/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 462
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  int8_t yy47;
  EOperatorType yy128;
  EJoinType yy288;
  SNodeList* yy376;
  SNode* yy476;
  int32_t yy508;
  SDataType yy532;
  EOrder yy554;
  EFillMode yy690;
  ENullOrder yy697;
  SToken yy701;
  bool yy845;
  SAlterOption yy893;
  int64_t yy921;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             724
#define YYNRULE              548
#define YYNRULE_WITH_ACTION  548
#define YYNTOKEN             326
#define YY_MAX_SHIFT         723
#define YY_MIN_SHIFTREDUCE   1071
#define YY_MAX_SHIFTREDUCE   1618
#define YY_ERROR_ACTION      1619
#define YY_ACCEPT_ACTION     1620
#define YY_NO_ACTION         1621
#define YY_MIN_REDUCE        1622
#define YY_MAX_REDUCE        2169
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2895)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1766, 1764,  372, 1892,  578, 1821, 1823,  467, 2140,  468,
 /*    10 */  1658, 1966,   45,   43, 1548, 1970, 1890,  600,  232, 2001,
 /*    20 */   367, 1805, 1398,  577,  178,  612, 1966,  572, 2141,  579,
 /*    30 */   103,  590,  172, 1478,  466, 1396, 1691,  471, 1664, 1552,
 /*    40 */  1962, 1968,   38,   37,  138, 1423,   44,   42,   41,   40,
 /*    50 */    39,  623, 1767,  339, 1877, 1962, 1968,  349, 1473,  163,
 /*    60 */     8, 2145,  137,   18, 1729, 2140,  623,  571,  119, 1983,
 /*    70 */  1404,  118,  117,  116,  115,  114,  113,  112,  111,  110,
 /*    80 */  1828, 2144,  359,   45,   43, 2141, 2143,  336,  473, 1104,
 /*    90 */   160,  367,  612, 1398,  469,   14, 1826,  332,  174, 1777,
 /*   100 */  2001,  521,  520,  519, 1478,  590, 1396,  160,  593,  134,
 /*   110 */   515, 1815, 1488, 1952,  514,  629, 1778,  720, 1423,  513,
 /*   120 */   518,  592,  176, 2079, 2080,  512,  135, 2084, 1106, 1473,
 /*   130 */  1109, 1110, 1480, 1481,   18,  612,  137, 1753, 1507, 1982,
 /*   140 */   485, 1404, 1123, 2018, 1122,  190,  106, 1984,  633, 1986,
 /*   150 */  1987,  628,  578,  623,   60, 2145, 2140,  215,  175, 2140,
 /*   160 */  2071, 1407, 1453, 1463,  361, 2067,   14,   48, 1479, 1482,
 /*   170 */   665,  577,  178, 1124, 1423, 2144, 2141,  579,  180, 2141,
 /*   180 */  2142,   81,  573, 1399,   80, 1397, 2097, 1454,  720,  151,
 /*   190 */   150,  662,  661,  660,  148, 1508,  177, 2079, 2080,  485,
 /*   200 */   135, 2084,  475, 1480, 1481,  471, 1664,  263, 1402, 1403,
 /*   210 */    48, 1452, 1455, 1456, 1457, 1458, 1459, 1460, 1461, 1462,
 /*   220 */   625,  621, 1471, 1472, 1474, 1475, 1476, 1477,    2,  521,
 /*   230 */   520,  519,  139, 1453, 1463, 2042,  568,  134,  515, 1479,
 /*   240 */  1482,  405,  514,  404,   60, 1423,   89,  513,  518,   60,
 /*   250 */   230,   35,  280,  512, 1399,   64, 1397,   38,   37, 1424,
 /*   260 */  1454,   44,   42,   41,   40,   39, 1541,   34,  365, 1502,
 /*   270 */  1503, 1504, 1505, 1506, 1510, 1511, 1512, 1513, 1424, 1402,
 /*   280 */  1403,   84, 1452, 1455, 1456, 1457, 1458, 1459, 1460, 1461,
 /*   290 */  1462,  625,  621, 1471, 1472, 1474, 1475, 1476, 1477,    2,
 /*   300 */  1828,   11,   45,   43, 1771,  181,  590,  355, 1751,   60,
 /*   310 */   367, 1410, 1398,   86,  327,  667, 1826,  539,  590,  537,
 /*   320 */   574,  569,  563, 1478, 1620, 1396, 1230,  655,  654,  653,
 /*   330 */  1234,  652, 1236, 1237,  651, 1239,  648,  137, 1245,  645,
 /*   340 */  1247, 1248,  642,  639,  216, 1645,   60,  412, 1473,  137,
 /*   350 */    38,   37, 1971,   18,   44,   42,   41,   40,   39,  167,
 /*   360 */  1404,  181, 1644, 1966,  149,  502,  498,  494,  490,  213,
 /*   370 */   667, 1273, 1274,   45,   43, 1483,   44,   42,   41,   40,
 /*   380 */    39,  367,  162, 1398, 1634,   14,   27,  322,  382, 1952,
 /*   390 */  1343, 1344, 1962, 1968, 1478,  181, 1396,  179, 2079, 2080,
 /*   400 */   181,  135, 2084,  623,  613,   85, 1952,  720,  211,  260,
 /*   410 */  2079,  589, 1828,  130,  588, 1623,   53, 2140,  129, 1473,
 /*   420 */  1822, 1823, 1480, 1481, 1615,  506, 1342, 1345, 1827,  231,
 /*   430 */   554, 1404,  577,  178, 2140, 1775,  119, 2141,  579,  118,
 /*   440 */   117,  116,  115,  114,  113,  112,  111,  110, 1643, 2146,
 /*   450 */   178, 1892, 1453, 1463, 2141,  579,   46,   84, 1479, 1482,
 /*   460 */   181,  358,   38,   37, 1889,  600,   44,   42,   41,   40,
 /*   470 */    39,  133,  413, 1399, 1426, 1397,  210,  204,  720, 1422,
 /*   480 */  1770,  209,   38,   37,  481,  414,   44,   42,   41,   40,
 /*   490 */    39, 1190, 1952, 1480, 1481, 1375, 1376,  181, 1402, 1403,
 /*   500 */   202, 1452, 1455, 1456, 1457, 1458, 1459, 1460, 1461, 1462,
 /*   510 */   625,  621, 1471, 1472, 1474, 1475, 1476, 1477,    2, 1614,
 /*   520 */  1642,  723,  658, 1453, 1463,  476, 1192,  468, 1658, 1479,
 /*   530 */  1482,  613,   38,   37,  450,  287,   44,   42,   41,   40,
 /*   540 */    39,   49,  517,  516, 1399,   54, 1397,   38,   37, 1425,
 /*   550 */   171,   44,   42,   41,   40,   39,  713,  709,  705,  701,
 /*   560 */   285, 1858, 1775, 1983, 1952,   11, 1123, 1509, 1122, 1402,
 /*   570 */  1403, 1423, 1452, 1455, 1456, 1457, 1458, 1459, 1460, 1461,
 /*   580 */  1462,  625,  621, 1471, 1472, 1474, 1475, 1476, 1477,    2,
 /*   590 */    45,   43,  194,  193, 2001, 1404,  104, 1124,  367,  278,
 /*   600 */  1398,  679,  630,  613,   11, 1828,    9, 1952, 1752,  629,
 /*   610 */  1426, 1478,  360, 1396,  406,  449,   31,  183,  240, 1635,
 /*   620 */  1585, 1826,   38,   37, 1983, 2086,   44,   42,   41,   40,
 /*   630 */    39, 1760,  609, 1982, 1775, 1564, 1473, 2018,  159,   32,
 /*   640 */   106, 1984,  633, 1986, 1987,  628, 1970,  623, 1404, 1514,
 /*   650 */   140, 2083,  146, 2042, 2071, 2001,  554, 1966,  361, 2067,
 /*   660 */  2140,   45,   43,  630, 2086,  613,  370,  266, 1952,  367,
 /*   670 */   629, 1398,  265,   46,  160, 2146,  178, 1575, 1983,  410,
 /*   680 */  2141,  579, 1478, 1777, 1396, 1426, 1962, 1968,  362, 1369,
 /*   690 */  2082,  234,  181,  262, 1982,  720, 1775,  623, 2018, 2086,
 /*   700 */   582,  164, 1984,  633, 1986, 1987,  628, 1473,  623, 2001,
 /*   710 */  1480, 1481,  430, 1328, 1329,  665,  615,  630, 2043, 1404,
 /*   720 */  1641,  429, 1952, 1750,  629, 2081,  565, 1573, 1574, 1576,
 /*   730 */  1577,   97, 1398, 2145,  151,  150,  662,  661,  660,  148,
 /*   740 */  1453, 1463,  555, 2108,   14, 1396, 1479, 1482, 1982,  617,
 /*   750 */  1425, 2043, 2018, 1768,  187,  106, 1984,  633, 1986, 1987,
 /*   760 */   628, 1399,  623, 1397, 1952,   33,  720, 2160, 1762, 2071,
 /*   770 */   535,   38,   37,  361, 2067,   44,   42,   41,   40,   39,
 /*   780 */  1404, 1480, 1481,  533, 2105,  531, 1402, 1403,  172, 1452,
 /*   790 */  1455, 1456, 1457, 1458, 1459, 1460, 1461, 1462,  625,  621,
 /*   800 */  1471, 1472, 1474, 1475, 1476, 1477,    2,  613, 1873,  613,
 /*   810 */  1878, 1453, 1463,  325,  401, 1421,  373, 1479, 1482,  186,
 /*   820 */  1873,  411,  443,  145,  160,  457, 1608,  720,  456,  239,
 /*   830 */   665,  188, 1399, 1777, 1397,  403,  399, 1640, 1775, 1828,
 /*   840 */  1775, 1639, 1423,  426,  294,  458,  371, 1805,  428,  151,
 /*   850 */   150,  662,  661,  660,  148, 1826, 1545, 1402, 1403, 1758,
 /*   860 */  1452, 1455, 1456, 1457, 1458, 1459, 1460, 1461, 1462,  625,
 /*   870 */   621, 1471, 1472, 1474, 1475, 1476, 1477,    2,   41,   40,
 /*   880 */    39, 1952,  510,  161, 1622, 1952,  613, 1873,  300,  340,
 /*   890 */  1688,  613,   52, 1399,  262, 1397,  691,  689,  192,  553,
 /*   900 */   129,  416,  298,   70,  509,  420,   69,  511,  128,  127,
 /*   910 */   126,  125,  124,  123,  122,  121,  120, 1775, 1402, 1403,
 /*   920 */    13,   12, 1775,  583,  198,  463,  461,  659,  343,  663,
 /*   930 */  1819,  454, 1819, 2144,  448,  447,  446,  445,  442,  441,
 /*   940 */   440,  439,  438,  434,  433,  432,  431,  324,  423,  422,
 /*   950 */   421, 1638,  418,  417,  338,  697,  696,  695,  694,  377,
 /*   960 */    60,  693,  692,  141,  687,  686,  685,  684,  683,  682,
 /*   970 */   681,  153,  677,  676,  675,  376,  375,  672,  671,  670,
 /*   980 */   669,  668,  613, 1637, 1454,  526, 1109, 1110, 1636,  344,
 /*   990 */   613,  342,  341, 1633,  508, 1952,  435,  613,  510,  105,
 /*  1000 */   536,   38,   37, 1665,  436,   44,   42,   41,   40,   39,
 /*  1010 */  1632,  483, 1983, 1775,  229, 1521,  613,  613,  596,  613,
 /*  1020 */   509, 1775,  613,  680,  613, 1745,  549, 1952, 1775,  529,
 /*  1030 */   484, 1772, 1952,  550,  523, 1939,  594, 1952,  598,  228,
 /*  1040 */    78,   77,  409, 2001, 1730,  185,  664, 1775, 1775, 1819,
 /*  1050 */  1775,  593,  715, 1775, 1952, 1775, 1952,   50,  629,    3,
 /*  1060 */   554,  585, 1631,  323, 2140,  143,  397,  131,  395,  391,
 /*  1070 */   387,  384,  381,  613, 1983,   67, 2091, 1541,   66, 2146,
 /*  1080 */   178,  613, 1982,  389, 2141,  579, 2018,  599,  613,  106,
 /*  1090 */  1984,  633, 1986, 1987,  628,  275,  623, 1983,  238, 1544,
 /*  1100 */    71,  175,  608, 2071, 1775, 2001, 1952,  361, 2067,  613,
 /*  1110 */  1678,  181, 1775,  630,  235, 1630,  613, 1629, 1952, 1775,
 /*  1120 */   629,  271,  272,  610,  221,  624,  270,  219, 2001, 2098,
 /*  1130 */   611,  613,  522, 1617, 1618,  613,  630,   87,  620, 1628,
 /*  1140 */  1775, 1952,  657,  629, 1982,  281, 1671, 1775, 2018,  374,
 /*  1150 */    79,  106, 1984,  633, 1986, 1987,  628, 1627,  623, 1952,
 /*  1160 */  1669, 1952, 1775, 2160,  380, 2071, 1775, 1982,  524,  361,
 /*  1170 */  2067, 2018,  379, 1983,  106, 1984,  633, 1986, 1987,  628,
 /*  1180 */  2118,  623,  527, 1952, 1626, 1625, 2160, 1406, 2071,   62,
 /*  1190 */   364,  363,  361, 2067,  223,  581, 1983,  222, 2111,  225,
 /*  1200 */  1412, 1952,  224,  561, 2001,  227,  554,  257,  226,  244,
 /*  1210 */  2140, 1478,  630, 1405,  554,  566,  214, 1952, 2140,  629,
 /*  1220 */   149,   13,   12,  251,  378, 2146,  178, 2001, 1952, 1952,
 /*  1230 */  2141,  579,   47, 2146,  178,  630, 1473,   47, 2141,  579,
 /*  1240 */  1952, 1572,  629, 1982, 1882,  268,   68, 2018, 1404, 2002,
 /*  1250 */   106, 1984,  633, 1986, 1987,  628,  147,  623,  149,  542,
 /*  1260 */   673,  246, 2160,   62, 2071, 1983, 1982, 1659,  361, 2067,
 /*  1270 */  2018,   47,  597,  106, 1984,  633, 1986, 1987,  628, 2134,
 /*  1280 */   623, 1973, 1171, 1499, 1464, 2160,  586, 2071, 1983, 1340,
 /*  1290 */   674,  361, 2067, 1152, 1816,  619, 2001,  273,  605, 2101,
 /*  1300 */   637,  554, 2090,  147,  627, 2140,  102,  149,  277, 1952,
 /*  1310 */  1223,  629, 1169,  591,  256, 1515,   99,    1,    4, 2001,
 /*  1320 */  2146,  178,  132,  293,  147, 2141,  579,  630, 1153, 1975,
 /*  1330 */   383,  259, 1952,  388,  629, 1982, 1362, 1409,  337, 2018,
 /*  1340 */   288,  191,  316, 1984,  633, 1986, 1987,  628,  626,  623,
 /*  1350 */   614, 2036, 1251,  415, 1426, 1255,  419, 1883, 1982, 1262,
 /*  1360 */   452, 1413, 2018, 1408,  424,  106, 1984,  633, 1986, 1987,
 /*  1370 */   628, 1421,  623,  437, 1260, 1983,  152, 2046, 1875, 2071,
 /*  1380 */   444,  459,  451,  361, 2067,  453, 1416, 1418,  460,  195,
 /*  1390 */   462,  464, 1427,  465,  474, 1429, 1424,  478, 1983,  621,
 /*  1400 */  1471, 1472, 1474, 1475, 1476, 1477, 2001,  477,  201,  203,
 /*  1410 */  1428,  479, 1430,  486,  630,  480,  482,  206, 1126, 1952,
 /*  1420 */   208,  629,   82,   83,  212,  503,  504,  505,  507, 2001,
 /*  1430 */   109, 1765,  218, 1929,  326,  541,  543,  630,  289,  544,
 /*  1440 */  1928,  551, 1952, 1761,  629, 1982,  233,  220,  154, 2018,
 /*  1450 */   155, 1763,  106, 1984,  633, 1986, 1987,  628, 1759,  623,
 /*  1460 */   236,  156,  157,  567, 2044, 2102, 2071,  548, 1982, 2117,
 /*  1470 */   361, 2067, 2018, 1983, 2116,  106, 1984,  633, 1986, 1987,
 /*  1480 */   628,  558,  623,  603,  545,  242,  564,  616,  350, 2071,
 /*  1490 */  2112,  570,    7,  361, 2067,  245, 2093,  576,  168,  250,
 /*  1500 */  1983,  556,  252,  559, 2001,  557,  351, 1541, 2163,  587,
 /*  1510 */   584,  258,  630,  255, 2139,  136, 1425, 1952,  595,  629,
 /*  1520 */   354, 2087,  290,  601,  253,  264,   92,  602,  291, 1900,
 /*  1530 */  1899, 2001, 1898,  254,  357,  606,   94,  607,   96,  630,
 /*  1540 */  1776,   59,  292, 1982, 1952, 2052,  629, 2018,   98,  716,
 /*  1550 */   107, 1984,  633, 1986, 1987,  628,  635,  623, 1746,  295,
 /*  1560 */  1820,  717,  284,  719, 2071,  319, 1983,   51, 2070, 2067,
 /*  1570 */  1982,  304,  318,  299, 2018,  297,  328,  107, 1984,  633,
 /*  1580 */  1986, 1987,  628,  329,  623,  308, 1946, 1945,   75, 1944,
 /*  1590 */  1943, 2071,   76, 1940,  385,  618, 2067, 2001,  386, 1390,
 /*  1600 */  1391,  184,  390, 1938,  392,  630,  393,  394, 1937,  396,
 /*  1610 */  1952, 1936,  629,  398, 1935, 1934,  400,  402, 1365, 1364,
 /*  1620 */  1911, 1983, 1910,  407, 1909,  408, 1908, 1319, 1866, 1865,
 /*  1630 */  1863, 1862, 1861,  142, 1864, 1860,  631, 1859, 1857, 1983,
 /*  1640 */  2018, 1856, 1855,  107, 1984,  633, 1986, 1987,  628,  189,
 /*  1650 */   623,  425, 2001, 1854,  427, 1868, 1853, 2071, 1852, 1851,
 /*  1660 */   630,  331, 2067, 1850, 1849, 1952, 1848,  629, 1321,  144,
 /*  1670 */  2001, 1847, 1846, 1845, 1844, 1843, 1842, 1841,  630, 1840,
 /*  1680 */  1839, 1838, 1837, 1952,  455,  629, 1836, 1867, 1835, 1834,
 /*  1690 */  1833, 1982, 1832, 1983, 1831, 2018, 1830, 1829,  165, 1984,
 /*  1700 */   633, 1986, 1987,  628, 1198,  623, 1693,  196, 1692, 1982,
 /*  1710 */   197, 1690, 1654, 2018, 1983, 1112,  107, 1984,  633, 1986,
 /*  1720 */  1987,  628,  173,  623, 2001,  199, 1653, 1111, 1924, 1918,
 /*  1730 */  2071, 1907,  630, 1906,   73, 2068,  207, 1952, 1972,  629,
 /*  1740 */   470, 1886,  200,   74,  205, 2001,  472, 1754, 1689, 1145,
 /*  1750 */   580, 2161, 1687,  630,  487,  488,  489, 1685, 1952,  491,
 /*  1760 */   629,  493,  492, 1982, 1683,  495,  496, 2018, 1681,  499,
 /*  1770 */   164, 1984,  633, 1986, 1987,  628,  497,  623,  501, 1983,
 /*  1780 */   500, 1668, 1667, 1650, 1982, 1756, 1267, 1266, 2018, 1755,
 /*  1790 */  1189,  310, 1984,  633, 1986, 1987,  628, 1188,  623, 1181,
 /*  1800 */  1983, 1187,   61, 1679, 1186,  217, 1183,  688, 1182, 1180,
 /*  1810 */  2001,  690, 2109,  345, 1672,  346, 1670,  347,  630,  528,
 /*  1820 */   525, 1649,  530, 1952, 1648,  629, 1647,  532,  534,  108,
 /*  1830 */    26, 2001, 1380, 1379,  538,  575,  356, 1923, 1382,  630,
 /*  1840 */  1371, 1917,  546,  158, 1952, 1905,  629, 1903,   19, 1982,
 /*  1850 */    16, 2145, 1587, 2018,  560,   28,  165, 1984,  633, 1986,
 /*  1860 */  1987,  628,   58,  623,   55,   63,  562,  241,   20, 1983,
 /*  1870 */  1982,  243, 1571,  547, 2018,  166,  237,  317, 1984,  633,
 /*  1880 */  1986, 1987,  628,  247,  623,  348,    5, 1983,  552,   29,
 /*  1890 */   248,    6, 1563,   17,   88,   30,  249, 1973, 1607,   21,
 /*  1900 */  2001, 1602, 1601, 1608,  352, 1606, 1605,  353,  627, 2162,
 /*  1910 */   261, 1538,   57, 1952,   56,  629, 1904, 1902, 2001, 1537,
 /*  1920 */   169, 1901, 1885,  366,   90,   91,  630,  267,   22, 1884,
 /*  1930 */  1569, 1952,   93,  629,  269,  274,  279,   65,   95, 1982,
 /*  1940 */    99,   23, 1983, 2018,  276,  604,  316, 1984,  633, 1986,
 /*  1950 */  1987,  628, 1490,  623,   12, 2037,   10, 1982, 1414, 2021,
 /*  1960 */   622, 2018, 1500, 1445,  317, 1984,  633, 1986, 1987,  628,
 /*  1970 */  1468,  623, 1489, 2001, 1466,   36, 1244, 1465,  368,  170,
 /*  1980 */    15,  630,   24,   25,  182,  634, 1952, 1437,  629,  636,
 /*  1990 */  1252,  369, 1249,  638,  640,  641,  632, 1983, 1246,  643,
 /*  2000 */   644,  646, 1240,  647,  649, 1238,  650, 1229,  100, 1243,
 /*  2010 */   656, 1242, 1982, 1983, 1241,  282, 2018, 1261,  101,  317,
 /*  2020 */  1984,  633, 1986, 1987,  628,   72,  623, 1257, 2001, 1143,
 /*  2030 */   666, 1177, 1176, 1175, 1174, 1173,  630, 1172, 1170, 1168,
 /*  2040 */  1196, 1952, 1167,  629, 2001, 1166, 1164,  678, 1163, 1162,
 /*  2050 */   283, 1160,  630, 1161, 1159, 1158, 1193, 1952, 1191,  629,
 /*  2060 */  1155, 1154, 1151, 1150, 1149, 1983, 1686,  540, 1148,  698,
 /*  2070 */   699, 2018, 1684,  702,  312, 1984,  633, 1986, 1987,  628,
 /*  2080 */   700,  623,  704, 1982,  703, 1682,  706, 2018, 1983, 1680,
 /*  2090 */   301, 1984,  633, 1986, 1987,  628, 2001,  623,  707,  708,
 /*  2100 */   710,  711,  712, 1666,  630,  714, 1101, 1646,  286, 1952,
 /*  2110 */  1400,  629,  718,  722,  296,  721, 1621, 1621, 1621, 2001,
 /*  2120 */  1621, 1621, 1621, 1621, 1621, 1621, 1621,  630, 1621, 1621,
 /*  2130 */  1621, 1621, 1952, 1621,  629, 1982, 1621, 1621, 1621, 2018,
 /*  2140 */  1983, 1621,  302, 1984,  633, 1986, 1987,  628, 1621,  623,
 /*  2150 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1982, 1621,
 /*  2160 */  1621, 1983, 2018, 1621, 1621,  303, 1984,  633, 1986, 1987,
 /*  2170 */   628, 2001,  623, 1621, 1621, 1621, 1621, 1621, 1621,  630,
 /*  2180 */  1621, 1621, 1621, 1621, 1952, 1621,  629, 1621, 1621, 1621,
 /*  2190 */  1621, 1621, 2001, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*  2200 */   630, 1621, 1621, 1621, 1621, 1952, 1621,  629, 1621, 1621,
 /*  2210 */  1982, 1621, 1621, 1621, 2018, 1621, 1621,  309, 1984,  633,
 /*  2220 */  1986, 1987,  628, 1621,  623, 1621, 1621, 1621, 1621, 1621,
 /*  2230 */  1983, 1982, 1621, 1621, 1621, 2018, 1621, 1621,  313, 1984,
 /*  2240 */   633, 1986, 1987,  628, 1621,  623, 1621, 1621, 1983, 1621,
 /*  2250 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*  2260 */  1621, 2001, 1621, 1621, 1621, 1621, 1621, 1621, 1621,  630,
 /*  2270 */  1621, 1621, 1621, 1621, 1952, 1621,  629, 1621, 1621, 2001,
 /*  2280 */  1621, 1621, 1621, 1621, 1621, 1621, 1621,  630, 1621, 1621,
 /*  2290 */  1621, 1621, 1952, 1621,  629, 1621, 1621, 1621, 1621, 1621,
 /*  2300 */  1982, 1621, 1621, 1983, 2018, 1621, 1621,  305, 1984,  633,
 /*  2310 */  1986, 1987,  628, 1621,  623, 1621, 1621, 1621, 1982, 1621,
 /*  2320 */  1621, 1621, 2018, 1621, 1621,  314, 1984,  633, 1986, 1987,
 /*  2330 */   628, 1621,  623, 1621, 2001, 1621, 1621, 1621, 1621, 1621,
 /*  2340 */  1621, 1621,  630, 1621, 1621, 1621, 1621, 1952, 1621,  629,
 /*  2350 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1983, 1621,
 /*  2360 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*  2370 */  1621, 1621, 1621, 1982, 1983, 1621, 1621, 2018, 1621, 1621,
 /*  2380 */   306, 1984,  633, 1986, 1987,  628, 1621,  623, 1621, 2001,
 /*  2390 */  1621, 1621, 1621, 1621, 1621, 1621, 1621,  630, 1621, 1621,
 /*  2400 */  1621, 1621, 1952, 1621,  629, 2001, 1621, 1621, 1621, 1621,
 /*  2410 */  1621, 1621, 1621,  630, 1621, 1621, 1621, 1621, 1952, 1621,
 /*  2420 */   629, 1621, 1621, 1621, 1621, 1621, 1983, 1621, 1982, 1621,
 /*  2430 */  1621, 1621, 2018, 1621, 1621,  315, 1984,  633, 1986, 1987,
 /*  2440 */   628, 1621,  623, 1621, 1982, 1621, 1621, 1621, 2018, 1983,
 /*  2450 */  1621,  307, 1984,  633, 1986, 1987,  628, 2001,  623, 1621,
 /*  2460 */  1621, 1621, 1621, 1621, 1621,  630, 1621, 1621, 1621, 1621,
 /*  2470 */  1952, 1621,  629, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*  2480 */  2001, 1621, 1621, 1621, 1621, 1621, 1621, 1621,  630, 1621,
 /*  2490 */  1621, 1621, 1621, 1952, 1621,  629, 1982, 1621, 1621, 1621,
 /*  2500 */  2018, 1983, 1621,  320, 1984,  633, 1986, 1987,  628, 1621,
 /*  2510 */   623, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1982,
 /*  2520 */  1621, 1621, 1983, 2018, 1621, 1621,  321, 1984,  633, 1986,
 /*  2530 */  1987,  628, 2001,  623, 1621, 1621, 1621, 1621, 1621, 1621,
 /*  2540 */   630, 1621, 1621, 1621, 1621, 1952, 1621,  629, 1621, 1621,
 /*  2550 */  1621, 1621, 1621, 2001, 1621, 1621, 1621, 1621, 1621, 1621,
 /*  2560 */  1621,  630, 1621, 1621, 1621, 1621, 1952, 1621,  629, 1621,
 /*  2570 */  1621, 1982, 1621, 1621, 1621, 2018, 1621, 1621, 1995, 1984,
 /*  2580 */   633, 1986, 1987,  628, 1621,  623, 1621, 1621, 1621, 1621,
 /*  2590 */  1621, 1983, 1982, 1621, 1621, 1621, 2018, 1621, 1621, 1994,
 /*  2600 */  1984,  633, 1986, 1987,  628, 1621,  623, 1621, 1621, 1983,
 /*  2610 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*  2620 */  1621, 1621, 2001, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*  2630 */   630, 1621, 1621, 1621, 1621, 1952, 1621,  629, 1621, 1621,
 /*  2640 */  2001, 1621, 1621, 1621, 1621, 1621, 1621, 1621,  630, 1621,
 /*  2650 */  1621, 1621, 1621, 1952, 1621,  629, 1621, 1621, 1621, 1621,
 /*  2660 */  1621, 1982, 1621, 1621, 1983, 2018, 1621, 1621, 1993, 1984,
 /*  2670 */   633, 1986, 1987,  628, 1621,  623, 1621, 1621, 1621, 1982,
 /*  2680 */  1621, 1621, 1621, 2018, 1621, 1621,  333, 1984,  633, 1986,
 /*  2690 */  1987,  628, 1621,  623, 1621, 2001, 1621, 1621, 1621, 1621,
 /*  2700 */  1621, 1621, 1621,  630, 1621, 1621, 1621, 1621, 1952, 1621,
 /*  2710 */   629, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1983,
 /*  2720 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*  2730 */  1621, 1621, 1621, 1621, 1982, 1983, 1621, 1621, 2018, 1621,
 /*  2740 */  1621,  334, 1984,  633, 1986, 1987,  628, 1621,  623, 1621,
 /*  2750 */  2001, 1621, 1621, 1621, 1621, 1621, 1621, 1621,  630, 1621,
 /*  2760 */  1621, 1621, 1621, 1952, 1621,  629, 2001, 1621, 1621, 1621,
 /*  2770 */  1621, 1621, 1621, 1621,  630, 1621, 1621, 1621, 1621, 1952,
 /*  2780 */  1621,  629, 1621, 1621, 1621, 1621, 1621, 1983, 1621, 1982,
 /*  2790 */  1621, 1621, 1621, 2018, 1621, 1621,  330, 1984,  633, 1986,
 /*  2800 */  1987,  628, 1621,  623, 1621, 1982, 1621, 1621, 1621, 2018,
 /*  2810 */  1983, 1621,  335, 1984,  633, 1986, 1987,  628, 2001,  623,
 /*  2820 */  1621, 1621, 1621, 1621, 1621, 1621,  630, 1621, 1621, 1621,
 /*  2830 */  1621, 1952, 1621,  629, 1621, 1621, 1621, 1621, 1621, 1621,
 /*  2840 */  1621, 2001, 1621, 1621, 1621, 1621, 1621, 1621, 1621,  630,
 /*  2850 */  1621, 1621, 1621, 1621, 1952, 1621,  629,  631, 1621, 1621,
 /*  2860 */  1621, 2018, 1621, 1621,  312, 1984,  633, 1986, 1987,  628,
 /*  2870 */  1621,  623, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*  2880 */  1982, 1621, 1621, 1621, 2018, 1621, 1621,  311, 1984,  633,
 /*  2890 */  1986, 1987,  628, 1621,  623,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   362,  361,  371,  375,  432,  374,  375,  333,  436,  335,
 /*    10 */   336,  373,   12,   13,   14,  362,  388,  389,  353,  360,
 /*    20 */    20,  356,   22,  451,  452,   20,  373,  368,  456,  457,
 /*    30 */   341,  337,  360,   33,  334,   35,    0,  337,  338,   14,
 /*    40 */   402,  403,    8,    9,  355,   20,   12,   13,   14,   15,
 /*    50 */    16,  413,  363,  381,  382,  402,  403,  404,   58,  344,
 /*    60 */    39,  432,  368,   63,  349,  436,  413,  408,   21,  329,
 /*    70 */    70,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*    80 */   360,  452,  352,   12,   13,  456,  457,  367,   14,    4,
 /*    90 */   360,   20,   20,   22,   20,   95,  376,   63,  359,  369,
 /*   100 */   360,   65,   66,   67,   33,  337,   35,  360,  368,   73,
 /*   110 */    74,  372,   14,  373,   78,  375,  369,  117,   20,   83,
 /*   120 */    84,  427,  428,  429,  430,   89,  432,  433,   43,   58,
 /*   130 */    45,   46,  132,  133,   63,   20,  368,    0,  104,  399,
 /*   140 */    62,   70,   20,  403,   22,   58,  406,  407,  408,  409,
 /*   150 */   410,  411,  432,  413,   95,  432,  436,   35,  418,  436,
 /*   160 */   420,   35,  162,  163,  424,  425,   95,   95,  168,  169,
 /*   170 */   107,  451,  452,   51,   20,  452,  456,  457,  438,  456,
 /*   180 */   457,   94,   20,  183,   97,  185,  446,  162,  117,  126,
 /*   190 */   127,  128,  129,  130,  131,  161,  428,  429,  430,   62,
 /*   200 */   432,  433,  334,  132,  133,  337,  338,   58,  208,  209,
 /*   210 */    95,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,   65,
 /*   230 */    66,   67,  416,  162,  163,  419,  167,   73,   74,  168,
 /*   240 */   169,  182,   78,  184,   95,   20,   97,   83,   84,   95,
 /*   250 */   127,  421,  422,   89,  183,    4,  185,    8,    9,   20,
 /*   260 */   162,   12,   13,   14,   15,   16,  245,  233,  234,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,  242,  243,   20,  208,
 /*   280 */   209,  343,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   290 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*   300 */   360,  230,   12,   13,  366,  246,  337,  367,    0,   95,
 /*   310 */    20,  185,   22,  190,  191,   62,  376,  194,  337,  196,
 /*   320 */   251,  252,  253,   33,  326,   35,  108,  109,  110,  111,
 /*   330 */   112,  113,  114,  115,  116,  117,  118,  368,  120,  121,
 /*   340 */   122,  123,  124,  125,   33,  329,   95,  337,   58,  368,
 /*   350 */     8,    9,  362,   63,   12,   13,   14,   15,   16,   48,
 /*   360 */    70,  246,  329,  373,   44,   54,   55,   56,   57,   58,
 /*   370 */    62,  132,  133,   12,   13,   14,   12,   13,   14,   15,
 /*   380 */    16,   20,  328,   22,  330,   95,   44,  377,  390,  373,
 /*   390 */   132,  133,  402,  403,   33,  246,   35,  428,  429,  430,
 /*   400 */   246,  432,  433,  413,  337,   94,  373,  117,   97,  428,
 /*   410 */   429,  430,  360,  432,  433,    0,   96,  436,  351,   58,
 /*   420 */   374,  375,  132,  133,  175,  358,  168,  169,  376,  126,
 /*   430 */   432,   70,  451,  452,  436,  368,   21,  456,  457,   24,
 /*   440 */    25,   26,   27,   28,   29,   30,   31,   32,  329,  451,
 /*   450 */   452,  375,  162,  163,  456,  457,   95,  343,  168,  169,
 /*   460 */   246,  385,    8,    9,  388,  389,   12,   13,   14,   15,
 /*   470 */    16,  357,   22,  183,   20,  185,  165,  166,  117,   20,
 /*   480 */   366,  170,    8,    9,  173,   35,   12,   13,   14,   15,
 /*   490 */    16,   35,  373,  132,  133,  192,  193,  246,  208,  209,
 /*   500 */   189,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   510 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  270,
 /*   520 */   329,   19,  106,  162,  163,  333,   70,  335,  336,  168,
 /*   530 */   169,  337,    8,    9,   79,   33,   12,   13,   14,   15,
 /*   540 */    16,   95,  346,  347,  183,  351,  185,    8,    9,   20,
 /*   550 */    48,   12,   13,   14,   15,   16,   54,   55,   56,   57,
 /*   560 */    58,    0,  368,  329,  373,  230,   20,  161,   22,  208,
 /*   570 */   209,   20,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   580 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*   590 */    12,   13,  137,  138,  360,   70,   94,   51,   20,   97,
 /*   600 */    22,   70,  368,  337,  230,  360,  232,  373,    0,  375,
 /*   610 */    20,   33,  367,   35,  390,  160,    2,  351,  164,  330,
 /*   620 */    96,  376,    8,    9,  329,  405,   12,   13,   14,   15,
 /*   630 */    16,  361,  130,  399,  368,   96,   58,  403,  164,  233,
 /*   640 */   406,  407,  408,  409,  410,  411,  362,  413,   70,  243,
 /*   650 */   416,  431,  418,  419,  420,  360,  432,  373,  424,  425,
 /*   660 */   436,   12,   13,  368,  405,  337,  352,  165,  373,   20,
 /*   670 */   375,   22,  170,   95,  360,  451,  452,  208,  329,  351,
 /*   680 */   456,  457,   33,  369,   35,   20,  402,  403,  404,  187,
 /*   690 */   431,  189,  246,  164,  399,  117,  368,  413,  403,  405,
 /*   700 */    44,  406,  407,  408,  409,  410,  411,   58,  413,  360,
 /*   710 */   132,  133,  151,  162,  163,  107,  417,  368,  419,   70,
 /*   720 */   329,  160,  373,    0,  375,  431,  257,  258,  259,  260,
 /*   730 */   261,  341,   22,    3,  126,  127,  128,  129,  130,  131,
 /*   740 */   162,  163,  447,  448,   95,   35,  168,  169,  399,  417,
 /*   750 */    20,  419,  403,  363,  164,  406,  407,  408,  409,  410,
 /*   760 */   411,  183,  413,  185,  373,    2,  117,  418,  361,  420,
 /*   770 */    21,    8,    9,  424,  425,   12,   13,   14,   15,   16,
 /*   780 */    70,  132,  133,   34,  435,   36,  208,  209,  360,  211,
 /*   790 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   800 */   222,  223,  224,  225,  226,  227,  228,  337,  368,  337,
 /*   810 */   382,  162,  163,   18,  178,   20,  352,  168,  169,  379,
 /*   820 */   368,  351,   27,  351,  360,   30,   96,  117,   33,  164,
 /*   830 */   107,  379,  183,  369,  185,  199,  200,  329,  368,  360,
 /*   840 */   368,  329,   20,   48,  353,   50,  367,  356,   53,  126,
 /*   850 */   127,  128,  129,  130,  131,  376,    4,  208,  209,  361,
 /*   860 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   870 */   221,  222,  223,  224,  225,  226,  227,  228,   14,   15,
 /*   880 */    16,  373,  107,   18,    0,  373,  337,  368,   23,   94,
 /*   890 */     0,  337,  164,  183,  164,  185,  346,  347,  379,  171,
 /*   900 */   351,  106,   37,   38,  129,  351,   41,  358,   24,   25,
 /*   910 */    26,   27,   28,   29,   30,   31,   32,  368,  208,  209,
 /*   920 */     1,    2,  368,  267,   59,   60,   61,  370,   37,  370,
 /*   930 */   373,  136,  373,    3,  139,  140,  141,  142,  143,  144,
 /*   940 */   145,  146,  147,  148,  149,  150,  151,  152,  153,  154,
 /*   950 */   155,  329,  157,  158,  159,   65,   66,   67,   68,   69,
 /*   960 */    95,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   970 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   980 */    90,   91,  337,  329,  162,    4,   45,   46,  329,   98,
 /*   990 */   337,  100,  101,  329,  103,  373,  351,  337,  107,  134,
 /*  1000 */    19,    8,    9,    0,  351,   12,   13,   14,   15,   16,
 /*  1010 */   329,  351,  329,  368,   33,   96,  337,  337,  390,  337,
 /*  1020 */   129,  368,  337,  348,  337,  350,  394,  373,  368,   48,
 /*  1030 */   351,  351,  373,  351,   53,    0,  351,  373,  351,   58,
 /*  1040 */   175,  176,  177,  360,  349,  180,  370,  368,  368,  373,
 /*  1050 */   368,  368,   49,  368,  373,  368,  373,   42,  375,   44,
 /*  1060 */   432,   44,  329,  198,  436,   42,  201,   44,  203,  204,
 /*  1070 */   205,  206,  207,  337,  329,   94,  244,  245,   97,  451,
 /*  1080 */   452,  337,  399,   48,  456,  457,  403,  351,  337,  406,
 /*  1090 */   407,  408,  409,  410,  411,  351,  413,  329,   58,  247,
 /*  1100 */   106,  418,  351,  420,  368,  360,  373,  424,  425,  337,
 /*  1110 */     0,  246,  368,  368,  361,  329,  337,  329,  373,  368,
 /*  1120 */   375,  126,  127,  351,   99,  361,  131,  102,  360,  446,
 /*  1130 */   351,  337,   22,  132,  133,  337,  368,   97,   63,  329,
 /*  1140 */   368,  373,  361,  375,  399,  351,    0,  368,  403,  351,
 /*  1150 */   156,  406,  407,  408,  409,  410,  411,  329,  413,  373,
 /*  1160 */     0,  373,  368,  418,  390,  420,  368,  399,   22,  424,
 /*  1170 */   425,  403,  390,  329,  406,  407,  408,  409,  410,  411,
 /*  1180 */   435,  413,   22,  373,  329,  329,  418,   35,  420,   44,
 /*  1190 */    12,   13,  424,  425,   99,  265,  329,  102,  383,   99,
 /*  1200 */    22,  373,  102,  435,  360,   99,  432,  460,  102,   44,
 /*  1210 */   436,   33,  368,   35,  432,  449,  339,  373,  436,  375,
 /*  1220 */    44,    1,    2,  443,  339,  451,  452,  360,  373,  373,
 /*  1230 */   456,  457,   44,  451,  452,  368,   58,   44,  456,  457,
 /*  1240 */   373,   96,  375,  399,  383,   44,   44,  403,   70,  360,
 /*  1250 */   406,  407,  408,  409,  410,  411,   44,  413,   44,  390,
 /*  1260 */    13,   96,  418,   44,  420,  329,  399,  336,  424,  425,
 /*  1270 */   403,   44,   96,  406,  407,  408,  409,  410,  411,  435,
 /*  1280 */   413,   47,   35,  208,   96,  418,  269,  420,  329,   96,
 /*  1290 */    13,  424,  425,   35,  372,  117,  360,   96,   96,  383,
 /*  1300 */    44,  432,  435,   44,  368,  436,   95,   44,   96,  373,
 /*  1310 */    96,  375,   35,  434,  426,   96,  105,  437,  248,  360,
 /*  1320 */   451,  452,   44,   96,   44,  456,  457,  368,   70,   95,
 /*  1330 */   401,  453,  373,   48,  375,  399,  181,  185,  400,  403,
 /*  1340 */   392,   42,  406,  407,  408,  409,  410,  411,  412,  413,
 /*  1350 */   414,  415,   96,  380,   20,   96,  380,  383,  399,   96,
 /*  1360 */   161,  183,  403,  185,  378,  406,  407,  408,  409,  410,
 /*  1370 */   411,   20,  413,  337,   96,  329,   96,  418,  337,  420,
 /*  1380 */   380,   93,  378,  424,  425,  378,  208,  209,  345,  337,
 /*  1390 */   337,  337,   20,  331,  331,   20,   20,  375,  329,  221,
 /*  1400 */   222,  223,  224,  225,  226,  227,  360,  396,  343,  343,
 /*  1410 */    20,  338,   20,  337,  368,  391,  338,  343,   52,  373,
 /*  1420 */   343,  375,  343,  343,  343,  340,  340,  331,  360,  360,
 /*  1430 */   337,  360,  360,  373,  331,  197,  398,  368,  396,  188,
 /*  1440 */   373,  337,  373,  360,  375,  399,  341,  360,  360,  403,
 /*  1450 */   360,  360,  406,  407,  408,  409,  410,  411,  360,  413,
 /*  1460 */   341,  360,  360,  256,  418,  383,  420,  375,  399,  442,
 /*  1470 */   424,  425,  403,  329,  442,  406,  407,  408,  409,  410,
 /*  1480 */   411,  373,  413,  255,  395,  386,  373,  418,  373,  420,
 /*  1490 */   383,  373,  262,  424,  425,  386,  445,  174,  442,  444,
 /*  1500 */   329,  249,  441,  264,  360,  263,  271,  245,  461,  268,
 /*  1510 */   266,  454,  368,  401,  455,  368,   20,  373,  337,  375,
 /*  1520 */   338,  405,  386,  373,  440,  341,  341,  373,  386,  373,
 /*  1530 */   373,  360,  373,  439,  373,  166,  341,  384,  341,  368,
 /*  1540 */   368,   95,  356,  399,  373,  423,  375,  403,   95,   36,
 /*  1550 */   406,  407,  408,  409,  410,  411,  364,  413,  350,  337,
 /*  1560 */   373,  332,  341,  331,  420,  397,  329,  393,  424,  425,
 /*  1570 */   399,  354,  354,  327,  403,  342,  387,  406,  407,  408,
 /*  1580 */   409,  410,  411,  387,  413,  354,    0,    0,  190,    0,
 /*  1590 */     0,  420,   42,    0,   35,  424,  425,  360,  202,   35,
 /*  1600 */    35,   35,  202,    0,   35,  368,   35,  202,    0,  202,
 /*  1610 */   373,    0,  375,   35,    0,    0,   22,   35,  185,  183,
 /*  1620 */     0,  329,    0,  179,    0,  178,    0,   47,    0,    0,
 /*  1630 */     0,    0,    0,   42,    0,    0,  399,    0,    0,  329,
 /*  1640 */   403,    0,    0,  406,  407,  408,  409,  410,  411,  151,
 /*  1650 */   413,   35,  360,    0,  151,    0,    0,  420,    0,    0,
 /*  1660 */   368,  424,  425,    0,    0,  373,    0,  375,   22,   42,
 /*  1670 */   360,    0,    0,    0,    0,    0,    0,    0,  368,    0,
 /*  1680 */     0,    0,    0,  373,  135,  375,    0,    0,    0,    0,
 /*  1690 */     0,  399,    0,  329,    0,  403,    0,    0,  406,  407,
 /*  1700 */   408,  409,  410,  411,   35,  413,    0,   58,    0,  399,
 /*  1710 */    58,    0,    0,  403,  329,   14,  406,  407,  408,  409,
 /*  1720 */   410,  411,   44,  413,  360,   42,    0,   14,    0,    0,
 /*  1730 */   420,    0,  368,    0,   39,  425,  174,  373,   47,  375,
 /*  1740 */    47,    0,   40,   39,   39,  360,   47,    0,    0,   64,
 /*  1750 */   458,  459,    0,  368,   35,   48,   39,    0,  373,   35,
 /*  1760 */   375,   39,   48,  399,    0,   35,   48,  403,    0,   35,
 /*  1770 */   406,  407,  408,  409,  410,  411,   39,  413,   39,  329,
 /*  1780 */    48,    0,    0,    0,  399,    0,   35,   22,  403,    0,
 /*  1790 */    35,  406,  407,  408,  409,  410,  411,   35,  413,   22,
 /*  1800 */   329,   35,  104,    0,   35,  102,   35,   44,   35,   35,
 /*  1810 */   360,   44,  448,   22,    0,   22,    0,   22,  368,   35,
 /*  1820 */    50,    0,   35,  373,    0,  375,    0,   35,   22,   20,
 /*  1830 */    95,  360,   35,   35,  195,  450,  365,    0,   96,  368,
 /*  1840 */    35,    0,   22,  186,  373,    0,  375,    0,   44,  399,
 /*  1850 */   250,    3,   96,  403,  229,   95,  406,  407,  408,  409,
 /*  1860 */   410,  411,   44,  413,  164,    3,  254,   95,  250,  329,
 /*  1870 */   399,   96,   96,  164,  403,   95,  166,  406,  407,  408,
 /*  1880 */   409,  410,  411,   95,  413,  164,  171,  329,  172,   95,
 /*  1890 */    44,  171,   96,  250,   95,   44,   47,   47,   96,   44,
 /*  1900 */   360,   35,   35,   96,   35,   35,   35,   35,  368,  459,
 /*  1910 */    47,   96,   44,  373,  244,  375,    0,    0,  360,   96,
 /*  1920 */    47,    0,    0,  365,   95,   39,  368,   96,   95,    0,
 /*  1930 */    96,  373,   39,  375,   95,   95,   47,   95,   95,  399,
 /*  1940 */   105,   44,  329,  403,  165,  167,  406,  407,  408,  409,
 /*  1950 */   410,  411,  229,  413,    2,  415,  231,  399,   22,   95,
 /*  1960 */    95,  403,  208,   22,  406,  407,  408,  409,  410,  411,
 /*  1970 */    96,  413,  229,  360,   96,   95,  119,   96,  365,   47,
 /*  1980 */    95,  368,   95,   95,   47,  106,  373,   96,  375,   35,
 /*  1990 */    96,   35,   96,   95,   35,   95,  210,  329,   96,   35,
 /*  2000 */    95,   35,   96,   95,   35,   96,   95,   22,   95,  119,
 /*  2010 */   107,  119,  399,  329,  119,   44,  403,   35,   95,  406,
 /*  2020 */   407,  408,  409,  410,  411,   95,  413,   22,  360,   64,
 /*  2030 */    63,   35,   35,   35,   35,   35,  368,   35,   35,   35,
 /*  2040 */    70,  373,   35,  375,  360,   35,   35,   92,   35,   35,
 /*  2050 */    44,   35,  368,   22,   35,   35,   70,  373,   35,  375,
 /*  2060 */    35,   35,   35,   35,   22,  329,    0,  399,   35,   35,
 /*  2070 */    48,  403,    0,   35,  406,  407,  408,  409,  410,  411,
 /*  2080 */    39,  413,   39,  399,   48,    0,   35,  403,  329,    0,
 /*  2090 */   406,  407,  408,  409,  410,  411,  360,  413,   48,   39,
 /*  2100 */    35,   48,   39,    0,  368,   35,   35,    0,   22,  373,
 /*  2110 */    22,  375,   21,   20,   22,   21,  462,  462,  462,  360,
 /*  2120 */   462,  462,  462,  462,  462,  462,  462,  368,  462,  462,
 /*  2130 */   462,  462,  373,  462,  375,  399,  462,  462,  462,  403,
 /*  2140 */   329,  462,  406,  407,  408,  409,  410,  411,  462,  413,
 /*  2150 */   462,  462,  462,  462,  462,  462,  462,  462,  399,  462,
 /*  2160 */   462,  329,  403,  462,  462,  406,  407,  408,  409,  410,
 /*  2170 */   411,  360,  413,  462,  462,  462,  462,  462,  462,  368,
 /*  2180 */   462,  462,  462,  462,  373,  462,  375,  462,  462,  462,
 /*  2190 */   462,  462,  360,  462,  462,  462,  462,  462,  462,  462,
 /*  2200 */   368,  462,  462,  462,  462,  373,  462,  375,  462,  462,
 /*  2210 */   399,  462,  462,  462,  403,  462,  462,  406,  407,  408,
 /*  2220 */   409,  410,  411,  462,  413,  462,  462,  462,  462,  462,
 /*  2230 */   329,  399,  462,  462,  462,  403,  462,  462,  406,  407,
 /*  2240 */   408,  409,  410,  411,  462,  413,  462,  462,  329,  462,
 /*  2250 */   462,  462,  462,  462,  462,  462,  462,  462,  462,  462,
 /*  2260 */   462,  360,  462,  462,  462,  462,  462,  462,  462,  368,
 /*  2270 */   462,  462,  462,  462,  373,  462,  375,  462,  462,  360,
 /*  2280 */   462,  462,  462,  462,  462,  462,  462,  368,  462,  462,
 /*  2290 */   462,  462,  373,  462,  375,  462,  462,  462,  462,  462,
 /*  2300 */   399,  462,  462,  329,  403,  462,  462,  406,  407,  408,
 /*  2310 */   409,  410,  411,  462,  413,  462,  462,  462,  399,  462,
 /*  2320 */   462,  462,  403,  462,  462,  406,  407,  408,  409,  410,
 /*  2330 */   411,  462,  413,  462,  360,  462,  462,  462,  462,  462,
 /*  2340 */   462,  462,  368,  462,  462,  462,  462,  373,  462,  375,
 /*  2350 */   462,  462,  462,  462,  462,  462,  462,  462,  329,  462,
 /*  2360 */   462,  462,  462,  462,  462,  462,  462,  462,  462,  462,
 /*  2370 */   462,  462,  462,  399,  329,  462,  462,  403,  462,  462,
 /*  2380 */   406,  407,  408,  409,  410,  411,  462,  413,  462,  360,
 /*  2390 */   462,  462,  462,  462,  462,  462,  462,  368,  462,  462,
 /*  2400 */   462,  462,  373,  462,  375,  360,  462,  462,  462,  462,
 /*  2410 */   462,  462,  462,  368,  462,  462,  462,  462,  373,  462,
 /*  2420 */   375,  462,  462,  462,  462,  462,  329,  462,  399,  462,
 /*  2430 */   462,  462,  403,  462,  462,  406,  407,  408,  409,  410,
 /*  2440 */   411,  462,  413,  462,  399,  462,  462,  462,  403,  329,
 /*  2450 */   462,  406,  407,  408,  409,  410,  411,  360,  413,  462,
 /*  2460 */   462,  462,  462,  462,  462,  368,  462,  462,  462,  462,
 /*  2470 */   373,  462,  375,  462,  462,  462,  462,  462,  462,  462,
 /*  2480 */   360,  462,  462,  462,  462,  462,  462,  462,  368,  462,
 /*  2490 */   462,  462,  462,  373,  462,  375,  399,  462,  462,  462,
 /*  2500 */   403,  329,  462,  406,  407,  408,  409,  410,  411,  462,
 /*  2510 */   413,  462,  462,  462,  462,  462,  462,  462,  462,  399,
 /*  2520 */   462,  462,  329,  403,  462,  462,  406,  407,  408,  409,
 /*  2530 */   410,  411,  360,  413,  462,  462,  462,  462,  462,  462,
 /*  2540 */   368,  462,  462,  462,  462,  373,  462,  375,  462,  462,
 /*  2550 */   462,  462,  462,  360,  462,  462,  462,  462,  462,  462,
 /*  2560 */   462,  368,  462,  462,  462,  462,  373,  462,  375,  462,
 /*  2570 */   462,  399,  462,  462,  462,  403,  462,  462,  406,  407,
 /*  2580 */   408,  409,  410,  411,  462,  413,  462,  462,  462,  462,
 /*  2590 */   462,  329,  399,  462,  462,  462,  403,  462,  462,  406,
 /*  2600 */   407,  408,  409,  410,  411,  462,  413,  462,  462,  329,
 /*  2610 */   462,  462,  462,  462,  462,  462,  462,  462,  462,  462,
 /*  2620 */   462,  462,  360,  462,  462,  462,  462,  462,  462,  462,
 /*  2630 */   368,  462,  462,  462,  462,  373,  462,  375,  462,  462,
 /*  2640 */   360,  462,  462,  462,  462,  462,  462,  462,  368,  462,
 /*  2650 */   462,  462,  462,  373,  462,  375,  462,  462,  462,  462,
 /*  2660 */   462,  399,  462,  462,  329,  403,  462,  462,  406,  407,
 /*  2670 */   408,  409,  410,  411,  462,  413,  462,  462,  462,  399,
 /*  2680 */   462,  462,  462,  403,  462,  462,  406,  407,  408,  409,
 /*  2690 */   410,  411,  462,  413,  462,  360,  462,  462,  462,  462,
 /*  2700 */   462,  462,  462,  368,  462,  462,  462,  462,  373,  462,
 /*  2710 */   375,  462,  462,  462,  462,  462,  462,  462,  462,  329,
 /*  2720 */   462,  462,  462,  462,  462,  462,  462,  462,  462,  462,
 /*  2730 */   462,  462,  462,  462,  399,  329,  462,  462,  403,  462,
 /*  2740 */   462,  406,  407,  408,  409,  410,  411,  462,  413,  462,
 /*  2750 */   360,  462,  462,  462,  462,  462,  462,  462,  368,  462,
 /*  2760 */   462,  462,  462,  373,  462,  375,  360,  462,  462,  462,
 /*  2770 */   462,  462,  462,  462,  368,  462,  462,  462,  462,  373,
 /*  2780 */   462,  375,  462,  462,  462,  462,  462,  329,  462,  399,
 /*  2790 */   462,  462,  462,  403,  462,  462,  406,  407,  408,  409,
 /*  2800 */   410,  411,  462,  413,  462,  399,  462,  462,  462,  403,
 /*  2810 */   329,  462,  406,  407,  408,  409,  410,  411,  360,  413,
 /*  2820 */   462,  462,  462,  462,  462,  462,  368,  462,  462,  462,
 /*  2830 */   462,  373,  462,  375,  462,  462,  462,  462,  462,  462,
 /*  2840 */   462,  360,  462,  462,  462,  462,  462,  462,  462,  368,
 /*  2850 */   462,  462,  462,  462,  373,  462,  375,  399,  462,  462,
 /*  2860 */   462,  403,  462,  462,  406,  407,  408,  409,  410,  411,
 /*  2870 */   462,  413,  462,  462,  462,  462,  462,  462,  462,  462,
 /*  2880 */   399,  462,  462,  462,  403,  462,  462,  406,  407,  408,
 /*  2890 */   409,  410,  411,  462,  413,  326,  326,  326,  326,  326,
 /*  2900 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2910 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2920 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2930 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2940 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2950 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2960 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2970 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2980 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2990 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3000 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3010 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3020 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3030 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3040 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3050 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3060 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3070 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3080 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3090 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3100 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3110 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3120 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3130 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3140 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3150 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3160 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3170 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3180 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3190 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3200 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3210 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3220 */   326,
};
#define YY_SHIFT_COUNT    (723)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2107)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   865,    0,   71,    0,  290,  290,  290,  290,  290,  290,
 /*    10 */   290,  290,  290,  290,  290,  361,  578,  578,  649,  578,
 /*    20 */   578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
 /*    30 */   578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
 /*    40 */   578,  578,  578,  578,  578,  578,  578,  578,  115,  154,
 /*    50 */    72,   59,  149,  214,  446,  214,   72,   72, 1178, 1178,
 /*    60 */   214, 1178, 1178,  251,  214,  258,    5,    5,  258,   85,
 /*    70 */    85,  551,  239,   74,   74,    5,    5,    5,    5,    5,
 /*    80 */     5,    5,    5,    5,    5,   78,    5,    5,  162,    5,
 /*    90 */   225,    5,    5,    5,    5,  225,    5,    5,  225,    5,
 /*   100 */   225,  225,  225,    5,  253,  795,   34,   34,   47,  164,
 /*   110 */   710,  710,  710,  710,  710,  710,  710,  710,  710,  710,
 /*   120 */   710,  710,  710,  710,  710,  710,  710,  710,  710,  891,
 /*   130 */   730,  551,  239,  137,  456,  529,  529,  529,  308,  374,
 /*   140 */   374,  456,  459,  459,  459,  416,  335,  225,  525,  225,
 /*   150 */   525,  525,  416,  531,  218,  218,  218,  218,  218,  218,
 /*   160 */   218,  502,  415,   36,  454,  249,  469,  122,   69,   25,
 /*   170 */    98,  546,  590,  941,  775,  665,  832,   21,  930,  832,
 /*   180 */  1015,  852,  822, 1070, 1285, 1155, 1299, 1334, 1299, 1199,
 /*   190 */  1351, 1351, 1299, 1199, 1199, 1288, 1351, 1351, 1351, 1372,
 /*   200 */  1372, 1375,   78, 1376,   78, 1390, 1392,   78, 1390,   78,
 /*   210 */    78,   78, 1351,   78, 1366, 1366, 1372,  225,  225,  225,
 /*   220 */   225,  225,  225,  225,  225,  225,  225,  225, 1351, 1372,
 /*   230 */   525,  525, 1238, 1375,  253, 1251, 1376,  253, 1351, 1334,
 /*   240 */  1334,  525, 1207, 1228,  525, 1207, 1228,  525,  525,  225,
 /*   250 */  1230, 1323, 1207, 1239, 1242, 1252, 1070, 1235, 1241, 1244,
 /*   260 */  1262,  459, 1496, 1351, 1390,  253,  253, 1228,  525,  525,
 /*   270 */   525,  525,  525, 1228,  525, 1369,  253,  416,  253,  459,
 /*   280 */  1446, 1453,  525,  531, 1351,  253, 1513, 1372, 2895, 2895,
 /*   290 */  2895, 2895, 2895, 2895, 2895, 2895, 2895,  890,  311,  884,
 /*   300 */   981,  524,  342,  539,  608,  614,  763,  474,  723,  993,
 /*   310 */   993,  993,  993,  993,  993,  993,  993,  993,   63,  123,
 /*   320 */   364,  364,  455,  636,  561,   87,  749,  303,  995,  995,
 /*   330 */   864,  919,  406,  864,  864,  864,  320, 1035,  450, 1023,
 /*   340 */   994, 1025, 1095, 1100, 1106, 1110, 1146, 1160, 1040, 1145,
 /*   350 */  1165, 1001,  656, 1017,  728, 1176, 1193, 1201, 1202, 1212,
 /*   360 */  1214, 1220, 1219,  126, 1152, 1075, 1188, 1234, 1227, 1256,
 /*   370 */  1259, 1263, 1278, 1280, 1211, 1247, 1277, 1258, 1003, 1586,
 /*   380 */  1587, 1398, 1589, 1590, 1550, 1593, 1559, 1396, 1564, 1565,
 /*   390 */  1566, 1400, 1603, 1569, 1571, 1405, 1608, 1407, 1611, 1578,
 /*   400 */  1614, 1594, 1615, 1582, 1433, 1436, 1620, 1622, 1444, 1447,
 /*   410 */  1624, 1626, 1580, 1628, 1629, 1630, 1591, 1631, 1632, 1634,
 /*   420 */  1635, 1637, 1638, 1641, 1642, 1498, 1616, 1653, 1503, 1655,
 /*   430 */  1656, 1658, 1659, 1663, 1664, 1666, 1671, 1672, 1673, 1674,
 /*   440 */  1675, 1676, 1677, 1679, 1680, 1627, 1681, 1682, 1686, 1687,
 /*   450 */  1688, 1689, 1646, 1690, 1692, 1694, 1549, 1696, 1697, 1669,
 /*   460 */  1706, 1649, 1708, 1652, 1711, 1712, 1683, 1695, 1678, 1691,
 /*   470 */  1701, 1693, 1713, 1699, 1726, 1702, 1704, 1728, 1729, 1731,
 /*   480 */  1705, 1562, 1733, 1741, 1747, 1685, 1748, 1752, 1719, 1707,
 /*   490 */  1717, 1757, 1724, 1714, 1722, 1764, 1730, 1718, 1737, 1768,
 /*   500 */  1734, 1732, 1739, 1781, 1782, 1783, 1785, 1698, 1703, 1751,
 /*   510 */  1765, 1789, 1755, 1762, 1766, 1769, 1763, 1767, 1771, 1773,
 /*   520 */  1777, 1774, 1803, 1791, 1814, 1793, 1770, 1816, 1795, 1784,
 /*   530 */  1821, 1787, 1824, 1792, 1826, 1806, 1809, 1797, 1798, 1639,
 /*   540 */  1742, 1735, 1837, 1700, 1805, 1841, 1657, 1820, 1709, 1710,
 /*   550 */  1845, 1847, 1721, 1716, 1848, 1804, 1600, 1760, 1756, 1772,
 /*   560 */  1715, 1625, 1720, 1612, 1775, 1818, 1776, 1780, 1788, 1794,
 /*   570 */  1796, 1846, 1849, 1850, 1799, 1851, 1618, 1802, 1807, 1862,
 /*   580 */  1855, 1643, 1866, 1867, 1869, 1870, 1871, 1872, 1815, 1823,
 /*   590 */  1863, 1670, 1868, 1873, 1916, 1917, 1921, 1922, 1829, 1886,
 /*   600 */  1833, 1831, 1834, 1839, 1840, 1778, 1842, 1929, 1893, 1779,
 /*   610 */  1843, 1835, 1691, 1889, 1897, 1723, 1725, 1743, 1952, 1936,
 /*   620 */  1754, 1864, 1874, 1865, 1878, 1880, 1881, 1932, 1885, 1887,
 /*   630 */  1937, 1891, 1941, 1786, 1888, 1879, 1894, 1954, 1956, 1898,
 /*   640 */  1896, 1959, 1900, 1902, 1964, 1905, 1906, 1966, 1908, 1909,
 /*   650 */  1969, 1911, 1857, 1890, 1892, 1895, 1985, 1903, 1913, 1971,
 /*   660 */  1923, 1982, 1930, 1971, 1971, 2005, 1965, 1967, 1996, 1997,
 /*   670 */  1998, 1999, 2000, 2002, 2003, 2004, 2007, 2010, 1970, 1955,
 /*   680 */  2006, 2011, 2013, 2014, 2031, 2016, 2019, 2020, 1986, 1763,
 /*   690 */  2023, 1767, 2025, 2026, 2027, 2028, 2042, 2033, 2066, 2034,
 /*   700 */  2022, 2041, 2072, 2038, 2036, 2043, 2085, 2051, 2050, 2060,
 /*   710 */  2089, 2065, 2053, 2063, 2103, 2070, 2071, 2107, 2086, 2091,
 /*   720 */  2088, 2092, 2094, 2093,
};
#define YY_REDUCE_COUNT (296)
#define YY_REDUCE_MIN   (-428)
#define YY_REDUCE_MAX   (2481)
static const short yy_reduce_ofst[] = {
 /*     0 */    -2, -260,  234,  683,  349,  745,  768,  844,  867,  959,
 /*    10 */  1046, 1069, 1144, 1171, 1237,  936,  295, 1292, 1310, 1364,
 /*    20 */  1385, 1450, 1471, 1540, 1558, 1613, 1668, 1684, 1736, 1759,
 /*    30 */  1811, 1832, 1901, 1919, 1974, 2029, 2045, 2097, 2120, 2172,
 /*    40 */  2193, 2262, 2280, 2335, 2390, 2406, 2458, 2481,  -19, -280,
 /*    50 */  -306,  224,  628,  774,  782,  869, -232,  -31, -347,  284,
 /*    60 */  -428, -362,  -10, -371, -277,   76,   67,  549, -372, -326,
 /*    70 */   192, -328, -369, -300, -132,  194,  266,  328,  470,  554,
 /*    80 */   645,  653,  660,  679,  680,  114,  472,  682, -341,  685,
 /*    90 */   -60,  687,  736,  744,  751, -270,  772,  779,  245,  794,
 /*   100 */   314,  479,  464,  798, -311,   10, -170, -170,   54, -285,
 /*   110 */    16,   33,  119,  191,  391,  508,  512,  622,  654,  659,
 /*   120 */   664,  681,  733,  786,  788,  810,  828,  855,  856, -261,
 /*   130 */   220,  428,   46,  -62,  196,  220,  259,  294,  390,  299,
 /*   140 */   332,  550,  440,  452,  519, -335, -184, -253,  557,   52,
 /*   150 */   559,  676,  491,  675, -360,  270,  407,  498,  753,  764,
 /*   160 */   781,  632,  289,  695,  815,  747,  766,  877,  780,  889,
 /*   170 */   889,  885,  861,  931,  922,  916,  879,  879,  878,  879,
 /*   180 */   888,  880,  889,  929,  938,  948,  973,  974,  976,  986,
 /*   190 */  1036, 1041, 1000, 1004, 1007, 1043, 1052, 1053, 1054, 1062,
 /*   200 */  1063, 1011, 1065, 1022, 1066, 1073, 1024, 1074, 1078, 1077,
 /*   210 */  1079, 1080, 1076, 1081, 1085, 1086, 1096, 1068, 1071, 1072,
 /*   220 */  1083, 1087, 1088, 1090, 1091, 1098, 1101, 1102, 1093, 1103,
 /*   230 */  1060, 1067, 1038, 1042, 1105, 1089, 1092, 1119, 1104, 1082,
 /*   240 */  1107, 1108, 1027, 1099, 1113, 1032, 1109, 1115, 1118,  889,
 /*   250 */  1051, 1055, 1056, 1061, 1084, 1094, 1112, 1047, 1059, 1057,
 /*   260 */   879, 1147, 1116, 1181, 1182, 1184, 1185, 1136, 1150, 1154,
 /*   270 */  1156, 1157, 1159, 1142, 1161, 1153, 1195, 1186, 1197, 1172,
 /*   280 */  1122, 1192, 1187, 1208, 1222, 1221, 1229, 1232, 1174, 1168,
 /*   290 */  1189, 1196, 1217, 1218, 1231, 1233, 1246,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*    10 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*    20 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*    30 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*    40 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*    50 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*    60 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*    70 */  1619, 1876, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*    80 */  1619, 1619, 1619, 1619, 1619, 1697, 1619, 1619, 1619, 1619,
 /*    90 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   100 */  1619, 1619, 1619, 1619, 1695, 1869, 2073, 1619, 1619, 1619,
 /*   110 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   120 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   130 */  2085, 1619, 1619, 1697, 1619, 2085, 2085, 2085, 1695, 2045,
 /*   140 */  2045, 1619, 1619, 1619, 1619, 1804, 1619, 1619, 1619, 1619,
 /*   150 */  1619, 1619, 1804, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   160 */  1619, 1919, 1619, 1619, 2110, 2164, 1619, 1619, 2113, 1619,
 /*   170 */  1619, 1619, 1881, 1619, 1757, 2100, 2077, 2091, 2148, 2078,
 /*   180 */  2075, 2094, 1619, 2104, 1619, 1912, 1874, 1619, 1874, 1871,
 /*   190 */  1619, 1619, 1874, 1871, 1871, 1748, 1619, 1619, 1619, 1619,
 /*   200 */  1619, 1619, 1697, 1619, 1697, 1619, 1619, 1697, 1619, 1697,
 /*   210 */  1697, 1697, 1619, 1697, 1676, 1676, 1619, 1619, 1619, 1619,
 /*   220 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   230 */  1619, 1619, 1932, 1619, 1695, 1921, 1619, 1695, 1619, 1619,
 /*   240 */  1619, 1619, 2121, 2119, 1619, 2121, 2119, 1619, 1619, 1619,
 /*   250 */  2133, 2129, 2121, 2137, 2135, 2106, 2104, 2167, 2154, 2150,
 /*   260 */  2091, 1619, 1619, 1619, 1619, 1695, 1695, 2119, 1619, 1619,
 /*   270 */  1619, 1619, 1619, 2119, 1619, 1619, 1695, 1619, 1695, 1619,
 /*   280 */  1619, 1773, 1619, 1619, 1619, 1695, 1651, 1619, 1914, 1925,
 /*   290 */  1897, 1897, 1807, 1807, 1807, 1698, 1624, 1619, 1619, 1619,
 /*   300 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 2132,
 /*   310 */  2131, 2000, 1619, 2049, 2048, 2047, 2038, 1999, 1769, 1619,
 /*   320 */  1998, 1997, 1619, 1619, 1619, 1619, 1619, 1619, 1888, 1887,
 /*   330 */  1991, 1619, 1619, 1992, 1990, 1989, 1619, 1619, 1619, 1619,
 /*   340 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   350 */  1619, 1619, 2151, 2155, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   360 */  1619, 2074, 1619, 1619, 1619, 1619, 1619, 1974, 1619, 1619,
 /*   370 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   380 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   390 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   400 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   410 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   420 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   430 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   440 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   450 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   460 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1656, 1979,
 /*   470 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   480 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   490 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   500 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   510 */  1619, 1619, 1619, 1619, 1619, 1619, 1736, 1735, 1619, 1619,
 /*   520 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   530 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   540 */  1982, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   550 */  1619, 1619, 1619, 1619, 2147, 2107, 1619, 1619, 1619, 1619,
 /*   560 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   570 */  1619, 1619, 1619, 1974, 1619, 2130, 1619, 1619, 2145, 1619,
 /*   580 */  2149, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 2084, 2080,
 /*   590 */  1619, 1619, 2076, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   600 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   610 */  1619, 1619, 1973, 1619, 2035, 1619, 1619, 1619, 2069, 1619,
 /*   620 */  1619, 2020, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   630 */  1619, 1982, 1619, 1985, 1619, 1619, 1619, 1619, 1619, 1801,
 /*   640 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   650 */  1619, 1619, 1786, 1784, 1783, 1782, 1619, 1779, 1619, 1814,
 /*   660 */  1619, 1619, 1619, 1810, 1809, 1619, 1619, 1619, 1619, 1619,
 /*   670 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   680 */  1716, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1708,
 /*   690 */  1619, 1707, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   700 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   710 */  1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619, 1619,
 /*   720 */  1619, 1619, 1619, 1619,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
  272,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*      START => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  272,  /*      AFTER => ABORT */
  272,  /*     ATTACH => ABORT */
  272,  /*     BEFORE => ABORT */
  272,  /*      BEGIN => ABORT */
  272,  /*     BITAND => ABORT */
  272,  /*     BITNOT => ABORT */
  272,  /*      BITOR => ABORT */
  272,  /*     BLOCKS => ABORT */
  272,  /*     CHANGE => ABORT */
  272,  /*      COMMA => ABORT */
  272,  /*    COMPACT => ABORT */
  272,  /*     CONCAT => ABORT */
  272,  /*   CONFLICT => ABORT */
  272,  /*       COPY => ABORT */
  272,  /*   DEFERRED => ABORT */
  272,  /* DELIMITERS => ABORT */
  272,  /*     DETACH => ABORT */
  272,  /*     DIVIDE => ABORT */
  272,  /*        DOT => ABORT */
  272,  /*       EACH => ABORT */
  272,  /*       FAIL => ABORT */
  272,  /*       FILE => ABORT */
  272,  /*        FOR => ABORT */
  272,  /*       GLOB => ABORT */
  272,  /*         ID => ABORT */
  272,  /*  IMMEDIATE => ABORT */
  272,  /*     IMPORT => ABORT */
  272,  /*  INITIALLY => ABORT */
  272,  /*    INSTEAD => ABORT */
  272,  /*     ISNULL => ABORT */
  272,  /*        KEY => ABORT */
  272,  /*    MODULES => ABORT */
  272,  /*  NK_BITNOT => ABORT */
  272,  /*    NK_SEMI => ABORT */
  272,  /*    NOTNULL => ABORT */
  272,  /*         OF => ABORT */
  272,  /*       PLUS => ABORT */
  272,  /*  PRIVILEGE => ABORT */
  272,  /*      RAISE => ABORT */
  272,  /*    REPLACE => ABORT */
  272,  /*   RESTRICT => ABORT */
  272,  /*        ROW => ABORT */
  272,  /*       SEMI => ABORT */
  272,  /*       STAR => ABORT */
  272,  /*  STATEMENT => ABORT */
  272,  /*     STRICT => ABORT */
  272,  /*     STRING => ABORT */
  272,  /*      TIMES => ABORT */
  272,  /*     UPDATE => ABORT */
  272,  /*     VALUES => ABORT */
  272,  /*   VARIABLE => ABORT */
  272,  /*       VIEW => ABORT */
  272,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "IF",
  /*   63 */ "NOT",
  /*   64 */ "EXISTS",
  /*   65 */ "BUFFER",
  /*   66 */ "CACHEMODEL",
  /*   67 */ "CACHESIZE",
  /*   68 */ "COMP",
  /*   69 */ "DURATION",
  /*   70 */ "NK_VARIABLE",
  /*   71 */ "MAXROWS",
  /*   72 */ "MINROWS",
  /*   73 */ "KEEP",
  /*   74 */ "PAGES",
  /*   75 */ "PAGESIZE",
  /*   76 */ "TSDB_PAGESIZE",
  /*   77 */ "PRECISION",
  /*   78 */ "REPLICA",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "WAL_LEVEL",
  /*   84 */ "WAL_FSYNC_PERIOD",
  /*   85 */ "WAL_RETENTION_PERIOD",
  /*   86 */ "WAL_RETENTION_SIZE",
  /*   87 */ "WAL_ROLL_PERIOD",
  /*   88 */ "WAL_SEGMENT_SIZE",
  /*   89 */ "STT_TRIGGER",
  /*   90 */ "TABLE_PREFIX",
  /*   91 */ "TABLE_SUFFIX",
  /*   92 */ "NK_COLON",
  /*   93 */ "MAX_SPEED",
  /*   94 */ "TABLE",
  /*   95 */ "NK_LP",
  /*   96 */ "NK_RP",
  /*   97 */ "STABLE",
  /*   98 */ "ADD",
  /*   99 */ "COLUMN",
  /*  100 */ "MODIFY",
  /*  101 */ "RENAME",
  /*  102 */ "TAG",
  /*  103 */ "SET",
  /*  104 */ "NK_EQ",
  /*  105 */ "USING",
  /*  106 */ "TAGS",
  /*  107 */ "COMMENT",
  /*  108 */ "BOOL",
  /*  109 */ "TINYINT",
  /*  110 */ "SMALLINT",
  /*  111 */ "INT",
  /*  112 */ "INTEGER",
  /*  113 */ "BIGINT",
  /*  114 */ "FLOAT",
  /*  115 */ "DOUBLE",
  /*  116 */ "BINARY",
  /*  117 */ "TIMESTAMP",
  /*  118 */ "NCHAR",
  /*  119 */ "UNSIGNED",
  /*  120 */ "JSON",
  /*  121 */ "VARCHAR",
  /*  122 */ "MEDIUMBLOB",
  /*  123 */ "BLOB",
  /*  124 */ "VARBINARY",
  /*  125 */ "DECIMAL",
  /*  126 */ "MAX_DELAY",
  /*  127 */ "WATERMARK",
  /*  128 */ "ROLLUP",
  /*  129 */ "TTL",
  /*  130 */ "SMA",
  /*  131 */ "DELETE_MARK",
  /*  132 */ "FIRST",
  /*  133 */ "LAST",
  /*  134 */ "SHOW",
  /*  135 */ "PRIVILEGES",
  /*  136 */ "DATABASES",
  /*  137 */ "TABLES",
  /*  138 */ "STABLES",
  /*  139 */ "MNODES",
  /*  140 */ "QNODES",
  /*  141 */ "FUNCTIONS",
  /*  142 */ "INDEXES",
  /*  143 */ "ACCOUNTS",
  /*  144 */ "APPS",
  /*  145 */ "CONNECTIONS",
  /*  146 */ "LICENCES",
  /*  147 */ "GRANTS",
  /*  148 */ "QUERIES",
  /*  149 */ "SCORES",
  /*  150 */ "TOPICS",
  /*  151 */ "VARIABLES",
  /*  152 */ "CLUSTER",
  /*  153 */ "BNODES",
  /*  154 */ "SNODES",
  /*  155 */ "TRANSACTIONS",
  /*  156 */ "DISTRIBUTED",
  /*  157 */ "CONSUMERS",
  /*  158 */ "SUBSCRIPTIONS",
  /*  159 */ "VNODES",
  /*  160 */ "ALIVE",
  /*  161 */ "LIKE",
  /*  162 */ "TBNAME",
  /*  163 */ "QTAGS",
  /*  164 */ "AS",
  /*  165 */ "INDEX",
  /*  166 */ "FUNCTION",
  /*  167 */ "INTERVAL",
  /*  168 */ "COUNT",
  /*  169 */ "LAST_ROW",
  /*  170 */ "TOPIC",
  /*  171 */ "WITH",
  /*  172 */ "META",
  /*  173 */ "CONSUMER",
  /*  174 */ "GROUP",
  /*  175 */ "DESC",
  /*  176 */ "DESCRIBE",
  /*  177 */ "RESET",
  /*  178 */ "QUERY",
  /*  179 */ "CACHE",
  /*  180 */ "EXPLAIN",
  /*  181 */ "ANALYZE",
  /*  182 */ "VERBOSE",
  /*  183 */ "NK_BOOL",
  /*  184 */ "RATIO",
  /*  185 */ "NK_FLOAT",
  /*  186 */ "OUTPUTTYPE",
  /*  187 */ "AGGREGATE",
  /*  188 */ "BUFSIZE",
  /*  189 */ "STREAM",
  /*  190 */ "INTO",
  /*  191 */ "TRIGGER",
  /*  192 */ "AT_ONCE",
  /*  193 */ "WINDOW_CLOSE",
  /*  194 */ "IGNORE",
  /*  195 */ "EXPIRED",
  /*  196 */ "FILL_HISTORY",
  /*  197 */ "SUBTABLE",
  /*  198 */ "KILL",
  /*  199 */ "CONNECTION",
  /*  200 */ "TRANSACTION",
  /*  201 */ "BALANCE",
  /*  202 */ "VGROUP",
  /*  203 */ "MERGE",
  /*  204 */ "REDISTRIBUTE",
  /*  205 */ "SPLIT",
  /*  206 */ "DELETE",
  /*  207 */ "INSERT",
  /*  208 */ "NULL",
  /*  209 */ "NK_QUESTION",
  /*  210 */ "NK_ARROW",
  /*  211 */ "ROWTS",
  /*  212 */ "QSTART",
  /*  213 */ "QEND",
  /*  214 */ "QDURATION",
  /*  215 */ "WSTART",
  /*  216 */ "WEND",
  /*  217 */ "WDURATION",
  /*  218 */ "IROWTS",
  /*  219 */ "ISFILLED",
  /*  220 */ "CAST",
  /*  221 */ "NOW",
  /*  222 */ "TODAY",
  /*  223 */ "TIMEZONE",
  /*  224 */ "CLIENT_VERSION",
  /*  225 */ "SERVER_VERSION",
  /*  226 */ "SERVER_STATUS",
  /*  227 */ "CURRENT_USER",
  /*  228 */ "CASE",
  /*  229 */ "END",
  /*  230 */ "WHEN",
  /*  231 */ "THEN",
  /*  232 */ "ELSE",
  /*  233 */ "BETWEEN",
  /*  234 */ "IS",
  /*  235 */ "NK_LT",
  /*  236 */ "NK_GT",
  /*  237 */ "NK_LE",
  /*  238 */ "NK_GE",
  /*  239 */ "NK_NE",
  /*  240 */ "MATCH",
  /*  241 */ "NMATCH",
  /*  242 */ "CONTAINS",
  /*  243 */ "IN",
  /*  244 */ "JOIN",
  /*  245 */ "INNER",
  /*  246 */ "SELECT",
  /*  247 */ "DISTINCT",
  /*  248 */ "WHERE",
  /*  249 */ "PARTITION",
  /*  250 */ "BY",
  /*  251 */ "SESSION",
  /*  252 */ "STATE_WINDOW",
  /*  253 */ "EVENT_WINDOW",
  /*  254 */ "START",
  /*  255 */ "SLIDING",
  /*  256 */ "FILL",
  /*  257 */ "VALUE",
  /*  258 */ "NONE",
  /*  259 */ "PREV",
  /*  260 */ "LINEAR",
  /*  261 */ "NEXT",
  /*  262 */ "HAVING",
  /*  263 */ "RANGE",
  /*  264 */ "EVERY",
  /*  265 */ "ORDER",
  /*  266 */ "SLIMIT",
  /*  267 */ "SOFFSET",
  /*  268 */ "LIMIT",
  /*  269 */ "OFFSET",
  /*  270 */ "ASC",
  /*  271 */ "NULLS",
  /*  272 */ "ABORT",
  /*  273 */ "AFTER",
  /*  274 */ "ATTACH",
  /*  275 */ "BEFORE",
  /*  276 */ "BEGIN",
  /*  277 */ "BITAND",
  /*  278 */ "BITNOT",
  /*  279 */ "BITOR",
  /*  280 */ "BLOCKS",
  /*  281 */ "CHANGE",
  /*  282 */ "COMMA",
  /*  283 */ "COMPACT",
  /*  284 */ "CONCAT",
  /*  285 */ "CONFLICT",
  /*  286 */ "COPY",
  /*  287 */ "DEFERRED",
  /*  288 */ "DELIMITERS",
  /*  289 */ "DETACH",
  /*  290 */ "DIVIDE",
  /*  291 */ "DOT",
  /*  292 */ "EACH",
  /*  293 */ "FAIL",
  /*  294 */ "FILE",
  /*  295 */ "FOR",
  /*  296 */ "GLOB",
  /*  297 */ "ID",
  /*  298 */ "IMMEDIATE",
  /*  299 */ "IMPORT",
  /*  300 */ "INITIALLY",
  /*  301 */ "INSTEAD",
  /*  302 */ "ISNULL",
  /*  303 */ "KEY",
  /*  304 */ "MODULES",
  /*  305 */ "NK_BITNOT",
  /*  306 */ "NK_SEMI",
  /*  307 */ "NOTNULL",
  /*  308 */ "OF",
  /*  309 */ "PLUS",
  /*  310 */ "PRIVILEGE",
  /*  311 */ "RAISE",
  /*  312 */ "REPLACE",
  /*  313 */ "RESTRICT",
  /*  314 */ "ROW",
  /*  315 */ "SEMI",
  /*  316 */ "STAR",
  /*  317 */ "STATEMENT",
  /*  318 */ "STRICT",
  /*  319 */ "STRING",
  /*  320 */ "TIMES",
  /*  321 */ "UPDATE",
  /*  322 */ "VALUES",
  /*  323 */ "VARIABLE",
  /*  324 */ "VIEW",
  /*  325 */ "WAL",
  /*  326 */ "cmd",
  /*  327 */ "account_options",
  /*  328 */ "alter_account_options",
  /*  329 */ "literal",
  /*  330 */ "alter_account_option",
  /*  331 */ "user_name",
  /*  332 */ "sysinfo_opt",
  /*  333 */ "privileges",
  /*  334 */ "priv_level",
  /*  335 */ "priv_type_list",
  /*  336 */ "priv_type",
  /*  337 */ "db_name",
  /*  338 */ "topic_name",
  /*  339 */ "dnode_endpoint",
  /*  340 */ "force_opt",
  /*  341 */ "not_exists_opt",
  /*  342 */ "db_options",
  /*  343 */ "exists_opt",
  /*  344 */ "alter_db_options",
  /*  345 */ "speed_opt",
  /*  346 */ "integer_list",
  /*  347 */ "variable_list",
  /*  348 */ "retention_list",
  /*  349 */ "alter_db_option",
  /*  350 */ "retention",
  /*  351 */ "full_table_name",
  /*  352 */ "column_def_list",
  /*  353 */ "tags_def_opt",
  /*  354 */ "table_options",
  /*  355 */ "multi_create_clause",
  /*  356 */ "tags_def",
  /*  357 */ "multi_drop_clause",
  /*  358 */ "alter_table_clause",
  /*  359 */ "alter_table_options",
  /*  360 */ "column_name",
  /*  361 */ "type_name",
  /*  362 */ "signed_literal",
  /*  363 */ "create_subtable_clause",
  /*  364 */ "specific_cols_opt",
  /*  365 */ "expression_list",
  /*  366 */ "drop_table_clause",
  /*  367 */ "col_name_list",
  /*  368 */ "table_name",
  /*  369 */ "column_def",
  /*  370 */ "duration_list",
  /*  371 */ "rollup_func_list",
  /*  372 */ "alter_table_option",
  /*  373 */ "duration_literal",
  /*  374 */ "rollup_func_name",
  /*  375 */ "function_name",
  /*  376 */ "col_name",
  /*  377 */ "db_name_cond_opt",
  /*  378 */ "like_pattern_opt",
  /*  379 */ "table_name_cond",
  /*  380 */ "from_db_opt",
  /*  381 */ "tag_list_opt",
  /*  382 */ "tag_item",
  /*  383 */ "column_alias",
  /*  384 */ "index_options",
  /*  385 */ "func_list",
  /*  386 */ "sliding_opt",
  /*  387 */ "sma_stream_opt",
  /*  388 */ "func",
  /*  389 */ "sma_func_name",
  /*  390 */ "query_or_subquery",
  /*  391 */ "cgroup_name",
  /*  392 */ "analyze_opt",
  /*  393 */ "explain_options",
  /*  394 */ "agg_func_opt",
  /*  395 */ "bufsize_opt",
  /*  396 */ "stream_name",
  /*  397 */ "stream_options",
  /*  398 */ "subtable_opt",
  /*  399 */ "expression",
  /*  400 */ "dnode_list",
  /*  401 */ "where_clause_opt",
  /*  402 */ "signed",
  /*  403 */ "literal_func",
  /*  404 */ "literal_list",
  /*  405 */ "table_alias",
  /*  406 */ "expr_or_subquery",
  /*  407 */ "pseudo_column",
  /*  408 */ "column_reference",
  /*  409 */ "function_expression",
  /*  410 */ "case_when_expression",
  /*  411 */ "star_func",
  /*  412 */ "star_func_para_list",
  /*  413 */ "noarg_func",
  /*  414 */ "other_para_list",
  /*  415 */ "star_func_para",
  /*  416 */ "when_then_list",
  /*  417 */ "case_when_else_opt",
  /*  418 */ "common_expression",
  /*  419 */ "when_then_expr",
  /*  420 */ "predicate",
  /*  421 */ "compare_op",
  /*  422 */ "in_op",
  /*  423 */ "in_predicate_value",
  /*  424 */ "boolean_value_expression",
  /*  425 */ "boolean_primary",
  /*  426 */ "from_clause_opt",
  /*  427 */ "table_reference_list",
  /*  428 */ "table_reference",
  /*  429 */ "table_primary",
  /*  430 */ "joined_table",
  /*  431 */ "alias_opt",
  /*  432 */ "subquery",
  /*  433 */ "parenthesized_joined_table",
  /*  434 */ "join_type",
  /*  435 */ "search_condition",
  /*  436 */ "query_specification",
  /*  437 */ "set_quantifier_opt",
  /*  438 */ "select_list",
  /*  439 */ "partition_by_clause_opt",
  /*  440 */ "range_opt",
  /*  441 */ "every_opt",
  /*  442 */ "fill_opt",
  /*  443 */ "twindow_clause_opt",
  /*  444 */ "group_by_clause_opt",
  /*  445 */ "having_clause_opt",
  /*  446 */ "select_item",
  /*  447 */ "partition_list",
  /*  448 */ "partition_item",
  /*  449 */ "fill_mode",
  /*  450 */ "group_by_list",
  /*  451 */ "query_expression",
  /*  452 */ "query_simple",
  /*  453 */ "order_by_clause_opt",
  /*  454 */ "slimit_clause_opt",
  /*  455 */ "limit_clause_opt",
  /*  456 */ "union_query_expression",
  /*  457 */ "query_simple_or_subquery",
  /*  458 */ "sort_specification_list",
  /*  459 */ "sort_specification",
  /*  460 */ "ordering_specification_opt",
  /*  461 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  73 */ "not_exists_opt ::=",
 /*  74 */ "exists_opt ::= IF EXISTS",
 /*  75 */ "exists_opt ::=",
 /*  76 */ "db_options ::=",
 /*  77 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  78 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  79 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  81 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  83 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  84 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options KEEP integer_list",
 /*  86 */ "db_options ::= db_options KEEP variable_list",
 /*  87 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  88 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  89 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  91 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  92 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  93 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  94 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  95 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 104 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 105 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 107 */ "alter_db_options ::= alter_db_option",
 /* 108 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 109 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 110 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 111 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 112 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 113 */ "alter_db_option ::= KEEP integer_list",
 /* 114 */ "alter_db_option ::= KEEP variable_list",
 /* 115 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 116 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 117 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 118 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 119 */ "integer_list ::= NK_INTEGER",
 /* 120 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 121 */ "variable_list ::= NK_VARIABLE",
 /* 122 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 123 */ "retention_list ::= retention",
 /* 124 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 125 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 126 */ "speed_opt ::=",
 /* 127 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 128 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 129 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 130 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 131 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 132 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 133 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 134 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 135 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 136 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 142 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 144 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 145 */ "multi_create_clause ::= create_subtable_clause",
 /* 146 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 147 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 148 */ "multi_drop_clause ::= drop_table_clause",
 /* 149 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 150 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 151 */ "specific_cols_opt ::=",
 /* 152 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 153 */ "full_table_name ::= table_name",
 /* 154 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 155 */ "column_def_list ::= column_def",
 /* 156 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 157 */ "column_def ::= column_name type_name",
 /* 158 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 159 */ "type_name ::= BOOL",
 /* 160 */ "type_name ::= TINYINT",
 /* 161 */ "type_name ::= SMALLINT",
 /* 162 */ "type_name ::= INT",
 /* 163 */ "type_name ::= INTEGER",
 /* 164 */ "type_name ::= BIGINT",
 /* 165 */ "type_name ::= FLOAT",
 /* 166 */ "type_name ::= DOUBLE",
 /* 167 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TIMESTAMP",
 /* 169 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TINYINT UNSIGNED",
 /* 171 */ "type_name ::= SMALLINT UNSIGNED",
 /* 172 */ "type_name ::= INT UNSIGNED",
 /* 173 */ "type_name ::= BIGINT UNSIGNED",
 /* 174 */ "type_name ::= JSON",
 /* 175 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 176 */ "type_name ::= MEDIUMBLOB",
 /* 177 */ "type_name ::= BLOB",
 /* 178 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL",
 /* 180 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 182 */ "tags_def_opt ::=",
 /* 183 */ "tags_def_opt ::= tags_def",
 /* 184 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 185 */ "table_options ::=",
 /* 186 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 187 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 188 */ "table_options ::= table_options WATERMARK duration_list",
 /* 189 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 190 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 191 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 192 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 193 */ "alter_table_options ::= alter_table_option",
 /* 194 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 195 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 196 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 197 */ "duration_list ::= duration_literal",
 /* 198 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 199 */ "rollup_func_list ::= rollup_func_name",
 /* 200 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 201 */ "rollup_func_name ::= function_name",
 /* 202 */ "rollup_func_name ::= FIRST",
 /* 203 */ "rollup_func_name ::= LAST",
 /* 204 */ "col_name_list ::= col_name",
 /* 205 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 206 */ "col_name ::= column_name",
 /* 207 */ "cmd ::= SHOW DNODES",
 /* 208 */ "cmd ::= SHOW USERS",
 /* 209 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 210 */ "cmd ::= SHOW DATABASES",
 /* 211 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 214 */ "cmd ::= SHOW MNODES",
 /* 215 */ "cmd ::= SHOW QNODES",
 /* 216 */ "cmd ::= SHOW FUNCTIONS",
 /* 217 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 218 */ "cmd ::= SHOW STREAMS",
 /* 219 */ "cmd ::= SHOW ACCOUNTS",
 /* 220 */ "cmd ::= SHOW APPS",
 /* 221 */ "cmd ::= SHOW CONNECTIONS",
 /* 222 */ "cmd ::= SHOW LICENCES",
 /* 223 */ "cmd ::= SHOW GRANTS",
 /* 224 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 225 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 226 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 227 */ "cmd ::= SHOW QUERIES",
 /* 228 */ "cmd ::= SHOW SCORES",
 /* 229 */ "cmd ::= SHOW TOPICS",
 /* 230 */ "cmd ::= SHOW VARIABLES",
 /* 231 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 232 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 233 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 234 */ "cmd ::= SHOW BNODES",
 /* 235 */ "cmd ::= SHOW SNODES",
 /* 236 */ "cmd ::= SHOW CLUSTER",
 /* 237 */ "cmd ::= SHOW TRANSACTIONS",
 /* 238 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 239 */ "cmd ::= SHOW CONSUMERS",
 /* 240 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 241 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 242 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 244 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 245 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 246 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 247 */ "db_name_cond_opt ::=",
 /* 248 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 249 */ "like_pattern_opt ::=",
 /* 250 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 251 */ "table_name_cond ::= table_name",
 /* 252 */ "from_db_opt ::=",
 /* 253 */ "from_db_opt ::= FROM db_name",
 /* 254 */ "tag_list_opt ::=",
 /* 255 */ "tag_list_opt ::= tag_item",
 /* 256 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 257 */ "tag_item ::= TBNAME",
 /* 258 */ "tag_item ::= QTAGS",
 /* 259 */ "tag_item ::= column_name",
 /* 260 */ "tag_item ::= column_name column_alias",
 /* 261 */ "tag_item ::= column_name AS column_alias",
 /* 262 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 263 */ "cmd ::= CREATE INDEX not_exists_opt full_table_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 264 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 265 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 266 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 267 */ "func_list ::= func",
 /* 268 */ "func_list ::= func_list NK_COMMA func",
 /* 269 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 270 */ "sma_func_name ::= function_name",
 /* 271 */ "sma_func_name ::= COUNT",
 /* 272 */ "sma_func_name ::= FIRST",
 /* 273 */ "sma_func_name ::= LAST",
 /* 274 */ "sma_func_name ::= LAST_ROW",
 /* 275 */ "sma_stream_opt ::=",
 /* 276 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 277 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 278 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 279 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 280 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 281 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 282 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 283 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 284 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 285 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 286 */ "cmd ::= DESC full_table_name",
 /* 287 */ "cmd ::= DESCRIBE full_table_name",
 /* 288 */ "cmd ::= RESET QUERY CACHE",
 /* 289 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 290 */ "analyze_opt ::=",
 /* 291 */ "analyze_opt ::= ANALYZE",
 /* 292 */ "explain_options ::=",
 /* 293 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 294 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 295 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 296 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 297 */ "agg_func_opt ::=",
 /* 298 */ "agg_func_opt ::= AGGREGATE",
 /* 299 */ "bufsize_opt ::=",
 /* 300 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 301 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 302 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 303 */ "stream_options ::=",
 /* 304 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 305 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 306 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 307 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 308 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 309 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 310 */ "subtable_opt ::=",
 /* 311 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 312 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 313 */ "cmd ::= KILL QUERY NK_STRING",
 /* 314 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 315 */ "cmd ::= BALANCE VGROUP",
 /* 316 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 317 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 318 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 319 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 320 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 321 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 322 */ "cmd ::= query_or_subquery",
 /* 323 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 324 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 325 */ "literal ::= NK_INTEGER",
 /* 326 */ "literal ::= NK_FLOAT",
 /* 327 */ "literal ::= NK_STRING",
 /* 328 */ "literal ::= NK_BOOL",
 /* 329 */ "literal ::= TIMESTAMP NK_STRING",
 /* 330 */ "literal ::= duration_literal",
 /* 331 */ "literal ::= NULL",
 /* 332 */ "literal ::= NK_QUESTION",
 /* 333 */ "duration_literal ::= NK_VARIABLE",
 /* 334 */ "signed ::= NK_INTEGER",
 /* 335 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 336 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 337 */ "signed ::= NK_FLOAT",
 /* 338 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 339 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 340 */ "signed_literal ::= signed",
 /* 341 */ "signed_literal ::= NK_STRING",
 /* 342 */ "signed_literal ::= NK_BOOL",
 /* 343 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 344 */ "signed_literal ::= duration_literal",
 /* 345 */ "signed_literal ::= NULL",
 /* 346 */ "signed_literal ::= literal_func",
 /* 347 */ "signed_literal ::= NK_QUESTION",
 /* 348 */ "literal_list ::= signed_literal",
 /* 349 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 350 */ "db_name ::= NK_ID",
 /* 351 */ "table_name ::= NK_ID",
 /* 352 */ "column_name ::= NK_ID",
 /* 353 */ "function_name ::= NK_ID",
 /* 354 */ "table_alias ::= NK_ID",
 /* 355 */ "column_alias ::= NK_ID",
 /* 356 */ "user_name ::= NK_ID",
 /* 357 */ "topic_name ::= NK_ID",
 /* 358 */ "stream_name ::= NK_ID",
 /* 359 */ "cgroup_name ::= NK_ID",
 /* 360 */ "expr_or_subquery ::= expression",
 /* 361 */ "expression ::= literal",
 /* 362 */ "expression ::= pseudo_column",
 /* 363 */ "expression ::= column_reference",
 /* 364 */ "expression ::= function_expression",
 /* 365 */ "expression ::= case_when_expression",
 /* 366 */ "expression ::= NK_LP expression NK_RP",
 /* 367 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 368 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 369 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 370 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 371 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 372 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 373 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 374 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 375 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 376 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 377 */ "expression_list ::= expr_or_subquery",
 /* 378 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 379 */ "column_reference ::= column_name",
 /* 380 */ "column_reference ::= table_name NK_DOT column_name",
 /* 381 */ "pseudo_column ::= ROWTS",
 /* 382 */ "pseudo_column ::= TBNAME",
 /* 383 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 384 */ "pseudo_column ::= QSTART",
 /* 385 */ "pseudo_column ::= QEND",
 /* 386 */ "pseudo_column ::= QDURATION",
 /* 387 */ "pseudo_column ::= WSTART",
 /* 388 */ "pseudo_column ::= WEND",
 /* 389 */ "pseudo_column ::= WDURATION",
 /* 390 */ "pseudo_column ::= IROWTS",
 /* 391 */ "pseudo_column ::= ISFILLED",
 /* 392 */ "pseudo_column ::= QTAGS",
 /* 393 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 394 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 395 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 396 */ "function_expression ::= literal_func",
 /* 397 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 398 */ "literal_func ::= NOW",
 /* 399 */ "noarg_func ::= NOW",
 /* 400 */ "noarg_func ::= TODAY",
 /* 401 */ "noarg_func ::= TIMEZONE",
 /* 402 */ "noarg_func ::= DATABASE",
 /* 403 */ "noarg_func ::= CLIENT_VERSION",
 /* 404 */ "noarg_func ::= SERVER_VERSION",
 /* 405 */ "noarg_func ::= SERVER_STATUS",
 /* 406 */ "noarg_func ::= CURRENT_USER",
 /* 407 */ "noarg_func ::= USER",
 /* 408 */ "star_func ::= COUNT",
 /* 409 */ "star_func ::= FIRST",
 /* 410 */ "star_func ::= LAST",
 /* 411 */ "star_func ::= LAST_ROW",
 /* 412 */ "star_func_para_list ::= NK_STAR",
 /* 413 */ "star_func_para_list ::= other_para_list",
 /* 414 */ "other_para_list ::= star_func_para",
 /* 415 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 416 */ "star_func_para ::= expr_or_subquery",
 /* 417 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 418 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 419 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 420 */ "when_then_list ::= when_then_expr",
 /* 421 */ "when_then_list ::= when_then_list when_then_expr",
 /* 422 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 423 */ "case_when_else_opt ::=",
 /* 424 */ "case_when_else_opt ::= ELSE common_expression",
 /* 425 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 426 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 427 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 428 */ "predicate ::= expr_or_subquery IS NULL",
 /* 429 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 430 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 431 */ "compare_op ::= NK_LT",
 /* 432 */ "compare_op ::= NK_GT",
 /* 433 */ "compare_op ::= NK_LE",
 /* 434 */ "compare_op ::= NK_GE",
 /* 435 */ "compare_op ::= NK_NE",
 /* 436 */ "compare_op ::= NK_EQ",
 /* 437 */ "compare_op ::= LIKE",
 /* 438 */ "compare_op ::= NOT LIKE",
 /* 439 */ "compare_op ::= MATCH",
 /* 440 */ "compare_op ::= NMATCH",
 /* 441 */ "compare_op ::= CONTAINS",
 /* 442 */ "in_op ::= IN",
 /* 443 */ "in_op ::= NOT IN",
 /* 444 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 445 */ "boolean_value_expression ::= boolean_primary",
 /* 446 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 447 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 448 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 449 */ "boolean_primary ::= predicate",
 /* 450 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 451 */ "common_expression ::= expr_or_subquery",
 /* 452 */ "common_expression ::= boolean_value_expression",
 /* 453 */ "from_clause_opt ::=",
 /* 454 */ "from_clause_opt ::= FROM table_reference_list",
 /* 455 */ "table_reference_list ::= table_reference",
 /* 456 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 457 */ "table_reference ::= table_primary",
 /* 458 */ "table_reference ::= joined_table",
 /* 459 */ "table_primary ::= table_name alias_opt",
 /* 460 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 461 */ "table_primary ::= subquery alias_opt",
 /* 462 */ "table_primary ::= parenthesized_joined_table",
 /* 463 */ "alias_opt ::=",
 /* 464 */ "alias_opt ::= table_alias",
 /* 465 */ "alias_opt ::= AS table_alias",
 /* 466 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 467 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 468 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 469 */ "join_type ::=",
 /* 470 */ "join_type ::= INNER",
 /* 471 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 472 */ "set_quantifier_opt ::=",
 /* 473 */ "set_quantifier_opt ::= DISTINCT",
 /* 474 */ "set_quantifier_opt ::= ALL",
 /* 475 */ "select_list ::= select_item",
 /* 476 */ "select_list ::= select_list NK_COMMA select_item",
 /* 477 */ "select_item ::= NK_STAR",
 /* 478 */ "select_item ::= common_expression",
 /* 479 */ "select_item ::= common_expression column_alias",
 /* 480 */ "select_item ::= common_expression AS column_alias",
 /* 481 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 482 */ "where_clause_opt ::=",
 /* 483 */ "where_clause_opt ::= WHERE search_condition",
 /* 484 */ "partition_by_clause_opt ::=",
 /* 485 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 486 */ "partition_list ::= partition_item",
 /* 487 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 488 */ "partition_item ::= expr_or_subquery",
 /* 489 */ "partition_item ::= expr_or_subquery column_alias",
 /* 490 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 491 */ "twindow_clause_opt ::=",
 /* 492 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 493 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 494 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 495 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 496 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 497 */ "sliding_opt ::=",
 /* 498 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 499 */ "fill_opt ::=",
 /* 500 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 501 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 502 */ "fill_mode ::= NONE",
 /* 503 */ "fill_mode ::= PREV",
 /* 504 */ "fill_mode ::= NULL",
 /* 505 */ "fill_mode ::= LINEAR",
 /* 506 */ "fill_mode ::= NEXT",
 /* 507 */ "group_by_clause_opt ::=",
 /* 508 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 509 */ "group_by_list ::= expr_or_subquery",
 /* 510 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 511 */ "having_clause_opt ::=",
 /* 512 */ "having_clause_opt ::= HAVING search_condition",
 /* 513 */ "range_opt ::=",
 /* 514 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 515 */ "every_opt ::=",
 /* 516 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 517 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 518 */ "query_simple ::= query_specification",
 /* 519 */ "query_simple ::= union_query_expression",
 /* 520 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 521 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 522 */ "query_simple_or_subquery ::= query_simple",
 /* 523 */ "query_simple_or_subquery ::= subquery",
 /* 524 */ "query_or_subquery ::= query_expression",
 /* 525 */ "query_or_subquery ::= subquery",
 /* 526 */ "order_by_clause_opt ::=",
 /* 527 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 528 */ "slimit_clause_opt ::=",
 /* 529 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 530 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 531 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 532 */ "limit_clause_opt ::=",
 /* 533 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 534 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 535 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 536 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 537 */ "subquery ::= NK_LP subquery NK_RP",
 /* 538 */ "search_condition ::= common_expression",
 /* 539 */ "sort_specification_list ::= sort_specification",
 /* 540 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 541 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 542 */ "ordering_specification_opt ::=",
 /* 543 */ "ordering_specification_opt ::= ASC",
 /* 544 */ "ordering_specification_opt ::= DESC",
 /* 545 */ "null_ordering_opt ::=",
 /* 546 */ "null_ordering_opt ::= NULLS FIRST",
 /* 547 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 326: /* cmd */
    case 329: /* literal */
    case 342: /* db_options */
    case 344: /* alter_db_options */
    case 350: /* retention */
    case 351: /* full_table_name */
    case 354: /* table_options */
    case 358: /* alter_table_clause */
    case 359: /* alter_table_options */
    case 362: /* signed_literal */
    case 363: /* create_subtable_clause */
    case 366: /* drop_table_clause */
    case 369: /* column_def */
    case 373: /* duration_literal */
    case 374: /* rollup_func_name */
    case 376: /* col_name */
    case 377: /* db_name_cond_opt */
    case 378: /* like_pattern_opt */
    case 379: /* table_name_cond */
    case 380: /* from_db_opt */
    case 382: /* tag_item */
    case 384: /* index_options */
    case 386: /* sliding_opt */
    case 387: /* sma_stream_opt */
    case 388: /* func */
    case 390: /* query_or_subquery */
    case 393: /* explain_options */
    case 397: /* stream_options */
    case 398: /* subtable_opt */
    case 399: /* expression */
    case 401: /* where_clause_opt */
    case 402: /* signed */
    case 403: /* literal_func */
    case 406: /* expr_or_subquery */
    case 407: /* pseudo_column */
    case 408: /* column_reference */
    case 409: /* function_expression */
    case 410: /* case_when_expression */
    case 415: /* star_func_para */
    case 417: /* case_when_else_opt */
    case 418: /* common_expression */
    case 419: /* when_then_expr */
    case 420: /* predicate */
    case 423: /* in_predicate_value */
    case 424: /* boolean_value_expression */
    case 425: /* boolean_primary */
    case 426: /* from_clause_opt */
    case 427: /* table_reference_list */
    case 428: /* table_reference */
    case 429: /* table_primary */
    case 430: /* joined_table */
    case 432: /* subquery */
    case 433: /* parenthesized_joined_table */
    case 435: /* search_condition */
    case 436: /* query_specification */
    case 440: /* range_opt */
    case 441: /* every_opt */
    case 442: /* fill_opt */
    case 443: /* twindow_clause_opt */
    case 445: /* having_clause_opt */
    case 446: /* select_item */
    case 448: /* partition_item */
    case 451: /* query_expression */
    case 452: /* query_simple */
    case 454: /* slimit_clause_opt */
    case 455: /* limit_clause_opt */
    case 456: /* union_query_expression */
    case 457: /* query_simple_or_subquery */
    case 459: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy476)); 
}
      break;
    case 327: /* account_options */
    case 328: /* alter_account_options */
    case 330: /* alter_account_option */
    case 345: /* speed_opt */
    case 395: /* bufsize_opt */
{
 
}
      break;
    case 331: /* user_name */
    case 334: /* priv_level */
    case 337: /* db_name */
    case 338: /* topic_name */
    case 339: /* dnode_endpoint */
    case 360: /* column_name */
    case 368: /* table_name */
    case 375: /* function_name */
    case 383: /* column_alias */
    case 389: /* sma_func_name */
    case 391: /* cgroup_name */
    case 396: /* stream_name */
    case 405: /* table_alias */
    case 411: /* star_func */
    case 413: /* noarg_func */
    case 431: /* alias_opt */
{
 
}
      break;
    case 332: /* sysinfo_opt */
{
 
}
      break;
    case 333: /* privileges */
    case 335: /* priv_type_list */
    case 336: /* priv_type */
{
 
}
      break;
    case 340: /* force_opt */
    case 341: /* not_exists_opt */
    case 343: /* exists_opt */
    case 392: /* analyze_opt */
    case 394: /* agg_func_opt */
    case 437: /* set_quantifier_opt */
{
 
}
      break;
    case 346: /* integer_list */
    case 347: /* variable_list */
    case 348: /* retention_list */
    case 352: /* column_def_list */
    case 353: /* tags_def_opt */
    case 355: /* multi_create_clause */
    case 356: /* tags_def */
    case 357: /* multi_drop_clause */
    case 364: /* specific_cols_opt */
    case 365: /* expression_list */
    case 367: /* col_name_list */
    case 370: /* duration_list */
    case 371: /* rollup_func_list */
    case 381: /* tag_list_opt */
    case 385: /* func_list */
    case 400: /* dnode_list */
    case 404: /* literal_list */
    case 412: /* star_func_para_list */
    case 414: /* other_para_list */
    case 416: /* when_then_list */
    case 438: /* select_list */
    case 439: /* partition_by_clause_opt */
    case 444: /* group_by_clause_opt */
    case 447: /* partition_list */
    case 450: /* group_by_list */
    case 453: /* order_by_clause_opt */
    case 458: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy376)); 
}
      break;
    case 349: /* alter_db_option */
    case 372: /* alter_table_option */
{
 
}
      break;
    case 361: /* type_name */
{
 
}
      break;
    case 421: /* compare_op */
    case 422: /* in_op */
{
 
}
      break;
    case 434: /* join_type */
{
 
}
      break;
    case 449: /* fill_mode */
{
 
}
      break;
    case 460: /* ordering_specification_opt */
{
 
}
      break;
    case 461: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<sizeof(yy_action)/sizeof(yy_action[0]) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
   326,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   326,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
   327,  /* (2) account_options ::= */
   327,  /* (3) account_options ::= account_options PPS literal */
   327,  /* (4) account_options ::= account_options TSERIES literal */
   327,  /* (5) account_options ::= account_options STORAGE literal */
   327,  /* (6) account_options ::= account_options STREAMS literal */
   327,  /* (7) account_options ::= account_options QTIME literal */
   327,  /* (8) account_options ::= account_options DBS literal */
   327,  /* (9) account_options ::= account_options USERS literal */
   327,  /* (10) account_options ::= account_options CONNS literal */
   327,  /* (11) account_options ::= account_options STATE literal */
   328,  /* (12) alter_account_options ::= alter_account_option */
   328,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   330,  /* (14) alter_account_option ::= PASS literal */
   330,  /* (15) alter_account_option ::= PPS literal */
   330,  /* (16) alter_account_option ::= TSERIES literal */
   330,  /* (17) alter_account_option ::= STORAGE literal */
   330,  /* (18) alter_account_option ::= STREAMS literal */
   330,  /* (19) alter_account_option ::= QTIME literal */
   330,  /* (20) alter_account_option ::= DBS literal */
   330,  /* (21) alter_account_option ::= USERS literal */
   330,  /* (22) alter_account_option ::= CONNS literal */
   330,  /* (23) alter_account_option ::= STATE literal */
   326,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   326,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   326,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   326,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   326,  /* (28) cmd ::= DROP USER user_name */
   332,  /* (29) sysinfo_opt ::= */
   332,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   326,  /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
   326,  /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
   333,  /* (33) privileges ::= ALL */
   333,  /* (34) privileges ::= priv_type_list */
   333,  /* (35) privileges ::= SUBSCRIBE */
   335,  /* (36) priv_type_list ::= priv_type */
   335,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   336,  /* (38) priv_type ::= READ */
   336,  /* (39) priv_type ::= WRITE */
   334,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   334,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   334,  /* (42) priv_level ::= topic_name */
   326,  /* (43) cmd ::= CREATE DNODE dnode_endpoint */
   326,  /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   326,  /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
   326,  /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
   326,  /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   326,  /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   326,  /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
   326,  /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   339,  /* (51) dnode_endpoint ::= NK_STRING */
   339,  /* (52) dnode_endpoint ::= NK_ID */
   339,  /* (53) dnode_endpoint ::= NK_IPTOKEN */
   340,  /* (54) force_opt ::= */
   340,  /* (55) force_opt ::= FORCE */
   326,  /* (56) cmd ::= ALTER LOCAL NK_STRING */
   326,  /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   326,  /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   326,  /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   326,  /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   326,  /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   326,  /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   326,  /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   326,  /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   326,  /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   326,  /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   326,  /* (67) cmd ::= DROP DATABASE exists_opt db_name */
   326,  /* (68) cmd ::= USE db_name */
   326,  /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
   326,  /* (70) cmd ::= FLUSH DATABASE db_name */
   326,  /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
   341,  /* (72) not_exists_opt ::= IF NOT EXISTS */
   341,  /* (73) not_exists_opt ::= */
   343,  /* (74) exists_opt ::= IF EXISTS */
   343,  /* (75) exists_opt ::= */
   342,  /* (76) db_options ::= */
   342,  /* (77) db_options ::= db_options BUFFER NK_INTEGER */
   342,  /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
   342,  /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
   342,  /* (80) db_options ::= db_options COMP NK_INTEGER */
   342,  /* (81) db_options ::= db_options DURATION NK_INTEGER */
   342,  /* (82) db_options ::= db_options DURATION NK_VARIABLE */
   342,  /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
   342,  /* (84) db_options ::= db_options MINROWS NK_INTEGER */
   342,  /* (85) db_options ::= db_options KEEP integer_list */
   342,  /* (86) db_options ::= db_options KEEP variable_list */
   342,  /* (87) db_options ::= db_options PAGES NK_INTEGER */
   342,  /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
   342,  /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   342,  /* (90) db_options ::= db_options PRECISION NK_STRING */
   342,  /* (91) db_options ::= db_options REPLICA NK_INTEGER */
   342,  /* (92) db_options ::= db_options VGROUPS NK_INTEGER */
   342,  /* (93) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   342,  /* (94) db_options ::= db_options RETENTIONS retention_list */
   342,  /* (95) db_options ::= db_options SCHEMALESS NK_INTEGER */
   342,  /* (96) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   342,  /* (97) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   342,  /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   342,  /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   342,  /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   342,  /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   342,  /* (102) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   342,  /* (103) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   342,  /* (104) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   342,  /* (105) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
   342,  /* (106) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
   344,  /* (107) alter_db_options ::= alter_db_option */
   344,  /* (108) alter_db_options ::= alter_db_options alter_db_option */
   349,  /* (109) alter_db_option ::= BUFFER NK_INTEGER */
   349,  /* (110) alter_db_option ::= CACHEMODEL NK_STRING */
   349,  /* (111) alter_db_option ::= CACHESIZE NK_INTEGER */
   349,  /* (112) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   349,  /* (113) alter_db_option ::= KEEP integer_list */
   349,  /* (114) alter_db_option ::= KEEP variable_list */
   349,  /* (115) alter_db_option ::= PAGES NK_INTEGER */
   349,  /* (116) alter_db_option ::= REPLICA NK_INTEGER */
   349,  /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   349,  /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   346,  /* (119) integer_list ::= NK_INTEGER */
   346,  /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   347,  /* (121) variable_list ::= NK_VARIABLE */
   347,  /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   348,  /* (123) retention_list ::= retention */
   348,  /* (124) retention_list ::= retention_list NK_COMMA retention */
   350,  /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
   345,  /* (126) speed_opt ::= */
   345,  /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
   326,  /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   326,  /* (129) cmd ::= CREATE TABLE multi_create_clause */
   326,  /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   326,  /* (131) cmd ::= DROP TABLE multi_drop_clause */
   326,  /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
   326,  /* (133) cmd ::= ALTER TABLE alter_table_clause */
   326,  /* (134) cmd ::= ALTER STABLE alter_table_clause */
   358,  /* (135) alter_table_clause ::= full_table_name alter_table_options */
   358,  /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   358,  /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   358,  /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   358,  /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   358,  /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   358,  /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
   358,  /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   358,  /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   358,  /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   355,  /* (145) multi_create_clause ::= create_subtable_clause */
   355,  /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
   363,  /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   357,  /* (148) multi_drop_clause ::= drop_table_clause */
   357,  /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
   366,  /* (150) drop_table_clause ::= exists_opt full_table_name */
   364,  /* (151) specific_cols_opt ::= */
   364,  /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   351,  /* (153) full_table_name ::= table_name */
   351,  /* (154) full_table_name ::= db_name NK_DOT table_name */
   352,  /* (155) column_def_list ::= column_def */
   352,  /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
   369,  /* (157) column_def ::= column_name type_name */
   369,  /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
   361,  /* (159) type_name ::= BOOL */
   361,  /* (160) type_name ::= TINYINT */
   361,  /* (161) type_name ::= SMALLINT */
   361,  /* (162) type_name ::= INT */
   361,  /* (163) type_name ::= INTEGER */
   361,  /* (164) type_name ::= BIGINT */
   361,  /* (165) type_name ::= FLOAT */
   361,  /* (166) type_name ::= DOUBLE */
   361,  /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   361,  /* (168) type_name ::= TIMESTAMP */
   361,  /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   361,  /* (170) type_name ::= TINYINT UNSIGNED */
   361,  /* (171) type_name ::= SMALLINT UNSIGNED */
   361,  /* (172) type_name ::= INT UNSIGNED */
   361,  /* (173) type_name ::= BIGINT UNSIGNED */
   361,  /* (174) type_name ::= JSON */
   361,  /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   361,  /* (176) type_name ::= MEDIUMBLOB */
   361,  /* (177) type_name ::= BLOB */
   361,  /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   361,  /* (179) type_name ::= DECIMAL */
   361,  /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   361,  /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
   353,  /* (182) tags_def_opt ::= */
   353,  /* (183) tags_def_opt ::= tags_def */
   356,  /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
   354,  /* (185) table_options ::= */
   354,  /* (186) table_options ::= table_options COMMENT NK_STRING */
   354,  /* (187) table_options ::= table_options MAX_DELAY duration_list */
   354,  /* (188) table_options ::= table_options WATERMARK duration_list */
   354,  /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   354,  /* (190) table_options ::= table_options TTL NK_INTEGER */
   354,  /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   354,  /* (192) table_options ::= table_options DELETE_MARK duration_list */
   359,  /* (193) alter_table_options ::= alter_table_option */
   359,  /* (194) alter_table_options ::= alter_table_options alter_table_option */
   372,  /* (195) alter_table_option ::= COMMENT NK_STRING */
   372,  /* (196) alter_table_option ::= TTL NK_INTEGER */
   370,  /* (197) duration_list ::= duration_literal */
   370,  /* (198) duration_list ::= duration_list NK_COMMA duration_literal */
   371,  /* (199) rollup_func_list ::= rollup_func_name */
   371,  /* (200) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   374,  /* (201) rollup_func_name ::= function_name */
   374,  /* (202) rollup_func_name ::= FIRST */
   374,  /* (203) rollup_func_name ::= LAST */
   367,  /* (204) col_name_list ::= col_name */
   367,  /* (205) col_name_list ::= col_name_list NK_COMMA col_name */
   376,  /* (206) col_name ::= column_name */
   326,  /* (207) cmd ::= SHOW DNODES */
   326,  /* (208) cmd ::= SHOW USERS */
   326,  /* (209) cmd ::= SHOW USER PRIVILEGES */
   326,  /* (210) cmd ::= SHOW DATABASES */
   326,  /* (211) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   326,  /* (212) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   326,  /* (213) cmd ::= SHOW db_name_cond_opt VGROUPS */
   326,  /* (214) cmd ::= SHOW MNODES */
   326,  /* (215) cmd ::= SHOW QNODES */
   326,  /* (216) cmd ::= SHOW FUNCTIONS */
   326,  /* (217) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   326,  /* (218) cmd ::= SHOW STREAMS */
   326,  /* (219) cmd ::= SHOW ACCOUNTS */
   326,  /* (220) cmd ::= SHOW APPS */
   326,  /* (221) cmd ::= SHOW CONNECTIONS */
   326,  /* (222) cmd ::= SHOW LICENCES */
   326,  /* (223) cmd ::= SHOW GRANTS */
   326,  /* (224) cmd ::= SHOW CREATE DATABASE db_name */
   326,  /* (225) cmd ::= SHOW CREATE TABLE full_table_name */
   326,  /* (226) cmd ::= SHOW CREATE STABLE full_table_name */
   326,  /* (227) cmd ::= SHOW QUERIES */
   326,  /* (228) cmd ::= SHOW SCORES */
   326,  /* (229) cmd ::= SHOW TOPICS */
   326,  /* (230) cmd ::= SHOW VARIABLES */
   326,  /* (231) cmd ::= SHOW CLUSTER VARIABLES */
   326,  /* (232) cmd ::= SHOW LOCAL VARIABLES */
   326,  /* (233) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   326,  /* (234) cmd ::= SHOW BNODES */
   326,  /* (235) cmd ::= SHOW SNODES */
   326,  /* (236) cmd ::= SHOW CLUSTER */
   326,  /* (237) cmd ::= SHOW TRANSACTIONS */
   326,  /* (238) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   326,  /* (239) cmd ::= SHOW CONSUMERS */
   326,  /* (240) cmd ::= SHOW SUBSCRIPTIONS */
   326,  /* (241) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   326,  /* (242) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   326,  /* (243) cmd ::= SHOW VNODES NK_INTEGER */
   326,  /* (244) cmd ::= SHOW VNODES NK_STRING */
   326,  /* (245) cmd ::= SHOW db_name_cond_opt ALIVE */
   326,  /* (246) cmd ::= SHOW CLUSTER ALIVE */
   377,  /* (247) db_name_cond_opt ::= */
   377,  /* (248) db_name_cond_opt ::= db_name NK_DOT */
   378,  /* (249) like_pattern_opt ::= */
   378,  /* (250) like_pattern_opt ::= LIKE NK_STRING */
   379,  /* (251) table_name_cond ::= table_name */
   380,  /* (252) from_db_opt ::= */
   380,  /* (253) from_db_opt ::= FROM db_name */
   381,  /* (254) tag_list_opt ::= */
   381,  /* (255) tag_list_opt ::= tag_item */
   381,  /* (256) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   382,  /* (257) tag_item ::= TBNAME */
   382,  /* (258) tag_item ::= QTAGS */
   382,  /* (259) tag_item ::= column_name */
   382,  /* (260) tag_item ::= column_name column_alias */
   382,  /* (261) tag_item ::= column_name AS column_alias */
   326,  /* (262) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
   326,  /* (263) cmd ::= CREATE INDEX not_exists_opt full_table_name ON full_table_name NK_LP col_name_list NK_RP */
   326,  /* (264) cmd ::= DROP INDEX exists_opt full_table_name */
   384,  /* (265) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
   384,  /* (266) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   385,  /* (267) func_list ::= func */
   385,  /* (268) func_list ::= func_list NK_COMMA func */
   388,  /* (269) func ::= sma_func_name NK_LP expression_list NK_RP */
   389,  /* (270) sma_func_name ::= function_name */
   389,  /* (271) sma_func_name ::= COUNT */
   389,  /* (272) sma_func_name ::= FIRST */
   389,  /* (273) sma_func_name ::= LAST */
   389,  /* (274) sma_func_name ::= LAST_ROW */
   387,  /* (275) sma_stream_opt ::= */
   387,  /* (276) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   387,  /* (277) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   387,  /* (278) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   326,  /* (279) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   326,  /* (280) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   326,  /* (281) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   326,  /* (282) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   326,  /* (283) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   326,  /* (284) cmd ::= DROP TOPIC exists_opt topic_name */
   326,  /* (285) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   326,  /* (286) cmd ::= DESC full_table_name */
   326,  /* (287) cmd ::= DESCRIBE full_table_name */
   326,  /* (288) cmd ::= RESET QUERY CACHE */
   326,  /* (289) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   392,  /* (290) analyze_opt ::= */
   392,  /* (291) analyze_opt ::= ANALYZE */
   393,  /* (292) explain_options ::= */
   393,  /* (293) explain_options ::= explain_options VERBOSE NK_BOOL */
   393,  /* (294) explain_options ::= explain_options RATIO NK_FLOAT */
   326,  /* (295) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
   326,  /* (296) cmd ::= DROP FUNCTION exists_opt function_name */
   394,  /* (297) agg_func_opt ::= */
   394,  /* (298) agg_func_opt ::= AGGREGATE */
   395,  /* (299) bufsize_opt ::= */
   395,  /* (300) bufsize_opt ::= BUFSIZE NK_INTEGER */
   326,  /* (301) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
   326,  /* (302) cmd ::= DROP STREAM exists_opt stream_name */
   397,  /* (303) stream_options ::= */
   397,  /* (304) stream_options ::= stream_options TRIGGER AT_ONCE */
   397,  /* (305) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   397,  /* (306) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   397,  /* (307) stream_options ::= stream_options WATERMARK duration_literal */
   397,  /* (308) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   397,  /* (309) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   398,  /* (310) subtable_opt ::= */
   398,  /* (311) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   326,  /* (312) cmd ::= KILL CONNECTION NK_INTEGER */
   326,  /* (313) cmd ::= KILL QUERY NK_STRING */
   326,  /* (314) cmd ::= KILL TRANSACTION NK_INTEGER */
   326,  /* (315) cmd ::= BALANCE VGROUP */
   326,  /* (316) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   326,  /* (317) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   326,  /* (318) cmd ::= SPLIT VGROUP NK_INTEGER */
   400,  /* (319) dnode_list ::= DNODE NK_INTEGER */
   400,  /* (320) dnode_list ::= dnode_list DNODE NK_INTEGER */
   326,  /* (321) cmd ::= DELETE FROM full_table_name where_clause_opt */
   326,  /* (322) cmd ::= query_or_subquery */
   326,  /* (323) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   326,  /* (324) cmd ::= INSERT INTO full_table_name query_or_subquery */
   329,  /* (325) literal ::= NK_INTEGER */
   329,  /* (326) literal ::= NK_FLOAT */
   329,  /* (327) literal ::= NK_STRING */
   329,  /* (328) literal ::= NK_BOOL */
   329,  /* (329) literal ::= TIMESTAMP NK_STRING */
   329,  /* (330) literal ::= duration_literal */
   329,  /* (331) literal ::= NULL */
   329,  /* (332) literal ::= NK_QUESTION */
   373,  /* (333) duration_literal ::= NK_VARIABLE */
   402,  /* (334) signed ::= NK_INTEGER */
   402,  /* (335) signed ::= NK_PLUS NK_INTEGER */
   402,  /* (336) signed ::= NK_MINUS NK_INTEGER */
   402,  /* (337) signed ::= NK_FLOAT */
   402,  /* (338) signed ::= NK_PLUS NK_FLOAT */
   402,  /* (339) signed ::= NK_MINUS NK_FLOAT */
   362,  /* (340) signed_literal ::= signed */
   362,  /* (341) signed_literal ::= NK_STRING */
   362,  /* (342) signed_literal ::= NK_BOOL */
   362,  /* (343) signed_literal ::= TIMESTAMP NK_STRING */
   362,  /* (344) signed_literal ::= duration_literal */
   362,  /* (345) signed_literal ::= NULL */
   362,  /* (346) signed_literal ::= literal_func */
   362,  /* (347) signed_literal ::= NK_QUESTION */
   404,  /* (348) literal_list ::= signed_literal */
   404,  /* (349) literal_list ::= literal_list NK_COMMA signed_literal */
   337,  /* (350) db_name ::= NK_ID */
   368,  /* (351) table_name ::= NK_ID */
   360,  /* (352) column_name ::= NK_ID */
   375,  /* (353) function_name ::= NK_ID */
   405,  /* (354) table_alias ::= NK_ID */
   383,  /* (355) column_alias ::= NK_ID */
   331,  /* (356) user_name ::= NK_ID */
   338,  /* (357) topic_name ::= NK_ID */
   396,  /* (358) stream_name ::= NK_ID */
   391,  /* (359) cgroup_name ::= NK_ID */
   406,  /* (360) expr_or_subquery ::= expression */
   399,  /* (361) expression ::= literal */
   399,  /* (362) expression ::= pseudo_column */
   399,  /* (363) expression ::= column_reference */
   399,  /* (364) expression ::= function_expression */
   399,  /* (365) expression ::= case_when_expression */
   399,  /* (366) expression ::= NK_LP expression NK_RP */
   399,  /* (367) expression ::= NK_PLUS expr_or_subquery */
   399,  /* (368) expression ::= NK_MINUS expr_or_subquery */
   399,  /* (369) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   399,  /* (370) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   399,  /* (371) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   399,  /* (372) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   399,  /* (373) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   399,  /* (374) expression ::= column_reference NK_ARROW NK_STRING */
   399,  /* (375) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   399,  /* (376) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   365,  /* (377) expression_list ::= expr_or_subquery */
   365,  /* (378) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   408,  /* (379) column_reference ::= column_name */
   408,  /* (380) column_reference ::= table_name NK_DOT column_name */
   407,  /* (381) pseudo_column ::= ROWTS */
   407,  /* (382) pseudo_column ::= TBNAME */
   407,  /* (383) pseudo_column ::= table_name NK_DOT TBNAME */
   407,  /* (384) pseudo_column ::= QSTART */
   407,  /* (385) pseudo_column ::= QEND */
   407,  /* (386) pseudo_column ::= QDURATION */
   407,  /* (387) pseudo_column ::= WSTART */
   407,  /* (388) pseudo_column ::= WEND */
   407,  /* (389) pseudo_column ::= WDURATION */
   407,  /* (390) pseudo_column ::= IROWTS */
   407,  /* (391) pseudo_column ::= ISFILLED */
   407,  /* (392) pseudo_column ::= QTAGS */
   409,  /* (393) function_expression ::= function_name NK_LP expression_list NK_RP */
   409,  /* (394) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   409,  /* (395) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   409,  /* (396) function_expression ::= literal_func */
   403,  /* (397) literal_func ::= noarg_func NK_LP NK_RP */
   403,  /* (398) literal_func ::= NOW */
   413,  /* (399) noarg_func ::= NOW */
   413,  /* (400) noarg_func ::= TODAY */
   413,  /* (401) noarg_func ::= TIMEZONE */
   413,  /* (402) noarg_func ::= DATABASE */
   413,  /* (403) noarg_func ::= CLIENT_VERSION */
   413,  /* (404) noarg_func ::= SERVER_VERSION */
   413,  /* (405) noarg_func ::= SERVER_STATUS */
   413,  /* (406) noarg_func ::= CURRENT_USER */
   413,  /* (407) noarg_func ::= USER */
   411,  /* (408) star_func ::= COUNT */
   411,  /* (409) star_func ::= FIRST */
   411,  /* (410) star_func ::= LAST */
   411,  /* (411) star_func ::= LAST_ROW */
   412,  /* (412) star_func_para_list ::= NK_STAR */
   412,  /* (413) star_func_para_list ::= other_para_list */
   414,  /* (414) other_para_list ::= star_func_para */
   414,  /* (415) other_para_list ::= other_para_list NK_COMMA star_func_para */
   415,  /* (416) star_func_para ::= expr_or_subquery */
   415,  /* (417) star_func_para ::= table_name NK_DOT NK_STAR */
   410,  /* (418) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   410,  /* (419) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   416,  /* (420) when_then_list ::= when_then_expr */
   416,  /* (421) when_then_list ::= when_then_list when_then_expr */
   419,  /* (422) when_then_expr ::= WHEN common_expression THEN common_expression */
   417,  /* (423) case_when_else_opt ::= */
   417,  /* (424) case_when_else_opt ::= ELSE common_expression */
   420,  /* (425) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   420,  /* (426) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   420,  /* (427) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   420,  /* (428) predicate ::= expr_or_subquery IS NULL */
   420,  /* (429) predicate ::= expr_or_subquery IS NOT NULL */
   420,  /* (430) predicate ::= expr_or_subquery in_op in_predicate_value */
   421,  /* (431) compare_op ::= NK_LT */
   421,  /* (432) compare_op ::= NK_GT */
   421,  /* (433) compare_op ::= NK_LE */
   421,  /* (434) compare_op ::= NK_GE */
   421,  /* (435) compare_op ::= NK_NE */
   421,  /* (436) compare_op ::= NK_EQ */
   421,  /* (437) compare_op ::= LIKE */
   421,  /* (438) compare_op ::= NOT LIKE */
   421,  /* (439) compare_op ::= MATCH */
   421,  /* (440) compare_op ::= NMATCH */
   421,  /* (441) compare_op ::= CONTAINS */
   422,  /* (442) in_op ::= IN */
   422,  /* (443) in_op ::= NOT IN */
   423,  /* (444) in_predicate_value ::= NK_LP literal_list NK_RP */
   424,  /* (445) boolean_value_expression ::= boolean_primary */
   424,  /* (446) boolean_value_expression ::= NOT boolean_primary */
   424,  /* (447) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   424,  /* (448) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   425,  /* (449) boolean_primary ::= predicate */
   425,  /* (450) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   418,  /* (451) common_expression ::= expr_or_subquery */
   418,  /* (452) common_expression ::= boolean_value_expression */
   426,  /* (453) from_clause_opt ::= */
   426,  /* (454) from_clause_opt ::= FROM table_reference_list */
   427,  /* (455) table_reference_list ::= table_reference */
   427,  /* (456) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   428,  /* (457) table_reference ::= table_primary */
   428,  /* (458) table_reference ::= joined_table */
   429,  /* (459) table_primary ::= table_name alias_opt */
   429,  /* (460) table_primary ::= db_name NK_DOT table_name alias_opt */
   429,  /* (461) table_primary ::= subquery alias_opt */
   429,  /* (462) table_primary ::= parenthesized_joined_table */
   431,  /* (463) alias_opt ::= */
   431,  /* (464) alias_opt ::= table_alias */
   431,  /* (465) alias_opt ::= AS table_alias */
   433,  /* (466) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   433,  /* (467) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   430,  /* (468) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
   434,  /* (469) join_type ::= */
   434,  /* (470) join_type ::= INNER */
   436,  /* (471) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
   437,  /* (472) set_quantifier_opt ::= */
   437,  /* (473) set_quantifier_opt ::= DISTINCT */
   437,  /* (474) set_quantifier_opt ::= ALL */
   438,  /* (475) select_list ::= select_item */
   438,  /* (476) select_list ::= select_list NK_COMMA select_item */
   446,  /* (477) select_item ::= NK_STAR */
   446,  /* (478) select_item ::= common_expression */
   446,  /* (479) select_item ::= common_expression column_alias */
   446,  /* (480) select_item ::= common_expression AS column_alias */
   446,  /* (481) select_item ::= table_name NK_DOT NK_STAR */
   401,  /* (482) where_clause_opt ::= */
   401,  /* (483) where_clause_opt ::= WHERE search_condition */
   439,  /* (484) partition_by_clause_opt ::= */
   439,  /* (485) partition_by_clause_opt ::= PARTITION BY partition_list */
   447,  /* (486) partition_list ::= partition_item */
   447,  /* (487) partition_list ::= partition_list NK_COMMA partition_item */
   448,  /* (488) partition_item ::= expr_or_subquery */
   448,  /* (489) partition_item ::= expr_or_subquery column_alias */
   448,  /* (490) partition_item ::= expr_or_subquery AS column_alias */
   443,  /* (491) twindow_clause_opt ::= */
   443,  /* (492) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   443,  /* (493) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   443,  /* (494) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   443,  /* (495) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   443,  /* (496) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
   386,  /* (497) sliding_opt ::= */
   386,  /* (498) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
   442,  /* (499) fill_opt ::= */
   442,  /* (500) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   442,  /* (501) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
   449,  /* (502) fill_mode ::= NONE */
   449,  /* (503) fill_mode ::= PREV */
   449,  /* (504) fill_mode ::= NULL */
   449,  /* (505) fill_mode ::= LINEAR */
   449,  /* (506) fill_mode ::= NEXT */
   444,  /* (507) group_by_clause_opt ::= */
   444,  /* (508) group_by_clause_opt ::= GROUP BY group_by_list */
   450,  /* (509) group_by_list ::= expr_or_subquery */
   450,  /* (510) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
   445,  /* (511) having_clause_opt ::= */
   445,  /* (512) having_clause_opt ::= HAVING search_condition */
   440,  /* (513) range_opt ::= */
   440,  /* (514) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
   441,  /* (515) every_opt ::= */
   441,  /* (516) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   451,  /* (517) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   452,  /* (518) query_simple ::= query_specification */
   452,  /* (519) query_simple ::= union_query_expression */
   456,  /* (520) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   456,  /* (521) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   457,  /* (522) query_simple_or_subquery ::= query_simple */
   457,  /* (523) query_simple_or_subquery ::= subquery */
   390,  /* (524) query_or_subquery ::= query_expression */
   390,  /* (525) query_or_subquery ::= subquery */
   453,  /* (526) order_by_clause_opt ::= */
   453,  /* (527) order_by_clause_opt ::= ORDER BY sort_specification_list */
   454,  /* (528) slimit_clause_opt ::= */
   454,  /* (529) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   454,  /* (530) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   454,  /* (531) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   455,  /* (532) limit_clause_opt ::= */
   455,  /* (533) limit_clause_opt ::= LIMIT NK_INTEGER */
   455,  /* (534) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   455,  /* (535) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   432,  /* (536) subquery ::= NK_LP query_expression NK_RP */
   432,  /* (537) subquery ::= NK_LP subquery NK_RP */
   435,  /* (538) search_condition ::= common_expression */
   458,  /* (539) sort_specification_list ::= sort_specification */
   458,  /* (540) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   459,  /* (541) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
   460,  /* (542) ordering_specification_opt ::= */
   460,  /* (543) ordering_specification_opt ::= ASC */
   460,  /* (544) ordering_specification_opt ::= DESC */
   461,  /* (545) null_ordering_opt ::= */
   461,  /* (546) null_ordering_opt ::= NULLS FIRST */
   461,  /* (547) null_ordering_opt ::= NULLS LAST */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -6,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   -4,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
    0,  /* (2) account_options ::= */
   -3,  /* (3) account_options ::= account_options PPS literal */
   -3,  /* (4) account_options ::= account_options TSERIES literal */
   -3,  /* (5) account_options ::= account_options STORAGE literal */
   -3,  /* (6) account_options ::= account_options STREAMS literal */
   -3,  /* (7) account_options ::= account_options QTIME literal */
   -3,  /* (8) account_options ::= account_options DBS literal */
   -3,  /* (9) account_options ::= account_options USERS literal */
   -3,  /* (10) account_options ::= account_options CONNS literal */
   -3,  /* (11) account_options ::= account_options STATE literal */
   -1,  /* (12) alter_account_options ::= alter_account_option */
   -2,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   -2,  /* (14) alter_account_option ::= PASS literal */
   -2,  /* (15) alter_account_option ::= PPS literal */
   -2,  /* (16) alter_account_option ::= TSERIES literal */
   -2,  /* (17) alter_account_option ::= STORAGE literal */
   -2,  /* (18) alter_account_option ::= STREAMS literal */
   -2,  /* (19) alter_account_option ::= QTIME literal */
   -2,  /* (20) alter_account_option ::= DBS literal */
   -2,  /* (21) alter_account_option ::= USERS literal */
   -2,  /* (22) alter_account_option ::= CONNS literal */
   -2,  /* (23) alter_account_option ::= STATE literal */
   -6,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   -5,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   -5,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   -5,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   -3,  /* (28) cmd ::= DROP USER user_name */
    0,  /* (29) sysinfo_opt ::= */
   -2,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   -6,  /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
   -6,  /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
   -1,  /* (33) privileges ::= ALL */
   -1,  /* (34) privileges ::= priv_type_list */
   -1,  /* (35) privileges ::= SUBSCRIBE */
   -1,  /* (36) priv_type_list ::= priv_type */
   -3,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   -1,  /* (38) priv_type ::= READ */
   -1,  /* (39) priv_type ::= WRITE */
   -3,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   -3,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   -1,  /* (42) priv_level ::= topic_name */
   -3,  /* (43) cmd ::= CREATE DNODE dnode_endpoint */
   -5,  /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   -4,  /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
   -4,  /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
   -4,  /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   -5,  /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   -4,  /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
   -5,  /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   -1,  /* (51) dnode_endpoint ::= NK_STRING */
   -1,  /* (52) dnode_endpoint ::= NK_ID */
   -1,  /* (53) dnode_endpoint ::= NK_IPTOKEN */
    0,  /* (54) force_opt ::= */
   -1,  /* (55) force_opt ::= FORCE */
   -3,  /* (56) cmd ::= ALTER LOCAL NK_STRING */
   -4,  /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   -5,  /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   -5,  /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   -5,  /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   -5,  /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   -5,  /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   -5,  /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   -5,  /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   -5,  /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   -5,  /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   -4,  /* (67) cmd ::= DROP DATABASE exists_opt db_name */
   -2,  /* (68) cmd ::= USE db_name */
   -4,  /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
   -3,  /* (70) cmd ::= FLUSH DATABASE db_name */
   -4,  /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
   -3,  /* (72) not_exists_opt ::= IF NOT EXISTS */
    0,  /* (73) not_exists_opt ::= */
   -2,  /* (74) exists_opt ::= IF EXISTS */
    0,  /* (75) exists_opt ::= */
    0,  /* (76) db_options ::= */
   -3,  /* (77) db_options ::= db_options BUFFER NK_INTEGER */
   -3,  /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
   -3,  /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
   -3,  /* (80) db_options ::= db_options COMP NK_INTEGER */
   -3,  /* (81) db_options ::= db_options DURATION NK_INTEGER */
   -3,  /* (82) db_options ::= db_options DURATION NK_VARIABLE */
   -3,  /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
   -3,  /* (84) db_options ::= db_options MINROWS NK_INTEGER */
   -3,  /* (85) db_options ::= db_options KEEP integer_list */
   -3,  /* (86) db_options ::= db_options KEEP variable_list */
   -3,  /* (87) db_options ::= db_options PAGES NK_INTEGER */
   -3,  /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
   -3,  /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   -3,  /* (90) db_options ::= db_options PRECISION NK_STRING */
   -3,  /* (91) db_options ::= db_options REPLICA NK_INTEGER */
   -3,  /* (92) db_options ::= db_options VGROUPS NK_INTEGER */
   -3,  /* (93) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   -3,  /* (94) db_options ::= db_options RETENTIONS retention_list */
   -3,  /* (95) db_options ::= db_options SCHEMALESS NK_INTEGER */
   -3,  /* (96) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   -3,  /* (97) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   -3,  /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   -4,  /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -3,  /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   -4,  /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -3,  /* (102) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   -3,  /* (103) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   -3,  /* (104) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   -3,  /* (105) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
   -3,  /* (106) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
   -1,  /* (107) alter_db_options ::= alter_db_option */
   -2,  /* (108) alter_db_options ::= alter_db_options alter_db_option */
   -2,  /* (109) alter_db_option ::= BUFFER NK_INTEGER */
   -2,  /* (110) alter_db_option ::= CACHEMODEL NK_STRING */
   -2,  /* (111) alter_db_option ::= CACHESIZE NK_INTEGER */
   -2,  /* (112) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   -2,  /* (113) alter_db_option ::= KEEP integer_list */
   -2,  /* (114) alter_db_option ::= KEEP variable_list */
   -2,  /* (115) alter_db_option ::= PAGES NK_INTEGER */
   -2,  /* (116) alter_db_option ::= REPLICA NK_INTEGER */
   -2,  /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   -2,  /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   -1,  /* (119) integer_list ::= NK_INTEGER */
   -3,  /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   -1,  /* (121) variable_list ::= NK_VARIABLE */
   -3,  /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   -1,  /* (123) retention_list ::= retention */
   -3,  /* (124) retention_list ::= retention_list NK_COMMA retention */
   -3,  /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
    0,  /* (126) speed_opt ::= */
   -2,  /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
   -9,  /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   -3,  /* (129) cmd ::= CREATE TABLE multi_create_clause */
   -9,  /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   -3,  /* (131) cmd ::= DROP TABLE multi_drop_clause */
   -4,  /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
   -3,  /* (133) cmd ::= ALTER TABLE alter_table_clause */
   -3,  /* (134) cmd ::= ALTER STABLE alter_table_clause */
   -2,  /* (135) alter_table_clause ::= full_table_name alter_table_options */
   -5,  /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   -4,  /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   -5,  /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   -5,  /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   -5,  /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   -4,  /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
   -5,  /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   -5,  /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   -6,  /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   -1,  /* (145) multi_create_clause ::= create_subtable_clause */
   -2,  /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
  -10,  /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   -1,  /* (148) multi_drop_clause ::= drop_table_clause */
   -2,  /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
   -2,  /* (150) drop_table_clause ::= exists_opt full_table_name */
    0,  /* (151) specific_cols_opt ::= */
   -3,  /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   -1,  /* (153) full_table_name ::= table_name */
   -3,  /* (154) full_table_name ::= db_name NK_DOT table_name */
   -1,  /* (155) column_def_list ::= column_def */
   -3,  /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
   -2,  /* (157) column_def ::= column_name type_name */
   -4,  /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
   -1,  /* (159) type_name ::= BOOL */
   -1,  /* (160) type_name ::= TINYINT */
   -1,  /* (161) type_name ::= SMALLINT */
   -1,  /* (162) type_name ::= INT */
   -1,  /* (163) type_name ::= INTEGER */
   -1,  /* (164) type_name ::= BIGINT */
   -1,  /* (165) type_name ::= FLOAT */
   -1,  /* (166) type_name ::= DOUBLE */
   -4,  /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (168) type_name ::= TIMESTAMP */
   -4,  /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   -2,  /* (170) type_name ::= TINYINT UNSIGNED */
   -2,  /* (171) type_name ::= SMALLINT UNSIGNED */
   -2,  /* (172) type_name ::= INT UNSIGNED */
   -2,  /* (173) type_name ::= BIGINT UNSIGNED */
   -1,  /* (174) type_name ::= JSON */
   -4,  /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   -1,  /* (176) type_name ::= MEDIUMBLOB */
   -1,  /* (177) type_name ::= BLOB */
   -4,  /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (179) type_name ::= DECIMAL */
   -4,  /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   -6,  /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
    0,  /* (182) tags_def_opt ::= */
   -1,  /* (183) tags_def_opt ::= tags_def */
   -4,  /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
    0,  /* (185) table_options ::= */
   -3,  /* (186) table_options ::= table_options COMMENT NK_STRING */
   -3,  /* (187) table_options ::= table_options MAX_DELAY duration_list */
   -3,  /* (188) table_options ::= table_options WATERMARK duration_list */
   -5,  /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   -3,  /* (190) table_options ::= table_options TTL NK_INTEGER */
   -5,  /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   -3,  /* (192) table_options ::= table_options DELETE_MARK duration_list */
   -1,  /* (193) alter_table_options ::= alter_table_option */
   -2,  /* (194) alter_table_options ::= alter_table_options alter_table_option */
   -2,  /* (195) alter_table_option ::= COMMENT NK_STRING */
   -2,  /* (196) alter_table_option ::= TTL NK_INTEGER */
   -1,  /* (197) duration_list ::= duration_literal */
   -3,  /* (198) duration_list ::= duration_list NK_COMMA duration_literal */
   -1,  /* (199) rollup_func_list ::= rollup_func_name */
   -3,  /* (200) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   -1,  /* (201) rollup_func_name ::= function_name */
   -1,  /* (202) rollup_func_name ::= FIRST */
   -1,  /* (203) rollup_func_name ::= LAST */
   -1,  /* (204) col_name_list ::= col_name */
   -3,  /* (205) col_name_list ::= col_name_list NK_COMMA col_name */
   -1,  /* (206) col_name ::= column_name */
   -2,  /* (207) cmd ::= SHOW DNODES */
   -2,  /* (208) cmd ::= SHOW USERS */
   -3,  /* (209) cmd ::= SHOW USER PRIVILEGES */
   -2,  /* (210) cmd ::= SHOW DATABASES */
   -4,  /* (211) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   -4,  /* (212) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   -3,  /* (213) cmd ::= SHOW db_name_cond_opt VGROUPS */
   -2,  /* (214) cmd ::= SHOW MNODES */
   -2,  /* (215) cmd ::= SHOW QNODES */
   -2,  /* (216) cmd ::= SHOW FUNCTIONS */
   -5,  /* (217) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   -2,  /* (218) cmd ::= SHOW STREAMS */
   -2,  /* (219) cmd ::= SHOW ACCOUNTS */
   -2,  /* (220) cmd ::= SHOW APPS */
   -2,  /* (221) cmd ::= SHOW CONNECTIONS */
   -2,  /* (222) cmd ::= SHOW LICENCES */
   -2,  /* (223) cmd ::= SHOW GRANTS */
   -4,  /* (224) cmd ::= SHOW CREATE DATABASE db_name */
   -4,  /* (225) cmd ::= SHOW CREATE TABLE full_table_name */
   -4,  /* (226) cmd ::= SHOW CREATE STABLE full_table_name */
   -2,  /* (227) cmd ::= SHOW QUERIES */
   -2,  /* (228) cmd ::= SHOW SCORES */
   -2,  /* (229) cmd ::= SHOW TOPICS */
   -2,  /* (230) cmd ::= SHOW VARIABLES */
   -3,  /* (231) cmd ::= SHOW CLUSTER VARIABLES */
   -3,  /* (232) cmd ::= SHOW LOCAL VARIABLES */
   -5,  /* (233) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   -2,  /* (234) cmd ::= SHOW BNODES */
   -2,  /* (235) cmd ::= SHOW SNODES */
   -2,  /* (236) cmd ::= SHOW CLUSTER */
   -2,  /* (237) cmd ::= SHOW TRANSACTIONS */
   -4,  /* (238) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   -2,  /* (239) cmd ::= SHOW CONSUMERS */
   -2,  /* (240) cmd ::= SHOW SUBSCRIPTIONS */
   -5,  /* (241) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   -7,  /* (242) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   -3,  /* (243) cmd ::= SHOW VNODES NK_INTEGER */
   -3,  /* (244) cmd ::= SHOW VNODES NK_STRING */
   -3,  /* (245) cmd ::= SHOW db_name_cond_opt ALIVE */
   -3,  /* (246) cmd ::= SHOW CLUSTER ALIVE */
    0,  /* (247) db_name_cond_opt ::= */
   -2,  /* (248) db_name_cond_opt ::= db_name NK_DOT */
    0,  /* (249) like_pattern_opt ::= */
   -2,  /* (250) like_pattern_opt ::= LIKE NK_STRING */
   -1,  /* (251) table_name_cond ::= table_name */
    0,  /* (252) from_db_opt ::= */
   -2,  /* (253) from_db_opt ::= FROM db_name */
    0,  /* (254) tag_list_opt ::= */
   -1,  /* (255) tag_list_opt ::= tag_item */
   -3,  /* (256) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   -1,  /* (257) tag_item ::= TBNAME */
   -1,  /* (258) tag_item ::= QTAGS */
   -1,  /* (259) tag_item ::= column_name */
   -2,  /* (260) tag_item ::= column_name column_alias */
   -3,  /* (261) tag_item ::= column_name AS column_alias */
   -8,  /* (262) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
   -9,  /* (263) cmd ::= CREATE INDEX not_exists_opt full_table_name ON full_table_name NK_LP col_name_list NK_RP */
   -4,  /* (264) cmd ::= DROP INDEX exists_opt full_table_name */
  -10,  /* (265) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  -12,  /* (266) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   -1,  /* (267) func_list ::= func */
   -3,  /* (268) func_list ::= func_list NK_COMMA func */
   -4,  /* (269) func ::= sma_func_name NK_LP expression_list NK_RP */
   -1,  /* (270) sma_func_name ::= function_name */
   -1,  /* (271) sma_func_name ::= COUNT */
   -1,  /* (272) sma_func_name ::= FIRST */
   -1,  /* (273) sma_func_name ::= LAST */
   -1,  /* (274) sma_func_name ::= LAST_ROW */
    0,  /* (275) sma_stream_opt ::= */
   -3,  /* (276) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   -3,  /* (277) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   -3,  /* (278) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   -6,  /* (279) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   -7,  /* (280) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   -9,  /* (281) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   -7,  /* (282) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   -9,  /* (283) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   -4,  /* (284) cmd ::= DROP TOPIC exists_opt topic_name */
   -7,  /* (285) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   -2,  /* (286) cmd ::= DESC full_table_name */
   -2,  /* (287) cmd ::= DESCRIBE full_table_name */
   -3,  /* (288) cmd ::= RESET QUERY CACHE */
   -4,  /* (289) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
    0,  /* (290) analyze_opt ::= */
   -1,  /* (291) analyze_opt ::= ANALYZE */
    0,  /* (292) explain_options ::= */
   -3,  /* (293) explain_options ::= explain_options VERBOSE NK_BOOL */
   -3,  /* (294) explain_options ::= explain_options RATIO NK_FLOAT */
  -10,  /* (295) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
   -4,  /* (296) cmd ::= DROP FUNCTION exists_opt function_name */
    0,  /* (297) agg_func_opt ::= */
   -1,  /* (298) agg_func_opt ::= AGGREGATE */
    0,  /* (299) bufsize_opt ::= */
   -2,  /* (300) bufsize_opt ::= BUFSIZE NK_INTEGER */
  -11,  /* (301) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
   -4,  /* (302) cmd ::= DROP STREAM exists_opt stream_name */
    0,  /* (303) stream_options ::= */
   -3,  /* (304) stream_options ::= stream_options TRIGGER AT_ONCE */
   -3,  /* (305) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   -4,  /* (306) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   -3,  /* (307) stream_options ::= stream_options WATERMARK duration_literal */
   -4,  /* (308) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   -3,  /* (309) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
    0,  /* (310) subtable_opt ::= */
   -4,  /* (311) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   -3,  /* (312) cmd ::= KILL CONNECTION NK_INTEGER */
   -3,  /* (313) cmd ::= KILL QUERY NK_STRING */
   -3,  /* (314) cmd ::= KILL TRANSACTION NK_INTEGER */
   -2,  /* (315) cmd ::= BALANCE VGROUP */
   -4,  /* (316) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   -4,  /* (317) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   -3,  /* (318) cmd ::= SPLIT VGROUP NK_INTEGER */
   -2,  /* (319) dnode_list ::= DNODE NK_INTEGER */
   -3,  /* (320) dnode_list ::= dnode_list DNODE NK_INTEGER */
   -4,  /* (321) cmd ::= DELETE FROM full_table_name where_clause_opt */
   -1,  /* (322) cmd ::= query_or_subquery */
   -7,  /* (323) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   -4,  /* (324) cmd ::= INSERT INTO full_table_name query_or_subquery */
   -1,  /* (325) literal ::= NK_INTEGER */
   -1,  /* (326) literal ::= NK_FLOAT */
   -1,  /* (327) literal ::= NK_STRING */
   -1,  /* (328) literal ::= NK_BOOL */
   -2,  /* (329) literal ::= TIMESTAMP NK_STRING */
   -1,  /* (330) literal ::= duration_literal */
   -1,  /* (331) literal ::= NULL */
   -1,  /* (332) literal ::= NK_QUESTION */
   -1,  /* (333) duration_literal ::= NK_VARIABLE */
   -1,  /* (334) signed ::= NK_INTEGER */
   -2,  /* (335) signed ::= NK_PLUS NK_INTEGER */
   -2,  /* (336) signed ::= NK_MINUS NK_INTEGER */
   -1,  /* (337) signed ::= NK_FLOAT */
   -2,  /* (338) signed ::= NK_PLUS NK_FLOAT */
   -2,  /* (339) signed ::= NK_MINUS NK_FLOAT */
   -1,  /* (340) signed_literal ::= signed */
   -1,  /* (341) signed_literal ::= NK_STRING */
   -1,  /* (342) signed_literal ::= NK_BOOL */
   -2,  /* (343) signed_literal ::= TIMESTAMP NK_STRING */
   -1,  /* (344) signed_literal ::= duration_literal */
   -1,  /* (345) signed_literal ::= NULL */
   -1,  /* (346) signed_literal ::= literal_func */
   -1,  /* (347) signed_literal ::= NK_QUESTION */
   -1,  /* (348) literal_list ::= signed_literal */
   -3,  /* (349) literal_list ::= literal_list NK_COMMA signed_literal */
   -1,  /* (350) db_name ::= NK_ID */
   -1,  /* (351) table_name ::= NK_ID */
   -1,  /* (352) column_name ::= NK_ID */
   -1,  /* (353) function_name ::= NK_ID */
   -1,  /* (354) table_alias ::= NK_ID */
   -1,  /* (355) column_alias ::= NK_ID */
   -1,  /* (356) user_name ::= NK_ID */
   -1,  /* (357) topic_name ::= NK_ID */
   -1,  /* (358) stream_name ::= NK_ID */
   -1,  /* (359) cgroup_name ::= NK_ID */
   -1,  /* (360) expr_or_subquery ::= expression */
   -1,  /* (361) expression ::= literal */
   -1,  /* (362) expression ::= pseudo_column */
   -1,  /* (363) expression ::= column_reference */
   -1,  /* (364) expression ::= function_expression */
   -1,  /* (365) expression ::= case_when_expression */
   -3,  /* (366) expression ::= NK_LP expression NK_RP */
   -2,  /* (367) expression ::= NK_PLUS expr_or_subquery */
   -2,  /* (368) expression ::= NK_MINUS expr_or_subquery */
   -3,  /* (369) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   -3,  /* (370) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   -3,  /* (371) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   -3,  /* (372) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   -3,  /* (373) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   -3,  /* (374) expression ::= column_reference NK_ARROW NK_STRING */
   -3,  /* (375) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   -3,  /* (376) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   -1,  /* (377) expression_list ::= expr_or_subquery */
   -3,  /* (378) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   -1,  /* (379) column_reference ::= column_name */
   -3,  /* (380) column_reference ::= table_name NK_DOT column_name */
   -1,  /* (381) pseudo_column ::= ROWTS */
   -1,  /* (382) pseudo_column ::= TBNAME */
   -3,  /* (383) pseudo_column ::= table_name NK_DOT TBNAME */
   -1,  /* (384) pseudo_column ::= QSTART */
   -1,  /* (385) pseudo_column ::= QEND */
   -1,  /* (386) pseudo_column ::= QDURATION */
   -1,  /* (387) pseudo_column ::= WSTART */
   -1,  /* (388) pseudo_column ::= WEND */
   -1,  /* (389) pseudo_column ::= WDURATION */
   -1,  /* (390) pseudo_column ::= IROWTS */
   -1,  /* (391) pseudo_column ::= ISFILLED */
   -1,  /* (392) pseudo_column ::= QTAGS */
   -4,  /* (393) function_expression ::= function_name NK_LP expression_list NK_RP */
   -4,  /* (394) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   -6,  /* (395) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   -1,  /* (396) function_expression ::= literal_func */
   -3,  /* (397) literal_func ::= noarg_func NK_LP NK_RP */
   -1,  /* (398) literal_func ::= NOW */
   -1,  /* (399) noarg_func ::= NOW */
   -1,  /* (400) noarg_func ::= TODAY */
   -1,  /* (401) noarg_func ::= TIMEZONE */
   -1,  /* (402) noarg_func ::= DATABASE */
   -1,  /* (403) noarg_func ::= CLIENT_VERSION */
   -1,  /* (404) noarg_func ::= SERVER_VERSION */
   -1,  /* (405) noarg_func ::= SERVER_STATUS */
   -1,  /* (406) noarg_func ::= CURRENT_USER */
   -1,  /* (407) noarg_func ::= USER */
   -1,  /* (408) star_func ::= COUNT */
   -1,  /* (409) star_func ::= FIRST */
   -1,  /* (410) star_func ::= LAST */
   -1,  /* (411) star_func ::= LAST_ROW */
   -1,  /* (412) star_func_para_list ::= NK_STAR */
   -1,  /* (413) star_func_para_list ::= other_para_list */
   -1,  /* (414) other_para_list ::= star_func_para */
   -3,  /* (415) other_para_list ::= other_para_list NK_COMMA star_func_para */
   -1,  /* (416) star_func_para ::= expr_or_subquery */
   -3,  /* (417) star_func_para ::= table_name NK_DOT NK_STAR */
   -4,  /* (418) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   -5,  /* (419) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   -1,  /* (420) when_then_list ::= when_then_expr */
   -2,  /* (421) when_then_list ::= when_then_list when_then_expr */
   -4,  /* (422) when_then_expr ::= WHEN common_expression THEN common_expression */
    0,  /* (423) case_when_else_opt ::= */
   -2,  /* (424) case_when_else_opt ::= ELSE common_expression */
   -3,  /* (425) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   -5,  /* (426) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   -6,  /* (427) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   -3,  /* (428) predicate ::= expr_or_subquery IS NULL */
   -4,  /* (429) predicate ::= expr_or_subquery IS NOT NULL */
   -3,  /* (430) predicate ::= expr_or_subquery in_op in_predicate_value */
   -1,  /* (431) compare_op ::= NK_LT */
   -1,  /* (432) compare_op ::= NK_GT */
   -1,  /* (433) compare_op ::= NK_LE */
   -1,  /* (434) compare_op ::= NK_GE */
   -1,  /* (435) compare_op ::= NK_NE */
   -1,  /* (436) compare_op ::= NK_EQ */
   -1,  /* (437) compare_op ::= LIKE */
   -2,  /* (438) compare_op ::= NOT LIKE */
   -1,  /* (439) compare_op ::= MATCH */
   -1,  /* (440) compare_op ::= NMATCH */
   -1,  /* (441) compare_op ::= CONTAINS */
   -1,  /* (442) in_op ::= IN */
   -2,  /* (443) in_op ::= NOT IN */
   -3,  /* (444) in_predicate_value ::= NK_LP literal_list NK_RP */
   -1,  /* (445) boolean_value_expression ::= boolean_primary */
   -2,  /* (446) boolean_value_expression ::= NOT boolean_primary */
   -3,  /* (447) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   -3,  /* (448) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   -1,  /* (449) boolean_primary ::= predicate */
   -3,  /* (450) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   -1,  /* (451) common_expression ::= expr_or_subquery */
   -1,  /* (452) common_expression ::= boolean_value_expression */
    0,  /* (453) from_clause_opt ::= */
   -2,  /* (454) from_clause_opt ::= FROM table_reference_list */
   -1,  /* (455) table_reference_list ::= table_reference */
   -3,  /* (456) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   -1,  /* (457) table_reference ::= table_primary */
   -1,  /* (458) table_reference ::= joined_table */
   -2,  /* (459) table_primary ::= table_name alias_opt */
   -4,  /* (460) table_primary ::= db_name NK_DOT table_name alias_opt */
   -2,  /* (461) table_primary ::= subquery alias_opt */
   -1,  /* (462) table_primary ::= parenthesized_joined_table */
    0,  /* (463) alias_opt ::= */
   -1,  /* (464) alias_opt ::= table_alias */
   -2,  /* (465) alias_opt ::= AS table_alias */
   -3,  /* (466) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   -3,  /* (467) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   -6,  /* (468) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
    0,  /* (469) join_type ::= */
   -1,  /* (470) join_type ::= INNER */
  -12,  /* (471) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
    0,  /* (472) set_quantifier_opt ::= */
   -1,  /* (473) set_quantifier_opt ::= DISTINCT */
   -1,  /* (474) set_quantifier_opt ::= ALL */
   -1,  /* (475) select_list ::= select_item */
   -3,  /* (476) select_list ::= select_list NK_COMMA select_item */
   -1,  /* (477) select_item ::= NK_STAR */
   -1,  /* (478) select_item ::= common_expression */
   -2,  /* (479) select_item ::= common_expression column_alias */
   -3,  /* (480) select_item ::= common_expression AS column_alias */
   -3,  /* (481) select_item ::= table_name NK_DOT NK_STAR */
    0,  /* (482) where_clause_opt ::= */
   -2,  /* (483) where_clause_opt ::= WHERE search_condition */
    0,  /* (484) partition_by_clause_opt ::= */
   -3,  /* (485) partition_by_clause_opt ::= PARTITION BY partition_list */
   -1,  /* (486) partition_list ::= partition_item */
   -3,  /* (487) partition_list ::= partition_list NK_COMMA partition_item */
   -1,  /* (488) partition_item ::= expr_or_subquery */
   -2,  /* (489) partition_item ::= expr_or_subquery column_alias */
   -3,  /* (490) partition_item ::= expr_or_subquery AS column_alias */
    0,  /* (491) twindow_clause_opt ::= */
   -6,  /* (492) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   -4,  /* (493) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   -6,  /* (494) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   -8,  /* (495) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   -7,  /* (496) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
    0,  /* (497) sliding_opt ::= */
   -4,  /* (498) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
    0,  /* (499) fill_opt ::= */
   -4,  /* (500) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   -6,  /* (501) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
   -1,  /* (502) fill_mode ::= NONE */
   -1,  /* (503) fill_mode ::= PREV */
   -1,  /* (504) fill_mode ::= NULL */
   -1,  /* (505) fill_mode ::= LINEAR */
   -1,  /* (506) fill_mode ::= NEXT */
    0,  /* (507) group_by_clause_opt ::= */
   -3,  /* (508) group_by_clause_opt ::= GROUP BY group_by_list */
   -1,  /* (509) group_by_list ::= expr_or_subquery */
   -3,  /* (510) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
    0,  /* (511) having_clause_opt ::= */
   -2,  /* (512) having_clause_opt ::= HAVING search_condition */
    0,  /* (513) range_opt ::= */
   -6,  /* (514) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
    0,  /* (515) every_opt ::= */
   -4,  /* (516) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   -4,  /* (517) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   -1,  /* (518) query_simple ::= query_specification */
   -1,  /* (519) query_simple ::= union_query_expression */
   -4,  /* (520) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   -3,  /* (521) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   -1,  /* (522) query_simple_or_subquery ::= query_simple */
   -1,  /* (523) query_simple_or_subquery ::= subquery */
   -1,  /* (524) query_or_subquery ::= query_expression */
   -1,  /* (525) query_or_subquery ::= subquery */
    0,  /* (526) order_by_clause_opt ::= */
   -3,  /* (527) order_by_clause_opt ::= ORDER BY sort_specification_list */
    0,  /* (528) slimit_clause_opt ::= */
   -2,  /* (529) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   -4,  /* (530) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   -4,  /* (531) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
    0,  /* (532) limit_clause_opt ::= */
   -2,  /* (533) limit_clause_opt ::= LIMIT NK_INTEGER */
   -4,  /* (534) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   -4,  /* (535) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   -3,  /* (536) subquery ::= NK_LP query_expression NK_RP */
   -3,  /* (537) subquery ::= NK_LP subquery NK_RP */
   -1,  /* (538) search_condition ::= common_expression */
   -1,  /* (539) sort_specification_list ::= sort_specification */
   -3,  /* (540) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   -3,  /* (541) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
    0,  /* (542) ordering_specification_opt ::= */
   -1,  /* (543) ordering_specification_opt ::= ASC */
   -1,  /* (544) ordering_specification_opt ::= DESC */
    0,  /* (545) null_ordering_opt ::= */
   -2,  /* (546) null_ordering_opt ::= NULLS FIRST */
   -2,  /* (547) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,327,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,328,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,327,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,330,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,328,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,330,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy701, &yymsp[-1].minor.yy0, yymsp[0].minor.yy47); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy701, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy701, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy701, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy701); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy47 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy47 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy921, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy701); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy921, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy701); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy921 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy921 = yymsp[0].minor.yy921; }
  yymsp[0].minor.yy921 = yylhsminor.yy921;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy921 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy921 = yymsp[-2].minor.yy921 | yymsp[0].minor.yy921; }
  yymsp[-2].minor.yy921 = yylhsminor.yy921;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy921 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy921 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy701 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy701 = yylhsminor.yy701;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy701 = yymsp[-2].minor.yy701; }
  yymsp[-2].minor.yy701 = yylhsminor.yy701;
        break;
      case 42: /* priv_level ::= topic_name */
      case 270: /* sma_func_name ::= function_name */ yytestcase(yyruleno==270);
      case 464: /* alias_opt ::= table_alias */ yytestcase(yyruleno==464);
{ yylhsminor.yy701 = yymsp[0].minor.yy701; }
  yymsp[0].minor.yy701 = yylhsminor.yy701;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy701, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy845); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy701, yymsp[0].minor.yy845); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 271: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==271);
      case 272: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==272);
      case 273: /* sma_func_name ::= LAST */ yytestcase(yyruleno==273);
      case 274: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==274);
      case 350: /* db_name ::= NK_ID */ yytestcase(yyruleno==350);
      case 351: /* table_name ::= NK_ID */ yytestcase(yyruleno==351);
      case 352: /* column_name ::= NK_ID */ yytestcase(yyruleno==352);
      case 353: /* function_name ::= NK_ID */ yytestcase(yyruleno==353);
      case 354: /* table_alias ::= NK_ID */ yytestcase(yyruleno==354);
      case 355: /* column_alias ::= NK_ID */ yytestcase(yyruleno==355);
      case 356: /* user_name ::= NK_ID */ yytestcase(yyruleno==356);
      case 357: /* topic_name ::= NK_ID */ yytestcase(yyruleno==357);
      case 358: /* stream_name ::= NK_ID */ yytestcase(yyruleno==358);
      case 359: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==359);
      case 399: /* noarg_func ::= NOW */ yytestcase(yyruleno==399);
      case 400: /* noarg_func ::= TODAY */ yytestcase(yyruleno==400);
      case 401: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==401);
      case 402: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==402);
      case 403: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==403);
      case 404: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==404);
      case 405: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==405);
      case 406: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==406);
      case 407: /* noarg_func ::= USER */ yytestcase(yyruleno==407);
      case 408: /* star_func ::= COUNT */ yytestcase(yyruleno==408);
      case 409: /* star_func ::= FIRST */ yytestcase(yyruleno==409);
      case 410: /* star_func ::= LAST */ yytestcase(yyruleno==410);
      case 411: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==411);
{ yylhsminor.yy701 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy701 = yylhsminor.yy701;
        break;
      case 54: /* force_opt ::= */
      case 73: /* not_exists_opt ::= */ yytestcase(yyruleno==73);
      case 75: /* exists_opt ::= */ yytestcase(yyruleno==75);
      case 290: /* analyze_opt ::= */ yytestcase(yyruleno==290);
      case 297: /* agg_func_opt ::= */ yytestcase(yyruleno==297);
      case 472: /* set_quantifier_opt ::= */ yytestcase(yyruleno==472);
{ yymsp[1].minor.yy845 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 291: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==291);
      case 298: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==298);
      case 473: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==473);
{ yymsp[0].minor.yy845 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy845, &yymsp[-1].minor.yy701, yymsp[0].minor.yy476); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy845, &yymsp[0].minor.yy701); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy701); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy701, yymsp[0].minor.yy476); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy701); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy701, yymsp[0].minor.yy508); }
        break;
      case 72: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy845 = true; }
        break;
      case 74: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy845 = true; }
        break;
      case 76: /* db_options ::= */
{ yymsp[1].minor.yy476 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 77: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 78: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 79: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 80: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 81: /* db_options ::= db_options DURATION NK_INTEGER */
      case 82: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==82);
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 83: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 84: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 85: /* db_options ::= db_options KEEP integer_list */
      case 86: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==86);
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_KEEP, yymsp[0].minor.yy376); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 87: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 88: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 89: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 90: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 91: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 92: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 93: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 94: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_RETENTIONS, yymsp[0].minor.yy376); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 95: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 96: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 97: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-3].minor.yy476, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-3].minor.yy476, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 102: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 103: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 104: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 105: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 106: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 107: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy476 = createAlterDatabaseOptions(pCxt); yylhsminor.yy476 = setAlterDatabaseOption(pCxt, yylhsminor.yy476, &yymsp[0].minor.yy893); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 108: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy476 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy476, &yymsp[0].minor.yy893); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 109: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy893.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy893.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy893.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy893.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= KEEP integer_list */
      case 114: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==114);
{ yymsp[-1].minor.yy893.type = DB_OPTION_KEEP; yymsp[-1].minor.yy893.pList = yymsp[0].minor.yy376; }
        break;
      case 115: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy893.type = DB_OPTION_PAGES; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy893.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy893.type = DB_OPTION_WAL; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy893.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy376 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 120: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 320: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==320);
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 121: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy376 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 122: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 123: /* retention_list ::= retention */
      case 145: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==145);
      case 148: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==148);
      case 155: /* column_def_list ::= column_def */ yytestcase(yyruleno==155);
      case 199: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==199);
      case 204: /* col_name_list ::= col_name */ yytestcase(yyruleno==204);
      case 255: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==255);
      case 267: /* func_list ::= func */ yytestcase(yyruleno==267);
      case 348: /* literal_list ::= signed_literal */ yytestcase(yyruleno==348);
      case 414: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==414);
      case 420: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==420);
      case 475: /* select_list ::= select_item */ yytestcase(yyruleno==475);
      case 486: /* partition_list ::= partition_item */ yytestcase(yyruleno==486);
      case 539: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==539);
{ yylhsminor.yy376 = createNodeList(pCxt, yymsp[0].minor.yy476); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 124: /* retention_list ::= retention_list NK_COMMA retention */
      case 156: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==205);
      case 256: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==256);
      case 268: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==268);
      case 349: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==349);
      case 415: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==415);
      case 476: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==476);
      case 487: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==487);
      case 540: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==540);
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, yymsp[0].minor.yy476); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 125: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy476 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 126: /* speed_opt ::= */
      case 299: /* bufsize_opt ::= */ yytestcase(yyruleno==299);
{ yymsp[1].minor.yy508 = 0; }
        break;
      case 127: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 300: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==300);
{ yymsp[-1].minor.yy508 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 128: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 130: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==130);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy845, yymsp[-5].minor.yy476, yymsp[-3].minor.yy376, yymsp[-1].minor.yy376, yymsp[0].minor.yy476); }
        break;
      case 129: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy376); }
        break;
      case 131: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy376); }
        break;
      case 132: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy845, yymsp[0].minor.yy476); }
        break;
      case 133: /* cmd ::= ALTER TABLE alter_table_clause */
      case 322: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==322);
{ pCxt->pRootNode = yymsp[0].minor.yy476; }
        break;
      case 134: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy476); }
        break;
      case 135: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy476 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy476, yymsp[0].minor.yy476); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy476 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy476, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy701, yymsp[0].minor.yy532); }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy476 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy476, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy701); }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy476 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy476, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy701, yymsp[0].minor.yy532); }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy476 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy476, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy701, &yymsp[0].minor.yy701); }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 140: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy476 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy476, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy701, yymsp[0].minor.yy532); }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 141: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy476 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy476, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy701); }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 142: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy476 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy476, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy701, yymsp[0].minor.yy532); }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 143: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy476 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy476, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy701, &yymsp[0].minor.yy701); }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 144: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy476 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy476, &yymsp[-2].minor.yy701, yymsp[0].minor.yy476); }
  yymsp[-5].minor.yy476 = yylhsminor.yy476;
        break;
      case 146: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 149: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==149);
      case 421: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==421);
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-1].minor.yy376, yymsp[0].minor.yy476); }
  yymsp[-1].minor.yy376 = yylhsminor.yy376;
        break;
      case 147: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy476 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy845, yymsp[-8].minor.yy476, yymsp[-6].minor.yy476, yymsp[-5].minor.yy376, yymsp[-2].minor.yy376, yymsp[0].minor.yy476); }
  yymsp[-9].minor.yy476 = yylhsminor.yy476;
        break;
      case 150: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy476 = createDropTableClause(pCxt, yymsp[-1].minor.yy845, yymsp[0].minor.yy476); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 151: /* specific_cols_opt ::= */
      case 182: /* tags_def_opt ::= */ yytestcase(yyruleno==182);
      case 254: /* tag_list_opt ::= */ yytestcase(yyruleno==254);
      case 484: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==484);
      case 507: /* group_by_clause_opt ::= */ yytestcase(yyruleno==507);
      case 526: /* order_by_clause_opt ::= */ yytestcase(yyruleno==526);
{ yymsp[1].minor.yy376 = NULL; }
        break;
      case 152: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy376 = yymsp[-1].minor.yy376; }
        break;
      case 153: /* full_table_name ::= table_name */
{ yylhsminor.yy476 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy701, NULL); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 154: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy476 = createRealTableNode(pCxt, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy701, NULL); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 157: /* column_def ::= column_name type_name */
{ yylhsminor.yy476 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy701, yymsp[0].minor.yy532, NULL); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 158: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy476 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy701, yymsp[-2].minor.yy532, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 159: /* type_name ::= BOOL */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 160: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 161: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 162: /* type_name ::= INT */
      case 163: /* type_name ::= INTEGER */ yytestcase(yyruleno==163);
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 164: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 165: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 166: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 167: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy532 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 169: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy532 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy532 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy532 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 172: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy532 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 173: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy532 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 174: /* type_name ::= JSON */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 175: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy532 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 176: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 177: /* type_name ::= BLOB */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 178: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy532 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 180: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy532 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy532 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* tags_def_opt ::= tags_def */
      case 413: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==413);
{ yylhsminor.yy376 = yymsp[0].minor.yy376; }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 184: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy376 = yymsp[-1].minor.yy376; }
        break;
      case 185: /* table_options ::= */
{ yymsp[1].minor.yy476 = createDefaultTableOptions(pCxt); }
        break;
      case 186: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy476 = setTableOption(pCxt, yymsp[-2].minor.yy476, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 187: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy476 = setTableOption(pCxt, yymsp[-2].minor.yy476, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy376); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 188: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy476 = setTableOption(pCxt, yymsp[-2].minor.yy476, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy376); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 189: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy476 = setTableOption(pCxt, yymsp[-4].minor.yy476, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy376); }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 190: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy476 = setTableOption(pCxt, yymsp[-2].minor.yy476, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 191: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy476 = setTableOption(pCxt, yymsp[-4].minor.yy476, TABLE_OPTION_SMA, yymsp[-1].minor.yy376); }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 192: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy476 = setTableOption(pCxt, yymsp[-2].minor.yy476, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy376); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 193: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy476 = createAlterTableOptions(pCxt); yylhsminor.yy476 = setTableOption(pCxt, yylhsminor.yy476, yymsp[0].minor.yy893.type, &yymsp[0].minor.yy893.val); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 194: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy476 = setTableOption(pCxt, yymsp[-1].minor.yy476, yymsp[0].minor.yy893.type, &yymsp[0].minor.yy893.val); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 195: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy893.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 196: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy893.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* duration_list ::= duration_literal */
      case 377: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==377);
{ yylhsminor.yy376 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy476)); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 198: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 378: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==378);
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, releaseRawExprNode(pCxt, yymsp[0].minor.yy476)); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 201: /* rollup_func_name ::= function_name */
{ yylhsminor.yy476 = createFunctionNode(pCxt, &yymsp[0].minor.yy701, NULL); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 202: /* rollup_func_name ::= FIRST */
      case 203: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==203);
      case 258: /* tag_item ::= QTAGS */ yytestcase(yyruleno==258);
{ yylhsminor.yy476 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 206: /* col_name ::= column_name */
      case 259: /* tag_item ::= column_name */ yytestcase(yyruleno==259);
{ yylhsminor.yy476 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy701); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 207: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 208: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 209: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 210: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 211: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy476, yymsp[0].minor.yy476, OP_TYPE_LIKE); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy476, yymsp[0].minor.yy476, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy476, NULL, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy476, yymsp[-1].minor.yy476, OP_TYPE_EQUAL); }
        break;
      case 218: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 219: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 220: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 221: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 222: /* cmd ::= SHOW LICENCES */
      case 223: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==223);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 224: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy701); }
        break;
      case 225: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy476); }
        break;
      case 226: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy476); }
        break;
      case 227: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 228: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 229: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 230: /* cmd ::= SHOW VARIABLES */
      case 231: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==231);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 232: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy476); }
        break;
      case 234: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 235: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 237: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 238: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy476); }
        break;
      case 239: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 240: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 241: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy476, yymsp[-1].minor.yy476, OP_TYPE_EQUAL); }
        break;
      case 242: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy476, yymsp[0].minor.yy476, yymsp[-3].minor.yy376); }
        break;
      case 243: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 245: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy476,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 246: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 247: /* db_name_cond_opt ::= */
      case 252: /* from_db_opt ::= */ yytestcase(yyruleno==252);
{ yymsp[1].minor.yy476 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 248: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy476 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy701); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 249: /* like_pattern_opt ::= */
      case 310: /* subtable_opt ::= */ yytestcase(yyruleno==310);
      case 423: /* case_when_else_opt ::= */ yytestcase(yyruleno==423);
      case 453: /* from_clause_opt ::= */ yytestcase(yyruleno==453);
      case 482: /* where_clause_opt ::= */ yytestcase(yyruleno==482);
      case 491: /* twindow_clause_opt ::= */ yytestcase(yyruleno==491);
      case 497: /* sliding_opt ::= */ yytestcase(yyruleno==497);
      case 499: /* fill_opt ::= */ yytestcase(yyruleno==499);
      case 511: /* having_clause_opt ::= */ yytestcase(yyruleno==511);
      case 513: /* range_opt ::= */ yytestcase(yyruleno==513);
      case 515: /* every_opt ::= */ yytestcase(yyruleno==515);
      case 528: /* slimit_clause_opt ::= */ yytestcase(yyruleno==528);
      case 532: /* limit_clause_opt ::= */ yytestcase(yyruleno==532);
{ yymsp[1].minor.yy476 = NULL; }
        break;
      case 250: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 251: /* table_name_cond ::= table_name */
{ yylhsminor.yy476 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy701); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 253: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy476 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy701); }
        break;
      case 257: /* tag_item ::= TBNAME */
{ yylhsminor.yy476 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 260: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy476 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy701), &yymsp[0].minor.yy701); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 261: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy476 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy701), &yymsp[0].minor.yy701); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 262: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy845, yymsp[-3].minor.yy476, yymsp[-1].minor.yy476, NULL, yymsp[0].minor.yy476); }
        break;
      case 263: /* cmd ::= CREATE INDEX not_exists_opt full_table_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy845, yymsp[-5].minor.yy476, yymsp[-3].minor.yy476, yymsp[-1].minor.yy376, NULL); }
        break;
      case 264: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy845, yymsp[0].minor.yy476); }
        break;
      case 265: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy476 = createIndexOption(pCxt, yymsp[-7].minor.yy376, releaseRawExprNode(pCxt, yymsp[-3].minor.yy476), NULL, yymsp[-1].minor.yy476, yymsp[0].minor.yy476); }
        break;
      case 266: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy476 = createIndexOption(pCxt, yymsp[-9].minor.yy376, releaseRawExprNode(pCxt, yymsp[-5].minor.yy476), releaseRawExprNode(pCxt, yymsp[-3].minor.yy476), yymsp[-1].minor.yy476, yymsp[0].minor.yy476); }
        break;
      case 269: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy476 = createFunctionNode(pCxt, &yymsp[-3].minor.yy701, yymsp[-1].minor.yy376); }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 275: /* sma_stream_opt ::= */
      case 303: /* stream_options ::= */ yytestcase(yyruleno==303);
{ yymsp[1].minor.yy476 = createStreamOptions(pCxt); }
        break;
      case 276: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 307: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==307);
{ ((SStreamOptions*)yymsp[-2].minor.yy476)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy476); yylhsminor.yy476 = yymsp[-2].minor.yy476; }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 277: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy476)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy476); yylhsminor.yy476 = yymsp[-2].minor.yy476; }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 278: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy476)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy476); yylhsminor.yy476 = yymsp[-2].minor.yy476; }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 279: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy845, &yymsp[-2].minor.yy701, yymsp[0].minor.yy476); }
        break;
      case 280: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy845, &yymsp[-3].minor.yy701, &yymsp[0].minor.yy701, false); }
        break;
      case 281: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy845, &yymsp[-5].minor.yy701, &yymsp[0].minor.yy701, true); }
        break;
      case 282: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy845, &yymsp[-3].minor.yy701, yymsp[0].minor.yy476, false); }
        break;
      case 283: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy845, &yymsp[-5].minor.yy701, yymsp[0].minor.yy476, true); }
        break;
      case 284: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy845, &yymsp[0].minor.yy701); }
        break;
      case 285: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy845, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy701); }
        break;
      case 286: /* cmd ::= DESC full_table_name */
      case 287: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==287);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy476); }
        break;
      case 288: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 289: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy845, yymsp[-1].minor.yy476, yymsp[0].minor.yy476); }
        break;
      case 292: /* explain_options ::= */
{ yymsp[1].minor.yy476 = createDefaultExplainOptions(pCxt); }
        break;
      case 293: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy476 = setExplainVerbose(pCxt, yymsp[-2].minor.yy476, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 294: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy476 = setExplainRatio(pCxt, yymsp[-2].minor.yy476, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 295: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy845, yymsp[-8].minor.yy845, &yymsp[-5].minor.yy701, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy532, yymsp[0].minor.yy508); }
        break;
      case 296: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy845, &yymsp[0].minor.yy701); }
        break;
      case 301: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy845, &yymsp[-7].minor.yy701, yymsp[-4].minor.yy476, yymsp[-6].minor.yy476, yymsp[-3].minor.yy376, yymsp[-2].minor.yy476, yymsp[0].minor.yy476); }
        break;
      case 302: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy845, &yymsp[0].minor.yy701); }
        break;
      case 304: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy476)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy476 = yymsp[-2].minor.yy476; }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 305: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy476)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy476 = yymsp[-2].minor.yy476; }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 306: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy476)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy476)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy476); yylhsminor.yy476 = yymsp[-3].minor.yy476; }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 308: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy476)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy476 = yymsp[-3].minor.yy476; }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 309: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy476)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy476 = yymsp[-2].minor.yy476; }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 311: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 498: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==498);
      case 516: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==516);
{ yymsp[-3].minor.yy476 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy476); }
        break;
      case 312: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 313: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 314: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 315: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 316: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 317: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy376); }
        break;
      case 318: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 319: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy376 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 321: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy476, yymsp[0].minor.yy476); }
        break;
      case 323: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy476, yymsp[-2].minor.yy376, yymsp[0].minor.yy476); }
        break;
      case 324: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy476, NULL, yymsp[0].minor.yy476); }
        break;
      case 325: /* literal ::= NK_INTEGER */
{ yylhsminor.yy476 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 326: /* literal ::= NK_FLOAT */
{ yylhsminor.yy476 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 327: /* literal ::= NK_STRING */
{ yylhsminor.yy476 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 328: /* literal ::= NK_BOOL */
{ yylhsminor.yy476 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 329: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 330: /* literal ::= duration_literal */
      case 340: /* signed_literal ::= signed */ yytestcase(yyruleno==340);
      case 360: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==360);
      case 361: /* expression ::= literal */ yytestcase(yyruleno==361);
      case 362: /* expression ::= pseudo_column */ yytestcase(yyruleno==362);
      case 363: /* expression ::= column_reference */ yytestcase(yyruleno==363);
      case 364: /* expression ::= function_expression */ yytestcase(yyruleno==364);
      case 365: /* expression ::= case_when_expression */ yytestcase(yyruleno==365);
      case 396: /* function_expression ::= literal_func */ yytestcase(yyruleno==396);
      case 445: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==445);
      case 449: /* boolean_primary ::= predicate */ yytestcase(yyruleno==449);
      case 451: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==451);
      case 452: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==452);
      case 455: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==455);
      case 457: /* table_reference ::= table_primary */ yytestcase(yyruleno==457);
      case 458: /* table_reference ::= joined_table */ yytestcase(yyruleno==458);
      case 462: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==462);
      case 518: /* query_simple ::= query_specification */ yytestcase(yyruleno==518);
      case 519: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==519);
      case 522: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==522);
      case 524: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==524);
{ yylhsminor.yy476 = yymsp[0].minor.yy476; }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 331: /* literal ::= NULL */
{ yylhsminor.yy476 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 332: /* literal ::= NK_QUESTION */
{ yylhsminor.yy476 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 333: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy476 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 334: /* signed ::= NK_INTEGER */
{ yylhsminor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 335: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 336: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 337: /* signed ::= NK_FLOAT */
{ yylhsminor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 338: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 339: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 341: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 342: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 343: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 344: /* signed_literal ::= duration_literal */
      case 346: /* signed_literal ::= literal_func */ yytestcase(yyruleno==346);
      case 416: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==416);
      case 478: /* select_item ::= common_expression */ yytestcase(yyruleno==478);
      case 488: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==488);
      case 523: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==523);
      case 525: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==525);
      case 538: /* search_condition ::= common_expression */ yytestcase(yyruleno==538);
{ yylhsminor.yy476 = releaseRawExprNode(pCxt, yymsp[0].minor.yy476); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 345: /* signed_literal ::= NULL */
{ yylhsminor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 347: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy476 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 366: /* expression ::= NK_LP expression NK_RP */
      case 450: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==450);
      case 537: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==537);
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy476)); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 367: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy476));
                                                                                  }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 368: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy476), NULL));
                                                                                  }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 369: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476))); 
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 370: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476))); 
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 371: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476))); 
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 372: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476))); 
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 373: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476)));
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 374: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 375: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476)));
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 376: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476)));
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 379: /* column_reference ::= column_name */
{ yylhsminor.yy476 = createRawExprNode(pCxt, &yymsp[0].minor.yy701, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy701)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 380: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy701, createColumnNode(pCxt, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy701)); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 381: /* pseudo_column ::= ROWTS */
      case 382: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==382);
      case 384: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==384);
      case 385: /* pseudo_column ::= QEND */ yytestcase(yyruleno==385);
      case 386: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==386);
      case 387: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==387);
      case 388: /* pseudo_column ::= WEND */ yytestcase(yyruleno==388);
      case 389: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==389);
      case 390: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==390);
      case 391: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==391);
      case 392: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==392);
      case 398: /* literal_func ::= NOW */ yytestcase(yyruleno==398);
{ yylhsminor.yy476 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 383: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy701)))); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 393: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 394: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==394);
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy701, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy701, yymsp[-1].minor.yy376)); }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 395: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy476), yymsp[-1].minor.yy532)); }
  yymsp[-5].minor.yy476 = yylhsminor.yy476;
        break;
      case 397: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy701, NULL)); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 412: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy376 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 417: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 481: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==481);
{ yylhsminor.yy476 = createColumnNode(pCxt, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 418: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy376, yymsp[-1].minor.yy476)); }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 419: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy476), yymsp[-2].minor.yy376, yymsp[-1].minor.yy476)); }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 422: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy476 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476)); }
        break;
      case 424: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy476 = releaseRawExprNode(pCxt, yymsp[0].minor.yy476); }
        break;
      case 425: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 430: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==430);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy128, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476)));
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 426: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy476), releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476)));
                                                                                  }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 427: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy476), releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476)));
                                                                                  }
  yymsp[-5].minor.yy476 = yylhsminor.yy476;
        break;
      case 428: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), NULL));
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 429: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy476), NULL));
                                                                                  }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 431: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy128 = OP_TYPE_LOWER_THAN; }
        break;
      case 432: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy128 = OP_TYPE_GREATER_THAN; }
        break;
      case 433: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy128 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 434: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy128 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 435: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy128 = OP_TYPE_NOT_EQUAL; }
        break;
      case 436: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy128 = OP_TYPE_EQUAL; }
        break;
      case 437: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy128 = OP_TYPE_LIKE; }
        break;
      case 438: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy128 = OP_TYPE_NOT_LIKE; }
        break;
      case 439: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy128 = OP_TYPE_MATCH; }
        break;
      case 440: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy128 = OP_TYPE_NMATCH; }
        break;
      case 441: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy128 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 442: /* in_op ::= IN */
{ yymsp[0].minor.yy128 = OP_TYPE_IN; }
        break;
      case 443: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy128 = OP_TYPE_NOT_IN; }
        break;
      case 444: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy376)); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 446: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy476), NULL));
                                                                                  }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 447: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476)));
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 448: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476)));
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 454: /* from_clause_opt ::= FROM table_reference_list */
      case 483: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==483);
      case 512: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==512);
{ yymsp[-1].minor.yy476 = yymsp[0].minor.yy476; }
        break;
      case 456: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy476 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy476, yymsp[0].minor.yy476, NULL); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 459: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy476 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy701, &yymsp[0].minor.yy701); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 460: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy476 = createRealTableNode(pCxt, &yymsp[-3].minor.yy701, &yymsp[-1].minor.yy701, &yymsp[0].minor.yy701); }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 461: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy476 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy476), &yymsp[0].minor.yy701); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 463: /* alias_opt ::= */
{ yymsp[1].minor.yy701 = nil_token;  }
        break;
      case 465: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy701 = yymsp[0].minor.yy701; }
        break;
      case 466: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 467: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==467);
{ yymsp[-2].minor.yy476 = yymsp[-1].minor.yy476; }
        break;
      case 468: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy476 = createJoinTableNode(pCxt, yymsp[-4].minor.yy288, yymsp[-5].minor.yy476, yymsp[-2].minor.yy476, yymsp[0].minor.yy476); }
  yymsp[-5].minor.yy476 = yylhsminor.yy476;
        break;
      case 469: /* join_type ::= */
{ yymsp[1].minor.yy288 = JOIN_TYPE_INNER; }
        break;
      case 470: /* join_type ::= INNER */
{ yymsp[0].minor.yy288 = JOIN_TYPE_INNER; }
        break;
      case 471: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy476 = createSelectStmt(pCxt, yymsp[-10].minor.yy845, yymsp[-9].minor.yy376, yymsp[-8].minor.yy476);
                                                                                    yymsp[-11].minor.yy476 = addWhereClause(pCxt, yymsp[-11].minor.yy476, yymsp[-7].minor.yy476);
                                                                                    yymsp[-11].minor.yy476 = addPartitionByClause(pCxt, yymsp[-11].minor.yy476, yymsp[-6].minor.yy376);
                                                                                    yymsp[-11].minor.yy476 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy476, yymsp[-2].minor.yy476);
                                                                                    yymsp[-11].minor.yy476 = addGroupByClause(pCxt, yymsp[-11].minor.yy476, yymsp[-1].minor.yy376);
                                                                                    yymsp[-11].minor.yy476 = addHavingClause(pCxt, yymsp[-11].minor.yy476, yymsp[0].minor.yy476);
                                                                                    yymsp[-11].minor.yy476 = addRangeClause(pCxt, yymsp[-11].minor.yy476, yymsp[-5].minor.yy476);
                                                                                    yymsp[-11].minor.yy476 = addEveryClause(pCxt, yymsp[-11].minor.yy476, yymsp[-4].minor.yy476);
                                                                                    yymsp[-11].minor.yy476 = addFillClause(pCxt, yymsp[-11].minor.yy476, yymsp[-3].minor.yy476);
                                                                                  }
        break;
      case 474: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy845 = false; }
        break;
      case 477: /* select_item ::= NK_STAR */
{ yylhsminor.yy476 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 479: /* select_item ::= common_expression column_alias */
      case 489: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==489);
{ yylhsminor.yy476 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy476), &yymsp[0].minor.yy701); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 480: /* select_item ::= common_expression AS column_alias */
      case 490: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==490);
{ yylhsminor.yy476 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), &yymsp[0].minor.yy701); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 485: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 508: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==508);
      case 527: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==527);
{ yymsp[-2].minor.yy376 = yymsp[0].minor.yy376; }
        break;
      case 492: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy476 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy476), releaseRawExprNode(pCxt, yymsp[-1].minor.yy476)); }
        break;
      case 493: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy476 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy476)); }
        break;
      case 494: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy476 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy476), NULL, yymsp[-1].minor.yy476, yymsp[0].minor.yy476); }
        break;
      case 495: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy476 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy476), releaseRawExprNode(pCxt, yymsp[-3].minor.yy476), yymsp[-1].minor.yy476, yymsp[0].minor.yy476); }
        break;
      case 496: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy476 = createEventWindowNode(pCxt, yymsp[-3].minor.yy476, yymsp[0].minor.yy476); }
        break;
      case 500: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy476 = createFillNode(pCxt, yymsp[-1].minor.yy690, NULL); }
        break;
      case 501: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy476 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy376)); }
        break;
      case 502: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy690 = FILL_MODE_NONE; }
        break;
      case 503: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy690 = FILL_MODE_PREV; }
        break;
      case 504: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy690 = FILL_MODE_NULL; }
        break;
      case 505: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy690 = FILL_MODE_LINEAR; }
        break;
      case 506: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy690 = FILL_MODE_NEXT; }
        break;
      case 509: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy376 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy476))); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 510: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy476))); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 514: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy476 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy476), releaseRawExprNode(pCxt, yymsp[-1].minor.yy476)); }
        break;
      case 517: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy476 = addOrderByClause(pCxt, yymsp[-3].minor.yy476, yymsp[-2].minor.yy376);
                                                                                    yylhsminor.yy476 = addSlimitClause(pCxt, yylhsminor.yy476, yymsp[-1].minor.yy476);
                                                                                    yylhsminor.yy476 = addLimitClause(pCxt, yylhsminor.yy476, yymsp[0].minor.yy476);
                                                                                  }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 520: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy476 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy476, yymsp[0].minor.yy476); }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 521: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy476 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy476, yymsp[0].minor.yy476); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 529: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 533: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==533);
{ yymsp[-1].minor.yy476 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 530: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 534: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==534);
{ yymsp[-3].minor.yy476 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 531: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 535: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==535);
{ yymsp[-3].minor.yy476 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 536: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy476); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 541: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy476 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), yymsp[-1].minor.yy554, yymsp[0].minor.yy697); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 542: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy554 = ORDER_ASC; }
        break;
      case 543: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy554 = ORDER_ASC; }
        break;
      case 544: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy554 = ORDER_DESC; }
        break;
      case 545: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy697 = NULL_ORDER_DEFAULT; }
        break;
      case 546: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy697 = NULL_ORDER_FIRST; }
        break;
      case 547: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy697 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
