---
sidebar_label: Go
title: Connect with Go Connector
---

## Add Dependency

add `driver-go` dependency in `go.mod` .

```go-mod title="go.mod"
module goexample

go 1.17

require github.com/taosdata/driver-go/v2 develop
```

Then run command `go mod tidy` in your terminal to download dependencies.

## Config

Run this command in your terminal to save DSN(data source name) as variable:

```bash
export TDENGINE_GO_DSN=<goDSN>
```

<!-- exclude -->
:::note
Replace <goDSN\> with the real value, the format should be `https(<cloud_host>)/?token=<token>`.
To obtain the value of `goDSN`, please log in [TDengine Cloud](https://cloud.tdengine.com) and click "Connector" and then select "Go".

:::
<!-- exclude-end -->

## Connect

```go
package main

import (
    "database/sql"
    "fmt"
    "os"

    _ "github.com/taosdata/driver-go/v2/taosRestful"
)

func main() {
    dsn := os.Getenv("TDENGINE_CLOUD_TOKEN")
    taos, err := sql.Open("taosRestful", dsn)
    if err != nil {
        fmt.Println("failed to connect TDengine, err:", err)
        return
    }
    fmt.Println("Connected")
    defer taos.Close()
}
```