---
sidebar_label: taosKeeper
title: taosKeeper
description: This document describes how to use taosKeeper, a tool for exporting TDengine monitoring metrics.
---

## Introduction

taosKeeper is a tool for TDengine that exports monitoring metrics. With taosKeeper, you can easily monitor the operational status of your TDengine deployment. taosKeeper uses the TDengine REST API. It is not necessary to install TDengine Client to use taosKeeper.

## Installation

<!-- There are two ways to install taosKeeper: -->
Methods of installing taosKeeper:

<!--- Installing the official TDengine installer will automatically install taosKeeper. Please refer to [TDengine installation](/operation/pkg-install) for details. -->

- You can compile taosKeeper separately and install it. Please refer to the [taosKeeper](https://github.com/taosdata/taoskeeper) repository for details. -->
You can compile taosKeeper separately and install it. Please refer to the [taosKeeper](https://github.com/taosdata/taoskeeper) repository for details.

## Run

### Configuration and running methods

taosKeeper needs to be executed on the terminal of the operating system, it supports three configuration methods: [Command-line arguments](#command-line-arguments-in-detail), [environment variable](#environment-variable-in-detail) and [configuration file](#configuration-file-parameters-in-detail). The precedence of those is Command-line, environment variable and configuration file.

**Make sure that the TDengine cluster is running correctly before running taosKeeper.** Ensure that the monitoring service in TDengine has been started. At least the values of `monitor` and `monitorFqdn` need to be set in `taos.cfg`.

```shell
monitor 1
monitorFqdn localhost # taoskeeper's FQDN
```

For more information, see [TDengine Monitoring Configuration](../config/#monitoring).

### Command-Line Parameters

You can use command-line parameters to run taosKeeper and control its behavior:

```shell
$ taosKeeper
```
### Environment variable

You can use Environment variable to run taosKeeper and control its behavior:

```shell
$ export TAOS_KEEPER_TDENGINE_HOST=192.168.64.3
 
$ taoskeeper
```

you can run `taoskeeper -h` for more detail.

### Configuration File

You can quickly launch taosKeeper with the following commands. If you do not specify a configuration file, `/etc/taos/keeper.toml` is used by default. If this file does not specify configurations, the default values are used. 

```shell
$ taoskeeper -c <keeper config file>
```

**Sample configuration files**
```toml
# enable debug in gin framework
debug = false

# listen to server port, default 6043
port = 6043

# set log level to panic, error, info, debug, or trace
loglevel = "info"

# set pool size
gopoolsize = 50000

# query rotation period for TDengine monitoring data
RotationInterval = "15s"

[tdengine]
host = "127.0.0.1"
port = 6041
username = "root"
password = "taosdata"

# set taosAdapter to monitor
[taosAdapter]
address = ["127.0.0.1:6041","192.168.1.95:6041"]

[metrics]
# monitoring metric prefix
prefix = "taos"

# cluster data identifier
cluster = "production"

# database to store monitoring data
database = "log"

# standard tables to monitor
tables = ["normal_table"]
```

### Obtain Monitoring Metrics

taosKeeper records monitoring metrics generated by TDengine in a specified database and provides an interface through which you can export the data.

#### View Monitoring Results

```shell
$ taos
# the log database is used in this example
> use log;
> select * from cluster_info limit 1;
```

Example result set:

```shell
           ts            |            first_ep            | first_ep_dnode_id |   version    |    master_uptime     | monitor_interval |  dbs_total  |  tbs_total  | stbs_total  | dnodes_total | dnodes_alive | mnodes_total | mnodes_alive | vgroups_total | vgroups_alive | vnodes_total | vnodes_alive | connections_total |  protocol   |           cluster_id           |
===============================================================================================================================================================================================================================================================================================================================================================================
 2022-08-16 17:37:01.629 | hlb:6030                       |                 1 | 3.0.0.0      |              0.27250 |               15 |           2 |          27 |          38 |            1 |            1 |            1 |            1 |             4 |             4 |            4 |            4 |                14 |           1 | 5981392874047724755            |
Query OK, 1 rows in database (0.036162s)
```

#### Export Monitoring Metrics

```shell
$ curl http://127.0.0.1:6043/metrics
```

Sample result set (excerpt):

```shell
# HELP taos_cluster_info_connections_total 
# TYPE taos_cluster_info_connections_total counter
taos_cluster_info_connections_total{cluster_id="5981392874047724755"} 16
# HELP taos_cluster_info_dbs_total 
# TYPE taos_cluster_info_dbs_total counter
taos_cluster_info_dbs_total{cluster_id="5981392874047724755"} 2
# HELP taos_cluster_info_dnodes_alive 
# TYPE taos_cluster_info_dnodes_alive counter
taos_cluster_info_dnodes_alive{cluster_id="5981392874047724755"} 1
# HELP taos_cluster_info_dnodes_total 
# TYPE taos_cluster_info_dnodes_total counter
taos_cluster_info_dnodes_total{cluster_id="5981392874047724755"} 1
# HELP taos_cluster_info_first_ep 
# TYPE taos_cluster_info_first_ep gauge
taos_cluster_info_first_ep{cluster_id="5981392874047724755",value="hlb:6030"} 1
```