/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 459
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOperatorType yy20;
  SNode* yy74;
  ENullOrder yy109;
  SToken yy317;
  EOrder yy326;
  bool yy335;
  int8_t yy449;
  int64_t yy531;
  EJoinType yy630;
  SAlterOption yy767;
  EFillMode yy828;
  int32_t yy856;
  SNodeList* yy874;
  SDataType yy898;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             714
#define YYNRULE              539
#define YYNTOKEN             324
#define YY_MAX_SHIFT         713
#define YY_MIN_SHIFTREDUCE   1055
#define YY_MAX_SHIFTREDUCE   1593
#define YY_ERROR_ACTION      1594
#define YY_ACCEPT_ACTION     1595
#define YY_NO_ACTION         1596
#define YY_MIN_REDUCE        1597
#define YY_MAX_REDUCE        2135
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2968)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   460,  354,  461, 1633, 1739,  469, 1595,  461, 1633,  157,
 /*    10 */   542,   82,   45,   43, 1523, 1937,  169,  159, 1752, 1609,
 /*    20 */   362, 1401, 1374,   38,   37,  129, 1933,   44,   42,   41,
 /*    30 */    40,   39,  602, 1453, 1745, 1372, 1666,  334, 1850,  602,
 /*    40 */  1937,  367,   38,   37, 1796, 1798,   44,   42,   41,   40,
 /*    50 */    39, 1933,  407, 1846, 1929, 1935,  345,  583, 1448,   27,
 /*    60 */  1527,   31, 1728,   18,  183,  613, 1399,   38,   37,  377,
 /*    70 */  1380,   44,   42,   41,   40,   39,  171, 1950, 1803, 1929,
 /*    80 */  1935,  357,   64,   45,   43,  355, 1399, 1741,  133, 1790,
 /*    90 */   613,  362,  320, 1374, 1801,   14,  459,  327, 1933,  464,
 /*   100 */  1639,  514,  513,  512, 1453,  365, 1372,   48, 1968,  130,
 /*   110 */   508,  547,  466,  157,  507, 2106,  586,  710,  462,  506,
 /*   120 */   511, 1919, 1752,  619,  478,  505, 1929, 1935,  566, 1448,
 /*   130 */  2112,  175, 1455, 1456,   18, 2107,  572,  613, 1482,  468,
 /*   140 */   160, 1380,  464, 1639,  583, 1704, 1949,  174, 2045, 2046,
 /*   150 */  1984,  131, 2050,  102, 1951,  623, 1953, 1954,  618,  571,
 /*   160 */   613, 1429, 1438, 2106,  259,  172,   14, 2037,  514,  513,
 /*   170 */   512,  356, 2033,   60,  478,  133,  130,  508,  570,  175,
 /*   180 */  1375,  507, 1373, 2107,  572,  177,  506,  511,  710,  605,
 /*   190 */  1938, 2009,  505, 2063, 1483,  227,   44,   42,   41,   40,
 /*   200 */    39, 1933, 1088, 1455, 1456, 1378, 1379, 1430, 1428, 1431,
 /*   210 */  1432, 1433, 1434, 1435, 1436, 1437,  615,  611, 1446, 1447,
 /*   220 */  1449, 1450, 1451, 1452, 1454, 1457,    2, 1310, 1311, 1929,
 /*   230 */  1935, 1400, 1429, 1438,  257, 2045,  582,  368,  126,  581,
 /*   240 */   613, 1090, 2106, 1093, 1094,  157,   60, 1107, 1803, 1106,
 /*   250 */   339, 1375, 1550, 1373, 1752,   84,  322,  570,  175,  532,
 /*   260 */   443,  530, 2107,  572, 1802,   34,  360, 1477, 1478, 1479,
 /*   270 */  1480, 1481, 1485, 1486, 1487, 1488, 1378, 1379, 1108, 1428,
 /*   280 */  1431, 1432, 1433, 1434, 1435, 1436, 1437,  615,  611, 1446,
 /*   290 */  1447, 1449, 1450, 1451, 1452, 1454, 1457,    2, 2111,   11,
 /*   300 */    45,   43,  558, 1548, 1549, 1551, 1552,   11,  362,    9,
 /*   310 */  1374,  340,  602,  338,  337, 1401,  501,  583,  191,  190,
 /*   320 */   503, 1453,  178, 1372, 1214,  645,  644,  643, 1218,  642,
 /*   330 */  1220, 1221,  641, 1223,  638, 1598, 1229,  635, 1231, 1232,
 /*   340 */   632,  629,  502, 1257, 1258,  260, 1448,  235,  133,  187,
 /*   350 */  2111,   18,  228,  610, 2106,   99,  115,   11, 1380,  114,
 /*   360 */   113,  112,  111,  110,  109,  108,  107,  106,  169,  134,
 /*   370 */  2110,   45,   43, 1458, 2107, 2109,  607, 1742, 2009,  362,
 /*   380 */   401, 1374,   60,   14,   87,   79,   85,   48,   78,   60,
 /*   390 */  1851, 1583, 1453,  115, 1372,  178,  114,  113,  112,  111,
 /*   400 */   110,  109,  108,  107,  106,  710,  585,  173, 2045, 2046,
 /*   410 */    49,  131, 2050,  213,  590, 1351, 1352, 1448,  590, 2111,
 /*   420 */  1455, 1456,  547, 2106,  353,   82, 2106, 1861,  164, 1380,
 /*   430 */  1107, 1862, 1106,  561,  495,  491,  487,  483,  210, 2110,
 /*   440 */  1374, 2112,  175, 2107, 2108,  212, 2107,  572, 1746, 1429,
 /*   450 */  1438,  267,  268, 1372,   46, 1597,  266, 1399,  259,   38,
 /*   460 */    37, 1108, 1803,   44,   42,   41,   40,   39, 1375,  331,
 /*   470 */  1373, 1402, 1402,  400,   83,  399,  710,  208, 1801,  124,
 /*   480 */   123,  122,  121,  120,  119,  118,  117,  116, 1380, 2052,
 /*   490 */  1620, 1455, 1456, 1378, 1379, 1474, 1428, 1431, 1432, 1433,
 /*   500 */  1434, 1435, 1436, 1437,  615,  611, 1446, 1447, 1449, 1450,
 /*   510 */  1451, 1452, 1454, 1457,    2, 2049,  567,  562,  556, 1463,
 /*   520 */  1429, 1438,   38,   37, 1484, 1399,   44,   42,   41,   40,
 /*   530 */    39,  178,   60,  571, 1919,  710,  178, 2106,  178, 1375,
 /*   540 */   396, 1373, 1400, 1968,  207,  201, 1726,  206,   35,  276,
 /*   550 */   474,  565,  570,  175,  157,  589, 1399, 2107,  572,  178,
 /*   560 */  1950,  398,  394, 1753, 1378, 1379,  199, 1428, 1431, 1432,
 /*   570 */  1433, 1434, 1435, 1436, 1437,  615,  611, 1446, 1447, 1449,
 /*   580 */  1450, 1451, 1452, 1454, 1457,    2,   45,   43,  603,  603,
 /*   590 */   564, 1968, 1797, 1798,  362,   32, 1374,  547, 1375,  620,
 /*   600 */  1373, 2106,   54,  180, 1919, 1489,  619, 1453,  657, 1372,
 /*   610 */  1560,   41,   40,   39,  237,  184, 2112,  175, 1803, 1750,
 /*   620 */  1750, 2107,  572, 1378, 1379,  366,  375,  510,  509, 1949,
 /*   630 */  2110,  603, 1448, 1984, 1801,    8,  102, 1951,  623, 1953,
 /*   640 */  1954,  618, 1727,  613, 1380,  125,  136, 2052,  143, 2008,
 /*   650 */  2037, 1950,  499, 2052,  356, 2033,  374,   45,   43, 1402,
 /*   660 */   519,  528, 1750,  603, 1619,  362, 1430, 1374,  547,   46,
 /*   670 */    13,   12, 2106, 2048,  526,  529,  524,  125, 1453, 2047,
 /*   680 */  1372,  178, 1968,   93,  504, 1846, 1174, 2112,  175,  226,
 /*   690 */   586,  710, 2107,  572, 1750, 1919,  185,  619,  547,  681,
 /*   700 */   679, 1398, 2106, 1448,  522, 1743, 1455, 1456, 1919,  516,
 /*   710 */   135,  603,  648, 2008,  225, 1380, 1618, 2112,  175, 1617,
 /*   720 */  1949, 1176, 2107,  572, 1984,  405, 1846,  102, 1951,  623,
 /*   730 */  1953, 1954,  618,  603,  613, 1429, 1438,  189,  657,  172,
 /*   740 */    14, 2037, 1750,  603,  603,  356, 2033,  406,  229,  655,
 /*   750 */    66, 1780,  649,   65, 1375, 1794, 1373,  415,  429,  503,
 /*   760 */  1919, 1616,  710, 1919, 1750, 1496, 1640, 2064,  148,  147,
 /*   770 */   652,  651,  650,  145, 1750, 1750, 1380, 1455, 1456, 1378,
 /*   780 */  1379,  502, 1428, 1431, 1432, 1433, 1434, 1435, 1436, 1437,
 /*   790 */   615,  611, 1446, 1447, 1449, 1450, 1451, 1452, 1454, 1457,
 /*   800 */     2,  319,  236, 1397,  603, 1919, 1429, 1438, 1615,  653,
 /*   810 */   437,  654, 1794,  450, 1794,  705,  449,  290,  430,  669,
 /*   820 */  1780,  670,   50, 1720,    3, 1375, 1663, 1373, 1614, 1613,
 /*   830 */  1612,  421,  146,  451,   33, 1750,  423, 1093, 1094, 1516,
 /*   840 */    38,   37, 1725, 1833,   44,   42,   41,   40,   39, 1399,
 /*   850 */  1378, 1379, 1919, 1428, 1431, 1432, 1433, 1434, 1435, 1436,
 /*   860 */  1437,  615,  611, 1446, 1447, 1449, 1450, 1451, 1452, 1454,
 /*   870 */  1457,    2, 1919, 1919, 1919,   38,   37,  335, 1735,   44,
 /*   880 */    42,   41,   40,   39,   53,  218, 2057, 1516,  216,  411,
 /*   890 */   574,  687,  686,  685,  684,  372, 1520,  683,  682,  137,
 /*   900 */   677,  676,  675,  674,  673,  672,  671,  150,  667,  666,
 /*   910 */   665,  371,  370,  662,  661,  660,  659,  658,  139,  447,
 /*   920 */   127, 1383,  442,  441,  440,  439,  436,  435,  434,  433,
 /*   930 */   432,  428,  427,  426,  425,  336,  418,  417,  416,   69,
 /*   940 */   413,  412,  333,  158,  578,  535,   38,   37,  296,  655,
 /*   950 */    44,   42,   41,   40,   39,  220,  222, 1950,  219,  221,
 /*   960 */  1611, 1608,  294,   68,  224, 1610,   67,  223,  148,  147,
 /*   970 */   652,  651,  650,  145, 1737,   38,   37, 1950,  603,   44,
 /*   980 */    42,   41,   40,   39,  195,  456,  454,  547, 1968,   77,
 /*   990 */  1430, 2106,  476,  583,  424,  575,  620, 1607, 1606, 1605,
 /*  1000 */    98, 1919,  408,  619, 1919, 1919, 2112,  175, 1968, 1750,
 /*  1010 */    95, 2107,  572,  603,   52,  409,  620,  603,  603,  546,
 /*  1020 */    60, 1919, 1604,  619,  133, 1906, 1949,  477,   62,  241,
 /*  1030 */  1984, 1747,  141,  102, 1951,  623, 1953, 1954,  618, 1590,
 /*  1040 */   613, 1919, 1919, 1919, 1750, 2126, 1949, 2037, 1750, 1750,
 /*  1050 */  1984,  356, 2033,  102, 1951,  623, 1953, 1954,  618,  101,
 /*  1060 */   613, 1382, 2071, 1539,  603, 2126, 1919, 2037, 1386, 1950,
 /*  1070 */   655,  356, 2033,  384, 1603, 1592, 1593, 1602,  543, 1733,
 /*  1080 */  1547,  243, 2084,  176, 2045, 2046,  232,  131, 2050,  148,
 /*  1090 */   147,  652,  651,  650,  145, 1750,  614,   76,   75,  404,
 /*  1100 */  1968,  156,  182,  603,  647,  603, 1705, 2077,  620,  559,
 /*  1110 */   603, 1653, 1950, 1919,   47,  619, 1601,  587, 1919,  271,
 /*  1120 */   318, 1919,  254,  392,  598,  390,  386,  382,  379,  376,
 /*  1130 */   603,   13,   12,  515, 1750, 1589, 1750, 1519, 1949,  603,
 /*  1140 */   603, 1750, 1984, 1968,  600,  102, 1951,  623, 1953, 1954,
 /*  1150 */   618,  620,  613,  601,  277, 1950, 1919, 2126,  619, 2037,
 /*  1160 */  1919, 1750, 1646,  356, 2033, 1644, 1321,  579, 1600,  178,
 /*  1170 */  1750, 1750,   38,   37,  554,  264,   44,   42,   41,   40,
 /*  1180 */    39, 1949,  603,  211,  517, 1984, 1968,  520,  102, 1951,
 /*  1190 */   623, 1953, 1954,  618,  620,  613,  369,  248, 1940, 1919,
 /*  1200 */  2126,  619, 2037,  142,  144,  146,  356, 2033, 1385,  373,
 /*  1210 */    62,   47, 1919, 1750, 1634,   47,  576, 2100,  627,  359,
 /*  1220 */   358,  144, 1950,  146, 1949,  663,  128,  269, 1984, 1388,
 /*  1230 */   144,  102, 1951,  623, 1953, 1954,  618,  664,  613, 1136,
 /*  1240 */  1453, 1969, 1381, 2126, 1855, 2037, 1942, 1155, 1791,  356,
 /*  1250 */  2033, 2067,  584, 1968,  253,  595,  273, 1207,  256, 1153,
 /*  1260 */  2056,  620, 1490, 1439,    1, 1448, 1919,  289,  619,    4,
 /*  1270 */  1235,  378,  332, 1239, 1137, 1246, 1950, 1380, 1244,  383,
 /*  1280 */  1338,  188,  149,  284,  410, 1402,  414,  445, 1856,  419,
 /*  1290 */  1397, 1949,  431, 1848,  438, 1984,  444,  446,  102, 1951,
 /*  1300 */   623, 1953, 1954,  618,  452,  613,  192, 1968,  453,  455,
 /*  1310 */  2012,  457, 2037, 1403, 1405,  620,  356, 2033,  458,  467,
 /*  1320 */  1919,  470,  619,  198,  609,  471, 1404,  200,  472, 1406,
 /*  1330 */   473,  475,  203,  479,  205,   80, 1110,   81,  209,  496,
 /*  1340 */   497,  498,  321,  105, 1896, 1949,  500,  534, 1895, 1984,
 /*  1350 */   536,  538,  102, 1951,  623, 1953, 1954,  618, 1740,  613,
 /*  1360 */   230,  215, 1950, 1736, 2010,  217, 2037,  151,  152, 1738,
 /*  1370 */   356, 2033, 1734,  153,  154,  537,  285,  541,  233,  544,
 /*  1380 */  2068,    7,  560, 2083, 2082,  593,  569, 1389, 2059, 1384,
 /*  1390 */   551,  557,  249, 1968,  247,  346,  552,  550, 2078,  563,
 /*  1400 */   165,  620,  239,  250,  549,  251, 1919,  347,  619,  580,
 /*  1410 */   577,  242, 1392, 1394, 2129, 1516, 2105,  132, 1401,  255,
 /*  1420 */   252,  588,  261,  350,  611, 1446, 1447, 1449, 1450, 1451,
 /*  1430 */  1452, 1949, 2053,  286,  591, 1984, 1950,  592,  102, 1951,
 /*  1440 */   623, 1953, 1954,  618, 1867,  613, 1866, 1865,  287,  352,
 /*  1450 */   606,  596, 2037,  597,   90,  288,  356, 2033,   92, 1751,
 /*  1460 */    59, 2018,   94, 1795, 1721,  625,  706, 1968,  291,  707,
 /*  1470 */   709,   51,  300,  315,  280,  620,  323,  314,  304, 1950,
 /*  1480 */  1919,  324,  619,  295,  293, 1913, 1912,   73, 1911, 1910,
 /*  1490 */    74, 1907,  380, 1366,  381, 1367,  181,  385, 1905,  387,
 /*  1500 */   388,  389, 1904,  391, 1903, 1949,  393, 1902, 1901, 1984,
 /*  1510 */  1968,  397,  103, 1951,  623, 1953, 1954,  618,  620,  613,
 /*  1520 */  1341,  395, 1950, 1919, 1340,  619, 2037,  402,  403, 1876,
 /*  1530 */  2036, 2033, 1878, 1877, 1875, 1841, 1840, 1301, 1838,  138,
 /*  1540 */  1837, 1836, 1839, 1835, 1834, 1832, 1831, 1830, 1949,  420,
 /*  1550 */  1950,  186, 1984, 1968, 1829,  103, 1951,  623, 1953, 1954,
 /*  1560 */   618,  620,  613,  422, 1828, 1827, 1919, 1826,  619, 2037,
 /*  1570 */   140, 1813, 1812,  608, 2033, 1825, 1824, 1823, 1822, 1821,
 /*  1580 */  1820, 1968, 1819, 1818, 1817, 1816, 1815, 1814, 1811,  617,
 /*  1590 */  1810,  621, 1809, 1808, 1919, 1984,  619, 1807,  103, 1951,
 /*  1600 */   623, 1953, 1954,  618, 1806,  613, 1805,  448, 1804, 1182,
 /*  1610 */  1668, 1303, 2037,  193, 1667,  194,  326, 2033, 1665, 1949,
 /*  1620 */  1629, 1096,  713, 1984, 1628,  170,  312, 1951,  623, 1953,
 /*  1630 */  1954,  618,  616,  613,  604, 2002,  283,  196, 1950,   71,
 /*  1640 */  1095, 1939,  197,  463,   72,  465, 1891, 1885, 1874,  204,
 /*  1650 */   202,  168, 1873, 1858, 1729, 1129, 1664,  703,  699,  695,
 /*  1660 */   691,  281, 1662,  480,  481, 1660,  484,  485,  482, 1968,
 /*  1670 */  1658,  486,  488,  489,  490, 1656,  492,  620,  493,  494,
 /*  1680 */  1643, 1950, 1919, 1642,  619, 1625, 1731, 1730, 1250,  678,
 /*  1690 */  1251, 1165, 1173, 1172, 1171, 1170, 1654,  100, 1950, 1167,
 /*  1700 */   274,  341, 1166,   61, 1647,  680, 1164, 1949, 1645,  521,
 /*  1710 */   342, 1984, 1968,  518,  161, 1951,  623, 1953, 1954,  618,
 /*  1720 */   620,  613,  343,  214, 1624, 1919,  523,  619, 1623, 1968,
 /*  1730 */   525, 1622,  527,  599,  104, 1358, 1356,  620, 1355,   26,
 /*  1740 */   531, 1890, 1919, 1884,  619,  155, 1347,  539, 1872, 1870,
 /*  1750 */  1949,   19, 1950, 2111, 1984,  548, 2074,  162, 1951,  623,
 /*  1760 */  1953, 1954,  618,   16,  613,  555,  234, 1949, 1950, 1562,
 /*  1770 */   262, 1984,   55,  240,  103, 1951,  623, 1953, 1954,  618,
 /*  1780 */   540,  613,  545, 1968,   28,  344,  553, 1345, 2037,  231,
 /*  1790 */    58,  620,  238, 2034, 1546,  245, 1919,  163,  619, 1968,
 /*  1800 */   244,    5,    6,  246,   29, 1940,   30,  620, 1538,  573,
 /*  1810 */  2127,   86, 1919, 1582,  619, 1583,   20,   63,   21, 1513,
 /*  1820 */  1577, 1949, 1576,  348, 1581, 1984, 1580,  349,  161, 1951,
 /*  1830 */   623, 1953, 1954,  618, 1512,  613, 1871, 1949, 1950,   57,
 /*  1840 */   258, 1984, 1869,  166,  306, 1951,  623, 1953, 1954,  618,
 /*  1850 */  1868,  613,   22, 1857, 1950,  263, 1544,   56,  265,  270,
 /*  1860 */    17,   88,   89,   91,  275,   23,   95,   10,   12, 1968,
 /*  1870 */  2075, 1390,  594, 1475, 1987,  612, 1465,  620, 1464,  272,
 /*  1880 */   167,   36, 1919, 1421,  619, 1968, 1443,  179,  568,   15,
 /*  1890 */   351,  622,   24,  620, 1441, 1440, 1413, 1950, 1919,   25,
 /*  1900 */   619, 1236,  626,  364,  628, 1213, 1233, 1949,  624,  630,
 /*  1910 */   631, 1984, 1230,  633,  162, 1951,  623, 1953, 1954,  618,
 /*  1920 */   634,  613, 1224, 1949,  636,  637,  639, 1984, 1968,  640,
 /*  1930 */   313, 1951,  623, 1953, 1954,  618,  617,  613, 1228, 1222,
 /*  1940 */    96, 1919,  646,  619,  278, 1245, 1227, 1226, 1225,   97,
 /*  1950 */    70, 1241, 1127,  656, 1950, 1161, 1160, 1159, 1158, 1157,
 /*  1960 */  1156, 1154, 1152, 1151,  668, 1150, 1949, 2128, 1180, 1148,
 /*  1970 */  1984, 1147, 1145,  312, 1951,  623, 1953, 1954,  618,  279,
 /*  1980 */   613, 1146, 2003, 1144, 1143, 1968, 1142, 1177, 1175, 1139,
 /*  1990 */   361, 1138, 1135,  620, 1134, 1133, 1132, 1661, 1919,  688,
 /*  2000 */   619,  690, 1659,  692,  694, 1950,  689, 1657,  693,  696,
 /*  2010 */   698,  697, 1655,  700,  701,  702, 1641,  704, 1085, 1621,
 /*  2020 */   282,  708,  711, 1949,  712, 1376, 1950, 1984,  292, 1596,
 /*  2030 */   313, 1951,  623, 1953, 1954,  618, 1968,  613, 1596, 1596,
 /*  2040 */  1596,  363, 1596, 1596,  620, 1596, 1596, 1596, 1950, 1919,
 /*  2050 */  1596,  619, 1596, 1596, 1596, 1596, 1596, 1968, 1596, 1596,
 /*  2060 */  1596, 1596, 1596, 1596, 1596,  620, 1596, 1596, 1596, 1596,
 /*  2070 */  1919, 1596,  619, 1596, 1949, 1596, 1596, 1596, 1984, 1968,
 /*  2080 */  1596,  313, 1951,  623, 1953, 1954,  618,  620,  613, 1596,
 /*  2090 */  1596, 1596, 1919, 1596,  619,  533, 1596, 1596, 1596, 1984,
 /*  2100 */  1596, 1596,  308, 1951,  623, 1953, 1954,  618, 1596,  613,
 /*  2110 */  1596, 1950, 1596, 1596, 1596, 1596, 1596, 1949, 1596, 1596,
 /*  2120 */  1596, 1984, 1596, 1596,  297, 1951,  623, 1953, 1954,  618,
 /*  2130 */  1596,  613, 1596, 1596, 1596, 1950, 1596, 1596, 1596, 1596,
 /*  2140 */  1596, 1596, 1968, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
 /*  2150 */   620, 1596, 1596, 1596, 1596, 1919, 1596,  619, 1596, 1596,
 /*  2160 */  1596, 1596, 1596, 1596, 1596, 1596, 1968, 1596, 1596, 1596,
 /*  2170 */  1596, 1596, 1596, 1596,  620, 1596, 1596, 1596, 1596, 1919,
 /*  2180 */  1949,  619, 1596, 1596, 1984, 1596, 1596,  298, 1951,  623,
 /*  2190 */  1953, 1954,  618, 1596,  613, 1596, 1596, 1950, 1596, 1596,
 /*  2200 */  1596, 1596, 1596, 1596, 1949, 1596, 1596, 1596, 1984, 1596,
 /*  2210 */  1596,  299, 1951,  623, 1953, 1954,  618, 1596,  613, 1596,
 /*  2220 */  1596, 1950, 1596, 1596, 1596, 1596, 1596, 1596, 1968, 1596,
 /*  2230 */  1596, 1596, 1596, 1596, 1596, 1596,  620, 1596, 1596, 1596,
 /*  2240 */  1596, 1919, 1596,  619, 1596, 1596, 1596, 1596, 1596, 1596,
 /*  2250 */  1596, 1596, 1968, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
 /*  2260 */   620, 1596, 1596, 1596, 1950, 1919, 1949,  619, 1596, 1596,
 /*  2270 */  1984, 1596, 1596,  305, 1951,  623, 1953, 1954,  618, 1596,
 /*  2280 */   613, 1596, 1950, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
 /*  2290 */  1949, 1596, 1596, 1596, 1984, 1968, 1596,  309, 1951,  623,
 /*  2300 */  1953, 1954,  618,  620,  613, 1596, 1596, 1596, 1919, 1596,
 /*  2310 */   619, 1596, 1596, 1968, 1596, 1596, 1596, 1596, 1596, 1596,
 /*  2320 */  1596,  620, 1596, 1596, 1596, 1596, 1919, 1596,  619, 1596,
 /*  2330 */  1596, 1596, 1596, 1949, 1596, 1596, 1596, 1984, 1596, 1596,
 /*  2340 */   301, 1951,  623, 1953, 1954,  618, 1596,  613, 1596, 1596,
 /*  2350 */  1596, 1949, 1596, 1596, 1950, 1984, 1596, 1596,  310, 1951,
 /*  2360 */   623, 1953, 1954,  618, 1596,  613, 1596, 1596, 1596, 1596,
 /*  2370 */  1596, 1596, 1950, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
 /*  2380 */  1596, 1596, 1596, 1596, 1596, 1968, 1596, 1596, 1596, 1596,
 /*  2390 */  1596, 1596, 1596,  620, 1596, 1596, 1596, 1596, 1919, 1596,
 /*  2400 */   619, 1596, 1596, 1968, 1596, 1596, 1596, 1596, 1596, 1596,
 /*  2410 */  1596,  620, 1596, 1596, 1596, 1950, 1919, 1596,  619, 1596,
 /*  2420 */  1596, 1596, 1596, 1949, 1596, 1596, 1596, 1984, 1596, 1596,
 /*  2430 */   302, 1951,  623, 1953, 1954,  618, 1596,  613, 1596, 1950,
 /*  2440 */  1596, 1949, 1596, 1596, 1596, 1984, 1968, 1596,  311, 1951,
 /*  2450 */   623, 1953, 1954,  618,  620,  613, 1596, 1596, 1596, 1919,
 /*  2460 */  1596,  619, 1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
 /*  2470 */  1968, 1596, 1596, 1596, 1596, 1596, 1596, 1596,  620, 1596,
 /*  2480 */  1596, 1596, 1596, 1919, 1949,  619, 1596, 1596, 1984, 1596,
 /*  2490 */  1596,  303, 1951,  623, 1953, 1954,  618, 1596,  613, 1596,
 /*  2500 */  1596, 1596, 1950, 1596, 1596, 1596, 1596, 1596, 1949, 1596,
 /*  2510 */  1596, 1596, 1984, 1596, 1596,  316, 1951,  623, 1953, 1954,
 /*  2520 */   618, 1596,  613, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
 /*  2530 */  1596, 1596, 1596, 1968, 1596, 1596, 1596, 1596, 1596, 1596,
 /*  2540 */  1596,  620, 1596, 1596, 1596, 1596, 1919, 1596,  619, 1596,
 /*  2550 */  1596, 1596, 1596, 1596, 1596, 1596, 1950, 1596, 1596, 1596,
 /*  2560 */  1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
 /*  2570 */  1596, 1949, 1596, 1596, 1596, 1984, 1596, 1596,  317, 1951,
 /*  2580 */   623, 1953, 1954,  618, 1596,  613, 1596, 1968, 1596, 1596,
 /*  2590 */  1596, 1596, 1596, 1596, 1596,  620, 1596, 1596, 1596, 1596,
 /*  2600 */  1919, 1596,  619, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
 /*  2610 */  1950, 1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
 /*  2620 */  1596, 1596, 1596, 1596, 1596, 1949, 1950, 1596, 1596, 1984,
 /*  2630 */  1596, 1596, 1962, 1951,  623, 1953, 1954,  618, 1596,  613,
 /*  2640 */  1596, 1968, 1596, 1596, 1596, 1596, 1596, 1596, 1596,  620,
 /*  2650 */  1596, 1596, 1596, 1596, 1919, 1596,  619, 1968, 1596, 1596,
 /*  2660 */  1596, 1596, 1596, 1596, 1596,  620, 1596, 1596, 1596, 1950,
 /*  2670 */  1919, 1596,  619, 1596, 1596, 1596, 1596, 1596, 1596, 1949,
 /*  2680 */  1596, 1596, 1596, 1984, 1596, 1596, 1961, 1951,  623, 1953,
 /*  2690 */  1954,  618, 1596,  613, 1596, 1949, 1596, 1596, 1596, 1984,
 /*  2700 */  1968, 1596, 1960, 1951,  623, 1953, 1954,  618,  620,  613,
 /*  2710 */  1596, 1596, 1596, 1919, 1596,  619, 1596, 1596, 1596, 1596,
 /*  2720 */  1596, 1596, 1596, 1596, 1596, 1596, 1950, 1596, 1596, 1596,
 /*  2730 */  1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596, 1949, 1596,
 /*  2740 */  1596, 1596, 1984, 1950, 1596,  328, 1951,  623, 1953, 1954,
 /*  2750 */   618, 1596,  613, 1596, 1596, 1596, 1596, 1968, 1596, 1596,
 /*  2760 */  1596, 1596, 1596, 1596, 1596,  620, 1596, 1596, 1596, 1950,
 /*  2770 */  1919, 1596,  619, 1596, 1968, 1596, 1596, 1596, 1596, 1596,
 /*  2780 */  1596, 1596,  620, 1596, 1596, 1596, 1596, 1919, 1596,  619,
 /*  2790 */  1596, 1596, 1596, 1596, 1596, 1949, 1596, 1596, 1596, 1984,
 /*  2800 */  1968, 1596,  329, 1951,  623, 1953, 1954,  618,  620,  613,
 /*  2810 */  1596, 1596, 1949, 1919, 1596,  619, 1984, 1596, 1596,  325,
 /*  2820 */  1951,  623, 1953, 1954,  618, 1596,  613, 1596, 1596, 1596,
 /*  2830 */  1950, 1596, 1596, 1596, 1596, 1596, 1596, 1596, 1949, 1596,
 /*  2840 */  1596, 1596, 1984, 1596, 1596,  330, 1951,  623, 1953, 1954,
 /*  2850 */   618, 1596,  613, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
 /*  2860 */  1596, 1968, 1596, 1596, 1596, 1596, 1596, 1596, 1596,  620,
 /*  2870 */  1596, 1596, 1596, 1596, 1919, 1596,  619, 1596, 1596, 1596,
 /*  2880 */  1596, 1596, 1596, 1596, 1950, 1596, 1596, 1596, 1596, 1596,
 /*  2890 */  1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,  621,
 /*  2900 */  1596, 1596, 1596, 1984, 1596, 1596,  308, 1951,  623, 1953,
 /*  2910 */  1954,  618, 1596,  613, 1596, 1968, 1596, 1596, 1596, 1596,
 /*  2920 */  1596, 1596, 1596,  620, 1596, 1596, 1596, 1596, 1919, 1596,
 /*  2930 */   619, 1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
 /*  2940 */  1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
 /*  2950 */  1596, 1596, 1596, 1949, 1596, 1596, 1596, 1984, 1596, 1596,
 /*  2960 */   307, 1951,  623, 1953, 1954,  618, 1596,  613,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   331,  350,  333,  334,  359,  331,  324,  333,  334,  358,
 /*    10 */   391,  341,   12,   13,   14,  360,  358,  326,  367,  328,
 /*    20 */    20,   20,   22,    8,    9,  355,  371,   12,   13,   14,
 /*    30 */    15,   16,   20,   33,  364,   35,    0,  379,  380,   20,
 /*    40 */   360,  369,    8,    9,  372,  373,   12,   13,   14,   15,
 /*    50 */    16,  371,  335,  366,  399,  400,  401,  335,   58,   44,
 /*    60 */    14,    2,    0,   63,  377,  410,   20,    8,    9,  387,
 /*    70 */    70,   12,   13,   14,   15,   16,  357,  327,  358,  399,
 /*    80 */   400,  401,    4,   12,   13,  365,   20,  360,  366,  370,
 /*    90 */   410,   20,  375,   22,  374,   95,  332,   63,  371,  335,
 /*   100 */   336,   65,   66,   67,   33,  350,   35,   95,  358,   73,
 /*   110 */    74,  429,   14,  358,   78,  433,  366,  117,   20,   83,
 /*   120 */    84,  371,  367,  373,   62,   89,  399,  400,   20,   58,
 /*   130 */   448,  449,  132,  133,   63,  453,  454,  410,  104,  332,
 /*   140 */   342,   70,  335,  336,  335,  347,  396,  425,  426,  427,
 /*   150 */   400,  429,  430,  403,  404,  405,  406,  407,  408,  429,
 /*   160 */   410,  161,  162,  433,  163,  415,   95,  417,   65,   66,
 /*   170 */    67,  421,  422,   95,   62,  366,   73,   74,  448,  449,
 /*   180 */   180,   78,  182,  453,  454,  435,   83,   84,  117,  414,
 /*   190 */   360,  416,   89,  443,  160,  127,   12,   13,   14,   15,
 /*   200 */    16,  371,    4,  132,  133,  205,  206,  161,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  161,  162,  399,
 /*   230 */   400,   20,  161,  162,  425,  426,  427,  350,  429,  430,
 /*   240 */   410,   43,  433,   45,   46,  358,   95,   20,  358,   22,
 /*   250 */    37,  180,  205,  182,  367,  187,  188,  448,  449,  191,
 /*   260 */    79,  193,  453,  454,  374,  231,  232,  233,  234,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,  205,  206,   51,  208,
 /*   280 */   209,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   290 */   219,  220,  221,  222,  223,  224,  225,  226,    3,  228,
 /*   300 */    12,   13,  255,  256,  257,  258,  259,  228,   20,  230,
 /*   310 */    22,   98,   20,  100,  101,   20,  103,  335,  137,  138,
 /*   320 */   107,   33,  244,   35,  108,  109,  110,  111,  112,  113,
 /*   330 */   114,  115,  116,  117,  118,    0,  120,  121,  122,  123,
 /*   340 */   124,  125,  129,  132,  133,   58,   58,   58,  366,   58,
 /*   350 */   429,   63,  126,   63,  433,  339,   21,  228,   70,   24,
 /*   360 */    25,   26,   27,   28,   29,   30,   31,   32,  358,  353,
 /*   370 */   449,   12,   13,   14,  453,  454,  414,  361,  416,   20,
 /*   380 */   387,   22,   95,   95,   97,   94,   97,   95,   97,   95,
 /*   390 */   380,   96,   33,   21,   35,  244,   24,   25,   26,   27,
 /*   400 */    28,   29,   30,   31,   32,  117,  424,  425,  426,  427,
 /*   410 */    95,  429,  430,   33,  373,  189,  190,   58,  373,  429,
 /*   420 */   132,  133,  429,  433,  383,  341,  433,  386,   48,   70,
 /*   430 */    20,  386,   22,  166,   54,   55,   56,   57,   58,  449,
 /*   440 */    22,  448,  449,  453,  454,   35,  453,  454,  364,  161,
 /*   450 */   162,  126,  127,   35,   95,    0,  131,   20,  163,    8,
 /*   460 */     9,   51,  358,   12,   13,   14,   15,   16,  180,  365,
 /*   470 */   182,   20,   20,  179,   94,  181,  117,   97,  374,   24,
 /*   480 */    25,   26,   27,   28,   29,   30,   31,   32,   70,  402,
 /*   490 */   327,  132,  133,  205,  206,  205,  208,  209,  210,  211,
 /*   500 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   510 */   222,  223,  224,  225,  226,  428,  249,  250,  251,   14,
 /*   520 */   161,  162,    8,    9,  160,   20,   12,   13,   14,   15,
 /*   530 */    16,  244,   95,  429,  371,  117,  244,  433,  244,  180,
 /*   540 */   175,  182,   20,  358,  164,  165,    0,  167,  418,  419,
 /*   550 */   170,  366,  448,  449,  358,  387,   20,  453,  454,  244,
 /*   560 */   327,  196,  197,  367,  205,  206,  186,  208,  209,  210,
 /*   570 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   580 */   221,  222,  223,  224,  225,  226,   12,   13,  335,  335,
 /*   590 */   405,  358,  372,  373,   20,  231,   22,  429,  180,  366,
 /*   600 */   182,  433,  349,  349,  371,  241,  373,   33,   62,   35,
 /*   610 */    96,   14,   15,   16,  163,  163,  448,  449,  358,  366,
 /*   620 */   366,  453,  454,  205,  206,  365,  387,  344,  345,  396,
 /*   630 */     3,  335,   58,  400,  374,   39,  403,  404,  405,  406,
 /*   640 */   407,  408,    0,  410,   70,  349,  413,  402,  415,  416,
 /*   650 */   417,  327,  356,  402,  421,  422,  387,   12,   13,   20,
 /*   660 */     4,   21,  366,  335,  327,   20,  161,   22,  429,   95,
 /*   670 */     1,    2,  433,  428,   34,   19,   36,  349,   33,  428,
 /*   680 */    35,  244,  358,  339,  356,  366,   35,  448,  449,   33,
 /*   690 */   366,  117,  453,  454,  366,  371,  377,  373,  429,  344,
 /*   700 */   345,   20,  433,   58,   48,  361,  132,  133,  371,   53,
 /*   710 */   413,  335,  106,  416,   58,   70,  327,  448,  449,  327,
 /*   720 */   396,   70,  453,  454,  400,  349,  366,  403,  404,  405,
 /*   730 */   406,  407,  408,  335,  410,  161,  162,  377,   62,  415,
 /*   740 */    95,  417,  366,  335,  335,  421,  422,  349,  351,  107,
 /*   750 */    94,  354,  368,   97,  180,  371,  182,  349,  349,  107,
 /*   760 */   371,  327,  117,  371,  366,   96,    0,  443,  126,  127,
 /*   770 */   128,  129,  130,  131,  366,  366,   70,  132,  133,  205,
 /*   780 */   206,  129,  208,  209,  210,  211,  212,  213,  214,  215,
 /*   790 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   800 */   226,   18,  163,   20,  335,  371,  161,  162,  327,  368,
 /*   810 */    27,  368,  371,   30,  371,   49,   33,  351,  349,   70,
 /*   820 */   354,  346,   42,  348,   44,  180,    0,  182,  327,  327,
 /*   830 */   327,   48,   44,   50,    2,  366,   53,   45,   46,  243,
 /*   840 */     8,    9,    0,    0,   12,   13,   14,   15,   16,   20,
 /*   850 */   205,  206,  371,  208,  209,  210,  211,  212,  213,  214,
 /*   860 */   215,  216,  217,  218,  219,  220,  221,  222,  223,  224,
 /*   870 */   225,  226,  371,  371,  371,    8,    9,   94,  359,   12,
 /*   880 */    13,   14,   15,   16,   96,   99,  242,  243,  102,  106,
 /*   890 */   263,   65,   66,   67,   68,   69,    4,   71,   72,   73,
 /*   900 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   910 */    84,   85,   86,   87,   88,   89,   90,   91,   42,  136,
 /*   920 */    44,   35,  139,  140,  141,  142,  143,  144,  145,  146,
 /*   930 */   147,  148,  149,  150,  151,  152,  153,  154,  155,  106,
 /*   940 */   157,  158,  159,   18,   44,  387,    8,    9,   23,  107,
 /*   950 */    12,   13,   14,   15,   16,   99,   99,  327,  102,  102,
 /*   960 */   327,  327,   37,   38,   99,  328,   41,  102,  126,  127,
 /*   970 */   128,  129,  130,  131,  359,    8,    9,  327,  335,   12,
 /*   980 */    13,   14,   15,   16,   59,   60,   61,  429,  358,  156,
 /*   990 */   161,  433,  349,  335,  151,   44,  366,  327,  327,  327,
 /*  1000 */    95,  371,   22,  373,  371,  371,  448,  449,  358,  366,
 /*  1010 */   105,  453,  454,  335,  163,   35,  366,  335,  335,  168,
 /*  1020 */    95,  371,  327,  373,  366,    0,  396,  349,   44,   44,
 /*  1030 */   400,  349,  349,  403,  404,  405,  406,  407,  408,  172,
 /*  1040 */   410,  371,  371,  371,  366,  415,  396,  417,  366,  366,
 /*  1050 */   400,  421,  422,  403,  404,  405,  406,  407,  408,  134,
 /*  1060 */   410,   35,  432,   96,  335,  415,  371,  417,  182,  327,
 /*  1070 */   107,  421,  422,   48,  327,  132,  133,  327,  349,  359,
 /*  1080 */    96,   96,  432,  425,  426,  427,  359,  429,  430,  126,
 /*  1090 */   127,  128,  129,  130,  131,  366,  359,  172,  173,  174,
 /*  1100 */   358,  163,  177,  335,  359,  335,  347,  381,  366,  446,
 /*  1110 */   335,    0,  327,  371,   44,  373,  327,  349,  371,  349,
 /*  1120 */   195,  371,  457,  198,  349,  200,  201,  202,  203,  204,
 /*  1130 */   335,    1,    2,   22,  366,  268,  366,  245,  396,  335,
 /*  1140 */   335,  366,  400,  358,  349,  403,  404,  405,  406,  407,
 /*  1150 */   408,  366,  410,  349,  349,  327,  371,  415,  373,  417,
 /*  1160 */   371,  366,    0,  421,  422,    0,   96,  267,  327,  244,
 /*  1170 */   366,  366,    8,    9,  432,   44,   12,   13,   14,   15,
 /*  1180 */    16,  396,  335,  337,   22,  400,  358,   22,  403,  404,
 /*  1190 */   405,  406,  407,  408,  366,  410,  349,  440,   47,  371,
 /*  1200 */   415,  373,  417,   44,   44,   44,  421,  422,  182,  337,
 /*  1210 */    44,   44,  371,  366,  334,   44,  265,  432,   44,   12,
 /*  1220 */    13,   44,  327,   44,  396,   13,   44,   96,  400,   22,
 /*  1230 */    44,  403,  404,  405,  406,  407,  408,   13,  410,   35,
 /*  1240 */    33,  358,   35,  415,  381,  417,   95,   35,  370,  421,
 /*  1250 */   422,  381,  431,  358,  423,   96,   96,   96,  450,   35,
 /*  1260 */   432,  366,   96,   96,  434,   58,  371,   96,  373,  246,
 /*  1270 */    96,  398,  397,   96,   70,   96,  327,   70,   96,   48,
 /*  1280 */   178,   42,   96,  389,  378,   20,  378,  160,  381,  376,
 /*  1290 */    20,  396,  335,  335,  378,  400,  376,  376,  403,  404,
 /*  1300 */   405,  406,  407,  408,   93,  410,  335,  358,  343,  335,
 /*  1310 */   415,  335,  417,   20,   20,  366,  421,  422,  329,  329,
 /*  1320 */   371,  393,  373,  341,  117,  373,   20,  341,  336,   20,
 /*  1330 */   388,  336,  341,  335,  341,  341,   52,  341,  341,  338,
 /*  1340 */   338,  329,  329,  335,  371,  396,  358,  194,  371,  400,
 /*  1350 */   395,  392,  403,  404,  405,  406,  407,  408,  358,  410,
 /*  1360 */   339,  358,  327,  358,  415,  358,  417,  358,  358,  358,
 /*  1370 */   421,  422,  358,  358,  358,  185,  393,  373,  339,  335,
 /*  1380 */   381,  260,  254,  439,  439,  253,  171,  180,  442,  182,
 /*  1390 */   371,  371,  438,  358,  441,  371,  262,  261,  381,  371,
 /*  1400 */   439,  366,  384,  437,  247,  436,  371,  269,  373,  266,
 /*  1410 */   264,  384,  205,  206,  458,  243,  452,  366,   20,  451,
 /*  1420 */   398,  335,  339,  336,  217,  218,  219,  220,  221,  222,
 /*  1430 */   223,  396,  402,  384,  371,  400,  327,  371,  403,  404,
 /*  1440 */   405,  406,  407,  408,  371,  410,  371,  371,  384,  371,
 /*  1450 */   415,  165,  417,  382,  339,  354,  421,  422,  339,  366,
 /*  1460 */    95,  420,   95,  371,  348,  362,   36,  358,  335,  330,
 /*  1470 */   329,  390,  352,  394,  339,  366,  385,  352,  352,  327,
 /*  1480 */   371,  385,  373,  325,  340,    0,    0,  187,    0,    0,
 /*  1490 */    42,    0,   35,   35,  199,   35,   35,  199,    0,   35,
 /*  1500 */    35,  199,    0,  199,    0,  396,   35,    0,    0,  400,
 /*  1510 */   358,   35,  403,  404,  405,  406,  407,  408,  366,  410,
 /*  1520 */   182,   22,  327,  371,  180,  373,  417,  176,  175,    0,
 /*  1530 */   421,  422,    0,    0,    0,    0,    0,   47,    0,   42,
 /*  1540 */     0,    0,    0,    0,    0,    0,    0,    0,  396,   35,
 /*  1550 */   327,  151,  400,  358,    0,  403,  404,  405,  406,  407,
 /*  1560 */   408,  366,  410,  151,    0,    0,  371,    0,  373,  417,
 /*  1570 */    42,    0,    0,  421,  422,    0,    0,    0,    0,    0,
 /*  1580 */     0,  358,    0,    0,    0,    0,    0,    0,    0,  366,
 /*  1590 */     0,  396,    0,    0,  371,  400,  373,    0,  403,  404,
 /*  1600 */   405,  406,  407,  408,    0,  410,    0,  135,    0,   35,
 /*  1610 */     0,   22,  417,   58,    0,   58,  421,  422,    0,  396,
 /*  1620 */     0,   14,   19,  400,    0,   44,  403,  404,  405,  406,
 /*  1630 */   407,  408,  409,  410,  411,  412,   33,   42,  327,   39,
 /*  1640 */    14,   47,   40,   47,   39,   47,    0,    0,    0,  171,
 /*  1650 */    39,   48,    0,    0,    0,   64,    0,   54,   55,   56,
 /*  1660 */    57,   58,    0,   35,   48,    0,   35,   48,   39,  358,
 /*  1670 */     0,   39,   35,   48,   39,    0,   35,  366,   48,   39,
 /*  1680 */     0,  327,  371,    0,  373,    0,    0,    0,   22,   44,
 /*  1690 */    35,   22,   35,   35,   35,   35,    0,   94,  327,   35,
 /*  1700 */    97,   22,   35,  104,    0,   44,   35,  396,    0,   35,
 /*  1710 */    22,  400,  358,   50,  403,  404,  405,  406,  407,  408,
 /*  1720 */   366,  410,   22,  102,    0,  371,   35,  373,    0,  358,
 /*  1730 */    35,    0,   22,  130,   20,   96,   35,  366,   35,   95,
 /*  1740 */   192,    0,  371,    0,  373,  183,   35,   22,    0,    0,
 /*  1750 */   396,   44,  327,    3,  400,  444,  445,  403,  404,  405,
 /*  1760 */   406,  407,  408,  248,  410,  252,  165,  396,  327,   96,
 /*  1770 */   167,  400,  163,   96,  403,  404,  405,  406,  407,  408,
 /*  1780 */   163,  410,  169,  358,   95,  163,  227,  184,  417,  186,
 /*  1790 */    44,  366,   95,  422,   96,   44,  371,   95,  373,  358,
 /*  1800 */    95,  168,  168,   47,   95,   47,   44,  366,   96,  455,
 /*  1810 */   456,   95,  371,   96,  373,   96,  248,    3,   44,   96,
 /*  1820 */    35,  396,   35,   35,   35,  400,   35,   35,  403,  404,
 /*  1830 */   405,  406,  407,  408,   96,  410,    0,  396,  327,   44,
 /*  1840 */    47,  400,    0,   47,  403,  404,  405,  406,  407,  408,
 /*  1850 */     0,  410,   95,    0,  327,   96,   96,  242,   95,   95,
 /*  1860 */   248,   95,   39,   95,   47,   44,  105,  229,    2,  358,
 /*  1870 */   445,   22,  166,  205,   95,   95,  227,  366,  227,  164,
 /*  1880 */    47,   95,  371,   22,  373,  358,   96,   47,  447,   95,
 /*  1890 */   363,  207,   95,  366,   96,   96,   96,  327,  371,   95,
 /*  1900 */   373,   96,   35,   35,   95,   22,   96,  396,  106,   35,
 /*  1910 */    95,  400,   96,   35,  403,  404,  405,  406,  407,  408,
 /*  1920 */    95,  410,   96,  396,   35,   95,   35,  400,  358,   95,
 /*  1930 */   403,  404,  405,  406,  407,  408,  366,  410,  119,   96,
 /*  1940 */    95,  371,  107,  373,   44,   35,  119,  119,  119,   95,
 /*  1950 */    95,   22,   64,   63,  327,   35,   35,   35,   35,   35,
 /*  1960 */    35,   35,   35,   35,   92,   35,  396,  456,   70,   35,
 /*  1970 */   400,   35,   22,  403,  404,  405,  406,  407,  408,   44,
 /*  1980 */   410,   35,  412,   35,   35,  358,   35,   70,   35,   35,
 /*  1990 */   363,   35,   35,  366,   35,   22,   35,    0,  371,   35,
 /*  2000 */   373,   39,    0,   35,   39,  327,   48,    0,   48,   35,
 /*  2010 */    39,   48,    0,   35,   48,   39,    0,   35,   35,    0,
 /*  2020 */    22,   21,   21,  396,   20,   22,  327,  400,   22,  459,
 /*  2030 */   403,  404,  405,  406,  407,  408,  358,  410,  459,  459,
 /*  2040 */   459,  363,  459,  459,  366,  459,  459,  459,  327,  371,
 /*  2050 */   459,  373,  459,  459,  459,  459,  459,  358,  459,  459,
 /*  2060 */   459,  459,  459,  459,  459,  366,  459,  459,  459,  459,
 /*  2070 */   371,  459,  373,  459,  396,  459,  459,  459,  400,  358,
 /*  2080 */   459,  403,  404,  405,  406,  407,  408,  366,  410,  459,
 /*  2090 */   459,  459,  371,  459,  373,  396,  459,  459,  459,  400,
 /*  2100 */   459,  459,  403,  404,  405,  406,  407,  408,  459,  410,
 /*  2110 */   459,  327,  459,  459,  459,  459,  459,  396,  459,  459,
 /*  2120 */   459,  400,  459,  459,  403,  404,  405,  406,  407,  408,
 /*  2130 */   459,  410,  459,  459,  459,  327,  459,  459,  459,  459,
 /*  2140 */   459,  459,  358,  459,  459,  459,  459,  459,  459,  459,
 /*  2150 */   366,  459,  459,  459,  459,  371,  459,  373,  459,  459,
 /*  2160 */   459,  459,  459,  459,  459,  459,  358,  459,  459,  459,
 /*  2170 */   459,  459,  459,  459,  366,  459,  459,  459,  459,  371,
 /*  2180 */   396,  373,  459,  459,  400,  459,  459,  403,  404,  405,
 /*  2190 */   406,  407,  408,  459,  410,  459,  459,  327,  459,  459,
 /*  2200 */   459,  459,  459,  459,  396,  459,  459,  459,  400,  459,
 /*  2210 */   459,  403,  404,  405,  406,  407,  408,  459,  410,  459,
 /*  2220 */   459,  327,  459,  459,  459,  459,  459,  459,  358,  459,
 /*  2230 */   459,  459,  459,  459,  459,  459,  366,  459,  459,  459,
 /*  2240 */   459,  371,  459,  373,  459,  459,  459,  459,  459,  459,
 /*  2250 */   459,  459,  358,  459,  459,  459,  459,  459,  459,  459,
 /*  2260 */   366,  459,  459,  459,  327,  371,  396,  373,  459,  459,
 /*  2270 */   400,  459,  459,  403,  404,  405,  406,  407,  408,  459,
 /*  2280 */   410,  459,  327,  459,  459,  459,  459,  459,  459,  459,
 /*  2290 */   396,  459,  459,  459,  400,  358,  459,  403,  404,  405,
 /*  2300 */   406,  407,  408,  366,  410,  459,  459,  459,  371,  459,
 /*  2310 */   373,  459,  459,  358,  459,  459,  459,  459,  459,  459,
 /*  2320 */   459,  366,  459,  459,  459,  459,  371,  459,  373,  459,
 /*  2330 */   459,  459,  459,  396,  459,  459,  459,  400,  459,  459,
 /*  2340 */   403,  404,  405,  406,  407,  408,  459,  410,  459,  459,
 /*  2350 */   459,  396,  459,  459,  327,  400,  459,  459,  403,  404,
 /*  2360 */   405,  406,  407,  408,  459,  410,  459,  459,  459,  459,
 /*  2370 */   459,  459,  327,  459,  459,  459,  459,  459,  459,  459,
 /*  2380 */   459,  459,  459,  459,  459,  358,  459,  459,  459,  459,
 /*  2390 */   459,  459,  459,  366,  459,  459,  459,  459,  371,  459,
 /*  2400 */   373,  459,  459,  358,  459,  459,  459,  459,  459,  459,
 /*  2410 */   459,  366,  459,  459,  459,  327,  371,  459,  373,  459,
 /*  2420 */   459,  459,  459,  396,  459,  459,  459,  400,  459,  459,
 /*  2430 */   403,  404,  405,  406,  407,  408,  459,  410,  459,  327,
 /*  2440 */   459,  396,  459,  459,  459,  400,  358,  459,  403,  404,
 /*  2450 */   405,  406,  407,  408,  366,  410,  459,  459,  459,  371,
 /*  2460 */   459,  373,  459,  459,  459,  459,  459,  459,  459,  459,
 /*  2470 */   358,  459,  459,  459,  459,  459,  459,  459,  366,  459,
 /*  2480 */   459,  459,  459,  371,  396,  373,  459,  459,  400,  459,
 /*  2490 */   459,  403,  404,  405,  406,  407,  408,  459,  410,  459,
 /*  2500 */   459,  459,  327,  459,  459,  459,  459,  459,  396,  459,
 /*  2510 */   459,  459,  400,  459,  459,  403,  404,  405,  406,  407,
 /*  2520 */   408,  459,  410,  459,  459,  459,  459,  459,  459,  459,
 /*  2530 */   459,  459,  459,  358,  459,  459,  459,  459,  459,  459,
 /*  2540 */   459,  366,  459,  459,  459,  459,  371,  459,  373,  459,
 /*  2550 */   459,  459,  459,  459,  459,  459,  327,  459,  459,  459,
 /*  2560 */   459,  459,  459,  459,  459,  459,  459,  459,  459,  459,
 /*  2570 */   459,  396,  459,  459,  459,  400,  459,  459,  403,  404,
 /*  2580 */   405,  406,  407,  408,  459,  410,  459,  358,  459,  459,
 /*  2590 */   459,  459,  459,  459,  459,  366,  459,  459,  459,  459,
 /*  2600 */   371,  459,  373,  459,  459,  459,  459,  459,  459,  459,
 /*  2610 */   327,  459,  459,  459,  459,  459,  459,  459,  459,  459,
 /*  2620 */   459,  459,  459,  459,  459,  396,  327,  459,  459,  400,
 /*  2630 */   459,  459,  403,  404,  405,  406,  407,  408,  459,  410,
 /*  2640 */   459,  358,  459,  459,  459,  459,  459,  459,  459,  366,
 /*  2650 */   459,  459,  459,  459,  371,  459,  373,  358,  459,  459,
 /*  2660 */   459,  459,  459,  459,  459,  366,  459,  459,  459,  327,
 /*  2670 */   371,  459,  373,  459,  459,  459,  459,  459,  459,  396,
 /*  2680 */   459,  459,  459,  400,  459,  459,  403,  404,  405,  406,
 /*  2690 */   407,  408,  459,  410,  459,  396,  459,  459,  459,  400,
 /*  2700 */   358,  459,  403,  404,  405,  406,  407,  408,  366,  410,
 /*  2710 */   459,  459,  459,  371,  459,  373,  459,  459,  459,  459,
 /*  2720 */   459,  459,  459,  459,  459,  459,  327,  459,  459,  459,
 /*  2730 */   459,  459,  459,  459,  459,  459,  459,  459,  396,  459,
 /*  2740 */   459,  459,  400,  327,  459,  403,  404,  405,  406,  407,
 /*  2750 */   408,  459,  410,  459,  459,  459,  459,  358,  459,  459,
 /*  2760 */   459,  459,  459,  459,  459,  366,  459,  459,  459,  327,
 /*  2770 */   371,  459,  373,  459,  358,  459,  459,  459,  459,  459,
 /*  2780 */   459,  459,  366,  459,  459,  459,  459,  371,  459,  373,
 /*  2790 */   459,  459,  459,  459,  459,  396,  459,  459,  459,  400,
 /*  2800 */   358,  459,  403,  404,  405,  406,  407,  408,  366,  410,
 /*  2810 */   459,  459,  396,  371,  459,  373,  400,  459,  459,  403,
 /*  2820 */   404,  405,  406,  407,  408,  459,  410,  459,  459,  459,
 /*  2830 */   327,  459,  459,  459,  459,  459,  459,  459,  396,  459,
 /*  2840 */   459,  459,  400,  459,  459,  403,  404,  405,  406,  407,
 /*  2850 */   408,  459,  410,  459,  459,  459,  459,  459,  459,  459,
 /*  2860 */   459,  358,  459,  459,  459,  459,  459,  459,  459,  366,
 /*  2870 */   459,  459,  459,  459,  371,  459,  373,  459,  459,  459,
 /*  2880 */   459,  459,  459,  459,  327,  459,  459,  459,  459,  459,
 /*  2890 */   459,  459,  459,  459,  459,  459,  459,  459,  459,  396,
 /*  2900 */   459,  459,  459,  400,  459,  459,  403,  404,  405,  406,
 /*  2910 */   407,  408,  459,  410,  459,  358,  459,  459,  459,  459,
 /*  2920 */   459,  459,  459,  366,  459,  459,  459,  459,  371,  459,
 /*  2930 */   373,  459,  459,  459,  459,  459,  459,  459,  459,  459,
 /*  2940 */   459,  459,  459,  459,  459,  459,  459,  459,  459,  459,
 /*  2950 */   459,  459,  459,  396,  459,  459,  459,  400,  459,  459,
 /*  2960 */   403,  404,  405,  406,  407,  408,  459,  410,
};
#define YY_SHIFT_COUNT    (713)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2019)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   925,    0,   71,    0,  288,  288,  288,  288,  288,  288,
 /*    10 */   288,  288,  288,  288,  288,  359,  574,  574,  645,  574,
 /*    20 */   574,  574,  574,  574,  574,  574,  574,  574,  574,  574,
 /*    30 */   574,  574,  574,  574,  574,  574,  574,  574,  574,  574,
 /*    40 */   574,  574,  574,  574,  574,  574,  574,  574,  292,  437,
 /*    50 */    12,  294,  287,  151,  315,  151,   12,   12, 1207, 1207,
 /*    60 */   151, 1207, 1207,   78,  151,   19,   19,  198,  198,   66,
 /*    70 */   211,   98,   98,   19,   19,   19,   19,   19,   19,   19,
 /*    80 */    19,   19,   19,  112,   19,   19,  108,   19,  522,   19,
 /*    90 */    19,  536,   19,   19,  536,   19,  536,  536,  536,   19,
 /*   100 */   676,  783,   34,   34,  372,  103,  418,  418,  418,  418,
 /*   110 */   418,  418,  418,  418,  418,  418,  418,  418,  418,  418,
 /*   120 */   418,  418,  418,  418,  418,  213,  295,   66,  211,   62,
 /*   130 */   651,    1,    1,    1,  546,   79,   79,  651,  681,  681,
 /*   140 */   681,  606,  522,  129,  536,  706,  536,  706,  706,  606,
 /*   150 */   749,  216,  216,  216,  216,  216,  216,  216, 1603,  335,
 /*   160 */    36,  451,  867,   47,  410,  267,   46,  505,  227,  452,
 /*   170 */   792,  652,  639,  644,  596,  627,  644,  780,  892,  829,
 /*   180 */  1023, 1231, 1102, 1239, 1265, 1239, 1127, 1270, 1270, 1239,
 /*   190 */  1127, 1127, 1211, 1270, 1270, 1270, 1293, 1293, 1294,  112,
 /*   200 */   522,  112, 1306, 1309,  112, 1306,  112,  112,  112, 1270,
 /*   210 */   112, 1284, 1284, 1293,  536,  536,  536,  536,  536,  536,
 /*   220 */   536,  536,  536,  536,  536, 1270, 1293,  706,  706, 1153,
 /*   230 */  1294,  676, 1190,  522,  676, 1270, 1265, 1265,  706, 1128,
 /*   240 */  1132,  706, 1128, 1132,  706,  706,  536, 1121, 1215, 1128,
 /*   250 */  1134, 1136, 1157, 1023, 1138, 1143, 1146, 1172,  681, 1398,
 /*   260 */  1270, 1306,  676, 1132,  706,  706,  706,  706,  706, 1132,
 /*   270 */   706, 1286,  676,  606,  676,  681, 1365, 1367,  706,  749,
 /*   280 */  1270,  676, 1430, 1293, 2968, 2968, 2968, 2968, 2968, 2968,
 /*   290 */  2968, 2968, 2968,  826,  380,  455,  656,  514,   15,  967,
 /*   300 */   642,   59,  832,  938,  842, 1164, 1164, 1164, 1164, 1164,
 /*   310 */  1164, 1164, 1164, 1164,  963,   68,  184,  184,  365,  291,
 /*   320 */   181,  640,  226,  325,  325,  597,  669,  364,  597,  597,
 /*   330 */   597,  788, 1025,  980,  876,  833,  843,  786,  856,  857,
 /*   340 */   865, 1111, 1162, 1165,  289,  984,  985,  943,  951,  900,
 /*   350 */   851, 1070, 1131, 1159, 1160, 1161, 1130, 1166,  886, 1026,
 /*   360 */   290, 1167, 1151, 1171, 1174, 1177, 1179, 1182, 1186,  905,
 /*   370 */  1212, 1224, 1204,  766, 1485, 1486, 1300, 1488, 1489, 1448,
 /*   380 */  1491, 1457, 1295, 1458, 1460, 1461, 1298, 1498, 1464, 1465,
 /*   390 */  1302, 1502, 1304, 1504, 1471, 1507, 1499, 1508, 1476, 1338,
 /*   400 */  1344, 1532, 1533, 1351, 1353, 1529, 1534, 1490, 1535, 1536,
 /*   410 */  1538, 1497, 1540, 1541, 1542, 1543, 1544, 1545, 1546, 1547,
 /*   420 */  1400, 1514, 1554, 1412, 1564, 1565, 1567, 1575, 1576, 1577,
 /*   430 */  1578, 1579, 1580, 1582, 1583, 1584, 1585, 1586, 1587, 1528,
 /*   440 */  1571, 1572, 1588, 1590, 1592, 1589, 1593, 1597, 1604, 1472,
 /*   450 */  1606, 1608, 1574, 1610, 1555, 1614, 1557, 1618, 1620, 1595,
 /*   460 */  1600, 1581, 1594, 1607, 1596, 1626, 1598, 1624, 1602, 1605,
 /*   470 */  1646, 1647, 1648, 1611, 1478, 1652, 1653, 1654, 1591, 1656,
 /*   480 */  1662, 1628, 1616, 1629, 1665, 1631, 1619, 1632, 1670, 1637,
 /*   490 */  1625, 1635, 1675, 1641, 1630, 1640, 1680, 1683, 1685, 1686,
 /*   500 */  1599, 1621, 1655, 1666, 1687, 1657, 1658, 1659, 1660, 1645,
 /*   510 */  1661, 1664, 1667, 1669, 1671, 1696, 1679, 1704, 1688, 1663,
 /*   520 */  1708, 1700, 1674, 1724, 1691, 1728, 1695, 1731, 1710, 1714,
 /*   530 */  1701, 1703, 1548, 1639, 1644, 1741, 1609, 1711, 1743, 1562,
 /*   540 */  1725, 1617, 1601, 1748, 1749, 1622, 1613, 1750, 1707, 1515,
 /*   550 */  1689, 1673, 1697, 1633, 1559, 1634, 1513, 1677, 1746, 1698,
 /*   560 */  1702, 1705, 1709, 1712, 1751, 1756, 1758, 1716, 1762, 1568,
 /*   570 */  1717, 1719, 1814, 1774, 1612, 1785, 1787, 1788, 1789, 1791,
 /*   580 */  1792, 1723, 1738, 1793, 1615, 1795, 1796, 1836, 1842, 1850,
 /*   590 */  1757, 1759, 1760, 1763, 1764, 1706, 1766, 1853, 1823, 1715,
 /*   600 */  1768, 1761, 1594, 1817, 1821, 1649, 1638, 1651, 1866, 1849,
 /*   610 */  1668, 1779, 1790, 1780, 1798, 1786, 1799, 1833, 1794, 1797,
 /*   620 */  1840, 1800, 1861, 1684, 1804, 1802, 1805, 1867, 1868, 1809,
 /*   630 */  1810, 1874, 1815, 1816, 1878, 1825, 1826, 1889, 1830, 1843,
 /*   640 */  1891, 1834, 1819, 1827, 1828, 1829, 1883, 1835, 1845, 1900,
 /*   650 */  1854, 1910, 1855, 1900, 1900, 1929, 1888, 1890, 1920, 1921,
 /*   660 */  1922, 1923, 1924, 1925, 1926, 1927, 1928, 1930, 1898, 1872,
 /*   670 */  1935, 1934, 1936, 1946, 1950, 1948, 1949, 1951, 1917, 1645,
 /*   680 */  1953, 1661, 1954, 1956, 1957, 1959, 1973, 1961, 1997, 1964,
 /*   690 */  1958, 1962, 2002, 1968, 1960, 1965, 2007, 1974, 1963, 1971,
 /*   700 */  2012, 1978, 1966, 1976, 2016, 1982, 1983, 2019, 1998, 2000,
 /*   710 */  2003, 2006, 2001, 2004,
};
#define YY_REDUCE_COUNT (292)
#define YY_REDUCE_MIN   (-381)
#define YY_REDUCE_MAX   (2557)
static const short yy_reduce_ofst[] = {
 /*     0 */  -318, -250,  233,  324,  630,  650,  742,  785,  828,  895,
 /*    10 */   949, 1035, 1109, 1152, 1195, 1223, 1311, 1354, 1371, 1425,
 /*    20 */  1441, 1511, 1527, 1570, 1627, 1678, 1699, 1721, 1784, 1808,
 /*    30 */  1870, 1894, 1937, 1955, 2027, 2045, 2088, 2112, 2175, 2229,
 /*    40 */  2283, 2299, 2342, 2399, 2416, 2442, 2503, 2557, -191,  104,
 /*    50 */   -18,   -7,  168,  239,  269,  558, -278,  658, -345, -320,
 /*    60 */  -270, -273, -170,  -79,  -10,  296,  328, -331, -326, -342,
 /*    70 */  -328, -236, -193,  253,  254,  376,  398,  408,  409,  469,
 /*    80 */   643,  678,  682, -330,  683,  729,  185,  768,   41,  770,
 /*    90 */   775, -349,  795,  804, -280,  805, -245,  260, -113,  847,
 /*   100 */    16, -283,  130,  130, -309, -202,  163,  337,  389,  392,
 /*   110 */   434,  481,  501,  502,  503,  633,  634,  670,  671,  672,
 /*   120 */   695,  747,  750,  789,  841, -281,   87,   10,  220,   84,
 /*   130 */   283,   87,  245,  251,  344, -225,  -38,  355, -313,  319,
 /*   140 */   360,  397,   45,  297,  196,  384, -110,  441,  443,  466,
 /*   150 */   475, -355,  519,  615,  720,  727,  737,  745, -381,  637,
 /*   160 */   759,  726,  665,  663,  846,  757,  883,  883,  872,  863,
 /*   170 */   880,  878,  870,  821,  821,  808,  821,  831,  830,  883,
 /*   180 */   873,  875,  894,  906,  907,  908,  913,  957,  958,  916,
 /*   190 */   920,  921,  965,  971,  974,  976,  989,  990,  928,  982,
 /*   200 */   952,  986,  992,  942,  991,  995,  993,  994,  996,  998,
 /*   210 */   997, 1001, 1002, 1012,  988, 1000, 1003, 1005, 1007, 1009,
 /*   220 */  1010, 1011, 1014, 1015, 1016, 1008, 1013,  973,  977,  955,
 /*   230 */   983, 1021,  959, 1004, 1039, 1044,  999, 1017, 1019,  944,
 /*   240 */  1018, 1020,  945, 1027, 1024, 1028,  883,  946,  953,  961,
 /*   250 */   954,  966,  969, 1022,  956,  964,  968,  821, 1051, 1030,
 /*   260 */  1086, 1087, 1083, 1049, 1063, 1066, 1073, 1075, 1076, 1064,
 /*   270 */  1078, 1071, 1115, 1101, 1119, 1093, 1041, 1103, 1092, 1116,
 /*   280 */  1133, 1135, 1139, 1141, 1081, 1079, 1091, 1096, 1120, 1125,
 /*   290 */  1126, 1144, 1158,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*    10 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*    20 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*    30 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*    40 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*    50 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*    60 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1849,
 /*    70 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*    80 */  1594, 1594, 1594, 1672, 1594, 1594, 1594, 1594, 1594, 1594,
 /*    90 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   100 */  1670, 1842, 2039, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   110 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   120 */  1594, 1594, 1594, 1594, 1594, 1594, 2051, 1594, 1594, 1672,
 /*   130 */  1594, 2051, 2051, 2051, 1670, 2011, 2011, 1594, 1594, 1594,
 /*   140 */  1594, 1779, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1779,
 /*   150 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1886, 1594,
 /*   160 */  1594, 2076, 2130, 1594, 1594, 2079, 1594, 1594, 1594, 1854,
 /*   170 */  1594, 1732, 2066, 2043, 2057, 2114, 2044, 2041, 2060, 1594,
 /*   180 */  2070, 1594, 1879, 1847, 1594, 1847, 1844, 1594, 1594, 1847,
 /*   190 */  1844, 1844, 1723, 1594, 1594, 1594, 1594, 1594, 1594, 1672,
 /*   200 */  1594, 1672, 1594, 1594, 1672, 1594, 1672, 1672, 1672, 1594,
 /*   210 */  1672, 1651, 1651, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   220 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1899,
 /*   230 */  1594, 1670, 1888, 1594, 1670, 1594, 1594, 1594, 1594, 2087,
 /*   240 */  2085, 1594, 2087, 2085, 1594, 1594, 1594, 2099, 2095, 2087,
 /*   250 */  2103, 2101, 2072, 2070, 2133, 2120, 2116, 2057, 1594, 1594,
 /*   260 */  1594, 1594, 1670, 2085, 1594, 1594, 1594, 1594, 1594, 2085,
 /*   270 */  1594, 1594, 1670, 1594, 1670, 1594, 1594, 1748, 1594, 1594,
 /*   280 */  1594, 1670, 1626, 1594, 1881, 1892, 1864, 1864, 1782, 1782,
 /*   290 */  1782, 1673, 1599, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   300 */  1594, 1594, 1594, 1594, 1594, 2098, 2097, 1967, 1594, 2015,
 /*   310 */  2014, 2013, 2004, 1966, 1744, 1594, 1965, 1964, 1594, 1594,
 /*   320 */  1594, 1594, 1594, 1860, 1859, 1958, 1594, 1594, 1959, 1957,
 /*   330 */  1956, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   340 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 2117, 2121,
 /*   350 */  1594, 1594, 1594, 1594, 1594, 1594, 2040, 1594, 1594, 1594,
 /*   360 */  1594, 1594, 1941, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   370 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   380 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   390 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   400 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   410 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   420 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   430 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   440 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   450 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   460 */  1594, 1631, 1946, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   470 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   480 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   490 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   500 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1711,
 /*   510 */  1710, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   520 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   530 */  1594, 1594, 1594, 1949, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   540 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 2113, 2073, 1594,
 /*   550 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   560 */  1594, 1594, 1594, 1594, 1594, 1594, 1941, 1594, 2096, 1594,
 /*   570 */  1594, 2111, 1594, 2115, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   580 */  1594, 2050, 2046, 1594, 1594, 2042, 1594, 1594, 1594, 1594,
 /*   590 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   600 */  1594, 1594, 1940, 1594, 2001, 1594, 1594, 1594, 2035, 1594,
 /*   610 */  1594, 1986, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   620 */  1594, 1949, 1594, 1952, 1594, 1594, 1594, 1594, 1594, 1776,
 /*   630 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   640 */  1594, 1594, 1761, 1759, 1758, 1757, 1594, 1754, 1594, 1789,
 /*   650 */  1594, 1594, 1594, 1785, 1784, 1594, 1594, 1594, 1594, 1594,
 /*   660 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   670 */  1691, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1683,
 /*   680 */  1594, 1682, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   690 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   700 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*   710 */  1594, 1594, 1594, 1594,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  270,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*      START => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  270,  /*      AFTER => ABORT */
  270,  /*     ATTACH => ABORT */
  270,  /*     BEFORE => ABORT */
  270,  /*      BEGIN => ABORT */
  270,  /*     BITAND => ABORT */
  270,  /*     BITNOT => ABORT */
  270,  /*      BITOR => ABORT */
  270,  /*     BLOCKS => ABORT */
  270,  /*     CHANGE => ABORT */
  270,  /*      COMMA => ABORT */
  270,  /*    COMPACT => ABORT */
  270,  /*     CONCAT => ABORT */
  270,  /*   CONFLICT => ABORT */
  270,  /*       COPY => ABORT */
  270,  /*   DEFERRED => ABORT */
  270,  /* DELIMITERS => ABORT */
  270,  /*     DETACH => ABORT */
  270,  /*     DIVIDE => ABORT */
  270,  /*        DOT => ABORT */
  270,  /*       EACH => ABORT */
  270,  /*       FAIL => ABORT */
  270,  /*       FILE => ABORT */
  270,  /*        FOR => ABORT */
  270,  /*       GLOB => ABORT */
  270,  /*         ID => ABORT */
  270,  /*  IMMEDIATE => ABORT */
  270,  /*     IMPORT => ABORT */
  270,  /*  INITIALLY => ABORT */
  270,  /*    INSTEAD => ABORT */
  270,  /*     ISNULL => ABORT */
  270,  /*        KEY => ABORT */
  270,  /*    MODULES => ABORT */
  270,  /*  NK_BITNOT => ABORT */
  270,  /*    NK_SEMI => ABORT */
  270,  /*    NOTNULL => ABORT */
  270,  /*         OF => ABORT */
  270,  /*       PLUS => ABORT */
  270,  /*  PRIVILEGE => ABORT */
  270,  /*      RAISE => ABORT */
  270,  /*    REPLACE => ABORT */
  270,  /*   RESTRICT => ABORT */
  270,  /*        ROW => ABORT */
  270,  /*       SEMI => ABORT */
  270,  /*       STAR => ABORT */
  270,  /*  STATEMENT => ABORT */
  270,  /*     STRICT => ABORT */
  270,  /*     STRING => ABORT */
  270,  /*      TIMES => ABORT */
  270,  /*     UPDATE => ABORT */
  270,  /*     VALUES => ABORT */
  270,  /*   VARIABLE => ABORT */
  270,  /*       VIEW => ABORT */
  270,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "IF",
  /*   63 */ "NOT",
  /*   64 */ "EXISTS",
  /*   65 */ "BUFFER",
  /*   66 */ "CACHEMODEL",
  /*   67 */ "CACHESIZE",
  /*   68 */ "COMP",
  /*   69 */ "DURATION",
  /*   70 */ "NK_VARIABLE",
  /*   71 */ "MAXROWS",
  /*   72 */ "MINROWS",
  /*   73 */ "KEEP",
  /*   74 */ "PAGES",
  /*   75 */ "PAGESIZE",
  /*   76 */ "TSDB_PAGESIZE",
  /*   77 */ "PRECISION",
  /*   78 */ "REPLICA",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "WAL_LEVEL",
  /*   84 */ "WAL_FSYNC_PERIOD",
  /*   85 */ "WAL_RETENTION_PERIOD",
  /*   86 */ "WAL_RETENTION_SIZE",
  /*   87 */ "WAL_ROLL_PERIOD",
  /*   88 */ "WAL_SEGMENT_SIZE",
  /*   89 */ "STT_TRIGGER",
  /*   90 */ "TABLE_PREFIX",
  /*   91 */ "TABLE_SUFFIX",
  /*   92 */ "NK_COLON",
  /*   93 */ "MAX_SPEED",
  /*   94 */ "TABLE",
  /*   95 */ "NK_LP",
  /*   96 */ "NK_RP",
  /*   97 */ "STABLE",
  /*   98 */ "ADD",
  /*   99 */ "COLUMN",
  /*  100 */ "MODIFY",
  /*  101 */ "RENAME",
  /*  102 */ "TAG",
  /*  103 */ "SET",
  /*  104 */ "NK_EQ",
  /*  105 */ "USING",
  /*  106 */ "TAGS",
  /*  107 */ "COMMENT",
  /*  108 */ "BOOL",
  /*  109 */ "TINYINT",
  /*  110 */ "SMALLINT",
  /*  111 */ "INT",
  /*  112 */ "INTEGER",
  /*  113 */ "BIGINT",
  /*  114 */ "FLOAT",
  /*  115 */ "DOUBLE",
  /*  116 */ "BINARY",
  /*  117 */ "TIMESTAMP",
  /*  118 */ "NCHAR",
  /*  119 */ "UNSIGNED",
  /*  120 */ "JSON",
  /*  121 */ "VARCHAR",
  /*  122 */ "MEDIUMBLOB",
  /*  123 */ "BLOB",
  /*  124 */ "VARBINARY",
  /*  125 */ "DECIMAL",
  /*  126 */ "MAX_DELAY",
  /*  127 */ "WATERMARK",
  /*  128 */ "ROLLUP",
  /*  129 */ "TTL",
  /*  130 */ "SMA",
  /*  131 */ "DELETE_MARK",
  /*  132 */ "FIRST",
  /*  133 */ "LAST",
  /*  134 */ "SHOW",
  /*  135 */ "PRIVILEGES",
  /*  136 */ "DATABASES",
  /*  137 */ "TABLES",
  /*  138 */ "STABLES",
  /*  139 */ "MNODES",
  /*  140 */ "QNODES",
  /*  141 */ "FUNCTIONS",
  /*  142 */ "INDEXES",
  /*  143 */ "ACCOUNTS",
  /*  144 */ "APPS",
  /*  145 */ "CONNECTIONS",
  /*  146 */ "LICENCES",
  /*  147 */ "GRANTS",
  /*  148 */ "QUERIES",
  /*  149 */ "SCORES",
  /*  150 */ "TOPICS",
  /*  151 */ "VARIABLES",
  /*  152 */ "CLUSTER",
  /*  153 */ "BNODES",
  /*  154 */ "SNODES",
  /*  155 */ "TRANSACTIONS",
  /*  156 */ "DISTRIBUTED",
  /*  157 */ "CONSUMERS",
  /*  158 */ "SUBSCRIPTIONS",
  /*  159 */ "VNODES",
  /*  160 */ "LIKE",
  /*  161 */ "TBNAME",
  /*  162 */ "QTAGS",
  /*  163 */ "AS",
  /*  164 */ "INDEX",
  /*  165 */ "FUNCTION",
  /*  166 */ "INTERVAL",
  /*  167 */ "TOPIC",
  /*  168 */ "WITH",
  /*  169 */ "META",
  /*  170 */ "CONSUMER",
  /*  171 */ "GROUP",
  /*  172 */ "DESC",
  /*  173 */ "DESCRIBE",
  /*  174 */ "RESET",
  /*  175 */ "QUERY",
  /*  176 */ "CACHE",
  /*  177 */ "EXPLAIN",
  /*  178 */ "ANALYZE",
  /*  179 */ "VERBOSE",
  /*  180 */ "NK_BOOL",
  /*  181 */ "RATIO",
  /*  182 */ "NK_FLOAT",
  /*  183 */ "OUTPUTTYPE",
  /*  184 */ "AGGREGATE",
  /*  185 */ "BUFSIZE",
  /*  186 */ "STREAM",
  /*  187 */ "INTO",
  /*  188 */ "TRIGGER",
  /*  189 */ "AT_ONCE",
  /*  190 */ "WINDOW_CLOSE",
  /*  191 */ "IGNORE",
  /*  192 */ "EXPIRED",
  /*  193 */ "FILL_HISTORY",
  /*  194 */ "SUBTABLE",
  /*  195 */ "KILL",
  /*  196 */ "CONNECTION",
  /*  197 */ "TRANSACTION",
  /*  198 */ "BALANCE",
  /*  199 */ "VGROUP",
  /*  200 */ "MERGE",
  /*  201 */ "REDISTRIBUTE",
  /*  202 */ "SPLIT",
  /*  203 */ "DELETE",
  /*  204 */ "INSERT",
  /*  205 */ "NULL",
  /*  206 */ "NK_QUESTION",
  /*  207 */ "NK_ARROW",
  /*  208 */ "ROWTS",
  /*  209 */ "QSTART",
  /*  210 */ "QEND",
  /*  211 */ "QDURATION",
  /*  212 */ "WSTART",
  /*  213 */ "WEND",
  /*  214 */ "WDURATION",
  /*  215 */ "IROWTS",
  /*  216 */ "CAST",
  /*  217 */ "NOW",
  /*  218 */ "TODAY",
  /*  219 */ "TIMEZONE",
  /*  220 */ "CLIENT_VERSION",
  /*  221 */ "SERVER_VERSION",
  /*  222 */ "SERVER_STATUS",
  /*  223 */ "CURRENT_USER",
  /*  224 */ "COUNT",
  /*  225 */ "LAST_ROW",
  /*  226 */ "CASE",
  /*  227 */ "END",
  /*  228 */ "WHEN",
  /*  229 */ "THEN",
  /*  230 */ "ELSE",
  /*  231 */ "BETWEEN",
  /*  232 */ "IS",
  /*  233 */ "NK_LT",
  /*  234 */ "NK_GT",
  /*  235 */ "NK_LE",
  /*  236 */ "NK_GE",
  /*  237 */ "NK_NE",
  /*  238 */ "MATCH",
  /*  239 */ "NMATCH",
  /*  240 */ "CONTAINS",
  /*  241 */ "IN",
  /*  242 */ "JOIN",
  /*  243 */ "INNER",
  /*  244 */ "SELECT",
  /*  245 */ "DISTINCT",
  /*  246 */ "WHERE",
  /*  247 */ "PARTITION",
  /*  248 */ "BY",
  /*  249 */ "SESSION",
  /*  250 */ "STATE_WINDOW",
  /*  251 */ "EVENT_WINDOW",
  /*  252 */ "START",
  /*  253 */ "SLIDING",
  /*  254 */ "FILL",
  /*  255 */ "VALUE",
  /*  256 */ "NONE",
  /*  257 */ "PREV",
  /*  258 */ "LINEAR",
  /*  259 */ "NEXT",
  /*  260 */ "HAVING",
  /*  261 */ "RANGE",
  /*  262 */ "EVERY",
  /*  263 */ "ORDER",
  /*  264 */ "SLIMIT",
  /*  265 */ "SOFFSET",
  /*  266 */ "LIMIT",
  /*  267 */ "OFFSET",
  /*  268 */ "ASC",
  /*  269 */ "NULLS",
  /*  270 */ "ABORT",
  /*  271 */ "AFTER",
  /*  272 */ "ATTACH",
  /*  273 */ "BEFORE",
  /*  274 */ "BEGIN",
  /*  275 */ "BITAND",
  /*  276 */ "BITNOT",
  /*  277 */ "BITOR",
  /*  278 */ "BLOCKS",
  /*  279 */ "CHANGE",
  /*  280 */ "COMMA",
  /*  281 */ "COMPACT",
  /*  282 */ "CONCAT",
  /*  283 */ "CONFLICT",
  /*  284 */ "COPY",
  /*  285 */ "DEFERRED",
  /*  286 */ "DELIMITERS",
  /*  287 */ "DETACH",
  /*  288 */ "DIVIDE",
  /*  289 */ "DOT",
  /*  290 */ "EACH",
  /*  291 */ "FAIL",
  /*  292 */ "FILE",
  /*  293 */ "FOR",
  /*  294 */ "GLOB",
  /*  295 */ "ID",
  /*  296 */ "IMMEDIATE",
  /*  297 */ "IMPORT",
  /*  298 */ "INITIALLY",
  /*  299 */ "INSTEAD",
  /*  300 */ "ISNULL",
  /*  301 */ "KEY",
  /*  302 */ "MODULES",
  /*  303 */ "NK_BITNOT",
  /*  304 */ "NK_SEMI",
  /*  305 */ "NOTNULL",
  /*  306 */ "OF",
  /*  307 */ "PLUS",
  /*  308 */ "PRIVILEGE",
  /*  309 */ "RAISE",
  /*  310 */ "REPLACE",
  /*  311 */ "RESTRICT",
  /*  312 */ "ROW",
  /*  313 */ "SEMI",
  /*  314 */ "STAR",
  /*  315 */ "STATEMENT",
  /*  316 */ "STRICT",
  /*  317 */ "STRING",
  /*  318 */ "TIMES",
  /*  319 */ "UPDATE",
  /*  320 */ "VALUES",
  /*  321 */ "VARIABLE",
  /*  322 */ "VIEW",
  /*  323 */ "WAL",
  /*  324 */ "cmd",
  /*  325 */ "account_options",
  /*  326 */ "alter_account_options",
  /*  327 */ "literal",
  /*  328 */ "alter_account_option",
  /*  329 */ "user_name",
  /*  330 */ "sysinfo_opt",
  /*  331 */ "privileges",
  /*  332 */ "priv_level",
  /*  333 */ "priv_type_list",
  /*  334 */ "priv_type",
  /*  335 */ "db_name",
  /*  336 */ "topic_name",
  /*  337 */ "dnode_endpoint",
  /*  338 */ "force_opt",
  /*  339 */ "not_exists_opt",
  /*  340 */ "db_options",
  /*  341 */ "exists_opt",
  /*  342 */ "alter_db_options",
  /*  343 */ "speed_opt",
  /*  344 */ "integer_list",
  /*  345 */ "variable_list",
  /*  346 */ "retention_list",
  /*  347 */ "alter_db_option",
  /*  348 */ "retention",
  /*  349 */ "full_table_name",
  /*  350 */ "column_def_list",
  /*  351 */ "tags_def_opt",
  /*  352 */ "table_options",
  /*  353 */ "multi_create_clause",
  /*  354 */ "tags_def",
  /*  355 */ "multi_drop_clause",
  /*  356 */ "alter_table_clause",
  /*  357 */ "alter_table_options",
  /*  358 */ "column_name",
  /*  359 */ "type_name",
  /*  360 */ "signed_literal",
  /*  361 */ "create_subtable_clause",
  /*  362 */ "specific_cols_opt",
  /*  363 */ "expression_list",
  /*  364 */ "drop_table_clause",
  /*  365 */ "col_name_list",
  /*  366 */ "table_name",
  /*  367 */ "column_def",
  /*  368 */ "duration_list",
  /*  369 */ "rollup_func_list",
  /*  370 */ "alter_table_option",
  /*  371 */ "duration_literal",
  /*  372 */ "rollup_func_name",
  /*  373 */ "function_name",
  /*  374 */ "col_name",
  /*  375 */ "db_name_cond_opt",
  /*  376 */ "like_pattern_opt",
  /*  377 */ "table_name_cond",
  /*  378 */ "from_db_opt",
  /*  379 */ "tag_list_opt",
  /*  380 */ "tag_item",
  /*  381 */ "column_alias",
  /*  382 */ "index_options",
  /*  383 */ "func_list",
  /*  384 */ "sliding_opt",
  /*  385 */ "sma_stream_opt",
  /*  386 */ "func",
  /*  387 */ "query_or_subquery",
  /*  388 */ "cgroup_name",
  /*  389 */ "analyze_opt",
  /*  390 */ "explain_options",
  /*  391 */ "agg_func_opt",
  /*  392 */ "bufsize_opt",
  /*  393 */ "stream_name",
  /*  394 */ "stream_options",
  /*  395 */ "subtable_opt",
  /*  396 */ "expression",
  /*  397 */ "dnode_list",
  /*  398 */ "where_clause_opt",
  /*  399 */ "signed",
  /*  400 */ "literal_func",
  /*  401 */ "literal_list",
  /*  402 */ "table_alias",
  /*  403 */ "expr_or_subquery",
  /*  404 */ "pseudo_column",
  /*  405 */ "column_reference",
  /*  406 */ "function_expression",
  /*  407 */ "case_when_expression",
  /*  408 */ "star_func",
  /*  409 */ "star_func_para_list",
  /*  410 */ "noarg_func",
  /*  411 */ "other_para_list",
  /*  412 */ "star_func_para",
  /*  413 */ "when_then_list",
  /*  414 */ "case_when_else_opt",
  /*  415 */ "common_expression",
  /*  416 */ "when_then_expr",
  /*  417 */ "predicate",
  /*  418 */ "compare_op",
  /*  419 */ "in_op",
  /*  420 */ "in_predicate_value",
  /*  421 */ "boolean_value_expression",
  /*  422 */ "boolean_primary",
  /*  423 */ "from_clause_opt",
  /*  424 */ "table_reference_list",
  /*  425 */ "table_reference",
  /*  426 */ "table_primary",
  /*  427 */ "joined_table",
  /*  428 */ "alias_opt",
  /*  429 */ "subquery",
  /*  430 */ "parenthesized_joined_table",
  /*  431 */ "join_type",
  /*  432 */ "search_condition",
  /*  433 */ "query_specification",
  /*  434 */ "set_quantifier_opt",
  /*  435 */ "select_list",
  /*  436 */ "partition_by_clause_opt",
  /*  437 */ "range_opt",
  /*  438 */ "every_opt",
  /*  439 */ "fill_opt",
  /*  440 */ "twindow_clause_opt",
  /*  441 */ "group_by_clause_opt",
  /*  442 */ "having_clause_opt",
  /*  443 */ "select_item",
  /*  444 */ "partition_list",
  /*  445 */ "partition_item",
  /*  446 */ "fill_mode",
  /*  447 */ "group_by_list",
  /*  448 */ "query_expression",
  /*  449 */ "query_simple",
  /*  450 */ "order_by_clause_opt",
  /*  451 */ "slimit_clause_opt",
  /*  452 */ "limit_clause_opt",
  /*  453 */ "union_query_expression",
  /*  454 */ "query_simple_or_subquery",
  /*  455 */ "sort_specification_list",
  /*  456 */ "sort_specification",
  /*  457 */ "ordering_specification_opt",
  /*  458 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  73 */ "not_exists_opt ::=",
 /*  74 */ "exists_opt ::= IF EXISTS",
 /*  75 */ "exists_opt ::=",
 /*  76 */ "db_options ::=",
 /*  77 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  78 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  79 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  81 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  83 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  84 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options KEEP integer_list",
 /*  86 */ "db_options ::= db_options KEEP variable_list",
 /*  87 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  88 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  89 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  91 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  92 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  93 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  94 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  95 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 104 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 105 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 107 */ "alter_db_options ::= alter_db_option",
 /* 108 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 109 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 110 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 111 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 112 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 113 */ "alter_db_option ::= KEEP integer_list",
 /* 114 */ "alter_db_option ::= KEEP variable_list",
 /* 115 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 116 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 117 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 118 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 119 */ "integer_list ::= NK_INTEGER",
 /* 120 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 121 */ "variable_list ::= NK_VARIABLE",
 /* 122 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 123 */ "retention_list ::= retention",
 /* 124 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 125 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 126 */ "speed_opt ::=",
 /* 127 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 128 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 129 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 130 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 131 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 132 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 133 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 134 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 135 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 136 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 142 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 144 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 145 */ "multi_create_clause ::= create_subtable_clause",
 /* 146 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 147 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 148 */ "multi_drop_clause ::= drop_table_clause",
 /* 149 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 150 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 151 */ "specific_cols_opt ::=",
 /* 152 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 153 */ "full_table_name ::= table_name",
 /* 154 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 155 */ "column_def_list ::= column_def",
 /* 156 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 157 */ "column_def ::= column_name type_name",
 /* 158 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 159 */ "type_name ::= BOOL",
 /* 160 */ "type_name ::= TINYINT",
 /* 161 */ "type_name ::= SMALLINT",
 /* 162 */ "type_name ::= INT",
 /* 163 */ "type_name ::= INTEGER",
 /* 164 */ "type_name ::= BIGINT",
 /* 165 */ "type_name ::= FLOAT",
 /* 166 */ "type_name ::= DOUBLE",
 /* 167 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TIMESTAMP",
 /* 169 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TINYINT UNSIGNED",
 /* 171 */ "type_name ::= SMALLINT UNSIGNED",
 /* 172 */ "type_name ::= INT UNSIGNED",
 /* 173 */ "type_name ::= BIGINT UNSIGNED",
 /* 174 */ "type_name ::= JSON",
 /* 175 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 176 */ "type_name ::= MEDIUMBLOB",
 /* 177 */ "type_name ::= BLOB",
 /* 178 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL",
 /* 180 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 182 */ "tags_def_opt ::=",
 /* 183 */ "tags_def_opt ::= tags_def",
 /* 184 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 185 */ "table_options ::=",
 /* 186 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 187 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 188 */ "table_options ::= table_options WATERMARK duration_list",
 /* 189 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 190 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 191 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 192 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 193 */ "alter_table_options ::= alter_table_option",
 /* 194 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 195 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 196 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 197 */ "duration_list ::= duration_literal",
 /* 198 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 199 */ "rollup_func_list ::= rollup_func_name",
 /* 200 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 201 */ "rollup_func_name ::= function_name",
 /* 202 */ "rollup_func_name ::= FIRST",
 /* 203 */ "rollup_func_name ::= LAST",
 /* 204 */ "col_name_list ::= col_name",
 /* 205 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 206 */ "col_name ::= column_name",
 /* 207 */ "cmd ::= SHOW DNODES",
 /* 208 */ "cmd ::= SHOW USERS",
 /* 209 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 210 */ "cmd ::= SHOW DATABASES",
 /* 211 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 214 */ "cmd ::= SHOW MNODES",
 /* 215 */ "cmd ::= SHOW QNODES",
 /* 216 */ "cmd ::= SHOW FUNCTIONS",
 /* 217 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 218 */ "cmd ::= SHOW STREAMS",
 /* 219 */ "cmd ::= SHOW ACCOUNTS",
 /* 220 */ "cmd ::= SHOW APPS",
 /* 221 */ "cmd ::= SHOW CONNECTIONS",
 /* 222 */ "cmd ::= SHOW LICENCES",
 /* 223 */ "cmd ::= SHOW GRANTS",
 /* 224 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 225 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 226 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 227 */ "cmd ::= SHOW QUERIES",
 /* 228 */ "cmd ::= SHOW SCORES",
 /* 229 */ "cmd ::= SHOW TOPICS",
 /* 230 */ "cmd ::= SHOW VARIABLES",
 /* 231 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 232 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 233 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 234 */ "cmd ::= SHOW BNODES",
 /* 235 */ "cmd ::= SHOW SNODES",
 /* 236 */ "cmd ::= SHOW CLUSTER",
 /* 237 */ "cmd ::= SHOW TRANSACTIONS",
 /* 238 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 239 */ "cmd ::= SHOW CONSUMERS",
 /* 240 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 241 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 242 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 244 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 245 */ "db_name_cond_opt ::=",
 /* 246 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 247 */ "like_pattern_opt ::=",
 /* 248 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 249 */ "table_name_cond ::= table_name",
 /* 250 */ "from_db_opt ::=",
 /* 251 */ "from_db_opt ::= FROM db_name",
 /* 252 */ "tag_list_opt ::=",
 /* 253 */ "tag_list_opt ::= tag_item",
 /* 254 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 255 */ "tag_item ::= TBNAME",
 /* 256 */ "tag_item ::= QTAGS",
 /* 257 */ "tag_item ::= column_name",
 /* 258 */ "tag_item ::= column_name column_alias",
 /* 259 */ "tag_item ::= column_name AS column_alias",
 /* 260 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 261 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 262 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 263 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 264 */ "func_list ::= func",
 /* 265 */ "func_list ::= func_list NK_COMMA func",
 /* 266 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 267 */ "sma_stream_opt ::=",
 /* 268 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 269 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 270 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 271 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 272 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 273 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 274 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 275 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 276 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 277 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 278 */ "cmd ::= DESC full_table_name",
 /* 279 */ "cmd ::= DESCRIBE full_table_name",
 /* 280 */ "cmd ::= RESET QUERY CACHE",
 /* 281 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 282 */ "analyze_opt ::=",
 /* 283 */ "analyze_opt ::= ANALYZE",
 /* 284 */ "explain_options ::=",
 /* 285 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 286 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 287 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 288 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 289 */ "agg_func_opt ::=",
 /* 290 */ "agg_func_opt ::= AGGREGATE",
 /* 291 */ "bufsize_opt ::=",
 /* 292 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 293 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 294 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 295 */ "stream_options ::=",
 /* 296 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 297 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 298 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 299 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 300 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 301 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 302 */ "subtable_opt ::=",
 /* 303 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 304 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 305 */ "cmd ::= KILL QUERY NK_STRING",
 /* 306 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 307 */ "cmd ::= BALANCE VGROUP",
 /* 308 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 309 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 310 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 311 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 312 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 313 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 314 */ "cmd ::= query_or_subquery",
 /* 315 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 316 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 317 */ "literal ::= NK_INTEGER",
 /* 318 */ "literal ::= NK_FLOAT",
 /* 319 */ "literal ::= NK_STRING",
 /* 320 */ "literal ::= NK_BOOL",
 /* 321 */ "literal ::= TIMESTAMP NK_STRING",
 /* 322 */ "literal ::= duration_literal",
 /* 323 */ "literal ::= NULL",
 /* 324 */ "literal ::= NK_QUESTION",
 /* 325 */ "duration_literal ::= NK_VARIABLE",
 /* 326 */ "signed ::= NK_INTEGER",
 /* 327 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 328 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 329 */ "signed ::= NK_FLOAT",
 /* 330 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 331 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 332 */ "signed_literal ::= signed",
 /* 333 */ "signed_literal ::= NK_STRING",
 /* 334 */ "signed_literal ::= NK_BOOL",
 /* 335 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 336 */ "signed_literal ::= duration_literal",
 /* 337 */ "signed_literal ::= NULL",
 /* 338 */ "signed_literal ::= literal_func",
 /* 339 */ "signed_literal ::= NK_QUESTION",
 /* 340 */ "literal_list ::= signed_literal",
 /* 341 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 342 */ "db_name ::= NK_ID",
 /* 343 */ "table_name ::= NK_ID",
 /* 344 */ "column_name ::= NK_ID",
 /* 345 */ "function_name ::= NK_ID",
 /* 346 */ "table_alias ::= NK_ID",
 /* 347 */ "column_alias ::= NK_ID",
 /* 348 */ "user_name ::= NK_ID",
 /* 349 */ "topic_name ::= NK_ID",
 /* 350 */ "stream_name ::= NK_ID",
 /* 351 */ "cgroup_name ::= NK_ID",
 /* 352 */ "expr_or_subquery ::= expression",
 /* 353 */ "expression ::= literal",
 /* 354 */ "expression ::= pseudo_column",
 /* 355 */ "expression ::= column_reference",
 /* 356 */ "expression ::= function_expression",
 /* 357 */ "expression ::= case_when_expression",
 /* 358 */ "expression ::= NK_LP expression NK_RP",
 /* 359 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 360 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 361 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 362 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 363 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 364 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 365 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 366 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 367 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 368 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 369 */ "expression_list ::= expr_or_subquery",
 /* 370 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 371 */ "column_reference ::= column_name",
 /* 372 */ "column_reference ::= table_name NK_DOT column_name",
 /* 373 */ "pseudo_column ::= ROWTS",
 /* 374 */ "pseudo_column ::= TBNAME",
 /* 375 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 376 */ "pseudo_column ::= QSTART",
 /* 377 */ "pseudo_column ::= QEND",
 /* 378 */ "pseudo_column ::= QDURATION",
 /* 379 */ "pseudo_column ::= WSTART",
 /* 380 */ "pseudo_column ::= WEND",
 /* 381 */ "pseudo_column ::= WDURATION",
 /* 382 */ "pseudo_column ::= IROWTS",
 /* 383 */ "pseudo_column ::= QTAGS",
 /* 384 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 385 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 386 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 387 */ "function_expression ::= literal_func",
 /* 388 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 389 */ "literal_func ::= NOW",
 /* 390 */ "noarg_func ::= NOW",
 /* 391 */ "noarg_func ::= TODAY",
 /* 392 */ "noarg_func ::= TIMEZONE",
 /* 393 */ "noarg_func ::= DATABASE",
 /* 394 */ "noarg_func ::= CLIENT_VERSION",
 /* 395 */ "noarg_func ::= SERVER_VERSION",
 /* 396 */ "noarg_func ::= SERVER_STATUS",
 /* 397 */ "noarg_func ::= CURRENT_USER",
 /* 398 */ "noarg_func ::= USER",
 /* 399 */ "star_func ::= COUNT",
 /* 400 */ "star_func ::= FIRST",
 /* 401 */ "star_func ::= LAST",
 /* 402 */ "star_func ::= LAST_ROW",
 /* 403 */ "star_func_para_list ::= NK_STAR",
 /* 404 */ "star_func_para_list ::= other_para_list",
 /* 405 */ "other_para_list ::= star_func_para",
 /* 406 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 407 */ "star_func_para ::= expr_or_subquery",
 /* 408 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 409 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 410 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 411 */ "when_then_list ::= when_then_expr",
 /* 412 */ "when_then_list ::= when_then_list when_then_expr",
 /* 413 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 414 */ "case_when_else_opt ::=",
 /* 415 */ "case_when_else_opt ::= ELSE common_expression",
 /* 416 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 417 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 418 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 419 */ "predicate ::= expr_or_subquery IS NULL",
 /* 420 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 421 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 422 */ "compare_op ::= NK_LT",
 /* 423 */ "compare_op ::= NK_GT",
 /* 424 */ "compare_op ::= NK_LE",
 /* 425 */ "compare_op ::= NK_GE",
 /* 426 */ "compare_op ::= NK_NE",
 /* 427 */ "compare_op ::= NK_EQ",
 /* 428 */ "compare_op ::= LIKE",
 /* 429 */ "compare_op ::= NOT LIKE",
 /* 430 */ "compare_op ::= MATCH",
 /* 431 */ "compare_op ::= NMATCH",
 /* 432 */ "compare_op ::= CONTAINS",
 /* 433 */ "in_op ::= IN",
 /* 434 */ "in_op ::= NOT IN",
 /* 435 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 436 */ "boolean_value_expression ::= boolean_primary",
 /* 437 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 438 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 439 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 440 */ "boolean_primary ::= predicate",
 /* 441 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 442 */ "common_expression ::= expr_or_subquery",
 /* 443 */ "common_expression ::= boolean_value_expression",
 /* 444 */ "from_clause_opt ::=",
 /* 445 */ "from_clause_opt ::= FROM table_reference_list",
 /* 446 */ "table_reference_list ::= table_reference",
 /* 447 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 448 */ "table_reference ::= table_primary",
 /* 449 */ "table_reference ::= joined_table",
 /* 450 */ "table_primary ::= table_name alias_opt",
 /* 451 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 452 */ "table_primary ::= subquery alias_opt",
 /* 453 */ "table_primary ::= parenthesized_joined_table",
 /* 454 */ "alias_opt ::=",
 /* 455 */ "alias_opt ::= table_alias",
 /* 456 */ "alias_opt ::= AS table_alias",
 /* 457 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 458 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 459 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 460 */ "join_type ::=",
 /* 461 */ "join_type ::= INNER",
 /* 462 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 463 */ "set_quantifier_opt ::=",
 /* 464 */ "set_quantifier_opt ::= DISTINCT",
 /* 465 */ "set_quantifier_opt ::= ALL",
 /* 466 */ "select_list ::= select_item",
 /* 467 */ "select_list ::= select_list NK_COMMA select_item",
 /* 468 */ "select_item ::= NK_STAR",
 /* 469 */ "select_item ::= common_expression",
 /* 470 */ "select_item ::= common_expression column_alias",
 /* 471 */ "select_item ::= common_expression AS column_alias",
 /* 472 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 473 */ "where_clause_opt ::=",
 /* 474 */ "where_clause_opt ::= WHERE search_condition",
 /* 475 */ "partition_by_clause_opt ::=",
 /* 476 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 477 */ "partition_list ::= partition_item",
 /* 478 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 479 */ "partition_item ::= expr_or_subquery",
 /* 480 */ "partition_item ::= expr_or_subquery column_alias",
 /* 481 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 482 */ "twindow_clause_opt ::=",
 /* 483 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 484 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 485 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 486 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 487 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 488 */ "sliding_opt ::=",
 /* 489 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 490 */ "fill_opt ::=",
 /* 491 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 492 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 493 */ "fill_mode ::= NONE",
 /* 494 */ "fill_mode ::= PREV",
 /* 495 */ "fill_mode ::= NULL",
 /* 496 */ "fill_mode ::= LINEAR",
 /* 497 */ "fill_mode ::= NEXT",
 /* 498 */ "group_by_clause_opt ::=",
 /* 499 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 500 */ "group_by_list ::= expr_or_subquery",
 /* 501 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 502 */ "having_clause_opt ::=",
 /* 503 */ "having_clause_opt ::= HAVING search_condition",
 /* 504 */ "range_opt ::=",
 /* 505 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 506 */ "every_opt ::=",
 /* 507 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 508 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 509 */ "query_simple ::= query_specification",
 /* 510 */ "query_simple ::= union_query_expression",
 /* 511 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 512 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 513 */ "query_simple_or_subquery ::= query_simple",
 /* 514 */ "query_simple_or_subquery ::= subquery",
 /* 515 */ "query_or_subquery ::= query_expression",
 /* 516 */ "query_or_subquery ::= subquery",
 /* 517 */ "order_by_clause_opt ::=",
 /* 518 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 519 */ "slimit_clause_opt ::=",
 /* 520 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 521 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 522 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 523 */ "limit_clause_opt ::=",
 /* 524 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 525 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 526 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 527 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 528 */ "subquery ::= NK_LP subquery NK_RP",
 /* 529 */ "search_condition ::= common_expression",
 /* 530 */ "sort_specification_list ::= sort_specification",
 /* 531 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 532 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 533 */ "ordering_specification_opt ::=",
 /* 534 */ "ordering_specification_opt ::= ASC",
 /* 535 */ "ordering_specification_opt ::= DESC",
 /* 536 */ "null_ordering_opt ::=",
 /* 537 */ "null_ordering_opt ::= NULLS FIRST",
 /* 538 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 324: /* cmd */
    case 327: /* literal */
    case 340: /* db_options */
    case 342: /* alter_db_options */
    case 348: /* retention */
    case 349: /* full_table_name */
    case 352: /* table_options */
    case 356: /* alter_table_clause */
    case 357: /* alter_table_options */
    case 360: /* signed_literal */
    case 361: /* create_subtable_clause */
    case 364: /* drop_table_clause */
    case 367: /* column_def */
    case 371: /* duration_literal */
    case 372: /* rollup_func_name */
    case 374: /* col_name */
    case 375: /* db_name_cond_opt */
    case 376: /* like_pattern_opt */
    case 377: /* table_name_cond */
    case 378: /* from_db_opt */
    case 380: /* tag_item */
    case 382: /* index_options */
    case 384: /* sliding_opt */
    case 385: /* sma_stream_opt */
    case 386: /* func */
    case 387: /* query_or_subquery */
    case 390: /* explain_options */
    case 394: /* stream_options */
    case 395: /* subtable_opt */
    case 396: /* expression */
    case 398: /* where_clause_opt */
    case 399: /* signed */
    case 400: /* literal_func */
    case 403: /* expr_or_subquery */
    case 404: /* pseudo_column */
    case 405: /* column_reference */
    case 406: /* function_expression */
    case 407: /* case_when_expression */
    case 412: /* star_func_para */
    case 414: /* case_when_else_opt */
    case 415: /* common_expression */
    case 416: /* when_then_expr */
    case 417: /* predicate */
    case 420: /* in_predicate_value */
    case 421: /* boolean_value_expression */
    case 422: /* boolean_primary */
    case 423: /* from_clause_opt */
    case 424: /* table_reference_list */
    case 425: /* table_reference */
    case 426: /* table_primary */
    case 427: /* joined_table */
    case 429: /* subquery */
    case 430: /* parenthesized_joined_table */
    case 432: /* search_condition */
    case 433: /* query_specification */
    case 437: /* range_opt */
    case 438: /* every_opt */
    case 439: /* fill_opt */
    case 440: /* twindow_clause_opt */
    case 442: /* having_clause_opt */
    case 443: /* select_item */
    case 445: /* partition_item */
    case 448: /* query_expression */
    case 449: /* query_simple */
    case 451: /* slimit_clause_opt */
    case 452: /* limit_clause_opt */
    case 453: /* union_query_expression */
    case 454: /* query_simple_or_subquery */
    case 456: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy74)); 
}
      break;
    case 325: /* account_options */
    case 326: /* alter_account_options */
    case 328: /* alter_account_option */
    case 343: /* speed_opt */
    case 392: /* bufsize_opt */
{
 
}
      break;
    case 329: /* user_name */
    case 332: /* priv_level */
    case 335: /* db_name */
    case 336: /* topic_name */
    case 337: /* dnode_endpoint */
    case 358: /* column_name */
    case 366: /* table_name */
    case 373: /* function_name */
    case 381: /* column_alias */
    case 388: /* cgroup_name */
    case 393: /* stream_name */
    case 402: /* table_alias */
    case 408: /* star_func */
    case 410: /* noarg_func */
    case 428: /* alias_opt */
{
 
}
      break;
    case 330: /* sysinfo_opt */
{
 
}
      break;
    case 331: /* privileges */
    case 333: /* priv_type_list */
    case 334: /* priv_type */
{
 
}
      break;
    case 338: /* force_opt */
    case 339: /* not_exists_opt */
    case 341: /* exists_opt */
    case 389: /* analyze_opt */
    case 391: /* agg_func_opt */
    case 434: /* set_quantifier_opt */
{
 
}
      break;
    case 344: /* integer_list */
    case 345: /* variable_list */
    case 346: /* retention_list */
    case 350: /* column_def_list */
    case 351: /* tags_def_opt */
    case 353: /* multi_create_clause */
    case 354: /* tags_def */
    case 355: /* multi_drop_clause */
    case 362: /* specific_cols_opt */
    case 363: /* expression_list */
    case 365: /* col_name_list */
    case 368: /* duration_list */
    case 369: /* rollup_func_list */
    case 379: /* tag_list_opt */
    case 383: /* func_list */
    case 397: /* dnode_list */
    case 401: /* literal_list */
    case 409: /* star_func_para_list */
    case 411: /* other_para_list */
    case 413: /* when_then_list */
    case 435: /* select_list */
    case 436: /* partition_by_clause_opt */
    case 441: /* group_by_clause_opt */
    case 444: /* partition_list */
    case 447: /* group_by_list */
    case 450: /* order_by_clause_opt */
    case 455: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy874)); 
}
      break;
    case 347: /* alter_db_option */
    case 370: /* alter_table_option */
{
 
}
      break;
    case 359: /* type_name */
{
 
}
      break;
    case 418: /* compare_op */
    case 419: /* in_op */
{
 
}
      break;
    case 431: /* join_type */
{
 
}
      break;
    case 446: /* fill_mode */
{
 
}
      break;
    case 457: /* ordering_specification_opt */
{
 
}
      break;
    case 458: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  324,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  324,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  325,    0 }, /* (2) account_options ::= */
  {  325,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  325,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  325,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  325,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  325,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  325,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  325,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  325,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  325,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  326,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  326,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  328,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  328,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  328,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  328,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  328,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  328,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  328,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  328,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  328,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  328,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  324,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  324,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  324,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  324,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  324,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  330,    0 }, /* (29) sysinfo_opt ::= */
  {  330,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  324,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  324,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  331,   -1 }, /* (33) privileges ::= ALL */
  {  331,   -1 }, /* (34) privileges ::= priv_type_list */
  {  331,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  333,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  333,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  334,   -1 }, /* (38) priv_type ::= READ */
  {  334,   -1 }, /* (39) priv_type ::= WRITE */
  {  332,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  332,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  332,   -1 }, /* (42) priv_level ::= topic_name */
  {  324,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  324,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  324,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  324,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  324,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  324,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  324,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  324,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  337,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  337,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  337,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  338,    0 }, /* (54) force_opt ::= */
  {  338,   -1 }, /* (55) force_opt ::= FORCE */
  {  324,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  324,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  324,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  324,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  324,   -2 }, /* (68) cmd ::= USE db_name */
  {  324,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  324,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  324,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  339,   -3 }, /* (72) not_exists_opt ::= IF NOT EXISTS */
  {  339,    0 }, /* (73) not_exists_opt ::= */
  {  341,   -2 }, /* (74) exists_opt ::= IF EXISTS */
  {  341,    0 }, /* (75) exists_opt ::= */
  {  340,    0 }, /* (76) db_options ::= */
  {  340,   -3 }, /* (77) db_options ::= db_options BUFFER NK_INTEGER */
  {  340,   -3 }, /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
  {  340,   -3 }, /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  340,   -3 }, /* (80) db_options ::= db_options COMP NK_INTEGER */
  {  340,   -3 }, /* (81) db_options ::= db_options DURATION NK_INTEGER */
  {  340,   -3 }, /* (82) db_options ::= db_options DURATION NK_VARIABLE */
  {  340,   -3 }, /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
  {  340,   -3 }, /* (84) db_options ::= db_options MINROWS NK_INTEGER */
  {  340,   -3 }, /* (85) db_options ::= db_options KEEP integer_list */
  {  340,   -3 }, /* (86) db_options ::= db_options KEEP variable_list */
  {  340,   -3 }, /* (87) db_options ::= db_options PAGES NK_INTEGER */
  {  340,   -3 }, /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  340,   -3 }, /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  340,   -3 }, /* (90) db_options ::= db_options PRECISION NK_STRING */
  {  340,   -3 }, /* (91) db_options ::= db_options REPLICA NK_INTEGER */
  {  340,   -3 }, /* (92) db_options ::= db_options VGROUPS NK_INTEGER */
  {  340,   -3 }, /* (93) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  340,   -3 }, /* (94) db_options ::= db_options RETENTIONS retention_list */
  {  340,   -3 }, /* (95) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  340,   -3 }, /* (96) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  340,   -3 }, /* (97) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  340,   -3 }, /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  340,   -4 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  340,   -3 }, /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  340,   -4 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  340,   -3 }, /* (102) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  340,   -3 }, /* (103) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  340,   -3 }, /* (104) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  340,   -3 }, /* (105) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  340,   -3 }, /* (106) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  342,   -1 }, /* (107) alter_db_options ::= alter_db_option */
  {  342,   -2 }, /* (108) alter_db_options ::= alter_db_options alter_db_option */
  {  347,   -2 }, /* (109) alter_db_option ::= BUFFER NK_INTEGER */
  {  347,   -2 }, /* (110) alter_db_option ::= CACHEMODEL NK_STRING */
  {  347,   -2 }, /* (111) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  347,   -2 }, /* (112) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  347,   -2 }, /* (113) alter_db_option ::= KEEP integer_list */
  {  347,   -2 }, /* (114) alter_db_option ::= KEEP variable_list */
  {  347,   -2 }, /* (115) alter_db_option ::= PAGES NK_INTEGER */
  {  347,   -2 }, /* (116) alter_db_option ::= REPLICA NK_INTEGER */
  {  347,   -2 }, /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  347,   -2 }, /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  344,   -1 }, /* (119) integer_list ::= NK_INTEGER */
  {  344,   -3 }, /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  345,   -1 }, /* (121) variable_list ::= NK_VARIABLE */
  {  345,   -3 }, /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  346,   -1 }, /* (123) retention_list ::= retention */
  {  346,   -3 }, /* (124) retention_list ::= retention_list NK_COMMA retention */
  {  348,   -3 }, /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  343,    0 }, /* (126) speed_opt ::= */
  {  343,   -2 }, /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  324,   -9 }, /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  324,   -3 }, /* (129) cmd ::= CREATE TABLE multi_create_clause */
  {  324,   -9 }, /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  324,   -3 }, /* (131) cmd ::= DROP TABLE multi_drop_clause */
  {  324,   -4 }, /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
  {  324,   -3 }, /* (133) cmd ::= ALTER TABLE alter_table_clause */
  {  324,   -3 }, /* (134) cmd ::= ALTER STABLE alter_table_clause */
  {  356,   -2 }, /* (135) alter_table_clause ::= full_table_name alter_table_options */
  {  356,   -5 }, /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  356,   -4 }, /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  356,   -5 }, /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  356,   -5 }, /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  356,   -5 }, /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  356,   -4 }, /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  356,   -5 }, /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  356,   -5 }, /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  356,   -6 }, /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  353,   -1 }, /* (145) multi_create_clause ::= create_subtable_clause */
  {  353,   -2 }, /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  361,  -10 }, /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  355,   -1 }, /* (148) multi_drop_clause ::= drop_table_clause */
  {  355,   -2 }, /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  364,   -2 }, /* (150) drop_table_clause ::= exists_opt full_table_name */
  {  362,    0 }, /* (151) specific_cols_opt ::= */
  {  362,   -3 }, /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  349,   -1 }, /* (153) full_table_name ::= table_name */
  {  349,   -3 }, /* (154) full_table_name ::= db_name NK_DOT table_name */
  {  350,   -1 }, /* (155) column_def_list ::= column_def */
  {  350,   -3 }, /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
  {  367,   -2 }, /* (157) column_def ::= column_name type_name */
  {  367,   -4 }, /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
  {  359,   -1 }, /* (159) type_name ::= BOOL */
  {  359,   -1 }, /* (160) type_name ::= TINYINT */
  {  359,   -1 }, /* (161) type_name ::= SMALLINT */
  {  359,   -1 }, /* (162) type_name ::= INT */
  {  359,   -1 }, /* (163) type_name ::= INTEGER */
  {  359,   -1 }, /* (164) type_name ::= BIGINT */
  {  359,   -1 }, /* (165) type_name ::= FLOAT */
  {  359,   -1 }, /* (166) type_name ::= DOUBLE */
  {  359,   -4 }, /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  359,   -1 }, /* (168) type_name ::= TIMESTAMP */
  {  359,   -4 }, /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  359,   -2 }, /* (170) type_name ::= TINYINT UNSIGNED */
  {  359,   -2 }, /* (171) type_name ::= SMALLINT UNSIGNED */
  {  359,   -2 }, /* (172) type_name ::= INT UNSIGNED */
  {  359,   -2 }, /* (173) type_name ::= BIGINT UNSIGNED */
  {  359,   -1 }, /* (174) type_name ::= JSON */
  {  359,   -4 }, /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  359,   -1 }, /* (176) type_name ::= MEDIUMBLOB */
  {  359,   -1 }, /* (177) type_name ::= BLOB */
  {  359,   -4 }, /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  359,   -1 }, /* (179) type_name ::= DECIMAL */
  {  359,   -4 }, /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  359,   -6 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  351,    0 }, /* (182) tags_def_opt ::= */
  {  351,   -1 }, /* (183) tags_def_opt ::= tags_def */
  {  354,   -4 }, /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  352,    0 }, /* (185) table_options ::= */
  {  352,   -3 }, /* (186) table_options ::= table_options COMMENT NK_STRING */
  {  352,   -3 }, /* (187) table_options ::= table_options MAX_DELAY duration_list */
  {  352,   -3 }, /* (188) table_options ::= table_options WATERMARK duration_list */
  {  352,   -5 }, /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  352,   -3 }, /* (190) table_options ::= table_options TTL NK_INTEGER */
  {  352,   -5 }, /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  352,   -3 }, /* (192) table_options ::= table_options DELETE_MARK duration_list */
  {  357,   -1 }, /* (193) alter_table_options ::= alter_table_option */
  {  357,   -2 }, /* (194) alter_table_options ::= alter_table_options alter_table_option */
  {  370,   -2 }, /* (195) alter_table_option ::= COMMENT NK_STRING */
  {  370,   -2 }, /* (196) alter_table_option ::= TTL NK_INTEGER */
  {  368,   -1 }, /* (197) duration_list ::= duration_literal */
  {  368,   -3 }, /* (198) duration_list ::= duration_list NK_COMMA duration_literal */
  {  369,   -1 }, /* (199) rollup_func_list ::= rollup_func_name */
  {  369,   -3 }, /* (200) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  372,   -1 }, /* (201) rollup_func_name ::= function_name */
  {  372,   -1 }, /* (202) rollup_func_name ::= FIRST */
  {  372,   -1 }, /* (203) rollup_func_name ::= LAST */
  {  365,   -1 }, /* (204) col_name_list ::= col_name */
  {  365,   -3 }, /* (205) col_name_list ::= col_name_list NK_COMMA col_name */
  {  374,   -1 }, /* (206) col_name ::= column_name */
  {  324,   -2 }, /* (207) cmd ::= SHOW DNODES */
  {  324,   -2 }, /* (208) cmd ::= SHOW USERS */
  {  324,   -3 }, /* (209) cmd ::= SHOW USER PRIVILEGES */
  {  324,   -2 }, /* (210) cmd ::= SHOW DATABASES */
  {  324,   -4 }, /* (211) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  324,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  324,   -3 }, /* (213) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  324,   -2 }, /* (214) cmd ::= SHOW MNODES */
  {  324,   -2 }, /* (215) cmd ::= SHOW QNODES */
  {  324,   -2 }, /* (216) cmd ::= SHOW FUNCTIONS */
  {  324,   -5 }, /* (217) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  324,   -2 }, /* (218) cmd ::= SHOW STREAMS */
  {  324,   -2 }, /* (219) cmd ::= SHOW ACCOUNTS */
  {  324,   -2 }, /* (220) cmd ::= SHOW APPS */
  {  324,   -2 }, /* (221) cmd ::= SHOW CONNECTIONS */
  {  324,   -2 }, /* (222) cmd ::= SHOW LICENCES */
  {  324,   -2 }, /* (223) cmd ::= SHOW GRANTS */
  {  324,   -4 }, /* (224) cmd ::= SHOW CREATE DATABASE db_name */
  {  324,   -4 }, /* (225) cmd ::= SHOW CREATE TABLE full_table_name */
  {  324,   -4 }, /* (226) cmd ::= SHOW CREATE STABLE full_table_name */
  {  324,   -2 }, /* (227) cmd ::= SHOW QUERIES */
  {  324,   -2 }, /* (228) cmd ::= SHOW SCORES */
  {  324,   -2 }, /* (229) cmd ::= SHOW TOPICS */
  {  324,   -2 }, /* (230) cmd ::= SHOW VARIABLES */
  {  324,   -3 }, /* (231) cmd ::= SHOW CLUSTER VARIABLES */
  {  324,   -3 }, /* (232) cmd ::= SHOW LOCAL VARIABLES */
  {  324,   -5 }, /* (233) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  324,   -2 }, /* (234) cmd ::= SHOW BNODES */
  {  324,   -2 }, /* (235) cmd ::= SHOW SNODES */
  {  324,   -2 }, /* (236) cmd ::= SHOW CLUSTER */
  {  324,   -2 }, /* (237) cmd ::= SHOW TRANSACTIONS */
  {  324,   -4 }, /* (238) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  324,   -2 }, /* (239) cmd ::= SHOW CONSUMERS */
  {  324,   -2 }, /* (240) cmd ::= SHOW SUBSCRIPTIONS */
  {  324,   -5 }, /* (241) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  324,   -7 }, /* (242) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  324,   -3 }, /* (243) cmd ::= SHOW VNODES NK_INTEGER */
  {  324,   -3 }, /* (244) cmd ::= SHOW VNODES NK_STRING */
  {  375,    0 }, /* (245) db_name_cond_opt ::= */
  {  375,   -2 }, /* (246) db_name_cond_opt ::= db_name NK_DOT */
  {  376,    0 }, /* (247) like_pattern_opt ::= */
  {  376,   -2 }, /* (248) like_pattern_opt ::= LIKE NK_STRING */
  {  377,   -1 }, /* (249) table_name_cond ::= table_name */
  {  378,    0 }, /* (250) from_db_opt ::= */
  {  378,   -2 }, /* (251) from_db_opt ::= FROM db_name */
  {  379,    0 }, /* (252) tag_list_opt ::= */
  {  379,   -1 }, /* (253) tag_list_opt ::= tag_item */
  {  379,   -3 }, /* (254) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  380,   -1 }, /* (255) tag_item ::= TBNAME */
  {  380,   -1 }, /* (256) tag_item ::= QTAGS */
  {  380,   -1 }, /* (257) tag_item ::= column_name */
  {  380,   -2 }, /* (258) tag_item ::= column_name column_alias */
  {  380,   -3 }, /* (259) tag_item ::= column_name AS column_alias */
  {  324,   -8 }, /* (260) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  324,   -4 }, /* (261) cmd ::= DROP INDEX exists_opt full_table_name */
  {  382,  -10 }, /* (262) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  382,  -12 }, /* (263) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  383,   -1 }, /* (264) func_list ::= func */
  {  383,   -3 }, /* (265) func_list ::= func_list NK_COMMA func */
  {  386,   -4 }, /* (266) func ::= function_name NK_LP expression_list NK_RP */
  {  385,    0 }, /* (267) sma_stream_opt ::= */
  {  385,   -3 }, /* (268) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  385,   -3 }, /* (269) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  385,   -3 }, /* (270) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  324,   -6 }, /* (271) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  324,   -7 }, /* (272) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  324,   -9 }, /* (273) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  324,   -7 }, /* (274) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  324,   -9 }, /* (275) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  324,   -4 }, /* (276) cmd ::= DROP TOPIC exists_opt topic_name */
  {  324,   -7 }, /* (277) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  324,   -2 }, /* (278) cmd ::= DESC full_table_name */
  {  324,   -2 }, /* (279) cmd ::= DESCRIBE full_table_name */
  {  324,   -3 }, /* (280) cmd ::= RESET QUERY CACHE */
  {  324,   -4 }, /* (281) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  389,    0 }, /* (282) analyze_opt ::= */
  {  389,   -1 }, /* (283) analyze_opt ::= ANALYZE */
  {  390,    0 }, /* (284) explain_options ::= */
  {  390,   -3 }, /* (285) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  390,   -3 }, /* (286) explain_options ::= explain_options RATIO NK_FLOAT */
  {  324,  -10 }, /* (287) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  324,   -4 }, /* (288) cmd ::= DROP FUNCTION exists_opt function_name */
  {  391,    0 }, /* (289) agg_func_opt ::= */
  {  391,   -1 }, /* (290) agg_func_opt ::= AGGREGATE */
  {  392,    0 }, /* (291) bufsize_opt ::= */
  {  392,   -2 }, /* (292) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  324,  -11 }, /* (293) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  324,   -4 }, /* (294) cmd ::= DROP STREAM exists_opt stream_name */
  {  394,    0 }, /* (295) stream_options ::= */
  {  394,   -3 }, /* (296) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  394,   -3 }, /* (297) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  394,   -4 }, /* (298) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  394,   -3 }, /* (299) stream_options ::= stream_options WATERMARK duration_literal */
  {  394,   -4 }, /* (300) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  394,   -3 }, /* (301) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  395,    0 }, /* (302) subtable_opt ::= */
  {  395,   -4 }, /* (303) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  324,   -3 }, /* (304) cmd ::= KILL CONNECTION NK_INTEGER */
  {  324,   -3 }, /* (305) cmd ::= KILL QUERY NK_STRING */
  {  324,   -3 }, /* (306) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  324,   -2 }, /* (307) cmd ::= BALANCE VGROUP */
  {  324,   -4 }, /* (308) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  324,   -4 }, /* (309) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  324,   -3 }, /* (310) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  397,   -2 }, /* (311) dnode_list ::= DNODE NK_INTEGER */
  {  397,   -3 }, /* (312) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  324,   -4 }, /* (313) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  324,   -1 }, /* (314) cmd ::= query_or_subquery */
  {  324,   -7 }, /* (315) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  324,   -4 }, /* (316) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  327,   -1 }, /* (317) literal ::= NK_INTEGER */
  {  327,   -1 }, /* (318) literal ::= NK_FLOAT */
  {  327,   -1 }, /* (319) literal ::= NK_STRING */
  {  327,   -1 }, /* (320) literal ::= NK_BOOL */
  {  327,   -2 }, /* (321) literal ::= TIMESTAMP NK_STRING */
  {  327,   -1 }, /* (322) literal ::= duration_literal */
  {  327,   -1 }, /* (323) literal ::= NULL */
  {  327,   -1 }, /* (324) literal ::= NK_QUESTION */
  {  371,   -1 }, /* (325) duration_literal ::= NK_VARIABLE */
  {  399,   -1 }, /* (326) signed ::= NK_INTEGER */
  {  399,   -2 }, /* (327) signed ::= NK_PLUS NK_INTEGER */
  {  399,   -2 }, /* (328) signed ::= NK_MINUS NK_INTEGER */
  {  399,   -1 }, /* (329) signed ::= NK_FLOAT */
  {  399,   -2 }, /* (330) signed ::= NK_PLUS NK_FLOAT */
  {  399,   -2 }, /* (331) signed ::= NK_MINUS NK_FLOAT */
  {  360,   -1 }, /* (332) signed_literal ::= signed */
  {  360,   -1 }, /* (333) signed_literal ::= NK_STRING */
  {  360,   -1 }, /* (334) signed_literal ::= NK_BOOL */
  {  360,   -2 }, /* (335) signed_literal ::= TIMESTAMP NK_STRING */
  {  360,   -1 }, /* (336) signed_literal ::= duration_literal */
  {  360,   -1 }, /* (337) signed_literal ::= NULL */
  {  360,   -1 }, /* (338) signed_literal ::= literal_func */
  {  360,   -1 }, /* (339) signed_literal ::= NK_QUESTION */
  {  401,   -1 }, /* (340) literal_list ::= signed_literal */
  {  401,   -3 }, /* (341) literal_list ::= literal_list NK_COMMA signed_literal */
  {  335,   -1 }, /* (342) db_name ::= NK_ID */
  {  366,   -1 }, /* (343) table_name ::= NK_ID */
  {  358,   -1 }, /* (344) column_name ::= NK_ID */
  {  373,   -1 }, /* (345) function_name ::= NK_ID */
  {  402,   -1 }, /* (346) table_alias ::= NK_ID */
  {  381,   -1 }, /* (347) column_alias ::= NK_ID */
  {  329,   -1 }, /* (348) user_name ::= NK_ID */
  {  336,   -1 }, /* (349) topic_name ::= NK_ID */
  {  393,   -1 }, /* (350) stream_name ::= NK_ID */
  {  388,   -1 }, /* (351) cgroup_name ::= NK_ID */
  {  403,   -1 }, /* (352) expr_or_subquery ::= expression */
  {  396,   -1 }, /* (353) expression ::= literal */
  {  396,   -1 }, /* (354) expression ::= pseudo_column */
  {  396,   -1 }, /* (355) expression ::= column_reference */
  {  396,   -1 }, /* (356) expression ::= function_expression */
  {  396,   -1 }, /* (357) expression ::= case_when_expression */
  {  396,   -3 }, /* (358) expression ::= NK_LP expression NK_RP */
  {  396,   -2 }, /* (359) expression ::= NK_PLUS expr_or_subquery */
  {  396,   -2 }, /* (360) expression ::= NK_MINUS expr_or_subquery */
  {  396,   -3 }, /* (361) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  396,   -3 }, /* (362) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  396,   -3 }, /* (363) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  396,   -3 }, /* (364) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  396,   -3 }, /* (365) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  396,   -3 }, /* (366) expression ::= column_reference NK_ARROW NK_STRING */
  {  396,   -3 }, /* (367) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  396,   -3 }, /* (368) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  363,   -1 }, /* (369) expression_list ::= expr_or_subquery */
  {  363,   -3 }, /* (370) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  405,   -1 }, /* (371) column_reference ::= column_name */
  {  405,   -3 }, /* (372) column_reference ::= table_name NK_DOT column_name */
  {  404,   -1 }, /* (373) pseudo_column ::= ROWTS */
  {  404,   -1 }, /* (374) pseudo_column ::= TBNAME */
  {  404,   -3 }, /* (375) pseudo_column ::= table_name NK_DOT TBNAME */
  {  404,   -1 }, /* (376) pseudo_column ::= QSTART */
  {  404,   -1 }, /* (377) pseudo_column ::= QEND */
  {  404,   -1 }, /* (378) pseudo_column ::= QDURATION */
  {  404,   -1 }, /* (379) pseudo_column ::= WSTART */
  {  404,   -1 }, /* (380) pseudo_column ::= WEND */
  {  404,   -1 }, /* (381) pseudo_column ::= WDURATION */
  {  404,   -1 }, /* (382) pseudo_column ::= IROWTS */
  {  404,   -1 }, /* (383) pseudo_column ::= QTAGS */
  {  406,   -4 }, /* (384) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  406,   -4 }, /* (385) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  406,   -6 }, /* (386) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  406,   -1 }, /* (387) function_expression ::= literal_func */
  {  400,   -3 }, /* (388) literal_func ::= noarg_func NK_LP NK_RP */
  {  400,   -1 }, /* (389) literal_func ::= NOW */
  {  410,   -1 }, /* (390) noarg_func ::= NOW */
  {  410,   -1 }, /* (391) noarg_func ::= TODAY */
  {  410,   -1 }, /* (392) noarg_func ::= TIMEZONE */
  {  410,   -1 }, /* (393) noarg_func ::= DATABASE */
  {  410,   -1 }, /* (394) noarg_func ::= CLIENT_VERSION */
  {  410,   -1 }, /* (395) noarg_func ::= SERVER_VERSION */
  {  410,   -1 }, /* (396) noarg_func ::= SERVER_STATUS */
  {  410,   -1 }, /* (397) noarg_func ::= CURRENT_USER */
  {  410,   -1 }, /* (398) noarg_func ::= USER */
  {  408,   -1 }, /* (399) star_func ::= COUNT */
  {  408,   -1 }, /* (400) star_func ::= FIRST */
  {  408,   -1 }, /* (401) star_func ::= LAST */
  {  408,   -1 }, /* (402) star_func ::= LAST_ROW */
  {  409,   -1 }, /* (403) star_func_para_list ::= NK_STAR */
  {  409,   -1 }, /* (404) star_func_para_list ::= other_para_list */
  {  411,   -1 }, /* (405) other_para_list ::= star_func_para */
  {  411,   -3 }, /* (406) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  412,   -1 }, /* (407) star_func_para ::= expr_or_subquery */
  {  412,   -3 }, /* (408) star_func_para ::= table_name NK_DOT NK_STAR */
  {  407,   -4 }, /* (409) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  407,   -5 }, /* (410) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  413,   -1 }, /* (411) when_then_list ::= when_then_expr */
  {  413,   -2 }, /* (412) when_then_list ::= when_then_list when_then_expr */
  {  416,   -4 }, /* (413) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  414,    0 }, /* (414) case_when_else_opt ::= */
  {  414,   -2 }, /* (415) case_when_else_opt ::= ELSE common_expression */
  {  417,   -3 }, /* (416) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  417,   -5 }, /* (417) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  417,   -6 }, /* (418) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  417,   -3 }, /* (419) predicate ::= expr_or_subquery IS NULL */
  {  417,   -4 }, /* (420) predicate ::= expr_or_subquery IS NOT NULL */
  {  417,   -3 }, /* (421) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  418,   -1 }, /* (422) compare_op ::= NK_LT */
  {  418,   -1 }, /* (423) compare_op ::= NK_GT */
  {  418,   -1 }, /* (424) compare_op ::= NK_LE */
  {  418,   -1 }, /* (425) compare_op ::= NK_GE */
  {  418,   -1 }, /* (426) compare_op ::= NK_NE */
  {  418,   -1 }, /* (427) compare_op ::= NK_EQ */
  {  418,   -1 }, /* (428) compare_op ::= LIKE */
  {  418,   -2 }, /* (429) compare_op ::= NOT LIKE */
  {  418,   -1 }, /* (430) compare_op ::= MATCH */
  {  418,   -1 }, /* (431) compare_op ::= NMATCH */
  {  418,   -1 }, /* (432) compare_op ::= CONTAINS */
  {  419,   -1 }, /* (433) in_op ::= IN */
  {  419,   -2 }, /* (434) in_op ::= NOT IN */
  {  420,   -3 }, /* (435) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  421,   -1 }, /* (436) boolean_value_expression ::= boolean_primary */
  {  421,   -2 }, /* (437) boolean_value_expression ::= NOT boolean_primary */
  {  421,   -3 }, /* (438) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  421,   -3 }, /* (439) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  422,   -1 }, /* (440) boolean_primary ::= predicate */
  {  422,   -3 }, /* (441) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  415,   -1 }, /* (442) common_expression ::= expr_or_subquery */
  {  415,   -1 }, /* (443) common_expression ::= boolean_value_expression */
  {  423,    0 }, /* (444) from_clause_opt ::= */
  {  423,   -2 }, /* (445) from_clause_opt ::= FROM table_reference_list */
  {  424,   -1 }, /* (446) table_reference_list ::= table_reference */
  {  424,   -3 }, /* (447) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  425,   -1 }, /* (448) table_reference ::= table_primary */
  {  425,   -1 }, /* (449) table_reference ::= joined_table */
  {  426,   -2 }, /* (450) table_primary ::= table_name alias_opt */
  {  426,   -4 }, /* (451) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  426,   -2 }, /* (452) table_primary ::= subquery alias_opt */
  {  426,   -1 }, /* (453) table_primary ::= parenthesized_joined_table */
  {  428,    0 }, /* (454) alias_opt ::= */
  {  428,   -1 }, /* (455) alias_opt ::= table_alias */
  {  428,   -2 }, /* (456) alias_opt ::= AS table_alias */
  {  430,   -3 }, /* (457) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  430,   -3 }, /* (458) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  427,   -6 }, /* (459) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  431,    0 }, /* (460) join_type ::= */
  {  431,   -1 }, /* (461) join_type ::= INNER */
  {  433,  -12 }, /* (462) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  434,    0 }, /* (463) set_quantifier_opt ::= */
  {  434,   -1 }, /* (464) set_quantifier_opt ::= DISTINCT */
  {  434,   -1 }, /* (465) set_quantifier_opt ::= ALL */
  {  435,   -1 }, /* (466) select_list ::= select_item */
  {  435,   -3 }, /* (467) select_list ::= select_list NK_COMMA select_item */
  {  443,   -1 }, /* (468) select_item ::= NK_STAR */
  {  443,   -1 }, /* (469) select_item ::= common_expression */
  {  443,   -2 }, /* (470) select_item ::= common_expression column_alias */
  {  443,   -3 }, /* (471) select_item ::= common_expression AS column_alias */
  {  443,   -3 }, /* (472) select_item ::= table_name NK_DOT NK_STAR */
  {  398,    0 }, /* (473) where_clause_opt ::= */
  {  398,   -2 }, /* (474) where_clause_opt ::= WHERE search_condition */
  {  436,    0 }, /* (475) partition_by_clause_opt ::= */
  {  436,   -3 }, /* (476) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  444,   -1 }, /* (477) partition_list ::= partition_item */
  {  444,   -3 }, /* (478) partition_list ::= partition_list NK_COMMA partition_item */
  {  445,   -1 }, /* (479) partition_item ::= expr_or_subquery */
  {  445,   -2 }, /* (480) partition_item ::= expr_or_subquery column_alias */
  {  445,   -3 }, /* (481) partition_item ::= expr_or_subquery AS column_alias */
  {  440,    0 }, /* (482) twindow_clause_opt ::= */
  {  440,   -6 }, /* (483) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  440,   -4 }, /* (484) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  440,   -6 }, /* (485) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  440,   -8 }, /* (486) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  440,   -7 }, /* (487) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  384,    0 }, /* (488) sliding_opt ::= */
  {  384,   -4 }, /* (489) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  439,    0 }, /* (490) fill_opt ::= */
  {  439,   -4 }, /* (491) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  439,   -6 }, /* (492) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  446,   -1 }, /* (493) fill_mode ::= NONE */
  {  446,   -1 }, /* (494) fill_mode ::= PREV */
  {  446,   -1 }, /* (495) fill_mode ::= NULL */
  {  446,   -1 }, /* (496) fill_mode ::= LINEAR */
  {  446,   -1 }, /* (497) fill_mode ::= NEXT */
  {  441,    0 }, /* (498) group_by_clause_opt ::= */
  {  441,   -3 }, /* (499) group_by_clause_opt ::= GROUP BY group_by_list */
  {  447,   -1 }, /* (500) group_by_list ::= expr_or_subquery */
  {  447,   -3 }, /* (501) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  442,    0 }, /* (502) having_clause_opt ::= */
  {  442,   -2 }, /* (503) having_clause_opt ::= HAVING search_condition */
  {  437,    0 }, /* (504) range_opt ::= */
  {  437,   -6 }, /* (505) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  438,    0 }, /* (506) every_opt ::= */
  {  438,   -4 }, /* (507) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  448,   -4 }, /* (508) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  449,   -1 }, /* (509) query_simple ::= query_specification */
  {  449,   -1 }, /* (510) query_simple ::= union_query_expression */
  {  453,   -4 }, /* (511) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  453,   -3 }, /* (512) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  454,   -1 }, /* (513) query_simple_or_subquery ::= query_simple */
  {  454,   -1 }, /* (514) query_simple_or_subquery ::= subquery */
  {  387,   -1 }, /* (515) query_or_subquery ::= query_expression */
  {  387,   -1 }, /* (516) query_or_subquery ::= subquery */
  {  450,    0 }, /* (517) order_by_clause_opt ::= */
  {  450,   -3 }, /* (518) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  451,    0 }, /* (519) slimit_clause_opt ::= */
  {  451,   -2 }, /* (520) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  451,   -4 }, /* (521) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  451,   -4 }, /* (522) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  452,    0 }, /* (523) limit_clause_opt ::= */
  {  452,   -2 }, /* (524) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  452,   -4 }, /* (525) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  452,   -4 }, /* (526) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  429,   -3 }, /* (527) subquery ::= NK_LP query_expression NK_RP */
  {  429,   -3 }, /* (528) subquery ::= NK_LP subquery NK_RP */
  {  432,   -1 }, /* (529) search_condition ::= common_expression */
  {  455,   -1 }, /* (530) sort_specification_list ::= sort_specification */
  {  455,   -3 }, /* (531) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  456,   -3 }, /* (532) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  457,    0 }, /* (533) ordering_specification_opt ::= */
  {  457,   -1 }, /* (534) ordering_specification_opt ::= ASC */
  {  457,   -1 }, /* (535) ordering_specification_opt ::= DESC */
  {  458,    0 }, /* (536) null_ordering_opt ::= */
  {  458,   -2 }, /* (537) null_ordering_opt ::= NULLS FIRST */
  {  458,   -2 }, /* (538) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,325,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,326,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,325,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,327,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,328,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,326,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,328,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,327,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy317, &yymsp[-1].minor.yy0, yymsp[0].minor.yy449); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy317, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy317, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy317, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy317); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy449 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy449 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy531, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy317); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy531, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy317); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy531 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy531 = yymsp[0].minor.yy531; }
  yymsp[0].minor.yy531 = yylhsminor.yy531;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy531 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy531 = yymsp[-2].minor.yy531 | yymsp[0].minor.yy531; }
  yymsp[-2].minor.yy531 = yylhsminor.yy531;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy531 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy531 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy317 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy317 = yylhsminor.yy317;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy317 = yymsp[-2].minor.yy317; }
  yymsp[-2].minor.yy317 = yylhsminor.yy317;
        break;
      case 42: /* priv_level ::= topic_name */
      case 455: /* alias_opt ::= table_alias */ yytestcase(yyruleno==455);
{ yylhsminor.yy317 = yymsp[0].minor.yy317; }
  yymsp[0].minor.yy317 = yylhsminor.yy317;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy317, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy335); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy317, yymsp[0].minor.yy335); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 342: /* db_name ::= NK_ID */ yytestcase(yyruleno==342);
      case 343: /* table_name ::= NK_ID */ yytestcase(yyruleno==343);
      case 344: /* column_name ::= NK_ID */ yytestcase(yyruleno==344);
      case 345: /* function_name ::= NK_ID */ yytestcase(yyruleno==345);
      case 346: /* table_alias ::= NK_ID */ yytestcase(yyruleno==346);
      case 347: /* column_alias ::= NK_ID */ yytestcase(yyruleno==347);
      case 348: /* user_name ::= NK_ID */ yytestcase(yyruleno==348);
      case 349: /* topic_name ::= NK_ID */ yytestcase(yyruleno==349);
      case 350: /* stream_name ::= NK_ID */ yytestcase(yyruleno==350);
      case 351: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==351);
      case 390: /* noarg_func ::= NOW */ yytestcase(yyruleno==390);
      case 391: /* noarg_func ::= TODAY */ yytestcase(yyruleno==391);
      case 392: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==392);
      case 393: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==393);
      case 394: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==394);
      case 395: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==395);
      case 396: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==396);
      case 397: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==397);
      case 398: /* noarg_func ::= USER */ yytestcase(yyruleno==398);
      case 399: /* star_func ::= COUNT */ yytestcase(yyruleno==399);
      case 400: /* star_func ::= FIRST */ yytestcase(yyruleno==400);
      case 401: /* star_func ::= LAST */ yytestcase(yyruleno==401);
      case 402: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==402);
{ yylhsminor.yy317 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy317 = yylhsminor.yy317;
        break;
      case 54: /* force_opt ::= */
      case 73: /* not_exists_opt ::= */ yytestcase(yyruleno==73);
      case 75: /* exists_opt ::= */ yytestcase(yyruleno==75);
      case 282: /* analyze_opt ::= */ yytestcase(yyruleno==282);
      case 289: /* agg_func_opt ::= */ yytestcase(yyruleno==289);
      case 463: /* set_quantifier_opt ::= */ yytestcase(yyruleno==463);
{ yymsp[1].minor.yy335 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 283: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==283);
      case 290: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==290);
      case 464: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==464);
{ yymsp[0].minor.yy335 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy335, &yymsp[-1].minor.yy317, yymsp[0].minor.yy74); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy335, &yymsp[0].minor.yy317); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy317); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy317, yymsp[0].minor.yy74); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy317); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy317, yymsp[0].minor.yy856); }
        break;
      case 72: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy335 = true; }
        break;
      case 74: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy335 = true; }
        break;
      case 76: /* db_options ::= */
{ yymsp[1].minor.yy74 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 77: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 78: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 79: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 80: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 81: /* db_options ::= db_options DURATION NK_INTEGER */
      case 82: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==82);
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 83: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 84: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 85: /* db_options ::= db_options KEEP integer_list */
      case 86: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==86);
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_KEEP, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 87: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 88: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 89: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 90: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 91: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 92: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 93: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 94: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_RETENTIONS, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 95: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 96: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 97: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-3].minor.yy74, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-3].minor.yy74, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 102: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 103: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 104: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 105: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 106: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 107: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy74 = createAlterDatabaseOptions(pCxt); yylhsminor.yy74 = setAlterDatabaseOption(pCxt, yylhsminor.yy74, &yymsp[0].minor.yy767); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 108: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy74 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy74, &yymsp[0].minor.yy767); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 109: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy767.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= KEEP integer_list */
      case 114: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==114);
{ yymsp[-1].minor.yy767.type = DB_OPTION_KEEP; yymsp[-1].minor.yy767.pList = yymsp[0].minor.yy874; }
        break;
      case 115: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_PAGES; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_WAL; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy874 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 120: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 312: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==312);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 121: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy874 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 122: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 123: /* retention_list ::= retention */
      case 145: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==145);
      case 148: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==148);
      case 155: /* column_def_list ::= column_def */ yytestcase(yyruleno==155);
      case 199: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==199);
      case 204: /* col_name_list ::= col_name */ yytestcase(yyruleno==204);
      case 253: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==253);
      case 264: /* func_list ::= func */ yytestcase(yyruleno==264);
      case 340: /* literal_list ::= signed_literal */ yytestcase(yyruleno==340);
      case 405: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==405);
      case 411: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==411);
      case 466: /* select_list ::= select_item */ yytestcase(yyruleno==466);
      case 477: /* partition_list ::= partition_item */ yytestcase(yyruleno==477);
      case 530: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==530);
{ yylhsminor.yy874 = createNodeList(pCxt, yymsp[0].minor.yy74); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 124: /* retention_list ::= retention_list NK_COMMA retention */
      case 156: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==205);
      case 254: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==254);
      case 265: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==265);
      case 341: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==341);
      case 406: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==406);
      case 467: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==467);
      case 478: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==478);
      case 531: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==531);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, yymsp[0].minor.yy74); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 125: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy74 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 126: /* speed_opt ::= */
      case 291: /* bufsize_opt ::= */ yytestcase(yyruleno==291);
{ yymsp[1].minor.yy856 = 0; }
        break;
      case 127: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 292: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==292);
{ yymsp[-1].minor.yy856 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 128: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 130: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==130);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy335, yymsp[-5].minor.yy74, yymsp[-3].minor.yy874, yymsp[-1].minor.yy874, yymsp[0].minor.yy74); }
        break;
      case 129: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy874); }
        break;
      case 131: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy874); }
        break;
      case 132: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy335, yymsp[0].minor.yy74); }
        break;
      case 133: /* cmd ::= ALTER TABLE alter_table_clause */
      case 314: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==314);
{ pCxt->pRootNode = yymsp[0].minor.yy74; }
        break;
      case 134: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy74); }
        break;
      case 135: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy74 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy74 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy74, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy317, yymsp[0].minor.yy898); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy74 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy74, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy317); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy74 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy74, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy317, yymsp[0].minor.yy898); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy74 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy74, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy317, &yymsp[0].minor.yy317); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 140: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy74 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy74, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy317, yymsp[0].minor.yy898); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 141: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy74 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy74, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy317); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 142: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy74 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy74, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy317, yymsp[0].minor.yy898); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 143: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy74 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy74, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy317, &yymsp[0].minor.yy317); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 144: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy74 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy74, &yymsp[-2].minor.yy317, yymsp[0].minor.yy74); }
  yymsp[-5].minor.yy74 = yylhsminor.yy74;
        break;
      case 146: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 149: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==149);
      case 412: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==412);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-1].minor.yy874, yymsp[0].minor.yy74); }
  yymsp[-1].minor.yy874 = yylhsminor.yy874;
        break;
      case 147: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy74 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy335, yymsp[-8].minor.yy74, yymsp[-6].minor.yy74, yymsp[-5].minor.yy874, yymsp[-2].minor.yy874, yymsp[0].minor.yy74); }
  yymsp[-9].minor.yy74 = yylhsminor.yy74;
        break;
      case 150: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy74 = createDropTableClause(pCxt, yymsp[-1].minor.yy335, yymsp[0].minor.yy74); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 151: /* specific_cols_opt ::= */
      case 182: /* tags_def_opt ::= */ yytestcase(yyruleno==182);
      case 252: /* tag_list_opt ::= */ yytestcase(yyruleno==252);
      case 475: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==475);
      case 498: /* group_by_clause_opt ::= */ yytestcase(yyruleno==498);
      case 517: /* order_by_clause_opt ::= */ yytestcase(yyruleno==517);
{ yymsp[1].minor.yy874 = NULL; }
        break;
      case 152: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy874 = yymsp[-1].minor.yy874; }
        break;
      case 153: /* full_table_name ::= table_name */
{ yylhsminor.yy74 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy317, NULL); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 154: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy74 = createRealTableNode(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy317, NULL); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 157: /* column_def ::= column_name type_name */
{ yylhsminor.yy74 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy317, yymsp[0].minor.yy898, NULL); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 158: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy74 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy317, yymsp[-2].minor.yy898, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 159: /* type_name ::= BOOL */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 160: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 161: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 162: /* type_name ::= INT */
      case 163: /* type_name ::= INTEGER */ yytestcase(yyruleno==163);
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 164: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 165: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 166: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 167: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy898 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 169: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy898 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy898 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy898 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 172: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy898 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 173: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy898 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 174: /* type_name ::= JSON */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 175: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy898 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 176: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 177: /* type_name ::= BLOB */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 178: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy898 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 180: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy898 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy898 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* tags_def_opt ::= tags_def */
      case 404: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==404);
{ yylhsminor.yy874 = yymsp[0].minor.yy874; }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 184: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy874 = yymsp[-1].minor.yy874; }
        break;
      case 185: /* table_options ::= */
{ yymsp[1].minor.yy74 = createDefaultTableOptions(pCxt); }
        break;
      case 186: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-2].minor.yy74, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 187: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-2].minor.yy74, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 188: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-2].minor.yy74, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 189: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-4].minor.yy74, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy874); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 190: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-2].minor.yy74, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 191: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-4].minor.yy74, TABLE_OPTION_SMA, yymsp[-1].minor.yy874); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 192: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-2].minor.yy74, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 193: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy74 = createAlterTableOptions(pCxt); yylhsminor.yy74 = setTableOption(pCxt, yylhsminor.yy74, yymsp[0].minor.yy767.type, &yymsp[0].minor.yy767.val); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 194: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-1].minor.yy74, yymsp[0].minor.yy767.type, &yymsp[0].minor.yy767.val); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 195: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy767.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 196: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy767.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* duration_list ::= duration_literal */
      case 369: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==369);
{ yylhsminor.yy874 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy74)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 198: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 370: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==370);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, releaseRawExprNode(pCxt, yymsp[0].minor.yy74)); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 201: /* rollup_func_name ::= function_name */
{ yylhsminor.yy74 = createFunctionNode(pCxt, &yymsp[0].minor.yy317, NULL); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 202: /* rollup_func_name ::= FIRST */
      case 203: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==203);
      case 256: /* tag_item ::= QTAGS */ yytestcase(yyruleno==256);
{ yylhsminor.yy74 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 206: /* col_name ::= column_name */
      case 257: /* tag_item ::= column_name */ yytestcase(yyruleno==257);
{ yylhsminor.yy74 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy317); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 207: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 208: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 209: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 210: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 211: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy74, yymsp[0].minor.yy74, OP_TYPE_LIKE); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy74, yymsp[0].minor.yy74, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy74, NULL, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy74, yymsp[-1].minor.yy74, OP_TYPE_EQUAL); }
        break;
      case 218: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 219: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 220: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 221: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 222: /* cmd ::= SHOW LICENCES */
      case 223: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==223);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 224: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy317); }
        break;
      case 225: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy74); }
        break;
      case 226: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy74); }
        break;
      case 227: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 228: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 229: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 230: /* cmd ::= SHOW VARIABLES */
      case 231: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==231);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 232: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy74); }
        break;
      case 234: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 235: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 237: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 238: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy74); }
        break;
      case 239: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 240: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 241: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy74, yymsp[-1].minor.yy74, OP_TYPE_EQUAL); }
        break;
      case 242: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy74, yymsp[0].minor.yy74, yymsp[-3].minor.yy874); }
        break;
      case 243: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 245: /* db_name_cond_opt ::= */
      case 250: /* from_db_opt ::= */ yytestcase(yyruleno==250);
{ yymsp[1].minor.yy74 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 246: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy74 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy317); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 247: /* like_pattern_opt ::= */
      case 302: /* subtable_opt ::= */ yytestcase(yyruleno==302);
      case 414: /* case_when_else_opt ::= */ yytestcase(yyruleno==414);
      case 444: /* from_clause_opt ::= */ yytestcase(yyruleno==444);
      case 473: /* where_clause_opt ::= */ yytestcase(yyruleno==473);
      case 482: /* twindow_clause_opt ::= */ yytestcase(yyruleno==482);
      case 488: /* sliding_opt ::= */ yytestcase(yyruleno==488);
      case 490: /* fill_opt ::= */ yytestcase(yyruleno==490);
      case 502: /* having_clause_opt ::= */ yytestcase(yyruleno==502);
      case 504: /* range_opt ::= */ yytestcase(yyruleno==504);
      case 506: /* every_opt ::= */ yytestcase(yyruleno==506);
      case 519: /* slimit_clause_opt ::= */ yytestcase(yyruleno==519);
      case 523: /* limit_clause_opt ::= */ yytestcase(yyruleno==523);
{ yymsp[1].minor.yy74 = NULL; }
        break;
      case 248: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 249: /* table_name_cond ::= table_name */
{ yylhsminor.yy74 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy317); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 251: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy74 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy317); }
        break;
      case 255: /* tag_item ::= TBNAME */
{ yylhsminor.yy74 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 258: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy74 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy317), &yymsp[0].minor.yy317); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 259: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy74 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy317), &yymsp[0].minor.yy317); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 260: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy335, yymsp[-3].minor.yy74, yymsp[-1].minor.yy74, NULL, yymsp[0].minor.yy74); }
        break;
      case 261: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy335, yymsp[0].minor.yy74); }
        break;
      case 262: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy74 = createIndexOption(pCxt, yymsp[-7].minor.yy874, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), NULL, yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 263: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy74 = createIndexOption(pCxt, yymsp[-9].minor.yy874, releaseRawExprNode(pCxt, yymsp[-5].minor.yy74), releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 266: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy74 = createFunctionNode(pCxt, &yymsp[-3].minor.yy317, yymsp[-1].minor.yy874); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 267: /* sma_stream_opt ::= */
      case 295: /* stream_options ::= */ yytestcase(yyruleno==295);
{ yymsp[1].minor.yy74 = createStreamOptions(pCxt); }
        break;
      case 268: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 299: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==299);
{ ((SStreamOptions*)yymsp[-2].minor.yy74)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy74); yylhsminor.yy74 = yymsp[-2].minor.yy74; }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 269: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy74)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy74); yylhsminor.yy74 = yymsp[-2].minor.yy74; }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 270: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy74)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy74); yylhsminor.yy74 = yymsp[-2].minor.yy74; }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 271: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy335, &yymsp[-2].minor.yy317, yymsp[0].minor.yy74); }
        break;
      case 272: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy335, &yymsp[-3].minor.yy317, &yymsp[0].minor.yy317, false); }
        break;
      case 273: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy335, &yymsp[-5].minor.yy317, &yymsp[0].minor.yy317, true); }
        break;
      case 274: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy335, &yymsp[-3].minor.yy317, yymsp[0].minor.yy74, false); }
        break;
      case 275: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy335, &yymsp[-5].minor.yy317, yymsp[0].minor.yy74, true); }
        break;
      case 276: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy335, &yymsp[0].minor.yy317); }
        break;
      case 277: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy335, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy317); }
        break;
      case 278: /* cmd ::= DESC full_table_name */
      case 279: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==279);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy74); }
        break;
      case 280: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 281: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy335, yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 284: /* explain_options ::= */
{ yymsp[1].minor.yy74 = createDefaultExplainOptions(pCxt); }
        break;
      case 285: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy74 = setExplainVerbose(pCxt, yymsp[-2].minor.yy74, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 286: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy74 = setExplainRatio(pCxt, yymsp[-2].minor.yy74, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 287: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy335, yymsp[-8].minor.yy335, &yymsp[-5].minor.yy317, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy898, yymsp[0].minor.yy856); }
        break;
      case 288: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy335, &yymsp[0].minor.yy317); }
        break;
      case 293: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy335, &yymsp[-7].minor.yy317, yymsp[-4].minor.yy74, yymsp[-6].minor.yy74, yymsp[-3].minor.yy874, yymsp[-2].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 294: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy335, &yymsp[0].minor.yy317); }
        break;
      case 296: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy74)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy74 = yymsp[-2].minor.yy74; }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 297: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy74)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy74 = yymsp[-2].minor.yy74; }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 298: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy74)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy74)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy74); yylhsminor.yy74 = yymsp[-3].minor.yy74; }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 300: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy74)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy74 = yymsp[-3].minor.yy74; }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 301: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy74)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy74 = yymsp[-2].minor.yy74; }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 303: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 489: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==489);
      case 507: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==507);
{ yymsp[-3].minor.yy74 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy74); }
        break;
      case 304: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 305: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 306: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 307: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 308: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 309: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy874); }
        break;
      case 310: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 311: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy874 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 313: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 315: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy74, yymsp[-2].minor.yy874, yymsp[0].minor.yy74); }
        break;
      case 316: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy74, NULL, yymsp[0].minor.yy74); }
        break;
      case 317: /* literal ::= NK_INTEGER */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 318: /* literal ::= NK_FLOAT */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 319: /* literal ::= NK_STRING */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 320: /* literal ::= NK_BOOL */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 321: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 322: /* literal ::= duration_literal */
      case 332: /* signed_literal ::= signed */ yytestcase(yyruleno==332);
      case 352: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==352);
      case 353: /* expression ::= literal */ yytestcase(yyruleno==353);
      case 354: /* expression ::= pseudo_column */ yytestcase(yyruleno==354);
      case 355: /* expression ::= column_reference */ yytestcase(yyruleno==355);
      case 356: /* expression ::= function_expression */ yytestcase(yyruleno==356);
      case 357: /* expression ::= case_when_expression */ yytestcase(yyruleno==357);
      case 387: /* function_expression ::= literal_func */ yytestcase(yyruleno==387);
      case 436: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==436);
      case 440: /* boolean_primary ::= predicate */ yytestcase(yyruleno==440);
      case 442: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==442);
      case 443: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==443);
      case 446: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==446);
      case 448: /* table_reference ::= table_primary */ yytestcase(yyruleno==448);
      case 449: /* table_reference ::= joined_table */ yytestcase(yyruleno==449);
      case 453: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==453);
      case 509: /* query_simple ::= query_specification */ yytestcase(yyruleno==509);
      case 510: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==510);
      case 513: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==513);
      case 515: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==515);
{ yylhsminor.yy74 = yymsp[0].minor.yy74; }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 323: /* literal ::= NULL */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 324: /* literal ::= NK_QUESTION */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 325: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 326: /* signed ::= NK_INTEGER */
{ yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 327: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 328: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 329: /* signed ::= NK_FLOAT */
{ yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 330: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 331: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 333: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 334: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 335: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 336: /* signed_literal ::= duration_literal */
      case 338: /* signed_literal ::= literal_func */ yytestcase(yyruleno==338);
      case 407: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==407);
      case 469: /* select_item ::= common_expression */ yytestcase(yyruleno==469);
      case 479: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==479);
      case 514: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==514);
      case 516: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==516);
      case 529: /* search_condition ::= common_expression */ yytestcase(yyruleno==529);
{ yylhsminor.yy74 = releaseRawExprNode(pCxt, yymsp[0].minor.yy74); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 337: /* signed_literal ::= NULL */
{ yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 339: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy74 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 358: /* expression ::= NK_LP expression NK_RP */
      case 441: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==441);
      case 528: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==528);
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy74)); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 359: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy74));
                                                                                  }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 360: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy74), NULL));
                                                                                  }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 361: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74))); 
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 362: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74))); 
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 363: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74))); 
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 364: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74))); 
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 365: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 366: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 367: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 368: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 371: /* column_reference ::= column_name */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy317, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy317)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 372: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy317, createColumnNode(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy317)); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 373: /* pseudo_column ::= ROWTS */
      case 374: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==374);
      case 376: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==376);
      case 377: /* pseudo_column ::= QEND */ yytestcase(yyruleno==377);
      case 378: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==378);
      case 379: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==379);
      case 380: /* pseudo_column ::= WEND */ yytestcase(yyruleno==380);
      case 381: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==381);
      case 382: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==382);
      case 383: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==383);
      case 389: /* literal_func ::= NOW */ yytestcase(yyruleno==389);
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 375: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy317)))); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 384: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 385: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==385);
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy317, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy317, yymsp[-1].minor.yy874)); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 386: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), yymsp[-1].minor.yy898)); }
  yymsp[-5].minor.yy74 = yylhsminor.yy74;
        break;
      case 388: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy317, NULL)); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 403: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy874 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 408: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 472: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==472);
{ yylhsminor.yy74 = createColumnNode(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 409: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy874, yymsp[-1].minor.yy74)); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 410: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), yymsp[-2].minor.yy874, yymsp[-1].minor.yy74)); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 413: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy74 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)); }
        break;
      case 415: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy74 = releaseRawExprNode(pCxt, yymsp[0].minor.yy74); }
        break;
      case 416: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 421: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==421);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy20, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 417: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy74), releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 418: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy74), releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-5].minor.yy74 = yylhsminor.yy74;
        break;
      case 419: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), NULL));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 420: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), NULL));
                                                                                  }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 422: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy20 = OP_TYPE_LOWER_THAN; }
        break;
      case 423: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy20 = OP_TYPE_GREATER_THAN; }
        break;
      case 424: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy20 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 425: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy20 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 426: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy20 = OP_TYPE_NOT_EQUAL; }
        break;
      case 427: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy20 = OP_TYPE_EQUAL; }
        break;
      case 428: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy20 = OP_TYPE_LIKE; }
        break;
      case 429: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy20 = OP_TYPE_NOT_LIKE; }
        break;
      case 430: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy20 = OP_TYPE_MATCH; }
        break;
      case 431: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy20 = OP_TYPE_NMATCH; }
        break;
      case 432: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy20 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 433: /* in_op ::= IN */
{ yymsp[0].minor.yy20 = OP_TYPE_IN; }
        break;
      case 434: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy20 = OP_TYPE_NOT_IN; }
        break;
      case 435: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy874)); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 437: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy74), NULL));
                                                                                  }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 438: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 439: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 445: /* from_clause_opt ::= FROM table_reference_list */
      case 474: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==474);
      case 503: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==503);
{ yymsp[-1].minor.yy74 = yymsp[0].minor.yy74; }
        break;
      case 447: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy74 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy74, yymsp[0].minor.yy74, NULL); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 450: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy74 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy317, &yymsp[0].minor.yy317); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 451: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy74 = createRealTableNode(pCxt, &yymsp[-3].minor.yy317, &yymsp[-1].minor.yy317, &yymsp[0].minor.yy317); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 452: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy74 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy74), &yymsp[0].minor.yy317); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 454: /* alias_opt ::= */
{ yymsp[1].minor.yy317 = nil_token;  }
        break;
      case 456: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy317 = yymsp[0].minor.yy317; }
        break;
      case 457: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 458: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==458);
{ yymsp[-2].minor.yy74 = yymsp[-1].minor.yy74; }
        break;
      case 459: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy74 = createJoinTableNode(pCxt, yymsp[-4].minor.yy630, yymsp[-5].minor.yy74, yymsp[-2].minor.yy74, yymsp[0].minor.yy74); }
  yymsp[-5].minor.yy74 = yylhsminor.yy74;
        break;
      case 460: /* join_type ::= */
{ yymsp[1].minor.yy630 = JOIN_TYPE_INNER; }
        break;
      case 461: /* join_type ::= INNER */
{ yymsp[0].minor.yy630 = JOIN_TYPE_INNER; }
        break;
      case 462: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy74 = createSelectStmt(pCxt, yymsp[-10].minor.yy335, yymsp[-9].minor.yy874, yymsp[-8].minor.yy74);
                                                                                    yymsp[-11].minor.yy74 = addWhereClause(pCxt, yymsp[-11].minor.yy74, yymsp[-7].minor.yy74);
                                                                                    yymsp[-11].minor.yy74 = addPartitionByClause(pCxt, yymsp[-11].minor.yy74, yymsp[-6].minor.yy874);
                                                                                    yymsp[-11].minor.yy74 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy74, yymsp[-2].minor.yy74);
                                                                                    yymsp[-11].minor.yy74 = addGroupByClause(pCxt, yymsp[-11].minor.yy74, yymsp[-1].minor.yy874);
                                                                                    yymsp[-11].minor.yy74 = addHavingClause(pCxt, yymsp[-11].minor.yy74, yymsp[0].minor.yy74);
                                                                                    yymsp[-11].minor.yy74 = addRangeClause(pCxt, yymsp[-11].minor.yy74, yymsp[-5].minor.yy74);
                                                                                    yymsp[-11].minor.yy74 = addEveryClause(pCxt, yymsp[-11].minor.yy74, yymsp[-4].minor.yy74);
                                                                                    yymsp[-11].minor.yy74 = addFillClause(pCxt, yymsp[-11].minor.yy74, yymsp[-3].minor.yy74);
                                                                                  }
        break;
      case 465: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy335 = false; }
        break;
      case 468: /* select_item ::= NK_STAR */
{ yylhsminor.yy74 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 470: /* select_item ::= common_expression column_alias */
      case 480: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==480);
{ yylhsminor.yy74 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy74), &yymsp[0].minor.yy317); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 471: /* select_item ::= common_expression AS column_alias */
      case 481: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==481);
{ yylhsminor.yy74 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), &yymsp[0].minor.yy317); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 476: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 499: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==499);
      case 518: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==518);
{ yymsp[-2].minor.yy874 = yymsp[0].minor.yy874; }
        break;
      case 483: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy74 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), releaseRawExprNode(pCxt, yymsp[-1].minor.yy74)); }
        break;
      case 484: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy74 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy74)); }
        break;
      case 485: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy74 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), NULL, yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 486: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy74 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy74), releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 487: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy74 = createEventWindowNode(pCxt, yymsp[-3].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 491: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy74 = createFillNode(pCxt, yymsp[-1].minor.yy828, NULL); }
        break;
      case 492: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy74 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy874)); }
        break;
      case 493: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy828 = FILL_MODE_NONE; }
        break;
      case 494: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy828 = FILL_MODE_PREV; }
        break;
      case 495: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy828 = FILL_MODE_NULL; }
        break;
      case 496: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy828 = FILL_MODE_LINEAR; }
        break;
      case 497: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy828 = FILL_MODE_NEXT; }
        break;
      case 500: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy874 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy74))); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 501: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy74))); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 505: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy74 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), releaseRawExprNode(pCxt, yymsp[-1].minor.yy74)); }
        break;
      case 508: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy74 = addOrderByClause(pCxt, yymsp[-3].minor.yy74, yymsp[-2].minor.yy874);
                                                                                    yylhsminor.yy74 = addSlimitClause(pCxt, yylhsminor.yy74, yymsp[-1].minor.yy74);
                                                                                    yylhsminor.yy74 = addLimitClause(pCxt, yylhsminor.yy74, yymsp[0].minor.yy74);
                                                                                  }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 511: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy74 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy74, yymsp[0].minor.yy74); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 512: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy74 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy74, yymsp[0].minor.yy74); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 520: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 524: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==524);
{ yymsp[-1].minor.yy74 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 521: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 525: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==525);
{ yymsp[-3].minor.yy74 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 522: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 526: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==526);
{ yymsp[-3].minor.yy74 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 527: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy74); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 532: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy74 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), yymsp[-1].minor.yy326, yymsp[0].minor.yy109); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 533: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy326 = ORDER_ASC; }
        break;
      case 534: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy326 = ORDER_ASC; }
        break;
      case 535: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy326 = ORDER_DESC; }
        break;
      case 536: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy109 = NULL_ORDER_DEFAULT; }
        break;
      case 537: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy109 = NULL_ORDER_FIRST; }
        break;
      case 538: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy109 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
