/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 476
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EFillMode yy46;
  SAlterOption yy53;
  SToken yy113;
  EOperatorType yy156;
  bool yy369;
  SNodeList* yy432;
  SNode* yy448;
  int8_t yy551;
  ENullOrder yy585;
  EJoinType yy596;
  EOrder yy666;
  SDataType yy728;
  STokenPair yy777;
  int32_t yy788;
  int64_t yy837;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             762
#define YYNRULE              583
#define YYNTOKEN             330
#define YY_MAX_SHIFT         761
#define YY_MIN_SHIFTREDUCE   1136
#define YY_MAX_SHIFTREDUCE   1718
#define YY_ERROR_ACTION      1719
#define YY_ACCEPT_ACTION     1720
#define YY_NO_ACTION         1721
#define YY_MIN_REDUCE        1722
#define YY_MAX_REDUCE        2304
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2905)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  2116, 1881, 2010,  499,  432, 1877,  500, 1758,  431, 2102,
 /*    10 */   670, 2051,   46,   44, 1646, 1722, 2102, 2008,  640, 2098,
 /*    20 */   393,  504, 1495, 1520,   39,   38, 2098,  501,   45,   43,
 /*    30 */    42,   41,   40, 1576, 1791, 1493, 2134, 2010, 1520,  132,
 /*    40 */   131,  130,  129,  128,  127,  126,  125,  124, 2084,  384,
 /*    50 */   669,  591, 2007,  640, 2275, 2094, 2100,  374,  244, 1571,
 /*    60 */    28, 1944, 2094, 2100,  375,   19,  663,  652,  371, 2281,
 /*    70 */   184,  638, 1501,  663, 2276,  617, 1942,  628,  140, 1869,
 /*    80 */   507, 2115,  107,  500, 1758, 2151,   36,  296,  169, 2117,
 /*    90 */   673, 2119, 2120,  668,  168,  663, 1734,  758,  141,    9,
 /*   100 */    15,  735,  734,  733,  732,  403, 1884,  731,  730,  144,
 /*   110 */   725,  724,  723,  722,  721,  720,  719,  157,  715,  714,
 /*   120 */   713,  402,  401,  710,  709,  708,  707,  706,  592, 2241,
 /*   130 */   398, 2219, 1320, 1937, 1939,  123, 1578, 1579,  122,  121,
 /*   140 */   120,  119,  118,  117,  116,  115,  114, 1311,  695,  694,
 /*   150 */   693, 1315,  692, 1317, 1318,  691,  688, 2216, 1326,  685,
 /*   160 */  1328, 1329,  682,  679,  177,  652, 1551, 1561, 2280, 1409,
 /*   170 */  1410, 2275, 1577, 1580, 1944,  653, 1892,  630,  182, 2212,
 /*   180 */  2213,  356,  138, 2217,  358, 1993, 1496, 2279, 1494, 1942,
 /*   190 */  1720, 2276, 2278,  133,  287,  288,  516,   39,   38,  286,
 /*   200 */   537,   45,   43,   42,   41,   40,  278,   62,  703,  155,
 /*   210 */   154,  700,  699,  698,  152, 1499, 1500, 1794, 1550, 1553,
 /*   220 */  1554, 1555, 1556, 1557, 1558, 1559, 1560,  665,  661, 1569,
 /*   230 */  1570, 1572, 1573, 1574, 1575,    2,   46,   44,  425, 1169,
 /*   240 */  1522,  341,   62, 1518,  393,   49, 1495,   62,  611,   93,
 /*   250 */   469, 2116,  616,  483,  350, 2275,  482, 1576,  177, 1493,
 /*   260 */   406,  670,  427,  423,  405,   45,   43,   42,   41,   40,
 /*   270 */   615,  184,  452,   50,  484, 2276,  617,  454, 1171, 1994,
 /*   280 */  1174, 1175,  180, 1571,  555,  554,  553, 2134, 1723,   19,
 /*   290 */   106,  545,  137,  549, 1931, 1520, 1501,  548, 1605, 2084,
 /*   300 */   103,  669,  547,  552,  366,  365, 1521,  591,  546,  123,
 /*   310 */  2275, 1639,  122,  121,  120,  119,  118,  117,  116,  115,
 /*   320 */   114,  758,  359,  101,   15, 2281,  184,  430, 2280,  429,
 /*   330 */  2276,  617, 2115, 1191,  442, 1190, 2151,  653, 1892,  110,
 /*   340 */  2117,  673, 2119, 2120,  668, 1522,  663, 1885,  226,  143,
 /*   350 */   438,  150, 2175, 2204, 1606,  133,  428,  387, 2200,  187,
 /*   360 */  1578, 1579,  542,  480, 1519, 1192,  474,  473,  472,  471,
 /*   370 */   468,  467,  466,  465,  464,  460,  459,  458,  457,  340,
 /*   380 */   449,  448,  447,  209,  444,  443,  357,  502,  277, 1765,
 /*   390 */  1551, 1561, 2280,  338,  187, 2275, 1577, 1580, 1650,  187,
 /*   400 */   555,  554,  553,  705, 1520, 1938, 1939,  545,  137,  549,
 /*   410 */  1496, 2279, 1494,  548,  606, 2276, 2277, 1868,  547,  552,
 /*   420 */   366,  365, 1354, 1355,  546,  187, 1708, 1264,   35,  391,
 /*   430 */  1600, 1601, 1602, 1603, 1604, 1608, 1609, 1610, 1611, 1499,
 /*   440 */  1500, 1552, 1550, 1553, 1554, 1555, 1556, 1557, 1558, 1559,
 /*   450 */  1560,  665,  661, 1569, 1570, 1572, 1573, 1574, 1575,    2,
 /*   460 */    12,   46,   44,  227, 1266, 1495,  167, 1521,  211,  393,
 /*   470 */  2116, 1495,  502, 1833, 1765, 1674,  578,  652, 1493,  172,
 /*   480 */   631,  705, 1576,  476, 1493,  533,  529,  525,  521,  224,
 /*   490 */  2219,   39,   38,  277, 1745,   45,   43,   42,   41,   40,
 /*   500 */   612,  607,  600, 1523, 1523,   66, 2134, 1883, 1571,  551,
 /*   510 */   550, 1501, 1520,  610,   19, 1501, 2215, 2098, 2084,  639,
 /*   520 */   669, 1501,  603,  602, 1672, 1673, 1675, 1676, 1677,   88,
 /*   530 */    39,   38,  222,   12,   45,   43,   42,   41,   40, 2134,
 /*   540 */   758, 1944, 2084,  200,  199,  543,  758, 1744,  381,   15,
 /*   550 */  1552, 2115, 1607, 2094, 2100, 2151, 1942,   49,  110, 2117,
 /*   560 */   673, 2119, 2120,  668,  663,  663,  475, 1262,  166,  514,
 /*   570 */   181, 2003, 2204,  316,   39,   38,  387, 2200,   45,   43,
 /*   580 */    42,   41,   40, 1426, 1427, 1578, 1579,  314,   73,  186,
 /*   590 */  1743,   72,   62,  609,  560, 2084, 1191, 2230, 1190,  221,
 /*   600 */   215,   62,   87,  639,  220,   12,  512,   10, 2219,  570,
 /*   610 */   207,  495,  493,  490,  696, 1551, 1561,  396,  360, 1425,
 /*   620 */  1428, 1577, 1580,  240,  213,  162,   33, 1887, 1192, 1496,
 /*   630 */   717, 1494,  372, 1894, 2214, 1496, 1612, 1494, 2084,  563,
 /*   640 */  1942, 2067,  653, 1892,  557,  653, 1892, 1944, 1742,  239,
 /*   650 */    62,  255,  193,  637,  386, 2003, 2102,  541, 1499, 1500,
 /*   660 */   189,  540, 1942,   55, 1499, 1500, 2098, 1550, 1553, 1554,
 /*   670 */  1555, 1556, 1557, 1558, 1559, 1560,  665,  661, 1569, 1570,
 /*   680 */  1572, 1573, 1574, 1575,    2,   46,   44, 1581,  109,   70,
 /*   690 */  1944, 2116,   69,  393, 1879, 1495, 2084,  397,  653, 1892,
 /*   700 */  1715,  631, 2094, 2100,  388, 1942, 1576, 1741, 1493,  187,
 /*   710 */   718,   32, 1854,  663,  628,  140,  436,   39,   38,  653,
 /*   720 */  1892,   45,   43,   42,   41,   40, 1834, 2134,   81,   80,
 /*   730 */   435,   87, 1571,  191,  164,  729,  727,  437,  639, 2084,
 /*   740 */  1875,  669,   39,   38,  187, 1501,   45,   43,   42,   41,
 /*   750 */    40,  653, 1892,  187,  339, 2084, 1888,  421, 1974, 1989,
 /*   760 */   419,  415,  411,  408,  428, 1177, 1740,  653, 1892,  446,
 /*   770 */   758, 1519, 2115,   47,  653, 1892, 2151, 2116, 1739,  110,
 /*   780 */  2117,  673, 2119, 2120,  668,  461,  663,  670,  648, 1767,
 /*   790 */  2003,  181,  462, 2204,   34, 1643, 1738,  387, 2200, 1714,
 /*   800 */    39,   38,  187,  192,   45,   43,   42,   41,   40, 1578,
 /*   810 */  1579,  653, 1892, 2134, 2084,  275, 2212,  627, 2231,  134,
 /*   820 */   626,  569, 2275,  628,  140, 2084, 2084,  669, 1896,  515,
 /*   830 */  1523,  653, 1892,  196,  567, 1685,  565,  615,  184, 1551,
 /*   840 */  1561, 1989, 2276,  617, 2084, 1577, 1580,   39,   38, 1889,
 /*   850 */   420,   45,   43,   42,   41,   40, 1867,  142, 2115, 1496,
 /*   860 */  2175, 1494, 2151,  653, 1892,  110, 2117,  673, 2119, 2120,
 /*   870 */   668, 1944,  663,   84,  242,  249,   83, 2295,  241, 2204,
 /*   880 */   363,  245,  165,  387, 2200,  194, 1943,  634, 1499, 1500,
 /*   890 */  1895, 1550, 1553, 1554, 1555, 1556, 1557, 1558, 1559, 1560,
 /*   900 */   665,  661, 1569, 1570, 1572, 1573, 1574, 1575,    2,   46,
 /*   910 */    44, 2116,  655,  456, 2176,  653, 1892,  393, 1737, 1495,
 /*   920 */  1736,  670,  455, 2238,  183, 2212, 2213,  253,  138, 2217,
 /*   930 */  1576, 2116, 1493,  587,  591, 1174, 1175, 2275,   90,  345,
 /*   940 */  1662,  667,  370,  657,  571, 2176,  364, 2134,  362,  361,
 /*   950 */  1733,  539, 2281,  184, 1586, 1735, 1571, 2276,  617, 2084,
 /*   960 */  1520,  669,  653, 1892,  653, 1892, 2084, 2134, 2084, 1501,
 /*   970 */    91, 1275,  541,   42,   41,   40,  540, 2279,  254, 2084,
 /*   980 */   632,  669,  636, 2103, 1274,  703,  155,  154,  700,  699,
 /*   990 */   698,  152, 2115, 2098,  758, 2077, 2151,   47, 2084,  110,
 /*  1000 */  2117,  673, 2119, 2120,  668, 2116,  663, 2078,   14,   13,
 /*  1010 */  1732, 2295, 2115, 2204, 1731,  670, 2151,  387, 2200,  332,
 /*  1020 */  2117,  673, 2119, 2120,  668,  666,  663,  654, 2169, 2094,
 /*  1030 */  2100,   39,   38, 1578, 1579,   45,   43,   42,   41,   40,
 /*  1040 */   663, 2134,  591,  385, 1642, 2275,  485, 1989,  620,  653,
 /*  1050 */  1892,  165,  660, 2084,  591,  669,  664, 2275, 2084, 1894,
 /*  1060 */  2281,  184, 2084, 1551, 1561, 2276,  617,  291,  697, 1577,
 /*  1070 */  1580, 1935, 2281,  184, 2224, 1639,  396, 2276,  617, 1717,
 /*  1080 */  1718,  653, 1892, 1496,  165, 1494, 2115,  653, 1892, 1279,
 /*  1090 */  2151,  198, 1894,  170, 2117,  673, 2119, 2120,  668,  650,
 /*  1100 */   663,  576, 1278,  628,  140,  651, 1552,   52, 1619,    3,
 /*  1110 */   243,  701, 1499, 1500, 1935, 1550, 1553, 1554, 1555, 1556,
 /*  1120 */  1557, 1558, 1559, 1560,  665,  661, 1569, 1570, 1572, 1573,
 /*  1130 */  1574, 1575,    2,   46,   44,  653, 1892,  653, 1892, 1730,
 /*  1140 */  1729,  393,  399, 1495,  618, 2296, 1728, 2116,  591, 2070,
 /*  1150 */   165, 2275, 1727,  297, 1576,  400, 1493,  670, 1894, 2251,
 /*  1160 */   153,  623,  439, 1726,  487, 1725, 2281,  184, 1870,  252,
 /*  1170 */   310, 2276,  617, 1921, 2116,  440,  702, 1468, 1469, 1935,
 /*  1180 */  1571,   74,  232, 2134,  670,  230,  598, 2084, 2084,  146,
 /*  1190 */   573,  135,  572, 1501, 2084, 2084,  616,  669,  413, 2275,
 /*  1200 */  2084,  590, 1597,  544,  185, 2212, 2213, 1781,  138, 2217,
 /*  1210 */  2134, 2084,  148, 2084,  615,  184, 2244,   54,  758, 2276,
 /*  1220 */   617,   15, 2084,  234,  669, 1260,  233,  272, 2115,  556,
 /*  1230 */    82, 1504, 2151,  153, 2116,  110, 2117,  673, 2119, 2120,
 /*  1240 */   668, 1503,  663,  604,  670,  236,  619, 2295,  235, 2204,
 /*  1250 */  1774, 1772,  225,  387, 2200, 2115,  153, 1578, 1579, 2151,
 /*  1260 */    64,  711,  110, 2117,  673, 2119, 2120,  668,  238,  663,
 /*  1270 */  2134,  237,  558,  561, 2295,   64, 2204,  259,  621,  266,
 /*  1280 */   387, 2200, 2084, 1240,  669, 2105, 2135, 1551, 1561, 1998,
 /*  1290 */  1463, 1221,  404, 1577, 1580, 1759,  703,  155,  154,  700,
 /*  1300 */   699,  698,  152,   14,   13,  153, 1764, 1496,   48, 1494,
 /*  1310 */  1932,  284, 2234, 1466,   71, 2115,  151, 1671,  153, 2151,
 /*  1320 */   629,   53,  169, 2117,  673, 2119, 2120,  668, 1222,  663,
 /*  1330 */    48, 1768, 1670,   64,  261,   48, 1499, 1500, 2107, 1550,
 /*  1340 */  1553, 1554, 1555, 1556, 1557, 1558, 1559, 1560,  665,  661,
 /*  1350 */  1569, 1570, 1572, 1573, 1574, 1575,    2,  271,  274,  390,
 /*  1360 */   389,  677,  635, 2242,  151, 1423,  153, 2116,  289, 1509,
 /*  1370 */   136,  645,  151,  293,  712, 1305,    1,  670,    5, 2269,
 /*  1380 */  1576,  753, 1502,  407, 1507,  412,  354,  309, 1446,  441,
 /*  1390 */  1613,  304, 1562,  624, 1506,  197, 1238, 2116, 1523, 1999,
 /*  1400 */   445,  478,  450, 2134, 1518,  463, 1571,  670, 1991, 2223,
 /*  1410 */   470,  477,  479,  488,  489, 2084,  202,  669, 1332, 1501,
 /*  1420 */   486, 1336,  201, 1343,  491,  492,  204, 1341,  494,  156,
 /*  1430 */   496, 1524,  497, 2134,    4,  498,  505,  506, 1526,  508,
 /*  1440 */   212, 1521,  509,  214,  659, 2084, 1525,  669, 2115,  510,
 /*  1450 */  1527,  511, 2151,  217,  513,  110, 2117,  673, 2119, 2120,
 /*  1460 */   668,  219,  663,   85,   86, 2116, 1194, 2295,  517, 2204,
 /*  1470 */   223,  536,  534,  387, 2200,  670,  535,  538, 2115,  344,
 /*  1480 */  2060, 1882, 2151, 2057,  229,  110, 2117,  673, 2119, 2120,
 /*  1490 */   668, 1878,  663,  112,  577,  575,  231, 2295,   89, 2204,
 /*  1500 */   158, 2134,  159,  387, 2200,  149, 1880, 1876,  160, 2056,
 /*  1510 */   246,  161,  582, 2084,  580,  669,  305,  581,  585,  250,
 /*  1520 */  1453,  588,    8,  605, 2250,  248,  643,  595, 2249,  586,
 /*  1530 */   257,  601,  614, 1510, 2235, 1505, 2245,  376,  608, 2226,
 /*  1540 */   265,  173,  596,  594,  260,  268, 2115,  267,  593,  622,
 /*  1550 */  2151, 2298,  625,  110, 2117,  673, 2119, 2120,  668,  269,
 /*  1560 */   663,  377, 1513, 1515, 2274, 2179,  139, 2204,  270, 1639,
 /*  1570 */  1522,  387, 2200, 2116, 2220,  661, 1569, 1570, 1572, 1573,
 /*  1580 */  1574, 1575,  279,  670,  633,  380, 1528,   96, 2004,  306,
 /*  1590 */   641,  642, 2018, 2116, 2017, 2016,  307,  646,  273,  383,
 /*  1600 */    98,  647,  308,  670,   61,  100, 1893, 2185,  102, 2134,
 /*  1610 */  1936,  311,  754, 1855, 2076,  755,  675,  757,   51,  346,
 /*  1620 */  2075, 2084,  347,  669, 2074,  315,  300,  335,  320, 2134,
 /*  1630 */   313,  334,   78, 2071,  409, 1486,  410, 1487,  324,  190,
 /*  1640 */   414, 2084,  416,  669, 2069,  417,  418, 2068,  355, 2066,
 /*  1650 */   422, 2065,  424, 2064, 2115,   79,  426, 1449, 2151, 1448,
 /*  1660 */  2030,  110, 2117,  673, 2119, 2120,  668, 2029,  663, 2028,
 /*  1670 */   433,  434, 2027, 2177, 2115, 2204, 1400, 2116, 2151,  387,
 /*  1680 */  2200,  110, 2117,  673, 2119, 2120,  668,  670,  663, 2026,
 /*  1690 */  1982, 1981, 1979,  656,  145, 2204, 1978, 1977, 1980,  387,
 /*  1700 */  2200, 2116, 1976, 1975, 1973, 1972, 1971,  195,  451, 1970,
 /*  1710 */   453,  670, 1984, 2134, 1969, 1968, 1967, 1966, 1965, 1964,
 /*  1720 */  1963, 1962, 1961, 1960, 1959, 2084, 1958,  669, 1957, 1956,
 /*  1730 */  1955, 1954, 1953, 1952, 1983,  147, 1951, 2134, 1950, 1949,
 /*  1740 */  1948, 1947,  481, 1946, 1945, 1797,  203, 1402,  342, 2084,
 /*  1750 */  1796,  669, 1795,  205,  206,  343, 1793, 1276, 2115, 1280,
 /*  1760 */  1754, 1176, 2151,  218, 2024,  111, 2117,  673, 2119, 2120,
 /*  1770 */   668,  178,  663, 1753, 2047, 2037, 2025, 1272, 2116, 2204,
 /*  1780 */  2002, 1871, 2115, 2203, 2200,   76, 2151,   77,  670,  111,
 /*  1790 */  2117,  673, 2119, 2120,  668,  208,  663,  216, 2104,  210,
 /*  1800 */  1792, 2116,  179, 2204,  503, 1790,  518,  658, 2200,  520,
 /*  1810 */   519,  670, 1788,  522, 2134, 1214,  523, 1786,  524,  526,
 /*  1820 */  1784,  527,  528,  530, 2116,  532, 2084, 1771,  669, 1770,
 /*  1830 */  1750,  531, 1873, 1348,  670, 1347, 1872, 2134, 1263, 1261,
 /*  1840 */   726, 1259, 1258, 1257, 1256, 1255,  728, 2116, 1250, 2084,
 /*  1850 */  1252,  669, 1782, 1251, 1249,  367, 1775,  670, 1773,  671,
 /*  1860 */  2134,  228,  368, 2151,  369,  559,  111, 2117,  673, 2119,
 /*  1870 */  2120,  668, 2084,  663,  669,   63,  562, 1749,  564, 1748,
 /*  1880 */  2204,  566, 2115, 2134,  349, 2200, 2151, 1747,  568,  111,
 /*  1890 */  2117,  673, 2119, 2120,  668, 2084,  663,  669,  113, 1473,
 /*  1900 */  1475,   27, 1472, 2204, 2046, 2115, 1459, 1455, 2201, 2151,
 /*  1910 */  2116,   67,  326, 2117,  673, 2119, 2120,  668, 1457,  663,
 /*  1920 */   670, 2036, 1477,  583, 2023, 2021, 2280,   20, 2115, 1687,
 /*  1930 */    56,   17, 2151,    6,   29,  170, 2117,  673, 2119, 2120,
 /*  1940 */   668,    7,  663,  589,  256,  584, 2134,  597,  258,  599,
 /*  1950 */    59,  382,   60,  373,  163,  613, 1669,  171, 2084,  251,
 /*  1960 */   669,  262,   30,  263, 1661,  264,   21,   65,   92, 2105,
 /*  1970 */    31, 1707, 1708,   22, 1702, 2116, 1701,  378, 1706, 1705,
 /*  1980 */   379, 1636, 1635, 2022,  276,  667, 2020, 2297, 2019, 2001,
 /*  1990 */    58, 2115,   94,   95,  174, 2151, 2116,  282,  333, 2117,
 /*  2000 */   673, 2119, 2120,  668,  283,  663,  670,   23,  644, 2116,
 /*  2010 */  1667, 2134,  285,  290,   68, 2000,   97,  292,  295,  670,
 /*  2020 */   103,   13,   24, 2084, 1511,  669, 1588,   99, 1587,   11,
 /*  2030 */  1543, 1598, 2134, 2154,  175, 1566, 1564,  392,  662,  188,
 /*  2040 */    57, 1563,  672,  674, 2084, 2134,  669,   18,   37,   16,
 /*  2050 */   394,   25,  676, 1535, 1333,   26, 2115, 2084,  395,  669,
 /*  2060 */  2151,  579,  678,  332, 2117,  673, 2119, 2120,  668, 1330,
 /*  2070 */   663,  680, 2170,  681,  683, 1327,  684, 2115,  686,  761,
 /*  2080 */  1321, 2151,  687,  689,  333, 2117,  673, 2119, 2120,  668,
 /*  2090 */  2115,  663, 1319,  303, 2151,  690, 2116,  333, 2117,  673,
 /*  2100 */  2119, 2120,  668, 1325,  663,  104,  670, 1324,  298,  176,
 /*  2110 */   105, 1342, 1323,   75, 1338,  751,  747,  743,  739,  301,
 /*  2120 */  2116, 1322, 1212,  704, 1246, 1245, 1244, 1270, 1243, 1242,
 /*  2130 */   670, 1241, 2134, 1239, 1237, 1236, 1235, 1233,  716,  299,
 /*  2140 */  1232, 1231, 1230, 1229, 2084, 1228,  669, 1227, 1265, 1267,
 /*  2150 */  1224, 1223, 1218, 1220, 1219, 1789, 2134, 1217,  736,  108,
 /*  2160 */   737, 1787,  294,  738,  740,  742, 1785,  744, 2084, 1783,
 /*  2170 */   669,  748, 1769,  746,  741,  752,  745,  574,  750, 1166,
 /*  2180 */   749, 2151, 1746, 2116,  328, 2117,  673, 2119, 2120,  668,
 /*  2190 */   302,  663,  756,  670,  649, 1497,  312,  759,  760, 1721,
 /*  2200 */  1721, 2115, 1721, 1721, 1721, 2151, 1721, 2116,  317, 2117,
 /*  2210 */   673, 2119, 2120,  668, 1721,  663, 1721,  670, 1721, 2134,
 /*  2220 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,  281,
 /*  2230 */  1721, 2084, 1721,  669,  280, 1721, 1721, 1721, 1721, 1721,
 /*  2240 */  1721, 1721, 1721, 2134, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2250 */  1721, 1721, 1721, 2116,  247, 2084, 1721,  669, 1721, 1721,
 /*  2260 */  1721, 1721, 1721,  670, 2115, 1721, 1721, 1721, 2151, 2116,
 /*  2270 */  1721,  318, 2117,  673, 2119, 2120,  668, 1721,  663,  670,
 /*  2280 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 2115, 2134,
 /*  2290 */  1721, 1721, 2151, 1721, 1721,  319, 2117,  673, 2119, 2120,
 /*  2300 */   668, 2084,  663,  669, 1721, 2134, 1721, 1721, 1721, 1721,
 /*  2310 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 2084, 1721,  669,
 /*  2320 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 2116,
 /*  2330 */  1721, 1721, 1721, 1721, 2115, 1721, 1721, 1721, 2151,  670,
 /*  2340 */  1721,  325, 2117,  673, 2119, 2120,  668, 1721,  663, 1721,
 /*  2350 */  2115, 1721, 1721, 2116, 2151, 1721, 1721,  329, 2117,  673,
 /*  2360 */  2119, 2120,  668,  670,  663, 2134, 1721, 1721, 1721, 1721,
 /*  2370 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 2084, 1721,  669,
 /*  2380 */  2116, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 2134,
 /*  2390 */   670, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 2116,
 /*  2400 */  1721, 2084, 1721,  669, 1721, 1721, 1721, 1721, 1721,  670,
 /*  2410 */  2115, 1721, 1721, 1721, 2151, 1721, 2134,  321, 2117,  673,
 /*  2420 */  2119, 2120,  668, 1721,  663, 1721, 1721, 1721, 2084, 1721,
 /*  2430 */   669, 1721, 1721, 1721, 2115, 2134, 1721, 1721, 2151, 1721,
 /*  2440 */  1721,  330, 2117,  673, 2119, 2120,  668, 2084,  663,  669,
 /*  2450 */  2116, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2460 */   670, 2115, 1721, 1721, 1721, 2151, 2116, 1721,  322, 2117,
 /*  2470 */   673, 2119, 2120,  668, 1721,  663,  670, 1721, 1721, 1721,
 /*  2480 */  2115, 1721, 1721, 1721, 2151, 1721, 2134,  331, 2117,  673,
 /*  2490 */  2119, 2120,  668, 1721,  663, 1721, 2116, 1721, 2084, 1721,
 /*  2500 */   669, 1721, 2134, 1721, 1721, 1721,  670, 1721, 1721, 1721,
 /*  2510 */  1721, 1721, 1721, 1721, 2084, 1721,  669, 2116, 1721, 1721,
 /*  2520 */  1721, 1721, 1721, 1721, 1721, 1721, 1721,  670, 1721, 1721,
 /*  2530 */  1721, 2115, 2134, 1721, 1721, 2151, 1721, 1721,  323, 2117,
 /*  2540 */   673, 2119, 2120,  668, 2084,  663,  669, 2115, 1721, 1721,
 /*  2550 */  1721, 2151, 1721, 2134,  336, 2117,  673, 2119, 2120,  668,
 /*  2560 */  1721,  663, 1721, 2116, 1721, 2084, 1721,  669, 1721, 1721,
 /*  2570 */  1721, 1721, 1721,  670, 1721, 1721, 1721, 2115, 1721, 1721,
 /*  2580 */  1721, 2151, 1721, 1721,  337, 2117,  673, 2119, 2120,  668,
 /*  2590 */  1721,  663, 1721, 1721, 1721, 1721, 1721, 1721, 2115, 2134,
 /*  2600 */  1721, 1721, 2151, 1721, 1721, 2128, 2117,  673, 2119, 2120,
 /*  2610 */   668, 2084,  663,  669, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2620 */  1721, 1721, 1721, 2116, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2630 */  1721, 1721, 1721,  670, 1721, 1721, 2116, 1721, 1721, 1721,
 /*  2640 */  1721, 1721, 1721, 1721, 2115, 1721,  670, 1721, 2151, 1721,
 /*  2650 */  1721, 2127, 2117,  673, 2119, 2120,  668, 1721,  663, 2134,
 /*  2660 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2670 */  1721, 2084, 2134,  669, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2680 */  1721, 1721, 1721, 1721, 2084, 1721,  669, 2116, 1721, 1721,
 /*  2690 */  1721, 1721, 1721, 1721, 1721, 1721, 1721,  670, 1721, 1721,
 /*  2700 */  1721, 1721, 1721, 1721, 2115, 1721, 1721, 1721, 2151, 1721,
 /*  2710 */  1721, 2126, 2117,  673, 2119, 2120,  668, 2115,  663, 1721,
 /*  2720 */  1721, 2151, 1721, 2134,  351, 2117,  673, 2119, 2120,  668,
 /*  2730 */  1721,  663, 1721, 2116, 1721, 2084, 1721,  669, 1721, 1721,
 /*  2740 */  1721, 1721, 1721,  670, 1721, 1721, 1721, 1721, 2116, 1721,
 /*  2750 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,  670, 1721,
 /*  2760 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 2115, 2134,
 /*  2770 */  1721, 1721, 2151, 1721, 1721,  352, 2117,  673, 2119, 2120,
 /*  2780 */   668, 2084,  663,  669, 2134, 1721, 1721, 1721, 1721, 1721,
 /*  2790 */  1721, 1721, 1721, 1721, 2116, 1721, 2084, 1721,  669, 1721,
 /*  2800 */  1721, 1721, 1721, 1721,  670, 1721, 1721, 1721, 1721, 2116,
 /*  2810 */  1721, 1721, 1721, 1721, 2115, 1721, 1721, 1721, 2151,  670,
 /*  2820 */  1721,  348, 2117,  673, 2119, 2120,  668, 1721,  663, 2115,
 /*  2830 */  2134, 1721, 1721, 2151, 1721, 1721,  353, 2117,  673, 2119,
 /*  2840 */  2120,  668, 2084,  663,  669, 2134, 1721, 1721, 1721, 1721,
 /*  2850 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 2084, 1721,  669,
 /*  2860 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2870 */  1721, 1721, 1721, 1721, 1721,  671, 1721, 1721, 1721, 2151,
 /*  2880 */  1721, 1721,  328, 2117,  673, 2119, 2120,  668, 1721,  663,
 /*  2890 */  2115, 1721, 1721, 1721, 2151, 1721, 1721,  327, 2117,  673,
 /*  2900 */  2119, 2120,  668, 1721,  663,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   333,  370,  383,  337,  400,  370,  340,  341,  404,  371,
 /*    10 */   343,  365,   12,   13,   14,    0,  371,  398,  399,  381,
 /*    20 */    20,   14,   22,   20,    8,    9,  381,   20,   12,   13,
 /*    30 */    14,   15,   16,   33,    0,   35,  369,  383,   20,   24,
 /*    40 */    25,   26,   27,   28,   29,   30,   31,   32,  381,  395,
 /*    50 */   383,  447,  398,  399,  450,  417,  418,  419,  412,   59,
 /*    60 */    44,  369,  417,  418,  419,   65,  428,   20,  376,  465,
 /*    70 */   466,   20,   72,  428,  470,  471,  384,  342,  343,    0,
 /*    80 */   337,  414,  348,  340,  341,  418,  436,  437,  421,  422,
 /*    90 */   423,  424,  425,  426,  332,  428,  334,   97,  364,   39,
 /*   100 */   100,   67,   68,   69,   70,   71,  372,   73,   74,   75,
 /*   110 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   120 */    86,   87,   88,   89,   90,   91,   92,   93,  461,  462,
 /*   130 */   379,  420,   97,  382,  383,   21,  136,  137,   24,   25,
 /*   140 */    26,   27,   28,   29,   30,   31,   32,  112,  113,  114,
 /*   150 */   115,  116,  117,  118,  119,  120,  121,  446,  123,  124,
 /*   160 */   125,  126,  127,  128,  369,   20,  166,  167,  447,  166,
 /*   170 */   167,  450,  172,  173,  369,  342,  343,  442,  443,  444,
 /*   180 */   445,  376,  447,  448,  389,  390,  186,  466,  188,  384,
 /*   190 */   330,  470,  471,  360,  130,  131,   64,    8,    9,  135,
 /*   200 */   367,   12,   13,   14,   15,   16,   59,  100,  129,  130,
 /*   210 */   131,  132,  133,  134,  135,  215,  216,    0,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,  233,  234,  235,   12,   13,  181,    4,
 /*   240 */    20,   18,  100,   20,   20,  100,   22,  100,   20,  102,
 /*   250 */    27,  333,  447,   30,   65,  450,   33,   33,  369,   35,
 /*   260 */   400,  343,  205,  206,  404,   12,   13,   14,   15,   16,
 /*   270 */   465,  466,   49,  100,   51,  470,  471,   54,   43,  390,
 /*   280 */    45,   46,  368,   59,   67,   68,   69,  369,    0,   65,
 /*   290 */   100,   74,   75,   76,  380,   20,   72,   80,  109,  381,
 /*   300 */   110,  383,   85,   86,   87,   88,   20,  447,   91,   21,
 /*   310 */   450,  251,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   320 */    32,   97,   99,  348,  100,  465,  466,  185,    3,  187,
 /*   330 */   470,  471,  414,   20,  111,   22,  418,  342,  343,  421,
 /*   340 */   422,  423,  424,  425,  426,   20,  428,  372,   35,  431,
 /*   350 */   342,  433,  434,  435,  165,  360,  214,  439,  440,  252,
 /*   360 */   136,  137,  367,  140,   20,   52,  143,  144,  145,  146,
 /*   370 */   147,  148,  149,  150,  151,  152,  153,  154,  155,  156,
 /*   380 */   157,  158,  159,  338,  161,  162,  163,  342,  168,  344,
 /*   390 */   166,  167,  447,  385,  252,  450,  172,  173,   14,  252,
 /*   400 */    67,   68,   69,   64,   20,  382,  383,   74,   75,   76,
 /*   410 */   186,  466,  188,   80,  171,  470,  471,    0,   85,   86,
 /*   420 */    87,   88,  136,  137,   91,  252,  101,   35,  239,  240,
 /*   430 */   241,  242,  243,  244,  245,  246,  247,  248,  249,  215,
 /*   440 */   216,  166,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   450 */   226,  227,  228,  229,  230,  231,  232,  233,  234,  235,
 /*   460 */   236,   12,   13,   33,   72,   22,  351,   20,  338,   20,
 /*   470 */   333,   22,  342,  358,  344,  215,  111,   20,   35,   49,
 /*   480 */   343,   64,   33,   81,   35,   55,   56,   57,   58,   59,
 /*   490 */   420,    8,    9,  168,  333,   12,   13,   14,   15,   16,
 /*   500 */   257,  258,  259,   20,   20,    4,  369,  371,   59,  355,
 /*   510 */   356,   72,   20,  343,   65,   72,  446,  381,  381,  342,
 /*   520 */   383,   72,  262,  263,  264,  265,  266,  267,  268,   99,
 /*   530 */     8,    9,  102,  236,   12,   13,   14,   15,   16,  369,
 /*   540 */    97,  369,  381,  141,  142,   13,   97,  333,  376,  100,
 /*   550 */   166,  414,  165,  417,  418,  418,  384,  100,  421,  422,
 /*   560 */   423,  424,  425,  426,  428,  428,  164,   35,   18,  392,
 /*   570 */   433,  394,  435,   23,    8,    9,  439,  440,   12,   13,
 /*   580 */    14,   15,   16,  136,  137,  136,  137,   37,   38,  452,
 /*   590 */   333,   41,  100,  423,    4,  381,   20,  460,   22,  169,
 /*   600 */   170,  100,  350,  342,  174,  236,  176,  238,  420,   19,
 /*   610 */    60,   61,   62,   63,  111,  166,  167,  361,  366,  172,
 /*   620 */   173,  172,  173,   33,  194,  369,  239,  375,   52,  186,
 /*   630 */    72,  188,  376,  377,  446,  186,  249,  188,  381,   49,
 /*   640 */   384,    0,  342,  343,   54,  342,  343,  369,  333,   59,
 /*   650 */   100,  168,  168,  392,  376,  394,  371,  129,  215,  216,
 /*   660 */   360,  133,  384,  360,  215,  216,  381,  218,  219,  220,
 /*   670 */   221,  222,  223,  224,  225,  226,  227,  228,  229,  230,
 /*   680 */   231,  232,  233,  234,  235,   12,   13,   14,  138,   99,
 /*   690 */   369,  333,  102,   20,  370,   22,  381,  376,  342,  343,
 /*   700 */   178,  343,  417,  418,  419,  384,   33,  333,   35,  252,
 /*   710 */   357,    2,  359,  428,  342,  343,  360,    8,    9,  342,
 /*   720 */   343,   12,   13,   14,   15,   16,  358,  369,  178,  179,
 /*   730 */   180,  350,   59,  183,  168,  355,  356,  360,  342,  381,
 /*   740 */   370,  383,    8,    9,  252,   72,   12,   13,   14,   15,
 /*   750 */    16,  342,  343,  252,  204,  381,  375,  207,    0,  343,
 /*   760 */   210,  211,  212,  213,  214,   14,  333,  342,  343,  360,
 /*   770 */    97,   20,  414,  100,  342,  343,  418,  333,  333,  421,
 /*   780 */   422,  423,  424,  425,  426,  360,  428,  343,  392,  345,
 /*   790 */   394,  433,  360,  435,    2,    4,  333,  439,  440,  277,
 /*   800 */     8,    9,  252,  387,   12,   13,   14,   15,   16,  136,
 /*   810 */   137,  342,  343,  369,  381,  443,  444,  445,  460,  447,
 /*   820 */   448,   21,  450,  342,  343,  381,  381,  383,  370,  360,
 /*   830 */    20,  342,  343,   59,   34,  101,   36,  465,  466,  166,
 /*   840 */   167,  343,  470,  471,  381,  172,  173,    8,    9,  360,
 /*   850 */   209,   12,   13,   14,   15,   16,    0,  431,  414,  186,
 /*   860 */   434,  188,  418,  342,  343,  421,  422,  423,  424,  425,
 /*   870 */   426,  369,  428,   99,  131,  370,  102,  433,  135,  435,
 /*   880 */    37,  360,  369,  439,  440,  387,  384,  400,  215,  216,
 /*   890 */   377,  218,  219,  220,  221,  222,  223,  224,  225,  226,
 /*   900 */   227,  228,  229,  230,  231,  232,  233,  234,  235,   12,
 /*   910 */    13,  333,  432,  155,  434,  342,  343,   20,  333,   22,
 /*   920 */   333,  343,  164,  345,  443,  444,  445,   59,  447,  448,
 /*   930 */    33,  333,   35,  360,  447,   45,   46,  450,  195,  196,
 /*   940 */   101,  343,  199,  432,  201,  434,  103,  369,  105,  106,
 /*   950 */   333,  108,  465,  466,   14,  334,   59,  470,  471,  381,
 /*   960 */    20,  383,  342,  343,  342,  343,  381,  369,  381,   72,
 /*   970 */   102,   22,  129,   14,   15,   16,  133,    3,  168,  381,
 /*   980 */   360,  383,  360,  371,   35,  129,  130,  131,  132,  133,
 /*   990 */   134,  135,  414,  381,   97,  400,  418,  100,  381,  421,
 /*  1000 */   422,  423,  424,  425,  426,  333,  428,  400,    1,    2,
 /*  1010 */   333,  433,  414,  435,  333,  343,  418,  439,  440,  421,
 /*  1020 */   422,  423,  424,  425,  426,  427,  428,  429,  430,  417,
 /*  1030 */   418,    8,    9,  136,  137,   12,   13,   14,   15,   16,
 /*  1040 */   428,  369,  447,  361,  253,  450,   97,  343,   44,  342,
 /*  1050 */   343,  369,   65,  381,  447,  383,  370,  450,  381,  377,
 /*  1060 */   465,  466,  381,  166,  167,  470,  471,  360,  378,  172,
 /*  1070 */   173,  381,  465,  466,  250,  251,  361,  470,  471,  136,
 /*  1080 */   137,  342,  343,  186,  369,  188,  414,  342,  343,   22,
 /*  1090 */   418,  387,  377,  421,  422,  423,  424,  425,  426,  360,
 /*  1100 */   428,  400,   35,  342,  343,  360,  166,   42,  101,   44,
 /*  1110 */   130,  378,  215,  216,  381,  218,  219,  220,  221,  222,
 /*  1120 */   223,  224,  225,  226,  227,  228,  229,  230,  231,  232,
 /*  1130 */   233,  234,  235,   12,   13,  342,  343,  342,  343,  333,
 /*  1140 */   333,   20,  361,   22,  472,  473,  333,  333,  447,    0,
 /*  1150 */   369,  450,  333,  360,   33,  360,   35,  343,  377,  345,
 /*  1160 */    44,   44,   22,  333,   97,  333,  465,  466,    0,  405,
 /*  1170 */   362,  470,  471,  365,  333,   35,  378,  197,  198,  381,
 /*  1180 */    59,  111,  104,  369,  343,  107,  345,  381,  381,   42,
 /*  1190 */   200,   44,  202,   72,  381,  381,  447,  383,   49,  450,
 /*  1200 */   381,   48,  215,   13,  443,  444,  445,    0,  447,  448,
 /*  1210 */   369,  381,   44,  381,  465,  466,  391,  101,   97,  470,
 /*  1220 */   471,  100,  381,  104,  383,   35,  107,  474,  414,   22,
 /*  1230 */   160,   35,  418,   44,  333,  421,  422,  423,  424,  425,
 /*  1240 */   426,   35,  428,  463,  343,  104,  272,  433,  107,  435,
 /*  1250 */     0,    0,  346,  439,  440,  414,   44,  136,  137,  418,
 /*  1260 */    44,   13,  421,  422,  423,  424,  425,  426,  104,  428,
 /*  1270 */   369,  107,   22,   22,  433,   44,  435,   44,  274,  457,
 /*  1280 */   439,  440,  381,   35,  383,   47,  369,  166,  167,  391,
 /*  1290 */   101,   35,  346,  172,  173,  341,  129,  130,  131,  132,
 /*  1300 */   133,  134,  135,    1,    2,   44,  343,  186,   44,  188,
 /*  1310 */   380,   44,  391,  101,   44,  414,   44,  101,   44,  418,
 /*  1320 */   449,  168,  421,  422,  423,  424,  425,  426,   72,  428,
 /*  1330 */    44,    0,  101,   44,  101,   44,  215,  216,  100,  218,
 /*  1340 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*  1350 */   229,  230,  231,  232,  233,  234,  235,  441,  467,   12,
 /*  1360 */    13,   44,  101,  462,   44,  101,   44,  333,  101,   22,
 /*  1370 */    44,  101,   44,  101,   13,  101,  451,  343,  254,  345,
 /*  1380 */    33,   50,   35,  416,  188,   49,  415,  101,  184,  388,
 /*  1390 */   101,  402,  101,  276,  188,   42,   35,  333,   20,  391,
 /*  1400 */   388,  165,  386,  369,   20,  342,   59,  343,  342,  345,
 /*  1410 */   388,  386,  386,   98,  354,  381,  342,  383,  101,   72,
 /*  1420 */    96,  101,  353,  101,   95,  352,  342,  101,  342,  101,
 /*  1430 */   342,   20,  335,  369,   48,  339,  335,  339,   20,  409,
 /*  1440 */   350,   20,  383,  350,   97,  381,   20,  383,  414,  344,
 /*  1450 */    20,  401,  418,  350,  344,  421,  422,  423,  424,  425,
 /*  1460 */   426,  350,  428,  350,  350,  333,   53,  433,  342,  435,
 /*  1470 */   350,  335,  347,  439,  440,  343,  347,  369,  414,  335,
 /*  1480 */   381,  369,  418,  381,  369,  421,  422,  423,  424,  425,
 /*  1490 */   426,  369,  428,  342,  413,  203,  369,  433,  100,  435,
 /*  1500 */   369,  369,  369,  439,  440,  411,  369,  369,  369,  381,
 /*  1510 */   348,  369,  408,  381,  191,  383,  409,  192,  383,  348,
 /*  1520 */   190,  342,  269,  261,  456,  407,  260,  381,  456,  406,
 /*  1530 */   396,  381,  177,  186,  391,  188,  391,  381,  381,  459,
 /*  1540 */   458,  456,  271,  270,  396,  454,  414,  455,  255,  273,
 /*  1550 */   418,  475,  275,  421,  422,  423,  424,  425,  426,  453,
 /*  1560 */   428,  278,  215,  216,  469,  433,  343,  435,  416,  251,
 /*  1570 */    20,  439,  440,  333,  420,  228,  229,  230,  231,  232,
 /*  1580 */   233,  234,  348,  343,  342,  344,   20,  348,  394,  396,
 /*  1590 */   381,  381,  381,  333,  381,  381,  396,  170,  468,  381,
 /*  1600 */   348,  393,  365,  343,  100,  348,  343,  438,  100,  369,
 /*  1610 */   381,  342,   36,  359,    0,  336,  373,  335,  403,  397,
 /*  1620 */     0,  381,  397,  383,    0,  331,  348,  410,  363,  369,
 /*  1630 */   349,  363,   42,    0,   35,   35,  208,   35,  363,   35,
 /*  1640 */   208,  381,   35,  383,    0,   35,  208,    0,  208,    0,
 /*  1650 */    35,    0,   22,    0,  414,  195,   35,  188,  418,  186,
 /*  1660 */     0,  421,  422,  423,  424,  425,  426,    0,  428,    0,
 /*  1670 */   182,  181,    0,  433,  414,  435,   47,  333,  418,  439,
 /*  1680 */   440,  421,  422,  423,  424,  425,  426,  343,  428,    0,
 /*  1690 */     0,    0,    0,  433,   42,  435,    0,    0,    0,  439,
 /*  1700 */   440,  333,    0,    0,    0,    0,    0,  155,   35,    0,
 /*  1710 */   155,  343,    0,  369,    0,    0,    0,    0,    0,    0,
 /*  1720 */     0,    0,    0,    0,    0,  381,    0,  383,    0,    0,
 /*  1730 */     0,    0,    0,    0,    0,   42,    0,  369,    0,    0,
 /*  1740 */     0,    0,  139,    0,    0,    0,   59,   22,   48,  381,
 /*  1750 */     0,  383,    0,   59,   59,   48,    0,   22,  414,   22,
 /*  1760 */     0,   14,  418,  177,    0,  421,  422,  423,  424,  425,
 /*  1770 */   426,   44,  428,    0,    0,    0,    0,   35,  333,  435,
 /*  1780 */     0,    0,  414,  439,  440,   39,  418,   39,  343,  421,
 /*  1790 */   422,  423,  424,  425,  426,   42,  428,   39,   47,   40,
 /*  1800 */     0,  333,   47,  435,   47,    0,   35,  439,  440,   39,
 /*  1810 */    49,  343,    0,   35,  369,   66,   49,    0,   39,   35,
 /*  1820 */     0,   49,   39,   35,  333,   39,  381,    0,  383,    0,
 /*  1830 */     0,   49,    0,   35,  343,   22,    0,  369,   35,   35,
 /*  1840 */    44,   35,   35,   35,   35,   35,   44,  333,   22,  381,
 /*  1850 */    35,  383,    0,   35,   35,   22,    0,  343,    0,  414,
 /*  1860 */   369,  107,   22,  418,   22,   51,  421,  422,  423,  424,
 /*  1870 */   425,  426,  381,  428,  383,  109,   35,    0,   35,    0,
 /*  1880 */   435,   35,  414,  369,  439,  440,  418,    0,   22,  421,
 /*  1890 */   422,  423,  424,  425,  426,  381,  428,  383,   20,   35,
 /*  1900 */    35,  100,   35,  435,    0,  414,  193,   35,  440,  418,
 /*  1910 */   333,  100,  421,  422,  423,  424,  425,  426,   22,  428,
 /*  1920 */   343,    0,  101,   22,    0,    0,    3,   44,  414,  101,
 /*  1930 */   168,  256,  418,   48,  100,  421,  422,  423,  424,  425,
 /*  1940 */   426,   48,  428,  175,  100,  168,  369,   98,  101,   96,
 /*  1950 */    44,  374,   44,  168,  189,  464,  101,  100,  381,  170,
 /*  1960 */   383,  100,  100,   44,  101,   47,  256,    3,  100,   47,
 /*  1970 */    44,  101,  101,   44,   35,  333,   35,   35,   35,   35,
 /*  1980 */    35,  101,  101,    0,   47,  343,    0,  473,    0,    0,
 /*  1990 */    44,  414,  100,   39,   47,  418,  333,   47,  421,  422,
 /*  2000 */   423,  424,  425,  426,  101,  428,  343,  100,  171,  333,
 /*  2010 */   101,  369,  100,  100,  100,    0,   39,  169,   47,  343,
 /*  2020 */   110,    2,   44,  381,   22,  383,   98,  100,   98,  237,
 /*  2030 */    22,  215,  369,  100,   47,  101,  101,  374,  100,   47,
 /*  2040 */   250,  101,  217,  111,  381,  369,  383,  256,  100,  100,
 /*  2050 */   374,  100,   35,  101,  101,  100,  414,  381,   35,  383,
 /*  2060 */   418,    1,  100,  421,  422,  423,  424,  425,  426,  101,
 /*  2070 */   428,   35,  430,  100,   35,  101,  100,  414,   35,   19,
 /*  2080 */   101,  418,  100,   35,  421,  422,  423,  424,  425,  426,
 /*  2090 */   414,  428,  101,   33,  418,  100,  333,  421,  422,  423,
 /*  2100 */   424,  425,  426,  122,  428,  100,  343,  122,   44,   49,
 /*  2110 */   100,   35,  122,  100,   22,   55,   56,   57,   58,   59,
 /*  2120 */   333,  122,   66,   65,   35,   35,   35,   72,   35,   35,
 /*  2130 */   343,   35,  369,   35,   35,   35,   35,   35,   94,   44,
 /*  2140 */    35,   35,   22,   35,  381,   35,  383,   35,   35,   72,
 /*  2150 */    35,   35,   22,   35,   35,    0,  369,   35,   35,   99,
 /*  2160 */    49,    0,  102,   39,   35,   39,    0,   35,  381,    0,
 /*  2170 */   383,   35,    0,   39,   49,   35,   49,  414,   39,   35,
 /*  2180 */    49,  418,    0,  333,  421,  422,  423,  424,  425,  426,
 /*  2190 */    22,  428,   21,  343,  134,   22,   22,   21,   20,  476,
 /*  2200 */   476,  414,  476,  476,  476,  418,  476,  333,  421,  422,
 /*  2210 */   423,  424,  425,  426,  476,  428,  476,  343,  476,  369,
 /*  2220 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  169,
 /*  2230 */   476,  381,  476,  383,  174,  476,  476,  476,  476,  476,
 /*  2240 */   476,  476,  476,  369,  476,  476,  476,  476,  476,  476,
 /*  2250 */   476,  476,  476,  333,  194,  381,  476,  383,  476,  476,
 /*  2260 */   476,  476,  476,  343,  414,  476,  476,  476,  418,  333,
 /*  2270 */   476,  421,  422,  423,  424,  425,  426,  476,  428,  343,
 /*  2280 */   476,  476,  476,  476,  476,  476,  476,  476,  414,  369,
 /*  2290 */   476,  476,  418,  476,  476,  421,  422,  423,  424,  425,
 /*  2300 */   426,  381,  428,  383,  476,  369,  476,  476,  476,  476,
 /*  2310 */   476,  476,  476,  476,  476,  476,  476,  381,  476,  383,
 /*  2320 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  333,
 /*  2330 */   476,  476,  476,  476,  414,  476,  476,  476,  418,  343,
 /*  2340 */   476,  421,  422,  423,  424,  425,  426,  476,  428,  476,
 /*  2350 */   414,  476,  476,  333,  418,  476,  476,  421,  422,  423,
 /*  2360 */   424,  425,  426,  343,  428,  369,  476,  476,  476,  476,
 /*  2370 */   476,  476,  476,  476,  476,  476,  476,  381,  476,  383,
 /*  2380 */   333,  476,  476,  476,  476,  476,  476,  476,  476,  369,
 /*  2390 */   343,  476,  476,  476,  476,  476,  476,  476,  476,  333,
 /*  2400 */   476,  381,  476,  383,  476,  476,  476,  476,  476,  343,
 /*  2410 */   414,  476,  476,  476,  418,  476,  369,  421,  422,  423,
 /*  2420 */   424,  425,  426,  476,  428,  476,  476,  476,  381,  476,
 /*  2430 */   383,  476,  476,  476,  414,  369,  476,  476,  418,  476,
 /*  2440 */   476,  421,  422,  423,  424,  425,  426,  381,  428,  383,
 /*  2450 */   333,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2460 */   343,  414,  476,  476,  476,  418,  333,  476,  421,  422,
 /*  2470 */   423,  424,  425,  426,  476,  428,  343,  476,  476,  476,
 /*  2480 */   414,  476,  476,  476,  418,  476,  369,  421,  422,  423,
 /*  2490 */   424,  425,  426,  476,  428,  476,  333,  476,  381,  476,
 /*  2500 */   383,  476,  369,  476,  476,  476,  343,  476,  476,  476,
 /*  2510 */   476,  476,  476,  476,  381,  476,  383,  333,  476,  476,
 /*  2520 */   476,  476,  476,  476,  476,  476,  476,  343,  476,  476,
 /*  2530 */   476,  414,  369,  476,  476,  418,  476,  476,  421,  422,
 /*  2540 */   423,  424,  425,  426,  381,  428,  383,  414,  476,  476,
 /*  2550 */   476,  418,  476,  369,  421,  422,  423,  424,  425,  426,
 /*  2560 */   476,  428,  476,  333,  476,  381,  476,  383,  476,  476,
 /*  2570 */   476,  476,  476,  343,  476,  476,  476,  414,  476,  476,
 /*  2580 */   476,  418,  476,  476,  421,  422,  423,  424,  425,  426,
 /*  2590 */   476,  428,  476,  476,  476,  476,  476,  476,  414,  369,
 /*  2600 */   476,  476,  418,  476,  476,  421,  422,  423,  424,  425,
 /*  2610 */   426,  381,  428,  383,  476,  476,  476,  476,  476,  476,
 /*  2620 */   476,  476,  476,  333,  476,  476,  476,  476,  476,  476,
 /*  2630 */   476,  476,  476,  343,  476,  476,  333,  476,  476,  476,
 /*  2640 */   476,  476,  476,  476,  414,  476,  343,  476,  418,  476,
 /*  2650 */   476,  421,  422,  423,  424,  425,  426,  476,  428,  369,
 /*  2660 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2670 */   476,  381,  369,  383,  476,  476,  476,  476,  476,  476,
 /*  2680 */   476,  476,  476,  476,  381,  476,  383,  333,  476,  476,
 /*  2690 */   476,  476,  476,  476,  476,  476,  476,  343,  476,  476,
 /*  2700 */   476,  476,  476,  476,  414,  476,  476,  476,  418,  476,
 /*  2710 */   476,  421,  422,  423,  424,  425,  426,  414,  428,  476,
 /*  2720 */   476,  418,  476,  369,  421,  422,  423,  424,  425,  426,
 /*  2730 */   476,  428,  476,  333,  476,  381,  476,  383,  476,  476,
 /*  2740 */   476,  476,  476,  343,  476,  476,  476,  476,  333,  476,
 /*  2750 */   476,  476,  476,  476,  476,  476,  476,  476,  343,  476,
 /*  2760 */   476,  476,  476,  476,  476,  476,  476,  476,  414,  369,
 /*  2770 */   476,  476,  418,  476,  476,  421,  422,  423,  424,  425,
 /*  2780 */   426,  381,  428,  383,  369,  476,  476,  476,  476,  476,
 /*  2790 */   476,  476,  476,  476,  333,  476,  381,  476,  383,  476,
 /*  2800 */   476,  476,  476,  476,  343,  476,  476,  476,  476,  333,
 /*  2810 */   476,  476,  476,  476,  414,  476,  476,  476,  418,  343,
 /*  2820 */   476,  421,  422,  423,  424,  425,  426,  476,  428,  414,
 /*  2830 */   369,  476,  476,  418,  476,  476,  421,  422,  423,  424,
 /*  2840 */   425,  426,  381,  428,  383,  369,  476,  476,  476,  476,
 /*  2850 */   476,  476,  476,  476,  476,  476,  476,  381,  476,  383,
 /*  2860 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2870 */   476,  476,  476,  476,  476,  414,  476,  476,  476,  418,
 /*  2880 */   476,  476,  421,  422,  423,  424,  425,  426,  476,  428,
 /*  2890 */   414,  476,  476,  476,  418,  476,  476,  421,  422,  423,
 /*  2900 */   424,  425,  426,  476,  428,
};
#define YY_SHIFT_COUNT    (761)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2182)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   550,    0,  224,    0,  449,  449,  449,  449,  449,  449,
 /*    10 */   449,  449,  449,  449,  449,  449,  673,  897,  897, 1121,
 /*    20 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*    30 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*    40 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  457,
 /*    50 */   492,  142,  145,  147,  107,  173,  107,  145,  145, 1347,
 /*    60 */  1347, 1347,  107, 1347, 1347,  501,  107,   18,  447,   47,
 /*    70 */    47,  447,  235,  235,    3,  286,    7,    7,   47,   47,
 /*    80 */    47,   47,   47,   47,   47,   51,   47,   47,  132,   18,
 /*    90 */    47,   47,  228,   47,   18,   47,   51,   47,   51,   18,
 /*   100 */    47,   47,   18,   47,   18,   18,   18,   47,  339,  223,
 /*   110 */   189,  189,  333,  114,  443,  443,  443,  443,  443,  443,
 /*   120 */   443,  443,  443,  443,  443,  443,  443,  443,  443,  443,
 /*   130 */   443,  443,  443,  843,  325,    3,  286,  392,  220,  220,
 /*   140 */   220,  417,  369,  369,  392,  344,  344,  344,  132,  365,
 /*   150 */   297,   18,  439,   18,  439,  439,  503,  558,   35,   35,
 /*   160 */    35,   35,   35,   35,   35,   35, 2060,  217,  288,  483,
 /*   170 */   522,  260,  313,  243,  384,  940,  576,  484,  890,  751,
 /*   180 */   528,  810,  824,   60,  974,  824, 1065,  791,  275, 1124,
 /*   190 */  1336, 1204, 1353, 1378, 1353, 1236, 1384, 1384, 1353, 1236,
 /*   200 */  1236, 1315, 1324, 1384, 1329, 1384, 1384, 1384, 1411, 1386,
 /*   210 */  1411, 1386, 1418,  132, 1421,  132, 1426, 1430,  132, 1426,
 /*   220 */   132,  132,  132, 1384,  132, 1413, 1413, 1411,   18,   18,
 /*   230 */    18,   18,   18,   18,   18,   18,   18,   18,   18, 1384,
 /*   240 */  1411,  439,  439,  439, 1292, 1398, 1418,  339, 1325, 1323,
 /*   250 */  1421,  339, 1330, 1384, 1378, 1378,  439, 1262, 1266,  439,
 /*   260 */  1262, 1266,  439,  439,   18, 1253, 1355, 1262, 1271, 1273,
 /*   270 */  1293, 1124, 1283, 1277, 1276, 1318,  344, 1550, 1384, 1426,
 /*   280 */   339,  339, 1566, 1266,  439,  439,  439,  439,  439, 1266,
 /*   290 */   439, 1427,  339,  503,  339,  344, 1504, 1508,  439,  558,
 /*   300 */  1384,  339, 1576, 1411, 2905, 2905, 2905, 2905, 2905, 2905,
 /*   310 */  2905, 2905, 2905,   34,  430,   15,  590,  734,   16,  839,
 /*   320 */    79,  709,  792,  566,  856, 1023, 1023, 1023, 1023, 1023,
 /*   330 */  1023, 1023, 1023, 1023, 1167,  743,  253,  253,  402,   57,
 /*   340 */   758,  774,  949, 1067,  800,  980,   64,   64,  959, 1007,
 /*   350 */   387,  959,  959,  959, 1149,  641, 1116, 1140, 1147, 1070,
 /*   360 */  1168, 1078, 1119, 1141, 1164,  532, 1190, 1207, 1250, 1251,
 /*   370 */   990, 1189, 1212,  868, 1216, 1231, 1233,  943, 1004, 1117,
 /*   380 */  1153, 1261, 1264, 1267, 1270, 1272, 1274, 1302, 1289, 1196,
 /*   390 */  1206,  987, 1291, 1238, 1286, 1317, 1320, 1322, 1326, 1328,
 /*   400 */   190, 1248, 1361, 1256, 1331, 1614, 1620, 1624, 1590, 1633,
 /*   410 */  1599, 1428, 1600, 1602, 1604, 1432, 1644, 1607, 1610, 1438,
 /*   420 */  1647, 1440, 1649, 1615, 1651, 1630, 1653, 1621, 1460, 1469,
 /*   430 */  1473, 1660, 1667, 1669, 1488, 1490, 1672, 1689, 1629, 1690,
 /*   440 */  1691, 1692, 1652, 1696, 1697, 1698, 1702, 1703, 1704, 1705,
 /*   450 */  1706, 1552, 1673, 1709, 1555, 1712, 1714, 1715, 1716, 1717,
 /*   460 */  1718, 1719, 1720, 1721, 1722, 1723, 1724, 1726, 1728, 1729,
 /*   470 */  1730, 1693, 1731, 1732, 1733, 1734, 1736, 1738, 1725, 1739,
 /*   480 */  1740, 1741, 1603, 1743, 1744, 1735, 1700, 1737, 1707, 1745,
 /*   490 */  1687, 1742, 1750, 1694, 1752, 1695, 1756, 1760, 1753, 1746,
 /*   500 */  1727, 1751, 1755, 1747, 1757, 1773, 1759, 1748, 1774, 1775,
 /*   510 */  1776, 1758, 1586, 1764, 1780, 1781, 1749, 1800, 1805, 1771,
 /*   520 */  1761, 1770, 1812, 1778, 1767, 1779, 1817, 1784, 1772, 1783,
 /*   530 */  1820, 1788, 1782, 1786, 1827, 1829, 1830, 1832, 1766, 1754,
 /*   540 */  1798, 1813, 1836, 1803, 1804, 1806, 1807, 1808, 1809, 1810,
 /*   550 */  1796, 1802, 1815, 1818, 1826, 1819, 1852, 1833, 1856, 1840,
 /*   560 */  1814, 1858, 1842, 1841, 1877, 1843, 1879, 1846, 1887, 1866,
 /*   570 */  1878, 1864, 1865, 1867, 1821, 1801, 1904, 1762, 1811, 1713,
 /*   580 */  1872, 1896, 1921, 1765, 1901, 1777, 1789, 1924, 1925, 1785,
 /*   590 */  1768, 1923, 1883, 1675, 1834, 1828, 1844, 1885, 1849, 1893,
 /*   600 */  1853, 1847, 1906, 1908, 1855, 1857, 1861, 1862, 1863, 1919,
 /*   610 */  1918, 1922, 1868, 1926, 1710, 1870, 1871, 1964, 1929, 1791,
 /*   620 */  1939, 1941, 1942, 1943, 1944, 1945, 1880, 1881, 1937, 1790,
 /*   630 */  1946, 1947, 1983, 1986, 1988, 1989, 1892, 1954, 1751, 1950,
 /*   640 */  1907, 1903, 1909, 1912, 1913, 1837, 1914, 2015, 1977, 1848,
 /*   650 */  1927, 1910, 1751, 1971, 1978, 1928, 1792, 1930, 2019, 2002,
 /*   660 */  1816, 1933, 1934, 1938, 1935, 1948, 1940, 1987, 1949, 1951,
 /*   670 */  1992, 1952, 2008, 1825, 1955, 1932, 1953, 2017, 2023, 1962,
 /*   680 */  1968, 2036, 1973, 1974, 2039, 1976, 1979, 2043, 1982, 1991,
 /*   690 */  2048, 1995, 1981, 1985, 1990, 1999, 2005, 2064, 2010, 2076,
 /*   700 */  2013, 2064, 2064, 2092, 2056, 2058, 2089, 2090, 2091, 2093,
 /*   710 */  2094, 2096, 2098, 2099, 2100, 2101, 2055, 2044, 2095, 2102,
 /*   720 */  2105, 2106, 2120, 2108, 2110, 2112, 2077, 1796, 2113, 1802,
 /*   730 */  2115, 2116, 2118, 2119, 2130, 2122, 2155, 2123, 2111, 2124,
 /*   740 */  2161, 2129, 2125, 2126, 2166, 2132, 2127, 2134, 2169, 2136,
 /*   750 */  2131, 2139, 2172, 2140, 2144, 2182, 2168, 2171, 2173, 2174,
 /*   760 */  2176, 2178,
};
#define YY_REDUCE_COUNT (312)
#define YY_REDUCE_MIN   (-396)
#define YY_REDUCE_MAX   (2476)
static const short yy_reduce_ofst[] = {
 /*     0 */  -140,  137,  -82,  358,  444,  578,  814,  841, 1034, 1064,
 /*    10 */  1132, 1240, 1260, 1344, 1368, 1445,  598, -333,  672, 1468,
 /*    20 */   901, 1491, 1514, 1577, 1642, 1663, 1676, 1763, 1787, 1850,
 /*    30 */  1874, 1920, 1936, 1996, 2020, 2047, 2066, 2117, 2133, 2163,
 /*    40 */  2184, 2230, 2290, 2303, 2354, 2400, 2415, 2461, 2476,  372,
 /*    50 */  -195, -396, -265,  487,  595,  607,  701,  481,  761, -362,
 /*    60 */  -355,  285,  749,  136,  612, -279,  -55,  256, -346, -167,
 /*    70 */    -5, -381, -334, -257, -205, -249,   45,  130,  300,  303,
 /*    80 */   356,  377,  409,  425,  432,  177,  469,  489,  252, -308,
 /*    90 */   521,  573,  170,  620,  172,  622,  261,  707,  396,  682,
 /*   100 */   739,  745,  278,  793,  715,  321,  781,  795, -266,    8,
 /*   110 */  -350, -350,  115, -238,  161,  214,  257,  315,  374,  433,
 /*   120 */   445,  463,  585,  587,  617,  677,  681,  806,  807,  813,
 /*   130 */   819,  830,  832,  -86, -289, -111,   23,  154, -289,   70,
 /*   140 */   188,  -25,  480,  511,  380,  416,  498,  704,  381, -354,
 /*   150 */   426,  513,  690,  502,  733,  798,  808,  353, -369, -365,
 /*   160 */   324,  370,  458,  505,  686,  458,  764,  368,  621,  825,
 /*   170 */   753,  780,  906,  822,  917,  917,  946,  898,  954,  963,
 /*   180 */   930,  921,  871,  871,  891,  871,  916,  925,  917,  967,
 /*   190 */   971,  989, 1001, 1008, 1012, 1016, 1063, 1066, 1022, 1025,
 /*   200 */  1026, 1060, 1069, 1074, 1073, 1084, 1086, 1088, 1097, 1096,
 /*   210 */  1101, 1098, 1030, 1090, 1059, 1093, 1105, 1050, 1103, 1110,
 /*   220 */  1111, 1113, 1114, 1126, 1120, 1125, 1129, 1136, 1108, 1112,
 /*   230 */  1115, 1122, 1127, 1131, 1133, 1137, 1138, 1139, 1142, 1151,
 /*   240 */  1144, 1099, 1102, 1128, 1081, 1094, 1107, 1162, 1104, 1118,
 /*   250 */  1135, 1171, 1123, 1179, 1143, 1145, 1146, 1068, 1134, 1150,
 /*   260 */  1072, 1148, 1156, 1157,  917, 1080, 1082, 1085, 1092, 1091,
 /*   270 */  1106, 1152, 1076, 1095, 1130,  871, 1223, 1154, 1242, 1241,
 /*   280 */  1234, 1239, 1194, 1193, 1209, 1210, 1211, 1213, 1214, 1200,
 /*   290 */  1218, 1208, 1252, 1237, 1257, 1263, 1169, 1243, 1229, 1254,
 /*   300 */  1269, 1278, 1279, 1282, 1215, 1217, 1222, 1225, 1265, 1268,
 /*   310 */  1275, 1281, 1294,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*    10 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*    20 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*    30 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*    40 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*    50 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*    60 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*    70 */  1719, 1719, 1719, 1719, 1992, 1719, 1719, 1719, 1719, 1719,
 /*    80 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1801, 1719,
 /*    90 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   100 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1799, 1985,
 /*   110 */  2206, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   120 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   130 */  1719, 1719, 1719, 1719, 2218, 1719, 1719, 1719, 2218, 2218,
 /*   140 */  2218, 1799, 2178, 2178, 1719, 1719, 1719, 1719, 1801, 2050,
 /*   150 */  1719, 1719, 1719, 1719, 1719, 1719, 1920, 1719, 1719, 1719,
 /*   160 */  1719, 1719, 1944, 1719, 1719, 1719, 2044, 1719, 1719, 2243,
 /*   170 */  2299, 1719, 1719, 2246, 1719, 1719, 1719, 1997, 1719, 1719,
 /*   180 */  1874, 2233, 2210, 2224, 2283, 2211, 2208, 2227, 1719, 2237,
 /*   190 */  1719, 2031, 1990, 1719, 1990, 1987, 1719, 1719, 1990, 1987,
 /*   200 */  1987, 1863, 1859, 1719, 1857, 1719, 1719, 1719, 1719, 1766,
 /*   210 */  1719, 1766, 1719, 1801, 1719, 1801, 1719, 1719, 1801, 1719,
 /*   220 */  1801, 1801, 1801, 1719, 1801, 1779, 1779, 1719, 1719, 1719,
 /*   230 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   240 */  1719, 1719, 1719, 1719, 2062, 2048, 1719, 1799, 2042, 2040,
 /*   250 */  1719, 1799, 2038, 1719, 1719, 1719, 1719, 2254, 2252, 1719,
 /*   260 */  2254, 2252, 1719, 1719, 1719, 2268, 2264, 2254, 2272, 2270,
 /*   270 */  2239, 2237, 2302, 2289, 2285, 2224, 1719, 1719, 1719, 1719,
 /*   280 */  1799, 1799, 1719, 2252, 1719, 1719, 1719, 1719, 1719, 2252,
 /*   290 */  1719, 1719, 1799, 1719, 1799, 1719, 1719, 1890, 1719, 1719,
 /*   300 */  1719, 1799, 1751, 1719, 2033, 2053, 2015, 2015, 1923, 1923,
 /*   310 */  1923, 1802, 1724, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   320 */  1719, 1719, 1719, 1719, 1719, 2267, 2266, 2133, 1719, 2182,
 /*   330 */  2181, 2180, 2171, 2132, 1886, 1719, 2131, 2130, 1719, 1719,
 /*   340 */  1719, 1719, 1719, 1719, 1719, 1719, 2006, 2005, 2124, 1719,
 /*   350 */  1719, 2125, 2123, 2122, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   360 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   370 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 2286, 2290,
 /*   380 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 2207, 1719, 1719,
 /*   390 */  1719, 1719, 1719, 2106, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   400 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   410 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   420 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   430 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   440 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   450 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   460 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   470 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   480 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   490 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   500 */  1756, 2111, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   510 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   520 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   530 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   540 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   550 */  1840, 1839, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   560 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   570 */  1719, 1719, 1719, 1719, 2115, 1719, 1719, 1719, 1719, 1719,
 /*   580 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   590 */  1719, 2282, 2240, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   600 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   610 */  1719, 2106, 1719, 2265, 1719, 1719, 2280, 1719, 2284, 1719,
 /*   620 */  1719, 1719, 1719, 1719, 1719, 1719, 2217, 2213, 1719, 1719,
 /*   630 */  2209, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 2114, 1719,
 /*   640 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   650 */  1719, 1719, 2105, 1719, 2168, 1719, 1719, 1719, 2202, 1719,
 /*   660 */  1719, 2153, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   670 */  1719, 2115, 1719, 2118, 1719, 1719, 1719, 1719, 1719, 1917,
 /*   680 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   690 */  1719, 1719, 1902, 1900, 1899, 1898, 1719, 1930, 1719, 1719,
 /*   700 */  1719, 1926, 1925, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   710 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1820, 1719,
 /*   720 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1812, 1719, 1811,
 /*   730 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   740 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   750 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   760 */  1719, 1719,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*       WITH => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*  TIMESTAMP => nothing */
  279,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*   LANGUAGE => nothing */
    0,  /*    REPLACE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*     LEADER => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  279,  /*      AFTER => ABORT */
  279,  /*     ATTACH => ABORT */
  279,  /*     BEFORE => ABORT */
  279,  /*      BEGIN => ABORT */
  279,  /*     BITAND => ABORT */
  279,  /*     BITNOT => ABORT */
  279,  /*      BITOR => ABORT */
  279,  /*     BLOCKS => ABORT */
  279,  /*     CHANGE => ABORT */
  279,  /*      COMMA => ABORT */
  279,  /*     CONCAT => ABORT */
  279,  /*   CONFLICT => ABORT */
  279,  /*       COPY => ABORT */
  279,  /*   DEFERRED => ABORT */
  279,  /* DELIMITERS => ABORT */
  279,  /*     DETACH => ABORT */
  279,  /*     DIVIDE => ABORT */
  279,  /*        DOT => ABORT */
  279,  /*       EACH => ABORT */
  279,  /*       FAIL => ABORT */
  279,  /*       FILE => ABORT */
  279,  /*        FOR => ABORT */
  279,  /*       GLOB => ABORT */
  279,  /*         ID => ABORT */
  279,  /*  IMMEDIATE => ABORT */
  279,  /*     IMPORT => ABORT */
  279,  /*  INITIALLY => ABORT */
  279,  /*    INSTEAD => ABORT */
  279,  /*     ISNULL => ABORT */
  279,  /*        KEY => ABORT */
  279,  /*    MODULES => ABORT */
  279,  /*  NK_BITNOT => ABORT */
  279,  /*    NK_SEMI => ABORT */
  279,  /*    NOTNULL => ABORT */
  279,  /*         OF => ABORT */
  279,  /*       PLUS => ABORT */
  279,  /*  PRIVILEGE => ABORT */
  279,  /*      RAISE => ABORT */
  279,  /*   RESTRICT => ABORT */
  279,  /*        ROW => ABORT */
  279,  /*       SEMI => ABORT */
  279,  /*       STAR => ABORT */
  279,  /*  STATEMENT => ABORT */
  279,  /*     STRICT => ABORT */
  279,  /*     STRING => ABORT */
  279,  /*      TIMES => ABORT */
  279,  /*     VALUES => ABORT */
  279,  /*   VARIABLE => ABORT */
  279,  /*       VIEW => ABORT */
  279,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "WITH",
  /*   49 */ "DNODE",
  /*   50 */ "PORT",
  /*   51 */ "DNODES",
  /*   52 */ "NK_IPTOKEN",
  /*   53 */ "FORCE",
  /*   54 */ "LOCAL",
  /*   55 */ "QNODE",
  /*   56 */ "BNODE",
  /*   57 */ "SNODE",
  /*   58 */ "MNODE",
  /*   59 */ "DATABASE",
  /*   60 */ "USE",
  /*   61 */ "FLUSH",
  /*   62 */ "TRIM",
  /*   63 */ "COMPACT",
  /*   64 */ "IF",
  /*   65 */ "NOT",
  /*   66 */ "EXISTS",
  /*   67 */ "BUFFER",
  /*   68 */ "CACHEMODEL",
  /*   69 */ "CACHESIZE",
  /*   70 */ "COMP",
  /*   71 */ "DURATION",
  /*   72 */ "NK_VARIABLE",
  /*   73 */ "MAXROWS",
  /*   74 */ "MINROWS",
  /*   75 */ "KEEP",
  /*   76 */ "PAGES",
  /*   77 */ "PAGESIZE",
  /*   78 */ "TSDB_PAGESIZE",
  /*   79 */ "PRECISION",
  /*   80 */ "REPLICA",
  /*   81 */ "VGROUPS",
  /*   82 */ "SINGLE_STABLE",
  /*   83 */ "RETENTIONS",
  /*   84 */ "SCHEMALESS",
  /*   85 */ "WAL_LEVEL",
  /*   86 */ "WAL_FSYNC_PERIOD",
  /*   87 */ "WAL_RETENTION_PERIOD",
  /*   88 */ "WAL_RETENTION_SIZE",
  /*   89 */ "WAL_ROLL_PERIOD",
  /*   90 */ "WAL_SEGMENT_SIZE",
  /*   91 */ "STT_TRIGGER",
  /*   92 */ "TABLE_PREFIX",
  /*   93 */ "TABLE_SUFFIX",
  /*   94 */ "NK_COLON",
  /*   95 */ "MAX_SPEED",
  /*   96 */ "START",
  /*   97 */ "TIMESTAMP",
  /*   98 */ "END",
  /*   99 */ "TABLE",
  /*  100 */ "NK_LP",
  /*  101 */ "NK_RP",
  /*  102 */ "STABLE",
  /*  103 */ "ADD",
  /*  104 */ "COLUMN",
  /*  105 */ "MODIFY",
  /*  106 */ "RENAME",
  /*  107 */ "TAG",
  /*  108 */ "SET",
  /*  109 */ "NK_EQ",
  /*  110 */ "USING",
  /*  111 */ "TAGS",
  /*  112 */ "BOOL",
  /*  113 */ "TINYINT",
  /*  114 */ "SMALLINT",
  /*  115 */ "INT",
  /*  116 */ "INTEGER",
  /*  117 */ "BIGINT",
  /*  118 */ "FLOAT",
  /*  119 */ "DOUBLE",
  /*  120 */ "BINARY",
  /*  121 */ "NCHAR",
  /*  122 */ "UNSIGNED",
  /*  123 */ "JSON",
  /*  124 */ "VARCHAR",
  /*  125 */ "MEDIUMBLOB",
  /*  126 */ "BLOB",
  /*  127 */ "VARBINARY",
  /*  128 */ "DECIMAL",
  /*  129 */ "COMMENT",
  /*  130 */ "MAX_DELAY",
  /*  131 */ "WATERMARK",
  /*  132 */ "ROLLUP",
  /*  133 */ "TTL",
  /*  134 */ "SMA",
  /*  135 */ "DELETE_MARK",
  /*  136 */ "FIRST",
  /*  137 */ "LAST",
  /*  138 */ "SHOW",
  /*  139 */ "PRIVILEGES",
  /*  140 */ "DATABASES",
  /*  141 */ "TABLES",
  /*  142 */ "STABLES",
  /*  143 */ "MNODES",
  /*  144 */ "QNODES",
  /*  145 */ "FUNCTIONS",
  /*  146 */ "INDEXES",
  /*  147 */ "ACCOUNTS",
  /*  148 */ "APPS",
  /*  149 */ "CONNECTIONS",
  /*  150 */ "LICENCES",
  /*  151 */ "GRANTS",
  /*  152 */ "QUERIES",
  /*  153 */ "SCORES",
  /*  154 */ "TOPICS",
  /*  155 */ "VARIABLES",
  /*  156 */ "CLUSTER",
  /*  157 */ "BNODES",
  /*  158 */ "SNODES",
  /*  159 */ "TRANSACTIONS",
  /*  160 */ "DISTRIBUTED",
  /*  161 */ "CONSUMERS",
  /*  162 */ "SUBSCRIPTIONS",
  /*  163 */ "VNODES",
  /*  164 */ "ALIVE",
  /*  165 */ "LIKE",
  /*  166 */ "TBNAME",
  /*  167 */ "QTAGS",
  /*  168 */ "AS",
  /*  169 */ "INDEX",
  /*  170 */ "FUNCTION",
  /*  171 */ "INTERVAL",
  /*  172 */ "COUNT",
  /*  173 */ "LAST_ROW",
  /*  174 */ "TOPIC",
  /*  175 */ "META",
  /*  176 */ "CONSUMER",
  /*  177 */ "GROUP",
  /*  178 */ "DESC",
  /*  179 */ "DESCRIBE",
  /*  180 */ "RESET",
  /*  181 */ "QUERY",
  /*  182 */ "CACHE",
  /*  183 */ "EXPLAIN",
  /*  184 */ "ANALYZE",
  /*  185 */ "VERBOSE",
  /*  186 */ "NK_BOOL",
  /*  187 */ "RATIO",
  /*  188 */ "NK_FLOAT",
  /*  189 */ "OUTPUTTYPE",
  /*  190 */ "AGGREGATE",
  /*  191 */ "BUFSIZE",
  /*  192 */ "LANGUAGE",
  /*  193 */ "REPLACE",
  /*  194 */ "STREAM",
  /*  195 */ "INTO",
  /*  196 */ "TRIGGER",
  /*  197 */ "AT_ONCE",
  /*  198 */ "WINDOW_CLOSE",
  /*  199 */ "IGNORE",
  /*  200 */ "EXPIRED",
  /*  201 */ "FILL_HISTORY",
  /*  202 */ "UPDATE",
  /*  203 */ "SUBTABLE",
  /*  204 */ "KILL",
  /*  205 */ "CONNECTION",
  /*  206 */ "TRANSACTION",
  /*  207 */ "BALANCE",
  /*  208 */ "VGROUP",
  /*  209 */ "LEADER",
  /*  210 */ "MERGE",
  /*  211 */ "REDISTRIBUTE",
  /*  212 */ "SPLIT",
  /*  213 */ "DELETE",
  /*  214 */ "INSERT",
  /*  215 */ "NULL",
  /*  216 */ "NK_QUESTION",
  /*  217 */ "NK_ARROW",
  /*  218 */ "ROWTS",
  /*  219 */ "QSTART",
  /*  220 */ "QEND",
  /*  221 */ "QDURATION",
  /*  222 */ "WSTART",
  /*  223 */ "WEND",
  /*  224 */ "WDURATION",
  /*  225 */ "IROWTS",
  /*  226 */ "ISFILLED",
  /*  227 */ "CAST",
  /*  228 */ "NOW",
  /*  229 */ "TODAY",
  /*  230 */ "TIMEZONE",
  /*  231 */ "CLIENT_VERSION",
  /*  232 */ "SERVER_VERSION",
  /*  233 */ "SERVER_STATUS",
  /*  234 */ "CURRENT_USER",
  /*  235 */ "CASE",
  /*  236 */ "WHEN",
  /*  237 */ "THEN",
  /*  238 */ "ELSE",
  /*  239 */ "BETWEEN",
  /*  240 */ "IS",
  /*  241 */ "NK_LT",
  /*  242 */ "NK_GT",
  /*  243 */ "NK_LE",
  /*  244 */ "NK_GE",
  /*  245 */ "NK_NE",
  /*  246 */ "MATCH",
  /*  247 */ "NMATCH",
  /*  248 */ "CONTAINS",
  /*  249 */ "IN",
  /*  250 */ "JOIN",
  /*  251 */ "INNER",
  /*  252 */ "SELECT",
  /*  253 */ "DISTINCT",
  /*  254 */ "WHERE",
  /*  255 */ "PARTITION",
  /*  256 */ "BY",
  /*  257 */ "SESSION",
  /*  258 */ "STATE_WINDOW",
  /*  259 */ "EVENT_WINDOW",
  /*  260 */ "SLIDING",
  /*  261 */ "FILL",
  /*  262 */ "VALUE",
  /*  263 */ "VALUE_F",
  /*  264 */ "NONE",
  /*  265 */ "PREV",
  /*  266 */ "NULL_F",
  /*  267 */ "LINEAR",
  /*  268 */ "NEXT",
  /*  269 */ "HAVING",
  /*  270 */ "RANGE",
  /*  271 */ "EVERY",
  /*  272 */ "ORDER",
  /*  273 */ "SLIMIT",
  /*  274 */ "SOFFSET",
  /*  275 */ "LIMIT",
  /*  276 */ "OFFSET",
  /*  277 */ "ASC",
  /*  278 */ "NULLS",
  /*  279 */ "ABORT",
  /*  280 */ "AFTER",
  /*  281 */ "ATTACH",
  /*  282 */ "BEFORE",
  /*  283 */ "BEGIN",
  /*  284 */ "BITAND",
  /*  285 */ "BITNOT",
  /*  286 */ "BITOR",
  /*  287 */ "BLOCKS",
  /*  288 */ "CHANGE",
  /*  289 */ "COMMA",
  /*  290 */ "CONCAT",
  /*  291 */ "CONFLICT",
  /*  292 */ "COPY",
  /*  293 */ "DEFERRED",
  /*  294 */ "DELIMITERS",
  /*  295 */ "DETACH",
  /*  296 */ "DIVIDE",
  /*  297 */ "DOT",
  /*  298 */ "EACH",
  /*  299 */ "FAIL",
  /*  300 */ "FILE",
  /*  301 */ "FOR",
  /*  302 */ "GLOB",
  /*  303 */ "ID",
  /*  304 */ "IMMEDIATE",
  /*  305 */ "IMPORT",
  /*  306 */ "INITIALLY",
  /*  307 */ "INSTEAD",
  /*  308 */ "ISNULL",
  /*  309 */ "KEY",
  /*  310 */ "MODULES",
  /*  311 */ "NK_BITNOT",
  /*  312 */ "NK_SEMI",
  /*  313 */ "NOTNULL",
  /*  314 */ "OF",
  /*  315 */ "PLUS",
  /*  316 */ "PRIVILEGE",
  /*  317 */ "RAISE",
  /*  318 */ "RESTRICT",
  /*  319 */ "ROW",
  /*  320 */ "SEMI",
  /*  321 */ "STAR",
  /*  322 */ "STATEMENT",
  /*  323 */ "STRICT",
  /*  324 */ "STRING",
  /*  325 */ "TIMES",
  /*  326 */ "VALUES",
  /*  327 */ "VARIABLE",
  /*  328 */ "VIEW",
  /*  329 */ "WAL",
  /*  330 */ "cmd",
  /*  331 */ "account_options",
  /*  332 */ "alter_account_options",
  /*  333 */ "literal",
  /*  334 */ "alter_account_option",
  /*  335 */ "user_name",
  /*  336 */ "sysinfo_opt",
  /*  337 */ "privileges",
  /*  338 */ "priv_level",
  /*  339 */ "with_opt",
  /*  340 */ "priv_type_list",
  /*  341 */ "priv_type",
  /*  342 */ "db_name",
  /*  343 */ "table_name",
  /*  344 */ "topic_name",
  /*  345 */ "search_condition",
  /*  346 */ "dnode_endpoint",
  /*  347 */ "force_opt",
  /*  348 */ "not_exists_opt",
  /*  349 */ "db_options",
  /*  350 */ "exists_opt",
  /*  351 */ "alter_db_options",
  /*  352 */ "speed_opt",
  /*  353 */ "start_opt",
  /*  354 */ "end_opt",
  /*  355 */ "integer_list",
  /*  356 */ "variable_list",
  /*  357 */ "retention_list",
  /*  358 */ "alter_db_option",
  /*  359 */ "retention",
  /*  360 */ "full_table_name",
  /*  361 */ "column_def_list",
  /*  362 */ "tags_def_opt",
  /*  363 */ "table_options",
  /*  364 */ "multi_create_clause",
  /*  365 */ "tags_def",
  /*  366 */ "multi_drop_clause",
  /*  367 */ "alter_table_clause",
  /*  368 */ "alter_table_options",
  /*  369 */ "column_name",
  /*  370 */ "type_name",
  /*  371 */ "signed_literal",
  /*  372 */ "create_subtable_clause",
  /*  373 */ "specific_cols_opt",
  /*  374 */ "expression_list",
  /*  375 */ "drop_table_clause",
  /*  376 */ "col_name_list",
  /*  377 */ "column_def",
  /*  378 */ "duration_list",
  /*  379 */ "rollup_func_list",
  /*  380 */ "alter_table_option",
  /*  381 */ "duration_literal",
  /*  382 */ "rollup_func_name",
  /*  383 */ "function_name",
  /*  384 */ "col_name",
  /*  385 */ "db_name_cond_opt",
  /*  386 */ "like_pattern_opt",
  /*  387 */ "table_name_cond",
  /*  388 */ "from_db_opt",
  /*  389 */ "tag_list_opt",
  /*  390 */ "tag_item",
  /*  391 */ "column_alias",
  /*  392 */ "full_index_name",
  /*  393 */ "index_options",
  /*  394 */ "index_name",
  /*  395 */ "func_list",
  /*  396 */ "sliding_opt",
  /*  397 */ "sma_stream_opt",
  /*  398 */ "func",
  /*  399 */ "sma_func_name",
  /*  400 */ "query_or_subquery",
  /*  401 */ "cgroup_name",
  /*  402 */ "analyze_opt",
  /*  403 */ "explain_options",
  /*  404 */ "insert_query",
  /*  405 */ "or_replace_opt",
  /*  406 */ "agg_func_opt",
  /*  407 */ "bufsize_opt",
  /*  408 */ "language_opt",
  /*  409 */ "stream_name",
  /*  410 */ "stream_options",
  /*  411 */ "col_list_opt",
  /*  412 */ "tag_def_or_ref_opt",
  /*  413 */ "subtable_opt",
  /*  414 */ "expression",
  /*  415 */ "dnode_list",
  /*  416 */ "where_clause_opt",
  /*  417 */ "signed",
  /*  418 */ "literal_func",
  /*  419 */ "literal_list",
  /*  420 */ "table_alias",
  /*  421 */ "expr_or_subquery",
  /*  422 */ "pseudo_column",
  /*  423 */ "column_reference",
  /*  424 */ "function_expression",
  /*  425 */ "case_when_expression",
  /*  426 */ "star_func",
  /*  427 */ "star_func_para_list",
  /*  428 */ "noarg_func",
  /*  429 */ "other_para_list",
  /*  430 */ "star_func_para",
  /*  431 */ "when_then_list",
  /*  432 */ "case_when_else_opt",
  /*  433 */ "common_expression",
  /*  434 */ "when_then_expr",
  /*  435 */ "predicate",
  /*  436 */ "compare_op",
  /*  437 */ "in_op",
  /*  438 */ "in_predicate_value",
  /*  439 */ "boolean_value_expression",
  /*  440 */ "boolean_primary",
  /*  441 */ "from_clause_opt",
  /*  442 */ "table_reference_list",
  /*  443 */ "table_reference",
  /*  444 */ "table_primary",
  /*  445 */ "joined_table",
  /*  446 */ "alias_opt",
  /*  447 */ "subquery",
  /*  448 */ "parenthesized_joined_table",
  /*  449 */ "join_type",
  /*  450 */ "query_specification",
  /*  451 */ "set_quantifier_opt",
  /*  452 */ "select_list",
  /*  453 */ "partition_by_clause_opt",
  /*  454 */ "range_opt",
  /*  455 */ "every_opt",
  /*  456 */ "fill_opt",
  /*  457 */ "twindow_clause_opt",
  /*  458 */ "group_by_clause_opt",
  /*  459 */ "having_clause_opt",
  /*  460 */ "select_item",
  /*  461 */ "partition_list",
  /*  462 */ "partition_item",
  /*  463 */ "fill_mode",
  /*  464 */ "group_by_list",
  /*  465 */ "query_expression",
  /*  466 */ "query_simple",
  /*  467 */ "order_by_clause_opt",
  /*  468 */ "slimit_clause_opt",
  /*  469 */ "limit_clause_opt",
  /*  470 */ "union_query_expression",
  /*  471 */ "query_simple_or_subquery",
  /*  472 */ "sort_specification_list",
  /*  473 */ "sort_specification",
  /*  474 */ "ordering_specification_opt",
  /*  475 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level with_opt TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= db_name NK_DOT table_name",
 /*  43 */ "priv_level ::= topic_name",
 /*  44 */ "with_opt ::=",
 /*  45 */ "with_opt ::= WITH search_condition",
 /*  46 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  47 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  48 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  49 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  50 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  51 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  52 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  53 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  54 */ "dnode_endpoint ::= NK_STRING",
 /*  55 */ "dnode_endpoint ::= NK_ID",
 /*  56 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  57 */ "force_opt ::=",
 /*  58 */ "force_opt ::= FORCE",
 /*  59 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  60 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  61 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  67 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  68 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  69 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  70 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  71 */ "cmd ::= USE db_name",
 /*  72 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  73 */ "cmd ::= FLUSH DATABASE db_name",
 /*  74 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  75 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  76 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  77 */ "not_exists_opt ::=",
 /*  78 */ "exists_opt ::= IF EXISTS",
 /*  79 */ "exists_opt ::=",
 /*  80 */ "db_options ::=",
 /*  81 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  82 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  83 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  84 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  85 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  86 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  87 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  88 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  89 */ "db_options ::= db_options KEEP integer_list",
 /*  90 */ "db_options ::= db_options KEEP variable_list",
 /*  91 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  92 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  93 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  94 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  95 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  96 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  97 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  98 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  99 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 106 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 107 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 108 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 109 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 110 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 111 */ "alter_db_options ::= alter_db_option",
 /* 112 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 113 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 114 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 115 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 116 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 117 */ "alter_db_option ::= KEEP integer_list",
 /* 118 */ "alter_db_option ::= KEEP variable_list",
 /* 119 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 120 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 121 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 122 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 123 */ "alter_db_option ::= MINROWS NK_INTEGER",
 /* 124 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER",
 /* 125 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 126 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER",
 /* 127 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 128 */ "integer_list ::= NK_INTEGER",
 /* 129 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 130 */ "variable_list ::= NK_VARIABLE",
 /* 131 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 132 */ "retention_list ::= retention",
 /* 133 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 134 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 135 */ "speed_opt ::=",
 /* 136 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 137 */ "start_opt ::=",
 /* 138 */ "start_opt ::= START WITH NK_INTEGER",
 /* 139 */ "start_opt ::= START WITH NK_STRING",
 /* 140 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 141 */ "end_opt ::=",
 /* 142 */ "end_opt ::= END WITH NK_INTEGER",
 /* 143 */ "end_opt ::= END WITH NK_STRING",
 /* 144 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 145 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 146 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 147 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 148 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 149 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 150 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 151 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 152 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 153 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 154 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 155 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 156 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 157 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 158 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 159 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 160 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 161 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 162 */ "multi_create_clause ::= create_subtable_clause",
 /* 163 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 164 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 165 */ "multi_drop_clause ::= drop_table_clause",
 /* 166 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 167 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 168 */ "specific_cols_opt ::=",
 /* 169 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 170 */ "full_table_name ::= table_name",
 /* 171 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 172 */ "column_def_list ::= column_def",
 /* 173 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 174 */ "column_def ::= column_name type_name",
 /* 175 */ "type_name ::= BOOL",
 /* 176 */ "type_name ::= TINYINT",
 /* 177 */ "type_name ::= SMALLINT",
 /* 178 */ "type_name ::= INT",
 /* 179 */ "type_name ::= INTEGER",
 /* 180 */ "type_name ::= BIGINT",
 /* 181 */ "type_name ::= FLOAT",
 /* 182 */ "type_name ::= DOUBLE",
 /* 183 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 184 */ "type_name ::= TIMESTAMP",
 /* 185 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 186 */ "type_name ::= TINYINT UNSIGNED",
 /* 187 */ "type_name ::= SMALLINT UNSIGNED",
 /* 188 */ "type_name ::= INT UNSIGNED",
 /* 189 */ "type_name ::= BIGINT UNSIGNED",
 /* 190 */ "type_name ::= JSON",
 /* 191 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 192 */ "type_name ::= MEDIUMBLOB",
 /* 193 */ "type_name ::= BLOB",
 /* 194 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 195 */ "type_name ::= DECIMAL",
 /* 196 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 197 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 198 */ "tags_def_opt ::=",
 /* 199 */ "tags_def_opt ::= tags_def",
 /* 200 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 201 */ "table_options ::=",
 /* 202 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 203 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 204 */ "table_options ::= table_options WATERMARK duration_list",
 /* 205 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 206 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 207 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 208 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 209 */ "alter_table_options ::= alter_table_option",
 /* 210 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 211 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 212 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 213 */ "duration_list ::= duration_literal",
 /* 214 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 215 */ "rollup_func_list ::= rollup_func_name",
 /* 216 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 217 */ "rollup_func_name ::= function_name",
 /* 218 */ "rollup_func_name ::= FIRST",
 /* 219 */ "rollup_func_name ::= LAST",
 /* 220 */ "col_name_list ::= col_name",
 /* 221 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 222 */ "col_name ::= column_name",
 /* 223 */ "cmd ::= SHOW DNODES",
 /* 224 */ "cmd ::= SHOW USERS",
 /* 225 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 226 */ "cmd ::= SHOW DATABASES",
 /* 227 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 228 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 229 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 230 */ "cmd ::= SHOW MNODES",
 /* 231 */ "cmd ::= SHOW QNODES",
 /* 232 */ "cmd ::= SHOW FUNCTIONS",
 /* 233 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 234 */ "cmd ::= SHOW STREAMS",
 /* 235 */ "cmd ::= SHOW ACCOUNTS",
 /* 236 */ "cmd ::= SHOW APPS",
 /* 237 */ "cmd ::= SHOW CONNECTIONS",
 /* 238 */ "cmd ::= SHOW LICENCES",
 /* 239 */ "cmd ::= SHOW GRANTS",
 /* 240 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 241 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 242 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 243 */ "cmd ::= SHOW QUERIES",
 /* 244 */ "cmd ::= SHOW SCORES",
 /* 245 */ "cmd ::= SHOW TOPICS",
 /* 246 */ "cmd ::= SHOW VARIABLES",
 /* 247 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 248 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 249 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 250 */ "cmd ::= SHOW BNODES",
 /* 251 */ "cmd ::= SHOW SNODES",
 /* 252 */ "cmd ::= SHOW CLUSTER",
 /* 253 */ "cmd ::= SHOW TRANSACTIONS",
 /* 254 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 255 */ "cmd ::= SHOW CONSUMERS",
 /* 256 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 257 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 258 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 259 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 260 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 261 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 262 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 263 */ "db_name_cond_opt ::=",
 /* 264 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 265 */ "like_pattern_opt ::=",
 /* 266 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 267 */ "table_name_cond ::= table_name",
 /* 268 */ "from_db_opt ::=",
 /* 269 */ "from_db_opt ::= FROM db_name",
 /* 270 */ "tag_list_opt ::=",
 /* 271 */ "tag_list_opt ::= tag_item",
 /* 272 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 273 */ "tag_item ::= TBNAME",
 /* 274 */ "tag_item ::= QTAGS",
 /* 275 */ "tag_item ::= column_name",
 /* 276 */ "tag_item ::= column_name column_alias",
 /* 277 */ "tag_item ::= column_name AS column_alias",
 /* 278 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 279 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 280 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 281 */ "full_index_name ::= index_name",
 /* 282 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 283 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 284 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 285 */ "func_list ::= func",
 /* 286 */ "func_list ::= func_list NK_COMMA func",
 /* 287 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 288 */ "sma_func_name ::= function_name",
 /* 289 */ "sma_func_name ::= COUNT",
 /* 290 */ "sma_func_name ::= FIRST",
 /* 291 */ "sma_func_name ::= LAST",
 /* 292 */ "sma_func_name ::= LAST_ROW",
 /* 293 */ "sma_stream_opt ::=",
 /* 294 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 295 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 296 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 297 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 298 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 299 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 300 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 301 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 302 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 303 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 304 */ "cmd ::= DESC full_table_name",
 /* 305 */ "cmd ::= DESCRIBE full_table_name",
 /* 306 */ "cmd ::= RESET QUERY CACHE",
 /* 307 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 308 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 309 */ "analyze_opt ::=",
 /* 310 */ "analyze_opt ::= ANALYZE",
 /* 311 */ "explain_options ::=",
 /* 312 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 313 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 314 */ "cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt",
 /* 315 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 316 */ "agg_func_opt ::=",
 /* 317 */ "agg_func_opt ::= AGGREGATE",
 /* 318 */ "bufsize_opt ::=",
 /* 319 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 320 */ "language_opt ::=",
 /* 321 */ "language_opt ::= LANGUAGE NK_STRING",
 /* 322 */ "or_replace_opt ::=",
 /* 323 */ "or_replace_opt ::= OR REPLACE",
 /* 324 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 325 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 326 */ "col_list_opt ::=",
 /* 327 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 328 */ "tag_def_or_ref_opt ::=",
 /* 329 */ "tag_def_or_ref_opt ::= tags_def",
 /* 330 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 331 */ "stream_options ::=",
 /* 332 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 333 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 334 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 335 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 336 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 337 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 338 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 339 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 340 */ "subtable_opt ::=",
 /* 341 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 342 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 343 */ "cmd ::= KILL QUERY NK_STRING",
 /* 344 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 345 */ "cmd ::= BALANCE VGROUP",
 /* 346 */ "cmd ::= BALANCE VGROUP LEADER",
 /* 347 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 348 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 349 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 350 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 351 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 352 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 353 */ "cmd ::= query_or_subquery",
 /* 354 */ "cmd ::= insert_query",
 /* 355 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 356 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 357 */ "literal ::= NK_INTEGER",
 /* 358 */ "literal ::= NK_FLOAT",
 /* 359 */ "literal ::= NK_STRING",
 /* 360 */ "literal ::= NK_BOOL",
 /* 361 */ "literal ::= TIMESTAMP NK_STRING",
 /* 362 */ "literal ::= duration_literal",
 /* 363 */ "literal ::= NULL",
 /* 364 */ "literal ::= NK_QUESTION",
 /* 365 */ "duration_literal ::= NK_VARIABLE",
 /* 366 */ "signed ::= NK_INTEGER",
 /* 367 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 368 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 369 */ "signed ::= NK_FLOAT",
 /* 370 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 371 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 372 */ "signed_literal ::= signed",
 /* 373 */ "signed_literal ::= NK_STRING",
 /* 374 */ "signed_literal ::= NK_BOOL",
 /* 375 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 376 */ "signed_literal ::= duration_literal",
 /* 377 */ "signed_literal ::= NULL",
 /* 378 */ "signed_literal ::= literal_func",
 /* 379 */ "signed_literal ::= NK_QUESTION",
 /* 380 */ "literal_list ::= signed_literal",
 /* 381 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 382 */ "db_name ::= NK_ID",
 /* 383 */ "table_name ::= NK_ID",
 /* 384 */ "column_name ::= NK_ID",
 /* 385 */ "function_name ::= NK_ID",
 /* 386 */ "table_alias ::= NK_ID",
 /* 387 */ "column_alias ::= NK_ID",
 /* 388 */ "user_name ::= NK_ID",
 /* 389 */ "topic_name ::= NK_ID",
 /* 390 */ "stream_name ::= NK_ID",
 /* 391 */ "cgroup_name ::= NK_ID",
 /* 392 */ "index_name ::= NK_ID",
 /* 393 */ "expr_or_subquery ::= expression",
 /* 394 */ "expression ::= literal",
 /* 395 */ "expression ::= pseudo_column",
 /* 396 */ "expression ::= column_reference",
 /* 397 */ "expression ::= function_expression",
 /* 398 */ "expression ::= case_when_expression",
 /* 399 */ "expression ::= NK_LP expression NK_RP",
 /* 400 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 401 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 402 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 403 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 404 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 405 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 406 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 407 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 408 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 409 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 410 */ "expression_list ::= expr_or_subquery",
 /* 411 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 412 */ "column_reference ::= column_name",
 /* 413 */ "column_reference ::= table_name NK_DOT column_name",
 /* 414 */ "pseudo_column ::= ROWTS",
 /* 415 */ "pseudo_column ::= TBNAME",
 /* 416 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 417 */ "pseudo_column ::= QSTART",
 /* 418 */ "pseudo_column ::= QEND",
 /* 419 */ "pseudo_column ::= QDURATION",
 /* 420 */ "pseudo_column ::= WSTART",
 /* 421 */ "pseudo_column ::= WEND",
 /* 422 */ "pseudo_column ::= WDURATION",
 /* 423 */ "pseudo_column ::= IROWTS",
 /* 424 */ "pseudo_column ::= ISFILLED",
 /* 425 */ "pseudo_column ::= QTAGS",
 /* 426 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 427 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 428 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 429 */ "function_expression ::= literal_func",
 /* 430 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 431 */ "literal_func ::= NOW",
 /* 432 */ "noarg_func ::= NOW",
 /* 433 */ "noarg_func ::= TODAY",
 /* 434 */ "noarg_func ::= TIMEZONE",
 /* 435 */ "noarg_func ::= DATABASE",
 /* 436 */ "noarg_func ::= CLIENT_VERSION",
 /* 437 */ "noarg_func ::= SERVER_VERSION",
 /* 438 */ "noarg_func ::= SERVER_STATUS",
 /* 439 */ "noarg_func ::= CURRENT_USER",
 /* 440 */ "noarg_func ::= USER",
 /* 441 */ "star_func ::= COUNT",
 /* 442 */ "star_func ::= FIRST",
 /* 443 */ "star_func ::= LAST",
 /* 444 */ "star_func ::= LAST_ROW",
 /* 445 */ "star_func_para_list ::= NK_STAR",
 /* 446 */ "star_func_para_list ::= other_para_list",
 /* 447 */ "other_para_list ::= star_func_para",
 /* 448 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 449 */ "star_func_para ::= expr_or_subquery",
 /* 450 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 451 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 452 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 453 */ "when_then_list ::= when_then_expr",
 /* 454 */ "when_then_list ::= when_then_list when_then_expr",
 /* 455 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 456 */ "case_when_else_opt ::=",
 /* 457 */ "case_when_else_opt ::= ELSE common_expression",
 /* 458 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 459 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 460 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 461 */ "predicate ::= expr_or_subquery IS NULL",
 /* 462 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 463 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 464 */ "compare_op ::= NK_LT",
 /* 465 */ "compare_op ::= NK_GT",
 /* 466 */ "compare_op ::= NK_LE",
 /* 467 */ "compare_op ::= NK_GE",
 /* 468 */ "compare_op ::= NK_NE",
 /* 469 */ "compare_op ::= NK_EQ",
 /* 470 */ "compare_op ::= LIKE",
 /* 471 */ "compare_op ::= NOT LIKE",
 /* 472 */ "compare_op ::= MATCH",
 /* 473 */ "compare_op ::= NMATCH",
 /* 474 */ "compare_op ::= CONTAINS",
 /* 475 */ "in_op ::= IN",
 /* 476 */ "in_op ::= NOT IN",
 /* 477 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 478 */ "boolean_value_expression ::= boolean_primary",
 /* 479 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 480 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 481 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 482 */ "boolean_primary ::= predicate",
 /* 483 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 484 */ "common_expression ::= expr_or_subquery",
 /* 485 */ "common_expression ::= boolean_value_expression",
 /* 486 */ "from_clause_opt ::=",
 /* 487 */ "from_clause_opt ::= FROM table_reference_list",
 /* 488 */ "table_reference_list ::= table_reference",
 /* 489 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 490 */ "table_reference ::= table_primary",
 /* 491 */ "table_reference ::= joined_table",
 /* 492 */ "table_primary ::= table_name alias_opt",
 /* 493 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 494 */ "table_primary ::= subquery alias_opt",
 /* 495 */ "table_primary ::= parenthesized_joined_table",
 /* 496 */ "alias_opt ::=",
 /* 497 */ "alias_opt ::= table_alias",
 /* 498 */ "alias_opt ::= AS table_alias",
 /* 499 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 500 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 501 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 502 */ "join_type ::=",
 /* 503 */ "join_type ::= INNER",
 /* 504 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 505 */ "set_quantifier_opt ::=",
 /* 506 */ "set_quantifier_opt ::= DISTINCT",
 /* 507 */ "set_quantifier_opt ::= ALL",
 /* 508 */ "select_list ::= select_item",
 /* 509 */ "select_list ::= select_list NK_COMMA select_item",
 /* 510 */ "select_item ::= NK_STAR",
 /* 511 */ "select_item ::= common_expression",
 /* 512 */ "select_item ::= common_expression column_alias",
 /* 513 */ "select_item ::= common_expression AS column_alias",
 /* 514 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 515 */ "where_clause_opt ::=",
 /* 516 */ "where_clause_opt ::= WHERE search_condition",
 /* 517 */ "partition_by_clause_opt ::=",
 /* 518 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 519 */ "partition_list ::= partition_item",
 /* 520 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 521 */ "partition_item ::= expr_or_subquery",
 /* 522 */ "partition_item ::= expr_or_subquery column_alias",
 /* 523 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 524 */ "twindow_clause_opt ::=",
 /* 525 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 526 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 527 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 528 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 529 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 530 */ "sliding_opt ::=",
 /* 531 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 532 */ "fill_opt ::=",
 /* 533 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 534 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 535 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP",
 /* 536 */ "fill_mode ::= NONE",
 /* 537 */ "fill_mode ::= PREV",
 /* 538 */ "fill_mode ::= NULL",
 /* 539 */ "fill_mode ::= NULL_F",
 /* 540 */ "fill_mode ::= LINEAR",
 /* 541 */ "fill_mode ::= NEXT",
 /* 542 */ "group_by_clause_opt ::=",
 /* 543 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 544 */ "group_by_list ::= expr_or_subquery",
 /* 545 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 546 */ "having_clause_opt ::=",
 /* 547 */ "having_clause_opt ::= HAVING search_condition",
 /* 548 */ "range_opt ::=",
 /* 549 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 550 */ "every_opt ::=",
 /* 551 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 552 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 553 */ "query_simple ::= query_specification",
 /* 554 */ "query_simple ::= union_query_expression",
 /* 555 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 556 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 557 */ "query_simple_or_subquery ::= query_simple",
 /* 558 */ "query_simple_or_subquery ::= subquery",
 /* 559 */ "query_or_subquery ::= query_expression",
 /* 560 */ "query_or_subquery ::= subquery",
 /* 561 */ "order_by_clause_opt ::=",
 /* 562 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 563 */ "slimit_clause_opt ::=",
 /* 564 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 565 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 566 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 567 */ "limit_clause_opt ::=",
 /* 568 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 569 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 570 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 571 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 572 */ "subquery ::= NK_LP subquery NK_RP",
 /* 573 */ "search_condition ::= common_expression",
 /* 574 */ "sort_specification_list ::= sort_specification",
 /* 575 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 576 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 577 */ "ordering_specification_opt ::=",
 /* 578 */ "ordering_specification_opt ::= ASC",
 /* 579 */ "ordering_specification_opt ::= DESC",
 /* 580 */ "null_ordering_opt ::=",
 /* 581 */ "null_ordering_opt ::= NULLS FIRST",
 /* 582 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 330: /* cmd */
    case 333: /* literal */
    case 339: /* with_opt */
    case 345: /* search_condition */
    case 349: /* db_options */
    case 351: /* alter_db_options */
    case 353: /* start_opt */
    case 354: /* end_opt */
    case 359: /* retention */
    case 360: /* full_table_name */
    case 363: /* table_options */
    case 367: /* alter_table_clause */
    case 368: /* alter_table_options */
    case 371: /* signed_literal */
    case 372: /* create_subtable_clause */
    case 375: /* drop_table_clause */
    case 377: /* column_def */
    case 381: /* duration_literal */
    case 382: /* rollup_func_name */
    case 384: /* col_name */
    case 385: /* db_name_cond_opt */
    case 386: /* like_pattern_opt */
    case 387: /* table_name_cond */
    case 388: /* from_db_opt */
    case 390: /* tag_item */
    case 392: /* full_index_name */
    case 393: /* index_options */
    case 396: /* sliding_opt */
    case 397: /* sma_stream_opt */
    case 398: /* func */
    case 400: /* query_or_subquery */
    case 403: /* explain_options */
    case 404: /* insert_query */
    case 410: /* stream_options */
    case 413: /* subtable_opt */
    case 414: /* expression */
    case 416: /* where_clause_opt */
    case 417: /* signed */
    case 418: /* literal_func */
    case 421: /* expr_or_subquery */
    case 422: /* pseudo_column */
    case 423: /* column_reference */
    case 424: /* function_expression */
    case 425: /* case_when_expression */
    case 430: /* star_func_para */
    case 432: /* case_when_else_opt */
    case 433: /* common_expression */
    case 434: /* when_then_expr */
    case 435: /* predicate */
    case 438: /* in_predicate_value */
    case 439: /* boolean_value_expression */
    case 440: /* boolean_primary */
    case 441: /* from_clause_opt */
    case 442: /* table_reference_list */
    case 443: /* table_reference */
    case 444: /* table_primary */
    case 445: /* joined_table */
    case 447: /* subquery */
    case 448: /* parenthesized_joined_table */
    case 450: /* query_specification */
    case 454: /* range_opt */
    case 455: /* every_opt */
    case 456: /* fill_opt */
    case 457: /* twindow_clause_opt */
    case 459: /* having_clause_opt */
    case 460: /* select_item */
    case 462: /* partition_item */
    case 465: /* query_expression */
    case 466: /* query_simple */
    case 468: /* slimit_clause_opt */
    case 469: /* limit_clause_opt */
    case 470: /* union_query_expression */
    case 471: /* query_simple_or_subquery */
    case 473: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy448)); 
}
      break;
    case 331: /* account_options */
    case 332: /* alter_account_options */
    case 334: /* alter_account_option */
    case 352: /* speed_opt */
    case 407: /* bufsize_opt */
{
 
}
      break;
    case 335: /* user_name */
    case 342: /* db_name */
    case 343: /* table_name */
    case 344: /* topic_name */
    case 346: /* dnode_endpoint */
    case 369: /* column_name */
    case 383: /* function_name */
    case 391: /* column_alias */
    case 394: /* index_name */
    case 399: /* sma_func_name */
    case 401: /* cgroup_name */
    case 408: /* language_opt */
    case 409: /* stream_name */
    case 420: /* table_alias */
    case 426: /* star_func */
    case 428: /* noarg_func */
    case 446: /* alias_opt */
{
 
}
      break;
    case 336: /* sysinfo_opt */
{
 
}
      break;
    case 337: /* privileges */
    case 340: /* priv_type_list */
    case 341: /* priv_type */
{
 
}
      break;
    case 338: /* priv_level */
{
 
}
      break;
    case 347: /* force_opt */
    case 348: /* not_exists_opt */
    case 350: /* exists_opt */
    case 402: /* analyze_opt */
    case 405: /* or_replace_opt */
    case 406: /* agg_func_opt */
    case 451: /* set_quantifier_opt */
{
 
}
      break;
    case 355: /* integer_list */
    case 356: /* variable_list */
    case 357: /* retention_list */
    case 361: /* column_def_list */
    case 362: /* tags_def_opt */
    case 364: /* multi_create_clause */
    case 365: /* tags_def */
    case 366: /* multi_drop_clause */
    case 373: /* specific_cols_opt */
    case 374: /* expression_list */
    case 376: /* col_name_list */
    case 378: /* duration_list */
    case 379: /* rollup_func_list */
    case 389: /* tag_list_opt */
    case 395: /* func_list */
    case 411: /* col_list_opt */
    case 412: /* tag_def_or_ref_opt */
    case 415: /* dnode_list */
    case 419: /* literal_list */
    case 427: /* star_func_para_list */
    case 429: /* other_para_list */
    case 431: /* when_then_list */
    case 452: /* select_list */
    case 453: /* partition_by_clause_opt */
    case 458: /* group_by_clause_opt */
    case 461: /* partition_list */
    case 464: /* group_by_list */
    case 467: /* order_by_clause_opt */
    case 472: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy432)); 
}
      break;
    case 358: /* alter_db_option */
    case 380: /* alter_table_option */
{
 
}
      break;
    case 370: /* type_name */
{
 
}
      break;
    case 436: /* compare_op */
    case 437: /* in_op */
{
 
}
      break;
    case 449: /* join_type */
{
 
}
      break;
    case 463: /* fill_mode */
{
 
}
      break;
    case 474: /* ordering_specification_opt */
{
 
}
      break;
    case 475: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  330,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  330,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  331,    0 }, /* (2) account_options ::= */
  {  331,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  331,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  331,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  331,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  331,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  331,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  331,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  331,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  331,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  332,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  332,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  334,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  334,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  334,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  334,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  334,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  334,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  334,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  334,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  334,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  334,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  330,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  330,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  330,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  330,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  330,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  336,    0 }, /* (29) sysinfo_opt ::= */
  {  336,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  330,   -7 }, /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
  {  330,   -7 }, /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
  {  337,   -1 }, /* (33) privileges ::= ALL */
  {  337,   -1 }, /* (34) privileges ::= priv_type_list */
  {  337,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  340,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  340,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  341,   -1 }, /* (38) priv_type ::= READ */
  {  341,   -1 }, /* (39) priv_type ::= WRITE */
  {  338,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  338,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  338,   -3 }, /* (42) priv_level ::= db_name NK_DOT table_name */
  {  338,   -1 }, /* (43) priv_level ::= topic_name */
  {  339,    0 }, /* (44) with_opt ::= */
  {  339,   -2 }, /* (45) with_opt ::= WITH search_condition */
  {  330,   -3 }, /* (46) cmd ::= CREATE DNODE dnode_endpoint */
  {  330,   -5 }, /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  330,   -4 }, /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  330,   -4 }, /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  330,   -4 }, /* (50) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  330,   -5 }, /* (51) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  330,   -4 }, /* (52) cmd ::= ALTER ALL DNODES NK_STRING */
  {  330,   -5 }, /* (53) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  346,   -1 }, /* (54) dnode_endpoint ::= NK_STRING */
  {  346,   -1 }, /* (55) dnode_endpoint ::= NK_ID */
  {  346,   -1 }, /* (56) dnode_endpoint ::= NK_IPTOKEN */
  {  347,    0 }, /* (57) force_opt ::= */
  {  347,   -1 }, /* (58) force_opt ::= FORCE */
  {  330,   -3 }, /* (59) cmd ::= ALTER LOCAL NK_STRING */
  {  330,   -4 }, /* (60) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  330,   -5 }, /* (61) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (62) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (63) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (64) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (65) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (66) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (67) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (68) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (69) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  330,   -4 }, /* (70) cmd ::= DROP DATABASE exists_opt db_name */
  {  330,   -2 }, /* (71) cmd ::= USE db_name */
  {  330,   -4 }, /* (72) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  330,   -3 }, /* (73) cmd ::= FLUSH DATABASE db_name */
  {  330,   -4 }, /* (74) cmd ::= TRIM DATABASE db_name speed_opt */
  {  330,   -5 }, /* (75) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
  {  348,   -3 }, /* (76) not_exists_opt ::= IF NOT EXISTS */
  {  348,    0 }, /* (77) not_exists_opt ::= */
  {  350,   -2 }, /* (78) exists_opt ::= IF EXISTS */
  {  350,    0 }, /* (79) exists_opt ::= */
  {  349,    0 }, /* (80) db_options ::= */
  {  349,   -3 }, /* (81) db_options ::= db_options BUFFER NK_INTEGER */
  {  349,   -3 }, /* (82) db_options ::= db_options CACHEMODEL NK_STRING */
  {  349,   -3 }, /* (83) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  349,   -3 }, /* (84) db_options ::= db_options COMP NK_INTEGER */
  {  349,   -3 }, /* (85) db_options ::= db_options DURATION NK_INTEGER */
  {  349,   -3 }, /* (86) db_options ::= db_options DURATION NK_VARIABLE */
  {  349,   -3 }, /* (87) db_options ::= db_options MAXROWS NK_INTEGER */
  {  349,   -3 }, /* (88) db_options ::= db_options MINROWS NK_INTEGER */
  {  349,   -3 }, /* (89) db_options ::= db_options KEEP integer_list */
  {  349,   -3 }, /* (90) db_options ::= db_options KEEP variable_list */
  {  349,   -3 }, /* (91) db_options ::= db_options PAGES NK_INTEGER */
  {  349,   -3 }, /* (92) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  349,   -3 }, /* (93) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  349,   -3 }, /* (94) db_options ::= db_options PRECISION NK_STRING */
  {  349,   -3 }, /* (95) db_options ::= db_options REPLICA NK_INTEGER */
  {  349,   -3 }, /* (96) db_options ::= db_options VGROUPS NK_INTEGER */
  {  349,   -3 }, /* (97) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  349,   -3 }, /* (98) db_options ::= db_options RETENTIONS retention_list */
  {  349,   -3 }, /* (99) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  349,   -3 }, /* (100) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  349,   -3 }, /* (101) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  349,   -3 }, /* (102) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  349,   -4 }, /* (103) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  349,   -3 }, /* (104) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  349,   -4 }, /* (105) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  349,   -3 }, /* (106) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  349,   -3 }, /* (107) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  349,   -3 }, /* (108) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  349,   -3 }, /* (109) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  349,   -3 }, /* (110) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  351,   -1 }, /* (111) alter_db_options ::= alter_db_option */
  {  351,   -2 }, /* (112) alter_db_options ::= alter_db_options alter_db_option */
  {  358,   -2 }, /* (113) alter_db_option ::= BUFFER NK_INTEGER */
  {  358,   -2 }, /* (114) alter_db_option ::= CACHEMODEL NK_STRING */
  {  358,   -2 }, /* (115) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  358,   -2 }, /* (116) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  358,   -2 }, /* (117) alter_db_option ::= KEEP integer_list */
  {  358,   -2 }, /* (118) alter_db_option ::= KEEP variable_list */
  {  358,   -2 }, /* (119) alter_db_option ::= PAGES NK_INTEGER */
  {  358,   -2 }, /* (120) alter_db_option ::= REPLICA NK_INTEGER */
  {  358,   -2 }, /* (121) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  358,   -2 }, /* (122) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  358,   -2 }, /* (123) alter_db_option ::= MINROWS NK_INTEGER */
  {  358,   -2 }, /* (124) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
  {  358,   -3 }, /* (125) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  358,   -2 }, /* (126) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
  {  358,   -3 }, /* (127) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  355,   -1 }, /* (128) integer_list ::= NK_INTEGER */
  {  355,   -3 }, /* (129) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  356,   -1 }, /* (130) variable_list ::= NK_VARIABLE */
  {  356,   -3 }, /* (131) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  357,   -1 }, /* (132) retention_list ::= retention */
  {  357,   -3 }, /* (133) retention_list ::= retention_list NK_COMMA retention */
  {  359,   -3 }, /* (134) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  352,    0 }, /* (135) speed_opt ::= */
  {  352,   -2 }, /* (136) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  353,    0 }, /* (137) start_opt ::= */
  {  353,   -3 }, /* (138) start_opt ::= START WITH NK_INTEGER */
  {  353,   -3 }, /* (139) start_opt ::= START WITH NK_STRING */
  {  353,   -4 }, /* (140) start_opt ::= START WITH TIMESTAMP NK_STRING */
  {  354,    0 }, /* (141) end_opt ::= */
  {  354,   -3 }, /* (142) end_opt ::= END WITH NK_INTEGER */
  {  354,   -3 }, /* (143) end_opt ::= END WITH NK_STRING */
  {  354,   -4 }, /* (144) end_opt ::= END WITH TIMESTAMP NK_STRING */
  {  330,   -9 }, /* (145) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  330,   -3 }, /* (146) cmd ::= CREATE TABLE multi_create_clause */
  {  330,   -9 }, /* (147) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  330,   -3 }, /* (148) cmd ::= DROP TABLE multi_drop_clause */
  {  330,   -4 }, /* (149) cmd ::= DROP STABLE exists_opt full_table_name */
  {  330,   -3 }, /* (150) cmd ::= ALTER TABLE alter_table_clause */
  {  330,   -3 }, /* (151) cmd ::= ALTER STABLE alter_table_clause */
  {  367,   -2 }, /* (152) alter_table_clause ::= full_table_name alter_table_options */
  {  367,   -5 }, /* (153) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  367,   -4 }, /* (154) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  367,   -5 }, /* (155) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  367,   -5 }, /* (156) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  367,   -5 }, /* (157) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  367,   -4 }, /* (158) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  367,   -5 }, /* (159) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  367,   -5 }, /* (160) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  367,   -6 }, /* (161) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  364,   -1 }, /* (162) multi_create_clause ::= create_subtable_clause */
  {  364,   -2 }, /* (163) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  372,  -10 }, /* (164) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  366,   -1 }, /* (165) multi_drop_clause ::= drop_table_clause */
  {  366,   -3 }, /* (166) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
  {  375,   -2 }, /* (167) drop_table_clause ::= exists_opt full_table_name */
  {  373,    0 }, /* (168) specific_cols_opt ::= */
  {  373,   -3 }, /* (169) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  360,   -1 }, /* (170) full_table_name ::= table_name */
  {  360,   -3 }, /* (171) full_table_name ::= db_name NK_DOT table_name */
  {  361,   -1 }, /* (172) column_def_list ::= column_def */
  {  361,   -3 }, /* (173) column_def_list ::= column_def_list NK_COMMA column_def */
  {  377,   -2 }, /* (174) column_def ::= column_name type_name */
  {  370,   -1 }, /* (175) type_name ::= BOOL */
  {  370,   -1 }, /* (176) type_name ::= TINYINT */
  {  370,   -1 }, /* (177) type_name ::= SMALLINT */
  {  370,   -1 }, /* (178) type_name ::= INT */
  {  370,   -1 }, /* (179) type_name ::= INTEGER */
  {  370,   -1 }, /* (180) type_name ::= BIGINT */
  {  370,   -1 }, /* (181) type_name ::= FLOAT */
  {  370,   -1 }, /* (182) type_name ::= DOUBLE */
  {  370,   -4 }, /* (183) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  370,   -1 }, /* (184) type_name ::= TIMESTAMP */
  {  370,   -4 }, /* (185) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  370,   -2 }, /* (186) type_name ::= TINYINT UNSIGNED */
  {  370,   -2 }, /* (187) type_name ::= SMALLINT UNSIGNED */
  {  370,   -2 }, /* (188) type_name ::= INT UNSIGNED */
  {  370,   -2 }, /* (189) type_name ::= BIGINT UNSIGNED */
  {  370,   -1 }, /* (190) type_name ::= JSON */
  {  370,   -4 }, /* (191) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  370,   -1 }, /* (192) type_name ::= MEDIUMBLOB */
  {  370,   -1 }, /* (193) type_name ::= BLOB */
  {  370,   -4 }, /* (194) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  370,   -1 }, /* (195) type_name ::= DECIMAL */
  {  370,   -4 }, /* (196) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  370,   -6 }, /* (197) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  362,    0 }, /* (198) tags_def_opt ::= */
  {  362,   -1 }, /* (199) tags_def_opt ::= tags_def */
  {  365,   -4 }, /* (200) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  363,    0 }, /* (201) table_options ::= */
  {  363,   -3 }, /* (202) table_options ::= table_options COMMENT NK_STRING */
  {  363,   -3 }, /* (203) table_options ::= table_options MAX_DELAY duration_list */
  {  363,   -3 }, /* (204) table_options ::= table_options WATERMARK duration_list */
  {  363,   -5 }, /* (205) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  363,   -3 }, /* (206) table_options ::= table_options TTL NK_INTEGER */
  {  363,   -5 }, /* (207) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  363,   -3 }, /* (208) table_options ::= table_options DELETE_MARK duration_list */
  {  368,   -1 }, /* (209) alter_table_options ::= alter_table_option */
  {  368,   -2 }, /* (210) alter_table_options ::= alter_table_options alter_table_option */
  {  380,   -2 }, /* (211) alter_table_option ::= COMMENT NK_STRING */
  {  380,   -2 }, /* (212) alter_table_option ::= TTL NK_INTEGER */
  {  378,   -1 }, /* (213) duration_list ::= duration_literal */
  {  378,   -3 }, /* (214) duration_list ::= duration_list NK_COMMA duration_literal */
  {  379,   -1 }, /* (215) rollup_func_list ::= rollup_func_name */
  {  379,   -3 }, /* (216) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  382,   -1 }, /* (217) rollup_func_name ::= function_name */
  {  382,   -1 }, /* (218) rollup_func_name ::= FIRST */
  {  382,   -1 }, /* (219) rollup_func_name ::= LAST */
  {  376,   -1 }, /* (220) col_name_list ::= col_name */
  {  376,   -3 }, /* (221) col_name_list ::= col_name_list NK_COMMA col_name */
  {  384,   -1 }, /* (222) col_name ::= column_name */
  {  330,   -2 }, /* (223) cmd ::= SHOW DNODES */
  {  330,   -2 }, /* (224) cmd ::= SHOW USERS */
  {  330,   -3 }, /* (225) cmd ::= SHOW USER PRIVILEGES */
  {  330,   -2 }, /* (226) cmd ::= SHOW DATABASES */
  {  330,   -4 }, /* (227) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  330,   -4 }, /* (228) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  330,   -3 }, /* (229) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  330,   -2 }, /* (230) cmd ::= SHOW MNODES */
  {  330,   -2 }, /* (231) cmd ::= SHOW QNODES */
  {  330,   -2 }, /* (232) cmd ::= SHOW FUNCTIONS */
  {  330,   -5 }, /* (233) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  330,   -2 }, /* (234) cmd ::= SHOW STREAMS */
  {  330,   -2 }, /* (235) cmd ::= SHOW ACCOUNTS */
  {  330,   -2 }, /* (236) cmd ::= SHOW APPS */
  {  330,   -2 }, /* (237) cmd ::= SHOW CONNECTIONS */
  {  330,   -2 }, /* (238) cmd ::= SHOW LICENCES */
  {  330,   -2 }, /* (239) cmd ::= SHOW GRANTS */
  {  330,   -4 }, /* (240) cmd ::= SHOW CREATE DATABASE db_name */
  {  330,   -4 }, /* (241) cmd ::= SHOW CREATE TABLE full_table_name */
  {  330,   -4 }, /* (242) cmd ::= SHOW CREATE STABLE full_table_name */
  {  330,   -2 }, /* (243) cmd ::= SHOW QUERIES */
  {  330,   -2 }, /* (244) cmd ::= SHOW SCORES */
  {  330,   -2 }, /* (245) cmd ::= SHOW TOPICS */
  {  330,   -2 }, /* (246) cmd ::= SHOW VARIABLES */
  {  330,   -3 }, /* (247) cmd ::= SHOW CLUSTER VARIABLES */
  {  330,   -3 }, /* (248) cmd ::= SHOW LOCAL VARIABLES */
  {  330,   -5 }, /* (249) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  330,   -2 }, /* (250) cmd ::= SHOW BNODES */
  {  330,   -2 }, /* (251) cmd ::= SHOW SNODES */
  {  330,   -2 }, /* (252) cmd ::= SHOW CLUSTER */
  {  330,   -2 }, /* (253) cmd ::= SHOW TRANSACTIONS */
  {  330,   -4 }, /* (254) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  330,   -2 }, /* (255) cmd ::= SHOW CONSUMERS */
  {  330,   -2 }, /* (256) cmd ::= SHOW SUBSCRIPTIONS */
  {  330,   -5 }, /* (257) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  330,   -7 }, /* (258) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  330,   -3 }, /* (259) cmd ::= SHOW VNODES NK_INTEGER */
  {  330,   -3 }, /* (260) cmd ::= SHOW VNODES NK_STRING */
  {  330,   -3 }, /* (261) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  330,   -3 }, /* (262) cmd ::= SHOW CLUSTER ALIVE */
  {  385,    0 }, /* (263) db_name_cond_opt ::= */
  {  385,   -2 }, /* (264) db_name_cond_opt ::= db_name NK_DOT */
  {  386,    0 }, /* (265) like_pattern_opt ::= */
  {  386,   -2 }, /* (266) like_pattern_opt ::= LIKE NK_STRING */
  {  387,   -1 }, /* (267) table_name_cond ::= table_name */
  {  388,    0 }, /* (268) from_db_opt ::= */
  {  388,   -2 }, /* (269) from_db_opt ::= FROM db_name */
  {  389,    0 }, /* (270) tag_list_opt ::= */
  {  389,   -1 }, /* (271) tag_list_opt ::= tag_item */
  {  389,   -3 }, /* (272) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  390,   -1 }, /* (273) tag_item ::= TBNAME */
  {  390,   -1 }, /* (274) tag_item ::= QTAGS */
  {  390,   -1 }, /* (275) tag_item ::= column_name */
  {  390,   -2 }, /* (276) tag_item ::= column_name column_alias */
  {  390,   -3 }, /* (277) tag_item ::= column_name AS column_alias */
  {  330,   -8 }, /* (278) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  330,   -9 }, /* (279) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  330,   -4 }, /* (280) cmd ::= DROP INDEX exists_opt full_index_name */
  {  392,   -1 }, /* (281) full_index_name ::= index_name */
  {  392,   -3 }, /* (282) full_index_name ::= db_name NK_DOT index_name */
  {  393,  -10 }, /* (283) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  393,  -12 }, /* (284) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  395,   -1 }, /* (285) func_list ::= func */
  {  395,   -3 }, /* (286) func_list ::= func_list NK_COMMA func */
  {  398,   -4 }, /* (287) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  399,   -1 }, /* (288) sma_func_name ::= function_name */
  {  399,   -1 }, /* (289) sma_func_name ::= COUNT */
  {  399,   -1 }, /* (290) sma_func_name ::= FIRST */
  {  399,   -1 }, /* (291) sma_func_name ::= LAST */
  {  399,   -1 }, /* (292) sma_func_name ::= LAST_ROW */
  {  397,    0 }, /* (293) sma_stream_opt ::= */
  {  397,   -3 }, /* (294) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  397,   -3 }, /* (295) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  397,   -3 }, /* (296) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  330,   -6 }, /* (297) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  330,   -7 }, /* (298) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  330,   -9 }, /* (299) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  330,   -7 }, /* (300) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  330,   -9 }, /* (301) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  330,   -4 }, /* (302) cmd ::= DROP TOPIC exists_opt topic_name */
  {  330,   -7 }, /* (303) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  330,   -2 }, /* (304) cmd ::= DESC full_table_name */
  {  330,   -2 }, /* (305) cmd ::= DESCRIBE full_table_name */
  {  330,   -3 }, /* (306) cmd ::= RESET QUERY CACHE */
  {  330,   -4 }, /* (307) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  330,   -4 }, /* (308) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
  {  402,    0 }, /* (309) analyze_opt ::= */
  {  402,   -1 }, /* (310) analyze_opt ::= ANALYZE */
  {  403,    0 }, /* (311) explain_options ::= */
  {  403,   -3 }, /* (312) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  403,   -3 }, /* (313) explain_options ::= explain_options RATIO NK_FLOAT */
  {  330,  -12 }, /* (314) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
  {  330,   -4 }, /* (315) cmd ::= DROP FUNCTION exists_opt function_name */
  {  406,    0 }, /* (316) agg_func_opt ::= */
  {  406,   -1 }, /* (317) agg_func_opt ::= AGGREGATE */
  {  407,    0 }, /* (318) bufsize_opt ::= */
  {  407,   -2 }, /* (319) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  408,    0 }, /* (320) language_opt ::= */
  {  408,   -2 }, /* (321) language_opt ::= LANGUAGE NK_STRING */
  {  405,    0 }, /* (322) or_replace_opt ::= */
  {  405,   -2 }, /* (323) or_replace_opt ::= OR REPLACE */
  {  330,  -12 }, /* (324) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  330,   -4 }, /* (325) cmd ::= DROP STREAM exists_opt stream_name */
  {  411,    0 }, /* (326) col_list_opt ::= */
  {  411,   -3 }, /* (327) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  412,    0 }, /* (328) tag_def_or_ref_opt ::= */
  {  412,   -1 }, /* (329) tag_def_or_ref_opt ::= tags_def */
  {  412,   -4 }, /* (330) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  410,    0 }, /* (331) stream_options ::= */
  {  410,   -3 }, /* (332) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  410,   -3 }, /* (333) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  410,   -4 }, /* (334) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  410,   -3 }, /* (335) stream_options ::= stream_options WATERMARK duration_literal */
  {  410,   -4 }, /* (336) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  410,   -3 }, /* (337) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  410,   -3 }, /* (338) stream_options ::= stream_options DELETE_MARK duration_literal */
  {  410,   -4 }, /* (339) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
  {  413,    0 }, /* (340) subtable_opt ::= */
  {  413,   -4 }, /* (341) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  330,   -3 }, /* (342) cmd ::= KILL CONNECTION NK_INTEGER */
  {  330,   -3 }, /* (343) cmd ::= KILL QUERY NK_STRING */
  {  330,   -3 }, /* (344) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  330,   -2 }, /* (345) cmd ::= BALANCE VGROUP */
  {  330,   -3 }, /* (346) cmd ::= BALANCE VGROUP LEADER */
  {  330,   -4 }, /* (347) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  330,   -4 }, /* (348) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  330,   -3 }, /* (349) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  415,   -2 }, /* (350) dnode_list ::= DNODE NK_INTEGER */
  {  415,   -3 }, /* (351) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  330,   -4 }, /* (352) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  330,   -1 }, /* (353) cmd ::= query_or_subquery */
  {  330,   -1 }, /* (354) cmd ::= insert_query */
  {  404,   -7 }, /* (355) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  404,   -4 }, /* (356) insert_query ::= INSERT INTO full_table_name query_or_subquery */
  {  333,   -1 }, /* (357) literal ::= NK_INTEGER */
  {  333,   -1 }, /* (358) literal ::= NK_FLOAT */
  {  333,   -1 }, /* (359) literal ::= NK_STRING */
  {  333,   -1 }, /* (360) literal ::= NK_BOOL */
  {  333,   -2 }, /* (361) literal ::= TIMESTAMP NK_STRING */
  {  333,   -1 }, /* (362) literal ::= duration_literal */
  {  333,   -1 }, /* (363) literal ::= NULL */
  {  333,   -1 }, /* (364) literal ::= NK_QUESTION */
  {  381,   -1 }, /* (365) duration_literal ::= NK_VARIABLE */
  {  417,   -1 }, /* (366) signed ::= NK_INTEGER */
  {  417,   -2 }, /* (367) signed ::= NK_PLUS NK_INTEGER */
  {  417,   -2 }, /* (368) signed ::= NK_MINUS NK_INTEGER */
  {  417,   -1 }, /* (369) signed ::= NK_FLOAT */
  {  417,   -2 }, /* (370) signed ::= NK_PLUS NK_FLOAT */
  {  417,   -2 }, /* (371) signed ::= NK_MINUS NK_FLOAT */
  {  371,   -1 }, /* (372) signed_literal ::= signed */
  {  371,   -1 }, /* (373) signed_literal ::= NK_STRING */
  {  371,   -1 }, /* (374) signed_literal ::= NK_BOOL */
  {  371,   -2 }, /* (375) signed_literal ::= TIMESTAMP NK_STRING */
  {  371,   -1 }, /* (376) signed_literal ::= duration_literal */
  {  371,   -1 }, /* (377) signed_literal ::= NULL */
  {  371,   -1 }, /* (378) signed_literal ::= literal_func */
  {  371,   -1 }, /* (379) signed_literal ::= NK_QUESTION */
  {  419,   -1 }, /* (380) literal_list ::= signed_literal */
  {  419,   -3 }, /* (381) literal_list ::= literal_list NK_COMMA signed_literal */
  {  342,   -1 }, /* (382) db_name ::= NK_ID */
  {  343,   -1 }, /* (383) table_name ::= NK_ID */
  {  369,   -1 }, /* (384) column_name ::= NK_ID */
  {  383,   -1 }, /* (385) function_name ::= NK_ID */
  {  420,   -1 }, /* (386) table_alias ::= NK_ID */
  {  391,   -1 }, /* (387) column_alias ::= NK_ID */
  {  335,   -1 }, /* (388) user_name ::= NK_ID */
  {  344,   -1 }, /* (389) topic_name ::= NK_ID */
  {  409,   -1 }, /* (390) stream_name ::= NK_ID */
  {  401,   -1 }, /* (391) cgroup_name ::= NK_ID */
  {  394,   -1 }, /* (392) index_name ::= NK_ID */
  {  421,   -1 }, /* (393) expr_or_subquery ::= expression */
  {  414,   -1 }, /* (394) expression ::= literal */
  {  414,   -1 }, /* (395) expression ::= pseudo_column */
  {  414,   -1 }, /* (396) expression ::= column_reference */
  {  414,   -1 }, /* (397) expression ::= function_expression */
  {  414,   -1 }, /* (398) expression ::= case_when_expression */
  {  414,   -3 }, /* (399) expression ::= NK_LP expression NK_RP */
  {  414,   -2 }, /* (400) expression ::= NK_PLUS expr_or_subquery */
  {  414,   -2 }, /* (401) expression ::= NK_MINUS expr_or_subquery */
  {  414,   -3 }, /* (402) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  414,   -3 }, /* (403) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  414,   -3 }, /* (404) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  414,   -3 }, /* (405) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  414,   -3 }, /* (406) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  414,   -3 }, /* (407) expression ::= column_reference NK_ARROW NK_STRING */
  {  414,   -3 }, /* (408) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  414,   -3 }, /* (409) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  374,   -1 }, /* (410) expression_list ::= expr_or_subquery */
  {  374,   -3 }, /* (411) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  423,   -1 }, /* (412) column_reference ::= column_name */
  {  423,   -3 }, /* (413) column_reference ::= table_name NK_DOT column_name */
  {  422,   -1 }, /* (414) pseudo_column ::= ROWTS */
  {  422,   -1 }, /* (415) pseudo_column ::= TBNAME */
  {  422,   -3 }, /* (416) pseudo_column ::= table_name NK_DOT TBNAME */
  {  422,   -1 }, /* (417) pseudo_column ::= QSTART */
  {  422,   -1 }, /* (418) pseudo_column ::= QEND */
  {  422,   -1 }, /* (419) pseudo_column ::= QDURATION */
  {  422,   -1 }, /* (420) pseudo_column ::= WSTART */
  {  422,   -1 }, /* (421) pseudo_column ::= WEND */
  {  422,   -1 }, /* (422) pseudo_column ::= WDURATION */
  {  422,   -1 }, /* (423) pseudo_column ::= IROWTS */
  {  422,   -1 }, /* (424) pseudo_column ::= ISFILLED */
  {  422,   -1 }, /* (425) pseudo_column ::= QTAGS */
  {  424,   -4 }, /* (426) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  424,   -4 }, /* (427) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  424,   -6 }, /* (428) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  424,   -1 }, /* (429) function_expression ::= literal_func */
  {  418,   -3 }, /* (430) literal_func ::= noarg_func NK_LP NK_RP */
  {  418,   -1 }, /* (431) literal_func ::= NOW */
  {  428,   -1 }, /* (432) noarg_func ::= NOW */
  {  428,   -1 }, /* (433) noarg_func ::= TODAY */
  {  428,   -1 }, /* (434) noarg_func ::= TIMEZONE */
  {  428,   -1 }, /* (435) noarg_func ::= DATABASE */
  {  428,   -1 }, /* (436) noarg_func ::= CLIENT_VERSION */
  {  428,   -1 }, /* (437) noarg_func ::= SERVER_VERSION */
  {  428,   -1 }, /* (438) noarg_func ::= SERVER_STATUS */
  {  428,   -1 }, /* (439) noarg_func ::= CURRENT_USER */
  {  428,   -1 }, /* (440) noarg_func ::= USER */
  {  426,   -1 }, /* (441) star_func ::= COUNT */
  {  426,   -1 }, /* (442) star_func ::= FIRST */
  {  426,   -1 }, /* (443) star_func ::= LAST */
  {  426,   -1 }, /* (444) star_func ::= LAST_ROW */
  {  427,   -1 }, /* (445) star_func_para_list ::= NK_STAR */
  {  427,   -1 }, /* (446) star_func_para_list ::= other_para_list */
  {  429,   -1 }, /* (447) other_para_list ::= star_func_para */
  {  429,   -3 }, /* (448) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  430,   -1 }, /* (449) star_func_para ::= expr_or_subquery */
  {  430,   -3 }, /* (450) star_func_para ::= table_name NK_DOT NK_STAR */
  {  425,   -4 }, /* (451) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  425,   -5 }, /* (452) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  431,   -1 }, /* (453) when_then_list ::= when_then_expr */
  {  431,   -2 }, /* (454) when_then_list ::= when_then_list when_then_expr */
  {  434,   -4 }, /* (455) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  432,    0 }, /* (456) case_when_else_opt ::= */
  {  432,   -2 }, /* (457) case_when_else_opt ::= ELSE common_expression */
  {  435,   -3 }, /* (458) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  435,   -5 }, /* (459) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  435,   -6 }, /* (460) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  435,   -3 }, /* (461) predicate ::= expr_or_subquery IS NULL */
  {  435,   -4 }, /* (462) predicate ::= expr_or_subquery IS NOT NULL */
  {  435,   -3 }, /* (463) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  436,   -1 }, /* (464) compare_op ::= NK_LT */
  {  436,   -1 }, /* (465) compare_op ::= NK_GT */
  {  436,   -1 }, /* (466) compare_op ::= NK_LE */
  {  436,   -1 }, /* (467) compare_op ::= NK_GE */
  {  436,   -1 }, /* (468) compare_op ::= NK_NE */
  {  436,   -1 }, /* (469) compare_op ::= NK_EQ */
  {  436,   -1 }, /* (470) compare_op ::= LIKE */
  {  436,   -2 }, /* (471) compare_op ::= NOT LIKE */
  {  436,   -1 }, /* (472) compare_op ::= MATCH */
  {  436,   -1 }, /* (473) compare_op ::= NMATCH */
  {  436,   -1 }, /* (474) compare_op ::= CONTAINS */
  {  437,   -1 }, /* (475) in_op ::= IN */
  {  437,   -2 }, /* (476) in_op ::= NOT IN */
  {  438,   -3 }, /* (477) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  439,   -1 }, /* (478) boolean_value_expression ::= boolean_primary */
  {  439,   -2 }, /* (479) boolean_value_expression ::= NOT boolean_primary */
  {  439,   -3 }, /* (480) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  439,   -3 }, /* (481) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  440,   -1 }, /* (482) boolean_primary ::= predicate */
  {  440,   -3 }, /* (483) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  433,   -1 }, /* (484) common_expression ::= expr_or_subquery */
  {  433,   -1 }, /* (485) common_expression ::= boolean_value_expression */
  {  441,    0 }, /* (486) from_clause_opt ::= */
  {  441,   -2 }, /* (487) from_clause_opt ::= FROM table_reference_list */
  {  442,   -1 }, /* (488) table_reference_list ::= table_reference */
  {  442,   -3 }, /* (489) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  443,   -1 }, /* (490) table_reference ::= table_primary */
  {  443,   -1 }, /* (491) table_reference ::= joined_table */
  {  444,   -2 }, /* (492) table_primary ::= table_name alias_opt */
  {  444,   -4 }, /* (493) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  444,   -2 }, /* (494) table_primary ::= subquery alias_opt */
  {  444,   -1 }, /* (495) table_primary ::= parenthesized_joined_table */
  {  446,    0 }, /* (496) alias_opt ::= */
  {  446,   -1 }, /* (497) alias_opt ::= table_alias */
  {  446,   -2 }, /* (498) alias_opt ::= AS table_alias */
  {  448,   -3 }, /* (499) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  448,   -3 }, /* (500) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  445,   -6 }, /* (501) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  449,    0 }, /* (502) join_type ::= */
  {  449,   -1 }, /* (503) join_type ::= INNER */
  {  450,  -12 }, /* (504) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  451,    0 }, /* (505) set_quantifier_opt ::= */
  {  451,   -1 }, /* (506) set_quantifier_opt ::= DISTINCT */
  {  451,   -1 }, /* (507) set_quantifier_opt ::= ALL */
  {  452,   -1 }, /* (508) select_list ::= select_item */
  {  452,   -3 }, /* (509) select_list ::= select_list NK_COMMA select_item */
  {  460,   -1 }, /* (510) select_item ::= NK_STAR */
  {  460,   -1 }, /* (511) select_item ::= common_expression */
  {  460,   -2 }, /* (512) select_item ::= common_expression column_alias */
  {  460,   -3 }, /* (513) select_item ::= common_expression AS column_alias */
  {  460,   -3 }, /* (514) select_item ::= table_name NK_DOT NK_STAR */
  {  416,    0 }, /* (515) where_clause_opt ::= */
  {  416,   -2 }, /* (516) where_clause_opt ::= WHERE search_condition */
  {  453,    0 }, /* (517) partition_by_clause_opt ::= */
  {  453,   -3 }, /* (518) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  461,   -1 }, /* (519) partition_list ::= partition_item */
  {  461,   -3 }, /* (520) partition_list ::= partition_list NK_COMMA partition_item */
  {  462,   -1 }, /* (521) partition_item ::= expr_or_subquery */
  {  462,   -2 }, /* (522) partition_item ::= expr_or_subquery column_alias */
  {  462,   -3 }, /* (523) partition_item ::= expr_or_subquery AS column_alias */
  {  457,    0 }, /* (524) twindow_clause_opt ::= */
  {  457,   -6 }, /* (525) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  457,   -4 }, /* (526) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  457,   -6 }, /* (527) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  457,   -8 }, /* (528) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  457,   -7 }, /* (529) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  396,    0 }, /* (530) sliding_opt ::= */
  {  396,   -4 }, /* (531) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  456,    0 }, /* (532) fill_opt ::= */
  {  456,   -4 }, /* (533) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  456,   -6 }, /* (534) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  456,   -6 }, /* (535) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
  {  463,   -1 }, /* (536) fill_mode ::= NONE */
  {  463,   -1 }, /* (537) fill_mode ::= PREV */
  {  463,   -1 }, /* (538) fill_mode ::= NULL */
  {  463,   -1 }, /* (539) fill_mode ::= NULL_F */
  {  463,   -1 }, /* (540) fill_mode ::= LINEAR */
  {  463,   -1 }, /* (541) fill_mode ::= NEXT */
  {  458,    0 }, /* (542) group_by_clause_opt ::= */
  {  458,   -3 }, /* (543) group_by_clause_opt ::= GROUP BY group_by_list */
  {  464,   -1 }, /* (544) group_by_list ::= expr_or_subquery */
  {  464,   -3 }, /* (545) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  459,    0 }, /* (546) having_clause_opt ::= */
  {  459,   -2 }, /* (547) having_clause_opt ::= HAVING search_condition */
  {  454,    0 }, /* (548) range_opt ::= */
  {  454,   -6 }, /* (549) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  455,    0 }, /* (550) every_opt ::= */
  {  455,   -4 }, /* (551) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  465,   -4 }, /* (552) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  466,   -1 }, /* (553) query_simple ::= query_specification */
  {  466,   -1 }, /* (554) query_simple ::= union_query_expression */
  {  470,   -4 }, /* (555) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  470,   -3 }, /* (556) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  471,   -1 }, /* (557) query_simple_or_subquery ::= query_simple */
  {  471,   -1 }, /* (558) query_simple_or_subquery ::= subquery */
  {  400,   -1 }, /* (559) query_or_subquery ::= query_expression */
  {  400,   -1 }, /* (560) query_or_subquery ::= subquery */
  {  467,    0 }, /* (561) order_by_clause_opt ::= */
  {  467,   -3 }, /* (562) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  468,    0 }, /* (563) slimit_clause_opt ::= */
  {  468,   -2 }, /* (564) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  468,   -4 }, /* (565) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  468,   -4 }, /* (566) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  469,    0 }, /* (567) limit_clause_opt ::= */
  {  469,   -2 }, /* (568) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  469,   -4 }, /* (569) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  469,   -4 }, /* (570) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  447,   -3 }, /* (571) subquery ::= NK_LP query_expression NK_RP */
  {  447,   -3 }, /* (572) subquery ::= NK_LP subquery NK_RP */
  {  345,   -1 }, /* (573) search_condition ::= common_expression */
  {  472,   -1 }, /* (574) sort_specification_list ::= sort_specification */
  {  472,   -3 }, /* (575) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  473,   -3 }, /* (576) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  474,    0 }, /* (577) ordering_specification_opt ::= */
  {  474,   -1 }, /* (578) ordering_specification_opt ::= ASC */
  {  474,   -1 }, /* (579) ordering_specification_opt ::= DESC */
  {  475,    0 }, /* (580) null_ordering_opt ::= */
  {  475,   -2 }, /* (581) null_ordering_opt ::= NULLS FIRST */
  {  475,   -2 }, /* (582) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,331,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,332,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,331,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,333,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,334,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,332,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,334,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,333,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy113, &yymsp[-1].minor.yy0, yymsp[0].minor.yy551); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy113, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy113, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy113, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy113); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy551 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy551 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-5].minor.yy837, &yymsp[-3].minor.yy777, &yymsp[0].minor.yy113, yymsp[-2].minor.yy448); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-5].minor.yy837, &yymsp[-3].minor.yy777, &yymsp[0].minor.yy113, yymsp[-2].minor.yy448); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy837 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy837 = yymsp[0].minor.yy837; }
  yymsp[0].minor.yy837 = yylhsminor.yy837;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy837 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy837 = yymsp[-2].minor.yy837 | yymsp[0].minor.yy837; }
  yymsp[-2].minor.yy837 = yylhsminor.yy837;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy837 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy837 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy777.first = yymsp[-2].minor.yy0; yylhsminor.yy777.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy777 = yylhsminor.yy777;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy777.first = yymsp[-2].minor.yy113; yylhsminor.yy777.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy777 = yylhsminor.yy777;
        break;
      case 42: /* priv_level ::= db_name NK_DOT table_name */
{ yylhsminor.yy777.first = yymsp[-2].minor.yy113; yylhsminor.yy777.second = yymsp[0].minor.yy113; }
  yymsp[-2].minor.yy777 = yylhsminor.yy777;
        break;
      case 43: /* priv_level ::= topic_name */
{ yylhsminor.yy777.first = yymsp[0].minor.yy113; yylhsminor.yy777.second = nil_token; }
  yymsp[0].minor.yy777 = yylhsminor.yy777;
        break;
      case 44: /* with_opt ::= */
      case 137: /* start_opt ::= */ yytestcase(yyruleno==137);
      case 141: /* end_opt ::= */ yytestcase(yyruleno==141);
      case 265: /* like_pattern_opt ::= */ yytestcase(yyruleno==265);
      case 340: /* subtable_opt ::= */ yytestcase(yyruleno==340);
      case 456: /* case_when_else_opt ::= */ yytestcase(yyruleno==456);
      case 486: /* from_clause_opt ::= */ yytestcase(yyruleno==486);
      case 515: /* where_clause_opt ::= */ yytestcase(yyruleno==515);
      case 524: /* twindow_clause_opt ::= */ yytestcase(yyruleno==524);
      case 530: /* sliding_opt ::= */ yytestcase(yyruleno==530);
      case 532: /* fill_opt ::= */ yytestcase(yyruleno==532);
      case 546: /* having_clause_opt ::= */ yytestcase(yyruleno==546);
      case 548: /* range_opt ::= */ yytestcase(yyruleno==548);
      case 550: /* every_opt ::= */ yytestcase(yyruleno==550);
      case 563: /* slimit_clause_opt ::= */ yytestcase(yyruleno==563);
      case 567: /* limit_clause_opt ::= */ yytestcase(yyruleno==567);
{ yymsp[1].minor.yy448 = NULL; }
        break;
      case 45: /* with_opt ::= WITH search_condition */
      case 487: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==487);
      case 516: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==516);
      case 547: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==547);
{ yymsp[-1].minor.yy448 = yymsp[0].minor.yy448; }
        break;
      case 46: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy113, NULL); }
        break;
      case 47: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy369); }
        break;
      case 49: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy113, yymsp[0].minor.yy369); }
        break;
      case 50: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 51: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 52: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* dnode_endpoint ::= NK_STRING */
      case 55: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==55);
      case 56: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==56);
      case 289: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==289);
      case 290: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==290);
      case 291: /* sma_func_name ::= LAST */ yytestcase(yyruleno==291);
      case 292: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==292);
      case 382: /* db_name ::= NK_ID */ yytestcase(yyruleno==382);
      case 383: /* table_name ::= NK_ID */ yytestcase(yyruleno==383);
      case 384: /* column_name ::= NK_ID */ yytestcase(yyruleno==384);
      case 385: /* function_name ::= NK_ID */ yytestcase(yyruleno==385);
      case 386: /* table_alias ::= NK_ID */ yytestcase(yyruleno==386);
      case 387: /* column_alias ::= NK_ID */ yytestcase(yyruleno==387);
      case 388: /* user_name ::= NK_ID */ yytestcase(yyruleno==388);
      case 389: /* topic_name ::= NK_ID */ yytestcase(yyruleno==389);
      case 390: /* stream_name ::= NK_ID */ yytestcase(yyruleno==390);
      case 391: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==391);
      case 392: /* index_name ::= NK_ID */ yytestcase(yyruleno==392);
      case 432: /* noarg_func ::= NOW */ yytestcase(yyruleno==432);
      case 433: /* noarg_func ::= TODAY */ yytestcase(yyruleno==433);
      case 434: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==434);
      case 435: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==435);
      case 436: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==436);
      case 437: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==437);
      case 438: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==438);
      case 439: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==439);
      case 440: /* noarg_func ::= USER */ yytestcase(yyruleno==440);
      case 441: /* star_func ::= COUNT */ yytestcase(yyruleno==441);
      case 442: /* star_func ::= FIRST */ yytestcase(yyruleno==442);
      case 443: /* star_func ::= LAST */ yytestcase(yyruleno==443);
      case 444: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==444);
{ yylhsminor.yy113 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy113 = yylhsminor.yy113;
        break;
      case 57: /* force_opt ::= */
      case 77: /* not_exists_opt ::= */ yytestcase(yyruleno==77);
      case 79: /* exists_opt ::= */ yytestcase(yyruleno==79);
      case 309: /* analyze_opt ::= */ yytestcase(yyruleno==309);
      case 316: /* agg_func_opt ::= */ yytestcase(yyruleno==316);
      case 322: /* or_replace_opt ::= */ yytestcase(yyruleno==322);
      case 505: /* set_quantifier_opt ::= */ yytestcase(yyruleno==505);
{ yymsp[1].minor.yy369 = false; }
        break;
      case 58: /* force_opt ::= FORCE */
      case 310: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==310);
      case 317: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==317);
      case 506: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==506);
{ yymsp[0].minor.yy369 = true; }
        break;
      case 59: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 60: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 67: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 68: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 69: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy369, &yymsp[-1].minor.yy113, yymsp[0].minor.yy448); }
        break;
      case 70: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy369, &yymsp[0].minor.yy113); }
        break;
      case 71: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy113); }
        break;
      case 72: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy113, yymsp[0].minor.yy448); }
        break;
      case 73: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy113); }
        break;
      case 74: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy113, yymsp[0].minor.yy788); }
        break;
      case 75: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy113, yymsp[-1].minor.yy448, yymsp[0].minor.yy448); }
        break;
      case 76: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy369 = true; }
        break;
      case 78: /* exists_opt ::= IF EXISTS */
      case 323: /* or_replace_opt ::= OR REPLACE */ yytestcase(yyruleno==323);
{ yymsp[-1].minor.yy369 = true; }
        break;
      case 80: /* db_options ::= */
{ yymsp[1].minor.yy448 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 81: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 82: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 83: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 84: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 85: /* db_options ::= db_options DURATION NK_INTEGER */
      case 86: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==86);
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 87: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 88: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 89: /* db_options ::= db_options KEEP integer_list */
      case 90: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==90);
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_KEEP, yymsp[0].minor.yy432); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 91: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 92: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 93: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 94: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 95: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 96: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 97: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 98: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_RETENTIONS, yymsp[0].minor.yy432); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 99: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 100: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 101: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 103: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-3].minor.yy448, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 104: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 105: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-3].minor.yy448, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 106: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 107: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 108: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 109: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 110: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 111: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy448 = createAlterDatabaseOptions(pCxt); yylhsminor.yy448 = setAlterDatabaseOption(pCxt, yylhsminor.yy448, &yymsp[0].minor.yy53); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 112: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy448 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy448, &yymsp[0].minor.yy53); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 113: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy53.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 115: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= KEEP integer_list */
      case 118: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==118);
{ yymsp[-1].minor.yy53.type = DB_OPTION_KEEP; yymsp[-1].minor.yy53.pList = yymsp[0].minor.yy432; }
        break;
      case 119: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_PAGES; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 121: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_WAL; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 122: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 123: /* alter_db_option ::= MINROWS NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_MINROWS; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 124: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 125: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy53.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-2].minor.yy53.val = t;
                                                                                  }
        break;
      case 126: /* alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 127: /* alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy53.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-2].minor.yy53.val = t;
                                                                                  }
        break;
      case 128: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy432 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy432 = yylhsminor.yy432;
        break;
      case 129: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 351: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==351);
{ yylhsminor.yy432 = addNodeToList(pCxt, yymsp[-2].minor.yy432, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy432 = yylhsminor.yy432;
        break;
      case 130: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy432 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy432 = yylhsminor.yy432;
        break;
      case 131: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy432 = addNodeToList(pCxt, yymsp[-2].minor.yy432, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy432 = yylhsminor.yy432;
        break;
      case 132: /* retention_list ::= retention */
      case 162: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==162);
      case 165: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==165);
      case 172: /* column_def_list ::= column_def */ yytestcase(yyruleno==172);
      case 215: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==215);
      case 220: /* col_name_list ::= col_name */ yytestcase(yyruleno==220);
      case 271: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==271);
      case 285: /* func_list ::= func */ yytestcase(yyruleno==285);
      case 380: /* literal_list ::= signed_literal */ yytestcase(yyruleno==380);
      case 447: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==447);
      case 453: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==453);
      case 508: /* select_list ::= select_item */ yytestcase(yyruleno==508);
      case 519: /* partition_list ::= partition_item */ yytestcase(yyruleno==519);
      case 574: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==574);
{ yylhsminor.yy432 = createNodeList(pCxt, yymsp[0].minor.yy448); }
  yymsp[0].minor.yy432 = yylhsminor.yy432;
        break;
      case 133: /* retention_list ::= retention_list NK_COMMA retention */
      case 166: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==166);
      case 173: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==173);
      case 216: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==216);
      case 221: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==221);
      case 272: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==272);
      case 286: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==286);
      case 381: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==381);
      case 448: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==448);
      case 509: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==509);
      case 520: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==520);
      case 575: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==575);
{ yylhsminor.yy432 = addNodeToList(pCxt, yymsp[-2].minor.yy432, yymsp[0].minor.yy448); }
  yymsp[-2].minor.yy432 = yylhsminor.yy432;
        break;
      case 134: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy448 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 135: /* speed_opt ::= */
      case 318: /* bufsize_opt ::= */ yytestcase(yyruleno==318);
{ yymsp[1].minor.yy788 = 0; }
        break;
      case 136: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 319: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==319);
{ yymsp[-1].minor.yy788 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 138: /* start_opt ::= START WITH NK_INTEGER */
      case 142: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==142);
{ yymsp[-2].minor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 139: /* start_opt ::= START WITH NK_STRING */
      case 143: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==143);
{ yymsp[-2].minor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 140: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 144: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==144);
{ yymsp[-3].minor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 145: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 147: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==147);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy369, yymsp[-5].minor.yy448, yymsp[-3].minor.yy432, yymsp[-1].minor.yy432, yymsp[0].minor.yy448); }
        break;
      case 146: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy432); }
        break;
      case 148: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy432); }
        break;
      case 149: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy369, yymsp[0].minor.yy448); }
        break;
      case 150: /* cmd ::= ALTER TABLE alter_table_clause */
      case 353: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==353);
      case 354: /* cmd ::= insert_query */ yytestcase(yyruleno==354);
{ pCxt->pRootNode = yymsp[0].minor.yy448; }
        break;
      case 151: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy448); }
        break;
      case 152: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy448 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy448, yymsp[0].minor.yy448); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 153: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy448 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy448, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy113, yymsp[0].minor.yy728); }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 154: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy448 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy448, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy113); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 155: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy448 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy448, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy113, yymsp[0].minor.yy728); }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 156: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy448 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy448, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy113, &yymsp[0].minor.yy113); }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 157: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy448 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy448, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy113, yymsp[0].minor.yy728); }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 158: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy448 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy448, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy113); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 159: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy448 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy448, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy113, yymsp[0].minor.yy728); }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 160: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy448 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy448, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy113, &yymsp[0].minor.yy113); }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 161: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy448 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy448, &yymsp[-2].minor.yy113, yymsp[0].minor.yy448); }
  yymsp[-5].minor.yy448 = yylhsminor.yy448;
        break;
      case 163: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 454: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==454);
{ yylhsminor.yy432 = addNodeToList(pCxt, yymsp[-1].minor.yy432, yymsp[0].minor.yy448); }
  yymsp[-1].minor.yy432 = yylhsminor.yy432;
        break;
      case 164: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy448 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy369, yymsp[-8].minor.yy448, yymsp[-6].minor.yy448, yymsp[-5].minor.yy432, yymsp[-2].minor.yy432, yymsp[0].minor.yy448); }
  yymsp[-9].minor.yy448 = yylhsminor.yy448;
        break;
      case 167: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy448 = createDropTableClause(pCxt, yymsp[-1].minor.yy369, yymsp[0].minor.yy448); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 168: /* specific_cols_opt ::= */
      case 198: /* tags_def_opt ::= */ yytestcase(yyruleno==198);
      case 270: /* tag_list_opt ::= */ yytestcase(yyruleno==270);
      case 326: /* col_list_opt ::= */ yytestcase(yyruleno==326);
      case 328: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==328);
      case 517: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==517);
      case 542: /* group_by_clause_opt ::= */ yytestcase(yyruleno==542);
      case 561: /* order_by_clause_opt ::= */ yytestcase(yyruleno==561);
{ yymsp[1].minor.yy432 = NULL; }
        break;
      case 169: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 327: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==327);
{ yymsp[-2].minor.yy432 = yymsp[-1].minor.yy432; }
        break;
      case 170: /* full_table_name ::= table_name */
{ yylhsminor.yy448 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy113, NULL); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 171: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy448 = createRealTableNode(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy113, NULL); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 174: /* column_def ::= column_name type_name */
{ yylhsminor.yy448 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy113, yymsp[0].minor.yy728, NULL); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 175: /* type_name ::= BOOL */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 176: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 177: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 178: /* type_name ::= INT */
      case 179: /* type_name ::= INTEGER */ yytestcase(yyruleno==179);
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 180: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 181: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 182: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 183: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy728 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 184: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 185: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy728 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 186: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy728 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 187: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy728 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 188: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy728 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 189: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy728 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 190: /* type_name ::= JSON */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 191: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy728 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 192: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 193: /* type_name ::= BLOB */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 194: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy728 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 195: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 196: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy728 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 197: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy728 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 199: /* tags_def_opt ::= tags_def */
      case 329: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==329);
      case 446: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==446);
{ yylhsminor.yy432 = yymsp[0].minor.yy432; }
  yymsp[0].minor.yy432 = yylhsminor.yy432;
        break;
      case 200: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 330: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==330);
{ yymsp[-3].minor.yy432 = yymsp[-1].minor.yy432; }
        break;
      case 201: /* table_options ::= */
{ yymsp[1].minor.yy448 = createDefaultTableOptions(pCxt); }
        break;
      case 202: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy448 = setTableOption(pCxt, yymsp[-2].minor.yy448, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 203: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy448 = setTableOption(pCxt, yymsp[-2].minor.yy448, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy432); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 204: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy448 = setTableOption(pCxt, yymsp[-2].minor.yy448, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy432); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 205: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy448 = setTableOption(pCxt, yymsp[-4].minor.yy448, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy432); }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 206: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy448 = setTableOption(pCxt, yymsp[-2].minor.yy448, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 207: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy448 = setTableOption(pCxt, yymsp[-4].minor.yy448, TABLE_OPTION_SMA, yymsp[-1].minor.yy432); }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 208: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy448 = setTableOption(pCxt, yymsp[-2].minor.yy448, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy432); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 209: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy448 = createAlterTableOptions(pCxt); yylhsminor.yy448 = setTableOption(pCxt, yylhsminor.yy448, yymsp[0].minor.yy53.type, &yymsp[0].minor.yy53.val); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 210: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy448 = setTableOption(pCxt, yymsp[-1].minor.yy448, yymsp[0].minor.yy53.type, &yymsp[0].minor.yy53.val); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 211: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy53.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 212: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy53.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 213: /* duration_list ::= duration_literal */
      case 410: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==410);
{ yylhsminor.yy432 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy448)); }
  yymsp[0].minor.yy432 = yylhsminor.yy432;
        break;
      case 214: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 411: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==411);
{ yylhsminor.yy432 = addNodeToList(pCxt, yymsp[-2].minor.yy432, releaseRawExprNode(pCxt, yymsp[0].minor.yy448)); }
  yymsp[-2].minor.yy432 = yylhsminor.yy432;
        break;
      case 217: /* rollup_func_name ::= function_name */
{ yylhsminor.yy448 = createFunctionNode(pCxt, &yymsp[0].minor.yy113, NULL); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 218: /* rollup_func_name ::= FIRST */
      case 219: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==219);
      case 274: /* tag_item ::= QTAGS */ yytestcase(yyruleno==274);
{ yylhsminor.yy448 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 222: /* col_name ::= column_name */
      case 275: /* tag_item ::= column_name */ yytestcase(yyruleno==275);
{ yylhsminor.yy448 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy113); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 223: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 224: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 225: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 226: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 227: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy448, yymsp[0].minor.yy448, OP_TYPE_LIKE); }
        break;
      case 228: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy448, yymsp[0].minor.yy448, OP_TYPE_LIKE); }
        break;
      case 229: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy448, NULL, OP_TYPE_LIKE); }
        break;
      case 230: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 231: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 232: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 233: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy448, yymsp[-1].minor.yy448, OP_TYPE_EQUAL); }
        break;
      case 234: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 235: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 236: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 237: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 238: /* cmd ::= SHOW LICENCES */
      case 239: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==239);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 240: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy113); }
        break;
      case 241: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy448); }
        break;
      case 242: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy448); }
        break;
      case 243: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 244: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 245: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 246: /* cmd ::= SHOW VARIABLES */
      case 247: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==247);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 248: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 249: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy448); }
        break;
      case 250: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 251: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 252: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 253: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 254: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy448); }
        break;
      case 255: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 256: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 257: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy448, yymsp[-1].minor.yy448, OP_TYPE_EQUAL); }
        break;
      case 258: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy448, yymsp[0].minor.yy448, yymsp[-3].minor.yy432); }
        break;
      case 259: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 260: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 261: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy448,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 262: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 263: /* db_name_cond_opt ::= */
      case 268: /* from_db_opt ::= */ yytestcase(yyruleno==268);
{ yymsp[1].minor.yy448 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 264: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy448 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy113); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 266: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 267: /* table_name_cond ::= table_name */
{ yylhsminor.yy448 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy113); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 269: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy448 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy113); }
        break;
      case 273: /* tag_item ::= TBNAME */
{ yylhsminor.yy448 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 276: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy448 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy113), &yymsp[0].minor.yy113); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 277: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy448 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy113), &yymsp[0].minor.yy113); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 278: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy369, yymsp[-3].minor.yy448, yymsp[-1].minor.yy448, NULL, yymsp[0].minor.yy448); }
        break;
      case 279: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy369, yymsp[-5].minor.yy448, yymsp[-3].minor.yy448, yymsp[-1].minor.yy432, NULL); }
        break;
      case 280: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy369, yymsp[0].minor.yy448); }
        break;
      case 281: /* full_index_name ::= index_name */
{ yylhsminor.yy448 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy113); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 282: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy448 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy113); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 283: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy448 = createIndexOption(pCxt, yymsp[-7].minor.yy432, releaseRawExprNode(pCxt, yymsp[-3].minor.yy448), NULL, yymsp[-1].minor.yy448, yymsp[0].minor.yy448); }
        break;
      case 284: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy448 = createIndexOption(pCxt, yymsp[-9].minor.yy432, releaseRawExprNode(pCxt, yymsp[-5].minor.yy448), releaseRawExprNode(pCxt, yymsp[-3].minor.yy448), yymsp[-1].minor.yy448, yymsp[0].minor.yy448); }
        break;
      case 287: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy448 = createFunctionNode(pCxt, &yymsp[-3].minor.yy113, yymsp[-1].minor.yy432); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 288: /* sma_func_name ::= function_name */
      case 497: /* alias_opt ::= table_alias */ yytestcase(yyruleno==497);
{ yylhsminor.yy113 = yymsp[0].minor.yy113; }
  yymsp[0].minor.yy113 = yylhsminor.yy113;
        break;
      case 293: /* sma_stream_opt ::= */
      case 331: /* stream_options ::= */ yytestcase(yyruleno==331);
{ yymsp[1].minor.yy448 = createStreamOptions(pCxt); }
        break;
      case 294: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy448)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy448); yylhsminor.yy448 = yymsp[-2].minor.yy448; }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 295: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy448)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy448); yylhsminor.yy448 = yymsp[-2].minor.yy448; }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 296: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy448)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy448); yylhsminor.yy448 = yymsp[-2].minor.yy448; }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 297: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy369, &yymsp[-2].minor.yy113, yymsp[0].minor.yy448); }
        break;
      case 298: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy369, &yymsp[-3].minor.yy113, &yymsp[0].minor.yy113, false); }
        break;
      case 299: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy369, &yymsp[-5].minor.yy113, &yymsp[0].minor.yy113, true); }
        break;
      case 300: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy369, &yymsp[-3].minor.yy113, yymsp[0].minor.yy448, false); }
        break;
      case 301: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy369, &yymsp[-5].minor.yy113, yymsp[0].minor.yy448, true); }
        break;
      case 302: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy369, &yymsp[0].minor.yy113); }
        break;
      case 303: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy369, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy113); }
        break;
      case 304: /* cmd ::= DESC full_table_name */
      case 305: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==305);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy448); }
        break;
      case 306: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 307: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 308: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==308);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy369, yymsp[-1].minor.yy448, yymsp[0].minor.yy448); }
        break;
      case 311: /* explain_options ::= */
{ yymsp[1].minor.yy448 = createDefaultExplainOptions(pCxt); }
        break;
      case 312: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy448 = setExplainVerbose(pCxt, yymsp[-2].minor.yy448, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 313: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy448 = setExplainRatio(pCxt, yymsp[-2].minor.yy448, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 314: /* cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy369, yymsp[-9].minor.yy369, &yymsp[-6].minor.yy113, &yymsp[-4].minor.yy0, yymsp[-2].minor.yy728, yymsp[-1].minor.yy788, &yymsp[0].minor.yy113, yymsp[-10].minor.yy369); }
        break;
      case 315: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy369, &yymsp[0].minor.yy113); }
        break;
      case 320: /* language_opt ::= */
{ yymsp[1].minor.yy113 = nil_token; }
        break;
      case 321: /* language_opt ::= LANGUAGE NK_STRING */
{ yymsp[-1].minor.yy113 = yymsp[0].minor.yy0; }
        break;
      case 324: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy369, &yymsp[-8].minor.yy113, yymsp[-5].minor.yy448, yymsp[-7].minor.yy448, yymsp[-3].minor.yy432, yymsp[-2].minor.yy448, yymsp[0].minor.yy448, yymsp[-4].minor.yy432); }
        break;
      case 325: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy369, &yymsp[0].minor.yy113); }
        break;
      case 332: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 333: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==333);
{ yylhsminor.yy448 = setStreamOptions(pCxt, yymsp[-2].minor.yy448, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 334: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ yylhsminor.yy448 = setStreamOptions(pCxt, yymsp[-3].minor.yy448, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy448)); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 335: /* stream_options ::= stream_options WATERMARK duration_literal */
{ yylhsminor.yy448 = setStreamOptions(pCxt, yymsp[-2].minor.yy448, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy448)); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 336: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ yylhsminor.yy448 = setStreamOptions(pCxt, yymsp[-3].minor.yy448, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 337: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ yylhsminor.yy448 = setStreamOptions(pCxt, yymsp[-2].minor.yy448, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 338: /* stream_options ::= stream_options DELETE_MARK duration_literal */
{ yylhsminor.yy448 = setStreamOptions(pCxt, yymsp[-2].minor.yy448, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy448)); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 339: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ yylhsminor.yy448 = setStreamOptions(pCxt, yymsp[-3].minor.yy448, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 341: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 531: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==531);
      case 551: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==551);
{ yymsp[-3].minor.yy448 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy448); }
        break;
      case 342: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 343: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 344: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 345: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 346: /* cmd ::= BALANCE VGROUP LEADER */
{ pCxt->pRootNode = createBalanceVgroupLeaderStmt(pCxt); }
        break;
      case 347: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 348: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy432); }
        break;
      case 349: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 350: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy432 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 352: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy448, yymsp[0].minor.yy448); }
        break;
      case 355: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy448 = createInsertStmt(pCxt, yymsp[-4].minor.yy448, yymsp[-2].minor.yy432, yymsp[0].minor.yy448); }
        break;
      case 356: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy448 = createInsertStmt(pCxt, yymsp[-1].minor.yy448, NULL, yymsp[0].minor.yy448); }
        break;
      case 357: /* literal ::= NK_INTEGER */
{ yylhsminor.yy448 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 358: /* literal ::= NK_FLOAT */
{ yylhsminor.yy448 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 359: /* literal ::= NK_STRING */
{ yylhsminor.yy448 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 360: /* literal ::= NK_BOOL */
{ yylhsminor.yy448 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 361: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 362: /* literal ::= duration_literal */
      case 372: /* signed_literal ::= signed */ yytestcase(yyruleno==372);
      case 393: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==393);
      case 394: /* expression ::= literal */ yytestcase(yyruleno==394);
      case 395: /* expression ::= pseudo_column */ yytestcase(yyruleno==395);
      case 396: /* expression ::= column_reference */ yytestcase(yyruleno==396);
      case 397: /* expression ::= function_expression */ yytestcase(yyruleno==397);
      case 398: /* expression ::= case_when_expression */ yytestcase(yyruleno==398);
      case 429: /* function_expression ::= literal_func */ yytestcase(yyruleno==429);
      case 478: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==478);
      case 482: /* boolean_primary ::= predicate */ yytestcase(yyruleno==482);
      case 484: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==484);
      case 485: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==485);
      case 488: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==488);
      case 490: /* table_reference ::= table_primary */ yytestcase(yyruleno==490);
      case 491: /* table_reference ::= joined_table */ yytestcase(yyruleno==491);
      case 495: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==495);
      case 553: /* query_simple ::= query_specification */ yytestcase(yyruleno==553);
      case 554: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==554);
      case 557: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==557);
      case 559: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==559);
{ yylhsminor.yy448 = yymsp[0].minor.yy448; }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 363: /* literal ::= NULL */
{ yylhsminor.yy448 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 364: /* literal ::= NK_QUESTION */
{ yylhsminor.yy448 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 365: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy448 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 366: /* signed ::= NK_INTEGER */
{ yylhsminor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 367: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 368: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 369: /* signed ::= NK_FLOAT */
{ yylhsminor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 370: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 371: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 373: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 374: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 375: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 376: /* signed_literal ::= duration_literal */
      case 378: /* signed_literal ::= literal_func */ yytestcase(yyruleno==378);
      case 449: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==449);
      case 511: /* select_item ::= common_expression */ yytestcase(yyruleno==511);
      case 521: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==521);
      case 558: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==558);
      case 560: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==560);
      case 573: /* search_condition ::= common_expression */ yytestcase(yyruleno==573);
{ yylhsminor.yy448 = releaseRawExprNode(pCxt, yymsp[0].minor.yy448); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 377: /* signed_literal ::= NULL */
{ yylhsminor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 379: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy448 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 399: /* expression ::= NK_LP expression NK_RP */
      case 483: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==483);
      case 572: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==572);
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy448)); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 400: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy448));
                                                                                  }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 401: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy448), NULL));
                                                                                  }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 402: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448))); 
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 403: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448))); 
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 404: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448))); 
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 405: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448))); 
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 406: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448)));
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 407: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 408: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448)));
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 409: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448)));
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 412: /* column_reference ::= column_name */
{ yylhsminor.yy448 = createRawExprNode(pCxt, &yymsp[0].minor.yy113, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy113)); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 413: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy113, createColumnNode(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy113)); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 414: /* pseudo_column ::= ROWTS */
      case 415: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==415);
      case 417: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==417);
      case 418: /* pseudo_column ::= QEND */ yytestcase(yyruleno==418);
      case 419: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==419);
      case 420: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==420);
      case 421: /* pseudo_column ::= WEND */ yytestcase(yyruleno==421);
      case 422: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==422);
      case 423: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==423);
      case 424: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==424);
      case 425: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==425);
      case 431: /* literal_func ::= NOW */ yytestcase(yyruleno==431);
{ yylhsminor.yy448 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 416: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy113)))); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 426: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 427: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==427);
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy113, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy113, yymsp[-1].minor.yy432)); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 428: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy448), yymsp[-1].minor.yy728)); }
  yymsp[-5].minor.yy448 = yylhsminor.yy448;
        break;
      case 430: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy113, NULL)); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 445: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy432 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy432 = yylhsminor.yy432;
        break;
      case 450: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 514: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==514);
{ yylhsminor.yy448 = createColumnNode(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 451: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy432, yymsp[-1].minor.yy448)); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 452: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy448), yymsp[-2].minor.yy432, yymsp[-1].minor.yy448)); }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 455: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy448 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448)); }
        break;
      case 457: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy448 = releaseRawExprNode(pCxt, yymsp[0].minor.yy448); }
        break;
      case 458: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 463: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==463);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy156, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448)));
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 459: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy448), releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448)));
                                                                                  }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 460: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy448), releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448)));
                                                                                  }
  yymsp[-5].minor.yy448 = yylhsminor.yy448;
        break;
      case 461: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), NULL));
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 462: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy448), NULL));
                                                                                  }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 464: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy156 = OP_TYPE_LOWER_THAN; }
        break;
      case 465: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy156 = OP_TYPE_GREATER_THAN; }
        break;
      case 466: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy156 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 467: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy156 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 468: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy156 = OP_TYPE_NOT_EQUAL; }
        break;
      case 469: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy156 = OP_TYPE_EQUAL; }
        break;
      case 470: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy156 = OP_TYPE_LIKE; }
        break;
      case 471: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy156 = OP_TYPE_NOT_LIKE; }
        break;
      case 472: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy156 = OP_TYPE_MATCH; }
        break;
      case 473: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy156 = OP_TYPE_NMATCH; }
        break;
      case 474: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy156 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 475: /* in_op ::= IN */
{ yymsp[0].minor.yy156 = OP_TYPE_IN; }
        break;
      case 476: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy156 = OP_TYPE_NOT_IN; }
        break;
      case 477: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy432)); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 479: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy448), NULL));
                                                                                  }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 480: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448)));
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 481: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448)));
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 489: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy448 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy448, yymsp[0].minor.yy448, NULL); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 492: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy448 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy113, &yymsp[0].minor.yy113); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 493: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy448 = createRealTableNode(pCxt, &yymsp[-3].minor.yy113, &yymsp[-1].minor.yy113, &yymsp[0].minor.yy113); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 494: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy448 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy448), &yymsp[0].minor.yy113); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 496: /* alias_opt ::= */
{ yymsp[1].minor.yy113 = nil_token;  }
        break;
      case 498: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy113 = yymsp[0].minor.yy113; }
        break;
      case 499: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 500: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==500);
{ yymsp[-2].minor.yy448 = yymsp[-1].minor.yy448; }
        break;
      case 501: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy448 = createJoinTableNode(pCxt, yymsp[-4].minor.yy596, yymsp[-5].minor.yy448, yymsp[-2].minor.yy448, yymsp[0].minor.yy448); }
  yymsp[-5].minor.yy448 = yylhsminor.yy448;
        break;
      case 502: /* join_type ::= */
{ yymsp[1].minor.yy596 = JOIN_TYPE_INNER; }
        break;
      case 503: /* join_type ::= INNER */
{ yymsp[0].minor.yy596 = JOIN_TYPE_INNER; }
        break;
      case 504: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy448 = createSelectStmt(pCxt, yymsp[-10].minor.yy369, yymsp[-9].minor.yy432, yymsp[-8].minor.yy448);
                                                                                    yymsp[-11].minor.yy448 = addWhereClause(pCxt, yymsp[-11].minor.yy448, yymsp[-7].minor.yy448);
                                                                                    yymsp[-11].minor.yy448 = addPartitionByClause(pCxt, yymsp[-11].minor.yy448, yymsp[-6].minor.yy432);
                                                                                    yymsp[-11].minor.yy448 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy448, yymsp[-2].minor.yy448);
                                                                                    yymsp[-11].minor.yy448 = addGroupByClause(pCxt, yymsp[-11].minor.yy448, yymsp[-1].minor.yy432);
                                                                                    yymsp[-11].minor.yy448 = addHavingClause(pCxt, yymsp[-11].minor.yy448, yymsp[0].minor.yy448);
                                                                                    yymsp[-11].minor.yy448 = addRangeClause(pCxt, yymsp[-11].minor.yy448, yymsp[-5].minor.yy448);
                                                                                    yymsp[-11].minor.yy448 = addEveryClause(pCxt, yymsp[-11].minor.yy448, yymsp[-4].minor.yy448);
                                                                                    yymsp[-11].minor.yy448 = addFillClause(pCxt, yymsp[-11].minor.yy448, yymsp[-3].minor.yy448);
                                                                                  }
        break;
      case 507: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy369 = false; }
        break;
      case 510: /* select_item ::= NK_STAR */
{ yylhsminor.yy448 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 512: /* select_item ::= common_expression column_alias */
      case 522: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==522);
{ yylhsminor.yy448 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy448), &yymsp[0].minor.yy113); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 513: /* select_item ::= common_expression AS column_alias */
      case 523: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==523);
{ yylhsminor.yy448 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), &yymsp[0].minor.yy113); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 518: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 543: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==543);
      case 562: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==562);
{ yymsp[-2].minor.yy432 = yymsp[0].minor.yy432; }
        break;
      case 525: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy448 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy448), releaseRawExprNode(pCxt, yymsp[-1].minor.yy448)); }
        break;
      case 526: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy448 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy448)); }
        break;
      case 527: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy448 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy448), NULL, yymsp[-1].minor.yy448, yymsp[0].minor.yy448); }
        break;
      case 528: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy448 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy448), releaseRawExprNode(pCxt, yymsp[-3].minor.yy448), yymsp[-1].minor.yy448, yymsp[0].minor.yy448); }
        break;
      case 529: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy448 = createEventWindowNode(pCxt, yymsp[-3].minor.yy448, yymsp[0].minor.yy448); }
        break;
      case 533: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy448 = createFillNode(pCxt, yymsp[-1].minor.yy46, NULL); }
        break;
      case 534: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy448 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy432)); }
        break;
      case 535: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy448 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy432)); }
        break;
      case 536: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy46 = FILL_MODE_NONE; }
        break;
      case 537: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy46 = FILL_MODE_PREV; }
        break;
      case 538: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy46 = FILL_MODE_NULL; }
        break;
      case 539: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy46 = FILL_MODE_NULL_F; }
        break;
      case 540: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy46 = FILL_MODE_LINEAR; }
        break;
      case 541: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy46 = FILL_MODE_NEXT; }
        break;
      case 544: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy432 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy448))); }
  yymsp[0].minor.yy432 = yylhsminor.yy432;
        break;
      case 545: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy432 = addNodeToList(pCxt, yymsp[-2].minor.yy432, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy448))); }
  yymsp[-2].minor.yy432 = yylhsminor.yy432;
        break;
      case 549: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy448 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy448), releaseRawExprNode(pCxt, yymsp[-1].minor.yy448)); }
        break;
      case 552: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy448 = addOrderByClause(pCxt, yymsp[-3].minor.yy448, yymsp[-2].minor.yy432);
                                                                                    yylhsminor.yy448 = addSlimitClause(pCxt, yylhsminor.yy448, yymsp[-1].minor.yy448);
                                                                                    yylhsminor.yy448 = addLimitClause(pCxt, yylhsminor.yy448, yymsp[0].minor.yy448);
                                                                                  }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 555: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy448 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy448, yymsp[0].minor.yy448); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 556: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy448 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy448, yymsp[0].minor.yy448); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 564: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 568: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==568);
{ yymsp[-1].minor.yy448 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 565: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 569: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==569);
{ yymsp[-3].minor.yy448 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 566: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 570: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==570);
{ yymsp[-3].minor.yy448 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 571: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy448); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 576: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy448 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), yymsp[-1].minor.yy666, yymsp[0].minor.yy585); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 577: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy666 = ORDER_ASC; }
        break;
      case 578: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy666 = ORDER_ASC; }
        break;
      case 579: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy666 = ORDER_DESC; }
        break;
      case 580: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy585 = NULL_ORDER_DEFAULT; }
        break;
      case 581: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy585 = NULL_ORDER_FIRST; }
        break;
      case 582: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy585 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
