/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 358
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy14;
  ENullOrder yy17;
  SNodeList* yy60;
  SToken yy105;
  int32_t yy140;
  SNode* yy172;
  EFillMode yy202;
  SDataType yy248;
  EOperatorType yy572;
  int64_t yy593;
  SAlterOption yy609;
  bool yy617;
  EJoinType yy636;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             615
#define YYNRULE              452
#define YYNTOKEN             238
#define YY_MAX_SHIFT         614
#define YY_MIN_SHIFTREDUCE   901
#define YY_MAX_SHIFTREDUCE   1352
#define YY_ERROR_ACTION      1353
#define YY_ACCEPT_ACTION     1354
#define YY_NO_ACTION         1355
#define YY_MIN_REDUCE        1356
#define YY_MAX_REDUCE        1807
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2165)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */    72,  354, 1654, 1641,   28,  230,  296, 1464, 1641,  607,
 /*    10 */   606,  313,   35,   33,  529,   36,   34,   32,   31,   30,
 /*    20 */   305, 1480, 1166, 1638,  529,  489,  106, 1476, 1638,  388,
 /*    30 */  1670,  389, 1388,  427,  489,  277,  152,  348,  513, 1634,
 /*    40 */  1640,  528,  133, 1487, 1634, 1640, 1444, 1164,  512,  132,
 /*    50 */   532, 1368, 1624, 1487,  114,  532,  528,  493,   14,  529,
 /*    60 */    35,   33, 1293,  114, 1172, 1415,  931,   63,  305, 1683,
 /*    70 */  1166,  352,   82, 1655,  515, 1657, 1658,  511, 1785,  532,
 /*    80 */   110,    1, 1723,   56, 1531, 1307,  278, 1719, 1487, 1482,
 /*    90 */   147,  295,  112,  516, 1782, 1164, 1529,  528, 1785, 1577,
 /*   100 */   563,  112,   39,  611,  935,  936,   14,  145, 1730, 1731,
 /*   110 */   149, 1735, 1172, 1165, 1782,  491,  144, 1730, 1731,  562,
 /*   120 */  1735,  561,  560,  559,  406,  587,  586,  585,  320,    2,
 /*   130 */   584,  583,  582,  116,  577,  576,  575,  574,  573,  572,
 /*   140 */   571,  570,  123,  566, 1357,   36,   34,   32,   31,   30,
 /*   150 */   396,  611,  389, 1388,  142,  317, 1167, 1190,   38, 1670,
 /*   160 */    55, 1165, 1567, 1569, 1465,   96, 1525,  482,   95,   94,
 /*   170 */    93,   92,   91,   90,   89,   88,   87,  478,  387, 1170,
 /*   180 */  1171,  391, 1217, 1218, 1220, 1221, 1222, 1223, 1224,  508,
 /*   190 */   530, 1232, 1233, 1234, 1235, 1236, 1237,   36,   34,   32,
 /*   200 */    31,   30,  516,  481, 1167,  308,  580,   96, 1576,  150,
 /*   210 */    95,   94,   93,   92,   91,   90,   89,   88,   87,  288,
 /*   220 */   130,  406,   36,   34,   32,   31,   30, 1170, 1171, 1490,
 /*   230 */  1217, 1218, 1220, 1221, 1222, 1223, 1224,  508,  530, 1232,
 /*   240 */  1233, 1234, 1235, 1236, 1237,   35,   33,  342,  484,  479,
 /*   250 */  1354,  441,  440,  305, 1654, 1166,  439,  200,  252,  111,
 /*   260 */   436, 1517,  378,  435,  434,  433,   35,   33,  289,  446,
 /*   270 */   287,  286, 1000,  429,  305, 1478, 1166,  431,  129,  309,
 /*   280 */  1164,   79, 1670,   55,  454,   66,  150,  130,  150, 1002,
 /*   290 */   513,   14, 1204,  483,  115, 1638, 1489, 1172,  193,  430,
 /*   300 */   512, 1164, 1479,  948, 1624,  947,  161,  160,  321,  493,
 /*   310 */   449, 1634, 1640,  393,    2,  443, 1191, 1642, 1172, 1188,
 /*   320 */   192, 1683,  532,  489,   82, 1655,  515, 1657, 1658,  511,
 /*   330 */    24,  532,  949, 1349, 1723,    8,  611, 1638,  278, 1719,
 /*   340 */    36,   34,   32,   31,   30,   51, 1165, 1463,   50, 1785,
 /*   350 */  1785,  565,  114, 1634, 1640,   65,  294,  611, 1379,  194,
 /*   360 */   558,  147,  147, 1462,  532, 1782, 1782, 1165, 1356, 1038,
 /*   370 */   555,  554,  553, 1042,  552, 1044, 1045,  551, 1047,  548,
 /*   380 */  1378, 1053,  545, 1055, 1056,  542,  539,    7,   55, 1167,
 /*   390 */   112, 1189,  105,  104,  103,  102,  101,  100,   99,   98,
 /*   400 */    97,   32,   31,   30,  565,  146, 1730, 1731, 1624, 1735,
 /*   410 */  1167,  150, 1170, 1171, 1348, 1217, 1218, 1220, 1221, 1222,
 /*   420 */  1223, 1224,  508,  530, 1232, 1233, 1234, 1235, 1236, 1237,
 /*   430 */  1624,  568,  157, 1170, 1171,  462, 1217, 1218, 1220, 1221,
 /*   440 */  1222, 1223, 1224,  508,  530, 1232, 1233, 1234, 1235, 1236,
 /*   450 */  1237,   35,   33, 1238,   26, 1377,  563,   61,  465,  305,
 /*   460 */    60, 1166,  563,  150,   36,   34,   32,   31,   30,   63,
 /*   470 */  1405,  395,   35,   33,  391,  562, 1654,  561,  560,  559,
 /*   480 */   305,  562, 1166,  561,  560,  559, 1164, 1192,  529, 1317,
 /*   490 */   529, 1483,  442,   36,   34,   32,   31,   30, 1785, 1785,
 /*   500 */   353, 1644,  106, 1172, 1670, 1624, 1472, 1164,   55,  432,
 /*   510 */  1784,  147,  492,  455, 1782, 1782,  150, 1487, 1376, 1487,
 /*   520 */     9,  569,  512, 1459, 1172, 1418, 1624,  453,  475, 1315,
 /*   530 */  1316, 1318, 1319,   36,   34,   32,   31,   30, 1646,  279,
 /*   540 */   451,    9,  611, 1683,  438,  437,   83, 1655,  515, 1657,
 /*   550 */  1658,  511, 1165,  532, 1785, 1474, 1723, 1531, 1288,  315,
 /*   560 */   298, 1719,  143,  611,  310, 1785,  147,  130, 1624, 1529,
 /*   570 */  1782, 1255, 1300, 1165,  222, 1785, 1489,  148, 1190,  471,
 /*   580 */  1750, 1782,  347, 1737,  346,  441,  440, 1783,  529,  339,
 /*   590 */   439, 1782, 1531,  111,  436, 1167, 1531,  435,  434,  433,
 /*   600 */   363,  581,  579,  316, 1530, 1568, 1569, 1734, 1529,  341,
 /*   610 */   337, 1292,  221, 1375,  935,  936, 1167, 1487, 1170, 1171,
 /*   620 */  1256, 1217, 1218, 1220, 1221, 1222, 1223, 1224,  508,  530,
 /*   630 */  1232, 1233, 1234, 1235, 1236, 1237,  150,   11,   10, 1170,
 /*   640 */  1171, 1261, 1217, 1218, 1220, 1221, 1222, 1223, 1224,  508,
 /*   650 */   530, 1232, 1233, 1234, 1235, 1236, 1237,   35,   33,  276,
 /*   660 */  1654, 1188,  529, 1624,  529,  305, 1374, 1166,  371,   54,
 /*   670 */  1373,  383, 1372, 1470,  364,  197,  405,  507,   27,  303,
 /*   680 */  1250, 1251, 1252, 1253, 1254, 1258, 1259, 1260, 1670,  384,
 /*   690 */   529, 1487, 1164, 1487, 1243,  529,  513, 1371, 1564,  529,
 /*   700 */  1190,  431, 1484, 1370,  318,  159,  512, 1603, 1190, 1172,
 /*   710 */  1624,  463,  130,  529, 1150, 1151, 1624, 1193, 1269, 1487,
 /*   720 */  1624, 1489, 1624,  430, 1487,  526,    2, 1683, 1487, 1257,
 /*   730 */    83, 1655,  515, 1657, 1658,  511,  947,  532, 1367, 1366,
 /*   740 */  1723, 1219, 1487,  497,  298, 1719, 1798, 1624,  611,  120,
 /*   750 */  1262, 1742, 1288, 1624, 1365, 1757, 1364, 1363, 1165,  382,
 /*   760 */  1362,  425,  377,  376,  375,  374,  373,  370,  369,  368,
 /*   770 */   367,  366,  362,  361,  360,  359,  358,  357,  356,  355,
 /*   780 */   529,  131,  529,  529, 1737, 1369,  258,   25, 1624, 1624,
 /*   790 */   467, 1737,  527, 1361,  243,  319, 1360,  500,  256,   53,
 /*   800 */  1613, 1167,   52, 1359, 1624,  505, 1624, 1624, 1733, 1487,
 /*   810 */  1624, 1487, 1487,  185, 1445, 1732,  183, 1291,  187,  162,
 /*   820 */   189,  186, 1175,  188, 1170, 1171,   46, 1217, 1218, 1220,
 /*   830 */  1221, 1222, 1223, 1224,  508,  530, 1232, 1233, 1234, 1235,
 /*   840 */  1236, 1237,  206, 1624,   55,  327, 1624,   36,   34,   32,
 /*   850 */    31,   30,  191, 1624, 1400,  190, 1166, 1398,  209,   11,
 /*   860 */    10, 1351, 1352, 1219,   46,   37,   37, 1314,   37,  232,
 /*   870 */   557, 1219,  456,  118,  119,   78,  444,  120, 1174,  447,
 /*   880 */    81, 1164,  537,  225,  972,   74,  119,  476, 1178,  120,
 /*   890 */   495,  216, 1671,  279,  121, 1389, 1654, 1526, 1172,  211,
 /*   900 */   424,  973,  119, 1753,  490,  251, 1263, 1225,  322, 1123,
 /*   910 */   234,   59,   58,  351,  521,  240,  156, 1204, 1031, 1188,
 /*   920 */   224,  345,    3, 1059, 1670, 1255, 1247, 1063,  498,  227,
 /*   930 */  1069,  229,  492,  275,    5, 1067,  335,  611,  333,  329,
 /*   940 */   153,  323,  512,  122, 1177,  326, 1624, 1165,  325,  284,
 /*   950 */  1000,  285,  312,  311,  248, 1134,  158,  365, 1566,  372,
 /*   960 */   380,  379, 1180, 1683,  381,  385,   83, 1655,  515, 1657,
 /*   970 */  1658,  511,  150,  532, 1256, 1654, 1723, 1194, 1197,  386,
 /*   980 */   298, 1719,  143,  394,  501,  397,  398, 1173, 1196,  399,
 /*   990 */  1167,  165,  167, 1198,  170, 1261,  172,  403,  400,  402,
 /*  1000 */  1751, 1195,  175, 1670, 1172,   62,  404,  407,  178,  426,
 /*  1010 */  1172,  513,   86, 1170, 1171,  428,  293, 1477, 1607,  182,
 /*  1020 */  1473,  512,  184,  124,  249, 1624,  125, 1475, 1654, 1471,
 /*  1030 */   126,  127,   27,  303, 1250, 1251, 1252, 1253, 1254, 1258,
 /*  1040 */  1259, 1260, 1683,  533,  195,   83, 1655,  515, 1657, 1658,
 /*  1050 */   511,  457,  532, 1176,  198, 1723, 1670,  461,  464,  298,
 /*  1060 */  1719, 1798,  201,  466,  513,  468,  458,  469,  477,  204,
 /*  1070 */  1780, 1193, 1764,  207,  512,  519, 1763,  474, 1624, 1654,
 /*  1080 */   297, 1754,  210,  480,  215,    6,  486, 1744,  473,  217,
 /*  1090 */  1654, 1288,  113, 1192,   40, 1683, 1181,  502,   83, 1655,
 /*  1100 */   515, 1657, 1658,  511, 1738,  532,  218, 1670, 1723,  137,
 /*  1110 */   499,  299,  298, 1719, 1798,  513,   18,  517, 1670, 1184,
 /*  1120 */   518, 1704, 1575, 1741, 1781,  512,  513,  223,  226, 1624,
 /*  1130 */   530, 1232, 1233,  228,  493, 1574,  512, 1801, 1654,  522,
 /*  1140 */  1624,  307,  236,  496,  523,  493, 1683,  238,  503,  263,
 /*  1150 */  1655,  515, 1657, 1658,  511,  524,  532, 1683,  250,   71,
 /*  1160 */   263, 1655,  515, 1657, 1658,  511, 1670,  532, 1488,   73,
 /*  1170 */  1460,  535,  253,  245,  513, 1785,  610,   47, 1654,  255,
 /*  1180 */   136,  264,  274,  265,  512, 1618, 1785,  149, 1624,  257,
 /*  1190 */  1617, 1782,   57, 1616,  324, 1159, 1160,  154,  147,  328,
 /*  1200 */  1612,  330, 1782,  331,  332, 1683, 1670, 1611,   84, 1655,
 /*  1210 */   515, 1657, 1658,  511,  513,  532,  334, 1610, 1723,  336,
 /*  1220 */   180, 1609, 1722, 1719,  512,  338, 1608,  340, 1624,  343,
 /*  1230 */   344, 1137,  141, 1593,  155, 1136, 1587, 1654,  423,  419,
 /*  1240 */   415,  411,  179, 1586,  349, 1683,  350, 1585,   84, 1655,
 /*  1250 */   515, 1657, 1658,  511, 1584,  532, 1106, 1559, 1723,  117,
 /*  1260 */  1541, 1540,  504, 1719, 1558, 1670, 1557,   64, 1556, 1555,
 /*  1270 */   177, 1554, 1553,  510, 1552, 1551, 1550, 1549, 1548, 1547,
 /*  1280 */  1546, 1545, 1544,  512, 1543, 1542, 1539, 1624, 1538, 1654,
 /*  1290 */  1537, 1536, 1108, 1535, 1534, 1533, 1532, 1417, 1654, 1385,
 /*  1300 */   108,  938,  163,  937, 1683, 1384,  140,  272, 1655,  515,
 /*  1310 */  1657, 1658,  511,  509,  532,  506, 1695, 1670, 1601, 1595,
 /*  1320 */  1583,  164,  171, 1582, 1572,  513, 1670,  176, 1466,  168,
 /*  1330 */  1416,  173,  966,  401,  513,  512,  390,  109,  169, 1624,
 /*  1340 */   174, 1414,  392,  410,  512, 1412,  414, 1410, 1624,  408,
 /*  1350 */  1408,  166,  409,  418, 1654,  412, 1683,  413,  417,  134,
 /*  1360 */  1655,  515, 1657, 1658,  511, 1683,  532,  421,   84, 1655,
 /*  1370 */   515, 1657, 1658,  511,  422,  532,  416, 1397, 1723,  614,
 /*  1380 */   420, 1396, 1670, 1720, 1383, 1468, 1073, 1072, 1467,  999,
 /*  1390 */   513,  998,  578,  247,   45,  997,  996,  580,  181,  993,
 /*  1400 */   512,  992,  494, 1799, 1624,  107,  991,  472, 1654, 1406,
 /*  1410 */  1401,  603,  599,  595,  591,  246,  290, 1654,  291,  445,
 /*  1420 */  1399, 1683,  292,  448,  273, 1655,  515, 1657, 1658,  511,
 /*  1430 */  1382,  532, 1381,  450,  452,   85, 1670, 1600, 1144, 1594,
 /*  1440 */    80,  459, 1581,  241,  513, 1670, 1580, 1579, 1571,   67,
 /*  1450 */   203,   15,  208,  513,  512,    4, 1313,   37, 1624,   49,
 /*  1460 */   460,  205,   48,  512,   43, 1306,  213, 1624,  199,   16,
 /*  1470 */  1654,  135,  214,  212,   22, 1683,  525, 1644,  268, 1655,
 /*  1480 */   515, 1657, 1658,  511, 1683,  532,  128,  134, 1655,  515,
 /*  1490 */  1657, 1658,  511,   23,  532,  220,   42,  138, 1670,   68,
 /*  1500 */  1654,  470,   17, 1285,  202, 1337,  513, 1336, 1284,  300,
 /*  1510 */  1341, 1342, 1340, 1331,  301,  485,  512,   10,   19, 1248,
 /*  1520 */  1624,   29, 1142,  302,  196, 1227, 1226,  139, 1670,  151,
 /*  1530 */    12, 1800, 1212, 1570,  514,   20,  510, 1683,   41,  231,
 /*  1540 */   273, 1655,  515, 1657, 1658,  511,  512,  532,   13,   21,
 /*  1550 */  1624, 1311, 1654,  233,  235,   69,  237,   70, 1643, 1686,
 /*  1560 */   520,   74,  239, 1229,  242,  531, 1182, 1683, 1654,   44,
 /*  1570 */   272, 1655,  515, 1657, 1658,  511, 1060,  532,  534, 1696,
 /*  1580 */  1670,  536,  314,  538, 1052, 1057,  540,  541,  513, 1054,
 /*  1590 */   543, 1048,  544,  546,  547,  549, 1670,  550,  512, 1046,
 /*  1600 */  1051, 1050, 1624, 1049,  513,  304, 1037,   75, 1654,   76,
 /*  1610 */  1068,  556,   77, 1066,  512, 1065,  964,  564, 1624, 1683,
 /*  1620 */  1654,  306,  273, 1655,  515, 1657, 1658,  511,  988,  532,
 /*  1630 */  1006,  567,  244,  986,  985, 1683, 1670,  984,  273, 1655,
 /*  1640 */   515, 1657, 1658,  511,  513,  532,  983,  982, 1670,  981,
 /*  1650 */   980,  979, 1003, 1001,  512,  976,  513,  975, 1624,  974,
 /*  1660 */   971,  970,  969, 1413,  588,  589,  512,  590, 1654,  592,
 /*  1670 */  1624, 1411,  594,  593, 1409, 1683,  596,  597,  259, 1655,
 /*  1680 */   515, 1657, 1658,  511,  598,  532, 1407, 1683,  600,  601,
 /*  1690 */   267, 1655,  515, 1657, 1658,  511, 1670,  532,  602, 1395,
 /*  1700 */  1654,  604,  605, 1394,  513, 1380,  608, 1168,  609,  613,
 /*  1710 */   254,  612, 1355, 1355,  512, 1355, 1355, 1355, 1624, 1355,
 /*  1720 */  1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1670, 1355,
 /*  1730 */  1654, 1355, 1355, 1355, 1355, 1683,  513, 1355,  269, 1655,
 /*  1740 */   515, 1657, 1658,  511, 1355,  532,  512, 1355, 1355, 1355,
 /*  1750 */  1624, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1670, 1355,
 /*  1760 */  1355, 1355, 1654, 1355, 1355, 1355,  513, 1683, 1355, 1355,
 /*  1770 */   260, 1655,  515, 1657, 1658,  511,  512,  532, 1654, 1355,
 /*  1780 */  1624, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355,
 /*  1790 */  1670, 1355, 1355, 1355, 1654, 1355, 1355, 1683,  513, 1355,
 /*  1800 */   270, 1655,  515, 1657, 1658,  511, 1670,  532,  512, 1355,
 /*  1810 */  1654, 1355, 1624, 1355,  513, 1355, 1355, 1355, 1355, 1355,
 /*  1820 */  1355, 1355, 1670, 1355,  512, 1355, 1355, 1355, 1624, 1683,
 /*  1830 */   513, 1355,  261, 1655,  515, 1657, 1658,  511, 1670,  532,
 /*  1840 */   512, 1355, 1355, 1355, 1624, 1683,  513, 1355,  271, 1655,
 /*  1850 */   515, 1657, 1658,  511, 1355,  532,  512, 1355, 1355, 1355,
 /*  1860 */  1624, 1683, 1654, 1355,  262, 1655,  515, 1657, 1658,  511,
 /*  1870 */  1355,  532, 1355, 1355, 1355, 1355, 1355, 1683, 1654, 1355,
 /*  1880 */  1666, 1655,  515, 1657, 1658,  511, 1355,  532, 1355, 1355,
 /*  1890 */  1670, 1355, 1355, 1355, 1355, 1355, 1355, 1355,  513, 1355,
 /*  1900 */  1355, 1355, 1355, 1355, 1355, 1355, 1670, 1355,  512, 1355,
 /*  1910 */  1654, 1355, 1624, 1355,  513, 1355, 1355, 1355, 1355, 1355,
 /*  1920 */  1355, 1355, 1355, 1355,  512, 1355, 1355, 1355, 1624, 1683,
 /*  1930 */  1355, 1355, 1665, 1655,  515, 1657, 1658,  511, 1670,  532,
 /*  1940 */  1355, 1355, 1654, 1355, 1355, 1683,  513, 1355, 1664, 1655,
 /*  1950 */   515, 1657, 1658,  511, 1355,  532,  512, 1355, 1355, 1355,
 /*  1960 */  1624, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355,
 /*  1970 */  1670, 1355, 1654, 1355, 1355, 1355, 1355, 1683,  513, 1355,
 /*  1980 */   282, 1655,  515, 1657, 1658,  511, 1355,  532,  512, 1355,
 /*  1990 */  1355, 1355, 1624, 1355, 1355, 1355, 1355, 1355, 1355, 1355,
 /*  2000 */  1670, 1355, 1355, 1355, 1654, 1355, 1355, 1355,  513, 1683,
 /*  2010 */  1355, 1355,  281, 1655,  515, 1657, 1658,  511,  512,  532,
 /*  2020 */  1654, 1355, 1624, 1355, 1355, 1355, 1355, 1355, 1355, 1355,
 /*  2030 */  1355, 1355, 1670, 1355, 1355, 1355, 1355, 1355, 1355, 1683,
 /*  2040 */   513, 1355,  283, 1655,  515, 1657, 1658,  511, 1670,  532,
 /*  2050 */   512,  489, 1355, 1355, 1624, 1355,  513, 1355, 1355,  489,
 /*  2060 */  1355, 1355, 1355, 1355, 1355, 1355,  512, 1355, 1355, 1355,
 /*  2070 */  1624, 1683, 1355, 1355,  280, 1655,  515, 1657, 1658,  511,
 /*  2080 */   114,  532, 1355, 1355, 1355, 1355, 1355, 1683,  114, 1355,
 /*  2090 */   266, 1655,  515, 1657, 1658,  511, 1355,  532, 1355,  493,
 /*  2100 */  1355, 1355, 1355, 1355, 1355, 1355, 1355,  493, 1355, 1355,
 /*  2110 */  1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355,  112, 1355,
 /*  2120 */  1355, 1355, 1355, 1355, 1355, 1355,  112, 1355, 1355, 1355,
 /*  2130 */  1355, 1355, 1355,  219, 1730,  488, 1355,  487, 1355, 1355,
 /*  2140 */  1785,  219, 1730,  488, 1355,  487, 1355, 1355, 1785, 1355,
 /*  2150 */  1355, 1355,  149, 1355, 1355, 1355, 1782, 1355, 1355, 1355,
 /*  2160 */   147, 1355, 1355, 1355, 1782,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   251,  248,  241,  271,  322,  323,  274,    0,  271,  249,
 /*    10 */   250,  274,   12,   13,  248,   12,   13,   14,   15,   16,
 /*    20 */    20,  272,   22,  291,  248,  248,  260,  270,  291,  244,
 /*    30 */   269,  246,  247,  267,  248,  282,  260,  296,  277,  307,
 /*    40 */   308,   20,  254,  277,  307,  308,  258,   47,  287,  240,
 /*    50 */   318,  242,  291,  277,  277,  318,   20,  296,   58,  248,
 /*    60 */    12,   13,   14,  277,   64,    0,    4,  253,   20,  308,
 /*    70 */    22,  260,  311,  312,  313,  314,  315,  316,  337,  318,
 /*    80 */   266,   81,  321,    4,  269,   82,  325,  326,  277,  275,
 /*    90 */   349,  276,  315,  287,  353,   47,  281,   20,  337,  293,
 /*   100 */    93,  315,   81,  103,   42,   43,   58,  330,  331,  332,
 /*   110 */   349,  334,   64,  113,  353,  329,  330,  331,  332,  112,
 /*   120 */   334,  114,  115,  116,   57,   60,   61,   62,   63,   81,
 /*   130 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   140 */    75,   76,   77,   78,    0,   12,   13,   14,   15,   16,
 /*   150 */   244,  103,  246,  247,  268,  279,  156,   20,   81,  269,
 /*   160 */    81,  113,  286,  287,    0,   21,  280,  277,   24,   25,
 /*   170 */    26,   27,   28,   29,   30,   31,   32,  143,  245,  179,
 /*   180 */   180,  248,  182,  183,  184,  185,  186,  187,  188,  189,
 /*   190 */   190,  191,  192,  193,  194,  195,  196,   12,   13,   14,
 /*   200 */    15,   16,  287,  313,  156,  290,   41,   21,  293,  209,
 /*   210 */    24,   25,   26,   27,   28,   29,   30,   31,   32,   35,
 /*   220 */   269,   57,   12,   13,   14,   15,   16,  179,  180,  278,
 /*   230 */   182,  183,  184,  185,  186,  187,  188,  189,  190,  191,
 /*   240 */   192,  193,  194,  195,  196,   12,   13,   82,  214,  215,
 /*   250 */   238,   60,   61,   20,  241,   22,   65,   55,  262,   68,
 /*   260 */    69,  265,   75,   72,   73,   74,   12,   13,   84,    4,
 /*   270 */    86,   87,   47,   89,   20,  271,   22,   93,  145,  261,
 /*   280 */    47,  251,  269,   81,   19,   83,  209,  269,  209,   64,
 /*   290 */   277,   58,   82,   20,  264,  291,  278,   64,   33,  115,
 /*   300 */   287,   47,  272,   20,  291,   22,  119,  120,  296,  296,
 /*   310 */    45,  307,  308,   14,   81,   50,   20,  271,   64,   20,
 /*   320 */    55,  308,  318,  248,  311,  312,  313,  314,  315,  316,
 /*   330 */     2,  318,   49,  148,  321,   81,  103,  291,  325,  326,
 /*   340 */    12,   13,   14,   15,   16,   80,  113,    0,   83,  337,
 /*   350 */   337,   57,  277,  307,  308,  165,  166,  103,  241,  169,
 /*   360 */    92,  349,  349,    0,  318,  353,  353,  113,    0,   94,
 /*   370 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   380 */   241,  106,  107,  108,  109,  110,  111,   37,   81,  156,
 /*   390 */   315,   20,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   400 */    32,   14,   15,   16,   57,  330,  331,  332,  291,  334,
 /*   410 */   156,  209,  179,  180,  229,  182,  183,  184,  185,  186,
 /*   420 */   187,  188,  189,  190,  191,  192,  193,  194,  195,  196,
 /*   430 */   291,   64,   55,  179,  180,  300,  182,  183,  184,  185,
 /*   440 */   186,  187,  188,  189,  190,  191,  192,  193,  194,  195,
 /*   450 */   196,   12,   13,   14,    2,  241,   93,   80,  296,   20,
 /*   460 */    83,   22,   93,  209,   12,   13,   14,   15,   16,  253,
 /*   470 */     0,  245,   12,   13,  248,  112,  241,  114,  115,  116,
 /*   480 */    20,  112,   22,  114,  115,  116,   47,   20,  248,  179,
 /*   490 */   248,  275,   22,   12,   13,   14,   15,   16,  337,  337,
 /*   500 */   260,   44,  260,   64,  269,  291,  270,   47,   81,  267,
 /*   510 */   349,  349,  277,  296,  353,  353,  209,  277,  241,  277,
 /*   520 */    81,  257,  287,  259,   64,    0,  291,   21,  218,  219,
 /*   530 */   220,  221,  222,   12,   13,   14,   15,   16,   81,   58,
 /*   540 */    34,   81,  103,  308,  255,  256,  311,  312,  313,  314,
 /*   550 */   315,  316,  113,  318,  337,  270,  321,  269,  208,  261,
 /*   560 */   325,  326,  327,  103,  276,  337,  349,  269,  291,  281,
 /*   570 */   353,   90,   14,  113,  339,  337,  278,  349,   20,  344,
 /*   580 */   345,  353,  155,  309,  157,   60,   61,  349,  248,  151,
 /*   590 */    65,  353,  269,   68,   69,  156,  269,   72,   73,   74,
 /*   600 */   260,  255,  256,  276,  281,  286,  287,  333,  281,  171,
 /*   610 */   172,    4,  145,  241,   42,   43,  156,  277,  179,  180,
 /*   620 */   139,  182,  183,  184,  185,  186,  187,  188,  189,  190,
 /*   630 */   191,  192,  193,  194,  195,  196,  209,    1,    2,  179,
 /*   640 */   180,  160,  182,  183,  184,  185,  186,  187,  188,  189,
 /*   650 */   190,  191,  192,  193,  194,  195,  196,   12,   13,   18,
 /*   660 */   241,   20,  248,  291,  248,   20,  241,   22,   27,    3,
 /*   670 */   241,   30,  241,  270,  260,  270,  260,  270,  197,  198,
 /*   680 */   199,  200,  201,  202,  203,  204,  205,  206,  269,   48,
 /*   690 */   248,  277,   47,  277,   14,  248,  277,  241,  277,  248,
 /*   700 */    20,   93,  260,  241,  261,  284,  287,  260,   20,   64,
 /*   710 */   291,  260,  269,  248,  167,  168,  291,   20,   82,  277,
 /*   720 */   291,  278,  291,  115,  277,  260,   81,  308,  277,  139,
 /*   730 */   311,  312,  313,  314,  315,  316,   22,  318,  241,  241,
 /*   740 */   321,  183,  277,   41,  325,  326,  327,  291,  103,   41,
 /*   750 */   160,  207,  208,  291,  241,  336,  241,  241,  113,  118,
 /*   760 */   241,   47,  121,  122,  123,  124,  125,  126,  127,  128,
 /*   770 */   129,  130,  131,  132,  133,  134,  135,  136,  137,  138,
 /*   780 */   248,   18,  248,  248,  309,  242,   23,  197,  291,  291,
 /*   790 */    82,  309,  260,  241,  260,  260,  241,   41,   35,   36,
 /*   800 */     0,  156,   39,  241,  291,   58,  291,  291,  333,  277,
 /*   810 */   291,  277,  277,   85,  258,  333,   88,  210,   85,   56,
 /*   820 */    85,   88,   47,   88,  179,  180,   41,  182,  183,  184,
 /*   830 */   185,  186,  187,  188,  189,  190,  191,  192,  193,  194,
 /*   840 */   195,  196,  145,  291,   81,   45,  291,   12,   13,   14,
 /*   850 */    15,   16,   85,  291,    0,   88,   22,    0,   41,    1,
 /*   860 */     2,  194,  195,  183,   41,   41,   41,   82,   41,   41,
 /*   870 */   270,  183,  304,   41,   41,   81,   22,   41,   47,   22,
 /*   880 */   117,   47,   41,  356,   47,   91,   41,  347,  113,   41,
 /*   890 */   224,  341,  269,   58,   41,  247,  241,  280,   64,   82,
 /*   900 */   249,   64,   41,  310,  335,   82,   82,   82,  306,   82,
 /*   910 */    82,  148,  149,  150,   82,   82,  153,   82,   82,   20,
 /*   920 */   350,  158,  338,   82,  269,   90,  179,   82,  226,  350,
 /*   930 */    82,  350,  277,  170,  211,   82,  173,  103,  175,  176,
 /*   940 */   177,  178,  287,   82,  113,   45,  291,  113,  248,  305,
 /*   950 */    47,  255,   12,   13,  298,  154,   40,  248,  248,  285,
 /*   960 */   139,  283,   22,  308,  283,  248,  311,  312,  313,  314,
 /*   970 */   315,  316,  209,  318,  139,  241,  321,   20,   20,  243,
 /*   980 */   325,  326,  327,  243,  228,  302,  287,   47,   20,  295,
 /*   990 */   156,  253,  253,   20,  253,  160,  253,  277,  297,  295,
 /*  1000 */   345,   20,  253,  269,   64,  253,  288,  248,  253,  243,
 /*  1010 */    64,  277,  248,  179,  180,  269,  243,  269,  291,  269,
 /*  1020 */   269,  287,  269,  269,  302,  291,  269,  269,  241,  269,
 /*  1030 */   269,  269,  197,  198,  199,  200,  201,  202,  203,  204,
 /*  1040 */   205,  206,  308,  103,  251,  311,  312,  313,  314,  315,
 /*  1050 */   316,  163,  318,  113,  251,  321,  269,  287,  248,  325,
 /*  1060 */   326,  327,  251,  295,  277,  277,  301,  288,  217,  251,
 /*  1070 */   336,   20,  346,  292,  287,  216,  346,  291,  291,  241,
 /*  1080 */   291,  310,  292,  291,  342,  223,  147,  343,  212,  306,
 /*  1090 */   241,  208,  277,   20,   40,  308,  156,  227,  311,  312,
 /*  1100 */   313,  314,  315,  316,  309,  318,  328,  269,  321,  340,
 /*  1110 */   225,  230,  325,  326,  327,  277,   81,  291,  269,  179,
 /*  1120 */   291,  324,  292,  336,  352,  287,  277,  351,  351,  291,
 /*  1130 */   190,  191,  192,  351,  296,  292,  287,  357,  241,  142,
 /*  1140 */   291,  291,  277,  352,  289,  296,  308,  251,  352,  311,
 /*  1150 */   312,  313,  314,  315,  316,  288,  318,  308,  265,  251,
 /*  1160 */   311,  312,  313,  314,  315,  316,  269,  318,  277,   81,
 /*  1170 */   259,  273,  248,  251,  277,  337,  243,  299,  241,  252,
 /*  1180 */   303,  263,  263,  263,  287,    0,  337,  349,  291,  239,
 /*  1190 */     0,  353,   40,    0,   72,   47,   47,   47,  349,  174,
 /*  1200 */     0,   47,  353,   47,  174,  308,  269,    0,  311,  312,
 /*  1210 */   313,  314,  315,  316,  277,  318,  174,    0,  321,   47,
 /*  1220 */    33,    0,  325,  326,  287,   47,    0,   47,  291,  160,
 /*  1230 */   159,  113,   45,    0,   81,  156,    0,  241,   51,   52,
 /*  1240 */    53,   54,   55,    0,  152,  308,  151,    0,  311,  312,
 /*  1250 */   313,  314,  315,  316,    0,  318,   44,    0,  321,   40,
 /*  1260 */     0,    0,  325,  326,    0,  269,    0,   80,    0,    0,
 /*  1270 */    83,    0,    0,  277,    0,    0,    0,    0,    0,    0,
 /*  1280 */     0,    0,    0,  287,    0,    0,    0,  291,    0,  241,
 /*  1290 */     0,    0,   22,    0,    0,    0,    0,    0,  241,    0,
 /*  1300 */    37,   14,   40,   14,  308,    0,   41,  311,  312,  313,
 /*  1310 */   314,  315,  316,  317,  318,  319,  320,  269,    0,    0,
 /*  1320 */     0,   38,  147,    0,    0,  277,  269,  140,    0,  142,
 /*  1330 */     0,  144,   59,  146,  277,  287,   44,   37,   37,  291,
 /*  1340 */    37,    0,   44,   37,  287,    0,   37,    0,  291,   47,
 /*  1350 */     0,  164,   45,   37,  241,   47,  308,   45,   45,  311,
 /*  1360 */   312,  313,  314,  315,  316,  308,  318,   45,  311,  312,
 /*  1370 */   313,  314,  315,  316,   37,  318,   47,    0,  321,   19,
 /*  1380 */    47,    0,  269,  326,    0,    0,   47,   22,    0,   47,
 /*  1390 */   277,   47,   41,   33,   90,   47,   47,   41,   88,   47,
 /*  1400 */   287,   47,  354,  355,  291,   45,   47,  294,  241,    0,
 /*  1410 */     0,   51,   52,   53,   54,   55,   22,  241,   22,   48,
 /*  1420 */     0,  308,   22,   47,  311,  312,  313,  314,  315,  316,
 /*  1430 */     0,  318,    0,   22,   22,   20,  269,    0,   47,    0,
 /*  1440 */    80,   22,    0,   83,  277,  269,    0,    0,    0,   81,
 /*  1450 */    37,  213,   82,  277,  287,   41,   82,   41,  291,  145,
 /*  1460 */   145,  140,  145,  287,   41,   82,   41,  291,  142,  213,
 /*  1470 */   241,   81,   44,   81,   81,  308,  116,   44,  311,  312,
 /*  1480 */   313,  314,  315,  316,  308,  318,  161,  311,  312,  313,
 /*  1490 */   314,  315,  316,   41,  318,   44,   41,   44,  269,   81,
 /*  1500 */   241,  141,   41,   82,  144,   47,  277,   47,   82,   47,
 /*  1510 */    47,   82,   47,   82,   47,  348,  287,    2,   41,  179,
 /*  1520 */   291,   81,  162,  294,  164,   82,   82,   44,  269,   44,
 /*  1530 */    81,  355,   22,    0,  181,   81,  277,  308,  207,   82,
 /*  1540 */   311,  312,  313,  314,  315,  316,  287,  318,  213,   81,
 /*  1550 */   291,   82,  241,   81,   81,   81,   37,   81,   44,   81,
 /*  1560 */   143,   91,  140,   82,   44,   81,   22,  308,  241,   81,
 /*  1570 */   311,  312,  313,  314,  315,  316,   82,  318,   92,  320,
 /*  1580 */   269,   47,   47,   81,  105,   82,   47,   81,  277,   82,
 /*  1590 */    47,   82,   81,   47,   81,   47,  269,   81,  287,   82,
 /*  1600 */   105,  105,  291,  105,  277,  294,   22,   81,  241,   81,
 /*  1610 */    47,   93,   81,  113,  287,   22,   59,   58,  291,  308,
 /*  1620 */   241,  294,  311,  312,  313,  314,  315,  316,   47,  318,
 /*  1630 */    64,   79,   41,   47,   47,  308,  269,   47,  311,  312,
 /*  1640 */   313,  314,  315,  316,  277,  318,   47,   47,  269,   22,
 /*  1650 */    47,   47,   64,   47,  287,   47,  277,   47,  291,   47,
 /*  1660 */    47,   47,   47,    0,   47,   45,  287,   37,  241,   47,
 /*  1670 */   291,    0,   37,   45,    0,  308,   47,   45,  311,  312,
 /*  1680 */   313,  314,  315,  316,   37,  318,    0,  308,   47,   45,
 /*  1690 */   311,  312,  313,  314,  315,  316,  269,  318,   37,    0,
 /*  1700 */   241,   47,   46,    0,  277,    0,   22,   22,   21,   20,
 /*  1710 */    22,   21,  358,  358,  287,  358,  358,  358,  291,  358,
 /*  1720 */   358,  358,  358,  358,  358,  358,  358,  358,  269,  358,
 /*  1730 */   241,  358,  358,  358,  358,  308,  277,  358,  311,  312,
 /*  1740 */   313,  314,  315,  316,  358,  318,  287,  358,  358,  358,
 /*  1750 */   291,  358,  358,  358,  358,  358,  358,  358,  269,  358,
 /*  1760 */   358,  358,  241,  358,  358,  358,  277,  308,  358,  358,
 /*  1770 */   311,  312,  313,  314,  315,  316,  287,  318,  241,  358,
 /*  1780 */   291,  358,  358,  358,  358,  358,  358,  358,  358,  358,
 /*  1790 */   269,  358,  358,  358,  241,  358,  358,  308,  277,  358,
 /*  1800 */   311,  312,  313,  314,  315,  316,  269,  318,  287,  358,
 /*  1810 */   241,  358,  291,  358,  277,  358,  358,  358,  358,  358,
 /*  1820 */   358,  358,  269,  358,  287,  358,  358,  358,  291,  308,
 /*  1830 */   277,  358,  311,  312,  313,  314,  315,  316,  269,  318,
 /*  1840 */   287,  358,  358,  358,  291,  308,  277,  358,  311,  312,
 /*  1850 */   313,  314,  315,  316,  358,  318,  287,  358,  358,  358,
 /*  1860 */   291,  308,  241,  358,  311,  312,  313,  314,  315,  316,
 /*  1870 */   358,  318,  358,  358,  358,  358,  358,  308,  241,  358,
 /*  1880 */   311,  312,  313,  314,  315,  316,  358,  318,  358,  358,
 /*  1890 */   269,  358,  358,  358,  358,  358,  358,  358,  277,  358,
 /*  1900 */   358,  358,  358,  358,  358,  358,  269,  358,  287,  358,
 /*  1910 */   241,  358,  291,  358,  277,  358,  358,  358,  358,  358,
 /*  1920 */   358,  358,  358,  358,  287,  358,  358,  358,  291,  308,
 /*  1930 */   358,  358,  311,  312,  313,  314,  315,  316,  269,  318,
 /*  1940 */   358,  358,  241,  358,  358,  308,  277,  358,  311,  312,
 /*  1950 */   313,  314,  315,  316,  358,  318,  287,  358,  358,  358,
 /*  1960 */   291,  358,  358,  358,  358,  358,  358,  358,  358,  358,
 /*  1970 */   269,  358,  241,  358,  358,  358,  358,  308,  277,  358,
 /*  1980 */   311,  312,  313,  314,  315,  316,  358,  318,  287,  358,
 /*  1990 */   358,  358,  291,  358,  358,  358,  358,  358,  358,  358,
 /*  2000 */   269,  358,  358,  358,  241,  358,  358,  358,  277,  308,
 /*  2010 */   358,  358,  311,  312,  313,  314,  315,  316,  287,  318,
 /*  2020 */   241,  358,  291,  358,  358,  358,  358,  358,  358,  358,
 /*  2030 */   358,  358,  269,  358,  358,  358,  358,  358,  358,  308,
 /*  2040 */   277,  358,  311,  312,  313,  314,  315,  316,  269,  318,
 /*  2050 */   287,  248,  358,  358,  291,  358,  277,  358,  358,  248,
 /*  2060 */   358,  358,  358,  358,  358,  358,  287,  358,  358,  358,
 /*  2070 */   291,  308,  358,  358,  311,  312,  313,  314,  315,  316,
 /*  2080 */   277,  318,  358,  358,  358,  358,  358,  308,  277,  358,
 /*  2090 */   311,  312,  313,  314,  315,  316,  358,  318,  358,  296,
 /*  2100 */   358,  358,  358,  358,  358,  358,  358,  296,  358,  358,
 /*  2110 */   358,  358,  358,  358,  358,  358,  358,  358,  315,  358,
 /*  2120 */   358,  358,  358,  358,  358,  358,  315,  358,  358,  358,
 /*  2130 */   358,  358,  358,  330,  331,  332,  358,  334,  358,  358,
 /*  2140 */   337,  330,  331,  332,  358,  334,  358,  358,  337,  358,
 /*  2150 */   358,  358,  349,  358,  358,  358,  353,  358,  358,  358,
 /*  2160 */   349,  358,  358,  358,  353,
};
#define YY_SHIFT_COUNT    (614)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1705)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   763,    0,    0,   48,  233,  233,  233,  233,  254,  254,
 /*    10 */   233,  233,  439,  460,  645,  460,  460,  460,  460,  460,
 /*    20 */   460,  460,  460,  460,  460,  460,  460,  460,  460,  460,
 /*    30 */   460,  460,  460,  460,  460,  460,  460,  460,   77,   77,
 /*    40 */    21,   21,   21,  940,  940,  940,  940,  427,  202,  307,
 /*    50 */    36,   36,   62,   62,   79,  307,  307,   36,   36,   36,
 /*    60 */    36,   36,   36,   36,   67,   36,   36,  137,  273,  296,
 /*    70 */   137,   36,   36,  137,   36,  137,  137,  296,  137,   36,
 /*    80 */   294,  641,  835,  481,  481,  186,  191,  834,  834,  834,
 /*    90 */   834,  834,  834,  834,  834,  834,  834,  834,  834,  834,
 /*   100 */   834,  834,  834,  834,  834,  834,  184,  283,  299,  299,
 /*   110 */   164,  225,  467,  467,  467,  347,  225,  371,  296,  137,
 /*   120 */   137,  296,  268,  367,  275,  275,  275,  275,  275,  275,
 /*   130 */   275, 1360,  144,  525,  185,  310,  190,   34,  558,  680,
 /*   140 */   572,  714,  608,  697,  544,  350,  544,  666,  666,  666,
 /*   150 */   607,  688,  723,  899,  900,  903,  801,  899,  899,  916,
 /*   160 */   821,  821,  899,  957,  957,  958,   67,  296,   67,  968,
 /*   170 */   973,   67,  968,   67,  371,  981,   67,   67,  899,   67,
 /*   180 */   957,  137,  137,  137,  137,  137,  137,  137,  137,  137,
 /*   190 */   137,  137,  899,  957,  946,  958,  294,  888,  296,  294,
 /*   200 */   899,  968,  294,  371,  981,  294, 1051,  851,  859,  946,
 /*   210 */   851,  859,  946,  946,  137,  862,  939,  876,  723,  883,
 /*   220 */   371, 1073, 1054,  870,  885,  881,  870,  885,  870,  885,
 /*   230 */  1035,  859,  946,  946,  859,  946,  997,  371,  981,  294,
 /*   240 */   268,  294,  371, 1088,  367,  899,  294,  957, 2165, 2165,
 /*   250 */  2165, 2165, 2165, 2165, 2165,   65, 1187,  368,  265,    3,
 /*   260 */   328,  452,  133,  210,    7,  363,  521,  521,  521,  521,
 /*   270 */   521,  521,  521,  521,  369,  438,  377,  187,  636,  590,
 /*   280 */   387,  387,  387,  387,  800,  165,  728,  733,  735,  767,
 /*   290 */   470,  854,  857,  506,  547,  708,  785,  817,  858,  667,
 /*   300 */   702,  756,  824,  747,  825,  457,  827,  828,  832,  833,
 /*   310 */   836,  775,  831,  823,  841,  845,  848,  853,  861,  794,
 /*   320 */   837, 1185, 1190, 1152, 1193, 1122, 1148, 1149, 1150, 1025,
 /*   330 */  1200, 1154, 1156, 1030, 1207, 1042, 1217, 1172, 1221, 1178,
 /*   340 */  1226, 1180, 1233, 1153, 1069, 1071, 1118, 1079, 1236, 1243,
 /*   350 */  1092, 1095, 1247, 1254, 1212, 1257, 1264, 1266, 1268, 1269,
 /*   360 */  1271, 1272, 1274, 1275, 1276, 1277, 1278, 1279, 1280, 1281,
 /*   370 */  1282, 1284, 1285, 1219, 1260, 1261, 1286, 1288, 1290, 1291,
 /*   380 */  1270, 1293, 1294, 1295, 1296, 1297, 1299, 1262, 1263, 1265,
 /*   390 */  1287, 1292, 1289, 1298, 1305, 1283, 1300, 1318, 1319, 1320,
 /*   400 */  1301, 1175, 1323, 1324, 1303, 1328, 1273, 1330, 1341, 1302,
 /*   410 */  1307, 1306, 1345, 1308, 1312, 1309, 1347, 1329, 1313, 1316,
 /*   420 */  1350, 1333, 1322, 1337, 1377, 1381, 1384, 1385, 1304, 1310,
 /*   430 */  1339, 1365, 1388, 1342, 1344, 1348, 1349, 1351, 1356, 1352,
 /*   440 */  1354, 1359, 1409, 1394, 1410, 1396, 1371, 1420, 1400, 1376,
 /*   450 */  1430, 1411, 1432, 1412, 1415, 1437, 1314, 1391, 1439, 1325,
 /*   460 */  1419, 1315, 1326, 1442, 1446, 1447, 1317, 1448, 1368, 1413,
 /*   470 */  1321, 1414, 1416, 1238, 1370, 1423, 1374, 1390, 1392, 1393,
 /*   480 */  1383, 1425, 1428, 1433, 1418, 1452, 1256, 1421, 1426, 1451,
 /*   490 */  1331, 1455, 1453, 1429, 1461, 1335, 1431, 1458, 1460, 1462,
 /*   500 */  1463, 1465, 1467, 1431, 1515, 1340, 1477, 1443, 1440, 1444,
 /*   510 */  1483, 1449, 1454, 1485, 1510, 1353, 1468, 1457, 1469, 1472,
 /*   520 */  1473, 1417, 1474, 1533, 1519, 1422, 1476, 1470, 1514, 1520,
 /*   530 */  1478, 1481, 1484, 1544, 1488, 1486, 1494, 1534, 1535, 1502,
 /*   540 */  1503, 1539, 1506, 1507, 1543, 1511, 1509, 1546, 1513, 1517,
 /*   550 */  1548, 1516, 1479, 1495, 1496, 1498, 1584, 1518, 1526, 1528,
 /*   560 */  1563, 1531, 1500, 1593, 1557, 1559, 1581, 1566, 1552, 1591,
 /*   570 */  1586, 1587, 1590, 1599, 1600, 1627, 1603, 1604, 1588, 1351,
 /*   580 */  1606, 1356, 1608, 1610, 1612, 1613, 1614, 1615, 1663, 1617,
 /*   590 */  1620, 1630, 1671, 1622, 1628, 1635, 1674, 1629, 1632, 1647,
 /*   600 */  1686, 1641, 1644, 1661, 1699, 1654, 1656, 1703, 1705, 1684,
 /*   610 */  1687, 1685, 1688, 1690, 1689,
};
#define YY_REDUCE_COUNT (254)
#define YY_REDUCE_MIN   (-318)
#define YY_REDUCE_MAX   (1811)
static const short yy_reduce_ofst[] = {
 /*     0 */    12, -239,   13,  235,  655,  419,  734,  787,  838,  849,
 /*    10 */   897,  937,  996, 1048, 1057, 1113, 1167, 1176, 1229, 1259,
 /*    20 */  1311, 1327, 1367, 1379, 1427, 1459, 1489, 1521, 1537, 1553,
 /*    30 */  1569, 1621, 1637, 1669, 1701, 1731, 1763, 1779, 1803, 1811,
 /*    40 */  -214, -223,   75, -268, -263,    4,   46, -259,  162,  217,
 /*    50 */  -234,  242, -215,  -94,  161,  228,  238, -224, -189,  240,
 /*    60 */   340,  414,  416,  442, -186,  447,  451, -185, -110,  -85,
 /*    70 */    18,  465,  532,  288,  534,  298,  327, -124,  443,  535,
 /*    80 */    30, -247, -318, -318, -318, -191, -212,  117,  139,  214,
 /*    90 */   277,  372,  425,  429,  431,  456,  462,  497,  498,  513,
 /*   100 */   515,  516,  519,  552,  555,  562, -114, -240,  -67,  226,
 /*   110 */   216,  289,  274,  475,  482, -251,  346,  421, -194,  -49,
 /*   120 */   323,  319,   -4,  264, -243,  236,  285,  403,  405,  407,
 /*   130 */   600,  135,  543,  556,  527,  540,  568,  550,  623,  623,
 /*   140 */   648,  651,  617,  593,  569,  569,  569,  570,  579,  581,
 /*   150 */   584,  623,  602,  700,  644,  696,  656,  709,  710,  674,
 /*   160 */   678,  681,  717,  736,  740,  683,  738,  699,  739,  694,
 /*   170 */   701,  741,  704,  743,  720,  718,  749,  752,  759,  755,
 /*   180 */   766,  746,  748,  750,  751,  753,  754,  757,  758,  760,
 /*   190 */   761,  762,  764,  773,  727,  722,  793,  765,  770,  803,
 /*   200 */   810,  768,  811,  788,  779,  818,  771,  726,  781,  786,
 /*   210 */   730,  790,  789,  792,  623,  744,  742,  769,  783,  569,
 /*   220 */   815,  795,  778,  772,  776,  780,  791,  777,  796,  782,
 /*   230 */   797,  830,  826,  829,  843,  850,  855,  865,  867,  896,
 /*   240 */   893,  908,  891,  898,  911,  924,  922,  933,  878,  877,
 /*   250 */   918,  919,  920,  927,  950,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*    10 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*    20 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*    30 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*    40 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*    50 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*    60 */  1353, 1353, 1353, 1353, 1422, 1353, 1353, 1353, 1353, 1353,
 /*    70 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*    80 */  1420, 1560, 1353, 1725, 1353, 1353, 1353, 1353, 1353, 1353,
 /*    90 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   100 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   110 */  1422, 1353, 1736, 1736, 1736, 1420, 1353, 1353, 1353, 1353,
 /*   120 */  1353, 1353, 1516, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   130 */  1353, 1596, 1353, 1353, 1802, 1353, 1602, 1760, 1353, 1353,
 /*   140 */  1353, 1353, 1469, 1752, 1728, 1742, 1729, 1787, 1787, 1787,
 /*   150 */  1745, 1353, 1756, 1353, 1353, 1353, 1588, 1353, 1353, 1565,
 /*   160 */  1562, 1562, 1353, 1353, 1353, 1353, 1422, 1353, 1422, 1353,
 /*   170 */  1353, 1422, 1353, 1422, 1353, 1353, 1422, 1422, 1353, 1422,
 /*   180 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   190 */  1353, 1353, 1353, 1353, 1353, 1353, 1420, 1598, 1353, 1420,
 /*   200 */  1353, 1353, 1420, 1353, 1353, 1420, 1353, 1767, 1765, 1353,
 /*   210 */  1767, 1765, 1353, 1353, 1353, 1779, 1775, 1758, 1756, 1742,
 /*   220 */  1353, 1353, 1353, 1793, 1789, 1805, 1793, 1789, 1793, 1789,
 /*   230 */  1353, 1765, 1353, 1353, 1765, 1353, 1573, 1353, 1353, 1420,
 /*   240 */  1353, 1420, 1353, 1485, 1353, 1353, 1420, 1353, 1590, 1604,
 /*   250 */  1519, 1519, 1519, 1423, 1358, 1353, 1353, 1353, 1353, 1353,
 /*   260 */  1353, 1353, 1353, 1353, 1353, 1353, 1669, 1778, 1777, 1701,
 /*   270 */  1700, 1699, 1697, 1668, 1481, 1353, 1353, 1353, 1353, 1353,
 /*   280 */  1662, 1663, 1661, 1660, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   290 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1726, 1353,
 /*   300 */  1790, 1794, 1353, 1353, 1353, 1645, 1353, 1353, 1353, 1353,
 /*   310 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   320 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   330 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   340 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   350 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   360 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   370 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   380 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1387,
 /*   390 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   400 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   410 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   420 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   430 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1450, 1449, 1353,
 /*   440 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   450 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   460 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   470 */  1353, 1749, 1759, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   480 */  1353, 1353, 1353, 1645, 1353, 1776, 1353, 1735, 1731, 1353,
 /*   490 */  1353, 1727, 1353, 1353, 1788, 1353, 1353, 1353, 1353, 1353,
 /*   500 */  1353, 1353, 1353, 1353, 1721, 1353, 1694, 1353, 1353, 1353,
 /*   510 */  1353, 1353, 1353, 1353, 1353, 1656, 1353, 1353, 1353, 1353,
 /*   520 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1644, 1353,
 /*   530 */  1685, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1513,
 /*   540 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   550 */  1353, 1353, 1498, 1496, 1495, 1494, 1353, 1491, 1353, 1353,
 /*   560 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1442,
 /*   570 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1433,
 /*   580 */  1353, 1432, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   590 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   600 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   610 */  1353, 1353, 1353, 1353, 1353,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*  PRIVILEGE => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*       DAYS => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /* FILE_FACTOR => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FULLTEXT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /*      COUNT => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  231,  /*  NK_BITNOT => ID */
  231,  /*     INSERT => ID */
  231,  /*     VALUES => ID */
  231,  /*     IMPORT => ID */
  231,  /*    NK_SEMI => ID */
  231,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "GRANT",
  /*   37 */ "ON",
  /*   38 */ "TO",
  /*   39 */ "REVOKE",
  /*   40 */ "FROM",
  /*   41 */ "NK_COMMA",
  /*   42 */ "READ",
  /*   43 */ "WRITE",
  /*   44 */ "NK_DOT",
  /*   45 */ "DNODE",
  /*   46 */ "PORT",
  /*   47 */ "NK_INTEGER",
  /*   48 */ "DNODES",
  /*   49 */ "NK_IPTOKEN",
  /*   50 */ "LOCAL",
  /*   51 */ "QNODE",
  /*   52 */ "BNODE",
  /*   53 */ "SNODE",
  /*   54 */ "MNODE",
  /*   55 */ "DATABASE",
  /*   56 */ "USE",
  /*   57 */ "IF",
  /*   58 */ "NOT",
  /*   59 */ "EXISTS",
  /*   60 */ "BUFFER",
  /*   61 */ "CACHELAST",
  /*   62 */ "COMP",
  /*   63 */ "DAYS",
  /*   64 */ "NK_VARIABLE",
  /*   65 */ "FSYNC",
  /*   66 */ "MAXROWS",
  /*   67 */ "MINROWS",
  /*   68 */ "KEEP",
  /*   69 */ "PAGES",
  /*   70 */ "PAGESIZE",
  /*   71 */ "PRECISION",
  /*   72 */ "REPLICA",
  /*   73 */ "STRICT",
  /*   74 */ "WAL",
  /*   75 */ "VGROUPS",
  /*   76 */ "SINGLE_STABLE",
  /*   77 */ "RETENTIONS",
  /*   78 */ "SCHEMALESS",
  /*   79 */ "NK_COLON",
  /*   80 */ "TABLE",
  /*   81 */ "NK_LP",
  /*   82 */ "NK_RP",
  /*   83 */ "STABLE",
  /*   84 */ "ADD",
  /*   85 */ "COLUMN",
  /*   86 */ "MODIFY",
  /*   87 */ "RENAME",
  /*   88 */ "TAG",
  /*   89 */ "SET",
  /*   90 */ "NK_EQ",
  /*   91 */ "USING",
  /*   92 */ "TAGS",
  /*   93 */ "COMMENT",
  /*   94 */ "BOOL",
  /*   95 */ "TINYINT",
  /*   96 */ "SMALLINT",
  /*   97 */ "INT",
  /*   98 */ "INTEGER",
  /*   99 */ "BIGINT",
  /*  100 */ "FLOAT",
  /*  101 */ "DOUBLE",
  /*  102 */ "BINARY",
  /*  103 */ "TIMESTAMP",
  /*  104 */ "NCHAR",
  /*  105 */ "UNSIGNED",
  /*  106 */ "JSON",
  /*  107 */ "VARCHAR",
  /*  108 */ "MEDIUMBLOB",
  /*  109 */ "BLOB",
  /*  110 */ "VARBINARY",
  /*  111 */ "DECIMAL",
  /*  112 */ "FILE_FACTOR",
  /*  113 */ "NK_FLOAT",
  /*  114 */ "ROLLUP",
  /*  115 */ "TTL",
  /*  116 */ "SMA",
  /*  117 */ "SHOW",
  /*  118 */ "DATABASES",
  /*  119 */ "TABLES",
  /*  120 */ "STABLES",
  /*  121 */ "MNODES",
  /*  122 */ "MODULES",
  /*  123 */ "QNODES",
  /*  124 */ "FUNCTIONS",
  /*  125 */ "INDEXES",
  /*  126 */ "ACCOUNTS",
  /*  127 */ "APPS",
  /*  128 */ "CONNECTIONS",
  /*  129 */ "LICENCE",
  /*  130 */ "GRANTS",
  /*  131 */ "QUERIES",
  /*  132 */ "SCORES",
  /*  133 */ "TOPICS",
  /*  134 */ "VARIABLES",
  /*  135 */ "BNODES",
  /*  136 */ "SNODES",
  /*  137 */ "CLUSTER",
  /*  138 */ "TRANSACTIONS",
  /*  139 */ "LIKE",
  /*  140 */ "INDEX",
  /*  141 */ "FULLTEXT",
  /*  142 */ "FUNCTION",
  /*  143 */ "INTERVAL",
  /*  144 */ "TOPIC",
  /*  145 */ "AS",
  /*  146 */ "CONSUMER",
  /*  147 */ "GROUP",
  /*  148 */ "DESC",
  /*  149 */ "DESCRIBE",
  /*  150 */ "RESET",
  /*  151 */ "QUERY",
  /*  152 */ "CACHE",
  /*  153 */ "EXPLAIN",
  /*  154 */ "ANALYZE",
  /*  155 */ "VERBOSE",
  /*  156 */ "NK_BOOL",
  /*  157 */ "RATIO",
  /*  158 */ "COMPACT",
  /*  159 */ "VNODES",
  /*  160 */ "IN",
  /*  161 */ "OUTPUTTYPE",
  /*  162 */ "AGGREGATE",
  /*  163 */ "BUFSIZE",
  /*  164 */ "STREAM",
  /*  165 */ "INTO",
  /*  166 */ "TRIGGER",
  /*  167 */ "AT_ONCE",
  /*  168 */ "WINDOW_CLOSE",
  /*  169 */ "WATERMARK",
  /*  170 */ "KILL",
  /*  171 */ "CONNECTION",
  /*  172 */ "TRANSACTION",
  /*  173 */ "BALANCE",
  /*  174 */ "VGROUP",
  /*  175 */ "MERGE",
  /*  176 */ "REDISTRIBUTE",
  /*  177 */ "SYNCDB",
  /*  178 */ "DELETE",
  /*  179 */ "NULL",
  /*  180 */ "NK_QUESTION",
  /*  181 */ "NK_ARROW",
  /*  182 */ "ROWTS",
  /*  183 */ "TBNAME",
  /*  184 */ "QSTARTTS",
  /*  185 */ "QENDTS",
  /*  186 */ "WSTARTTS",
  /*  187 */ "WENDTS",
  /*  188 */ "WDURATION",
  /*  189 */ "CAST",
  /*  190 */ "NOW",
  /*  191 */ "TODAY",
  /*  192 */ "TIMEZONE",
  /*  193 */ "COUNT",
  /*  194 */ "FIRST",
  /*  195 */ "LAST",
  /*  196 */ "LAST_ROW",
  /*  197 */ "BETWEEN",
  /*  198 */ "IS",
  /*  199 */ "NK_LT",
  /*  200 */ "NK_GT",
  /*  201 */ "NK_LE",
  /*  202 */ "NK_GE",
  /*  203 */ "NK_NE",
  /*  204 */ "MATCH",
  /*  205 */ "NMATCH",
  /*  206 */ "CONTAINS",
  /*  207 */ "JOIN",
  /*  208 */ "INNER",
  /*  209 */ "SELECT",
  /*  210 */ "DISTINCT",
  /*  211 */ "WHERE",
  /*  212 */ "PARTITION",
  /*  213 */ "BY",
  /*  214 */ "SESSION",
  /*  215 */ "STATE_WINDOW",
  /*  216 */ "SLIDING",
  /*  217 */ "FILL",
  /*  218 */ "VALUE",
  /*  219 */ "NONE",
  /*  220 */ "PREV",
  /*  221 */ "LINEAR",
  /*  222 */ "NEXT",
  /*  223 */ "HAVING",
  /*  224 */ "ORDER",
  /*  225 */ "SLIMIT",
  /*  226 */ "SOFFSET",
  /*  227 */ "LIMIT",
  /*  228 */ "OFFSET",
  /*  229 */ "ASC",
  /*  230 */ "NULLS",
  /*  231 */ "ID",
  /*  232 */ "NK_BITNOT",
  /*  233 */ "INSERT",
  /*  234 */ "VALUES",
  /*  235 */ "IMPORT",
  /*  236 */ "NK_SEMI",
  /*  237 */ "FILE",
  /*  238 */ "cmd",
  /*  239 */ "account_options",
  /*  240 */ "alter_account_options",
  /*  241 */ "literal",
  /*  242 */ "alter_account_option",
  /*  243 */ "user_name",
  /*  244 */ "privileges",
  /*  245 */ "priv_level",
  /*  246 */ "priv_type_list",
  /*  247 */ "priv_type",
  /*  248 */ "db_name",
  /*  249 */ "dnode_endpoint",
  /*  250 */ "dnode_host_name",
  /*  251 */ "not_exists_opt",
  /*  252 */ "db_options",
  /*  253 */ "exists_opt",
  /*  254 */ "alter_db_options",
  /*  255 */ "integer_list",
  /*  256 */ "variable_list",
  /*  257 */ "retention_list",
  /*  258 */ "alter_db_option",
  /*  259 */ "retention",
  /*  260 */ "full_table_name",
  /*  261 */ "column_def_list",
  /*  262 */ "tags_def_opt",
  /*  263 */ "table_options",
  /*  264 */ "multi_create_clause",
  /*  265 */ "tags_def",
  /*  266 */ "multi_drop_clause",
  /*  267 */ "alter_table_clause",
  /*  268 */ "alter_table_options",
  /*  269 */ "column_name",
  /*  270 */ "type_name",
  /*  271 */ "signed_literal",
  /*  272 */ "create_subtable_clause",
  /*  273 */ "specific_tags_opt",
  /*  274 */ "literal_list",
  /*  275 */ "drop_table_clause",
  /*  276 */ "col_name_list",
  /*  277 */ "table_name",
  /*  278 */ "column_def",
  /*  279 */ "func_name_list",
  /*  280 */ "alter_table_option",
  /*  281 */ "col_name",
  /*  282 */ "db_name_cond_opt",
  /*  283 */ "like_pattern_opt",
  /*  284 */ "table_name_cond",
  /*  285 */ "from_db_opt",
  /*  286 */ "func_name",
  /*  287 */ "function_name",
  /*  288 */ "index_name",
  /*  289 */ "index_options",
  /*  290 */ "func_list",
  /*  291 */ "duration_literal",
  /*  292 */ "sliding_opt",
  /*  293 */ "func",
  /*  294 */ "expression_list",
  /*  295 */ "topic_name",
  /*  296 */ "query_expression",
  /*  297 */ "cgroup_name",
  /*  298 */ "analyze_opt",
  /*  299 */ "explain_options",
  /*  300 */ "agg_func_opt",
  /*  301 */ "bufsize_opt",
  /*  302 */ "stream_name",
  /*  303 */ "stream_options",
  /*  304 */ "into_opt",
  /*  305 */ "dnode_list",
  /*  306 */ "where_clause_opt",
  /*  307 */ "signed",
  /*  308 */ "literal_func",
  /*  309 */ "table_alias",
  /*  310 */ "column_alias",
  /*  311 */ "expression",
  /*  312 */ "pseudo_column",
  /*  313 */ "column_reference",
  /*  314 */ "function_expression",
  /*  315 */ "subquery",
  /*  316 */ "star_func",
  /*  317 */ "star_func_para_list",
  /*  318 */ "noarg_func",
  /*  319 */ "other_para_list",
  /*  320 */ "star_func_para",
  /*  321 */ "predicate",
  /*  322 */ "compare_op",
  /*  323 */ "in_op",
  /*  324 */ "in_predicate_value",
  /*  325 */ "boolean_value_expression",
  /*  326 */ "boolean_primary",
  /*  327 */ "common_expression",
  /*  328 */ "from_clause",
  /*  329 */ "table_reference_list",
  /*  330 */ "table_reference",
  /*  331 */ "table_primary",
  /*  332 */ "joined_table",
  /*  333 */ "alias_opt",
  /*  334 */ "parenthesized_joined_table",
  /*  335 */ "join_type",
  /*  336 */ "search_condition",
  /*  337 */ "query_specification",
  /*  338 */ "set_quantifier_opt",
  /*  339 */ "select_list",
  /*  340 */ "partition_by_clause_opt",
  /*  341 */ "twindow_clause_opt",
  /*  342 */ "group_by_clause_opt",
  /*  343 */ "having_clause_opt",
  /*  344 */ "select_sublist",
  /*  345 */ "select_item",
  /*  346 */ "fill_opt",
  /*  347 */ "fill_mode",
  /*  348 */ "group_by_list",
  /*  349 */ "query_expression_body",
  /*  350 */ "order_by_clause_opt",
  /*  351 */ "slimit_clause_opt",
  /*  352 */ "limit_clause_opt",
  /*  353 */ "query_primary",
  /*  354 */ "sort_specification_list",
  /*  355 */ "sort_specification",
  /*  356 */ "ordering_specification_opt",
  /*  357 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  29 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  30 */ "privileges ::= ALL",
 /*  31 */ "privileges ::= priv_type_list",
 /*  32 */ "priv_type_list ::= priv_type",
 /*  33 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  34 */ "priv_type ::= READ",
 /*  35 */ "priv_type ::= WRITE",
 /*  36 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  37 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  38 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  39 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  40 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  41 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  42 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  43 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  44 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  45 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  46 */ "dnode_endpoint ::= NK_STRING",
 /*  47 */ "dnode_host_name ::= NK_ID",
 /*  48 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  49 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  50 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  51 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  52 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  53 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  54 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  60 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  61 */ "cmd ::= USE db_name",
 /*  62 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  63 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  64 */ "not_exists_opt ::=",
 /*  65 */ "exists_opt ::= IF EXISTS",
 /*  66 */ "exists_opt ::=",
 /*  67 */ "db_options ::=",
 /*  68 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  69 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  70 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  71 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  72 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  73 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  74 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  75 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  76 */ "db_options ::= db_options KEEP integer_list",
 /*  77 */ "db_options ::= db_options KEEP variable_list",
 /*  78 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  79 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  81 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  82 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  83 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  84 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  85 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  86 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  87 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  88 */ "alter_db_options ::= alter_db_option",
 /*  89 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  90 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  91 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  92 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  93 */ "alter_db_option ::= KEEP integer_list",
 /*  94 */ "alter_db_option ::= KEEP variable_list",
 /*  95 */ "alter_db_option ::= PAGES NK_INTEGER",
 /*  96 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  97 */ "alter_db_option ::= STRICT NK_INTEGER",
 /*  98 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  99 */ "integer_list ::= NK_INTEGER",
 /* 100 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 101 */ "variable_list ::= NK_VARIABLE",
 /* 102 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 103 */ "retention_list ::= retention",
 /* 104 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 105 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 106 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 107 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 108 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 109 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 110 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 111 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 112 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 113 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 114 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 115 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 116 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 117 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 118 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 119 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 120 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 121 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 122 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 123 */ "multi_create_clause ::= create_subtable_clause",
 /* 124 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 125 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 126 */ "multi_drop_clause ::= drop_table_clause",
 /* 127 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 128 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 129 */ "specific_tags_opt ::=",
 /* 130 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 131 */ "full_table_name ::= table_name",
 /* 132 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 133 */ "column_def_list ::= column_def",
 /* 134 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 135 */ "column_def ::= column_name type_name",
 /* 136 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 137 */ "type_name ::= BOOL",
 /* 138 */ "type_name ::= TINYINT",
 /* 139 */ "type_name ::= SMALLINT",
 /* 140 */ "type_name ::= INT",
 /* 141 */ "type_name ::= INTEGER",
 /* 142 */ "type_name ::= BIGINT",
 /* 143 */ "type_name ::= FLOAT",
 /* 144 */ "type_name ::= DOUBLE",
 /* 145 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 146 */ "type_name ::= TIMESTAMP",
 /* 147 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= TINYINT UNSIGNED",
 /* 149 */ "type_name ::= SMALLINT UNSIGNED",
 /* 150 */ "type_name ::= INT UNSIGNED",
 /* 151 */ "type_name ::= BIGINT UNSIGNED",
 /* 152 */ "type_name ::= JSON",
 /* 153 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 154 */ "type_name ::= MEDIUMBLOB",
 /* 155 */ "type_name ::= BLOB",
 /* 156 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= DECIMAL",
 /* 158 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 159 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 160 */ "tags_def_opt ::=",
 /* 161 */ "tags_def_opt ::= tags_def",
 /* 162 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 163 */ "table_options ::=",
 /* 164 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 165 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 166 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 167 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 168 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 169 */ "alter_table_options ::= alter_table_option",
 /* 170 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 171 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 172 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 173 */ "col_name_list ::= col_name",
 /* 174 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 175 */ "col_name ::= column_name",
 /* 176 */ "cmd ::= SHOW DNODES",
 /* 177 */ "cmd ::= SHOW USERS",
 /* 178 */ "cmd ::= SHOW DATABASES",
 /* 179 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 180 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 181 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 182 */ "cmd ::= SHOW MNODES",
 /* 183 */ "cmd ::= SHOW MODULES",
 /* 184 */ "cmd ::= SHOW QNODES",
 /* 185 */ "cmd ::= SHOW FUNCTIONS",
 /* 186 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 187 */ "cmd ::= SHOW STREAMS",
 /* 188 */ "cmd ::= SHOW ACCOUNTS",
 /* 189 */ "cmd ::= SHOW APPS",
 /* 190 */ "cmd ::= SHOW CONNECTIONS",
 /* 191 */ "cmd ::= SHOW LICENCE",
 /* 192 */ "cmd ::= SHOW GRANTS",
 /* 193 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 194 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 195 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 196 */ "cmd ::= SHOW QUERIES",
 /* 197 */ "cmd ::= SHOW SCORES",
 /* 198 */ "cmd ::= SHOW TOPICS",
 /* 199 */ "cmd ::= SHOW VARIABLES",
 /* 200 */ "cmd ::= SHOW BNODES",
 /* 201 */ "cmd ::= SHOW SNODES",
 /* 202 */ "cmd ::= SHOW CLUSTER",
 /* 203 */ "cmd ::= SHOW TRANSACTIONS",
 /* 204 */ "db_name_cond_opt ::=",
 /* 205 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 206 */ "like_pattern_opt ::=",
 /* 207 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 208 */ "table_name_cond ::= table_name",
 /* 209 */ "from_db_opt ::=",
 /* 210 */ "from_db_opt ::= FROM db_name",
 /* 211 */ "func_name_list ::= func_name",
 /* 212 */ "func_name_list ::= func_name_list NK_COMMA func_name",
 /* 213 */ "func_name ::= function_name",
 /* 214 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 215 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 216 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 217 */ "index_options ::=",
 /* 218 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 219 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 220 */ "func_list ::= func",
 /* 221 */ "func_list ::= func_list NK_COMMA func",
 /* 222 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 223 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 224 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 225 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 226 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 227 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 228 */ "cmd ::= DESC full_table_name",
 /* 229 */ "cmd ::= DESCRIBE full_table_name",
 /* 230 */ "cmd ::= RESET QUERY CACHE",
 /* 231 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 232 */ "analyze_opt ::=",
 /* 233 */ "analyze_opt ::= ANALYZE",
 /* 234 */ "explain_options ::=",
 /* 235 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 236 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 237 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 238 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 239 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 240 */ "agg_func_opt ::=",
 /* 241 */ "agg_func_opt ::= AGGREGATE",
 /* 242 */ "bufsize_opt ::=",
 /* 243 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 244 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 245 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 246 */ "into_opt ::=",
 /* 247 */ "into_opt ::= INTO full_table_name",
 /* 248 */ "stream_options ::=",
 /* 249 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 250 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 251 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 252 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 253 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 254 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 255 */ "cmd ::= BALANCE VGROUP",
 /* 256 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 257 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 258 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 259 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 260 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 261 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 262 */ "cmd ::= query_expression",
 /* 263 */ "literal ::= NK_INTEGER",
 /* 264 */ "literal ::= NK_FLOAT",
 /* 265 */ "literal ::= NK_STRING",
 /* 266 */ "literal ::= NK_BOOL",
 /* 267 */ "literal ::= TIMESTAMP NK_STRING",
 /* 268 */ "literal ::= duration_literal",
 /* 269 */ "literal ::= NULL",
 /* 270 */ "literal ::= NK_QUESTION",
 /* 271 */ "duration_literal ::= NK_VARIABLE",
 /* 272 */ "signed ::= NK_INTEGER",
 /* 273 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 274 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 275 */ "signed ::= NK_FLOAT",
 /* 276 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 277 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 278 */ "signed_literal ::= signed",
 /* 279 */ "signed_literal ::= NK_STRING",
 /* 280 */ "signed_literal ::= NK_BOOL",
 /* 281 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 282 */ "signed_literal ::= duration_literal",
 /* 283 */ "signed_literal ::= NULL",
 /* 284 */ "signed_literal ::= literal_func",
 /* 285 */ "literal_list ::= signed_literal",
 /* 286 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 287 */ "db_name ::= NK_ID",
 /* 288 */ "table_name ::= NK_ID",
 /* 289 */ "column_name ::= NK_ID",
 /* 290 */ "function_name ::= NK_ID",
 /* 291 */ "table_alias ::= NK_ID",
 /* 292 */ "column_alias ::= NK_ID",
 /* 293 */ "user_name ::= NK_ID",
 /* 294 */ "index_name ::= NK_ID",
 /* 295 */ "topic_name ::= NK_ID",
 /* 296 */ "stream_name ::= NK_ID",
 /* 297 */ "cgroup_name ::= NK_ID",
 /* 298 */ "expression ::= literal",
 /* 299 */ "expression ::= pseudo_column",
 /* 300 */ "expression ::= column_reference",
 /* 301 */ "expression ::= function_expression",
 /* 302 */ "expression ::= subquery",
 /* 303 */ "expression ::= NK_LP expression NK_RP",
 /* 304 */ "expression ::= NK_PLUS expression",
 /* 305 */ "expression ::= NK_MINUS expression",
 /* 306 */ "expression ::= expression NK_PLUS expression",
 /* 307 */ "expression ::= expression NK_MINUS expression",
 /* 308 */ "expression ::= expression NK_STAR expression",
 /* 309 */ "expression ::= expression NK_SLASH expression",
 /* 310 */ "expression ::= expression NK_REM expression",
 /* 311 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 312 */ "expression_list ::= expression",
 /* 313 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 314 */ "column_reference ::= column_name",
 /* 315 */ "column_reference ::= table_name NK_DOT column_name",
 /* 316 */ "pseudo_column ::= ROWTS",
 /* 317 */ "pseudo_column ::= TBNAME",
 /* 318 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 319 */ "pseudo_column ::= QSTARTTS",
 /* 320 */ "pseudo_column ::= QENDTS",
 /* 321 */ "pseudo_column ::= WSTARTTS",
 /* 322 */ "pseudo_column ::= WENDTS",
 /* 323 */ "pseudo_column ::= WDURATION",
 /* 324 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 325 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 326 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 327 */ "function_expression ::= literal_func",
 /* 328 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 329 */ "literal_func ::= NOW",
 /* 330 */ "noarg_func ::= NOW",
 /* 331 */ "noarg_func ::= TODAY",
 /* 332 */ "noarg_func ::= TIMEZONE",
 /* 333 */ "star_func ::= COUNT",
 /* 334 */ "star_func ::= FIRST",
 /* 335 */ "star_func ::= LAST",
 /* 336 */ "star_func ::= LAST_ROW",
 /* 337 */ "star_func_para_list ::= NK_STAR",
 /* 338 */ "star_func_para_list ::= other_para_list",
 /* 339 */ "other_para_list ::= star_func_para",
 /* 340 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 341 */ "star_func_para ::= expression",
 /* 342 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 343 */ "predicate ::= expression compare_op expression",
 /* 344 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 345 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 346 */ "predicate ::= expression IS NULL",
 /* 347 */ "predicate ::= expression IS NOT NULL",
 /* 348 */ "predicate ::= expression in_op in_predicate_value",
 /* 349 */ "compare_op ::= NK_LT",
 /* 350 */ "compare_op ::= NK_GT",
 /* 351 */ "compare_op ::= NK_LE",
 /* 352 */ "compare_op ::= NK_GE",
 /* 353 */ "compare_op ::= NK_NE",
 /* 354 */ "compare_op ::= NK_EQ",
 /* 355 */ "compare_op ::= LIKE",
 /* 356 */ "compare_op ::= NOT LIKE",
 /* 357 */ "compare_op ::= MATCH",
 /* 358 */ "compare_op ::= NMATCH",
 /* 359 */ "compare_op ::= CONTAINS",
 /* 360 */ "in_op ::= IN",
 /* 361 */ "in_op ::= NOT IN",
 /* 362 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 363 */ "boolean_value_expression ::= boolean_primary",
 /* 364 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 365 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 366 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 367 */ "boolean_primary ::= predicate",
 /* 368 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 369 */ "common_expression ::= expression",
 /* 370 */ "common_expression ::= boolean_value_expression",
 /* 371 */ "from_clause ::= FROM table_reference_list",
 /* 372 */ "table_reference_list ::= table_reference",
 /* 373 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 374 */ "table_reference ::= table_primary",
 /* 375 */ "table_reference ::= joined_table",
 /* 376 */ "table_primary ::= table_name alias_opt",
 /* 377 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 378 */ "table_primary ::= subquery alias_opt",
 /* 379 */ "table_primary ::= parenthesized_joined_table",
 /* 380 */ "alias_opt ::=",
 /* 381 */ "alias_opt ::= table_alias",
 /* 382 */ "alias_opt ::= AS table_alias",
 /* 383 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 384 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 385 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 386 */ "join_type ::=",
 /* 387 */ "join_type ::= INNER",
 /* 388 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 389 */ "set_quantifier_opt ::=",
 /* 390 */ "set_quantifier_opt ::= DISTINCT",
 /* 391 */ "set_quantifier_opt ::= ALL",
 /* 392 */ "select_list ::= NK_STAR",
 /* 393 */ "select_list ::= select_sublist",
 /* 394 */ "select_sublist ::= select_item",
 /* 395 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 396 */ "select_item ::= common_expression",
 /* 397 */ "select_item ::= common_expression column_alias",
 /* 398 */ "select_item ::= common_expression AS column_alias",
 /* 399 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 400 */ "where_clause_opt ::=",
 /* 401 */ "where_clause_opt ::= WHERE search_condition",
 /* 402 */ "partition_by_clause_opt ::=",
 /* 403 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 404 */ "twindow_clause_opt ::=",
 /* 405 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 406 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 407 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 408 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 409 */ "sliding_opt ::=",
 /* 410 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 411 */ "fill_opt ::=",
 /* 412 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 413 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 414 */ "fill_mode ::= NONE",
 /* 415 */ "fill_mode ::= PREV",
 /* 416 */ "fill_mode ::= NULL",
 /* 417 */ "fill_mode ::= LINEAR",
 /* 418 */ "fill_mode ::= NEXT",
 /* 419 */ "group_by_clause_opt ::=",
 /* 420 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 421 */ "group_by_list ::= expression",
 /* 422 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 423 */ "having_clause_opt ::=",
 /* 424 */ "having_clause_opt ::= HAVING search_condition",
 /* 425 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 426 */ "query_expression_body ::= query_primary",
 /* 427 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 428 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 429 */ "query_primary ::= query_specification",
 /* 430 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 431 */ "order_by_clause_opt ::=",
 /* 432 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 433 */ "slimit_clause_opt ::=",
 /* 434 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 435 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 436 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 437 */ "limit_clause_opt ::=",
 /* 438 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 439 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 440 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 441 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 442 */ "search_condition ::= common_expression",
 /* 443 */ "sort_specification_list ::= sort_specification",
 /* 444 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 445 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 446 */ "ordering_specification_opt ::=",
 /* 447 */ "ordering_specification_opt ::= ASC",
 /* 448 */ "ordering_specification_opt ::= DESC",
 /* 449 */ "null_ordering_opt ::=",
 /* 450 */ "null_ordering_opt ::= NULLS FIRST",
 /* 451 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 238: /* cmd */
    case 241: /* literal */
    case 252: /* db_options */
    case 254: /* alter_db_options */
    case 259: /* retention */
    case 260: /* full_table_name */
    case 263: /* table_options */
    case 267: /* alter_table_clause */
    case 268: /* alter_table_options */
    case 271: /* signed_literal */
    case 272: /* create_subtable_clause */
    case 275: /* drop_table_clause */
    case 278: /* column_def */
    case 281: /* col_name */
    case 282: /* db_name_cond_opt */
    case 283: /* like_pattern_opt */
    case 284: /* table_name_cond */
    case 285: /* from_db_opt */
    case 286: /* func_name */
    case 289: /* index_options */
    case 291: /* duration_literal */
    case 292: /* sliding_opt */
    case 293: /* func */
    case 296: /* query_expression */
    case 299: /* explain_options */
    case 303: /* stream_options */
    case 304: /* into_opt */
    case 306: /* where_clause_opt */
    case 307: /* signed */
    case 308: /* literal_func */
    case 311: /* expression */
    case 312: /* pseudo_column */
    case 313: /* column_reference */
    case 314: /* function_expression */
    case 315: /* subquery */
    case 320: /* star_func_para */
    case 321: /* predicate */
    case 324: /* in_predicate_value */
    case 325: /* boolean_value_expression */
    case 326: /* boolean_primary */
    case 327: /* common_expression */
    case 328: /* from_clause */
    case 329: /* table_reference_list */
    case 330: /* table_reference */
    case 331: /* table_primary */
    case 332: /* joined_table */
    case 334: /* parenthesized_joined_table */
    case 336: /* search_condition */
    case 337: /* query_specification */
    case 341: /* twindow_clause_opt */
    case 343: /* having_clause_opt */
    case 345: /* select_item */
    case 346: /* fill_opt */
    case 349: /* query_expression_body */
    case 351: /* slimit_clause_opt */
    case 352: /* limit_clause_opt */
    case 353: /* query_primary */
    case 355: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy172)); 
}
      break;
    case 239: /* account_options */
    case 240: /* alter_account_options */
    case 242: /* alter_account_option */
    case 301: /* bufsize_opt */
{
 
}
      break;
    case 243: /* user_name */
    case 245: /* priv_level */
    case 248: /* db_name */
    case 249: /* dnode_endpoint */
    case 250: /* dnode_host_name */
    case 269: /* column_name */
    case 277: /* table_name */
    case 287: /* function_name */
    case 288: /* index_name */
    case 295: /* topic_name */
    case 297: /* cgroup_name */
    case 302: /* stream_name */
    case 309: /* table_alias */
    case 310: /* column_alias */
    case 316: /* star_func */
    case 318: /* noarg_func */
    case 333: /* alias_opt */
{
 
}
      break;
    case 244: /* privileges */
    case 246: /* priv_type_list */
    case 247: /* priv_type */
{
 
}
      break;
    case 251: /* not_exists_opt */
    case 253: /* exists_opt */
    case 298: /* analyze_opt */
    case 300: /* agg_func_opt */
    case 338: /* set_quantifier_opt */
{
 
}
      break;
    case 255: /* integer_list */
    case 256: /* variable_list */
    case 257: /* retention_list */
    case 261: /* column_def_list */
    case 262: /* tags_def_opt */
    case 264: /* multi_create_clause */
    case 265: /* tags_def */
    case 266: /* multi_drop_clause */
    case 273: /* specific_tags_opt */
    case 274: /* literal_list */
    case 276: /* col_name_list */
    case 279: /* func_name_list */
    case 290: /* func_list */
    case 294: /* expression_list */
    case 305: /* dnode_list */
    case 317: /* star_func_para_list */
    case 319: /* other_para_list */
    case 339: /* select_list */
    case 340: /* partition_by_clause_opt */
    case 342: /* group_by_clause_opt */
    case 344: /* select_sublist */
    case 348: /* group_by_list */
    case 350: /* order_by_clause_opt */
    case 354: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy60)); 
}
      break;
    case 258: /* alter_db_option */
    case 280: /* alter_table_option */
{
 
}
      break;
    case 270: /* type_name */
{
 
}
      break;
    case 322: /* compare_op */
    case 323: /* in_op */
{
 
}
      break;
    case 335: /* join_type */
{
 
}
      break;
    case 347: /* fill_mode */
{
 
}
      break;
    case 356: /* ordering_specification_opt */
{
 
}
      break;
    case 357: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  238,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  238,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  239,    0 }, /* (2) account_options ::= */
  {  239,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  239,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  239,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  239,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  239,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  239,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  239,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  239,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  239,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  240,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  240,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  242,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  242,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  242,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  242,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  242,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  242,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  242,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  242,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  242,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  242,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  238,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  238,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  238,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  238,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  238,   -6 }, /* (28) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  238,   -6 }, /* (29) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  244,   -1 }, /* (30) privileges ::= ALL */
  {  244,   -1 }, /* (31) privileges ::= priv_type_list */
  {  246,   -1 }, /* (32) priv_type_list ::= priv_type */
  {  246,   -3 }, /* (33) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  247,   -1 }, /* (34) priv_type ::= READ */
  {  247,   -1 }, /* (35) priv_type ::= WRITE */
  {  245,   -3 }, /* (36) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  245,   -3 }, /* (37) priv_level ::= db_name NK_DOT NK_STAR */
  {  238,   -3 }, /* (38) cmd ::= CREATE DNODE dnode_endpoint */
  {  238,   -5 }, /* (39) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  238,   -3 }, /* (40) cmd ::= DROP DNODE NK_INTEGER */
  {  238,   -3 }, /* (41) cmd ::= DROP DNODE dnode_endpoint */
  {  238,   -4 }, /* (42) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  238,   -5 }, /* (43) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  238,   -4 }, /* (44) cmd ::= ALTER ALL DNODES NK_STRING */
  {  238,   -5 }, /* (45) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  249,   -1 }, /* (46) dnode_endpoint ::= NK_STRING */
  {  250,   -1 }, /* (47) dnode_host_name ::= NK_ID */
  {  250,   -1 }, /* (48) dnode_host_name ::= NK_IPTOKEN */
  {  238,   -3 }, /* (49) cmd ::= ALTER LOCAL NK_STRING */
  {  238,   -4 }, /* (50) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  238,   -5 }, /* (51) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (52) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (53) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (54) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (55) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (56) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (57) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (58) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (59) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  238,   -4 }, /* (60) cmd ::= DROP DATABASE exists_opt db_name */
  {  238,   -2 }, /* (61) cmd ::= USE db_name */
  {  238,   -4 }, /* (62) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  251,   -3 }, /* (63) not_exists_opt ::= IF NOT EXISTS */
  {  251,    0 }, /* (64) not_exists_opt ::= */
  {  253,   -2 }, /* (65) exists_opt ::= IF EXISTS */
  {  253,    0 }, /* (66) exists_opt ::= */
  {  252,    0 }, /* (67) db_options ::= */
  {  252,   -3 }, /* (68) db_options ::= db_options BUFFER NK_INTEGER */
  {  252,   -3 }, /* (69) db_options ::= db_options CACHELAST NK_INTEGER */
  {  252,   -3 }, /* (70) db_options ::= db_options COMP NK_INTEGER */
  {  252,   -3 }, /* (71) db_options ::= db_options DAYS NK_INTEGER */
  {  252,   -3 }, /* (72) db_options ::= db_options DAYS NK_VARIABLE */
  {  252,   -3 }, /* (73) db_options ::= db_options FSYNC NK_INTEGER */
  {  252,   -3 }, /* (74) db_options ::= db_options MAXROWS NK_INTEGER */
  {  252,   -3 }, /* (75) db_options ::= db_options MINROWS NK_INTEGER */
  {  252,   -3 }, /* (76) db_options ::= db_options KEEP integer_list */
  {  252,   -3 }, /* (77) db_options ::= db_options KEEP variable_list */
  {  252,   -3 }, /* (78) db_options ::= db_options PAGES NK_INTEGER */
  {  252,   -3 }, /* (79) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  252,   -3 }, /* (80) db_options ::= db_options PRECISION NK_STRING */
  {  252,   -3 }, /* (81) db_options ::= db_options REPLICA NK_INTEGER */
  {  252,   -3 }, /* (82) db_options ::= db_options STRICT NK_INTEGER */
  {  252,   -3 }, /* (83) db_options ::= db_options WAL NK_INTEGER */
  {  252,   -3 }, /* (84) db_options ::= db_options VGROUPS NK_INTEGER */
  {  252,   -3 }, /* (85) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  252,   -3 }, /* (86) db_options ::= db_options RETENTIONS retention_list */
  {  252,   -3 }, /* (87) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  254,   -1 }, /* (88) alter_db_options ::= alter_db_option */
  {  254,   -2 }, /* (89) alter_db_options ::= alter_db_options alter_db_option */
  {  258,   -2 }, /* (90) alter_db_option ::= BUFFER NK_INTEGER */
  {  258,   -2 }, /* (91) alter_db_option ::= CACHELAST NK_INTEGER */
  {  258,   -2 }, /* (92) alter_db_option ::= FSYNC NK_INTEGER */
  {  258,   -2 }, /* (93) alter_db_option ::= KEEP integer_list */
  {  258,   -2 }, /* (94) alter_db_option ::= KEEP variable_list */
  {  258,   -2 }, /* (95) alter_db_option ::= PAGES NK_INTEGER */
  {  258,   -2 }, /* (96) alter_db_option ::= REPLICA NK_INTEGER */
  {  258,   -2 }, /* (97) alter_db_option ::= STRICT NK_INTEGER */
  {  258,   -2 }, /* (98) alter_db_option ::= WAL NK_INTEGER */
  {  255,   -1 }, /* (99) integer_list ::= NK_INTEGER */
  {  255,   -3 }, /* (100) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  256,   -1 }, /* (101) variable_list ::= NK_VARIABLE */
  {  256,   -3 }, /* (102) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  257,   -1 }, /* (103) retention_list ::= retention */
  {  257,   -3 }, /* (104) retention_list ::= retention_list NK_COMMA retention */
  {  259,   -3 }, /* (105) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  238,   -9 }, /* (106) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  238,   -3 }, /* (107) cmd ::= CREATE TABLE multi_create_clause */
  {  238,   -9 }, /* (108) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  238,   -3 }, /* (109) cmd ::= DROP TABLE multi_drop_clause */
  {  238,   -4 }, /* (110) cmd ::= DROP STABLE exists_opt full_table_name */
  {  238,   -3 }, /* (111) cmd ::= ALTER TABLE alter_table_clause */
  {  238,   -3 }, /* (112) cmd ::= ALTER STABLE alter_table_clause */
  {  267,   -2 }, /* (113) alter_table_clause ::= full_table_name alter_table_options */
  {  267,   -5 }, /* (114) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  267,   -4 }, /* (115) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  267,   -5 }, /* (116) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  267,   -5 }, /* (117) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  267,   -5 }, /* (118) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  267,   -4 }, /* (119) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  267,   -5 }, /* (120) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  267,   -5 }, /* (121) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  267,   -6 }, /* (122) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  264,   -1 }, /* (123) multi_create_clause ::= create_subtable_clause */
  {  264,   -2 }, /* (124) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  272,  -10 }, /* (125) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  266,   -1 }, /* (126) multi_drop_clause ::= drop_table_clause */
  {  266,   -2 }, /* (127) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  275,   -2 }, /* (128) drop_table_clause ::= exists_opt full_table_name */
  {  273,    0 }, /* (129) specific_tags_opt ::= */
  {  273,   -3 }, /* (130) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  260,   -1 }, /* (131) full_table_name ::= table_name */
  {  260,   -3 }, /* (132) full_table_name ::= db_name NK_DOT table_name */
  {  261,   -1 }, /* (133) column_def_list ::= column_def */
  {  261,   -3 }, /* (134) column_def_list ::= column_def_list NK_COMMA column_def */
  {  278,   -2 }, /* (135) column_def ::= column_name type_name */
  {  278,   -4 }, /* (136) column_def ::= column_name type_name COMMENT NK_STRING */
  {  270,   -1 }, /* (137) type_name ::= BOOL */
  {  270,   -1 }, /* (138) type_name ::= TINYINT */
  {  270,   -1 }, /* (139) type_name ::= SMALLINT */
  {  270,   -1 }, /* (140) type_name ::= INT */
  {  270,   -1 }, /* (141) type_name ::= INTEGER */
  {  270,   -1 }, /* (142) type_name ::= BIGINT */
  {  270,   -1 }, /* (143) type_name ::= FLOAT */
  {  270,   -1 }, /* (144) type_name ::= DOUBLE */
  {  270,   -4 }, /* (145) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  270,   -1 }, /* (146) type_name ::= TIMESTAMP */
  {  270,   -4 }, /* (147) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  270,   -2 }, /* (148) type_name ::= TINYINT UNSIGNED */
  {  270,   -2 }, /* (149) type_name ::= SMALLINT UNSIGNED */
  {  270,   -2 }, /* (150) type_name ::= INT UNSIGNED */
  {  270,   -2 }, /* (151) type_name ::= BIGINT UNSIGNED */
  {  270,   -1 }, /* (152) type_name ::= JSON */
  {  270,   -4 }, /* (153) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  270,   -1 }, /* (154) type_name ::= MEDIUMBLOB */
  {  270,   -1 }, /* (155) type_name ::= BLOB */
  {  270,   -4 }, /* (156) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  270,   -1 }, /* (157) type_name ::= DECIMAL */
  {  270,   -4 }, /* (158) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  270,   -6 }, /* (159) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  262,    0 }, /* (160) tags_def_opt ::= */
  {  262,   -1 }, /* (161) tags_def_opt ::= tags_def */
  {  265,   -4 }, /* (162) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  263,    0 }, /* (163) table_options ::= */
  {  263,   -3 }, /* (164) table_options ::= table_options COMMENT NK_STRING */
  {  263,   -3 }, /* (165) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  263,   -5 }, /* (166) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  263,   -3 }, /* (167) table_options ::= table_options TTL NK_INTEGER */
  {  263,   -5 }, /* (168) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  268,   -1 }, /* (169) alter_table_options ::= alter_table_option */
  {  268,   -2 }, /* (170) alter_table_options ::= alter_table_options alter_table_option */
  {  280,   -2 }, /* (171) alter_table_option ::= COMMENT NK_STRING */
  {  280,   -2 }, /* (172) alter_table_option ::= TTL NK_INTEGER */
  {  276,   -1 }, /* (173) col_name_list ::= col_name */
  {  276,   -3 }, /* (174) col_name_list ::= col_name_list NK_COMMA col_name */
  {  281,   -1 }, /* (175) col_name ::= column_name */
  {  238,   -2 }, /* (176) cmd ::= SHOW DNODES */
  {  238,   -2 }, /* (177) cmd ::= SHOW USERS */
  {  238,   -2 }, /* (178) cmd ::= SHOW DATABASES */
  {  238,   -4 }, /* (179) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  238,   -4 }, /* (180) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  238,   -3 }, /* (181) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  238,   -2 }, /* (182) cmd ::= SHOW MNODES */
  {  238,   -2 }, /* (183) cmd ::= SHOW MODULES */
  {  238,   -2 }, /* (184) cmd ::= SHOW QNODES */
  {  238,   -2 }, /* (185) cmd ::= SHOW FUNCTIONS */
  {  238,   -5 }, /* (186) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  238,   -2 }, /* (187) cmd ::= SHOW STREAMS */
  {  238,   -2 }, /* (188) cmd ::= SHOW ACCOUNTS */
  {  238,   -2 }, /* (189) cmd ::= SHOW APPS */
  {  238,   -2 }, /* (190) cmd ::= SHOW CONNECTIONS */
  {  238,   -2 }, /* (191) cmd ::= SHOW LICENCE */
  {  238,   -2 }, /* (192) cmd ::= SHOW GRANTS */
  {  238,   -4 }, /* (193) cmd ::= SHOW CREATE DATABASE db_name */
  {  238,   -4 }, /* (194) cmd ::= SHOW CREATE TABLE full_table_name */
  {  238,   -4 }, /* (195) cmd ::= SHOW CREATE STABLE full_table_name */
  {  238,   -2 }, /* (196) cmd ::= SHOW QUERIES */
  {  238,   -2 }, /* (197) cmd ::= SHOW SCORES */
  {  238,   -2 }, /* (198) cmd ::= SHOW TOPICS */
  {  238,   -2 }, /* (199) cmd ::= SHOW VARIABLES */
  {  238,   -2 }, /* (200) cmd ::= SHOW BNODES */
  {  238,   -2 }, /* (201) cmd ::= SHOW SNODES */
  {  238,   -2 }, /* (202) cmd ::= SHOW CLUSTER */
  {  238,   -2 }, /* (203) cmd ::= SHOW TRANSACTIONS */
  {  282,    0 }, /* (204) db_name_cond_opt ::= */
  {  282,   -2 }, /* (205) db_name_cond_opt ::= db_name NK_DOT */
  {  283,    0 }, /* (206) like_pattern_opt ::= */
  {  283,   -2 }, /* (207) like_pattern_opt ::= LIKE NK_STRING */
  {  284,   -1 }, /* (208) table_name_cond ::= table_name */
  {  285,    0 }, /* (209) from_db_opt ::= */
  {  285,   -2 }, /* (210) from_db_opt ::= FROM db_name */
  {  279,   -1 }, /* (211) func_name_list ::= func_name */
  {  279,   -3 }, /* (212) func_name_list ::= func_name_list NK_COMMA func_name */
  {  286,   -1 }, /* (213) func_name ::= function_name */
  {  238,   -8 }, /* (214) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  238,  -10 }, /* (215) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  238,   -6 }, /* (216) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  289,    0 }, /* (217) index_options ::= */
  {  289,   -9 }, /* (218) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  289,  -11 }, /* (219) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  290,   -1 }, /* (220) func_list ::= func */
  {  290,   -3 }, /* (221) func_list ::= func_list NK_COMMA func */
  {  293,   -4 }, /* (222) func ::= function_name NK_LP expression_list NK_RP */
  {  238,   -6 }, /* (223) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  238,   -7 }, /* (224) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  238,   -7 }, /* (225) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  238,   -4 }, /* (226) cmd ::= DROP TOPIC exists_opt topic_name */
  {  238,   -7 }, /* (227) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  238,   -2 }, /* (228) cmd ::= DESC full_table_name */
  {  238,   -2 }, /* (229) cmd ::= DESCRIBE full_table_name */
  {  238,   -3 }, /* (230) cmd ::= RESET QUERY CACHE */
  {  238,   -4 }, /* (231) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  298,    0 }, /* (232) analyze_opt ::= */
  {  298,   -1 }, /* (233) analyze_opt ::= ANALYZE */
  {  299,    0 }, /* (234) explain_options ::= */
  {  299,   -3 }, /* (235) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  299,   -3 }, /* (236) explain_options ::= explain_options RATIO NK_FLOAT */
  {  238,   -6 }, /* (237) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  238,  -10 }, /* (238) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  238,   -4 }, /* (239) cmd ::= DROP FUNCTION exists_opt function_name */
  {  300,    0 }, /* (240) agg_func_opt ::= */
  {  300,   -1 }, /* (241) agg_func_opt ::= AGGREGATE */
  {  301,    0 }, /* (242) bufsize_opt ::= */
  {  301,   -2 }, /* (243) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  238,   -8 }, /* (244) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  238,   -4 }, /* (245) cmd ::= DROP STREAM exists_opt stream_name */
  {  304,    0 }, /* (246) into_opt ::= */
  {  304,   -2 }, /* (247) into_opt ::= INTO full_table_name */
  {  303,    0 }, /* (248) stream_options ::= */
  {  303,   -3 }, /* (249) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  303,   -3 }, /* (250) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  303,   -3 }, /* (251) stream_options ::= stream_options WATERMARK duration_literal */
  {  238,   -3 }, /* (252) cmd ::= KILL CONNECTION NK_INTEGER */
  {  238,   -3 }, /* (253) cmd ::= KILL QUERY NK_INTEGER */
  {  238,   -3 }, /* (254) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  238,   -2 }, /* (255) cmd ::= BALANCE VGROUP */
  {  238,   -4 }, /* (256) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  238,   -4 }, /* (257) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  305,   -2 }, /* (258) dnode_list ::= DNODE NK_INTEGER */
  {  305,   -3 }, /* (259) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  238,   -3 }, /* (260) cmd ::= SYNCDB db_name REPLICA */
  {  238,   -4 }, /* (261) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  238,   -1 }, /* (262) cmd ::= query_expression */
  {  241,   -1 }, /* (263) literal ::= NK_INTEGER */
  {  241,   -1 }, /* (264) literal ::= NK_FLOAT */
  {  241,   -1 }, /* (265) literal ::= NK_STRING */
  {  241,   -1 }, /* (266) literal ::= NK_BOOL */
  {  241,   -2 }, /* (267) literal ::= TIMESTAMP NK_STRING */
  {  241,   -1 }, /* (268) literal ::= duration_literal */
  {  241,   -1 }, /* (269) literal ::= NULL */
  {  241,   -1 }, /* (270) literal ::= NK_QUESTION */
  {  291,   -1 }, /* (271) duration_literal ::= NK_VARIABLE */
  {  307,   -1 }, /* (272) signed ::= NK_INTEGER */
  {  307,   -2 }, /* (273) signed ::= NK_PLUS NK_INTEGER */
  {  307,   -2 }, /* (274) signed ::= NK_MINUS NK_INTEGER */
  {  307,   -1 }, /* (275) signed ::= NK_FLOAT */
  {  307,   -2 }, /* (276) signed ::= NK_PLUS NK_FLOAT */
  {  307,   -2 }, /* (277) signed ::= NK_MINUS NK_FLOAT */
  {  271,   -1 }, /* (278) signed_literal ::= signed */
  {  271,   -1 }, /* (279) signed_literal ::= NK_STRING */
  {  271,   -1 }, /* (280) signed_literal ::= NK_BOOL */
  {  271,   -2 }, /* (281) signed_literal ::= TIMESTAMP NK_STRING */
  {  271,   -1 }, /* (282) signed_literal ::= duration_literal */
  {  271,   -1 }, /* (283) signed_literal ::= NULL */
  {  271,   -1 }, /* (284) signed_literal ::= literal_func */
  {  274,   -1 }, /* (285) literal_list ::= signed_literal */
  {  274,   -3 }, /* (286) literal_list ::= literal_list NK_COMMA signed_literal */
  {  248,   -1 }, /* (287) db_name ::= NK_ID */
  {  277,   -1 }, /* (288) table_name ::= NK_ID */
  {  269,   -1 }, /* (289) column_name ::= NK_ID */
  {  287,   -1 }, /* (290) function_name ::= NK_ID */
  {  309,   -1 }, /* (291) table_alias ::= NK_ID */
  {  310,   -1 }, /* (292) column_alias ::= NK_ID */
  {  243,   -1 }, /* (293) user_name ::= NK_ID */
  {  288,   -1 }, /* (294) index_name ::= NK_ID */
  {  295,   -1 }, /* (295) topic_name ::= NK_ID */
  {  302,   -1 }, /* (296) stream_name ::= NK_ID */
  {  297,   -1 }, /* (297) cgroup_name ::= NK_ID */
  {  311,   -1 }, /* (298) expression ::= literal */
  {  311,   -1 }, /* (299) expression ::= pseudo_column */
  {  311,   -1 }, /* (300) expression ::= column_reference */
  {  311,   -1 }, /* (301) expression ::= function_expression */
  {  311,   -1 }, /* (302) expression ::= subquery */
  {  311,   -3 }, /* (303) expression ::= NK_LP expression NK_RP */
  {  311,   -2 }, /* (304) expression ::= NK_PLUS expression */
  {  311,   -2 }, /* (305) expression ::= NK_MINUS expression */
  {  311,   -3 }, /* (306) expression ::= expression NK_PLUS expression */
  {  311,   -3 }, /* (307) expression ::= expression NK_MINUS expression */
  {  311,   -3 }, /* (308) expression ::= expression NK_STAR expression */
  {  311,   -3 }, /* (309) expression ::= expression NK_SLASH expression */
  {  311,   -3 }, /* (310) expression ::= expression NK_REM expression */
  {  311,   -3 }, /* (311) expression ::= column_reference NK_ARROW NK_STRING */
  {  294,   -1 }, /* (312) expression_list ::= expression */
  {  294,   -3 }, /* (313) expression_list ::= expression_list NK_COMMA expression */
  {  313,   -1 }, /* (314) column_reference ::= column_name */
  {  313,   -3 }, /* (315) column_reference ::= table_name NK_DOT column_name */
  {  312,   -1 }, /* (316) pseudo_column ::= ROWTS */
  {  312,   -1 }, /* (317) pseudo_column ::= TBNAME */
  {  312,   -3 }, /* (318) pseudo_column ::= table_name NK_DOT TBNAME */
  {  312,   -1 }, /* (319) pseudo_column ::= QSTARTTS */
  {  312,   -1 }, /* (320) pseudo_column ::= QENDTS */
  {  312,   -1 }, /* (321) pseudo_column ::= WSTARTTS */
  {  312,   -1 }, /* (322) pseudo_column ::= WENDTS */
  {  312,   -1 }, /* (323) pseudo_column ::= WDURATION */
  {  314,   -4 }, /* (324) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  314,   -4 }, /* (325) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  314,   -6 }, /* (326) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  314,   -1 }, /* (327) function_expression ::= literal_func */
  {  308,   -3 }, /* (328) literal_func ::= noarg_func NK_LP NK_RP */
  {  308,   -1 }, /* (329) literal_func ::= NOW */
  {  318,   -1 }, /* (330) noarg_func ::= NOW */
  {  318,   -1 }, /* (331) noarg_func ::= TODAY */
  {  318,   -1 }, /* (332) noarg_func ::= TIMEZONE */
  {  316,   -1 }, /* (333) star_func ::= COUNT */
  {  316,   -1 }, /* (334) star_func ::= FIRST */
  {  316,   -1 }, /* (335) star_func ::= LAST */
  {  316,   -1 }, /* (336) star_func ::= LAST_ROW */
  {  317,   -1 }, /* (337) star_func_para_list ::= NK_STAR */
  {  317,   -1 }, /* (338) star_func_para_list ::= other_para_list */
  {  319,   -1 }, /* (339) other_para_list ::= star_func_para */
  {  319,   -3 }, /* (340) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  320,   -1 }, /* (341) star_func_para ::= expression */
  {  320,   -3 }, /* (342) star_func_para ::= table_name NK_DOT NK_STAR */
  {  321,   -3 }, /* (343) predicate ::= expression compare_op expression */
  {  321,   -5 }, /* (344) predicate ::= expression BETWEEN expression AND expression */
  {  321,   -6 }, /* (345) predicate ::= expression NOT BETWEEN expression AND expression */
  {  321,   -3 }, /* (346) predicate ::= expression IS NULL */
  {  321,   -4 }, /* (347) predicate ::= expression IS NOT NULL */
  {  321,   -3 }, /* (348) predicate ::= expression in_op in_predicate_value */
  {  322,   -1 }, /* (349) compare_op ::= NK_LT */
  {  322,   -1 }, /* (350) compare_op ::= NK_GT */
  {  322,   -1 }, /* (351) compare_op ::= NK_LE */
  {  322,   -1 }, /* (352) compare_op ::= NK_GE */
  {  322,   -1 }, /* (353) compare_op ::= NK_NE */
  {  322,   -1 }, /* (354) compare_op ::= NK_EQ */
  {  322,   -1 }, /* (355) compare_op ::= LIKE */
  {  322,   -2 }, /* (356) compare_op ::= NOT LIKE */
  {  322,   -1 }, /* (357) compare_op ::= MATCH */
  {  322,   -1 }, /* (358) compare_op ::= NMATCH */
  {  322,   -1 }, /* (359) compare_op ::= CONTAINS */
  {  323,   -1 }, /* (360) in_op ::= IN */
  {  323,   -2 }, /* (361) in_op ::= NOT IN */
  {  324,   -3 }, /* (362) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  325,   -1 }, /* (363) boolean_value_expression ::= boolean_primary */
  {  325,   -2 }, /* (364) boolean_value_expression ::= NOT boolean_primary */
  {  325,   -3 }, /* (365) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  325,   -3 }, /* (366) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  326,   -1 }, /* (367) boolean_primary ::= predicate */
  {  326,   -3 }, /* (368) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  327,   -1 }, /* (369) common_expression ::= expression */
  {  327,   -1 }, /* (370) common_expression ::= boolean_value_expression */
  {  328,   -2 }, /* (371) from_clause ::= FROM table_reference_list */
  {  329,   -1 }, /* (372) table_reference_list ::= table_reference */
  {  329,   -3 }, /* (373) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  330,   -1 }, /* (374) table_reference ::= table_primary */
  {  330,   -1 }, /* (375) table_reference ::= joined_table */
  {  331,   -2 }, /* (376) table_primary ::= table_name alias_opt */
  {  331,   -4 }, /* (377) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  331,   -2 }, /* (378) table_primary ::= subquery alias_opt */
  {  331,   -1 }, /* (379) table_primary ::= parenthesized_joined_table */
  {  333,    0 }, /* (380) alias_opt ::= */
  {  333,   -1 }, /* (381) alias_opt ::= table_alias */
  {  333,   -2 }, /* (382) alias_opt ::= AS table_alias */
  {  334,   -3 }, /* (383) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  334,   -3 }, /* (384) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  332,   -6 }, /* (385) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  335,    0 }, /* (386) join_type ::= */
  {  335,   -1 }, /* (387) join_type ::= INNER */
  {  337,   -9 }, /* (388) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  338,    0 }, /* (389) set_quantifier_opt ::= */
  {  338,   -1 }, /* (390) set_quantifier_opt ::= DISTINCT */
  {  338,   -1 }, /* (391) set_quantifier_opt ::= ALL */
  {  339,   -1 }, /* (392) select_list ::= NK_STAR */
  {  339,   -1 }, /* (393) select_list ::= select_sublist */
  {  344,   -1 }, /* (394) select_sublist ::= select_item */
  {  344,   -3 }, /* (395) select_sublist ::= select_sublist NK_COMMA select_item */
  {  345,   -1 }, /* (396) select_item ::= common_expression */
  {  345,   -2 }, /* (397) select_item ::= common_expression column_alias */
  {  345,   -3 }, /* (398) select_item ::= common_expression AS column_alias */
  {  345,   -3 }, /* (399) select_item ::= table_name NK_DOT NK_STAR */
  {  306,    0 }, /* (400) where_clause_opt ::= */
  {  306,   -2 }, /* (401) where_clause_opt ::= WHERE search_condition */
  {  340,    0 }, /* (402) partition_by_clause_opt ::= */
  {  340,   -3 }, /* (403) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  341,    0 }, /* (404) twindow_clause_opt ::= */
  {  341,   -6 }, /* (405) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  341,   -4 }, /* (406) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  341,   -6 }, /* (407) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  341,   -8 }, /* (408) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  292,    0 }, /* (409) sliding_opt ::= */
  {  292,   -4 }, /* (410) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  346,    0 }, /* (411) fill_opt ::= */
  {  346,   -4 }, /* (412) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  346,   -6 }, /* (413) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  347,   -1 }, /* (414) fill_mode ::= NONE */
  {  347,   -1 }, /* (415) fill_mode ::= PREV */
  {  347,   -1 }, /* (416) fill_mode ::= NULL */
  {  347,   -1 }, /* (417) fill_mode ::= LINEAR */
  {  347,   -1 }, /* (418) fill_mode ::= NEXT */
  {  342,    0 }, /* (419) group_by_clause_opt ::= */
  {  342,   -3 }, /* (420) group_by_clause_opt ::= GROUP BY group_by_list */
  {  348,   -1 }, /* (421) group_by_list ::= expression */
  {  348,   -3 }, /* (422) group_by_list ::= group_by_list NK_COMMA expression */
  {  343,    0 }, /* (423) having_clause_opt ::= */
  {  343,   -2 }, /* (424) having_clause_opt ::= HAVING search_condition */
  {  296,   -4 }, /* (425) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  349,   -1 }, /* (426) query_expression_body ::= query_primary */
  {  349,   -4 }, /* (427) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  349,   -3 }, /* (428) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  353,   -1 }, /* (429) query_primary ::= query_specification */
  {  353,   -6 }, /* (430) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  350,    0 }, /* (431) order_by_clause_opt ::= */
  {  350,   -3 }, /* (432) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  351,    0 }, /* (433) slimit_clause_opt ::= */
  {  351,   -2 }, /* (434) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  351,   -4 }, /* (435) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  351,   -4 }, /* (436) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  352,    0 }, /* (437) limit_clause_opt ::= */
  {  352,   -2 }, /* (438) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  352,   -4 }, /* (439) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  352,   -4 }, /* (440) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  315,   -3 }, /* (441) subquery ::= NK_LP query_expression NK_RP */
  {  336,   -1 }, /* (442) search_condition ::= common_expression */
  {  354,   -1 }, /* (443) sort_specification_list ::= sort_specification */
  {  354,   -3 }, /* (444) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  355,   -3 }, /* (445) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  356,    0 }, /* (446) ordering_specification_opt ::= */
  {  356,   -1 }, /* (447) ordering_specification_opt ::= ASC */
  {  356,   -1 }, /* (448) ordering_specification_opt ::= DESC */
  {  357,    0 }, /* (449) null_ordering_opt ::= */
  {  357,   -2 }, /* (450) null_ordering_opt ::= NULLS FIRST */
  {  357,   -2 }, /* (451) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,239,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,240,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,239,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,241,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,242,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,240,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,242,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,241,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy105, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy105, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy105); }
        break;
      case 28: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy593, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105); }
        break;
      case 29: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy593, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105); }
        break;
      case 30: /* privileges ::= ALL */
{ yymsp[0].minor.yy593 = PRIVILEGE_TYPE_ALL; }
        break;
      case 31: /* privileges ::= priv_type_list */
      case 32: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==32);
{ yylhsminor.yy593 = yymsp[0].minor.yy593; }
  yymsp[0].minor.yy593 = yylhsminor.yy593;
        break;
      case 33: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy593 = yymsp[-2].minor.yy593 | yymsp[0].minor.yy593; }
  yymsp[-2].minor.yy593 = yylhsminor.yy593;
        break;
      case 34: /* priv_type ::= READ */
{ yymsp[0].minor.yy593 = PRIVILEGE_TYPE_READ; }
        break;
      case 35: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy593 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 36: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy105 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy105 = yylhsminor.yy105;
        break;
      case 37: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy105 = yymsp[-2].minor.yy105; }
  yymsp[-2].minor.yy105 = yylhsminor.yy105;
        break;
      case 38: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy105, NULL); }
        break;
      case 39: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy0); }
        break;
      case 40: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy105); }
        break;
      case 42: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 43: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 45: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 46: /* dnode_endpoint ::= NK_STRING */
      case 47: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==47);
      case 48: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==48);
      case 287: /* db_name ::= NK_ID */ yytestcase(yyruleno==287);
      case 288: /* table_name ::= NK_ID */ yytestcase(yyruleno==288);
      case 289: /* column_name ::= NK_ID */ yytestcase(yyruleno==289);
      case 290: /* function_name ::= NK_ID */ yytestcase(yyruleno==290);
      case 291: /* table_alias ::= NK_ID */ yytestcase(yyruleno==291);
      case 292: /* column_alias ::= NK_ID */ yytestcase(yyruleno==292);
      case 293: /* user_name ::= NK_ID */ yytestcase(yyruleno==293);
      case 294: /* index_name ::= NK_ID */ yytestcase(yyruleno==294);
      case 295: /* topic_name ::= NK_ID */ yytestcase(yyruleno==295);
      case 296: /* stream_name ::= NK_ID */ yytestcase(yyruleno==296);
      case 297: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==297);
      case 330: /* noarg_func ::= NOW */ yytestcase(yyruleno==330);
      case 331: /* noarg_func ::= TODAY */ yytestcase(yyruleno==331);
      case 332: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==332);
      case 333: /* star_func ::= COUNT */ yytestcase(yyruleno==333);
      case 334: /* star_func ::= FIRST */ yytestcase(yyruleno==334);
      case 335: /* star_func ::= LAST */ yytestcase(yyruleno==335);
      case 336: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==336);
{ yylhsminor.yy105 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy105 = yylhsminor.yy105;
        break;
      case 49: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 52: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 53: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy617, &yymsp[-1].minor.yy105, yymsp[0].minor.yy172); }
        break;
      case 60: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy617, &yymsp[0].minor.yy105); }
        break;
      case 61: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy105); }
        break;
      case 62: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy105, yymsp[0].minor.yy172); }
        break;
      case 63: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy617 = true; }
        break;
      case 64: /* not_exists_opt ::= */
      case 66: /* exists_opt ::= */ yytestcase(yyruleno==66);
      case 232: /* analyze_opt ::= */ yytestcase(yyruleno==232);
      case 240: /* agg_func_opt ::= */ yytestcase(yyruleno==240);
      case 389: /* set_quantifier_opt ::= */ yytestcase(yyruleno==389);
{ yymsp[1].minor.yy617 = false; }
        break;
      case 65: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy617 = true; }
        break;
      case 67: /* db_options ::= */
{ yymsp[1].minor.yy172 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 68: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 69: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 70: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 71: /* db_options ::= db_options DAYS NK_INTEGER */
      case 72: /* db_options ::= db_options DAYS NK_VARIABLE */ yytestcase(yyruleno==72);
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 73: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 74: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 75: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 76: /* db_options ::= db_options KEEP integer_list */
      case 77: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==77);
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_KEEP, yymsp[0].minor.yy60); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 78: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 79: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 80: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 81: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 82: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 83: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 84: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 85: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 86: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_RETENTIONS, yymsp[0].minor.yy60); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 87: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 88: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy172 = createAlterDatabaseOptions(pCxt); yylhsminor.yy172 = setAlterDatabaseOption(pCxt, yylhsminor.yy172, &yymsp[0].minor.yy609); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 89: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy172 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy172, &yymsp[0].minor.yy609); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 90: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 91: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 92: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 93: /* alter_db_option ::= KEEP integer_list */
      case 94: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==94);
{ yymsp[-1].minor.yy609.type = DB_OPTION_KEEP; yymsp[-1].minor.yy609.pList = yymsp[0].minor.yy60; }
        break;
      case 95: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_PAGES; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_STRICT; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 98: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_WAL; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy60 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 100: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 259: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==259);
{ yylhsminor.yy60 = addNodeToList(pCxt, yymsp[-2].minor.yy60, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy60 = yylhsminor.yy60;
        break;
      case 101: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy60 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 102: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy60 = addNodeToList(pCxt, yymsp[-2].minor.yy60, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy60 = yylhsminor.yy60;
        break;
      case 103: /* retention_list ::= retention */
      case 123: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==123);
      case 126: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==126);
      case 133: /* column_def_list ::= column_def */ yytestcase(yyruleno==133);
      case 173: /* col_name_list ::= col_name */ yytestcase(yyruleno==173);
      case 211: /* func_name_list ::= func_name */ yytestcase(yyruleno==211);
      case 220: /* func_list ::= func */ yytestcase(yyruleno==220);
      case 285: /* literal_list ::= signed_literal */ yytestcase(yyruleno==285);
      case 339: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==339);
      case 394: /* select_sublist ::= select_item */ yytestcase(yyruleno==394);
      case 443: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==443);
{ yylhsminor.yy60 = createNodeList(pCxt, yymsp[0].minor.yy172); }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 104: /* retention_list ::= retention_list NK_COMMA retention */
      case 134: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==134);
      case 174: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==174);
      case 212: /* func_name_list ::= func_name_list NK_COMMA func_name */ yytestcase(yyruleno==212);
      case 221: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==221);
      case 286: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==286);
      case 340: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==340);
      case 395: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==395);
      case 444: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==444);
{ yylhsminor.yy60 = addNodeToList(pCxt, yymsp[-2].minor.yy60, yymsp[0].minor.yy172); }
  yymsp[-2].minor.yy60 = yylhsminor.yy60;
        break;
      case 105: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy172 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 106: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 108: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==108);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy617, yymsp[-5].minor.yy172, yymsp[-3].minor.yy60, yymsp[-1].minor.yy60, yymsp[0].minor.yy172); }
        break;
      case 107: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy60); }
        break;
      case 109: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy60); }
        break;
      case 110: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy617, yymsp[0].minor.yy172); }
        break;
      case 111: /* cmd ::= ALTER TABLE alter_table_clause */
      case 112: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==112);
      case 262: /* cmd ::= query_expression */ yytestcase(yyruleno==262);
{ pCxt->pRootNode = yymsp[0].minor.yy172; }
        break;
      case 113: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy172 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy172, yymsp[0].minor.yy172); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 114: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy172 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy172, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy105, yymsp[0].minor.yy248); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 115: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy172 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy172, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy105); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 116: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy172 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy172, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy105, yymsp[0].minor.yy248); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 117: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy172 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy172, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy105, &yymsp[0].minor.yy105); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 118: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy172 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy172, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy105, yymsp[0].minor.yy248); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 119: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy172 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy172, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy105); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 120: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy172 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy172, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy105, yymsp[0].minor.yy248); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 121: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy172 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy172, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy105, &yymsp[0].minor.yy105); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 122: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy172 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy172, &yymsp[-2].minor.yy105, yymsp[0].minor.yy172); }
  yymsp[-5].minor.yy172 = yylhsminor.yy172;
        break;
      case 124: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 127: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==127);
{ yylhsminor.yy60 = addNodeToList(pCxt, yymsp[-1].minor.yy60, yymsp[0].minor.yy172); }
  yymsp[-1].minor.yy60 = yylhsminor.yy60;
        break;
      case 125: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy172 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy617, yymsp[-8].minor.yy172, yymsp[-6].minor.yy172, yymsp[-5].minor.yy60, yymsp[-2].minor.yy60, yymsp[0].minor.yy172); }
  yymsp[-9].minor.yy172 = yylhsminor.yy172;
        break;
      case 128: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy172 = createDropTableClause(pCxt, yymsp[-1].minor.yy617, yymsp[0].minor.yy172); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 129: /* specific_tags_opt ::= */
      case 160: /* tags_def_opt ::= */ yytestcase(yyruleno==160);
      case 402: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==402);
      case 419: /* group_by_clause_opt ::= */ yytestcase(yyruleno==419);
      case 431: /* order_by_clause_opt ::= */ yytestcase(yyruleno==431);
{ yymsp[1].minor.yy60 = NULL; }
        break;
      case 130: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy60 = yymsp[-1].minor.yy60; }
        break;
      case 131: /* full_table_name ::= table_name */
{ yylhsminor.yy172 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy105, NULL); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 132: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy172 = createRealTableNode(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105, NULL); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 135: /* column_def ::= column_name type_name */
{ yylhsminor.yy172 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy105, yymsp[0].minor.yy248, NULL); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 136: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy172 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy105, yymsp[-2].minor.yy248, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 137: /* type_name ::= BOOL */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 138: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 139: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 140: /* type_name ::= INT */
      case 141: /* type_name ::= INTEGER */ yytestcase(yyruleno==141);
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 142: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 143: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 144: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 145: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy248 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 146: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 147: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy248 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 148: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy248 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 149: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy248 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 150: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy248 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 151: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy248 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 152: /* type_name ::= JSON */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 153: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy248 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 154: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 155: /* type_name ::= BLOB */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 156: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy248 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 158: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy248 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 159: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy248 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 161: /* tags_def_opt ::= tags_def */
      case 338: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==338);
      case 393: /* select_list ::= select_sublist */ yytestcase(yyruleno==393);
{ yylhsminor.yy60 = yymsp[0].minor.yy60; }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 162: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy60 = yymsp[-1].minor.yy60; }
        break;
      case 163: /* table_options ::= */
{ yymsp[1].minor.yy172 = createDefaultTableOptions(pCxt); }
        break;
      case 164: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy172 = setTableOption(pCxt, yymsp[-2].minor.yy172, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 165: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ yylhsminor.yy172 = setTableOption(pCxt, yymsp[-2].minor.yy172, TABLE_OPTION_FILE_FACTOR, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 166: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ yylhsminor.yy172 = setTableOption(pCxt, yymsp[-4].minor.yy172, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy60); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 167: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy172 = setTableOption(pCxt, yymsp[-2].minor.yy172, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 168: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy172 = setTableOption(pCxt, yymsp[-4].minor.yy172, TABLE_OPTION_SMA, yymsp[-1].minor.yy60); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 169: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy172 = createAlterTableOptions(pCxt); yylhsminor.yy172 = setTableOption(pCxt, yylhsminor.yy172, yymsp[0].minor.yy609.type, &yymsp[0].minor.yy609.val); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 170: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy172 = setTableOption(pCxt, yymsp[-1].minor.yy172, yymsp[0].minor.yy609.type, &yymsp[0].minor.yy609.val); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 171: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy609.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 172: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy609.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 175: /* col_name ::= column_name */
{ yylhsminor.yy172 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy105); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 176: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 177: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 178: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 179: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 180: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 181: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy172, NULL); }
        break;
      case 182: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 183: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 184: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 185: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 186: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 187: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 188: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 189: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 190: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 191: /* cmd ::= SHOW LICENCE */
      case 192: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==192);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 193: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy105); }
        break;
      case 194: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy172); }
        break;
      case 195: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy172); }
        break;
      case 196: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 197: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 198: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 199: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 200: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 201: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 202: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT, NULL, NULL); }
        break;
      case 203: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT, NULL, NULL); }
        break;
      case 204: /* db_name_cond_opt ::= */
      case 209: /* from_db_opt ::= */ yytestcase(yyruleno==209);
{ yymsp[1].minor.yy172 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 205: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy105); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 206: /* like_pattern_opt ::= */
      case 217: /* index_options ::= */ yytestcase(yyruleno==217);
      case 246: /* into_opt ::= */ yytestcase(yyruleno==246);
      case 400: /* where_clause_opt ::= */ yytestcase(yyruleno==400);
      case 404: /* twindow_clause_opt ::= */ yytestcase(yyruleno==404);
      case 409: /* sliding_opt ::= */ yytestcase(yyruleno==409);
      case 411: /* fill_opt ::= */ yytestcase(yyruleno==411);
      case 423: /* having_clause_opt ::= */ yytestcase(yyruleno==423);
      case 433: /* slimit_clause_opt ::= */ yytestcase(yyruleno==433);
      case 437: /* limit_clause_opt ::= */ yytestcase(yyruleno==437);
{ yymsp[1].minor.yy172 = NULL; }
        break;
      case 207: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 208: /* table_name_cond ::= table_name */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy105); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 210: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy105); }
        break;
      case 213: /* func_name ::= function_name */
{ yylhsminor.yy172 = createFunctionNode(pCxt, &yymsp[0].minor.yy105, NULL); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 214: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy617, &yymsp[-3].minor.yy105, &yymsp[-1].minor.yy105, NULL, yymsp[0].minor.yy172); }
        break;
      case 215: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy617, &yymsp[-5].minor.yy105, &yymsp[-3].minor.yy105, yymsp[-1].minor.yy60, NULL); }
        break;
      case 216: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy617, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105); }
        break;
      case 218: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy172 = createIndexOption(pCxt, yymsp[-6].minor.yy60, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), NULL, yymsp[0].minor.yy172); }
        break;
      case 219: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy172 = createIndexOption(pCxt, yymsp[-8].minor.yy60, releaseRawExprNode(pCxt, yymsp[-4].minor.yy172), releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), yymsp[0].minor.yy172); }
        break;
      case 222: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy172 = createFunctionNode(pCxt, &yymsp[-3].minor.yy105, yymsp[-1].minor.yy60); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 223: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy617, &yymsp[-2].minor.yy105, yymsp[0].minor.yy172, NULL, NULL); }
        break;
      case 224: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy617, &yymsp[-3].minor.yy105, NULL, &yymsp[0].minor.yy105, NULL); }
        break;
      case 225: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy617, &yymsp[-3].minor.yy105, NULL, NULL, yymsp[0].minor.yy172); }
        break;
      case 226: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy617, &yymsp[0].minor.yy105); }
        break;
      case 227: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy617, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105); }
        break;
      case 228: /* cmd ::= DESC full_table_name */
      case 229: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==229);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy172); }
        break;
      case 230: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 231: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy617, yymsp[-1].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 233: /* analyze_opt ::= ANALYZE */
      case 241: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==241);
      case 390: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==390);
{ yymsp[0].minor.yy617 = true; }
        break;
      case 234: /* explain_options ::= */
{ yymsp[1].minor.yy172 = createDefaultExplainOptions(pCxt); }
        break;
      case 235: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy172 = setExplainVerbose(pCxt, yymsp[-2].minor.yy172, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 236: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy172 = setExplainRatio(pCxt, yymsp[-2].minor.yy172, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 237: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy60); }
        break;
      case 238: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy617, yymsp[-8].minor.yy617, &yymsp[-5].minor.yy105, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy248, yymsp[0].minor.yy140); }
        break;
      case 239: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy617, &yymsp[0].minor.yy105); }
        break;
      case 242: /* bufsize_opt ::= */
{ yymsp[1].minor.yy140 = 0; }
        break;
      case 243: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy140 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 244: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy617, &yymsp[-4].minor.yy105, yymsp[-2].minor.yy172, yymsp[-3].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 245: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy617, &yymsp[0].minor.yy105); }
        break;
      case 247: /* into_opt ::= INTO full_table_name */
      case 371: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==371);
      case 401: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==401);
      case 424: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==424);
{ yymsp[-1].minor.yy172 = yymsp[0].minor.yy172; }
        break;
      case 248: /* stream_options ::= */
{ yymsp[1].minor.yy172 = createStreamOptions(pCxt); }
        break;
      case 249: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy172)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy172 = yymsp[-2].minor.yy172; }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 250: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy172)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy172 = yymsp[-2].minor.yy172; }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 251: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy172)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy172); yylhsminor.yy172 = yymsp[-2].minor.yy172; }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 252: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 253: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 254: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 255: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 256: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 257: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy60); }
        break;
      case 258: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy60 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 260: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy105); }
        break;
      case 261: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 263: /* literal ::= NK_INTEGER */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 264: /* literal ::= NK_FLOAT */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 265: /* literal ::= NK_STRING */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 266: /* literal ::= NK_BOOL */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 267: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 268: /* literal ::= duration_literal */
      case 278: /* signed_literal ::= signed */ yytestcase(yyruleno==278);
      case 298: /* expression ::= literal */ yytestcase(yyruleno==298);
      case 299: /* expression ::= pseudo_column */ yytestcase(yyruleno==299);
      case 300: /* expression ::= column_reference */ yytestcase(yyruleno==300);
      case 301: /* expression ::= function_expression */ yytestcase(yyruleno==301);
      case 302: /* expression ::= subquery */ yytestcase(yyruleno==302);
      case 327: /* function_expression ::= literal_func */ yytestcase(yyruleno==327);
      case 363: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==363);
      case 367: /* boolean_primary ::= predicate */ yytestcase(yyruleno==367);
      case 369: /* common_expression ::= expression */ yytestcase(yyruleno==369);
      case 370: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==370);
      case 372: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==372);
      case 374: /* table_reference ::= table_primary */ yytestcase(yyruleno==374);
      case 375: /* table_reference ::= joined_table */ yytestcase(yyruleno==375);
      case 379: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==379);
      case 426: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==426);
      case 429: /* query_primary ::= query_specification */ yytestcase(yyruleno==429);
{ yylhsminor.yy172 = yymsp[0].minor.yy172; }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 269: /* literal ::= NULL */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 270: /* literal ::= NK_QUESTION */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 271: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 272: /* signed ::= NK_INTEGER */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 273: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 274: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 275: /* signed ::= NK_FLOAT */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 276: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 277: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 279: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 280: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 281: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 282: /* signed_literal ::= duration_literal */
      case 284: /* signed_literal ::= literal_func */ yytestcase(yyruleno==284);
      case 341: /* star_func_para ::= expression */ yytestcase(yyruleno==341);
      case 396: /* select_item ::= common_expression */ yytestcase(yyruleno==396);
      case 442: /* search_condition ::= common_expression */ yytestcase(yyruleno==442);
{ yylhsminor.yy172 = releaseRawExprNode(pCxt, yymsp[0].minor.yy172); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 283: /* signed_literal ::= NULL */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 303: /* expression ::= NK_LP expression NK_RP */
      case 368: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==368);
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy172)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 304: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy172));
                                                                                  }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 305: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy172), NULL));
                                                                                  }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 306: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172))); 
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 307: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172))); 
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 308: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172))); 
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 309: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172))); 
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 310: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172)));
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 311: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 312: /* expression_list ::= expression */
{ yylhsminor.yy60 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy172)); }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 313: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy60 = addNodeToList(pCxt, yymsp[-2].minor.yy60, releaseRawExprNode(pCxt, yymsp[0].minor.yy172)); }
  yymsp[-2].minor.yy60 = yylhsminor.yy60;
        break;
      case 314: /* column_reference ::= column_name */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy105, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy105)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 315: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105, createColumnNode(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 316: /* pseudo_column ::= ROWTS */
      case 317: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==317);
      case 319: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==319);
      case 320: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==320);
      case 321: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==321);
      case 322: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==322);
      case 323: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==323);
      case 329: /* literal_func ::= NOW */ yytestcase(yyruleno==329);
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 318: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy105)))); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 324: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 325: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==325);
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy105, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy105, yymsp[-1].minor.yy60)); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 326: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy172), yymsp[-1].minor.yy248)); }
  yymsp[-5].minor.yy172 = yylhsminor.yy172;
        break;
      case 328: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy105, NULL)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 337: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy60 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 342: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 399: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==399);
{ yylhsminor.yy172 = createColumnNode(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 343: /* predicate ::= expression compare_op expression */
      case 348: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==348);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy572, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172)));
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 344: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy172), releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172)));
                                                                                  }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 345: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy172), releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172)));
                                                                                  }
  yymsp[-5].minor.yy172 = yylhsminor.yy172;
        break;
      case 346: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), NULL));
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 347: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy172), NULL));
                                                                                  }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 349: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy572 = OP_TYPE_LOWER_THAN; }
        break;
      case 350: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy572 = OP_TYPE_GREATER_THAN; }
        break;
      case 351: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy572 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 352: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy572 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 353: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy572 = OP_TYPE_NOT_EQUAL; }
        break;
      case 354: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy572 = OP_TYPE_EQUAL; }
        break;
      case 355: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy572 = OP_TYPE_LIKE; }
        break;
      case 356: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy572 = OP_TYPE_NOT_LIKE; }
        break;
      case 357: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy572 = OP_TYPE_MATCH; }
        break;
      case 358: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy572 = OP_TYPE_NMATCH; }
        break;
      case 359: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy572 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 360: /* in_op ::= IN */
{ yymsp[0].minor.yy572 = OP_TYPE_IN; }
        break;
      case 361: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy572 = OP_TYPE_NOT_IN; }
        break;
      case 362: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy60)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 364: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy172), NULL));
                                                                                  }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 365: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172)));
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 366: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172)));
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 373: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy172 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy172, yymsp[0].minor.yy172, NULL); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 376: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy172 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy105, &yymsp[0].minor.yy105); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 377: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy172 = createRealTableNode(pCxt, &yymsp[-3].minor.yy105, &yymsp[-1].minor.yy105, &yymsp[0].minor.yy105); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 378: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy172 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy172), &yymsp[0].minor.yy105); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 380: /* alias_opt ::= */
{ yymsp[1].minor.yy105 = nil_token;  }
        break;
      case 381: /* alias_opt ::= table_alias */
{ yylhsminor.yy105 = yymsp[0].minor.yy105; }
  yymsp[0].minor.yy105 = yylhsminor.yy105;
        break;
      case 382: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy105 = yymsp[0].minor.yy105; }
        break;
      case 383: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 384: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==384);
{ yymsp[-2].minor.yy172 = yymsp[-1].minor.yy172; }
        break;
      case 385: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy172 = createJoinTableNode(pCxt, yymsp[-4].minor.yy636, yymsp[-5].minor.yy172, yymsp[-2].minor.yy172, yymsp[0].minor.yy172); }
  yymsp[-5].minor.yy172 = yylhsminor.yy172;
        break;
      case 386: /* join_type ::= */
{ yymsp[1].minor.yy636 = JOIN_TYPE_INNER; }
        break;
      case 387: /* join_type ::= INNER */
{ yymsp[0].minor.yy636 = JOIN_TYPE_INNER; }
        break;
      case 388: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy172 = createSelectStmt(pCxt, yymsp[-7].minor.yy617, yymsp[-6].minor.yy60, yymsp[-5].minor.yy172);
                                                                                    yymsp[-8].minor.yy172 = addWhereClause(pCxt, yymsp[-8].minor.yy172, yymsp[-4].minor.yy172);
                                                                                    yymsp[-8].minor.yy172 = addPartitionByClause(pCxt, yymsp[-8].minor.yy172, yymsp[-3].minor.yy60);
                                                                                    yymsp[-8].minor.yy172 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy172, yymsp[-2].minor.yy172);
                                                                                    yymsp[-8].minor.yy172 = addGroupByClause(pCxt, yymsp[-8].minor.yy172, yymsp[-1].minor.yy60);
                                                                                    yymsp[-8].minor.yy172 = addHavingClause(pCxt, yymsp[-8].minor.yy172, yymsp[0].minor.yy172);
                                                                                  }
        break;
      case 391: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy617 = false; }
        break;
      case 392: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy60 = NULL; }
        break;
      case 397: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy172 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy172), &yymsp[0].minor.yy105); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 398: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy172 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), &yymsp[0].minor.yy105); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 403: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 420: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==420);
      case 432: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==432);
{ yymsp[-2].minor.yy60 = yymsp[0].minor.yy60; }
        break;
      case 405: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy172 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy172), releaseRawExprNode(pCxt, yymsp[-1].minor.yy172)); }
        break;
      case 406: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy172 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy172)); }
        break;
      case 407: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy172 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy172), NULL, yymsp[-1].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 408: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy172 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy172), releaseRawExprNode(pCxt, yymsp[-3].minor.yy172), yymsp[-1].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 410: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy172 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy172); }
        break;
      case 412: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy172 = createFillNode(pCxt, yymsp[-1].minor.yy202, NULL); }
        break;
      case 413: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy172 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy60)); }
        break;
      case 414: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy202 = FILL_MODE_NONE; }
        break;
      case 415: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy202 = FILL_MODE_PREV; }
        break;
      case 416: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy202 = FILL_MODE_NULL; }
        break;
      case 417: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy202 = FILL_MODE_LINEAR; }
        break;
      case 418: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy202 = FILL_MODE_NEXT; }
        break;
      case 421: /* group_by_list ::= expression */
{ yylhsminor.yy60 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy172))); }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 422: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy60 = addNodeToList(pCxt, yymsp[-2].minor.yy60, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy172))); }
  yymsp[-2].minor.yy60 = yylhsminor.yy60;
        break;
      case 425: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy172 = addOrderByClause(pCxt, yymsp[-3].minor.yy172, yymsp[-2].minor.yy60);
                                                                                    yylhsminor.yy172 = addSlimitClause(pCxt, yylhsminor.yy172, yymsp[-1].minor.yy172);
                                                                                    yylhsminor.yy172 = addLimitClause(pCxt, yylhsminor.yy172, yymsp[0].minor.yy172);
                                                                                  }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 427: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy172 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy172, yymsp[0].minor.yy172); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 428: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy172 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy172, yymsp[0].minor.yy172); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 430: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy172 = yymsp[-4].minor.yy172; }
  yy_destructor(yypParser,350,&yymsp[-3].minor);
  yy_destructor(yypParser,351,&yymsp[-2].minor);
  yy_destructor(yypParser,352,&yymsp[-1].minor);
        break;
      case 434: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 438: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==438);
{ yymsp[-1].minor.yy172 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 435: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 439: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==439);
{ yymsp[-3].minor.yy172 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 436: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 440: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==440);
{ yymsp[-3].minor.yy172 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 441: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy172); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 445: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy172 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), yymsp[-1].minor.yy14, yymsp[0].minor.yy17); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 446: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy14 = ORDER_ASC; }
        break;
      case 447: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy14 = ORDER_ASC; }
        break;
      case 448: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy14 = ORDER_DESC; }
        break;
      case 449: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy17 = NULL_ORDER_DEFAULT; }
        break;
      case 450: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy17 = NULL_ORDER_FIRST; }
        break;
      case 451: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy17 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
