/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 259
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SAlterOption yy11;
  ENullOrder yy151;
  EJoinType yy162;
  SToken yy183;
  bool yy215;
  EOperatorType yy366;
  SNode* yy378;
  int32_t yy396;
  EOrder yy400;
  SNodeList* yy404;
  EFillMode yy466;
  SDataType yy504;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYNSTATE             431
#define YYNRULE              338
#define YYNTOKEN             164
#define YY_MAX_SHIFT         430
#define YY_MIN_SHIFTREDUCE   664
#define YY_MAX_SHIFTREDUCE   1001
#define YY_ERROR_ACTION      1002
#define YY_ACCEPT_ACTION     1003
#define YY_NO_ACTION         1004
#define YY_MIN_REDUCE        1005
#define YY_MAX_REDUCE        1342
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1230)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1235, 1220,  225, 1208, 1220,  349,  242,  346,  237, 1204,
 /*    10 */  1210, 1184,   31,   29,   27,   26,   25, 1097,  105, 1208,
 /*    20 */  1017, 1235,  362, 1208, 1235, 1204, 1209,   66,  346, 1204,
 /*    30 */  1209,  346,  320, 1235,  279,  361,   24,  170,  348,  362,
 /*    40 */   346,  348, 1196, 1108,   66, 1196,  361,  211, 1048,  250,
 /*    50 */   334,  285,  107, 1221, 1224,   61, 1221, 1224, 1260,  362,
 /*    60 */  1108,  194,  210, 1256,  269,  323,  196,  349,  283,  884,
 /*    70 */   109,  362,  282, 1185, 1321,  209, 1105,  907,  195,   43,
 /*    80 */  1108, 1148,   31,   29,   27,   26,   25,  117,  123,  335,
 /*    90 */  1334, 1319, 1108,  284,   10, 1099, 1104,  415,  414,  413,
 /*   100 */   412,  411,  410,  409,  408,  407,  406,  405,  404,  403,
 /*   110 */   402,  401,  400,  399,  398,  270,  908,  211,   31,   29,
 /*   120 */    27,   26,   25,    9,    8,   23,  232, 1006,  902,  903,
 /*   130 */   904,  905,  906,  910,  911,  912, 1196,   27,   26,   25,
 /*   140 */    31,   29,   27,   26,   25, 1003, 1028,  907,   78,   64,
 /*   150 */   870,   77,   76,   75,   74,   73,   72,   71,   70,   69,
 /*   160 */   319,  773,  385,  384,  383,  777,  382,  779,  780,  381,
 /*   170 */   782,  378, 1274,  788,  375,  790,  791,  372,  369,  872,
 /*   180 */   291,  118,  286,  325,  321,  290,  908, 1196,  289, 1271,
 /*   190 */   287,  920, 1220,  288,  249,   23,  232,  884,  902,  903,
 /*   200 */   904,  905,  906,  910,  911,  912,   31,   29,   27,   26,
 /*   210 */    25,  324, 1235,  106, 1075,  423,  422,   78, 1321,  333,
 /*   220 */    77,   76,   75,   74,   73,   72,   71,   70,   69,  348,
 /*   230 */    43,  117,  238, 1196,  968, 1319, 1321,  218,  118,   89,
 /*   240 */   104,  874, 1220,   62, 1221, 1224, 1260, 1103, 1110, 1320,
 /*   250 */   227, 1256,  112, 1319,  316,  966,  967,  969,  970,  283,
 /*   260 */   875,  330, 1235,  282,  166,  997,  998,  870,  118,  333,
 /*   270 */   312, 1287, 1220,  219,  251,  217,  216,  263,  281,  348,
 /*   280 */   245,  244,   92, 1196,  284,  362,  264, 1175, 1177,  104,
 /*   290 */   359, 1172, 1235,   62, 1221, 1224, 1260, 1110,  120,  346,
 /*   300 */   227, 1256,  112, 1279,  939,  361, 1108,  362,   90,  348,
 /*   310 */  1027,  700,  360, 1196,  701, 1220,  700,  332,  113, 1267,
 /*   320 */  1268, 1288, 1272,   62, 1221, 1224, 1260,  277, 1108,  330,
 /*   330 */   227, 1256, 1333,    6,  702, 1235, 1026,   30,   28,  241,
 /*   340 */   240, 1294,  346,  165, 1220,  234,  258,  852,  873,  864,
 /*   350 */    92, 1196,  348,   10,  262,  397, 1196,  257,  256,  255,
 /*   360 */   254,  253,  151,  850, 1235,  857,   62, 1221, 1224, 1260,
 /*   370 */   909,  346,   12,  227, 1256, 1333,   90, 1196,  362,   21,
 /*   380 */  1086,  348,  871,  184, 1317, 1196,  114, 1267, 1268,  913,
 /*   390 */  1272,  122,  121,    1, 1155,   62, 1221, 1224, 1260, 1108,
 /*   400 */   224, 1220,  227, 1256, 1333, 1153,   30,   28,  944, 1084,
 /*   410 */    30,   28,  189, 1278,  234, 1138,  852,  427,  234,  363,
 /*   420 */   852, 1235,  943,  118,    9,    8,  270,  939,  346,  851,
 /*   430 */   305,  860,  850, 1155,  951, 1025,  850, 1024,  348,  239,
 /*   440 */   872,   12, 1196, 1085, 1153,   12,   20,  334,  853,  856,
 /*   450 */   865,  856,  201, 1221, 1224,  397,   31,   29,   27,   26,
 /*   460 */    25,  104,    1,  118, 1023,  247,    1,   30,   28, 1111,
 /*   470 */   306, 1321, 1083,  104, 1155,  234, 1196,  852, 1196,   59,
 /*   480 */   246, 1110, 1274, 1220,  117, 1153,  427,  362, 1319,   93,
 /*   490 */   427,  388,  248,  850, 1321, 1155, 1100, 1022,  851, 1270,
 /*   500 */   394,  345,  851, 1235,  393, 1196, 1176,  117, 1108,  337,
 /*   510 */   346, 1319, 1220,   52, 1021, 1020, 1076,  853,  856, 1093,
 /*   520 */   348,  853,  856,    7, 1196,  395, 1019, 1016, 1015,  394,
 /*   530 */  1101, 1014, 1235,  393,   63, 1221, 1224, 1260, 1196,  346,
 /*   540 */   330, 1259, 1256, 1095,  392,  391,  390,  427,  389,  348,
 /*   550 */    30,   28,  347, 1196,  395, 1196, 1196,  942,  234,  851,
 /*   560 */   852,   92, 1013,   63, 1221, 1224, 1260, 1196, 1196, 1196,
 /*   570 */   344, 1256, 1196,  392,  391,  390,  850,  389,  853,  856,
 /*   580 */   334,  899, 1220,  308,   30,   28, 1012,   90, 1011, 1091,
 /*   590 */  1274, 1010,  234,  118,  852,   98, 1009,  163, 1267,  329,
 /*   600 */   852,  328, 1235, 1196, 1321, 1008,    7, 1269,  137,  346,
 /*   610 */   850,  135,   30,   28, 1155,  139,  850,  117,  138,  348,
 /*   620 */   234, 1319,  852, 1196, 1005, 1154,  303, 1196,  141, 1196,
 /*   630 */   427,  140, 1196,   63, 1221, 1224, 1260, 1196,  850,  301,
 /*   640 */     7, 1257,  851, 1044, 1000, 1001, 1196, 1039,   87,   86,
 /*   650 */    85,   84,   83,   82,   81,   80,   79, 1037,  430,  387,
 /*   660 */   336,  853,  856,   58,  427,  292, 1220,  341,    1,  294,
 /*   670 */   427,  143,  187,   54,  142,   88,  851,  965,  156,  297,
 /*   680 */   859,  419,  851,  186,  338, 1220, 1235,  914,  881,   41,
 /*   690 */   154, 1018,  427,  346,  167,  853,  856,  317, 1149,   32,
 /*   700 */    32,  853,  856,  348,  851, 1235,   60, 1196, 1214,  182,
 /*   710 */   233,  160,  346,  845,  276, 1220,  858,  205, 1221, 1224,
 /*   720 */  1212, 1220,  348,  853,  856,   32, 1196,  175, 1290,  313,
 /*   730 */   331,  354,  330, 1236, 1220, 1235,  205, 1221, 1224,  173,
 /*   740 */   358, 1235,  346,   95,  342,  169,  862,    2,  346,  870,
 /*   750 */  1174,  181,  348,   92, 1235,  252, 1196,  311,  348,  339,
 /*   760 */   147,  346, 1196,   96,  260,  766,  204, 1221, 1224,  761,
 /*   770 */   259,  348,  107, 1221, 1224, 1196,  119,   98,  231,   90,
 /*   780 */  1220,   41,  861,  794,  261,  205, 1221, 1224, 1220,  115,
 /*   790 */  1267, 1268,   22, 1272,  878,  367,  265,  326,  267,  798,
 /*   800 */  1235,  804,   31,   29,   27,   26,   25,  346, 1235,  266,
 /*   810 */  1335,   96,  124,   97,  803,  346, 1220,  348,   99,  877,
 /*   820 */   268, 1196, 1220,  271,  235,  348,   98,  127,   42, 1196,
 /*   830 */    96,  205, 1221, 1224,  130,  876, 1235,  278,  280,  203,
 /*   840 */  1221, 1224, 1235,  346, 1220,   68,  307, 1098,  223,  346,
 /*   850 */   134, 1094,  136,  348,  100,  146,  101, 1196, 1096,  348,
 /*   860 */  1092,  102,  103, 1196, 1235,  149,  875,  206, 1221, 1224,
 /*   870 */   309,  346, 1220,  199, 1221, 1224, 1301,  318, 1220,  352,
 /*   880 */   856,  348, 1300, 1291,  159, 1196,  310,  314,    5,  152,
 /*   890 */  1281, 1220, 1235,  315,  226,  207, 1221, 1224, 1235,  346,
 /*   900 */   155,    4,  322,  327,  939,  346,   91,  874,   33,  348,
 /*   910 */   161, 1235,  162, 1196, 1275,  348,  228,  343,  346, 1196,
 /*   920 */  1220,  340,   17,  200, 1221, 1224, 1220, 1242,  348,  208,
 /*   930 */  1221, 1224, 1196,  110, 1183,  350,  351,  355,  177, 1220,
 /*   940 */  1235, 1318, 1232, 1221, 1224, 1336, 1235,  346, 1220,  168,
 /*   950 */  1182,  236,  357,  346,  356,  179,  188,  348,   51, 1235,
 /*   960 */    53, 1196, 1109,  348, 1051,  365,  346, 1196, 1235,  190,
 /*   970 */   185, 1231, 1221, 1224,  426,  346,  348, 1230, 1221, 1224,
 /*   980 */  1196,  197,  198, 1220,  192,  348,  193, 1190,  828, 1196,
 /*   990 */   214, 1221, 1224,  132, 1167, 1166,  111,   94, 1165,  213,
 /*  1000 */  1221, 1224,  275, 1235,  131, 1164, 1163, 1162, 1161, 1160,
 /*  1010 */   346, 1220,  830,  291, 1159,  286, 1158, 1220,  290, 1157,
 /*  1020 */   348,  289, 1156,  287, 1196, 1050,  288,   44, 1189, 1180,
 /*  1030 */   129, 1235,  126, 1087,  215, 1221, 1224, 1235,  346,  713,
 /*  1040 */  1049, 1047,  296,  274,  346, 1036,  273, 1035,  348,  272,
 /*  1050 */  1032, 1089, 1196,   67,  348,  133,  811,  304, 1196,  810,
 /*  1060 */  1088,  809,  212, 1221, 1224,  741, 1045, 1040,  202, 1221,
 /*  1070 */  1224,  145,  740,  739,  299,  738,  220,  128,  221,  293,
 /*  1080 */   737,  125,  144,  295,  736, 1038,  222,  298, 1031, 1030,
 /*  1090 */   300,  302,   65, 1188, 1187,   36, 1179,   14,   45,  150,
 /*  1100 */   148,    3,   34,   15,   32,   40,   48,   37,   39,   11,
 /*  1110 */     8, 1212,  153,  158,  986,  985,  164,  964,  229,  990,
 /*  1120 */   108,  157,  989,  900,  958,  230,   46, 1178,  957,   47,
 /*  1130 */  1004,  866,  936,  353,  935, 1004, 1004, 1004, 1004, 1004,
 /*  1140 */   991,  178, 1046,   19,  882,  366, 1004,   13,  243, 1004,
 /*  1150 */    18,   35,  172,  116,  174,   16,  370,  373,  171,  962,
 /*  1160 */   176,  376, 1004,   49,  379,   50,  772,  800, 1034, 1033,
 /*  1170 */   806,   38, 1029,  802,  795,  792,  733,   54,  725,  368,
 /*  1180 */  1211,  183,  371,  364,  789,  374,  801,  732,  396,  783,
 /*  1190 */   377,  731,  421,  781,  711,  730,  380,  729,   55,  728,
 /*  1200 */   727,   56,   57,  726,  724,  723,  787,  786,  180,  722,
 /*  1210 */   785,  386,  721,  720,  719,  784,  718,  717,  716,  416,
 /*  1220 */   417,  420,  424,  425,  428,  418,  854,  191,  429,  805,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   187,  167,  191,  208,  167,  204,  191,  194,  207,  214,
 /*    10 */   215,  210,   12,   13,   14,   15,   16,  188,  166,  208,
 /*    20 */   168,  187,  173,  208,  187,  214,  215,  178,  194,  214,
 /*    30 */   215,  194,  219,  187,  185,   20,  222,  223,  204,  173,
 /*    40 */   194,  204,  208,  194,  178,  208,   20,   47,    0,  173,
 /*    50 */   213,  185,  218,  219,  220,  218,  219,  220,  221,  173,
 /*    60 */   194,   18,  225,  226,  178,  219,   23,  204,   57,   69,
 /*    70 */   186,  173,   61,  210,  237,  199,  178,   77,   35,  175,
 /*    80 */   194,  197,   12,   13,   14,   15,   16,  250,   45,  255,
 /*    90 */   256,  254,  194,   82,   68,  167,  192,   49,   50,   51,
 /*   100 */    52,   53,   54,   55,   56,   57,   58,   59,   60,   61,
 /*   110 */    62,   63,   64,   65,   66,   46,  116,   47,   12,   13,
 /*   120 */    14,   15,   16,    1,    2,  125,  126,    0,  128,  129,
 /*   130 */   130,  131,  132,  133,  134,  135,  208,   14,   15,   16,
 /*   140 */    12,   13,   14,   15,   16,  164,  167,   77,   21,  106,
 /*   150 */    20,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   160 */   120,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   170 */    92,   93,  216,   95,   96,   97,   98,   99,  100,   20,
 /*   180 */    49,  138,   51,  143,  144,   54,  116,  208,   57,  233,
 /*   190 */    59,   69,  167,   62,  213,  125,  126,   69,  128,  129,
 /*   200 */   130,  131,  132,  133,  134,  135,   12,   13,   14,   15,
 /*   210 */    16,   20,  187,  176,  177,  170,  171,   21,  237,  194,
 /*   220 */    24,   25,   26,   27,   28,   29,   30,   31,   32,  204,
 /*   230 */   175,  250,  179,  208,  127,  254,  237,   35,  138,  184,
 /*   240 */   187,   20,  167,  218,  219,  220,  221,  192,  195,  250,
 /*   250 */   225,  226,  227,  254,  147,  148,  149,  150,  151,   57,
 /*   260 */    20,  173,  187,   61,  239,  159,  160,   20,  138,  194,
 /*   270 */   245,  246,  167,   71,   27,   73,   74,   30,   76,  204,
 /*   280 */   196,  179,  194,  208,   82,  173,   39,  203,  204,  187,
 /*   290 */   178,  194,  187,  218,  219,  220,  221,  195,  201,  194,
 /*   300 */   225,  226,  227,  136,  137,   20,  194,  173,  220,  204,
 /*   310 */   167,   22,  178,  208,   20,  167,   22,  229,  230,  231,
 /*   320 */   232,  246,  234,  218,  219,  220,  221,   38,  194,  173,
 /*   330 */   225,  226,  227,   43,   40,  187,  167,   12,   13,   12,
 /*   340 */    13,  236,  194,  122,  167,   20,   63,   22,   20,   22,
 /*   350 */   194,  208,  204,   68,  107,   46,  208,  110,  111,  112,
 /*   360 */   113,  114,  122,   38,  187,   38,  218,  219,  220,  221,
 /*   370 */   116,  194,   47,  225,  226,  227,  220,  208,  173,  125,
 /*   380 */     0,  204,   20,  178,  236,  208,  230,  231,  232,  135,
 /*   390 */   234,  108,  109,   68,  187,  218,  219,  220,  221,  194,
 /*   400 */   193,  167,  225,  226,  227,  198,   12,   13,   14,    0,
 /*   410 */    12,   13,  180,  236,   20,  183,   22,   92,   20,   92,
 /*   420 */    22,  187,    4,  138,    1,    2,   46,  137,  194,  104,
 /*   430 */   173,  104,   38,  187,   14,  167,   38,  167,  204,  193,
 /*   440 */    20,   47,  208,    0,  198,   47,    2,  213,  123,  124,
 /*   450 */   123,  124,  218,  219,  220,   46,   12,   13,   14,   15,
 /*   460 */    16,  187,   68,  138,  167,  179,   68,   12,   13,  195,
 /*   470 */   213,  237,    0,  187,  187,   20,  208,   22,  208,  172,
 /*   480 */   193,  195,  216,  167,  250,  198,   92,  173,  254,  182,
 /*   490 */    92,   79,  178,   38,  237,  187,  189,  167,  104,  233,
 /*   500 */    57,   47,  104,  187,   61,  208,  198,  250,  194,    3,
 /*   510 */   194,  254,  167,  172,  167,  167,  177,  123,  124,  188,
 /*   520 */   204,  123,  124,   68,  208,   82,  167,  167,  167,   57,
 /*   530 */   189,  167,  187,   61,  218,  219,  220,  221,  208,  194,
 /*   540 */   173,  225,  226,  188,  101,  102,  103,   92,  105,  204,
 /*   550 */    12,   13,   14,  208,   82,  208,  208,  139,   20,  104,
 /*   560 */    22,  194,  167,  218,  219,  220,  221,  208,  208,  208,
 /*   570 */   225,  226,  208,  101,  102,  103,   38,  105,  123,  124,
 /*   580 */   213,  127,  167,   69,   12,   13,  167,  220,  167,  188,
 /*   590 */   216,  167,   20,  138,   22,   81,  167,  230,  231,  232,
 /*   600 */    22,  234,  187,  208,  237,  167,   68,  233,   72,  194,
 /*   610 */    38,   75,   12,   13,  187,   72,   38,  250,   75,  204,
 /*   620 */    20,  254,   22,  208,    0,  198,   21,  208,   72,  208,
 /*   630 */    92,   75,  208,  218,  219,  220,  221,  208,   38,   34,
 /*   640 */    68,  226,  104,    0,  162,  163,  208,    0,   24,   25,
 /*   650 */    26,   27,   28,   29,   30,   31,   32,    0,   19,  188,
 /*   660 */   154,  123,  124,   68,   92,   22,  167,   81,   68,   22,
 /*   670 */    92,   72,   33,   78,   75,   36,  104,   69,   69,   22,
 /*   680 */    38,   42,  104,   44,   81,  167,  187,   69,   69,   81,
 /*   690 */    81,  168,   92,  194,  257,  123,  124,  248,  197,   81,
 /*   700 */    81,  123,  124,  204,  104,  187,   67,  208,   68,   70,
 /*   710 */   211,  242,  194,   69,  170,  167,   38,  218,  219,  220,
 /*   720 */    80,  167,  204,  123,  124,   81,  208,   69,  217,  211,
 /*   730 */   235,   69,  173,  187,  167,  187,  218,  219,  220,   81,
 /*   740 */   101,  187,  194,   81,  158,  251,  104,  238,  194,   20,
 /*   750 */   173,   69,  204,  194,  187,  202,  208,  118,  204,  156,
 /*   760 */   121,  194,  208,   81,  116,   69,  218,  219,  220,   69,
 /*   770 */   200,  204,  218,  219,  220,  208,  115,   81,  211,  220,
 /*   780 */   167,   81,  104,   69,  200,  218,  219,  220,  167,  230,
 /*   790 */   231,  232,    2,  234,   20,   81,  173,  249,  194,   69,
 /*   800 */   187,   69,   12,   13,   14,   15,   16,  194,  187,  212,
 /*   810 */   256,   81,  175,   81,   69,  194,  167,  204,   69,   20,
 /*   820 */   205,  208,  167,  173,  211,  204,   81,  175,  175,  208,
 /*   830 */    81,  218,  219,  220,  175,   20,  187,  169,  187,  218,
 /*   840 */   219,  220,  187,  194,  167,  173,  212,  187,  169,  194,
 /*   850 */   187,  187,  187,  204,  187,  172,  187,  208,  187,  204,
 /*   860 */   187,  187,  187,  208,  187,  172,   20,  218,  219,  220,
 /*   870 */   194,  194,  167,  218,  219,  220,  247,  146,  167,  145,
 /*   880 */   124,  204,  247,  217,  243,  208,  205,  141,  153,  209,
 /*   890 */   244,  167,  187,  208,  208,  218,  219,  220,  187,  194,
 /*   900 */   209,  140,  208,  152,  137,  194,  194,   20,  115,  204,
 /*   910 */   240,  187,  228,  208,  216,  204,  161,  157,  194,  208,
 /*   920 */   167,  155,   68,  218,  219,  220,  167,  224,  204,  218,
 /*   930 */   219,  220,  208,  241,  209,  208,  208,  119,  194,  167,
 /*   940 */   187,  253,  218,  219,  220,  258,  187,  194,  167,  252,
 /*   950 */   209,  208,  205,  194,  206,  172,  183,  204,  172,  187,
 /*   960 */    68,  208,  194,  204,    0,  190,  194,  208,  187,  173,
 /*   970 */   172,  218,  219,  220,  169,  194,  204,  218,  219,  220,
 /*   980 */   208,  181,  181,  167,  174,  204,  165,    0,   80,  208,
 /*   990 */   218,  219,  220,   33,    0,    0,   36,  115,    0,  218,
 /*  1000 */   219,  220,   42,  187,   44,    0,    0,    0,    0,    0,
 /*  1010 */   194,  167,   22,   49,    0,   51,    0,  167,   54,    0,
 /*  1020 */   204,   57,    0,   59,  208,    0,   62,   67,    0,    0,
 /*  1030 */    70,  187,   43,    0,  218,  219,  220,  187,  194,   48,
 /*  1040 */     0,    0,    4,   43,  194,    0,   36,    0,  204,   38,
 /*  1050 */     0,    0,  208,   77,  204,   75,   38,   19,  208,   38,
 /*  1060 */     0,   22,  218,  219,  220,   38,    0,    0,  218,  219,
 /*  1070 */   220,   33,   38,   38,   36,   38,   22,  117,   22,   41,
 /*  1080 */    38,  121,   44,   39,   38,    0,   22,   38,    0,    0,
 /*  1090 */    22,   22,   20,    0,    0,  122,    0,  142,   68,  117,
 /*  1100 */    43,   81,  136,  142,   81,   67,    4,   81,   70,  142,
 /*  1110 */     2,   80,   69,   81,   38,   38,   80,   69,   38,   38,
 /*  1120 */    68,   68,   38,  127,   69,   38,   68,    0,   69,   68,
 /*  1130 */   259,   22,   69,  120,   69,  259,  259,  259,  259,  259,
 /*  1140 */    69,   43,    0,   81,   69,   38,  259,   68,   38,  259,
 /*  1150 */    68,   81,   69,   80,   68,   81,   38,   38,   80,   69,
 /*  1160 */    68,   38,  259,   68,   38,   68,   22,   22,    0,    0,
 /*  1170 */    38,   68,    0,   38,   69,   69,   22,   78,   22,   68,
 /*  1180 */    80,   80,   68,   79,   69,   68,   38,   38,   47,   69,
 /*  1190 */    68,   38,   37,   69,   48,   38,   68,   38,   68,   38,
 /*  1200 */    38,   68,   68,   38,   38,   38,   94,   94,  117,   38,
 /*  1210 */    94,   82,   38,   38,   38,   94,   38,   38,   38,   38,
 /*  1220 */    36,   38,   22,   21,   21,   43,   22,   22,   20,  104,
 /*  1230 */   259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
 /*  1240 */   259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
 /*  1250 */   259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
 /*  1260 */   259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
 /*  1270 */   259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
 /*  1280 */   259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
 /*  1290 */   259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
 /*  1300 */   259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
 /*  1310 */   259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
 /*  1320 */   259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
 /*  1330 */   259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
 /*  1340 */   259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
 /*  1350 */   259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
 /*  1360 */   259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
 /*  1370 */   259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
 /*  1380 */   259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
 /*  1390 */   259,  259,  259,  259,
};
#define YY_SHIFT_COUNT    (430)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1208)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */    43,  325,  394,  398,  398,  398,  398,  455,  398,  398,
 /*    10 */   285,  572,  600,  538,  572,  572,  572,  572,  572,  572,
 /*    20 */   572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
 /*    30 */   572,  572,  572,   26,   26,   26,  130,  327,  327,   15,
 /*    40 */    15,  327,   15,   15,   69,  159,  191,  191,  100,  328,
 /*    50 */   159,   15,   15,  159,   15,  159,  328,  159,  159,   15,
 /*    60 */   309,    0,   70,   70,  247,  196,  202,  578,  131,  578,
 /*    70 */   578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
 /*    80 */   578,  578,  578,  578,  578,  578,  578,  578,  294,  380,
 /*    90 */   221,  221,  221,  409,  362,  328,  159,  159,  159,  412,
 /*   100 */    78,   78,   78,   78,   78,  127,  964,  106,  107,   11,
 /*   110 */    40,  289,  240,  167,  290,  167,  420,  506,  418,  729,
 /*   120 */   661,  648,  648,  729,  774,   69,  362,  799,   69,   69,
 /*   130 */   729,   69,  815,  159,  159,  159,  159,  159,  159,  159,
 /*   140 */   159,  159,  159,  159,  729,  815,  774,  309,  362,  799,
 /*   150 */   309,  846,  731,  734,  756,  731,  734,  756,  756,  735,
 /*   160 */   751,  746,  761,  767,  362,  887,  793,  755,  760,  766,
 /*   170 */   854,  159,  734,  756,  756,  734,  756,  818,  362,  799,
 /*   180 */   309,  412,  309,  362,  892,  729,  309,  815, 1230, 1230,
 /*   190 */  1230, 1230,   48,  624,  639,  960, 1038,  443,  472,  444,
 /*   200 */   790,  128,  194,  194,  194,  194,  194,  194,  194,  283,
 /*   210 */   122,  254,  123,  123,  123,  123,  536,  543,  556,  599,
 /*   220 */   643,  647,  657,  605,  514,  608,  609,  423,  482,  603,
 /*   230 */   586,  618,  454,  619,  640,  644,  658,  662,  682,  696,
 /*   240 */   642,  678,  700,  714,  730,  732,  745,  749,  595,  987,
 /*   250 */   908,  994,  995,  882,  998, 1005, 1006, 1007, 1008, 1009,
 /*   260 */   990, 1014, 1016, 1019, 1022, 1025, 1028, 1029,  989, 1033,
 /*   270 */   991, 1040, 1041, 1011, 1010, 1000, 1045, 1047, 1050, 1051,
 /*   280 */   976,  980, 1018, 1021, 1039, 1060, 1027, 1034, 1035, 1037,
 /*   290 */  1042, 1046, 1066, 1054, 1067, 1056, 1044, 1085, 1064, 1049,
 /*   300 */  1088, 1068, 1089, 1069, 1072, 1093, 1094,  973, 1096, 1030,
 /*   310 */  1057,  982, 1020, 1023,  955, 1043, 1026, 1048, 1052, 1053,
 /*   320 */  1055, 1058, 1059, 1032, 1031, 1061, 1062,  961, 1063, 1065,
 /*   330 */  1036,  966, 1070, 1073, 1071, 1074,  967, 1102, 1076, 1077,
 /*   340 */  1080, 1081, 1084, 1087, 1108,  996, 1078, 1075, 1079, 1082,
 /*   350 */  1083, 1090, 1086, 1092, 1013, 1095, 1127, 1098, 1091, 1097,
 /*   360 */  1099, 1100, 1101, 1109, 1103, 1104, 1105, 1107, 1110, 1111,
 /*   370 */  1106, 1118, 1114, 1115, 1119, 1117, 1120, 1123, 1122, 1124,
 /*   380 */  1126, 1128, 1112, 1113, 1116, 1121, 1144, 1129, 1130, 1132,
 /*   390 */  1125, 1133, 1134, 1135, 1148, 1145, 1146, 1141, 1154, 1149,
 /*   400 */  1153, 1157, 1159, 1161, 1162, 1165, 1156, 1166, 1167, 1171,
 /*   410 */  1174, 1175, 1176, 1178, 1179, 1180, 1142, 1181, 1184, 1182,
 /*   420 */  1168, 1183, 1155, 1169, 1172, 1200, 1202, 1204, 1205, 1203,
 /*   430 */  1208,
};
#define YY_REDUCE_COUNT (191)
#define YY_REDUCE_MIN   (-205)
#define YY_REDUCE_MAX   (850)
static const short yy_reduce_ofst[] = {
 /*     0 */   -19, -163,   25,   75,  105,  148,  177,  234,  316,  345,
 /*    10 */   367, -166,  415,  499,  518,  548,  554,  567,  613,  621,
 /*    20 */   649,  655,  677,  705,  711,  724,  753,  759,  772,  781,
 /*    30 */   816,  844,  850,   88,  156,  559,  257, -189, -185, -151,
 /*    40 */  -134, -205, -114, -102,   55,  207, -187, -154,   -1, -199,
 /*    50 */    53,  112,  134,  246,  205,  102,   84,  287,  286,  314,
 /*    60 */   307, -186, -186, -186, -124, -148, -116,  -72,   37,  -21,
 /*    70 */   143,  169,  268,  270,  297,  330,  347,  348,  359,  360,
 /*    80 */   361,  364,  395,  419,  421,  424,  429,  438,   45,  -96,
 /*    90 */   -44,  266,  374,  341,   97, -137,  274,  308,  427,  232,
 /*   100 */  -171,  331,  355,  401,  471,  523,  339,  437,  449,  501,
 /*   110 */   469,  544,  511,  495,  495,  495,  546,  494,  509,  577,
 /*   120 */   553,  570,  584,  623,  597,  637,  604,  615,  652,  653,
 /*   130 */   650,  659,  668,  651,  660,  663,  664,  665,  667,  669,
 /*   140 */   671,  673,  674,  675,  672,  679,  634,  683,  676,  681,
 /*   150 */   693,  666,  629,  680,  685,  635,  691,  686,  694,  646,
 /*   160 */   641,  692,  670,  495,  712,  698,  684,  687,  688,  697,
 /*   170 */   703,  546,  725,  727,  728,  741,  743,  748,  744,  747,
 /*   180 */   783,  773,  786,  768,  775,  796,  798,  805,  800,  801,
 /*   190 */   810,  821,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*    10 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*    20 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*    30 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*    40 */  1002, 1002, 1002, 1002, 1055, 1002, 1002, 1002, 1002, 1002,
 /*    50 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*    60 */  1053, 1002, 1262, 1002, 1168, 1002, 1002, 1002, 1002, 1002,
 /*    70 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*    80 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1055,
 /*    90 */  1273, 1273, 1273, 1053, 1002, 1002, 1002, 1002, 1002, 1137,
 /*   100 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1337, 1002, 1090,
 /*   110 */  1297, 1002, 1289, 1265, 1279, 1266, 1002, 1322, 1282, 1002,
 /*   120 */  1173, 1170, 1170, 1002, 1002, 1055, 1002, 1002, 1055, 1055,
 /*   130 */  1002, 1055, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*   140 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1053, 1002, 1002,
 /*   150 */  1053, 1002, 1304, 1302, 1002, 1304, 1302, 1002, 1002, 1316,
 /*   160 */  1312, 1295, 1293, 1279, 1002, 1002, 1002, 1340, 1328, 1324,
 /*   170 */  1002, 1002, 1302, 1002, 1002, 1302, 1002, 1181, 1002, 1002,
 /*   180 */  1053, 1002, 1053, 1002, 1106, 1002, 1053, 1002, 1140, 1140,
 /*   190 */  1056, 1007, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*   200 */  1002, 1002, 1234, 1315, 1314, 1233, 1239, 1238, 1237, 1002,
 /*   210 */  1002, 1002, 1228, 1229, 1227, 1226, 1002, 1002, 1002, 1002,
 /*   220 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1263, 1002, 1325,
 /*   230 */  1329, 1002, 1002, 1002, 1213, 1002, 1002, 1002, 1002, 1002,
 /*   240 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*   250 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*   260 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*   270 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*   280 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*   290 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*   300 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*   310 */  1002, 1002, 1286, 1296, 1002, 1002, 1002, 1002, 1002, 1002,
 /*   320 */  1002, 1002, 1002, 1002, 1213, 1002, 1313, 1002, 1272, 1268,
 /*   330 */  1002, 1002, 1264, 1002, 1002, 1323, 1002, 1002, 1002, 1002,
 /*   340 */  1002, 1002, 1002, 1002, 1258, 1002, 1002, 1002, 1002, 1002,
 /*   350 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*   360 */  1002, 1212, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1134,
 /*   370 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*   380 */  1002, 1002, 1119, 1117, 1116, 1115, 1002, 1112, 1002, 1002,
 /*   390 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*   400 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*   410 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*   420 */  1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
 /*   430 */  1002,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "DATABASE",
  /*   45 */ "USE",
  /*   46 */ "IF",
  /*   47 */ "NOT",
  /*   48 */ "EXISTS",
  /*   49 */ "BLOCKS",
  /*   50 */ "CACHE",
  /*   51 */ "CACHELAST",
  /*   52 */ "COMP",
  /*   53 */ "DAYS",
  /*   54 */ "FSYNC",
  /*   55 */ "MAXROWS",
  /*   56 */ "MINROWS",
  /*   57 */ "KEEP",
  /*   58 */ "PRECISION",
  /*   59 */ "QUORUM",
  /*   60 */ "REPLICA",
  /*   61 */ "TTL",
  /*   62 */ "WAL",
  /*   63 */ "VGROUPS",
  /*   64 */ "SINGLE_STABLE",
  /*   65 */ "STREAM_MODE",
  /*   66 */ "RETENTIONS",
  /*   67 */ "TABLE",
  /*   68 */ "NK_LP",
  /*   69 */ "NK_RP",
  /*   70 */ "STABLE",
  /*   71 */ "ADD",
  /*   72 */ "COLUMN",
  /*   73 */ "MODIFY",
  /*   74 */ "RENAME",
  /*   75 */ "TAG",
  /*   76 */ "SET",
  /*   77 */ "NK_EQ",
  /*   78 */ "USING",
  /*   79 */ "TAGS",
  /*   80 */ "NK_DOT",
  /*   81 */ "NK_COMMA",
  /*   82 */ "COMMENT",
  /*   83 */ "BOOL",
  /*   84 */ "TINYINT",
  /*   85 */ "SMALLINT",
  /*   86 */ "INT",
  /*   87 */ "INTEGER",
  /*   88 */ "BIGINT",
  /*   89 */ "FLOAT",
  /*   90 */ "DOUBLE",
  /*   91 */ "BINARY",
  /*   92 */ "TIMESTAMP",
  /*   93 */ "NCHAR",
  /*   94 */ "UNSIGNED",
  /*   95 */ "JSON",
  /*   96 */ "VARCHAR",
  /*   97 */ "MEDIUMBLOB",
  /*   98 */ "BLOB",
  /*   99 */ "VARBINARY",
  /*  100 */ "DECIMAL",
  /*  101 */ "SMA",
  /*  102 */ "ROLLUP",
  /*  103 */ "FILE_FACTOR",
  /*  104 */ "NK_FLOAT",
  /*  105 */ "DELAY",
  /*  106 */ "SHOW",
  /*  107 */ "DATABASES",
  /*  108 */ "TABLES",
  /*  109 */ "STABLES",
  /*  110 */ "MNODES",
  /*  111 */ "MODULES",
  /*  112 */ "QNODES",
  /*  113 */ "FUNCTIONS",
  /*  114 */ "INDEXES",
  /*  115 */ "FROM",
  /*  116 */ "LIKE",
  /*  117 */ "INDEX",
  /*  118 */ "FULLTEXT",
  /*  119 */ "FUNCTION",
  /*  120 */ "INTERVAL",
  /*  121 */ "TOPIC",
  /*  122 */ "AS",
  /*  123 */ "NK_BOOL",
  /*  124 */ "NK_VARIABLE",
  /*  125 */ "BETWEEN",
  /*  126 */ "IS",
  /*  127 */ "NULL",
  /*  128 */ "NK_LT",
  /*  129 */ "NK_GT",
  /*  130 */ "NK_LE",
  /*  131 */ "NK_GE",
  /*  132 */ "NK_NE",
  /*  133 */ "MATCH",
  /*  134 */ "NMATCH",
  /*  135 */ "IN",
  /*  136 */ "JOIN",
  /*  137 */ "INNER",
  /*  138 */ "SELECT",
  /*  139 */ "DISTINCT",
  /*  140 */ "WHERE",
  /*  141 */ "PARTITION",
  /*  142 */ "BY",
  /*  143 */ "SESSION",
  /*  144 */ "STATE_WINDOW",
  /*  145 */ "SLIDING",
  /*  146 */ "FILL",
  /*  147 */ "VALUE",
  /*  148 */ "NONE",
  /*  149 */ "PREV",
  /*  150 */ "LINEAR",
  /*  151 */ "NEXT",
  /*  152 */ "GROUP",
  /*  153 */ "HAVING",
  /*  154 */ "ORDER",
  /*  155 */ "SLIMIT",
  /*  156 */ "SOFFSET",
  /*  157 */ "LIMIT",
  /*  158 */ "OFFSET",
  /*  159 */ "ASC",
  /*  160 */ "DESC",
  /*  161 */ "NULLS",
  /*  162 */ "FIRST",
  /*  163 */ "LAST",
  /*  164 */ "cmd",
  /*  165 */ "account_options",
  /*  166 */ "alter_account_options",
  /*  167 */ "literal",
  /*  168 */ "alter_account_option",
  /*  169 */ "user_name",
  /*  170 */ "dnode_endpoint",
  /*  171 */ "dnode_host_name",
  /*  172 */ "not_exists_opt",
  /*  173 */ "db_name",
  /*  174 */ "db_options",
  /*  175 */ "exists_opt",
  /*  176 */ "alter_db_options",
  /*  177 */ "alter_db_option",
  /*  178 */ "full_table_name",
  /*  179 */ "column_def_list",
  /*  180 */ "tags_def_opt",
  /*  181 */ "table_options",
  /*  182 */ "multi_create_clause",
  /*  183 */ "tags_def",
  /*  184 */ "multi_drop_clause",
  /*  185 */ "alter_table_clause",
  /*  186 */ "alter_table_options",
  /*  187 */ "column_name",
  /*  188 */ "type_name",
  /*  189 */ "create_subtable_clause",
  /*  190 */ "specific_tags_opt",
  /*  191 */ "literal_list",
  /*  192 */ "drop_table_clause",
  /*  193 */ "col_name_list",
  /*  194 */ "table_name",
  /*  195 */ "column_def",
  /*  196 */ "func_name_list",
  /*  197 */ "alter_table_option",
  /*  198 */ "col_name",
  /*  199 */ "db_name_cond_opt",
  /*  200 */ "like_pattern_opt",
  /*  201 */ "table_name_cond",
  /*  202 */ "from_db_opt",
  /*  203 */ "func_name",
  /*  204 */ "function_name",
  /*  205 */ "index_name",
  /*  206 */ "index_options",
  /*  207 */ "func_list",
  /*  208 */ "duration_literal",
  /*  209 */ "sliding_opt",
  /*  210 */ "func",
  /*  211 */ "expression_list",
  /*  212 */ "topic_name",
  /*  213 */ "query_expression",
  /*  214 */ "signed",
  /*  215 */ "signed_literal",
  /*  216 */ "table_alias",
  /*  217 */ "column_alias",
  /*  218 */ "expression",
  /*  219 */ "column_reference",
  /*  220 */ "subquery",
  /*  221 */ "predicate",
  /*  222 */ "compare_op",
  /*  223 */ "in_op",
  /*  224 */ "in_predicate_value",
  /*  225 */ "boolean_value_expression",
  /*  226 */ "boolean_primary",
  /*  227 */ "common_expression",
  /*  228 */ "from_clause",
  /*  229 */ "table_reference_list",
  /*  230 */ "table_reference",
  /*  231 */ "table_primary",
  /*  232 */ "joined_table",
  /*  233 */ "alias_opt",
  /*  234 */ "parenthesized_joined_table",
  /*  235 */ "join_type",
  /*  236 */ "search_condition",
  /*  237 */ "query_specification",
  /*  238 */ "set_quantifier_opt",
  /*  239 */ "select_list",
  /*  240 */ "where_clause_opt",
  /*  241 */ "partition_by_clause_opt",
  /*  242 */ "twindow_clause_opt",
  /*  243 */ "group_by_clause_opt",
  /*  244 */ "having_clause_opt",
  /*  245 */ "select_sublist",
  /*  246 */ "select_item",
  /*  247 */ "fill_opt",
  /*  248 */ "fill_mode",
  /*  249 */ "group_by_list",
  /*  250 */ "query_expression_body",
  /*  251 */ "order_by_clause_opt",
  /*  252 */ "slimit_clause_opt",
  /*  253 */ "limit_clause_opt",
  /*  254 */ "query_primary",
  /*  255 */ "sort_specification_list",
  /*  256 */ "sort_specification",
  /*  257 */ "ordering_specification_opt",
  /*  258 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  44 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  45 */ "cmd ::= USE db_name",
 /*  46 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  47 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  48 */ "not_exists_opt ::=",
 /*  49 */ "exists_opt ::= IF EXISTS",
 /*  50 */ "exists_opt ::=",
 /*  51 */ "db_options ::=",
 /*  52 */ "db_options ::= db_options BLOCKS NK_INTEGER",
 /*  53 */ "db_options ::= db_options CACHE NK_INTEGER",
 /*  54 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  55 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  56 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  57 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  58 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  59 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  60 */ "db_options ::= db_options KEEP NK_INTEGER",
 /*  61 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  62 */ "db_options ::= db_options QUORUM NK_INTEGER",
 /*  63 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  64 */ "db_options ::= db_options TTL NK_INTEGER",
 /*  65 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  66 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  67 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  68 */ "db_options ::= db_options STREAM_MODE NK_INTEGER",
 /*  69 */ "db_options ::= db_options RETENTIONS NK_STRING",
 /*  70 */ "alter_db_options ::= alter_db_option",
 /*  71 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  72 */ "alter_db_option ::= BLOCKS NK_INTEGER",
 /*  73 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  74 */ "alter_db_option ::= KEEP NK_INTEGER",
 /*  75 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  76 */ "alter_db_option ::= QUORUM NK_INTEGER",
 /*  77 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  78 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  79 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  80 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /*  81 */ "cmd ::= DROP TABLE multi_drop_clause",
 /*  82 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /*  83 */ "cmd ::= ALTER TABLE alter_table_clause",
 /*  84 */ "cmd ::= ALTER STABLE alter_table_clause",
 /*  85 */ "alter_table_clause ::= full_table_name alter_table_options",
 /*  86 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /*  87 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /*  88 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /*  89 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /*  90 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /*  91 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /*  92 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /*  93 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /*  94 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /*  95 */ "multi_create_clause ::= create_subtable_clause",
 /*  96 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /*  97 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP",
 /*  98 */ "multi_drop_clause ::= drop_table_clause",
 /*  99 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 100 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 101 */ "specific_tags_opt ::=",
 /* 102 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 103 */ "full_table_name ::= table_name",
 /* 104 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 105 */ "column_def_list ::= column_def",
 /* 106 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 107 */ "column_def ::= column_name type_name",
 /* 108 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 109 */ "type_name ::= BOOL",
 /* 110 */ "type_name ::= TINYINT",
 /* 111 */ "type_name ::= SMALLINT",
 /* 112 */ "type_name ::= INT",
 /* 113 */ "type_name ::= INTEGER",
 /* 114 */ "type_name ::= BIGINT",
 /* 115 */ "type_name ::= FLOAT",
 /* 116 */ "type_name ::= DOUBLE",
 /* 117 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 118 */ "type_name ::= TIMESTAMP",
 /* 119 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 120 */ "type_name ::= TINYINT UNSIGNED",
 /* 121 */ "type_name ::= SMALLINT UNSIGNED",
 /* 122 */ "type_name ::= INT UNSIGNED",
 /* 123 */ "type_name ::= BIGINT UNSIGNED",
 /* 124 */ "type_name ::= JSON",
 /* 125 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 126 */ "type_name ::= MEDIUMBLOB",
 /* 127 */ "type_name ::= BLOB",
 /* 128 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 129 */ "type_name ::= DECIMAL",
 /* 130 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 131 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 132 */ "tags_def_opt ::=",
 /* 133 */ "tags_def_opt ::= tags_def",
 /* 134 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 135 */ "table_options ::=",
 /* 136 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 137 */ "table_options ::= table_options KEEP NK_INTEGER",
 /* 138 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 139 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 140 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 141 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 142 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 143 */ "alter_table_options ::= alter_table_option",
 /* 144 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 145 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 146 */ "alter_table_option ::= KEEP NK_INTEGER",
 /* 147 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 148 */ "col_name_list ::= col_name",
 /* 149 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 150 */ "col_name ::= column_name",
 /* 151 */ "cmd ::= SHOW DNODES",
 /* 152 */ "cmd ::= SHOW USERS",
 /* 153 */ "cmd ::= SHOW DATABASES",
 /* 154 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 155 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 156 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 157 */ "cmd ::= SHOW MNODES",
 /* 158 */ "cmd ::= SHOW MODULES",
 /* 159 */ "cmd ::= SHOW QNODES",
 /* 160 */ "cmd ::= SHOW FUNCTIONS",
 /* 161 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 162 */ "cmd ::= SHOW STREAMS",
 /* 163 */ "db_name_cond_opt ::=",
 /* 164 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 165 */ "like_pattern_opt ::=",
 /* 166 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 167 */ "table_name_cond ::= table_name",
 /* 168 */ "from_db_opt ::=",
 /* 169 */ "from_db_opt ::= FROM db_name",
 /* 170 */ "func_name_list ::= func_name",
 /* 171 */ "func_name_list ::= func_name_list NK_COMMA col_name",
 /* 172 */ "func_name ::= function_name",
 /* 173 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 174 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 175 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 176 */ "index_options ::=",
 /* 177 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 178 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 179 */ "func_list ::= func",
 /* 180 */ "func_list ::= func_list NK_COMMA func",
 /* 181 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 182 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 183 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name",
 /* 184 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 185 */ "cmd ::= query_expression",
 /* 186 */ "literal ::= NK_INTEGER",
 /* 187 */ "literal ::= NK_FLOAT",
 /* 188 */ "literal ::= NK_STRING",
 /* 189 */ "literal ::= NK_BOOL",
 /* 190 */ "literal ::= TIMESTAMP NK_STRING",
 /* 191 */ "literal ::= duration_literal",
 /* 192 */ "duration_literal ::= NK_VARIABLE",
 /* 193 */ "signed ::= NK_INTEGER",
 /* 194 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 195 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 196 */ "signed ::= NK_FLOAT",
 /* 197 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 198 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 199 */ "signed_literal ::= signed",
 /* 200 */ "signed_literal ::= NK_STRING",
 /* 201 */ "signed_literal ::= NK_BOOL",
 /* 202 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 203 */ "signed_literal ::= duration_literal",
 /* 204 */ "literal_list ::= signed_literal",
 /* 205 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 206 */ "db_name ::= NK_ID",
 /* 207 */ "table_name ::= NK_ID",
 /* 208 */ "column_name ::= NK_ID",
 /* 209 */ "function_name ::= NK_ID",
 /* 210 */ "table_alias ::= NK_ID",
 /* 211 */ "column_alias ::= NK_ID",
 /* 212 */ "user_name ::= NK_ID",
 /* 213 */ "index_name ::= NK_ID",
 /* 214 */ "topic_name ::= NK_ID",
 /* 215 */ "expression ::= literal",
 /* 216 */ "expression ::= column_reference",
 /* 217 */ "expression ::= function_name NK_LP expression_list NK_RP",
 /* 218 */ "expression ::= function_name NK_LP NK_STAR NK_RP",
 /* 219 */ "expression ::= subquery",
 /* 220 */ "expression ::= NK_LP expression NK_RP",
 /* 221 */ "expression ::= NK_PLUS expression",
 /* 222 */ "expression ::= NK_MINUS expression",
 /* 223 */ "expression ::= expression NK_PLUS expression",
 /* 224 */ "expression ::= expression NK_MINUS expression",
 /* 225 */ "expression ::= expression NK_STAR expression",
 /* 226 */ "expression ::= expression NK_SLASH expression",
 /* 227 */ "expression ::= expression NK_REM expression",
 /* 228 */ "expression_list ::= expression",
 /* 229 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 230 */ "column_reference ::= column_name",
 /* 231 */ "column_reference ::= table_name NK_DOT column_name",
 /* 232 */ "predicate ::= expression compare_op expression",
 /* 233 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 234 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 235 */ "predicate ::= expression IS NULL",
 /* 236 */ "predicate ::= expression IS NOT NULL",
 /* 237 */ "predicate ::= expression in_op in_predicate_value",
 /* 238 */ "compare_op ::= NK_LT",
 /* 239 */ "compare_op ::= NK_GT",
 /* 240 */ "compare_op ::= NK_LE",
 /* 241 */ "compare_op ::= NK_GE",
 /* 242 */ "compare_op ::= NK_NE",
 /* 243 */ "compare_op ::= NK_EQ",
 /* 244 */ "compare_op ::= LIKE",
 /* 245 */ "compare_op ::= NOT LIKE",
 /* 246 */ "compare_op ::= MATCH",
 /* 247 */ "compare_op ::= NMATCH",
 /* 248 */ "in_op ::= IN",
 /* 249 */ "in_op ::= NOT IN",
 /* 250 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 251 */ "boolean_value_expression ::= boolean_primary",
 /* 252 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 253 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 254 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 255 */ "boolean_primary ::= predicate",
 /* 256 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 257 */ "common_expression ::= expression",
 /* 258 */ "common_expression ::= boolean_value_expression",
 /* 259 */ "from_clause ::= FROM table_reference_list",
 /* 260 */ "table_reference_list ::= table_reference",
 /* 261 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 262 */ "table_reference ::= table_primary",
 /* 263 */ "table_reference ::= joined_table",
 /* 264 */ "table_primary ::= table_name alias_opt",
 /* 265 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 266 */ "table_primary ::= subquery alias_opt",
 /* 267 */ "table_primary ::= parenthesized_joined_table",
 /* 268 */ "alias_opt ::=",
 /* 269 */ "alias_opt ::= table_alias",
 /* 270 */ "alias_opt ::= AS table_alias",
 /* 271 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 272 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 273 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 274 */ "join_type ::=",
 /* 275 */ "join_type ::= INNER",
 /* 276 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 277 */ "set_quantifier_opt ::=",
 /* 278 */ "set_quantifier_opt ::= DISTINCT",
 /* 279 */ "set_quantifier_opt ::= ALL",
 /* 280 */ "select_list ::= NK_STAR",
 /* 281 */ "select_list ::= select_sublist",
 /* 282 */ "select_sublist ::= select_item",
 /* 283 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 284 */ "select_item ::= common_expression",
 /* 285 */ "select_item ::= common_expression column_alias",
 /* 286 */ "select_item ::= common_expression AS column_alias",
 /* 287 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 288 */ "where_clause_opt ::=",
 /* 289 */ "where_clause_opt ::= WHERE search_condition",
 /* 290 */ "partition_by_clause_opt ::=",
 /* 291 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 292 */ "twindow_clause_opt ::=",
 /* 293 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 294 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP",
 /* 295 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 296 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 297 */ "sliding_opt ::=",
 /* 298 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 299 */ "fill_opt ::=",
 /* 300 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 301 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 302 */ "fill_mode ::= NONE",
 /* 303 */ "fill_mode ::= PREV",
 /* 304 */ "fill_mode ::= NULL",
 /* 305 */ "fill_mode ::= LINEAR",
 /* 306 */ "fill_mode ::= NEXT",
 /* 307 */ "group_by_clause_opt ::=",
 /* 308 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 309 */ "group_by_list ::= expression",
 /* 310 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 311 */ "having_clause_opt ::=",
 /* 312 */ "having_clause_opt ::= HAVING search_condition",
 /* 313 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 314 */ "query_expression_body ::= query_primary",
 /* 315 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 316 */ "query_primary ::= query_specification",
 /* 317 */ "order_by_clause_opt ::=",
 /* 318 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 319 */ "slimit_clause_opt ::=",
 /* 320 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 321 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 322 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 323 */ "limit_clause_opt ::=",
 /* 324 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 325 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 326 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 327 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 328 */ "search_condition ::= common_expression",
 /* 329 */ "sort_specification_list ::= sort_specification",
 /* 330 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 331 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 332 */ "ordering_specification_opt ::=",
 /* 333 */ "ordering_specification_opt ::= ASC",
 /* 334 */ "ordering_specification_opt ::= DESC",
 /* 335 */ "null_ordering_opt ::=",
 /* 336 */ "null_ordering_opt ::= NULLS FIRST",
 /* 337 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 164: /* cmd */
    case 167: /* literal */
    case 174: /* db_options */
    case 176: /* alter_db_options */
    case 178: /* full_table_name */
    case 181: /* table_options */
    case 185: /* alter_table_clause */
    case 186: /* alter_table_options */
    case 189: /* create_subtable_clause */
    case 192: /* drop_table_clause */
    case 195: /* column_def */
    case 198: /* col_name */
    case 199: /* db_name_cond_opt */
    case 200: /* like_pattern_opt */
    case 201: /* table_name_cond */
    case 202: /* from_db_opt */
    case 203: /* func_name */
    case 206: /* index_options */
    case 208: /* duration_literal */
    case 209: /* sliding_opt */
    case 210: /* func */
    case 213: /* query_expression */
    case 214: /* signed */
    case 215: /* signed_literal */
    case 218: /* expression */
    case 219: /* column_reference */
    case 220: /* subquery */
    case 221: /* predicate */
    case 224: /* in_predicate_value */
    case 225: /* boolean_value_expression */
    case 226: /* boolean_primary */
    case 227: /* common_expression */
    case 228: /* from_clause */
    case 229: /* table_reference_list */
    case 230: /* table_reference */
    case 231: /* table_primary */
    case 232: /* joined_table */
    case 234: /* parenthesized_joined_table */
    case 236: /* search_condition */
    case 237: /* query_specification */
    case 240: /* where_clause_opt */
    case 242: /* twindow_clause_opt */
    case 244: /* having_clause_opt */
    case 246: /* select_item */
    case 247: /* fill_opt */
    case 250: /* query_expression_body */
    case 252: /* slimit_clause_opt */
    case 253: /* limit_clause_opt */
    case 254: /* query_primary */
    case 256: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy378)); 
}
      break;
    case 165: /* account_options */
    case 166: /* alter_account_options */
    case 168: /* alter_account_option */
{
 
}
      break;
    case 169: /* user_name */
    case 170: /* dnode_endpoint */
    case 171: /* dnode_host_name */
    case 173: /* db_name */
    case 187: /* column_name */
    case 194: /* table_name */
    case 204: /* function_name */
    case 205: /* index_name */
    case 212: /* topic_name */
    case 216: /* table_alias */
    case 217: /* column_alias */
    case 233: /* alias_opt */
{
 
}
      break;
    case 172: /* not_exists_opt */
    case 175: /* exists_opt */
    case 238: /* set_quantifier_opt */
{
 
}
      break;
    case 177: /* alter_db_option */
    case 197: /* alter_table_option */
{
 
}
      break;
    case 179: /* column_def_list */
    case 180: /* tags_def_opt */
    case 182: /* multi_create_clause */
    case 183: /* tags_def */
    case 184: /* multi_drop_clause */
    case 190: /* specific_tags_opt */
    case 191: /* literal_list */
    case 193: /* col_name_list */
    case 196: /* func_name_list */
    case 207: /* func_list */
    case 211: /* expression_list */
    case 239: /* select_list */
    case 241: /* partition_by_clause_opt */
    case 243: /* group_by_clause_opt */
    case 245: /* select_sublist */
    case 249: /* group_by_list */
    case 251: /* order_by_clause_opt */
    case 255: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy404)); 
}
      break;
    case 188: /* type_name */
{
 
}
      break;
    case 222: /* compare_op */
    case 223: /* in_op */
{
 
}
      break;
    case 235: /* join_type */
{
 
}
      break;
    case 248: /* fill_mode */
{
 
}
      break;
    case 257: /* ordering_specification_opt */
{
 
}
      break;
    case 258: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  164,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  164,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  165,    0 }, /* (2) account_options ::= */
  {  165,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  165,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  165,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  165,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  165,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  165,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  165,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  165,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  165,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  166,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  166,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  168,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  168,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  168,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  168,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  168,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  168,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  168,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  168,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  168,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  168,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  164,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  164,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  164,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  164,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  164,   -3 }, /* (28) cmd ::= CREATE DNODE dnode_endpoint */
  {  164,   -5 }, /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  164,   -3 }, /* (30) cmd ::= DROP DNODE NK_INTEGER */
  {  164,   -3 }, /* (31) cmd ::= DROP DNODE dnode_endpoint */
  {  164,   -4 }, /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  164,   -5 }, /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  164,   -4 }, /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
  {  164,   -5 }, /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  170,   -1 }, /* (36) dnode_endpoint ::= NK_STRING */
  {  171,   -1 }, /* (37) dnode_host_name ::= NK_ID */
  {  171,   -1 }, /* (38) dnode_host_name ::= NK_IPTOKEN */
  {  164,   -3 }, /* (39) cmd ::= ALTER LOCAL NK_STRING */
  {  164,   -4 }, /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  164,   -5 }, /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  164,   -5 }, /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  164,   -5 }, /* (43) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  164,   -4 }, /* (44) cmd ::= DROP DATABASE exists_opt db_name */
  {  164,   -2 }, /* (45) cmd ::= USE db_name */
  {  164,   -4 }, /* (46) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  172,   -3 }, /* (47) not_exists_opt ::= IF NOT EXISTS */
  {  172,    0 }, /* (48) not_exists_opt ::= */
  {  175,   -2 }, /* (49) exists_opt ::= IF EXISTS */
  {  175,    0 }, /* (50) exists_opt ::= */
  {  174,    0 }, /* (51) db_options ::= */
  {  174,   -3 }, /* (52) db_options ::= db_options BLOCKS NK_INTEGER */
  {  174,   -3 }, /* (53) db_options ::= db_options CACHE NK_INTEGER */
  {  174,   -3 }, /* (54) db_options ::= db_options CACHELAST NK_INTEGER */
  {  174,   -3 }, /* (55) db_options ::= db_options COMP NK_INTEGER */
  {  174,   -3 }, /* (56) db_options ::= db_options DAYS NK_INTEGER */
  {  174,   -3 }, /* (57) db_options ::= db_options FSYNC NK_INTEGER */
  {  174,   -3 }, /* (58) db_options ::= db_options MAXROWS NK_INTEGER */
  {  174,   -3 }, /* (59) db_options ::= db_options MINROWS NK_INTEGER */
  {  174,   -3 }, /* (60) db_options ::= db_options KEEP NK_INTEGER */
  {  174,   -3 }, /* (61) db_options ::= db_options PRECISION NK_STRING */
  {  174,   -3 }, /* (62) db_options ::= db_options QUORUM NK_INTEGER */
  {  174,   -3 }, /* (63) db_options ::= db_options REPLICA NK_INTEGER */
  {  174,   -3 }, /* (64) db_options ::= db_options TTL NK_INTEGER */
  {  174,   -3 }, /* (65) db_options ::= db_options WAL NK_INTEGER */
  {  174,   -3 }, /* (66) db_options ::= db_options VGROUPS NK_INTEGER */
  {  174,   -3 }, /* (67) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  174,   -3 }, /* (68) db_options ::= db_options STREAM_MODE NK_INTEGER */
  {  174,   -3 }, /* (69) db_options ::= db_options RETENTIONS NK_STRING */
  {  176,   -1 }, /* (70) alter_db_options ::= alter_db_option */
  {  176,   -2 }, /* (71) alter_db_options ::= alter_db_options alter_db_option */
  {  177,   -2 }, /* (72) alter_db_option ::= BLOCKS NK_INTEGER */
  {  177,   -2 }, /* (73) alter_db_option ::= FSYNC NK_INTEGER */
  {  177,   -2 }, /* (74) alter_db_option ::= KEEP NK_INTEGER */
  {  177,   -2 }, /* (75) alter_db_option ::= WAL NK_INTEGER */
  {  177,   -2 }, /* (76) alter_db_option ::= QUORUM NK_INTEGER */
  {  177,   -2 }, /* (77) alter_db_option ::= CACHELAST NK_INTEGER */
  {  164,   -9 }, /* (78) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  164,   -3 }, /* (79) cmd ::= CREATE TABLE multi_create_clause */
  {  164,   -9 }, /* (80) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  164,   -3 }, /* (81) cmd ::= DROP TABLE multi_drop_clause */
  {  164,   -4 }, /* (82) cmd ::= DROP STABLE exists_opt full_table_name */
  {  164,   -3 }, /* (83) cmd ::= ALTER TABLE alter_table_clause */
  {  164,   -3 }, /* (84) cmd ::= ALTER STABLE alter_table_clause */
  {  185,   -2 }, /* (85) alter_table_clause ::= full_table_name alter_table_options */
  {  185,   -5 }, /* (86) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  185,   -4 }, /* (87) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  185,   -5 }, /* (88) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  185,   -5 }, /* (89) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  185,   -5 }, /* (90) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  185,   -4 }, /* (91) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  185,   -5 }, /* (92) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  185,   -5 }, /* (93) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  185,   -6 }, /* (94) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
  {  182,   -1 }, /* (95) multi_create_clause ::= create_subtable_clause */
  {  182,   -2 }, /* (96) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  189,   -9 }, /* (97) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
  {  184,   -1 }, /* (98) multi_drop_clause ::= drop_table_clause */
  {  184,   -2 }, /* (99) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  192,   -2 }, /* (100) drop_table_clause ::= exists_opt full_table_name */
  {  190,    0 }, /* (101) specific_tags_opt ::= */
  {  190,   -3 }, /* (102) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  178,   -1 }, /* (103) full_table_name ::= table_name */
  {  178,   -3 }, /* (104) full_table_name ::= db_name NK_DOT table_name */
  {  179,   -1 }, /* (105) column_def_list ::= column_def */
  {  179,   -3 }, /* (106) column_def_list ::= column_def_list NK_COMMA column_def */
  {  195,   -2 }, /* (107) column_def ::= column_name type_name */
  {  195,   -4 }, /* (108) column_def ::= column_name type_name COMMENT NK_STRING */
  {  188,   -1 }, /* (109) type_name ::= BOOL */
  {  188,   -1 }, /* (110) type_name ::= TINYINT */
  {  188,   -1 }, /* (111) type_name ::= SMALLINT */
  {  188,   -1 }, /* (112) type_name ::= INT */
  {  188,   -1 }, /* (113) type_name ::= INTEGER */
  {  188,   -1 }, /* (114) type_name ::= BIGINT */
  {  188,   -1 }, /* (115) type_name ::= FLOAT */
  {  188,   -1 }, /* (116) type_name ::= DOUBLE */
  {  188,   -4 }, /* (117) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  188,   -1 }, /* (118) type_name ::= TIMESTAMP */
  {  188,   -4 }, /* (119) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  188,   -2 }, /* (120) type_name ::= TINYINT UNSIGNED */
  {  188,   -2 }, /* (121) type_name ::= SMALLINT UNSIGNED */
  {  188,   -2 }, /* (122) type_name ::= INT UNSIGNED */
  {  188,   -2 }, /* (123) type_name ::= BIGINT UNSIGNED */
  {  188,   -1 }, /* (124) type_name ::= JSON */
  {  188,   -4 }, /* (125) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  188,   -1 }, /* (126) type_name ::= MEDIUMBLOB */
  {  188,   -1 }, /* (127) type_name ::= BLOB */
  {  188,   -4 }, /* (128) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  188,   -1 }, /* (129) type_name ::= DECIMAL */
  {  188,   -4 }, /* (130) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  188,   -6 }, /* (131) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  180,    0 }, /* (132) tags_def_opt ::= */
  {  180,   -1 }, /* (133) tags_def_opt ::= tags_def */
  {  183,   -4 }, /* (134) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  181,    0 }, /* (135) table_options ::= */
  {  181,   -3 }, /* (136) table_options ::= table_options COMMENT NK_STRING */
  {  181,   -3 }, /* (137) table_options ::= table_options KEEP NK_INTEGER */
  {  181,   -3 }, /* (138) table_options ::= table_options TTL NK_INTEGER */
  {  181,   -5 }, /* (139) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  181,   -5 }, /* (140) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  181,   -3 }, /* (141) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  181,   -3 }, /* (142) table_options ::= table_options DELAY NK_INTEGER */
  {  186,   -1 }, /* (143) alter_table_options ::= alter_table_option */
  {  186,   -2 }, /* (144) alter_table_options ::= alter_table_options alter_table_option */
  {  197,   -2 }, /* (145) alter_table_option ::= COMMENT NK_STRING */
  {  197,   -2 }, /* (146) alter_table_option ::= KEEP NK_INTEGER */
  {  197,   -2 }, /* (147) alter_table_option ::= TTL NK_INTEGER */
  {  193,   -1 }, /* (148) col_name_list ::= col_name */
  {  193,   -3 }, /* (149) col_name_list ::= col_name_list NK_COMMA col_name */
  {  198,   -1 }, /* (150) col_name ::= column_name */
  {  164,   -2 }, /* (151) cmd ::= SHOW DNODES */
  {  164,   -2 }, /* (152) cmd ::= SHOW USERS */
  {  164,   -2 }, /* (153) cmd ::= SHOW DATABASES */
  {  164,   -4 }, /* (154) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  164,   -4 }, /* (155) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  164,   -3 }, /* (156) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  164,   -2 }, /* (157) cmd ::= SHOW MNODES */
  {  164,   -2 }, /* (158) cmd ::= SHOW MODULES */
  {  164,   -2 }, /* (159) cmd ::= SHOW QNODES */
  {  164,   -2 }, /* (160) cmd ::= SHOW FUNCTIONS */
  {  164,   -5 }, /* (161) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  164,   -2 }, /* (162) cmd ::= SHOW STREAMS */
  {  199,    0 }, /* (163) db_name_cond_opt ::= */
  {  199,   -2 }, /* (164) db_name_cond_opt ::= db_name NK_DOT */
  {  200,    0 }, /* (165) like_pattern_opt ::= */
  {  200,   -2 }, /* (166) like_pattern_opt ::= LIKE NK_STRING */
  {  201,   -1 }, /* (167) table_name_cond ::= table_name */
  {  202,    0 }, /* (168) from_db_opt ::= */
  {  202,   -2 }, /* (169) from_db_opt ::= FROM db_name */
  {  196,   -1 }, /* (170) func_name_list ::= func_name */
  {  196,   -3 }, /* (171) func_name_list ::= func_name_list NK_COMMA col_name */
  {  203,   -1 }, /* (172) func_name ::= function_name */
  {  164,   -8 }, /* (173) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  164,  -10 }, /* (174) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  164,   -6 }, /* (175) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  206,    0 }, /* (176) index_options ::= */
  {  206,   -9 }, /* (177) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  206,  -11 }, /* (178) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  207,   -1 }, /* (179) func_list ::= func */
  {  207,   -3 }, /* (180) func_list ::= func_list NK_COMMA func */
  {  210,   -4 }, /* (181) func ::= function_name NK_LP expression_list NK_RP */
  {  164,   -6 }, /* (182) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  164,   -6 }, /* (183) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
  {  164,   -4 }, /* (184) cmd ::= DROP TOPIC exists_opt topic_name */
  {  164,   -1 }, /* (185) cmd ::= query_expression */
  {  167,   -1 }, /* (186) literal ::= NK_INTEGER */
  {  167,   -1 }, /* (187) literal ::= NK_FLOAT */
  {  167,   -1 }, /* (188) literal ::= NK_STRING */
  {  167,   -1 }, /* (189) literal ::= NK_BOOL */
  {  167,   -2 }, /* (190) literal ::= TIMESTAMP NK_STRING */
  {  167,   -1 }, /* (191) literal ::= duration_literal */
  {  208,   -1 }, /* (192) duration_literal ::= NK_VARIABLE */
  {  214,   -1 }, /* (193) signed ::= NK_INTEGER */
  {  214,   -2 }, /* (194) signed ::= NK_PLUS NK_INTEGER */
  {  214,   -2 }, /* (195) signed ::= NK_MINUS NK_INTEGER */
  {  214,   -1 }, /* (196) signed ::= NK_FLOAT */
  {  214,   -2 }, /* (197) signed ::= NK_PLUS NK_FLOAT */
  {  214,   -2 }, /* (198) signed ::= NK_MINUS NK_FLOAT */
  {  215,   -1 }, /* (199) signed_literal ::= signed */
  {  215,   -1 }, /* (200) signed_literal ::= NK_STRING */
  {  215,   -1 }, /* (201) signed_literal ::= NK_BOOL */
  {  215,   -2 }, /* (202) signed_literal ::= TIMESTAMP NK_STRING */
  {  215,   -1 }, /* (203) signed_literal ::= duration_literal */
  {  191,   -1 }, /* (204) literal_list ::= signed_literal */
  {  191,   -3 }, /* (205) literal_list ::= literal_list NK_COMMA signed_literal */
  {  173,   -1 }, /* (206) db_name ::= NK_ID */
  {  194,   -1 }, /* (207) table_name ::= NK_ID */
  {  187,   -1 }, /* (208) column_name ::= NK_ID */
  {  204,   -1 }, /* (209) function_name ::= NK_ID */
  {  216,   -1 }, /* (210) table_alias ::= NK_ID */
  {  217,   -1 }, /* (211) column_alias ::= NK_ID */
  {  169,   -1 }, /* (212) user_name ::= NK_ID */
  {  205,   -1 }, /* (213) index_name ::= NK_ID */
  {  212,   -1 }, /* (214) topic_name ::= NK_ID */
  {  218,   -1 }, /* (215) expression ::= literal */
  {  218,   -1 }, /* (216) expression ::= column_reference */
  {  218,   -4 }, /* (217) expression ::= function_name NK_LP expression_list NK_RP */
  {  218,   -4 }, /* (218) expression ::= function_name NK_LP NK_STAR NK_RP */
  {  218,   -1 }, /* (219) expression ::= subquery */
  {  218,   -3 }, /* (220) expression ::= NK_LP expression NK_RP */
  {  218,   -2 }, /* (221) expression ::= NK_PLUS expression */
  {  218,   -2 }, /* (222) expression ::= NK_MINUS expression */
  {  218,   -3 }, /* (223) expression ::= expression NK_PLUS expression */
  {  218,   -3 }, /* (224) expression ::= expression NK_MINUS expression */
  {  218,   -3 }, /* (225) expression ::= expression NK_STAR expression */
  {  218,   -3 }, /* (226) expression ::= expression NK_SLASH expression */
  {  218,   -3 }, /* (227) expression ::= expression NK_REM expression */
  {  211,   -1 }, /* (228) expression_list ::= expression */
  {  211,   -3 }, /* (229) expression_list ::= expression_list NK_COMMA expression */
  {  219,   -1 }, /* (230) column_reference ::= column_name */
  {  219,   -3 }, /* (231) column_reference ::= table_name NK_DOT column_name */
  {  221,   -3 }, /* (232) predicate ::= expression compare_op expression */
  {  221,   -5 }, /* (233) predicate ::= expression BETWEEN expression AND expression */
  {  221,   -6 }, /* (234) predicate ::= expression NOT BETWEEN expression AND expression */
  {  221,   -3 }, /* (235) predicate ::= expression IS NULL */
  {  221,   -4 }, /* (236) predicate ::= expression IS NOT NULL */
  {  221,   -3 }, /* (237) predicate ::= expression in_op in_predicate_value */
  {  222,   -1 }, /* (238) compare_op ::= NK_LT */
  {  222,   -1 }, /* (239) compare_op ::= NK_GT */
  {  222,   -1 }, /* (240) compare_op ::= NK_LE */
  {  222,   -1 }, /* (241) compare_op ::= NK_GE */
  {  222,   -1 }, /* (242) compare_op ::= NK_NE */
  {  222,   -1 }, /* (243) compare_op ::= NK_EQ */
  {  222,   -1 }, /* (244) compare_op ::= LIKE */
  {  222,   -2 }, /* (245) compare_op ::= NOT LIKE */
  {  222,   -1 }, /* (246) compare_op ::= MATCH */
  {  222,   -1 }, /* (247) compare_op ::= NMATCH */
  {  223,   -1 }, /* (248) in_op ::= IN */
  {  223,   -2 }, /* (249) in_op ::= NOT IN */
  {  224,   -3 }, /* (250) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  225,   -1 }, /* (251) boolean_value_expression ::= boolean_primary */
  {  225,   -2 }, /* (252) boolean_value_expression ::= NOT boolean_primary */
  {  225,   -3 }, /* (253) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  225,   -3 }, /* (254) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  226,   -1 }, /* (255) boolean_primary ::= predicate */
  {  226,   -3 }, /* (256) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  227,   -1 }, /* (257) common_expression ::= expression */
  {  227,   -1 }, /* (258) common_expression ::= boolean_value_expression */
  {  228,   -2 }, /* (259) from_clause ::= FROM table_reference_list */
  {  229,   -1 }, /* (260) table_reference_list ::= table_reference */
  {  229,   -3 }, /* (261) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  230,   -1 }, /* (262) table_reference ::= table_primary */
  {  230,   -1 }, /* (263) table_reference ::= joined_table */
  {  231,   -2 }, /* (264) table_primary ::= table_name alias_opt */
  {  231,   -4 }, /* (265) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  231,   -2 }, /* (266) table_primary ::= subquery alias_opt */
  {  231,   -1 }, /* (267) table_primary ::= parenthesized_joined_table */
  {  233,    0 }, /* (268) alias_opt ::= */
  {  233,   -1 }, /* (269) alias_opt ::= table_alias */
  {  233,   -2 }, /* (270) alias_opt ::= AS table_alias */
  {  234,   -3 }, /* (271) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  234,   -3 }, /* (272) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  232,   -6 }, /* (273) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  235,    0 }, /* (274) join_type ::= */
  {  235,   -1 }, /* (275) join_type ::= INNER */
  {  237,   -9 }, /* (276) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  238,    0 }, /* (277) set_quantifier_opt ::= */
  {  238,   -1 }, /* (278) set_quantifier_opt ::= DISTINCT */
  {  238,   -1 }, /* (279) set_quantifier_opt ::= ALL */
  {  239,   -1 }, /* (280) select_list ::= NK_STAR */
  {  239,   -1 }, /* (281) select_list ::= select_sublist */
  {  245,   -1 }, /* (282) select_sublist ::= select_item */
  {  245,   -3 }, /* (283) select_sublist ::= select_sublist NK_COMMA select_item */
  {  246,   -1 }, /* (284) select_item ::= common_expression */
  {  246,   -2 }, /* (285) select_item ::= common_expression column_alias */
  {  246,   -3 }, /* (286) select_item ::= common_expression AS column_alias */
  {  246,   -3 }, /* (287) select_item ::= table_name NK_DOT NK_STAR */
  {  240,    0 }, /* (288) where_clause_opt ::= */
  {  240,   -2 }, /* (289) where_clause_opt ::= WHERE search_condition */
  {  241,    0 }, /* (290) partition_by_clause_opt ::= */
  {  241,   -3 }, /* (291) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  242,    0 }, /* (292) twindow_clause_opt ::= */
  {  242,   -6 }, /* (293) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  242,   -4 }, /* (294) twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP */
  {  242,   -6 }, /* (295) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  242,   -8 }, /* (296) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  209,    0 }, /* (297) sliding_opt ::= */
  {  209,   -4 }, /* (298) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  247,    0 }, /* (299) fill_opt ::= */
  {  247,   -4 }, /* (300) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  247,   -6 }, /* (301) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  248,   -1 }, /* (302) fill_mode ::= NONE */
  {  248,   -1 }, /* (303) fill_mode ::= PREV */
  {  248,   -1 }, /* (304) fill_mode ::= NULL */
  {  248,   -1 }, /* (305) fill_mode ::= LINEAR */
  {  248,   -1 }, /* (306) fill_mode ::= NEXT */
  {  243,    0 }, /* (307) group_by_clause_opt ::= */
  {  243,   -3 }, /* (308) group_by_clause_opt ::= GROUP BY group_by_list */
  {  249,   -1 }, /* (309) group_by_list ::= expression */
  {  249,   -3 }, /* (310) group_by_list ::= group_by_list NK_COMMA expression */
  {  244,    0 }, /* (311) having_clause_opt ::= */
  {  244,   -2 }, /* (312) having_clause_opt ::= HAVING search_condition */
  {  213,   -4 }, /* (313) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  250,   -1 }, /* (314) query_expression_body ::= query_primary */
  {  250,   -4 }, /* (315) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  254,   -1 }, /* (316) query_primary ::= query_specification */
  {  251,    0 }, /* (317) order_by_clause_opt ::= */
  {  251,   -3 }, /* (318) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  252,    0 }, /* (319) slimit_clause_opt ::= */
  {  252,   -2 }, /* (320) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  252,   -4 }, /* (321) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  252,   -4 }, /* (322) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  253,    0 }, /* (323) limit_clause_opt ::= */
  {  253,   -2 }, /* (324) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  253,   -4 }, /* (325) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  253,   -4 }, /* (326) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  220,   -3 }, /* (327) subquery ::= NK_LP query_expression NK_RP */
  {  236,   -1 }, /* (328) search_condition ::= common_expression */
  {  255,   -1 }, /* (329) sort_specification_list ::= sort_specification */
  {  255,   -3 }, /* (330) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  256,   -3 }, /* (331) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  257,    0 }, /* (332) ordering_specification_opt ::= */
  {  257,   -1 }, /* (333) ordering_specification_opt ::= ASC */
  {  257,   -1 }, /* (334) ordering_specification_opt ::= DESC */
  {  258,    0 }, /* (335) null_ordering_opt ::= */
  {  258,   -2 }, /* (336) null_ordering_opt ::= NULLS FIRST */
  {  258,   -2 }, /* (337) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,165,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,166,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,165,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,167,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,168,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,166,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,168,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,167,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy183, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy183, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy183, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy183); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy183, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy183, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy183); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 206: /* db_name ::= NK_ID */ yytestcase(yyruleno==206);
      case 207: /* table_name ::= NK_ID */ yytestcase(yyruleno==207);
      case 208: /* column_name ::= NK_ID */ yytestcase(yyruleno==208);
      case 209: /* function_name ::= NK_ID */ yytestcase(yyruleno==209);
      case 210: /* table_alias ::= NK_ID */ yytestcase(yyruleno==210);
      case 211: /* column_alias ::= NK_ID */ yytestcase(yyruleno==211);
      case 212: /* user_name ::= NK_ID */ yytestcase(yyruleno==212);
      case 213: /* index_name ::= NK_ID */ yytestcase(yyruleno==213);
      case 214: /* topic_name ::= NK_ID */ yytestcase(yyruleno==214);
{ yylhsminor.yy183 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy183 = yylhsminor.yy183;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateQnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropQnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy215, &yymsp[-1].minor.yy183, yymsp[0].minor.yy378); }
        break;
      case 44: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy215, &yymsp[0].minor.yy183); }
        break;
      case 45: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy183); }
        break;
      case 46: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy183, yymsp[0].minor.yy378); }
        break;
      case 47: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy215 = true; }
        break;
      case 48: /* not_exists_opt ::= */
      case 50: /* exists_opt ::= */ yytestcase(yyruleno==50);
      case 277: /* set_quantifier_opt ::= */ yytestcase(yyruleno==277);
{ yymsp[1].minor.yy215 = false; }
        break;
      case 49: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy215 = true; }
        break;
      case 51: /* db_options ::= */
{ yymsp[1].minor.yy378 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 52: /* db_options ::= db_options BLOCKS NK_INTEGER */
{ yylhsminor.yy378 = setDatabaseOption(pCxt, yymsp[-2].minor.yy378, DB_OPTION_BLOCKS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 53: /* db_options ::= db_options CACHE NK_INTEGER */
{ yylhsminor.yy378 = setDatabaseOption(pCxt, yymsp[-2].minor.yy378, DB_OPTION_CACHE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 54: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy378 = setDatabaseOption(pCxt, yymsp[-2].minor.yy378, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 55: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy378 = setDatabaseOption(pCxt, yymsp[-2].minor.yy378, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 56: /* db_options ::= db_options DAYS NK_INTEGER */
{ yylhsminor.yy378 = setDatabaseOption(pCxt, yymsp[-2].minor.yy378, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 57: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy378 = setDatabaseOption(pCxt, yymsp[-2].minor.yy378, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 58: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy378 = setDatabaseOption(pCxt, yymsp[-2].minor.yy378, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 59: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy378 = setDatabaseOption(pCxt, yymsp[-2].minor.yy378, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 60: /* db_options ::= db_options KEEP NK_INTEGER */
{ yylhsminor.yy378 = setDatabaseOption(pCxt, yymsp[-2].minor.yy378, DB_OPTION_KEEP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 61: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy378 = setDatabaseOption(pCxt, yymsp[-2].minor.yy378, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 62: /* db_options ::= db_options QUORUM NK_INTEGER */
{ yylhsminor.yy378 = setDatabaseOption(pCxt, yymsp[-2].minor.yy378, DB_OPTION_QUORUM, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 63: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy378 = setDatabaseOption(pCxt, yymsp[-2].minor.yy378, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 64: /* db_options ::= db_options TTL NK_INTEGER */
{ yylhsminor.yy378 = setDatabaseOption(pCxt, yymsp[-2].minor.yy378, DB_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 65: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy378 = setDatabaseOption(pCxt, yymsp[-2].minor.yy378, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 66: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy378 = setDatabaseOption(pCxt, yymsp[-2].minor.yy378, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 67: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy378 = setDatabaseOption(pCxt, yymsp[-2].minor.yy378, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 68: /* db_options ::= db_options STREAM_MODE NK_INTEGER */
{ yylhsminor.yy378 = setDatabaseOption(pCxt, yymsp[-2].minor.yy378, DB_OPTION_STREAM_MODE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 69: /* db_options ::= db_options RETENTIONS NK_STRING */
{ yylhsminor.yy378 = setDatabaseOption(pCxt, yymsp[-2].minor.yy378, DB_OPTION_RETENTIONS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 70: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy378 = createDefaultAlterDatabaseOptions(pCxt); yylhsminor.yy378 = setDatabaseOption(pCxt, yylhsminor.yy378, yymsp[0].minor.yy11.type, &yymsp[0].minor.yy11.val); }
  yymsp[0].minor.yy378 = yylhsminor.yy378;
        break;
      case 71: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy378 = setDatabaseOption(pCxt, yymsp[-1].minor.yy378, yymsp[0].minor.yy11.type, &yymsp[0].minor.yy11.val); }
  yymsp[-1].minor.yy378 = yylhsminor.yy378;
        break;
      case 72: /* alter_db_option ::= BLOCKS NK_INTEGER */
{ yymsp[-1].minor.yy11.type = DB_OPTION_BLOCKS; yymsp[-1].minor.yy11.val = yymsp[0].minor.yy0; }
        break;
      case 73: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy11.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy11.val = yymsp[0].minor.yy0; }
        break;
      case 74: /* alter_db_option ::= KEEP NK_INTEGER */
{ yymsp[-1].minor.yy11.type = DB_OPTION_KEEP; yymsp[-1].minor.yy11.val = yymsp[0].minor.yy0; }
        break;
      case 75: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy11.type = DB_OPTION_WAL; yymsp[-1].minor.yy11.val = yymsp[0].minor.yy0; }
        break;
      case 76: /* alter_db_option ::= QUORUM NK_INTEGER */
{ yymsp[-1].minor.yy11.type = DB_OPTION_QUORUM; yymsp[-1].minor.yy11.val = yymsp[0].minor.yy0; }
        break;
      case 77: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy11.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy11.val = yymsp[0].minor.yy0; }
        break;
      case 78: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 80: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==80);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy215, yymsp[-5].minor.yy378, yymsp[-3].minor.yy404, yymsp[-1].minor.yy404, yymsp[0].minor.yy378); }
        break;
      case 79: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy404); }
        break;
      case 81: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy404); }
        break;
      case 82: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy215, yymsp[0].minor.yy378); }
        break;
      case 83: /* cmd ::= ALTER TABLE alter_table_clause */
      case 84: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==84);
      case 185: /* cmd ::= query_expression */ yytestcase(yyruleno==185);
{ pCxt->pRootNode = yymsp[0].minor.yy378; }
        break;
      case 85: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy378 = createAlterTableOption(pCxt, yymsp[-1].minor.yy378, yymsp[0].minor.yy378); }
  yymsp[-1].minor.yy378 = yylhsminor.yy378;
        break;
      case 86: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy378 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy378, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy183, yymsp[0].minor.yy504); }
  yymsp[-4].minor.yy378 = yylhsminor.yy378;
        break;
      case 87: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy378 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy378, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy183); }
  yymsp[-3].minor.yy378 = yylhsminor.yy378;
        break;
      case 88: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy378 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy378, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy183, yymsp[0].minor.yy504); }
  yymsp[-4].minor.yy378 = yylhsminor.yy378;
        break;
      case 89: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy378 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy378, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy183, &yymsp[0].minor.yy183); }
  yymsp[-4].minor.yy378 = yylhsminor.yy378;
        break;
      case 90: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy378 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy378, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy183, yymsp[0].minor.yy504); }
  yymsp[-4].minor.yy378 = yylhsminor.yy378;
        break;
      case 91: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy378 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy378, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy183); }
  yymsp[-3].minor.yy378 = yylhsminor.yy378;
        break;
      case 92: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy378 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy378, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy183, yymsp[0].minor.yy504); }
  yymsp[-4].minor.yy378 = yylhsminor.yy378;
        break;
      case 93: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy378 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy378, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy183, &yymsp[0].minor.yy183); }
  yymsp[-4].minor.yy378 = yylhsminor.yy378;
        break;
      case 94: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy378 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy378, &yymsp[-2].minor.yy183, yymsp[0].minor.yy378); }
  yymsp[-5].minor.yy378 = yylhsminor.yy378;
        break;
      case 95: /* multi_create_clause ::= create_subtable_clause */
      case 98: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==98);
      case 105: /* column_def_list ::= column_def */ yytestcase(yyruleno==105);
      case 148: /* col_name_list ::= col_name */ yytestcase(yyruleno==148);
      case 170: /* func_name_list ::= func_name */ yytestcase(yyruleno==170);
      case 179: /* func_list ::= func */ yytestcase(yyruleno==179);
      case 204: /* literal_list ::= signed_literal */ yytestcase(yyruleno==204);
      case 282: /* select_sublist ::= select_item */ yytestcase(yyruleno==282);
      case 329: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==329);
{ yylhsminor.yy404 = createNodeList(pCxt, yymsp[0].minor.yy378); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 96: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 99: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==99);
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-1].minor.yy404, yymsp[0].minor.yy378); }
  yymsp[-1].minor.yy404 = yylhsminor.yy404;
        break;
      case 97: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
{ yylhsminor.yy378 = createCreateSubTableClause(pCxt, yymsp[-8].minor.yy215, yymsp[-7].minor.yy378, yymsp[-5].minor.yy378, yymsp[-4].minor.yy404, yymsp[-1].minor.yy404); }
  yymsp[-8].minor.yy378 = yylhsminor.yy378;
        break;
      case 100: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy378 = createDropTableClause(pCxt, yymsp[-1].minor.yy215, yymsp[0].minor.yy378); }
  yymsp[-1].minor.yy378 = yylhsminor.yy378;
        break;
      case 101: /* specific_tags_opt ::= */
      case 132: /* tags_def_opt ::= */ yytestcase(yyruleno==132);
      case 290: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==290);
      case 307: /* group_by_clause_opt ::= */ yytestcase(yyruleno==307);
      case 317: /* order_by_clause_opt ::= */ yytestcase(yyruleno==317);
{ yymsp[1].minor.yy404 = NULL; }
        break;
      case 102: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy404 = yymsp[-1].minor.yy404; }
        break;
      case 103: /* full_table_name ::= table_name */
{ yylhsminor.yy378 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy183, NULL); }
  yymsp[0].minor.yy378 = yylhsminor.yy378;
        break;
      case 104: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy378 = createRealTableNode(pCxt, &yymsp[-2].minor.yy183, &yymsp[0].minor.yy183, NULL); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 106: /* column_def_list ::= column_def_list NK_COMMA column_def */
      case 149: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==149);
      case 171: /* func_name_list ::= func_name_list NK_COMMA col_name */ yytestcase(yyruleno==171);
      case 180: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==180);
      case 205: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==205);
      case 283: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==283);
      case 330: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==330);
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, yymsp[0].minor.yy378); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 107: /* column_def ::= column_name type_name */
{ yylhsminor.yy378 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy183, yymsp[0].minor.yy504, NULL); }
  yymsp[-1].minor.yy378 = yylhsminor.yy378;
        break;
      case 108: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy378 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy183, yymsp[-2].minor.yy504, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy378 = yylhsminor.yy378;
        break;
      case 109: /* type_name ::= BOOL */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 110: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 111: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 112: /* type_name ::= INT */
      case 113: /* type_name ::= INTEGER */ yytestcase(yyruleno==113);
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 114: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 115: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 116: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 117: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy504 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 118: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 119: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy504 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 120: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy504 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 121: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy504 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 122: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy504 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 123: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy504 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 124: /* type_name ::= JSON */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 125: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy504 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 126: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 127: /* type_name ::= BLOB */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 128: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy504 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 129: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 130: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy504 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 131: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy504 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 133: /* tags_def_opt ::= tags_def */
      case 281: /* select_list ::= select_sublist */ yytestcase(yyruleno==281);
{ yylhsminor.yy404 = yymsp[0].minor.yy404; }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 134: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy404 = yymsp[-1].minor.yy404; }
        break;
      case 135: /* table_options ::= */
{ yymsp[1].minor.yy378 = createDefaultTableOptions(pCxt); }
        break;
      case 136: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy378 = setTableOption(pCxt, yymsp[-2].minor.yy378, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 137: /* table_options ::= table_options KEEP NK_INTEGER */
{ yylhsminor.yy378 = setTableOption(pCxt, yymsp[-2].minor.yy378, TABLE_OPTION_KEEP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 138: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy378 = setTableOption(pCxt, yymsp[-2].minor.yy378, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 139: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy378 = setTableSmaOption(pCxt, yymsp[-4].minor.yy378, yymsp[-1].minor.yy404); }
  yymsp[-4].minor.yy378 = yylhsminor.yy378;
        break;
      case 140: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ yylhsminor.yy378 = setTableRollupOption(pCxt, yymsp[-4].minor.yy378, yymsp[-1].minor.yy404); }
  yymsp[-4].minor.yy378 = yylhsminor.yy378;
        break;
      case 141: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ yylhsminor.yy378 = setTableOption(pCxt, yymsp[-2].minor.yy378, TABLE_OPTION_FILE_FACTOR, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 142: /* table_options ::= table_options DELAY NK_INTEGER */
{ yylhsminor.yy378 = setTableOption(pCxt, yymsp[-2].minor.yy378, TABLE_OPTION_DELAY, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 143: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy378 = createDefaultAlterTableOptions(pCxt); yylhsminor.yy378 = setTableOption(pCxt, yylhsminor.yy378, yymsp[0].minor.yy11.type, &yymsp[0].minor.yy11.val); }
  yymsp[0].minor.yy378 = yylhsminor.yy378;
        break;
      case 144: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy378 = setTableOption(pCxt, yymsp[-1].minor.yy378, yymsp[0].minor.yy11.type, &yymsp[0].minor.yy11.val); }
  yymsp[-1].minor.yy378 = yylhsminor.yy378;
        break;
      case 145: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy11.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy11.val = yymsp[0].minor.yy0; }
        break;
      case 146: /* alter_table_option ::= KEEP NK_INTEGER */
{ yymsp[-1].minor.yy11.type = TABLE_OPTION_KEEP; yymsp[-1].minor.yy11.val = yymsp[0].minor.yy0; }
        break;
      case 147: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy11.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy11.val = yymsp[0].minor.yy0; }
        break;
      case 150: /* col_name ::= column_name */
{ yylhsminor.yy378 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy183); }
  yymsp[0].minor.yy378 = yylhsminor.yy378;
        break;
      case 151: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 152: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 153: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 154: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy378, yymsp[0].minor.yy378); }
        break;
      case 155: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy378, yymsp[0].minor.yy378); }
        break;
      case 156: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy378, NULL); }
        break;
      case 157: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 158: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 159: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 160: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 161: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy378, yymsp[0].minor.yy378); }
        break;
      case 162: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 163: /* db_name_cond_opt ::= */
      case 168: /* from_db_opt ::= */ yytestcase(yyruleno==168);
{ yymsp[1].minor.yy378 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 164: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy378 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy183); }
  yymsp[-1].minor.yy378 = yylhsminor.yy378;
        break;
      case 165: /* like_pattern_opt ::= */
      case 176: /* index_options ::= */ yytestcase(yyruleno==176);
      case 288: /* where_clause_opt ::= */ yytestcase(yyruleno==288);
      case 292: /* twindow_clause_opt ::= */ yytestcase(yyruleno==292);
      case 297: /* sliding_opt ::= */ yytestcase(yyruleno==297);
      case 299: /* fill_opt ::= */ yytestcase(yyruleno==299);
      case 311: /* having_clause_opt ::= */ yytestcase(yyruleno==311);
      case 319: /* slimit_clause_opt ::= */ yytestcase(yyruleno==319);
      case 323: /* limit_clause_opt ::= */ yytestcase(yyruleno==323);
{ yymsp[1].minor.yy378 = NULL; }
        break;
      case 166: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy378 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 167: /* table_name_cond ::= table_name */
{ yylhsminor.yy378 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy183); }
  yymsp[0].minor.yy378 = yylhsminor.yy378;
        break;
      case 169: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy378 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy183); }
        break;
      case 172: /* func_name ::= function_name */
{ yylhsminor.yy378 = createFunctionNode(pCxt, &yymsp[0].minor.yy183, NULL); }
  yymsp[0].minor.yy378 = yylhsminor.yy378;
        break;
      case 173: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy215, &yymsp[-3].minor.yy183, &yymsp[-1].minor.yy183, NULL, yymsp[0].minor.yy378); }
        break;
      case 174: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy215, &yymsp[-5].minor.yy183, &yymsp[-3].minor.yy183, yymsp[-1].minor.yy404, NULL); }
        break;
      case 175: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy215, &yymsp[-2].minor.yy183, &yymsp[0].minor.yy183); }
        break;
      case 177: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy378 = createIndexOption(pCxt, yymsp[-6].minor.yy404, releaseRawExprNode(pCxt, yymsp[-2].minor.yy378), NULL, yymsp[0].minor.yy378); }
        break;
      case 178: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy378 = createIndexOption(pCxt, yymsp[-8].minor.yy404, releaseRawExprNode(pCxt, yymsp[-4].minor.yy378), releaseRawExprNode(pCxt, yymsp[-2].minor.yy378), yymsp[0].minor.yy378); }
        break;
      case 181: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy378 = createFunctionNode(pCxt, &yymsp[-3].minor.yy183, yymsp[-1].minor.yy404); }
  yymsp[-3].minor.yy378 = yylhsminor.yy378;
        break;
      case 182: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy215, &yymsp[-2].minor.yy183, yymsp[0].minor.yy378, NULL); }
        break;
      case 183: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy215, &yymsp[-2].minor.yy183, NULL, &yymsp[0].minor.yy183); }
        break;
      case 184: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy215, &yymsp[0].minor.yy183); }
        break;
      case 186: /* literal ::= NK_INTEGER */
{ yylhsminor.yy378 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy378 = yylhsminor.yy378;
        break;
      case 187: /* literal ::= NK_FLOAT */
{ yylhsminor.yy378 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy378 = yylhsminor.yy378;
        break;
      case 188: /* literal ::= NK_STRING */
{ yylhsminor.yy378 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy378 = yylhsminor.yy378;
        break;
      case 189: /* literal ::= NK_BOOL */
{ yylhsminor.yy378 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy378 = yylhsminor.yy378;
        break;
      case 190: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy378 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy378 = yylhsminor.yy378;
        break;
      case 191: /* literal ::= duration_literal */
      case 199: /* signed_literal ::= signed */ yytestcase(yyruleno==199);
      case 215: /* expression ::= literal */ yytestcase(yyruleno==215);
      case 216: /* expression ::= column_reference */ yytestcase(yyruleno==216);
      case 219: /* expression ::= subquery */ yytestcase(yyruleno==219);
      case 251: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==251);
      case 255: /* boolean_primary ::= predicate */ yytestcase(yyruleno==255);
      case 257: /* common_expression ::= expression */ yytestcase(yyruleno==257);
      case 258: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==258);
      case 260: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==260);
      case 262: /* table_reference ::= table_primary */ yytestcase(yyruleno==262);
      case 263: /* table_reference ::= joined_table */ yytestcase(yyruleno==263);
      case 267: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==267);
      case 314: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==314);
      case 316: /* query_primary ::= query_specification */ yytestcase(yyruleno==316);
{ yylhsminor.yy378 = yymsp[0].minor.yy378; }
  yymsp[0].minor.yy378 = yylhsminor.yy378;
        break;
      case 192: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy378 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy378 = yylhsminor.yy378;
        break;
      case 193: /* signed ::= NK_INTEGER */
{ yylhsminor.yy378 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy378 = yylhsminor.yy378;
        break;
      case 194: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy378 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 195: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy378 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy378 = yylhsminor.yy378;
        break;
      case 196: /* signed ::= NK_FLOAT */
{ yylhsminor.yy378 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy378 = yylhsminor.yy378;
        break;
      case 197: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy378 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 198: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy378 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy378 = yylhsminor.yy378;
        break;
      case 200: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy378 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy378 = yylhsminor.yy378;
        break;
      case 201: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy378 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy378 = yylhsminor.yy378;
        break;
      case 202: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy378 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 203: /* signed_literal ::= duration_literal */
      case 328: /* search_condition ::= common_expression */ yytestcase(yyruleno==328);
{ yylhsminor.yy378 = releaseRawExprNode(pCxt, yymsp[0].minor.yy378); }
  yymsp[0].minor.yy378 = yylhsminor.yy378;
        break;
      case 217: /* expression ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy378 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy183, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy183, yymsp[-1].minor.yy404)); }
  yymsp[-3].minor.yy378 = yylhsminor.yy378;
        break;
      case 218: /* expression ::= function_name NK_LP NK_STAR NK_RP */
{ yylhsminor.yy378 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy183, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy183, createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy0)))); }
  yymsp[-3].minor.yy378 = yylhsminor.yy378;
        break;
      case 220: /* expression ::= NK_LP expression NK_RP */
      case 256: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==256);
{ yylhsminor.yy378 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy378)); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 221: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy378);
                                                                                    yylhsminor.yy378 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy378));
                                                                                  }
  yymsp[-1].minor.yy378 = yylhsminor.yy378;
        break;
      case 222: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy378);
                                                                                    yylhsminor.yy378 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[0].minor.yy378), NULL));
                                                                                  }
  yymsp[-1].minor.yy378 = yylhsminor.yy378;
        break;
      case 223: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy378);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy378);
                                                                                    yylhsminor.yy378 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy378), releaseRawExprNode(pCxt, yymsp[0].minor.yy378))); 
                                                                                  }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 224: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy378);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy378);
                                                                                    yylhsminor.yy378 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy378), releaseRawExprNode(pCxt, yymsp[0].minor.yy378))); 
                                                                                  }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 225: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy378);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy378);
                                                                                    yylhsminor.yy378 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy378), releaseRawExprNode(pCxt, yymsp[0].minor.yy378))); 
                                                                                  }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 226: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy378);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy378);
                                                                                    yylhsminor.yy378 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy378), releaseRawExprNode(pCxt, yymsp[0].minor.yy378))); 
                                                                                  }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 227: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy378);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy378);
                                                                                    yylhsminor.yy378 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy378), releaseRawExprNode(pCxt, yymsp[0].minor.yy378))); 
                                                                                  }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 228: /* expression_list ::= expression */
{ yylhsminor.yy404 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy378)); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 229: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, releaseRawExprNode(pCxt, yymsp[0].minor.yy378)); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 230: /* column_reference ::= column_name */
{ yylhsminor.yy378 = createRawExprNode(pCxt, &yymsp[0].minor.yy183, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy183)); }
  yymsp[0].minor.yy378 = yylhsminor.yy378;
        break;
      case 231: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy378 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy183, &yymsp[0].minor.yy183, createColumnNode(pCxt, &yymsp[-2].minor.yy183, &yymsp[0].minor.yy183)); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 232: /* predicate ::= expression compare_op expression */
      case 237: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==237);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy378);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy378);
                                                                                    yylhsminor.yy378 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy366, releaseRawExprNode(pCxt, yymsp[-2].minor.yy378), releaseRawExprNode(pCxt, yymsp[0].minor.yy378)));
                                                                                  }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 233: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy378);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy378);
                                                                                    yylhsminor.yy378 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy378), releaseRawExprNode(pCxt, yymsp[-2].minor.yy378), releaseRawExprNode(pCxt, yymsp[0].minor.yy378)));
                                                                                  }
  yymsp[-4].minor.yy378 = yylhsminor.yy378;
        break;
      case 234: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy378);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy378);
                                                                                    yylhsminor.yy378 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy378), releaseRawExprNode(pCxt, yymsp[-5].minor.yy378), releaseRawExprNode(pCxt, yymsp[0].minor.yy378)));
                                                                                  }
  yymsp[-5].minor.yy378 = yylhsminor.yy378;
        break;
      case 235: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy378);
                                                                                    yylhsminor.yy378 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy378), NULL));
                                                                                  }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 236: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy378);
                                                                                    yylhsminor.yy378 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy378), NULL));
                                                                                  }
  yymsp[-3].minor.yy378 = yylhsminor.yy378;
        break;
      case 238: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy366 = OP_TYPE_LOWER_THAN; }
        break;
      case 239: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy366 = OP_TYPE_GREATER_THAN; }
        break;
      case 240: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy366 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 241: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy366 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 242: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy366 = OP_TYPE_NOT_EQUAL; }
        break;
      case 243: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy366 = OP_TYPE_EQUAL; }
        break;
      case 244: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy366 = OP_TYPE_LIKE; }
        break;
      case 245: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy366 = OP_TYPE_NOT_LIKE; }
        break;
      case 246: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy366 = OP_TYPE_MATCH; }
        break;
      case 247: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy366 = OP_TYPE_NMATCH; }
        break;
      case 248: /* in_op ::= IN */
{ yymsp[0].minor.yy366 = OP_TYPE_IN; }
        break;
      case 249: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy366 = OP_TYPE_NOT_IN; }
        break;
      case 250: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy378 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy404)); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 252: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy378);
                                                                                    yylhsminor.yy378 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy378), NULL));
                                                                                  }
  yymsp[-1].minor.yy378 = yylhsminor.yy378;
        break;
      case 253: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy378);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy378);
                                                                                    yylhsminor.yy378 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy378), releaseRawExprNode(pCxt, yymsp[0].minor.yy378)));
                                                                                  }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 254: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy378);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy378);
                                                                                    yylhsminor.yy378 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy378), releaseRawExprNode(pCxt, yymsp[0].minor.yy378)));
                                                                                  }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 259: /* from_clause ::= FROM table_reference_list */
      case 289: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==289);
      case 312: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==312);
{ yymsp[-1].minor.yy378 = yymsp[0].minor.yy378; }
        break;
      case 261: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy378 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy378, yymsp[0].minor.yy378, NULL); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 264: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy378 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy183, &yymsp[0].minor.yy183); }
  yymsp[-1].minor.yy378 = yylhsminor.yy378;
        break;
      case 265: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy378 = createRealTableNode(pCxt, &yymsp[-3].minor.yy183, &yymsp[-1].minor.yy183, &yymsp[0].minor.yy183); }
  yymsp[-3].minor.yy378 = yylhsminor.yy378;
        break;
      case 266: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy378 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy378), &yymsp[0].minor.yy183); }
  yymsp[-1].minor.yy378 = yylhsminor.yy378;
        break;
      case 268: /* alias_opt ::= */
{ yymsp[1].minor.yy183 = nil_token;  }
        break;
      case 269: /* alias_opt ::= table_alias */
{ yylhsminor.yy183 = yymsp[0].minor.yy183; }
  yymsp[0].minor.yy183 = yylhsminor.yy183;
        break;
      case 270: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy183 = yymsp[0].minor.yy183; }
        break;
      case 271: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 272: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==272);
{ yymsp[-2].minor.yy378 = yymsp[-1].minor.yy378; }
        break;
      case 273: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy378 = createJoinTableNode(pCxt, yymsp[-4].minor.yy162, yymsp[-5].minor.yy378, yymsp[-2].minor.yy378, yymsp[0].minor.yy378); }
  yymsp[-5].minor.yy378 = yylhsminor.yy378;
        break;
      case 274: /* join_type ::= */
{ yymsp[1].minor.yy162 = JOIN_TYPE_INNER; }
        break;
      case 275: /* join_type ::= INNER */
{ yymsp[0].minor.yy162 = JOIN_TYPE_INNER; }
        break;
      case 276: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy378 = createSelectStmt(pCxt, yymsp[-7].minor.yy215, yymsp[-6].minor.yy404, yymsp[-5].minor.yy378);
                                                                                    yymsp[-8].minor.yy378 = addWhereClause(pCxt, yymsp[-8].minor.yy378, yymsp[-4].minor.yy378);
                                                                                    yymsp[-8].minor.yy378 = addPartitionByClause(pCxt, yymsp[-8].minor.yy378, yymsp[-3].minor.yy404);
                                                                                    yymsp[-8].minor.yy378 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy378, yymsp[-2].minor.yy378);
                                                                                    yymsp[-8].minor.yy378 = addGroupByClause(pCxt, yymsp[-8].minor.yy378, yymsp[-1].minor.yy404);
                                                                                    yymsp[-8].minor.yy378 = addHavingClause(pCxt, yymsp[-8].minor.yy378, yymsp[0].minor.yy378);
                                                                                  }
        break;
      case 278: /* set_quantifier_opt ::= DISTINCT */
{ yymsp[0].minor.yy215 = true; }
        break;
      case 279: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy215 = false; }
        break;
      case 280: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy404 = NULL; }
        break;
      case 284: /* select_item ::= common_expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy378);
                                                                                    yylhsminor.yy378 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy378), &t);
                                                                                  }
  yymsp[0].minor.yy378 = yylhsminor.yy378;
        break;
      case 285: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy378 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy378), &yymsp[0].minor.yy183); }
  yymsp[-1].minor.yy378 = yylhsminor.yy378;
        break;
      case 286: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy378 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy378), &yymsp[0].minor.yy183); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 287: /* select_item ::= table_name NK_DOT NK_STAR */
{ yylhsminor.yy378 = createColumnNode(pCxt, &yymsp[-2].minor.yy183, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 291: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 308: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==308);
      case 318: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==318);
{ yymsp[-2].minor.yy404 = yymsp[0].minor.yy404; }
        break;
      case 293: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy378 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy378), releaseRawExprNode(pCxt, yymsp[-1].minor.yy378)); }
        break;
      case 294: /* twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP */
{ yymsp[-3].minor.yy378 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy378)); }
        break;
      case 295: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy378 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy378), NULL, yymsp[-1].minor.yy378, yymsp[0].minor.yy378); }
        break;
      case 296: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy378 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy378), releaseRawExprNode(pCxt, yymsp[-3].minor.yy378), yymsp[-1].minor.yy378, yymsp[0].minor.yy378); }
        break;
      case 298: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy378 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy378); }
        break;
      case 300: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy378 = createFillNode(pCxt, yymsp[-1].minor.yy466, NULL); }
        break;
      case 301: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy378 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy404)); }
        break;
      case 302: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy466 = FILL_MODE_NONE; }
        break;
      case 303: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy466 = FILL_MODE_PREV; }
        break;
      case 304: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy466 = FILL_MODE_NULL; }
        break;
      case 305: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy466 = FILL_MODE_LINEAR; }
        break;
      case 306: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy466 = FILL_MODE_NEXT; }
        break;
      case 309: /* group_by_list ::= expression */
{ yylhsminor.yy404 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy378))); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 310: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy378))); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 313: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy378 = addOrderByClause(pCxt, yymsp[-3].minor.yy378, yymsp[-2].minor.yy404);
                                                                                    yylhsminor.yy378 = addSlimitClause(pCxt, yylhsminor.yy378, yymsp[-1].minor.yy378);
                                                                                    yylhsminor.yy378 = addLimitClause(pCxt, yylhsminor.yy378, yymsp[0].minor.yy378);
                                                                                  }
  yymsp[-3].minor.yy378 = yylhsminor.yy378;
        break;
      case 315: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy378 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy378, yymsp[0].minor.yy378); }
  yymsp[-3].minor.yy378 = yylhsminor.yy378;
        break;
      case 320: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 324: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==324);
{ yymsp[-1].minor.yy378 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 321: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 325: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==325);
{ yymsp[-3].minor.yy378 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 322: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 326: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==326);
{ yymsp[-3].minor.yy378 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 327: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy378 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy378); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 331: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy378 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy378), yymsp[-1].minor.yy400, yymsp[0].minor.yy151); }
  yymsp[-2].minor.yy378 = yylhsminor.yy378;
        break;
      case 332: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy400 = ORDER_ASC; }
        break;
      case 333: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy400 = ORDER_ASC; }
        break;
      case 334: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy400 = ORDER_DESC; }
        break;
      case 335: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy151 = NULL_ORDER_DEFAULT; }
        break;
      case 336: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy151 = NULL_ORDER_FIRST; }
        break;
      case 337: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy151 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
