/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 469
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOperatorType yy2;
  SNode* yy42;
  bool yy103;
  EOrder yy106;
  SNodeList* yy110;
  SToken yy225;
  EFillMode yy410;
  SDataType yy448;
  SAlterOption yy459;
  int32_t yy508;
  ENullOrder yy599;
  EJoinType yy638;
  int64_t yy641;
  int8_t yy705;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             740
#define YYNRULE              561
#define YYNTOKEN             328
#define YY_MAX_SHIFT         739
#define YY_MIN_SHIFTREDUCE   1097
#define YY_MAX_SHIFTREDUCE   1657
#define YY_ERROR_ACTION      1658
#define YY_ACCEPT_ACTION     1659
#define YY_NO_ACTION         1660
#define YY_MIN_REDUCE        1661
#define YY_MAX_REDUCE        2221
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2835)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   166,  380, 1673,  604,  479,  629,  480, 1697,  142,  161,
 /*    10 */    65, 2092,   45,   43, 1585, 1804,  356,   31, 1817,  132,
 /*    20 */   377, 1806, 1434,   38,   37, 1866,  518,   44,   42,   41,
 /*    30 */    40,   39, 2015, 1515,  140, 1432, 1815, 2033, 1149, 1589,
 /*    40 */  1148, 2019,   38,   37,  610, 1459,   44,   42,   41,   40,
 /*    50 */    39,  629, 2015,  220, 2136,   38,   37,  176, 1510,   44,
 /*    60 */    42,   41,   40,   39,   18,  187, 2011, 2017, 2051, 1150,
 /*    70 */   382, 1440, 1659, 1861, 1863,  604,  643,  639,  346, 1917,
 /*    80 */  2133, 2001, 1815,  645,   45,   43, 2011, 2017,  358,  567,
 /*    90 */  1459,  269,  377, 2192, 1434, 1934,   14,  639,  339,  181,
 /*   100 */  2129, 2130,   61,  138, 2134, 1515,  140, 1432, 2198,  182,
 /*   110 */  1932,  616, 2032, 2193,  593, 1459, 2068, 1460,  736,  323,
 /*   120 */  2034,  649, 2036, 2037,  644,  642,  639,  630, 2086,   61,
 /*   130 */  1510,   92,  628, 1517, 1518,  628,   18,  478,  390, 1544,
 /*   140 */   483, 1703,  389, 1440, 1624, 1257,  671,  670,  669, 1261,
 /*   150 */   668, 1263, 1264,  667, 1266,  664, 1459, 1272,  661, 1274,
 /*   160 */  1275,  658,  655, 1490, 1500, 1934,  604,   61,   14, 1516,
 /*   170 */  1519,  266, 2129,  603,  614,  133,  602,  368,   86, 2192,
 /*   180 */  1931,  616,  176,  567, 1435, 2051, 1433, 2192, 1491,  488,
 /*   190 */   736,  480, 1697,  586,  591,  182, 1545,  140,  497, 2193,
 /*   200 */   593, 1811, 2198,  182, 1918, 1517, 1518, 2193,  593, 1438,
 /*   210 */  1439,   48, 1489, 1492, 1493, 1494, 1495, 1496, 1497, 1498,
 /*   220 */  1499,  641,  637, 1508, 1509, 1511, 1512, 1513, 1514,    2,
 /*   230 */  1300, 1301,   61, 1491,  604, 1490, 1500, 1459,  585, 1546,
 /*   240 */   122, 1516, 1519,  121,  120,  119,  118,  117,  116,  115,
 /*   250 */   114,  113, 1149,  185, 1148,  350, 1435,  100, 1433,   35,
 /*   260 */   287,  606,  180, 2129, 2130,  140,  138, 2134,   34,  375,
 /*   270 */  1539, 1540, 1541, 1542, 1543, 1547, 1548, 1549, 1550, 1808,
 /*   280 */   185, 1438, 1439, 1150, 1489, 1492, 1493, 1494, 1495, 1496,
 /*   290 */  1497, 1498, 1499,  641,  637, 1508, 1509, 1511, 1512, 1513,
 /*   300 */  1514,    2,  615,   11,   45,   43,   44,   42,   41,   40,
 /*   310 */    39,   32,  377, 1971, 1434, 1662,  587,  351,  185,  349,
 /*   320 */   348, 1551,  520,  167,  629, 1515,  522, 1432, 1769, 2033,
 /*   330 */   183, 2129, 2130,  592,  138, 2134,  122, 2192,   54,  121,
 /*   340 */   120,  119,  118,  117,  116,  115,  114,  113,  521,  495,
 /*   350 */  1510, 1927,  591,  182, 2033, 1815,   18, 2193,  593,  237,
 /*   360 */  2051, 2020,  185, 1440,  278,  279, 1217, 2197,  646,  277,
 /*   370 */  2197, 2192, 2015, 2001, 2192,  645,   45,   43, 1520,  582,
 /*   380 */  1355, 1356, 1130,  185,  377, 2051, 1434, 2196,   14,  629,
 /*   390 */  2196, 2193, 2195,  646, 2193, 2194, 1613, 1515, 2001, 1432,
 /*   400 */   645,  152, 1219,  420, 2032,  106, 2011, 2017, 2068,  683,
 /*   410 */   736,  168, 2034,  649, 2036, 2037,  644,  639,  639,  141,
 /*   420 */  1815, 1132, 1510, 1135, 1136, 1517, 1518, 1807,  487, 2032,
 /*   430 */  1458,  483, 1703, 2068,  105, 1440,  169, 2034,  649, 2036,
 /*   440 */  2037,  644, 1661,  639,  102,  579,  578, 1611, 1612, 1614,
 /*   450 */  1615, 1616,  568, 2158,   53, 1490, 1500, 1730, 1460,  628,
 /*   460 */    46, 1516, 1519,  588,  583,  576,  131,  130,  129,  128,
 /*   470 */   127,  126,  125,  124,  123, 1525, 1435,  547, 1433,   38,
 /*   480 */    37, 1459,  736,   44,   42,   41,   40,   39,  594, 2213,
 /*   490 */   545, 1462,  543,   41,   40,   39,  675, 1517, 1518, 1859,
 /*   500 */  1994, 1438, 1439, 1792, 1489, 1492, 1493, 1494, 1495, 1496,
 /*   510 */  1497, 1498, 1499,  641,  637, 1508, 1509, 1511, 1512, 1513,
 /*   520 */  1514,    2, 2197,  533,  532,  531,  556, 1490, 1500,  164,
 /*   530 */   629,  137,  527, 1516, 1519,   48,  526,  485, 1818, 1461,
 /*   540 */    86,  525,  530,  481,  132,  567, 1868,  524, 1435, 2192,
 /*   550 */  1433,  523, 1868,  344,  136, 1684,  416,   11,  369,  355,
 /*   560 */   415, 1815, 1866, 1810, 2198,  182,  164, 1440, 1866, 2193,
 /*   570 */   593, 1372, 1373, 1438, 1439, 1817, 1489, 1492, 1493, 1494,
 /*   580 */  1495, 1496, 1497, 1498, 1499,  641,  637, 1508, 1509, 1511,
 /*   590 */  1512, 1513, 1514,    2,   45,   43,  460, 1434,  629, 2001,
 /*   600 */   679,  567,  377, 1859, 1434, 2192,   73, 1371, 1374,  422,
 /*   610 */  1432,  681,  421,  615,  629, 1515, 1647, 1432, 1461, 2033,
 /*   620 */  2198,  182,   61,  592, 1491, 2193,  593, 2192,  430, 1815,
 /*   630 */   154,  153,  678,  677,  676,  151,  246,  629,  629,  674,
 /*   640 */  1510, 1683,  591,  182, 2033, 1815, 1440, 2193,  593,  329,
 /*   650 */  2051,  445,  446, 1440,  198,  197,   81, 1868,  646,  409,
 /*   660 */   613,   49, 1927, 2001,  365,  645,   45,   43, 1815, 1815,
 /*   670 */  1868,  615, 1995, 1866,  377, 2051, 1434,  459,   46,  178,
 /*   680 */   411,  407,  629,  646,  268, 2001, 1867, 1515, 2001, 1432,
 /*   690 */   645,  695, 1855,  736, 2032,  538,  496,   11, 2068,    9,
 /*   700 */   736,  168, 2034,  649, 2036, 2037,  644, 1987,  639,  414,
 /*   710 */   548,  413, 1510, 1815,  235, 1517, 1518,  567,  624, 2032,
 /*   720 */  1927, 2192, 1800, 2068,  234, 1440,  317, 2034,  649, 2036,
 /*   730 */  2037,  644,  680,  639,  412, 1859, 2198,  182, 1682,  541,
 /*   740 */   629, 2193,  593, 2159,  535, 1490, 1500, 1802,  629,  233,
 /*   750 */    14, 1516, 1519,  194, 1812,  397,  533,  532,  531, 1435,
 /*   760 */  1868, 1433,  238,  268,  137,  527, 1435,  370, 1433,  526,
 /*   770 */   589, 1815,  736,  185,  525,  530, 1866,   89,  334, 1815,
 /*   780 */   524,  551, 2001,  549, 1438, 1439,   69, 1517, 1518,   68,
 /*   790 */    83, 1438, 1439,   82, 1489, 1492, 1493, 1494, 1495, 1496,
 /*   800 */  1497, 1498, 1499,  641,  637, 1508, 1509, 1511, 1512, 1513,
 /*   810 */  1514,    2,  185,  332, 1462, 1457, 2136, 1490, 1500, 1862,
 /*   820 */  1863, 1681,  453, 1516, 1519,  467,   38,   37,  466,  221,
 /*   830 */    44,   42,   41,   40,   39, 2136,  681, 1798, 1435, 1727,
 /*   840 */  1433, 1680, 2132,  436,  171,  468,  529,  528,  438,  673,
 /*   850 */   514,  510,  506,  502,  218,  154,  153,  678,  677,  676,
 /*   860 */   151, 2131,   27, 1438, 1439, 2001, 1489, 1492, 1493, 1494,
 /*   870 */  1495, 1496, 1497, 1498, 1499,  641,  637, 1508, 1509, 1511,
 /*   880 */  1512, 1513, 1514,    2, 1462, 2001,   33,  380,  707,  705,
 /*   890 */   347,   87,   38,   37,  216,  164,   44,   42,   41,   40,
 /*   900 */    39, 1793,  426,   52, 1817,  713,  712,  711,  710,  387,
 /*   910 */   566,  709,  708,  144,  703,  702,  701,  700,  699,  698,
 /*   920 */   697,  156,  693,  692,  691,  386,  385,  688,  687,  686,
 /*   930 */   685,  684,  464,  241, 2033,  458,  457,  456,  455,  452,
 /*   940 */   451,  450,  449,  448,  444,  443,  442,  441,  331,  433,
 /*   950 */   432,  431,  739,  428,  427,  345,  165,  301, 2019,  191,
 /*   960 */  1845,  307,  215,  209,  497, 2051,  294,  214, 1679, 2015,
 /*   970 */   493,  629,  631,  646, 2093,  305,   72,  554, 2001,   71,
 /*   980 */   645,  175, 1913, 1678,  383,  563,  207,  729,  725,  721,
 /*   990 */   717,  292,  164,  190,  629, 1898, 2196,  203,  475,  473,
 /*  1000 */   470, 1817, 1815, 2011, 2017,  359, 2033, 1677,  608, 2032,
 /*  1010 */   236,    8, 2001, 2068,  639, 1582,  110, 2034,  649, 2036,
 /*  1020 */  2037,  644,  567,  639,  629, 1815, 2192, 2001,  107,  245,
 /*  1030 */  2121,  285, 1868, 1791,   61, 2118,  596, 2051,  612,  381,
 /*  1040 */   629, 2198,  182,  629,  629,  607, 2193,  593, 1866,  629,
 /*  1050 */  2001, 2001,  645, 1676,  282, 1815,  629,  626,  627,   13,
 /*  1060 */    12,   38,   37,  288,  625,   44,   42,   41,   40,   39,
 /*  1070 */   384, 1815,  522,  108, 1815, 1815, 1410, 1411, 2033,  640,
 /*  1080 */  1815, 2032,  633, 1675, 2093, 2068,  599, 1815,  109, 2034,
 /*  1090 */   649, 2036, 2037,  644,  521,  639,  683, 2001,  562,  272,
 /*  1100 */   179, 1913, 2121, 1674,  271, 1672,  371, 2117, 1671, 2051,
 /*  1110 */  1670,  696,  192, 1785,   80,   79,  419,  646,  152,  189,
 /*  1120 */   184, 1399, 2001,  240,  645,   38,   37, 2001, 2147,   44,
 /*  1130 */    42,   41,   40,   39, 1135, 1136, 1669,  330, 2033, 1668,
 /*  1140 */   405,  244,  403,  399,  395,  392,  412,  440,  226, 2001,
 /*  1150 */  1601,  224, 2001, 2032, 2001, 1558,  439, 2068, 1667, 1666,
 /*  1160 */   109, 2034,  649, 2036, 2037,  644, 1665,  639, 1664, 2051,
 /*  1170 */   143, 1405,  149, 2092, 2121, 2141, 1578,  607,  371, 2117,
 /*  1180 */  2001,   90, 2001, 2001,  645,  185, 1913,   38,   37, 1790,
 /*  1190 */   152,   44,   42,   41,   40,   39,  423,  196, 2033,   51,
 /*  1200 */   636,    3, 2001, 2001,  146,  228,  134, 1770,  227,  424,
 /*  1210 */  2001,  230, 2001, 2032,  229,   63,   63, 2068, 1578, 2019,
 /*  1220 */   109, 2034,  649, 2036, 2037,  644,  250,  639,  232, 2051,
 /*  1230 */  2015,  231,  179, 1443, 2121, 1717, 1710,  646,  371, 2117,
 /*  1240 */  1656, 1657, 2001, 1408,  645, 1708, 2022, 2033,   38,   37,
 /*  1250 */   152,   47,   44,   42,   41,   40,   39,  534,  536, 1581,
 /*  1260 */  2148,  595,  597, 2161, 2011, 2017,  372,  539, 1610, 1609,
 /*  1270 */   275,   70,  150, 2032,  152,  639, 1442, 2068, 2051,  252,
 /*  1280 */   109, 2034,  649, 2036, 2037,  644,  646,  639,   13,   12,
 /*  1290 */  1704, 2001, 2212,  645, 2121, 2024,   63,  681,  371, 2117,
 /*  1300 */   263,   47,   47,  611, 1369,  580,  653, 2033,  219, 2155,
 /*  1310 */   150,  152,  135,  689,  600,  150,  154,  153,  678,  677,
 /*  1320 */   676,  151, 2032,  280,  621,  284, 2068, 1250,  690,  109,
 /*  1330 */  2034,  649, 2036, 2037,  644, 1198,  639, 1179, 2051,  731,
 /*  1340 */   257, 2212, 2052, 2121,  163, 1536,  646,  371, 2117, 1552,
 /*  1350 */  1196, 2001, 1698,  645, 1501,  300,  388, 1856, 2168, 1278,
 /*  1360 */  1922,  605, 2151, 1282, 1289, 1287, 2033,  265,  155,  262,
 /*  1370 */     1,    4,  396, 1180,  391,  343, 1392,  295,  195,  425,
 /*  1380 */  1462, 1923, 2032,  429, 1446,  462, 2068,  434, 1457,  109,
 /*  1390 */  2034,  649, 2036, 2037,  644,  447,  639, 2051, 1915,  454,
 /*  1400 */   461, 2212,  463, 2121,  469,  646,  471,  371, 2117,  472,
 /*  1410 */  2001,  200,  645,  477,  474,  476, 1654, 1463,  574,  486,
 /*  1420 */  1465, 1460,  489,  206,  490, 2033,  208, 1445, 1464, 1466,
 /*  1430 */   491,  492,  211,  494, 1152,  498,  213,   84, 1977,  517,
 /*  1440 */    85, 2032,  217,  515,  516, 2068,  519, 1805,  109, 2034,
 /*  1450 */   649, 2036, 2037,  644,  112,  639, 2051,  333,  553,  555,
 /*  1460 */  2212,  223, 2121, 1976,  646, 1801,  371, 2117,   88, 2001,
 /*  1470 */   225,  645,  157,  148,  158, 1803, 1799, 2186,  159,  558,
 /*  1480 */   160,  239,  374,  373,  242, 2033,  557,  564,  581, 2152,
 /*  1490 */  2167, 2143, 1448,  619, 2162,  571,  561,    7,  577,  296,
 /*  1500 */  2032, 2166,  360, 1515, 2068, 1441,  584,  109, 2034,  649,
 /*  1510 */  2036, 2037,  644, 1653,  639,  248, 2051, 2033,  590, 2212,
 /*  1520 */   251, 2121,  256,  572,  646,  371, 2117,  570, 1510, 2001,
 /*  1530 */   258,  645,  569,  361, 2215,  601, 2140, 1578,  598, 2191,
 /*  1540 */   261, 1440, 1461,  139,  609, 2033, 2137,  270, 2051,  172,
 /*  1550 */   364,   95, 1467, 1928,  297,  617,  646,  298,  618, 1942,
 /*  1560 */  2032, 2001, 1941,  645, 2068, 1940,  367,  109, 2034,  649,
 /*  1570 */  2036, 2037,  644,  259,  639,  260, 2051,  622,  299, 2096,
 /*  1580 */   623, 2121,  264, 1816,  646,  371, 2117,   97,  635, 2001,
 /*  1590 */    99,  645, 2032,   60,  101,  651, 2068, 1860, 2102,  109,
 /*  1600 */  2034,  649, 2036, 2037,  644, 1786,  639,  732,  291,  302,
 /*  1610 */   733, 2094,  735, 2121,   50,  335,  336,  371, 2117,  311,
 /*  1620 */  2032,  326,  304,  306, 2068, 1993, 2033,  109, 2034,  649,
 /*  1630 */  2036, 2037,  644,  325,  639, 1992,  315, 1991,   77,  632,
 /*  1640 */  1988, 2121,  393,  394, 1425,  371, 2117, 1426,  188,  398,
 /*  1650 */  1986,  400,  401,  402, 1449, 1985, 1444, 2051,  404, 1984,
 /*  1660 */  1983,  406, 1982,  408,  410,  646,   78, 1395, 1394, 1954,
 /*  1670 */  2001, 1953,  645, 1952,  417, 2033, 1951, 1950,  418, 1452,
 /*  1680 */  1454, 1346, 1906, 1905, 1903,  145, 1902, 1901, 1904, 1900,
 /*  1690 */  1899, 1897,  637, 1508, 1509, 1511, 1512, 1513, 1514, 1896,
 /*  1700 */  1895, 2032,  193,  435, 1894, 2068, 2051,  437,  110, 2034,
 /*  1710 */   649, 2036, 2037,  644,  646,  639, 1908, 1893, 1892, 2001,
 /*  1720 */  1891,  645, 2121, 1890, 2033, 1889, 2120, 2117, 1888, 1887,
 /*  1730 */  1886, 1885, 1884, 1883, 1882, 1881, 1880, 1879,  147, 1878,
 /*  1740 */  1877, 1876, 1907, 1875, 1874, 1873, 1348, 1872, 1871, 1870,
 /*  1750 */  2032,  465, 1869, 1733, 2068, 2051,  199,  110, 2034,  649,
 /*  1760 */  2036, 2037,  644,  646,  639, 1732,  201, 1731, 2001,  202,
 /*  1770 */   645, 2121, 1729, 2033, 1693,  634, 2117, 1138, 1137, 1692,
 /*  1780 */   204, 1225, 1967, 1961, 1949,  212, 1948, 1926, 1794,   75,
 /*  1790 */  1728, 1172, 2033, 1726, 1724,  177,  205,  499,   76,  647,
 /*  1800 */   210, 2021,  482, 2068, 2051,  484,  110, 2034,  649, 2036,
 /*  1810 */  2037,  644,  646,  639,  500,  501,  503, 2001,  504,  645,
 /*  1820 */  2121, 1722, 1720, 2051,  338, 2117,  508,  507,  366, 1707,
 /*  1830 */   505,  646,  511,  512,  509,  513, 2001, 1706,  645, 1689,
 /*  1840 */  1796, 2033, 1294, 1795, 1216, 1293, 1215, 1214, 2032, 1213,
 /*  1850 */   704, 1210, 2068, 1209,  706,  169, 2034,  649, 2036, 2037,
 /*  1860 */   644, 2033,  639, 1208, 1718,   62, 1207, 2032,  352, 1711,
 /*  1870 */   353, 2068, 2051, 1709,  324, 2034,  649, 2036, 2037,  644,
 /*  1880 */   643,  639,  354,  222,  537, 2001,  540,  645, 1688,  542,
 /*  1890 */  1687,  544, 2051, 1686,  546,  111, 1415,  376, 1414,  550,
 /*  1900 */   646, 1417, 1966, 1401,   26, 2001, 1960,  645, 2214,   66,
 /*  1910 */  1947,  559, 1945,   28,  162,   19, 2032,   16, 2033,  575,
 /*  1920 */  2068, 1626,   55,  323, 2034,  649, 2036, 2037,  644, 2197,
 /*  1930 */   639,  247, 2087,  560, 2033,  573, 2032,   64,  357,  249,
 /*  1940 */  2068,    5,  243,  324, 2034,  649, 2036, 2037,  644, 2051,
 /*  1950 */   639,   58, 2033,   59,  378, 1608, 1600,  646,  254,   30,
 /*  1960 */   255,    6, 2001,  170,  645, 2051,  253, 2022,   21,  267,
 /*  1970 */    29,  565,   91,  646, 1646, 1647, 1641, 1640, 2001,  362,
 /*  1980 */   645, 1645, 1644, 2051,  363,  173, 1946,   57, 1575, 1574,
 /*  1990 */  1944,  646, 1943, 2032, 1925,   93, 2001, 2068,  645,   94,
 /*  2000 */   324, 2034,  649, 2036, 2037,  644,  273,  639,  274,  552,
 /*  2010 */  1924, 2033,   22, 2068, 1606,  276,  319, 2034,  649, 2036,
 /*  2020 */  2037,  644,   56,  639,  281,  620,   67, 2032, 2033,   98,
 /*  2030 */    96, 2068,  283,  102,  308, 2034,  649, 2036, 2037,  644,
 /*  2040 */   286,  639, 2051,   12,   23, 2033, 1450,   10, 2071, 1527,
 /*  2050 */   646,   20,   17, 1537, 1505, 2001, 1526,  645,  638, 2051,
 /*  2060 */  1503,   36,  174, 1502,   15,   24,  186,  646, 1474, 1482,
 /*  2070 */  1279,   25, 2001,  652,  645,  379, 2051,  650,  654,  656,
 /*  2080 */  1276,  657, 1256,  659,  646, 1273, 2032,  662,  665, 2001,
 /*  2090 */  2068,  645,  660,  309, 2034,  649, 2036, 2037,  644, 1267,
 /*  2100 */   639,  663, 2033, 2032, 1265,  648,  289, 2068,  666, 1271,
 /*  2110 */   310, 2034,  649, 2036, 2037,  644,  672,  639, 1270,  103,
 /*  2120 */  2032, 1269,  104, 1268, 2068, 1288,   74,  316, 2034,  649,
 /*  2130 */  2036, 2037,  644, 2051,  639, 1284, 2033, 1170,  682, 1204,
 /*  2140 */  1203,  646, 1202, 1201, 1200, 1199, 2001, 1197,  645, 1195,
 /*  2150 */  1194, 1193, 1223, 1191,  694,  290, 1190, 1189, 1188, 1187,
 /*  2160 */  1186, 1185, 1220, 2033, 1218, 1182, 1181, 2051, 1178, 1177,
 /*  2170 */  1176, 1725, 1175,  714,  716,  646,  715, 2032, 1723,  718,
 /*  2180 */  2001, 2068,  645, 1721,  320, 2034,  649, 2036, 2037,  644,
 /*  2190 */   719,  639,  720, 2033, 2051,  722,  724, 1719,  723,  726,
 /*  2200 */   727,  728,  646, 1705,  730, 1127, 1685, 2001,  293,  645,
 /*  2210 */   734, 2032, 2033, 1436,  303, 2068,  737, 1660,  312, 2034,
 /*  2220 */   649, 2036, 2037,  644, 2051,  639, 1660,  738, 1660, 1660,
 /*  2230 */  1660, 1660,  646, 1660, 1660, 1660, 1660, 2001, 2032,  645,
 /*  2240 */  1660, 1660, 2068, 2051, 1660,  321, 2034,  649, 2036, 2037,
 /*  2250 */   644,  646,  639, 1660, 1660, 1660, 2001, 1660,  645, 1660,
 /*  2260 */  1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660, 2032, 1660,
 /*  2270 */  1660, 1660, 2068, 1660, 1660,  313, 2034,  649, 2036, 2037,
 /*  2280 */   644, 2033,  639, 1660, 1660, 1660, 1660, 2032, 1660, 1660,
 /*  2290 */  1660, 2068, 1660, 1660,  322, 2034,  649, 2036, 2037,  644,
 /*  2300 */  1660,  639, 1660, 1660, 1660, 2033, 1660, 1660, 1660, 1660,
 /*  2310 */  1660, 1660, 2051, 1660, 1660, 1660, 1660, 1660, 1660, 1660,
 /*  2320 */   646, 1660, 1660, 1660, 1660, 2001, 1660,  645, 1660, 1660,
 /*  2330 */  2033, 1660, 1660, 1660, 1660, 1660, 2051, 1660, 1660, 1660,
 /*  2340 */  1660, 1660, 1660, 1660,  646, 1660, 1660, 1660, 1660, 2001,
 /*  2350 */  1660,  645, 1660, 1660, 1660, 1660, 2032, 1660, 1660, 1660,
 /*  2360 */  2068, 2051, 1660,  314, 2034,  649, 2036, 2037,  644,  646,
 /*  2370 */   639, 1660, 1660, 1660, 2001, 1660,  645, 1660, 1660, 1660,
 /*  2380 */  2032, 1660, 1660, 1660, 2068, 1660, 1660,  327, 2034,  649,
 /*  2390 */  2036, 2037,  644, 1660,  639, 1660, 1660, 1660, 1660, 2033,
 /*  2400 */  1660, 1660, 1660, 1660, 1660, 2032, 1660, 1660, 1660, 2068,
 /*  2410 */  1660, 1660,  328, 2034,  649, 2036, 2037,  644, 2033,  639,
 /*  2420 */  1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660,
 /*  2430 */  2051, 1660, 1660, 1660, 1660, 1660, 1660, 1660,  646, 1660,
 /*  2440 */  1660, 1660, 1660, 2001, 1660,  645, 1660, 1660, 1660, 2051,
 /*  2450 */  1660, 1660, 1660, 1660, 1660, 1660, 1660,  646, 1660, 1660,
 /*  2460 */  1660, 1660, 2001, 1660,  645, 1660, 1660, 1660, 1660, 1660,
 /*  2470 */  1660, 1660, 1660, 1660, 2032, 1660, 1660, 1660, 2068, 1660,
 /*  2480 */  2033, 2045, 2034,  649, 2036, 2037,  644, 1660,  639, 1660,
 /*  2490 */  1660, 1660, 1660, 2032, 1660, 1660, 1660, 2068, 1660, 2033,
 /*  2500 */  2044, 2034,  649, 2036, 2037,  644, 1660,  639, 1660, 1660,
 /*  2510 */  1660, 2051, 1660, 1660, 1660, 1660, 1660, 1660, 1660,  646,
 /*  2520 */  1660, 1660, 1660, 1660, 2001, 1660,  645, 1660, 1660, 1660,
 /*  2530 */  2051, 1660, 1660, 1660, 1660, 1660, 1660, 1660,  646, 1660,
 /*  2540 */  1660, 1660, 1660, 2001, 1660,  645, 1660, 1660, 1660, 1660,
 /*  2550 */  1660, 1660, 1660, 1660, 1660, 2032, 2033, 1660, 1660, 2068,
 /*  2560 */  1660, 1660, 2043, 2034,  649, 2036, 2037,  644, 1660,  639,
 /*  2570 */  1660, 1660, 1660, 1660, 2032, 2033, 1660, 1660, 2068, 1660,
 /*  2580 */  1660,  340, 2034,  649, 2036, 2037,  644, 2051,  639, 1660,
 /*  2590 */  1660, 1660, 1660, 1660, 1660,  646, 1660, 1660, 1660, 1660,
 /*  2600 */  2001, 1660,  645, 1660, 1660, 1660, 2051, 1660, 1660, 1660,
 /*  2610 */  1660, 1660, 1660, 1660,  646, 1660, 1660, 1660, 1660, 2001,
 /*  2620 */  1660,  645, 1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660,
 /*  2630 */  1660, 2032, 1660, 1660, 1660, 2068, 1660, 2033,  341, 2034,
 /*  2640 */   649, 2036, 2037,  644, 1660,  639, 1660, 1660, 1660, 1660,
 /*  2650 */  2032, 1660, 1660, 1660, 2068, 1660, 1660,  337, 2034,  649,
 /*  2660 */  2036, 2037,  644, 1660,  639, 1660, 1660, 1660, 2051, 1660,
 /*  2670 */  1660, 1660, 1660, 1660, 1660, 1660,  646, 1660, 1660, 1660,
 /*  2680 */  1660, 2001, 1660,  645, 1660, 1660, 1660, 1660, 1660, 1660,
 /*  2690 */  1660, 1660, 1660, 1660, 1660, 1660, 2033, 1660, 1660, 1660,
 /*  2700 */  1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660,
 /*  2710 */  1660, 1660, 2032, 1660, 1660, 1660, 2068, 1660, 1660,  342,
 /*  2720 */  2034,  649, 2036, 2037,  644, 1660,  639, 2051, 1660, 1660,
 /*  2730 */  1660, 1660, 1660, 1660, 1660,  646, 1660, 1660, 1660, 1660,
 /*  2740 */  2001, 1660,  645, 1660, 1660, 2033, 1660, 1660, 1660, 1660,
 /*  2750 */  1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660,
 /*  2760 */  1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660,
 /*  2770 */  1660,  647, 1660, 1660, 1660, 2068, 2051, 1660,  319, 2034,
 /*  2780 */   649, 2036, 2037,  644,  646,  639, 1660, 1660, 1660, 2001,
 /*  2790 */  1660,  645, 1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660,
 /*  2800 */  1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660,
 /*  2810 */  1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660, 1660,
 /*  2820 */  2032, 1660, 1660, 1660, 2068, 1660, 1660,  318, 2034,  649,
 /*  2830 */  2036, 2037,  644, 1660,  639,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   330,  354,  332,  339,  335,  339,  337,  338,  423,  362,
 /*    10 */     4,  426,   12,   13,   14,  363,  369,    2,  371,  353,
 /*    20 */    20,  364,   22,    8,    9,  378,  360,   12,   13,   14,
 /*    30 */    15,   16,  375,   33,  370,   35,  370,  331,   20,   14,
 /*    40 */    22,  364,    8,    9,  394,   20,   12,   13,   14,   15,
 /*    50 */    16,  339,  375,   35,  412,    8,    9,  362,   58,   12,
 /*    60 */    13,   14,   15,   16,   64,  353,  409,  410,  362,   51,
 /*    70 */   373,   71,  328,  376,  377,  339,  370,  420,  383,  384,
 /*    80 */   438,  375,  370,  377,   12,   13,  409,  410,  411,  439,
 /*    90 */    20,   58,   20,  443,   22,  377,   96,  420,   64,  435,
 /*   100 */   436,  437,   96,  439,  440,   33,  370,   35,  458,  459,
 /*   110 */   392,  393,  406,  463,  464,   20,  410,   20,  118,  413,
 /*   120 */   414,  415,  416,  417,  418,  419,  420,  421,  422,   96,
 /*   130 */    58,   98,   20,  133,  134,   20,   64,  336,  394,  105,
 /*   140 */   339,  340,  398,   71,   97,  109,  110,  111,  112,  113,
 /*   150 */   114,  115,  116,  117,  118,  119,   20,  121,  122,  123,
 /*   160 */   124,  125,  126,  163,  164,  377,  339,   96,   96,  169,
 /*   170 */   170,  435,  436,  437,   20,  439,  440,  389,  345,  443,
 /*   180 */   392,  393,  362,  439,  184,  362,  186,  443,  163,  335,
 /*   190 */   118,  337,  338,  370,  458,  459,  162,  370,   63,  463,
 /*   200 */   464,  368,  458,  459,  384,  133,  134,  463,  464,  209,
 /*   210 */   210,   96,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */   133,  134,   96,  163,  339,  163,  164,   20,  415,  162,
 /*   240 */    21,  169,  170,   24,   25,   26,   27,   28,   29,   30,
 /*   250 */    31,   32,   20,  247,   22,   37,  184,  343,  186,  428,
 /*   260 */   429,  434,  435,  436,  437,  370,  439,  440,  234,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,  242,  243,  244,  365,
 /*   280 */   247,  209,  210,   51,  212,  213,  214,  215,  216,  217,
 /*   290 */   218,  219,  220,  221,  222,  223,  224,  225,  226,  227,
 /*   300 */   228,  229,  339,  231,   12,   13,   12,   13,   14,   15,
 /*   310 */    16,  234,   20,  358,   22,    0,   20,   99,  247,  101,
 /*   320 */   102,  244,  104,  346,  339,   33,  108,   35,  351,  331,
 /*   330 */   435,  436,  437,  439,  439,  440,   21,  443,  353,   24,
 /*   340 */    25,   26,   27,   28,   29,   30,   31,   32,  130,  386,
 /*   350 */    58,  388,  458,  459,  331,  370,   64,  463,  464,  404,
 /*   360 */   362,  364,  247,   71,  127,  128,   35,  439,  370,  132,
 /*   370 */   439,  443,  375,  375,  443,  377,   12,   13,   14,  168,
 /*   380 */   163,  164,    4,  247,   20,  362,   22,  459,   96,  339,
 /*   390 */   459,  463,  464,  370,  463,  464,  209,   33,  375,   35,
 /*   400 */   377,   44,   71,  353,  406,  343,  409,  410,  410,   63,
 /*   410 */   118,  413,  414,  415,  416,  417,  418,  420,  420,  357,
 /*   420 */   370,   43,   58,   45,   46,  133,  134,  365,  336,  406,
 /*   430 */    20,  339,  340,  410,   96,   71,  413,  414,  415,  416,
 /*   440 */   417,  418,    0,  420,  106,  258,  259,  260,  261,  262,
 /*   450 */   263,  264,  454,  455,   97,  163,  164,    0,   20,   20,
 /*   460 */    96,  169,  170,  252,  253,  254,   24,   25,   26,   27,
 /*   470 */    28,   29,   30,   31,   32,   14,  184,   21,  186,    8,
 /*   480 */     9,   20,  118,   12,   13,   14,   15,   16,  465,  466,
 /*   490 */    34,   20,   36,   14,   15,   16,  372,  133,  134,  375,
 /*   500 */   394,  209,  210,    0,  212,  213,  214,  215,  216,  217,
 /*   510 */   218,  219,  220,  221,  222,  223,  224,  225,  226,  227,
 /*   520 */   228,  229,    3,   66,   67,   68,  107,  163,  164,  362,
 /*   530 */   339,   74,   75,  169,  170,   96,   79,   14,  371,   20,
 /*   540 */   345,   84,   85,   20,  353,  439,  362,   90,  184,  443,
 /*   550 */   186,  360,  362,  369,  359,  331,  394,  231,  354,  369,
 /*   560 */   398,  370,  378,  368,  458,  459,  362,   71,  378,  463,
 /*   570 */   464,  133,  134,  209,  210,  371,  212,  213,  214,  215,
 /*   580 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   590 */   226,  227,  228,  229,   12,   13,   80,   22,  339,  375,
 /*   600 */   372,  439,   20,  375,   22,  443,  107,  169,  170,  339,
 /*   610 */    35,  108,  353,  339,  339,   33,   97,   35,   20,  331,
 /*   620 */   458,  459,   96,  439,  163,  463,  464,  443,  353,  370,
 /*   630 */   127,  128,  129,  130,  131,  132,  165,  339,  339,  107,
 /*   640 */    58,  331,  458,  459,  331,  370,   71,  463,  464,  379,
 /*   650 */   362,  353,  353,   71,  138,  139,  157,  362,  370,  179,
 /*   660 */   386,   96,  388,  375,  369,  377,   12,   13,  370,  370,
 /*   670 */   362,  339,  394,  378,   20,  362,   22,  161,   96,  361,
 /*   680 */   200,  201,  339,  370,  165,  375,  378,   33,  375,   35,
 /*   690 */   377,   71,  374,  118,  406,    4,  353,  231,  410,  233,
 /*   700 */   118,  413,  414,  415,  416,  417,  418,    0,  420,  183,
 /*   710 */    19,  185,   58,  370,  128,  133,  134,  439,  386,  406,
 /*   720 */   388,  443,  363,  410,   33,   71,  413,  414,  415,  416,
 /*   730 */   417,  418,  372,  420,  208,  375,  458,  459,  331,   48,
 /*   740 */   339,  463,  464,  455,   53,  163,  164,  363,  339,   58,
 /*   750 */    96,  169,  170,   58,  353,   48,   66,   67,   68,  184,
 /*   760 */   362,  186,  353,  165,   74,   75,  184,  369,  186,   79,
 /*   770 */   457,  370,  118,  247,   84,   85,  378,  191,  192,  370,
 /*   780 */    90,  195,  375,  197,  209,  210,   95,  133,  134,   98,
 /*   790 */    95,  209,  210,   98,  212,  213,  214,  215,  216,  217,
 /*   800 */   218,  219,  220,  221,  222,  223,  224,  225,  226,  227,
 /*   810 */   228,  229,  247,   18,   20,   20,  412,  163,  164,  376,
 /*   820 */   377,  331,   27,  169,  170,   30,    8,    9,   33,   33,
 /*   830 */    12,   13,   14,   15,   16,  412,  108,  363,  184,    0,
 /*   840 */   186,  331,  438,   48,   48,   50,  348,  349,   53,  363,
 /*   850 */    54,   55,   56,   57,   58,  127,  128,  129,  130,  131,
 /*   860 */   132,  438,   44,  209,  210,  375,  212,  213,  214,  215,
 /*   870 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   880 */   226,  227,  228,  229,   20,  375,    2,  354,  348,  349,
 /*   890 */    95,   95,    8,    9,   98,  362,   12,   13,   14,   15,
 /*   900 */    16,    0,  107,  165,  371,   66,   67,   68,   69,   70,
 /*   910 */   172,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   920 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   930 */    91,   92,  137,  363,  331,  140,  141,  142,  143,  144,
 /*   940 */   145,  146,  147,  148,  149,  150,  151,  152,  153,  154,
 /*   950 */   155,  156,   19,  158,  159,  160,   18,  355,  364,  165,
 /*   960 */   358,   23,  166,  167,   63,  362,   33,  171,  331,  375,
 /*   970 */   174,  339,  424,  370,  426,   37,   38,  394,  375,   41,
 /*   980 */   377,   48,  370,  331,  354,  353,  190,   54,   55,   56,
 /*   990 */    57,   58,  362,  381,  339,    0,    3,   59,   60,   61,
 /*  1000 */    62,  371,  370,  409,  410,  411,  331,  331,  353,  406,
 /*  1010 */   127,   39,  375,  410,  420,    4,  413,  414,  415,  416,
 /*  1020 */   417,  418,  439,  420,  339,  370,  443,  375,   95,  165,
 /*  1030 */   427,   98,  362,    0,   96,  432,   44,  362,  353,  369,
 /*  1040 */   339,  458,  459,  339,  339,  370,  463,  464,  378,  339,
 /*  1050 */   375,  375,  377,  331,  353,  370,  339,  353,  353,    1,
 /*  1060 */     2,    8,    9,  353,  131,   12,   13,   14,   15,   16,
 /*  1070 */   353,  370,  108,  135,  370,  370,  193,  194,  331,  363,
 /*  1080 */   370,  406,  424,  331,  426,  410,   44,  370,  413,  414,
 /*  1090 */   415,  416,  417,  418,  130,  420,   63,  375,  399,  166,
 /*  1100 */   425,  370,  427,  332,  171,  331,  431,  432,  331,  362,
 /*  1110 */   331,  350,  381,  352,  176,  177,  178,  370,   44,  181,
 /*  1120 */   445,  188,  375,  190,  377,    8,    9,  375,  453,   12,
 /*  1130 */    13,   14,   15,   16,   45,   46,  331,  199,  331,  331,
 /*  1140 */   202,   58,  204,  205,  206,  207,  208,  152,  100,  375,
 /*  1150 */    97,  103,  375,  406,  375,   97,  161,  410,  331,  331,
 /*  1160 */   413,  414,  415,  416,  417,  418,  331,  420,  331,  362,
 /*  1170 */   423,   97,  425,  426,  427,  245,  246,  370,  431,  432,
 /*  1180 */   375,   98,  375,  375,  377,  247,  370,    8,    9,    0,
 /*  1190 */    44,   12,   13,   14,   15,   16,   22,  381,  331,   42,
 /*  1200 */    64,   44,  375,  375,   42,  100,   44,  351,  103,   35,
 /*  1210 */   375,  100,  375,  406,  103,   44,   44,  410,  246,  364,
 /*  1220 */   413,  414,  415,  416,  417,  418,   44,  420,  100,  362,
 /*  1230 */   375,  103,  425,   35,  427,    0,    0,  370,  431,  432,
 /*  1240 */   133,  134,  375,   97,  377,    0,   47,  331,    8,    9,
 /*  1250 */    44,   44,   12,   13,   14,   15,   16,   22,   22,  248,
 /*  1260 */   453,  268,  270,  385,  409,  410,  411,   22,   97,   97,
 /*  1270 */    44,   44,   44,  406,   44,  420,   35,  410,  362,   97,
 /*  1280 */   413,  414,  415,  416,  417,  418,  370,  420,    1,    2,
 /*  1290 */     0,  375,  425,  377,  427,   96,   44,  108,  431,  432,
 /*  1300 */   467,   44,   44,   97,   97,  456,   44,  331,  341,  442,
 /*  1310 */    44,   44,   44,   13,  272,   44,  127,  128,  129,  130,
 /*  1320 */   131,  132,  406,   97,   97,   97,  410,   97,   13,  413,
 /*  1330 */   414,  415,  416,  417,  418,   35,  420,   35,  362,   49,
 /*  1340 */   450,  425,  362,  427,  165,  209,  370,  431,  432,   97,
 /*  1350 */    35,  375,  338,  377,   97,   97,  341,  374,  442,   97,
 /*  1360 */   385,  441,  385,   97,   97,   97,  331,  460,   97,  433,
 /*  1370 */   444,  249,   48,   71,  408,  407,  182,  396,   42,  382,
 /*  1380 */    20,  385,  406,  382,  186,  162,  410,  380,   20,  413,
 /*  1390 */   414,  415,  416,  417,  418,  339,  420,  362,  339,  382,
 /*  1400 */   380,  425,  380,  427,  339,  370,   94,  431,  432,  347,
 /*  1410 */   375,  339,  377,  333,  339,  339,  176,   20,  442,  333,
 /*  1420 */    20,   20,  401,  345,  377,  331,  345,  186,   20,   20,
 /*  1430 */   340,  395,  345,  340,   52,  339,  345,  345,  375,  333,
 /*  1440 */   345,  406,  345,  342,  342,  410,  362,  362,  413,  414,
 /*  1450 */   415,  416,  417,  418,  339,  420,  362,  333,  198,  405,
 /*  1460 */   425,  362,  427,  375,  370,  362,  431,  432,   96,  375,
 /*  1470 */   362,  377,  362,  403,  362,  362,  362,  442,  362,  400,
 /*  1480 */   362,  343,   12,   13,  343,  331,  189,  339,  257,  385,
 /*  1490 */   449,  452,   22,  256,  385,  375,  377,  265,  375,  401,
 /*  1500 */   406,  449,  375,   33,  410,   35,  375,  413,  414,  415,
 /*  1510 */   416,  417,  418,  273,  420,  390,  362,  331,  175,  425,
 /*  1520 */   390,  427,  451,  267,  370,  431,  432,  266,   58,  375,
 /*  1530 */   448,  377,  250,  274,  468,  271,  442,  246,  269,  462,
 /*  1540 */   408,   71,   20,  370,  339,  331,  412,  343,  362,  449,
 /*  1550 */   340,  343,   20,  388,  390,  375,  370,  390,  375,  375,
 /*  1560 */   406,  375,  375,  377,  410,  375,  375,  413,  414,  415,
 /*  1570 */   416,  417,  418,  447,  420,  446,  362,  167,  358,  425,
 /*  1580 */   387,  427,  461,  370,  370,  431,  432,  343,  118,  375,
 /*  1590 */   343,  377,  406,   96,   96,  366,  410,  375,  430,  413,
 /*  1600 */   414,  415,  416,  417,  418,  352,  420,   36,  343,  339,
 /*  1610 */   334,  425,  333,  427,  397,  391,  391,  431,  432,  356,
 /*  1620 */   406,  402,  344,  329,  410,    0,  331,  413,  414,  415,
 /*  1630 */   416,  417,  418,  356,  420,    0,  356,    0,   42,  425,
 /*  1640 */     0,  427,   35,  203,   35,  431,  432,   35,   35,  203,
 /*  1650 */     0,   35,   35,  203,  184,    0,  186,  362,  203,    0,
 /*  1660 */     0,   35,    0,   22,   35,  370,  191,  186,  184,    0,
 /*  1670 */   375,    0,  377,    0,  180,  331,    0,    0,  179,  209,
 /*  1680 */   210,   47,    0,    0,    0,   42,    0,    0,    0,    0,
 /*  1690 */     0,    0,  222,  223,  224,  225,  226,  227,  228,    0,
 /*  1700 */     0,  406,  152,   35,    0,  410,  362,  152,  413,  414,
 /*  1710 */   415,  416,  417,  418,  370,  420,    0,    0,    0,  375,
 /*  1720 */     0,  377,  427,    0,  331,    0,  431,  432,    0,    0,
 /*  1730 */     0,    0,    0,    0,    0,    0,    0,    0,   42,    0,
 /*  1740 */     0,    0,    0,    0,    0,    0,   22,    0,    0,    0,
 /*  1750 */   406,  136,    0,    0,  410,  362,   58,  413,  414,  415,
 /*  1760 */   416,  417,  418,  370,  420,    0,   58,    0,  375,   58,
 /*  1770 */   377,  427,    0,  331,    0,  431,  432,   14,   14,    0,
 /*  1780 */    42,   35,    0,    0,    0,  175,    0,    0,    0,   39,
 /*  1790 */     0,   65,  331,    0,    0,   44,   40,   35,   39,  406,
 /*  1800 */    39,   47,   47,  410,  362,   47,  413,  414,  415,  416,
 /*  1810 */   417,  418,  370,  420,   48,   39,   35,  375,   48,  377,
 /*  1820 */   427,    0,    0,  362,  431,  432,   48,   35,  367,    0,
 /*  1830 */    39,  370,   35,   48,   39,   39,  375,    0,  377,    0,
 /*  1840 */     0,  331,   35,    0,   35,   22,   35,   35,  406,   35,
 /*  1850 */    44,   35,  410,   35,   44,  413,  414,  415,  416,  417,
 /*  1860 */   418,  331,  420,   22,    0,  105,   35,  406,   22,    0,
 /*  1870 */    22,  410,  362,    0,  413,  414,  415,  416,  417,  418,
 /*  1880 */   370,  420,   22,  103,   50,  375,   35,  377,    0,   35,
 /*  1890 */     0,   35,  362,    0,   22,   20,   35,  367,   35,  196,
 /*  1900 */   370,   97,    0,   35,   96,  375,    0,  377,  466,   96,
 /*  1910 */     0,   22,    0,   96,  187,   44,  406,  251,  331,  255,
 /*  1920 */   410,   97,  165,  413,  414,  415,  416,  417,  418,    3,
 /*  1930 */   420,   96,  422,  165,  331,  230,  406,    3,  165,   97,
 /*  1940 */   410,  172,  167,  413,  414,  415,  416,  417,  418,  362,
 /*  1950 */   420,   44,  331,   44,  367,   97,   97,  370,   44,   44,
 /*  1960 */    47,  172,  375,   96,  377,  362,   96,   47,   44,   47,
 /*  1970 */    96,  173,   96,  370,   97,   97,   35,   35,  375,   35,
 /*  1980 */   377,   35,   35,  362,   35,   47,    0,   44,   97,   97,
 /*  1990 */     0,  370,    0,  406,    0,   96,  375,  410,  377,   39,
 /*  2000 */   413,  414,  415,  416,  417,  418,   47,  420,   97,  406,
 /*  2010 */     0,  331,   96,  410,   97,   96,  413,  414,  415,  416,
 /*  2020 */   417,  418,  245,  420,   96,  168,   96,  406,  331,   96,
 /*  2030 */    39,  410,  166,  106,  413,  414,  415,  416,  417,  418,
 /*  2040 */    47,  420,  362,    2,   44,  331,   22,  232,   96,  230,
 /*  2050 */   370,  251,  251,  209,   97,  375,  230,  377,   96,  362,
 /*  2060 */    97,   96,   47,   97,   96,   96,   47,  370,   97,   22,
 /*  2070 */    97,   96,  375,   35,  377,   35,  362,  107,   96,   35,
 /*  2080 */    97,   96,   22,   35,  370,   97,  406,   35,   35,  375,
 /*  2090 */   410,  377,   96,  413,  414,  415,  416,  417,  418,   97,
 /*  2100 */   420,   96,  331,  406,   97,  211,   44,  410,   96,  120,
 /*  2110 */   413,  414,  415,  416,  417,  418,  108,  420,  120,   96,
 /*  2120 */   406,  120,   96,  120,  410,   35,   96,  413,  414,  415,
 /*  2130 */   416,  417,  418,  362,  420,   22,  331,   65,   64,   35,
 /*  2140 */    35,  370,   35,   35,   35,   35,  375,   35,  377,   35,
 /*  2150 */    35,   35,   71,   35,   93,   44,   35,   35,   22,   35,
 /*  2160 */    35,   35,   71,  331,   35,   35,   35,  362,   35,   35,
 /*  2170 */    22,    0,   35,   35,   39,  370,   48,  406,    0,   35,
 /*  2180 */   375,  410,  377,    0,  413,  414,  415,  416,  417,  418,
 /*  2190 */    48,  420,   39,  331,  362,   35,   39,    0,   48,   35,
 /*  2200 */    48,   39,  370,    0,   35,   35,    0,  375,   22,  377,
 /*  2210 */    21,  406,  331,   22,   22,  410,   21,  469,  413,  414,
 /*  2220 */   415,  416,  417,  418,  362,  420,  469,   20,  469,  469,
 /*  2230 */   469,  469,  370,  469,  469,  469,  469,  375,  406,  377,
 /*  2240 */   469,  469,  410,  362,  469,  413,  414,  415,  416,  417,
 /*  2250 */   418,  370,  420,  469,  469,  469,  375,  469,  377,  469,
 /*  2260 */   469,  469,  469,  469,  469,  469,  469,  469,  406,  469,
 /*  2270 */   469,  469,  410,  469,  469,  413,  414,  415,  416,  417,
 /*  2280 */   418,  331,  420,  469,  469,  469,  469,  406,  469,  469,
 /*  2290 */   469,  410,  469,  469,  413,  414,  415,  416,  417,  418,
 /*  2300 */   469,  420,  469,  469,  469,  331,  469,  469,  469,  469,
 /*  2310 */   469,  469,  362,  469,  469,  469,  469,  469,  469,  469,
 /*  2320 */   370,  469,  469,  469,  469,  375,  469,  377,  469,  469,
 /*  2330 */   331,  469,  469,  469,  469,  469,  362,  469,  469,  469,
 /*  2340 */   469,  469,  469,  469,  370,  469,  469,  469,  469,  375,
 /*  2350 */   469,  377,  469,  469,  469,  469,  406,  469,  469,  469,
 /*  2360 */   410,  362,  469,  413,  414,  415,  416,  417,  418,  370,
 /*  2370 */   420,  469,  469,  469,  375,  469,  377,  469,  469,  469,
 /*  2380 */   406,  469,  469,  469,  410,  469,  469,  413,  414,  415,
 /*  2390 */   416,  417,  418,  469,  420,  469,  469,  469,  469,  331,
 /*  2400 */   469,  469,  469,  469,  469,  406,  469,  469,  469,  410,
 /*  2410 */   469,  469,  413,  414,  415,  416,  417,  418,  331,  420,
 /*  2420 */   469,  469,  469,  469,  469,  469,  469,  469,  469,  469,
 /*  2430 */   362,  469,  469,  469,  469,  469,  469,  469,  370,  469,
 /*  2440 */   469,  469,  469,  375,  469,  377,  469,  469,  469,  362,
 /*  2450 */   469,  469,  469,  469,  469,  469,  469,  370,  469,  469,
 /*  2460 */   469,  469,  375,  469,  377,  469,  469,  469,  469,  469,
 /*  2470 */   469,  469,  469,  469,  406,  469,  469,  469,  410,  469,
 /*  2480 */   331,  413,  414,  415,  416,  417,  418,  469,  420,  469,
 /*  2490 */   469,  469,  469,  406,  469,  469,  469,  410,  469,  331,
 /*  2500 */   413,  414,  415,  416,  417,  418,  469,  420,  469,  469,
 /*  2510 */   469,  362,  469,  469,  469,  469,  469,  469,  469,  370,
 /*  2520 */   469,  469,  469,  469,  375,  469,  377,  469,  469,  469,
 /*  2530 */   362,  469,  469,  469,  469,  469,  469,  469,  370,  469,
 /*  2540 */   469,  469,  469,  375,  469,  377,  469,  469,  469,  469,
 /*  2550 */   469,  469,  469,  469,  469,  406,  331,  469,  469,  410,
 /*  2560 */   469,  469,  413,  414,  415,  416,  417,  418,  469,  420,
 /*  2570 */   469,  469,  469,  469,  406,  331,  469,  469,  410,  469,
 /*  2580 */   469,  413,  414,  415,  416,  417,  418,  362,  420,  469,
 /*  2590 */   469,  469,  469,  469,  469,  370,  469,  469,  469,  469,
 /*  2600 */   375,  469,  377,  469,  469,  469,  362,  469,  469,  469,
 /*  2610 */   469,  469,  469,  469,  370,  469,  469,  469,  469,  375,
 /*  2620 */   469,  377,  469,  469,  469,  469,  469,  469,  469,  469,
 /*  2630 */   469,  406,  469,  469,  469,  410,  469,  331,  413,  414,
 /*  2640 */   415,  416,  417,  418,  469,  420,  469,  469,  469,  469,
 /*  2650 */   406,  469,  469,  469,  410,  469,  469,  413,  414,  415,
 /*  2660 */   416,  417,  418,  469,  420,  469,  469,  469,  362,  469,
 /*  2670 */   469,  469,  469,  469,  469,  469,  370,  469,  469,  469,
 /*  2680 */   469,  375,  469,  377,  469,  469,  469,  469,  469,  469,
 /*  2690 */   469,  469,  469,  469,  469,  469,  331,  469,  469,  469,
 /*  2700 */   469,  469,  469,  469,  469,  469,  469,  469,  469,  469,
 /*  2710 */   469,  469,  406,  469,  469,  469,  410,  469,  469,  413,
 /*  2720 */   414,  415,  416,  417,  418,  469,  420,  362,  469,  469,
 /*  2730 */   469,  469,  469,  469,  469,  370,  469,  469,  469,  469,
 /*  2740 */   375,  469,  377,  469,  469,  331,  469,  469,  469,  469,
 /*  2750 */   469,  469,  469,  469,  469,  469,  469,  469,  469,  469,
 /*  2760 */   469,  469,  469,  469,  469,  469,  469,  469,  469,  469,
 /*  2770 */   469,  406,  469,  469,  469,  410,  362,  469,  413,  414,
 /*  2780 */   415,  416,  417,  418,  370,  420,  469,  469,  469,  375,
 /*  2790 */   469,  377,  469,  469,  469,  469,  469,  469,  469,  469,
 /*  2800 */   469,  469,  469,  469,  469,  469,  469,  469,  469,  469,
 /*  2810 */   469,  469,  469,  469,  469,  469,  469,  469,  469,  469,
 /*  2820 */   406,  469,  469,  469,  410,  469,  469,  413,  414,  415,
 /*  2830 */   416,  417,  418,  469,  420,
};
#define YY_SHIFT_COUNT    (739)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2207)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   938,    0,   72,    0,  292,  292,  292,  292,  292,  292,
 /*    10 */   292,  292,  292,  292,  292,  364,  582,  582,  654,  582,
 /*    20 */   582,  582,  582,  582,  582,  582,  582,  582,  582,  582,
 /*    30 */   582,  582,  582,  582,  582,  582,  582,  582,  582,  582,
 /*    40 */   582,  582,  582,  582,  582,  582,  582,  582,  115,  136,
 /*    50 */   526,  439,   33,   71,  565,   71,  439,  439, 1470, 1470,
 /*    60 */  1470,   71, 1470, 1470,    6,   71,   95,  438,  112,  112,
 /*    70 */   438,  378,  378,  217,   97,  523,  523,  112,  112,  112,
 /*    80 */   112,  112,  112,  112,  154,  112,  112,  135,   95,  112,
 /*    90 */   112,  296,  112,   95,  112,  154,  112,  154,   95,  112,
 /*   100 */   112,   95,  112,   95,   95,   95,  112,  346,  795,   34,
 /*   110 */    34,  219,  690,  575,  575,  575,  575,  575,  575,  575,
 /*   120 */   575,  575,  575,  575,  575,  575,  575,  575,  575,  575,
 /*   130 */   575,  575,  218,  519,  217,   97,  901,  331,  598,  598,
 /*   140 */   598, 1033,  466,  466,  331,  410,  410,  410,  419,  326,
 /*   150 */    95,  496,   95,  496,  496,  532,  620,   36,   36,   36,
 /*   160 */    36,   36,   36,   36,   36,  933,  315,  457,  471, 1240,
 /*   170 */   187,   18,  211,   25,  461,  232,  794, 1089,  964,  864,
 /*   180 */   930,  972,  993,  930, 1157, 1011,   70, 1122, 1324, 1194,
 /*   190 */  1336, 1360, 1336, 1223, 1368, 1368, 1336, 1223, 1223, 1368,
 /*   200 */  1312, 1368, 1368, 1368, 1397, 1397, 1400,  135, 1401,  135,
 /*   210 */  1408, 1409,  135, 1408,  135,  135,  135, 1368,  135, 1382,
 /*   220 */  1382, 1397,   95,   95,   95,   95,   95,   95,   95,   95,
 /*   230 */    95,   95,   95, 1368, 1397,  496,  496, 1260, 1372, 1400,
 /*   240 */   346, 1297, 1401,  346, 1368, 1360, 1360,  496, 1231, 1237,
 /*   250 */   496, 1231, 1237,  496,  496,   95, 1232, 1343, 1231, 1256,
 /*   260 */  1261, 1282, 1122, 1259, 1264, 1269, 1291,  410, 1522, 1368,
 /*   270 */  1408,  346,  346, 1532, 1237,  496,  496,  496,  496,  496,
 /*   280 */  1237,  496, 1410,  346,  532,  346,  410, 1497, 1498,  496,
 /*   290 */   620, 1368,  346, 1571, 1397, 2835, 2835, 2835, 2835, 2835,
 /*   300 */  2835, 2835, 2835, 2835,  839,  796,  442,  691,   47,  818,
 /*   310 */  1053,  503,   15,  884, 1179, 1189, 1117, 1117, 1117, 1117,
 /*   320 */  1117, 1117, 1117, 1117, 1117,  728,  586,  294,  294,  516,
 /*   330 */   480,  995,  695,  456,  883,  237,  237,  479, 1058,   77,
 /*   340 */   479,  479,  479,  707,  357, 1174, 1162,  499, 1048, 1105,
 /*   350 */  1111, 1128, 1235, 1236, 1245, 1074, 1146, 1083, 1171, 1172,
 /*   360 */  1182, 1107,  992, 1042,  738, 1206, 1207, 1226, 1227, 1228,
 /*   370 */  1230, 1287, 1252, 1198, 1241, 1136, 1257, 1199, 1258, 1262,
 /*   380 */  1266, 1267, 1268, 1271,  338, 1300, 1315, 1302, 1290, 1625,
 /*   390 */  1635, 1637, 1596, 1640, 1607, 1440, 1609, 1612, 1613, 1446,
 /*   400 */  1650, 1616, 1617, 1450, 1655, 1455, 1659, 1626, 1660, 1641,
 /*   410 */  1662, 1629, 1475, 1481, 1484, 1669, 1671, 1673, 1494, 1499,
 /*   420 */  1676, 1677, 1634, 1682, 1683, 1684, 1643, 1686, 1687, 1688,
 /*   430 */  1689, 1690, 1691, 1699, 1700, 1550, 1668, 1704, 1555, 1716,
 /*   440 */  1717, 1718, 1720, 1723, 1725, 1728, 1729, 1730, 1731, 1732,
 /*   450 */  1733, 1734, 1735, 1736, 1737, 1696, 1739, 1740, 1741, 1742,
 /*   460 */  1743, 1744, 1724, 1745, 1747, 1748, 1615, 1749, 1752, 1753,
 /*   470 */  1698, 1746, 1765, 1708, 1767, 1711, 1772, 1774, 1738, 1750,
 /*   480 */  1751, 1754, 1763, 1755, 1764, 1758, 1779, 1756, 1759, 1782,
 /*   490 */  1783, 1784, 1761, 1610, 1786, 1787, 1788, 1726, 1790, 1793,
 /*   500 */  1762, 1766, 1776, 1794, 1781, 1770, 1791, 1821, 1792, 1778,
 /*   510 */  1795, 1822, 1797, 1785, 1796, 1829, 1837, 1839, 1840, 1760,
 /*   520 */  1780, 1807, 1823, 1843, 1809, 1811, 1812, 1814, 1806, 1810,
 /*   530 */  1816, 1818, 1841, 1831, 1864, 1846, 1869, 1848, 1834, 1873,
 /*   540 */  1860, 1851, 1888, 1854, 1890, 1856, 1893, 1872, 1875, 1861,
 /*   550 */  1863, 1703, 1804, 1808, 1902, 1757, 1813, 1868, 1906, 1727,
 /*   560 */  1889, 1768, 1775, 1910, 1912, 1773, 1798, 1926, 1871, 1666,
 /*   570 */  1817, 1824, 1835, 1769, 1705, 1789, 1664, 1842, 1907, 1909,
 /*   580 */  1858, 1867, 1870, 1874, 1859, 1914, 1913, 1920, 1876, 1915,
 /*   590 */  1800, 1877, 1878, 1934, 1924, 1801, 1941, 1942, 1944, 1946,
 /*   600 */  1947, 1949, 1891, 1892, 1922, 1777, 1943, 1938, 1986, 1990,
 /*   610 */  1992, 1994, 1899, 1960, 1754, 1959, 1916, 1911, 1917, 1919,
 /*   620 */  1928, 1857, 1930, 2010, 1991, 1866, 1933, 1927, 1754, 1993,
 /*   630 */  2000, 1819, 1815, 1826, 2041, 2024, 1844, 1952, 1957, 1962,
 /*   640 */  1963, 1965, 1966, 2015, 1968, 1969, 2019, 1971, 2047, 1894,
 /*   650 */  1975, 1970, 1973, 2038, 2040, 1982, 1983, 2044, 1985, 1988,
 /*   660 */  2048, 1996, 2002, 2052, 2005, 2007, 2053, 2012, 1989, 1998,
 /*   670 */  2001, 2003, 2060, 2008, 2023, 2062, 2026, 2090, 2030, 2062,
 /*   680 */  2062, 2113, 2072, 2074, 2104, 2105, 2107, 2108, 2109, 2110,
 /*   690 */  2112, 2114, 2115, 2116, 2081, 2061, 2111, 2118, 2121, 2122,
 /*   700 */  2136, 2124, 2125, 2126, 2091, 1806, 2129, 1810, 2130, 2131,
 /*   710 */  2133, 2134, 2148, 2137, 2171, 2138, 2128, 2135, 2178, 2144,
 /*   720 */  2142, 2153, 2183, 2160, 2150, 2157, 2197, 2164, 2152, 2162,
 /*   730 */  2203, 2169, 2170, 2206, 2186, 2189, 2191, 2192, 2195, 2207,
};
#define YY_REDUCE_COUNT (303)
#define YY_REDUCE_MIN   (-415)
#define YY_REDUCE_MAX   (2414)
static const short yy_reduce_ofst[] = {
 /*     0 */  -256,  675,  747,  807,  867,  916,  976, 1035, 1094, 1154,
 /*    10 */  1186, 1214, 1295, 1344, 1393, -294,   -2,   23,  603,  288,
 /*    20 */   313, 1442, 1461, 1510, 1530, 1587, 1603, 1621, 1680, 1697,
 /*    30 */  1714, 1771, 1805, 1832, 1862, 1881, 1950, 1974, 1999, 2068,
 /*    40 */  2087, 2149, 2168, 2225, 2244, 2306, 2365, 2414, -264,  184,
 /*    50 */   162, -173, -350,  106,  278,  583, -336, -105, -323,  594,
 /*    60 */   855, -106, -343,   -3,  -72,  -69, -353, -212, -334,  191,
 /*    70 */  -282, -331, -146, -305, -303, -199,   92, -288,  -15,   50,
 /*    80 */   259,  275,  298,  299,  -37,  343,  401,  195,  190,  409,
 /*    90 */   632, -177,  655,  295,  685,  274,  701,  332,  204,  704,
 /*   100 */   705,  398,  710,  533,  670,  630,  717,   62,  270, -169,
 /*   110 */  -169, -330,  -23,  224,  310,  407,  490,  510,  637,  652,
 /*   120 */   676,  722,  752,  774,  777,  779,  805,  808,  827,  828,
 /*   130 */   835,  837,  318, -358, -180,  443, -167,  498, -358,  404,
 /*   140 */   423,  -86,  548,  658,  540,  612,  731,  816,  -45, -415,
 /*   150 */   167,  124,  308,  228,  360,  602,  761, -348,  359,  384,
 /*   160 */   474,  486,  570,  716,  486,  699,  771,  856,  878,  833,
 /*   170 */   849,  967,  890,  980,  980, 1015,  975, 1014,  983,  977,
 /*   180 */   920,  920,  907,  920,  936,  926,  980,  966,  968,  981,
 /*   190 */   997,  996, 1001, 1007, 1056, 1059, 1017, 1020, 1022, 1065,
 /*   200 */  1062, 1072, 1075, 1076, 1080, 1086, 1021, 1078, 1047, 1081,
 /*   210 */  1090, 1036, 1087, 1093, 1091, 1092, 1095, 1096, 1097, 1101,
 /*   220 */  1102, 1106, 1084, 1085, 1099, 1103, 1108, 1110, 1112, 1113,
 /*   230 */  1114, 1116, 1118, 1115, 1124, 1063, 1088, 1054, 1070, 1098,
 /*   240 */  1138, 1079, 1119, 1141, 1148, 1104, 1109, 1120, 1041, 1125,
 /*   250 */  1123, 1052, 1130, 1127, 1131,  980, 1039, 1071, 1100, 1082,
 /*   260 */  1126, 1129, 1132, 1066, 1077, 1121,  920, 1173, 1134, 1205,
 /*   270 */  1210, 1204, 1208, 1165, 1164, 1180, 1183, 1184, 1187, 1190,
 /*   280 */  1167, 1191, 1193, 1244, 1220, 1247, 1213, 1168, 1229, 1222,
 /*   290 */  1253, 1270, 1265, 1276, 1279, 1217, 1219, 1224, 1225, 1263,
 /*   300 */  1277, 1280, 1278, 1294,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*    10 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*    20 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*    30 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*    40 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*    50 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*    60 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*    70 */  1658, 1658, 1658, 1916, 1658, 1658, 1658, 1658, 1658, 1658,
 /*    80 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1737, 1658, 1658,
 /*    90 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   100 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1735, 1909, 2123,
 /*   110 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   120 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   130 */  1658, 1658, 1658, 2135, 1658, 1658, 1737, 1658, 2135, 2135,
 /*   140 */  2135, 1735, 2095, 2095, 1658, 1658, 1658, 1658, 1970, 1658,
 /*   150 */  1658, 1658, 1658, 1658, 1658, 1844, 1658, 1658, 1658, 1658,
 /*   160 */  1658, 1868, 1658, 1658, 1658, 1962, 1658, 1658, 2160, 2216,
 /*   170 */  1658, 1658, 2163, 1658, 1658, 1658, 1921, 1658, 1797, 2150,
 /*   180 */  2127, 2141, 2200, 2128, 2125, 2144, 1658, 2154, 1658, 1955,
 /*   190 */  1914, 1658, 1914, 1911, 1658, 1658, 1914, 1911, 1911, 1658,
 /*   200 */  1788, 1658, 1658, 1658, 1658, 1658, 1658, 1737, 1658, 1737,
 /*   210 */  1658, 1658, 1737, 1658, 1737, 1737, 1737, 1658, 1737, 1715,
 /*   220 */  1715, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   230 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1980, 1968, 1658,
 /*   240 */  1735, 1964, 1658, 1735, 1658, 1658, 1658, 1658, 2171, 2169,
 /*   250 */  1658, 2171, 2169, 1658, 1658, 1658, 2185, 2181, 2171, 2189,
 /*   260 */  2187, 2156, 2154, 2219, 2206, 2202, 2141, 1658, 1658, 1658,
 /*   270 */  1658, 1735, 1735, 1658, 2169, 1658, 1658, 1658, 1658, 1658,
 /*   280 */  2169, 1658, 1658, 1735, 1658, 1735, 1658, 1658, 1813, 1658,
 /*   290 */  1658, 1658, 1735, 1690, 1658, 1957, 1973, 1939, 1939, 1847,
 /*   300 */  1847, 1847, 1738, 1663, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   310 */  1658, 1658, 1658, 1658, 1658, 1658, 2184, 2183, 2050, 1658,
 /*   320 */  2099, 2098, 2097, 2088, 2049, 1809, 1658, 2048, 2047, 1658,
 /*   330 */  1658, 1658, 1658, 1658, 1658, 1930, 1929, 2041, 1658, 1658,
 /*   340 */  2042, 2040, 2039, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   350 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   360 */  1658, 1658, 2203, 2207, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   370 */  1658, 2124, 1658, 1658, 1658, 1658, 1658, 2023, 1658, 1658,
 /*   380 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   390 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   400 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   410 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   420 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   430 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   440 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   450 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   460 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   470 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   480 */  1695, 2028, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   490 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   500 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   510 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   520 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1776, 1775,
 /*   530 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   540 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   550 */  1658, 1658, 2032, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   560 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 2199, 2157, 1658,
 /*   570 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   580 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 2023, 1658, 2182,
 /*   590 */  1658, 1658, 2197, 1658, 2201, 1658, 1658, 1658, 1658, 1658,
 /*   600 */  1658, 1658, 2134, 2130, 1658, 1658, 2126, 1658, 1658, 1658,
 /*   610 */  1658, 1658, 1658, 1658, 2031, 1658, 1658, 1658, 1658, 1658,
 /*   620 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 2022, 1658,
 /*   630 */  2085, 1658, 1658, 1658, 2119, 1658, 1658, 2070, 1658, 1658,
 /*   640 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 2032, 1658, 2035,
 /*   650 */  1658, 1658, 1658, 1658, 1658, 1841, 1658, 1658, 1658, 1658,
 /*   660 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1826, 1824,
 /*   670 */  1823, 1822, 1658, 1819, 1658, 1854, 1658, 1658, 1658, 1850,
 /*   680 */  1849, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   690 */  1658, 1658, 1658, 1658, 1658, 1658, 1756, 1658, 1658, 1658,
 /*   700 */  1658, 1658, 1658, 1658, 1658, 1748, 1658, 1747, 1658, 1658,
 /*   710 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   720 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
 /*   730 */  1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658, 1658,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
  275,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*      START => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  275,  /*      AFTER => ABORT */
  275,  /*     ATTACH => ABORT */
  275,  /*     BEFORE => ABORT */
  275,  /*      BEGIN => ABORT */
  275,  /*     BITAND => ABORT */
  275,  /*     BITNOT => ABORT */
  275,  /*      BITOR => ABORT */
  275,  /*     BLOCKS => ABORT */
  275,  /*     CHANGE => ABORT */
  275,  /*      COMMA => ABORT */
  275,  /*     CONCAT => ABORT */
  275,  /*   CONFLICT => ABORT */
  275,  /*       COPY => ABORT */
  275,  /*   DEFERRED => ABORT */
  275,  /* DELIMITERS => ABORT */
  275,  /*     DETACH => ABORT */
  275,  /*     DIVIDE => ABORT */
  275,  /*        DOT => ABORT */
  275,  /*       EACH => ABORT */
  275,  /*       FAIL => ABORT */
  275,  /*       FILE => ABORT */
  275,  /*        FOR => ABORT */
  275,  /*       GLOB => ABORT */
  275,  /*         ID => ABORT */
  275,  /*  IMMEDIATE => ABORT */
  275,  /*     IMPORT => ABORT */
  275,  /*  INITIALLY => ABORT */
  275,  /*    INSTEAD => ABORT */
  275,  /*     ISNULL => ABORT */
  275,  /*        KEY => ABORT */
  275,  /*    MODULES => ABORT */
  275,  /*  NK_BITNOT => ABORT */
  275,  /*    NK_SEMI => ABORT */
  275,  /*    NOTNULL => ABORT */
  275,  /*         OF => ABORT */
  275,  /*       PLUS => ABORT */
  275,  /*  PRIVILEGE => ABORT */
  275,  /*      RAISE => ABORT */
  275,  /*    REPLACE => ABORT */
  275,  /*   RESTRICT => ABORT */
  275,  /*        ROW => ABORT */
  275,  /*       SEMI => ABORT */
  275,  /*       STAR => ABORT */
  275,  /*  STATEMENT => ABORT */
  275,  /*     STRICT => ABORT */
  275,  /*     STRING => ABORT */
  275,  /*      TIMES => ABORT */
  275,  /*     UPDATE => ABORT */
  275,  /*     VALUES => ABORT */
  275,  /*   VARIABLE => ABORT */
  275,  /*       VIEW => ABORT */
  275,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "COMPACT",
  /*   63 */ "IF",
  /*   64 */ "NOT",
  /*   65 */ "EXISTS",
  /*   66 */ "BUFFER",
  /*   67 */ "CACHEMODEL",
  /*   68 */ "CACHESIZE",
  /*   69 */ "COMP",
  /*   70 */ "DURATION",
  /*   71 */ "NK_VARIABLE",
  /*   72 */ "MAXROWS",
  /*   73 */ "MINROWS",
  /*   74 */ "KEEP",
  /*   75 */ "PAGES",
  /*   76 */ "PAGESIZE",
  /*   77 */ "TSDB_PAGESIZE",
  /*   78 */ "PRECISION",
  /*   79 */ "REPLICA",
  /*   80 */ "VGROUPS",
  /*   81 */ "SINGLE_STABLE",
  /*   82 */ "RETENTIONS",
  /*   83 */ "SCHEMALESS",
  /*   84 */ "WAL_LEVEL",
  /*   85 */ "WAL_FSYNC_PERIOD",
  /*   86 */ "WAL_RETENTION_PERIOD",
  /*   87 */ "WAL_RETENTION_SIZE",
  /*   88 */ "WAL_ROLL_PERIOD",
  /*   89 */ "WAL_SEGMENT_SIZE",
  /*   90 */ "STT_TRIGGER",
  /*   91 */ "TABLE_PREFIX",
  /*   92 */ "TABLE_SUFFIX",
  /*   93 */ "NK_COLON",
  /*   94 */ "MAX_SPEED",
  /*   95 */ "TABLE",
  /*   96 */ "NK_LP",
  /*   97 */ "NK_RP",
  /*   98 */ "STABLE",
  /*   99 */ "ADD",
  /*  100 */ "COLUMN",
  /*  101 */ "MODIFY",
  /*  102 */ "RENAME",
  /*  103 */ "TAG",
  /*  104 */ "SET",
  /*  105 */ "NK_EQ",
  /*  106 */ "USING",
  /*  107 */ "TAGS",
  /*  108 */ "COMMENT",
  /*  109 */ "BOOL",
  /*  110 */ "TINYINT",
  /*  111 */ "SMALLINT",
  /*  112 */ "INT",
  /*  113 */ "INTEGER",
  /*  114 */ "BIGINT",
  /*  115 */ "FLOAT",
  /*  116 */ "DOUBLE",
  /*  117 */ "BINARY",
  /*  118 */ "TIMESTAMP",
  /*  119 */ "NCHAR",
  /*  120 */ "UNSIGNED",
  /*  121 */ "JSON",
  /*  122 */ "VARCHAR",
  /*  123 */ "MEDIUMBLOB",
  /*  124 */ "BLOB",
  /*  125 */ "VARBINARY",
  /*  126 */ "DECIMAL",
  /*  127 */ "MAX_DELAY",
  /*  128 */ "WATERMARK",
  /*  129 */ "ROLLUP",
  /*  130 */ "TTL",
  /*  131 */ "SMA",
  /*  132 */ "DELETE_MARK",
  /*  133 */ "FIRST",
  /*  134 */ "LAST",
  /*  135 */ "SHOW",
  /*  136 */ "PRIVILEGES",
  /*  137 */ "DATABASES",
  /*  138 */ "TABLES",
  /*  139 */ "STABLES",
  /*  140 */ "MNODES",
  /*  141 */ "QNODES",
  /*  142 */ "FUNCTIONS",
  /*  143 */ "INDEXES",
  /*  144 */ "ACCOUNTS",
  /*  145 */ "APPS",
  /*  146 */ "CONNECTIONS",
  /*  147 */ "LICENCES",
  /*  148 */ "GRANTS",
  /*  149 */ "QUERIES",
  /*  150 */ "SCORES",
  /*  151 */ "TOPICS",
  /*  152 */ "VARIABLES",
  /*  153 */ "CLUSTER",
  /*  154 */ "BNODES",
  /*  155 */ "SNODES",
  /*  156 */ "TRANSACTIONS",
  /*  157 */ "DISTRIBUTED",
  /*  158 */ "CONSUMERS",
  /*  159 */ "SUBSCRIPTIONS",
  /*  160 */ "VNODES",
  /*  161 */ "ALIVE",
  /*  162 */ "LIKE",
  /*  163 */ "TBNAME",
  /*  164 */ "QTAGS",
  /*  165 */ "AS",
  /*  166 */ "INDEX",
  /*  167 */ "FUNCTION",
  /*  168 */ "INTERVAL",
  /*  169 */ "COUNT",
  /*  170 */ "LAST_ROW",
  /*  171 */ "TOPIC",
  /*  172 */ "WITH",
  /*  173 */ "META",
  /*  174 */ "CONSUMER",
  /*  175 */ "GROUP",
  /*  176 */ "DESC",
  /*  177 */ "DESCRIBE",
  /*  178 */ "RESET",
  /*  179 */ "QUERY",
  /*  180 */ "CACHE",
  /*  181 */ "EXPLAIN",
  /*  182 */ "ANALYZE",
  /*  183 */ "VERBOSE",
  /*  184 */ "NK_BOOL",
  /*  185 */ "RATIO",
  /*  186 */ "NK_FLOAT",
  /*  187 */ "OUTPUTTYPE",
  /*  188 */ "AGGREGATE",
  /*  189 */ "BUFSIZE",
  /*  190 */ "STREAM",
  /*  191 */ "INTO",
  /*  192 */ "TRIGGER",
  /*  193 */ "AT_ONCE",
  /*  194 */ "WINDOW_CLOSE",
  /*  195 */ "IGNORE",
  /*  196 */ "EXPIRED",
  /*  197 */ "FILL_HISTORY",
  /*  198 */ "SUBTABLE",
  /*  199 */ "KILL",
  /*  200 */ "CONNECTION",
  /*  201 */ "TRANSACTION",
  /*  202 */ "BALANCE",
  /*  203 */ "VGROUP",
  /*  204 */ "MERGE",
  /*  205 */ "REDISTRIBUTE",
  /*  206 */ "SPLIT",
  /*  207 */ "DELETE",
  /*  208 */ "INSERT",
  /*  209 */ "NULL",
  /*  210 */ "NK_QUESTION",
  /*  211 */ "NK_ARROW",
  /*  212 */ "ROWTS",
  /*  213 */ "QSTART",
  /*  214 */ "QEND",
  /*  215 */ "QDURATION",
  /*  216 */ "WSTART",
  /*  217 */ "WEND",
  /*  218 */ "WDURATION",
  /*  219 */ "IROWTS",
  /*  220 */ "ISFILLED",
  /*  221 */ "CAST",
  /*  222 */ "NOW",
  /*  223 */ "TODAY",
  /*  224 */ "TIMEZONE",
  /*  225 */ "CLIENT_VERSION",
  /*  226 */ "SERVER_VERSION",
  /*  227 */ "SERVER_STATUS",
  /*  228 */ "CURRENT_USER",
  /*  229 */ "CASE",
  /*  230 */ "END",
  /*  231 */ "WHEN",
  /*  232 */ "THEN",
  /*  233 */ "ELSE",
  /*  234 */ "BETWEEN",
  /*  235 */ "IS",
  /*  236 */ "NK_LT",
  /*  237 */ "NK_GT",
  /*  238 */ "NK_LE",
  /*  239 */ "NK_GE",
  /*  240 */ "NK_NE",
  /*  241 */ "MATCH",
  /*  242 */ "NMATCH",
  /*  243 */ "CONTAINS",
  /*  244 */ "IN",
  /*  245 */ "JOIN",
  /*  246 */ "INNER",
  /*  247 */ "SELECT",
  /*  248 */ "DISTINCT",
  /*  249 */ "WHERE",
  /*  250 */ "PARTITION",
  /*  251 */ "BY",
  /*  252 */ "SESSION",
  /*  253 */ "STATE_WINDOW",
  /*  254 */ "EVENT_WINDOW",
  /*  255 */ "START",
  /*  256 */ "SLIDING",
  /*  257 */ "FILL",
  /*  258 */ "VALUE",
  /*  259 */ "VALUE_F",
  /*  260 */ "NONE",
  /*  261 */ "PREV",
  /*  262 */ "NULL_F",
  /*  263 */ "LINEAR",
  /*  264 */ "NEXT",
  /*  265 */ "HAVING",
  /*  266 */ "RANGE",
  /*  267 */ "EVERY",
  /*  268 */ "ORDER",
  /*  269 */ "SLIMIT",
  /*  270 */ "SOFFSET",
  /*  271 */ "LIMIT",
  /*  272 */ "OFFSET",
  /*  273 */ "ASC",
  /*  274 */ "NULLS",
  /*  275 */ "ABORT",
  /*  276 */ "AFTER",
  /*  277 */ "ATTACH",
  /*  278 */ "BEFORE",
  /*  279 */ "BEGIN",
  /*  280 */ "BITAND",
  /*  281 */ "BITNOT",
  /*  282 */ "BITOR",
  /*  283 */ "BLOCKS",
  /*  284 */ "CHANGE",
  /*  285 */ "COMMA",
  /*  286 */ "CONCAT",
  /*  287 */ "CONFLICT",
  /*  288 */ "COPY",
  /*  289 */ "DEFERRED",
  /*  290 */ "DELIMITERS",
  /*  291 */ "DETACH",
  /*  292 */ "DIVIDE",
  /*  293 */ "DOT",
  /*  294 */ "EACH",
  /*  295 */ "FAIL",
  /*  296 */ "FILE",
  /*  297 */ "FOR",
  /*  298 */ "GLOB",
  /*  299 */ "ID",
  /*  300 */ "IMMEDIATE",
  /*  301 */ "IMPORT",
  /*  302 */ "INITIALLY",
  /*  303 */ "INSTEAD",
  /*  304 */ "ISNULL",
  /*  305 */ "KEY",
  /*  306 */ "MODULES",
  /*  307 */ "NK_BITNOT",
  /*  308 */ "NK_SEMI",
  /*  309 */ "NOTNULL",
  /*  310 */ "OF",
  /*  311 */ "PLUS",
  /*  312 */ "PRIVILEGE",
  /*  313 */ "RAISE",
  /*  314 */ "REPLACE",
  /*  315 */ "RESTRICT",
  /*  316 */ "ROW",
  /*  317 */ "SEMI",
  /*  318 */ "STAR",
  /*  319 */ "STATEMENT",
  /*  320 */ "STRICT",
  /*  321 */ "STRING",
  /*  322 */ "TIMES",
  /*  323 */ "UPDATE",
  /*  324 */ "VALUES",
  /*  325 */ "VARIABLE",
  /*  326 */ "VIEW",
  /*  327 */ "WAL",
  /*  328 */ "cmd",
  /*  329 */ "account_options",
  /*  330 */ "alter_account_options",
  /*  331 */ "literal",
  /*  332 */ "alter_account_option",
  /*  333 */ "user_name",
  /*  334 */ "sysinfo_opt",
  /*  335 */ "privileges",
  /*  336 */ "priv_level",
  /*  337 */ "priv_type_list",
  /*  338 */ "priv_type",
  /*  339 */ "db_name",
  /*  340 */ "topic_name",
  /*  341 */ "dnode_endpoint",
  /*  342 */ "force_opt",
  /*  343 */ "not_exists_opt",
  /*  344 */ "db_options",
  /*  345 */ "exists_opt",
  /*  346 */ "alter_db_options",
  /*  347 */ "speed_opt",
  /*  348 */ "integer_list",
  /*  349 */ "variable_list",
  /*  350 */ "retention_list",
  /*  351 */ "alter_db_option",
  /*  352 */ "retention",
  /*  353 */ "full_table_name",
  /*  354 */ "column_def_list",
  /*  355 */ "tags_def_opt",
  /*  356 */ "table_options",
  /*  357 */ "multi_create_clause",
  /*  358 */ "tags_def",
  /*  359 */ "multi_drop_clause",
  /*  360 */ "alter_table_clause",
  /*  361 */ "alter_table_options",
  /*  362 */ "column_name",
  /*  363 */ "type_name",
  /*  364 */ "signed_literal",
  /*  365 */ "create_subtable_clause",
  /*  366 */ "specific_cols_opt",
  /*  367 */ "expression_list",
  /*  368 */ "drop_table_clause",
  /*  369 */ "col_name_list",
  /*  370 */ "table_name",
  /*  371 */ "column_def",
  /*  372 */ "duration_list",
  /*  373 */ "rollup_func_list",
  /*  374 */ "alter_table_option",
  /*  375 */ "duration_literal",
  /*  376 */ "rollup_func_name",
  /*  377 */ "function_name",
  /*  378 */ "col_name",
  /*  379 */ "db_name_cond_opt",
  /*  380 */ "like_pattern_opt",
  /*  381 */ "table_name_cond",
  /*  382 */ "from_db_opt",
  /*  383 */ "tag_list_opt",
  /*  384 */ "tag_item",
  /*  385 */ "column_alias",
  /*  386 */ "full_index_name",
  /*  387 */ "index_options",
  /*  388 */ "index_name",
  /*  389 */ "func_list",
  /*  390 */ "sliding_opt",
  /*  391 */ "sma_stream_opt",
  /*  392 */ "func",
  /*  393 */ "sma_func_name",
  /*  394 */ "query_or_subquery",
  /*  395 */ "cgroup_name",
  /*  396 */ "analyze_opt",
  /*  397 */ "explain_options",
  /*  398 */ "insert_query",
  /*  399 */ "agg_func_opt",
  /*  400 */ "bufsize_opt",
  /*  401 */ "stream_name",
  /*  402 */ "stream_options",
  /*  403 */ "col_list_opt",
  /*  404 */ "tag_def_or_ref_opt",
  /*  405 */ "subtable_opt",
  /*  406 */ "expression",
  /*  407 */ "dnode_list",
  /*  408 */ "where_clause_opt",
  /*  409 */ "signed",
  /*  410 */ "literal_func",
  /*  411 */ "literal_list",
  /*  412 */ "table_alias",
  /*  413 */ "expr_or_subquery",
  /*  414 */ "pseudo_column",
  /*  415 */ "column_reference",
  /*  416 */ "function_expression",
  /*  417 */ "case_when_expression",
  /*  418 */ "star_func",
  /*  419 */ "star_func_para_list",
  /*  420 */ "noarg_func",
  /*  421 */ "other_para_list",
  /*  422 */ "star_func_para",
  /*  423 */ "when_then_list",
  /*  424 */ "case_when_else_opt",
  /*  425 */ "common_expression",
  /*  426 */ "when_then_expr",
  /*  427 */ "predicate",
  /*  428 */ "compare_op",
  /*  429 */ "in_op",
  /*  430 */ "in_predicate_value",
  /*  431 */ "boolean_value_expression",
  /*  432 */ "boolean_primary",
  /*  433 */ "from_clause_opt",
  /*  434 */ "table_reference_list",
  /*  435 */ "table_reference",
  /*  436 */ "table_primary",
  /*  437 */ "joined_table",
  /*  438 */ "alias_opt",
  /*  439 */ "subquery",
  /*  440 */ "parenthesized_joined_table",
  /*  441 */ "join_type",
  /*  442 */ "search_condition",
  /*  443 */ "query_specification",
  /*  444 */ "set_quantifier_opt",
  /*  445 */ "select_list",
  /*  446 */ "partition_by_clause_opt",
  /*  447 */ "range_opt",
  /*  448 */ "every_opt",
  /*  449 */ "fill_opt",
  /*  450 */ "twindow_clause_opt",
  /*  451 */ "group_by_clause_opt",
  /*  452 */ "having_clause_opt",
  /*  453 */ "select_item",
  /*  454 */ "partition_list",
  /*  455 */ "partition_item",
  /*  456 */ "fill_mode",
  /*  457 */ "group_by_list",
  /*  458 */ "query_expression",
  /*  459 */ "query_simple",
  /*  460 */ "order_by_clause_opt",
  /*  461 */ "slimit_clause_opt",
  /*  462 */ "limit_clause_opt",
  /*  463 */ "union_query_expression",
  /*  464 */ "query_simple_or_subquery",
  /*  465 */ "sort_specification_list",
  /*  466 */ "sort_specification",
  /*  467 */ "ordering_specification_opt",
  /*  468 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "cmd ::= COMPACT DATABASE db_name",
 /*  73 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  74 */ "not_exists_opt ::=",
 /*  75 */ "exists_opt ::= IF EXISTS",
 /*  76 */ "exists_opt ::=",
 /*  77 */ "db_options ::=",
 /*  78 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  79 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  80 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  81 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  83 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  84 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  86 */ "db_options ::= db_options KEEP integer_list",
 /*  87 */ "db_options ::= db_options KEEP variable_list",
 /*  88 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  89 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  92 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  93 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  94 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  95 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  96 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 107 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 108 */ "alter_db_options ::= alter_db_option",
 /* 109 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 110 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 111 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 112 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 114 */ "alter_db_option ::= KEEP integer_list",
 /* 115 */ "alter_db_option ::= KEEP variable_list",
 /* 116 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 117 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 118 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 119 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 120 */ "integer_list ::= NK_INTEGER",
 /* 121 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 122 */ "variable_list ::= NK_VARIABLE",
 /* 123 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 124 */ "retention_list ::= retention",
 /* 125 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 126 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 127 */ "speed_opt ::=",
 /* 128 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 129 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 130 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 131 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 132 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 133 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 134 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 135 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 136 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 137 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 138 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 139 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 140 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 141 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 142 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 143 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 144 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 145 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 146 */ "multi_create_clause ::= create_subtable_clause",
 /* 147 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 148 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 149 */ "multi_drop_clause ::= drop_table_clause",
 /* 150 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 151 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 152 */ "specific_cols_opt ::=",
 /* 153 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 154 */ "full_table_name ::= table_name",
 /* 155 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 156 */ "column_def_list ::= column_def",
 /* 157 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 158 */ "column_def ::= column_name type_name",
 /* 159 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 160 */ "type_name ::= BOOL",
 /* 161 */ "type_name ::= TINYINT",
 /* 162 */ "type_name ::= SMALLINT",
 /* 163 */ "type_name ::= INT",
 /* 164 */ "type_name ::= INTEGER",
 /* 165 */ "type_name ::= BIGINT",
 /* 166 */ "type_name ::= FLOAT",
 /* 167 */ "type_name ::= DOUBLE",
 /* 168 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 169 */ "type_name ::= TIMESTAMP",
 /* 170 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 171 */ "type_name ::= TINYINT UNSIGNED",
 /* 172 */ "type_name ::= SMALLINT UNSIGNED",
 /* 173 */ "type_name ::= INT UNSIGNED",
 /* 174 */ "type_name ::= BIGINT UNSIGNED",
 /* 175 */ "type_name ::= JSON",
 /* 176 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 177 */ "type_name ::= MEDIUMBLOB",
 /* 178 */ "type_name ::= BLOB",
 /* 179 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 180 */ "type_name ::= DECIMAL",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 182 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 183 */ "tags_def_opt ::=",
 /* 184 */ "tags_def_opt ::= tags_def",
 /* 185 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 186 */ "table_options ::=",
 /* 187 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 188 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 189 */ "table_options ::= table_options WATERMARK duration_list",
 /* 190 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 191 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 192 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 193 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 194 */ "alter_table_options ::= alter_table_option",
 /* 195 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 196 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 197 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 198 */ "duration_list ::= duration_literal",
 /* 199 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 200 */ "rollup_func_list ::= rollup_func_name",
 /* 201 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 202 */ "rollup_func_name ::= function_name",
 /* 203 */ "rollup_func_name ::= FIRST",
 /* 204 */ "rollup_func_name ::= LAST",
 /* 205 */ "col_name_list ::= col_name",
 /* 206 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 207 */ "col_name ::= column_name",
 /* 208 */ "cmd ::= SHOW DNODES",
 /* 209 */ "cmd ::= SHOW USERS",
 /* 210 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 211 */ "cmd ::= SHOW DATABASES",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 214 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 215 */ "cmd ::= SHOW MNODES",
 /* 216 */ "cmd ::= SHOW QNODES",
 /* 217 */ "cmd ::= SHOW FUNCTIONS",
 /* 218 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 219 */ "cmd ::= SHOW STREAMS",
 /* 220 */ "cmd ::= SHOW ACCOUNTS",
 /* 221 */ "cmd ::= SHOW APPS",
 /* 222 */ "cmd ::= SHOW CONNECTIONS",
 /* 223 */ "cmd ::= SHOW LICENCES",
 /* 224 */ "cmd ::= SHOW GRANTS",
 /* 225 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 226 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 227 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 228 */ "cmd ::= SHOW QUERIES",
 /* 229 */ "cmd ::= SHOW SCORES",
 /* 230 */ "cmd ::= SHOW TOPICS",
 /* 231 */ "cmd ::= SHOW VARIABLES",
 /* 232 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 233 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 234 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 235 */ "cmd ::= SHOW BNODES",
 /* 236 */ "cmd ::= SHOW SNODES",
 /* 237 */ "cmd ::= SHOW CLUSTER",
 /* 238 */ "cmd ::= SHOW TRANSACTIONS",
 /* 239 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 240 */ "cmd ::= SHOW CONSUMERS",
 /* 241 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 242 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 244 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 245 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 246 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 247 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 248 */ "db_name_cond_opt ::=",
 /* 249 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 250 */ "like_pattern_opt ::=",
 /* 251 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 252 */ "table_name_cond ::= table_name",
 /* 253 */ "from_db_opt ::=",
 /* 254 */ "from_db_opt ::= FROM db_name",
 /* 255 */ "tag_list_opt ::=",
 /* 256 */ "tag_list_opt ::= tag_item",
 /* 257 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 258 */ "tag_item ::= TBNAME",
 /* 259 */ "tag_item ::= QTAGS",
 /* 260 */ "tag_item ::= column_name",
 /* 261 */ "tag_item ::= column_name column_alias",
 /* 262 */ "tag_item ::= column_name AS column_alias",
 /* 263 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 264 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 265 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 266 */ "full_index_name ::= index_name",
 /* 267 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 268 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 269 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 270 */ "func_list ::= func",
 /* 271 */ "func_list ::= func_list NK_COMMA func",
 /* 272 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 273 */ "sma_func_name ::= function_name",
 /* 274 */ "sma_func_name ::= COUNT",
 /* 275 */ "sma_func_name ::= FIRST",
 /* 276 */ "sma_func_name ::= LAST",
 /* 277 */ "sma_func_name ::= LAST_ROW",
 /* 278 */ "sma_stream_opt ::=",
 /* 279 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 280 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 281 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 282 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 283 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 284 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 285 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 286 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 287 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 288 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 289 */ "cmd ::= DESC full_table_name",
 /* 290 */ "cmd ::= DESCRIBE full_table_name",
 /* 291 */ "cmd ::= RESET QUERY CACHE",
 /* 292 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 293 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 294 */ "analyze_opt ::=",
 /* 295 */ "analyze_opt ::= ANALYZE",
 /* 296 */ "explain_options ::=",
 /* 297 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 298 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 299 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 300 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 301 */ "agg_func_opt ::=",
 /* 302 */ "agg_func_opt ::= AGGREGATE",
 /* 303 */ "bufsize_opt ::=",
 /* 304 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 305 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 306 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 307 */ "col_list_opt ::=",
 /* 308 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 309 */ "tag_def_or_ref_opt ::=",
 /* 310 */ "tag_def_or_ref_opt ::= tags_def",
 /* 311 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 312 */ "stream_options ::=",
 /* 313 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 314 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 315 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 316 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 317 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 318 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 319 */ "subtable_opt ::=",
 /* 320 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 321 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 322 */ "cmd ::= KILL QUERY NK_STRING",
 /* 323 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 324 */ "cmd ::= BALANCE VGROUP",
 /* 325 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 326 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 327 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 328 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 329 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 330 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 331 */ "cmd ::= query_or_subquery",
 /* 332 */ "cmd ::= insert_query",
 /* 333 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 334 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 335 */ "literal ::= NK_INTEGER",
 /* 336 */ "literal ::= NK_FLOAT",
 /* 337 */ "literal ::= NK_STRING",
 /* 338 */ "literal ::= NK_BOOL",
 /* 339 */ "literal ::= TIMESTAMP NK_STRING",
 /* 340 */ "literal ::= duration_literal",
 /* 341 */ "literal ::= NULL",
 /* 342 */ "literal ::= NK_QUESTION",
 /* 343 */ "duration_literal ::= NK_VARIABLE",
 /* 344 */ "signed ::= NK_INTEGER",
 /* 345 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 346 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 347 */ "signed ::= NK_FLOAT",
 /* 348 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 349 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 350 */ "signed_literal ::= signed",
 /* 351 */ "signed_literal ::= NK_STRING",
 /* 352 */ "signed_literal ::= NK_BOOL",
 /* 353 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 354 */ "signed_literal ::= duration_literal",
 /* 355 */ "signed_literal ::= NULL",
 /* 356 */ "signed_literal ::= literal_func",
 /* 357 */ "signed_literal ::= NK_QUESTION",
 /* 358 */ "literal_list ::= signed_literal",
 /* 359 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 360 */ "db_name ::= NK_ID",
 /* 361 */ "table_name ::= NK_ID",
 /* 362 */ "column_name ::= NK_ID",
 /* 363 */ "function_name ::= NK_ID",
 /* 364 */ "table_alias ::= NK_ID",
 /* 365 */ "column_alias ::= NK_ID",
 /* 366 */ "user_name ::= NK_ID",
 /* 367 */ "topic_name ::= NK_ID",
 /* 368 */ "stream_name ::= NK_ID",
 /* 369 */ "cgroup_name ::= NK_ID",
 /* 370 */ "index_name ::= NK_ID",
 /* 371 */ "expr_or_subquery ::= expression",
 /* 372 */ "expression ::= literal",
 /* 373 */ "expression ::= pseudo_column",
 /* 374 */ "expression ::= column_reference",
 /* 375 */ "expression ::= function_expression",
 /* 376 */ "expression ::= case_when_expression",
 /* 377 */ "expression ::= NK_LP expression NK_RP",
 /* 378 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 379 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 380 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 381 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 382 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 383 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 384 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 385 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 386 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 387 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 388 */ "expression_list ::= expr_or_subquery",
 /* 389 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 390 */ "column_reference ::= column_name",
 /* 391 */ "column_reference ::= table_name NK_DOT column_name",
 /* 392 */ "pseudo_column ::= ROWTS",
 /* 393 */ "pseudo_column ::= TBNAME",
 /* 394 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 395 */ "pseudo_column ::= QSTART",
 /* 396 */ "pseudo_column ::= QEND",
 /* 397 */ "pseudo_column ::= QDURATION",
 /* 398 */ "pseudo_column ::= WSTART",
 /* 399 */ "pseudo_column ::= WEND",
 /* 400 */ "pseudo_column ::= WDURATION",
 /* 401 */ "pseudo_column ::= IROWTS",
 /* 402 */ "pseudo_column ::= ISFILLED",
 /* 403 */ "pseudo_column ::= QTAGS",
 /* 404 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 405 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 406 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 407 */ "function_expression ::= literal_func",
 /* 408 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 409 */ "literal_func ::= NOW",
 /* 410 */ "noarg_func ::= NOW",
 /* 411 */ "noarg_func ::= TODAY",
 /* 412 */ "noarg_func ::= TIMEZONE",
 /* 413 */ "noarg_func ::= DATABASE",
 /* 414 */ "noarg_func ::= CLIENT_VERSION",
 /* 415 */ "noarg_func ::= SERVER_VERSION",
 /* 416 */ "noarg_func ::= SERVER_STATUS",
 /* 417 */ "noarg_func ::= CURRENT_USER",
 /* 418 */ "noarg_func ::= USER",
 /* 419 */ "star_func ::= COUNT",
 /* 420 */ "star_func ::= FIRST",
 /* 421 */ "star_func ::= LAST",
 /* 422 */ "star_func ::= LAST_ROW",
 /* 423 */ "star_func_para_list ::= NK_STAR",
 /* 424 */ "star_func_para_list ::= other_para_list",
 /* 425 */ "other_para_list ::= star_func_para",
 /* 426 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 427 */ "star_func_para ::= expr_or_subquery",
 /* 428 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 429 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 430 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 431 */ "when_then_list ::= when_then_expr",
 /* 432 */ "when_then_list ::= when_then_list when_then_expr",
 /* 433 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 434 */ "case_when_else_opt ::=",
 /* 435 */ "case_when_else_opt ::= ELSE common_expression",
 /* 436 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 437 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 438 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 439 */ "predicate ::= expr_or_subquery IS NULL",
 /* 440 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 441 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 442 */ "compare_op ::= NK_LT",
 /* 443 */ "compare_op ::= NK_GT",
 /* 444 */ "compare_op ::= NK_LE",
 /* 445 */ "compare_op ::= NK_GE",
 /* 446 */ "compare_op ::= NK_NE",
 /* 447 */ "compare_op ::= NK_EQ",
 /* 448 */ "compare_op ::= LIKE",
 /* 449 */ "compare_op ::= NOT LIKE",
 /* 450 */ "compare_op ::= MATCH",
 /* 451 */ "compare_op ::= NMATCH",
 /* 452 */ "compare_op ::= CONTAINS",
 /* 453 */ "in_op ::= IN",
 /* 454 */ "in_op ::= NOT IN",
 /* 455 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 456 */ "boolean_value_expression ::= boolean_primary",
 /* 457 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 458 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 459 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 460 */ "boolean_primary ::= predicate",
 /* 461 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 462 */ "common_expression ::= expr_or_subquery",
 /* 463 */ "common_expression ::= boolean_value_expression",
 /* 464 */ "from_clause_opt ::=",
 /* 465 */ "from_clause_opt ::= FROM table_reference_list",
 /* 466 */ "table_reference_list ::= table_reference",
 /* 467 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 468 */ "table_reference ::= table_primary",
 /* 469 */ "table_reference ::= joined_table",
 /* 470 */ "table_primary ::= table_name alias_opt",
 /* 471 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 472 */ "table_primary ::= subquery alias_opt",
 /* 473 */ "table_primary ::= parenthesized_joined_table",
 /* 474 */ "alias_opt ::=",
 /* 475 */ "alias_opt ::= table_alias",
 /* 476 */ "alias_opt ::= AS table_alias",
 /* 477 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 478 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 479 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 480 */ "join_type ::=",
 /* 481 */ "join_type ::= INNER",
 /* 482 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 483 */ "set_quantifier_opt ::=",
 /* 484 */ "set_quantifier_opt ::= DISTINCT",
 /* 485 */ "set_quantifier_opt ::= ALL",
 /* 486 */ "select_list ::= select_item",
 /* 487 */ "select_list ::= select_list NK_COMMA select_item",
 /* 488 */ "select_item ::= NK_STAR",
 /* 489 */ "select_item ::= common_expression",
 /* 490 */ "select_item ::= common_expression column_alias",
 /* 491 */ "select_item ::= common_expression AS column_alias",
 /* 492 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 493 */ "where_clause_opt ::=",
 /* 494 */ "where_clause_opt ::= WHERE search_condition",
 /* 495 */ "partition_by_clause_opt ::=",
 /* 496 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 497 */ "partition_list ::= partition_item",
 /* 498 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 499 */ "partition_item ::= expr_or_subquery",
 /* 500 */ "partition_item ::= expr_or_subquery column_alias",
 /* 501 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 502 */ "twindow_clause_opt ::=",
 /* 503 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 504 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 505 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 506 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 507 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 508 */ "sliding_opt ::=",
 /* 509 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 510 */ "fill_opt ::=",
 /* 511 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 512 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 513 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP",
 /* 514 */ "fill_mode ::= NONE",
 /* 515 */ "fill_mode ::= PREV",
 /* 516 */ "fill_mode ::= NULL",
 /* 517 */ "fill_mode ::= NULL_F",
 /* 518 */ "fill_mode ::= LINEAR",
 /* 519 */ "fill_mode ::= NEXT",
 /* 520 */ "group_by_clause_opt ::=",
 /* 521 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 522 */ "group_by_list ::= expr_or_subquery",
 /* 523 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 524 */ "having_clause_opt ::=",
 /* 525 */ "having_clause_opt ::= HAVING search_condition",
 /* 526 */ "range_opt ::=",
 /* 527 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 528 */ "every_opt ::=",
 /* 529 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 530 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 531 */ "query_simple ::= query_specification",
 /* 532 */ "query_simple ::= union_query_expression",
 /* 533 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 534 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 535 */ "query_simple_or_subquery ::= query_simple",
 /* 536 */ "query_simple_or_subquery ::= subquery",
 /* 537 */ "query_or_subquery ::= query_expression",
 /* 538 */ "query_or_subquery ::= subquery",
 /* 539 */ "order_by_clause_opt ::=",
 /* 540 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 541 */ "slimit_clause_opt ::=",
 /* 542 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 543 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 544 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 545 */ "limit_clause_opt ::=",
 /* 546 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 547 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 548 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 549 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 550 */ "subquery ::= NK_LP subquery NK_RP",
 /* 551 */ "search_condition ::= common_expression",
 /* 552 */ "sort_specification_list ::= sort_specification",
 /* 553 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 554 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 555 */ "ordering_specification_opt ::=",
 /* 556 */ "ordering_specification_opt ::= ASC",
 /* 557 */ "ordering_specification_opt ::= DESC",
 /* 558 */ "null_ordering_opt ::=",
 /* 559 */ "null_ordering_opt ::= NULLS FIRST",
 /* 560 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 328: /* cmd */
    case 331: /* literal */
    case 344: /* db_options */
    case 346: /* alter_db_options */
    case 352: /* retention */
    case 353: /* full_table_name */
    case 356: /* table_options */
    case 360: /* alter_table_clause */
    case 361: /* alter_table_options */
    case 364: /* signed_literal */
    case 365: /* create_subtable_clause */
    case 368: /* drop_table_clause */
    case 371: /* column_def */
    case 375: /* duration_literal */
    case 376: /* rollup_func_name */
    case 378: /* col_name */
    case 379: /* db_name_cond_opt */
    case 380: /* like_pattern_opt */
    case 381: /* table_name_cond */
    case 382: /* from_db_opt */
    case 384: /* tag_item */
    case 386: /* full_index_name */
    case 387: /* index_options */
    case 390: /* sliding_opt */
    case 391: /* sma_stream_opt */
    case 392: /* func */
    case 394: /* query_or_subquery */
    case 397: /* explain_options */
    case 398: /* insert_query */
    case 402: /* stream_options */
    case 405: /* subtable_opt */
    case 406: /* expression */
    case 408: /* where_clause_opt */
    case 409: /* signed */
    case 410: /* literal_func */
    case 413: /* expr_or_subquery */
    case 414: /* pseudo_column */
    case 415: /* column_reference */
    case 416: /* function_expression */
    case 417: /* case_when_expression */
    case 422: /* star_func_para */
    case 424: /* case_when_else_opt */
    case 425: /* common_expression */
    case 426: /* when_then_expr */
    case 427: /* predicate */
    case 430: /* in_predicate_value */
    case 431: /* boolean_value_expression */
    case 432: /* boolean_primary */
    case 433: /* from_clause_opt */
    case 434: /* table_reference_list */
    case 435: /* table_reference */
    case 436: /* table_primary */
    case 437: /* joined_table */
    case 439: /* subquery */
    case 440: /* parenthesized_joined_table */
    case 442: /* search_condition */
    case 443: /* query_specification */
    case 447: /* range_opt */
    case 448: /* every_opt */
    case 449: /* fill_opt */
    case 450: /* twindow_clause_opt */
    case 452: /* having_clause_opt */
    case 453: /* select_item */
    case 455: /* partition_item */
    case 458: /* query_expression */
    case 459: /* query_simple */
    case 461: /* slimit_clause_opt */
    case 462: /* limit_clause_opt */
    case 463: /* union_query_expression */
    case 464: /* query_simple_or_subquery */
    case 466: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy42)); 
}
      break;
    case 329: /* account_options */
    case 330: /* alter_account_options */
    case 332: /* alter_account_option */
    case 347: /* speed_opt */
    case 400: /* bufsize_opt */
{
 
}
      break;
    case 333: /* user_name */
    case 336: /* priv_level */
    case 339: /* db_name */
    case 340: /* topic_name */
    case 341: /* dnode_endpoint */
    case 362: /* column_name */
    case 370: /* table_name */
    case 377: /* function_name */
    case 385: /* column_alias */
    case 388: /* index_name */
    case 393: /* sma_func_name */
    case 395: /* cgroup_name */
    case 401: /* stream_name */
    case 412: /* table_alias */
    case 418: /* star_func */
    case 420: /* noarg_func */
    case 438: /* alias_opt */
{
 
}
      break;
    case 334: /* sysinfo_opt */
{
 
}
      break;
    case 335: /* privileges */
    case 337: /* priv_type_list */
    case 338: /* priv_type */
{
 
}
      break;
    case 342: /* force_opt */
    case 343: /* not_exists_opt */
    case 345: /* exists_opt */
    case 396: /* analyze_opt */
    case 399: /* agg_func_opt */
    case 444: /* set_quantifier_opt */
{
 
}
      break;
    case 348: /* integer_list */
    case 349: /* variable_list */
    case 350: /* retention_list */
    case 354: /* column_def_list */
    case 355: /* tags_def_opt */
    case 357: /* multi_create_clause */
    case 358: /* tags_def */
    case 359: /* multi_drop_clause */
    case 366: /* specific_cols_opt */
    case 367: /* expression_list */
    case 369: /* col_name_list */
    case 372: /* duration_list */
    case 373: /* rollup_func_list */
    case 383: /* tag_list_opt */
    case 389: /* func_list */
    case 403: /* col_list_opt */
    case 404: /* tag_def_or_ref_opt */
    case 407: /* dnode_list */
    case 411: /* literal_list */
    case 419: /* star_func_para_list */
    case 421: /* other_para_list */
    case 423: /* when_then_list */
    case 445: /* select_list */
    case 446: /* partition_by_clause_opt */
    case 451: /* group_by_clause_opt */
    case 454: /* partition_list */
    case 457: /* group_by_list */
    case 460: /* order_by_clause_opt */
    case 465: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy110)); 
}
      break;
    case 351: /* alter_db_option */
    case 374: /* alter_table_option */
{
 
}
      break;
    case 363: /* type_name */
{
 
}
      break;
    case 428: /* compare_op */
    case 429: /* in_op */
{
 
}
      break;
    case 441: /* join_type */
{
 
}
      break;
    case 456: /* fill_mode */
{
 
}
      break;
    case 467: /* ordering_specification_opt */
{
 
}
      break;
    case 468: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  328,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  328,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  329,    0 }, /* (2) account_options ::= */
  {  329,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  329,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  329,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  329,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  329,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  329,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  329,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  329,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  329,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  330,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  330,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  332,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  332,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  332,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  332,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  332,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  332,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  332,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  332,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  332,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  332,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  328,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  328,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  328,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  328,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  328,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  334,    0 }, /* (29) sysinfo_opt ::= */
  {  334,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  328,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  328,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  335,   -1 }, /* (33) privileges ::= ALL */
  {  335,   -1 }, /* (34) privileges ::= priv_type_list */
  {  335,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  337,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  337,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  338,   -1 }, /* (38) priv_type ::= READ */
  {  338,   -1 }, /* (39) priv_type ::= WRITE */
  {  336,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  336,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  336,   -1 }, /* (42) priv_level ::= topic_name */
  {  328,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  328,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  328,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  328,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  328,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  328,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  328,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  328,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  341,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  341,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  341,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  342,    0 }, /* (54) force_opt ::= */
  {  342,   -1 }, /* (55) force_opt ::= FORCE */
  {  328,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  328,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  328,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  328,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  328,   -2 }, /* (68) cmd ::= USE db_name */
  {  328,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  328,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  328,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  328,   -3 }, /* (72) cmd ::= COMPACT DATABASE db_name */
  {  343,   -3 }, /* (73) not_exists_opt ::= IF NOT EXISTS */
  {  343,    0 }, /* (74) not_exists_opt ::= */
  {  345,   -2 }, /* (75) exists_opt ::= IF EXISTS */
  {  345,    0 }, /* (76) exists_opt ::= */
  {  344,    0 }, /* (77) db_options ::= */
  {  344,   -3 }, /* (78) db_options ::= db_options BUFFER NK_INTEGER */
  {  344,   -3 }, /* (79) db_options ::= db_options CACHEMODEL NK_STRING */
  {  344,   -3 }, /* (80) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  344,   -3 }, /* (81) db_options ::= db_options COMP NK_INTEGER */
  {  344,   -3 }, /* (82) db_options ::= db_options DURATION NK_INTEGER */
  {  344,   -3 }, /* (83) db_options ::= db_options DURATION NK_VARIABLE */
  {  344,   -3 }, /* (84) db_options ::= db_options MAXROWS NK_INTEGER */
  {  344,   -3 }, /* (85) db_options ::= db_options MINROWS NK_INTEGER */
  {  344,   -3 }, /* (86) db_options ::= db_options KEEP integer_list */
  {  344,   -3 }, /* (87) db_options ::= db_options KEEP variable_list */
  {  344,   -3 }, /* (88) db_options ::= db_options PAGES NK_INTEGER */
  {  344,   -3 }, /* (89) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  344,   -3 }, /* (90) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  344,   -3 }, /* (91) db_options ::= db_options PRECISION NK_STRING */
  {  344,   -3 }, /* (92) db_options ::= db_options REPLICA NK_INTEGER */
  {  344,   -3 }, /* (93) db_options ::= db_options VGROUPS NK_INTEGER */
  {  344,   -3 }, /* (94) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  344,   -3 }, /* (95) db_options ::= db_options RETENTIONS retention_list */
  {  344,   -3 }, /* (96) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  344,   -3 }, /* (97) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  344,   -3 }, /* (98) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  344,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  344,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  344,   -3 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  344,   -4 }, /* (102) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  344,   -3 }, /* (103) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  344,   -3 }, /* (104) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  344,   -3 }, /* (105) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  344,   -3 }, /* (106) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  344,   -3 }, /* (107) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  346,   -1 }, /* (108) alter_db_options ::= alter_db_option */
  {  346,   -2 }, /* (109) alter_db_options ::= alter_db_options alter_db_option */
  {  351,   -2 }, /* (110) alter_db_option ::= BUFFER NK_INTEGER */
  {  351,   -2 }, /* (111) alter_db_option ::= CACHEMODEL NK_STRING */
  {  351,   -2 }, /* (112) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  351,   -2 }, /* (113) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  351,   -2 }, /* (114) alter_db_option ::= KEEP integer_list */
  {  351,   -2 }, /* (115) alter_db_option ::= KEEP variable_list */
  {  351,   -2 }, /* (116) alter_db_option ::= PAGES NK_INTEGER */
  {  351,   -2 }, /* (117) alter_db_option ::= REPLICA NK_INTEGER */
  {  351,   -2 }, /* (118) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  351,   -2 }, /* (119) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  348,   -1 }, /* (120) integer_list ::= NK_INTEGER */
  {  348,   -3 }, /* (121) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  349,   -1 }, /* (122) variable_list ::= NK_VARIABLE */
  {  349,   -3 }, /* (123) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  350,   -1 }, /* (124) retention_list ::= retention */
  {  350,   -3 }, /* (125) retention_list ::= retention_list NK_COMMA retention */
  {  352,   -3 }, /* (126) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  347,    0 }, /* (127) speed_opt ::= */
  {  347,   -2 }, /* (128) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  328,   -9 }, /* (129) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  328,   -3 }, /* (130) cmd ::= CREATE TABLE multi_create_clause */
  {  328,   -9 }, /* (131) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  328,   -3 }, /* (132) cmd ::= DROP TABLE multi_drop_clause */
  {  328,   -4 }, /* (133) cmd ::= DROP STABLE exists_opt full_table_name */
  {  328,   -3 }, /* (134) cmd ::= ALTER TABLE alter_table_clause */
  {  328,   -3 }, /* (135) cmd ::= ALTER STABLE alter_table_clause */
  {  360,   -2 }, /* (136) alter_table_clause ::= full_table_name alter_table_options */
  {  360,   -5 }, /* (137) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  360,   -4 }, /* (138) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  360,   -5 }, /* (139) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  360,   -5 }, /* (140) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  360,   -5 }, /* (141) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  360,   -4 }, /* (142) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  360,   -5 }, /* (143) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  360,   -5 }, /* (144) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  360,   -6 }, /* (145) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  357,   -1 }, /* (146) multi_create_clause ::= create_subtable_clause */
  {  357,   -2 }, /* (147) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  365,  -10 }, /* (148) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  359,   -1 }, /* (149) multi_drop_clause ::= drop_table_clause */
  {  359,   -2 }, /* (150) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  368,   -2 }, /* (151) drop_table_clause ::= exists_opt full_table_name */
  {  366,    0 }, /* (152) specific_cols_opt ::= */
  {  366,   -3 }, /* (153) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  353,   -1 }, /* (154) full_table_name ::= table_name */
  {  353,   -3 }, /* (155) full_table_name ::= db_name NK_DOT table_name */
  {  354,   -1 }, /* (156) column_def_list ::= column_def */
  {  354,   -3 }, /* (157) column_def_list ::= column_def_list NK_COMMA column_def */
  {  371,   -2 }, /* (158) column_def ::= column_name type_name */
  {  371,   -4 }, /* (159) column_def ::= column_name type_name COMMENT NK_STRING */
  {  363,   -1 }, /* (160) type_name ::= BOOL */
  {  363,   -1 }, /* (161) type_name ::= TINYINT */
  {  363,   -1 }, /* (162) type_name ::= SMALLINT */
  {  363,   -1 }, /* (163) type_name ::= INT */
  {  363,   -1 }, /* (164) type_name ::= INTEGER */
  {  363,   -1 }, /* (165) type_name ::= BIGINT */
  {  363,   -1 }, /* (166) type_name ::= FLOAT */
  {  363,   -1 }, /* (167) type_name ::= DOUBLE */
  {  363,   -4 }, /* (168) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  363,   -1 }, /* (169) type_name ::= TIMESTAMP */
  {  363,   -4 }, /* (170) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  363,   -2 }, /* (171) type_name ::= TINYINT UNSIGNED */
  {  363,   -2 }, /* (172) type_name ::= SMALLINT UNSIGNED */
  {  363,   -2 }, /* (173) type_name ::= INT UNSIGNED */
  {  363,   -2 }, /* (174) type_name ::= BIGINT UNSIGNED */
  {  363,   -1 }, /* (175) type_name ::= JSON */
  {  363,   -4 }, /* (176) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  363,   -1 }, /* (177) type_name ::= MEDIUMBLOB */
  {  363,   -1 }, /* (178) type_name ::= BLOB */
  {  363,   -4 }, /* (179) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  363,   -1 }, /* (180) type_name ::= DECIMAL */
  {  363,   -4 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  363,   -6 }, /* (182) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  355,    0 }, /* (183) tags_def_opt ::= */
  {  355,   -1 }, /* (184) tags_def_opt ::= tags_def */
  {  358,   -4 }, /* (185) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  356,    0 }, /* (186) table_options ::= */
  {  356,   -3 }, /* (187) table_options ::= table_options COMMENT NK_STRING */
  {  356,   -3 }, /* (188) table_options ::= table_options MAX_DELAY duration_list */
  {  356,   -3 }, /* (189) table_options ::= table_options WATERMARK duration_list */
  {  356,   -5 }, /* (190) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  356,   -3 }, /* (191) table_options ::= table_options TTL NK_INTEGER */
  {  356,   -5 }, /* (192) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  356,   -3 }, /* (193) table_options ::= table_options DELETE_MARK duration_list */
  {  361,   -1 }, /* (194) alter_table_options ::= alter_table_option */
  {  361,   -2 }, /* (195) alter_table_options ::= alter_table_options alter_table_option */
  {  374,   -2 }, /* (196) alter_table_option ::= COMMENT NK_STRING */
  {  374,   -2 }, /* (197) alter_table_option ::= TTL NK_INTEGER */
  {  372,   -1 }, /* (198) duration_list ::= duration_literal */
  {  372,   -3 }, /* (199) duration_list ::= duration_list NK_COMMA duration_literal */
  {  373,   -1 }, /* (200) rollup_func_list ::= rollup_func_name */
  {  373,   -3 }, /* (201) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  376,   -1 }, /* (202) rollup_func_name ::= function_name */
  {  376,   -1 }, /* (203) rollup_func_name ::= FIRST */
  {  376,   -1 }, /* (204) rollup_func_name ::= LAST */
  {  369,   -1 }, /* (205) col_name_list ::= col_name */
  {  369,   -3 }, /* (206) col_name_list ::= col_name_list NK_COMMA col_name */
  {  378,   -1 }, /* (207) col_name ::= column_name */
  {  328,   -2 }, /* (208) cmd ::= SHOW DNODES */
  {  328,   -2 }, /* (209) cmd ::= SHOW USERS */
  {  328,   -3 }, /* (210) cmd ::= SHOW USER PRIVILEGES */
  {  328,   -2 }, /* (211) cmd ::= SHOW DATABASES */
  {  328,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  328,   -4 }, /* (213) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  328,   -3 }, /* (214) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  328,   -2 }, /* (215) cmd ::= SHOW MNODES */
  {  328,   -2 }, /* (216) cmd ::= SHOW QNODES */
  {  328,   -2 }, /* (217) cmd ::= SHOW FUNCTIONS */
  {  328,   -5 }, /* (218) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  328,   -2 }, /* (219) cmd ::= SHOW STREAMS */
  {  328,   -2 }, /* (220) cmd ::= SHOW ACCOUNTS */
  {  328,   -2 }, /* (221) cmd ::= SHOW APPS */
  {  328,   -2 }, /* (222) cmd ::= SHOW CONNECTIONS */
  {  328,   -2 }, /* (223) cmd ::= SHOW LICENCES */
  {  328,   -2 }, /* (224) cmd ::= SHOW GRANTS */
  {  328,   -4 }, /* (225) cmd ::= SHOW CREATE DATABASE db_name */
  {  328,   -4 }, /* (226) cmd ::= SHOW CREATE TABLE full_table_name */
  {  328,   -4 }, /* (227) cmd ::= SHOW CREATE STABLE full_table_name */
  {  328,   -2 }, /* (228) cmd ::= SHOW QUERIES */
  {  328,   -2 }, /* (229) cmd ::= SHOW SCORES */
  {  328,   -2 }, /* (230) cmd ::= SHOW TOPICS */
  {  328,   -2 }, /* (231) cmd ::= SHOW VARIABLES */
  {  328,   -3 }, /* (232) cmd ::= SHOW CLUSTER VARIABLES */
  {  328,   -3 }, /* (233) cmd ::= SHOW LOCAL VARIABLES */
  {  328,   -5 }, /* (234) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  328,   -2 }, /* (235) cmd ::= SHOW BNODES */
  {  328,   -2 }, /* (236) cmd ::= SHOW SNODES */
  {  328,   -2 }, /* (237) cmd ::= SHOW CLUSTER */
  {  328,   -2 }, /* (238) cmd ::= SHOW TRANSACTIONS */
  {  328,   -4 }, /* (239) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  328,   -2 }, /* (240) cmd ::= SHOW CONSUMERS */
  {  328,   -2 }, /* (241) cmd ::= SHOW SUBSCRIPTIONS */
  {  328,   -5 }, /* (242) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  328,   -7 }, /* (243) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  328,   -3 }, /* (244) cmd ::= SHOW VNODES NK_INTEGER */
  {  328,   -3 }, /* (245) cmd ::= SHOW VNODES NK_STRING */
  {  328,   -3 }, /* (246) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  328,   -3 }, /* (247) cmd ::= SHOW CLUSTER ALIVE */
  {  379,    0 }, /* (248) db_name_cond_opt ::= */
  {  379,   -2 }, /* (249) db_name_cond_opt ::= db_name NK_DOT */
  {  380,    0 }, /* (250) like_pattern_opt ::= */
  {  380,   -2 }, /* (251) like_pattern_opt ::= LIKE NK_STRING */
  {  381,   -1 }, /* (252) table_name_cond ::= table_name */
  {  382,    0 }, /* (253) from_db_opt ::= */
  {  382,   -2 }, /* (254) from_db_opt ::= FROM db_name */
  {  383,    0 }, /* (255) tag_list_opt ::= */
  {  383,   -1 }, /* (256) tag_list_opt ::= tag_item */
  {  383,   -3 }, /* (257) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  384,   -1 }, /* (258) tag_item ::= TBNAME */
  {  384,   -1 }, /* (259) tag_item ::= QTAGS */
  {  384,   -1 }, /* (260) tag_item ::= column_name */
  {  384,   -2 }, /* (261) tag_item ::= column_name column_alias */
  {  384,   -3 }, /* (262) tag_item ::= column_name AS column_alias */
  {  328,   -8 }, /* (263) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  328,   -9 }, /* (264) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  328,   -4 }, /* (265) cmd ::= DROP INDEX exists_opt full_index_name */
  {  386,   -1 }, /* (266) full_index_name ::= index_name */
  {  386,   -3 }, /* (267) full_index_name ::= db_name NK_DOT index_name */
  {  387,  -10 }, /* (268) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  387,  -12 }, /* (269) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  389,   -1 }, /* (270) func_list ::= func */
  {  389,   -3 }, /* (271) func_list ::= func_list NK_COMMA func */
  {  392,   -4 }, /* (272) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  393,   -1 }, /* (273) sma_func_name ::= function_name */
  {  393,   -1 }, /* (274) sma_func_name ::= COUNT */
  {  393,   -1 }, /* (275) sma_func_name ::= FIRST */
  {  393,   -1 }, /* (276) sma_func_name ::= LAST */
  {  393,   -1 }, /* (277) sma_func_name ::= LAST_ROW */
  {  391,    0 }, /* (278) sma_stream_opt ::= */
  {  391,   -3 }, /* (279) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  391,   -3 }, /* (280) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  391,   -3 }, /* (281) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  328,   -6 }, /* (282) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  328,   -7 }, /* (283) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  328,   -9 }, /* (284) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  328,   -7 }, /* (285) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  328,   -9 }, /* (286) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  328,   -4 }, /* (287) cmd ::= DROP TOPIC exists_opt topic_name */
  {  328,   -7 }, /* (288) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  328,   -2 }, /* (289) cmd ::= DESC full_table_name */
  {  328,   -2 }, /* (290) cmd ::= DESCRIBE full_table_name */
  {  328,   -3 }, /* (291) cmd ::= RESET QUERY CACHE */
  {  328,   -4 }, /* (292) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  328,   -4 }, /* (293) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
  {  396,    0 }, /* (294) analyze_opt ::= */
  {  396,   -1 }, /* (295) analyze_opt ::= ANALYZE */
  {  397,    0 }, /* (296) explain_options ::= */
  {  397,   -3 }, /* (297) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  397,   -3 }, /* (298) explain_options ::= explain_options RATIO NK_FLOAT */
  {  328,  -10 }, /* (299) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  328,   -4 }, /* (300) cmd ::= DROP FUNCTION exists_opt function_name */
  {  399,    0 }, /* (301) agg_func_opt ::= */
  {  399,   -1 }, /* (302) agg_func_opt ::= AGGREGATE */
  {  400,    0 }, /* (303) bufsize_opt ::= */
  {  400,   -2 }, /* (304) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  328,  -12 }, /* (305) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  328,   -4 }, /* (306) cmd ::= DROP STREAM exists_opt stream_name */
  {  403,    0 }, /* (307) col_list_opt ::= */
  {  403,   -3 }, /* (308) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  404,    0 }, /* (309) tag_def_or_ref_opt ::= */
  {  404,   -1 }, /* (310) tag_def_or_ref_opt ::= tags_def */
  {  404,   -4 }, /* (311) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  402,    0 }, /* (312) stream_options ::= */
  {  402,   -3 }, /* (313) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  402,   -3 }, /* (314) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  402,   -4 }, /* (315) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  402,   -3 }, /* (316) stream_options ::= stream_options WATERMARK duration_literal */
  {  402,   -4 }, /* (317) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  402,   -3 }, /* (318) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  405,    0 }, /* (319) subtable_opt ::= */
  {  405,   -4 }, /* (320) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  328,   -3 }, /* (321) cmd ::= KILL CONNECTION NK_INTEGER */
  {  328,   -3 }, /* (322) cmd ::= KILL QUERY NK_STRING */
  {  328,   -3 }, /* (323) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  328,   -2 }, /* (324) cmd ::= BALANCE VGROUP */
  {  328,   -4 }, /* (325) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  328,   -4 }, /* (326) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  328,   -3 }, /* (327) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  407,   -2 }, /* (328) dnode_list ::= DNODE NK_INTEGER */
  {  407,   -3 }, /* (329) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  328,   -4 }, /* (330) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  328,   -1 }, /* (331) cmd ::= query_or_subquery */
  {  328,   -1 }, /* (332) cmd ::= insert_query */
  {  398,   -7 }, /* (333) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  398,   -4 }, /* (334) insert_query ::= INSERT INTO full_table_name query_or_subquery */
  {  331,   -1 }, /* (335) literal ::= NK_INTEGER */
  {  331,   -1 }, /* (336) literal ::= NK_FLOAT */
  {  331,   -1 }, /* (337) literal ::= NK_STRING */
  {  331,   -1 }, /* (338) literal ::= NK_BOOL */
  {  331,   -2 }, /* (339) literal ::= TIMESTAMP NK_STRING */
  {  331,   -1 }, /* (340) literal ::= duration_literal */
  {  331,   -1 }, /* (341) literal ::= NULL */
  {  331,   -1 }, /* (342) literal ::= NK_QUESTION */
  {  375,   -1 }, /* (343) duration_literal ::= NK_VARIABLE */
  {  409,   -1 }, /* (344) signed ::= NK_INTEGER */
  {  409,   -2 }, /* (345) signed ::= NK_PLUS NK_INTEGER */
  {  409,   -2 }, /* (346) signed ::= NK_MINUS NK_INTEGER */
  {  409,   -1 }, /* (347) signed ::= NK_FLOAT */
  {  409,   -2 }, /* (348) signed ::= NK_PLUS NK_FLOAT */
  {  409,   -2 }, /* (349) signed ::= NK_MINUS NK_FLOAT */
  {  364,   -1 }, /* (350) signed_literal ::= signed */
  {  364,   -1 }, /* (351) signed_literal ::= NK_STRING */
  {  364,   -1 }, /* (352) signed_literal ::= NK_BOOL */
  {  364,   -2 }, /* (353) signed_literal ::= TIMESTAMP NK_STRING */
  {  364,   -1 }, /* (354) signed_literal ::= duration_literal */
  {  364,   -1 }, /* (355) signed_literal ::= NULL */
  {  364,   -1 }, /* (356) signed_literal ::= literal_func */
  {  364,   -1 }, /* (357) signed_literal ::= NK_QUESTION */
  {  411,   -1 }, /* (358) literal_list ::= signed_literal */
  {  411,   -3 }, /* (359) literal_list ::= literal_list NK_COMMA signed_literal */
  {  339,   -1 }, /* (360) db_name ::= NK_ID */
  {  370,   -1 }, /* (361) table_name ::= NK_ID */
  {  362,   -1 }, /* (362) column_name ::= NK_ID */
  {  377,   -1 }, /* (363) function_name ::= NK_ID */
  {  412,   -1 }, /* (364) table_alias ::= NK_ID */
  {  385,   -1 }, /* (365) column_alias ::= NK_ID */
  {  333,   -1 }, /* (366) user_name ::= NK_ID */
  {  340,   -1 }, /* (367) topic_name ::= NK_ID */
  {  401,   -1 }, /* (368) stream_name ::= NK_ID */
  {  395,   -1 }, /* (369) cgroup_name ::= NK_ID */
  {  388,   -1 }, /* (370) index_name ::= NK_ID */
  {  413,   -1 }, /* (371) expr_or_subquery ::= expression */
  {  406,   -1 }, /* (372) expression ::= literal */
  {  406,   -1 }, /* (373) expression ::= pseudo_column */
  {  406,   -1 }, /* (374) expression ::= column_reference */
  {  406,   -1 }, /* (375) expression ::= function_expression */
  {  406,   -1 }, /* (376) expression ::= case_when_expression */
  {  406,   -3 }, /* (377) expression ::= NK_LP expression NK_RP */
  {  406,   -2 }, /* (378) expression ::= NK_PLUS expr_or_subquery */
  {  406,   -2 }, /* (379) expression ::= NK_MINUS expr_or_subquery */
  {  406,   -3 }, /* (380) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  406,   -3 }, /* (381) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  406,   -3 }, /* (382) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  406,   -3 }, /* (383) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  406,   -3 }, /* (384) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  406,   -3 }, /* (385) expression ::= column_reference NK_ARROW NK_STRING */
  {  406,   -3 }, /* (386) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  406,   -3 }, /* (387) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  367,   -1 }, /* (388) expression_list ::= expr_or_subquery */
  {  367,   -3 }, /* (389) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  415,   -1 }, /* (390) column_reference ::= column_name */
  {  415,   -3 }, /* (391) column_reference ::= table_name NK_DOT column_name */
  {  414,   -1 }, /* (392) pseudo_column ::= ROWTS */
  {  414,   -1 }, /* (393) pseudo_column ::= TBNAME */
  {  414,   -3 }, /* (394) pseudo_column ::= table_name NK_DOT TBNAME */
  {  414,   -1 }, /* (395) pseudo_column ::= QSTART */
  {  414,   -1 }, /* (396) pseudo_column ::= QEND */
  {  414,   -1 }, /* (397) pseudo_column ::= QDURATION */
  {  414,   -1 }, /* (398) pseudo_column ::= WSTART */
  {  414,   -1 }, /* (399) pseudo_column ::= WEND */
  {  414,   -1 }, /* (400) pseudo_column ::= WDURATION */
  {  414,   -1 }, /* (401) pseudo_column ::= IROWTS */
  {  414,   -1 }, /* (402) pseudo_column ::= ISFILLED */
  {  414,   -1 }, /* (403) pseudo_column ::= QTAGS */
  {  416,   -4 }, /* (404) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  416,   -4 }, /* (405) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  416,   -6 }, /* (406) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  416,   -1 }, /* (407) function_expression ::= literal_func */
  {  410,   -3 }, /* (408) literal_func ::= noarg_func NK_LP NK_RP */
  {  410,   -1 }, /* (409) literal_func ::= NOW */
  {  420,   -1 }, /* (410) noarg_func ::= NOW */
  {  420,   -1 }, /* (411) noarg_func ::= TODAY */
  {  420,   -1 }, /* (412) noarg_func ::= TIMEZONE */
  {  420,   -1 }, /* (413) noarg_func ::= DATABASE */
  {  420,   -1 }, /* (414) noarg_func ::= CLIENT_VERSION */
  {  420,   -1 }, /* (415) noarg_func ::= SERVER_VERSION */
  {  420,   -1 }, /* (416) noarg_func ::= SERVER_STATUS */
  {  420,   -1 }, /* (417) noarg_func ::= CURRENT_USER */
  {  420,   -1 }, /* (418) noarg_func ::= USER */
  {  418,   -1 }, /* (419) star_func ::= COUNT */
  {  418,   -1 }, /* (420) star_func ::= FIRST */
  {  418,   -1 }, /* (421) star_func ::= LAST */
  {  418,   -1 }, /* (422) star_func ::= LAST_ROW */
  {  419,   -1 }, /* (423) star_func_para_list ::= NK_STAR */
  {  419,   -1 }, /* (424) star_func_para_list ::= other_para_list */
  {  421,   -1 }, /* (425) other_para_list ::= star_func_para */
  {  421,   -3 }, /* (426) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  422,   -1 }, /* (427) star_func_para ::= expr_or_subquery */
  {  422,   -3 }, /* (428) star_func_para ::= table_name NK_DOT NK_STAR */
  {  417,   -4 }, /* (429) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  417,   -5 }, /* (430) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  423,   -1 }, /* (431) when_then_list ::= when_then_expr */
  {  423,   -2 }, /* (432) when_then_list ::= when_then_list when_then_expr */
  {  426,   -4 }, /* (433) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  424,    0 }, /* (434) case_when_else_opt ::= */
  {  424,   -2 }, /* (435) case_when_else_opt ::= ELSE common_expression */
  {  427,   -3 }, /* (436) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  427,   -5 }, /* (437) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  427,   -6 }, /* (438) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  427,   -3 }, /* (439) predicate ::= expr_or_subquery IS NULL */
  {  427,   -4 }, /* (440) predicate ::= expr_or_subquery IS NOT NULL */
  {  427,   -3 }, /* (441) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  428,   -1 }, /* (442) compare_op ::= NK_LT */
  {  428,   -1 }, /* (443) compare_op ::= NK_GT */
  {  428,   -1 }, /* (444) compare_op ::= NK_LE */
  {  428,   -1 }, /* (445) compare_op ::= NK_GE */
  {  428,   -1 }, /* (446) compare_op ::= NK_NE */
  {  428,   -1 }, /* (447) compare_op ::= NK_EQ */
  {  428,   -1 }, /* (448) compare_op ::= LIKE */
  {  428,   -2 }, /* (449) compare_op ::= NOT LIKE */
  {  428,   -1 }, /* (450) compare_op ::= MATCH */
  {  428,   -1 }, /* (451) compare_op ::= NMATCH */
  {  428,   -1 }, /* (452) compare_op ::= CONTAINS */
  {  429,   -1 }, /* (453) in_op ::= IN */
  {  429,   -2 }, /* (454) in_op ::= NOT IN */
  {  430,   -3 }, /* (455) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  431,   -1 }, /* (456) boolean_value_expression ::= boolean_primary */
  {  431,   -2 }, /* (457) boolean_value_expression ::= NOT boolean_primary */
  {  431,   -3 }, /* (458) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  431,   -3 }, /* (459) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  432,   -1 }, /* (460) boolean_primary ::= predicate */
  {  432,   -3 }, /* (461) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  425,   -1 }, /* (462) common_expression ::= expr_or_subquery */
  {  425,   -1 }, /* (463) common_expression ::= boolean_value_expression */
  {  433,    0 }, /* (464) from_clause_opt ::= */
  {  433,   -2 }, /* (465) from_clause_opt ::= FROM table_reference_list */
  {  434,   -1 }, /* (466) table_reference_list ::= table_reference */
  {  434,   -3 }, /* (467) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  435,   -1 }, /* (468) table_reference ::= table_primary */
  {  435,   -1 }, /* (469) table_reference ::= joined_table */
  {  436,   -2 }, /* (470) table_primary ::= table_name alias_opt */
  {  436,   -4 }, /* (471) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  436,   -2 }, /* (472) table_primary ::= subquery alias_opt */
  {  436,   -1 }, /* (473) table_primary ::= parenthesized_joined_table */
  {  438,    0 }, /* (474) alias_opt ::= */
  {  438,   -1 }, /* (475) alias_opt ::= table_alias */
  {  438,   -2 }, /* (476) alias_opt ::= AS table_alias */
  {  440,   -3 }, /* (477) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  440,   -3 }, /* (478) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  437,   -6 }, /* (479) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  441,    0 }, /* (480) join_type ::= */
  {  441,   -1 }, /* (481) join_type ::= INNER */
  {  443,  -12 }, /* (482) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  444,    0 }, /* (483) set_quantifier_opt ::= */
  {  444,   -1 }, /* (484) set_quantifier_opt ::= DISTINCT */
  {  444,   -1 }, /* (485) set_quantifier_opt ::= ALL */
  {  445,   -1 }, /* (486) select_list ::= select_item */
  {  445,   -3 }, /* (487) select_list ::= select_list NK_COMMA select_item */
  {  453,   -1 }, /* (488) select_item ::= NK_STAR */
  {  453,   -1 }, /* (489) select_item ::= common_expression */
  {  453,   -2 }, /* (490) select_item ::= common_expression column_alias */
  {  453,   -3 }, /* (491) select_item ::= common_expression AS column_alias */
  {  453,   -3 }, /* (492) select_item ::= table_name NK_DOT NK_STAR */
  {  408,    0 }, /* (493) where_clause_opt ::= */
  {  408,   -2 }, /* (494) where_clause_opt ::= WHERE search_condition */
  {  446,    0 }, /* (495) partition_by_clause_opt ::= */
  {  446,   -3 }, /* (496) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  454,   -1 }, /* (497) partition_list ::= partition_item */
  {  454,   -3 }, /* (498) partition_list ::= partition_list NK_COMMA partition_item */
  {  455,   -1 }, /* (499) partition_item ::= expr_or_subquery */
  {  455,   -2 }, /* (500) partition_item ::= expr_or_subquery column_alias */
  {  455,   -3 }, /* (501) partition_item ::= expr_or_subquery AS column_alias */
  {  450,    0 }, /* (502) twindow_clause_opt ::= */
  {  450,   -6 }, /* (503) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  450,   -4 }, /* (504) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  450,   -6 }, /* (505) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  450,   -8 }, /* (506) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  450,   -7 }, /* (507) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  390,    0 }, /* (508) sliding_opt ::= */
  {  390,   -4 }, /* (509) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  449,    0 }, /* (510) fill_opt ::= */
  {  449,   -4 }, /* (511) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  449,   -6 }, /* (512) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  449,   -6 }, /* (513) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
  {  456,   -1 }, /* (514) fill_mode ::= NONE */
  {  456,   -1 }, /* (515) fill_mode ::= PREV */
  {  456,   -1 }, /* (516) fill_mode ::= NULL */
  {  456,   -1 }, /* (517) fill_mode ::= NULL_F */
  {  456,   -1 }, /* (518) fill_mode ::= LINEAR */
  {  456,   -1 }, /* (519) fill_mode ::= NEXT */
  {  451,    0 }, /* (520) group_by_clause_opt ::= */
  {  451,   -3 }, /* (521) group_by_clause_opt ::= GROUP BY group_by_list */
  {  457,   -1 }, /* (522) group_by_list ::= expr_or_subquery */
  {  457,   -3 }, /* (523) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  452,    0 }, /* (524) having_clause_opt ::= */
  {  452,   -2 }, /* (525) having_clause_opt ::= HAVING search_condition */
  {  447,    0 }, /* (526) range_opt ::= */
  {  447,   -6 }, /* (527) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  448,    0 }, /* (528) every_opt ::= */
  {  448,   -4 }, /* (529) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  458,   -4 }, /* (530) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  459,   -1 }, /* (531) query_simple ::= query_specification */
  {  459,   -1 }, /* (532) query_simple ::= union_query_expression */
  {  463,   -4 }, /* (533) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  463,   -3 }, /* (534) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  464,   -1 }, /* (535) query_simple_or_subquery ::= query_simple */
  {  464,   -1 }, /* (536) query_simple_or_subquery ::= subquery */
  {  394,   -1 }, /* (537) query_or_subquery ::= query_expression */
  {  394,   -1 }, /* (538) query_or_subquery ::= subquery */
  {  460,    0 }, /* (539) order_by_clause_opt ::= */
  {  460,   -3 }, /* (540) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  461,    0 }, /* (541) slimit_clause_opt ::= */
  {  461,   -2 }, /* (542) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  461,   -4 }, /* (543) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  461,   -4 }, /* (544) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  462,    0 }, /* (545) limit_clause_opt ::= */
  {  462,   -2 }, /* (546) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  462,   -4 }, /* (547) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  462,   -4 }, /* (548) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  439,   -3 }, /* (549) subquery ::= NK_LP query_expression NK_RP */
  {  439,   -3 }, /* (550) subquery ::= NK_LP subquery NK_RP */
  {  442,   -1 }, /* (551) search_condition ::= common_expression */
  {  465,   -1 }, /* (552) sort_specification_list ::= sort_specification */
  {  465,   -3 }, /* (553) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  466,   -3 }, /* (554) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  467,    0 }, /* (555) ordering_specification_opt ::= */
  {  467,   -1 }, /* (556) ordering_specification_opt ::= ASC */
  {  467,   -1 }, /* (557) ordering_specification_opt ::= DESC */
  {  468,    0 }, /* (558) null_ordering_opt ::= */
  {  468,   -2 }, /* (559) null_ordering_opt ::= NULLS FIRST */
  {  468,   -2 }, /* (560) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,329,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,330,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,329,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,331,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,332,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,330,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,332,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,331,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy225, &yymsp[-1].minor.yy0, yymsp[0].minor.yy705); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy225, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy225, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy225, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy705 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy705 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy641, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy641, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy641 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy641 = yymsp[0].minor.yy641; }
  yymsp[0].minor.yy641 = yylhsminor.yy641;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy641 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy641 = yymsp[-2].minor.yy641 | yymsp[0].minor.yy641; }
  yymsp[-2].minor.yy641 = yylhsminor.yy641;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy641 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy641 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy225 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy225 = yylhsminor.yy225;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy225 = yymsp[-2].minor.yy225; }
  yymsp[-2].minor.yy225 = yylhsminor.yy225;
        break;
      case 42: /* priv_level ::= topic_name */
      case 273: /* sma_func_name ::= function_name */ yytestcase(yyruleno==273);
      case 475: /* alias_opt ::= table_alias */ yytestcase(yyruleno==475);
{ yylhsminor.yy225 = yymsp[0].minor.yy225; }
  yymsp[0].minor.yy225 = yylhsminor.yy225;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy225, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy103); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy225, yymsp[0].minor.yy103); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 274: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==274);
      case 275: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==275);
      case 276: /* sma_func_name ::= LAST */ yytestcase(yyruleno==276);
      case 277: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==277);
      case 360: /* db_name ::= NK_ID */ yytestcase(yyruleno==360);
      case 361: /* table_name ::= NK_ID */ yytestcase(yyruleno==361);
      case 362: /* column_name ::= NK_ID */ yytestcase(yyruleno==362);
      case 363: /* function_name ::= NK_ID */ yytestcase(yyruleno==363);
      case 364: /* table_alias ::= NK_ID */ yytestcase(yyruleno==364);
      case 365: /* column_alias ::= NK_ID */ yytestcase(yyruleno==365);
      case 366: /* user_name ::= NK_ID */ yytestcase(yyruleno==366);
      case 367: /* topic_name ::= NK_ID */ yytestcase(yyruleno==367);
      case 368: /* stream_name ::= NK_ID */ yytestcase(yyruleno==368);
      case 369: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==369);
      case 370: /* index_name ::= NK_ID */ yytestcase(yyruleno==370);
      case 410: /* noarg_func ::= NOW */ yytestcase(yyruleno==410);
      case 411: /* noarg_func ::= TODAY */ yytestcase(yyruleno==411);
      case 412: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==412);
      case 413: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==413);
      case 414: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==414);
      case 415: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==415);
      case 416: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==416);
      case 417: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==417);
      case 418: /* noarg_func ::= USER */ yytestcase(yyruleno==418);
      case 419: /* star_func ::= COUNT */ yytestcase(yyruleno==419);
      case 420: /* star_func ::= FIRST */ yytestcase(yyruleno==420);
      case 421: /* star_func ::= LAST */ yytestcase(yyruleno==421);
      case 422: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==422);
{ yylhsminor.yy225 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy225 = yylhsminor.yy225;
        break;
      case 54: /* force_opt ::= */
      case 74: /* not_exists_opt ::= */ yytestcase(yyruleno==74);
      case 76: /* exists_opt ::= */ yytestcase(yyruleno==76);
      case 294: /* analyze_opt ::= */ yytestcase(yyruleno==294);
      case 301: /* agg_func_opt ::= */ yytestcase(yyruleno==301);
      case 483: /* set_quantifier_opt ::= */ yytestcase(yyruleno==483);
{ yymsp[1].minor.yy103 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 295: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==295);
      case 302: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==302);
      case 484: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==484);
{ yymsp[0].minor.yy103 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy103, &yymsp[-1].minor.yy225, yymsp[0].minor.yy42); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy103, &yymsp[0].minor.yy225); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy225, yymsp[0].minor.yy42); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy225, yymsp[0].minor.yy508); }
        break;
      case 72: /* cmd ::= COMPACT DATABASE db_name */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 73: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy103 = true; }
        break;
      case 75: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy103 = true; }
        break;
      case 77: /* db_options ::= */
{ yymsp[1].minor.yy42 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 78: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 79: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 80: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 81: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 82: /* db_options ::= db_options DURATION NK_INTEGER */
      case 83: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==83);
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 84: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 85: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 86: /* db_options ::= db_options KEEP integer_list */
      case 87: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==87);
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_KEEP, yymsp[0].minor.yy110); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 88: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 89: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 90: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 91: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 92: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 93: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 94: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 95: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_RETENTIONS, yymsp[0].minor.yy110); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 96: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 97: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 98: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-3].minor.yy42, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-3].minor.yy42, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 103: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 104: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 105: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 106: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 107: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 108: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy42 = createAlterDatabaseOptions(pCxt); yylhsminor.yy42 = setAlterDatabaseOption(pCxt, yylhsminor.yy42, &yymsp[0].minor.yy459); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 109: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy42 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy42, &yymsp[0].minor.yy459); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 110: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy459.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= KEEP integer_list */
      case 115: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==115);
{ yymsp[-1].minor.yy459.type = DB_OPTION_KEEP; yymsp[-1].minor.yy459.pList = yymsp[0].minor.yy110; }
        break;
      case 116: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_PAGES; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_WAL; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy110 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 121: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 329: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==329);
{ yylhsminor.yy110 = addNodeToList(pCxt, yymsp[-2].minor.yy110, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy110 = yylhsminor.yy110;
        break;
      case 122: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy110 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 123: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy110 = addNodeToList(pCxt, yymsp[-2].minor.yy110, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy110 = yylhsminor.yy110;
        break;
      case 124: /* retention_list ::= retention */
      case 146: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==146);
      case 149: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==149);
      case 156: /* column_def_list ::= column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name */ yytestcase(yyruleno==205);
      case 256: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==256);
      case 270: /* func_list ::= func */ yytestcase(yyruleno==270);
      case 358: /* literal_list ::= signed_literal */ yytestcase(yyruleno==358);
      case 425: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==425);
      case 431: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==431);
      case 486: /* select_list ::= select_item */ yytestcase(yyruleno==486);
      case 497: /* partition_list ::= partition_item */ yytestcase(yyruleno==497);
      case 552: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==552);
{ yylhsminor.yy110 = createNodeList(pCxt, yymsp[0].minor.yy42); }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 125: /* retention_list ::= retention_list NK_COMMA retention */
      case 157: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==157);
      case 201: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==201);
      case 206: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==206);
      case 257: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==257);
      case 271: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==271);
      case 359: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==359);
      case 426: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==426);
      case 487: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==487);
      case 498: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==498);
      case 553: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==553);
{ yylhsminor.yy110 = addNodeToList(pCxt, yymsp[-2].minor.yy110, yymsp[0].minor.yy42); }
  yymsp[-2].minor.yy110 = yylhsminor.yy110;
        break;
      case 126: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy42 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 127: /* speed_opt ::= */
      case 303: /* bufsize_opt ::= */ yytestcase(yyruleno==303);
{ yymsp[1].minor.yy508 = 0; }
        break;
      case 128: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 304: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==304);
{ yymsp[-1].minor.yy508 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 129: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 131: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==131);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy103, yymsp[-5].minor.yy42, yymsp[-3].minor.yy110, yymsp[-1].minor.yy110, yymsp[0].minor.yy42); }
        break;
      case 130: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy110); }
        break;
      case 132: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy110); }
        break;
      case 133: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy103, yymsp[0].minor.yy42); }
        break;
      case 134: /* cmd ::= ALTER TABLE alter_table_clause */
      case 331: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==331);
      case 332: /* cmd ::= insert_query */ yytestcase(yyruleno==332);
{ pCxt->pRootNode = yymsp[0].minor.yy42; }
        break;
      case 135: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy42); }
        break;
      case 136: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy42 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 137: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy42 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 138: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy42 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy42, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy225); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 139: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy42 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 140: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy42 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 141: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy42 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 142: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy42 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy42, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy225); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 143: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy42 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 144: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy42 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 145: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy42 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy42, &yymsp[-2].minor.yy225, yymsp[0].minor.yy42); }
  yymsp[-5].minor.yy42 = yylhsminor.yy42;
        break;
      case 147: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 150: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==150);
      case 432: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==432);
{ yylhsminor.yy110 = addNodeToList(pCxt, yymsp[-1].minor.yy110, yymsp[0].minor.yy42); }
  yymsp[-1].minor.yy110 = yylhsminor.yy110;
        break;
      case 148: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy42 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy103, yymsp[-8].minor.yy42, yymsp[-6].minor.yy42, yymsp[-5].minor.yy110, yymsp[-2].minor.yy110, yymsp[0].minor.yy42); }
  yymsp[-9].minor.yy42 = yylhsminor.yy42;
        break;
      case 151: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy42 = createDropTableClause(pCxt, yymsp[-1].minor.yy103, yymsp[0].minor.yy42); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 152: /* specific_cols_opt ::= */
      case 183: /* tags_def_opt ::= */ yytestcase(yyruleno==183);
      case 255: /* tag_list_opt ::= */ yytestcase(yyruleno==255);
      case 307: /* col_list_opt ::= */ yytestcase(yyruleno==307);
      case 309: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==309);
      case 495: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==495);
      case 520: /* group_by_clause_opt ::= */ yytestcase(yyruleno==520);
      case 539: /* order_by_clause_opt ::= */ yytestcase(yyruleno==539);
{ yymsp[1].minor.yy110 = NULL; }
        break;
      case 153: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 308: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==308);
{ yymsp[-2].minor.yy110 = yymsp[-1].minor.yy110; }
        break;
      case 154: /* full_table_name ::= table_name */
{ yylhsminor.yy42 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy225, NULL); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 155: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy42 = createRealTableNode(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225, NULL); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 158: /* column_def ::= column_name type_name */
{ yylhsminor.yy42 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448, NULL); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 159: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy42 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy225, yymsp[-2].minor.yy448, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 160: /* type_name ::= BOOL */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 161: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 162: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 163: /* type_name ::= INT */
      case 164: /* type_name ::= INTEGER */ yytestcase(yyruleno==164);
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 165: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 166: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 167: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 168: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 169: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 170: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 171: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 172: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 173: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 174: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 175: /* type_name ::= JSON */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 176: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 177: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 178: /* type_name ::= BLOB */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 179: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 180: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 182: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 184: /* tags_def_opt ::= tags_def */
      case 310: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==310);
      case 424: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==424);
{ yylhsminor.yy110 = yymsp[0].minor.yy110; }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 185: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 311: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==311);
{ yymsp[-3].minor.yy110 = yymsp[-1].minor.yy110; }
        break;
      case 186: /* table_options ::= */
{ yymsp[1].minor.yy42 = createDefaultTableOptions(pCxt); }
        break;
      case 187: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-2].minor.yy42, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 188: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-2].minor.yy42, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy110); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 189: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-2].minor.yy42, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy110); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 190: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-4].minor.yy42, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy110); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 191: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-2].minor.yy42, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 192: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-4].minor.yy42, TABLE_OPTION_SMA, yymsp[-1].minor.yy110); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 193: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-2].minor.yy42, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy110); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 194: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy42 = createAlterTableOptions(pCxt); yylhsminor.yy42 = setTableOption(pCxt, yylhsminor.yy42, yymsp[0].minor.yy459.type, &yymsp[0].minor.yy459.val); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 195: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-1].minor.yy42, yymsp[0].minor.yy459.type, &yymsp[0].minor.yy459.val); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 196: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy459.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy459.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 198: /* duration_list ::= duration_literal */
      case 388: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==388);
{ yylhsminor.yy110 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy42)); }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 199: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 389: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==389);
{ yylhsminor.yy110 = addNodeToList(pCxt, yymsp[-2].minor.yy110, releaseRawExprNode(pCxt, yymsp[0].minor.yy42)); }
  yymsp[-2].minor.yy110 = yylhsminor.yy110;
        break;
      case 202: /* rollup_func_name ::= function_name */
{ yylhsminor.yy42 = createFunctionNode(pCxt, &yymsp[0].minor.yy225, NULL); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 203: /* rollup_func_name ::= FIRST */
      case 204: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==204);
      case 259: /* tag_item ::= QTAGS */ yytestcase(yyruleno==259);
{ yylhsminor.yy42 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 207: /* col_name ::= column_name */
      case 260: /* tag_item ::= column_name */ yytestcase(yyruleno==260);
{ yylhsminor.yy42 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy225); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 208: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 209: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 210: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 211: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy42, yymsp[0].minor.yy42, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy42, yymsp[0].minor.yy42, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy42, NULL, OP_TYPE_LIKE); }
        break;
      case 215: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 217: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 218: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy42, yymsp[-1].minor.yy42, OP_TYPE_EQUAL); }
        break;
      case 219: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 220: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 221: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 222: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 223: /* cmd ::= SHOW LICENCES */
      case 224: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==224);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 225: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 226: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy42); }
        break;
      case 227: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy42); }
        break;
      case 228: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 229: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 230: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 231: /* cmd ::= SHOW VARIABLES */
      case 232: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==232);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 234: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy42); }
        break;
      case 235: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 237: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 238: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 239: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy42); }
        break;
      case 240: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 241: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 242: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy42, yymsp[-1].minor.yy42, OP_TYPE_EQUAL); }
        break;
      case 243: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy42, yymsp[0].minor.yy42, yymsp[-3].minor.yy110); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 245: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 246: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy42,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 247: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 248: /* db_name_cond_opt ::= */
      case 253: /* from_db_opt ::= */ yytestcase(yyruleno==253);
{ yymsp[1].minor.yy42 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 249: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy42 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy225); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 250: /* like_pattern_opt ::= */
      case 319: /* subtable_opt ::= */ yytestcase(yyruleno==319);
      case 434: /* case_when_else_opt ::= */ yytestcase(yyruleno==434);
      case 464: /* from_clause_opt ::= */ yytestcase(yyruleno==464);
      case 493: /* where_clause_opt ::= */ yytestcase(yyruleno==493);
      case 502: /* twindow_clause_opt ::= */ yytestcase(yyruleno==502);
      case 508: /* sliding_opt ::= */ yytestcase(yyruleno==508);
      case 510: /* fill_opt ::= */ yytestcase(yyruleno==510);
      case 524: /* having_clause_opt ::= */ yytestcase(yyruleno==524);
      case 526: /* range_opt ::= */ yytestcase(yyruleno==526);
      case 528: /* every_opt ::= */ yytestcase(yyruleno==528);
      case 541: /* slimit_clause_opt ::= */ yytestcase(yyruleno==541);
      case 545: /* limit_clause_opt ::= */ yytestcase(yyruleno==545);
{ yymsp[1].minor.yy42 = NULL; }
        break;
      case 251: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 252: /* table_name_cond ::= table_name */
{ yylhsminor.yy42 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy225); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 254: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy42 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 258: /* tag_item ::= TBNAME */
{ yylhsminor.yy42 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 261: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy42 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy225), &yymsp[0].minor.yy225); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 262: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy42 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy225), &yymsp[0].minor.yy225); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 263: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy103, yymsp[-3].minor.yy42, yymsp[-1].minor.yy42, NULL, yymsp[0].minor.yy42); }
        break;
      case 264: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy103, yymsp[-5].minor.yy42, yymsp[-3].minor.yy42, yymsp[-1].minor.yy110, NULL); }
        break;
      case 265: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy103, yymsp[0].minor.yy42); }
        break;
      case 266: /* full_index_name ::= index_name */
{ yylhsminor.yy42 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy225); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 267: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy42 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 268: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy42 = createIndexOption(pCxt, yymsp[-7].minor.yy110, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), NULL, yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 269: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy42 = createIndexOption(pCxt, yymsp[-9].minor.yy110, releaseRawExprNode(pCxt, yymsp[-5].minor.yy42), releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 272: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy42 = createFunctionNode(pCxt, &yymsp[-3].minor.yy225, yymsp[-1].minor.yy110); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 278: /* sma_stream_opt ::= */
      case 312: /* stream_options ::= */ yytestcase(yyruleno==312);
{ yymsp[1].minor.yy42 = createStreamOptions(pCxt); }
        break;
      case 279: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 316: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==316);
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 280: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 281: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 282: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy103, &yymsp[-2].minor.yy225, yymsp[0].minor.yy42); }
        break;
      case 283: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy103, &yymsp[-3].minor.yy225, &yymsp[0].minor.yy225, false); }
        break;
      case 284: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy103, &yymsp[-5].minor.yy225, &yymsp[0].minor.yy225, true); }
        break;
      case 285: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy103, &yymsp[-3].minor.yy225, yymsp[0].minor.yy42, false); }
        break;
      case 286: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy103, &yymsp[-5].minor.yy225, yymsp[0].minor.yy42, true); }
        break;
      case 287: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy103, &yymsp[0].minor.yy225); }
        break;
      case 288: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy103, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225); }
        break;
      case 289: /* cmd ::= DESC full_table_name */
      case 290: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==290);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy42); }
        break;
      case 291: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 292: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 293: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==293);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy103, yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 296: /* explain_options ::= */
{ yymsp[1].minor.yy42 = createDefaultExplainOptions(pCxt); }
        break;
      case 297: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy42 = setExplainVerbose(pCxt, yymsp[-2].minor.yy42, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 298: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy42 = setExplainRatio(pCxt, yymsp[-2].minor.yy42, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 299: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy103, yymsp[-8].minor.yy103, &yymsp[-5].minor.yy225, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy448, yymsp[0].minor.yy508); }
        break;
      case 300: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy103, &yymsp[0].minor.yy225); }
        break;
      case 305: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy103, &yymsp[-8].minor.yy225, yymsp[-5].minor.yy42, yymsp[-7].minor.yy42, yymsp[-3].minor.yy110, yymsp[-2].minor.yy42, yymsp[0].minor.yy42, yymsp[-4].minor.yy110); }
        break;
      case 306: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy103, &yymsp[0].minor.yy225); }
        break;
      case 313: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 314: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 315: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy42)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy42)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); yylhsminor.yy42 = yymsp[-3].minor.yy42; }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 317: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy42)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy42 = yymsp[-3].minor.yy42; }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 318: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 320: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 509: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==509);
      case 529: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==529);
{ yymsp[-3].minor.yy42 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy42); }
        break;
      case 321: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 322: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 323: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 324: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 325: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 326: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy110); }
        break;
      case 327: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 328: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy110 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 330: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 333: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy42 = createInsertStmt(pCxt, yymsp[-4].minor.yy42, yymsp[-2].minor.yy110, yymsp[0].minor.yy42); }
        break;
      case 334: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy42 = createInsertStmt(pCxt, yymsp[-1].minor.yy42, NULL, yymsp[0].minor.yy42); }
        break;
      case 335: /* literal ::= NK_INTEGER */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 336: /* literal ::= NK_FLOAT */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 337: /* literal ::= NK_STRING */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 338: /* literal ::= NK_BOOL */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 339: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 340: /* literal ::= duration_literal */
      case 350: /* signed_literal ::= signed */ yytestcase(yyruleno==350);
      case 371: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==371);
      case 372: /* expression ::= literal */ yytestcase(yyruleno==372);
      case 373: /* expression ::= pseudo_column */ yytestcase(yyruleno==373);
      case 374: /* expression ::= column_reference */ yytestcase(yyruleno==374);
      case 375: /* expression ::= function_expression */ yytestcase(yyruleno==375);
      case 376: /* expression ::= case_when_expression */ yytestcase(yyruleno==376);
      case 407: /* function_expression ::= literal_func */ yytestcase(yyruleno==407);
      case 456: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==456);
      case 460: /* boolean_primary ::= predicate */ yytestcase(yyruleno==460);
      case 462: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==462);
      case 463: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==463);
      case 466: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==466);
      case 468: /* table_reference ::= table_primary */ yytestcase(yyruleno==468);
      case 469: /* table_reference ::= joined_table */ yytestcase(yyruleno==469);
      case 473: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==473);
      case 531: /* query_simple ::= query_specification */ yytestcase(yyruleno==531);
      case 532: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==532);
      case 535: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==535);
      case 537: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==537);
{ yylhsminor.yy42 = yymsp[0].minor.yy42; }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 341: /* literal ::= NULL */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 342: /* literal ::= NK_QUESTION */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 343: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 344: /* signed ::= NK_INTEGER */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 345: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 346: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 347: /* signed ::= NK_FLOAT */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 348: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 349: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 351: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 352: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 353: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 354: /* signed_literal ::= duration_literal */
      case 356: /* signed_literal ::= literal_func */ yytestcase(yyruleno==356);
      case 427: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==427);
      case 489: /* select_item ::= common_expression */ yytestcase(yyruleno==489);
      case 499: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==499);
      case 536: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==536);
      case 538: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==538);
      case 551: /* search_condition ::= common_expression */ yytestcase(yyruleno==551);
{ yylhsminor.yy42 = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 355: /* signed_literal ::= NULL */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 357: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy42 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 377: /* expression ::= NK_LP expression NK_RP */
      case 461: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==461);
      case 550: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==550);
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy42)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 378: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy42));
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 379: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy42), NULL));
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 380: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 381: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 382: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 383: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 384: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 385: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 386: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 387: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 390: /* column_reference ::= column_name */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy225, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy225)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 391: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225, createColumnNode(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 392: /* pseudo_column ::= ROWTS */
      case 393: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==393);
      case 395: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==395);
      case 396: /* pseudo_column ::= QEND */ yytestcase(yyruleno==396);
      case 397: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==397);
      case 398: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==398);
      case 399: /* pseudo_column ::= WEND */ yytestcase(yyruleno==399);
      case 400: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==400);
      case 401: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==401);
      case 402: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==402);
      case 403: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==403);
      case 409: /* literal_func ::= NOW */ yytestcase(yyruleno==409);
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 394: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy225)))); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 404: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 405: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==405);
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy225, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy225, yymsp[-1].minor.yy110)); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 406: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), yymsp[-1].minor.yy448)); }
  yymsp[-5].minor.yy42 = yylhsminor.yy42;
        break;
      case 408: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy225, NULL)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 423: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy110 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 428: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 492: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==492);
{ yylhsminor.yy42 = createColumnNode(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 429: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy110, yymsp[-1].minor.yy42)); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 430: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), yymsp[-2].minor.yy110, yymsp[-1].minor.yy42)); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 433: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy42 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)); }
        break;
      case 435: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy42 = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); }
        break;
      case 436: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 441: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==441);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy2, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 437: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy42), releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 438: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy42), releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-5].minor.yy42 = yylhsminor.yy42;
        break;
      case 439: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), NULL));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 440: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), NULL));
                                                                                  }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 442: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy2 = OP_TYPE_LOWER_THAN; }
        break;
      case 443: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy2 = OP_TYPE_GREATER_THAN; }
        break;
      case 444: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy2 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 445: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy2 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 446: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy2 = OP_TYPE_NOT_EQUAL; }
        break;
      case 447: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy2 = OP_TYPE_EQUAL; }
        break;
      case 448: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy2 = OP_TYPE_LIKE; }
        break;
      case 449: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy2 = OP_TYPE_NOT_LIKE; }
        break;
      case 450: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy2 = OP_TYPE_MATCH; }
        break;
      case 451: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy2 = OP_TYPE_NMATCH; }
        break;
      case 452: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy2 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 453: /* in_op ::= IN */
{ yymsp[0].minor.yy2 = OP_TYPE_IN; }
        break;
      case 454: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy2 = OP_TYPE_NOT_IN; }
        break;
      case 455: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy110)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 457: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy42), NULL));
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 458: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 459: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 465: /* from_clause_opt ::= FROM table_reference_list */
      case 494: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==494);
      case 525: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==525);
{ yymsp[-1].minor.yy42 = yymsp[0].minor.yy42; }
        break;
      case 467: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy42 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy42, yymsp[0].minor.yy42, NULL); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 470: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy42 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 471: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy42 = createRealTableNode(pCxt, &yymsp[-3].minor.yy225, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 472: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy42 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy42), &yymsp[0].minor.yy225); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 474: /* alias_opt ::= */
{ yymsp[1].minor.yy225 = nil_token;  }
        break;
      case 476: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy225 = yymsp[0].minor.yy225; }
        break;
      case 477: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 478: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==478);
{ yymsp[-2].minor.yy42 = yymsp[-1].minor.yy42; }
        break;
      case 479: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy42 = createJoinTableNode(pCxt, yymsp[-4].minor.yy638, yymsp[-5].minor.yy42, yymsp[-2].minor.yy42, yymsp[0].minor.yy42); }
  yymsp[-5].minor.yy42 = yylhsminor.yy42;
        break;
      case 480: /* join_type ::= */
{ yymsp[1].minor.yy638 = JOIN_TYPE_INNER; }
        break;
      case 481: /* join_type ::= INNER */
{ yymsp[0].minor.yy638 = JOIN_TYPE_INNER; }
        break;
      case 482: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy42 = createSelectStmt(pCxt, yymsp[-10].minor.yy103, yymsp[-9].minor.yy110, yymsp[-8].minor.yy42);
                                                                                    yymsp[-11].minor.yy42 = addWhereClause(pCxt, yymsp[-11].minor.yy42, yymsp[-7].minor.yy42);
                                                                                    yymsp[-11].minor.yy42 = addPartitionByClause(pCxt, yymsp[-11].minor.yy42, yymsp[-6].minor.yy110);
                                                                                    yymsp[-11].minor.yy42 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy42, yymsp[-2].minor.yy42);
                                                                                    yymsp[-11].minor.yy42 = addGroupByClause(pCxt, yymsp[-11].minor.yy42, yymsp[-1].minor.yy110);
                                                                                    yymsp[-11].minor.yy42 = addHavingClause(pCxt, yymsp[-11].minor.yy42, yymsp[0].minor.yy42);
                                                                                    yymsp[-11].minor.yy42 = addRangeClause(pCxt, yymsp[-11].minor.yy42, yymsp[-5].minor.yy42);
                                                                                    yymsp[-11].minor.yy42 = addEveryClause(pCxt, yymsp[-11].minor.yy42, yymsp[-4].minor.yy42);
                                                                                    yymsp[-11].minor.yy42 = addFillClause(pCxt, yymsp[-11].minor.yy42, yymsp[-3].minor.yy42);
                                                                                  }
        break;
      case 485: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy103 = false; }
        break;
      case 488: /* select_item ::= NK_STAR */
{ yylhsminor.yy42 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 490: /* select_item ::= common_expression column_alias */
      case 500: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==500);
{ yylhsminor.yy42 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy42), &yymsp[0].minor.yy225); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 491: /* select_item ::= common_expression AS column_alias */
      case 501: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==501);
{ yylhsminor.yy42 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), &yymsp[0].minor.yy225); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 496: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 521: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==521);
      case 540: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==540);
{ yymsp[-2].minor.yy110 = yymsp[0].minor.yy110; }
        break;
      case 503: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy42 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), releaseRawExprNode(pCxt, yymsp[-1].minor.yy42)); }
        break;
      case 504: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy42 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy42)); }
        break;
      case 505: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy42 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), NULL, yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 506: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy42 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy42), releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 507: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy42 = createEventWindowNode(pCxt, yymsp[-3].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 511: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy42 = createFillNode(pCxt, yymsp[-1].minor.yy410, NULL); }
        break;
      case 512: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy42 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy110)); }
        break;
      case 513: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy42 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy110)); }
        break;
      case 514: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy410 = FILL_MODE_NONE; }
        break;
      case 515: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy410 = FILL_MODE_PREV; }
        break;
      case 516: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy410 = FILL_MODE_NULL; }
        break;
      case 517: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy410 = FILL_MODE_NULL_F; }
        break;
      case 518: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy410 = FILL_MODE_LINEAR; }
        break;
      case 519: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy410 = FILL_MODE_NEXT; }
        break;
      case 522: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy110 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 523: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy110 = addNodeToList(pCxt, yymsp[-2].minor.yy110, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); }
  yymsp[-2].minor.yy110 = yylhsminor.yy110;
        break;
      case 527: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy42 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), releaseRawExprNode(pCxt, yymsp[-1].minor.yy42)); }
        break;
      case 530: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy42 = addOrderByClause(pCxt, yymsp[-3].minor.yy42, yymsp[-2].minor.yy110);
                                                                                    yylhsminor.yy42 = addSlimitClause(pCxt, yylhsminor.yy42, yymsp[-1].minor.yy42);
                                                                                    yylhsminor.yy42 = addLimitClause(pCxt, yylhsminor.yy42, yymsp[0].minor.yy42);
                                                                                  }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 533: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy42 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy42, yymsp[0].minor.yy42); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 534: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy42 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy42, yymsp[0].minor.yy42); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 542: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 546: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==546);
{ yymsp[-1].minor.yy42 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 543: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 547: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==547);
{ yymsp[-3].minor.yy42 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 544: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 548: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==548);
{ yymsp[-3].minor.yy42 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 549: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy42); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 554: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy42 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), yymsp[-1].minor.yy106, yymsp[0].minor.yy599); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 555: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy106 = ORDER_ASC; }
        break;
      case 556: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy106 = ORDER_ASC; }
        break;
      case 557: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy106 = ORDER_DESC; }
        break;
      case 558: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy599 = NULL_ORDER_DEFAULT; }
        break;
      case 559: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy599 = NULL_ORDER_FIRST; }
        break;
      case 560: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy599 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
