/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 380
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOperatorType yy60;
  EFillMode yy94;
  SToken yy129;
  SDataType yy184;
  bool yy337;
  ENullOrder yy338;
  SAlterOption yy405;
  SNodeList* yy464;
  int32_t yy500;
  EJoinType yy532;
  int8_t yy543;
  int64_t yy549;
  EOrder yy658;
  SNode* yy712;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             666
#define YYNRULE              492
#define YYNTOKEN             257
#define YY_MAX_SHIFT         665
#define YY_MIN_SHIFTREDUCE   973
#define YY_MAX_SHIFTREDUCE   1464
#define YY_ERROR_ACTION      1465
#define YY_ACCEPT_ACTION     1466
#define YY_NO_ACTION         1467
#define YY_MIN_REDUCE        1468
#define YY_MAX_REDUCE        1959
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2395)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   433, 1937,  434, 1503, 1654, 1655, 1599,  326,  441,  548,
 /*    10 */   434, 1503,   39,   37, 1936,  144, 1709, 1776, 1934, 1937,
 /*    20 */   339, 1469, 1264,  513, 1610,   40,   38,   36,   35,   34,
 /*    30 */  1793,  325,  164, 1341, 1706, 1262, 1934,  125, 1290, 1023,
 /*    40 */  1006, 1022,  105, 1772, 1778,  104,  103,  102,  101,  100,
 /*    50 */    99,   98,   97,   96,  157,  570, 1336,   73, 1811,  344,
 /*    60 */   148,   14, 1653, 1655, 1568,   89,  577, 1647, 1270, 1024,
 /*    70 */  1023, 1762, 1022,  576,   39,   37, 1404,  123,  122, 1604,
 /*    80 */  1010, 1011,  339, 1530, 1264,  469, 1600,  553,  146,    1,
 /*    90 */  1480,  550,  159, 1879, 1880, 1341, 1884, 1262, 1825,  551,
 /*   100 */  1024,   64,   92, 1794,  579, 1796, 1797,  575, 1660,  570,
 /*   110 */  1291,  662, 1871, 1408, 1937,  312,  306, 1867, 1336, 1289,
 /*   120 */    36,   35,   34,   14, 1658, 1343, 1344, 1935, 1937,  105,
 /*   130 */  1270, 1934,  104,  103,  102,  101,  100,   99,   98,   97,
 /*   140 */    96,  165,  450, 1161, 1162, 1934,  639,  638,  637,  636,
 /*   150 */   349,    2,  635,  634,  126,  629,  628,  627,  626,  625,
 /*   160 */   624,  623,  137,  619,  618,  617,  348,  347,  614,  613,
 /*   170 */  1265,  316, 1263,  662, 1491,   33,   32, 1466, 1937,   40,
 /*   180 */    38,   36,   35,   34,   30,  261,   63, 1343, 1344,  432,
 /*   190 */  1290,  164,  436, 1268, 1269, 1934, 1318, 1319, 1321, 1322,
 /*   200 */  1323, 1324, 1325, 1326,  572,  568, 1334, 1335, 1337, 1338,
 /*   210 */  1339, 1340, 1342, 1345, 1468, 1762,   33,   32,  612,  551,
 /*   220 */    40,   38,   36,   35,   34, 1289,  317,  166,  315,  314,
 /*   230 */   610,  473, 1265,  210, 1263,  475, 1425,  354,  114,  113,
 /*   240 */   112,  111,  110,  109,  108,  107,  106,  253,  384,  135,
 /*   250 */   134,  607,  606,  605,   63, 1268, 1269,  474, 1318, 1319,
 /*   260 */  1321, 1322, 1323, 1324, 1325, 1326,  572,  568, 1334, 1335,
 /*   270 */  1337, 1338, 1339, 1340, 1342, 1345,   39,   37, 1937,  534,
 /*   280 */  1423, 1424, 1426, 1427,  339,  303, 1264,  378,   43,   75,
 /*   290 */   305,  163,  222,  515, 1793, 1934, 1320, 1341, 1435, 1262,
 /*   300 */  1119,  601,  600,  599, 1123,  598, 1125, 1126,  597, 1128,
 /*   310 */   594,  487, 1134,  591, 1136, 1137,  588,  585,  440, 1811,
 /*   320 */  1336,  436, 1811,  537,  166,   14,  497,  541, 1937, 1461,
 /*   330 */   577, 1699, 1270,  551,  377, 1762,  376,  576,   39,   37,
 /*   340 */   209,  163,  171,   63,  548, 1934,  339,   49, 1264,  525,
 /*   350 */   665, 1244, 1245,    2,  490, 1490,  223,  224,  484, 1341,
 /*   360 */    55, 1262, 1825,  208,  268,  540,   94, 1794,  579, 1796,
 /*   370 */  1797,  575,  125,  570, 1289,  662, 1871, 1608,  155,  144,
 /*   380 */  1870, 1867, 1336,  655,  651,  647,  643,  266, 1611, 1343,
 /*   390 */  1344, 1270,  166, 1264, 1270,   58, 1762,  217,   57, 1489,
 /*   400 */   543,  538,   42,   39,   37, 1346, 1262, 1780,  496, 1488,
 /*   410 */   548,  339,  123, 1264,  305,    8, 1460,  515, 1776,   90,
 /*   420 */    73,  494,  231,  492, 1341,  542, 1262,  160, 1879, 1880,
 /*   430 */    63, 1884,   77,  120, 1265, 1351, 1263,  662,  125, 1270,
 /*   440 */  1762, 1289, 1603,   63, 1772, 1778,  328, 1336,  479,  478,
 /*   450 */  1762, 1343, 1344,   11,   10,  522,  570, 1268, 1269, 1270,
 /*   460 */  1318, 1319, 1321, 1322, 1323, 1324, 1325, 1326,  572,  568,
 /*   470 */  1334, 1335, 1337, 1338, 1339, 1340, 1342, 1345,  123,  216,
 /*   480 */     9,  166,  662,  482,  481,  166,  172,  219, 1586,  196,
 /*   490 */   121,  633,  631,  161, 1879, 1880, 1265, 1884, 1263, 1660,
 /*   500 */   477,  480,  662,  150,   61, 1236,  327,  212,  467,  463,
 /*   510 */   459,  455,  195, 1585,   76, 1658, 1343, 1344,   71, 1268,
 /*   520 */  1269,   70, 1318, 1319, 1321, 1322, 1323, 1324, 1325, 1326,
 /*   530 */   572,  568, 1334, 1335, 1337, 1338, 1339, 1340, 1342, 1345,
 /*   540 */   166, 1265, 1377, 1263,   74, 1583, 1288,  193,  450,   82,
 /*   550 */    33,   32,  342,  166,   40,   38,   36,   35,   34, 1533,
 /*   560 */   144, 1265, 1584, 1263, 1268, 1269,  621,  512,  166, 1610,
 /*   570 */  1601, 1699,   33,   32, 1010, 1011,   40,   38,   36,   35,
 /*   580 */    34,  166,  174,  604, 1268, 1269, 1081, 1318, 1319, 1321,
 /*   590 */  1322, 1323, 1324, 1325, 1326,  572,  568, 1334, 1335, 1337,
 /*   600 */  1338, 1339, 1340, 1342, 1345,   39,   37,   22, 1937,  192,
 /*   610 */   185, 1793,  190,  339,  610, 1264,  446, 1597, 1320, 1083,
 /*   620 */   513,  163,  612,  482,  481, 1934, 1341,  525, 1262, 1593,
 /*   630 */   121, 1707,  183,  135,  134,  607,  606,  605,  115, 1811,
 /*   640 */   477,  480,    7,  345,  548,  471,  610,  577, 1487, 1336,
 /*   650 */   438,  144, 1762,  525,  576, 1608, 1287, 1595,  419,  352,
 /*   660 */  1610, 1270,  351, 1365,  168,  135,  134,  607,  606,  605,
 /*   670 */    33,   32,  125, 1486,   40,   38,   36,   35,   34, 1825,
 /*   680 */  1485, 1608,    9,  280, 1794,  579, 1796, 1797,  575, 1762,
 /*   690 */   570,   33,   32,  553,  505,   40,   38,   36,   35,   34,
 /*   700 */  1937,   33,   32, 1937,  662,   40,   38,   36,   35,   34,
 /*   710 */   176,  175,  123,  163, 1762,  498,  163, 1934, 1343, 1344,
 /*   720 */  1934, 1762, 1705,  307,  300,   27, 1484,  251, 1879,  547,
 /*   730 */   525,  546,   39,   37, 1937, 1370, 1483,  302, 1886, 1287,
 /*   740 */   339,  115, 1264,  525,  307,  555,  412,  165,  476,  424,
 /*   750 */  1591, 1934, 1303, 1341,  382, 1262, 1937,  213, 1608,  373,
 /*   760 */  1363, 1886, 1883, 1265, 1509, 1263,  397, 1762,  425,  163,
 /*   770 */   399, 1608, 1482, 1934, 1479, 1292, 1336, 1762,  375,  371,
 /*   780 */  1704, 1363,  300, 1415, 1478, 1882, 1268, 1269, 1270, 1318,
 /*   790 */  1319, 1321, 1322, 1323, 1324, 1325, 1326,  572,  568, 1334,
 /*   800 */  1335, 1337, 1338, 1339, 1340, 1342, 1345,  390, 1477,    2,
 /*   810 */    26, 1660,  657, 1762, 1364, 1762,   33,   32,  343,  386,
 /*   820 */    40,   38,   36,   35,   34, 1762,   28, 1658, 1660, 1397,
 /*   830 */  1476,  662,   33,   32, 1475, 1364,   40,   38,   36,   35,
 /*   840 */    34,  622, 1289, 1580, 1659, 1343, 1344,  423, 1474, 1762,
 /*   850 */   418,  417,  416,  415,  414,  411,  410,  409,  408,  407,
 /*   860 */   403,  402,  401,  400,  394,  393,  392,  391, 1473,  388,
 /*   870 */   387, 1762,  475, 1401, 1472, 1762,   29,  337, 1358, 1359,
 /*   880 */  1360, 1361, 1362, 1366, 1367, 1368, 1369, 1886,  608, 1762,
 /*   890 */  1265, 1651, 1263,  609,  474,  571, 1651,   29,  337, 1358,
 /*   900 */  1359, 1360, 1361, 1362, 1366, 1367, 1368, 1369, 1471, 1762,
 /*   910 */  1793, 1881,  233, 1268, 1269, 1762, 1318, 1319, 1321, 1322,
 /*   920 */  1323, 1324, 1325, 1326,  572,  568, 1334, 1335, 1337, 1338,
 /*   930 */  1339, 1340, 1342, 1345,  525,  145,  525,  525, 1811, 1273,
 /*   940 */   279,  525, 1891, 1397,  548,  383,  577,  389,  404, 1762,
 /*   950 */   603, 1762,  405,  576,  277,   60,  273,  133,   59, 1638,
 /*   960 */    44,    4, 1608, 1749, 1608, 1608, 1481,  553,  201, 1608,
 /*   970 */   525,  199,  125, 1520,  179,  429,  427, 1780, 1825, 1515,
 /*   980 */   560,  449,   92, 1794,  579, 1796, 1797,  575, 1776,  570,
 /*   990 */   566,  203, 1871,  553,  202,  483,  306, 1867, 1608,  336,
 /*  1000 */   335,  485,  525,   41,   54,  557,   63,  221, 1937, 1278,
 /*  1010 */   361, 1513,  123, 1605, 1772, 1778,  334,   53,  509, 1320,
 /*  1020 */  1341,  163, 1271,   11,   10, 1934,  570,  251, 1879,  547,
 /*  1030 */  1608,  546,  256,  488, 1937,  525,  205, 1781,  207,  204,
 /*  1040 */   129,  206, 1793, 1336,   91,  132, 1737,  163, 1776,   51,
 /*  1050 */  1213, 1934,   33,   32,  225, 1270,   40,   38,   36,   35,
 /*  1060 */    34,   33,   32, 1608,  133,   40,   38,   36,   35,   34,
 /*  1070 */  1811,  525, 1463, 1464, 1772, 1778, 1276, 1569,  552,   68,
 /*  1080 */    67,  381,  506, 1762,  170,  576,  570,  518,  468, 1783,
 /*  1090 */   615,  535,  230, 1272,   88,  245, 1371, 1400,  565, 1608,
 /*  1100 */   301,  499,   51,  369,   85,  367,  363,  359,  356,  353,
 /*  1110 */  1825, 1112, 1069,  237,   93, 1794,  579, 1796, 1797,  575,
 /*  1120 */   525,  570, 1355,  525, 1871,  525,  525,  525,  330, 1867,
 /*  1130 */   158,  510, 1785, 1050,  227,  525,  523,  524,  262,  616,
 /*  1140 */    41, 1793,  162, 1303,  166,  350,  346, 1504, 1608, 1422,
 /*  1150 */  1897, 1608,   41, 1608, 1608, 1608, 1812, 1279,  583, 1274,
 /*  1160 */   240, 1067, 1648, 1608, 1901,  132, 1051,  549,  255, 1811,
 /*  1170 */   250,  258,    3,  260,  133,  117,  355,  552,  132,    5,
 /*  1180 */  1282, 1284, 1762, 1793,  576,  561,  360, 1327,  313,  269,
 /*  1190 */   173, 1229,  568, 1334, 1335, 1337, 1338, 1339, 1340,  272,
 /*  1200 */   385,  143, 1287,  406, 1701, 1140,  421,  413,  558, 1825,
 /*  1210 */   426, 1811, 1144,   93, 1794,  579, 1796, 1797,  575,  577,
 /*  1220 */   570, 1151, 1149, 1871, 1762,  136,  576,  330, 1867,  158,
 /*  1230 */  1275,  420,  422,  428,  430, 1293, 1793,  431, 1296,  439,
 /*  1240 */   182,  443,  442,  184,  444, 1295, 1297,  447,  445, 1898,
 /*  1250 */   187, 1825,  189, 1793, 1294,   93, 1794,  579, 1796, 1797,
 /*  1260 */   575,  448,  570,  191, 1811, 1871,   72,  451,  194,  330,
 /*  1270 */  1867, 1950,  577,  472,  470,  304, 1598, 1762,  198,  576,
 /*  1280 */  1905, 1811,  116, 1594, 1742,  211,  200,  500,  138,  577,
 /*  1290 */   270,  139, 1596,  507, 1762, 1592,  576,  140,  141,  214,
 /*  1300 */   511,  218,  322,  501, 1825,  533,  519, 1292,   93, 1794,
 /*  1310 */   579, 1796, 1797,  575, 1609,  570, 1793,  228, 1871,  504,
 /*  1320 */   130, 1825,  330, 1867, 1950,   93, 1794,  579, 1796, 1797,
 /*  1330 */   575,  514,  570, 1928, 1741, 1871, 1711,  516,  131,  330,
 /*  1340 */  1867, 1950,  324,  521, 1811,  271,   81,  520, 1902,  529,
 /*  1350 */  1890,  235,  577,  536,  239,    6, 1912, 1762,  531,  576,
 /*  1360 */   545,  532,  530,  329,  539, 1911, 1793,  528,  527, 1397,
 /*  1370 */   124,  249, 1291,  553,  562,  559, 1793,   48,  331, 1887,
 /*  1380 */    83,  581, 1652,  246, 1825,  248, 1893,  265,  286, 1794,
 /*  1390 */   579, 1796, 1797,  575, 1811,  570,  658,  274, 1581,  659,
 /*  1400 */   247, 1933,  577,  661, 1811,   52,  244, 1762,  151,  576,
 /*  1410 */   152, 1852,  577,  276, 1937,  287,  297, 1762, 1793,  576,
 /*  1420 */   278, 1756,  296,  553,  254, 1755,  556,  165,  257, 1953,
 /*  1430 */    65, 1934, 1754, 1753, 1825,   66, 1750,  259,  286, 1794,
 /*  1440 */   579, 1796, 1797,  575, 1825,  570, 1811,  563,   94, 1794,
 /*  1450 */   579, 1796, 1797,  575,  574,  570,  358,  357, 1871, 1762,
 /*  1460 */   362,  576,  564, 1867, 1937, 1256, 1257, 1748, 1747,  169,
 /*  1470 */   364,  366, 1793,  365, 1746,  370,  368,  163, 1745,  372,
 /*  1480 */  1744, 1934,  374, 1232, 1793, 1231, 1825, 1722, 1721,  380,
 /*  1490 */   294, 1794,  579, 1796, 1797,  575,  573,  570,  567, 1843,
 /*  1500 */  1811,  379, 1720, 1719, 1201, 1694,  127, 1693,  577, 1692,
 /*  1510 */  1691,   69, 1811, 1762, 1690,  576, 1689, 1688, 1687, 1686,
 /*  1520 */   577,  395, 1685,  398,  396, 1762, 1684,  576, 1683, 1682,
 /*  1530 */  1681, 1680, 1679, 1678, 1677, 1676, 1675, 1674, 1673, 1672,
 /*  1540 */  1825, 1793, 1671,  128,  147, 1794,  579, 1796, 1797,  575,
 /*  1550 */  1670,  570, 1825,  180,  177, 1534,   94, 1794,  579, 1796,
 /*  1560 */  1797,  575, 1669,  570, 1668, 1793, 1871, 1203, 1664, 1811,
 /*  1570 */  1667, 1868, 1666, 1665,  323, 1663, 1662,  577, 1661, 1535,
 /*  1580 */   178, 1532, 1762, 1793,  576, 1500,  118,  156,  554, 1951,
 /*  1590 */  1499, 1013,  435, 1811, 1012,  437,  181,  119,  526, 1735,
 /*  1600 */  1729,  577, 1718,  188,  186, 1717, 1762, 1703,  576, 1825,
 /*  1610 */  1587, 1811, 1531,  295, 1794,  579, 1796, 1797,  575,  577,
 /*  1620 */   570, 1043, 1529,  452, 1762,  454,  576, 1527,  456,  453,
 /*  1630 */   457,  458, 1525, 1825,  461,  462,  460,  295, 1794,  579,
 /*  1640 */  1796, 1797,  575, 1523,  570, 1793,  464,  466, 1512, 1511,
 /*  1650 */   465, 1825, 1496, 1589, 1588,  290, 1794,  579, 1796, 1797,
 /*  1660 */   575,   50,  570, 1793, 1155,  197, 1154,  630, 1080,  632,
 /*  1670 */  1077, 1076, 1075, 1811, 1521, 1516, 1514,  318,  319,  486,
 /*  1680 */   320,  577,  489, 1495, 1494, 1493, 1762,  495,  576,   95,
 /*  1690 */  1734, 1811,  491,  544,  493, 1238, 1728,   56,  142,  574,
 /*  1700 */   502, 1716, 1714, 1715, 1762,  503,  576, 1713,  215,  321,
 /*  1710 */   508, 1712,   15, 1825,  226, 1793, 1710,  147, 1794,  579,
 /*  1720 */  1796, 1797,  575, 1248,  570, 1702,  517,  220,   78,   80,
 /*  1730 */    79, 1825,  232, 1793,   23,  294, 1794,  579, 1796, 1797,
 /*  1740 */   575,   85,  570, 1811, 1844,  243,   16,  229,  338,   41,
 /*  1750 */  1783,  577, 1437,  234,   17,  238, 1762, 1793,  576,  252,
 /*  1760 */   236, 1811, 1952, 1419,   47,  242,  340, 1421,  149,  577,
 /*  1770 */   241,   24,   25,   46, 1762, 1449,  576, 1414,   84, 1782,
 /*  1780 */   153,   18, 1394, 1825, 1393, 1811,   45,  295, 1794,  579,
 /*  1790 */  1796, 1797,  575,  577,  570, 1454, 1448,   13, 1762, 1443,
 /*  1800 */   576, 1825,  332, 1453, 1452,  295, 1794,  579, 1796, 1797,
 /*  1810 */   575,  333,  570, 1793,   10, 1280,   19, 1828,  154, 1311,
 /*  1820 */   569, 1356,  582,  167,   31, 1825, 1331, 1793,   12,  281,
 /*  1830 */  1794,  579, 1796, 1797,  575, 1329,  570, 1328,   20,   21,
 /*  1840 */   341, 1811,  580, 1141,  584,  587,  578, 1138,  586,  577,
 /*  1850 */  1135,  589,  590,  592, 1762, 1811,  576,  595, 1118, 1133,
 /*  1860 */  1129, 1127, 1150,  577,  593, 1132,  602,  596, 1762, 1793,
 /*  1870 */   576, 1131, 1130,  263,   86,   87, 1146,   62,  611, 1793,
 /*  1880 */  1072, 1825, 1041, 1071, 1070,  282, 1794,  579, 1796, 1797,
 /*  1890 */   575, 1068,  570, 1066, 1065, 1825, 1064, 1811,  620,  289,
 /*  1900 */  1794,  579, 1796, 1797,  575,  577,  570, 1811, 1087,  264,
 /*  1910 */  1762, 1062,  576, 1061, 1060,  577, 1059, 1058, 1057, 1056,
 /*  1920 */  1762, 1793,  576, 1084, 1082, 1047, 1053, 1528, 1052, 1049,
 /*  1930 */  1526, 1048, 1046,  640,  641,  644, 1524, 1825,  642,  648,
 /*  1940 */   646,  291, 1794,  579, 1796, 1797,  575, 1825,  570, 1811,
 /*  1950 */   650,  283, 1794,  579, 1796, 1797,  575,  577,  570,  645,
 /*  1960 */   649, 1522, 1762,  652,  576,  653, 1510,  656,  654, 1003,
 /*  1970 */  1492,  267,  660,  663, 1793, 1266,  275,  664, 1467, 1467,
 /*  1980 */  1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 1825,
 /*  1990 */  1467, 1467, 1793,  292, 1794,  579, 1796, 1797,  575, 1467,
 /*  2000 */   570, 1467, 1811, 1467, 1467, 1467, 1467, 1467, 1467, 1467,
 /*  2010 */   577, 1467, 1467, 1467, 1467, 1762, 1467,  576, 1467, 1467,
 /*  2020 */  1811, 1467, 1467, 1467, 1467, 1467, 1467, 1467,  577, 1467,
 /*  2030 */  1467, 1467, 1467, 1762, 1467,  576, 1467, 1467, 1467, 1467,
 /*  2040 */  1467, 1467, 1825, 1467, 1793, 1467,  284, 1794,  579, 1796,
 /*  2050 */  1797,  575, 1467,  570, 1793, 1467, 1467, 1467, 1467, 1467,
 /*  2060 */  1825, 1467, 1467, 1467,  293, 1794,  579, 1796, 1797,  575,
 /*  2070 */  1793,  570, 1811, 1467, 1467, 1467, 1467, 1467, 1467, 1467,
 /*  2080 */   577, 1467, 1811, 1467, 1467, 1762, 1467,  576, 1467, 1467,
 /*  2090 */   577, 1467, 1467, 1467, 1467, 1762, 1467,  576, 1811, 1467,
 /*  2100 */  1467, 1467, 1467, 1467, 1467, 1467,  577, 1467, 1467, 1467,
 /*  2110 */  1467, 1762, 1825,  576, 1467, 1467,  285, 1794,  579, 1796,
 /*  2120 */  1797,  575, 1825,  570, 1793, 1467,  298, 1794,  579, 1796,
 /*  2130 */  1797,  575, 1467,  570, 1467, 1467, 1467, 1467, 1825, 1467,
 /*  2140 */  1793, 1467,  299, 1794,  579, 1796, 1797,  575, 1467,  570,
 /*  2150 */  1793, 1467, 1811, 1467, 1467, 1467, 1467, 1467, 1467, 1467,
 /*  2160 */   577, 1467, 1467, 1467, 1467, 1762, 1793,  576, 1811, 1467,
 /*  2170 */  1467, 1467, 1467, 1467, 1467, 1467,  577, 1467, 1811, 1467,
 /*  2180 */  1467, 1762, 1467,  576, 1467, 1467,  577, 1467, 1467, 1467,
 /*  2190 */  1467, 1762, 1825,  576, 1811, 1467, 1805, 1794,  579, 1796,
 /*  2200 */  1797,  575,  577,  570, 1467, 1467, 1467, 1762, 1825,  576,
 /*  2210 */  1467, 1467, 1804, 1794,  579, 1796, 1797,  575, 1825,  570,
 /*  2220 */  1467, 1467, 1803, 1794,  579, 1796, 1797,  575, 1467,  570,
 /*  2230 */  1467, 1467, 1467, 1467, 1825, 1793, 1467, 1467,  310, 1794,
 /*  2240 */   579, 1796, 1797,  575, 1467,  570, 1467, 1467, 1467, 1467,
 /*  2250 */  1467, 1467, 1467, 1793, 1467, 1467, 1467, 1467, 1467, 1467,
 /*  2260 */  1467, 1467, 1467, 1811, 1467, 1467, 1467, 1467, 1467, 1467,
 /*  2270 */  1467,  577, 1467, 1467, 1467, 1467, 1762, 1467,  576, 1467,
 /*  2280 */  1467, 1811, 1467, 1467, 1467, 1467, 1467, 1467, 1467,  577,
 /*  2290 */  1467, 1467, 1467, 1467, 1762, 1467,  576, 1467, 1467, 1467,
 /*  2300 */  1467, 1467, 1467, 1825, 1467, 1793, 1467,  309, 1794,  579,
 /*  2310 */  1796, 1797,  575, 1467,  570, 1793, 1467, 1467, 1467, 1467,
 /*  2320 */  1467, 1825, 1467, 1467, 1467,  311, 1794,  579, 1796, 1797,
 /*  2330 */   575, 1467,  570, 1811, 1467, 1467, 1467, 1467, 1467, 1467,
 /*  2340 */  1467,  577, 1467, 1811, 1467, 1467, 1762, 1467,  576, 1467,
 /*  2350 */  1467,  577, 1467, 1467, 1467, 1467, 1762, 1467,  576, 1467,
 /*  2360 */  1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467,
 /*  2370 */  1467, 1467, 1467, 1825, 1467, 1467, 1467,  308, 1794,  579,
 /*  2380 */  1796, 1797,  575, 1825,  570, 1467, 1467,  288, 1794,  579,
 /*  2390 */  1796, 1797,  575, 1467,  570,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   264,  358,  266,  267,  302,  303,  290,  280,  264,  268,
 /*    10 */   266,  267,   12,   13,  371,  288,    0,  301,  375,  358,
 /*    20 */    20,    0,   22,  303,  297,   12,   13,   14,   15,   16,
 /*    30 */   260,  311,  371,   33,  314,   35,  375,  296,   20,   20,
 /*    40 */     4,   22,   21,  327,  328,   24,   25,   26,   27,   28,
 /*    50 */    29,   30,   31,   32,  287,  339,   56,  272,  288,  299,
 /*    60 */   273,   61,  302,  303,  277,  270,  296,  300,   68,   50,
 /*    70 */    20,  301,   22,  303,   12,   13,   14,  336,  283,  294,
 /*    80 */    44,   45,   20,    0,   22,   35,  291,  317,  259,   89,
 /*    90 */   261,  350,  351,  352,  353,   33,  355,   35,  328,   20,
 /*   100 */    50,    4,  332,  333,  334,  335,  336,  337,  288,  339,
 /*   110 */    20,  111,  342,   14,  358,  295,  346,  347,   56,   20,
 /*   120 */    14,   15,   16,   61,  304,  125,  126,  371,  358,   21,
 /*   130 */    68,  375,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   140 */    32,  371,   60,  125,  126,  375,   63,   64,   65,   66,
 /*   150 */    67,   89,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   160 */    77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   170 */   170,   37,  172,  111,  260,    8,    9,  257,  358,   12,
 /*   180 */    13,   14,   15,   16,  343,  344,   89,  125,  126,  265,
 /*   190 */    20,  371,  268,  193,  194,  375,  196,  197,  198,  199,
 /*   200 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,    0,  301,    8,    9,   60,   20,
 /*   220 */    12,   13,   14,   15,   16,   20,   92,  227,   94,   95,
 /*   230 */   101,   97,  170,  121,  172,  101,  193,  317,   24,   25,
 /*   240 */    26,   27,   28,   29,   30,   31,   32,  157,  268,  120,
 /*   250 */   121,  122,  123,  124,   89,  193,  194,  123,  196,  197,
 /*   260 */   198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
 /*   270 */   208,  209,  210,  211,  212,  213,   12,   13,  358,  236,
 /*   280 */   237,  238,  239,  240,   20,  305,   22,  317,   89,  177,
 /*   290 */   178,  371,  120,  181,  260,  375,  197,   33,   90,   35,
 /*   300 */   102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
 /*   310 */   112,    4,  114,  115,  116,  117,  118,  119,  265,  288,
 /*   320 */    56,  268,  288,  155,  227,   61,   19,  296,  358,  162,
 /*   330 */   296,  296,   68,   20,  169,  301,  171,  303,   12,   13,
 /*   340 */    33,  371,  307,   89,  268,  375,   20,   89,   22,  268,
 /*   350 */    19,  179,  180,   89,   47,  260,  120,  121,   51,   33,
 /*   360 */   279,   35,  328,   56,   33,  334,  332,  333,  334,  335,
 /*   370 */   336,  337,  296,  339,   20,  111,  342,  296,   47,  288,
 /*   380 */   346,  347,   56,   52,   53,   54,   55,   56,  297,  125,
 /*   390 */   126,   68,  227,   22,   68,   88,  301,   56,   91,  260,
 /*   400 */   232,  233,   89,   12,   13,   14,   35,  290,   21,  260,
 /*   410 */   268,   20,  336,   22,  178,   89,  249,  181,  301,   88,
 /*   420 */   272,   34,   91,   36,   33,   20,   35,  351,  352,  353,
 /*   430 */    89,  355,   91,  285,  170,   14,  172,  111,  296,   68,
 /*   440 */   301,   20,  294,   89,  327,  328,  329,   56,  274,  275,
 /*   450 */   301,  125,  126,    1,    2,  124,  339,  193,  194,   68,
 /*   460 */   196,  197,  198,  199,  200,  201,  202,  203,  204,  205,
 /*   470 */   206,  207,  208,  209,  210,  211,  212,  213,  336,   56,
 /*   480 */    89,  227,  111,   64,   65,  227,   56,  156,    0,   33,
 /*   490 */    71,  274,  275,  351,  352,  353,  170,  355,  172,  288,
 /*   500 */    81,   82,  111,   47,    3,  174,  295,  176,   52,   53,
 /*   510 */    54,   55,   56,    0,   91,  304,  125,  126,   88,  193,
 /*   520 */   194,   91,  196,  197,  198,  199,  200,  201,  202,  203,
 /*   530 */   204,  205,  206,  207,  208,  209,  210,  211,  212,  213,
 /*   540 */   227,  170,   90,  172,   88,    0,   20,   91,   60,  270,
 /*   550 */     8,    9,  280,  227,   12,   13,   14,   15,   16,    0,
 /*   560 */   288,  170,    0,  172,  193,  194,   68,  317,  227,  297,
 /*   570 */   291,  296,    8,    9,   44,   45,   12,   13,   14,   15,
 /*   580 */    16,  227,  307,  100,  193,  194,   35,  196,  197,  198,
 /*   590 */   199,  200,  201,  202,  203,  204,  205,  206,  207,  208,
 /*   600 */   209,  210,  211,  212,  213,   12,   13,   43,  358,  153,
 /*   610 */   154,  260,  156,   20,  101,   22,  160,  289,  197,   68,
 /*   620 */   303,  371,   60,   64,   65,  375,   33,  268,   35,  289,
 /*   630 */    71,  314,  176,  120,  121,  122,  123,  124,  279,  288,
 /*   640 */    81,   82,   39,  280,  268,  286,  101,  296,  260,   56,
 /*   650 */    14,  288,  301,  268,  303,  296,   20,  289,   77,  317,
 /*   660 */   297,   68,  317,  152,  279,  120,  121,  122,  123,  124,
 /*   670 */     8,    9,  296,  260,   12,   13,   14,   15,   16,  328,
 /*   680 */   260,  296,   89,  332,  333,  334,  335,  336,  337,  301,
 /*   690 */   339,    8,    9,  317,  321,   12,   13,   14,   15,   16,
 /*   700 */   358,    8,    9,  358,  111,   12,   13,   14,   15,   16,
 /*   710 */   129,  130,  336,  371,  301,  317,  371,  375,  125,  126,
 /*   720 */   375,  301,  313,   61,  315,  214,  260,  351,  352,  353,
 /*   730 */   268,  355,   12,   13,  358,  224,  260,   18,  330,   20,
 /*   740 */    20,  279,   22,  268,   61,  244,   27,  371,  286,   30,
 /*   750 */   289,  375,   90,   33,  279,   35,  358,  289,  296,  165,
 /*   760 */    98,  330,  354,  170,    0,  172,   47,  301,   49,  371,
 /*   770 */    51,  296,  260,  375,  260,   20,   56,  301,  184,  185,
 /*   780 */   313,   98,  315,   90,  260,  354,  193,  194,   68,  196,
 /*   790 */   197,  198,  199,  200,  201,  202,  203,  204,  205,  206,
 /*   800 */   207,  208,  209,  210,  211,  212,  213,   88,  260,   89,
 /*   810 */     2,  288,   48,  301,  152,  301,    8,    9,  295,  100,
 /*   820 */    12,   13,   14,   15,   16,  301,    2,  304,  288,  226,
 /*   830 */   260,  111,    8,    9,  260,  152,   12,   13,   14,   15,
 /*   840 */    16,  276,   20,  278,  304,  125,  126,  128,  260,  301,
 /*   850 */   131,  132,  133,  134,  135,  136,  137,  138,  139,  140,
 /*   860 */   141,  142,  143,  144,  145,  146,  147,  148,  260,  150,
 /*   870 */   151,  301,  101,    4,  260,  301,  214,  215,  216,  217,
 /*   880 */   218,  219,  220,  221,  222,  223,  224,  330,  298,  301,
 /*   890 */   170,  301,  172,  298,  123,  289,  301,  214,  215,  216,
 /*   900 */   217,  218,  219,  220,  221,  222,  223,  224,  260,  301,
 /*   910 */   260,  354,  157,  193,  194,  301,  196,  197,  198,  199,
 /*   920 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   930 */   210,  211,  212,  213,  268,   18,  268,  268,  288,   35,
 /*   940 */    23,  268,  225,  226,  268,  279,  296,  279,  279,  301,
 /*   950 */   289,  301,  279,  303,   37,   38,  281,   43,   41,  284,
 /*   960 */    42,   43,  296,    0,  296,  296,  261,  317,   93,  296,
 /*   970 */   268,   96,  296,    0,   57,   58,   59,  290,  328,    0,
 /*   980 */    43,  279,  332,  333,  334,  335,  336,  337,  301,  339,
 /*   990 */    61,   93,  342,  317,   96,   22,  346,  347,  296,   12,
 /*  1000 */    13,   22,  268,   43,   90,   43,   89,   43,  358,   22,
 /*  1010 */    47,    0,  336,  279,  327,  328,  329,  157,  158,  197,
 /*  1020 */    33,  371,   35,    1,    2,  375,  339,  351,  352,  353,
 /*  1030 */   296,  355,  378,   22,  358,  268,   93,  290,   93,   96,
 /*  1040 */    43,   96,  260,   56,  127,   43,  279,  371,  301,   43,
 /*  1050 */    90,  375,    8,    9,   90,   68,   12,   13,   14,   15,
 /*  1060 */    16,    8,    9,  296,   43,   12,   13,   14,   15,   16,
 /*  1070 */   288,  268,  125,  126,  327,  328,  172,  277,  296,  162,
 /*  1080 */   163,  164,  279,  301,  167,  303,  339,   90,  269,   46,
 /*  1090 */    13,  369,   90,   35,   89,  365,   90,  228,  111,  296,
 /*  1100 */   183,  324,   43,  186,   99,  188,  189,  190,  191,  192,
 /*  1110 */   328,   90,   35,   43,  332,  333,  334,  335,  336,  337,
 /*  1120 */   268,  339,  193,  268,  342,  268,  268,  268,  346,  347,
 /*  1130 */   348,  279,   89,   35,  279,  268,  279,  279,  279,   13,
 /*  1140 */    43,  260,  360,   90,  227,  269,  279,  267,  296,   90,
 /*  1150 */   368,  296,   43,  296,  296,  296,  288,  170,   43,  172,
 /*  1160 */    90,   35,  300,  296,  331,   43,   68,  356,  372,  288,
 /*  1170 */   349,  372,  359,  372,   43,   43,  326,  296,   43,  229,
 /*  1180 */   193,  194,  301,  260,  303,  248,   47,   90,  325,  319,
 /*  1190 */    42,  168,  205,  206,  207,  208,  209,  210,  211,   90,
 /*  1200 */   308,  157,   20,  268,  268,   90,  152,  308,  246,  328,
 /*  1210 */   268,  288,   90,  332,  333,  334,  335,  336,  337,  296,
 /*  1220 */   339,   90,   90,  342,  301,   90,  303,  346,  347,  348,
 /*  1230 */   172,  306,  306,  268,  268,   20,  260,  262,   20,  262,
 /*  1240 */   272,  303,  323,  272,  316,   20,   20,  316,  318,  368,
 /*  1250 */   272,  328,  272,  260,   20,  332,  333,  334,  335,  336,
 /*  1260 */   337,  309,  339,  272,  288,  342,  272,  268,  272,  346,
 /*  1270 */   347,  348,  296,  288,  262,  262,  288,  301,  288,  303,
 /*  1280 */   357,  288,  268,  288,  301,  270,  288,  175,  288,  296,
 /*  1290 */   323,  288,  288,  268,  301,  288,  303,  288,  288,  270,
 /*  1300 */   268,  270,  316,  322,  328,  234,  154,   20,  332,  333,
 /*  1310 */   334,  335,  336,  337,  296,  339,  260,  270,  342,  303,
 /*  1320 */   312,  328,  346,  347,  348,  332,  333,  334,  335,  336,
 /*  1330 */   337,  301,  339,  357,  301,  342,  301,  301,  312,  346,
 /*  1340 */   347,  348,  301,  309,  288,  284,  270,  310,  331,  301,
 /*  1350 */   357,  312,  296,  235,  312,  241,  364,  301,  301,  303,
 /*  1360 */   161,  301,  243,  301,  301,  364,  260,  242,  230,  226,
 /*  1370 */   296,  326,   20,  317,  247,  245,  260,   89,  250,  330,
 /*  1380 */    89,  292,  301,  363,  328,  361,  367,  270,  332,  333,
 /*  1390 */   334,  335,  336,  337,  288,  339,   36,  268,  278,  263,
 /*  1400 */   362,  374,  296,  262,  288,  320,  366,  301,  315,  303,
 /*  1410 */   364,  345,  296,  271,  358,  282,  282,  301,  260,  303,
 /*  1420 */   258,    0,  282,  317,  373,    0,  374,  371,  373,  379,
 /*  1430 */   177,  375,    0,    0,  328,   42,    0,  373,  332,  333,
 /*  1440 */   334,  335,  336,  337,  328,  339,  288,  374,  332,  333,
 /*  1450 */   334,  335,  336,  337,  296,  339,  187,   35,  342,  301,
 /*  1460 */   187,  303,  346,  347,  358,   35,   35,    0,    0,   35,
 /*  1470 */    35,  187,  260,   35,    0,   35,  187,  371,    0,   22,
 /*  1480 */     0,  375,   35,  172,  260,  170,  328,    0,    0,  165,
 /*  1490 */   332,  333,  334,  335,  336,  337,  338,  339,  340,  341,
 /*  1500 */   288,  166,    0,    0,   46,    0,   42,    0,  296,    0,
 /*  1510 */     0,  149,  288,  301,    0,  303,    0,    0,    0,    0,
 /*  1520 */   296,  144,    0,  144,   35,  301,    0,  303,    0,    0,
 /*  1530 */     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 /*  1540 */   328,  260,    0,   42,  332,  333,  334,  335,  336,  337,
 /*  1550 */     0,  339,  328,   42,   56,    0,  332,  333,  334,  335,
 /*  1560 */   336,  337,    0,  339,    0,  260,  342,   22,    0,  288,
 /*  1570 */     0,  347,    0,    0,  293,    0,    0,  296,    0,    0,
 /*  1580 */    56,    0,  301,  260,  303,    0,   39,   43,  376,  377,
 /*  1590 */     0,   14,   46,  288,   14,   46,   40,   39,  293,    0,
 /*  1600 */     0,  296,    0,  161,   39,    0,  301,    0,  303,  328,
 /*  1610 */     0,  288,    0,  332,  333,  334,  335,  336,  337,  296,
 /*  1620 */   339,   62,    0,   35,  301,   39,  303,    0,   35,   47,
 /*  1630 */    47,   39,    0,  328,   47,   39,   35,  332,  333,  334,
 /*  1640 */   335,  336,  337,    0,  339,  260,   35,   39,    0,    0,
 /*  1650 */    47,  328,    0,    0,    0,  332,  333,  334,  335,  336,
 /*  1660 */   337,   98,  339,  260,   35,   96,   22,   43,   35,   43,
 /*  1670 */    35,   35,   22,  288,    0,    0,    0,   22,   22,   49,
 /*  1680 */    22,  296,   35,    0,    0,    0,  301,   22,  303,   20,
 /*  1690 */     0,  288,   35,  370,   35,   35,    0,  157,  173,  296,
 /*  1700 */    22,    0,    0,    0,  301,  157,  303,    0,  154,  157,
 /*  1710 */   159,    0,   89,  328,   89,  260,    0,  332,  333,  334,
 /*  1720 */   335,  336,  337,  182,  339,    0,  155,   90,   89,   89,
 /*  1730 */    39,  328,   46,  260,   89,  332,  333,  334,  335,  336,
 /*  1740 */   337,   99,  339,  288,  341,   46,  231,  153,  293,   43,
 /*  1750 */    46,  296,   90,   89,  231,   89,  301,  260,  303,   46,
 /*  1760 */    90,  288,  377,   90,   43,   43,  293,   90,   89,  296,
 /*  1770 */    89,   89,   43,   43,  301,   35,  303,   90,   89,   46,
 /*  1780 */    46,   43,   90,  328,   90,  288,  225,  332,  333,  334,
 /*  1790 */   335,  336,  337,  296,  339,   90,   35,  231,  301,   90,
 /*  1800 */   303,  328,   35,   35,   35,  332,  333,  334,  335,  336,
 /*  1810 */   337,   35,  339,  260,    2,   22,   43,   89,   46,   22,
 /*  1820 */    89,  193,   35,   46,   89,  328,   90,  260,   89,  332,
 /*  1830 */   333,  334,  335,  336,  337,   90,  339,   90,   89,   89,
 /*  1840 */    35,  288,  100,   90,   89,   89,  195,   90,   35,  296,
 /*  1850 */    90,   35,   89,   35,  301,  288,  303,   35,   22,  113,
 /*  1860 */    90,   90,   35,  296,   89,  113,  101,   89,  301,  260,
 /*  1870 */   303,  113,  113,   43,   89,   89,   22,   89,   61,  260,
 /*  1880 */    35,  328,   62,   35,   35,  332,  333,  334,  335,  336,
 /*  1890 */   337,   35,  339,   35,   35,  328,   35,  288,   87,  332,
 /*  1900 */   333,  334,  335,  336,  337,  296,  339,  288,   68,   43,
 /*  1910 */   301,   35,  303,   35,   22,  296,   35,   22,   35,   35,
 /*  1920 */   301,  260,  303,   68,   35,   22,   35,    0,   35,   35,
 /*  1930 */     0,   35,   35,   35,   47,   35,    0,  328,   39,   35,
 /*  1940 */    39,  332,  333,  334,  335,  336,  337,  328,  339,  288,
 /*  1950 */    39,  332,  333,  334,  335,  336,  337,  296,  339,   47,
 /*  1960 */    47,    0,  301,   35,  303,   47,    0,   35,   39,   35,
 /*  1970 */     0,   22,   21,   21,  260,   22,   22,   20,  380,  380,
 /*  1980 */   380,  380,  380,  380,  380,  380,  380,  380,  380,  328,
 /*  1990 */   380,  380,  260,  332,  333,  334,  335,  336,  337,  380,
 /*  2000 */   339,  380,  288,  380,  380,  380,  380,  380,  380,  380,
 /*  2010 */   296,  380,  380,  380,  380,  301,  380,  303,  380,  380,
 /*  2020 */   288,  380,  380,  380,  380,  380,  380,  380,  296,  380,
 /*  2030 */   380,  380,  380,  301,  380,  303,  380,  380,  380,  380,
 /*  2040 */   380,  380,  328,  380,  260,  380,  332,  333,  334,  335,
 /*  2050 */   336,  337,  380,  339,  260,  380,  380,  380,  380,  380,
 /*  2060 */   328,  380,  380,  380,  332,  333,  334,  335,  336,  337,
 /*  2070 */   260,  339,  288,  380,  380,  380,  380,  380,  380,  380,
 /*  2080 */   296,  380,  288,  380,  380,  301,  380,  303,  380,  380,
 /*  2090 */   296,  380,  380,  380,  380,  301,  380,  303,  288,  380,
 /*  2100 */   380,  380,  380,  380,  380,  380,  296,  380,  380,  380,
 /*  2110 */   380,  301,  328,  303,  380,  380,  332,  333,  334,  335,
 /*  2120 */   336,  337,  328,  339,  260,  380,  332,  333,  334,  335,
 /*  2130 */   336,  337,  380,  339,  380,  380,  380,  380,  328,  380,
 /*  2140 */   260,  380,  332,  333,  334,  335,  336,  337,  380,  339,
 /*  2150 */   260,  380,  288,  380,  380,  380,  380,  380,  380,  380,
 /*  2160 */   296,  380,  380,  380,  380,  301,  260,  303,  288,  380,
 /*  2170 */   380,  380,  380,  380,  380,  380,  296,  380,  288,  380,
 /*  2180 */   380,  301,  380,  303,  380,  380,  296,  380,  380,  380,
 /*  2190 */   380,  301,  328,  303,  288,  380,  332,  333,  334,  335,
 /*  2200 */   336,  337,  296,  339,  380,  380,  380,  301,  328,  303,
 /*  2210 */   380,  380,  332,  333,  334,  335,  336,  337,  328,  339,
 /*  2220 */   380,  380,  332,  333,  334,  335,  336,  337,  380,  339,
 /*  2230 */   380,  380,  380,  380,  328,  260,  380,  380,  332,  333,
 /*  2240 */   334,  335,  336,  337,  380,  339,  380,  380,  380,  380,
 /*  2250 */   380,  380,  380,  260,  380,  380,  380,  380,  380,  380,
 /*  2260 */   380,  380,  380,  288,  380,  380,  380,  380,  380,  380,
 /*  2270 */   380,  296,  380,  380,  380,  380,  301,  380,  303,  380,
 /*  2280 */   380,  288,  380,  380,  380,  380,  380,  380,  380,  296,
 /*  2290 */   380,  380,  380,  380,  301,  380,  303,  380,  380,  380,
 /*  2300 */   380,  380,  380,  328,  380,  260,  380,  332,  333,  334,
 /*  2310 */   335,  336,  337,  380,  339,  260,  380,  380,  380,  380,
 /*  2320 */   380,  328,  380,  380,  380,  332,  333,  334,  335,  336,
 /*  2330 */   337,  380,  339,  288,  380,  380,  380,  380,  380,  380,
 /*  2340 */   380,  296,  380,  288,  380,  380,  301,  380,  303,  380,
 /*  2350 */   380,  296,  380,  380,  380,  380,  301,  380,  303,  380,
 /*  2360 */   380,  380,  380,  380,  380,  380,  380,  380,  380,  380,
 /*  2370 */   380,  380,  380,  328,  380,  380,  380,  332,  333,  334,
 /*  2380 */   335,  336,  337,  328,  339,  380,  380,  332,  333,  334,
 /*  2390 */   335,  336,  337,  380,  339,
};
#define YY_SHIFT_COUNT    (665)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1970)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   917,    0,    0,   62,   62,  264,  264,  264,  326,  326,
 /*    10 */   264,  264,  391,  593,  720,  593,  593,  593,  593,  593,
 /*    20 */   593,  593,  593,  593,  593,  593,  593,  593,  593,  593,
 /*    30 */   593,  593,  593,  593,  593,  593,  593,  593,  593,  593,
 /*    40 */   593,  593,  313,  313,  199,  199,  199,  987,  987,  354,
 /*    50 */   987,  987,  165,  341,  254,  258,  254,   79,   79,   36,
 /*    60 */    36,   97,   18,  254,  254,   79,   79,   79,   79,   79,
 /*    70 */    79,   79,   79,   79,   82,   79,   79,   79,  170,   79,
 /*    80 */   205,   79,   79,  205,  405,   79,  205,  205,  205,   79,
 /*    90 */   158,  719,  662,  683,  683,  108,  371,  371,  371,  371,
 /*   100 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*   110 */   371,  371,  371,  371,  371,  134,  419,   18,  636,  636,
 /*   120 */   488,  551,  562,   90,   90,   90,  551,  526,  526,  170,
 /*   130 */    16,   16,  205,  205,  323,  323,  483,  498,  198,  198,
 /*   140 */   198,  198,  198,  198,  198,  331,   21,  167,  559,   43,
 /*   150 */    50,  112,  168,   99,  421,   19,  530,  771,  755,  717,
 /*   160 */   603,  717,  918,  501,  501,  501,  869,  822,  950, 1139,
 /*   170 */  1023, 1148, 1182, 1182, 1148, 1054, 1054, 1182, 1182, 1182,
 /*   180 */  1215, 1215, 1218,   82,  170,   82, 1225, 1226,   82, 1225,
 /*   190 */    82, 1234,   82,   82, 1182,   82, 1215,  205,  205,  205,
 /*   200 */   205,  205,  205,  205,  205,  205,  205,  205, 1182, 1215,
 /*   210 */   323, 1218,  158, 1112,  170,  158, 1182, 1182, 1225,  158,
 /*   220 */  1071,  323,  323,  323,  323, 1071,  323, 1152, 1234,  158,
 /*   230 */   483,  158,  526, 1287,  323, 1118, 1071,  323,  323, 1118,
 /*   240 */  1071,  323,  323,  205, 1114, 1199, 1118, 1119, 1125, 1138,
 /*   250 */   950, 1143,  526, 1352, 1127, 1130, 1128, 1127, 1130, 1127,
 /*   260 */  1130, 1288, 1291,  323,  498, 1182,  158, 1360, 1215, 2395,
 /*   270 */  2395, 2395, 2395, 2395, 2395, 2395,   83,  456,  214,  307,
 /*   280 */   208,  564,  693,  808,  824, 1044, 1053,  513,  542,  542,
 /*   290 */   542,  542,  542,  542,  542,  542,  545,  129,   13,   13,
 /*   300 */   236,  594,  430,  581,  387,  172,  452,  511,  106,  106,
 /*   310 */   106,  106,  914,  963,  875,  898,  943,  945,  973,  979,
 /*   320 */  1011,  423,  860,  960,  964,  997, 1002, 1021, 1059, 1070,
 /*   330 */  1022,  947,  962,  937, 1006,  904, 1058,  929, 1097, 1043,
 /*   340 */  1109, 1115, 1122, 1131, 1132, 1135, 1005, 1077, 1126, 1098,
 /*   350 */   764, 1421, 1425, 1253, 1432, 1433, 1393, 1436, 1422, 1269,
 /*   360 */  1430, 1431, 1434, 1273, 1467, 1435, 1438, 1284, 1468, 1289,
 /*   370 */  1474, 1440, 1478, 1457, 1480, 1447, 1311, 1315, 1487, 1488,
 /*   380 */  1335, 1324, 1502, 1503, 1458, 1505, 1464, 1507, 1509, 1510,
 /*   390 */  1362, 1514, 1516, 1517, 1518, 1519, 1377, 1489, 1522, 1379,
 /*   400 */  1526, 1528, 1529, 1530, 1531, 1532, 1533, 1534, 1535, 1536,
 /*   410 */  1537, 1538, 1539, 1542, 1501, 1550, 1562, 1564, 1570, 1572,
 /*   420 */  1573, 1545, 1568, 1575, 1576, 1578, 1579, 1498, 1555, 1524,
 /*   430 */  1581, 1585, 1511, 1547, 1544, 1577, 1546, 1580, 1549, 1590,
 /*   440 */  1556, 1558, 1599, 1600, 1602, 1565, 1442, 1605, 1607, 1610,
 /*   450 */  1559, 1612, 1622, 1588, 1582, 1586, 1627, 1593, 1583, 1592,
 /*   460 */  1632, 1601, 1587, 1596, 1643, 1611, 1603, 1608, 1648, 1649,
 /*   470 */  1652, 1653, 1563, 1569, 1629, 1644, 1654, 1633, 1624, 1626,
 /*   480 */  1635, 1636, 1650, 1674, 1655, 1675, 1656, 1630, 1676, 1658,
 /*   490 */  1647, 1683, 1657, 1684, 1659, 1685, 1665, 1669, 1690, 1540,
 /*   500 */  1660, 1696, 1525, 1678, 1548, 1554, 1701, 1702, 1552, 1551,
 /*   510 */  1703, 1707, 1711, 1623, 1637, 1541, 1716, 1625, 1571, 1639,
 /*   520 */  1725, 1691, 1594, 1640, 1642, 1686, 1706, 1515, 1645, 1662,
 /*   530 */  1664, 1670, 1673, 1666, 1721, 1677, 1679, 1681, 1682, 1687,
 /*   540 */  1722, 1699, 1704, 1689, 1729, 1523, 1692, 1694, 1713, 1561,
 /*   550 */  1730, 1733, 1734, 1705, 1738, 1566, 1709, 1740, 1761, 1767,
 /*   560 */  1768, 1769, 1776, 1709, 1812, 1793, 1628, 1773, 1728, 1736,
 /*   570 */  1731, 1745, 1735, 1747, 1772, 1739, 1749, 1777, 1797, 1651,
 /*   580 */  1750, 1742, 1753, 1787, 1805, 1755, 1757, 1813, 1756, 1760,
 /*   590 */  1816, 1763, 1770, 1818, 1775, 1771, 1822, 1778, 1746, 1752,
 /*   600 */  1758, 1759, 1836, 1765, 1785, 1786, 1827, 1788, 1830, 1830,
 /*   610 */  1854, 1820, 1817, 1845, 1848, 1849, 1856, 1858, 1859, 1861,
 /*   620 */  1840, 1811, 1866, 1876, 1878, 1892, 1881, 1895, 1883, 1884,
 /*   630 */  1855, 1624, 1889, 1626, 1891, 1893, 1894, 1896, 1903, 1897,
 /*   640 */  1927, 1898, 1887, 1899, 1930, 1900, 1912, 1901, 1936, 1904,
 /*   650 */  1913, 1911, 1961, 1928, 1918, 1929, 1966, 1932, 1934, 1970,
 /*   660 */  1949, 1951, 1953, 1954, 1952, 1957,
};
#define YY_REDUCE_COUNT (275)
#define YY_REDUCE_MIN   (-357)
#define YY_REDUCE_MAX   (2055)
static const short yy_reduce_ofst[] = {
 /*     0 */   -80, -230,  650,  782,  881,  923,  976,  993, 1056, 1106,
 /*    10 */    34, 1116, 1158, 1212, 1224, 1281, 1305, 1323, 1385, 1403,
 /*    20 */  1455, 1473,  351, 1497, 1553, 1567, 1609, 1619, 1661, 1714,
 /*    30 */  1732, 1784, 1794, 1810, 1864, 1880, 1890, 1906, 1975, 1993,
 /*    40 */  2045, 2055,  376,  676, -259,   76,  142,  117,  687, -180,
 /*    50 */  -284,  747,  -30,  250,  342,  345,  398,  359,  462, -264,
 /*    60 */  -256, -357, -240, -339, -244,   81,  385,  475,  666,  668,
 /*    70 */   669,  673,  702,  734,  148,  767,  803,  852, -280,  855,
 /*    80 */  -273,  857,  858,  211,   31,  859,  272,  523,  363,  867,
 /*    90 */  -205,  -20, -159, -159, -159, -171,  -86,   95,  139,  149,
 /*   100 */   388,  413,  420,  466,  476,  512,  514,  524,  548,  570,
 /*   110 */   574,  588,  608,  614,  648, -233, -213, -298,  -76,   53,
 /*   120 */  -215,  174,  279,  408,  431,  557,  217,   35,  275,  317,
 /*   130 */   409,  467,   91,  540,  590,  595,  675,  565,  328,  340,
 /*   140 */   368,  461,  468,  606,  661,  373,  705,  654,  800,  722,
 /*   150 */   819,  777,  730,  868,  868,  876,  880,  862,  833,  811,
 /*   160 */   811,  811,  821,  796,  799,  801,  813,  868,  850,  863,
 /*   170 */   870,  892,  935,  936,  899,  925,  926,  942,  965,  966,
 /*   180 */   975,  977,  919,  968,  938,  971,  928,  930,  978,  931,
 /*   190 */   980,  952,  991,  994,  999,  996, 1012,  985,  988,  990,
 /*   200 */   995,  998, 1000, 1003, 1004, 1007, 1009, 1010, 1014, 1013,
 /*   210 */   983,  967, 1015,  981, 1016, 1029, 1025, 1032,  986, 1031,
 /*   220 */  1008, 1030, 1033, 1035, 1036, 1026, 1041, 1037, 1034, 1047,
 /*   230 */  1061, 1076, 1018, 1017, 1048,  992, 1039, 1057, 1060, 1001,
 /*   240 */  1042, 1062, 1063,  868, 1019, 1040, 1046, 1020, 1038, 1024,
 /*   250 */  1045,  811, 1074, 1049, 1027, 1051, 1050, 1052, 1055, 1073,
 /*   260 */  1064, 1066, 1089, 1081, 1120, 1129, 1117, 1136, 1141, 1085,
 /*   270 */  1093, 1133, 1134, 1140, 1142, 1162,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*    10 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*    20 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*    30 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*    40 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*    50 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*    60 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*    70 */  1465, 1465, 1465, 1465, 1539, 1465, 1465, 1465, 1465, 1465,
 /*    80 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*    90 */  1537, 1695, 1465, 1873, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   100 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   110 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   120 */  1539, 1465, 1537, 1885, 1885, 1885, 1465, 1465, 1465, 1465,
 /*   130 */  1738, 1738, 1465, 1465, 1465, 1465, 1637, 1465, 1465, 1465,
 /*   140 */  1465, 1465, 1465, 1465, 1465, 1730, 1465, 1954, 1465, 1465,
 /*   150 */  1465, 1736, 1908, 1465, 1465, 1465, 1465, 1590, 1900, 1877,
 /*   160 */  1891, 1878, 1875, 1939, 1939, 1939, 1894, 1465, 1904, 1465,
 /*   170 */  1723, 1700, 1465, 1465, 1700, 1697, 1697, 1465, 1465, 1465,
 /*   180 */  1465, 1465, 1465, 1539, 1465, 1539, 1465, 1465, 1539, 1465,
 /*   190 */  1539, 1465, 1539, 1539, 1465, 1539, 1465, 1465, 1465, 1465,
 /*   200 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   210 */  1465, 1465, 1537, 1732, 1465, 1537, 1465, 1465, 1465, 1537,
 /*   220 */  1913, 1465, 1465, 1465, 1465, 1913, 1465, 1465, 1465, 1537,
 /*   230 */  1465, 1537, 1465, 1465, 1465, 1915, 1913, 1465, 1465, 1915,
 /*   240 */  1913, 1465, 1465, 1465, 1927, 1923, 1915, 1931, 1929, 1906,
 /*   250 */  1904, 1891, 1465, 1465, 1945, 1941, 1957, 1945, 1941, 1945,
 /*   260 */  1941, 1465, 1606, 1465, 1465, 1465, 1537, 1497, 1465, 1725,
 /*   270 */  1738, 1640, 1640, 1640, 1540, 1470, 1465, 1465, 1465, 1465,
 /*   280 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1810, 1926,
 /*   290 */  1925, 1849, 1848, 1847, 1845, 1809, 1465, 1602, 1808, 1807,
 /*   300 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1801, 1802,
 /*   310 */  1800, 1799, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   320 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   330 */  1874, 1465, 1942, 1946, 1465, 1465, 1465, 1465, 1465, 1784,
 /*   340 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   350 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   360 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   370 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   380 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   390 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   400 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   410 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   420 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   430 */  1465, 1465, 1465, 1465, 1502, 1465, 1465, 1465, 1465, 1465,
 /*   440 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   450 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   460 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   470 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1574, 1573,
 /*   480 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   490 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   500 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   510 */  1465, 1465, 1465, 1465, 1465, 1465, 1742, 1465, 1465, 1465,
 /*   520 */  1465, 1465, 1465, 1465, 1465, 1465, 1907, 1465, 1465, 1465,
 /*   530 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   540 */  1465, 1465, 1784, 1465, 1924, 1465, 1884, 1880, 1465, 1465,
 /*   550 */  1876, 1783, 1465, 1465, 1940, 1465, 1465, 1465, 1465, 1465,
 /*   560 */  1465, 1465, 1465, 1465, 1869, 1465, 1465, 1842, 1827, 1465,
 /*   570 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1795,
 /*   580 */  1465, 1465, 1465, 1465, 1465, 1634, 1465, 1465, 1465, 1465,
 /*   590 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1619, 1617,
 /*   600 */  1616, 1615, 1465, 1612, 1465, 1465, 1465, 1465, 1643, 1642,
 /*   610 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   620 */  1465, 1465, 1558, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   630 */  1465, 1550, 1465, 1549, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   640 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   650 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   660 */  1465, 1465, 1465, 1465, 1465, 1465,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  251,  /*  NK_BITNOT => ID */
  251,  /*     VALUES => ID */
  251,  /*     IMPORT => ID */
  251,  /*    NK_SEMI => ID */
  251,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "MAXROWS",
  /*   70 */ "MINROWS",
  /*   71 */ "KEEP",
  /*   72 */ "PAGES",
  /*   73 */ "PAGESIZE",
  /*   74 */ "PRECISION",
  /*   75 */ "REPLICA",
  /*   76 */ "STRICT",
  /*   77 */ "VGROUPS",
  /*   78 */ "SINGLE_STABLE",
  /*   79 */ "RETENTIONS",
  /*   80 */ "SCHEMALESS",
  /*   81 */ "WAL_LEVEL",
  /*   82 */ "WAL_FSYNC_PERIOD",
  /*   83 */ "WAL_RETENTION_PERIOD",
  /*   84 */ "WAL_RETENTION_SIZE",
  /*   85 */ "WAL_ROLL_PERIOD",
  /*   86 */ "WAL_SEGMENT_SIZE",
  /*   87 */ "NK_COLON",
  /*   88 */ "TABLE",
  /*   89 */ "NK_LP",
  /*   90 */ "NK_RP",
  /*   91 */ "STABLE",
  /*   92 */ "ADD",
  /*   93 */ "COLUMN",
  /*   94 */ "MODIFY",
  /*   95 */ "RENAME",
  /*   96 */ "TAG",
  /*   97 */ "SET",
  /*   98 */ "NK_EQ",
  /*   99 */ "USING",
  /*  100 */ "TAGS",
  /*  101 */ "COMMENT",
  /*  102 */ "BOOL",
  /*  103 */ "TINYINT",
  /*  104 */ "SMALLINT",
  /*  105 */ "INT",
  /*  106 */ "INTEGER",
  /*  107 */ "BIGINT",
  /*  108 */ "FLOAT",
  /*  109 */ "DOUBLE",
  /*  110 */ "BINARY",
  /*  111 */ "TIMESTAMP",
  /*  112 */ "NCHAR",
  /*  113 */ "UNSIGNED",
  /*  114 */ "JSON",
  /*  115 */ "VARCHAR",
  /*  116 */ "MEDIUMBLOB",
  /*  117 */ "BLOB",
  /*  118 */ "VARBINARY",
  /*  119 */ "DECIMAL",
  /*  120 */ "MAX_DELAY",
  /*  121 */ "WATERMARK",
  /*  122 */ "ROLLUP",
  /*  123 */ "TTL",
  /*  124 */ "SMA",
  /*  125 */ "FIRST",
  /*  126 */ "LAST",
  /*  127 */ "SHOW",
  /*  128 */ "DATABASES",
  /*  129 */ "TABLES",
  /*  130 */ "STABLES",
  /*  131 */ "MNODES",
  /*  132 */ "MODULES",
  /*  133 */ "QNODES",
  /*  134 */ "FUNCTIONS",
  /*  135 */ "INDEXES",
  /*  136 */ "ACCOUNTS",
  /*  137 */ "APPS",
  /*  138 */ "CONNECTIONS",
  /*  139 */ "LICENCE",
  /*  140 */ "GRANTS",
  /*  141 */ "QUERIES",
  /*  142 */ "SCORES",
  /*  143 */ "TOPICS",
  /*  144 */ "VARIABLES",
  /*  145 */ "BNODES",
  /*  146 */ "SNODES",
  /*  147 */ "CLUSTER",
  /*  148 */ "TRANSACTIONS",
  /*  149 */ "DISTRIBUTED",
  /*  150 */ "CONSUMERS",
  /*  151 */ "SUBSCRIPTIONS",
  /*  152 */ "LIKE",
  /*  153 */ "INDEX",
  /*  154 */ "FUNCTION",
  /*  155 */ "INTERVAL",
  /*  156 */ "TOPIC",
  /*  157 */ "AS",
  /*  158 */ "WITH",
  /*  159 */ "META",
  /*  160 */ "CONSUMER",
  /*  161 */ "GROUP",
  /*  162 */ "DESC",
  /*  163 */ "DESCRIBE",
  /*  164 */ "RESET",
  /*  165 */ "QUERY",
  /*  166 */ "CACHE",
  /*  167 */ "EXPLAIN",
  /*  168 */ "ANALYZE",
  /*  169 */ "VERBOSE",
  /*  170 */ "NK_BOOL",
  /*  171 */ "RATIO",
  /*  172 */ "NK_FLOAT",
  /*  173 */ "OUTPUTTYPE",
  /*  174 */ "AGGREGATE",
  /*  175 */ "BUFSIZE",
  /*  176 */ "STREAM",
  /*  177 */ "INTO",
  /*  178 */ "TRIGGER",
  /*  179 */ "AT_ONCE",
  /*  180 */ "WINDOW_CLOSE",
  /*  181 */ "IGNORE",
  /*  182 */ "EXPIRED",
  /*  183 */ "KILL",
  /*  184 */ "CONNECTION",
  /*  185 */ "TRANSACTION",
  /*  186 */ "BALANCE",
  /*  187 */ "VGROUP",
  /*  188 */ "MERGE",
  /*  189 */ "REDISTRIBUTE",
  /*  190 */ "SPLIT",
  /*  191 */ "DELETE",
  /*  192 */ "INSERT",
  /*  193 */ "NULL",
  /*  194 */ "NK_QUESTION",
  /*  195 */ "NK_ARROW",
  /*  196 */ "ROWTS",
  /*  197 */ "TBNAME",
  /*  198 */ "QSTART",
  /*  199 */ "QEND",
  /*  200 */ "QDURATION",
  /*  201 */ "WSTART",
  /*  202 */ "WEND",
  /*  203 */ "WDURATION",
  /*  204 */ "CAST",
  /*  205 */ "NOW",
  /*  206 */ "TODAY",
  /*  207 */ "TIMEZONE",
  /*  208 */ "CLIENT_VERSION",
  /*  209 */ "SERVER_VERSION",
  /*  210 */ "SERVER_STATUS",
  /*  211 */ "CURRENT_USER",
  /*  212 */ "COUNT",
  /*  213 */ "LAST_ROW",
  /*  214 */ "BETWEEN",
  /*  215 */ "IS",
  /*  216 */ "NK_LT",
  /*  217 */ "NK_GT",
  /*  218 */ "NK_LE",
  /*  219 */ "NK_GE",
  /*  220 */ "NK_NE",
  /*  221 */ "MATCH",
  /*  222 */ "NMATCH",
  /*  223 */ "CONTAINS",
  /*  224 */ "IN",
  /*  225 */ "JOIN",
  /*  226 */ "INNER",
  /*  227 */ "SELECT",
  /*  228 */ "DISTINCT",
  /*  229 */ "WHERE",
  /*  230 */ "PARTITION",
  /*  231 */ "BY",
  /*  232 */ "SESSION",
  /*  233 */ "STATE_WINDOW",
  /*  234 */ "SLIDING",
  /*  235 */ "FILL",
  /*  236 */ "VALUE",
  /*  237 */ "NONE",
  /*  238 */ "PREV",
  /*  239 */ "LINEAR",
  /*  240 */ "NEXT",
  /*  241 */ "HAVING",
  /*  242 */ "RANGE",
  /*  243 */ "EVERY",
  /*  244 */ "ORDER",
  /*  245 */ "SLIMIT",
  /*  246 */ "SOFFSET",
  /*  247 */ "LIMIT",
  /*  248 */ "OFFSET",
  /*  249 */ "ASC",
  /*  250 */ "NULLS",
  /*  251 */ "ID",
  /*  252 */ "NK_BITNOT",
  /*  253 */ "VALUES",
  /*  254 */ "IMPORT",
  /*  255 */ "NK_SEMI",
  /*  256 */ "FILE",
  /*  257 */ "cmd",
  /*  258 */ "account_options",
  /*  259 */ "alter_account_options",
  /*  260 */ "literal",
  /*  261 */ "alter_account_option",
  /*  262 */ "user_name",
  /*  263 */ "sysinfo_opt",
  /*  264 */ "privileges",
  /*  265 */ "priv_level",
  /*  266 */ "priv_type_list",
  /*  267 */ "priv_type",
  /*  268 */ "db_name",
  /*  269 */ "dnode_endpoint",
  /*  270 */ "not_exists_opt",
  /*  271 */ "db_options",
  /*  272 */ "exists_opt",
  /*  273 */ "alter_db_options",
  /*  274 */ "integer_list",
  /*  275 */ "variable_list",
  /*  276 */ "retention_list",
  /*  277 */ "alter_db_option",
  /*  278 */ "retention",
  /*  279 */ "full_table_name",
  /*  280 */ "column_def_list",
  /*  281 */ "tags_def_opt",
  /*  282 */ "table_options",
  /*  283 */ "multi_create_clause",
  /*  284 */ "tags_def",
  /*  285 */ "multi_drop_clause",
  /*  286 */ "alter_table_clause",
  /*  287 */ "alter_table_options",
  /*  288 */ "column_name",
  /*  289 */ "type_name",
  /*  290 */ "signed_literal",
  /*  291 */ "create_subtable_clause",
  /*  292 */ "specific_cols_opt",
  /*  293 */ "expression_list",
  /*  294 */ "drop_table_clause",
  /*  295 */ "col_name_list",
  /*  296 */ "table_name",
  /*  297 */ "column_def",
  /*  298 */ "duration_list",
  /*  299 */ "rollup_func_list",
  /*  300 */ "alter_table_option",
  /*  301 */ "duration_literal",
  /*  302 */ "rollup_func_name",
  /*  303 */ "function_name",
  /*  304 */ "col_name",
  /*  305 */ "db_name_cond_opt",
  /*  306 */ "like_pattern_opt",
  /*  307 */ "table_name_cond",
  /*  308 */ "from_db_opt",
  /*  309 */ "index_name",
  /*  310 */ "index_options",
  /*  311 */ "func_list",
  /*  312 */ "sliding_opt",
  /*  313 */ "sma_stream_opt",
  /*  314 */ "func",
  /*  315 */ "stream_options",
  /*  316 */ "topic_name",
  /*  317 */ "query_expression",
  /*  318 */ "cgroup_name",
  /*  319 */ "analyze_opt",
  /*  320 */ "explain_options",
  /*  321 */ "agg_func_opt",
  /*  322 */ "bufsize_opt",
  /*  323 */ "stream_name",
  /*  324 */ "into_opt",
  /*  325 */ "dnode_list",
  /*  326 */ "where_clause_opt",
  /*  327 */ "signed",
  /*  328 */ "literal_func",
  /*  329 */ "literal_list",
  /*  330 */ "table_alias",
  /*  331 */ "column_alias",
  /*  332 */ "expression",
  /*  333 */ "pseudo_column",
  /*  334 */ "column_reference",
  /*  335 */ "function_expression",
  /*  336 */ "subquery",
  /*  337 */ "star_func",
  /*  338 */ "star_func_para_list",
  /*  339 */ "noarg_func",
  /*  340 */ "other_para_list",
  /*  341 */ "star_func_para",
  /*  342 */ "predicate",
  /*  343 */ "compare_op",
  /*  344 */ "in_op",
  /*  345 */ "in_predicate_value",
  /*  346 */ "boolean_value_expression",
  /*  347 */ "boolean_primary",
  /*  348 */ "common_expression",
  /*  349 */ "from_clause_opt",
  /*  350 */ "table_reference_list",
  /*  351 */ "table_reference",
  /*  352 */ "table_primary",
  /*  353 */ "joined_table",
  /*  354 */ "alias_opt",
  /*  355 */ "parenthesized_joined_table",
  /*  356 */ "join_type",
  /*  357 */ "search_condition",
  /*  358 */ "query_specification",
  /*  359 */ "set_quantifier_opt",
  /*  360 */ "select_list",
  /*  361 */ "partition_by_clause_opt",
  /*  362 */ "range_opt",
  /*  363 */ "every_opt",
  /*  364 */ "fill_opt",
  /*  365 */ "twindow_clause_opt",
  /*  366 */ "group_by_clause_opt",
  /*  367 */ "having_clause_opt",
  /*  368 */ "select_item",
  /*  369 */ "fill_mode",
  /*  370 */ "group_by_list",
  /*  371 */ "query_expression_body",
  /*  372 */ "order_by_clause_opt",
  /*  373 */ "slimit_clause_opt",
  /*  374 */ "limit_clause_opt",
  /*  375 */ "query_primary",
  /*  376 */ "sort_specification_list",
  /*  377 */ "sort_specification",
  /*  378 */ "ordering_specification_opt",
  /*  379 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options KEEP integer_list",
 /*  82 */ "db_options ::= db_options KEEP variable_list",
 /*  83 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  84 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  85 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  86 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  87 */ "db_options ::= db_options STRICT NK_STRING",
 /*  88 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  89 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  90 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  91 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  92 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  93 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  94 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 100 */ "alter_db_options ::= alter_db_option",
 /* 101 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 102 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 103 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 104 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 105 */ "alter_db_option ::= KEEP integer_list",
 /* 106 */ "alter_db_option ::= KEEP variable_list",
 /* 107 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 108 */ "integer_list ::= NK_INTEGER",
 /* 109 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 110 */ "variable_list ::= NK_VARIABLE",
 /* 111 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 112 */ "retention_list ::= retention",
 /* 113 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 114 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 115 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 116 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 117 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 118 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 119 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 120 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 121 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 122 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 123 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 124 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 125 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 126 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 127 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 128 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 129 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 130 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 131 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 132 */ "multi_create_clause ::= create_subtable_clause",
 /* 133 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 134 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 135 */ "multi_drop_clause ::= drop_table_clause",
 /* 136 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 137 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 138 */ "specific_cols_opt ::=",
 /* 139 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 140 */ "full_table_name ::= table_name",
 /* 141 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 142 */ "column_def_list ::= column_def",
 /* 143 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 144 */ "column_def ::= column_name type_name",
 /* 145 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 146 */ "type_name ::= BOOL",
 /* 147 */ "type_name ::= TINYINT",
 /* 148 */ "type_name ::= SMALLINT",
 /* 149 */ "type_name ::= INT",
 /* 150 */ "type_name ::= INTEGER",
 /* 151 */ "type_name ::= BIGINT",
 /* 152 */ "type_name ::= FLOAT",
 /* 153 */ "type_name ::= DOUBLE",
 /* 154 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 155 */ "type_name ::= TIMESTAMP",
 /* 156 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= TINYINT UNSIGNED",
 /* 158 */ "type_name ::= SMALLINT UNSIGNED",
 /* 159 */ "type_name ::= INT UNSIGNED",
 /* 160 */ "type_name ::= BIGINT UNSIGNED",
 /* 161 */ "type_name ::= JSON",
 /* 162 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 163 */ "type_name ::= MEDIUMBLOB",
 /* 164 */ "type_name ::= BLOB",
 /* 165 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 166 */ "type_name ::= DECIMAL",
 /* 167 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 169 */ "tags_def_opt ::=",
 /* 170 */ "tags_def_opt ::= tags_def",
 /* 171 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 172 */ "table_options ::=",
 /* 173 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 174 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 175 */ "table_options ::= table_options WATERMARK duration_list",
 /* 176 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 177 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 178 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 179 */ "alter_table_options ::= alter_table_option",
 /* 180 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 181 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 182 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 183 */ "duration_list ::= duration_literal",
 /* 184 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 185 */ "rollup_func_list ::= rollup_func_name",
 /* 186 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 187 */ "rollup_func_name ::= function_name",
 /* 188 */ "rollup_func_name ::= FIRST",
 /* 189 */ "rollup_func_name ::= LAST",
 /* 190 */ "col_name_list ::= col_name",
 /* 191 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 192 */ "col_name ::= column_name",
 /* 193 */ "cmd ::= SHOW DNODES",
 /* 194 */ "cmd ::= SHOW USERS",
 /* 195 */ "cmd ::= SHOW DATABASES",
 /* 196 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 197 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 198 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 199 */ "cmd ::= SHOW MNODES",
 /* 200 */ "cmd ::= SHOW MODULES",
 /* 201 */ "cmd ::= SHOW QNODES",
 /* 202 */ "cmd ::= SHOW FUNCTIONS",
 /* 203 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 204 */ "cmd ::= SHOW STREAMS",
 /* 205 */ "cmd ::= SHOW ACCOUNTS",
 /* 206 */ "cmd ::= SHOW APPS",
 /* 207 */ "cmd ::= SHOW CONNECTIONS",
 /* 208 */ "cmd ::= SHOW LICENCE",
 /* 209 */ "cmd ::= SHOW GRANTS",
 /* 210 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 211 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 212 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 213 */ "cmd ::= SHOW QUERIES",
 /* 214 */ "cmd ::= SHOW SCORES",
 /* 215 */ "cmd ::= SHOW TOPICS",
 /* 216 */ "cmd ::= SHOW VARIABLES",
 /* 217 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 218 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 219 */ "cmd ::= SHOW BNODES",
 /* 220 */ "cmd ::= SHOW SNODES",
 /* 221 */ "cmd ::= SHOW CLUSTER",
 /* 222 */ "cmd ::= SHOW TRANSACTIONS",
 /* 223 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 224 */ "cmd ::= SHOW CONSUMERS",
 /* 225 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 226 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 227 */ "db_name_cond_opt ::=",
 /* 228 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 229 */ "like_pattern_opt ::=",
 /* 230 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 231 */ "table_name_cond ::= table_name",
 /* 232 */ "from_db_opt ::=",
 /* 233 */ "from_db_opt ::= FROM db_name",
 /* 234 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON full_table_name index_options",
 /* 235 */ "cmd ::= DROP INDEX exists_opt index_name",
 /* 236 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 237 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 238 */ "func_list ::= func",
 /* 239 */ "func_list ::= func_list NK_COMMA func",
 /* 240 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 241 */ "sma_stream_opt ::=",
 /* 242 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 243 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 244 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 245 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 246 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 247 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 248 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 249 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 250 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 251 */ "cmd ::= DESC full_table_name",
 /* 252 */ "cmd ::= DESCRIBE full_table_name",
 /* 253 */ "cmd ::= RESET QUERY CACHE",
 /* 254 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 255 */ "analyze_opt ::=",
 /* 256 */ "analyze_opt ::= ANALYZE",
 /* 257 */ "explain_options ::=",
 /* 258 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 259 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 260 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 261 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 262 */ "agg_func_opt ::=",
 /* 263 */ "agg_func_opt ::= AGGREGATE",
 /* 264 */ "bufsize_opt ::=",
 /* 265 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 266 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 267 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 268 */ "into_opt ::=",
 /* 269 */ "into_opt ::= INTO full_table_name",
 /* 270 */ "stream_options ::=",
 /* 271 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 272 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 273 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 274 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 275 */ "stream_options ::= stream_options IGNORE EXPIRED",
 /* 276 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 277 */ "cmd ::= KILL QUERY NK_STRING",
 /* 278 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 279 */ "cmd ::= BALANCE VGROUP",
 /* 280 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 281 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 282 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 283 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 284 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 285 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 286 */ "cmd ::= query_expression",
 /* 287 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression",
 /* 288 */ "cmd ::= INSERT INTO full_table_name query_expression",
 /* 289 */ "literal ::= NK_INTEGER",
 /* 290 */ "literal ::= NK_FLOAT",
 /* 291 */ "literal ::= NK_STRING",
 /* 292 */ "literal ::= NK_BOOL",
 /* 293 */ "literal ::= TIMESTAMP NK_STRING",
 /* 294 */ "literal ::= duration_literal",
 /* 295 */ "literal ::= NULL",
 /* 296 */ "literal ::= NK_QUESTION",
 /* 297 */ "duration_literal ::= NK_VARIABLE",
 /* 298 */ "signed ::= NK_INTEGER",
 /* 299 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 300 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 301 */ "signed ::= NK_FLOAT",
 /* 302 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 303 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 304 */ "signed_literal ::= signed",
 /* 305 */ "signed_literal ::= NK_STRING",
 /* 306 */ "signed_literal ::= NK_BOOL",
 /* 307 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 308 */ "signed_literal ::= duration_literal",
 /* 309 */ "signed_literal ::= NULL",
 /* 310 */ "signed_literal ::= literal_func",
 /* 311 */ "signed_literal ::= NK_QUESTION",
 /* 312 */ "literal_list ::= signed_literal",
 /* 313 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 314 */ "db_name ::= NK_ID",
 /* 315 */ "table_name ::= NK_ID",
 /* 316 */ "column_name ::= NK_ID",
 /* 317 */ "function_name ::= NK_ID",
 /* 318 */ "table_alias ::= NK_ID",
 /* 319 */ "column_alias ::= NK_ID",
 /* 320 */ "user_name ::= NK_ID",
 /* 321 */ "index_name ::= NK_ID",
 /* 322 */ "topic_name ::= NK_ID",
 /* 323 */ "stream_name ::= NK_ID",
 /* 324 */ "cgroup_name ::= NK_ID",
 /* 325 */ "expression ::= literal",
 /* 326 */ "expression ::= pseudo_column",
 /* 327 */ "expression ::= column_reference",
 /* 328 */ "expression ::= function_expression",
 /* 329 */ "expression ::= subquery",
 /* 330 */ "expression ::= NK_LP expression NK_RP",
 /* 331 */ "expression ::= NK_PLUS expression",
 /* 332 */ "expression ::= NK_MINUS expression",
 /* 333 */ "expression ::= expression NK_PLUS expression",
 /* 334 */ "expression ::= expression NK_MINUS expression",
 /* 335 */ "expression ::= expression NK_STAR expression",
 /* 336 */ "expression ::= expression NK_SLASH expression",
 /* 337 */ "expression ::= expression NK_REM expression",
 /* 338 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 339 */ "expression ::= expression NK_BITAND expression",
 /* 340 */ "expression ::= expression NK_BITOR expression",
 /* 341 */ "expression_list ::= expression",
 /* 342 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 343 */ "column_reference ::= column_name",
 /* 344 */ "column_reference ::= table_name NK_DOT column_name",
 /* 345 */ "pseudo_column ::= ROWTS",
 /* 346 */ "pseudo_column ::= TBNAME",
 /* 347 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 348 */ "pseudo_column ::= QSTART",
 /* 349 */ "pseudo_column ::= QEND",
 /* 350 */ "pseudo_column ::= QDURATION",
 /* 351 */ "pseudo_column ::= WSTART",
 /* 352 */ "pseudo_column ::= WEND",
 /* 353 */ "pseudo_column ::= WDURATION",
 /* 354 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 355 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 356 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 357 */ "function_expression ::= literal_func",
 /* 358 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 359 */ "literal_func ::= NOW",
 /* 360 */ "noarg_func ::= NOW",
 /* 361 */ "noarg_func ::= TODAY",
 /* 362 */ "noarg_func ::= TIMEZONE",
 /* 363 */ "noarg_func ::= DATABASE",
 /* 364 */ "noarg_func ::= CLIENT_VERSION",
 /* 365 */ "noarg_func ::= SERVER_VERSION",
 /* 366 */ "noarg_func ::= SERVER_STATUS",
 /* 367 */ "noarg_func ::= CURRENT_USER",
 /* 368 */ "noarg_func ::= USER",
 /* 369 */ "star_func ::= COUNT",
 /* 370 */ "star_func ::= FIRST",
 /* 371 */ "star_func ::= LAST",
 /* 372 */ "star_func ::= LAST_ROW",
 /* 373 */ "star_func_para_list ::= NK_STAR",
 /* 374 */ "star_func_para_list ::= other_para_list",
 /* 375 */ "other_para_list ::= star_func_para",
 /* 376 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 377 */ "star_func_para ::= expression",
 /* 378 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 379 */ "predicate ::= expression compare_op expression",
 /* 380 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 381 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 382 */ "predicate ::= expression IS NULL",
 /* 383 */ "predicate ::= expression IS NOT NULL",
 /* 384 */ "predicate ::= expression in_op in_predicate_value",
 /* 385 */ "compare_op ::= NK_LT",
 /* 386 */ "compare_op ::= NK_GT",
 /* 387 */ "compare_op ::= NK_LE",
 /* 388 */ "compare_op ::= NK_GE",
 /* 389 */ "compare_op ::= NK_NE",
 /* 390 */ "compare_op ::= NK_EQ",
 /* 391 */ "compare_op ::= LIKE",
 /* 392 */ "compare_op ::= NOT LIKE",
 /* 393 */ "compare_op ::= MATCH",
 /* 394 */ "compare_op ::= NMATCH",
 /* 395 */ "compare_op ::= CONTAINS",
 /* 396 */ "in_op ::= IN",
 /* 397 */ "in_op ::= NOT IN",
 /* 398 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 399 */ "boolean_value_expression ::= boolean_primary",
 /* 400 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 401 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 402 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 403 */ "boolean_primary ::= predicate",
 /* 404 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 405 */ "common_expression ::= expression",
 /* 406 */ "common_expression ::= boolean_value_expression",
 /* 407 */ "from_clause_opt ::=",
 /* 408 */ "from_clause_opt ::= FROM table_reference_list",
 /* 409 */ "table_reference_list ::= table_reference",
 /* 410 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 411 */ "table_reference ::= table_primary",
 /* 412 */ "table_reference ::= joined_table",
 /* 413 */ "table_primary ::= table_name alias_opt",
 /* 414 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 415 */ "table_primary ::= subquery alias_opt",
 /* 416 */ "table_primary ::= parenthesized_joined_table",
 /* 417 */ "alias_opt ::=",
 /* 418 */ "alias_opt ::= table_alias",
 /* 419 */ "alias_opt ::= AS table_alias",
 /* 420 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 421 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 422 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 423 */ "join_type ::=",
 /* 424 */ "join_type ::= INNER",
 /* 425 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 426 */ "set_quantifier_opt ::=",
 /* 427 */ "set_quantifier_opt ::= DISTINCT",
 /* 428 */ "set_quantifier_opt ::= ALL",
 /* 429 */ "select_list ::= select_item",
 /* 430 */ "select_list ::= select_list NK_COMMA select_item",
 /* 431 */ "select_item ::= NK_STAR",
 /* 432 */ "select_item ::= common_expression",
 /* 433 */ "select_item ::= common_expression column_alias",
 /* 434 */ "select_item ::= common_expression AS column_alias",
 /* 435 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 436 */ "where_clause_opt ::=",
 /* 437 */ "where_clause_opt ::= WHERE search_condition",
 /* 438 */ "partition_by_clause_opt ::=",
 /* 439 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 440 */ "twindow_clause_opt ::=",
 /* 441 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 442 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 443 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 444 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 445 */ "sliding_opt ::=",
 /* 446 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 447 */ "fill_opt ::=",
 /* 448 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 449 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 450 */ "fill_mode ::= NONE",
 /* 451 */ "fill_mode ::= PREV",
 /* 452 */ "fill_mode ::= NULL",
 /* 453 */ "fill_mode ::= LINEAR",
 /* 454 */ "fill_mode ::= NEXT",
 /* 455 */ "group_by_clause_opt ::=",
 /* 456 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 457 */ "group_by_list ::= expression",
 /* 458 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 459 */ "having_clause_opt ::=",
 /* 460 */ "having_clause_opt ::= HAVING search_condition",
 /* 461 */ "range_opt ::=",
 /* 462 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 463 */ "every_opt ::=",
 /* 464 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 465 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 466 */ "query_expression_body ::= query_primary",
 /* 467 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 468 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 469 */ "query_primary ::= query_specification",
 /* 470 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 471 */ "order_by_clause_opt ::=",
 /* 472 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 473 */ "slimit_clause_opt ::=",
 /* 474 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 475 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 476 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 477 */ "limit_clause_opt ::=",
 /* 478 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 479 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 480 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 481 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 482 */ "search_condition ::= common_expression",
 /* 483 */ "sort_specification_list ::= sort_specification",
 /* 484 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 485 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 486 */ "ordering_specification_opt ::=",
 /* 487 */ "ordering_specification_opt ::= ASC",
 /* 488 */ "ordering_specification_opt ::= DESC",
 /* 489 */ "null_ordering_opt ::=",
 /* 490 */ "null_ordering_opt ::= NULLS FIRST",
 /* 491 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 257: /* cmd */
    case 260: /* literal */
    case 271: /* db_options */
    case 273: /* alter_db_options */
    case 278: /* retention */
    case 279: /* full_table_name */
    case 282: /* table_options */
    case 286: /* alter_table_clause */
    case 287: /* alter_table_options */
    case 290: /* signed_literal */
    case 291: /* create_subtable_clause */
    case 294: /* drop_table_clause */
    case 297: /* column_def */
    case 301: /* duration_literal */
    case 302: /* rollup_func_name */
    case 304: /* col_name */
    case 305: /* db_name_cond_opt */
    case 306: /* like_pattern_opt */
    case 307: /* table_name_cond */
    case 308: /* from_db_opt */
    case 310: /* index_options */
    case 312: /* sliding_opt */
    case 313: /* sma_stream_opt */
    case 314: /* func */
    case 315: /* stream_options */
    case 317: /* query_expression */
    case 320: /* explain_options */
    case 324: /* into_opt */
    case 326: /* where_clause_opt */
    case 327: /* signed */
    case 328: /* literal_func */
    case 332: /* expression */
    case 333: /* pseudo_column */
    case 334: /* column_reference */
    case 335: /* function_expression */
    case 336: /* subquery */
    case 341: /* star_func_para */
    case 342: /* predicate */
    case 345: /* in_predicate_value */
    case 346: /* boolean_value_expression */
    case 347: /* boolean_primary */
    case 348: /* common_expression */
    case 349: /* from_clause_opt */
    case 350: /* table_reference_list */
    case 351: /* table_reference */
    case 352: /* table_primary */
    case 353: /* joined_table */
    case 355: /* parenthesized_joined_table */
    case 357: /* search_condition */
    case 358: /* query_specification */
    case 362: /* range_opt */
    case 363: /* every_opt */
    case 364: /* fill_opt */
    case 365: /* twindow_clause_opt */
    case 367: /* having_clause_opt */
    case 368: /* select_item */
    case 371: /* query_expression_body */
    case 373: /* slimit_clause_opt */
    case 374: /* limit_clause_opt */
    case 375: /* query_primary */
    case 377: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy712)); 
}
      break;
    case 258: /* account_options */
    case 259: /* alter_account_options */
    case 261: /* alter_account_option */
    case 322: /* bufsize_opt */
{
 
}
      break;
    case 262: /* user_name */
    case 265: /* priv_level */
    case 268: /* db_name */
    case 269: /* dnode_endpoint */
    case 288: /* column_name */
    case 296: /* table_name */
    case 303: /* function_name */
    case 309: /* index_name */
    case 316: /* topic_name */
    case 318: /* cgroup_name */
    case 323: /* stream_name */
    case 330: /* table_alias */
    case 331: /* column_alias */
    case 337: /* star_func */
    case 339: /* noarg_func */
    case 354: /* alias_opt */
{
 
}
      break;
    case 263: /* sysinfo_opt */
{
 
}
      break;
    case 264: /* privileges */
    case 266: /* priv_type_list */
    case 267: /* priv_type */
{
 
}
      break;
    case 270: /* not_exists_opt */
    case 272: /* exists_opt */
    case 319: /* analyze_opt */
    case 321: /* agg_func_opt */
    case 359: /* set_quantifier_opt */
{
 
}
      break;
    case 274: /* integer_list */
    case 275: /* variable_list */
    case 276: /* retention_list */
    case 280: /* column_def_list */
    case 281: /* tags_def_opt */
    case 283: /* multi_create_clause */
    case 284: /* tags_def */
    case 285: /* multi_drop_clause */
    case 292: /* specific_cols_opt */
    case 293: /* expression_list */
    case 295: /* col_name_list */
    case 298: /* duration_list */
    case 299: /* rollup_func_list */
    case 311: /* func_list */
    case 325: /* dnode_list */
    case 329: /* literal_list */
    case 338: /* star_func_para_list */
    case 340: /* other_para_list */
    case 360: /* select_list */
    case 361: /* partition_by_clause_opt */
    case 366: /* group_by_clause_opt */
    case 370: /* group_by_list */
    case 372: /* order_by_clause_opt */
    case 376: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy464)); 
}
      break;
    case 277: /* alter_db_option */
    case 300: /* alter_table_option */
{
 
}
      break;
    case 289: /* type_name */
{
 
}
      break;
    case 343: /* compare_op */
    case 344: /* in_op */
{
 
}
      break;
    case 356: /* join_type */
{
 
}
      break;
    case 369: /* fill_mode */
{
 
}
      break;
    case 378: /* ordering_specification_opt */
{
 
}
      break;
    case 379: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  257,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  257,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  258,    0 }, /* (2) account_options ::= */
  {  258,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  258,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  258,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  258,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  258,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  258,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  258,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  258,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  258,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  259,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  259,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  261,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  261,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  261,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  261,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  261,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  261,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  261,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  261,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  261,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  261,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  257,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  257,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  257,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  257,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  257,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  263,    0 }, /* (29) sysinfo_opt ::= */
  {  263,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  257,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  257,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  264,   -1 }, /* (33) privileges ::= ALL */
  {  264,   -1 }, /* (34) privileges ::= priv_type_list */
  {  266,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  266,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  267,   -1 }, /* (37) priv_type ::= READ */
  {  267,   -1 }, /* (38) priv_type ::= WRITE */
  {  265,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  265,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  257,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  257,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  257,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  257,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  257,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  257,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  257,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  257,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  269,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  269,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  269,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  257,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  257,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  257,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  257,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  257,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  257,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  257,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  257,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  257,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  257,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  257,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  257,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  257,   -2 }, /* (64) cmd ::= USE db_name */
  {  257,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  257,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  257,   -3 }, /* (67) cmd ::= TRIM DATABASE db_name */
  {  270,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  270,    0 }, /* (69) not_exists_opt ::= */
  {  272,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  272,    0 }, /* (71) exists_opt ::= */
  {  271,    0 }, /* (72) db_options ::= */
  {  271,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  271,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  271,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  271,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  271,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  271,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  271,   -3 }, /* (79) db_options ::= db_options MAXROWS NK_INTEGER */
  {  271,   -3 }, /* (80) db_options ::= db_options MINROWS NK_INTEGER */
  {  271,   -3 }, /* (81) db_options ::= db_options KEEP integer_list */
  {  271,   -3 }, /* (82) db_options ::= db_options KEEP variable_list */
  {  271,   -3 }, /* (83) db_options ::= db_options PAGES NK_INTEGER */
  {  271,   -3 }, /* (84) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  271,   -3 }, /* (85) db_options ::= db_options PRECISION NK_STRING */
  {  271,   -3 }, /* (86) db_options ::= db_options REPLICA NK_INTEGER */
  {  271,   -3 }, /* (87) db_options ::= db_options STRICT NK_STRING */
  {  271,   -3 }, /* (88) db_options ::= db_options VGROUPS NK_INTEGER */
  {  271,   -3 }, /* (89) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  271,   -3 }, /* (90) db_options ::= db_options RETENTIONS retention_list */
  {  271,   -3 }, /* (91) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  271,   -3 }, /* (92) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  271,   -3 }, /* (93) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  271,   -3 }, /* (94) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  271,   -4 }, /* (95) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  271,   -3 }, /* (96) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  271,   -4 }, /* (97) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  271,   -3 }, /* (98) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  271,   -3 }, /* (99) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  273,   -1 }, /* (100) alter_db_options ::= alter_db_option */
  {  273,   -2 }, /* (101) alter_db_options ::= alter_db_options alter_db_option */
  {  277,   -2 }, /* (102) alter_db_option ::= CACHEMODEL NK_STRING */
  {  277,   -2 }, /* (103) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  277,   -2 }, /* (104) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  277,   -2 }, /* (105) alter_db_option ::= KEEP integer_list */
  {  277,   -2 }, /* (106) alter_db_option ::= KEEP variable_list */
  {  277,   -2 }, /* (107) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  274,   -1 }, /* (108) integer_list ::= NK_INTEGER */
  {  274,   -3 }, /* (109) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  275,   -1 }, /* (110) variable_list ::= NK_VARIABLE */
  {  275,   -3 }, /* (111) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  276,   -1 }, /* (112) retention_list ::= retention */
  {  276,   -3 }, /* (113) retention_list ::= retention_list NK_COMMA retention */
  {  278,   -3 }, /* (114) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  257,   -9 }, /* (115) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  257,   -3 }, /* (116) cmd ::= CREATE TABLE multi_create_clause */
  {  257,   -9 }, /* (117) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  257,   -3 }, /* (118) cmd ::= DROP TABLE multi_drop_clause */
  {  257,   -4 }, /* (119) cmd ::= DROP STABLE exists_opt full_table_name */
  {  257,   -3 }, /* (120) cmd ::= ALTER TABLE alter_table_clause */
  {  257,   -3 }, /* (121) cmd ::= ALTER STABLE alter_table_clause */
  {  286,   -2 }, /* (122) alter_table_clause ::= full_table_name alter_table_options */
  {  286,   -5 }, /* (123) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  286,   -4 }, /* (124) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  286,   -5 }, /* (125) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  286,   -5 }, /* (126) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  286,   -5 }, /* (127) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  286,   -4 }, /* (128) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  286,   -5 }, /* (129) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  286,   -5 }, /* (130) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  286,   -6 }, /* (131) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  283,   -1 }, /* (132) multi_create_clause ::= create_subtable_clause */
  {  283,   -2 }, /* (133) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  291,  -10 }, /* (134) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  285,   -1 }, /* (135) multi_drop_clause ::= drop_table_clause */
  {  285,   -2 }, /* (136) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  294,   -2 }, /* (137) drop_table_clause ::= exists_opt full_table_name */
  {  292,    0 }, /* (138) specific_cols_opt ::= */
  {  292,   -3 }, /* (139) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  279,   -1 }, /* (140) full_table_name ::= table_name */
  {  279,   -3 }, /* (141) full_table_name ::= db_name NK_DOT table_name */
  {  280,   -1 }, /* (142) column_def_list ::= column_def */
  {  280,   -3 }, /* (143) column_def_list ::= column_def_list NK_COMMA column_def */
  {  297,   -2 }, /* (144) column_def ::= column_name type_name */
  {  297,   -4 }, /* (145) column_def ::= column_name type_name COMMENT NK_STRING */
  {  289,   -1 }, /* (146) type_name ::= BOOL */
  {  289,   -1 }, /* (147) type_name ::= TINYINT */
  {  289,   -1 }, /* (148) type_name ::= SMALLINT */
  {  289,   -1 }, /* (149) type_name ::= INT */
  {  289,   -1 }, /* (150) type_name ::= INTEGER */
  {  289,   -1 }, /* (151) type_name ::= BIGINT */
  {  289,   -1 }, /* (152) type_name ::= FLOAT */
  {  289,   -1 }, /* (153) type_name ::= DOUBLE */
  {  289,   -4 }, /* (154) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  289,   -1 }, /* (155) type_name ::= TIMESTAMP */
  {  289,   -4 }, /* (156) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  289,   -2 }, /* (157) type_name ::= TINYINT UNSIGNED */
  {  289,   -2 }, /* (158) type_name ::= SMALLINT UNSIGNED */
  {  289,   -2 }, /* (159) type_name ::= INT UNSIGNED */
  {  289,   -2 }, /* (160) type_name ::= BIGINT UNSIGNED */
  {  289,   -1 }, /* (161) type_name ::= JSON */
  {  289,   -4 }, /* (162) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  289,   -1 }, /* (163) type_name ::= MEDIUMBLOB */
  {  289,   -1 }, /* (164) type_name ::= BLOB */
  {  289,   -4 }, /* (165) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  289,   -1 }, /* (166) type_name ::= DECIMAL */
  {  289,   -4 }, /* (167) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  289,   -6 }, /* (168) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  281,    0 }, /* (169) tags_def_opt ::= */
  {  281,   -1 }, /* (170) tags_def_opt ::= tags_def */
  {  284,   -4 }, /* (171) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  282,    0 }, /* (172) table_options ::= */
  {  282,   -3 }, /* (173) table_options ::= table_options COMMENT NK_STRING */
  {  282,   -3 }, /* (174) table_options ::= table_options MAX_DELAY duration_list */
  {  282,   -3 }, /* (175) table_options ::= table_options WATERMARK duration_list */
  {  282,   -5 }, /* (176) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  282,   -3 }, /* (177) table_options ::= table_options TTL NK_INTEGER */
  {  282,   -5 }, /* (178) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  287,   -1 }, /* (179) alter_table_options ::= alter_table_option */
  {  287,   -2 }, /* (180) alter_table_options ::= alter_table_options alter_table_option */
  {  300,   -2 }, /* (181) alter_table_option ::= COMMENT NK_STRING */
  {  300,   -2 }, /* (182) alter_table_option ::= TTL NK_INTEGER */
  {  298,   -1 }, /* (183) duration_list ::= duration_literal */
  {  298,   -3 }, /* (184) duration_list ::= duration_list NK_COMMA duration_literal */
  {  299,   -1 }, /* (185) rollup_func_list ::= rollup_func_name */
  {  299,   -3 }, /* (186) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  302,   -1 }, /* (187) rollup_func_name ::= function_name */
  {  302,   -1 }, /* (188) rollup_func_name ::= FIRST */
  {  302,   -1 }, /* (189) rollup_func_name ::= LAST */
  {  295,   -1 }, /* (190) col_name_list ::= col_name */
  {  295,   -3 }, /* (191) col_name_list ::= col_name_list NK_COMMA col_name */
  {  304,   -1 }, /* (192) col_name ::= column_name */
  {  257,   -2 }, /* (193) cmd ::= SHOW DNODES */
  {  257,   -2 }, /* (194) cmd ::= SHOW USERS */
  {  257,   -2 }, /* (195) cmd ::= SHOW DATABASES */
  {  257,   -4 }, /* (196) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  257,   -4 }, /* (197) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  257,   -3 }, /* (198) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  257,   -2 }, /* (199) cmd ::= SHOW MNODES */
  {  257,   -2 }, /* (200) cmd ::= SHOW MODULES */
  {  257,   -2 }, /* (201) cmd ::= SHOW QNODES */
  {  257,   -2 }, /* (202) cmd ::= SHOW FUNCTIONS */
  {  257,   -5 }, /* (203) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  257,   -2 }, /* (204) cmd ::= SHOW STREAMS */
  {  257,   -2 }, /* (205) cmd ::= SHOW ACCOUNTS */
  {  257,   -2 }, /* (206) cmd ::= SHOW APPS */
  {  257,   -2 }, /* (207) cmd ::= SHOW CONNECTIONS */
  {  257,   -2 }, /* (208) cmd ::= SHOW LICENCE */
  {  257,   -2 }, /* (209) cmd ::= SHOW GRANTS */
  {  257,   -4 }, /* (210) cmd ::= SHOW CREATE DATABASE db_name */
  {  257,   -4 }, /* (211) cmd ::= SHOW CREATE TABLE full_table_name */
  {  257,   -4 }, /* (212) cmd ::= SHOW CREATE STABLE full_table_name */
  {  257,   -2 }, /* (213) cmd ::= SHOW QUERIES */
  {  257,   -2 }, /* (214) cmd ::= SHOW SCORES */
  {  257,   -2 }, /* (215) cmd ::= SHOW TOPICS */
  {  257,   -2 }, /* (216) cmd ::= SHOW VARIABLES */
  {  257,   -3 }, /* (217) cmd ::= SHOW LOCAL VARIABLES */
  {  257,   -4 }, /* (218) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  257,   -2 }, /* (219) cmd ::= SHOW BNODES */
  {  257,   -2 }, /* (220) cmd ::= SHOW SNODES */
  {  257,   -2 }, /* (221) cmd ::= SHOW CLUSTER */
  {  257,   -2 }, /* (222) cmd ::= SHOW TRANSACTIONS */
  {  257,   -4 }, /* (223) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  257,   -2 }, /* (224) cmd ::= SHOW CONSUMERS */
  {  257,   -2 }, /* (225) cmd ::= SHOW SUBSCRIPTIONS */
  {  257,   -5 }, /* (226) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  305,    0 }, /* (227) db_name_cond_opt ::= */
  {  305,   -2 }, /* (228) db_name_cond_opt ::= db_name NK_DOT */
  {  306,    0 }, /* (229) like_pattern_opt ::= */
  {  306,   -2 }, /* (230) like_pattern_opt ::= LIKE NK_STRING */
  {  307,   -1 }, /* (231) table_name_cond ::= table_name */
  {  308,    0 }, /* (232) from_db_opt ::= */
  {  308,   -2 }, /* (233) from_db_opt ::= FROM db_name */
  {  257,   -8 }, /* (234) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON full_table_name index_options */
  {  257,   -4 }, /* (235) cmd ::= DROP INDEX exists_opt index_name */
  {  310,  -10 }, /* (236) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  310,  -12 }, /* (237) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  311,   -1 }, /* (238) func_list ::= func */
  {  311,   -3 }, /* (239) func_list ::= func_list NK_COMMA func */
  {  314,   -4 }, /* (240) func ::= function_name NK_LP expression_list NK_RP */
  {  313,    0 }, /* (241) sma_stream_opt ::= */
  {  313,   -3 }, /* (242) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  313,   -3 }, /* (243) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  257,   -6 }, /* (244) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  257,   -7 }, /* (245) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  257,   -9 }, /* (246) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  257,   -7 }, /* (247) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  257,   -9 }, /* (248) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  257,   -4 }, /* (249) cmd ::= DROP TOPIC exists_opt topic_name */
  {  257,   -7 }, /* (250) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  257,   -2 }, /* (251) cmd ::= DESC full_table_name */
  {  257,   -2 }, /* (252) cmd ::= DESCRIBE full_table_name */
  {  257,   -3 }, /* (253) cmd ::= RESET QUERY CACHE */
  {  257,   -4 }, /* (254) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  319,    0 }, /* (255) analyze_opt ::= */
  {  319,   -1 }, /* (256) analyze_opt ::= ANALYZE */
  {  320,    0 }, /* (257) explain_options ::= */
  {  320,   -3 }, /* (258) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  320,   -3 }, /* (259) explain_options ::= explain_options RATIO NK_FLOAT */
  {  257,  -10 }, /* (260) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  257,   -4 }, /* (261) cmd ::= DROP FUNCTION exists_opt function_name */
  {  321,    0 }, /* (262) agg_func_opt ::= */
  {  321,   -1 }, /* (263) agg_func_opt ::= AGGREGATE */
  {  322,    0 }, /* (264) bufsize_opt ::= */
  {  322,   -2 }, /* (265) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  257,   -8 }, /* (266) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  257,   -4 }, /* (267) cmd ::= DROP STREAM exists_opt stream_name */
  {  324,    0 }, /* (268) into_opt ::= */
  {  324,   -2 }, /* (269) into_opt ::= INTO full_table_name */
  {  315,    0 }, /* (270) stream_options ::= */
  {  315,   -3 }, /* (271) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  315,   -3 }, /* (272) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  315,   -4 }, /* (273) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  315,   -3 }, /* (274) stream_options ::= stream_options WATERMARK duration_literal */
  {  315,   -3 }, /* (275) stream_options ::= stream_options IGNORE EXPIRED */
  {  257,   -3 }, /* (276) cmd ::= KILL CONNECTION NK_INTEGER */
  {  257,   -3 }, /* (277) cmd ::= KILL QUERY NK_STRING */
  {  257,   -3 }, /* (278) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  257,   -2 }, /* (279) cmd ::= BALANCE VGROUP */
  {  257,   -4 }, /* (280) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  257,   -4 }, /* (281) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  257,   -3 }, /* (282) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  325,   -2 }, /* (283) dnode_list ::= DNODE NK_INTEGER */
  {  325,   -3 }, /* (284) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  257,   -4 }, /* (285) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  257,   -1 }, /* (286) cmd ::= query_expression */
  {  257,   -7 }, /* (287) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
  {  257,   -4 }, /* (288) cmd ::= INSERT INTO full_table_name query_expression */
  {  260,   -1 }, /* (289) literal ::= NK_INTEGER */
  {  260,   -1 }, /* (290) literal ::= NK_FLOAT */
  {  260,   -1 }, /* (291) literal ::= NK_STRING */
  {  260,   -1 }, /* (292) literal ::= NK_BOOL */
  {  260,   -2 }, /* (293) literal ::= TIMESTAMP NK_STRING */
  {  260,   -1 }, /* (294) literal ::= duration_literal */
  {  260,   -1 }, /* (295) literal ::= NULL */
  {  260,   -1 }, /* (296) literal ::= NK_QUESTION */
  {  301,   -1 }, /* (297) duration_literal ::= NK_VARIABLE */
  {  327,   -1 }, /* (298) signed ::= NK_INTEGER */
  {  327,   -2 }, /* (299) signed ::= NK_PLUS NK_INTEGER */
  {  327,   -2 }, /* (300) signed ::= NK_MINUS NK_INTEGER */
  {  327,   -1 }, /* (301) signed ::= NK_FLOAT */
  {  327,   -2 }, /* (302) signed ::= NK_PLUS NK_FLOAT */
  {  327,   -2 }, /* (303) signed ::= NK_MINUS NK_FLOAT */
  {  290,   -1 }, /* (304) signed_literal ::= signed */
  {  290,   -1 }, /* (305) signed_literal ::= NK_STRING */
  {  290,   -1 }, /* (306) signed_literal ::= NK_BOOL */
  {  290,   -2 }, /* (307) signed_literal ::= TIMESTAMP NK_STRING */
  {  290,   -1 }, /* (308) signed_literal ::= duration_literal */
  {  290,   -1 }, /* (309) signed_literal ::= NULL */
  {  290,   -1 }, /* (310) signed_literal ::= literal_func */
  {  290,   -1 }, /* (311) signed_literal ::= NK_QUESTION */
  {  329,   -1 }, /* (312) literal_list ::= signed_literal */
  {  329,   -3 }, /* (313) literal_list ::= literal_list NK_COMMA signed_literal */
  {  268,   -1 }, /* (314) db_name ::= NK_ID */
  {  296,   -1 }, /* (315) table_name ::= NK_ID */
  {  288,   -1 }, /* (316) column_name ::= NK_ID */
  {  303,   -1 }, /* (317) function_name ::= NK_ID */
  {  330,   -1 }, /* (318) table_alias ::= NK_ID */
  {  331,   -1 }, /* (319) column_alias ::= NK_ID */
  {  262,   -1 }, /* (320) user_name ::= NK_ID */
  {  309,   -1 }, /* (321) index_name ::= NK_ID */
  {  316,   -1 }, /* (322) topic_name ::= NK_ID */
  {  323,   -1 }, /* (323) stream_name ::= NK_ID */
  {  318,   -1 }, /* (324) cgroup_name ::= NK_ID */
  {  332,   -1 }, /* (325) expression ::= literal */
  {  332,   -1 }, /* (326) expression ::= pseudo_column */
  {  332,   -1 }, /* (327) expression ::= column_reference */
  {  332,   -1 }, /* (328) expression ::= function_expression */
  {  332,   -1 }, /* (329) expression ::= subquery */
  {  332,   -3 }, /* (330) expression ::= NK_LP expression NK_RP */
  {  332,   -2 }, /* (331) expression ::= NK_PLUS expression */
  {  332,   -2 }, /* (332) expression ::= NK_MINUS expression */
  {  332,   -3 }, /* (333) expression ::= expression NK_PLUS expression */
  {  332,   -3 }, /* (334) expression ::= expression NK_MINUS expression */
  {  332,   -3 }, /* (335) expression ::= expression NK_STAR expression */
  {  332,   -3 }, /* (336) expression ::= expression NK_SLASH expression */
  {  332,   -3 }, /* (337) expression ::= expression NK_REM expression */
  {  332,   -3 }, /* (338) expression ::= column_reference NK_ARROW NK_STRING */
  {  332,   -3 }, /* (339) expression ::= expression NK_BITAND expression */
  {  332,   -3 }, /* (340) expression ::= expression NK_BITOR expression */
  {  293,   -1 }, /* (341) expression_list ::= expression */
  {  293,   -3 }, /* (342) expression_list ::= expression_list NK_COMMA expression */
  {  334,   -1 }, /* (343) column_reference ::= column_name */
  {  334,   -3 }, /* (344) column_reference ::= table_name NK_DOT column_name */
  {  333,   -1 }, /* (345) pseudo_column ::= ROWTS */
  {  333,   -1 }, /* (346) pseudo_column ::= TBNAME */
  {  333,   -3 }, /* (347) pseudo_column ::= table_name NK_DOT TBNAME */
  {  333,   -1 }, /* (348) pseudo_column ::= QSTART */
  {  333,   -1 }, /* (349) pseudo_column ::= QEND */
  {  333,   -1 }, /* (350) pseudo_column ::= QDURATION */
  {  333,   -1 }, /* (351) pseudo_column ::= WSTART */
  {  333,   -1 }, /* (352) pseudo_column ::= WEND */
  {  333,   -1 }, /* (353) pseudo_column ::= WDURATION */
  {  335,   -4 }, /* (354) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  335,   -4 }, /* (355) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  335,   -6 }, /* (356) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  335,   -1 }, /* (357) function_expression ::= literal_func */
  {  328,   -3 }, /* (358) literal_func ::= noarg_func NK_LP NK_RP */
  {  328,   -1 }, /* (359) literal_func ::= NOW */
  {  339,   -1 }, /* (360) noarg_func ::= NOW */
  {  339,   -1 }, /* (361) noarg_func ::= TODAY */
  {  339,   -1 }, /* (362) noarg_func ::= TIMEZONE */
  {  339,   -1 }, /* (363) noarg_func ::= DATABASE */
  {  339,   -1 }, /* (364) noarg_func ::= CLIENT_VERSION */
  {  339,   -1 }, /* (365) noarg_func ::= SERVER_VERSION */
  {  339,   -1 }, /* (366) noarg_func ::= SERVER_STATUS */
  {  339,   -1 }, /* (367) noarg_func ::= CURRENT_USER */
  {  339,   -1 }, /* (368) noarg_func ::= USER */
  {  337,   -1 }, /* (369) star_func ::= COUNT */
  {  337,   -1 }, /* (370) star_func ::= FIRST */
  {  337,   -1 }, /* (371) star_func ::= LAST */
  {  337,   -1 }, /* (372) star_func ::= LAST_ROW */
  {  338,   -1 }, /* (373) star_func_para_list ::= NK_STAR */
  {  338,   -1 }, /* (374) star_func_para_list ::= other_para_list */
  {  340,   -1 }, /* (375) other_para_list ::= star_func_para */
  {  340,   -3 }, /* (376) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  341,   -1 }, /* (377) star_func_para ::= expression */
  {  341,   -3 }, /* (378) star_func_para ::= table_name NK_DOT NK_STAR */
  {  342,   -3 }, /* (379) predicate ::= expression compare_op expression */
  {  342,   -5 }, /* (380) predicate ::= expression BETWEEN expression AND expression */
  {  342,   -6 }, /* (381) predicate ::= expression NOT BETWEEN expression AND expression */
  {  342,   -3 }, /* (382) predicate ::= expression IS NULL */
  {  342,   -4 }, /* (383) predicate ::= expression IS NOT NULL */
  {  342,   -3 }, /* (384) predicate ::= expression in_op in_predicate_value */
  {  343,   -1 }, /* (385) compare_op ::= NK_LT */
  {  343,   -1 }, /* (386) compare_op ::= NK_GT */
  {  343,   -1 }, /* (387) compare_op ::= NK_LE */
  {  343,   -1 }, /* (388) compare_op ::= NK_GE */
  {  343,   -1 }, /* (389) compare_op ::= NK_NE */
  {  343,   -1 }, /* (390) compare_op ::= NK_EQ */
  {  343,   -1 }, /* (391) compare_op ::= LIKE */
  {  343,   -2 }, /* (392) compare_op ::= NOT LIKE */
  {  343,   -1 }, /* (393) compare_op ::= MATCH */
  {  343,   -1 }, /* (394) compare_op ::= NMATCH */
  {  343,   -1 }, /* (395) compare_op ::= CONTAINS */
  {  344,   -1 }, /* (396) in_op ::= IN */
  {  344,   -2 }, /* (397) in_op ::= NOT IN */
  {  345,   -3 }, /* (398) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  346,   -1 }, /* (399) boolean_value_expression ::= boolean_primary */
  {  346,   -2 }, /* (400) boolean_value_expression ::= NOT boolean_primary */
  {  346,   -3 }, /* (401) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  346,   -3 }, /* (402) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  347,   -1 }, /* (403) boolean_primary ::= predicate */
  {  347,   -3 }, /* (404) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  348,   -1 }, /* (405) common_expression ::= expression */
  {  348,   -1 }, /* (406) common_expression ::= boolean_value_expression */
  {  349,    0 }, /* (407) from_clause_opt ::= */
  {  349,   -2 }, /* (408) from_clause_opt ::= FROM table_reference_list */
  {  350,   -1 }, /* (409) table_reference_list ::= table_reference */
  {  350,   -3 }, /* (410) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  351,   -1 }, /* (411) table_reference ::= table_primary */
  {  351,   -1 }, /* (412) table_reference ::= joined_table */
  {  352,   -2 }, /* (413) table_primary ::= table_name alias_opt */
  {  352,   -4 }, /* (414) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  352,   -2 }, /* (415) table_primary ::= subquery alias_opt */
  {  352,   -1 }, /* (416) table_primary ::= parenthesized_joined_table */
  {  354,    0 }, /* (417) alias_opt ::= */
  {  354,   -1 }, /* (418) alias_opt ::= table_alias */
  {  354,   -2 }, /* (419) alias_opt ::= AS table_alias */
  {  355,   -3 }, /* (420) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  355,   -3 }, /* (421) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  353,   -6 }, /* (422) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  356,    0 }, /* (423) join_type ::= */
  {  356,   -1 }, /* (424) join_type ::= INNER */
  {  358,  -12 }, /* (425) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  359,    0 }, /* (426) set_quantifier_opt ::= */
  {  359,   -1 }, /* (427) set_quantifier_opt ::= DISTINCT */
  {  359,   -1 }, /* (428) set_quantifier_opt ::= ALL */
  {  360,   -1 }, /* (429) select_list ::= select_item */
  {  360,   -3 }, /* (430) select_list ::= select_list NK_COMMA select_item */
  {  368,   -1 }, /* (431) select_item ::= NK_STAR */
  {  368,   -1 }, /* (432) select_item ::= common_expression */
  {  368,   -2 }, /* (433) select_item ::= common_expression column_alias */
  {  368,   -3 }, /* (434) select_item ::= common_expression AS column_alias */
  {  368,   -3 }, /* (435) select_item ::= table_name NK_DOT NK_STAR */
  {  326,    0 }, /* (436) where_clause_opt ::= */
  {  326,   -2 }, /* (437) where_clause_opt ::= WHERE search_condition */
  {  361,    0 }, /* (438) partition_by_clause_opt ::= */
  {  361,   -3 }, /* (439) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  365,    0 }, /* (440) twindow_clause_opt ::= */
  {  365,   -6 }, /* (441) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  365,   -4 }, /* (442) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  365,   -6 }, /* (443) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  365,   -8 }, /* (444) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  312,    0 }, /* (445) sliding_opt ::= */
  {  312,   -4 }, /* (446) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  364,    0 }, /* (447) fill_opt ::= */
  {  364,   -4 }, /* (448) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  364,   -6 }, /* (449) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  369,   -1 }, /* (450) fill_mode ::= NONE */
  {  369,   -1 }, /* (451) fill_mode ::= PREV */
  {  369,   -1 }, /* (452) fill_mode ::= NULL */
  {  369,   -1 }, /* (453) fill_mode ::= LINEAR */
  {  369,   -1 }, /* (454) fill_mode ::= NEXT */
  {  366,    0 }, /* (455) group_by_clause_opt ::= */
  {  366,   -3 }, /* (456) group_by_clause_opt ::= GROUP BY group_by_list */
  {  370,   -1 }, /* (457) group_by_list ::= expression */
  {  370,   -3 }, /* (458) group_by_list ::= group_by_list NK_COMMA expression */
  {  367,    0 }, /* (459) having_clause_opt ::= */
  {  367,   -2 }, /* (460) having_clause_opt ::= HAVING search_condition */
  {  362,    0 }, /* (461) range_opt ::= */
  {  362,   -6 }, /* (462) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  363,    0 }, /* (463) every_opt ::= */
  {  363,   -4 }, /* (464) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  317,   -4 }, /* (465) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  371,   -1 }, /* (466) query_expression_body ::= query_primary */
  {  371,   -4 }, /* (467) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  371,   -3 }, /* (468) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  375,   -1 }, /* (469) query_primary ::= query_specification */
  {  375,   -6 }, /* (470) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  372,    0 }, /* (471) order_by_clause_opt ::= */
  {  372,   -3 }, /* (472) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  373,    0 }, /* (473) slimit_clause_opt ::= */
  {  373,   -2 }, /* (474) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  373,   -4 }, /* (475) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  373,   -4 }, /* (476) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  374,    0 }, /* (477) limit_clause_opt ::= */
  {  374,   -2 }, /* (478) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  374,   -4 }, /* (479) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  374,   -4 }, /* (480) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  336,   -3 }, /* (481) subquery ::= NK_LP query_expression NK_RP */
  {  357,   -1 }, /* (482) search_condition ::= common_expression */
  {  376,   -1 }, /* (483) sort_specification_list ::= sort_specification */
  {  376,   -3 }, /* (484) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  377,   -3 }, /* (485) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  378,    0 }, /* (486) ordering_specification_opt ::= */
  {  378,   -1 }, /* (487) ordering_specification_opt ::= ASC */
  {  378,   -1 }, /* (488) ordering_specification_opt ::= DESC */
  {  379,    0 }, /* (489) null_ordering_opt ::= */
  {  379,   -2 }, /* (490) null_ordering_opt ::= NULLS FIRST */
  {  379,   -2 }, /* (491) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,258,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,259,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,258,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,260,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,261,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,259,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,261,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,260,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy129, &yymsp[-1].minor.yy0, yymsp[0].minor.yy543); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy129, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy129, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy129, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy543 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy543 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy549, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy549, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy549 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy549 = yymsp[0].minor.yy549; }
  yymsp[0].minor.yy549 = yylhsminor.yy549;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy549 = yymsp[-2].minor.yy549 | yymsp[0].minor.yy549; }
  yymsp[-2].minor.yy549 = yylhsminor.yy549;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy549 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy549 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy129 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy129 = yylhsminor.yy129;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy129 = yymsp[-2].minor.yy129; }
  yymsp[-2].minor.yy129 = yylhsminor.yy129;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy129, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 314: /* db_name ::= NK_ID */ yytestcase(yyruleno==314);
      case 315: /* table_name ::= NK_ID */ yytestcase(yyruleno==315);
      case 316: /* column_name ::= NK_ID */ yytestcase(yyruleno==316);
      case 317: /* function_name ::= NK_ID */ yytestcase(yyruleno==317);
      case 318: /* table_alias ::= NK_ID */ yytestcase(yyruleno==318);
      case 319: /* column_alias ::= NK_ID */ yytestcase(yyruleno==319);
      case 320: /* user_name ::= NK_ID */ yytestcase(yyruleno==320);
      case 321: /* index_name ::= NK_ID */ yytestcase(yyruleno==321);
      case 322: /* topic_name ::= NK_ID */ yytestcase(yyruleno==322);
      case 323: /* stream_name ::= NK_ID */ yytestcase(yyruleno==323);
      case 324: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==324);
      case 360: /* noarg_func ::= NOW */ yytestcase(yyruleno==360);
      case 361: /* noarg_func ::= TODAY */ yytestcase(yyruleno==361);
      case 362: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==362);
      case 363: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==363);
      case 364: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==364);
      case 365: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==365);
      case 366: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==366);
      case 367: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==367);
      case 368: /* noarg_func ::= USER */ yytestcase(yyruleno==368);
      case 369: /* star_func ::= COUNT */ yytestcase(yyruleno==369);
      case 370: /* star_func ::= FIRST */ yytestcase(yyruleno==370);
      case 371: /* star_func ::= LAST */ yytestcase(yyruleno==371);
      case 372: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==372);
{ yylhsminor.yy129 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy129 = yylhsminor.yy129;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy337, &yymsp[-1].minor.yy129, yymsp[0].minor.yy712); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy337, &yymsp[0].minor.yy129); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy129, yymsp[0].minor.yy712); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy337 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 255: /* analyze_opt ::= */ yytestcase(yyruleno==255);
      case 262: /* agg_func_opt ::= */ yytestcase(yyruleno==262);
      case 426: /* set_quantifier_opt ::= */ yytestcase(yyruleno==426);
{ yymsp[1].minor.yy337 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy337 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy712 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 79: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 80: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 81: /* db_options ::= db_options KEEP integer_list */
      case 82: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==82);
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_KEEP, yymsp[0].minor.yy464); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 83: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 84: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 85: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 86: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 87: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 88: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 89: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 90: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_RETENTIONS, yymsp[0].minor.yy464); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 91: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 92: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 93: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 94: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 95: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-3].minor.yy712, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 96: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-3].minor.yy712, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 98: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 99: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 100: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy712 = createAlterDatabaseOptions(pCxt); yylhsminor.yy712 = setAlterDatabaseOption(pCxt, yylhsminor.yy712, &yymsp[0].minor.yy405); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 101: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy712 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy712, &yymsp[0].minor.yy405); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 102: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy405.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy405.val = yymsp[0].minor.yy0; }
        break;
      case 103: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy405.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy405.val = yymsp[0].minor.yy0; }
        break;
      case 104: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy405.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy405.val = yymsp[0].minor.yy0; }
        break;
      case 105: /* alter_db_option ::= KEEP integer_list */
      case 106: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==106);
{ yymsp[-1].minor.yy405.type = DB_OPTION_KEEP; yymsp[-1].minor.yy405.pList = yymsp[0].minor.yy464; }
        break;
      case 107: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy405.type = DB_OPTION_WAL; yymsp[-1].minor.yy405.val = yymsp[0].minor.yy0; }
        break;
      case 108: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy464 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy464 = yylhsminor.yy464;
        break;
      case 109: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 284: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==284);
{ yylhsminor.yy464 = addNodeToList(pCxt, yymsp[-2].minor.yy464, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy464 = yylhsminor.yy464;
        break;
      case 110: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy464 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy464 = yylhsminor.yy464;
        break;
      case 111: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy464 = addNodeToList(pCxt, yymsp[-2].minor.yy464, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy464 = yylhsminor.yy464;
        break;
      case 112: /* retention_list ::= retention */
      case 132: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==132);
      case 135: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==135);
      case 142: /* column_def_list ::= column_def */ yytestcase(yyruleno==142);
      case 185: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==185);
      case 190: /* col_name_list ::= col_name */ yytestcase(yyruleno==190);
      case 238: /* func_list ::= func */ yytestcase(yyruleno==238);
      case 312: /* literal_list ::= signed_literal */ yytestcase(yyruleno==312);
      case 375: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==375);
      case 429: /* select_list ::= select_item */ yytestcase(yyruleno==429);
      case 483: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==483);
{ yylhsminor.yy464 = createNodeList(pCxt, yymsp[0].minor.yy712); }
  yymsp[0].minor.yy464 = yylhsminor.yy464;
        break;
      case 113: /* retention_list ::= retention_list NK_COMMA retention */
      case 143: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==143);
      case 186: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==186);
      case 191: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==191);
      case 239: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==239);
      case 313: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==313);
      case 376: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==376);
      case 430: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==430);
      case 484: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==484);
{ yylhsminor.yy464 = addNodeToList(pCxt, yymsp[-2].minor.yy464, yymsp[0].minor.yy712); }
  yymsp[-2].minor.yy464 = yylhsminor.yy464;
        break;
      case 114: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy712 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 115: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 117: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==117);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy337, yymsp[-5].minor.yy712, yymsp[-3].minor.yy464, yymsp[-1].minor.yy464, yymsp[0].minor.yy712); }
        break;
      case 116: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy464); }
        break;
      case 118: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy464); }
        break;
      case 119: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy337, yymsp[0].minor.yy712); }
        break;
      case 120: /* cmd ::= ALTER TABLE alter_table_clause */
      case 286: /* cmd ::= query_expression */ yytestcase(yyruleno==286);
{ pCxt->pRootNode = yymsp[0].minor.yy712; }
        break;
      case 121: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy712); }
        break;
      case 122: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy712 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy712, yymsp[0].minor.yy712); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 123: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy712 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy712, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy129, yymsp[0].minor.yy184); }
  yymsp[-4].minor.yy712 = yylhsminor.yy712;
        break;
      case 124: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy712 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy712, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy129); }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 125: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy712 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy712, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy129, yymsp[0].minor.yy184); }
  yymsp[-4].minor.yy712 = yylhsminor.yy712;
        break;
      case 126: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy712 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy712, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy129, &yymsp[0].minor.yy129); }
  yymsp[-4].minor.yy712 = yylhsminor.yy712;
        break;
      case 127: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy712 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy712, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy129, yymsp[0].minor.yy184); }
  yymsp[-4].minor.yy712 = yylhsminor.yy712;
        break;
      case 128: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy712 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy712, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy129); }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 129: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy712 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy712, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy129, yymsp[0].minor.yy184); }
  yymsp[-4].minor.yy712 = yylhsminor.yy712;
        break;
      case 130: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy712 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy712, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy129, &yymsp[0].minor.yy129); }
  yymsp[-4].minor.yy712 = yylhsminor.yy712;
        break;
      case 131: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy712 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy712, &yymsp[-2].minor.yy129, yymsp[0].minor.yy712); }
  yymsp[-5].minor.yy712 = yylhsminor.yy712;
        break;
      case 133: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 136: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==136);
{ yylhsminor.yy464 = addNodeToList(pCxt, yymsp[-1].minor.yy464, yymsp[0].minor.yy712); }
  yymsp[-1].minor.yy464 = yylhsminor.yy464;
        break;
      case 134: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy712 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy337, yymsp[-8].minor.yy712, yymsp[-6].minor.yy712, yymsp[-5].minor.yy464, yymsp[-2].minor.yy464, yymsp[0].minor.yy712); }
  yymsp[-9].minor.yy712 = yylhsminor.yy712;
        break;
      case 137: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy712 = createDropTableClause(pCxt, yymsp[-1].minor.yy337, yymsp[0].minor.yy712); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 138: /* specific_cols_opt ::= */
      case 169: /* tags_def_opt ::= */ yytestcase(yyruleno==169);
      case 438: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==438);
      case 455: /* group_by_clause_opt ::= */ yytestcase(yyruleno==455);
      case 471: /* order_by_clause_opt ::= */ yytestcase(yyruleno==471);
{ yymsp[1].minor.yy464 = NULL; }
        break;
      case 139: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy464 = yymsp[-1].minor.yy464; }
        break;
      case 140: /* full_table_name ::= table_name */
{ yylhsminor.yy712 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy129, NULL); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 141: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy712 = createRealTableNode(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129, NULL); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 144: /* column_def ::= column_name type_name */
{ yylhsminor.yy712 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy129, yymsp[0].minor.yy184, NULL); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 145: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy712 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy129, yymsp[-2].minor.yy184, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 146: /* type_name ::= BOOL */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 147: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 148: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 149: /* type_name ::= INT */
      case 150: /* type_name ::= INTEGER */ yytestcase(yyruleno==150);
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 151: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 152: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 153: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 154: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy184 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 155: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 156: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy184 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy184 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 158: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy184 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 159: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy184 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 160: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy184 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 161: /* type_name ::= JSON */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 162: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy184 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 163: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 164: /* type_name ::= BLOB */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 165: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy184 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 166: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 167: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy184 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 168: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy184 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 170: /* tags_def_opt ::= tags_def */
      case 374: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==374);
{ yylhsminor.yy464 = yymsp[0].minor.yy464; }
  yymsp[0].minor.yy464 = yylhsminor.yy464;
        break;
      case 171: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy464 = yymsp[-1].minor.yy464; }
        break;
      case 172: /* table_options ::= */
{ yymsp[1].minor.yy712 = createDefaultTableOptions(pCxt); }
        break;
      case 173: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy712 = setTableOption(pCxt, yymsp[-2].minor.yy712, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 174: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy712 = setTableOption(pCxt, yymsp[-2].minor.yy712, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy464); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 175: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy712 = setTableOption(pCxt, yymsp[-2].minor.yy712, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy464); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 176: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy712 = setTableOption(pCxt, yymsp[-4].minor.yy712, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy464); }
  yymsp[-4].minor.yy712 = yylhsminor.yy712;
        break;
      case 177: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy712 = setTableOption(pCxt, yymsp[-2].minor.yy712, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 178: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy712 = setTableOption(pCxt, yymsp[-4].minor.yy712, TABLE_OPTION_SMA, yymsp[-1].minor.yy464); }
  yymsp[-4].minor.yy712 = yylhsminor.yy712;
        break;
      case 179: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy712 = createAlterTableOptions(pCxt); yylhsminor.yy712 = setTableOption(pCxt, yylhsminor.yy712, yymsp[0].minor.yy405.type, &yymsp[0].minor.yy405.val); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 180: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy712 = setTableOption(pCxt, yymsp[-1].minor.yy712, yymsp[0].minor.yy405.type, &yymsp[0].minor.yy405.val); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 181: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy405.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy405.val = yymsp[0].minor.yy0; }
        break;
      case 182: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy405.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy405.val = yymsp[0].minor.yy0; }
        break;
      case 183: /* duration_list ::= duration_literal */
      case 341: /* expression_list ::= expression */ yytestcase(yyruleno==341);
{ yylhsminor.yy464 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy712)); }
  yymsp[0].minor.yy464 = yylhsminor.yy464;
        break;
      case 184: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 342: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==342);
{ yylhsminor.yy464 = addNodeToList(pCxt, yymsp[-2].minor.yy464, releaseRawExprNode(pCxt, yymsp[0].minor.yy712)); }
  yymsp[-2].minor.yy464 = yylhsminor.yy464;
        break;
      case 187: /* rollup_func_name ::= function_name */
{ yylhsminor.yy712 = createFunctionNode(pCxt, &yymsp[0].minor.yy129, NULL); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 188: /* rollup_func_name ::= FIRST */
      case 189: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==189);
{ yylhsminor.yy712 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 192: /* col_name ::= column_name */
{ yylhsminor.yy712 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy129); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 193: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 194: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 195: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 196: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy712, yymsp[0].minor.yy712, OP_TYPE_LIKE); }
        break;
      case 197: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy712, yymsp[0].minor.yy712, OP_TYPE_LIKE); }
        break;
      case 198: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy712, NULL, OP_TYPE_LIKE); }
        break;
      case 199: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 200: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 201: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 202: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 203: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy712, yymsp[-1].minor.yy712, OP_TYPE_EQUAL); }
        break;
      case 204: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 205: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 206: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 207: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 208: /* cmd ::= SHOW LICENCE */
      case 209: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==209);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT); }
        break;
      case 210: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 211: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy712); }
        break;
      case 212: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy712); }
        break;
      case 213: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 214: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 215: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 216: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 217: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 218: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 219: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 220: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 221: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 222: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 223: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy712); }
        break;
      case 224: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 225: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 226: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy712, yymsp[-1].minor.yy712, OP_TYPE_EQUAL); }
        break;
      case 227: /* db_name_cond_opt ::= */
      case 232: /* from_db_opt ::= */ yytestcase(yyruleno==232);
{ yymsp[1].minor.yy712 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 228: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy129); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 229: /* like_pattern_opt ::= */
      case 268: /* into_opt ::= */ yytestcase(yyruleno==268);
      case 407: /* from_clause_opt ::= */ yytestcase(yyruleno==407);
      case 436: /* where_clause_opt ::= */ yytestcase(yyruleno==436);
      case 440: /* twindow_clause_opt ::= */ yytestcase(yyruleno==440);
      case 445: /* sliding_opt ::= */ yytestcase(yyruleno==445);
      case 447: /* fill_opt ::= */ yytestcase(yyruleno==447);
      case 459: /* having_clause_opt ::= */ yytestcase(yyruleno==459);
      case 461: /* range_opt ::= */ yytestcase(yyruleno==461);
      case 463: /* every_opt ::= */ yytestcase(yyruleno==463);
      case 473: /* slimit_clause_opt ::= */ yytestcase(yyruleno==473);
      case 477: /* limit_clause_opt ::= */ yytestcase(yyruleno==477);
{ yymsp[1].minor.yy712 = NULL; }
        break;
      case 230: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 231: /* table_name_cond ::= table_name */
{ yylhsminor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy129); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 233: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy129); }
        break;
      case 234: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy337, &yymsp[-3].minor.yy129, yymsp[-1].minor.yy712, NULL, yymsp[0].minor.yy712); }
        break;
      case 235: /* cmd ::= DROP INDEX exists_opt index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy337, &yymsp[0].minor.yy129); }
        break;
      case 236: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy712 = createIndexOption(pCxt, yymsp[-7].minor.yy464, releaseRawExprNode(pCxt, yymsp[-3].minor.yy712), NULL, yymsp[-1].minor.yy712, yymsp[0].minor.yy712); }
        break;
      case 237: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy712 = createIndexOption(pCxt, yymsp[-9].minor.yy464, releaseRawExprNode(pCxt, yymsp[-5].minor.yy712), releaseRawExprNode(pCxt, yymsp[-3].minor.yy712), yymsp[-1].minor.yy712, yymsp[0].minor.yy712); }
        break;
      case 240: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy712 = createFunctionNode(pCxt, &yymsp[-3].minor.yy129, yymsp[-1].minor.yy464); }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 241: /* sma_stream_opt ::= */
      case 270: /* stream_options ::= */ yytestcase(yyruleno==270);
{ yymsp[1].minor.yy712 = createStreamOptions(pCxt); }
        break;
      case 242: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 274: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==274);
{ ((SStreamOptions*)yymsp[-2].minor.yy712)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy712); yylhsminor.yy712 = yymsp[-2].minor.yy712; }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 243: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy712)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy712); yylhsminor.yy712 = yymsp[-2].minor.yy712; }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 244: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy337, &yymsp[-2].minor.yy129, yymsp[0].minor.yy712); }
        break;
      case 245: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy337, &yymsp[-3].minor.yy129, &yymsp[0].minor.yy129, false); }
        break;
      case 246: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy337, &yymsp[-5].minor.yy129, &yymsp[0].minor.yy129, true); }
        break;
      case 247: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy337, &yymsp[-3].minor.yy129, yymsp[0].minor.yy712, false); }
        break;
      case 248: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy337, &yymsp[-5].minor.yy129, yymsp[0].minor.yy712, true); }
        break;
      case 249: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy337, &yymsp[0].minor.yy129); }
        break;
      case 250: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy337, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129); }
        break;
      case 251: /* cmd ::= DESC full_table_name */
      case 252: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==252);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy712); }
        break;
      case 253: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 254: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy337, yymsp[-1].minor.yy712, yymsp[0].minor.yy712); }
        break;
      case 256: /* analyze_opt ::= ANALYZE */
      case 263: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==263);
      case 427: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==427);
{ yymsp[0].minor.yy337 = true; }
        break;
      case 257: /* explain_options ::= */
{ yymsp[1].minor.yy712 = createDefaultExplainOptions(pCxt); }
        break;
      case 258: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy712 = setExplainVerbose(pCxt, yymsp[-2].minor.yy712, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 259: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy712 = setExplainRatio(pCxt, yymsp[-2].minor.yy712, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 260: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy337, yymsp[-8].minor.yy337, &yymsp[-5].minor.yy129, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy184, yymsp[0].minor.yy500); }
        break;
      case 261: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy337, &yymsp[0].minor.yy129); }
        break;
      case 264: /* bufsize_opt ::= */
{ yymsp[1].minor.yy500 = 0; }
        break;
      case 265: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy500 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 266: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy337, &yymsp[-4].minor.yy129, yymsp[-2].minor.yy712, yymsp[-3].minor.yy712, yymsp[0].minor.yy712); }
        break;
      case 267: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy337, &yymsp[0].minor.yy129); }
        break;
      case 269: /* into_opt ::= INTO full_table_name */
      case 408: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==408);
      case 437: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==437);
      case 460: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==460);
{ yymsp[-1].minor.yy712 = yymsp[0].minor.yy712; }
        break;
      case 271: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy712)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy712 = yymsp[-2].minor.yy712; }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 272: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy712)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy712 = yymsp[-2].minor.yy712; }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 273: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy712)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy712)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy712); yylhsminor.yy712 = yymsp[-3].minor.yy712; }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 275: /* stream_options ::= stream_options IGNORE EXPIRED */
{ ((SStreamOptions*)yymsp[-2].minor.yy712)->ignoreExpired = true; yylhsminor.yy712 = yymsp[-2].minor.yy712; }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 276: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 277: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 278: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 279: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 280: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 281: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy464); }
        break;
      case 282: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 283: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy464 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 285: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy712, yymsp[0].minor.yy712); }
        break;
      case 287: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy712, yymsp[-2].minor.yy464, yymsp[0].minor.yy712); }
        break;
      case 288: /* cmd ::= INSERT INTO full_table_name query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy712, NULL, yymsp[0].minor.yy712); }
        break;
      case 289: /* literal ::= NK_INTEGER */
{ yylhsminor.yy712 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 290: /* literal ::= NK_FLOAT */
{ yylhsminor.yy712 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 291: /* literal ::= NK_STRING */
{ yylhsminor.yy712 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 292: /* literal ::= NK_BOOL */
{ yylhsminor.yy712 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 293: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 294: /* literal ::= duration_literal */
      case 304: /* signed_literal ::= signed */ yytestcase(yyruleno==304);
      case 325: /* expression ::= literal */ yytestcase(yyruleno==325);
      case 326: /* expression ::= pseudo_column */ yytestcase(yyruleno==326);
      case 327: /* expression ::= column_reference */ yytestcase(yyruleno==327);
      case 328: /* expression ::= function_expression */ yytestcase(yyruleno==328);
      case 329: /* expression ::= subquery */ yytestcase(yyruleno==329);
      case 357: /* function_expression ::= literal_func */ yytestcase(yyruleno==357);
      case 399: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==399);
      case 403: /* boolean_primary ::= predicate */ yytestcase(yyruleno==403);
      case 405: /* common_expression ::= expression */ yytestcase(yyruleno==405);
      case 406: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==406);
      case 409: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==409);
      case 411: /* table_reference ::= table_primary */ yytestcase(yyruleno==411);
      case 412: /* table_reference ::= joined_table */ yytestcase(yyruleno==412);
      case 416: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==416);
      case 466: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==466);
      case 469: /* query_primary ::= query_specification */ yytestcase(yyruleno==469);
{ yylhsminor.yy712 = yymsp[0].minor.yy712; }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 295: /* literal ::= NULL */
{ yylhsminor.yy712 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 296: /* literal ::= NK_QUESTION */
{ yylhsminor.yy712 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 297: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy712 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 298: /* signed ::= NK_INTEGER */
{ yylhsminor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 299: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 300: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 301: /* signed ::= NK_FLOAT */
{ yylhsminor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 302: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 303: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 305: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 306: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 307: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 308: /* signed_literal ::= duration_literal */
      case 310: /* signed_literal ::= literal_func */ yytestcase(yyruleno==310);
      case 377: /* star_func_para ::= expression */ yytestcase(yyruleno==377);
      case 432: /* select_item ::= common_expression */ yytestcase(yyruleno==432);
      case 482: /* search_condition ::= common_expression */ yytestcase(yyruleno==482);
{ yylhsminor.yy712 = releaseRawExprNode(pCxt, yymsp[0].minor.yy712); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 309: /* signed_literal ::= NULL */
{ yylhsminor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 311: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy712 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 330: /* expression ::= NK_LP expression NK_RP */
      case 404: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==404);
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy712)); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 331: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy712));
                                                                                  }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 332: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy712), NULL));
                                                                                  }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 333: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712))); 
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 334: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712))); 
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 335: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712))); 
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 336: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712))); 
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 337: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712)));
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 338: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 339: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712)));
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 340: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712)));
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 343: /* column_reference ::= column_name */
{ yylhsminor.yy712 = createRawExprNode(pCxt, &yymsp[0].minor.yy129, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy129)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 344: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129, createColumnNode(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129)); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 345: /* pseudo_column ::= ROWTS */
      case 346: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==346);
      case 348: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==348);
      case 349: /* pseudo_column ::= QEND */ yytestcase(yyruleno==349);
      case 350: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==350);
      case 351: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==351);
      case 352: /* pseudo_column ::= WEND */ yytestcase(yyruleno==352);
      case 353: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==353);
      case 359: /* literal_func ::= NOW */ yytestcase(yyruleno==359);
{ yylhsminor.yy712 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 347: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy129)))); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 354: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 355: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==355);
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy129, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy129, yymsp[-1].minor.yy464)); }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 356: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy712), yymsp[-1].minor.yy184)); }
  yymsp[-5].minor.yy712 = yylhsminor.yy712;
        break;
      case 358: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy129, NULL)); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 373: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy464 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy464 = yylhsminor.yy464;
        break;
      case 378: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 435: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==435);
{ yylhsminor.yy712 = createColumnNode(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 379: /* predicate ::= expression compare_op expression */
      case 384: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==384);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy60, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712)));
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 380: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy712), releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712)));
                                                                                  }
  yymsp[-4].minor.yy712 = yylhsminor.yy712;
        break;
      case 381: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy712), releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712)));
                                                                                  }
  yymsp[-5].minor.yy712 = yylhsminor.yy712;
        break;
      case 382: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), NULL));
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 383: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy712), NULL));
                                                                                  }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 385: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy60 = OP_TYPE_LOWER_THAN; }
        break;
      case 386: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy60 = OP_TYPE_GREATER_THAN; }
        break;
      case 387: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy60 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 388: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy60 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 389: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy60 = OP_TYPE_NOT_EQUAL; }
        break;
      case 390: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy60 = OP_TYPE_EQUAL; }
        break;
      case 391: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy60 = OP_TYPE_LIKE; }
        break;
      case 392: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy60 = OP_TYPE_NOT_LIKE; }
        break;
      case 393: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy60 = OP_TYPE_MATCH; }
        break;
      case 394: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy60 = OP_TYPE_NMATCH; }
        break;
      case 395: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy60 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 396: /* in_op ::= IN */
{ yymsp[0].minor.yy60 = OP_TYPE_IN; }
        break;
      case 397: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy60 = OP_TYPE_NOT_IN; }
        break;
      case 398: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy464)); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 400: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy712), NULL));
                                                                                  }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 401: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712)));
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 402: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712)));
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 410: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy712 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy712, yymsp[0].minor.yy712, NULL); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 413: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy712 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy129, &yymsp[0].minor.yy129); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 414: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy712 = createRealTableNode(pCxt, &yymsp[-3].minor.yy129, &yymsp[-1].minor.yy129, &yymsp[0].minor.yy129); }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 415: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy712 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy712), &yymsp[0].minor.yy129); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 417: /* alias_opt ::= */
{ yymsp[1].minor.yy129 = nil_token;  }
        break;
      case 418: /* alias_opt ::= table_alias */
{ yylhsminor.yy129 = yymsp[0].minor.yy129; }
  yymsp[0].minor.yy129 = yylhsminor.yy129;
        break;
      case 419: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy129 = yymsp[0].minor.yy129; }
        break;
      case 420: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 421: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==421);
{ yymsp[-2].minor.yy712 = yymsp[-1].minor.yy712; }
        break;
      case 422: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy712 = createJoinTableNode(pCxt, yymsp[-4].minor.yy532, yymsp[-5].minor.yy712, yymsp[-2].minor.yy712, yymsp[0].minor.yy712); }
  yymsp[-5].minor.yy712 = yylhsminor.yy712;
        break;
      case 423: /* join_type ::= */
{ yymsp[1].minor.yy532 = JOIN_TYPE_INNER; }
        break;
      case 424: /* join_type ::= INNER */
{ yymsp[0].minor.yy532 = JOIN_TYPE_INNER; }
        break;
      case 425: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy712 = createSelectStmt(pCxt, yymsp[-10].minor.yy337, yymsp[-9].minor.yy464, yymsp[-8].minor.yy712);
                                                                                    yymsp[-11].minor.yy712 = addWhereClause(pCxt, yymsp[-11].minor.yy712, yymsp[-7].minor.yy712);
                                                                                    yymsp[-11].minor.yy712 = addPartitionByClause(pCxt, yymsp[-11].minor.yy712, yymsp[-6].minor.yy464);
                                                                                    yymsp[-11].minor.yy712 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy712, yymsp[-2].minor.yy712);
                                                                                    yymsp[-11].minor.yy712 = addGroupByClause(pCxt, yymsp[-11].minor.yy712, yymsp[-1].minor.yy464);
                                                                                    yymsp[-11].minor.yy712 = addHavingClause(pCxt, yymsp[-11].minor.yy712, yymsp[0].minor.yy712);
                                                                                    yymsp[-11].minor.yy712 = addRangeClause(pCxt, yymsp[-11].minor.yy712, yymsp[-5].minor.yy712);
                                                                                    yymsp[-11].minor.yy712 = addEveryClause(pCxt, yymsp[-11].minor.yy712, yymsp[-4].minor.yy712);
                                                                                    yymsp[-11].minor.yy712 = addFillClause(pCxt, yymsp[-11].minor.yy712, yymsp[-3].minor.yy712);
                                                                                  }
        break;
      case 428: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy337 = false; }
        break;
      case 431: /* select_item ::= NK_STAR */
{ yylhsminor.yy712 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 433: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy712 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy712), &yymsp[0].minor.yy129); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 434: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy712 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), &yymsp[0].minor.yy129); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 439: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 456: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==456);
      case 472: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==472);
{ yymsp[-2].minor.yy464 = yymsp[0].minor.yy464; }
        break;
      case 441: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy712 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy712), releaseRawExprNode(pCxt, yymsp[-1].minor.yy712)); }
        break;
      case 442: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy712 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy712)); }
        break;
      case 443: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy712 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy712), NULL, yymsp[-1].minor.yy712, yymsp[0].minor.yy712); }
        break;
      case 444: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy712 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy712), releaseRawExprNode(pCxt, yymsp[-3].minor.yy712), yymsp[-1].minor.yy712, yymsp[0].minor.yy712); }
        break;
      case 446: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 464: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==464);
{ yymsp[-3].minor.yy712 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy712); }
        break;
      case 448: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy712 = createFillNode(pCxt, yymsp[-1].minor.yy94, NULL); }
        break;
      case 449: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy712 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy464)); }
        break;
      case 450: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy94 = FILL_MODE_NONE; }
        break;
      case 451: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy94 = FILL_MODE_PREV; }
        break;
      case 452: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy94 = FILL_MODE_NULL; }
        break;
      case 453: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy94 = FILL_MODE_LINEAR; }
        break;
      case 454: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy94 = FILL_MODE_NEXT; }
        break;
      case 457: /* group_by_list ::= expression */
{ yylhsminor.yy464 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy712))); }
  yymsp[0].minor.yy464 = yylhsminor.yy464;
        break;
      case 458: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy464 = addNodeToList(pCxt, yymsp[-2].minor.yy464, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy712))); }
  yymsp[-2].minor.yy464 = yylhsminor.yy464;
        break;
      case 462: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy712 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy712), releaseRawExprNode(pCxt, yymsp[-1].minor.yy712)); }
        break;
      case 465: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy712 = addOrderByClause(pCxt, yymsp[-3].minor.yy712, yymsp[-2].minor.yy464);
                                                                                    yylhsminor.yy712 = addSlimitClause(pCxt, yylhsminor.yy712, yymsp[-1].minor.yy712);
                                                                                    yylhsminor.yy712 = addLimitClause(pCxt, yylhsminor.yy712, yymsp[0].minor.yy712);
                                                                                  }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 467: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy712 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy712, yymsp[0].minor.yy712); }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 468: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy712 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy712, yymsp[0].minor.yy712); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 470: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ 
                                                                                    yymsp[-5].minor.yy712 = addOrderByClause(pCxt, yymsp[-4].minor.yy712, yymsp[-3].minor.yy464);
                                                                                    yymsp[-5].minor.yy712 = addSlimitClause(pCxt, yymsp[-5].minor.yy712, yymsp[-2].minor.yy712);
                                                                                    yymsp[-5].minor.yy712 = addLimitClause(pCxt, yymsp[-5].minor.yy712, yymsp[-1].minor.yy712);
                                                                                  }
        break;
      case 474: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 478: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==478);
{ yymsp[-1].minor.yy712 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 475: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 479: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==479);
{ yymsp[-3].minor.yy712 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 476: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 480: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==480);
{ yymsp[-3].minor.yy712 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 481: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy712); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 485: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy712 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), yymsp[-1].minor.yy658, yymsp[0].minor.yy338); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 486: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy658 = ORDER_ASC; }
        break;
      case 487: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy658 = ORDER_ASC; }
        break;
      case 488: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy658 = ORDER_DESC; }
        break;
      case 489: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy338 = NULL_ORDER_DEFAULT; }
        break;
      case 490: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy338 = NULL_ORDER_FIRST; }
        break;
      case 491: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy338 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
