###################################################################
#           Copyright (c) 2016 by TAOS Technologies, Inc.
#                     All rights reserved.
#
#  This file is proprietary and confidential to TAOS Technologies.
#  No part of this file may be reproduced, stored, transmitted,
#  disclosed or used in any form or by any means other than as
#  expressly provided by the written permission from Jianhui Tao
#
###################################################################

# -*- coding: utf-8 -*-

import sys
import taos
from util.log import *
from util.cases import *
from util.sql import *
import numpy as np
import random


class TDTestCase:
    def init(self, conn, logSql):
        tdLog.debug("start to execute %s" % __file__)
        tdSql.init(conn.cursor())

    def randomInt(self):
        return random.randint(-2147483647, 2147483647)

    def randomUInt(self):
        return random.randint(0, 4294967294)

    def randomBigint(self):
        return random.randint(-2**63 + 1, 2**63 - 1)

    def randomUBigint(self):
        return random.randint(0, 18446744073709551614)

    def randomDouble(self):
        return random.random()

    def randomNchar(self):
        return random.choice('abcdefghijklmnopqrstuvwxyz')

    def randomSmallint(self):
        return random.randint(-32767, 32767)

    def randomUSmallint(self):
        return random.randint(0, 65534)

    def randomTinyint(self):
        return random.randint(-127, 127)

    def randomUTinyint(self):
        return random.randint(0, 254)

    def run(self):
        select_command = [
            "floor(ts)",
            "floor(timestamp_col)",
            "floor(int_col)",
            "floor(bigint_col)",
            "floor(float_col)",
            "floor(double_col)",
            "floor(binary_col)",
            "floor(smallint_col)",
            "floor(tinyint_col)",
            "floor(bool_col)",
            "floor(nchar_col)",
            "floor(uint_col)",
            "floor(ubigint_col)",
            "floor(usmallint_col)",
            "floor(utinyint_col)",
            "floor(timestamp_tag)",
            "floor(int_tag)",
            "floor(bigint_tag)",
            "floor(float_tag)",
            "floor(double_tag)",
            "floor(binary_tag)",
            "floor(smallint_tag)",
            "floor(tinyint_tag)",
            "floor(bool_tag)",
            "floor(nchar_tag)",
            "floor(uint_tag)",
            "floor(ubigint_tag)",
            "floor(usmallint_tag)",
            "floor(utinyint_tag)",
            "count(floor(int_col))",
            "count(floor(bigint_col))",
            "count(floor(float_col))",
            "count(floor(double_col))",
            "count(floor(smallint_col))",
            "count(floor(tinyint_col))",
            "count(floor(uint_col))",
            "count(floor(ubigint_col))",
            "count(floor(usmallint_col))",
            "count(floor(utinyint_col))",
            "avg(floor(int_col))",
            "avg(floor(bigint_col))",
            "avg(floor(float_col))",
            "avg(floor(double_col))",
            "avg(floor(smallint_col))",
            "avg(floor(tinyint_col))",
            "avg(floor(uint_col))",
            "avg(floor(ubigint_col))",
            "avg(floor(usmallint_col))",
            "avg(floor(utinyint_col))",
            "twa(floor(int_col))",
            "twa(floor(bigint_col))",
            "twa(floor(float_col))",
            "twa(floor(double_col))",
            "twa(floor(smallint_col))",
            "twa(floor(tinyint_col))",
            "twa(floor(uint_col))",
            "twa(floor(ubigint_col))",
            "twa(floor(usmallint_col))",
            "twa(floor(utinyint_col))",
            "sum(floor(int_col))",
            "sum(floor(bigint_col))",
            "sum(floor(float_col))",
            "sum(floor(double_col))",
            "sum(floor(smallint_col))",
            "sum(floor(tinyint_col))",
            "sum(floor(uint_col))",
            "sum(floor(ubigint_col))",
            "sum(floor(usmallint_col))",
            "sum(floor(utinyint_col))",
            "stddev(floor(int_col))",
            "stddev(floor(bigint_col))",
            "stddev(floor(float_col))",
            "stddev(floor(double_col))",
            "stddev(floor(smallint_col))",
            "stddev(floor(tinyint_col))",
            "stddev(floor(uint_col))",
            "stddev(floor(ubigint_col))",
            "stddev(floor(usmallint_col))",
            "stddev(floor(utinyint_col))",
            "irate(floor(int_col))",
            "irate(floor(bigint_col))",
            "irate(floor(float_col))",
            "irate(floor(double_col))",
            "irate(floor(smallint_col))",
            "irate(floor(tinyint_col))",
            "irate(floor(uint_col))",
            "irate(floor(ubigint_col))",
            "irate(floor(usmallint_col))",
            "irate(floor(utinyint_col))",
            "leastsquares(floor(int_col), 1, 1)",
            "leastsquares(floor(bigint_col), 1, 1)",
            "leastsquares(floor(float_col), 1, 1)",
            "leastsquares(floor(double_col), 1, 1)",
            "leastsquares(floor(smallint_col), 1, 1)",
            "leastsquares(floor(tinyint_col), 1, 1)",
            "leastsquares(floor(uint_col), 1, 1)",
            "leastsquares(floor(ubigint_col), 1, 1)",
            "leastsquares(floor(usmallint_col), 1, 1)",
            "leastsquares(floor(utinyint_col), 1, 1)",
            "min(floor(int_col))",
            "min(floor(bigint_col))",
            "min(floor(float_col))",
            "min(floor(double_col))",
            "min(floor(smallint_col))",
            "min(floor(tinyint_col))",
            "min(floor(uint_col))",
            "min(floor(ubigint_col))",
            "min(floor(usmallint_col))",
            "min(floor(utinyint_col))",
            "max(floor(int_col))",
            "max(floor(bigint_col))",
            "max(floor(float_col))",
            "max(floor(double_col))",
            "max(floor(smallint_col))",
            "max(floor(tinyint_col))",
            "max(floor(uint_col))",
            "max(floor(ubigint_col))",
            "max(floor(usmallint_col))",
            "max(floor(utinyint_col))",
            "first(floor(int_col))",
            "first(floor(bigint_col))",
            "first(floor(float_col))",
            "first(floor(double_col))",
            "first(floor(smallint_col))",
            "first(floor(tinyint_col))",
            "first(floor(uint_col))",
            "first(floor(ubigint_col))",
            "first(floor(usmallint_col))",
            "first(floor(utinyint_col))",
            "last(floor(int_col))",
            "last(floor(bigint_col))",
            "last(floor(float_col))",
            "last(floor(double_col))",
            "last(floor(smallint_col))",
            "last(floor(tinyint_col))",
            "last(floor(uint_col))",
            "last(floor(ubigint_col))",
            "last(floor(usmallint_col))",
            "last(floor(utinyint_col))",
            "top(floor(int_col), 1)",
            "top(floor(bigint_col), 1)",
            "top(floor(float_col), 1)",
            "top(floor(double_col), 1)",
            "top(floor(smallint_col), 1)",
            "top(floor(tinyint_col), 1)",
            "top(floor(uint_col), 1)",
            "top(floor(ubigint_col), 1)",
            "top(floor(usmallint_col), 1)",
            "top(floor(utinyint_col), 1)",
            "bottom(floor(int_col), 1)",
            "bottom(floor(bigint_col), 1)",
            "bottom(floor(float_col), 1)",
            "bottom(floor(double_col), 1)",
            "bottom(floor(smallint_col), 1)",
            "bottom(floor(tinyint_col), 1)",
            "bottom(floor(uint_col), 1)",
            "bottom(floor(ubigint_col), 1)",
            "bottom(floor(usmallint_col), 1)",
            "bottom(floor(utinyint_col), 1)",
            "percentile(floor(int_col), 20)",
            "percentile(floor(bigint_col), 20)",
            "percentile(floor(float_col), 20)",
            "percentile(floor(double_col), 20)",
            "percentile(floor(smallint_col), 20)",
            "percentile(floor(tinyint_col), 20)",
            "percentile(floor(uint_col), 20)",
            "percentile(floor(ubigint_col), 20)",
            "percentile(floor(usmallint_col), 20)",
            "percentile(floor(utinyint_col), 20)",
            "apercentile(floor(int_col), 20)",
            "apercentile(floor(bigint_col), 20)",
            "apercentile(floor(float_col), 20)",
            "apercentile(floor(double_col), 20)",
            "apercentile(floor(smallint_col), 20)",
            "apercentile(floor(tinyint_col), 20)",
            "apercentile(floor(uint_col), 20)",
            "apercentile(floor(ubigint_col), 20)",
            "apercentile(floor(usmallint_col), 20)",
            "apercentile(floor(utinyint_col), 20)",
            "last_row(floor(int_col))",
            "last_row(floor(bigint_col))",
            "last_row(floor(float_col))",
            "last_row(floor(double_col))",
            "last_row(floor(smallint_col))",
            "last_row(floor(tinyint_col))",
            "last_row(floor(uint_col))",
            "last_row(floor(ubigint_col))",
            "last_row(floor(usmallint_col))",
            "last_row(floor(utinyint_col))",
            "interp(floor(int_col))",
            "interp(floor(bigint_col))",
            "interp(floor(float_col))",
            "interp(floor(double_col))",
            "interp(floor(smallint_col))",
            "interp(floor(tinyint_col))",
            "interp(floor(uint_col))",
            "interp(floor(ubigint_col))",
            "interp(floor(usmallint_col))",
            "interp(floor(utinyint_col))",
            "diff(floor(int_col))",
            "diff(floor(bigint_col))",
            "diff(floor(float_col))",
            "diff(floor(double_col))",
            "diff(floor(smallint_col))",
            "diff(floor(tinyint_col))",
            "diff(floor(uint_col))",
            "diff(floor(ubigint_col))",
            "diff(floor(usmallint_col))",
            "diff(floor(utinyint_col))",
            "spread(floor(int_col))",
            "spread(floor(bigint_col))",
            "spread(floor(float_col))",
            "spread(floor(double_col))",
            "spread(floor(smallint_col))",
            "spread(floor(tinyint_col))",
            "spread(floor(uint_col))",
            "spread(floor(ubigint_col))",
            "spread(floor(usmallint_col))",
            "spread(floor(utinyint_col))",
            "derivative(floor(int_col), 1s, 0)",
            "derivative(floor(bigint_col), 1s, 0)",
            "derivative(floor(float_col), 1s, 0)",
            "derivative(floor(double_col), 1s, 0)",
            "derivative(floor(smallint_col), 1s, 0)",
            "derivative(floor(tinyint_col), 1s, 0)",
            "derivative(floor(uint_col), 1s, 0)",
            "derivative(floor(ubigint_col), 1s, 0)",
            "derivative(floor(usmallint_col), 1s, 0)",
            "derivative(floor(utinyint_col), 1s, 0)",
            "floor(int_col) - floor(int_col)",
            "floor(bigint_col) - floor(bigint_col)",
            "floor(float_col) - floor(float_col)",
            "floor(double_col) - floor(double_col)",
            "floor(smallint_col) - floor(smallint_col)",
            "floor(tinyint_col) - floor(tinyint_col)",
            "floor(uint_col) - floor(uint_col)",
            "floor(ubigint_col) - floor(ubigint_col)",
            "floor(usmallint_col) - floor(usmallint_col)",
            "floor(utinyint_col) - floor(utinyint_col)",
            "floor(int_col) / floor(int_col)",
            "floor(bigint_col) / floor(bigint_col)",
            "floor(float_col) / floor(float_col)",
            "floor(double_col) / floor(double_col)",
            "floor(smallint_col) / floor(smallint_col)",
            "floor(tinyint_col) / floor(tinyint_col)",
            "floor(uint_col) / floor(uint_col)",
            "floor(ubigint_col) / floor(ubigint_col)",
            "floor(usmallint_col) / floor(usmallint_col)",
            "floor(utinyint_col) / floor(utinyint_col)",
            "floor(int_col) * floor(int_col)",
            "floor(bigint_col) * floor(bigint_col)",
            "floor(float_col) * floor(float_col)",
            "floor(double_col) * floor(double_col)",
            "floor(smallint_col) * floor(smallint_col)",
            "floor(tinyint_col) * floor(tinyint_col)",
            "floor(uint_col) * floor(uint_col)",
            "floor(ubigint_col) * floor(ubigint_col)",
            "floor(usmallint_col) * floor(usmallint_col)",
            "floor(utinyint_col) * floor(utinyint_col)",
            "floor(count(ts))",
            "floor(count(timestamp_col))",
            "floor(count(int_col))",
            "floor(count(bigint_col))",
            "floor(count(float_col))",
            "floor(count(double_col))",
            "floor(count(binary_col))",
            "floor(count(smallint_col))",
            "floor(count(tinyint_col))",
            "floor(count(bool_col))",
            "floor(count(nchar_col))",
            "floor(count(uint_col))",
            "floor(count(ubigint_col))",
            "floor(count(usmallint_col))",
            "floor(count(utinyint_col))",
            "floor(count(timestamp_tag))",
            "floor(count(int_tag))",
            "floor(count(bigint_tag))",
            "floor(count(float_tag))",
            "floor(count(double_tag))",
            "floor(count(binary_tag))",
            "floor(count(smallint_tag))",
            "floor(count(tinyint_tag))",
            "floor(count(bool_tag))",
            "floor(count(nchar_tag))",
            "floor(count(uint_tag))",
            "floor(count(ubigint_tag))",
            "floor(count(usmallint_tag))",
            "floor(count(utinyint_tag))",
            "floor(avg(ts))",
            "floor(avg(timestamp_col))",
            "floor(avg(int_col))",
            "floor(avg(bigint_col))",
            "floor(avg(float_col))",
            "floor(avg(double_col))",
            "floor(avg(binary_col))",
            "floor(avg(smallint_col))",
            "floor(avg(tinyint_col))",
            "floor(avg(bool_col))",
            "floor(avg(nchar_col))",
            "floor(avg(uint_col))",
            "floor(avg(ubigint_col))",
            "floor(avg(usmallint_col))",
            "floor(avg(utinyint_col))",
            "floor(avg(timestamp_tag))",
            "floor(avg(int_tag))",
            "floor(avg(bigint_tag))",
            "floor(avg(float_tag))",
            "floor(avg(double_tag))",
            "floor(avg(binary_tag))",
            "floor(avg(smallint_tag))",
            "floor(avg(tinyint_tag))",
            "floor(avg(bool_tag))",
            "floor(avg(nchar_tag))",
            "floor(avg(uint_tag))",
            "floor(avg(ubigint_tag))",
            "floor(avg(usmallint_tag))",
            "floor(avg(utinyint_tag))",
            "floor(twa(ts))",
            "floor(twa(timestamp_col))",
            "floor(twa(int_col))",
            "floor(twa(bigint_col))",
            "floor(twa(float_col))",
            "floor(twa(double_col))",
            "floor(twa(binary_col))",
            "floor(twa(smallint_col))",
            "floor(twa(tinyint_col))",
            "floor(twa(bool_col))",
            "floor(twa(nchar_col))",
            "floor(twa(uint_col))",
            "floor(twa(ubigint_col))",
            "floor(twa(usmallint_col))",
            "floor(twa(utinyint_col))",
            "floor(twa(timestamp_tag))",
            "floor(twa(int_tag))",
            "floor(twa(bigint_tag))",
            "floor(twa(float_tag))",
            "floor(twa(double_tag))",
            "floor(twa(binary_tag))",
            "floor(twa(smallint_tag))",
            "floor(twa(tinyint_tag))",
            "floor(twa(bool_tag))",
            "floor(twa(nchar_tag))",
            "floor(twa(uint_tag))",
            "floor(twa(ubigint_tag))",
            "floor(twa(usmallint_tag))",
            "floor(twa(utinyint_tag))",
            "floor(sum(ts))",
            "floor(sum(timestamp_col))",
            "floor(sum(int_col))",
            "floor(sum(bigint_col))",
            "floor(sum(float_col))",
            "floor(sum(double_col))",
            "floor(sum(binary_col))",
            "floor(sum(smallint_col))",
            "floor(sum(tinyint_col))",
            "floor(sum(bool_col))",
            "floor(sum(nchar_col))",
            "floor(sum(uint_col))",
            "floor(sum(ubigint_col))",
            "floor(sum(usmallint_col))",
            "floor(sum(utinyint_col))",
            "floor(sum(timestamp_tag))",
            "floor(sum(int_tag))",
            "floor(sum(bigint_tag))",
            "floor(sum(float_tag))",
            "floor(sum(double_tag))",
            "floor(sum(binary_tag))",
            "floor(sum(smallint_tag))",
            "floor(sum(tinyint_tag))",
            "floor(sum(bool_tag))",
            "floor(sum(nchar_tag))",
            "floor(sum(uint_tag))",
            "floor(sum(ubigint_tag))",
            "floor(sum(usmallint_tag))",
            "floor(sum(utinyint_tag))",
            "floor(stddev(ts))",
            "floor(stddev(timestamp_col))",
            "floor(stddev(int_col))",
            "floor(stddev(bigint_col))",
            "floor(stddev(float_col))",
            "floor(stddev(double_col))",
            "floor(stddev(binary_col))",
            "floor(stddev(smallint_col))",
            "floor(stddev(tinyint_col))",
            "floor(stddev(bool_col))",
            "floor(stddev(nchar_col))",
            "floor(stddev(uint_col))",
            "floor(stddev(ubigint_col))",
            "floor(stddev(usmallint_col))",
            "floor(stddev(utinyint_col))",
            "floor(stddev(timestamp_tag))",
            "floor(stddev(int_tag))",
            "floor(stddev(bigint_tag))",
            "floor(stddev(float_tag))",
            "floor(stddev(double_tag))",
            "floor(stddev(binary_tag))",
            "floor(stddev(smallint_tag))",
            "floor(stddev(tinyint_tag))",
            "floor(stddev(bool_tag))",
            "floor(stddev(nchar_tag))",
            "floor(stddev(uint_tag))",
            "floor(stddev(ubigint_tag))",
            "floor(stddev(usmallint_tag))",
            "floor(stddev(utinyint_tag))",
            "floor(leastsquares(ts, 1, 1))",
            "floor(leastsquares(timestamp_col, 1, 1))",
            "floor(leastsquares(int_col, 1, 1))",
            "floor(leastsquares(bigint_col, 1, 1))",
            "floor(leastsquares(float_col, 1, 1))",
            "floor(leastsquares(double_col, 1, 1))",
            "floor(leastsquares(binary_col, 1, 1))",
            "floor(leastsquares(smallint_col, 1, 1))",
            "floor(leastsquares(tinyint_col, 1, 1))",
            "floor(leastsquares(bool_col, 1, 1))",
            "floor(leastsquares(nchar_col, 1, 1))",
            "floor(leastsquares(uint_col, 1, 1))",
            "floor(leastsquares(ubigint_col, 1, 1))",
            "floor(leastsquares(usmallint_col, 1, 1))",
            "floor(leastsquares(utinyint_col, 1, 1))",
            "floor(leastsquares(timestamp_tag, 1, 1))",
            "floor(leastsquares(int_tag, 1, 1))",
            "floor(leastsquares(bigint_tag, 1, 1))",
            "floor(leastsquares(float_tag, 1, 1))",
            "floor(leastsquares(double_tag, 1, 1))",
            "floor(leastsquares(binary_tag, 1, 1))",
            "floor(leastsquares(smallint_tag, 1, 1))",
            "floor(leastsquares(tinyint_tag, 1, 1))",
            "floor(leastsquares(bool_tag, 1, 1))",
            "floor(leastsquares(nchar_tag, 1, 1))",
            "floor(leastsquares(uint_tag, 1, 1))",
            "floor(leastsquares(ubigint_tag, 1, 1))",
            "floor(leastsquares(usmallint_tag, 1, 1))",
            "floor(leastsquares(utinyint_tag, 1, 1))",
            "floor(irate(ts))",
            "floor(irate(timestamp_col))",
            "floor(irate(int_col))",
            "floor(irate(bigint_col))",
            "floor(irate(float_col))",
            "floor(irate(double_col))",
            "floor(irate(binary_col))",
            "floor(irate(smallint_col))",
            "floor(irate(tinyint_col))",
            "floor(irate(bool_col))",
            "floor(irate(nchar_col))",
            "floor(irate(uint_col))",
            "floor(irate(ubigint_col))",
            "floor(irate(usmallint_col))",
            "floor(irate(utinyint_col))",
            "floor(irate(timestamp_tag))",
            "floor(irate(int_tag))",
            "floor(irate(bigint_tag))",
            "floor(irate(float_tag))",
            "floor(irate(double_tag))",
            "floor(irate(binary_tag))",
            "floor(irate(smallint_tag))",
            "floor(irate(tinyint_tag))",
            "floor(irate(bool_tag))",
            "floor(irate(nchar_tag))",
            "floor(irate(uint_tag))",
            "floor(irate(ubigint_tag))",
            "floor(irate(usmallint_tag))",
            "floor(irate(utinyint_tag))",
            "floor(min(ts))",
            "floor(min(timestamp_col))",
            "floor(min(int_col))",
            "floor(min(bigint_col))",
            "floor(min(float_col))",
            "floor(min(double_col))",
            "floor(min(binary_col))",
            "floor(min(smallint_col))",
            "floor(min(tinyint_col))",
            "floor(min(bool_col))",
            "floor(min(nchar_col))",
            "floor(min(uint_col))",
            "floor(min(ubigint_col))",
            "floor(min(usmallint_col))",
            "floor(min(utinyint_col))",
            "floor(min(timestamp_tag))",
            "floor(min(int_tag))",
            "floor(min(bigint_tag))",
            "floor(min(float_tag))",
            "floor(min(double_tag))",
            "floor(min(binary_tag))",
            "floor(min(smallint_tag))",
            "floor(min(tinyint_tag))",
            "floor(min(bool_tag))",
            "floor(min(nchar_tag))",
            "floor(min(uint_tag))",
            "floor(min(ubigint_tag))",
            "floor(min(usmallint_tag))",
            "floor(min(utinyint_tag))",
            "floor(max(ts))",
            "floor(max(timestamp_col))",
            "floor(max(int_col))",
            "floor(max(bigint_col))",
            "floor(max(float_col))",
            "floor(max(double_col))",
            "floor(max(binary_col))",
            "floor(max(smallint_col))",
            "floor(max(tinyint_col))",
            "floor(max(bool_col))",
            "floor(max(nchar_col))",
            "floor(max(uint_col))",
            "floor(max(ubigint_col))",
            "floor(max(usmallint_col))",
            "floor(max(utinyint_col))",
            "floor(max(timestamp_tag))",
            "floor(max(int_tag))",
            "floor(max(bigint_tag))",
            "floor(max(float_tag))",
            "floor(max(double_tag))",
            "floor(max(binary_tag))",
            "floor(max(smallint_tag))",
            "floor(max(tinyint_tag))",
            "floor(max(bool_tag))",
            "floor(max(nchar_tag))",
            "floor(max(uint_tag))",
            "floor(max(ubigint_tag))",
            "floor(max(usmallint_tag))",
            "floor(max(utinyint_tag))",
            "floor(first(ts))",
            "floor(first(timestamp_col))",
            "floor(first(int_col))",
            "floor(first(bigint_col))",
            "floor(first(float_col))",
            "floor(first(double_col))",
            "floor(first(binary_col))",
            "floor(first(smallint_col))",
            "floor(first(tinyint_col))",
            "floor(first(bool_col))",
            "floor(first(nchar_col))",
            "floor(first(uint_col))",
            "floor(first(ubigint_col))",
            "floor(first(usmallint_col))",
            "floor(first(utinyint_col))",
            "floor(first(timestamp_tag))",
            "floor(first(int_tag))",
            "floor(first(bigint_tag))",
            "floor(first(float_tag))",
            "floor(first(double_tag))",
            "floor(first(binary_tag))",
            "floor(first(smallint_tag))",
            "floor(first(tinyint_tag))",
            "floor(first(bool_tag))",
            "floor(first(nchar_tag))",
            "floor(first(uint_tag))",
            "floor(first(ubigint_tag))",
            "floor(first(usmallint_tag))",
            "floor(first(utinyint_tag))",
            "floor(last(ts))",
            "floor(last(timestamp_col))",
            "floor(last(int_col))",
            "floor(last(bigint_col))",
            "floor(last(float_col))",
            "floor(last(double_col))",
            "floor(last(binary_col))",
            "floor(last(smallint_col))",
            "floor(last(tinyint_col))",
            "floor(last(bool_col))",
            "floor(last(nchar_col))",
            "floor(last(uint_col))",
            "floor(last(ubigint_col))",
            "floor(last(usmallint_col))",
            "floor(last(utinyint_col))",
            "floor(last(timestamp_tag))",
            "floor(last(int_tag))",
            "floor(last(bigint_tag))",
            "floor(last(float_tag))",
            "floor(last(double_tag))",
            "floor(last(binary_tag))",
            "floor(last(smallint_tag))",
            "floor(last(tinyint_tag))",
            "floor(last(bool_tag))",
            "floor(last(nchar_tag))",
            "floor(last(uint_tag))",
            "floor(last(ubigint_tag))",
            "floor(last(usmallint_tag))",
            "floor(last(utinyint_tag))",
            "floor(top(ts, 1))",
            "floor(top(timestamp_col, 1))",
            "floor(top(int_col, 1))",
            "floor(top(bigint_col, 1))",
            "floor(top(float_col, 1))",
            "floor(top(double_col, 1))",
            "floor(top(binary_col, 1))",
            "floor(top(smallint_col, 1))",
            "floor(top(tinyint_col, 1))",
            "floor(top(bool_col, 1))",
            "floor(top(nchar_col, 1))",
            "floor(top(uint_col, 1))",
            "floor(top(ubigint_col, 1))",
            "floor(top(usmallint_col, 1))",
            "floor(top(utinyint_col, 1))",
            "floor(top(timestamp_tag, 1))",
            "floor(top(int_tag, 1))",
            "floor(top(bigint_tag, 1))",
            "floor(top(float_tag, 1))",
            "floor(top(double_tag, 1))",
            "floor(top(binary_tag, 1))",
            "floor(top(smallint_tag, 1))",
            "floor(top(tinyint_tag, 1))",
            "floor(top(bool_tag, 1))",
            "floor(top(nchar_tag, 1))",
            "floor(top(uint_tag, 1))",
            "floor(top(ubigint_tag, 1))",
            "floor(top(usmallint_tag, 1))",
            "floor(top(utinyint_tag, 1))",
            "floor(bottom(ts, 1))",
            "floor(bottom(timestamp_col, 1))",
            "floor(bottom(int_col, 1))",
            "floor(bottom(bigint_col, 1))",
            "floor(bottom(float_col, 1))",
            "floor(bottom(double_col, 1))",
            "floor(bottom(binary_col, 1))",
            "floor(bottom(smallint_col, 1))",
            "floor(bottom(tinyint_col, 1))",
            "floor(bottom(bool_col, 1))",
            "floor(bottom(nchar_col, 1))",
            "floor(bottom(uint_col, 1))",
            "floor(bottom(ubigint_col, 1))",
            "floor(bottom(usmallint_col, 1))",
            "floor(bottom(utinyint_col, 1))",
            "floor(bottom(timestamp_tag, 1))",
            "floor(bottom(int_tag, 1))",
            "floor(bottom(bigint_tag, 1))",
            "floor(bottom(float_tag, 1))",
            "floor(bottom(double_tag, 1))",
            "floor(bottom(binary_tag, 1))",
            "floor(bottom(smallint_tag, 1))",
            "floor(bottom(tinyint_tag, 1))",
            "floor(bottom(bool_tag, 1))",
            "floor(bottom(nchar_tag, 1))",
            "floor(bottom(uint_tag, 1))",
            "floor(bottom(ubigint_tag, 1))",
            "floor(bottom(usmallint_tag, 1))",
            "floor(bottom(utinyint_tag, 1))",
            "floor(percentile(ts, 1))",
            "floor(percentile(timestamp_col, 1))",
            "floor(percentile(int_col, 1))",
            "floor(percentile(bigint_col, 1))",
            "floor(percentile(float_col, 1))",
            "floor(percentile(double_col, 1))",
            "floor(percentile(binary_col, 1))",
            "floor(percentile(smallint_col, 1))",
            "floor(percentile(tinyint_col, 1))",
            "floor(percentile(bool_col, 1))",
            "floor(percentile(nchar_col, 1))",
            "floor(percentile(uint_col, 1))",
            "floor(percentile(ubigint_col, 1))",
            "floor(percentile(usmallint_col, 1))",
            "floor(percentile(utinyint_col, 1))",
            "floor(percentile(timestamp_tag, 1))",
            "floor(percentile(int_tag, 1))",
            "floor(percentile(bigint_tag, 1))",
            "floor(percentile(float_tag, 1))",
            "floor(percentile(double_tag, 1))",
            "floor(percentile(binary_tag, 1))",
            "floor(percentile(smallint_tag, 1))",
            "floor(percentile(tinyint_tag, 1))",
            "floor(percentile(bool_tag, 1))",
            "floor(percentile(nchar_tag, 1))",
            "floor(percentile(uint_tag, 1))",
            "floor(percentile(ubigint_tag, 1))",
            "floor(percentile(usmallint_tag, 1))",
            "floor(percentile(utinyint_tag, 1))",
            "floor(apercentile(ts, 1))",
            "floor(apercentile(timestamp_col, 1))",
            "floor(apercentile(int_col, 1))",
            "floor(apercentile(bigint_col, 1))",
            "floor(apercentile(float_col, 1))",
            "floor(apercentile(double_col, 1))",
            "floor(apercentile(binary_col, 1))",
            "floor(apercentile(smallint_col, 1))",
            "floor(apercentile(tinyint_col, 1))",
            "floor(apercentile(bool_col, 1))",
            "floor(apercentile(nchar_col, 1))",
            "floor(apercentile(uint_col, 1))",
            "floor(apercentile(ubigint_col, 1))",
            "floor(apercentile(usmallint_col, 1))",
            "floor(apercentile(utinyint_col, 1))",
            "floor(apercentile(timestamp_tag, 1))",
            "floor(apercentile(int_tag, 1))",
            "floor(apercentile(bigint_tag, 1))",
            "floor(apercentile(float_tag, 1))",
            "floor(apercentile(double_tag, 1))",
            "floor(apercentile(binary_tag, 1))",
            "floor(apercentile(smallint_tag, 1))",
            "floor(apercentile(tinyint_tag, 1))",
            "floor(apercentile(bool_tag, 1))",
            "floor(apercentile(nchar_tag, 1))",
            "floor(apercentile(uint_tag, 1))",
            "floor(apercentile(ubigint_tag, 1))",
            "floor(apercentile(usmallint_tag, 1))",
            "floor(apercentile(utinyint_tag, 1))",
            "floor(last_row(ts))",
            "floor(last_row(timestamp_col))",
            "floor(last_row(int_col))",
            "floor(last_row(bigint_col))",
            "floor(last_row(float_col))",
            "floor(last_row(double_col))",
            "floor(last_row(binary_col))",
            "floor(last_row(smallint_col))",
            "floor(last_row(tinyint_col))",
            "floor(last_row(bool_col))",
            "floor(last_row(nchar_col))",
            "floor(last_row(uint_col))",
            "floor(last_row(ubigint_col))",
            "floor(last_row(usmallint_col))",
            "floor(last_row(utinyint_col))",
            "floor(last_row(timestamp_tag))",
            "floor(last_row(int_tag))",
            "floor(last_row(bigint_tag))",
            "floor(last_row(float_tag))",
            "floor(last_row(double_tag))",
            "floor(last_row(binary_tag))",
            "floor(last_row(smallint_tag))",
            "floor(last_row(tinyint_tag))",
            "floor(last_row(bool_tag))",
            "floor(last_row(nchar_tag))",
            "floor(last_row(uint_tag))",
            "floor(last_row(ubigint_tag))",
            "floor(last_row(usmallint_tag))",
            "floor(last_row(utinyint_tag))",
            "floor(interp(ts))",
            "floor(interp(timestamp_col))",
            "floor(interp(int_col))",
            "floor(interp(bigint_col))",
            "floor(interp(float_col))",
            "floor(interp(double_col))",
            "floor(interp(binary_col))",
            "floor(interp(smallint_col))",
            "floor(interp(tinyint_col))",
            "floor(interp(bool_col))",
            "floor(interp(nchar_col))",
            "floor(interp(uint_col))",
            "floor(interp(ubigint_col))",
            "floor(interp(usmallint_col))",
            "floor(interp(utinyint_col))",
            "floor(interp(timestamp_tag))",
            "floor(interp(int_tag))",
            "floor(interp(bigint_tag))",
            "floor(interp(float_tag))",
            "floor(interp(double_tag))",
            "floor(interp(binary_tag))",
            "floor(interp(smallint_tag))",
            "floor(interp(tinyint_tag))",
            "floor(interp(bool_tag))",
            "floor(interp(nchar_tag))",
            "floor(interp(uint_tag))",
            "floor(interp(ubigint_tag))",
            "floor(interp(usmallint_tag))",
            "floor(interp(utinyint_tag))",
            "floor(diff(ts))",
            "floor(diff(timestamp_col))",
            "floor(diff(int_col))",
            "floor(diff(bigint_col))",
            "floor(diff(float_col))",
            "floor(diff(double_col))",
            "floor(diff(binary_col))",
            "floor(diff(smallint_col))",
            "floor(diff(tinyint_col))",
            "floor(diff(bool_col))",
            "floor(diff(nchar_col))",
            "floor(diff(uint_col))",
            "floor(diff(ubigint_col))",
            "floor(diff(usmallint_col))",
            "floor(diff(utinyint_col))",
            "floor(diff(timestamp_tag))",
            "floor(diff(int_tag))",
            "floor(diff(bigint_tag))",
            "floor(diff(float_tag))",
            "floor(diff(double_tag))",
            "floor(diff(binary_tag))",
            "floor(diff(smallint_tag))",
            "floor(diff(tinyint_tag))",
            "floor(diff(bool_tag))",
            "floor(diff(nchar_tag))",
            "floor(diff(uint_tag))",
            "floor(diff(ubigint_tag))",
            "floor(diff(usmallint_tag))",
            "floor(diff(utinyint_tag))",
            "floor(spread(ts))",
            "floor(spread(timestamp_col))",
            "floor(spread(int_col))",
            "floor(spread(bigint_col))",
            "floor(spread(float_col))",
            "floor(spread(double_col))",
            "floor(spread(binary_col))",
            "floor(spread(smallint_col))",
            "floor(spread(tinyint_col))",
            "floor(spread(bool_col))",
            "floor(spread(nchar_col))",
            "floor(spread(uint_col))",
            "floor(spread(ubigint_col))",
            "floor(spread(usmallint_col))",
            "floor(spread(utinyint_col))",
            "floor(spread(timestamp_tag))",
            "floor(spread(int_tag))",
            "floor(spread(bigint_tag))",
            "floor(spread(float_tag))",
            "floor(spread(double_tag))",
            "floor(spread(binary_tag))",
            "floor(spread(smallint_tag))",
            "floor(spread(tinyint_tag))",
            "floor(spread(bool_tag))",
            "floor(spread(nchar_tag))",
            "floor(spread(uint_tag))",
            "floor(spread(ubigint_tag))",
            "floor(spread(usmallint_tag))",
            "floor(spread(utinyint_tag))",
            "floor(derivative(ts, 1s, 0))",
            "floor(derivative(timestamp_col, 1s, 0))",
            "floor(derivative(int_col, 1s, 0))",
            "floor(derivative(bigint_col, 1s, 0))",
            "floor(derivative(float_col, 1s, 0))",
            "floor(derivative(double_col, 1s, 0))",
            "floor(derivative(binary_col, 1s, 0))",
            "floor(derivative(smallint_col, 1s, 0))",
            "floor(derivative(tinyint_col, 1s, 0))",
            "floor(derivative(bool_col, 1s, 0))",
            "floor(derivative(nchar_col, 1s, 0))",
            "floor(derivative(uint_col, 1s, 0))",
            "floor(derivative(ubigint_col, 1s, 0))",
            "floor(derivative(usmallint_col, 1s, 0))",
            "floor(derivative(utinyint_col, 1s, 0))",
            "floor(derivative(timestamp_tag, 1s, 0))",
            "floor(derivative(int_tag, 1s, 0))",
            "floor(derivative(bigint_tag, 1s, 0))",
            "floor(derivative(float_tag, 1s, 0))",
            "floor(derivative(double_tag, 1s, 0))",
            "floor(derivative(binary_tag, 1s, 0))",
            "floor(derivative(smallint_tag, 1s, 0))",
            "floor(derivative(tinyint_tag, 1s, 0))",
            "floor(derivative(bool_tag, 1s, 0))",
            "floor(derivative(nchar_tag, 1s, 0))",
            "floor(derivative(uint_tag, 1s, 0))",
            "floor(derivative(ubigint_tag, 1s, 0))",
            "floor(derivative(usmallint_tag, 1s, 0))",
            "floor(derivative(utinyint_tag, 1s, 0))",
            "floor(ts + ts)",
            "floor(timestamp_col + timestamp_col)",
            "floor(int_col + int_col)",
            "floor(bigint_col + bigint_col)",
            "floor(float_col + float_col)",
            "floor(double_col + double_col)",
            "floor(binary_col + binary_col)",
            "floor(smallint_col + smallint_col)",
            "floor(tinyint_col + tinyint_col)",
            "floor(bool_col + bool_col)",
            "floor(nchar_col + nchar_col)",
            "floor(uint_col + uint_col)",
            "floor(ubigint_col + ubigint_col)",
            "floor(usmallint_col + usmallint_col)",
            "floor(utinyint_col + utinyint_col)",
            "floor(timestamp_tag + timestamp_tag)",
            "floor(int_tag + int_tag)",
            "floor(bigint_tag + bigint_tag)",
            "floor(float_tag + float_tag)",
            "floor(double_tag + double_tag)",
            "floor(binary_tag + binary_tag)",
            "floor(smallint_tag + smallint_tag)",
            "floor(tinyint_tag + tinyint_tag)",
            "floor(bool_tag + bool_tag)",
            "floor(nchar_tag + nchar_tag)",
            "floor(uint_tag + uint_tag)",
            "floor(ubigint_tag + ubigint_tag)",
            "floor(usmallint_tag + usmallint_tag)",
            "floor(utinyint_tag + utinyint_tag)",
            "floor(ts - ts)",
            "floor(timestamp_col - timestamp_col)",
            "floor(int_col - int_col)",
            "floor(bigint_col - bigint_col)",
            "floor(float_col - float_col)",
            "floor(double_col - double_col)",
            "floor(binary_col - binary_col)",
            "floor(smallint_col - smallint_col)",
            "floor(tinyint_col - tinyint_col)",
            "floor(bool_col - bool_col)",
            "floor(nchar_col - nchar_col)",
            "floor(uint_col - uint_col)",
            "floor(ubigint_col - ubigint_col)",
            "floor(usmallint_col - usmallint_col)",
            "floor(utinyint_col - utinyint_col)",
            "floor(timestamp_tag - timestamp_tag)",
            "floor(int_tag - int_tag)",
            "floor(bigint_tag - bigint_tag)",
            "floor(float_tag - float_tag)",
            "floor(double_tag - double_tag)",
            "floor(binary_tag - binary_tag)",
            "floor(smallint_tag - smallint_tag)",
            "floor(tinyint_tag - tinyint_tag)",
            "floor(bool_tag - bool_tag)",
            "floor(nchar_tag - nchar_tag)",
            "floor(uint_tag - uint_tag)",
            "floor(ubigint_tag - ubigint_tag)",
            "floor(usmallint_tag - usmallint_tag)",
            "floor(utinyint_tag - utinyint_tag)",
            "floor(ts * ts)",
            "floor(timestamp_col * timestamp_col)",
            "floor(int_col * int_col)",
            "floor(bigint_col * bigint_col)",
            "floor(float_col * float_col)",
            "floor(double_col * double_col)",
            "floor(binary_col * binary_col)",
            "floor(smallint_col * smallint_col)",
            "floor(tinyint_col * tinyint_col)",
            "floor(bool_col * bool_col)",
            "floor(nchar_col * nchar_col)",
            "floor(uint_col * uint_col)",
            "floor(ubigint_col * ubigint_col)",
            "floor(usmallint_col * usmallint_col)",
            "floor(utinyint_col * utinyint_col)",
            "floor(timestamp_tag * timestamp_tag)",
            "floor(int_tag * int_tag)",
            "floor(bigint_tag * bigint_tag)",
            "floor(float_tag * float_tag)",
            "floor(double_tag * double_tag)",
            "floor(binary_tag * binary_tag)",
            "floor(smallint_tag * smallint_tag)",
            "floor(tinyint_tag * tinyint_tag)",
            "floor(bool_tag * bool_tag)",
            "floor(nchar_tag * nchar_tag)",
            "floor(uint_tag * uint_tag)",
            "floor(ubigint_tag * ubigint_tag)",
            "floor(usmallint_tag * usmallint_tag)",
            "floor(utinyint_tag * utinyint_tag)",
            "floor(ts / ts)",
            "floor(timestamp_col / timestamp_col)",
            "floor(int_col / int_col)",
            "floor(bigint_col / bigint_col)",
            "floor(float_col / float_col)",
            "floor(double_col / double_col)",
            "floor(binary_col / binary_col)",
            "floor(smallint_col / smallint_col)",
            "floor(tinyint_col / tinyint_col)",
            "floor(bool_col / bool_col)",
            "floor(nchar_col / nchar_col)",
            "floor(uint_col / uint_col)",
            "floor(ubigint_col / ubigint_col)",
            "floor(usmallint_col / usmallint_col)",
            "floor(utinyint_col / utinyint_col)",
            "floor(timestamp_tag / timestamp_tag)",
            "floor(int_tag / int_tag)",
            "floor(bigint_tag / bigint_tag)",
            "floor(float_tag / float_tag)",
            "floor(double_tag / double_tag)",
            "floor(binary_tag / binary_tag)",
            "floor(smallint_tag / smallint_tag)",
            "floor(tinyint_tag / tinyint_tag)",
            "floor(bool_tag / bool_tag)",
            "floor(nchar_tag / nchar_tag)",
            "floor(uint_tag / uint_tag)",
            "floor(ubigint_tag / ubigint_tag)",
            "floor(usmallint_tag / usmallint_tag)",
            "floor(utinyint_tag / utinyint_tag)",
            "int_col, floor(int_col), int_col",
            "bigint_col, floor(bigint_col), bigint_col",
            "float_col, floor(float_col), float_col",
            "double_col, floor(double_col), double_col",
            "smallint_col, floor(smallint_col), smallint_col",
            "tinyint_col, floor(tinyint_col), tinyint_col",
            "uint_col, floor(uint_col), uint_col",
            "ubigint_col, floor(ubigint_col), ubigint_col",
            "usmallint_col, floor(usmallint_col), usmallint_col",
            "utinyint_col, floor(utinyint_col), utinyint_col",
            "count(int_col), floor(int_col), count(int_col)",
            "count(bigint_col), floor(bigint_col), count(bigint_col)",
            "count(float_col), floor(float_col), count(float_col)",
            "count(double_col), floor(double_col), count(double_col)",
            "count(smallint_col), floor(smallint_col), count(smallint_col)",
            "count(tinyint_col), floor(tinyint_col), count(tinyint_col)",
            "count(uint_col), floor(uint_col), count(uint_col)",
            "count(ubigint_col), floor(ubigint_col), count(ubigint_col)",
            "count(usmallint_col), floor(usmallint_col), count(usmallint_col)",
            "count(utinyint_col), floor(utinyint_col), count(utinyint_col)",
            "avg(int_col), floor(int_col), avg(int_col)",
            "avg(bigint_col), floor(bigint_col), avg(bigint_col)",
            "avg(float_col), floor(float_col), avg(float_col)",
            "avg(double_col), floor(double_col), avg(double_col)",
            "avg(smallint_col), floor(smallint_col), avg(smallint_col)",
            "avg(tinyint_col), floor(tinyint_col), avg(tinyint_col)",
            "avg(uint_col), floor(uint_col), avg(uint_col)",
            "avg(ubigint_col), floor(ubigint_col), avg(ubigint_col)",
            "avg(usmallint_col), floor(usmallint_col), avg(usmallint_col)",
            "avg(utinyint_col), floor(utinyint_col), avg(utinyint_col)",
            "twa(int_col), floor(int_col), twa(int_col)",
            "twa(bigint_col), floor(bigint_col), twa(bigint_col)",
            "twa(float_col), floor(float_col), twa(float_col)",
            "twa(double_col), floor(double_col), twa(double_col)",
            "twa(smallint_col), floor(smallint_col), twa(smallint_col)",
            "twa(tinyint_col), floor(tinyint_col), twa(tinyint_col)",
            "twa(uint_col), floor(uint_col), twa(uint_col)",
            "twa(ubigint_col), floor(ubigint_col), twa(ubigint_col)",
            "twa(usmallint_col), floor(usmallint_col), twa(usmallint_col)",
            "twa(utinyint_col), floor(utinyint_col), twa(utinyint_col)",
            "sum(int_col), floor(int_col), sum(int_col)",
            "sum(bigint_col), floor(bigint_col), sum(bigint_col)",
            "sum(float_col), floor(float_col), sum(float_col)",
            "sum(double_col), floor(double_col), sum(double_col)",
            "sum(smallint_col), floor(smallint_col), sum(smallint_col)",
            "sum(tinyint_col), floor(tinyint_col), sum(tinyint_col)",
            "sum(uint_col), floor(uint_col), sum(uint_col)",
            "sum(ubigint_col), floor(ubigint_col), sum(ubigint_col)",
            "sum(usmallint_col), floor(usmallint_col), sum(usmallint_col)",
            "sum(utinyint_col), floor(utinyint_col), sum(utinyint_col)",
            "stddev(int_col), floor(int_col), stddev(int_col)",
            "stddev(bigint_col), floor(bigint_col), stddev(bigint_col)",
            "stddev(float_col), floor(float_col), stddev(float_col)",
            "stddev(double_col), floor(double_col), stddev(double_col)",
            "stddev(smallint_col), floor(smallint_col), stddev(smallint_col)",
            "stddev(tinyint_col), floor(tinyint_col), stddev(tinyint_col)",
            "stddev(uint_col), floor(uint_col), stddev(uint_col)",
            "stddev(ubigint_col), floor(ubigint_col), stddev(ubigint_col)",
            "stddev(usmallint_col), floor(usmallint_col), stddev(usmallint_col)",
            "stddev(utinyint_col), floor(utinyint_col), stddev(utinyint_col)",
            "irate(int_col), floor(int_col), irate(int_col)",
            "irate(bigint_col), floor(bigint_col), irate(bigint_col)",
            "irate(float_col), floor(float_col), irate(float_col)",
            "irate(double_col), floor(double_col), irate(double_col)",
            "irate(smallint_col), floor(smallint_col), irate(smallint_col)",
            "irate(tinyint_col), floor(tinyint_col), irate(tinyint_col)",
            "irate(uint_col), floor(uint_col), irate(uint_col)",
            "irate(ubigint_col), floor(ubigint_col), irate(ubigint_col)",
            "irate(usmallint_col), floor(usmallint_col), irate(usmallint_col)",
            "irate(utinyint_col), floor(utinyint_col), irate(utinyint_col)",
            "min(int_col), floor(int_col), min(int_col)",
            "min(bigint_col), floor(bigint_col), min(bigint_col)",
            "min(float_col), floor(float_col), min(float_col)",
            "min(double_col), floor(double_col), min(double_col)",
            "min(smallint_col), floor(smallint_col), min(smallint_col)",
            "min(tinyint_col), floor(tinyint_col), min(tinyint_col)",
            "min(uint_col), floor(uint_col), min(uint_col)",
            "min(ubigint_col), floor(ubigint_col), min(ubigint_col)",
            "min(usmallint_col), floor(usmallint_col), min(usmallint_col)",
            "min(utinyint_col), floor(utinyint_col), min(utinyint_col)",
            "max(int_col), floor(int_col), max(int_col)",
            "max(bigint_col), floor(bigint_col), max(bigint_col)",
            "max(float_col), floor(float_col), max(float_col)",
            "max(double_col), floor(double_col), max(double_col)",
            "max(smallint_col), floor(smallint_col), max(smallint_col)",
            "max(tinyint_col), floor(tinyint_col), max(tinyint_col)",
            "max(uint_col), floor(uint_col), max(uint_col)",
            "max(ubigint_col), floor(ubigint_col), max(ubigint_col)",
            "max(usmallint_col), floor(usmallint_col), max(usmallint_col)",
            "max(utinyint_col), floor(utinyint_col), max(utinyint_col)",
            "first(int_col), floor(int_col), first(int_col)",
            "first(bigint_col), floor(bigint_col), first(bigint_col)",
            "first(float_col), floor(float_col), first(float_col)",
            "first(double_col), floor(double_col), first(double_col)",
            "first(smallint_col), floor(smallint_col), first(smallint_col)",
            "first(tinyint_col), floor(tinyint_col), first(tinyint_col)",
            "first(uint_col), floor(uint_col), first(uint_col)",
            "first(ubigint_col), floor(ubigint_col), first(ubigint_col)",
            "first(usmallint_col), floor(usmallint_col), first(usmallint_col)",
            "first(utinyint_col), floor(utinyint_col), first(utinyint_col)",
            "last(int_col), floor(int_col), last(int_col)",
            "last(bigint_col), floor(bigint_col), last(bigint_col)",
            "last(float_col), floor(float_col), last(float_col)",
            "last(double_col), floor(double_col), last(double_col)",
            "last(smallint_col), floor(smallint_col), last(smallint_col)",
            "last(tinyint_col), floor(tinyint_col), last(tinyint_col)",
            "last(uint_col), floor(uint_col), last(uint_col)",
            "last(ubigint_col), floor(ubigint_col), last(ubigint_col)",
            "last(usmallint_col), floor(usmallint_col), last(usmallint_col)",
            "last(utinyint_col), floor(utinyint_col), last(utinyint_col)",
            "last_row(int_col), floor(int_col), last_row(int_col)",
            "last_row(bigint_col), floor(bigint_col), last_row(bigint_col)",
            "last_row(float_col), floor(float_col), last_row(float_col)",
            "last_row(double_col), floor(double_col), last_row(double_col)",
            "last_row(smallint_col), floor(smallint_col), last_row(smallint_col)",
            "last_row(tinyint_col), floor(tinyint_col), last_row(tinyint_col)",
            "last_row(uint_col), floor(uint_col), last_row(uint_col)",
            "last_row(ubigint_col), floor(ubigint_col), last_row(ubigint_col)",
            "last_row(usmallint_col), floor(usmallint_col), last_row(usmallint_col)",
            "last_row(utinyint_col), floor(utinyint_col), last_row(utinyint_col)",
            "interp(int_col), floor(int_col), interp(int_col)",
            "interp(bigint_col), floor(bigint_col), interp(bigint_col)",
            "interp(float_col), floor(float_col), interp(float_col)",
            "interp(double_col), floor(double_col), interp(double_col)",
            "interp(smallint_col), floor(smallint_col), interp(smallint_col)",
            "interp(tinyint_col), floor(tinyint_col), interp(tinyint_col)",
            "interp(uint_col), floor(uint_col), interp(uint_col)",
            "interp(ubigint_col), floor(ubigint_col), interp(ubigint_col)",
            "interp(usmallint_col), floor(usmallint_col), interp(usmallint_col)",
            "interp(utinyint_col), floor(utinyint_col), interp(utinyint_col)",
            "diff(int_col), floor(int_col), diff(int_col)",
            "diff(bigint_col), floor(bigint_col), diff(bigint_col)",
            "diff(float_col), floor(float_col), diff(float_col)",
            "diff(double_col), floor(double_col), diff(double_col)",
            "diff(smallint_col), floor(smallint_col), diff(smallint_col)",
            "diff(tinyint_col), floor(tinyint_col), diff(tinyint_col)",
            "diff(uint_col), floor(uint_col), diff(uint_col)",
            "diff(ubigint_col), floor(ubigint_col), diff(ubigint_col)",
            "diff(usmallint_col), floor(usmallint_col), diff(usmallint_col)",
            "diff(utinyint_col), floor(utinyint_col), diff(utinyint_col)",
            "spread(int_col), floor(int_col), spread(int_col)",
            "spread(bigint_col), floor(bigint_col), spread(bigint_col)",
            "spread(float_col), floor(float_col), spread(float_col)",
            "spread(double_col), floor(double_col), spread(double_col)",
            "spread(smallint_col), floor(smallint_col), spread(smallint_col)",
            "spread(tinyint_col), floor(tinyint_col), spread(tinyint_col)",
            "spread(uint_col), floor(uint_col), spread(uint_col)",
            "spread(ubigint_col), floor(ubigint_col), spread(ubigint_col)",
            "spread(usmallint_col), floor(usmallint_col), spread(usmallint_col)",
            "spread(utinyint_col), floor(utinyint_col), spread(utinyint_col)",
            "leastsquares(int_col, 1, 1), floor(int_col), leastsquares(int_col, 1, 1)",
            "leastsquares(bigint_col, 1, 1), floor(bigint_col), leastsquares(bigint_col, 1, 1)",
            "leastsquares(float_col, 1, 1), floor(float_col), leastsquares(float_col, 1, 1)",
            "leastsquares(double_col, 1, 1), floor(double_col), leastsquares(double_col, 1, 1)",
            "leastsquares(smallint_col, 1, 1), floor(smallint_col), leastsquares(smallint_col, 1, 1)",
            "leastsquares(tinyint_col, 1, 1), floor(tinyint_col), leastsquares(tinyint_col, 1, 1)",
            "leastsquares(uint_col, 1, 1), floor(uint_col), leastsquares(uint_col, 1, 1)",
            "leastsquares(ubigint_col, 1, 1), floor(ubigint_col), leastsquares(ubigint_col, 1, 1)",
            "leastsquares(usmallint_col, 1, 1), floor(usmallint_col), leastsquares(usmallint_col, 1, 1)",
            "leastsquares(utinyint_col, 1, 1), floor(utinyint_col), leastsquares(utinyint_col, 1, 1)",
            "top(int_col, 1), floor(int_col), top(int_col, 1)",
            "top(bigint_col, 1), floor(bigint_col), top(bigint_col, 1)",
            "top(float_col, 1), floor(float_col), top(float_col, 1)",
            "top(double_col, 1), floor(double_col), top(double_col, 1)",
            "top(smallint_col, 1), floor(smallint_col), top(smallint_col, 1)",
            "top(tinyint_col, 1), floor(tinyint_col), top(tinyint_col, 1)",
            "top(uint_col, 1), floor(uint_col), top(uint_col, 1)",
            "top(ubigint_col, 1), floor(ubigint_col), top(ubigint_col, 1)",
            "top(usmallint_col, 1), floor(usmallint_col), top(usmallint_col, 1)",
            "top(utinyint_col, 1), floor(utinyint_col), top(utinyint_col, 1)",
            "bottom(int_col, 1), floor(int_col), bottom(int_col, 1)",
            "bottom(bigint_col, 1), floor(bigint_col), bottom(bigint_col, 1)",
            "bottom(float_col, 1), floor(float_col), bottom(float_col, 1)",
            "bottom(double_col, 1), floor(double_col), bottom(double_col, 1)",
            "bottom(smallint_col, 1), floor(smallint_col), bottom(smallint_col, 1)",
            "bottom(tinyint_col, 1), floor(tinyint_col), bottom(tinyint_col, 1)",
            "bottom(uint_col, 1), floor(uint_col), bottom(uint_col, 1)",
            "bottom(ubigint_col, 1), floor(ubigint_col), bottom(ubigint_col, 1)",
            "bottom(usmallint_col, 1), floor(usmallint_col), bottom(usmallint_col, 1)",
            "bottom(utinyint_col, 1), floor(utinyint_col), bottom(utinyint_col, 1)",
            "percentile(int_col, 1), floor(int_col), percentile(int_col, 1)",
            "percentile(bigint_col, 1), floor(bigint_col), percentile(bigint_col, 1)",
            "percentile(float_col, 1), floor(float_col), percentile(float_col, 1)",
            "percentile(double_col, 1), floor(double_col), percentile(double_col, 1)",
            "percentile(smallint_col, 1), floor(smallint_col), percentile(smallint_col, 1)",
            "percentile(tinyint_col, 1), floor(tinyint_col), percentile(tinyint_col, 1)",
            "percentile(uint_col, 1), floor(uint_col), percentile(uint_col, 1)",
            "percentile(ubigint_col, 1), floor(ubigint_col), percentile(ubigint_col, 1)",
            "percentile(usmallint_col, 1), floor(usmallint_col), percentile(usmallint_col, 1)",
            "percentile(utinyint_col, 1), floor(utinyint_col), percentile(utinyint_col, 1)",
            "apercentile(int_col, 1), floor(int_col), apercentile(int_col, 1)",
            "apercentile(bigint_col, 1), floor(bigint_col), apercentile(bigint_col, 1)",
            "apercentile(float_col, 1), floor(float_col), apercentile(float_col, 1)",
            "apercentile(double_col, 1), floor(double_col), apercentile(double_col, 1)",
            "apercentile(smallint_col, 1), floor(smallint_col), apercentile(smallint_col, 1)",
            "apercentile(tinyint_col, 1), floor(tinyint_col), apercentile(tinyint_col, 1)",
            "apercentile(uint_col, 1), floor(uint_col), apercentile(uint_col, 1)",
            "apercentile(ubigint_col, 1), floor(ubigint_col), apercentile(ubigint_col, 1)",
            "apercentile(usmallint_col, 1), floor(usmallint_col), apercentile(usmallint_col, 1)",
            "apercentile(utinyint_col, 1), floor(utinyint_col), apercentile(utinyint_col, 1)",
            "derivative(int_col, 1s, 0), floor(int_col), derivative(int_col, 1s, 0)",
            "derivative(bigint_col, 1s, 0), floor(bigint_col), derivative(bigint_col, 1s, 0)",
            "derivative(float_col, 1s, 0), floor(float_col), derivative(float_col, 1s, 0)",
            "derivative(double_col, 1s, 0), floor(double_col), derivative(double_col, 1s, 0)",
            "derivative(smallint_col, 1s, 0), floor(smallint_col), derivative(smallint_col, 1s, 0)",
            "derivative(tinyint_col, 1s, 0), floor(tinyint_col), derivative(tinyint_col, 1s, 0)",
            "derivative(uint_col, 1s, 0), floor(uint_col), derivative(uint_col, 1s, 0)",
            "derivative(ubigint_col, 1s, 0), floor(ubigint_col), derivative(ubigint_col, 1s, 0)",
            "derivative(usmallint_col, 1s, 0), floor(usmallint_col), derivative(usmallint_col, 1s, 0)",
            "derivative(utinyint_col, 1s, 0), floor(utinyint_col), derivative(utinyint_col, 1s, 0)",
            "1, floor(int_col), 1",
            "1, floor(bigint_col), 1",
            "1, floor(float_col), 1",
            "1, floor(double_col), 1",
            "1, floor(smallint_col), 1",
            "1, floor(tinyint_col), 1",
            "1, floor(uint_col), 1",
            "1, floor(ubigint_col), 1",
            "1, floor(usmallint_col), 1",
            "1, floor(utinyint_col), 1",
            "floor(int_col) as anyName",
            "floor(bigint_col) as anyName",
            "floor(float_col) as anyName",
            "floor(double_col) as anyName",
            "floor(smallint_col) as anyName",
            "floor(tinyint_col) as anyName",
            "floor(uint_col) as anyName",
            "floor(ubigint_col) as anyName",
            "floor(usmallint_col) as anyName",
            "floor(utinyint_col) as anyName",
            "distinct floor(int_col)",
            "distinct floor(bigint_col)",
            "distinct floor(float_col)",
            "distinct floor(double_col)",
            "distinct floor(smallint_col)",
            "distinct floor(tinyint_col)",
            "distinct floor(uint_col)",
            "distinct floor(ubigint_col)",
            "distinct floor(usmallint_col)",
            "distinct floor(utinyint_col)",
        ]
        simple_select_command = [
            "floor(super.int_col)",
            "floor(super.bigint_col)",
            "floor(super.float_col)",
            "floor(super.double_col)",
            "floor(super.smallint_col)",
            "floor(super.tinyint_col)",
            "floor(super.uint_col)",
            "floor(super.ubigint_col)",
            "floor(super.usmallint_col)",
            "floor(super.utinyint_col)",
            "floor(t1.int_col)",
            "floor(t1.bigint_col)",
            "floor(t1.float_col)",
            "floor(t1.double_col)",
            "floor(t1.smallint_col)",
            "floor(t1.tinyint_col)",
            "floor(t1.uint_col)",
            "floor(t1.ubigint_col)",
            "floor(t1.usmallint_col)",
            "floor(t1.utinyint_col)",
        ]
        from_command = [" from super", " from t1"]
        advance_from_command = [
            " from super", " from t1",
            " from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag"
        ]
        filter_command = [
            "", " session(ts, 1s)", " state_window(int_col)", " interval (1s)",
            " interval (1s) sliding (1s)", " group by (ts)"
        ]
        fill_command = [
            "", " fill(prev)", " fill(next)", " fill(null)", " fill(1)",
            " fill(linear)"
        ]
        tdSql.prepare()
        tdSql.execute(
            "create stable super (ts timestamp, timestamp_col timestamp, int_col int, bigint_col bigint, float_col float,\
                double_col double, binary_col binary(8), smallint_col smallint, tinyint_col tinyint, bool_col bool, nchar_col nchar(8), \
                uint_col int unsigned, ubigint_col bigint unsigned, usmallint_col smallint unsigned,  utinyint_col tinyint unsigned) tags (int_tag int, bigint_tag bigint, \
                    float_tag float, double_tag double, binary_tag binary(8), smallint_tag smallint, tinyint_tag tinyint, bool_tag bool, nchar_tag nchar(8),\
                        uint_tag int unsigned, ubigint_tag bigint unsigned, usmallint_tag smallint unsigned, utinyint_tag tinyint unsigned, timestamp_tag timestamp)"
        )
        tdSql.execute(
            "create stable superb (ts timestamp, timestamp_col timestamp, int_col int, bigint_col bigint, float_col float,\
                double_col double, binary_col binary(8), smallint_col smallint, tinyint_col tinyint, bool_col bool, nchar_col nchar(8), \
                uint_col int unsigned, ubigint_col bigint unsigned, usmallint_col smallint unsigned,  utinyint_col tinyint unsigned) tags (int_tag int, bigint_tag bigint, \
                    float_tag float, double_tag double, binary_tag binary(8), smallint_tag smallint, tinyint_tag tinyint, bool_tag bool, nchar_tag nchar(8),\
                        uint_tag int unsigned, ubigint_tag bigint unsigned, usmallint_tag smallint unsigned, utinyint_tag tinyint unsigned, timestamp_tag timestamp)"
        )
        tdSql.execute(
            "create table t1 using super tags (1, %d, %f, %f, '%s', %d, %d, 1, '%s', %d, %d, %d, %d, %s)"
            % (self.randomBigint(), self.randomDouble(), self.randomDouble(),
               self.randomNchar(), self.randomSmallint(), self.randomTinyint(),
               self.randomNchar(), self.randomUInt(), self.randomUBigint(),
               self.randomUSmallint(), self.randomUTinyint(), 'now'))
        tdSql.execute(
            "insert into t1 values (1629796215891, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 1, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "insert into t1 values (1629796215892, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 0, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "insert into t1 values (1629796215893, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 1, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "insert into t1 values (1629796215894, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 0, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "create table t2 using superb tags (1, %d, %f, %f, '%s', %d, %d, 1, '%s', %d, %d, %d, %d, %s)"
            % (self.randomBigint(), self.randomDouble(), self.randomDouble(),
               self.randomNchar(), self.randomSmallint(), self.randomTinyint(),
               self.randomNchar(), self.randomUInt(), self.randomUBigint(),
               self.randomUSmallint(), self.randomUTinyint(), 'now'))
        tdSql.execute(
            "insert into t2 values (1629796215891, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 1, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "insert into t2 values (1629796215892, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 0, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "insert into t2 values (1629796215893, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 1, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "insert into t2 values (1629796215894, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 0, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        
        shouldPass = ['select floor(int_col) from super',
            'select floor(int_col) from t1',
            'select floor(bigint_col) from super',
            'select floor(bigint_col) from t1',
            'select floor(float_col) from super',
            'select floor(float_col) from t1',
            'select floor(double_col) from super',
            'select floor(double_col) from t1',
            'select floor(smallint_col) from super',
            'select floor(smallint_col) from t1',
            'select floor(tinyint_col) from super',
            'select floor(tinyint_col) from t1',
            'select floor(uint_col) from super',
            'select floor(uint_col) from t1',
            'select floor(ubigint_col) from super',
            'select floor(ubigint_col) from t1',
            'select floor(usmallint_col) from super',
            'select floor(usmallint_col) from t1',
            'select floor(utinyint_col) from super',
            'select floor(utinyint_col) from t1',
            'select floor(int_col) - floor(int_col) from super',
            'select floor(int_col) - floor(int_col) from t1',
            'select floor(bigint_col) - floor(bigint_col) from super',
            'select floor(bigint_col) - floor(bigint_col) from t1',
            'select floor(float_col) - floor(float_col) from super',
            'select floor(float_col) - floor(float_col) from t1',
            'select floor(double_col) - floor(double_col) from super',
            'select floor(double_col) - floor(double_col) from t1',
            'select floor(smallint_col) - floor(smallint_col) from super',
            'select floor(smallint_col) - floor(smallint_col) from t1',
            'select floor(tinyint_col) - floor(tinyint_col) from super',
            'select floor(tinyint_col) - floor(tinyint_col) from t1',
            'select floor(uint_col) - floor(uint_col) from super',
            'select floor(uint_col) - floor(uint_col) from t1',
            'select floor(ubigint_col) - floor(ubigint_col) from super',
            'select floor(ubigint_col) - floor(ubigint_col) from t1',
            'select floor(usmallint_col) - floor(usmallint_col) from super',
            'select floor(usmallint_col) - floor(usmallint_col) from t1',
            'select floor(utinyint_col) - floor(utinyint_col) from super',
            'select floor(utinyint_col) - floor(utinyint_col) from t1',
            'select floor(int_col) / floor(int_col) from super',
            'select floor(int_col) / floor(int_col) from t1',
            'select floor(bigint_col) / floor(bigint_col) from super',
            'select floor(bigint_col) / floor(bigint_col) from t1',
            'select floor(float_col) / floor(float_col) from super',
            'select floor(float_col) / floor(float_col) from t1',
            'select floor(double_col) / floor(double_col) from super',
            'select floor(double_col) / floor(double_col) from t1',
            'select floor(smallint_col) / floor(smallint_col) from super',
            'select floor(smallint_col) / floor(smallint_col) from t1',
            'select floor(tinyint_col) / floor(tinyint_col) from super',
            'select floor(tinyint_col) / floor(tinyint_col) from t1',
            'select floor(uint_col) / floor(uint_col) from super',
            'select floor(uint_col) / floor(uint_col) from t1',
            'select floor(ubigint_col) / floor(ubigint_col) from super',
            'select floor(ubigint_col) / floor(ubigint_col) from t1',
            'select floor(usmallint_col) / floor(usmallint_col) from super',
            'select floor(usmallint_col) / floor(usmallint_col) from t1',
            'select floor(utinyint_col) / floor(utinyint_col) from super',
            'select floor(utinyint_col) / floor(utinyint_col) from t1',
            'select floor(int_col) * floor(int_col) from super',
            'select floor(int_col) * floor(int_col) from t1',
            'select floor(bigint_col) * floor(bigint_col) from super',
            'select floor(bigint_col) * floor(bigint_col) from t1',
            'select floor(float_col) * floor(float_col) from super',
            'select floor(float_col) * floor(float_col) from t1',
            'select floor(double_col) * floor(double_col) from super',
            'select floor(double_col) * floor(double_col) from t1',
            'select floor(smallint_col) * floor(smallint_col) from super',
            'select floor(smallint_col) * floor(smallint_col) from t1',
            'select floor(tinyint_col) * floor(tinyint_col) from super',
            'select floor(tinyint_col) * floor(tinyint_col) from t1',
            'select floor(uint_col) * floor(uint_col) from super',
            'select floor(uint_col) * floor(uint_col) from t1',
            'select floor(ubigint_col) * floor(ubigint_col) from super',
            'select floor(ubigint_col) * floor(ubigint_col) from t1',
            'select floor(usmallint_col) * floor(usmallint_col) from super',
            'select floor(usmallint_col) * floor(usmallint_col) from t1',
            'select floor(utinyint_col) * floor(utinyint_col) from super',
            'select floor(utinyint_col) * floor(utinyint_col) from t1',
            'select floor(count(ts)) from super',
            'select floor(count(ts)) from t1',
            'select floor(count(timestamp_col)) from super',
            'select floor(count(timestamp_col)) from t1',
            'select floor(count(int_col)) from super',
            'select floor(count(int_col)) from t1',
            'select floor(count(bigint_col)) from super',
            'select floor(count(bigint_col)) from t1',
            'select floor(count(float_col)) from super',
            'select floor(count(float_col)) from t1',
            'select floor(count(double_col)) from super',
            'select floor(count(double_col)) from t1',
            'select floor(count(binary_col)) from super',
            'select floor(count(binary_col)) from t1',
            'select floor(count(smallint_col)) from super',
            'select floor(count(smallint_col)) from t1',
            'select floor(count(tinyint_col)) from super',
            'select floor(count(tinyint_col)) from t1',
            'select floor(count(bool_col)) from super',
            'select floor(count(bool_col)) from t1',
            'select floor(count(nchar_col)) from super',
            'select floor(count(nchar_col)) from t1',
            'select floor(count(uint_col)) from super',
            'select floor(count(uint_col)) from t1',
            'select floor(count(ubigint_col)) from super',
            'select floor(count(ubigint_col)) from t1',
            'select floor(count(usmallint_col)) from super',
            'select floor(count(usmallint_col)) from t1',
            'select floor(count(utinyint_col)) from super',
            'select floor(count(utinyint_col)) from t1',
            'select floor(count(timestamp_tag)) from super',
            'select floor(count(timestamp_tag)) from t1',
            'select floor(count(int_tag)) from super',
            'select floor(count(int_tag)) from t1',
            'select floor(count(bigint_tag)) from super',
            'select floor(count(bigint_tag)) from t1',
            'select floor(count(float_tag)) from super',
            'select floor(count(float_tag)) from t1',
            'select floor(count(double_tag)) from super',
            'select floor(count(double_tag)) from t1',
            'select floor(count(binary_tag)) from super',
            'select floor(count(binary_tag)) from t1',
            'select floor(count(smallint_tag)) from super',
            'select floor(count(smallint_tag)) from t1',
            'select floor(count(tinyint_tag)) from super',
            'select floor(count(tinyint_tag)) from t1',
            'select floor(count(bool_tag)) from super',
            'select floor(count(bool_tag)) from t1',
            'select floor(count(nchar_tag)) from super',
            'select floor(count(nchar_tag)) from t1',
            'select floor(count(uint_tag)) from super',
            'select floor(count(uint_tag)) from t1',
            'select floor(count(ubigint_tag)) from super',
            'select floor(count(ubigint_tag)) from t1',
            'select floor(count(usmallint_tag)) from super',
            'select floor(count(usmallint_tag)) from t1',
            'select floor(count(utinyint_tag)) from super',
            'select floor(count(utinyint_tag)) from t1',
            'select floor(avg(int_col)) from super',
            'select floor(avg(int_col)) from t1',
            'select floor(avg(bigint_col)) from super',
            'select floor(avg(bigint_col)) from t1',
            'select floor(avg(float_col)) from super',
            'select floor(avg(float_col)) from t1',
            'select floor(avg(double_col)) from super',
            'select floor(avg(double_col)) from t1',
            'select floor(avg(smallint_col)) from super',
            'select floor(avg(smallint_col)) from t1',
            'select floor(avg(tinyint_col)) from super',
            'select floor(avg(tinyint_col)) from t1',
            'select floor(avg(uint_col)) from super',
            'select floor(avg(uint_col)) from t1',
            'select floor(avg(ubigint_col)) from super',
            'select floor(avg(ubigint_col)) from t1',
            'select floor(avg(usmallint_col)) from super',
            'select floor(avg(usmallint_col)) from t1',
            'select floor(avg(utinyint_col)) from super',
            'select floor(avg(utinyint_col)) from t1',
            'select floor(twa(int_col)) from t1',
            'select floor(twa(bigint_col)) from t1',
            'select floor(twa(float_col)) from t1',
            'select floor(twa(double_col)) from t1',
            'select floor(twa(smallint_col)) from t1',
            'select floor(twa(tinyint_col)) from t1',
            'select floor(twa(uint_col)) from t1',
            'select floor(twa(ubigint_col)) from t1',
            'select floor(twa(usmallint_col)) from t1',
            'select floor(twa(utinyint_col)) from t1',
            'select floor(sum(int_col)) from super',
            'select floor(sum(int_col)) from t1',
            'select floor(sum(bigint_col)) from super',
            'select floor(sum(bigint_col)) from t1',
            'select floor(sum(float_col)) from super',
            'select floor(sum(float_col)) from t1',
            'select floor(sum(double_col)) from super',
            'select floor(sum(double_col)) from t1',
            'select floor(sum(smallint_col)) from super',
            'select floor(sum(smallint_col)) from t1',
            'select floor(sum(tinyint_col)) from super',
            'select floor(sum(tinyint_col)) from t1',
            'select floor(sum(uint_col)) from super',
            'select floor(sum(uint_col)) from t1',
            'select floor(sum(ubigint_col)) from super',
            'select floor(sum(ubigint_col)) from t1',
            'select floor(sum(usmallint_col)) from super',
            'select floor(sum(usmallint_col)) from t1',
            'select floor(sum(utinyint_col)) from super',
            'select floor(sum(utinyint_col)) from t1',
            'select floor(stddev(int_col)) from super',
            'select floor(stddev(int_col)) from t1',
            'select floor(stddev(bigint_col)) from super',
            'select floor(stddev(bigint_col)) from t1',
            'select floor(stddev(float_col)) from super',
            'select floor(stddev(float_col)) from t1',
            'select floor(stddev(double_col)) from super',
            'select floor(stddev(double_col)) from t1',
            'select floor(stddev(smallint_col)) from super',
            'select floor(stddev(smallint_col)) from t1',
            'select floor(stddev(tinyint_col)) from super',
            'select floor(stddev(tinyint_col)) from t1',
            'select floor(stddev(uint_col)) from super',
            'select floor(stddev(uint_col)) from t1',
            'select floor(stddev(ubigint_col)) from super',
            'select floor(stddev(ubigint_col)) from t1',
            'select floor(stddev(usmallint_col)) from super',
            'select floor(stddev(usmallint_col)) from t1',
            'select floor(stddev(utinyint_col)) from super',
            'select floor(stddev(utinyint_col)) from t1',
            'select floor(irate(int_col)) from t1',
            'select floor(irate(bigint_col)) from t1',
            'select floor(irate(float_col)) from t1',
            'select floor(irate(double_col)) from t1',
            'select floor(irate(smallint_col)) from t1',
            'select floor(irate(tinyint_col)) from t1',
            'select floor(irate(uint_col)) from t1',
            'select floor(irate(ubigint_col)) from t1',
            'select floor(irate(usmallint_col)) from t1',
            'select floor(irate(utinyint_col)) from t1',
            'select floor(min(int_col)) from super',
            'select floor(min(int_col)) from t1',
            'select floor(min(bigint_col)) from super',
            'select floor(min(bigint_col)) from t1',
            'select floor(min(float_col)) from super',
            'select floor(min(float_col)) from t1',
            'select floor(min(double_col)) from super',
            'select floor(min(double_col)) from t1',
            'select floor(min(smallint_col)) from super',
            'select floor(min(smallint_col)) from t1',
            'select floor(min(tinyint_col)) from super',
            'select floor(min(tinyint_col)) from t1',
            'select floor(min(uint_col)) from super',
            'select floor(min(uint_col)) from t1',
            'select floor(min(ubigint_col)) from super',
            'select floor(min(ubigint_col)) from t1',
            'select floor(min(usmallint_col)) from super',
            'select floor(min(usmallint_col)) from t1',
            'select floor(min(utinyint_col)) from super',
            'select floor(min(utinyint_col)) from t1',
            'select floor(max(int_col)) from super',
            'select floor(max(int_col)) from t1',
            'select floor(max(bigint_col)) from super',
            'select floor(max(bigint_col)) from t1',
            'select floor(max(float_col)) from super',
            'select floor(max(float_col)) from t1',
            'select floor(max(double_col)) from super',
            'select floor(max(double_col)) from t1',
            'select floor(max(smallint_col)) from super',
            'select floor(max(smallint_col)) from t1',
            'select floor(max(tinyint_col)) from super',
            'select floor(max(tinyint_col)) from t1',
            'select floor(max(uint_col)) from super',
            'select floor(max(uint_col)) from t1',
            'select floor(max(ubigint_col)) from super',
            'select floor(max(ubigint_col)) from t1',
            'select floor(max(usmallint_col)) from super',
            'select floor(max(usmallint_col)) from t1',
            'select floor(max(utinyint_col)) from super',
            'select floor(max(utinyint_col)) from t1',
            'select floor(first(int_col)) from super',
            'select floor(first(int_col)) from t1',
            'select floor(first(bigint_col)) from super',
            'select floor(first(bigint_col)) from t1',
            'select floor(first(float_col)) from super',
            'select floor(first(float_col)) from t1',
            'select floor(first(double_col)) from super',
            'select floor(first(double_col)) from t1',
            'select floor(first(smallint_col)) from super',
            'select floor(first(smallint_col)) from t1',
            'select floor(first(tinyint_col)) from super',
            'select floor(first(tinyint_col)) from t1',
            'select floor(first(uint_col)) from super',
            'select floor(first(uint_col)) from t1',
            'select floor(first(ubigint_col)) from super',
            'select floor(first(ubigint_col)) from t1',
            'select floor(first(usmallint_col)) from super',
            'select floor(first(usmallint_col)) from t1',
            'select floor(first(utinyint_col)) from super',
            'select floor(first(utinyint_col)) from t1',
            'select floor(last(int_col)) from super',
            'select floor(last(int_col)) from t1',
            'select floor(last(bigint_col)) from super',
            'select floor(last(bigint_col)) from t1',
            'select floor(last(float_col)) from super',
            'select floor(last(float_col)) from t1',
            'select floor(last(double_col)) from super',
            'select floor(last(double_col)) from t1',
            'select floor(last(smallint_col)) from super',
            'select floor(last(smallint_col)) from t1',
            'select floor(last(tinyint_col)) from super',
            'select floor(last(tinyint_col)) from t1',
            'select floor(last(uint_col)) from super',
            'select floor(last(uint_col)) from t1',
            'select floor(last(ubigint_col)) from super',
            'select floor(last(ubigint_col)) from t1',
            'select floor(last(usmallint_col)) from super',
            'select floor(last(usmallint_col)) from t1',
            'select floor(last(utinyint_col)) from super',
            'select floor(last(utinyint_col)) from t1',
            'select floor(percentile(int_col, 1)) from t1',
            'select floor(percentile(bigint_col, 1)) from t1',
            'select floor(percentile(float_col, 1)) from t1',
            'select floor(percentile(double_col, 1)) from t1',
            'select floor(percentile(smallint_col, 1)) from t1',
            'select floor(percentile(tinyint_col, 1)) from t1',
            'select floor(percentile(uint_col, 1)) from t1',
            'select floor(percentile(ubigint_col, 1)) from t1',
            'select floor(percentile(usmallint_col, 1)) from t1',
            'select floor(percentile(utinyint_col, 1)) from t1',
            'select floor(apercentile(int_col, 1)) from super',
            'select floor(apercentile(int_col, 1)) from t1',
            'select floor(apercentile(bigint_col, 1)) from super',
            'select floor(apercentile(bigint_col, 1)) from t1',
            'select floor(apercentile(float_col, 1)) from super',
            'select floor(apercentile(float_col, 1)) from t1',
            'select floor(apercentile(double_col, 1)) from super',
            'select floor(apercentile(double_col, 1)) from t1',
            'select floor(apercentile(smallint_col, 1)) from super',
            'select floor(apercentile(smallint_col, 1)) from t1',
            'select floor(apercentile(tinyint_col, 1)) from super',
            'select floor(apercentile(tinyint_col, 1)) from t1',
            'select floor(apercentile(uint_col, 1)) from super',
            'select floor(apercentile(uint_col, 1)) from t1',
            'select floor(apercentile(ubigint_col, 1)) from super',
            'select floor(apercentile(ubigint_col, 1)) from t1',
            'select floor(apercentile(usmallint_col, 1)) from super',
            'select floor(apercentile(usmallint_col, 1)) from t1',
            'select floor(apercentile(utinyint_col, 1)) from super',
            'select floor(apercentile(utinyint_col, 1)) from t1',
            'select floor(last_row(int_col)) from super',
            'select floor(last_row(int_col)) from t1',
            'select floor(last_row(bigint_col)) from super',
            'select floor(last_row(bigint_col)) from t1',
            'select floor(last_row(float_col)) from super',
            'select floor(last_row(float_col)) from t1',
            'select floor(last_row(double_col)) from super',
            'select floor(last_row(double_col)) from t1',
            'select floor(last_row(smallint_col)) from super',
            'select floor(last_row(smallint_col)) from t1',
            'select floor(last_row(tinyint_col)) from super',
            'select floor(last_row(tinyint_col)) from t1',
            'select floor(last_row(uint_col)) from super',
            'select floor(last_row(uint_col)) from t1',
            'select floor(last_row(ubigint_col)) from super',
            'select floor(last_row(ubigint_col)) from t1',
            'select floor(last_row(usmallint_col)) from super',
            'select floor(last_row(usmallint_col)) from t1',
            'select floor(last_row(utinyint_col)) from super',
            'select floor(last_row(utinyint_col)) from t1',
            'select floor(spread(ts)) from super',
            'select floor(spread(ts)) from t1',
            'select floor(spread(timestamp_col)) from super',
            'select floor(spread(timestamp_col)) from t1',
            'select floor(spread(int_col)) from super',
            'select floor(spread(int_col)) from t1',
            'select floor(spread(bigint_col)) from super',
            'select floor(spread(bigint_col)) from t1',
            'select floor(spread(float_col)) from super',
            'select floor(spread(float_col)) from t1',
            'select floor(spread(double_col)) from super',
            'select floor(spread(double_col)) from t1',
            'select floor(spread(smallint_col)) from super',
            'select floor(spread(smallint_col)) from t1',
            'select floor(spread(tinyint_col)) from super',
            'select floor(spread(tinyint_col)) from t1',
            'select floor(spread(uint_col)) from super',
            'select floor(spread(uint_col)) from t1',
            'select floor(spread(ubigint_col)) from super',
            'select floor(spread(ubigint_col)) from t1',
            'select floor(spread(usmallint_col)) from super',
            'select floor(spread(usmallint_col)) from t1',
            'select floor(spread(utinyint_col)) from super',
            'select floor(spread(utinyint_col)) from t1',
            'select floor(int_col + int_col) from super',
            'select floor(int_col + int_col) from t1',
            'select floor(bigint_col + bigint_col) from super',
            'select floor(bigint_col + bigint_col) from t1',
            'select floor(float_col + float_col) from super',
            'select floor(float_col + float_col) from t1',
            'select floor(double_col + double_col) from super',
            'select floor(double_col + double_col) from t1',
            'select floor(smallint_col + smallint_col) from super',
            'select floor(smallint_col + smallint_col) from t1',
            'select floor(tinyint_col + tinyint_col) from super',
            'select floor(tinyint_col + tinyint_col) from t1',
            'select floor(uint_col + uint_col) from super',
            'select floor(uint_col + uint_col) from t1',
            'select floor(ubigint_col + ubigint_col) from super',
            'select floor(ubigint_col + ubigint_col) from t1',
            'select floor(usmallint_col + usmallint_col) from super',
            'select floor(usmallint_col + usmallint_col) from t1',
            'select floor(utinyint_col + utinyint_col) from super',
            'select floor(utinyint_col + utinyint_col) from t1',
            'select floor(int_col - int_col) from super',
            'select floor(int_col - int_col) from t1',
            'select floor(bigint_col - bigint_col) from super',
            'select floor(bigint_col - bigint_col) from t1',
            'select floor(float_col - float_col) from super',
            'select floor(float_col - float_col) from t1',
            'select floor(double_col - double_col) from super',
            'select floor(double_col - double_col) from t1',
            'select floor(smallint_col - smallint_col) from super',
            'select floor(smallint_col - smallint_col) from t1',
            'select floor(tinyint_col - tinyint_col) from super',
            'select floor(tinyint_col - tinyint_col) from t1',
            'select floor(uint_col - uint_col) from super',
            'select floor(uint_col - uint_col) from t1',
            'select floor(ubigint_col - ubigint_col) from super',
            'select floor(ubigint_col - ubigint_col) from t1',
            'select floor(usmallint_col - usmallint_col) from super',
            'select floor(usmallint_col - usmallint_col) from t1',
            'select floor(utinyint_col - utinyint_col) from super',
            'select floor(utinyint_col - utinyint_col) from t1',
            'select floor(int_col * int_col) from super',
            'select floor(int_col * int_col) from t1',
            'select floor(bigint_col * bigint_col) from super',
            'select floor(bigint_col * bigint_col) from t1',
            'select floor(float_col * float_col) from super',
            'select floor(float_col * float_col) from t1',
            'select floor(double_col * double_col) from super',
            'select floor(double_col * double_col) from t1',
            'select floor(smallint_col * smallint_col) from super',
            'select floor(smallint_col * smallint_col) from t1',
            'select floor(tinyint_col * tinyint_col) from super',
            'select floor(tinyint_col * tinyint_col) from t1',
            'select floor(uint_col * uint_col) from super',
            'select floor(uint_col * uint_col) from t1',
            'select floor(ubigint_col * ubigint_col) from super',
            'select floor(ubigint_col * ubigint_col) from t1',
            'select floor(usmallint_col * usmallint_col) from super',
            'select floor(usmallint_col * usmallint_col) from t1',
            'select floor(utinyint_col * utinyint_col) from super',
            'select floor(utinyint_col * utinyint_col) from t1',
            'select floor(int_col / int_col) from super',
            'select floor(int_col / int_col) from t1',
            'select floor(bigint_col / bigint_col) from super',
            'select floor(bigint_col / bigint_col) from t1',
            'select floor(float_col / float_col) from super',
            'select floor(float_col / float_col) from t1',
            'select floor(double_col / double_col) from super',
            'select floor(double_col / double_col) from t1',
            'select floor(smallint_col / smallint_col) from super',
            'select floor(smallint_col / smallint_col) from t1',
            'select floor(tinyint_col / tinyint_col) from super',
            'select floor(tinyint_col / tinyint_col) from t1',
            'select floor(uint_col / uint_col) from super',
            'select floor(uint_col / uint_col) from t1',
            'select floor(ubigint_col / ubigint_col) from super',
            'select floor(ubigint_col / ubigint_col) from t1',
            'select floor(usmallint_col / usmallint_col) from super',
            'select floor(usmallint_col / usmallint_col) from t1',
            'select floor(utinyint_col / utinyint_col) from super',
            'select floor(utinyint_col / utinyint_col) from t1',
            'select int_col, floor(int_col), int_col from super',
            'select int_col, floor(int_col), int_col from t1',
            'select bigint_col, floor(bigint_col), bigint_col from super',
            'select bigint_col, floor(bigint_col), bigint_col from t1',
            'select float_col, floor(float_col), float_col from super',
            'select float_col, floor(float_col), float_col from t1',
            'select double_col, floor(double_col), double_col from super',
            'select double_col, floor(double_col), double_col from t1',
            'select smallint_col, floor(smallint_col), smallint_col from super',
            'select smallint_col, floor(smallint_col), smallint_col from t1',
            'select tinyint_col, floor(tinyint_col), tinyint_col from super',
            'select tinyint_col, floor(tinyint_col), tinyint_col from t1',
            'select uint_col, floor(uint_col), uint_col from super',
            'select uint_col, floor(uint_col), uint_col from t1',
            'select ubigint_col, floor(ubigint_col), ubigint_col from super',
            'select ubigint_col, floor(ubigint_col), ubigint_col from t1',
            'select usmallint_col, floor(usmallint_col), usmallint_col from super',
            'select usmallint_col, floor(usmallint_col), usmallint_col from t1',
            'select utinyint_col, floor(utinyint_col), utinyint_col from super',
            'select utinyint_col, floor(utinyint_col), utinyint_col from t1',
            'select 1, floor(int_col), 1 from super',
            'select 1, floor(int_col), 1 from t1',
            'select 1, floor(bigint_col), 1 from super',
            'select 1, floor(bigint_col), 1 from t1',
            'select 1, floor(float_col), 1 from super',
            'select 1, floor(float_col), 1 from t1',
            'select 1, floor(double_col), 1 from super',
            'select 1, floor(double_col), 1 from t1',
            'select 1, floor(smallint_col), 1 from super',
            'select 1, floor(smallint_col), 1 from t1',
            'select 1, floor(tinyint_col), 1 from super',
            'select 1, floor(tinyint_col), 1 from t1',
            'select 1, floor(uint_col), 1 from super',
            'select 1, floor(uint_col), 1 from t1',
            'select 1, floor(ubigint_col), 1 from super',
            'select 1, floor(ubigint_col), 1 from t1',
            'select 1, floor(usmallint_col), 1 from super',
            'select 1, floor(usmallint_col), 1 from t1',
            'select 1, floor(utinyint_col), 1 from super',
            'select 1, floor(utinyint_col), 1 from t1',
            'select floor(int_col) as anyName from super',
            'select floor(int_col) as anyName from t1',
            'select floor(bigint_col) as anyName from super',
            'select floor(bigint_col) as anyName from t1',
            'select floor(float_col) as anyName from super',
            'select floor(float_col) as anyName from t1',
            'select floor(double_col) as anyName from super',
            'select floor(double_col) as anyName from t1',
            'select floor(smallint_col) as anyName from super',
            'select floor(smallint_col) as anyName from t1',
            'select floor(tinyint_col) as anyName from super',
            'select floor(tinyint_col) as anyName from t1',
            'select floor(uint_col) as anyName from super',
            'select floor(uint_col) as anyName from t1',
            'select floor(ubigint_col) as anyName from super',
            'select floor(ubigint_col) as anyName from t1',
            'select floor(usmallint_col) as anyName from super',
            'select floor(usmallint_col) as anyName from t1',
            'select floor(utinyint_col) as anyName from super',
            'select floor(utinyint_col) as anyName from t1']

        shouldPass2 = ['select floor(super.int_col) from super',
            'select floor(super.int_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select floor(super.bigint_col) from super',
            'select floor(super.bigint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select floor(super.float_col) from super',
            'select floor(super.float_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select floor(super.double_col) from super',
            'select floor(super.double_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select floor(super.smallint_col) from super',
            'select floor(super.smallint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select floor(super.tinyint_col) from super',
            'select floor(super.tinyint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select floor(super.uint_col) from super',
            'select floor(super.uint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select floor(super.ubigint_col) from super',
            'select floor(super.ubigint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select floor(super.usmallint_col) from super',
            'select floor(super.usmallint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select floor(super.utinyint_col) from super',
            'select floor(super.utinyint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select floor(t1.int_col) from t1',
            'select floor(t1.bigint_col) from t1',
            'select floor(t1.float_col) from t1',
            'select floor(t1.double_col) from t1',
            'select floor(t1.smallint_col) from t1',
            'select floor(t1.tinyint_col) from t1',
            'select floor(t1.uint_col) from t1',
            'select floor(t1.ubigint_col) from t1',
            'select floor(t1.usmallint_col) from t1',
            'select floor(t1.utinyint_col) from t1']


        for s in range(len(select_command)):
            for f in range(len(from_command)):
                sql = "select " + select_command[s] + from_command[f]
                if sql in shouldPass:
                    tdSql.query(sql)
                else:
                    tdSql.error(sql)
        for sim in range(len(simple_select_command)):
            for fr in range(len(advance_from_command)):
                for filter in range(len(filter_command)):
                    for fill in range(len(fill_command)):
                        sql = "select " + simple_select_command[
                            sim] + advance_from_command[fr] + filter_command[
                                filter] + fill_command[fill]
                        if sql in shouldPass2:        
                            tdSql.query(sql)
                        else:
                            tdSql.error(sql)                    
    def stop(self):
        tdSql.close()
        tdLog.success("%s successfully executed" % __file__)


tdCases.addWindows(__file__, TDTestCase())
tdCases.addLinux(__file__, TDTestCase())
