###################################################################
#           Copyright (c) 2016 by TAOS Technologies, Inc.
#                     All rights reserved.
#
#  This file is proprietary and confidential to TAOS Technologies.
#  No part of this file may be reproduced, stored, transmitted,
#  disclosed or used in any form or by any means other than as
#  expressly provided by the written permission from Jianhui Tao
#
###################################################################

# -*- coding: utf-8 -*-

import sys
import taos
from util.log import *
from util.cases import *
from util.sql import *
import numpy as np
import random


class TDTestCase:
    def init(self, conn, logSql):
        tdLog.debug("start to execute %s" % __file__)
        tdSql.init(conn.cursor())

    def randomInt(self):
        return random.randint(-2147483647, 2147483647)

    def randomUInt(self):
        return random.randint(0, 4294967294)

    def randomBigint(self):
        return random.randint(-2**63 + 1, 2**63 - 1)

    def randomUBigint(self):
        return random.randint(0, 18446744073709551614)

    def randomDouble(self):
        return random.random()

    def randomNchar(self):
        return random.choice('abcdefghijklmnopqrstuvwxyz')

    def randomSmallint(self):
        return random.randint(-32767, 32767)

    def randomUSmallint(self):
        return random.randint(0, 65534)

    def randomTinyint(self):
        return random.randint(-127, 127)

    def randomUTinyint(self):
        return random.randint(0, 254)

    def run(self):
        select_command = [
            "ceil(ts)",
            "ceil(timestamp_col)",
            "ceil(int_col)",
            "ceil(bigint_col)",
            "ceil(float_col)",
            "ceil(double_col)",
            "ceil(binary_col)",
            "ceil(smallint_col)",
            "ceil(tinyint_col)",
            "ceil(bool_col)",
            "ceil(nchar_col)",
            "ceil(uint_col)",
            "ceil(ubigint_col)",
            "ceil(usmallint_col)",
            "ceil(utinyint_col)",
            "ceil(timestamp_tag)",
            "ceil(int_tag)",
            "ceil(bigint_tag)",
            "ceil(float_tag)",
            "ceil(double_tag)",
            "ceil(binary_tag)",
            "ceil(smallint_tag)",
            "ceil(tinyint_tag)",
            "ceil(bool_tag)",
            "ceil(nchar_tag)",
            "ceil(uint_tag)",
            "ceil(ubigint_tag)",
            "ceil(usmallint_tag)",
            "ceil(utinyint_tag)",
            "count(ceil(int_col))",
            "count(ceil(bigint_col))",
            "count(ceil(float_col))",
            "count(ceil(double_col))",
            "count(ceil(smallint_col))",
            "count(ceil(tinyint_col))",
            "count(ceil(uint_col))",
            "count(ceil(ubigint_col))",
            "count(ceil(usmallint_col))",
            "count(ceil(utinyint_col))",
            "avg(ceil(int_col))",
            "avg(ceil(bigint_col))",
            "avg(ceil(float_col))",
            "avg(ceil(double_col))",
            "avg(ceil(smallint_col))",
            "avg(ceil(tinyint_col))",
            "avg(ceil(uint_col))",
            "avg(ceil(ubigint_col))",
            "avg(ceil(usmallint_col))",
            "avg(ceil(utinyint_col))",
            "twa(ceil(int_col))",
            "twa(ceil(bigint_col))",
            "twa(ceil(float_col))",
            "twa(ceil(double_col))",
            "twa(ceil(smallint_col))",
            "twa(ceil(tinyint_col))",
            "twa(ceil(uint_col))",
            "twa(ceil(ubigint_col))",
            "twa(ceil(usmallint_col))",
            "twa(ceil(utinyint_col))",
            "sum(ceil(int_col))",
            "sum(ceil(bigint_col))",
            "sum(ceil(float_col))",
            "sum(ceil(double_col))",
            "sum(ceil(smallint_col))",
            "sum(ceil(tinyint_col))",
            "sum(ceil(uint_col))",
            "sum(ceil(ubigint_col))",
            "sum(ceil(usmallint_col))",
            "sum(ceil(utinyint_col))",
            "stddev(ceil(int_col))",
            "stddev(ceil(bigint_col))",
            "stddev(ceil(float_col))",
            "stddev(ceil(double_col))",
            "stddev(ceil(smallint_col))",
            "stddev(ceil(tinyint_col))",
            "stddev(ceil(uint_col))",
            "stddev(ceil(ubigint_col))",
            "stddev(ceil(usmallint_col))",
            "stddev(ceil(utinyint_col))",
            "irate(ceil(int_col))",
            "irate(ceil(bigint_col))",
            "irate(ceil(float_col))",
            "irate(ceil(double_col))",
            "irate(ceil(smallint_col))",
            "irate(ceil(tinyint_col))",
            "irate(ceil(uint_col))",
            "irate(ceil(ubigint_col))",
            "irate(ceil(usmallint_col))",
            "irate(ceil(utinyint_col))",
            "leastsquares(ceil(int_col), 1, 1)",
            "leastsquares(ceil(bigint_col), 1, 1)",
            "leastsquares(ceil(float_col), 1, 1)",
            "leastsquares(ceil(double_col), 1, 1)",
            "leastsquares(ceil(smallint_col), 1, 1)",
            "leastsquares(ceil(tinyint_col), 1, 1)",
            "leastsquares(ceil(uint_col), 1, 1)",
            "leastsquares(ceil(ubigint_col), 1, 1)",
            "leastsquares(ceil(usmallint_col), 1, 1)",
            "leastsquares(ceil(utinyint_col), 1, 1)",
            "min(ceil(int_col))",
            "min(ceil(bigint_col))",
            "min(ceil(float_col))",
            "min(ceil(double_col))",
            "min(ceil(smallint_col))",
            "min(ceil(tinyint_col))",
            "min(ceil(uint_col))",
            "min(ceil(ubigint_col))",
            "min(ceil(usmallint_col))",
            "min(ceil(utinyint_col))",
            "max(ceil(int_col))",
            "max(ceil(bigint_col))",
            "max(ceil(float_col))",
            "max(ceil(double_col))",
            "max(ceil(smallint_col))",
            "max(ceil(tinyint_col))",
            "max(ceil(uint_col))",
            "max(ceil(ubigint_col))",
            "max(ceil(usmallint_col))",
            "max(ceil(utinyint_col))",
            "first(ceil(int_col))",
            "first(ceil(bigint_col))",
            "first(ceil(float_col))",
            "first(ceil(double_col))",
            "first(ceil(smallint_col))",
            "first(ceil(tinyint_col))",
            "first(ceil(uint_col))",
            "first(ceil(ubigint_col))",
            "first(ceil(usmallint_col))",
            "first(ceil(utinyint_col))",
            "last(ceil(int_col))",
            "last(ceil(bigint_col))",
            "last(ceil(float_col))",
            "last(ceil(double_col))",
            "last(ceil(smallint_col))",
            "last(ceil(tinyint_col))",
            "last(ceil(uint_col))",
            "last(ceil(ubigint_col))",
            "last(ceil(usmallint_col))",
            "last(ceil(utinyint_col))",
            "top(ceil(int_col), 1)",
            "top(ceil(bigint_col), 1)",
            "top(ceil(float_col), 1)",
            "top(ceil(double_col), 1)",
            "top(ceil(smallint_col), 1)",
            "top(ceil(tinyint_col), 1)",
            "top(ceil(uint_col), 1)",
            "top(ceil(ubigint_col), 1)",
            "top(ceil(usmallint_col), 1)",
            "top(ceil(utinyint_col), 1)",
            "bottom(ceil(int_col), 1)",
            "bottom(ceil(bigint_col), 1)",
            "bottom(ceil(float_col), 1)",
            "bottom(ceil(double_col), 1)",
            "bottom(ceil(smallint_col), 1)",
            "bottom(ceil(tinyint_col), 1)",
            "bottom(ceil(uint_col), 1)",
            "bottom(ceil(ubigint_col), 1)",
            "bottom(ceil(usmallint_col), 1)",
            "bottom(ceil(utinyint_col), 1)",
            "percentile(ceil(int_col), 20)",
            "percentile(ceil(bigint_col), 20)",
            "percentile(ceil(float_col), 20)",
            "percentile(ceil(double_col), 20)",
            "percentile(ceil(smallint_col), 20)",
            "percentile(ceil(tinyint_col), 20)",
            "percentile(ceil(uint_col), 20)",
            "percentile(ceil(ubigint_col), 20)",
            "percentile(ceil(usmallint_col), 20)",
            "percentile(ceil(utinyint_col), 20)",
            "apercentile(ceil(int_col), 20)",
            "apercentile(ceil(bigint_col), 20)",
            "apercentile(ceil(float_col), 20)",
            "apercentile(ceil(double_col), 20)",
            "apercentile(ceil(smallint_col), 20)",
            "apercentile(ceil(tinyint_col), 20)",
            "apercentile(ceil(uint_col), 20)",
            "apercentile(ceil(ubigint_col), 20)",
            "apercentile(ceil(usmallint_col), 20)",
            "apercentile(ceil(utinyint_col), 20)",
            "last_row(ceil(int_col))",
            "last_row(ceil(bigint_col))",
            "last_row(ceil(float_col))",
            "last_row(ceil(double_col))",
            "last_row(ceil(smallint_col))",
            "last_row(ceil(tinyint_col))",
            "last_row(ceil(uint_col))",
            "last_row(ceil(ubigint_col))",
            "last_row(ceil(usmallint_col))",
            "last_row(ceil(utinyint_col))",
            "interp(ceil(int_col))",
            "interp(ceil(bigint_col))",
            "interp(ceil(float_col))",
            "interp(ceil(double_col))",
            "interp(ceil(smallint_col))",
            "interp(ceil(tinyint_col))",
            "interp(ceil(uint_col))",
            "interp(ceil(ubigint_col))",
            "interp(ceil(usmallint_col))",
            "interp(ceil(utinyint_col))",
            "diff(ceil(int_col))",
            "diff(ceil(bigint_col))",
            "diff(ceil(float_col))",
            "diff(ceil(double_col))",
            "diff(ceil(smallint_col))",
            "diff(ceil(tinyint_col))",
            "diff(ceil(uint_col))",
            "diff(ceil(ubigint_col))",
            "diff(ceil(usmallint_col))",
            "diff(ceil(utinyint_col))",
            "spread(ceil(int_col))",
            "spread(ceil(bigint_col))",
            "spread(ceil(float_col))",
            "spread(ceil(double_col))",
            "spread(ceil(smallint_col))",
            "spread(ceil(tinyint_col))",
            "spread(ceil(uint_col))",
            "spread(ceil(ubigint_col))",
            "spread(ceil(usmallint_col))",
            "spread(ceil(utinyint_col))",
            "derivative(ceil(int_col), 1s, 0)",
            "derivative(ceil(bigint_col), 1s, 0)",
            "derivative(ceil(float_col), 1s, 0)",
            "derivative(ceil(double_col), 1s, 0)",
            "derivative(ceil(smallint_col), 1s, 0)",
            "derivative(ceil(tinyint_col), 1s, 0)",
            "derivative(ceil(uint_col), 1s, 0)",
            "derivative(ceil(ubigint_col), 1s, 0)",
            "derivative(ceil(usmallint_col), 1s, 0)",
            "derivative(ceil(utinyint_col), 1s, 0)",
            "ceil(int_col) - ceil(int_col)",
            "ceil(bigint_col) - ceil(bigint_col)",
            "ceil(float_col) - ceil(float_col)",
            "ceil(double_col) - ceil(double_col)",
            "ceil(smallint_col) - ceil(smallint_col)",
            "ceil(tinyint_col) - ceil(tinyint_col)",
            "ceil(uint_col) - ceil(uint_col)",
            "ceil(ubigint_col) - ceil(ubigint_col)",
            "ceil(usmallint_col) - ceil(usmallint_col)",
            "ceil(utinyint_col) - ceil(utinyint_col)",
            "ceil(int_col) / ceil(int_col)",
            "ceil(bigint_col) / ceil(bigint_col)",
            "ceil(float_col) / ceil(float_col)",
            "ceil(double_col) / ceil(double_col)",
            "ceil(smallint_col) / ceil(smallint_col)",
            "ceil(tinyint_col) / ceil(tinyint_col)",
            "ceil(uint_col) / ceil(uint_col)",
            "ceil(ubigint_col) / ceil(ubigint_col)",
            "ceil(usmallint_col) / ceil(usmallint_col)",
            "ceil(utinyint_col) / ceil(utinyint_col)",
            "ceil(int_col) * ceil(int_col)",
            "ceil(bigint_col) * ceil(bigint_col)",
            "ceil(float_col) * ceil(float_col)",
            "ceil(double_col) * ceil(double_col)",
            "ceil(smallint_col) * ceil(smallint_col)",
            "ceil(tinyint_col) * ceil(tinyint_col)",
            "ceil(uint_col) * ceil(uint_col)",
            "ceil(ubigint_col) * ceil(ubigint_col)",
            "ceil(usmallint_col) * ceil(usmallint_col)",
            "ceil(utinyint_col) * ceil(utinyint_col)",
            "ceil(count(ts))",
            "ceil(count(timestamp_col))",
            "ceil(count(int_col))",
            "ceil(count(bigint_col))",
            "ceil(count(float_col))",
            "ceil(count(double_col))",
            "ceil(count(binary_col))",
            "ceil(count(smallint_col))",
            "ceil(count(tinyint_col))",
            "ceil(count(bool_col))",
            "ceil(count(nchar_col))",
            "ceil(count(uint_col))",
            "ceil(count(ubigint_col))",
            "ceil(count(usmallint_col))",
            "ceil(count(utinyint_col))",
            "ceil(count(timestamp_tag))",
            "ceil(count(int_tag))",
            "ceil(count(bigint_tag))",
            "ceil(count(float_tag))",
            "ceil(count(double_tag))",
            "ceil(count(binary_tag))",
            "ceil(count(smallint_tag))",
            "ceil(count(tinyint_tag))",
            "ceil(count(bool_tag))",
            "ceil(count(nchar_tag))",
            "ceil(count(uint_tag))",
            "ceil(count(ubigint_tag))",
            "ceil(count(usmallint_tag))",
            "ceil(count(utinyint_tag))",
            "ceil(avg(ts))",
            "ceil(avg(timestamp_col))",
            "ceil(avg(int_col))",
            "ceil(avg(bigint_col))",
            "ceil(avg(float_col))",
            "ceil(avg(double_col))",
            "ceil(avg(binary_col))",
            "ceil(avg(smallint_col))",
            "ceil(avg(tinyint_col))",
            "ceil(avg(bool_col))",
            "ceil(avg(nchar_col))",
            "ceil(avg(uint_col))",
            "ceil(avg(ubigint_col))",
            "ceil(avg(usmallint_col))",
            "ceil(avg(utinyint_col))",
            "ceil(avg(timestamp_tag))",
            "ceil(avg(int_tag))",
            "ceil(avg(bigint_tag))",
            "ceil(avg(float_tag))",
            "ceil(avg(double_tag))",
            "ceil(avg(binary_tag))",
            "ceil(avg(smallint_tag))",
            "ceil(avg(tinyint_tag))",
            "ceil(avg(bool_tag))",
            "ceil(avg(nchar_tag))",
            "ceil(avg(uint_tag))",
            "ceil(avg(ubigint_tag))",
            "ceil(avg(usmallint_tag))",
            "ceil(avg(utinyint_tag))",
            "ceil(twa(ts))",
            "ceil(twa(timestamp_col))",
            "ceil(twa(int_col))",
            "ceil(twa(bigint_col))",
            "ceil(twa(float_col))",
            "ceil(twa(double_col))",
            "ceil(twa(binary_col))",
            "ceil(twa(smallint_col))",
            "ceil(twa(tinyint_col))",
            "ceil(twa(bool_col))",
            "ceil(twa(nchar_col))",
            "ceil(twa(uint_col))",
            "ceil(twa(ubigint_col))",
            "ceil(twa(usmallint_col))",
            "ceil(twa(utinyint_col))",
            "ceil(twa(timestamp_tag))",
            "ceil(twa(int_tag))",
            "ceil(twa(bigint_tag))",
            "ceil(twa(float_tag))",
            "ceil(twa(double_tag))",
            "ceil(twa(binary_tag))",
            "ceil(twa(smallint_tag))",
            "ceil(twa(tinyint_tag))",
            "ceil(twa(bool_tag))",
            "ceil(twa(nchar_tag))",
            "ceil(twa(uint_tag))",
            "ceil(twa(ubigint_tag))",
            "ceil(twa(usmallint_tag))",
            "ceil(twa(utinyint_tag))",
            "ceil(sum(ts))",
            "ceil(sum(timestamp_col))",
            "ceil(sum(int_col))",
            "ceil(sum(bigint_col))",
            "ceil(sum(float_col))",
            "ceil(sum(double_col))",
            "ceil(sum(binary_col))",
            "ceil(sum(smallint_col))",
            "ceil(sum(tinyint_col))",
            "ceil(sum(bool_col))",
            "ceil(sum(nchar_col))",
            "ceil(sum(uint_col))",
            "ceil(sum(ubigint_col))",
            "ceil(sum(usmallint_col))",
            "ceil(sum(utinyint_col))",
            "ceil(sum(timestamp_tag))",
            "ceil(sum(int_tag))",
            "ceil(sum(bigint_tag))",
            "ceil(sum(float_tag))",
            "ceil(sum(double_tag))",
            "ceil(sum(binary_tag))",
            "ceil(sum(smallint_tag))",
            "ceil(sum(tinyint_tag))",
            "ceil(sum(bool_tag))",
            "ceil(sum(nchar_tag))",
            "ceil(sum(uint_tag))",
            "ceil(sum(ubigint_tag))",
            "ceil(sum(usmallint_tag))",
            "ceil(sum(utinyint_tag))",
            "ceil(stddev(ts))",
            "ceil(stddev(timestamp_col))",
            "ceil(stddev(int_col))",
            "ceil(stddev(bigint_col))",
            "ceil(stddev(float_col))",
            "ceil(stddev(double_col))",
            "ceil(stddev(binary_col))",
            "ceil(stddev(smallint_col))",
            "ceil(stddev(tinyint_col))",
            "ceil(stddev(bool_col))",
            "ceil(stddev(nchar_col))",
            "ceil(stddev(uint_col))",
            "ceil(stddev(ubigint_col))",
            "ceil(stddev(usmallint_col))",
            "ceil(stddev(utinyint_col))",
            "ceil(stddev(timestamp_tag))",
            "ceil(stddev(int_tag))",
            "ceil(stddev(bigint_tag))",
            "ceil(stddev(float_tag))",
            "ceil(stddev(double_tag))",
            "ceil(stddev(binary_tag))",
            "ceil(stddev(smallint_tag))",
            "ceil(stddev(tinyint_tag))",
            "ceil(stddev(bool_tag))",
            "ceil(stddev(nchar_tag))",
            "ceil(stddev(uint_tag))",
            "ceil(stddev(ubigint_tag))",
            "ceil(stddev(usmallint_tag))",
            "ceil(stddev(utinyint_tag))",
            "ceil(leastsquares(ts, 1, 1))",
            "ceil(leastsquares(timestamp_col, 1, 1))",
            "ceil(leastsquares(int_col, 1, 1))",
            "ceil(leastsquares(bigint_col, 1, 1))",
            "ceil(leastsquares(float_col, 1, 1))",
            "ceil(leastsquares(double_col, 1, 1))",
            "ceil(leastsquares(binary_col, 1, 1))",
            "ceil(leastsquares(smallint_col, 1, 1))",
            "ceil(leastsquares(tinyint_col, 1, 1))",
            "ceil(leastsquares(bool_col, 1, 1))",
            "ceil(leastsquares(nchar_col, 1, 1))",
            "ceil(leastsquares(uint_col, 1, 1))",
            "ceil(leastsquares(ubigint_col, 1, 1))",
            "ceil(leastsquares(usmallint_col, 1, 1))",
            "ceil(leastsquares(utinyint_col, 1, 1))",
            "ceil(leastsquares(timestamp_tag, 1, 1))",
            "ceil(leastsquares(int_tag, 1, 1))",
            "ceil(leastsquares(bigint_tag, 1, 1))",
            "ceil(leastsquares(float_tag, 1, 1))",
            "ceil(leastsquares(double_tag, 1, 1))",
            "ceil(leastsquares(binary_tag, 1, 1))",
            "ceil(leastsquares(smallint_tag, 1, 1))",
            "ceil(leastsquares(tinyint_tag, 1, 1))",
            "ceil(leastsquares(bool_tag, 1, 1))",
            "ceil(leastsquares(nchar_tag, 1, 1))",
            "ceil(leastsquares(uint_tag, 1, 1))",
            "ceil(leastsquares(ubigint_tag, 1, 1))",
            "ceil(leastsquares(usmallint_tag, 1, 1))",
            "ceil(leastsquares(utinyint_tag, 1, 1))",
            "ceil(irate(ts))",
            "ceil(irate(timestamp_col))",
            "ceil(irate(int_col))",
            "ceil(irate(bigint_col))",
            "ceil(irate(float_col))",
            "ceil(irate(double_col))",
            "ceil(irate(binary_col))",
            "ceil(irate(smallint_col))",
            "ceil(irate(tinyint_col))",
            "ceil(irate(bool_col))",
            "ceil(irate(nchar_col))",
            "ceil(irate(uint_col))",
            "ceil(irate(ubigint_col))",
            "ceil(irate(usmallint_col))",
            "ceil(irate(utinyint_col))",
            "ceil(irate(timestamp_tag))",
            "ceil(irate(int_tag))",
            "ceil(irate(bigint_tag))",
            "ceil(irate(float_tag))",
            "ceil(irate(double_tag))",
            "ceil(irate(binary_tag))",
            "ceil(irate(smallint_tag))",
            "ceil(irate(tinyint_tag))",
            "ceil(irate(bool_tag))",
            "ceil(irate(nchar_tag))",
            "ceil(irate(uint_tag))",
            "ceil(irate(ubigint_tag))",
            "ceil(irate(usmallint_tag))",
            "ceil(irate(utinyint_tag))",
            "ceil(min(ts))",
            "ceil(min(timestamp_col))",
            "ceil(min(int_col))",
            "ceil(min(bigint_col))",
            "ceil(min(float_col))",
            "ceil(min(double_col))",
            "ceil(min(binary_col))",
            "ceil(min(smallint_col))",
            "ceil(min(tinyint_col))",
            "ceil(min(bool_col))",
            "ceil(min(nchar_col))",
            "ceil(min(uint_col))",
            "ceil(min(ubigint_col))",
            "ceil(min(usmallint_col))",
            "ceil(min(utinyint_col))",
            "ceil(min(timestamp_tag))",
            "ceil(min(int_tag))",
            "ceil(min(bigint_tag))",
            "ceil(min(float_tag))",
            "ceil(min(double_tag))",
            "ceil(min(binary_tag))",
            "ceil(min(smallint_tag))",
            "ceil(min(tinyint_tag))",
            "ceil(min(bool_tag))",
            "ceil(min(nchar_tag))",
            "ceil(min(uint_tag))",
            "ceil(min(ubigint_tag))",
            "ceil(min(usmallint_tag))",
            "ceil(min(utinyint_tag))",
            "ceil(max(ts))",
            "ceil(max(timestamp_col))",
            "ceil(max(int_col))",
            "ceil(max(bigint_col))",
            "ceil(max(float_col))",
            "ceil(max(double_col))",
            "ceil(max(binary_col))",
            "ceil(max(smallint_col))",
            "ceil(max(tinyint_col))",
            "ceil(max(bool_col))",
            "ceil(max(nchar_col))",
            "ceil(max(uint_col))",
            "ceil(max(ubigint_col))",
            "ceil(max(usmallint_col))",
            "ceil(max(utinyint_col))",
            "ceil(max(timestamp_tag))",
            "ceil(max(int_tag))",
            "ceil(max(bigint_tag))",
            "ceil(max(float_tag))",
            "ceil(max(double_tag))",
            "ceil(max(binary_tag))",
            "ceil(max(smallint_tag))",
            "ceil(max(tinyint_tag))",
            "ceil(max(bool_tag))",
            "ceil(max(nchar_tag))",
            "ceil(max(uint_tag))",
            "ceil(max(ubigint_tag))",
            "ceil(max(usmallint_tag))",
            "ceil(max(utinyint_tag))",
            "ceil(first(ts))",
            "ceil(first(timestamp_col))",
            "ceil(first(int_col))",
            "ceil(first(bigint_col))",
            "ceil(first(float_col))",
            "ceil(first(double_col))",
            "ceil(first(binary_col))",
            "ceil(first(smallint_col))",
            "ceil(first(tinyint_col))",
            "ceil(first(bool_col))",
            "ceil(first(nchar_col))",
            "ceil(first(uint_col))",
            "ceil(first(ubigint_col))",
            "ceil(first(usmallint_col))",
            "ceil(first(utinyint_col))",
            "ceil(first(timestamp_tag))",
            "ceil(first(int_tag))",
            "ceil(first(bigint_tag))",
            "ceil(first(float_tag))",
            "ceil(first(double_tag))",
            "ceil(first(binary_tag))",
            "ceil(first(smallint_tag))",
            "ceil(first(tinyint_tag))",
            "ceil(first(bool_tag))",
            "ceil(first(nchar_tag))",
            "ceil(first(uint_tag))",
            "ceil(first(ubigint_tag))",
            "ceil(first(usmallint_tag))",
            "ceil(first(utinyint_tag))",
            "ceil(last(ts))",
            "ceil(last(timestamp_col))",
            "ceil(last(int_col))",
            "ceil(last(bigint_col))",
            "ceil(last(float_col))",
            "ceil(last(double_col))",
            "ceil(last(binary_col))",
            "ceil(last(smallint_col))",
            "ceil(last(tinyint_col))",
            "ceil(last(bool_col))",
            "ceil(last(nchar_col))",
            "ceil(last(uint_col))",
            "ceil(last(ubigint_col))",
            "ceil(last(usmallint_col))",
            "ceil(last(utinyint_col))",
            "ceil(last(timestamp_tag))",
            "ceil(last(int_tag))",
            "ceil(last(bigint_tag))",
            "ceil(last(float_tag))",
            "ceil(last(double_tag))",
            "ceil(last(binary_tag))",
            "ceil(last(smallint_tag))",
            "ceil(last(tinyint_tag))",
            "ceil(last(bool_tag))",
            "ceil(last(nchar_tag))",
            "ceil(last(uint_tag))",
            "ceil(last(ubigint_tag))",
            "ceil(last(usmallint_tag))",
            "ceil(last(utinyint_tag))",
            "ceil(top(ts, 1))",
            "ceil(top(timestamp_col, 1))",
            "ceil(top(int_col, 1))",
            "ceil(top(bigint_col, 1))",
            "ceil(top(float_col, 1))",
            "ceil(top(double_col, 1))",
            "ceil(top(binary_col, 1))",
            "ceil(top(smallint_col, 1))",
            "ceil(top(tinyint_col, 1))",
            "ceil(top(bool_col, 1))",
            "ceil(top(nchar_col, 1))",
            "ceil(top(uint_col, 1))",
            "ceil(top(ubigint_col, 1))",
            "ceil(top(usmallint_col, 1))",
            "ceil(top(utinyint_col, 1))",
            "ceil(top(timestamp_tag, 1))",
            "ceil(top(int_tag, 1))",
            "ceil(top(bigint_tag, 1))",
            "ceil(top(float_tag, 1))",
            "ceil(top(double_tag, 1))",
            "ceil(top(binary_tag, 1))",
            "ceil(top(smallint_tag, 1))",
            "ceil(top(tinyint_tag, 1))",
            "ceil(top(bool_tag, 1))",
            "ceil(top(nchar_tag, 1))",
            "ceil(top(uint_tag, 1))",
            "ceil(top(ubigint_tag, 1))",
            "ceil(top(usmallint_tag, 1))",
            "ceil(top(utinyint_tag, 1))",
            "ceil(bottom(ts, 1))",
            "ceil(bottom(timestamp_col, 1))",
            "ceil(bottom(int_col, 1))",
            "ceil(bottom(bigint_col, 1))",
            "ceil(bottom(float_col, 1))",
            "ceil(bottom(double_col, 1))",
            "ceil(bottom(binary_col, 1))",
            "ceil(bottom(smallint_col, 1))",
            "ceil(bottom(tinyint_col, 1))",
            "ceil(bottom(bool_col, 1))",
            "ceil(bottom(nchar_col, 1))",
            "ceil(bottom(uint_col, 1))",
            "ceil(bottom(ubigint_col, 1))",
            "ceil(bottom(usmallint_col, 1))",
            "ceil(bottom(utinyint_col, 1))",
            "ceil(bottom(timestamp_tag, 1))",
            "ceil(bottom(int_tag, 1))",
            "ceil(bottom(bigint_tag, 1))",
            "ceil(bottom(float_tag, 1))",
            "ceil(bottom(double_tag, 1))",
            "ceil(bottom(binary_tag, 1))",
            "ceil(bottom(smallint_tag, 1))",
            "ceil(bottom(tinyint_tag, 1))",
            "ceil(bottom(bool_tag, 1))",
            "ceil(bottom(nchar_tag, 1))",
            "ceil(bottom(uint_tag, 1))",
            "ceil(bottom(ubigint_tag, 1))",
            "ceil(bottom(usmallint_tag, 1))",
            "ceil(bottom(utinyint_tag, 1))",
            "ceil(percentile(ts, 1))",
            "ceil(percentile(timestamp_col, 1))",
            "ceil(percentile(int_col, 1))",
            "ceil(percentile(bigint_col, 1))",
            "ceil(percentile(float_col, 1))",
            "ceil(percentile(double_col, 1))",
            "ceil(percentile(binary_col, 1))",
            "ceil(percentile(smallint_col, 1))",
            "ceil(percentile(tinyint_col, 1))",
            "ceil(percentile(bool_col, 1))",
            "ceil(percentile(nchar_col, 1))",
            "ceil(percentile(uint_col, 1))",
            "ceil(percentile(ubigint_col, 1))",
            "ceil(percentile(usmallint_col, 1))",
            "ceil(percentile(utinyint_col, 1))",
            "ceil(percentile(timestamp_tag, 1))",
            "ceil(percentile(int_tag, 1))",
            "ceil(percentile(bigint_tag, 1))",
            "ceil(percentile(float_tag, 1))",
            "ceil(percentile(double_tag, 1))",
            "ceil(percentile(binary_tag, 1))",
            "ceil(percentile(smallint_tag, 1))",
            "ceil(percentile(tinyint_tag, 1))",
            "ceil(percentile(bool_tag, 1))",
            "ceil(percentile(nchar_tag, 1))",
            "ceil(percentile(uint_tag, 1))",
            "ceil(percentile(ubigint_tag, 1))",
            "ceil(percentile(usmallint_tag, 1))",
            "ceil(percentile(utinyint_tag, 1))",
            "ceil(apercentile(ts, 1))",
            "ceil(apercentile(timestamp_col, 1))",
            "ceil(apercentile(int_col, 1))",
            "ceil(apercentile(bigint_col, 1))",
            "ceil(apercentile(float_col, 1))",
            "ceil(apercentile(double_col, 1))",
            "ceil(apercentile(binary_col, 1))",
            "ceil(apercentile(smallint_col, 1))",
            "ceil(apercentile(tinyint_col, 1))",
            "ceil(apercentile(bool_col, 1))",
            "ceil(apercentile(nchar_col, 1))",
            "ceil(apercentile(uint_col, 1))",
            "ceil(apercentile(ubigint_col, 1))",
            "ceil(apercentile(usmallint_col, 1))",
            "ceil(apercentile(utinyint_col, 1))",
            "ceil(apercentile(timestamp_tag, 1))",
            "ceil(apercentile(int_tag, 1))",
            "ceil(apercentile(bigint_tag, 1))",
            "ceil(apercentile(float_tag, 1))",
            "ceil(apercentile(double_tag, 1))",
            "ceil(apercentile(binary_tag, 1))",
            "ceil(apercentile(smallint_tag, 1))",
            "ceil(apercentile(tinyint_tag, 1))",
            "ceil(apercentile(bool_tag, 1))",
            "ceil(apercentile(nchar_tag, 1))",
            "ceil(apercentile(uint_tag, 1))",
            "ceil(apercentile(ubigint_tag, 1))",
            "ceil(apercentile(usmallint_tag, 1))",
            "ceil(apercentile(utinyint_tag, 1))",
            "ceil(last_row(ts))",
            "ceil(last_row(timestamp_col))",
            "ceil(last_row(int_col))",
            "ceil(last_row(bigint_col))",
            "ceil(last_row(float_col))",
            "ceil(last_row(double_col))",
            "ceil(last_row(binary_col))",
            "ceil(last_row(smallint_col))",
            "ceil(last_row(tinyint_col))",
            "ceil(last_row(bool_col))",
            "ceil(last_row(nchar_col))",
            "ceil(last_row(uint_col))",
            "ceil(last_row(ubigint_col))",
            "ceil(last_row(usmallint_col))",
            "ceil(last_row(utinyint_col))",
            "ceil(last_row(timestamp_tag))",
            "ceil(last_row(int_tag))",
            "ceil(last_row(bigint_tag))",
            "ceil(last_row(float_tag))",
            "ceil(last_row(double_tag))",
            "ceil(last_row(binary_tag))",
            "ceil(last_row(smallint_tag))",
            "ceil(last_row(tinyint_tag))",
            "ceil(last_row(bool_tag))",
            "ceil(last_row(nchar_tag))",
            "ceil(last_row(uint_tag))",
            "ceil(last_row(ubigint_tag))",
            "ceil(last_row(usmallint_tag))",
            "ceil(last_row(utinyint_tag))",
            "ceil(interp(ts))",
            "ceil(interp(timestamp_col))",
            "ceil(interp(int_col))",
            "ceil(interp(bigint_col))",
            "ceil(interp(float_col))",
            "ceil(interp(double_col))",
            "ceil(interp(binary_col))",
            "ceil(interp(smallint_col))",
            "ceil(interp(tinyint_col))",
            "ceil(interp(bool_col))",
            "ceil(interp(nchar_col))",
            "ceil(interp(uint_col))",
            "ceil(interp(ubigint_col))",
            "ceil(interp(usmallint_col))",
            "ceil(interp(utinyint_col))",
            "ceil(interp(timestamp_tag))",
            "ceil(interp(int_tag))",
            "ceil(interp(bigint_tag))",
            "ceil(interp(float_tag))",
            "ceil(interp(double_tag))",
            "ceil(interp(binary_tag))",
            "ceil(interp(smallint_tag))",
            "ceil(interp(tinyint_tag))",
            "ceil(interp(bool_tag))",
            "ceil(interp(nchar_tag))",
            "ceil(interp(uint_tag))",
            "ceil(interp(ubigint_tag))",
            "ceil(interp(usmallint_tag))",
            "ceil(interp(utinyint_tag))",
            "ceil(diff(ts))",
            "ceil(diff(timestamp_col))",
            "ceil(diff(int_col))",
            "ceil(diff(bigint_col))",
            "ceil(diff(float_col))",
            "ceil(diff(double_col))",
            "ceil(diff(binary_col))",
            "ceil(diff(smallint_col))",
            "ceil(diff(tinyint_col))",
            "ceil(diff(bool_col))",
            "ceil(diff(nchar_col))",
            "ceil(diff(uint_col))",
            "ceil(diff(ubigint_col))",
            "ceil(diff(usmallint_col))",
            "ceil(diff(utinyint_col))",
            "ceil(diff(timestamp_tag))",
            "ceil(diff(int_tag))",
            "ceil(diff(bigint_tag))",
            "ceil(diff(float_tag))",
            "ceil(diff(double_tag))",
            "ceil(diff(binary_tag))",
            "ceil(diff(smallint_tag))",
            "ceil(diff(tinyint_tag))",
            "ceil(diff(bool_tag))",
            "ceil(diff(nchar_tag))",
            "ceil(diff(uint_tag))",
            "ceil(diff(ubigint_tag))",
            "ceil(diff(usmallint_tag))",
            "ceil(diff(utinyint_tag))",
            "ceil(spread(ts))",
            "ceil(spread(timestamp_col))",
            "ceil(spread(int_col))",
            "ceil(spread(bigint_col))",
            "ceil(spread(float_col))",
            "ceil(spread(double_col))",
            "ceil(spread(binary_col))",
            "ceil(spread(smallint_col))",
            "ceil(spread(tinyint_col))",
            "ceil(spread(bool_col))",
            "ceil(spread(nchar_col))",
            "ceil(spread(uint_col))",
            "ceil(spread(ubigint_col))",
            "ceil(spread(usmallint_col))",
            "ceil(spread(utinyint_col))",
            "ceil(spread(timestamp_tag))",
            "ceil(spread(int_tag))",
            "ceil(spread(bigint_tag))",
            "ceil(spread(float_tag))",
            "ceil(spread(double_tag))",
            "ceil(spread(binary_tag))",
            "ceil(spread(smallint_tag))",
            "ceil(spread(tinyint_tag))",
            "ceil(spread(bool_tag))",
            "ceil(spread(nchar_tag))",
            "ceil(spread(uint_tag))",
            "ceil(spread(ubigint_tag))",
            "ceil(spread(usmallint_tag))",
            "ceil(spread(utinyint_tag))",
            "ceil(derivative(ts, 1s, 0))",
            "ceil(derivative(timestamp_col, 1s, 0))",
            "ceil(derivative(int_col, 1s, 0))",
            "ceil(derivative(bigint_col, 1s, 0))",
            "ceil(derivative(float_col, 1s, 0))",
            "ceil(derivative(double_col, 1s, 0))",
            "ceil(derivative(binary_col, 1s, 0))",
            "ceil(derivative(smallint_col, 1s, 0))",
            "ceil(derivative(tinyint_col, 1s, 0))",
            "ceil(derivative(bool_col, 1s, 0))",
            "ceil(derivative(nchar_col, 1s, 0))",
            "ceil(derivative(uint_col, 1s, 0))",
            "ceil(derivative(ubigint_col, 1s, 0))",
            "ceil(derivative(usmallint_col, 1s, 0))",
            "ceil(derivative(utinyint_col, 1s, 0))",
            "ceil(derivative(timestamp_tag, 1s, 0))",
            "ceil(derivative(int_tag, 1s, 0))",
            "ceil(derivative(bigint_tag, 1s, 0))",
            "ceil(derivative(float_tag, 1s, 0))",
            "ceil(derivative(double_tag, 1s, 0))",
            "ceil(derivative(binary_tag, 1s, 0))",
            "ceil(derivative(smallint_tag, 1s, 0))",
            "ceil(derivative(tinyint_tag, 1s, 0))",
            "ceil(derivative(bool_tag, 1s, 0))",
            "ceil(derivative(nchar_tag, 1s, 0))",
            "ceil(derivative(uint_tag, 1s, 0))",
            "ceil(derivative(ubigint_tag, 1s, 0))",
            "ceil(derivative(usmallint_tag, 1s, 0))",
            "ceil(derivative(utinyint_tag, 1s, 0))",
            "ceil(ts + ts)",
            "ceil(timestamp_col + timestamp_col)",
            "ceil(int_col + int_col)",
            "ceil(bigint_col + bigint_col)",
            "ceil(float_col + float_col)",
            "ceil(double_col + double_col)",
            "ceil(binary_col + binary_col)",
            "ceil(smallint_col + smallint_col)",
            "ceil(tinyint_col + tinyint_col)",
            "ceil(bool_col + bool_col)",
            "ceil(nchar_col + nchar_col)",
            "ceil(uint_col + uint_col)",
            "ceil(ubigint_col + ubigint_col)",
            "ceil(usmallint_col + usmallint_col)",
            "ceil(utinyint_col + utinyint_col)",
            "ceil(timestamp_tag + timestamp_tag)",
            "ceil(int_tag + int_tag)",
            "ceil(bigint_tag + bigint_tag)",
            "ceil(float_tag + float_tag)",
            "ceil(double_tag + double_tag)",
            "ceil(binary_tag + binary_tag)",
            "ceil(smallint_tag + smallint_tag)",
            "ceil(tinyint_tag + tinyint_tag)",
            "ceil(bool_tag + bool_tag)",
            "ceil(nchar_tag + nchar_tag)",
            "ceil(uint_tag + uint_tag)",
            "ceil(ubigint_tag + ubigint_tag)",
            "ceil(usmallint_tag + usmallint_tag)",
            "ceil(utinyint_tag + utinyint_tag)",
            "ceil(ts - ts)",
            "ceil(timestamp_col - timestamp_col)",
            "ceil(int_col - int_col)",
            "ceil(bigint_col - bigint_col)",
            "ceil(float_col - float_col)",
            "ceil(double_col - double_col)",
            "ceil(binary_col - binary_col)",
            "ceil(smallint_col - smallint_col)",
            "ceil(tinyint_col - tinyint_col)",
            "ceil(bool_col - bool_col)",
            "ceil(nchar_col - nchar_col)",
            "ceil(uint_col - uint_col)",
            "ceil(ubigint_col - ubigint_col)",
            "ceil(usmallint_col - usmallint_col)",
            "ceil(utinyint_col - utinyint_col)",
            "ceil(timestamp_tag - timestamp_tag)",
            "ceil(int_tag - int_tag)",
            "ceil(bigint_tag - bigint_tag)",
            "ceil(float_tag - float_tag)",
            "ceil(double_tag - double_tag)",
            "ceil(binary_tag - binary_tag)",
            "ceil(smallint_tag - smallint_tag)",
            "ceil(tinyint_tag - tinyint_tag)",
            "ceil(bool_tag - bool_tag)",
            "ceil(nchar_tag - nchar_tag)",
            "ceil(uint_tag - uint_tag)",
            "ceil(ubigint_tag - ubigint_tag)",
            "ceil(usmallint_tag - usmallint_tag)",
            "ceil(utinyint_tag - utinyint_tag)",
            "ceil(ts * ts)",
            "ceil(timestamp_col * timestamp_col)",
            "ceil(int_col * int_col)",
            "ceil(bigint_col * bigint_col)",
            "ceil(float_col * float_col)",
            "ceil(double_col * double_col)",
            "ceil(binary_col * binary_col)",
            "ceil(smallint_col * smallint_col)",
            "ceil(tinyint_col * tinyint_col)",
            "ceil(bool_col * bool_col)",
            "ceil(nchar_col * nchar_col)",
            "ceil(uint_col * uint_col)",
            "ceil(ubigint_col * ubigint_col)",
            "ceil(usmallint_col * usmallint_col)",
            "ceil(utinyint_col * utinyint_col)",
            "ceil(timestamp_tag * timestamp_tag)",
            "ceil(int_tag * int_tag)",
            "ceil(bigint_tag * bigint_tag)",
            "ceil(float_tag * float_tag)",
            "ceil(double_tag * double_tag)",
            "ceil(binary_tag * binary_tag)",
            "ceil(smallint_tag * smallint_tag)",
            "ceil(tinyint_tag * tinyint_tag)",
            "ceil(bool_tag * bool_tag)",
            "ceil(nchar_tag * nchar_tag)",
            "ceil(uint_tag * uint_tag)",
            "ceil(ubigint_tag * ubigint_tag)",
            "ceil(usmallint_tag * usmallint_tag)",
            "ceil(utinyint_tag * utinyint_tag)",
            "ceil(ts / ts)",
            "ceil(timestamp_col / timestamp_col)",
            "ceil(int_col / int_col)",
            "ceil(bigint_col / bigint_col)",
            "ceil(float_col / float_col)",
            "ceil(double_col / double_col)",
            "ceil(binary_col / binary_col)",
            "ceil(smallint_col / smallint_col)",
            "ceil(tinyint_col / tinyint_col)",
            "ceil(bool_col / bool_col)",
            "ceil(nchar_col / nchar_col)",
            "ceil(uint_col / uint_col)",
            "ceil(ubigint_col / ubigint_col)",
            "ceil(usmallint_col / usmallint_col)",
            "ceil(utinyint_col / utinyint_col)",
            "ceil(timestamp_tag / timestamp_tag)",
            "ceil(int_tag / int_tag)",
            "ceil(bigint_tag / bigint_tag)",
            "ceil(float_tag / float_tag)",
            "ceil(double_tag / double_tag)",
            "ceil(binary_tag / binary_tag)",
            "ceil(smallint_tag / smallint_tag)",
            "ceil(tinyint_tag / tinyint_tag)",
            "ceil(bool_tag / bool_tag)",
            "ceil(nchar_tag / nchar_tag)",
            "ceil(uint_tag / uint_tag)",
            "ceil(ubigint_tag / ubigint_tag)",
            "ceil(usmallint_tag / usmallint_tag)",
            "ceil(utinyint_tag / utinyint_tag)",
            "int_col, ceil(int_col), int_col",
            "bigint_col, ceil(bigint_col), bigint_col",
            "float_col, ceil(float_col), float_col",
            "double_col, ceil(double_col), double_col",
            "smallint_col, ceil(smallint_col), smallint_col",
            "tinyint_col, ceil(tinyint_col), tinyint_col",
            "uint_col, ceil(uint_col), uint_col",
            "ubigint_col, ceil(ubigint_col), ubigint_col",
            "usmallint_col, ceil(usmallint_col), usmallint_col",
            "utinyint_col, ceil(utinyint_col), utinyint_col",
            "count(int_col), ceil(int_col), count(int_col)",
            "count(bigint_col), ceil(bigint_col), count(bigint_col)",
            "count(float_col), ceil(float_col), count(float_col)",
            "count(double_col), ceil(double_col), count(double_col)",
            "count(smallint_col), ceil(smallint_col), count(smallint_col)",
            "count(tinyint_col), ceil(tinyint_col), count(tinyint_col)",
            "count(uint_col), ceil(uint_col), count(uint_col)",
            "count(ubigint_col), ceil(ubigint_col), count(ubigint_col)",
            "count(usmallint_col), ceil(usmallint_col), count(usmallint_col)",
            "count(utinyint_col), ceil(utinyint_col), count(utinyint_col)",
            "avg(int_col), ceil(int_col), avg(int_col)",
            "avg(bigint_col), ceil(bigint_col), avg(bigint_col)",
            "avg(float_col), ceil(float_col), avg(float_col)",
            "avg(double_col), ceil(double_col), avg(double_col)",
            "avg(smallint_col), ceil(smallint_col), avg(smallint_col)",
            "avg(tinyint_col), ceil(tinyint_col), avg(tinyint_col)",
            "avg(uint_col), ceil(uint_col), avg(uint_col)",
            "avg(ubigint_col), ceil(ubigint_col), avg(ubigint_col)",
            "avg(usmallint_col), ceil(usmallint_col), avg(usmallint_col)",
            "avg(utinyint_col), ceil(utinyint_col), avg(utinyint_col)",
            "twa(int_col), ceil(int_col), twa(int_col)",
            "twa(bigint_col), ceil(bigint_col), twa(bigint_col)",
            "twa(float_col), ceil(float_col), twa(float_col)",
            "twa(double_col), ceil(double_col), twa(double_col)",
            "twa(smallint_col), ceil(smallint_col), twa(smallint_col)",
            "twa(tinyint_col), ceil(tinyint_col), twa(tinyint_col)",
            "twa(uint_col), ceil(uint_col), twa(uint_col)",
            "twa(ubigint_col), ceil(ubigint_col), twa(ubigint_col)",
            "twa(usmallint_col), ceil(usmallint_col), twa(usmallint_col)",
            "twa(utinyint_col), ceil(utinyint_col), twa(utinyint_col)",
            "sum(int_col), ceil(int_col), sum(int_col)",
            "sum(bigint_col), ceil(bigint_col), sum(bigint_col)",
            "sum(float_col), ceil(float_col), sum(float_col)",
            "sum(double_col), ceil(double_col), sum(double_col)",
            "sum(smallint_col), ceil(smallint_col), sum(smallint_col)",
            "sum(tinyint_col), ceil(tinyint_col), sum(tinyint_col)",
            "sum(uint_col), ceil(uint_col), sum(uint_col)",
            "sum(ubigint_col), ceil(ubigint_col), sum(ubigint_col)",
            "sum(usmallint_col), ceil(usmallint_col), sum(usmallint_col)",
            "sum(utinyint_col), ceil(utinyint_col), sum(utinyint_col)",
            "stddev(int_col), ceil(int_col), stddev(int_col)",
            "stddev(bigint_col), ceil(bigint_col), stddev(bigint_col)",
            "stddev(float_col), ceil(float_col), stddev(float_col)",
            "stddev(double_col), ceil(double_col), stddev(double_col)",
            "stddev(smallint_col), ceil(smallint_col), stddev(smallint_col)",
            "stddev(tinyint_col), ceil(tinyint_col), stddev(tinyint_col)",
            "stddev(uint_col), ceil(uint_col), stddev(uint_col)",
            "stddev(ubigint_col), ceil(ubigint_col), stddev(ubigint_col)",
            "stddev(usmallint_col), ceil(usmallint_col), stddev(usmallint_col)",
            "stddev(utinyint_col), ceil(utinyint_col), stddev(utinyint_col)",
            "irate(int_col), ceil(int_col), irate(int_col)",
            "irate(bigint_col), ceil(bigint_col), irate(bigint_col)",
            "irate(float_col), ceil(float_col), irate(float_col)",
            "irate(double_col), ceil(double_col), irate(double_col)",
            "irate(smallint_col), ceil(smallint_col), irate(smallint_col)",
            "irate(tinyint_col), ceil(tinyint_col), irate(tinyint_col)",
            "irate(uint_col), ceil(uint_col), irate(uint_col)",
            "irate(ubigint_col), ceil(ubigint_col), irate(ubigint_col)",
            "irate(usmallint_col), ceil(usmallint_col), irate(usmallint_col)",
            "irate(utinyint_col), ceil(utinyint_col), irate(utinyint_col)",
            "min(int_col), ceil(int_col), min(int_col)",
            "min(bigint_col), ceil(bigint_col), min(bigint_col)",
            "min(float_col), ceil(float_col), min(float_col)",
            "min(double_col), ceil(double_col), min(double_col)",
            "min(smallint_col), ceil(smallint_col), min(smallint_col)",
            "min(tinyint_col), ceil(tinyint_col), min(tinyint_col)",
            "min(uint_col), ceil(uint_col), min(uint_col)",
            "min(ubigint_col), ceil(ubigint_col), min(ubigint_col)",
            "min(usmallint_col), ceil(usmallint_col), min(usmallint_col)",
            "min(utinyint_col), ceil(utinyint_col), min(utinyint_col)",
            "max(int_col), ceil(int_col), max(int_col)",
            "max(bigint_col), ceil(bigint_col), max(bigint_col)",
            "max(float_col), ceil(float_col), max(float_col)",
            "max(double_col), ceil(double_col), max(double_col)",
            "max(smallint_col), ceil(smallint_col), max(smallint_col)",
            "max(tinyint_col), ceil(tinyint_col), max(tinyint_col)",
            "max(uint_col), ceil(uint_col), max(uint_col)",
            "max(ubigint_col), ceil(ubigint_col), max(ubigint_col)",
            "max(usmallint_col), ceil(usmallint_col), max(usmallint_col)",
            "max(utinyint_col), ceil(utinyint_col), max(utinyint_col)",
            "first(int_col), ceil(int_col), first(int_col)",
            "first(bigint_col), ceil(bigint_col), first(bigint_col)",
            "first(float_col), ceil(float_col), first(float_col)",
            "first(double_col), ceil(double_col), first(double_col)",
            "first(smallint_col), ceil(smallint_col), first(smallint_col)",
            "first(tinyint_col), ceil(tinyint_col), first(tinyint_col)",
            "first(uint_col), ceil(uint_col), first(uint_col)",
            "first(ubigint_col), ceil(ubigint_col), first(ubigint_col)",
            "first(usmallint_col), ceil(usmallint_col), first(usmallint_col)",
            "first(utinyint_col), ceil(utinyint_col), first(utinyint_col)",
            "last(int_col), ceil(int_col), last(int_col)",
            "last(bigint_col), ceil(bigint_col), last(bigint_col)",
            "last(float_col), ceil(float_col), last(float_col)",
            "last(double_col), ceil(double_col), last(double_col)",
            "last(smallint_col), ceil(smallint_col), last(smallint_col)",
            "last(tinyint_col), ceil(tinyint_col), last(tinyint_col)",
            "last(uint_col), ceil(uint_col), last(uint_col)",
            "last(ubigint_col), ceil(ubigint_col), last(ubigint_col)",
            "last(usmallint_col), ceil(usmallint_col), last(usmallint_col)",
            "last(utinyint_col), ceil(utinyint_col), last(utinyint_col)",
            "last_row(int_col), ceil(int_col), last_row(int_col)",
            "last_row(bigint_col), ceil(bigint_col), last_row(bigint_col)",
            "last_row(float_col), ceil(float_col), last_row(float_col)",
            "last_row(double_col), ceil(double_col), last_row(double_col)",
            "last_row(smallint_col), ceil(smallint_col), last_row(smallint_col)",
            "last_row(tinyint_col), ceil(tinyint_col), last_row(tinyint_col)",
            "last_row(uint_col), ceil(uint_col), last_row(uint_col)",
            "last_row(ubigint_col), ceil(ubigint_col), last_row(ubigint_col)",
            "last_row(usmallint_col), ceil(usmallint_col), last_row(usmallint_col)",
            "last_row(utinyint_col), ceil(utinyint_col), last_row(utinyint_col)",
            "interp(int_col), ceil(int_col), interp(int_col)",
            "interp(bigint_col), ceil(bigint_col), interp(bigint_col)",
            "interp(float_col), ceil(float_col), interp(float_col)",
            "interp(double_col), ceil(double_col), interp(double_col)",
            "interp(smallint_col), ceil(smallint_col), interp(smallint_col)",
            "interp(tinyint_col), ceil(tinyint_col), interp(tinyint_col)",
            "interp(uint_col), ceil(uint_col), interp(uint_col)",
            "interp(ubigint_col), ceil(ubigint_col), interp(ubigint_col)",
            "interp(usmallint_col), ceil(usmallint_col), interp(usmallint_col)",
            "interp(utinyint_col), ceil(utinyint_col), interp(utinyint_col)",
            "diff(int_col), ceil(int_col), diff(int_col)",
            "diff(bigint_col), ceil(bigint_col), diff(bigint_col)",
            "diff(float_col), ceil(float_col), diff(float_col)",
            "diff(double_col), ceil(double_col), diff(double_col)",
            "diff(smallint_col), ceil(smallint_col), diff(smallint_col)",
            "diff(tinyint_col), ceil(tinyint_col), diff(tinyint_col)",
            "diff(uint_col), ceil(uint_col), diff(uint_col)",
            "diff(ubigint_col), ceil(ubigint_col), diff(ubigint_col)",
            "diff(usmallint_col), ceil(usmallint_col), diff(usmallint_col)",
            "diff(utinyint_col), ceil(utinyint_col), diff(utinyint_col)",
            "spread(int_col), ceil(int_col), spread(int_col)",
            "spread(bigint_col), ceil(bigint_col), spread(bigint_col)",
            "spread(float_col), ceil(float_col), spread(float_col)",
            "spread(double_col), ceil(double_col), spread(double_col)",
            "spread(smallint_col), ceil(smallint_col), spread(smallint_col)",
            "spread(tinyint_col), ceil(tinyint_col), spread(tinyint_col)",
            "spread(uint_col), ceil(uint_col), spread(uint_col)",
            "spread(ubigint_col), ceil(ubigint_col), spread(ubigint_col)",
            "spread(usmallint_col), ceil(usmallint_col), spread(usmallint_col)",
            "spread(utinyint_col), ceil(utinyint_col), spread(utinyint_col)",
            "leastsquares(int_col, 1, 1), ceil(int_col), leastsquares(int_col, 1, 1)",
            "leastsquares(bigint_col, 1, 1), ceil(bigint_col), leastsquares(bigint_col, 1, 1)",
            "leastsquares(float_col, 1, 1), ceil(float_col), leastsquares(float_col, 1, 1)",
            "leastsquares(double_col, 1, 1), ceil(double_col), leastsquares(double_col, 1, 1)",
            "leastsquares(smallint_col, 1, 1), ceil(smallint_col), leastsquares(smallint_col, 1, 1)",
            "leastsquares(tinyint_col, 1, 1), ceil(tinyint_col), leastsquares(tinyint_col, 1, 1)",
            "leastsquares(uint_col, 1, 1), ceil(uint_col), leastsquares(uint_col, 1, 1)",
            "leastsquares(ubigint_col, 1, 1), ceil(ubigint_col), leastsquares(ubigint_col, 1, 1)",
            "leastsquares(usmallint_col, 1, 1), ceil(usmallint_col), leastsquares(usmallint_col, 1, 1)",
            "leastsquares(utinyint_col, 1, 1), ceil(utinyint_col), leastsquares(utinyint_col, 1, 1)",
            "top(int_col, 1), ceil(int_col), top(int_col, 1)",
            "top(bigint_col, 1), ceil(bigint_col), top(bigint_col, 1)",
            "top(float_col, 1), ceil(float_col), top(float_col, 1)",
            "top(double_col, 1), ceil(double_col), top(double_col, 1)",
            "top(smallint_col, 1), ceil(smallint_col), top(smallint_col, 1)",
            "top(tinyint_col, 1), ceil(tinyint_col), top(tinyint_col, 1)",
            "top(uint_col, 1), ceil(uint_col), top(uint_col, 1)",
            "top(ubigint_col, 1), ceil(ubigint_col), top(ubigint_col, 1)",
            "top(usmallint_col, 1), ceil(usmallint_col), top(usmallint_col, 1)",
            "top(utinyint_col, 1), ceil(utinyint_col), top(utinyint_col, 1)",
            "bottom(int_col, 1), ceil(int_col), bottom(int_col, 1)",
            "bottom(bigint_col, 1), ceil(bigint_col), bottom(bigint_col, 1)",
            "bottom(float_col, 1), ceil(float_col), bottom(float_col, 1)",
            "bottom(double_col, 1), ceil(double_col), bottom(double_col, 1)",
            "bottom(smallint_col, 1), ceil(smallint_col), bottom(smallint_col, 1)",
            "bottom(tinyint_col, 1), ceil(tinyint_col), bottom(tinyint_col, 1)",
            "bottom(uint_col, 1), ceil(uint_col), bottom(uint_col, 1)",
            "bottom(ubigint_col, 1), ceil(ubigint_col), bottom(ubigint_col, 1)",
            "bottom(usmallint_col, 1), ceil(usmallint_col), bottom(usmallint_col, 1)",
            "bottom(utinyint_col, 1), ceil(utinyint_col), bottom(utinyint_col, 1)",
            "percentile(int_col, 1), ceil(int_col), percentile(int_col, 1)",
            "percentile(bigint_col, 1), ceil(bigint_col), percentile(bigint_col, 1)",
            "percentile(float_col, 1), ceil(float_col), percentile(float_col, 1)",
            "percentile(double_col, 1), ceil(double_col), percentile(double_col, 1)",
            "percentile(smallint_col, 1), ceil(smallint_col), percentile(smallint_col, 1)",
            "percentile(tinyint_col, 1), ceil(tinyint_col), percentile(tinyint_col, 1)",
            "percentile(uint_col, 1), ceil(uint_col), percentile(uint_col, 1)",
            "percentile(ubigint_col, 1), ceil(ubigint_col), percentile(ubigint_col, 1)",
            "percentile(usmallint_col, 1), ceil(usmallint_col), percentile(usmallint_col, 1)",
            "percentile(utinyint_col, 1), ceil(utinyint_col), percentile(utinyint_col, 1)",
            "apercentile(int_col, 1), ceil(int_col), apercentile(int_col, 1)",
            "apercentile(bigint_col, 1), ceil(bigint_col), apercentile(bigint_col, 1)",
            "apercentile(float_col, 1), ceil(float_col), apercentile(float_col, 1)",
            "apercentile(double_col, 1), ceil(double_col), apercentile(double_col, 1)",
            "apercentile(smallint_col, 1), ceil(smallint_col), apercentile(smallint_col, 1)",
            "apercentile(tinyint_col, 1), ceil(tinyint_col), apercentile(tinyint_col, 1)",
            "apercentile(uint_col, 1), ceil(uint_col), apercentile(uint_col, 1)",
            "apercentile(ubigint_col, 1), ceil(ubigint_col), apercentile(ubigint_col, 1)",
            "apercentile(usmallint_col, 1), ceil(usmallint_col), apercentile(usmallint_col, 1)",
            "apercentile(utinyint_col, 1), ceil(utinyint_col), apercentile(utinyint_col, 1)",
            "derivative(int_col, 1s, 0), ceil(int_col), derivative(int_col, 1s, 0)",
            "derivative(bigint_col, 1s, 0), ceil(bigint_col), derivative(bigint_col, 1s, 0)",
            "derivative(float_col, 1s, 0), ceil(float_col), derivative(float_col, 1s, 0)",
            "derivative(double_col, 1s, 0), ceil(double_col), derivative(double_col, 1s, 0)",
            "derivative(smallint_col, 1s, 0), ceil(smallint_col), derivative(smallint_col, 1s, 0)",
            "derivative(tinyint_col, 1s, 0), ceil(tinyint_col), derivative(tinyint_col, 1s, 0)",
            "derivative(uint_col, 1s, 0), ceil(uint_col), derivative(uint_col, 1s, 0)",
            "derivative(ubigint_col, 1s, 0), ceil(ubigint_col), derivative(ubigint_col, 1s, 0)",
            "derivative(usmallint_col, 1s, 0), ceil(usmallint_col), derivative(usmallint_col, 1s, 0)",
            "derivative(utinyint_col, 1s, 0), ceil(utinyint_col), derivative(utinyint_col, 1s, 0)",
            "1, ceil(int_col), 1",
            "1, ceil(bigint_col), 1",
            "1, ceil(float_col), 1",
            "1, ceil(double_col), 1",
            "1, ceil(smallint_col), 1",
            "1, ceil(tinyint_col), 1",
            "1, ceil(uint_col), 1",
            "1, ceil(ubigint_col), 1",
            "1, ceil(usmallint_col), 1",
            "1, ceil(utinyint_col), 1",
            "ceil(int_col) as anyName",
            "ceil(bigint_col) as anyName",
            "ceil(float_col) as anyName",
            "ceil(double_col) as anyName",
            "ceil(smallint_col) as anyName",
            "ceil(tinyint_col) as anyName",
            "ceil(uint_col) as anyName",
            "ceil(ubigint_col) as anyName",
            "ceil(usmallint_col) as anyName",
            "ceil(utinyint_col) as anyName",
            "distinct ceil(int_col)",
            "distinct ceil(bigint_col)",
            "distinct ceil(float_col)",
            "distinct ceil(double_col)",
            "distinct ceil(smallint_col)",
            "distinct ceil(tinyint_col)",
            "distinct ceil(uint_col)",
            "distinct ceil(ubigint_col)",
            "distinct ceil(usmallint_col)",
            "distinct ceil(utinyint_col)",
        ]
        simple_select_command = [
            "ceil(super.int_col)",
            "ceil(super.bigint_col)",
            "ceil(super.float_col)",
            "ceil(super.double_col)",
            "ceil(super.smallint_col)",
            "ceil(super.tinyint_col)",
            "ceil(super.uint_col)",
            "ceil(super.ubigint_col)",
            "ceil(super.usmallint_col)",
            "ceil(super.utinyint_col)",
            "ceil(t1.int_col)",
            "ceil(t1.bigint_col)",
            "ceil(t1.float_col)",
            "ceil(t1.double_col)",
            "ceil(t1.smallint_col)",
            "ceil(t1.tinyint_col)",
            "ceil(t1.uint_col)",
            "ceil(t1.ubigint_col)",
            "ceil(t1.usmallint_col)",
            "ceil(t1.utinyint_col)",
        ]
        from_command = [" from super", " from t1"]
        advance_from_command = [
            " from super", " from t1",
            " from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag"
        ]
        filter_command = [
            "", " session(ts, 1s)", " state_window(int_col)", " interval (1s)",
            " interval (1s) sliding (1s)", " group by (ts)"
        ]
        fill_command = [
            "", " fill(prev)", " fill(next)", " fill(null)", " fill(1)",
            " fill(linear)"
        ]
        tdSql.prepare()
        #need insert new data --data type is double or float and tests ceil floor round .
        tdSql.execute("create table if not exists jsons7(ts timestamp, dataInt int, dataBool bool, datafloat float, datadouble double, dataStr nchar(50)) tags(jtag nchar(128))")
        tdSql.execute("insert into jsons7_1 using jsons7 tags('{\"nv\":null,\"tea\":true,\"\":false,\" \":123,\"tea\":false}') values (now,2,'true',0.9,0.1,'123')")
        tdSql.query("select * from jsons7")
        tdSql.checkRows(1)
        tdSql.execute("insert into jsons7_1 values (now+1s,3,'true',-4.8,-5.5,'123') ")
        tdSql.execute("insert into jsons7_1 values (now+2s,4,'true',1.9998,2.00001,'123') ")
        tdSql.execute("insert into jsons7_2 using jsons7 tags('{\"nv\":null,\"tea\":true,\"\":false,\"tag\":123,\"tea\":false}') values (now,5,'true',4.01,2.2,'123') ")
        tdSql.execute("insert into jsons7_2 (ts,datadouble) values (now+3s,-0.9) ")
        tdSql.execute("insert into jsons7_2 (ts,datadouble) values (now+4s,-2.9) ")
        tdSql.execute("insert into jsons7_2 (ts,datafloat) values (now+1s,-0.9) ")
        tdSql.execute("insert into jsons7_2 (ts,datafloat) values (now+2s,-1.9) ")
        tdSql.query("select ts,ceil(dataint),ceil(datafloat),ceil(datadouble) from jsons7")
        tdSql.checkRows(8)
        tdSql.checkData(5, 1, None)
        tdSql.checkData(6, 2, None)
        tdSql.checkData(7, 3, -2)
        tdSql.query("select ceil(dataint),ceil(datafloat),ceil(datadouble) from jsons7")
        tdSql.checkRows(8)
        tdSql.checkData(5, 1, -1)
        tdSql.checkData(5, 2, None)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(7, 2, -2)
        tdSql.query("select ts,floor(dataint),floor(datafloat),floor(datadouble) from jsons7")
        tdSql.query("select floor(dataint),floor(datafloat),floor(datadouble) from jsons7")
        tdSql.query("select ts,round(dataint),round(datafloat),round(datadouble) from jsons7")
        tdSql.query("select round(dataint),round(datafloat),round(datadouble) from jsons7")

        tdSql.execute(
            "create stable super (ts timestamp, timestamp_col timestamp, int_col int, bigint_col bigint, float_col float,\
                double_col double, binary_col binary(8), smallint_col smallint, tinyint_col tinyint, bool_col bool, nchar_col nchar(8), \
                uint_col int unsigned, ubigint_col bigint unsigned, usmallint_col smallint unsigned,  utinyint_col tinyint unsigned) tags (int_tag int, bigint_tag bigint, \
                    float_tag float, double_tag double, binary_tag binary(8), smallint_tag smallint, tinyint_tag tinyint, bool_tag bool, nchar_tag nchar(8),\
                        uint_tag int unsigned, ubigint_tag bigint unsigned, usmallint_tag smallint unsigned, utinyint_tag tinyint unsigned, timestamp_tag timestamp)"
        )
        tdSql.execute(
            "create stable superb (ts timestamp, timestamp_col timestamp, int_col int, bigint_col bigint, float_col float,\
                double_col double, binary_col binary(8), smallint_col smallint, tinyint_col tinyint, bool_col bool, nchar_col nchar(8), \
                uint_col int unsigned, ubigint_col bigint unsigned, usmallint_col smallint unsigned,  utinyint_col tinyint unsigned) tags (int_tag int, bigint_tag bigint, \
                    float_tag float, double_tag double, binary_tag binary(8), smallint_tag smallint, tinyint_tag tinyint, bool_tag bool, nchar_tag nchar(8),\
                        uint_tag int unsigned, ubigint_tag bigint unsigned, usmallint_tag smallint unsigned, utinyint_tag tinyint unsigned, timestamp_tag timestamp)"
        )
        tdSql.execute(
            "create table t1 using super tags (1, %d, %f, %f, '%s', %d, %d, 1, '%s', %d, %d, %d, %d, %s)"
            % (self.randomBigint(), self.randomDouble(), self.randomDouble(),
               self.randomNchar(), self.randomSmallint(), self.randomTinyint(),
               self.randomNchar(), self.randomUInt(), self.randomUBigint(),
               self.randomUSmallint(), self.randomUTinyint(), 'now'))
        tdSql.execute(
            "insert into t1 values (1629796215891, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 1, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "insert into t1 values (1629796215892, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 0, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "insert into t1 values (1629796215893, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 1, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "insert into t1 values (1629796215894, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 0, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "create table t2 using superb tags (1, %d, %f, %f, '%s', %d, %d, 1, '%s', %d, %d, %d, %d, %s)"
            % (self.randomBigint(), self.randomDouble(), self.randomDouble(),
               self.randomNchar(), self.randomSmallint(), self.randomTinyint(),
               self.randomNchar(), self.randomUInt(), self.randomUBigint(),
               self.randomUSmallint(), self.randomUTinyint(), 'now'))
        tdSql.execute(
            "insert into t2 values (1629796215891, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 1, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "insert into t2 values (1629796215892, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 0, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "insert into t2 values (1629796215893, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 1, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "insert into t2 values (1629796215894, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 0, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))

        shouldPass = ['select ceil(int_col) from super',
              'select ceil(int_col) from t1',
              'select ceil(bigint_col) from super',
              'select ceil(bigint_col) from t1',
              'select ceil(float_col) from super',
              'select ceil(float_col) from t1',
              'select ceil(double_col) from super',
              'select ceil(double_col) from t1',
              'select ceil(smallint_col) from super',
              'select ceil(smallint_col) from t1',
              'select ceil(tinyint_col) from super',
              'select ceil(tinyint_col) from t1',
              'select ceil(uint_col) from super',
              'select ceil(uint_col) from t1',
              'select ceil(ubigint_col) from super',
              'select ceil(ubigint_col) from t1',
              'select ceil(usmallint_col) from super',
              'select ceil(usmallint_col) from t1',
              'select ceil(utinyint_col) from super',
              'select ceil(utinyint_col) from t1',
              'select ceil(int_col) - ceil(int_col) from super',
              'select ceil(int_col) - ceil(int_col) from t1',
              'select ceil(bigint_col) - ceil(bigint_col) from super',
              'select ceil(bigint_col) - ceil(bigint_col) from t1',
              'select ceil(float_col) - ceil(float_col) from super',
              'select ceil(float_col) - ceil(float_col) from t1',
              'select ceil(double_col) - ceil(double_col) from super',
              'select ceil(double_col) - ceil(double_col) from t1',
              'select ceil(smallint_col) - ceil(smallint_col) from super',
              'select ceil(smallint_col) - ceil(smallint_col) from t1',
              'select ceil(tinyint_col) - ceil(tinyint_col) from super',
              'select ceil(tinyint_col) - ceil(tinyint_col) from t1',
              'select ceil(uint_col) - ceil(uint_col) from super',
              'select ceil(uint_col) - ceil(uint_col) from t1',
              'select ceil(ubigint_col) - ceil(ubigint_col) from super',
              'select ceil(ubigint_col) - ceil(ubigint_col) from t1',
              'select ceil(usmallint_col) - ceil(usmallint_col) from super',
              'select ceil(usmallint_col) - ceil(usmallint_col) from t1',
              'select ceil(utinyint_col) - ceil(utinyint_col) from super',
              'select ceil(utinyint_col) - ceil(utinyint_col) from t1',
              'select ceil(int_col) / ceil(int_col) from super',
              'select ceil(int_col) / ceil(int_col) from t1',
              'select ceil(bigint_col) / ceil(bigint_col) from super',
              'select ceil(bigint_col) / ceil(bigint_col) from t1',
              'select ceil(float_col) / ceil(float_col) from super',
              'select ceil(float_col) / ceil(float_col) from t1',
              'select ceil(double_col) / ceil(double_col) from super',
              'select ceil(double_col) / ceil(double_col) from t1',
              'select ceil(smallint_col) / ceil(smallint_col) from super',
              'select ceil(smallint_col) / ceil(smallint_col) from t1',
              'select ceil(tinyint_col) / ceil(tinyint_col) from super',
              'select ceil(tinyint_col) / ceil(tinyint_col) from t1',
              'select ceil(uint_col) / ceil(uint_col) from super',
              'select ceil(uint_col) / ceil(uint_col) from t1',
              'select ceil(ubigint_col) / ceil(ubigint_col) from super',
              'select ceil(ubigint_col) / ceil(ubigint_col) from t1',
              'select ceil(usmallint_col) / ceil(usmallint_col) from super',
              'select ceil(usmallint_col) / ceil(usmallint_col) from t1',
              'select ceil(utinyint_col) / ceil(utinyint_col) from super',
              'select ceil(utinyint_col) / ceil(utinyint_col) from t1',
              'select ceil(int_col) * ceil(int_col) from super',
              'select ceil(int_col) * ceil(int_col) from t1',
              'select ceil(bigint_col) * ceil(bigint_col) from super',
              'select ceil(bigint_col) * ceil(bigint_col) from t1',
              'select ceil(float_col) * ceil(float_col) from super',
              'select ceil(float_col) * ceil(float_col) from t1',
              'select ceil(double_col) * ceil(double_col) from super',
              'select ceil(double_col) * ceil(double_col) from t1',
              'select ceil(smallint_col) * ceil(smallint_col) from super',
              'select ceil(smallint_col) * ceil(smallint_col) from t1',
              'select ceil(tinyint_col) * ceil(tinyint_col) from super',
              'select ceil(tinyint_col) * ceil(tinyint_col) from t1',
              'select ceil(uint_col) * ceil(uint_col) from super',
              'select ceil(uint_col) * ceil(uint_col) from t1',
              'select ceil(ubigint_col) * ceil(ubigint_col) from super',
              'select ceil(ubigint_col) * ceil(ubigint_col) from t1',
              'select ceil(usmallint_col) * ceil(usmallint_col) from super',
              'select ceil(usmallint_col) * ceil(usmallint_col) from t1',
              'select ceil(utinyint_col) * ceil(utinyint_col) from super',
              'select ceil(utinyint_col) * ceil(utinyint_col) from t1',
              'select ceil(count(ts)) from super',
              'select ceil(count(ts)) from t1',
              'select ceil(count(timestamp_col)) from super',
              'select ceil(count(timestamp_col)) from t1',
              'select ceil(count(int_col)) from super',
              'select ceil(count(int_col)) from t1',
              'select ceil(count(bigint_col)) from super',
              'select ceil(count(bigint_col)) from t1',
              'select ceil(count(float_col)) from super',
              'select ceil(count(float_col)) from t1',
              'select ceil(count(double_col)) from super',
              'select ceil(count(double_col)) from t1',
              'select ceil(count(binary_col)) from super',
              'select ceil(count(binary_col)) from t1',
              'select ceil(count(smallint_col)) from super',
              'select ceil(count(smallint_col)) from t1',
              'select ceil(count(tinyint_col)) from super',
              'select ceil(count(tinyint_col)) from t1',
              'select ceil(count(bool_col)) from super',
              'select ceil(count(bool_col)) from t1',
              'select ceil(count(nchar_col)) from super',
              'select ceil(count(nchar_col)) from t1',
              'select ceil(count(uint_col)) from super',
              'select ceil(count(uint_col)) from t1',
              'select ceil(count(ubigint_col)) from super',
              'select ceil(count(ubigint_col)) from t1',
              'select ceil(count(usmallint_col)) from super',
              'select ceil(count(usmallint_col)) from t1',
              'select ceil(count(utinyint_col)) from super',
              'select ceil(count(utinyint_col)) from t1',
              'select ceil(count(timestamp_tag)) from super',
              'select ceil(count(timestamp_tag)) from t1',
              'select ceil(count(int_tag)) from super',
              'select ceil(count(int_tag)) from t1',
              'select ceil(count(bigint_tag)) from super',
              'select ceil(count(bigint_tag)) from t1',
              'select ceil(count(float_tag)) from super',
              'select ceil(count(float_tag)) from t1',
              'select ceil(count(double_tag)) from super',
              'select ceil(count(double_tag)) from t1',
              'select ceil(count(binary_tag)) from super',
              'select ceil(count(binary_tag)) from t1',
              'select ceil(count(smallint_tag)) from super',
              'select ceil(count(smallint_tag)) from t1',
              'select ceil(count(tinyint_tag)) from super',
              'select ceil(count(tinyint_tag)) from t1',
              'select ceil(count(bool_tag)) from super',
              'select ceil(count(bool_tag)) from t1',
              'select ceil(count(nchar_tag)) from super',
              'select ceil(count(nchar_tag)) from t1',
              'select ceil(count(uint_tag)) from super',
              'select ceil(count(uint_tag)) from t1',
              'select ceil(count(ubigint_tag)) from super',
              'select ceil(count(ubigint_tag)) from t1',
              'select ceil(count(usmallint_tag)) from super',
              'select ceil(count(usmallint_tag)) from t1',
              'select ceil(count(utinyint_tag)) from super',
              'select ceil(count(utinyint_tag)) from t1',
              'select ceil(avg(int_col)) from super',
              'select ceil(avg(int_col)) from t1',
              'select ceil(avg(bigint_col)) from super',
              'select ceil(avg(bigint_col)) from t1',
              'select ceil(avg(float_col)) from super',
              'select ceil(avg(float_col)) from t1',
              'select ceil(avg(double_col)) from super',
              'select ceil(avg(double_col)) from t1',
              'select ceil(avg(smallint_col)) from super',
              'select ceil(avg(smallint_col)) from t1',
              'select ceil(avg(tinyint_col)) from super',
              'select ceil(avg(tinyint_col)) from t1',
              'select ceil(avg(uint_col)) from super',
              'select ceil(avg(uint_col)) from t1',
              'select ceil(avg(ubigint_col)) from super',
              'select ceil(avg(ubigint_col)) from t1',
              'select ceil(avg(usmallint_col)) from super',
              'select ceil(avg(usmallint_col)) from t1',
              'select ceil(avg(utinyint_col)) from super',
              'select ceil(avg(utinyint_col)) from t1',
              'select ceil(twa(int_col)) from t1',
              'select ceil(twa(bigint_col)) from t1',
              'select ceil(twa(float_col)) from t1',
              'select ceil(twa(double_col)) from t1',
              'select ceil(twa(smallint_col)) from t1',
              'select ceil(twa(tinyint_col)) from t1',
              'select ceil(twa(uint_col)) from t1',
              'select ceil(twa(ubigint_col)) from t1',
              'select ceil(twa(usmallint_col)) from t1',
              'select ceil(twa(utinyint_col)) from t1',
              'select ceil(sum(int_col)) from super',
              'select ceil(sum(int_col)) from t1',
              'select ceil(sum(bigint_col)) from super',
              'select ceil(sum(bigint_col)) from t1',
              'select ceil(sum(float_col)) from super',
              'select ceil(sum(float_col)) from t1',
              'select ceil(sum(double_col)) from super',
              'select ceil(sum(double_col)) from t1',
              'select ceil(sum(smallint_col)) from super',
              'select ceil(sum(smallint_col)) from t1',
              'select ceil(sum(tinyint_col)) from super',
              'select ceil(sum(tinyint_col)) from t1',
              'select ceil(sum(uint_col)) from super',
              'select ceil(sum(uint_col)) from t1',
              'select ceil(sum(ubigint_col)) from super',
              'select ceil(sum(ubigint_col)) from t1',
              'select ceil(sum(usmallint_col)) from super',
              'select ceil(sum(usmallint_col)) from t1',
              'select ceil(sum(utinyint_col)) from super',
              'select ceil(sum(utinyint_col)) from t1',
              'select ceil(stddev(int_col)) from super',
              'select ceil(stddev(int_col)) from t1',
              'select ceil(stddev(bigint_col)) from super',
              'select ceil(stddev(bigint_col)) from t1',
              'select ceil(stddev(float_col)) from super',
              'select ceil(stddev(float_col)) from t1',
              'select ceil(stddev(double_col)) from super',
              'select ceil(stddev(double_col)) from t1',
              'select ceil(stddev(smallint_col)) from super',
              'select ceil(stddev(smallint_col)) from t1',
              'select ceil(stddev(tinyint_col)) from super',
              'select ceil(stddev(tinyint_col)) from t1',
              'select ceil(stddev(uint_col)) from super',
              'select ceil(stddev(uint_col)) from t1',
              'select ceil(stddev(ubigint_col)) from super',
              'select ceil(stddev(ubigint_col)) from t1',
              'select ceil(stddev(usmallint_col)) from super',
              'select ceil(stddev(usmallint_col)) from t1',
              'select ceil(stddev(utinyint_col)) from super',
              'select ceil(stddev(utinyint_col)) from t1',
              'select ceil(irate(int_col)) from t1',
              'select ceil(irate(bigint_col)) from t1',
              'select ceil(irate(float_col)) from t1',
              'select ceil(irate(double_col)) from t1',
              'select ceil(irate(smallint_col)) from t1',
              'select ceil(irate(tinyint_col)) from t1',
              'select ceil(irate(uint_col)) from t1',
              'select ceil(irate(ubigint_col)) from t1',
              'select ceil(irate(usmallint_col)) from t1',
              'select ceil(irate(utinyint_col)) from t1',
              'select ceil(min(int_col)) from super',
              'select ceil(min(int_col)) from t1',
              'select ceil(min(bigint_col)) from super',
              'select ceil(min(bigint_col)) from t1',
              'select ceil(min(float_col)) from super',
              'select ceil(min(float_col)) from t1',
              'select ceil(min(double_col)) from super',
              'select ceil(min(double_col)) from t1',
              'select ceil(min(smallint_col)) from super',
              'select ceil(min(smallint_col)) from t1',
              'select ceil(min(tinyint_col)) from super',
              'select ceil(min(tinyint_col)) from t1',
              'select ceil(min(uint_col)) from super',
              'select ceil(min(uint_col)) from t1',
              'select ceil(min(ubigint_col)) from super',
              'select ceil(min(ubigint_col)) from t1',
              'select ceil(min(usmallint_col)) from super',
              'select ceil(min(usmallint_col)) from t1',
              'select ceil(min(utinyint_col)) from super',
              'select ceil(min(utinyint_col)) from t1',
              'select ceil(max(int_col)) from super',
              'select ceil(max(int_col)) from t1',
              'select ceil(max(bigint_col)) from super',
              'select ceil(max(bigint_col)) from t1',
              'select ceil(max(float_col)) from super',
              'select ceil(max(float_col)) from t1',
              'select ceil(max(double_col)) from super',
              'select ceil(max(double_col)) from t1',
              'select ceil(max(smallint_col)) from super',
              'select ceil(max(smallint_col)) from t1',
              'select ceil(max(tinyint_col)) from super',
              'select ceil(max(tinyint_col)) from t1',
              'select ceil(max(uint_col)) from super',
              'select ceil(max(uint_col)) from t1',
              'select ceil(max(ubigint_col)) from super',
              'select ceil(max(ubigint_col)) from t1',
              'select ceil(max(usmallint_col)) from super',
              'select ceil(max(usmallint_col)) from t1',
              'select ceil(max(utinyint_col)) from super',
              'select ceil(max(utinyint_col)) from t1',
              'select ceil(first(int_col)) from super',
              'select ceil(first(int_col)) from t1',
              'select ceil(first(bigint_col)) from super',
              'select ceil(first(bigint_col)) from t1',
              'select ceil(first(float_col)) from super',
              'select ceil(first(float_col)) from t1',
              'select ceil(first(double_col)) from super',
              'select ceil(first(double_col)) from t1',
              'select ceil(first(smallint_col)) from super',
              'select ceil(first(smallint_col)) from t1',
              'select ceil(first(tinyint_col)) from super',
              'select ceil(first(tinyint_col)) from t1',
              'select ceil(first(uint_col)) from super',
              'select ceil(first(uint_col)) from t1',
              'select ceil(first(ubigint_col)) from super',
              'select ceil(first(ubigint_col)) from t1',
              'select ceil(first(usmallint_col)) from super',
              'select ceil(first(usmallint_col)) from t1',
              'select ceil(first(utinyint_col)) from super',
              'select ceil(first(utinyint_col)) from t1',
              'select ceil(last(int_col)) from super',
              'select ceil(last(int_col)) from t1',
              'select ceil(last(bigint_col)) from super',
              'select ceil(last(bigint_col)) from t1',
              'select ceil(last(float_col)) from super',
              'select ceil(last(float_col)) from t1',
              'select ceil(last(double_col)) from super',
              'select ceil(last(double_col)) from t1',
              'select ceil(last(smallint_col)) from super',
              'select ceil(last(smallint_col)) from t1',
              'select ceil(last(tinyint_col)) from super',
              'select ceil(last(tinyint_col)) from t1',
              'select ceil(last(uint_col)) from super',
              'select ceil(last(uint_col)) from t1',
              'select ceil(last(ubigint_col)) from super',
              'select ceil(last(ubigint_col)) from t1',
              'select ceil(last(usmallint_col)) from super',
              'select ceil(last(usmallint_col)) from t1',
              'select ceil(last(utinyint_col)) from super',
              'select ceil(last(utinyint_col)) from t1',
              'select ceil(percentile(int_col, 1)) from t1',
              'select ceil(percentile(bigint_col, 1)) from t1',
              'select ceil(percentile(float_col, 1)) from t1',
              'select ceil(percentile(double_col, 1)) from t1',
              'select ceil(percentile(smallint_col, 1)) from t1',
              'select ceil(percentile(tinyint_col, 1)) from t1',
              'select ceil(percentile(uint_col, 1)) from t1',
              'select ceil(percentile(ubigint_col, 1)) from t1',
              'select ceil(percentile(usmallint_col, 1)) from t1',
              'select ceil(percentile(utinyint_col, 1)) from t1',
              'select ceil(apercentile(int_col, 1)) from super',
              'select ceil(apercentile(int_col, 1)) from t1',
              'select ceil(apercentile(bigint_col, 1)) from super',
              'select ceil(apercentile(bigint_col, 1)) from t1',
              'select ceil(apercentile(float_col, 1)) from super',
              'select ceil(apercentile(float_col, 1)) from t1',
              'select ceil(apercentile(double_col, 1)) from super',
              'select ceil(apercentile(double_col, 1)) from t1',
              'select ceil(apercentile(smallint_col, 1)) from super',
              'select ceil(apercentile(smallint_col, 1)) from t1',
              'select ceil(apercentile(tinyint_col, 1)) from super',
              'select ceil(apercentile(tinyint_col, 1)) from t1',
              'select ceil(apercentile(uint_col, 1)) from super',
              'select ceil(apercentile(uint_col, 1)) from t1',
              'select ceil(apercentile(ubigint_col, 1)) from super',
              'select ceil(apercentile(ubigint_col, 1)) from t1',
              'select ceil(apercentile(usmallint_col, 1)) from super',
              'select ceil(apercentile(usmallint_col, 1)) from t1',
              'select ceil(apercentile(utinyint_col, 1)) from super',
              'select ceil(apercentile(utinyint_col, 1)) from t1',
              'select ceil(last_row(int_col)) from super',
              'select ceil(last_row(int_col)) from t1',
              'select ceil(last_row(bigint_col)) from super',
              'select ceil(last_row(bigint_col)) from t1',
              'select ceil(last_row(float_col)) from super',
              'select ceil(last_row(float_col)) from t1',
              'select ceil(last_row(double_col)) from super',
              'select ceil(last_row(double_col)) from t1',
              'select ceil(last_row(smallint_col)) from super',
              'select ceil(last_row(smallint_col)) from t1',
              'select ceil(last_row(tinyint_col)) from super',
              'select ceil(last_row(tinyint_col)) from t1',
              'select ceil(last_row(uint_col)) from super',
              'select ceil(last_row(uint_col)) from t1',
              'select ceil(last_row(ubigint_col)) from super',
              'select ceil(last_row(ubigint_col)) from t1',
              'select ceil(last_row(usmallint_col)) from super',
              'select ceil(last_row(usmallint_col)) from t1',
              'select ceil(last_row(utinyint_col)) from super',
              'select ceil(last_row(utinyint_col)) from t1',
              'select ceil(spread(ts)) from super',
              'select ceil(spread(ts)) from t1',
              'select ceil(spread(timestamp_col)) from super',
              'select ceil(spread(timestamp_col)) from t1',
              'select ceil(spread(int_col)) from super',
              'select ceil(spread(int_col)) from t1',
              'select ceil(spread(bigint_col)) from super',
              'select ceil(spread(bigint_col)) from t1',
              'select ceil(spread(float_col)) from super',
              'select ceil(spread(float_col)) from t1',
              'select ceil(spread(double_col)) from super',
              'select ceil(spread(double_col)) from t1',
              'select ceil(spread(smallint_col)) from super',
              'select ceil(spread(smallint_col)) from t1',
              'select ceil(spread(tinyint_col)) from super',
              'select ceil(spread(tinyint_col)) from t1',
              'select ceil(spread(uint_col)) from super',
              'select ceil(spread(uint_col)) from t1',
              'select ceil(spread(ubigint_col)) from super',
              'select ceil(spread(ubigint_col)) from t1',
              'select ceil(spread(usmallint_col)) from super',
              'select ceil(spread(usmallint_col)) from t1',
              'select ceil(spread(utinyint_col)) from super',
              'select ceil(spread(utinyint_col)) from t1',
              'select ceil(int_col + int_col) from super',
              'select ceil(int_col + int_col) from t1',
              'select ceil(bigint_col + bigint_col) from super',
              'select ceil(bigint_col + bigint_col) from t1',
              'select ceil(float_col + float_col) from super',
              'select ceil(float_col + float_col) from t1',
              'select ceil(double_col + double_col) from super',
              'select ceil(double_col + double_col) from t1',
              'select ceil(smallint_col + smallint_col) from super',
              'select ceil(smallint_col + smallint_col) from t1',
              'select ceil(tinyint_col + tinyint_col) from super',
              'select ceil(tinyint_col + tinyint_col) from t1',
              'select ceil(uint_col + uint_col) from super',
              'select ceil(uint_col + uint_col) from t1',
              'select ceil(ubigint_col + ubigint_col) from super',
              'select ceil(ubigint_col + ubigint_col) from t1',
              'select ceil(usmallint_col + usmallint_col) from super',
              'select ceil(usmallint_col + usmallint_col) from t1',
              'select ceil(utinyint_col + utinyint_col) from super',
              'select ceil(utinyint_col + utinyint_col) from t1',
              'select ceil(int_col - int_col) from super',
              'select ceil(int_col - int_col) from t1',
              'select ceil(bigint_col - bigint_col) from super',
              'select ceil(bigint_col - bigint_col) from t1',
              'select ceil(float_col - float_col) from super',
              'select ceil(float_col - float_col) from t1',
              'select ceil(double_col - double_col) from super',
              'select ceil(double_col - double_col) from t1',
              'select ceil(smallint_col - smallint_col) from super',
              'select ceil(smallint_col - smallint_col) from t1',
              'select ceil(tinyint_col - tinyint_col) from super',
              'select ceil(tinyint_col - tinyint_col) from t1',
              'select ceil(uint_col - uint_col) from super',
              'select ceil(uint_col - uint_col) from t1',
              'select ceil(ubigint_col - ubigint_col) from super',
              'select ceil(ubigint_col - ubigint_col) from t1',
              'select ceil(usmallint_col - usmallint_col) from super',
              'select ceil(usmallint_col - usmallint_col) from t1',
              'select ceil(utinyint_col - utinyint_col) from super',
              'select ceil(utinyint_col - utinyint_col) from t1',
              'select ceil(int_col * int_col) from super',
              'select ceil(int_col * int_col) from t1',
              'select ceil(bigint_col * bigint_col) from super',
              'select ceil(bigint_col * bigint_col) from t1',
              'select ceil(float_col * float_col) from super',
              'select ceil(float_col * float_col) from t1',
              'select ceil(double_col * double_col) from super',
              'select ceil(double_col * double_col) from t1',
              'select ceil(smallint_col * smallint_col) from super',
              'select ceil(smallint_col * smallint_col) from t1',
              'select ceil(tinyint_col * tinyint_col) from super',
              'select ceil(tinyint_col * tinyint_col) from t1',
              'select ceil(uint_col * uint_col) from super',
              'select ceil(uint_col * uint_col) from t1',
              'select ceil(ubigint_col * ubigint_col) from super',
              'select ceil(ubigint_col * ubigint_col) from t1',
              'select ceil(usmallint_col * usmallint_col) from super',
              'select ceil(usmallint_col * usmallint_col) from t1',
              'select ceil(utinyint_col * utinyint_col) from super',
              'select ceil(utinyint_col * utinyint_col) from t1',
              'select ceil(int_col / int_col) from super',
              'select ceil(int_col / int_col) from t1',
              'select ceil(bigint_col / bigint_col) from super',
              'select ceil(bigint_col / bigint_col) from t1',
              'select ceil(float_col / float_col) from super',
              'select ceil(float_col / float_col) from t1',
              'select ceil(double_col / double_col) from super',
              'select ceil(double_col / double_col) from t1',
              'select ceil(smallint_col / smallint_col) from super',
              'select ceil(smallint_col / smallint_col) from t1',
              'select ceil(tinyint_col / tinyint_col) from super',
              'select ceil(tinyint_col / tinyint_col) from t1',
              'select ceil(uint_col / uint_col) from super',
              'select ceil(uint_col / uint_col) from t1',
              'select ceil(ubigint_col / ubigint_col) from super',
              'select ceil(ubigint_col / ubigint_col) from t1',
              'select ceil(usmallint_col / usmallint_col) from super',
              'select ceil(usmallint_col / usmallint_col) from t1',
              'select ceil(utinyint_col / utinyint_col) from super',
              'select ceil(utinyint_col / utinyint_col) from t1',
              'select int_col, ceil(int_col), int_col from super',
              'select int_col, ceil(int_col), int_col from t1',
              'select bigint_col, ceil(bigint_col), bigint_col from super',
              'select bigint_col, ceil(bigint_col), bigint_col from t1',
              'select float_col, ceil(float_col), float_col from super',
              'select float_col, ceil(float_col), float_col from t1',
              'select double_col, ceil(double_col), double_col from super',
              'select double_col, ceil(double_col), double_col from t1',
              'select smallint_col, ceil(smallint_col), smallint_col from super',
              'select smallint_col, ceil(smallint_col), smallint_col from t1',
              'select tinyint_col, ceil(tinyint_col), tinyint_col from super',
              'select tinyint_col, ceil(tinyint_col), tinyint_col from t1',
              'select uint_col, ceil(uint_col), uint_col from super',
              'select uint_col, ceil(uint_col), uint_col from t1',
              'select ubigint_col, ceil(ubigint_col), ubigint_col from super',
              'select ubigint_col, ceil(ubigint_col), ubigint_col from t1',
              'select usmallint_col, ceil(usmallint_col), usmallint_col from super',
              'select usmallint_col, ceil(usmallint_col), usmallint_col from t1',
              'select utinyint_col, ceil(utinyint_col), utinyint_col from super',
              'select utinyint_col, ceil(utinyint_col), utinyint_col from t1',
              'select 1, ceil(int_col), 1 from super',
              'select 1, ceil(int_col), 1 from t1',
              'select 1, ceil(bigint_col), 1 from super',
              'select 1, ceil(bigint_col), 1 from t1',
              'select 1, ceil(float_col), 1 from super',
              'select 1, ceil(float_col), 1 from t1',
              'select 1, ceil(double_col), 1 from super',
              'select 1, ceil(double_col), 1 from t1',
              'select 1, ceil(smallint_col), 1 from super',
              'select 1, ceil(smallint_col), 1 from t1',
              'select 1, ceil(tinyint_col), 1 from super',
              'select 1, ceil(tinyint_col), 1 from t1',
              'select 1, ceil(uint_col), 1 from super',
              'select 1, ceil(uint_col), 1 from t1',
              'select 1, ceil(ubigint_col), 1 from super',
              'select 1, ceil(ubigint_col), 1 from t1',
              'select 1, ceil(usmallint_col), 1 from super',
              'select 1, ceil(usmallint_col), 1 from t1',
              'select 1, ceil(utinyint_col), 1 from super',
              'select 1, ceil(utinyint_col), 1 from t1',
              'select ceil(int_col) as anyName from super',
              'select ceil(int_col) as anyName from t1',
              'select ceil(bigint_col) as anyName from super',
              'select ceil(bigint_col) as anyName from t1',
              'select ceil(float_col) as anyName from super',
              'select ceil(float_col) as anyName from t1',
              'select ceil(double_col) as anyName from super',
              'select ceil(double_col) as anyName from t1',
              'select ceil(smallint_col) as anyName from super',
              'select ceil(smallint_col) as anyName from t1',
              'select ceil(tinyint_col) as anyName from super',
              'select ceil(tinyint_col) as anyName from t1',
              'select ceil(uint_col) as anyName from super',
              'select ceil(uint_col) as anyName from t1',
              'select ceil(ubigint_col) as anyName from super',
              'select ceil(ubigint_col) as anyName from t1',
              'select ceil(usmallint_col) as anyName from super',
              'select ceil(usmallint_col) as anyName from t1',
              'select ceil(utinyint_col) as anyName from super',
              'select ceil(utinyint_col) as anyName from t1']
        for s in range(len(select_command)):
            for f in range(len(from_command)):
                sql = "select " + select_command[s] + from_command[f]
                if sql in shouldPass:
                    tdSql.query(sql)
                else:
                    tdSql.error(sql)

        shouldPass2 = ['select ceil(super.int_col) from super',
                       'select ceil(super.int_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
                       'select ceil(super.bigint_col) from super',
                       'select ceil(super.bigint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
                       'select ceil(super.float_col) from super',
                       'select ceil(super.float_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
                       'select ceil(super.double_col) from super',
                       'select ceil(super.double_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
                       'select ceil(super.smallint_col) from super',
                       'select ceil(super.smallint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
                       'select ceil(super.tinyint_col) from super',
                       'select ceil(super.tinyint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
                       'select ceil(super.uint_col) from super',
                       'select ceil(super.uint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
                       'select ceil(super.ubigint_col) from super',
                       'select ceil(super.ubigint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
                       'select ceil(super.usmallint_col) from super',
                       'select ceil(super.usmallint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
                       'select ceil(super.utinyint_col) from super',
                       'select ceil(super.utinyint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
                       'select ceil(t1.int_col) from t1',
                       'select ceil(t1.bigint_col) from t1',
                       'select ceil(t1.float_col) from t1',
                       'select ceil(t1.double_col) from t1',
                       'select ceil(t1.smallint_col) from t1',
                       'select ceil(t1.tinyint_col) from t1',
                       'select ceil(t1.uint_col) from t1',
                       'select ceil(t1.ubigint_col) from t1',
                       'select ceil(t1.usmallint_col) from t1',
                       'select ceil(t1.utinyint_col) from t1']
        for sim in range(len(simple_select_command)):
            for fr in range(len(advance_from_command)):
                for groupby in range(len(filter_command)):
                    for fill in range(len(fill_command)):
                        sql = "select " + simple_select_command[sim] + advance_from_command[fr] + filter_command[groupby] + fill_command[fill]
                        if sql in shouldPass2:
                            tdSql.query(sql)
                        else:
                            tdSql.error(sql)

    def stop(self):
        tdSql.close()
        tdLog.success("%s successfully executed" % __file__)


tdCases.addWindows(__file__, TDTestCase())
tdCases.addLinux(__file__, TDTestCase())
