/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 304
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOperatorType yy60;
  SNode* yy104;
  SToken yy129;
  bool yy185;
  int32_t yy196;
  SAlterOption yy253;
  SNodeList* yy312;
  SDataType yy336;
  EOrder yy354;
  ENullOrder yy489;
  EJoinType yy532;
  EFillMode yy550;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYNSTATE             512
#define YYNRULE              389
#define YYNTOKEN             201
#define YY_MAX_SHIFT         511
#define YY_MIN_SHIFTREDUCE   762
#define YY_MAX_SHIFTREDUCE   1150
#define YY_ERROR_ACTION      1151
#define YY_ACCEPT_ACTION     1152
#define YY_NO_ACTION         1153
#define YY_MIN_REDUCE        1154
#define YY_MAX_REDUCE        1542
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1412)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1398,   24,  191,  442,  442,  504,  503,  253, 1307,   72,
 /*    10 */    72,  270, 1394, 1401,  252,  307,  349,  355,  233, 1305,
 /*    20 */  1010, 1197, 1155,  442, 1398, 1260, 1260,  319, 1398,  305,
 /*    30 */   331,   31,   29,   27,   26,   25, 1394, 1400,  429,  332,
 /*    40 */  1394, 1400,  234,   84, 1348, 1260,   83,   82,   81,   80,
 /*    50 */    79,   78,   77,   76,   75,  273,   31,   29,   27,   26,
 /*    60 */    25,  429, 1338, 1340,  265,  213,  236, 1347, 1290,  441,
 /*    70 */   496,  495,  494,  493,  492,  491,  490,  489,  207,  486,
 /*    80 */   485,  484,  483,  482,  481,  480,  479,  478,  998, 1026,
 /*    90 */    31,   29,   27,   26,   25,   84,  441, 1056,   83,   82,
 /*   100 */    81,   80,   79,   78,   77,   76,   75,  330, 1154,  442,
 /*   110 */   325,  324,  323,  322,  321,  306,  318,  317,  316,  315,
 /*   120 */   311,  310,  309,  308,  442,  236,   27,   26,   25,  340,
 /*   130 */   312, 1260,   93,   92,   91,   90,   89,   88,   87,   86,
 /*   140 */    85, 1428,  362, 1057,  357,   12, 1260,  361,  426, 1012,
 /*   150 */   160,  442,  358,  356, 1001,  359, 1056,  313,  404,  399,
 /*   160 */   410, 1061,  874,  465,  464,  463,  878,  462,  880,  881,
 /*   170 */   461,  883,  458, 1260,  889,  455,  891,  892,  452,  449,
 /*   180 */   400,  126,   98, 1010,   23,  260, 1051, 1052, 1053, 1054,
 /*   190 */  1055, 1059, 1060,   20,  112, 1412,  300, 1013,  299,  219,
 /*   200 */   385,  266, 1057,   31,   29,   27,   26,   25,  442,  111,
 /*   210 */   111,  217,  405,  401,  339,   96, 1428, 1262, 1263,  292,
 /*   220 */  1061,  136, 1251,  426,  412,  121, 1467, 1468, 1177, 1472,
 /*   230 */  1260,  477,  301,  428,  294,  126,  113, 1385, 1166, 1412,
 /*   240 */  1011,  386,  414,   23,  260, 1051, 1052, 1053, 1054, 1055,
 /*   250 */  1059, 1060,  126,   68, 1413, 1414, 1417, 1460,   30,   28,
 /*   260 */  1428,  235, 1456, 1521, 1385,  442,  262,  426,  990,  468,
 /*   270 */  1385, 1257, 1521, 1521, 1249, 1412,  125,  428,  990,  159,
 /*   280 */  1519, 1385,   67,  352,  988,  125,  125, 1260, 1117, 1519,
 /*   290 */  1519, 1374,   49,   11,  988,    6, 1428,   70, 1413, 1414,
 /*   300 */  1417, 1460,   95,  413,  354, 1459, 1456,   45,   44,  304,
 /*   310 */  1255,  130, 1245,  428, 1200,    1,  298, 1385,  396, 1115,
 /*   320 */  1116, 1118, 1119,  410,  242,  442,  290,  284,  286,  282,
 /*   330 */   127,  439,  441,   69, 1413, 1414, 1417, 1460,  508,  126,
 /*   340 */   326,  255, 1456,  120, 1428,   98, 1247, 1260,  508,   49,
 /*   350 */   989,  426,  126,  442, 1014,  187,   30,   28, 1093,  440,
 /*   360 */   989,  392, 1487,  362,  262,  357,  990, 1256,  361,   30,
 /*   370 */    28,  160, 1412,  358,  356, 1260,  359,  262,   96,  990,
 /*   380 */  1243,   12,  988,  403,  991,  135,  134, 1176,  122, 1467,
 /*   390 */  1468,   11, 1472, 1428,  991,  988,    9,    8,  117, 1238,
 /*   400 */   413,  994,  995,  224,   11, 1039,  114,  272, 1224, 1300,
 /*   410 */   428,  994,  995,    1, 1385,  111, 1412,   31,   29,   27,
 /*   420 */    26,   25,  126, 1262,   65, 1412,    1, 1088, 1152, 1385,
 /*   430 */    69, 1413, 1414, 1417, 1460,   99,  508, 1428,  255, 1456,
 /*   440 */   120, 1307, 1252, 1521,  426,  340, 1428,  267,  989,  508,
 /*   450 */   165, 1307, 1305,  426,  428, 1058, 1520,  274, 1385, 1488,
 /*   460 */  1519,  989, 1305,  428,  186, 1069, 1038, 1385, 1040, 1041,
 /*   470 */  1042, 1043, 1044, 1062,  227, 1413, 1414, 1417,  277,  467,
 /*   480 */    30,   28,  991,   69, 1413, 1414, 1417, 1460,  262, 1412,
 /*   490 */   990,  255, 1456, 1533,  131,  991,   21, 1175, 1236,  994,
 /*   500 */   995,  224, 1494, 1039, 1412,  384,  988,  275,  417, 1521,
 /*   510 */  1428, 1174,  994,  995,  224,  111, 1039,  426,   47,  410,
 /*   520 */  1015,   46,  125, 1262, 1307, 1428, 1519,  428, 1173,  798,
 /*   530 */  1092, 1385,  426, 1412, 1474, 1339, 1147,    7,  799, 1385,
 /*   540 */   798,   98,  428, 1167,  477,  347, 1385,   69, 1413, 1414,
 /*   550 */  1417, 1460, 1471, 1385, 1428,  255, 1456, 1533,  800,  188,
 /*   560 */   508,  426,  230, 1413, 1414, 1417, 1517, 1100, 1225, 1172,
 /*   570 */  1385,  428,  989, 1012,   96, 1385,  442, 1171, 1474,   30,
 /*   580 */    28,  427,  205, 1335,  123, 1467, 1468,  262, 1472,  990,
 /*   590 */   133,   69, 1413, 1414, 1417, 1460, 1470, 1170, 1260,  255,
 /*   600 */  1456, 1533, 1146, 1474,   22,  988,  991, 1412, 1169,  376,
 /*   610 */  1478, 1385,   30,   28,   31,   29,   27,   26,   25, 1385,
 /*   620 */   262, 1469,  990,  994,  995,  224,  442, 1039, 1428,   58,
 /*   630 */   172, 1168,  276, 1165, 1164,  426,    7, 1163,  988, 1385,
 /*   640 */  1521, 1162, 1161,  487,  126,  428,  295, 1253, 1260, 1385,
 /*   650 */  1385,  269,  268,  125,  414, 1479, 1088, 1519, 1160,  508,
 /*   660 */   418, 1003,   30,   28,  511,  225, 1413, 1414, 1417,    7,
 /*   670 */   262,  989,  990, 1385,  421, 1385, 1385,  996,  210, 1385,
 /*   680 */   397,   94, 1307, 1385, 1385, 1521, 1159,  500,  988,  209,
 /*   690 */  1158, 1157,  508, 1306,    9,    8,  152,  416,  125,  150,
 /*   700 */  1385, 1301, 1519, 1091,  989,  991, 1412,  154,  156,  158,
 /*   710 */   153,  155,  157,   66, 1193, 1188,  203, 1186,  104,    1,
 /*   720 */   425,  388,  994,  995,  224,   64, 1039, 1428, 1385, 1149,
 /*   730 */  1150,  443, 1385, 1385,  426,   60,  363,  365,  991,  368,
 /*   740 */   181, 1405,  508,  999,  428,  374,  438,   43, 1385,  175,
 /*   750 */  1114,  997,  177, 1403,  989,  994,  995,  224,  372, 1039,
 /*   760 */   410,  346, 1412,  411,   70, 1413, 1414, 1417, 1460, 1490,
 /*   770 */  1429,  391,  424, 1456,  168,   32,   32, 1004, 1063, 1023,
 /*   780 */   190, 1010,   98, 1428,    2,  279,  283,  419,  991,  974,
 /*   790 */   426,  164,  241,  841, 1007,  995,   32,  243,  966,  957,
 /*   800 */   428,  414,  314,  422, 1385,  994,  995,  224,  211, 1039,
 /*   810 */  1412,  194,  132,  101,  196,   96,  434, 1000, 1337,  320,
 /*   820 */   115, 1413, 1414, 1417,  328,  184, 1467,  409, 1048,  408,
 /*   830 */   333, 1428, 1521,   31,   29,   27,   26,   25,  426,  102,
 /*   840 */  1019,  246,  202,  104,  147,  125,  867,  119,  428, 1519,
 /*   850 */   327,   43, 1385,  345,  862,  146,  329,  447,  415, 1534,
 /*   860 */   895,  334,  102,  159, 1412,  899,  335,  352,   70, 1413,
 /*   870 */  1414, 1417, 1460, 1412, 1018,  336,  139, 1457,  247,   50,
 /*   880 */   245,  244,  144,  351,  103, 1428,  337,  905,  354, 1017,
 /*   890 */   104, 1026,  426,  904, 1428,  102,  338,  142,  105,   48,
 /*   900 */   341,  426,  428,  145, 1016,  348, 1385, 1412,  350,  261,
 /*   910 */   377,  428,  353, 1250,  149, 1385,   74, 1246,  393,  151,
 /*   920 */   106,  107,  229, 1413, 1414, 1417, 1248, 1244, 1428,  108,
 /*   930 */   109,  229, 1413, 1414, 1417,  426,  143,  360,  138,  251,
 /*   940 */   140,  379,  378, 1412,  167,  428,  170, 1015,  389, 1385,
 /*   950 */   398, 1412,  383, 1501,  367,  390,  995,  137,  432, 1500,
 /*   960 */     5,  387,  380, 1481, 1428,  228, 1413, 1414, 1417,  375,
 /*   970 */   407,  426, 1428,  173,  395,    4,  254, 1412,  176,  426,
 /*   980 */  1491,  428,  402,  162,  394, 1385,  370, 1088,   97,  428,
 /*   990 */  1014,  364, 1237, 1385,  161,   33,  259,  406, 1428, 1235,
 /*  1000 */  1475,  115, 1413, 1414, 1417,  426, 1412,  118,  180,  229,
 /*  1010 */  1413, 1414, 1417,  256,  183,  428, 1518,  182,   41, 1385,
 /*  1020 */   423,   40,  263,  420,  189, 1536,   17, 1428, 1442, 1346,
 /*  1030 */  1412,  430,  431,  264,  426,  229, 1413, 1414, 1417, 1345,
 /*  1040 */  1535,  435,  436,  200,  428,  198,  437,   57, 1385,  206,
 /*  1050 */   212, 1428,   59,  473, 1412,  474,  206,  488,  426, 1261,
 /*  1060 */   473,  445,  214,  507,  222, 1413, 1414, 1417,  428,  208,
 /*  1070 */   220,   39, 1385,  216,  475, 1428, 1379,  221, 1412,  218,
 /*  1080 */  1378,  475,  426,  278, 1375,  280,  281,  984,  231, 1413,
 /*  1090 */  1414, 1417,  428,  472,  471,  470, 1385,  469,  985, 1428,
 /*  1100 */   472,  471,  470,  128,  469,  285,  426, 1412, 1373,  287,
 /*  1110 */   288,  289,  223, 1413, 1414, 1417,  428, 1372, 1371,  291,
 /*  1120 */  1385,  293, 1362,  129,  296,  297,  969,  968, 1428, 1356,
 /*  1130 */  1355,  303,  302, 1412, 1354,  426,  232, 1413, 1414, 1417,
 /*  1140 */  1353, 1412,  940, 1330, 1329,  428, 1328, 1327, 1326, 1385,
 /*  1150 */  1325, 1324, 1323, 1322, 1428, 1321, 1320, 1319, 1318,  100,
 /*  1160 */  1317,  426, 1428, 1316, 1315, 1425, 1413, 1414, 1417,  426,
 /*  1170 */  1314,  428, 1313, 1312, 1311, 1385, 1412, 1310, 1309,  428,
 /*  1180 */  1308,  942, 1412, 1385, 1199, 1370, 1364, 1352, 1343, 1239,
 /*  1190 */   811, 1424, 1413, 1414, 1417, 1198, 1196, 1428, 1185, 1423,
 /*  1200 */  1413, 1414, 1417, 1428,  426,  141,  342,  343,  344, 1184,
 /*  1210 */   426, 1412, 1181, 1241,  428,   73,  487, 1412, 1385,  912,
 /*  1220 */   428,  148,  910, 1240, 1385, 1194,  248, 1189,  840,  839,
 /*  1230 */   838,  837, 1428,  249,  239, 1413, 1414, 1417, 1428,  426,
 /*  1240 */   238, 1413, 1414, 1417,  835,  426,  834, 1187,  250,  428,
 /*  1250 */  1180,  371,  369, 1385,  366,  428, 1179,  373,   71, 1385,
 /*  1260 */  1369,   42,  163, 1412, 1363,  381,  976,  110,  382,  240,
 /*  1270 */  1413, 1414, 1417, 1351, 1350,  237, 1413, 1414, 1417, 1342,
 /*  1280 */   169,  166,   14, 1403, 1428,   51,  171,    3,   32,  174,
 /*  1290 */    15,  426, 1113,  116,   34,   54,   36,   37,  185,  124,
 /*  1300 */   178,  428, 1107,   52, 1135, 1385, 1106,  179,   53,   19,
 /*  1310 */  1134, 1085,   35,   10, 1084,   16, 1140,    8,  257, 1139,
 /*  1320 */  1138,  226, 1413, 1414, 1417,  258, 1341, 1024,   13,  433,
 /*  1330 */  1049,   18,  192,  193,   60, 1111,  195,  197,   55,  199,
 /*  1340 */    56, 1005, 1402,  446,   38,  271,  450,  896,  893,  453,
 /*  1350 */   456,  204,  448,  451,  459,  890,  444,  454,  201,  884,
 /*  1360 */   882,  457,  460,  873,  901,  907,  903,   61,  809,  476,
 /*  1370 */    62,   63,  831,  830,  829,  828,  827,  826,  825,  823,
 /*  1380 */   888,  466,  824,  842,  821,  820,  819,  818,  887,  886,
 /*  1390 */   817,  885,  816,  815,  814, 1195,  497,  498, 1183, 1182,
 /*  1400 */   501,  502,  499, 1178,  906,  505,  506, 1153,  992,  215,
 /*  1410 */   509,  510,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   246,  267,  268,  210,  210,  207,  208,  229,  225,  216,
 /*    10 */   216,  229,  258,  259,  231,  210,  223,  223,   18,  236,
 /*    20 */    20,    0,    0,  210,  246,  232,  232,   27,  246,  216,
 /*    30 */    30,   12,   13,   14,   15,   16,  258,  259,  242,   39,
 /*    40 */   258,  259,  237,   21,  248,  232,   24,   25,   26,   27,
 /*    50 */    28,   29,   30,   31,   32,  234,   12,   13,   14,   15,
 /*    60 */    16,  242,  241,  242,  245,  218,   47,  248,  221,   20,
 /*    70 */    49,   50,   51,   52,   53,   54,   55,   56,   57,   58,
 /*    80 */    59,   60,   61,   62,   63,   64,   65,   66,   38,   70,
 /*    90 */    12,   13,   14,   15,   16,   21,   20,   78,   24,   25,
 /*   100 */    26,   27,   28,   29,   30,   31,   32,  107,    0,  210,
 /*   110 */   110,  111,  112,  113,  114,  216,  116,  117,  118,  119,
 /*   120 */   120,  121,  122,  123,  210,   47,   14,   15,   16,   46,
 /*   130 */   216,  232,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   140 */    32,  225,   49,  124,   51,   69,  232,   54,  232,   20,
 /*   150 */    57,  210,   59,   60,  104,   62,   78,  216,   20,  128,
 /*   160 */   210,  142,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   170 */    91,   92,   93,  232,   95,   96,   97,   98,   99,  100,
 /*   180 */   264,  176,  232,   20,  165,  166,  167,  168,  169,  170,
 /*   190 */   171,  172,  173,    2,   18,  204,  137,   20,  139,   23,
 /*   200 */   210,  217,  124,   12,   13,   14,   15,   16,  210,  225,
 /*   210 */   225,   35,  181,  182,  216,  265,  225,  233,  233,  134,
 /*   220 */   142,   45,  204,  232,  274,  275,  276,  277,  204,  279,
 /*   230 */   232,   46,  251,  242,  149,  176,  203,  246,  205,  204,
 /*   240 */    20,  251,  251,  165,  166,  167,  168,  169,  170,  171,
 /*   250 */   172,  173,  176,  262,  263,  264,  265,  266,   12,   13,
 /*   260 */   225,  270,  271,  282,  246,  210,   20,  232,   22,   80,
 /*   270 */   246,  216,  282,  282,  226,  204,  295,  242,   22,   57,
 /*   280 */   299,  246,  106,   61,   38,  295,  295,  232,  155,  299,
 /*   290 */   299,    0,  212,   47,   38,   43,  225,  262,  263,  264,
 /*   300 */   265,  266,  222,  232,   82,  270,  271,  131,  132,  133,
 /*   310 */   230,  135,  226,  242,    0,   69,  140,  246,  185,  186,
 /*   320 */   187,  188,  189,  210,  148,  210,  150,   36,  152,  153,
 /*   330 */   154,  216,   20,  262,  263,  264,  265,  266,   92,  176,
 /*   340 */    63,  270,  271,  272,  225,  232,  226,  232,   92,  212,
 /*   350 */   104,  232,  176,  210,   20,  284,   12,   13,   14,  216,
 /*   360 */   104,  290,  291,   49,   20,   51,   22,  230,   54,   12,
 /*   370 */    13,   57,  204,   59,   60,  232,   62,   20,  265,   22,
 /*   380 */   226,   69,   38,  264,  138,  108,  109,  204,  275,  276,
 /*   390 */   277,   47,  279,  225,  138,   38,    1,    2,  224,    0,
 /*   400 */   232,  155,  156,  157,   47,  159,  213,  217,  215,  235,
 /*   410 */   242,  155,  156,   69,  246,  225,  204,   12,   13,   14,
 /*   420 */    15,   16,  176,  233,  209,  204,   69,  175,  201,  246,
 /*   430 */   262,  263,  264,  265,  266,  220,   92,  225,  270,  271,
 /*   440 */   272,  225,  227,  282,  232,   46,  225,  231,  104,   92,
 /*   450 */   226,  225,  236,  232,  242,  124,  295,  231,  246,  291,
 /*   460 */   299,  104,  236,  242,  130,   70,  158,  246,  160,  161,
 /*   470 */   162,  163,  164,  142,  262,  263,  264,  265,  251,  226,
 /*   480 */    12,   13,  138,  262,  263,  264,  265,  266,   20,  204,
 /*   490 */    22,  270,  271,  272,   44,  138,  165,  204,    0,  155,
 /*   500 */   156,  157,  281,  159,  204,  254,   38,  217,    3,  282,
 /*   510 */   225,  204,  155,  156,  157,  225,  159,  232,   68,  210,
 /*   520 */    20,   71,  295,  233,  225,  225,  299,  242,  204,   22,
 /*   530 */     4,  246,  232,  204,  260,  236,  131,   69,   20,  246,
 /*   540 */    22,  232,  242,  205,   46,   38,  246,  262,  263,  264,
 /*   550 */   265,  266,  278,  246,  225,  270,  271,  272,   40,  302,
 /*   560 */    92,  232,  262,  263,  264,  265,  281,   14,  215,  204,
 /*   570 */   246,  242,  104,   20,  265,  246,  210,  204,  260,   12,
 /*   580 */    13,   14,  216,  232,  275,  276,  277,   20,  279,   22,
 /*   590 */   239,  262,  263,  264,  265,  266,  278,  204,  232,  270,
 /*   600 */   271,  272,  197,  260,    2,   38,  138,  204,  204,  251,
 /*   610 */   281,  246,   12,   13,   12,   13,   14,   15,   16,  246,
 /*   620 */    20,  278,   22,  155,  156,  157,  210,  159,  225,  209,
 /*   630 */   130,  204,  216,  204,  204,  232,   69,  204,   38,  246,
 /*   640 */   282,  204,  204,   67,  176,  242,   70,  227,  232,  246,
 /*   650 */   246,   12,   13,  295,  251,  174,  175,  299,  204,   92,
 /*   660 */    67,   22,   12,   13,   19,  262,  263,  264,  265,   69,
 /*   670 */    20,  104,   22,  246,   67,  246,  246,   38,   33,  246,
 /*   680 */   293,   36,  225,  246,  246,  282,  204,   42,   38,   44,
 /*   690 */   204,  204,   92,  236,    1,    2,   73,  192,  295,   76,
 /*   700 */   246,  235,  299,  177,  104,  138,  204,   73,   73,   73,
 /*   710 */    76,   76,   76,   68,    0,    0,   71,    0,   67,   69,
 /*   720 */    47,   70,  155,  156,  157,   69,  159,  225,  246,  199,
 /*   730 */   200,   92,  246,  246,  232,   79,   22,   22,  138,   22,
 /*   740 */   287,   69,   92,  104,  242,   21,  101,   67,  246,   67,
 /*   750 */    70,   38,   70,   81,  104,  155,  156,  157,   34,  159,
 /*   760 */   210,  207,  204,  280,  262,  263,  264,  265,  266,  261,
 /*   770 */   225,  126,  270,  271,  129,   67,   67,  138,   70,   70,
 /*   780 */   296,   20,  232,  225,  283,  210,   36,  194,  138,  144,
 /*   790 */   232,  146,  257,   38,  155,  156,   67,  214,  136,   70,
 /*   800 */   242,  251,  210,  196,  246,  155,  156,  157,  252,  159,
 /*   810 */   204,   67,  115,   67,   70,  265,   70,  104,  210,  240,
 /*   820 */   262,  263,  264,  265,  124,  275,  276,  277,  155,  279,
 /*   830 */   210,  225,  282,   12,   13,   14,   15,   16,  232,   67,
 /*   840 */    20,   35,   70,   67,   33,  295,   70,   36,  242,  299,
 /*   850 */   238,   67,  246,   42,   70,   44,  238,   67,  300,  301,
 /*   860 */    70,  256,   67,   57,  204,   70,  242,   61,  262,  263,
 /*   870 */   264,  265,  266,  204,   20,  250,  212,  271,   72,   68,
 /*   880 */    74,   75,   71,   77,   67,  225,  232,   70,   82,   20,
 /*   890 */    67,   70,  232,   70,  225,   67,  243,  212,   70,  212,
 /*   900 */   210,  232,  242,  212,   20,  206,  246,  204,  225,  249,
 /*   910 */   232,  242,  214,  225,  225,  246,  210,  225,  249,  225,
 /*   920 */   225,  225,  262,  263,  264,  265,  225,  225,  225,  225,
 /*   930 */   225,  262,  263,  264,  265,  232,  125,  214,  127,  206,
 /*   940 */   129,  145,  256,  204,  209,  242,  209,   20,  232,  246,
 /*   950 */   184,  204,  242,  292,    4,  243,  156,  146,  183,  292,
 /*   960 */   191,  250,  255,  289,  225,  262,  263,  264,  265,   19,
 /*   970 */   190,  232,  225,  247,  246,  178,  246,  204,  247,  232,
 /*   980 */   261,  242,  246,   33,  179,  246,   36,  175,  232,  242,
 /*   990 */    20,   41,    0,  246,   44,  115,  249,  294,  225,    0,
 /*  1000 */   260,  262,  263,  264,  265,  232,  204,  286,  288,  262,
 /*  1010 */   263,  264,  265,  198,  273,  242,  298,  285,   68,  246,
 /*  1020 */   195,   71,  249,  193,  297,  303,   69,  225,  269,  247,
 /*  1030 */   204,  246,  246,  246,  232,  262,  263,  264,  265,  247,
 /*  1040 */   301,  127,  244,  209,  242,  232,  243,  209,  246,   57,
 /*  1050 */   221,  225,   69,   61,  204,  214,   57,  214,  232,  232,
 /*  1060 */    61,  228,  210,  206,  262,  263,  264,  265,  242,  209,
 /*  1070 */   219,  253,  246,  211,   82,  225,    0,  219,  204,  202,
 /*  1080 */     0,   82,  232,   60,    0,   38,  151,   38,  262,  263,
 /*  1090 */   264,  265,  242,  101,  102,  103,  246,  105,   38,  225,
 /*  1100 */   101,  102,  103,   38,  105,  151,  232,  204,    0,   38,
 /*  1110 */    38,  151,  262,  263,  264,  265,  242,    0,    0,   38,
 /*  1120 */   246,   38,    0,   69,  142,  141,  104,  138,  225,    0,
 /*  1130 */     0,  134,   50,  204,    0,  232,  262,  263,  264,  265,
 /*  1140 */     0,  204,   81,    0,    0,  242,    0,    0,    0,  246,
 /*  1150 */     0,    0,    0,    0,  225,    0,    0,    0,    0,  115,
 /*  1160 */     0,  232,  225,    0,    0,  262,  263,  264,  265,  232,
 /*  1170 */     0,  242,    0,    0,    0,  246,  204,    0,    0,  242,
 /*  1180 */     0,   22,  204,  246,    0,    0,    0,    0,    0,    0,
 /*  1190 */    48,  262,  263,  264,  265,    0,    0,  225,    0,  262,
 /*  1200 */   263,  264,  265,  225,  232,   43,   38,   36,   43,    0,
 /*  1210 */   232,  204,    0,    0,  242,   78,   67,  204,  246,   38,
 /*  1220 */   242,   76,   22,    0,  246,    0,   22,    0,   38,   38,
 /*  1230 */    38,   38,  225,   22,  262,  263,  264,  265,  225,  232,
 /*  1240 */   262,  263,  264,  265,   38,  232,   38,    0,   22,  242,
 /*  1250 */     0,   22,   38,  246,   39,  242,    0,   22,   20,  246,
 /*  1260 */     0,  130,  147,  204,    0,   22,   38,  143,  130,  262,
 /*  1270 */   263,  264,  265,    0,    0,  262,  263,  264,  265,    0,
 /*  1280 */    43,  127,  180,   81,  225,   69,  125,   67,   67,   70,
 /*  1290 */   180,  232,   70,   69,  174,    4,  130,   67,   81,   81,
 /*  1300 */    69,  242,   70,   69,   38,  246,   70,   67,   69,   67,
 /*  1310 */    38,   70,   67,  180,   70,   67,   70,    2,   38,   38,
 /*  1320 */    38,  262,  263,  264,  265,   38,    0,   70,   69,  128,
 /*  1330 */   155,   69,   81,   70,   79,   70,   69,   69,   69,   43,
 /*  1340 */    69,   22,   81,   38,   69,   38,   38,   70,   70,   38,
 /*  1350 */    38,   81,   69,   69,   38,   70,   80,   69,  125,   70,
 /*  1360 */    70,   69,   69,   22,   22,   38,   38,   69,   48,   47,
 /*  1370 */    69,   69,   22,   38,   38,   38,   38,   38,   38,   22,
 /*  1380 */    94,   82,   38,   38,   38,   38,   38,   38,   94,   94,
 /*  1390 */    38,   94,   38,   38,   38,    0,   38,   36,    0,    0,
 /*  1400 */    38,   37,   43,    0,  104,   22,   21,  304,   22,   22,
 /*  1410 */    21,   20,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1420 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1430 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1440 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1450 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1460 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1470 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1480 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1490 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1500 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1510 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1520 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1530 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1540 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1550 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1560 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1570 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1580 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1590 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1600 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1610 */   304,  304,  304,
};
#define YY_SHIFT_COUNT    (511)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1403)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   176,  246,  344,  357,  357,  357,  357,  468,  357,  357,
 /*    10 */   600,  650,   76,  567,  600,  600,  600,  600,  600,  600,
 /*    20 */   600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
 /*    30 */   600,  600,  600,  312,  312,  312,  163,  639,  639,   59,
 /*    40 */    49,   49,    5,  639,   49,   49,   49,   49,   49,   49,
 /*    50 */    83,  129,  138,  138,    5,  177,  129,   49,   49,  129,
 /*    60 */    49,  129,  177,  129,  129,   49,  185,    0,   19,   78,
 /*    70 */    78,   74,  806,  256,   93,  256,  256,  256,  256,  256,
 /*    80 */   256,  256,  256,  256,  256,  256,  256,  256,  256,  256,
 /*    90 */   256,  256,  256,  256,  518,  399,  334,  334,  334,  498,
 /*   100 */   220,  177,  129,  129,  129,  189,   79,   79,   79,   79,
 /*   110 */    79,   79,  645,   22,  314,  405,  133,  222,   31,  507,
 /*   120 */   500,  481,  252,  481,  553,  505,  526,  761,  750,  755,
 /*   130 */   662,  761,  761,  697,  700,  700,  761,  820,  177,  854,
 /*   140 */    83,  220,  869,   83,   83,  761,   83,  884,  129,  129,
 /*   150 */   129,  129,  129,  129,  129,  129,  129,  129,  129,  755,
 /*   160 */   755,  761,  884,  220,  820,  796,  177,  854,  185,  220,
 /*   170 */   869,  185,  927,  766,  775,  800,  766,  775,  800,  800,
 /*   180 */   769,  780,  805,  797,  812,  220,  970,  880,  815,  825,
 /*   190 */   830,  957,  129,  775,  800,  800,  775,  800,  914,  220,
 /*   200 */   869,  185,  189,  185,  220,  983,  755,  755,  761,  185,
 /*   210 */   884, 1412, 1412, 1412, 1412, 1412,   21,  811,  108,  950,
 /*   220 */   992,  999,  191,  602,  308,  821,   44,   44,   44,   44,
 /*   230 */    44,   44,   44,  450,  277,  395,  331,  112,  112,  112,
 /*   240 */   112,  291,   85,  576,  623,  634,  635,  636,  714,  715,
 /*   250 */   717,  724,  651,  680,  682,  693,  530,  593,  607,  708,
 /*   260 */   673,  709,  672,  729,  744,  746,  772,  776,   50,  713,
 /*   270 */   784,  790,  795,  817,  823,  828,  656, 1076, 1080, 1023,
 /*   280 */  1084, 1047,  935, 1049, 1060, 1065,  954, 1108, 1071, 1072,
 /*   290 */   960, 1117, 1081, 1118, 1083, 1122, 1054,  982,  984, 1022,
 /*   300 */   989, 1129, 1130, 1082,  997, 1134, 1140, 1061, 1143, 1144,
 /*   310 */  1146, 1147, 1148, 1150, 1151, 1152, 1153, 1155, 1156, 1157,
 /*   320 */  1158, 1044, 1160, 1163, 1164, 1170, 1172, 1173, 1159, 1174,
 /*   330 */  1177, 1178, 1180, 1184, 1185, 1186, 1187, 1188, 1162, 1189,
 /*   340 */  1142, 1195, 1196, 1168, 1171, 1165, 1198, 1209, 1212, 1213,
 /*   350 */  1137, 1145, 1181, 1149, 1200, 1223, 1190, 1191, 1192, 1193,
 /*   360 */  1149, 1206, 1208, 1225, 1204, 1227, 1211, 1215, 1247, 1226,
 /*   370 */  1214, 1250, 1229, 1256, 1235, 1238, 1260, 1131, 1115, 1228,
 /*   380 */  1264, 1124, 1243, 1138, 1154, 1273, 1274, 1166, 1279, 1216,
 /*   390 */  1237, 1161, 1220, 1221, 1102, 1219, 1230, 1222, 1224, 1231,
 /*   400 */  1232, 1234, 1236, 1240, 1202, 1239, 1242, 1110, 1241, 1244,
 /*   410 */  1217, 1120, 1245, 1218, 1246, 1248, 1133, 1291, 1266, 1272,
 /*   420 */  1280, 1281, 1282, 1287, 1315, 1175, 1251, 1257, 1259, 1262,
 /*   430 */  1263, 1265, 1267, 1268, 1201, 1269, 1326, 1296, 1233, 1271,
 /*   440 */  1255, 1261, 1270, 1319, 1275, 1276, 1277, 1305, 1307, 1283,
 /*   450 */  1278, 1308, 1284, 1285, 1311, 1288, 1289, 1312, 1292, 1290,
 /*   460 */  1316, 1293, 1286, 1294, 1295, 1297, 1341, 1299, 1298, 1327,
 /*   470 */  1300, 1301, 1302, 1328, 1149, 1342, 1320, 1322, 1350, 1335,
 /*   480 */  1336, 1337, 1338, 1339, 1340, 1344, 1357, 1345, 1149, 1346,
 /*   490 */  1347, 1348, 1349, 1352, 1354, 1355, 1356, 1395, 1358, 1361,
 /*   500 */  1359, 1398, 1362, 1364, 1399, 1403, 1383, 1385, 1386, 1387,
 /*   510 */  1389, 1391,
};
#define YY_REDUCE_COUNT (215)
#define YY_REDUCE_MIN   (-266)
#define YY_REDUCE_MAX   (1059)
static const short yy_reduce_ofst[] = {
 /*     0 */   227,   -9,   71,  168,  221,  285,  329,  403,   35,  502,
 /*    10 */   558,  606,  550,  660,  669,  703,  739,  747,  773,  212,
 /*    20 */   300,  802,  826,  850,  874,  903,  929,  937,  972,  978,
 /*    30 */  1007, 1013, 1059,  -50,  113,  309,  -10, -222, -218,  -19,
 /*    40 */  -207, -206,  358, -246, -187, -101,  -86,  -59,   -2,   55,
 /*    50 */    80, -217,  -84,  119,  161, -181,  -16,  115,  143,  216,
 /*    60 */   366,  190, -179,  226,  290,  416,  215, -195, -266, -266,
 /*    70 */  -266,   33,  174,   18,  193,   24,  183,  293,  307,  324,
 /*    80 */   365,  373,  393,  404,  427,  429,  430,  433,  437,  438,
 /*    90 */   454,  482,  486,  487, -202,  137,  274,  318,  343,  420,
 /*   100 */   351, -204,  -15,  299,  457, -153,   48,   86,  120,  154,
 /*   110 */   224,  253,  251,  338,  353,  257,  387,  466,  453,  554,
 /*   120 */   508,  483,  483,  483,  545,  484,  501,  575,  535,  583,
 /*   130 */   556,  592,  608,  579,  612,  618,  620,  605,  624,  625,
 /*   140 */   664,  654,  653,  685,  687,  690,  691,  699,  683,  688,
 /*   150 */   689,  692,  694,  695,  696,  701,  702,  704,  705,  698,
 /*   160 */   723,  706,  733,  678,  686,  707,  710,  711,  735,  716,
 /*   170 */   712,  737,  719,  661,  726,  728,  667,  731,  730,  736,
 /*   180 */   674,  720,  721,  732,  483,  756,  740,  741,  722,  718,
 /*   190 */   727,  759,  545,  782,  785,  786,  792,  787,  798,  813,
 /*   200 */   803,  834,  829,  838,  827,  833,  841,  843,  852,  860,
 /*   210 */   857,  818,  851,  858,  862,  877,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*    10 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*    20 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*    30 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*    40 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*    50 */  1204, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*    60 */  1151, 1151, 1151, 1151, 1151, 1151, 1202, 1331, 1151, 1462,
 /*    70 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*    80 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*    90 */  1151, 1151, 1151, 1151, 1151, 1204, 1473, 1473, 1473, 1202,
 /*   100 */  1151, 1151, 1151, 1151, 1151, 1289, 1151, 1151, 1151, 1151,
 /*   110 */  1151, 1151, 1365, 1151, 1151, 1537, 1151, 1242, 1497, 1151,
 /*   120 */  1489, 1465, 1479, 1466, 1151, 1522, 1482, 1151, 1151, 1151,
 /*   130 */  1357, 1151, 1151, 1336, 1333, 1333, 1151, 1151, 1151, 1151,
 /*   140 */  1204, 1151, 1151, 1204, 1204, 1151, 1204, 1151, 1151, 1151,
 /*   150 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   160 */  1151, 1151, 1151, 1151, 1151, 1367, 1151, 1151, 1202, 1151,
 /*   170 */  1151, 1202, 1151, 1504, 1502, 1151, 1504, 1502, 1151, 1151,
 /*   180 */  1516, 1512, 1495, 1493, 1479, 1151, 1151, 1151, 1540, 1528,
 /*   190 */  1524, 1151, 1151, 1502, 1151, 1151, 1502, 1151, 1344, 1151,
 /*   200 */  1151, 1202, 1151, 1202, 1151, 1258, 1151, 1151, 1151, 1202,
 /*   210 */  1151, 1359, 1292, 1292, 1205, 1156, 1151, 1151, 1151, 1151,
 /*   220 */  1151, 1151, 1151, 1151, 1151, 1151, 1427, 1515, 1514, 1426,
 /*   230 */  1439, 1438, 1437, 1151, 1151, 1151, 1151, 1421, 1422, 1420,
 /*   240 */  1419, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   250 */  1151, 1151, 1151, 1151, 1151, 1463, 1151, 1525, 1529, 1151,
 /*   260 */  1151, 1151, 1404, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   270 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   280 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   290 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   300 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   310 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   320 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   330 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   340 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   350 */  1151, 1151, 1151, 1303, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   360 */  1228, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   370 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   380 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   390 */  1151, 1151, 1486, 1496, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   400 */  1151, 1151, 1151, 1151, 1404, 1151, 1513, 1151, 1472, 1468,
 /*   410 */  1151, 1151, 1464, 1151, 1151, 1523, 1151, 1151, 1151, 1151,
 /*   420 */  1151, 1151, 1151, 1151, 1458, 1151, 1151, 1151, 1151, 1151,
 /*   430 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   440 */  1151, 1403, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1286,
 /*   450 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   460 */  1151, 1151, 1271, 1269, 1268, 1267, 1151, 1264, 1151, 1151,
 /*   470 */  1151, 1151, 1151, 1151, 1294, 1151, 1151, 1151, 1151, 1151,
 /*   480 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1214, 1151,
 /*   490 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   500 */  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
 /*   510 */  1151, 1151,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "DATABASE",
  /*   45 */ "USE",
  /*   46 */ "IF",
  /*   47 */ "NOT",
  /*   48 */ "EXISTS",
  /*   49 */ "BLOCKS",
  /*   50 */ "CACHE",
  /*   51 */ "CACHELAST",
  /*   52 */ "COMP",
  /*   53 */ "DAYS",
  /*   54 */ "FSYNC",
  /*   55 */ "MAXROWS",
  /*   56 */ "MINROWS",
  /*   57 */ "KEEP",
  /*   58 */ "PRECISION",
  /*   59 */ "QUORUM",
  /*   60 */ "REPLICA",
  /*   61 */ "TTL",
  /*   62 */ "WAL",
  /*   63 */ "VGROUPS",
  /*   64 */ "SINGLE_STABLE",
  /*   65 */ "STREAM_MODE",
  /*   66 */ "RETENTIONS",
  /*   67 */ "NK_COMMA",
  /*   68 */ "TABLE",
  /*   69 */ "NK_LP",
  /*   70 */ "NK_RP",
  /*   71 */ "STABLE",
  /*   72 */ "ADD",
  /*   73 */ "COLUMN",
  /*   74 */ "MODIFY",
  /*   75 */ "RENAME",
  /*   76 */ "TAG",
  /*   77 */ "SET",
  /*   78 */ "NK_EQ",
  /*   79 */ "USING",
  /*   80 */ "TAGS",
  /*   81 */ "NK_DOT",
  /*   82 */ "COMMENT",
  /*   83 */ "BOOL",
  /*   84 */ "TINYINT",
  /*   85 */ "SMALLINT",
  /*   86 */ "INT",
  /*   87 */ "INTEGER",
  /*   88 */ "BIGINT",
  /*   89 */ "FLOAT",
  /*   90 */ "DOUBLE",
  /*   91 */ "BINARY",
  /*   92 */ "TIMESTAMP",
  /*   93 */ "NCHAR",
  /*   94 */ "UNSIGNED",
  /*   95 */ "JSON",
  /*   96 */ "VARCHAR",
  /*   97 */ "MEDIUMBLOB",
  /*   98 */ "BLOB",
  /*   99 */ "VARBINARY",
  /*  100 */ "DECIMAL",
  /*  101 */ "SMA",
  /*  102 */ "ROLLUP",
  /*  103 */ "FILE_FACTOR",
  /*  104 */ "NK_FLOAT",
  /*  105 */ "DELAY",
  /*  106 */ "SHOW",
  /*  107 */ "DATABASES",
  /*  108 */ "TABLES",
  /*  109 */ "STABLES",
  /*  110 */ "MNODES",
  /*  111 */ "MODULES",
  /*  112 */ "QNODES",
  /*  113 */ "FUNCTIONS",
  /*  114 */ "INDEXES",
  /*  115 */ "FROM",
  /*  116 */ "ACCOUNTS",
  /*  117 */ "APPS",
  /*  118 */ "CONNECTIONS",
  /*  119 */ "LICENCE",
  /*  120 */ "QUERIES",
  /*  121 */ "SCORES",
  /*  122 */ "TOPICS",
  /*  123 */ "VARIABLES",
  /*  124 */ "LIKE",
  /*  125 */ "INDEX",
  /*  126 */ "FULLTEXT",
  /*  127 */ "FUNCTION",
  /*  128 */ "INTERVAL",
  /*  129 */ "TOPIC",
  /*  130 */ "AS",
  /*  131 */ "DESC",
  /*  132 */ "DESCRIBE",
  /*  133 */ "RESET",
  /*  134 */ "QUERY",
  /*  135 */ "EXPLAIN",
  /*  136 */ "ANALYZE",
  /*  137 */ "VERBOSE",
  /*  138 */ "NK_BOOL",
  /*  139 */ "RATIO",
  /*  140 */ "COMPACT",
  /*  141 */ "VNODES",
  /*  142 */ "IN",
  /*  143 */ "OUTPUTTYPE",
  /*  144 */ "AGGREGATE",
  /*  145 */ "BUFSIZE",
  /*  146 */ "STREAM",
  /*  147 */ "INTO",
  /*  148 */ "KILL",
  /*  149 */ "CONNECTION",
  /*  150 */ "MERGE",
  /*  151 */ "VGROUP",
  /*  152 */ "REDISTRIBUTE",
  /*  153 */ "SPLIT",
  /*  154 */ "SYNCDB",
  /*  155 */ "NULL",
  /*  156 */ "NK_VARIABLE",
  /*  157 */ "NK_UNDERLINE",
  /*  158 */ "ROWTS",
  /*  159 */ "TBNAME",
  /*  160 */ "QSTARTTS",
  /*  161 */ "QENDTS",
  /*  162 */ "WSTARTTS",
  /*  163 */ "WENDTS",
  /*  164 */ "WDURATION",
  /*  165 */ "BETWEEN",
  /*  166 */ "IS",
  /*  167 */ "NK_LT",
  /*  168 */ "NK_GT",
  /*  169 */ "NK_LE",
  /*  170 */ "NK_GE",
  /*  171 */ "NK_NE",
  /*  172 */ "MATCH",
  /*  173 */ "NMATCH",
  /*  174 */ "JOIN",
  /*  175 */ "INNER",
  /*  176 */ "SELECT",
  /*  177 */ "DISTINCT",
  /*  178 */ "WHERE",
  /*  179 */ "PARTITION",
  /*  180 */ "BY",
  /*  181 */ "SESSION",
  /*  182 */ "STATE_WINDOW",
  /*  183 */ "SLIDING",
  /*  184 */ "FILL",
  /*  185 */ "VALUE",
  /*  186 */ "NONE",
  /*  187 */ "PREV",
  /*  188 */ "LINEAR",
  /*  189 */ "NEXT",
  /*  190 */ "GROUP",
  /*  191 */ "HAVING",
  /*  192 */ "ORDER",
  /*  193 */ "SLIMIT",
  /*  194 */ "SOFFSET",
  /*  195 */ "LIMIT",
  /*  196 */ "OFFSET",
  /*  197 */ "ASC",
  /*  198 */ "NULLS",
  /*  199 */ "FIRST",
  /*  200 */ "LAST",
  /*  201 */ "cmd",
  /*  202 */ "account_options",
  /*  203 */ "alter_account_options",
  /*  204 */ "literal",
  /*  205 */ "alter_account_option",
  /*  206 */ "user_name",
  /*  207 */ "dnode_endpoint",
  /*  208 */ "dnode_host_name",
  /*  209 */ "not_exists_opt",
  /*  210 */ "db_name",
  /*  211 */ "db_options",
  /*  212 */ "exists_opt",
  /*  213 */ "alter_db_options",
  /*  214 */ "integer_list",
  /*  215 */ "alter_db_option",
  /*  216 */ "full_table_name",
  /*  217 */ "column_def_list",
  /*  218 */ "tags_def_opt",
  /*  219 */ "table_options",
  /*  220 */ "multi_create_clause",
  /*  221 */ "tags_def",
  /*  222 */ "multi_drop_clause",
  /*  223 */ "alter_table_clause",
  /*  224 */ "alter_table_options",
  /*  225 */ "column_name",
  /*  226 */ "type_name",
  /*  227 */ "create_subtable_clause",
  /*  228 */ "specific_tags_opt",
  /*  229 */ "literal_list",
  /*  230 */ "drop_table_clause",
  /*  231 */ "col_name_list",
  /*  232 */ "table_name",
  /*  233 */ "column_def",
  /*  234 */ "func_name_list",
  /*  235 */ "alter_table_option",
  /*  236 */ "col_name",
  /*  237 */ "db_name_cond_opt",
  /*  238 */ "like_pattern_opt",
  /*  239 */ "table_name_cond",
  /*  240 */ "from_db_opt",
  /*  241 */ "func_name",
  /*  242 */ "function_name",
  /*  243 */ "index_name",
  /*  244 */ "index_options",
  /*  245 */ "func_list",
  /*  246 */ "duration_literal",
  /*  247 */ "sliding_opt",
  /*  248 */ "func",
  /*  249 */ "expression_list",
  /*  250 */ "topic_name",
  /*  251 */ "query_expression",
  /*  252 */ "analyze_opt",
  /*  253 */ "explain_options",
  /*  254 */ "agg_func_opt",
  /*  255 */ "bufsize_opt",
  /*  256 */ "stream_name",
  /*  257 */ "dnode_list",
  /*  258 */ "signed",
  /*  259 */ "signed_literal",
  /*  260 */ "table_alias",
  /*  261 */ "column_alias",
  /*  262 */ "expression",
  /*  263 */ "pseudo_column",
  /*  264 */ "column_reference",
  /*  265 */ "subquery",
  /*  266 */ "predicate",
  /*  267 */ "compare_op",
  /*  268 */ "in_op",
  /*  269 */ "in_predicate_value",
  /*  270 */ "boolean_value_expression",
  /*  271 */ "boolean_primary",
  /*  272 */ "common_expression",
  /*  273 */ "from_clause",
  /*  274 */ "table_reference_list",
  /*  275 */ "table_reference",
  /*  276 */ "table_primary",
  /*  277 */ "joined_table",
  /*  278 */ "alias_opt",
  /*  279 */ "parenthesized_joined_table",
  /*  280 */ "join_type",
  /*  281 */ "search_condition",
  /*  282 */ "query_specification",
  /*  283 */ "set_quantifier_opt",
  /*  284 */ "select_list",
  /*  285 */ "where_clause_opt",
  /*  286 */ "partition_by_clause_opt",
  /*  287 */ "twindow_clause_opt",
  /*  288 */ "group_by_clause_opt",
  /*  289 */ "having_clause_opt",
  /*  290 */ "select_sublist",
  /*  291 */ "select_item",
  /*  292 */ "fill_opt",
  /*  293 */ "fill_mode",
  /*  294 */ "group_by_list",
  /*  295 */ "query_expression_body",
  /*  296 */ "order_by_clause_opt",
  /*  297 */ "slimit_clause_opt",
  /*  298 */ "limit_clause_opt",
  /*  299 */ "query_primary",
  /*  300 */ "sort_specification_list",
  /*  301 */ "sort_specification",
  /*  302 */ "ordering_specification_opt",
  /*  303 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  44 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  45 */ "cmd ::= USE db_name",
 /*  46 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  47 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  48 */ "not_exists_opt ::=",
 /*  49 */ "exists_opt ::= IF EXISTS",
 /*  50 */ "exists_opt ::=",
 /*  51 */ "db_options ::=",
 /*  52 */ "db_options ::= db_options BLOCKS NK_INTEGER",
 /*  53 */ "db_options ::= db_options CACHE NK_INTEGER",
 /*  54 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  55 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  56 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  57 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  58 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  59 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  60 */ "db_options ::= db_options KEEP integer_list",
 /*  61 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  62 */ "db_options ::= db_options QUORUM NK_INTEGER",
 /*  63 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  64 */ "db_options ::= db_options TTL NK_INTEGER",
 /*  65 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  66 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  67 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  68 */ "db_options ::= db_options STREAM_MODE NK_INTEGER",
 /*  69 */ "db_options ::= db_options RETENTIONS NK_STRING",
 /*  70 */ "alter_db_options ::= alter_db_option",
 /*  71 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  72 */ "alter_db_option ::= BLOCKS NK_INTEGER",
 /*  73 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  74 */ "alter_db_option ::= KEEP integer_list",
 /*  75 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  76 */ "alter_db_option ::= QUORUM NK_INTEGER",
 /*  77 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  78 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  79 */ "integer_list ::= NK_INTEGER",
 /*  80 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /*  81 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  82 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  83 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /*  84 */ "cmd ::= DROP TABLE multi_drop_clause",
 /*  85 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /*  86 */ "cmd ::= ALTER TABLE alter_table_clause",
 /*  87 */ "cmd ::= ALTER STABLE alter_table_clause",
 /*  88 */ "alter_table_clause ::= full_table_name alter_table_options",
 /*  89 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /*  90 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /*  91 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /*  92 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /*  93 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /*  94 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /*  95 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /*  96 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /*  97 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /*  98 */ "multi_create_clause ::= create_subtable_clause",
 /*  99 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 100 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP",
 /* 101 */ "multi_drop_clause ::= drop_table_clause",
 /* 102 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 103 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 104 */ "specific_tags_opt ::=",
 /* 105 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 106 */ "full_table_name ::= table_name",
 /* 107 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 108 */ "column_def_list ::= column_def",
 /* 109 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 110 */ "column_def ::= column_name type_name",
 /* 111 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 112 */ "type_name ::= BOOL",
 /* 113 */ "type_name ::= TINYINT",
 /* 114 */ "type_name ::= SMALLINT",
 /* 115 */ "type_name ::= INT",
 /* 116 */ "type_name ::= INTEGER",
 /* 117 */ "type_name ::= BIGINT",
 /* 118 */ "type_name ::= FLOAT",
 /* 119 */ "type_name ::= DOUBLE",
 /* 120 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 121 */ "type_name ::= TIMESTAMP",
 /* 122 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 123 */ "type_name ::= TINYINT UNSIGNED",
 /* 124 */ "type_name ::= SMALLINT UNSIGNED",
 /* 125 */ "type_name ::= INT UNSIGNED",
 /* 126 */ "type_name ::= BIGINT UNSIGNED",
 /* 127 */ "type_name ::= JSON",
 /* 128 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 129 */ "type_name ::= MEDIUMBLOB",
 /* 130 */ "type_name ::= BLOB",
 /* 131 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 132 */ "type_name ::= DECIMAL",
 /* 133 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 134 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 135 */ "tags_def_opt ::=",
 /* 136 */ "tags_def_opt ::= tags_def",
 /* 137 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 138 */ "table_options ::=",
 /* 139 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 140 */ "table_options ::= table_options KEEP integer_list",
 /* 141 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 142 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 143 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 144 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 145 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 146 */ "alter_table_options ::= alter_table_option",
 /* 147 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 148 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 149 */ "alter_table_option ::= KEEP integer_list",
 /* 150 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 151 */ "col_name_list ::= col_name",
 /* 152 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 153 */ "col_name ::= column_name",
 /* 154 */ "cmd ::= SHOW DNODES",
 /* 155 */ "cmd ::= SHOW USERS",
 /* 156 */ "cmd ::= SHOW DATABASES",
 /* 157 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 158 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 159 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 160 */ "cmd ::= SHOW MNODES",
 /* 161 */ "cmd ::= SHOW MODULES",
 /* 162 */ "cmd ::= SHOW QNODES",
 /* 163 */ "cmd ::= SHOW FUNCTIONS",
 /* 164 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 165 */ "cmd ::= SHOW STREAMS",
 /* 166 */ "cmd ::= SHOW ACCOUNTS",
 /* 167 */ "cmd ::= SHOW APPS",
 /* 168 */ "cmd ::= SHOW CONNECTIONS",
 /* 169 */ "cmd ::= SHOW LICENCE",
 /* 170 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 171 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 172 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 173 */ "cmd ::= SHOW QUERIES",
 /* 174 */ "cmd ::= SHOW SCORES",
 /* 175 */ "cmd ::= SHOW TOPICS",
 /* 176 */ "cmd ::= SHOW VARIABLES",
 /* 177 */ "db_name_cond_opt ::=",
 /* 178 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 179 */ "like_pattern_opt ::=",
 /* 180 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 181 */ "table_name_cond ::= table_name",
 /* 182 */ "from_db_opt ::=",
 /* 183 */ "from_db_opt ::= FROM db_name",
 /* 184 */ "func_name_list ::= func_name",
 /* 185 */ "func_name_list ::= func_name_list NK_COMMA col_name",
 /* 186 */ "func_name ::= function_name",
 /* 187 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 188 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 189 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 190 */ "index_options ::=",
 /* 191 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 192 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 193 */ "func_list ::= func",
 /* 194 */ "func_list ::= func_list NK_COMMA func",
 /* 195 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 196 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 197 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name",
 /* 198 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 199 */ "cmd ::= DESC full_table_name",
 /* 200 */ "cmd ::= DESCRIBE full_table_name",
 /* 201 */ "cmd ::= RESET QUERY CACHE",
 /* 202 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 203 */ "analyze_opt ::=",
 /* 204 */ "analyze_opt ::= ANALYZE",
 /* 205 */ "explain_options ::=",
 /* 206 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 207 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 208 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 209 */ "cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 210 */ "cmd ::= DROP FUNCTION function_name",
 /* 211 */ "agg_func_opt ::=",
 /* 212 */ "agg_func_opt ::= AGGREGATE",
 /* 213 */ "bufsize_opt ::=",
 /* 214 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 215 */ "cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression",
 /* 216 */ "cmd ::= DROP STREAM stream_name",
 /* 217 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 218 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 219 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 220 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 221 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 222 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 223 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 224 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 225 */ "cmd ::= query_expression",
 /* 226 */ "literal ::= NK_INTEGER",
 /* 227 */ "literal ::= NK_FLOAT",
 /* 228 */ "literal ::= NK_STRING",
 /* 229 */ "literal ::= NK_BOOL",
 /* 230 */ "literal ::= TIMESTAMP NK_STRING",
 /* 231 */ "literal ::= duration_literal",
 /* 232 */ "literal ::= NULL",
 /* 233 */ "duration_literal ::= NK_VARIABLE",
 /* 234 */ "signed ::= NK_INTEGER",
 /* 235 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 236 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 237 */ "signed ::= NK_FLOAT",
 /* 238 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 239 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 240 */ "signed_literal ::= signed",
 /* 241 */ "signed_literal ::= NK_STRING",
 /* 242 */ "signed_literal ::= NK_BOOL",
 /* 243 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 244 */ "signed_literal ::= duration_literal",
 /* 245 */ "signed_literal ::= NULL",
 /* 246 */ "literal_list ::= signed_literal",
 /* 247 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 248 */ "db_name ::= NK_ID",
 /* 249 */ "table_name ::= NK_ID",
 /* 250 */ "column_name ::= NK_ID",
 /* 251 */ "function_name ::= NK_ID",
 /* 252 */ "table_alias ::= NK_ID",
 /* 253 */ "column_alias ::= NK_ID",
 /* 254 */ "user_name ::= NK_ID",
 /* 255 */ "index_name ::= NK_ID",
 /* 256 */ "topic_name ::= NK_ID",
 /* 257 */ "stream_name ::= NK_ID",
 /* 258 */ "expression ::= literal",
 /* 259 */ "expression ::= pseudo_column",
 /* 260 */ "expression ::= column_reference",
 /* 261 */ "expression ::= function_name NK_LP expression_list NK_RP",
 /* 262 */ "expression ::= function_name NK_LP NK_STAR NK_RP",
 /* 263 */ "expression ::= subquery",
 /* 264 */ "expression ::= NK_LP expression NK_RP",
 /* 265 */ "expression ::= NK_PLUS expression",
 /* 266 */ "expression ::= NK_MINUS expression",
 /* 267 */ "expression ::= expression NK_PLUS expression",
 /* 268 */ "expression ::= expression NK_MINUS expression",
 /* 269 */ "expression ::= expression NK_STAR expression",
 /* 270 */ "expression ::= expression NK_SLASH expression",
 /* 271 */ "expression ::= expression NK_REM expression",
 /* 272 */ "expression_list ::= expression",
 /* 273 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 274 */ "column_reference ::= column_name",
 /* 275 */ "column_reference ::= table_name NK_DOT column_name",
 /* 276 */ "pseudo_column ::= NK_UNDERLINE ROWTS",
 /* 277 */ "pseudo_column ::= TBNAME",
 /* 278 */ "pseudo_column ::= NK_UNDERLINE QSTARTTS",
 /* 279 */ "pseudo_column ::= NK_UNDERLINE QENDTS",
 /* 280 */ "pseudo_column ::= NK_UNDERLINE WSTARTTS",
 /* 281 */ "pseudo_column ::= NK_UNDERLINE WENDTS",
 /* 282 */ "pseudo_column ::= NK_UNDERLINE WDURATION",
 /* 283 */ "predicate ::= expression compare_op expression",
 /* 284 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 285 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 286 */ "predicate ::= expression IS NULL",
 /* 287 */ "predicate ::= expression IS NOT NULL",
 /* 288 */ "predicate ::= expression in_op in_predicate_value",
 /* 289 */ "compare_op ::= NK_LT",
 /* 290 */ "compare_op ::= NK_GT",
 /* 291 */ "compare_op ::= NK_LE",
 /* 292 */ "compare_op ::= NK_GE",
 /* 293 */ "compare_op ::= NK_NE",
 /* 294 */ "compare_op ::= NK_EQ",
 /* 295 */ "compare_op ::= LIKE",
 /* 296 */ "compare_op ::= NOT LIKE",
 /* 297 */ "compare_op ::= MATCH",
 /* 298 */ "compare_op ::= NMATCH",
 /* 299 */ "in_op ::= IN",
 /* 300 */ "in_op ::= NOT IN",
 /* 301 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 302 */ "boolean_value_expression ::= boolean_primary",
 /* 303 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 304 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 305 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 306 */ "boolean_primary ::= predicate",
 /* 307 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 308 */ "common_expression ::= expression",
 /* 309 */ "common_expression ::= boolean_value_expression",
 /* 310 */ "from_clause ::= FROM table_reference_list",
 /* 311 */ "table_reference_list ::= table_reference",
 /* 312 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 313 */ "table_reference ::= table_primary",
 /* 314 */ "table_reference ::= joined_table",
 /* 315 */ "table_primary ::= table_name alias_opt",
 /* 316 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 317 */ "table_primary ::= subquery alias_opt",
 /* 318 */ "table_primary ::= parenthesized_joined_table",
 /* 319 */ "alias_opt ::=",
 /* 320 */ "alias_opt ::= table_alias",
 /* 321 */ "alias_opt ::= AS table_alias",
 /* 322 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 323 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 324 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 325 */ "join_type ::=",
 /* 326 */ "join_type ::= INNER",
 /* 327 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 328 */ "set_quantifier_opt ::=",
 /* 329 */ "set_quantifier_opt ::= DISTINCT",
 /* 330 */ "set_quantifier_opt ::= ALL",
 /* 331 */ "select_list ::= NK_STAR",
 /* 332 */ "select_list ::= select_sublist",
 /* 333 */ "select_sublist ::= select_item",
 /* 334 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 335 */ "select_item ::= common_expression",
 /* 336 */ "select_item ::= common_expression column_alias",
 /* 337 */ "select_item ::= common_expression AS column_alias",
 /* 338 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 339 */ "where_clause_opt ::=",
 /* 340 */ "where_clause_opt ::= WHERE search_condition",
 /* 341 */ "partition_by_clause_opt ::=",
 /* 342 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 343 */ "twindow_clause_opt ::=",
 /* 344 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 345 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP",
 /* 346 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 347 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 348 */ "sliding_opt ::=",
 /* 349 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 350 */ "fill_opt ::=",
 /* 351 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 352 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 353 */ "fill_mode ::= NONE",
 /* 354 */ "fill_mode ::= PREV",
 /* 355 */ "fill_mode ::= NULL",
 /* 356 */ "fill_mode ::= LINEAR",
 /* 357 */ "fill_mode ::= NEXT",
 /* 358 */ "group_by_clause_opt ::=",
 /* 359 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 360 */ "group_by_list ::= expression",
 /* 361 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 362 */ "having_clause_opt ::=",
 /* 363 */ "having_clause_opt ::= HAVING search_condition",
 /* 364 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 365 */ "query_expression_body ::= query_primary",
 /* 366 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 367 */ "query_primary ::= query_specification",
 /* 368 */ "order_by_clause_opt ::=",
 /* 369 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 370 */ "slimit_clause_opt ::=",
 /* 371 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 372 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 373 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 374 */ "limit_clause_opt ::=",
 /* 375 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 376 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 377 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 378 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 379 */ "search_condition ::= common_expression",
 /* 380 */ "sort_specification_list ::= sort_specification",
 /* 381 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 382 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 383 */ "ordering_specification_opt ::=",
 /* 384 */ "ordering_specification_opt ::= ASC",
 /* 385 */ "ordering_specification_opt ::= DESC",
 /* 386 */ "null_ordering_opt ::=",
 /* 387 */ "null_ordering_opt ::= NULLS FIRST",
 /* 388 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 201: /* cmd */
    case 204: /* literal */
    case 211: /* db_options */
    case 213: /* alter_db_options */
    case 216: /* full_table_name */
    case 219: /* table_options */
    case 223: /* alter_table_clause */
    case 224: /* alter_table_options */
    case 227: /* create_subtable_clause */
    case 230: /* drop_table_clause */
    case 233: /* column_def */
    case 236: /* col_name */
    case 237: /* db_name_cond_opt */
    case 238: /* like_pattern_opt */
    case 239: /* table_name_cond */
    case 240: /* from_db_opt */
    case 241: /* func_name */
    case 244: /* index_options */
    case 246: /* duration_literal */
    case 247: /* sliding_opt */
    case 248: /* func */
    case 251: /* query_expression */
    case 253: /* explain_options */
    case 258: /* signed */
    case 259: /* signed_literal */
    case 262: /* expression */
    case 263: /* pseudo_column */
    case 264: /* column_reference */
    case 265: /* subquery */
    case 266: /* predicate */
    case 269: /* in_predicate_value */
    case 270: /* boolean_value_expression */
    case 271: /* boolean_primary */
    case 272: /* common_expression */
    case 273: /* from_clause */
    case 274: /* table_reference_list */
    case 275: /* table_reference */
    case 276: /* table_primary */
    case 277: /* joined_table */
    case 279: /* parenthesized_joined_table */
    case 281: /* search_condition */
    case 282: /* query_specification */
    case 285: /* where_clause_opt */
    case 287: /* twindow_clause_opt */
    case 289: /* having_clause_opt */
    case 291: /* select_item */
    case 292: /* fill_opt */
    case 295: /* query_expression_body */
    case 297: /* slimit_clause_opt */
    case 298: /* limit_clause_opt */
    case 299: /* query_primary */
    case 301: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy104)); 
}
      break;
    case 202: /* account_options */
    case 203: /* alter_account_options */
    case 205: /* alter_account_option */
    case 255: /* bufsize_opt */
{
 
}
      break;
    case 206: /* user_name */
    case 207: /* dnode_endpoint */
    case 208: /* dnode_host_name */
    case 210: /* db_name */
    case 225: /* column_name */
    case 232: /* table_name */
    case 242: /* function_name */
    case 243: /* index_name */
    case 250: /* topic_name */
    case 256: /* stream_name */
    case 260: /* table_alias */
    case 261: /* column_alias */
    case 278: /* alias_opt */
{
 
}
      break;
    case 209: /* not_exists_opt */
    case 212: /* exists_opt */
    case 252: /* analyze_opt */
    case 254: /* agg_func_opt */
    case 283: /* set_quantifier_opt */
{
 
}
      break;
    case 214: /* integer_list */
    case 217: /* column_def_list */
    case 218: /* tags_def_opt */
    case 220: /* multi_create_clause */
    case 221: /* tags_def */
    case 222: /* multi_drop_clause */
    case 228: /* specific_tags_opt */
    case 229: /* literal_list */
    case 231: /* col_name_list */
    case 234: /* func_name_list */
    case 245: /* func_list */
    case 249: /* expression_list */
    case 257: /* dnode_list */
    case 284: /* select_list */
    case 286: /* partition_by_clause_opt */
    case 288: /* group_by_clause_opt */
    case 290: /* select_sublist */
    case 294: /* group_by_list */
    case 296: /* order_by_clause_opt */
    case 300: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy312)); 
}
      break;
    case 215: /* alter_db_option */
    case 235: /* alter_table_option */
{
 
}
      break;
    case 226: /* type_name */
{
 
}
      break;
    case 267: /* compare_op */
    case 268: /* in_op */
{
 
}
      break;
    case 280: /* join_type */
{
 
}
      break;
    case 293: /* fill_mode */
{
 
}
      break;
    case 302: /* ordering_specification_opt */
{
 
}
      break;
    case 303: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  201,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  201,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  202,    0 }, /* (2) account_options ::= */
  {  202,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  202,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  202,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  202,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  202,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  202,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  202,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  202,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  202,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  203,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  203,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  205,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  205,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  205,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  205,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  205,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  205,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  205,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  205,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  205,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  205,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  201,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  201,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  201,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  201,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  201,   -3 }, /* (28) cmd ::= CREATE DNODE dnode_endpoint */
  {  201,   -5 }, /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  201,   -3 }, /* (30) cmd ::= DROP DNODE NK_INTEGER */
  {  201,   -3 }, /* (31) cmd ::= DROP DNODE dnode_endpoint */
  {  201,   -4 }, /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  201,   -5 }, /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  201,   -4 }, /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
  {  201,   -5 }, /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  207,   -1 }, /* (36) dnode_endpoint ::= NK_STRING */
  {  208,   -1 }, /* (37) dnode_host_name ::= NK_ID */
  {  208,   -1 }, /* (38) dnode_host_name ::= NK_IPTOKEN */
  {  201,   -3 }, /* (39) cmd ::= ALTER LOCAL NK_STRING */
  {  201,   -4 }, /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  201,   -5 }, /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  201,   -5 }, /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  201,   -5 }, /* (43) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  201,   -4 }, /* (44) cmd ::= DROP DATABASE exists_opt db_name */
  {  201,   -2 }, /* (45) cmd ::= USE db_name */
  {  201,   -4 }, /* (46) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  209,   -3 }, /* (47) not_exists_opt ::= IF NOT EXISTS */
  {  209,    0 }, /* (48) not_exists_opt ::= */
  {  212,   -2 }, /* (49) exists_opt ::= IF EXISTS */
  {  212,    0 }, /* (50) exists_opt ::= */
  {  211,    0 }, /* (51) db_options ::= */
  {  211,   -3 }, /* (52) db_options ::= db_options BLOCKS NK_INTEGER */
  {  211,   -3 }, /* (53) db_options ::= db_options CACHE NK_INTEGER */
  {  211,   -3 }, /* (54) db_options ::= db_options CACHELAST NK_INTEGER */
  {  211,   -3 }, /* (55) db_options ::= db_options COMP NK_INTEGER */
  {  211,   -3 }, /* (56) db_options ::= db_options DAYS NK_INTEGER */
  {  211,   -3 }, /* (57) db_options ::= db_options FSYNC NK_INTEGER */
  {  211,   -3 }, /* (58) db_options ::= db_options MAXROWS NK_INTEGER */
  {  211,   -3 }, /* (59) db_options ::= db_options MINROWS NK_INTEGER */
  {  211,   -3 }, /* (60) db_options ::= db_options KEEP integer_list */
  {  211,   -3 }, /* (61) db_options ::= db_options PRECISION NK_STRING */
  {  211,   -3 }, /* (62) db_options ::= db_options QUORUM NK_INTEGER */
  {  211,   -3 }, /* (63) db_options ::= db_options REPLICA NK_INTEGER */
  {  211,   -3 }, /* (64) db_options ::= db_options TTL NK_INTEGER */
  {  211,   -3 }, /* (65) db_options ::= db_options WAL NK_INTEGER */
  {  211,   -3 }, /* (66) db_options ::= db_options VGROUPS NK_INTEGER */
  {  211,   -3 }, /* (67) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  211,   -3 }, /* (68) db_options ::= db_options STREAM_MODE NK_INTEGER */
  {  211,   -3 }, /* (69) db_options ::= db_options RETENTIONS NK_STRING */
  {  213,   -1 }, /* (70) alter_db_options ::= alter_db_option */
  {  213,   -2 }, /* (71) alter_db_options ::= alter_db_options alter_db_option */
  {  215,   -2 }, /* (72) alter_db_option ::= BLOCKS NK_INTEGER */
  {  215,   -2 }, /* (73) alter_db_option ::= FSYNC NK_INTEGER */
  {  215,   -2 }, /* (74) alter_db_option ::= KEEP integer_list */
  {  215,   -2 }, /* (75) alter_db_option ::= WAL NK_INTEGER */
  {  215,   -2 }, /* (76) alter_db_option ::= QUORUM NK_INTEGER */
  {  215,   -2 }, /* (77) alter_db_option ::= CACHELAST NK_INTEGER */
  {  215,   -2 }, /* (78) alter_db_option ::= REPLICA NK_INTEGER */
  {  214,   -1 }, /* (79) integer_list ::= NK_INTEGER */
  {  214,   -3 }, /* (80) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  201,   -9 }, /* (81) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  201,   -3 }, /* (82) cmd ::= CREATE TABLE multi_create_clause */
  {  201,   -9 }, /* (83) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  201,   -3 }, /* (84) cmd ::= DROP TABLE multi_drop_clause */
  {  201,   -4 }, /* (85) cmd ::= DROP STABLE exists_opt full_table_name */
  {  201,   -3 }, /* (86) cmd ::= ALTER TABLE alter_table_clause */
  {  201,   -3 }, /* (87) cmd ::= ALTER STABLE alter_table_clause */
  {  223,   -2 }, /* (88) alter_table_clause ::= full_table_name alter_table_options */
  {  223,   -5 }, /* (89) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  223,   -4 }, /* (90) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  223,   -5 }, /* (91) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  223,   -5 }, /* (92) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  223,   -5 }, /* (93) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  223,   -4 }, /* (94) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  223,   -5 }, /* (95) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  223,   -5 }, /* (96) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  223,   -6 }, /* (97) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
  {  220,   -1 }, /* (98) multi_create_clause ::= create_subtable_clause */
  {  220,   -2 }, /* (99) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  227,   -9 }, /* (100) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
  {  222,   -1 }, /* (101) multi_drop_clause ::= drop_table_clause */
  {  222,   -2 }, /* (102) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  230,   -2 }, /* (103) drop_table_clause ::= exists_opt full_table_name */
  {  228,    0 }, /* (104) specific_tags_opt ::= */
  {  228,   -3 }, /* (105) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  216,   -1 }, /* (106) full_table_name ::= table_name */
  {  216,   -3 }, /* (107) full_table_name ::= db_name NK_DOT table_name */
  {  217,   -1 }, /* (108) column_def_list ::= column_def */
  {  217,   -3 }, /* (109) column_def_list ::= column_def_list NK_COMMA column_def */
  {  233,   -2 }, /* (110) column_def ::= column_name type_name */
  {  233,   -4 }, /* (111) column_def ::= column_name type_name COMMENT NK_STRING */
  {  226,   -1 }, /* (112) type_name ::= BOOL */
  {  226,   -1 }, /* (113) type_name ::= TINYINT */
  {  226,   -1 }, /* (114) type_name ::= SMALLINT */
  {  226,   -1 }, /* (115) type_name ::= INT */
  {  226,   -1 }, /* (116) type_name ::= INTEGER */
  {  226,   -1 }, /* (117) type_name ::= BIGINT */
  {  226,   -1 }, /* (118) type_name ::= FLOAT */
  {  226,   -1 }, /* (119) type_name ::= DOUBLE */
  {  226,   -4 }, /* (120) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  226,   -1 }, /* (121) type_name ::= TIMESTAMP */
  {  226,   -4 }, /* (122) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  226,   -2 }, /* (123) type_name ::= TINYINT UNSIGNED */
  {  226,   -2 }, /* (124) type_name ::= SMALLINT UNSIGNED */
  {  226,   -2 }, /* (125) type_name ::= INT UNSIGNED */
  {  226,   -2 }, /* (126) type_name ::= BIGINT UNSIGNED */
  {  226,   -1 }, /* (127) type_name ::= JSON */
  {  226,   -4 }, /* (128) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  226,   -1 }, /* (129) type_name ::= MEDIUMBLOB */
  {  226,   -1 }, /* (130) type_name ::= BLOB */
  {  226,   -4 }, /* (131) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  226,   -1 }, /* (132) type_name ::= DECIMAL */
  {  226,   -4 }, /* (133) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  226,   -6 }, /* (134) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  218,    0 }, /* (135) tags_def_opt ::= */
  {  218,   -1 }, /* (136) tags_def_opt ::= tags_def */
  {  221,   -4 }, /* (137) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  219,    0 }, /* (138) table_options ::= */
  {  219,   -3 }, /* (139) table_options ::= table_options COMMENT NK_STRING */
  {  219,   -3 }, /* (140) table_options ::= table_options KEEP integer_list */
  {  219,   -3 }, /* (141) table_options ::= table_options TTL NK_INTEGER */
  {  219,   -5 }, /* (142) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  219,   -5 }, /* (143) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  219,   -3 }, /* (144) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  219,   -3 }, /* (145) table_options ::= table_options DELAY NK_INTEGER */
  {  224,   -1 }, /* (146) alter_table_options ::= alter_table_option */
  {  224,   -2 }, /* (147) alter_table_options ::= alter_table_options alter_table_option */
  {  235,   -2 }, /* (148) alter_table_option ::= COMMENT NK_STRING */
  {  235,   -2 }, /* (149) alter_table_option ::= KEEP integer_list */
  {  235,   -2 }, /* (150) alter_table_option ::= TTL NK_INTEGER */
  {  231,   -1 }, /* (151) col_name_list ::= col_name */
  {  231,   -3 }, /* (152) col_name_list ::= col_name_list NK_COMMA col_name */
  {  236,   -1 }, /* (153) col_name ::= column_name */
  {  201,   -2 }, /* (154) cmd ::= SHOW DNODES */
  {  201,   -2 }, /* (155) cmd ::= SHOW USERS */
  {  201,   -2 }, /* (156) cmd ::= SHOW DATABASES */
  {  201,   -4 }, /* (157) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  201,   -4 }, /* (158) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  201,   -3 }, /* (159) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  201,   -2 }, /* (160) cmd ::= SHOW MNODES */
  {  201,   -2 }, /* (161) cmd ::= SHOW MODULES */
  {  201,   -2 }, /* (162) cmd ::= SHOW QNODES */
  {  201,   -2 }, /* (163) cmd ::= SHOW FUNCTIONS */
  {  201,   -5 }, /* (164) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  201,   -2 }, /* (165) cmd ::= SHOW STREAMS */
  {  201,   -2 }, /* (166) cmd ::= SHOW ACCOUNTS */
  {  201,   -2 }, /* (167) cmd ::= SHOW APPS */
  {  201,   -2 }, /* (168) cmd ::= SHOW CONNECTIONS */
  {  201,   -2 }, /* (169) cmd ::= SHOW LICENCE */
  {  201,   -4 }, /* (170) cmd ::= SHOW CREATE DATABASE db_name */
  {  201,   -4 }, /* (171) cmd ::= SHOW CREATE TABLE full_table_name */
  {  201,   -4 }, /* (172) cmd ::= SHOW CREATE STABLE full_table_name */
  {  201,   -2 }, /* (173) cmd ::= SHOW QUERIES */
  {  201,   -2 }, /* (174) cmd ::= SHOW SCORES */
  {  201,   -2 }, /* (175) cmd ::= SHOW TOPICS */
  {  201,   -2 }, /* (176) cmd ::= SHOW VARIABLES */
  {  237,    0 }, /* (177) db_name_cond_opt ::= */
  {  237,   -2 }, /* (178) db_name_cond_opt ::= db_name NK_DOT */
  {  238,    0 }, /* (179) like_pattern_opt ::= */
  {  238,   -2 }, /* (180) like_pattern_opt ::= LIKE NK_STRING */
  {  239,   -1 }, /* (181) table_name_cond ::= table_name */
  {  240,    0 }, /* (182) from_db_opt ::= */
  {  240,   -2 }, /* (183) from_db_opt ::= FROM db_name */
  {  234,   -1 }, /* (184) func_name_list ::= func_name */
  {  234,   -3 }, /* (185) func_name_list ::= func_name_list NK_COMMA col_name */
  {  241,   -1 }, /* (186) func_name ::= function_name */
  {  201,   -8 }, /* (187) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  201,  -10 }, /* (188) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  201,   -6 }, /* (189) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  244,    0 }, /* (190) index_options ::= */
  {  244,   -9 }, /* (191) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  244,  -11 }, /* (192) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  245,   -1 }, /* (193) func_list ::= func */
  {  245,   -3 }, /* (194) func_list ::= func_list NK_COMMA func */
  {  248,   -4 }, /* (195) func ::= function_name NK_LP expression_list NK_RP */
  {  201,   -6 }, /* (196) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  201,   -6 }, /* (197) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
  {  201,   -4 }, /* (198) cmd ::= DROP TOPIC exists_opt topic_name */
  {  201,   -2 }, /* (199) cmd ::= DESC full_table_name */
  {  201,   -2 }, /* (200) cmd ::= DESCRIBE full_table_name */
  {  201,   -3 }, /* (201) cmd ::= RESET QUERY CACHE */
  {  201,   -4 }, /* (202) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  252,    0 }, /* (203) analyze_opt ::= */
  {  252,   -1 }, /* (204) analyze_opt ::= ANALYZE */
  {  253,    0 }, /* (205) explain_options ::= */
  {  253,   -3 }, /* (206) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  253,   -3 }, /* (207) explain_options ::= explain_options RATIO NK_FLOAT */
  {  201,   -6 }, /* (208) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  201,   -9 }, /* (209) cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  201,   -3 }, /* (210) cmd ::= DROP FUNCTION function_name */
  {  254,    0 }, /* (211) agg_func_opt ::= */
  {  254,   -1 }, /* (212) agg_func_opt ::= AGGREGATE */
  {  255,    0 }, /* (213) bufsize_opt ::= */
  {  255,   -2 }, /* (214) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  201,   -7 }, /* (215) cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression */
  {  201,   -3 }, /* (216) cmd ::= DROP STREAM stream_name */
  {  201,   -3 }, /* (217) cmd ::= KILL CONNECTION NK_INTEGER */
  {  201,   -3 }, /* (218) cmd ::= KILL QUERY NK_INTEGER */
  {  201,   -4 }, /* (219) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  201,   -4 }, /* (220) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  201,   -3 }, /* (221) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  257,   -2 }, /* (222) dnode_list ::= DNODE NK_INTEGER */
  {  257,   -3 }, /* (223) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  201,   -3 }, /* (224) cmd ::= SYNCDB db_name REPLICA */
  {  201,   -1 }, /* (225) cmd ::= query_expression */
  {  204,   -1 }, /* (226) literal ::= NK_INTEGER */
  {  204,   -1 }, /* (227) literal ::= NK_FLOAT */
  {  204,   -1 }, /* (228) literal ::= NK_STRING */
  {  204,   -1 }, /* (229) literal ::= NK_BOOL */
  {  204,   -2 }, /* (230) literal ::= TIMESTAMP NK_STRING */
  {  204,   -1 }, /* (231) literal ::= duration_literal */
  {  204,   -1 }, /* (232) literal ::= NULL */
  {  246,   -1 }, /* (233) duration_literal ::= NK_VARIABLE */
  {  258,   -1 }, /* (234) signed ::= NK_INTEGER */
  {  258,   -2 }, /* (235) signed ::= NK_PLUS NK_INTEGER */
  {  258,   -2 }, /* (236) signed ::= NK_MINUS NK_INTEGER */
  {  258,   -1 }, /* (237) signed ::= NK_FLOAT */
  {  258,   -2 }, /* (238) signed ::= NK_PLUS NK_FLOAT */
  {  258,   -2 }, /* (239) signed ::= NK_MINUS NK_FLOAT */
  {  259,   -1 }, /* (240) signed_literal ::= signed */
  {  259,   -1 }, /* (241) signed_literal ::= NK_STRING */
  {  259,   -1 }, /* (242) signed_literal ::= NK_BOOL */
  {  259,   -2 }, /* (243) signed_literal ::= TIMESTAMP NK_STRING */
  {  259,   -1 }, /* (244) signed_literal ::= duration_literal */
  {  259,   -1 }, /* (245) signed_literal ::= NULL */
  {  229,   -1 }, /* (246) literal_list ::= signed_literal */
  {  229,   -3 }, /* (247) literal_list ::= literal_list NK_COMMA signed_literal */
  {  210,   -1 }, /* (248) db_name ::= NK_ID */
  {  232,   -1 }, /* (249) table_name ::= NK_ID */
  {  225,   -1 }, /* (250) column_name ::= NK_ID */
  {  242,   -1 }, /* (251) function_name ::= NK_ID */
  {  260,   -1 }, /* (252) table_alias ::= NK_ID */
  {  261,   -1 }, /* (253) column_alias ::= NK_ID */
  {  206,   -1 }, /* (254) user_name ::= NK_ID */
  {  243,   -1 }, /* (255) index_name ::= NK_ID */
  {  250,   -1 }, /* (256) topic_name ::= NK_ID */
  {  256,   -1 }, /* (257) stream_name ::= NK_ID */
  {  262,   -1 }, /* (258) expression ::= literal */
  {  262,   -1 }, /* (259) expression ::= pseudo_column */
  {  262,   -1 }, /* (260) expression ::= column_reference */
  {  262,   -4 }, /* (261) expression ::= function_name NK_LP expression_list NK_RP */
  {  262,   -4 }, /* (262) expression ::= function_name NK_LP NK_STAR NK_RP */
  {  262,   -1 }, /* (263) expression ::= subquery */
  {  262,   -3 }, /* (264) expression ::= NK_LP expression NK_RP */
  {  262,   -2 }, /* (265) expression ::= NK_PLUS expression */
  {  262,   -2 }, /* (266) expression ::= NK_MINUS expression */
  {  262,   -3 }, /* (267) expression ::= expression NK_PLUS expression */
  {  262,   -3 }, /* (268) expression ::= expression NK_MINUS expression */
  {  262,   -3 }, /* (269) expression ::= expression NK_STAR expression */
  {  262,   -3 }, /* (270) expression ::= expression NK_SLASH expression */
  {  262,   -3 }, /* (271) expression ::= expression NK_REM expression */
  {  249,   -1 }, /* (272) expression_list ::= expression */
  {  249,   -3 }, /* (273) expression_list ::= expression_list NK_COMMA expression */
  {  264,   -1 }, /* (274) column_reference ::= column_name */
  {  264,   -3 }, /* (275) column_reference ::= table_name NK_DOT column_name */
  {  263,   -2 }, /* (276) pseudo_column ::= NK_UNDERLINE ROWTS */
  {  263,   -1 }, /* (277) pseudo_column ::= TBNAME */
  {  263,   -2 }, /* (278) pseudo_column ::= NK_UNDERLINE QSTARTTS */
  {  263,   -2 }, /* (279) pseudo_column ::= NK_UNDERLINE QENDTS */
  {  263,   -2 }, /* (280) pseudo_column ::= NK_UNDERLINE WSTARTTS */
  {  263,   -2 }, /* (281) pseudo_column ::= NK_UNDERLINE WENDTS */
  {  263,   -2 }, /* (282) pseudo_column ::= NK_UNDERLINE WDURATION */
  {  266,   -3 }, /* (283) predicate ::= expression compare_op expression */
  {  266,   -5 }, /* (284) predicate ::= expression BETWEEN expression AND expression */
  {  266,   -6 }, /* (285) predicate ::= expression NOT BETWEEN expression AND expression */
  {  266,   -3 }, /* (286) predicate ::= expression IS NULL */
  {  266,   -4 }, /* (287) predicate ::= expression IS NOT NULL */
  {  266,   -3 }, /* (288) predicate ::= expression in_op in_predicate_value */
  {  267,   -1 }, /* (289) compare_op ::= NK_LT */
  {  267,   -1 }, /* (290) compare_op ::= NK_GT */
  {  267,   -1 }, /* (291) compare_op ::= NK_LE */
  {  267,   -1 }, /* (292) compare_op ::= NK_GE */
  {  267,   -1 }, /* (293) compare_op ::= NK_NE */
  {  267,   -1 }, /* (294) compare_op ::= NK_EQ */
  {  267,   -1 }, /* (295) compare_op ::= LIKE */
  {  267,   -2 }, /* (296) compare_op ::= NOT LIKE */
  {  267,   -1 }, /* (297) compare_op ::= MATCH */
  {  267,   -1 }, /* (298) compare_op ::= NMATCH */
  {  268,   -1 }, /* (299) in_op ::= IN */
  {  268,   -2 }, /* (300) in_op ::= NOT IN */
  {  269,   -3 }, /* (301) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  270,   -1 }, /* (302) boolean_value_expression ::= boolean_primary */
  {  270,   -2 }, /* (303) boolean_value_expression ::= NOT boolean_primary */
  {  270,   -3 }, /* (304) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  270,   -3 }, /* (305) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  271,   -1 }, /* (306) boolean_primary ::= predicate */
  {  271,   -3 }, /* (307) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  272,   -1 }, /* (308) common_expression ::= expression */
  {  272,   -1 }, /* (309) common_expression ::= boolean_value_expression */
  {  273,   -2 }, /* (310) from_clause ::= FROM table_reference_list */
  {  274,   -1 }, /* (311) table_reference_list ::= table_reference */
  {  274,   -3 }, /* (312) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  275,   -1 }, /* (313) table_reference ::= table_primary */
  {  275,   -1 }, /* (314) table_reference ::= joined_table */
  {  276,   -2 }, /* (315) table_primary ::= table_name alias_opt */
  {  276,   -4 }, /* (316) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  276,   -2 }, /* (317) table_primary ::= subquery alias_opt */
  {  276,   -1 }, /* (318) table_primary ::= parenthesized_joined_table */
  {  278,    0 }, /* (319) alias_opt ::= */
  {  278,   -1 }, /* (320) alias_opt ::= table_alias */
  {  278,   -2 }, /* (321) alias_opt ::= AS table_alias */
  {  279,   -3 }, /* (322) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  279,   -3 }, /* (323) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  277,   -6 }, /* (324) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  280,    0 }, /* (325) join_type ::= */
  {  280,   -1 }, /* (326) join_type ::= INNER */
  {  282,   -9 }, /* (327) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  283,    0 }, /* (328) set_quantifier_opt ::= */
  {  283,   -1 }, /* (329) set_quantifier_opt ::= DISTINCT */
  {  283,   -1 }, /* (330) set_quantifier_opt ::= ALL */
  {  284,   -1 }, /* (331) select_list ::= NK_STAR */
  {  284,   -1 }, /* (332) select_list ::= select_sublist */
  {  290,   -1 }, /* (333) select_sublist ::= select_item */
  {  290,   -3 }, /* (334) select_sublist ::= select_sublist NK_COMMA select_item */
  {  291,   -1 }, /* (335) select_item ::= common_expression */
  {  291,   -2 }, /* (336) select_item ::= common_expression column_alias */
  {  291,   -3 }, /* (337) select_item ::= common_expression AS column_alias */
  {  291,   -3 }, /* (338) select_item ::= table_name NK_DOT NK_STAR */
  {  285,    0 }, /* (339) where_clause_opt ::= */
  {  285,   -2 }, /* (340) where_clause_opt ::= WHERE search_condition */
  {  286,    0 }, /* (341) partition_by_clause_opt ::= */
  {  286,   -3 }, /* (342) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  287,    0 }, /* (343) twindow_clause_opt ::= */
  {  287,   -6 }, /* (344) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  287,   -4 }, /* (345) twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP */
  {  287,   -6 }, /* (346) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  287,   -8 }, /* (347) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  247,    0 }, /* (348) sliding_opt ::= */
  {  247,   -4 }, /* (349) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  292,    0 }, /* (350) fill_opt ::= */
  {  292,   -4 }, /* (351) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  292,   -6 }, /* (352) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  293,   -1 }, /* (353) fill_mode ::= NONE */
  {  293,   -1 }, /* (354) fill_mode ::= PREV */
  {  293,   -1 }, /* (355) fill_mode ::= NULL */
  {  293,   -1 }, /* (356) fill_mode ::= LINEAR */
  {  293,   -1 }, /* (357) fill_mode ::= NEXT */
  {  288,    0 }, /* (358) group_by_clause_opt ::= */
  {  288,   -3 }, /* (359) group_by_clause_opt ::= GROUP BY group_by_list */
  {  294,   -1 }, /* (360) group_by_list ::= expression */
  {  294,   -3 }, /* (361) group_by_list ::= group_by_list NK_COMMA expression */
  {  289,    0 }, /* (362) having_clause_opt ::= */
  {  289,   -2 }, /* (363) having_clause_opt ::= HAVING search_condition */
  {  251,   -4 }, /* (364) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  295,   -1 }, /* (365) query_expression_body ::= query_primary */
  {  295,   -4 }, /* (366) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  299,   -1 }, /* (367) query_primary ::= query_specification */
  {  296,    0 }, /* (368) order_by_clause_opt ::= */
  {  296,   -3 }, /* (369) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  297,    0 }, /* (370) slimit_clause_opt ::= */
  {  297,   -2 }, /* (371) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  297,   -4 }, /* (372) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  297,   -4 }, /* (373) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  298,    0 }, /* (374) limit_clause_opt ::= */
  {  298,   -2 }, /* (375) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  298,   -4 }, /* (376) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  298,   -4 }, /* (377) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  265,   -3 }, /* (378) subquery ::= NK_LP query_expression NK_RP */
  {  281,   -1 }, /* (379) search_condition ::= common_expression */
  {  300,   -1 }, /* (380) sort_specification_list ::= sort_specification */
  {  300,   -3 }, /* (381) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  301,   -3 }, /* (382) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  302,    0 }, /* (383) ordering_specification_opt ::= */
  {  302,   -1 }, /* (384) ordering_specification_opt ::= ASC */
  {  302,   -1 }, /* (385) ordering_specification_opt ::= DESC */
  {  303,    0 }, /* (386) null_ordering_opt ::= */
  {  303,   -2 }, /* (387) null_ordering_opt ::= NULLS FIRST */
  {  303,   -2 }, /* (388) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,202,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,203,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,202,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,204,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,205,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,203,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,205,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,204,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy129, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy129, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy129, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 248: /* db_name ::= NK_ID */ yytestcase(yyruleno==248);
      case 249: /* table_name ::= NK_ID */ yytestcase(yyruleno==249);
      case 250: /* column_name ::= NK_ID */ yytestcase(yyruleno==250);
      case 251: /* function_name ::= NK_ID */ yytestcase(yyruleno==251);
      case 252: /* table_alias ::= NK_ID */ yytestcase(yyruleno==252);
      case 253: /* column_alias ::= NK_ID */ yytestcase(yyruleno==253);
      case 254: /* user_name ::= NK_ID */ yytestcase(yyruleno==254);
      case 255: /* index_name ::= NK_ID */ yytestcase(yyruleno==255);
      case 256: /* topic_name ::= NK_ID */ yytestcase(yyruleno==256);
      case 257: /* stream_name ::= NK_ID */ yytestcase(yyruleno==257);
{ yylhsminor.yy129 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy129 = yylhsminor.yy129;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateQnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropQnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy185, &yymsp[-1].minor.yy129, yymsp[0].minor.yy104); }
        break;
      case 44: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy185, &yymsp[0].minor.yy129); }
        break;
      case 45: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 46: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy129, yymsp[0].minor.yy104); }
        break;
      case 47: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy185 = true; }
        break;
      case 48: /* not_exists_opt ::= */
      case 50: /* exists_opt ::= */ yytestcase(yyruleno==50);
      case 203: /* analyze_opt ::= */ yytestcase(yyruleno==203);
      case 211: /* agg_func_opt ::= */ yytestcase(yyruleno==211);
      case 328: /* set_quantifier_opt ::= */ yytestcase(yyruleno==328);
{ yymsp[1].minor.yy185 = false; }
        break;
      case 49: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy185 = true; }
        break;
      case 51: /* db_options ::= */
{ yymsp[1].minor.yy104 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 52: /* db_options ::= db_options BLOCKS NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_BLOCKS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 53: /* db_options ::= db_options CACHE NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_CACHE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 54: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 55: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 56: /* db_options ::= db_options DAYS NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 57: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 58: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 59: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 60: /* db_options ::= db_options KEEP integer_list */
{ yylhsminor.yy104 = setDatabaseKeepOption(pCxt, yymsp[-2].minor.yy104, yymsp[0].minor.yy312); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 61: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 62: /* db_options ::= db_options QUORUM NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_QUORUM, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 63: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 64: /* db_options ::= db_options TTL NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 65: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 66: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 67: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 68: /* db_options ::= db_options STREAM_MODE NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_STREAM_MODE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 69: /* db_options ::= db_options RETENTIONS NK_STRING */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_RETENTIONS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 70: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy104 = createDefaultAlterDatabaseOptions(pCxt); yylhsminor.yy104 = setDatabaseAlterOption(pCxt, yylhsminor.yy104, &yymsp[0].minor.yy253); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 71: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy104 = setDatabaseAlterOption(pCxt, yymsp[-1].minor.yy104, &yymsp[0].minor.yy253); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 72: /* alter_db_option ::= BLOCKS NK_INTEGER */
{ yymsp[-1].minor.yy253.type = DB_OPTION_BLOCKS; yymsp[-1].minor.yy253.val = yymsp[0].minor.yy0; }
        break;
      case 73: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy253.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy253.val = yymsp[0].minor.yy0; }
        break;
      case 74: /* alter_db_option ::= KEEP integer_list */
{ yymsp[-1].minor.yy253.type = DB_OPTION_KEEP; yymsp[-1].minor.yy253.pKeep = yymsp[0].minor.yy312; }
        break;
      case 75: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy253.type = DB_OPTION_WAL; yymsp[-1].minor.yy253.val = yymsp[0].minor.yy0; }
        break;
      case 76: /* alter_db_option ::= QUORUM NK_INTEGER */
{ yymsp[-1].minor.yy253.type = DB_OPTION_QUORUM; yymsp[-1].minor.yy253.val = yymsp[0].minor.yy0; }
        break;
      case 77: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy253.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy253.val = yymsp[0].minor.yy0; }
        break;
      case 78: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy253.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy253.val = yymsp[0].minor.yy0; }
        break;
      case 79: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy312 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 80: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 223: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==223);
{ yylhsminor.yy312 = addNodeToList(pCxt, yymsp[-2].minor.yy312, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 81: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 83: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==83);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy185, yymsp[-5].minor.yy104, yymsp[-3].minor.yy312, yymsp[-1].minor.yy312, yymsp[0].minor.yy104); }
        break;
      case 82: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy312); }
        break;
      case 84: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy312); }
        break;
      case 85: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy185, yymsp[0].minor.yy104); }
        break;
      case 86: /* cmd ::= ALTER TABLE alter_table_clause */
      case 87: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==87);
      case 225: /* cmd ::= query_expression */ yytestcase(yyruleno==225);
{ pCxt->pRootNode = yymsp[0].minor.yy104; }
        break;
      case 88: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy104 = createAlterTableOption(pCxt, yymsp[-1].minor.yy104, yymsp[0].minor.yy104); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 89: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy104 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy104, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy129, yymsp[0].minor.yy336); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 90: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy104 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy104, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy129); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 91: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy104 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy104, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy129, yymsp[0].minor.yy336); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 92: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy104 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy104, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy129, &yymsp[0].minor.yy129); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 93: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy104 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy104, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy129, yymsp[0].minor.yy336); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 94: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy104 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy104, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy129); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 95: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy104 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy104, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy129, yymsp[0].minor.yy336); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 96: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy104 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy104, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy129, &yymsp[0].minor.yy129); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 97: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy104 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy104, &yymsp[-2].minor.yy129, yymsp[0].minor.yy104); }
  yymsp[-5].minor.yy104 = yylhsminor.yy104;
        break;
      case 98: /* multi_create_clause ::= create_subtable_clause */
      case 101: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==101);
      case 108: /* column_def_list ::= column_def */ yytestcase(yyruleno==108);
      case 151: /* col_name_list ::= col_name */ yytestcase(yyruleno==151);
      case 184: /* func_name_list ::= func_name */ yytestcase(yyruleno==184);
      case 193: /* func_list ::= func */ yytestcase(yyruleno==193);
      case 246: /* literal_list ::= signed_literal */ yytestcase(yyruleno==246);
      case 333: /* select_sublist ::= select_item */ yytestcase(yyruleno==333);
      case 380: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==380);
{ yylhsminor.yy312 = createNodeList(pCxt, yymsp[0].minor.yy104); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 99: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 102: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==102);
{ yylhsminor.yy312 = addNodeToList(pCxt, yymsp[-1].minor.yy312, yymsp[0].minor.yy104); }
  yymsp[-1].minor.yy312 = yylhsminor.yy312;
        break;
      case 100: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
{ yylhsminor.yy104 = createCreateSubTableClause(pCxt, yymsp[-8].minor.yy185, yymsp[-7].minor.yy104, yymsp[-5].minor.yy104, yymsp[-4].minor.yy312, yymsp[-1].minor.yy312); }
  yymsp[-8].minor.yy104 = yylhsminor.yy104;
        break;
      case 103: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy104 = createDropTableClause(pCxt, yymsp[-1].minor.yy185, yymsp[0].minor.yy104); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 104: /* specific_tags_opt ::= */
      case 135: /* tags_def_opt ::= */ yytestcase(yyruleno==135);
      case 341: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==341);
      case 358: /* group_by_clause_opt ::= */ yytestcase(yyruleno==358);
      case 368: /* order_by_clause_opt ::= */ yytestcase(yyruleno==368);
{ yymsp[1].minor.yy312 = NULL; }
        break;
      case 105: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy312 = yymsp[-1].minor.yy312; }
        break;
      case 106: /* full_table_name ::= table_name */
{ yylhsminor.yy104 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy129, NULL); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 107: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy104 = createRealTableNode(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129, NULL); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 109: /* column_def_list ::= column_def_list NK_COMMA column_def */
      case 152: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==152);
      case 185: /* func_name_list ::= func_name_list NK_COMMA col_name */ yytestcase(yyruleno==185);
      case 194: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==194);
      case 247: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==247);
      case 334: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==334);
      case 381: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==381);
{ yylhsminor.yy312 = addNodeToList(pCxt, yymsp[-2].minor.yy312, yymsp[0].minor.yy104); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 110: /* column_def ::= column_name type_name */
{ yylhsminor.yy104 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy129, yymsp[0].minor.yy336, NULL); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 111: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy104 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy129, yymsp[-2].minor.yy336, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 112: /* type_name ::= BOOL */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 113: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 114: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 115: /* type_name ::= INT */
      case 116: /* type_name ::= INTEGER */ yytestcase(yyruleno==116);
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 117: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 118: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 119: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 120: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy336 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 121: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 122: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy336 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 123: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy336 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 124: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy336 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 125: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy336 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 126: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy336 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 127: /* type_name ::= JSON */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 128: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy336 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 129: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 130: /* type_name ::= BLOB */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 131: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy336 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 132: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 133: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy336 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 134: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy336 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 136: /* tags_def_opt ::= tags_def */
      case 332: /* select_list ::= select_sublist */ yytestcase(yyruleno==332);
{ yylhsminor.yy312 = yymsp[0].minor.yy312; }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 137: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy312 = yymsp[-1].minor.yy312; }
        break;
      case 138: /* table_options ::= */
{ yymsp[1].minor.yy104 = createDefaultTableOptions(pCxt); }
        break;
      case 139: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy104 = setTableOption(pCxt, yymsp[-2].minor.yy104, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 140: /* table_options ::= table_options KEEP integer_list */
{ yylhsminor.yy104 = setTableKeepOption(pCxt, yymsp[-2].minor.yy104, yymsp[0].minor.yy312); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 141: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy104 = setTableOption(pCxt, yymsp[-2].minor.yy104, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 142: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy104 = setTableSmaOption(pCxt, yymsp[-4].minor.yy104, yymsp[-1].minor.yy312); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 143: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ yylhsminor.yy104 = setTableRollupOption(pCxt, yymsp[-4].minor.yy104, yymsp[-1].minor.yy312); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 144: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ yylhsminor.yy104 = setTableOption(pCxt, yymsp[-2].minor.yy104, TABLE_OPTION_FILE_FACTOR, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 145: /* table_options ::= table_options DELAY NK_INTEGER */
{ yylhsminor.yy104 = setTableOption(pCxt, yymsp[-2].minor.yy104, TABLE_OPTION_DELAY, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 146: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy104 = createDefaultAlterTableOptions(pCxt); yylhsminor.yy104 = setTableAlterOption(pCxt, yylhsminor.yy104, &yymsp[0].minor.yy253); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 147: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy104 = setTableAlterOption(pCxt, yymsp[-1].minor.yy104, &yymsp[0].minor.yy253); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 148: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy253.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy253.val = yymsp[0].minor.yy0; }
        break;
      case 149: /* alter_table_option ::= KEEP integer_list */
{ yymsp[-1].minor.yy253.type = TABLE_OPTION_KEEP; yymsp[-1].minor.yy253.pKeep = yymsp[0].minor.yy312; }
        break;
      case 150: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy253.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy253.val = yymsp[0].minor.yy0; }
        break;
      case 153: /* col_name ::= column_name */
{ yylhsminor.yy104 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy129); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 154: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 155: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 156: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 157: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy104, yymsp[0].minor.yy104); }
        break;
      case 158: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy104, yymsp[0].minor.yy104); }
        break;
      case 159: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy104, NULL); }
        break;
      case 160: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 161: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 162: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 163: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 164: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy104, yymsp[0].minor.yy104); }
        break;
      case 165: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 166: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 167: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 168: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 169: /* cmd ::= SHOW LICENCE */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 170: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 171: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy104); }
        break;
      case 172: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy104); }
        break;
      case 173: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 174: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 175: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 176: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 177: /* db_name_cond_opt ::= */
      case 182: /* from_db_opt ::= */ yytestcase(yyruleno==182);
{ yymsp[1].minor.yy104 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 178: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy129); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 179: /* like_pattern_opt ::= */
      case 190: /* index_options ::= */ yytestcase(yyruleno==190);
      case 339: /* where_clause_opt ::= */ yytestcase(yyruleno==339);
      case 343: /* twindow_clause_opt ::= */ yytestcase(yyruleno==343);
      case 348: /* sliding_opt ::= */ yytestcase(yyruleno==348);
      case 350: /* fill_opt ::= */ yytestcase(yyruleno==350);
      case 362: /* having_clause_opt ::= */ yytestcase(yyruleno==362);
      case 370: /* slimit_clause_opt ::= */ yytestcase(yyruleno==370);
      case 374: /* limit_clause_opt ::= */ yytestcase(yyruleno==374);
{ yymsp[1].minor.yy104 = NULL; }
        break;
      case 180: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 181: /* table_name_cond ::= table_name */
{ yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy129); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 183: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy129); }
        break;
      case 186: /* func_name ::= function_name */
{ yylhsminor.yy104 = createFunctionNode(pCxt, &yymsp[0].minor.yy129, NULL); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 187: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy185, &yymsp[-3].minor.yy129, &yymsp[-1].minor.yy129, NULL, yymsp[0].minor.yy104); }
        break;
      case 188: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy185, &yymsp[-5].minor.yy129, &yymsp[-3].minor.yy129, yymsp[-1].minor.yy312, NULL); }
        break;
      case 189: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy185, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129); }
        break;
      case 191: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy104 = createIndexOption(pCxt, yymsp[-6].minor.yy312, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), NULL, yymsp[0].minor.yy104); }
        break;
      case 192: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy104 = createIndexOption(pCxt, yymsp[-8].minor.yy312, releaseRawExprNode(pCxt, yymsp[-4].minor.yy104), releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), yymsp[0].minor.yy104); }
        break;
      case 195: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy104 = createFunctionNode(pCxt, &yymsp[-3].minor.yy129, yymsp[-1].minor.yy312); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 196: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy185, &yymsp[-2].minor.yy129, yymsp[0].minor.yy104, NULL); }
        break;
      case 197: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy185, &yymsp[-2].minor.yy129, NULL, &yymsp[0].minor.yy129); }
        break;
      case 198: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy185, &yymsp[0].minor.yy129); }
        break;
      case 199: /* cmd ::= DESC full_table_name */
      case 200: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==200);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy104); }
        break;
      case 201: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 202: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy185, yymsp[-1].minor.yy104, yymsp[0].minor.yy104); }
        break;
      case 204: /* analyze_opt ::= ANALYZE */
      case 212: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==212);
      case 329: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==329);
{ yymsp[0].minor.yy185 = true; }
        break;
      case 205: /* explain_options ::= */
{ yymsp[1].minor.yy104 = createDefaultExplainOptions(pCxt); }
        break;
      case 206: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy104 = setExplainVerbose(pCxt, yymsp[-2].minor.yy104, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 207: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy104 = setExplainRatio(pCxt, yymsp[-2].minor.yy104, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 208: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy312); }
        break;
      case 209: /* cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy185, &yymsp[-5].minor.yy129, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy336, yymsp[0].minor.yy196); }
        break;
      case 210: /* cmd ::= DROP FUNCTION function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 213: /* bufsize_opt ::= */
{ yymsp[1].minor.yy196 = 0; }
        break;
      case 214: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy196 = strtol(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 215: /* cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, &yymsp[-4].minor.yy129, &yymsp[-2].minor.yy129, yymsp[0].minor.yy104); }
        break;
      case 216: /* cmd ::= DROP STREAM stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 217: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 218: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 219: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 220: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy312); }
        break;
      case 221: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 222: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy312 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 224: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy129); }
        break;
      case 226: /* literal ::= NK_INTEGER */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 227: /* literal ::= NK_FLOAT */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 228: /* literal ::= NK_STRING */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 229: /* literal ::= NK_BOOL */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 230: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 231: /* literal ::= duration_literal */
      case 240: /* signed_literal ::= signed */ yytestcase(yyruleno==240);
      case 258: /* expression ::= literal */ yytestcase(yyruleno==258);
      case 259: /* expression ::= pseudo_column */ yytestcase(yyruleno==259);
      case 260: /* expression ::= column_reference */ yytestcase(yyruleno==260);
      case 263: /* expression ::= subquery */ yytestcase(yyruleno==263);
      case 302: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==302);
      case 306: /* boolean_primary ::= predicate */ yytestcase(yyruleno==306);
      case 308: /* common_expression ::= expression */ yytestcase(yyruleno==308);
      case 309: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==309);
      case 311: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==311);
      case 313: /* table_reference ::= table_primary */ yytestcase(yyruleno==313);
      case 314: /* table_reference ::= joined_table */ yytestcase(yyruleno==314);
      case 318: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==318);
      case 365: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==365);
      case 367: /* query_primary ::= query_specification */ yytestcase(yyruleno==367);
{ yylhsminor.yy104 = yymsp[0].minor.yy104; }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 232: /* literal ::= NULL */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 233: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 234: /* signed ::= NK_INTEGER */
{ yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 235: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 236: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 237: /* signed ::= NK_FLOAT */
{ yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 238: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 239: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 241: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 242: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 243: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 244: /* signed_literal ::= duration_literal */
      case 379: /* search_condition ::= common_expression */ yytestcase(yyruleno==379);
{ yylhsminor.yy104 = releaseRawExprNode(pCxt, yymsp[0].minor.yy104); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 245: /* signed_literal ::= NULL */
{ yymsp[0].minor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL); }
        break;
      case 261: /* expression ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy129, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy129, yymsp[-1].minor.yy312)); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 262: /* expression ::= function_name NK_LP NK_STAR NK_RP */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy129, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy129, createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy0)))); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 264: /* expression ::= NK_LP expression NK_RP */
      case 307: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==307);
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy104)); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 265: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy104));
                                                                                  }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 266: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[0].minor.yy104), NULL));
                                                                                  }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 267: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); 
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 268: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); 
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 269: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); 
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 270: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); 
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 271: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); 
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 272: /* expression_list ::= expression */
{ yylhsminor.yy312 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy104)); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 273: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy312 = addNodeToList(pCxt, yymsp[-2].minor.yy312, releaseRawExprNode(pCxt, yymsp[0].minor.yy104)); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 274: /* column_reference ::= column_name */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy129, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy129)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 275: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129, createColumnNode(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129)); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 276: /* pseudo_column ::= NK_UNDERLINE ROWTS */
      case 278: /* pseudo_column ::= NK_UNDERLINE QSTARTTS */ yytestcase(yyruleno==278);
      case 279: /* pseudo_column ::= NK_UNDERLINE QENDTS */ yytestcase(yyruleno==279);
      case 280: /* pseudo_column ::= NK_UNDERLINE WSTARTTS */ yytestcase(yyruleno==280);
      case 281: /* pseudo_column ::= NK_UNDERLINE WENDTS */ yytestcase(yyruleno==281);
      case 282: /* pseudo_column ::= NK_UNDERLINE WDURATION */ yytestcase(yyruleno==282);
{
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy104 = createRawExprNode(pCxt, &t, createFunctionNode(pCxt, &t, NULL));
                                                                                  }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 277: /* pseudo_column ::= TBNAME */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 283: /* predicate ::= expression compare_op expression */
      case 288: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==288);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy60, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104)));
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 284: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy104), releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104)));
                                                                                  }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 285: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[-5].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104)));
                                                                                  }
  yymsp[-5].minor.yy104 = yylhsminor.yy104;
        break;
      case 286: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), NULL));
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 287: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy104), NULL));
                                                                                  }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 289: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy60 = OP_TYPE_LOWER_THAN; }
        break;
      case 290: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy60 = OP_TYPE_GREATER_THAN; }
        break;
      case 291: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy60 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 292: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy60 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 293: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy60 = OP_TYPE_NOT_EQUAL; }
        break;
      case 294: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy60 = OP_TYPE_EQUAL; }
        break;
      case 295: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy60 = OP_TYPE_LIKE; }
        break;
      case 296: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy60 = OP_TYPE_NOT_LIKE; }
        break;
      case 297: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy60 = OP_TYPE_MATCH; }
        break;
      case 298: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy60 = OP_TYPE_NMATCH; }
        break;
      case 299: /* in_op ::= IN */
{ yymsp[0].minor.yy60 = OP_TYPE_IN; }
        break;
      case 300: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy60 = OP_TYPE_NOT_IN; }
        break;
      case 301: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy312)); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 303: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy104), NULL));
                                                                                  }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 304: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104)));
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 305: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104)));
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 310: /* from_clause ::= FROM table_reference_list */
      case 340: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==340);
      case 363: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==363);
{ yymsp[-1].minor.yy104 = yymsp[0].minor.yy104; }
        break;
      case 312: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy104 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy104, yymsp[0].minor.yy104, NULL); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 315: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy104 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy129, &yymsp[0].minor.yy129); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 316: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy104 = createRealTableNode(pCxt, &yymsp[-3].minor.yy129, &yymsp[-1].minor.yy129, &yymsp[0].minor.yy129); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 317: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy104 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy104), &yymsp[0].minor.yy129); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 319: /* alias_opt ::= */
{ yymsp[1].minor.yy129 = nil_token;  }
        break;
      case 320: /* alias_opt ::= table_alias */
{ yylhsminor.yy129 = yymsp[0].minor.yy129; }
  yymsp[0].minor.yy129 = yylhsminor.yy129;
        break;
      case 321: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy129 = yymsp[0].minor.yy129; }
        break;
      case 322: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 323: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==323);
{ yymsp[-2].minor.yy104 = yymsp[-1].minor.yy104; }
        break;
      case 324: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy104 = createJoinTableNode(pCxt, yymsp[-4].minor.yy532, yymsp[-5].minor.yy104, yymsp[-2].minor.yy104, yymsp[0].minor.yy104); }
  yymsp[-5].minor.yy104 = yylhsminor.yy104;
        break;
      case 325: /* join_type ::= */
{ yymsp[1].minor.yy532 = JOIN_TYPE_INNER; }
        break;
      case 326: /* join_type ::= INNER */
{ yymsp[0].minor.yy532 = JOIN_TYPE_INNER; }
        break;
      case 327: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy104 = createSelectStmt(pCxt, yymsp[-7].minor.yy185, yymsp[-6].minor.yy312, yymsp[-5].minor.yy104);
                                                                                    yymsp[-8].minor.yy104 = addWhereClause(pCxt, yymsp[-8].minor.yy104, yymsp[-4].minor.yy104);
                                                                                    yymsp[-8].minor.yy104 = addPartitionByClause(pCxt, yymsp[-8].minor.yy104, yymsp[-3].minor.yy312);
                                                                                    yymsp[-8].minor.yy104 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy104, yymsp[-2].minor.yy104);
                                                                                    yymsp[-8].minor.yy104 = addGroupByClause(pCxt, yymsp[-8].minor.yy104, yymsp[-1].minor.yy312);
                                                                                    yymsp[-8].minor.yy104 = addHavingClause(pCxt, yymsp[-8].minor.yy104, yymsp[0].minor.yy104);
                                                                                  }
        break;
      case 330: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy185 = false; }
        break;
      case 331: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy312 = NULL; }
        break;
      case 335: /* select_item ::= common_expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy104), &t);
                                                                                  }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 336: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy104 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy104), &yymsp[0].minor.yy129); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 337: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy104 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), &yymsp[0].minor.yy129); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 338: /* select_item ::= table_name NK_DOT NK_STAR */
{ yylhsminor.yy104 = createColumnNode(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 342: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 359: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==359);
      case 369: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==369);
{ yymsp[-2].minor.yy312 = yymsp[0].minor.yy312; }
        break;
      case 344: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy104 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy104), releaseRawExprNode(pCxt, yymsp[-1].minor.yy104)); }
        break;
      case 345: /* twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP */
{ yymsp[-3].minor.yy104 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy104)); }
        break;
      case 346: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy104 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy104), NULL, yymsp[-1].minor.yy104, yymsp[0].minor.yy104); }
        break;
      case 347: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy104 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy104), releaseRawExprNode(pCxt, yymsp[-3].minor.yy104), yymsp[-1].minor.yy104, yymsp[0].minor.yy104); }
        break;
      case 349: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy104 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy104); }
        break;
      case 351: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy104 = createFillNode(pCxt, yymsp[-1].minor.yy550, NULL); }
        break;
      case 352: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy104 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy312)); }
        break;
      case 353: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy550 = FILL_MODE_NONE; }
        break;
      case 354: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy550 = FILL_MODE_PREV; }
        break;
      case 355: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy550 = FILL_MODE_NULL; }
        break;
      case 356: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy550 = FILL_MODE_LINEAR; }
        break;
      case 357: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy550 = FILL_MODE_NEXT; }
        break;
      case 360: /* group_by_list ::= expression */
{ yylhsminor.yy312 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 361: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy312 = addNodeToList(pCxt, yymsp[-2].minor.yy312, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 364: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy104 = addOrderByClause(pCxt, yymsp[-3].minor.yy104, yymsp[-2].minor.yy312);
                                                                                    yylhsminor.yy104 = addSlimitClause(pCxt, yylhsminor.yy104, yymsp[-1].minor.yy104);
                                                                                    yylhsminor.yy104 = addLimitClause(pCxt, yylhsminor.yy104, yymsp[0].minor.yy104);
                                                                                  }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 366: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy104 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy104, yymsp[0].minor.yy104); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 371: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 375: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==375);
{ yymsp[-1].minor.yy104 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 372: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 376: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==376);
{ yymsp[-3].minor.yy104 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 373: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 377: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==377);
{ yymsp[-3].minor.yy104 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 378: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy104); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 382: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy104 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), yymsp[-1].minor.yy354, yymsp[0].minor.yy489); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 383: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy354 = ORDER_ASC; }
        break;
      case 384: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy354 = ORDER_ASC; }
        break;
      case 385: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy354 = ORDER_DESC; }
        break;
      case 386: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy489 = NULL_ORDER_DEFAULT; }
        break;
      case 387: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy489 = NULL_ORDER_FIRST; }
        break;
      case 388: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy489 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
