/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 485
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy48;
  EOperatorType yy70;
  int8_t yy73;
  int32_t yy120;
  SNodeList* yy174;
  EFillMode yy204;
  SNode* yy242;
  STokenPair yy257;
  int64_t yy349;
  EJoinType yy482;
  SAlterOption yy535;
  SToken yy669;
  ENullOrder yy687;
  bool yy777;
  SDataType yy794;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             794
#define YYNRULE              596
#define YYNRULE_WITH_ACTION  596
#define YYNTOKEN             337
#define YY_MAX_SHIFT         793
#define YY_MIN_SHIFTREDUCE   1172
#define YY_MAX_SHIFTREDUCE   1767
#define YY_ERROR_ACTION      1768
#define YY_ACCEPT_ACTION     1769
#define YY_NO_ACTION         1770
#define YY_MIN_REDUCE        1771
#define YY_MAX_REDUCE        2366
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2730)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  2177, 2067,  170,  218, 1783,  670,  447,  531,  665, 1814,
 /*    10 */   662,  446,   48,   46, 1694, 1937, 2065,  671,  647, 1794,
 /*    20 */   401, 2337, 1543,   41,   40,  410,  409,   47,   45,   44,
 /*    30 */    43,   42,  686, 1624, 2237, 1541,  646,  188, 2195,   41,
 /*    40 */    40, 2338,  648,   47,   45,   44,   43,   42, 1550, 2138,
 /*    50 */  2145, 1571,  700,  622, 1568,  622, 2337,  543, 2337, 2060,
 /*    60 */  2177,  181, 1619,   47,   45,   44,   43,   42,   19, 2145,
 /*    70 */   701, 2343,  188, 2343,  188, 1549, 2338,  648, 2338,  648,
 /*    80 */   220,  368, 2050,  360,  531, 2176, 1814, 2212,  107,  184,
 /*    90 */   110, 2178,  704, 2180, 2181,  699,  622,  694, 2195, 2337,
 /*   100 */   790, 1988,  185,   15, 2265,  143,   87,  641,  397, 2261,
 /*   110 */  2145, 1793,  700, 1940, 2343,  188,   48,   46, 2067, 2338,
 /*   120 */   648,  190, 2155,  370,  401, 2342, 1543, 1653, 2337, 2291,
 /*   130 */   394,  683, 1943, 2064,  671, 2195, 1939, 1624,  205, 1541,
 /*   140 */  1626, 1627,  453, 1318, 2341, 2176, 2159, 2212, 2338, 2340,
 /*   150 */   110, 2178,  704, 2180, 2181,  699, 1317,  694, 1569,  404,
 /*   160 */   145, 2145,  152, 2236, 2265,  181, 1619,  164,  397, 2261,
 /*   170 */  1599, 1609,   19, 2001,  382, 1950, 1625, 1628,   84, 1549,
 /*   180 */   381,   83, 1999, 2161, 1654, 1772, 2051,  347, 1999,  640,
 /*   190 */  1544,  123, 1542,  694,  122,  121,  120,  119,  118,  117,
 /*   200 */   116,  115,  114,  263,  790, 1553,  123,   15, 2177,  122,
 /*   210 */   121,  120,  119,  118,  117,  116,  115,  114,  701,  669,
 /*   220 */  1816,  500, 1547, 1548, 1771, 1598, 1601, 1602, 1603, 1604,
 /*   230 */  1605, 1606, 1607, 1608,  696,  692, 1617, 1618, 1620, 1621,
 /*   240 */  1622, 1623,    2,  642, 1626, 1627, 2195, 1792,  132,  131,
 /*   250 */   130,  129,  128,  127,  126,  125,  124,  670, 2145,   62,
 /*   260 */   700,   37,  399, 1648, 1649, 1650, 1651, 1652, 1656, 1657,
 /*   270 */  1658, 1659,   38,  305, 1599, 1609, 1568,  287, 1398, 1399,
 /*   280 */  1625, 1628, 1205,  683,   41,   40,  684, 1948,   47,   45,
 /*   290 */    44,   43,   42, 2176, 1544, 2212, 1542, 2145,  110, 2178,
 /*   300 */   704, 2180, 2181,  699,  528,  694,  133,  529, 1807,  668,
 /*   310 */  2357, 2060, 2265,  568, 1568, 2177,  397, 2261,   62, 1567,
 /*   320 */    93, 1207,  533, 1210, 1211,  662, 1547, 1548,  530, 1598,
 /*   330 */  1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608,  696,  692,
 /*   340 */  1617, 1618, 1620, 1621, 1622, 1623,    2,   12,   48,   46,
 /*   350 */    12,  637,   10, 2195,  395,  683,  401,  406, 1543, 1363,
 /*   360 */  1994, 1996,  167,  373,  545, 2145,   51,  700,  670, 1624,
 /*   370 */  1950, 1541,  684, 1948, 1354,  729,  728,  727, 1358,  726,
 /*   380 */  1360, 1361,  725,  722, 2131, 1369,  719, 1371, 1372,  716,
 /*   390 */   713,  710,  133, 2177,    8, 2280,  659,  142, 1619,  573,
 /*   400 */  2176, 1791, 2212,  698,   19,  110, 2178,  704, 2180, 2181,
 /*   410 */   699, 1549,  694, 2342, 1230,  191, 1229,  185, 1925, 2265,
 /*   420 */   679, 2277, 2060,  397, 2261,  250, 1600,  659,  142,  138,
 /*   430 */  1570, 2195,  374,  423,  372,  371,  790,  570,   51,   15,
 /*   440 */   643,  638,  631, 2145, 2292,  700, 1570, 1231,  586,  585,
 /*   450 */   584, 2145,   48,   46, 1629,  576,  139,  580, 1764,  572,
 /*   460 */   401,  579, 1543,  571, 1453, 1454,  578,  583,  376,  375,
 /*   470 */   609, 1722,  577, 1624,  191, 1541, 1626, 1627, 2176, 2280,
 /*   480 */  2212, 1995, 1996,  341, 2178,  704, 2180, 2181,  699,  697,
 /*   490 */   694,  685, 2230,  536, 1514, 1515,  529, 1807, 2177,  187,
 /*   500 */  2273, 2274, 1619,  140, 2278, 2276, 1599, 1609,  701, 1230,
 /*   510 */  2312, 1229, 1625, 1628, 1757, 1549,  659,  142,  634,  633,
 /*   520 */  1720, 1721, 1723, 1724, 1725,  491, 1544,  739, 1542,  661,
 /*   530 */   186, 2273, 2274,  525,  140, 2278, 2195,   14,   13, 1568,
 /*   540 */   790,  523, 1231,   49,  519,  515,  659,  142, 2145, 1790,
 /*   550 */   700,  737,  157,  156,  734,  733,  732,  154, 1547, 1548,
 /*   560 */  1763, 1598, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608,
 /*   570 */   696,  692, 1617, 1618, 1620, 1621, 1622, 1623,    2,  574,
 /*   580 */  1626, 1627,  285, 2176, 2341, 2212,  209,  208,  110, 2178,
 /*   590 */   704, 2180, 2181,  699,  191,  694,   12, 2001,  285, 2145,
 /*   600 */  2357, 1305, 2265,  101,  391, 2177,  397, 2261, 2110,  490,
 /*   610 */  1599, 1609, 1999, 1687,  600,  701, 1625, 1628, 1924,  283,
 /*   620 */  2273,  658,   62,  134,  657,   66, 2337,  598, 1941,  596,
 /*   630 */  1544,  435, 1542,  737,  157,  156,  734,  733,  732,  154,
 /*   640 */  1667,  646,  188, 2195,  684, 1948, 2338,  648, 1769,  189,
 /*   650 */  2273, 2274, 1549,  140, 2278, 2145,  251,  700,  437,  433,
 /*   660 */  2031, 2139, 1547, 1548,  193, 1598, 1601, 1602, 1603, 1604,
 /*   670 */  1605, 1606, 1607, 1608,  696,  692, 1617, 1618, 1620, 1621,
 /*   680 */  1622, 1623,    2,   48,   46,  739,  169, 1233, 1234,   52,
 /*   690 */  2176,  401, 2212, 1543, 1889,  110, 2178,  704, 2180, 2181,
 /*   700 */   699,  575,  694, 2001, 1624, 2155, 1541, 2240,  622, 2265,
 /*   710 */   396, 2337,  234,  397, 2261,   44,   43,   42, 1999, 2164,
 /*   720 */   416, 1322, 1543, 1303,   62,  415, 2343,  188,  174, 2159,
 /*   730 */  2177, 2338,  648, 1619, 1321, 1541,  562,  558,  554,  550,
 /*   740 */   701,  233,  688, 1789, 2237, 2155, 1549,   41,   40, 1307,
 /*   750 */    34,   47,   45,   44,   43,   42,   41,   40, 1264, 2163,
 /*   760 */    47,   45,   44,   43,   42, 1926, 2161,  622, 2195, 2159,
 /*   770 */  2337,  790,  684, 1948,   49, 1549,  694,  730,  191, 1788,
 /*   780 */  2145,   88,  700,   30,  231, 2343,  188,   48,   46, 1309,
 /*   790 */  2338,  648,  681, 2145, 2177,  401, 1571, 1543, 1265,  502,
 /*   800 */   790, 1787,  564,  563,  701,  749, 2161,  398, 1624,  150,
 /*   810 */  1541, 1626, 1627,  684, 1948, 2176,  694, 2212, 1569,  471,
 /*   820 */   111, 2178,  704, 2180, 2181,  699, 1933,  694,  470, 2145,
 /*   830 */   566,  565, 2195,   57, 2265,  684, 1948, 1619, 2264, 2261,
 /*   840 */  1571, 1599, 1609, 1734, 2145,  191,  700, 1625, 1628, 2046,
 /*   850 */  1549, 2145,  230,  224,  572,  451, 1935,  229,  571,  541,
 /*   860 */   650, 1544,  144, 1542,  249, 2236,   41,   40,  248, 1786,
 /*   870 */    47,   45,   44,   43,   42,  790, 1698,  222,   15, 2176,
 /*   880 */   191, 2212, 1568, 2046,  171, 2178,  704, 2180, 2181,  699,
 /*   890 */  1544,  694, 1542, 1547, 1548,  201, 1598, 1601, 1602, 1603,
 /*   900 */  1604, 1605, 1606, 1607, 1608,  696,  692, 1617, 1618, 1620,
 /*   910 */  1621, 1622, 1623,    2, 1931, 1626, 1627,  582,  581, 2145,
 /*   920 */   684, 1948, 1547, 1548,  623, 2302, 1952, 2001,   90,  203,
 /*   930 */  2280,  355, 2046,  404,  380,  351,  602, 1566, 1470, 1471,
 /*   940 */   452,  167, 2000, 2177,  484, 1599, 1609,  498,  202, 1950,
 /*   950 */   497, 1625, 1628,  701,  256,  629, 2275,  684, 1948,  684,
 /*   960 */  1948, 2342, 1733, 1213, 2337, 1544,  467, 1542,  499, 1567,
 /*   970 */  1785,  684, 1948,  469, 1469, 1472,   36,  461,  207,  476,
 /*   980 */  2341, 2195,   41,   40, 2338, 2339,   47,   45,   44,   43,
 /*   990 */    42,  477,  262, 2145,  695,  700,  731, 1547, 1548, 1992,
 /*  1000 */  1598, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608,  696,
 /*  1010 */   692, 1617, 1618, 1620, 1621, 1622, 1623,    2, 1847,  369,
 /*  1020 */  2145,  167,  684, 1948,  684, 1948,  684, 1948, 2176, 1951,
 /*  1030 */  2212,  457, 1600,  110, 2178,  704, 2180, 2181,  699,   54,
 /*  1040 */   694,    3,  544,  259, 1945, 2357,  252, 2265, 1890,   41,
 /*  1050 */    40,  397, 2261,   47,   45,   44,   43,   42,  296,  297,
 /*  1060 */  2128,  495, 2305,  295,  489,  488,  487,  486,  483,  482,
 /*  1070 */   481,  480,  479,  475,  474,  473,  472,  350,  464,  463,
 /*  1080 */   462,  607,  459,  458,  367, 1691, 1782, 1634,  767,  766,
 /*  1090 */   765,  764,  413, 1568,  763,  762,  146,  757,  756,  755,
 /*  1100 */   754,  753,  752,  751,  159,  747,  746,  745,  412,  411,
 /*  1110 */   742,  741,  740,  177,  176,  168, 1850,  454,   41,   40,
 /*  1120 */   326, 1655,   47,   45,   44,   43,   42,   87,  622, 2177,
 /*  1130 */   455, 2337, 1784, 2001,  323,   73, 2145,  155,   72,  701,
 /*  1140 */   405, 2330, 1781,  761,  759, 1710, 2343,  188, 1999,  348,
 /*  1150 */   280, 2338,  648, 1944,  684, 1948,   62,  635,  684, 1948,
 /*  1160 */   216,  510,  508,  505,  137, 2177, 1923, 2195, 1780,  691,
 /*  1170 */  2001,  684, 1948,  735,  260,  701, 1992,  366,  286, 2145,
 /*  1180 */  1888,  700,  684, 1948, 1779, 1999,  586,  585,  584,  684,
 /*  1190 */  1948,  667, 2145,  576,  139,  580, 1778,   56,   35,  579,
 /*  1200 */    62,  651,  300, 2195,  578,  583,  376,  375, 1660,  682,
 /*  1210 */   577,  274, 1210, 1211, 2176, 2145, 2212,  700, 2145,  110,
 /*  1220 */  2178,  704, 2180, 2181,  699, 1777,  694,  654, 1776,  684,
 /*  1230 */  1948, 2357, 1887, 2265, 2145, 2177,  414,  397, 2261,  109,
 /*  1240 */  1775, 1774,  445, 1600,  444,  701, 2145, 2284,  647,  306,
 /*  1250 */  2176, 2337, 2212, 2285, 1687,  172, 2178,  704, 2180, 2181,
 /*  1260 */   699,  407,  694,  684, 1948,  736,  646,  188, 1992,  167,
 /*  1270 */  2196, 2338,  648, 2195,  443, 2145,  430, 1950, 2145,   81,
 /*  1280 */    80,  450,  166,  408,  200, 2145, 2177,  700,  261,  319,
 /*  1290 */  2145, 2145, 1978,  604, 2055,  603,  701,  442,  440,  737,
 /*  1300 */   157,  156,  734,  733,  732,  154,  649, 2358,  349, 2177,
 /*  1310 */   750,  431,  191, 1910,  429,  425,  421,  418,  443,  701,
 /*  1320 */  2176, 2299, 2212, 1645, 2195,  110, 2178,  704, 2180, 2181,
 /*  1330 */   699,   91,  694,  148,   74,  135, 2145, 2357,  700, 2265,
 /*  1340 */  1834, 1690, 1825,  397, 2261,  410,  409, 2195,  239,  241,
 /*  1350 */   243,  237,  240,  242,  245, 1557,  191,  244,  621, 2145,
 /*  1360 */  2177,  700,  587,  155,  589, 1823, 1624,  155, 1550,   50,
 /*  1370 */   701, 2176,   50, 2212,  267,  155,  335, 2178,  704, 2180,
 /*  1380 */  2181,  699,   50,  694,   82,   41,   40,  592,  293,   47,
 /*  1390 */    45,   44,   43,   42, 2176, 1619, 2212, 1552, 2195,  110,
 /*  1400 */  2178,  704, 2180, 2181,  699,   71,  694,  153, 1549, 1551,
 /*  1410 */  2145, 2357,  700, 2265, 1766, 1767,  155,  397, 2261,  644,
 /*  1420 */  2177,   14,   13, 1509,   64,   50,   50, 1512,  708, 1719,
 /*  1430 */   701,  153, 1718,  690,  269,  666, 2166,  155,  652,  743,
 /*  1440 */   136,  744, 1467,  153, 1817, 2176,  106, 2212,  298, 2177,
 /*  1450 */   110, 2178,  704, 2180, 2181,  699,  103,  694, 2195,  701,
 /*  1460 */  1808, 1283, 2238, 1281, 2265,  676,  655,  302,  397, 2261,
 /*  1470 */  2145, 1813,  700, 1989, 2295,  660, 1348,  282,  279,    1,
 /*  1480 */     9,  417,   55,  422, 1661, 1610,  318, 2195, 1376,  364,
 /*  1490 */  1574, 1380, 2168,  438,  785,  439,  195, 1387,  196, 2145,
 /*  1500 */  1385,  700,  441,  158,  198, 2176, 1490, 2212,  313,  206,
 /*  1510 */   110, 2178,  704, 2180, 2181,  699,  456,  694, 1571,  460,
 /*  1520 */  2056,  493,  687, 1558, 2265, 1553,  465, 1566,  397, 2261,
 /*  1530 */   478, 2048,  485,  492, 2176,  504, 2212,  494,  503,  111,
 /*  1540 */  2178,  704, 2180, 2181,  699,  501,  694,  591,  210,  211,
 /*  1550 */   506,  507,  213, 2265, 1555, 1561, 1563,  689, 2261,  509,
 /*  1560 */   511, 1572,  601,  526,    4, 2177, 1554,  537,  692, 1617,
 /*  1570 */  1618, 1620, 1621, 1622, 1623,  701,  247,  527,  534,  535,
 /*  1580 */   221, 1569,  538, 1573, 1575,  223,  539,  540,  226,  542,
 /*  1590 */   228, 2177,  594,  546,  567,   85,  569,   86,  232,  588,
 /*  1600 */   354,  701, 1938, 2195,  112,  246,  236, 1934,  608,  606,
 /*  1610 */   151,   89,  238, 2119,  314, 2145,  253,  700,  612,  613,
 /*  1620 */   611,  255,  257,  160,  161, 2177, 1936, 1932,  162, 2195,
 /*  1630 */  1497,  163,  617,  619,  636,  701, 2311,  674, 2287, 2310,
 /*  1640 */     7, 2145,  645,  700, 2116,   70, 2115,  273,   69,  616,
 /*  1650 */   702,  175, 2212,  626,  627,  111, 2178,  704, 2180, 2181,
 /*  1660 */   699,  632,  694, 2195, 2296, 2306,  386,  265,  639, 2265,
 /*  1670 */   275,  618,  268,  359, 2261, 2145, 2176,  700, 2212,  625,
 /*  1680 */   276,  111, 2178,  704, 2180, 2181,  699, 2177,  694,  624,
 /*  1690 */   278,  387, 2360,  656,  653, 2265, 1687,  701,  141, 1570,
 /*  1700 */  2262, 2281,  663,  664,  390,  288,   96, 2061, 1576,  677,
 /*  1710 */  2176, 2177, 2212,  315,  672,  171, 2178,  704, 2180, 2181,
 /*  1720 */   699,  701,  694,  678,  673, 2195, 2075, 2074,   61, 2073,
 /*  1730 */   384,  277,  316,  317,   98, 2177,  281, 2145, 1949,  700,
 /*  1740 */  2246,  393,  100,  102,  786,  701, 2336, 1993,  309, 2195,
 /*  1750 */   706, 1911,  320,  787,  385,  789, 2303,  329,   53,  324,
 /*  1760 */  2137, 2145,  356,  700,  357,  322,  344, 2136, 2135,  343,
 /*  1770 */   333,   78, 2176, 2195, 2212,  419, 1534,  342, 2178,  704,
 /*  1780 */  2180, 2181,  699, 2132,  694, 2145,  420,  700, 1535,  194,
 /*  1790 */   424, 2130,  426,  427,  428, 2129, 2176,  365, 2212, 2177,
 /*  1800 */  2127,  342, 2178,  704, 2180, 2181,  699,  432,  694,  701,
 /*  1810 */  2126,  434, 2125,  436, 1525, 2106,  197, 2105,  199, 1493,
 /*  1820 */  2176,   79, 2212, 1492, 2087,  172, 2178,  704, 2180, 2181,
 /*  1830 */   699, 2086,  694, 2085,  448,  449, 2084, 2195, 2083, 1444,
 /*  1840 */  2039, 2038,  392, 2036,  147, 2035, 2034, 2037, 2033, 2145,
 /*  1850 */  2032,  700, 2030, 2029, 2028,  204,  466, 2027,  468, 2041,
 /*  1860 */  2026, 2025, 2024, 2177,  149, 2011, 2010, 2009, 2040, 2008,
 /*  1870 */  2007, 1446, 2006,  698, 2023, 2022, 2021, 2359, 2020, 2019,
 /*  1880 */  2018, 2017, 2016, 2015, 2176, 2177, 2212, 2014, 2013,  342,
 /*  1890 */  2178,  704, 2180, 2181,  699,  701,  694, 2012, 2005, 2004,
 /*  1900 */  2003, 2195,  496, 2002,  352, 1853, 1319, 1852, 1323, 2177,
 /*  1910 */    63,  353, 1315, 2145, 1851,  700, 1849,  212, 1846,  701,
 /*  1920 */   214, 1845,  513, 2195,  512, 1838,  516, 1827,  400,  514,
 /*  1930 */   520,  524,  518,  215, 1803, 2145, 1212,  700, 1802, 2104,
 /*  1940 */   522,  517, 2094,  521,  217,   76, 2082, 2195, 2176,  219,
 /*  1950 */  2212, 2165,  402,  341, 2178,  704, 2180, 2181,  699, 2145,
 /*  1960 */   694,  700, 2231,  610,  182,   77,  183,  225,  227, 2081,
 /*  1970 */  2176,  532, 2212, 2059, 1927,  342, 2178,  704, 2180, 2181,
 /*  1980 */   699,  793,  694, 1848, 1257, 1844,  547,  549, 1842,  548,
 /*  1990 */   551,  553,  552, 1840, 2176,  312, 2212, 2177,  555,  342,
 /*  2000 */  2178,  704, 2180, 2181,  699,  556,  694,  701, 1837,  557,
 /*  2010 */   559,  180, 1392,  560, 1822,  561, 2177, 1820, 1821,  783,
 /*  2020 */   779,  775,  771, 1819,  310, 1391,  701, 2177, 1799, 1929,
 /*  2030 */  1928,  758, 1306,  235, 1304, 2195, 1302,  701,  760, 1301,
 /*  2040 */  1300, 1299, 1298, 1293, 1295, 1294, 1292, 2145, 1835,  700,
 /*  2050 */  1826,  590, 1824,  377, 2195,  378,  379,  593, 1798,  595,
 /*  2060 */  1797,  597, 1796,  599,  108, 2195, 2145,  303,  700,  113,
 /*  2070 */  1519, 1521, 1518, 2103, 1499, 1523, 1501, 2145, 2093,  700,
 /*  2080 */    58,   29,  605,   67, 2212,  614,  258,  337, 2178,  704,
 /*  2090 */  2180, 2181,  699, 2080,  694, 2177, 2078, 2342,   17,   20,
 /*  2100 */   680, 2176, 1736, 2212,  165,  701,  327, 2178,  704, 2180,
 /*  2110 */  2181,  699, 2176,  694, 2212, 2177,  615,  325, 2178,  704,
 /*  2120 */  2180, 2181,  699,   31,  694,  701, 2177, 1503,  620,  383,
 /*  2130 */   264,    5,    6, 2195,   21,  290,  701,   65,  272,  628,
 /*  2140 */   289,  630,   22,  271,  266, 2145, 2177,  700, 1717,  173,
 /*  2150 */   270, 2166,   33, 2195,   32,   24,  701, 1709, 1751,   92,
 /*  2160 */   254, 1756, 1750, 1757, 2195, 2145,  388,  700, 1755, 1684,
 /*  2170 */  1754,  389, 1683,  284,   59,  178, 2145, 2079,  700, 2077,
 /*  2180 */  2176,   60, 2212, 2076, 2195,  328, 2178,  704, 2180, 2181,
 /*  2190 */   699, 2058,  694,   95,   23,   18, 2145,  291,  700,  292,
 /*  2200 */  2176, 1715, 2212,   94, 2177,  334, 2178,  704, 2180, 2181,
 /*  2210 */   699, 2176,  694, 2212,  701,   25,  338, 2178,  704, 2180,
 /*  2220 */  2181,  699,  294,  694,  299, 2177, 2057,   68,   97,  103,
 /*  2230 */    26, 2176,   99, 2212,  301,  701,  330, 2178,  704, 2180,
 /*  2240 */  2181,  699, 2195,  694,  675,  304, 1636, 1635,   13, 1559,
 /*  2250 */  2177, 2215,  179, 1614, 2145,  693,  700,   11,  192, 1612,
 /*  2260 */   701,   39,   16, 2195, 1611, 1646,   27, 1591, 1583,  703,
 /*  2270 */    28,  705, 1377,  707,  403, 2145, 2177,  700,  709,  711,
 /*  2280 */  1374,  712,  714,  717, 1373,  715,  701,  718, 2195, 2176,
 /*  2290 */   720, 2212, 1370,  721,  339, 2178,  704, 2180, 2181,  699,
 /*  2300 */  2145,  694,  700, 1364, 1362,  723, 1368,  724,  307, 1386,
 /*  2310 */  2176,  104, 2212,  105, 2195,  331, 2178,  704, 2180, 2181,
 /*  2320 */   699, 1367,  694,   75, 1382, 1255, 2145, 1366,  700,  738,
 /*  2330 */  1287, 1365, 1286, 1285, 1284, 2176, 2177, 2212, 1282, 1280,
 /*  2340 */   340, 2178,  704, 2180, 2181,  699,  701,  694, 1279, 1278,
 /*  2350 */  1313,  748, 2177,  308, 1276, 1275, 1274, 1273, 1272, 1271,
 /*  2360 */  1270, 2176,  701, 2212, 1310, 2177,  332, 2178,  704, 2180,
 /*  2370 */  2181,  699, 1308,  694, 2195,  701, 1267, 1266, 1263, 1262,
 /*  2380 */  1261, 1260, 1843,  768,  770,  769, 2145, 1841,  700,  772,
 /*  2390 */  2195,  774, 1839, 1836,  776,  778,  773,  780,  777,  781,
 /*  2400 */   782, 1818, 2145, 2195,  700,  784, 1202, 1795,  311,  788,
 /*  2410 */  1770, 1545,  321, 1770,  792, 2145,  791,  700, 1770, 1770,
 /*  2420 */  1770, 2176, 1770, 2212, 1770, 2177,  345, 2178,  704, 2180,
 /*  2430 */  2181,  699, 1770,  694, 1770,  701, 1770, 2176, 1770, 2212,
 /*  2440 */  1770, 2177,  346, 2178,  704, 2180, 2181,  699, 1770,  694,
 /*  2450 */  2176,  701, 2212, 1770, 2177, 2189, 2178,  704, 2180, 2181,
 /*  2460 */   699, 1770,  694, 2195,  701, 1770, 1770, 1770, 1770, 1770,
 /*  2470 */  1770, 1770, 1770, 1770, 1770, 2145, 1770,  700, 1770, 2195,
 /*  2480 */  1770, 1770, 1770, 1770, 1770, 1770, 1770, 1770, 1770, 1770,
 /*  2490 */  1770, 2145, 2195,  700, 1770, 1770, 1770, 1770, 1770, 1770,
 /*  2500 */  1770, 1770, 1770, 1770, 2145, 1770,  700, 1770, 1770, 1770,
 /*  2510 */  2176, 1770, 2212, 1770, 1770, 2188, 2178,  704, 2180, 2181,
 /*  2520 */   699, 1770,  694, 1770, 1770, 1770, 2176, 2177, 2212, 1770,
 /*  2530 */  1770, 2187, 2178,  704, 2180, 2181,  699,  701,  694, 2176,
 /*  2540 */  1770, 2212, 1770, 2177,  361, 2178,  704, 2180, 2181,  699,
 /*  2550 */  1770,  694, 1770,  701, 2177, 1770, 1770, 1770, 1770, 1770,
 /*  2560 */  1770, 1770, 1770, 1770,  701, 2195, 1770, 1770, 1770, 1770,
 /*  2570 */  1770, 1770, 1770, 1770, 1770, 1770, 1770, 2145, 1770,  700,
 /*  2580 */  1770, 2195, 1770, 1770, 1770, 1770, 1770, 1770, 1770, 1770,
 /*  2590 */  1770, 1770, 2195, 2145, 1770,  700, 1770, 1770, 1770, 1770,
 /*  2600 */  1770, 1770, 1770, 1770, 2145, 1770,  700, 1770, 1770, 1770,
 /*  2610 */  1770, 1770, 2176, 1770, 2212, 1770, 2177,  362, 2178,  704,
 /*  2620 */  2180, 2181,  699, 1770,  694, 1770,  701, 1770, 2176, 1770,
 /*  2630 */  2212, 1770, 2177,  358, 2178,  704, 2180, 2181,  699, 2176,
 /*  2640 */   694, 2212,  701, 1770,  363, 2178,  704, 2180, 2181,  699,
 /*  2650 */  1770,  694, 1770, 1770, 2195, 1770, 1770, 1770, 1770, 1770,
 /*  2660 */  1770, 1770, 1770, 1770, 1770, 1770, 2145, 1770,  700, 1770,
 /*  2670 */  2195, 1770, 1770, 1770, 1770, 1770, 1770, 1770, 1770, 1770,
 /*  2680 */  1770, 1770, 2145, 1770,  700, 1770, 1770, 1770, 1770, 1770,
 /*  2690 */  1770, 1770, 1770, 1770, 1770, 1770, 1770, 1770, 1770, 1770,
 /*  2700 */  1770,  702, 1770, 2212, 1770, 1770,  337, 2178,  704, 2180,
 /*  2710 */  2181,  699, 1770,  694, 1770, 1770, 1770, 2176, 1770, 2212,
 /*  2720 */  1770, 1770,  336, 2178,  704, 2180, 2181,  699, 1770,  694,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   340,  392,  339,  345,  341,  349,  409,  349,  409,  351,
 /*    10 */   350,  414,   12,   13,   14,  379,  407,  408,  456,  340,
 /*    20 */    20,  459,   22,    8,    9,   12,   13,   12,   13,   14,
 /*    30 */    15,   16,  441,   33,  443,   35,  474,  475,  378,    8,
 /*    40 */     9,  479,  480,   12,   13,   14,   15,   16,   35,  409,
 /*    50 */   390,   20,  392,  456,   20,  456,  459,  401,  459,  403,
 /*    60 */   340,  378,   62,   12,   13,   14,   15,   16,   68,  390,
 /*    70 */   350,  474,  475,  474,  475,   75,  479,  480,  479,  480,
 /*    80 */   345,  398,  399,   68,  349,  425,  351,  427,  356,  377,
 /*    90 */   430,  431,  432,  433,  434,  435,  456,  437,  378,  459,
 /*   100 */   100,  389,  442,  103,  444,  373,  358,  350,  448,  449,
 /*   110 */   390,  340,  392,  381,  474,  475,   12,   13,  392,  479,
 /*   120 */   480,  461,  366,  375,   20,  456,   22,  112,  459,  469,
 /*   130 */   404,   20,  384,  407,  408,  378,  380,   33,   62,   35,
 /*   140 */   140,  141,  349,   22,  475,  425,  390,  427,  479,  480,
 /*   150 */   430,  431,  432,  433,  434,  435,   35,  437,   20,  370,
 /*   160 */   440,  390,  442,  443,  444,  378,   62,  378,  448,  449,
 /*   170 */   170,  171,   68,  378,  385,  386,  176,  177,  102,   75,
 /*   180 */   385,  105,  393,  427,  169,    0,  399,  394,  393,  432,
 /*   190 */   190,   21,  192,  437,   24,   25,   26,   27,   28,   29,
 /*   200 */    30,   31,   32,  172,  100,  192,   21,  103,  340,   24,
 /*   210 */    25,   26,   27,   28,   29,   30,   31,   32,  350,   20,
 /*   220 */   352,  100,  222,  223,    0,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,  233,  234,  235,  236,  237,  238,  239,
 /*   240 */   240,  241,  242,   20,  140,  141,  378,  340,   24,   25,
 /*   250 */    26,   27,   28,   29,   30,   31,   32,  349,  390,  103,
 /*   260 */   392,  246,  247,  248,  249,  250,  251,  252,  253,  254,
 /*   270 */   255,  256,  445,  446,  170,  171,   20,   62,  140,  141,
 /*   280 */   176,  177,    4,   20,    8,    9,  349,  350,   12,   13,
 /*   290 */    14,   15,   16,  425,  190,  427,  192,  390,  430,  431,
 /*   300 */   432,  433,  434,  435,  344,  437,  369,  347,  348,  401,
 /*   310 */   442,  403,  444,  376,   20,  340,  448,  449,  103,   20,
 /*   320 */   105,   43,   14,   45,   46,  350,  222,  223,   20,  225,
 /*   330 */   226,  227,  228,  229,  230,  231,  232,  233,  234,  235,
 /*   340 */   236,  237,  238,  239,  240,  241,  242,  243,   12,   13,
 /*   350 */   243,  175,  245,  378,  370,   20,   20,  388,   22,  100,
 /*   360 */   391,  392,  378,   37,   67,  390,  103,  392,  349,   33,
 /*   370 */   386,   35,  349,  350,  115,  116,  117,  118,  119,  120,
 /*   380 */   121,  122,  123,  124,    0,  126,  127,  128,  129,  130,
 /*   390 */   131,  132,  369,  340,   39,  429,  349,  350,   62,  376,
 /*   400 */   425,  340,  427,  350,   68,  430,  431,  432,  433,  434,
 /*   410 */   435,   75,  437,    3,   20,  259,   22,  442,    0,  444,
 /*   420 */   401,  455,  403,  448,  449,  134,  170,  349,  350,   35,
 /*   430 */    20,  378,  106,   49,  108,  109,  100,  111,  103,  103,
 /*   440 */   264,  265,  266,  390,  469,  392,   20,   53,   70,   71,
 /*   450 */    72,  390,   12,   13,   14,   77,   78,   79,  182,  133,
 /*   460 */    20,   83,   22,  137,  170,  171,   88,   89,   90,   91,
 /*   470 */   114,  222,   94,   33,  259,   35,  140,  141,  425,  429,
 /*   480 */   427,  391,  392,  430,  431,  432,  433,  434,  435,  436,
 /*   490 */   437,  438,  439,  344,  203,  204,  347,  348,  340,  452,
 /*   500 */   453,  454,   62,  456,  457,  455,  170,  171,  350,   20,
 /*   510 */   352,   22,  176,  177,  104,   75,  349,  350,  269,  270,
 /*   520 */   271,  272,  273,  274,  275,   84,  190,   67,  192,  451,
 /*   530 */   452,  453,  454,   49,  456,  457,  378,    1,    2,   20,
 /*   540 */   100,   57,   53,  103,   60,   61,  349,  350,  390,  340,
 /*   550 */   392,  133,  134,  135,  136,  137,  138,  139,  222,  223,
 /*   560 */   284,  225,  226,  227,  228,  229,  230,  231,  232,  233,
 /*   570 */   234,  235,  236,  237,  238,  239,  240,  241,  242,   13,
 /*   580 */   140,  141,  172,  425,    3,  427,  145,  146,  430,  431,
 /*   590 */   432,  433,  434,  435,  259,  437,  243,  378,  172,  390,
 /*   600 */   442,   35,  444,  356,  385,  340,  448,  449,  374,  168,
 /*   610 */   170,  171,  393,  258,   21,  350,  176,  177,    0,  452,
 /*   620 */   453,  454,  103,  456,  457,    4,  459,   34,  381,   36,
 /*   630 */   190,  185,  192,  133,  134,  135,  136,  137,  138,  139,
 /*   640 */   104,  474,  475,  378,  349,  350,  479,  480,  337,  452,
 /*   650 */   453,  454,   75,  456,  457,  390,  422,  392,  212,  213,
 /*   660 */     0,  409,  222,  223,  369,  225,  226,  227,  228,  229,
 /*   670 */   230,  231,  232,  233,  234,  235,  236,  237,  238,  239,
 /*   680 */   240,  241,  242,   12,   13,   67,  359,   54,   55,  103,
 /*   690 */   425,   20,  427,   22,  367,  430,  431,  432,  433,  434,
 /*   700 */   435,   13,  437,  378,   33,  366,   35,  442,  456,  444,
 /*   710 */   385,  459,   33,  448,  449,   14,   15,   16,  393,  380,
 /*   720 */   409,   22,   22,   35,  103,  414,  474,  475,   49,  390,
 /*   730 */   340,  479,  480,   62,   35,   35,   57,   58,   59,   60,
 /*   740 */   350,   62,  441,  340,  443,  366,   75,    8,    9,   35,
 /*   750 */     2,   12,   13,   14,   15,   16,    8,    9,   35,  380,
 /*   760 */    12,   13,   14,   15,   16,    0,  427,  456,  378,  390,
 /*   770 */   459,  100,  349,  350,  103,   75,  437,  114,  259,  340,
 /*   780 */   390,  102,  392,   44,  105,  474,  475,   12,   13,   75,
 /*   790 */   479,  480,  369,  390,  340,   20,   20,   22,   75,  100,
 /*   800 */   100,  340,  354,  355,  350,   75,  427,  428,   33,   44,
 /*   810 */    35,  140,  141,  349,  350,  425,  437,  427,   20,  159,
 /*   820 */   430,  431,  432,  433,  434,  435,  379,  437,  168,  390,
 /*   830 */   354,  355,  378,  369,  444,  349,  350,   62,  448,  449,
 /*   840 */    20,  170,  171,  104,  390,  259,  392,  176,  177,  350,
 /*   850 */    75,  390,  173,  174,  133,  369,  379,  178,  137,  180,
 /*   860 */   279,  190,  440,  192,  135,  443,    8,    9,  139,  340,
 /*   870 */    12,   13,   14,   15,   16,  100,   14,  198,  103,  425,
 /*   880 */   259,  427,   20,  350,  430,  431,  432,  433,  434,  435,
 /*   890 */   190,  437,  192,  222,  223,  396,  225,  226,  227,  228,
 /*   900 */   229,  230,  231,  232,  233,  234,  235,  236,  237,  238,
 /*   910 */   239,  240,  241,  242,  379,  140,  141,  363,  364,  390,
 /*   920 */   349,  350,  222,  223,  470,  471,  379,  378,  199,  396,
 /*   930 */   429,  202,  350,  370,  205,   18,  207,   20,  140,  141,
 /*   940 */   369,  378,  393,  340,   27,  170,  171,   30,  172,  386,
 /*   950 */    33,  176,  177,  350,  379,  352,  455,  349,  350,  349,
 /*   960 */   350,  456,  104,   14,  459,  190,   49,  192,   51,   20,
 /*   970 */   340,  349,  350,   56,  176,  177,    2,  369,  396,  369,
 /*   980 */   475,  378,    8,    9,  479,  480,   12,   13,   14,   15,
 /*   990 */    16,  369,  172,  390,  379,  392,  387,  222,  223,  390,
 /*  1000 */   225,  226,  227,  228,  229,  230,  231,  232,  233,  234,
 /*  1010 */   235,  236,  237,  238,  239,  240,  241,  242,    0,  102,
 /*  1020 */   390,  378,  349,  350,  349,  350,  349,  350,  425,  386,
 /*  1030 */   427,  114,  170,  430,  431,  432,  433,  434,  435,   42,
 /*  1040 */   437,   44,  369,  415,  369,  442,  369,  444,  367,    8,
 /*  1050 */     9,  448,  449,   12,   13,   14,   15,   16,  134,  135,
 /*  1060 */     0,  144,  400,  139,  147,  148,  149,  150,  151,  152,
 /*  1070 */   153,  154,  155,  156,  157,  158,  159,  160,  161,  162,
 /*  1080 */   163,  409,  165,  166,  167,    4,  340,   14,   70,   71,
 /*  1090 */    72,   73,   74,   20,   76,   77,   78,   79,   80,   81,
 /*  1100 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*  1110 */    92,   93,   94,   95,   96,   18,    0,   22,    8,    9,
 /*  1120 */    23,  169,   12,   13,   14,   15,   16,  358,  456,  340,
 /*  1130 */    35,  459,  341,  378,   37,   38,  390,   44,   41,  350,
 /*  1140 */   385,  352,  340,  363,  364,  104,  474,  475,  393,   52,
 /*  1150 */   483,  479,  480,  384,  349,  350,  103,  472,  349,  350,
 /*  1160 */    63,   64,   65,   66,  353,  340,    0,  378,  340,   68,
 /*  1170 */   378,  349,  350,  387,  369,  350,  390,  385,  369,  390,
 /*  1180 */   366,  392,  349,  350,  340,  393,   70,   71,   72,  349,
 /*  1190 */   350,  369,  390,   77,   78,   79,  340,  104,  246,   83,
 /*  1200 */   103,   44,  369,  378,   88,   89,   90,   91,  256,  369,
 /*  1210 */    94,  466,   45,   46,  425,  390,  427,  392,  390,  430,
 /*  1220 */   431,  432,  433,  434,  435,  340,  437,   44,  340,  349,
 /*  1230 */   350,  442,  366,  444,  390,  340,  353,  448,  449,  142,
 /*  1240 */   340,  340,  189,  170,  191,  350,  390,  352,  456,  369,
 /*  1250 */   425,  459,  427,  257,  258,  430,  431,  432,  433,  434,
 /*  1260 */   435,  370,  437,  349,  350,  387,  474,  475,  390,  378,
 /*  1270 */   378,  479,  480,  378,  221,  390,  216,  386,  390,  182,
 /*  1280 */   183,  184,  172,  369,  187,  390,  340,  392,   62,  371,
 /*  1290 */   390,  390,  374,  206,  400,  208,  350,  200,  201,  133,
 /*  1300 */   134,  135,  136,  137,  138,  139,  481,  482,  211,  340,
 /*  1310 */   365,  214,  259,  368,  217,  218,  219,  220,  221,  350,
 /*  1320 */   425,  352,  427,  222,  378,  430,  431,  432,  433,  434,
 /*  1330 */   435,  105,  437,   42,  114,   44,  390,  442,  392,  444,
 /*  1340 */     0,  260,    0,  448,  449,   12,   13,  378,  107,  107,
 /*  1350 */   107,  110,  110,  110,  107,   22,  259,  110,   48,  390,
 /*  1360 */   340,  392,   22,   44,   22,    0,   33,   44,   35,   44,
 /*  1370 */   350,  425,   44,  427,   44,   44,  430,  431,  432,  433,
 /*  1380 */   434,  435,   44,  437,  164,    8,    9,   22,   44,   12,
 /*  1390 */    13,   14,   15,   16,  425,   62,  427,   35,  378,  430,
 /*  1400 */   431,  432,  433,  434,  435,   44,  437,   44,   75,   35,
 /*  1410 */   390,  442,  392,  444,  140,  141,   44,  448,  449,  473,
 /*  1420 */   340,    1,    2,  104,   44,   44,   44,  104,   44,  104,
 /*  1430 */   350,   44,  104,  100,  104,  104,   47,   44,  281,   13,
 /*  1440 */    44,   13,  104,   44,    0,  425,  103,  427,  104,  340,
 /*  1450 */   430,  431,  432,  433,  434,  435,  113,  437,  378,  350,
 /*  1460 */   348,   35,  442,   35,  444,  104,  283,  104,  448,  449,
 /*  1470 */   390,  350,  392,  389,  400,  458,  104,  476,  450,  460,
 /*  1480 */   261,  410,  172,   49,  104,  104,  104,  378,  104,  426,
 /*  1490 */    20,  104,  103,  205,   50,  419,  424,  104,  358,  390,
 /*  1500 */   104,  392,  419,  104,  358,  425,  188,  427,  412,   42,
 /*  1510 */   430,  431,  432,  433,  434,  435,  397,  437,   20,  397,
 /*  1520 */   400,  169,  442,  190,  444,  192,  395,   20,  448,  449,
 /*  1530 */   349,  349,  397,  395,  425,  362,  427,  395,  101,  430,
 /*  1540 */   431,  432,  433,  434,  435,   99,  437,    4,  361,  349,
 /*  1550 */    98,  360,  349,  444,  192,  222,  223,  448,  449,  349,
 /*  1560 */   349,   20,   19,  342,   48,  340,  192,  419,  235,  236,
 /*  1570 */   237,  238,  239,  240,  241,  350,   33,  346,  342,  346,
 /*  1580 */   358,   20,  392,   20,   20,  358,  351,  411,  358,  351,
 /*  1590 */   358,  340,   49,  349,  342,  358,  378,  358,  358,   56,
 /*  1600 */   342,  350,  378,  378,  349,   62,  378,  378,  423,  209,
 /*  1610 */   421,  103,  378,  390,  419,  390,  356,  392,  196,  418,
 /*  1620 */   195,  417,  356,  378,  378,  340,  378,  378,  378,  378,
 /*  1630 */   194,  378,  416,  349,  268,  350,  465,  267,  468,  465,
 /*  1640 */   276,  390,  181,  392,  390,  102,  390,  467,  105,  392,
 /*  1650 */   425,  465,  427,  390,  278,  430,  431,  432,  433,  434,
 /*  1660 */   435,  390,  437,  378,  400,  400,  390,  405,  390,  444,
 /*  1670 */   464,  410,  405,  448,  449,  390,  425,  392,  427,  277,
 /*  1680 */   463,  430,  431,  432,  433,  434,  435,  340,  437,  262,
 /*  1690 */   410,  285,  484,  282,  280,  444,  258,  350,  350,   20,
 /*  1700 */   449,  429,  410,  349,  351,  356,  356,  403,   20,  174,
 /*  1710 */   425,  340,  427,  405,  390,  430,  431,  432,  433,  434,
 /*  1720 */   435,  350,  437,  402,  390,  378,  390,  390,  103,  390,
 /*  1730 */   383,  462,  405,  374,  356,  340,  477,  390,  350,  392,
 /*  1740 */   447,  390,  356,  103,   36,  350,  478,  390,  356,  378,
 /*  1750 */   382,  368,  349,  343,  383,  342,  471,  372,  413,  338,
 /*  1760 */     0,  390,  406,  392,  406,  357,  420,    0,    0,  372,
 /*  1770 */   372,   42,  425,  378,  427,   35,   35,  430,  431,  432,
 /*  1780 */   433,  434,  435,    0,  437,  390,  215,  392,   35,   35,
 /*  1790 */   215,    0,   35,   35,  215,    0,  425,  215,  427,  340,
 /*  1800 */     0,  430,  431,  432,  433,  434,  435,   35,  437,  350,
 /*  1810 */     0,   22,    0,   35,  210,    0,  198,    0,  198,  192,
 /*  1820 */   425,  199,  427,  190,    0,  430,  431,  432,  433,  434,
 /*  1830 */   435,    0,  437,    0,  186,  185,    0,  378,    0,   47,
 /*  1840 */     0,    0,  383,    0,   42,    0,    0,    0,    0,  390,
 /*  1850 */     0,  392,    0,    0,    0,  159,   35,    0,  159,    0,
 /*  1860 */     0,    0,    0,  340,   42,    0,    0,    0,    0,    0,
 /*  1870 */     0,   22,    0,  350,    0,    0,    0,  482,    0,    0,
 /*  1880 */     0,    0,    0,    0,  425,  340,  427,    0,    0,  430,
 /*  1890 */   431,  432,  433,  434,  435,  350,  437,    0,    0,    0,
 /*  1900 */     0,  378,  143,    0,   48,    0,   22,    0,   22,  340,
 /*  1910 */   112,   48,   35,  390,    0,  392,    0,   62,    0,  350,
 /*  1920 */    62,    0,   49,  378,   35,    0,   35,    0,  383,   39,
 /*  1930 */    35,   35,   39,   62,    0,  390,   14,  392,    0,    0,
 /*  1940 */    39,   49,    0,   49,   42,   39,    0,  378,  425,   40,
 /*  1950 */   427,   47,  383,  430,  431,  432,  433,  434,  435,  390,
 /*  1960 */   437,  392,  439,    1,   44,   39,   47,   39,  181,    0,
 /*  1970 */   425,   47,  427,    0,    0,  430,  431,  432,  433,  434,
 /*  1980 */   435,   19,  437,    0,   69,    0,   35,   39,    0,   49,
 /*  1990 */    35,   39,   49,    0,  425,   33,  427,  340,   35,  430,
 /*  2000 */   431,  432,  433,  434,  435,   49,  437,  350,    0,   39,
 /*  2010 */    35,   49,   35,   49,    0,   39,  340,    0,    0,   57,
 /*  2020 */    58,   59,   60,    0,   62,   22,  350,  340,    0,    0,
 /*  2030 */     0,   44,   35,  110,   35,  378,   35,  350,   44,   35,
 /*  2040 */    35,   35,   35,   22,   35,   35,   35,  390,    0,  392,
 /*  2050 */     0,   51,    0,   22,  378,   22,   22,   35,    0,   35,
 /*  2060 */     0,   35,    0,   22,  102,  378,  390,  105,  392,   20,
 /*  2070 */    35,   35,   35,    0,   35,  104,   22,  390,    0,  392,
 /*  2080 */   172,  103,  425,  103,  427,   22,  174,  430,  431,  432,
 /*  2090 */   433,  434,  435,    0,  437,  340,    0,    3,  263,   44,
 /*  2100 */   138,  425,  104,  427,  193,  350,  430,  431,  432,  433,
 /*  2110 */   434,  435,  425,  437,  427,  340,  172,  430,  431,  432,
 /*  2120 */   433,  434,  435,  103,  437,  350,  340,  197,  179,  172,
 /*  2130 */   103,   48,   48,  378,   44,  173,  350,    3,   47,  101,
 /*  2140 */   178,   99,   44,   44,  104,  390,  340,  392,  104,  103,
 /*  2150 */   103,   47,   44,  378,  103,   44,  350,  104,   35,  103,
 /*  2160 */   198,  104,   35,  104,  378,  390,   35,  392,   35,  104,
 /*  2170 */    35,   35,  104,   47,  257,   47,  390,    0,  392,    0,
 /*  2180 */   425,   44,  427,    0,  378,  430,  431,  432,  433,  434,
 /*  2190 */   435,    0,  437,   39,  263,  263,  390,   47,  392,  104,
 /*  2200 */   425,  104,  427,  103,  340,  430,  431,  432,  433,  434,
 /*  2210 */   435,  425,  437,  427,  350,  103,  430,  431,  432,  433,
 /*  2220 */   434,  435,  103,  437,  103,  340,    0,  103,   39,  113,
 /*  2230 */    44,  425,  103,  427,  173,  350,  430,  431,  432,  433,
 /*  2240 */   434,  435,  378,  437,  175,   47,  101,  101,    2,   22,
 /*  2250 */   340,  103,   47,  104,  390,  103,  392,  244,   47,  104,
 /*  2260 */   350,  103,  103,  378,  104,  222,  103,   22,  104,  224,
 /*  2270 */   103,  114,  104,   35,   35,  390,  340,  392,  103,   35,
 /*  2280 */   104,  103,   35,   35,  104,  103,  350,  103,  378,  425,
 /*  2290 */    35,  427,  104,  103,  430,  431,  432,  433,  434,  435,
 /*  2300 */   390,  437,  392,  104,  104,   35,  125,  103,   44,   35,
 /*  2310 */   425,  103,  427,  103,  378,  430,  431,  432,  433,  434,
 /*  2320 */   435,  125,  437,  103,   22,   69,  390,  125,  392,   68,
 /*  2330 */    35,  125,   35,   35,   35,  425,  340,  427,   35,   35,
 /*  2340 */   430,  431,  432,  433,  434,  435,  350,  437,   35,   35,
 /*  2350 */    75,   97,  340,   44,   35,   35,   35,   22,   35,   35,
 /*  2360 */    35,  425,  350,  427,   75,  340,  430,  431,  432,  433,
 /*  2370 */   434,  435,   35,  437,  378,  350,   35,   35,   35,   35,
 /*  2380 */    22,   35,    0,   35,   39,   49,  390,    0,  392,   35,
 /*  2390 */   378,   39,    0,    0,   35,   39,   49,   35,   49,   49,
 /*  2400 */    39,    0,  390,  378,  392,   35,   35,    0,   22,   21,
 /*  2410 */   485,   22,   22,  485,   20,  390,   21,  392,  485,  485,
 /*  2420 */   485,  425,  485,  427,  485,  340,  430,  431,  432,  433,
 /*  2430 */   434,  435,  485,  437,  485,  350,  485,  425,  485,  427,
 /*  2440 */   485,  340,  430,  431,  432,  433,  434,  435,  485,  437,
 /*  2450 */   425,  350,  427,  485,  340,  430,  431,  432,  433,  434,
 /*  2460 */   435,  485,  437,  378,  350,  485,  485,  485,  485,  485,
 /*  2470 */   485,  485,  485,  485,  485,  390,  485,  392,  485,  378,
 /*  2480 */   485,  485,  485,  485,  485,  485,  485,  485,  485,  485,
 /*  2490 */   485,  390,  378,  392,  485,  485,  485,  485,  485,  485,
 /*  2500 */   485,  485,  485,  485,  390,  485,  392,  485,  485,  485,
 /*  2510 */   425,  485,  427,  485,  485,  430,  431,  432,  433,  434,
 /*  2520 */   435,  485,  437,  485,  485,  485,  425,  340,  427,  485,
 /*  2530 */   485,  430,  431,  432,  433,  434,  435,  350,  437,  425,
 /*  2540 */   485,  427,  485,  340,  430,  431,  432,  433,  434,  435,
 /*  2550 */   485,  437,  485,  350,  340,  485,  485,  485,  485,  485,
 /*  2560 */   485,  485,  485,  485,  350,  378,  485,  485,  485,  485,
 /*  2570 */   485,  485,  485,  485,  485,  485,  485,  390,  485,  392,
 /*  2580 */   485,  378,  485,  485,  485,  485,  485,  485,  485,  485,
 /*  2590 */   485,  485,  378,  390,  485,  392,  485,  485,  485,  485,
 /*  2600 */   485,  485,  485,  485,  390,  485,  392,  485,  485,  485,
 /*  2610 */   485,  485,  425,  485,  427,  485,  340,  430,  431,  432,
 /*  2620 */   433,  434,  435,  485,  437,  485,  350,  485,  425,  485,
 /*  2630 */   427,  485,  340,  430,  431,  432,  433,  434,  435,  425,
 /*  2640 */   437,  427,  350,  485,  430,  431,  432,  433,  434,  435,
 /*  2650 */   485,  437,  485,  485,  378,  485,  485,  485,  485,  485,
 /*  2660 */   485,  485,  485,  485,  485,  485,  390,  485,  392,  485,
 /*  2670 */   378,  485,  485,  485,  485,  485,  485,  485,  485,  485,
 /*  2680 */   485,  485,  390,  485,  392,  485,  485,  485,  485,  485,
 /*  2690 */   485,  485,  485,  485,  485,  485,  485,  485,  485,  485,
 /*  2700 */   485,  425,  485,  427,  485,  485,  430,  431,  432,  433,
 /*  2710 */   434,  435,  485,  437,  485,  485,  485,  425,  485,  427,
 /*  2720 */   485,  485,  430,  431,  432,  433,  434,  435,  485,  437,
 /*  2730 */   485,  485,  485,  485,  485,  485,  485,  485,  485,  485,
 /*  2740 */   485,  485,  485,  485,  485,  485,  485,  485,  485,  485,
 /*  2750 */   485,  485,  485,  485,  337,  337,  337,  337,  337,  337,
 /*  2760 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2770 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2780 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2790 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2800 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2810 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2820 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2830 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2840 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2850 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2860 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2870 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2880 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2890 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2900 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2910 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2920 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2930 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2940 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2950 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2960 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2970 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2980 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2990 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  3000 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  3010 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  3020 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  3030 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  3040 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  3050 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  3060 */   337,  337,  337,  337,  337,  337,  337,
};
#define YY_SHIFT_COUNT    (793)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2407)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1097,    0,  104,    0,  336,  336,  336,  336,  336,  336,
 /*    10 */   336,  336,  336,  336,  336,  336,  440,  671,  671,  775,
 /*    20 */   671,  671,  671,  671,  671,  671,  671,  671,  671,  671,
 /*    30 */   671,  671,  671,  671,  671,  671,  671,  671,  671,  671,
 /*    40 */   671,  671,  671,  671,  671,  671,  671,  671,  671,  671,
 /*    50 */   671,  335,  519, 1053,  263,  215,  156,  586,  156,  263,
 /*    60 */   263, 1333,  156, 1333, 1333,  621,  156,   34,  798,  111,
 /*    70 */   111,  798,  278,  278,  294,  138,  308,  308,  111,  111,
 /*    80 */   111,  111,  111,  111,  111,  199,  111,  111,  297,   34,
 /*    90 */   111,  111,  223,  111,   34,  111,  199,  111,  199,   34,
 /*   100 */   111,  111,   34,  111,   34,   34,   34,  111,  460,  917,
 /*   110 */    15,   15,  378,  170,  700,  700,  700,  700,  700,  700,
 /*   120 */   700,  700,  700,  700,  700,  700,  700,  700,  700,  700,
 /*   130 */   700,  700,  700,  326,  410,  294,  138,  633,  633,  714,
 /*   140 */   426,  426,  426,  618,  107,  107,  714,  299,  299,  299,
 /*   150 */   297,  356,  353,   34,  577,   34,  577,  577,  663,  730,
 /*   160 */   259,  259,  259,  259,  259,  259,  259,  259, 1962, 1116,
 /*   170 */   185,   31,  276,  249,  394,  176,   13,   13,  862, 1073,
 /*   180 */   489,  776, 1167,  949,  721,  820,  996,  355,  581,  996,
 /*   190 */   997, 1081,  256, 1219, 1434, 1470, 1288,  297, 1470,  297,
 /*   200 */  1318, 1467, 1498, 1467, 1352, 1507, 1507, 1467, 1352, 1352,
 /*   210 */  1437, 1446, 1507, 1452, 1507, 1507, 1507, 1541, 1516, 1541,
 /*   220 */  1516, 1470,  297, 1561,  297, 1563, 1564,  297, 1563,  297,
 /*   230 */   297,  297, 1507,  297, 1541,   34,   34,   34,   34,   34,
 /*   240 */    34,   34,   34,   34,   34,   34, 1507, 1541,  577,  577,
 /*   250 */   577, 1400, 1508, 1470,  460, 1422, 1425, 1561,  460, 1436,
 /*   260 */  1219, 1507, 1498, 1498,  577, 1366, 1370,  577, 1366, 1370,
 /*   270 */   577,  577,   34, 1364, 1461, 1366, 1376, 1402, 1427, 1219,
 /*   280 */  1406, 1411, 1414, 1438,  299, 1679, 1219, 1507, 1563,  460,
 /*   290 */   460, 1688, 1370,  577,  577,  577,  577,  577, 1370,  577,
 /*   300 */  1535,  460,  663,  460,  299, 1625, 1640,  577,  730, 1507,
 /*   310 */   460, 1708, 1541, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
 /*   320 */  2730, 2730, 1018,  679,  224,  739, 1543,  858, 1041,  418,
 /*   330 */   748,  974, 1110, 1166, 1377, 1377, 1377, 1377, 1377, 1377,
 /*   340 */  1377, 1377, 1377,  500,  729,   51,   51,  441,  484,  446,
 /*   350 */   660,   76,  121,  699,  593,  291,  924,  924,  701,  536,
 /*   360 */   952,  701,  701,  701,  384, 1060, 1093, 1095, 1291, 1220,
 /*   370 */   765, 1241, 1242, 1243, 1247,  566,  688, 1340, 1342, 1365,
 /*   380 */  1087, 1319, 1323, 1226, 1325, 1328, 1330, 1274, 1157, 1183,
 /*   390 */  1310, 1331, 1338, 1344, 1361, 1363, 1372, 1420, 1380, 1101,
 /*   400 */  1381, 1389, 1382, 1384, 1387, 1393, 1396, 1399, 1343, 1362,
 /*   410 */  1374, 1426, 1428,  723, 1444, 1760, 1767, 1768, 1729, 1783,
 /*   420 */  1740, 1571, 1741, 1753, 1754, 1575, 1791, 1757, 1758, 1579,
 /*   430 */  1795, 1582, 1800, 1772, 1810, 1789, 1812, 1778, 1604, 1815,
 /*   440 */  1618, 1817, 1620, 1622, 1627, 1633, 1824, 1831, 1833, 1648,
 /*   450 */  1650, 1836, 1838, 1792, 1840, 1841, 1843, 1802, 1845, 1846,
 /*   460 */  1847, 1848, 1850, 1852, 1853, 1854, 1696, 1821, 1857, 1699,
 /*   470 */  1859, 1860, 1861, 1862, 1874, 1875, 1876, 1878, 1879, 1880,
 /*   480 */  1881, 1882, 1883, 1887, 1888, 1897, 1822, 1865, 1866, 1867,
 /*   490 */  1868, 1869, 1870, 1849, 1872, 1898, 1899, 1759, 1900, 1903,
 /*   500 */  1884, 1856, 1886, 1863, 1905, 1855, 1877, 1907, 1858, 1914,
 /*   510 */  1871, 1916, 1918, 1889, 1873, 1890, 1921, 1891, 1892, 1893,
 /*   520 */  1925, 1895, 1894, 1901, 1927, 1896, 1934, 1902, 1906, 1920,
 /*   530 */  1904, 1919, 1922, 1924, 1938, 1909, 1926, 1939, 1942, 1946,
 /*   540 */  1928, 1787, 1969, 1973, 1974, 1915, 1983, 1985, 1951, 1940,
 /*   550 */  1948, 1988, 1955, 1943, 1952, 1993, 1963, 1956, 1970, 2008,
 /*   560 */  1975, 1964, 1976, 2014, 2017, 2018, 2023, 2028, 2029, 1798,
 /*   570 */  1923, 1977, 2003, 2030, 1997, 1999, 2001, 2004, 2005, 2006,
 /*   580 */  2007, 1987, 1994, 2009, 2010, 2021, 2011, 2048, 2031, 2050,
 /*   590 */  2033, 2000, 2052, 2034, 2022, 2058, 2024, 2060, 2026, 2062,
 /*   600 */  2041, 2049, 2035, 2036, 2037, 1971, 1978, 2073, 1908, 1980,
 /*   610 */  1930, 2039, 2054, 2078, 1911, 2063, 1944, 1912, 2093, 2096,
 /*   620 */  1957, 1949, 2094, 2055, 1835, 2020, 1998, 2027, 2083, 2038,
 /*   630 */  2084, 2042, 2040, 2090, 2098, 2044, 2046, 2047, 2051, 2053,
 /*   640 */  2099, 2091, 2104, 2056, 2108, 1931, 2057, 2059, 2134, 2111,
 /*   650 */  1932, 2123, 2127, 2131, 2133, 2135, 2136, 2065, 2068, 2126,
 /*   660 */  1917, 2137, 2128, 2177, 2179, 2183, 2191, 2100, 2154, 1904,
 /*   670 */  2150, 2112, 2095, 2097, 2119, 2121, 2069, 2124, 2226, 2189,
 /*   680 */  2061, 2129, 2116, 1904, 2198, 2186, 2145, 2013, 2146, 2246,
 /*   690 */  2227, 2043, 2148, 2149, 2152, 2155, 2158, 2160, 2205, 2159,
 /*   700 */  2163, 2211, 2164, 2245, 2045, 2167, 2157, 2168, 2238, 2239,
 /*   710 */  2175, 2176, 2244, 2178, 2180, 2247, 2182, 2188, 2248, 2184,
 /*   720 */  2199, 2255, 2190, 2200, 2270, 2204, 2181, 2196, 2202, 2206,
 /*   730 */  2208, 2264, 2210, 2274, 2220, 2264, 2264, 2302, 2256, 2261,
 /*   740 */  2295, 2297, 2298, 2299, 2303, 2304, 2313, 2314, 2275, 2254,
 /*   750 */  2309, 2319, 2320, 2321, 2335, 2323, 2324, 2325, 2289, 1987,
 /*   760 */  2337, 1994, 2341, 2342, 2343, 2344, 2358, 2346, 2382, 2348,
 /*   770 */  2336, 2345, 2387, 2354, 2347, 2352, 2392, 2359, 2349, 2356,
 /*   780 */  2393, 2362, 2350, 2361, 2401, 2370, 2371, 2407, 2386, 2388,
 /*   790 */  2389, 2390, 2395, 2394,
};
#define YY_REDUCE_COUNT (321)
#define YY_REDUCE_MIN   (-438)
#define YY_REDUCE_MAX   (2292)
static const short yy_reduce_ofst[] = {
 /*     0 */   311, -340, -280,  -25, -132,  158,  603,  789,  895,  969,
 /*    10 */   265, 1020, 1080,  390, 1109, 1225,   53,  454,  825, 1251,
 /*    20 */  1285, 1347, 1371,  946, 1395, 1459, 1523, 1545, 1569, 1657,
 /*    30 */  1676, 1687, 1755, 1775, 1786, 1806, 1864, 1885, 1910, 1936,
 /*    40 */  1996, 2012, 2025, 2085, 2101, 2114, 2187, 2203, 2214, 2276,
 /*    50 */  2292,  167,  792, -403,   78, -401, -360,  252,  672,   47,
 /*    60 */   197,  379, -438, -244,  339, -331,  505, -211, -274,  -63,
 /*    70 */    23, -391,  -40,  149, -317,  -31, -342, -265,  295,  464,
 /*    80 */   486,  571,  608,  610,  622, -344,  673,  675, -252, -205,
 /*    90 */   677,  805, -243,  809,  219,  822,  -92,  833,   19,  -16,
 /*   100 */   423,  840,  325,  880,  563,  755,  891,  914, -268, -207,
 /*   110 */  -173, -173,  327, -337, -321, -229,  -93,   61,  209,  403,
 /*   120 */   439,  461,  529,  630,  746,  802,  828,  844,  856,  885,
 /*   130 */   888,  900,  901, -288,  -34, -213,   90,  448,  476,  554,
 /*   140 */   -34,   50,  501,  247, -409,  301,  780,  499,  533,  582,
 /*   150 */   769,  234,  422,  643,  609,  549,  786,  878,  918,  945,
 /*   160 */  -364,  447,  477,  535,  547,  575,  615,  547,  628,  681,
 /*   170 */   791,  662,  667,  685,  811,  745,  814,  866,  892,  892,
 /*   180 */   883,  894, 1112, 1121, 1084, 1074, 1017, 1017, 1001, 1017,
 /*   190 */  1028, 1019,  892, 1071, 1063, 1076, 1072, 1140, 1083, 1146,
 /*   200 */  1096, 1119, 1120, 1122, 1131, 1181, 1182, 1135, 1138, 1142,
 /*   210 */  1173, 1187, 1200, 1191, 1203, 1210, 1211, 1221, 1231, 1236,
 /*   220 */  1233, 1148, 1222, 1190, 1227, 1235, 1176, 1230, 1238, 1232,
 /*   230 */  1237, 1239, 1244, 1240, 1252, 1218, 1224, 1228, 1229, 1234,
 /*   240 */  1245, 1246, 1248, 1249, 1250, 1253, 1255, 1258, 1223, 1254,
 /*   250 */  1256, 1185, 1189, 1195, 1260, 1201, 1204, 1257, 1266, 1216,
 /*   260 */  1261, 1284, 1264, 1265, 1263, 1171, 1262, 1271, 1174, 1267,
 /*   270 */  1276, 1278,  892, 1170, 1180, 1186, 1206, 1217, 1269, 1280,
 /*   280 */  1208, 1268, 1259, 1017, 1348, 1272, 1292, 1354, 1353, 1349,
 /*   290 */  1350, 1304, 1308, 1324, 1334, 1336, 1337, 1339, 1327, 1351,
 /*   300 */  1321, 1378, 1359, 1386, 1388, 1293, 1368, 1357, 1383, 1403,
 /*   310 */  1392, 1410, 1413, 1345, 1346, 1356, 1358, 1385, 1397, 1398,
 /*   320 */  1408, 1421,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*    10 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*    20 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*    30 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*    40 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*    50 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*    60 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*    70 */  1768, 1768, 1768, 1768, 2049, 1768, 1768, 1768, 1768, 1768,
 /*    80 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1857, 1768,
 /*    90 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   100 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1855, 2042,
 /*   110 */  2267, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   120 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   130 */  1768, 1768, 1768, 1768, 2279, 1768, 1768, 1831, 1831, 1768,
 /*   140 */  2279, 2279, 2279, 1855, 2239, 2239, 1768, 1768, 1768, 1768,
 /*   150 */  1857, 2109, 1768, 1768, 1768, 1768, 1768, 1768, 1977, 1768,
 /*   160 */  1768, 1768, 1768, 1768, 2001, 1768, 1768, 1768, 2101, 1768,
 /*   170 */  1768, 2304, 2361, 1768, 1768, 2307, 1768, 1768, 1768, 1768,
 /*   180 */  1768, 2054, 1768, 1768, 1930, 2294, 2271, 2285, 2345, 2272,
 /*   190 */  2269, 2288, 1768, 2298, 1768, 1768, 2123, 1857, 1768, 1857,
 /*   200 */  2088, 2047, 1768, 2047, 2044, 1768, 1768, 2047, 2044, 2044,
 /*   210 */  1919, 1915, 1768, 1913, 1768, 1768, 1768, 1768, 1815, 1768,
 /*   220 */  1815, 1768, 1857, 1768, 1857, 1768, 1768, 1857, 1768, 1857,
 /*   230 */  1857, 1857, 1768, 1857, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   240 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   250 */  1768, 2121, 2107, 1768, 1855, 2099, 2097, 1768, 1855, 2095,
 /*   260 */  2298, 1768, 1768, 1768, 1768, 2315, 2313, 1768, 2315, 2313,
 /*   270 */  1768, 1768, 1768, 2329, 2325, 2315, 2334, 2331, 2300, 2298,
 /*   280 */  2364, 2351, 2347, 2285, 1768, 1768, 2298, 1768, 1768, 1855,
 /*   290 */  1855, 1768, 2313, 1768, 1768, 1768, 1768, 1768, 2313, 1768,
 /*   300 */  1768, 1855, 1768, 1855, 1768, 1768, 1946, 1768, 1768, 1768,
 /*   310 */  1855, 1800, 1768, 2090, 2112, 2072, 2072, 1980, 1980, 1980,
 /*   320 */  1858, 1773, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   330 */  1768, 1768, 1768, 1768, 2328, 2327, 2194, 1768, 2243, 2242,
 /*   340 */  2241, 2232, 2193, 1942, 1768, 2192, 2191, 1768, 1768, 1768,
 /*   350 */  1768, 1768, 1768, 1768, 1768, 1768, 2063, 2062, 2185, 1768,
 /*   360 */  1768, 2186, 2184, 2183, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   370 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   380 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 2348, 2352,
 /*   390 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 2268, 1768, 1768,
 /*   400 */  1768, 2167, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   410 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   420 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   430 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   440 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   450 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   460 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   470 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   480 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   490 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   500 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   510 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   520 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1805,
 /*   530 */  2172, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   540 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   550 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   560 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   570 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   580 */  1768, 1896, 1895, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   590 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   600 */  1768, 1768, 1768, 1768, 1768, 2176, 1768, 1768, 1768, 1768,
 /*   610 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   620 */  1768, 1768, 2344, 2301, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   630 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   640 */  1768, 1768, 2167, 1768, 2326, 1768, 1768, 2342, 1768, 2346,
 /*   650 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 2278, 2274, 1768,
 /*   660 */  1768, 2270, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 2175,
 /*   670 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   680 */  1768, 1768, 1768, 2166, 1768, 2229, 1768, 1768, 1768, 2263,
 /*   690 */  1768, 1768, 2214, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   700 */  1768, 1768, 2176, 1768, 2179, 1768, 1768, 1768, 1768, 1768,
 /*   710 */  1974, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   720 */  1768, 1768, 1768, 1768, 1768, 1768, 1958, 1956, 1955, 1954,
 /*   730 */  1768, 1987, 1768, 1768, 1768, 1983, 1982, 1768, 1768, 1768,
 /*   740 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   750 */  1876, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1868,
 /*   760 */  1768, 1867, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   770 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   780 */  1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768, 1768,
 /*   790 */  1768, 1768, 1768, 1768,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*       WITH => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /*    RESTORE => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*     UNSAFE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*      VNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*  TIMESTAMP => nothing */
  286,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*   GEOMETRY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*   LANGUAGE => nothing */
    0,  /*    REPLACE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*      PAUSE => nothing */
    0,  /*     RESUME => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*  UNTREATED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*     LEADER => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  286,  /*      AFTER => ABORT */
  286,  /*     ATTACH => ABORT */
  286,  /*     BEFORE => ABORT */
  286,  /*      BEGIN => ABORT */
  286,  /*     BITAND => ABORT */
  286,  /*     BITNOT => ABORT */
  286,  /*      BITOR => ABORT */
  286,  /*     BLOCKS => ABORT */
  286,  /*     CHANGE => ABORT */
  286,  /*      COMMA => ABORT */
  286,  /*     CONCAT => ABORT */
  286,  /*   CONFLICT => ABORT */
  286,  /*       COPY => ABORT */
  286,  /*   DEFERRED => ABORT */
  286,  /* DELIMITERS => ABORT */
  286,  /*     DETACH => ABORT */
  286,  /*     DIVIDE => ABORT */
  286,  /*        DOT => ABORT */
  286,  /*       EACH => ABORT */
  286,  /*       FAIL => ABORT */
  286,  /*       FILE => ABORT */
  286,  /*        FOR => ABORT */
  286,  /*       GLOB => ABORT */
  286,  /*         ID => ABORT */
  286,  /*  IMMEDIATE => ABORT */
  286,  /*     IMPORT => ABORT */
  286,  /*  INITIALLY => ABORT */
  286,  /*    INSTEAD => ABORT */
  286,  /*     ISNULL => ABORT */
  286,  /*        KEY => ABORT */
  286,  /*    MODULES => ABORT */
  286,  /*  NK_BITNOT => ABORT */
  286,  /*    NK_SEMI => ABORT */
  286,  /*    NOTNULL => ABORT */
  286,  /*         OF => ABORT */
  286,  /*       PLUS => ABORT */
  286,  /*  PRIVILEGE => ABORT */
  286,  /*      RAISE => ABORT */
  286,  /*   RESTRICT => ABORT */
  286,  /*        ROW => ABORT */
  286,  /*       SEMI => ABORT */
  286,  /*       STAR => ABORT */
  286,  /*  STATEMENT => ABORT */
  286,  /*     STRICT => ABORT */
  286,  /*     STRING => ABORT */
  286,  /*      TIMES => ABORT */
  286,  /*     VALUES => ABORT */
  286,  /*   VARIABLE => ABORT */
  286,  /*       VIEW => ABORT */
  286,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "WITH",
  /*   49 */ "DNODE",
  /*   50 */ "PORT",
  /*   51 */ "DNODES",
  /*   52 */ "RESTORE",
  /*   53 */ "NK_IPTOKEN",
  /*   54 */ "FORCE",
  /*   55 */ "UNSAFE",
  /*   56 */ "LOCAL",
  /*   57 */ "QNODE",
  /*   58 */ "BNODE",
  /*   59 */ "SNODE",
  /*   60 */ "MNODE",
  /*   61 */ "VNODE",
  /*   62 */ "DATABASE",
  /*   63 */ "USE",
  /*   64 */ "FLUSH",
  /*   65 */ "TRIM",
  /*   66 */ "COMPACT",
  /*   67 */ "IF",
  /*   68 */ "NOT",
  /*   69 */ "EXISTS",
  /*   70 */ "BUFFER",
  /*   71 */ "CACHEMODEL",
  /*   72 */ "CACHESIZE",
  /*   73 */ "COMP",
  /*   74 */ "DURATION",
  /*   75 */ "NK_VARIABLE",
  /*   76 */ "MAXROWS",
  /*   77 */ "MINROWS",
  /*   78 */ "KEEP",
  /*   79 */ "PAGES",
  /*   80 */ "PAGESIZE",
  /*   81 */ "TSDB_PAGESIZE",
  /*   82 */ "PRECISION",
  /*   83 */ "REPLICA",
  /*   84 */ "VGROUPS",
  /*   85 */ "SINGLE_STABLE",
  /*   86 */ "RETENTIONS",
  /*   87 */ "SCHEMALESS",
  /*   88 */ "WAL_LEVEL",
  /*   89 */ "WAL_FSYNC_PERIOD",
  /*   90 */ "WAL_RETENTION_PERIOD",
  /*   91 */ "WAL_RETENTION_SIZE",
  /*   92 */ "WAL_ROLL_PERIOD",
  /*   93 */ "WAL_SEGMENT_SIZE",
  /*   94 */ "STT_TRIGGER",
  /*   95 */ "TABLE_PREFIX",
  /*   96 */ "TABLE_SUFFIX",
  /*   97 */ "NK_COLON",
  /*   98 */ "MAX_SPEED",
  /*   99 */ "START",
  /*  100 */ "TIMESTAMP",
  /*  101 */ "END",
  /*  102 */ "TABLE",
  /*  103 */ "NK_LP",
  /*  104 */ "NK_RP",
  /*  105 */ "STABLE",
  /*  106 */ "ADD",
  /*  107 */ "COLUMN",
  /*  108 */ "MODIFY",
  /*  109 */ "RENAME",
  /*  110 */ "TAG",
  /*  111 */ "SET",
  /*  112 */ "NK_EQ",
  /*  113 */ "USING",
  /*  114 */ "TAGS",
  /*  115 */ "BOOL",
  /*  116 */ "TINYINT",
  /*  117 */ "SMALLINT",
  /*  118 */ "INT",
  /*  119 */ "INTEGER",
  /*  120 */ "BIGINT",
  /*  121 */ "FLOAT",
  /*  122 */ "DOUBLE",
  /*  123 */ "BINARY",
  /*  124 */ "NCHAR",
  /*  125 */ "UNSIGNED",
  /*  126 */ "JSON",
  /*  127 */ "VARCHAR",
  /*  128 */ "MEDIUMBLOB",
  /*  129 */ "BLOB",
  /*  130 */ "VARBINARY",
  /*  131 */ "GEOMETRY",
  /*  132 */ "DECIMAL",
  /*  133 */ "COMMENT",
  /*  134 */ "MAX_DELAY",
  /*  135 */ "WATERMARK",
  /*  136 */ "ROLLUP",
  /*  137 */ "TTL",
  /*  138 */ "SMA",
  /*  139 */ "DELETE_MARK",
  /*  140 */ "FIRST",
  /*  141 */ "LAST",
  /*  142 */ "SHOW",
  /*  143 */ "PRIVILEGES",
  /*  144 */ "DATABASES",
  /*  145 */ "TABLES",
  /*  146 */ "STABLES",
  /*  147 */ "MNODES",
  /*  148 */ "QNODES",
  /*  149 */ "FUNCTIONS",
  /*  150 */ "INDEXES",
  /*  151 */ "ACCOUNTS",
  /*  152 */ "APPS",
  /*  153 */ "CONNECTIONS",
  /*  154 */ "LICENCES",
  /*  155 */ "GRANTS",
  /*  156 */ "QUERIES",
  /*  157 */ "SCORES",
  /*  158 */ "TOPICS",
  /*  159 */ "VARIABLES",
  /*  160 */ "CLUSTER",
  /*  161 */ "BNODES",
  /*  162 */ "SNODES",
  /*  163 */ "TRANSACTIONS",
  /*  164 */ "DISTRIBUTED",
  /*  165 */ "CONSUMERS",
  /*  166 */ "SUBSCRIPTIONS",
  /*  167 */ "VNODES",
  /*  168 */ "ALIVE",
  /*  169 */ "LIKE",
  /*  170 */ "TBNAME",
  /*  171 */ "QTAGS",
  /*  172 */ "AS",
  /*  173 */ "INDEX",
  /*  174 */ "FUNCTION",
  /*  175 */ "INTERVAL",
  /*  176 */ "COUNT",
  /*  177 */ "LAST_ROW",
  /*  178 */ "TOPIC",
  /*  179 */ "META",
  /*  180 */ "CONSUMER",
  /*  181 */ "GROUP",
  /*  182 */ "DESC",
  /*  183 */ "DESCRIBE",
  /*  184 */ "RESET",
  /*  185 */ "QUERY",
  /*  186 */ "CACHE",
  /*  187 */ "EXPLAIN",
  /*  188 */ "ANALYZE",
  /*  189 */ "VERBOSE",
  /*  190 */ "NK_BOOL",
  /*  191 */ "RATIO",
  /*  192 */ "NK_FLOAT",
  /*  193 */ "OUTPUTTYPE",
  /*  194 */ "AGGREGATE",
  /*  195 */ "BUFSIZE",
  /*  196 */ "LANGUAGE",
  /*  197 */ "REPLACE",
  /*  198 */ "STREAM",
  /*  199 */ "INTO",
  /*  200 */ "PAUSE",
  /*  201 */ "RESUME",
  /*  202 */ "TRIGGER",
  /*  203 */ "AT_ONCE",
  /*  204 */ "WINDOW_CLOSE",
  /*  205 */ "IGNORE",
  /*  206 */ "EXPIRED",
  /*  207 */ "FILL_HISTORY",
  /*  208 */ "UPDATE",
  /*  209 */ "SUBTABLE",
  /*  210 */ "UNTREATED",
  /*  211 */ "KILL",
  /*  212 */ "CONNECTION",
  /*  213 */ "TRANSACTION",
  /*  214 */ "BALANCE",
  /*  215 */ "VGROUP",
  /*  216 */ "LEADER",
  /*  217 */ "MERGE",
  /*  218 */ "REDISTRIBUTE",
  /*  219 */ "SPLIT",
  /*  220 */ "DELETE",
  /*  221 */ "INSERT",
  /*  222 */ "NULL",
  /*  223 */ "NK_QUESTION",
  /*  224 */ "NK_ARROW",
  /*  225 */ "ROWTS",
  /*  226 */ "QSTART",
  /*  227 */ "QEND",
  /*  228 */ "QDURATION",
  /*  229 */ "WSTART",
  /*  230 */ "WEND",
  /*  231 */ "WDURATION",
  /*  232 */ "IROWTS",
  /*  233 */ "ISFILLED",
  /*  234 */ "CAST",
  /*  235 */ "NOW",
  /*  236 */ "TODAY",
  /*  237 */ "TIMEZONE",
  /*  238 */ "CLIENT_VERSION",
  /*  239 */ "SERVER_VERSION",
  /*  240 */ "SERVER_STATUS",
  /*  241 */ "CURRENT_USER",
  /*  242 */ "CASE",
  /*  243 */ "WHEN",
  /*  244 */ "THEN",
  /*  245 */ "ELSE",
  /*  246 */ "BETWEEN",
  /*  247 */ "IS",
  /*  248 */ "NK_LT",
  /*  249 */ "NK_GT",
  /*  250 */ "NK_LE",
  /*  251 */ "NK_GE",
  /*  252 */ "NK_NE",
  /*  253 */ "MATCH",
  /*  254 */ "NMATCH",
  /*  255 */ "CONTAINS",
  /*  256 */ "IN",
  /*  257 */ "JOIN",
  /*  258 */ "INNER",
  /*  259 */ "SELECT",
  /*  260 */ "DISTINCT",
  /*  261 */ "WHERE",
  /*  262 */ "PARTITION",
  /*  263 */ "BY",
  /*  264 */ "SESSION",
  /*  265 */ "STATE_WINDOW",
  /*  266 */ "EVENT_WINDOW",
  /*  267 */ "SLIDING",
  /*  268 */ "FILL",
  /*  269 */ "VALUE",
  /*  270 */ "VALUE_F",
  /*  271 */ "NONE",
  /*  272 */ "PREV",
  /*  273 */ "NULL_F",
  /*  274 */ "LINEAR",
  /*  275 */ "NEXT",
  /*  276 */ "HAVING",
  /*  277 */ "RANGE",
  /*  278 */ "EVERY",
  /*  279 */ "ORDER",
  /*  280 */ "SLIMIT",
  /*  281 */ "SOFFSET",
  /*  282 */ "LIMIT",
  /*  283 */ "OFFSET",
  /*  284 */ "ASC",
  /*  285 */ "NULLS",
  /*  286 */ "ABORT",
  /*  287 */ "AFTER",
  /*  288 */ "ATTACH",
  /*  289 */ "BEFORE",
  /*  290 */ "BEGIN",
  /*  291 */ "BITAND",
  /*  292 */ "BITNOT",
  /*  293 */ "BITOR",
  /*  294 */ "BLOCKS",
  /*  295 */ "CHANGE",
  /*  296 */ "COMMA",
  /*  297 */ "CONCAT",
  /*  298 */ "CONFLICT",
  /*  299 */ "COPY",
  /*  300 */ "DEFERRED",
  /*  301 */ "DELIMITERS",
  /*  302 */ "DETACH",
  /*  303 */ "DIVIDE",
  /*  304 */ "DOT",
  /*  305 */ "EACH",
  /*  306 */ "FAIL",
  /*  307 */ "FILE",
  /*  308 */ "FOR",
  /*  309 */ "GLOB",
  /*  310 */ "ID",
  /*  311 */ "IMMEDIATE",
  /*  312 */ "IMPORT",
  /*  313 */ "INITIALLY",
  /*  314 */ "INSTEAD",
  /*  315 */ "ISNULL",
  /*  316 */ "KEY",
  /*  317 */ "MODULES",
  /*  318 */ "NK_BITNOT",
  /*  319 */ "NK_SEMI",
  /*  320 */ "NOTNULL",
  /*  321 */ "OF",
  /*  322 */ "PLUS",
  /*  323 */ "PRIVILEGE",
  /*  324 */ "RAISE",
  /*  325 */ "RESTRICT",
  /*  326 */ "ROW",
  /*  327 */ "SEMI",
  /*  328 */ "STAR",
  /*  329 */ "STATEMENT",
  /*  330 */ "STRICT",
  /*  331 */ "STRING",
  /*  332 */ "TIMES",
  /*  333 */ "VALUES",
  /*  334 */ "VARIABLE",
  /*  335 */ "VIEW",
  /*  336 */ "WAL",
  /*  337 */ "cmd",
  /*  338 */ "account_options",
  /*  339 */ "alter_account_options",
  /*  340 */ "literal",
  /*  341 */ "alter_account_option",
  /*  342 */ "user_name",
  /*  343 */ "sysinfo_opt",
  /*  344 */ "privileges",
  /*  345 */ "priv_level",
  /*  346 */ "with_opt",
  /*  347 */ "priv_type_list",
  /*  348 */ "priv_type",
  /*  349 */ "db_name",
  /*  350 */ "table_name",
  /*  351 */ "topic_name",
  /*  352 */ "search_condition",
  /*  353 */ "dnode_endpoint",
  /*  354 */ "force_opt",
  /*  355 */ "unsafe_opt",
  /*  356 */ "not_exists_opt",
  /*  357 */ "db_options",
  /*  358 */ "exists_opt",
  /*  359 */ "alter_db_options",
  /*  360 */ "speed_opt",
  /*  361 */ "start_opt",
  /*  362 */ "end_opt",
  /*  363 */ "integer_list",
  /*  364 */ "variable_list",
  /*  365 */ "retention_list",
  /*  366 */ "signed",
  /*  367 */ "alter_db_option",
  /*  368 */ "retention",
  /*  369 */ "full_table_name",
  /*  370 */ "column_def_list",
  /*  371 */ "tags_def_opt",
  /*  372 */ "table_options",
  /*  373 */ "multi_create_clause",
  /*  374 */ "tags_def",
  /*  375 */ "multi_drop_clause",
  /*  376 */ "alter_table_clause",
  /*  377 */ "alter_table_options",
  /*  378 */ "column_name",
  /*  379 */ "type_name",
  /*  380 */ "signed_literal",
  /*  381 */ "create_subtable_clause",
  /*  382 */ "specific_cols_opt",
  /*  383 */ "expression_list",
  /*  384 */ "drop_table_clause",
  /*  385 */ "col_name_list",
  /*  386 */ "column_def",
  /*  387 */ "duration_list",
  /*  388 */ "rollup_func_list",
  /*  389 */ "alter_table_option",
  /*  390 */ "duration_literal",
  /*  391 */ "rollup_func_name",
  /*  392 */ "function_name",
  /*  393 */ "col_name",
  /*  394 */ "db_name_cond_opt",
  /*  395 */ "like_pattern_opt",
  /*  396 */ "table_name_cond",
  /*  397 */ "from_db_opt",
  /*  398 */ "tag_list_opt",
  /*  399 */ "tag_item",
  /*  400 */ "column_alias",
  /*  401 */ "full_index_name",
  /*  402 */ "index_options",
  /*  403 */ "index_name",
  /*  404 */ "func_list",
  /*  405 */ "sliding_opt",
  /*  406 */ "sma_stream_opt",
  /*  407 */ "func",
  /*  408 */ "sma_func_name",
  /*  409 */ "query_or_subquery",
  /*  410 */ "where_clause_opt",
  /*  411 */ "cgroup_name",
  /*  412 */ "analyze_opt",
  /*  413 */ "explain_options",
  /*  414 */ "insert_query",
  /*  415 */ "or_replace_opt",
  /*  416 */ "agg_func_opt",
  /*  417 */ "bufsize_opt",
  /*  418 */ "language_opt",
  /*  419 */ "stream_name",
  /*  420 */ "stream_options",
  /*  421 */ "col_list_opt",
  /*  422 */ "tag_def_or_ref_opt",
  /*  423 */ "subtable_opt",
  /*  424 */ "ignore_opt",
  /*  425 */ "expression",
  /*  426 */ "dnode_list",
  /*  427 */ "literal_func",
  /*  428 */ "literal_list",
  /*  429 */ "table_alias",
  /*  430 */ "expr_or_subquery",
  /*  431 */ "pseudo_column",
  /*  432 */ "column_reference",
  /*  433 */ "function_expression",
  /*  434 */ "case_when_expression",
  /*  435 */ "star_func",
  /*  436 */ "star_func_para_list",
  /*  437 */ "noarg_func",
  /*  438 */ "other_para_list",
  /*  439 */ "star_func_para",
  /*  440 */ "when_then_list",
  /*  441 */ "case_when_else_opt",
  /*  442 */ "common_expression",
  /*  443 */ "when_then_expr",
  /*  444 */ "predicate",
  /*  445 */ "compare_op",
  /*  446 */ "in_op",
  /*  447 */ "in_predicate_value",
  /*  448 */ "boolean_value_expression",
  /*  449 */ "boolean_primary",
  /*  450 */ "from_clause_opt",
  /*  451 */ "table_reference_list",
  /*  452 */ "table_reference",
  /*  453 */ "table_primary",
  /*  454 */ "joined_table",
  /*  455 */ "alias_opt",
  /*  456 */ "subquery",
  /*  457 */ "parenthesized_joined_table",
  /*  458 */ "join_type",
  /*  459 */ "query_specification",
  /*  460 */ "set_quantifier_opt",
  /*  461 */ "select_list",
  /*  462 */ "partition_by_clause_opt",
  /*  463 */ "range_opt",
  /*  464 */ "every_opt",
  /*  465 */ "fill_opt",
  /*  466 */ "twindow_clause_opt",
  /*  467 */ "group_by_clause_opt",
  /*  468 */ "having_clause_opt",
  /*  469 */ "select_item",
  /*  470 */ "partition_list",
  /*  471 */ "partition_item",
  /*  472 */ "fill_mode",
  /*  473 */ "group_by_list",
  /*  474 */ "query_expression",
  /*  475 */ "query_simple",
  /*  476 */ "order_by_clause_opt",
  /*  477 */ "slimit_clause_opt",
  /*  478 */ "limit_clause_opt",
  /*  479 */ "union_query_expression",
  /*  480 */ "query_simple_or_subquery",
  /*  481 */ "sort_specification_list",
  /*  482 */ "sort_specification",
  /*  483 */ "ordering_specification_opt",
  /*  484 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level with_opt TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= db_name NK_DOT table_name",
 /*  43 */ "priv_level ::= topic_name",
 /*  44 */ "with_opt ::=",
 /*  45 */ "with_opt ::= WITH search_condition",
 /*  46 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  47 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  48 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  49 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  50 */ "cmd ::= DROP DNODE NK_INTEGER unsafe_opt",
 /*  51 */ "cmd ::= DROP DNODE dnode_endpoint unsafe_opt",
 /*  52 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  53 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  54 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  55 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  56 */ "cmd ::= RESTORE DNODE NK_INTEGER",
 /*  57 */ "dnode_endpoint ::= NK_STRING",
 /*  58 */ "dnode_endpoint ::= NK_ID",
 /*  59 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  60 */ "force_opt ::=",
 /*  61 */ "force_opt ::= FORCE",
 /*  62 */ "unsafe_opt ::= UNSAFE",
 /*  63 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  64 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  65 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  67 */ "cmd ::= RESTORE QNODE ON DNODE NK_INTEGER",
 /*  68 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  69 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  70 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  71 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  72 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  73 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  74 */ "cmd ::= RESTORE MNODE ON DNODE NK_INTEGER",
 /*  75 */ "cmd ::= RESTORE VNODE ON DNODE NK_INTEGER",
 /*  76 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  77 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  78 */ "cmd ::= USE db_name",
 /*  79 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  80 */ "cmd ::= FLUSH DATABASE db_name",
 /*  81 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  82 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  83 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  84 */ "not_exists_opt ::=",
 /*  85 */ "exists_opt ::= IF EXISTS",
 /*  86 */ "exists_opt ::=",
 /*  87 */ "db_options ::=",
 /*  88 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  89 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  90 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  92 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  93 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  94 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  95 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  96 */ "db_options ::= db_options KEEP integer_list",
 /*  97 */ "db_options ::= db_options KEEP variable_list",
 /*  98 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  99 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /* 100 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options PRECISION NK_STRING",
 /* 102 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /* 103 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /* 104 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /* 105 */ "db_options ::= db_options RETENTIONS retention_list",
 /* 106 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /* 107 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /* 108 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /* 109 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 110 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 111 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 112 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 113 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 114 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 115 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 116 */ "db_options ::= db_options TABLE_PREFIX signed",
 /* 117 */ "db_options ::= db_options TABLE_SUFFIX signed",
 /* 118 */ "alter_db_options ::= alter_db_option",
 /* 119 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 120 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 121 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 122 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 123 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 124 */ "alter_db_option ::= KEEP integer_list",
 /* 125 */ "alter_db_option ::= KEEP variable_list",
 /* 126 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 127 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 128 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 129 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 130 */ "alter_db_option ::= MINROWS NK_INTEGER",
 /* 131 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER",
 /* 132 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 133 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER",
 /* 134 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 135 */ "integer_list ::= NK_INTEGER",
 /* 136 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 137 */ "variable_list ::= NK_VARIABLE",
 /* 138 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 139 */ "retention_list ::= retention",
 /* 140 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 141 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 142 */ "speed_opt ::=",
 /* 143 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 144 */ "start_opt ::=",
 /* 145 */ "start_opt ::= START WITH NK_INTEGER",
 /* 146 */ "start_opt ::= START WITH NK_STRING",
 /* 147 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 148 */ "end_opt ::=",
 /* 149 */ "end_opt ::= END WITH NK_INTEGER",
 /* 150 */ "end_opt ::= END WITH NK_STRING",
 /* 151 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 152 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 153 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 154 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 155 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 156 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 157 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 158 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 159 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 160 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 161 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 162 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 163 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 164 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 165 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 166 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 167 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 168 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 169 */ "multi_create_clause ::= create_subtable_clause",
 /* 170 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 171 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 172 */ "multi_drop_clause ::= drop_table_clause",
 /* 173 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 174 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 175 */ "specific_cols_opt ::=",
 /* 176 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 177 */ "full_table_name ::= table_name",
 /* 178 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 179 */ "column_def_list ::= column_def",
 /* 180 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 181 */ "column_def ::= column_name type_name",
 /* 182 */ "type_name ::= BOOL",
 /* 183 */ "type_name ::= TINYINT",
 /* 184 */ "type_name ::= SMALLINT",
 /* 185 */ "type_name ::= INT",
 /* 186 */ "type_name ::= INTEGER",
 /* 187 */ "type_name ::= BIGINT",
 /* 188 */ "type_name ::= FLOAT",
 /* 189 */ "type_name ::= DOUBLE",
 /* 190 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 191 */ "type_name ::= TIMESTAMP",
 /* 192 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 193 */ "type_name ::= TINYINT UNSIGNED",
 /* 194 */ "type_name ::= SMALLINT UNSIGNED",
 /* 195 */ "type_name ::= INT UNSIGNED",
 /* 196 */ "type_name ::= BIGINT UNSIGNED",
 /* 197 */ "type_name ::= JSON",
 /* 198 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 199 */ "type_name ::= MEDIUMBLOB",
 /* 200 */ "type_name ::= BLOB",
 /* 201 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 202 */ "type_name ::= GEOMETRY NK_LP NK_INTEGER NK_RP",
 /* 203 */ "type_name ::= DECIMAL",
 /* 204 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 205 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 206 */ "tags_def_opt ::=",
 /* 207 */ "tags_def_opt ::= tags_def",
 /* 208 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 209 */ "table_options ::=",
 /* 210 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 211 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 212 */ "table_options ::= table_options WATERMARK duration_list",
 /* 213 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 214 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 215 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 216 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 217 */ "alter_table_options ::= alter_table_option",
 /* 218 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 219 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 220 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 221 */ "duration_list ::= duration_literal",
 /* 222 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 223 */ "rollup_func_list ::= rollup_func_name",
 /* 224 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 225 */ "rollup_func_name ::= function_name",
 /* 226 */ "rollup_func_name ::= FIRST",
 /* 227 */ "rollup_func_name ::= LAST",
 /* 228 */ "col_name_list ::= col_name",
 /* 229 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 230 */ "col_name ::= column_name",
 /* 231 */ "cmd ::= SHOW DNODES",
 /* 232 */ "cmd ::= SHOW USERS",
 /* 233 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 234 */ "cmd ::= SHOW DATABASES",
 /* 235 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 236 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 237 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 238 */ "cmd ::= SHOW MNODES",
 /* 239 */ "cmd ::= SHOW QNODES",
 /* 240 */ "cmd ::= SHOW FUNCTIONS",
 /* 241 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 242 */ "cmd ::= SHOW STREAMS",
 /* 243 */ "cmd ::= SHOW ACCOUNTS",
 /* 244 */ "cmd ::= SHOW APPS",
 /* 245 */ "cmd ::= SHOW CONNECTIONS",
 /* 246 */ "cmd ::= SHOW LICENCES",
 /* 247 */ "cmd ::= SHOW GRANTS",
 /* 248 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 249 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 250 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 251 */ "cmd ::= SHOW QUERIES",
 /* 252 */ "cmd ::= SHOW SCORES",
 /* 253 */ "cmd ::= SHOW TOPICS",
 /* 254 */ "cmd ::= SHOW VARIABLES",
 /* 255 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 256 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 257 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 258 */ "cmd ::= SHOW BNODES",
 /* 259 */ "cmd ::= SHOW SNODES",
 /* 260 */ "cmd ::= SHOW CLUSTER",
 /* 261 */ "cmd ::= SHOW TRANSACTIONS",
 /* 262 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 263 */ "cmd ::= SHOW CONSUMERS",
 /* 264 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 265 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 266 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 267 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 268 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 269 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 270 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 271 */ "db_name_cond_opt ::=",
 /* 272 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 273 */ "like_pattern_opt ::=",
 /* 274 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 275 */ "table_name_cond ::= table_name",
 /* 276 */ "from_db_opt ::=",
 /* 277 */ "from_db_opt ::= FROM db_name",
 /* 278 */ "tag_list_opt ::=",
 /* 279 */ "tag_list_opt ::= tag_item",
 /* 280 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 281 */ "tag_item ::= TBNAME",
 /* 282 */ "tag_item ::= QTAGS",
 /* 283 */ "tag_item ::= column_name",
 /* 284 */ "tag_item ::= column_name column_alias",
 /* 285 */ "tag_item ::= column_name AS column_alias",
 /* 286 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 287 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 288 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 289 */ "full_index_name ::= index_name",
 /* 290 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 291 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 292 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 293 */ "func_list ::= func",
 /* 294 */ "func_list ::= func_list NK_COMMA func",
 /* 295 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 296 */ "sma_func_name ::= function_name",
 /* 297 */ "sma_func_name ::= COUNT",
 /* 298 */ "sma_func_name ::= FIRST",
 /* 299 */ "sma_func_name ::= LAST",
 /* 300 */ "sma_func_name ::= LAST_ROW",
 /* 301 */ "sma_stream_opt ::=",
 /* 302 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 303 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 304 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 305 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 306 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 307 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 308 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name where_clause_opt",
 /* 309 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name where_clause_opt",
 /* 310 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 311 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 312 */ "cmd ::= DESC full_table_name",
 /* 313 */ "cmd ::= DESCRIBE full_table_name",
 /* 314 */ "cmd ::= RESET QUERY CACHE",
 /* 315 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 316 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 317 */ "analyze_opt ::=",
 /* 318 */ "analyze_opt ::= ANALYZE",
 /* 319 */ "explain_options ::=",
 /* 320 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 321 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 322 */ "cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt",
 /* 323 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 324 */ "agg_func_opt ::=",
 /* 325 */ "agg_func_opt ::= AGGREGATE",
 /* 326 */ "bufsize_opt ::=",
 /* 327 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 328 */ "language_opt ::=",
 /* 329 */ "language_opt ::= LANGUAGE NK_STRING",
 /* 330 */ "or_replace_opt ::=",
 /* 331 */ "or_replace_opt ::= OR REPLACE",
 /* 332 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 333 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 334 */ "cmd ::= PAUSE STREAM exists_opt stream_name",
 /* 335 */ "cmd ::= RESUME STREAM exists_opt ignore_opt stream_name",
 /* 336 */ "col_list_opt ::=",
 /* 337 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 338 */ "tag_def_or_ref_opt ::=",
 /* 339 */ "tag_def_or_ref_opt ::= tags_def",
 /* 340 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 341 */ "stream_options ::=",
 /* 342 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 343 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 344 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 345 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 346 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 347 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 348 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 349 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 350 */ "subtable_opt ::=",
 /* 351 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 352 */ "ignore_opt ::=",
 /* 353 */ "ignore_opt ::= IGNORE UNTREATED",
 /* 354 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 355 */ "cmd ::= KILL QUERY NK_STRING",
 /* 356 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 357 */ "cmd ::= BALANCE VGROUP",
 /* 358 */ "cmd ::= BALANCE VGROUP LEADER",
 /* 359 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 360 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 361 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 362 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 363 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 364 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 365 */ "cmd ::= query_or_subquery",
 /* 366 */ "cmd ::= insert_query",
 /* 367 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 368 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 369 */ "literal ::= NK_INTEGER",
 /* 370 */ "literal ::= NK_FLOAT",
 /* 371 */ "literal ::= NK_STRING",
 /* 372 */ "literal ::= NK_BOOL",
 /* 373 */ "literal ::= TIMESTAMP NK_STRING",
 /* 374 */ "literal ::= duration_literal",
 /* 375 */ "literal ::= NULL",
 /* 376 */ "literal ::= NK_QUESTION",
 /* 377 */ "duration_literal ::= NK_VARIABLE",
 /* 378 */ "signed ::= NK_INTEGER",
 /* 379 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 380 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 381 */ "signed ::= NK_FLOAT",
 /* 382 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 383 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 384 */ "signed_literal ::= signed",
 /* 385 */ "signed_literal ::= NK_STRING",
 /* 386 */ "signed_literal ::= NK_BOOL",
 /* 387 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 388 */ "signed_literal ::= duration_literal",
 /* 389 */ "signed_literal ::= NULL",
 /* 390 */ "signed_literal ::= literal_func",
 /* 391 */ "signed_literal ::= NK_QUESTION",
 /* 392 */ "literal_list ::= signed_literal",
 /* 393 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 394 */ "db_name ::= NK_ID",
 /* 395 */ "table_name ::= NK_ID",
 /* 396 */ "column_name ::= NK_ID",
 /* 397 */ "function_name ::= NK_ID",
 /* 398 */ "table_alias ::= NK_ID",
 /* 399 */ "column_alias ::= NK_ID",
 /* 400 */ "user_name ::= NK_ID",
 /* 401 */ "topic_name ::= NK_ID",
 /* 402 */ "stream_name ::= NK_ID",
 /* 403 */ "cgroup_name ::= NK_ID",
 /* 404 */ "index_name ::= NK_ID",
 /* 405 */ "expr_or_subquery ::= expression",
 /* 406 */ "expression ::= literal",
 /* 407 */ "expression ::= pseudo_column",
 /* 408 */ "expression ::= column_reference",
 /* 409 */ "expression ::= function_expression",
 /* 410 */ "expression ::= case_when_expression",
 /* 411 */ "expression ::= NK_LP expression NK_RP",
 /* 412 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 413 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 414 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 415 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 416 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 417 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 418 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 419 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 420 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 421 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 422 */ "expression_list ::= expr_or_subquery",
 /* 423 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 424 */ "column_reference ::= column_name",
 /* 425 */ "column_reference ::= table_name NK_DOT column_name",
 /* 426 */ "pseudo_column ::= ROWTS",
 /* 427 */ "pseudo_column ::= TBNAME",
 /* 428 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 429 */ "pseudo_column ::= QSTART",
 /* 430 */ "pseudo_column ::= QEND",
 /* 431 */ "pseudo_column ::= QDURATION",
 /* 432 */ "pseudo_column ::= WSTART",
 /* 433 */ "pseudo_column ::= WEND",
 /* 434 */ "pseudo_column ::= WDURATION",
 /* 435 */ "pseudo_column ::= IROWTS",
 /* 436 */ "pseudo_column ::= ISFILLED",
 /* 437 */ "pseudo_column ::= QTAGS",
 /* 438 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 439 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 440 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 441 */ "function_expression ::= literal_func",
 /* 442 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 443 */ "literal_func ::= NOW",
 /* 444 */ "noarg_func ::= NOW",
 /* 445 */ "noarg_func ::= TODAY",
 /* 446 */ "noarg_func ::= TIMEZONE",
 /* 447 */ "noarg_func ::= DATABASE",
 /* 448 */ "noarg_func ::= CLIENT_VERSION",
 /* 449 */ "noarg_func ::= SERVER_VERSION",
 /* 450 */ "noarg_func ::= SERVER_STATUS",
 /* 451 */ "noarg_func ::= CURRENT_USER",
 /* 452 */ "noarg_func ::= USER",
 /* 453 */ "star_func ::= COUNT",
 /* 454 */ "star_func ::= FIRST",
 /* 455 */ "star_func ::= LAST",
 /* 456 */ "star_func ::= LAST_ROW",
 /* 457 */ "star_func_para_list ::= NK_STAR",
 /* 458 */ "star_func_para_list ::= other_para_list",
 /* 459 */ "other_para_list ::= star_func_para",
 /* 460 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 461 */ "star_func_para ::= expr_or_subquery",
 /* 462 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 463 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 464 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 465 */ "when_then_list ::= when_then_expr",
 /* 466 */ "when_then_list ::= when_then_list when_then_expr",
 /* 467 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 468 */ "case_when_else_opt ::=",
 /* 469 */ "case_when_else_opt ::= ELSE common_expression",
 /* 470 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 471 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 472 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 473 */ "predicate ::= expr_or_subquery IS NULL",
 /* 474 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 475 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 476 */ "compare_op ::= NK_LT",
 /* 477 */ "compare_op ::= NK_GT",
 /* 478 */ "compare_op ::= NK_LE",
 /* 479 */ "compare_op ::= NK_GE",
 /* 480 */ "compare_op ::= NK_NE",
 /* 481 */ "compare_op ::= NK_EQ",
 /* 482 */ "compare_op ::= LIKE",
 /* 483 */ "compare_op ::= NOT LIKE",
 /* 484 */ "compare_op ::= MATCH",
 /* 485 */ "compare_op ::= NMATCH",
 /* 486 */ "compare_op ::= CONTAINS",
 /* 487 */ "in_op ::= IN",
 /* 488 */ "in_op ::= NOT IN",
 /* 489 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 490 */ "boolean_value_expression ::= boolean_primary",
 /* 491 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 492 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 493 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 494 */ "boolean_primary ::= predicate",
 /* 495 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 496 */ "common_expression ::= expr_or_subquery",
 /* 497 */ "common_expression ::= boolean_value_expression",
 /* 498 */ "from_clause_opt ::=",
 /* 499 */ "from_clause_opt ::= FROM table_reference_list",
 /* 500 */ "table_reference_list ::= table_reference",
 /* 501 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 502 */ "table_reference ::= table_primary",
 /* 503 */ "table_reference ::= joined_table",
 /* 504 */ "table_primary ::= table_name alias_opt",
 /* 505 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 506 */ "table_primary ::= subquery alias_opt",
 /* 507 */ "table_primary ::= parenthesized_joined_table",
 /* 508 */ "alias_opt ::=",
 /* 509 */ "alias_opt ::= table_alias",
 /* 510 */ "alias_opt ::= AS table_alias",
 /* 511 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 512 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 513 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 514 */ "join_type ::=",
 /* 515 */ "join_type ::= INNER",
 /* 516 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 517 */ "set_quantifier_opt ::=",
 /* 518 */ "set_quantifier_opt ::= DISTINCT",
 /* 519 */ "set_quantifier_opt ::= ALL",
 /* 520 */ "select_list ::= select_item",
 /* 521 */ "select_list ::= select_list NK_COMMA select_item",
 /* 522 */ "select_item ::= NK_STAR",
 /* 523 */ "select_item ::= common_expression",
 /* 524 */ "select_item ::= common_expression column_alias",
 /* 525 */ "select_item ::= common_expression AS column_alias",
 /* 526 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 527 */ "where_clause_opt ::=",
 /* 528 */ "where_clause_opt ::= WHERE search_condition",
 /* 529 */ "partition_by_clause_opt ::=",
 /* 530 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 531 */ "partition_list ::= partition_item",
 /* 532 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 533 */ "partition_item ::= expr_or_subquery",
 /* 534 */ "partition_item ::= expr_or_subquery column_alias",
 /* 535 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 536 */ "twindow_clause_opt ::=",
 /* 537 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 538 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 539 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 540 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 541 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 542 */ "sliding_opt ::=",
 /* 543 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 544 */ "fill_opt ::=",
 /* 545 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 546 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP",
 /* 547 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP",
 /* 548 */ "fill_mode ::= NONE",
 /* 549 */ "fill_mode ::= PREV",
 /* 550 */ "fill_mode ::= NULL",
 /* 551 */ "fill_mode ::= NULL_F",
 /* 552 */ "fill_mode ::= LINEAR",
 /* 553 */ "fill_mode ::= NEXT",
 /* 554 */ "group_by_clause_opt ::=",
 /* 555 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 556 */ "group_by_list ::= expr_or_subquery",
 /* 557 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 558 */ "having_clause_opt ::=",
 /* 559 */ "having_clause_opt ::= HAVING search_condition",
 /* 560 */ "range_opt ::=",
 /* 561 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 562 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_RP",
 /* 563 */ "every_opt ::=",
 /* 564 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 565 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 566 */ "query_simple ::= query_specification",
 /* 567 */ "query_simple ::= union_query_expression",
 /* 568 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 569 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 570 */ "query_simple_or_subquery ::= query_simple",
 /* 571 */ "query_simple_or_subquery ::= subquery",
 /* 572 */ "query_or_subquery ::= query_expression",
 /* 573 */ "query_or_subquery ::= subquery",
 /* 574 */ "order_by_clause_opt ::=",
 /* 575 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 576 */ "slimit_clause_opt ::=",
 /* 577 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 578 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 579 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 580 */ "limit_clause_opt ::=",
 /* 581 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 582 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 583 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 584 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 585 */ "subquery ::= NK_LP subquery NK_RP",
 /* 586 */ "search_condition ::= common_expression",
 /* 587 */ "sort_specification_list ::= sort_specification",
 /* 588 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 589 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 590 */ "ordering_specification_opt ::=",
 /* 591 */ "ordering_specification_opt ::= ASC",
 /* 592 */ "ordering_specification_opt ::= DESC",
 /* 593 */ "null_ordering_opt ::=",
 /* 594 */ "null_ordering_opt ::= NULLS FIRST",
 /* 595 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 337: /* cmd */
    case 340: /* literal */
    case 346: /* with_opt */
    case 352: /* search_condition */
    case 357: /* db_options */
    case 359: /* alter_db_options */
    case 361: /* start_opt */
    case 362: /* end_opt */
    case 366: /* signed */
    case 368: /* retention */
    case 369: /* full_table_name */
    case 372: /* table_options */
    case 376: /* alter_table_clause */
    case 377: /* alter_table_options */
    case 380: /* signed_literal */
    case 381: /* create_subtable_clause */
    case 384: /* drop_table_clause */
    case 386: /* column_def */
    case 390: /* duration_literal */
    case 391: /* rollup_func_name */
    case 393: /* col_name */
    case 394: /* db_name_cond_opt */
    case 395: /* like_pattern_opt */
    case 396: /* table_name_cond */
    case 397: /* from_db_opt */
    case 399: /* tag_item */
    case 401: /* full_index_name */
    case 402: /* index_options */
    case 405: /* sliding_opt */
    case 406: /* sma_stream_opt */
    case 407: /* func */
    case 409: /* query_or_subquery */
    case 410: /* where_clause_opt */
    case 413: /* explain_options */
    case 414: /* insert_query */
    case 420: /* stream_options */
    case 423: /* subtable_opt */
    case 425: /* expression */
    case 427: /* literal_func */
    case 430: /* expr_or_subquery */
    case 431: /* pseudo_column */
    case 432: /* column_reference */
    case 433: /* function_expression */
    case 434: /* case_when_expression */
    case 439: /* star_func_para */
    case 441: /* case_when_else_opt */
    case 442: /* common_expression */
    case 443: /* when_then_expr */
    case 444: /* predicate */
    case 447: /* in_predicate_value */
    case 448: /* boolean_value_expression */
    case 449: /* boolean_primary */
    case 450: /* from_clause_opt */
    case 451: /* table_reference_list */
    case 452: /* table_reference */
    case 453: /* table_primary */
    case 454: /* joined_table */
    case 456: /* subquery */
    case 457: /* parenthesized_joined_table */
    case 459: /* query_specification */
    case 463: /* range_opt */
    case 464: /* every_opt */
    case 465: /* fill_opt */
    case 466: /* twindow_clause_opt */
    case 468: /* having_clause_opt */
    case 469: /* select_item */
    case 471: /* partition_item */
    case 474: /* query_expression */
    case 475: /* query_simple */
    case 477: /* slimit_clause_opt */
    case 478: /* limit_clause_opt */
    case 479: /* union_query_expression */
    case 480: /* query_simple_or_subquery */
    case 482: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy242)); 
}
      break;
    case 338: /* account_options */
    case 339: /* alter_account_options */
    case 341: /* alter_account_option */
    case 360: /* speed_opt */
    case 417: /* bufsize_opt */
{
 
}
      break;
    case 342: /* user_name */
    case 349: /* db_name */
    case 350: /* table_name */
    case 351: /* topic_name */
    case 353: /* dnode_endpoint */
    case 378: /* column_name */
    case 392: /* function_name */
    case 400: /* column_alias */
    case 403: /* index_name */
    case 408: /* sma_func_name */
    case 411: /* cgroup_name */
    case 418: /* language_opt */
    case 419: /* stream_name */
    case 429: /* table_alias */
    case 435: /* star_func */
    case 437: /* noarg_func */
    case 455: /* alias_opt */
{
 
}
      break;
    case 343: /* sysinfo_opt */
{
 
}
      break;
    case 344: /* privileges */
    case 347: /* priv_type_list */
    case 348: /* priv_type */
{
 
}
      break;
    case 345: /* priv_level */
{
 
}
      break;
    case 354: /* force_opt */
    case 355: /* unsafe_opt */
    case 356: /* not_exists_opt */
    case 358: /* exists_opt */
    case 412: /* analyze_opt */
    case 415: /* or_replace_opt */
    case 416: /* agg_func_opt */
    case 424: /* ignore_opt */
    case 460: /* set_quantifier_opt */
{
 
}
      break;
    case 363: /* integer_list */
    case 364: /* variable_list */
    case 365: /* retention_list */
    case 370: /* column_def_list */
    case 371: /* tags_def_opt */
    case 373: /* multi_create_clause */
    case 374: /* tags_def */
    case 375: /* multi_drop_clause */
    case 382: /* specific_cols_opt */
    case 383: /* expression_list */
    case 385: /* col_name_list */
    case 387: /* duration_list */
    case 388: /* rollup_func_list */
    case 398: /* tag_list_opt */
    case 404: /* func_list */
    case 421: /* col_list_opt */
    case 422: /* tag_def_or_ref_opt */
    case 426: /* dnode_list */
    case 428: /* literal_list */
    case 436: /* star_func_para_list */
    case 438: /* other_para_list */
    case 440: /* when_then_list */
    case 461: /* select_list */
    case 462: /* partition_by_clause_opt */
    case 467: /* group_by_clause_opt */
    case 470: /* partition_list */
    case 473: /* group_by_list */
    case 476: /* order_by_clause_opt */
    case 481: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy174)); 
}
      break;
    case 367: /* alter_db_option */
    case 389: /* alter_table_option */
{
 
}
      break;
    case 379: /* type_name */
{
 
}
      break;
    case 445: /* compare_op */
    case 446: /* in_op */
{
 
}
      break;
    case 458: /* join_type */
{
 
}
      break;
    case 472: /* fill_mode */
{
 
}
      break;
    case 483: /* ordering_specification_opt */
{
 
}
      break;
    case 484: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<sizeof(yy_action)/sizeof(yy_action[0]) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
   337,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   337,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
   338,  /* (2) account_options ::= */
   338,  /* (3) account_options ::= account_options PPS literal */
   338,  /* (4) account_options ::= account_options TSERIES literal */
   338,  /* (5) account_options ::= account_options STORAGE literal */
   338,  /* (6) account_options ::= account_options STREAMS literal */
   338,  /* (7) account_options ::= account_options QTIME literal */
   338,  /* (8) account_options ::= account_options DBS literal */
   338,  /* (9) account_options ::= account_options USERS literal */
   338,  /* (10) account_options ::= account_options CONNS literal */
   338,  /* (11) account_options ::= account_options STATE literal */
   339,  /* (12) alter_account_options ::= alter_account_option */
   339,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   341,  /* (14) alter_account_option ::= PASS literal */
   341,  /* (15) alter_account_option ::= PPS literal */
   341,  /* (16) alter_account_option ::= TSERIES literal */
   341,  /* (17) alter_account_option ::= STORAGE literal */
   341,  /* (18) alter_account_option ::= STREAMS literal */
   341,  /* (19) alter_account_option ::= QTIME literal */
   341,  /* (20) alter_account_option ::= DBS literal */
   341,  /* (21) alter_account_option ::= USERS literal */
   341,  /* (22) alter_account_option ::= CONNS literal */
   341,  /* (23) alter_account_option ::= STATE literal */
   337,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   337,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   337,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   337,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   337,  /* (28) cmd ::= DROP USER user_name */
   343,  /* (29) sysinfo_opt ::= */
   343,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   337,  /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
   337,  /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
   344,  /* (33) privileges ::= ALL */
   344,  /* (34) privileges ::= priv_type_list */
   344,  /* (35) privileges ::= SUBSCRIBE */
   347,  /* (36) priv_type_list ::= priv_type */
   347,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   348,  /* (38) priv_type ::= READ */
   348,  /* (39) priv_type ::= WRITE */
   345,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   345,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   345,  /* (42) priv_level ::= db_name NK_DOT table_name */
   345,  /* (43) priv_level ::= topic_name */
   346,  /* (44) with_opt ::= */
   346,  /* (45) with_opt ::= WITH search_condition */
   337,  /* (46) cmd ::= CREATE DNODE dnode_endpoint */
   337,  /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   337,  /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
   337,  /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
   337,  /* (50) cmd ::= DROP DNODE NK_INTEGER unsafe_opt */
   337,  /* (51) cmd ::= DROP DNODE dnode_endpoint unsafe_opt */
   337,  /* (52) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   337,  /* (53) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   337,  /* (54) cmd ::= ALTER ALL DNODES NK_STRING */
   337,  /* (55) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   337,  /* (56) cmd ::= RESTORE DNODE NK_INTEGER */
   353,  /* (57) dnode_endpoint ::= NK_STRING */
   353,  /* (58) dnode_endpoint ::= NK_ID */
   353,  /* (59) dnode_endpoint ::= NK_IPTOKEN */
   354,  /* (60) force_opt ::= */
   354,  /* (61) force_opt ::= FORCE */
   355,  /* (62) unsafe_opt ::= UNSAFE */
   337,  /* (63) cmd ::= ALTER LOCAL NK_STRING */
   337,  /* (64) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   337,  /* (65) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   337,  /* (66) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   337,  /* (67) cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
   337,  /* (68) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   337,  /* (69) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   337,  /* (70) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   337,  /* (71) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   337,  /* (72) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   337,  /* (73) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   337,  /* (74) cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
   337,  /* (75) cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
   337,  /* (76) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   337,  /* (77) cmd ::= DROP DATABASE exists_opt db_name */
   337,  /* (78) cmd ::= USE db_name */
   337,  /* (79) cmd ::= ALTER DATABASE db_name alter_db_options */
   337,  /* (80) cmd ::= FLUSH DATABASE db_name */
   337,  /* (81) cmd ::= TRIM DATABASE db_name speed_opt */
   337,  /* (82) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
   356,  /* (83) not_exists_opt ::= IF NOT EXISTS */
   356,  /* (84) not_exists_opt ::= */
   358,  /* (85) exists_opt ::= IF EXISTS */
   358,  /* (86) exists_opt ::= */
   357,  /* (87) db_options ::= */
   357,  /* (88) db_options ::= db_options BUFFER NK_INTEGER */
   357,  /* (89) db_options ::= db_options CACHEMODEL NK_STRING */
   357,  /* (90) db_options ::= db_options CACHESIZE NK_INTEGER */
   357,  /* (91) db_options ::= db_options COMP NK_INTEGER */
   357,  /* (92) db_options ::= db_options DURATION NK_INTEGER */
   357,  /* (93) db_options ::= db_options DURATION NK_VARIABLE */
   357,  /* (94) db_options ::= db_options MAXROWS NK_INTEGER */
   357,  /* (95) db_options ::= db_options MINROWS NK_INTEGER */
   357,  /* (96) db_options ::= db_options KEEP integer_list */
   357,  /* (97) db_options ::= db_options KEEP variable_list */
   357,  /* (98) db_options ::= db_options PAGES NK_INTEGER */
   357,  /* (99) db_options ::= db_options PAGESIZE NK_INTEGER */
   357,  /* (100) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   357,  /* (101) db_options ::= db_options PRECISION NK_STRING */
   357,  /* (102) db_options ::= db_options REPLICA NK_INTEGER */
   357,  /* (103) db_options ::= db_options VGROUPS NK_INTEGER */
   357,  /* (104) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   357,  /* (105) db_options ::= db_options RETENTIONS retention_list */
   357,  /* (106) db_options ::= db_options SCHEMALESS NK_INTEGER */
   357,  /* (107) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   357,  /* (108) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   357,  /* (109) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   357,  /* (110) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   357,  /* (111) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   357,  /* (112) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   357,  /* (113) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   357,  /* (114) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   357,  /* (115) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   357,  /* (116) db_options ::= db_options TABLE_PREFIX signed */
   357,  /* (117) db_options ::= db_options TABLE_SUFFIX signed */
   359,  /* (118) alter_db_options ::= alter_db_option */
   359,  /* (119) alter_db_options ::= alter_db_options alter_db_option */
   367,  /* (120) alter_db_option ::= BUFFER NK_INTEGER */
   367,  /* (121) alter_db_option ::= CACHEMODEL NK_STRING */
   367,  /* (122) alter_db_option ::= CACHESIZE NK_INTEGER */
   367,  /* (123) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   367,  /* (124) alter_db_option ::= KEEP integer_list */
   367,  /* (125) alter_db_option ::= KEEP variable_list */
   367,  /* (126) alter_db_option ::= PAGES NK_INTEGER */
   367,  /* (127) alter_db_option ::= REPLICA NK_INTEGER */
   367,  /* (128) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   367,  /* (129) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   367,  /* (130) alter_db_option ::= MINROWS NK_INTEGER */
   367,  /* (131) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
   367,  /* (132) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   367,  /* (133) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
   367,  /* (134) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   363,  /* (135) integer_list ::= NK_INTEGER */
   363,  /* (136) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   364,  /* (137) variable_list ::= NK_VARIABLE */
   364,  /* (138) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   365,  /* (139) retention_list ::= retention */
   365,  /* (140) retention_list ::= retention_list NK_COMMA retention */
   368,  /* (141) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
   360,  /* (142) speed_opt ::= */
   360,  /* (143) speed_opt ::= MAX_SPEED NK_INTEGER */
   361,  /* (144) start_opt ::= */
   361,  /* (145) start_opt ::= START WITH NK_INTEGER */
   361,  /* (146) start_opt ::= START WITH NK_STRING */
   361,  /* (147) start_opt ::= START WITH TIMESTAMP NK_STRING */
   362,  /* (148) end_opt ::= */
   362,  /* (149) end_opt ::= END WITH NK_INTEGER */
   362,  /* (150) end_opt ::= END WITH NK_STRING */
   362,  /* (151) end_opt ::= END WITH TIMESTAMP NK_STRING */
   337,  /* (152) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   337,  /* (153) cmd ::= CREATE TABLE multi_create_clause */
   337,  /* (154) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   337,  /* (155) cmd ::= DROP TABLE multi_drop_clause */
   337,  /* (156) cmd ::= DROP STABLE exists_opt full_table_name */
   337,  /* (157) cmd ::= ALTER TABLE alter_table_clause */
   337,  /* (158) cmd ::= ALTER STABLE alter_table_clause */
   376,  /* (159) alter_table_clause ::= full_table_name alter_table_options */
   376,  /* (160) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   376,  /* (161) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   376,  /* (162) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   376,  /* (163) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   376,  /* (164) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   376,  /* (165) alter_table_clause ::= full_table_name DROP TAG column_name */
   376,  /* (166) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   376,  /* (167) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   376,  /* (168) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   373,  /* (169) multi_create_clause ::= create_subtable_clause */
   373,  /* (170) multi_create_clause ::= multi_create_clause create_subtable_clause */
   381,  /* (171) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   375,  /* (172) multi_drop_clause ::= drop_table_clause */
   375,  /* (173) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
   384,  /* (174) drop_table_clause ::= exists_opt full_table_name */
   382,  /* (175) specific_cols_opt ::= */
   382,  /* (176) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   369,  /* (177) full_table_name ::= table_name */
   369,  /* (178) full_table_name ::= db_name NK_DOT table_name */
   370,  /* (179) column_def_list ::= column_def */
   370,  /* (180) column_def_list ::= column_def_list NK_COMMA column_def */
   386,  /* (181) column_def ::= column_name type_name */
   379,  /* (182) type_name ::= BOOL */
   379,  /* (183) type_name ::= TINYINT */
   379,  /* (184) type_name ::= SMALLINT */
   379,  /* (185) type_name ::= INT */
   379,  /* (186) type_name ::= INTEGER */
   379,  /* (187) type_name ::= BIGINT */
   379,  /* (188) type_name ::= FLOAT */
   379,  /* (189) type_name ::= DOUBLE */
   379,  /* (190) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   379,  /* (191) type_name ::= TIMESTAMP */
   379,  /* (192) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   379,  /* (193) type_name ::= TINYINT UNSIGNED */
   379,  /* (194) type_name ::= SMALLINT UNSIGNED */
   379,  /* (195) type_name ::= INT UNSIGNED */
   379,  /* (196) type_name ::= BIGINT UNSIGNED */
   379,  /* (197) type_name ::= JSON */
   379,  /* (198) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   379,  /* (199) type_name ::= MEDIUMBLOB */
   379,  /* (200) type_name ::= BLOB */
   379,  /* (201) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   379,  /* (202) type_name ::= GEOMETRY NK_LP NK_INTEGER NK_RP */
   379,  /* (203) type_name ::= DECIMAL */
   379,  /* (204) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   379,  /* (205) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
   371,  /* (206) tags_def_opt ::= */
   371,  /* (207) tags_def_opt ::= tags_def */
   374,  /* (208) tags_def ::= TAGS NK_LP column_def_list NK_RP */
   372,  /* (209) table_options ::= */
   372,  /* (210) table_options ::= table_options COMMENT NK_STRING */
   372,  /* (211) table_options ::= table_options MAX_DELAY duration_list */
   372,  /* (212) table_options ::= table_options WATERMARK duration_list */
   372,  /* (213) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   372,  /* (214) table_options ::= table_options TTL NK_INTEGER */
   372,  /* (215) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   372,  /* (216) table_options ::= table_options DELETE_MARK duration_list */
   377,  /* (217) alter_table_options ::= alter_table_option */
   377,  /* (218) alter_table_options ::= alter_table_options alter_table_option */
   389,  /* (219) alter_table_option ::= COMMENT NK_STRING */
   389,  /* (220) alter_table_option ::= TTL NK_INTEGER */
   387,  /* (221) duration_list ::= duration_literal */
   387,  /* (222) duration_list ::= duration_list NK_COMMA duration_literal */
   388,  /* (223) rollup_func_list ::= rollup_func_name */
   388,  /* (224) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   391,  /* (225) rollup_func_name ::= function_name */
   391,  /* (226) rollup_func_name ::= FIRST */
   391,  /* (227) rollup_func_name ::= LAST */
   385,  /* (228) col_name_list ::= col_name */
   385,  /* (229) col_name_list ::= col_name_list NK_COMMA col_name */
   393,  /* (230) col_name ::= column_name */
   337,  /* (231) cmd ::= SHOW DNODES */
   337,  /* (232) cmd ::= SHOW USERS */
   337,  /* (233) cmd ::= SHOW USER PRIVILEGES */
   337,  /* (234) cmd ::= SHOW DATABASES */
   337,  /* (235) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   337,  /* (236) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   337,  /* (237) cmd ::= SHOW db_name_cond_opt VGROUPS */
   337,  /* (238) cmd ::= SHOW MNODES */
   337,  /* (239) cmd ::= SHOW QNODES */
   337,  /* (240) cmd ::= SHOW FUNCTIONS */
   337,  /* (241) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   337,  /* (242) cmd ::= SHOW STREAMS */
   337,  /* (243) cmd ::= SHOW ACCOUNTS */
   337,  /* (244) cmd ::= SHOW APPS */
   337,  /* (245) cmd ::= SHOW CONNECTIONS */
   337,  /* (246) cmd ::= SHOW LICENCES */
   337,  /* (247) cmd ::= SHOW GRANTS */
   337,  /* (248) cmd ::= SHOW CREATE DATABASE db_name */
   337,  /* (249) cmd ::= SHOW CREATE TABLE full_table_name */
   337,  /* (250) cmd ::= SHOW CREATE STABLE full_table_name */
   337,  /* (251) cmd ::= SHOW QUERIES */
   337,  /* (252) cmd ::= SHOW SCORES */
   337,  /* (253) cmd ::= SHOW TOPICS */
   337,  /* (254) cmd ::= SHOW VARIABLES */
   337,  /* (255) cmd ::= SHOW CLUSTER VARIABLES */
   337,  /* (256) cmd ::= SHOW LOCAL VARIABLES */
   337,  /* (257) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   337,  /* (258) cmd ::= SHOW BNODES */
   337,  /* (259) cmd ::= SHOW SNODES */
   337,  /* (260) cmd ::= SHOW CLUSTER */
   337,  /* (261) cmd ::= SHOW TRANSACTIONS */
   337,  /* (262) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   337,  /* (263) cmd ::= SHOW CONSUMERS */
   337,  /* (264) cmd ::= SHOW SUBSCRIPTIONS */
   337,  /* (265) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   337,  /* (266) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   337,  /* (267) cmd ::= SHOW VNODES NK_INTEGER */
   337,  /* (268) cmd ::= SHOW VNODES NK_STRING */
   337,  /* (269) cmd ::= SHOW db_name_cond_opt ALIVE */
   337,  /* (270) cmd ::= SHOW CLUSTER ALIVE */
   394,  /* (271) db_name_cond_opt ::= */
   394,  /* (272) db_name_cond_opt ::= db_name NK_DOT */
   395,  /* (273) like_pattern_opt ::= */
   395,  /* (274) like_pattern_opt ::= LIKE NK_STRING */
   396,  /* (275) table_name_cond ::= table_name */
   397,  /* (276) from_db_opt ::= */
   397,  /* (277) from_db_opt ::= FROM db_name */
   398,  /* (278) tag_list_opt ::= */
   398,  /* (279) tag_list_opt ::= tag_item */
   398,  /* (280) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   399,  /* (281) tag_item ::= TBNAME */
   399,  /* (282) tag_item ::= QTAGS */
   399,  /* (283) tag_item ::= column_name */
   399,  /* (284) tag_item ::= column_name column_alias */
   399,  /* (285) tag_item ::= column_name AS column_alias */
   337,  /* (286) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   337,  /* (287) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
   337,  /* (288) cmd ::= DROP INDEX exists_opt full_index_name */
   401,  /* (289) full_index_name ::= index_name */
   401,  /* (290) full_index_name ::= db_name NK_DOT index_name */
   402,  /* (291) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
   402,  /* (292) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   404,  /* (293) func_list ::= func */
   404,  /* (294) func_list ::= func_list NK_COMMA func */
   407,  /* (295) func ::= sma_func_name NK_LP expression_list NK_RP */
   408,  /* (296) sma_func_name ::= function_name */
   408,  /* (297) sma_func_name ::= COUNT */
   408,  /* (298) sma_func_name ::= FIRST */
   408,  /* (299) sma_func_name ::= LAST */
   408,  /* (300) sma_func_name ::= LAST_ROW */
   406,  /* (301) sma_stream_opt ::= */
   406,  /* (302) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   406,  /* (303) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   406,  /* (304) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   337,  /* (305) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   337,  /* (306) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   337,  /* (307) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   337,  /* (308) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name where_clause_opt */
   337,  /* (309) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name where_clause_opt */
   337,  /* (310) cmd ::= DROP TOPIC exists_opt topic_name */
   337,  /* (311) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   337,  /* (312) cmd ::= DESC full_table_name */
   337,  /* (313) cmd ::= DESCRIBE full_table_name */
   337,  /* (314) cmd ::= RESET QUERY CACHE */
   337,  /* (315) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   337,  /* (316) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
   412,  /* (317) analyze_opt ::= */
   412,  /* (318) analyze_opt ::= ANALYZE */
   413,  /* (319) explain_options ::= */
   413,  /* (320) explain_options ::= explain_options VERBOSE NK_BOOL */
   413,  /* (321) explain_options ::= explain_options RATIO NK_FLOAT */
   337,  /* (322) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
   337,  /* (323) cmd ::= DROP FUNCTION exists_opt function_name */
   416,  /* (324) agg_func_opt ::= */
   416,  /* (325) agg_func_opt ::= AGGREGATE */
   417,  /* (326) bufsize_opt ::= */
   417,  /* (327) bufsize_opt ::= BUFSIZE NK_INTEGER */
   418,  /* (328) language_opt ::= */
   418,  /* (329) language_opt ::= LANGUAGE NK_STRING */
   415,  /* (330) or_replace_opt ::= */
   415,  /* (331) or_replace_opt ::= OR REPLACE */
   337,  /* (332) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
   337,  /* (333) cmd ::= DROP STREAM exists_opt stream_name */
   337,  /* (334) cmd ::= PAUSE STREAM exists_opt stream_name */
   337,  /* (335) cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
   421,  /* (336) col_list_opt ::= */
   421,  /* (337) col_list_opt ::= NK_LP col_name_list NK_RP */
   422,  /* (338) tag_def_or_ref_opt ::= */
   422,  /* (339) tag_def_or_ref_opt ::= tags_def */
   422,  /* (340) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
   420,  /* (341) stream_options ::= */
   420,  /* (342) stream_options ::= stream_options TRIGGER AT_ONCE */
   420,  /* (343) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   420,  /* (344) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   420,  /* (345) stream_options ::= stream_options WATERMARK duration_literal */
   420,  /* (346) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   420,  /* (347) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   420,  /* (348) stream_options ::= stream_options DELETE_MARK duration_literal */
   420,  /* (349) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
   423,  /* (350) subtable_opt ::= */
   423,  /* (351) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   424,  /* (352) ignore_opt ::= */
   424,  /* (353) ignore_opt ::= IGNORE UNTREATED */
   337,  /* (354) cmd ::= KILL CONNECTION NK_INTEGER */
   337,  /* (355) cmd ::= KILL QUERY NK_STRING */
   337,  /* (356) cmd ::= KILL TRANSACTION NK_INTEGER */
   337,  /* (357) cmd ::= BALANCE VGROUP */
   337,  /* (358) cmd ::= BALANCE VGROUP LEADER */
   337,  /* (359) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   337,  /* (360) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   337,  /* (361) cmd ::= SPLIT VGROUP NK_INTEGER */
   426,  /* (362) dnode_list ::= DNODE NK_INTEGER */
   426,  /* (363) dnode_list ::= dnode_list DNODE NK_INTEGER */
   337,  /* (364) cmd ::= DELETE FROM full_table_name where_clause_opt */
   337,  /* (365) cmd ::= query_or_subquery */
   337,  /* (366) cmd ::= insert_query */
   414,  /* (367) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   414,  /* (368) insert_query ::= INSERT INTO full_table_name query_or_subquery */
   340,  /* (369) literal ::= NK_INTEGER */
   340,  /* (370) literal ::= NK_FLOAT */
   340,  /* (371) literal ::= NK_STRING */
   340,  /* (372) literal ::= NK_BOOL */
   340,  /* (373) literal ::= TIMESTAMP NK_STRING */
   340,  /* (374) literal ::= duration_literal */
   340,  /* (375) literal ::= NULL */
   340,  /* (376) literal ::= NK_QUESTION */
   390,  /* (377) duration_literal ::= NK_VARIABLE */
   366,  /* (378) signed ::= NK_INTEGER */
   366,  /* (379) signed ::= NK_PLUS NK_INTEGER */
   366,  /* (380) signed ::= NK_MINUS NK_INTEGER */
   366,  /* (381) signed ::= NK_FLOAT */
   366,  /* (382) signed ::= NK_PLUS NK_FLOAT */
   366,  /* (383) signed ::= NK_MINUS NK_FLOAT */
   380,  /* (384) signed_literal ::= signed */
   380,  /* (385) signed_literal ::= NK_STRING */
   380,  /* (386) signed_literal ::= NK_BOOL */
   380,  /* (387) signed_literal ::= TIMESTAMP NK_STRING */
   380,  /* (388) signed_literal ::= duration_literal */
   380,  /* (389) signed_literal ::= NULL */
   380,  /* (390) signed_literal ::= literal_func */
   380,  /* (391) signed_literal ::= NK_QUESTION */
   428,  /* (392) literal_list ::= signed_literal */
   428,  /* (393) literal_list ::= literal_list NK_COMMA signed_literal */
   349,  /* (394) db_name ::= NK_ID */
   350,  /* (395) table_name ::= NK_ID */
   378,  /* (396) column_name ::= NK_ID */
   392,  /* (397) function_name ::= NK_ID */
   429,  /* (398) table_alias ::= NK_ID */
   400,  /* (399) column_alias ::= NK_ID */
   342,  /* (400) user_name ::= NK_ID */
   351,  /* (401) topic_name ::= NK_ID */
   419,  /* (402) stream_name ::= NK_ID */
   411,  /* (403) cgroup_name ::= NK_ID */
   403,  /* (404) index_name ::= NK_ID */
   430,  /* (405) expr_or_subquery ::= expression */
   425,  /* (406) expression ::= literal */
   425,  /* (407) expression ::= pseudo_column */
   425,  /* (408) expression ::= column_reference */
   425,  /* (409) expression ::= function_expression */
   425,  /* (410) expression ::= case_when_expression */
   425,  /* (411) expression ::= NK_LP expression NK_RP */
   425,  /* (412) expression ::= NK_PLUS expr_or_subquery */
   425,  /* (413) expression ::= NK_MINUS expr_or_subquery */
   425,  /* (414) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   425,  /* (415) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   425,  /* (416) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   425,  /* (417) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   425,  /* (418) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   425,  /* (419) expression ::= column_reference NK_ARROW NK_STRING */
   425,  /* (420) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   425,  /* (421) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   383,  /* (422) expression_list ::= expr_or_subquery */
   383,  /* (423) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   432,  /* (424) column_reference ::= column_name */
   432,  /* (425) column_reference ::= table_name NK_DOT column_name */
   431,  /* (426) pseudo_column ::= ROWTS */
   431,  /* (427) pseudo_column ::= TBNAME */
   431,  /* (428) pseudo_column ::= table_name NK_DOT TBNAME */
   431,  /* (429) pseudo_column ::= QSTART */
   431,  /* (430) pseudo_column ::= QEND */
   431,  /* (431) pseudo_column ::= QDURATION */
   431,  /* (432) pseudo_column ::= WSTART */
   431,  /* (433) pseudo_column ::= WEND */
   431,  /* (434) pseudo_column ::= WDURATION */
   431,  /* (435) pseudo_column ::= IROWTS */
   431,  /* (436) pseudo_column ::= ISFILLED */
   431,  /* (437) pseudo_column ::= QTAGS */
   433,  /* (438) function_expression ::= function_name NK_LP expression_list NK_RP */
   433,  /* (439) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   433,  /* (440) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   433,  /* (441) function_expression ::= literal_func */
   427,  /* (442) literal_func ::= noarg_func NK_LP NK_RP */
   427,  /* (443) literal_func ::= NOW */
   437,  /* (444) noarg_func ::= NOW */
   437,  /* (445) noarg_func ::= TODAY */
   437,  /* (446) noarg_func ::= TIMEZONE */
   437,  /* (447) noarg_func ::= DATABASE */
   437,  /* (448) noarg_func ::= CLIENT_VERSION */
   437,  /* (449) noarg_func ::= SERVER_VERSION */
   437,  /* (450) noarg_func ::= SERVER_STATUS */
   437,  /* (451) noarg_func ::= CURRENT_USER */
   437,  /* (452) noarg_func ::= USER */
   435,  /* (453) star_func ::= COUNT */
   435,  /* (454) star_func ::= FIRST */
   435,  /* (455) star_func ::= LAST */
   435,  /* (456) star_func ::= LAST_ROW */
   436,  /* (457) star_func_para_list ::= NK_STAR */
   436,  /* (458) star_func_para_list ::= other_para_list */
   438,  /* (459) other_para_list ::= star_func_para */
   438,  /* (460) other_para_list ::= other_para_list NK_COMMA star_func_para */
   439,  /* (461) star_func_para ::= expr_or_subquery */
   439,  /* (462) star_func_para ::= table_name NK_DOT NK_STAR */
   434,  /* (463) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   434,  /* (464) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   440,  /* (465) when_then_list ::= when_then_expr */
   440,  /* (466) when_then_list ::= when_then_list when_then_expr */
   443,  /* (467) when_then_expr ::= WHEN common_expression THEN common_expression */
   441,  /* (468) case_when_else_opt ::= */
   441,  /* (469) case_when_else_opt ::= ELSE common_expression */
   444,  /* (470) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   444,  /* (471) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   444,  /* (472) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   444,  /* (473) predicate ::= expr_or_subquery IS NULL */
   444,  /* (474) predicate ::= expr_or_subquery IS NOT NULL */
   444,  /* (475) predicate ::= expr_or_subquery in_op in_predicate_value */
   445,  /* (476) compare_op ::= NK_LT */
   445,  /* (477) compare_op ::= NK_GT */
   445,  /* (478) compare_op ::= NK_LE */
   445,  /* (479) compare_op ::= NK_GE */
   445,  /* (480) compare_op ::= NK_NE */
   445,  /* (481) compare_op ::= NK_EQ */
   445,  /* (482) compare_op ::= LIKE */
   445,  /* (483) compare_op ::= NOT LIKE */
   445,  /* (484) compare_op ::= MATCH */
   445,  /* (485) compare_op ::= NMATCH */
   445,  /* (486) compare_op ::= CONTAINS */
   446,  /* (487) in_op ::= IN */
   446,  /* (488) in_op ::= NOT IN */
   447,  /* (489) in_predicate_value ::= NK_LP literal_list NK_RP */
   448,  /* (490) boolean_value_expression ::= boolean_primary */
   448,  /* (491) boolean_value_expression ::= NOT boolean_primary */
   448,  /* (492) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   448,  /* (493) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   449,  /* (494) boolean_primary ::= predicate */
   449,  /* (495) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   442,  /* (496) common_expression ::= expr_or_subquery */
   442,  /* (497) common_expression ::= boolean_value_expression */
   450,  /* (498) from_clause_opt ::= */
   450,  /* (499) from_clause_opt ::= FROM table_reference_list */
   451,  /* (500) table_reference_list ::= table_reference */
   451,  /* (501) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   452,  /* (502) table_reference ::= table_primary */
   452,  /* (503) table_reference ::= joined_table */
   453,  /* (504) table_primary ::= table_name alias_opt */
   453,  /* (505) table_primary ::= db_name NK_DOT table_name alias_opt */
   453,  /* (506) table_primary ::= subquery alias_opt */
   453,  /* (507) table_primary ::= parenthesized_joined_table */
   455,  /* (508) alias_opt ::= */
   455,  /* (509) alias_opt ::= table_alias */
   455,  /* (510) alias_opt ::= AS table_alias */
   457,  /* (511) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   457,  /* (512) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   454,  /* (513) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
   458,  /* (514) join_type ::= */
   458,  /* (515) join_type ::= INNER */
   459,  /* (516) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
   460,  /* (517) set_quantifier_opt ::= */
   460,  /* (518) set_quantifier_opt ::= DISTINCT */
   460,  /* (519) set_quantifier_opt ::= ALL */
   461,  /* (520) select_list ::= select_item */
   461,  /* (521) select_list ::= select_list NK_COMMA select_item */
   469,  /* (522) select_item ::= NK_STAR */
   469,  /* (523) select_item ::= common_expression */
   469,  /* (524) select_item ::= common_expression column_alias */
   469,  /* (525) select_item ::= common_expression AS column_alias */
   469,  /* (526) select_item ::= table_name NK_DOT NK_STAR */
   410,  /* (527) where_clause_opt ::= */
   410,  /* (528) where_clause_opt ::= WHERE search_condition */
   462,  /* (529) partition_by_clause_opt ::= */
   462,  /* (530) partition_by_clause_opt ::= PARTITION BY partition_list */
   470,  /* (531) partition_list ::= partition_item */
   470,  /* (532) partition_list ::= partition_list NK_COMMA partition_item */
   471,  /* (533) partition_item ::= expr_or_subquery */
   471,  /* (534) partition_item ::= expr_or_subquery column_alias */
   471,  /* (535) partition_item ::= expr_or_subquery AS column_alias */
   466,  /* (536) twindow_clause_opt ::= */
   466,  /* (537) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   466,  /* (538) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   466,  /* (539) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   466,  /* (540) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   466,  /* (541) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
   405,  /* (542) sliding_opt ::= */
   405,  /* (543) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
   465,  /* (544) fill_opt ::= */
   465,  /* (545) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   465,  /* (546) fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
   465,  /* (547) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
   472,  /* (548) fill_mode ::= NONE */
   472,  /* (549) fill_mode ::= PREV */
   472,  /* (550) fill_mode ::= NULL */
   472,  /* (551) fill_mode ::= NULL_F */
   472,  /* (552) fill_mode ::= LINEAR */
   472,  /* (553) fill_mode ::= NEXT */
   467,  /* (554) group_by_clause_opt ::= */
   467,  /* (555) group_by_clause_opt ::= GROUP BY group_by_list */
   473,  /* (556) group_by_list ::= expr_or_subquery */
   473,  /* (557) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
   468,  /* (558) having_clause_opt ::= */
   468,  /* (559) having_clause_opt ::= HAVING search_condition */
   463,  /* (560) range_opt ::= */
   463,  /* (561) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
   463,  /* (562) range_opt ::= RANGE NK_LP expr_or_subquery NK_RP */
   464,  /* (563) every_opt ::= */
   464,  /* (564) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   474,  /* (565) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   475,  /* (566) query_simple ::= query_specification */
   475,  /* (567) query_simple ::= union_query_expression */
   479,  /* (568) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   479,  /* (569) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   480,  /* (570) query_simple_or_subquery ::= query_simple */
   480,  /* (571) query_simple_or_subquery ::= subquery */
   409,  /* (572) query_or_subquery ::= query_expression */
   409,  /* (573) query_or_subquery ::= subquery */
   476,  /* (574) order_by_clause_opt ::= */
   476,  /* (575) order_by_clause_opt ::= ORDER BY sort_specification_list */
   477,  /* (576) slimit_clause_opt ::= */
   477,  /* (577) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   477,  /* (578) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   477,  /* (579) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   478,  /* (580) limit_clause_opt ::= */
   478,  /* (581) limit_clause_opt ::= LIMIT NK_INTEGER */
   478,  /* (582) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   478,  /* (583) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   456,  /* (584) subquery ::= NK_LP query_expression NK_RP */
   456,  /* (585) subquery ::= NK_LP subquery NK_RP */
   352,  /* (586) search_condition ::= common_expression */
   481,  /* (587) sort_specification_list ::= sort_specification */
   481,  /* (588) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   482,  /* (589) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
   483,  /* (590) ordering_specification_opt ::= */
   483,  /* (591) ordering_specification_opt ::= ASC */
   483,  /* (592) ordering_specification_opt ::= DESC */
   484,  /* (593) null_ordering_opt ::= */
   484,  /* (594) null_ordering_opt ::= NULLS FIRST */
   484,  /* (595) null_ordering_opt ::= NULLS LAST */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -6,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   -4,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
    0,  /* (2) account_options ::= */
   -3,  /* (3) account_options ::= account_options PPS literal */
   -3,  /* (4) account_options ::= account_options TSERIES literal */
   -3,  /* (5) account_options ::= account_options STORAGE literal */
   -3,  /* (6) account_options ::= account_options STREAMS literal */
   -3,  /* (7) account_options ::= account_options QTIME literal */
   -3,  /* (8) account_options ::= account_options DBS literal */
   -3,  /* (9) account_options ::= account_options USERS literal */
   -3,  /* (10) account_options ::= account_options CONNS literal */
   -3,  /* (11) account_options ::= account_options STATE literal */
   -1,  /* (12) alter_account_options ::= alter_account_option */
   -2,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   -2,  /* (14) alter_account_option ::= PASS literal */
   -2,  /* (15) alter_account_option ::= PPS literal */
   -2,  /* (16) alter_account_option ::= TSERIES literal */
   -2,  /* (17) alter_account_option ::= STORAGE literal */
   -2,  /* (18) alter_account_option ::= STREAMS literal */
   -2,  /* (19) alter_account_option ::= QTIME literal */
   -2,  /* (20) alter_account_option ::= DBS literal */
   -2,  /* (21) alter_account_option ::= USERS literal */
   -2,  /* (22) alter_account_option ::= CONNS literal */
   -2,  /* (23) alter_account_option ::= STATE literal */
   -6,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   -5,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   -5,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   -5,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   -3,  /* (28) cmd ::= DROP USER user_name */
    0,  /* (29) sysinfo_opt ::= */
   -2,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   -7,  /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
   -7,  /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
   -1,  /* (33) privileges ::= ALL */
   -1,  /* (34) privileges ::= priv_type_list */
   -1,  /* (35) privileges ::= SUBSCRIBE */
   -1,  /* (36) priv_type_list ::= priv_type */
   -3,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   -1,  /* (38) priv_type ::= READ */
   -1,  /* (39) priv_type ::= WRITE */
   -3,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   -3,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   -3,  /* (42) priv_level ::= db_name NK_DOT table_name */
   -1,  /* (43) priv_level ::= topic_name */
    0,  /* (44) with_opt ::= */
   -2,  /* (45) with_opt ::= WITH search_condition */
   -3,  /* (46) cmd ::= CREATE DNODE dnode_endpoint */
   -5,  /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   -4,  /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
   -4,  /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
   -4,  /* (50) cmd ::= DROP DNODE NK_INTEGER unsafe_opt */
   -4,  /* (51) cmd ::= DROP DNODE dnode_endpoint unsafe_opt */
   -4,  /* (52) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   -5,  /* (53) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   -4,  /* (54) cmd ::= ALTER ALL DNODES NK_STRING */
   -5,  /* (55) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   -3,  /* (56) cmd ::= RESTORE DNODE NK_INTEGER */
   -1,  /* (57) dnode_endpoint ::= NK_STRING */
   -1,  /* (58) dnode_endpoint ::= NK_ID */
   -1,  /* (59) dnode_endpoint ::= NK_IPTOKEN */
    0,  /* (60) force_opt ::= */
   -1,  /* (61) force_opt ::= FORCE */
   -1,  /* (62) unsafe_opt ::= UNSAFE */
   -3,  /* (63) cmd ::= ALTER LOCAL NK_STRING */
   -4,  /* (64) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   -5,  /* (65) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   -5,  /* (66) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   -5,  /* (67) cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
   -5,  /* (68) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   -5,  /* (69) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   -5,  /* (70) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   -5,  /* (71) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   -5,  /* (72) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   -5,  /* (73) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   -5,  /* (74) cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
   -5,  /* (75) cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
   -5,  /* (76) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   -4,  /* (77) cmd ::= DROP DATABASE exists_opt db_name */
   -2,  /* (78) cmd ::= USE db_name */
   -4,  /* (79) cmd ::= ALTER DATABASE db_name alter_db_options */
   -3,  /* (80) cmd ::= FLUSH DATABASE db_name */
   -4,  /* (81) cmd ::= TRIM DATABASE db_name speed_opt */
   -5,  /* (82) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
   -3,  /* (83) not_exists_opt ::= IF NOT EXISTS */
    0,  /* (84) not_exists_opt ::= */
   -2,  /* (85) exists_opt ::= IF EXISTS */
    0,  /* (86) exists_opt ::= */
    0,  /* (87) db_options ::= */
   -3,  /* (88) db_options ::= db_options BUFFER NK_INTEGER */
   -3,  /* (89) db_options ::= db_options CACHEMODEL NK_STRING */
   -3,  /* (90) db_options ::= db_options CACHESIZE NK_INTEGER */
   -3,  /* (91) db_options ::= db_options COMP NK_INTEGER */
   -3,  /* (92) db_options ::= db_options DURATION NK_INTEGER */
   -3,  /* (93) db_options ::= db_options DURATION NK_VARIABLE */
   -3,  /* (94) db_options ::= db_options MAXROWS NK_INTEGER */
   -3,  /* (95) db_options ::= db_options MINROWS NK_INTEGER */
   -3,  /* (96) db_options ::= db_options KEEP integer_list */
   -3,  /* (97) db_options ::= db_options KEEP variable_list */
   -3,  /* (98) db_options ::= db_options PAGES NK_INTEGER */
   -3,  /* (99) db_options ::= db_options PAGESIZE NK_INTEGER */
   -3,  /* (100) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   -3,  /* (101) db_options ::= db_options PRECISION NK_STRING */
   -3,  /* (102) db_options ::= db_options REPLICA NK_INTEGER */
   -3,  /* (103) db_options ::= db_options VGROUPS NK_INTEGER */
   -3,  /* (104) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   -3,  /* (105) db_options ::= db_options RETENTIONS retention_list */
   -3,  /* (106) db_options ::= db_options SCHEMALESS NK_INTEGER */
   -3,  /* (107) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   -3,  /* (108) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   -3,  /* (109) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   -4,  /* (110) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -3,  /* (111) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   -4,  /* (112) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -3,  /* (113) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   -3,  /* (114) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   -3,  /* (115) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   -3,  /* (116) db_options ::= db_options TABLE_PREFIX signed */
   -3,  /* (117) db_options ::= db_options TABLE_SUFFIX signed */
   -1,  /* (118) alter_db_options ::= alter_db_option */
   -2,  /* (119) alter_db_options ::= alter_db_options alter_db_option */
   -2,  /* (120) alter_db_option ::= BUFFER NK_INTEGER */
   -2,  /* (121) alter_db_option ::= CACHEMODEL NK_STRING */
   -2,  /* (122) alter_db_option ::= CACHESIZE NK_INTEGER */
   -2,  /* (123) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   -2,  /* (124) alter_db_option ::= KEEP integer_list */
   -2,  /* (125) alter_db_option ::= KEEP variable_list */
   -2,  /* (126) alter_db_option ::= PAGES NK_INTEGER */
   -2,  /* (127) alter_db_option ::= REPLICA NK_INTEGER */
   -2,  /* (128) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   -2,  /* (129) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   -2,  /* (130) alter_db_option ::= MINROWS NK_INTEGER */
   -2,  /* (131) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
   -3,  /* (132) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -2,  /* (133) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
   -3,  /* (134) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -1,  /* (135) integer_list ::= NK_INTEGER */
   -3,  /* (136) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   -1,  /* (137) variable_list ::= NK_VARIABLE */
   -3,  /* (138) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   -1,  /* (139) retention_list ::= retention */
   -3,  /* (140) retention_list ::= retention_list NK_COMMA retention */
   -3,  /* (141) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
    0,  /* (142) speed_opt ::= */
   -2,  /* (143) speed_opt ::= MAX_SPEED NK_INTEGER */
    0,  /* (144) start_opt ::= */
   -3,  /* (145) start_opt ::= START WITH NK_INTEGER */
   -3,  /* (146) start_opt ::= START WITH NK_STRING */
   -4,  /* (147) start_opt ::= START WITH TIMESTAMP NK_STRING */
    0,  /* (148) end_opt ::= */
   -3,  /* (149) end_opt ::= END WITH NK_INTEGER */
   -3,  /* (150) end_opt ::= END WITH NK_STRING */
   -4,  /* (151) end_opt ::= END WITH TIMESTAMP NK_STRING */
   -9,  /* (152) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   -3,  /* (153) cmd ::= CREATE TABLE multi_create_clause */
   -9,  /* (154) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   -3,  /* (155) cmd ::= DROP TABLE multi_drop_clause */
   -4,  /* (156) cmd ::= DROP STABLE exists_opt full_table_name */
   -3,  /* (157) cmd ::= ALTER TABLE alter_table_clause */
   -3,  /* (158) cmd ::= ALTER STABLE alter_table_clause */
   -2,  /* (159) alter_table_clause ::= full_table_name alter_table_options */
   -5,  /* (160) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   -4,  /* (161) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   -5,  /* (162) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   -5,  /* (163) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   -5,  /* (164) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   -4,  /* (165) alter_table_clause ::= full_table_name DROP TAG column_name */
   -5,  /* (166) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   -5,  /* (167) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   -6,  /* (168) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   -1,  /* (169) multi_create_clause ::= create_subtable_clause */
   -2,  /* (170) multi_create_clause ::= multi_create_clause create_subtable_clause */
  -10,  /* (171) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   -1,  /* (172) multi_drop_clause ::= drop_table_clause */
   -3,  /* (173) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
   -2,  /* (174) drop_table_clause ::= exists_opt full_table_name */
    0,  /* (175) specific_cols_opt ::= */
   -3,  /* (176) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   -1,  /* (177) full_table_name ::= table_name */
   -3,  /* (178) full_table_name ::= db_name NK_DOT table_name */
   -1,  /* (179) column_def_list ::= column_def */
   -3,  /* (180) column_def_list ::= column_def_list NK_COMMA column_def */
   -2,  /* (181) column_def ::= column_name type_name */
   -1,  /* (182) type_name ::= BOOL */
   -1,  /* (183) type_name ::= TINYINT */
   -1,  /* (184) type_name ::= SMALLINT */
   -1,  /* (185) type_name ::= INT */
   -1,  /* (186) type_name ::= INTEGER */
   -1,  /* (187) type_name ::= BIGINT */
   -1,  /* (188) type_name ::= FLOAT */
   -1,  /* (189) type_name ::= DOUBLE */
   -4,  /* (190) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (191) type_name ::= TIMESTAMP */
   -4,  /* (192) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   -2,  /* (193) type_name ::= TINYINT UNSIGNED */
   -2,  /* (194) type_name ::= SMALLINT UNSIGNED */
   -2,  /* (195) type_name ::= INT UNSIGNED */
   -2,  /* (196) type_name ::= BIGINT UNSIGNED */
   -1,  /* (197) type_name ::= JSON */
   -4,  /* (198) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   -1,  /* (199) type_name ::= MEDIUMBLOB */
   -1,  /* (200) type_name ::= BLOB */
   -4,  /* (201) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   -4,  /* (202) type_name ::= GEOMETRY NK_LP NK_INTEGER NK_RP */
   -1,  /* (203) type_name ::= DECIMAL */
   -4,  /* (204) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   -6,  /* (205) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
    0,  /* (206) tags_def_opt ::= */
   -1,  /* (207) tags_def_opt ::= tags_def */
   -4,  /* (208) tags_def ::= TAGS NK_LP column_def_list NK_RP */
    0,  /* (209) table_options ::= */
   -3,  /* (210) table_options ::= table_options COMMENT NK_STRING */
   -3,  /* (211) table_options ::= table_options MAX_DELAY duration_list */
   -3,  /* (212) table_options ::= table_options WATERMARK duration_list */
   -5,  /* (213) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   -3,  /* (214) table_options ::= table_options TTL NK_INTEGER */
   -5,  /* (215) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   -3,  /* (216) table_options ::= table_options DELETE_MARK duration_list */
   -1,  /* (217) alter_table_options ::= alter_table_option */
   -2,  /* (218) alter_table_options ::= alter_table_options alter_table_option */
   -2,  /* (219) alter_table_option ::= COMMENT NK_STRING */
   -2,  /* (220) alter_table_option ::= TTL NK_INTEGER */
   -1,  /* (221) duration_list ::= duration_literal */
   -3,  /* (222) duration_list ::= duration_list NK_COMMA duration_literal */
   -1,  /* (223) rollup_func_list ::= rollup_func_name */
   -3,  /* (224) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   -1,  /* (225) rollup_func_name ::= function_name */
   -1,  /* (226) rollup_func_name ::= FIRST */
   -1,  /* (227) rollup_func_name ::= LAST */
   -1,  /* (228) col_name_list ::= col_name */
   -3,  /* (229) col_name_list ::= col_name_list NK_COMMA col_name */
   -1,  /* (230) col_name ::= column_name */
   -2,  /* (231) cmd ::= SHOW DNODES */
   -2,  /* (232) cmd ::= SHOW USERS */
   -3,  /* (233) cmd ::= SHOW USER PRIVILEGES */
   -2,  /* (234) cmd ::= SHOW DATABASES */
   -4,  /* (235) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   -4,  /* (236) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   -3,  /* (237) cmd ::= SHOW db_name_cond_opt VGROUPS */
   -2,  /* (238) cmd ::= SHOW MNODES */
   -2,  /* (239) cmd ::= SHOW QNODES */
   -2,  /* (240) cmd ::= SHOW FUNCTIONS */
   -5,  /* (241) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   -2,  /* (242) cmd ::= SHOW STREAMS */
   -2,  /* (243) cmd ::= SHOW ACCOUNTS */
   -2,  /* (244) cmd ::= SHOW APPS */
   -2,  /* (245) cmd ::= SHOW CONNECTIONS */
   -2,  /* (246) cmd ::= SHOW LICENCES */
   -2,  /* (247) cmd ::= SHOW GRANTS */
   -4,  /* (248) cmd ::= SHOW CREATE DATABASE db_name */
   -4,  /* (249) cmd ::= SHOW CREATE TABLE full_table_name */
   -4,  /* (250) cmd ::= SHOW CREATE STABLE full_table_name */
   -2,  /* (251) cmd ::= SHOW QUERIES */
   -2,  /* (252) cmd ::= SHOW SCORES */
   -2,  /* (253) cmd ::= SHOW TOPICS */
   -2,  /* (254) cmd ::= SHOW VARIABLES */
   -3,  /* (255) cmd ::= SHOW CLUSTER VARIABLES */
   -3,  /* (256) cmd ::= SHOW LOCAL VARIABLES */
   -5,  /* (257) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   -2,  /* (258) cmd ::= SHOW BNODES */
   -2,  /* (259) cmd ::= SHOW SNODES */
   -2,  /* (260) cmd ::= SHOW CLUSTER */
   -2,  /* (261) cmd ::= SHOW TRANSACTIONS */
   -4,  /* (262) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   -2,  /* (263) cmd ::= SHOW CONSUMERS */
   -2,  /* (264) cmd ::= SHOW SUBSCRIPTIONS */
   -5,  /* (265) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   -7,  /* (266) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   -3,  /* (267) cmd ::= SHOW VNODES NK_INTEGER */
   -3,  /* (268) cmd ::= SHOW VNODES NK_STRING */
   -3,  /* (269) cmd ::= SHOW db_name_cond_opt ALIVE */
   -3,  /* (270) cmd ::= SHOW CLUSTER ALIVE */
    0,  /* (271) db_name_cond_opt ::= */
   -2,  /* (272) db_name_cond_opt ::= db_name NK_DOT */
    0,  /* (273) like_pattern_opt ::= */
   -2,  /* (274) like_pattern_opt ::= LIKE NK_STRING */
   -1,  /* (275) table_name_cond ::= table_name */
    0,  /* (276) from_db_opt ::= */
   -2,  /* (277) from_db_opt ::= FROM db_name */
    0,  /* (278) tag_list_opt ::= */
   -1,  /* (279) tag_list_opt ::= tag_item */
   -3,  /* (280) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   -1,  /* (281) tag_item ::= TBNAME */
   -1,  /* (282) tag_item ::= QTAGS */
   -1,  /* (283) tag_item ::= column_name */
   -2,  /* (284) tag_item ::= column_name column_alias */
   -3,  /* (285) tag_item ::= column_name AS column_alias */
   -8,  /* (286) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   -9,  /* (287) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
   -4,  /* (288) cmd ::= DROP INDEX exists_opt full_index_name */
   -1,  /* (289) full_index_name ::= index_name */
   -3,  /* (290) full_index_name ::= db_name NK_DOT index_name */
  -10,  /* (291) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  -12,  /* (292) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   -1,  /* (293) func_list ::= func */
   -3,  /* (294) func_list ::= func_list NK_COMMA func */
   -4,  /* (295) func ::= sma_func_name NK_LP expression_list NK_RP */
   -1,  /* (296) sma_func_name ::= function_name */
   -1,  /* (297) sma_func_name ::= COUNT */
   -1,  /* (298) sma_func_name ::= FIRST */
   -1,  /* (299) sma_func_name ::= LAST */
   -1,  /* (300) sma_func_name ::= LAST_ROW */
    0,  /* (301) sma_stream_opt ::= */
   -3,  /* (302) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   -3,  /* (303) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   -3,  /* (304) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   -6,  /* (305) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   -7,  /* (306) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   -9,  /* (307) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   -8,  /* (308) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name where_clause_opt */
  -10,  /* (309) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name where_clause_opt */
   -4,  /* (310) cmd ::= DROP TOPIC exists_opt topic_name */
   -7,  /* (311) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   -2,  /* (312) cmd ::= DESC full_table_name */
   -2,  /* (313) cmd ::= DESCRIBE full_table_name */
   -3,  /* (314) cmd ::= RESET QUERY CACHE */
   -4,  /* (315) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   -4,  /* (316) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
    0,  /* (317) analyze_opt ::= */
   -1,  /* (318) analyze_opt ::= ANALYZE */
    0,  /* (319) explain_options ::= */
   -3,  /* (320) explain_options ::= explain_options VERBOSE NK_BOOL */
   -3,  /* (321) explain_options ::= explain_options RATIO NK_FLOAT */
  -12,  /* (322) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
   -4,  /* (323) cmd ::= DROP FUNCTION exists_opt function_name */
    0,  /* (324) agg_func_opt ::= */
   -1,  /* (325) agg_func_opt ::= AGGREGATE */
    0,  /* (326) bufsize_opt ::= */
   -2,  /* (327) bufsize_opt ::= BUFSIZE NK_INTEGER */
    0,  /* (328) language_opt ::= */
   -2,  /* (329) language_opt ::= LANGUAGE NK_STRING */
    0,  /* (330) or_replace_opt ::= */
   -2,  /* (331) or_replace_opt ::= OR REPLACE */
  -12,  /* (332) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
   -4,  /* (333) cmd ::= DROP STREAM exists_opt stream_name */
   -4,  /* (334) cmd ::= PAUSE STREAM exists_opt stream_name */
   -5,  /* (335) cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
    0,  /* (336) col_list_opt ::= */
   -3,  /* (337) col_list_opt ::= NK_LP col_name_list NK_RP */
    0,  /* (338) tag_def_or_ref_opt ::= */
   -1,  /* (339) tag_def_or_ref_opt ::= tags_def */
   -4,  /* (340) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
    0,  /* (341) stream_options ::= */
   -3,  /* (342) stream_options ::= stream_options TRIGGER AT_ONCE */
   -3,  /* (343) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   -4,  /* (344) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   -3,  /* (345) stream_options ::= stream_options WATERMARK duration_literal */
   -4,  /* (346) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   -3,  /* (347) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   -3,  /* (348) stream_options ::= stream_options DELETE_MARK duration_literal */
   -4,  /* (349) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
    0,  /* (350) subtable_opt ::= */
   -4,  /* (351) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
    0,  /* (352) ignore_opt ::= */
   -2,  /* (353) ignore_opt ::= IGNORE UNTREATED */
   -3,  /* (354) cmd ::= KILL CONNECTION NK_INTEGER */
   -3,  /* (355) cmd ::= KILL QUERY NK_STRING */
   -3,  /* (356) cmd ::= KILL TRANSACTION NK_INTEGER */
   -2,  /* (357) cmd ::= BALANCE VGROUP */
   -3,  /* (358) cmd ::= BALANCE VGROUP LEADER */
   -4,  /* (359) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   -4,  /* (360) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   -3,  /* (361) cmd ::= SPLIT VGROUP NK_INTEGER */
   -2,  /* (362) dnode_list ::= DNODE NK_INTEGER */
   -3,  /* (363) dnode_list ::= dnode_list DNODE NK_INTEGER */
   -4,  /* (364) cmd ::= DELETE FROM full_table_name where_clause_opt */
   -1,  /* (365) cmd ::= query_or_subquery */
   -1,  /* (366) cmd ::= insert_query */
   -7,  /* (367) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   -4,  /* (368) insert_query ::= INSERT INTO full_table_name query_or_subquery */
   -1,  /* (369) literal ::= NK_INTEGER */
   -1,  /* (370) literal ::= NK_FLOAT */
   -1,  /* (371) literal ::= NK_STRING */
   -1,  /* (372) literal ::= NK_BOOL */
   -2,  /* (373) literal ::= TIMESTAMP NK_STRING */
   -1,  /* (374) literal ::= duration_literal */
   -1,  /* (375) literal ::= NULL */
   -1,  /* (376) literal ::= NK_QUESTION */
   -1,  /* (377) duration_literal ::= NK_VARIABLE */
   -1,  /* (378) signed ::= NK_INTEGER */
   -2,  /* (379) signed ::= NK_PLUS NK_INTEGER */
   -2,  /* (380) signed ::= NK_MINUS NK_INTEGER */
   -1,  /* (381) signed ::= NK_FLOAT */
   -2,  /* (382) signed ::= NK_PLUS NK_FLOAT */
   -2,  /* (383) signed ::= NK_MINUS NK_FLOAT */
   -1,  /* (384) signed_literal ::= signed */
   -1,  /* (385) signed_literal ::= NK_STRING */
   -1,  /* (386) signed_literal ::= NK_BOOL */
   -2,  /* (387) signed_literal ::= TIMESTAMP NK_STRING */
   -1,  /* (388) signed_literal ::= duration_literal */
   -1,  /* (389) signed_literal ::= NULL */
   -1,  /* (390) signed_literal ::= literal_func */
   -1,  /* (391) signed_literal ::= NK_QUESTION */
   -1,  /* (392) literal_list ::= signed_literal */
   -3,  /* (393) literal_list ::= literal_list NK_COMMA signed_literal */
   -1,  /* (394) db_name ::= NK_ID */
   -1,  /* (395) table_name ::= NK_ID */
   -1,  /* (396) column_name ::= NK_ID */
   -1,  /* (397) function_name ::= NK_ID */
   -1,  /* (398) table_alias ::= NK_ID */
   -1,  /* (399) column_alias ::= NK_ID */
   -1,  /* (400) user_name ::= NK_ID */
   -1,  /* (401) topic_name ::= NK_ID */
   -1,  /* (402) stream_name ::= NK_ID */
   -1,  /* (403) cgroup_name ::= NK_ID */
   -1,  /* (404) index_name ::= NK_ID */
   -1,  /* (405) expr_or_subquery ::= expression */
   -1,  /* (406) expression ::= literal */
   -1,  /* (407) expression ::= pseudo_column */
   -1,  /* (408) expression ::= column_reference */
   -1,  /* (409) expression ::= function_expression */
   -1,  /* (410) expression ::= case_when_expression */
   -3,  /* (411) expression ::= NK_LP expression NK_RP */
   -2,  /* (412) expression ::= NK_PLUS expr_or_subquery */
   -2,  /* (413) expression ::= NK_MINUS expr_or_subquery */
   -3,  /* (414) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   -3,  /* (415) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   -3,  /* (416) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   -3,  /* (417) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   -3,  /* (418) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   -3,  /* (419) expression ::= column_reference NK_ARROW NK_STRING */
   -3,  /* (420) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   -3,  /* (421) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   -1,  /* (422) expression_list ::= expr_or_subquery */
   -3,  /* (423) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   -1,  /* (424) column_reference ::= column_name */
   -3,  /* (425) column_reference ::= table_name NK_DOT column_name */
   -1,  /* (426) pseudo_column ::= ROWTS */
   -1,  /* (427) pseudo_column ::= TBNAME */
   -3,  /* (428) pseudo_column ::= table_name NK_DOT TBNAME */
   -1,  /* (429) pseudo_column ::= QSTART */
   -1,  /* (430) pseudo_column ::= QEND */
   -1,  /* (431) pseudo_column ::= QDURATION */
   -1,  /* (432) pseudo_column ::= WSTART */
   -1,  /* (433) pseudo_column ::= WEND */
   -1,  /* (434) pseudo_column ::= WDURATION */
   -1,  /* (435) pseudo_column ::= IROWTS */
   -1,  /* (436) pseudo_column ::= ISFILLED */
   -1,  /* (437) pseudo_column ::= QTAGS */
   -4,  /* (438) function_expression ::= function_name NK_LP expression_list NK_RP */
   -4,  /* (439) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   -6,  /* (440) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   -1,  /* (441) function_expression ::= literal_func */
   -3,  /* (442) literal_func ::= noarg_func NK_LP NK_RP */
   -1,  /* (443) literal_func ::= NOW */
   -1,  /* (444) noarg_func ::= NOW */
   -1,  /* (445) noarg_func ::= TODAY */
   -1,  /* (446) noarg_func ::= TIMEZONE */
   -1,  /* (447) noarg_func ::= DATABASE */
   -1,  /* (448) noarg_func ::= CLIENT_VERSION */
   -1,  /* (449) noarg_func ::= SERVER_VERSION */
   -1,  /* (450) noarg_func ::= SERVER_STATUS */
   -1,  /* (451) noarg_func ::= CURRENT_USER */
   -1,  /* (452) noarg_func ::= USER */
   -1,  /* (453) star_func ::= COUNT */
   -1,  /* (454) star_func ::= FIRST */
   -1,  /* (455) star_func ::= LAST */
   -1,  /* (456) star_func ::= LAST_ROW */
   -1,  /* (457) star_func_para_list ::= NK_STAR */
   -1,  /* (458) star_func_para_list ::= other_para_list */
   -1,  /* (459) other_para_list ::= star_func_para */
   -3,  /* (460) other_para_list ::= other_para_list NK_COMMA star_func_para */
   -1,  /* (461) star_func_para ::= expr_or_subquery */
   -3,  /* (462) star_func_para ::= table_name NK_DOT NK_STAR */
   -4,  /* (463) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   -5,  /* (464) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   -1,  /* (465) when_then_list ::= when_then_expr */
   -2,  /* (466) when_then_list ::= when_then_list when_then_expr */
   -4,  /* (467) when_then_expr ::= WHEN common_expression THEN common_expression */
    0,  /* (468) case_when_else_opt ::= */
   -2,  /* (469) case_when_else_opt ::= ELSE common_expression */
   -3,  /* (470) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   -5,  /* (471) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   -6,  /* (472) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   -3,  /* (473) predicate ::= expr_or_subquery IS NULL */
   -4,  /* (474) predicate ::= expr_or_subquery IS NOT NULL */
   -3,  /* (475) predicate ::= expr_or_subquery in_op in_predicate_value */
   -1,  /* (476) compare_op ::= NK_LT */
   -1,  /* (477) compare_op ::= NK_GT */
   -1,  /* (478) compare_op ::= NK_LE */
   -1,  /* (479) compare_op ::= NK_GE */
   -1,  /* (480) compare_op ::= NK_NE */
   -1,  /* (481) compare_op ::= NK_EQ */
   -1,  /* (482) compare_op ::= LIKE */
   -2,  /* (483) compare_op ::= NOT LIKE */
   -1,  /* (484) compare_op ::= MATCH */
   -1,  /* (485) compare_op ::= NMATCH */
   -1,  /* (486) compare_op ::= CONTAINS */
   -1,  /* (487) in_op ::= IN */
   -2,  /* (488) in_op ::= NOT IN */
   -3,  /* (489) in_predicate_value ::= NK_LP literal_list NK_RP */
   -1,  /* (490) boolean_value_expression ::= boolean_primary */
   -2,  /* (491) boolean_value_expression ::= NOT boolean_primary */
   -3,  /* (492) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   -3,  /* (493) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   -1,  /* (494) boolean_primary ::= predicate */
   -3,  /* (495) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   -1,  /* (496) common_expression ::= expr_or_subquery */
   -1,  /* (497) common_expression ::= boolean_value_expression */
    0,  /* (498) from_clause_opt ::= */
   -2,  /* (499) from_clause_opt ::= FROM table_reference_list */
   -1,  /* (500) table_reference_list ::= table_reference */
   -3,  /* (501) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   -1,  /* (502) table_reference ::= table_primary */
   -1,  /* (503) table_reference ::= joined_table */
   -2,  /* (504) table_primary ::= table_name alias_opt */
   -4,  /* (505) table_primary ::= db_name NK_DOT table_name alias_opt */
   -2,  /* (506) table_primary ::= subquery alias_opt */
   -1,  /* (507) table_primary ::= parenthesized_joined_table */
    0,  /* (508) alias_opt ::= */
   -1,  /* (509) alias_opt ::= table_alias */
   -2,  /* (510) alias_opt ::= AS table_alias */
   -3,  /* (511) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   -3,  /* (512) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   -6,  /* (513) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
    0,  /* (514) join_type ::= */
   -1,  /* (515) join_type ::= INNER */
  -12,  /* (516) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
    0,  /* (517) set_quantifier_opt ::= */
   -1,  /* (518) set_quantifier_opt ::= DISTINCT */
   -1,  /* (519) set_quantifier_opt ::= ALL */
   -1,  /* (520) select_list ::= select_item */
   -3,  /* (521) select_list ::= select_list NK_COMMA select_item */
   -1,  /* (522) select_item ::= NK_STAR */
   -1,  /* (523) select_item ::= common_expression */
   -2,  /* (524) select_item ::= common_expression column_alias */
   -3,  /* (525) select_item ::= common_expression AS column_alias */
   -3,  /* (526) select_item ::= table_name NK_DOT NK_STAR */
    0,  /* (527) where_clause_opt ::= */
   -2,  /* (528) where_clause_opt ::= WHERE search_condition */
    0,  /* (529) partition_by_clause_opt ::= */
   -3,  /* (530) partition_by_clause_opt ::= PARTITION BY partition_list */
   -1,  /* (531) partition_list ::= partition_item */
   -3,  /* (532) partition_list ::= partition_list NK_COMMA partition_item */
   -1,  /* (533) partition_item ::= expr_or_subquery */
   -2,  /* (534) partition_item ::= expr_or_subquery column_alias */
   -3,  /* (535) partition_item ::= expr_or_subquery AS column_alias */
    0,  /* (536) twindow_clause_opt ::= */
   -6,  /* (537) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   -4,  /* (538) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   -6,  /* (539) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   -8,  /* (540) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   -7,  /* (541) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
    0,  /* (542) sliding_opt ::= */
   -4,  /* (543) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
    0,  /* (544) fill_opt ::= */
   -4,  /* (545) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   -6,  /* (546) fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
   -6,  /* (547) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
   -1,  /* (548) fill_mode ::= NONE */
   -1,  /* (549) fill_mode ::= PREV */
   -1,  /* (550) fill_mode ::= NULL */
   -1,  /* (551) fill_mode ::= NULL_F */
   -1,  /* (552) fill_mode ::= LINEAR */
   -1,  /* (553) fill_mode ::= NEXT */
    0,  /* (554) group_by_clause_opt ::= */
   -3,  /* (555) group_by_clause_opt ::= GROUP BY group_by_list */
   -1,  /* (556) group_by_list ::= expr_or_subquery */
   -3,  /* (557) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
    0,  /* (558) having_clause_opt ::= */
   -2,  /* (559) having_clause_opt ::= HAVING search_condition */
    0,  /* (560) range_opt ::= */
   -6,  /* (561) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
   -4,  /* (562) range_opt ::= RANGE NK_LP expr_or_subquery NK_RP */
    0,  /* (563) every_opt ::= */
   -4,  /* (564) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   -4,  /* (565) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   -1,  /* (566) query_simple ::= query_specification */
   -1,  /* (567) query_simple ::= union_query_expression */
   -4,  /* (568) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   -3,  /* (569) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   -1,  /* (570) query_simple_or_subquery ::= query_simple */
   -1,  /* (571) query_simple_or_subquery ::= subquery */
   -1,  /* (572) query_or_subquery ::= query_expression */
   -1,  /* (573) query_or_subquery ::= subquery */
    0,  /* (574) order_by_clause_opt ::= */
   -3,  /* (575) order_by_clause_opt ::= ORDER BY sort_specification_list */
    0,  /* (576) slimit_clause_opt ::= */
   -2,  /* (577) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   -4,  /* (578) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   -4,  /* (579) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
    0,  /* (580) limit_clause_opt ::= */
   -2,  /* (581) limit_clause_opt ::= LIMIT NK_INTEGER */
   -4,  /* (582) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   -4,  /* (583) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   -3,  /* (584) subquery ::= NK_LP query_expression NK_RP */
   -3,  /* (585) subquery ::= NK_LP subquery NK_RP */
   -1,  /* (586) search_condition ::= common_expression */
   -1,  /* (587) sort_specification_list ::= sort_specification */
   -3,  /* (588) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   -3,  /* (589) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
    0,  /* (590) ordering_specification_opt ::= */
   -1,  /* (591) ordering_specification_opt ::= ASC */
   -1,  /* (592) ordering_specification_opt ::= DESC */
    0,  /* (593) null_ordering_opt ::= */
   -2,  /* (594) null_ordering_opt ::= NULLS FIRST */
   -2,  /* (595) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,338,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,339,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,338,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,340,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,341,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,339,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,341,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,340,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy669, &yymsp[-1].minor.yy0, yymsp[0].minor.yy73); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy669, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy669, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy669, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy669); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy73 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy73 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-5].minor.yy349, &yymsp[-3].minor.yy257, &yymsp[0].minor.yy669, yymsp[-2].minor.yy242); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-5].minor.yy349, &yymsp[-3].minor.yy257, &yymsp[0].minor.yy669, yymsp[-2].minor.yy242); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy349 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy349 = yymsp[0].minor.yy349; }
  yymsp[0].minor.yy349 = yylhsminor.yy349;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy349 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy349 = yymsp[-2].minor.yy349 | yymsp[0].minor.yy349; }
  yymsp[-2].minor.yy349 = yylhsminor.yy349;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy349 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy349 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy257.first = yymsp[-2].minor.yy0; yylhsminor.yy257.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy257 = yylhsminor.yy257;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy257.first = yymsp[-2].minor.yy669; yylhsminor.yy257.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy257 = yylhsminor.yy257;
        break;
      case 42: /* priv_level ::= db_name NK_DOT table_name */
{ yylhsminor.yy257.first = yymsp[-2].minor.yy669; yylhsminor.yy257.second = yymsp[0].minor.yy669; }
  yymsp[-2].minor.yy257 = yylhsminor.yy257;
        break;
      case 43: /* priv_level ::= topic_name */
{ yylhsminor.yy257.first = yymsp[0].minor.yy669; yylhsminor.yy257.second = nil_token; }
  yymsp[0].minor.yy257 = yylhsminor.yy257;
        break;
      case 44: /* with_opt ::= */
      case 144: /* start_opt ::= */ yytestcase(yyruleno==144);
      case 148: /* end_opt ::= */ yytestcase(yyruleno==148);
      case 273: /* like_pattern_opt ::= */ yytestcase(yyruleno==273);
      case 350: /* subtable_opt ::= */ yytestcase(yyruleno==350);
      case 468: /* case_when_else_opt ::= */ yytestcase(yyruleno==468);
      case 498: /* from_clause_opt ::= */ yytestcase(yyruleno==498);
      case 527: /* where_clause_opt ::= */ yytestcase(yyruleno==527);
      case 536: /* twindow_clause_opt ::= */ yytestcase(yyruleno==536);
      case 542: /* sliding_opt ::= */ yytestcase(yyruleno==542);
      case 544: /* fill_opt ::= */ yytestcase(yyruleno==544);
      case 558: /* having_clause_opt ::= */ yytestcase(yyruleno==558);
      case 560: /* range_opt ::= */ yytestcase(yyruleno==560);
      case 563: /* every_opt ::= */ yytestcase(yyruleno==563);
      case 576: /* slimit_clause_opt ::= */ yytestcase(yyruleno==576);
      case 580: /* limit_clause_opt ::= */ yytestcase(yyruleno==580);
{ yymsp[1].minor.yy242 = NULL; }
        break;
      case 45: /* with_opt ::= WITH search_condition */
      case 499: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==499);
      case 528: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==528);
      case 559: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==559);
{ yymsp[-1].minor.yy242 = yymsp[0].minor.yy242; }
        break;
      case 46: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy669, NULL); }
        break;
      case 47: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy669, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy777, false); }
        break;
      case 49: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy669, yymsp[0].minor.yy777, false); }
        break;
      case 50: /* cmd ::= DROP DNODE NK_INTEGER unsafe_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, false, yymsp[0].minor.yy777); }
        break;
      case 51: /* cmd ::= DROP DNODE dnode_endpoint unsafe_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy669, false, yymsp[0].minor.yy777); }
        break;
      case 52: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 55: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= RESTORE DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_DNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* dnode_endpoint ::= NK_STRING */
      case 58: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==58);
      case 59: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==59);
      case 297: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==297);
      case 298: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==298);
      case 299: /* sma_func_name ::= LAST */ yytestcase(yyruleno==299);
      case 300: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==300);
      case 394: /* db_name ::= NK_ID */ yytestcase(yyruleno==394);
      case 395: /* table_name ::= NK_ID */ yytestcase(yyruleno==395);
      case 396: /* column_name ::= NK_ID */ yytestcase(yyruleno==396);
      case 397: /* function_name ::= NK_ID */ yytestcase(yyruleno==397);
      case 398: /* table_alias ::= NK_ID */ yytestcase(yyruleno==398);
      case 399: /* column_alias ::= NK_ID */ yytestcase(yyruleno==399);
      case 400: /* user_name ::= NK_ID */ yytestcase(yyruleno==400);
      case 401: /* topic_name ::= NK_ID */ yytestcase(yyruleno==401);
      case 402: /* stream_name ::= NK_ID */ yytestcase(yyruleno==402);
      case 403: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==403);
      case 404: /* index_name ::= NK_ID */ yytestcase(yyruleno==404);
      case 444: /* noarg_func ::= NOW */ yytestcase(yyruleno==444);
      case 445: /* noarg_func ::= TODAY */ yytestcase(yyruleno==445);
      case 446: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==446);
      case 447: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==447);
      case 448: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==448);
      case 449: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==449);
      case 450: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==450);
      case 451: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==451);
      case 452: /* noarg_func ::= USER */ yytestcase(yyruleno==452);
      case 453: /* star_func ::= COUNT */ yytestcase(yyruleno==453);
      case 454: /* star_func ::= FIRST */ yytestcase(yyruleno==454);
      case 455: /* star_func ::= LAST */ yytestcase(yyruleno==455);
      case 456: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==456);
{ yylhsminor.yy669 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy669 = yylhsminor.yy669;
        break;
      case 60: /* force_opt ::= */
      case 84: /* not_exists_opt ::= */ yytestcase(yyruleno==84);
      case 86: /* exists_opt ::= */ yytestcase(yyruleno==86);
      case 317: /* analyze_opt ::= */ yytestcase(yyruleno==317);
      case 324: /* agg_func_opt ::= */ yytestcase(yyruleno==324);
      case 330: /* or_replace_opt ::= */ yytestcase(yyruleno==330);
      case 352: /* ignore_opt ::= */ yytestcase(yyruleno==352);
      case 517: /* set_quantifier_opt ::= */ yytestcase(yyruleno==517);
{ yymsp[1].minor.yy777 = false; }
        break;
      case 61: /* force_opt ::= FORCE */
      case 62: /* unsafe_opt ::= UNSAFE */ yytestcase(yyruleno==62);
      case 318: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==318);
      case 325: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==325);
      case 518: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==518);
{ yymsp[0].minor.yy777 = true; }
        break;
      case 63: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 64: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 67: /* cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 68: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 69: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 70: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 71: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 72: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 73: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 74: /* cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 75: /* cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_VNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 76: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy777, &yymsp[-1].minor.yy669, yymsp[0].minor.yy242); }
        break;
      case 77: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy777, &yymsp[0].minor.yy669); }
        break;
      case 78: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy669); }
        break;
      case 79: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy669, yymsp[0].minor.yy242); }
        break;
      case 80: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy669); }
        break;
      case 81: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy669, yymsp[0].minor.yy120); }
        break;
      case 82: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy669, yymsp[-1].minor.yy242, yymsp[0].minor.yy242); }
        break;
      case 83: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy777 = true; }
        break;
      case 85: /* exists_opt ::= IF EXISTS */
      case 331: /* or_replace_opt ::= OR REPLACE */ yytestcase(yyruleno==331);
      case 353: /* ignore_opt ::= IGNORE UNTREATED */ yytestcase(yyruleno==353);
{ yymsp[-1].minor.yy777 = true; }
        break;
      case 87: /* db_options ::= */
{ yymsp[1].minor.yy242 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 88: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 89: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 90: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 91: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 92: /* db_options ::= db_options DURATION NK_INTEGER */
      case 93: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==93);
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 94: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 95: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 96: /* db_options ::= db_options KEEP integer_list */
      case 97: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==97);
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_KEEP, yymsp[0].minor.yy174); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 98: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 99: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 100: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 101: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 102: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 103: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 104: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 105: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_RETENTIONS, yymsp[0].minor.yy174); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 106: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 107: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 108: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 109: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 110: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-3].minor.yy242, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 111: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 112: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-3].minor.yy242, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 113: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 114: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 115: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 116: /* db_options ::= db_options TABLE_PREFIX signed */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_TABLE_PREFIX, yymsp[0].minor.yy242); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 117: /* db_options ::= db_options TABLE_SUFFIX signed */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_TABLE_SUFFIX, yymsp[0].minor.yy242); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 118: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy242 = createAlterDatabaseOptions(pCxt); yylhsminor.yy242 = setAlterDatabaseOption(pCxt, yylhsminor.yy242, &yymsp[0].minor.yy535); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 119: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy242 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy242, &yymsp[0].minor.yy535); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 120: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 121: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy535.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 122: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 123: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 124: /* alter_db_option ::= KEEP integer_list */
      case 125: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==125);
{ yymsp[-1].minor.yy535.type = DB_OPTION_KEEP; yymsp[-1].minor.yy535.pList = yymsp[0].minor.yy174; }
        break;
      case 126: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_PAGES; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 127: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 128: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_WAL; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 129: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 130: /* alter_db_option ::= MINROWS NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_MINROWS; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 131: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 132: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy535.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-2].minor.yy535.val = t;
                                                                                  }
        break;
      case 133: /* alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 134: /* alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy535.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-2].minor.yy535.val = t;
                                                                                  }
        break;
      case 135: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy174 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy174 = yylhsminor.yy174;
        break;
      case 136: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 363: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==363);
{ yylhsminor.yy174 = addNodeToList(pCxt, yymsp[-2].minor.yy174, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy174 = yylhsminor.yy174;
        break;
      case 137: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy174 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy174 = yylhsminor.yy174;
        break;
      case 138: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy174 = addNodeToList(pCxt, yymsp[-2].minor.yy174, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy174 = yylhsminor.yy174;
        break;
      case 139: /* retention_list ::= retention */
      case 169: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==169);
      case 172: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==172);
      case 179: /* column_def_list ::= column_def */ yytestcase(yyruleno==179);
      case 223: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==223);
      case 228: /* col_name_list ::= col_name */ yytestcase(yyruleno==228);
      case 279: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==279);
      case 293: /* func_list ::= func */ yytestcase(yyruleno==293);
      case 392: /* literal_list ::= signed_literal */ yytestcase(yyruleno==392);
      case 459: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==459);
      case 465: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==465);
      case 520: /* select_list ::= select_item */ yytestcase(yyruleno==520);
      case 531: /* partition_list ::= partition_item */ yytestcase(yyruleno==531);
      case 587: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==587);
{ yylhsminor.yy174 = createNodeList(pCxt, yymsp[0].minor.yy242); }
  yymsp[0].minor.yy174 = yylhsminor.yy174;
        break;
      case 140: /* retention_list ::= retention_list NK_COMMA retention */
      case 173: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==173);
      case 180: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==180);
      case 224: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==224);
      case 229: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==229);
      case 280: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==280);
      case 294: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==294);
      case 393: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==393);
      case 460: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==460);
      case 521: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==521);
      case 532: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==532);
      case 588: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==588);
{ yylhsminor.yy174 = addNodeToList(pCxt, yymsp[-2].minor.yy174, yymsp[0].minor.yy242); }
  yymsp[-2].minor.yy174 = yylhsminor.yy174;
        break;
      case 141: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy242 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 142: /* speed_opt ::= */
      case 326: /* bufsize_opt ::= */ yytestcase(yyruleno==326);
{ yymsp[1].minor.yy120 = 0; }
        break;
      case 143: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 327: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==327);
{ yymsp[-1].minor.yy120 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 145: /* start_opt ::= START WITH NK_INTEGER */
      case 149: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==149);
{ yymsp[-2].minor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 146: /* start_opt ::= START WITH NK_STRING */
      case 150: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==150);
{ yymsp[-2].minor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 147: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 151: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==151);
{ yymsp[-3].minor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 152: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 154: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==154);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy777, yymsp[-5].minor.yy242, yymsp[-3].minor.yy174, yymsp[-1].minor.yy174, yymsp[0].minor.yy242); }
        break;
      case 153: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy174); }
        break;
      case 155: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy174); }
        break;
      case 156: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy777, yymsp[0].minor.yy242); }
        break;
      case 157: /* cmd ::= ALTER TABLE alter_table_clause */
      case 365: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==365);
      case 366: /* cmd ::= insert_query */ yytestcase(yyruleno==366);
{ pCxt->pRootNode = yymsp[0].minor.yy242; }
        break;
      case 158: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy242); }
        break;
      case 159: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy242 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy242, yymsp[0].minor.yy242); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 160: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy242 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy242, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy669, yymsp[0].minor.yy794); }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 161: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy242 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy242, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy669); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 162: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy242 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy242, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy669, yymsp[0].minor.yy794); }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 163: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy242 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy242, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy669, &yymsp[0].minor.yy669); }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 164: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy242 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy242, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy669, yymsp[0].minor.yy794); }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 165: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy242 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy242, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy669); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 166: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy242 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy242, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy669, yymsp[0].minor.yy794); }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 167: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy242 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy242, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy669, &yymsp[0].minor.yy669); }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 168: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy242 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy242, &yymsp[-2].minor.yy669, yymsp[0].minor.yy242); }
  yymsp[-5].minor.yy242 = yylhsminor.yy242;
        break;
      case 170: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 466: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==466);
{ yylhsminor.yy174 = addNodeToList(pCxt, yymsp[-1].minor.yy174, yymsp[0].minor.yy242); }
  yymsp[-1].minor.yy174 = yylhsminor.yy174;
        break;
      case 171: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy242 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy777, yymsp[-8].minor.yy242, yymsp[-6].minor.yy242, yymsp[-5].minor.yy174, yymsp[-2].minor.yy174, yymsp[0].minor.yy242); }
  yymsp[-9].minor.yy242 = yylhsminor.yy242;
        break;
      case 174: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy242 = createDropTableClause(pCxt, yymsp[-1].minor.yy777, yymsp[0].minor.yy242); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 175: /* specific_cols_opt ::= */
      case 206: /* tags_def_opt ::= */ yytestcase(yyruleno==206);
      case 278: /* tag_list_opt ::= */ yytestcase(yyruleno==278);
      case 336: /* col_list_opt ::= */ yytestcase(yyruleno==336);
      case 338: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==338);
      case 529: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==529);
      case 554: /* group_by_clause_opt ::= */ yytestcase(yyruleno==554);
      case 574: /* order_by_clause_opt ::= */ yytestcase(yyruleno==574);
{ yymsp[1].minor.yy174 = NULL; }
        break;
      case 176: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 337: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==337);
{ yymsp[-2].minor.yy174 = yymsp[-1].minor.yy174; }
        break;
      case 177: /* full_table_name ::= table_name */
{ yylhsminor.yy242 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy669, NULL); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 178: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy242 = createRealTableNode(pCxt, &yymsp[-2].minor.yy669, &yymsp[0].minor.yy669, NULL); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 181: /* column_def ::= column_name type_name */
{ yylhsminor.yy242 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy669, yymsp[0].minor.yy794, NULL); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 182: /* type_name ::= BOOL */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 183: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 184: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 185: /* type_name ::= INT */
      case 186: /* type_name ::= INTEGER */ yytestcase(yyruleno==186);
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 187: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 188: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 189: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 190: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy794 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 191: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 192: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy794 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 193: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy794 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 194: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy794 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 195: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy794 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 196: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy794 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 197: /* type_name ::= JSON */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 198: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy794 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 199: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 200: /* type_name ::= BLOB */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 201: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy794 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 202: /* type_name ::= GEOMETRY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy794 = createVarLenDataType(TSDB_DATA_TYPE_GEOMETRY, &yymsp[-1].minor.yy0); }
        break;
      case 203: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 204: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy794 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 205: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy794 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 207: /* tags_def_opt ::= tags_def */
      case 339: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==339);
      case 458: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==458);
{ yylhsminor.yy174 = yymsp[0].minor.yy174; }
  yymsp[0].minor.yy174 = yylhsminor.yy174;
        break;
      case 208: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 340: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==340);
{ yymsp[-3].minor.yy174 = yymsp[-1].minor.yy174; }
        break;
      case 209: /* table_options ::= */
{ yymsp[1].minor.yy242 = createDefaultTableOptions(pCxt); }
        break;
      case 210: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy242 = setTableOption(pCxt, yymsp[-2].minor.yy242, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 211: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy242 = setTableOption(pCxt, yymsp[-2].minor.yy242, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy174); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 212: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy242 = setTableOption(pCxt, yymsp[-2].minor.yy242, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy174); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 213: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy242 = setTableOption(pCxt, yymsp[-4].minor.yy242, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy174); }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 214: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy242 = setTableOption(pCxt, yymsp[-2].minor.yy242, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 215: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy242 = setTableOption(pCxt, yymsp[-4].minor.yy242, TABLE_OPTION_SMA, yymsp[-1].minor.yy174); }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 216: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy242 = setTableOption(pCxt, yymsp[-2].minor.yy242, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy174); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 217: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy242 = createAlterTableOptions(pCxt); yylhsminor.yy242 = setTableOption(pCxt, yylhsminor.yy242, yymsp[0].minor.yy535.type, &yymsp[0].minor.yy535.val); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 218: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy242 = setTableOption(pCxt, yymsp[-1].minor.yy242, yymsp[0].minor.yy535.type, &yymsp[0].minor.yy535.val); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 219: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy535.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 220: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy535.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 221: /* duration_list ::= duration_literal */
      case 422: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==422);
{ yylhsminor.yy174 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy242)); }
  yymsp[0].minor.yy174 = yylhsminor.yy174;
        break;
      case 222: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 423: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==423);
{ yylhsminor.yy174 = addNodeToList(pCxt, yymsp[-2].minor.yy174, releaseRawExprNode(pCxt, yymsp[0].minor.yy242)); }
  yymsp[-2].minor.yy174 = yylhsminor.yy174;
        break;
      case 225: /* rollup_func_name ::= function_name */
{ yylhsminor.yy242 = createFunctionNode(pCxt, &yymsp[0].minor.yy669, NULL); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 226: /* rollup_func_name ::= FIRST */
      case 227: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==227);
      case 282: /* tag_item ::= QTAGS */ yytestcase(yyruleno==282);
{ yylhsminor.yy242 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 230: /* col_name ::= column_name */
      case 283: /* tag_item ::= column_name */ yytestcase(yyruleno==283);
{ yylhsminor.yy242 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy669); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 231: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 232: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 233: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 234: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 235: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, OP_TYPE_LIKE); }
        break;
      case 236: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, OP_TYPE_LIKE); }
        break;
      case 237: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy242, NULL, OP_TYPE_LIKE); }
        break;
      case 238: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 239: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 240: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 241: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy242, yymsp[-1].minor.yy242, OP_TYPE_EQUAL); }
        break;
      case 242: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 243: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 244: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 245: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 246: /* cmd ::= SHOW LICENCES */
      case 247: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==247);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 248: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy669); }
        break;
      case 249: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy242); }
        break;
      case 250: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy242); }
        break;
      case 251: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 252: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 253: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 254: /* cmd ::= SHOW VARIABLES */
      case 255: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==255);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 256: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 257: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy242); }
        break;
      case 258: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 259: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 260: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 261: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 262: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy242); }
        break;
      case 263: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 264: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 265: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy242, yymsp[-1].minor.yy242, OP_TYPE_EQUAL); }
        break;
      case 266: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy242, yymsp[0].minor.yy242, yymsp[-3].minor.yy174); }
        break;
      case 267: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 268: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 269: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy242,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 270: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 271: /* db_name_cond_opt ::= */
      case 276: /* from_db_opt ::= */ yytestcase(yyruleno==276);
{ yymsp[1].minor.yy242 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 272: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy242 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy669); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 274: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 275: /* table_name_cond ::= table_name */
{ yylhsminor.yy242 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy669); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 277: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy242 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy669); }
        break;
      case 281: /* tag_item ::= TBNAME */
{ yylhsminor.yy242 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 284: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy242 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy669), &yymsp[0].minor.yy669); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 285: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy242 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy669), &yymsp[0].minor.yy669); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 286: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy777, yymsp[-3].minor.yy242, yymsp[-1].minor.yy242, NULL, yymsp[0].minor.yy242); }
        break;
      case 287: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy777, yymsp[-5].minor.yy242, yymsp[-3].minor.yy242, yymsp[-1].minor.yy174, NULL); }
        break;
      case 288: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy777, yymsp[0].minor.yy242); }
        break;
      case 289: /* full_index_name ::= index_name */
{ yylhsminor.yy242 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy669); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 290: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy242 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy669, &yymsp[0].minor.yy669); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 291: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy242 = createIndexOption(pCxt, yymsp[-7].minor.yy174, releaseRawExprNode(pCxt, yymsp[-3].minor.yy242), NULL, yymsp[-1].minor.yy242, yymsp[0].minor.yy242); }
        break;
      case 292: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy242 = createIndexOption(pCxt, yymsp[-9].minor.yy174, releaseRawExprNode(pCxt, yymsp[-5].minor.yy242), releaseRawExprNode(pCxt, yymsp[-3].minor.yy242), yymsp[-1].minor.yy242, yymsp[0].minor.yy242); }
        break;
      case 295: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy242 = createFunctionNode(pCxt, &yymsp[-3].minor.yy669, yymsp[-1].minor.yy174); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 296: /* sma_func_name ::= function_name */
      case 509: /* alias_opt ::= table_alias */ yytestcase(yyruleno==509);
{ yylhsminor.yy669 = yymsp[0].minor.yy669; }
  yymsp[0].minor.yy669 = yylhsminor.yy669;
        break;
      case 301: /* sma_stream_opt ::= */
      case 341: /* stream_options ::= */ yytestcase(yyruleno==341);
{ yymsp[1].minor.yy242 = createStreamOptions(pCxt); }
        break;
      case 302: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy242)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy242); yylhsminor.yy242 = yymsp[-2].minor.yy242; }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 303: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy242)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy242); yylhsminor.yy242 = yymsp[-2].minor.yy242; }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 304: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy242)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy242); yylhsminor.yy242 = yymsp[-2].minor.yy242; }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 305: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy777, &yymsp[-2].minor.yy669, yymsp[0].minor.yy242); }
        break;
      case 306: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy777, &yymsp[-3].minor.yy669, &yymsp[0].minor.yy669, false); }
        break;
      case 307: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy777, &yymsp[-5].minor.yy669, &yymsp[0].minor.yy669, true); }
        break;
      case 308: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name where_clause_opt */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-5].minor.yy777, &yymsp[-4].minor.yy669, yymsp[-1].minor.yy242, false, yymsp[0].minor.yy242); }
        break;
      case 309: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name where_clause_opt */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-7].minor.yy777, &yymsp[-6].minor.yy669, yymsp[-1].minor.yy242, true, yymsp[0].minor.yy242); }
        break;
      case 310: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy777, &yymsp[0].minor.yy669); }
        break;
      case 311: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy777, &yymsp[-2].minor.yy669, &yymsp[0].minor.yy669); }
        break;
      case 312: /* cmd ::= DESC full_table_name */
      case 313: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==313);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy242); }
        break;
      case 314: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 315: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 316: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==316);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy777, yymsp[-1].minor.yy242, yymsp[0].minor.yy242); }
        break;
      case 319: /* explain_options ::= */
{ yymsp[1].minor.yy242 = createDefaultExplainOptions(pCxt); }
        break;
      case 320: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy242 = setExplainVerbose(pCxt, yymsp[-2].minor.yy242, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 321: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy242 = setExplainRatio(pCxt, yymsp[-2].minor.yy242, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 322: /* cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy777, yymsp[-9].minor.yy777, &yymsp[-6].minor.yy669, &yymsp[-4].minor.yy0, yymsp[-2].minor.yy794, yymsp[-1].minor.yy120, &yymsp[0].minor.yy669, yymsp[-10].minor.yy777); }
        break;
      case 323: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy777, &yymsp[0].minor.yy669); }
        break;
      case 328: /* language_opt ::= */
{ yymsp[1].minor.yy669 = nil_token; }
        break;
      case 329: /* language_opt ::= LANGUAGE NK_STRING */
{ yymsp[-1].minor.yy669 = yymsp[0].minor.yy0; }
        break;
      case 332: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy777, &yymsp[-8].minor.yy669, yymsp[-5].minor.yy242, yymsp[-7].minor.yy242, yymsp[-3].minor.yy174, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, yymsp[-4].minor.yy174); }
        break;
      case 333: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy777, &yymsp[0].minor.yy669); }
        break;
      case 334: /* cmd ::= PAUSE STREAM exists_opt stream_name */
{ pCxt->pRootNode = createPauseStreamStmt(pCxt, yymsp[-1].minor.yy777, &yymsp[0].minor.yy669); }
        break;
      case 335: /* cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
{ pCxt->pRootNode = createResumeStreamStmt(pCxt, yymsp[-2].minor.yy777, yymsp[-1].minor.yy777, &yymsp[0].minor.yy669); }
        break;
      case 342: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 343: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==343);
{ yylhsminor.yy242 = setStreamOptions(pCxt, yymsp[-2].minor.yy242, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 344: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ yylhsminor.yy242 = setStreamOptions(pCxt, yymsp[-3].minor.yy242, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy242)); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 345: /* stream_options ::= stream_options WATERMARK duration_literal */
{ yylhsminor.yy242 = setStreamOptions(pCxt, yymsp[-2].minor.yy242, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy242)); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 346: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ yylhsminor.yy242 = setStreamOptions(pCxt, yymsp[-3].minor.yy242, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 347: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ yylhsminor.yy242 = setStreamOptions(pCxt, yymsp[-2].minor.yy242, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 348: /* stream_options ::= stream_options DELETE_MARK duration_literal */
{ yylhsminor.yy242 = setStreamOptions(pCxt, yymsp[-2].minor.yy242, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy242)); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 349: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ yylhsminor.yy242 = setStreamOptions(pCxt, yymsp[-3].minor.yy242, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 351: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 543: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==543);
      case 564: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==564);
{ yymsp[-3].minor.yy242 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy242); }
        break;
      case 354: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 355: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 356: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 357: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 358: /* cmd ::= BALANCE VGROUP LEADER */
{ pCxt->pRootNode = createBalanceVgroupLeaderStmt(pCxt); }
        break;
      case 359: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 360: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy174); }
        break;
      case 361: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 362: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy174 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 364: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy242, yymsp[0].minor.yy242); }
        break;
      case 367: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy242 = createInsertStmt(pCxt, yymsp[-4].minor.yy242, yymsp[-2].minor.yy174, yymsp[0].minor.yy242); }
        break;
      case 368: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy242 = createInsertStmt(pCxt, yymsp[-1].minor.yy242, NULL, yymsp[0].minor.yy242); }
        break;
      case 369: /* literal ::= NK_INTEGER */
{ yylhsminor.yy242 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 370: /* literal ::= NK_FLOAT */
{ yylhsminor.yy242 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 371: /* literal ::= NK_STRING */
{ yylhsminor.yy242 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 372: /* literal ::= NK_BOOL */
{ yylhsminor.yy242 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 373: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 374: /* literal ::= duration_literal */
      case 384: /* signed_literal ::= signed */ yytestcase(yyruleno==384);
      case 405: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==405);
      case 406: /* expression ::= literal */ yytestcase(yyruleno==406);
      case 407: /* expression ::= pseudo_column */ yytestcase(yyruleno==407);
      case 408: /* expression ::= column_reference */ yytestcase(yyruleno==408);
      case 409: /* expression ::= function_expression */ yytestcase(yyruleno==409);
      case 410: /* expression ::= case_when_expression */ yytestcase(yyruleno==410);
      case 441: /* function_expression ::= literal_func */ yytestcase(yyruleno==441);
      case 490: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==490);
      case 494: /* boolean_primary ::= predicate */ yytestcase(yyruleno==494);
      case 496: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==496);
      case 497: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==497);
      case 500: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==500);
      case 502: /* table_reference ::= table_primary */ yytestcase(yyruleno==502);
      case 503: /* table_reference ::= joined_table */ yytestcase(yyruleno==503);
      case 507: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==507);
      case 566: /* query_simple ::= query_specification */ yytestcase(yyruleno==566);
      case 567: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==567);
      case 570: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==570);
      case 572: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==572);
{ yylhsminor.yy242 = yymsp[0].minor.yy242; }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 375: /* literal ::= NULL */
{ yylhsminor.yy242 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 376: /* literal ::= NK_QUESTION */
{ yylhsminor.yy242 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 377: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy242 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 378: /* signed ::= NK_INTEGER */
{ yylhsminor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 379: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 380: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 381: /* signed ::= NK_FLOAT */
{ yylhsminor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 382: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 383: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 385: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 386: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 387: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 388: /* signed_literal ::= duration_literal */
      case 390: /* signed_literal ::= literal_func */ yytestcase(yyruleno==390);
      case 461: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==461);
      case 523: /* select_item ::= common_expression */ yytestcase(yyruleno==523);
      case 533: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==533);
      case 571: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==571);
      case 573: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==573);
      case 586: /* search_condition ::= common_expression */ yytestcase(yyruleno==586);
{ yylhsminor.yy242 = releaseRawExprNode(pCxt, yymsp[0].minor.yy242); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 389: /* signed_literal ::= NULL */
{ yylhsminor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 391: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy242 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 411: /* expression ::= NK_LP expression NK_RP */
      case 495: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==495);
      case 585: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==585);
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy242)); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 412: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy242));
                                                                                  }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 413: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy242), NULL));
                                                                                  }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 414: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242))); 
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 415: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242))); 
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 416: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242))); 
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 417: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242))); 
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 418: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242)));
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 419: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 420: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242)));
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 421: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242)));
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 424: /* column_reference ::= column_name */
{ yylhsminor.yy242 = createRawExprNode(pCxt, &yymsp[0].minor.yy669, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy669)); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 425: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy669, &yymsp[0].minor.yy669, createColumnNode(pCxt, &yymsp[-2].minor.yy669, &yymsp[0].minor.yy669)); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 426: /* pseudo_column ::= ROWTS */
      case 427: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==427);
      case 429: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==429);
      case 430: /* pseudo_column ::= QEND */ yytestcase(yyruleno==430);
      case 431: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==431);
      case 432: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==432);
      case 433: /* pseudo_column ::= WEND */ yytestcase(yyruleno==433);
      case 434: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==434);
      case 435: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==435);
      case 436: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==436);
      case 437: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==437);
      case 443: /* literal_func ::= NOW */ yytestcase(yyruleno==443);
{ yylhsminor.yy242 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 428: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy669, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy669)))); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 438: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 439: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==439);
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy669, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy669, yymsp[-1].minor.yy174)); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 440: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy242), yymsp[-1].minor.yy794)); }
  yymsp[-5].minor.yy242 = yylhsminor.yy242;
        break;
      case 442: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy669, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy669, NULL)); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 457: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy174 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy174 = yylhsminor.yy174;
        break;
      case 462: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 526: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==526);
{ yylhsminor.yy242 = createColumnNode(pCxt, &yymsp[-2].minor.yy669, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 463: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy174, yymsp[-1].minor.yy242)); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 464: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy242), yymsp[-2].minor.yy174, yymsp[-1].minor.yy242)); }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 467: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy242 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242)); }
        break;
      case 469: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy242 = releaseRawExprNode(pCxt, yymsp[0].minor.yy242); }
        break;
      case 470: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 475: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==475);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy70, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242)));
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 471: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy242), releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242)));
                                                                                  }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 472: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy242), releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242)));
                                                                                  }
  yymsp[-5].minor.yy242 = yylhsminor.yy242;
        break;
      case 473: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), NULL));
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 474: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy242), NULL));
                                                                                  }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 476: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy70 = OP_TYPE_LOWER_THAN; }
        break;
      case 477: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy70 = OP_TYPE_GREATER_THAN; }
        break;
      case 478: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy70 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 479: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy70 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 480: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy70 = OP_TYPE_NOT_EQUAL; }
        break;
      case 481: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy70 = OP_TYPE_EQUAL; }
        break;
      case 482: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy70 = OP_TYPE_LIKE; }
        break;
      case 483: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy70 = OP_TYPE_NOT_LIKE; }
        break;
      case 484: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy70 = OP_TYPE_MATCH; }
        break;
      case 485: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy70 = OP_TYPE_NMATCH; }
        break;
      case 486: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy70 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 487: /* in_op ::= IN */
{ yymsp[0].minor.yy70 = OP_TYPE_IN; }
        break;
      case 488: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy70 = OP_TYPE_NOT_IN; }
        break;
      case 489: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy174)); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 491: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy242), NULL));
                                                                                  }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 492: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242)));
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 493: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242)));
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 501: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy242 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, NULL); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 504: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy242 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy669, &yymsp[0].minor.yy669); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 505: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy242 = createRealTableNode(pCxt, &yymsp[-3].minor.yy669, &yymsp[-1].minor.yy669, &yymsp[0].minor.yy669); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 506: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy242 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy242), &yymsp[0].minor.yy669); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 508: /* alias_opt ::= */
{ yymsp[1].minor.yy669 = nil_token;  }
        break;
      case 510: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy669 = yymsp[0].minor.yy669; }
        break;
      case 511: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 512: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==512);
{ yymsp[-2].minor.yy242 = yymsp[-1].minor.yy242; }
        break;
      case 513: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy242 = createJoinTableNode(pCxt, yymsp[-4].minor.yy482, yymsp[-5].minor.yy242, yymsp[-2].minor.yy242, yymsp[0].minor.yy242); }
  yymsp[-5].minor.yy242 = yylhsminor.yy242;
        break;
      case 514: /* join_type ::= */
{ yymsp[1].minor.yy482 = JOIN_TYPE_INNER; }
        break;
      case 515: /* join_type ::= INNER */
{ yymsp[0].minor.yy482 = JOIN_TYPE_INNER; }
        break;
      case 516: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy242 = createSelectStmt(pCxt, yymsp[-10].minor.yy777, yymsp[-9].minor.yy174, yymsp[-8].minor.yy242);
                                                                                    yymsp[-11].minor.yy242 = addWhereClause(pCxt, yymsp[-11].minor.yy242, yymsp[-7].minor.yy242);
                                                                                    yymsp[-11].minor.yy242 = addPartitionByClause(pCxt, yymsp[-11].minor.yy242, yymsp[-6].minor.yy174);
                                                                                    yymsp[-11].minor.yy242 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy242, yymsp[-2].minor.yy242);
                                                                                    yymsp[-11].minor.yy242 = addGroupByClause(pCxt, yymsp[-11].minor.yy242, yymsp[-1].minor.yy174);
                                                                                    yymsp[-11].minor.yy242 = addHavingClause(pCxt, yymsp[-11].minor.yy242, yymsp[0].minor.yy242);
                                                                                    yymsp[-11].minor.yy242 = addRangeClause(pCxt, yymsp[-11].minor.yy242, yymsp[-5].minor.yy242);
                                                                                    yymsp[-11].minor.yy242 = addEveryClause(pCxt, yymsp[-11].minor.yy242, yymsp[-4].minor.yy242);
                                                                                    yymsp[-11].minor.yy242 = addFillClause(pCxt, yymsp[-11].minor.yy242, yymsp[-3].minor.yy242);
                                                                                  }
        break;
      case 519: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy777 = false; }
        break;
      case 522: /* select_item ::= NK_STAR */
{ yylhsminor.yy242 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 524: /* select_item ::= common_expression column_alias */
      case 534: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==534);
{ yylhsminor.yy242 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy242), &yymsp[0].minor.yy669); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 525: /* select_item ::= common_expression AS column_alias */
      case 535: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==535);
{ yylhsminor.yy242 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), &yymsp[0].minor.yy669); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 530: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 555: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==555);
      case 575: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==575);
{ yymsp[-2].minor.yy174 = yymsp[0].minor.yy174; }
        break;
      case 537: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy242 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy242), releaseRawExprNode(pCxt, yymsp[-1].minor.yy242)); }
        break;
      case 538: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy242 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy242)); }
        break;
      case 539: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy242 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy242), NULL, yymsp[-1].minor.yy242, yymsp[0].minor.yy242); }
        break;
      case 540: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy242 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy242), releaseRawExprNode(pCxt, yymsp[-3].minor.yy242), yymsp[-1].minor.yy242, yymsp[0].minor.yy242); }
        break;
      case 541: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy242 = createEventWindowNode(pCxt, yymsp[-3].minor.yy242, yymsp[0].minor.yy242); }
        break;
      case 545: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy242 = createFillNode(pCxt, yymsp[-1].minor.yy204, NULL); }
        break;
      case 546: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
{ yymsp[-5].minor.yy242 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy174)); }
        break;
      case 547: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
{ yymsp[-5].minor.yy242 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy174)); }
        break;
      case 548: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy204 = FILL_MODE_NONE; }
        break;
      case 549: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy204 = FILL_MODE_PREV; }
        break;
      case 550: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy204 = FILL_MODE_NULL; }
        break;
      case 551: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy204 = FILL_MODE_NULL_F; }
        break;
      case 552: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy204 = FILL_MODE_LINEAR; }
        break;
      case 553: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy204 = FILL_MODE_NEXT; }
        break;
      case 556: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy174 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy242))); }
  yymsp[0].minor.yy174 = yylhsminor.yy174;
        break;
      case 557: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy174 = addNodeToList(pCxt, yymsp[-2].minor.yy174, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy242))); }
  yymsp[-2].minor.yy174 = yylhsminor.yy174;
        break;
      case 561: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy242 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy242), releaseRawExprNode(pCxt, yymsp[-1].minor.yy242)); }
        break;
      case 562: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy242 = createInterpTimePoint(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy242)); }
        break;
      case 565: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy242 = addOrderByClause(pCxt, yymsp[-3].minor.yy242, yymsp[-2].minor.yy174);
                                                                                    yylhsminor.yy242 = addSlimitClause(pCxt, yylhsminor.yy242, yymsp[-1].minor.yy242);
                                                                                    yylhsminor.yy242 = addLimitClause(pCxt, yylhsminor.yy242, yymsp[0].minor.yy242);
                                                                                  }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 568: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy242 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy242, yymsp[0].minor.yy242); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 569: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy242 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy242, yymsp[0].minor.yy242); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 577: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 581: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==581);
{ yymsp[-1].minor.yy242 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 578: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 582: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==582);
{ yymsp[-3].minor.yy242 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 579: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 583: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==583);
{ yymsp[-3].minor.yy242 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 584: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy242); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 589: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy242 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), yymsp[-1].minor.yy48, yymsp[0].minor.yy687); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 590: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy48 = ORDER_ASC; }
        break;
      case 591: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy48 = ORDER_ASC; }
        break;
      case 592: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy48 = ORDER_DESC; }
        break;
      case 593: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy687 = NULL_ORDER_DEFAULT; }
        break;
      case 594: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy687 = NULL_ORDER_FIRST; }
        break;
      case 595: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy687 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
