/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 474
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  int32_t yy136;
  SDataType yy160;
  SNodeList* yy172;
  SNode* yy188;
  int64_t yy189;
  EOrder yy206;
  EJoinType yy240;
  int8_t yy371;
  bool yy437;
  SAlterOption yy653;
  EFillMode yy654;
  EOperatorType yy716;
  SToken yy725;
  ENullOrder yy913;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             759
#define YYNRULE              579
#define YYNTOKEN             330
#define YY_MAX_SHIFT         758
#define YY_MIN_SHIFTREDUCE   1130
#define YY_MAX_SHIFTREDUCE   1708
#define YY_ERROR_ACTION      1709
#define YY_ACCEPT_ACTION     1710
#define YY_NO_ACTION         1711
#define YY_MIN_REDUCE        1712
#define YY_MAX_REDUCE        2290
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2842)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1870, 1998,  427, 1932,  629,  494,  426,  495, 1748,  164,
 /*    10 */   366, 2084,   45,   43, 1636, 1710, 1996,  635, 1882, 1930,
 /*    20 */   388,  433, 1485,  393,   38,   37, 1925, 1927,   44,   42,
 /*    30 */    41,   40,   39, 1566,  122, 1483, 1778,  121,  120,  119,
 /*    40 */   118,  117,  116,  115,  114,  113, 2080, 2086,  586,  500,
 /*    50 */   586, 1510, 2261, 2102, 2261,  496, 2266,  658, 1561,  503,
 /*    60 */  2261,  495, 1748,  333,   18, 1511,  647, 2267,  182, 2267,
 /*    70 */   182, 1491, 2262,  612, 2262,  612, 2265, 1932,   35,  291,
 /*    80 */  2262, 2264,   86,  401,  351,  512, 2120,  400,   44,   42,
 /*    90 */    41,   40,   39, 1930,  626, 1926, 1927,  755,  355, 2070,
 /*   100 */    14,  664,  732,  731,  730,  729,  398, 1874,  728,  727,
 /*   110 */   143,  722,  721,  720,  719,  718,  717,  716,  156,  712,
 /*   120 */   711,  710,  397,  396,  707,  706,  705,  704,  703,  586,
 /*   130 */  2037, 2101, 1182, 2261, 1181, 2137, 1568, 1569,  109, 2103,
 /*   140 */   668, 2105, 2106,  663,  633,  658, 1998,  222, 2267,  182,
 /*   150 */   179,   65, 2190, 2262,  612,  611,  382, 2186,  379, 2261,
 /*   160 */   648, 1995,  635, 1183,  623,  611, 1541, 1551,  647, 2261,
 /*   170 */   184,   61, 1567, 1570,  610,  182,  132,  240, 2216, 2262,
 /*   180 */   612, 1346, 1347,  533,  610,  182, 1486, 1491, 1484, 2262,
 /*   190 */   612, 1932, 1735, 1879, 1705,   38,   37,  139,  376,   44,
 /*   200 */    42,   41,   40,   39,   38,   37,  606, 1930,   44,   42,
 /*   210 */    41,   40,   39, 2102, 1489, 1490, 1513, 1540, 1543, 1544,
 /*   220 */  1545, 1546, 1547, 1548, 1549, 1550,  660,  656, 1559, 1560,
 /*   230 */  1562, 1563, 1564, 1565,    2,   45,   43, 1932, 2070,  647,
 /*   240 */   336, 1510, 1508,  388,  381, 1485, 2120,   61,   48,  464,
 /*   250 */   623,  345,  478, 1930,  665,  477, 1566,  648, 1483, 2070,
 /*   260 */   176,  664,  625,  180, 2198, 2199,  702,  137, 2203,  391,
 /*   270 */   447, 1509,  479,  132,  167,  449, 1724,  161, 2089, 1664,
 /*   280 */   538, 1561, 1982,  139,  367,  176, 1881,   18, 2056, 2084,
 /*   290 */  1879, 2101, 1704, 1930, 1491, 2137, 1595,  166,  109, 2103,
 /*   300 */   668, 2105, 2106,  663, 1820,  658,  353, 1981,  142, 1597,
 /*   310 */   149, 2161, 2190, 1713, 1510, 2102,  382, 2186,  574,   48,
 /*   320 */   755,  354,  185,   14, 2080, 2086,  598,  597, 1662, 1663,
 /*   330 */  1665, 1666, 1667,  437,  122,  658,  408,  121,  120,  119,
 /*   340 */   118,  117,  116,  115,  114,  113,  547,  546, 2120,  181,
 /*   350 */  2198, 2199, 1596,  137, 2203, 1182,  665, 1181,  693, 1568,
 /*   360 */  1569, 2070,  475,  664,  250,  469,  468,  467,  466,  463,
 /*   370 */   462,  461,  460,  459,  455,  454,  453,  452,  335,  444,
 /*   380 */   443,  442,   32,  439,  438,  352, 1183, 1401, 1402, 1541,
 /*   390 */  1551,   49, 1602, 2101,   61, 1567, 1570, 2137,  185,  601,
 /*   400 */   109, 2103,  668, 2105, 2106,  663, 1512,  658,   11, 1486,
 /*   410 */     9, 1484, 2165,  650, 2190, 2162,   38,   37,  382, 2186,
 /*   420 */    44,   42,   41,   40,   39,   34,  386, 1590, 1591, 1592,
 /*   430 */  1593, 1594, 1598, 1599, 1600, 1601, 1163, 1489, 1490,  273,
 /*   440 */  1540, 1543, 1544, 1545, 1546, 1547, 1548, 1549, 1550,  660,
 /*   450 */   656, 1559, 1560, 1562, 1563, 1564, 1565,    2,   11,   45,
 /*   460 */    43,  493,   13,   12,  498, 1754, 2205,  388, 2120, 1485,
 /*   470 */   185, 2102, 1932,   11,  223, 1165,  605, 1168, 1169,  392,
 /*   480 */  1566,   61, 1483,   92,  607,  602,  595,  502, 1930,  171,
 /*   490 */   498, 1754, 2202, 2266,   61,  529,  525,  521,  517,  220,
 /*   500 */  2102,  634,  726,  724, 2120, 1561, 1856, 1312,  178, 1675,
 /*   510 */  1512,   18,  626,   41,   40,   39,  634, 2070, 1491,  664,
 /*   520 */   634, 1919,  604, 1303,  690,  689,  688, 1307,  687, 1309,
 /*   530 */  1310,  686,  683, 2120, 1318,  680, 1320, 1321,  677,  674,
 /*   540 */    87,  665,  185,  218,  755,  185, 2070,   14,  664, 2101,
 /*   550 */   510,  556, 1991, 2137,  272,  714,  109, 2103,  668, 2105,
 /*   560 */  2106,  663, 1609,  658,  581,  632,  566, 1991,  179,  643,
 /*   570 */  2190, 1991, 1255,  694,  382, 2186, 1923,  106, 2101,  425,
 /*   580 */   236,  424, 2137, 1568, 1569,  109, 2103,  668, 2105, 2106,
 /*   590 */   663, 1698,  658,  140,  539,  559, 2217, 2163, 1712, 2190,
 /*   600 */   553, 1871, 1734,  382, 2186,  235, 1733,  423, 1257, 2102,
 /*   610 */   217,  211, 1513, 1541, 1551,  216, 1253,  508,  700, 1567,
 /*   620 */  1570,  623,  131,  130,  129,  128,  127,  126,  125,  124,
 /*   630 */   123,  152,  185, 1486,  209, 1484,  154,  153,  697,  696,
 /*   640 */   695,  151, 2120,  380,  655,  185,   69, 1640, 2070,   68,
 /*   650 */   665,  164, 2070, 1510,  139, 2070, 1962,  664,  272, 1868,
 /*   660 */  1881, 1489, 1490, 1511, 1540, 1543, 1544, 1545, 1546, 1547,
 /*   670 */  1548, 1549, 1550,  660,  656, 1559, 1560, 1562, 1563, 1564,
 /*   680 */  1565,    2,   45,   43, 1571,  238, 2102, 2101,   53,  237,
 /*   690 */   388, 2137, 1485,  648,  109, 2103,  668, 2105, 2106,  663,
 /*   700 */  1855,  658, 1821, 1566,   31, 1483, 2281,  420, 2190,  187,
 /*   710 */    38,   37,  382, 2186,   44,   42,   41,   40,   39, 2120,
 /*   720 */   183, 2198, 2199, 2224,  137, 2203, 1879,  665, 1561, 1266,
 /*   730 */   422,  418, 2070,  652,  664, 2162, 2102,  551,  550,  549,
 /*   740 */  2088, 1491, 1265, 1633,  541,  136,  545, 1864,   89,  340,
 /*   750 */   544, 2084,  365, 1725,  567,  543,  548,  361,  360, 1732,
 /*   760 */   191,  542, 2102,  702, 2101,  648, 1731,  755, 2137, 2120,
 /*   770 */    46,  109, 2103,  668, 2105, 2106,  663,  662,  658, 1418,
 /*   780 */  1419,   54, 2070, 2281,  664, 2190, 2080, 2086,  369,  382,
 /*   790 */  2186,  194, 1730, 2205, 1587, 2120, 1485,  658, 1879, 1542,
 /*   800 */  2237,  648,  471,  665,  480, 2070, 1568, 1569, 2070, 1483,
 /*   810 */   664,  451, 2070, 1866, 2101, 1417, 1420,  431, 2137, 2201,
 /*   820 */   450,  327, 2103,  668, 2105, 2106,  663,  661,  658,  649,
 /*   830 */  2155,  715,   83, 1841, 1879,   82, 1541, 1551, 2070,  648,
 /*   840 */  2101,  358, 1567, 1570, 2137, 1491,  648,  109, 2103,  668,
 /*   850 */  2105, 2106,  663, 1862,  658,  432, 1486, 1781, 1484, 2281,
 /*   860 */   391, 2190,  441,  198,  197,  382, 2186, 1576,  164, 1977,
 /*   870 */  1270,  755, 1879, 1510, 1729, 1728,  593, 1881,  692, 1879,
 /*   880 */   190, 2102,  239, 1269, 1489, 1490,  470, 1540, 1543, 1544,
 /*   890 */  1545, 1546, 1547, 1548, 1549, 1550,  660,  656, 1559, 1560,
 /*   900 */  1562, 1563, 1564, 1565,    2,   45,   43,  359, 2088,  357,
 /*   910 */   356, 2063,  535,  388, 2120, 1485,  537,  648,  245, 2084,
 /*   920 */  2070, 2070,  665,  551,  550,  549, 1566, 2070, 1483,  664,
 /*   930 */   541,  136,  545,  456,  100,  141,  544,  536, 2161, 1168,
 /*   940 */  1169,  543,  548,  361,  360,  482, 2205,  542, 1458, 1459,
 /*   950 */  1879, 1561,  540, 2102, 2080, 2086,  370,  586, 1872, 2101,
 /*   960 */  1486, 2261, 1484, 2137, 1491,  658,  109, 2103,  668, 2105,
 /*   970 */  2106,  663, 2200,  658, 1251,   86, 2267,  182, 2281,  394,
 /*   980 */  2190, 2262,  612, 1513,  382, 2186, 2120,  164, 1489, 1490,
 /*   990 */   755, 1632,  565,   46,  665, 2255, 1881,  282,  283, 2070,
 /*  1000 */  1875,  664,  281,  385,  384,  563, 1932,  561, 2266, 1727,
 /*  1010 */    38,   37, 2261, 1499,   44,   42,   41,   40,   39, 1542,
 /*  1020 */   648,  648, 1931, 1977, 1566, 1726, 1492,    8, 2265, 1568,
 /*  1030 */  1569, 2101, 2262, 2263,  192, 2137,  457,  511,  109, 2103,
 /*  1040 */   668, 2105, 2106,  663, 2265,  658,   27,  648,  698, 1561,
 /*  1050 */  2281, 1923, 2190, 1879, 1879, 2070,  382, 2186,  699, 1541,
 /*  1060 */  1551, 1923, 1491, 1876,  537, 1567, 1570, 2209,   38,   37,
 /*  1070 */   648, 2070,   44,   42,   41,   40,   39, 2053,  659, 1486,
 /*  1080 */  1879, 1484, 1977, 2230,   33,  536,  241,  615,  654, 1723,
 /*  1090 */    38,   37,  434,  196,   44,   42,   41,   40,   39, 1854,
 /*  1100 */  1722, 1721, 1720, 1879, 2102,  435,  305, 1489, 1490, 1909,
 /*  1110 */  1540, 1543, 1544, 1545, 1546, 1547, 1548, 1549, 1550,  660,
 /*  1120 */   656, 1559, 1560, 1562, 1563, 1564, 1565,    2,   45,   43,
 /*  1130 */  1719,  249, 2210, 1629, 1857, 2070,  388, 2120, 1485,  648,
 /*  1140 */   648,  228,  623,  221,  226,  665, 2070, 2070, 2070, 1566,
 /*  1150 */  2070, 1483,  664, 1510,  230,  582,  627,  229,   38,   37,
 /*  1160 */    73, 1652,   44,   42,   41,   40,   39,  648,   51,  648,
 /*  1170 */     3, 1718, 1879, 1879, 1561,  139, 2070, 1500,  147, 1495,
 /*  1180 */  1717,  648, 2101,  631,  267,  286, 2137, 1491,  599,  109,
 /*  1190 */  2103,  668, 2105, 2106,  663,  232,  658,  645,  231, 1494,
 /*  1200 */  1879,  651, 1879, 2190, 1716, 1503, 1505,  382, 2186,   81,
 /*  1210 */  1715,  700,  234,  755, 1879,  233,   14, 2070,  656, 1559,
 /*  1220 */  1560, 1562, 1563, 1564, 1565, 2064, 2070,  261,  648,  154,
 /*  1230 */   153,  697,  696,  695,  151,  165,  152,  145, 1629,  134,
 /*  1240 */   311,  270, 2198,  622,  646,  133,  621,  648,  585, 2261,
 /*  1250 */  2070,  648, 1568, 1569,  309,   72, 2070,  248,   71, 1768,
 /*  1260 */   569, 1879,  568,  292,  610,  182,  152,  395,   63, 2262,
 /*  1270 */   612,  586, 1761, 1707, 1708, 2261,  205,  490,  488,  485,
 /*  1280 */  1879,  552, 1541, 1551, 1879,  415,  618,  700, 1567, 1570,
 /*  1290 */  2267,  182, 1759, 1453,  554, 2262,  612,   63, 1493, 1542,
 /*  1300 */   254,   90, 1486, 2121, 1484,  154,  153,  697,  696,  695,
 /*  1310 */   151, 2091,  614,  572,  557,  152,  616,   61,  163,   47,
 /*  1320 */    52,   13,   12, 1456,  279, 1661, 1212, 2102,   70,  150,
 /*  1330 */  1489, 1490,  152, 1540, 1543, 1544, 1545, 1546, 1547, 1548,
 /*  1340 */  1549, 1550,  660,  656, 1559, 1560, 1562, 1563, 1564, 1565,
 /*  1350 */     2,   63, 1497,   47, 1660,  108,  399,  256, 2102,  586,
 /*  1360 */  2120,   47, 1213, 2261, 2093,  672,  708,  150,  665, 1986,
 /*  1370 */  1749,  709,  630, 2070,  152,  664, 1415,  135, 2267,  182,
 /*  1380 */   150,  284,  105, 2262,  612,  640,  288, 1920, 1231, 1296,
 /*  1390 */  1755, 2120,  102, 1229, 2220,   80,   79,  430,  269,  665,
 /*  1400 */   189,  624,  266,    1, 2070, 2101,  664,    4, 1603, 2137,
 /*  1410 */  1552,  402,  168, 2103,  668, 2105, 2106,  663,  304,  658,
 /*  1420 */   334,  407, 1324,  416, 1328, 1438,  414,  410,  406,  403,
 /*  1430 */   423, 1335,  349,  299, 1333,  195, 2101,  155, 2102,  750,
 /*  1440 */  2137, 2088,  436,  110, 2103,  668, 2105, 2106,  663, 1513,
 /*  1450 */   658, 1496, 2084,  587, 2227, 1987,  445, 2190, 2102,   38,
 /*  1460 */    37, 2189, 2186,   44,   42,   41,   40,   39,  185,  440,
 /*  1470 */   473, 2120, 1508,  458,  465,  483, 1979,  472,  474,  665,
 /*  1480 */   484,  481,  200,  486, 2070,  487,  664, 2080, 2086,  383,
 /*  1490 */   199, 2120,  202, 1514,  489,  492,  491,  501,  658,  665,
 /*  1500 */  1516,  504, 1511,  208, 2070,  505,  664, 1515,  210,  506,
 /*  1510 */  1517,  507,  213,  509,  513,  215, 2101,  619, 1185,   84,
 /*  1520 */  2137,   85,  530,  110, 2103,  668, 2105, 2106,  663,  219,
 /*  1530 */   658,  531,  532,  571,   88, 2102,  666, 2190, 2046,  339,
 /*  1540 */  2137,  653, 2186,  110, 2103,  668, 2105, 2106,  663,  534,
 /*  1550 */   658, 1869, 2102,  111,  225, 1865,  227, 2190, 2043,  157,
 /*  1560 */   158,  344, 2186, 2042, 1867,  148, 1863,  159, 2120,  160,
 /*  1570 */   242,  576,  300,  573,  577,  575,  665,  580,  246,  583,
 /*  1580 */   244, 2070,  600,  664, 2236, 2120,  590,  638,  596,  609,
 /*  1590 */   371,  372, 2235,  665, 2221, 2231, 2212,  603, 2070,  260,
 /*  1600 */   664,  172,  252,    7,  255,  588,  620,  591,  589, 1629,
 /*  1610 */   617,  262, 2102, 2101,  268, 2284, 2260, 2137,  138, 1512,
 /*  1620 */   169, 2103,  668, 2105, 2106,  663,  265,  658,  628,  263,
 /*  1630 */  2101,  264, 2206, 1518, 2137,  375, 2102,  110, 2103,  668,
 /*  1640 */  2105, 2106,  663,  274,  658, 2120,   95, 1992,  301,  636,
 /*  1650 */    60, 2190,  637,  665,  302, 2006, 2187, 2005, 2070,  641,
 /*  1660 */   664,   97, 2004,   99,  303,  378, 2171,  101,  642, 2120,
 /*  1670 */  1880, 1842,  613, 2282,  670,  306, 1924,  665,  751,  752,
 /*  1680 */   754,  330, 2070,  310,  664,  295,  315,  329,  308,  341,
 /*  1690 */  2101,   50, 2062, 2061, 2137,  342, 2060,  168, 2103,  668,
 /*  1700 */  2105, 2106,  663,   77,  658, 2057,  319, 2102,  404,  405,
 /*  1710 */  1476, 1477,  188,  409, 2101, 2055,  411,  412, 2137,  413,
 /*  1720 */  2054,  321, 2103,  668, 2105, 2106,  663,  350,  658, 2102,
 /*  1730 */  2052, 2051,  417,  419, 2050,  421,   78, 1441, 1440, 2228,
 /*  1740 */  2120, 2018, 2017, 2016,  428,  429, 2015, 2014,  665, 1392,
 /*  1750 */  1970, 1969, 1967, 2070,  144,  664, 1966, 1965, 1968, 1964,
 /*  1760 */  1963, 1961, 2120, 1960, 1959,  608,  193,  377,  446, 1958,
 /*  1770 */   665,  448, 1972, 1957, 1956, 2070, 1955,  664, 1954, 2102,
 /*  1780 */  1953, 1952, 1951, 1950, 1949, 2101, 1948, 1947, 1946, 2137,
 /*  1790 */  1945, 1944,  169, 2103,  668, 2105, 2106,  663, 1943,  658,
 /*  1800 */  1942, 1941, 2102, 1940,  146, 1971, 1939, 2101, 1938, 1937,
 /*  1810 */  1936, 2137, 2120, 1935,  328, 2103,  668, 2105, 2106,  663,
 /*  1820 */   662,  658,  476, 1934, 1394, 2070, 1933,  664,  337, 1267,
 /*  1830 */  1784,  338, 1263, 1271, 1783, 2120, 1782,  201, 1780, 1744,
 /*  1840 */   387,  206, 2090,  665, 1743, 2283, 1171,  203, 2070, 1170,
 /*  1850 */   664,  204, 2033,   75, 2025, 2013,  177, 2101,  207,   76,
 /*  1860 */  2102, 2137,  497,  212,  327, 2103,  668, 2105, 2106,  663,
 /*  1870 */  2012,  658,  499, 2156, 1990,  214, 1858, 1779, 1777,  515,
 /*  1880 */  2101,  758, 1205,  514, 2137,  516, 1775,  328, 2103,  668,
 /*  1890 */  2105, 2106,  663, 2120,  658,  298,  518,  519,  389,  520,
 /*  1900 */  1773,  665,  522,  524,  523, 1771, 2070,  526,  664, 1758,
 /*  1910 */   175,  527,  528, 1757, 1740, 1860,  748,  744,  740,  736,
 /*  1920 */   296, 1339, 1340, 1859, 1254, 1252, 1250, 2102,   62,  224,
 /*  1930 */  1249, 1248, 1247, 1246, 1241, 1769,  723,  725, 2101, 1243,
 /*  1940 */   362, 1242, 2137, 1240, 1762,  328, 2103,  668, 2105, 2106,
 /*  1950 */   663,  363,  658,  555, 1760,  364, 2102,  558, 1739,  560,
 /*  1960 */  2120,  107, 1738,  562,  289, 1737,  112,  564,  665, 1463,
 /*  1970 */  1467, 1465, 1462, 2070, 2032,  664, 1447, 1449, 2024,   26,
 /*  1980 */    66,  162,  578, 2011, 2009, 2266,   19, 2102,   28, 2120,
 /*  1990 */    64,  247,   16,   58,  251,   55,  644,  665,    5,  592,
 /*  2000 */    59,  579, 2070,  584,  664,  570,  259,    6,  368, 2137,
 /*  2010 */   258, 1677,  323, 2103,  668, 2105, 2106,  663, 2102,  658,
 /*  2020 */  2120,  594,  253, 2091,   30,   20, 1659,  170,  665,   21,
 /*  2030 */   257,  276,   29, 2070, 2101,  664,  275, 1692, 2137, 1651,
 /*  2040 */    91,  312, 2103,  668, 2105, 2106,  663, 1691,  658, 1697,
 /*  2050 */   373, 2120, 1445, 1698, 1626,  243, 1696, 1695,  374,  665,
 /*  2060 */   271,   57, 2010,  173, 2070, 2101,  664, 2008, 1625, 2137,
 /*  2070 */  2007, 1989,  313, 2103,  668, 2105, 2106,  663,   94,  658,
 /*  2080 */   277,   93, 2102, 1988,   17,   96,   56,  278,   22,  287,
 /*  2090 */  1657,  280,  285,   67,   98,  290, 2101,   23, 1578, 2102,
 /*  2100 */  2137,   10,  639,  314, 2103,  668, 2105, 2106,  663,  102,
 /*  2110 */   658,   12, 1577, 1501, 1533, 2120,  174,  669, 2140,  186,
 /*  2120 */   657, 1588,  671,  665,  390, 1556, 1554,   36, 2070, 1553,
 /*  2130 */   664,   15, 2120, 1525,   24,  667, 1325,   25,  673,  675,
 /*  2140 */   665, 1322,  676,  678, 1319, 2070, 1313,  664,  681, 2102,
 /*  2150 */   679,  682,  684, 1311,  685, 1302,  691, 1334,  103,  293,
 /*  2160 */  2101,  104, 1330,   74, 2137, 1237, 1203,  320, 2103,  668,
 /*  2170 */  2105, 2106,  663, 1236,  658,  701, 1235, 2101, 1317, 1316,
 /*  2180 */  1315, 2137, 2120, 1314,  324, 2103,  668, 2105, 2106,  663,
 /*  2190 */   665,  658, 1234, 1233, 1232, 2070, 1230,  664, 1228, 2102,
 /*  2200 */  1227, 1226, 1261,  713,  294, 1224, 1223, 1222, 1221, 1220,
 /*  2210 */  1219, 1218, 1256, 1258, 1215, 2102, 1214, 1211, 1209, 1210,
 /*  2220 */  1208, 1776,  733, 1774, 1772,  737,  734, 2101,  735, 1770,
 /*  2230 */   739, 2137, 2120,  741,  316, 2103,  668, 2105, 2106,  663,
 /*  2240 */   665,  658,  738,  742,  743, 2070,  745,  664, 2120,  746,
 /*  2250 */  1756,  747,  749, 1160, 1736,  297,  665,  753, 1711, 1487,
 /*  2260 */   307, 2070,  756,  664,  757, 1711, 1711, 1711, 1711, 1711,
 /*  2270 */  1711, 1711, 1711, 1711, 1711, 1711, 2102, 2101, 1711, 1711,
 /*  2280 */  1711, 2137, 1711, 1711,  325, 2103,  668, 2105, 2106,  663,
 /*  2290 */  1711,  658, 1711, 2101, 2102, 1711, 1711, 2137, 1711, 1711,
 /*  2300 */   317, 2103,  668, 2105, 2106,  663, 1711,  658, 1711, 2120,
 /*  2310 */  1711, 1711, 1711, 1711, 1711, 1711, 1711,  665, 1711, 1711,
 /*  2320 */  1711, 1711, 2070, 1711,  664, 1711, 1711, 2120, 1711, 1711,
 /*  2330 */  1711, 1711, 1711, 1711, 1711,  665, 1711, 1711, 1711, 1711,
 /*  2340 */  2070, 1711,  664, 1711, 1711, 1711, 1711, 1711, 1711, 1711,
 /*  2350 */  1711, 1711, 2102, 1711, 2101, 1711, 1711, 1711, 2137, 1711,
 /*  2360 */  1711,  326, 2103,  668, 2105, 2106,  663, 1711,  658, 2102,
 /*  2370 */  1711, 1711, 2101, 1711, 1711, 1711, 2137, 1711, 1711,  318,
 /*  2380 */  2103,  668, 2105, 2106,  663, 2120,  658, 1711, 1711, 1711,
 /*  2390 */  1711, 1711, 1711,  665, 1711, 1711, 1711, 1711, 2070, 1711,
 /*  2400 */   664, 1711, 2120, 1711, 1711, 1711, 1711, 1711, 1711, 1711,
 /*  2410 */   665, 1711, 1711, 1711, 1711, 2070, 1711,  664, 1711, 1711,
 /*  2420 */  1711, 1711, 1711, 1711, 1711, 1711, 1711, 1711, 1711, 1711,
 /*  2430 */  2101, 1711, 1711, 2102, 2137, 1711, 1711,  331, 2103,  668,
 /*  2440 */  2105, 2106,  663, 1711,  658, 1711, 1711, 2101, 1711, 2102,
 /*  2450 */  1711, 2137, 1711, 1711,  332, 2103,  668, 2105, 2106,  663,
 /*  2460 */  1711,  658, 1711, 1711, 1711, 1711, 2120, 1711, 1711, 1711,
 /*  2470 */  1711, 1711, 1711, 1711,  665, 1711, 1711, 1711, 1711, 2070,
 /*  2480 */  1711,  664, 2120, 1711, 1711, 1711, 1711, 1711, 1711, 1711,
 /*  2490 */   665, 1711, 1711, 1711, 1711, 2070, 1711,  664, 1711, 1711,
 /*  2500 */  1711, 1711, 1711, 1711, 1711, 1711, 1711, 1711, 1711, 1711,
 /*  2510 */  1711, 2101, 1711, 1711, 1711, 2137, 2102, 1711, 2114, 2103,
 /*  2520 */   668, 2105, 2106,  663, 1711,  658, 1711, 2101, 1711, 1711,
 /*  2530 */  1711, 2137, 1711, 2102, 2113, 2103,  668, 2105, 2106,  663,
 /*  2540 */  1711,  658, 1711, 1711, 1711, 1711, 1711, 1711, 1711, 2120,
 /*  2550 */  1711, 1711, 1711, 1711, 1711, 1711, 1711,  665, 1711, 1711,
 /*  2560 */  1711, 1711, 2070, 1711,  664, 1711, 2120, 1711, 1711, 1711,
 /*  2570 */  1711, 1711, 1711, 1711,  665, 1711, 1711, 1711, 1711, 2070,
 /*  2580 */  1711,  664, 1711, 1711, 1711, 1711, 1711, 1711, 1711, 1711,
 /*  2590 */  1711, 1711, 1711, 1711, 2101, 2102, 1711, 1711, 2137, 1711,
 /*  2600 */  1711, 2112, 2103,  668, 2105, 2106,  663, 1711,  658, 1711,
 /*  2610 */  1711, 2101, 1711, 1711, 1711, 2137, 1711, 1711,  346, 2103,
 /*  2620 */   668, 2105, 2106,  663, 1711,  658, 1711, 1711, 2120, 1711,
 /*  2630 */  1711, 1711, 1711, 1711, 1711, 1711,  665, 1711, 1711, 1711,
 /*  2640 */  1711, 2070, 1711,  664, 1711, 1711, 1711, 1711, 1711, 1711,
 /*  2650 */  1711, 1711, 1711, 1711, 1711, 1711, 2102, 1711, 1711, 1711,
 /*  2660 */  1711, 1711, 1711, 1711, 1711, 1711, 1711, 1711, 1711, 1711,
 /*  2670 */  1711, 1711, 1711, 2101, 2102, 1711, 1711, 2137, 1711, 1711,
 /*  2680 */   347, 2103,  668, 2105, 2106,  663, 1711,  658, 1711, 2120,
 /*  2690 */  1711, 1711, 1711, 1711, 1711, 1711, 1711,  665, 1711, 1711,
 /*  2700 */  1711, 1711, 2070, 1711,  664, 1711, 1711, 2120, 1711, 1711,
 /*  2710 */  1711, 1711, 1711, 1711, 1711,  665, 1711, 1711, 1711, 1711,
 /*  2720 */  2070, 1711,  664, 1711, 1711, 1711, 1711, 1711, 1711, 1711,
 /*  2730 */  1711, 1711, 2102, 1711, 2101, 1711, 1711, 1711, 2137, 1711,
 /*  2740 */  1711,  343, 2103,  668, 2105, 2106,  663, 1711,  658, 2102,
 /*  2750 */  1711, 1711, 2101, 1711, 1711, 1711, 2137, 1711, 1711,  348,
 /*  2760 */  2103,  668, 2105, 2106,  663, 2120,  658, 1711, 1711, 1711,
 /*  2770 */  1711, 1711, 1711,  665, 1711, 1711, 1711, 1711, 2070, 1711,
 /*  2780 */   664, 1711, 2120, 1711, 1711, 1711, 1711, 1711, 1711, 1711,
 /*  2790 */   665, 1711, 1711, 1711, 1711, 2070, 1711,  664, 1711, 1711,
 /*  2800 */  1711, 1711, 1711, 1711, 1711, 1711, 1711, 1711, 1711, 1711,
 /*  2810 */   666, 1711, 1711, 1711, 2137, 1711, 1711,  323, 2103,  668,
 /*  2820 */  2105, 2106,  663, 1711,  658, 1711, 1711, 2101, 1711, 1711,
 /*  2830 */  1711, 2137, 1711, 1711,  322, 2103,  668, 2105, 2106,  663,
 /*  2840 */  1711,  658,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   368,  381,  398,  366,  398,  337,  402,  339,  340,  366,
 /*    10 */   373,  379,   12,   13,   14,  330,  396,  397,  375,  382,
 /*    20 */    20,  341,   22,  377,    8,    9,  380,  381,   12,   13,
 /*    30 */    14,   15,   16,   33,   21,   35,    0,   24,   25,   26,
 /*    40 */    27,   28,   29,   30,   31,   32,  414,  415,  444,   14,
 /*    50 */   444,   20,  448,  333,  448,   20,  444,  425,   58,  337,
 /*    60 */   448,  339,  340,  383,   64,   20,   20,  463,  464,  463,
 /*    70 */   464,   71,  468,  469,  468,  469,  464,  366,  433,  434,
 /*    80 */   468,  469,  347,  398,  373,   63,  366,  402,   12,   13,
 /*    90 */    14,   15,   16,  382,  374,  380,  381,   97,  363,  379,
 /*   100 */   100,  381,   66,   67,   68,   69,   70,  372,   72,   73,
 /*   110 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   120 */    84,   85,   86,   87,   88,   89,   90,   91,   92,  444,
 /*   130 */   362,  411,   20,  448,   22,  415,  136,  137,  418,  419,
 /*   140 */   420,  421,  422,  423,   20,  425,  381,   35,  463,  464,
 /*   150 */   430,    4,  432,  468,  469,  444,  436,  437,  393,  448,
 /*   160 */   341,  396,  397,   51,  341,  444,  166,  167,   20,  448,
 /*   170 */   450,  100,  172,  173,  463,  464,  357,  409,  458,  468,
 /*   180 */   469,  136,  137,  364,  463,  464,  186,   71,  188,  468,
 /*   190 */   469,  366,  333,  374,  178,    8,    9,  374,  373,   12,
 /*   200 */    13,   14,   15,   16,    8,    9,   20,  382,   12,   13,
 /*   210 */    14,   15,   16,  333,  214,  215,   20,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,  233,  234,   12,   13,  366,  379,   20,
 /*   240 */    18,   20,   20,   20,  373,   22,  366,  100,  100,   27,
 /*   250 */   341,   64,   30,  382,  374,   33,   33,  341,   35,  379,
 /*   260 */   366,  381,  439,  440,  441,  442,   63,  444,  445,  358,
 /*   270 */    48,   20,   50,  357,  332,   53,  334,  366,  368,  214,
 /*   280 */   364,   58,  388,  374,  373,  366,  375,   64,    0,  379,
 /*   290 */   374,  411,  276,  382,   71,  415,  109,  348,  418,  419,
 /*   300 */   420,  421,  422,  423,  355,  425,  387,  388,  428,  165,
 /*   310 */   430,  431,  432,    0,   20,  333,  436,  437,  111,  100,
 /*   320 */    97,   99,  251,  100,  414,  415,  261,  262,  263,  264,
 /*   330 */   265,  266,  267,  111,   21,  425,   48,   24,   25,   26,
 /*   340 */    27,   28,   29,   30,   31,   32,  352,  353,  366,  440,
 /*   350 */   441,  442,  165,  444,  445,   20,  374,   22,  111,  136,
 /*   360 */   137,  379,  140,  381,  168,  143,  144,  145,  146,  147,
 /*   370 */   148,  149,  150,  151,  152,  153,  154,  155,  156,  157,
 /*   380 */   158,  159,  238,  161,  162,  163,   51,  166,  167,  166,
 /*   390 */   167,  100,  248,  411,  100,  172,  173,  415,  251,  171,
 /*   400 */   418,  419,  420,  421,  422,  423,   20,  425,  235,  186,
 /*   410 */   237,  188,  430,  429,  432,  431,    8,    9,  436,  437,
 /*   420 */    12,   13,   14,   15,   16,  238,  239,  240,  241,  242,
 /*   430 */   243,  244,  245,  246,  247,  248,    4,  214,  215,   58,
 /*   440 */   217,  218,  219,  220,  221,  222,  223,  224,  225,  226,
 /*   450 */   227,  228,  229,  230,  231,  232,  233,  234,  235,   12,
 /*   460 */    13,  338,    1,    2,  341,  342,  417,   20,  366,   22,
 /*   470 */   251,  333,  366,  235,   33,   43,  374,   45,   46,  373,
 /*   480 */    33,  100,   35,  102,  256,  257,  258,  338,  382,   48,
 /*   490 */   341,  342,  443,    3,  100,   54,   55,   56,   57,   58,
 /*   500 */   333,  341,  352,  353,  366,   58,    0,   97,  365,  101,
 /*   510 */    20,   64,  374,   14,   15,   16,  341,  379,   71,  381,
 /*   520 */   341,  378,  420,  113,  114,  115,  116,  117,  118,  119,
 /*   530 */   120,  121,  122,  366,  124,  125,  126,  127,  128,  129,
 /*   540 */    99,  374,  251,  102,   97,  251,  379,  100,  381,  411,
 /*   550 */   390,    4,  392,  415,  168,   71,  418,  419,  420,  421,
 /*   560 */   422,  423,  101,  425,  403,  390,   19,  392,  430,  390,
 /*   570 */   432,  392,   35,  376,  436,  437,  379,  345,  411,  185,
 /*   580 */    33,  187,  415,  136,  137,  418,  419,  420,  421,  422,
 /*   590 */   423,  101,  425,  361,   13,   48,  458,  430,    0,  432,
 /*   600 */    53,  369,  333,  436,  437,   58,  333,  213,   71,  333,
 /*   610 */   169,  170,   20,  166,  167,  174,   35,  176,  112,  172,
 /*   620 */   173,  341,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   630 */    32,   44,  251,  186,  193,  188,  130,  131,  132,  133,
 /*   640 */   134,  135,  366,  358,   64,  251,   99,   14,  379,  102,
 /*   650 */   374,  366,  379,   20,  374,  379,    0,  381,  168,  367,
 /*   660 */   375,  214,  215,   20,  217,  218,  219,  220,  221,  222,
 /*   670 */   223,  224,  225,  226,  227,  228,  229,  230,  231,  232,
 /*   680 */   233,  234,   12,   13,   14,  131,  333,  411,  101,  135,
 /*   690 */    20,  415,   22,  341,  418,  419,  420,  421,  422,  423,
 /*   700 */     0,  425,  355,   33,    2,   35,  430,  181,  432,  357,
 /*   710 */     8,    9,  436,  437,   12,   13,   14,   15,   16,  366,
 /*   720 */   440,  441,  442,  447,  444,  445,  374,  374,   58,   22,
 /*   730 */   204,  205,  379,  429,  381,  431,  333,   66,   67,   68,
 /*   740 */   368,   71,   35,    4,   73,   74,   75,  367,  194,  195,
 /*   750 */    79,  379,  198,  334,  200,   84,   85,   86,   87,  333,
 /*   760 */   168,   90,  333,   63,  411,  341,  333,   97,  415,  366,
 /*   770 */   100,  418,  419,  420,  421,  422,  423,  374,  425,  136,
 /*   780 */   137,  357,  379,  430,  381,  432,  414,  415,  416,  436,
 /*   790 */   437,   58,  333,  417,  214,  366,   22,  425,  374,  166,
 /*   800 */   447,  341,   80,  374,   97,  379,  136,  137,  379,   35,
 /*   810 */   381,  155,  379,  367,  411,  172,  173,  357,  415,  443,
 /*   820 */   164,  418,  419,  420,  421,  422,  423,  424,  425,  426,
 /*   830 */   427,  354,   99,  356,  374,  102,  166,  167,  379,  341,
 /*   840 */   411,   37,  172,  173,  415,   71,  341,  418,  419,  420,
 /*   850 */   421,  422,  423,  367,  425,  357,  186,    0,  188,  430,
 /*   860 */   358,  432,  357,  141,  142,  436,  437,   14,  366,  374,
 /*   870 */    22,   97,  374,   20,  333,  333,  447,  375,  367,  374,
 /*   880 */   385,  333,  130,   35,  214,  215,  164,  217,  218,  219,
 /*   890 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   900 */   230,  231,  232,  233,  234,   12,   13,  103,  368,  105,
 /*   910 */   106,  398,  108,   20,  366,   22,  112,  341,  367,  379,
 /*   920 */   379,  379,  374,   66,   67,   68,   33,  379,   35,  381,
 /*   930 */    73,   74,   75,  357,  345,  428,   79,  133,  431,   45,
 /*   940 */    46,   84,   85,   86,   87,   97,  417,   90,  196,  197,
 /*   950 */   374,   58,   13,  333,  414,  415,  416,  444,  369,  411,
 /*   960 */   186,  448,  188,  415,   71,  425,  418,  419,  420,  421,
 /*   970 */   422,  423,  443,  425,   35,  347,  463,  464,  430,  358,
 /*   980 */   432,  468,  469,   20,  436,  437,  366,  366,  214,  215,
 /*   990 */    97,  252,   21,  100,  374,  447,  375,  130,  131,  379,
 /*  1000 */   372,  381,  135,   12,   13,   34,  366,   36,  444,  333,
 /*  1010 */     8,    9,  448,   22,   12,   13,   14,   15,   16,  166,
 /*  1020 */   341,  341,  382,  374,   33,  333,   35,   39,  464,  136,
 /*  1030 */   137,  411,  468,  469,  385,  415,  357,  357,  418,  419,
 /*  1040 */   420,  421,  422,  423,    3,  425,   44,  341,  376,   58,
 /*  1050 */   430,  379,  432,  374,  374,  379,  436,  437,  376,  166,
 /*  1060 */   167,  379,   71,  357,  112,  172,  173,  447,    8,    9,
 /*  1070 */   341,  379,   12,   13,   14,   15,   16,    0,  367,  186,
 /*  1080 */   374,  188,  374,  389,    2,  133,  357,   44,   97,  333,
 /*  1090 */     8,    9,   22,  385,   12,   13,   14,   15,   16,    0,
 /*  1100 */   333,  333,  333,  374,  333,   35,  359,  214,  215,  362,
 /*  1110 */   217,  218,  219,  220,  221,  222,  223,  224,  225,  226,
 /*  1120 */   227,  228,  229,  230,  231,  232,  233,  234,   12,   13,
 /*  1130 */   333,  168,  249,  250,    0,  379,   20,  366,   22,  341,
 /*  1140 */   341,  104,  341,  343,  107,  374,  379,  379,  379,   33,
 /*  1150 */   379,   35,  381,   20,  104,  357,  357,  107,    8,    9,
 /*  1160 */   111,  101,   12,   13,   14,   15,   16,  341,   42,  341,
 /*  1170 */    44,  333,  374,  374,   58,  374,  379,  186,   44,  188,
 /*  1180 */   333,  341,  411,  357,  472,  357,  415,   71,  461,  418,
 /*  1190 */   419,  420,  421,  422,  423,  104,  425,  357,  107,   35,
 /*  1200 */   374,  430,  374,  432,  333,  214,  215,  436,  437,  160,
 /*  1210 */   333,  112,  104,   97,  374,  107,  100,  379,  227,  228,
 /*  1220 */   229,  230,  231,  232,  233,  398,  379,  455,  341,  130,
 /*  1230 */   131,  132,  133,  134,  135,   18,   44,   42,  250,   44,
 /*  1240 */    23,  440,  441,  442,  357,  444,  445,  341,   96,  448,
 /*  1250 */   379,  341,  136,  137,   37,   38,  379,   58,   41,    0,
 /*  1260 */   199,  374,  201,  357,  463,  464,   44,  357,   44,  468,
 /*  1270 */   469,  444,    0,  136,  137,  448,   59,   60,   61,   62,
 /*  1280 */   374,   22,  166,  167,  374,  208,   44,  112,  172,  173,
 /*  1290 */   463,  464,    0,  101,   22,  468,  469,   44,   35,  166,
 /*  1300 */    44,  102,  186,  366,  188,  130,  131,  132,  133,  134,
 /*  1310 */   135,   47,  271,  398,   22,   44,  273,  100,  168,   44,
 /*  1320 */   168,    1,    2,  101,   44,  101,   35,  333,   44,   44,
 /*  1330 */   214,  215,   44,  217,  218,  219,  220,  221,  222,  223,
 /*  1340 */   224,  225,  226,  227,  228,  229,  230,  231,  232,  233,
 /*  1350 */   234,   44,  188,   44,  101,  138,  343,  101,  333,  444,
 /*  1360 */   366,   44,   71,  448,  100,   44,   13,   44,  374,  389,
 /*  1370 */   340,   13,  101,  379,   44,  381,  101,   44,  463,  464,
 /*  1380 */    44,  101,  100,  468,  469,  101,  101,  378,   35,  101,
 /*  1390 */     0,  366,  110,   35,  389,  178,  179,  180,  465,  374,
 /*  1400 */   183,  446,  438,  449,  379,  411,  381,  253,  101,  415,
 /*  1410 */   101,  413,  418,  419,  420,  421,  422,  423,  101,  425,
 /*  1420 */   203,   48,  101,  206,  101,  184,  209,  210,  211,  212,
 /*  1430 */   213,  101,  412,  400,  101,   42,  411,  101,  333,   49,
 /*  1440 */   415,  368,  386,  418,  419,  420,  421,  422,  423,   20,
 /*  1450 */   425,  188,  379,  459,  460,  389,  384,  432,  333,    8,
 /*  1460 */     9,  436,  437,   12,   13,   14,   15,   16,  251,  386,
 /*  1470 */   165,  366,   20,  341,  386,   98,  341,  384,  384,  374,
 /*  1480 */   351,   95,  341,   94,  379,  349,  381,  414,  415,  416,
 /*  1490 */   350,  366,  341,   20,  341,  335,  341,  335,  425,  374,
 /*  1500 */    20,  406,   20,  347,  379,  381,  381,   20,  347,  342,
 /*  1510 */    20,  399,  347,  342,  341,  347,  411,  275,   52,  347,
 /*  1520 */   415,  347,  344,  418,  419,  420,  421,  422,  423,  347,
 /*  1530 */   425,  344,  335,  202,  100,  333,  411,  432,  379,  335,
 /*  1540 */   415,  436,  437,  418,  419,  420,  421,  422,  423,  366,
 /*  1550 */   425,  366,  333,  341,  366,  366,  366,  432,  379,  366,
 /*  1560 */   366,  436,  437,  379,  366,  408,  366,  366,  366,  366,
 /*  1570 */   345,  192,  406,  410,  405,  191,  374,  381,  345,  341,
 /*  1580 */   404,  379,  260,  381,  454,  366,  379,  259,  379,  177,
 /*  1590 */   379,  277,  454,  374,  389,  389,  457,  379,  379,  456,
 /*  1600 */   381,  454,  394,  268,  394,  254,  274,  270,  269,  250,
 /*  1610 */   272,  453,  333,  411,  466,  473,  467,  415,  374,   20,
 /*  1620 */   418,  419,  420,  421,  422,  423,  413,  425,  341,  452,
 /*  1630 */   411,  451,  417,   20,  415,  342,  333,  418,  419,  420,
 /*  1640 */   421,  422,  423,  345,  425,  366,  345,  392,  394,  379,
 /*  1650 */   100,  432,  379,  374,  394,  379,  437,  379,  379,  170,
 /*  1660 */   381,  345,  379,  345,  362,  379,  435,  100,  391,  366,
 /*  1670 */   374,  356,  470,  471,  370,  341,  379,  374,   36,  336,
 /*  1680 */   335,  407,  379,  331,  381,  345,  360,  360,  346,  395,
 /*  1690 */   411,  401,    0,    0,  415,  395,    0,  418,  419,  420,
 /*  1700 */   421,  422,  423,   42,  425,    0,  360,  333,   35,  207,
 /*  1710 */    35,   35,   35,  207,  411,    0,   35,   35,  415,  207,
 /*  1720 */     0,  418,  419,  420,  421,  422,  423,  207,  425,  333,
 /*  1730 */     0,    0,   35,   22,    0,   35,  194,  188,  186,  460,
 /*  1740 */   366,    0,    0,    0,  182,  181,    0,    0,  374,   47,
 /*  1750 */     0,    0,    0,  379,   42,  381,    0,    0,    0,    0,
 /*  1760 */     0,    0,  366,    0,    0,  462,  155,  371,   35,    0,
 /*  1770 */   374,  155,    0,    0,    0,  379,    0,  381,    0,  333,
 /*  1780 */     0,    0,    0,    0,    0,  411,    0,    0,    0,  415,
 /*  1790 */     0,    0,  418,  419,  420,  421,  422,  423,    0,  425,
 /*  1800 */     0,    0,  333,    0,   42,    0,    0,  411,    0,    0,
 /*  1810 */     0,  415,  366,    0,  418,  419,  420,  421,  422,  423,
 /*  1820 */   374,  425,  139,    0,   22,  379,    0,  381,   96,   22,
 /*  1830 */     0,   96,   35,   22,    0,  366,    0,   58,    0,    0,
 /*  1840 */   371,   42,   47,  374,    0,  471,   14,   58,  379,   14,
 /*  1850 */   381,   58,    0,   39,    0,    0,   44,  411,   40,   39,
 /*  1860 */   333,  415,   47,   39,  418,  419,  420,  421,  422,  423,
 /*  1870 */     0,  425,   47,  427,    0,  177,    0,    0,    0,   48,
 /*  1880 */   411,   19,   65,   35,  415,   39,    0,  418,  419,  420,
 /*  1890 */   421,  422,  423,  366,  425,   33,   35,   48,  371,   39,
 /*  1900 */     0,  374,   35,   39,   48,    0,  379,   35,  381,    0,
 /*  1910 */    48,   48,   39,    0,    0,    0,   54,   55,   56,   57,
 /*  1920 */    58,   22,   35,    0,   35,   35,   35,  333,  109,  107,
 /*  1930 */    35,   35,   35,   35,   22,    0,   44,   44,  411,   35,
 /*  1940 */    22,   35,  415,   35,    0,  418,  419,  420,  421,  422,
 /*  1950 */   423,   22,  425,   50,    0,   22,  333,   35,    0,   35,
 /*  1960 */   366,   99,    0,   35,  102,    0,   20,   22,  374,   35,
 /*  1970 */   101,   35,   35,  379,    0,  381,   35,   22,    0,  100,
 /*  1980 */   100,  189,   22,    0,    0,    3,   44,  333,  100,  366,
 /*  1990 */     3,  170,  255,   44,  100,  168,  134,  374,   96,   98,
 /*  2000 */    44,  168,  379,  175,  381,  411,   47,   96,  168,  415,
 /*  2010 */    44,  101,  418,  419,  420,  421,  422,  423,  333,  425,
 /*  2020 */   366,   95,  101,   47,   44,  255,  101,  100,  374,   44,
 /*  2030 */   100,  169,  100,  379,  411,  381,  174,   35,  415,  101,
 /*  2040 */   100,  418,  419,  420,  421,  422,  423,   35,  425,  101,
 /*  2050 */    35,  366,  190,  101,  101,  193,   35,   35,   35,  374,
 /*  2060 */    47,   44,    0,   47,  379,  411,  381,    0,  101,  415,
 /*  2070 */     0,    0,  418,  419,  420,  421,  422,  423,   39,  425,
 /*  2080 */    47,  100,  333,    0,  255,   39,  249,  101,  100,  169,
 /*  2090 */   101,  100,  100,  100,  100,   47,  411,   44,   98,  333,
 /*  2100 */   415,  236,  171,  418,  419,  420,  421,  422,  423,  110,
 /*  2110 */   425,    2,   98,   22,   22,  366,   47,  111,  100,   47,
 /*  2120 */   100,  214,   35,  374,   35,  101,  101,  100,  379,  101,
 /*  2130 */   381,  100,  366,  101,  100,  216,  101,  100,  100,   35,
 /*  2140 */   374,  101,  100,   35,  101,  379,  101,  381,   35,  333,
 /*  2150 */   100,  100,   35,  101,  100,   22,  112,   35,  100,   44,
 /*  2160 */   411,  100,   22,  100,  415,   35,   65,  418,  419,  420,
 /*  2170 */   421,  422,  423,   35,  425,   64,   35,  411,  123,  123,
 /*  2180 */   123,  415,  366,  123,  418,  419,  420,  421,  422,  423,
 /*  2190 */   374,  425,   35,   35,   35,  379,   35,  381,   35,  333,
 /*  2200 */    35,   35,   71,   93,   44,   35,   35,   35,   22,   35,
 /*  2210 */    35,   35,   35,   71,   35,  333,   35,   35,   22,   35,
 /*  2220 */    35,    0,   35,    0,    0,   35,   48,  411,   39,    0,
 /*  2230 */    39,  415,  366,   35,  418,  419,  420,  421,  422,  423,
 /*  2240 */   374,  425,   48,   48,   39,  379,   35,  381,  366,   48,
 /*  2250 */     0,   39,   35,   35,    0,   22,  374,   21,  474,   22,
 /*  2260 */    22,  379,   21,  381,   20,  474,  474,  474,  474,  474,
 /*  2270 */   474,  474,  474,  474,  474,  474,  333,  411,  474,  474,
 /*  2280 */   474,  415,  474,  474,  418,  419,  420,  421,  422,  423,
 /*  2290 */   474,  425,  474,  411,  333,  474,  474,  415,  474,  474,
 /*  2300 */   418,  419,  420,  421,  422,  423,  474,  425,  474,  366,
 /*  2310 */   474,  474,  474,  474,  474,  474,  474,  374,  474,  474,
 /*  2320 */   474,  474,  379,  474,  381,  474,  474,  366,  474,  474,
 /*  2330 */   474,  474,  474,  474,  474,  374,  474,  474,  474,  474,
 /*  2340 */   379,  474,  381,  474,  474,  474,  474,  474,  474,  474,
 /*  2350 */   474,  474,  333,  474,  411,  474,  474,  474,  415,  474,
 /*  2360 */   474,  418,  419,  420,  421,  422,  423,  474,  425,  333,
 /*  2370 */   474,  474,  411,  474,  474,  474,  415,  474,  474,  418,
 /*  2380 */   419,  420,  421,  422,  423,  366,  425,  474,  474,  474,
 /*  2390 */   474,  474,  474,  374,  474,  474,  474,  474,  379,  474,
 /*  2400 */   381,  474,  366,  474,  474,  474,  474,  474,  474,  474,
 /*  2410 */   374,  474,  474,  474,  474,  379,  474,  381,  474,  474,
 /*  2420 */   474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
 /*  2430 */   411,  474,  474,  333,  415,  474,  474,  418,  419,  420,
 /*  2440 */   421,  422,  423,  474,  425,  474,  474,  411,  474,  333,
 /*  2450 */   474,  415,  474,  474,  418,  419,  420,  421,  422,  423,
 /*  2460 */   474,  425,  474,  474,  474,  474,  366,  474,  474,  474,
 /*  2470 */   474,  474,  474,  474,  374,  474,  474,  474,  474,  379,
 /*  2480 */   474,  381,  366,  474,  474,  474,  474,  474,  474,  474,
 /*  2490 */   374,  474,  474,  474,  474,  379,  474,  381,  474,  474,
 /*  2500 */   474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
 /*  2510 */   474,  411,  474,  474,  474,  415,  333,  474,  418,  419,
 /*  2520 */   420,  421,  422,  423,  474,  425,  474,  411,  474,  474,
 /*  2530 */   474,  415,  474,  333,  418,  419,  420,  421,  422,  423,
 /*  2540 */   474,  425,  474,  474,  474,  474,  474,  474,  474,  366,
 /*  2550 */   474,  474,  474,  474,  474,  474,  474,  374,  474,  474,
 /*  2560 */   474,  474,  379,  474,  381,  474,  366,  474,  474,  474,
 /*  2570 */   474,  474,  474,  474,  374,  474,  474,  474,  474,  379,
 /*  2580 */   474,  381,  474,  474,  474,  474,  474,  474,  474,  474,
 /*  2590 */   474,  474,  474,  474,  411,  333,  474,  474,  415,  474,
 /*  2600 */   474,  418,  419,  420,  421,  422,  423,  474,  425,  474,
 /*  2610 */   474,  411,  474,  474,  474,  415,  474,  474,  418,  419,
 /*  2620 */   420,  421,  422,  423,  474,  425,  474,  474,  366,  474,
 /*  2630 */   474,  474,  474,  474,  474,  474,  374,  474,  474,  474,
 /*  2640 */   474,  379,  474,  381,  474,  474,  474,  474,  474,  474,
 /*  2650 */   474,  474,  474,  474,  474,  474,  333,  474,  474,  474,
 /*  2660 */   474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
 /*  2670 */   474,  474,  474,  411,  333,  474,  474,  415,  474,  474,
 /*  2680 */   418,  419,  420,  421,  422,  423,  474,  425,  474,  366,
 /*  2690 */   474,  474,  474,  474,  474,  474,  474,  374,  474,  474,
 /*  2700 */   474,  474,  379,  474,  381,  474,  474,  366,  474,  474,
 /*  2710 */   474,  474,  474,  474,  474,  374,  474,  474,  474,  474,
 /*  2720 */   379,  474,  381,  474,  474,  474,  474,  474,  474,  474,
 /*  2730 */   474,  474,  333,  474,  411,  474,  474,  474,  415,  474,
 /*  2740 */   474,  418,  419,  420,  421,  422,  423,  474,  425,  333,
 /*  2750 */   474,  474,  411,  474,  474,  474,  415,  474,  474,  418,
 /*  2760 */   419,  420,  421,  422,  423,  366,  425,  474,  474,  474,
 /*  2770 */   474,  474,  474,  374,  474,  474,  474,  474,  379,  474,
 /*  2780 */   381,  474,  366,  474,  474,  474,  474,  474,  474,  474,
 /*  2790 */   374,  474,  474,  474,  474,  379,  474,  381,  474,  474,
 /*  2800 */   474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
 /*  2810 */   411,  474,  474,  474,  415,  474,  474,  418,  419,  420,
 /*  2820 */   421,  422,  423,  474,  425,  474,  474,  411,  474,  474,
 /*  2830 */   474,  415,  474,  474,  418,  419,  420,  421,  422,  423,
 /*  2840 */   474,  425,
};
#define YY_SHIFT_COUNT    (758)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2254)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1217,    0,  223,    0,  447,  447,  447,  447,  447,  447,
 /*    10 */   447,  447,  447,  447,  447,  670,  893,  893, 1116,  893,
 /*    20 */   893,  893,  893,  893,  893,  893,  893,  893,  893,  893,
 /*    30 */   893,  893,  893,  893,  893,  893,  893,  893,  893,  893,
 /*    40 */   893,  893,  893,  893,  893,  893,  893,  893,  219,  294,
 /*    50 */   394,  148,  381,   71,  291,   71,  148,  148,  991,  991,
 /*    60 */   991,   71,  991,  991,  147,   71,   31,  643,   46,   46,
 /*    70 */   643,  432,  432,  221,   45,   35,   35,   46,   46,   46,
 /*    80 */    46,   46,   46,   46,  124,   46,   46,   22,   31,   46,
 /*    90 */    46,  186,   46,   31,   46,  124,   46,  124,   31,   46,
 /*   100 */    46,   31,   46,   31,   31,   31,   46,  203,  222,  187,
 /*   110 */   187,  671,   13,  774,  774,  774,  774,  774,  774,  774,
 /*   120 */   774,  774,  774,  774,  774,  774,  774,  774,  774,  774,
 /*   130 */   774,  774,  804,  490,  221,   45,  537,  386,  386,  386,
 /*   140 */   700,  173,  173,  537,  251,  251,  251,   22,  207,  238,
 /*   150 */    31,  116,   31,  116,  116,  247,  484,  410,  410,  410,
 /*   160 */   410,  410,  410,  410,  410, 1862,  857,  313,  196,   16,
 /*   170 */    65,  112,  228,  633,  853,  335,  592,  894,  952,  963,
 /*   180 */   883,  988, 1041,  883, 1126,  739, 1133, 1154, 1373, 1241,
 /*   190 */  1393, 1429, 1393, 1305, 1452, 1452, 1393, 1305, 1305, 1377,
 /*   200 */  1386, 1452, 1389, 1452, 1452, 1452, 1473, 1473, 1480,   22,
 /*   210 */  1482,   22, 1487, 1490,   22, 1487,   22,   22,   22, 1452,
 /*   220 */    22, 1466, 1466, 1473,   31,   31,   31,   31,   31,   31,
 /*   230 */    31,   31,   31,   31,   31, 1452, 1473,  116,  116,  116,
 /*   240 */  1331, 1434, 1480,  203, 1379, 1384, 1482,  203, 1452, 1429,
 /*   250 */  1429,  116, 1322, 1328,  116, 1322, 1328,  116,  116,   31,
 /*   260 */  1335, 1412, 1322, 1337, 1339, 1351, 1154, 1314, 1332, 1338,
 /*   270 */  1359,  251, 1599, 1452, 1487,  203,  203, 1613, 1328,  116,
 /*   280 */   116,  116,  116,  116, 1328,  116, 1489,  203,  247,  203,
 /*   290 */   251, 1550, 1567,  116,  484, 1452,  203, 1642, 1473, 2842,
 /*   300 */  2842, 2842, 2842, 2842, 2842, 2842, 2842, 2842,   36,  441,
 /*   310 */   598,  547,  408, 1002, 1060,  506,  702, 1082, 1150, 1099,
 /*   320 */  1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451, 1175,
 /*   330 */   554,   76,   76,  722,  526,  656,  733,  707,  848,  971,
 /*   340 */   752,  867,  867,  499,  461,  144,  499,  499,  499,  288,
 /*   350 */  1077,  587, 1070, 1195, 1049, 1134, 1037, 1050, 1091, 1108,
 /*   360 */   581,  939, 1259, 1272, 1292, 1061, 1192, 1222, 1199, 1224,
 /*   370 */  1253, 1256, 1137, 1043, 1242, 1152, 1271, 1275, 1280, 1284,
 /*   380 */  1285, 1288, 1320, 1307, 1164, 1263,  580, 1309, 1264, 1317,
 /*   390 */  1321, 1323, 1330, 1333, 1336, 1282, 1353, 1358, 1291, 1390,
 /*   400 */  1692, 1693, 1696, 1661, 1705, 1673, 1502, 1675, 1676, 1677,
 /*   410 */  1506, 1715, 1681, 1682, 1512, 1720, 1520, 1730, 1697, 1731,
 /*   420 */  1711, 1734, 1700, 1542, 1549, 1552, 1741, 1742, 1743, 1562,
 /*   430 */  1564, 1746, 1747, 1702, 1750, 1751, 1752, 1712, 1756, 1757,
 /*   440 */  1758, 1759, 1760, 1761, 1763, 1764, 1611, 1733, 1769, 1616,
 /*   450 */  1772, 1773, 1774, 1776, 1778, 1780, 1781, 1782, 1783, 1784,
 /*   460 */  1786, 1787, 1788, 1790, 1791, 1798, 1762, 1800, 1801, 1803,
 /*   470 */  1805, 1806, 1808, 1802, 1809, 1810, 1813, 1683, 1823, 1826,
 /*   480 */  1807, 1732, 1811, 1735, 1830, 1779, 1797, 1834, 1789, 1836,
 /*   490 */  1793, 1838, 1839, 1799, 1814, 1812, 1795, 1832, 1815, 1835,
 /*   500 */  1825, 1844, 1818, 1820, 1852, 1854, 1855, 1824, 1698, 1870,
 /*   510 */  1874, 1876, 1817, 1877, 1878, 1848, 1831, 1846, 1886, 1861,
 /*   520 */  1849, 1860, 1900, 1867, 1856, 1864, 1905, 1872, 1863, 1873,
 /*   530 */  1909, 1913, 1914, 1915, 1819, 1822, 1887, 1899, 1923, 1889,
 /*   540 */  1890, 1891, 1895, 1896, 1897, 1898, 1892, 1893, 1904, 1906,
 /*   550 */  1912, 1908, 1935, 1918, 1944, 1929, 1903, 1954, 1933, 1922,
 /*   560 */  1958, 1924, 1962, 1928, 1965, 1945, 1946, 1934, 1936, 1937,
 /*   570 */  1869, 1879, 1974, 1827, 1880, 1941, 1955, 1978, 1792, 1960,
 /*   580 */  1833, 1821, 1983, 1984, 1840, 1828, 1982, 1942, 1737, 1888,
 /*   590 */  1910, 1894, 1902, 1901, 1911, 1926, 1921, 1949, 1956, 1925,
 /*   600 */  1927, 1930, 1932, 1938, 1966, 1959, 1976, 1940, 1980, 1770,
 /*   610 */  1948, 1952, 1987, 1985, 1829, 2002, 2012, 2015, 2021, 2022,
 /*   620 */  2023, 1953, 1967, 2013, 1837, 2017, 2016, 2062, 2067, 2070,
 /*   630 */  2071, 1981, 2039, 1795, 2033, 1988, 1986, 1989, 1991, 1992,
 /*   640 */  1931, 1993, 2083, 2046, 1920, 1994, 1999, 1795, 2048, 2053,
 /*   650 */  2000, 1865, 2014, 2109, 2091, 1907, 2018, 2024, 2020, 2025,
 /*   660 */  2027, 2028, 2069, 2031, 2034, 2072, 2032, 2092, 1919, 2037,
 /*   670 */  2006, 2035, 2087, 2089, 2038, 2040, 2104, 2042, 2043, 2108,
 /*   680 */  2050, 2045, 2113, 2051, 2052, 2117, 2054, 2055, 2056, 2057,
 /*   690 */  2060, 2133, 2044, 2058, 2115, 2061, 2122, 2063, 2115, 2115,
 /*   700 */  2140, 2101, 2111, 2130, 2138, 2141, 2157, 2158, 2159, 2161,
 /*   710 */  2163, 2165, 2166, 2131, 2110, 2160, 2170, 2171, 2172, 2186,
 /*   720 */  2174, 2175, 2176, 2142, 1892, 2177, 1893, 2179, 2181, 2182,
 /*   730 */  2184, 2196, 2185, 2221, 2187, 2178, 2189, 2223, 2190, 2194,
 /*   740 */  2191, 2224, 2198, 2195, 2205, 2229, 2211, 2201, 2212, 2250,
 /*   750 */  2217, 2218, 2254, 2233, 2236, 2237, 2238, 2241, 2244,
};
#define YY_REDUCE_COUNT (307)
#define YY_REDUCE_MIN   (-396)
#define YY_REDUCE_MAX   (2416)
static const short yy_reduce_ofst[] = {
 /*     0 */  -315, -280, -120,  138,  276,  353,  429,  548,  620,  -18,
 /*    10 */   167,  771, 1025, 1105, 1125,  403,  994, 1202, 1219, 1279,
 /*    20 */  1303, 1374, 1396, 1446, 1469, 1527, 1594, 1623, 1654, 1685,
 /*    30 */  1749, 1766, 1816, 1866, 1882, 1943, 1961, 2019, 2036, 2100,
 /*    40 */  2116, 2183, 2200, 2262, 2323, 2341, 2399, 2416,  801, -289,
 /*    50 */  -396, -177, -394,  513,  827,  915,  -91,  280,  372,  540,
 /*    60 */  1073, -279, -368,  -90, -388,  564,  -89, -235, -181,  -84,
 /*    70 */  -380, -332, -278,  -81, -354,  123,  149,  352,  424,  460,
 /*    80 */   498,  505,  576,  679,  160,  680,  706, -265, -363,  729,
 /*    90 */   798,  102,  799, -175,  826,  175,  828,  179,  285,  840,
 /*   100 */   887, -129,  906,  502,  106,  621,  910,  232, -320, -355,
 /*   110 */  -355,  -51,  -58, -141,  269,  273,  426,  433,  459,  541,
 /*   120 */   542,  676,  692,  756,  767,  768,  769,  797,  838,  847,
 /*   130 */   871,  877,  143,   49, -106, -285,   -6,   49,  376,  529,
 /*   140 */   589,  -16,  304,  150,  495,  649,  708,  628, -232,  507,
 /*   150 */  -357,  197,  640,  672,  682,  747,  477,  292,  380,  446,
 /*   160 */   486,  511,  551,  711,  511,  161,  347,  419,  694,  712,
 /*   170 */   727,  800,  772,  937,  937, 1013,  980, 1030, 1009, 1005,
 /*   180 */   955,  955,  933,  955,  964,  954,  937,  998, 1020, 1033,
 /*   190 */  1056, 1066, 1083, 1072, 1132, 1135, 1088, 1093, 1094, 1129,
 /*   200 */  1140, 1141, 1136, 1151, 1153, 1155, 1160, 1162, 1095, 1156,
 /*   210 */  1124, 1161, 1167, 1112, 1165, 1171, 1168, 1172, 1174, 1173,
 /*   220 */  1182, 1178, 1187, 1197, 1183, 1185, 1188, 1189, 1190, 1193,
 /*   230 */  1194, 1198, 1200, 1201, 1203, 1212, 1204, 1159, 1179, 1184,
 /*   240 */  1163, 1157, 1166, 1225, 1169, 1176, 1196, 1233, 1238, 1205,
 /*   250 */  1206, 1207, 1130, 1208, 1209, 1138, 1210, 1211, 1218,  937,
 /*   260 */  1139, 1143, 1147, 1158, 1177, 1180, 1213, 1142, 1149, 1148,
 /*   270 */   955, 1244, 1215, 1287, 1293, 1298, 1301, 1255, 1254, 1270,
 /*   280 */  1273, 1276, 1278, 1283, 1260, 1286, 1277, 1316, 1302, 1318,
 /*   290 */  1296, 1231, 1304, 1297, 1315, 1334, 1340, 1343, 1345, 1290,
 /*   300 */  1274, 1294, 1300, 1326, 1327, 1346, 1342, 1352,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*    10 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*    20 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*    30 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*    40 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*    50 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*    60 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*    70 */  1709, 1709, 1709, 1980, 1709, 1709, 1709, 1709, 1709, 1709,
 /*    80 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1788, 1709, 1709,
 /*    90 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   100 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1786, 1973, 2192,
 /*   110 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   120 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   130 */  1709, 1709, 1709, 2204, 1709, 1709, 1709, 2204, 2204, 2204,
 /*   140 */  1786, 2164, 2164, 1709, 1709, 1709, 1709, 1788, 2036, 1709,
 /*   150 */  1709, 1709, 1709, 1709, 1709, 1908, 1709, 1709, 1709, 1709,
 /*   160 */  1709, 1932, 1709, 1709, 1709, 2026, 1709, 1709, 2229, 2285,
 /*   170 */  1709, 1709, 2232, 1709, 1709, 1709, 1985, 1709, 1861, 2219,
 /*   180 */  2196, 2210, 2269, 2197, 2194, 2213, 1709, 2223, 1709, 2019,
 /*   190 */  1978, 1709, 1978, 1975, 1709, 1709, 1978, 1975, 1975, 1850,
 /*   200 */  1846, 1709, 1844, 1709, 1709, 1709, 1709, 1709, 1709, 1788,
 /*   210 */  1709, 1788, 1709, 1709, 1788, 1709, 1788, 1788, 1788, 1709,
 /*   220 */  1788, 1766, 1766, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   230 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   240 */  2048, 2034, 1709, 1786, 2030, 2028, 1709, 1786, 1709, 1709,
 /*   250 */  1709, 1709, 2240, 2238, 1709, 2240, 2238, 1709, 1709, 1709,
 /*   260 */  2254, 2250, 2240, 2258, 2256, 2225, 2223, 2288, 2275, 2271,
 /*   270 */  2210, 1709, 1709, 1709, 1709, 1786, 1786, 1709, 2238, 1709,
 /*   280 */  1709, 1709, 1709, 1709, 2238, 1709, 1709, 1786, 1709, 1786,
 /*   290 */  1709, 1709, 1877, 1709, 1709, 1709, 1786, 1741, 1709, 2021,
 /*   300 */  2039, 2003, 2003, 1911, 1911, 1911, 1789, 1714, 1709, 1709,
 /*   310 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   320 */  2253, 2252, 2119, 1709, 2168, 2167, 2166, 2157, 2118, 1873,
 /*   330 */  1709, 2117, 2116, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   340 */  1709, 1994, 1993, 2110, 1709, 1709, 2111, 2109, 2108, 1709,
 /*   350 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   360 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   370 */  1709, 1709, 1709, 2272, 2276, 1709, 1709, 1709, 1709, 1709,
 /*   380 */  1709, 1709, 2193, 1709, 1709, 1709, 1709, 1709, 2092, 1709,
 /*   390 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   400 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   410 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   420 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   430 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   440 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   450 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   460 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   470 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   480 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   490 */  1709, 1709, 1709, 1709, 1709, 1746, 2097, 1709, 1709, 1709,
 /*   500 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   510 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   520 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   530 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   540 */  1709, 1709, 1709, 1709, 1709, 1709, 1827, 1826, 1709, 1709,
 /*   550 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   560 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   570 */  2101, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   580 */  1709, 1709, 1709, 1709, 1709, 1709, 2268, 2226, 1709, 1709,
 /*   590 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   600 */  1709, 1709, 1709, 1709, 1709, 1709, 2092, 1709, 2251, 1709,
 /*   610 */  1709, 2266, 1709, 2270, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   620 */  1709, 2203, 2199, 1709, 1709, 2195, 1709, 1709, 1709, 1709,
 /*   630 */  1709, 1709, 1709, 2100, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   640 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 2091, 1709, 2154,
 /*   650 */  1709, 1709, 1709, 2188, 1709, 1709, 2139, 1709, 1709, 1709,
 /*   660 */  1709, 1709, 1709, 1709, 1709, 1709, 2101, 1709, 2104, 1709,
 /*   670 */  1709, 1709, 1709, 1709, 1905, 1709, 1709, 1709, 1709, 1709,
 /*   680 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1890, 1888, 1887,
 /*   690 */  1886, 1709, 1883, 1709, 1918, 1709, 1709, 1709, 1914, 1913,
 /*   700 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   710 */  1709, 1709, 1709, 1709, 1709, 1807, 1709, 1709, 1709, 1709,
 /*   720 */  1709, 1709, 1709, 1709, 1799, 1709, 1798, 1709, 1709, 1709,
 /*   730 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   740 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*   750 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*       WITH => nothing */
    0,  /*  TIMESTAMP => nothing */
  278,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*   LANGUAGE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*     LEADER => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  278,  /*      AFTER => ABORT */
  278,  /*     ATTACH => ABORT */
  278,  /*     BEFORE => ABORT */
  278,  /*      BEGIN => ABORT */
  278,  /*     BITAND => ABORT */
  278,  /*     BITNOT => ABORT */
  278,  /*      BITOR => ABORT */
  278,  /*     BLOCKS => ABORT */
  278,  /*     CHANGE => ABORT */
  278,  /*      COMMA => ABORT */
  278,  /*     CONCAT => ABORT */
  278,  /*   CONFLICT => ABORT */
  278,  /*       COPY => ABORT */
  278,  /*   DEFERRED => ABORT */
  278,  /* DELIMITERS => ABORT */
  278,  /*     DETACH => ABORT */
  278,  /*     DIVIDE => ABORT */
  278,  /*        DOT => ABORT */
  278,  /*       EACH => ABORT */
  278,  /*       FAIL => ABORT */
  278,  /*       FILE => ABORT */
  278,  /*        FOR => ABORT */
  278,  /*       GLOB => ABORT */
  278,  /*         ID => ABORT */
  278,  /*  IMMEDIATE => ABORT */
  278,  /*     IMPORT => ABORT */
  278,  /*  INITIALLY => ABORT */
  278,  /*    INSTEAD => ABORT */
  278,  /*     ISNULL => ABORT */
  278,  /*        KEY => ABORT */
  278,  /*    MODULES => ABORT */
  278,  /*  NK_BITNOT => ABORT */
  278,  /*    NK_SEMI => ABORT */
  278,  /*    NOTNULL => ABORT */
  278,  /*         OF => ABORT */
  278,  /*       PLUS => ABORT */
  278,  /*  PRIVILEGE => ABORT */
  278,  /*      RAISE => ABORT */
  278,  /*    REPLACE => ABORT */
  278,  /*   RESTRICT => ABORT */
  278,  /*        ROW => ABORT */
  278,  /*       SEMI => ABORT */
  278,  /*       STAR => ABORT */
  278,  /*  STATEMENT => ABORT */
  278,  /*     STRICT => ABORT */
  278,  /*     STRING => ABORT */
  278,  /*      TIMES => ABORT */
  278,  /*     VALUES => ABORT */
  278,  /*   VARIABLE => ABORT */
  278,  /*       VIEW => ABORT */
  278,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "COMPACT",
  /*   63 */ "IF",
  /*   64 */ "NOT",
  /*   65 */ "EXISTS",
  /*   66 */ "BUFFER",
  /*   67 */ "CACHEMODEL",
  /*   68 */ "CACHESIZE",
  /*   69 */ "COMP",
  /*   70 */ "DURATION",
  /*   71 */ "NK_VARIABLE",
  /*   72 */ "MAXROWS",
  /*   73 */ "MINROWS",
  /*   74 */ "KEEP",
  /*   75 */ "PAGES",
  /*   76 */ "PAGESIZE",
  /*   77 */ "TSDB_PAGESIZE",
  /*   78 */ "PRECISION",
  /*   79 */ "REPLICA",
  /*   80 */ "VGROUPS",
  /*   81 */ "SINGLE_STABLE",
  /*   82 */ "RETENTIONS",
  /*   83 */ "SCHEMALESS",
  /*   84 */ "WAL_LEVEL",
  /*   85 */ "WAL_FSYNC_PERIOD",
  /*   86 */ "WAL_RETENTION_PERIOD",
  /*   87 */ "WAL_RETENTION_SIZE",
  /*   88 */ "WAL_ROLL_PERIOD",
  /*   89 */ "WAL_SEGMENT_SIZE",
  /*   90 */ "STT_TRIGGER",
  /*   91 */ "TABLE_PREFIX",
  /*   92 */ "TABLE_SUFFIX",
  /*   93 */ "NK_COLON",
  /*   94 */ "MAX_SPEED",
  /*   95 */ "START",
  /*   96 */ "WITH",
  /*   97 */ "TIMESTAMP",
  /*   98 */ "END",
  /*   99 */ "TABLE",
  /*  100 */ "NK_LP",
  /*  101 */ "NK_RP",
  /*  102 */ "STABLE",
  /*  103 */ "ADD",
  /*  104 */ "COLUMN",
  /*  105 */ "MODIFY",
  /*  106 */ "RENAME",
  /*  107 */ "TAG",
  /*  108 */ "SET",
  /*  109 */ "NK_EQ",
  /*  110 */ "USING",
  /*  111 */ "TAGS",
  /*  112 */ "COMMENT",
  /*  113 */ "BOOL",
  /*  114 */ "TINYINT",
  /*  115 */ "SMALLINT",
  /*  116 */ "INT",
  /*  117 */ "INTEGER",
  /*  118 */ "BIGINT",
  /*  119 */ "FLOAT",
  /*  120 */ "DOUBLE",
  /*  121 */ "BINARY",
  /*  122 */ "NCHAR",
  /*  123 */ "UNSIGNED",
  /*  124 */ "JSON",
  /*  125 */ "VARCHAR",
  /*  126 */ "MEDIUMBLOB",
  /*  127 */ "BLOB",
  /*  128 */ "VARBINARY",
  /*  129 */ "DECIMAL",
  /*  130 */ "MAX_DELAY",
  /*  131 */ "WATERMARK",
  /*  132 */ "ROLLUP",
  /*  133 */ "TTL",
  /*  134 */ "SMA",
  /*  135 */ "DELETE_MARK",
  /*  136 */ "FIRST",
  /*  137 */ "LAST",
  /*  138 */ "SHOW",
  /*  139 */ "PRIVILEGES",
  /*  140 */ "DATABASES",
  /*  141 */ "TABLES",
  /*  142 */ "STABLES",
  /*  143 */ "MNODES",
  /*  144 */ "QNODES",
  /*  145 */ "FUNCTIONS",
  /*  146 */ "INDEXES",
  /*  147 */ "ACCOUNTS",
  /*  148 */ "APPS",
  /*  149 */ "CONNECTIONS",
  /*  150 */ "LICENCES",
  /*  151 */ "GRANTS",
  /*  152 */ "QUERIES",
  /*  153 */ "SCORES",
  /*  154 */ "TOPICS",
  /*  155 */ "VARIABLES",
  /*  156 */ "CLUSTER",
  /*  157 */ "BNODES",
  /*  158 */ "SNODES",
  /*  159 */ "TRANSACTIONS",
  /*  160 */ "DISTRIBUTED",
  /*  161 */ "CONSUMERS",
  /*  162 */ "SUBSCRIPTIONS",
  /*  163 */ "VNODES",
  /*  164 */ "ALIVE",
  /*  165 */ "LIKE",
  /*  166 */ "TBNAME",
  /*  167 */ "QTAGS",
  /*  168 */ "AS",
  /*  169 */ "INDEX",
  /*  170 */ "FUNCTION",
  /*  171 */ "INTERVAL",
  /*  172 */ "COUNT",
  /*  173 */ "LAST_ROW",
  /*  174 */ "TOPIC",
  /*  175 */ "META",
  /*  176 */ "CONSUMER",
  /*  177 */ "GROUP",
  /*  178 */ "DESC",
  /*  179 */ "DESCRIBE",
  /*  180 */ "RESET",
  /*  181 */ "QUERY",
  /*  182 */ "CACHE",
  /*  183 */ "EXPLAIN",
  /*  184 */ "ANALYZE",
  /*  185 */ "VERBOSE",
  /*  186 */ "NK_BOOL",
  /*  187 */ "RATIO",
  /*  188 */ "NK_FLOAT",
  /*  189 */ "OUTPUTTYPE",
  /*  190 */ "AGGREGATE",
  /*  191 */ "BUFSIZE",
  /*  192 */ "LANGUAGE",
  /*  193 */ "STREAM",
  /*  194 */ "INTO",
  /*  195 */ "TRIGGER",
  /*  196 */ "AT_ONCE",
  /*  197 */ "WINDOW_CLOSE",
  /*  198 */ "IGNORE",
  /*  199 */ "EXPIRED",
  /*  200 */ "FILL_HISTORY",
  /*  201 */ "UPDATE",
  /*  202 */ "SUBTABLE",
  /*  203 */ "KILL",
  /*  204 */ "CONNECTION",
  /*  205 */ "TRANSACTION",
  /*  206 */ "BALANCE",
  /*  207 */ "VGROUP",
  /*  208 */ "LEADER",
  /*  209 */ "MERGE",
  /*  210 */ "REDISTRIBUTE",
  /*  211 */ "SPLIT",
  /*  212 */ "DELETE",
  /*  213 */ "INSERT",
  /*  214 */ "NULL",
  /*  215 */ "NK_QUESTION",
  /*  216 */ "NK_ARROW",
  /*  217 */ "ROWTS",
  /*  218 */ "QSTART",
  /*  219 */ "QEND",
  /*  220 */ "QDURATION",
  /*  221 */ "WSTART",
  /*  222 */ "WEND",
  /*  223 */ "WDURATION",
  /*  224 */ "IROWTS",
  /*  225 */ "ISFILLED",
  /*  226 */ "CAST",
  /*  227 */ "NOW",
  /*  228 */ "TODAY",
  /*  229 */ "TIMEZONE",
  /*  230 */ "CLIENT_VERSION",
  /*  231 */ "SERVER_VERSION",
  /*  232 */ "SERVER_STATUS",
  /*  233 */ "CURRENT_USER",
  /*  234 */ "CASE",
  /*  235 */ "WHEN",
  /*  236 */ "THEN",
  /*  237 */ "ELSE",
  /*  238 */ "BETWEEN",
  /*  239 */ "IS",
  /*  240 */ "NK_LT",
  /*  241 */ "NK_GT",
  /*  242 */ "NK_LE",
  /*  243 */ "NK_GE",
  /*  244 */ "NK_NE",
  /*  245 */ "MATCH",
  /*  246 */ "NMATCH",
  /*  247 */ "CONTAINS",
  /*  248 */ "IN",
  /*  249 */ "JOIN",
  /*  250 */ "INNER",
  /*  251 */ "SELECT",
  /*  252 */ "DISTINCT",
  /*  253 */ "WHERE",
  /*  254 */ "PARTITION",
  /*  255 */ "BY",
  /*  256 */ "SESSION",
  /*  257 */ "STATE_WINDOW",
  /*  258 */ "EVENT_WINDOW",
  /*  259 */ "SLIDING",
  /*  260 */ "FILL",
  /*  261 */ "VALUE",
  /*  262 */ "VALUE_F",
  /*  263 */ "NONE",
  /*  264 */ "PREV",
  /*  265 */ "NULL_F",
  /*  266 */ "LINEAR",
  /*  267 */ "NEXT",
  /*  268 */ "HAVING",
  /*  269 */ "RANGE",
  /*  270 */ "EVERY",
  /*  271 */ "ORDER",
  /*  272 */ "SLIMIT",
  /*  273 */ "SOFFSET",
  /*  274 */ "LIMIT",
  /*  275 */ "OFFSET",
  /*  276 */ "ASC",
  /*  277 */ "NULLS",
  /*  278 */ "ABORT",
  /*  279 */ "AFTER",
  /*  280 */ "ATTACH",
  /*  281 */ "BEFORE",
  /*  282 */ "BEGIN",
  /*  283 */ "BITAND",
  /*  284 */ "BITNOT",
  /*  285 */ "BITOR",
  /*  286 */ "BLOCKS",
  /*  287 */ "CHANGE",
  /*  288 */ "COMMA",
  /*  289 */ "CONCAT",
  /*  290 */ "CONFLICT",
  /*  291 */ "COPY",
  /*  292 */ "DEFERRED",
  /*  293 */ "DELIMITERS",
  /*  294 */ "DETACH",
  /*  295 */ "DIVIDE",
  /*  296 */ "DOT",
  /*  297 */ "EACH",
  /*  298 */ "FAIL",
  /*  299 */ "FILE",
  /*  300 */ "FOR",
  /*  301 */ "GLOB",
  /*  302 */ "ID",
  /*  303 */ "IMMEDIATE",
  /*  304 */ "IMPORT",
  /*  305 */ "INITIALLY",
  /*  306 */ "INSTEAD",
  /*  307 */ "ISNULL",
  /*  308 */ "KEY",
  /*  309 */ "MODULES",
  /*  310 */ "NK_BITNOT",
  /*  311 */ "NK_SEMI",
  /*  312 */ "NOTNULL",
  /*  313 */ "OF",
  /*  314 */ "PLUS",
  /*  315 */ "PRIVILEGE",
  /*  316 */ "RAISE",
  /*  317 */ "REPLACE",
  /*  318 */ "RESTRICT",
  /*  319 */ "ROW",
  /*  320 */ "SEMI",
  /*  321 */ "STAR",
  /*  322 */ "STATEMENT",
  /*  323 */ "STRICT",
  /*  324 */ "STRING",
  /*  325 */ "TIMES",
  /*  326 */ "VALUES",
  /*  327 */ "VARIABLE",
  /*  328 */ "VIEW",
  /*  329 */ "WAL",
  /*  330 */ "cmd",
  /*  331 */ "account_options",
  /*  332 */ "alter_account_options",
  /*  333 */ "literal",
  /*  334 */ "alter_account_option",
  /*  335 */ "user_name",
  /*  336 */ "sysinfo_opt",
  /*  337 */ "privileges",
  /*  338 */ "priv_level",
  /*  339 */ "priv_type_list",
  /*  340 */ "priv_type",
  /*  341 */ "db_name",
  /*  342 */ "topic_name",
  /*  343 */ "dnode_endpoint",
  /*  344 */ "force_opt",
  /*  345 */ "not_exists_opt",
  /*  346 */ "db_options",
  /*  347 */ "exists_opt",
  /*  348 */ "alter_db_options",
  /*  349 */ "speed_opt",
  /*  350 */ "start_opt",
  /*  351 */ "end_opt",
  /*  352 */ "integer_list",
  /*  353 */ "variable_list",
  /*  354 */ "retention_list",
  /*  355 */ "alter_db_option",
  /*  356 */ "retention",
  /*  357 */ "full_table_name",
  /*  358 */ "column_def_list",
  /*  359 */ "tags_def_opt",
  /*  360 */ "table_options",
  /*  361 */ "multi_create_clause",
  /*  362 */ "tags_def",
  /*  363 */ "multi_drop_clause",
  /*  364 */ "alter_table_clause",
  /*  365 */ "alter_table_options",
  /*  366 */ "column_name",
  /*  367 */ "type_name",
  /*  368 */ "signed_literal",
  /*  369 */ "create_subtable_clause",
  /*  370 */ "specific_cols_opt",
  /*  371 */ "expression_list",
  /*  372 */ "drop_table_clause",
  /*  373 */ "col_name_list",
  /*  374 */ "table_name",
  /*  375 */ "column_def",
  /*  376 */ "duration_list",
  /*  377 */ "rollup_func_list",
  /*  378 */ "alter_table_option",
  /*  379 */ "duration_literal",
  /*  380 */ "rollup_func_name",
  /*  381 */ "function_name",
  /*  382 */ "col_name",
  /*  383 */ "db_name_cond_opt",
  /*  384 */ "like_pattern_opt",
  /*  385 */ "table_name_cond",
  /*  386 */ "from_db_opt",
  /*  387 */ "tag_list_opt",
  /*  388 */ "tag_item",
  /*  389 */ "column_alias",
  /*  390 */ "full_index_name",
  /*  391 */ "index_options",
  /*  392 */ "index_name",
  /*  393 */ "func_list",
  /*  394 */ "sliding_opt",
  /*  395 */ "sma_stream_opt",
  /*  396 */ "func",
  /*  397 */ "sma_func_name",
  /*  398 */ "query_or_subquery",
  /*  399 */ "cgroup_name",
  /*  400 */ "analyze_opt",
  /*  401 */ "explain_options",
  /*  402 */ "insert_query",
  /*  403 */ "agg_func_opt",
  /*  404 */ "bufsize_opt",
  /*  405 */ "language_opt",
  /*  406 */ "stream_name",
  /*  407 */ "stream_options",
  /*  408 */ "col_list_opt",
  /*  409 */ "tag_def_or_ref_opt",
  /*  410 */ "subtable_opt",
  /*  411 */ "expression",
  /*  412 */ "dnode_list",
  /*  413 */ "where_clause_opt",
  /*  414 */ "signed",
  /*  415 */ "literal_func",
  /*  416 */ "literal_list",
  /*  417 */ "table_alias",
  /*  418 */ "expr_or_subquery",
  /*  419 */ "pseudo_column",
  /*  420 */ "column_reference",
  /*  421 */ "function_expression",
  /*  422 */ "case_when_expression",
  /*  423 */ "star_func",
  /*  424 */ "star_func_para_list",
  /*  425 */ "noarg_func",
  /*  426 */ "other_para_list",
  /*  427 */ "star_func_para",
  /*  428 */ "when_then_list",
  /*  429 */ "case_when_else_opt",
  /*  430 */ "common_expression",
  /*  431 */ "when_then_expr",
  /*  432 */ "predicate",
  /*  433 */ "compare_op",
  /*  434 */ "in_op",
  /*  435 */ "in_predicate_value",
  /*  436 */ "boolean_value_expression",
  /*  437 */ "boolean_primary",
  /*  438 */ "from_clause_opt",
  /*  439 */ "table_reference_list",
  /*  440 */ "table_reference",
  /*  441 */ "table_primary",
  /*  442 */ "joined_table",
  /*  443 */ "alias_opt",
  /*  444 */ "subquery",
  /*  445 */ "parenthesized_joined_table",
  /*  446 */ "join_type",
  /*  447 */ "search_condition",
  /*  448 */ "query_specification",
  /*  449 */ "set_quantifier_opt",
  /*  450 */ "select_list",
  /*  451 */ "partition_by_clause_opt",
  /*  452 */ "range_opt",
  /*  453 */ "every_opt",
  /*  454 */ "fill_opt",
  /*  455 */ "twindow_clause_opt",
  /*  456 */ "group_by_clause_opt",
  /*  457 */ "having_clause_opt",
  /*  458 */ "select_item",
  /*  459 */ "partition_list",
  /*  460 */ "partition_item",
  /*  461 */ "fill_mode",
  /*  462 */ "group_by_list",
  /*  463 */ "query_expression",
  /*  464 */ "query_simple",
  /*  465 */ "order_by_clause_opt",
  /*  466 */ "slimit_clause_opt",
  /*  467 */ "limit_clause_opt",
  /*  468 */ "union_query_expression",
  /*  469 */ "query_simple_or_subquery",
  /*  470 */ "sort_specification_list",
  /*  471 */ "sort_specification",
  /*  472 */ "ordering_specification_opt",
  /*  473 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  73 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  74 */ "not_exists_opt ::=",
 /*  75 */ "exists_opt ::= IF EXISTS",
 /*  76 */ "exists_opt ::=",
 /*  77 */ "db_options ::=",
 /*  78 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  79 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  80 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  81 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  83 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  84 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  86 */ "db_options ::= db_options KEEP integer_list",
 /*  87 */ "db_options ::= db_options KEEP variable_list",
 /*  88 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  89 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  92 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  93 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  94 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  95 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  96 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 107 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 108 */ "alter_db_options ::= alter_db_option",
 /* 109 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 110 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 111 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 112 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 114 */ "alter_db_option ::= KEEP integer_list",
 /* 115 */ "alter_db_option ::= KEEP variable_list",
 /* 116 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 117 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 118 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 119 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 120 */ "alter_db_option ::= MINROWS NK_INTEGER",
 /* 121 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER",
 /* 122 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 123 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER",
 /* 124 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 125 */ "integer_list ::= NK_INTEGER",
 /* 126 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 127 */ "variable_list ::= NK_VARIABLE",
 /* 128 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 129 */ "retention_list ::= retention",
 /* 130 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 131 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 132 */ "speed_opt ::=",
 /* 133 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 134 */ "start_opt ::=",
 /* 135 */ "start_opt ::= START WITH NK_INTEGER",
 /* 136 */ "start_opt ::= START WITH NK_STRING",
 /* 137 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 138 */ "end_opt ::=",
 /* 139 */ "end_opt ::= END WITH NK_INTEGER",
 /* 140 */ "end_opt ::= END WITH NK_STRING",
 /* 141 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 142 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 143 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 144 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 145 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 146 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 147 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 148 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 149 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 150 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 151 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 152 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 153 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 154 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 155 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 156 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 157 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 158 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 159 */ "multi_create_clause ::= create_subtable_clause",
 /* 160 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 161 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 162 */ "multi_drop_clause ::= drop_table_clause",
 /* 163 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 164 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 165 */ "specific_cols_opt ::=",
 /* 166 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 167 */ "full_table_name ::= table_name",
 /* 168 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 169 */ "column_def_list ::= column_def",
 /* 170 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 171 */ "column_def ::= column_name type_name",
 /* 172 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 173 */ "type_name ::= BOOL",
 /* 174 */ "type_name ::= TINYINT",
 /* 175 */ "type_name ::= SMALLINT",
 /* 176 */ "type_name ::= INT",
 /* 177 */ "type_name ::= INTEGER",
 /* 178 */ "type_name ::= BIGINT",
 /* 179 */ "type_name ::= FLOAT",
 /* 180 */ "type_name ::= DOUBLE",
 /* 181 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 182 */ "type_name ::= TIMESTAMP",
 /* 183 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 184 */ "type_name ::= TINYINT UNSIGNED",
 /* 185 */ "type_name ::= SMALLINT UNSIGNED",
 /* 186 */ "type_name ::= INT UNSIGNED",
 /* 187 */ "type_name ::= BIGINT UNSIGNED",
 /* 188 */ "type_name ::= JSON",
 /* 189 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 190 */ "type_name ::= MEDIUMBLOB",
 /* 191 */ "type_name ::= BLOB",
 /* 192 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 193 */ "type_name ::= DECIMAL",
 /* 194 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 195 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 196 */ "tags_def_opt ::=",
 /* 197 */ "tags_def_opt ::= tags_def",
 /* 198 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 199 */ "table_options ::=",
 /* 200 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 201 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 202 */ "table_options ::= table_options WATERMARK duration_list",
 /* 203 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 204 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 205 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 206 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 207 */ "alter_table_options ::= alter_table_option",
 /* 208 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 209 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 210 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 211 */ "duration_list ::= duration_literal",
 /* 212 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 213 */ "rollup_func_list ::= rollup_func_name",
 /* 214 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 215 */ "rollup_func_name ::= function_name",
 /* 216 */ "rollup_func_name ::= FIRST",
 /* 217 */ "rollup_func_name ::= LAST",
 /* 218 */ "col_name_list ::= col_name",
 /* 219 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 220 */ "col_name ::= column_name",
 /* 221 */ "cmd ::= SHOW DNODES",
 /* 222 */ "cmd ::= SHOW USERS",
 /* 223 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 224 */ "cmd ::= SHOW DATABASES",
 /* 225 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 226 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 227 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 228 */ "cmd ::= SHOW MNODES",
 /* 229 */ "cmd ::= SHOW QNODES",
 /* 230 */ "cmd ::= SHOW FUNCTIONS",
 /* 231 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 232 */ "cmd ::= SHOW STREAMS",
 /* 233 */ "cmd ::= SHOW ACCOUNTS",
 /* 234 */ "cmd ::= SHOW APPS",
 /* 235 */ "cmd ::= SHOW CONNECTIONS",
 /* 236 */ "cmd ::= SHOW LICENCES",
 /* 237 */ "cmd ::= SHOW GRANTS",
 /* 238 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 239 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 240 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 241 */ "cmd ::= SHOW QUERIES",
 /* 242 */ "cmd ::= SHOW SCORES",
 /* 243 */ "cmd ::= SHOW TOPICS",
 /* 244 */ "cmd ::= SHOW VARIABLES",
 /* 245 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 246 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 247 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 248 */ "cmd ::= SHOW BNODES",
 /* 249 */ "cmd ::= SHOW SNODES",
 /* 250 */ "cmd ::= SHOW CLUSTER",
 /* 251 */ "cmd ::= SHOW TRANSACTIONS",
 /* 252 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 253 */ "cmd ::= SHOW CONSUMERS",
 /* 254 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 255 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 256 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 257 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 258 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 259 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 260 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 261 */ "db_name_cond_opt ::=",
 /* 262 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 263 */ "like_pattern_opt ::=",
 /* 264 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 265 */ "table_name_cond ::= table_name",
 /* 266 */ "from_db_opt ::=",
 /* 267 */ "from_db_opt ::= FROM db_name",
 /* 268 */ "tag_list_opt ::=",
 /* 269 */ "tag_list_opt ::= tag_item",
 /* 270 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 271 */ "tag_item ::= TBNAME",
 /* 272 */ "tag_item ::= QTAGS",
 /* 273 */ "tag_item ::= column_name",
 /* 274 */ "tag_item ::= column_name column_alias",
 /* 275 */ "tag_item ::= column_name AS column_alias",
 /* 276 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 277 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 278 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 279 */ "full_index_name ::= index_name",
 /* 280 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 281 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 282 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 283 */ "func_list ::= func",
 /* 284 */ "func_list ::= func_list NK_COMMA func",
 /* 285 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 286 */ "sma_func_name ::= function_name",
 /* 287 */ "sma_func_name ::= COUNT",
 /* 288 */ "sma_func_name ::= FIRST",
 /* 289 */ "sma_func_name ::= LAST",
 /* 290 */ "sma_func_name ::= LAST_ROW",
 /* 291 */ "sma_stream_opt ::=",
 /* 292 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 293 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 294 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 295 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 296 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 297 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 298 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 299 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 300 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 301 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 302 */ "cmd ::= DESC full_table_name",
 /* 303 */ "cmd ::= DESCRIBE full_table_name",
 /* 304 */ "cmd ::= RESET QUERY CACHE",
 /* 305 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 306 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 307 */ "analyze_opt ::=",
 /* 308 */ "analyze_opt ::= ANALYZE",
 /* 309 */ "explain_options ::=",
 /* 310 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 311 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 312 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt",
 /* 313 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 314 */ "agg_func_opt ::=",
 /* 315 */ "agg_func_opt ::= AGGREGATE",
 /* 316 */ "bufsize_opt ::=",
 /* 317 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 318 */ "language_opt ::=",
 /* 319 */ "language_opt ::= LANGUAGE NK_STRING",
 /* 320 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 321 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 322 */ "col_list_opt ::=",
 /* 323 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 324 */ "tag_def_or_ref_opt ::=",
 /* 325 */ "tag_def_or_ref_opt ::= tags_def",
 /* 326 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 327 */ "stream_options ::=",
 /* 328 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 329 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 330 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 331 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 332 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 333 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 334 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 335 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 336 */ "subtable_opt ::=",
 /* 337 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 338 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 339 */ "cmd ::= KILL QUERY NK_STRING",
 /* 340 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 341 */ "cmd ::= BALANCE VGROUP",
 /* 342 */ "cmd ::= BALANCE VGROUP LEADER",
 /* 343 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 344 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 345 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 346 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 347 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 348 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 349 */ "cmd ::= query_or_subquery",
 /* 350 */ "cmd ::= insert_query",
 /* 351 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 352 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 353 */ "literal ::= NK_INTEGER",
 /* 354 */ "literal ::= NK_FLOAT",
 /* 355 */ "literal ::= NK_STRING",
 /* 356 */ "literal ::= NK_BOOL",
 /* 357 */ "literal ::= TIMESTAMP NK_STRING",
 /* 358 */ "literal ::= duration_literal",
 /* 359 */ "literal ::= NULL",
 /* 360 */ "literal ::= NK_QUESTION",
 /* 361 */ "duration_literal ::= NK_VARIABLE",
 /* 362 */ "signed ::= NK_INTEGER",
 /* 363 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 364 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 365 */ "signed ::= NK_FLOAT",
 /* 366 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 367 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 368 */ "signed_literal ::= signed",
 /* 369 */ "signed_literal ::= NK_STRING",
 /* 370 */ "signed_literal ::= NK_BOOL",
 /* 371 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 372 */ "signed_literal ::= duration_literal",
 /* 373 */ "signed_literal ::= NULL",
 /* 374 */ "signed_literal ::= literal_func",
 /* 375 */ "signed_literal ::= NK_QUESTION",
 /* 376 */ "literal_list ::= signed_literal",
 /* 377 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 378 */ "db_name ::= NK_ID",
 /* 379 */ "table_name ::= NK_ID",
 /* 380 */ "column_name ::= NK_ID",
 /* 381 */ "function_name ::= NK_ID",
 /* 382 */ "table_alias ::= NK_ID",
 /* 383 */ "column_alias ::= NK_ID",
 /* 384 */ "user_name ::= NK_ID",
 /* 385 */ "topic_name ::= NK_ID",
 /* 386 */ "stream_name ::= NK_ID",
 /* 387 */ "cgroup_name ::= NK_ID",
 /* 388 */ "index_name ::= NK_ID",
 /* 389 */ "expr_or_subquery ::= expression",
 /* 390 */ "expression ::= literal",
 /* 391 */ "expression ::= pseudo_column",
 /* 392 */ "expression ::= column_reference",
 /* 393 */ "expression ::= function_expression",
 /* 394 */ "expression ::= case_when_expression",
 /* 395 */ "expression ::= NK_LP expression NK_RP",
 /* 396 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 397 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 398 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 399 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 400 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 401 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 402 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 403 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 404 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 405 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 406 */ "expression_list ::= expr_or_subquery",
 /* 407 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 408 */ "column_reference ::= column_name",
 /* 409 */ "column_reference ::= table_name NK_DOT column_name",
 /* 410 */ "pseudo_column ::= ROWTS",
 /* 411 */ "pseudo_column ::= TBNAME",
 /* 412 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 413 */ "pseudo_column ::= QSTART",
 /* 414 */ "pseudo_column ::= QEND",
 /* 415 */ "pseudo_column ::= QDURATION",
 /* 416 */ "pseudo_column ::= WSTART",
 /* 417 */ "pseudo_column ::= WEND",
 /* 418 */ "pseudo_column ::= WDURATION",
 /* 419 */ "pseudo_column ::= IROWTS",
 /* 420 */ "pseudo_column ::= ISFILLED",
 /* 421 */ "pseudo_column ::= QTAGS",
 /* 422 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 423 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 424 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 425 */ "function_expression ::= literal_func",
 /* 426 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 427 */ "literal_func ::= NOW",
 /* 428 */ "noarg_func ::= NOW",
 /* 429 */ "noarg_func ::= TODAY",
 /* 430 */ "noarg_func ::= TIMEZONE",
 /* 431 */ "noarg_func ::= DATABASE",
 /* 432 */ "noarg_func ::= CLIENT_VERSION",
 /* 433 */ "noarg_func ::= SERVER_VERSION",
 /* 434 */ "noarg_func ::= SERVER_STATUS",
 /* 435 */ "noarg_func ::= CURRENT_USER",
 /* 436 */ "noarg_func ::= USER",
 /* 437 */ "star_func ::= COUNT",
 /* 438 */ "star_func ::= FIRST",
 /* 439 */ "star_func ::= LAST",
 /* 440 */ "star_func ::= LAST_ROW",
 /* 441 */ "star_func_para_list ::= NK_STAR",
 /* 442 */ "star_func_para_list ::= other_para_list",
 /* 443 */ "other_para_list ::= star_func_para",
 /* 444 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 445 */ "star_func_para ::= expr_or_subquery",
 /* 446 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 447 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 448 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 449 */ "when_then_list ::= when_then_expr",
 /* 450 */ "when_then_list ::= when_then_list when_then_expr",
 /* 451 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 452 */ "case_when_else_opt ::=",
 /* 453 */ "case_when_else_opt ::= ELSE common_expression",
 /* 454 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 455 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 456 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 457 */ "predicate ::= expr_or_subquery IS NULL",
 /* 458 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 459 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 460 */ "compare_op ::= NK_LT",
 /* 461 */ "compare_op ::= NK_GT",
 /* 462 */ "compare_op ::= NK_LE",
 /* 463 */ "compare_op ::= NK_GE",
 /* 464 */ "compare_op ::= NK_NE",
 /* 465 */ "compare_op ::= NK_EQ",
 /* 466 */ "compare_op ::= LIKE",
 /* 467 */ "compare_op ::= NOT LIKE",
 /* 468 */ "compare_op ::= MATCH",
 /* 469 */ "compare_op ::= NMATCH",
 /* 470 */ "compare_op ::= CONTAINS",
 /* 471 */ "in_op ::= IN",
 /* 472 */ "in_op ::= NOT IN",
 /* 473 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 474 */ "boolean_value_expression ::= boolean_primary",
 /* 475 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 476 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 477 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 478 */ "boolean_primary ::= predicate",
 /* 479 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 480 */ "common_expression ::= expr_or_subquery",
 /* 481 */ "common_expression ::= boolean_value_expression",
 /* 482 */ "from_clause_opt ::=",
 /* 483 */ "from_clause_opt ::= FROM table_reference_list",
 /* 484 */ "table_reference_list ::= table_reference",
 /* 485 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 486 */ "table_reference ::= table_primary",
 /* 487 */ "table_reference ::= joined_table",
 /* 488 */ "table_primary ::= table_name alias_opt",
 /* 489 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 490 */ "table_primary ::= subquery alias_opt",
 /* 491 */ "table_primary ::= parenthesized_joined_table",
 /* 492 */ "alias_opt ::=",
 /* 493 */ "alias_opt ::= table_alias",
 /* 494 */ "alias_opt ::= AS table_alias",
 /* 495 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 496 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 497 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 498 */ "join_type ::=",
 /* 499 */ "join_type ::= INNER",
 /* 500 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 501 */ "set_quantifier_opt ::=",
 /* 502 */ "set_quantifier_opt ::= DISTINCT",
 /* 503 */ "set_quantifier_opt ::= ALL",
 /* 504 */ "select_list ::= select_item",
 /* 505 */ "select_list ::= select_list NK_COMMA select_item",
 /* 506 */ "select_item ::= NK_STAR",
 /* 507 */ "select_item ::= common_expression",
 /* 508 */ "select_item ::= common_expression column_alias",
 /* 509 */ "select_item ::= common_expression AS column_alias",
 /* 510 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 511 */ "where_clause_opt ::=",
 /* 512 */ "where_clause_opt ::= WHERE search_condition",
 /* 513 */ "partition_by_clause_opt ::=",
 /* 514 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 515 */ "partition_list ::= partition_item",
 /* 516 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 517 */ "partition_item ::= expr_or_subquery",
 /* 518 */ "partition_item ::= expr_or_subquery column_alias",
 /* 519 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 520 */ "twindow_clause_opt ::=",
 /* 521 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 522 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 523 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 524 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 525 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 526 */ "sliding_opt ::=",
 /* 527 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 528 */ "fill_opt ::=",
 /* 529 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 530 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 531 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP",
 /* 532 */ "fill_mode ::= NONE",
 /* 533 */ "fill_mode ::= PREV",
 /* 534 */ "fill_mode ::= NULL",
 /* 535 */ "fill_mode ::= NULL_F",
 /* 536 */ "fill_mode ::= LINEAR",
 /* 537 */ "fill_mode ::= NEXT",
 /* 538 */ "group_by_clause_opt ::=",
 /* 539 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 540 */ "group_by_list ::= expr_or_subquery",
 /* 541 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 542 */ "having_clause_opt ::=",
 /* 543 */ "having_clause_opt ::= HAVING search_condition",
 /* 544 */ "range_opt ::=",
 /* 545 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 546 */ "every_opt ::=",
 /* 547 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 548 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 549 */ "query_simple ::= query_specification",
 /* 550 */ "query_simple ::= union_query_expression",
 /* 551 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 552 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 553 */ "query_simple_or_subquery ::= query_simple",
 /* 554 */ "query_simple_or_subquery ::= subquery",
 /* 555 */ "query_or_subquery ::= query_expression",
 /* 556 */ "query_or_subquery ::= subquery",
 /* 557 */ "order_by_clause_opt ::=",
 /* 558 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 559 */ "slimit_clause_opt ::=",
 /* 560 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 561 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 562 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 563 */ "limit_clause_opt ::=",
 /* 564 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 565 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 566 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 567 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 568 */ "subquery ::= NK_LP subquery NK_RP",
 /* 569 */ "search_condition ::= common_expression",
 /* 570 */ "sort_specification_list ::= sort_specification",
 /* 571 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 572 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 573 */ "ordering_specification_opt ::=",
 /* 574 */ "ordering_specification_opt ::= ASC",
 /* 575 */ "ordering_specification_opt ::= DESC",
 /* 576 */ "null_ordering_opt ::=",
 /* 577 */ "null_ordering_opt ::= NULLS FIRST",
 /* 578 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 330: /* cmd */
    case 333: /* literal */
    case 346: /* db_options */
    case 348: /* alter_db_options */
    case 350: /* start_opt */
    case 351: /* end_opt */
    case 356: /* retention */
    case 357: /* full_table_name */
    case 360: /* table_options */
    case 364: /* alter_table_clause */
    case 365: /* alter_table_options */
    case 368: /* signed_literal */
    case 369: /* create_subtable_clause */
    case 372: /* drop_table_clause */
    case 375: /* column_def */
    case 379: /* duration_literal */
    case 380: /* rollup_func_name */
    case 382: /* col_name */
    case 383: /* db_name_cond_opt */
    case 384: /* like_pattern_opt */
    case 385: /* table_name_cond */
    case 386: /* from_db_opt */
    case 388: /* tag_item */
    case 390: /* full_index_name */
    case 391: /* index_options */
    case 394: /* sliding_opt */
    case 395: /* sma_stream_opt */
    case 396: /* func */
    case 398: /* query_or_subquery */
    case 401: /* explain_options */
    case 402: /* insert_query */
    case 407: /* stream_options */
    case 410: /* subtable_opt */
    case 411: /* expression */
    case 413: /* where_clause_opt */
    case 414: /* signed */
    case 415: /* literal_func */
    case 418: /* expr_or_subquery */
    case 419: /* pseudo_column */
    case 420: /* column_reference */
    case 421: /* function_expression */
    case 422: /* case_when_expression */
    case 427: /* star_func_para */
    case 429: /* case_when_else_opt */
    case 430: /* common_expression */
    case 431: /* when_then_expr */
    case 432: /* predicate */
    case 435: /* in_predicate_value */
    case 436: /* boolean_value_expression */
    case 437: /* boolean_primary */
    case 438: /* from_clause_opt */
    case 439: /* table_reference_list */
    case 440: /* table_reference */
    case 441: /* table_primary */
    case 442: /* joined_table */
    case 444: /* subquery */
    case 445: /* parenthesized_joined_table */
    case 447: /* search_condition */
    case 448: /* query_specification */
    case 452: /* range_opt */
    case 453: /* every_opt */
    case 454: /* fill_opt */
    case 455: /* twindow_clause_opt */
    case 457: /* having_clause_opt */
    case 458: /* select_item */
    case 460: /* partition_item */
    case 463: /* query_expression */
    case 464: /* query_simple */
    case 466: /* slimit_clause_opt */
    case 467: /* limit_clause_opt */
    case 468: /* union_query_expression */
    case 469: /* query_simple_or_subquery */
    case 471: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy188)); 
}
      break;
    case 331: /* account_options */
    case 332: /* alter_account_options */
    case 334: /* alter_account_option */
    case 349: /* speed_opt */
    case 404: /* bufsize_opt */
{
 
}
      break;
    case 335: /* user_name */
    case 338: /* priv_level */
    case 341: /* db_name */
    case 342: /* topic_name */
    case 343: /* dnode_endpoint */
    case 366: /* column_name */
    case 374: /* table_name */
    case 381: /* function_name */
    case 389: /* column_alias */
    case 392: /* index_name */
    case 397: /* sma_func_name */
    case 399: /* cgroup_name */
    case 405: /* language_opt */
    case 406: /* stream_name */
    case 417: /* table_alias */
    case 423: /* star_func */
    case 425: /* noarg_func */
    case 443: /* alias_opt */
{
 
}
      break;
    case 336: /* sysinfo_opt */
{
 
}
      break;
    case 337: /* privileges */
    case 339: /* priv_type_list */
    case 340: /* priv_type */
{
 
}
      break;
    case 344: /* force_opt */
    case 345: /* not_exists_opt */
    case 347: /* exists_opt */
    case 400: /* analyze_opt */
    case 403: /* agg_func_opt */
    case 449: /* set_quantifier_opt */
{
 
}
      break;
    case 352: /* integer_list */
    case 353: /* variable_list */
    case 354: /* retention_list */
    case 358: /* column_def_list */
    case 359: /* tags_def_opt */
    case 361: /* multi_create_clause */
    case 362: /* tags_def */
    case 363: /* multi_drop_clause */
    case 370: /* specific_cols_opt */
    case 371: /* expression_list */
    case 373: /* col_name_list */
    case 376: /* duration_list */
    case 377: /* rollup_func_list */
    case 387: /* tag_list_opt */
    case 393: /* func_list */
    case 408: /* col_list_opt */
    case 409: /* tag_def_or_ref_opt */
    case 412: /* dnode_list */
    case 416: /* literal_list */
    case 424: /* star_func_para_list */
    case 426: /* other_para_list */
    case 428: /* when_then_list */
    case 450: /* select_list */
    case 451: /* partition_by_clause_opt */
    case 456: /* group_by_clause_opt */
    case 459: /* partition_list */
    case 462: /* group_by_list */
    case 465: /* order_by_clause_opt */
    case 470: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy172)); 
}
      break;
    case 355: /* alter_db_option */
    case 378: /* alter_table_option */
{
 
}
      break;
    case 367: /* type_name */
{
 
}
      break;
    case 433: /* compare_op */
    case 434: /* in_op */
{
 
}
      break;
    case 446: /* join_type */
{
 
}
      break;
    case 461: /* fill_mode */
{
 
}
      break;
    case 472: /* ordering_specification_opt */
{
 
}
      break;
    case 473: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  330,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  330,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  331,    0 }, /* (2) account_options ::= */
  {  331,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  331,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  331,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  331,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  331,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  331,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  331,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  331,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  331,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  332,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  332,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  334,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  334,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  334,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  334,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  334,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  334,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  334,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  334,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  334,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  334,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  330,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  330,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  330,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  330,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  330,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  336,    0 }, /* (29) sysinfo_opt ::= */
  {  336,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  330,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  330,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  337,   -1 }, /* (33) privileges ::= ALL */
  {  337,   -1 }, /* (34) privileges ::= priv_type_list */
  {  337,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  339,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  339,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  340,   -1 }, /* (38) priv_type ::= READ */
  {  340,   -1 }, /* (39) priv_type ::= WRITE */
  {  338,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  338,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  338,   -1 }, /* (42) priv_level ::= topic_name */
  {  330,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  330,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  330,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  330,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  330,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  330,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  330,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  330,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  343,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  343,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  343,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  344,    0 }, /* (54) force_opt ::= */
  {  344,   -1 }, /* (55) force_opt ::= FORCE */
  {  330,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  330,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  330,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  330,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  330,   -2 }, /* (68) cmd ::= USE db_name */
  {  330,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  330,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  330,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  330,   -5 }, /* (72) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
  {  345,   -3 }, /* (73) not_exists_opt ::= IF NOT EXISTS */
  {  345,    0 }, /* (74) not_exists_opt ::= */
  {  347,   -2 }, /* (75) exists_opt ::= IF EXISTS */
  {  347,    0 }, /* (76) exists_opt ::= */
  {  346,    0 }, /* (77) db_options ::= */
  {  346,   -3 }, /* (78) db_options ::= db_options BUFFER NK_INTEGER */
  {  346,   -3 }, /* (79) db_options ::= db_options CACHEMODEL NK_STRING */
  {  346,   -3 }, /* (80) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  346,   -3 }, /* (81) db_options ::= db_options COMP NK_INTEGER */
  {  346,   -3 }, /* (82) db_options ::= db_options DURATION NK_INTEGER */
  {  346,   -3 }, /* (83) db_options ::= db_options DURATION NK_VARIABLE */
  {  346,   -3 }, /* (84) db_options ::= db_options MAXROWS NK_INTEGER */
  {  346,   -3 }, /* (85) db_options ::= db_options MINROWS NK_INTEGER */
  {  346,   -3 }, /* (86) db_options ::= db_options KEEP integer_list */
  {  346,   -3 }, /* (87) db_options ::= db_options KEEP variable_list */
  {  346,   -3 }, /* (88) db_options ::= db_options PAGES NK_INTEGER */
  {  346,   -3 }, /* (89) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  346,   -3 }, /* (90) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  346,   -3 }, /* (91) db_options ::= db_options PRECISION NK_STRING */
  {  346,   -3 }, /* (92) db_options ::= db_options REPLICA NK_INTEGER */
  {  346,   -3 }, /* (93) db_options ::= db_options VGROUPS NK_INTEGER */
  {  346,   -3 }, /* (94) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  346,   -3 }, /* (95) db_options ::= db_options RETENTIONS retention_list */
  {  346,   -3 }, /* (96) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  346,   -3 }, /* (97) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  346,   -3 }, /* (98) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  346,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  346,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  346,   -3 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  346,   -4 }, /* (102) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  346,   -3 }, /* (103) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  346,   -3 }, /* (104) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  346,   -3 }, /* (105) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  346,   -3 }, /* (106) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  346,   -3 }, /* (107) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  348,   -1 }, /* (108) alter_db_options ::= alter_db_option */
  {  348,   -2 }, /* (109) alter_db_options ::= alter_db_options alter_db_option */
  {  355,   -2 }, /* (110) alter_db_option ::= BUFFER NK_INTEGER */
  {  355,   -2 }, /* (111) alter_db_option ::= CACHEMODEL NK_STRING */
  {  355,   -2 }, /* (112) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  355,   -2 }, /* (113) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  355,   -2 }, /* (114) alter_db_option ::= KEEP integer_list */
  {  355,   -2 }, /* (115) alter_db_option ::= KEEP variable_list */
  {  355,   -2 }, /* (116) alter_db_option ::= PAGES NK_INTEGER */
  {  355,   -2 }, /* (117) alter_db_option ::= REPLICA NK_INTEGER */
  {  355,   -2 }, /* (118) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  355,   -2 }, /* (119) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  355,   -2 }, /* (120) alter_db_option ::= MINROWS NK_INTEGER */
  {  355,   -2 }, /* (121) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
  {  355,   -3 }, /* (122) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  355,   -2 }, /* (123) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
  {  355,   -3 }, /* (124) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  352,   -1 }, /* (125) integer_list ::= NK_INTEGER */
  {  352,   -3 }, /* (126) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  353,   -1 }, /* (127) variable_list ::= NK_VARIABLE */
  {  353,   -3 }, /* (128) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  354,   -1 }, /* (129) retention_list ::= retention */
  {  354,   -3 }, /* (130) retention_list ::= retention_list NK_COMMA retention */
  {  356,   -3 }, /* (131) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  349,    0 }, /* (132) speed_opt ::= */
  {  349,   -2 }, /* (133) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  350,    0 }, /* (134) start_opt ::= */
  {  350,   -3 }, /* (135) start_opt ::= START WITH NK_INTEGER */
  {  350,   -3 }, /* (136) start_opt ::= START WITH NK_STRING */
  {  350,   -4 }, /* (137) start_opt ::= START WITH TIMESTAMP NK_STRING */
  {  351,    0 }, /* (138) end_opt ::= */
  {  351,   -3 }, /* (139) end_opt ::= END WITH NK_INTEGER */
  {  351,   -3 }, /* (140) end_opt ::= END WITH NK_STRING */
  {  351,   -4 }, /* (141) end_opt ::= END WITH TIMESTAMP NK_STRING */
  {  330,   -9 }, /* (142) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  330,   -3 }, /* (143) cmd ::= CREATE TABLE multi_create_clause */
  {  330,   -9 }, /* (144) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  330,   -3 }, /* (145) cmd ::= DROP TABLE multi_drop_clause */
  {  330,   -4 }, /* (146) cmd ::= DROP STABLE exists_opt full_table_name */
  {  330,   -3 }, /* (147) cmd ::= ALTER TABLE alter_table_clause */
  {  330,   -3 }, /* (148) cmd ::= ALTER STABLE alter_table_clause */
  {  364,   -2 }, /* (149) alter_table_clause ::= full_table_name alter_table_options */
  {  364,   -5 }, /* (150) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  364,   -4 }, /* (151) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  364,   -5 }, /* (152) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  364,   -5 }, /* (153) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  364,   -5 }, /* (154) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  364,   -4 }, /* (155) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  364,   -5 }, /* (156) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  364,   -5 }, /* (157) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  364,   -6 }, /* (158) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  361,   -1 }, /* (159) multi_create_clause ::= create_subtable_clause */
  {  361,   -2 }, /* (160) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  369,  -10 }, /* (161) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  363,   -1 }, /* (162) multi_drop_clause ::= drop_table_clause */
  {  363,   -3 }, /* (163) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
  {  372,   -2 }, /* (164) drop_table_clause ::= exists_opt full_table_name */
  {  370,    0 }, /* (165) specific_cols_opt ::= */
  {  370,   -3 }, /* (166) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  357,   -1 }, /* (167) full_table_name ::= table_name */
  {  357,   -3 }, /* (168) full_table_name ::= db_name NK_DOT table_name */
  {  358,   -1 }, /* (169) column_def_list ::= column_def */
  {  358,   -3 }, /* (170) column_def_list ::= column_def_list NK_COMMA column_def */
  {  375,   -2 }, /* (171) column_def ::= column_name type_name */
  {  375,   -4 }, /* (172) column_def ::= column_name type_name COMMENT NK_STRING */
  {  367,   -1 }, /* (173) type_name ::= BOOL */
  {  367,   -1 }, /* (174) type_name ::= TINYINT */
  {  367,   -1 }, /* (175) type_name ::= SMALLINT */
  {  367,   -1 }, /* (176) type_name ::= INT */
  {  367,   -1 }, /* (177) type_name ::= INTEGER */
  {  367,   -1 }, /* (178) type_name ::= BIGINT */
  {  367,   -1 }, /* (179) type_name ::= FLOAT */
  {  367,   -1 }, /* (180) type_name ::= DOUBLE */
  {  367,   -4 }, /* (181) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  367,   -1 }, /* (182) type_name ::= TIMESTAMP */
  {  367,   -4 }, /* (183) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  367,   -2 }, /* (184) type_name ::= TINYINT UNSIGNED */
  {  367,   -2 }, /* (185) type_name ::= SMALLINT UNSIGNED */
  {  367,   -2 }, /* (186) type_name ::= INT UNSIGNED */
  {  367,   -2 }, /* (187) type_name ::= BIGINT UNSIGNED */
  {  367,   -1 }, /* (188) type_name ::= JSON */
  {  367,   -4 }, /* (189) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  367,   -1 }, /* (190) type_name ::= MEDIUMBLOB */
  {  367,   -1 }, /* (191) type_name ::= BLOB */
  {  367,   -4 }, /* (192) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  367,   -1 }, /* (193) type_name ::= DECIMAL */
  {  367,   -4 }, /* (194) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  367,   -6 }, /* (195) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  359,    0 }, /* (196) tags_def_opt ::= */
  {  359,   -1 }, /* (197) tags_def_opt ::= tags_def */
  {  362,   -4 }, /* (198) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  360,    0 }, /* (199) table_options ::= */
  {  360,   -3 }, /* (200) table_options ::= table_options COMMENT NK_STRING */
  {  360,   -3 }, /* (201) table_options ::= table_options MAX_DELAY duration_list */
  {  360,   -3 }, /* (202) table_options ::= table_options WATERMARK duration_list */
  {  360,   -5 }, /* (203) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  360,   -3 }, /* (204) table_options ::= table_options TTL NK_INTEGER */
  {  360,   -5 }, /* (205) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  360,   -3 }, /* (206) table_options ::= table_options DELETE_MARK duration_list */
  {  365,   -1 }, /* (207) alter_table_options ::= alter_table_option */
  {  365,   -2 }, /* (208) alter_table_options ::= alter_table_options alter_table_option */
  {  378,   -2 }, /* (209) alter_table_option ::= COMMENT NK_STRING */
  {  378,   -2 }, /* (210) alter_table_option ::= TTL NK_INTEGER */
  {  376,   -1 }, /* (211) duration_list ::= duration_literal */
  {  376,   -3 }, /* (212) duration_list ::= duration_list NK_COMMA duration_literal */
  {  377,   -1 }, /* (213) rollup_func_list ::= rollup_func_name */
  {  377,   -3 }, /* (214) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  380,   -1 }, /* (215) rollup_func_name ::= function_name */
  {  380,   -1 }, /* (216) rollup_func_name ::= FIRST */
  {  380,   -1 }, /* (217) rollup_func_name ::= LAST */
  {  373,   -1 }, /* (218) col_name_list ::= col_name */
  {  373,   -3 }, /* (219) col_name_list ::= col_name_list NK_COMMA col_name */
  {  382,   -1 }, /* (220) col_name ::= column_name */
  {  330,   -2 }, /* (221) cmd ::= SHOW DNODES */
  {  330,   -2 }, /* (222) cmd ::= SHOW USERS */
  {  330,   -3 }, /* (223) cmd ::= SHOW USER PRIVILEGES */
  {  330,   -2 }, /* (224) cmd ::= SHOW DATABASES */
  {  330,   -4 }, /* (225) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  330,   -4 }, /* (226) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  330,   -3 }, /* (227) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  330,   -2 }, /* (228) cmd ::= SHOW MNODES */
  {  330,   -2 }, /* (229) cmd ::= SHOW QNODES */
  {  330,   -2 }, /* (230) cmd ::= SHOW FUNCTIONS */
  {  330,   -5 }, /* (231) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  330,   -2 }, /* (232) cmd ::= SHOW STREAMS */
  {  330,   -2 }, /* (233) cmd ::= SHOW ACCOUNTS */
  {  330,   -2 }, /* (234) cmd ::= SHOW APPS */
  {  330,   -2 }, /* (235) cmd ::= SHOW CONNECTIONS */
  {  330,   -2 }, /* (236) cmd ::= SHOW LICENCES */
  {  330,   -2 }, /* (237) cmd ::= SHOW GRANTS */
  {  330,   -4 }, /* (238) cmd ::= SHOW CREATE DATABASE db_name */
  {  330,   -4 }, /* (239) cmd ::= SHOW CREATE TABLE full_table_name */
  {  330,   -4 }, /* (240) cmd ::= SHOW CREATE STABLE full_table_name */
  {  330,   -2 }, /* (241) cmd ::= SHOW QUERIES */
  {  330,   -2 }, /* (242) cmd ::= SHOW SCORES */
  {  330,   -2 }, /* (243) cmd ::= SHOW TOPICS */
  {  330,   -2 }, /* (244) cmd ::= SHOW VARIABLES */
  {  330,   -3 }, /* (245) cmd ::= SHOW CLUSTER VARIABLES */
  {  330,   -3 }, /* (246) cmd ::= SHOW LOCAL VARIABLES */
  {  330,   -5 }, /* (247) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  330,   -2 }, /* (248) cmd ::= SHOW BNODES */
  {  330,   -2 }, /* (249) cmd ::= SHOW SNODES */
  {  330,   -2 }, /* (250) cmd ::= SHOW CLUSTER */
  {  330,   -2 }, /* (251) cmd ::= SHOW TRANSACTIONS */
  {  330,   -4 }, /* (252) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  330,   -2 }, /* (253) cmd ::= SHOW CONSUMERS */
  {  330,   -2 }, /* (254) cmd ::= SHOW SUBSCRIPTIONS */
  {  330,   -5 }, /* (255) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  330,   -7 }, /* (256) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  330,   -3 }, /* (257) cmd ::= SHOW VNODES NK_INTEGER */
  {  330,   -3 }, /* (258) cmd ::= SHOW VNODES NK_STRING */
  {  330,   -3 }, /* (259) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  330,   -3 }, /* (260) cmd ::= SHOW CLUSTER ALIVE */
  {  383,    0 }, /* (261) db_name_cond_opt ::= */
  {  383,   -2 }, /* (262) db_name_cond_opt ::= db_name NK_DOT */
  {  384,    0 }, /* (263) like_pattern_opt ::= */
  {  384,   -2 }, /* (264) like_pattern_opt ::= LIKE NK_STRING */
  {  385,   -1 }, /* (265) table_name_cond ::= table_name */
  {  386,    0 }, /* (266) from_db_opt ::= */
  {  386,   -2 }, /* (267) from_db_opt ::= FROM db_name */
  {  387,    0 }, /* (268) tag_list_opt ::= */
  {  387,   -1 }, /* (269) tag_list_opt ::= tag_item */
  {  387,   -3 }, /* (270) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  388,   -1 }, /* (271) tag_item ::= TBNAME */
  {  388,   -1 }, /* (272) tag_item ::= QTAGS */
  {  388,   -1 }, /* (273) tag_item ::= column_name */
  {  388,   -2 }, /* (274) tag_item ::= column_name column_alias */
  {  388,   -3 }, /* (275) tag_item ::= column_name AS column_alias */
  {  330,   -8 }, /* (276) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  330,   -9 }, /* (277) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  330,   -4 }, /* (278) cmd ::= DROP INDEX exists_opt full_index_name */
  {  390,   -1 }, /* (279) full_index_name ::= index_name */
  {  390,   -3 }, /* (280) full_index_name ::= db_name NK_DOT index_name */
  {  391,  -10 }, /* (281) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  391,  -12 }, /* (282) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  393,   -1 }, /* (283) func_list ::= func */
  {  393,   -3 }, /* (284) func_list ::= func_list NK_COMMA func */
  {  396,   -4 }, /* (285) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  397,   -1 }, /* (286) sma_func_name ::= function_name */
  {  397,   -1 }, /* (287) sma_func_name ::= COUNT */
  {  397,   -1 }, /* (288) sma_func_name ::= FIRST */
  {  397,   -1 }, /* (289) sma_func_name ::= LAST */
  {  397,   -1 }, /* (290) sma_func_name ::= LAST_ROW */
  {  395,    0 }, /* (291) sma_stream_opt ::= */
  {  395,   -3 }, /* (292) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  395,   -3 }, /* (293) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  395,   -3 }, /* (294) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  330,   -6 }, /* (295) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  330,   -7 }, /* (296) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  330,   -9 }, /* (297) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  330,   -7 }, /* (298) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  330,   -9 }, /* (299) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  330,   -4 }, /* (300) cmd ::= DROP TOPIC exists_opt topic_name */
  {  330,   -7 }, /* (301) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  330,   -2 }, /* (302) cmd ::= DESC full_table_name */
  {  330,   -2 }, /* (303) cmd ::= DESCRIBE full_table_name */
  {  330,   -3 }, /* (304) cmd ::= RESET QUERY CACHE */
  {  330,   -4 }, /* (305) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  330,   -4 }, /* (306) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
  {  400,    0 }, /* (307) analyze_opt ::= */
  {  400,   -1 }, /* (308) analyze_opt ::= ANALYZE */
  {  401,    0 }, /* (309) explain_options ::= */
  {  401,   -3 }, /* (310) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  401,   -3 }, /* (311) explain_options ::= explain_options RATIO NK_FLOAT */
  {  330,  -11 }, /* (312) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
  {  330,   -4 }, /* (313) cmd ::= DROP FUNCTION exists_opt function_name */
  {  403,    0 }, /* (314) agg_func_opt ::= */
  {  403,   -1 }, /* (315) agg_func_opt ::= AGGREGATE */
  {  404,    0 }, /* (316) bufsize_opt ::= */
  {  404,   -2 }, /* (317) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  405,    0 }, /* (318) language_opt ::= */
  {  405,   -2 }, /* (319) language_opt ::= LANGUAGE NK_STRING */
  {  330,  -12 }, /* (320) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  330,   -4 }, /* (321) cmd ::= DROP STREAM exists_opt stream_name */
  {  408,    0 }, /* (322) col_list_opt ::= */
  {  408,   -3 }, /* (323) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  409,    0 }, /* (324) tag_def_or_ref_opt ::= */
  {  409,   -1 }, /* (325) tag_def_or_ref_opt ::= tags_def */
  {  409,   -4 }, /* (326) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  407,    0 }, /* (327) stream_options ::= */
  {  407,   -3 }, /* (328) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  407,   -3 }, /* (329) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  407,   -4 }, /* (330) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  407,   -3 }, /* (331) stream_options ::= stream_options WATERMARK duration_literal */
  {  407,   -4 }, /* (332) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  407,   -3 }, /* (333) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  407,   -3 }, /* (334) stream_options ::= stream_options DELETE_MARK duration_literal */
  {  407,   -4 }, /* (335) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
  {  410,    0 }, /* (336) subtable_opt ::= */
  {  410,   -4 }, /* (337) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  330,   -3 }, /* (338) cmd ::= KILL CONNECTION NK_INTEGER */
  {  330,   -3 }, /* (339) cmd ::= KILL QUERY NK_STRING */
  {  330,   -3 }, /* (340) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  330,   -2 }, /* (341) cmd ::= BALANCE VGROUP */
  {  330,   -3 }, /* (342) cmd ::= BALANCE VGROUP LEADER */
  {  330,   -4 }, /* (343) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  330,   -4 }, /* (344) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  330,   -3 }, /* (345) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  412,   -2 }, /* (346) dnode_list ::= DNODE NK_INTEGER */
  {  412,   -3 }, /* (347) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  330,   -4 }, /* (348) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  330,   -1 }, /* (349) cmd ::= query_or_subquery */
  {  330,   -1 }, /* (350) cmd ::= insert_query */
  {  402,   -7 }, /* (351) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  402,   -4 }, /* (352) insert_query ::= INSERT INTO full_table_name query_or_subquery */
  {  333,   -1 }, /* (353) literal ::= NK_INTEGER */
  {  333,   -1 }, /* (354) literal ::= NK_FLOAT */
  {  333,   -1 }, /* (355) literal ::= NK_STRING */
  {  333,   -1 }, /* (356) literal ::= NK_BOOL */
  {  333,   -2 }, /* (357) literal ::= TIMESTAMP NK_STRING */
  {  333,   -1 }, /* (358) literal ::= duration_literal */
  {  333,   -1 }, /* (359) literal ::= NULL */
  {  333,   -1 }, /* (360) literal ::= NK_QUESTION */
  {  379,   -1 }, /* (361) duration_literal ::= NK_VARIABLE */
  {  414,   -1 }, /* (362) signed ::= NK_INTEGER */
  {  414,   -2 }, /* (363) signed ::= NK_PLUS NK_INTEGER */
  {  414,   -2 }, /* (364) signed ::= NK_MINUS NK_INTEGER */
  {  414,   -1 }, /* (365) signed ::= NK_FLOAT */
  {  414,   -2 }, /* (366) signed ::= NK_PLUS NK_FLOAT */
  {  414,   -2 }, /* (367) signed ::= NK_MINUS NK_FLOAT */
  {  368,   -1 }, /* (368) signed_literal ::= signed */
  {  368,   -1 }, /* (369) signed_literal ::= NK_STRING */
  {  368,   -1 }, /* (370) signed_literal ::= NK_BOOL */
  {  368,   -2 }, /* (371) signed_literal ::= TIMESTAMP NK_STRING */
  {  368,   -1 }, /* (372) signed_literal ::= duration_literal */
  {  368,   -1 }, /* (373) signed_literal ::= NULL */
  {  368,   -1 }, /* (374) signed_literal ::= literal_func */
  {  368,   -1 }, /* (375) signed_literal ::= NK_QUESTION */
  {  416,   -1 }, /* (376) literal_list ::= signed_literal */
  {  416,   -3 }, /* (377) literal_list ::= literal_list NK_COMMA signed_literal */
  {  341,   -1 }, /* (378) db_name ::= NK_ID */
  {  374,   -1 }, /* (379) table_name ::= NK_ID */
  {  366,   -1 }, /* (380) column_name ::= NK_ID */
  {  381,   -1 }, /* (381) function_name ::= NK_ID */
  {  417,   -1 }, /* (382) table_alias ::= NK_ID */
  {  389,   -1 }, /* (383) column_alias ::= NK_ID */
  {  335,   -1 }, /* (384) user_name ::= NK_ID */
  {  342,   -1 }, /* (385) topic_name ::= NK_ID */
  {  406,   -1 }, /* (386) stream_name ::= NK_ID */
  {  399,   -1 }, /* (387) cgroup_name ::= NK_ID */
  {  392,   -1 }, /* (388) index_name ::= NK_ID */
  {  418,   -1 }, /* (389) expr_or_subquery ::= expression */
  {  411,   -1 }, /* (390) expression ::= literal */
  {  411,   -1 }, /* (391) expression ::= pseudo_column */
  {  411,   -1 }, /* (392) expression ::= column_reference */
  {  411,   -1 }, /* (393) expression ::= function_expression */
  {  411,   -1 }, /* (394) expression ::= case_when_expression */
  {  411,   -3 }, /* (395) expression ::= NK_LP expression NK_RP */
  {  411,   -2 }, /* (396) expression ::= NK_PLUS expr_or_subquery */
  {  411,   -2 }, /* (397) expression ::= NK_MINUS expr_or_subquery */
  {  411,   -3 }, /* (398) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  411,   -3 }, /* (399) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  411,   -3 }, /* (400) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  411,   -3 }, /* (401) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  411,   -3 }, /* (402) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  411,   -3 }, /* (403) expression ::= column_reference NK_ARROW NK_STRING */
  {  411,   -3 }, /* (404) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  411,   -3 }, /* (405) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  371,   -1 }, /* (406) expression_list ::= expr_or_subquery */
  {  371,   -3 }, /* (407) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  420,   -1 }, /* (408) column_reference ::= column_name */
  {  420,   -3 }, /* (409) column_reference ::= table_name NK_DOT column_name */
  {  419,   -1 }, /* (410) pseudo_column ::= ROWTS */
  {  419,   -1 }, /* (411) pseudo_column ::= TBNAME */
  {  419,   -3 }, /* (412) pseudo_column ::= table_name NK_DOT TBNAME */
  {  419,   -1 }, /* (413) pseudo_column ::= QSTART */
  {  419,   -1 }, /* (414) pseudo_column ::= QEND */
  {  419,   -1 }, /* (415) pseudo_column ::= QDURATION */
  {  419,   -1 }, /* (416) pseudo_column ::= WSTART */
  {  419,   -1 }, /* (417) pseudo_column ::= WEND */
  {  419,   -1 }, /* (418) pseudo_column ::= WDURATION */
  {  419,   -1 }, /* (419) pseudo_column ::= IROWTS */
  {  419,   -1 }, /* (420) pseudo_column ::= ISFILLED */
  {  419,   -1 }, /* (421) pseudo_column ::= QTAGS */
  {  421,   -4 }, /* (422) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  421,   -4 }, /* (423) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  421,   -6 }, /* (424) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  421,   -1 }, /* (425) function_expression ::= literal_func */
  {  415,   -3 }, /* (426) literal_func ::= noarg_func NK_LP NK_RP */
  {  415,   -1 }, /* (427) literal_func ::= NOW */
  {  425,   -1 }, /* (428) noarg_func ::= NOW */
  {  425,   -1 }, /* (429) noarg_func ::= TODAY */
  {  425,   -1 }, /* (430) noarg_func ::= TIMEZONE */
  {  425,   -1 }, /* (431) noarg_func ::= DATABASE */
  {  425,   -1 }, /* (432) noarg_func ::= CLIENT_VERSION */
  {  425,   -1 }, /* (433) noarg_func ::= SERVER_VERSION */
  {  425,   -1 }, /* (434) noarg_func ::= SERVER_STATUS */
  {  425,   -1 }, /* (435) noarg_func ::= CURRENT_USER */
  {  425,   -1 }, /* (436) noarg_func ::= USER */
  {  423,   -1 }, /* (437) star_func ::= COUNT */
  {  423,   -1 }, /* (438) star_func ::= FIRST */
  {  423,   -1 }, /* (439) star_func ::= LAST */
  {  423,   -1 }, /* (440) star_func ::= LAST_ROW */
  {  424,   -1 }, /* (441) star_func_para_list ::= NK_STAR */
  {  424,   -1 }, /* (442) star_func_para_list ::= other_para_list */
  {  426,   -1 }, /* (443) other_para_list ::= star_func_para */
  {  426,   -3 }, /* (444) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  427,   -1 }, /* (445) star_func_para ::= expr_or_subquery */
  {  427,   -3 }, /* (446) star_func_para ::= table_name NK_DOT NK_STAR */
  {  422,   -4 }, /* (447) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  422,   -5 }, /* (448) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  428,   -1 }, /* (449) when_then_list ::= when_then_expr */
  {  428,   -2 }, /* (450) when_then_list ::= when_then_list when_then_expr */
  {  431,   -4 }, /* (451) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  429,    0 }, /* (452) case_when_else_opt ::= */
  {  429,   -2 }, /* (453) case_when_else_opt ::= ELSE common_expression */
  {  432,   -3 }, /* (454) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  432,   -5 }, /* (455) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  432,   -6 }, /* (456) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  432,   -3 }, /* (457) predicate ::= expr_or_subquery IS NULL */
  {  432,   -4 }, /* (458) predicate ::= expr_or_subquery IS NOT NULL */
  {  432,   -3 }, /* (459) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  433,   -1 }, /* (460) compare_op ::= NK_LT */
  {  433,   -1 }, /* (461) compare_op ::= NK_GT */
  {  433,   -1 }, /* (462) compare_op ::= NK_LE */
  {  433,   -1 }, /* (463) compare_op ::= NK_GE */
  {  433,   -1 }, /* (464) compare_op ::= NK_NE */
  {  433,   -1 }, /* (465) compare_op ::= NK_EQ */
  {  433,   -1 }, /* (466) compare_op ::= LIKE */
  {  433,   -2 }, /* (467) compare_op ::= NOT LIKE */
  {  433,   -1 }, /* (468) compare_op ::= MATCH */
  {  433,   -1 }, /* (469) compare_op ::= NMATCH */
  {  433,   -1 }, /* (470) compare_op ::= CONTAINS */
  {  434,   -1 }, /* (471) in_op ::= IN */
  {  434,   -2 }, /* (472) in_op ::= NOT IN */
  {  435,   -3 }, /* (473) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  436,   -1 }, /* (474) boolean_value_expression ::= boolean_primary */
  {  436,   -2 }, /* (475) boolean_value_expression ::= NOT boolean_primary */
  {  436,   -3 }, /* (476) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  436,   -3 }, /* (477) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  437,   -1 }, /* (478) boolean_primary ::= predicate */
  {  437,   -3 }, /* (479) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  430,   -1 }, /* (480) common_expression ::= expr_or_subquery */
  {  430,   -1 }, /* (481) common_expression ::= boolean_value_expression */
  {  438,    0 }, /* (482) from_clause_opt ::= */
  {  438,   -2 }, /* (483) from_clause_opt ::= FROM table_reference_list */
  {  439,   -1 }, /* (484) table_reference_list ::= table_reference */
  {  439,   -3 }, /* (485) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  440,   -1 }, /* (486) table_reference ::= table_primary */
  {  440,   -1 }, /* (487) table_reference ::= joined_table */
  {  441,   -2 }, /* (488) table_primary ::= table_name alias_opt */
  {  441,   -4 }, /* (489) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  441,   -2 }, /* (490) table_primary ::= subquery alias_opt */
  {  441,   -1 }, /* (491) table_primary ::= parenthesized_joined_table */
  {  443,    0 }, /* (492) alias_opt ::= */
  {  443,   -1 }, /* (493) alias_opt ::= table_alias */
  {  443,   -2 }, /* (494) alias_opt ::= AS table_alias */
  {  445,   -3 }, /* (495) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  445,   -3 }, /* (496) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  442,   -6 }, /* (497) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  446,    0 }, /* (498) join_type ::= */
  {  446,   -1 }, /* (499) join_type ::= INNER */
  {  448,  -12 }, /* (500) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  449,    0 }, /* (501) set_quantifier_opt ::= */
  {  449,   -1 }, /* (502) set_quantifier_opt ::= DISTINCT */
  {  449,   -1 }, /* (503) set_quantifier_opt ::= ALL */
  {  450,   -1 }, /* (504) select_list ::= select_item */
  {  450,   -3 }, /* (505) select_list ::= select_list NK_COMMA select_item */
  {  458,   -1 }, /* (506) select_item ::= NK_STAR */
  {  458,   -1 }, /* (507) select_item ::= common_expression */
  {  458,   -2 }, /* (508) select_item ::= common_expression column_alias */
  {  458,   -3 }, /* (509) select_item ::= common_expression AS column_alias */
  {  458,   -3 }, /* (510) select_item ::= table_name NK_DOT NK_STAR */
  {  413,    0 }, /* (511) where_clause_opt ::= */
  {  413,   -2 }, /* (512) where_clause_opt ::= WHERE search_condition */
  {  451,    0 }, /* (513) partition_by_clause_opt ::= */
  {  451,   -3 }, /* (514) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  459,   -1 }, /* (515) partition_list ::= partition_item */
  {  459,   -3 }, /* (516) partition_list ::= partition_list NK_COMMA partition_item */
  {  460,   -1 }, /* (517) partition_item ::= expr_or_subquery */
  {  460,   -2 }, /* (518) partition_item ::= expr_or_subquery column_alias */
  {  460,   -3 }, /* (519) partition_item ::= expr_or_subquery AS column_alias */
  {  455,    0 }, /* (520) twindow_clause_opt ::= */
  {  455,   -6 }, /* (521) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  455,   -4 }, /* (522) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  455,   -6 }, /* (523) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  455,   -8 }, /* (524) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  455,   -7 }, /* (525) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  394,    0 }, /* (526) sliding_opt ::= */
  {  394,   -4 }, /* (527) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  454,    0 }, /* (528) fill_opt ::= */
  {  454,   -4 }, /* (529) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  454,   -6 }, /* (530) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  454,   -6 }, /* (531) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
  {  461,   -1 }, /* (532) fill_mode ::= NONE */
  {  461,   -1 }, /* (533) fill_mode ::= PREV */
  {  461,   -1 }, /* (534) fill_mode ::= NULL */
  {  461,   -1 }, /* (535) fill_mode ::= NULL_F */
  {  461,   -1 }, /* (536) fill_mode ::= LINEAR */
  {  461,   -1 }, /* (537) fill_mode ::= NEXT */
  {  456,    0 }, /* (538) group_by_clause_opt ::= */
  {  456,   -3 }, /* (539) group_by_clause_opt ::= GROUP BY group_by_list */
  {  462,   -1 }, /* (540) group_by_list ::= expr_or_subquery */
  {  462,   -3 }, /* (541) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  457,    0 }, /* (542) having_clause_opt ::= */
  {  457,   -2 }, /* (543) having_clause_opt ::= HAVING search_condition */
  {  452,    0 }, /* (544) range_opt ::= */
  {  452,   -6 }, /* (545) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  453,    0 }, /* (546) every_opt ::= */
  {  453,   -4 }, /* (547) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  463,   -4 }, /* (548) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  464,   -1 }, /* (549) query_simple ::= query_specification */
  {  464,   -1 }, /* (550) query_simple ::= union_query_expression */
  {  468,   -4 }, /* (551) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  468,   -3 }, /* (552) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  469,   -1 }, /* (553) query_simple_or_subquery ::= query_simple */
  {  469,   -1 }, /* (554) query_simple_or_subquery ::= subquery */
  {  398,   -1 }, /* (555) query_or_subquery ::= query_expression */
  {  398,   -1 }, /* (556) query_or_subquery ::= subquery */
  {  465,    0 }, /* (557) order_by_clause_opt ::= */
  {  465,   -3 }, /* (558) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  466,    0 }, /* (559) slimit_clause_opt ::= */
  {  466,   -2 }, /* (560) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  466,   -4 }, /* (561) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  466,   -4 }, /* (562) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  467,    0 }, /* (563) limit_clause_opt ::= */
  {  467,   -2 }, /* (564) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  467,   -4 }, /* (565) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  467,   -4 }, /* (566) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  444,   -3 }, /* (567) subquery ::= NK_LP query_expression NK_RP */
  {  444,   -3 }, /* (568) subquery ::= NK_LP subquery NK_RP */
  {  447,   -1 }, /* (569) search_condition ::= common_expression */
  {  470,   -1 }, /* (570) sort_specification_list ::= sort_specification */
  {  470,   -3 }, /* (571) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  471,   -3 }, /* (572) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  472,    0 }, /* (573) ordering_specification_opt ::= */
  {  472,   -1 }, /* (574) ordering_specification_opt ::= ASC */
  {  472,   -1 }, /* (575) ordering_specification_opt ::= DESC */
  {  473,    0 }, /* (576) null_ordering_opt ::= */
  {  473,   -2 }, /* (577) null_ordering_opt ::= NULLS FIRST */
  {  473,   -2 }, /* (578) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,331,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,332,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,331,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,333,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,334,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,332,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,334,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,333,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy725, &yymsp[-1].minor.yy0, yymsp[0].minor.yy371); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy725, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy725, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy725, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy725); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy371 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy371 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy189, &yymsp[-2].minor.yy725, &yymsp[0].minor.yy725); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy189, &yymsp[-2].minor.yy725, &yymsp[0].minor.yy725); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy189 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy189 = yymsp[0].minor.yy189; }
  yymsp[0].minor.yy189 = yylhsminor.yy189;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy189 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy189 = yymsp[-2].minor.yy189 | yymsp[0].minor.yy189; }
  yymsp[-2].minor.yy189 = yylhsminor.yy189;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy189 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy189 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy725 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy725 = yylhsminor.yy725;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy725 = yymsp[-2].minor.yy725; }
  yymsp[-2].minor.yy725 = yylhsminor.yy725;
        break;
      case 42: /* priv_level ::= topic_name */
      case 286: /* sma_func_name ::= function_name */ yytestcase(yyruleno==286);
      case 493: /* alias_opt ::= table_alias */ yytestcase(yyruleno==493);
{ yylhsminor.yy725 = yymsp[0].minor.yy725; }
  yymsp[0].minor.yy725 = yylhsminor.yy725;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy725, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy725, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy437); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy725, yymsp[0].minor.yy437); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 287: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==287);
      case 288: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==288);
      case 289: /* sma_func_name ::= LAST */ yytestcase(yyruleno==289);
      case 290: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==290);
      case 378: /* db_name ::= NK_ID */ yytestcase(yyruleno==378);
      case 379: /* table_name ::= NK_ID */ yytestcase(yyruleno==379);
      case 380: /* column_name ::= NK_ID */ yytestcase(yyruleno==380);
      case 381: /* function_name ::= NK_ID */ yytestcase(yyruleno==381);
      case 382: /* table_alias ::= NK_ID */ yytestcase(yyruleno==382);
      case 383: /* column_alias ::= NK_ID */ yytestcase(yyruleno==383);
      case 384: /* user_name ::= NK_ID */ yytestcase(yyruleno==384);
      case 385: /* topic_name ::= NK_ID */ yytestcase(yyruleno==385);
      case 386: /* stream_name ::= NK_ID */ yytestcase(yyruleno==386);
      case 387: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==387);
      case 388: /* index_name ::= NK_ID */ yytestcase(yyruleno==388);
      case 428: /* noarg_func ::= NOW */ yytestcase(yyruleno==428);
      case 429: /* noarg_func ::= TODAY */ yytestcase(yyruleno==429);
      case 430: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==430);
      case 431: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==431);
      case 432: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==432);
      case 433: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==433);
      case 434: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==434);
      case 435: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==435);
      case 436: /* noarg_func ::= USER */ yytestcase(yyruleno==436);
      case 437: /* star_func ::= COUNT */ yytestcase(yyruleno==437);
      case 438: /* star_func ::= FIRST */ yytestcase(yyruleno==438);
      case 439: /* star_func ::= LAST */ yytestcase(yyruleno==439);
      case 440: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==440);
{ yylhsminor.yy725 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy725 = yylhsminor.yy725;
        break;
      case 54: /* force_opt ::= */
      case 74: /* not_exists_opt ::= */ yytestcase(yyruleno==74);
      case 76: /* exists_opt ::= */ yytestcase(yyruleno==76);
      case 307: /* analyze_opt ::= */ yytestcase(yyruleno==307);
      case 314: /* agg_func_opt ::= */ yytestcase(yyruleno==314);
      case 501: /* set_quantifier_opt ::= */ yytestcase(yyruleno==501);
{ yymsp[1].minor.yy437 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 308: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==308);
      case 315: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==315);
      case 502: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==502);
{ yymsp[0].minor.yy437 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy437, &yymsp[-1].minor.yy725, yymsp[0].minor.yy188); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy437, &yymsp[0].minor.yy725); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy725); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy725, yymsp[0].minor.yy188); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy725); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy725, yymsp[0].minor.yy136); }
        break;
      case 72: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy725, yymsp[-1].minor.yy188, yymsp[0].minor.yy188); }
        break;
      case 73: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy437 = true; }
        break;
      case 75: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy437 = true; }
        break;
      case 77: /* db_options ::= */
{ yymsp[1].minor.yy188 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 78: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 79: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 80: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 81: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 82: /* db_options ::= db_options DURATION NK_INTEGER */
      case 83: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==83);
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 84: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 85: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 86: /* db_options ::= db_options KEEP integer_list */
      case 87: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==87);
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_KEEP, yymsp[0].minor.yy172); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 88: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 89: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 90: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 91: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 92: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 93: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 94: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 95: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_RETENTIONS, yymsp[0].minor.yy172); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 96: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 97: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 98: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-3].minor.yy188, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy188 = yylhsminor.yy188;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-3].minor.yy188, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy188 = yylhsminor.yy188;
        break;
      case 103: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 104: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 105: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 106: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 107: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy188 = setDatabaseOption(pCxt, yymsp[-2].minor.yy188, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 108: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy188 = createAlterDatabaseOptions(pCxt); yylhsminor.yy188 = setAlterDatabaseOption(pCxt, yylhsminor.yy188, &yymsp[0].minor.yy653); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 109: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy188 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy188, &yymsp[0].minor.yy653); }
  yymsp[-1].minor.yy188 = yylhsminor.yy188;
        break;
      case 110: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy653.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy653.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy653.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy653.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy653.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy653.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy653.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy653.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= KEEP integer_list */
      case 115: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==115);
{ yymsp[-1].minor.yy653.type = DB_OPTION_KEEP; yymsp[-1].minor.yy653.pList = yymsp[0].minor.yy172; }
        break;
      case 116: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy653.type = DB_OPTION_PAGES; yymsp[-1].minor.yy653.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy653.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy653.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy653.type = DB_OPTION_WAL; yymsp[-1].minor.yy653.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy653.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy653.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* alter_db_option ::= MINROWS NK_INTEGER */
{ yymsp[-1].minor.yy653.type = DB_OPTION_MINROWS; yymsp[-1].minor.yy653.val = yymsp[0].minor.yy0; }
        break;
      case 121: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy653.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-1].minor.yy653.val = yymsp[0].minor.yy0; }
        break;
      case 122: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy653.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-2].minor.yy653.val = t;
                                                                                  }
        break;
      case 123: /* alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
{ yymsp[-1].minor.yy653.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-1].minor.yy653.val = yymsp[0].minor.yy0; }
        break;
      case 124: /* alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy653.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-2].minor.yy653.val = t;
                                                                                  }
        break;
      case 125: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy172 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 126: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 347: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==347);
{ yylhsminor.yy172 = addNodeToList(pCxt, yymsp[-2].minor.yy172, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 127: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy172 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 128: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy172 = addNodeToList(pCxt, yymsp[-2].minor.yy172, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 129: /* retention_list ::= retention */
      case 159: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==159);
      case 162: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==162);
      case 169: /* column_def_list ::= column_def */ yytestcase(yyruleno==169);
      case 213: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==213);
      case 218: /* col_name_list ::= col_name */ yytestcase(yyruleno==218);
      case 269: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==269);
      case 283: /* func_list ::= func */ yytestcase(yyruleno==283);
      case 376: /* literal_list ::= signed_literal */ yytestcase(yyruleno==376);
      case 443: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==443);
      case 449: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==449);
      case 504: /* select_list ::= select_item */ yytestcase(yyruleno==504);
      case 515: /* partition_list ::= partition_item */ yytestcase(yyruleno==515);
      case 570: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==570);
{ yylhsminor.yy172 = createNodeList(pCxt, yymsp[0].minor.yy188); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 130: /* retention_list ::= retention_list NK_COMMA retention */
      case 163: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==163);
      case 170: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==170);
      case 214: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==214);
      case 219: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==219);
      case 270: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==270);
      case 284: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==284);
      case 377: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==377);
      case 444: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==444);
      case 505: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==505);
      case 516: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==516);
      case 571: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==571);
{ yylhsminor.yy172 = addNodeToList(pCxt, yymsp[-2].minor.yy172, yymsp[0].minor.yy188); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 131: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy188 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 132: /* speed_opt ::= */
      case 316: /* bufsize_opt ::= */ yytestcase(yyruleno==316);
{ yymsp[1].minor.yy136 = 0; }
        break;
      case 133: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 317: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==317);
{ yymsp[-1].minor.yy136 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 134: /* start_opt ::= */
      case 138: /* end_opt ::= */ yytestcase(yyruleno==138);
      case 263: /* like_pattern_opt ::= */ yytestcase(yyruleno==263);
      case 336: /* subtable_opt ::= */ yytestcase(yyruleno==336);
      case 452: /* case_when_else_opt ::= */ yytestcase(yyruleno==452);
      case 482: /* from_clause_opt ::= */ yytestcase(yyruleno==482);
      case 511: /* where_clause_opt ::= */ yytestcase(yyruleno==511);
      case 520: /* twindow_clause_opt ::= */ yytestcase(yyruleno==520);
      case 526: /* sliding_opt ::= */ yytestcase(yyruleno==526);
      case 528: /* fill_opt ::= */ yytestcase(yyruleno==528);
      case 542: /* having_clause_opt ::= */ yytestcase(yyruleno==542);
      case 544: /* range_opt ::= */ yytestcase(yyruleno==544);
      case 546: /* every_opt ::= */ yytestcase(yyruleno==546);
      case 559: /* slimit_clause_opt ::= */ yytestcase(yyruleno==559);
      case 563: /* limit_clause_opt ::= */ yytestcase(yyruleno==563);
{ yymsp[1].minor.yy188 = NULL; }
        break;
      case 135: /* start_opt ::= START WITH NK_INTEGER */
      case 139: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==139);
{ yymsp[-2].minor.yy188 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 136: /* start_opt ::= START WITH NK_STRING */
      case 140: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==140);
{ yymsp[-2].minor.yy188 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 137: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 141: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==141);
{ yymsp[-3].minor.yy188 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 142: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 144: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==144);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy437, yymsp[-5].minor.yy188, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, yymsp[0].minor.yy188); }
        break;
      case 143: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy172); }
        break;
      case 145: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy172); }
        break;
      case 146: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy437, yymsp[0].minor.yy188); }
        break;
      case 147: /* cmd ::= ALTER TABLE alter_table_clause */
      case 349: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==349);
      case 350: /* cmd ::= insert_query */ yytestcase(yyruleno==350);
{ pCxt->pRootNode = yymsp[0].minor.yy188; }
        break;
      case 148: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy188); }
        break;
      case 149: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy188 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy188, yymsp[0].minor.yy188); }
  yymsp[-1].minor.yy188 = yylhsminor.yy188;
        break;
      case 150: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy188 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy188, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy725, yymsp[0].minor.yy160); }
  yymsp[-4].minor.yy188 = yylhsminor.yy188;
        break;
      case 151: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy188 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy188, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy725); }
  yymsp[-3].minor.yy188 = yylhsminor.yy188;
        break;
      case 152: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy188 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy188, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy725, yymsp[0].minor.yy160); }
  yymsp[-4].minor.yy188 = yylhsminor.yy188;
        break;
      case 153: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy188 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy188, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy725, &yymsp[0].minor.yy725); }
  yymsp[-4].minor.yy188 = yylhsminor.yy188;
        break;
      case 154: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy188 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy188, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy725, yymsp[0].minor.yy160); }
  yymsp[-4].minor.yy188 = yylhsminor.yy188;
        break;
      case 155: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy188 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy188, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy725); }
  yymsp[-3].minor.yy188 = yylhsminor.yy188;
        break;
      case 156: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy188 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy188, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy725, yymsp[0].minor.yy160); }
  yymsp[-4].minor.yy188 = yylhsminor.yy188;
        break;
      case 157: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy188 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy188, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy725, &yymsp[0].minor.yy725); }
  yymsp[-4].minor.yy188 = yylhsminor.yy188;
        break;
      case 158: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy188 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy188, &yymsp[-2].minor.yy725, yymsp[0].minor.yy188); }
  yymsp[-5].minor.yy188 = yylhsminor.yy188;
        break;
      case 160: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 450: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==450);
{ yylhsminor.yy172 = addNodeToList(pCxt, yymsp[-1].minor.yy172, yymsp[0].minor.yy188); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 161: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy188 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy437, yymsp[-8].minor.yy188, yymsp[-6].minor.yy188, yymsp[-5].minor.yy172, yymsp[-2].minor.yy172, yymsp[0].minor.yy188); }
  yymsp[-9].minor.yy188 = yylhsminor.yy188;
        break;
      case 164: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy188 = createDropTableClause(pCxt, yymsp[-1].minor.yy437, yymsp[0].minor.yy188); }
  yymsp[-1].minor.yy188 = yylhsminor.yy188;
        break;
      case 165: /* specific_cols_opt ::= */
      case 196: /* tags_def_opt ::= */ yytestcase(yyruleno==196);
      case 268: /* tag_list_opt ::= */ yytestcase(yyruleno==268);
      case 322: /* col_list_opt ::= */ yytestcase(yyruleno==322);
      case 324: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==324);
      case 513: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==513);
      case 538: /* group_by_clause_opt ::= */ yytestcase(yyruleno==538);
      case 557: /* order_by_clause_opt ::= */ yytestcase(yyruleno==557);
{ yymsp[1].minor.yy172 = NULL; }
        break;
      case 166: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 323: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==323);
{ yymsp[-2].minor.yy172 = yymsp[-1].minor.yy172; }
        break;
      case 167: /* full_table_name ::= table_name */
{ yylhsminor.yy188 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy725, NULL); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 168: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy188 = createRealTableNode(pCxt, &yymsp[-2].minor.yy725, &yymsp[0].minor.yy725, NULL); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 171: /* column_def ::= column_name type_name */
{ yylhsminor.yy188 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy725, yymsp[0].minor.yy160, NULL); }
  yymsp[-1].minor.yy188 = yylhsminor.yy188;
        break;
      case 172: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy188 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy725, yymsp[-2].minor.yy160, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy188 = yylhsminor.yy188;
        break;
      case 173: /* type_name ::= BOOL */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 174: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 175: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 176: /* type_name ::= INT */
      case 177: /* type_name ::= INTEGER */ yytestcase(yyruleno==177);
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 178: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 179: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 180: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 181: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy160 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 182: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 183: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy160 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 184: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy160 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 185: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy160 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 186: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy160 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 187: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy160 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 188: /* type_name ::= JSON */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 189: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy160 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 190: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 191: /* type_name ::= BLOB */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 192: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy160 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 193: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 194: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy160 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 195: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy160 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 197: /* tags_def_opt ::= tags_def */
      case 325: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==325);
      case 442: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==442);
{ yylhsminor.yy172 = yymsp[0].minor.yy172; }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 198: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 326: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==326);
{ yymsp[-3].minor.yy172 = yymsp[-1].minor.yy172; }
        break;
      case 199: /* table_options ::= */
{ yymsp[1].minor.yy188 = createDefaultTableOptions(pCxt); }
        break;
      case 200: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy188 = setTableOption(pCxt, yymsp[-2].minor.yy188, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 201: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy188 = setTableOption(pCxt, yymsp[-2].minor.yy188, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy172); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 202: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy188 = setTableOption(pCxt, yymsp[-2].minor.yy188, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy172); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 203: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy188 = setTableOption(pCxt, yymsp[-4].minor.yy188, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy172); }
  yymsp[-4].minor.yy188 = yylhsminor.yy188;
        break;
      case 204: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy188 = setTableOption(pCxt, yymsp[-2].minor.yy188, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 205: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy188 = setTableOption(pCxt, yymsp[-4].minor.yy188, TABLE_OPTION_SMA, yymsp[-1].minor.yy172); }
  yymsp[-4].minor.yy188 = yylhsminor.yy188;
        break;
      case 206: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy188 = setTableOption(pCxt, yymsp[-2].minor.yy188, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy172); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 207: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy188 = createAlterTableOptions(pCxt); yylhsminor.yy188 = setTableOption(pCxt, yylhsminor.yy188, yymsp[0].minor.yy653.type, &yymsp[0].minor.yy653.val); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 208: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy188 = setTableOption(pCxt, yymsp[-1].minor.yy188, yymsp[0].minor.yy653.type, &yymsp[0].minor.yy653.val); }
  yymsp[-1].minor.yy188 = yylhsminor.yy188;
        break;
      case 209: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy653.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy653.val = yymsp[0].minor.yy0; }
        break;
      case 210: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy653.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy653.val = yymsp[0].minor.yy0; }
        break;
      case 211: /* duration_list ::= duration_literal */
      case 406: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==406);
{ yylhsminor.yy172 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy188)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 212: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 407: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==407);
{ yylhsminor.yy172 = addNodeToList(pCxt, yymsp[-2].minor.yy172, releaseRawExprNode(pCxt, yymsp[0].minor.yy188)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 215: /* rollup_func_name ::= function_name */
{ yylhsminor.yy188 = createFunctionNode(pCxt, &yymsp[0].minor.yy725, NULL); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 216: /* rollup_func_name ::= FIRST */
      case 217: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==217);
      case 272: /* tag_item ::= QTAGS */ yytestcase(yyruleno==272);
{ yylhsminor.yy188 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 220: /* col_name ::= column_name */
      case 273: /* tag_item ::= column_name */ yytestcase(yyruleno==273);
{ yylhsminor.yy188 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy725); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 221: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 222: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 223: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 224: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 225: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy188, yymsp[0].minor.yy188, OP_TYPE_LIKE); }
        break;
      case 226: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy188, yymsp[0].minor.yy188, OP_TYPE_LIKE); }
        break;
      case 227: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy188, NULL, OP_TYPE_LIKE); }
        break;
      case 228: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 229: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 230: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 231: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy188, yymsp[-1].minor.yy188, OP_TYPE_EQUAL); }
        break;
      case 232: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 233: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 234: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 235: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 236: /* cmd ::= SHOW LICENCES */
      case 237: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==237);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 238: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy725); }
        break;
      case 239: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy188); }
        break;
      case 240: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy188); }
        break;
      case 241: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 242: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 243: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 244: /* cmd ::= SHOW VARIABLES */
      case 245: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==245);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 246: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 247: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy188); }
        break;
      case 248: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 249: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 250: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 251: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 252: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy188); }
        break;
      case 253: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 254: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 255: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy188, yymsp[-1].minor.yy188, OP_TYPE_EQUAL); }
        break;
      case 256: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy188, yymsp[0].minor.yy188, yymsp[-3].minor.yy172); }
        break;
      case 257: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 258: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 259: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy188,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 260: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 261: /* db_name_cond_opt ::= */
      case 266: /* from_db_opt ::= */ yytestcase(yyruleno==266);
{ yymsp[1].minor.yy188 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 262: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy188 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy725); }
  yymsp[-1].minor.yy188 = yylhsminor.yy188;
        break;
      case 264: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy188 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 265: /* table_name_cond ::= table_name */
{ yylhsminor.yy188 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy725); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 267: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy188 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy725); }
        break;
      case 271: /* tag_item ::= TBNAME */
{ yylhsminor.yy188 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 274: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy188 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy725), &yymsp[0].minor.yy725); }
  yymsp[-1].minor.yy188 = yylhsminor.yy188;
        break;
      case 275: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy188 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy725), &yymsp[0].minor.yy725); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 276: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy437, yymsp[-3].minor.yy188, yymsp[-1].minor.yy188, NULL, yymsp[0].minor.yy188); }
        break;
      case 277: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy437, yymsp[-5].minor.yy188, yymsp[-3].minor.yy188, yymsp[-1].minor.yy172, NULL); }
        break;
      case 278: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy437, yymsp[0].minor.yy188); }
        break;
      case 279: /* full_index_name ::= index_name */
{ yylhsminor.yy188 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy725); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 280: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy188 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy725, &yymsp[0].minor.yy725); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 281: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy188 = createIndexOption(pCxt, yymsp[-7].minor.yy172, releaseRawExprNode(pCxt, yymsp[-3].minor.yy188), NULL, yymsp[-1].minor.yy188, yymsp[0].minor.yy188); }
        break;
      case 282: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy188 = createIndexOption(pCxt, yymsp[-9].minor.yy172, releaseRawExprNode(pCxt, yymsp[-5].minor.yy188), releaseRawExprNode(pCxt, yymsp[-3].minor.yy188), yymsp[-1].minor.yy188, yymsp[0].minor.yy188); }
        break;
      case 285: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy188 = createFunctionNode(pCxt, &yymsp[-3].minor.yy725, yymsp[-1].minor.yy172); }
  yymsp[-3].minor.yy188 = yylhsminor.yy188;
        break;
      case 291: /* sma_stream_opt ::= */
      case 327: /* stream_options ::= */ yytestcase(yyruleno==327);
{ yymsp[1].minor.yy188 = createStreamOptions(pCxt); }
        break;
      case 292: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy188)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy188); yylhsminor.yy188 = yymsp[-2].minor.yy188; }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 293: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy188)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy188); yylhsminor.yy188 = yymsp[-2].minor.yy188; }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 294: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy188)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy188); yylhsminor.yy188 = yymsp[-2].minor.yy188; }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 295: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy437, &yymsp[-2].minor.yy725, yymsp[0].minor.yy188); }
        break;
      case 296: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy437, &yymsp[-3].minor.yy725, &yymsp[0].minor.yy725, false); }
        break;
      case 297: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy437, &yymsp[-5].minor.yy725, &yymsp[0].minor.yy725, true); }
        break;
      case 298: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy437, &yymsp[-3].minor.yy725, yymsp[0].minor.yy188, false); }
        break;
      case 299: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy437, &yymsp[-5].minor.yy725, yymsp[0].minor.yy188, true); }
        break;
      case 300: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy437, &yymsp[0].minor.yy725); }
        break;
      case 301: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy437, &yymsp[-2].minor.yy725, &yymsp[0].minor.yy725); }
        break;
      case 302: /* cmd ::= DESC full_table_name */
      case 303: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==303);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy188); }
        break;
      case 304: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 305: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 306: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==306);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy437, yymsp[-1].minor.yy188, yymsp[0].minor.yy188); }
        break;
      case 309: /* explain_options ::= */
{ yymsp[1].minor.yy188 = createDefaultExplainOptions(pCxt); }
        break;
      case 310: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy188 = setExplainVerbose(pCxt, yymsp[-2].minor.yy188, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 311: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy188 = setExplainRatio(pCxt, yymsp[-2].minor.yy188, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 312: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy437, yymsp[-9].minor.yy437, &yymsp[-6].minor.yy725, &yymsp[-4].minor.yy0, yymsp[-2].minor.yy160, yymsp[-1].minor.yy136, &yymsp[0].minor.yy725); }
        break;
      case 313: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy437, &yymsp[0].minor.yy725); }
        break;
      case 318: /* language_opt ::= */
{ yymsp[1].minor.yy725 = nil_token; }
        break;
      case 319: /* language_opt ::= LANGUAGE NK_STRING */
{ yymsp[-1].minor.yy725 = yymsp[0].minor.yy0; }
        break;
      case 320: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy437, &yymsp[-8].minor.yy725, yymsp[-5].minor.yy188, yymsp[-7].minor.yy188, yymsp[-3].minor.yy172, yymsp[-2].minor.yy188, yymsp[0].minor.yy188, yymsp[-4].minor.yy172); }
        break;
      case 321: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy437, &yymsp[0].minor.yy725); }
        break;
      case 328: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 329: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==329);
{ yylhsminor.yy188 = setStreamOptions(pCxt, yymsp[-2].minor.yy188, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 330: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ yylhsminor.yy188 = setStreamOptions(pCxt, yymsp[-3].minor.yy188, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy188)); }
  yymsp[-3].minor.yy188 = yylhsminor.yy188;
        break;
      case 331: /* stream_options ::= stream_options WATERMARK duration_literal */
{ yylhsminor.yy188 = setStreamOptions(pCxt, yymsp[-2].minor.yy188, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy188)); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 332: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ yylhsminor.yy188 = setStreamOptions(pCxt, yymsp[-3].minor.yy188, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy188 = yylhsminor.yy188;
        break;
      case 333: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ yylhsminor.yy188 = setStreamOptions(pCxt, yymsp[-2].minor.yy188, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 334: /* stream_options ::= stream_options DELETE_MARK duration_literal */
{ yylhsminor.yy188 = setStreamOptions(pCxt, yymsp[-2].minor.yy188, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy188)); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 335: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ yylhsminor.yy188 = setStreamOptions(pCxt, yymsp[-3].minor.yy188, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy188 = yylhsminor.yy188;
        break;
      case 337: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 527: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==527);
      case 547: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==547);
{ yymsp[-3].minor.yy188 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy188); }
        break;
      case 338: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 339: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 340: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 341: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 342: /* cmd ::= BALANCE VGROUP LEADER */
{ pCxt->pRootNode = createBalanceVgroupLeaderStmt(pCxt); }
        break;
      case 343: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 344: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy172); }
        break;
      case 345: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 346: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy172 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 348: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy188, yymsp[0].minor.yy188); }
        break;
      case 351: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy188 = createInsertStmt(pCxt, yymsp[-4].minor.yy188, yymsp[-2].minor.yy172, yymsp[0].minor.yy188); }
        break;
      case 352: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy188 = createInsertStmt(pCxt, yymsp[-1].minor.yy188, NULL, yymsp[0].minor.yy188); }
        break;
      case 353: /* literal ::= NK_INTEGER */
{ yylhsminor.yy188 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 354: /* literal ::= NK_FLOAT */
{ yylhsminor.yy188 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 355: /* literal ::= NK_STRING */
{ yylhsminor.yy188 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 356: /* literal ::= NK_BOOL */
{ yylhsminor.yy188 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 357: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy188 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy188 = yylhsminor.yy188;
        break;
      case 358: /* literal ::= duration_literal */
      case 368: /* signed_literal ::= signed */ yytestcase(yyruleno==368);
      case 389: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==389);
      case 390: /* expression ::= literal */ yytestcase(yyruleno==390);
      case 391: /* expression ::= pseudo_column */ yytestcase(yyruleno==391);
      case 392: /* expression ::= column_reference */ yytestcase(yyruleno==392);
      case 393: /* expression ::= function_expression */ yytestcase(yyruleno==393);
      case 394: /* expression ::= case_when_expression */ yytestcase(yyruleno==394);
      case 425: /* function_expression ::= literal_func */ yytestcase(yyruleno==425);
      case 474: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==474);
      case 478: /* boolean_primary ::= predicate */ yytestcase(yyruleno==478);
      case 480: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==480);
      case 481: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==481);
      case 484: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==484);
      case 486: /* table_reference ::= table_primary */ yytestcase(yyruleno==486);
      case 487: /* table_reference ::= joined_table */ yytestcase(yyruleno==487);
      case 491: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==491);
      case 549: /* query_simple ::= query_specification */ yytestcase(yyruleno==549);
      case 550: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==550);
      case 553: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==553);
      case 555: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==555);
{ yylhsminor.yy188 = yymsp[0].minor.yy188; }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 359: /* literal ::= NULL */
{ yylhsminor.yy188 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 360: /* literal ::= NK_QUESTION */
{ yylhsminor.yy188 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 361: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy188 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 362: /* signed ::= NK_INTEGER */
{ yylhsminor.yy188 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 363: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy188 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 364: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy188 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy188 = yylhsminor.yy188;
        break;
      case 365: /* signed ::= NK_FLOAT */
{ yylhsminor.yy188 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 366: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy188 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 367: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy188 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy188 = yylhsminor.yy188;
        break;
      case 369: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy188 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 370: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy188 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 371: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy188 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 372: /* signed_literal ::= duration_literal */
      case 374: /* signed_literal ::= literal_func */ yytestcase(yyruleno==374);
      case 445: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==445);
      case 507: /* select_item ::= common_expression */ yytestcase(yyruleno==507);
      case 517: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==517);
      case 554: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==554);
      case 556: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==556);
      case 569: /* search_condition ::= common_expression */ yytestcase(yyruleno==569);
{ yylhsminor.yy188 = releaseRawExprNode(pCxt, yymsp[0].minor.yy188); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 373: /* signed_literal ::= NULL */
{ yylhsminor.yy188 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 375: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy188 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 395: /* expression ::= NK_LP expression NK_RP */
      case 479: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==479);
      case 568: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==568);
{ yylhsminor.yy188 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy188)); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 396: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy188);
                                                                                    yylhsminor.yy188 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy188));
                                                                                  }
  yymsp[-1].minor.yy188 = yylhsminor.yy188;
        break;
      case 397: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy188);
                                                                                    yylhsminor.yy188 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy188), NULL));
                                                                                  }
  yymsp[-1].minor.yy188 = yylhsminor.yy188;
        break;
      case 398: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy188);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy188);
                                                                                    yylhsminor.yy188 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy188), releaseRawExprNode(pCxt, yymsp[0].minor.yy188))); 
                                                                                  }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 399: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy188);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy188);
                                                                                    yylhsminor.yy188 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy188), releaseRawExprNode(pCxt, yymsp[0].minor.yy188))); 
                                                                                  }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 400: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy188);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy188);
                                                                                    yylhsminor.yy188 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy188), releaseRawExprNode(pCxt, yymsp[0].minor.yy188))); 
                                                                                  }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 401: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy188);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy188);
                                                                                    yylhsminor.yy188 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy188), releaseRawExprNode(pCxt, yymsp[0].minor.yy188))); 
                                                                                  }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 402: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy188);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy188);
                                                                                    yylhsminor.yy188 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy188), releaseRawExprNode(pCxt, yymsp[0].minor.yy188)));
                                                                                  }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 403: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy188);
                                                                                    yylhsminor.yy188 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy188), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 404: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy188);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy188);
                                                                                    yylhsminor.yy188 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy188), releaseRawExprNode(pCxt, yymsp[0].minor.yy188)));
                                                                                  }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 405: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy188);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy188);
                                                                                    yylhsminor.yy188 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy188), releaseRawExprNode(pCxt, yymsp[0].minor.yy188)));
                                                                                  }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 408: /* column_reference ::= column_name */
{ yylhsminor.yy188 = createRawExprNode(pCxt, &yymsp[0].minor.yy725, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy725)); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 409: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy188 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy725, &yymsp[0].minor.yy725, createColumnNode(pCxt, &yymsp[-2].minor.yy725, &yymsp[0].minor.yy725)); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 410: /* pseudo_column ::= ROWTS */
      case 411: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==411);
      case 413: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==413);
      case 414: /* pseudo_column ::= QEND */ yytestcase(yyruleno==414);
      case 415: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==415);
      case 416: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==416);
      case 417: /* pseudo_column ::= WEND */ yytestcase(yyruleno==417);
      case 418: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==418);
      case 419: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==419);
      case 420: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==420);
      case 421: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==421);
      case 427: /* literal_func ::= NOW */ yytestcase(yyruleno==427);
{ yylhsminor.yy188 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 412: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy188 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy725, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy725)))); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 422: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 423: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==423);
{ yylhsminor.yy188 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy725, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy725, yymsp[-1].minor.yy172)); }
  yymsp[-3].minor.yy188 = yylhsminor.yy188;
        break;
      case 424: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy188 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy188), yymsp[-1].minor.yy160)); }
  yymsp[-5].minor.yy188 = yylhsminor.yy188;
        break;
      case 426: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy188 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy725, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy725, NULL)); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 441: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy172 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 446: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 510: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==510);
{ yylhsminor.yy188 = createColumnNode(pCxt, &yymsp[-2].minor.yy725, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 447: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy188 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy172, yymsp[-1].minor.yy188)); }
  yymsp[-3].minor.yy188 = yylhsminor.yy188;
        break;
      case 448: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy188 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy188), yymsp[-2].minor.yy172, yymsp[-1].minor.yy188)); }
  yymsp[-4].minor.yy188 = yylhsminor.yy188;
        break;
      case 451: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy188 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy188), releaseRawExprNode(pCxt, yymsp[0].minor.yy188)); }
        break;
      case 453: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy188 = releaseRawExprNode(pCxt, yymsp[0].minor.yy188); }
        break;
      case 454: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 459: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==459);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy188);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy188);
                                                                                    yylhsminor.yy188 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy716, releaseRawExprNode(pCxt, yymsp[-2].minor.yy188), releaseRawExprNode(pCxt, yymsp[0].minor.yy188)));
                                                                                  }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 455: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy188);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy188);
                                                                                    yylhsminor.yy188 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy188), releaseRawExprNode(pCxt, yymsp[-2].minor.yy188), releaseRawExprNode(pCxt, yymsp[0].minor.yy188)));
                                                                                  }
  yymsp[-4].minor.yy188 = yylhsminor.yy188;
        break;
      case 456: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy188);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy188);
                                                                                    yylhsminor.yy188 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy188), releaseRawExprNode(pCxt, yymsp[-2].minor.yy188), releaseRawExprNode(pCxt, yymsp[0].minor.yy188)));
                                                                                  }
  yymsp[-5].minor.yy188 = yylhsminor.yy188;
        break;
      case 457: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy188);
                                                                                    yylhsminor.yy188 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy188), NULL));
                                                                                  }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 458: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy188);
                                                                                    yylhsminor.yy188 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy188), NULL));
                                                                                  }
  yymsp[-3].minor.yy188 = yylhsminor.yy188;
        break;
      case 460: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy716 = OP_TYPE_LOWER_THAN; }
        break;
      case 461: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy716 = OP_TYPE_GREATER_THAN; }
        break;
      case 462: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy716 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 463: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy716 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 464: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy716 = OP_TYPE_NOT_EQUAL; }
        break;
      case 465: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy716 = OP_TYPE_EQUAL; }
        break;
      case 466: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy716 = OP_TYPE_LIKE; }
        break;
      case 467: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy716 = OP_TYPE_NOT_LIKE; }
        break;
      case 468: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy716 = OP_TYPE_MATCH; }
        break;
      case 469: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy716 = OP_TYPE_NMATCH; }
        break;
      case 470: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy716 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 471: /* in_op ::= IN */
{ yymsp[0].minor.yy716 = OP_TYPE_IN; }
        break;
      case 472: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy716 = OP_TYPE_NOT_IN; }
        break;
      case 473: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy188 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy172)); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 475: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy188);
                                                                                    yylhsminor.yy188 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy188), NULL));
                                                                                  }
  yymsp[-1].minor.yy188 = yylhsminor.yy188;
        break;
      case 476: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy188);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy188);
                                                                                    yylhsminor.yy188 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy188), releaseRawExprNode(pCxt, yymsp[0].minor.yy188)));
                                                                                  }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 477: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy188);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy188);
                                                                                    yylhsminor.yy188 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy188), releaseRawExprNode(pCxt, yymsp[0].minor.yy188)));
                                                                                  }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 483: /* from_clause_opt ::= FROM table_reference_list */
      case 512: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==512);
      case 543: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==543);
{ yymsp[-1].minor.yy188 = yymsp[0].minor.yy188; }
        break;
      case 485: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy188 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy188, yymsp[0].minor.yy188, NULL); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 488: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy188 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy725, &yymsp[0].minor.yy725); }
  yymsp[-1].minor.yy188 = yylhsminor.yy188;
        break;
      case 489: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy188 = createRealTableNode(pCxt, &yymsp[-3].minor.yy725, &yymsp[-1].minor.yy725, &yymsp[0].minor.yy725); }
  yymsp[-3].minor.yy188 = yylhsminor.yy188;
        break;
      case 490: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy188 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy188), &yymsp[0].minor.yy725); }
  yymsp[-1].minor.yy188 = yylhsminor.yy188;
        break;
      case 492: /* alias_opt ::= */
{ yymsp[1].minor.yy725 = nil_token;  }
        break;
      case 494: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy725 = yymsp[0].minor.yy725; }
        break;
      case 495: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 496: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==496);
{ yymsp[-2].minor.yy188 = yymsp[-1].minor.yy188; }
        break;
      case 497: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy188 = createJoinTableNode(pCxt, yymsp[-4].minor.yy240, yymsp[-5].minor.yy188, yymsp[-2].minor.yy188, yymsp[0].minor.yy188); }
  yymsp[-5].minor.yy188 = yylhsminor.yy188;
        break;
      case 498: /* join_type ::= */
{ yymsp[1].minor.yy240 = JOIN_TYPE_INNER; }
        break;
      case 499: /* join_type ::= INNER */
{ yymsp[0].minor.yy240 = JOIN_TYPE_INNER; }
        break;
      case 500: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy188 = createSelectStmt(pCxt, yymsp[-10].minor.yy437, yymsp[-9].minor.yy172, yymsp[-8].minor.yy188);
                                                                                    yymsp[-11].minor.yy188 = addWhereClause(pCxt, yymsp[-11].minor.yy188, yymsp[-7].minor.yy188);
                                                                                    yymsp[-11].minor.yy188 = addPartitionByClause(pCxt, yymsp[-11].minor.yy188, yymsp[-6].minor.yy172);
                                                                                    yymsp[-11].minor.yy188 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy188, yymsp[-2].minor.yy188);
                                                                                    yymsp[-11].minor.yy188 = addGroupByClause(pCxt, yymsp[-11].minor.yy188, yymsp[-1].minor.yy172);
                                                                                    yymsp[-11].minor.yy188 = addHavingClause(pCxt, yymsp[-11].minor.yy188, yymsp[0].minor.yy188);
                                                                                    yymsp[-11].minor.yy188 = addRangeClause(pCxt, yymsp[-11].minor.yy188, yymsp[-5].minor.yy188);
                                                                                    yymsp[-11].minor.yy188 = addEveryClause(pCxt, yymsp[-11].minor.yy188, yymsp[-4].minor.yy188);
                                                                                    yymsp[-11].minor.yy188 = addFillClause(pCxt, yymsp[-11].minor.yy188, yymsp[-3].minor.yy188);
                                                                                  }
        break;
      case 503: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy437 = false; }
        break;
      case 506: /* select_item ::= NK_STAR */
{ yylhsminor.yy188 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy188 = yylhsminor.yy188;
        break;
      case 508: /* select_item ::= common_expression column_alias */
      case 518: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==518);
{ yylhsminor.yy188 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy188), &yymsp[0].minor.yy725); }
  yymsp[-1].minor.yy188 = yylhsminor.yy188;
        break;
      case 509: /* select_item ::= common_expression AS column_alias */
      case 519: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==519);
{ yylhsminor.yy188 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy188), &yymsp[0].minor.yy725); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 514: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 539: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==539);
      case 558: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==558);
{ yymsp[-2].minor.yy172 = yymsp[0].minor.yy172; }
        break;
      case 521: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy188 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy188), releaseRawExprNode(pCxt, yymsp[-1].minor.yy188)); }
        break;
      case 522: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy188 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy188)); }
        break;
      case 523: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy188 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy188), NULL, yymsp[-1].minor.yy188, yymsp[0].minor.yy188); }
        break;
      case 524: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy188 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy188), releaseRawExprNode(pCxt, yymsp[-3].minor.yy188), yymsp[-1].minor.yy188, yymsp[0].minor.yy188); }
        break;
      case 525: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy188 = createEventWindowNode(pCxt, yymsp[-3].minor.yy188, yymsp[0].minor.yy188); }
        break;
      case 529: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy188 = createFillNode(pCxt, yymsp[-1].minor.yy654, NULL); }
        break;
      case 530: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy188 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy172)); }
        break;
      case 531: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy188 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy172)); }
        break;
      case 532: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy654 = FILL_MODE_NONE; }
        break;
      case 533: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy654 = FILL_MODE_PREV; }
        break;
      case 534: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy654 = FILL_MODE_NULL; }
        break;
      case 535: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy654 = FILL_MODE_NULL_F; }
        break;
      case 536: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy654 = FILL_MODE_LINEAR; }
        break;
      case 537: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy654 = FILL_MODE_NEXT; }
        break;
      case 540: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy172 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy188))); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 541: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy172 = addNodeToList(pCxt, yymsp[-2].minor.yy172, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy188))); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 545: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy188 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy188), releaseRawExprNode(pCxt, yymsp[-1].minor.yy188)); }
        break;
      case 548: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy188 = addOrderByClause(pCxt, yymsp[-3].minor.yy188, yymsp[-2].minor.yy172);
                                                                                    yylhsminor.yy188 = addSlimitClause(pCxt, yylhsminor.yy188, yymsp[-1].minor.yy188);
                                                                                    yylhsminor.yy188 = addLimitClause(pCxt, yylhsminor.yy188, yymsp[0].minor.yy188);
                                                                                  }
  yymsp[-3].minor.yy188 = yylhsminor.yy188;
        break;
      case 551: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy188 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy188, yymsp[0].minor.yy188); }
  yymsp[-3].minor.yy188 = yylhsminor.yy188;
        break;
      case 552: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy188 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy188, yymsp[0].minor.yy188); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 560: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 564: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==564);
{ yymsp[-1].minor.yy188 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 561: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 565: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==565);
{ yymsp[-3].minor.yy188 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 562: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 566: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==566);
{ yymsp[-3].minor.yy188 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 567: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy188 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy188); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 572: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy188 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy188), yymsp[-1].minor.yy206, yymsp[0].minor.yy913); }
  yymsp[-2].minor.yy188 = yylhsminor.yy188;
        break;
      case 573: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy206 = ORDER_ASC; }
        break;
      case 574: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy206 = ORDER_ASC; }
        break;
      case 575: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy206 = ORDER_DESC; }
        break;
      case 576: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy913 = NULL_ORDER_DEFAULT; }
        break;
      case 577: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy913 = NULL_ORDER_FIRST; }
        break;
      case 578: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy913 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
