/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 463
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  bool yy63;
  int32_t yy122;
  EOrder yy162;
  SDataType yy200;
  SNode* yy320;
  EJoinType yy334;
  int8_t yy475;
  int64_t yy483;
  SNodeList* yy570;
  SAlterOption yy695;
  ENullOrder yy715;
  EFillMode yy762;
  SToken yy815;
  EOperatorType yy828;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             727
#define YYNRULE              550
#define YYNRULE_WITH_ACTION  550
#define YYNTOKEN             326
#define YY_MAX_SHIFT         726
#define YY_MIN_SHIFTREDUCE   1075
#define YY_MAX_SHIFTREDUCE   1624
#define YY_ERROR_ACTION      1625
#define YY_ACCEPT_ACTION     1626
#define YY_NO_ACTION         1627
#define YY_MIN_REDUCE        1628
#define YY_MAX_REDUCE        2177
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2803)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */    35,  282, 1770, 1898, 2153, 1898,  233,  581, 2148, 1811,
 /*    10 */  1978, 2148,   45,   43, 1554,  361, 1896,  603, 1895,  603,
 /*    20 */   370, 1974, 1404, 1978, 2152, 1759,  580,  179, 2149, 2151,
 /*    30 */  1991, 2149,  582, 1484, 1974, 1402,   44,   42,   41,   40,
 /*    40 */    39,  538,   38,   37, 1772, 2152,   44,   42,   41,   40,
 /*    50 */    39, 1970, 1976,  352,  536, 1974,  534,  593, 1479, 1429,
 /*    60 */  1626, 2009,  626,   18, 1970, 1976,  365,  476,  375,  596,
 /*    70 */  1410, 1827, 1829,  472, 1960,  626,  632,  470,  415,  471,
 /*    80 */  1664, 1430, 1834,   45,   43, 1970, 1976,  488,  138,  338,
 /*    90 */   615,  370,  163, 1404, 1640,   14,  626,  334, 1832,  469,
 /*   100 */   616, 1990,  474, 1670, 1484, 2026, 1402, 1431,  107, 1992,
 /*   110 */   636, 1994, 1995,  631,  130,  626,  616,  723,  324, 2153,
 /*   120 */   176,  509, 2079, 2148,  385, 1879,  364, 2075,  615, 1479,
 /*   130 */   130, 1781, 1486, 1487,   18,  615,  187,  514, 1513, 2152,
 /*   140 */   181, 1410,  478, 2149, 2150,  474, 1670, 1781, 2105,  262,
 /*   150 */  2087,  592,  161,  131,  591,  581, 2009, 2148, 1108, 2148,
 /*   160 */   173, 1784, 1459, 1469,  575,   48,   14,  557, 1485, 1488,
 /*   170 */  1429, 2148,  580,  179,  580,  179,  616, 2149,  582, 2149,
 /*   180 */   582,  341, 1883, 1405,  173, 1403, 2154,  179,  723,  345,
 /*   190 */    54, 2149,  582, 1347, 1348, 1514, 1864, 1110,  265, 1113,
 /*   200 */  1114, 1332, 1333, 1486, 1487,  574, 1884, 1781, 1408, 1409,
 /*   210 */    48, 1458, 1461, 1462, 1463, 1464, 1465, 1466, 1467, 1468,
 /*   220 */   628,  624, 1477, 1478, 1480, 1481, 1482, 1483,    2, 1346,
 /*   230 */  1349,  273,  274, 1459, 1469,   60,  272,   90,  120, 1485,
 /*   240 */  1488,  119,  118,  117,  116,  115,  114,  113,  112,  111,
 /*   250 */   346,  264,  344,  343, 1405,  511, 1403,   38,   37,  513,
 /*   260 */   488,   44,   42,   41,   40,   39, 1581,   34,  368, 1508,
 /*   270 */  1509, 1510, 1511, 1512, 1516, 1517, 1518, 1519,   60, 1408,
 /*   280 */  1409,  512, 1458, 1461, 1462, 1463, 1464, 1465, 1466, 1467,
 /*   290 */  1468,  628,  624, 1477, 1478, 1480, 1481, 1482, 1483,    2,
 /*   300 */    49,   11,   45,   43, 1697, 1429, 1127,  584, 1126, 1404,
 /*   310 */   370,  140, 1404, 1979, 2050,  568, 1579, 1580, 1582, 1583,
 /*   320 */  1991,  216, 1402, 1484, 1974, 1402, 1234,  658,  657,  656,
 /*   330 */  1238,  655, 1240, 1241,  654, 1243,  651, 1128, 1249,  648,
 /*   340 */  1251, 1252,  645,  642, 1194, 1591,   60,  433, 1479,   84,
 /*   350 */    64, 2009, 1558,   18, 1970, 1976,  432, 1410, 1429,  633,
 /*   360 */  1410,  182,  104,  134, 1960,  626,  632, 1828, 1829,  524,
 /*   370 */   523,  522, 1776,   45,   43, 1489,  139,  135,  518, 1196,
 /*   380 */    60,  370,  517, 1404, 1773,   14,  182,  516,  521, 2153,
 /*   390 */    84, 1990,  164,  515, 1484, 2026, 1402, 1735,  107, 1992,
 /*   400 */   636, 1994, 1995,  631,  723,  626, 1431,  723,  141,  576,
 /*   410 */   147, 2050, 2079, 1777,   31,  217,  364, 2075, 1628, 1479,
 /*   420 */    38,   37, 1486, 1487,   44,   42,   41,   40,   39,  182,
 /*   430 */   168, 1410,   11,  408,    9,  407,  505,  501,  497,  493,
 /*   440 */   214,   60,  129,  128,  127,  126,  125,  124,  123,  122,
 /*   450 */   121,  182, 1459, 1469, 1430,  571,   46, 1494, 1485, 1488,
 /*   460 */  1629,   38,   37, 1429, 1834,   44,   42,   41,   40,   39,
 /*   470 */  1405,  350, 1403, 1405,  296, 1403,   85, 1811,  723,  212,
 /*   480 */  1832,  120, 1614, 1757,  119,  118,  117,  116,  115,  114,
 /*   490 */   113,  112,  111, 1486, 1487, 1408, 1409,  182, 1408, 1409,
 /*   500 */  1460, 1458, 1461, 1462, 1463, 1464, 1465, 1466, 1467, 1468,
 /*   510 */   628,  624, 1477, 1478, 1480, 1481, 1482, 1483,    2,  524,
 /*   520 */   523,  522, 1428, 1459, 1469,  520,  519,  135,  518, 1485,
 /*   530 */  1488,  182,  517,  479,  362,  471, 1664,  516,  521,  577,
 /*   540 */   572,  566,  161,  515, 1405,  670, 1403,  211,  205,  150,
 /*   550 */   264, 1783,  210,   38,   37,  484,  453,   44,   42,   41,
 /*   560 */    40,   39,  593,  670, 1991, 1432, 1277, 1278,  661, 1408,
 /*   570 */  1409,  203, 1458, 1461, 1462, 1463, 1464, 1465, 1466, 1467,
 /*   580 */  1468,  628,  624, 1477, 1478, 1480, 1481, 1482, 1483,    2,
 /*   590 */    45,   43,  182,  138,  662, 2009, 1651, 1825,  370,  373,
 /*   600 */  1404,   53, 1834,  633,  175, 1460,   11,  161, 1960,  358,
 /*   610 */   632, 1484,  231, 1402,  195,  194, 1783, 1821, 1832,   38,
 /*   620 */    37, 1991, 1834,   44,   42,   41,   40,   39, 1621,  363,
 /*   630 */    41,   40,   39,  593, 1834, 1990, 1479,  452, 1832, 2026,
 /*   640 */  1960,  374,  312, 1992,  636, 1994, 1995,  631, 1410,  626,
 /*   650 */  1832, 1410, 2009,  595,  177, 2087, 2088,  682,  136, 2092,
 /*   660 */   633,   45,   43,  616,  138, 1960,  616,  632,   98,  370,
 /*   670 */   376, 1404, 1650,   46,  616,   87,  329,  184,  161,  542,
 /*   680 */   413,  540, 1484, 1127, 1402, 1126,  578, 1783,  414, 1991,
 /*   690 */  1774,  618, 1990, 2051, 1781,  723, 2026, 1781, 1641,  108,
 /*   700 */  1992,  636, 1994, 1995,  631, 1781,  626, 1479,  616,  242,
 /*   710 */  1486, 1487,  232, 2079, 1128,  404, 1960, 2078, 2075, 1410,
 /*   720 */  2009, 1879,  423, 1620, 1758,  178, 2087, 2088,  630,  136,
 /*   730 */  2092,  616,  189, 1960,  616,  632,  406,  402, 1766, 1781,
 /*   740 */  1459, 1469,  694,  692,   14,  438, 1485, 1488,  439,   38,
 /*   750 */    37,   13,   12,   44,   42,   41,   40,   39, 2094, 1671,
 /*   760 */  1990, 1405, 1781, 1403, 2026, 1781,  723,  318, 1992,  636,
 /*   770 */  1994, 1995,  631,  629,  626,  617, 2044,  666, 1381, 1382,
 /*   780 */  1825, 1486, 1487, 1432, 2091,   27, 1408, 1409,  593, 1458,
 /*   790 */  1461, 1462, 1463, 1464, 1465, 1466, 1467, 1468,  628,  624,
 /*   800 */  1477, 1478, 1480, 1481, 1482, 1483,    2,  616,  718,  616,
 /*   810 */   616, 1459, 1469,  327,  513, 1427,  616, 1485, 1488,  138,
 /*   820 */   191,  486,  446,  234,  487,  460, 1834,  620,  459, 2051,
 /*   830 */  1778,  668, 1405, 1879, 1403, 1649,  512, 1515, 1781, 1432,
 /*   840 */  1781, 1781, 1833,  429,  193,  461, 1527, 1781,  431, 1429,
 /*   850 */   152,  151,  665,  664,  663,  149,   81, 1408, 1409,   80,
 /*   860 */  1458, 1461, 1462, 1463, 1464, 1465, 1466, 1467, 1468,  628,
 /*   870 */   624, 1477, 1478, 1480, 1481, 1482, 1483,    2, 1756, 1960,
 /*   880 */   180, 2087, 2088,  162,  136, 2092,   33, 2094,  302,  342,
 /*   890 */  1694,  616,   38,   37, 2094, 1551,   44,   42,   41,   40,
 /*   900 */    39,  419,  300,   70,  667,  553,   69, 1825,    8,   32,
 /*   910 */    38,   37,  588, 2090,   44,   42,   41,   40,   39, 1520,
 /*   920 */  2089,  683, 1781, 1751,  199,  466,  464,  188, 1113, 1114,
 /*   930 */   623,  457, 2099, 1547,  451,  450,  449,  448,  445,  444,
 /*   940 */   443,  442,  441,  437,  436,  435,  434,  326,  426,  425,
 /*   950 */   424, 1991,  421,  420,  340,  700,  699,  698,  697,  380,
 /*   960 */    60,  696,  695,  142,  690,  689,  688,  687,  686,  685,
 /*   970 */   684,  154,  680,  679,  678,  379,  378,  675,  674,  673,
 /*   980 */   672,  671, 2009,  241, 1648,  668,  240,   50,  616,    3,
 /*   990 */   633, 1460, 1768, 1647,  668, 1960,  616,  632, 1570,  106,
 /*  1000 */  1646, 1947,  377,   71,  152,  151,  665,  664,  663,  149,
 /*  1010 */   597,  585, 1991,  152,  151,  665,  664,  663,  149, 1781,
 /*  1020 */   552,  144, 1990,  132,  616,   88, 2026, 1781, 1960,  166,
 /*  1030 */  1992,  636, 1994, 1995,  631,  529,  626, 1960,  601, 1764,
 /*  1040 */    78,   77,  412, 2009, 1960,  186,  616,  616, 1736,  392,
 /*  1050 */   539,  596, 1645,   79,  416, 1781, 1960,  237,  632, 1644,
 /*  1060 */   602,  277,  222,  325,  230,  220,  400,  417,  398,  394,
 /*  1070 */   390,  387,  384,  224, 1991, 1505,  223, 1781, 1781,  532,
 /*  1080 */   409,  583, 2169, 1990,  526,  616,  616, 2026, 1981,  229,
 /*  1090 */   107, 1992,  636, 1994, 1995,  631, 1960,  626,  616,  611,
 /*  1100 */   613,  616,  176, 1960, 2079, 2009,  259,  226,  364, 2075,
 /*  1110 */   225,  182,  614,  633, 1547,  283, 1781, 1781, 1960, 1991,
 /*  1120 */   632,  228, 1684,  557,  227,   67,   52, 2148,   66, 1781,
 /*  1130 */  2106,  627, 1781,  556, 1623, 1624, 1983,  589, 1550, 1643,
 /*  1140 */  1642, 1639, 2154,  179,  525, 1990, 1413, 2149,  582, 2026,
 /*  1150 */  2009, 1638,  107, 1992,  636, 1994, 1995,  631,  633,  626,
 /*  1160 */  1677,  150,  660, 1960, 2168,  632, 2079, 2119, 1637, 1412,
 /*  1170 */   364, 2075,   38,   37, 1675, 1991,   44,   42,   41,   40,
 /*  1180 */    39, 2113,  527, 1960, 1960, 1960, 1636, 1635, 1634, 1633,
 /*  1190 */  1990, 1632,  569, 1631, 2026, 1960,  530,  107, 1992,  636,
 /*  1200 */  1994, 1995,  631, 2010,  626, 1991, 2009, 1888, 1156, 2168,
 /*  1210 */    62, 2079, 1960, 1379,  633,  364, 2075,  367,  366, 1960,
 /*  1220 */   215,  632,  246,   13,   12,  150, 2126, 1418,  381,   47,
 /*  1230 */  1960, 1960, 1960, 1960,  586, 1960, 2009, 1960, 1484,  270,
 /*  1240 */  1411,   68,  148, 1157,  633, 1665, 1990,  150,  253, 1960,
 /*  1250 */  2026,  632, 1822,  107, 1992,  636, 1994, 1995,  631,   62,
 /*  1260 */   626, 1991, 1578, 1479,  258, 2168,  594, 2079,   47,   47,
 /*  1270 */   261,  364, 2075,    1,  248, 1410, 1990,  600,  640,  148,
 /*  1280 */  2026, 1344,  564,  107, 1992,  636, 1994, 1995,  631, 2109,
 /*  1290 */   626,  275, 2009,  608,  279, 2168, 1416, 2079,  150, 1227,
 /*  1300 */   633,  364, 2075,  133,  676, 1960,    4,  632,  148,  386,
 /*  1310 */   391, 1521, 2142,  103,  339,  677,  599, 1366,  192, 1415,
 /*  1320 */  1470,  295,  622,  100,  418,  290, 1175, 1432,  160,  383,
 /*  1330 */  1255, 1259, 1990, 1889,  422,  427, 2026, 1173,  382,  107,
 /*  1340 */  1992,  636, 1994, 1995,  631,  455,  626, 1427,  440, 1881,
 /*  1350 */  1266, 2168,  447, 2079,  454, 1264,  545,  364, 2075,  557,
 /*  1360 */   153,  456,  462, 2148,  463,  196,  465,  467, 2098, 1433,
 /*  1370 */   468, 1991,  557, 1435,  477, 1430, 2148,  480, 2154,  179,
 /*  1380 */   202,  557,  481, 2149,  582, 2148, 1434,  204, 1419,  482,
 /*  1390 */  1414, 2154,  179, 1436,  483,  207, 2149,  582,  485,  557,
 /*  1400 */  2154,  179, 2009, 2148,  209, 2149,  582,   82,   83,  489,
 /*  1410 */   633,  213, 1130, 1422, 1424, 1960,  506,  632, 2154,  179,
 /*  1420 */   507,  508,  510, 2149,  582,  110,  624, 1477, 1478, 1480,
 /*  1430 */  1481, 1482, 1483, 1771, 1991,  219, 1937, 1767,  221,  155,
 /*  1440 */   328,  156, 1990, 1769, 1765,  157, 2026,  158,  546,  107,
 /*  1450 */  1992,  636, 1994, 1995,  631, 1936,  626,  544,   86,  235,
 /*  1460 */   547, 2054,  548, 2079,  146, 2009,  291,  364, 2075,  551,
 /*  1470 */   238,  561,  554,  633, 2110, 2120,  570, 2125, 1960, 1991,
 /*  1480 */   632,  606,  244,  567, 2101,  247,  353,  573, 2124,    7,
 /*  1490 */   579,  252,  562,  169,  560,  254,  255,  559, 2171,  256,
 /*  1500 */   354,  590,  257, 2147,  587, 1990, 1547,  137, 1431, 2026,
 /*  1510 */  2009,  260,  107, 1992,  636, 1994, 1995,  631,  633,  626,
 /*  1520 */   598, 2095,  604, 1960, 2052,  632, 2079,  357,  266,   93,
 /*  1530 */   364, 2075,  292,  293,  605, 1991, 1906,  609, 1905,  610,
 /*  1540 */  1904,  360,   95,   97, 1782,   59,  294, 2060,   99, 1752,
 /*  1550 */  1990,  297, 1826,  286, 2026,  638,  719,  107, 1992,  636,
 /*  1560 */  1994, 1995,  631,  722,  626,   51, 2009,  321,  720,  619,
 /*  1570 */   306, 2079,  301,  330,  633,  364, 2075,  320, 1954, 1960,
 /*  1580 */  1991,  632,  299,  331,  310, 1953,   75, 1952, 1951,   76,
 /*  1590 */  1948,  388,  389, 1396, 1397,  185,  393, 1946,  395,  396,
 /*  1600 */   397, 1945,  399, 1944,  401, 1943, 1990, 1942,  403,  405,
 /*  1610 */  2026, 2009, 1368,  108, 1992,  636, 1994, 1995,  631,  633,
 /*  1620 */   626, 1369, 1917, 1916, 1960, 1991,  632, 2079,  410,  411,
 /*  1630 */  1915,  621, 2075, 1914, 1872, 1871, 1323, 1869,  143, 1868,
 /*  1640 */  1867, 1870, 1991, 1866, 1865, 1863, 1862, 1861,  190,  428,
 /*  1650 */  1860,  634,  430, 1874, 1859, 2026, 2009, 1858,  108, 1992,
 /*  1660 */   636, 1994, 1995,  631,  633,  626, 1857, 1856, 1855, 1960,
 /*  1670 */  1854,  632, 2079, 2009, 1853, 1852,  333, 2075,  145, 1844,
 /*  1680 */  1843,  633, 1851, 1850, 1849, 1848, 1960, 1991,  632, 1847,
 /*  1690 */  1846, 1845, 1842, 1873, 1841, 1840, 1990, 1839, 1325, 1838,
 /*  1700 */  2026,  458, 1836,  165, 1992,  636, 1994, 1995,  631, 1837,
 /*  1710 */   626, 1835, 1202, 1990, 1699, 1698,  197, 2026, 2009,  198,
 /*  1720 */   108, 1992,  636, 1994, 1995,  631,  633,  626, 1696, 1660,
 /*  1730 */   200, 1960, 1116,  632, 2079,   73, 1115, 1659, 1930, 2076,
 /*  1740 */  1991, 1924,  174, 1913,  558, 2116,  201, 1980, 1912,   74,
 /*  1750 */   473,  475,  206,  208, 1892, 1760, 1991, 1695, 1990, 1693,
 /*  1760 */   490, 1691, 2026,  492,  491,  165, 1992,  636, 1994, 1995,
 /*  1770 */   631, 2009,  626,  496,  494,  495, 1149, 1689,  499,  633,
 /*  1780 */   498,  500, 1687,  503, 1960,  502,  632, 2009,  504, 1674,
 /*  1790 */  1673, 1656,  359, 1762, 1270,  633, 1761, 1271, 1193, 1192,
 /*  1800 */  1960, 1191,  632, 1185, 1190, 1685, 1187, 2117,  347, 1991,
 /*  1810 */  1186, 1990,   61, 1184,  691, 2026, 1678,  693,  166, 1992,
 /*  1820 */   636, 1994, 1995,  631,  348,  626,  528, 1990,  218, 1676,
 /*  1830 */   349, 2026,  531, 1655,  319, 1992,  636, 1994, 1995,  631,
 /*  1840 */  2009,  626,  533, 1654,  535, 1653,  537,  109,  630, 1386,
 /*  1850 */  1385,  541, 1388, 1960, 1929,  632, 1375, 1923,  159,  549,
 /*  1860 */    26, 1911, 1909, 2153,   19,   16,  565,  563,   20,   55,
 /*  1870 */  1593, 2170,   58,  239,   28,  243,  250,  251, 1981,  245,
 /*  1880 */  1990,  550,  167,  351, 2026,   30,   63,  318, 1992,  636,
 /*  1890 */  1994, 1995,  631,  555,  626, 1577, 2045, 1569,  249, 1991,
 /*  1900 */  1613,   29,    5,    6, 1608,   89, 1607, 1614,   21,   17,
 /*  1910 */   355,  726, 1612, 1611,  356, 1544,   57,  263, 1543, 1910,
 /*  1920 */   170, 1908, 1907, 1891, 1890,  289,   92,  607,   94,   91,
 /*  1930 */  2009,   56,  269,   22,  271,  369,   12,  276,  633,   65,
 /*  1940 */   172,  281, 1575, 1960,   96,  632,  716,  712,  708,  704,
 /*  1950 */   287,   23,  100,  278, 1991, 1420,  171,  183, 2029, 1506,
 /*  1960 */  1451, 1474, 1496,  625,  637,  639,  372,   10,  635, 1495,
 /*  1970 */  1990,  643, 1472, 1233, 2026,   36,   15,  319, 1992,  636,
 /*  1980 */  1994, 1995,  631,   24,  626, 2009,  105, 1471,   25,  280,
 /*  1990 */   371, 1443, 1256,  633,  641,  646, 1253,  644, 1960, 1250,
 /*  2000 */   632,  647,  649,  652, 1244, 1248,  650, 1991, 1242,  653,
 /*  2010 */   101,  659,  102,  284, 1265,   72, 1247, 1246, 1261, 1147,
 /*  2020 */  1245,  669,  612, 1181, 1180, 1990, 1179, 1178, 1177, 2026,
 /*  2030 */  1991, 1200,  319, 1992,  636, 1994, 1995,  631, 2009,  626,
 /*  2040 */  1176, 1174, 1172, 1171, 1170,  681,  633,  285, 1168, 1167,
 /*  2050 */  1166, 1960, 1991,  632, 1165, 1164, 1163,  268, 1162, 1195,
 /*  2060 */  1197, 2009,  267, 1159, 1158, 1155, 1154, 1153, 1152,  633,
 /*  2070 */  1692,  701, 1690,  702, 1960, 1991,  632,  703,  543, 1373,
 /*  2080 */   707,  236, 2026, 2009,  705,  314, 1992,  636, 1994, 1995,
 /*  2090 */   631,  633,  626, 1688,  706,  709, 1960, 1991,  632,  710,
 /*  2100 */   711, 1990, 1686,  713,  714, 2026, 2009, 1672,  303, 1992,
 /*  2110 */   636, 1994, 1995,  631,  633,  626,  715,  717, 1105, 1960,
 /*  2120 */  1652,  632,  288, 1990,  721,  725, 1406, 2026, 2009,  724,
 /*  2130 */   304, 1992,  636, 1994, 1995,  631,  633,  626,  298, 1627,
 /*  2140 */  1627, 1960, 1627,  632, 1627, 1627, 1990, 1627, 1627, 1627,
 /*  2150 */  2026, 1627, 1991,  305, 1992,  636, 1994, 1995,  631, 1627,
 /*  2160 */   626, 1627, 1627, 1627, 1627, 1627, 1627, 1627, 1990, 1991,
 /*  2170 */  1627, 1627, 2026, 1627, 1627,  311, 1992,  636, 1994, 1995,
 /*  2180 */   631, 1627,  626, 2009, 1627, 1627, 1627, 1627, 1627, 1627,
 /*  2190 */  1627,  633, 1627, 1627, 1627, 1627, 1960, 1627,  632, 1627,
 /*  2200 */  2009, 1627, 1627, 1627, 1627, 1627, 1627, 1627,  633, 1627,
 /*  2210 */  1627, 1627, 1627, 1960, 1991,  632, 1627, 1627, 1627, 1627,
 /*  2220 */  1627, 1627, 1627, 1990, 1627, 1627, 1627, 2026, 1627, 1627,
 /*  2230 */   315, 1992,  636, 1994, 1995,  631, 1627,  626, 1627, 1627,
 /*  2240 */  1990, 1627, 1627, 1627, 2026, 2009, 1627,  307, 1992,  636,
 /*  2250 */  1994, 1995,  631,  633,  626, 1627, 1627, 1627, 1960, 1627,
 /*  2260 */   632, 1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627,
 /*  2270 */  1991, 1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627,
 /*  2280 */  1627, 1627, 1627, 1627, 1627, 1990, 1627, 1627, 1627, 2026,
 /*  2290 */  1627, 1627,  316, 1992,  636, 1994, 1995,  631, 1627,  626,
 /*  2300 */  1991, 2009, 1627, 1627, 1627, 1627, 1627, 1627, 1627,  633,
 /*  2310 */  1627, 1627, 1627, 1627, 1960, 1627,  632, 1627, 1627, 1627,
 /*  2320 */  1627, 1627, 1627, 1991, 1627, 1627, 1627, 1627, 1627, 1627,
 /*  2330 */  1627, 2009, 1627, 1627, 1627, 1627, 1627, 1627, 1627,  633,
 /*  2340 */  1627, 1990, 1627, 1627, 1960, 2026,  632, 1627,  308, 1992,
 /*  2350 */   636, 1994, 1995,  631, 2009,  626, 1627, 1627, 1627, 1627,
 /*  2360 */  1627, 1627,  633, 1627, 1627, 1627, 1627, 1960, 1991,  632,
 /*  2370 */  1627, 1990, 1627, 1627, 1627, 2026, 1627, 1627,  317, 1992,
 /*  2380 */   636, 1994, 1995,  631, 1627,  626, 1627, 1991, 1627, 1627,
 /*  2390 */  1627, 1627, 1627, 1627, 1990, 1627, 1627, 1627, 2026, 2009,
 /*  2400 */  1627,  309, 1992,  636, 1994, 1995,  631,  633,  626, 1627,
 /*  2410 */  1627, 1627, 1960, 1991,  632, 1627, 1627, 1627, 2009, 1627,
 /*  2420 */  1627, 1627, 1627, 1627, 1627, 1627,  633, 1627, 1627, 1627,
 /*  2430 */  1627, 1960, 1627,  632, 1627, 1627, 1627, 1627, 1627, 1990,
 /*  2440 */  1627, 1627, 1627, 2026, 2009, 1627,  322, 1992,  636, 1994,
 /*  2450 */  1995,  631,  633,  626, 1627, 1627, 1627, 1960, 1990,  632,
 /*  2460 */  1627, 1627, 2026, 1627, 1627,  323, 1992,  636, 1994, 1995,
 /*  2470 */   631, 1991,  626, 1627, 1627, 1627, 1627, 1627, 1627, 1627,
 /*  2480 */  1627, 1627, 1627, 1627, 1990, 1627, 1627, 1991, 2026, 1627,
 /*  2490 */  1627, 2003, 1992,  636, 1994, 1995,  631, 1627,  626, 1627,
 /*  2500 */  1627, 1627, 2009, 1627, 1627, 1627, 1627, 1627, 1627, 1627,
 /*  2510 */   633, 1627, 1627, 1627, 1627, 1960, 1627,  632, 2009, 1627,
 /*  2520 */  1627, 1627, 1627, 1627, 1627, 1627,  633, 1627, 1627, 1627,
 /*  2530 */  1627, 1960, 1627,  632, 1627, 1627, 1627, 1627, 1627, 1627,
 /*  2540 */  1627, 1627, 1990, 1991, 1627, 1627, 2026, 1627, 1627, 2002,
 /*  2550 */  1992,  636, 1994, 1995,  631, 1627,  626, 1627, 1990, 1627,
 /*  2560 */  1991, 1627, 2026, 1627, 1627, 2001, 1992,  636, 1994, 1995,
 /*  2570 */   631, 1627,  626, 1627, 2009, 1627, 1627, 1627, 1627, 1627,
 /*  2580 */  1627, 1627,  633, 1627, 1627, 1627, 1627, 1960, 1991,  632,
 /*  2590 */  1627, 2009, 1627, 1627, 1627, 1627, 1627, 1627, 1627,  633,
 /*  2600 */  1627, 1627, 1627, 1627, 1960, 1627,  632, 1627, 1627, 1627,
 /*  2610 */  1627, 1627, 1627, 1627, 1990, 1627, 1627, 1627, 2026, 2009,
 /*  2620 */  1627,  335, 1992,  636, 1994, 1995,  631,  633,  626, 1627,
 /*  2630 */  1627, 1990, 1960, 1627,  632, 2026, 1627, 1627,  336, 1992,
 /*  2640 */   636, 1994, 1995,  631, 1991,  626, 1627, 1627, 1627, 1627,
 /*  2650 */  1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627, 1990,
 /*  2660 */  1627, 1991, 1627, 2026, 1627, 1627,  332, 1992,  636, 1994,
 /*  2670 */  1995,  631, 1627,  626, 1627, 2009, 1627, 1627, 1627, 1627,
 /*  2680 */  1627, 1627, 1627,  633, 1627, 1627, 1627, 1627, 1960, 1627,
 /*  2690 */   632, 1627, 2009, 1627, 1627, 1627, 1627, 1627, 1627, 1627,
 /*  2700 */   633, 1627, 1627, 1627, 1627, 1960, 1627,  632, 1627, 1627,
 /*  2710 */  1627, 1627, 1627, 1627, 1627, 1990, 1627, 1991, 1627, 2026,
 /*  2720 */  1627, 1627,  337, 1992,  636, 1994, 1995,  631, 1627,  626,
 /*  2730 */  1627, 1627,  634, 1627, 1627, 1627, 2026, 1627, 1627,  314,
 /*  2740 */  1992,  636, 1994, 1995,  631, 1627,  626, 1627, 2009, 1627,
 /*  2750 */  1627, 1627, 1627, 1627, 1627, 1627,  633, 1627, 1627, 1627,
 /*  2760 */  1627, 1960, 1627,  632, 1627, 1627, 1627, 1627, 1627, 1627,
 /*  2770 */  1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627,
 /*  2780 */  1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627, 1990, 1627,
 /*  2790 */  1627, 1627, 2026, 1627, 1627,  313, 1992,  636, 1994, 1995,
 /*  2800 */   631, 1627,  626,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   422,  423,  361,  375,  433,  375,  353,  433,  437,  356,
 /*    10 */   362,  437,   12,   13,   14,  385,  388,  389,  388,  389,
 /*    20 */    20,  373,   22,  362,  453,    0,  452,  453,  457,  458,
 /*    30 */   329,  457,  458,   33,  373,   35,   12,   13,   14,   15,
 /*    40 */    16,   21,    8,    9,  362,    3,   12,   13,   14,   15,
 /*    50 */    16,  403,  404,  405,   34,  373,   36,  337,   58,   20,
 /*    60 */   326,  360,  414,   63,  403,  404,  405,   14,  371,  368,
 /*    70 */    70,  374,  375,   20,  373,  414,  375,  333,  337,  335,
 /*    80 */   336,   20,  360,   12,   13,  403,  404,   62,  368,  367,
 /*    90 */    20,   20,  328,   22,  330,   95,  414,   63,  376,  334,
 /*   100 */   337,  400,  337,  338,   33,  404,   35,   20,  407,  408,
 /*   110 */   409,  410,  411,  412,  351,  414,  337,  117,  377,  433,
 /*   120 */   419,  358,  421,  437,  390,  368,  425,  426,   20,   58,
 /*   130 */   351,  368,  132,  133,   63,   20,  379,  358,  104,  453,
 /*   140 */   439,   70,  334,  457,  458,  337,  338,  368,  447,  429,
 /*   150 */   430,  431,  360,  433,  434,  433,  360,  437,    4,  437,
 /*   160 */   360,  369,  162,  163,  368,   95,   95,  433,  168,  169,
 /*   170 */    20,  437,  452,  453,  452,  453,  337,  457,  458,  457,
 /*   180 */   458,  381,  382,  183,  360,  185,  452,  453,  117,   37,
 /*   190 */   351,  457,  458,  132,  133,  161,    0,   43,   58,   45,
 /*   200 */    46,  162,  163,  132,  133,  409,  382,  368,  208,  209,
 /*   210 */    95,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  168,
 /*   230 */   169,  126,  127,  162,  163,   95,  131,   97,   21,  168,
 /*   240 */   169,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   250 */    98,  164,  100,  101,  183,  103,  185,    8,    9,  107,
 /*   260 */    62,   12,   13,   14,   15,   16,  208,  233,  234,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,  242,  243,   95,  208,
 /*   280 */   209,  129,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   290 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*   300 */    95,  230,   12,   13,    0,   20,   20,  265,   22,   22,
 /*   310 */    20,  417,   22,  362,  420,  257,  258,  259,  260,  261,
 /*   320 */   329,   35,   35,   33,  373,   35,  108,  109,  110,  111,
 /*   330 */   112,  113,  114,  115,  116,  117,  118,   51,  120,  121,
 /*   340 */   122,  123,  124,  125,   35,   96,   95,  151,   58,  343,
 /*   350 */     4,  360,   14,   63,  403,  404,  160,   70,   20,  368,
 /*   360 */    70,  246,  341,  357,  373,  414,  375,  374,  375,   65,
 /*   370 */    66,   67,  366,   12,   13,   14,  355,   73,   74,   70,
 /*   380 */    95,   20,   78,   22,  363,   95,  246,   83,   84,    3,
 /*   390 */   343,  400,  344,   89,   33,  404,   35,  349,  407,  408,
 /*   400 */   409,  410,  411,  412,  117,  414,   20,  117,  417,   20,
 /*   410 */   419,  420,  421,  366,    2,   33,  425,  426,    0,   58,
 /*   420 */     8,    9,  132,  133,   12,   13,   14,   15,   16,  246,
 /*   430 */    48,   70,  230,  182,  232,  184,   54,   55,   56,   57,
 /*   440 */    58,   95,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   450 */    32,  246,  162,  163,   20,  167,   95,   14,  168,  169,
 /*   460 */     0,    8,    9,   20,  360,   12,   13,   14,   15,   16,
 /*   470 */   183,  367,  185,  183,  353,  185,   94,  356,  117,   97,
 /*   480 */   376,   21,   96,    0,   24,   25,   26,   27,   28,   29,
 /*   490 */    30,   31,   32,  132,  133,  208,  209,  246,  208,  209,
 /*   500 */   162,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   510 */   220,  221,  222,  223,  224,  225,  226,  227,  228,   65,
 /*   520 */    66,   67,   20,  162,  163,  346,  347,   73,   74,  168,
 /*   530 */   169,  246,   78,  333,  352,  335,  336,   83,   84,  251,
 /*   540 */   252,  253,  360,   89,  183,   62,  185,  165,  166,   44,
 /*   550 */   164,  369,  170,    8,    9,  173,   79,   12,   13,   14,
 /*   560 */    15,   16,  337,   62,  329,   20,  132,  133,  106,  208,
 /*   570 */   209,  189,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   580 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*   590 */    12,   13,  246,  368,  370,  360,  329,  373,   20,  352,
 /*   600 */    22,   96,  360,  368,  359,  162,  230,  360,  373,  367,
 /*   610 */   375,   33,  127,   35,  137,  138,  369,  372,  376,    8,
 /*   620 */     9,  329,  360,   12,   13,   14,   15,   16,  175,  367,
 /*   630 */    14,   15,   16,  337,  360,  400,   58,  160,  376,  404,
 /*   640 */   373,  367,  407,  408,  409,  410,  411,  412,   70,  414,
 /*   650 */   376,   70,  360,  428,  429,  430,  431,   70,  433,  434,
 /*   660 */   368,   12,   13,  337,  368,  373,  337,  375,  341,   20,
 /*   670 */   352,   22,  329,   95,  337,  190,  191,  351,  360,  194,
 /*   680 */   351,  196,   33,   20,   35,   22,  451,  369,  351,  329,
 /*   690 */   363,  418,  400,  420,  368,  117,  404,  368,  330,  407,
 /*   700 */   408,  409,  410,  411,  412,  368,  414,   58,  337,  164,
 /*   710 */   132,  133,  126,  421,   51,  178,  373,  425,  426,   70,
 /*   720 */   360,  368,  351,  270,    0,  429,  430,  431,  368,  433,
 /*   730 */   434,  337,  379,  373,  337,  375,  199,  200,  361,  368,
 /*   740 */   162,  163,  346,  347,   95,  351,  168,  169,  351,    8,
 /*   750 */     9,    1,    2,   12,   13,   14,   15,   16,  406,    0,
 /*   760 */   400,  183,  368,  185,  404,  368,  117,  407,  408,  409,
 /*   770 */   410,  411,  412,  413,  414,  415,  416,  370,  192,  193,
 /*   780 */   373,  132,  133,   20,  432,   44,  208,  209,  337,  211,
 /*   790 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   800 */   222,  223,  224,  225,  226,  227,  228,  337,   49,  337,
 /*   810 */   337,  162,  163,   18,  107,   20,  337,  168,  169,  368,
 /*   820 */    58,  351,   27,  351,  351,   30,  360,  418,   33,  420,
 /*   830 */   351,  107,  183,  368,  185,  329,  129,  161,  368,   20,
 /*   840 */   368,  368,  376,   48,  379,   50,   96,  368,   53,   20,
 /*   850 */   126,  127,  128,  129,  130,  131,   94,  208,  209,   97,
 /*   860 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   870 */   221,  222,  223,  224,  225,  226,  227,  228,    0,  373,
 /*   880 */   429,  430,  431,   18,  433,  434,    2,  406,   23,   94,
 /*   890 */     0,  337,    8,    9,  406,    4,   12,   13,   14,   15,
 /*   900 */    16,  106,   37,   38,  370,  351,   41,  373,   39,  233,
 /*   910 */     8,    9,   44,  432,   12,   13,   14,   15,   16,  243,
 /*   920 */   432,  348,  368,  350,   59,   60,   61,  164,   45,   46,
 /*   930 */    63,  136,  244,  245,  139,  140,  141,  142,  143,  144,
 /*   940 */   145,  146,  147,  148,  149,  150,  151,  152,  153,  154,
 /*   950 */   155,  329,  157,  158,  159,   65,   66,   67,   68,   69,
 /*   960 */    95,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   970 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   980 */    90,   91,  360,  164,  329,  107,   58,   42,  337,   44,
 /*   990 */   368,  162,  361,  329,  107,  373,  337,  375,   96,  134,
 /*  1000 */   329,    0,  351,  106,  126,  127,  128,  129,  130,  131,
 /*  1010 */   351,   44,  329,  126,  127,  128,  129,  130,  131,  368,
 /*  1020 */   394,   42,  400,   44,  337,   97,  404,  368,  373,  407,
 /*  1030 */   408,  409,  410,  411,  412,    4,  414,  373,  351,  361,
 /*  1040 */   175,  176,  177,  360,  373,  180,  337,  337,  349,   48,
 /*  1050 */    19,  368,  329,  156,   22,  368,  373,  361,  375,  329,
 /*  1060 */   351,  351,   99,  198,   33,  102,  201,   35,  203,  204,
 /*  1070 */   205,  206,  207,   99,  329,  208,  102,  368,  368,   48,
 /*  1080 */   390,  459,  460,  400,   53,  337,  337,  404,   47,   58,
 /*  1090 */   407,  408,  409,  410,  411,  412,  373,  414,  337,  351,
 /*  1100 */   351,  337,  419,  373,  421,  360,  461,   99,  425,  426,
 /*  1110 */   102,  246,  351,  368,  245,  351,  368,  368,  373,  329,
 /*  1120 */   375,   99,    0,  433,  102,   94,  164,  437,   97,  368,
 /*  1130 */   447,  361,  368,  171,  132,  133,   95,  269,  247,  329,
 /*  1140 */   329,  329,  452,  453,   22,  400,   35,  457,  458,  404,
 /*  1150 */   360,  329,  407,  408,  409,  410,  411,  412,  368,  414,
 /*  1160 */     0,   44,  361,  373,  419,  375,  421,  383,  329,   35,
 /*  1170 */   425,  426,    8,    9,    0,  329,   12,   13,   14,   15,
 /*  1180 */    16,  436,   22,  373,  373,  373,  329,  329,  329,  329,
 /*  1190 */   400,  329,  450,  329,  404,  373,   22,  407,  408,  409,
 /*  1200 */   410,  411,  412,  360,  414,  329,  360,  383,   35,  419,
 /*  1210 */    44,  421,  373,   96,  368,  425,  426,   12,   13,  373,
 /*  1220 */   339,  375,   44,    1,    2,   44,  436,   22,  339,   44,
 /*  1230 */   373,  373,  373,  373,  267,  373,  360,  373,   33,   44,
 /*  1240 */    35,   44,   44,   70,  368,  336,  400,   44,  444,  373,
 /*  1250 */   404,  375,  372,  407,  408,  409,  410,  411,  412,   44,
 /*  1260 */   414,  329,   96,   58,  427,  419,  435,  421,   44,   44,
 /*  1270 */   454,  425,  426,  438,   96,   70,  400,   96,   44,   44,
 /*  1280 */   404,   96,  436,  407,  408,  409,  410,  411,  412,  383,
 /*  1290 */   414,   96,  360,   96,   96,  419,  185,  421,   44,   96,
 /*  1300 */   368,  425,  426,   44,   13,  373,  248,  375,   44,  402,
 /*  1310 */    48,   96,  436,   95,  401,   13,  390,  181,   42,  185,
 /*  1320 */    96,   96,  117,  105,  380,  392,   35,   20,  164,  390,
 /*  1330 */    96,   96,  400,  383,  380,  378,  404,   35,  390,  407,
 /*  1340 */   408,  409,  410,  411,  412,  161,  414,   20,  337,  337,
 /*  1350 */    96,  419,  380,  421,  378,   96,  390,  425,  426,  433,
 /*  1360 */    96,  378,   93,  437,  345,  337,  337,  337,  436,   20,
 /*  1370 */   331,  329,  433,   20,  331,   20,  437,  396,  452,  453,
 /*  1380 */   343,  433,  375,  457,  458,  437,   20,  343,  183,  338,
 /*  1390 */   185,  452,  453,   20,  391,  343,  457,  458,  338,  433,
 /*  1400 */   452,  453,  360,  437,  343,  457,  458,  343,  343,  337,
 /*  1410 */   368,  343,   52,  208,  209,  373,  340,  375,  452,  453,
 /*  1420 */   340,  331,  360,  457,  458,  337,  221,  222,  223,  224,
 /*  1430 */   225,  226,  227,  360,  329,  360,  373,  360,  360,  360,
 /*  1440 */   331,  360,  400,  360,  360,  360,  404,  360,  399,  407,
 /*  1450 */   408,  409,  410,  411,  412,  373,  414,  197,   95,  341,
 /*  1460 */   188,  419,  395,  421,  398,  360,  396,  425,  426,  375,
 /*  1470 */   341,  373,  337,  368,  383,  383,  256,  443,  373,  329,
 /*  1480 */   375,  255,  386,  373,  446,  386,  373,  373,  443,  262,
 /*  1490 */   174,  445,  264,  443,  263,  442,  441,  249,  462,  440,
 /*  1500 */   271,  268,  402,  456,  266,  400,  245,  368,   20,  404,
 /*  1510 */   360,  455,  407,  408,  409,  410,  411,  412,  368,  414,
 /*  1520 */   337,  406,  373,  373,  419,  375,  421,  338,  341,  341,
 /*  1530 */   425,  426,  386,  386,  373,  329,  373,  166,  373,  384,
 /*  1540 */   373,  373,  341,  341,  368,   95,  356,  424,   95,  350,
 /*  1550 */   400,  337,  373,  341,  404,  364,   36,  407,  408,  409,
 /*  1560 */   410,  411,  412,  331,  414,  393,  360,  397,  332,  419,
 /*  1570 */   354,  421,  327,  387,  368,  425,  426,  354,    0,  373,
 /*  1580 */   329,  375,  342,  387,  354,    0,  190,    0,    0,   42,
 /*  1590 */     0,   35,  202,   35,   35,   35,  202,    0,   35,   35,
 /*  1600 */   202,    0,  202,    0,   35,    0,  400,    0,   22,   35,
 /*  1610 */   404,  360,  183,  407,  408,  409,  410,  411,  412,  368,
 /*  1620 */   414,  185,    0,    0,  373,  329,  375,  421,  179,  178,
 /*  1630 */     0,  425,  426,    0,    0,    0,   47,    0,   42,    0,
 /*  1640 */     0,    0,  329,    0,    0,    0,    0,    0,  151,   35,
 /*  1650 */     0,  400,  151,    0,    0,  404,  360,    0,  407,  408,
 /*  1660 */   409,  410,  411,  412,  368,  414,    0,    0,    0,  373,
 /*  1670 */     0,  375,  421,  360,    0,    0,  425,  426,   42,    0,
 /*  1680 */     0,  368,    0,    0,    0,    0,  373,  329,  375,    0,
 /*  1690 */     0,    0,    0,    0,    0,    0,  400,    0,   22,    0,
 /*  1700 */   404,  135,    0,  407,  408,  409,  410,  411,  412,    0,
 /*  1710 */   414,    0,   35,  400,    0,    0,   58,  404,  360,   58,
 /*  1720 */   407,  408,  409,  410,  411,  412,  368,  414,    0,    0,
 /*  1730 */    42,  373,   14,  375,  421,   39,   14,    0,    0,  426,
 /*  1740 */   329,    0,   44,    0,  448,  449,   40,   47,    0,   39,
 /*  1750 */    47,   47,   39,  174,    0,    0,  329,    0,  400,    0,
 /*  1760 */    35,    0,  404,   39,   48,  407,  408,  409,  410,  411,
 /*  1770 */   412,  360,  414,   39,   35,   48,   64,    0,   48,  368,
 /*  1780 */    35,   39,    0,   48,  373,   35,  375,  360,   39,    0,
 /*  1790 */     0,    0,  365,    0,   22,  368,    0,   35,   35,   35,
 /*  1800 */   373,   35,  375,   22,   35,    0,   35,  449,   22,  329,
 /*  1810 */    35,  400,  104,   35,   44,  404,    0,   44,  407,  408,
 /*  1820 */   409,  410,  411,  412,   22,  414,   50,  400,  102,    0,
 /*  1830 */    22,  404,   35,    0,  407,  408,  409,  410,  411,  412,
 /*  1840 */   360,  414,   35,    0,   35,    0,   22,   20,  368,   35,
 /*  1850 */    35,  195,   96,  373,    0,  375,   35,    0,  186,   22,
 /*  1860 */    95,    0,    0,    3,   44,  250,  254,  229,  250,  164,
 /*  1870 */    96,  460,   44,  166,   95,   95,   44,   47,   47,   96,
 /*  1880 */   400,  164,   95,  164,  404,   44,    3,  407,  408,  409,
 /*  1890 */   410,  411,  412,  172,  414,   96,  416,   96,   95,  329,
 /*  1900 */    96,   95,  171,  171,   35,   95,   35,   96,   44,  250,
 /*  1910 */    35,   19,   35,   35,   35,   96,   44,   47,   96,    0,
 /*  1920 */    47,    0,    0,    0,    0,   33,   39,  167,   39,   95,
 /*  1930 */   360,  244,   96,   95,   95,  365,    2,   95,  368,   95,
 /*  1940 */    48,   47,   96,  373,   95,  375,   54,   55,   56,   57,
 /*  1950 */    58,   44,  105,  165,  329,   22,   47,   47,   95,  208,
 /*  1960 */    22,   96,  229,   95,  106,   35,   35,  231,  210,  229,
 /*  1970 */   400,   35,   96,   22,  404,   95,   95,  407,  408,  409,
 /*  1980 */   410,  411,  412,   95,  414,  360,   94,   96,   95,   97,
 /*  1990 */   365,   96,   96,  368,   95,   35,   96,   95,  373,   96,
 /*  2000 */   375,   95,   35,   35,   96,  119,   95,  329,   96,   95,
 /*  2010 */    95,  107,   95,   44,   35,   95,  119,  119,   22,   64,
 /*  2020 */   119,   63,  130,   35,   35,  400,   35,   35,   35,  404,
 /*  2030 */   329,   70,  407,  408,  409,  410,  411,  412,  360,  414,
 /*  2040 */    35,   35,   35,   35,   35,   92,  368,   44,   35,   35,
 /*  2050 */    35,  373,  329,  375,   22,   35,   35,  165,   35,   35,
 /*  2060 */    70,  360,  170,   35,   35,   35,   35,   22,   35,  368,
 /*  2070 */     0,   35,    0,   48,  373,  329,  375,   39,  400,  187,
 /*  2080 */    39,  189,  404,  360,   35,  407,  408,  409,  410,  411,
 /*  2090 */   412,  368,  414,    0,   48,   35,  373,  329,  375,   48,
 /*  2100 */    39,  400,    0,   35,   48,  404,  360,    0,  407,  408,
 /*  2110 */   409,  410,  411,  412,  368,  414,   39,   35,   35,  373,
 /*  2120 */     0,  375,   22,  400,   21,   20,   22,  404,  360,   21,
 /*  2130 */   407,  408,  409,  410,  411,  412,  368,  414,   22,  463,
 /*  2140 */   463,  373,  463,  375,  463,  463,  400,  463,  463,  463,
 /*  2150 */   404,  463,  329,  407,  408,  409,  410,  411,  412,  463,
 /*  2160 */   414,  463,  463,  463,  463,  463,  463,  463,  400,  329,
 /*  2170 */   463,  463,  404,  463,  463,  407,  408,  409,  410,  411,
 /*  2180 */   412,  463,  414,  360,  463,  463,  463,  463,  463,  463,
 /*  2190 */   463,  368,  463,  463,  463,  463,  373,  463,  375,  463,
 /*  2200 */   360,  463,  463,  463,  463,  463,  463,  463,  368,  463,
 /*  2210 */   463,  463,  463,  373,  329,  375,  463,  463,  463,  463,
 /*  2220 */   463,  463,  463,  400,  463,  463,  463,  404,  463,  463,
 /*  2230 */   407,  408,  409,  410,  411,  412,  463,  414,  463,  463,
 /*  2240 */   400,  463,  463,  463,  404,  360,  463,  407,  408,  409,
 /*  2250 */   410,  411,  412,  368,  414,  463,  463,  463,  373,  463,
 /*  2260 */   375,  463,  463,  463,  463,  463,  463,  463,  463,  463,
 /*  2270 */   329,  463,  463,  463,  463,  463,  463,  463,  463,  463,
 /*  2280 */   463,  463,  463,  463,  463,  400,  463,  463,  463,  404,
 /*  2290 */   463,  463,  407,  408,  409,  410,  411,  412,  463,  414,
 /*  2300 */   329,  360,  463,  463,  463,  463,  463,  463,  463,  368,
 /*  2310 */   463,  463,  463,  463,  373,  463,  375,  463,  463,  463,
 /*  2320 */   463,  463,  463,  329,  463,  463,  463,  463,  463,  463,
 /*  2330 */   463,  360,  463,  463,  463,  463,  463,  463,  463,  368,
 /*  2340 */   463,  400,  463,  463,  373,  404,  375,  463,  407,  408,
 /*  2350 */   409,  410,  411,  412,  360,  414,  463,  463,  463,  463,
 /*  2360 */   463,  463,  368,  463,  463,  463,  463,  373,  329,  375,
 /*  2370 */   463,  400,  463,  463,  463,  404,  463,  463,  407,  408,
 /*  2380 */   409,  410,  411,  412,  463,  414,  463,  329,  463,  463,
 /*  2390 */   463,  463,  463,  463,  400,  463,  463,  463,  404,  360,
 /*  2400 */   463,  407,  408,  409,  410,  411,  412,  368,  414,  463,
 /*  2410 */   463,  463,  373,  329,  375,  463,  463,  463,  360,  463,
 /*  2420 */   463,  463,  463,  463,  463,  463,  368,  463,  463,  463,
 /*  2430 */   463,  373,  463,  375,  463,  463,  463,  463,  463,  400,
 /*  2440 */   463,  463,  463,  404,  360,  463,  407,  408,  409,  410,
 /*  2450 */   411,  412,  368,  414,  463,  463,  463,  373,  400,  375,
 /*  2460 */   463,  463,  404,  463,  463,  407,  408,  409,  410,  411,
 /*  2470 */   412,  329,  414,  463,  463,  463,  463,  463,  463,  463,
 /*  2480 */   463,  463,  463,  463,  400,  463,  463,  329,  404,  463,
 /*  2490 */   463,  407,  408,  409,  410,  411,  412,  463,  414,  463,
 /*  2500 */   463,  463,  360,  463,  463,  463,  463,  463,  463,  463,
 /*  2510 */   368,  463,  463,  463,  463,  373,  463,  375,  360,  463,
 /*  2520 */   463,  463,  463,  463,  463,  463,  368,  463,  463,  463,
 /*  2530 */   463,  373,  463,  375,  463,  463,  463,  463,  463,  463,
 /*  2540 */   463,  463,  400,  329,  463,  463,  404,  463,  463,  407,
 /*  2550 */   408,  409,  410,  411,  412,  463,  414,  463,  400,  463,
 /*  2560 */   329,  463,  404,  463,  463,  407,  408,  409,  410,  411,
 /*  2570 */   412,  463,  414,  463,  360,  463,  463,  463,  463,  463,
 /*  2580 */   463,  463,  368,  463,  463,  463,  463,  373,  329,  375,
 /*  2590 */   463,  360,  463,  463,  463,  463,  463,  463,  463,  368,
 /*  2600 */   463,  463,  463,  463,  373,  463,  375,  463,  463,  463,
 /*  2610 */   463,  463,  463,  463,  400,  463,  463,  463,  404,  360,
 /*  2620 */   463,  407,  408,  409,  410,  411,  412,  368,  414,  463,
 /*  2630 */   463,  400,  373,  463,  375,  404,  463,  463,  407,  408,
 /*  2640 */   409,  410,  411,  412,  329,  414,  463,  463,  463,  463,
 /*  2650 */   463,  463,  463,  463,  463,  463,  463,  463,  463,  400,
 /*  2660 */   463,  329,  463,  404,  463,  463,  407,  408,  409,  410,
 /*  2670 */   411,  412,  463,  414,  463,  360,  463,  463,  463,  463,
 /*  2680 */   463,  463,  463,  368,  463,  463,  463,  463,  373,  463,
 /*  2690 */   375,  463,  360,  463,  463,  463,  463,  463,  463,  463,
 /*  2700 */   368,  463,  463,  463,  463,  373,  463,  375,  463,  463,
 /*  2710 */   463,  463,  463,  463,  463,  400,  463,  329,  463,  404,
 /*  2720 */   463,  463,  407,  408,  409,  410,  411,  412,  463,  414,
 /*  2730 */   463,  463,  400,  463,  463,  463,  404,  463,  463,  407,
 /*  2740 */   408,  409,  410,  411,  412,  463,  414,  463,  360,  463,
 /*  2750 */   463,  463,  463,  463,  463,  463,  368,  463,  463,  463,
 /*  2760 */   463,  373,  463,  375,  463,  463,  463,  463,  463,  463,
 /*  2770 */   463,  463,  463,  463,  463,  463,  463,  463,  463,  463,
 /*  2780 */   463,  463,  463,  463,  463,  463,  463,  463,  400,  463,
 /*  2790 */   463,  463,  404,  463,  463,  407,  408,  409,  410,  411,
 /*  2800 */   412,  463,  414,  326,  326,  326,  326,  326,  326,  326,
 /*  2810 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2820 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2830 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2840 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2850 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2860 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2870 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2880 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2890 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2900 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2910 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2920 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2930 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2940 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2950 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2960 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2970 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2980 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2990 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3000 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3010 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3020 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3030 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3040 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3050 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3060 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3070 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3080 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3090 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3100 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3110 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  3120 */   326,  326,  326,  326,  326,  326,  326,  326,  326,
};
#define YY_SHIFT_COUNT    (726)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2120)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   865,    0,   71,    0,  290,  290,  290,  290,  290,  290,
 /*    10 */   290,  290,  290,  290,  290,  361,  578,  578,  649,  578,
 /*    20 */   578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
 /*    30 */   578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
 /*    40 */   578,  578,  578,  578,  578,  578,  578,  578,  115,  285,
 /*    50 */    70,  251,  140,  183,  205,  183,   70,   70, 1205, 1205,
 /*    60 */   183, 1205, 1205,  346,  183,   61,  108,  108,   61,  154,
 /*    70 */   154,   39,  434,   53,   53,  108,  108,  108,  108,  108,
 /*    80 */   108,  108,  108,  108,  108,  198,  150,  108,  108,  389,
 /*    90 */   108,  150,  108,  108,  108,  108,  150,  108,  108,  150,
 /*   100 */   108,  150,  150,  150,  108,  501,  795,   34,   34,  217,
 /*   110 */   454,  287,  287,  287,  287,  287,  287,  287,  287,  287,
 /*   120 */   287,  287,  287,  287,  287,  287,  287,  287,  287,  287,
 /*   130 */   152,  386,   39,  434,   25,  309,   87,   87,   87,  483,
 /*   140 */   202,  202,  309,  502,  502,  502,  462,  376,  150,  581,
 /*   150 */   150,  581,  581,  462,  587,  218,  218,  218,  218,  218,
 /*   160 */   218,  218, 1892,  460,  304,  545,  453,   58,  286,  288,
 /*   170 */   338,  443,  663,  763,  883,  707,  819,  688,  869,   42,
 /*   180 */   688,  945,  891,  829, 1058, 1262, 1136, 1276, 1307, 1276,
 /*   190 */  1184, 1327, 1327, 1276, 1184, 1184, 1269, 1327, 1327, 1327,
 /*   200 */  1349, 1349, 1353,  198, 1355,  198, 1366, 1373,  198, 1366,
 /*   210 */   198,  198,  198, 1327,  198, 1360, 1360, 1349,  150,  150,
 /*   220 */   150,  150,  150,  150,  150,  150,  150,  150,  150, 1327,
 /*   230 */  1349,  581,  581, 1260, 1363, 1353,  501, 1272, 1355,  501,
 /*   240 */  1327, 1307, 1307,  581, 1220, 1226,  581, 1220, 1226,  581,
 /*   250 */   581,  150, 1227, 1316, 1220, 1228, 1231, 1248, 1058, 1229,
 /*   260 */  1233, 1238, 1261,  502, 1488, 1327, 1366,  501,  501, 1226,
 /*   270 */   581,  581,  581,  581,  581, 1226,  581, 1371,  501,  462,
 /*   280 */   501,  502, 1450, 1453,  581,  587, 1327,  501, 1520, 1349,
 /*   290 */  2803, 2803, 2803, 2803, 2803, 2803, 2803, 2803, 2803,  890,
 /*   300 */   382,  418, 1031,  249,  741,  902,  724,  412,  884, 1164,
 /*   310 */   878,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*   320 */   887,  485,   24,   24,  477,  537,  196,  762,   20,  586,
 /*   330 */   105,  105,  616,  750,  676,  616,  616,  616,  505, 1001,
 /*   340 */  1032,  979,  897,  963,  974, 1008, 1022, 1122, 1160, 1174,
 /*   350 */  1117,  928, 1166, 1178, 1002,  967,  868,  962, 1181, 1185,
 /*   360 */  1195, 1197, 1198, 1203, 1222, 1215, 1111, 1134,  867, 1224,
 /*   370 */  1041, 1225, 1234, 1235, 1254, 1259, 1264, 1218, 1291, 1302,
 /*   380 */  1173,  759, 1578, 1585, 1396, 1587, 1588, 1547, 1590, 1556,
 /*   390 */  1390, 1558, 1559, 1560, 1394, 1597, 1563, 1564, 1398, 1601,
 /*   400 */  1400, 1603, 1569, 1605, 1586, 1607, 1574, 1436, 1429, 1622,
 /*   410 */  1623, 1449, 1451, 1630, 1633, 1589, 1634, 1635, 1637, 1596,
 /*   420 */  1639, 1640, 1641, 1643, 1644, 1645, 1646, 1647, 1497, 1614,
 /*   430 */  1650, 1501, 1653, 1654, 1657, 1666, 1667, 1668, 1670, 1674,
 /*   440 */  1675, 1682, 1683, 1684, 1685, 1689, 1690, 1691, 1636, 1679,
 /*   450 */  1680, 1692, 1693, 1694, 1695, 1676, 1697, 1699, 1709, 1566,
 /*   460 */  1702, 1711, 1677, 1714, 1658, 1715, 1661, 1728, 1729, 1688,
 /*   470 */  1696, 1698, 1700, 1718, 1703, 1722, 1704, 1737, 1706, 1710,
 /*   480 */  1738, 1741, 1743, 1713, 1579, 1748, 1754, 1755, 1712, 1757,
 /*   490 */  1759, 1725, 1716, 1724, 1761, 1739, 1727, 1734, 1777, 1745,
 /*   500 */  1730, 1742, 1782, 1750, 1735, 1749, 1789, 1790, 1791, 1793,
 /*   510 */  1708, 1726, 1762, 1772, 1796, 1763, 1764, 1766, 1769, 1770,
 /*   520 */  1773, 1771, 1775, 1781, 1778, 1805, 1786, 1816, 1802, 1776,
 /*   530 */  1829, 1808, 1797, 1833, 1807, 1843, 1809, 1845, 1824, 1827,
 /*   540 */  1814, 1815, 1656, 1756, 1765, 1854, 1705, 1821, 1857, 1672,
 /*   550 */  1837, 1717, 1707, 1861, 1862, 1719, 1721, 1860, 1820, 1615,
 /*   560 */  1779, 1774, 1780, 1731, 1638, 1732, 1612, 1783, 1828, 1799,
 /*   570 */  1787, 1803, 1806, 1801, 1832, 1830, 1831, 1810, 1841, 1618,
 /*   580 */  1804, 1811, 1883, 1864, 1659, 1869, 1871, 1875, 1877, 1878,
 /*   590 */  1879, 1819, 1822, 1870, 1687, 1872, 1873, 1919, 1921, 1922,
 /*   600 */  1923, 1834, 1887, 1838, 1836, 1846, 1839, 1842, 1760, 1844,
 /*   610 */  1924, 1889, 1788, 1849, 1847, 1700, 1894, 1907, 1733, 1736,
 /*   620 */  1740, 1934, 1933, 1751, 1863, 1865, 1868, 1876, 1880, 1891,
 /*   630 */  1909, 1881, 1888, 1910, 1895, 1938, 1758, 1893, 1858, 1896,
 /*   640 */  1930, 1931, 1899, 1900, 1936, 1902, 1903, 1960, 1906, 1908,
 /*   650 */  1967, 1911, 1912, 1968, 1914, 1886, 1897, 1898, 1901, 1951,
 /*   660 */  1904, 1915, 1969, 1917, 1979, 1920, 1969, 1969, 1996, 1955,
 /*   670 */  1958, 1988, 1989, 1991, 1992, 1993, 2005, 2006, 2007, 2008,
 /*   680 */  2009, 1961, 1953, 2003, 2013, 2014, 2015, 2032, 2020, 2021,
 /*   690 */  2023, 1990, 1770, 2024, 1773, 2028, 2029, 2030, 2031, 2045,
 /*   700 */  2033, 2070, 2036, 2025, 2038, 2072, 2049, 2046, 2041, 2093,
 /*   710 */  2060, 2051, 2061, 2102, 2068, 2056, 2077, 2107, 2082, 2083,
 /*   720 */  2120, 2100, 2103, 2104, 2116, 2108, 2105,
};
#define YY_REDUCE_COUNT (298)
#define YY_REDUCE_MIN   (-429)
#define YY_REDUCE_MAX   (2388)
static const short yy_reduce_ofst[] = {
 /*     0 */  -266, -299,   -9,  683,  745,  790,  846,  876,  932, 1042,
 /*    10 */  1105, 1150,  292, 1206, 1251,  360, 1296,  622, 1313, 1358,
 /*    20 */   235, 1411, 1427, 1480, 1570, 1625, 1678, 1701, 1723, 1746,
 /*    30 */  1768, 1823, 1840, 1885, 1941, 1971, 1994, 2039, 2058, 2084,
 /*    40 */  2142, 2158, 2214, 2231, 2259, 2315, 2332, 2388, -280, -278,
 /*    50 */   225,  690,  926,  939,  948,  966,  296,  451, -352, -339,
 /*    60 */  -426, -318,  -49, -429, -314, -370, -237, -221, -372, -256,
 /*    70 */   200, -200, -303, -235, -192, -161,  326,  329,  337,  371,
 /*    80 */   394,  397,  470,  473,  479,    6,  104,  472,  554, -204,
 /*    90 */   659,  242,  687,  709,  710,  748,  182,  749,  761,  262,
 /*   100 */   764,  247,  274,  318,  651,   21, -259, -422, -422, -236,
 /*   110 */    48,  267,  343,  506,  655,  664,  671,  723,  730,  810,
 /*   120 */   811,  812,  822,  839,  857,  858,  859,  860,  862,  864,
 /*   130 */   245,  352, -176,   -7,   47,  179,  352,  481,  488,  327,
 /*   140 */   273,  409,  396, -243,  353,  465, -347, -106, -208,  224,
 /*   150 */   466,  407,  534,  121,  573, -359,  377,  631,  678,  696,
 /*   160 */   770,  801,  626,  368,  699,  784,  645,  742,  881,  804,
 /*   170 */   843,  843,  889,  824,  909,  880,  906,  831,  831,  816,
 /*   180 */   831,  837,  835,  843,  907,  913,  933,  944,  950,  954,
 /*   190 */   957, 1011, 1012,  972,  976,  983, 1019, 1028, 1029, 1030,
 /*   200 */  1039, 1043,  981, 1037, 1007, 1044, 1051, 1003, 1052, 1060,
 /*   210 */  1061, 1064, 1065, 1072, 1068, 1076, 1080, 1090, 1062, 1073,
 /*   220 */  1075, 1077, 1078, 1079, 1081, 1083, 1084, 1085, 1087, 1088,
 /*   230 */  1109, 1063, 1082, 1049, 1066, 1070, 1118, 1067, 1094, 1129,
 /*   240 */  1135, 1091, 1092, 1098, 1034, 1096, 1110, 1045, 1099, 1113,
 /*   250 */  1114,  843, 1038, 1046, 1050, 1053, 1055, 1059, 1100, 1036,
 /*   260 */  1047, 1056,  831, 1139, 1115, 1183, 1189, 1187, 1188, 1146,
 /*   270 */  1149, 1161, 1163, 1165, 1167, 1147, 1168, 1155, 1201, 1190,
 /*   280 */  1202, 1176, 1123, 1191, 1179, 1199, 1214, 1212, 1236, 1232,
 /*   290 */  1172, 1170, 1186, 1196, 1216, 1223, 1230, 1240, 1245,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*    10 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*    20 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*    30 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*    40 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*    50 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*    60 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*    70 */  1625, 1882, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*    80 */  1625, 1625, 1625, 1625, 1625, 1703, 1625, 1625, 1625, 1625,
 /*    90 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   100 */  1625, 1625, 1625, 1625, 1625, 1701, 1875, 2081, 1625, 1625,
 /*   110 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   120 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   130 */  1625, 2093, 1625, 1625, 1703, 1625, 2093, 2093, 2093, 1701,
 /*   140 */  2053, 2053, 1625, 1625, 1625, 1625, 1810, 1625, 1625, 1625,
 /*   150 */  1625, 1625, 1625, 1810, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   160 */  1625, 1625, 1925, 1625, 1625, 2118, 2172, 1625, 1625, 2121,
 /*   170 */  1625, 1625, 1625, 1887, 1625, 1763, 2108, 2085, 2099, 2156,
 /*   180 */  2086, 2083, 2102, 1625, 2112, 1625, 1918, 1880, 1625, 1880,
 /*   190 */  1877, 1625, 1625, 1880, 1877, 1877, 1754, 1625, 1625, 1625,
 /*   200 */  1625, 1625, 1625, 1703, 1625, 1703, 1625, 1625, 1703, 1625,
 /*   210 */  1703, 1703, 1703, 1625, 1703, 1682, 1682, 1625, 1625, 1625,
 /*   220 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   230 */  1625, 1625, 1625, 1940, 1931, 1625, 1701, 1927, 1625, 1701,
 /*   240 */  1625, 1625, 1625, 1625, 2129, 2127, 1625, 2129, 2127, 1625,
 /*   250 */  1625, 1625, 2141, 2137, 2129, 2145, 2143, 2114, 2112, 2175,
 /*   260 */  2162, 2158, 2099, 1625, 1625, 1625, 1625, 1701, 1701, 2127,
 /*   270 */  1625, 1625, 1625, 1625, 1625, 2127, 1625, 1625, 1701, 1625,
 /*   280 */  1701, 1625, 1625, 1779, 1625, 1625, 1625, 1701, 1657, 1625,
 /*   290 */  1920, 1933, 1903, 1903, 1813, 1813, 1813, 1704, 1630, 1625,
 /*   300 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   310 */  1625, 2140, 2139, 2008, 1625, 2057, 2056, 2055, 2046, 2007,
 /*   320 */  1775, 1625, 2006, 2005, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   330 */  1894, 1893, 1999, 1625, 1625, 2000, 1998, 1997, 1625, 1625,
 /*   340 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   350 */  1625, 1625, 1625, 1625, 1625, 2159, 2163, 1625, 1625, 1625,
 /*   360 */  1625, 1625, 1625, 1625, 2082, 1625, 1625, 1625, 1625, 1625,
 /*   370 */  1982, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   380 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   390 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   400 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   410 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   420 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   430 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   440 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   450 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   460 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   470 */  1625, 1662, 1987, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   480 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   490 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   500 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   510 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1742,
 /*   520 */  1741, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   530 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   540 */  1625, 1625, 1625, 1990, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   550 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 2155, 2115, 1625,
 /*   560 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   570 */  1625, 1625, 1625, 1625, 1625, 1625, 1982, 1625, 2138, 1625,
 /*   580 */  1625, 2153, 1625, 2157, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   590 */  1625, 2092, 2088, 1625, 1625, 2084, 1625, 1625, 1625, 1625,
 /*   600 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   610 */  1625, 1625, 1625, 1625, 1625, 1981, 1625, 2043, 1625, 1625,
 /*   620 */  1625, 2077, 1625, 1625, 2028, 1625, 1625, 1625, 1625, 1625,
 /*   630 */  1625, 1625, 1625, 1625, 1990, 1625, 1993, 1625, 1625, 1625,
 /*   640 */  1625, 1625, 1807, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   650 */  1625, 1625, 1625, 1625, 1625, 1792, 1790, 1789, 1788, 1625,
 /*   660 */  1785, 1625, 1820, 1625, 1625, 1625, 1816, 1815, 1625, 1625,
 /*   670 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   680 */  1625, 1625, 1625, 1722, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   690 */  1625, 1625, 1714, 1625, 1713, 1625, 1625, 1625, 1625, 1625,
 /*   700 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   710 */  1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
 /*   720 */  1625, 1625, 1625, 1625, 1625, 1625, 1625,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
  272,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*      START => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  272,  /*      AFTER => ABORT */
  272,  /*     ATTACH => ABORT */
  272,  /*     BEFORE => ABORT */
  272,  /*      BEGIN => ABORT */
  272,  /*     BITAND => ABORT */
  272,  /*     BITNOT => ABORT */
  272,  /*      BITOR => ABORT */
  272,  /*     BLOCKS => ABORT */
  272,  /*     CHANGE => ABORT */
  272,  /*      COMMA => ABORT */
  272,  /*    COMPACT => ABORT */
  272,  /*     CONCAT => ABORT */
  272,  /*   CONFLICT => ABORT */
  272,  /*       COPY => ABORT */
  272,  /*   DEFERRED => ABORT */
  272,  /* DELIMITERS => ABORT */
  272,  /*     DETACH => ABORT */
  272,  /*     DIVIDE => ABORT */
  272,  /*        DOT => ABORT */
  272,  /*       EACH => ABORT */
  272,  /*       FAIL => ABORT */
  272,  /*       FILE => ABORT */
  272,  /*        FOR => ABORT */
  272,  /*       GLOB => ABORT */
  272,  /*         ID => ABORT */
  272,  /*  IMMEDIATE => ABORT */
  272,  /*     IMPORT => ABORT */
  272,  /*  INITIALLY => ABORT */
  272,  /*    INSTEAD => ABORT */
  272,  /*     ISNULL => ABORT */
  272,  /*        KEY => ABORT */
  272,  /*    MODULES => ABORT */
  272,  /*  NK_BITNOT => ABORT */
  272,  /*    NK_SEMI => ABORT */
  272,  /*    NOTNULL => ABORT */
  272,  /*         OF => ABORT */
  272,  /*       PLUS => ABORT */
  272,  /*  PRIVILEGE => ABORT */
  272,  /*      RAISE => ABORT */
  272,  /*    REPLACE => ABORT */
  272,  /*   RESTRICT => ABORT */
  272,  /*        ROW => ABORT */
  272,  /*       SEMI => ABORT */
  272,  /*       STAR => ABORT */
  272,  /*  STATEMENT => ABORT */
  272,  /*     STRICT => ABORT */
  272,  /*     STRING => ABORT */
  272,  /*      TIMES => ABORT */
  272,  /*     UPDATE => ABORT */
  272,  /*     VALUES => ABORT */
  272,  /*   VARIABLE => ABORT */
  272,  /*       VIEW => ABORT */
  272,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "IF",
  /*   63 */ "NOT",
  /*   64 */ "EXISTS",
  /*   65 */ "BUFFER",
  /*   66 */ "CACHEMODEL",
  /*   67 */ "CACHESIZE",
  /*   68 */ "COMP",
  /*   69 */ "DURATION",
  /*   70 */ "NK_VARIABLE",
  /*   71 */ "MAXROWS",
  /*   72 */ "MINROWS",
  /*   73 */ "KEEP",
  /*   74 */ "PAGES",
  /*   75 */ "PAGESIZE",
  /*   76 */ "TSDB_PAGESIZE",
  /*   77 */ "PRECISION",
  /*   78 */ "REPLICA",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "WAL_LEVEL",
  /*   84 */ "WAL_FSYNC_PERIOD",
  /*   85 */ "WAL_RETENTION_PERIOD",
  /*   86 */ "WAL_RETENTION_SIZE",
  /*   87 */ "WAL_ROLL_PERIOD",
  /*   88 */ "WAL_SEGMENT_SIZE",
  /*   89 */ "STT_TRIGGER",
  /*   90 */ "TABLE_PREFIX",
  /*   91 */ "TABLE_SUFFIX",
  /*   92 */ "NK_COLON",
  /*   93 */ "MAX_SPEED",
  /*   94 */ "TABLE",
  /*   95 */ "NK_LP",
  /*   96 */ "NK_RP",
  /*   97 */ "STABLE",
  /*   98 */ "ADD",
  /*   99 */ "COLUMN",
  /*  100 */ "MODIFY",
  /*  101 */ "RENAME",
  /*  102 */ "TAG",
  /*  103 */ "SET",
  /*  104 */ "NK_EQ",
  /*  105 */ "USING",
  /*  106 */ "TAGS",
  /*  107 */ "COMMENT",
  /*  108 */ "BOOL",
  /*  109 */ "TINYINT",
  /*  110 */ "SMALLINT",
  /*  111 */ "INT",
  /*  112 */ "INTEGER",
  /*  113 */ "BIGINT",
  /*  114 */ "FLOAT",
  /*  115 */ "DOUBLE",
  /*  116 */ "BINARY",
  /*  117 */ "TIMESTAMP",
  /*  118 */ "NCHAR",
  /*  119 */ "UNSIGNED",
  /*  120 */ "JSON",
  /*  121 */ "VARCHAR",
  /*  122 */ "MEDIUMBLOB",
  /*  123 */ "BLOB",
  /*  124 */ "VARBINARY",
  /*  125 */ "DECIMAL",
  /*  126 */ "MAX_DELAY",
  /*  127 */ "WATERMARK",
  /*  128 */ "ROLLUP",
  /*  129 */ "TTL",
  /*  130 */ "SMA",
  /*  131 */ "DELETE_MARK",
  /*  132 */ "FIRST",
  /*  133 */ "LAST",
  /*  134 */ "SHOW",
  /*  135 */ "PRIVILEGES",
  /*  136 */ "DATABASES",
  /*  137 */ "TABLES",
  /*  138 */ "STABLES",
  /*  139 */ "MNODES",
  /*  140 */ "QNODES",
  /*  141 */ "FUNCTIONS",
  /*  142 */ "INDEXES",
  /*  143 */ "ACCOUNTS",
  /*  144 */ "APPS",
  /*  145 */ "CONNECTIONS",
  /*  146 */ "LICENCES",
  /*  147 */ "GRANTS",
  /*  148 */ "QUERIES",
  /*  149 */ "SCORES",
  /*  150 */ "TOPICS",
  /*  151 */ "VARIABLES",
  /*  152 */ "CLUSTER",
  /*  153 */ "BNODES",
  /*  154 */ "SNODES",
  /*  155 */ "TRANSACTIONS",
  /*  156 */ "DISTRIBUTED",
  /*  157 */ "CONSUMERS",
  /*  158 */ "SUBSCRIPTIONS",
  /*  159 */ "VNODES",
  /*  160 */ "ALIVE",
  /*  161 */ "LIKE",
  /*  162 */ "TBNAME",
  /*  163 */ "QTAGS",
  /*  164 */ "AS",
  /*  165 */ "INDEX",
  /*  166 */ "FUNCTION",
  /*  167 */ "INTERVAL",
  /*  168 */ "COUNT",
  /*  169 */ "LAST_ROW",
  /*  170 */ "TOPIC",
  /*  171 */ "WITH",
  /*  172 */ "META",
  /*  173 */ "CONSUMER",
  /*  174 */ "GROUP",
  /*  175 */ "DESC",
  /*  176 */ "DESCRIBE",
  /*  177 */ "RESET",
  /*  178 */ "QUERY",
  /*  179 */ "CACHE",
  /*  180 */ "EXPLAIN",
  /*  181 */ "ANALYZE",
  /*  182 */ "VERBOSE",
  /*  183 */ "NK_BOOL",
  /*  184 */ "RATIO",
  /*  185 */ "NK_FLOAT",
  /*  186 */ "OUTPUTTYPE",
  /*  187 */ "AGGREGATE",
  /*  188 */ "BUFSIZE",
  /*  189 */ "STREAM",
  /*  190 */ "INTO",
  /*  191 */ "TRIGGER",
  /*  192 */ "AT_ONCE",
  /*  193 */ "WINDOW_CLOSE",
  /*  194 */ "IGNORE",
  /*  195 */ "EXPIRED",
  /*  196 */ "FILL_HISTORY",
  /*  197 */ "SUBTABLE",
  /*  198 */ "KILL",
  /*  199 */ "CONNECTION",
  /*  200 */ "TRANSACTION",
  /*  201 */ "BALANCE",
  /*  202 */ "VGROUP",
  /*  203 */ "MERGE",
  /*  204 */ "REDISTRIBUTE",
  /*  205 */ "SPLIT",
  /*  206 */ "DELETE",
  /*  207 */ "INSERT",
  /*  208 */ "NULL",
  /*  209 */ "NK_QUESTION",
  /*  210 */ "NK_ARROW",
  /*  211 */ "ROWTS",
  /*  212 */ "QSTART",
  /*  213 */ "QEND",
  /*  214 */ "QDURATION",
  /*  215 */ "WSTART",
  /*  216 */ "WEND",
  /*  217 */ "WDURATION",
  /*  218 */ "IROWTS",
  /*  219 */ "ISFILLED",
  /*  220 */ "CAST",
  /*  221 */ "NOW",
  /*  222 */ "TODAY",
  /*  223 */ "TIMEZONE",
  /*  224 */ "CLIENT_VERSION",
  /*  225 */ "SERVER_VERSION",
  /*  226 */ "SERVER_STATUS",
  /*  227 */ "CURRENT_USER",
  /*  228 */ "CASE",
  /*  229 */ "END",
  /*  230 */ "WHEN",
  /*  231 */ "THEN",
  /*  232 */ "ELSE",
  /*  233 */ "BETWEEN",
  /*  234 */ "IS",
  /*  235 */ "NK_LT",
  /*  236 */ "NK_GT",
  /*  237 */ "NK_LE",
  /*  238 */ "NK_GE",
  /*  239 */ "NK_NE",
  /*  240 */ "MATCH",
  /*  241 */ "NMATCH",
  /*  242 */ "CONTAINS",
  /*  243 */ "IN",
  /*  244 */ "JOIN",
  /*  245 */ "INNER",
  /*  246 */ "SELECT",
  /*  247 */ "DISTINCT",
  /*  248 */ "WHERE",
  /*  249 */ "PARTITION",
  /*  250 */ "BY",
  /*  251 */ "SESSION",
  /*  252 */ "STATE_WINDOW",
  /*  253 */ "EVENT_WINDOW",
  /*  254 */ "START",
  /*  255 */ "SLIDING",
  /*  256 */ "FILL",
  /*  257 */ "VALUE",
  /*  258 */ "NONE",
  /*  259 */ "PREV",
  /*  260 */ "LINEAR",
  /*  261 */ "NEXT",
  /*  262 */ "HAVING",
  /*  263 */ "RANGE",
  /*  264 */ "EVERY",
  /*  265 */ "ORDER",
  /*  266 */ "SLIMIT",
  /*  267 */ "SOFFSET",
  /*  268 */ "LIMIT",
  /*  269 */ "OFFSET",
  /*  270 */ "ASC",
  /*  271 */ "NULLS",
  /*  272 */ "ABORT",
  /*  273 */ "AFTER",
  /*  274 */ "ATTACH",
  /*  275 */ "BEFORE",
  /*  276 */ "BEGIN",
  /*  277 */ "BITAND",
  /*  278 */ "BITNOT",
  /*  279 */ "BITOR",
  /*  280 */ "BLOCKS",
  /*  281 */ "CHANGE",
  /*  282 */ "COMMA",
  /*  283 */ "COMPACT",
  /*  284 */ "CONCAT",
  /*  285 */ "CONFLICT",
  /*  286 */ "COPY",
  /*  287 */ "DEFERRED",
  /*  288 */ "DELIMITERS",
  /*  289 */ "DETACH",
  /*  290 */ "DIVIDE",
  /*  291 */ "DOT",
  /*  292 */ "EACH",
  /*  293 */ "FAIL",
  /*  294 */ "FILE",
  /*  295 */ "FOR",
  /*  296 */ "GLOB",
  /*  297 */ "ID",
  /*  298 */ "IMMEDIATE",
  /*  299 */ "IMPORT",
  /*  300 */ "INITIALLY",
  /*  301 */ "INSTEAD",
  /*  302 */ "ISNULL",
  /*  303 */ "KEY",
  /*  304 */ "MODULES",
  /*  305 */ "NK_BITNOT",
  /*  306 */ "NK_SEMI",
  /*  307 */ "NOTNULL",
  /*  308 */ "OF",
  /*  309 */ "PLUS",
  /*  310 */ "PRIVILEGE",
  /*  311 */ "RAISE",
  /*  312 */ "REPLACE",
  /*  313 */ "RESTRICT",
  /*  314 */ "ROW",
  /*  315 */ "SEMI",
  /*  316 */ "STAR",
  /*  317 */ "STATEMENT",
  /*  318 */ "STRICT",
  /*  319 */ "STRING",
  /*  320 */ "TIMES",
  /*  321 */ "UPDATE",
  /*  322 */ "VALUES",
  /*  323 */ "VARIABLE",
  /*  324 */ "VIEW",
  /*  325 */ "WAL",
  /*  326 */ "cmd",
  /*  327 */ "account_options",
  /*  328 */ "alter_account_options",
  /*  329 */ "literal",
  /*  330 */ "alter_account_option",
  /*  331 */ "user_name",
  /*  332 */ "sysinfo_opt",
  /*  333 */ "privileges",
  /*  334 */ "priv_level",
  /*  335 */ "priv_type_list",
  /*  336 */ "priv_type",
  /*  337 */ "db_name",
  /*  338 */ "topic_name",
  /*  339 */ "dnode_endpoint",
  /*  340 */ "force_opt",
  /*  341 */ "not_exists_opt",
  /*  342 */ "db_options",
  /*  343 */ "exists_opt",
  /*  344 */ "alter_db_options",
  /*  345 */ "speed_opt",
  /*  346 */ "integer_list",
  /*  347 */ "variable_list",
  /*  348 */ "retention_list",
  /*  349 */ "alter_db_option",
  /*  350 */ "retention",
  /*  351 */ "full_table_name",
  /*  352 */ "column_def_list",
  /*  353 */ "tags_def_opt",
  /*  354 */ "table_options",
  /*  355 */ "multi_create_clause",
  /*  356 */ "tags_def",
  /*  357 */ "multi_drop_clause",
  /*  358 */ "alter_table_clause",
  /*  359 */ "alter_table_options",
  /*  360 */ "column_name",
  /*  361 */ "type_name",
  /*  362 */ "signed_literal",
  /*  363 */ "create_subtable_clause",
  /*  364 */ "specific_cols_opt",
  /*  365 */ "expression_list",
  /*  366 */ "drop_table_clause",
  /*  367 */ "col_name_list",
  /*  368 */ "table_name",
  /*  369 */ "column_def",
  /*  370 */ "duration_list",
  /*  371 */ "rollup_func_list",
  /*  372 */ "alter_table_option",
  /*  373 */ "duration_literal",
  /*  374 */ "rollup_func_name",
  /*  375 */ "function_name",
  /*  376 */ "col_name",
  /*  377 */ "db_name_cond_opt",
  /*  378 */ "like_pattern_opt",
  /*  379 */ "table_name_cond",
  /*  380 */ "from_db_opt",
  /*  381 */ "tag_list_opt",
  /*  382 */ "tag_item",
  /*  383 */ "column_alias",
  /*  384 */ "index_options",
  /*  385 */ "func_list",
  /*  386 */ "sliding_opt",
  /*  387 */ "sma_stream_opt",
  /*  388 */ "func",
  /*  389 */ "sma_func_name",
  /*  390 */ "query_or_subquery",
  /*  391 */ "cgroup_name",
  /*  392 */ "analyze_opt",
  /*  393 */ "explain_options",
  /*  394 */ "agg_func_opt",
  /*  395 */ "bufsize_opt",
  /*  396 */ "stream_name",
  /*  397 */ "stream_options",
  /*  398 */ "col_list_opt",
  /*  399 */ "subtable_opt",
  /*  400 */ "expression",
  /*  401 */ "dnode_list",
  /*  402 */ "where_clause_opt",
  /*  403 */ "signed",
  /*  404 */ "literal_func",
  /*  405 */ "literal_list",
  /*  406 */ "table_alias",
  /*  407 */ "expr_or_subquery",
  /*  408 */ "pseudo_column",
  /*  409 */ "column_reference",
  /*  410 */ "function_expression",
  /*  411 */ "case_when_expression",
  /*  412 */ "star_func",
  /*  413 */ "star_func_para_list",
  /*  414 */ "noarg_func",
  /*  415 */ "other_para_list",
  /*  416 */ "star_func_para",
  /*  417 */ "when_then_list",
  /*  418 */ "case_when_else_opt",
  /*  419 */ "common_expression",
  /*  420 */ "when_then_expr",
  /*  421 */ "predicate",
  /*  422 */ "compare_op",
  /*  423 */ "in_op",
  /*  424 */ "in_predicate_value",
  /*  425 */ "boolean_value_expression",
  /*  426 */ "boolean_primary",
  /*  427 */ "from_clause_opt",
  /*  428 */ "table_reference_list",
  /*  429 */ "table_reference",
  /*  430 */ "table_primary",
  /*  431 */ "joined_table",
  /*  432 */ "alias_opt",
  /*  433 */ "subquery",
  /*  434 */ "parenthesized_joined_table",
  /*  435 */ "join_type",
  /*  436 */ "search_condition",
  /*  437 */ "query_specification",
  /*  438 */ "set_quantifier_opt",
  /*  439 */ "select_list",
  /*  440 */ "partition_by_clause_opt",
  /*  441 */ "range_opt",
  /*  442 */ "every_opt",
  /*  443 */ "fill_opt",
  /*  444 */ "twindow_clause_opt",
  /*  445 */ "group_by_clause_opt",
  /*  446 */ "having_clause_opt",
  /*  447 */ "select_item",
  /*  448 */ "partition_list",
  /*  449 */ "partition_item",
  /*  450 */ "fill_mode",
  /*  451 */ "group_by_list",
  /*  452 */ "query_expression",
  /*  453 */ "query_simple",
  /*  454 */ "order_by_clause_opt",
  /*  455 */ "slimit_clause_opt",
  /*  456 */ "limit_clause_opt",
  /*  457 */ "union_query_expression",
  /*  458 */ "query_simple_or_subquery",
  /*  459 */ "sort_specification_list",
  /*  460 */ "sort_specification",
  /*  461 */ "ordering_specification_opt",
  /*  462 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  73 */ "not_exists_opt ::=",
 /*  74 */ "exists_opt ::= IF EXISTS",
 /*  75 */ "exists_opt ::=",
 /*  76 */ "db_options ::=",
 /*  77 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  78 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  79 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  81 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  83 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  84 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options KEEP integer_list",
 /*  86 */ "db_options ::= db_options KEEP variable_list",
 /*  87 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  88 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  89 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  91 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  92 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  93 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  94 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  95 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 104 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 105 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 107 */ "alter_db_options ::= alter_db_option",
 /* 108 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 109 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 110 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 111 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 112 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 113 */ "alter_db_option ::= KEEP integer_list",
 /* 114 */ "alter_db_option ::= KEEP variable_list",
 /* 115 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 116 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 117 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 118 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 119 */ "integer_list ::= NK_INTEGER",
 /* 120 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 121 */ "variable_list ::= NK_VARIABLE",
 /* 122 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 123 */ "retention_list ::= retention",
 /* 124 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 125 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 126 */ "speed_opt ::=",
 /* 127 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 128 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 129 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 130 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 131 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 132 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 133 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 134 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 135 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 136 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 142 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 144 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 145 */ "multi_create_clause ::= create_subtable_clause",
 /* 146 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 147 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 148 */ "multi_drop_clause ::= drop_table_clause",
 /* 149 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 150 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 151 */ "specific_cols_opt ::=",
 /* 152 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 153 */ "full_table_name ::= table_name",
 /* 154 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 155 */ "column_def_list ::= column_def",
 /* 156 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 157 */ "column_def ::= column_name type_name",
 /* 158 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 159 */ "type_name ::= BOOL",
 /* 160 */ "type_name ::= TINYINT",
 /* 161 */ "type_name ::= SMALLINT",
 /* 162 */ "type_name ::= INT",
 /* 163 */ "type_name ::= INTEGER",
 /* 164 */ "type_name ::= BIGINT",
 /* 165 */ "type_name ::= FLOAT",
 /* 166 */ "type_name ::= DOUBLE",
 /* 167 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TIMESTAMP",
 /* 169 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TINYINT UNSIGNED",
 /* 171 */ "type_name ::= SMALLINT UNSIGNED",
 /* 172 */ "type_name ::= INT UNSIGNED",
 /* 173 */ "type_name ::= BIGINT UNSIGNED",
 /* 174 */ "type_name ::= JSON",
 /* 175 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 176 */ "type_name ::= MEDIUMBLOB",
 /* 177 */ "type_name ::= BLOB",
 /* 178 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL",
 /* 180 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 182 */ "tags_def_opt ::=",
 /* 183 */ "tags_def_opt ::= tags_def",
 /* 184 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 185 */ "table_options ::=",
 /* 186 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 187 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 188 */ "table_options ::= table_options WATERMARK duration_list",
 /* 189 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 190 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 191 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 192 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 193 */ "alter_table_options ::= alter_table_option",
 /* 194 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 195 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 196 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 197 */ "duration_list ::= duration_literal",
 /* 198 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 199 */ "rollup_func_list ::= rollup_func_name",
 /* 200 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 201 */ "rollup_func_name ::= function_name",
 /* 202 */ "rollup_func_name ::= FIRST",
 /* 203 */ "rollup_func_name ::= LAST",
 /* 204 */ "col_name_list ::= col_name",
 /* 205 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 206 */ "col_name ::= column_name",
 /* 207 */ "cmd ::= SHOW DNODES",
 /* 208 */ "cmd ::= SHOW USERS",
 /* 209 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 210 */ "cmd ::= SHOW DATABASES",
 /* 211 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 214 */ "cmd ::= SHOW MNODES",
 /* 215 */ "cmd ::= SHOW QNODES",
 /* 216 */ "cmd ::= SHOW FUNCTIONS",
 /* 217 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 218 */ "cmd ::= SHOW STREAMS",
 /* 219 */ "cmd ::= SHOW ACCOUNTS",
 /* 220 */ "cmd ::= SHOW APPS",
 /* 221 */ "cmd ::= SHOW CONNECTIONS",
 /* 222 */ "cmd ::= SHOW LICENCES",
 /* 223 */ "cmd ::= SHOW GRANTS",
 /* 224 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 225 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 226 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 227 */ "cmd ::= SHOW QUERIES",
 /* 228 */ "cmd ::= SHOW SCORES",
 /* 229 */ "cmd ::= SHOW TOPICS",
 /* 230 */ "cmd ::= SHOW VARIABLES",
 /* 231 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 232 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 233 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 234 */ "cmd ::= SHOW BNODES",
 /* 235 */ "cmd ::= SHOW SNODES",
 /* 236 */ "cmd ::= SHOW CLUSTER",
 /* 237 */ "cmd ::= SHOW TRANSACTIONS",
 /* 238 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 239 */ "cmd ::= SHOW CONSUMERS",
 /* 240 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 241 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 242 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 244 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 245 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 246 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 247 */ "db_name_cond_opt ::=",
 /* 248 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 249 */ "like_pattern_opt ::=",
 /* 250 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 251 */ "table_name_cond ::= table_name",
 /* 252 */ "from_db_opt ::=",
 /* 253 */ "from_db_opt ::= FROM db_name",
 /* 254 */ "tag_list_opt ::=",
 /* 255 */ "tag_list_opt ::= tag_item",
 /* 256 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 257 */ "tag_item ::= TBNAME",
 /* 258 */ "tag_item ::= QTAGS",
 /* 259 */ "tag_item ::= column_name",
 /* 260 */ "tag_item ::= column_name column_alias",
 /* 261 */ "tag_item ::= column_name AS column_alias",
 /* 262 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 263 */ "cmd ::= CREATE INDEX not_exists_opt full_table_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 264 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 265 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 266 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 267 */ "func_list ::= func",
 /* 268 */ "func_list ::= func_list NK_COMMA func",
 /* 269 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 270 */ "sma_func_name ::= function_name",
 /* 271 */ "sma_func_name ::= COUNT",
 /* 272 */ "sma_func_name ::= FIRST",
 /* 273 */ "sma_func_name ::= LAST",
 /* 274 */ "sma_func_name ::= LAST_ROW",
 /* 275 */ "sma_stream_opt ::=",
 /* 276 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 277 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 278 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 279 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 280 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 281 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 282 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 283 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 284 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 285 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 286 */ "cmd ::= DESC full_table_name",
 /* 287 */ "cmd ::= DESCRIBE full_table_name",
 /* 288 */ "cmd ::= RESET QUERY CACHE",
 /* 289 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 290 */ "analyze_opt ::=",
 /* 291 */ "analyze_opt ::= ANALYZE",
 /* 292 */ "explain_options ::=",
 /* 293 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 294 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 295 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 296 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 297 */ "agg_func_opt ::=",
 /* 298 */ "agg_func_opt ::= AGGREGATE",
 /* 299 */ "bufsize_opt ::=",
 /* 300 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 301 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tags_def_opt subtable_opt AS query_or_subquery",
 /* 302 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 303 */ "col_list_opt ::=",
 /* 304 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 305 */ "stream_options ::=",
 /* 306 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 307 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 308 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 309 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 310 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 311 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 312 */ "subtable_opt ::=",
 /* 313 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 314 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 315 */ "cmd ::= KILL QUERY NK_STRING",
 /* 316 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 317 */ "cmd ::= BALANCE VGROUP",
 /* 318 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 319 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 320 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 321 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 322 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 323 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 324 */ "cmd ::= query_or_subquery",
 /* 325 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 326 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 327 */ "literal ::= NK_INTEGER",
 /* 328 */ "literal ::= NK_FLOAT",
 /* 329 */ "literal ::= NK_STRING",
 /* 330 */ "literal ::= NK_BOOL",
 /* 331 */ "literal ::= TIMESTAMP NK_STRING",
 /* 332 */ "literal ::= duration_literal",
 /* 333 */ "literal ::= NULL",
 /* 334 */ "literal ::= NK_QUESTION",
 /* 335 */ "duration_literal ::= NK_VARIABLE",
 /* 336 */ "signed ::= NK_INTEGER",
 /* 337 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 338 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 339 */ "signed ::= NK_FLOAT",
 /* 340 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 341 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 342 */ "signed_literal ::= signed",
 /* 343 */ "signed_literal ::= NK_STRING",
 /* 344 */ "signed_literal ::= NK_BOOL",
 /* 345 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 346 */ "signed_literal ::= duration_literal",
 /* 347 */ "signed_literal ::= NULL",
 /* 348 */ "signed_literal ::= literal_func",
 /* 349 */ "signed_literal ::= NK_QUESTION",
 /* 350 */ "literal_list ::= signed_literal",
 /* 351 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 352 */ "db_name ::= NK_ID",
 /* 353 */ "table_name ::= NK_ID",
 /* 354 */ "column_name ::= NK_ID",
 /* 355 */ "function_name ::= NK_ID",
 /* 356 */ "table_alias ::= NK_ID",
 /* 357 */ "column_alias ::= NK_ID",
 /* 358 */ "user_name ::= NK_ID",
 /* 359 */ "topic_name ::= NK_ID",
 /* 360 */ "stream_name ::= NK_ID",
 /* 361 */ "cgroup_name ::= NK_ID",
 /* 362 */ "expr_or_subquery ::= expression",
 /* 363 */ "expression ::= literal",
 /* 364 */ "expression ::= pseudo_column",
 /* 365 */ "expression ::= column_reference",
 /* 366 */ "expression ::= function_expression",
 /* 367 */ "expression ::= case_when_expression",
 /* 368 */ "expression ::= NK_LP expression NK_RP",
 /* 369 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 370 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 371 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 372 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 373 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 374 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 375 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 376 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 377 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 378 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 379 */ "expression_list ::= expr_or_subquery",
 /* 380 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 381 */ "column_reference ::= column_name",
 /* 382 */ "column_reference ::= table_name NK_DOT column_name",
 /* 383 */ "pseudo_column ::= ROWTS",
 /* 384 */ "pseudo_column ::= TBNAME",
 /* 385 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 386 */ "pseudo_column ::= QSTART",
 /* 387 */ "pseudo_column ::= QEND",
 /* 388 */ "pseudo_column ::= QDURATION",
 /* 389 */ "pseudo_column ::= WSTART",
 /* 390 */ "pseudo_column ::= WEND",
 /* 391 */ "pseudo_column ::= WDURATION",
 /* 392 */ "pseudo_column ::= IROWTS",
 /* 393 */ "pseudo_column ::= ISFILLED",
 /* 394 */ "pseudo_column ::= QTAGS",
 /* 395 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 396 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 397 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 398 */ "function_expression ::= literal_func",
 /* 399 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 400 */ "literal_func ::= NOW",
 /* 401 */ "noarg_func ::= NOW",
 /* 402 */ "noarg_func ::= TODAY",
 /* 403 */ "noarg_func ::= TIMEZONE",
 /* 404 */ "noarg_func ::= DATABASE",
 /* 405 */ "noarg_func ::= CLIENT_VERSION",
 /* 406 */ "noarg_func ::= SERVER_VERSION",
 /* 407 */ "noarg_func ::= SERVER_STATUS",
 /* 408 */ "noarg_func ::= CURRENT_USER",
 /* 409 */ "noarg_func ::= USER",
 /* 410 */ "star_func ::= COUNT",
 /* 411 */ "star_func ::= FIRST",
 /* 412 */ "star_func ::= LAST",
 /* 413 */ "star_func ::= LAST_ROW",
 /* 414 */ "star_func_para_list ::= NK_STAR",
 /* 415 */ "star_func_para_list ::= other_para_list",
 /* 416 */ "other_para_list ::= star_func_para",
 /* 417 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 418 */ "star_func_para ::= expr_or_subquery",
 /* 419 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 420 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 421 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 422 */ "when_then_list ::= when_then_expr",
 /* 423 */ "when_then_list ::= when_then_list when_then_expr",
 /* 424 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 425 */ "case_when_else_opt ::=",
 /* 426 */ "case_when_else_opt ::= ELSE common_expression",
 /* 427 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 428 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 429 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 430 */ "predicate ::= expr_or_subquery IS NULL",
 /* 431 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 432 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 433 */ "compare_op ::= NK_LT",
 /* 434 */ "compare_op ::= NK_GT",
 /* 435 */ "compare_op ::= NK_LE",
 /* 436 */ "compare_op ::= NK_GE",
 /* 437 */ "compare_op ::= NK_NE",
 /* 438 */ "compare_op ::= NK_EQ",
 /* 439 */ "compare_op ::= LIKE",
 /* 440 */ "compare_op ::= NOT LIKE",
 /* 441 */ "compare_op ::= MATCH",
 /* 442 */ "compare_op ::= NMATCH",
 /* 443 */ "compare_op ::= CONTAINS",
 /* 444 */ "in_op ::= IN",
 /* 445 */ "in_op ::= NOT IN",
 /* 446 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 447 */ "boolean_value_expression ::= boolean_primary",
 /* 448 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 449 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 450 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 451 */ "boolean_primary ::= predicate",
 /* 452 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 453 */ "common_expression ::= expr_or_subquery",
 /* 454 */ "common_expression ::= boolean_value_expression",
 /* 455 */ "from_clause_opt ::=",
 /* 456 */ "from_clause_opt ::= FROM table_reference_list",
 /* 457 */ "table_reference_list ::= table_reference",
 /* 458 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 459 */ "table_reference ::= table_primary",
 /* 460 */ "table_reference ::= joined_table",
 /* 461 */ "table_primary ::= table_name alias_opt",
 /* 462 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 463 */ "table_primary ::= subquery alias_opt",
 /* 464 */ "table_primary ::= parenthesized_joined_table",
 /* 465 */ "alias_opt ::=",
 /* 466 */ "alias_opt ::= table_alias",
 /* 467 */ "alias_opt ::= AS table_alias",
 /* 468 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 469 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 470 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 471 */ "join_type ::=",
 /* 472 */ "join_type ::= INNER",
 /* 473 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 474 */ "set_quantifier_opt ::=",
 /* 475 */ "set_quantifier_opt ::= DISTINCT",
 /* 476 */ "set_quantifier_opt ::= ALL",
 /* 477 */ "select_list ::= select_item",
 /* 478 */ "select_list ::= select_list NK_COMMA select_item",
 /* 479 */ "select_item ::= NK_STAR",
 /* 480 */ "select_item ::= common_expression",
 /* 481 */ "select_item ::= common_expression column_alias",
 /* 482 */ "select_item ::= common_expression AS column_alias",
 /* 483 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 484 */ "where_clause_opt ::=",
 /* 485 */ "where_clause_opt ::= WHERE search_condition",
 /* 486 */ "partition_by_clause_opt ::=",
 /* 487 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 488 */ "partition_list ::= partition_item",
 /* 489 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 490 */ "partition_item ::= expr_or_subquery",
 /* 491 */ "partition_item ::= expr_or_subquery column_alias",
 /* 492 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 493 */ "twindow_clause_opt ::=",
 /* 494 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 495 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 496 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 497 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 498 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 499 */ "sliding_opt ::=",
 /* 500 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 501 */ "fill_opt ::=",
 /* 502 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 503 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 504 */ "fill_mode ::= NONE",
 /* 505 */ "fill_mode ::= PREV",
 /* 506 */ "fill_mode ::= NULL",
 /* 507 */ "fill_mode ::= LINEAR",
 /* 508 */ "fill_mode ::= NEXT",
 /* 509 */ "group_by_clause_opt ::=",
 /* 510 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 511 */ "group_by_list ::= expr_or_subquery",
 /* 512 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 513 */ "having_clause_opt ::=",
 /* 514 */ "having_clause_opt ::= HAVING search_condition",
 /* 515 */ "range_opt ::=",
 /* 516 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 517 */ "every_opt ::=",
 /* 518 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 519 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 520 */ "query_simple ::= query_specification",
 /* 521 */ "query_simple ::= union_query_expression",
 /* 522 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 523 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 524 */ "query_simple_or_subquery ::= query_simple",
 /* 525 */ "query_simple_or_subquery ::= subquery",
 /* 526 */ "query_or_subquery ::= query_expression",
 /* 527 */ "query_or_subquery ::= subquery",
 /* 528 */ "order_by_clause_opt ::=",
 /* 529 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 530 */ "slimit_clause_opt ::=",
 /* 531 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 532 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 533 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 534 */ "limit_clause_opt ::=",
 /* 535 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 536 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 537 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 538 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 539 */ "subquery ::= NK_LP subquery NK_RP",
 /* 540 */ "search_condition ::= common_expression",
 /* 541 */ "sort_specification_list ::= sort_specification",
 /* 542 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 543 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 544 */ "ordering_specification_opt ::=",
 /* 545 */ "ordering_specification_opt ::= ASC",
 /* 546 */ "ordering_specification_opt ::= DESC",
 /* 547 */ "null_ordering_opt ::=",
 /* 548 */ "null_ordering_opt ::= NULLS FIRST",
 /* 549 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 326: /* cmd */
    case 329: /* literal */
    case 342: /* db_options */
    case 344: /* alter_db_options */
    case 350: /* retention */
    case 351: /* full_table_name */
    case 354: /* table_options */
    case 358: /* alter_table_clause */
    case 359: /* alter_table_options */
    case 362: /* signed_literal */
    case 363: /* create_subtable_clause */
    case 366: /* drop_table_clause */
    case 369: /* column_def */
    case 373: /* duration_literal */
    case 374: /* rollup_func_name */
    case 376: /* col_name */
    case 377: /* db_name_cond_opt */
    case 378: /* like_pattern_opt */
    case 379: /* table_name_cond */
    case 380: /* from_db_opt */
    case 382: /* tag_item */
    case 384: /* index_options */
    case 386: /* sliding_opt */
    case 387: /* sma_stream_opt */
    case 388: /* func */
    case 390: /* query_or_subquery */
    case 393: /* explain_options */
    case 397: /* stream_options */
    case 399: /* subtable_opt */
    case 400: /* expression */
    case 402: /* where_clause_opt */
    case 403: /* signed */
    case 404: /* literal_func */
    case 407: /* expr_or_subquery */
    case 408: /* pseudo_column */
    case 409: /* column_reference */
    case 410: /* function_expression */
    case 411: /* case_when_expression */
    case 416: /* star_func_para */
    case 418: /* case_when_else_opt */
    case 419: /* common_expression */
    case 420: /* when_then_expr */
    case 421: /* predicate */
    case 424: /* in_predicate_value */
    case 425: /* boolean_value_expression */
    case 426: /* boolean_primary */
    case 427: /* from_clause_opt */
    case 428: /* table_reference_list */
    case 429: /* table_reference */
    case 430: /* table_primary */
    case 431: /* joined_table */
    case 433: /* subquery */
    case 434: /* parenthesized_joined_table */
    case 436: /* search_condition */
    case 437: /* query_specification */
    case 441: /* range_opt */
    case 442: /* every_opt */
    case 443: /* fill_opt */
    case 444: /* twindow_clause_opt */
    case 446: /* having_clause_opt */
    case 447: /* select_item */
    case 449: /* partition_item */
    case 452: /* query_expression */
    case 453: /* query_simple */
    case 455: /* slimit_clause_opt */
    case 456: /* limit_clause_opt */
    case 457: /* union_query_expression */
    case 458: /* query_simple_or_subquery */
    case 460: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy320)); 
}
      break;
    case 327: /* account_options */
    case 328: /* alter_account_options */
    case 330: /* alter_account_option */
    case 345: /* speed_opt */
    case 395: /* bufsize_opt */
{
 
}
      break;
    case 331: /* user_name */
    case 334: /* priv_level */
    case 337: /* db_name */
    case 338: /* topic_name */
    case 339: /* dnode_endpoint */
    case 360: /* column_name */
    case 368: /* table_name */
    case 375: /* function_name */
    case 383: /* column_alias */
    case 389: /* sma_func_name */
    case 391: /* cgroup_name */
    case 396: /* stream_name */
    case 406: /* table_alias */
    case 412: /* star_func */
    case 414: /* noarg_func */
    case 432: /* alias_opt */
{
 
}
      break;
    case 332: /* sysinfo_opt */
{
 
}
      break;
    case 333: /* privileges */
    case 335: /* priv_type_list */
    case 336: /* priv_type */
{
 
}
      break;
    case 340: /* force_opt */
    case 341: /* not_exists_opt */
    case 343: /* exists_opt */
    case 392: /* analyze_opt */
    case 394: /* agg_func_opt */
    case 438: /* set_quantifier_opt */
{
 
}
      break;
    case 346: /* integer_list */
    case 347: /* variable_list */
    case 348: /* retention_list */
    case 352: /* column_def_list */
    case 353: /* tags_def_opt */
    case 355: /* multi_create_clause */
    case 356: /* tags_def */
    case 357: /* multi_drop_clause */
    case 364: /* specific_cols_opt */
    case 365: /* expression_list */
    case 367: /* col_name_list */
    case 370: /* duration_list */
    case 371: /* rollup_func_list */
    case 381: /* tag_list_opt */
    case 385: /* func_list */
    case 398: /* col_list_opt */
    case 401: /* dnode_list */
    case 405: /* literal_list */
    case 413: /* star_func_para_list */
    case 415: /* other_para_list */
    case 417: /* when_then_list */
    case 439: /* select_list */
    case 440: /* partition_by_clause_opt */
    case 445: /* group_by_clause_opt */
    case 448: /* partition_list */
    case 451: /* group_by_list */
    case 454: /* order_by_clause_opt */
    case 459: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy570)); 
}
      break;
    case 349: /* alter_db_option */
    case 372: /* alter_table_option */
{
 
}
      break;
    case 361: /* type_name */
{
 
}
      break;
    case 422: /* compare_op */
    case 423: /* in_op */
{
 
}
      break;
    case 435: /* join_type */
{
 
}
      break;
    case 450: /* fill_mode */
{
 
}
      break;
    case 461: /* ordering_specification_opt */
{
 
}
      break;
    case 462: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<sizeof(yy_action)/sizeof(yy_action[0]) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
   326,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   326,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
   327,  /* (2) account_options ::= */
   327,  /* (3) account_options ::= account_options PPS literal */
   327,  /* (4) account_options ::= account_options TSERIES literal */
   327,  /* (5) account_options ::= account_options STORAGE literal */
   327,  /* (6) account_options ::= account_options STREAMS literal */
   327,  /* (7) account_options ::= account_options QTIME literal */
   327,  /* (8) account_options ::= account_options DBS literal */
   327,  /* (9) account_options ::= account_options USERS literal */
   327,  /* (10) account_options ::= account_options CONNS literal */
   327,  /* (11) account_options ::= account_options STATE literal */
   328,  /* (12) alter_account_options ::= alter_account_option */
   328,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   330,  /* (14) alter_account_option ::= PASS literal */
   330,  /* (15) alter_account_option ::= PPS literal */
   330,  /* (16) alter_account_option ::= TSERIES literal */
   330,  /* (17) alter_account_option ::= STORAGE literal */
   330,  /* (18) alter_account_option ::= STREAMS literal */
   330,  /* (19) alter_account_option ::= QTIME literal */
   330,  /* (20) alter_account_option ::= DBS literal */
   330,  /* (21) alter_account_option ::= USERS literal */
   330,  /* (22) alter_account_option ::= CONNS literal */
   330,  /* (23) alter_account_option ::= STATE literal */
   326,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   326,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   326,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   326,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   326,  /* (28) cmd ::= DROP USER user_name */
   332,  /* (29) sysinfo_opt ::= */
   332,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   326,  /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
   326,  /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
   333,  /* (33) privileges ::= ALL */
   333,  /* (34) privileges ::= priv_type_list */
   333,  /* (35) privileges ::= SUBSCRIBE */
   335,  /* (36) priv_type_list ::= priv_type */
   335,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   336,  /* (38) priv_type ::= READ */
   336,  /* (39) priv_type ::= WRITE */
   334,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   334,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   334,  /* (42) priv_level ::= topic_name */
   326,  /* (43) cmd ::= CREATE DNODE dnode_endpoint */
   326,  /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   326,  /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
   326,  /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
   326,  /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   326,  /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   326,  /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
   326,  /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   339,  /* (51) dnode_endpoint ::= NK_STRING */
   339,  /* (52) dnode_endpoint ::= NK_ID */
   339,  /* (53) dnode_endpoint ::= NK_IPTOKEN */
   340,  /* (54) force_opt ::= */
   340,  /* (55) force_opt ::= FORCE */
   326,  /* (56) cmd ::= ALTER LOCAL NK_STRING */
   326,  /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   326,  /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   326,  /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   326,  /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   326,  /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   326,  /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   326,  /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   326,  /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   326,  /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   326,  /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   326,  /* (67) cmd ::= DROP DATABASE exists_opt db_name */
   326,  /* (68) cmd ::= USE db_name */
   326,  /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
   326,  /* (70) cmd ::= FLUSH DATABASE db_name */
   326,  /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
   341,  /* (72) not_exists_opt ::= IF NOT EXISTS */
   341,  /* (73) not_exists_opt ::= */
   343,  /* (74) exists_opt ::= IF EXISTS */
   343,  /* (75) exists_opt ::= */
   342,  /* (76) db_options ::= */
   342,  /* (77) db_options ::= db_options BUFFER NK_INTEGER */
   342,  /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
   342,  /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
   342,  /* (80) db_options ::= db_options COMP NK_INTEGER */
   342,  /* (81) db_options ::= db_options DURATION NK_INTEGER */
   342,  /* (82) db_options ::= db_options DURATION NK_VARIABLE */
   342,  /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
   342,  /* (84) db_options ::= db_options MINROWS NK_INTEGER */
   342,  /* (85) db_options ::= db_options KEEP integer_list */
   342,  /* (86) db_options ::= db_options KEEP variable_list */
   342,  /* (87) db_options ::= db_options PAGES NK_INTEGER */
   342,  /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
   342,  /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   342,  /* (90) db_options ::= db_options PRECISION NK_STRING */
   342,  /* (91) db_options ::= db_options REPLICA NK_INTEGER */
   342,  /* (92) db_options ::= db_options VGROUPS NK_INTEGER */
   342,  /* (93) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   342,  /* (94) db_options ::= db_options RETENTIONS retention_list */
   342,  /* (95) db_options ::= db_options SCHEMALESS NK_INTEGER */
   342,  /* (96) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   342,  /* (97) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   342,  /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   342,  /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   342,  /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   342,  /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   342,  /* (102) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   342,  /* (103) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   342,  /* (104) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   342,  /* (105) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
   342,  /* (106) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
   344,  /* (107) alter_db_options ::= alter_db_option */
   344,  /* (108) alter_db_options ::= alter_db_options alter_db_option */
   349,  /* (109) alter_db_option ::= BUFFER NK_INTEGER */
   349,  /* (110) alter_db_option ::= CACHEMODEL NK_STRING */
   349,  /* (111) alter_db_option ::= CACHESIZE NK_INTEGER */
   349,  /* (112) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   349,  /* (113) alter_db_option ::= KEEP integer_list */
   349,  /* (114) alter_db_option ::= KEEP variable_list */
   349,  /* (115) alter_db_option ::= PAGES NK_INTEGER */
   349,  /* (116) alter_db_option ::= REPLICA NK_INTEGER */
   349,  /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   349,  /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   346,  /* (119) integer_list ::= NK_INTEGER */
   346,  /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   347,  /* (121) variable_list ::= NK_VARIABLE */
   347,  /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   348,  /* (123) retention_list ::= retention */
   348,  /* (124) retention_list ::= retention_list NK_COMMA retention */
   350,  /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
   345,  /* (126) speed_opt ::= */
   345,  /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
   326,  /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   326,  /* (129) cmd ::= CREATE TABLE multi_create_clause */
   326,  /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   326,  /* (131) cmd ::= DROP TABLE multi_drop_clause */
   326,  /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
   326,  /* (133) cmd ::= ALTER TABLE alter_table_clause */
   326,  /* (134) cmd ::= ALTER STABLE alter_table_clause */
   358,  /* (135) alter_table_clause ::= full_table_name alter_table_options */
   358,  /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   358,  /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   358,  /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   358,  /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   358,  /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   358,  /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
   358,  /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   358,  /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   358,  /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   355,  /* (145) multi_create_clause ::= create_subtable_clause */
   355,  /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
   363,  /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   357,  /* (148) multi_drop_clause ::= drop_table_clause */
   357,  /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
   366,  /* (150) drop_table_clause ::= exists_opt full_table_name */
   364,  /* (151) specific_cols_opt ::= */
   364,  /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   351,  /* (153) full_table_name ::= table_name */
   351,  /* (154) full_table_name ::= db_name NK_DOT table_name */
   352,  /* (155) column_def_list ::= column_def */
   352,  /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
   369,  /* (157) column_def ::= column_name type_name */
   369,  /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
   361,  /* (159) type_name ::= BOOL */
   361,  /* (160) type_name ::= TINYINT */
   361,  /* (161) type_name ::= SMALLINT */
   361,  /* (162) type_name ::= INT */
   361,  /* (163) type_name ::= INTEGER */
   361,  /* (164) type_name ::= BIGINT */
   361,  /* (165) type_name ::= FLOAT */
   361,  /* (166) type_name ::= DOUBLE */
   361,  /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   361,  /* (168) type_name ::= TIMESTAMP */
   361,  /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   361,  /* (170) type_name ::= TINYINT UNSIGNED */
   361,  /* (171) type_name ::= SMALLINT UNSIGNED */
   361,  /* (172) type_name ::= INT UNSIGNED */
   361,  /* (173) type_name ::= BIGINT UNSIGNED */
   361,  /* (174) type_name ::= JSON */
   361,  /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   361,  /* (176) type_name ::= MEDIUMBLOB */
   361,  /* (177) type_name ::= BLOB */
   361,  /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   361,  /* (179) type_name ::= DECIMAL */
   361,  /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   361,  /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
   353,  /* (182) tags_def_opt ::= */
   353,  /* (183) tags_def_opt ::= tags_def */
   356,  /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
   354,  /* (185) table_options ::= */
   354,  /* (186) table_options ::= table_options COMMENT NK_STRING */
   354,  /* (187) table_options ::= table_options MAX_DELAY duration_list */
   354,  /* (188) table_options ::= table_options WATERMARK duration_list */
   354,  /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   354,  /* (190) table_options ::= table_options TTL NK_INTEGER */
   354,  /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   354,  /* (192) table_options ::= table_options DELETE_MARK duration_list */
   359,  /* (193) alter_table_options ::= alter_table_option */
   359,  /* (194) alter_table_options ::= alter_table_options alter_table_option */
   372,  /* (195) alter_table_option ::= COMMENT NK_STRING */
   372,  /* (196) alter_table_option ::= TTL NK_INTEGER */
   370,  /* (197) duration_list ::= duration_literal */
   370,  /* (198) duration_list ::= duration_list NK_COMMA duration_literal */
   371,  /* (199) rollup_func_list ::= rollup_func_name */
   371,  /* (200) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   374,  /* (201) rollup_func_name ::= function_name */
   374,  /* (202) rollup_func_name ::= FIRST */
   374,  /* (203) rollup_func_name ::= LAST */
   367,  /* (204) col_name_list ::= col_name */
   367,  /* (205) col_name_list ::= col_name_list NK_COMMA col_name */
   376,  /* (206) col_name ::= column_name */
   326,  /* (207) cmd ::= SHOW DNODES */
   326,  /* (208) cmd ::= SHOW USERS */
   326,  /* (209) cmd ::= SHOW USER PRIVILEGES */
   326,  /* (210) cmd ::= SHOW DATABASES */
   326,  /* (211) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   326,  /* (212) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   326,  /* (213) cmd ::= SHOW db_name_cond_opt VGROUPS */
   326,  /* (214) cmd ::= SHOW MNODES */
   326,  /* (215) cmd ::= SHOW QNODES */
   326,  /* (216) cmd ::= SHOW FUNCTIONS */
   326,  /* (217) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   326,  /* (218) cmd ::= SHOW STREAMS */
   326,  /* (219) cmd ::= SHOW ACCOUNTS */
   326,  /* (220) cmd ::= SHOW APPS */
   326,  /* (221) cmd ::= SHOW CONNECTIONS */
   326,  /* (222) cmd ::= SHOW LICENCES */
   326,  /* (223) cmd ::= SHOW GRANTS */
   326,  /* (224) cmd ::= SHOW CREATE DATABASE db_name */
   326,  /* (225) cmd ::= SHOW CREATE TABLE full_table_name */
   326,  /* (226) cmd ::= SHOW CREATE STABLE full_table_name */
   326,  /* (227) cmd ::= SHOW QUERIES */
   326,  /* (228) cmd ::= SHOW SCORES */
   326,  /* (229) cmd ::= SHOW TOPICS */
   326,  /* (230) cmd ::= SHOW VARIABLES */
   326,  /* (231) cmd ::= SHOW CLUSTER VARIABLES */
   326,  /* (232) cmd ::= SHOW LOCAL VARIABLES */
   326,  /* (233) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   326,  /* (234) cmd ::= SHOW BNODES */
   326,  /* (235) cmd ::= SHOW SNODES */
   326,  /* (236) cmd ::= SHOW CLUSTER */
   326,  /* (237) cmd ::= SHOW TRANSACTIONS */
   326,  /* (238) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   326,  /* (239) cmd ::= SHOW CONSUMERS */
   326,  /* (240) cmd ::= SHOW SUBSCRIPTIONS */
   326,  /* (241) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   326,  /* (242) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   326,  /* (243) cmd ::= SHOW VNODES NK_INTEGER */
   326,  /* (244) cmd ::= SHOW VNODES NK_STRING */
   326,  /* (245) cmd ::= SHOW db_name_cond_opt ALIVE */
   326,  /* (246) cmd ::= SHOW CLUSTER ALIVE */
   377,  /* (247) db_name_cond_opt ::= */
   377,  /* (248) db_name_cond_opt ::= db_name NK_DOT */
   378,  /* (249) like_pattern_opt ::= */
   378,  /* (250) like_pattern_opt ::= LIKE NK_STRING */
   379,  /* (251) table_name_cond ::= table_name */
   380,  /* (252) from_db_opt ::= */
   380,  /* (253) from_db_opt ::= FROM db_name */
   381,  /* (254) tag_list_opt ::= */
   381,  /* (255) tag_list_opt ::= tag_item */
   381,  /* (256) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   382,  /* (257) tag_item ::= TBNAME */
   382,  /* (258) tag_item ::= QTAGS */
   382,  /* (259) tag_item ::= column_name */
   382,  /* (260) tag_item ::= column_name column_alias */
   382,  /* (261) tag_item ::= column_name AS column_alias */
   326,  /* (262) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
   326,  /* (263) cmd ::= CREATE INDEX not_exists_opt full_table_name ON full_table_name NK_LP col_name_list NK_RP */
   326,  /* (264) cmd ::= DROP INDEX exists_opt full_table_name */
   384,  /* (265) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
   384,  /* (266) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   385,  /* (267) func_list ::= func */
   385,  /* (268) func_list ::= func_list NK_COMMA func */
   388,  /* (269) func ::= sma_func_name NK_LP expression_list NK_RP */
   389,  /* (270) sma_func_name ::= function_name */
   389,  /* (271) sma_func_name ::= COUNT */
   389,  /* (272) sma_func_name ::= FIRST */
   389,  /* (273) sma_func_name ::= LAST */
   389,  /* (274) sma_func_name ::= LAST_ROW */
   387,  /* (275) sma_stream_opt ::= */
   387,  /* (276) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   387,  /* (277) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   387,  /* (278) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   326,  /* (279) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   326,  /* (280) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   326,  /* (281) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   326,  /* (282) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   326,  /* (283) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   326,  /* (284) cmd ::= DROP TOPIC exists_opt topic_name */
   326,  /* (285) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   326,  /* (286) cmd ::= DESC full_table_name */
   326,  /* (287) cmd ::= DESCRIBE full_table_name */
   326,  /* (288) cmd ::= RESET QUERY CACHE */
   326,  /* (289) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   392,  /* (290) analyze_opt ::= */
   392,  /* (291) analyze_opt ::= ANALYZE */
   393,  /* (292) explain_options ::= */
   393,  /* (293) explain_options ::= explain_options VERBOSE NK_BOOL */
   393,  /* (294) explain_options ::= explain_options RATIO NK_FLOAT */
   326,  /* (295) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
   326,  /* (296) cmd ::= DROP FUNCTION exists_opt function_name */
   394,  /* (297) agg_func_opt ::= */
   394,  /* (298) agg_func_opt ::= AGGREGATE */
   395,  /* (299) bufsize_opt ::= */
   395,  /* (300) bufsize_opt ::= BUFSIZE NK_INTEGER */
   326,  /* (301) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tags_def_opt subtable_opt AS query_or_subquery */
   326,  /* (302) cmd ::= DROP STREAM exists_opt stream_name */
   398,  /* (303) col_list_opt ::= */
   398,  /* (304) col_list_opt ::= NK_LP col_name_list NK_RP */
   397,  /* (305) stream_options ::= */
   397,  /* (306) stream_options ::= stream_options TRIGGER AT_ONCE */
   397,  /* (307) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   397,  /* (308) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   397,  /* (309) stream_options ::= stream_options WATERMARK duration_literal */
   397,  /* (310) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   397,  /* (311) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   399,  /* (312) subtable_opt ::= */
   399,  /* (313) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   326,  /* (314) cmd ::= KILL CONNECTION NK_INTEGER */
   326,  /* (315) cmd ::= KILL QUERY NK_STRING */
   326,  /* (316) cmd ::= KILL TRANSACTION NK_INTEGER */
   326,  /* (317) cmd ::= BALANCE VGROUP */
   326,  /* (318) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   326,  /* (319) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   326,  /* (320) cmd ::= SPLIT VGROUP NK_INTEGER */
   401,  /* (321) dnode_list ::= DNODE NK_INTEGER */
   401,  /* (322) dnode_list ::= dnode_list DNODE NK_INTEGER */
   326,  /* (323) cmd ::= DELETE FROM full_table_name where_clause_opt */
   326,  /* (324) cmd ::= query_or_subquery */
   326,  /* (325) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   326,  /* (326) cmd ::= INSERT INTO full_table_name query_or_subquery */
   329,  /* (327) literal ::= NK_INTEGER */
   329,  /* (328) literal ::= NK_FLOAT */
   329,  /* (329) literal ::= NK_STRING */
   329,  /* (330) literal ::= NK_BOOL */
   329,  /* (331) literal ::= TIMESTAMP NK_STRING */
   329,  /* (332) literal ::= duration_literal */
   329,  /* (333) literal ::= NULL */
   329,  /* (334) literal ::= NK_QUESTION */
   373,  /* (335) duration_literal ::= NK_VARIABLE */
   403,  /* (336) signed ::= NK_INTEGER */
   403,  /* (337) signed ::= NK_PLUS NK_INTEGER */
   403,  /* (338) signed ::= NK_MINUS NK_INTEGER */
   403,  /* (339) signed ::= NK_FLOAT */
   403,  /* (340) signed ::= NK_PLUS NK_FLOAT */
   403,  /* (341) signed ::= NK_MINUS NK_FLOAT */
   362,  /* (342) signed_literal ::= signed */
   362,  /* (343) signed_literal ::= NK_STRING */
   362,  /* (344) signed_literal ::= NK_BOOL */
   362,  /* (345) signed_literal ::= TIMESTAMP NK_STRING */
   362,  /* (346) signed_literal ::= duration_literal */
   362,  /* (347) signed_literal ::= NULL */
   362,  /* (348) signed_literal ::= literal_func */
   362,  /* (349) signed_literal ::= NK_QUESTION */
   405,  /* (350) literal_list ::= signed_literal */
   405,  /* (351) literal_list ::= literal_list NK_COMMA signed_literal */
   337,  /* (352) db_name ::= NK_ID */
   368,  /* (353) table_name ::= NK_ID */
   360,  /* (354) column_name ::= NK_ID */
   375,  /* (355) function_name ::= NK_ID */
   406,  /* (356) table_alias ::= NK_ID */
   383,  /* (357) column_alias ::= NK_ID */
   331,  /* (358) user_name ::= NK_ID */
   338,  /* (359) topic_name ::= NK_ID */
   396,  /* (360) stream_name ::= NK_ID */
   391,  /* (361) cgroup_name ::= NK_ID */
   407,  /* (362) expr_or_subquery ::= expression */
   400,  /* (363) expression ::= literal */
   400,  /* (364) expression ::= pseudo_column */
   400,  /* (365) expression ::= column_reference */
   400,  /* (366) expression ::= function_expression */
   400,  /* (367) expression ::= case_when_expression */
   400,  /* (368) expression ::= NK_LP expression NK_RP */
   400,  /* (369) expression ::= NK_PLUS expr_or_subquery */
   400,  /* (370) expression ::= NK_MINUS expr_or_subquery */
   400,  /* (371) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   400,  /* (372) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   400,  /* (373) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   400,  /* (374) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   400,  /* (375) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   400,  /* (376) expression ::= column_reference NK_ARROW NK_STRING */
   400,  /* (377) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   400,  /* (378) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   365,  /* (379) expression_list ::= expr_or_subquery */
   365,  /* (380) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   409,  /* (381) column_reference ::= column_name */
   409,  /* (382) column_reference ::= table_name NK_DOT column_name */
   408,  /* (383) pseudo_column ::= ROWTS */
   408,  /* (384) pseudo_column ::= TBNAME */
   408,  /* (385) pseudo_column ::= table_name NK_DOT TBNAME */
   408,  /* (386) pseudo_column ::= QSTART */
   408,  /* (387) pseudo_column ::= QEND */
   408,  /* (388) pseudo_column ::= QDURATION */
   408,  /* (389) pseudo_column ::= WSTART */
   408,  /* (390) pseudo_column ::= WEND */
   408,  /* (391) pseudo_column ::= WDURATION */
   408,  /* (392) pseudo_column ::= IROWTS */
   408,  /* (393) pseudo_column ::= ISFILLED */
   408,  /* (394) pseudo_column ::= QTAGS */
   410,  /* (395) function_expression ::= function_name NK_LP expression_list NK_RP */
   410,  /* (396) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   410,  /* (397) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   410,  /* (398) function_expression ::= literal_func */
   404,  /* (399) literal_func ::= noarg_func NK_LP NK_RP */
   404,  /* (400) literal_func ::= NOW */
   414,  /* (401) noarg_func ::= NOW */
   414,  /* (402) noarg_func ::= TODAY */
   414,  /* (403) noarg_func ::= TIMEZONE */
   414,  /* (404) noarg_func ::= DATABASE */
   414,  /* (405) noarg_func ::= CLIENT_VERSION */
   414,  /* (406) noarg_func ::= SERVER_VERSION */
   414,  /* (407) noarg_func ::= SERVER_STATUS */
   414,  /* (408) noarg_func ::= CURRENT_USER */
   414,  /* (409) noarg_func ::= USER */
   412,  /* (410) star_func ::= COUNT */
   412,  /* (411) star_func ::= FIRST */
   412,  /* (412) star_func ::= LAST */
   412,  /* (413) star_func ::= LAST_ROW */
   413,  /* (414) star_func_para_list ::= NK_STAR */
   413,  /* (415) star_func_para_list ::= other_para_list */
   415,  /* (416) other_para_list ::= star_func_para */
   415,  /* (417) other_para_list ::= other_para_list NK_COMMA star_func_para */
   416,  /* (418) star_func_para ::= expr_or_subquery */
   416,  /* (419) star_func_para ::= table_name NK_DOT NK_STAR */
   411,  /* (420) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   411,  /* (421) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   417,  /* (422) when_then_list ::= when_then_expr */
   417,  /* (423) when_then_list ::= when_then_list when_then_expr */
   420,  /* (424) when_then_expr ::= WHEN common_expression THEN common_expression */
   418,  /* (425) case_when_else_opt ::= */
   418,  /* (426) case_when_else_opt ::= ELSE common_expression */
   421,  /* (427) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   421,  /* (428) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   421,  /* (429) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   421,  /* (430) predicate ::= expr_or_subquery IS NULL */
   421,  /* (431) predicate ::= expr_or_subquery IS NOT NULL */
   421,  /* (432) predicate ::= expr_or_subquery in_op in_predicate_value */
   422,  /* (433) compare_op ::= NK_LT */
   422,  /* (434) compare_op ::= NK_GT */
   422,  /* (435) compare_op ::= NK_LE */
   422,  /* (436) compare_op ::= NK_GE */
   422,  /* (437) compare_op ::= NK_NE */
   422,  /* (438) compare_op ::= NK_EQ */
   422,  /* (439) compare_op ::= LIKE */
   422,  /* (440) compare_op ::= NOT LIKE */
   422,  /* (441) compare_op ::= MATCH */
   422,  /* (442) compare_op ::= NMATCH */
   422,  /* (443) compare_op ::= CONTAINS */
   423,  /* (444) in_op ::= IN */
   423,  /* (445) in_op ::= NOT IN */
   424,  /* (446) in_predicate_value ::= NK_LP literal_list NK_RP */
   425,  /* (447) boolean_value_expression ::= boolean_primary */
   425,  /* (448) boolean_value_expression ::= NOT boolean_primary */
   425,  /* (449) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   425,  /* (450) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   426,  /* (451) boolean_primary ::= predicate */
   426,  /* (452) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   419,  /* (453) common_expression ::= expr_or_subquery */
   419,  /* (454) common_expression ::= boolean_value_expression */
   427,  /* (455) from_clause_opt ::= */
   427,  /* (456) from_clause_opt ::= FROM table_reference_list */
   428,  /* (457) table_reference_list ::= table_reference */
   428,  /* (458) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   429,  /* (459) table_reference ::= table_primary */
   429,  /* (460) table_reference ::= joined_table */
   430,  /* (461) table_primary ::= table_name alias_opt */
   430,  /* (462) table_primary ::= db_name NK_DOT table_name alias_opt */
   430,  /* (463) table_primary ::= subquery alias_opt */
   430,  /* (464) table_primary ::= parenthesized_joined_table */
   432,  /* (465) alias_opt ::= */
   432,  /* (466) alias_opt ::= table_alias */
   432,  /* (467) alias_opt ::= AS table_alias */
   434,  /* (468) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   434,  /* (469) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   431,  /* (470) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
   435,  /* (471) join_type ::= */
   435,  /* (472) join_type ::= INNER */
   437,  /* (473) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
   438,  /* (474) set_quantifier_opt ::= */
   438,  /* (475) set_quantifier_opt ::= DISTINCT */
   438,  /* (476) set_quantifier_opt ::= ALL */
   439,  /* (477) select_list ::= select_item */
   439,  /* (478) select_list ::= select_list NK_COMMA select_item */
   447,  /* (479) select_item ::= NK_STAR */
   447,  /* (480) select_item ::= common_expression */
   447,  /* (481) select_item ::= common_expression column_alias */
   447,  /* (482) select_item ::= common_expression AS column_alias */
   447,  /* (483) select_item ::= table_name NK_DOT NK_STAR */
   402,  /* (484) where_clause_opt ::= */
   402,  /* (485) where_clause_opt ::= WHERE search_condition */
   440,  /* (486) partition_by_clause_opt ::= */
   440,  /* (487) partition_by_clause_opt ::= PARTITION BY partition_list */
   448,  /* (488) partition_list ::= partition_item */
   448,  /* (489) partition_list ::= partition_list NK_COMMA partition_item */
   449,  /* (490) partition_item ::= expr_or_subquery */
   449,  /* (491) partition_item ::= expr_or_subquery column_alias */
   449,  /* (492) partition_item ::= expr_or_subquery AS column_alias */
   444,  /* (493) twindow_clause_opt ::= */
   444,  /* (494) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   444,  /* (495) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   444,  /* (496) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   444,  /* (497) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   444,  /* (498) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
   386,  /* (499) sliding_opt ::= */
   386,  /* (500) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
   443,  /* (501) fill_opt ::= */
   443,  /* (502) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   443,  /* (503) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
   450,  /* (504) fill_mode ::= NONE */
   450,  /* (505) fill_mode ::= PREV */
   450,  /* (506) fill_mode ::= NULL */
   450,  /* (507) fill_mode ::= LINEAR */
   450,  /* (508) fill_mode ::= NEXT */
   445,  /* (509) group_by_clause_opt ::= */
   445,  /* (510) group_by_clause_opt ::= GROUP BY group_by_list */
   451,  /* (511) group_by_list ::= expr_or_subquery */
   451,  /* (512) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
   446,  /* (513) having_clause_opt ::= */
   446,  /* (514) having_clause_opt ::= HAVING search_condition */
   441,  /* (515) range_opt ::= */
   441,  /* (516) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
   442,  /* (517) every_opt ::= */
   442,  /* (518) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   452,  /* (519) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   453,  /* (520) query_simple ::= query_specification */
   453,  /* (521) query_simple ::= union_query_expression */
   457,  /* (522) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   457,  /* (523) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   458,  /* (524) query_simple_or_subquery ::= query_simple */
   458,  /* (525) query_simple_or_subquery ::= subquery */
   390,  /* (526) query_or_subquery ::= query_expression */
   390,  /* (527) query_or_subquery ::= subquery */
   454,  /* (528) order_by_clause_opt ::= */
   454,  /* (529) order_by_clause_opt ::= ORDER BY sort_specification_list */
   455,  /* (530) slimit_clause_opt ::= */
   455,  /* (531) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   455,  /* (532) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   455,  /* (533) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   456,  /* (534) limit_clause_opt ::= */
   456,  /* (535) limit_clause_opt ::= LIMIT NK_INTEGER */
   456,  /* (536) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   456,  /* (537) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   433,  /* (538) subquery ::= NK_LP query_expression NK_RP */
   433,  /* (539) subquery ::= NK_LP subquery NK_RP */
   436,  /* (540) search_condition ::= common_expression */
   459,  /* (541) sort_specification_list ::= sort_specification */
   459,  /* (542) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   460,  /* (543) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
   461,  /* (544) ordering_specification_opt ::= */
   461,  /* (545) ordering_specification_opt ::= ASC */
   461,  /* (546) ordering_specification_opt ::= DESC */
   462,  /* (547) null_ordering_opt ::= */
   462,  /* (548) null_ordering_opt ::= NULLS FIRST */
   462,  /* (549) null_ordering_opt ::= NULLS LAST */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -6,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   -4,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
    0,  /* (2) account_options ::= */
   -3,  /* (3) account_options ::= account_options PPS literal */
   -3,  /* (4) account_options ::= account_options TSERIES literal */
   -3,  /* (5) account_options ::= account_options STORAGE literal */
   -3,  /* (6) account_options ::= account_options STREAMS literal */
   -3,  /* (7) account_options ::= account_options QTIME literal */
   -3,  /* (8) account_options ::= account_options DBS literal */
   -3,  /* (9) account_options ::= account_options USERS literal */
   -3,  /* (10) account_options ::= account_options CONNS literal */
   -3,  /* (11) account_options ::= account_options STATE literal */
   -1,  /* (12) alter_account_options ::= alter_account_option */
   -2,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   -2,  /* (14) alter_account_option ::= PASS literal */
   -2,  /* (15) alter_account_option ::= PPS literal */
   -2,  /* (16) alter_account_option ::= TSERIES literal */
   -2,  /* (17) alter_account_option ::= STORAGE literal */
   -2,  /* (18) alter_account_option ::= STREAMS literal */
   -2,  /* (19) alter_account_option ::= QTIME literal */
   -2,  /* (20) alter_account_option ::= DBS literal */
   -2,  /* (21) alter_account_option ::= USERS literal */
   -2,  /* (22) alter_account_option ::= CONNS literal */
   -2,  /* (23) alter_account_option ::= STATE literal */
   -6,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   -5,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   -5,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   -5,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   -3,  /* (28) cmd ::= DROP USER user_name */
    0,  /* (29) sysinfo_opt ::= */
   -2,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   -6,  /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
   -6,  /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
   -1,  /* (33) privileges ::= ALL */
   -1,  /* (34) privileges ::= priv_type_list */
   -1,  /* (35) privileges ::= SUBSCRIBE */
   -1,  /* (36) priv_type_list ::= priv_type */
   -3,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   -1,  /* (38) priv_type ::= READ */
   -1,  /* (39) priv_type ::= WRITE */
   -3,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   -3,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   -1,  /* (42) priv_level ::= topic_name */
   -3,  /* (43) cmd ::= CREATE DNODE dnode_endpoint */
   -5,  /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   -4,  /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
   -4,  /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
   -4,  /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   -5,  /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   -4,  /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
   -5,  /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   -1,  /* (51) dnode_endpoint ::= NK_STRING */
   -1,  /* (52) dnode_endpoint ::= NK_ID */
   -1,  /* (53) dnode_endpoint ::= NK_IPTOKEN */
    0,  /* (54) force_opt ::= */
   -1,  /* (55) force_opt ::= FORCE */
   -3,  /* (56) cmd ::= ALTER LOCAL NK_STRING */
   -4,  /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   -5,  /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   -5,  /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   -5,  /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   -5,  /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   -5,  /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   -5,  /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   -5,  /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   -5,  /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   -5,  /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   -4,  /* (67) cmd ::= DROP DATABASE exists_opt db_name */
   -2,  /* (68) cmd ::= USE db_name */
   -4,  /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
   -3,  /* (70) cmd ::= FLUSH DATABASE db_name */
   -4,  /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
   -3,  /* (72) not_exists_opt ::= IF NOT EXISTS */
    0,  /* (73) not_exists_opt ::= */
   -2,  /* (74) exists_opt ::= IF EXISTS */
    0,  /* (75) exists_opt ::= */
    0,  /* (76) db_options ::= */
   -3,  /* (77) db_options ::= db_options BUFFER NK_INTEGER */
   -3,  /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
   -3,  /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
   -3,  /* (80) db_options ::= db_options COMP NK_INTEGER */
   -3,  /* (81) db_options ::= db_options DURATION NK_INTEGER */
   -3,  /* (82) db_options ::= db_options DURATION NK_VARIABLE */
   -3,  /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
   -3,  /* (84) db_options ::= db_options MINROWS NK_INTEGER */
   -3,  /* (85) db_options ::= db_options KEEP integer_list */
   -3,  /* (86) db_options ::= db_options KEEP variable_list */
   -3,  /* (87) db_options ::= db_options PAGES NK_INTEGER */
   -3,  /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
   -3,  /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   -3,  /* (90) db_options ::= db_options PRECISION NK_STRING */
   -3,  /* (91) db_options ::= db_options REPLICA NK_INTEGER */
   -3,  /* (92) db_options ::= db_options VGROUPS NK_INTEGER */
   -3,  /* (93) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   -3,  /* (94) db_options ::= db_options RETENTIONS retention_list */
   -3,  /* (95) db_options ::= db_options SCHEMALESS NK_INTEGER */
   -3,  /* (96) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   -3,  /* (97) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   -3,  /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   -4,  /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -3,  /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   -4,  /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -3,  /* (102) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   -3,  /* (103) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   -3,  /* (104) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   -3,  /* (105) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
   -3,  /* (106) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
   -1,  /* (107) alter_db_options ::= alter_db_option */
   -2,  /* (108) alter_db_options ::= alter_db_options alter_db_option */
   -2,  /* (109) alter_db_option ::= BUFFER NK_INTEGER */
   -2,  /* (110) alter_db_option ::= CACHEMODEL NK_STRING */
   -2,  /* (111) alter_db_option ::= CACHESIZE NK_INTEGER */
   -2,  /* (112) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   -2,  /* (113) alter_db_option ::= KEEP integer_list */
   -2,  /* (114) alter_db_option ::= KEEP variable_list */
   -2,  /* (115) alter_db_option ::= PAGES NK_INTEGER */
   -2,  /* (116) alter_db_option ::= REPLICA NK_INTEGER */
   -2,  /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   -2,  /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   -1,  /* (119) integer_list ::= NK_INTEGER */
   -3,  /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   -1,  /* (121) variable_list ::= NK_VARIABLE */
   -3,  /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   -1,  /* (123) retention_list ::= retention */
   -3,  /* (124) retention_list ::= retention_list NK_COMMA retention */
   -3,  /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
    0,  /* (126) speed_opt ::= */
   -2,  /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
   -9,  /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   -3,  /* (129) cmd ::= CREATE TABLE multi_create_clause */
   -9,  /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   -3,  /* (131) cmd ::= DROP TABLE multi_drop_clause */
   -4,  /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
   -3,  /* (133) cmd ::= ALTER TABLE alter_table_clause */
   -3,  /* (134) cmd ::= ALTER STABLE alter_table_clause */
   -2,  /* (135) alter_table_clause ::= full_table_name alter_table_options */
   -5,  /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   -4,  /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   -5,  /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   -5,  /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   -5,  /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   -4,  /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
   -5,  /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   -5,  /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   -6,  /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   -1,  /* (145) multi_create_clause ::= create_subtable_clause */
   -2,  /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
  -10,  /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   -1,  /* (148) multi_drop_clause ::= drop_table_clause */
   -2,  /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
   -2,  /* (150) drop_table_clause ::= exists_opt full_table_name */
    0,  /* (151) specific_cols_opt ::= */
   -3,  /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   -1,  /* (153) full_table_name ::= table_name */
   -3,  /* (154) full_table_name ::= db_name NK_DOT table_name */
   -1,  /* (155) column_def_list ::= column_def */
   -3,  /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
   -2,  /* (157) column_def ::= column_name type_name */
   -4,  /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
   -1,  /* (159) type_name ::= BOOL */
   -1,  /* (160) type_name ::= TINYINT */
   -1,  /* (161) type_name ::= SMALLINT */
   -1,  /* (162) type_name ::= INT */
   -1,  /* (163) type_name ::= INTEGER */
   -1,  /* (164) type_name ::= BIGINT */
   -1,  /* (165) type_name ::= FLOAT */
   -1,  /* (166) type_name ::= DOUBLE */
   -4,  /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (168) type_name ::= TIMESTAMP */
   -4,  /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   -2,  /* (170) type_name ::= TINYINT UNSIGNED */
   -2,  /* (171) type_name ::= SMALLINT UNSIGNED */
   -2,  /* (172) type_name ::= INT UNSIGNED */
   -2,  /* (173) type_name ::= BIGINT UNSIGNED */
   -1,  /* (174) type_name ::= JSON */
   -4,  /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   -1,  /* (176) type_name ::= MEDIUMBLOB */
   -1,  /* (177) type_name ::= BLOB */
   -4,  /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (179) type_name ::= DECIMAL */
   -4,  /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   -6,  /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
    0,  /* (182) tags_def_opt ::= */
   -1,  /* (183) tags_def_opt ::= tags_def */
   -4,  /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
    0,  /* (185) table_options ::= */
   -3,  /* (186) table_options ::= table_options COMMENT NK_STRING */
   -3,  /* (187) table_options ::= table_options MAX_DELAY duration_list */
   -3,  /* (188) table_options ::= table_options WATERMARK duration_list */
   -5,  /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   -3,  /* (190) table_options ::= table_options TTL NK_INTEGER */
   -5,  /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   -3,  /* (192) table_options ::= table_options DELETE_MARK duration_list */
   -1,  /* (193) alter_table_options ::= alter_table_option */
   -2,  /* (194) alter_table_options ::= alter_table_options alter_table_option */
   -2,  /* (195) alter_table_option ::= COMMENT NK_STRING */
   -2,  /* (196) alter_table_option ::= TTL NK_INTEGER */
   -1,  /* (197) duration_list ::= duration_literal */
   -3,  /* (198) duration_list ::= duration_list NK_COMMA duration_literal */
   -1,  /* (199) rollup_func_list ::= rollup_func_name */
   -3,  /* (200) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   -1,  /* (201) rollup_func_name ::= function_name */
   -1,  /* (202) rollup_func_name ::= FIRST */
   -1,  /* (203) rollup_func_name ::= LAST */
   -1,  /* (204) col_name_list ::= col_name */
   -3,  /* (205) col_name_list ::= col_name_list NK_COMMA col_name */
   -1,  /* (206) col_name ::= column_name */
   -2,  /* (207) cmd ::= SHOW DNODES */
   -2,  /* (208) cmd ::= SHOW USERS */
   -3,  /* (209) cmd ::= SHOW USER PRIVILEGES */
   -2,  /* (210) cmd ::= SHOW DATABASES */
   -4,  /* (211) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   -4,  /* (212) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   -3,  /* (213) cmd ::= SHOW db_name_cond_opt VGROUPS */
   -2,  /* (214) cmd ::= SHOW MNODES */
   -2,  /* (215) cmd ::= SHOW QNODES */
   -2,  /* (216) cmd ::= SHOW FUNCTIONS */
   -5,  /* (217) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   -2,  /* (218) cmd ::= SHOW STREAMS */
   -2,  /* (219) cmd ::= SHOW ACCOUNTS */
   -2,  /* (220) cmd ::= SHOW APPS */
   -2,  /* (221) cmd ::= SHOW CONNECTIONS */
   -2,  /* (222) cmd ::= SHOW LICENCES */
   -2,  /* (223) cmd ::= SHOW GRANTS */
   -4,  /* (224) cmd ::= SHOW CREATE DATABASE db_name */
   -4,  /* (225) cmd ::= SHOW CREATE TABLE full_table_name */
   -4,  /* (226) cmd ::= SHOW CREATE STABLE full_table_name */
   -2,  /* (227) cmd ::= SHOW QUERIES */
   -2,  /* (228) cmd ::= SHOW SCORES */
   -2,  /* (229) cmd ::= SHOW TOPICS */
   -2,  /* (230) cmd ::= SHOW VARIABLES */
   -3,  /* (231) cmd ::= SHOW CLUSTER VARIABLES */
   -3,  /* (232) cmd ::= SHOW LOCAL VARIABLES */
   -5,  /* (233) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   -2,  /* (234) cmd ::= SHOW BNODES */
   -2,  /* (235) cmd ::= SHOW SNODES */
   -2,  /* (236) cmd ::= SHOW CLUSTER */
   -2,  /* (237) cmd ::= SHOW TRANSACTIONS */
   -4,  /* (238) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   -2,  /* (239) cmd ::= SHOW CONSUMERS */
   -2,  /* (240) cmd ::= SHOW SUBSCRIPTIONS */
   -5,  /* (241) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   -7,  /* (242) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   -3,  /* (243) cmd ::= SHOW VNODES NK_INTEGER */
   -3,  /* (244) cmd ::= SHOW VNODES NK_STRING */
   -3,  /* (245) cmd ::= SHOW db_name_cond_opt ALIVE */
   -3,  /* (246) cmd ::= SHOW CLUSTER ALIVE */
    0,  /* (247) db_name_cond_opt ::= */
   -2,  /* (248) db_name_cond_opt ::= db_name NK_DOT */
    0,  /* (249) like_pattern_opt ::= */
   -2,  /* (250) like_pattern_opt ::= LIKE NK_STRING */
   -1,  /* (251) table_name_cond ::= table_name */
    0,  /* (252) from_db_opt ::= */
   -2,  /* (253) from_db_opt ::= FROM db_name */
    0,  /* (254) tag_list_opt ::= */
   -1,  /* (255) tag_list_opt ::= tag_item */
   -3,  /* (256) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   -1,  /* (257) tag_item ::= TBNAME */
   -1,  /* (258) tag_item ::= QTAGS */
   -1,  /* (259) tag_item ::= column_name */
   -2,  /* (260) tag_item ::= column_name column_alias */
   -3,  /* (261) tag_item ::= column_name AS column_alias */
   -8,  /* (262) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
   -9,  /* (263) cmd ::= CREATE INDEX not_exists_opt full_table_name ON full_table_name NK_LP col_name_list NK_RP */
   -4,  /* (264) cmd ::= DROP INDEX exists_opt full_table_name */
  -10,  /* (265) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  -12,  /* (266) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   -1,  /* (267) func_list ::= func */
   -3,  /* (268) func_list ::= func_list NK_COMMA func */
   -4,  /* (269) func ::= sma_func_name NK_LP expression_list NK_RP */
   -1,  /* (270) sma_func_name ::= function_name */
   -1,  /* (271) sma_func_name ::= COUNT */
   -1,  /* (272) sma_func_name ::= FIRST */
   -1,  /* (273) sma_func_name ::= LAST */
   -1,  /* (274) sma_func_name ::= LAST_ROW */
    0,  /* (275) sma_stream_opt ::= */
   -3,  /* (276) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   -3,  /* (277) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   -3,  /* (278) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   -6,  /* (279) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   -7,  /* (280) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   -9,  /* (281) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   -7,  /* (282) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   -9,  /* (283) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   -4,  /* (284) cmd ::= DROP TOPIC exists_opt topic_name */
   -7,  /* (285) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   -2,  /* (286) cmd ::= DESC full_table_name */
   -2,  /* (287) cmd ::= DESCRIBE full_table_name */
   -3,  /* (288) cmd ::= RESET QUERY CACHE */
   -4,  /* (289) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
    0,  /* (290) analyze_opt ::= */
   -1,  /* (291) analyze_opt ::= ANALYZE */
    0,  /* (292) explain_options ::= */
   -3,  /* (293) explain_options ::= explain_options VERBOSE NK_BOOL */
   -3,  /* (294) explain_options ::= explain_options RATIO NK_FLOAT */
  -10,  /* (295) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
   -4,  /* (296) cmd ::= DROP FUNCTION exists_opt function_name */
    0,  /* (297) agg_func_opt ::= */
   -1,  /* (298) agg_func_opt ::= AGGREGATE */
    0,  /* (299) bufsize_opt ::= */
   -2,  /* (300) bufsize_opt ::= BUFSIZE NK_INTEGER */
  -12,  /* (301) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tags_def_opt subtable_opt AS query_or_subquery */
   -4,  /* (302) cmd ::= DROP STREAM exists_opt stream_name */
    0,  /* (303) col_list_opt ::= */
   -3,  /* (304) col_list_opt ::= NK_LP col_name_list NK_RP */
    0,  /* (305) stream_options ::= */
   -3,  /* (306) stream_options ::= stream_options TRIGGER AT_ONCE */
   -3,  /* (307) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   -4,  /* (308) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   -3,  /* (309) stream_options ::= stream_options WATERMARK duration_literal */
   -4,  /* (310) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   -3,  /* (311) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
    0,  /* (312) subtable_opt ::= */
   -4,  /* (313) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   -3,  /* (314) cmd ::= KILL CONNECTION NK_INTEGER */
   -3,  /* (315) cmd ::= KILL QUERY NK_STRING */
   -3,  /* (316) cmd ::= KILL TRANSACTION NK_INTEGER */
   -2,  /* (317) cmd ::= BALANCE VGROUP */
   -4,  /* (318) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   -4,  /* (319) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   -3,  /* (320) cmd ::= SPLIT VGROUP NK_INTEGER */
   -2,  /* (321) dnode_list ::= DNODE NK_INTEGER */
   -3,  /* (322) dnode_list ::= dnode_list DNODE NK_INTEGER */
   -4,  /* (323) cmd ::= DELETE FROM full_table_name where_clause_opt */
   -1,  /* (324) cmd ::= query_or_subquery */
   -7,  /* (325) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   -4,  /* (326) cmd ::= INSERT INTO full_table_name query_or_subquery */
   -1,  /* (327) literal ::= NK_INTEGER */
   -1,  /* (328) literal ::= NK_FLOAT */
   -1,  /* (329) literal ::= NK_STRING */
   -1,  /* (330) literal ::= NK_BOOL */
   -2,  /* (331) literal ::= TIMESTAMP NK_STRING */
   -1,  /* (332) literal ::= duration_literal */
   -1,  /* (333) literal ::= NULL */
   -1,  /* (334) literal ::= NK_QUESTION */
   -1,  /* (335) duration_literal ::= NK_VARIABLE */
   -1,  /* (336) signed ::= NK_INTEGER */
   -2,  /* (337) signed ::= NK_PLUS NK_INTEGER */
   -2,  /* (338) signed ::= NK_MINUS NK_INTEGER */
   -1,  /* (339) signed ::= NK_FLOAT */
   -2,  /* (340) signed ::= NK_PLUS NK_FLOAT */
   -2,  /* (341) signed ::= NK_MINUS NK_FLOAT */
   -1,  /* (342) signed_literal ::= signed */
   -1,  /* (343) signed_literal ::= NK_STRING */
   -1,  /* (344) signed_literal ::= NK_BOOL */
   -2,  /* (345) signed_literal ::= TIMESTAMP NK_STRING */
   -1,  /* (346) signed_literal ::= duration_literal */
   -1,  /* (347) signed_literal ::= NULL */
   -1,  /* (348) signed_literal ::= literal_func */
   -1,  /* (349) signed_literal ::= NK_QUESTION */
   -1,  /* (350) literal_list ::= signed_literal */
   -3,  /* (351) literal_list ::= literal_list NK_COMMA signed_literal */
   -1,  /* (352) db_name ::= NK_ID */
   -1,  /* (353) table_name ::= NK_ID */
   -1,  /* (354) column_name ::= NK_ID */
   -1,  /* (355) function_name ::= NK_ID */
   -1,  /* (356) table_alias ::= NK_ID */
   -1,  /* (357) column_alias ::= NK_ID */
   -1,  /* (358) user_name ::= NK_ID */
   -1,  /* (359) topic_name ::= NK_ID */
   -1,  /* (360) stream_name ::= NK_ID */
   -1,  /* (361) cgroup_name ::= NK_ID */
   -1,  /* (362) expr_or_subquery ::= expression */
   -1,  /* (363) expression ::= literal */
   -1,  /* (364) expression ::= pseudo_column */
   -1,  /* (365) expression ::= column_reference */
   -1,  /* (366) expression ::= function_expression */
   -1,  /* (367) expression ::= case_when_expression */
   -3,  /* (368) expression ::= NK_LP expression NK_RP */
   -2,  /* (369) expression ::= NK_PLUS expr_or_subquery */
   -2,  /* (370) expression ::= NK_MINUS expr_or_subquery */
   -3,  /* (371) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   -3,  /* (372) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   -3,  /* (373) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   -3,  /* (374) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   -3,  /* (375) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   -3,  /* (376) expression ::= column_reference NK_ARROW NK_STRING */
   -3,  /* (377) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   -3,  /* (378) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   -1,  /* (379) expression_list ::= expr_or_subquery */
   -3,  /* (380) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   -1,  /* (381) column_reference ::= column_name */
   -3,  /* (382) column_reference ::= table_name NK_DOT column_name */
   -1,  /* (383) pseudo_column ::= ROWTS */
   -1,  /* (384) pseudo_column ::= TBNAME */
   -3,  /* (385) pseudo_column ::= table_name NK_DOT TBNAME */
   -1,  /* (386) pseudo_column ::= QSTART */
   -1,  /* (387) pseudo_column ::= QEND */
   -1,  /* (388) pseudo_column ::= QDURATION */
   -1,  /* (389) pseudo_column ::= WSTART */
   -1,  /* (390) pseudo_column ::= WEND */
   -1,  /* (391) pseudo_column ::= WDURATION */
   -1,  /* (392) pseudo_column ::= IROWTS */
   -1,  /* (393) pseudo_column ::= ISFILLED */
   -1,  /* (394) pseudo_column ::= QTAGS */
   -4,  /* (395) function_expression ::= function_name NK_LP expression_list NK_RP */
   -4,  /* (396) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   -6,  /* (397) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   -1,  /* (398) function_expression ::= literal_func */
   -3,  /* (399) literal_func ::= noarg_func NK_LP NK_RP */
   -1,  /* (400) literal_func ::= NOW */
   -1,  /* (401) noarg_func ::= NOW */
   -1,  /* (402) noarg_func ::= TODAY */
   -1,  /* (403) noarg_func ::= TIMEZONE */
   -1,  /* (404) noarg_func ::= DATABASE */
   -1,  /* (405) noarg_func ::= CLIENT_VERSION */
   -1,  /* (406) noarg_func ::= SERVER_VERSION */
   -1,  /* (407) noarg_func ::= SERVER_STATUS */
   -1,  /* (408) noarg_func ::= CURRENT_USER */
   -1,  /* (409) noarg_func ::= USER */
   -1,  /* (410) star_func ::= COUNT */
   -1,  /* (411) star_func ::= FIRST */
   -1,  /* (412) star_func ::= LAST */
   -1,  /* (413) star_func ::= LAST_ROW */
   -1,  /* (414) star_func_para_list ::= NK_STAR */
   -1,  /* (415) star_func_para_list ::= other_para_list */
   -1,  /* (416) other_para_list ::= star_func_para */
   -3,  /* (417) other_para_list ::= other_para_list NK_COMMA star_func_para */
   -1,  /* (418) star_func_para ::= expr_or_subquery */
   -3,  /* (419) star_func_para ::= table_name NK_DOT NK_STAR */
   -4,  /* (420) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   -5,  /* (421) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   -1,  /* (422) when_then_list ::= when_then_expr */
   -2,  /* (423) when_then_list ::= when_then_list when_then_expr */
   -4,  /* (424) when_then_expr ::= WHEN common_expression THEN common_expression */
    0,  /* (425) case_when_else_opt ::= */
   -2,  /* (426) case_when_else_opt ::= ELSE common_expression */
   -3,  /* (427) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   -5,  /* (428) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   -6,  /* (429) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   -3,  /* (430) predicate ::= expr_or_subquery IS NULL */
   -4,  /* (431) predicate ::= expr_or_subquery IS NOT NULL */
   -3,  /* (432) predicate ::= expr_or_subquery in_op in_predicate_value */
   -1,  /* (433) compare_op ::= NK_LT */
   -1,  /* (434) compare_op ::= NK_GT */
   -1,  /* (435) compare_op ::= NK_LE */
   -1,  /* (436) compare_op ::= NK_GE */
   -1,  /* (437) compare_op ::= NK_NE */
   -1,  /* (438) compare_op ::= NK_EQ */
   -1,  /* (439) compare_op ::= LIKE */
   -2,  /* (440) compare_op ::= NOT LIKE */
   -1,  /* (441) compare_op ::= MATCH */
   -1,  /* (442) compare_op ::= NMATCH */
   -1,  /* (443) compare_op ::= CONTAINS */
   -1,  /* (444) in_op ::= IN */
   -2,  /* (445) in_op ::= NOT IN */
   -3,  /* (446) in_predicate_value ::= NK_LP literal_list NK_RP */
   -1,  /* (447) boolean_value_expression ::= boolean_primary */
   -2,  /* (448) boolean_value_expression ::= NOT boolean_primary */
   -3,  /* (449) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   -3,  /* (450) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   -1,  /* (451) boolean_primary ::= predicate */
   -3,  /* (452) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   -1,  /* (453) common_expression ::= expr_or_subquery */
   -1,  /* (454) common_expression ::= boolean_value_expression */
    0,  /* (455) from_clause_opt ::= */
   -2,  /* (456) from_clause_opt ::= FROM table_reference_list */
   -1,  /* (457) table_reference_list ::= table_reference */
   -3,  /* (458) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   -1,  /* (459) table_reference ::= table_primary */
   -1,  /* (460) table_reference ::= joined_table */
   -2,  /* (461) table_primary ::= table_name alias_opt */
   -4,  /* (462) table_primary ::= db_name NK_DOT table_name alias_opt */
   -2,  /* (463) table_primary ::= subquery alias_opt */
   -1,  /* (464) table_primary ::= parenthesized_joined_table */
    0,  /* (465) alias_opt ::= */
   -1,  /* (466) alias_opt ::= table_alias */
   -2,  /* (467) alias_opt ::= AS table_alias */
   -3,  /* (468) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   -3,  /* (469) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   -6,  /* (470) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
    0,  /* (471) join_type ::= */
   -1,  /* (472) join_type ::= INNER */
  -12,  /* (473) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
    0,  /* (474) set_quantifier_opt ::= */
   -1,  /* (475) set_quantifier_opt ::= DISTINCT */
   -1,  /* (476) set_quantifier_opt ::= ALL */
   -1,  /* (477) select_list ::= select_item */
   -3,  /* (478) select_list ::= select_list NK_COMMA select_item */
   -1,  /* (479) select_item ::= NK_STAR */
   -1,  /* (480) select_item ::= common_expression */
   -2,  /* (481) select_item ::= common_expression column_alias */
   -3,  /* (482) select_item ::= common_expression AS column_alias */
   -3,  /* (483) select_item ::= table_name NK_DOT NK_STAR */
    0,  /* (484) where_clause_opt ::= */
   -2,  /* (485) where_clause_opt ::= WHERE search_condition */
    0,  /* (486) partition_by_clause_opt ::= */
   -3,  /* (487) partition_by_clause_opt ::= PARTITION BY partition_list */
   -1,  /* (488) partition_list ::= partition_item */
   -3,  /* (489) partition_list ::= partition_list NK_COMMA partition_item */
   -1,  /* (490) partition_item ::= expr_or_subquery */
   -2,  /* (491) partition_item ::= expr_or_subquery column_alias */
   -3,  /* (492) partition_item ::= expr_or_subquery AS column_alias */
    0,  /* (493) twindow_clause_opt ::= */
   -6,  /* (494) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   -4,  /* (495) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   -6,  /* (496) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   -8,  /* (497) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   -7,  /* (498) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
    0,  /* (499) sliding_opt ::= */
   -4,  /* (500) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
    0,  /* (501) fill_opt ::= */
   -4,  /* (502) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   -6,  /* (503) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
   -1,  /* (504) fill_mode ::= NONE */
   -1,  /* (505) fill_mode ::= PREV */
   -1,  /* (506) fill_mode ::= NULL */
   -1,  /* (507) fill_mode ::= LINEAR */
   -1,  /* (508) fill_mode ::= NEXT */
    0,  /* (509) group_by_clause_opt ::= */
   -3,  /* (510) group_by_clause_opt ::= GROUP BY group_by_list */
   -1,  /* (511) group_by_list ::= expr_or_subquery */
   -3,  /* (512) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
    0,  /* (513) having_clause_opt ::= */
   -2,  /* (514) having_clause_opt ::= HAVING search_condition */
    0,  /* (515) range_opt ::= */
   -6,  /* (516) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
    0,  /* (517) every_opt ::= */
   -4,  /* (518) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   -4,  /* (519) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   -1,  /* (520) query_simple ::= query_specification */
   -1,  /* (521) query_simple ::= union_query_expression */
   -4,  /* (522) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   -3,  /* (523) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   -1,  /* (524) query_simple_or_subquery ::= query_simple */
   -1,  /* (525) query_simple_or_subquery ::= subquery */
   -1,  /* (526) query_or_subquery ::= query_expression */
   -1,  /* (527) query_or_subquery ::= subquery */
    0,  /* (528) order_by_clause_opt ::= */
   -3,  /* (529) order_by_clause_opt ::= ORDER BY sort_specification_list */
    0,  /* (530) slimit_clause_opt ::= */
   -2,  /* (531) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   -4,  /* (532) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   -4,  /* (533) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
    0,  /* (534) limit_clause_opt ::= */
   -2,  /* (535) limit_clause_opt ::= LIMIT NK_INTEGER */
   -4,  /* (536) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   -4,  /* (537) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   -3,  /* (538) subquery ::= NK_LP query_expression NK_RP */
   -3,  /* (539) subquery ::= NK_LP subquery NK_RP */
   -1,  /* (540) search_condition ::= common_expression */
   -1,  /* (541) sort_specification_list ::= sort_specification */
   -3,  /* (542) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   -3,  /* (543) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
    0,  /* (544) ordering_specification_opt ::= */
   -1,  /* (545) ordering_specification_opt ::= ASC */
   -1,  /* (546) ordering_specification_opt ::= DESC */
    0,  /* (547) null_ordering_opt ::= */
   -2,  /* (548) null_ordering_opt ::= NULLS FIRST */
   -2,  /* (549) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,327,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,328,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,327,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,330,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,328,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,330,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy815, &yymsp[-1].minor.yy0, yymsp[0].minor.yy475); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy815, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy815, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy815, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy815); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy475 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy475 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy483, &yymsp[-2].minor.yy815, &yymsp[0].minor.yy815); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy483, &yymsp[-2].minor.yy815, &yymsp[0].minor.yy815); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy483 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy483 = yymsp[0].minor.yy483; }
  yymsp[0].minor.yy483 = yylhsminor.yy483;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy483 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy483 = yymsp[-2].minor.yy483 | yymsp[0].minor.yy483; }
  yymsp[-2].minor.yy483 = yylhsminor.yy483;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy483 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy483 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy815 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy815 = yylhsminor.yy815;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy815 = yymsp[-2].minor.yy815; }
  yymsp[-2].minor.yy815 = yylhsminor.yy815;
        break;
      case 42: /* priv_level ::= topic_name */
      case 270: /* sma_func_name ::= function_name */ yytestcase(yyruleno==270);
      case 466: /* alias_opt ::= table_alias */ yytestcase(yyruleno==466);
{ yylhsminor.yy815 = yymsp[0].minor.yy815; }
  yymsp[0].minor.yy815 = yylhsminor.yy815;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy815, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy815, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy63); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy815, yymsp[0].minor.yy63); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 271: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==271);
      case 272: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==272);
      case 273: /* sma_func_name ::= LAST */ yytestcase(yyruleno==273);
      case 274: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==274);
      case 352: /* db_name ::= NK_ID */ yytestcase(yyruleno==352);
      case 353: /* table_name ::= NK_ID */ yytestcase(yyruleno==353);
      case 354: /* column_name ::= NK_ID */ yytestcase(yyruleno==354);
      case 355: /* function_name ::= NK_ID */ yytestcase(yyruleno==355);
      case 356: /* table_alias ::= NK_ID */ yytestcase(yyruleno==356);
      case 357: /* column_alias ::= NK_ID */ yytestcase(yyruleno==357);
      case 358: /* user_name ::= NK_ID */ yytestcase(yyruleno==358);
      case 359: /* topic_name ::= NK_ID */ yytestcase(yyruleno==359);
      case 360: /* stream_name ::= NK_ID */ yytestcase(yyruleno==360);
      case 361: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==361);
      case 401: /* noarg_func ::= NOW */ yytestcase(yyruleno==401);
      case 402: /* noarg_func ::= TODAY */ yytestcase(yyruleno==402);
      case 403: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==403);
      case 404: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==404);
      case 405: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==405);
      case 406: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==406);
      case 407: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==407);
      case 408: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==408);
      case 409: /* noarg_func ::= USER */ yytestcase(yyruleno==409);
      case 410: /* star_func ::= COUNT */ yytestcase(yyruleno==410);
      case 411: /* star_func ::= FIRST */ yytestcase(yyruleno==411);
      case 412: /* star_func ::= LAST */ yytestcase(yyruleno==412);
      case 413: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==413);
{ yylhsminor.yy815 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy815 = yylhsminor.yy815;
        break;
      case 54: /* force_opt ::= */
      case 73: /* not_exists_opt ::= */ yytestcase(yyruleno==73);
      case 75: /* exists_opt ::= */ yytestcase(yyruleno==75);
      case 290: /* analyze_opt ::= */ yytestcase(yyruleno==290);
      case 297: /* agg_func_opt ::= */ yytestcase(yyruleno==297);
      case 474: /* set_quantifier_opt ::= */ yytestcase(yyruleno==474);
{ yymsp[1].minor.yy63 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 291: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==291);
      case 298: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==298);
      case 475: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==475);
{ yymsp[0].minor.yy63 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy63, &yymsp[-1].minor.yy815, yymsp[0].minor.yy320); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy63, &yymsp[0].minor.yy815); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy815); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy815, yymsp[0].minor.yy320); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy815); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy815, yymsp[0].minor.yy122); }
        break;
      case 72: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy63 = true; }
        break;
      case 74: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy63 = true; }
        break;
      case 76: /* db_options ::= */
{ yymsp[1].minor.yy320 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 77: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 78: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 79: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 80: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 81: /* db_options ::= db_options DURATION NK_INTEGER */
      case 82: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==82);
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 83: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 84: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 85: /* db_options ::= db_options KEEP integer_list */
      case 86: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==86);
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_KEEP, yymsp[0].minor.yy570); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 87: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 88: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 89: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 90: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 91: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 92: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 93: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 94: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_RETENTIONS, yymsp[0].minor.yy570); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 95: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 96: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 97: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-3].minor.yy320, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy320 = yylhsminor.yy320;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-3].minor.yy320, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy320 = yylhsminor.yy320;
        break;
      case 102: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 103: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 104: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 105: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 106: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy320 = setDatabaseOption(pCxt, yymsp[-2].minor.yy320, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 107: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy320 = createAlterDatabaseOptions(pCxt); yylhsminor.yy320 = setAlterDatabaseOption(pCxt, yylhsminor.yy320, &yymsp[0].minor.yy695); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 108: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy320 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy320, &yymsp[0].minor.yy695); }
  yymsp[-1].minor.yy320 = yylhsminor.yy320;
        break;
      case 109: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy695.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy695.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy695.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy695.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy695.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy695.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy695.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy695.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= KEEP integer_list */
      case 114: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==114);
{ yymsp[-1].minor.yy695.type = DB_OPTION_KEEP; yymsp[-1].minor.yy695.pList = yymsp[0].minor.yy570; }
        break;
      case 115: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy695.type = DB_OPTION_PAGES; yymsp[-1].minor.yy695.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy695.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy695.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy695.type = DB_OPTION_WAL; yymsp[-1].minor.yy695.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy695.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy695.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy570 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy570 = yylhsminor.yy570;
        break;
      case 120: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 322: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==322);
{ yylhsminor.yy570 = addNodeToList(pCxt, yymsp[-2].minor.yy570, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy570 = yylhsminor.yy570;
        break;
      case 121: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy570 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy570 = yylhsminor.yy570;
        break;
      case 122: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy570 = addNodeToList(pCxt, yymsp[-2].minor.yy570, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy570 = yylhsminor.yy570;
        break;
      case 123: /* retention_list ::= retention */
      case 145: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==145);
      case 148: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==148);
      case 155: /* column_def_list ::= column_def */ yytestcase(yyruleno==155);
      case 199: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==199);
      case 204: /* col_name_list ::= col_name */ yytestcase(yyruleno==204);
      case 255: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==255);
      case 267: /* func_list ::= func */ yytestcase(yyruleno==267);
      case 350: /* literal_list ::= signed_literal */ yytestcase(yyruleno==350);
      case 416: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==416);
      case 422: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==422);
      case 477: /* select_list ::= select_item */ yytestcase(yyruleno==477);
      case 488: /* partition_list ::= partition_item */ yytestcase(yyruleno==488);
      case 541: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==541);
{ yylhsminor.yy570 = createNodeList(pCxt, yymsp[0].minor.yy320); }
  yymsp[0].minor.yy570 = yylhsminor.yy570;
        break;
      case 124: /* retention_list ::= retention_list NK_COMMA retention */
      case 156: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==205);
      case 256: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==256);
      case 268: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==268);
      case 351: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==351);
      case 417: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==417);
      case 478: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==478);
      case 489: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==489);
      case 542: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==542);
{ yylhsminor.yy570 = addNodeToList(pCxt, yymsp[-2].minor.yy570, yymsp[0].minor.yy320); }
  yymsp[-2].minor.yy570 = yylhsminor.yy570;
        break;
      case 125: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy320 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 126: /* speed_opt ::= */
      case 299: /* bufsize_opt ::= */ yytestcase(yyruleno==299);
{ yymsp[1].minor.yy122 = 0; }
        break;
      case 127: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 300: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==300);
{ yymsp[-1].minor.yy122 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 128: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 130: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==130);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy63, yymsp[-5].minor.yy320, yymsp[-3].minor.yy570, yymsp[-1].minor.yy570, yymsp[0].minor.yy320); }
        break;
      case 129: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy570); }
        break;
      case 131: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy570); }
        break;
      case 132: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy63, yymsp[0].minor.yy320); }
        break;
      case 133: /* cmd ::= ALTER TABLE alter_table_clause */
      case 324: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==324);
{ pCxt->pRootNode = yymsp[0].minor.yy320; }
        break;
      case 134: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy320); }
        break;
      case 135: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy320 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy320, yymsp[0].minor.yy320); }
  yymsp[-1].minor.yy320 = yylhsminor.yy320;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy320 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy320, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy815, yymsp[0].minor.yy200); }
  yymsp[-4].minor.yy320 = yylhsminor.yy320;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy320 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy320, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy815); }
  yymsp[-3].minor.yy320 = yylhsminor.yy320;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy320 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy320, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy815, yymsp[0].minor.yy200); }
  yymsp[-4].minor.yy320 = yylhsminor.yy320;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy320 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy320, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy815, &yymsp[0].minor.yy815); }
  yymsp[-4].minor.yy320 = yylhsminor.yy320;
        break;
      case 140: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy320 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy320, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy815, yymsp[0].minor.yy200); }
  yymsp[-4].minor.yy320 = yylhsminor.yy320;
        break;
      case 141: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy320 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy320, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy815); }
  yymsp[-3].minor.yy320 = yylhsminor.yy320;
        break;
      case 142: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy320 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy320, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy815, yymsp[0].minor.yy200); }
  yymsp[-4].minor.yy320 = yylhsminor.yy320;
        break;
      case 143: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy320 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy320, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy815, &yymsp[0].minor.yy815); }
  yymsp[-4].minor.yy320 = yylhsminor.yy320;
        break;
      case 144: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy320 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy320, &yymsp[-2].minor.yy815, yymsp[0].minor.yy320); }
  yymsp[-5].minor.yy320 = yylhsminor.yy320;
        break;
      case 146: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 149: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==149);
      case 423: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==423);
{ yylhsminor.yy570 = addNodeToList(pCxt, yymsp[-1].minor.yy570, yymsp[0].minor.yy320); }
  yymsp[-1].minor.yy570 = yylhsminor.yy570;
        break;
      case 147: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy320 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy63, yymsp[-8].minor.yy320, yymsp[-6].minor.yy320, yymsp[-5].minor.yy570, yymsp[-2].minor.yy570, yymsp[0].minor.yy320); }
  yymsp[-9].minor.yy320 = yylhsminor.yy320;
        break;
      case 150: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy320 = createDropTableClause(pCxt, yymsp[-1].minor.yy63, yymsp[0].minor.yy320); }
  yymsp[-1].minor.yy320 = yylhsminor.yy320;
        break;
      case 151: /* specific_cols_opt ::= */
      case 182: /* tags_def_opt ::= */ yytestcase(yyruleno==182);
      case 254: /* tag_list_opt ::= */ yytestcase(yyruleno==254);
      case 303: /* col_list_opt ::= */ yytestcase(yyruleno==303);
      case 486: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==486);
      case 509: /* group_by_clause_opt ::= */ yytestcase(yyruleno==509);
      case 528: /* order_by_clause_opt ::= */ yytestcase(yyruleno==528);
{ yymsp[1].minor.yy570 = NULL; }
        break;
      case 152: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 304: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==304);
{ yymsp[-2].minor.yy570 = yymsp[-1].minor.yy570; }
        break;
      case 153: /* full_table_name ::= table_name */
{ yylhsminor.yy320 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy815, NULL); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 154: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy320 = createRealTableNode(pCxt, &yymsp[-2].minor.yy815, &yymsp[0].minor.yy815, NULL); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 157: /* column_def ::= column_name type_name */
{ yylhsminor.yy320 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy815, yymsp[0].minor.yy200, NULL); }
  yymsp[-1].minor.yy320 = yylhsminor.yy320;
        break;
      case 158: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy320 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy815, yymsp[-2].minor.yy200, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy320 = yylhsminor.yy320;
        break;
      case 159: /* type_name ::= BOOL */
{ yymsp[0].minor.yy200 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 160: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy200 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 161: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy200 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 162: /* type_name ::= INT */
      case 163: /* type_name ::= INTEGER */ yytestcase(yyruleno==163);
{ yymsp[0].minor.yy200 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 164: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy200 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 165: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy200 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 166: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy200 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 167: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy200 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy200 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 169: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy200 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy200 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy200 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 172: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy200 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 173: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy200 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 174: /* type_name ::= JSON */
{ yymsp[0].minor.yy200 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 175: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy200 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 176: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy200 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 177: /* type_name ::= BLOB */
{ yymsp[0].minor.yy200 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 178: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy200 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy200 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 180: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy200 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy200 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* tags_def_opt ::= tags_def */
      case 415: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==415);
{ yylhsminor.yy570 = yymsp[0].minor.yy570; }
  yymsp[0].minor.yy570 = yylhsminor.yy570;
        break;
      case 184: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy570 = yymsp[-1].minor.yy570; }
        break;
      case 185: /* table_options ::= */
{ yymsp[1].minor.yy320 = createDefaultTableOptions(pCxt); }
        break;
      case 186: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy320 = setTableOption(pCxt, yymsp[-2].minor.yy320, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 187: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy320 = setTableOption(pCxt, yymsp[-2].minor.yy320, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy570); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 188: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy320 = setTableOption(pCxt, yymsp[-2].minor.yy320, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy570); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 189: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy320 = setTableOption(pCxt, yymsp[-4].minor.yy320, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy570); }
  yymsp[-4].minor.yy320 = yylhsminor.yy320;
        break;
      case 190: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy320 = setTableOption(pCxt, yymsp[-2].minor.yy320, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 191: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy320 = setTableOption(pCxt, yymsp[-4].minor.yy320, TABLE_OPTION_SMA, yymsp[-1].minor.yy570); }
  yymsp[-4].minor.yy320 = yylhsminor.yy320;
        break;
      case 192: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy320 = setTableOption(pCxt, yymsp[-2].minor.yy320, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy570); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 193: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy320 = createAlterTableOptions(pCxt); yylhsminor.yy320 = setTableOption(pCxt, yylhsminor.yy320, yymsp[0].minor.yy695.type, &yymsp[0].minor.yy695.val); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 194: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy320 = setTableOption(pCxt, yymsp[-1].minor.yy320, yymsp[0].minor.yy695.type, &yymsp[0].minor.yy695.val); }
  yymsp[-1].minor.yy320 = yylhsminor.yy320;
        break;
      case 195: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy695.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy695.val = yymsp[0].minor.yy0; }
        break;
      case 196: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy695.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy695.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* duration_list ::= duration_literal */
      case 379: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==379);
{ yylhsminor.yy570 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy320)); }
  yymsp[0].minor.yy570 = yylhsminor.yy570;
        break;
      case 198: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 380: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==380);
{ yylhsminor.yy570 = addNodeToList(pCxt, yymsp[-2].minor.yy570, releaseRawExprNode(pCxt, yymsp[0].minor.yy320)); }
  yymsp[-2].minor.yy570 = yylhsminor.yy570;
        break;
      case 201: /* rollup_func_name ::= function_name */
{ yylhsminor.yy320 = createFunctionNode(pCxt, &yymsp[0].minor.yy815, NULL); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 202: /* rollup_func_name ::= FIRST */
      case 203: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==203);
      case 258: /* tag_item ::= QTAGS */ yytestcase(yyruleno==258);
{ yylhsminor.yy320 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 206: /* col_name ::= column_name */
      case 259: /* tag_item ::= column_name */ yytestcase(yyruleno==259);
{ yylhsminor.yy320 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy815); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 207: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 208: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 209: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 210: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 211: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy320, yymsp[0].minor.yy320, OP_TYPE_LIKE); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy320, yymsp[0].minor.yy320, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy320, NULL, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy320, yymsp[-1].minor.yy320, OP_TYPE_EQUAL); }
        break;
      case 218: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 219: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 220: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 221: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 222: /* cmd ::= SHOW LICENCES */
      case 223: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==223);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 224: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy815); }
        break;
      case 225: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy320); }
        break;
      case 226: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy320); }
        break;
      case 227: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 228: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 229: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 230: /* cmd ::= SHOW VARIABLES */
      case 231: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==231);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 232: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy320); }
        break;
      case 234: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 235: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 237: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 238: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy320); }
        break;
      case 239: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 240: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 241: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy320, yymsp[-1].minor.yy320, OP_TYPE_EQUAL); }
        break;
      case 242: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy320, yymsp[0].minor.yy320, yymsp[-3].minor.yy570); }
        break;
      case 243: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 245: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy320,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 246: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 247: /* db_name_cond_opt ::= */
      case 252: /* from_db_opt ::= */ yytestcase(yyruleno==252);
{ yymsp[1].minor.yy320 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 248: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy320 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy815); }
  yymsp[-1].minor.yy320 = yylhsminor.yy320;
        break;
      case 249: /* like_pattern_opt ::= */
      case 312: /* subtable_opt ::= */ yytestcase(yyruleno==312);
      case 425: /* case_when_else_opt ::= */ yytestcase(yyruleno==425);
      case 455: /* from_clause_opt ::= */ yytestcase(yyruleno==455);
      case 484: /* where_clause_opt ::= */ yytestcase(yyruleno==484);
      case 493: /* twindow_clause_opt ::= */ yytestcase(yyruleno==493);
      case 499: /* sliding_opt ::= */ yytestcase(yyruleno==499);
      case 501: /* fill_opt ::= */ yytestcase(yyruleno==501);
      case 513: /* having_clause_opt ::= */ yytestcase(yyruleno==513);
      case 515: /* range_opt ::= */ yytestcase(yyruleno==515);
      case 517: /* every_opt ::= */ yytestcase(yyruleno==517);
      case 530: /* slimit_clause_opt ::= */ yytestcase(yyruleno==530);
      case 534: /* limit_clause_opt ::= */ yytestcase(yyruleno==534);
{ yymsp[1].minor.yy320 = NULL; }
        break;
      case 250: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy320 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 251: /* table_name_cond ::= table_name */
{ yylhsminor.yy320 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy815); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 253: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy320 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy815); }
        break;
      case 257: /* tag_item ::= TBNAME */
{ yylhsminor.yy320 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 260: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy320 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy815), &yymsp[0].minor.yy815); }
  yymsp[-1].minor.yy320 = yylhsminor.yy320;
        break;
      case 261: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy320 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy815), &yymsp[0].minor.yy815); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 262: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy63, yymsp[-3].minor.yy320, yymsp[-1].minor.yy320, NULL, yymsp[0].minor.yy320); }
        break;
      case 263: /* cmd ::= CREATE INDEX not_exists_opt full_table_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy63, yymsp[-5].minor.yy320, yymsp[-3].minor.yy320, yymsp[-1].minor.yy570, NULL); }
        break;
      case 264: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy63, yymsp[0].minor.yy320); }
        break;
      case 265: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy320 = createIndexOption(pCxt, yymsp[-7].minor.yy570, releaseRawExprNode(pCxt, yymsp[-3].minor.yy320), NULL, yymsp[-1].minor.yy320, yymsp[0].minor.yy320); }
        break;
      case 266: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy320 = createIndexOption(pCxt, yymsp[-9].minor.yy570, releaseRawExprNode(pCxt, yymsp[-5].minor.yy320), releaseRawExprNode(pCxt, yymsp[-3].minor.yy320), yymsp[-1].minor.yy320, yymsp[0].minor.yy320); }
        break;
      case 269: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy320 = createFunctionNode(pCxt, &yymsp[-3].minor.yy815, yymsp[-1].minor.yy570); }
  yymsp[-3].minor.yy320 = yylhsminor.yy320;
        break;
      case 275: /* sma_stream_opt ::= */
      case 305: /* stream_options ::= */ yytestcase(yyruleno==305);
{ yymsp[1].minor.yy320 = createStreamOptions(pCxt); }
        break;
      case 276: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 309: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==309);
{ ((SStreamOptions*)yymsp[-2].minor.yy320)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy320); yylhsminor.yy320 = yymsp[-2].minor.yy320; }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 277: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy320)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy320); yylhsminor.yy320 = yymsp[-2].minor.yy320; }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 278: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy320)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy320); yylhsminor.yy320 = yymsp[-2].minor.yy320; }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 279: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy63, &yymsp[-2].minor.yy815, yymsp[0].minor.yy320); }
        break;
      case 280: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy63, &yymsp[-3].minor.yy815, &yymsp[0].minor.yy815, false); }
        break;
      case 281: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy63, &yymsp[-5].minor.yy815, &yymsp[0].minor.yy815, true); }
        break;
      case 282: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy63, &yymsp[-3].minor.yy815, yymsp[0].minor.yy320, false); }
        break;
      case 283: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy63, &yymsp[-5].minor.yy815, yymsp[0].minor.yy320, true); }
        break;
      case 284: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy63, &yymsp[0].minor.yy815); }
        break;
      case 285: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy63, &yymsp[-2].minor.yy815, &yymsp[0].minor.yy815); }
        break;
      case 286: /* cmd ::= DESC full_table_name */
      case 287: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==287);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy320); }
        break;
      case 288: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 289: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy63, yymsp[-1].minor.yy320, yymsp[0].minor.yy320); }
        break;
      case 292: /* explain_options ::= */
{ yymsp[1].minor.yy320 = createDefaultExplainOptions(pCxt); }
        break;
      case 293: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy320 = setExplainVerbose(pCxt, yymsp[-2].minor.yy320, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 294: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy320 = setExplainRatio(pCxt, yymsp[-2].minor.yy320, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 295: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy63, yymsp[-8].minor.yy63, &yymsp[-5].minor.yy815, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy200, yymsp[0].minor.yy122); }
        break;
      case 296: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy63, &yymsp[0].minor.yy815); }
        break;
      case 301: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy63, &yymsp[-8].minor.yy815, yymsp[-5].minor.yy320, yymsp[-7].minor.yy320, yymsp[-3].minor.yy570, yymsp[-2].minor.yy320, yymsp[0].minor.yy320, yymsp[-4].minor.yy570); }
        break;
      case 302: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy63, &yymsp[0].minor.yy815); }
        break;
      case 306: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy320)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy320 = yymsp[-2].minor.yy320; }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 307: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy320)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy320 = yymsp[-2].minor.yy320; }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 308: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy320)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy320)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy320); yylhsminor.yy320 = yymsp[-3].minor.yy320; }
  yymsp[-3].minor.yy320 = yylhsminor.yy320;
        break;
      case 310: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy320)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy320 = yymsp[-3].minor.yy320; }
  yymsp[-3].minor.yy320 = yylhsminor.yy320;
        break;
      case 311: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy320)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy320 = yymsp[-2].minor.yy320; }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 313: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 500: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==500);
      case 518: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==518);
{ yymsp[-3].minor.yy320 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy320); }
        break;
      case 314: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 315: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 316: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 317: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 318: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 319: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy570); }
        break;
      case 320: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 321: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy570 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 323: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy320, yymsp[0].minor.yy320); }
        break;
      case 325: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy320, yymsp[-2].minor.yy570, yymsp[0].minor.yy320); }
        break;
      case 326: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy320, NULL, yymsp[0].minor.yy320); }
        break;
      case 327: /* literal ::= NK_INTEGER */
{ yylhsminor.yy320 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 328: /* literal ::= NK_FLOAT */
{ yylhsminor.yy320 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 329: /* literal ::= NK_STRING */
{ yylhsminor.yy320 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 330: /* literal ::= NK_BOOL */
{ yylhsminor.yy320 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 331: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy320 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy320 = yylhsminor.yy320;
        break;
      case 332: /* literal ::= duration_literal */
      case 342: /* signed_literal ::= signed */ yytestcase(yyruleno==342);
      case 362: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==362);
      case 363: /* expression ::= literal */ yytestcase(yyruleno==363);
      case 364: /* expression ::= pseudo_column */ yytestcase(yyruleno==364);
      case 365: /* expression ::= column_reference */ yytestcase(yyruleno==365);
      case 366: /* expression ::= function_expression */ yytestcase(yyruleno==366);
      case 367: /* expression ::= case_when_expression */ yytestcase(yyruleno==367);
      case 398: /* function_expression ::= literal_func */ yytestcase(yyruleno==398);
      case 447: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==447);
      case 451: /* boolean_primary ::= predicate */ yytestcase(yyruleno==451);
      case 453: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==453);
      case 454: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==454);
      case 457: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==457);
      case 459: /* table_reference ::= table_primary */ yytestcase(yyruleno==459);
      case 460: /* table_reference ::= joined_table */ yytestcase(yyruleno==460);
      case 464: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==464);
      case 520: /* query_simple ::= query_specification */ yytestcase(yyruleno==520);
      case 521: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==521);
      case 524: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==524);
      case 526: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==526);
{ yylhsminor.yy320 = yymsp[0].minor.yy320; }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 333: /* literal ::= NULL */
{ yylhsminor.yy320 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 334: /* literal ::= NK_QUESTION */
{ yylhsminor.yy320 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 335: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy320 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 336: /* signed ::= NK_INTEGER */
{ yylhsminor.yy320 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 337: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy320 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 338: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy320 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy320 = yylhsminor.yy320;
        break;
      case 339: /* signed ::= NK_FLOAT */
{ yylhsminor.yy320 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 340: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy320 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 341: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy320 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy320 = yylhsminor.yy320;
        break;
      case 343: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy320 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 344: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy320 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 345: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy320 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 346: /* signed_literal ::= duration_literal */
      case 348: /* signed_literal ::= literal_func */ yytestcase(yyruleno==348);
      case 418: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==418);
      case 480: /* select_item ::= common_expression */ yytestcase(yyruleno==480);
      case 490: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==490);
      case 525: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==525);
      case 527: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==527);
      case 540: /* search_condition ::= common_expression */ yytestcase(yyruleno==540);
{ yylhsminor.yy320 = releaseRawExprNode(pCxt, yymsp[0].minor.yy320); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 347: /* signed_literal ::= NULL */
{ yylhsminor.yy320 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 349: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy320 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 368: /* expression ::= NK_LP expression NK_RP */
      case 452: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==452);
      case 539: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==539);
{ yylhsminor.yy320 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy320)); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 369: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy320);
                                                                                    yylhsminor.yy320 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy320));
                                                                                  }
  yymsp[-1].minor.yy320 = yylhsminor.yy320;
        break;
      case 370: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy320);
                                                                                    yylhsminor.yy320 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy320), NULL));
                                                                                  }
  yymsp[-1].minor.yy320 = yylhsminor.yy320;
        break;
      case 371: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy320);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy320);
                                                                                    yylhsminor.yy320 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy320), releaseRawExprNode(pCxt, yymsp[0].minor.yy320))); 
                                                                                  }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 372: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy320);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy320);
                                                                                    yylhsminor.yy320 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy320), releaseRawExprNode(pCxt, yymsp[0].minor.yy320))); 
                                                                                  }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 373: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy320);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy320);
                                                                                    yylhsminor.yy320 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy320), releaseRawExprNode(pCxt, yymsp[0].minor.yy320))); 
                                                                                  }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 374: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy320);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy320);
                                                                                    yylhsminor.yy320 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy320), releaseRawExprNode(pCxt, yymsp[0].minor.yy320))); 
                                                                                  }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 375: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy320);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy320);
                                                                                    yylhsminor.yy320 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy320), releaseRawExprNode(pCxt, yymsp[0].minor.yy320)));
                                                                                  }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 376: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy320);
                                                                                    yylhsminor.yy320 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy320), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 377: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy320);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy320);
                                                                                    yylhsminor.yy320 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy320), releaseRawExprNode(pCxt, yymsp[0].minor.yy320)));
                                                                                  }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 378: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy320);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy320);
                                                                                    yylhsminor.yy320 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy320), releaseRawExprNode(pCxt, yymsp[0].minor.yy320)));
                                                                                  }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 381: /* column_reference ::= column_name */
{ yylhsminor.yy320 = createRawExprNode(pCxt, &yymsp[0].minor.yy815, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy815)); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 382: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy320 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy815, &yymsp[0].minor.yy815, createColumnNode(pCxt, &yymsp[-2].minor.yy815, &yymsp[0].minor.yy815)); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 383: /* pseudo_column ::= ROWTS */
      case 384: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==384);
      case 386: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==386);
      case 387: /* pseudo_column ::= QEND */ yytestcase(yyruleno==387);
      case 388: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==388);
      case 389: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==389);
      case 390: /* pseudo_column ::= WEND */ yytestcase(yyruleno==390);
      case 391: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==391);
      case 392: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==392);
      case 393: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==393);
      case 394: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==394);
      case 400: /* literal_func ::= NOW */ yytestcase(yyruleno==400);
{ yylhsminor.yy320 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 385: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy320 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy815, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy815)))); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 395: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 396: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==396);
{ yylhsminor.yy320 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy815, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy815, yymsp[-1].minor.yy570)); }
  yymsp[-3].minor.yy320 = yylhsminor.yy320;
        break;
      case 397: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy320 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy320), yymsp[-1].minor.yy200)); }
  yymsp[-5].minor.yy320 = yylhsminor.yy320;
        break;
      case 399: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy320 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy815, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy815, NULL)); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 414: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy570 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy570 = yylhsminor.yy570;
        break;
      case 419: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 483: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==483);
{ yylhsminor.yy320 = createColumnNode(pCxt, &yymsp[-2].minor.yy815, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 420: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy320 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy570, yymsp[-1].minor.yy320)); }
  yymsp[-3].minor.yy320 = yylhsminor.yy320;
        break;
      case 421: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy320 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy320), yymsp[-2].minor.yy570, yymsp[-1].minor.yy320)); }
  yymsp[-4].minor.yy320 = yylhsminor.yy320;
        break;
      case 424: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy320 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy320), releaseRawExprNode(pCxt, yymsp[0].minor.yy320)); }
        break;
      case 426: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy320 = releaseRawExprNode(pCxt, yymsp[0].minor.yy320); }
        break;
      case 427: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 432: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==432);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy320);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy320);
                                                                                    yylhsminor.yy320 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy828, releaseRawExprNode(pCxt, yymsp[-2].minor.yy320), releaseRawExprNode(pCxt, yymsp[0].minor.yy320)));
                                                                                  }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 428: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy320);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy320);
                                                                                    yylhsminor.yy320 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy320), releaseRawExprNode(pCxt, yymsp[-2].minor.yy320), releaseRawExprNode(pCxt, yymsp[0].minor.yy320)));
                                                                                  }
  yymsp[-4].minor.yy320 = yylhsminor.yy320;
        break;
      case 429: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy320);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy320);
                                                                                    yylhsminor.yy320 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy320), releaseRawExprNode(pCxt, yymsp[-2].minor.yy320), releaseRawExprNode(pCxt, yymsp[0].minor.yy320)));
                                                                                  }
  yymsp[-5].minor.yy320 = yylhsminor.yy320;
        break;
      case 430: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy320);
                                                                                    yylhsminor.yy320 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy320), NULL));
                                                                                  }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 431: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy320);
                                                                                    yylhsminor.yy320 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy320), NULL));
                                                                                  }
  yymsp[-3].minor.yy320 = yylhsminor.yy320;
        break;
      case 433: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy828 = OP_TYPE_LOWER_THAN; }
        break;
      case 434: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy828 = OP_TYPE_GREATER_THAN; }
        break;
      case 435: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy828 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 436: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy828 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 437: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy828 = OP_TYPE_NOT_EQUAL; }
        break;
      case 438: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy828 = OP_TYPE_EQUAL; }
        break;
      case 439: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy828 = OP_TYPE_LIKE; }
        break;
      case 440: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy828 = OP_TYPE_NOT_LIKE; }
        break;
      case 441: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy828 = OP_TYPE_MATCH; }
        break;
      case 442: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy828 = OP_TYPE_NMATCH; }
        break;
      case 443: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy828 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 444: /* in_op ::= IN */
{ yymsp[0].minor.yy828 = OP_TYPE_IN; }
        break;
      case 445: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy828 = OP_TYPE_NOT_IN; }
        break;
      case 446: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy320 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy570)); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 448: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy320);
                                                                                    yylhsminor.yy320 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy320), NULL));
                                                                                  }
  yymsp[-1].minor.yy320 = yylhsminor.yy320;
        break;
      case 449: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy320);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy320);
                                                                                    yylhsminor.yy320 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy320), releaseRawExprNode(pCxt, yymsp[0].minor.yy320)));
                                                                                  }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 450: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy320);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy320);
                                                                                    yylhsminor.yy320 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy320), releaseRawExprNode(pCxt, yymsp[0].minor.yy320)));
                                                                                  }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 456: /* from_clause_opt ::= FROM table_reference_list */
      case 485: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==485);
      case 514: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==514);
{ yymsp[-1].minor.yy320 = yymsp[0].minor.yy320; }
        break;
      case 458: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy320 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy320, yymsp[0].minor.yy320, NULL); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 461: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy320 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy815, &yymsp[0].minor.yy815); }
  yymsp[-1].minor.yy320 = yylhsminor.yy320;
        break;
      case 462: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy320 = createRealTableNode(pCxt, &yymsp[-3].minor.yy815, &yymsp[-1].minor.yy815, &yymsp[0].minor.yy815); }
  yymsp[-3].minor.yy320 = yylhsminor.yy320;
        break;
      case 463: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy320 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy320), &yymsp[0].minor.yy815); }
  yymsp[-1].minor.yy320 = yylhsminor.yy320;
        break;
      case 465: /* alias_opt ::= */
{ yymsp[1].minor.yy815 = nil_token;  }
        break;
      case 467: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy815 = yymsp[0].minor.yy815; }
        break;
      case 468: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 469: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==469);
{ yymsp[-2].minor.yy320 = yymsp[-1].minor.yy320; }
        break;
      case 470: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy320 = createJoinTableNode(pCxt, yymsp[-4].minor.yy334, yymsp[-5].minor.yy320, yymsp[-2].minor.yy320, yymsp[0].minor.yy320); }
  yymsp[-5].minor.yy320 = yylhsminor.yy320;
        break;
      case 471: /* join_type ::= */
{ yymsp[1].minor.yy334 = JOIN_TYPE_INNER; }
        break;
      case 472: /* join_type ::= INNER */
{ yymsp[0].minor.yy334 = JOIN_TYPE_INNER; }
        break;
      case 473: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy320 = createSelectStmt(pCxt, yymsp[-10].minor.yy63, yymsp[-9].minor.yy570, yymsp[-8].minor.yy320);
                                                                                    yymsp[-11].minor.yy320 = addWhereClause(pCxt, yymsp[-11].minor.yy320, yymsp[-7].minor.yy320);
                                                                                    yymsp[-11].minor.yy320 = addPartitionByClause(pCxt, yymsp[-11].minor.yy320, yymsp[-6].minor.yy570);
                                                                                    yymsp[-11].minor.yy320 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy320, yymsp[-2].minor.yy320);
                                                                                    yymsp[-11].minor.yy320 = addGroupByClause(pCxt, yymsp[-11].minor.yy320, yymsp[-1].minor.yy570);
                                                                                    yymsp[-11].minor.yy320 = addHavingClause(pCxt, yymsp[-11].minor.yy320, yymsp[0].minor.yy320);
                                                                                    yymsp[-11].minor.yy320 = addRangeClause(pCxt, yymsp[-11].minor.yy320, yymsp[-5].minor.yy320);
                                                                                    yymsp[-11].minor.yy320 = addEveryClause(pCxt, yymsp[-11].minor.yy320, yymsp[-4].minor.yy320);
                                                                                    yymsp[-11].minor.yy320 = addFillClause(pCxt, yymsp[-11].minor.yy320, yymsp[-3].minor.yy320);
                                                                                  }
        break;
      case 476: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy63 = false; }
        break;
      case 479: /* select_item ::= NK_STAR */
{ yylhsminor.yy320 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy320 = yylhsminor.yy320;
        break;
      case 481: /* select_item ::= common_expression column_alias */
      case 491: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==491);
{ yylhsminor.yy320 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy320), &yymsp[0].minor.yy815); }
  yymsp[-1].minor.yy320 = yylhsminor.yy320;
        break;
      case 482: /* select_item ::= common_expression AS column_alias */
      case 492: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==492);
{ yylhsminor.yy320 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy320), &yymsp[0].minor.yy815); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 487: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 510: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==510);
      case 529: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==529);
{ yymsp[-2].minor.yy570 = yymsp[0].minor.yy570; }
        break;
      case 494: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy320 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy320), releaseRawExprNode(pCxt, yymsp[-1].minor.yy320)); }
        break;
      case 495: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy320 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy320)); }
        break;
      case 496: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy320 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy320), NULL, yymsp[-1].minor.yy320, yymsp[0].minor.yy320); }
        break;
      case 497: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy320 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy320), releaseRawExprNode(pCxt, yymsp[-3].minor.yy320), yymsp[-1].minor.yy320, yymsp[0].minor.yy320); }
        break;
      case 498: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy320 = createEventWindowNode(pCxt, yymsp[-3].minor.yy320, yymsp[0].minor.yy320); }
        break;
      case 502: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy320 = createFillNode(pCxt, yymsp[-1].minor.yy762, NULL); }
        break;
      case 503: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy320 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy570)); }
        break;
      case 504: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy762 = FILL_MODE_NONE; }
        break;
      case 505: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy762 = FILL_MODE_PREV; }
        break;
      case 506: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy762 = FILL_MODE_NULL; }
        break;
      case 507: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy762 = FILL_MODE_LINEAR; }
        break;
      case 508: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy762 = FILL_MODE_NEXT; }
        break;
      case 511: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy570 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy320))); }
  yymsp[0].minor.yy570 = yylhsminor.yy570;
        break;
      case 512: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy570 = addNodeToList(pCxt, yymsp[-2].minor.yy570, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy320))); }
  yymsp[-2].minor.yy570 = yylhsminor.yy570;
        break;
      case 516: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy320 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy320), releaseRawExprNode(pCxt, yymsp[-1].minor.yy320)); }
        break;
      case 519: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy320 = addOrderByClause(pCxt, yymsp[-3].minor.yy320, yymsp[-2].minor.yy570);
                                                                                    yylhsminor.yy320 = addSlimitClause(pCxt, yylhsminor.yy320, yymsp[-1].minor.yy320);
                                                                                    yylhsminor.yy320 = addLimitClause(pCxt, yylhsminor.yy320, yymsp[0].minor.yy320);
                                                                                  }
  yymsp[-3].minor.yy320 = yylhsminor.yy320;
        break;
      case 522: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy320 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy320, yymsp[0].minor.yy320); }
  yymsp[-3].minor.yy320 = yylhsminor.yy320;
        break;
      case 523: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy320 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy320, yymsp[0].minor.yy320); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 531: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 535: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==535);
{ yymsp[-1].minor.yy320 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 532: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 536: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==536);
{ yymsp[-3].minor.yy320 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 533: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 537: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==537);
{ yymsp[-3].minor.yy320 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 538: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy320 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy320); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 543: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy320 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy320), yymsp[-1].minor.yy162, yymsp[0].minor.yy715); }
  yymsp[-2].minor.yy320 = yylhsminor.yy320;
        break;
      case 544: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy162 = ORDER_ASC; }
        break;
      case 545: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy162 = ORDER_ASC; }
        break;
      case 546: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy162 = ORDER_DESC; }
        break;
      case 547: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy715 = NULL_ORDER_DEFAULT; }
        break;
      case 548: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy715 = NULL_ORDER_FIRST; }
        break;
      case 549: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy715 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
