/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 473
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOperatorType yy62;
  SToken yy63;
  EOrder yy158;
  SNodeList* yy222;
  SAlterOption yy233;
  int32_t yy332;
  int64_t yy393;
  EJoinType yy574;
  bool yy669;
  ENullOrder yy675;
  SDataType yy686;
  int8_t yy707;
  EFillMode yy822;
  SNode* yy828;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             758
#define YYNRULE              578
#define YYNTOKEN             329
#define YY_MAX_SHIFT         757
#define YY_MIN_SHIFTREDUCE   1129
#define YY_MAX_SHIFTREDUCE   1706
#define YY_ERROR_ACTION      1707
#define YY_ACCEPT_ACTION     1708
#define YY_NO_ACTION         1709
#define YY_MIN_REDUCE        1710
#define YY_MAX_REDUCE        2287
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2833)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  2085, 2263, 1996,  166, 2099, 2258,  493, 2117,  494, 1746,
 /*    10 */  1818, 2081,   45,   43, 1634,  604, 1996, 1994,  634, 2085,
 /*    20 */   387, 2262, 1483,  622, 1508, 2259, 2261, 2099,  378, 2202,
 /*    30 */  2081, 1993,  634, 1564, 2035, 1481, 1853, 2117,   44,   42,
 /*    40 */    41,   40,   39,  432,  646,  625, 2077, 2083,  368, 1181,
 /*    50 */  2067, 1180,  663,  633,  647, 2199,  139,  657, 1559, 2263,
 /*    60 */  2117,  603, 1930, 2258,   18, 2077, 2083,  369,  664,  350,
 /*    70 */   132, 1489,  167, 2067, 1722,  663,  657,  532, 1928, 2262,
 /*    80 */  1182,  240, 2098, 2259, 2260,  333, 2134, 1877,  646,  109,
 /*    90 */  2100,  667, 2102, 2103,  662, 2085,  657,  754,   65,  701,
 /*   100 */    14,  179,  509, 2187, 1989, 2098, 2081,  381, 2183, 2134,
 /*   110 */    45,   43,  168, 2100,  667, 2102, 2103,  662,  387,  657,
 /*   120 */  1483,  184,  270, 2195,  621,  141,  133,  620, 2158, 2213,
 /*   130 */  2258, 1564, 1181, 1481, 1180,  392, 1566, 1567, 1923, 1925,
 /*   140 */   610, 2077, 2083,  382, 2258,  609,  182,  222,   35,  291,
 /*   150 */  2259,  611,  657,  586, 2224,  273, 1559, 1854,  632,  609,
 /*   160 */   182,  646,   18, 1182, 2259,  611, 1539, 1549,   48, 1489,
 /*   170 */  1776,  194, 1565, 1568,   38,   37,  178,  647,   44,   42,
 /*   180 */    41,   40,   39,  550,  549,  548, 1484,  511, 1482, 1917,
 /*   190 */   540,  136,  544,  132,   61,  754,  543,   61,   14,   92,
 /*   200 */   537,  542,  547,  360,  359,  499,  502,  541,  494, 1746,
 /*   210 */  1877,  495,   83, 1487, 1488,   82, 1538, 1541, 1542, 1543,
 /*   220 */  1544, 1545, 1546, 1547, 1548,  659,  655, 1557, 1558, 1560,
 /*   230 */  1561, 1562, 1563,    2, 1566, 1567,  731,  730,  729,  728,
 /*   240 */   397,   48,  727,  726,  143,  721,  720,  719,  718,  717,
 /*   250 */   716,  715,  156,  711,  710,  709,  396,  395,  706,  705,
 /*   260 */   704,  703,  702,  605, 1539, 1549,  600, 1673,  701,  699,
 /*   270 */  1565, 1568,  122, 1595, 1254,  121,  120,  119,  118,  117,
 /*   280 */   116,  115,  114,  113, 1484,  699, 1482,  154,  153,  696,
 /*   290 */   695,  694,  151,   38,   37, 1507, 1162,   44,   42,   41,
 /*   300 */    40,   39, 1975,  154,  153,  696,  695,  694,  151, 1708,
 /*   310 */  1256, 1487, 1488,  190, 1538, 1541, 1542, 1543, 1544, 1545,
 /*   320 */  1546, 1547, 1548,  659,  655, 1557, 1558, 1560, 1561, 1562,
 /*   330 */  1563,    2,   11,   45,   43, 1164, 1855, 1167, 1168, 1508,
 /*   340 */   379,  387, 1311, 1483,  185,   32,  633,  185,  164,  345,
 /*   350 */   606,  601,  594,  573, 1564, 1600, 1481, 1879, 1302,  689,
 /*   360 */   688,  687, 1306,  686, 1308, 1309,  685,  682,   86, 1317,
 /*   370 */   679, 1319, 1320,  676,  673, 1711,   31,  400, 2099, 1559,
 /*   380 */   147,  399,   38,   37,  354,   18,   44,   42,   41,   40,
 /*   390 */    39,  185, 1489, 1872, 1593,  631,  122, 1989,   11,  121,
 /*   400 */   120,  119,  118,  117,  116,  115,  114,  113,   38,   37,
 /*   410 */   633, 2117,   44,   42,   41,   40,   39,  390,  754,  661,
 /*   420 */  1511,   14,  470,  585, 2067,  164,  663, 2258,   11,  390,
 /*   430 */     9,   45,   43, 1569, 1879,  282,  283,  161, 1975,  387,
 /*   440 */   281, 1483, 2264,  182,  366, 1509, 1879, 2259,  611,  192,
 /*   450 */  1594,  238, 1564, 1928, 1481,  237, 2098, 1566, 1567,  642,
 /*   460 */  2134, 1989, 1489,  327, 2100,  667, 2102, 2103,  662,  660,
 /*   470 */   657,  648, 2152, 1710,   38,   37,  692, 1559,   44,   42,
 /*   480 */    41,   40,   39,  198,  197, 1400, 1401, 1539, 1549, 1508,
 /*   490 */  1489, 1779,  492, 1565, 1568,  497, 1752,  131,  130,  129,
 /*   500 */   128,  127,  126,  125,  124,  123,  469, 1484,  501, 1482,
 /*   510 */    27,  497, 1752,  713,   89,  340,  754,  426,  364,   46,
 /*   520 */   566,  425,   34,  385, 1588, 1589, 1590, 1591, 1592, 1596,
 /*   530 */  1597, 1598, 1599, 1733, 1487, 1488, 1960, 1538, 1541, 1542,
 /*   540 */  1543, 1544, 1545, 1546, 1547, 1548,  659,  655, 1557, 1558,
 /*   550 */  1560, 1561, 1562, 1563,    2, 1566, 1567,  550,  549,  548,
 /*   560 */  1975, 1345, 1346,  585,  540,  136,  544, 2258,  250,   61,
 /*   570 */   543,  196,  176, 1732,  106,  542,  547,  360,  359, 2067,
 /*   580 */  2099,  541, 2264,  182, 1731, 1539, 1549, 2259,  611,   33,
 /*   590 */   140, 1565, 1568,  352, 1979,   38,   37, 1852, 1869,   44,
 /*   600 */    42,   41,   40,   39,   61, 1484, 2263, 1482,   13,   12,
 /*   610 */    38,   37,  393, 2117,   44,   42,   41,   40,   39, 2067,
 /*   620 */   164,  664,  622, 1510,  546,  545, 2067,  239,  663, 1879,
 /*   630 */  2067, 1866, 1487, 1488,   86, 1538, 1541, 1542, 1543, 1544,
 /*   640 */  1545, 1546, 1547, 1548,  659,  655, 1557, 1558, 1560, 1561,
 /*   650 */  1562, 1563,    2,   45,   43,  139,   49, 2099, 2098, 1873,
 /*   660 */  1868,  387, 2134, 1483,  647,  109, 2100,  667, 2102, 2103,
 /*   670 */   662, 2081,  657, 1509, 1564,  142, 1481,  149, 2158, 2187,
 /*   680 */   187,   38,   37,  381, 2183,   44,   42,   41,   40,   39,
 /*   690 */  2117,  450,  176, 1457, 1458, 1930, 1766, 1877,  664, 1559,
 /*   700 */   449,  622,  365, 2067, 1696,  663, 2077, 2083, 1607,  699,
 /*   710 */   628, 1928, 1489,  419, 1980, 1662,  357,  657,  551,  185,
 /*   720 */   624,  180, 2195, 2196,  647,  137, 2200,  154,  153,  696,
 /*   730 */   695,  694,  151, 1730,  139, 2098,  421,  417,  754, 2134,
 /*   740 */    54,   46,  169, 2100,  667, 2102, 2103,  662,  714,  657,
 /*   750 */  1839,   45,   43,  647,  185,  693,  585, 1877, 1921,  387,
 /*   760 */  2258, 1483,  597,  596, 1660, 1661, 1663, 1664, 1665,  430,
 /*   770 */   163,  272, 1564, 2262, 1481, 2264,  182, 1566, 1567, 2067,
 /*   780 */  2259,  611,  358, 1510,  356,  355, 1877,  534, 1729, 1417,
 /*   790 */  1418,  536, 1638,  614,  612, 2279,  564, 1559, 1508, 2099,
 /*   800 */   181, 2195, 2196, 1728,  137, 2200,  185, 1539, 1549,  562,
 /*   810 */  1489,  560,  535, 1565, 1568,  647,   38,   37,  105,  647,
 /*   820 */    44,   42,   41,   40,   39, 1416, 1419, 1484,  102, 1482,
 /*   830 */  1930,  431, 2117, 1727, 2067,  440,  754,  375, 1574,   14,
 /*   840 */   664,   41,   40,   39, 1508, 2067, 1928,  663, 1877, 2067,
 /*   850 */  2060, 1703, 1877, 1726, 1487, 1488, 1725, 1538, 1541, 1542,
 /*   860 */  1543, 1544, 1545, 1546, 1547, 1548,  659,  655, 1557, 1558,
 /*   870 */  1560, 1561, 1562, 1563,    2, 1566, 1567, 2098,    8, 2067,
 /*   880 */  2061, 2134, 1924, 1925,  110, 2100,  667, 2102, 2103,  662,
 /*   890 */  2086,  657,  649,  100, 2159, 1862,  585, 1724, 2187, 2067,
 /*   900 */  2258, 2081, 2067, 2184,  610, 1539, 1549, 1864, 2258, 1650,
 /*   910 */   164, 1565, 1568,  725,  723, 2264,  182, 1870,   61, 1880,
 /*   920 */  2259,  611, 1511,  609,  182, 1484,  585, 1482, 2259,  611,
 /*   930 */  2258,  272,  538, 1930,   38,   37, 2077, 2083,   44,   42,
 /*   940 */    41,   40,   39, 2067, 1540, 2264,  182,  657, 1702, 1929,
 /*   950 */  2259,  611, 1487, 1488, 1252, 1538, 1541, 1542, 1543, 1544,
 /*   960 */  1545, 1546, 1547, 1548,  659,  655, 1557, 1558, 1560, 1561,
 /*   970 */  1562, 1563,    2, 1511,  336,  165, 1506,  647,  384,  383,
 /*   980 */   311,  571, 2202,  463, 2053,  555,  477, 2099, 1497,  476,
 /*   990 */  1540, 1167, 1168,  455,  309,   72, 2202, 1721,   71, 1564,
 /*  1000 */   565, 1490, 1631,  424,  446,  423,  478, 1720, 2198,  448,
 /*  1010 */  1877,  651, 1483, 2159,  236,  536,  205,  489,  487,  484,
 /*  1020 */  2117,  615, 2197,  622, 1559, 1481,  647,  585,  664,  558,
 /*  1030 */   422, 2258,  407, 2067,  552,  663,  535, 1489,  647,  235,
 /*  1040 */   613,  697,  456, 2067, 1921,  580, 2264,  182,  647, 2207,
 /*  1050 */  1627, 2259,  611, 2067,  510,  353,  139,   61,   51, 1877,
 /*  1060 */     3, 1489, 1723,  653, 1874, 2098,  617,  436,  185, 2134,
 /*  1070 */   191, 1877,  109, 2100,  667, 2102, 2103,  662, 1930,  657,
 /*  1080 */    69, 1877, 1930,   68, 2162,  380, 2187,  754, 1627,  391,
 /*  1090 */   381, 2183, 1860, 1719, 1928,  108,  474, 1718, 1928,  468,
 /*  1100 */   467,  466,  465,  462,  461,  460,  459,  458,  454,  453,
 /*  1110 */   452,  451,  335,  443,  442,  441,  647,  438,  437,  351,
 /*  1120 */   152,  249,  183, 2195, 2196, 1265,  137, 2200,  647, 2227,
 /*  1130 */   698,  647,  241, 1921,  691,   80,   79,  429, 1264, 2067,
 /*  1140 */   189, 2099,  647, 2067,  581, 1717, 1269,  626,  305, 1877,
 /*  1150 */   245, 1907, 1498,  658, 1493,  647, 1508,  647,  630, 1268,
 /*  1160 */   334, 1877,   73,  415, 1877,  413,  409,  405,  402,  422,
 /*  1170 */  1716,  286, 2099,  644, 2117, 1877, 1484,   53, 1482, 1501,
 /*  1180 */  1503,  145,  625,  134,  568,  152,  567, 2067, 1877,  663,
 /*  1190 */  1877, 2067,  655, 1557, 1558, 1560, 1561, 1562, 1563,  647,
 /*  1200 */   479,  647, 1715, 1487, 1488, 2117, 1714,  185,  647,  228,
 /*  1210 */  1713,   81,  226,  664,  539,  645, 2067,  292, 2067, 2098,
 /*  1220 */   663,  481, 2099, 2134,  394, 1759,  109, 2100,  667, 2102,
 /*  1230 */  2103,  662, 1877,  657, 1877,  152, 1250,   63,  179, 2099,
 /*  1240 */  2187, 1877, 1452,  654,  381, 2183,   63,  553, 2067, 1630,
 /*  1250 */  2098, 1757, 2067,  248, 2134, 2117, 2067,  109, 2100,  667,
 /*  1260 */  2102, 2103,  662,  664,  657,  254, 2214,  584, 2067, 2278,
 /*  1270 */   663, 2187, 2117,  556, 1492,  381, 2183,  433,  230,  232,
 /*  1280 */   664,  229,  231, 1705, 1706, 2067, 2221,  663,  234,  152,
 /*  1290 */   434,  233, 1455,   47, 1659, 2088,  618,   90,  279, 2099,
 /*  1300 */  2098,   70, 1540, 1658, 2134,  150,  152,  168, 2100,  667,
 /*  1310 */  2102, 2103,  662,   63,  657, 1491, 1819, 2098, 1211, 2099,
 /*  1320 */   267, 2134,  256,   47,  109, 2100,  667, 2102, 2103,  662,
 /*  1330 */   221,  657, 2117,   13,   12,  598, 2278,  757, 2187,   52,
 /*  1340 */   664,  261,  381, 2183, 1753, 2067,  629,  663, 2090, 2225,
 /*  1350 */  1414,  298, 2117, 2234, 1212,  284,  707,   47,  639, 2118,
 /*  1360 */   664,  708,  288, 1295,  671, 2067,  175,  663,  150,  152,
 /*  1370 */  1601,  398,  747,  743,  739,  735,  296, 2098, 1230,  135,
 /*  1380 */  1550, 2134,  150, 1228,  109, 2100,  667, 2102, 2103,  662,
 /*  1390 */  1984,  657, 1585,  749, 1747, 1918, 2278, 2098, 2187, 2217,
 /*  1400 */   623, 2134,  381, 2183,  109, 2100,  667, 2102, 2103,  662,
 /*  1410 */   266,  657,  269,  592,  304,    4, 2278,  107, 2187,    1,
 /*  1420 */   289, 1323,  381, 2183,  401, 1327, 1334, 1495, 2099,  406,
 /*  1430 */   349, 1437,  299, 2252,  195,  223, 1332,  435, 1511,  155,
 /*  1440 */   472, 1985,  439,  444,  457, 1506, 1977,  464, 2099,  471,
 /*  1450 */   171,  473,  643,  482,  480,  200,  528,  524,  520,  516,
 /*  1460 */   220, 2117,  483,  199,  485,  486,  202,  488, 1494,  664,
 /*  1470 */   490, 1512,  491, 1514, 2067,  503,  663,  500,  208, 1509,
 /*  1480 */   504, 2117, 1513,  210, 1515,  505,  506,  276,  213,  664,
 /*  1490 */   508,  215,  275,  512, 2067, 1184,  663,   84,   85,  529,
 /*  1500 */   219,   87,  530,  531,  218,  533, 2098,  111, 1444, 2044,
 /*  1510 */  2134,  243, 2041,  109, 2100,  667, 2102, 2103,  662,  570,
 /*  1520 */   657,  339, 2099, 1867, 2040, 2278, 2098, 2187,  572,  225,
 /*  1530 */  2134,  381, 2183,  109, 2100,  667, 2102, 2103,  662,   88,
 /*  1540 */   657, 1863, 2206,  227,  242, 2160, 2099, 2187,  157,  575,
 /*  1550 */   158,  381, 2183, 1865, 1861, 2117,  574,  159,  582,  160,
 /*  1560 */   579,  576,  148,  664,  244,  300,  246,  599, 2067, 2218,
 /*  1570 */   663,  217,  211, 2233, 2228,  589,  216,  637,  507, 2117,
 /*  1580 */   608,  595, 2232,  370,  602,  590,  172,  664,    7,  252,
 /*  1590 */   260,  255, 2067,  587,  663,  209, 2099,  588,  371,  263,
 /*  1600 */  2098,  619,  616, 1627, 2134,  138, 2209,  109, 2100,  667,
 /*  1610 */  2102, 2103,  662, 2099,  657, 1510,  264,  262,  627,  650,
 /*  1620 */   265, 2187, 1516, 2203, 2098,  381, 2183,  268, 2134, 2117,
 /*  1630 */   374,  110, 2100,  667, 2102, 2103,  662,  664,  657, 2257,
 /*  1640 */  2281,  274, 2067,   95,  663, 2187, 2117, 1990,  635, 2186,
 /*  1650 */  2183,  301,  636,  302,  664, 2004,  640,  641,   97, 2067,
 /*  1660 */  2003,  663, 2002,  377,  303, 1878,   60,   99, 2168,  101,
 /*  1670 */   669, 1922,  750, 2099, 2098,  308,  306,  295, 2134,  330,
 /*  1680 */   751,  321, 2100,  667, 2102, 2103,  662,  753,  657, 1840,
 /*  1690 */    50, 2098,  341, 2099,  342, 2134,  315,  310,  110, 2100,
 /*  1700 */   667, 2102, 2103,  662, 2059,  657, 2117, 2058,  329,  319,
 /*  1710 */  2057,   77, 2187, 2054,  664,  403,  652, 2183,  404, 2067,
 /*  1720 */  1474,  663, 1475,  188,  408,  607, 2117, 2052,  410,  411,
 /*  1730 */   412, 2051,  414, 2050,  664,  416, 2049,  418, 2048, 2067,
 /*  1740 */   420,  663,   78, 1440, 1439, 2016, 2015, 2014, 2013,  427,
 /*  1750 */  2012,  665,  428, 1391, 1968, 2134, 2099, 1967,  110, 2100,
 /*  1760 */   667, 2102, 2103,  662, 1965,  657,  144, 1964, 1963, 1966,
 /*  1770 */  1962, 2098, 2187, 1961, 1959, 2134,  344, 2183,  169, 2100,
 /*  1780 */   667, 2102, 2103,  662,  193,  657, 1958, 1957,  445, 2117,
 /*  1790 */  1956, 1970,  447, 1955,  376, 1954, 1953,  664, 1952, 1951,
 /*  1800 */  1950, 1949, 2067, 1948,  663, 1947, 1946, 1945, 1944, 1943,
 /*  1810 */  1942, 1941, 1940,  146, 2099, 1939, 1938, 1969, 1937, 1936,
 /*  1820 */  1935, 1934, 1933,  475, 1393, 1932, 1931, 1782,  337, 1262,
 /*  1830 */   338, 2280, 1781,  201, 2098, 1266, 1270,  203, 2134, 2099,
 /*  1840 */  1780,  328, 2100,  667, 2102, 2103,  662, 2117,  657, 1778,
 /*  1850 */   204, 1742, 1170, 1169, 1741,  661, 2031, 2023, 2011,  214,
 /*  1860 */  2067,   62,  663,   75, 2010,  206, 1988, 1856, 1777, 1204,
 /*  1870 */   207, 1775, 2117,  177,   76, 2087,  212,  386,  496,  513,
 /*  1880 */   664,  498,  515, 1773,  514, 2067,  519,  663,  517,  518,
 /*  1890 */  1771,  523, 2098,  522,  521, 1769, 2134, 1756,  525,  327,
 /*  1900 */  2100,  667, 2102, 2103,  662, 1755,  657, 1738, 2153,  527,
 /*  1910 */  1858, 1339, 2099,  526, 1338, 1857, 1253, 2098,  722, 1251,
 /*  1920 */  1249, 2134, 1248, 1247,  328, 2100,  667, 2102, 2103,  662,
 /*  1930 */   724,  657, 1767, 2099, 1246, 1245, 1242, 1241, 1240, 1239,
 /*  1940 */   224,  361, 1760,  362,  554, 2117, 1758,  363,  557, 1737,
 /*  1950 */   388, 1736,  559,  664, 1735,  561,  563,  112, 2067, 1462,
 /*  1960 */   663, 1464, 2099, 1461, 2030,   55, 2117, 1448, 1446, 2022,
 /*  1970 */  1466,  162,   26,   66,  664,  577, 2009, 2007, 2263, 2067,
 /*  1980 */    19,  663,   16, 2099,   58,   59,  259,  258,   30,   28,
 /*  1990 */  2098,  593, 1675,  251, 2134, 2117,  591,  328, 2100,  667,
 /*  2000 */  2102, 2103,  662,  664,  657,    5,  170,    6, 2067,  253,
 /*  2010 */   663,  569, 2088, 1657,  578, 2134, 2117,   20,  323, 2100,
 /*  2020 */   667, 2102, 2103,  662,  664,  657,   64,  257,   21, 2067,
 /*  2030 */   247,  663, 1649, 2099,   17,   29, 1690,  583,   91, 1689,
 /*  2040 */  2098,  372, 1694,  367, 2134, 1693,  373,  312, 2100,  667,
 /*  2050 */  2102, 2103,  662, 1695,  657,  271, 1696, 1624, 2099, 1623,
 /*  2060 */    57, 2098,  173, 2008, 2006, 2134, 2117, 2005,  313, 2100,
 /*  2070 */   667, 2102, 2103,  662,  664,  657, 1987,   94,   93, 2067,
 /*  2080 */   277,  663,   22, 1986,  278,  638, 1655,  280,  285,   67,
 /*  2090 */    96, 2117,  287, 2099,   98,  290,   56,   23, 1576,  664,
 /*  2100 */   102, 1575,   12, 1499, 2067, 2137,  663,  174,  186, 1531,
 /*  2110 */  1554, 2098,   10,  656,   36, 2134, 2099,   15,  314, 2100,
 /*  2120 */   667, 2102, 2103,  662,   24,  657, 2117, 1552, 1551, 1523,
 /*  2130 */    25, 1586,  668, 1324,  664,  672, 2098,  670,  389, 2067,
 /*  2140 */  2134,  663, 1321,  320, 2100,  667, 2102, 2103,  662, 2117,
 /*  2150 */   657,  674,  675,  677,  680, 1318,  678,  664, 1312, 1310,
 /*  2160 */   683, 1301, 2067,  666,  663,  681,  684, 1316, 1315, 1314,
 /*  2170 */  1313, 2098,  293,  103, 2099, 2134, 1333,  104,  324, 2100,
 /*  2180 */   667, 2102, 2103,  662,  690,  657,   74, 1329, 1202, 1236,
 /*  2190 */   700, 1235, 1234, 2099, 2098, 1233, 1232, 1231, 2134, 1229,
 /*  2200 */  1260,  316, 2100,  667, 2102, 2103,  662, 2117,  657, 1227,
 /*  2210 */   712, 1226, 1225,  294, 1223,  664, 1222, 1221, 1220, 1219,
 /*  2220 */  2067, 1218,  663, 1217, 1257, 1255, 2117, 1214, 1213, 1210,
 /*  2230 */  1209, 1208, 1207, 1774,  664,  732, 1772,  733,  734, 2067,
 /*  2240 */   736,  663,  738, 1770, 1768,  740,  737,  742,  744,  741,
 /*  2250 */   745,  746, 2098, 1754, 2099,  748, 2134, 1159, 1734,  325,
 /*  2260 */  2100,  667, 2102, 2103,  662, 1709,  657,  297,  752,  756,
 /*  2270 */  1485, 2098,  307,  755, 1709, 2134, 1709, 1709,  317, 2100,
 /*  2280 */   667, 2102, 2103,  662, 1709,  657, 1709, 2117, 1709, 1709,
 /*  2290 */  1709, 1709, 1709, 1709, 1709,  664, 1709, 1709, 1709, 1709,
 /*  2300 */  2067, 1709,  663, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*  2310 */  1709, 1709, 2099, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*  2320 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 2099, 1709,
 /*  2330 */  1709, 1709, 2098, 1709, 1709, 1709, 2134, 1709, 1709,  326,
 /*  2340 */  2100,  667, 2102, 2103,  662, 2117,  657, 1709, 1709, 1709,
 /*  2350 */  1709, 1709, 1709,  664, 1709, 1709, 1709, 1709, 2067, 1709,
 /*  2360 */   663, 2117, 1709, 1709, 1709, 1709, 1709, 1709, 1709,  664,
 /*  2370 */  1709, 1709, 1709, 1709, 2067, 1709,  663, 1709, 1709, 1709,
 /*  2380 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*  2390 */  2098, 2099, 1709, 1709, 2134, 1709, 1709,  318, 2100,  667,
 /*  2400 */  2102, 2103,  662, 1709,  657, 1709, 2098, 2099, 1709, 1709,
 /*  2410 */  2134, 1709, 1709,  331, 2100,  667, 2102, 2103,  662, 1709,
 /*  2420 */   657, 1709, 1709, 1709, 2117, 1709, 2099, 1709, 1709, 1709,
 /*  2430 */  1709, 1709,  664, 1709, 1709, 1709, 1709, 2067, 1709,  663,
 /*  2440 */  2117, 1709, 1709, 1709, 1709, 1709, 1709, 1709,  664, 1709,
 /*  2450 */  1709, 1709, 1709, 2067, 1709,  663, 1709, 1709, 1709, 2117,
 /*  2460 */  1709, 1709, 1709, 1709, 1709, 1709, 1709,  664, 1709, 2098,
 /*  2470 */  1709, 1709, 2067, 2134,  663, 1709,  332, 2100,  667, 2102,
 /*  2480 */  2103,  662, 1709,  657, 1709, 2098, 1709, 1709, 1709, 2134,
 /*  2490 */  2099, 1709, 2111, 2100,  667, 2102, 2103,  662, 1709,  657,
 /*  2500 */  1709, 1709, 1709, 1709, 2098, 1709, 1709, 2099, 2134, 1709,
 /*  2510 */  1709, 2110, 2100,  667, 2102, 2103,  662, 1709,  657, 1709,
 /*  2520 */  1709, 1709, 1709, 2117, 1709, 1709, 1709, 1709, 1709, 1709,
 /*  2530 */  1709,  664, 1709, 1709, 1709, 1709, 2067, 1709,  663, 1709,
 /*  2540 */  2117, 1709, 1709, 1709, 1709, 1709, 1709, 1709,  664, 1709,
 /*  2550 */  1709, 1709, 1709, 2067, 1709,  663, 1709, 1709, 1709, 1709,
 /*  2560 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 2099, 2098, 1709,
 /*  2570 */  1709, 1709, 2134, 1709, 1709, 2109, 2100,  667, 2102, 2103,
 /*  2580 */   662, 1709,  657, 1709, 1709, 2098, 1709, 2099, 1709, 2134,
 /*  2590 */  1709, 1709,  346, 2100,  667, 2102, 2103,  662, 1709,  657,
 /*  2600 */  2117, 1709, 1709, 1709, 1709, 1709, 1709, 1709,  664, 1709,
 /*  2610 */  1709, 1709, 1709, 2067, 1709,  663, 1709, 1709, 1709, 1709,
 /*  2620 */  2117, 1709, 1709, 1709, 1709, 1709, 1709, 1709,  664, 1709,
 /*  2630 */  1709, 1709, 1709, 2067, 1709,  663, 1709, 1709, 1709, 1709,
 /*  2640 */  1709, 1709, 1709, 1709, 1709, 2098, 1709, 1709, 1709, 2134,
 /*  2650 */  1709, 1709,  347, 2100,  667, 2102, 2103,  662, 1709,  657,
 /*  2660 */  1709, 2099, 1709, 1709, 1709, 2098, 1709, 1709, 1709, 2134,
 /*  2670 */  1709, 1709,  343, 2100,  667, 2102, 2103,  662, 2099,  657,
 /*  2680 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*  2690 */  1709, 1709, 1709, 1709, 2117, 1709, 1709, 1709, 1709, 1709,
 /*  2700 */  1709, 1709,  664, 1709, 1709, 1709, 1709, 2067, 1709,  663,
 /*  2710 */  1709, 2117, 1709, 1709, 1709, 1709, 1709, 1709, 1709,  664,
 /*  2720 */  1709, 1709, 1709, 1709, 2067, 1709,  663, 1709, 1709, 1709,
 /*  2730 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 2098,
 /*  2740 */  2099, 1709, 1709, 2134, 1709, 1709,  348, 2100,  667, 2102,
 /*  2750 */  2103,  662, 1709,  657, 1709, 1709,  665, 1709, 1709, 1709,
 /*  2760 */  2134, 1709, 1709,  323, 2100,  667, 2102, 2103,  662, 1709,
 /*  2770 */   657, 1709, 1709, 2117, 1709, 1709, 1709, 1709, 1709, 1709,
 /*  2780 */  1709,  664, 1709, 1709, 1709, 1709, 2067, 1709,  663, 1709,
 /*  2790 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*  2800 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
 /*  2810 */  1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709, 2098, 1709,
 /*  2820 */  1709, 1709, 2134, 1709, 1709,  322, 2100,  667, 2102, 2103,
 /*  2830 */   662, 1709,  657,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   367,  443,  380,  347,  332,  447,  336,  365,  338,  339,
 /*    10 */   354,  378,   12,   13,   14,  373,  380,  395,  396,  367,
 /*    20 */    20,  463,   22,  340,   20,  467,  468,  332,  392,  416,
 /*    30 */   378,  395,  396,   33,  361,   35,    0,  365,   12,   13,
 /*    40 */    14,   15,   16,  340,   20,  373,  413,  414,  415,   20,
 /*    50 */   378,   22,  380,  340,  340,  442,  373,  424,   58,  443,
 /*    60 */   365,  419,  365,  447,   64,  413,  414,  415,  373,  372,
 /*    70 */   356,   71,  331,  378,  333,  380,  424,  363,  381,  463,
 /*    80 */    51,  408,  410,  467,  468,  382,  414,  373,   20,  417,
 /*    90 */   418,  419,  420,  421,  422,  367,  424,   97,    4,   63,
 /*   100 */   100,  429,  389,  431,  391,  410,  378,  435,  436,  414,
 /*   110 */    12,   13,  417,  418,  419,  420,  421,  422,   20,  424,
 /*   120 */    22,  449,  439,  440,  441,  427,  443,  444,  430,  457,
 /*   130 */   447,   33,   20,   35,   22,  376,  136,  137,  379,  380,
 /*   140 */   443,  413,  414,  415,  447,  462,  463,   35,  432,  433,
 /*   150 */   467,  468,  424,  458,  459,   58,   58,    0,   20,  462,
 /*   160 */   463,   20,   64,   51,  467,  468,  166,  167,  100,   71,
 /*   170 */     0,   58,  172,  173,    8,    9,  364,  340,   12,   13,
 /*   180 */    14,   15,   16,   66,   67,   68,  186,   63,  188,  377,
 /*   190 */    73,   74,   75,  356,  100,   97,   79,  100,  100,  102,
 /*   200 */   363,   84,   85,   86,   87,   14,  336,   90,  338,  339,
 /*   210 */   373,   20,   99,  213,  214,  102,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,  233,  136,  137,   66,   67,   68,   69,
 /*   240 */    70,  100,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   250 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   260 */    90,   91,   92,   20,  166,  167,  171,  101,   63,  112,
 /*   270 */   172,  173,   21,  165,   35,   24,   25,   26,   27,   28,
 /*   280 */    29,   30,   31,   32,  186,  112,  188,  130,  131,  132,
 /*   290 */   133,  134,  135,    8,    9,   20,    4,   12,   13,   14,
 /*   300 */    15,   16,  373,  130,  131,  132,  133,  134,  135,  329,
 /*   310 */    71,  213,  214,  384,  216,  217,  218,  219,  220,  221,
 /*   320 */   222,  223,  224,  225,  226,  227,  228,  229,  230,  231,
 /*   330 */   232,  233,  234,   12,   13,   43,    0,   45,   46,   20,
 /*   340 */   357,   20,   97,   22,  250,  237,  340,  250,  365,   64,
 /*   350 */   255,  256,  257,  111,   33,  247,   35,  374,  113,  114,
 /*   360 */   115,  116,  117,  118,  119,  120,  121,  122,  346,  124,
 /*   370 */   125,  126,  127,  128,  129,    0,    2,  397,  332,   58,
 /*   380 */    44,  401,    8,    9,  362,   64,   12,   13,   14,   15,
 /*   390 */    16,  250,   71,  371,  109,  389,   21,  391,  234,   24,
 /*   400 */    25,   26,   27,   28,   29,   30,   31,   32,    8,    9,
 /*   410 */   340,  365,   12,   13,   14,   15,   16,  357,   97,  373,
 /*   420 */    20,  100,   80,  443,  378,  365,  380,  447,  234,  357,
 /*   430 */   236,   12,   13,   14,  374,  130,  131,  365,  373,   20,
 /*   440 */   135,   22,  462,  463,  372,   20,  374,  467,  468,  384,
 /*   450 */   165,  131,   33,  381,   35,  135,  410,  136,  137,  389,
 /*   460 */   414,  391,   71,  417,  418,  419,  420,  421,  422,  423,
 /*   470 */   424,  425,  426,    0,    8,    9,  111,   58,   12,   13,
 /*   480 */    14,   15,   16,  141,  142,  166,  167,  166,  167,   20,
 /*   490 */    71,    0,  337,  172,  173,  340,  341,   24,   25,   26,
 /*   500 */    27,   28,   29,   30,   31,   32,  164,  186,  337,  188,
 /*   510 */    44,  340,  341,   71,  194,  195,   97,  397,  198,  100,
 /*   520 */   200,  401,  237,  238,  239,  240,  241,  242,  243,  244,
 /*   530 */   245,  246,  247,  332,  213,  214,    0,  216,  217,  218,
 /*   540 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*   550 */   229,  230,  231,  232,  233,  136,  137,   66,   67,   68,
 /*   560 */   373,  136,  137,  443,   73,   74,   75,  447,  168,  100,
 /*   570 */    79,  384,  365,  332,  344,   84,   85,   86,   87,  378,
 /*   580 */   332,   90,  462,  463,  332,  166,  167,  467,  468,    2,
 /*   590 */   360,  172,  173,  386,  387,    8,    9,    0,  368,   12,
 /*   600 */    13,   14,   15,   16,  100,  186,    3,  188,    1,    2,
 /*   610 */     8,    9,  357,  365,   12,   13,   14,   15,   16,  378,
 /*   620 */   365,  373,  340,   20,  351,  352,  378,  130,  380,  374,
 /*   630 */   378,  366,  213,  214,  346,  216,  217,  218,  219,  220,
 /*   640 */   221,  222,  223,  224,  225,  226,  227,  228,  229,  230,
 /*   650 */   231,  232,  233,   12,   13,  373,  100,  332,  410,  371,
 /*   660 */   367,   20,  414,   22,  340,  417,  418,  419,  420,  421,
 /*   670 */   422,  378,  424,   20,   33,  427,   35,  429,  430,  431,
 /*   680 */   356,    8,    9,  435,  436,   12,   13,   14,   15,   16,
 /*   690 */   365,  155,  365,  196,  197,  365,    0,  373,  373,   58,
 /*   700 */   164,  340,  372,  378,  101,  380,  413,  414,  101,  112,
 /*   710 */   397,  381,   71,  181,  387,  213,   37,  424,   22,  250,
 /*   720 */   438,  439,  440,  441,  340,  443,  444,  130,  131,  132,
 /*   730 */   133,  134,  135,  332,  373,  410,  204,  205,   97,  414,
 /*   740 */   356,  100,  417,  418,  419,  420,  421,  422,  353,  424,
 /*   750 */   355,   12,   13,  340,  250,  375,  443,  373,  378,   20,
 /*   760 */   447,   22,  260,  261,  262,  263,  264,  265,  266,  356,
 /*   770 */   168,  168,   33,    3,   35,  462,  463,  136,  137,  378,
 /*   780 */   467,  468,  103,   20,  105,  106,  373,  108,  332,  136,
 /*   790 */   137,  112,   14,   44,  469,  470,   21,   58,   20,  332,
 /*   800 */   439,  440,  441,  332,  443,  444,  250,  166,  167,   34,
 /*   810 */    71,   36,  133,  172,  173,  340,    8,    9,  100,  340,
 /*   820 */    12,   13,   14,   15,   16,  172,  173,  186,  110,  188,
 /*   830 */   365,  356,  365,  332,  378,  356,   97,  372,   14,  100,
 /*   840 */   373,   14,   15,   16,   20,  378,  381,  380,  373,  378,
 /*   850 */   397,  178,  373,  332,  213,  214,  332,  216,  217,  218,
 /*   860 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*   870 */   229,  230,  231,  232,  233,  136,  137,  410,   39,  378,
 /*   880 */   397,  414,  379,  380,  417,  418,  419,  420,  421,  422,
 /*   890 */   367,  424,  428,  344,  430,  366,  443,  332,  431,  378,
 /*   900 */   447,  378,  378,  436,  443,  166,  167,  366,  447,  101,
 /*   910 */   365,  172,  173,  351,  352,  462,  463,  368,  100,  374,
 /*   920 */   467,  468,   20,  462,  463,  186,  443,  188,  467,  468,
 /*   930 */   447,  168,   13,  365,    8,    9,  413,  414,   12,   13,
 /*   940 */    14,   15,   16,  378,  166,  462,  463,  424,  275,  381,
 /*   950 */   467,  468,  213,  214,   35,  216,  217,  218,  219,  220,
 /*   960 */   221,  222,  223,  224,  225,  226,  227,  228,  229,  230,
 /*   970 */   231,  232,  233,   20,   18,   18,   20,  340,   12,   13,
 /*   980 */    23,  397,  416,   27,    0,    4,   30,  332,   22,   33,
 /*   990 */   166,   45,   46,  356,   37,   38,  416,  332,   41,   33,
 /*  1000 */    19,   35,    4,  185,   48,  187,   50,  332,  442,   53,
 /*  1010 */   373,  428,   22,  430,   33,  112,   59,   60,   61,   62,
 /*  1020 */   365,  272,  442,  340,   58,   35,  340,  443,  373,   48,
 /*  1030 */   212,  447,   48,  378,   53,  380,  133,   71,  340,   58,
 /*  1040 */   270,  375,  356,  378,  378,  402,  462,  463,  340,  248,
 /*  1050 */   249,  467,  468,  378,  356,   99,  373,  100,   42,  373,
 /*  1060 */    44,   71,  333,   97,  356,  410,   44,  111,  250,  414,
 /*  1070 */   168,  373,  417,  418,  419,  420,  421,  422,  365,  424,
 /*  1080 */    99,  373,  365,  102,  429,  372,  431,   97,  249,  372,
 /*  1090 */   435,  436,  366,  332,  381,  138,  140,  332,  381,  143,
 /*  1100 */   144,  145,  146,  147,  148,  149,  150,  151,  152,  153,
 /*  1110 */   154,  155,  156,  157,  158,  159,  340,  161,  162,  163,
 /*  1120 */    44,  168,  439,  440,  441,   22,  443,  444,  340,  388,
 /*  1130 */   375,  340,  356,  378,  366,  178,  179,  180,   35,  378,
 /*  1140 */   183,  332,  340,  378,  356,  332,   22,  356,  358,  373,
 /*  1150 */   366,  361,  186,  366,  188,  340,   20,  340,  356,   35,
 /*  1160 */   203,  373,  111,  206,  373,  208,  209,  210,  211,  212,
 /*  1170 */   332,  356,  332,  356,  365,  373,  186,  101,  188,  213,
 /*  1180 */   214,   42,  373,   44,  199,   44,  201,  378,  373,  380,
 /*  1190 */   373,  378,  226,  227,  228,  229,  230,  231,  232,  340,
 /*  1200 */    97,  340,  332,  213,  214,  365,  332,  250,  340,  104,
 /*  1210 */   332,  160,  107,  373,   13,  356,  378,  356,  378,  410,
 /*  1220 */   380,   97,  332,  414,  356,    0,  417,  418,  419,  420,
 /*  1230 */   421,  422,  373,  424,  373,   44,   35,   44,  429,  332,
 /*  1240 */   431,  373,  101,   64,  435,  436,   44,   22,  378,  251,
 /*  1250 */   410,    0,  378,   58,  414,  365,  378,  417,  418,  419,
 /*  1260 */   420,  421,  422,  373,  424,   44,  457,   96,  378,  429,
 /*  1270 */   380,  431,  365,   22,   35,  435,  436,   22,  104,  104,
 /*  1280 */   373,  107,  107,  136,  137,  378,  446,  380,  104,   44,
 /*  1290 */    35,  107,  101,   44,  101,   47,  274,  102,   44,  332,
 /*  1300 */   410,   44,  166,  101,  414,   44,   44,  417,  418,  419,
 /*  1310 */   420,  421,  422,   44,  424,   35,  354,  410,   35,  332,
 /*  1320 */   471,  414,  101,   44,  417,  418,  419,  420,  421,  422,
 /*  1330 */   342,  424,  365,    1,    2,  460,  429,   19,  431,  168,
 /*  1340 */   373,  454,  435,  436,    0,  378,  101,  380,  100,  459,
 /*  1350 */   101,   33,  365,  446,   71,  101,   13,   44,  101,  365,
 /*  1360 */   373,   13,  101,  101,   44,  378,   48,  380,   44,   44,
 /*  1370 */   101,  342,   54,   55,   56,   57,   58,  410,   35,   44,
 /*  1380 */   101,  414,   44,   35,  417,  418,  419,  420,  421,  422,
 /*  1390 */   388,  424,  213,   49,  339,  377,  429,  410,  431,  388,
 /*  1400 */   445,  414,  435,  436,  417,  418,  419,  420,  421,  422,
 /*  1410 */   437,  424,  464,  446,  101,  252,  429,   99,  431,  448,
 /*  1420 */   102,  101,  435,  436,  412,  101,  101,  188,  332,   48,
 /*  1430 */   411,  184,  399,  446,   42,   33,  101,  385,   20,  101,
 /*  1440 */   165,  388,  385,  383,  340,   20,  340,  385,  332,  383,
 /*  1450 */    48,  383,  134,   98,   95,  340,   54,   55,   56,   57,
 /*  1460 */    58,  365,  350,  349,   94,  348,  340,  340,  188,  373,
 /*  1470 */   340,   20,  334,   20,  378,  405,  380,  334,  346,   20,
 /*  1480 */   380,  365,   20,  346,   20,  341,  398,  169,  346,  373,
 /*  1490 */   341,  346,  174,  340,  378,   52,  380,  346,  346,  343,
 /*  1500 */   346,   99,  343,  334,  102,  365,  410,  340,  190,  378,
 /*  1510 */   414,  193,  378,  417,  418,  419,  420,  421,  422,  202,
 /*  1520 */   424,  334,  332,  365,  378,  429,  410,  431,  409,  365,
 /*  1530 */   414,  435,  436,  417,  418,  419,  420,  421,  422,  100,
 /*  1540 */   424,  365,  446,  365,  344,  429,  332,  431,  365,  192,
 /*  1550 */   365,  435,  436,  365,  365,  365,  191,  365,  340,  365,
 /*  1560 */   380,  404,  407,  373,  403,  405,  344,  259,  378,  388,
 /*  1570 */   380,  169,  170,  453,  388,  378,  174,  258,  176,  365,
 /*  1580 */   177,  378,  453,  378,  378,  269,  453,  373,  267,  393,
 /*  1590 */   455,  393,  378,  253,  380,  193,  332,  268,  276,  451,
 /*  1600 */   410,  273,  271,  249,  414,  373,  456,  417,  418,  419,
 /*  1610 */   420,  421,  422,  332,  424,   20,  450,  452,  340,  429,
 /*  1620 */   412,  431,   20,  416,  410,  435,  436,  465,  414,  365,
 /*  1630 */   341,  417,  418,  419,  420,  421,  422,  373,  424,  466,
 /*  1640 */   472,  344,  378,  344,  380,  431,  365,  391,  378,  435,
 /*  1650 */   436,  393,  378,  393,  373,  378,  170,  390,  344,  378,
 /*  1660 */   378,  380,  378,  378,  361,  373,  100,  344,  434,  100,
 /*  1670 */   369,  378,   36,  332,  410,  345,  340,  344,  414,  406,
 /*  1680 */   335,  417,  418,  419,  420,  421,  422,  334,  424,  355,
 /*  1690 */   400,  410,  394,  332,  394,  414,  359,  330,  417,  418,
 /*  1700 */   419,  420,  421,  422,    0,  424,  365,    0,  359,  359,
 /*  1710 */     0,   42,  431,    0,  373,   35,  435,  436,  207,  378,
 /*  1720 */    35,  380,   35,   35,  207,  461,  365,    0,   35,   35,
 /*  1730 */   207,    0,  207,    0,  373,   35,    0,   22,    0,  378,
 /*  1740 */    35,  380,  194,  188,  186,    0,    0,    0,    0,  182,
 /*  1750 */     0,  410,  181,   47,    0,  414,  332,    0,  417,  418,
 /*  1760 */   419,  420,  421,  422,    0,  424,   42,    0,    0,    0,
 /*  1770 */     0,  410,  431,    0,    0,  414,  435,  436,  417,  418,
 /*  1780 */   419,  420,  421,  422,  155,  424,    0,    0,   35,  365,
 /*  1790 */     0,    0,  155,    0,  370,    0,    0,  373,    0,    0,
 /*  1800 */     0,    0,  378,    0,  380,    0,    0,    0,    0,    0,
 /*  1810 */     0,    0,    0,   42,  332,    0,    0,    0,    0,    0,
 /*  1820 */     0,    0,    0,  139,   22,    0,    0,    0,   96,   35,
 /*  1830 */    96,  470,    0,   58,  410,   22,   22,   58,  414,  332,
 /*  1840 */     0,  417,  418,  419,  420,  421,  422,  365,  424,    0,
 /*  1850 */    58,    0,   14,   14,    0,  373,    0,    0,    0,  177,
 /*  1860 */   378,  109,  380,   39,    0,   42,    0,    0,    0,   65,
 /*  1870 */    40,    0,  365,   44,   39,   47,   39,  370,   47,   35,
 /*  1880 */   373,   47,   39,    0,   48,  378,   39,  380,   35,   48,
 /*  1890 */     0,   39,  410,   48,   35,    0,  414,    0,   35,  417,
 /*  1900 */   418,  419,  420,  421,  422,    0,  424,    0,  426,   39,
 /*  1910 */     0,   35,  332,   48,   22,    0,   35,  410,   44,   35,
 /*  1920 */    35,  414,   35,   35,  417,  418,  419,  420,  421,  422,
 /*  1930 */    44,  424,    0,  332,   35,   35,   35,   35,   22,   35,
 /*  1940 */   107,   22,    0,   22,   50,  365,    0,   22,   35,    0,
 /*  1950 */   370,    0,   35,  373,    0,   35,   22,   20,  378,   35,
 /*  1960 */   380,   35,  332,   35,    0,  168,  365,   22,   35,    0,
 /*  1970 */   101,  189,  100,  100,  373,   22,    0,    0,    3,  378,
 /*  1980 */    44,  380,  254,  332,   44,   44,   47,   44,   44,  100,
 /*  1990 */   410,   95,  101,  100,  414,  365,   98,  417,  418,  419,
 /*  2000 */   420,  421,  422,  373,  424,   96,  100,   96,  378,  101,
 /*  2010 */   380,  410,   47,  101,  168,  414,  365,  254,  417,  418,
 /*  2020 */   419,  420,  421,  422,  373,  424,    3,  100,   44,  378,
 /*  2030 */   170,  380,  101,  332,  254,  100,   35,  175,  100,   35,
 /*  2040 */   410,   35,   35,  168,  414,   35,   35,  417,  418,  419,
 /*  2050 */   420,  421,  422,  101,  424,   47,  101,  101,  332,  101,
 /*  2060 */    44,  410,   47,    0,    0,  414,  365,    0,  417,  418,
 /*  2070 */   419,  420,  421,  422,  373,  424,    0,   39,  100,  378,
 /*  2080 */    47,  380,  100,    0,  101,  171,  101,  100,  100,  100,
 /*  2090 */    39,  365,  169,  332,  100,   47,  248,   44,   98,  373,
 /*  2100 */   110,   98,    2,   22,  378,  100,  380,   47,   47,   22,
 /*  2110 */   101,  410,  235,  100,  100,  414,  332,  100,  417,  418,
 /*  2120 */   419,  420,  421,  422,  100,  424,  365,  101,  101,  101,
 /*  2130 */   100,  213,  111,  101,  373,  100,  410,   35,   35,  378,
 /*  2140 */   414,  380,  101,  417,  418,  419,  420,  421,  422,  365,
 /*  2150 */   424,   35,  100,   35,   35,  101,  100,  373,  101,  101,
 /*  2160 */    35,   22,  378,  215,  380,  100,  100,  123,  123,  123,
 /*  2170 */   123,  410,   44,  100,  332,  414,   35,  100,  417,  418,
 /*  2180 */   419,  420,  421,  422,  112,  424,  100,   22,   65,   35,
 /*  2190 */    64,   35,   35,  332,  410,   35,   35,   35,  414,   35,
 /*  2200 */    71,  417,  418,  419,  420,  421,  422,  365,  424,   35,
 /*  2210 */    93,   35,   35,   44,   35,  373,   35,   35,   22,   35,
 /*  2220 */   378,   35,  380,   35,   71,   35,  365,   35,   35,   35,
 /*  2230 */    35,   22,   35,    0,  373,   35,    0,   48,   39,  378,
 /*  2240 */    35,  380,   39,    0,    0,   35,   48,   39,   35,   48,
 /*  2250 */    48,   39,  410,    0,  332,   35,  414,   35,    0,  417,
 /*  2260 */   418,  419,  420,  421,  422,  473,  424,   22,   21,   20,
 /*  2270 */    22,  410,   22,   21,  473,  414,  473,  473,  417,  418,
 /*  2280 */   419,  420,  421,  422,  473,  424,  473,  365,  473,  473,
 /*  2290 */   473,  473,  473,  473,  473,  373,  473,  473,  473,  473,
 /*  2300 */   378,  473,  380,  473,  473,  473,  473,  473,  473,  473,
 /*  2310 */   473,  473,  332,  473,  473,  473,  473,  473,  473,  473,
 /*  2320 */   473,  473,  473,  473,  473,  473,  473,  473,  332,  473,
 /*  2330 */   473,  473,  410,  473,  473,  473,  414,  473,  473,  417,
 /*  2340 */   418,  419,  420,  421,  422,  365,  424,  473,  473,  473,
 /*  2350 */   473,  473,  473,  373,  473,  473,  473,  473,  378,  473,
 /*  2360 */   380,  365,  473,  473,  473,  473,  473,  473,  473,  373,
 /*  2370 */   473,  473,  473,  473,  378,  473,  380,  473,  473,  473,
 /*  2380 */   473,  473,  473,  473,  473,  473,  473,  473,  473,  473,
 /*  2390 */   410,  332,  473,  473,  414,  473,  473,  417,  418,  419,
 /*  2400 */   420,  421,  422,  473,  424,  473,  410,  332,  473,  473,
 /*  2410 */   414,  473,  473,  417,  418,  419,  420,  421,  422,  473,
 /*  2420 */   424,  473,  473,  473,  365,  473,  332,  473,  473,  473,
 /*  2430 */   473,  473,  373,  473,  473,  473,  473,  378,  473,  380,
 /*  2440 */   365,  473,  473,  473,  473,  473,  473,  473,  373,  473,
 /*  2450 */   473,  473,  473,  378,  473,  380,  473,  473,  473,  365,
 /*  2460 */   473,  473,  473,  473,  473,  473,  473,  373,  473,  410,
 /*  2470 */   473,  473,  378,  414,  380,  473,  417,  418,  419,  420,
 /*  2480 */   421,  422,  473,  424,  473,  410,  473,  473,  473,  414,
 /*  2490 */   332,  473,  417,  418,  419,  420,  421,  422,  473,  424,
 /*  2500 */   473,  473,  473,  473,  410,  473,  473,  332,  414,  473,
 /*  2510 */   473,  417,  418,  419,  420,  421,  422,  473,  424,  473,
 /*  2520 */   473,  473,  473,  365,  473,  473,  473,  473,  473,  473,
 /*  2530 */   473,  373,  473,  473,  473,  473,  378,  473,  380,  473,
 /*  2540 */   365,  473,  473,  473,  473,  473,  473,  473,  373,  473,
 /*  2550 */   473,  473,  473,  378,  473,  380,  473,  473,  473,  473,
 /*  2560 */   473,  473,  473,  473,  473,  473,  473,  332,  410,  473,
 /*  2570 */   473,  473,  414,  473,  473,  417,  418,  419,  420,  421,
 /*  2580 */   422,  473,  424,  473,  473,  410,  473,  332,  473,  414,
 /*  2590 */   473,  473,  417,  418,  419,  420,  421,  422,  473,  424,
 /*  2600 */   365,  473,  473,  473,  473,  473,  473,  473,  373,  473,
 /*  2610 */   473,  473,  473,  378,  473,  380,  473,  473,  473,  473,
 /*  2620 */   365,  473,  473,  473,  473,  473,  473,  473,  373,  473,
 /*  2630 */   473,  473,  473,  378,  473,  380,  473,  473,  473,  473,
 /*  2640 */   473,  473,  473,  473,  473,  410,  473,  473,  473,  414,
 /*  2650 */   473,  473,  417,  418,  419,  420,  421,  422,  473,  424,
 /*  2660 */   473,  332,  473,  473,  473,  410,  473,  473,  473,  414,
 /*  2670 */   473,  473,  417,  418,  419,  420,  421,  422,  332,  424,
 /*  2680 */   473,  473,  473,  473,  473,  473,  473,  473,  473,  473,
 /*  2690 */   473,  473,  473,  473,  365,  473,  473,  473,  473,  473,
 /*  2700 */   473,  473,  373,  473,  473,  473,  473,  378,  473,  380,
 /*  2710 */   473,  365,  473,  473,  473,  473,  473,  473,  473,  373,
 /*  2720 */   473,  473,  473,  473,  378,  473,  380,  473,  473,  473,
 /*  2730 */   473,  473,  473,  473,  473,  473,  473,  473,  473,  410,
 /*  2740 */   332,  473,  473,  414,  473,  473,  417,  418,  419,  420,
 /*  2750 */   421,  422,  473,  424,  473,  473,  410,  473,  473,  473,
 /*  2760 */   414,  473,  473,  417,  418,  419,  420,  421,  422,  473,
 /*  2770 */   424,  473,  473,  365,  473,  473,  473,  473,  473,  473,
 /*  2780 */   473,  373,  473,  473,  473,  473,  378,  473,  380,  473,
 /*  2790 */   473,  473,  473,  473,  473,  473,  473,  473,  473,  473,
 /*  2800 */   473,  473,  473,  473,  473,  473,  473,  473,  473,  473,
 /*  2810 */   473,  473,  473,  473,  473,  473,  473,  473,  410,  473,
 /*  2820 */   473,  473,  414,  473,  473,  417,  418,  419,  420,  421,
 /*  2830 */   422,  473,  424,
};
#define YY_SHIFT_COUNT    (757)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2258)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   957,    0,   98,    0,  321,  321,  321,  321,  321,  321,
 /*    10 */   321,  321,  321,  321,  321,  419,  641,  641,  739,  641,
 /*    20 */   641,  641,  641,  641,  641,  641,  641,  641,  641,  641,
 /*    30 */   641,  641,  641,  641,  641,  641,  641,  641,  641,  641,
 /*    40 */   641,  641,  641,  641,  641,  641,  641,  641,  141,  469,
 /*    50 */   818,   68,   97,  504,  556,  504,   68,   68,  966,  966,
 /*    60 */   966,  504,  966,  966,   94,  504,    4,  653,   24,   24,
 /*    70 */   653,  292,  292,  319,  425,  191,  191,   24,   24,   24,
 /*    80 */    24,   24,   24,   24,  138,   24,   24,  124,    4,   24,
 /*    90 */    24,  243,   24,    4,   24,  138,   24,  138,    4,   24,
 /*   100 */    24,    4,   24,    4,    4,    4,   24,  205,  956,  285,
 /*   110 */   285,  117,  251,  990,  990,  990,  990,  990,  990,  990,
 /*   120 */   990,  990,  990,  990,  990,  990,  990,  990,  990,  990,
 /*   130 */   990,  990,  679,  603,  319,  425,  239,  763,  763,  763,
 /*   140 */    36,  194,  194,  239,  275,  275,  275,  124,  242,  164,
 /*   150 */     4,  391,    4,  391,  391,  365,  442,  245,  245,  245,
 /*   160 */   245,  245,  245,  245,  245, 1318,  491,  375,  400,  673,
 /*   170 */   502,  112,   95,  778,  824,   29,  902,  946,  903,  953,
 /*   180 */   801,  839,  770,  801, 1016,  998, 1136, 1163, 1381, 1247,
 /*   190 */  1392, 1418, 1392, 1275, 1425, 1425, 1392, 1275, 1275, 1355,
 /*   200 */  1359, 1425, 1370, 1425, 1425, 1425, 1451, 1451, 1453,  124,
 /*   210 */  1459,  124, 1462, 1464,  124, 1462,  124,  124,  124, 1425,
 /*   220 */   124, 1443, 1443, 1451,    4,    4,    4,    4,    4,    4,
 /*   230 */     4,    4,    4,    4,    4, 1425, 1451,  391,  391,  391,
 /*   240 */  1317, 1439, 1453,  205, 1357, 1365, 1459,  205, 1425, 1418,
 /*   250 */  1418,  391, 1308, 1319,  391, 1308, 1319,  391,  391,    4,
 /*   260 */  1321, 1403, 1308, 1316, 1329, 1340, 1163, 1322, 1328, 1331,
 /*   270 */  1354,  275, 1595, 1425, 1462,  205,  205, 1602, 1319,  391,
 /*   280 */   391,  391,  391,  391, 1319,  391, 1486,  205,  365,  205,
 /*   290 */   275, 1566, 1569,  391,  442, 1425,  205, 1636, 1451, 2833,
 /*   300 */  2833, 2833, 2833, 2833, 2833, 2833, 2833, 2833,  170, 1402,
 /*   310 */   473,  981,  166,  466,  808,  157,  374,  587,  602,  597,
 /*   320 */   926,  926,  926,  926,  926,  926,  926,  926,  926,  173,
 /*   330 */   320,   26,   26,  342,  532,  536,  113, 1103, 1124,  775,
 /*   340 */   497,  305,  305,  827,  607,  108,  827,  827,  827,  984,
 /*   350 */  1076, 1255, 1139, 1051,  336, 1105, 1174, 1175, 1184,  919,
 /*   360 */  1201,  696, 1225, 1251,  985, 1141, 1191, 1195, 1193, 1202,
 /*   370 */  1221, 1147,  749, 1022, 1171, 1245, 1249, 1254, 1257, 1261,
 /*   380 */  1262, 1332, 1269, 1239, 1280, 1179, 1279, 1248, 1313, 1320,
 /*   390 */  1324, 1325, 1335, 1338,  718, 1343, 1348, 1283, 1344, 1704,
 /*   400 */  1707, 1710, 1669, 1713, 1680, 1511, 1685, 1687, 1688, 1517,
 /*   410 */  1727, 1693, 1694, 1523, 1731, 1525, 1733, 1700, 1736, 1715,
 /*   420 */  1738, 1705, 1548, 1555, 1558, 1745, 1746, 1747, 1567, 1571,
 /*   430 */  1748, 1750, 1706, 1754, 1757, 1764, 1724, 1767, 1768, 1769,
 /*   440 */  1770, 1773, 1774, 1786, 1787, 1629, 1753, 1790, 1637, 1791,
 /*   450 */  1793, 1795, 1796, 1798, 1799, 1800, 1801, 1803, 1805, 1806,
 /*   460 */  1807, 1808, 1809, 1810, 1811, 1771, 1812, 1815, 1816, 1817,
 /*   470 */  1818, 1819, 1802, 1820, 1821, 1822, 1684, 1825, 1826, 1813,
 /*   480 */  1732, 1814, 1734, 1827, 1775, 1794, 1832, 1779, 1840, 1792,
 /*   490 */  1849, 1851, 1823, 1824, 1829, 1828, 1838, 1831, 1839, 1834,
 /*   500 */  1854, 1830, 1835, 1856, 1857, 1858, 1837, 1682, 1864, 1866,
 /*   510 */  1867, 1804, 1868, 1871, 1844, 1836, 1843, 1883, 1853, 1841,
 /*   520 */  1847, 1890, 1859, 1845, 1852, 1895, 1863, 1865, 1870, 1897,
 /*   530 */  1905, 1907, 1910, 1752, 1833, 1876, 1892, 1915, 1881, 1884,
 /*   540 */  1885, 1887, 1888, 1899, 1900, 1874, 1886, 1901, 1902, 1916,
 /*   550 */  1904, 1932, 1919, 1942, 1921, 1894, 1946, 1925, 1913, 1949,
 /*   560 */  1917, 1951, 1920, 1954, 1934, 1937, 1924, 1926, 1928, 1869,
 /*   570 */  1872, 1964, 1797, 1873, 1933, 1945, 1969, 1782, 1953, 1846,
 /*   580 */  1860, 1976, 1977, 1875, 1862, 1975, 1936, 1728, 1889, 1891,
 /*   590 */  1893, 1909, 1898, 1911, 1896, 1908, 1940, 1941, 1912, 1906,
 /*   600 */  1927, 1935, 1931, 1943, 1939, 1965, 1938, 1944, 1763, 1952,
 /*   610 */  1955, 2023, 1984, 1780, 2001, 2004, 2006, 2007, 2010, 2011,
 /*   620 */  1956, 1958, 2008, 1848, 2016, 2015, 2063, 2064, 2067, 2076,
 /*   630 */  1978, 2038, 1828, 2033, 1982, 1983, 1985, 1987, 1988, 1914,
 /*   640 */  1989, 2083, 2051, 1923, 1994, 1990, 1828, 2048, 2053, 2000,
 /*   650 */  1877, 2003, 2100, 2081, 1918, 2005, 2009, 2013, 2026, 2014,
 /*   660 */  2027, 2060, 2017, 2024, 2061, 2028, 2087, 1948, 2030, 2021,
 /*   670 */  2032, 2102, 2103, 2035, 2041, 2116, 2052, 2054, 2118, 2056,
 /*   680 */  2057, 2119, 2065, 2058, 2125, 2066, 2044, 2045, 2046, 2047,
 /*   690 */  2139, 2072, 2073, 2128, 2077, 2141, 2086, 2128, 2128, 2165,
 /*   700 */  2123, 2126, 2154, 2156, 2157, 2160, 2161, 2162, 2164, 2174,
 /*   710 */  2176, 2177, 2129, 2117, 2169, 2179, 2181, 2182, 2196, 2184,
 /*   720 */  2186, 2188, 2153, 1874, 2190, 1886, 2192, 2193, 2194, 2195,
 /*   730 */  2209, 2197, 2233, 2200, 2189, 2199, 2236, 2205, 2198, 2203,
 /*   740 */  2243, 2210, 2201, 2208, 2244, 2213, 2202, 2212, 2253, 2220,
 /*   750 */  2222, 2258, 2245, 2247, 2248, 2250, 2252, 2249,
};
#define YY_REDUCE_COUNT (307)
#define YY_REDUCE_MIN   (-442)
#define YY_REDUCE_MAX   (2408)
static const short yy_reduce_ofst[] = {
 /*     0 */   -20, -328,  248,  809,  840,  907,  967,  987, 1096,  655,
 /*    10 */  1116, 1190, 1214, 1281, 1341,   46, -305,  325,  467,  890,
 /*    20 */  1264, 1361, 1424, 1482, 1507, 1580, 1601, 1630, 1651, 1701,
 /*    30 */  1726, 1761, 1784, 1842, 1861, 1922, 1980, 1996, 2059, 2075,
 /*    40 */  2094, 2158, 2175, 2235, 2255, 2329, 2346, 2408, -317, -303,
 /*    50 */   120,  282,  313,  453,  483,  584,  361,  683, -367, -348,
 /*    60 */  -272,  461,  293,  523, -442, -384,   72, -364, -286, -163,
 /*    70 */  -378, -330, -130,  207, -241,  155,  171,  324,  384,  413,
 /*    80 */   475,  479,  637,  686, -287,  698,  708,   22,  330,  776,
 /*    90 */   788, -358,  791,  465,  802,    6,  815,   70,  -17,  817,
 /*   100 */   859,  713,  861,   60,  717,  255,  868,  230, -297, -284,
 /*   110 */  -284, -344, -259,  201,  241,  252,  401,  456,  471,  501,
 /*   120 */   521,  524,  565,  665,  675,  761,  765,  813,  838,  870,
 /*   130 */   874,  878, -188, -387,  327,  503,  273, -387,  566,  580,
 /*   140 */   549,  464,  583,  562,  -71,   65,  187,  288, -327, -302,
 /*   150 */   545,  380,  568,  666,  755,  790,  395,  265,  529,  541,
 /*   160 */   726,  768,  784,  787,  768,  643,  962,  729,  741,  849,
 /*   170 */   875,  988,  887,  994,  994, 1029, 1002, 1055, 1018, 1011,
 /*   180 */   955,  955,  948,  955,  973,  971,  994, 1012, 1019, 1033,
 /*   190 */  1052, 1053, 1057, 1060, 1104, 1106, 1062, 1066, 1068, 1112,
 /*   200 */  1114, 1115, 1117, 1126, 1127, 1130, 1138, 1143, 1070, 1132,
 /*   210 */  1100, 1137, 1144, 1088, 1142, 1149, 1145, 1151, 1152, 1153,
 /*   220 */  1154, 1156, 1159, 1169, 1140, 1158, 1164, 1176, 1178, 1183,
 /*   230 */  1185, 1188, 1189, 1192, 1194, 1167, 1187, 1131, 1134, 1146,
 /*   240 */  1119, 1155, 1160, 1200, 1157, 1161, 1180, 1222, 1218, 1181,
 /*   250 */  1186, 1197, 1120, 1196, 1203, 1129, 1198, 1205, 1206,  994,
 /*   260 */  1150, 1135, 1133, 1165, 1148, 1166, 1208, 1168, 1173, 1162,
 /*   270 */   955, 1232, 1207, 1278, 1289, 1297, 1299, 1256, 1258, 1270,
 /*   280 */  1274, 1277, 1282, 1284, 1260, 1285, 1267, 1314, 1303, 1323,
 /*   290 */  1292, 1234, 1301, 1293, 1334, 1336, 1333, 1345, 1353, 1290,
 /*   300 */  1273, 1298, 1300, 1337, 1349, 1350, 1330, 1367,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*    10 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*    20 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*    30 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*    40 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*    50 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*    60 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*    70 */  1707, 1707, 1707, 1978, 1707, 1707, 1707, 1707, 1707, 1707,
 /*    80 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1786, 1707, 1707,
 /*    90 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   100 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1784, 1971, 2189,
 /*   110 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   120 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   130 */  1707, 1707, 1707, 2201, 1707, 1707, 1707, 2201, 2201, 2201,
 /*   140 */  1784, 2161, 2161, 1707, 1707, 1707, 1707, 1786, 2034, 1707,
 /*   150 */  1707, 1707, 1707, 1707, 1707, 1906, 1707, 1707, 1707, 1707,
 /*   160 */  1707, 1930, 1707, 1707, 1707, 2024, 1707, 1707, 2226, 2282,
 /*   170 */  1707, 1707, 2229, 1707, 1707, 1707, 1983, 1707, 1859, 2216,
 /*   180 */  2193, 2207, 2266, 2194, 2191, 2210, 1707, 2220, 1707, 2017,
 /*   190 */  1976, 1707, 1976, 1973, 1707, 1707, 1976, 1973, 1973, 1848,
 /*   200 */  1844, 1707, 1842, 1707, 1707, 1707, 1707, 1707, 1707, 1786,
 /*   210 */  1707, 1786, 1707, 1707, 1786, 1707, 1786, 1786, 1786, 1707,
 /*   220 */  1786, 1764, 1764, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   230 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   240 */  2046, 2032, 1707, 1784, 2028, 2026, 1707, 1784, 1707, 1707,
 /*   250 */  1707, 1707, 2237, 2235, 1707, 2237, 2235, 1707, 1707, 1707,
 /*   260 */  2251, 2247, 2237, 2255, 2253, 2222, 2220, 2285, 2272, 2268,
 /*   270 */  2207, 1707, 1707, 1707, 1707, 1784, 1784, 1707, 2235, 1707,
 /*   280 */  1707, 1707, 1707, 1707, 2235, 1707, 1707, 1784, 1707, 1784,
 /*   290 */  1707, 1707, 1875, 1707, 1707, 1707, 1784, 1739, 1707, 2019,
 /*   300 */  2037, 2001, 2001, 1909, 1909, 1909, 1787, 1712, 1707, 1707,
 /*   310 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   320 */  2250, 2249, 2116, 1707, 2165, 2164, 2163, 2154, 2115, 1871,
 /*   330 */  1707, 2114, 2113, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   340 */  1707, 1992, 1991, 2107, 1707, 1707, 2108, 2106, 2105, 1707,
 /*   350 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   360 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   370 */  1707, 1707, 2269, 2273, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   380 */  1707, 2190, 1707, 1707, 1707, 1707, 1707, 2089, 1707, 1707,
 /*   390 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   400 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   410 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   420 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   430 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   440 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   450 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   460 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   470 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   480 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   490 */  1707, 1707, 1707, 1707, 1744, 2094, 1707, 1707, 1707, 1707,
 /*   500 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   510 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   520 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   530 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   540 */  1707, 1707, 1707, 1707, 1707, 1825, 1824, 1707, 1707, 1707,
 /*   550 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   560 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 2098,
 /*   570 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   580 */  1707, 1707, 1707, 1707, 1707, 2265, 2223, 1707, 1707, 1707,
 /*   590 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   600 */  1707, 1707, 1707, 1707, 1707, 2089, 1707, 2248, 1707, 1707,
 /*   610 */  2263, 1707, 2267, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   620 */  2200, 2196, 1707, 1707, 2192, 1707, 1707, 1707, 1707, 1707,
 /*   630 */  1707, 1707, 2097, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   640 */  1707, 1707, 1707, 1707, 1707, 1707, 2088, 1707, 2151, 1707,
 /*   650 */  1707, 1707, 2185, 1707, 1707, 2136, 1707, 1707, 1707, 1707,
 /*   660 */  1707, 1707, 1707, 1707, 1707, 2098, 1707, 2101, 1707, 1707,
 /*   670 */  1707, 1707, 1707, 1903, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   680 */  1707, 1707, 1707, 1707, 1707, 1707, 1888, 1886, 1885, 1884,
 /*   690 */  1707, 1881, 1707, 1916, 1707, 1707, 1707, 1912, 1911, 1707,
 /*   700 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   710 */  1707, 1707, 1707, 1707, 1805, 1707, 1707, 1707, 1707, 1707,
 /*   720 */  1707, 1707, 1707, 1797, 1707, 1796, 1707, 1707, 1707, 1707,
 /*   730 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   740 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
 /*   750 */  1707, 1707, 1707, 1707, 1707, 1707, 1707, 1707,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*       WITH => nothing */
    0,  /*  TIMESTAMP => nothing */
  277,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*   LANGUAGE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  277,  /*      AFTER => ABORT */
  277,  /*     ATTACH => ABORT */
  277,  /*     BEFORE => ABORT */
  277,  /*      BEGIN => ABORT */
  277,  /*     BITAND => ABORT */
  277,  /*     BITNOT => ABORT */
  277,  /*      BITOR => ABORT */
  277,  /*     BLOCKS => ABORT */
  277,  /*     CHANGE => ABORT */
  277,  /*      COMMA => ABORT */
  277,  /*     CONCAT => ABORT */
  277,  /*   CONFLICT => ABORT */
  277,  /*       COPY => ABORT */
  277,  /*   DEFERRED => ABORT */
  277,  /* DELIMITERS => ABORT */
  277,  /*     DETACH => ABORT */
  277,  /*     DIVIDE => ABORT */
  277,  /*        DOT => ABORT */
  277,  /*       EACH => ABORT */
  277,  /*       FAIL => ABORT */
  277,  /*       FILE => ABORT */
  277,  /*        FOR => ABORT */
  277,  /*       GLOB => ABORT */
  277,  /*         ID => ABORT */
  277,  /*  IMMEDIATE => ABORT */
  277,  /*     IMPORT => ABORT */
  277,  /*  INITIALLY => ABORT */
  277,  /*    INSTEAD => ABORT */
  277,  /*     ISNULL => ABORT */
  277,  /*        KEY => ABORT */
  277,  /*    MODULES => ABORT */
  277,  /*  NK_BITNOT => ABORT */
  277,  /*    NK_SEMI => ABORT */
  277,  /*    NOTNULL => ABORT */
  277,  /*         OF => ABORT */
  277,  /*       PLUS => ABORT */
  277,  /*  PRIVILEGE => ABORT */
  277,  /*      RAISE => ABORT */
  277,  /*    REPLACE => ABORT */
  277,  /*   RESTRICT => ABORT */
  277,  /*        ROW => ABORT */
  277,  /*       SEMI => ABORT */
  277,  /*       STAR => ABORT */
  277,  /*  STATEMENT => ABORT */
  277,  /*     STRICT => ABORT */
  277,  /*     STRING => ABORT */
  277,  /*      TIMES => ABORT */
  277,  /*     VALUES => ABORT */
  277,  /*   VARIABLE => ABORT */
  277,  /*       VIEW => ABORT */
  277,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "COMPACT",
  /*   63 */ "IF",
  /*   64 */ "NOT",
  /*   65 */ "EXISTS",
  /*   66 */ "BUFFER",
  /*   67 */ "CACHEMODEL",
  /*   68 */ "CACHESIZE",
  /*   69 */ "COMP",
  /*   70 */ "DURATION",
  /*   71 */ "NK_VARIABLE",
  /*   72 */ "MAXROWS",
  /*   73 */ "MINROWS",
  /*   74 */ "KEEP",
  /*   75 */ "PAGES",
  /*   76 */ "PAGESIZE",
  /*   77 */ "TSDB_PAGESIZE",
  /*   78 */ "PRECISION",
  /*   79 */ "REPLICA",
  /*   80 */ "VGROUPS",
  /*   81 */ "SINGLE_STABLE",
  /*   82 */ "RETENTIONS",
  /*   83 */ "SCHEMALESS",
  /*   84 */ "WAL_LEVEL",
  /*   85 */ "WAL_FSYNC_PERIOD",
  /*   86 */ "WAL_RETENTION_PERIOD",
  /*   87 */ "WAL_RETENTION_SIZE",
  /*   88 */ "WAL_ROLL_PERIOD",
  /*   89 */ "WAL_SEGMENT_SIZE",
  /*   90 */ "STT_TRIGGER",
  /*   91 */ "TABLE_PREFIX",
  /*   92 */ "TABLE_SUFFIX",
  /*   93 */ "NK_COLON",
  /*   94 */ "MAX_SPEED",
  /*   95 */ "START",
  /*   96 */ "WITH",
  /*   97 */ "TIMESTAMP",
  /*   98 */ "END",
  /*   99 */ "TABLE",
  /*  100 */ "NK_LP",
  /*  101 */ "NK_RP",
  /*  102 */ "STABLE",
  /*  103 */ "ADD",
  /*  104 */ "COLUMN",
  /*  105 */ "MODIFY",
  /*  106 */ "RENAME",
  /*  107 */ "TAG",
  /*  108 */ "SET",
  /*  109 */ "NK_EQ",
  /*  110 */ "USING",
  /*  111 */ "TAGS",
  /*  112 */ "COMMENT",
  /*  113 */ "BOOL",
  /*  114 */ "TINYINT",
  /*  115 */ "SMALLINT",
  /*  116 */ "INT",
  /*  117 */ "INTEGER",
  /*  118 */ "BIGINT",
  /*  119 */ "FLOAT",
  /*  120 */ "DOUBLE",
  /*  121 */ "BINARY",
  /*  122 */ "NCHAR",
  /*  123 */ "UNSIGNED",
  /*  124 */ "JSON",
  /*  125 */ "VARCHAR",
  /*  126 */ "MEDIUMBLOB",
  /*  127 */ "BLOB",
  /*  128 */ "VARBINARY",
  /*  129 */ "DECIMAL",
  /*  130 */ "MAX_DELAY",
  /*  131 */ "WATERMARK",
  /*  132 */ "ROLLUP",
  /*  133 */ "TTL",
  /*  134 */ "SMA",
  /*  135 */ "DELETE_MARK",
  /*  136 */ "FIRST",
  /*  137 */ "LAST",
  /*  138 */ "SHOW",
  /*  139 */ "PRIVILEGES",
  /*  140 */ "DATABASES",
  /*  141 */ "TABLES",
  /*  142 */ "STABLES",
  /*  143 */ "MNODES",
  /*  144 */ "QNODES",
  /*  145 */ "FUNCTIONS",
  /*  146 */ "INDEXES",
  /*  147 */ "ACCOUNTS",
  /*  148 */ "APPS",
  /*  149 */ "CONNECTIONS",
  /*  150 */ "LICENCES",
  /*  151 */ "GRANTS",
  /*  152 */ "QUERIES",
  /*  153 */ "SCORES",
  /*  154 */ "TOPICS",
  /*  155 */ "VARIABLES",
  /*  156 */ "CLUSTER",
  /*  157 */ "BNODES",
  /*  158 */ "SNODES",
  /*  159 */ "TRANSACTIONS",
  /*  160 */ "DISTRIBUTED",
  /*  161 */ "CONSUMERS",
  /*  162 */ "SUBSCRIPTIONS",
  /*  163 */ "VNODES",
  /*  164 */ "ALIVE",
  /*  165 */ "LIKE",
  /*  166 */ "TBNAME",
  /*  167 */ "QTAGS",
  /*  168 */ "AS",
  /*  169 */ "INDEX",
  /*  170 */ "FUNCTION",
  /*  171 */ "INTERVAL",
  /*  172 */ "COUNT",
  /*  173 */ "LAST_ROW",
  /*  174 */ "TOPIC",
  /*  175 */ "META",
  /*  176 */ "CONSUMER",
  /*  177 */ "GROUP",
  /*  178 */ "DESC",
  /*  179 */ "DESCRIBE",
  /*  180 */ "RESET",
  /*  181 */ "QUERY",
  /*  182 */ "CACHE",
  /*  183 */ "EXPLAIN",
  /*  184 */ "ANALYZE",
  /*  185 */ "VERBOSE",
  /*  186 */ "NK_BOOL",
  /*  187 */ "RATIO",
  /*  188 */ "NK_FLOAT",
  /*  189 */ "OUTPUTTYPE",
  /*  190 */ "AGGREGATE",
  /*  191 */ "BUFSIZE",
  /*  192 */ "LANGUAGE",
  /*  193 */ "STREAM",
  /*  194 */ "INTO",
  /*  195 */ "TRIGGER",
  /*  196 */ "AT_ONCE",
  /*  197 */ "WINDOW_CLOSE",
  /*  198 */ "IGNORE",
  /*  199 */ "EXPIRED",
  /*  200 */ "FILL_HISTORY",
  /*  201 */ "UPDATE",
  /*  202 */ "SUBTABLE",
  /*  203 */ "KILL",
  /*  204 */ "CONNECTION",
  /*  205 */ "TRANSACTION",
  /*  206 */ "BALANCE",
  /*  207 */ "VGROUP",
  /*  208 */ "MERGE",
  /*  209 */ "REDISTRIBUTE",
  /*  210 */ "SPLIT",
  /*  211 */ "DELETE",
  /*  212 */ "INSERT",
  /*  213 */ "NULL",
  /*  214 */ "NK_QUESTION",
  /*  215 */ "NK_ARROW",
  /*  216 */ "ROWTS",
  /*  217 */ "QSTART",
  /*  218 */ "QEND",
  /*  219 */ "QDURATION",
  /*  220 */ "WSTART",
  /*  221 */ "WEND",
  /*  222 */ "WDURATION",
  /*  223 */ "IROWTS",
  /*  224 */ "ISFILLED",
  /*  225 */ "CAST",
  /*  226 */ "NOW",
  /*  227 */ "TODAY",
  /*  228 */ "TIMEZONE",
  /*  229 */ "CLIENT_VERSION",
  /*  230 */ "SERVER_VERSION",
  /*  231 */ "SERVER_STATUS",
  /*  232 */ "CURRENT_USER",
  /*  233 */ "CASE",
  /*  234 */ "WHEN",
  /*  235 */ "THEN",
  /*  236 */ "ELSE",
  /*  237 */ "BETWEEN",
  /*  238 */ "IS",
  /*  239 */ "NK_LT",
  /*  240 */ "NK_GT",
  /*  241 */ "NK_LE",
  /*  242 */ "NK_GE",
  /*  243 */ "NK_NE",
  /*  244 */ "MATCH",
  /*  245 */ "NMATCH",
  /*  246 */ "CONTAINS",
  /*  247 */ "IN",
  /*  248 */ "JOIN",
  /*  249 */ "INNER",
  /*  250 */ "SELECT",
  /*  251 */ "DISTINCT",
  /*  252 */ "WHERE",
  /*  253 */ "PARTITION",
  /*  254 */ "BY",
  /*  255 */ "SESSION",
  /*  256 */ "STATE_WINDOW",
  /*  257 */ "EVENT_WINDOW",
  /*  258 */ "SLIDING",
  /*  259 */ "FILL",
  /*  260 */ "VALUE",
  /*  261 */ "VALUE_F",
  /*  262 */ "NONE",
  /*  263 */ "PREV",
  /*  264 */ "NULL_F",
  /*  265 */ "LINEAR",
  /*  266 */ "NEXT",
  /*  267 */ "HAVING",
  /*  268 */ "RANGE",
  /*  269 */ "EVERY",
  /*  270 */ "ORDER",
  /*  271 */ "SLIMIT",
  /*  272 */ "SOFFSET",
  /*  273 */ "LIMIT",
  /*  274 */ "OFFSET",
  /*  275 */ "ASC",
  /*  276 */ "NULLS",
  /*  277 */ "ABORT",
  /*  278 */ "AFTER",
  /*  279 */ "ATTACH",
  /*  280 */ "BEFORE",
  /*  281 */ "BEGIN",
  /*  282 */ "BITAND",
  /*  283 */ "BITNOT",
  /*  284 */ "BITOR",
  /*  285 */ "BLOCKS",
  /*  286 */ "CHANGE",
  /*  287 */ "COMMA",
  /*  288 */ "CONCAT",
  /*  289 */ "CONFLICT",
  /*  290 */ "COPY",
  /*  291 */ "DEFERRED",
  /*  292 */ "DELIMITERS",
  /*  293 */ "DETACH",
  /*  294 */ "DIVIDE",
  /*  295 */ "DOT",
  /*  296 */ "EACH",
  /*  297 */ "FAIL",
  /*  298 */ "FILE",
  /*  299 */ "FOR",
  /*  300 */ "GLOB",
  /*  301 */ "ID",
  /*  302 */ "IMMEDIATE",
  /*  303 */ "IMPORT",
  /*  304 */ "INITIALLY",
  /*  305 */ "INSTEAD",
  /*  306 */ "ISNULL",
  /*  307 */ "KEY",
  /*  308 */ "MODULES",
  /*  309 */ "NK_BITNOT",
  /*  310 */ "NK_SEMI",
  /*  311 */ "NOTNULL",
  /*  312 */ "OF",
  /*  313 */ "PLUS",
  /*  314 */ "PRIVILEGE",
  /*  315 */ "RAISE",
  /*  316 */ "REPLACE",
  /*  317 */ "RESTRICT",
  /*  318 */ "ROW",
  /*  319 */ "SEMI",
  /*  320 */ "STAR",
  /*  321 */ "STATEMENT",
  /*  322 */ "STRICT",
  /*  323 */ "STRING",
  /*  324 */ "TIMES",
  /*  325 */ "VALUES",
  /*  326 */ "VARIABLE",
  /*  327 */ "VIEW",
  /*  328 */ "WAL",
  /*  329 */ "cmd",
  /*  330 */ "account_options",
  /*  331 */ "alter_account_options",
  /*  332 */ "literal",
  /*  333 */ "alter_account_option",
  /*  334 */ "user_name",
  /*  335 */ "sysinfo_opt",
  /*  336 */ "privileges",
  /*  337 */ "priv_level",
  /*  338 */ "priv_type_list",
  /*  339 */ "priv_type",
  /*  340 */ "db_name",
  /*  341 */ "topic_name",
  /*  342 */ "dnode_endpoint",
  /*  343 */ "force_opt",
  /*  344 */ "not_exists_opt",
  /*  345 */ "db_options",
  /*  346 */ "exists_opt",
  /*  347 */ "alter_db_options",
  /*  348 */ "speed_opt",
  /*  349 */ "start_opt",
  /*  350 */ "end_opt",
  /*  351 */ "integer_list",
  /*  352 */ "variable_list",
  /*  353 */ "retention_list",
  /*  354 */ "alter_db_option",
  /*  355 */ "retention",
  /*  356 */ "full_table_name",
  /*  357 */ "column_def_list",
  /*  358 */ "tags_def_opt",
  /*  359 */ "table_options",
  /*  360 */ "multi_create_clause",
  /*  361 */ "tags_def",
  /*  362 */ "multi_drop_clause",
  /*  363 */ "alter_table_clause",
  /*  364 */ "alter_table_options",
  /*  365 */ "column_name",
  /*  366 */ "type_name",
  /*  367 */ "signed_literal",
  /*  368 */ "create_subtable_clause",
  /*  369 */ "specific_cols_opt",
  /*  370 */ "expression_list",
  /*  371 */ "drop_table_clause",
  /*  372 */ "col_name_list",
  /*  373 */ "table_name",
  /*  374 */ "column_def",
  /*  375 */ "duration_list",
  /*  376 */ "rollup_func_list",
  /*  377 */ "alter_table_option",
  /*  378 */ "duration_literal",
  /*  379 */ "rollup_func_name",
  /*  380 */ "function_name",
  /*  381 */ "col_name",
  /*  382 */ "db_name_cond_opt",
  /*  383 */ "like_pattern_opt",
  /*  384 */ "table_name_cond",
  /*  385 */ "from_db_opt",
  /*  386 */ "tag_list_opt",
  /*  387 */ "tag_item",
  /*  388 */ "column_alias",
  /*  389 */ "full_index_name",
  /*  390 */ "index_options",
  /*  391 */ "index_name",
  /*  392 */ "func_list",
  /*  393 */ "sliding_opt",
  /*  394 */ "sma_stream_opt",
  /*  395 */ "func",
  /*  396 */ "sma_func_name",
  /*  397 */ "query_or_subquery",
  /*  398 */ "cgroup_name",
  /*  399 */ "analyze_opt",
  /*  400 */ "explain_options",
  /*  401 */ "insert_query",
  /*  402 */ "agg_func_opt",
  /*  403 */ "bufsize_opt",
  /*  404 */ "language_opt",
  /*  405 */ "stream_name",
  /*  406 */ "stream_options",
  /*  407 */ "col_list_opt",
  /*  408 */ "tag_def_or_ref_opt",
  /*  409 */ "subtable_opt",
  /*  410 */ "expression",
  /*  411 */ "dnode_list",
  /*  412 */ "where_clause_opt",
  /*  413 */ "signed",
  /*  414 */ "literal_func",
  /*  415 */ "literal_list",
  /*  416 */ "table_alias",
  /*  417 */ "expr_or_subquery",
  /*  418 */ "pseudo_column",
  /*  419 */ "column_reference",
  /*  420 */ "function_expression",
  /*  421 */ "case_when_expression",
  /*  422 */ "star_func",
  /*  423 */ "star_func_para_list",
  /*  424 */ "noarg_func",
  /*  425 */ "other_para_list",
  /*  426 */ "star_func_para",
  /*  427 */ "when_then_list",
  /*  428 */ "case_when_else_opt",
  /*  429 */ "common_expression",
  /*  430 */ "when_then_expr",
  /*  431 */ "predicate",
  /*  432 */ "compare_op",
  /*  433 */ "in_op",
  /*  434 */ "in_predicate_value",
  /*  435 */ "boolean_value_expression",
  /*  436 */ "boolean_primary",
  /*  437 */ "from_clause_opt",
  /*  438 */ "table_reference_list",
  /*  439 */ "table_reference",
  /*  440 */ "table_primary",
  /*  441 */ "joined_table",
  /*  442 */ "alias_opt",
  /*  443 */ "subquery",
  /*  444 */ "parenthesized_joined_table",
  /*  445 */ "join_type",
  /*  446 */ "search_condition",
  /*  447 */ "query_specification",
  /*  448 */ "set_quantifier_opt",
  /*  449 */ "select_list",
  /*  450 */ "partition_by_clause_opt",
  /*  451 */ "range_opt",
  /*  452 */ "every_opt",
  /*  453 */ "fill_opt",
  /*  454 */ "twindow_clause_opt",
  /*  455 */ "group_by_clause_opt",
  /*  456 */ "having_clause_opt",
  /*  457 */ "select_item",
  /*  458 */ "partition_list",
  /*  459 */ "partition_item",
  /*  460 */ "fill_mode",
  /*  461 */ "group_by_list",
  /*  462 */ "query_expression",
  /*  463 */ "query_simple",
  /*  464 */ "order_by_clause_opt",
  /*  465 */ "slimit_clause_opt",
  /*  466 */ "limit_clause_opt",
  /*  467 */ "union_query_expression",
  /*  468 */ "query_simple_or_subquery",
  /*  469 */ "sort_specification_list",
  /*  470 */ "sort_specification",
  /*  471 */ "ordering_specification_opt",
  /*  472 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  73 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  74 */ "not_exists_opt ::=",
 /*  75 */ "exists_opt ::= IF EXISTS",
 /*  76 */ "exists_opt ::=",
 /*  77 */ "db_options ::=",
 /*  78 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  79 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  80 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  81 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  83 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  84 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  86 */ "db_options ::= db_options KEEP integer_list",
 /*  87 */ "db_options ::= db_options KEEP variable_list",
 /*  88 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  89 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  92 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  93 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  94 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  95 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  96 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 107 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 108 */ "alter_db_options ::= alter_db_option",
 /* 109 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 110 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 111 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 112 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 114 */ "alter_db_option ::= KEEP integer_list",
 /* 115 */ "alter_db_option ::= KEEP variable_list",
 /* 116 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 117 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 118 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 119 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 120 */ "alter_db_option ::= MINROWS NK_INTEGER",
 /* 121 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER",
 /* 122 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 123 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER",
 /* 124 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 125 */ "integer_list ::= NK_INTEGER",
 /* 126 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 127 */ "variable_list ::= NK_VARIABLE",
 /* 128 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 129 */ "retention_list ::= retention",
 /* 130 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 131 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 132 */ "speed_opt ::=",
 /* 133 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 134 */ "start_opt ::=",
 /* 135 */ "start_opt ::= START WITH NK_INTEGER",
 /* 136 */ "start_opt ::= START WITH NK_STRING",
 /* 137 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 138 */ "end_opt ::=",
 /* 139 */ "end_opt ::= END WITH NK_INTEGER",
 /* 140 */ "end_opt ::= END WITH NK_STRING",
 /* 141 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 142 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 143 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 144 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 145 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 146 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 147 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 148 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 149 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 150 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 151 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 152 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 153 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 154 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 155 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 156 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 157 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 158 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 159 */ "multi_create_clause ::= create_subtable_clause",
 /* 160 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 161 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 162 */ "multi_drop_clause ::= drop_table_clause",
 /* 163 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 164 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 165 */ "specific_cols_opt ::=",
 /* 166 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 167 */ "full_table_name ::= table_name",
 /* 168 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 169 */ "column_def_list ::= column_def",
 /* 170 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 171 */ "column_def ::= column_name type_name",
 /* 172 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 173 */ "type_name ::= BOOL",
 /* 174 */ "type_name ::= TINYINT",
 /* 175 */ "type_name ::= SMALLINT",
 /* 176 */ "type_name ::= INT",
 /* 177 */ "type_name ::= INTEGER",
 /* 178 */ "type_name ::= BIGINT",
 /* 179 */ "type_name ::= FLOAT",
 /* 180 */ "type_name ::= DOUBLE",
 /* 181 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 182 */ "type_name ::= TIMESTAMP",
 /* 183 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 184 */ "type_name ::= TINYINT UNSIGNED",
 /* 185 */ "type_name ::= SMALLINT UNSIGNED",
 /* 186 */ "type_name ::= INT UNSIGNED",
 /* 187 */ "type_name ::= BIGINT UNSIGNED",
 /* 188 */ "type_name ::= JSON",
 /* 189 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 190 */ "type_name ::= MEDIUMBLOB",
 /* 191 */ "type_name ::= BLOB",
 /* 192 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 193 */ "type_name ::= DECIMAL",
 /* 194 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 195 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 196 */ "tags_def_opt ::=",
 /* 197 */ "tags_def_opt ::= tags_def",
 /* 198 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 199 */ "table_options ::=",
 /* 200 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 201 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 202 */ "table_options ::= table_options WATERMARK duration_list",
 /* 203 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 204 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 205 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 206 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 207 */ "alter_table_options ::= alter_table_option",
 /* 208 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 209 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 210 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 211 */ "duration_list ::= duration_literal",
 /* 212 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 213 */ "rollup_func_list ::= rollup_func_name",
 /* 214 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 215 */ "rollup_func_name ::= function_name",
 /* 216 */ "rollup_func_name ::= FIRST",
 /* 217 */ "rollup_func_name ::= LAST",
 /* 218 */ "col_name_list ::= col_name",
 /* 219 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 220 */ "col_name ::= column_name",
 /* 221 */ "cmd ::= SHOW DNODES",
 /* 222 */ "cmd ::= SHOW USERS",
 /* 223 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 224 */ "cmd ::= SHOW DATABASES",
 /* 225 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 226 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 227 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 228 */ "cmd ::= SHOW MNODES",
 /* 229 */ "cmd ::= SHOW QNODES",
 /* 230 */ "cmd ::= SHOW FUNCTIONS",
 /* 231 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 232 */ "cmd ::= SHOW STREAMS",
 /* 233 */ "cmd ::= SHOW ACCOUNTS",
 /* 234 */ "cmd ::= SHOW APPS",
 /* 235 */ "cmd ::= SHOW CONNECTIONS",
 /* 236 */ "cmd ::= SHOW LICENCES",
 /* 237 */ "cmd ::= SHOW GRANTS",
 /* 238 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 239 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 240 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 241 */ "cmd ::= SHOW QUERIES",
 /* 242 */ "cmd ::= SHOW SCORES",
 /* 243 */ "cmd ::= SHOW TOPICS",
 /* 244 */ "cmd ::= SHOW VARIABLES",
 /* 245 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 246 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 247 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 248 */ "cmd ::= SHOW BNODES",
 /* 249 */ "cmd ::= SHOW SNODES",
 /* 250 */ "cmd ::= SHOW CLUSTER",
 /* 251 */ "cmd ::= SHOW TRANSACTIONS",
 /* 252 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 253 */ "cmd ::= SHOW CONSUMERS",
 /* 254 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 255 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 256 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 257 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 258 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 259 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 260 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 261 */ "db_name_cond_opt ::=",
 /* 262 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 263 */ "like_pattern_opt ::=",
 /* 264 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 265 */ "table_name_cond ::= table_name",
 /* 266 */ "from_db_opt ::=",
 /* 267 */ "from_db_opt ::= FROM db_name",
 /* 268 */ "tag_list_opt ::=",
 /* 269 */ "tag_list_opt ::= tag_item",
 /* 270 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 271 */ "tag_item ::= TBNAME",
 /* 272 */ "tag_item ::= QTAGS",
 /* 273 */ "tag_item ::= column_name",
 /* 274 */ "tag_item ::= column_name column_alias",
 /* 275 */ "tag_item ::= column_name AS column_alias",
 /* 276 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 277 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 278 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 279 */ "full_index_name ::= index_name",
 /* 280 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 281 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 282 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 283 */ "func_list ::= func",
 /* 284 */ "func_list ::= func_list NK_COMMA func",
 /* 285 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 286 */ "sma_func_name ::= function_name",
 /* 287 */ "sma_func_name ::= COUNT",
 /* 288 */ "sma_func_name ::= FIRST",
 /* 289 */ "sma_func_name ::= LAST",
 /* 290 */ "sma_func_name ::= LAST_ROW",
 /* 291 */ "sma_stream_opt ::=",
 /* 292 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 293 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 294 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 295 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 296 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 297 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 298 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 299 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 300 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 301 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 302 */ "cmd ::= DESC full_table_name",
 /* 303 */ "cmd ::= DESCRIBE full_table_name",
 /* 304 */ "cmd ::= RESET QUERY CACHE",
 /* 305 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 306 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 307 */ "analyze_opt ::=",
 /* 308 */ "analyze_opt ::= ANALYZE",
 /* 309 */ "explain_options ::=",
 /* 310 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 311 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 312 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt",
 /* 313 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 314 */ "agg_func_opt ::=",
 /* 315 */ "agg_func_opt ::= AGGREGATE",
 /* 316 */ "bufsize_opt ::=",
 /* 317 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 318 */ "language_opt ::=",
 /* 319 */ "language_opt ::= LANGUAGE NK_STRING",
 /* 320 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 321 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 322 */ "col_list_opt ::=",
 /* 323 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 324 */ "tag_def_or_ref_opt ::=",
 /* 325 */ "tag_def_or_ref_opt ::= tags_def",
 /* 326 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 327 */ "stream_options ::=",
 /* 328 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 329 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 330 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 331 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 332 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 333 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 334 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 335 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 336 */ "subtable_opt ::=",
 /* 337 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 338 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 339 */ "cmd ::= KILL QUERY NK_STRING",
 /* 340 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 341 */ "cmd ::= BALANCE VGROUP",
 /* 342 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 343 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 344 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 345 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 346 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 347 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 348 */ "cmd ::= query_or_subquery",
 /* 349 */ "cmd ::= insert_query",
 /* 350 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 351 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 352 */ "literal ::= NK_INTEGER",
 /* 353 */ "literal ::= NK_FLOAT",
 /* 354 */ "literal ::= NK_STRING",
 /* 355 */ "literal ::= NK_BOOL",
 /* 356 */ "literal ::= TIMESTAMP NK_STRING",
 /* 357 */ "literal ::= duration_literal",
 /* 358 */ "literal ::= NULL",
 /* 359 */ "literal ::= NK_QUESTION",
 /* 360 */ "duration_literal ::= NK_VARIABLE",
 /* 361 */ "signed ::= NK_INTEGER",
 /* 362 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 363 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 364 */ "signed ::= NK_FLOAT",
 /* 365 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 366 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 367 */ "signed_literal ::= signed",
 /* 368 */ "signed_literal ::= NK_STRING",
 /* 369 */ "signed_literal ::= NK_BOOL",
 /* 370 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 371 */ "signed_literal ::= duration_literal",
 /* 372 */ "signed_literal ::= NULL",
 /* 373 */ "signed_literal ::= literal_func",
 /* 374 */ "signed_literal ::= NK_QUESTION",
 /* 375 */ "literal_list ::= signed_literal",
 /* 376 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 377 */ "db_name ::= NK_ID",
 /* 378 */ "table_name ::= NK_ID",
 /* 379 */ "column_name ::= NK_ID",
 /* 380 */ "function_name ::= NK_ID",
 /* 381 */ "table_alias ::= NK_ID",
 /* 382 */ "column_alias ::= NK_ID",
 /* 383 */ "user_name ::= NK_ID",
 /* 384 */ "topic_name ::= NK_ID",
 /* 385 */ "stream_name ::= NK_ID",
 /* 386 */ "cgroup_name ::= NK_ID",
 /* 387 */ "index_name ::= NK_ID",
 /* 388 */ "expr_or_subquery ::= expression",
 /* 389 */ "expression ::= literal",
 /* 390 */ "expression ::= pseudo_column",
 /* 391 */ "expression ::= column_reference",
 /* 392 */ "expression ::= function_expression",
 /* 393 */ "expression ::= case_when_expression",
 /* 394 */ "expression ::= NK_LP expression NK_RP",
 /* 395 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 396 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 397 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 398 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 399 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 400 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 401 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 402 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 403 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 404 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 405 */ "expression_list ::= expr_or_subquery",
 /* 406 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 407 */ "column_reference ::= column_name",
 /* 408 */ "column_reference ::= table_name NK_DOT column_name",
 /* 409 */ "pseudo_column ::= ROWTS",
 /* 410 */ "pseudo_column ::= TBNAME",
 /* 411 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 412 */ "pseudo_column ::= QSTART",
 /* 413 */ "pseudo_column ::= QEND",
 /* 414 */ "pseudo_column ::= QDURATION",
 /* 415 */ "pseudo_column ::= WSTART",
 /* 416 */ "pseudo_column ::= WEND",
 /* 417 */ "pseudo_column ::= WDURATION",
 /* 418 */ "pseudo_column ::= IROWTS",
 /* 419 */ "pseudo_column ::= ISFILLED",
 /* 420 */ "pseudo_column ::= QTAGS",
 /* 421 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 422 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 423 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 424 */ "function_expression ::= literal_func",
 /* 425 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 426 */ "literal_func ::= NOW",
 /* 427 */ "noarg_func ::= NOW",
 /* 428 */ "noarg_func ::= TODAY",
 /* 429 */ "noarg_func ::= TIMEZONE",
 /* 430 */ "noarg_func ::= DATABASE",
 /* 431 */ "noarg_func ::= CLIENT_VERSION",
 /* 432 */ "noarg_func ::= SERVER_VERSION",
 /* 433 */ "noarg_func ::= SERVER_STATUS",
 /* 434 */ "noarg_func ::= CURRENT_USER",
 /* 435 */ "noarg_func ::= USER",
 /* 436 */ "star_func ::= COUNT",
 /* 437 */ "star_func ::= FIRST",
 /* 438 */ "star_func ::= LAST",
 /* 439 */ "star_func ::= LAST_ROW",
 /* 440 */ "star_func_para_list ::= NK_STAR",
 /* 441 */ "star_func_para_list ::= other_para_list",
 /* 442 */ "other_para_list ::= star_func_para",
 /* 443 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 444 */ "star_func_para ::= expr_or_subquery",
 /* 445 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 446 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 447 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 448 */ "when_then_list ::= when_then_expr",
 /* 449 */ "when_then_list ::= when_then_list when_then_expr",
 /* 450 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 451 */ "case_when_else_opt ::=",
 /* 452 */ "case_when_else_opt ::= ELSE common_expression",
 /* 453 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 454 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 455 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 456 */ "predicate ::= expr_or_subquery IS NULL",
 /* 457 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 458 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 459 */ "compare_op ::= NK_LT",
 /* 460 */ "compare_op ::= NK_GT",
 /* 461 */ "compare_op ::= NK_LE",
 /* 462 */ "compare_op ::= NK_GE",
 /* 463 */ "compare_op ::= NK_NE",
 /* 464 */ "compare_op ::= NK_EQ",
 /* 465 */ "compare_op ::= LIKE",
 /* 466 */ "compare_op ::= NOT LIKE",
 /* 467 */ "compare_op ::= MATCH",
 /* 468 */ "compare_op ::= NMATCH",
 /* 469 */ "compare_op ::= CONTAINS",
 /* 470 */ "in_op ::= IN",
 /* 471 */ "in_op ::= NOT IN",
 /* 472 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 473 */ "boolean_value_expression ::= boolean_primary",
 /* 474 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 475 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 476 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 477 */ "boolean_primary ::= predicate",
 /* 478 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 479 */ "common_expression ::= expr_or_subquery",
 /* 480 */ "common_expression ::= boolean_value_expression",
 /* 481 */ "from_clause_opt ::=",
 /* 482 */ "from_clause_opt ::= FROM table_reference_list",
 /* 483 */ "table_reference_list ::= table_reference",
 /* 484 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 485 */ "table_reference ::= table_primary",
 /* 486 */ "table_reference ::= joined_table",
 /* 487 */ "table_primary ::= table_name alias_opt",
 /* 488 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 489 */ "table_primary ::= subquery alias_opt",
 /* 490 */ "table_primary ::= parenthesized_joined_table",
 /* 491 */ "alias_opt ::=",
 /* 492 */ "alias_opt ::= table_alias",
 /* 493 */ "alias_opt ::= AS table_alias",
 /* 494 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 495 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 496 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 497 */ "join_type ::=",
 /* 498 */ "join_type ::= INNER",
 /* 499 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 500 */ "set_quantifier_opt ::=",
 /* 501 */ "set_quantifier_opt ::= DISTINCT",
 /* 502 */ "set_quantifier_opt ::= ALL",
 /* 503 */ "select_list ::= select_item",
 /* 504 */ "select_list ::= select_list NK_COMMA select_item",
 /* 505 */ "select_item ::= NK_STAR",
 /* 506 */ "select_item ::= common_expression",
 /* 507 */ "select_item ::= common_expression column_alias",
 /* 508 */ "select_item ::= common_expression AS column_alias",
 /* 509 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 510 */ "where_clause_opt ::=",
 /* 511 */ "where_clause_opt ::= WHERE search_condition",
 /* 512 */ "partition_by_clause_opt ::=",
 /* 513 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 514 */ "partition_list ::= partition_item",
 /* 515 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 516 */ "partition_item ::= expr_or_subquery",
 /* 517 */ "partition_item ::= expr_or_subquery column_alias",
 /* 518 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 519 */ "twindow_clause_opt ::=",
 /* 520 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 521 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 522 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 523 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 524 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 525 */ "sliding_opt ::=",
 /* 526 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 527 */ "fill_opt ::=",
 /* 528 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 529 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 530 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP",
 /* 531 */ "fill_mode ::= NONE",
 /* 532 */ "fill_mode ::= PREV",
 /* 533 */ "fill_mode ::= NULL",
 /* 534 */ "fill_mode ::= NULL_F",
 /* 535 */ "fill_mode ::= LINEAR",
 /* 536 */ "fill_mode ::= NEXT",
 /* 537 */ "group_by_clause_opt ::=",
 /* 538 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 539 */ "group_by_list ::= expr_or_subquery",
 /* 540 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 541 */ "having_clause_opt ::=",
 /* 542 */ "having_clause_opt ::= HAVING search_condition",
 /* 543 */ "range_opt ::=",
 /* 544 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 545 */ "every_opt ::=",
 /* 546 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 547 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 548 */ "query_simple ::= query_specification",
 /* 549 */ "query_simple ::= union_query_expression",
 /* 550 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 551 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 552 */ "query_simple_or_subquery ::= query_simple",
 /* 553 */ "query_simple_or_subquery ::= subquery",
 /* 554 */ "query_or_subquery ::= query_expression",
 /* 555 */ "query_or_subquery ::= subquery",
 /* 556 */ "order_by_clause_opt ::=",
 /* 557 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 558 */ "slimit_clause_opt ::=",
 /* 559 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 560 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 561 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 562 */ "limit_clause_opt ::=",
 /* 563 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 564 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 565 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 566 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 567 */ "subquery ::= NK_LP subquery NK_RP",
 /* 568 */ "search_condition ::= common_expression",
 /* 569 */ "sort_specification_list ::= sort_specification",
 /* 570 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 571 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 572 */ "ordering_specification_opt ::=",
 /* 573 */ "ordering_specification_opt ::= ASC",
 /* 574 */ "ordering_specification_opt ::= DESC",
 /* 575 */ "null_ordering_opt ::=",
 /* 576 */ "null_ordering_opt ::= NULLS FIRST",
 /* 577 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 329: /* cmd */
    case 332: /* literal */
    case 345: /* db_options */
    case 347: /* alter_db_options */
    case 349: /* start_opt */
    case 350: /* end_opt */
    case 355: /* retention */
    case 356: /* full_table_name */
    case 359: /* table_options */
    case 363: /* alter_table_clause */
    case 364: /* alter_table_options */
    case 367: /* signed_literal */
    case 368: /* create_subtable_clause */
    case 371: /* drop_table_clause */
    case 374: /* column_def */
    case 378: /* duration_literal */
    case 379: /* rollup_func_name */
    case 381: /* col_name */
    case 382: /* db_name_cond_opt */
    case 383: /* like_pattern_opt */
    case 384: /* table_name_cond */
    case 385: /* from_db_opt */
    case 387: /* tag_item */
    case 389: /* full_index_name */
    case 390: /* index_options */
    case 393: /* sliding_opt */
    case 394: /* sma_stream_opt */
    case 395: /* func */
    case 397: /* query_or_subquery */
    case 400: /* explain_options */
    case 401: /* insert_query */
    case 406: /* stream_options */
    case 409: /* subtable_opt */
    case 410: /* expression */
    case 412: /* where_clause_opt */
    case 413: /* signed */
    case 414: /* literal_func */
    case 417: /* expr_or_subquery */
    case 418: /* pseudo_column */
    case 419: /* column_reference */
    case 420: /* function_expression */
    case 421: /* case_when_expression */
    case 426: /* star_func_para */
    case 428: /* case_when_else_opt */
    case 429: /* common_expression */
    case 430: /* when_then_expr */
    case 431: /* predicate */
    case 434: /* in_predicate_value */
    case 435: /* boolean_value_expression */
    case 436: /* boolean_primary */
    case 437: /* from_clause_opt */
    case 438: /* table_reference_list */
    case 439: /* table_reference */
    case 440: /* table_primary */
    case 441: /* joined_table */
    case 443: /* subquery */
    case 444: /* parenthesized_joined_table */
    case 446: /* search_condition */
    case 447: /* query_specification */
    case 451: /* range_opt */
    case 452: /* every_opt */
    case 453: /* fill_opt */
    case 454: /* twindow_clause_opt */
    case 456: /* having_clause_opt */
    case 457: /* select_item */
    case 459: /* partition_item */
    case 462: /* query_expression */
    case 463: /* query_simple */
    case 465: /* slimit_clause_opt */
    case 466: /* limit_clause_opt */
    case 467: /* union_query_expression */
    case 468: /* query_simple_or_subquery */
    case 470: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy828)); 
}
      break;
    case 330: /* account_options */
    case 331: /* alter_account_options */
    case 333: /* alter_account_option */
    case 348: /* speed_opt */
    case 403: /* bufsize_opt */
{
 
}
      break;
    case 334: /* user_name */
    case 337: /* priv_level */
    case 340: /* db_name */
    case 341: /* topic_name */
    case 342: /* dnode_endpoint */
    case 365: /* column_name */
    case 373: /* table_name */
    case 380: /* function_name */
    case 388: /* column_alias */
    case 391: /* index_name */
    case 396: /* sma_func_name */
    case 398: /* cgroup_name */
    case 404: /* language_opt */
    case 405: /* stream_name */
    case 416: /* table_alias */
    case 422: /* star_func */
    case 424: /* noarg_func */
    case 442: /* alias_opt */
{
 
}
      break;
    case 335: /* sysinfo_opt */
{
 
}
      break;
    case 336: /* privileges */
    case 338: /* priv_type_list */
    case 339: /* priv_type */
{
 
}
      break;
    case 343: /* force_opt */
    case 344: /* not_exists_opt */
    case 346: /* exists_opt */
    case 399: /* analyze_opt */
    case 402: /* agg_func_opt */
    case 448: /* set_quantifier_opt */
{
 
}
      break;
    case 351: /* integer_list */
    case 352: /* variable_list */
    case 353: /* retention_list */
    case 357: /* column_def_list */
    case 358: /* tags_def_opt */
    case 360: /* multi_create_clause */
    case 361: /* tags_def */
    case 362: /* multi_drop_clause */
    case 369: /* specific_cols_opt */
    case 370: /* expression_list */
    case 372: /* col_name_list */
    case 375: /* duration_list */
    case 376: /* rollup_func_list */
    case 386: /* tag_list_opt */
    case 392: /* func_list */
    case 407: /* col_list_opt */
    case 408: /* tag_def_or_ref_opt */
    case 411: /* dnode_list */
    case 415: /* literal_list */
    case 423: /* star_func_para_list */
    case 425: /* other_para_list */
    case 427: /* when_then_list */
    case 449: /* select_list */
    case 450: /* partition_by_clause_opt */
    case 455: /* group_by_clause_opt */
    case 458: /* partition_list */
    case 461: /* group_by_list */
    case 464: /* order_by_clause_opt */
    case 469: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy222)); 
}
      break;
    case 354: /* alter_db_option */
    case 377: /* alter_table_option */
{
 
}
      break;
    case 366: /* type_name */
{
 
}
      break;
    case 432: /* compare_op */
    case 433: /* in_op */
{
 
}
      break;
    case 445: /* join_type */
{
 
}
      break;
    case 460: /* fill_mode */
{
 
}
      break;
    case 471: /* ordering_specification_opt */
{
 
}
      break;
    case 472: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  329,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  329,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  330,    0 }, /* (2) account_options ::= */
  {  330,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  330,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  330,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  330,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  330,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  330,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  330,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  330,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  330,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  331,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  331,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  333,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  333,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  333,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  333,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  333,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  333,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  333,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  333,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  333,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  333,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  329,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  329,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  329,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  329,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  329,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  335,    0 }, /* (29) sysinfo_opt ::= */
  {  335,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  329,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  329,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  336,   -1 }, /* (33) privileges ::= ALL */
  {  336,   -1 }, /* (34) privileges ::= priv_type_list */
  {  336,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  338,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  338,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  339,   -1 }, /* (38) priv_type ::= READ */
  {  339,   -1 }, /* (39) priv_type ::= WRITE */
  {  337,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  337,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  337,   -1 }, /* (42) priv_level ::= topic_name */
  {  329,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  329,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  329,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  329,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  329,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  329,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  329,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  329,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  342,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  342,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  342,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  343,    0 }, /* (54) force_opt ::= */
  {  343,   -1 }, /* (55) force_opt ::= FORCE */
  {  329,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  329,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  329,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  329,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  329,   -2 }, /* (68) cmd ::= USE db_name */
  {  329,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  329,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  329,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  329,   -5 }, /* (72) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
  {  344,   -3 }, /* (73) not_exists_opt ::= IF NOT EXISTS */
  {  344,    0 }, /* (74) not_exists_opt ::= */
  {  346,   -2 }, /* (75) exists_opt ::= IF EXISTS */
  {  346,    0 }, /* (76) exists_opt ::= */
  {  345,    0 }, /* (77) db_options ::= */
  {  345,   -3 }, /* (78) db_options ::= db_options BUFFER NK_INTEGER */
  {  345,   -3 }, /* (79) db_options ::= db_options CACHEMODEL NK_STRING */
  {  345,   -3 }, /* (80) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  345,   -3 }, /* (81) db_options ::= db_options COMP NK_INTEGER */
  {  345,   -3 }, /* (82) db_options ::= db_options DURATION NK_INTEGER */
  {  345,   -3 }, /* (83) db_options ::= db_options DURATION NK_VARIABLE */
  {  345,   -3 }, /* (84) db_options ::= db_options MAXROWS NK_INTEGER */
  {  345,   -3 }, /* (85) db_options ::= db_options MINROWS NK_INTEGER */
  {  345,   -3 }, /* (86) db_options ::= db_options KEEP integer_list */
  {  345,   -3 }, /* (87) db_options ::= db_options KEEP variable_list */
  {  345,   -3 }, /* (88) db_options ::= db_options PAGES NK_INTEGER */
  {  345,   -3 }, /* (89) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  345,   -3 }, /* (90) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  345,   -3 }, /* (91) db_options ::= db_options PRECISION NK_STRING */
  {  345,   -3 }, /* (92) db_options ::= db_options REPLICA NK_INTEGER */
  {  345,   -3 }, /* (93) db_options ::= db_options VGROUPS NK_INTEGER */
  {  345,   -3 }, /* (94) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  345,   -3 }, /* (95) db_options ::= db_options RETENTIONS retention_list */
  {  345,   -3 }, /* (96) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  345,   -3 }, /* (97) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  345,   -3 }, /* (98) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  345,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  345,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  345,   -3 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  345,   -4 }, /* (102) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  345,   -3 }, /* (103) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  345,   -3 }, /* (104) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  345,   -3 }, /* (105) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  345,   -3 }, /* (106) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  345,   -3 }, /* (107) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  347,   -1 }, /* (108) alter_db_options ::= alter_db_option */
  {  347,   -2 }, /* (109) alter_db_options ::= alter_db_options alter_db_option */
  {  354,   -2 }, /* (110) alter_db_option ::= BUFFER NK_INTEGER */
  {  354,   -2 }, /* (111) alter_db_option ::= CACHEMODEL NK_STRING */
  {  354,   -2 }, /* (112) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  354,   -2 }, /* (113) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  354,   -2 }, /* (114) alter_db_option ::= KEEP integer_list */
  {  354,   -2 }, /* (115) alter_db_option ::= KEEP variable_list */
  {  354,   -2 }, /* (116) alter_db_option ::= PAGES NK_INTEGER */
  {  354,   -2 }, /* (117) alter_db_option ::= REPLICA NK_INTEGER */
  {  354,   -2 }, /* (118) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  354,   -2 }, /* (119) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  354,   -2 }, /* (120) alter_db_option ::= MINROWS NK_INTEGER */
  {  354,   -2 }, /* (121) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
  {  354,   -3 }, /* (122) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  354,   -2 }, /* (123) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
  {  354,   -3 }, /* (124) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  351,   -1 }, /* (125) integer_list ::= NK_INTEGER */
  {  351,   -3 }, /* (126) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  352,   -1 }, /* (127) variable_list ::= NK_VARIABLE */
  {  352,   -3 }, /* (128) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  353,   -1 }, /* (129) retention_list ::= retention */
  {  353,   -3 }, /* (130) retention_list ::= retention_list NK_COMMA retention */
  {  355,   -3 }, /* (131) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  348,    0 }, /* (132) speed_opt ::= */
  {  348,   -2 }, /* (133) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  349,    0 }, /* (134) start_opt ::= */
  {  349,   -3 }, /* (135) start_opt ::= START WITH NK_INTEGER */
  {  349,   -3 }, /* (136) start_opt ::= START WITH NK_STRING */
  {  349,   -4 }, /* (137) start_opt ::= START WITH TIMESTAMP NK_STRING */
  {  350,    0 }, /* (138) end_opt ::= */
  {  350,   -3 }, /* (139) end_opt ::= END WITH NK_INTEGER */
  {  350,   -3 }, /* (140) end_opt ::= END WITH NK_STRING */
  {  350,   -4 }, /* (141) end_opt ::= END WITH TIMESTAMP NK_STRING */
  {  329,   -9 }, /* (142) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  329,   -3 }, /* (143) cmd ::= CREATE TABLE multi_create_clause */
  {  329,   -9 }, /* (144) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  329,   -3 }, /* (145) cmd ::= DROP TABLE multi_drop_clause */
  {  329,   -4 }, /* (146) cmd ::= DROP STABLE exists_opt full_table_name */
  {  329,   -3 }, /* (147) cmd ::= ALTER TABLE alter_table_clause */
  {  329,   -3 }, /* (148) cmd ::= ALTER STABLE alter_table_clause */
  {  363,   -2 }, /* (149) alter_table_clause ::= full_table_name alter_table_options */
  {  363,   -5 }, /* (150) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  363,   -4 }, /* (151) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  363,   -5 }, /* (152) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  363,   -5 }, /* (153) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  363,   -5 }, /* (154) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  363,   -4 }, /* (155) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  363,   -5 }, /* (156) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  363,   -5 }, /* (157) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  363,   -6 }, /* (158) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  360,   -1 }, /* (159) multi_create_clause ::= create_subtable_clause */
  {  360,   -2 }, /* (160) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  368,  -10 }, /* (161) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  362,   -1 }, /* (162) multi_drop_clause ::= drop_table_clause */
  {  362,   -3 }, /* (163) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
  {  371,   -2 }, /* (164) drop_table_clause ::= exists_opt full_table_name */
  {  369,    0 }, /* (165) specific_cols_opt ::= */
  {  369,   -3 }, /* (166) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  356,   -1 }, /* (167) full_table_name ::= table_name */
  {  356,   -3 }, /* (168) full_table_name ::= db_name NK_DOT table_name */
  {  357,   -1 }, /* (169) column_def_list ::= column_def */
  {  357,   -3 }, /* (170) column_def_list ::= column_def_list NK_COMMA column_def */
  {  374,   -2 }, /* (171) column_def ::= column_name type_name */
  {  374,   -4 }, /* (172) column_def ::= column_name type_name COMMENT NK_STRING */
  {  366,   -1 }, /* (173) type_name ::= BOOL */
  {  366,   -1 }, /* (174) type_name ::= TINYINT */
  {  366,   -1 }, /* (175) type_name ::= SMALLINT */
  {  366,   -1 }, /* (176) type_name ::= INT */
  {  366,   -1 }, /* (177) type_name ::= INTEGER */
  {  366,   -1 }, /* (178) type_name ::= BIGINT */
  {  366,   -1 }, /* (179) type_name ::= FLOAT */
  {  366,   -1 }, /* (180) type_name ::= DOUBLE */
  {  366,   -4 }, /* (181) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  366,   -1 }, /* (182) type_name ::= TIMESTAMP */
  {  366,   -4 }, /* (183) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  366,   -2 }, /* (184) type_name ::= TINYINT UNSIGNED */
  {  366,   -2 }, /* (185) type_name ::= SMALLINT UNSIGNED */
  {  366,   -2 }, /* (186) type_name ::= INT UNSIGNED */
  {  366,   -2 }, /* (187) type_name ::= BIGINT UNSIGNED */
  {  366,   -1 }, /* (188) type_name ::= JSON */
  {  366,   -4 }, /* (189) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  366,   -1 }, /* (190) type_name ::= MEDIUMBLOB */
  {  366,   -1 }, /* (191) type_name ::= BLOB */
  {  366,   -4 }, /* (192) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  366,   -1 }, /* (193) type_name ::= DECIMAL */
  {  366,   -4 }, /* (194) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  366,   -6 }, /* (195) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  358,    0 }, /* (196) tags_def_opt ::= */
  {  358,   -1 }, /* (197) tags_def_opt ::= tags_def */
  {  361,   -4 }, /* (198) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  359,    0 }, /* (199) table_options ::= */
  {  359,   -3 }, /* (200) table_options ::= table_options COMMENT NK_STRING */
  {  359,   -3 }, /* (201) table_options ::= table_options MAX_DELAY duration_list */
  {  359,   -3 }, /* (202) table_options ::= table_options WATERMARK duration_list */
  {  359,   -5 }, /* (203) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  359,   -3 }, /* (204) table_options ::= table_options TTL NK_INTEGER */
  {  359,   -5 }, /* (205) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  359,   -3 }, /* (206) table_options ::= table_options DELETE_MARK duration_list */
  {  364,   -1 }, /* (207) alter_table_options ::= alter_table_option */
  {  364,   -2 }, /* (208) alter_table_options ::= alter_table_options alter_table_option */
  {  377,   -2 }, /* (209) alter_table_option ::= COMMENT NK_STRING */
  {  377,   -2 }, /* (210) alter_table_option ::= TTL NK_INTEGER */
  {  375,   -1 }, /* (211) duration_list ::= duration_literal */
  {  375,   -3 }, /* (212) duration_list ::= duration_list NK_COMMA duration_literal */
  {  376,   -1 }, /* (213) rollup_func_list ::= rollup_func_name */
  {  376,   -3 }, /* (214) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  379,   -1 }, /* (215) rollup_func_name ::= function_name */
  {  379,   -1 }, /* (216) rollup_func_name ::= FIRST */
  {  379,   -1 }, /* (217) rollup_func_name ::= LAST */
  {  372,   -1 }, /* (218) col_name_list ::= col_name */
  {  372,   -3 }, /* (219) col_name_list ::= col_name_list NK_COMMA col_name */
  {  381,   -1 }, /* (220) col_name ::= column_name */
  {  329,   -2 }, /* (221) cmd ::= SHOW DNODES */
  {  329,   -2 }, /* (222) cmd ::= SHOW USERS */
  {  329,   -3 }, /* (223) cmd ::= SHOW USER PRIVILEGES */
  {  329,   -2 }, /* (224) cmd ::= SHOW DATABASES */
  {  329,   -4 }, /* (225) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  329,   -4 }, /* (226) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  329,   -3 }, /* (227) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  329,   -2 }, /* (228) cmd ::= SHOW MNODES */
  {  329,   -2 }, /* (229) cmd ::= SHOW QNODES */
  {  329,   -2 }, /* (230) cmd ::= SHOW FUNCTIONS */
  {  329,   -5 }, /* (231) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  329,   -2 }, /* (232) cmd ::= SHOW STREAMS */
  {  329,   -2 }, /* (233) cmd ::= SHOW ACCOUNTS */
  {  329,   -2 }, /* (234) cmd ::= SHOW APPS */
  {  329,   -2 }, /* (235) cmd ::= SHOW CONNECTIONS */
  {  329,   -2 }, /* (236) cmd ::= SHOW LICENCES */
  {  329,   -2 }, /* (237) cmd ::= SHOW GRANTS */
  {  329,   -4 }, /* (238) cmd ::= SHOW CREATE DATABASE db_name */
  {  329,   -4 }, /* (239) cmd ::= SHOW CREATE TABLE full_table_name */
  {  329,   -4 }, /* (240) cmd ::= SHOW CREATE STABLE full_table_name */
  {  329,   -2 }, /* (241) cmd ::= SHOW QUERIES */
  {  329,   -2 }, /* (242) cmd ::= SHOW SCORES */
  {  329,   -2 }, /* (243) cmd ::= SHOW TOPICS */
  {  329,   -2 }, /* (244) cmd ::= SHOW VARIABLES */
  {  329,   -3 }, /* (245) cmd ::= SHOW CLUSTER VARIABLES */
  {  329,   -3 }, /* (246) cmd ::= SHOW LOCAL VARIABLES */
  {  329,   -5 }, /* (247) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  329,   -2 }, /* (248) cmd ::= SHOW BNODES */
  {  329,   -2 }, /* (249) cmd ::= SHOW SNODES */
  {  329,   -2 }, /* (250) cmd ::= SHOW CLUSTER */
  {  329,   -2 }, /* (251) cmd ::= SHOW TRANSACTIONS */
  {  329,   -4 }, /* (252) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  329,   -2 }, /* (253) cmd ::= SHOW CONSUMERS */
  {  329,   -2 }, /* (254) cmd ::= SHOW SUBSCRIPTIONS */
  {  329,   -5 }, /* (255) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  329,   -7 }, /* (256) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  329,   -3 }, /* (257) cmd ::= SHOW VNODES NK_INTEGER */
  {  329,   -3 }, /* (258) cmd ::= SHOW VNODES NK_STRING */
  {  329,   -3 }, /* (259) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  329,   -3 }, /* (260) cmd ::= SHOW CLUSTER ALIVE */
  {  382,    0 }, /* (261) db_name_cond_opt ::= */
  {  382,   -2 }, /* (262) db_name_cond_opt ::= db_name NK_DOT */
  {  383,    0 }, /* (263) like_pattern_opt ::= */
  {  383,   -2 }, /* (264) like_pattern_opt ::= LIKE NK_STRING */
  {  384,   -1 }, /* (265) table_name_cond ::= table_name */
  {  385,    0 }, /* (266) from_db_opt ::= */
  {  385,   -2 }, /* (267) from_db_opt ::= FROM db_name */
  {  386,    0 }, /* (268) tag_list_opt ::= */
  {  386,   -1 }, /* (269) tag_list_opt ::= tag_item */
  {  386,   -3 }, /* (270) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  387,   -1 }, /* (271) tag_item ::= TBNAME */
  {  387,   -1 }, /* (272) tag_item ::= QTAGS */
  {  387,   -1 }, /* (273) tag_item ::= column_name */
  {  387,   -2 }, /* (274) tag_item ::= column_name column_alias */
  {  387,   -3 }, /* (275) tag_item ::= column_name AS column_alias */
  {  329,   -8 }, /* (276) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  329,   -9 }, /* (277) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  329,   -4 }, /* (278) cmd ::= DROP INDEX exists_opt full_index_name */
  {  389,   -1 }, /* (279) full_index_name ::= index_name */
  {  389,   -3 }, /* (280) full_index_name ::= db_name NK_DOT index_name */
  {  390,  -10 }, /* (281) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  390,  -12 }, /* (282) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  392,   -1 }, /* (283) func_list ::= func */
  {  392,   -3 }, /* (284) func_list ::= func_list NK_COMMA func */
  {  395,   -4 }, /* (285) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  396,   -1 }, /* (286) sma_func_name ::= function_name */
  {  396,   -1 }, /* (287) sma_func_name ::= COUNT */
  {  396,   -1 }, /* (288) sma_func_name ::= FIRST */
  {  396,   -1 }, /* (289) sma_func_name ::= LAST */
  {  396,   -1 }, /* (290) sma_func_name ::= LAST_ROW */
  {  394,    0 }, /* (291) sma_stream_opt ::= */
  {  394,   -3 }, /* (292) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  394,   -3 }, /* (293) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  394,   -3 }, /* (294) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  329,   -6 }, /* (295) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  329,   -7 }, /* (296) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  329,   -9 }, /* (297) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  329,   -7 }, /* (298) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  329,   -9 }, /* (299) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  329,   -4 }, /* (300) cmd ::= DROP TOPIC exists_opt topic_name */
  {  329,   -7 }, /* (301) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  329,   -2 }, /* (302) cmd ::= DESC full_table_name */
  {  329,   -2 }, /* (303) cmd ::= DESCRIBE full_table_name */
  {  329,   -3 }, /* (304) cmd ::= RESET QUERY CACHE */
  {  329,   -4 }, /* (305) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  329,   -4 }, /* (306) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
  {  399,    0 }, /* (307) analyze_opt ::= */
  {  399,   -1 }, /* (308) analyze_opt ::= ANALYZE */
  {  400,    0 }, /* (309) explain_options ::= */
  {  400,   -3 }, /* (310) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  400,   -3 }, /* (311) explain_options ::= explain_options RATIO NK_FLOAT */
  {  329,  -11 }, /* (312) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
  {  329,   -4 }, /* (313) cmd ::= DROP FUNCTION exists_opt function_name */
  {  402,    0 }, /* (314) agg_func_opt ::= */
  {  402,   -1 }, /* (315) agg_func_opt ::= AGGREGATE */
  {  403,    0 }, /* (316) bufsize_opt ::= */
  {  403,   -2 }, /* (317) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  404,    0 }, /* (318) language_opt ::= */
  {  404,   -2 }, /* (319) language_opt ::= LANGUAGE NK_STRING */
  {  329,  -12 }, /* (320) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  329,   -4 }, /* (321) cmd ::= DROP STREAM exists_opt stream_name */
  {  407,    0 }, /* (322) col_list_opt ::= */
  {  407,   -3 }, /* (323) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  408,    0 }, /* (324) tag_def_or_ref_opt ::= */
  {  408,   -1 }, /* (325) tag_def_or_ref_opt ::= tags_def */
  {  408,   -4 }, /* (326) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  406,    0 }, /* (327) stream_options ::= */
  {  406,   -3 }, /* (328) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  406,   -3 }, /* (329) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  406,   -4 }, /* (330) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  406,   -3 }, /* (331) stream_options ::= stream_options WATERMARK duration_literal */
  {  406,   -4 }, /* (332) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  406,   -3 }, /* (333) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  406,   -3 }, /* (334) stream_options ::= stream_options DELETE_MARK duration_literal */
  {  406,   -4 }, /* (335) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
  {  409,    0 }, /* (336) subtable_opt ::= */
  {  409,   -4 }, /* (337) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  329,   -3 }, /* (338) cmd ::= KILL CONNECTION NK_INTEGER */
  {  329,   -3 }, /* (339) cmd ::= KILL QUERY NK_STRING */
  {  329,   -3 }, /* (340) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  329,   -2 }, /* (341) cmd ::= BALANCE VGROUP */
  {  329,   -4 }, /* (342) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  329,   -4 }, /* (343) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  329,   -3 }, /* (344) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  411,   -2 }, /* (345) dnode_list ::= DNODE NK_INTEGER */
  {  411,   -3 }, /* (346) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  329,   -4 }, /* (347) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  329,   -1 }, /* (348) cmd ::= query_or_subquery */
  {  329,   -1 }, /* (349) cmd ::= insert_query */
  {  401,   -7 }, /* (350) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  401,   -4 }, /* (351) insert_query ::= INSERT INTO full_table_name query_or_subquery */
  {  332,   -1 }, /* (352) literal ::= NK_INTEGER */
  {  332,   -1 }, /* (353) literal ::= NK_FLOAT */
  {  332,   -1 }, /* (354) literal ::= NK_STRING */
  {  332,   -1 }, /* (355) literal ::= NK_BOOL */
  {  332,   -2 }, /* (356) literal ::= TIMESTAMP NK_STRING */
  {  332,   -1 }, /* (357) literal ::= duration_literal */
  {  332,   -1 }, /* (358) literal ::= NULL */
  {  332,   -1 }, /* (359) literal ::= NK_QUESTION */
  {  378,   -1 }, /* (360) duration_literal ::= NK_VARIABLE */
  {  413,   -1 }, /* (361) signed ::= NK_INTEGER */
  {  413,   -2 }, /* (362) signed ::= NK_PLUS NK_INTEGER */
  {  413,   -2 }, /* (363) signed ::= NK_MINUS NK_INTEGER */
  {  413,   -1 }, /* (364) signed ::= NK_FLOAT */
  {  413,   -2 }, /* (365) signed ::= NK_PLUS NK_FLOAT */
  {  413,   -2 }, /* (366) signed ::= NK_MINUS NK_FLOAT */
  {  367,   -1 }, /* (367) signed_literal ::= signed */
  {  367,   -1 }, /* (368) signed_literal ::= NK_STRING */
  {  367,   -1 }, /* (369) signed_literal ::= NK_BOOL */
  {  367,   -2 }, /* (370) signed_literal ::= TIMESTAMP NK_STRING */
  {  367,   -1 }, /* (371) signed_literal ::= duration_literal */
  {  367,   -1 }, /* (372) signed_literal ::= NULL */
  {  367,   -1 }, /* (373) signed_literal ::= literal_func */
  {  367,   -1 }, /* (374) signed_literal ::= NK_QUESTION */
  {  415,   -1 }, /* (375) literal_list ::= signed_literal */
  {  415,   -3 }, /* (376) literal_list ::= literal_list NK_COMMA signed_literal */
  {  340,   -1 }, /* (377) db_name ::= NK_ID */
  {  373,   -1 }, /* (378) table_name ::= NK_ID */
  {  365,   -1 }, /* (379) column_name ::= NK_ID */
  {  380,   -1 }, /* (380) function_name ::= NK_ID */
  {  416,   -1 }, /* (381) table_alias ::= NK_ID */
  {  388,   -1 }, /* (382) column_alias ::= NK_ID */
  {  334,   -1 }, /* (383) user_name ::= NK_ID */
  {  341,   -1 }, /* (384) topic_name ::= NK_ID */
  {  405,   -1 }, /* (385) stream_name ::= NK_ID */
  {  398,   -1 }, /* (386) cgroup_name ::= NK_ID */
  {  391,   -1 }, /* (387) index_name ::= NK_ID */
  {  417,   -1 }, /* (388) expr_or_subquery ::= expression */
  {  410,   -1 }, /* (389) expression ::= literal */
  {  410,   -1 }, /* (390) expression ::= pseudo_column */
  {  410,   -1 }, /* (391) expression ::= column_reference */
  {  410,   -1 }, /* (392) expression ::= function_expression */
  {  410,   -1 }, /* (393) expression ::= case_when_expression */
  {  410,   -3 }, /* (394) expression ::= NK_LP expression NK_RP */
  {  410,   -2 }, /* (395) expression ::= NK_PLUS expr_or_subquery */
  {  410,   -2 }, /* (396) expression ::= NK_MINUS expr_or_subquery */
  {  410,   -3 }, /* (397) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  410,   -3 }, /* (398) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  410,   -3 }, /* (399) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  410,   -3 }, /* (400) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  410,   -3 }, /* (401) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  410,   -3 }, /* (402) expression ::= column_reference NK_ARROW NK_STRING */
  {  410,   -3 }, /* (403) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  410,   -3 }, /* (404) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  370,   -1 }, /* (405) expression_list ::= expr_or_subquery */
  {  370,   -3 }, /* (406) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  419,   -1 }, /* (407) column_reference ::= column_name */
  {  419,   -3 }, /* (408) column_reference ::= table_name NK_DOT column_name */
  {  418,   -1 }, /* (409) pseudo_column ::= ROWTS */
  {  418,   -1 }, /* (410) pseudo_column ::= TBNAME */
  {  418,   -3 }, /* (411) pseudo_column ::= table_name NK_DOT TBNAME */
  {  418,   -1 }, /* (412) pseudo_column ::= QSTART */
  {  418,   -1 }, /* (413) pseudo_column ::= QEND */
  {  418,   -1 }, /* (414) pseudo_column ::= QDURATION */
  {  418,   -1 }, /* (415) pseudo_column ::= WSTART */
  {  418,   -1 }, /* (416) pseudo_column ::= WEND */
  {  418,   -1 }, /* (417) pseudo_column ::= WDURATION */
  {  418,   -1 }, /* (418) pseudo_column ::= IROWTS */
  {  418,   -1 }, /* (419) pseudo_column ::= ISFILLED */
  {  418,   -1 }, /* (420) pseudo_column ::= QTAGS */
  {  420,   -4 }, /* (421) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  420,   -4 }, /* (422) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  420,   -6 }, /* (423) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  420,   -1 }, /* (424) function_expression ::= literal_func */
  {  414,   -3 }, /* (425) literal_func ::= noarg_func NK_LP NK_RP */
  {  414,   -1 }, /* (426) literal_func ::= NOW */
  {  424,   -1 }, /* (427) noarg_func ::= NOW */
  {  424,   -1 }, /* (428) noarg_func ::= TODAY */
  {  424,   -1 }, /* (429) noarg_func ::= TIMEZONE */
  {  424,   -1 }, /* (430) noarg_func ::= DATABASE */
  {  424,   -1 }, /* (431) noarg_func ::= CLIENT_VERSION */
  {  424,   -1 }, /* (432) noarg_func ::= SERVER_VERSION */
  {  424,   -1 }, /* (433) noarg_func ::= SERVER_STATUS */
  {  424,   -1 }, /* (434) noarg_func ::= CURRENT_USER */
  {  424,   -1 }, /* (435) noarg_func ::= USER */
  {  422,   -1 }, /* (436) star_func ::= COUNT */
  {  422,   -1 }, /* (437) star_func ::= FIRST */
  {  422,   -1 }, /* (438) star_func ::= LAST */
  {  422,   -1 }, /* (439) star_func ::= LAST_ROW */
  {  423,   -1 }, /* (440) star_func_para_list ::= NK_STAR */
  {  423,   -1 }, /* (441) star_func_para_list ::= other_para_list */
  {  425,   -1 }, /* (442) other_para_list ::= star_func_para */
  {  425,   -3 }, /* (443) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  426,   -1 }, /* (444) star_func_para ::= expr_or_subquery */
  {  426,   -3 }, /* (445) star_func_para ::= table_name NK_DOT NK_STAR */
  {  421,   -4 }, /* (446) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  421,   -5 }, /* (447) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  427,   -1 }, /* (448) when_then_list ::= when_then_expr */
  {  427,   -2 }, /* (449) when_then_list ::= when_then_list when_then_expr */
  {  430,   -4 }, /* (450) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  428,    0 }, /* (451) case_when_else_opt ::= */
  {  428,   -2 }, /* (452) case_when_else_opt ::= ELSE common_expression */
  {  431,   -3 }, /* (453) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  431,   -5 }, /* (454) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  431,   -6 }, /* (455) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  431,   -3 }, /* (456) predicate ::= expr_or_subquery IS NULL */
  {  431,   -4 }, /* (457) predicate ::= expr_or_subquery IS NOT NULL */
  {  431,   -3 }, /* (458) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  432,   -1 }, /* (459) compare_op ::= NK_LT */
  {  432,   -1 }, /* (460) compare_op ::= NK_GT */
  {  432,   -1 }, /* (461) compare_op ::= NK_LE */
  {  432,   -1 }, /* (462) compare_op ::= NK_GE */
  {  432,   -1 }, /* (463) compare_op ::= NK_NE */
  {  432,   -1 }, /* (464) compare_op ::= NK_EQ */
  {  432,   -1 }, /* (465) compare_op ::= LIKE */
  {  432,   -2 }, /* (466) compare_op ::= NOT LIKE */
  {  432,   -1 }, /* (467) compare_op ::= MATCH */
  {  432,   -1 }, /* (468) compare_op ::= NMATCH */
  {  432,   -1 }, /* (469) compare_op ::= CONTAINS */
  {  433,   -1 }, /* (470) in_op ::= IN */
  {  433,   -2 }, /* (471) in_op ::= NOT IN */
  {  434,   -3 }, /* (472) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  435,   -1 }, /* (473) boolean_value_expression ::= boolean_primary */
  {  435,   -2 }, /* (474) boolean_value_expression ::= NOT boolean_primary */
  {  435,   -3 }, /* (475) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  435,   -3 }, /* (476) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  436,   -1 }, /* (477) boolean_primary ::= predicate */
  {  436,   -3 }, /* (478) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  429,   -1 }, /* (479) common_expression ::= expr_or_subquery */
  {  429,   -1 }, /* (480) common_expression ::= boolean_value_expression */
  {  437,    0 }, /* (481) from_clause_opt ::= */
  {  437,   -2 }, /* (482) from_clause_opt ::= FROM table_reference_list */
  {  438,   -1 }, /* (483) table_reference_list ::= table_reference */
  {  438,   -3 }, /* (484) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  439,   -1 }, /* (485) table_reference ::= table_primary */
  {  439,   -1 }, /* (486) table_reference ::= joined_table */
  {  440,   -2 }, /* (487) table_primary ::= table_name alias_opt */
  {  440,   -4 }, /* (488) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  440,   -2 }, /* (489) table_primary ::= subquery alias_opt */
  {  440,   -1 }, /* (490) table_primary ::= parenthesized_joined_table */
  {  442,    0 }, /* (491) alias_opt ::= */
  {  442,   -1 }, /* (492) alias_opt ::= table_alias */
  {  442,   -2 }, /* (493) alias_opt ::= AS table_alias */
  {  444,   -3 }, /* (494) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  444,   -3 }, /* (495) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  441,   -6 }, /* (496) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  445,    0 }, /* (497) join_type ::= */
  {  445,   -1 }, /* (498) join_type ::= INNER */
  {  447,  -12 }, /* (499) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  448,    0 }, /* (500) set_quantifier_opt ::= */
  {  448,   -1 }, /* (501) set_quantifier_opt ::= DISTINCT */
  {  448,   -1 }, /* (502) set_quantifier_opt ::= ALL */
  {  449,   -1 }, /* (503) select_list ::= select_item */
  {  449,   -3 }, /* (504) select_list ::= select_list NK_COMMA select_item */
  {  457,   -1 }, /* (505) select_item ::= NK_STAR */
  {  457,   -1 }, /* (506) select_item ::= common_expression */
  {  457,   -2 }, /* (507) select_item ::= common_expression column_alias */
  {  457,   -3 }, /* (508) select_item ::= common_expression AS column_alias */
  {  457,   -3 }, /* (509) select_item ::= table_name NK_DOT NK_STAR */
  {  412,    0 }, /* (510) where_clause_opt ::= */
  {  412,   -2 }, /* (511) where_clause_opt ::= WHERE search_condition */
  {  450,    0 }, /* (512) partition_by_clause_opt ::= */
  {  450,   -3 }, /* (513) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  458,   -1 }, /* (514) partition_list ::= partition_item */
  {  458,   -3 }, /* (515) partition_list ::= partition_list NK_COMMA partition_item */
  {  459,   -1 }, /* (516) partition_item ::= expr_or_subquery */
  {  459,   -2 }, /* (517) partition_item ::= expr_or_subquery column_alias */
  {  459,   -3 }, /* (518) partition_item ::= expr_or_subquery AS column_alias */
  {  454,    0 }, /* (519) twindow_clause_opt ::= */
  {  454,   -6 }, /* (520) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  454,   -4 }, /* (521) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  454,   -6 }, /* (522) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  454,   -8 }, /* (523) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  454,   -7 }, /* (524) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  393,    0 }, /* (525) sliding_opt ::= */
  {  393,   -4 }, /* (526) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  453,    0 }, /* (527) fill_opt ::= */
  {  453,   -4 }, /* (528) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  453,   -6 }, /* (529) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  453,   -6 }, /* (530) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
  {  460,   -1 }, /* (531) fill_mode ::= NONE */
  {  460,   -1 }, /* (532) fill_mode ::= PREV */
  {  460,   -1 }, /* (533) fill_mode ::= NULL */
  {  460,   -1 }, /* (534) fill_mode ::= NULL_F */
  {  460,   -1 }, /* (535) fill_mode ::= LINEAR */
  {  460,   -1 }, /* (536) fill_mode ::= NEXT */
  {  455,    0 }, /* (537) group_by_clause_opt ::= */
  {  455,   -3 }, /* (538) group_by_clause_opt ::= GROUP BY group_by_list */
  {  461,   -1 }, /* (539) group_by_list ::= expr_or_subquery */
  {  461,   -3 }, /* (540) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  456,    0 }, /* (541) having_clause_opt ::= */
  {  456,   -2 }, /* (542) having_clause_opt ::= HAVING search_condition */
  {  451,    0 }, /* (543) range_opt ::= */
  {  451,   -6 }, /* (544) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  452,    0 }, /* (545) every_opt ::= */
  {  452,   -4 }, /* (546) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  462,   -4 }, /* (547) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  463,   -1 }, /* (548) query_simple ::= query_specification */
  {  463,   -1 }, /* (549) query_simple ::= union_query_expression */
  {  467,   -4 }, /* (550) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  467,   -3 }, /* (551) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  468,   -1 }, /* (552) query_simple_or_subquery ::= query_simple */
  {  468,   -1 }, /* (553) query_simple_or_subquery ::= subquery */
  {  397,   -1 }, /* (554) query_or_subquery ::= query_expression */
  {  397,   -1 }, /* (555) query_or_subquery ::= subquery */
  {  464,    0 }, /* (556) order_by_clause_opt ::= */
  {  464,   -3 }, /* (557) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  465,    0 }, /* (558) slimit_clause_opt ::= */
  {  465,   -2 }, /* (559) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  465,   -4 }, /* (560) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  465,   -4 }, /* (561) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  466,    0 }, /* (562) limit_clause_opt ::= */
  {  466,   -2 }, /* (563) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  466,   -4 }, /* (564) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  466,   -4 }, /* (565) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  443,   -3 }, /* (566) subquery ::= NK_LP query_expression NK_RP */
  {  443,   -3 }, /* (567) subquery ::= NK_LP subquery NK_RP */
  {  446,   -1 }, /* (568) search_condition ::= common_expression */
  {  469,   -1 }, /* (569) sort_specification_list ::= sort_specification */
  {  469,   -3 }, /* (570) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  470,   -3 }, /* (571) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  471,    0 }, /* (572) ordering_specification_opt ::= */
  {  471,   -1 }, /* (573) ordering_specification_opt ::= ASC */
  {  471,   -1 }, /* (574) ordering_specification_opt ::= DESC */
  {  472,    0 }, /* (575) null_ordering_opt ::= */
  {  472,   -2 }, /* (576) null_ordering_opt ::= NULLS FIRST */
  {  472,   -2 }, /* (577) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,330,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,331,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,330,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,332,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,333,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,331,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,333,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,332,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy63, &yymsp[-1].minor.yy0, yymsp[0].minor.yy707); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy63, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy63, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy63, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy63); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy707 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy707 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy393, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy393, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy393 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy393 = yymsp[0].minor.yy393; }
  yymsp[0].minor.yy393 = yylhsminor.yy393;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy393 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy393 = yymsp[-2].minor.yy393 | yymsp[0].minor.yy393; }
  yymsp[-2].minor.yy393 = yylhsminor.yy393;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy393 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy393 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy63 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy63 = yylhsminor.yy63;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy63 = yymsp[-2].minor.yy63; }
  yymsp[-2].minor.yy63 = yylhsminor.yy63;
        break;
      case 42: /* priv_level ::= topic_name */
      case 286: /* sma_func_name ::= function_name */ yytestcase(yyruleno==286);
      case 492: /* alias_opt ::= table_alias */ yytestcase(yyruleno==492);
{ yylhsminor.yy63 = yymsp[0].minor.yy63; }
  yymsp[0].minor.yy63 = yylhsminor.yy63;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy63, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy669); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy63, yymsp[0].minor.yy669); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 287: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==287);
      case 288: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==288);
      case 289: /* sma_func_name ::= LAST */ yytestcase(yyruleno==289);
      case 290: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==290);
      case 377: /* db_name ::= NK_ID */ yytestcase(yyruleno==377);
      case 378: /* table_name ::= NK_ID */ yytestcase(yyruleno==378);
      case 379: /* column_name ::= NK_ID */ yytestcase(yyruleno==379);
      case 380: /* function_name ::= NK_ID */ yytestcase(yyruleno==380);
      case 381: /* table_alias ::= NK_ID */ yytestcase(yyruleno==381);
      case 382: /* column_alias ::= NK_ID */ yytestcase(yyruleno==382);
      case 383: /* user_name ::= NK_ID */ yytestcase(yyruleno==383);
      case 384: /* topic_name ::= NK_ID */ yytestcase(yyruleno==384);
      case 385: /* stream_name ::= NK_ID */ yytestcase(yyruleno==385);
      case 386: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==386);
      case 387: /* index_name ::= NK_ID */ yytestcase(yyruleno==387);
      case 427: /* noarg_func ::= NOW */ yytestcase(yyruleno==427);
      case 428: /* noarg_func ::= TODAY */ yytestcase(yyruleno==428);
      case 429: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==429);
      case 430: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==430);
      case 431: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==431);
      case 432: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==432);
      case 433: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==433);
      case 434: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==434);
      case 435: /* noarg_func ::= USER */ yytestcase(yyruleno==435);
      case 436: /* star_func ::= COUNT */ yytestcase(yyruleno==436);
      case 437: /* star_func ::= FIRST */ yytestcase(yyruleno==437);
      case 438: /* star_func ::= LAST */ yytestcase(yyruleno==438);
      case 439: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==439);
{ yylhsminor.yy63 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy63 = yylhsminor.yy63;
        break;
      case 54: /* force_opt ::= */
      case 74: /* not_exists_opt ::= */ yytestcase(yyruleno==74);
      case 76: /* exists_opt ::= */ yytestcase(yyruleno==76);
      case 307: /* analyze_opt ::= */ yytestcase(yyruleno==307);
      case 314: /* agg_func_opt ::= */ yytestcase(yyruleno==314);
      case 500: /* set_quantifier_opt ::= */ yytestcase(yyruleno==500);
{ yymsp[1].minor.yy669 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 308: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==308);
      case 315: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==315);
      case 501: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==501);
{ yymsp[0].minor.yy669 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy669, &yymsp[-1].minor.yy63, yymsp[0].minor.yy828); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy669, &yymsp[0].minor.yy63); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy63); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy63, yymsp[0].minor.yy828); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy63); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy63, yymsp[0].minor.yy332); }
        break;
      case 72: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy63, yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 73: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy669 = true; }
        break;
      case 75: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy669 = true; }
        break;
      case 77: /* db_options ::= */
{ yymsp[1].minor.yy828 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 78: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 79: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 80: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 81: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 82: /* db_options ::= db_options DURATION NK_INTEGER */
      case 83: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==83);
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 84: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 85: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 86: /* db_options ::= db_options KEEP integer_list */
      case 87: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==87);
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_KEEP, yymsp[0].minor.yy222); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 88: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 89: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 90: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 91: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 92: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 93: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 94: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 95: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_RETENTIONS, yymsp[0].minor.yy222); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 96: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 97: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 98: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-3].minor.yy828, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-3].minor.yy828, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 103: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 104: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 105: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 106: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 107: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 108: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy828 = createAlterDatabaseOptions(pCxt); yylhsminor.yy828 = setAlterDatabaseOption(pCxt, yylhsminor.yy828, &yymsp[0].minor.yy233); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 109: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy828 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy828, &yymsp[0].minor.yy233); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 110: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy233.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= KEEP integer_list */
      case 115: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==115);
{ yymsp[-1].minor.yy233.type = DB_OPTION_KEEP; yymsp[-1].minor.yy233.pList = yymsp[0].minor.yy222; }
        break;
      case 116: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_PAGES; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_WAL; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* alter_db_option ::= MINROWS NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_MINROWS; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 121: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 122: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy233.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-2].minor.yy233.val = t;
                                                                                  }
        break;
      case 123: /* alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 124: /* alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy233.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-2].minor.yy233.val = t;
                                                                                  }
        break;
      case 125: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy222 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 126: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 346: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==346);
{ yylhsminor.yy222 = addNodeToList(pCxt, yymsp[-2].minor.yy222, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy222 = yylhsminor.yy222;
        break;
      case 127: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy222 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 128: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy222 = addNodeToList(pCxt, yymsp[-2].minor.yy222, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy222 = yylhsminor.yy222;
        break;
      case 129: /* retention_list ::= retention */
      case 159: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==159);
      case 162: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==162);
      case 169: /* column_def_list ::= column_def */ yytestcase(yyruleno==169);
      case 213: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==213);
      case 218: /* col_name_list ::= col_name */ yytestcase(yyruleno==218);
      case 269: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==269);
      case 283: /* func_list ::= func */ yytestcase(yyruleno==283);
      case 375: /* literal_list ::= signed_literal */ yytestcase(yyruleno==375);
      case 442: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==442);
      case 448: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==448);
      case 503: /* select_list ::= select_item */ yytestcase(yyruleno==503);
      case 514: /* partition_list ::= partition_item */ yytestcase(yyruleno==514);
      case 569: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==569);
{ yylhsminor.yy222 = createNodeList(pCxt, yymsp[0].minor.yy828); }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 130: /* retention_list ::= retention_list NK_COMMA retention */
      case 163: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==163);
      case 170: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==170);
      case 214: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==214);
      case 219: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==219);
      case 270: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==270);
      case 284: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==284);
      case 376: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==376);
      case 443: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==443);
      case 504: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==504);
      case 515: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==515);
      case 570: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==570);
{ yylhsminor.yy222 = addNodeToList(pCxt, yymsp[-2].minor.yy222, yymsp[0].minor.yy828); }
  yymsp[-2].minor.yy222 = yylhsminor.yy222;
        break;
      case 131: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy828 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 132: /* speed_opt ::= */
      case 316: /* bufsize_opt ::= */ yytestcase(yyruleno==316);
{ yymsp[1].minor.yy332 = 0; }
        break;
      case 133: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 317: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==317);
{ yymsp[-1].minor.yy332 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 134: /* start_opt ::= */
      case 138: /* end_opt ::= */ yytestcase(yyruleno==138);
      case 263: /* like_pattern_opt ::= */ yytestcase(yyruleno==263);
      case 336: /* subtable_opt ::= */ yytestcase(yyruleno==336);
      case 451: /* case_when_else_opt ::= */ yytestcase(yyruleno==451);
      case 481: /* from_clause_opt ::= */ yytestcase(yyruleno==481);
      case 510: /* where_clause_opt ::= */ yytestcase(yyruleno==510);
      case 519: /* twindow_clause_opt ::= */ yytestcase(yyruleno==519);
      case 525: /* sliding_opt ::= */ yytestcase(yyruleno==525);
      case 527: /* fill_opt ::= */ yytestcase(yyruleno==527);
      case 541: /* having_clause_opt ::= */ yytestcase(yyruleno==541);
      case 543: /* range_opt ::= */ yytestcase(yyruleno==543);
      case 545: /* every_opt ::= */ yytestcase(yyruleno==545);
      case 558: /* slimit_clause_opt ::= */ yytestcase(yyruleno==558);
      case 562: /* limit_clause_opt ::= */ yytestcase(yyruleno==562);
{ yymsp[1].minor.yy828 = NULL; }
        break;
      case 135: /* start_opt ::= START WITH NK_INTEGER */
      case 139: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==139);
{ yymsp[-2].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 136: /* start_opt ::= START WITH NK_STRING */
      case 140: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==140);
{ yymsp[-2].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 137: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 141: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==141);
{ yymsp[-3].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 142: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 144: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==144);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy669, yymsp[-5].minor.yy828, yymsp[-3].minor.yy222, yymsp[-1].minor.yy222, yymsp[0].minor.yy828); }
        break;
      case 143: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy222); }
        break;
      case 145: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy222); }
        break;
      case 146: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy669, yymsp[0].minor.yy828); }
        break;
      case 147: /* cmd ::= ALTER TABLE alter_table_clause */
      case 348: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==348);
      case 349: /* cmd ::= insert_query */ yytestcase(yyruleno==349);
{ pCxt->pRootNode = yymsp[0].minor.yy828; }
        break;
      case 148: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy828); }
        break;
      case 149: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy828 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 150: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy828 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy828, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy63, yymsp[0].minor.yy686); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 151: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy828 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy828, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy63); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 152: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy828 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy828, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy63, yymsp[0].minor.yy686); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 153: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy828 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy828, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy63, &yymsp[0].minor.yy63); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 154: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy828 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy828, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy63, yymsp[0].minor.yy686); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 155: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy828 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy828, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy63); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 156: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy828 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy828, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy63, yymsp[0].minor.yy686); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 157: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy828 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy828, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy63, &yymsp[0].minor.yy63); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 158: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy828 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy828, &yymsp[-2].minor.yy63, yymsp[0].minor.yy828); }
  yymsp[-5].minor.yy828 = yylhsminor.yy828;
        break;
      case 160: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 449: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==449);
{ yylhsminor.yy222 = addNodeToList(pCxt, yymsp[-1].minor.yy222, yymsp[0].minor.yy828); }
  yymsp[-1].minor.yy222 = yylhsminor.yy222;
        break;
      case 161: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy828 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy669, yymsp[-8].minor.yy828, yymsp[-6].minor.yy828, yymsp[-5].minor.yy222, yymsp[-2].minor.yy222, yymsp[0].minor.yy828); }
  yymsp[-9].minor.yy828 = yylhsminor.yy828;
        break;
      case 164: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy828 = createDropTableClause(pCxt, yymsp[-1].minor.yy669, yymsp[0].minor.yy828); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 165: /* specific_cols_opt ::= */
      case 196: /* tags_def_opt ::= */ yytestcase(yyruleno==196);
      case 268: /* tag_list_opt ::= */ yytestcase(yyruleno==268);
      case 322: /* col_list_opt ::= */ yytestcase(yyruleno==322);
      case 324: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==324);
      case 512: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==512);
      case 537: /* group_by_clause_opt ::= */ yytestcase(yyruleno==537);
      case 556: /* order_by_clause_opt ::= */ yytestcase(yyruleno==556);
{ yymsp[1].minor.yy222 = NULL; }
        break;
      case 166: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 323: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==323);
{ yymsp[-2].minor.yy222 = yymsp[-1].minor.yy222; }
        break;
      case 167: /* full_table_name ::= table_name */
{ yylhsminor.yy828 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy63, NULL); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 168: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy828 = createRealTableNode(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63, NULL); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 171: /* column_def ::= column_name type_name */
{ yylhsminor.yy828 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy63, yymsp[0].minor.yy686, NULL); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 172: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy828 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy63, yymsp[-2].minor.yy686, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 173: /* type_name ::= BOOL */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 174: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 175: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 176: /* type_name ::= INT */
      case 177: /* type_name ::= INTEGER */ yytestcase(yyruleno==177);
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 178: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 179: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 180: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 181: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy686 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 182: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 183: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy686 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 184: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy686 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 185: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy686 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 186: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy686 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 187: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy686 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 188: /* type_name ::= JSON */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 189: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy686 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 190: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 191: /* type_name ::= BLOB */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 192: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy686 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 193: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 194: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy686 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 195: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy686 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 197: /* tags_def_opt ::= tags_def */
      case 325: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==325);
      case 441: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==441);
{ yylhsminor.yy222 = yymsp[0].minor.yy222; }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 198: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 326: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==326);
{ yymsp[-3].minor.yy222 = yymsp[-1].minor.yy222; }
        break;
      case 199: /* table_options ::= */
{ yymsp[1].minor.yy828 = createDefaultTableOptions(pCxt); }
        break;
      case 200: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-2].minor.yy828, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 201: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-2].minor.yy828, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy222); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 202: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-2].minor.yy828, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy222); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 203: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-4].minor.yy828, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy222); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 204: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-2].minor.yy828, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 205: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-4].minor.yy828, TABLE_OPTION_SMA, yymsp[-1].minor.yy222); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 206: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-2].minor.yy828, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy222); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 207: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy828 = createAlterTableOptions(pCxt); yylhsminor.yy828 = setTableOption(pCxt, yylhsminor.yy828, yymsp[0].minor.yy233.type, &yymsp[0].minor.yy233.val); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 208: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-1].minor.yy828, yymsp[0].minor.yy233.type, &yymsp[0].minor.yy233.val); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 209: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy233.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 210: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy233.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 211: /* duration_list ::= duration_literal */
      case 405: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==405);
{ yylhsminor.yy222 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy828)); }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 212: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 406: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==406);
{ yylhsminor.yy222 = addNodeToList(pCxt, yymsp[-2].minor.yy222, releaseRawExprNode(pCxt, yymsp[0].minor.yy828)); }
  yymsp[-2].minor.yy222 = yylhsminor.yy222;
        break;
      case 215: /* rollup_func_name ::= function_name */
{ yylhsminor.yy828 = createFunctionNode(pCxt, &yymsp[0].minor.yy63, NULL); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 216: /* rollup_func_name ::= FIRST */
      case 217: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==217);
      case 272: /* tag_item ::= QTAGS */ yytestcase(yyruleno==272);
{ yylhsminor.yy828 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 220: /* col_name ::= column_name */
      case 273: /* tag_item ::= column_name */ yytestcase(yyruleno==273);
{ yylhsminor.yy828 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy63); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 221: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 222: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 223: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 224: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 225: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy828, yymsp[0].minor.yy828, OP_TYPE_LIKE); }
        break;
      case 226: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy828, yymsp[0].minor.yy828, OP_TYPE_LIKE); }
        break;
      case 227: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy828, NULL, OP_TYPE_LIKE); }
        break;
      case 228: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 229: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 230: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 231: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy828, yymsp[-1].minor.yy828, OP_TYPE_EQUAL); }
        break;
      case 232: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 233: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 234: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 235: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 236: /* cmd ::= SHOW LICENCES */
      case 237: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==237);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 238: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy63); }
        break;
      case 239: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy828); }
        break;
      case 240: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy828); }
        break;
      case 241: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 242: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 243: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 244: /* cmd ::= SHOW VARIABLES */
      case 245: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==245);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 246: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 247: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy828); }
        break;
      case 248: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 249: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 250: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 251: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 252: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy828); }
        break;
      case 253: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 254: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 255: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy828, yymsp[-1].minor.yy828, OP_TYPE_EQUAL); }
        break;
      case 256: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy828, yymsp[0].minor.yy828, yymsp[-3].minor.yy222); }
        break;
      case 257: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 258: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 259: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy828,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 260: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 261: /* db_name_cond_opt ::= */
      case 266: /* from_db_opt ::= */ yytestcase(yyruleno==266);
{ yymsp[1].minor.yy828 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 262: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy828 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy63); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 264: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 265: /* table_name_cond ::= table_name */
{ yylhsminor.yy828 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy63); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 267: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy828 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy63); }
        break;
      case 271: /* tag_item ::= TBNAME */
{ yylhsminor.yy828 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 274: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy828 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy63), &yymsp[0].minor.yy63); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 275: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy828 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy63), &yymsp[0].minor.yy63); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 276: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy669, yymsp[-3].minor.yy828, yymsp[-1].minor.yy828, NULL, yymsp[0].minor.yy828); }
        break;
      case 277: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy669, yymsp[-5].minor.yy828, yymsp[-3].minor.yy828, yymsp[-1].minor.yy222, NULL); }
        break;
      case 278: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy669, yymsp[0].minor.yy828); }
        break;
      case 279: /* full_index_name ::= index_name */
{ yylhsminor.yy828 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy63); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 280: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy828 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 281: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy828 = createIndexOption(pCxt, yymsp[-7].minor.yy222, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), NULL, yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 282: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy828 = createIndexOption(pCxt, yymsp[-9].minor.yy222, releaseRawExprNode(pCxt, yymsp[-5].minor.yy828), releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 285: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy828 = createFunctionNode(pCxt, &yymsp[-3].minor.yy63, yymsp[-1].minor.yy222); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 291: /* sma_stream_opt ::= */
      case 327: /* stream_options ::= */ yytestcase(yyruleno==327);
{ yymsp[1].minor.yy828 = createStreamOptions(pCxt); }
        break;
      case 292: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy828)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy828); yylhsminor.yy828 = yymsp[-2].minor.yy828; }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 293: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy828)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy828); yylhsminor.yy828 = yymsp[-2].minor.yy828; }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 294: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy828)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy828); yylhsminor.yy828 = yymsp[-2].minor.yy828; }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 295: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy669, &yymsp[-2].minor.yy63, yymsp[0].minor.yy828); }
        break;
      case 296: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy669, &yymsp[-3].minor.yy63, &yymsp[0].minor.yy63, false); }
        break;
      case 297: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy669, &yymsp[-5].minor.yy63, &yymsp[0].minor.yy63, true); }
        break;
      case 298: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy669, &yymsp[-3].minor.yy63, yymsp[0].minor.yy828, false); }
        break;
      case 299: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy669, &yymsp[-5].minor.yy63, yymsp[0].minor.yy828, true); }
        break;
      case 300: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy669, &yymsp[0].minor.yy63); }
        break;
      case 301: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy669, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63); }
        break;
      case 302: /* cmd ::= DESC full_table_name */
      case 303: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==303);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy828); }
        break;
      case 304: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 305: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 306: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==306);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy669, yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 309: /* explain_options ::= */
{ yymsp[1].minor.yy828 = createDefaultExplainOptions(pCxt); }
        break;
      case 310: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy828 = setExplainVerbose(pCxt, yymsp[-2].minor.yy828, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 311: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy828 = setExplainRatio(pCxt, yymsp[-2].minor.yy828, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 312: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy669, yymsp[-9].minor.yy669, &yymsp[-6].minor.yy63, &yymsp[-4].minor.yy0, yymsp[-2].minor.yy686, yymsp[-1].minor.yy332, &yymsp[0].minor.yy63); }
        break;
      case 313: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy669, &yymsp[0].minor.yy63); }
        break;
      case 318: /* language_opt ::= */
{ yymsp[1].minor.yy63 = nil_token; }
        break;
      case 319: /* language_opt ::= LANGUAGE NK_STRING */
{ yymsp[-1].minor.yy63 = yymsp[0].minor.yy0; }
        break;
      case 320: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy669, &yymsp[-8].minor.yy63, yymsp[-5].minor.yy828, yymsp[-7].minor.yy828, yymsp[-3].minor.yy222, yymsp[-2].minor.yy828, yymsp[0].minor.yy828, yymsp[-4].minor.yy222); }
        break;
      case 321: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy669, &yymsp[0].minor.yy63); }
        break;
      case 328: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 329: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==329);
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-2].minor.yy828, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 330: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-3].minor.yy828, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy828)); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 331: /* stream_options ::= stream_options WATERMARK duration_literal */
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-2].minor.yy828, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy828)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 332: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-3].minor.yy828, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 333: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-2].minor.yy828, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 334: /* stream_options ::= stream_options DELETE_MARK duration_literal */
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-2].minor.yy828, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy828)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 335: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-3].minor.yy828, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 337: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 526: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==526);
      case 546: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==546);
{ yymsp[-3].minor.yy828 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy828); }
        break;
      case 338: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 339: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 340: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 341: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 342: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 343: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy222); }
        break;
      case 344: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 345: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy222 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 347: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 350: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy828 = createInsertStmt(pCxt, yymsp[-4].minor.yy828, yymsp[-2].minor.yy222, yymsp[0].minor.yy828); }
        break;
      case 351: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy828 = createInsertStmt(pCxt, yymsp[-1].minor.yy828, NULL, yymsp[0].minor.yy828); }
        break;
      case 352: /* literal ::= NK_INTEGER */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 353: /* literal ::= NK_FLOAT */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 354: /* literal ::= NK_STRING */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 355: /* literal ::= NK_BOOL */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 356: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 357: /* literal ::= duration_literal */
      case 367: /* signed_literal ::= signed */ yytestcase(yyruleno==367);
      case 388: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==388);
      case 389: /* expression ::= literal */ yytestcase(yyruleno==389);
      case 390: /* expression ::= pseudo_column */ yytestcase(yyruleno==390);
      case 391: /* expression ::= column_reference */ yytestcase(yyruleno==391);
      case 392: /* expression ::= function_expression */ yytestcase(yyruleno==392);
      case 393: /* expression ::= case_when_expression */ yytestcase(yyruleno==393);
      case 424: /* function_expression ::= literal_func */ yytestcase(yyruleno==424);
      case 473: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==473);
      case 477: /* boolean_primary ::= predicate */ yytestcase(yyruleno==477);
      case 479: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==479);
      case 480: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==480);
      case 483: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==483);
      case 485: /* table_reference ::= table_primary */ yytestcase(yyruleno==485);
      case 486: /* table_reference ::= joined_table */ yytestcase(yyruleno==486);
      case 490: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==490);
      case 548: /* query_simple ::= query_specification */ yytestcase(yyruleno==548);
      case 549: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==549);
      case 552: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==552);
      case 554: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==554);
{ yylhsminor.yy828 = yymsp[0].minor.yy828; }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 358: /* literal ::= NULL */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 359: /* literal ::= NK_QUESTION */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 360: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 361: /* signed ::= NK_INTEGER */
{ yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 362: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 363: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 364: /* signed ::= NK_FLOAT */
{ yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 365: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 366: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 368: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 369: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 370: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 371: /* signed_literal ::= duration_literal */
      case 373: /* signed_literal ::= literal_func */ yytestcase(yyruleno==373);
      case 444: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==444);
      case 506: /* select_item ::= common_expression */ yytestcase(yyruleno==506);
      case 516: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==516);
      case 553: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==553);
      case 555: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==555);
      case 568: /* search_condition ::= common_expression */ yytestcase(yyruleno==568);
{ yylhsminor.yy828 = releaseRawExprNode(pCxt, yymsp[0].minor.yy828); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 372: /* signed_literal ::= NULL */
{ yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 374: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy828 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 394: /* expression ::= NK_LP expression NK_RP */
      case 478: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==478);
      case 567: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==567);
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy828)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 395: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy828));
                                                                                  }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 396: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy828), NULL));
                                                                                  }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 397: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828))); 
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 398: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828))); 
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 399: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828))); 
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 400: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828))); 
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 401: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 402: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 403: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 404: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 407: /* column_reference ::= column_name */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy63, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy63)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 408: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63, createColumnNode(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 409: /* pseudo_column ::= ROWTS */
      case 410: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==410);
      case 412: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==412);
      case 413: /* pseudo_column ::= QEND */ yytestcase(yyruleno==413);
      case 414: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==414);
      case 415: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==415);
      case 416: /* pseudo_column ::= WEND */ yytestcase(yyruleno==416);
      case 417: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==417);
      case 418: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==418);
      case 419: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==419);
      case 420: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==420);
      case 426: /* literal_func ::= NOW */ yytestcase(yyruleno==426);
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 411: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy63)))); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 421: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 422: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==422);
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy63, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy63, yymsp[-1].minor.yy222)); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 423: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), yymsp[-1].minor.yy686)); }
  yymsp[-5].minor.yy828 = yylhsminor.yy828;
        break;
      case 425: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy63, NULL)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 440: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy222 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 445: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 509: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==509);
{ yylhsminor.yy828 = createColumnNode(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 446: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy222, yymsp[-1].minor.yy828)); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 447: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), yymsp[-2].minor.yy222, yymsp[-1].minor.yy828)); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 450: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy828 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)); }
        break;
      case 452: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy828 = releaseRawExprNode(pCxt, yymsp[0].minor.yy828); }
        break;
      case 453: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 458: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==458);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy62, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 454: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy828), releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 455: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy828), releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-5].minor.yy828 = yylhsminor.yy828;
        break;
      case 456: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), NULL));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 457: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), NULL));
                                                                                  }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 459: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy62 = OP_TYPE_LOWER_THAN; }
        break;
      case 460: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy62 = OP_TYPE_GREATER_THAN; }
        break;
      case 461: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy62 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 462: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy62 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 463: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy62 = OP_TYPE_NOT_EQUAL; }
        break;
      case 464: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy62 = OP_TYPE_EQUAL; }
        break;
      case 465: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy62 = OP_TYPE_LIKE; }
        break;
      case 466: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy62 = OP_TYPE_NOT_LIKE; }
        break;
      case 467: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy62 = OP_TYPE_MATCH; }
        break;
      case 468: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy62 = OP_TYPE_NMATCH; }
        break;
      case 469: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy62 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 470: /* in_op ::= IN */
{ yymsp[0].minor.yy62 = OP_TYPE_IN; }
        break;
      case 471: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy62 = OP_TYPE_NOT_IN; }
        break;
      case 472: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy222)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 474: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy828), NULL));
                                                                                  }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 475: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 476: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 482: /* from_clause_opt ::= FROM table_reference_list */
      case 511: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==511);
      case 542: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==542);
{ yymsp[-1].minor.yy828 = yymsp[0].minor.yy828; }
        break;
      case 484: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy828 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy828, yymsp[0].minor.yy828, NULL); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 487: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy828 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy63, &yymsp[0].minor.yy63); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 488: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy828 = createRealTableNode(pCxt, &yymsp[-3].minor.yy63, &yymsp[-1].minor.yy63, &yymsp[0].minor.yy63); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 489: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy828 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy828), &yymsp[0].minor.yy63); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 491: /* alias_opt ::= */
{ yymsp[1].minor.yy63 = nil_token;  }
        break;
      case 493: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy63 = yymsp[0].minor.yy63; }
        break;
      case 494: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 495: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==495);
{ yymsp[-2].minor.yy828 = yymsp[-1].minor.yy828; }
        break;
      case 496: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy828 = createJoinTableNode(pCxt, yymsp[-4].minor.yy574, yymsp[-5].minor.yy828, yymsp[-2].minor.yy828, yymsp[0].minor.yy828); }
  yymsp[-5].minor.yy828 = yylhsminor.yy828;
        break;
      case 497: /* join_type ::= */
{ yymsp[1].minor.yy574 = JOIN_TYPE_INNER; }
        break;
      case 498: /* join_type ::= INNER */
{ yymsp[0].minor.yy574 = JOIN_TYPE_INNER; }
        break;
      case 499: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy828 = createSelectStmt(pCxt, yymsp[-10].minor.yy669, yymsp[-9].minor.yy222, yymsp[-8].minor.yy828);
                                                                                    yymsp[-11].minor.yy828 = addWhereClause(pCxt, yymsp[-11].minor.yy828, yymsp[-7].minor.yy828);
                                                                                    yymsp[-11].minor.yy828 = addPartitionByClause(pCxt, yymsp[-11].minor.yy828, yymsp[-6].minor.yy222);
                                                                                    yymsp[-11].minor.yy828 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy828, yymsp[-2].minor.yy828);
                                                                                    yymsp[-11].minor.yy828 = addGroupByClause(pCxt, yymsp[-11].minor.yy828, yymsp[-1].minor.yy222);
                                                                                    yymsp[-11].minor.yy828 = addHavingClause(pCxt, yymsp[-11].minor.yy828, yymsp[0].minor.yy828);
                                                                                    yymsp[-11].minor.yy828 = addRangeClause(pCxt, yymsp[-11].minor.yy828, yymsp[-5].minor.yy828);
                                                                                    yymsp[-11].minor.yy828 = addEveryClause(pCxt, yymsp[-11].minor.yy828, yymsp[-4].minor.yy828);
                                                                                    yymsp[-11].minor.yy828 = addFillClause(pCxt, yymsp[-11].minor.yy828, yymsp[-3].minor.yy828);
                                                                                  }
        break;
      case 502: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy669 = false; }
        break;
      case 505: /* select_item ::= NK_STAR */
{ yylhsminor.yy828 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 507: /* select_item ::= common_expression column_alias */
      case 517: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==517);
{ yylhsminor.yy828 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy828), &yymsp[0].minor.yy63); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 508: /* select_item ::= common_expression AS column_alias */
      case 518: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==518);
{ yylhsminor.yy828 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), &yymsp[0].minor.yy63); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 513: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 538: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==538);
      case 557: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==557);
{ yymsp[-2].minor.yy222 = yymsp[0].minor.yy222; }
        break;
      case 520: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy828 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), releaseRawExprNode(pCxt, yymsp[-1].minor.yy828)); }
        break;
      case 521: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy828 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy828)); }
        break;
      case 522: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy828 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), NULL, yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 523: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy828 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy828), releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 524: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy828 = createEventWindowNode(pCxt, yymsp[-3].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 528: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy828 = createFillNode(pCxt, yymsp[-1].minor.yy822, NULL); }
        break;
      case 529: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy828 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy222)); }
        break;
      case 530: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy828 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy222)); }
        break;
      case 531: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy822 = FILL_MODE_NONE; }
        break;
      case 532: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy822 = FILL_MODE_PREV; }
        break;
      case 533: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy822 = FILL_MODE_NULL; }
        break;
      case 534: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy822 = FILL_MODE_NULL_F; }
        break;
      case 535: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy822 = FILL_MODE_LINEAR; }
        break;
      case 536: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy822 = FILL_MODE_NEXT; }
        break;
      case 539: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy222 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy828))); }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 540: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy222 = addNodeToList(pCxt, yymsp[-2].minor.yy222, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy828))); }
  yymsp[-2].minor.yy222 = yylhsminor.yy222;
        break;
      case 544: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy828 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), releaseRawExprNode(pCxt, yymsp[-1].minor.yy828)); }
        break;
      case 547: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy828 = addOrderByClause(pCxt, yymsp[-3].minor.yy828, yymsp[-2].minor.yy222);
                                                                                    yylhsminor.yy828 = addSlimitClause(pCxt, yylhsminor.yy828, yymsp[-1].minor.yy828);
                                                                                    yylhsminor.yy828 = addLimitClause(pCxt, yylhsminor.yy828, yymsp[0].minor.yy828);
                                                                                  }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 550: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy828 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy828, yymsp[0].minor.yy828); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 551: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy828 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy828, yymsp[0].minor.yy828); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 559: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 563: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==563);
{ yymsp[-1].minor.yy828 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 560: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 564: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==564);
{ yymsp[-3].minor.yy828 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 561: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 565: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==565);
{ yymsp[-3].minor.yy828 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 566: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy828); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 571: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy828 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), yymsp[-1].minor.yy158, yymsp[0].minor.yy675); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 572: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy158 = ORDER_ASC; }
        break;
      case 573: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy158 = ORDER_ASC; }
        break;
      case 574: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy158 = ORDER_DESC; }
        break;
      case 575: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy675 = NULL_ORDER_DEFAULT; }
        break;
      case 576: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy675 = NULL_ORDER_FIRST; }
        break;
      case 577: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy675 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
