---
sidebar_label: Node.js
title: Connect with Node.js Connector
description: Connect to TDengine cloud service using Node.JS connector
---
import Tabs from '@theme/Tabs';
import TabItem from '@theme/TabItem';

## Install Connector

```bash
npm i td2.0-rest-connector
```
## Config

Run this command in your terminal to save TDengine cloud token as variables:

<Tabs defaultValue="bash">
<TabItem value="bash" label="Bash">

```bash
export TDENGINE_CLOUD_TOKEN="<token>"
export TDENGINE_CLOUD_URL="<url>"
```

</TabItem>
<TabItem value="cmd" label="CMD">

```bash
set TDENGINE_CLOUD_TOKEN="<token>"
set TDENGINE_CLOUD_URL="<url>"
```

</TabItem>
<TabItem value="powershell" label="Powershell">

```powershell
$env:TDENGINE_CLOUD_TOKEN="<token>"
$env:TDENGINE_CLOUD_URL="<url>"
```

</TabItem>
</Tabs>


<!-- exclude -->
:::note
Replace  <token\> and <url\> with cloud token and URL.
To obtain the value of cloud token and URL, please log in [TDengine Cloud](https://cloud.tdengine.com) and click "Connector" and then select "Node.js".

:::
<!-- exclude-end -->

## Connect

```javascript
{{#include docs/examples/node/connect.js}}
```