/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 461
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy32;
  SToken yy77;
  int32_t yy248;
  int8_t yy287;
  ENullOrder yy385;
  EJoinType yy560;
  SNode* yy600;
  SNodeList* yy601;
  SAlterOption yy661;
  EOperatorType yy666;
  int64_t yy717;
  EFillMode yy798;
  bool yy841;
  SDataType yy888;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             717
#define YYNRULE              546
#define YYNTOKEN             325
#define YY_MAX_SHIFT         716
#define YY_MIN_SHIFTREDUCE   1064
#define YY_MAX_SHIFTREDUCE   1609
#define YY_ERROR_ACTION      1610
#define YY_ACCEPT_ACTION     1611
#define YY_NO_ACTION         1612
#define YY_MIN_REDUCE        1613
#define YY_MAX_REDUCE        2158
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (3190)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1820,  408, 1756, 1972, 1959, 1881,  463,  356,  464, 1649,
 /*    10 */  1959, 1752,   45,   43, 1539, 1955, 1818, 1754, 1879,  593,
 /*    20 */   363, 1955, 1389,   38,   37,  522, 1097,   44,   42,   41,
 /*    30 */    40,   39, 1745, 1469, 1990, 1387,  472,  605,  464, 1649,
 /*    40 */   532,  321,  589, 1881, 1951, 1957,  346, 1941,  605,  622,
 /*    50 */  1951, 1957,  358,  354,  227,  616, 1878,  593, 1464,   27,
 /*    60 */   230,  616, 1972, 1797,   18, 1099, 2134, 1102, 1103,  525,
 /*    70 */  2129, 1395,  368, 1971,  519, 1813, 1815, 2007,  569,  226,
 /*    80 */   103, 1973,  626, 1975, 1976,  621, 2133,  616,  169,  605,
 /*    90 */  2130, 2132,  172, 1990, 2060,  481,   14, 1613,  357, 2056,
 /*   100 */   462,  623,  160,  467, 1655,  481, 1941, 1721,  622,  335,
 /*   110 */  1867,  471,  177,   48,  467, 1655,   67,  606,  713,   66,
 /*   120 */  2086,  125,  124,  123,  122,  121,  120,  119,  118,  117,
 /*   130 */  1415,  126, 1971, 1471, 1472, 1414, 2007,  355,  502,  103,
 /*   140 */  1973,  626, 1975, 1976,  621,  157,  616, 2134, 1767,  137,
 /*   150 */  1614,  143, 2031, 2060, 1769, 1414,  660,  357, 2056,   41,
 /*   160 */    40,   39, 1444, 1454, 1416,   48, 1543,  469, 1470, 1473,
 /*   170 */  1820,  116, 1414,  465,  115,  114,  113,  112,  111,  110,
 /*   180 */   109,  108,  107, 1390,   84, 1388, 1819, 1224,  648,  647,
 /*   190 */   646, 1228,  645, 1230, 1231,  644, 1233,  641,  130, 1239,
 /*   200 */   638, 1241, 1242,  635,  632, 1682, 2075, 1762, 1393, 1394,
 /*   210 */  1184, 1443, 1446, 1447, 1448, 1449, 1450, 1451, 1452, 1453,
 /*   220 */   618,  614, 1462, 1463, 1465, 1466, 1467, 1468,    2,   45,
 /*   230 */    43,   60, 2072,  320,  564, 1412,  261,  363, 1116, 1389,
 /*   240 */  1115, 1599,  438, 1267, 1268,  451, 1186, 1972,  450, 1414,
 /*   250 */  1469,  116, 1387,  213,  115,  114,  113,  112,  111,  110,
 /*   260 */   109,  108,  107,  422,  171,  452,   60, 1636,  424, 1117,
 /*   270 */  1413,  517,  516,  515,   60, 1464,   89, 1807, 1990,  131,
 /*   280 */   511,   18,   11, 1611,  510,  606,  623,  651, 1395,  509,
 /*   290 */   514, 1941, 1990,  622, 1395,  508,   49,   38,   37,  126,
 /*   300 */   568,   44,   42,   41,   40,   39,  507,   64,  260, 1417,
 /*   310 */   336, 1941,  397,   14, 1445,  178, 1767, 1971,  570,  565,
 /*   320 */   559, 2007,  412, 1820,  103, 1973,  626, 1975, 1976,  621,
 /*   330 */   367,  616,  100,  399,  395,  713, 2149, 1758, 2060, 1818,
 /*   340 */   567, 1743,  357, 2056,   35,  277,  135,  378, 1955,  672,
 /*   350 */  1471, 1472,  448, 2094, 1759,  443,  442,  441,  440,  437,
 /*   360 */   436,  435,  434,  433,  429,  428,  427,  426,  337,  419,
 /*   370 */   418,  417,  586,  414,  413,  334, 1750, 1951, 1957, 1444,
 /*   380 */  1454,  178,  268,  269,  586, 1470, 1473,  267,  616,  550,
 /*   390 */   233, 1320, 1321, 2129, 1820, 1398, 1116,  214, 1115,   60,
 /*   400 */  1390,  332, 1388,  134,  660,   13,   12,   60, 2135,  175,
 /*   410 */  1818, 1635,  164, 2130,  575,  134,  178, 1479,  498,  494,
 /*   420 */   490,  486,  211, 1414,  178, 1393, 1394, 1117, 1443, 1446,
 /*   430 */  1447, 1448, 1449, 1450, 1451, 1452, 1453,  618,  614, 1462,
 /*   440 */  1463, 1465, 1466, 1467, 1468,    2,  178,   11,   45,   43,
 /*   450 */   159,  169, 1625,  238,  136, 1941,  363, 2031, 1389,   85,
 /*   460 */  1814, 1815,  209,  174, 2068, 2069,  574,  132, 2073, 1469,
 /*   470 */  2129, 1387, 1416, 1868,  606,  258, 2068,  585, 1863,  127,
 /*   480 */   584,  652,  606, 2129, 1811,  573,  175, 1634,  603,  183,
 /*   490 */  2130,  575,  606,  401, 1464,  400,  604, 1863,  573,  175,
 /*   500 */    18, 1512,  229, 2130,  575, 1767,   54, 1395,  185,  517,
 /*   510 */   516,  515, 1972, 1767,  513,  512, 2134,  131,  511,  158,
 /*   520 */  2129,   84,  510, 1767,  297,  360,  359,  509,  514,  208,
 /*   530 */   202, 1941,   14,  508,  207, 1403, 2133,  477,  295,   70,
 /*   540 */  2130, 2131,   69, 1990, 1763, 1401, 1469,  340, 1396,  178,
 /*   550 */   606,  589,  606,  200,  713,  617, 1941,  178,  622, 2075,
 /*   560 */   196,  459,  457,  454,  180, 1445,  406, 1366, 1367, 1471,
 /*   570 */  1472, 1464,   38,   37, 1566, 1626,   44,   42,   41,   40,
 /*   580 */    39, 1767, 1971, 1767, 1395, 2071, 2007, 1417,   94,  103,
 /*   590 */  1973,  626, 1975, 1976,  621, 1863,  616,   60, 1444, 1454,
 /*   600 */   650,  172,  187, 2060, 1470, 1473,  189,  357, 2056,  341,
 /*   610 */  1760,  339,  338,  574,  504, 2075,  260, 2129,  506, 1390,
 /*   620 */  1536, 1388, 1389,  561, 1564, 1565, 1567, 1568,  328, 2087,
 /*   630 */   545,  612,  573,  175, 1722, 1387,  102, 2130,  575,   81,
 /*   640 */   505, 2070,   80, 1415, 1393, 1394,  506, 1443, 1446, 1447,
 /*   650 */  1448, 1449, 1450, 1451, 1452, 1453,  618,  614, 1462, 1463,
 /*   660 */  1465, 1466, 1467, 1468,    2,   45,   43, 1474,  505, 1498,
 /*   670 */   658, 1395,  531,  363,  444, 1389,   78,   77,  405,  656,
 /*   680 */   228,  182, 1811, 1633, 1972,  529, 1469,  527, 1387,  148,
 /*   690 */   147,  655,  654,  653,  145,  606, 1404, 1632, 1399,  319,
 /*   700 */  1500,   11,  393,    9,  391,  387,  383,  380,  377,  407,
 /*   710 */   291, 1464,  366, 1797,  608, 1990, 2032,  610,  713, 2032,
 /*   720 */   157, 1407, 1409,  623, 1395, 1499, 1767, 1941, 1941, 1769,
 /*   730 */   622,  184,  191,  190,  614, 1462, 1463, 1465, 1466, 1467,
 /*   740 */  1468, 1941,   86,  323,  157,  606,  535,  178,  533,   46,
 /*   750 */   586, 1631,  369, 1770, 1971, 1417, 1334, 1335, 2007,  416,
 /*   760 */   157,  103, 1973,  626, 1975, 1976,  621,  657,  616, 1769,
 /*   770 */  1811,  713,   32, 2149, 1630, 2060, 1767,  684,  682,  357,
 /*   780 */  2056,  134, 1505, 1390,  581, 1388, 1471, 1472, 1744,    8,
 /*   790 */  2107, 1333, 1336, 1629,  673, 1941, 1737,   34,  361, 1493,
 /*   800 */  1494, 1495, 1496, 1497, 1501, 1502, 1503, 1504, 1393, 1394,
 /*   810 */    44,   42,   41,   40,   39, 1444, 1454, 1669, 1941,  606,
 /*   820 */  1414, 1470, 1473, 2100,   38,   37, 1742, 1850,   44,   42,
 /*   830 */    41,   40,   39,  278, 1102, 1103, 1390, 1941, 1388,  518,
 /*   840 */   588,  173, 2068, 2069, 2133,  132, 2073,   38,   37, 1928,
 /*   850 */  1767,   44,   42,   41,   40,   39, 1628, 1627, 1624,  146,
 /*   860 */  1623, 1393, 1394, 1535, 1443, 1446, 1447, 1448, 1449, 1450,
 /*   870 */  1451, 1452, 1453,  618,  614, 1462, 1463, 1465, 1466, 1467,
 /*   880 */  1468,    2,   45,   43, 2080, 1532,   50,  140,    3,  128,
 /*   890 */   363, 1972, 1389,  606,  606,  606,  658,  385,  409,  237,
 /*   900 */  1941, 1941, 1941, 1469, 1941, 1387,  613,  430,  431,  479,
 /*   910 */   255,  410,   53, 1576,  562,  148,  147,  655,  654,  653,
 /*   920 */   145,  578, 1990, 1622, 1767, 1767, 1767, 1397, 1464,  606,
 /*   930 */   623,   52,  402,  606,  658, 1941, 1555,  622,  549,   71,
 /*   940 */  1146, 1395,  212,  480,   38,   37, 1621, 1764,   44,   42,
 /*   950 */    41,   40,   39,  148,  147,  655,  654,  653,  145,  592,
 /*   960 */  1767, 1971, 1445, 1662, 1767, 2007,   46, 1941,  103, 1973,
 /*   970 */   626, 1975, 1976,  621,  550,  616, 1147,  606, 2129,  425,
 /*   980 */  2149, 1991, 2060, 1620, 1972,  520,  357, 2056,  713,   79,
 /*   990 */  1941,  142, 1619, 2135,  175, 1532, 1618,  557, 2130,  575,
 /*  1000 */    31,  550, 1660, 1471, 1472, 2129,   38,   37, 1767,  582,
 /*  1010 */    44,   42,   41,   40,   39, 1990,  219, 1608, 1609,  217,
 /*  1020 */  2135,  175,  666,  620,  523, 2130,  575, 1941, 1941,  606,
 /*  1030 */   622, 1617, 1444, 1454,  221,   33, 1941,  220, 1470, 1473,
 /*  1040 */  1941,   38,   37,  546, 1165,   44,   42,   41,   40,   39,
 /*  1050 */  1490,   62,  667, 1390, 1971, 1388,  223, 1616, 2007,  222,
 /*  1060 */  1767,  313, 1973,  626, 1975, 1976,  621,  619,  616,  607,
 /*  1070 */  2025,  376,  586,  225, 1163, 1941,  224, 1400, 1393, 1394,
 /*  1080 */   249, 1443, 1446, 1447, 1448, 1449, 1450, 1451, 1452, 1453,
 /*  1090 */   618,  614, 1462, 1463, 1465, 1466, 1467, 1468,    2,   45,
 /*  1100 */    43, 1941,  236,  134, 1563,  606,  577,  363, 1972, 1389,
 /*  1110 */  1962, 1606,  606,  550,  375,   99,  242, 2129,   47,  590,
 /*  1120 */  1469,  265, 1387,   38,   37,   96,  272,   44,   42,   41,
 /*  1130 */    40,   39, 2135,  175,  374,  606, 1767, 2130,  575, 1990,
 /*  1140 */    68,  606,   87, 1767,  579, 1464, 1872,  623, 1650,  601,
 /*  1150 */  1808,  587, 1941, 1656,  622,  370,  550,  144, 1395, 1964,
 /*  1160 */  2129,  257,  146,  176, 2068, 2069, 1767,  132, 2073,  244,
 /*  1170 */   254, 1331, 1767,   62,  270, 2135,  175, 2090, 1971,    1,
 /*  1180 */  2130,  575, 2007,   14,  379,  103, 1973,  626, 1975, 1976,
 /*  1190 */   621,  538,  616,  598,   13,   12,    4, 2149,  384, 2060,
 /*  1200 */   333, 1972,  708,  357, 2056,  713, 1605,   47,   47,  630,
 /*  1210 */   274,  144,  146,  129, 2123, 1217,  144, 1353,  188,  285,
 /*  1220 */  1471, 1472,  411,   38,   37, 1417, 1506,   44,   42,   41,
 /*  1230 */    40,   39, 1990,  550, 1873,  415,  446, 2129,  420, 1412,
 /*  1240 */   623,  439,  432, 1865,  445, 1941,  447,  622,  453, 1444,
 /*  1250 */  1454, 1679, 2135,  175,  455, 1470, 1473, 2130,  575,  456,
 /*  1260 */  1455,  290, 1245,  193, 1249, 1256, 1254,  458,  460,  149,
 /*  1270 */  1390, 1971, 1388, 1418,  461, 2007,  470, 1420,  104, 1973,
 /*  1280 */   626, 1975, 1976,  621,  473,  616, 1415,  199,  474,  201,
 /*  1290 */  1419,  475, 2060,  476, 1421, 1393, 1394, 2057, 1443, 1446,
 /*  1300 */  1447, 1448, 1449, 1450, 1451, 1452, 1453,  618,  614, 1462,
 /*  1310 */  1463, 1465, 1466, 1467, 1468,    2, 1972,  690,  689,  688,
 /*  1320 */   687,  373,  204,  686,  685,  138,  680,  679,  678,  677,
 /*  1330 */   676,  675,  674,  150,  670,  669,  668,  372,  371,  665,
 /*  1340 */   664,  663,  662,  661, 1119,  478,  206, 1990, 1960,  482,
 /*  1350 */   501,  503,   82,   83,  210,  623,  499,  500, 1757, 1955,
 /*  1360 */  1941,  322,  622,  106,  216, 1753, 1918, 1917,  537,  539,
 /*  1370 */   286,  540,  231,  218,  151,  152,  541,  544,  234,  156,
 /*  1380 */  1755, 1751, 1972,  153,  154,  547, 1971,  563, 1951, 1957,
 /*  1390 */  2007, 2106,  596,  103, 1973,  626, 1975, 1976,  621,  616,
 /*  1400 */   616,  554, 2105,    7, 2082, 2149,  560, 2060, 2091,  347,
 /*  1410 */  2101,  357, 2056, 1990,  566,  240,  572,  248,  165,  555,
 /*  1420 */   243,  623, 2079,  250,  553,  251, 1941,  552,  622,  252,
 /*  1430 */   348, 2152, 2128, 1532,  583,  133, 1972,  256, 1416,  580,
 /*  1440 */   253,  591,  262,  351,  287, 2076,  288,  599,  594,  600,
 /*  1450 */   595, 1889, 1971, 1888, 1887,  353, 2007,   91,  289,  103,
 /*  1460 */  1973,  626, 1975, 1976,  621,   93,  616, 1990, 1768,   59,
 /*  1470 */  2041, 2035,   95, 2060,  628,  623, 1812,  357, 2056, 1738,
 /*  1480 */  1941,  292,  622,  281,  709,  710,  712,   51,  316,  301,
 /*  1490 */   294,  315,  305,  324, 1935,  325,  296, 1934,   75, 1933,
 /*  1500 */  1932,   76, 1929,  381,  382, 1381, 1971, 1972, 1382,  181,
 /*  1510 */  2007,  386, 1927,  103, 1973,  626, 1975, 1976,  621,  388,
 /*  1520 */   616,  389,  390, 1926,  392, 2033,  394, 2060, 1925, 1924,
 /*  1530 */   396,  357, 2056, 1923, 1972, 1356,  398, 1355, 1990, 1900,
 /*  1540 */  1899,  403,  404, 1898, 1897, 1311,  623, 1858, 1857, 1855,
 /*  1550 */  1854, 1941,  139,  622, 1853, 1856, 1852, 1851, 1849, 1848,
 /*  1560 */  1847,  186,  421, 1846,  423, 1990, 1845, 1844, 1843, 1842,
 /*  1570 */  1841, 1840, 1839,  623, 1838, 1837, 1836, 1971, 1941, 1835,
 /*  1580 */   622, 2007, 1834, 1833,  103, 1973,  626, 1975, 1976,  621,
 /*  1590 */  1832,  616, 1831,  141, 1830, 1829,  609,  449, 2060, 1828,
 /*  1600 */  1827, 1972,  357, 2056, 1971, 1826, 1313, 1825, 2007, 1824,
 /*  1610 */  1823,  104, 1973,  626, 1975, 1976,  621, 1822,  616, 1821,
 /*  1620 */  1685, 1192,  192, 1684, 1972, 2060, 1683, 1681, 1645, 2059,
 /*  1630 */  2056,  194, 1990,  197, 1961,  195, 1105,   73, 1104, 1644,
 /*  1640 */   623, 1913,   74,  466,  198, 1941,  170,  622,  468, 1907,
 /*  1650 */  1896,  203,  205, 1895, 1875, 1990, 1746, 1680, 1139, 1678,
 /*  1660 */   483,  484, 1676,  623,  487, 1674,  488,  491, 1941,  485,
 /*  1670 */   622, 1971,  489,  493, 1672, 2007,  497,  495,  104, 1973,
 /*  1680 */   626, 1975, 1976,  621,  492,  616,  496, 1659, 1658, 1641,
 /*  1690 */  1748, 1972, 2060,   61,  624, 1261,  611, 2056, 2007, 1260,
 /*  1700 */  1747,  104, 1973,  626, 1975, 1976,  621,  681,  616,  215,
 /*  1710 */  1183, 1972,  683, 1182, 1181, 2060, 1180, 1177, 1176,  327,
 /*  1720 */  2056, 1175, 1990, 1670,  342, 1663, 1174,  343, 1661,  344,
 /*  1730 */   623,  524, 1640,  526,  521, 1941, 1639,  622,  528, 1638,
 /*  1740 */   530,  105, 1990, 1371, 1370, 1373, 1912,  534,   26,   55,
 /*  1750 */   623, 1362, 1906,  542, 1894, 1941, 1892,  622, 2134,   19,
 /*  1760 */    28, 1971,  239,   16, 1578, 2007,  155,  556,  161, 1973,
 /*  1770 */   626, 1975, 1976,  621,  235,  616,  558,  241,  543,  345,
 /*  1780 */   247, 1971,   58,  548,  246, 2007,   30,    5,  162, 1973,
 /*  1790 */   626, 1975, 1976,  621, 1562,  616, 1962,  163,   63, 1593,
 /*  1800 */  1972, 1554,    6,   20,   21, 1592,  245,   29,   88,  551,
 /*  1810 */  2097, 1598,   17,  349, 1599, 1597, 1596, 1529,  350, 1528,
 /*  1820 */   259,   57,  166, 1893, 1891,   56, 1890,  264,  597, 1874,
 /*  1830 */    22, 1990, 1560,  266,  273,   90,  276,  271,   23,  623,
 /*  1840 */   576, 2150,   12,   65, 1941, 1459,  622,   92,  629,   96,
 /*  1850 */  1481, 1491, 1405, 2010, 1972,  615,  167,  179, 1457,   36,
 /*  1860 */  1436,  625, 1456,   15,   24,   25,   10,  365, 1428, 1480,
 /*  1870 */  1971, 1246,  631,  627, 2007, 1223, 1243,  161, 1973,  626,
 /*  1880 */  1975, 1976,  621,  633,  616, 1990,  634,  636, 1240,  637,
 /*  1890 */   279,  639,  642,  623, 1234,  640, 1255, 1232, 1941,  643,
 /*  1900 */   622,   97,   98,   72, 1238, 1237, 1972, 1236, 1235, 1251,
 /*  1910 */   649, 1171, 1137,  659, 1170, 1169, 1168, 1167, 1166, 2098,
 /*  1920 */  1164, 1162, 1190, 1161, 1971, 1972, 1160,  671, 2007, 1158,
 /*  1930 */  1155,  307, 1973,  626, 1975, 1976,  621, 1990,  616,  280,
 /*  1940 */  1157, 1156, 1187, 1143, 1154,  623, 1153, 1152, 1185, 1149,
 /*  1950 */  1941, 1148,  622, 1145, 1144, 1142, 1990, 1677,  691, 1675,
 /*  1960 */   695,  352, 1673,  692,  623,  696,  693,  697,  699, 1941,
 /*  1970 */   700,  622, 1671,  701,  703,  571, 1971,  704, 1657,  705,
 /*  1980 */  2007,  707, 1094,  162, 1973,  626, 1975, 1976,  621, 1637,
 /*  1990 */   616,  283,  711, 1612,  714, 1971, 1391,  293, 1612, 2007,
 /*  2000 */  1972,  715,  314, 1973,  626, 1975, 1976,  621, 1612,  616,
 /*  2010 */  1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  2020 */  1972, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  2030 */  1612, 1990, 1612, 1612, 1612, 1612, 2151, 1612, 1612,  620,
 /*  2040 */  1612, 1612, 1612, 1612, 1941, 1612,  622, 1612, 1612, 1612,
 /*  2050 */  1612, 1990, 1612, 1612, 1612, 1612,  362, 1612, 1612,  623,
 /*  2060 */  1612, 1612, 1612, 1612, 1941, 1612,  622, 1612, 1612, 1612,
 /*  2070 */  1971, 1612, 1612, 1612, 2007, 1612, 1612,  313, 1973,  626,
 /*  2080 */  1975, 1976,  621, 1612,  616, 1612, 2026, 1612, 1612, 1612,
 /*  2090 */  1971, 1612, 1612, 1612, 2007, 1612, 1612,  314, 1973,  626,
 /*  2100 */  1975, 1976,  621, 1612,  616, 1612, 1612, 1612, 1612, 1612,
 /*  2110 */  1972, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  2120 */  1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1972,
 /*  2130 */  1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  2140 */  1612, 1990, 1612, 1612, 1612, 1612,  364, 1612, 1612,  623,
 /*  2150 */  1612, 1612, 1612, 1612, 1941, 1612,  622, 1612, 1612, 1612,
 /*  2160 */  1990, 1612, 1612, 1612, 1612, 1612, 1612, 1612,  623, 1612,
 /*  2170 */  1612, 1612, 1612, 1941, 1612,  622, 1612, 1612, 1612, 1612,
 /*  2180 */  1971, 1612, 1612, 1972, 2007, 1612, 1612,  314, 1973,  626,
 /*  2190 */  1975, 1976,  621, 1612,  616, 1612, 1612, 1612, 1612,  536,
 /*  2200 */  1612, 1612, 1612, 2007, 1612, 1612,  309, 1973,  626, 1975,
 /*  2210 */  1976,  621, 1612,  616, 1990, 1612, 1612, 1612, 1612, 1612,
 /*  2220 */  1612, 1612,  623, 1612, 1612, 1612, 1612, 1941, 1612,  622,
 /*  2230 */  1612, 1612, 1612, 1612, 1612, 1972, 1612, 1612, 1612, 1612,
 /*  2240 */  1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  2250 */  1612, 1612, 1612, 1971, 1972, 1612, 1612, 2007, 1612, 1612,
 /*  2260 */   298, 1973,  626, 1975, 1976,  621, 1990,  616, 1612, 1612,
 /*  2270 */  1612, 1612, 1612, 1612,  623, 1612, 1612, 1612, 1612, 1941,
 /*  2280 */  1612,  622, 1612, 1612, 1612, 1990, 1612, 1612, 1612, 1612,
 /*  2290 */  1612, 1612, 1612,  623, 1612, 1612, 1612, 1612, 1941, 1612,
 /*  2300 */   622, 1612, 1612, 1612, 1612, 1971, 1612, 1612, 1612, 2007,
 /*  2310 */  1612, 1612,  299, 1973,  626, 1975, 1976,  621, 1612,  616,
 /*  2320 */  1612, 1612, 1612, 1612, 1971, 1612, 1612, 1612, 2007, 1972,
 /*  2330 */  1612,  300, 1973,  626, 1975, 1976,  621, 1612,  616, 1612,
 /*  2340 */  1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1972,
 /*  2350 */  1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  2360 */  1990, 1612, 1612, 1612, 1612, 1612, 1612, 1612,  623, 1612,
 /*  2370 */  1612, 1612, 1612, 1941, 1612,  622, 1612, 1612, 1612, 1612,
 /*  2380 */  1990, 1612, 1612, 1612, 1612, 1612, 1612, 1612,  623, 1612,
 /*  2390 */  1612, 1612, 1612, 1941, 1612,  622, 1612, 1612, 1612, 1971,
 /*  2400 */  1612, 1612, 1612, 2007, 1612, 1612,  306, 1973,  626, 1975,
 /*  2410 */  1976,  621, 1612,  616, 1612, 1972, 1612, 1612, 1612, 1971,
 /*  2420 */  1612, 1612, 1612, 2007, 1612, 1612,  310, 1973,  626, 1975,
 /*  2430 */  1976,  621, 1612,  616, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  2440 */  1612, 1612, 1612, 1612, 1612, 1612, 1990, 1612, 1612, 1612,
 /*  2450 */  1612, 1612, 1612, 1612,  623, 1612, 1612, 1612, 1612, 1941,
 /*  2460 */  1612,  622, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  2470 */  1972, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  2480 */  1612, 1612, 1612, 1612, 1612, 1971, 1612, 1612, 1612, 2007,
 /*  2490 */  1612, 1612,  302, 1973,  626, 1975, 1976,  621, 1612,  616,
 /*  2500 */  1612, 1990, 1612, 1612, 1612, 1612, 1612, 1612, 1612,  623,
 /*  2510 */  1612, 1612, 1612, 1612, 1941, 1612,  622, 1612, 1612, 1612,
 /*  2520 */  1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1972, 1612,
 /*  2530 */  1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  2540 */  1971, 1612, 1612, 1612, 2007, 1612, 1612,  311, 1973,  626,
 /*  2550 */  1975, 1976,  621, 1612,  616, 1612, 1612, 1612, 1612, 1990,
 /*  2560 */  1612, 1612, 1612, 1612, 1612, 1612, 1612,  623, 1612, 1612,
 /*  2570 */  1612, 1612, 1941, 1612,  622, 1612, 1612, 1612, 1612, 1612,
 /*  2580 */  1612, 1612, 1972, 1612, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  2590 */  1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1971, 1612,
 /*  2600 */  1612, 1612, 2007, 1972, 1612,  303, 1973,  626, 1975, 1976,
 /*  2610 */   621, 1612,  616, 1990, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  2620 */  1612,  623, 1612, 1612, 1612, 1612, 1941, 1612,  622, 1612,
 /*  2630 */  1612, 1612, 1612, 1612, 1990, 1612, 1612, 1612, 1612, 1612,
 /*  2640 */  1612, 1612,  623, 1612, 1612, 1612, 1612, 1941, 1612,  622,
 /*  2650 */  1612, 1612, 1971, 1612, 1612, 1612, 2007, 1972, 1612,  312,
 /*  2660 */  1973,  626, 1975, 1976,  621, 1612,  616, 1612, 1612, 1612,
 /*  2670 */  1612, 1612, 1612, 1971, 1612, 1612, 1612, 2007, 1972, 1612,
 /*  2680 */   304, 1973,  626, 1975, 1976,  621, 1612,  616, 1990, 1612,
 /*  2690 */  1612, 1612, 1612, 1612, 1612, 1612,  623, 1612, 1612, 1612,
 /*  2700 */  1612, 1941, 1612,  622, 1612, 1612, 1612, 1612, 1612, 1990,
 /*  2710 */  1612, 1612, 1612, 1612, 1612, 1612, 1612,  623, 1612, 1612,
 /*  2720 */  1612, 1612, 1941, 1612,  622, 1612, 1612, 1971, 1612, 1612,
 /*  2730 */  1612, 2007, 1972, 1612,  317, 1973,  626, 1975, 1976,  621,
 /*  2740 */  1612,  616, 1612, 1612, 1612, 1612, 1612, 1612, 1971, 1612,
 /*  2750 */  1612, 1612, 2007, 1612, 1612,  318, 1973,  626, 1975, 1976,
 /*  2760 */   621,  716,  616, 1990, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  2770 */  1612,  623, 1612, 1612, 1612,  284, 1941, 1612,  622, 1612,
 /*  2780 */  1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1972, 1612,
 /*  2790 */   168, 1612, 1612, 1612, 1612, 1612,  706,  702,  698,  694,
 /*  2800 */   282, 1612, 1971, 1612, 1612, 1612, 2007, 1612, 1612, 1984,
 /*  2810 */  1973,  626, 1975, 1976,  621, 1612,  616, 1612, 1612, 1990,
 /*  2820 */  1612, 1612, 1612, 1612, 1612, 1612, 1612,  623, 1612, 1612,
 /*  2830 */  1612, 1612, 1941, 1612,  622, 1612, 1612,  101, 1612, 1612,
 /*  2840 */   275, 1612, 1612, 1972, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  2850 */  1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1971, 1612,
 /*  2860 */  1612, 1612, 2007, 1612, 1612, 1983, 1973,  626, 1975, 1976,
 /*  2870 */   621, 1612,  616,  602, 1990, 1612, 1612, 1612, 1612, 1612,
 /*  2880 */  1612, 1612,  623, 1612, 1612, 1612, 1612, 1941, 1612,  622,
 /*  2890 */  1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  2900 */  1612, 1972, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  2910 */  1612, 1612,  263, 1971, 1612, 1612, 1612, 2007, 1612, 1612,
 /*  2920 */  1982, 1973,  626, 1975, 1976,  621, 1612,  616, 1612, 1360,
 /*  2930 */  1612,  232, 1990, 1612, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  2940 */   623, 1612, 1612, 1612, 1612, 1941, 1612,  622, 1612, 1612,
 /*  2950 */  1612, 1612, 1612, 1612, 1612, 1972, 1612, 1612, 1612, 1612,
 /*  2960 */  1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  2970 */  1612, 1971, 1612, 1612, 1612, 2007, 1972, 1612,  329, 1973,
 /*  2980 */   626, 1975, 1976,  621, 1612,  616, 1990, 1612, 1612, 1612,
 /*  2990 */  1612, 1612, 1612, 1612,  623, 1612, 1612, 1612, 1612, 1941,
 /*  3000 */  1612,  622, 1612, 1612, 1612, 1612, 1612, 1990, 1612, 1612,
 /*  3010 */  1612, 1612, 1612, 1612, 1612,  623, 1612, 1612, 1612, 1612,
 /*  3020 */  1941, 1612,  622, 1612, 1612, 1971, 1612, 1612, 1612, 2007,
 /*  3030 */  1972, 1612,  330, 1973,  626, 1975, 1976,  621, 1612,  616,
 /*  3040 */  1612, 1612, 1612, 1612, 1612, 1612, 1971, 1612, 1612, 1612,
 /*  3050 */  2007, 1972, 1612,  326, 1973,  626, 1975, 1976,  621, 1612,
 /*  3060 */   616, 1990, 1612, 1612, 1612, 1612, 1612, 1612, 1612,  623,
 /*  3070 */  1612, 1612, 1612, 1612, 1941, 1612,  622, 1612, 1612, 1612,
 /*  3080 */  1612, 1612, 1990, 1612, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  3090 */   623, 1612, 1612, 1612, 1612, 1941, 1612,  622, 1612, 1612,
 /*  3100 */  1971, 1612, 1612, 1612, 2007, 1972, 1612,  331, 1973,  626,
 /*  3110 */  1975, 1976,  621, 1612,  616, 1612, 1612, 1612, 1612, 1612,
 /*  3120 */  1612,  624, 1612, 1612, 1612, 2007, 1612, 1612,  309, 1973,
 /*  3130 */   626, 1975, 1976,  621, 1612,  616, 1990, 1612, 1612, 1612,
 /*  3140 */  1612, 1612, 1612, 1612,  623, 1612, 1612, 1612, 1612, 1941,
 /*  3150 */  1612,  622, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  3160 */  1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612, 1612,
 /*  3170 */  1612, 1612, 1612, 1612, 1612, 1971, 1612, 1612, 1612, 2007,
 /*  3180 */  1612, 1612,  308, 1973,  626, 1975, 1976,  621, 1612,  616,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   359,  336,  360,  328,  361,  374,  332,  366,  334,  335,
 /*    10 */   361,  360,   12,   13,   14,  372,  375,  360,  387,  388,
 /*    20 */    20,  372,   22,    8,    9,    4,    4,   12,   13,   14,
 /*    30 */    15,   16,    0,   33,  359,   35,  332,   20,  334,  335,
 /*    40 */    19,  376,  367,  374,  401,  402,  403,  372,   20,  374,
 /*    50 */   401,  402,  403,  384,   33,  412,  387,  388,   58,   44,
 /*    60 */   352,  412,  328,  355,   64,   43,  431,   45,   46,   48,
 /*    70 */   435,   71,  370,  398,   53,  373,  374,  402,   20,   58,
 /*    80 */   405,  406,  407,  408,  409,  410,  451,  412,  359,   20,
 /*    90 */   455,  456,  417,  359,  419,   63,   96,    0,  423,  424,
 /*   100 */   333,  367,  343,  336,  337,   63,  372,  348,  374,  380,
 /*   110 */   381,  333,  437,   96,  336,  337,   95,  336,  118,   98,
 /*   120 */   445,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   130 */    20,  350,  398,  133,  134,   20,  402,  351,  357,  405,
 /*   140 */   406,  407,  408,  409,  410,  359,  412,    3,  367,  415,
 /*   150 */     0,  417,  418,  419,  368,   20,   63,  423,  424,   14,
 /*   160 */    15,   16,  162,  163,   20,   96,   14,   14,  168,  169,
 /*   170 */   359,   21,   20,   20,   24,   25,   26,   27,   28,   29,
 /*   180 */    30,   31,   32,  183,  342,  185,  375,  109,  110,  111,
 /*   190 */   112,  113,  114,  115,  116,  117,  118,  119,  356,  121,
 /*   200 */   122,  123,  124,  125,  126,    0,  404,  365,  208,  209,
 /*   210 */    35,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,   12,
 /*   230 */    13,   96,  430,   18,  167,   20,   58,   20,   20,   22,
 /*   240 */    22,   97,   27,  133,  134,   30,   71,  328,   33,   20,
 /*   250 */    33,   21,   35,   35,   24,   25,   26,   27,   28,   29,
 /*   260 */    30,   31,   32,   48,  358,   50,   96,  328,   53,   51,
 /*   270 */    20,   66,   67,   68,   96,   58,   98,  371,  359,   74,
 /*   280 */    75,   64,  230,  325,   79,  336,  367,  107,   71,   84,
 /*   290 */    85,  372,  359,  374,   71,   90,   96,    8,    9,  350,
 /*   300 */   367,   12,   13,   14,   15,   16,  357,    4,  164,   20,
 /*   310 */    95,  372,  178,   96,  162,  246,  367,  398,  251,  252,
 /*   320 */   253,  402,  107,  359,  405,  406,  407,  408,  409,  410,
 /*   330 */   366,  412,  340,  199,  200,  118,  417,  361,  419,  375,
 /*   340 */   407,    0,  423,  424,  420,  421,  354,  389,  372,   71,
 /*   350 */   133,  134,  137,  434,  362,  140,  141,  142,  143,  144,
 /*   360 */   145,  146,  147,  148,  149,  150,  151,  152,  153,  154,
 /*   370 */   155,  156,  336,  158,  159,  160,  360,  401,  402,  162,
 /*   380 */   163,  246,  127,  128,  336,  168,  169,  132,  412,  431,
 /*   390 */   360,  162,  163,  435,  359,   35,   20,   33,   22,   96,
 /*   400 */   183,  366,  185,  367,   63,    1,    2,   96,  450,  451,
 /*   410 */   375,  328,   48,  455,  456,  367,  246,   14,   54,   55,
 /*   420 */    56,   57,   58,   20,  246,  208,  209,   51,  211,  212,
 /*   430 */   213,  214,  215,  216,  217,  218,  219,  220,  221,  222,
 /*   440 */   223,  224,  225,  226,  227,  228,  246,  230,   12,   13,
 /*   450 */   327,  359,  329,  164,  415,  372,   20,  418,   22,   95,
 /*   460 */   373,  374,   98,  427,  428,  429,  431,  431,  432,   33,
 /*   470 */   435,   35,   20,  381,  336,  427,  428,  429,  367,  431,
 /*   480 */   432,  369,  336,  435,  372,  450,  451,  328,  350,  378,
 /*   490 */   455,  456,  336,  182,   58,  184,  350,  367,  450,  451,
 /*   500 */    64,   97,  127,  455,  456,  367,  350,   71,  378,   66,
 /*   510 */    67,   68,  328,  367,  345,  346,  431,   74,   75,   18,
 /*   520 */   435,  342,   79,  367,   23,   12,   13,   84,   85,  165,
 /*   530 */   166,  372,   96,   90,  170,   22,  451,  173,   37,   38,
 /*   540 */   455,  456,   41,  359,  365,  185,   33,   37,   35,  246,
 /*   550 */   336,  367,  336,  189,  118,  360,  372,  246,  374,  404,
 /*   560 */    59,   60,   61,   62,  350,  162,  350,  192,  193,  133,
 /*   570 */   134,   58,    8,    9,  208,  329,   12,   13,   14,   15,
 /*   580 */    16,  367,  398,  367,   71,  430,  402,   20,  340,  405,
 /*   590 */   406,  407,  408,  409,  410,  367,  412,   96,  162,  163,
 /*   600 */   360,  417,   58,  419,  168,  169,  378,  423,  424,   99,
 /*   610 */   362,  101,  102,  431,  104,  404,  164,  435,  108,  183,
 /*   620 */     4,  185,   22,  257,  258,  259,  260,  261,   64,  445,
 /*   630 */   393,  118,  450,  451,  348,   35,  135,  455,  456,   95,
 /*   640 */   130,  430,   98,   20,  208,  209,  108,  211,  212,  213,
 /*   650 */   214,  215,  216,  217,  218,  219,  220,  221,  222,  223,
 /*   660 */   224,  225,  226,  227,  228,   12,   13,   14,  130,  105,
 /*   670 */   108,   71,   21,   20,   80,   22,  175,  176,  177,  369,
 /*   680 */   128,  180,  372,  328,  328,   34,   33,   36,   35,  127,
 /*   690 */   128,  129,  130,  131,  132,  336,  183,  328,  185,  198,
 /*   700 */   161,  230,  201,  232,  203,  204,  205,  206,  207,  350,
 /*   710 */   352,   58,  351,  355,  416,  359,  418,  416,  118,  418,
 /*   720 */   359,  208,  209,  367,   71,  161,  367,  372,  372,  368,
 /*   730 */   374,  164,  138,  139,  221,  222,  223,  224,  225,  226,
 /*   740 */   227,  372,  190,  191,  359,  336,  194,  246,  196,   96,
 /*   750 */   336,  328,  351,  368,  398,   20,  133,  134,  402,  350,
 /*   760 */   359,  405,  406,  407,  408,  409,  410,  369,  412,  368,
 /*   770 */   372,  118,  233,  417,  328,  419,  367,  345,  346,  423,
 /*   780 */   424,  367,  243,  183,   44,  185,  133,  134,    0,   39,
 /*   790 */   434,  168,  169,  328,  347,  372,  349,  233,  234,  235,
 /*   800 */   236,  237,  238,  239,  240,  241,  242,  243,  208,  209,
 /*   810 */    12,   13,   14,   15,   16,  162,  163,    0,  372,  336,
 /*   820 */    20,  168,  169,  382,    8,    9,    0,    0,   12,   13,
 /*   830 */    14,   15,   16,  350,   45,   46,  183,  372,  185,   22,
 /*   840 */   426,  427,  428,  429,    3,  431,  432,    8,    9,    0,
 /*   850 */   367,   12,   13,   14,   15,   16,  328,  328,  328,   44,
 /*   860 */   328,  208,  209,  247,  211,  212,  213,  214,  215,  216,
 /*   870 */   217,  218,  219,  220,  221,  222,  223,  224,  225,  226,
 /*   880 */   227,  228,   12,   13,  244,  245,   42,   42,   44,   44,
 /*   890 */    20,  328,   22,  336,  336,  336,  108,   48,   22,  164,
 /*   900 */   372,  372,  372,   33,  372,   35,   64,  350,  350,  350,
 /*   910 */   459,   35,   97,   97,  448,  127,  128,  129,  130,  131,
 /*   920 */   132,   44,  359,  328,  367,  367,  367,   35,   58,  336,
 /*   930 */   367,  164,  389,  336,  108,  372,   97,  374,  171,  107,
 /*   940 */    35,   71,  338,  350,    8,    9,  328,  350,   12,   13,
 /*   950 */    14,   15,   16,  127,  128,  129,  130,  131,  132,  389,
 /*   960 */   367,  398,  162,    0,  367,  402,   96,  372,  405,  406,
 /*   970 */   407,  408,  409,  410,  431,  412,   71,  336,  435,  152,
 /*   980 */   417,  359,  419,  328,  328,   22,  423,  424,  118,  157,
 /*   990 */   372,  350,  328,  450,  451,  245,  328,  434,  455,  456,
 /*  1000 */     2,  431,    0,  133,  134,  435,    8,    9,  367,  269,
 /*  1010 */    12,   13,   14,   15,   16,  359,  100,  133,  134,  103,
 /*  1020 */   450,  451,   13,  367,   22,  455,  456,  372,  372,  336,
 /*  1030 */   374,  328,  162,  163,  100,    2,  372,  103,  168,  169,
 /*  1040 */   372,    8,    9,  350,   35,   12,   13,   14,   15,   16,
 /*  1050 */   208,   44,   13,  183,  398,  185,  100,  328,  402,  103,
 /*  1060 */   367,  405,  406,  407,  408,  409,  410,  411,  412,  413,
 /*  1070 */   414,  389,  336,  100,   35,  372,  103,  185,  208,  209,
 /*  1080 */   442,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*  1090 */   220,  221,  222,  223,  224,  225,  226,  227,  228,   12,
 /*  1100 */    13,  372,   58,  367,   97,  336,  265,   20,  328,   22,
 /*  1110 */    47,  175,  336,  431,  389,   96,   44,  435,   44,  350,
 /*  1120 */    33,   44,   35,    8,    9,  106,  350,   12,   13,   14,
 /*  1130 */    15,   16,  450,  451,  338,  336,  367,  455,  456,  359,
 /*  1140 */    44,  336,   98,  367,  267,   58,  382,  367,  335,  350,
 /*  1150 */   371,  433,  372,    0,  374,  350,  431,   44,   71,   96,
 /*  1160 */   435,  452,   44,  427,  428,  429,  367,  431,  432,   97,
 /*  1170 */   425,   97,  367,   44,   97,  450,  451,  382,  398,  436,
 /*  1180 */   455,  456,  402,   96,  400,  405,  406,  407,  408,  409,
 /*  1190 */   410,  389,  412,   97,    1,    2,  248,  417,   48,  419,
 /*  1200 */   399,  328,   49,  423,  424,  118,  270,   44,   44,   44,
 /*  1210 */    97,   44,   44,   44,  434,   97,   44,  181,   42,  391,
 /*  1220 */   133,  134,  379,    8,    9,   20,   97,   12,   13,   14,
 /*  1230 */    15,   16,  359,  431,  382,  379,  161,  435,  377,   20,
 /*  1240 */   367,  379,  336,  336,  377,  372,  377,  374,  336,  162,
 /*  1250 */   163,    0,  450,  451,   94,  168,  169,  455,  456,  344,
 /*  1260 */    97,   97,   97,  336,   97,   97,   97,  336,  336,   97,
 /*  1270 */   183,  398,  185,   20,  330,  402,  330,   20,  405,  406,
 /*  1280 */   407,  408,  409,  410,  395,  412,   20,  342,  374,  342,
 /*  1290 */    20,  337,  419,  390,   20,  208,  209,  424,  211,  212,
 /*  1300 */   213,  214,  215,  216,  217,  218,  219,  220,  221,  222,
 /*  1310 */   223,  224,  225,  226,  227,  228,  328,   66,   67,   68,
 /*  1320 */    69,   70,  342,   72,   73,   74,   75,   76,   77,   78,
 /*  1330 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*  1340 */    89,   90,   91,   92,   52,  337,  342,  359,  361,  336,
 /*  1350 */   330,  359,  342,  342,  342,  367,  339,  339,  359,  372,
 /*  1360 */   372,  330,  374,  336,  359,  359,  372,  372,  197,  397,
 /*  1370 */   395,  188,  340,  359,  359,  359,  394,  374,  340,  164,
 /*  1380 */   359,  359,  328,  359,  359,  336,  398,  256,  401,  402,
 /*  1390 */   402,  441,  255,  405,  406,  407,  408,  409,  410,  412,
 /*  1400 */   412,  372,  441,  262,  444,  417,  372,  419,  382,  372,
 /*  1410 */   382,  423,  424,  359,  372,  385,  174,  443,  441,  264,
 /*  1420 */   385,  367,  434,  440,  263,  439,  372,  249,  374,  438,
 /*  1430 */   271,  460,  454,  245,  268,  367,  328,  453,   20,  266,
 /*  1440 */   400,  336,  340,  337,  385,  404,  385,  166,  372,  383,
 /*  1450 */   372,  372,  398,  372,  372,  372,  402,  340,  355,  405,
 /*  1460 */   406,  407,  408,  409,  410,  340,  412,  359,  367,   96,
 /*  1470 */   422,  417,   96,  419,  363,  367,  372,  423,  424,  349,
 /*  1480 */   372,  336,  374,  340,   36,  331,  330,  392,  396,  353,
 /*  1490 */   341,  353,  353,  386,    0,  386,  326,    0,  190,    0,
 /*  1500 */     0,   42,    0,   35,  202,   35,  398,  328,   35,   35,
 /*  1510 */   402,  202,    0,  405,  406,  407,  408,  409,  410,   35,
 /*  1520 */   412,   35,  202,    0,  202,  417,   35,  419,    0,    0,
 /*  1530 */    22,  423,  424,    0,  328,  185,   35,  183,  359,    0,
 /*  1540 */     0,  179,  178,    0,    0,   47,  367,    0,    0,    0,
 /*  1550 */     0,  372,   42,  374,    0,    0,    0,    0,    0,    0,
 /*  1560 */     0,  152,   35,    0,  152,  359,    0,    0,    0,    0,
 /*  1570 */     0,    0,    0,  367,    0,    0,    0,  398,  372,    0,
 /*  1580 */   374,  402,    0,    0,  405,  406,  407,  408,  409,  410,
 /*  1590 */     0,  412,    0,   42,    0,    0,  417,  136,  419,    0,
 /*  1600 */     0,  328,  423,  424,  398,    0,   22,    0,  402,    0,
 /*  1610 */     0,  405,  406,  407,  408,  409,  410,    0,  412,    0,
 /*  1620 */     0,   35,   58,    0,  328,  419,    0,    0,    0,  423,
 /*  1630 */   424,   58,  359,   42,   47,   58,   14,   39,   14,    0,
 /*  1640 */   367,    0,   39,   47,   40,  372,   44,  374,   47,    0,
 /*  1650 */     0,   39,  174,    0,    0,  359,    0,    0,   65,    0,
 /*  1660 */    35,   48,    0,  367,   35,    0,   48,   35,  372,   39,
 /*  1670 */   374,  398,   39,   39,    0,  402,   39,   35,  405,  406,
 /*  1680 */   407,  408,  409,  410,   48,  412,   48,    0,    0,    0,
 /*  1690 */     0,  328,  419,  105,  398,   35,  423,  424,  402,   22,
 /*  1700 */     0,  405,  406,  407,  408,  409,  410,   44,  412,  103,
 /*  1710 */    35,  328,   44,   35,   35,  419,   35,   35,   35,  423,
 /*  1720 */   424,   22,  359,    0,   22,    0,   35,   22,    0,   22,
 /*  1730 */   367,   35,    0,   35,   50,  372,    0,  374,   35,    0,
 /*  1740 */    22,   20,  359,   35,   35,   97,    0,  195,   96,  164,
 /*  1750 */   367,   35,    0,   22,    0,  372,    0,  374,    3,   44,
 /*  1760 */    96,  398,   96,  250,   97,  402,  186,  229,  405,  406,
 /*  1770 */   407,  408,  409,  410,  166,  412,  254,   97,  164,  164,
 /*  1780 */    47,  398,   44,  172,   44,  402,   44,  171,  405,  406,
 /*  1790 */   407,  408,  409,  410,   97,  412,   47,   96,    3,   35,
 /*  1800 */   328,   97,  171,  250,   44,   35,   96,   96,   96,  446,
 /*  1810 */   447,   97,  250,   35,   97,   35,   35,   97,   35,   97,
 /*  1820 */    47,   44,   47,    0,    0,  244,    0,   97,  167,    0,
 /*  1830 */    96,  359,   97,   96,  165,   39,   47,   96,   44,  367,
 /*  1840 */   457,  458,    2,   96,  372,   97,  374,   96,   35,  106,
 /*  1850 */   229,  208,   22,   96,  328,   96,   47,   47,   97,   96,
 /*  1860 */    22,  210,   97,   96,   96,   96,  231,   35,   97,  229,
 /*  1870 */   398,   97,   96,  107,  402,   22,   97,  405,  406,  407,
 /*  1880 */   408,  409,  410,   35,  412,  359,   96,   35,   97,   96,
 /*  1890 */    44,   35,   35,  367,   97,   96,   35,   97,  372,   96,
 /*  1900 */   374,   96,   96,   96,  120,  120,  328,  120,  120,   22,
 /*  1910 */   108,   35,   65,   64,   35,   35,   35,   35,   35,  447,
 /*  1920 */    35,   35,   71,   35,  398,  328,   35,   93,  402,   35,
 /*  1930 */    22,  405,  406,  407,  408,  409,  410,  359,  412,   44,
 /*  1940 */    35,   35,   71,   22,   35,  367,   35,   35,   35,   35,
 /*  1950 */   372,   35,  374,   35,   35,   35,  359,    0,   35,    0,
 /*  1960 */    35,  364,    0,   48,  367,   48,   39,   39,   35,  372,
 /*  1970 */    48,  374,    0,   39,   35,  449,  398,   48,    0,   39,
 /*  1980 */   402,   35,   35,  405,  406,  407,  408,  409,  410,    0,
 /*  1990 */   412,   22,   21,  461,   21,  398,   22,   22,  461,  402,
 /*  2000 */   328,   20,  405,  406,  407,  408,  409,  410,  461,  412,
 /*  2010 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2020 */   328,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2030 */   461,  359,  461,  461,  461,  461,  458,  461,  461,  367,
 /*  2040 */   461,  461,  461,  461,  372,  461,  374,  461,  461,  461,
 /*  2050 */   461,  359,  461,  461,  461,  461,  364,  461,  461,  367,
 /*  2060 */   461,  461,  461,  461,  372,  461,  374,  461,  461,  461,
 /*  2070 */   398,  461,  461,  461,  402,  461,  461,  405,  406,  407,
 /*  2080 */   408,  409,  410,  461,  412,  461,  414,  461,  461,  461,
 /*  2090 */   398,  461,  461,  461,  402,  461,  461,  405,  406,  407,
 /*  2100 */   408,  409,  410,  461,  412,  461,  461,  461,  461,  461,
 /*  2110 */   328,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2120 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  328,
 /*  2130 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2140 */   461,  359,  461,  461,  461,  461,  364,  461,  461,  367,
 /*  2150 */   461,  461,  461,  461,  372,  461,  374,  461,  461,  461,
 /*  2160 */   359,  461,  461,  461,  461,  461,  461,  461,  367,  461,
 /*  2170 */   461,  461,  461,  372,  461,  374,  461,  461,  461,  461,
 /*  2180 */   398,  461,  461,  328,  402,  461,  461,  405,  406,  407,
 /*  2190 */   408,  409,  410,  461,  412,  461,  461,  461,  461,  398,
 /*  2200 */   461,  461,  461,  402,  461,  461,  405,  406,  407,  408,
 /*  2210 */   409,  410,  461,  412,  359,  461,  461,  461,  461,  461,
 /*  2220 */   461,  461,  367,  461,  461,  461,  461,  372,  461,  374,
 /*  2230 */   461,  461,  461,  461,  461,  328,  461,  461,  461,  461,
 /*  2240 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2250 */   461,  461,  461,  398,  328,  461,  461,  402,  461,  461,
 /*  2260 */   405,  406,  407,  408,  409,  410,  359,  412,  461,  461,
 /*  2270 */   461,  461,  461,  461,  367,  461,  461,  461,  461,  372,
 /*  2280 */   461,  374,  461,  461,  461,  359,  461,  461,  461,  461,
 /*  2290 */   461,  461,  461,  367,  461,  461,  461,  461,  372,  461,
 /*  2300 */   374,  461,  461,  461,  461,  398,  461,  461,  461,  402,
 /*  2310 */   461,  461,  405,  406,  407,  408,  409,  410,  461,  412,
 /*  2320 */   461,  461,  461,  461,  398,  461,  461,  461,  402,  328,
 /*  2330 */   461,  405,  406,  407,  408,  409,  410,  461,  412,  461,
 /*  2340 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  328,
 /*  2350 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2360 */   359,  461,  461,  461,  461,  461,  461,  461,  367,  461,
 /*  2370 */   461,  461,  461,  372,  461,  374,  461,  461,  461,  461,
 /*  2380 */   359,  461,  461,  461,  461,  461,  461,  461,  367,  461,
 /*  2390 */   461,  461,  461,  372,  461,  374,  461,  461,  461,  398,
 /*  2400 */   461,  461,  461,  402,  461,  461,  405,  406,  407,  408,
 /*  2410 */   409,  410,  461,  412,  461,  328,  461,  461,  461,  398,
 /*  2420 */   461,  461,  461,  402,  461,  461,  405,  406,  407,  408,
 /*  2430 */   409,  410,  461,  412,  461,  461,  461,  461,  461,  461,
 /*  2440 */   461,  461,  461,  461,  461,  461,  359,  461,  461,  461,
 /*  2450 */   461,  461,  461,  461,  367,  461,  461,  461,  461,  372,
 /*  2460 */   461,  374,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2470 */   328,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2480 */   461,  461,  461,  461,  461,  398,  461,  461,  461,  402,
 /*  2490 */   461,  461,  405,  406,  407,  408,  409,  410,  461,  412,
 /*  2500 */   461,  359,  461,  461,  461,  461,  461,  461,  461,  367,
 /*  2510 */   461,  461,  461,  461,  372,  461,  374,  461,  461,  461,
 /*  2520 */   461,  461,  461,  461,  461,  461,  461,  461,  328,  461,
 /*  2530 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2540 */   398,  461,  461,  461,  402,  461,  461,  405,  406,  407,
 /*  2550 */   408,  409,  410,  461,  412,  461,  461,  461,  461,  359,
 /*  2560 */   461,  461,  461,  461,  461,  461,  461,  367,  461,  461,
 /*  2570 */   461,  461,  372,  461,  374,  461,  461,  461,  461,  461,
 /*  2580 */   461,  461,  328,  461,  461,  461,  461,  461,  461,  461,
 /*  2590 */   461,  461,  461,  461,  461,  461,  461,  461,  398,  461,
 /*  2600 */   461,  461,  402,  328,  461,  405,  406,  407,  408,  409,
 /*  2610 */   410,  461,  412,  359,  461,  461,  461,  461,  461,  461,
 /*  2620 */   461,  367,  461,  461,  461,  461,  372,  461,  374,  461,
 /*  2630 */   461,  461,  461,  461,  359,  461,  461,  461,  461,  461,
 /*  2640 */   461,  461,  367,  461,  461,  461,  461,  372,  461,  374,
 /*  2650 */   461,  461,  398,  461,  461,  461,  402,  328,  461,  405,
 /*  2660 */   406,  407,  408,  409,  410,  461,  412,  461,  461,  461,
 /*  2670 */   461,  461,  461,  398,  461,  461,  461,  402,  328,  461,
 /*  2680 */   405,  406,  407,  408,  409,  410,  461,  412,  359,  461,
 /*  2690 */   461,  461,  461,  461,  461,  461,  367,  461,  461,  461,
 /*  2700 */   461,  372,  461,  374,  461,  461,  461,  461,  461,  359,
 /*  2710 */   461,  461,  461,  461,  461,  461,  461,  367,  461,  461,
 /*  2720 */   461,  461,  372,  461,  374,  461,  461,  398,  461,  461,
 /*  2730 */   461,  402,  328,  461,  405,  406,  407,  408,  409,  410,
 /*  2740 */   461,  412,  461,  461,  461,  461,  461,  461,  398,  461,
 /*  2750 */   461,  461,  402,  461,  461,  405,  406,  407,  408,  409,
 /*  2760 */   410,   19,  412,  359,  461,  461,  461,  461,  461,  461,
 /*  2770 */   461,  367,  461,  461,  461,   33,  372,  461,  374,  461,
 /*  2780 */   461,  461,  461,  461,  461,  461,  461,  461,  328,  461,
 /*  2790 */    48,  461,  461,  461,  461,  461,   54,   55,   56,   57,
 /*  2800 */    58,  461,  398,  461,  461,  461,  402,  461,  461,  405,
 /*  2810 */   406,  407,  408,  409,  410,  461,  412,  461,  461,  359,
 /*  2820 */   461,  461,  461,  461,  461,  461,  461,  367,  461,  461,
 /*  2830 */   461,  461,  372,  461,  374,  461,  461,   95,  461,  461,
 /*  2840 */    98,  461,  461,  328,  461,  461,  461,  461,  461,  461,
 /*  2850 */   461,  461,  461,  461,  461,  461,  461,  461,  398,  461,
 /*  2860 */   461,  461,  402,  461,  461,  405,  406,  407,  408,  409,
 /*  2870 */   410,  461,  412,  131,  359,  461,  461,  461,  461,  461,
 /*  2880 */   461,  461,  367,  461,  461,  461,  461,  372,  461,  374,
 /*  2890 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2900 */   461,  328,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2910 */   461,  461,  170,  398,  461,  461,  461,  402,  461,  461,
 /*  2920 */   405,  406,  407,  408,  409,  410,  461,  412,  461,  187,
 /*  2930 */   461,  189,  359,  461,  461,  461,  461,  461,  461,  461,
 /*  2940 */   367,  461,  461,  461,  461,  372,  461,  374,  461,  461,
 /*  2950 */   461,  461,  461,  461,  461,  328,  461,  461,  461,  461,
 /*  2960 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2970 */   461,  398,  461,  461,  461,  402,  328,  461,  405,  406,
 /*  2980 */   407,  408,  409,  410,  461,  412,  359,  461,  461,  461,
 /*  2990 */   461,  461,  461,  461,  367,  461,  461,  461,  461,  372,
 /*  3000 */   461,  374,  461,  461,  461,  461,  461,  359,  461,  461,
 /*  3010 */   461,  461,  461,  461,  461,  367,  461,  461,  461,  461,
 /*  3020 */   372,  461,  374,  461,  461,  398,  461,  461,  461,  402,
 /*  3030 */   328,  461,  405,  406,  407,  408,  409,  410,  461,  412,
 /*  3040 */   461,  461,  461,  461,  461,  461,  398,  461,  461,  461,
 /*  3050 */   402,  328,  461,  405,  406,  407,  408,  409,  410,  461,
 /*  3060 */   412,  359,  461,  461,  461,  461,  461,  461,  461,  367,
 /*  3070 */   461,  461,  461,  461,  372,  461,  374,  461,  461,  461,
 /*  3080 */   461,  461,  359,  461,  461,  461,  461,  461,  461,  461,
 /*  3090 */   367,  461,  461,  461,  461,  372,  461,  374,  461,  461,
 /*  3100 */   398,  461,  461,  461,  402,  328,  461,  405,  406,  407,
 /*  3110 */   408,  409,  410,  461,  412,  461,  461,  461,  461,  461,
 /*  3120 */   461,  398,  461,  461,  461,  402,  461,  461,  405,  406,
 /*  3130 */   407,  408,  409,  410,  461,  412,  359,  461,  461,  461,
 /*  3140 */   461,  461,  461,  461,  367,  461,  461,  461,  461,  372,
 /*  3150 */   461,  374,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  3160 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  3170 */   461,  461,  461,  461,  461,  398,  461,  461,  461,  402,
 /*  3180 */   461,  461,  405,  406,  407,  408,  409,  410,  461,  412,
};
#define YY_SHIFT_COUNT    (716)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2742)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   501,    0,  217,    0,  436,  436,  436,  436,  436,  436,
 /*    10 */   436,  436,  436,  436,  436,  653,  870,  870, 1087,  870,
 /*    20 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*    30 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*    40 */   870,  870,  870,  870,  870,  870,  870,  870,   69,  135,
 /*    50 */    17,  311,  178,  170,  200,  170,   17,   17,  513,  513,
 /*    60 */   170,  513,  513,  303,  170,  623,   28,   28,  623,   22,
 /*    70 */    22,  229,  110,  153,  153,   28,   28,   28,   28,   28,
 /*    80 */    28,   28,   28,   28,   28,   42,   28,   28,   58,   28,
 /*    90 */    28,   28,  115,   28,   28,  115,   28,  115,  115,  115,
 /*   100 */    28,   93,  215,  564,  564,  230,  443,  600,  600,  600,
 /*   110 */   600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
 /*   120 */   600,  600,  600,  600,  600,  600,  510,  144,  229,  110,
 /*   130 */    32,  175,  452,  452,  452,  341,  471,  471,  175,  250,
 /*   140 */   250,  250,  180,   52,  115,  223,  115,  223,  223,  180,
 /*   150 */   278,   78,   78,   78,   78,   78,   78,   78, 2742,  150,
 /*   160 */   205,  289,  936,  366,  218,   67,  152,  403,  376,  567,
 /*   170 */   789,  538,  735,  640,  750,  841,  640,  844,  616,  800,
 /*   180 */   948, 1150, 1036, 1176, 1205, 1176, 1075, 1219, 1219, 1176,
 /*   190 */  1075, 1075, 1219, 1160, 1219, 1219, 1219, 1253, 1253, 1257,
 /*   200 */    42, 1266,   42, 1270, 1274,   42, 1270,   42,   42,   42,
 /*   210 */  1219,   42, 1292, 1292, 1253,  115,  115,  115,  115,  115,
 /*   220 */   115,  115,  115,  115,  115,  115, 1219, 1253,  223,  223,
 /*   230 */  1171, 1257,   93, 1183, 1266,   93, 1219, 1205, 1205,  223,
 /*   240 */  1131, 1137,  223, 1131, 1137,  223,  223,  115, 1141, 1242,
 /*   250 */  1131, 1155, 1161, 1178,  948, 1159, 1166, 1173, 1188,  250,
 /*   260 */  1418, 1219, 1270,   93, 1137,  223,  223,  223,  223,  223,
 /*   270 */  1137,  223, 1281,   93,  180,   93,  250, 1373, 1376,  223,
 /*   280 */   278, 1219,   93, 1448, 1253, 3190, 3190, 3190, 3190, 3190,
 /*   290 */  3190, 3190, 3190, 3190, 1251,  364,   97,   21,  816,   15,
 /*   300 */   839,  788,  998, 1033, 1215,  826, 1115, 1115, 1115, 1115,
 /*   310 */  1115, 1115, 1115, 1115, 1115,  562,  552,  798,  798,  134,
 /*   320 */   544,  594,  651,  375,  255,  255,  145,  404,  539,  145,
 /*   330 */   145,  145,  815,  849,  876,  845,  832,  827,  916,  934,
 /*   340 */   956,  973,  817,  963, 1002, 1044, 1007, 1072,  884,  877,
 /*   350 */   740,  767, 1074, 1077, 1096, 1113, 1118, 1193, 1129,  360,
 /*   360 */   892,  842, 1163, 1063, 1164, 1165, 1167, 1168, 1169, 1172,
 /*   370 */  1019, 1009, 1039,  905, 1153, 1494, 1497, 1308, 1499, 1500,
 /*   380 */  1459, 1502, 1468, 1302, 1470, 1473, 1474, 1309, 1512, 1484,
 /*   390 */  1486, 1320, 1523, 1322, 1528, 1491, 1529, 1508, 1533, 1501,
 /*   400 */  1350, 1354, 1539, 1540, 1362, 1364, 1543, 1544, 1498, 1547,
 /*   410 */  1548, 1549, 1510, 1550, 1554, 1555, 1556, 1557, 1558, 1559,
 /*   420 */  1560, 1409, 1527, 1563, 1412, 1566, 1567, 1568, 1569, 1570,
 /*   430 */  1571, 1572, 1574, 1575, 1576, 1579, 1582, 1583, 1590, 1592,
 /*   440 */  1551, 1594, 1595, 1599, 1600, 1605, 1584, 1607, 1609, 1610,
 /*   450 */  1461, 1617, 1619, 1620, 1564, 1586, 1623, 1573, 1626, 1577,
 /*   460 */  1627, 1628, 1591, 1598, 1602, 1587, 1622, 1596, 1624, 1601,
 /*   470 */  1639, 1604, 1603, 1641, 1649, 1650, 1612, 1478, 1653, 1654,
 /*   480 */  1656, 1593, 1657, 1659, 1625, 1613, 1630, 1662, 1629, 1618,
 /*   490 */  1633, 1665, 1632, 1636, 1634, 1674, 1642, 1638, 1637, 1687,
 /*   500 */  1688, 1689, 1690, 1588, 1606, 1660, 1677, 1700, 1675, 1678,
 /*   510 */  1679, 1681, 1663, 1668, 1682, 1683, 1699, 1691, 1723, 1702,
 /*   520 */  1725, 1705, 1684, 1728, 1707, 1696, 1732, 1698, 1736, 1703,
 /*   530 */  1739, 1718, 1721, 1708, 1709, 1552, 1648, 1652, 1746, 1585,
 /*   540 */  1716, 1752, 1580, 1731, 1614, 1608, 1754, 1756, 1615, 1611,
 /*   550 */  1755, 1715, 1513, 1664, 1667, 1666, 1616, 1538, 1631, 1522,
 /*   560 */  1680, 1738, 1697, 1701, 1710, 1711, 1704, 1740, 1733, 1749,
 /*   570 */  1712, 1742, 1553, 1714, 1717, 1795, 1760, 1562, 1764, 1770,
 /*   580 */  1778, 1780, 1781, 1783, 1720, 1722, 1773, 1581, 1777, 1775,
 /*   590 */  1823, 1824, 1826, 1734, 1730, 1735, 1737, 1741, 1661, 1747,
 /*   600 */  1829, 1796, 1669, 1751, 1743, 1587, 1789, 1794, 1621, 1635,
 /*   610 */  1640, 1840, 1830, 1643, 1757, 1748, 1759, 1761, 1763, 1765,
 /*   620 */  1809, 1767, 1768, 1810, 1771, 1838, 1651, 1769, 1766, 1774,
 /*   630 */  1813, 1832, 1776, 1779, 1848, 1790, 1791, 1852, 1793, 1797,
 /*   640 */  1856, 1799, 1800, 1857, 1803, 1784, 1785, 1787, 1788, 1853,
 /*   650 */  1802, 1805, 1846, 1806, 1861, 1807, 1846, 1846, 1887, 1847,
 /*   660 */  1849, 1876, 1879, 1880, 1881, 1882, 1883, 1885, 1886, 1888,
 /*   670 */  1891, 1851, 1834, 1895, 1894, 1905, 1906, 1908, 1909, 1911,
 /*   680 */  1912, 1871, 1663, 1913, 1668, 1914, 1916, 1918, 1919, 1921,
 /*   690 */  1920, 1957, 1923, 1915, 1927, 1959, 1925, 1917, 1928, 1962,
 /*   700 */  1933, 1922, 1934, 1972, 1939, 1929, 1940, 1978, 1946, 1947,
 /*   710 */  1989, 1969, 1971, 1974, 1975, 1973, 1981,
};
#define YY_REDUCE_COUNT (293)
#define YY_REDUCE_MIN   (-369)
#define YY_REDUCE_MAX   (2777)
static const short yy_reduce_ofst[] = {
 /*     0 */   -42, -325, -266,  184,  -81,  356,  563,  780,  988, 1054,
 /*    10 */  1108, 1179, 1206, 1273, 1296,  656, 1363, 1383,  873, 1472,
 /*    20 */  1526, 1578, 1597, 1672, 1692, 1782, 1801, 1855, 1907, 1926,
 /*    30 */  2001, 2021, 2087, 2142, 2200, 2254, 2275, 2329, 2350, 2404,
 /*    40 */  2460, 2515, 2573, 2627, 2648, 2702, 2723, 2777,   48,   35,
 /*    50 */   414,  543,  570,  682,  725,  802,   36,  736, -357, -351,
 /*    60 */   182,  -24,  987, -365,   85, -331, -219,  -51, -369, -326,
 /*    70 */  -296, -271, -298, -233, -222,  156,  214,  216,  359,  409,
 /*    80 */   557,  558,  559,  593,  597, -158,  641,  693,  -67,  769,
 /*    90 */   776,  799, -214,  138,  146, -359,  483,  361,  -36,  401,
 /*   100 */   805,   -8, -335,  -76,  -76,  123, -241,  -61,   83,  159,
 /*   110 */   355,  369,  423,  446,  465,  528,  529,  530,  532,  595,
 /*   120 */   618,  655,  664,  668,  703,  729,  -94, -198,   92,   87,
 /*   130 */   179,  169, -198,  155,  211,  248,  298,  301,  432,  111,
 /*   140 */   130,  228, -292,   39,  385,  112, -189,  310,  398,  358,
 /*   150 */   447, -358, -349, -343,   16,   30,  195,  240,  237,  246,
 /*   160 */   286,  441,  451,  466,  604,  638,  622,  622,  796,  764,
 /*   170 */   813,  779,  795,  718,  718,  709,  718,  745,  743,  622,
 /*   180 */   784,  801,  828,  843,  852,  856,  861,  906,  907,  862,
 /*   190 */   867,  869,  912,  915,  927,  931,  932,  944,  946,  889,
 /*   200 */   945,  914,  947,  954,  903,  980, 1008, 1004, 1010, 1011,
 /*   210 */  1013, 1012, 1017, 1018, 1020,  992,  999, 1005, 1006, 1014,
 /*   220 */  1015, 1016, 1021, 1022, 1024, 1025, 1027, 1031,  994,  995,
 /*   230 */   972,  975, 1032,  982, 1003, 1038, 1049, 1026, 1028, 1029,
 /*   240 */   950, 1030, 1034,  961, 1035, 1037, 1042,  622,  960,  974,
 /*   250 */   977,  983,  986,  991, 1040,  971,  978,  984,  718, 1068,
 /*   260 */  1041, 1105, 1106, 1102, 1059, 1076, 1078, 1079, 1081, 1082,
 /*   270 */  1061, 1083, 1066, 1117, 1103, 1125, 1101, 1048, 1111, 1104,
 /*   280 */  1130, 1145, 1143, 1154, 1156, 1095, 1092, 1107, 1109, 1136,
 /*   290 */  1138, 1139, 1149, 1170,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*    10 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*    20 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*    30 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*    40 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*    50 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*    60 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*    70 */  1610, 1866, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*    80 */  1610, 1610, 1610, 1610, 1610, 1689, 1610, 1610, 1610, 1610,
 /*    90 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   100 */  1610, 1687, 1859, 2062, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   110 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   120 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 2074, 1610, 1610,
 /*   130 */  1689, 1610, 2074, 2074, 2074, 1687, 2034, 2034, 1610, 1610,
 /*   140 */  1610, 1610, 1796, 1610, 1610, 1610, 1610, 1610, 1610, 1796,
 /*   150 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1908, 1610,
 /*   160 */  1610, 2099, 2153, 1610, 1610, 2102, 1610, 1610, 1610, 1871,
 /*   170 */  1610, 1749, 2089, 2066, 2080, 2137, 2067, 2064, 2083, 1610,
 /*   180 */  2093, 1610, 1901, 1864, 1610, 1864, 1861, 1610, 1610, 1864,
 /*   190 */  1861, 1861, 1610, 1740, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   200 */  1689, 1610, 1689, 1610, 1610, 1689, 1610, 1689, 1689, 1689,
 /*   210 */  1610, 1689, 1667, 1667, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   220 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   230 */  1921, 1610, 1687, 1910, 1610, 1687, 1610, 1610, 1610, 1610,
 /*   240 */  2110, 2108, 1610, 2110, 2108, 1610, 1610, 1610, 2122, 2118,
 /*   250 */  2110, 2126, 2124, 2095, 2093, 2156, 2143, 2139, 2080, 1610,
 /*   260 */  1610, 1610, 1610, 1687, 2108, 1610, 1610, 1610, 1610, 1610,
 /*   270 */  2108, 1610, 1610, 1687, 1610, 1687, 1610, 1610, 1765, 1610,
 /*   280 */  1610, 1610, 1687, 1642, 1610, 1903, 1914, 1886, 1886, 1799,
 /*   290 */  1799, 1799, 1690, 1615, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   300 */  1610, 1610, 1610, 1610, 1610, 1610, 2121, 2120, 1989, 1610,
 /*   310 */  2038, 2037, 2036, 2027, 1988, 1761, 1610, 1987, 1986, 1610,
 /*   320 */  1610, 1610, 1610, 1610, 1877, 1876, 1980, 1610, 1610, 1981,
 /*   330 */  1979, 1978, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   340 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 2140,
 /*   350 */  2144, 1610, 1610, 1610, 1610, 1610, 1610, 2063, 1610, 1610,
 /*   360 */  1610, 1610, 1610, 1963, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   370 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   380 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   390 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   400 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   410 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   420 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   430 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   440 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   450 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   460 */  1610, 1610, 1610, 1610, 1647, 1968, 1610, 1610, 1610, 1610,
 /*   470 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   480 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   490 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   500 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   510 */  1610, 1610, 1728, 1727, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   520 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   530 */  1610, 1610, 1610, 1610, 1610, 1610, 1971, 1610, 1610, 1610,
 /*   540 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   550 */  2136, 2096, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   560 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1963,
 /*   570 */  1610, 2119, 1610, 1610, 2134, 1610, 2138, 1610, 1610, 1610,
 /*   580 */  1610, 1610, 1610, 1610, 2073, 2069, 1610, 1610, 2065, 1610,
 /*   590 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   600 */  1610, 1610, 1610, 1610, 1610, 1962, 1610, 2024, 1610, 1610,
 /*   610 */  1610, 2058, 1610, 1610, 2009, 1610, 1610, 1610, 1610, 1610,
 /*   620 */  1610, 1610, 1610, 1610, 1971, 1610, 1974, 1610, 1610, 1610,
 /*   630 */  1610, 1610, 1793, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   640 */  1610, 1610, 1610, 1610, 1610, 1778, 1776, 1775, 1774, 1610,
 /*   650 */  1771, 1610, 1806, 1610, 1610, 1610, 1802, 1801, 1610, 1610,
 /*   660 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   670 */  1610, 1610, 1610, 1708, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   680 */  1610, 1610, 1700, 1610, 1699, 1610, 1610, 1610, 1610, 1610,
 /*   690 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   700 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*   710 */  1610, 1610, 1610, 1610, 1610, 1610, 1610,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
  272,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*      START => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  272,  /*      AFTER => ABORT */
  272,  /*     ATTACH => ABORT */
  272,  /*     BEFORE => ABORT */
  272,  /*      BEGIN => ABORT */
  272,  /*     BITAND => ABORT */
  272,  /*     BITNOT => ABORT */
  272,  /*      BITOR => ABORT */
  272,  /*     BLOCKS => ABORT */
  272,  /*     CHANGE => ABORT */
  272,  /*      COMMA => ABORT */
  272,  /*     CONCAT => ABORT */
  272,  /*   CONFLICT => ABORT */
  272,  /*       COPY => ABORT */
  272,  /*   DEFERRED => ABORT */
  272,  /* DELIMITERS => ABORT */
  272,  /*     DETACH => ABORT */
  272,  /*     DIVIDE => ABORT */
  272,  /*        DOT => ABORT */
  272,  /*       EACH => ABORT */
  272,  /*       FAIL => ABORT */
  272,  /*       FILE => ABORT */
  272,  /*        FOR => ABORT */
  272,  /*       GLOB => ABORT */
  272,  /*         ID => ABORT */
  272,  /*  IMMEDIATE => ABORT */
  272,  /*     IMPORT => ABORT */
  272,  /*  INITIALLY => ABORT */
  272,  /*    INSTEAD => ABORT */
  272,  /*     ISNULL => ABORT */
  272,  /*        KEY => ABORT */
  272,  /*    MODULES => ABORT */
  272,  /*  NK_BITNOT => ABORT */
  272,  /*    NK_SEMI => ABORT */
  272,  /*    NOTNULL => ABORT */
  272,  /*         OF => ABORT */
  272,  /*       PLUS => ABORT */
  272,  /*  PRIVILEGE => ABORT */
  272,  /*      RAISE => ABORT */
  272,  /*    REPLACE => ABORT */
  272,  /*   RESTRICT => ABORT */
  272,  /*        ROW => ABORT */
  272,  /*       SEMI => ABORT */
  272,  /*       STAR => ABORT */
  272,  /*  STATEMENT => ABORT */
  272,  /*     STRICT => ABORT */
  272,  /*     STRING => ABORT */
  272,  /*      TIMES => ABORT */
  272,  /*     UPDATE => ABORT */
  272,  /*     VALUES => ABORT */
  272,  /*   VARIABLE => ABORT */
  272,  /*       VIEW => ABORT */
  272,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "COMPACT",
  /*   63 */ "IF",
  /*   64 */ "NOT",
  /*   65 */ "EXISTS",
  /*   66 */ "BUFFER",
  /*   67 */ "CACHEMODEL",
  /*   68 */ "CACHESIZE",
  /*   69 */ "COMP",
  /*   70 */ "DURATION",
  /*   71 */ "NK_VARIABLE",
  /*   72 */ "MAXROWS",
  /*   73 */ "MINROWS",
  /*   74 */ "KEEP",
  /*   75 */ "PAGES",
  /*   76 */ "PAGESIZE",
  /*   77 */ "TSDB_PAGESIZE",
  /*   78 */ "PRECISION",
  /*   79 */ "REPLICA",
  /*   80 */ "VGROUPS",
  /*   81 */ "SINGLE_STABLE",
  /*   82 */ "RETENTIONS",
  /*   83 */ "SCHEMALESS",
  /*   84 */ "WAL_LEVEL",
  /*   85 */ "WAL_FSYNC_PERIOD",
  /*   86 */ "WAL_RETENTION_PERIOD",
  /*   87 */ "WAL_RETENTION_SIZE",
  /*   88 */ "WAL_ROLL_PERIOD",
  /*   89 */ "WAL_SEGMENT_SIZE",
  /*   90 */ "STT_TRIGGER",
  /*   91 */ "TABLE_PREFIX",
  /*   92 */ "TABLE_SUFFIX",
  /*   93 */ "NK_COLON",
  /*   94 */ "MAX_SPEED",
  /*   95 */ "TABLE",
  /*   96 */ "NK_LP",
  /*   97 */ "NK_RP",
  /*   98 */ "STABLE",
  /*   99 */ "ADD",
  /*  100 */ "COLUMN",
  /*  101 */ "MODIFY",
  /*  102 */ "RENAME",
  /*  103 */ "TAG",
  /*  104 */ "SET",
  /*  105 */ "NK_EQ",
  /*  106 */ "USING",
  /*  107 */ "TAGS",
  /*  108 */ "COMMENT",
  /*  109 */ "BOOL",
  /*  110 */ "TINYINT",
  /*  111 */ "SMALLINT",
  /*  112 */ "INT",
  /*  113 */ "INTEGER",
  /*  114 */ "BIGINT",
  /*  115 */ "FLOAT",
  /*  116 */ "DOUBLE",
  /*  117 */ "BINARY",
  /*  118 */ "TIMESTAMP",
  /*  119 */ "NCHAR",
  /*  120 */ "UNSIGNED",
  /*  121 */ "JSON",
  /*  122 */ "VARCHAR",
  /*  123 */ "MEDIUMBLOB",
  /*  124 */ "BLOB",
  /*  125 */ "VARBINARY",
  /*  126 */ "DECIMAL",
  /*  127 */ "MAX_DELAY",
  /*  128 */ "WATERMARK",
  /*  129 */ "ROLLUP",
  /*  130 */ "TTL",
  /*  131 */ "SMA",
  /*  132 */ "DELETE_MARK",
  /*  133 */ "FIRST",
  /*  134 */ "LAST",
  /*  135 */ "SHOW",
  /*  136 */ "PRIVILEGES",
  /*  137 */ "DATABASES",
  /*  138 */ "TABLES",
  /*  139 */ "STABLES",
  /*  140 */ "MNODES",
  /*  141 */ "QNODES",
  /*  142 */ "FUNCTIONS",
  /*  143 */ "INDEXES",
  /*  144 */ "ACCOUNTS",
  /*  145 */ "APPS",
  /*  146 */ "CONNECTIONS",
  /*  147 */ "LICENCES",
  /*  148 */ "GRANTS",
  /*  149 */ "QUERIES",
  /*  150 */ "SCORES",
  /*  151 */ "TOPICS",
  /*  152 */ "VARIABLES",
  /*  153 */ "CLUSTER",
  /*  154 */ "BNODES",
  /*  155 */ "SNODES",
  /*  156 */ "TRANSACTIONS",
  /*  157 */ "DISTRIBUTED",
  /*  158 */ "CONSUMERS",
  /*  159 */ "SUBSCRIPTIONS",
  /*  160 */ "VNODES",
  /*  161 */ "LIKE",
  /*  162 */ "TBNAME",
  /*  163 */ "QTAGS",
  /*  164 */ "AS",
  /*  165 */ "INDEX",
  /*  166 */ "FUNCTION",
  /*  167 */ "INTERVAL",
  /*  168 */ "COUNT",
  /*  169 */ "LAST_ROW",
  /*  170 */ "TOPIC",
  /*  171 */ "WITH",
  /*  172 */ "META",
  /*  173 */ "CONSUMER",
  /*  174 */ "GROUP",
  /*  175 */ "DESC",
  /*  176 */ "DESCRIBE",
  /*  177 */ "RESET",
  /*  178 */ "QUERY",
  /*  179 */ "CACHE",
  /*  180 */ "EXPLAIN",
  /*  181 */ "ANALYZE",
  /*  182 */ "VERBOSE",
  /*  183 */ "NK_BOOL",
  /*  184 */ "RATIO",
  /*  185 */ "NK_FLOAT",
  /*  186 */ "OUTPUTTYPE",
  /*  187 */ "AGGREGATE",
  /*  188 */ "BUFSIZE",
  /*  189 */ "STREAM",
  /*  190 */ "INTO",
  /*  191 */ "TRIGGER",
  /*  192 */ "AT_ONCE",
  /*  193 */ "WINDOW_CLOSE",
  /*  194 */ "IGNORE",
  /*  195 */ "EXPIRED",
  /*  196 */ "FILL_HISTORY",
  /*  197 */ "SUBTABLE",
  /*  198 */ "KILL",
  /*  199 */ "CONNECTION",
  /*  200 */ "TRANSACTION",
  /*  201 */ "BALANCE",
  /*  202 */ "VGROUP",
  /*  203 */ "MERGE",
  /*  204 */ "REDISTRIBUTE",
  /*  205 */ "SPLIT",
  /*  206 */ "DELETE",
  /*  207 */ "INSERT",
  /*  208 */ "NULL",
  /*  209 */ "NK_QUESTION",
  /*  210 */ "NK_ARROW",
  /*  211 */ "ROWTS",
  /*  212 */ "QSTART",
  /*  213 */ "QEND",
  /*  214 */ "QDURATION",
  /*  215 */ "WSTART",
  /*  216 */ "WEND",
  /*  217 */ "WDURATION",
  /*  218 */ "IROWTS",
  /*  219 */ "ISFILLED",
  /*  220 */ "CAST",
  /*  221 */ "NOW",
  /*  222 */ "TODAY",
  /*  223 */ "TIMEZONE",
  /*  224 */ "CLIENT_VERSION",
  /*  225 */ "SERVER_VERSION",
  /*  226 */ "SERVER_STATUS",
  /*  227 */ "CURRENT_USER",
  /*  228 */ "CASE",
  /*  229 */ "END",
  /*  230 */ "WHEN",
  /*  231 */ "THEN",
  /*  232 */ "ELSE",
  /*  233 */ "BETWEEN",
  /*  234 */ "IS",
  /*  235 */ "NK_LT",
  /*  236 */ "NK_GT",
  /*  237 */ "NK_LE",
  /*  238 */ "NK_GE",
  /*  239 */ "NK_NE",
  /*  240 */ "MATCH",
  /*  241 */ "NMATCH",
  /*  242 */ "CONTAINS",
  /*  243 */ "IN",
  /*  244 */ "JOIN",
  /*  245 */ "INNER",
  /*  246 */ "SELECT",
  /*  247 */ "DISTINCT",
  /*  248 */ "WHERE",
  /*  249 */ "PARTITION",
  /*  250 */ "BY",
  /*  251 */ "SESSION",
  /*  252 */ "STATE_WINDOW",
  /*  253 */ "EVENT_WINDOW",
  /*  254 */ "START",
  /*  255 */ "SLIDING",
  /*  256 */ "FILL",
  /*  257 */ "VALUE",
  /*  258 */ "NONE",
  /*  259 */ "PREV",
  /*  260 */ "LINEAR",
  /*  261 */ "NEXT",
  /*  262 */ "HAVING",
  /*  263 */ "RANGE",
  /*  264 */ "EVERY",
  /*  265 */ "ORDER",
  /*  266 */ "SLIMIT",
  /*  267 */ "SOFFSET",
  /*  268 */ "LIMIT",
  /*  269 */ "OFFSET",
  /*  270 */ "ASC",
  /*  271 */ "NULLS",
  /*  272 */ "ABORT",
  /*  273 */ "AFTER",
  /*  274 */ "ATTACH",
  /*  275 */ "BEFORE",
  /*  276 */ "BEGIN",
  /*  277 */ "BITAND",
  /*  278 */ "BITNOT",
  /*  279 */ "BITOR",
  /*  280 */ "BLOCKS",
  /*  281 */ "CHANGE",
  /*  282 */ "COMMA",
  /*  283 */ "CONCAT",
  /*  284 */ "CONFLICT",
  /*  285 */ "COPY",
  /*  286 */ "DEFERRED",
  /*  287 */ "DELIMITERS",
  /*  288 */ "DETACH",
  /*  289 */ "DIVIDE",
  /*  290 */ "DOT",
  /*  291 */ "EACH",
  /*  292 */ "FAIL",
  /*  293 */ "FILE",
  /*  294 */ "FOR",
  /*  295 */ "GLOB",
  /*  296 */ "ID",
  /*  297 */ "IMMEDIATE",
  /*  298 */ "IMPORT",
  /*  299 */ "INITIALLY",
  /*  300 */ "INSTEAD",
  /*  301 */ "ISNULL",
  /*  302 */ "KEY",
  /*  303 */ "MODULES",
  /*  304 */ "NK_BITNOT",
  /*  305 */ "NK_SEMI",
  /*  306 */ "NOTNULL",
  /*  307 */ "OF",
  /*  308 */ "PLUS",
  /*  309 */ "PRIVILEGE",
  /*  310 */ "RAISE",
  /*  311 */ "REPLACE",
  /*  312 */ "RESTRICT",
  /*  313 */ "ROW",
  /*  314 */ "SEMI",
  /*  315 */ "STAR",
  /*  316 */ "STATEMENT",
  /*  317 */ "STRICT",
  /*  318 */ "STRING",
  /*  319 */ "TIMES",
  /*  320 */ "UPDATE",
  /*  321 */ "VALUES",
  /*  322 */ "VARIABLE",
  /*  323 */ "VIEW",
  /*  324 */ "WAL",
  /*  325 */ "cmd",
  /*  326 */ "account_options",
  /*  327 */ "alter_account_options",
  /*  328 */ "literal",
  /*  329 */ "alter_account_option",
  /*  330 */ "user_name",
  /*  331 */ "sysinfo_opt",
  /*  332 */ "privileges",
  /*  333 */ "priv_level",
  /*  334 */ "priv_type_list",
  /*  335 */ "priv_type",
  /*  336 */ "db_name",
  /*  337 */ "topic_name",
  /*  338 */ "dnode_endpoint",
  /*  339 */ "force_opt",
  /*  340 */ "not_exists_opt",
  /*  341 */ "db_options",
  /*  342 */ "exists_opt",
  /*  343 */ "alter_db_options",
  /*  344 */ "speed_opt",
  /*  345 */ "integer_list",
  /*  346 */ "variable_list",
  /*  347 */ "retention_list",
  /*  348 */ "alter_db_option",
  /*  349 */ "retention",
  /*  350 */ "full_table_name",
  /*  351 */ "column_def_list",
  /*  352 */ "tags_def_opt",
  /*  353 */ "table_options",
  /*  354 */ "multi_create_clause",
  /*  355 */ "tags_def",
  /*  356 */ "multi_drop_clause",
  /*  357 */ "alter_table_clause",
  /*  358 */ "alter_table_options",
  /*  359 */ "column_name",
  /*  360 */ "type_name",
  /*  361 */ "signed_literal",
  /*  362 */ "create_subtable_clause",
  /*  363 */ "specific_cols_opt",
  /*  364 */ "expression_list",
  /*  365 */ "drop_table_clause",
  /*  366 */ "col_name_list",
  /*  367 */ "table_name",
  /*  368 */ "column_def",
  /*  369 */ "duration_list",
  /*  370 */ "rollup_func_list",
  /*  371 */ "alter_table_option",
  /*  372 */ "duration_literal",
  /*  373 */ "rollup_func_name",
  /*  374 */ "function_name",
  /*  375 */ "col_name",
  /*  376 */ "db_name_cond_opt",
  /*  377 */ "like_pattern_opt",
  /*  378 */ "table_name_cond",
  /*  379 */ "from_db_opt",
  /*  380 */ "tag_list_opt",
  /*  381 */ "tag_item",
  /*  382 */ "column_alias",
  /*  383 */ "index_options",
  /*  384 */ "func_list",
  /*  385 */ "sliding_opt",
  /*  386 */ "sma_stream_opt",
  /*  387 */ "func",
  /*  388 */ "sma_func_name",
  /*  389 */ "query_or_subquery",
  /*  390 */ "cgroup_name",
  /*  391 */ "analyze_opt",
  /*  392 */ "explain_options",
  /*  393 */ "agg_func_opt",
  /*  394 */ "bufsize_opt",
  /*  395 */ "stream_name",
  /*  396 */ "stream_options",
  /*  397 */ "subtable_opt",
  /*  398 */ "expression",
  /*  399 */ "dnode_list",
  /*  400 */ "where_clause_opt",
  /*  401 */ "signed",
  /*  402 */ "literal_func",
  /*  403 */ "literal_list",
  /*  404 */ "table_alias",
  /*  405 */ "expr_or_subquery",
  /*  406 */ "pseudo_column",
  /*  407 */ "column_reference",
  /*  408 */ "function_expression",
  /*  409 */ "case_when_expression",
  /*  410 */ "star_func",
  /*  411 */ "star_func_para_list",
  /*  412 */ "noarg_func",
  /*  413 */ "other_para_list",
  /*  414 */ "star_func_para",
  /*  415 */ "when_then_list",
  /*  416 */ "case_when_else_opt",
  /*  417 */ "common_expression",
  /*  418 */ "when_then_expr",
  /*  419 */ "predicate",
  /*  420 */ "compare_op",
  /*  421 */ "in_op",
  /*  422 */ "in_predicate_value",
  /*  423 */ "boolean_value_expression",
  /*  424 */ "boolean_primary",
  /*  425 */ "from_clause_opt",
  /*  426 */ "table_reference_list",
  /*  427 */ "table_reference",
  /*  428 */ "table_primary",
  /*  429 */ "joined_table",
  /*  430 */ "alias_opt",
  /*  431 */ "subquery",
  /*  432 */ "parenthesized_joined_table",
  /*  433 */ "join_type",
  /*  434 */ "search_condition",
  /*  435 */ "query_specification",
  /*  436 */ "set_quantifier_opt",
  /*  437 */ "select_list",
  /*  438 */ "partition_by_clause_opt",
  /*  439 */ "range_opt",
  /*  440 */ "every_opt",
  /*  441 */ "fill_opt",
  /*  442 */ "twindow_clause_opt",
  /*  443 */ "group_by_clause_opt",
  /*  444 */ "having_clause_opt",
  /*  445 */ "select_item",
  /*  446 */ "partition_list",
  /*  447 */ "partition_item",
  /*  448 */ "fill_mode",
  /*  449 */ "group_by_list",
  /*  450 */ "query_expression",
  /*  451 */ "query_simple",
  /*  452 */ "order_by_clause_opt",
  /*  453 */ "slimit_clause_opt",
  /*  454 */ "limit_clause_opt",
  /*  455 */ "union_query_expression",
  /*  456 */ "query_simple_or_subquery",
  /*  457 */ "sort_specification_list",
  /*  458 */ "sort_specification",
  /*  459 */ "ordering_specification_opt",
  /*  460 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "cmd ::= COMPACT DATABASE db_name",
 /*  73 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  74 */ "not_exists_opt ::=",
 /*  75 */ "exists_opt ::= IF EXISTS",
 /*  76 */ "exists_opt ::=",
 /*  77 */ "db_options ::=",
 /*  78 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  79 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  80 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  81 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  83 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  84 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  86 */ "db_options ::= db_options KEEP integer_list",
 /*  87 */ "db_options ::= db_options KEEP variable_list",
 /*  88 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  89 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  92 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  93 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  94 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  95 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  96 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 107 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 108 */ "alter_db_options ::= alter_db_option",
 /* 109 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 110 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 111 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 112 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 114 */ "alter_db_option ::= KEEP integer_list",
 /* 115 */ "alter_db_option ::= KEEP variable_list",
 /* 116 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 117 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 118 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 119 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 120 */ "integer_list ::= NK_INTEGER",
 /* 121 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 122 */ "variable_list ::= NK_VARIABLE",
 /* 123 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 124 */ "retention_list ::= retention",
 /* 125 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 126 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 127 */ "speed_opt ::=",
 /* 128 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 129 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 130 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 131 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 132 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 133 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 134 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 135 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 136 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 137 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 138 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 139 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 140 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 141 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 142 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 143 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 144 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 145 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 146 */ "multi_create_clause ::= create_subtable_clause",
 /* 147 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 148 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 149 */ "multi_drop_clause ::= drop_table_clause",
 /* 150 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 151 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 152 */ "specific_cols_opt ::=",
 /* 153 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 154 */ "full_table_name ::= table_name",
 /* 155 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 156 */ "column_def_list ::= column_def",
 /* 157 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 158 */ "column_def ::= column_name type_name",
 /* 159 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 160 */ "type_name ::= BOOL",
 /* 161 */ "type_name ::= TINYINT",
 /* 162 */ "type_name ::= SMALLINT",
 /* 163 */ "type_name ::= INT",
 /* 164 */ "type_name ::= INTEGER",
 /* 165 */ "type_name ::= BIGINT",
 /* 166 */ "type_name ::= FLOAT",
 /* 167 */ "type_name ::= DOUBLE",
 /* 168 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 169 */ "type_name ::= TIMESTAMP",
 /* 170 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 171 */ "type_name ::= TINYINT UNSIGNED",
 /* 172 */ "type_name ::= SMALLINT UNSIGNED",
 /* 173 */ "type_name ::= INT UNSIGNED",
 /* 174 */ "type_name ::= BIGINT UNSIGNED",
 /* 175 */ "type_name ::= JSON",
 /* 176 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 177 */ "type_name ::= MEDIUMBLOB",
 /* 178 */ "type_name ::= BLOB",
 /* 179 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 180 */ "type_name ::= DECIMAL",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 182 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 183 */ "tags_def_opt ::=",
 /* 184 */ "tags_def_opt ::= tags_def",
 /* 185 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 186 */ "table_options ::=",
 /* 187 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 188 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 189 */ "table_options ::= table_options WATERMARK duration_list",
 /* 190 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 191 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 192 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 193 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 194 */ "alter_table_options ::= alter_table_option",
 /* 195 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 196 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 197 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 198 */ "duration_list ::= duration_literal",
 /* 199 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 200 */ "rollup_func_list ::= rollup_func_name",
 /* 201 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 202 */ "rollup_func_name ::= function_name",
 /* 203 */ "rollup_func_name ::= FIRST",
 /* 204 */ "rollup_func_name ::= LAST",
 /* 205 */ "col_name_list ::= col_name",
 /* 206 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 207 */ "col_name ::= column_name",
 /* 208 */ "cmd ::= SHOW DNODES",
 /* 209 */ "cmd ::= SHOW USERS",
 /* 210 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 211 */ "cmd ::= SHOW DATABASES",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 214 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 215 */ "cmd ::= SHOW MNODES",
 /* 216 */ "cmd ::= SHOW QNODES",
 /* 217 */ "cmd ::= SHOW FUNCTIONS",
 /* 218 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 219 */ "cmd ::= SHOW STREAMS",
 /* 220 */ "cmd ::= SHOW ACCOUNTS",
 /* 221 */ "cmd ::= SHOW APPS",
 /* 222 */ "cmd ::= SHOW CONNECTIONS",
 /* 223 */ "cmd ::= SHOW LICENCES",
 /* 224 */ "cmd ::= SHOW GRANTS",
 /* 225 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 226 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 227 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 228 */ "cmd ::= SHOW QUERIES",
 /* 229 */ "cmd ::= SHOW SCORES",
 /* 230 */ "cmd ::= SHOW TOPICS",
 /* 231 */ "cmd ::= SHOW VARIABLES",
 /* 232 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 233 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 234 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 235 */ "cmd ::= SHOW BNODES",
 /* 236 */ "cmd ::= SHOW SNODES",
 /* 237 */ "cmd ::= SHOW CLUSTER",
 /* 238 */ "cmd ::= SHOW TRANSACTIONS",
 /* 239 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 240 */ "cmd ::= SHOW CONSUMERS",
 /* 241 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 242 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 244 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 245 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 246 */ "db_name_cond_opt ::=",
 /* 247 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 248 */ "like_pattern_opt ::=",
 /* 249 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 250 */ "table_name_cond ::= table_name",
 /* 251 */ "from_db_opt ::=",
 /* 252 */ "from_db_opt ::= FROM db_name",
 /* 253 */ "tag_list_opt ::=",
 /* 254 */ "tag_list_opt ::= tag_item",
 /* 255 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 256 */ "tag_item ::= TBNAME",
 /* 257 */ "tag_item ::= QTAGS",
 /* 258 */ "tag_item ::= column_name",
 /* 259 */ "tag_item ::= column_name column_alias",
 /* 260 */ "tag_item ::= column_name AS column_alias",
 /* 261 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 262 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 263 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 264 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 265 */ "func_list ::= func",
 /* 266 */ "func_list ::= func_list NK_COMMA func",
 /* 267 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 268 */ "sma_func_name ::= function_name",
 /* 269 */ "sma_func_name ::= COUNT",
 /* 270 */ "sma_func_name ::= FIRST",
 /* 271 */ "sma_func_name ::= LAST",
 /* 272 */ "sma_func_name ::= LAST_ROW",
 /* 273 */ "sma_stream_opt ::=",
 /* 274 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 275 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 276 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 277 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 278 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 279 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 280 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 281 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 282 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 283 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 284 */ "cmd ::= DESC full_table_name",
 /* 285 */ "cmd ::= DESCRIBE full_table_name",
 /* 286 */ "cmd ::= RESET QUERY CACHE",
 /* 287 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 288 */ "analyze_opt ::=",
 /* 289 */ "analyze_opt ::= ANALYZE",
 /* 290 */ "explain_options ::=",
 /* 291 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 292 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 293 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 294 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 295 */ "agg_func_opt ::=",
 /* 296 */ "agg_func_opt ::= AGGREGATE",
 /* 297 */ "bufsize_opt ::=",
 /* 298 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 299 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 300 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 301 */ "stream_options ::=",
 /* 302 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 303 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 304 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 305 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 306 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 307 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 308 */ "subtable_opt ::=",
 /* 309 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 310 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 311 */ "cmd ::= KILL QUERY NK_STRING",
 /* 312 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 313 */ "cmd ::= BALANCE VGROUP",
 /* 314 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 315 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 316 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 317 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 318 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 319 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 320 */ "cmd ::= query_or_subquery",
 /* 321 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 322 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 323 */ "literal ::= NK_INTEGER",
 /* 324 */ "literal ::= NK_FLOAT",
 /* 325 */ "literal ::= NK_STRING",
 /* 326 */ "literal ::= NK_BOOL",
 /* 327 */ "literal ::= TIMESTAMP NK_STRING",
 /* 328 */ "literal ::= duration_literal",
 /* 329 */ "literal ::= NULL",
 /* 330 */ "literal ::= NK_QUESTION",
 /* 331 */ "duration_literal ::= NK_VARIABLE",
 /* 332 */ "signed ::= NK_INTEGER",
 /* 333 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 334 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 335 */ "signed ::= NK_FLOAT",
 /* 336 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 337 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 338 */ "signed_literal ::= signed",
 /* 339 */ "signed_literal ::= NK_STRING",
 /* 340 */ "signed_literal ::= NK_BOOL",
 /* 341 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 342 */ "signed_literal ::= duration_literal",
 /* 343 */ "signed_literal ::= NULL",
 /* 344 */ "signed_literal ::= literal_func",
 /* 345 */ "signed_literal ::= NK_QUESTION",
 /* 346 */ "literal_list ::= signed_literal",
 /* 347 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 348 */ "db_name ::= NK_ID",
 /* 349 */ "table_name ::= NK_ID",
 /* 350 */ "column_name ::= NK_ID",
 /* 351 */ "function_name ::= NK_ID",
 /* 352 */ "table_alias ::= NK_ID",
 /* 353 */ "column_alias ::= NK_ID",
 /* 354 */ "user_name ::= NK_ID",
 /* 355 */ "topic_name ::= NK_ID",
 /* 356 */ "stream_name ::= NK_ID",
 /* 357 */ "cgroup_name ::= NK_ID",
 /* 358 */ "expr_or_subquery ::= expression",
 /* 359 */ "expression ::= literal",
 /* 360 */ "expression ::= pseudo_column",
 /* 361 */ "expression ::= column_reference",
 /* 362 */ "expression ::= function_expression",
 /* 363 */ "expression ::= case_when_expression",
 /* 364 */ "expression ::= NK_LP expression NK_RP",
 /* 365 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 366 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 367 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 368 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 369 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 370 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 371 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 372 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 373 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 374 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 375 */ "expression_list ::= expr_or_subquery",
 /* 376 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 377 */ "column_reference ::= column_name",
 /* 378 */ "column_reference ::= table_name NK_DOT column_name",
 /* 379 */ "pseudo_column ::= ROWTS",
 /* 380 */ "pseudo_column ::= TBNAME",
 /* 381 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 382 */ "pseudo_column ::= QSTART",
 /* 383 */ "pseudo_column ::= QEND",
 /* 384 */ "pseudo_column ::= QDURATION",
 /* 385 */ "pseudo_column ::= WSTART",
 /* 386 */ "pseudo_column ::= WEND",
 /* 387 */ "pseudo_column ::= WDURATION",
 /* 388 */ "pseudo_column ::= IROWTS",
 /* 389 */ "pseudo_column ::= ISFILLED",
 /* 390 */ "pseudo_column ::= QTAGS",
 /* 391 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 392 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 393 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 394 */ "function_expression ::= literal_func",
 /* 395 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 396 */ "literal_func ::= NOW",
 /* 397 */ "noarg_func ::= NOW",
 /* 398 */ "noarg_func ::= TODAY",
 /* 399 */ "noarg_func ::= TIMEZONE",
 /* 400 */ "noarg_func ::= DATABASE",
 /* 401 */ "noarg_func ::= CLIENT_VERSION",
 /* 402 */ "noarg_func ::= SERVER_VERSION",
 /* 403 */ "noarg_func ::= SERVER_STATUS",
 /* 404 */ "noarg_func ::= CURRENT_USER",
 /* 405 */ "noarg_func ::= USER",
 /* 406 */ "star_func ::= COUNT",
 /* 407 */ "star_func ::= FIRST",
 /* 408 */ "star_func ::= LAST",
 /* 409 */ "star_func ::= LAST_ROW",
 /* 410 */ "star_func_para_list ::= NK_STAR",
 /* 411 */ "star_func_para_list ::= other_para_list",
 /* 412 */ "other_para_list ::= star_func_para",
 /* 413 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 414 */ "star_func_para ::= expr_or_subquery",
 /* 415 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 416 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 417 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 418 */ "when_then_list ::= when_then_expr",
 /* 419 */ "when_then_list ::= when_then_list when_then_expr",
 /* 420 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 421 */ "case_when_else_opt ::=",
 /* 422 */ "case_when_else_opt ::= ELSE common_expression",
 /* 423 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 424 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 425 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 426 */ "predicate ::= expr_or_subquery IS NULL",
 /* 427 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 428 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 429 */ "compare_op ::= NK_LT",
 /* 430 */ "compare_op ::= NK_GT",
 /* 431 */ "compare_op ::= NK_LE",
 /* 432 */ "compare_op ::= NK_GE",
 /* 433 */ "compare_op ::= NK_NE",
 /* 434 */ "compare_op ::= NK_EQ",
 /* 435 */ "compare_op ::= LIKE",
 /* 436 */ "compare_op ::= NOT LIKE",
 /* 437 */ "compare_op ::= MATCH",
 /* 438 */ "compare_op ::= NMATCH",
 /* 439 */ "compare_op ::= CONTAINS",
 /* 440 */ "in_op ::= IN",
 /* 441 */ "in_op ::= NOT IN",
 /* 442 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 443 */ "boolean_value_expression ::= boolean_primary",
 /* 444 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 445 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 446 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 447 */ "boolean_primary ::= predicate",
 /* 448 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 449 */ "common_expression ::= expr_or_subquery",
 /* 450 */ "common_expression ::= boolean_value_expression",
 /* 451 */ "from_clause_opt ::=",
 /* 452 */ "from_clause_opt ::= FROM table_reference_list",
 /* 453 */ "table_reference_list ::= table_reference",
 /* 454 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 455 */ "table_reference ::= table_primary",
 /* 456 */ "table_reference ::= joined_table",
 /* 457 */ "table_primary ::= table_name alias_opt",
 /* 458 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 459 */ "table_primary ::= subquery alias_opt",
 /* 460 */ "table_primary ::= parenthesized_joined_table",
 /* 461 */ "alias_opt ::=",
 /* 462 */ "alias_opt ::= table_alias",
 /* 463 */ "alias_opt ::= AS table_alias",
 /* 464 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 465 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 466 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 467 */ "join_type ::=",
 /* 468 */ "join_type ::= INNER",
 /* 469 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 470 */ "set_quantifier_opt ::=",
 /* 471 */ "set_quantifier_opt ::= DISTINCT",
 /* 472 */ "set_quantifier_opt ::= ALL",
 /* 473 */ "select_list ::= select_item",
 /* 474 */ "select_list ::= select_list NK_COMMA select_item",
 /* 475 */ "select_item ::= NK_STAR",
 /* 476 */ "select_item ::= common_expression",
 /* 477 */ "select_item ::= common_expression column_alias",
 /* 478 */ "select_item ::= common_expression AS column_alias",
 /* 479 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 480 */ "where_clause_opt ::=",
 /* 481 */ "where_clause_opt ::= WHERE search_condition",
 /* 482 */ "partition_by_clause_opt ::=",
 /* 483 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 484 */ "partition_list ::= partition_item",
 /* 485 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 486 */ "partition_item ::= expr_or_subquery",
 /* 487 */ "partition_item ::= expr_or_subquery column_alias",
 /* 488 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 489 */ "twindow_clause_opt ::=",
 /* 490 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 491 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 492 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 493 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 494 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 495 */ "sliding_opt ::=",
 /* 496 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 497 */ "fill_opt ::=",
 /* 498 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 499 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 500 */ "fill_mode ::= NONE",
 /* 501 */ "fill_mode ::= PREV",
 /* 502 */ "fill_mode ::= NULL",
 /* 503 */ "fill_mode ::= LINEAR",
 /* 504 */ "fill_mode ::= NEXT",
 /* 505 */ "group_by_clause_opt ::=",
 /* 506 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 507 */ "group_by_list ::= expr_or_subquery",
 /* 508 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 509 */ "having_clause_opt ::=",
 /* 510 */ "having_clause_opt ::= HAVING search_condition",
 /* 511 */ "range_opt ::=",
 /* 512 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 513 */ "every_opt ::=",
 /* 514 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 515 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 516 */ "query_simple ::= query_specification",
 /* 517 */ "query_simple ::= union_query_expression",
 /* 518 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 519 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 520 */ "query_simple_or_subquery ::= query_simple",
 /* 521 */ "query_simple_or_subquery ::= subquery",
 /* 522 */ "query_or_subquery ::= query_expression",
 /* 523 */ "query_or_subquery ::= subquery",
 /* 524 */ "order_by_clause_opt ::=",
 /* 525 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 526 */ "slimit_clause_opt ::=",
 /* 527 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 528 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 529 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 530 */ "limit_clause_opt ::=",
 /* 531 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 532 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 533 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 534 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 535 */ "subquery ::= NK_LP subquery NK_RP",
 /* 536 */ "search_condition ::= common_expression",
 /* 537 */ "sort_specification_list ::= sort_specification",
 /* 538 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 539 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 540 */ "ordering_specification_opt ::=",
 /* 541 */ "ordering_specification_opt ::= ASC",
 /* 542 */ "ordering_specification_opt ::= DESC",
 /* 543 */ "null_ordering_opt ::=",
 /* 544 */ "null_ordering_opt ::= NULLS FIRST",
 /* 545 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 325: /* cmd */
    case 328: /* literal */
    case 341: /* db_options */
    case 343: /* alter_db_options */
    case 349: /* retention */
    case 350: /* full_table_name */
    case 353: /* table_options */
    case 357: /* alter_table_clause */
    case 358: /* alter_table_options */
    case 361: /* signed_literal */
    case 362: /* create_subtable_clause */
    case 365: /* drop_table_clause */
    case 368: /* column_def */
    case 372: /* duration_literal */
    case 373: /* rollup_func_name */
    case 375: /* col_name */
    case 376: /* db_name_cond_opt */
    case 377: /* like_pattern_opt */
    case 378: /* table_name_cond */
    case 379: /* from_db_opt */
    case 381: /* tag_item */
    case 383: /* index_options */
    case 385: /* sliding_opt */
    case 386: /* sma_stream_opt */
    case 387: /* func */
    case 389: /* query_or_subquery */
    case 392: /* explain_options */
    case 396: /* stream_options */
    case 397: /* subtable_opt */
    case 398: /* expression */
    case 400: /* where_clause_opt */
    case 401: /* signed */
    case 402: /* literal_func */
    case 405: /* expr_or_subquery */
    case 406: /* pseudo_column */
    case 407: /* column_reference */
    case 408: /* function_expression */
    case 409: /* case_when_expression */
    case 414: /* star_func_para */
    case 416: /* case_when_else_opt */
    case 417: /* common_expression */
    case 418: /* when_then_expr */
    case 419: /* predicate */
    case 422: /* in_predicate_value */
    case 423: /* boolean_value_expression */
    case 424: /* boolean_primary */
    case 425: /* from_clause_opt */
    case 426: /* table_reference_list */
    case 427: /* table_reference */
    case 428: /* table_primary */
    case 429: /* joined_table */
    case 431: /* subquery */
    case 432: /* parenthesized_joined_table */
    case 434: /* search_condition */
    case 435: /* query_specification */
    case 439: /* range_opt */
    case 440: /* every_opt */
    case 441: /* fill_opt */
    case 442: /* twindow_clause_opt */
    case 444: /* having_clause_opt */
    case 445: /* select_item */
    case 447: /* partition_item */
    case 450: /* query_expression */
    case 451: /* query_simple */
    case 453: /* slimit_clause_opt */
    case 454: /* limit_clause_opt */
    case 455: /* union_query_expression */
    case 456: /* query_simple_or_subquery */
    case 458: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy600)); 
}
      break;
    case 326: /* account_options */
    case 327: /* alter_account_options */
    case 329: /* alter_account_option */
    case 344: /* speed_opt */
    case 394: /* bufsize_opt */
{
 
}
      break;
    case 330: /* user_name */
    case 333: /* priv_level */
    case 336: /* db_name */
    case 337: /* topic_name */
    case 338: /* dnode_endpoint */
    case 359: /* column_name */
    case 367: /* table_name */
    case 374: /* function_name */
    case 382: /* column_alias */
    case 388: /* sma_func_name */
    case 390: /* cgroup_name */
    case 395: /* stream_name */
    case 404: /* table_alias */
    case 410: /* star_func */
    case 412: /* noarg_func */
    case 430: /* alias_opt */
{
 
}
      break;
    case 331: /* sysinfo_opt */
{
 
}
      break;
    case 332: /* privileges */
    case 334: /* priv_type_list */
    case 335: /* priv_type */
{
 
}
      break;
    case 339: /* force_opt */
    case 340: /* not_exists_opt */
    case 342: /* exists_opt */
    case 391: /* analyze_opt */
    case 393: /* agg_func_opt */
    case 436: /* set_quantifier_opt */
{
 
}
      break;
    case 345: /* integer_list */
    case 346: /* variable_list */
    case 347: /* retention_list */
    case 351: /* column_def_list */
    case 352: /* tags_def_opt */
    case 354: /* multi_create_clause */
    case 355: /* tags_def */
    case 356: /* multi_drop_clause */
    case 363: /* specific_cols_opt */
    case 364: /* expression_list */
    case 366: /* col_name_list */
    case 369: /* duration_list */
    case 370: /* rollup_func_list */
    case 380: /* tag_list_opt */
    case 384: /* func_list */
    case 399: /* dnode_list */
    case 403: /* literal_list */
    case 411: /* star_func_para_list */
    case 413: /* other_para_list */
    case 415: /* when_then_list */
    case 437: /* select_list */
    case 438: /* partition_by_clause_opt */
    case 443: /* group_by_clause_opt */
    case 446: /* partition_list */
    case 449: /* group_by_list */
    case 452: /* order_by_clause_opt */
    case 457: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy601)); 
}
      break;
    case 348: /* alter_db_option */
    case 371: /* alter_table_option */
{
 
}
      break;
    case 360: /* type_name */
{
 
}
      break;
    case 420: /* compare_op */
    case 421: /* in_op */
{
 
}
      break;
    case 433: /* join_type */
{
 
}
      break;
    case 448: /* fill_mode */
{
 
}
      break;
    case 459: /* ordering_specification_opt */
{
 
}
      break;
    case 460: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  325,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  325,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  326,    0 }, /* (2) account_options ::= */
  {  326,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  326,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  326,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  326,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  326,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  326,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  326,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  326,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  326,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  327,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  327,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  329,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  329,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  329,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  329,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  329,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  329,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  329,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  329,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  329,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  329,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  325,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  325,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  325,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  325,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  325,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  331,    0 }, /* (29) sysinfo_opt ::= */
  {  331,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  325,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  325,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  332,   -1 }, /* (33) privileges ::= ALL */
  {  332,   -1 }, /* (34) privileges ::= priv_type_list */
  {  332,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  334,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  334,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  335,   -1 }, /* (38) priv_type ::= READ */
  {  335,   -1 }, /* (39) priv_type ::= WRITE */
  {  333,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  333,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  333,   -1 }, /* (42) priv_level ::= topic_name */
  {  325,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  325,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  325,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  325,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  325,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  325,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  325,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  325,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  338,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  338,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  338,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  339,    0 }, /* (54) force_opt ::= */
  {  339,   -1 }, /* (55) force_opt ::= FORCE */
  {  325,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  325,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  325,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  325,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  325,   -2 }, /* (68) cmd ::= USE db_name */
  {  325,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  325,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  325,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  325,   -3 }, /* (72) cmd ::= COMPACT DATABASE db_name */
  {  340,   -3 }, /* (73) not_exists_opt ::= IF NOT EXISTS */
  {  340,    0 }, /* (74) not_exists_opt ::= */
  {  342,   -2 }, /* (75) exists_opt ::= IF EXISTS */
  {  342,    0 }, /* (76) exists_opt ::= */
  {  341,    0 }, /* (77) db_options ::= */
  {  341,   -3 }, /* (78) db_options ::= db_options BUFFER NK_INTEGER */
  {  341,   -3 }, /* (79) db_options ::= db_options CACHEMODEL NK_STRING */
  {  341,   -3 }, /* (80) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  341,   -3 }, /* (81) db_options ::= db_options COMP NK_INTEGER */
  {  341,   -3 }, /* (82) db_options ::= db_options DURATION NK_INTEGER */
  {  341,   -3 }, /* (83) db_options ::= db_options DURATION NK_VARIABLE */
  {  341,   -3 }, /* (84) db_options ::= db_options MAXROWS NK_INTEGER */
  {  341,   -3 }, /* (85) db_options ::= db_options MINROWS NK_INTEGER */
  {  341,   -3 }, /* (86) db_options ::= db_options KEEP integer_list */
  {  341,   -3 }, /* (87) db_options ::= db_options KEEP variable_list */
  {  341,   -3 }, /* (88) db_options ::= db_options PAGES NK_INTEGER */
  {  341,   -3 }, /* (89) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  341,   -3 }, /* (90) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  341,   -3 }, /* (91) db_options ::= db_options PRECISION NK_STRING */
  {  341,   -3 }, /* (92) db_options ::= db_options REPLICA NK_INTEGER */
  {  341,   -3 }, /* (93) db_options ::= db_options VGROUPS NK_INTEGER */
  {  341,   -3 }, /* (94) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  341,   -3 }, /* (95) db_options ::= db_options RETENTIONS retention_list */
  {  341,   -3 }, /* (96) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  341,   -3 }, /* (97) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  341,   -3 }, /* (98) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  341,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  341,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  341,   -3 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  341,   -4 }, /* (102) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  341,   -3 }, /* (103) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  341,   -3 }, /* (104) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  341,   -3 }, /* (105) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  341,   -3 }, /* (106) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  341,   -3 }, /* (107) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  343,   -1 }, /* (108) alter_db_options ::= alter_db_option */
  {  343,   -2 }, /* (109) alter_db_options ::= alter_db_options alter_db_option */
  {  348,   -2 }, /* (110) alter_db_option ::= BUFFER NK_INTEGER */
  {  348,   -2 }, /* (111) alter_db_option ::= CACHEMODEL NK_STRING */
  {  348,   -2 }, /* (112) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  348,   -2 }, /* (113) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  348,   -2 }, /* (114) alter_db_option ::= KEEP integer_list */
  {  348,   -2 }, /* (115) alter_db_option ::= KEEP variable_list */
  {  348,   -2 }, /* (116) alter_db_option ::= PAGES NK_INTEGER */
  {  348,   -2 }, /* (117) alter_db_option ::= REPLICA NK_INTEGER */
  {  348,   -2 }, /* (118) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  348,   -2 }, /* (119) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  345,   -1 }, /* (120) integer_list ::= NK_INTEGER */
  {  345,   -3 }, /* (121) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  346,   -1 }, /* (122) variable_list ::= NK_VARIABLE */
  {  346,   -3 }, /* (123) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  347,   -1 }, /* (124) retention_list ::= retention */
  {  347,   -3 }, /* (125) retention_list ::= retention_list NK_COMMA retention */
  {  349,   -3 }, /* (126) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  344,    0 }, /* (127) speed_opt ::= */
  {  344,   -2 }, /* (128) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  325,   -9 }, /* (129) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  325,   -3 }, /* (130) cmd ::= CREATE TABLE multi_create_clause */
  {  325,   -9 }, /* (131) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  325,   -3 }, /* (132) cmd ::= DROP TABLE multi_drop_clause */
  {  325,   -4 }, /* (133) cmd ::= DROP STABLE exists_opt full_table_name */
  {  325,   -3 }, /* (134) cmd ::= ALTER TABLE alter_table_clause */
  {  325,   -3 }, /* (135) cmd ::= ALTER STABLE alter_table_clause */
  {  357,   -2 }, /* (136) alter_table_clause ::= full_table_name alter_table_options */
  {  357,   -5 }, /* (137) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  357,   -4 }, /* (138) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  357,   -5 }, /* (139) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  357,   -5 }, /* (140) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  357,   -5 }, /* (141) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  357,   -4 }, /* (142) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  357,   -5 }, /* (143) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  357,   -5 }, /* (144) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  357,   -6 }, /* (145) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  354,   -1 }, /* (146) multi_create_clause ::= create_subtable_clause */
  {  354,   -2 }, /* (147) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  362,  -10 }, /* (148) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  356,   -1 }, /* (149) multi_drop_clause ::= drop_table_clause */
  {  356,   -2 }, /* (150) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  365,   -2 }, /* (151) drop_table_clause ::= exists_opt full_table_name */
  {  363,    0 }, /* (152) specific_cols_opt ::= */
  {  363,   -3 }, /* (153) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  350,   -1 }, /* (154) full_table_name ::= table_name */
  {  350,   -3 }, /* (155) full_table_name ::= db_name NK_DOT table_name */
  {  351,   -1 }, /* (156) column_def_list ::= column_def */
  {  351,   -3 }, /* (157) column_def_list ::= column_def_list NK_COMMA column_def */
  {  368,   -2 }, /* (158) column_def ::= column_name type_name */
  {  368,   -4 }, /* (159) column_def ::= column_name type_name COMMENT NK_STRING */
  {  360,   -1 }, /* (160) type_name ::= BOOL */
  {  360,   -1 }, /* (161) type_name ::= TINYINT */
  {  360,   -1 }, /* (162) type_name ::= SMALLINT */
  {  360,   -1 }, /* (163) type_name ::= INT */
  {  360,   -1 }, /* (164) type_name ::= INTEGER */
  {  360,   -1 }, /* (165) type_name ::= BIGINT */
  {  360,   -1 }, /* (166) type_name ::= FLOAT */
  {  360,   -1 }, /* (167) type_name ::= DOUBLE */
  {  360,   -4 }, /* (168) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  360,   -1 }, /* (169) type_name ::= TIMESTAMP */
  {  360,   -4 }, /* (170) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  360,   -2 }, /* (171) type_name ::= TINYINT UNSIGNED */
  {  360,   -2 }, /* (172) type_name ::= SMALLINT UNSIGNED */
  {  360,   -2 }, /* (173) type_name ::= INT UNSIGNED */
  {  360,   -2 }, /* (174) type_name ::= BIGINT UNSIGNED */
  {  360,   -1 }, /* (175) type_name ::= JSON */
  {  360,   -4 }, /* (176) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  360,   -1 }, /* (177) type_name ::= MEDIUMBLOB */
  {  360,   -1 }, /* (178) type_name ::= BLOB */
  {  360,   -4 }, /* (179) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  360,   -1 }, /* (180) type_name ::= DECIMAL */
  {  360,   -4 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  360,   -6 }, /* (182) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  352,    0 }, /* (183) tags_def_opt ::= */
  {  352,   -1 }, /* (184) tags_def_opt ::= tags_def */
  {  355,   -4 }, /* (185) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  353,    0 }, /* (186) table_options ::= */
  {  353,   -3 }, /* (187) table_options ::= table_options COMMENT NK_STRING */
  {  353,   -3 }, /* (188) table_options ::= table_options MAX_DELAY duration_list */
  {  353,   -3 }, /* (189) table_options ::= table_options WATERMARK duration_list */
  {  353,   -5 }, /* (190) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  353,   -3 }, /* (191) table_options ::= table_options TTL NK_INTEGER */
  {  353,   -5 }, /* (192) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  353,   -3 }, /* (193) table_options ::= table_options DELETE_MARK duration_list */
  {  358,   -1 }, /* (194) alter_table_options ::= alter_table_option */
  {  358,   -2 }, /* (195) alter_table_options ::= alter_table_options alter_table_option */
  {  371,   -2 }, /* (196) alter_table_option ::= COMMENT NK_STRING */
  {  371,   -2 }, /* (197) alter_table_option ::= TTL NK_INTEGER */
  {  369,   -1 }, /* (198) duration_list ::= duration_literal */
  {  369,   -3 }, /* (199) duration_list ::= duration_list NK_COMMA duration_literal */
  {  370,   -1 }, /* (200) rollup_func_list ::= rollup_func_name */
  {  370,   -3 }, /* (201) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  373,   -1 }, /* (202) rollup_func_name ::= function_name */
  {  373,   -1 }, /* (203) rollup_func_name ::= FIRST */
  {  373,   -1 }, /* (204) rollup_func_name ::= LAST */
  {  366,   -1 }, /* (205) col_name_list ::= col_name */
  {  366,   -3 }, /* (206) col_name_list ::= col_name_list NK_COMMA col_name */
  {  375,   -1 }, /* (207) col_name ::= column_name */
  {  325,   -2 }, /* (208) cmd ::= SHOW DNODES */
  {  325,   -2 }, /* (209) cmd ::= SHOW USERS */
  {  325,   -3 }, /* (210) cmd ::= SHOW USER PRIVILEGES */
  {  325,   -2 }, /* (211) cmd ::= SHOW DATABASES */
  {  325,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  325,   -4 }, /* (213) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  325,   -3 }, /* (214) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  325,   -2 }, /* (215) cmd ::= SHOW MNODES */
  {  325,   -2 }, /* (216) cmd ::= SHOW QNODES */
  {  325,   -2 }, /* (217) cmd ::= SHOW FUNCTIONS */
  {  325,   -5 }, /* (218) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  325,   -2 }, /* (219) cmd ::= SHOW STREAMS */
  {  325,   -2 }, /* (220) cmd ::= SHOW ACCOUNTS */
  {  325,   -2 }, /* (221) cmd ::= SHOW APPS */
  {  325,   -2 }, /* (222) cmd ::= SHOW CONNECTIONS */
  {  325,   -2 }, /* (223) cmd ::= SHOW LICENCES */
  {  325,   -2 }, /* (224) cmd ::= SHOW GRANTS */
  {  325,   -4 }, /* (225) cmd ::= SHOW CREATE DATABASE db_name */
  {  325,   -4 }, /* (226) cmd ::= SHOW CREATE TABLE full_table_name */
  {  325,   -4 }, /* (227) cmd ::= SHOW CREATE STABLE full_table_name */
  {  325,   -2 }, /* (228) cmd ::= SHOW QUERIES */
  {  325,   -2 }, /* (229) cmd ::= SHOW SCORES */
  {  325,   -2 }, /* (230) cmd ::= SHOW TOPICS */
  {  325,   -2 }, /* (231) cmd ::= SHOW VARIABLES */
  {  325,   -3 }, /* (232) cmd ::= SHOW CLUSTER VARIABLES */
  {  325,   -3 }, /* (233) cmd ::= SHOW LOCAL VARIABLES */
  {  325,   -5 }, /* (234) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  325,   -2 }, /* (235) cmd ::= SHOW BNODES */
  {  325,   -2 }, /* (236) cmd ::= SHOW SNODES */
  {  325,   -2 }, /* (237) cmd ::= SHOW CLUSTER */
  {  325,   -2 }, /* (238) cmd ::= SHOW TRANSACTIONS */
  {  325,   -4 }, /* (239) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  325,   -2 }, /* (240) cmd ::= SHOW CONSUMERS */
  {  325,   -2 }, /* (241) cmd ::= SHOW SUBSCRIPTIONS */
  {  325,   -5 }, /* (242) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  325,   -7 }, /* (243) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  325,   -3 }, /* (244) cmd ::= SHOW VNODES NK_INTEGER */
  {  325,   -3 }, /* (245) cmd ::= SHOW VNODES NK_STRING */
  {  376,    0 }, /* (246) db_name_cond_opt ::= */
  {  376,   -2 }, /* (247) db_name_cond_opt ::= db_name NK_DOT */
  {  377,    0 }, /* (248) like_pattern_opt ::= */
  {  377,   -2 }, /* (249) like_pattern_opt ::= LIKE NK_STRING */
  {  378,   -1 }, /* (250) table_name_cond ::= table_name */
  {  379,    0 }, /* (251) from_db_opt ::= */
  {  379,   -2 }, /* (252) from_db_opt ::= FROM db_name */
  {  380,    0 }, /* (253) tag_list_opt ::= */
  {  380,   -1 }, /* (254) tag_list_opt ::= tag_item */
  {  380,   -3 }, /* (255) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  381,   -1 }, /* (256) tag_item ::= TBNAME */
  {  381,   -1 }, /* (257) tag_item ::= QTAGS */
  {  381,   -1 }, /* (258) tag_item ::= column_name */
  {  381,   -2 }, /* (259) tag_item ::= column_name column_alias */
  {  381,   -3 }, /* (260) tag_item ::= column_name AS column_alias */
  {  325,   -8 }, /* (261) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  325,   -4 }, /* (262) cmd ::= DROP INDEX exists_opt full_table_name */
  {  383,  -10 }, /* (263) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  383,  -12 }, /* (264) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  384,   -1 }, /* (265) func_list ::= func */
  {  384,   -3 }, /* (266) func_list ::= func_list NK_COMMA func */
  {  387,   -4 }, /* (267) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  388,   -1 }, /* (268) sma_func_name ::= function_name */
  {  388,   -1 }, /* (269) sma_func_name ::= COUNT */
  {  388,   -1 }, /* (270) sma_func_name ::= FIRST */
  {  388,   -1 }, /* (271) sma_func_name ::= LAST */
  {  388,   -1 }, /* (272) sma_func_name ::= LAST_ROW */
  {  386,    0 }, /* (273) sma_stream_opt ::= */
  {  386,   -3 }, /* (274) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  386,   -3 }, /* (275) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  386,   -3 }, /* (276) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  325,   -6 }, /* (277) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  325,   -7 }, /* (278) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  325,   -9 }, /* (279) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  325,   -7 }, /* (280) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  325,   -9 }, /* (281) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  325,   -4 }, /* (282) cmd ::= DROP TOPIC exists_opt topic_name */
  {  325,   -7 }, /* (283) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  325,   -2 }, /* (284) cmd ::= DESC full_table_name */
  {  325,   -2 }, /* (285) cmd ::= DESCRIBE full_table_name */
  {  325,   -3 }, /* (286) cmd ::= RESET QUERY CACHE */
  {  325,   -4 }, /* (287) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  391,    0 }, /* (288) analyze_opt ::= */
  {  391,   -1 }, /* (289) analyze_opt ::= ANALYZE */
  {  392,    0 }, /* (290) explain_options ::= */
  {  392,   -3 }, /* (291) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  392,   -3 }, /* (292) explain_options ::= explain_options RATIO NK_FLOAT */
  {  325,  -10 }, /* (293) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  325,   -4 }, /* (294) cmd ::= DROP FUNCTION exists_opt function_name */
  {  393,    0 }, /* (295) agg_func_opt ::= */
  {  393,   -1 }, /* (296) agg_func_opt ::= AGGREGATE */
  {  394,    0 }, /* (297) bufsize_opt ::= */
  {  394,   -2 }, /* (298) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  325,  -11 }, /* (299) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  325,   -4 }, /* (300) cmd ::= DROP STREAM exists_opt stream_name */
  {  396,    0 }, /* (301) stream_options ::= */
  {  396,   -3 }, /* (302) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  396,   -3 }, /* (303) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  396,   -4 }, /* (304) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  396,   -3 }, /* (305) stream_options ::= stream_options WATERMARK duration_literal */
  {  396,   -4 }, /* (306) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  396,   -3 }, /* (307) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  397,    0 }, /* (308) subtable_opt ::= */
  {  397,   -4 }, /* (309) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  325,   -3 }, /* (310) cmd ::= KILL CONNECTION NK_INTEGER */
  {  325,   -3 }, /* (311) cmd ::= KILL QUERY NK_STRING */
  {  325,   -3 }, /* (312) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  325,   -2 }, /* (313) cmd ::= BALANCE VGROUP */
  {  325,   -4 }, /* (314) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  325,   -4 }, /* (315) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  325,   -3 }, /* (316) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  399,   -2 }, /* (317) dnode_list ::= DNODE NK_INTEGER */
  {  399,   -3 }, /* (318) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  325,   -4 }, /* (319) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  325,   -1 }, /* (320) cmd ::= query_or_subquery */
  {  325,   -7 }, /* (321) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  325,   -4 }, /* (322) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  328,   -1 }, /* (323) literal ::= NK_INTEGER */
  {  328,   -1 }, /* (324) literal ::= NK_FLOAT */
  {  328,   -1 }, /* (325) literal ::= NK_STRING */
  {  328,   -1 }, /* (326) literal ::= NK_BOOL */
  {  328,   -2 }, /* (327) literal ::= TIMESTAMP NK_STRING */
  {  328,   -1 }, /* (328) literal ::= duration_literal */
  {  328,   -1 }, /* (329) literal ::= NULL */
  {  328,   -1 }, /* (330) literal ::= NK_QUESTION */
  {  372,   -1 }, /* (331) duration_literal ::= NK_VARIABLE */
  {  401,   -1 }, /* (332) signed ::= NK_INTEGER */
  {  401,   -2 }, /* (333) signed ::= NK_PLUS NK_INTEGER */
  {  401,   -2 }, /* (334) signed ::= NK_MINUS NK_INTEGER */
  {  401,   -1 }, /* (335) signed ::= NK_FLOAT */
  {  401,   -2 }, /* (336) signed ::= NK_PLUS NK_FLOAT */
  {  401,   -2 }, /* (337) signed ::= NK_MINUS NK_FLOAT */
  {  361,   -1 }, /* (338) signed_literal ::= signed */
  {  361,   -1 }, /* (339) signed_literal ::= NK_STRING */
  {  361,   -1 }, /* (340) signed_literal ::= NK_BOOL */
  {  361,   -2 }, /* (341) signed_literal ::= TIMESTAMP NK_STRING */
  {  361,   -1 }, /* (342) signed_literal ::= duration_literal */
  {  361,   -1 }, /* (343) signed_literal ::= NULL */
  {  361,   -1 }, /* (344) signed_literal ::= literal_func */
  {  361,   -1 }, /* (345) signed_literal ::= NK_QUESTION */
  {  403,   -1 }, /* (346) literal_list ::= signed_literal */
  {  403,   -3 }, /* (347) literal_list ::= literal_list NK_COMMA signed_literal */
  {  336,   -1 }, /* (348) db_name ::= NK_ID */
  {  367,   -1 }, /* (349) table_name ::= NK_ID */
  {  359,   -1 }, /* (350) column_name ::= NK_ID */
  {  374,   -1 }, /* (351) function_name ::= NK_ID */
  {  404,   -1 }, /* (352) table_alias ::= NK_ID */
  {  382,   -1 }, /* (353) column_alias ::= NK_ID */
  {  330,   -1 }, /* (354) user_name ::= NK_ID */
  {  337,   -1 }, /* (355) topic_name ::= NK_ID */
  {  395,   -1 }, /* (356) stream_name ::= NK_ID */
  {  390,   -1 }, /* (357) cgroup_name ::= NK_ID */
  {  405,   -1 }, /* (358) expr_or_subquery ::= expression */
  {  398,   -1 }, /* (359) expression ::= literal */
  {  398,   -1 }, /* (360) expression ::= pseudo_column */
  {  398,   -1 }, /* (361) expression ::= column_reference */
  {  398,   -1 }, /* (362) expression ::= function_expression */
  {  398,   -1 }, /* (363) expression ::= case_when_expression */
  {  398,   -3 }, /* (364) expression ::= NK_LP expression NK_RP */
  {  398,   -2 }, /* (365) expression ::= NK_PLUS expr_or_subquery */
  {  398,   -2 }, /* (366) expression ::= NK_MINUS expr_or_subquery */
  {  398,   -3 }, /* (367) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  398,   -3 }, /* (368) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  398,   -3 }, /* (369) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  398,   -3 }, /* (370) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  398,   -3 }, /* (371) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  398,   -3 }, /* (372) expression ::= column_reference NK_ARROW NK_STRING */
  {  398,   -3 }, /* (373) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  398,   -3 }, /* (374) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  364,   -1 }, /* (375) expression_list ::= expr_or_subquery */
  {  364,   -3 }, /* (376) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  407,   -1 }, /* (377) column_reference ::= column_name */
  {  407,   -3 }, /* (378) column_reference ::= table_name NK_DOT column_name */
  {  406,   -1 }, /* (379) pseudo_column ::= ROWTS */
  {  406,   -1 }, /* (380) pseudo_column ::= TBNAME */
  {  406,   -3 }, /* (381) pseudo_column ::= table_name NK_DOT TBNAME */
  {  406,   -1 }, /* (382) pseudo_column ::= QSTART */
  {  406,   -1 }, /* (383) pseudo_column ::= QEND */
  {  406,   -1 }, /* (384) pseudo_column ::= QDURATION */
  {  406,   -1 }, /* (385) pseudo_column ::= WSTART */
  {  406,   -1 }, /* (386) pseudo_column ::= WEND */
  {  406,   -1 }, /* (387) pseudo_column ::= WDURATION */
  {  406,   -1 }, /* (388) pseudo_column ::= IROWTS */
  {  406,   -1 }, /* (389) pseudo_column ::= ISFILLED */
  {  406,   -1 }, /* (390) pseudo_column ::= QTAGS */
  {  408,   -4 }, /* (391) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  408,   -4 }, /* (392) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  408,   -6 }, /* (393) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  408,   -1 }, /* (394) function_expression ::= literal_func */
  {  402,   -3 }, /* (395) literal_func ::= noarg_func NK_LP NK_RP */
  {  402,   -1 }, /* (396) literal_func ::= NOW */
  {  412,   -1 }, /* (397) noarg_func ::= NOW */
  {  412,   -1 }, /* (398) noarg_func ::= TODAY */
  {  412,   -1 }, /* (399) noarg_func ::= TIMEZONE */
  {  412,   -1 }, /* (400) noarg_func ::= DATABASE */
  {  412,   -1 }, /* (401) noarg_func ::= CLIENT_VERSION */
  {  412,   -1 }, /* (402) noarg_func ::= SERVER_VERSION */
  {  412,   -1 }, /* (403) noarg_func ::= SERVER_STATUS */
  {  412,   -1 }, /* (404) noarg_func ::= CURRENT_USER */
  {  412,   -1 }, /* (405) noarg_func ::= USER */
  {  410,   -1 }, /* (406) star_func ::= COUNT */
  {  410,   -1 }, /* (407) star_func ::= FIRST */
  {  410,   -1 }, /* (408) star_func ::= LAST */
  {  410,   -1 }, /* (409) star_func ::= LAST_ROW */
  {  411,   -1 }, /* (410) star_func_para_list ::= NK_STAR */
  {  411,   -1 }, /* (411) star_func_para_list ::= other_para_list */
  {  413,   -1 }, /* (412) other_para_list ::= star_func_para */
  {  413,   -3 }, /* (413) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  414,   -1 }, /* (414) star_func_para ::= expr_or_subquery */
  {  414,   -3 }, /* (415) star_func_para ::= table_name NK_DOT NK_STAR */
  {  409,   -4 }, /* (416) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  409,   -5 }, /* (417) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  415,   -1 }, /* (418) when_then_list ::= when_then_expr */
  {  415,   -2 }, /* (419) when_then_list ::= when_then_list when_then_expr */
  {  418,   -4 }, /* (420) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  416,    0 }, /* (421) case_when_else_opt ::= */
  {  416,   -2 }, /* (422) case_when_else_opt ::= ELSE common_expression */
  {  419,   -3 }, /* (423) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  419,   -5 }, /* (424) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  419,   -6 }, /* (425) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  419,   -3 }, /* (426) predicate ::= expr_or_subquery IS NULL */
  {  419,   -4 }, /* (427) predicate ::= expr_or_subquery IS NOT NULL */
  {  419,   -3 }, /* (428) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  420,   -1 }, /* (429) compare_op ::= NK_LT */
  {  420,   -1 }, /* (430) compare_op ::= NK_GT */
  {  420,   -1 }, /* (431) compare_op ::= NK_LE */
  {  420,   -1 }, /* (432) compare_op ::= NK_GE */
  {  420,   -1 }, /* (433) compare_op ::= NK_NE */
  {  420,   -1 }, /* (434) compare_op ::= NK_EQ */
  {  420,   -1 }, /* (435) compare_op ::= LIKE */
  {  420,   -2 }, /* (436) compare_op ::= NOT LIKE */
  {  420,   -1 }, /* (437) compare_op ::= MATCH */
  {  420,   -1 }, /* (438) compare_op ::= NMATCH */
  {  420,   -1 }, /* (439) compare_op ::= CONTAINS */
  {  421,   -1 }, /* (440) in_op ::= IN */
  {  421,   -2 }, /* (441) in_op ::= NOT IN */
  {  422,   -3 }, /* (442) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  423,   -1 }, /* (443) boolean_value_expression ::= boolean_primary */
  {  423,   -2 }, /* (444) boolean_value_expression ::= NOT boolean_primary */
  {  423,   -3 }, /* (445) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  423,   -3 }, /* (446) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  424,   -1 }, /* (447) boolean_primary ::= predicate */
  {  424,   -3 }, /* (448) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  417,   -1 }, /* (449) common_expression ::= expr_or_subquery */
  {  417,   -1 }, /* (450) common_expression ::= boolean_value_expression */
  {  425,    0 }, /* (451) from_clause_opt ::= */
  {  425,   -2 }, /* (452) from_clause_opt ::= FROM table_reference_list */
  {  426,   -1 }, /* (453) table_reference_list ::= table_reference */
  {  426,   -3 }, /* (454) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  427,   -1 }, /* (455) table_reference ::= table_primary */
  {  427,   -1 }, /* (456) table_reference ::= joined_table */
  {  428,   -2 }, /* (457) table_primary ::= table_name alias_opt */
  {  428,   -4 }, /* (458) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  428,   -2 }, /* (459) table_primary ::= subquery alias_opt */
  {  428,   -1 }, /* (460) table_primary ::= parenthesized_joined_table */
  {  430,    0 }, /* (461) alias_opt ::= */
  {  430,   -1 }, /* (462) alias_opt ::= table_alias */
  {  430,   -2 }, /* (463) alias_opt ::= AS table_alias */
  {  432,   -3 }, /* (464) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  432,   -3 }, /* (465) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  429,   -6 }, /* (466) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  433,    0 }, /* (467) join_type ::= */
  {  433,   -1 }, /* (468) join_type ::= INNER */
  {  435,  -12 }, /* (469) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  436,    0 }, /* (470) set_quantifier_opt ::= */
  {  436,   -1 }, /* (471) set_quantifier_opt ::= DISTINCT */
  {  436,   -1 }, /* (472) set_quantifier_opt ::= ALL */
  {  437,   -1 }, /* (473) select_list ::= select_item */
  {  437,   -3 }, /* (474) select_list ::= select_list NK_COMMA select_item */
  {  445,   -1 }, /* (475) select_item ::= NK_STAR */
  {  445,   -1 }, /* (476) select_item ::= common_expression */
  {  445,   -2 }, /* (477) select_item ::= common_expression column_alias */
  {  445,   -3 }, /* (478) select_item ::= common_expression AS column_alias */
  {  445,   -3 }, /* (479) select_item ::= table_name NK_DOT NK_STAR */
  {  400,    0 }, /* (480) where_clause_opt ::= */
  {  400,   -2 }, /* (481) where_clause_opt ::= WHERE search_condition */
  {  438,    0 }, /* (482) partition_by_clause_opt ::= */
  {  438,   -3 }, /* (483) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  446,   -1 }, /* (484) partition_list ::= partition_item */
  {  446,   -3 }, /* (485) partition_list ::= partition_list NK_COMMA partition_item */
  {  447,   -1 }, /* (486) partition_item ::= expr_or_subquery */
  {  447,   -2 }, /* (487) partition_item ::= expr_or_subquery column_alias */
  {  447,   -3 }, /* (488) partition_item ::= expr_or_subquery AS column_alias */
  {  442,    0 }, /* (489) twindow_clause_opt ::= */
  {  442,   -6 }, /* (490) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  442,   -4 }, /* (491) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  442,   -6 }, /* (492) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  442,   -8 }, /* (493) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  442,   -7 }, /* (494) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  385,    0 }, /* (495) sliding_opt ::= */
  {  385,   -4 }, /* (496) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  441,    0 }, /* (497) fill_opt ::= */
  {  441,   -4 }, /* (498) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  441,   -6 }, /* (499) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  448,   -1 }, /* (500) fill_mode ::= NONE */
  {  448,   -1 }, /* (501) fill_mode ::= PREV */
  {  448,   -1 }, /* (502) fill_mode ::= NULL */
  {  448,   -1 }, /* (503) fill_mode ::= LINEAR */
  {  448,   -1 }, /* (504) fill_mode ::= NEXT */
  {  443,    0 }, /* (505) group_by_clause_opt ::= */
  {  443,   -3 }, /* (506) group_by_clause_opt ::= GROUP BY group_by_list */
  {  449,   -1 }, /* (507) group_by_list ::= expr_or_subquery */
  {  449,   -3 }, /* (508) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  444,    0 }, /* (509) having_clause_opt ::= */
  {  444,   -2 }, /* (510) having_clause_opt ::= HAVING search_condition */
  {  439,    0 }, /* (511) range_opt ::= */
  {  439,   -6 }, /* (512) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  440,    0 }, /* (513) every_opt ::= */
  {  440,   -4 }, /* (514) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  450,   -4 }, /* (515) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  451,   -1 }, /* (516) query_simple ::= query_specification */
  {  451,   -1 }, /* (517) query_simple ::= union_query_expression */
  {  455,   -4 }, /* (518) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  455,   -3 }, /* (519) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  456,   -1 }, /* (520) query_simple_or_subquery ::= query_simple */
  {  456,   -1 }, /* (521) query_simple_or_subquery ::= subquery */
  {  389,   -1 }, /* (522) query_or_subquery ::= query_expression */
  {  389,   -1 }, /* (523) query_or_subquery ::= subquery */
  {  452,    0 }, /* (524) order_by_clause_opt ::= */
  {  452,   -3 }, /* (525) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  453,    0 }, /* (526) slimit_clause_opt ::= */
  {  453,   -2 }, /* (527) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  453,   -4 }, /* (528) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  453,   -4 }, /* (529) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  454,    0 }, /* (530) limit_clause_opt ::= */
  {  454,   -2 }, /* (531) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  454,   -4 }, /* (532) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  454,   -4 }, /* (533) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  431,   -3 }, /* (534) subquery ::= NK_LP query_expression NK_RP */
  {  431,   -3 }, /* (535) subquery ::= NK_LP subquery NK_RP */
  {  434,   -1 }, /* (536) search_condition ::= common_expression */
  {  457,   -1 }, /* (537) sort_specification_list ::= sort_specification */
  {  457,   -3 }, /* (538) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  458,   -3 }, /* (539) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  459,    0 }, /* (540) ordering_specification_opt ::= */
  {  459,   -1 }, /* (541) ordering_specification_opt ::= ASC */
  {  459,   -1 }, /* (542) ordering_specification_opt ::= DESC */
  {  460,    0 }, /* (543) null_ordering_opt ::= */
  {  460,   -2 }, /* (544) null_ordering_opt ::= NULLS FIRST */
  {  460,   -2 }, /* (545) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,326,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,327,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,326,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,328,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,329,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,327,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,328,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy77, &yymsp[-1].minor.yy0, yymsp[0].minor.yy287); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy77, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy77, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy77, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy287 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy287 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy717, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy717, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy717 = yymsp[0].minor.yy717; }
  yymsp[0].minor.yy717 = yylhsminor.yy717;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy717 = yymsp[-2].minor.yy717 | yymsp[0].minor.yy717; }
  yymsp[-2].minor.yy717 = yylhsminor.yy717;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy77 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy77 = yylhsminor.yy77;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy77 = yymsp[-2].minor.yy77; }
  yymsp[-2].minor.yy77 = yylhsminor.yy77;
        break;
      case 42: /* priv_level ::= topic_name */
      case 268: /* sma_func_name ::= function_name */ yytestcase(yyruleno==268);
      case 462: /* alias_opt ::= table_alias */ yytestcase(yyruleno==462);
{ yylhsminor.yy77 = yymsp[0].minor.yy77; }
  yymsp[0].minor.yy77 = yylhsminor.yy77;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy77, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy841); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy841); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 269: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==269);
      case 270: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==270);
      case 271: /* sma_func_name ::= LAST */ yytestcase(yyruleno==271);
      case 272: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==272);
      case 348: /* db_name ::= NK_ID */ yytestcase(yyruleno==348);
      case 349: /* table_name ::= NK_ID */ yytestcase(yyruleno==349);
      case 350: /* column_name ::= NK_ID */ yytestcase(yyruleno==350);
      case 351: /* function_name ::= NK_ID */ yytestcase(yyruleno==351);
      case 352: /* table_alias ::= NK_ID */ yytestcase(yyruleno==352);
      case 353: /* column_alias ::= NK_ID */ yytestcase(yyruleno==353);
      case 354: /* user_name ::= NK_ID */ yytestcase(yyruleno==354);
      case 355: /* topic_name ::= NK_ID */ yytestcase(yyruleno==355);
      case 356: /* stream_name ::= NK_ID */ yytestcase(yyruleno==356);
      case 357: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==357);
      case 397: /* noarg_func ::= NOW */ yytestcase(yyruleno==397);
      case 398: /* noarg_func ::= TODAY */ yytestcase(yyruleno==398);
      case 399: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==399);
      case 400: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==400);
      case 401: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==401);
      case 402: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==402);
      case 403: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==403);
      case 404: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==404);
      case 405: /* noarg_func ::= USER */ yytestcase(yyruleno==405);
      case 406: /* star_func ::= COUNT */ yytestcase(yyruleno==406);
      case 407: /* star_func ::= FIRST */ yytestcase(yyruleno==407);
      case 408: /* star_func ::= LAST */ yytestcase(yyruleno==408);
      case 409: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==409);
{ yylhsminor.yy77 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy77 = yylhsminor.yy77;
        break;
      case 54: /* force_opt ::= */
      case 74: /* not_exists_opt ::= */ yytestcase(yyruleno==74);
      case 76: /* exists_opt ::= */ yytestcase(yyruleno==76);
      case 288: /* analyze_opt ::= */ yytestcase(yyruleno==288);
      case 295: /* agg_func_opt ::= */ yytestcase(yyruleno==295);
      case 470: /* set_quantifier_opt ::= */ yytestcase(yyruleno==470);
{ yymsp[1].minor.yy841 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 289: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==289);
      case 296: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==296);
      case 471: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==471);
{ yymsp[0].minor.yy841 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy841, &yymsp[-1].minor.yy77, yymsp[0].minor.yy600); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy600); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy248); }
        break;
      case 72: /* cmd ::= COMPACT DATABASE db_name */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 73: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy841 = true; }
        break;
      case 75: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy841 = true; }
        break;
      case 77: /* db_options ::= */
{ yymsp[1].minor.yy600 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 78: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 79: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 80: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 81: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 82: /* db_options ::= db_options DURATION NK_INTEGER */
      case 83: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==83);
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 84: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 85: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 86: /* db_options ::= db_options KEEP integer_list */
      case 87: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==87);
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_KEEP, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 88: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 89: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 90: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 91: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 92: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 93: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 94: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 95: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_RETENTIONS, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 96: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 97: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 98: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-3].minor.yy600, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-3].minor.yy600, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 103: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 104: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 105: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 106: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 107: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 108: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy600 = createAlterDatabaseOptions(pCxt); yylhsminor.yy600 = setAlterDatabaseOption(pCxt, yylhsminor.yy600, &yymsp[0].minor.yy661); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 109: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy600 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy600, &yymsp[0].minor.yy661); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 110: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy661.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= KEEP integer_list */
      case 115: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==115);
{ yymsp[-1].minor.yy661.type = DB_OPTION_KEEP; yymsp[-1].minor.yy661.pList = yymsp[0].minor.yy601; }
        break;
      case 116: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_PAGES; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_WAL; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy601 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 121: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 318: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==318);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 122: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy601 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 123: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 124: /* retention_list ::= retention */
      case 146: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==146);
      case 149: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==149);
      case 156: /* column_def_list ::= column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name */ yytestcase(yyruleno==205);
      case 254: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==254);
      case 265: /* func_list ::= func */ yytestcase(yyruleno==265);
      case 346: /* literal_list ::= signed_literal */ yytestcase(yyruleno==346);
      case 412: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==412);
      case 418: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==418);
      case 473: /* select_list ::= select_item */ yytestcase(yyruleno==473);
      case 484: /* partition_list ::= partition_item */ yytestcase(yyruleno==484);
      case 537: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==537);
{ yylhsminor.yy601 = createNodeList(pCxt, yymsp[0].minor.yy600); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 125: /* retention_list ::= retention_list NK_COMMA retention */
      case 157: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==157);
      case 201: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==201);
      case 206: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==206);
      case 255: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==255);
      case 266: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==266);
      case 347: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==347);
      case 413: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==413);
      case 474: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==474);
      case 485: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==485);
      case 538: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==538);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, yymsp[0].minor.yy600); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 126: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy600 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 127: /* speed_opt ::= */
      case 297: /* bufsize_opt ::= */ yytestcase(yyruleno==297);
{ yymsp[1].minor.yy248 = 0; }
        break;
      case 128: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 298: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==298);
{ yymsp[-1].minor.yy248 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 129: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 131: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==131);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy841, yymsp[-5].minor.yy600, yymsp[-3].minor.yy601, yymsp[-1].minor.yy601, yymsp[0].minor.yy600); }
        break;
      case 130: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy601); }
        break;
      case 132: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy601); }
        break;
      case 133: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy841, yymsp[0].minor.yy600); }
        break;
      case 134: /* cmd ::= ALTER TABLE alter_table_clause */
      case 320: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==320);
{ pCxt->pRootNode = yymsp[0].minor.yy600; }
        break;
      case 135: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy600); }
        break;
      case 136: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy600 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 137: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 138: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy600 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy600, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy77); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 139: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 140: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy600 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 141: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 142: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy600 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy600, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy77); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 143: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 144: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy600 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 145: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy600 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy600, &yymsp[-2].minor.yy77, yymsp[0].minor.yy600); }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 147: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 150: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==150);
      case 419: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==419);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-1].minor.yy601, yymsp[0].minor.yy600); }
  yymsp[-1].minor.yy601 = yylhsminor.yy601;
        break;
      case 148: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy600 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy841, yymsp[-8].minor.yy600, yymsp[-6].minor.yy600, yymsp[-5].minor.yy601, yymsp[-2].minor.yy601, yymsp[0].minor.yy600); }
  yymsp[-9].minor.yy600 = yylhsminor.yy600;
        break;
      case 151: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy600 = createDropTableClause(pCxt, yymsp[-1].minor.yy841, yymsp[0].minor.yy600); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 152: /* specific_cols_opt ::= */
      case 183: /* tags_def_opt ::= */ yytestcase(yyruleno==183);
      case 253: /* tag_list_opt ::= */ yytestcase(yyruleno==253);
      case 482: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==482);
      case 505: /* group_by_clause_opt ::= */ yytestcase(yyruleno==505);
      case 524: /* order_by_clause_opt ::= */ yytestcase(yyruleno==524);
{ yymsp[1].minor.yy601 = NULL; }
        break;
      case 153: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy601 = yymsp[-1].minor.yy601; }
        break;
      case 154: /* full_table_name ::= table_name */
{ yylhsminor.yy600 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy77, NULL); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 155: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy600 = createRealTableNode(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77, NULL); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 158: /* column_def ::= column_name type_name */
{ yylhsminor.yy600 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888, NULL); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 159: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy600 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy77, yymsp[-2].minor.yy888, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 160: /* type_name ::= BOOL */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 161: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 162: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 163: /* type_name ::= INT */
      case 164: /* type_name ::= INTEGER */ yytestcase(yyruleno==164);
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 165: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 166: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 167: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 168: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 169: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 170: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 171: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 172: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 173: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 174: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 175: /* type_name ::= JSON */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 176: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 177: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 178: /* type_name ::= BLOB */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 179: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 180: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 182: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy888 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 184: /* tags_def_opt ::= tags_def */
      case 411: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==411);
{ yylhsminor.yy601 = yymsp[0].minor.yy601; }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 185: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy601 = yymsp[-1].minor.yy601; }
        break;
      case 186: /* table_options ::= */
{ yymsp[1].minor.yy600 = createDefaultTableOptions(pCxt); }
        break;
      case 187: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 188: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 189: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 190: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-4].minor.yy600, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy601); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 191: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 192: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-4].minor.yy600, TABLE_OPTION_SMA, yymsp[-1].minor.yy601); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 193: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 194: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy600 = createAlterTableOptions(pCxt); yylhsminor.yy600 = setTableOption(pCxt, yylhsminor.yy600, yymsp[0].minor.yy661.type, &yymsp[0].minor.yy661.val); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 195: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy661.type, &yymsp[0].minor.yy661.val); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 196: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy661.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy661.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 198: /* duration_list ::= duration_literal */
      case 375: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==375);
{ yylhsminor.yy601 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy600)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 199: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 376: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==376);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, releaseRawExprNode(pCxt, yymsp[0].minor.yy600)); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 202: /* rollup_func_name ::= function_name */
{ yylhsminor.yy600 = createFunctionNode(pCxt, &yymsp[0].minor.yy77, NULL); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 203: /* rollup_func_name ::= FIRST */
      case 204: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==204);
      case 257: /* tag_item ::= QTAGS */ yytestcase(yyruleno==257);
{ yylhsminor.yy600 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 207: /* col_name ::= column_name */
      case 258: /* tag_item ::= column_name */ yytestcase(yyruleno==258);
{ yylhsminor.yy600 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy77); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 208: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 209: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 210: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 211: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy600, yymsp[0].minor.yy600, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy600, yymsp[0].minor.yy600, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy600, NULL, OP_TYPE_LIKE); }
        break;
      case 215: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 217: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 218: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy600, yymsp[-1].minor.yy600, OP_TYPE_EQUAL); }
        break;
      case 219: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 220: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 221: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 222: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 223: /* cmd ::= SHOW LICENCES */
      case 224: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==224);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 225: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 226: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy600); }
        break;
      case 227: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy600); }
        break;
      case 228: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 229: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 230: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 231: /* cmd ::= SHOW VARIABLES */
      case 232: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==232);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 234: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy600); }
        break;
      case 235: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 237: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 238: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 239: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy600); }
        break;
      case 240: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 241: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 242: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy600, yymsp[-1].minor.yy600, OP_TYPE_EQUAL); }
        break;
      case 243: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy600, yymsp[-3].minor.yy601); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 245: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 246: /* db_name_cond_opt ::= */
      case 251: /* from_db_opt ::= */ yytestcase(yyruleno==251);
{ yymsp[1].minor.yy600 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 247: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy600 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 248: /* like_pattern_opt ::= */
      case 308: /* subtable_opt ::= */ yytestcase(yyruleno==308);
      case 421: /* case_when_else_opt ::= */ yytestcase(yyruleno==421);
      case 451: /* from_clause_opt ::= */ yytestcase(yyruleno==451);
      case 480: /* where_clause_opt ::= */ yytestcase(yyruleno==480);
      case 489: /* twindow_clause_opt ::= */ yytestcase(yyruleno==489);
      case 495: /* sliding_opt ::= */ yytestcase(yyruleno==495);
      case 497: /* fill_opt ::= */ yytestcase(yyruleno==497);
      case 509: /* having_clause_opt ::= */ yytestcase(yyruleno==509);
      case 511: /* range_opt ::= */ yytestcase(yyruleno==511);
      case 513: /* every_opt ::= */ yytestcase(yyruleno==513);
      case 526: /* slimit_clause_opt ::= */ yytestcase(yyruleno==526);
      case 530: /* limit_clause_opt ::= */ yytestcase(yyruleno==530);
{ yymsp[1].minor.yy600 = NULL; }
        break;
      case 249: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 250: /* table_name_cond ::= table_name */
{ yylhsminor.yy600 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy77); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 252: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy600 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 256: /* tag_item ::= TBNAME */
{ yylhsminor.yy600 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 259: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy600 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy77), &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 260: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy600 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy77), &yymsp[0].minor.yy77); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 261: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy841, yymsp[-3].minor.yy600, yymsp[-1].minor.yy600, NULL, yymsp[0].minor.yy600); }
        break;
      case 262: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy841, yymsp[0].minor.yy600); }
        break;
      case 263: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy600 = createIndexOption(pCxt, yymsp[-7].minor.yy601, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), NULL, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 264: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy600 = createIndexOption(pCxt, yymsp[-9].minor.yy601, releaseRawExprNode(pCxt, yymsp[-5].minor.yy600), releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 267: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy600 = createFunctionNode(pCxt, &yymsp[-3].minor.yy77, yymsp[-1].minor.yy601); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 273: /* sma_stream_opt ::= */
      case 301: /* stream_options ::= */ yytestcase(yyruleno==301);
{ yymsp[1].minor.yy600 = createStreamOptions(pCxt); }
        break;
      case 274: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 305: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==305);
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 275: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 276: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 277: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy841, &yymsp[-2].minor.yy77, yymsp[0].minor.yy600); }
        break;
      case 278: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy841, &yymsp[-3].minor.yy77, &yymsp[0].minor.yy77, false); }
        break;
      case 279: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy841, &yymsp[-5].minor.yy77, &yymsp[0].minor.yy77, true); }
        break;
      case 280: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy841, &yymsp[-3].minor.yy77, yymsp[0].minor.yy600, false); }
        break;
      case 281: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy841, &yymsp[-5].minor.yy77, yymsp[0].minor.yy600, true); }
        break;
      case 282: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 283: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy841, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77); }
        break;
      case 284: /* cmd ::= DESC full_table_name */
      case 285: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==285);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy600); }
        break;
      case 286: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 287: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy841, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 290: /* explain_options ::= */
{ yymsp[1].minor.yy600 = createDefaultExplainOptions(pCxt); }
        break;
      case 291: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy600 = setExplainVerbose(pCxt, yymsp[-2].minor.yy600, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 292: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy600 = setExplainRatio(pCxt, yymsp[-2].minor.yy600, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 293: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy841, yymsp[-8].minor.yy841, &yymsp[-5].minor.yy77, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy888, yymsp[0].minor.yy248); }
        break;
      case 294: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 299: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy841, &yymsp[-7].minor.yy77, yymsp[-4].minor.yy600, yymsp[-6].minor.yy600, yymsp[-3].minor.yy601, yymsp[-2].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 300: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 302: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 303: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 304: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy600)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy600)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-3].minor.yy600; }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 306: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy600)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy600 = yymsp[-3].minor.yy600; }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 307: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 309: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 496: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==496);
      case 514: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==514);
{ yymsp[-3].minor.yy600 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy600); }
        break;
      case 310: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 311: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 312: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 313: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 314: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 315: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy601); }
        break;
      case 316: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 317: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy601 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 319: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 321: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy600, yymsp[-2].minor.yy601, yymsp[0].minor.yy600); }
        break;
      case 322: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy600, NULL, yymsp[0].minor.yy600); }
        break;
      case 323: /* literal ::= NK_INTEGER */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 324: /* literal ::= NK_FLOAT */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 325: /* literal ::= NK_STRING */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 326: /* literal ::= NK_BOOL */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 327: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 328: /* literal ::= duration_literal */
      case 338: /* signed_literal ::= signed */ yytestcase(yyruleno==338);
      case 358: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==358);
      case 359: /* expression ::= literal */ yytestcase(yyruleno==359);
      case 360: /* expression ::= pseudo_column */ yytestcase(yyruleno==360);
      case 361: /* expression ::= column_reference */ yytestcase(yyruleno==361);
      case 362: /* expression ::= function_expression */ yytestcase(yyruleno==362);
      case 363: /* expression ::= case_when_expression */ yytestcase(yyruleno==363);
      case 394: /* function_expression ::= literal_func */ yytestcase(yyruleno==394);
      case 443: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==443);
      case 447: /* boolean_primary ::= predicate */ yytestcase(yyruleno==447);
      case 449: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==449);
      case 450: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==450);
      case 453: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==453);
      case 455: /* table_reference ::= table_primary */ yytestcase(yyruleno==455);
      case 456: /* table_reference ::= joined_table */ yytestcase(yyruleno==456);
      case 460: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==460);
      case 516: /* query_simple ::= query_specification */ yytestcase(yyruleno==516);
      case 517: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==517);
      case 520: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==520);
      case 522: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==522);
{ yylhsminor.yy600 = yymsp[0].minor.yy600; }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 329: /* literal ::= NULL */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 330: /* literal ::= NK_QUESTION */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 331: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 332: /* signed ::= NK_INTEGER */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 333: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 334: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 335: /* signed ::= NK_FLOAT */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 336: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 337: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 339: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 340: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 341: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 342: /* signed_literal ::= duration_literal */
      case 344: /* signed_literal ::= literal_func */ yytestcase(yyruleno==344);
      case 414: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==414);
      case 476: /* select_item ::= common_expression */ yytestcase(yyruleno==476);
      case 486: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==486);
      case 521: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==521);
      case 523: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==523);
      case 536: /* search_condition ::= common_expression */ yytestcase(yyruleno==536);
{ yylhsminor.yy600 = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 343: /* signed_literal ::= NULL */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 345: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy600 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 364: /* expression ::= NK_LP expression NK_RP */
      case 448: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==448);
      case 535: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==535);
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 365: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy600));
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 366: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy600), NULL));
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 367: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 368: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 369: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 370: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 371: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 372: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 373: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 374: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 377: /* column_reference ::= column_name */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy77, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy77)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 378: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77, createColumnNode(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 379: /* pseudo_column ::= ROWTS */
      case 380: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==380);
      case 382: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==382);
      case 383: /* pseudo_column ::= QEND */ yytestcase(yyruleno==383);
      case 384: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==384);
      case 385: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==385);
      case 386: /* pseudo_column ::= WEND */ yytestcase(yyruleno==386);
      case 387: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==387);
      case 388: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==388);
      case 389: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==389);
      case 390: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==390);
      case 396: /* literal_func ::= NOW */ yytestcase(yyruleno==396);
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 381: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy77)))); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 391: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 392: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==392);
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy77, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy77, yymsp[-1].minor.yy601)); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 393: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-1].minor.yy888)); }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 395: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy77, NULL)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 410: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy601 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 415: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 479: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==479);
{ yylhsminor.yy600 = createColumnNode(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 416: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy601, yymsp[-1].minor.yy600)); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 417: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-2].minor.yy601, yymsp[-1].minor.yy600)); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 420: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy600 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)); }
        break;
      case 422: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy600 = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); }
        break;
      case 423: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 428: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==428);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy666, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 424: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy600), releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 425: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy600), releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 426: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), NULL));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 427: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), NULL));
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 429: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy666 = OP_TYPE_LOWER_THAN; }
        break;
      case 430: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy666 = OP_TYPE_GREATER_THAN; }
        break;
      case 431: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy666 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 432: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy666 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 433: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy666 = OP_TYPE_NOT_EQUAL; }
        break;
      case 434: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy666 = OP_TYPE_EQUAL; }
        break;
      case 435: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy666 = OP_TYPE_LIKE; }
        break;
      case 436: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy666 = OP_TYPE_NOT_LIKE; }
        break;
      case 437: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy666 = OP_TYPE_MATCH; }
        break;
      case 438: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy666 = OP_TYPE_NMATCH; }
        break;
      case 439: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy666 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 440: /* in_op ::= IN */
{ yymsp[0].minor.yy666 = OP_TYPE_IN; }
        break;
      case 441: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy666 = OP_TYPE_NOT_IN; }
        break;
      case 442: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy601)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 444: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy600), NULL));
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 445: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 446: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 452: /* from_clause_opt ::= FROM table_reference_list */
      case 481: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==481);
      case 510: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==510);
{ yymsp[-1].minor.yy600 = yymsp[0].minor.yy600; }
        break;
      case 454: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy600 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy600, yymsp[0].minor.yy600, NULL); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 457: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy600 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 458: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy600 = createRealTableNode(pCxt, &yymsp[-3].minor.yy77, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 459: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy600 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600), &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 461: /* alias_opt ::= */
{ yymsp[1].minor.yy77 = nil_token;  }
        break;
      case 463: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy77 = yymsp[0].minor.yy77; }
        break;
      case 464: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 465: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==465);
{ yymsp[-2].minor.yy600 = yymsp[-1].minor.yy600; }
        break;
      case 466: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy600 = createJoinTableNode(pCxt, yymsp[-4].minor.yy560, yymsp[-5].minor.yy600, yymsp[-2].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 467: /* join_type ::= */
{ yymsp[1].minor.yy560 = JOIN_TYPE_INNER; }
        break;
      case 468: /* join_type ::= INNER */
{ yymsp[0].minor.yy560 = JOIN_TYPE_INNER; }
        break;
      case 469: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy600 = createSelectStmt(pCxt, yymsp[-10].minor.yy841, yymsp[-9].minor.yy601, yymsp[-8].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addWhereClause(pCxt, yymsp[-11].minor.yy600, yymsp[-7].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addPartitionByClause(pCxt, yymsp[-11].minor.yy600, yymsp[-6].minor.yy601);
                                                                                    yymsp[-11].minor.yy600 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy600, yymsp[-2].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addGroupByClause(pCxt, yymsp[-11].minor.yy600, yymsp[-1].minor.yy601);
                                                                                    yymsp[-11].minor.yy600 = addHavingClause(pCxt, yymsp[-11].minor.yy600, yymsp[0].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addRangeClause(pCxt, yymsp[-11].minor.yy600, yymsp[-5].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addEveryClause(pCxt, yymsp[-11].minor.yy600, yymsp[-4].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addFillClause(pCxt, yymsp[-11].minor.yy600, yymsp[-3].minor.yy600);
                                                                                  }
        break;
      case 472: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy841 = false; }
        break;
      case 475: /* select_item ::= NK_STAR */
{ yylhsminor.yy600 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 477: /* select_item ::= common_expression column_alias */
      case 487: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==487);
{ yylhsminor.yy600 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600), &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 478: /* select_item ::= common_expression AS column_alias */
      case 488: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==488);
{ yylhsminor.yy600 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), &yymsp[0].minor.yy77); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 483: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 506: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==506);
      case 525: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==525);
{ yymsp[-2].minor.yy601 = yymsp[0].minor.yy601; }
        break;
      case 490: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy600 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
        break;
      case 491: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy600 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
        break;
      case 492: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy600 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), NULL, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 493: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy600 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy600), releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 494: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy600 = createEventWindowNode(pCxt, yymsp[-3].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 498: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy600 = createFillNode(pCxt, yymsp[-1].minor.yy798, NULL); }
        break;
      case 499: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy600 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy601)); }
        break;
      case 500: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy798 = FILL_MODE_NONE; }
        break;
      case 501: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy798 = FILL_MODE_PREV; }
        break;
      case 502: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy798 = FILL_MODE_NULL; }
        break;
      case 503: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy798 = FILL_MODE_LINEAR; }
        break;
      case 504: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy798 = FILL_MODE_NEXT; }
        break;
      case 507: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy601 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 508: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 512: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy600 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
        break;
      case 515: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy600 = addOrderByClause(pCxt, yymsp[-3].minor.yy600, yymsp[-2].minor.yy601);
                                                                                    yylhsminor.yy600 = addSlimitClause(pCxt, yylhsminor.yy600, yymsp[-1].minor.yy600);
                                                                                    yylhsminor.yy600 = addLimitClause(pCxt, yylhsminor.yy600, yymsp[0].minor.yy600);
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 518: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy600 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 519: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy600 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 527: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 531: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==531);
{ yymsp[-1].minor.yy600 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 528: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 532: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==532);
{ yymsp[-3].minor.yy600 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 529: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 533: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==533);
{ yymsp[-3].minor.yy600 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 534: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy600); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 539: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy600 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), yymsp[-1].minor.yy32, yymsp[0].minor.yy385); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 540: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy32 = ORDER_ASC; }
        break;
      case 541: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy32 = ORDER_ASC; }
        break;
      case 542: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy32 = ORDER_DESC; }
        break;
      case 543: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy385 = NULL_ORDER_DEFAULT; }
        break;
      case 544: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy385 = NULL_ORDER_FIRST; }
        break;
      case 545: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy385 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
