---
sidebar_label: Go
title: Connect with Go Connector
---

## Add Dependency

add `driver-go` dependency in `go.mod` .

``` title="go.mod"
module goexample

go 1.17

require github.com/taosdata/driver-go/v2 develop
```

## Config

Run this command in your terminal to save TDengine cloud token as variables:

```bash
export TDENGINE_TOKEN=<token>
```

## Connect

```go
package main

import (
    "database/sql"
    "fmt"
    "os"

    _ "github.com/taosdata/driver-go/v2/taosRestful"
)

func main() {
    token := os.Getenv("TDENGIN_TOKEN")
    taosDSN := "https://cloud.taosdata.com?token=" + token
    taos, err := sql.Open("taosRestful", taosDSN)
    if err != nil {
        fmt.Println("failed to connect TDengine, err:", err)
        return
    }
    fmt.Println("Connected")
    defer taos.Close()
}
```