CMAKE_MINIMUM_REQUIRED(VERSION 2.8)
PROJECT(TDengine)

IF (DEFINED VERNUMBER)
  SET(TD_VER_NUMBER ${VERNUMBER})
ELSE ()
  SET(TD_VER_NUMBER "2.0.9.0")
ENDIF ()

IF (DEFINED VERCOMPATIBLE)
  SET(TD_VER_COMPATIBLE ${VERCOMPATIBLE})
ELSE ()
  SET(TD_VER_COMPATIBLE "2.0.0.0")
ENDIF ()

IF (DEFINED GITINFO)
  SET(TD_VER_GIT ${GITINFO})
ELSE ()
  SET(TD_VER_GIT "community")
ENDIF ()

IF (DEFINED GITINFOI)
  SET(TD_VER_GIT_INTERNAL ${GITINFOI})
ELSE ()
  SET(TD_VER_GIT_INTERNAL "internal")
ENDIF ()

IF (DEFINED VERDATE)
  SET(TD_VER_DATE ${VERDATE})
ELSE ()
  STRING(TIMESTAMP TD_VER_DATE "%Y-%m-%d %H:%M:%S") 
ENDIF ()

IF (DEFINED VERTYPE)
  SET(TD_VER_VERTYPE ${VERTYPE})
ELSE ()
  SET(TD_VER_VERTYPE "stable")
ENDIF ()

IF (DEFINED CPUTYPE)
  SET(TD_VER_CPUTYPE ${CPUTYPE})
ELSE ()
  IF (TD_WINDOWS_32)
    SET(TD_VER_CPUTYPE "x86")
  ELSEIF (TD_LINUX_32)
    SET(TD_VER_CPUTYPE "x86")  
  ELSEIF (TD_ARM_32)
    SET(TD_VER_CPUTYPE "x86")  
  ELSEIF (TD_MIPS_32)
    SET(TD_VER_CPUTYPE "x86")  
  ELSE ()
    SET(TD_VER_CPUTYPE "x64")
  ENDIF ()
ENDIF ()

IF (DEFINED OSTYPE)
  SET(TD_VER_OSTYPE ${OSTYPE})
ELSE ()
  SET(TD_VER_OSTYPE "Linux")
ENDIF ()

MESSAGE(STATUS "============= compile version parameter information start ============= ")
MESSAGE(STATUS "ver number:" ${TD_VER_NUMBER})
MESSAGE(STATUS "compatible ver number:" ${TD_VER_COMPATIBLE})
MESSAGE(STATUS "communit commit id:" ${TD_VER_GIT})
MESSAGE(STATUS "internal commit id:" ${TD_VER_GIT_INTERNAL})
MESSAGE(STATUS "build date:" ${TD_VER_DATE})
MESSAGE(STATUS "ver type:" ${TD_VER_VERTYPE})
MESSAGE(STATUS "ver cpu:" ${TD_VER_CPUTYPE})
MESSAGE(STATUS "os type:" ${TD_VER_OSTYPE})
MESSAGE(STATUS "============= compile version parameter information end  ============= ")

STRING(REPLACE "." "_" TD_LIB_VER_NUMBER ${TD_VER_NUMBER})

CONFIGURE_FILE("${TD_COMMUNITY_DIR}/src/util/src/version.c.in" "${TD_COMMUNITY_DIR}/src/util/src/version.c")
