/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 467
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EFillMode yy22;
  ENullOrder yy23;
  SNode* yy44;
  int64_t yy91;
  SAlterOption yy153;
  bool yy163;
  int8_t yy169;
  SDataType yy260;
  SToken yy455;
  EOrder yy490;
  SNodeList* yy684;
  EOperatorType yy704;
  EJoinType yy724;
  int32_t yy832;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             734
#define YYNRULE              558
#define YYNTOKEN             326
#define YY_MAX_SHIFT         733
#define YY_MIN_SHIFTREDUCE   1089
#define YY_MAX_SHIFTREDUCE   1646
#define YY_ERROR_ACTION      1647
#define YY_ACCEPT_ACTION     1648
#define YY_NO_ACTION         1649
#define YY_MIN_REDUCE        1650
#define YY_MAX_REDUCE        2207
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (3082)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   474, 1673,  475, 1686, 1886,  586, 1792,  604, 2007, 2178,
 /*    10 */  1788, 1856,   45,   43, 1576,  480, 1922,  175,  342, 2003,
 /*    20 */   374,  476, 1425, 1794,  585,  181,  419, 1854,  365, 2179,
 /*    30 */   587, 1919,  610, 1506, 2003, 1423, 2021, 2183,  344, 1905,
 /*    40 */  2007, 2178,   38,   37, 1922, 1989,   44,   42,   41,   40,
 /*    50 */    39, 2003,  562, 1999, 2005,  356, 2178, 2182, 1501, 1920,
 /*    60 */   610, 2179, 2181,   18,  633,  177,  327, 2039, 1999, 2005,
 /*    70 */  1431, 2184,  181,  366,  598,  637, 2179,  587, 1843,  633,
 /*    80 */  1989,  163,  639,   45,   43, 1999, 2005,  369,  586, 1959,
 /*    90 */  1805,  374, 2178, 1425,  163,   14,  633,  337,   44,   42,
 /*   100 */    41,   40,   39, 1806, 1506,  139, 1423,  585,  181,   35,
 /*   110 */   285, 2020, 2179,  587,  165, 2056, 1662,  730,  321, 2022,
 /*   120 */   643, 2024, 2025,  638,  636,  633,  624, 2074,  267, 1501,
 /*   130 */  1450, 2008, 1508, 1509,   18,  235,  379, 1982, 1535, 1849,
 /*   140 */  1851, 1431, 2003,  590, 1248,  665,  664,  663, 1252,  662,
 /*   150 */  1254, 1255,  661, 1257,  658,  437, 1263,  655, 1265, 1266,
 /*   160 */   652,  649, 1481, 1491,  436,   60,   14,   91, 1507, 1510,
 /*   170 */   264, 2117,  597, 1781,  132,  596, 1999, 2005, 2178,   41,
 /*   180 */    40,   39,  562, 1426, 1856, 1424, 2178,  633,  730,  348,
 /*   190 */  1122,  353, 1451,  585,  181, 1536, 1850, 1851, 2179,  587,
 /*   200 */  1854, 2184,  181, 1508, 1509,  166, 2179,  587, 1429, 1430,
 /*   210 */  1757, 1480, 1483, 1484, 1485, 1486, 1487, 1488, 1489, 1490,
 /*   220 */   635,  631, 1499, 1500, 1502, 1503, 1504, 1505,    2, 1124,
 /*   230 */  1975, 1127, 1128, 1481, 1491,  492,  622,   85,  121, 1507,
 /*   240 */  1510,  120,  119,  118,  117,  116,  115,  114,  113,  112,
 /*   250 */   349,  135,  347,  346, 1426,  515, 1424,   38,   37,  517,
 /*   260 */  1798,   44,   42,   41,   40,   39,  593,   34,  372, 1530,
 /*   270 */  1531, 1532, 1533, 1534, 1538, 1539, 1540, 1541,  394, 1429,
 /*   280 */  1430,  516, 1480, 1483, 1484, 1485, 1486, 1487, 1488, 1489,
 /*   290 */  1490,  635,  631, 1499, 1500, 1502, 1503, 1504, 1505,    2,
 /*   300 */   377,   11,   45,   43, 1291, 1292,  622,  219,  160,  622,
 /*   310 */   374,   48, 1425, 1651,  609,  354,  184, 1805, 1672, 1141,
 /*   320 */   598, 1140,  170, 1506, 1854, 1423, 2021, 1603,  509,  505,
 /*   330 */   501,  497,  216,  623,  121,  233,   60,  120,  119,  118,
 /*   340 */   117,  116,  115,  114,  113,  112, 1450,  131, 1501, 1580,
 /*   350 */  1142,  139, 1573,   18,  513, 1450,  483, 2039,  475, 1686,
 /*   360 */  1431,  490, 1989, 1915, 1803,  640,  591,  675,   86, 2124,
 /*   370 */  1989,  214,  639,   45,   43, 1511,  573, 1601, 1602, 1604,
 /*   380 */  1605,  374, 1671, 1425,   48,   14,  153,  152,  672,  671,
 /*   390 */   670,  150,  105, 1779, 1506, 2121, 1423, 2021,   88,  332,
 /*   400 */   608, 2020,  546, 2124,  544, 2056,  140,  730,  167, 2022,
 /*   410 */   643, 2024, 2025,  638, 1795,  633,  180, 2117, 2118, 1501,
 /*   420 */   137, 2122, 1508, 1509, 1643, 1450, 1989, 1452, 2039, 2120,
 /*   430 */    64, 1431,  175, 1141,  473, 1140,  640,  478, 1692,  213,
 /*   440 */   207, 1989,  482,  639,  212,  478, 1692,  488,  218,  563,
 /*   450 */  2146, 1670, 1481, 1491, 1906,  677,   46, 1208, 1507, 1510,
 /*   460 */   492,   38,   37,  205, 1142,   44,   42,   41,   40,   39,
 /*   470 */   581,   49, 2020, 1426, 1719, 1424, 2056,  677,  730,  168,
 /*   480 */  2022,  643, 2024, 2025,  638,    8,  633,  184, 1346, 1347,
 /*   490 */  1648,  594, 1210, 1508, 1509, 1989,  598, 1482, 1429, 1430,
 /*   500 */    60, 1480, 1483, 1484, 1485, 1486, 1487, 1488, 1489, 1490,
 /*   510 */   635,  631, 1499, 1500, 1502, 1503, 1504, 1505,    2, 1642,
 /*   520 */   623,   60, 1901, 1481, 1491,  524,  523,  139,  623, 1507,
 /*   530 */  1510,  588, 2199,  189,  186,  184,  623, 1451, 1449,  528,
 /*   540 */   527,  526,   54,  406, 1426, 1537, 1424,  136,  522, 1613,
 /*   550 */   417, 1803,  521, 2039, 1983,   60,  387,  520,  525, 1803,
 /*   560 */   386,  580,  551,  519,  408,  404,   11, 1803,    9, 1429,
 /*   570 */  1430,  266, 1480, 1483, 1484, 1485, 1486, 1487, 1488, 1489,
 /*   580 */  1490,  635,  631, 1499, 1500, 1502, 1503, 1504, 1505,    2,
 /*   590 */    45,   43,  182, 2117, 2118, 1572,  137, 2122,  374,  562,
 /*   600 */  1425,  562,  733, 2178, 2124, 2178,  579,  457, 2183,   13,
 /*   610 */    12, 1506, 2178, 1423, 2021,  623,  292,   32, 2184,  181,
 /*   620 */  2184,  181,  184, 2179,  587, 2179,  587, 1542, 2182,  418,
 /*   630 */  2119,  174, 2179, 2180,  609, 1450, 1501,  723,  719,  715,
 /*   640 */   711,  290,  411,  623,  410, 2039, 1803, 1856, 1431, 1363,
 /*   650 */  1364,  184, 1856,  640,  362,  701,  699,  427, 1989,  367,
 /*   660 */   639,   45,   43, 1854,   85,  197,  196,  409, 1854,  374,
 /*   670 */  1453, 1425,  184,   46, 1803, 2183,  141,  106,  598, 2080,
 /*   680 */   283,  607, 1506, 1915, 1423, 1362, 1365, 1799,  456, 2020,
 /*   690 */   413, 1569, 1452, 2056,  412,  730,  167, 2022,  643, 2024,
 /*   700 */  2025,  638, 1650,  633, 1549, 1453,  184, 1501, 1516,  139,
 /*   710 */  1508, 1509,  420,  619, 1450,  609,   38,   37,  234, 1431,
 /*   720 */    44,   42,   41,   40,   39,  421,  130,  129,  128,  127,
 /*   730 */   126,  125,  124,  123,  122,  562,  623,   11, 2147, 2178,
 /*   740 */  1481, 1491, 1856,  690,   14, 1773, 1507, 1510,  270,  378,
 /*   750 */   131,  668,   27,  269, 2184,  181,  576,  518, 1854, 2179,
 /*   760 */   587, 1426,  618, 1424, 1915, 1669,  730, 1803, 1636,  625,
 /*   770 */  1390, 2081,  238,  600,  179, 2117, 2118, 1482,  137, 2122,
 /*   780 */  1668, 1508, 1509, 1431, 1401, 1402, 1429, 1430,   99, 1480,
 /*   790 */  1483, 1484, 1485, 1486, 1487, 1488, 1489, 1490,  635,  631,
 /*   800 */  1499, 1500, 1502, 1503, 1504, 1505,    2,  623,  689, 1989,
 /*   810 */  1796, 1481, 1491,  330,  190, 1448,  623, 1507, 1510,  623,
 /*   820 */  1901,  442,  450,  224, 1989,  464,  222,  377,  463,  380,
 /*   830 */   443,  191, 1426,  491, 1424,  163,  266,  163, 1803,  542,
 /*   840 */   582,  577,  571,  433, 1805,  465, 1805, 1803,  435,  243,
 /*   850 */  1803, 1667,  540, 1666,  538, 2182, 1482, 1429, 1430, 1790,
 /*   860 */  1480, 1483, 1484, 1485, 1486, 1487, 1488, 1489, 1490,  635,
 /*   870 */   631, 1499, 1500, 1502, 1503, 1504, 1505,    2, 1665, 1664,
 /*   880 */   623,  276,  277,  164, 1661,  627,  275, 2081,  305,  345,
 /*   890 */  1716,  528,  527,  526, 1800, 1989, 1786, 1989,  623,  136,
 /*   900 */   522,  423,  303,   71,  521, 1901,   70, 1127, 1128,  520,
 /*   910 */   525, 1803,  236,   38,   37,  519,  195,   44,   42,   41,
 /*   920 */    40,   39, 1989, 1989,  201,  470,  468,  669, 1989, 1803,
 /*   930 */  1847,  461, 2129, 1569,  455,  454,  453,  452,  449,  448,
 /*   940 */   447,  446,  445,  441,  440,  439,  438,  329,  430,  429,
 /*   950 */   428, 1660,  425,  424,  343,  707,  706,  705,  704,  384,
 /*   960 */    60,  703,  702,  143,  697,  696,  695,  694,  693,  692,
 /*   970 */   691,  155,  687,  686,  685,  383,  382,  682,  681,  680,
 /*   980 */   679,  678,   38,   37,  623,  533,   44,   42,   41,   40,
 /*   990 */    39,  623,  667, 1659, 1453, 1989,  104,   31,  558,  107,
 /*  1000 */   543, 1592, 1780,   38,   37,  602,  101,   44,   42,   41,
 /*  1010 */    40,   39, 2021,   33,  232, 1803,  549, 1434,  623,   38,
 /*  1020 */    37,  623, 1803,   44,   42,   41,   40,   39, 1856,  536,
 /*  1030 */   239,  517,  606,  623,  530,  280,  623, 1989,  634,  231,
 /*  1040 */    79,   78,  416, 2039, 1855,  188, 1658,  620,  623, 1803,
 /*  1050 */   621,  601, 1803,  516,  299, 1706, 1989, 1833,  639, 1657,
 /*  1060 */  1656,  562,  286,  328, 1803, 2178,  402, 1803,  400,  396,
 /*  1070 */   392,  389,  409, 1778,  623,   68, 2021,  529,   67, 1803,
 /*  1080 */  2184,  181,  193, 1655,  557, 2179,  587, 2020,  381, 1425,
 /*  1090 */  1989, 2056, 1654, 1433,  108, 2022,  643, 2024, 2025,  638,
 /*  1100 */  1653,  633, 1423, 1989, 1989, 1803,  178, 2039, 2109,  675,
 /*  1110 */   630,  184,  368, 2105,   72,  640,  226,  589,   82,  225,
 /*  1120 */  1989,   81,  639,   51, 1663,    3,  183, 1989,  153,  152,
 /*  1130 */   672,  671,  670,  150, 2135, 2021, 1989, 1431,  244, 1758,
 /*  1140 */   673,   38,   37, 1847, 1989,   44,   42,   41,   40,   39,
 /*  1150 */   674, 2020, 2149, 1847,  151, 2056, 1699,  261,  108, 2022,
 /*  1160 */   643, 2024, 2025,  638,   80,  633, 2039, 1437,  142,  574,
 /*  1170 */   148, 2080, 2109,  145,  601,  133,  368, 2105,  531, 1989,
 /*  1180 */   675,  639, 1645, 1646,  730,   38,   37, 1697,  151,   44,
 /*  1190 */    42,   41,   40,   39,  228, 2021,  151,  227,  217,  153,
 /*  1200 */   152,  672,  671,  670,  150,  230,   53,  242,  229,  534,
 /*  1210 */  2020,   62,   47,  248, 2056,  151,   47,  108, 2022,  643,
 /*  1220 */  2024, 2025,  638,   52,  633, 2010, 2039, 1170, 2040,  178,
 /*  1230 */   561, 2109,   13,   12,  640,  368, 2105, 1693,  273, 1989,
 /*  1240 */  1396,  639,   69, 1436,  255,  385,   89,  149, 1399,  151,
 /*  1250 */  1426,   62, 1424,   47, 2021, 1527,  647, 2136,  149,  151,
 /*  1260 */   134,  149, 1171, 1600, 1492,  250, 1910,  605, 1360, 1687,
 /*  1270 */  2020, 1844, 2139, 2012, 2056, 1429, 1430,  108, 2022,  643,
 /*  1280 */  2024, 2025,  638,  599,  633, 2039,  725,  683, 2021, 2198,
 /*  1290 */   278, 2109,  684,  640,  615,  368, 2105,  162, 1989,  282,
 /*  1300 */   639, 1241,  260, 1543,  263,  298, 2143,  393, 1269, 1189,
 /*  1310 */  1273, 1280, 1278,  154, 1187,    1,    4,  388,  341, 2039,
 /*  1320 */  1383,  293,  194,  422, 1453, 1911,  426,  640,  431, 2020,
 /*  1330 */  1448,  459, 1989, 2056,  639,  444,  108, 2022,  643, 2024,
 /*  1340 */  2025,  638, 1903,  633,  451,  458,  460,  466, 2198,  467,
 /*  1350 */  2109,  198,  469,  471,  368, 2105, 1454,  472,  481, 1456,
 /*  1360 */   484,  204, 1451, 2020,  485, 2156,  206, 2056, 1455,  486,
 /*  1370 */   108, 2022,  643, 2024, 2025,  638, 1457,  633,  487,  209,
 /*  1380 */   489, 2021, 2198,  211, 2109,  493,   83,   84,  368, 2105,
 /*  1390 */  1144,  510,  215,  511,  512,  371,  370,  514, 1793,  569,
 /*  1400 */   550, 2021,  111, 1965,   87, 1439,  221,  331, 1964,  552,
 /*  1410 */   548,  147, 2039,  575, 1789,  237, 1506,  223, 1432,  294,
 /*  1420 */   640,  156,  157,  553, 1791, 1989, 1787,  639,  240,  158,
 /*  1430 */   159,  556, 2039,  559, 2155,  613,    7, 2154, 2131,  584,
 /*  1440 */   640, 1501,  254, 2140,  565, 1989,  171,  639,  566,  567,
 /*  1450 */   572,  357,  578, 1431, 2150,  256, 2020,  257, 2201,  564,
 /*  1460 */  2056,  358,  592,  108, 2022,  643, 2024, 2025,  638,  595,
 /*  1470 */   633,  246,  249,  258, 1569, 2198, 2020, 2109, 1452, 2177,
 /*  1480 */  2056,  368, 2105,  108, 2022,  643, 2024, 2025,  638,  138,
 /*  1490 */   633,  259, 2172,  262,  268, 2198, 2125, 2109,  603,   94,
 /*  1500 */   629,  368, 2105,  361, 1458, 1916,  295,  611,  612, 1930,
 /*  1510 */  1929, 1928, 2128,  296,  364,  616,   96,  617,  297, 1804,
 /*  1520 */    98,   59, 2090,  100,  645,  300, 1774, 1848,  726,  727,
 /*  1530 */   289,  729,  333,  302,  334,   50,  309,  323,  313, 1981,
 /*  1540 */  2021, 1980,  324, 1979,   76,  304, 1976,  390,  391, 1416,
 /*  1550 */  1417,  187,  395, 1974,  397,  398,  399, 1973, 1972,  401,
 /*  1560 */   403, 1971,  405, 1970,  407,   77, 1440, 1386, 1435, 1385,
 /*  1570 */  1942, 2039, 1941, 1940,  414,  415, 1939, 1938, 1337,  640,
 /*  1580 */  1894, 1893, 1891, 1890, 1989,  192,  639,  144, 1889, 1892,
 /*  1590 */  1888, 1443, 1445, 1887, 1885, 1884, 1883,  432, 1882,  434,
 /*  1600 */  2021,  146, 1866, 1865,  631, 1499, 1500, 1502, 1503, 1504,
 /*  1610 */  1505, 1896, 1881, 1880, 1879, 2020, 1878, 1877, 1876, 2056,
 /*  1620 */  1875, 1874,  108, 2022,  643, 2024, 2025,  638, 2021,  633,
 /*  1630 */  1873, 2039, 1872, 1871, 2084, 1870, 2109, 1869, 1868,  640,
 /*  1640 */   368, 2105, 1867, 1864, 1989, 1895,  639, 1863, 1862, 1339,
 /*  1650 */  1861, 1860, 1859,  462, 1858, 1857, 1721, 1216,  199, 2039,
 /*  1660 */  1720, 1718,  200, 1682,   74,  202, 2009,  640,  176, 1681,
 /*  1670 */  1955, 1130, 1989,  477,  639, 2020, 1129, 1949,  479, 2056,
 /*  1680 */   203, 1937,  108, 2022,  643, 2024, 2025,  638,   75,  633,
 /*  1690 */  1936,  210,  208, 1914, 2082, 2021, 2109, 1782, 1163, 1717,
 /*  1700 */   368, 2105, 1715, 2020,  496, 1713,  494, 2056, 1711,  498,
 /*  1710 */   108, 2022,  643, 2024, 2025,  638,  495,  633, 2021,  500,
 /*  1720 */   499,  502,  626,  503, 2109, 1709, 2039,  504,  368, 2105,
 /*  1730 */   507,  506, 1696,  508,  640, 1695, 1678, 1784, 1285, 1989,
 /*  1740 */    61,  639, 1284,  220, 1783, 1207, 1206, 1205, 1204, 2039,
 /*  1750 */   698,  700, 1201, 1200, 1198, 1199, 1707,  640, 1700,  532,
 /*  1760 */   350,  351, 1989,  352,  639, 1698,  535, 1677, 1676,  537,
 /*  1770 */  2020, 1675,  541,  110, 2056,  539, 1954,  109, 2022,  643,
 /*  1780 */  2024, 2025,  638, 1406,  633, 1408, 2021, 1405, 1948, 1392,
 /*  1790 */  1935, 2109,  545, 2020,  161, 2108, 2105, 2056, 1933,   26,
 /*  1800 */   109, 2022,  643, 2024, 2025,  638, 2021,  633,   55,   65,
 /*  1810 */   555,  554, 2183,   19, 2109,   16,   28, 2039,  628, 2105,
 /*  1820 */  1615,  245,  570,  355,  241,  640,  247,  253,  568,   58,
 /*  1830 */  1989,  252,  639, 2010,   20,   30,  560, 2039,    5, 1599,
 /*  1840 */   169,  251,   29,   63,   90,  640,   21,    6, 1630, 1629,
 /*  1850 */  1989, 1591,  639, 1635,  359, 1636,   17, 1634, 1633,  360,
 /*  1860 */  1566,  641, 1565,  265,   57, 2056, 1934, 1932,  109, 2022,
 /*  1870 */   643, 2024, 2025,  638,  172,  633, 1931, 1913,   93,   92,
 /*  1880 */   271, 2020, 2109,   56, 1912, 2056,  336, 2105,  109, 2022,
 /*  1890 */   643, 2024, 2025,  638,   22,  633, 2021,  272,   95, 1597,
 /*  1900 */   274,  279, 2109,   66,  284,   97,   23, 2106, 1518,  614,
 /*  1910 */    12, 1441,  101, 2059, 2021,   10,  281, 1496, 1473,  173,
 /*  1920 */  1517,  632,  185, 1528, 1494,   36,   15, 2039, 1493,   24,
 /*  1930 */  2021, 1465,  642,   25,  646,  640,  376, 1270,  648,  650,
 /*  1940 */  1989, 1267,  639,  644,  651, 2039, 1264,  653,  654,  656,
 /*  1950 */  1258,  657,  659,  640, 1256,  660, 1247,  287, 1989,  666,
 /*  1960 */   639, 2039, 1279, 1262,  102, 1261,  363, 1260,  103,  640,
 /*  1970 */  1275, 2020,  676,   73, 1989, 2056,  639, 1195,  315, 2022,
 /*  1980 */   643, 2024, 2025,  638, 1259,  633, 1161, 1194, 1193, 2020,
 /*  1990 */  1192, 1191, 1190, 2056, 1188, 1186,  168, 2022,  643, 2024,
 /*  2000 */  2025,  638, 2021,  633, 1185, 2020, 1184, 1214,  688, 2056,
 /*  2010 */   288, 1182,  322, 2022,  643, 2024, 2025,  638, 1181,  633,
 /*  2020 */  1180, 1179,  583, 1178, 2021, 1167, 1177, 1176, 1211, 1209,
 /*  2030 */  1173, 1172, 1169, 2039, 1714, 1168, 1166,  708, 1712, 1710,
 /*  2040 */  1708,  637,  712, 1694,  710,  716, 1989,  714,  639, 2200,
 /*  2050 */   718,  720,  709,  722,  713, 2039,  724,  717, 1119, 1674,
 /*  2060 */   373,  721,  728,  640,  291, 1649, 1427,  301, 1989,  731,
 /*  2070 */   639,  732, 1649, 1649, 1649, 1649, 1649, 2020, 1649, 1649,
 /*  2080 */  1649, 2056, 1649, 1649,  321, 2022,  643, 2024, 2025,  638,
 /*  2090 */  1649,  633, 2021, 2075, 1649, 1649, 1649, 1649, 1649, 2020,
 /*  2100 */  1649, 1649, 1649, 2056, 1649, 1649,  322, 2022,  643, 2024,
 /*  2110 */  2025,  638, 2021,  633, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2120 */  1649, 1649, 1649, 2039, 1649, 1649, 1649, 1649,  375, 1649,
 /*  2130 */  1649,  640, 1649, 1649, 1649, 1649, 1989, 1649,  639, 1649,
 /*  2140 */  1649, 1649, 1649, 2039, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2150 */  1649,  640, 1649, 1649, 1649, 1649, 1989, 1649,  639, 1649,
 /*  2160 */  1649, 1649, 1649, 1649, 1649, 1649, 1649, 2020, 1649, 1649,
 /*  2170 */  1649, 2056, 1649, 1649,  322, 2022,  643, 2024, 2025,  638,
 /*  2180 */  2021,  633, 1649, 1649, 1649, 1649, 1649,  547, 1649, 1649,
 /*  2190 */  1649, 2056, 1649, 1649,  317, 2022,  643, 2024, 2025,  638,
 /*  2200 */  2021,  633, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2210 */  1649, 2039, 1649, 1649, 1649, 1649, 1649, 1649, 1649,  640,
 /*  2220 */  1649, 1649, 1649, 1649, 1989, 1649,  639, 1649, 1649, 1649,
 /*  2230 */  1649, 2039, 1649, 1649, 1649, 1649, 1649, 1649, 1649,  640,
 /*  2240 */  1649, 1649, 1649, 1649, 1989, 1649,  639, 1649, 1649, 1649,
 /*  2250 */  1649, 1649, 1649, 1649, 1649, 2020, 1649, 2021, 1649, 2056,
 /*  2260 */  1649, 1649,  306, 2022,  643, 2024, 2025,  638, 1649,  633,
 /*  2270 */  1649, 1649, 1649, 1649, 1649, 2020, 1649, 1649, 1649, 2056,
 /*  2280 */  1649, 1649,  307, 2022,  643, 2024, 2025,  638, 2039,  633,
 /*  2290 */  1649, 2021, 1649, 1649, 1649, 1649,  640, 1649, 1649, 1649,
 /*  2300 */  1649, 1989, 1649,  639, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2310 */  1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 2021,
 /*  2320 */  1649, 1649, 2039, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2330 */   640, 1649, 2020, 1649, 1649, 1989, 2056,  639, 1649,  308,
 /*  2340 */  2022,  643, 2024, 2025,  638, 1649,  633, 1649, 1649, 1649,
 /*  2350 */  2039, 1649, 1649, 1649, 1649, 1649, 1649, 1649,  640, 1649,
 /*  2360 */  1649, 1649, 1649, 1989, 1649,  639, 2020, 1649, 1649, 1649,
 /*  2370 */  2056, 1649, 1649,  314, 2022,  643, 2024, 2025,  638, 2021,
 /*  2380 */   633, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2390 */  1649, 1649, 1649, 1649, 2020, 1649, 1649, 1649, 2056, 1649,
 /*  2400 */  2021,  318, 2022,  643, 2024, 2025,  638, 1649,  633, 1649,
 /*  2410 */  2039, 1649, 1649, 1649, 1649, 1649, 1649, 1649,  640, 1649,
 /*  2420 */  1649, 1649, 1649, 1989, 1649,  639, 1649, 1649, 1649, 1649,
 /*  2430 */  1649, 2039, 1649, 1649, 1649, 1649, 1649, 1649, 1649,  640,
 /*  2440 */  1649, 1649, 1649, 1649, 1989, 1649,  639, 1649, 1649, 1649,
 /*  2450 */  1649, 1649, 1649, 1649, 2020, 1649, 1649, 1649, 2056, 1649,
 /*  2460 */  1649,  310, 2022,  643, 2024, 2025,  638, 1649,  633, 1649,
 /*  2470 */  1649, 1649, 1649, 2021, 1649, 2020, 1649, 1649, 1649, 2056,
 /*  2480 */  1649, 1649,  319, 2022,  643, 2024, 2025,  638, 1649,  633,
 /*  2490 */  1649, 1649, 1649, 1649, 1649, 1649, 1649, 2021, 1649, 1649,
 /*  2500 */  1649, 1649, 1649, 1649, 2039, 1649, 1649, 1649, 1649, 1649,
 /*  2510 */  1649, 1649,  640, 1649, 1649, 1649, 1649, 1989, 1649,  639,
 /*  2520 */  1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 2039, 1649,
 /*  2530 */  1649, 1649, 1649, 1649, 1649, 1649,  640, 1649, 1649, 1649,
 /*  2540 */  1649, 1989, 1649,  639, 1649, 1649, 1649, 1649, 2020, 1649,
 /*  2550 */  1649, 1649, 2056, 1649, 2021,  311, 2022,  643, 2024, 2025,
 /*  2560 */   638, 1649,  633, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2570 */  1649, 1649, 2020, 1649, 2021, 1649, 2056, 1649, 1649,  320,
 /*  2580 */  2022,  643, 2024, 2025,  638, 2039,  633, 1649, 1649, 1649,
 /*  2590 */  1649, 1649, 1649,  640, 1649, 1649, 1649, 1649, 1989, 1649,
 /*  2600 */   639, 1649, 1649, 1649, 1649, 2039, 1649, 1649, 1649, 1649,
 /*  2610 */  1649, 1649, 1649,  640, 1649, 1649, 1649, 1649, 1989, 1649,
 /*  2620 */   639, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 2020,
 /*  2630 */  1649, 2021, 1649, 2056, 1649, 1649,  312, 2022,  643, 2024,
 /*  2640 */  2025,  638, 1649,  633, 1649, 1649, 1649, 1649, 1649, 2020,
 /*  2650 */  1649, 1649, 2021, 2056, 1649, 1649,  325, 2022,  643, 2024,
 /*  2660 */  2025,  638, 2039,  633, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2670 */   640, 1649, 1649, 1649, 1649, 1989, 1649,  639, 1649, 1649,
 /*  2680 */  2021, 1649, 1649, 2039, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2690 */  1649,  640, 1649, 1649, 1649, 1649, 1989, 1649,  639, 1649,
 /*  2700 */  1649, 1649, 1649, 1649, 1649, 1649, 2020, 1649, 1649, 1649,
 /*  2710 */  2056, 2039, 1649,  326, 2022,  643, 2024, 2025,  638,  640,
 /*  2720 */   633, 1649, 1649, 1649, 1989, 1649,  639, 2020, 1649, 1649,
 /*  2730 */  1649, 2056, 1649, 1649, 2033, 2022,  643, 2024, 2025,  638,
 /*  2740 */  2021,  633, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2750 */  1649, 1649, 1649, 1649, 1649, 2020, 1649, 1649, 1649, 2056,
 /*  2760 */  1649, 2021, 2032, 2022,  643, 2024, 2025,  638, 1649,  633,
 /*  2770 */  1649, 2039, 1649, 1649, 1649, 1649, 1649, 1649, 1649,  640,
 /*  2780 */  1649, 1649, 1649, 1649, 1989, 1649,  639, 1649, 1649, 1649,
 /*  2790 */  1649, 1649, 2039, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2800 */   640, 1649, 1649, 1649, 1649, 1989, 1649,  639, 1649, 1649,
 /*  2810 */  1649, 1649, 1649, 1649, 1649, 2020, 1649, 1649, 1649, 2056,
 /*  2820 */  1649, 1649, 2031, 2022,  643, 2024, 2025,  638, 1649,  633,
 /*  2830 */  1649, 1649, 1649, 1649, 2021, 1649, 2020, 1649, 1649, 1649,
 /*  2840 */  2056, 1649, 1649,  338, 2022,  643, 2024, 2025,  638, 1649,
 /*  2850 */   633, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 2021, 1649,
 /*  2860 */  1649, 1649, 1649, 1649, 1649, 2039, 1649, 1649, 1649, 1649,
 /*  2870 */  1649, 1649, 1649,  640, 1649, 1649, 1649, 1649, 1989, 1649,
 /*  2880 */   639, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 2039,
 /*  2890 */  1649, 1649, 1649, 1649, 1649, 1649, 1649,  640, 1649, 1649,
 /*  2900 */  1649, 1649, 1989, 1649,  639, 1649, 1649, 1649, 1649, 2020,
 /*  2910 */  1649, 1649, 1649, 2056, 1649, 2021,  339, 2022,  643, 2024,
 /*  2920 */  2025,  638, 1649,  633, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2930 */  1649, 1649, 1649, 2020, 1649, 2021, 1649, 2056, 1649, 1649,
 /*  2940 */   335, 2022,  643, 2024, 2025,  638, 2039,  633, 1649, 1649,
 /*  2950 */  1649, 1649, 1649, 1649,  640, 1649, 1649, 1649, 1649, 1989,
 /*  2960 */  1649,  639, 1649, 1649, 1649, 1649, 2039, 1649, 1649, 1649,
 /*  2970 */  1649, 1649, 1649, 1649,  640, 1649, 1649, 1649, 1649, 1989,
 /*  2980 */  1649,  639, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2990 */  2020, 1649, 2021, 1649, 2056, 1649, 1649,  340, 2022,  643,
 /*  3000 */  2024, 2025,  638, 1649,  633, 1649, 1649, 1649, 1649, 1649,
 /*  3010 */   641, 1649, 1649, 1649, 2056, 1649, 1649,  317, 2022,  643,
 /*  3020 */  2024, 2025,  638, 2039,  633, 1649, 1649, 1649, 1649, 1649,
 /*  3030 */  1649,  640, 1649, 1649, 1649, 1649, 1989, 1649,  639, 1649,
 /*  3040 */  1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  3050 */  1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  3060 */  1649, 1649, 1649, 1649, 1649, 1649, 1649, 2020, 1649, 1649,
 /*  3070 */  1649, 2056, 1649, 1649,  316, 2022,  643, 2024, 2025,  638,
 /*  3080 */  1649,  633,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   333,  329,  335,  336,    0,  437,  361,  392,  362,  441,
 /*    10 */   361,  360,   12,   13,   14,   14,  375,  360,  367,  373,
 /*    20 */    20,   20,   22,  362,  456,  457,  337,  376,  387,  461,
 /*    30 */   462,  390,  391,   33,  373,   35,  329,  437,  381,  382,
 /*    40 */   362,  441,    8,    9,  375,  373,   12,   13,   14,   15,
 /*    50 */    16,  373,  437,  407,  408,  409,  441,  457,   58,  390,
 /*    60 */   391,  461,  462,   63,  418,  359,  377,  360,  407,  408,
 /*    70 */    70,  456,  457,  352,  337,  368,  461,  462,  372,  418,
 /*    80 */   373,  360,  375,   12,   13,  407,  408,  409,  437,  356,
 /*    90 */   369,   20,  441,   22,  360,   95,  418,   63,   12,   13,
 /*   100 */    14,   15,   16,  369,   33,  368,   35,  456,  457,  426,
 /*   110 */   427,  404,  461,  462,  328,  408,  330,  117,  411,  412,
 /*   120 */   413,  414,  415,  416,  417,  418,  419,  420,   58,   58,
 /*   130 */    20,  362,  132,  133,   63,  402,  371,  392,  104,  374,
 /*   140 */   375,   70,  373,   44,  108,  109,  110,  111,  112,  113,
 /*   150 */   114,  115,  116,  117,  118,  151,  120,  121,  122,  123,
 /*   160 */   124,  125,  162,  163,  160,   95,   95,   97,  168,  169,
 /*   170 */   433,  434,  435,    0,  437,  438,  407,  408,  441,   14,
 /*   180 */    15,   16,  437,  183,  360,  185,  441,  418,  117,   37,
 /*   190 */     4,  367,   20,  456,  457,  161,  374,  375,  461,  462,
 /*   200 */   376,  456,  457,  132,  133,  344,  461,  462,  208,  209,
 /*   210 */   349,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,   43,
 /*   230 */     0,   45,   46,  162,  163,   62,   20,  343,   21,  168,
 /*   240 */   169,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   250 */    98,  357,  100,  101,  183,  103,  185,    8,    9,  107,
 /*   260 */   366,   12,   13,   14,   15,   16,   44,  233,  234,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,  242,  243,   48,  208,
 /*   280 */   209,  129,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   290 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*   300 */   352,  230,   12,   13,  132,  133,   20,   33,  360,   20,
 /*   310 */    20,   95,   22,    0,  337,  367,  246,  369,  329,   20,
 /*   320 */   337,   22,   48,   33,  376,   35,  329,  208,   54,   55,
 /*   330 */    56,   57,   58,  337,   21,  127,   95,   24,   25,   26,
 /*   340 */    27,   28,   29,   30,   31,   32,   20,  351,   58,   14,
 /*   350 */    51,  368,    4,   63,  358,   20,  333,  360,  335,  336,
 /*   360 */    70,  384,  373,  386,  368,  368,  267,  107,   94,  410,
 /*   370 */   373,   97,  375,   12,   13,   14,  257,  258,  259,  260,
 /*   380 */   261,   20,  329,   22,   95,   95,  126,  127,  128,  129,
 /*   390 */   130,  131,  341,    0,   33,  436,   35,  329,  190,  191,
 /*   400 */    20,  404,  194,  410,  196,  408,  355,  117,  411,  412,
 /*   410 */   413,  414,  415,  416,  363,  418,  433,  434,  435,   58,
 /*   420 */   437,  438,  132,  133,  175,   20,  373,   20,  360,  436,
 /*   430 */     4,   70,  360,   20,  334,   22,  368,  337,  338,  165,
 /*   440 */   166,  373,  334,  375,  170,  337,  338,  173,   35,  452,
 /*   450 */   453,  329,  162,  163,  382,   62,   95,   35,  168,  169,
 /*   460 */    62,    8,    9,  189,   51,   12,   13,   14,   15,   16,
 /*   470 */    20,   95,  404,  183,    0,  185,  408,   62,  117,  411,
 /*   480 */   412,  413,  414,  415,  416,   39,  418,  246,  162,  163,
 /*   490 */   326,  269,   70,  132,  133,  373,  337,  162,  208,  209,
 /*   500 */    95,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   510 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  270,
 /*   520 */   337,   95,  368,  162,  163,  346,  347,  368,  337,  168,
 /*   530 */   169,  463,  464,  379,  351,  246,  337,   20,   20,   65,
 /*   540 */    66,   67,  351,  178,  183,  161,  185,   73,   74,   96,
 /*   550 */   351,  368,   78,  360,  392,   95,  392,   83,   84,  368,
 /*   560 */   396,  368,  106,   89,  199,  200,  230,  368,  232,  208,
 /*   570 */   209,  164,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   580 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*   590 */    12,   13,  433,  434,  435,  247,  437,  438,   20,  437,
 /*   600 */    22,  437,   19,  441,  410,  441,  413,   79,  437,    1,
 /*   610 */     2,   33,  441,   35,  329,  337,   33,  233,  456,  457,
 /*   620 */   456,  457,  246,  461,  462,  461,  462,  243,  457,  351,
 /*   630 */   436,   48,  461,  462,  337,   20,   58,   54,   55,   56,
 /*   640 */    57,   58,  182,  337,  184,  360,  368,  360,   70,  132,
 /*   650 */   133,  246,  360,  368,  367,  346,  347,  351,  373,  367,
 /*   660 */   375,   12,   13,  376,  343,  137,  138,  207,  376,   20,
 /*   670 */    20,   22,  246,   95,  368,    3,  421,   94,  337,  424,
 /*   680 */    97,  384,   33,  386,   35,  168,  169,  366,  160,  404,
 /*   690 */   392,  245,   20,  408,  396,  117,  411,  412,  413,  414,
 /*   700 */   415,  416,    0,  418,   96,   20,  246,   58,   14,  368,
 /*   710 */   132,  133,   22,  130,   20,  337,    8,    9,  126,   70,
 /*   720 */    12,   13,   14,   15,   16,   35,   24,   25,   26,   27,
 /*   730 */    28,   29,   30,   31,   32,  437,  337,  230,  453,  441,
 /*   740 */   162,  163,  360,  348,   95,  350,  168,  169,  165,  367,
 /*   750 */   351,  106,   44,  170,  456,  457,  167,  358,  376,  461,
 /*   760 */   462,  183,  384,  185,  386,  329,  117,  368,   96,  422,
 /*   770 */   187,  424,  189,  432,  433,  434,  435,  162,  437,  438,
 /*   780 */   329,  132,  133,   70,  192,  193,  208,  209,  341,  211,
 /*   790 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   800 */   222,  223,  224,  225,  226,  227,  228,  337,   70,  373,
 /*   810 */   363,  162,  163,   18,  164,   20,  337,  168,  169,  337,
 /*   820 */   368,  351,   27,   99,  373,   30,  102,  352,   33,  352,
 /*   830 */   351,  379,  183,  351,  185,  360,  164,  360,  368,   21,
 /*   840 */   251,  252,  253,   48,  369,   50,  369,  368,   53,  164,
 /*   850 */   368,  329,   34,  329,   36,    3,  162,  208,  209,  361,
 /*   860 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   870 */   221,  222,  223,  224,  225,  226,  227,  228,  329,  329,
 /*   880 */   337,  126,  127,   18,  329,  422,  131,  424,   23,   94,
 /*   890 */     0,   65,   66,   67,  351,  373,  361,  373,  337,   73,
 /*   900 */    74,  106,   37,   38,   78,  368,   41,   45,   46,   83,
 /*   910 */    84,  368,  351,    8,    9,   89,  379,   12,   13,   14,
 /*   920 */    15,   16,  373,  373,   59,   60,   61,  370,  373,  368,
 /*   930 */   373,  136,  244,  245,  139,  140,  141,  142,  143,  144,
 /*   940 */   145,  146,  147,  148,  149,  150,  151,  152,  153,  154,
 /*   950 */   155,  329,  157,  158,  159,   65,   66,   67,   68,   69,
 /*   960 */    95,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   970 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   980 */    90,   91,    8,    9,  337,    4,   12,   13,   14,   15,
 /*   990 */    16,  337,  361,  329,   20,  373,   95,    2,  351,  134,
 /*  1000 */    19,   96,    0,    8,    9,  351,  105,   12,   13,   14,
 /*  1010 */    15,   16,  329,    2,   33,  368,  392,   35,  337,    8,
 /*  1020 */     9,  337,  368,   12,   13,   14,   15,   16,  360,   48,
 /*  1030 */   361,  107,  351,  337,   53,  351,  337,  373,  361,   58,
 /*  1040 */   175,  176,  177,  360,  376,  180,  329,  351,  337,  368,
 /*  1050 */   351,  368,  368,  129,  353,    0,  373,  356,  375,  329,
 /*  1060 */   329,  437,  351,  198,  368,  441,  201,  368,  203,  204,
 /*  1070 */   205,  206,  207,    0,  337,   94,  329,   22,   97,  368,
 /*  1080 */   456,  457,   58,  329,  397,  461,  462,  404,  351,   22,
 /*  1090 */   373,  408,  329,   35,  411,  412,  413,  414,  415,  416,
 /*  1100 */   329,  418,   35,  373,  373,  368,  423,  360,  425,  107,
 /*  1110 */    63,  246,  429,  430,  106,  368,   99,  265,   94,  102,
 /*  1120 */   373,   97,  375,   42,  330,   44,  443,  373,  126,  127,
 /*  1130 */   128,  129,  130,  131,  451,  329,  373,   70,  164,  349,
 /*  1140 */   370,    8,    9,  373,  373,   12,   13,   14,   15,   16,
 /*  1150 */   370,  404,  383,  373,   44,  408,    0,  465,  411,  412,
 /*  1160 */   413,  414,  415,  416,  156,  418,  360,  185,  421,  454,
 /*  1170 */   423,  424,  425,   42,  368,   44,  429,  430,   22,  373,
 /*  1180 */   107,  375,  132,  133,  117,    8,    9,    0,   44,   12,
 /*  1190 */    13,   14,   15,   16,   99,  329,   44,  102,  339,  126,
 /*  1200 */   127,  128,  129,  130,  131,   99,   96,   58,  102,   22,
 /*  1210 */   404,   44,   44,   44,  408,   44,   44,  411,  412,  413,
 /*  1220 */   414,  415,  416,  164,  418,   47,  360,   35,  360,  423,
 /*  1230 */   171,  425,    1,    2,  368,  429,  430,    0,   44,  373,
 /*  1240 */    96,  375,   44,  185,  448,  339,   97,   44,   96,   44,
 /*  1250 */   183,   44,  185,   44,  329,  208,   44,  451,   44,   44,
 /*  1260 */    44,   44,   70,   96,   96,   96,  383,   96,   96,  336,
 /*  1270 */   404,  372,  383,   95,  408,  208,  209,  411,  412,  413,
 /*  1280 */   414,  415,  416,  439,  418,  360,   49,   13,  329,  423,
 /*  1290 */    96,  425,   13,  368,   96,  429,  430,  164,  373,   96,
 /*  1300 */   375,   96,  431,   96,  458,   96,  440,   48,   96,   35,
 /*  1310 */    96,   96,   96,   96,   35,  442,  248,  406,  405,  360,
 /*  1320 */   181,  394,   42,  380,   20,  383,  380,  368,  378,  404,
 /*  1330 */    20,  161,  373,  408,  375,  337,  411,  412,  413,  414,
 /*  1340 */   415,  416,  337,  418,  380,  378,  378,   93,  423,  345,
 /*  1350 */   425,  337,  337,  337,  429,  430,   20,  331,  331,   20,
 /*  1360 */   399,  343,   20,  404,  375,  440,  343,  408,   20,  338,
 /*  1370 */   411,  412,  413,  414,  415,  416,   20,  418,  393,  343,
 /*  1380 */   338,  329,  423,  343,  425,  337,  343,  343,  429,  430,
 /*  1390 */    52,  340,  343,  340,  331,   12,   13,  360,  360,  440,
 /*  1400 */   403,  329,  337,  373,   95,   22,  360,  331,  373,  188,
 /*  1410 */   197,  401,  360,  256,  360,  341,   33,  360,   35,  399,
 /*  1420 */   368,  360,  360,  398,  360,  373,  360,  375,  341,  360,
 /*  1430 */   360,  375,  360,  337,  447,  255,  262,  447,  450,  174,
 /*  1440 */   368,   58,  449,  383,  263,  373,  447,  375,  373,  264,
 /*  1450 */   373,  373,  373,   70,  383,  446,  404,  445,  466,  249,
 /*  1460 */   408,  271,  266,  411,  412,  413,  414,  415,  416,  268,
 /*  1470 */   418,  388,  388,  444,  245,  423,  404,  425,   20,  460,
 /*  1480 */   408,  429,  430,  411,  412,  413,  414,  415,  416,  368,
 /*  1490 */   418,  406,  440,  459,  341,  423,  410,  425,  337,  341,
 /*  1500 */   117,  429,  430,  338,   20,  386,  388,  373,  373,  373,
 /*  1510 */   373,  373,  440,  388,  373,  166,  341,  385,  356,  368,
 /*  1520 */   341,   95,  428,   95,  364,  337,  350,  373,   36,  332,
 /*  1530 */   341,  331,  389,  342,  389,  395,  354,  354,  354,    0,
 /*  1540 */   329,    0,  400,    0,   42,  327,    0,   35,  202,   35,
 /*  1550 */    35,   35,  202,    0,   35,   35,  202,    0,    0,  202,
 /*  1560 */    35,    0,   22,    0,   35,  190,  183,  185,  185,  183,
 /*  1570 */     0,  360,    0,    0,  179,  178,    0,    0,   47,  368,
 /*  1580 */     0,    0,    0,    0,  373,  151,  375,   42,    0,    0,
 /*  1590 */     0,  208,  209,    0,    0,    0,    0,   35,    0,  151,
 /*  1600 */   329,   42,    0,    0,  221,  222,  223,  224,  225,  226,
 /*  1610 */   227,    0,    0,    0,    0,  404,    0,    0,    0,  408,
 /*  1620 */     0,    0,  411,  412,  413,  414,  415,  416,  329,  418,
 /*  1630 */     0,  360,    0,    0,  423,    0,  425,    0,    0,  368,
 /*  1640 */   429,  430,    0,    0,  373,    0,  375,    0,    0,   22,
 /*  1650 */     0,    0,    0,  135,    0,    0,    0,   35,   58,  360,
 /*  1660 */     0,    0,   58,    0,   39,   42,   47,  368,   44,    0,
 /*  1670 */     0,   14,  373,   47,  375,  404,   14,    0,   47,  408,
 /*  1680 */    40,    0,  411,  412,  413,  414,  415,  416,   39,  418,
 /*  1690 */     0,  174,   39,    0,  423,  329,  425,    0,   64,    0,
 /*  1700 */   429,  430,    0,  404,   39,    0,   35,  408,    0,   35,
 /*  1710 */   411,  412,  413,  414,  415,  416,   48,  418,  329,   39,
 /*  1720 */    48,   35,  423,   48,  425,    0,  360,   39,  429,  430,
 /*  1730 */    48,   35,    0,   39,  368,    0,    0,    0,   35,  373,
 /*  1740 */   104,  375,   22,  102,    0,   35,   35,   35,   35,  360,
 /*  1750 */    44,   44,   35,   35,   35,   22,    0,  368,    0,   50,
 /*  1760 */    22,   22,  373,   22,  375,    0,   35,    0,    0,   35,
 /*  1770 */   404,    0,   22,   20,  408,   35,    0,  411,  412,  413,
 /*  1780 */   414,  415,  416,   35,  418,   96,  329,   35,    0,   35,
 /*  1790 */     0,  425,  195,  404,  186,  429,  430,  408,    0,   95,
 /*  1800 */   411,  412,  413,  414,  415,  416,  329,  418,  164,   95,
 /*  1810 */   164,   22,    3,   44,  425,  250,   95,  360,  429,  430,
 /*  1820 */    96,   95,  254,  164,  166,  368,   96,   47,  229,   44,
 /*  1830 */   373,   44,  375,   47,  250,   44,  172,  360,  171,   96,
 /*  1840 */    95,   95,   95,    3,   95,  368,   44,  171,   35,   35,
 /*  1850 */   373,   96,  375,   96,   35,   96,  250,   35,   35,   35,
 /*  1860 */    96,  404,   96,   47,   44,  408,    0,    0,  411,  412,
 /*  1870 */   413,  414,  415,  416,   47,  418,    0,    0,   39,   95,
 /*  1880 */    47,  404,  425,  244,    0,  408,  429,  430,  411,  412,
 /*  1890 */   413,  414,  415,  416,   95,  418,  329,   96,   39,   96,
 /*  1900 */    95,   95,  425,   95,   47,   95,   44,  430,  229,  167,
 /*  1910 */     2,   22,  105,   95,  329,  231,  165,   96,   22,   47,
 /*  1920 */   229,   95,   47,  208,   96,   95,   95,  360,   96,   95,
 /*  1930 */   329,   96,  210,   95,   35,  368,   35,   96,   95,   35,
 /*  1940 */   373,   96,  375,  106,   95,  360,   96,   35,   95,   35,
 /*  1950 */    96,   95,   35,  368,   96,   95,   22,   44,  373,  107,
 /*  1960 */   375,  360,   35,  119,   95,  119,  365,  119,   95,  368,
 /*  1970 */    22,  404,   63,   95,  373,  408,  375,   35,  411,  412,
 /*  1980 */   413,  414,  415,  416,  119,  418,   64,   35,   35,  404,
 /*  1990 */    35,   35,   35,  408,   35,   35,  411,  412,  413,  414,
 /*  2000 */   415,  416,  329,  418,   35,  404,   35,   70,   92,  408,
 /*  2010 */    44,   35,  411,  412,  413,  414,  415,  416,   35,  418,
 /*  2020 */    35,   22,  455,   35,  329,   22,   35,   35,   70,   35,
 /*  2030 */    35,   35,   35,  360,    0,   35,   35,   35,    0,    0,
 /*  2040 */     0,  368,   35,    0,   39,   35,  373,   39,  375,  464,
 /*  2050 */    39,   35,   48,   39,   48,  360,   35,   48,   35,    0,
 /*  2060 */   365,   48,   21,  368,   22,  467,   22,   22,  373,   21,
 /*  2070 */   375,   20,  467,  467,  467,  467,  467,  404,  467,  467,
 /*  2080 */   467,  408,  467,  467,  411,  412,  413,  414,  415,  416,
 /*  2090 */   467,  418,  329,  420,  467,  467,  467,  467,  467,  404,
 /*  2100 */   467,  467,  467,  408,  467,  467,  411,  412,  413,  414,
 /*  2110 */   415,  416,  329,  418,  467,  467,  467,  467,  467,  467,
 /*  2120 */   467,  467,  467,  360,  467,  467,  467,  467,  365,  467,
 /*  2130 */   467,  368,  467,  467,  467,  467,  373,  467,  375,  467,
 /*  2140 */   467,  467,  467,  360,  467,  467,  467,  467,  467,  467,
 /*  2150 */   467,  368,  467,  467,  467,  467,  373,  467,  375,  467,
 /*  2160 */   467,  467,  467,  467,  467,  467,  467,  404,  467,  467,
 /*  2170 */   467,  408,  467,  467,  411,  412,  413,  414,  415,  416,
 /*  2180 */   329,  418,  467,  467,  467,  467,  467,  404,  467,  467,
 /*  2190 */   467,  408,  467,  467,  411,  412,  413,  414,  415,  416,
 /*  2200 */   329,  418,  467,  467,  467,  467,  467,  467,  467,  467,
 /*  2210 */   467,  360,  467,  467,  467,  467,  467,  467,  467,  368,
 /*  2220 */   467,  467,  467,  467,  373,  467,  375,  467,  467,  467,
 /*  2230 */   467,  360,  467,  467,  467,  467,  467,  467,  467,  368,
 /*  2240 */   467,  467,  467,  467,  373,  467,  375,  467,  467,  467,
 /*  2250 */   467,  467,  467,  467,  467,  404,  467,  329,  467,  408,
 /*  2260 */   467,  467,  411,  412,  413,  414,  415,  416,  467,  418,
 /*  2270 */   467,  467,  467,  467,  467,  404,  467,  467,  467,  408,
 /*  2280 */   467,  467,  411,  412,  413,  414,  415,  416,  360,  418,
 /*  2290 */   467,  329,  467,  467,  467,  467,  368,  467,  467,  467,
 /*  2300 */   467,  373,  467,  375,  467,  467,  467,  467,  467,  467,
 /*  2310 */   467,  467,  467,  467,  467,  467,  467,  467,  467,  329,
 /*  2320 */   467,  467,  360,  467,  467,  467,  467,  467,  467,  467,
 /*  2330 */   368,  467,  404,  467,  467,  373,  408,  375,  467,  411,
 /*  2340 */   412,  413,  414,  415,  416,  467,  418,  467,  467,  467,
 /*  2350 */   360,  467,  467,  467,  467,  467,  467,  467,  368,  467,
 /*  2360 */   467,  467,  467,  373,  467,  375,  404,  467,  467,  467,
 /*  2370 */   408,  467,  467,  411,  412,  413,  414,  415,  416,  329,
 /*  2380 */   418,  467,  467,  467,  467,  467,  467,  467,  467,  467,
 /*  2390 */   467,  467,  467,  467,  404,  467,  467,  467,  408,  467,
 /*  2400 */   329,  411,  412,  413,  414,  415,  416,  467,  418,  467,
 /*  2410 */   360,  467,  467,  467,  467,  467,  467,  467,  368,  467,
 /*  2420 */   467,  467,  467,  373,  467,  375,  467,  467,  467,  467,
 /*  2430 */   467,  360,  467,  467,  467,  467,  467,  467,  467,  368,
 /*  2440 */   467,  467,  467,  467,  373,  467,  375,  467,  467,  467,
 /*  2450 */   467,  467,  467,  467,  404,  467,  467,  467,  408,  467,
 /*  2460 */   467,  411,  412,  413,  414,  415,  416,  467,  418,  467,
 /*  2470 */   467,  467,  467,  329,  467,  404,  467,  467,  467,  408,
 /*  2480 */   467,  467,  411,  412,  413,  414,  415,  416,  467,  418,
 /*  2490 */   467,  467,  467,  467,  467,  467,  467,  329,  467,  467,
 /*  2500 */   467,  467,  467,  467,  360,  467,  467,  467,  467,  467,
 /*  2510 */   467,  467,  368,  467,  467,  467,  467,  373,  467,  375,
 /*  2520 */   467,  467,  467,  467,  467,  467,  467,  467,  360,  467,
 /*  2530 */   467,  467,  467,  467,  467,  467,  368,  467,  467,  467,
 /*  2540 */   467,  373,  467,  375,  467,  467,  467,  467,  404,  467,
 /*  2550 */   467,  467,  408,  467,  329,  411,  412,  413,  414,  415,
 /*  2560 */   416,  467,  418,  467,  467,  467,  467,  467,  467,  467,
 /*  2570 */   467,  467,  404,  467,  329,  467,  408,  467,  467,  411,
 /*  2580 */   412,  413,  414,  415,  416,  360,  418,  467,  467,  467,
 /*  2590 */   467,  467,  467,  368,  467,  467,  467,  467,  373,  467,
 /*  2600 */   375,  467,  467,  467,  467,  360,  467,  467,  467,  467,
 /*  2610 */   467,  467,  467,  368,  467,  467,  467,  467,  373,  467,
 /*  2620 */   375,  467,  467,  467,  467,  467,  467,  467,  467,  404,
 /*  2630 */   467,  329,  467,  408,  467,  467,  411,  412,  413,  414,
 /*  2640 */   415,  416,  467,  418,  467,  467,  467,  467,  467,  404,
 /*  2650 */   467,  467,  329,  408,  467,  467,  411,  412,  413,  414,
 /*  2660 */   415,  416,  360,  418,  467,  467,  467,  467,  467,  467,
 /*  2670 */   368,  467,  467,  467,  467,  373,  467,  375,  467,  467,
 /*  2680 */   329,  467,  467,  360,  467,  467,  467,  467,  467,  467,
 /*  2690 */   467,  368,  467,  467,  467,  467,  373,  467,  375,  467,
 /*  2700 */   467,  467,  467,  467,  467,  467,  404,  467,  467,  467,
 /*  2710 */   408,  360,  467,  411,  412,  413,  414,  415,  416,  368,
 /*  2720 */   418,  467,  467,  467,  373,  467,  375,  404,  467,  467,
 /*  2730 */   467,  408,  467,  467,  411,  412,  413,  414,  415,  416,
 /*  2740 */   329,  418,  467,  467,  467,  467,  467,  467,  467,  467,
 /*  2750 */   467,  467,  467,  467,  467,  404,  467,  467,  467,  408,
 /*  2760 */   467,  329,  411,  412,  413,  414,  415,  416,  467,  418,
 /*  2770 */   467,  360,  467,  467,  467,  467,  467,  467,  467,  368,
 /*  2780 */   467,  467,  467,  467,  373,  467,  375,  467,  467,  467,
 /*  2790 */   467,  467,  360,  467,  467,  467,  467,  467,  467,  467,
 /*  2800 */   368,  467,  467,  467,  467,  373,  467,  375,  467,  467,
 /*  2810 */   467,  467,  467,  467,  467,  404,  467,  467,  467,  408,
 /*  2820 */   467,  467,  411,  412,  413,  414,  415,  416,  467,  418,
 /*  2830 */   467,  467,  467,  467,  329,  467,  404,  467,  467,  467,
 /*  2840 */   408,  467,  467,  411,  412,  413,  414,  415,  416,  467,
 /*  2850 */   418,  467,  467,  467,  467,  467,  467,  467,  329,  467,
 /*  2860 */   467,  467,  467,  467,  467,  360,  467,  467,  467,  467,
 /*  2870 */   467,  467,  467,  368,  467,  467,  467,  467,  373,  467,
 /*  2880 */   375,  467,  467,  467,  467,  467,  467,  467,  467,  360,
 /*  2890 */   467,  467,  467,  467,  467,  467,  467,  368,  467,  467,
 /*  2900 */   467,  467,  373,  467,  375,  467,  467,  467,  467,  404,
 /*  2910 */   467,  467,  467,  408,  467,  329,  411,  412,  413,  414,
 /*  2920 */   415,  416,  467,  418,  467,  467,  467,  467,  467,  467,
 /*  2930 */   467,  467,  467,  404,  467,  329,  467,  408,  467,  467,
 /*  2940 */   411,  412,  413,  414,  415,  416,  360,  418,  467,  467,
 /*  2950 */   467,  467,  467,  467,  368,  467,  467,  467,  467,  373,
 /*  2960 */   467,  375,  467,  467,  467,  467,  360,  467,  467,  467,
 /*  2970 */   467,  467,  467,  467,  368,  467,  467,  467,  467,  373,
 /*  2980 */   467,  375,  467,  467,  467,  467,  467,  467,  467,  467,
 /*  2990 */   404,  467,  329,  467,  408,  467,  467,  411,  412,  413,
 /*  3000 */   414,  415,  416,  467,  418,  467,  467,  467,  467,  467,
 /*  3010 */   404,  467,  467,  467,  408,  467,  467,  411,  412,  413,
 /*  3020 */   414,  415,  416,  360,  418,  467,  467,  467,  467,  467,
 /*  3030 */   467,  368,  467,  467,  467,  467,  373,  467,  375,  467,
 /*  3040 */   467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
 /*  3050 */   467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
 /*  3060 */   467,  467,  467,  467,  467,  467,  467,  404,  467,  467,
 /*  3070 */   467,  408,  467,  467,  411,  412,  413,  414,  415,  416,
 /*  3080 */   467,  418,
};
#define YY_SHIFT_COUNT    (733)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2059)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   865,    0,   71,    0,  290,  290,  290,  290,  290,  290,
 /*    10 */   290,  290,  290,  290,  290,  361,  578,  578,  649,  578,
 /*    20 */   578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
 /*    30 */   578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
 /*    40 */   578,  578,  578,  578,  578,  578,  578,  578,  289,  405,
 /*    50 */   460,  216,   70,  241,  376,  241,  216,  216, 1383, 1383,
 /*    60 */   241, 1383, 1383,  426,  241,  110,  517,  286,  286,  517,
 /*    70 */   186,  186,  326,  172,    1,    1,  286,  286,  286,  286,
 /*    80 */   286,  286,  286,  380,  286,  286,  398,  110,  286,  286,
 /*    90 */   450,  286,  110,  286,  380,  286,  380,  110,  286,  286,
 /*   100 */   110,  286,  110,  110,  110,  286,  415,  795,   34,   34,
 /*   110 */   217,  826, 1067, 1067, 1067, 1067, 1067, 1067, 1067, 1067,
 /*   120 */  1067, 1067, 1067, 1067, 1067, 1067, 1067, 1067, 1067, 1067,
 /*   130 */  1067,  152,  672,  326,  172,  173,  422,  407,  407,  407,
 /*   140 */   393,  336,  336,  422,  518,  518,  518,  456,  507,  110,
 /*   150 */   713,  110,  713,  713,  645,  738,   36,   36,   36,   36,
 /*   160 */    36,   36,   36,   36,  583,  313,  474,  974,  249,  119,
 /*   170 */   413,  589,  335,  694,  299,  650,  862,  924,  685,  688,
 /*   180 */   446,  852,  688, 1081,  348,  615, 1068, 1259, 1139, 1280,
 /*   190 */  1304, 1280, 1170, 1310, 1310, 1280, 1170, 1170, 1254, 1310,
 /*   200 */  1310, 1310, 1336, 1336, 1339,  398, 1342,  398, 1348, 1356,
 /*   210 */   398, 1348,  398,  398,  398, 1310,  398, 1338, 1338, 1336,
 /*   220 */   110,  110,  110,  110,  110,  110,  110,  110,  110,  110,
 /*   230 */   110, 1310, 1336,  713,  713, 1213, 1309, 1339,  415, 1221,
 /*   240 */  1342,  415, 1310, 1304, 1304,  713, 1157, 1180,  713, 1157,
 /*   250 */  1180,  713,  713,  110, 1174, 1265, 1157, 1185, 1181, 1210,
 /*   260 */  1068, 1190, 1201, 1196, 1229,  518, 1458, 1310, 1348,  415,
 /*   270 */   415, 1484, 1180,  713,  713,  713,  713,  713, 1180,  713,
 /*   280 */  1349,  415,  645,  415,  518, 1426, 1428,  713,  738, 1310,
 /*   290 */   415, 1492, 1336, 3082, 3082, 3082, 3082, 3082, 3082, 3082,
 /*   300 */  3082, 3082,  890,  274,  702,  981,  453,  708,  905, 1002,
 /*   310 */   995, 1011, 1133, 1073, 1177, 1177, 1177, 1177, 1177, 1177,
 /*   320 */  1177, 1177, 1177,  260,  208,   86,   86,  528,  365,    4,
 /*   330 */  1024,  818,  592,  755,  755,  165,  608,  384,  165,  165,
 /*   340 */   165,  230, 1110,  690, 1131, 1008,  724, 1017, 1095, 1106,
 /*   350 */  1055, 1156, 1187, 1144, 1152, 1149, 1167, 1169, 1050,   99,
 /*   360 */   222, 1059, 1171, 1172, 1194, 1198, 1203, 1205, 1231, 1207,
 /*   370 */   982, 1058, 1047, 1168, 1178, 1209, 1212, 1214, 1215, 1216,
 /*   380 */  1217,  901, 1274, 1279, 1192, 1237, 1539, 1541, 1543, 1502,
 /*   390 */  1546, 1512, 1346, 1514, 1515, 1516, 1350, 1553, 1519, 1520,
 /*   400 */  1354, 1557, 1357, 1558, 1525, 1561, 1540, 1563, 1529, 1375,
 /*   410 */  1382, 1386, 1570, 1572, 1573, 1395, 1397, 1576, 1577, 1531,
 /*   420 */  1580, 1581, 1582, 1545, 1583, 1588, 1589, 1590, 1593, 1594,
 /*   430 */  1595, 1596, 1434, 1562, 1598, 1448, 1611, 1612, 1613, 1614,
 /*   440 */  1616, 1617, 1618, 1620, 1621, 1630, 1632, 1633, 1635, 1637,
 /*   450 */  1638, 1642, 1559, 1602, 1603, 1643, 1645, 1647, 1648, 1627,
 /*   460 */  1650, 1651, 1652, 1518, 1654, 1655, 1622, 1656, 1600, 1660,
 /*   470 */  1604, 1661, 1663, 1623, 1625, 1624, 1619, 1657, 1626, 1662,
 /*   480 */  1631, 1669, 1640, 1649, 1670, 1677, 1681, 1653, 1517, 1690,
 /*   490 */  1693, 1697, 1634, 1699, 1702, 1671, 1668, 1665, 1705, 1674,
 /*   500 */  1672, 1680, 1708, 1686, 1675, 1688, 1725, 1696, 1682, 1694,
 /*   510 */  1732, 1735, 1736, 1737, 1636, 1641, 1703, 1720, 1744, 1710,
 /*   520 */  1711, 1712, 1713, 1706, 1707, 1717, 1718, 1733, 1719, 1756,
 /*   530 */  1738, 1758, 1739, 1709, 1765, 1741, 1731, 1767, 1734, 1768,
 /*   540 */  1740, 1771, 1750, 1753, 1748, 1752, 1597, 1689, 1704, 1776,
 /*   550 */  1644, 1714, 1754, 1788, 1608, 1789, 1646, 1658, 1790, 1798,
 /*   560 */  1659, 1664, 1809, 1769, 1565, 1721, 1724, 1726, 1667, 1599,
 /*   570 */  1676, 1568, 1730, 1785, 1743, 1745, 1746, 1747, 1755, 1787,
 /*   580 */  1780, 1786, 1749, 1791, 1584, 1757, 1759, 1840, 1802, 1606,
 /*   590 */  1813, 1814, 1819, 1822, 1823, 1824, 1764, 1766, 1816, 1639,
 /*   600 */  1820, 1827, 1866, 1867, 1876, 1877, 1784, 1839, 1619, 1833,
 /*   610 */  1799, 1801, 1803, 1805, 1806, 1742, 1808, 1884, 1859, 1751,
 /*   620 */  1810, 1807, 1619, 1857, 1862, 1679, 1684, 1691, 1908, 1889,
 /*   630 */  1715, 1818, 1821, 1826, 1828, 1830, 1832, 1872, 1831, 1834,
 /*   640 */  1875, 1835, 1896, 1722, 1838, 1837, 1841, 1899, 1901, 1843,
 /*   650 */  1845, 1904, 1849, 1850, 1912, 1853, 1854, 1914, 1856, 1858,
 /*   660 */  1917, 1860, 1844, 1846, 1848, 1865, 1934, 1852, 1869, 1913,
 /*   670 */  1873, 1927, 1878, 1913, 1913, 1948, 1922, 1909, 1942, 1952,
 /*   680 */  1953, 1955, 1956, 1957, 1959, 1960, 1969, 1971, 1937, 1916,
 /*   690 */  1966, 1976, 1983, 1985, 1999, 1988, 1991, 1992, 1958, 1706,
 /*   700 */  1994, 1707, 1995, 1996, 1997, 2000, 2003, 2001, 2034, 2002,
 /*   710 */  2004, 2005, 2038, 2007, 2006, 2008, 2039, 2010, 2009, 2011,
 /*   720 */  2040, 2016, 2013, 2014, 2043, 2021, 2023, 2059, 2042, 2041,
 /*   730 */  2044, 2045, 2048, 2051,
};
#define YY_REDUCE_COUNT (301)
#define YY_REDUCE_MIN   (-432)
#define YY_REDUCE_MAX   (2663)
static const short yy_reduce_ofst[] = {
 /*     0 */   164,  683,  747,  806,  866,  925,  959, 1052, 1072, 1211,
 /*    10 */  1271, 1299, 1366, 1389, 1457, -293,   -3,   68, 1477,  285,
 /*    20 */  1567, 1585, 1601, 1673, 1695, 1763, 1783, 1851, 1871, 1928,
 /*    30 */  1962, 1990, 2050, 2071, 2144, 2168, 2225, 2245, 2302, 2323,
 /*    40 */  2351, 2411, 2432, 2505, 2529, 2586, 2606, 2663, -263, -349,
 /*    50 */   298,  341, -385, -255,  162,  624,  -17,  159, -354, -322,
 /*    60 */  -432, -339, -231, -400,  171,  -52, -359,   -4,  399, -331,
 /*    70 */  -333,   23, -343, -235,  100,  108,  183,  191,  199,  278,
 /*    80 */   306,  470,  479,  -23,  482,  543, -106, -176,  561,  647,
 /*    90 */   193,  654,  287,  681,  297,  684,  378, -279,  696,  699,
 /*   100 */   292,  711,  475,  382,  477,  737,   51, -311, -317, -317,
 /*   110 */  -214, -139, -328,  -11,   53,  122,  436,  451,  522,  524,
 /*   120 */   549,  550,  555,  622,  664,  717,  730,  731,  754,  763,
 /*   130 */   771, -294,  -41,   72, -178,  321,  179,  -41,   -7,  194,
 /*   140 */   447,  347,  463,  309,  154,  452,  537, -267,  255, -266,
 /*   150 */   557,  668,  770,  780,  701,  395, -355, -351,  498,  535,
 /*   160 */   631,  669,  677,  631,  687,  794,  790,  769,  692,  715,
 /*   170 */   859,  796,  868,  868,  906,  883,  933,  899,  889,  844,
 /*   180 */   844,  846,  844,  871,  873,  868,  911,  913,  927,  943,
 /*   190 */   942,  946,  950,  998, 1005,  964,  967,  968, 1004, 1014,
 /*   200 */  1015, 1016, 1026, 1027,  961, 1018,  989, 1023, 1031,  985,
 /*   210 */  1036, 1042, 1040, 1043, 1044, 1048, 1049, 1051, 1053, 1063,
 /*   220 */  1037, 1038, 1046, 1054, 1057, 1061, 1062, 1064, 1066, 1069,
 /*   230 */  1070, 1065, 1076, 1030, 1035,  997, 1010, 1020, 1074, 1025,
 /*   240 */  1056, 1087, 1096, 1060, 1071, 1075,  987, 1083, 1077,  990,
 /*   250 */  1084, 1078, 1079,  868,  988,  993,  999, 1009, 1012, 1029,
 /*   260 */  1085,  992, 1019, 1034,  844, 1121, 1086, 1161, 1165, 1153,
 /*   270 */  1158, 1119, 1118, 1134, 1135, 1136, 1137, 1138, 1125, 1141,
 /*   280 */  1132, 1175, 1162, 1179, 1151, 1094, 1160, 1154, 1176, 1188,
 /*   290 */  1189, 1197, 1200, 1140, 1142, 1143, 1145, 1182, 1183, 1184,
 /*   300 */  1191, 1218,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*    10 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*    20 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*    30 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*    40 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*    50 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*    60 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*    70 */  1647, 1647, 1904, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*    80 */  1647, 1647, 1647, 1647, 1647, 1647, 1725, 1647, 1647, 1647,
 /*    90 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   100 */  1647, 1647, 1647, 1647, 1647, 1647, 1723, 1897, 2111, 1647,
 /*   110 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   120 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   130 */  1647, 1647, 2123, 1647, 1647, 1725, 1647, 2123, 2123, 2123,
 /*   140 */  1723, 2083, 2083, 1647, 1647, 1647, 1647, 1958, 1647, 1647,
 /*   150 */  1647, 1647, 1647, 1647, 1832, 1647, 1647, 1647, 1647, 1647,
 /*   160 */  1856, 1647, 1647, 1647, 1950, 1647, 1647, 2148, 2202, 1647,
 /*   170 */  1647, 2151, 1647, 1647, 1647, 1909, 1647, 1785, 2138, 2115,
 /*   180 */  2129, 2186, 2116, 2113, 2132, 1647, 2142, 1647, 1943, 1902,
 /*   190 */  1647, 1902, 1899, 1647, 1647, 1902, 1899, 1899, 1776, 1647,
 /*   200 */  1647, 1647, 1647, 1647, 1647, 1725, 1647, 1725, 1647, 1647,
 /*   210 */  1725, 1647, 1725, 1725, 1725, 1647, 1725, 1704, 1704, 1647,
 /*   220 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   230 */  1647, 1647, 1647, 1647, 1647, 1968, 1956, 1647, 1723, 1952,
 /*   240 */  1647, 1723, 1647, 1647, 1647, 1647, 2159, 2157, 1647, 2159,
 /*   250 */  2157, 1647, 1647, 1647, 2171, 2167, 2159, 2175, 2173, 2144,
 /*   260 */  2142, 2205, 2192, 2188, 2129, 1647, 1647, 1647, 1647, 1723,
 /*   270 */  1723, 1647, 2157, 1647, 1647, 1647, 1647, 1647, 2157, 1647,
 /*   280 */  1647, 1723, 1647, 1723, 1647, 1647, 1801, 1647, 1647, 1647,
 /*   290 */  1723, 1679, 1647, 1945, 1961, 1927, 1927, 1835, 1835, 1835,
 /*   300 */  1726, 1652, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   310 */  1647, 1647, 1647, 1647, 2170, 2169, 2038, 1647, 2087, 2086,
 /*   320 */  2085, 2076, 2037, 1797, 1647, 2036, 2035, 1647, 1647, 1647,
 /*   330 */  1647, 1647, 1647, 1918, 1917, 2029, 1647, 1647, 2030, 2028,
 /*   340 */  2027, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   350 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 2189,
 /*   360 */  2193, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 2112, 1647,
 /*   370 */  1647, 1647, 1647, 1647, 2011, 1647, 1647, 1647, 1647, 1647,
 /*   380 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   390 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   400 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   410 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   420 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   430 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   440 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   450 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   460 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   470 */  1647, 1647, 1647, 1647, 1647, 1684, 2016, 1647, 1647, 1647,
 /*   480 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   490 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   500 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   510 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   520 */  1647, 1647, 1647, 1764, 1763, 1647, 1647, 1647, 1647, 1647,
 /*   530 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   540 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 2020, 1647, 1647,
 /*   550 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   560 */  1647, 1647, 2185, 2145, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   570 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   580 */  1647, 2011, 1647, 2168, 1647, 1647, 2183, 1647, 2187, 1647,
 /*   590 */  1647, 1647, 1647, 1647, 1647, 1647, 2122, 2118, 1647, 1647,
 /*   600 */  2114, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 2019, 1647,
 /*   610 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   620 */  1647, 1647, 2010, 1647, 2073, 1647, 1647, 1647, 2107, 1647,
 /*   630 */  1647, 2058, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   640 */  1647, 2020, 1647, 2023, 1647, 1647, 1647, 1647, 1647, 1829,
 /*   650 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   660 */  1647, 1647, 1814, 1812, 1811, 1810, 1647, 1807, 1647, 1842,
 /*   670 */  1647, 1647, 1647, 1838, 1837, 1647, 1647, 1647, 1647, 1647,
 /*   680 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   690 */  1744, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1736,
 /*   700 */  1647, 1735, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   710 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   720 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   730 */  1647, 1647, 1647, 1647,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
  272,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*      START => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  272,  /*      AFTER => ABORT */
  272,  /*     ATTACH => ABORT */
  272,  /*     BEFORE => ABORT */
  272,  /*      BEGIN => ABORT */
  272,  /*     BITAND => ABORT */
  272,  /*     BITNOT => ABORT */
  272,  /*      BITOR => ABORT */
  272,  /*     BLOCKS => ABORT */
  272,  /*     CHANGE => ABORT */
  272,  /*      COMMA => ABORT */
  272,  /*    COMPACT => ABORT */
  272,  /*     CONCAT => ABORT */
  272,  /*   CONFLICT => ABORT */
  272,  /*       COPY => ABORT */
  272,  /*   DEFERRED => ABORT */
  272,  /* DELIMITERS => ABORT */
  272,  /*     DETACH => ABORT */
  272,  /*     DIVIDE => ABORT */
  272,  /*        DOT => ABORT */
  272,  /*       EACH => ABORT */
  272,  /*       FAIL => ABORT */
  272,  /*       FILE => ABORT */
  272,  /*        FOR => ABORT */
  272,  /*       GLOB => ABORT */
  272,  /*         ID => ABORT */
  272,  /*  IMMEDIATE => ABORT */
  272,  /*     IMPORT => ABORT */
  272,  /*  INITIALLY => ABORT */
  272,  /*    INSTEAD => ABORT */
  272,  /*     ISNULL => ABORT */
  272,  /*        KEY => ABORT */
  272,  /*    MODULES => ABORT */
  272,  /*  NK_BITNOT => ABORT */
  272,  /*    NK_SEMI => ABORT */
  272,  /*    NOTNULL => ABORT */
  272,  /*         OF => ABORT */
  272,  /*       PLUS => ABORT */
  272,  /*  PRIVILEGE => ABORT */
  272,  /*      RAISE => ABORT */
  272,  /*    REPLACE => ABORT */
  272,  /*   RESTRICT => ABORT */
  272,  /*        ROW => ABORT */
  272,  /*       SEMI => ABORT */
  272,  /*       STAR => ABORT */
  272,  /*  STATEMENT => ABORT */
  272,  /*     STRICT => ABORT */
  272,  /*     STRING => ABORT */
  272,  /*      TIMES => ABORT */
  272,  /*     UPDATE => ABORT */
  272,  /*     VALUES => ABORT */
  272,  /*   VARIABLE => ABORT */
  272,  /*       VIEW => ABORT */
  272,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "IF",
  /*   63 */ "NOT",
  /*   64 */ "EXISTS",
  /*   65 */ "BUFFER",
  /*   66 */ "CACHEMODEL",
  /*   67 */ "CACHESIZE",
  /*   68 */ "COMP",
  /*   69 */ "DURATION",
  /*   70 */ "NK_VARIABLE",
  /*   71 */ "MAXROWS",
  /*   72 */ "MINROWS",
  /*   73 */ "KEEP",
  /*   74 */ "PAGES",
  /*   75 */ "PAGESIZE",
  /*   76 */ "TSDB_PAGESIZE",
  /*   77 */ "PRECISION",
  /*   78 */ "REPLICA",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "WAL_LEVEL",
  /*   84 */ "WAL_FSYNC_PERIOD",
  /*   85 */ "WAL_RETENTION_PERIOD",
  /*   86 */ "WAL_RETENTION_SIZE",
  /*   87 */ "WAL_ROLL_PERIOD",
  /*   88 */ "WAL_SEGMENT_SIZE",
  /*   89 */ "STT_TRIGGER",
  /*   90 */ "TABLE_PREFIX",
  /*   91 */ "TABLE_SUFFIX",
  /*   92 */ "NK_COLON",
  /*   93 */ "MAX_SPEED",
  /*   94 */ "TABLE",
  /*   95 */ "NK_LP",
  /*   96 */ "NK_RP",
  /*   97 */ "STABLE",
  /*   98 */ "ADD",
  /*   99 */ "COLUMN",
  /*  100 */ "MODIFY",
  /*  101 */ "RENAME",
  /*  102 */ "TAG",
  /*  103 */ "SET",
  /*  104 */ "NK_EQ",
  /*  105 */ "USING",
  /*  106 */ "TAGS",
  /*  107 */ "COMMENT",
  /*  108 */ "BOOL",
  /*  109 */ "TINYINT",
  /*  110 */ "SMALLINT",
  /*  111 */ "INT",
  /*  112 */ "INTEGER",
  /*  113 */ "BIGINT",
  /*  114 */ "FLOAT",
  /*  115 */ "DOUBLE",
  /*  116 */ "BINARY",
  /*  117 */ "TIMESTAMP",
  /*  118 */ "NCHAR",
  /*  119 */ "UNSIGNED",
  /*  120 */ "JSON",
  /*  121 */ "VARCHAR",
  /*  122 */ "MEDIUMBLOB",
  /*  123 */ "BLOB",
  /*  124 */ "VARBINARY",
  /*  125 */ "DECIMAL",
  /*  126 */ "MAX_DELAY",
  /*  127 */ "WATERMARK",
  /*  128 */ "ROLLUP",
  /*  129 */ "TTL",
  /*  130 */ "SMA",
  /*  131 */ "DELETE_MARK",
  /*  132 */ "FIRST",
  /*  133 */ "LAST",
  /*  134 */ "SHOW",
  /*  135 */ "PRIVILEGES",
  /*  136 */ "DATABASES",
  /*  137 */ "TABLES",
  /*  138 */ "STABLES",
  /*  139 */ "MNODES",
  /*  140 */ "QNODES",
  /*  141 */ "FUNCTIONS",
  /*  142 */ "INDEXES",
  /*  143 */ "ACCOUNTS",
  /*  144 */ "APPS",
  /*  145 */ "CONNECTIONS",
  /*  146 */ "LICENCES",
  /*  147 */ "GRANTS",
  /*  148 */ "QUERIES",
  /*  149 */ "SCORES",
  /*  150 */ "TOPICS",
  /*  151 */ "VARIABLES",
  /*  152 */ "CLUSTER",
  /*  153 */ "BNODES",
  /*  154 */ "SNODES",
  /*  155 */ "TRANSACTIONS",
  /*  156 */ "DISTRIBUTED",
  /*  157 */ "CONSUMERS",
  /*  158 */ "SUBSCRIPTIONS",
  /*  159 */ "VNODES",
  /*  160 */ "ALIVE",
  /*  161 */ "LIKE",
  /*  162 */ "TBNAME",
  /*  163 */ "QTAGS",
  /*  164 */ "AS",
  /*  165 */ "INDEX",
  /*  166 */ "FUNCTION",
  /*  167 */ "INTERVAL",
  /*  168 */ "COUNT",
  /*  169 */ "LAST_ROW",
  /*  170 */ "TOPIC",
  /*  171 */ "WITH",
  /*  172 */ "META",
  /*  173 */ "CONSUMER",
  /*  174 */ "GROUP",
  /*  175 */ "DESC",
  /*  176 */ "DESCRIBE",
  /*  177 */ "RESET",
  /*  178 */ "QUERY",
  /*  179 */ "CACHE",
  /*  180 */ "EXPLAIN",
  /*  181 */ "ANALYZE",
  /*  182 */ "VERBOSE",
  /*  183 */ "NK_BOOL",
  /*  184 */ "RATIO",
  /*  185 */ "NK_FLOAT",
  /*  186 */ "OUTPUTTYPE",
  /*  187 */ "AGGREGATE",
  /*  188 */ "BUFSIZE",
  /*  189 */ "STREAM",
  /*  190 */ "INTO",
  /*  191 */ "TRIGGER",
  /*  192 */ "AT_ONCE",
  /*  193 */ "WINDOW_CLOSE",
  /*  194 */ "IGNORE",
  /*  195 */ "EXPIRED",
  /*  196 */ "FILL_HISTORY",
  /*  197 */ "SUBTABLE",
  /*  198 */ "KILL",
  /*  199 */ "CONNECTION",
  /*  200 */ "TRANSACTION",
  /*  201 */ "BALANCE",
  /*  202 */ "VGROUP",
  /*  203 */ "MERGE",
  /*  204 */ "REDISTRIBUTE",
  /*  205 */ "SPLIT",
  /*  206 */ "DELETE",
  /*  207 */ "INSERT",
  /*  208 */ "NULL",
  /*  209 */ "NK_QUESTION",
  /*  210 */ "NK_ARROW",
  /*  211 */ "ROWTS",
  /*  212 */ "QSTART",
  /*  213 */ "QEND",
  /*  214 */ "QDURATION",
  /*  215 */ "WSTART",
  /*  216 */ "WEND",
  /*  217 */ "WDURATION",
  /*  218 */ "IROWTS",
  /*  219 */ "ISFILLED",
  /*  220 */ "CAST",
  /*  221 */ "NOW",
  /*  222 */ "TODAY",
  /*  223 */ "TIMEZONE",
  /*  224 */ "CLIENT_VERSION",
  /*  225 */ "SERVER_VERSION",
  /*  226 */ "SERVER_STATUS",
  /*  227 */ "CURRENT_USER",
  /*  228 */ "CASE",
  /*  229 */ "END",
  /*  230 */ "WHEN",
  /*  231 */ "THEN",
  /*  232 */ "ELSE",
  /*  233 */ "BETWEEN",
  /*  234 */ "IS",
  /*  235 */ "NK_LT",
  /*  236 */ "NK_GT",
  /*  237 */ "NK_LE",
  /*  238 */ "NK_GE",
  /*  239 */ "NK_NE",
  /*  240 */ "MATCH",
  /*  241 */ "NMATCH",
  /*  242 */ "CONTAINS",
  /*  243 */ "IN",
  /*  244 */ "JOIN",
  /*  245 */ "INNER",
  /*  246 */ "SELECT",
  /*  247 */ "DISTINCT",
  /*  248 */ "WHERE",
  /*  249 */ "PARTITION",
  /*  250 */ "BY",
  /*  251 */ "SESSION",
  /*  252 */ "STATE_WINDOW",
  /*  253 */ "EVENT_WINDOW",
  /*  254 */ "START",
  /*  255 */ "SLIDING",
  /*  256 */ "FILL",
  /*  257 */ "VALUE",
  /*  258 */ "NONE",
  /*  259 */ "PREV",
  /*  260 */ "LINEAR",
  /*  261 */ "NEXT",
  /*  262 */ "HAVING",
  /*  263 */ "RANGE",
  /*  264 */ "EVERY",
  /*  265 */ "ORDER",
  /*  266 */ "SLIMIT",
  /*  267 */ "SOFFSET",
  /*  268 */ "LIMIT",
  /*  269 */ "OFFSET",
  /*  270 */ "ASC",
  /*  271 */ "NULLS",
  /*  272 */ "ABORT",
  /*  273 */ "AFTER",
  /*  274 */ "ATTACH",
  /*  275 */ "BEFORE",
  /*  276 */ "BEGIN",
  /*  277 */ "BITAND",
  /*  278 */ "BITNOT",
  /*  279 */ "BITOR",
  /*  280 */ "BLOCKS",
  /*  281 */ "CHANGE",
  /*  282 */ "COMMA",
  /*  283 */ "COMPACT",
  /*  284 */ "CONCAT",
  /*  285 */ "CONFLICT",
  /*  286 */ "COPY",
  /*  287 */ "DEFERRED",
  /*  288 */ "DELIMITERS",
  /*  289 */ "DETACH",
  /*  290 */ "DIVIDE",
  /*  291 */ "DOT",
  /*  292 */ "EACH",
  /*  293 */ "FAIL",
  /*  294 */ "FILE",
  /*  295 */ "FOR",
  /*  296 */ "GLOB",
  /*  297 */ "ID",
  /*  298 */ "IMMEDIATE",
  /*  299 */ "IMPORT",
  /*  300 */ "INITIALLY",
  /*  301 */ "INSTEAD",
  /*  302 */ "ISNULL",
  /*  303 */ "KEY",
  /*  304 */ "MODULES",
  /*  305 */ "NK_BITNOT",
  /*  306 */ "NK_SEMI",
  /*  307 */ "NOTNULL",
  /*  308 */ "OF",
  /*  309 */ "PLUS",
  /*  310 */ "PRIVILEGE",
  /*  311 */ "RAISE",
  /*  312 */ "REPLACE",
  /*  313 */ "RESTRICT",
  /*  314 */ "ROW",
  /*  315 */ "SEMI",
  /*  316 */ "STAR",
  /*  317 */ "STATEMENT",
  /*  318 */ "STRICT",
  /*  319 */ "STRING",
  /*  320 */ "TIMES",
  /*  321 */ "UPDATE",
  /*  322 */ "VALUES",
  /*  323 */ "VARIABLE",
  /*  324 */ "VIEW",
  /*  325 */ "WAL",
  /*  326 */ "cmd",
  /*  327 */ "account_options",
  /*  328 */ "alter_account_options",
  /*  329 */ "literal",
  /*  330 */ "alter_account_option",
  /*  331 */ "user_name",
  /*  332 */ "sysinfo_opt",
  /*  333 */ "privileges",
  /*  334 */ "priv_level",
  /*  335 */ "priv_type_list",
  /*  336 */ "priv_type",
  /*  337 */ "db_name",
  /*  338 */ "topic_name",
  /*  339 */ "dnode_endpoint",
  /*  340 */ "force_opt",
  /*  341 */ "not_exists_opt",
  /*  342 */ "db_options",
  /*  343 */ "exists_opt",
  /*  344 */ "alter_db_options",
  /*  345 */ "speed_opt",
  /*  346 */ "integer_list",
  /*  347 */ "variable_list",
  /*  348 */ "retention_list",
  /*  349 */ "alter_db_option",
  /*  350 */ "retention",
  /*  351 */ "full_table_name",
  /*  352 */ "column_def_list",
  /*  353 */ "tags_def_opt",
  /*  354 */ "table_options",
  /*  355 */ "multi_create_clause",
  /*  356 */ "tags_def",
  /*  357 */ "multi_drop_clause",
  /*  358 */ "alter_table_clause",
  /*  359 */ "alter_table_options",
  /*  360 */ "column_name",
  /*  361 */ "type_name",
  /*  362 */ "signed_literal",
  /*  363 */ "create_subtable_clause",
  /*  364 */ "specific_cols_opt",
  /*  365 */ "expression_list",
  /*  366 */ "drop_table_clause",
  /*  367 */ "col_name_list",
  /*  368 */ "table_name",
  /*  369 */ "column_def",
  /*  370 */ "duration_list",
  /*  371 */ "rollup_func_list",
  /*  372 */ "alter_table_option",
  /*  373 */ "duration_literal",
  /*  374 */ "rollup_func_name",
  /*  375 */ "function_name",
  /*  376 */ "col_name",
  /*  377 */ "db_name_cond_opt",
  /*  378 */ "like_pattern_opt",
  /*  379 */ "table_name_cond",
  /*  380 */ "from_db_opt",
  /*  381 */ "tag_list_opt",
  /*  382 */ "tag_item",
  /*  383 */ "column_alias",
  /*  384 */ "full_index_name",
  /*  385 */ "index_options",
  /*  386 */ "index_name",
  /*  387 */ "func_list",
  /*  388 */ "sliding_opt",
  /*  389 */ "sma_stream_opt",
  /*  390 */ "func",
  /*  391 */ "sma_func_name",
  /*  392 */ "query_or_subquery",
  /*  393 */ "cgroup_name",
  /*  394 */ "analyze_opt",
  /*  395 */ "explain_options",
  /*  396 */ "insert_query",
  /*  397 */ "agg_func_opt",
  /*  398 */ "bufsize_opt",
  /*  399 */ "stream_name",
  /*  400 */ "stream_options",
  /*  401 */ "col_list_opt",
  /*  402 */ "tag_def_or_ref_opt",
  /*  403 */ "subtable_opt",
  /*  404 */ "expression",
  /*  405 */ "dnode_list",
  /*  406 */ "where_clause_opt",
  /*  407 */ "signed",
  /*  408 */ "literal_func",
  /*  409 */ "literal_list",
  /*  410 */ "table_alias",
  /*  411 */ "expr_or_subquery",
  /*  412 */ "pseudo_column",
  /*  413 */ "column_reference",
  /*  414 */ "function_expression",
  /*  415 */ "case_when_expression",
  /*  416 */ "star_func",
  /*  417 */ "star_func_para_list",
  /*  418 */ "noarg_func",
  /*  419 */ "other_para_list",
  /*  420 */ "star_func_para",
  /*  421 */ "when_then_list",
  /*  422 */ "case_when_else_opt",
  /*  423 */ "common_expression",
  /*  424 */ "when_then_expr",
  /*  425 */ "predicate",
  /*  426 */ "compare_op",
  /*  427 */ "in_op",
  /*  428 */ "in_predicate_value",
  /*  429 */ "boolean_value_expression",
  /*  430 */ "boolean_primary",
  /*  431 */ "from_clause_opt",
  /*  432 */ "table_reference_list",
  /*  433 */ "table_reference",
  /*  434 */ "table_primary",
  /*  435 */ "joined_table",
  /*  436 */ "alias_opt",
  /*  437 */ "subquery",
  /*  438 */ "parenthesized_joined_table",
  /*  439 */ "join_type",
  /*  440 */ "search_condition",
  /*  441 */ "query_specification",
  /*  442 */ "set_quantifier_opt",
  /*  443 */ "select_list",
  /*  444 */ "partition_by_clause_opt",
  /*  445 */ "range_opt",
  /*  446 */ "every_opt",
  /*  447 */ "fill_opt",
  /*  448 */ "twindow_clause_opt",
  /*  449 */ "group_by_clause_opt",
  /*  450 */ "having_clause_opt",
  /*  451 */ "select_item",
  /*  452 */ "partition_list",
  /*  453 */ "partition_item",
  /*  454 */ "fill_mode",
  /*  455 */ "group_by_list",
  /*  456 */ "query_expression",
  /*  457 */ "query_simple",
  /*  458 */ "order_by_clause_opt",
  /*  459 */ "slimit_clause_opt",
  /*  460 */ "limit_clause_opt",
  /*  461 */ "union_query_expression",
  /*  462 */ "query_simple_or_subquery",
  /*  463 */ "sort_specification_list",
  /*  464 */ "sort_specification",
  /*  465 */ "ordering_specification_opt",
  /*  466 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  73 */ "not_exists_opt ::=",
 /*  74 */ "exists_opt ::= IF EXISTS",
 /*  75 */ "exists_opt ::=",
 /*  76 */ "db_options ::=",
 /*  77 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  78 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  79 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  81 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  83 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  84 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options KEEP integer_list",
 /*  86 */ "db_options ::= db_options KEEP variable_list",
 /*  87 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  88 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  89 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  91 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  92 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  93 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  94 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  95 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 104 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 105 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 107 */ "alter_db_options ::= alter_db_option",
 /* 108 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 109 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 110 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 111 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 112 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 113 */ "alter_db_option ::= KEEP integer_list",
 /* 114 */ "alter_db_option ::= KEEP variable_list",
 /* 115 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 116 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 117 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 118 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 119 */ "integer_list ::= NK_INTEGER",
 /* 120 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 121 */ "variable_list ::= NK_VARIABLE",
 /* 122 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 123 */ "retention_list ::= retention",
 /* 124 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 125 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 126 */ "speed_opt ::=",
 /* 127 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 128 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 129 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 130 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 131 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 132 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 133 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 134 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 135 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 136 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 142 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 144 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 145 */ "multi_create_clause ::= create_subtable_clause",
 /* 146 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 147 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 148 */ "multi_drop_clause ::= drop_table_clause",
 /* 149 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 150 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 151 */ "specific_cols_opt ::=",
 /* 152 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 153 */ "full_table_name ::= table_name",
 /* 154 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 155 */ "column_def_list ::= column_def",
 /* 156 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 157 */ "column_def ::= column_name type_name",
 /* 158 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 159 */ "type_name ::= BOOL",
 /* 160 */ "type_name ::= TINYINT",
 /* 161 */ "type_name ::= SMALLINT",
 /* 162 */ "type_name ::= INT",
 /* 163 */ "type_name ::= INTEGER",
 /* 164 */ "type_name ::= BIGINT",
 /* 165 */ "type_name ::= FLOAT",
 /* 166 */ "type_name ::= DOUBLE",
 /* 167 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TIMESTAMP",
 /* 169 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TINYINT UNSIGNED",
 /* 171 */ "type_name ::= SMALLINT UNSIGNED",
 /* 172 */ "type_name ::= INT UNSIGNED",
 /* 173 */ "type_name ::= BIGINT UNSIGNED",
 /* 174 */ "type_name ::= JSON",
 /* 175 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 176 */ "type_name ::= MEDIUMBLOB",
 /* 177 */ "type_name ::= BLOB",
 /* 178 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL",
 /* 180 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 182 */ "tags_def_opt ::=",
 /* 183 */ "tags_def_opt ::= tags_def",
 /* 184 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 185 */ "table_options ::=",
 /* 186 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 187 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 188 */ "table_options ::= table_options WATERMARK duration_list",
 /* 189 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 190 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 191 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 192 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 193 */ "alter_table_options ::= alter_table_option",
 /* 194 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 195 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 196 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 197 */ "duration_list ::= duration_literal",
 /* 198 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 199 */ "rollup_func_list ::= rollup_func_name",
 /* 200 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 201 */ "rollup_func_name ::= function_name",
 /* 202 */ "rollup_func_name ::= FIRST",
 /* 203 */ "rollup_func_name ::= LAST",
 /* 204 */ "col_name_list ::= col_name",
 /* 205 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 206 */ "col_name ::= column_name",
 /* 207 */ "cmd ::= SHOW DNODES",
 /* 208 */ "cmd ::= SHOW USERS",
 /* 209 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 210 */ "cmd ::= SHOW DATABASES",
 /* 211 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 214 */ "cmd ::= SHOW MNODES",
 /* 215 */ "cmd ::= SHOW QNODES",
 /* 216 */ "cmd ::= SHOW FUNCTIONS",
 /* 217 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 218 */ "cmd ::= SHOW STREAMS",
 /* 219 */ "cmd ::= SHOW ACCOUNTS",
 /* 220 */ "cmd ::= SHOW APPS",
 /* 221 */ "cmd ::= SHOW CONNECTIONS",
 /* 222 */ "cmd ::= SHOW LICENCES",
 /* 223 */ "cmd ::= SHOW GRANTS",
 /* 224 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 225 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 226 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 227 */ "cmd ::= SHOW QUERIES",
 /* 228 */ "cmd ::= SHOW SCORES",
 /* 229 */ "cmd ::= SHOW TOPICS",
 /* 230 */ "cmd ::= SHOW VARIABLES",
 /* 231 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 232 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 233 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 234 */ "cmd ::= SHOW BNODES",
 /* 235 */ "cmd ::= SHOW SNODES",
 /* 236 */ "cmd ::= SHOW CLUSTER",
 /* 237 */ "cmd ::= SHOW TRANSACTIONS",
 /* 238 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 239 */ "cmd ::= SHOW CONSUMERS",
 /* 240 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 241 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 242 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 244 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 245 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 246 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 247 */ "db_name_cond_opt ::=",
 /* 248 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 249 */ "like_pattern_opt ::=",
 /* 250 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 251 */ "table_name_cond ::= table_name",
 /* 252 */ "from_db_opt ::=",
 /* 253 */ "from_db_opt ::= FROM db_name",
 /* 254 */ "tag_list_opt ::=",
 /* 255 */ "tag_list_opt ::= tag_item",
 /* 256 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 257 */ "tag_item ::= TBNAME",
 /* 258 */ "tag_item ::= QTAGS",
 /* 259 */ "tag_item ::= column_name",
 /* 260 */ "tag_item ::= column_name column_alias",
 /* 261 */ "tag_item ::= column_name AS column_alias",
 /* 262 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 263 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 264 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 265 */ "full_index_name ::= index_name",
 /* 266 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 267 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 268 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 269 */ "func_list ::= func",
 /* 270 */ "func_list ::= func_list NK_COMMA func",
 /* 271 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 272 */ "sma_func_name ::= function_name",
 /* 273 */ "sma_func_name ::= COUNT",
 /* 274 */ "sma_func_name ::= FIRST",
 /* 275 */ "sma_func_name ::= LAST",
 /* 276 */ "sma_func_name ::= LAST_ROW",
 /* 277 */ "sma_stream_opt ::=",
 /* 278 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 279 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 280 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 281 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 282 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 283 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 284 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 285 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 286 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 287 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 288 */ "cmd ::= DESC full_table_name",
 /* 289 */ "cmd ::= DESCRIBE full_table_name",
 /* 290 */ "cmd ::= RESET QUERY CACHE",
 /* 291 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 292 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 293 */ "analyze_opt ::=",
 /* 294 */ "analyze_opt ::= ANALYZE",
 /* 295 */ "explain_options ::=",
 /* 296 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 297 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 298 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 299 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 300 */ "agg_func_opt ::=",
 /* 301 */ "agg_func_opt ::= AGGREGATE",
 /* 302 */ "bufsize_opt ::=",
 /* 303 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 304 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 305 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 306 */ "col_list_opt ::=",
 /* 307 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 308 */ "tag_def_or_ref_opt ::=",
 /* 309 */ "tag_def_or_ref_opt ::= tags_def",
 /* 310 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 311 */ "stream_options ::=",
 /* 312 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 313 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 314 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 315 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 316 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 317 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 318 */ "subtable_opt ::=",
 /* 319 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 320 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 321 */ "cmd ::= KILL QUERY NK_STRING",
 /* 322 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 323 */ "cmd ::= BALANCE VGROUP",
 /* 324 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 325 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 326 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 327 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 328 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 329 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 330 */ "cmd ::= query_or_subquery",
 /* 331 */ "cmd ::= insert_query",
 /* 332 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 333 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 334 */ "literal ::= NK_INTEGER",
 /* 335 */ "literal ::= NK_FLOAT",
 /* 336 */ "literal ::= NK_STRING",
 /* 337 */ "literal ::= NK_BOOL",
 /* 338 */ "literal ::= TIMESTAMP NK_STRING",
 /* 339 */ "literal ::= duration_literal",
 /* 340 */ "literal ::= NULL",
 /* 341 */ "literal ::= NK_QUESTION",
 /* 342 */ "duration_literal ::= NK_VARIABLE",
 /* 343 */ "signed ::= NK_INTEGER",
 /* 344 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 345 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 346 */ "signed ::= NK_FLOAT",
 /* 347 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 348 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 349 */ "signed_literal ::= signed",
 /* 350 */ "signed_literal ::= NK_STRING",
 /* 351 */ "signed_literal ::= NK_BOOL",
 /* 352 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 353 */ "signed_literal ::= duration_literal",
 /* 354 */ "signed_literal ::= NULL",
 /* 355 */ "signed_literal ::= literal_func",
 /* 356 */ "signed_literal ::= NK_QUESTION",
 /* 357 */ "literal_list ::= signed_literal",
 /* 358 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 359 */ "db_name ::= NK_ID",
 /* 360 */ "table_name ::= NK_ID",
 /* 361 */ "column_name ::= NK_ID",
 /* 362 */ "function_name ::= NK_ID",
 /* 363 */ "table_alias ::= NK_ID",
 /* 364 */ "column_alias ::= NK_ID",
 /* 365 */ "user_name ::= NK_ID",
 /* 366 */ "topic_name ::= NK_ID",
 /* 367 */ "stream_name ::= NK_ID",
 /* 368 */ "cgroup_name ::= NK_ID",
 /* 369 */ "index_name ::= NK_ID",
 /* 370 */ "expr_or_subquery ::= expression",
 /* 371 */ "expression ::= literal",
 /* 372 */ "expression ::= pseudo_column",
 /* 373 */ "expression ::= column_reference",
 /* 374 */ "expression ::= function_expression",
 /* 375 */ "expression ::= case_when_expression",
 /* 376 */ "expression ::= NK_LP expression NK_RP",
 /* 377 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 378 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 379 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 380 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 381 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 382 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 383 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 384 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 385 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 386 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 387 */ "expression_list ::= expr_or_subquery",
 /* 388 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 389 */ "column_reference ::= column_name",
 /* 390 */ "column_reference ::= table_name NK_DOT column_name",
 /* 391 */ "pseudo_column ::= ROWTS",
 /* 392 */ "pseudo_column ::= TBNAME",
 /* 393 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 394 */ "pseudo_column ::= QSTART",
 /* 395 */ "pseudo_column ::= QEND",
 /* 396 */ "pseudo_column ::= QDURATION",
 /* 397 */ "pseudo_column ::= WSTART",
 /* 398 */ "pseudo_column ::= WEND",
 /* 399 */ "pseudo_column ::= WDURATION",
 /* 400 */ "pseudo_column ::= IROWTS",
 /* 401 */ "pseudo_column ::= ISFILLED",
 /* 402 */ "pseudo_column ::= QTAGS",
 /* 403 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 404 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 405 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 406 */ "function_expression ::= literal_func",
 /* 407 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 408 */ "literal_func ::= NOW",
 /* 409 */ "noarg_func ::= NOW",
 /* 410 */ "noarg_func ::= TODAY",
 /* 411 */ "noarg_func ::= TIMEZONE",
 /* 412 */ "noarg_func ::= DATABASE",
 /* 413 */ "noarg_func ::= CLIENT_VERSION",
 /* 414 */ "noarg_func ::= SERVER_VERSION",
 /* 415 */ "noarg_func ::= SERVER_STATUS",
 /* 416 */ "noarg_func ::= CURRENT_USER",
 /* 417 */ "noarg_func ::= USER",
 /* 418 */ "star_func ::= COUNT",
 /* 419 */ "star_func ::= FIRST",
 /* 420 */ "star_func ::= LAST",
 /* 421 */ "star_func ::= LAST_ROW",
 /* 422 */ "star_func_para_list ::= NK_STAR",
 /* 423 */ "star_func_para_list ::= other_para_list",
 /* 424 */ "other_para_list ::= star_func_para",
 /* 425 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 426 */ "star_func_para ::= expr_or_subquery",
 /* 427 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 428 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 429 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 430 */ "when_then_list ::= when_then_expr",
 /* 431 */ "when_then_list ::= when_then_list when_then_expr",
 /* 432 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 433 */ "case_when_else_opt ::=",
 /* 434 */ "case_when_else_opt ::= ELSE common_expression",
 /* 435 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 436 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 437 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 438 */ "predicate ::= expr_or_subquery IS NULL",
 /* 439 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 440 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 441 */ "compare_op ::= NK_LT",
 /* 442 */ "compare_op ::= NK_GT",
 /* 443 */ "compare_op ::= NK_LE",
 /* 444 */ "compare_op ::= NK_GE",
 /* 445 */ "compare_op ::= NK_NE",
 /* 446 */ "compare_op ::= NK_EQ",
 /* 447 */ "compare_op ::= LIKE",
 /* 448 */ "compare_op ::= NOT LIKE",
 /* 449 */ "compare_op ::= MATCH",
 /* 450 */ "compare_op ::= NMATCH",
 /* 451 */ "compare_op ::= CONTAINS",
 /* 452 */ "in_op ::= IN",
 /* 453 */ "in_op ::= NOT IN",
 /* 454 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 455 */ "boolean_value_expression ::= boolean_primary",
 /* 456 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 457 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 458 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 459 */ "boolean_primary ::= predicate",
 /* 460 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 461 */ "common_expression ::= expr_or_subquery",
 /* 462 */ "common_expression ::= boolean_value_expression",
 /* 463 */ "from_clause_opt ::=",
 /* 464 */ "from_clause_opt ::= FROM table_reference_list",
 /* 465 */ "table_reference_list ::= table_reference",
 /* 466 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 467 */ "table_reference ::= table_primary",
 /* 468 */ "table_reference ::= joined_table",
 /* 469 */ "table_primary ::= table_name alias_opt",
 /* 470 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 471 */ "table_primary ::= subquery alias_opt",
 /* 472 */ "table_primary ::= parenthesized_joined_table",
 /* 473 */ "alias_opt ::=",
 /* 474 */ "alias_opt ::= table_alias",
 /* 475 */ "alias_opt ::= AS table_alias",
 /* 476 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 477 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 478 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 479 */ "join_type ::=",
 /* 480 */ "join_type ::= INNER",
 /* 481 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 482 */ "set_quantifier_opt ::=",
 /* 483 */ "set_quantifier_opt ::= DISTINCT",
 /* 484 */ "set_quantifier_opt ::= ALL",
 /* 485 */ "select_list ::= select_item",
 /* 486 */ "select_list ::= select_list NK_COMMA select_item",
 /* 487 */ "select_item ::= NK_STAR",
 /* 488 */ "select_item ::= common_expression",
 /* 489 */ "select_item ::= common_expression column_alias",
 /* 490 */ "select_item ::= common_expression AS column_alias",
 /* 491 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 492 */ "where_clause_opt ::=",
 /* 493 */ "where_clause_opt ::= WHERE search_condition",
 /* 494 */ "partition_by_clause_opt ::=",
 /* 495 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 496 */ "partition_list ::= partition_item",
 /* 497 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 498 */ "partition_item ::= expr_or_subquery",
 /* 499 */ "partition_item ::= expr_or_subquery column_alias",
 /* 500 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 501 */ "twindow_clause_opt ::=",
 /* 502 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 503 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 504 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 505 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 506 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 507 */ "sliding_opt ::=",
 /* 508 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 509 */ "fill_opt ::=",
 /* 510 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 511 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 512 */ "fill_mode ::= NONE",
 /* 513 */ "fill_mode ::= PREV",
 /* 514 */ "fill_mode ::= NULL",
 /* 515 */ "fill_mode ::= LINEAR",
 /* 516 */ "fill_mode ::= NEXT",
 /* 517 */ "group_by_clause_opt ::=",
 /* 518 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 519 */ "group_by_list ::= expr_or_subquery",
 /* 520 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 521 */ "having_clause_opt ::=",
 /* 522 */ "having_clause_opt ::= HAVING search_condition",
 /* 523 */ "range_opt ::=",
 /* 524 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 525 */ "every_opt ::=",
 /* 526 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 527 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 528 */ "query_simple ::= query_specification",
 /* 529 */ "query_simple ::= union_query_expression",
 /* 530 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 531 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 532 */ "query_simple_or_subquery ::= query_simple",
 /* 533 */ "query_simple_or_subquery ::= subquery",
 /* 534 */ "query_or_subquery ::= query_expression",
 /* 535 */ "query_or_subquery ::= subquery",
 /* 536 */ "order_by_clause_opt ::=",
 /* 537 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 538 */ "slimit_clause_opt ::=",
 /* 539 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 540 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 541 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 542 */ "limit_clause_opt ::=",
 /* 543 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 544 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 545 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 546 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 547 */ "subquery ::= NK_LP subquery NK_RP",
 /* 548 */ "search_condition ::= common_expression",
 /* 549 */ "sort_specification_list ::= sort_specification",
 /* 550 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 551 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 552 */ "ordering_specification_opt ::=",
 /* 553 */ "ordering_specification_opt ::= ASC",
 /* 554 */ "ordering_specification_opt ::= DESC",
 /* 555 */ "null_ordering_opt ::=",
 /* 556 */ "null_ordering_opt ::= NULLS FIRST",
 /* 557 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 326: /* cmd */
    case 329: /* literal */
    case 342: /* db_options */
    case 344: /* alter_db_options */
    case 350: /* retention */
    case 351: /* full_table_name */
    case 354: /* table_options */
    case 358: /* alter_table_clause */
    case 359: /* alter_table_options */
    case 362: /* signed_literal */
    case 363: /* create_subtable_clause */
    case 366: /* drop_table_clause */
    case 369: /* column_def */
    case 373: /* duration_literal */
    case 374: /* rollup_func_name */
    case 376: /* col_name */
    case 377: /* db_name_cond_opt */
    case 378: /* like_pattern_opt */
    case 379: /* table_name_cond */
    case 380: /* from_db_opt */
    case 382: /* tag_item */
    case 384: /* full_index_name */
    case 385: /* index_options */
    case 388: /* sliding_opt */
    case 389: /* sma_stream_opt */
    case 390: /* func */
    case 392: /* query_or_subquery */
    case 395: /* explain_options */
    case 396: /* insert_query */
    case 400: /* stream_options */
    case 403: /* subtable_opt */
    case 404: /* expression */
    case 406: /* where_clause_opt */
    case 407: /* signed */
    case 408: /* literal_func */
    case 411: /* expr_or_subquery */
    case 412: /* pseudo_column */
    case 413: /* column_reference */
    case 414: /* function_expression */
    case 415: /* case_when_expression */
    case 420: /* star_func_para */
    case 422: /* case_when_else_opt */
    case 423: /* common_expression */
    case 424: /* when_then_expr */
    case 425: /* predicate */
    case 428: /* in_predicate_value */
    case 429: /* boolean_value_expression */
    case 430: /* boolean_primary */
    case 431: /* from_clause_opt */
    case 432: /* table_reference_list */
    case 433: /* table_reference */
    case 434: /* table_primary */
    case 435: /* joined_table */
    case 437: /* subquery */
    case 438: /* parenthesized_joined_table */
    case 440: /* search_condition */
    case 441: /* query_specification */
    case 445: /* range_opt */
    case 446: /* every_opt */
    case 447: /* fill_opt */
    case 448: /* twindow_clause_opt */
    case 450: /* having_clause_opt */
    case 451: /* select_item */
    case 453: /* partition_item */
    case 456: /* query_expression */
    case 457: /* query_simple */
    case 459: /* slimit_clause_opt */
    case 460: /* limit_clause_opt */
    case 461: /* union_query_expression */
    case 462: /* query_simple_or_subquery */
    case 464: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy44)); 
}
      break;
    case 327: /* account_options */
    case 328: /* alter_account_options */
    case 330: /* alter_account_option */
    case 345: /* speed_opt */
    case 398: /* bufsize_opt */
{
 
}
      break;
    case 331: /* user_name */
    case 334: /* priv_level */
    case 337: /* db_name */
    case 338: /* topic_name */
    case 339: /* dnode_endpoint */
    case 360: /* column_name */
    case 368: /* table_name */
    case 375: /* function_name */
    case 383: /* column_alias */
    case 386: /* index_name */
    case 391: /* sma_func_name */
    case 393: /* cgroup_name */
    case 399: /* stream_name */
    case 410: /* table_alias */
    case 416: /* star_func */
    case 418: /* noarg_func */
    case 436: /* alias_opt */
{
 
}
      break;
    case 332: /* sysinfo_opt */
{
 
}
      break;
    case 333: /* privileges */
    case 335: /* priv_type_list */
    case 336: /* priv_type */
{
 
}
      break;
    case 340: /* force_opt */
    case 341: /* not_exists_opt */
    case 343: /* exists_opt */
    case 394: /* analyze_opt */
    case 397: /* agg_func_opt */
    case 442: /* set_quantifier_opt */
{
 
}
      break;
    case 346: /* integer_list */
    case 347: /* variable_list */
    case 348: /* retention_list */
    case 352: /* column_def_list */
    case 353: /* tags_def_opt */
    case 355: /* multi_create_clause */
    case 356: /* tags_def */
    case 357: /* multi_drop_clause */
    case 364: /* specific_cols_opt */
    case 365: /* expression_list */
    case 367: /* col_name_list */
    case 370: /* duration_list */
    case 371: /* rollup_func_list */
    case 381: /* tag_list_opt */
    case 387: /* func_list */
    case 401: /* col_list_opt */
    case 402: /* tag_def_or_ref_opt */
    case 405: /* dnode_list */
    case 409: /* literal_list */
    case 417: /* star_func_para_list */
    case 419: /* other_para_list */
    case 421: /* when_then_list */
    case 443: /* select_list */
    case 444: /* partition_by_clause_opt */
    case 449: /* group_by_clause_opt */
    case 452: /* partition_list */
    case 455: /* group_by_list */
    case 458: /* order_by_clause_opt */
    case 463: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy684)); 
}
      break;
    case 349: /* alter_db_option */
    case 372: /* alter_table_option */
{
 
}
      break;
    case 361: /* type_name */
{
 
}
      break;
    case 426: /* compare_op */
    case 427: /* in_op */
{
 
}
      break;
    case 439: /* join_type */
{
 
}
      break;
    case 454: /* fill_mode */
{
 
}
      break;
    case 465: /* ordering_specification_opt */
{
 
}
      break;
    case 466: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  326,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  326,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  327,    0 }, /* (2) account_options ::= */
  {  327,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  327,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  327,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  327,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  327,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  327,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  327,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  327,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  327,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  328,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  328,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  330,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  330,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  330,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  330,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  330,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  330,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  330,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  330,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  330,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  330,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  326,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  326,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  326,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  326,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  326,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  332,    0 }, /* (29) sysinfo_opt ::= */
  {  332,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  326,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  326,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  333,   -1 }, /* (33) privileges ::= ALL */
  {  333,   -1 }, /* (34) privileges ::= priv_type_list */
  {  333,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  335,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  335,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  336,   -1 }, /* (38) priv_type ::= READ */
  {  336,   -1 }, /* (39) priv_type ::= WRITE */
  {  334,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  334,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  334,   -1 }, /* (42) priv_level ::= topic_name */
  {  326,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  326,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  326,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  326,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  326,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  326,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  326,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  326,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  339,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  339,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  339,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  340,    0 }, /* (54) force_opt ::= */
  {  340,   -1 }, /* (55) force_opt ::= FORCE */
  {  326,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  326,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  326,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  326,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  326,   -2 }, /* (68) cmd ::= USE db_name */
  {  326,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  326,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  326,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  341,   -3 }, /* (72) not_exists_opt ::= IF NOT EXISTS */
  {  341,    0 }, /* (73) not_exists_opt ::= */
  {  343,   -2 }, /* (74) exists_opt ::= IF EXISTS */
  {  343,    0 }, /* (75) exists_opt ::= */
  {  342,    0 }, /* (76) db_options ::= */
  {  342,   -3 }, /* (77) db_options ::= db_options BUFFER NK_INTEGER */
  {  342,   -3 }, /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
  {  342,   -3 }, /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  342,   -3 }, /* (80) db_options ::= db_options COMP NK_INTEGER */
  {  342,   -3 }, /* (81) db_options ::= db_options DURATION NK_INTEGER */
  {  342,   -3 }, /* (82) db_options ::= db_options DURATION NK_VARIABLE */
  {  342,   -3 }, /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
  {  342,   -3 }, /* (84) db_options ::= db_options MINROWS NK_INTEGER */
  {  342,   -3 }, /* (85) db_options ::= db_options KEEP integer_list */
  {  342,   -3 }, /* (86) db_options ::= db_options KEEP variable_list */
  {  342,   -3 }, /* (87) db_options ::= db_options PAGES NK_INTEGER */
  {  342,   -3 }, /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  342,   -3 }, /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  342,   -3 }, /* (90) db_options ::= db_options PRECISION NK_STRING */
  {  342,   -3 }, /* (91) db_options ::= db_options REPLICA NK_INTEGER */
  {  342,   -3 }, /* (92) db_options ::= db_options VGROUPS NK_INTEGER */
  {  342,   -3 }, /* (93) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  342,   -3 }, /* (94) db_options ::= db_options RETENTIONS retention_list */
  {  342,   -3 }, /* (95) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  342,   -3 }, /* (96) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  342,   -3 }, /* (97) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  342,   -3 }, /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  342,   -4 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  342,   -3 }, /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  342,   -4 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  342,   -3 }, /* (102) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  342,   -3 }, /* (103) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  342,   -3 }, /* (104) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  342,   -3 }, /* (105) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  342,   -3 }, /* (106) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  344,   -1 }, /* (107) alter_db_options ::= alter_db_option */
  {  344,   -2 }, /* (108) alter_db_options ::= alter_db_options alter_db_option */
  {  349,   -2 }, /* (109) alter_db_option ::= BUFFER NK_INTEGER */
  {  349,   -2 }, /* (110) alter_db_option ::= CACHEMODEL NK_STRING */
  {  349,   -2 }, /* (111) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  349,   -2 }, /* (112) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  349,   -2 }, /* (113) alter_db_option ::= KEEP integer_list */
  {  349,   -2 }, /* (114) alter_db_option ::= KEEP variable_list */
  {  349,   -2 }, /* (115) alter_db_option ::= PAGES NK_INTEGER */
  {  349,   -2 }, /* (116) alter_db_option ::= REPLICA NK_INTEGER */
  {  349,   -2 }, /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  349,   -2 }, /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  346,   -1 }, /* (119) integer_list ::= NK_INTEGER */
  {  346,   -3 }, /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  347,   -1 }, /* (121) variable_list ::= NK_VARIABLE */
  {  347,   -3 }, /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  348,   -1 }, /* (123) retention_list ::= retention */
  {  348,   -3 }, /* (124) retention_list ::= retention_list NK_COMMA retention */
  {  350,   -3 }, /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  345,    0 }, /* (126) speed_opt ::= */
  {  345,   -2 }, /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  326,   -9 }, /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  326,   -3 }, /* (129) cmd ::= CREATE TABLE multi_create_clause */
  {  326,   -9 }, /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  326,   -3 }, /* (131) cmd ::= DROP TABLE multi_drop_clause */
  {  326,   -4 }, /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
  {  326,   -3 }, /* (133) cmd ::= ALTER TABLE alter_table_clause */
  {  326,   -3 }, /* (134) cmd ::= ALTER STABLE alter_table_clause */
  {  358,   -2 }, /* (135) alter_table_clause ::= full_table_name alter_table_options */
  {  358,   -5 }, /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  358,   -4 }, /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  358,   -5 }, /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  358,   -5 }, /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  358,   -5 }, /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  358,   -4 }, /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  358,   -5 }, /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  358,   -5 }, /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  358,   -6 }, /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  355,   -1 }, /* (145) multi_create_clause ::= create_subtable_clause */
  {  355,   -2 }, /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  363,  -10 }, /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  357,   -1 }, /* (148) multi_drop_clause ::= drop_table_clause */
  {  357,   -2 }, /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  366,   -2 }, /* (150) drop_table_clause ::= exists_opt full_table_name */
  {  364,    0 }, /* (151) specific_cols_opt ::= */
  {  364,   -3 }, /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  351,   -1 }, /* (153) full_table_name ::= table_name */
  {  351,   -3 }, /* (154) full_table_name ::= db_name NK_DOT table_name */
  {  352,   -1 }, /* (155) column_def_list ::= column_def */
  {  352,   -3 }, /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
  {  369,   -2 }, /* (157) column_def ::= column_name type_name */
  {  369,   -4 }, /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
  {  361,   -1 }, /* (159) type_name ::= BOOL */
  {  361,   -1 }, /* (160) type_name ::= TINYINT */
  {  361,   -1 }, /* (161) type_name ::= SMALLINT */
  {  361,   -1 }, /* (162) type_name ::= INT */
  {  361,   -1 }, /* (163) type_name ::= INTEGER */
  {  361,   -1 }, /* (164) type_name ::= BIGINT */
  {  361,   -1 }, /* (165) type_name ::= FLOAT */
  {  361,   -1 }, /* (166) type_name ::= DOUBLE */
  {  361,   -4 }, /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  361,   -1 }, /* (168) type_name ::= TIMESTAMP */
  {  361,   -4 }, /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  361,   -2 }, /* (170) type_name ::= TINYINT UNSIGNED */
  {  361,   -2 }, /* (171) type_name ::= SMALLINT UNSIGNED */
  {  361,   -2 }, /* (172) type_name ::= INT UNSIGNED */
  {  361,   -2 }, /* (173) type_name ::= BIGINT UNSIGNED */
  {  361,   -1 }, /* (174) type_name ::= JSON */
  {  361,   -4 }, /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  361,   -1 }, /* (176) type_name ::= MEDIUMBLOB */
  {  361,   -1 }, /* (177) type_name ::= BLOB */
  {  361,   -4 }, /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  361,   -1 }, /* (179) type_name ::= DECIMAL */
  {  361,   -4 }, /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  361,   -6 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  353,    0 }, /* (182) tags_def_opt ::= */
  {  353,   -1 }, /* (183) tags_def_opt ::= tags_def */
  {  356,   -4 }, /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  354,    0 }, /* (185) table_options ::= */
  {  354,   -3 }, /* (186) table_options ::= table_options COMMENT NK_STRING */
  {  354,   -3 }, /* (187) table_options ::= table_options MAX_DELAY duration_list */
  {  354,   -3 }, /* (188) table_options ::= table_options WATERMARK duration_list */
  {  354,   -5 }, /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  354,   -3 }, /* (190) table_options ::= table_options TTL NK_INTEGER */
  {  354,   -5 }, /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  354,   -3 }, /* (192) table_options ::= table_options DELETE_MARK duration_list */
  {  359,   -1 }, /* (193) alter_table_options ::= alter_table_option */
  {  359,   -2 }, /* (194) alter_table_options ::= alter_table_options alter_table_option */
  {  372,   -2 }, /* (195) alter_table_option ::= COMMENT NK_STRING */
  {  372,   -2 }, /* (196) alter_table_option ::= TTL NK_INTEGER */
  {  370,   -1 }, /* (197) duration_list ::= duration_literal */
  {  370,   -3 }, /* (198) duration_list ::= duration_list NK_COMMA duration_literal */
  {  371,   -1 }, /* (199) rollup_func_list ::= rollup_func_name */
  {  371,   -3 }, /* (200) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  374,   -1 }, /* (201) rollup_func_name ::= function_name */
  {  374,   -1 }, /* (202) rollup_func_name ::= FIRST */
  {  374,   -1 }, /* (203) rollup_func_name ::= LAST */
  {  367,   -1 }, /* (204) col_name_list ::= col_name */
  {  367,   -3 }, /* (205) col_name_list ::= col_name_list NK_COMMA col_name */
  {  376,   -1 }, /* (206) col_name ::= column_name */
  {  326,   -2 }, /* (207) cmd ::= SHOW DNODES */
  {  326,   -2 }, /* (208) cmd ::= SHOW USERS */
  {  326,   -3 }, /* (209) cmd ::= SHOW USER PRIVILEGES */
  {  326,   -2 }, /* (210) cmd ::= SHOW DATABASES */
  {  326,   -4 }, /* (211) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  326,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  326,   -3 }, /* (213) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  326,   -2 }, /* (214) cmd ::= SHOW MNODES */
  {  326,   -2 }, /* (215) cmd ::= SHOW QNODES */
  {  326,   -2 }, /* (216) cmd ::= SHOW FUNCTIONS */
  {  326,   -5 }, /* (217) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  326,   -2 }, /* (218) cmd ::= SHOW STREAMS */
  {  326,   -2 }, /* (219) cmd ::= SHOW ACCOUNTS */
  {  326,   -2 }, /* (220) cmd ::= SHOW APPS */
  {  326,   -2 }, /* (221) cmd ::= SHOW CONNECTIONS */
  {  326,   -2 }, /* (222) cmd ::= SHOW LICENCES */
  {  326,   -2 }, /* (223) cmd ::= SHOW GRANTS */
  {  326,   -4 }, /* (224) cmd ::= SHOW CREATE DATABASE db_name */
  {  326,   -4 }, /* (225) cmd ::= SHOW CREATE TABLE full_table_name */
  {  326,   -4 }, /* (226) cmd ::= SHOW CREATE STABLE full_table_name */
  {  326,   -2 }, /* (227) cmd ::= SHOW QUERIES */
  {  326,   -2 }, /* (228) cmd ::= SHOW SCORES */
  {  326,   -2 }, /* (229) cmd ::= SHOW TOPICS */
  {  326,   -2 }, /* (230) cmd ::= SHOW VARIABLES */
  {  326,   -3 }, /* (231) cmd ::= SHOW CLUSTER VARIABLES */
  {  326,   -3 }, /* (232) cmd ::= SHOW LOCAL VARIABLES */
  {  326,   -5 }, /* (233) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  326,   -2 }, /* (234) cmd ::= SHOW BNODES */
  {  326,   -2 }, /* (235) cmd ::= SHOW SNODES */
  {  326,   -2 }, /* (236) cmd ::= SHOW CLUSTER */
  {  326,   -2 }, /* (237) cmd ::= SHOW TRANSACTIONS */
  {  326,   -4 }, /* (238) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  326,   -2 }, /* (239) cmd ::= SHOW CONSUMERS */
  {  326,   -2 }, /* (240) cmd ::= SHOW SUBSCRIPTIONS */
  {  326,   -5 }, /* (241) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  326,   -7 }, /* (242) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  326,   -3 }, /* (243) cmd ::= SHOW VNODES NK_INTEGER */
  {  326,   -3 }, /* (244) cmd ::= SHOW VNODES NK_STRING */
  {  326,   -3 }, /* (245) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  326,   -3 }, /* (246) cmd ::= SHOW CLUSTER ALIVE */
  {  377,    0 }, /* (247) db_name_cond_opt ::= */
  {  377,   -2 }, /* (248) db_name_cond_opt ::= db_name NK_DOT */
  {  378,    0 }, /* (249) like_pattern_opt ::= */
  {  378,   -2 }, /* (250) like_pattern_opt ::= LIKE NK_STRING */
  {  379,   -1 }, /* (251) table_name_cond ::= table_name */
  {  380,    0 }, /* (252) from_db_opt ::= */
  {  380,   -2 }, /* (253) from_db_opt ::= FROM db_name */
  {  381,    0 }, /* (254) tag_list_opt ::= */
  {  381,   -1 }, /* (255) tag_list_opt ::= tag_item */
  {  381,   -3 }, /* (256) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  382,   -1 }, /* (257) tag_item ::= TBNAME */
  {  382,   -1 }, /* (258) tag_item ::= QTAGS */
  {  382,   -1 }, /* (259) tag_item ::= column_name */
  {  382,   -2 }, /* (260) tag_item ::= column_name column_alias */
  {  382,   -3 }, /* (261) tag_item ::= column_name AS column_alias */
  {  326,   -8 }, /* (262) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  326,   -9 }, /* (263) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  326,   -4 }, /* (264) cmd ::= DROP INDEX exists_opt full_index_name */
  {  384,   -1 }, /* (265) full_index_name ::= index_name */
  {  384,   -3 }, /* (266) full_index_name ::= db_name NK_DOT index_name */
  {  385,  -10 }, /* (267) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  385,  -12 }, /* (268) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  387,   -1 }, /* (269) func_list ::= func */
  {  387,   -3 }, /* (270) func_list ::= func_list NK_COMMA func */
  {  390,   -4 }, /* (271) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  391,   -1 }, /* (272) sma_func_name ::= function_name */
  {  391,   -1 }, /* (273) sma_func_name ::= COUNT */
  {  391,   -1 }, /* (274) sma_func_name ::= FIRST */
  {  391,   -1 }, /* (275) sma_func_name ::= LAST */
  {  391,   -1 }, /* (276) sma_func_name ::= LAST_ROW */
  {  389,    0 }, /* (277) sma_stream_opt ::= */
  {  389,   -3 }, /* (278) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  389,   -3 }, /* (279) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  389,   -3 }, /* (280) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  326,   -6 }, /* (281) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  326,   -7 }, /* (282) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  326,   -9 }, /* (283) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  326,   -7 }, /* (284) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  326,   -9 }, /* (285) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  326,   -4 }, /* (286) cmd ::= DROP TOPIC exists_opt topic_name */
  {  326,   -7 }, /* (287) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  326,   -2 }, /* (288) cmd ::= DESC full_table_name */
  {  326,   -2 }, /* (289) cmd ::= DESCRIBE full_table_name */
  {  326,   -3 }, /* (290) cmd ::= RESET QUERY CACHE */
  {  326,   -4 }, /* (291) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  326,   -4 }, /* (292) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
  {  394,    0 }, /* (293) analyze_opt ::= */
  {  394,   -1 }, /* (294) analyze_opt ::= ANALYZE */
  {  395,    0 }, /* (295) explain_options ::= */
  {  395,   -3 }, /* (296) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  395,   -3 }, /* (297) explain_options ::= explain_options RATIO NK_FLOAT */
  {  326,  -10 }, /* (298) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  326,   -4 }, /* (299) cmd ::= DROP FUNCTION exists_opt function_name */
  {  397,    0 }, /* (300) agg_func_opt ::= */
  {  397,   -1 }, /* (301) agg_func_opt ::= AGGREGATE */
  {  398,    0 }, /* (302) bufsize_opt ::= */
  {  398,   -2 }, /* (303) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  326,  -12 }, /* (304) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  326,   -4 }, /* (305) cmd ::= DROP STREAM exists_opt stream_name */
  {  401,    0 }, /* (306) col_list_opt ::= */
  {  401,   -3 }, /* (307) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  402,    0 }, /* (308) tag_def_or_ref_opt ::= */
  {  402,   -1 }, /* (309) tag_def_or_ref_opt ::= tags_def */
  {  402,   -4 }, /* (310) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  400,    0 }, /* (311) stream_options ::= */
  {  400,   -3 }, /* (312) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  400,   -3 }, /* (313) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  400,   -4 }, /* (314) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  400,   -3 }, /* (315) stream_options ::= stream_options WATERMARK duration_literal */
  {  400,   -4 }, /* (316) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  400,   -3 }, /* (317) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  403,    0 }, /* (318) subtable_opt ::= */
  {  403,   -4 }, /* (319) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  326,   -3 }, /* (320) cmd ::= KILL CONNECTION NK_INTEGER */
  {  326,   -3 }, /* (321) cmd ::= KILL QUERY NK_STRING */
  {  326,   -3 }, /* (322) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  326,   -2 }, /* (323) cmd ::= BALANCE VGROUP */
  {  326,   -4 }, /* (324) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  326,   -4 }, /* (325) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  326,   -3 }, /* (326) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  405,   -2 }, /* (327) dnode_list ::= DNODE NK_INTEGER */
  {  405,   -3 }, /* (328) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  326,   -4 }, /* (329) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  326,   -1 }, /* (330) cmd ::= query_or_subquery */
  {  326,   -1 }, /* (331) cmd ::= insert_query */
  {  396,   -7 }, /* (332) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  396,   -4 }, /* (333) insert_query ::= INSERT INTO full_table_name query_or_subquery */
  {  329,   -1 }, /* (334) literal ::= NK_INTEGER */
  {  329,   -1 }, /* (335) literal ::= NK_FLOAT */
  {  329,   -1 }, /* (336) literal ::= NK_STRING */
  {  329,   -1 }, /* (337) literal ::= NK_BOOL */
  {  329,   -2 }, /* (338) literal ::= TIMESTAMP NK_STRING */
  {  329,   -1 }, /* (339) literal ::= duration_literal */
  {  329,   -1 }, /* (340) literal ::= NULL */
  {  329,   -1 }, /* (341) literal ::= NK_QUESTION */
  {  373,   -1 }, /* (342) duration_literal ::= NK_VARIABLE */
  {  407,   -1 }, /* (343) signed ::= NK_INTEGER */
  {  407,   -2 }, /* (344) signed ::= NK_PLUS NK_INTEGER */
  {  407,   -2 }, /* (345) signed ::= NK_MINUS NK_INTEGER */
  {  407,   -1 }, /* (346) signed ::= NK_FLOAT */
  {  407,   -2 }, /* (347) signed ::= NK_PLUS NK_FLOAT */
  {  407,   -2 }, /* (348) signed ::= NK_MINUS NK_FLOAT */
  {  362,   -1 }, /* (349) signed_literal ::= signed */
  {  362,   -1 }, /* (350) signed_literal ::= NK_STRING */
  {  362,   -1 }, /* (351) signed_literal ::= NK_BOOL */
  {  362,   -2 }, /* (352) signed_literal ::= TIMESTAMP NK_STRING */
  {  362,   -1 }, /* (353) signed_literal ::= duration_literal */
  {  362,   -1 }, /* (354) signed_literal ::= NULL */
  {  362,   -1 }, /* (355) signed_literal ::= literal_func */
  {  362,   -1 }, /* (356) signed_literal ::= NK_QUESTION */
  {  409,   -1 }, /* (357) literal_list ::= signed_literal */
  {  409,   -3 }, /* (358) literal_list ::= literal_list NK_COMMA signed_literal */
  {  337,   -1 }, /* (359) db_name ::= NK_ID */
  {  368,   -1 }, /* (360) table_name ::= NK_ID */
  {  360,   -1 }, /* (361) column_name ::= NK_ID */
  {  375,   -1 }, /* (362) function_name ::= NK_ID */
  {  410,   -1 }, /* (363) table_alias ::= NK_ID */
  {  383,   -1 }, /* (364) column_alias ::= NK_ID */
  {  331,   -1 }, /* (365) user_name ::= NK_ID */
  {  338,   -1 }, /* (366) topic_name ::= NK_ID */
  {  399,   -1 }, /* (367) stream_name ::= NK_ID */
  {  393,   -1 }, /* (368) cgroup_name ::= NK_ID */
  {  386,   -1 }, /* (369) index_name ::= NK_ID */
  {  411,   -1 }, /* (370) expr_or_subquery ::= expression */
  {  404,   -1 }, /* (371) expression ::= literal */
  {  404,   -1 }, /* (372) expression ::= pseudo_column */
  {  404,   -1 }, /* (373) expression ::= column_reference */
  {  404,   -1 }, /* (374) expression ::= function_expression */
  {  404,   -1 }, /* (375) expression ::= case_when_expression */
  {  404,   -3 }, /* (376) expression ::= NK_LP expression NK_RP */
  {  404,   -2 }, /* (377) expression ::= NK_PLUS expr_or_subquery */
  {  404,   -2 }, /* (378) expression ::= NK_MINUS expr_or_subquery */
  {  404,   -3 }, /* (379) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  404,   -3 }, /* (380) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  404,   -3 }, /* (381) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  404,   -3 }, /* (382) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  404,   -3 }, /* (383) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  404,   -3 }, /* (384) expression ::= column_reference NK_ARROW NK_STRING */
  {  404,   -3 }, /* (385) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  404,   -3 }, /* (386) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  365,   -1 }, /* (387) expression_list ::= expr_or_subquery */
  {  365,   -3 }, /* (388) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  413,   -1 }, /* (389) column_reference ::= column_name */
  {  413,   -3 }, /* (390) column_reference ::= table_name NK_DOT column_name */
  {  412,   -1 }, /* (391) pseudo_column ::= ROWTS */
  {  412,   -1 }, /* (392) pseudo_column ::= TBNAME */
  {  412,   -3 }, /* (393) pseudo_column ::= table_name NK_DOT TBNAME */
  {  412,   -1 }, /* (394) pseudo_column ::= QSTART */
  {  412,   -1 }, /* (395) pseudo_column ::= QEND */
  {  412,   -1 }, /* (396) pseudo_column ::= QDURATION */
  {  412,   -1 }, /* (397) pseudo_column ::= WSTART */
  {  412,   -1 }, /* (398) pseudo_column ::= WEND */
  {  412,   -1 }, /* (399) pseudo_column ::= WDURATION */
  {  412,   -1 }, /* (400) pseudo_column ::= IROWTS */
  {  412,   -1 }, /* (401) pseudo_column ::= ISFILLED */
  {  412,   -1 }, /* (402) pseudo_column ::= QTAGS */
  {  414,   -4 }, /* (403) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  414,   -4 }, /* (404) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  414,   -6 }, /* (405) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  414,   -1 }, /* (406) function_expression ::= literal_func */
  {  408,   -3 }, /* (407) literal_func ::= noarg_func NK_LP NK_RP */
  {  408,   -1 }, /* (408) literal_func ::= NOW */
  {  418,   -1 }, /* (409) noarg_func ::= NOW */
  {  418,   -1 }, /* (410) noarg_func ::= TODAY */
  {  418,   -1 }, /* (411) noarg_func ::= TIMEZONE */
  {  418,   -1 }, /* (412) noarg_func ::= DATABASE */
  {  418,   -1 }, /* (413) noarg_func ::= CLIENT_VERSION */
  {  418,   -1 }, /* (414) noarg_func ::= SERVER_VERSION */
  {  418,   -1 }, /* (415) noarg_func ::= SERVER_STATUS */
  {  418,   -1 }, /* (416) noarg_func ::= CURRENT_USER */
  {  418,   -1 }, /* (417) noarg_func ::= USER */
  {  416,   -1 }, /* (418) star_func ::= COUNT */
  {  416,   -1 }, /* (419) star_func ::= FIRST */
  {  416,   -1 }, /* (420) star_func ::= LAST */
  {  416,   -1 }, /* (421) star_func ::= LAST_ROW */
  {  417,   -1 }, /* (422) star_func_para_list ::= NK_STAR */
  {  417,   -1 }, /* (423) star_func_para_list ::= other_para_list */
  {  419,   -1 }, /* (424) other_para_list ::= star_func_para */
  {  419,   -3 }, /* (425) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  420,   -1 }, /* (426) star_func_para ::= expr_or_subquery */
  {  420,   -3 }, /* (427) star_func_para ::= table_name NK_DOT NK_STAR */
  {  415,   -4 }, /* (428) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  415,   -5 }, /* (429) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  421,   -1 }, /* (430) when_then_list ::= when_then_expr */
  {  421,   -2 }, /* (431) when_then_list ::= when_then_list when_then_expr */
  {  424,   -4 }, /* (432) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  422,    0 }, /* (433) case_when_else_opt ::= */
  {  422,   -2 }, /* (434) case_when_else_opt ::= ELSE common_expression */
  {  425,   -3 }, /* (435) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  425,   -5 }, /* (436) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  425,   -6 }, /* (437) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  425,   -3 }, /* (438) predicate ::= expr_or_subquery IS NULL */
  {  425,   -4 }, /* (439) predicate ::= expr_or_subquery IS NOT NULL */
  {  425,   -3 }, /* (440) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  426,   -1 }, /* (441) compare_op ::= NK_LT */
  {  426,   -1 }, /* (442) compare_op ::= NK_GT */
  {  426,   -1 }, /* (443) compare_op ::= NK_LE */
  {  426,   -1 }, /* (444) compare_op ::= NK_GE */
  {  426,   -1 }, /* (445) compare_op ::= NK_NE */
  {  426,   -1 }, /* (446) compare_op ::= NK_EQ */
  {  426,   -1 }, /* (447) compare_op ::= LIKE */
  {  426,   -2 }, /* (448) compare_op ::= NOT LIKE */
  {  426,   -1 }, /* (449) compare_op ::= MATCH */
  {  426,   -1 }, /* (450) compare_op ::= NMATCH */
  {  426,   -1 }, /* (451) compare_op ::= CONTAINS */
  {  427,   -1 }, /* (452) in_op ::= IN */
  {  427,   -2 }, /* (453) in_op ::= NOT IN */
  {  428,   -3 }, /* (454) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  429,   -1 }, /* (455) boolean_value_expression ::= boolean_primary */
  {  429,   -2 }, /* (456) boolean_value_expression ::= NOT boolean_primary */
  {  429,   -3 }, /* (457) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  429,   -3 }, /* (458) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  430,   -1 }, /* (459) boolean_primary ::= predicate */
  {  430,   -3 }, /* (460) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  423,   -1 }, /* (461) common_expression ::= expr_or_subquery */
  {  423,   -1 }, /* (462) common_expression ::= boolean_value_expression */
  {  431,    0 }, /* (463) from_clause_opt ::= */
  {  431,   -2 }, /* (464) from_clause_opt ::= FROM table_reference_list */
  {  432,   -1 }, /* (465) table_reference_list ::= table_reference */
  {  432,   -3 }, /* (466) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  433,   -1 }, /* (467) table_reference ::= table_primary */
  {  433,   -1 }, /* (468) table_reference ::= joined_table */
  {  434,   -2 }, /* (469) table_primary ::= table_name alias_opt */
  {  434,   -4 }, /* (470) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  434,   -2 }, /* (471) table_primary ::= subquery alias_opt */
  {  434,   -1 }, /* (472) table_primary ::= parenthesized_joined_table */
  {  436,    0 }, /* (473) alias_opt ::= */
  {  436,   -1 }, /* (474) alias_opt ::= table_alias */
  {  436,   -2 }, /* (475) alias_opt ::= AS table_alias */
  {  438,   -3 }, /* (476) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  438,   -3 }, /* (477) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  435,   -6 }, /* (478) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  439,    0 }, /* (479) join_type ::= */
  {  439,   -1 }, /* (480) join_type ::= INNER */
  {  441,  -12 }, /* (481) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  442,    0 }, /* (482) set_quantifier_opt ::= */
  {  442,   -1 }, /* (483) set_quantifier_opt ::= DISTINCT */
  {  442,   -1 }, /* (484) set_quantifier_opt ::= ALL */
  {  443,   -1 }, /* (485) select_list ::= select_item */
  {  443,   -3 }, /* (486) select_list ::= select_list NK_COMMA select_item */
  {  451,   -1 }, /* (487) select_item ::= NK_STAR */
  {  451,   -1 }, /* (488) select_item ::= common_expression */
  {  451,   -2 }, /* (489) select_item ::= common_expression column_alias */
  {  451,   -3 }, /* (490) select_item ::= common_expression AS column_alias */
  {  451,   -3 }, /* (491) select_item ::= table_name NK_DOT NK_STAR */
  {  406,    0 }, /* (492) where_clause_opt ::= */
  {  406,   -2 }, /* (493) where_clause_opt ::= WHERE search_condition */
  {  444,    0 }, /* (494) partition_by_clause_opt ::= */
  {  444,   -3 }, /* (495) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  452,   -1 }, /* (496) partition_list ::= partition_item */
  {  452,   -3 }, /* (497) partition_list ::= partition_list NK_COMMA partition_item */
  {  453,   -1 }, /* (498) partition_item ::= expr_or_subquery */
  {  453,   -2 }, /* (499) partition_item ::= expr_or_subquery column_alias */
  {  453,   -3 }, /* (500) partition_item ::= expr_or_subquery AS column_alias */
  {  448,    0 }, /* (501) twindow_clause_opt ::= */
  {  448,   -6 }, /* (502) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  448,   -4 }, /* (503) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  448,   -6 }, /* (504) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  448,   -8 }, /* (505) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  448,   -7 }, /* (506) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  388,    0 }, /* (507) sliding_opt ::= */
  {  388,   -4 }, /* (508) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  447,    0 }, /* (509) fill_opt ::= */
  {  447,   -4 }, /* (510) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  447,   -6 }, /* (511) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  454,   -1 }, /* (512) fill_mode ::= NONE */
  {  454,   -1 }, /* (513) fill_mode ::= PREV */
  {  454,   -1 }, /* (514) fill_mode ::= NULL */
  {  454,   -1 }, /* (515) fill_mode ::= LINEAR */
  {  454,   -1 }, /* (516) fill_mode ::= NEXT */
  {  449,    0 }, /* (517) group_by_clause_opt ::= */
  {  449,   -3 }, /* (518) group_by_clause_opt ::= GROUP BY group_by_list */
  {  455,   -1 }, /* (519) group_by_list ::= expr_or_subquery */
  {  455,   -3 }, /* (520) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  450,    0 }, /* (521) having_clause_opt ::= */
  {  450,   -2 }, /* (522) having_clause_opt ::= HAVING search_condition */
  {  445,    0 }, /* (523) range_opt ::= */
  {  445,   -6 }, /* (524) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  446,    0 }, /* (525) every_opt ::= */
  {  446,   -4 }, /* (526) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  456,   -4 }, /* (527) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  457,   -1 }, /* (528) query_simple ::= query_specification */
  {  457,   -1 }, /* (529) query_simple ::= union_query_expression */
  {  461,   -4 }, /* (530) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  461,   -3 }, /* (531) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  462,   -1 }, /* (532) query_simple_or_subquery ::= query_simple */
  {  462,   -1 }, /* (533) query_simple_or_subquery ::= subquery */
  {  392,   -1 }, /* (534) query_or_subquery ::= query_expression */
  {  392,   -1 }, /* (535) query_or_subquery ::= subquery */
  {  458,    0 }, /* (536) order_by_clause_opt ::= */
  {  458,   -3 }, /* (537) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  459,    0 }, /* (538) slimit_clause_opt ::= */
  {  459,   -2 }, /* (539) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  459,   -4 }, /* (540) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  459,   -4 }, /* (541) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  460,    0 }, /* (542) limit_clause_opt ::= */
  {  460,   -2 }, /* (543) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  460,   -4 }, /* (544) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  460,   -4 }, /* (545) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  437,   -3 }, /* (546) subquery ::= NK_LP query_expression NK_RP */
  {  437,   -3 }, /* (547) subquery ::= NK_LP subquery NK_RP */
  {  440,   -1 }, /* (548) search_condition ::= common_expression */
  {  463,   -1 }, /* (549) sort_specification_list ::= sort_specification */
  {  463,   -3 }, /* (550) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  464,   -3 }, /* (551) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  465,    0 }, /* (552) ordering_specification_opt ::= */
  {  465,   -1 }, /* (553) ordering_specification_opt ::= ASC */
  {  465,   -1 }, /* (554) ordering_specification_opt ::= DESC */
  {  466,    0 }, /* (555) null_ordering_opt ::= */
  {  466,   -2 }, /* (556) null_ordering_opt ::= NULLS FIRST */
  {  466,   -2 }, /* (557) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,327,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,328,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,327,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,330,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,328,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,330,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy455, &yymsp[-1].minor.yy0, yymsp[0].minor.yy169); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy455, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy455, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy455, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy455); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy169 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy169 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy91, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy455); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy91, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy455); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy91 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy91 = yymsp[0].minor.yy91; }
  yymsp[0].minor.yy91 = yylhsminor.yy91;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy91 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy91 = yymsp[-2].minor.yy91 | yymsp[0].minor.yy91; }
  yymsp[-2].minor.yy91 = yylhsminor.yy91;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy91 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy91 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy455 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy455 = yylhsminor.yy455;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy455 = yymsp[-2].minor.yy455; }
  yymsp[-2].minor.yy455 = yylhsminor.yy455;
        break;
      case 42: /* priv_level ::= topic_name */
      case 272: /* sma_func_name ::= function_name */ yytestcase(yyruleno==272);
      case 474: /* alias_opt ::= table_alias */ yytestcase(yyruleno==474);
{ yylhsminor.yy455 = yymsp[0].minor.yy455; }
  yymsp[0].minor.yy455 = yylhsminor.yy455;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy455, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy163); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy455, yymsp[0].minor.yy163); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 273: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==273);
      case 274: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==274);
      case 275: /* sma_func_name ::= LAST */ yytestcase(yyruleno==275);
      case 276: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==276);
      case 359: /* db_name ::= NK_ID */ yytestcase(yyruleno==359);
      case 360: /* table_name ::= NK_ID */ yytestcase(yyruleno==360);
      case 361: /* column_name ::= NK_ID */ yytestcase(yyruleno==361);
      case 362: /* function_name ::= NK_ID */ yytestcase(yyruleno==362);
      case 363: /* table_alias ::= NK_ID */ yytestcase(yyruleno==363);
      case 364: /* column_alias ::= NK_ID */ yytestcase(yyruleno==364);
      case 365: /* user_name ::= NK_ID */ yytestcase(yyruleno==365);
      case 366: /* topic_name ::= NK_ID */ yytestcase(yyruleno==366);
      case 367: /* stream_name ::= NK_ID */ yytestcase(yyruleno==367);
      case 368: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==368);
      case 369: /* index_name ::= NK_ID */ yytestcase(yyruleno==369);
      case 409: /* noarg_func ::= NOW */ yytestcase(yyruleno==409);
      case 410: /* noarg_func ::= TODAY */ yytestcase(yyruleno==410);
      case 411: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==411);
      case 412: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==412);
      case 413: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==413);
      case 414: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==414);
      case 415: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==415);
      case 416: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==416);
      case 417: /* noarg_func ::= USER */ yytestcase(yyruleno==417);
      case 418: /* star_func ::= COUNT */ yytestcase(yyruleno==418);
      case 419: /* star_func ::= FIRST */ yytestcase(yyruleno==419);
      case 420: /* star_func ::= LAST */ yytestcase(yyruleno==420);
      case 421: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==421);
{ yylhsminor.yy455 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy455 = yylhsminor.yy455;
        break;
      case 54: /* force_opt ::= */
      case 73: /* not_exists_opt ::= */ yytestcase(yyruleno==73);
      case 75: /* exists_opt ::= */ yytestcase(yyruleno==75);
      case 293: /* analyze_opt ::= */ yytestcase(yyruleno==293);
      case 300: /* agg_func_opt ::= */ yytestcase(yyruleno==300);
      case 482: /* set_quantifier_opt ::= */ yytestcase(yyruleno==482);
{ yymsp[1].minor.yy163 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 294: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==294);
      case 301: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==301);
      case 483: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==483);
{ yymsp[0].minor.yy163 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy163, &yymsp[-1].minor.yy455, yymsp[0].minor.yy44); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy163, &yymsp[0].minor.yy455); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy455); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy455, yymsp[0].minor.yy44); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy455); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy455, yymsp[0].minor.yy832); }
        break;
      case 72: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy163 = true; }
        break;
      case 74: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy163 = true; }
        break;
      case 76: /* db_options ::= */
{ yymsp[1].minor.yy44 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 77: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 78: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 79: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 80: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 81: /* db_options ::= db_options DURATION NK_INTEGER */
      case 82: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==82);
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 83: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 84: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 85: /* db_options ::= db_options KEEP integer_list */
      case 86: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==86);
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_KEEP, yymsp[0].minor.yy684); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 87: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 88: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 89: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 90: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 91: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 92: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 93: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 94: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_RETENTIONS, yymsp[0].minor.yy684); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 95: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 96: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 97: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-3].minor.yy44, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-3].minor.yy44, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 102: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 103: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 104: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 105: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 106: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 107: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy44 = createAlterDatabaseOptions(pCxt); yylhsminor.yy44 = setAlterDatabaseOption(pCxt, yylhsminor.yy44, &yymsp[0].minor.yy153); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 108: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy44 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy44, &yymsp[0].minor.yy153); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 109: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy153.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy153.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy153.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy153.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= KEEP integer_list */
      case 114: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==114);
{ yymsp[-1].minor.yy153.type = DB_OPTION_KEEP; yymsp[-1].minor.yy153.pList = yymsp[0].minor.yy684; }
        break;
      case 115: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy153.type = DB_OPTION_PAGES; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy153.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy153.type = DB_OPTION_WAL; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy153.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy684 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy684 = yylhsminor.yy684;
        break;
      case 120: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 328: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==328);
{ yylhsminor.yy684 = addNodeToList(pCxt, yymsp[-2].minor.yy684, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy684 = yylhsminor.yy684;
        break;
      case 121: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy684 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy684 = yylhsminor.yy684;
        break;
      case 122: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy684 = addNodeToList(pCxt, yymsp[-2].minor.yy684, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy684 = yylhsminor.yy684;
        break;
      case 123: /* retention_list ::= retention */
      case 145: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==145);
      case 148: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==148);
      case 155: /* column_def_list ::= column_def */ yytestcase(yyruleno==155);
      case 199: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==199);
      case 204: /* col_name_list ::= col_name */ yytestcase(yyruleno==204);
      case 255: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==255);
      case 269: /* func_list ::= func */ yytestcase(yyruleno==269);
      case 357: /* literal_list ::= signed_literal */ yytestcase(yyruleno==357);
      case 424: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==424);
      case 430: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==430);
      case 485: /* select_list ::= select_item */ yytestcase(yyruleno==485);
      case 496: /* partition_list ::= partition_item */ yytestcase(yyruleno==496);
      case 549: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==549);
{ yylhsminor.yy684 = createNodeList(pCxt, yymsp[0].minor.yy44); }
  yymsp[0].minor.yy684 = yylhsminor.yy684;
        break;
      case 124: /* retention_list ::= retention_list NK_COMMA retention */
      case 156: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==205);
      case 256: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==256);
      case 270: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==270);
      case 358: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==358);
      case 425: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==425);
      case 486: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==486);
      case 497: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==497);
      case 550: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==550);
{ yylhsminor.yy684 = addNodeToList(pCxt, yymsp[-2].minor.yy684, yymsp[0].minor.yy44); }
  yymsp[-2].minor.yy684 = yylhsminor.yy684;
        break;
      case 125: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy44 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 126: /* speed_opt ::= */
      case 302: /* bufsize_opt ::= */ yytestcase(yyruleno==302);
{ yymsp[1].minor.yy832 = 0; }
        break;
      case 127: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 303: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==303);
{ yymsp[-1].minor.yy832 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 128: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 130: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==130);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy163, yymsp[-5].minor.yy44, yymsp[-3].minor.yy684, yymsp[-1].minor.yy684, yymsp[0].minor.yy44); }
        break;
      case 129: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy684); }
        break;
      case 131: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy684); }
        break;
      case 132: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy163, yymsp[0].minor.yy44); }
        break;
      case 133: /* cmd ::= ALTER TABLE alter_table_clause */
      case 330: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==330);
      case 331: /* cmd ::= insert_query */ yytestcase(yyruleno==331);
{ pCxt->pRootNode = yymsp[0].minor.yy44; }
        break;
      case 134: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy44); }
        break;
      case 135: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy44 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy44, yymsp[0].minor.yy44); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy44 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy44, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy455, yymsp[0].minor.yy260); }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy44 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy44, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy455); }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy44 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy44, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy455, yymsp[0].minor.yy260); }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy44 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy44, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy455, &yymsp[0].minor.yy455); }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 140: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy44 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy44, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy455, yymsp[0].minor.yy260); }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 141: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy44 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy44, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy455); }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 142: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy44 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy44, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy455, yymsp[0].minor.yy260); }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 143: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy44 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy44, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy455, &yymsp[0].minor.yy455); }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 144: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy44 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy44, &yymsp[-2].minor.yy455, yymsp[0].minor.yy44); }
  yymsp[-5].minor.yy44 = yylhsminor.yy44;
        break;
      case 146: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 149: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==149);
      case 431: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==431);
{ yylhsminor.yy684 = addNodeToList(pCxt, yymsp[-1].minor.yy684, yymsp[0].minor.yy44); }
  yymsp[-1].minor.yy684 = yylhsminor.yy684;
        break;
      case 147: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy44 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy163, yymsp[-8].minor.yy44, yymsp[-6].minor.yy44, yymsp[-5].minor.yy684, yymsp[-2].minor.yy684, yymsp[0].minor.yy44); }
  yymsp[-9].minor.yy44 = yylhsminor.yy44;
        break;
      case 150: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy44 = createDropTableClause(pCxt, yymsp[-1].minor.yy163, yymsp[0].minor.yy44); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 151: /* specific_cols_opt ::= */
      case 182: /* tags_def_opt ::= */ yytestcase(yyruleno==182);
      case 254: /* tag_list_opt ::= */ yytestcase(yyruleno==254);
      case 306: /* col_list_opt ::= */ yytestcase(yyruleno==306);
      case 308: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==308);
      case 494: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==494);
      case 517: /* group_by_clause_opt ::= */ yytestcase(yyruleno==517);
      case 536: /* order_by_clause_opt ::= */ yytestcase(yyruleno==536);
{ yymsp[1].minor.yy684 = NULL; }
        break;
      case 152: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 307: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==307);
{ yymsp[-2].minor.yy684 = yymsp[-1].minor.yy684; }
        break;
      case 153: /* full_table_name ::= table_name */
{ yylhsminor.yy44 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy455, NULL); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 154: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy44 = createRealTableNode(pCxt, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy455, NULL); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 157: /* column_def ::= column_name type_name */
{ yylhsminor.yy44 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy455, yymsp[0].minor.yy260, NULL); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 158: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy44 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy455, yymsp[-2].minor.yy260, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 159: /* type_name ::= BOOL */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 160: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 161: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 162: /* type_name ::= INT */
      case 163: /* type_name ::= INTEGER */ yytestcase(yyruleno==163);
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 164: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 165: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 166: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 167: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy260 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 169: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy260 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy260 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy260 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 172: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy260 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 173: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy260 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 174: /* type_name ::= JSON */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 175: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy260 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 176: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 177: /* type_name ::= BLOB */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 178: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy260 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 180: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy260 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy260 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* tags_def_opt ::= tags_def */
      case 309: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==309);
      case 423: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==423);
{ yylhsminor.yy684 = yymsp[0].minor.yy684; }
  yymsp[0].minor.yy684 = yylhsminor.yy684;
        break;
      case 184: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 310: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==310);
{ yymsp[-3].minor.yy684 = yymsp[-1].minor.yy684; }
        break;
      case 185: /* table_options ::= */
{ yymsp[1].minor.yy44 = createDefaultTableOptions(pCxt); }
        break;
      case 186: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy44 = setTableOption(pCxt, yymsp[-2].minor.yy44, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 187: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy44 = setTableOption(pCxt, yymsp[-2].minor.yy44, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy684); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 188: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy44 = setTableOption(pCxt, yymsp[-2].minor.yy44, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy684); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 189: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy44 = setTableOption(pCxt, yymsp[-4].minor.yy44, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy684); }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 190: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy44 = setTableOption(pCxt, yymsp[-2].minor.yy44, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 191: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy44 = setTableOption(pCxt, yymsp[-4].minor.yy44, TABLE_OPTION_SMA, yymsp[-1].minor.yy684); }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 192: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy44 = setTableOption(pCxt, yymsp[-2].minor.yy44, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy684); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 193: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy44 = createAlterTableOptions(pCxt); yylhsminor.yy44 = setTableOption(pCxt, yylhsminor.yy44, yymsp[0].minor.yy153.type, &yymsp[0].minor.yy153.val); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 194: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy44 = setTableOption(pCxt, yymsp[-1].minor.yy44, yymsp[0].minor.yy153.type, &yymsp[0].minor.yy153.val); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 195: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy153.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 196: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy153.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* duration_list ::= duration_literal */
      case 387: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==387);
{ yylhsminor.yy684 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy44)); }
  yymsp[0].minor.yy684 = yylhsminor.yy684;
        break;
      case 198: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 388: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==388);
{ yylhsminor.yy684 = addNodeToList(pCxt, yymsp[-2].minor.yy684, releaseRawExprNode(pCxt, yymsp[0].minor.yy44)); }
  yymsp[-2].minor.yy684 = yylhsminor.yy684;
        break;
      case 201: /* rollup_func_name ::= function_name */
{ yylhsminor.yy44 = createFunctionNode(pCxt, &yymsp[0].minor.yy455, NULL); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 202: /* rollup_func_name ::= FIRST */
      case 203: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==203);
      case 258: /* tag_item ::= QTAGS */ yytestcase(yyruleno==258);
{ yylhsminor.yy44 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 206: /* col_name ::= column_name */
      case 259: /* tag_item ::= column_name */ yytestcase(yyruleno==259);
{ yylhsminor.yy44 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy455); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 207: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 208: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 209: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 210: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 211: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy44, yymsp[0].minor.yy44, OP_TYPE_LIKE); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy44, yymsp[0].minor.yy44, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy44, NULL, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy44, yymsp[-1].minor.yy44, OP_TYPE_EQUAL); }
        break;
      case 218: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 219: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 220: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 221: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 222: /* cmd ::= SHOW LICENCES */
      case 223: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==223);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 224: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy455); }
        break;
      case 225: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy44); }
        break;
      case 226: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy44); }
        break;
      case 227: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 228: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 229: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 230: /* cmd ::= SHOW VARIABLES */
      case 231: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==231);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 232: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy44); }
        break;
      case 234: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 235: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 237: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 238: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy44); }
        break;
      case 239: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 240: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 241: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy44, yymsp[-1].minor.yy44, OP_TYPE_EQUAL); }
        break;
      case 242: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy44, yymsp[0].minor.yy44, yymsp[-3].minor.yy684); }
        break;
      case 243: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 245: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy44,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 246: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 247: /* db_name_cond_opt ::= */
      case 252: /* from_db_opt ::= */ yytestcase(yyruleno==252);
{ yymsp[1].minor.yy44 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 248: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy44 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy455); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 249: /* like_pattern_opt ::= */
      case 318: /* subtable_opt ::= */ yytestcase(yyruleno==318);
      case 433: /* case_when_else_opt ::= */ yytestcase(yyruleno==433);
      case 463: /* from_clause_opt ::= */ yytestcase(yyruleno==463);
      case 492: /* where_clause_opt ::= */ yytestcase(yyruleno==492);
      case 501: /* twindow_clause_opt ::= */ yytestcase(yyruleno==501);
      case 507: /* sliding_opt ::= */ yytestcase(yyruleno==507);
      case 509: /* fill_opt ::= */ yytestcase(yyruleno==509);
      case 521: /* having_clause_opt ::= */ yytestcase(yyruleno==521);
      case 523: /* range_opt ::= */ yytestcase(yyruleno==523);
      case 525: /* every_opt ::= */ yytestcase(yyruleno==525);
      case 538: /* slimit_clause_opt ::= */ yytestcase(yyruleno==538);
      case 542: /* limit_clause_opt ::= */ yytestcase(yyruleno==542);
{ yymsp[1].minor.yy44 = NULL; }
        break;
      case 250: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 251: /* table_name_cond ::= table_name */
{ yylhsminor.yy44 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy455); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 253: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy44 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy455); }
        break;
      case 257: /* tag_item ::= TBNAME */
{ yylhsminor.yy44 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 260: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy44 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy455), &yymsp[0].minor.yy455); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 261: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy44 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy455), &yymsp[0].minor.yy455); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 262: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy163, yymsp[-3].minor.yy44, yymsp[-1].minor.yy44, NULL, yymsp[0].minor.yy44); }
        break;
      case 263: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy163, yymsp[-5].minor.yy44, yymsp[-3].minor.yy44, yymsp[-1].minor.yy684, NULL); }
        break;
      case 264: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy163, yymsp[0].minor.yy44); }
        break;
      case 265: /* full_index_name ::= index_name */
{ yylhsminor.yy44 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy455); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 266: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy44 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy455); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 267: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy44 = createIndexOption(pCxt, yymsp[-7].minor.yy684, releaseRawExprNode(pCxt, yymsp[-3].minor.yy44), NULL, yymsp[-1].minor.yy44, yymsp[0].minor.yy44); }
        break;
      case 268: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy44 = createIndexOption(pCxt, yymsp[-9].minor.yy684, releaseRawExprNode(pCxt, yymsp[-5].minor.yy44), releaseRawExprNode(pCxt, yymsp[-3].minor.yy44), yymsp[-1].minor.yy44, yymsp[0].minor.yy44); }
        break;
      case 271: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy44 = createFunctionNode(pCxt, &yymsp[-3].minor.yy455, yymsp[-1].minor.yy684); }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 277: /* sma_stream_opt ::= */
      case 311: /* stream_options ::= */ yytestcase(yyruleno==311);
{ yymsp[1].minor.yy44 = createStreamOptions(pCxt); }
        break;
      case 278: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 315: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==315);
{ ((SStreamOptions*)yymsp[-2].minor.yy44)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy44); yylhsminor.yy44 = yymsp[-2].minor.yy44; }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 279: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy44)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy44); yylhsminor.yy44 = yymsp[-2].minor.yy44; }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 280: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy44)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy44); yylhsminor.yy44 = yymsp[-2].minor.yy44; }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 281: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy163, &yymsp[-2].minor.yy455, yymsp[0].minor.yy44); }
        break;
      case 282: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy163, &yymsp[-3].minor.yy455, &yymsp[0].minor.yy455, false); }
        break;
      case 283: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy163, &yymsp[-5].minor.yy455, &yymsp[0].minor.yy455, true); }
        break;
      case 284: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy163, &yymsp[-3].minor.yy455, yymsp[0].minor.yy44, false); }
        break;
      case 285: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy163, &yymsp[-5].minor.yy455, yymsp[0].minor.yy44, true); }
        break;
      case 286: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy163, &yymsp[0].minor.yy455); }
        break;
      case 287: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy163, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy455); }
        break;
      case 288: /* cmd ::= DESC full_table_name */
      case 289: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==289);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy44); }
        break;
      case 290: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 291: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 292: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==292);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy163, yymsp[-1].minor.yy44, yymsp[0].minor.yy44); }
        break;
      case 295: /* explain_options ::= */
{ yymsp[1].minor.yy44 = createDefaultExplainOptions(pCxt); }
        break;
      case 296: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy44 = setExplainVerbose(pCxt, yymsp[-2].minor.yy44, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 297: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy44 = setExplainRatio(pCxt, yymsp[-2].minor.yy44, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 298: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy163, yymsp[-8].minor.yy163, &yymsp[-5].minor.yy455, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy260, yymsp[0].minor.yy832); }
        break;
      case 299: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy163, &yymsp[0].minor.yy455); }
        break;
      case 304: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy163, &yymsp[-8].minor.yy455, yymsp[-5].minor.yy44, yymsp[-7].minor.yy44, yymsp[-3].minor.yy684, yymsp[-2].minor.yy44, yymsp[0].minor.yy44, yymsp[-4].minor.yy684); }
        break;
      case 305: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy163, &yymsp[0].minor.yy455); }
        break;
      case 312: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy44)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy44 = yymsp[-2].minor.yy44; }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 313: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy44)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy44 = yymsp[-2].minor.yy44; }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 314: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy44)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy44)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy44); yylhsminor.yy44 = yymsp[-3].minor.yy44; }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 316: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy44)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy44 = yymsp[-3].minor.yy44; }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 317: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy44)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy44 = yymsp[-2].minor.yy44; }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 319: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 508: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==508);
      case 526: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==526);
{ yymsp[-3].minor.yy44 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy44); }
        break;
      case 320: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 321: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 322: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 323: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 324: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 325: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy684); }
        break;
      case 326: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 327: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy684 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 329: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy44, yymsp[0].minor.yy44); }
        break;
      case 332: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy44 = createInsertStmt(pCxt, yymsp[-4].minor.yy44, yymsp[-2].minor.yy684, yymsp[0].minor.yy44); }
        break;
      case 333: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy44 = createInsertStmt(pCxt, yymsp[-1].minor.yy44, NULL, yymsp[0].minor.yy44); }
        break;
      case 334: /* literal ::= NK_INTEGER */
{ yylhsminor.yy44 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 335: /* literal ::= NK_FLOAT */
{ yylhsminor.yy44 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 336: /* literal ::= NK_STRING */
{ yylhsminor.yy44 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 337: /* literal ::= NK_BOOL */
{ yylhsminor.yy44 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 338: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 339: /* literal ::= duration_literal */
      case 349: /* signed_literal ::= signed */ yytestcase(yyruleno==349);
      case 370: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==370);
      case 371: /* expression ::= literal */ yytestcase(yyruleno==371);
      case 372: /* expression ::= pseudo_column */ yytestcase(yyruleno==372);
      case 373: /* expression ::= column_reference */ yytestcase(yyruleno==373);
      case 374: /* expression ::= function_expression */ yytestcase(yyruleno==374);
      case 375: /* expression ::= case_when_expression */ yytestcase(yyruleno==375);
      case 406: /* function_expression ::= literal_func */ yytestcase(yyruleno==406);
      case 455: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==455);
      case 459: /* boolean_primary ::= predicate */ yytestcase(yyruleno==459);
      case 461: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==461);
      case 462: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==462);
      case 465: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==465);
      case 467: /* table_reference ::= table_primary */ yytestcase(yyruleno==467);
      case 468: /* table_reference ::= joined_table */ yytestcase(yyruleno==468);
      case 472: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==472);
      case 528: /* query_simple ::= query_specification */ yytestcase(yyruleno==528);
      case 529: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==529);
      case 532: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==532);
      case 534: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==534);
{ yylhsminor.yy44 = yymsp[0].minor.yy44; }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 340: /* literal ::= NULL */
{ yylhsminor.yy44 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 341: /* literal ::= NK_QUESTION */
{ yylhsminor.yy44 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 342: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy44 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 343: /* signed ::= NK_INTEGER */
{ yylhsminor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 344: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 345: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 346: /* signed ::= NK_FLOAT */
{ yylhsminor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 347: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 348: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 350: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 351: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 352: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 353: /* signed_literal ::= duration_literal */
      case 355: /* signed_literal ::= literal_func */ yytestcase(yyruleno==355);
      case 426: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==426);
      case 488: /* select_item ::= common_expression */ yytestcase(yyruleno==488);
      case 498: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==498);
      case 533: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==533);
      case 535: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==535);
      case 548: /* search_condition ::= common_expression */ yytestcase(yyruleno==548);
{ yylhsminor.yy44 = releaseRawExprNode(pCxt, yymsp[0].minor.yy44); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 354: /* signed_literal ::= NULL */
{ yylhsminor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 356: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy44 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 376: /* expression ::= NK_LP expression NK_RP */
      case 460: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==460);
      case 547: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==547);
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy44)); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 377: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy44));
                                                                                  }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 378: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy44), NULL));
                                                                                  }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 379: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44))); 
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 380: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44))); 
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 381: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44))); 
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 382: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44))); 
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 383: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44)));
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 384: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 385: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44)));
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 386: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44)));
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 389: /* column_reference ::= column_name */
{ yylhsminor.yy44 = createRawExprNode(pCxt, &yymsp[0].minor.yy455, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy455)); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 390: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy455, createColumnNode(pCxt, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy455)); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 391: /* pseudo_column ::= ROWTS */
      case 392: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==392);
      case 394: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==394);
      case 395: /* pseudo_column ::= QEND */ yytestcase(yyruleno==395);
      case 396: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==396);
      case 397: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==397);
      case 398: /* pseudo_column ::= WEND */ yytestcase(yyruleno==398);
      case 399: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==399);
      case 400: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==400);
      case 401: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==401);
      case 402: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==402);
      case 408: /* literal_func ::= NOW */ yytestcase(yyruleno==408);
{ yylhsminor.yy44 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 393: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy455)))); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 403: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 404: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==404);
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy455, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy455, yymsp[-1].minor.yy684)); }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 405: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy44), yymsp[-1].minor.yy260)); }
  yymsp[-5].minor.yy44 = yylhsminor.yy44;
        break;
      case 407: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy455, NULL)); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 422: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy684 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy684 = yylhsminor.yy684;
        break;
      case 427: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 491: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==491);
{ yylhsminor.yy44 = createColumnNode(pCxt, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 428: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy684, yymsp[-1].minor.yy44)); }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 429: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy44), yymsp[-2].minor.yy684, yymsp[-1].minor.yy44)); }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 432: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy44 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44)); }
        break;
      case 434: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy44 = releaseRawExprNode(pCxt, yymsp[0].minor.yy44); }
        break;
      case 435: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 440: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==440);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy704, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44)));
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 436: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy44), releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44)));
                                                                                  }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 437: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy44), releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44)));
                                                                                  }
  yymsp[-5].minor.yy44 = yylhsminor.yy44;
        break;
      case 438: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), NULL));
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 439: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy44), NULL));
                                                                                  }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 441: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy704 = OP_TYPE_LOWER_THAN; }
        break;
      case 442: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy704 = OP_TYPE_GREATER_THAN; }
        break;
      case 443: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy704 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 444: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy704 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 445: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy704 = OP_TYPE_NOT_EQUAL; }
        break;
      case 446: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy704 = OP_TYPE_EQUAL; }
        break;
      case 447: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy704 = OP_TYPE_LIKE; }
        break;
      case 448: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy704 = OP_TYPE_NOT_LIKE; }
        break;
      case 449: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy704 = OP_TYPE_MATCH; }
        break;
      case 450: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy704 = OP_TYPE_NMATCH; }
        break;
      case 451: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy704 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 452: /* in_op ::= IN */
{ yymsp[0].minor.yy704 = OP_TYPE_IN; }
        break;
      case 453: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy704 = OP_TYPE_NOT_IN; }
        break;
      case 454: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy684)); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 456: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy44), NULL));
                                                                                  }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 457: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44)));
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 458: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44)));
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 464: /* from_clause_opt ::= FROM table_reference_list */
      case 493: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==493);
      case 522: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==522);
{ yymsp[-1].minor.yy44 = yymsp[0].minor.yy44; }
        break;
      case 466: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy44 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy44, yymsp[0].minor.yy44, NULL); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 469: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy44 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy455, &yymsp[0].minor.yy455); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 470: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy44 = createRealTableNode(pCxt, &yymsp[-3].minor.yy455, &yymsp[-1].minor.yy455, &yymsp[0].minor.yy455); }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 471: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy44 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy44), &yymsp[0].minor.yy455); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 473: /* alias_opt ::= */
{ yymsp[1].minor.yy455 = nil_token;  }
        break;
      case 475: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy455 = yymsp[0].minor.yy455; }
        break;
      case 476: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 477: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==477);
{ yymsp[-2].minor.yy44 = yymsp[-1].minor.yy44; }
        break;
      case 478: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy44 = createJoinTableNode(pCxt, yymsp[-4].minor.yy724, yymsp[-5].minor.yy44, yymsp[-2].minor.yy44, yymsp[0].minor.yy44); }
  yymsp[-5].minor.yy44 = yylhsminor.yy44;
        break;
      case 479: /* join_type ::= */
{ yymsp[1].minor.yy724 = JOIN_TYPE_INNER; }
        break;
      case 480: /* join_type ::= INNER */
{ yymsp[0].minor.yy724 = JOIN_TYPE_INNER; }
        break;
      case 481: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy44 = createSelectStmt(pCxt, yymsp[-10].minor.yy163, yymsp[-9].minor.yy684, yymsp[-8].minor.yy44);
                                                                                    yymsp[-11].minor.yy44 = addWhereClause(pCxt, yymsp[-11].minor.yy44, yymsp[-7].minor.yy44);
                                                                                    yymsp[-11].minor.yy44 = addPartitionByClause(pCxt, yymsp[-11].minor.yy44, yymsp[-6].minor.yy684);
                                                                                    yymsp[-11].minor.yy44 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy44, yymsp[-2].minor.yy44);
                                                                                    yymsp[-11].minor.yy44 = addGroupByClause(pCxt, yymsp[-11].minor.yy44, yymsp[-1].minor.yy684);
                                                                                    yymsp[-11].minor.yy44 = addHavingClause(pCxt, yymsp[-11].minor.yy44, yymsp[0].minor.yy44);
                                                                                    yymsp[-11].minor.yy44 = addRangeClause(pCxt, yymsp[-11].minor.yy44, yymsp[-5].minor.yy44);
                                                                                    yymsp[-11].minor.yy44 = addEveryClause(pCxt, yymsp[-11].minor.yy44, yymsp[-4].minor.yy44);
                                                                                    yymsp[-11].minor.yy44 = addFillClause(pCxt, yymsp[-11].minor.yy44, yymsp[-3].minor.yy44);
                                                                                  }
        break;
      case 484: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy163 = false; }
        break;
      case 487: /* select_item ::= NK_STAR */
{ yylhsminor.yy44 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 489: /* select_item ::= common_expression column_alias */
      case 499: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==499);
{ yylhsminor.yy44 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy44), &yymsp[0].minor.yy455); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 490: /* select_item ::= common_expression AS column_alias */
      case 500: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==500);
{ yylhsminor.yy44 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), &yymsp[0].minor.yy455); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 495: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 518: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==518);
      case 537: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==537);
{ yymsp[-2].minor.yy684 = yymsp[0].minor.yy684; }
        break;
      case 502: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy44 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy44), releaseRawExprNode(pCxt, yymsp[-1].minor.yy44)); }
        break;
      case 503: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy44 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy44)); }
        break;
      case 504: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy44 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy44), NULL, yymsp[-1].minor.yy44, yymsp[0].minor.yy44); }
        break;
      case 505: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy44 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy44), releaseRawExprNode(pCxt, yymsp[-3].minor.yy44), yymsp[-1].minor.yy44, yymsp[0].minor.yy44); }
        break;
      case 506: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy44 = createEventWindowNode(pCxt, yymsp[-3].minor.yy44, yymsp[0].minor.yy44); }
        break;
      case 510: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy44 = createFillNode(pCxt, yymsp[-1].minor.yy22, NULL); }
        break;
      case 511: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy44 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy684)); }
        break;
      case 512: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy22 = FILL_MODE_NONE; }
        break;
      case 513: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy22 = FILL_MODE_PREV; }
        break;
      case 514: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy22 = FILL_MODE_NULL; }
        break;
      case 515: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy22 = FILL_MODE_LINEAR; }
        break;
      case 516: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy22 = FILL_MODE_NEXT; }
        break;
      case 519: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy684 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy44))); }
  yymsp[0].minor.yy684 = yylhsminor.yy684;
        break;
      case 520: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy684 = addNodeToList(pCxt, yymsp[-2].minor.yy684, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy44))); }
  yymsp[-2].minor.yy684 = yylhsminor.yy684;
        break;
      case 524: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy44 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy44), releaseRawExprNode(pCxt, yymsp[-1].minor.yy44)); }
        break;
      case 527: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy44 = addOrderByClause(pCxt, yymsp[-3].minor.yy44, yymsp[-2].minor.yy684);
                                                                                    yylhsminor.yy44 = addSlimitClause(pCxt, yylhsminor.yy44, yymsp[-1].minor.yy44);
                                                                                    yylhsminor.yy44 = addLimitClause(pCxt, yylhsminor.yy44, yymsp[0].minor.yy44);
                                                                                  }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 530: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy44 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy44, yymsp[0].minor.yy44); }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 531: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy44 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy44, yymsp[0].minor.yy44); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 539: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 543: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==543);
{ yymsp[-1].minor.yy44 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 540: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 544: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==544);
{ yymsp[-3].minor.yy44 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 541: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 545: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==545);
{ yymsp[-3].minor.yy44 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 546: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy44); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 551: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy44 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), yymsp[-1].minor.yy490, yymsp[0].minor.yy23); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 552: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy490 = ORDER_ASC; }
        break;
      case 553: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy490 = ORDER_ASC; }
        break;
      case 554: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy490 = ORDER_DESC; }
        break;
      case 555: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy23 = NULL_ORDER_DEFAULT; }
        break;
      case 556: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy23 = NULL_ORDER_FIRST; }
        break;
      case 557: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy23 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
