/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 358
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy14;
  ENullOrder yy17;
  SNodeList* yy60;
  SToken yy105;
  int32_t yy140;
  SNode* yy172;
  EFillMode yy202;
  SDataType yy248;
  EOperatorType yy572;
  int64_t yy593;
  SAlterOption yy609;
  bool yy617;
  EJoinType yy636;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             605
#define YYNRULE              452
#define YYNTOKEN             238
#define YY_MAX_SHIFT         604
#define YY_MIN_SHIFTREDUCE   893
#define YY_MAX_SHIFTREDUCE   1344
#define YY_ERROR_ACTION      1345
#define YY_ACCEPT_ACTION     1346
#define YY_NO_ACTION         1347
#define YY_MIN_REDUCE        1348
#define YY_MAX_REDUCE        1799
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2154)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1467, 1777, 1777, 1646,  383, 1634,  384, 1380,  292,   11,
 /*    10 */    10,  343,   35,   33, 1776,  146,   24,  923, 1774, 1774,
 /*    20 */   301,  391, 1159,  384, 1380, 1631,   36,   34,   32,   31,
 /*    30 */    30, 1662,   26,   36,   34,   32,   31,   30,  518,  503,
 /*    40 */  1627, 1633,   36,   34,   32,   31,   30, 1157, 1346,  502,
 /*    50 */  1777,  522,  130, 1617, 1360,  927,  928,  518,   14,  483,
 /*    60 */    35,   33, 1285,  145, 1165,   28,  223, 1774,  301, 1675,
 /*    70 */  1159,  349,   80, 1647,  505, 1649, 1650,  501,   77,  522,
 /*    80 */     1,   62, 1715, 1777, 1181,  519,  273, 1711,  518, 1261,
 /*    90 */  1634,  113,  398,  309,  108, 1157, 1775,  104, 1777, 1470,
 /*   100 */  1774, 1646,  601, 1473,  419,  271,   14,  317,   35,   33,
 /*   110 */  1631,  147, 1165, 1158, 1478, 1774,  301,   38, 1159,   36,
 /*   120 */    34,   32,   31,   30,  388, 1627, 1633,   56,    2, 1662,
 /*   130 */  1181,   36,   34,   32,   31,   30,  522,  503,   36,   34,
 /*   140 */    32,   31,   30, 1157,   55, 1523, 1777,  502,   39,  131,
 /*   150 */   601, 1617,  291, 1435,   14, 1371, 1160, 1521, 1662,  145,
 /*   160 */  1165, 1158,  559, 1774, 1450,  274,  472, 1675,  140, 1341,
 /*   170 */   132, 1647,  505, 1649, 1650,  501,    2,  522, 1163, 1164,
 /*   180 */  1517, 1209, 1210, 1212, 1213, 1214, 1215, 1216,  498,  520,
 /*   190 */  1224, 1225, 1226, 1227, 1228, 1229, 1247, 1410,  601,  519,
 /*   200 */  1299,  471, 1183,   55, 1160, 1617, 1456, 1196,  148, 1158,
 /*   210 */   473,  347,  447,   94,  484, 1791,   93,   92,   91,   90,
 /*   220 */    89,   88,   87,   86,   85, 1729, 1163, 1164, 1478, 1209,
 /*   230 */  1210, 1212, 1213, 1214, 1215, 1216,  498,  520, 1224, 1225,
 /*   240 */  1226, 1227, 1228, 1229, 1454,  148, 1248,  479, 1523, 1726,
 /*   250 */  1340, 1777, 1160,  597,  596,  306, 1309,  433,  432,   55,
 /*   260 */  1521, 1523,  431,  398,  145,  109,  428, 1253, 1774,  427,
 /*   270 */   426,  425,  148, 1522, 1163, 1164,  112, 1209, 1210, 1212,
 /*   280 */  1213, 1214, 1215, 1216,  498,  520, 1224, 1225, 1226, 1227,
 /*   290 */  1228, 1229,   35,   33, 1349,  465, 1307, 1308, 1310, 1311,
 /*   300 */   301,  556, 1159,   27,  299, 1242, 1243, 1244, 1245, 1246,
 /*   310 */  1250, 1251, 1252,  110,  939,   94,   62, 1469,   93,   92,
 /*   320 */    91,   90,   89,   88,   87,   86,   85, 1157,  143, 1722,
 /*   330 */  1723,  148, 1727,  519, 1184,  519,  479, 1631, 1474,  417,
 /*   340 */    35,   33, 1230,  506, 1165,  348,  304,  104,  301, 1568,
 /*   350 */  1159,   55, 1627, 1633,  424,   36,   34,   32,   31,   30,
 /*   360 */     8,  479, 1478,  522, 1478,  112,   36,   34,   32,   31,
 /*   370 */    30, 1556,  433,  432, 1635, 1157,  154,  431,  156, 1646,
 /*   380 */   109,  428,  601,  519,  427,  426,  425,  148,   35,   33,
 /*   390 */   112,  556, 1165, 1158, 1631,  358,  301,  305, 1159, 1523,
 /*   400 */    60,  274,  110,   59, 1182,  128,  312, 1662,    9, 1627,
 /*   410 */  1633, 1521, 1478, 1185, 1480,  503,  481,  142, 1722, 1723,
 /*   420 */   522, 1727,  468, 1157, 1196,  502,  342,  110,  341, 1617,
 /*   430 */   601,  313, 1247,   64,  289, 1397, 1160,  188, 1559, 1561,
 /*   440 */  1165, 1158,  144, 1722, 1723, 1675, 1727,  548,  263, 1647,
 /*   450 */   505, 1649, 1650,  501, 1370,  522,    9,  434, 1163, 1164,
 /*   460 */   334, 1209, 1210, 1212, 1213, 1214, 1215, 1216,  498,  520,
 /*   470 */  1224, 1225, 1226, 1227, 1228, 1229,  283,  311,  601,  148,
 /*   480 */   336,  332, 1248, 1120, 1160,  128,  475,  455,  148, 1158,
 /*   490 */   373, 1122,  474,  469, 1480, 1463,  519,   36,   34,   32,
 /*   500 */    31,   30, 1369, 1253, 1617, 1465, 1163, 1164,  359, 1209,
 /*   510 */  1210, 1212, 1213, 1214, 1215, 1216,  498,  520, 1224, 1225,
 /*   520 */  1226, 1227, 1228, 1229,  284, 1478,  282,  281, 1368,  421,
 /*   530 */   558, 1292, 1160,  423,  158,  157,  456, 1183,  214,   27,
 /*   540 */   299, 1242, 1243, 1244, 1245, 1246, 1250, 1251, 1252, 1646,
 /*   550 */   382, 1121, 1617,  386, 1163, 1164,  422, 1209, 1210, 1212,
 /*   560 */  1213, 1214, 1215, 1216,  498,  520, 1224, 1225, 1226, 1227,
 /*   570 */  1228, 1229,   35,   33,  270, 1777, 1181, 1662, 1617,  519,
 /*   580 */   301,  314, 1159,  366, 1249,  482,  378, 1461,  145,  128,
 /*   590 */   554,  397, 1774,  390,  423,  502,  386, 1235, 1480, 1617,
 /*   600 */   940,   54,  939, 1183,  379, 1254,   70, 1157, 1478,  553,
 /*   610 */   552, 1367,  551,  550,  549, 1675, 1366,  422,   81, 1647,
 /*   620 */   505, 1649, 1650,  501, 1165,  522, 1365, 1471, 1715,  941,
 /*   630 */   127, 1186,  294, 1711,  141, 1407,   32,   31,   30,  191,
 /*   640 */     2,   25, 1029,  545,  544,  543, 1033,  542, 1035, 1036,
 /*   650 */   541, 1038,  538, 1743, 1044,  535, 1046, 1047,  532,  529,
 /*   660 */   497, 1617,  601, 1364, 1363, 1362, 1617, 1359, 1358, 1357,
 /*   670 */  1356, 1355, 1354, 1158,  377, 1353, 1617,  372,  371,  370,
 /*   680 */   369,  368,  365,  364,  363,  362,  361,  357,  356,  355,
 /*   690 */   354,  353,  352,  351,  350,  577,  576,  575,  316, 1211,
 /*   700 */   574,  573,  572,  114,  567,  566,  565,  564,  563,  562,
 /*   710 */   561,  560,  121, 1617, 1617, 1617, 1160, 1617, 1617, 1617,
 /*   720 */  1617, 1617, 1617, 1352,    7, 1617,  128, 1351,  430,  429,
 /*   730 */  1646,  571,  569, 1560, 1561, 1481,  927,  928, 1163, 1164,
 /*   740 */  1729, 1209, 1210, 1212, 1213, 1214, 1215, 1216,  498,  520,
 /*   750 */  1224, 1225, 1226, 1227, 1228, 1229,  199,  129, 1662,  519,
 /*   760 */  1284, 1646,  252, 1729, 1725, 1211,  503,  991, 1159,  519,
 /*   770 */  1183, 1475, 1606, 1617,  250,   53,  502, 1617,   52,  506,
 /*   780 */  1617, 1597, 1734, 1280,  993, 1569,  483, 1724, 1478, 1662,
 /*   790 */  1144, 1145,  487, 1157,  479,  159, 1675,  482, 1478,   80,
 /*   800 */  1647,  505, 1649, 1650,  501,  246,  522,  502, 1508, 1715,
 /*   810 */  1165, 1617,  519,  273, 1711,  570,  454,  324,  179,   55,
 /*   820 */  1168,  177,  485,  112,  516, 1777,  181, 1675,  490,  180,
 /*   830 */    81, 1647,  505, 1649, 1650,  501, 1637,  522,  145,  519,
 /*   840 */  1715, 1478, 1774,  483,  294, 1711,  141,  183,  601,  185,
 /*   850 */   182,  517,  184,  445,  495,  337,   79, 1646,  215, 1158,
 /*   860 */   110,  519,  519,  547,  461, 1742,  443,  964, 1478,   47,
 /*   870 */   272,  118, 1639,  236,  315,  212, 1722,  478, 1392,  477,
 /*   880 */    11,   10, 1777, 1390,  965, 1662, 1171,   58,   57,  346,
 /*   890 */  1478, 1478,  153,  503, 1280,  147, 1361,  340,   46, 1774,
 /*   900 */   436, 1167, 1160,  502,  202,  439,   37, 1617, 1436,  269,
 /*   910 */    37,  457,  330,   37,  326,  322,  150,  225, 1343, 1344,
 /*   920 */  1646, 1455,  116, 1675, 1163, 1164,   81, 1647,  505, 1649,
 /*   930 */  1650,  501, 1211,  522,  218,  117, 1715,  466, 1306,   76,
 /*   940 */   294, 1711, 1790,  448,  204,  118, 1255,  148, 1662,   72,
 /*   950 */  1217, 1749, 1663, 1115, 1381,   46,  503,  227,  527,  209,
 /*   960 */   416,  174,  511,  480, 1518, 1283,  502, 1170, 1745,  217,
 /*   970 */  1617,  117, 1646,  139, 1239,  233,  220,  488,  222,  415,
 /*   980 */   411,  407,  403,  173,  118, 1022, 1675,  119,  117,   81,
 /*   990 */  1647,  505, 1649, 1650,  501,  245,  522, 1453, 1050, 1715,
 /*  1000 */  1662,    3, 1181,  294, 1711, 1790,  319,   63,  503,  323,
 /*  1010 */   171, 1054,  991,  554, 1772,  491,  280,  279,  502,  241,
 /*  1020 */  1128,  155, 1617,  360, 1061, 1558,  367, 1059,  120,  375,
 /*  1030 */   374, 1646,  553,  552,  380,  551,  550,  549, 1675, 1187,
 /*  1040 */   376,   81, 1647,  505, 1649, 1650,  501,  438,  522,  381,
 /*  1050 */   389, 1715, 1190,  162,  392,  294, 1711, 1790,  393, 1662,
 /*  1060 */  1189,  164,  446,  394,  166,  395, 1733,  503,  170, 1188,
 /*  1070 */   165,  396,  167,  399,  169,   61,  187,  502,  418,  172,
 /*  1080 */  1165, 1617, 1646,  420, 1468,  176, 1464,  483,  441,  554,
 /*  1090 */    84,  242,  163,  435,  288, 1601,  178, 1675,  186, 1646,
 /*  1100 */   259, 1647,  505, 1649, 1650,  501,  122,  522,  553,  552,
 /*  1110 */  1662,  551,  550,  549,  123, 1466, 1462,  124,  503,  125,
 /*  1120 */   449,  189,   51,  453,  450,   50, 1777, 1662,  502,  243,
 /*  1130 */   458,  192, 1617,  194, 1186,  503,  197,  459,  483,  147,
 /*  1140 */  1746,  467,  509, 1774, 1756,  502,    6,  200, 1675, 1617,
 /*  1150 */   463,  259, 1647,  505, 1649, 1650,  501, 1646,  522,  464,
 /*  1160 */   476,    5, 1736,  203, 1755, 1675,  293,  210,   82, 1647,
 /*  1170 */   505, 1649, 1650,  501, 1280,  522,  111, 1777, 1715,  470,
 /*  1180 */   208, 1185, 1714, 1711, 1348, 1662,   40,  211,  492, 1646,
 /*  1190 */   145, 1773,  135,  503, 1774, 1730,  295,  489,   18, 1567,
 /*  1200 */  1793,  507,  508,  502, 1566,  512,  303, 1617,  103,  102,
 /*  1210 */   101,  100,   99,   98,   97,   96,   95, 1662,  216,  479,
 /*  1220 */  1696,  513,  229, 1675,  219,  500,   82, 1647,  505, 1649,
 /*  1230 */  1650,  501,  514,  522,  231,  502, 1715,   69,  486, 1617,
 /*  1240 */   494, 1711, 1646,  493,  221,  244, 1479,   71,  112,  525,
 /*  1250 */  1451,  247,  600,  238,   48, 1675,  134,  253,  267, 1647,
 /*  1260 */   505, 1649, 1650,  501,  499,  522,  496, 1687,  483,  290,
 /*  1270 */  1662,  260,  249,  254,  251, 1611, 1610,  318,  503, 1607,
 /*  1280 */   320,  321, 1153, 1154,  151,  110,  325, 1605,  502,  327,
 /*  1290 */   328,  329, 1617, 1604,  331, 1603,  333, 1602,  335, 1646,
 /*  1300 */   212, 1722,  478, 1587,  477,  152,  339, 1777, 1675,  338,
 /*  1310 */  1131,   82, 1647,  505, 1649, 1650,  501, 1581,  522, 1130,
 /*  1320 */   145, 1715, 1580,  344, 1774,  345, 1712, 1662,  604, 1579,
 /*  1330 */  1578, 1551, 1098, 1550, 1549,  503, 1548, 1547, 1546, 1545,
 /*  1340 */  1544, 1543,  240, 1100,  115,  502, 1646, 1542, 1541, 1617,
 /*  1350 */  1540, 1539,  462, 1538,  105, 1537, 1536, 1535, 1534, 1533,
 /*  1360 */   593,  589,  585,  581,  239, 1675, 1532, 1531,  268, 1647,
 /*  1370 */   505, 1649, 1650,  501, 1662,  522, 1530, 1529, 1528, 1527,
 /*  1380 */  1526, 1525,  503, 1524, 1409, 1646, 1377,  138,   78,  160,
 /*  1390 */  1376,  234,  502, 1595, 1589, 1573, 1617,  106,  385,  930,
 /*  1400 */   161,  929,  107, 1564, 1457,  387,  168, 1408, 1406,  401,
 /*  1410 */   400,  958, 1675, 1662, 1404,  132, 1647,  505, 1649, 1650,
 /*  1420 */   501,  503,  522, 1402, 1400,  515,  402, 1389,  406,  404,
 /*  1430 */  1388,  502,  175,  405,  410, 1617, 1646,  414,  298,  408,
 /*  1440 */  1375,  409, 1459, 1458,  413,  412, 1398, 1064, 1065,  990,
 /*  1450 */   460, 1675,  989,  195,  268, 1647,  505, 1649, 1650,  501,
 /*  1460 */  1792,  522,   45,  988, 1662, 1646,  987,  568, 1393,  570,
 /*  1470 */   285, 1136,  500,  190,  286, 1391,  984,  287,  983, 1374,
 /*  1480 */   982,  440,  502,  437,  442, 1373, 1617,  444, 1594,   83,
 /*  1490 */  1588, 1138,  451, 1662, 1572, 1571,  126, 1646, 1563,    4,
 /*  1500 */    65,  503, 1675,  196,   37,  267, 1647,  505, 1649, 1650,
 /*  1510 */   501,  502,  522,   49, 1688, 1617,  452,  193,  300,   15,
 /*  1520 */   201,   43, 1305,  206,   41, 1662, 1298,  133,  207,  205,
 /*  1530 */    22, 1675,   23,  503,  268, 1647,  505, 1649, 1650,  501,
 /*  1540 */  1637,  522, 1277,  502,   66,  213,  198, 1617, 1276,   42,
 /*  1550 */   302,  136, 1334, 1646,   16,   17,   13, 1323, 1329,   10,
 /*  1560 */  1328,   19,  296, 1675, 1333, 1332,  268, 1647,  505, 1649,
 /*  1570 */  1650,  501,  297,  522, 1219,  137,  149,   29, 1204,  510,
 /*  1580 */  1218, 1662,   12,   20, 1646,   21,  226, 1240, 1562,  503,
 /*  1590 */   504,  224,  230,  232,   72, 1636,  235, 1303, 1175,  502,
 /*  1600 */  1221,  228,   67, 1617,   68,  526, 1678,  521,   44,  310,
 /*  1610 */  1051, 1048, 1662, 1646,  524,  528,  530,  531,  533, 1675,
 /*  1620 */   503, 1045,  255, 1647,  505, 1649, 1650,  501,  534,  522,
 /*  1630 */   502, 1039,  536,  537, 1617, 1037,  539, 1043, 1042,  540,
 /*  1640 */  1041, 1662, 1040, 1028,   73,   74, 1060,   75, 1057,  503,
 /*  1650 */  1675, 1056,  546,  262, 1647,  505, 1649, 1650,  501,  502,
 /*  1660 */   522,  956, 1646, 1617,  555,  557,  237,  997,  308,  307,
 /*  1670 */   978,  977,  973, 1646, 1058,  976,  994,  975, 1173, 1675,
 /*  1680 */   974,  972,  264, 1647,  505, 1649, 1650,  501,  971,  522,
 /*  1690 */  1662,  992,  968,  967,  966,  963,  962, 1405,  503,  961,
 /*  1700 */   578, 1662,  579, 1166,  580, 1403,  582,  583,  502,  503,
 /*  1710 */   584, 1401, 1617,  586,  587,  588, 1399,  590,  592,  502,
 /*  1720 */  1165,  591, 1387, 1617, 1646, 1386,  594, 1372, 1675,  595,
 /*  1730 */   598,  256, 1647,  505, 1649, 1650,  501, 1161,  522, 1675,
 /*  1740 */   599,  603,  265, 1647,  505, 1649, 1650,  501,  248,  522,
 /*  1750 */   602, 1347, 1662, 1646, 1347, 1347, 1347, 1347,  523, 1347,
 /*  1760 */   503, 1347, 1347, 1347, 1347, 1347, 1347, 1347, 1347, 1169,
 /*  1770 */   502, 1347, 1347, 1347, 1617, 1347, 1347, 1347, 1347, 1347,
 /*  1780 */  1347, 1662, 1347, 1347, 1347, 1646, 1347, 1347, 1347,  503,
 /*  1790 */  1675, 1347, 1347,  257, 1647,  505, 1649, 1650,  501,  502,
 /*  1800 */   522, 1347, 1347, 1617, 1347, 1347, 1347, 1347, 1347, 1347,
 /*  1810 */  1347, 1347, 1174, 1662, 1347, 1347, 1347, 1347, 1347, 1675,
 /*  1820 */  1347,  503,  266, 1647,  505, 1649, 1650,  501, 1347,  522,
 /*  1830 */  1347,  502, 1347, 1347, 1177, 1617, 1347, 1347, 1347, 1347,
 /*  1840 */  1347, 1646, 1347, 1347, 1347,  520, 1224, 1225, 1347, 1347,
 /*  1850 */  1347, 1675, 1347, 1347,  258, 1647,  505, 1649, 1650,  501,
 /*  1860 */  1347,  522, 1347, 1347, 1347, 1347, 1347, 1347, 1347, 1662,
 /*  1870 */  1347, 1347, 1646, 1347, 1347, 1347, 1347,  503, 1347, 1347,
 /*  1880 */  1347, 1347, 1347, 1347, 1347, 1347, 1347,  502, 1347, 1347,
 /*  1890 */  1347, 1617, 1347, 1347, 1347, 1347, 1347, 1347, 1347, 1347,
 /*  1900 */  1662, 1646, 1347, 1347, 1347, 1347, 1347, 1675,  503, 1347,
 /*  1910 */  1658, 1647,  505, 1649, 1650,  501, 1347,  522,  502, 1347,
 /*  1920 */  1347, 1347, 1617, 1347, 1347, 1347, 1347, 1347, 1347, 1662,
 /*  1930 */  1347, 1347, 1646, 1347, 1347, 1347, 1347,  503, 1675, 1347,
 /*  1940 */  1347, 1657, 1647,  505, 1649, 1650,  501,  502,  522, 1347,
 /*  1950 */  1347, 1617, 1347, 1347, 1347, 1347, 1347, 1347, 1347, 1347,
 /*  1960 */  1662, 1646, 1347, 1347, 1347, 1347, 1347, 1675,  503, 1347,
 /*  1970 */  1656, 1647,  505, 1649, 1650,  501, 1347,  522,  502, 1347,
 /*  1980 */  1347, 1347, 1617, 1347, 1347, 1347, 1347, 1347, 1347, 1662,
 /*  1990 */  1347, 1347, 1347, 1347, 1347, 1347, 1347,  503, 1675, 1347,
 /*  2000 */  1347,  277, 1647,  505, 1649, 1650,  501,  502,  522, 1347,
 /*  2010 */  1347, 1617, 1646, 1347, 1347, 1347, 1347, 1347, 1347, 1347,
 /*  2020 */  1347, 1347, 1347, 1646, 1347, 1347, 1347, 1675, 1347, 1347,
 /*  2030 */   276, 1647,  505, 1649, 1650,  501, 1347,  522, 1347, 1347,
 /*  2040 */  1662, 1347, 1347, 1347, 1347, 1347, 1347, 1347,  503, 1347,
 /*  2050 */  1347, 1662, 1347, 1347, 1347, 1347, 1347, 1347,  502,  503,
 /*  2060 */  1347, 1347, 1617, 1347, 1347, 1347, 1347, 1347, 1347,  502,
 /*  2070 */  1347, 1347, 1347, 1617, 1347, 1347, 1347, 1646, 1675, 1347,
 /*  2080 */  1347,  278, 1647,  505, 1649, 1650,  501, 1347,  522, 1675,
 /*  2090 */  1347, 1347,  275, 1647,  505, 1649, 1650,  501, 1347,  522,
 /*  2100 */  1347, 1347, 1347, 1347, 1347, 1662, 1347, 1347, 1347, 1347,
 /*  2110 */  1347, 1347, 1347,  503, 1347, 1347, 1347, 1347, 1347, 1347,
 /*  2120 */  1347, 1347, 1347,  502, 1347, 1347, 1347, 1617, 1347, 1347,
 /*  2130 */  1347, 1347, 1347, 1347, 1347, 1347, 1347, 1347, 1347, 1347,
 /*  2140 */  1347, 1347, 1347, 1675, 1347, 1347,  261, 1647,  505, 1649,
 /*  2150 */  1650,  501, 1347,  522,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   270,  336,  336,  241,  244,  271,  246,  247,  274,    1,
 /*    10 */     2,  297,   12,   13,  349,  349,    2,    4,  353,  353,
 /*    20 */    20,  244,   22,  246,  247,  291,   12,   13,   14,   15,
 /*    30 */    16,  269,    2,   12,   13,   14,   15,   16,   20,  277,
 /*    40 */   306,  307,   12,   13,   14,   15,   16,   47,  238,  287,
 /*    50 */   336,  317,  240,  291,  242,   42,   43,   20,   58,  297,
 /*    60 */    12,   13,   14,  349,   64,  321,  322,  353,   20,  307,
 /*    70 */    22,  248,  310,  311,  312,  313,  314,  315,  251,  317,
 /*    80 */    80,  253,  320,  336,   20,  248,  324,  325,   20,   81,
 /*    90 */   271,  264,   57,  274,  266,   47,  349,  260,  336,  272,
 /*   100 */   353,  241,  102,  275,  267,  282,   58,  297,   12,   13,
 /*   110 */   291,  349,   64,  113,  277,  353,   20,   80,   22,   12,
 /*   120 */    13,   14,   15,   16,   14,  306,  307,    4,   80,  269,
 /*   130 */    20,   12,   13,   14,   15,   16,  317,  277,   12,   13,
 /*   140 */    14,   15,   16,   47,   80,  269,  336,  287,   80,  254,
 /*   150 */   102,  291,  276,  258,   58,  241,  156,  281,  269,  349,
 /*   160 */    64,  113,  257,  353,  259,   58,  277,  307,  268,  148,
 /*   170 */   310,  311,  312,  313,  314,  315,   80,  317,  178,  179,
 /*   180 */   280,  181,  182,  183,  184,  185,  186,  187,  188,  189,
 /*   190 */   190,  191,  192,  193,  194,  195,   89,    0,  102,  248,
 /*   200 */    81,  312,   20,   80,  156,  291,    0,   81,  208,  113,
 /*   210 */    20,  260,  297,   21,  354,  355,   24,   25,   26,   27,
 /*   220 */    28,   29,   30,   31,   32,  308,  178,  179,  277,  181,
 /*   230 */   182,  183,  184,  185,  186,  187,  188,  189,  190,  191,
 /*   240 */   192,  193,  194,  195,    0,  208,  139,  248,  269,  332,
 /*   250 */   229,  336,  156,  249,  250,  276,  178,   60,   61,   80,
 /*   260 */   281,  269,   65,   57,  349,   68,   69,  160,  353,   72,
 /*   270 */    73,   74,  208,  281,  178,  179,  277,  181,  182,  183,
 /*   280 */   184,  185,  186,  187,  188,  189,  190,  191,  192,  193,
 /*   290 */   194,  195,   12,   13,    0,  217,  218,  219,  220,  221,
 /*   300 */    20,   57,   22,  196,  197,  198,  199,  200,  201,  202,
 /*   310 */   203,  204,  205,  314,   22,   21,  253,  271,   24,   25,
 /*   320 */    26,   27,   28,   29,   30,   31,   32,   47,  329,  330,
 /*   330 */   331,  208,  333,  248,   20,  248,  248,  291,  275,   47,
 /*   340 */    12,   13,   14,  287,   64,  260,  290,  260,   20,  293,
 /*   350 */    22,   80,  306,  307,  267,   12,   13,   14,   15,   16,
 /*   360 */    80,  248,  277,  317,  277,  277,   12,   13,   14,   15,
 /*   370 */    16,  277,   60,   61,  271,   47,   55,   65,  284,  241,
 /*   380 */    68,   69,  102,  248,   72,   73,   74,  208,   12,   13,
 /*   390 */   277,   57,   64,  113,  291,  260,   20,  261,   22,  269,
 /*   400 */    79,   58,  314,   82,   20,  269,  276,  269,   80,  306,
 /*   410 */   307,  281,  277,   20,  278,  277,  328,  329,  330,  331,
 /*   420 */   317,  333,  143,   47,   81,  287,  155,  314,  157,  291,
 /*   430 */   102,  279,   89,  165,  166,    0,  156,  169,  286,  287,
 /*   440 */    64,  113,  329,  330,  331,  307,  333,   91,  310,  311,
 /*   450 */   312,  313,  314,  315,  241,  317,   80,   22,  178,  179,
 /*   460 */   151,  181,  182,  183,  184,  185,  186,  187,  188,  189,
 /*   470 */   190,  191,  192,  193,  194,  195,   35,  261,  102,  208,
 /*   480 */   171,  172,  139,   79,  156,  269,  348,  248,  208,  113,
 /*   490 */    75,   87,  213,  214,  278,  270,  248,   12,   13,   14,
 /*   500 */    15,   16,  241,  160,  291,  270,  178,  179,  260,  181,
 /*   510 */   182,  183,  184,  185,  186,  187,  188,  189,  190,  191,
 /*   520 */   192,  193,  194,  195,   83,  277,   85,   86,  241,   88,
 /*   530 */    64,   14,  156,   92,  119,  120,  297,   20,  145,  196,
 /*   540 */   197,  198,  199,  200,  201,  202,  203,  204,  205,  241,
 /*   550 */   245,  147,  291,  248,  178,  179,  115,  181,  182,  183,
 /*   560 */   184,  185,  186,  187,  188,  189,  190,  191,  192,  193,
 /*   570 */   194,  195,   12,   13,   18,  336,   20,  269,  291,  248,
 /*   580 */    20,  261,   22,   27,  139,  277,   30,  270,  349,  269,
 /*   590 */    92,  260,  353,  245,   92,  287,  248,   14,  278,  291,
 /*   600 */    20,    3,   22,   20,   48,  160,  251,   47,  277,  111,
 /*   610 */   112,  241,  114,  115,  116,  307,  241,  115,  310,  311,
 /*   620 */   312,  313,  314,  315,   64,  317,  241,  272,  320,   49,
 /*   630 */   145,   20,  324,  325,  326,    0,   14,   15,   16,  270,
 /*   640 */    80,  196,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   650 */   101,  102,  103,  345,  105,  106,  107,  108,  109,  110,
 /*   660 */   270,  291,  102,  241,  241,  241,  291,  241,  241,  241,
 /*   670 */   241,  241,  241,  113,  118,  241,  291,  121,  122,  123,
 /*   680 */   124,  125,  126,  127,  128,  129,  130,  131,  132,  133,
 /*   690 */   134,  135,  136,  137,  138,   60,   61,   62,   63,  182,
 /*   700 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   710 */    75,   76,   77,  291,  291,  291,  156,  291,  291,  291,
 /*   720 */   291,  291,  291,  241,   37,  291,  269,  241,  255,  256,
 /*   730 */   241,  255,  256,  286,  287,  278,   42,   43,  178,  179,
 /*   740 */   308,  181,  182,  183,  184,  185,  186,  187,  188,  189,
 /*   750 */   190,  191,  192,  193,  194,  195,  145,   18,  269,  248,
 /*   760 */     4,  241,   23,  308,  332,  182,  277,   47,   22,  248,
 /*   770 */    20,  260,    0,  291,   35,   36,  287,  291,   39,  287,
 /*   780 */   291,  260,  206,  207,   64,  293,  297,  332,  277,  269,
 /*   790 */   167,  168,   41,   47,  248,   56,  307,  277,  277,  310,
 /*   800 */   311,  312,  313,  314,  315,  262,  317,  287,  265,  320,
 /*   810 */    64,  291,  248,  324,  325,   41,  300,   45,   84,   80,
 /*   820 */    47,   87,  224,  277,  260,  336,   84,  307,   41,   87,
 /*   830 */   310,  311,  312,  313,  314,  315,   44,  317,  349,  248,
 /*   840 */   320,  277,  353,  297,  324,  325,  326,   84,  102,   84,
 /*   850 */    87,  260,   87,   21,   58,   81,  117,  241,  338,  113,
 /*   860 */   314,  248,  248,  270,  344,  345,   34,   47,  277,  145,
 /*   870 */   146,   41,   80,  260,  260,  329,  330,  331,    0,  333,
 /*   880 */     1,    2,  336,    0,   64,  269,  113,  148,  149,  150,
 /*   890 */   277,  277,  153,  277,  207,  349,  242,  158,   41,  353,
 /*   900 */    22,   47,  156,  287,   41,   22,   41,  291,  258,  170,
 /*   910 */    41,   81,  173,   41,  175,  176,  177,   41,  193,  194,
 /*   920 */   241,    0,   41,  307,  178,  179,  310,  311,  312,  313,
 /*   930 */   314,  315,  182,  317,  356,   41,  320,  347,   81,   80,
 /*   940 */   324,  325,  326,  304,   81,   41,   81,  208,  269,   90,
 /*   950 */    81,  335,  269,   81,  247,   41,  277,   81,   41,  341,
 /*   960 */   249,   33,   81,  334,  280,  209,  287,  113,  309,  350,
 /*   970 */   291,   41,  241,   45,  178,   81,  350,  226,  350,   51,
 /*   980 */    52,   53,   54,   55,   41,   81,  307,   41,   41,  310,
 /*   990 */   311,  312,  313,  314,  315,   81,  317,    0,   81,  320,
 /*  1000 */   269,  337,   20,  324,  325,  326,  248,   79,  277,   45,
 /*  1010 */    82,   81,   47,   92,  335,  228,  255,  305,  287,  298,
 /*  1020 */   154,   40,  291,  248,   81,  248,  285,   81,   81,  139,
 /*  1030 */   283,  241,  111,  112,  248,  114,  115,  116,  307,   20,
 /*  1040 */   283,  310,  311,  312,  313,  314,  315,    4,  317,  243,
 /*  1050 */   243,  320,   20,  253,  302,  324,  325,  326,  287,  269,
 /*  1060 */    20,  253,   19,  295,  253,  277,  335,  277,  140,   20,
 /*  1070 */   142,  288,  144,  248,  253,  253,   33,  287,  243,  253,
 /*  1080 */    64,  291,  241,  269,  269,  269,  269,  297,   45,   92,
 /*  1090 */   248,  302,  164,   50,  243,  291,  269,  307,   55,  241,
 /*  1100 */   310,  311,  312,  313,  314,  315,  269,  317,  111,  112,
 /*  1110 */   269,  114,  115,  116,  269,  269,  269,  269,  277,  269,
 /*  1120 */   163,  251,   79,  287,  301,   82,  336,  269,  287,  295,
 /*  1130 */   277,  251,  291,  251,   20,  277,  251,  288,  297,  349,
 /*  1140 */   309,  216,  215,  353,  346,  287,  223,  292,  307,  291,
 /*  1150 */   211,  310,  311,  312,  313,  314,  315,  241,  317,  291,
 /*  1160 */   222,  210,  343,  292,  346,  307,  291,  339,  310,  311,
 /*  1170 */   312,  313,  314,  315,  207,  317,  277,  336,  320,  291,
 /*  1180 */   342,   20,  324,  325,    0,  269,   40,  327,  227,  241,
 /*  1190 */   349,  352,  340,  277,  353,  308,  230,  225,   80,  292,
 /*  1200 */   357,  291,  291,  287,  292,  142,  291,  291,   24,   25,
 /*  1210 */    26,   27,   28,   29,   30,   31,   32,  269,  351,  248,
 /*  1220 */   323,  289,  277,  307,  351,  277,  310,  311,  312,  313,
 /*  1230 */   314,  315,  288,  317,  251,  287,  320,  251,  352,  291,
 /*  1240 */   324,  325,  241,  352,  351,  265,  277,   80,  277,  273,
 /*  1250 */   259,  248,  243,  251,  299,  307,  303,  263,  310,  311,
 /*  1260 */   312,  313,  314,  315,  316,  317,  318,  319,  297,  296,
 /*  1270 */   269,  263,  252,  263,  239,    0,    0,   72,  277,    0,
 /*  1280 */    47,  174,   47,   47,   47,  314,  174,    0,  287,   47,
 /*  1290 */    47,  174,  291,    0,   47,    0,   47,    0,   47,  241,
 /*  1300 */   329,  330,  331,    0,  333,   80,  159,  336,  307,  160,
 /*  1310 */   113,  310,  311,  312,  313,  314,  315,    0,  317,  156,
 /*  1320 */   349,  320,    0,  152,  353,  151,  325,  269,   19,    0,
 /*  1330 */     0,    0,   44,    0,    0,  277,    0,    0,    0,    0,
 /*  1340 */     0,    0,   33,   22,   40,  287,  241,    0,    0,  291,
 /*  1350 */     0,    0,  294,    0,   45,    0,    0,    0,    0,    0,
 /*  1360 */    51,   52,   53,   54,   55,  307,    0,    0,  310,  311,
 /*  1370 */   312,  313,  314,  315,  269,  317,    0,    0,    0,    0,
 /*  1380 */     0,    0,  277,    0,    0,  241,    0,   41,   79,   40,
 /*  1390 */     0,   82,  287,    0,    0,    0,  291,   37,   44,   14,
 /*  1400 */    38,   14,   37,    0,    0,   44,   37,    0,    0,   45,
 /*  1410 */    47,   59,  307,  269,    0,  310,  311,  312,  313,  314,
 /*  1420 */   315,  277,  317,    0,    0,  116,   37,    0,   37,   47,
 /*  1430 */     0,  287,   87,   45,   37,  291,  241,   37,  294,   47,
 /*  1440 */     0,   45,    0,    0,   45,   47,    0,   22,   47,   47,
 /*  1450 */   141,  307,   47,  144,  310,  311,  312,  313,  314,  315,
 /*  1460 */   355,  317,   89,   47,  269,  241,   47,   41,    0,   41,
 /*  1470 */    22,  162,  277,  164,   22,    0,   47,   22,   47,    0,
 /*  1480 */    47,   47,  287,   48,   22,    0,  291,   22,    0,   20,
 /*  1490 */     0,   47,   22,  269,    0,    0,  161,  241,    0,   41,
 /*  1500 */    80,  277,  307,   37,   41,  310,  311,  312,  313,  314,
 /*  1510 */   315,  287,  317,  145,  319,  291,  145,  142,  294,  212,
 /*  1520 */    81,   41,   81,   41,  206,  269,   81,   80,   44,   80,
 /*  1530 */    80,  307,   41,  277,  310,  311,  312,  313,  314,  315,
 /*  1540 */    44,  317,   81,  287,   80,   44,  140,  291,   81,   41,
 /*  1550 */   294,   44,   81,  241,  212,   41,  212,   81,   47,    2,
 /*  1560 */    47,   41,   47,  307,   47,   47,  310,  311,  312,  313,
 /*  1570 */   314,  315,   47,  317,   81,   44,   44,   80,   22,  143,
 /*  1580 */    81,  269,   80,   80,  241,   80,   80,  178,    0,  277,
 /*  1590 */   180,   81,   37,  140,   90,   44,   44,   81,   22,  287,
 /*  1600 */    81,   80,   80,  291,   80,   47,   80,   80,   80,   47,
 /*  1610 */    81,   81,  269,  241,   91,   80,   47,   80,   47,  307,
 /*  1620 */   277,   81,  310,  311,  312,  313,  314,  315,   80,  317,
 /*  1630 */   287,   81,   47,   80,  291,   81,   47,  104,  104,   80,
 /*  1640 */   104,  269,  104,   22,   80,   80,   47,   80,   47,  277,
 /*  1650 */   307,   22,   92,  310,  311,  312,  313,  314,  315,  287,
 /*  1660 */   317,   59,  241,  291,   58,   78,   41,   64,   12,   13,
 /*  1670 */    47,   47,   22,  241,  113,   47,   64,   47,   22,  307,
 /*  1680 */    47,   47,  310,  311,  312,  313,  314,  315,   47,  317,
 /*  1690 */   269,   47,   47,   47,   47,   47,   47,    0,  277,   47,
 /*  1700 */    47,  269,   45,   47,   37,    0,   47,   45,  287,  277,
 /*  1710 */    37,    0,  291,   47,   45,   37,    0,   47,   37,  287,
 /*  1720 */    64,   45,    0,  291,  241,    0,   47,    0,  307,   46,
 /*  1730 */    22,  310,  311,  312,  313,  314,  315,   22,  317,  307,
 /*  1740 */    21,   20,  310,  311,  312,  313,  314,  315,   22,  317,
 /*  1750 */    21,  358,  269,  241,  358,  358,  358,  358,  102,  358,
 /*  1760 */   277,  358,  358,  358,  358,  358,  358,  358,  358,  113,
 /*  1770 */   287,  358,  358,  358,  291,  358,  358,  358,  358,  358,
 /*  1780 */   358,  269,  358,  358,  358,  241,  358,  358,  358,  277,
 /*  1790 */   307,  358,  358,  310,  311,  312,  313,  314,  315,  287,
 /*  1800 */   317,  358,  358,  291,  358,  358,  358,  358,  358,  358,
 /*  1810 */   358,  358,  156,  269,  358,  358,  358,  358,  358,  307,
 /*  1820 */   358,  277,  310,  311,  312,  313,  314,  315,  358,  317,
 /*  1830 */   358,  287,  358,  358,  178,  291,  358,  358,  358,  358,
 /*  1840 */   358,  241,  358,  358,  358,  189,  190,  191,  358,  358,
 /*  1850 */   358,  307,  358,  358,  310,  311,  312,  313,  314,  315,
 /*  1860 */   358,  317,  358,  358,  358,  358,  358,  358,  358,  269,
 /*  1870 */   358,  358,  241,  358,  358,  358,  358,  277,  358,  358,
 /*  1880 */   358,  358,  358,  358,  358,  358,  358,  287,  358,  358,
 /*  1890 */   358,  291,  358,  358,  358,  358,  358,  358,  358,  358,
 /*  1900 */   269,  241,  358,  358,  358,  358,  358,  307,  277,  358,
 /*  1910 */   310,  311,  312,  313,  314,  315,  358,  317,  287,  358,
 /*  1920 */   358,  358,  291,  358,  358,  358,  358,  358,  358,  269,
 /*  1930 */   358,  358,  241,  358,  358,  358,  358,  277,  307,  358,
 /*  1940 */   358,  310,  311,  312,  313,  314,  315,  287,  317,  358,
 /*  1950 */   358,  291,  358,  358,  358,  358,  358,  358,  358,  358,
 /*  1960 */   269,  241,  358,  358,  358,  358,  358,  307,  277,  358,
 /*  1970 */   310,  311,  312,  313,  314,  315,  358,  317,  287,  358,
 /*  1980 */   358,  358,  291,  358,  358,  358,  358,  358,  358,  269,
 /*  1990 */   358,  358,  358,  358,  358,  358,  358,  277,  307,  358,
 /*  2000 */   358,  310,  311,  312,  313,  314,  315,  287,  317,  358,
 /*  2010 */   358,  291,  241,  358,  358,  358,  358,  358,  358,  358,
 /*  2020 */   358,  358,  358,  241,  358,  358,  358,  307,  358,  358,
 /*  2030 */   310,  311,  312,  313,  314,  315,  358,  317,  358,  358,
 /*  2040 */   269,  358,  358,  358,  358,  358,  358,  358,  277,  358,
 /*  2050 */   358,  269,  358,  358,  358,  358,  358,  358,  287,  277,
 /*  2060 */   358,  358,  291,  358,  358,  358,  358,  358,  358,  287,
 /*  2070 */   358,  358,  358,  291,  358,  358,  358,  241,  307,  358,
 /*  2080 */   358,  310,  311,  312,  313,  314,  315,  358,  317,  307,
 /*  2090 */   358,  358,  310,  311,  312,  313,  314,  315,  358,  317,
 /*  2100 */   358,  358,  358,  358,  358,  269,  358,  358,  358,  358,
 /*  2110 */   358,  358,  358,  277,  358,  358,  358,  358,  358,  358,
 /*  2120 */   358,  358,  358,  287,  358,  358,  358,  291,  358,  358,
 /*  2130 */   358,  358,  358,  358,  358,  358,  358,  358,  358,  358,
 /*  2140 */   358,  358,  358,  307,  358,  358,  310,  311,  312,  313,
 /*  2150 */   314,  315,  358,  317,
};
#define YY_SHIFT_COUNT    (604)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1729)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   739,    0,    0,   48,   96,   96,   96,   96,  280,  280,
 /*    10 */    96,   96,  328,  376,  560,  376,  376,  376,  376,  376,
 /*    20 */   376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
 /*    30 */   376,  376,  376,  376,  376,  376,  376,  376,   37,   37,
 /*    40 */    68,   68,   68, 1656, 1656, 1656, 1656,   64,  271,  179,
 /*    50 */    18,   18,   13,   13,  123,  179,  179,   18,   18,   18,
 /*    60 */    18,   18,   18,   35,   18,  182,  190,  314,  182,   18,
 /*    70 */    18,  182,   18,  182,  182,  314,  182,   18,  334,  556,
 /*    80 */   343,  107,  107,  192,  312,  746,  746,  746,  746,  746,
 /*    90 */   746,  746,  746,  746,  746,  746,  746,  746,  746,  746,
 /*   100 */   746,  746,  746,  746,  441,  580,  110,  110,  206,  720,
 /*   110 */   393,  393,  393,  244,  720,  384,  314,  182,  182,  314,
 /*   120 */   356,  466,  549,  549,  549,  549,  549,  549,  549, 1309,
 /*   130 */   294,  197,   21,   78,  268,  279,  517,  583,  694,  292,
 /*   140 */   502,  611,  576,  687,  576,  598,  598,  598,  756,  750,
 /*   150 */   982,  964,  965,  866,  982,  982,  981,  890,  890,  982,
 /*   160 */  1019, 1019, 1032,   35,  314,   35, 1040,   35,  384, 1049,
 /*   170 */    35,   35,  982,   35, 1019,  182,  182,  182,  182,  182,
 /*   180 */   182,  182,  182,  182,  182,  182,  982, 1019, 1016, 1032,
 /*   190 */   334,  957,  314,  334, 1040,  334,  384, 1049,  334, 1114,
 /*   200 */   925,  927, 1016,  925,  927, 1016, 1016,  182,  923,  938,
 /*   210 */   939,  951,  967,  384, 1161, 1146,  961,  972,  966,  961,
 /*   220 */   972,  961,  972, 1118,  927, 1016, 1016,  927, 1016, 1063,
 /*   230 */   384, 1049,  334,  356,  334,  384, 1167,  466,  982,  334,
 /*   240 */  1019, 2154, 2154, 2154, 2154, 2154, 2154, 2154, 2154,  635,
 /*   250 */   928, 1184, 1043,  921,  997,  119,   14,   30,  485,  126,
 /*   260 */   498,  354,  354,  354,  354,  354,  354,  354,  354,  309,
 /*   270 */   321,  415,  404,    8,  445,  622,  622,  622,  622,  772,
 /*   280 */   774,  734,  742,  763,  765,  435,  878,  883,  832,  623,
 /*   290 */   724,  830,  857,  863,  879,  725,  751,  787,  865,  796,
 /*   300 */   869,  792,  872,  876,  881,  894,  904,  773,  854,  914,
 /*   310 */   917,  930,  943,  946,  947,  859,  820, 1275, 1276, 1205,
 /*   320 */  1279, 1233, 1107, 1235, 1236, 1237, 1112, 1287, 1242, 1243,
 /*   330 */  1117, 1293, 1247, 1295, 1249, 1297, 1251, 1303, 1225, 1149,
 /*   340 */  1147, 1197, 1163, 1317, 1322, 1171, 1174, 1329, 1330, 1288,
 /*   350 */  1331, 1333, 1334, 1336, 1337, 1338, 1339, 1340, 1341, 1347,
 /*   360 */  1348, 1350, 1351, 1353, 1355, 1356, 1357, 1358, 1304, 1359,
 /*   370 */  1366, 1367, 1376, 1377, 1378, 1321, 1379, 1380, 1381, 1383,
 /*   380 */  1384, 1386, 1349, 1360, 1346, 1385, 1354, 1387, 1361, 1390,
 /*   390 */  1362, 1365, 1393, 1394, 1395, 1403, 1369, 1404, 1352, 1407,
 /*   400 */  1408, 1363, 1364, 1389, 1414, 1382, 1388, 1391, 1423, 1392,
 /*   410 */  1396, 1397, 1424, 1398, 1399, 1400, 1427, 1430, 1440, 1442,
 /*   420 */  1373, 1345, 1401, 1425, 1443, 1402, 1405, 1416, 1419, 1426,
 /*   430 */  1428, 1429, 1431, 1433, 1446, 1448, 1468, 1452, 1435, 1475,
 /*   440 */  1455, 1434, 1479, 1462, 1485, 1465, 1469, 1488, 1368, 1444,
 /*   450 */  1490, 1335, 1470, 1371, 1375, 1494, 1495, 1498, 1420, 1466,
 /*   460 */  1406, 1458, 1463, 1307, 1439, 1480, 1441, 1447, 1449, 1450,
 /*   470 */  1445, 1482, 1484, 1496, 1464, 1491, 1342, 1461, 1467, 1501,
 /*   480 */  1318, 1508, 1507, 1471, 1514, 1344, 1476, 1511, 1513, 1515,
 /*   490 */  1517, 1518, 1525, 1476, 1557, 1409, 1520, 1493, 1497, 1499,
 /*   500 */  1531, 1502, 1503, 1532, 1556, 1410, 1505, 1510, 1516, 1506,
 /*   510 */  1521, 1436, 1522, 1588, 1555, 1453, 1524, 1504, 1551, 1552,
 /*   520 */  1526, 1519, 1527, 1576, 1528, 1523, 1529, 1558, 1562, 1535,
 /*   530 */  1530, 1569, 1537, 1540, 1571, 1548, 1550, 1585, 1553, 1554,
 /*   540 */  1589, 1559, 1533, 1534, 1536, 1538, 1621, 1560, 1564, 1565,
 /*   550 */  1599, 1567, 1561, 1601, 1629, 1602, 1606, 1603, 1587, 1625,
 /*   560 */  1623, 1624, 1628, 1630, 1633, 1650, 1634, 1641, 1612, 1426,
 /*   570 */  1644, 1428, 1645, 1646, 1647, 1648, 1649, 1652, 1697, 1653,
 /*   580 */  1657, 1667, 1705, 1659, 1662, 1673, 1711, 1666, 1669, 1678,
 /*   590 */  1716, 1670, 1676, 1681, 1722, 1679, 1683, 1725, 1727, 1708,
 /*   600 */  1719, 1715, 1726, 1729, 1721,
};
#define YY_REDUCE_COUNT (248)
#define YY_REDUCE_MIN   (-335)
#define YY_REDUCE_MAX   (1836)
static const short yy_reduce_ofst[] = {
 /*     0 */  -190, -238,  489,  520,  308,  616,  679,  731,  790,  841,
 /*    10 */   858,  916,  948, -140, 1001, 1058,  138, 1105, 1144, 1195,
 /*    20 */  1224, 1256, 1312, 1343, 1372, 1421, 1432, 1483, 1512, 1544,
 /*    30 */  1600, 1631, 1660, 1691, 1720, 1771, 1782, 1836,  546,  971,
 /*    40 */    88,   -1,  113, -266, -181,   46,  103,  239, -286,  -85,
 /*    50 */  -163,   87, -240, -223, -335, -334, -253,  -49,   85,  135,
 /*    60 */   248,  331,  511, -172,  521, -124, -111,   56,  136,  564,
 /*    70 */   591,  -21,  613,  216,  130,  152,  320,  614, -173, -177,
 /*    80 */  -256, -256, -256, -188, -105,  -86,  213,  261,  287,  370,
 /*    90 */   375,  385,  422,  423,  424,  426,  427,  428,  429,  430,
 /*   100 */   431,  434,  482,  486, -100,    4,  305,  348,   63,  473,
 /*   110 */   -83,  432,  455,  355,  476,   94,  492,  457,   -8,  447,
 /*   120 */   543,  -95, -270,  225,  235,  317,  369,  390,  593,  516,
 /*   130 */   654,  650,  578,  590,  639,  618,  683,  683,  707,  711,
 /*   140 */   684,  659,  629,  629,  629,  619,  626,  628,  664,  683,
 /*   150 */   758,  712,  761,  721,  775,  777,  741,  747,  757,  786,
 /*   160 */   806,  807,  752,  800,  771,  808,  768,  811,  788,  783,
 /*   170 */   821,  822,  825,  826,  835,  814,  815,  816,  817,  827,
 /*   180 */   837,  845,  846,  847,  848,  850,  842,  851,  804,  789,
 /*   190 */   870,  823,  836,  880,  834,  882,  853,  849,  885,  831,
 /*   200 */   798,  855,  868,  818,  871,  875,  888,  683,  819,  838,
 /*   210 */   852,  828,  629,  899,  887,  860,  839,  867,  843,  886,
 /*   220 */   873,  891,  893,  897,  907,  910,  911,  912,  915,  932,
 /*   230 */   945,  944,  983,  980,  986,  969,  976,  991, 1003, 1002,
 /*   240 */  1009,  955,  953,  973,  994, 1008, 1010, 1020, 1035,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*    10 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*    20 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*    30 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*    40 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*    50 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*    60 */  1345, 1345, 1345, 1414, 1345, 1345, 1345, 1345, 1345, 1345,
 /*    70 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1412, 1552,
 /*    80 */  1345, 1717, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*    90 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   100 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1414, 1345,
 /*   110 */  1728, 1728, 1728, 1412, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   120 */  1507, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1590,
 /*   130 */  1345, 1345, 1794, 1345, 1596, 1752, 1345, 1345, 1345, 1345,
 /*   140 */  1460, 1744, 1720, 1734, 1721, 1779, 1779, 1779, 1737, 1345,
 /*   150 */  1345, 1345, 1345, 1582, 1345, 1345, 1557, 1554, 1554, 1345,
 /*   160 */  1345, 1345, 1345, 1414, 1345, 1414, 1345, 1414, 1345, 1345,
 /*   170 */  1414, 1414, 1345, 1414, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   180 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   190 */  1412, 1592, 1345, 1412, 1345, 1412, 1345, 1345, 1412, 1345,
 /*   200 */  1759, 1757, 1345, 1759, 1757, 1345, 1345, 1345, 1771, 1767,
 /*   210 */  1750, 1748, 1734, 1345, 1345, 1345, 1785, 1781, 1797, 1785,
 /*   220 */  1781, 1785, 1781, 1345, 1757, 1345, 1345, 1757, 1345, 1565,
 /*   230 */  1345, 1345, 1412, 1345, 1412, 1345, 1476, 1345, 1345, 1412,
 /*   240 */  1345, 1584, 1598, 1574, 1510, 1510, 1510, 1415, 1350, 1345,
 /*   250 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   260 */  1472, 1661, 1770, 1769, 1693, 1692, 1691, 1689, 1660, 1345,
 /*   270 */  1345, 1345, 1345, 1345, 1345, 1654, 1655, 1653, 1652, 1345,
 /*   280 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   290 */  1345, 1345, 1345, 1345, 1718, 1345, 1782, 1786, 1345, 1345,
 /*   300 */  1345, 1638, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   310 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   320 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   330 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   340 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   350 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   360 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   370 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   380 */  1345, 1345, 1345, 1345, 1379, 1345, 1345, 1345, 1345, 1345,
 /*   390 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   400 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   410 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   420 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1441,
 /*   430 */  1440, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   440 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   450 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   460 */  1345, 1741, 1751, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   470 */  1345, 1345, 1345, 1638, 1345, 1768, 1345, 1727, 1723, 1345,
 /*   480 */  1345, 1719, 1345, 1345, 1780, 1345, 1345, 1345, 1345, 1345,
 /*   490 */  1345, 1345, 1345, 1345, 1713, 1345, 1686, 1345, 1345, 1345,
 /*   500 */  1345, 1345, 1345, 1345, 1345, 1648, 1345, 1345, 1345, 1345,
 /*   510 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1637, 1345,
 /*   520 */  1677, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1504,
 /*   530 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   540 */  1345, 1345, 1489, 1487, 1486, 1485, 1345, 1482, 1345, 1345,
 /*   550 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1434,
 /*   560 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1425,
 /*   570 */  1345, 1424, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   580 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   590 */  1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345, 1345,
 /*   600 */  1345, 1345, 1345, 1345, 1345,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*  PRIVILEGE => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*       DAYS => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*      DELAY => nothing */
    0,  /* FILE_FACTOR => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FULLTEXT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*     SCHEMA => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*      MERGE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /*      COUNT => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  231,  /*  NK_BITNOT => ID */
  231,  /*     INSERT => ID */
  231,  /*     VALUES => ID */
  231,  /*     IMPORT => ID */
  231,  /*    NK_SEMI => ID */
  231,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "GRANT",
  /*   37 */ "ON",
  /*   38 */ "TO",
  /*   39 */ "REVOKE",
  /*   40 */ "FROM",
  /*   41 */ "NK_COMMA",
  /*   42 */ "READ",
  /*   43 */ "WRITE",
  /*   44 */ "NK_DOT",
  /*   45 */ "DNODE",
  /*   46 */ "PORT",
  /*   47 */ "NK_INTEGER",
  /*   48 */ "DNODES",
  /*   49 */ "NK_IPTOKEN",
  /*   50 */ "LOCAL",
  /*   51 */ "QNODE",
  /*   52 */ "BNODE",
  /*   53 */ "SNODE",
  /*   54 */ "MNODE",
  /*   55 */ "DATABASE",
  /*   56 */ "USE",
  /*   57 */ "IF",
  /*   58 */ "NOT",
  /*   59 */ "EXISTS",
  /*   60 */ "BUFFER",
  /*   61 */ "CACHELAST",
  /*   62 */ "COMP",
  /*   63 */ "DAYS",
  /*   64 */ "NK_VARIABLE",
  /*   65 */ "FSYNC",
  /*   66 */ "MAXROWS",
  /*   67 */ "MINROWS",
  /*   68 */ "KEEP",
  /*   69 */ "PAGES",
  /*   70 */ "PAGESIZE",
  /*   71 */ "PRECISION",
  /*   72 */ "REPLICA",
  /*   73 */ "STRICT",
  /*   74 */ "WAL",
  /*   75 */ "VGROUPS",
  /*   76 */ "SINGLE_STABLE",
  /*   77 */ "RETENTIONS",
  /*   78 */ "NK_COLON",
  /*   79 */ "TABLE",
  /*   80 */ "NK_LP",
  /*   81 */ "NK_RP",
  /*   82 */ "STABLE",
  /*   83 */ "ADD",
  /*   84 */ "COLUMN",
  /*   85 */ "MODIFY",
  /*   86 */ "RENAME",
  /*   87 */ "TAG",
  /*   88 */ "SET",
  /*   89 */ "NK_EQ",
  /*   90 */ "USING",
  /*   91 */ "TAGS",
  /*   92 */ "COMMENT",
  /*   93 */ "BOOL",
  /*   94 */ "TINYINT",
  /*   95 */ "SMALLINT",
  /*   96 */ "INT",
  /*   97 */ "INTEGER",
  /*   98 */ "BIGINT",
  /*   99 */ "FLOAT",
  /*  100 */ "DOUBLE",
  /*  101 */ "BINARY",
  /*  102 */ "TIMESTAMP",
  /*  103 */ "NCHAR",
  /*  104 */ "UNSIGNED",
  /*  105 */ "JSON",
  /*  106 */ "VARCHAR",
  /*  107 */ "MEDIUMBLOB",
  /*  108 */ "BLOB",
  /*  109 */ "VARBINARY",
  /*  110 */ "DECIMAL",
  /*  111 */ "DELAY",
  /*  112 */ "FILE_FACTOR",
  /*  113 */ "NK_FLOAT",
  /*  114 */ "ROLLUP",
  /*  115 */ "TTL",
  /*  116 */ "SMA",
  /*  117 */ "SHOW",
  /*  118 */ "DATABASES",
  /*  119 */ "TABLES",
  /*  120 */ "STABLES",
  /*  121 */ "MNODES",
  /*  122 */ "MODULES",
  /*  123 */ "QNODES",
  /*  124 */ "FUNCTIONS",
  /*  125 */ "INDEXES",
  /*  126 */ "ACCOUNTS",
  /*  127 */ "APPS",
  /*  128 */ "CONNECTIONS",
  /*  129 */ "LICENCE",
  /*  130 */ "GRANTS",
  /*  131 */ "QUERIES",
  /*  132 */ "SCORES",
  /*  133 */ "TOPICS",
  /*  134 */ "VARIABLES",
  /*  135 */ "BNODES",
  /*  136 */ "SNODES",
  /*  137 */ "CLUSTER",
  /*  138 */ "TRANSACTIONS",
  /*  139 */ "LIKE",
  /*  140 */ "INDEX",
  /*  141 */ "FULLTEXT",
  /*  142 */ "FUNCTION",
  /*  143 */ "INTERVAL",
  /*  144 */ "TOPIC",
  /*  145 */ "AS",
  /*  146 */ "WITH",
  /*  147 */ "SCHEMA",
  /*  148 */ "DESC",
  /*  149 */ "DESCRIBE",
  /*  150 */ "RESET",
  /*  151 */ "QUERY",
  /*  152 */ "CACHE",
  /*  153 */ "EXPLAIN",
  /*  154 */ "ANALYZE",
  /*  155 */ "VERBOSE",
  /*  156 */ "NK_BOOL",
  /*  157 */ "RATIO",
  /*  158 */ "COMPACT",
  /*  159 */ "VNODES",
  /*  160 */ "IN",
  /*  161 */ "OUTPUTTYPE",
  /*  162 */ "AGGREGATE",
  /*  163 */ "BUFSIZE",
  /*  164 */ "STREAM",
  /*  165 */ "INTO",
  /*  166 */ "TRIGGER",
  /*  167 */ "AT_ONCE",
  /*  168 */ "WINDOW_CLOSE",
  /*  169 */ "WATERMARK",
  /*  170 */ "KILL",
  /*  171 */ "CONNECTION",
  /*  172 */ "TRANSACTION",
  /*  173 */ "MERGE",
  /*  174 */ "VGROUP",
  /*  175 */ "REDISTRIBUTE",
  /*  176 */ "SPLIT",
  /*  177 */ "SYNCDB",
  /*  178 */ "NULL",
  /*  179 */ "NK_QUESTION",
  /*  180 */ "NK_ARROW",
  /*  181 */ "ROWTS",
  /*  182 */ "TBNAME",
  /*  183 */ "QSTARTTS",
  /*  184 */ "QENDTS",
  /*  185 */ "WSTARTTS",
  /*  186 */ "WENDTS",
  /*  187 */ "WDURATION",
  /*  188 */ "CAST",
  /*  189 */ "NOW",
  /*  190 */ "TODAY",
  /*  191 */ "TIMEZONE",
  /*  192 */ "COUNT",
  /*  193 */ "FIRST",
  /*  194 */ "LAST",
  /*  195 */ "LAST_ROW",
  /*  196 */ "BETWEEN",
  /*  197 */ "IS",
  /*  198 */ "NK_LT",
  /*  199 */ "NK_GT",
  /*  200 */ "NK_LE",
  /*  201 */ "NK_GE",
  /*  202 */ "NK_NE",
  /*  203 */ "MATCH",
  /*  204 */ "NMATCH",
  /*  205 */ "CONTAINS",
  /*  206 */ "JOIN",
  /*  207 */ "INNER",
  /*  208 */ "SELECT",
  /*  209 */ "DISTINCT",
  /*  210 */ "WHERE",
  /*  211 */ "PARTITION",
  /*  212 */ "BY",
  /*  213 */ "SESSION",
  /*  214 */ "STATE_WINDOW",
  /*  215 */ "SLIDING",
  /*  216 */ "FILL",
  /*  217 */ "VALUE",
  /*  218 */ "NONE",
  /*  219 */ "PREV",
  /*  220 */ "LINEAR",
  /*  221 */ "NEXT",
  /*  222 */ "GROUP",
  /*  223 */ "HAVING",
  /*  224 */ "ORDER",
  /*  225 */ "SLIMIT",
  /*  226 */ "SOFFSET",
  /*  227 */ "LIMIT",
  /*  228 */ "OFFSET",
  /*  229 */ "ASC",
  /*  230 */ "NULLS",
  /*  231 */ "ID",
  /*  232 */ "NK_BITNOT",
  /*  233 */ "INSERT",
  /*  234 */ "VALUES",
  /*  235 */ "IMPORT",
  /*  236 */ "NK_SEMI",
  /*  237 */ "FILE",
  /*  238 */ "cmd",
  /*  239 */ "account_options",
  /*  240 */ "alter_account_options",
  /*  241 */ "literal",
  /*  242 */ "alter_account_option",
  /*  243 */ "user_name",
  /*  244 */ "privileges",
  /*  245 */ "priv_level",
  /*  246 */ "priv_type_list",
  /*  247 */ "priv_type",
  /*  248 */ "db_name",
  /*  249 */ "dnode_endpoint",
  /*  250 */ "dnode_host_name",
  /*  251 */ "not_exists_opt",
  /*  252 */ "db_options",
  /*  253 */ "exists_opt",
  /*  254 */ "alter_db_options",
  /*  255 */ "integer_list",
  /*  256 */ "variable_list",
  /*  257 */ "retention_list",
  /*  258 */ "alter_db_option",
  /*  259 */ "retention",
  /*  260 */ "full_table_name",
  /*  261 */ "column_def_list",
  /*  262 */ "tags_def_opt",
  /*  263 */ "table_options",
  /*  264 */ "multi_create_clause",
  /*  265 */ "tags_def",
  /*  266 */ "multi_drop_clause",
  /*  267 */ "alter_table_clause",
  /*  268 */ "alter_table_options",
  /*  269 */ "column_name",
  /*  270 */ "type_name",
  /*  271 */ "signed_literal",
  /*  272 */ "create_subtable_clause",
  /*  273 */ "specific_tags_opt",
  /*  274 */ "literal_list",
  /*  275 */ "drop_table_clause",
  /*  276 */ "col_name_list",
  /*  277 */ "table_name",
  /*  278 */ "column_def",
  /*  279 */ "func_name_list",
  /*  280 */ "alter_table_option",
  /*  281 */ "col_name",
  /*  282 */ "db_name_cond_opt",
  /*  283 */ "like_pattern_opt",
  /*  284 */ "table_name_cond",
  /*  285 */ "from_db_opt",
  /*  286 */ "func_name",
  /*  287 */ "function_name",
  /*  288 */ "index_name",
  /*  289 */ "index_options",
  /*  290 */ "func_list",
  /*  291 */ "duration_literal",
  /*  292 */ "sliding_opt",
  /*  293 */ "func",
  /*  294 */ "expression_list",
  /*  295 */ "topic_name",
  /*  296 */ "topic_options",
  /*  297 */ "query_expression",
  /*  298 */ "analyze_opt",
  /*  299 */ "explain_options",
  /*  300 */ "agg_func_opt",
  /*  301 */ "bufsize_opt",
  /*  302 */ "stream_name",
  /*  303 */ "stream_options",
  /*  304 */ "into_opt",
  /*  305 */ "dnode_list",
  /*  306 */ "signed",
  /*  307 */ "literal_func",
  /*  308 */ "table_alias",
  /*  309 */ "column_alias",
  /*  310 */ "expression",
  /*  311 */ "pseudo_column",
  /*  312 */ "column_reference",
  /*  313 */ "function_expression",
  /*  314 */ "subquery",
  /*  315 */ "star_func",
  /*  316 */ "star_func_para_list",
  /*  317 */ "noarg_func",
  /*  318 */ "other_para_list",
  /*  319 */ "star_func_para",
  /*  320 */ "predicate",
  /*  321 */ "compare_op",
  /*  322 */ "in_op",
  /*  323 */ "in_predicate_value",
  /*  324 */ "boolean_value_expression",
  /*  325 */ "boolean_primary",
  /*  326 */ "common_expression",
  /*  327 */ "from_clause",
  /*  328 */ "table_reference_list",
  /*  329 */ "table_reference",
  /*  330 */ "table_primary",
  /*  331 */ "joined_table",
  /*  332 */ "alias_opt",
  /*  333 */ "parenthesized_joined_table",
  /*  334 */ "join_type",
  /*  335 */ "search_condition",
  /*  336 */ "query_specification",
  /*  337 */ "set_quantifier_opt",
  /*  338 */ "select_list",
  /*  339 */ "where_clause_opt",
  /*  340 */ "partition_by_clause_opt",
  /*  341 */ "twindow_clause_opt",
  /*  342 */ "group_by_clause_opt",
  /*  343 */ "having_clause_opt",
  /*  344 */ "select_sublist",
  /*  345 */ "select_item",
  /*  346 */ "fill_opt",
  /*  347 */ "fill_mode",
  /*  348 */ "group_by_list",
  /*  349 */ "query_expression_body",
  /*  350 */ "order_by_clause_opt",
  /*  351 */ "slimit_clause_opt",
  /*  352 */ "limit_clause_opt",
  /*  353 */ "query_primary",
  /*  354 */ "sort_specification_list",
  /*  355 */ "sort_specification",
  /*  356 */ "ordering_specification_opt",
  /*  357 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  29 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  30 */ "privileges ::= ALL",
 /*  31 */ "privileges ::= priv_type_list",
 /*  32 */ "priv_type_list ::= priv_type",
 /*  33 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  34 */ "priv_type ::= READ",
 /*  35 */ "priv_type ::= WRITE",
 /*  36 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  37 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  38 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  39 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  40 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  41 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  42 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  43 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  44 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  45 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  46 */ "dnode_endpoint ::= NK_STRING",
 /*  47 */ "dnode_host_name ::= NK_ID",
 /*  48 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  49 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  50 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  51 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  52 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  53 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  54 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  60 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  61 */ "cmd ::= USE db_name",
 /*  62 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  63 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  64 */ "not_exists_opt ::=",
 /*  65 */ "exists_opt ::= IF EXISTS",
 /*  66 */ "exists_opt ::=",
 /*  67 */ "db_options ::=",
 /*  68 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  69 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  70 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  71 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  72 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  73 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  74 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  75 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  76 */ "db_options ::= db_options KEEP integer_list",
 /*  77 */ "db_options ::= db_options KEEP variable_list",
 /*  78 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  79 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  81 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  82 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  83 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  84 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  85 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  86 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  87 */ "alter_db_options ::= alter_db_option",
 /*  88 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  89 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  90 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  91 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  92 */ "alter_db_option ::= KEEP integer_list",
 /*  93 */ "alter_db_option ::= KEEP variable_list",
 /*  94 */ "alter_db_option ::= PAGES NK_INTEGER",
 /*  95 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  96 */ "alter_db_option ::= STRICT NK_INTEGER",
 /*  97 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  98 */ "integer_list ::= NK_INTEGER",
 /*  99 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 100 */ "variable_list ::= NK_VARIABLE",
 /* 101 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 102 */ "retention_list ::= retention",
 /* 103 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 104 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 105 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 106 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 107 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 108 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 109 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 110 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 111 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 112 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 113 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 114 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 115 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 116 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 117 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 118 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 119 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 120 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 121 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 122 */ "multi_create_clause ::= create_subtable_clause",
 /* 123 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 124 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 125 */ "multi_drop_clause ::= drop_table_clause",
 /* 126 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 127 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 128 */ "specific_tags_opt ::=",
 /* 129 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 130 */ "full_table_name ::= table_name",
 /* 131 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 132 */ "column_def_list ::= column_def",
 /* 133 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 134 */ "column_def ::= column_name type_name",
 /* 135 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 136 */ "type_name ::= BOOL",
 /* 137 */ "type_name ::= TINYINT",
 /* 138 */ "type_name ::= SMALLINT",
 /* 139 */ "type_name ::= INT",
 /* 140 */ "type_name ::= INTEGER",
 /* 141 */ "type_name ::= BIGINT",
 /* 142 */ "type_name ::= FLOAT",
 /* 143 */ "type_name ::= DOUBLE",
 /* 144 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 145 */ "type_name ::= TIMESTAMP",
 /* 146 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 147 */ "type_name ::= TINYINT UNSIGNED",
 /* 148 */ "type_name ::= SMALLINT UNSIGNED",
 /* 149 */ "type_name ::= INT UNSIGNED",
 /* 150 */ "type_name ::= BIGINT UNSIGNED",
 /* 151 */ "type_name ::= JSON",
 /* 152 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 153 */ "type_name ::= MEDIUMBLOB",
 /* 154 */ "type_name ::= BLOB",
 /* 155 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 156 */ "type_name ::= DECIMAL",
 /* 157 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 158 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 159 */ "tags_def_opt ::=",
 /* 160 */ "tags_def_opt ::= tags_def",
 /* 161 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 162 */ "table_options ::=",
 /* 163 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 164 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 165 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 166 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 167 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 168 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 169 */ "alter_table_options ::= alter_table_option",
 /* 170 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 171 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 172 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 173 */ "col_name_list ::= col_name",
 /* 174 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 175 */ "col_name ::= column_name",
 /* 176 */ "cmd ::= SHOW DNODES",
 /* 177 */ "cmd ::= SHOW USERS",
 /* 178 */ "cmd ::= SHOW DATABASES",
 /* 179 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 180 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 181 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 182 */ "cmd ::= SHOW MNODES",
 /* 183 */ "cmd ::= SHOW MODULES",
 /* 184 */ "cmd ::= SHOW QNODES",
 /* 185 */ "cmd ::= SHOW FUNCTIONS",
 /* 186 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 187 */ "cmd ::= SHOW STREAMS",
 /* 188 */ "cmd ::= SHOW ACCOUNTS",
 /* 189 */ "cmd ::= SHOW APPS",
 /* 190 */ "cmd ::= SHOW CONNECTIONS",
 /* 191 */ "cmd ::= SHOW LICENCE",
 /* 192 */ "cmd ::= SHOW GRANTS",
 /* 193 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 194 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 195 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 196 */ "cmd ::= SHOW QUERIES",
 /* 197 */ "cmd ::= SHOW SCORES",
 /* 198 */ "cmd ::= SHOW TOPICS",
 /* 199 */ "cmd ::= SHOW VARIABLES",
 /* 200 */ "cmd ::= SHOW BNODES",
 /* 201 */ "cmd ::= SHOW SNODES",
 /* 202 */ "cmd ::= SHOW CLUSTER",
 /* 203 */ "cmd ::= SHOW TRANSACTIONS",
 /* 204 */ "db_name_cond_opt ::=",
 /* 205 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 206 */ "like_pattern_opt ::=",
 /* 207 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 208 */ "table_name_cond ::= table_name",
 /* 209 */ "from_db_opt ::=",
 /* 210 */ "from_db_opt ::= FROM db_name",
 /* 211 */ "func_name_list ::= func_name",
 /* 212 */ "func_name_list ::= func_name_list NK_COMMA func_name",
 /* 213 */ "func_name ::= function_name",
 /* 214 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 215 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 216 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 217 */ "index_options ::=",
 /* 218 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 219 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 220 */ "func_list ::= func",
 /* 221 */ "func_list ::= func_list NK_COMMA func",
 /* 222 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 223 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS query_expression",
 /* 224 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS db_name",
 /* 225 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 226 */ "topic_options ::=",
 /* 227 */ "topic_options ::= topic_options WITH TABLE",
 /* 228 */ "topic_options ::= topic_options WITH SCHEMA",
 /* 229 */ "topic_options ::= topic_options WITH TAG",
 /* 230 */ "cmd ::= DESC full_table_name",
 /* 231 */ "cmd ::= DESCRIBE full_table_name",
 /* 232 */ "cmd ::= RESET QUERY CACHE",
 /* 233 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 234 */ "analyze_opt ::=",
 /* 235 */ "analyze_opt ::= ANALYZE",
 /* 236 */ "explain_options ::=",
 /* 237 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 238 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 239 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 240 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 241 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 242 */ "agg_func_opt ::=",
 /* 243 */ "agg_func_opt ::= AGGREGATE",
 /* 244 */ "bufsize_opt ::=",
 /* 245 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 246 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 247 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 248 */ "into_opt ::=",
 /* 249 */ "into_opt ::= INTO full_table_name",
 /* 250 */ "stream_options ::=",
 /* 251 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 252 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 253 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 254 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 255 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 256 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 257 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 258 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 259 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 260 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 261 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 262 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 263 */ "cmd ::= query_expression",
 /* 264 */ "literal ::= NK_INTEGER",
 /* 265 */ "literal ::= NK_FLOAT",
 /* 266 */ "literal ::= NK_STRING",
 /* 267 */ "literal ::= NK_BOOL",
 /* 268 */ "literal ::= TIMESTAMP NK_STRING",
 /* 269 */ "literal ::= duration_literal",
 /* 270 */ "literal ::= NULL",
 /* 271 */ "literal ::= NK_QUESTION",
 /* 272 */ "duration_literal ::= NK_VARIABLE",
 /* 273 */ "signed ::= NK_INTEGER",
 /* 274 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 275 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 276 */ "signed ::= NK_FLOAT",
 /* 277 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 278 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 279 */ "signed_literal ::= signed",
 /* 280 */ "signed_literal ::= NK_STRING",
 /* 281 */ "signed_literal ::= NK_BOOL",
 /* 282 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 283 */ "signed_literal ::= duration_literal",
 /* 284 */ "signed_literal ::= NULL",
 /* 285 */ "signed_literal ::= literal_func",
 /* 286 */ "literal_list ::= signed_literal",
 /* 287 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 288 */ "db_name ::= NK_ID",
 /* 289 */ "table_name ::= NK_ID",
 /* 290 */ "column_name ::= NK_ID",
 /* 291 */ "function_name ::= NK_ID",
 /* 292 */ "table_alias ::= NK_ID",
 /* 293 */ "column_alias ::= NK_ID",
 /* 294 */ "user_name ::= NK_ID",
 /* 295 */ "index_name ::= NK_ID",
 /* 296 */ "topic_name ::= NK_ID",
 /* 297 */ "stream_name ::= NK_ID",
 /* 298 */ "expression ::= literal",
 /* 299 */ "expression ::= pseudo_column",
 /* 300 */ "expression ::= column_reference",
 /* 301 */ "expression ::= function_expression",
 /* 302 */ "expression ::= subquery",
 /* 303 */ "expression ::= NK_LP expression NK_RP",
 /* 304 */ "expression ::= NK_PLUS expression",
 /* 305 */ "expression ::= NK_MINUS expression",
 /* 306 */ "expression ::= expression NK_PLUS expression",
 /* 307 */ "expression ::= expression NK_MINUS expression",
 /* 308 */ "expression ::= expression NK_STAR expression",
 /* 309 */ "expression ::= expression NK_SLASH expression",
 /* 310 */ "expression ::= expression NK_REM expression",
 /* 311 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 312 */ "expression_list ::= expression",
 /* 313 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 314 */ "column_reference ::= column_name",
 /* 315 */ "column_reference ::= table_name NK_DOT column_name",
 /* 316 */ "pseudo_column ::= ROWTS",
 /* 317 */ "pseudo_column ::= TBNAME",
 /* 318 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 319 */ "pseudo_column ::= QSTARTTS",
 /* 320 */ "pseudo_column ::= QENDTS",
 /* 321 */ "pseudo_column ::= WSTARTTS",
 /* 322 */ "pseudo_column ::= WENDTS",
 /* 323 */ "pseudo_column ::= WDURATION",
 /* 324 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 325 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 326 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 327 */ "function_expression ::= literal_func",
 /* 328 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 329 */ "literal_func ::= NOW",
 /* 330 */ "noarg_func ::= NOW",
 /* 331 */ "noarg_func ::= TODAY",
 /* 332 */ "noarg_func ::= TIMEZONE",
 /* 333 */ "star_func ::= COUNT",
 /* 334 */ "star_func ::= FIRST",
 /* 335 */ "star_func ::= LAST",
 /* 336 */ "star_func ::= LAST_ROW",
 /* 337 */ "star_func_para_list ::= NK_STAR",
 /* 338 */ "star_func_para_list ::= other_para_list",
 /* 339 */ "other_para_list ::= star_func_para",
 /* 340 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 341 */ "star_func_para ::= expression",
 /* 342 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 343 */ "predicate ::= expression compare_op expression",
 /* 344 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 345 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 346 */ "predicate ::= expression IS NULL",
 /* 347 */ "predicate ::= expression IS NOT NULL",
 /* 348 */ "predicate ::= expression in_op in_predicate_value",
 /* 349 */ "compare_op ::= NK_LT",
 /* 350 */ "compare_op ::= NK_GT",
 /* 351 */ "compare_op ::= NK_LE",
 /* 352 */ "compare_op ::= NK_GE",
 /* 353 */ "compare_op ::= NK_NE",
 /* 354 */ "compare_op ::= NK_EQ",
 /* 355 */ "compare_op ::= LIKE",
 /* 356 */ "compare_op ::= NOT LIKE",
 /* 357 */ "compare_op ::= MATCH",
 /* 358 */ "compare_op ::= NMATCH",
 /* 359 */ "compare_op ::= CONTAINS",
 /* 360 */ "in_op ::= IN",
 /* 361 */ "in_op ::= NOT IN",
 /* 362 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 363 */ "boolean_value_expression ::= boolean_primary",
 /* 364 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 365 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 366 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 367 */ "boolean_primary ::= predicate",
 /* 368 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 369 */ "common_expression ::= expression",
 /* 370 */ "common_expression ::= boolean_value_expression",
 /* 371 */ "from_clause ::= FROM table_reference_list",
 /* 372 */ "table_reference_list ::= table_reference",
 /* 373 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 374 */ "table_reference ::= table_primary",
 /* 375 */ "table_reference ::= joined_table",
 /* 376 */ "table_primary ::= table_name alias_opt",
 /* 377 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 378 */ "table_primary ::= subquery alias_opt",
 /* 379 */ "table_primary ::= parenthesized_joined_table",
 /* 380 */ "alias_opt ::=",
 /* 381 */ "alias_opt ::= table_alias",
 /* 382 */ "alias_opt ::= AS table_alias",
 /* 383 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 384 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 385 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 386 */ "join_type ::=",
 /* 387 */ "join_type ::= INNER",
 /* 388 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 389 */ "set_quantifier_opt ::=",
 /* 390 */ "set_quantifier_opt ::= DISTINCT",
 /* 391 */ "set_quantifier_opt ::= ALL",
 /* 392 */ "select_list ::= NK_STAR",
 /* 393 */ "select_list ::= select_sublist",
 /* 394 */ "select_sublist ::= select_item",
 /* 395 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 396 */ "select_item ::= common_expression",
 /* 397 */ "select_item ::= common_expression column_alias",
 /* 398 */ "select_item ::= common_expression AS column_alias",
 /* 399 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 400 */ "where_clause_opt ::=",
 /* 401 */ "where_clause_opt ::= WHERE search_condition",
 /* 402 */ "partition_by_clause_opt ::=",
 /* 403 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 404 */ "twindow_clause_opt ::=",
 /* 405 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 406 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 407 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 408 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 409 */ "sliding_opt ::=",
 /* 410 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 411 */ "fill_opt ::=",
 /* 412 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 413 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 414 */ "fill_mode ::= NONE",
 /* 415 */ "fill_mode ::= PREV",
 /* 416 */ "fill_mode ::= NULL",
 /* 417 */ "fill_mode ::= LINEAR",
 /* 418 */ "fill_mode ::= NEXT",
 /* 419 */ "group_by_clause_opt ::=",
 /* 420 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 421 */ "group_by_list ::= expression",
 /* 422 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 423 */ "having_clause_opt ::=",
 /* 424 */ "having_clause_opt ::= HAVING search_condition",
 /* 425 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 426 */ "query_expression_body ::= query_primary",
 /* 427 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 428 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 429 */ "query_primary ::= query_specification",
 /* 430 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 431 */ "order_by_clause_opt ::=",
 /* 432 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 433 */ "slimit_clause_opt ::=",
 /* 434 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 435 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 436 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 437 */ "limit_clause_opt ::=",
 /* 438 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 439 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 440 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 441 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 442 */ "search_condition ::= common_expression",
 /* 443 */ "sort_specification_list ::= sort_specification",
 /* 444 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 445 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 446 */ "ordering_specification_opt ::=",
 /* 447 */ "ordering_specification_opt ::= ASC",
 /* 448 */ "ordering_specification_opt ::= DESC",
 /* 449 */ "null_ordering_opt ::=",
 /* 450 */ "null_ordering_opt ::= NULLS FIRST",
 /* 451 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 238: /* cmd */
    case 241: /* literal */
    case 252: /* db_options */
    case 254: /* alter_db_options */
    case 259: /* retention */
    case 260: /* full_table_name */
    case 263: /* table_options */
    case 267: /* alter_table_clause */
    case 268: /* alter_table_options */
    case 271: /* signed_literal */
    case 272: /* create_subtable_clause */
    case 275: /* drop_table_clause */
    case 278: /* column_def */
    case 281: /* col_name */
    case 282: /* db_name_cond_opt */
    case 283: /* like_pattern_opt */
    case 284: /* table_name_cond */
    case 285: /* from_db_opt */
    case 286: /* func_name */
    case 289: /* index_options */
    case 291: /* duration_literal */
    case 292: /* sliding_opt */
    case 293: /* func */
    case 296: /* topic_options */
    case 297: /* query_expression */
    case 299: /* explain_options */
    case 303: /* stream_options */
    case 304: /* into_opt */
    case 306: /* signed */
    case 307: /* literal_func */
    case 310: /* expression */
    case 311: /* pseudo_column */
    case 312: /* column_reference */
    case 313: /* function_expression */
    case 314: /* subquery */
    case 319: /* star_func_para */
    case 320: /* predicate */
    case 323: /* in_predicate_value */
    case 324: /* boolean_value_expression */
    case 325: /* boolean_primary */
    case 326: /* common_expression */
    case 327: /* from_clause */
    case 328: /* table_reference_list */
    case 329: /* table_reference */
    case 330: /* table_primary */
    case 331: /* joined_table */
    case 333: /* parenthesized_joined_table */
    case 335: /* search_condition */
    case 336: /* query_specification */
    case 339: /* where_clause_opt */
    case 341: /* twindow_clause_opt */
    case 343: /* having_clause_opt */
    case 345: /* select_item */
    case 346: /* fill_opt */
    case 349: /* query_expression_body */
    case 351: /* slimit_clause_opt */
    case 352: /* limit_clause_opt */
    case 353: /* query_primary */
    case 355: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy172)); 
}
      break;
    case 239: /* account_options */
    case 240: /* alter_account_options */
    case 242: /* alter_account_option */
    case 301: /* bufsize_opt */
{
 
}
      break;
    case 243: /* user_name */
    case 245: /* priv_level */
    case 248: /* db_name */
    case 249: /* dnode_endpoint */
    case 250: /* dnode_host_name */
    case 269: /* column_name */
    case 277: /* table_name */
    case 287: /* function_name */
    case 288: /* index_name */
    case 295: /* topic_name */
    case 302: /* stream_name */
    case 308: /* table_alias */
    case 309: /* column_alias */
    case 315: /* star_func */
    case 317: /* noarg_func */
    case 332: /* alias_opt */
{
 
}
      break;
    case 244: /* privileges */
    case 246: /* priv_type_list */
    case 247: /* priv_type */
{
 
}
      break;
    case 251: /* not_exists_opt */
    case 253: /* exists_opt */
    case 298: /* analyze_opt */
    case 300: /* agg_func_opt */
    case 337: /* set_quantifier_opt */
{
 
}
      break;
    case 255: /* integer_list */
    case 256: /* variable_list */
    case 257: /* retention_list */
    case 261: /* column_def_list */
    case 262: /* tags_def_opt */
    case 264: /* multi_create_clause */
    case 265: /* tags_def */
    case 266: /* multi_drop_clause */
    case 273: /* specific_tags_opt */
    case 274: /* literal_list */
    case 276: /* col_name_list */
    case 279: /* func_name_list */
    case 290: /* func_list */
    case 294: /* expression_list */
    case 305: /* dnode_list */
    case 316: /* star_func_para_list */
    case 318: /* other_para_list */
    case 338: /* select_list */
    case 340: /* partition_by_clause_opt */
    case 342: /* group_by_clause_opt */
    case 344: /* select_sublist */
    case 348: /* group_by_list */
    case 350: /* order_by_clause_opt */
    case 354: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy60)); 
}
      break;
    case 258: /* alter_db_option */
    case 280: /* alter_table_option */
{
 
}
      break;
    case 270: /* type_name */
{
 
}
      break;
    case 321: /* compare_op */
    case 322: /* in_op */
{
 
}
      break;
    case 334: /* join_type */
{
 
}
      break;
    case 347: /* fill_mode */
{
 
}
      break;
    case 356: /* ordering_specification_opt */
{
 
}
      break;
    case 357: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  238,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  238,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  239,    0 }, /* (2) account_options ::= */
  {  239,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  239,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  239,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  239,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  239,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  239,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  239,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  239,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  239,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  240,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  240,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  242,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  242,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  242,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  242,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  242,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  242,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  242,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  242,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  242,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  242,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  238,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  238,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  238,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  238,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  238,   -6 }, /* (28) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  238,   -6 }, /* (29) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  244,   -1 }, /* (30) privileges ::= ALL */
  {  244,   -1 }, /* (31) privileges ::= priv_type_list */
  {  246,   -1 }, /* (32) priv_type_list ::= priv_type */
  {  246,   -3 }, /* (33) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  247,   -1 }, /* (34) priv_type ::= READ */
  {  247,   -1 }, /* (35) priv_type ::= WRITE */
  {  245,   -3 }, /* (36) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  245,   -3 }, /* (37) priv_level ::= db_name NK_DOT NK_STAR */
  {  238,   -3 }, /* (38) cmd ::= CREATE DNODE dnode_endpoint */
  {  238,   -5 }, /* (39) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  238,   -3 }, /* (40) cmd ::= DROP DNODE NK_INTEGER */
  {  238,   -3 }, /* (41) cmd ::= DROP DNODE dnode_endpoint */
  {  238,   -4 }, /* (42) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  238,   -5 }, /* (43) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  238,   -4 }, /* (44) cmd ::= ALTER ALL DNODES NK_STRING */
  {  238,   -5 }, /* (45) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  249,   -1 }, /* (46) dnode_endpoint ::= NK_STRING */
  {  250,   -1 }, /* (47) dnode_host_name ::= NK_ID */
  {  250,   -1 }, /* (48) dnode_host_name ::= NK_IPTOKEN */
  {  238,   -3 }, /* (49) cmd ::= ALTER LOCAL NK_STRING */
  {  238,   -4 }, /* (50) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  238,   -5 }, /* (51) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (52) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (53) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (54) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (55) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (56) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (57) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (58) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (59) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  238,   -4 }, /* (60) cmd ::= DROP DATABASE exists_opt db_name */
  {  238,   -2 }, /* (61) cmd ::= USE db_name */
  {  238,   -4 }, /* (62) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  251,   -3 }, /* (63) not_exists_opt ::= IF NOT EXISTS */
  {  251,    0 }, /* (64) not_exists_opt ::= */
  {  253,   -2 }, /* (65) exists_opt ::= IF EXISTS */
  {  253,    0 }, /* (66) exists_opt ::= */
  {  252,    0 }, /* (67) db_options ::= */
  {  252,   -3 }, /* (68) db_options ::= db_options BUFFER NK_INTEGER */
  {  252,   -3 }, /* (69) db_options ::= db_options CACHELAST NK_INTEGER */
  {  252,   -3 }, /* (70) db_options ::= db_options COMP NK_INTEGER */
  {  252,   -3 }, /* (71) db_options ::= db_options DAYS NK_INTEGER */
  {  252,   -3 }, /* (72) db_options ::= db_options DAYS NK_VARIABLE */
  {  252,   -3 }, /* (73) db_options ::= db_options FSYNC NK_INTEGER */
  {  252,   -3 }, /* (74) db_options ::= db_options MAXROWS NK_INTEGER */
  {  252,   -3 }, /* (75) db_options ::= db_options MINROWS NK_INTEGER */
  {  252,   -3 }, /* (76) db_options ::= db_options KEEP integer_list */
  {  252,   -3 }, /* (77) db_options ::= db_options KEEP variable_list */
  {  252,   -3 }, /* (78) db_options ::= db_options PAGES NK_INTEGER */
  {  252,   -3 }, /* (79) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  252,   -3 }, /* (80) db_options ::= db_options PRECISION NK_STRING */
  {  252,   -3 }, /* (81) db_options ::= db_options REPLICA NK_INTEGER */
  {  252,   -3 }, /* (82) db_options ::= db_options STRICT NK_INTEGER */
  {  252,   -3 }, /* (83) db_options ::= db_options WAL NK_INTEGER */
  {  252,   -3 }, /* (84) db_options ::= db_options VGROUPS NK_INTEGER */
  {  252,   -3 }, /* (85) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  252,   -3 }, /* (86) db_options ::= db_options RETENTIONS retention_list */
  {  254,   -1 }, /* (87) alter_db_options ::= alter_db_option */
  {  254,   -2 }, /* (88) alter_db_options ::= alter_db_options alter_db_option */
  {  258,   -2 }, /* (89) alter_db_option ::= BUFFER NK_INTEGER */
  {  258,   -2 }, /* (90) alter_db_option ::= CACHELAST NK_INTEGER */
  {  258,   -2 }, /* (91) alter_db_option ::= FSYNC NK_INTEGER */
  {  258,   -2 }, /* (92) alter_db_option ::= KEEP integer_list */
  {  258,   -2 }, /* (93) alter_db_option ::= KEEP variable_list */
  {  258,   -2 }, /* (94) alter_db_option ::= PAGES NK_INTEGER */
  {  258,   -2 }, /* (95) alter_db_option ::= REPLICA NK_INTEGER */
  {  258,   -2 }, /* (96) alter_db_option ::= STRICT NK_INTEGER */
  {  258,   -2 }, /* (97) alter_db_option ::= WAL NK_INTEGER */
  {  255,   -1 }, /* (98) integer_list ::= NK_INTEGER */
  {  255,   -3 }, /* (99) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  256,   -1 }, /* (100) variable_list ::= NK_VARIABLE */
  {  256,   -3 }, /* (101) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  257,   -1 }, /* (102) retention_list ::= retention */
  {  257,   -3 }, /* (103) retention_list ::= retention_list NK_COMMA retention */
  {  259,   -3 }, /* (104) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  238,   -9 }, /* (105) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  238,   -3 }, /* (106) cmd ::= CREATE TABLE multi_create_clause */
  {  238,   -9 }, /* (107) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  238,   -3 }, /* (108) cmd ::= DROP TABLE multi_drop_clause */
  {  238,   -4 }, /* (109) cmd ::= DROP STABLE exists_opt full_table_name */
  {  238,   -3 }, /* (110) cmd ::= ALTER TABLE alter_table_clause */
  {  238,   -3 }, /* (111) cmd ::= ALTER STABLE alter_table_clause */
  {  267,   -2 }, /* (112) alter_table_clause ::= full_table_name alter_table_options */
  {  267,   -5 }, /* (113) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  267,   -4 }, /* (114) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  267,   -5 }, /* (115) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  267,   -5 }, /* (116) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  267,   -5 }, /* (117) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  267,   -4 }, /* (118) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  267,   -5 }, /* (119) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  267,   -5 }, /* (120) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  267,   -6 }, /* (121) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  264,   -1 }, /* (122) multi_create_clause ::= create_subtable_clause */
  {  264,   -2 }, /* (123) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  272,  -10 }, /* (124) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  266,   -1 }, /* (125) multi_drop_clause ::= drop_table_clause */
  {  266,   -2 }, /* (126) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  275,   -2 }, /* (127) drop_table_clause ::= exists_opt full_table_name */
  {  273,    0 }, /* (128) specific_tags_opt ::= */
  {  273,   -3 }, /* (129) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  260,   -1 }, /* (130) full_table_name ::= table_name */
  {  260,   -3 }, /* (131) full_table_name ::= db_name NK_DOT table_name */
  {  261,   -1 }, /* (132) column_def_list ::= column_def */
  {  261,   -3 }, /* (133) column_def_list ::= column_def_list NK_COMMA column_def */
  {  278,   -2 }, /* (134) column_def ::= column_name type_name */
  {  278,   -4 }, /* (135) column_def ::= column_name type_name COMMENT NK_STRING */
  {  270,   -1 }, /* (136) type_name ::= BOOL */
  {  270,   -1 }, /* (137) type_name ::= TINYINT */
  {  270,   -1 }, /* (138) type_name ::= SMALLINT */
  {  270,   -1 }, /* (139) type_name ::= INT */
  {  270,   -1 }, /* (140) type_name ::= INTEGER */
  {  270,   -1 }, /* (141) type_name ::= BIGINT */
  {  270,   -1 }, /* (142) type_name ::= FLOAT */
  {  270,   -1 }, /* (143) type_name ::= DOUBLE */
  {  270,   -4 }, /* (144) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  270,   -1 }, /* (145) type_name ::= TIMESTAMP */
  {  270,   -4 }, /* (146) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  270,   -2 }, /* (147) type_name ::= TINYINT UNSIGNED */
  {  270,   -2 }, /* (148) type_name ::= SMALLINT UNSIGNED */
  {  270,   -2 }, /* (149) type_name ::= INT UNSIGNED */
  {  270,   -2 }, /* (150) type_name ::= BIGINT UNSIGNED */
  {  270,   -1 }, /* (151) type_name ::= JSON */
  {  270,   -4 }, /* (152) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  270,   -1 }, /* (153) type_name ::= MEDIUMBLOB */
  {  270,   -1 }, /* (154) type_name ::= BLOB */
  {  270,   -4 }, /* (155) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  270,   -1 }, /* (156) type_name ::= DECIMAL */
  {  270,   -4 }, /* (157) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  270,   -6 }, /* (158) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  262,    0 }, /* (159) tags_def_opt ::= */
  {  262,   -1 }, /* (160) tags_def_opt ::= tags_def */
  {  265,   -4 }, /* (161) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  263,    0 }, /* (162) table_options ::= */
  {  263,   -3 }, /* (163) table_options ::= table_options COMMENT NK_STRING */
  {  263,   -3 }, /* (164) table_options ::= table_options DELAY NK_INTEGER */
  {  263,   -3 }, /* (165) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  263,   -5 }, /* (166) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  263,   -3 }, /* (167) table_options ::= table_options TTL NK_INTEGER */
  {  263,   -5 }, /* (168) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  268,   -1 }, /* (169) alter_table_options ::= alter_table_option */
  {  268,   -2 }, /* (170) alter_table_options ::= alter_table_options alter_table_option */
  {  280,   -2 }, /* (171) alter_table_option ::= COMMENT NK_STRING */
  {  280,   -2 }, /* (172) alter_table_option ::= TTL NK_INTEGER */
  {  276,   -1 }, /* (173) col_name_list ::= col_name */
  {  276,   -3 }, /* (174) col_name_list ::= col_name_list NK_COMMA col_name */
  {  281,   -1 }, /* (175) col_name ::= column_name */
  {  238,   -2 }, /* (176) cmd ::= SHOW DNODES */
  {  238,   -2 }, /* (177) cmd ::= SHOW USERS */
  {  238,   -2 }, /* (178) cmd ::= SHOW DATABASES */
  {  238,   -4 }, /* (179) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  238,   -4 }, /* (180) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  238,   -3 }, /* (181) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  238,   -2 }, /* (182) cmd ::= SHOW MNODES */
  {  238,   -2 }, /* (183) cmd ::= SHOW MODULES */
  {  238,   -2 }, /* (184) cmd ::= SHOW QNODES */
  {  238,   -2 }, /* (185) cmd ::= SHOW FUNCTIONS */
  {  238,   -5 }, /* (186) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  238,   -2 }, /* (187) cmd ::= SHOW STREAMS */
  {  238,   -2 }, /* (188) cmd ::= SHOW ACCOUNTS */
  {  238,   -2 }, /* (189) cmd ::= SHOW APPS */
  {  238,   -2 }, /* (190) cmd ::= SHOW CONNECTIONS */
  {  238,   -2 }, /* (191) cmd ::= SHOW LICENCE */
  {  238,   -2 }, /* (192) cmd ::= SHOW GRANTS */
  {  238,   -4 }, /* (193) cmd ::= SHOW CREATE DATABASE db_name */
  {  238,   -4 }, /* (194) cmd ::= SHOW CREATE TABLE full_table_name */
  {  238,   -4 }, /* (195) cmd ::= SHOW CREATE STABLE full_table_name */
  {  238,   -2 }, /* (196) cmd ::= SHOW QUERIES */
  {  238,   -2 }, /* (197) cmd ::= SHOW SCORES */
  {  238,   -2 }, /* (198) cmd ::= SHOW TOPICS */
  {  238,   -2 }, /* (199) cmd ::= SHOW VARIABLES */
  {  238,   -2 }, /* (200) cmd ::= SHOW BNODES */
  {  238,   -2 }, /* (201) cmd ::= SHOW SNODES */
  {  238,   -2 }, /* (202) cmd ::= SHOW CLUSTER */
  {  238,   -2 }, /* (203) cmd ::= SHOW TRANSACTIONS */
  {  282,    0 }, /* (204) db_name_cond_opt ::= */
  {  282,   -2 }, /* (205) db_name_cond_opt ::= db_name NK_DOT */
  {  283,    0 }, /* (206) like_pattern_opt ::= */
  {  283,   -2 }, /* (207) like_pattern_opt ::= LIKE NK_STRING */
  {  284,   -1 }, /* (208) table_name_cond ::= table_name */
  {  285,    0 }, /* (209) from_db_opt ::= */
  {  285,   -2 }, /* (210) from_db_opt ::= FROM db_name */
  {  279,   -1 }, /* (211) func_name_list ::= func_name */
  {  279,   -3 }, /* (212) func_name_list ::= func_name_list NK_COMMA func_name */
  {  286,   -1 }, /* (213) func_name ::= function_name */
  {  238,   -8 }, /* (214) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  238,  -10 }, /* (215) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  238,   -6 }, /* (216) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  289,    0 }, /* (217) index_options ::= */
  {  289,   -9 }, /* (218) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  289,  -11 }, /* (219) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  290,   -1 }, /* (220) func_list ::= func */
  {  290,   -3 }, /* (221) func_list ::= func_list NK_COMMA func */
  {  293,   -4 }, /* (222) func ::= function_name NK_LP expression_list NK_RP */
  {  238,   -7 }, /* (223) cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS query_expression */
  {  238,   -7 }, /* (224) cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS db_name */
  {  238,   -4 }, /* (225) cmd ::= DROP TOPIC exists_opt topic_name */
  {  296,    0 }, /* (226) topic_options ::= */
  {  296,   -3 }, /* (227) topic_options ::= topic_options WITH TABLE */
  {  296,   -3 }, /* (228) topic_options ::= topic_options WITH SCHEMA */
  {  296,   -3 }, /* (229) topic_options ::= topic_options WITH TAG */
  {  238,   -2 }, /* (230) cmd ::= DESC full_table_name */
  {  238,   -2 }, /* (231) cmd ::= DESCRIBE full_table_name */
  {  238,   -3 }, /* (232) cmd ::= RESET QUERY CACHE */
  {  238,   -4 }, /* (233) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  298,    0 }, /* (234) analyze_opt ::= */
  {  298,   -1 }, /* (235) analyze_opt ::= ANALYZE */
  {  299,    0 }, /* (236) explain_options ::= */
  {  299,   -3 }, /* (237) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  299,   -3 }, /* (238) explain_options ::= explain_options RATIO NK_FLOAT */
  {  238,   -6 }, /* (239) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  238,  -10 }, /* (240) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  238,   -4 }, /* (241) cmd ::= DROP FUNCTION exists_opt function_name */
  {  300,    0 }, /* (242) agg_func_opt ::= */
  {  300,   -1 }, /* (243) agg_func_opt ::= AGGREGATE */
  {  301,    0 }, /* (244) bufsize_opt ::= */
  {  301,   -2 }, /* (245) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  238,   -8 }, /* (246) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  238,   -4 }, /* (247) cmd ::= DROP STREAM exists_opt stream_name */
  {  304,    0 }, /* (248) into_opt ::= */
  {  304,   -2 }, /* (249) into_opt ::= INTO full_table_name */
  {  303,    0 }, /* (250) stream_options ::= */
  {  303,   -3 }, /* (251) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  303,   -3 }, /* (252) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  303,   -3 }, /* (253) stream_options ::= stream_options WATERMARK duration_literal */
  {  238,   -3 }, /* (254) cmd ::= KILL CONNECTION NK_INTEGER */
  {  238,   -3 }, /* (255) cmd ::= KILL QUERY NK_INTEGER */
  {  238,   -3 }, /* (256) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  238,   -4 }, /* (257) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  238,   -4 }, /* (258) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  238,   -3 }, /* (259) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  305,   -2 }, /* (260) dnode_list ::= DNODE NK_INTEGER */
  {  305,   -3 }, /* (261) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  238,   -3 }, /* (262) cmd ::= SYNCDB db_name REPLICA */
  {  238,   -1 }, /* (263) cmd ::= query_expression */
  {  241,   -1 }, /* (264) literal ::= NK_INTEGER */
  {  241,   -1 }, /* (265) literal ::= NK_FLOAT */
  {  241,   -1 }, /* (266) literal ::= NK_STRING */
  {  241,   -1 }, /* (267) literal ::= NK_BOOL */
  {  241,   -2 }, /* (268) literal ::= TIMESTAMP NK_STRING */
  {  241,   -1 }, /* (269) literal ::= duration_literal */
  {  241,   -1 }, /* (270) literal ::= NULL */
  {  241,   -1 }, /* (271) literal ::= NK_QUESTION */
  {  291,   -1 }, /* (272) duration_literal ::= NK_VARIABLE */
  {  306,   -1 }, /* (273) signed ::= NK_INTEGER */
  {  306,   -2 }, /* (274) signed ::= NK_PLUS NK_INTEGER */
  {  306,   -2 }, /* (275) signed ::= NK_MINUS NK_INTEGER */
  {  306,   -1 }, /* (276) signed ::= NK_FLOAT */
  {  306,   -2 }, /* (277) signed ::= NK_PLUS NK_FLOAT */
  {  306,   -2 }, /* (278) signed ::= NK_MINUS NK_FLOAT */
  {  271,   -1 }, /* (279) signed_literal ::= signed */
  {  271,   -1 }, /* (280) signed_literal ::= NK_STRING */
  {  271,   -1 }, /* (281) signed_literal ::= NK_BOOL */
  {  271,   -2 }, /* (282) signed_literal ::= TIMESTAMP NK_STRING */
  {  271,   -1 }, /* (283) signed_literal ::= duration_literal */
  {  271,   -1 }, /* (284) signed_literal ::= NULL */
  {  271,   -1 }, /* (285) signed_literal ::= literal_func */
  {  274,   -1 }, /* (286) literal_list ::= signed_literal */
  {  274,   -3 }, /* (287) literal_list ::= literal_list NK_COMMA signed_literal */
  {  248,   -1 }, /* (288) db_name ::= NK_ID */
  {  277,   -1 }, /* (289) table_name ::= NK_ID */
  {  269,   -1 }, /* (290) column_name ::= NK_ID */
  {  287,   -1 }, /* (291) function_name ::= NK_ID */
  {  308,   -1 }, /* (292) table_alias ::= NK_ID */
  {  309,   -1 }, /* (293) column_alias ::= NK_ID */
  {  243,   -1 }, /* (294) user_name ::= NK_ID */
  {  288,   -1 }, /* (295) index_name ::= NK_ID */
  {  295,   -1 }, /* (296) topic_name ::= NK_ID */
  {  302,   -1 }, /* (297) stream_name ::= NK_ID */
  {  310,   -1 }, /* (298) expression ::= literal */
  {  310,   -1 }, /* (299) expression ::= pseudo_column */
  {  310,   -1 }, /* (300) expression ::= column_reference */
  {  310,   -1 }, /* (301) expression ::= function_expression */
  {  310,   -1 }, /* (302) expression ::= subquery */
  {  310,   -3 }, /* (303) expression ::= NK_LP expression NK_RP */
  {  310,   -2 }, /* (304) expression ::= NK_PLUS expression */
  {  310,   -2 }, /* (305) expression ::= NK_MINUS expression */
  {  310,   -3 }, /* (306) expression ::= expression NK_PLUS expression */
  {  310,   -3 }, /* (307) expression ::= expression NK_MINUS expression */
  {  310,   -3 }, /* (308) expression ::= expression NK_STAR expression */
  {  310,   -3 }, /* (309) expression ::= expression NK_SLASH expression */
  {  310,   -3 }, /* (310) expression ::= expression NK_REM expression */
  {  310,   -3 }, /* (311) expression ::= column_reference NK_ARROW NK_STRING */
  {  294,   -1 }, /* (312) expression_list ::= expression */
  {  294,   -3 }, /* (313) expression_list ::= expression_list NK_COMMA expression */
  {  312,   -1 }, /* (314) column_reference ::= column_name */
  {  312,   -3 }, /* (315) column_reference ::= table_name NK_DOT column_name */
  {  311,   -1 }, /* (316) pseudo_column ::= ROWTS */
  {  311,   -1 }, /* (317) pseudo_column ::= TBNAME */
  {  311,   -3 }, /* (318) pseudo_column ::= table_name NK_DOT TBNAME */
  {  311,   -1 }, /* (319) pseudo_column ::= QSTARTTS */
  {  311,   -1 }, /* (320) pseudo_column ::= QENDTS */
  {  311,   -1 }, /* (321) pseudo_column ::= WSTARTTS */
  {  311,   -1 }, /* (322) pseudo_column ::= WENDTS */
  {  311,   -1 }, /* (323) pseudo_column ::= WDURATION */
  {  313,   -4 }, /* (324) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  313,   -4 }, /* (325) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  313,   -6 }, /* (326) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  313,   -1 }, /* (327) function_expression ::= literal_func */
  {  307,   -3 }, /* (328) literal_func ::= noarg_func NK_LP NK_RP */
  {  307,   -1 }, /* (329) literal_func ::= NOW */
  {  317,   -1 }, /* (330) noarg_func ::= NOW */
  {  317,   -1 }, /* (331) noarg_func ::= TODAY */
  {  317,   -1 }, /* (332) noarg_func ::= TIMEZONE */
  {  315,   -1 }, /* (333) star_func ::= COUNT */
  {  315,   -1 }, /* (334) star_func ::= FIRST */
  {  315,   -1 }, /* (335) star_func ::= LAST */
  {  315,   -1 }, /* (336) star_func ::= LAST_ROW */
  {  316,   -1 }, /* (337) star_func_para_list ::= NK_STAR */
  {  316,   -1 }, /* (338) star_func_para_list ::= other_para_list */
  {  318,   -1 }, /* (339) other_para_list ::= star_func_para */
  {  318,   -3 }, /* (340) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  319,   -1 }, /* (341) star_func_para ::= expression */
  {  319,   -3 }, /* (342) star_func_para ::= table_name NK_DOT NK_STAR */
  {  320,   -3 }, /* (343) predicate ::= expression compare_op expression */
  {  320,   -5 }, /* (344) predicate ::= expression BETWEEN expression AND expression */
  {  320,   -6 }, /* (345) predicate ::= expression NOT BETWEEN expression AND expression */
  {  320,   -3 }, /* (346) predicate ::= expression IS NULL */
  {  320,   -4 }, /* (347) predicate ::= expression IS NOT NULL */
  {  320,   -3 }, /* (348) predicate ::= expression in_op in_predicate_value */
  {  321,   -1 }, /* (349) compare_op ::= NK_LT */
  {  321,   -1 }, /* (350) compare_op ::= NK_GT */
  {  321,   -1 }, /* (351) compare_op ::= NK_LE */
  {  321,   -1 }, /* (352) compare_op ::= NK_GE */
  {  321,   -1 }, /* (353) compare_op ::= NK_NE */
  {  321,   -1 }, /* (354) compare_op ::= NK_EQ */
  {  321,   -1 }, /* (355) compare_op ::= LIKE */
  {  321,   -2 }, /* (356) compare_op ::= NOT LIKE */
  {  321,   -1 }, /* (357) compare_op ::= MATCH */
  {  321,   -1 }, /* (358) compare_op ::= NMATCH */
  {  321,   -1 }, /* (359) compare_op ::= CONTAINS */
  {  322,   -1 }, /* (360) in_op ::= IN */
  {  322,   -2 }, /* (361) in_op ::= NOT IN */
  {  323,   -3 }, /* (362) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  324,   -1 }, /* (363) boolean_value_expression ::= boolean_primary */
  {  324,   -2 }, /* (364) boolean_value_expression ::= NOT boolean_primary */
  {  324,   -3 }, /* (365) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  324,   -3 }, /* (366) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  325,   -1 }, /* (367) boolean_primary ::= predicate */
  {  325,   -3 }, /* (368) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  326,   -1 }, /* (369) common_expression ::= expression */
  {  326,   -1 }, /* (370) common_expression ::= boolean_value_expression */
  {  327,   -2 }, /* (371) from_clause ::= FROM table_reference_list */
  {  328,   -1 }, /* (372) table_reference_list ::= table_reference */
  {  328,   -3 }, /* (373) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  329,   -1 }, /* (374) table_reference ::= table_primary */
  {  329,   -1 }, /* (375) table_reference ::= joined_table */
  {  330,   -2 }, /* (376) table_primary ::= table_name alias_opt */
  {  330,   -4 }, /* (377) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  330,   -2 }, /* (378) table_primary ::= subquery alias_opt */
  {  330,   -1 }, /* (379) table_primary ::= parenthesized_joined_table */
  {  332,    0 }, /* (380) alias_opt ::= */
  {  332,   -1 }, /* (381) alias_opt ::= table_alias */
  {  332,   -2 }, /* (382) alias_opt ::= AS table_alias */
  {  333,   -3 }, /* (383) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  333,   -3 }, /* (384) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  331,   -6 }, /* (385) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  334,    0 }, /* (386) join_type ::= */
  {  334,   -1 }, /* (387) join_type ::= INNER */
  {  336,   -9 }, /* (388) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  337,    0 }, /* (389) set_quantifier_opt ::= */
  {  337,   -1 }, /* (390) set_quantifier_opt ::= DISTINCT */
  {  337,   -1 }, /* (391) set_quantifier_opt ::= ALL */
  {  338,   -1 }, /* (392) select_list ::= NK_STAR */
  {  338,   -1 }, /* (393) select_list ::= select_sublist */
  {  344,   -1 }, /* (394) select_sublist ::= select_item */
  {  344,   -3 }, /* (395) select_sublist ::= select_sublist NK_COMMA select_item */
  {  345,   -1 }, /* (396) select_item ::= common_expression */
  {  345,   -2 }, /* (397) select_item ::= common_expression column_alias */
  {  345,   -3 }, /* (398) select_item ::= common_expression AS column_alias */
  {  345,   -3 }, /* (399) select_item ::= table_name NK_DOT NK_STAR */
  {  339,    0 }, /* (400) where_clause_opt ::= */
  {  339,   -2 }, /* (401) where_clause_opt ::= WHERE search_condition */
  {  340,    0 }, /* (402) partition_by_clause_opt ::= */
  {  340,   -3 }, /* (403) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  341,    0 }, /* (404) twindow_clause_opt ::= */
  {  341,   -6 }, /* (405) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  341,   -4 }, /* (406) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  341,   -6 }, /* (407) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  341,   -8 }, /* (408) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  292,    0 }, /* (409) sliding_opt ::= */
  {  292,   -4 }, /* (410) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  346,    0 }, /* (411) fill_opt ::= */
  {  346,   -4 }, /* (412) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  346,   -6 }, /* (413) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  347,   -1 }, /* (414) fill_mode ::= NONE */
  {  347,   -1 }, /* (415) fill_mode ::= PREV */
  {  347,   -1 }, /* (416) fill_mode ::= NULL */
  {  347,   -1 }, /* (417) fill_mode ::= LINEAR */
  {  347,   -1 }, /* (418) fill_mode ::= NEXT */
  {  342,    0 }, /* (419) group_by_clause_opt ::= */
  {  342,   -3 }, /* (420) group_by_clause_opt ::= GROUP BY group_by_list */
  {  348,   -1 }, /* (421) group_by_list ::= expression */
  {  348,   -3 }, /* (422) group_by_list ::= group_by_list NK_COMMA expression */
  {  343,    0 }, /* (423) having_clause_opt ::= */
  {  343,   -2 }, /* (424) having_clause_opt ::= HAVING search_condition */
  {  297,   -4 }, /* (425) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  349,   -1 }, /* (426) query_expression_body ::= query_primary */
  {  349,   -4 }, /* (427) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  349,   -3 }, /* (428) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  353,   -1 }, /* (429) query_primary ::= query_specification */
  {  353,   -6 }, /* (430) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  350,    0 }, /* (431) order_by_clause_opt ::= */
  {  350,   -3 }, /* (432) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  351,    0 }, /* (433) slimit_clause_opt ::= */
  {  351,   -2 }, /* (434) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  351,   -4 }, /* (435) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  351,   -4 }, /* (436) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  352,    0 }, /* (437) limit_clause_opt ::= */
  {  352,   -2 }, /* (438) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  352,   -4 }, /* (439) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  352,   -4 }, /* (440) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  314,   -3 }, /* (441) subquery ::= NK_LP query_expression NK_RP */
  {  335,   -1 }, /* (442) search_condition ::= common_expression */
  {  354,   -1 }, /* (443) sort_specification_list ::= sort_specification */
  {  354,   -3 }, /* (444) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  355,   -3 }, /* (445) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  356,    0 }, /* (446) ordering_specification_opt ::= */
  {  356,   -1 }, /* (447) ordering_specification_opt ::= ASC */
  {  356,   -1 }, /* (448) ordering_specification_opt ::= DESC */
  {  357,    0 }, /* (449) null_ordering_opt ::= */
  {  357,   -2 }, /* (450) null_ordering_opt ::= NULLS FIRST */
  {  357,   -2 }, /* (451) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,239,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,240,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,239,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,241,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,242,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,240,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,242,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,241,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy105, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy105, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy105); }
        break;
      case 28: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy593, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105); }
        break;
      case 29: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy593, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105); }
        break;
      case 30: /* privileges ::= ALL */
{ yymsp[0].minor.yy593 = PRIVILEGE_TYPE_ALL; }
        break;
      case 31: /* privileges ::= priv_type_list */
      case 32: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==32);
{ yylhsminor.yy593 = yymsp[0].minor.yy593; }
  yymsp[0].minor.yy593 = yylhsminor.yy593;
        break;
      case 33: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy593 = yymsp[-2].minor.yy593 | yymsp[0].minor.yy593; }
  yymsp[-2].minor.yy593 = yylhsminor.yy593;
        break;
      case 34: /* priv_type ::= READ */
{ yymsp[0].minor.yy593 = PRIVILEGE_TYPE_READ; }
        break;
      case 35: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy593 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 36: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy105 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy105 = yylhsminor.yy105;
        break;
      case 37: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy105 = yymsp[-2].minor.yy105; }
  yymsp[-2].minor.yy105 = yylhsminor.yy105;
        break;
      case 38: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy105, NULL); }
        break;
      case 39: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy0); }
        break;
      case 40: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy105); }
        break;
      case 42: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 43: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 45: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 46: /* dnode_endpoint ::= NK_STRING */
      case 47: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==47);
      case 48: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==48);
      case 288: /* db_name ::= NK_ID */ yytestcase(yyruleno==288);
      case 289: /* table_name ::= NK_ID */ yytestcase(yyruleno==289);
      case 290: /* column_name ::= NK_ID */ yytestcase(yyruleno==290);
      case 291: /* function_name ::= NK_ID */ yytestcase(yyruleno==291);
      case 292: /* table_alias ::= NK_ID */ yytestcase(yyruleno==292);
      case 293: /* column_alias ::= NK_ID */ yytestcase(yyruleno==293);
      case 294: /* user_name ::= NK_ID */ yytestcase(yyruleno==294);
      case 295: /* index_name ::= NK_ID */ yytestcase(yyruleno==295);
      case 296: /* topic_name ::= NK_ID */ yytestcase(yyruleno==296);
      case 297: /* stream_name ::= NK_ID */ yytestcase(yyruleno==297);
      case 330: /* noarg_func ::= NOW */ yytestcase(yyruleno==330);
      case 331: /* noarg_func ::= TODAY */ yytestcase(yyruleno==331);
      case 332: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==332);
      case 333: /* star_func ::= COUNT */ yytestcase(yyruleno==333);
      case 334: /* star_func ::= FIRST */ yytestcase(yyruleno==334);
      case 335: /* star_func ::= LAST */ yytestcase(yyruleno==335);
      case 336: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==336);
{ yylhsminor.yy105 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy105 = yylhsminor.yy105;
        break;
      case 49: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 52: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 53: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy617, &yymsp[-1].minor.yy105, yymsp[0].minor.yy172); }
        break;
      case 60: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy617, &yymsp[0].minor.yy105); }
        break;
      case 61: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy105); }
        break;
      case 62: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy105, yymsp[0].minor.yy172); }
        break;
      case 63: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy617 = true; }
        break;
      case 64: /* not_exists_opt ::= */
      case 66: /* exists_opt ::= */ yytestcase(yyruleno==66);
      case 234: /* analyze_opt ::= */ yytestcase(yyruleno==234);
      case 242: /* agg_func_opt ::= */ yytestcase(yyruleno==242);
      case 389: /* set_quantifier_opt ::= */ yytestcase(yyruleno==389);
{ yymsp[1].minor.yy617 = false; }
        break;
      case 65: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy617 = true; }
        break;
      case 67: /* db_options ::= */
{ yymsp[1].minor.yy172 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 68: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 69: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 70: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 71: /* db_options ::= db_options DAYS NK_INTEGER */
      case 72: /* db_options ::= db_options DAYS NK_VARIABLE */ yytestcase(yyruleno==72);
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 73: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 74: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 75: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 76: /* db_options ::= db_options KEEP integer_list */
      case 77: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==77);
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_KEEP, yymsp[0].minor.yy60); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 78: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 79: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 80: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 81: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 82: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 83: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 84: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 85: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 86: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_RETENTIONS, yymsp[0].minor.yy60); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 87: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy172 = createAlterDatabaseOptions(pCxt); yylhsminor.yy172 = setAlterDatabaseOption(pCxt, yylhsminor.yy172, &yymsp[0].minor.yy609); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 88: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy172 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy172, &yymsp[0].minor.yy609); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 89: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 90: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 91: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 92: /* alter_db_option ::= KEEP integer_list */
      case 93: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==93);
{ yymsp[-1].minor.yy609.type = DB_OPTION_KEEP; yymsp[-1].minor.yy609.pList = yymsp[0].minor.yy60; }
        break;
      case 94: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_PAGES; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 95: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_STRICT; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_WAL; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 98: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy60 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 99: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 261: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==261);
{ yylhsminor.yy60 = addNodeToList(pCxt, yymsp[-2].minor.yy60, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy60 = yylhsminor.yy60;
        break;
      case 100: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy60 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 101: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy60 = addNodeToList(pCxt, yymsp[-2].minor.yy60, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy60 = yylhsminor.yy60;
        break;
      case 102: /* retention_list ::= retention */
      case 122: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==122);
      case 125: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==125);
      case 132: /* column_def_list ::= column_def */ yytestcase(yyruleno==132);
      case 173: /* col_name_list ::= col_name */ yytestcase(yyruleno==173);
      case 211: /* func_name_list ::= func_name */ yytestcase(yyruleno==211);
      case 220: /* func_list ::= func */ yytestcase(yyruleno==220);
      case 286: /* literal_list ::= signed_literal */ yytestcase(yyruleno==286);
      case 339: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==339);
      case 394: /* select_sublist ::= select_item */ yytestcase(yyruleno==394);
      case 443: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==443);
{ yylhsminor.yy60 = createNodeList(pCxt, yymsp[0].minor.yy172); }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 103: /* retention_list ::= retention_list NK_COMMA retention */
      case 133: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==133);
      case 174: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==174);
      case 212: /* func_name_list ::= func_name_list NK_COMMA func_name */ yytestcase(yyruleno==212);
      case 221: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==221);
      case 287: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==287);
      case 340: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==340);
      case 395: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==395);
      case 444: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==444);
{ yylhsminor.yy60 = addNodeToList(pCxt, yymsp[-2].minor.yy60, yymsp[0].minor.yy172); }
  yymsp[-2].minor.yy60 = yylhsminor.yy60;
        break;
      case 104: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy172 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 105: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 107: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==107);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy617, yymsp[-5].minor.yy172, yymsp[-3].minor.yy60, yymsp[-1].minor.yy60, yymsp[0].minor.yy172); }
        break;
      case 106: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy60); }
        break;
      case 108: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy60); }
        break;
      case 109: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy617, yymsp[0].minor.yy172); }
        break;
      case 110: /* cmd ::= ALTER TABLE alter_table_clause */
      case 111: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==111);
      case 263: /* cmd ::= query_expression */ yytestcase(yyruleno==263);
{ pCxt->pRootNode = yymsp[0].minor.yy172; }
        break;
      case 112: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy172 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy172, yymsp[0].minor.yy172); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 113: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy172 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy172, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy105, yymsp[0].minor.yy248); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 114: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy172 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy172, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy105); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 115: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy172 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy172, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy105, yymsp[0].minor.yy248); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 116: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy172 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy172, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy105, &yymsp[0].minor.yy105); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 117: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy172 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy172, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy105, yymsp[0].minor.yy248); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 118: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy172 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy172, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy105); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 119: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy172 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy172, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy105, yymsp[0].minor.yy248); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 120: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy172 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy172, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy105, &yymsp[0].minor.yy105); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 121: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy172 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy172, &yymsp[-2].minor.yy105, yymsp[0].minor.yy172); }
  yymsp[-5].minor.yy172 = yylhsminor.yy172;
        break;
      case 123: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 126: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==126);
{ yylhsminor.yy60 = addNodeToList(pCxt, yymsp[-1].minor.yy60, yymsp[0].minor.yy172); }
  yymsp[-1].minor.yy60 = yylhsminor.yy60;
        break;
      case 124: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy172 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy617, yymsp[-8].minor.yy172, yymsp[-6].minor.yy172, yymsp[-5].minor.yy60, yymsp[-2].minor.yy60, yymsp[0].minor.yy172); }
  yymsp[-9].minor.yy172 = yylhsminor.yy172;
        break;
      case 127: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy172 = createDropTableClause(pCxt, yymsp[-1].minor.yy617, yymsp[0].minor.yy172); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 128: /* specific_tags_opt ::= */
      case 159: /* tags_def_opt ::= */ yytestcase(yyruleno==159);
      case 402: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==402);
      case 419: /* group_by_clause_opt ::= */ yytestcase(yyruleno==419);
      case 431: /* order_by_clause_opt ::= */ yytestcase(yyruleno==431);
{ yymsp[1].minor.yy60 = NULL; }
        break;
      case 129: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy60 = yymsp[-1].minor.yy60; }
        break;
      case 130: /* full_table_name ::= table_name */
{ yylhsminor.yy172 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy105, NULL); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 131: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy172 = createRealTableNode(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105, NULL); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 134: /* column_def ::= column_name type_name */
{ yylhsminor.yy172 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy105, yymsp[0].minor.yy248, NULL); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 135: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy172 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy105, yymsp[-2].minor.yy248, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 136: /* type_name ::= BOOL */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 137: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 138: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 139: /* type_name ::= INT */
      case 140: /* type_name ::= INTEGER */ yytestcase(yyruleno==140);
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 141: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 142: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 143: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 144: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy248 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 145: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 146: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy248 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 147: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy248 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 148: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy248 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 149: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy248 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 150: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy248 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 151: /* type_name ::= JSON */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 152: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy248 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 153: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 154: /* type_name ::= BLOB */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 155: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy248 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 156: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 157: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy248 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 158: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy248 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 160: /* tags_def_opt ::= tags_def */
      case 338: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==338);
      case 393: /* select_list ::= select_sublist */ yytestcase(yyruleno==393);
{ yylhsminor.yy60 = yymsp[0].minor.yy60; }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 161: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy60 = yymsp[-1].minor.yy60; }
        break;
      case 162: /* table_options ::= */
{ yymsp[1].minor.yy172 = createDefaultTableOptions(pCxt); }
        break;
      case 163: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy172 = setTableOption(pCxt, yymsp[-2].minor.yy172, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 164: /* table_options ::= table_options DELAY NK_INTEGER */
{ yylhsminor.yy172 = setTableOption(pCxt, yymsp[-2].minor.yy172, TABLE_OPTION_DELAY, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 165: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ yylhsminor.yy172 = setTableOption(pCxt, yymsp[-2].minor.yy172, TABLE_OPTION_FILE_FACTOR, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 166: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ yylhsminor.yy172 = setTableOption(pCxt, yymsp[-4].minor.yy172, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy60); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 167: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy172 = setTableOption(pCxt, yymsp[-2].minor.yy172, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 168: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy172 = setTableOption(pCxt, yymsp[-4].minor.yy172, TABLE_OPTION_SMA, yymsp[-1].minor.yy60); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 169: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy172 = createAlterTableOptions(pCxt); yylhsminor.yy172 = setTableOption(pCxt, yylhsminor.yy172, yymsp[0].minor.yy609.type, &yymsp[0].minor.yy609.val); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 170: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy172 = setTableOption(pCxt, yymsp[-1].minor.yy172, yymsp[0].minor.yy609.type, &yymsp[0].minor.yy609.val); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 171: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy609.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 172: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy609.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 175: /* col_name ::= column_name */
{ yylhsminor.yy172 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy105); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 176: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 177: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 178: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 179: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 180: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 181: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy172, NULL); }
        break;
      case 182: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 183: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 184: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 185: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 186: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 187: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 188: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 189: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 190: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 191: /* cmd ::= SHOW LICENCE */
      case 192: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==192);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 193: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy105); }
        break;
      case 194: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy172); }
        break;
      case 195: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy172); }
        break;
      case 196: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 197: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 198: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 199: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 200: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 201: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 202: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT, NULL, NULL); }
        break;
      case 203: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT, NULL, NULL); }
        break;
      case 204: /* db_name_cond_opt ::= */
      case 209: /* from_db_opt ::= */ yytestcase(yyruleno==209);
{ yymsp[1].minor.yy172 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 205: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy105); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 206: /* like_pattern_opt ::= */
      case 217: /* index_options ::= */ yytestcase(yyruleno==217);
      case 248: /* into_opt ::= */ yytestcase(yyruleno==248);
      case 400: /* where_clause_opt ::= */ yytestcase(yyruleno==400);
      case 404: /* twindow_clause_opt ::= */ yytestcase(yyruleno==404);
      case 409: /* sliding_opt ::= */ yytestcase(yyruleno==409);
      case 411: /* fill_opt ::= */ yytestcase(yyruleno==411);
      case 423: /* having_clause_opt ::= */ yytestcase(yyruleno==423);
      case 433: /* slimit_clause_opt ::= */ yytestcase(yyruleno==433);
      case 437: /* limit_clause_opt ::= */ yytestcase(yyruleno==437);
{ yymsp[1].minor.yy172 = NULL; }
        break;
      case 207: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 208: /* table_name_cond ::= table_name */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy105); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 210: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy105); }
        break;
      case 213: /* func_name ::= function_name */
{ yylhsminor.yy172 = createFunctionNode(pCxt, &yymsp[0].minor.yy105, NULL); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 214: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy617, &yymsp[-3].minor.yy105, &yymsp[-1].minor.yy105, NULL, yymsp[0].minor.yy172); }
        break;
      case 215: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy617, &yymsp[-5].minor.yy105, &yymsp[-3].minor.yy105, yymsp[-1].minor.yy60, NULL); }
        break;
      case 216: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy617, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105); }
        break;
      case 218: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy172 = createIndexOption(pCxt, yymsp[-6].minor.yy60, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), NULL, yymsp[0].minor.yy172); }
        break;
      case 219: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy172 = createIndexOption(pCxt, yymsp[-8].minor.yy60, releaseRawExprNode(pCxt, yymsp[-4].minor.yy172), releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), yymsp[0].minor.yy172); }
        break;
      case 222: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy172 = createFunctionNode(pCxt, &yymsp[-3].minor.yy105, yymsp[-1].minor.yy60); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 223: /* cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy617, &yymsp[-3].minor.yy105, yymsp[0].minor.yy172, NULL, yymsp[-2].minor.yy172); }
        break;
      case 224: /* cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy617, &yymsp[-3].minor.yy105, NULL, &yymsp[0].minor.yy105, yymsp[-2].minor.yy172); }
        break;
      case 225: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy617, &yymsp[0].minor.yy105); }
        break;
      case 226: /* topic_options ::= */
{ yymsp[1].minor.yy172 = createTopicOptions(pCxt); }
        break;
      case 227: /* topic_options ::= topic_options WITH TABLE */
{ ((STopicOptions*)yymsp[-2].minor.yy172)->withTable = true; yylhsminor.yy172 = yymsp[-2].minor.yy172; }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 228: /* topic_options ::= topic_options WITH SCHEMA */
{ ((STopicOptions*)yymsp[-2].minor.yy172)->withSchema = true; yylhsminor.yy172 = yymsp[-2].minor.yy172; }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 229: /* topic_options ::= topic_options WITH TAG */
{ ((STopicOptions*)yymsp[-2].minor.yy172)->withTag = true; yylhsminor.yy172 = yymsp[-2].minor.yy172; }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 230: /* cmd ::= DESC full_table_name */
      case 231: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==231);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy172); }
        break;
      case 232: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 233: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy617, yymsp[-1].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 235: /* analyze_opt ::= ANALYZE */
      case 243: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==243);
      case 390: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==390);
{ yymsp[0].minor.yy617 = true; }
        break;
      case 236: /* explain_options ::= */
{ yymsp[1].minor.yy172 = createDefaultExplainOptions(pCxt); }
        break;
      case 237: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy172 = setExplainVerbose(pCxt, yymsp[-2].minor.yy172, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 238: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy172 = setExplainRatio(pCxt, yymsp[-2].minor.yy172, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 239: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy60); }
        break;
      case 240: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy617, yymsp[-8].minor.yy617, &yymsp[-5].minor.yy105, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy248, yymsp[0].minor.yy140); }
        break;
      case 241: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy617, &yymsp[0].minor.yy105); }
        break;
      case 244: /* bufsize_opt ::= */
{ yymsp[1].minor.yy140 = 0; }
        break;
      case 245: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy140 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 246: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy617, &yymsp[-4].minor.yy105, yymsp[-2].minor.yy172, yymsp[-3].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 247: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy617, &yymsp[0].minor.yy105); }
        break;
      case 249: /* into_opt ::= INTO full_table_name */
      case 371: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==371);
      case 401: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==401);
      case 424: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==424);
{ yymsp[-1].minor.yy172 = yymsp[0].minor.yy172; }
        break;
      case 250: /* stream_options ::= */
{ yymsp[1].minor.yy172 = createStreamOptions(pCxt); }
        break;
      case 251: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy172)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy172 = yymsp[-2].minor.yy172; }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 252: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy172)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy172 = yymsp[-2].minor.yy172; }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 253: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy172)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy172); yylhsminor.yy172 = yymsp[-2].minor.yy172; }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 254: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 255: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 256: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 257: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 258: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy60); }
        break;
      case 259: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 260: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy60 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 262: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy105); }
        break;
      case 264: /* literal ::= NK_INTEGER */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 265: /* literal ::= NK_FLOAT */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 266: /* literal ::= NK_STRING */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 267: /* literal ::= NK_BOOL */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 268: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 269: /* literal ::= duration_literal */
      case 279: /* signed_literal ::= signed */ yytestcase(yyruleno==279);
      case 298: /* expression ::= literal */ yytestcase(yyruleno==298);
      case 299: /* expression ::= pseudo_column */ yytestcase(yyruleno==299);
      case 300: /* expression ::= column_reference */ yytestcase(yyruleno==300);
      case 301: /* expression ::= function_expression */ yytestcase(yyruleno==301);
      case 302: /* expression ::= subquery */ yytestcase(yyruleno==302);
      case 327: /* function_expression ::= literal_func */ yytestcase(yyruleno==327);
      case 363: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==363);
      case 367: /* boolean_primary ::= predicate */ yytestcase(yyruleno==367);
      case 369: /* common_expression ::= expression */ yytestcase(yyruleno==369);
      case 370: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==370);
      case 372: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==372);
      case 374: /* table_reference ::= table_primary */ yytestcase(yyruleno==374);
      case 375: /* table_reference ::= joined_table */ yytestcase(yyruleno==375);
      case 379: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==379);
      case 426: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==426);
      case 429: /* query_primary ::= query_specification */ yytestcase(yyruleno==429);
{ yylhsminor.yy172 = yymsp[0].minor.yy172; }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 270: /* literal ::= NULL */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 271: /* literal ::= NK_QUESTION */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 272: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 273: /* signed ::= NK_INTEGER */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 274: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 275: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 276: /* signed ::= NK_FLOAT */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 277: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 278: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 280: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 281: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 282: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 283: /* signed_literal ::= duration_literal */
      case 285: /* signed_literal ::= literal_func */ yytestcase(yyruleno==285);
      case 341: /* star_func_para ::= expression */ yytestcase(yyruleno==341);
      case 396: /* select_item ::= common_expression */ yytestcase(yyruleno==396);
      case 442: /* search_condition ::= common_expression */ yytestcase(yyruleno==442);
{ yylhsminor.yy172 = releaseRawExprNode(pCxt, yymsp[0].minor.yy172); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 284: /* signed_literal ::= NULL */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 303: /* expression ::= NK_LP expression NK_RP */
      case 368: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==368);
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy172)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 304: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy172));
                                                                                  }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 305: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy172), NULL));
                                                                                  }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 306: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172))); 
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 307: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172))); 
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 308: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172))); 
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 309: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172))); 
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 310: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172))); 
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 311: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 312: /* expression_list ::= expression */
{ yylhsminor.yy60 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy172)); }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 313: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy60 = addNodeToList(pCxt, yymsp[-2].minor.yy60, releaseRawExprNode(pCxt, yymsp[0].minor.yy172)); }
  yymsp[-2].minor.yy60 = yylhsminor.yy60;
        break;
      case 314: /* column_reference ::= column_name */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy105, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy105)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 315: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105, createColumnNode(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 316: /* pseudo_column ::= ROWTS */
      case 317: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==317);
      case 319: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==319);
      case 320: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==320);
      case 321: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==321);
      case 322: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==322);
      case 323: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==323);
      case 329: /* literal_func ::= NOW */ yytestcase(yyruleno==329);
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 318: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy105)))); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 324: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 325: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==325);
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy105, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy105, yymsp[-1].minor.yy60)); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 326: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy172), yymsp[-1].minor.yy248)); }
  yymsp[-5].minor.yy172 = yylhsminor.yy172;
        break;
      case 328: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy105, NULL)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 337: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy60 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 342: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 399: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==399);
{ yylhsminor.yy172 = createColumnNode(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 343: /* predicate ::= expression compare_op expression */
      case 348: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==348);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy572, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172)));
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 344: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy172), releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172)));
                                                                                  }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 345: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy172), releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172)));
                                                                                  }
  yymsp[-5].minor.yy172 = yylhsminor.yy172;
        break;
      case 346: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), NULL));
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 347: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy172), NULL));
                                                                                  }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 349: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy572 = OP_TYPE_LOWER_THAN; }
        break;
      case 350: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy572 = OP_TYPE_GREATER_THAN; }
        break;
      case 351: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy572 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 352: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy572 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 353: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy572 = OP_TYPE_NOT_EQUAL; }
        break;
      case 354: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy572 = OP_TYPE_EQUAL; }
        break;
      case 355: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy572 = OP_TYPE_LIKE; }
        break;
      case 356: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy572 = OP_TYPE_NOT_LIKE; }
        break;
      case 357: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy572 = OP_TYPE_MATCH; }
        break;
      case 358: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy572 = OP_TYPE_NMATCH; }
        break;
      case 359: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy572 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 360: /* in_op ::= IN */
{ yymsp[0].minor.yy572 = OP_TYPE_IN; }
        break;
      case 361: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy572 = OP_TYPE_NOT_IN; }
        break;
      case 362: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy60)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 364: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy172), NULL));
                                                                                  }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 365: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172)));
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 366: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172)));
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 373: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy172 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy172, yymsp[0].minor.yy172, NULL); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 376: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy172 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy105, &yymsp[0].minor.yy105); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 377: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy172 = createRealTableNode(pCxt, &yymsp[-3].minor.yy105, &yymsp[-1].minor.yy105, &yymsp[0].minor.yy105); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 378: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy172 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy172), &yymsp[0].minor.yy105); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 380: /* alias_opt ::= */
{ yymsp[1].minor.yy105 = nil_token;  }
        break;
      case 381: /* alias_opt ::= table_alias */
{ yylhsminor.yy105 = yymsp[0].minor.yy105; }
  yymsp[0].minor.yy105 = yylhsminor.yy105;
        break;
      case 382: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy105 = yymsp[0].minor.yy105; }
        break;
      case 383: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 384: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==384);
{ yymsp[-2].minor.yy172 = yymsp[-1].minor.yy172; }
        break;
      case 385: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy172 = createJoinTableNode(pCxt, yymsp[-4].minor.yy636, yymsp[-5].minor.yy172, yymsp[-2].minor.yy172, yymsp[0].minor.yy172); }
  yymsp[-5].minor.yy172 = yylhsminor.yy172;
        break;
      case 386: /* join_type ::= */
{ yymsp[1].minor.yy636 = JOIN_TYPE_INNER; }
        break;
      case 387: /* join_type ::= INNER */
{ yymsp[0].minor.yy636 = JOIN_TYPE_INNER; }
        break;
      case 388: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy172 = createSelectStmt(pCxt, yymsp[-7].minor.yy617, yymsp[-6].minor.yy60, yymsp[-5].minor.yy172);
                                                                                    yymsp[-8].minor.yy172 = addWhereClause(pCxt, yymsp[-8].minor.yy172, yymsp[-4].minor.yy172);
                                                                                    yymsp[-8].minor.yy172 = addPartitionByClause(pCxt, yymsp[-8].minor.yy172, yymsp[-3].minor.yy60);
                                                                                    yymsp[-8].minor.yy172 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy172, yymsp[-2].minor.yy172);
                                                                                    yymsp[-8].minor.yy172 = addGroupByClause(pCxt, yymsp[-8].minor.yy172, yymsp[-1].minor.yy60);
                                                                                    yymsp[-8].minor.yy172 = addHavingClause(pCxt, yymsp[-8].minor.yy172, yymsp[0].minor.yy172);
                                                                                  }
        break;
      case 391: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy617 = false; }
        break;
      case 392: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy60 = NULL; }
        break;
      case 397: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy172 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy172), &yymsp[0].minor.yy105); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 398: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy172 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), &yymsp[0].minor.yy105); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 403: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 420: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==420);
      case 432: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==432);
{ yymsp[-2].minor.yy60 = yymsp[0].minor.yy60; }
        break;
      case 405: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy172 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy172), releaseRawExprNode(pCxt, yymsp[-1].minor.yy172)); }
        break;
      case 406: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy172 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy172)); }
        break;
      case 407: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy172 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy172), NULL, yymsp[-1].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 408: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy172 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy172), releaseRawExprNode(pCxt, yymsp[-3].minor.yy172), yymsp[-1].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 410: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy172 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy172); }
        break;
      case 412: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy172 = createFillNode(pCxt, yymsp[-1].minor.yy202, NULL); }
        break;
      case 413: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy172 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy60)); }
        break;
      case 414: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy202 = FILL_MODE_NONE; }
        break;
      case 415: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy202 = FILL_MODE_PREV; }
        break;
      case 416: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy202 = FILL_MODE_NULL; }
        break;
      case 417: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy202 = FILL_MODE_LINEAR; }
        break;
      case 418: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy202 = FILL_MODE_NEXT; }
        break;
      case 421: /* group_by_list ::= expression */
{ yylhsminor.yy60 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy172))); }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 422: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy60 = addNodeToList(pCxt, yymsp[-2].minor.yy60, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy172))); }
  yymsp[-2].minor.yy60 = yylhsminor.yy60;
        break;
      case 425: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy172 = addOrderByClause(pCxt, yymsp[-3].minor.yy172, yymsp[-2].minor.yy60);
                                                                                    yylhsminor.yy172 = addSlimitClause(pCxt, yylhsminor.yy172, yymsp[-1].minor.yy172);
                                                                                    yylhsminor.yy172 = addLimitClause(pCxt, yylhsminor.yy172, yymsp[0].minor.yy172);
                                                                                  }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 427: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy172 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy172, yymsp[0].minor.yy172); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 428: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy172 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy172, yymsp[0].minor.yy172); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 430: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy172 = yymsp[-4].minor.yy172; }
  yy_destructor(yypParser,350,&yymsp[-3].minor);
  yy_destructor(yypParser,351,&yymsp[-2].minor);
  yy_destructor(yypParser,352,&yymsp[-1].minor);
        break;
      case 434: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 438: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==438);
{ yymsp[-1].minor.yy172 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 435: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 439: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==439);
{ yymsp[-3].minor.yy172 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 436: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 440: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==440);
{ yymsp[-3].minor.yy172 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 441: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy172); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 445: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy172 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), yymsp[-1].minor.yy14, yymsp[0].minor.yy17); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 446: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy14 = ORDER_ASC; }
        break;
      case 447: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy14 = ORDER_ASC; }
        break;
      case 448: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy14 = ORDER_DESC; }
        break;
      case 449: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy17 = NULL_ORDER_DEFAULT; }
        break;
      case 450: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy17 = NULL_ORDER_FIRST; }
        break;
      case 451: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy17 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
