/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 457
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOperatorType yy20;
  int8_t yy33;
  SAlterOption yy123;
  SNode* yy148;
  SToken yy199;
  EFillMode yy334;
  bool yy397;
  SNodeList* yy404;
  EJoinType yy470;
  ENullOrder yy499;
  int64_t yy525;
  SDataType yy530;
  int32_t yy706;
  EOrder yy898;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             708
#define YYNRULE              538
#define YYNTOKEN             322
#define YY_MAX_SHIFT         707
#define YY_MIN_SHIFTREDUCE   1048
#define YY_MAX_SHIFTREDUCE   1585
#define YY_ERROR_ACTION      1586
#define YY_ACCEPT_ACTION     1587
#define YY_NO_ACTION         1588
#define YY_MIN_REDUCE        1589
#define YY_MAX_REDUCE        2126
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2706)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   458, 1795,  459, 1625, 1838, 1733, 1587,  467,  353,  459,
 /*    10 */  1625, 1632,   43,   41, 1516,  181, 1925, 1793, 1731,  399,
 /*    20 */   360,   62, 1367,   36,   35, 1081, 1960,   42,   40,   39,
 /*    30 */    38,   37,  167, 1446,  559, 1365, 1658,   42,   40,   39,
 /*    40 */    38,   37,   36,   35, 1921, 1927,   42,   40,   39,   38,
 /*    50 */    37,   33,  274,  332, 1842,  607,  464,  577, 1441,   25,
 /*    60 */   699,  545,  460,   16, 1083, 2097, 1086, 1087,  597,  375,
 /*    70 */  1373,  365,  596,  558, 1788, 1790,  597, 1942,   97, 1373,
 /*    80 */  2103,  173,  123,   43,   41, 2098,  566, 1929,  131,  497,
 /*    90 */    52,  360,  132, 1367,  596,   12,  560,  325, 1925, 1742,
 /*   100 */  1734,  512,  511,  510, 1446,  352, 1365, 1742, 1960,  128,
 /*   110 */   506,  545,   58,  155,  505, 2097,  580,  704, 1392,  504,
 /*   120 */   509, 1911, 1744,  613,  405,  503, 1921, 1927,  343, 1441,
 /*   130 */  2103,  173, 1448, 1449,   16, 2098,  566,  607, 1475,  457,
 /*   140 */   158, 1373,  462, 1631,  577, 1696, 1941,  172, 2037, 2038,
 /*   150 */  1976,  129, 2042,  100, 1943,  617, 1945, 1946,  612,  565,
 /*   160 */   607, 1422, 1431, 2097,  318,  170,   12, 2029,  476,   46,
 /*   170 */   466,  354, 2025,  462, 1631,  131,  265,  266,  564,  173,
 /*   180 */  1368,  264, 1366, 2098,  566,  175,  337,  526,  704, 1393,
 /*   190 */  1929,   36,   35, 2055, 1476,   42,   40,   39,   38,   37,
 /*   200 */   524, 1925,  522, 1448, 1449, 1371, 1372, 1513, 1421, 1424,
 /*   210 */  1425, 1426, 1427, 1428, 1429, 1430,  609,  605, 1439, 1440,
 /*   220 */  1442, 1443, 1444, 1445, 1447, 1450,    2,   58,   58, 1921,
 /*   230 */  1927,  355, 1422, 1431,  255, 2037,  576, 2101,  124,  575,
 /*   240 */   607,   80, 2097, 1789, 1790,  596,   47,  338, 1392,  336,
 /*   250 */   335, 1368,  499, 1366, 1542,  127,  501,  564,  173, 1303,
 /*   260 */  1304,  176, 2098,  566, 1737,   32,  358, 1470, 1471, 1472,
 /*   270 */  1473, 1474, 1478, 1479, 1480, 1481, 1371, 1372,  500, 1421,
 /*   280 */  1424, 1425, 1426, 1427, 1428, 1429, 1430,  609,  605, 1439,
 /*   290 */  1440, 1442, 1443, 1444, 1445, 1447, 1450,    2, 1612,    9,
 /*   300 */    43,   41,  552, 1540, 1541, 1543, 1544, 1838,  360,  584,
 /*   310 */  1367,  398, 1393,  397, 1100,  157, 1099, 1601,  183,  351,
 /*   320 */    46, 1446, 1853, 1365, 1207,  639,  638,  637, 1211,  636,
 /*   330 */  1213, 1214,  635, 1216,  632, 1590, 1222,  629, 1224, 1225,
 /*   340 */   626,  623, 1911, 1520,  169, 1101, 1441, 1086, 1087, 1392,
 /*   350 */  2102,   16, 2044,  555, 2097,  597,  113, 1782, 1373,  112,
 /*   360 */   111,  110,  109,  108,  107,  106,  105,  104,  394,  178,
 /*   370 */  2101,   43,   41, 1451, 2098, 2100,  176,  176, 2041,  360,
 /*   380 */   185, 1367, 1589,   12, 1942,    9, 1742,    7,  226,  396,
 /*   390 */   392,  577, 1446,  113, 1365,  176,  112,  111,  110,  109,
 /*   400 */   108,  107,  106,  105,  104,  704,  122,  121,  120,  119,
 /*   410 */   118,  117,  116,  115,  114, 1960,   77, 1441,  363,   76,
 /*   420 */  1448, 1449,  131,  614, 1250, 1251,  155, 1611, 1911, 1373,
 /*   430 */   613,   39,   38,   37, 1391, 1744,  561,  556,  227,   36,
 /*   440 */    35, 1772,  597,   42,   40,   39,   38,   37, 1512, 1422,
 /*   450 */  1431, 1344, 1345, 1941,   44,  167,  403, 1976,  225, 1795,
 /*   460 */   100, 1943,  617, 1945, 1946,  612,  329,  607, 1368,  176,
 /*   470 */  1366, 1911, 2117, 1742, 2029, 1793,  704, 1843,  354, 2025,
 /*   480 */  1167,  174, 2037, 2038,  441,  129, 2042,  233, 1610, 2063,
 /*   490 */  1423, 1448, 1449, 1371, 1372,  568, 1421, 1424, 1425, 1426,
 /*   500 */  1427, 1428, 1429, 1430,  609,  605, 1439, 1440, 1442, 1443,
 /*   510 */  1444, 1445, 1447, 1450,    2, 1169,  651,  597,   82,  320,
 /*   520 */  1422, 1431,  530,  707,  528,   91,   83,  512,  511,  510,
 /*   530 */   565,  123, 1911,  642, 2097,  128,  506,  281,  502, 1368,
 /*   540 */   505, 1366,  189,  188,    9,  504,  509, 1735, 1742,  564,
 /*   550 */   173,  503,  166, 1720, 2098,  566,   11,   10,  697,  693,
 /*   560 */   689,  685,  279,  663, 1371, 1372,   80, 1421, 1424, 1425,
 /*   570 */  1426, 1427, 1428, 1429, 1430,  609,  605, 1439, 1440, 1442,
 /*   580 */  1443, 1444, 1445, 1447, 1450,    2,   43,   41, 2102, 1738,
 /*   590 */   133, 1930, 2097, 2000,  360,  211, 1367, 1392,   98, 1609,
 /*   600 */  1718,  272, 1925, 1582,  649, 1727, 1942, 1446, 2101, 1365,
 /*   610 */   162, 1608, 2098, 2099,  572,  476,  493,  489,  485,  481,
 /*   620 */   208, 2044,  577,  146,  145,  646,  645,  644,  143,  258,
 /*   630 */  1921, 1927, 1441, 1795,  593,  508,  507, 1960,  675,  673,
 /*   640 */   364,  607, 1729, 1911, 1373,  614, 1100, 2040, 1099, 1793,
 /*   650 */  1911, 1489,  613,  131,  155, 1911,   81,   43,   41,  206,
 /*   660 */  1367,  210,  651, 1745, 2102,  360,   58, 1367,   85,   44,
 /*   670 */  1725,  260,   58, 1365,  230, 1941,  583, 1101, 1446, 1976,
 /*   680 */  1365, 1394,  100, 1943,  617, 1945, 1946,  612, 1338,  607,
 /*   690 */   229,  704,  134,  608,  141, 2000, 2029, 1581, 1456, 2044,
 /*   700 */   354, 2025,  569, 1441, 1392, 1394, 1448, 1449, 1373, 1838,
 /*   710 */   597,  579,  171, 2037, 2038, 1373,  129, 2042,  545,  540,
 /*   720 */   187, 1607, 2097,  641,  404, 2039,  205,  199, 1606,  204,
 /*   730 */   597, 1392,  472, 1477,  584, 1422, 1431, 2103,  173,   29,
 /*   740 */    12, 1742, 2098,  566,  413,   36,   35, 1854,  197,   42,
 /*   750 */    40,   39,   38,   37, 1368,  704, 1366, 1575, 1605, 2069,
 /*   760 */   144, 1742,  704,   36,   35, 1911, 1602,   42,   40,   39,
 /*   770 */    38,   37, 1911, 1604,  599, 1395, 2001, 1448, 1449, 1371,
 /*   780 */  1372, 1898, 1421, 1424, 1425, 1426, 1427, 1428, 1429, 1430,
 /*   790 */   609,  605, 1439, 1440, 1442, 1443, 1444, 1445, 1447, 1450,
 /*   800 */     2,  317, 1911, 1390,   30, 1603, 1422, 1431,  597,  597,
 /*   810 */   435,  366,   51,  448, 1482,  176,  447, 1911, 1368,  155,
 /*   820 */  1366,  176,  427,  428,  257, 1368, 1655, 1366, 1744,  382,
 /*   830 */  1600,  419, 1599,  449, 1598,  573,  421, 1597, 1596, 1742,
 /*   840 */  1742, 2049, 1509, 1371, 1372, 1423, 1595, 1395,  257, 1911,
 /*   850 */  1371, 1372,  553, 1421, 1424, 1425, 1426, 1427, 1428, 1429,
 /*   860 */  1430,  609,  605, 1439, 1440, 1442, 1443, 1444, 1445, 1447,
 /*   870 */  1450,    2, 1423,  601, 1911, 2001, 1911,  333, 1911,   36,
 /*   880 */    35, 1911, 1911,   42,   40,   39,   38,   37, 1719,  409,
 /*   890 */  1911,  681,  680,  679,  678,  370, 1697,  677,  676,  135,
 /*   900 */   671,  670,  669,  668,  667,  666,  665,  148,  661,  660,
 /*   910 */   659,  369,  368,  656,  655,  654,  653,  652,  235,  445,
 /*   920 */  1594,  570,  440,  439,  438,  437,  434,  433,  432,  431,
 /*   930 */   430,  426,  425,  424,  423,  334,  416,  415,  414,  517,
 /*   940 */   411,  410,  331,  156,  643,   36,   35, 1786,  294,   42,
 /*   950 */    40,   39,   38,   37,  527, 1717,  597, 1593, 1942,    6,
 /*   960 */   597,  252,  292,   66, 1911,   31,   65, 1552,  224,  209,
 /*   970 */   474,   36,   35, 1395,  475,   42,   40,   39,   38,   37,
 /*   980 */   597, 1592,  597,  520,  193,  454,  452, 1742,  514, 1960,
 /*   990 */   182, 1742,  597,  223, 1739,  649,  139,  580,  664,  501,
 /*  1000 */  1712, 1911, 1911,  373,  613,  246,  541,  647, 1795, 1825,
 /*  1010 */  1786, 1742,  597, 1742,  146,  145,  646,  645,  644,  143,
 /*  1020 */    58,  500,   67, 1742, 1794, 1911,  581, 1941,   48,   64,
 /*  1030 */     3, 1976,   63, 1532,  100, 1943,  617, 1945, 1946,  612,
 /*  1040 */   137,  607,  125, 1742,  648,  545,  170, 1786, 2029, 2097,
 /*  1050 */    36,   35,  354, 2025,   42,   40,   39,   38,   37,   99,
 /*  1060 */   406, 1942,  649,  597, 2103,  173,  357,  356,  288, 2098,
 /*  1070 */   566, 1772,   75,  407, 2056,  216, 1381,  269,  214,  597,
 /*  1080 */  1376,  146,  145,  646,  645,  644,  143, 1446,  218, 1374,
 /*  1090 */  1375,  217, 1960,  592, 1742, 1645, 1638,   74,   73,  402,
 /*  1100 */   614,  597,  180,  220, 1942, 1911,  219,  613, 1961,   60,
 /*  1110 */  1742,  222, 1441,  239,  221,  594,  234,  513,  515, 1932,
 /*  1120 */   316,  604,  597,  390, 1373,  388,  384,  380,  377,  374,
 /*  1130 */  1941,  371, 1742,  597, 1976, 1960,  595,  100, 1943,  617,
 /*  1140 */  1945, 1946,  612,  614,  607,  597, 1636,  275, 1911, 2117,
 /*  1150 */   613, 2029,   45, 1742,  372,  354, 2025, 1584, 1585,  367,
 /*  1160 */   422, 1539, 1942, 1509, 1742,  241, 2091, 1934,  518,  176,
 /*  1170 */    50,  603,  262, 1941,  140,  544, 1742, 1976,  142, 1626,
 /*  1180 */   100, 1943,  617, 1945, 1946,  612, 1847,  607,  657,   11,
 /*  1190 */    10,  658, 2117, 1960, 2029,  144,  545,   60,  354, 2025,
 /*  1200 */  2097,  614, 2059,   45, 1314,  154, 1911,   96,  613, 2048,
 /*  1210 */  1148, 1783,   45, 1146,  621, 2103,  173,   93,  142,  533,
 /*  1220 */  2098,  566,  578, 1942,  267,  254,  589, 1379,    4,  251,
 /*  1230 */   271, 1941,  376, 1129, 1382, 1976, 1377, 1378,  100, 1943,
 /*  1240 */   617, 1945, 1946,  612,  381,  607,  144, 1200,    1, 1483,
 /*  1250 */  2004, 1942, 2029,  126, 1960, 1432,  354, 2025,  330, 1385,
 /*  1260 */  1387,  545,  614, 1467,  287, 2097, 1228, 1911, 1130,  613,
 /*  1270 */  1232,  605, 1439, 1440, 1442, 1443, 1444, 1445, 1331,  186,
 /*  1280 */  2103,  173, 1960,  142,  282, 2098,  566,  408, 1395, 1848,
 /*  1290 */   614,  412, 1941,  443, 1390, 1911, 1976,  613, 1239,  100,
 /*  1300 */  1943,  617, 1945, 1946,  612, 1237,  607,  417,  429,  450,
 /*  1310 */  1840, 2002, 1942, 2029,  436,  442,  444,  354, 2025,  451,
 /*  1320 */  1941,  190, 1396,  453, 1976,  455,  456,  100, 1943,  617,
 /*  1330 */  1945, 1946,  612,  465,  607,  147, 1398,  468,  469,  600,
 /*  1340 */   196, 2029,  198, 1960, 1397,  354, 2025,  470, 1399,  201,
 /*  1350 */   471,  614,  473,  203,   78,   79, 1911,  477,  613,  207,
 /*  1360 */  1103,  496,  494,  495,  498, 1942,  103, 1732,  535, 1888,
 /*  1370 */   319, 1887,  534,  213,  532, 1728,  283,  215,  149,  150,
 /*  1380 */   542, 1941, 2075,  228, 1730, 1976, 1726,  151,  101, 1943,
 /*  1390 */   617, 1945, 1946,  612,  231,  607, 1960,  152, 2074,  554,
 /*  1400 */   587,    5, 2029,  539,  614, 2051, 2028, 2025,  549, 1911,
 /*  1410 */   245,  613,  563,  548, 2060, 2070,  550,  551, 1942,  536,
 /*  1420 */   344,  557,  345,  547, 2120,  574,  237,  571,  163,  247,
 /*  1430 */   248,  240,  253,  250, 1941, 1509, 1394,  130, 1976,  249,
 /*  1440 */   582,  101, 1943,  617, 1945, 1946,  612, 2096,  607, 1960,
 /*  1450 */  2045,  348,  259,  284,  585, 2029,  586,  614, 1859,  602,
 /*  1460 */  2025, 1942, 1911, 1858,  613,  285, 1857,  350,  590,   88,
 /*  1470 */   591,  286,   90, 1743,   57,   92,  619, 2010,  289, 1787,
 /*  1480 */   700,  278,  321, 1713,  313,  701,  322,  615,  298,  703,
 /*  1490 */    49, 1976, 1960, 1905,  101, 1943,  617, 1945, 1946,  612,
 /*  1500 */   611,  607,  312, 1904,  291, 1911,   71,  613, 2029,  293,
 /*  1510 */   302, 1903,  324, 2025, 1902,   72, 1899,  378, 1942,  379,
 /*  1520 */  1359, 1360,  179, 1897,  383,  385,  386, 1896,  387,  389,
 /*  1530 */  1941, 1895, 1894,  391, 1976, 1942, 1893,  310, 1943,  617,
 /*  1540 */  1945, 1946,  612,  610,  607,  598, 1994,  393, 1334, 1960,
 /*  1550 */   395, 1333, 1870, 1869,  400, 1868,  401,  614, 1867, 1294,
 /*  1560 */  1833, 1942, 1911, 1832,  613, 1830, 1960,  191,  136, 1829,
 /*  1570 */  1828, 1831, 1827, 1826,  614, 1824, 1823, 1822,  184, 1911,
 /*  1580 */   418,  613, 1821,  420, 1820, 1819, 1818, 1941,  138, 1805,
 /*  1590 */  1804, 1976, 1960, 1817,  159, 1943,  617, 1945, 1946,  612,
 /*  1600 */   614,  607, 1816, 1815, 1941, 1911, 1814,  613, 1976, 1813,
 /*  1610 */  1812,  160, 1943,  617, 1945, 1946,  612, 1811,  607, 1810,
 /*  1620 */  1809, 1942, 1808, 1807, 1806, 1803, 1802, 1801, 1800, 1296,
 /*  1630 */  1941,  446, 1797, 1796, 1976,  546, 2066,  101, 1943,  617,
 /*  1640 */  1945, 1946,  612, 1942,  607, 1799, 1798, 1175, 1660, 1659,
 /*  1650 */   192, 2029, 1960, 1657, 1621,  194, 2026,   69,  168, 1620,
 /*  1660 */   614, 1089, 1931,  567, 2118, 1911, 1883,  613,  461, 1088,
 /*  1670 */   195, 1877, 1866,   70, 1960,  200,  463,  202, 1865, 1850,
 /*  1680 */  1721, 1656,  614, 1654, 1652,  478,  479, 1911,  483,  613,
 /*  1690 */  1941, 1650,  482,  486, 1976,  480, 1648,  159, 1943,  617,
 /*  1700 */  1945, 1946,  612, 1122,  607, 1635,  484, 1942,  487,  488,
 /*  1710 */   490,  491, 1941,  492, 1634, 1617, 1976, 1723,  212,  304,
 /*  1720 */  1943,  617, 1945, 1946,  612, 1244,  607, 1722, 1942, 1243,
 /*  1730 */   672,  674, 1166, 1165, 1164, 1163, 1160, 1159, 1960, 2067,
 /*  1740 */  1158,   59, 1646, 1157,  339, 1639,  614,  340, 1637, 1616,
 /*  1750 */   341, 1911, 1615,  613,  516,  519,  521, 1614,  523, 1960,
 /*  1760 */   525,  102, 1882,  562,  349, 1349, 1348,  614,   53, 1351,
 /*  1770 */   529, 1942, 1911, 1876,  613, 1340, 1941,   24,  153, 1864,
 /*  1780 */  1976,  537, 1862,  160, 1943,  617, 1945, 1946,  612, 2102,
 /*  1790 */   607,   17,   14,  244,   56,  243,   18, 1941,  538, 1554,
 /*  1800 */  1932, 1976, 1960,   61,  311, 1943,  617, 1945, 1946,  612,
 /*  1810 */   611,  607,  543,   28,   26, 1911,  232,  613,   19,  236,
 /*  1820 */  1569,  161, 1942, 1568,  342,  238,  346,   15, 1538,  242,
 /*  1830 */    27, 1573, 1531, 1574,   84, 1863, 2119, 1572, 1942, 1575,
 /*  1840 */  1941,  347,  256,   54, 1976,   55,  164,  310, 1943,  617,
 /*  1850 */  1945, 1946,  612, 1960,  607, 1861, 1995, 1506,  359, 1505,
 /*  1860 */  1860,  614,   20, 1849,  261,  263, 1911, 1536,  613, 1960,
 /*  1870 */   268,   86,  588,   87,  361,  270,   89,  614,  273,   10,
 /*  1880 */    21, 1468, 1911,   93,  613, 1979, 1383,  165, 1436, 1458,
 /*  1890 */  1434, 1941, 1942,    8,  177, 1976, 1457, 1414,  311, 1943,
 /*  1900 */   617, 1945, 1946,  612,  606,  607,   34, 1941, 1433,   13,
 /*  1910 */    22, 1976, 1406, 1942,  311, 1943,  617, 1945, 1946,  612,
 /*  1920 */    23,  607, 1229, 1960,  618,  620,  362,  622,  624, 1226,
 /*  1930 */   627,  614,  625,  630, 1223, 1217, 1911,  628,  613,  631,
 /*  1940 */   616, 1215,  633,  634, 1960, 1206, 1221, 1220, 1219, 1218,
 /*  1950 */   640,   94,  614,  276, 1238, 1234, 1942, 1911, 1120,  613,
 /*  1960 */    95,  531,   68,  650, 1154, 1976, 1153, 1152,  306, 1943,
 /*  1970 */   617, 1945, 1946,  612, 1151,  607, 1150, 1942, 1149, 1147,
 /*  1980 */  1173, 1145, 1941, 1144, 1143, 1141, 1976, 1960,  662,  295,
 /*  1990 */  1943,  617, 1945, 1946,  612,  614,  607,  277, 1140, 1139,
 /*  2000 */  1911, 1138,  613, 1137, 1136, 1135, 1170, 1168, 1960, 1132,
 /*  2010 */  1131, 1128, 1127, 1126, 1653, 1125,  614,  682, 1651,  683,
 /*  2020 */  1942, 1911,  684,  613,  686, 1941,  687, 1649,  690, 1976,
 /*  2030 */  1647,  688,  296, 1943,  617, 1945, 1946,  612, 1942,  607,
 /*  2040 */   692,  694,  691,  695,  696, 1633, 1941,  698, 1078, 1613,
 /*  2050 */  1976, 1960,  702,  297, 1943,  617, 1945, 1946,  612,  614,
 /*  2060 */   607,  280, 1369,  290, 1911,  705,  613, 1588,  706, 1960,
 /*  2070 */  1588, 1588, 1588, 1588, 1588, 1588, 1588,  614, 1588, 1588,
 /*  2080 */  1588, 1588, 1911, 1588,  613, 1588, 1588, 1588, 1588, 1941,
 /*  2090 */  1588, 1588, 1588, 1976, 1588, 1588,  303, 1943,  617, 1945,
 /*  2100 */  1946,  612, 1942,  607, 1588, 1588, 1588, 1941, 1588, 1588,
 /*  2110 */  1588, 1976, 1588, 1588,  307, 1943,  617, 1945, 1946,  612,
 /*  2120 */  1588,  607, 1588, 1942, 1588, 1588, 1588, 1588, 1588, 1588,
 /*  2130 */  1588, 1588, 1588, 1960, 1588, 1588, 1588, 1588, 1588, 1588,
 /*  2140 */  1588,  614, 1588, 1588, 1588, 1588, 1911, 1588,  613, 1588,
 /*  2150 */  1588, 1588, 1588, 1588, 1960, 1588, 1588, 1588, 1588, 1588,
 /*  2160 */  1588, 1588,  614, 1588, 1588, 1588, 1942, 1911, 1588,  613,
 /*  2170 */  1588, 1941, 1588, 1588, 1588, 1976, 1588, 1588,  299, 1943,
 /*  2180 */   617, 1945, 1946,  612, 1942,  607, 1588, 1588, 1588, 1588,
 /*  2190 */  1588, 1588, 1941, 1588, 1588, 1588, 1976, 1960, 1588,  308,
 /*  2200 */  1943,  617, 1945, 1946,  612,  614,  607, 1588, 1588, 1588,
 /*  2210 */  1911, 1588,  613, 1588, 1588, 1960, 1588, 1588, 1588, 1588,
 /*  2220 */  1588, 1588, 1588,  614, 1588, 1588, 1588, 1942, 1911, 1588,
 /*  2230 */   613, 1588, 1588, 1588, 1588, 1941, 1588, 1588, 1588, 1976,
 /*  2240 */  1588, 1588,  300, 1943,  617, 1945, 1946,  612, 1588,  607,
 /*  2250 */  1588, 1588, 1588, 1941, 1588, 1588, 1588, 1976, 1960, 1588,
 /*  2260 */   309, 1943,  617, 1945, 1946,  612,  614,  607, 1588, 1588,
 /*  2270 */  1942, 1911, 1588,  613, 1588, 1588, 1588, 1588, 1588, 1588,
 /*  2280 */  1588, 1588, 1588, 1588, 1588, 1588, 1588, 1942, 1588, 1588,
 /*  2290 */  1588, 1588, 1588, 1588, 1588, 1588, 1941, 1588, 1588, 1588,
 /*  2300 */  1976, 1960, 1588,  301, 1943,  617, 1945, 1946,  612,  614,
 /*  2310 */   607, 1588, 1588, 1942, 1911, 1588,  613, 1588, 1960, 1588,
 /*  2320 */  1588, 1588, 1588, 1588, 1588, 1588,  614, 1588, 1588, 1588,
 /*  2330 */  1588, 1911, 1588,  613, 1588, 1588, 1588, 1588, 1588, 1941,
 /*  2340 */  1588, 1588, 1588, 1976, 1960, 1588,  314, 1943,  617, 1945,
 /*  2350 */  1946,  612,  614,  607, 1588, 1588, 1941, 1911, 1588,  613,
 /*  2360 */  1976, 1588, 1588,  315, 1943,  617, 1945, 1946,  612, 1588,
 /*  2370 */   607, 1588, 1942, 1588, 1588, 1588, 1588, 1588, 1588, 1588,
 /*  2380 */  1588, 1588, 1941, 1588, 1588, 1588, 1976, 1588, 1588, 1954,
 /*  2390 */  1943,  617, 1945, 1946,  612, 1588,  607, 1588, 1588, 1588,
 /*  2400 */  1588, 1588, 1588, 1960, 1588, 1588, 1588, 1588, 1588, 1588,
 /*  2410 */  1588,  614, 1588, 1588, 1588, 1942, 1911, 1588,  613, 1588,
 /*  2420 */  1588, 1588, 1588, 1588, 1588, 1588, 1588, 1588, 1588, 1588,
 /*  2430 */  1588, 1588, 1588, 1942, 1588, 1588, 1588, 1588, 1588, 1588,
 /*  2440 */  1588, 1941, 1588, 1588, 1588, 1976, 1960, 1588, 1953, 1943,
 /*  2450 */   617, 1945, 1946,  612,  614,  607, 1588, 1588, 1588, 1911,
 /*  2460 */  1588,  613, 1588, 1588, 1960, 1588, 1588, 1588, 1588, 1588,
 /*  2470 */  1588, 1588,  614, 1588, 1588, 1588, 1588, 1911, 1588,  613,
 /*  2480 */  1588, 1588, 1588, 1588, 1941, 1588, 1588, 1588, 1976, 1588,
 /*  2490 */  1588, 1952, 1943,  617, 1945, 1946,  612, 1942,  607, 1588,
 /*  2500 */  1588, 1588, 1941, 1588, 1588, 1588, 1976, 1588, 1588,  326,
 /*  2510 */  1943,  617, 1945, 1946,  612, 1588,  607, 1588, 1942, 1588,
 /*  2520 */  1588, 1588, 1588, 1588, 1588, 1588, 1588, 1588, 1960, 1588,
 /*  2530 */  1588, 1588, 1588, 1588, 1588, 1588,  614, 1588, 1588, 1588,
 /*  2540 */  1588, 1911, 1588,  613, 1588, 1588, 1588, 1588, 1588, 1960,
 /*  2550 */  1588, 1588, 1588, 1588, 1588, 1588, 1588,  614, 1588, 1588,
 /*  2560 */  1588, 1942, 1911, 1588,  613, 1588, 1941, 1588, 1588, 1588,
 /*  2570 */  1976, 1588, 1588,  327, 1943,  617, 1945, 1946,  612, 1942,
 /*  2580 */   607, 1588, 1588, 1588, 1588, 1588, 1588, 1941, 1588, 1588,
 /*  2590 */  1588, 1976, 1960, 1588,  323, 1943,  617, 1945, 1946,  612,
 /*  2600 */   614,  607, 1588, 1588, 1588, 1911, 1588,  613, 1588, 1588,
 /*  2610 */  1960, 1588, 1588, 1588, 1588, 1588, 1588, 1588,  614, 1588,
 /*  2620 */  1588, 1588, 1942, 1911, 1588,  613, 1588, 1588, 1588, 1588,
 /*  2630 */  1941, 1588, 1588, 1588, 1976, 1588, 1588,  328, 1943,  617,
 /*  2640 */  1945, 1946,  612, 1588,  607, 1588, 1588, 1588,  615, 1588,
 /*  2650 */  1588, 1588, 1976, 1960, 1588,  306, 1943,  617, 1945, 1946,
 /*  2660 */   612,  614,  607, 1588, 1588, 1588, 1911, 1588,  613, 1588,
 /*  2670 */  1588, 1588, 1588, 1588, 1588, 1588, 1588, 1588, 1588, 1588,
 /*  2680 */  1588, 1588, 1588, 1588, 1588, 1588, 1588, 1588, 1588, 1588,
 /*  2690 */  1588, 1941, 1588, 1588, 1588, 1976, 1588, 1588,  305, 1943,
 /*  2700 */   617, 1945, 1946,  612, 1588,  607,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   329,  356,  331,  332,  364,  358,  322,  329,  363,  331,
 /*    10 */   332,    0,   12,   13,   14,  375,  369,  372,  357,  385,
 /*    20 */    20,    4,   22,    8,    9,    4,  356,   12,   13,   14,
 /*    30 */    15,   16,  356,   33,  364,   35,    0,   12,   13,   14,
 /*    40 */    15,   16,    8,    9,  397,  398,   12,   13,   14,   15,
 /*    50 */    16,  416,  417,  377,  378,  408,   14,  333,   58,   44,
 /*    60 */    49,  427,   20,   63,   43,  431,   45,   46,  333,  385,
 /*    70 */    70,  367,   20,  403,  370,  371,  333,  325,  337,   70,
 /*    80 */   446,  447,  347,   12,   13,  451,  452,  358,  364,  354,
 /*    90 */   347,   20,  351,   22,   20,   95,   20,   63,  369,  364,
 /*   100 */   359,   65,   66,   67,   33,  348,   35,  364,  356,   73,
 /*   110 */    74,  427,   95,  356,   78,  431,  364,  117,   20,   83,
 /*   120 */    84,  369,  365,  371,  333,   89,  397,  398,  399,   58,
 /*   130 */   446,  447,  132,  133,   63,  451,  452,  408,  104,  330,
 /*   140 */   340,   70,  333,  334,  333,  345,  394,  423,  424,  425,
 /*   150 */   398,  427,  428,  401,  402,  403,  404,  405,  406,  427,
 /*   160 */   408,  161,  162,  431,  373,  413,   95,  415,   62,   95,
 /*   170 */   330,  419,  420,  333,  334,  364,  126,  127,  446,  447,
 /*   180 */   180,  131,  182,  451,  452,  433,   37,   21,  117,   20,
 /*   190 */   358,    8,    9,  441,  160,   12,   13,   14,   15,   16,
 /*   200 */    34,  369,   36,  132,  133,  205,  206,    4,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,   95,   95,  397,
 /*   230 */   398,  399,  161,  162,  423,  424,  425,    3,  427,  428,
 /*   240 */   408,  339,  431,  370,  371,   20,   95,   98,   20,  100,
 /*   250 */   101,  180,  103,  182,  205,  353,  107,  446,  447,  161,
 /*   260 */   162,  244,  451,  452,  362,  231,  232,  233,  234,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,  205,  206,  129,  208,
 /*   280 */   209,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   290 */   219,  220,  221,  222,  223,  224,  225,  226,  325,  228,
 /*   300 */    12,   13,  253,  254,  255,  256,  257,  364,   20,  371,
 /*   310 */    22,  179,   20,  181,   20,  324,   22,  326,  375,  381,
 /*   320 */    95,   33,  384,   35,  108,  109,  110,  111,  112,  113,
 /*   330 */   114,  115,  116,  117,  118,    0,  120,  121,  122,  123,
 /*   340 */   124,  125,  369,   14,  355,   51,   58,   45,   46,   20,
 /*   350 */   427,   63,  400,  166,  431,  333,   21,  368,   70,   24,
 /*   360 */    25,   26,   27,   28,   29,   30,   31,   32,  175,  347,
 /*   370 */   447,   12,   13,   14,  451,  452,  244,  244,  426,   20,
 /*   380 */    58,   22,    0,   95,  325,  228,  364,  230,  126,  196,
 /*   390 */   197,  333,   33,   21,   35,  244,   24,   25,   26,   27,
 /*   400 */    28,   29,   30,   31,   32,  117,   24,   25,   26,   27,
 /*   410 */    28,   29,   30,   31,   32,  356,   94,   58,  348,   97,
 /*   420 */   132,  133,  364,  364,  132,  133,  356,  325,  369,   70,
 /*   430 */   371,   14,   15,   16,   20,  365,  249,  250,  349,    8,
 /*   440 */     9,  352,  333,   12,   13,   14,   15,   16,  245,  161,
 /*   450 */   162,  189,  190,  394,   95,  356,  347,  398,  127,  356,
 /*   460 */   401,  402,  403,  404,  405,  406,  363,  408,  180,  244,
 /*   470 */   182,  369,  413,  364,  415,  372,  117,  378,  419,  420,
 /*   480 */    35,  423,  424,  425,   79,  427,  428,   58,  325,  430,
 /*   490 */   161,  132,  133,  205,  206,  261,  208,  209,  210,  211,
 /*   500 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   510 */   222,  223,  224,  225,  226,   70,   62,  333,  187,  188,
 /*   520 */   161,  162,  191,   19,  193,  337,   97,   65,   66,   67,
 /*   530 */   427,  347,  369,  106,  431,   73,   74,   33,  354,  180,
 /*   540 */    78,  182,  137,  138,  228,   83,   84,  359,  364,  446,
 /*   550 */   447,   89,   48,    0,  451,  452,    1,    2,   54,   55,
 /*   560 */    56,   57,   58,   70,  205,  206,  339,  208,  209,  210,
 /*   570 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   580 */   221,  222,  223,  224,  225,  226,   12,   13,  427,  362,
 /*   590 */   411,  358,  431,  414,   20,   33,   22,   20,   94,  325,
 /*   600 */     0,   97,  369,  172,  107,  357,  325,   33,  447,   35,
 /*   610 */    48,  325,  451,  452,   44,   62,   54,   55,   56,   57,
 /*   620 */    58,  400,  333,  126,  127,  128,  129,  130,  131,   58,
 /*   630 */   397,  398,   58,  356,  130,  342,  343,  356,  342,  343,
 /*   640 */   363,  408,  357,  369,   70,  364,   20,  426,   22,  372,
 /*   650 */   369,   96,  371,  364,  356,  369,   94,   12,   13,   97,
 /*   660 */    22,   35,   62,  365,    3,   20,   95,   22,   97,   95,
 /*   670 */   357,  167,   95,   35,  357,  394,  385,   51,   33,  398,
 /*   680 */    35,   20,  401,  402,  403,  404,  405,  406,  184,  408,
 /*   690 */   186,  117,  411,  357,  413,  414,  415,  266,   14,  400,
 /*   700 */   419,  420,   44,   58,   20,   20,  132,  133,   70,  364,
 /*   710 */   333,  422,  423,  424,  425,   70,  427,  428,  427,  389,
 /*   720 */   375,  325,  431,  357,  347,  426,  164,  165,  325,  167,
 /*   730 */   333,   20,  170,  160,  371,  161,  162,  446,  447,    2,
 /*   740 */    95,  364,  451,  452,  347,    8,    9,  384,  186,   12,
 /*   750 */    13,   14,   15,   16,  180,  117,  182,   96,  325,  379,
 /*   760 */    44,  364,  117,    8,    9,  369,  326,   12,   13,   14,
 /*   770 */    15,   16,  369,  325,  412,   20,  414,  132,  133,  205,
 /*   780 */   206,    0,  208,  209,  210,  211,  212,  213,  214,  215,
 /*   790 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   800 */   226,   18,  369,   20,  231,  325,  161,  162,  333,  333,
 /*   810 */    27,  348,   96,   30,  241,  244,   33,  369,  180,  356,
 /*   820 */   182,  244,  347,  347,  163,  180,    0,  182,  365,   48,
 /*   830 */   325,   48,  325,   50,  325,  265,   53,  325,  325,  364,
 /*   840 */   364,  242,  243,  205,  206,  161,  325,   20,  163,  369,
 /*   850 */   205,  206,  444,  208,  209,  210,  211,  212,  213,  214,
 /*   860 */   215,  216,  217,  218,  219,  220,  221,  222,  223,  224,
 /*   870 */   225,  226,  161,  412,  369,  414,  369,   94,  369,    8,
 /*   880 */     9,  369,  369,   12,   13,   14,   15,   16,    0,  106,
 /*   890 */   369,   65,   66,   67,   68,   69,  345,   71,   72,   73,
 /*   900 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   910 */    84,   85,   86,   87,   88,   89,   90,   91,  163,  136,
 /*   920 */   325,  263,  139,  140,  141,  142,  143,  144,  145,  146,
 /*   930 */   147,  148,  149,  150,  151,  152,  153,  154,  155,    4,
 /*   940 */   157,  158,  159,   18,  366,    8,    9,  369,   23,   12,
 /*   950 */    13,   14,   15,   16,   19,    0,  333,  325,  325,   39,
 /*   960 */   333,  455,   37,   38,  369,    2,   41,   96,   33,  335,
 /*   970 */   347,    8,    9,   20,  347,   12,   13,   14,   15,   16,
 /*   980 */   333,  325,  333,   48,   59,   60,   61,  364,   53,  356,
 /*   990 */   163,  364,  333,   58,  347,  107,  347,  364,  344,  107,
 /*  1000 */   346,  369,  369,  385,  371,  438,  347,  366,  356,    0,
 /*  1010 */   369,  364,  333,  364,  126,  127,  128,  129,  130,  131,
 /*  1020 */    95,  129,  106,  364,  372,  369,  347,  394,   42,   94,
 /*  1030 */    44,  398,   97,   96,  401,  402,  403,  404,  405,  406,
 /*  1040 */    42,  408,   44,  364,  366,  427,  413,  369,  415,  431,
 /*  1050 */     8,    9,  419,  420,   12,   13,   14,   15,   16,  134,
 /*  1060 */    22,  325,  107,  333,  446,  447,   12,   13,  349,  451,
 /*  1070 */   452,  352,  156,   35,  441,   99,   22,  347,  102,  333,
 /*  1080 */    35,  126,  127,  128,  129,  130,  131,   33,   99,   35,
 /*  1090 */    35,  102,  356,  347,  364,    0,    0,  172,  173,  174,
 /*  1100 */   364,  333,  177,   99,  325,  369,  102,  371,  356,   44,
 /*  1110 */   364,   99,   58,   44,  102,  347,  163,   22,   22,   47,
 /*  1120 */   195,   63,  333,  198,   70,  200,  201,  202,  203,  204,
 /*  1130 */   394,  335,  364,  333,  398,  356,  347,  401,  402,  403,
 /*  1140 */   404,  405,  406,  364,  408,  333,    0,  347,  369,  413,
 /*  1150 */   371,  415,   44,  364,  385,  419,  420,  132,  133,  347,
 /*  1160 */   151,   96,  325,  243,  364,   96,  430,   95,   22,  244,
 /*  1170 */   163,  117,   44,  394,   44,  168,  364,  398,   44,  332,
 /*  1180 */   401,  402,  403,  404,  405,  406,  379,  408,   13,    1,
 /*  1190 */     2,   13,  413,  356,  415,   44,  427,   44,  419,  420,
 /*  1200 */   431,  364,  379,   44,   96,  163,  369,   95,  371,  430,
 /*  1210 */    35,  368,   44,   35,   44,  446,  447,  105,   44,  385,
 /*  1220 */   451,  452,  429,  325,   96,  448,   96,  182,  246,  421,
 /*  1230 */    96,  394,  396,   35,  180,  398,  182,  182,  401,  402,
 /*  1240 */   403,  404,  405,  406,   48,  408,   44,   96,  432,   96,
 /*  1250 */   413,  325,  415,   44,  356,   96,  419,  420,  395,  205,
 /*  1260 */   206,  427,  364,  205,   96,  431,   96,  369,   70,  371,
 /*  1270 */    96,  217,  218,  219,  220,  221,  222,  223,  178,   42,
 /*  1280 */   446,  447,  356,   44,  387,  451,  452,  376,   20,  379,
 /*  1290 */   364,  376,  394,  160,   20,  369,  398,  371,   96,  401,
 /*  1300 */   402,  403,  404,  405,  406,   96,  408,  374,  333,   93,
 /*  1310 */   333,  413,  325,  415,  376,  374,  374,  419,  420,  341,
 /*  1320 */   394,  333,   20,  333,  398,  333,  327,  401,  402,  403,
 /*  1330 */   404,  405,  406,  327,  408,   96,   20,  391,  371,  413,
 /*  1340 */   339,  415,  339,  356,   20,  419,  420,  334,   20,  339,
 /*  1350 */   386,  364,  334,  339,  339,  339,  369,  333,  371,  339,
 /*  1360 */    52,  327,  336,  336,  356,  325,  333,  356,  185,  369,
 /*  1370 */   327,  369,  393,  356,  194,  356,  391,  356,  356,  356,
 /*  1380 */   333,  394,  437,  337,  356,  398,  356,  356,  401,  402,
 /*  1390 */   403,  404,  405,  406,  337,  408,  356,  356,  437,  252,
 /*  1400 */   251,  258,  415,  371,  364,  440,  419,  420,  369,  369,
 /*  1410 */   439,  371,  171,  259,  379,  379,  260,  369,  325,  390,
 /*  1420 */   369,  369,  267,  247,  456,  264,  382,  262,  437,  436,
 /*  1430 */   435,  382,  449,  396,  394,  243,   20,  364,  398,  434,
 /*  1440 */   333,  401,  402,  403,  404,  405,  406,  450,  408,  356,
 /*  1450 */   400,  334,  337,  382,  369,  415,  369,  364,  369,  419,
 /*  1460 */   420,  325,  369,  369,  371,  382,  369,  369,  165,  337,
 /*  1470 */   380,  352,  337,  364,   95,   95,  360,  418,  333,  369,
 /*  1480 */    36,  337,  383,  346,  392,  328,  383,  394,  350,  327,
 /*  1490 */   388,  398,  356,    0,  401,  402,  403,  404,  405,  406,
 /*  1500 */   364,  408,  350,    0,  338,  369,  187,  371,  415,  323,
 /*  1510 */   350,    0,  419,  420,    0,   42,    0,   35,  325,  199,
 /*  1520 */    35,   35,   35,    0,  199,   35,   35,    0,  199,  199,
 /*  1530 */   394,    0,    0,   35,  398,  325,    0,  401,  402,  403,
 /*  1540 */   404,  405,  406,  407,  408,  409,  410,   22,  182,  356,
 /*  1550 */    35,  180,    0,    0,  176,    0,  175,  364,    0,   47,
 /*  1560 */     0,  325,  369,    0,  371,    0,  356,   58,   42,    0,
 /*  1570 */     0,    0,    0,    0,  364,    0,    0,    0,  151,  369,
 /*  1580 */    35,  371,    0,  151,    0,    0,    0,  394,   42,    0,
 /*  1590 */     0,  398,  356,    0,  401,  402,  403,  404,  405,  406,
 /*  1600 */   364,  408,    0,    0,  394,  369,    0,  371,  398,    0,
 /*  1610 */     0,  401,  402,  403,  404,  405,  406,    0,  408,    0,
 /*  1620 */     0,  325,    0,    0,    0,    0,    0,    0,    0,   22,
 /*  1630 */   394,  135,    0,    0,  398,  442,  443,  401,  402,  403,
 /*  1640 */   404,  405,  406,  325,  408,    0,    0,   35,    0,    0,
 /*  1650 */    58,  415,  356,    0,    0,   42,  420,   39,   44,    0,
 /*  1660 */   364,   14,   47,  453,  454,  369,    0,  371,   47,   14,
 /*  1670 */    40,    0,    0,   39,  356,   39,   47,  171,    0,    0,
 /*  1680 */     0,    0,  364,    0,    0,   35,   48,  369,   48,  371,
 /*  1690 */   394,    0,   35,   35,  398,   39,    0,  401,  402,  403,
 /*  1700 */   404,  405,  406,   64,  408,    0,   39,  325,   48,   39,
 /*  1710 */    35,   48,  394,   39,    0,    0,  398,    0,  102,  401,
 /*  1720 */   402,  403,  404,  405,  406,   35,  408,    0,  325,   22,
 /*  1730 */    44,   44,   35,   35,   35,   35,   35,   35,  356,  443,
 /*  1740 */    22,  104,    0,   35,   22,    0,  364,   22,    0,    0,
 /*  1750 */    22,  369,    0,  371,   50,   35,   35,    0,   35,  356,
 /*  1760 */    22,   20,    0,  445,  361,   35,   35,  364,  163,   96,
 /*  1770 */   192,  325,  369,    0,  371,   35,  394,   95,  183,    0,
 /*  1780 */   398,   22,    0,  401,  402,  403,  404,  405,  406,    3,
 /*  1790 */   408,   44,  248,   47,   44,   44,  248,  394,  163,   96,
 /*  1800 */    47,  398,  356,    3,  401,  402,  403,  404,  405,  406,
 /*  1810 */   364,  408,  169,   44,   95,  369,  165,  371,   44,   95,
 /*  1820 */    35,   95,  325,   35,  163,   96,   35,  248,   96,   95,
 /*  1830 */    95,   35,   96,   96,   95,    0,  454,   35,  325,   96,
 /*  1840 */   394,   35,   47,  242,  398,   44,   47,  401,  402,  403,
 /*  1850 */   404,  405,  406,  356,  408,    0,  410,   96,  361,   96,
 /*  1860 */     0,  364,   95,    0,   96,   95,  369,   96,  371,  356,
 /*  1870 */    95,   95,  166,   39,  361,  164,   95,  364,   47,    2,
 /*  1880 */    44,  205,  369,  105,  371,   95,   22,   47,   96,  227,
 /*  1890 */    96,  394,  325,  229,   47,  398,  227,   22,  401,  402,
 /*  1900 */   403,  404,  405,  406,   95,  408,   95,  394,   96,   95,
 /*  1910 */    95,  398,   96,  325,  401,  402,  403,  404,  405,  406,
 /*  1920 */    95,  408,   96,  356,  106,   35,   35,   95,   35,   96,
 /*  1930 */    35,  364,   95,   35,   96,   96,  369,   95,  371,   95,
 /*  1940 */   207,   96,   35,   95,  356,   22,  119,  119,  119,  119,
 /*  1950 */   107,   95,  364,   44,   35,   22,  325,  369,   64,  371,
 /*  1960 */    95,  394,   95,   63,   35,  398,   35,   35,  401,  402,
 /*  1970 */   403,  404,  405,  406,   35,  408,   35,  325,   35,   35,
 /*  1980 */    70,   35,  394,   35,   35,   35,  398,  356,   92,  401,
 /*  1990 */   402,  403,  404,  405,  406,  364,  408,   44,   35,   35,
 /*  2000 */   369,   22,  371,   35,   35,   35,   70,   35,  356,   35,
 /*  2010 */    35,   35,   35,   22,    0,   35,  364,   35,    0,   48,
 /*  2020 */   325,  369,   39,  371,   35,  394,   48,    0,   35,  398,
 /*  2030 */     0,   39,  401,  402,  403,  404,  405,  406,  325,  408,
 /*  2040 */    39,   35,   48,   48,   39,    0,  394,   35,   35,    0,
 /*  2050 */   398,  356,   21,  401,  402,  403,  404,  405,  406,  364,
 /*  2060 */   408,   22,   22,   22,  369,   21,  371,  457,   20,  356,
 /*  2070 */   457,  457,  457,  457,  457,  457,  457,  364,  457,  457,
 /*  2080 */   457,  457,  369,  457,  371,  457,  457,  457,  457,  394,
 /*  2090 */   457,  457,  457,  398,  457,  457,  401,  402,  403,  404,
 /*  2100 */   405,  406,  325,  408,  457,  457,  457,  394,  457,  457,
 /*  2110 */   457,  398,  457,  457,  401,  402,  403,  404,  405,  406,
 /*  2120 */   457,  408,  457,  325,  457,  457,  457,  457,  457,  457,
 /*  2130 */   457,  457,  457,  356,  457,  457,  457,  457,  457,  457,
 /*  2140 */   457,  364,  457,  457,  457,  457,  369,  457,  371,  457,
 /*  2150 */   457,  457,  457,  457,  356,  457,  457,  457,  457,  457,
 /*  2160 */   457,  457,  364,  457,  457,  457,  325,  369,  457,  371,
 /*  2170 */   457,  394,  457,  457,  457,  398,  457,  457,  401,  402,
 /*  2180 */   403,  404,  405,  406,  325,  408,  457,  457,  457,  457,
 /*  2190 */   457,  457,  394,  457,  457,  457,  398,  356,  457,  401,
 /*  2200 */   402,  403,  404,  405,  406,  364,  408,  457,  457,  457,
 /*  2210 */   369,  457,  371,  457,  457,  356,  457,  457,  457,  457,
 /*  2220 */   457,  457,  457,  364,  457,  457,  457,  325,  369,  457,
 /*  2230 */   371,  457,  457,  457,  457,  394,  457,  457,  457,  398,
 /*  2240 */   457,  457,  401,  402,  403,  404,  405,  406,  457,  408,
 /*  2250 */   457,  457,  457,  394,  457,  457,  457,  398,  356,  457,
 /*  2260 */   401,  402,  403,  404,  405,  406,  364,  408,  457,  457,
 /*  2270 */   325,  369,  457,  371,  457,  457,  457,  457,  457,  457,
 /*  2280 */   457,  457,  457,  457,  457,  457,  457,  325,  457,  457,
 /*  2290 */   457,  457,  457,  457,  457,  457,  394,  457,  457,  457,
 /*  2300 */   398,  356,  457,  401,  402,  403,  404,  405,  406,  364,
 /*  2310 */   408,  457,  457,  325,  369,  457,  371,  457,  356,  457,
 /*  2320 */   457,  457,  457,  457,  457,  457,  364,  457,  457,  457,
 /*  2330 */   457,  369,  457,  371,  457,  457,  457,  457,  457,  394,
 /*  2340 */   457,  457,  457,  398,  356,  457,  401,  402,  403,  404,
 /*  2350 */   405,  406,  364,  408,  457,  457,  394,  369,  457,  371,
 /*  2360 */   398,  457,  457,  401,  402,  403,  404,  405,  406,  457,
 /*  2370 */   408,  457,  325,  457,  457,  457,  457,  457,  457,  457,
 /*  2380 */   457,  457,  394,  457,  457,  457,  398,  457,  457,  401,
 /*  2390 */   402,  403,  404,  405,  406,  457,  408,  457,  457,  457,
 /*  2400 */   457,  457,  457,  356,  457,  457,  457,  457,  457,  457,
 /*  2410 */   457,  364,  457,  457,  457,  325,  369,  457,  371,  457,
 /*  2420 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2430 */   457,  457,  457,  325,  457,  457,  457,  457,  457,  457,
 /*  2440 */   457,  394,  457,  457,  457,  398,  356,  457,  401,  402,
 /*  2450 */   403,  404,  405,  406,  364,  408,  457,  457,  457,  369,
 /*  2460 */   457,  371,  457,  457,  356,  457,  457,  457,  457,  457,
 /*  2470 */   457,  457,  364,  457,  457,  457,  457,  369,  457,  371,
 /*  2480 */   457,  457,  457,  457,  394,  457,  457,  457,  398,  457,
 /*  2490 */   457,  401,  402,  403,  404,  405,  406,  325,  408,  457,
 /*  2500 */   457,  457,  394,  457,  457,  457,  398,  457,  457,  401,
 /*  2510 */   402,  403,  404,  405,  406,  457,  408,  457,  325,  457,
 /*  2520 */   457,  457,  457,  457,  457,  457,  457,  457,  356,  457,
 /*  2530 */   457,  457,  457,  457,  457,  457,  364,  457,  457,  457,
 /*  2540 */   457,  369,  457,  371,  457,  457,  457,  457,  457,  356,
 /*  2550 */   457,  457,  457,  457,  457,  457,  457,  364,  457,  457,
 /*  2560 */   457,  325,  369,  457,  371,  457,  394,  457,  457,  457,
 /*  2570 */   398,  457,  457,  401,  402,  403,  404,  405,  406,  325,
 /*  2580 */   408,  457,  457,  457,  457,  457,  457,  394,  457,  457,
 /*  2590 */   457,  398,  356,  457,  401,  402,  403,  404,  405,  406,
 /*  2600 */   364,  408,  457,  457,  457,  369,  457,  371,  457,  457,
 /*  2610 */   356,  457,  457,  457,  457,  457,  457,  457,  364,  457,
 /*  2620 */   457,  457,  325,  369,  457,  371,  457,  457,  457,  457,
 /*  2630 */   394,  457,  457,  457,  398,  457,  457,  401,  402,  403,
 /*  2640 */   404,  405,  406,  457,  408,  457,  457,  457,  394,  457,
 /*  2650 */   457,  457,  398,  356,  457,  401,  402,  403,  404,  405,
 /*  2660 */   406,  364,  408,  457,  457,  457,  369,  457,  371,  457,
 /*  2670 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2680 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2690 */   457,  394,  457,  457,  457,  398,  457,  457,  401,  402,
 /*  2700 */   403,  404,  405,  406,  457,  408,
};
#define YY_SHIFT_COUNT    (707)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2049)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   925,    0,   71,    0,  288,  288,  288,  288,  288,  288,
 /*    10 */   288,  288,  288,  359,  574,  574,  645,  574,  574,  574,
 /*    20 */   574,  574,  574,  574,  574,  574,  574,  574,  574,  574,
 /*    30 */   574,  574,  574,  574,  574,  574,  574,  574,  574,  574,
 /*    40 */   574,  574,  574,  574,  574,  574,  225,  577,   74,  132,
 /*    50 */   571,  133,  151,  133,   74,   74, 1054, 1054,  133, 1054,
 /*    60 */  1054,   17,  133,   52,   52,   21,   21,   98,  292,   42,
 /*    70 */    42,   52,   52,   52,   52,   52,   52,   52,   52,   52,
 /*    80 */    52,  106,   52,   52,   76,   52,  169,   52,   52,  228,
 /*    90 */    52,   52,  228,   52,  228,  228,  228,   52,  454,  783,
 /*   100 */    34,   34,  372,  462,  638,  638,  638,  638,  638,  638,
 /*   110 */   638,  638,  638,  638,  638,  638,  638,  638,  638,  638,
 /*   120 */   638,  638,  638,  149,  661,   98,  292,  553,  445,  685,
 /*   130 */   685,  685,  600,  157,  157,  445,  414,  414,  414,  427,
 /*   140 */   169,  316,  228,    9,  228,    9,    9,  427,  493,  216,
 /*   150 */   216,  216,  216,  216,  216,  216,  504,  335,   36,  755,
 /*   160 */   431,   49,  626,  187,  329,  684,  294,  827,  302,  892,
 /*   170 */   953,  599,  920,  234,  599,  986,  203,  711,  982, 1196,
 /*   180 */  1100, 1237, 1268, 1237, 1133, 1274, 1274, 1237, 1133, 1133,
 /*   190 */  1216, 1274, 1274, 1274, 1302, 1302, 1316,  106,  169,  106,
 /*   200 */  1324, 1328,  106, 1324,  106,  106,  106, 1274,  106, 1308,
 /*   210 */  1308, 1302,  228,  228,  228,  228,  228,  228,  228,  228,
 /*   220 */   228,  228,  228, 1274, 1302,    9,    9, 1180, 1316,  454,
 /*   230 */  1183,  169,  454, 1274, 1268, 1268,    9, 1147, 1149,    9,
 /*   240 */  1147, 1149,    9,    9,  228, 1143, 1241, 1147, 1156, 1154,
 /*   250 */  1176,  982, 1155, 1161, 1165, 1192,  414, 1416, 1274, 1324,
 /*   260 */   454, 1149,    9,    9,    9,    9,    9, 1149,    9, 1303,
 /*   270 */   454,  427,  454,  414, 1379, 1380,    9,  493, 1274,  454,
 /*   280 */  1444, 1302, 2706, 2706, 2706, 2706, 2706, 2706, 2706, 2706,
 /*   290 */  2706,  826,  562,  382,  935,  871,   15,  937,  888,  737,
 /*   300 */   963, 1042,  955,  183,  183,  183,  183,  183,  183,  183,
 /*   310 */   183,  183,  497,  331,   25,   25,  193,  322,  405,  166,
 /*   320 */   262,   50,   50,  417,  555,  573,  417,  417,  417,  716,
 /*   330 */   781, 1038,  998,  916, 1009,  976,  989, 1004, 1012, 1095,
 /*   340 */  1096, 1146,  429, 1065, 1069, 1025,  658,  570, 1007, 1108,
 /*   350 */  1128, 1130, 1134, 1151, 1188, 1153, 1045, 1055, 1058, 1159,
 /*   360 */  1072, 1168, 1170, 1174, 1202, 1209, 1239, 1112, 1175, 1178,
 /*   370 */  1198,   11, 1493, 1503, 1319, 1511, 1514, 1473, 1516, 1482,
 /*   380 */  1320, 1485, 1486, 1487, 1325, 1523, 1490, 1491, 1329, 1527,
 /*   390 */  1330, 1531, 1498, 1532, 1525, 1536, 1515, 1366, 1371, 1552,
 /*   400 */  1553, 1378, 1381, 1555, 1558, 1512, 1560, 1563, 1565, 1526,
 /*   410 */  1569, 1570, 1571, 1572, 1573, 1575, 1576, 1577, 1427, 1545,
 /*   420 */  1582, 1432, 1584, 1585, 1586, 1593, 1602, 1603, 1606, 1609,
 /*   430 */  1610, 1617, 1619, 1620, 1622, 1623, 1624, 1546, 1589, 1590,
 /*   440 */  1625, 1626, 1627, 1607, 1628, 1645, 1646, 1496, 1632, 1633,
 /*   450 */  1612, 1648, 1509, 1649, 1592, 1653, 1654, 1613, 1618, 1614,
 /*   460 */  1615, 1647, 1621, 1655, 1629, 1659, 1630, 1634, 1666, 1671,
 /*   470 */  1672, 1636, 1506, 1678, 1679, 1680, 1639, 1681, 1683, 1650,
 /*   480 */  1638, 1656, 1684, 1657, 1640, 1667, 1691, 1658, 1660, 1670,
 /*   490 */  1696, 1675, 1663, 1674, 1705, 1714, 1715, 1717, 1637, 1616,
 /*   500 */  1690, 1707, 1727, 1697, 1698, 1699, 1700, 1686, 1687, 1701,
 /*   510 */  1702, 1718, 1708, 1742, 1722, 1745, 1725, 1704, 1748, 1728,
 /*   520 */  1720, 1749, 1721, 1752, 1723, 1757, 1738, 1741, 1730, 1731,
 /*   530 */  1578, 1673, 1682, 1762, 1605, 1740, 1773, 1595, 1759, 1635,
 /*   540 */  1651, 1779, 1782, 1661, 1643, 1786, 1747, 1544, 1719, 1703,
 /*   550 */  1724, 1729, 1750, 1732, 1726, 1734, 1735, 1736, 1751, 1746,
 /*   560 */  1753, 1739, 1769, 1548, 1737, 1743, 1800, 1774, 1579, 1785,
 /*   570 */  1788, 1791, 1796, 1802, 1806, 1761, 1763, 1795, 1601, 1801,
 /*   580 */  1799, 1835, 1855, 1860, 1767, 1768, 1771, 1770, 1775, 1706,
 /*   590 */  1776, 1863, 1834, 1711, 1781, 1778, 1615, 1831, 1836, 1662,
 /*   600 */  1664, 1669, 1877, 1864, 1676, 1790, 1792, 1809, 1794, 1811,
 /*   610 */  1812, 1840, 1814, 1815, 1847, 1816, 1875, 1733, 1825, 1818,
 /*   620 */  1826, 1890, 1891, 1832, 1833, 1893, 1837, 1838, 1895, 1842,
 /*   630 */  1839, 1898, 1844, 1845, 1907, 1848, 1827, 1828, 1829, 1830,
 /*   640 */  1923, 1843, 1856, 1909, 1865, 1919, 1867, 1909, 1909, 1933,
 /*   650 */  1894, 1900, 1929, 1931, 1932, 1939, 1941, 1943, 1944, 1946,
 /*   660 */  1948, 1949, 1910, 1896, 1953, 1950, 1963, 1964, 1979, 1968,
 /*   670 */  1969, 1970, 1936, 1686, 1972, 1687, 1974, 1975, 1976, 1977,
 /*   680 */  1991, 1980, 2014, 1982, 1971, 1983, 2018, 1989, 1978, 1992,
 /*   690 */  2027, 1993, 1994, 2001, 2030, 2006, 1995, 2005, 2045, 2012,
 /*   700 */  2013, 2049, 2039, 2031, 2040, 2041, 2044, 2048,
};
#define YY_REDUCE_COUNT (290)
#define YY_REDUCE_MIN   (-366)
#define YY_REDUCE_MAX   (2297)
static const short yy_reduce_ofst[] = {
 /*     0 */  -316, -248,  281,  633,   59,  736,  779,  837,  898,  926,
 /*    10 */   987, 1040, 1093, 1136, 1193, 1210, 1236, 1296, 1318, 1382,
 /*    20 */  1403, 1446, 1497, 1513, 1567, 1588, 1631, 1652, 1695, 1713,
 /*    30 */  1777, 1798, 1841, 1859, 1902, 1945, 1962, 1988, 2047, 2090,
 /*    40 */  2108, 2172, 2193, 2236, 2254, 2297, -189,  103,  289, -366,
 /*    50 */   291,  618,  769,  834, -276,   58, -271, -168, -268, -353,
 /*    60 */   233,  -77,  161, -265,  184, -329, -322, -324, -296, -191,
 /*    70 */  -160, -257,   22,  109,  377,  397,  475,  476,  623,  627,
 /*    80 */   647,  -98,  649,  659, -330,  679,  -62,  730,  746, -243,
 /*    90 */   768,  789, -355,  800,   70,  277,  463,  812, -259, -209,
 /*   100 */  -365, -365,   -9, -200,  -27,  102,  163,  274,  286,  396,
 /*   110 */   403,  433,  448,  480,  505,  507,  509,  512,  513,  521,
 /*   120 */   595,  632,  656,  -11,  -48,   99, -127,  227,  293,  -48,
 /*   130 */   221,  299,  188,  362,  461,  296, -360,  -57,  345,   89,
 /*   140 */   363,  179,  298,  578,  652,  641,  678,  719,  654, -339,
 /*   150 */   248,  285,  313,  317,  336,  366,  330,  440,  551,  380,
 /*   160 */   506,  408,  634,  567,  752,  752,  796,  807,  847,  843,
 /*   170 */   823,  793,  793,  777,  793,  808,  816,  752,  836,  863,
 /*   180 */   897,  911,  910,  915,  933,  975,  977,  938,  941,  942,
 /*   190 */   978,  988,  990,  992,  999, 1006,  946, 1001,  967, 1003,
 /*   200 */  1013,  964, 1010, 1018, 1014, 1015, 1016, 1024, 1020, 1026,
 /*   210 */  1027, 1034, 1008, 1011, 1017, 1019, 1021, 1022, 1023, 1028,
 /*   220 */  1030, 1031, 1041, 1033, 1043, 1000, 1002,  979,  985, 1046,
 /*   230 */  1029, 1032, 1057, 1047, 1035, 1036, 1039,  945, 1044, 1048,
 /*   240 */   961, 1049, 1051, 1052,  752,  965,  971,  991,  993,  995,
 /*   250 */  1005, 1037,  968,  997,  983,  793, 1073, 1050, 1107, 1117,
 /*   260 */  1115, 1071, 1085, 1087, 1089, 1094, 1097, 1083, 1098, 1090,
 /*   270 */  1132, 1119, 1135, 1109, 1059, 1116, 1110, 1137, 1145, 1144,
 /*   280 */  1157, 1162, 1102, 1092, 1099, 1103, 1138, 1152, 1160, 1166,
 /*   290 */  1186,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*    10 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*    20 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*    30 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*    40 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*    50 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*    60 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1841, 1586, 1586,
 /*    70 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*    80 */  1586, 1664, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*    90 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1662, 1834,
 /*   100 */  2031, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   110 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   120 */  1586, 1586, 1586, 1586, 2043, 1586, 1586, 1664, 1586, 2043,
 /*   130 */  2043, 2043, 1662, 2003, 2003, 1586, 1586, 1586, 1586, 1771,
 /*   140 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1771, 1586, 1586,
 /*   150 */  1586, 1586, 1586, 1586, 1586, 1586, 1878, 1586, 1586, 2068,
 /*   160 */  2121, 1586, 1586, 2071, 1586, 1586, 1586, 1846, 1586, 1724,
 /*   170 */  2058, 2035, 2049, 2105, 2036, 2033, 2052, 1586, 2062, 1586,
 /*   180 */  1871, 1839, 1586, 1839, 1836, 1586, 1586, 1839, 1836, 1836,
 /*   190 */  1715, 1586, 1586, 1586, 1586, 1586, 1586, 1664, 1586, 1664,
 /*   200 */  1586, 1586, 1664, 1586, 1664, 1664, 1664, 1586, 1664, 1643,
 /*   210 */  1643, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   220 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1891, 1586, 1662,
 /*   230 */  1880, 1586, 1662, 1586, 1586, 1586, 1586, 2078, 2076, 1586,
 /*   240 */  2078, 2076, 1586, 1586, 1586, 2090, 2086, 2078, 2094, 2092,
 /*   250 */  2064, 2062, 2124, 2111, 2107, 2049, 1586, 1586, 1586, 1586,
 /*   260 */  1662, 2076, 1586, 1586, 1586, 1586, 1586, 2076, 1586, 1586,
 /*   270 */  1662, 1586, 1662, 1586, 1586, 1740, 1586, 1586, 1586, 1662,
 /*   280 */  1618, 1586, 1873, 1884, 1856, 1856, 1774, 1774, 1774, 1665,
 /*   290 */  1591, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   300 */  1586, 1586, 1586, 2089, 2088, 1959, 1586, 2007, 2006, 2005,
 /*   310 */  1996, 1958, 1736, 1586, 1957, 1956, 1586, 1586, 1586, 1586,
 /*   320 */  1586, 1852, 1851, 1950, 1586, 1586, 1951, 1949, 1948, 1586,
 /*   330 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   340 */  1586, 1586, 1586, 1586, 1586, 1586, 2108, 2112, 1586, 1586,
 /*   350 */  1586, 1586, 1586, 1586, 2032, 1586, 1586, 1586, 1586, 1586,
 /*   360 */  1933, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   370 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   380 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   390 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   400 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   410 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   420 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   430 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   440 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   450 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1623,
 /*   460 */  1938, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   470 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   480 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   490 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   500 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1703, 1702, 1586,
 /*   510 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   520 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   530 */  1586, 1941, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   540 */  1586, 1586, 1586, 1586, 1586, 2104, 2065, 1586, 1586, 1586,
 /*   550 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   560 */  1933, 1586, 2087, 1586, 1586, 2102, 1586, 2106, 1586, 1586,
 /*   570 */  1586, 1586, 1586, 1586, 1586, 2042, 2038, 1586, 1586, 2034,
 /*   580 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   590 */  1586, 1586, 1586, 1586, 1586, 1586, 1932, 1586, 1993, 1586,
 /*   600 */  1586, 1586, 2027, 1586, 1586, 1978, 1586, 1586, 1586, 1586,
 /*   610 */  1586, 1586, 1586, 1586, 1586, 1941, 1586, 1944, 1586, 1586,
 /*   620 */  1586, 1586, 1586, 1768, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   630 */  1586, 1586, 1586, 1586, 1586, 1586, 1753, 1751, 1750, 1749,
 /*   640 */  1586, 1746, 1586, 1781, 1586, 1586, 1586, 1777, 1776, 1586,
 /*   650 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   660 */  1586, 1586, 1586, 1586, 1683, 1586, 1586, 1586, 1586, 1586,
 /*   670 */  1586, 1586, 1586, 1675, 1586, 1674, 1586, 1586, 1586, 1586,
 /*   680 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   690 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
 /*   700 */  1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  268,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  268,  /*      AFTER => ABORT */
  268,  /*     ATTACH => ABORT */
  268,  /*     BEFORE => ABORT */
  268,  /*      BEGIN => ABORT */
  268,  /*     BITAND => ABORT */
  268,  /*     BITNOT => ABORT */
  268,  /*      BITOR => ABORT */
  268,  /*     BLOCKS => ABORT */
  268,  /*     CHANGE => ABORT */
  268,  /*      COMMA => ABORT */
  268,  /*    COMPACT => ABORT */
  268,  /*     CONCAT => ABORT */
  268,  /*   CONFLICT => ABORT */
  268,  /*       COPY => ABORT */
  268,  /*   DEFERRED => ABORT */
  268,  /* DELIMITERS => ABORT */
  268,  /*     DETACH => ABORT */
  268,  /*     DIVIDE => ABORT */
  268,  /*        DOT => ABORT */
  268,  /*       EACH => ABORT */
  268,  /*       FAIL => ABORT */
  268,  /*       FILE => ABORT */
  268,  /*        FOR => ABORT */
  268,  /*       GLOB => ABORT */
  268,  /*         ID => ABORT */
  268,  /*  IMMEDIATE => ABORT */
  268,  /*     IMPORT => ABORT */
  268,  /*  INITIALLY => ABORT */
  268,  /*    INSTEAD => ABORT */
  268,  /*     ISNULL => ABORT */
  268,  /*        KEY => ABORT */
  268,  /*    MODULES => ABORT */
  268,  /*  NK_BITNOT => ABORT */
  268,  /*    NK_SEMI => ABORT */
  268,  /*    NOTNULL => ABORT */
  268,  /*         OF => ABORT */
  268,  /*       PLUS => ABORT */
  268,  /*  PRIVILEGE => ABORT */
  268,  /*      RAISE => ABORT */
  268,  /*    REPLACE => ABORT */
  268,  /*   RESTRICT => ABORT */
  268,  /*        ROW => ABORT */
  268,  /*       SEMI => ABORT */
  268,  /*       STAR => ABORT */
  268,  /*  STATEMENT => ABORT */
  268,  /*     STRICT => ABORT */
  268,  /*     STRING => ABORT */
  268,  /*      TIMES => ABORT */
  268,  /*     UPDATE => ABORT */
  268,  /*     VALUES => ABORT */
  268,  /*   VARIABLE => ABORT */
  268,  /*       VIEW => ABORT */
  268,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "IF",
  /*   63 */ "NOT",
  /*   64 */ "EXISTS",
  /*   65 */ "BUFFER",
  /*   66 */ "CACHEMODEL",
  /*   67 */ "CACHESIZE",
  /*   68 */ "COMP",
  /*   69 */ "DURATION",
  /*   70 */ "NK_VARIABLE",
  /*   71 */ "MAXROWS",
  /*   72 */ "MINROWS",
  /*   73 */ "KEEP",
  /*   74 */ "PAGES",
  /*   75 */ "PAGESIZE",
  /*   76 */ "TSDB_PAGESIZE",
  /*   77 */ "PRECISION",
  /*   78 */ "REPLICA",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "WAL_LEVEL",
  /*   84 */ "WAL_FSYNC_PERIOD",
  /*   85 */ "WAL_RETENTION_PERIOD",
  /*   86 */ "WAL_RETENTION_SIZE",
  /*   87 */ "WAL_ROLL_PERIOD",
  /*   88 */ "WAL_SEGMENT_SIZE",
  /*   89 */ "STT_TRIGGER",
  /*   90 */ "TABLE_PREFIX",
  /*   91 */ "TABLE_SUFFIX",
  /*   92 */ "NK_COLON",
  /*   93 */ "MAX_SPEED",
  /*   94 */ "TABLE",
  /*   95 */ "NK_LP",
  /*   96 */ "NK_RP",
  /*   97 */ "STABLE",
  /*   98 */ "ADD",
  /*   99 */ "COLUMN",
  /*  100 */ "MODIFY",
  /*  101 */ "RENAME",
  /*  102 */ "TAG",
  /*  103 */ "SET",
  /*  104 */ "NK_EQ",
  /*  105 */ "USING",
  /*  106 */ "TAGS",
  /*  107 */ "COMMENT",
  /*  108 */ "BOOL",
  /*  109 */ "TINYINT",
  /*  110 */ "SMALLINT",
  /*  111 */ "INT",
  /*  112 */ "INTEGER",
  /*  113 */ "BIGINT",
  /*  114 */ "FLOAT",
  /*  115 */ "DOUBLE",
  /*  116 */ "BINARY",
  /*  117 */ "TIMESTAMP",
  /*  118 */ "NCHAR",
  /*  119 */ "UNSIGNED",
  /*  120 */ "JSON",
  /*  121 */ "VARCHAR",
  /*  122 */ "MEDIUMBLOB",
  /*  123 */ "BLOB",
  /*  124 */ "VARBINARY",
  /*  125 */ "DECIMAL",
  /*  126 */ "MAX_DELAY",
  /*  127 */ "WATERMARK",
  /*  128 */ "ROLLUP",
  /*  129 */ "TTL",
  /*  130 */ "SMA",
  /*  131 */ "DELETE_MARK",
  /*  132 */ "FIRST",
  /*  133 */ "LAST",
  /*  134 */ "SHOW",
  /*  135 */ "PRIVILEGES",
  /*  136 */ "DATABASES",
  /*  137 */ "TABLES",
  /*  138 */ "STABLES",
  /*  139 */ "MNODES",
  /*  140 */ "QNODES",
  /*  141 */ "FUNCTIONS",
  /*  142 */ "INDEXES",
  /*  143 */ "ACCOUNTS",
  /*  144 */ "APPS",
  /*  145 */ "CONNECTIONS",
  /*  146 */ "LICENCES",
  /*  147 */ "GRANTS",
  /*  148 */ "QUERIES",
  /*  149 */ "SCORES",
  /*  150 */ "TOPICS",
  /*  151 */ "VARIABLES",
  /*  152 */ "CLUSTER",
  /*  153 */ "BNODES",
  /*  154 */ "SNODES",
  /*  155 */ "TRANSACTIONS",
  /*  156 */ "DISTRIBUTED",
  /*  157 */ "CONSUMERS",
  /*  158 */ "SUBSCRIPTIONS",
  /*  159 */ "VNODES",
  /*  160 */ "LIKE",
  /*  161 */ "TBNAME",
  /*  162 */ "QTAGS",
  /*  163 */ "AS",
  /*  164 */ "INDEX",
  /*  165 */ "FUNCTION",
  /*  166 */ "INTERVAL",
  /*  167 */ "TOPIC",
  /*  168 */ "WITH",
  /*  169 */ "META",
  /*  170 */ "CONSUMER",
  /*  171 */ "GROUP",
  /*  172 */ "DESC",
  /*  173 */ "DESCRIBE",
  /*  174 */ "RESET",
  /*  175 */ "QUERY",
  /*  176 */ "CACHE",
  /*  177 */ "EXPLAIN",
  /*  178 */ "ANALYZE",
  /*  179 */ "VERBOSE",
  /*  180 */ "NK_BOOL",
  /*  181 */ "RATIO",
  /*  182 */ "NK_FLOAT",
  /*  183 */ "OUTPUTTYPE",
  /*  184 */ "AGGREGATE",
  /*  185 */ "BUFSIZE",
  /*  186 */ "STREAM",
  /*  187 */ "INTO",
  /*  188 */ "TRIGGER",
  /*  189 */ "AT_ONCE",
  /*  190 */ "WINDOW_CLOSE",
  /*  191 */ "IGNORE",
  /*  192 */ "EXPIRED",
  /*  193 */ "FILL_HISTORY",
  /*  194 */ "SUBTABLE",
  /*  195 */ "KILL",
  /*  196 */ "CONNECTION",
  /*  197 */ "TRANSACTION",
  /*  198 */ "BALANCE",
  /*  199 */ "VGROUP",
  /*  200 */ "MERGE",
  /*  201 */ "REDISTRIBUTE",
  /*  202 */ "SPLIT",
  /*  203 */ "DELETE",
  /*  204 */ "INSERT",
  /*  205 */ "NULL",
  /*  206 */ "NK_QUESTION",
  /*  207 */ "NK_ARROW",
  /*  208 */ "ROWTS",
  /*  209 */ "QSTART",
  /*  210 */ "QEND",
  /*  211 */ "QDURATION",
  /*  212 */ "WSTART",
  /*  213 */ "WEND",
  /*  214 */ "WDURATION",
  /*  215 */ "IROWTS",
  /*  216 */ "CAST",
  /*  217 */ "NOW",
  /*  218 */ "TODAY",
  /*  219 */ "TIMEZONE",
  /*  220 */ "CLIENT_VERSION",
  /*  221 */ "SERVER_VERSION",
  /*  222 */ "SERVER_STATUS",
  /*  223 */ "CURRENT_USER",
  /*  224 */ "COUNT",
  /*  225 */ "LAST_ROW",
  /*  226 */ "CASE",
  /*  227 */ "END",
  /*  228 */ "WHEN",
  /*  229 */ "THEN",
  /*  230 */ "ELSE",
  /*  231 */ "BETWEEN",
  /*  232 */ "IS",
  /*  233 */ "NK_LT",
  /*  234 */ "NK_GT",
  /*  235 */ "NK_LE",
  /*  236 */ "NK_GE",
  /*  237 */ "NK_NE",
  /*  238 */ "MATCH",
  /*  239 */ "NMATCH",
  /*  240 */ "CONTAINS",
  /*  241 */ "IN",
  /*  242 */ "JOIN",
  /*  243 */ "INNER",
  /*  244 */ "SELECT",
  /*  245 */ "DISTINCT",
  /*  246 */ "WHERE",
  /*  247 */ "PARTITION",
  /*  248 */ "BY",
  /*  249 */ "SESSION",
  /*  250 */ "STATE_WINDOW",
  /*  251 */ "SLIDING",
  /*  252 */ "FILL",
  /*  253 */ "VALUE",
  /*  254 */ "NONE",
  /*  255 */ "PREV",
  /*  256 */ "LINEAR",
  /*  257 */ "NEXT",
  /*  258 */ "HAVING",
  /*  259 */ "RANGE",
  /*  260 */ "EVERY",
  /*  261 */ "ORDER",
  /*  262 */ "SLIMIT",
  /*  263 */ "SOFFSET",
  /*  264 */ "LIMIT",
  /*  265 */ "OFFSET",
  /*  266 */ "ASC",
  /*  267 */ "NULLS",
  /*  268 */ "ABORT",
  /*  269 */ "AFTER",
  /*  270 */ "ATTACH",
  /*  271 */ "BEFORE",
  /*  272 */ "BEGIN",
  /*  273 */ "BITAND",
  /*  274 */ "BITNOT",
  /*  275 */ "BITOR",
  /*  276 */ "BLOCKS",
  /*  277 */ "CHANGE",
  /*  278 */ "COMMA",
  /*  279 */ "COMPACT",
  /*  280 */ "CONCAT",
  /*  281 */ "CONFLICT",
  /*  282 */ "COPY",
  /*  283 */ "DEFERRED",
  /*  284 */ "DELIMITERS",
  /*  285 */ "DETACH",
  /*  286 */ "DIVIDE",
  /*  287 */ "DOT",
  /*  288 */ "EACH",
  /*  289 */ "FAIL",
  /*  290 */ "FILE",
  /*  291 */ "FOR",
  /*  292 */ "GLOB",
  /*  293 */ "ID",
  /*  294 */ "IMMEDIATE",
  /*  295 */ "IMPORT",
  /*  296 */ "INITIALLY",
  /*  297 */ "INSTEAD",
  /*  298 */ "ISNULL",
  /*  299 */ "KEY",
  /*  300 */ "MODULES",
  /*  301 */ "NK_BITNOT",
  /*  302 */ "NK_SEMI",
  /*  303 */ "NOTNULL",
  /*  304 */ "OF",
  /*  305 */ "PLUS",
  /*  306 */ "PRIVILEGE",
  /*  307 */ "RAISE",
  /*  308 */ "REPLACE",
  /*  309 */ "RESTRICT",
  /*  310 */ "ROW",
  /*  311 */ "SEMI",
  /*  312 */ "STAR",
  /*  313 */ "STATEMENT",
  /*  314 */ "STRICT",
  /*  315 */ "STRING",
  /*  316 */ "TIMES",
  /*  317 */ "UPDATE",
  /*  318 */ "VALUES",
  /*  319 */ "VARIABLE",
  /*  320 */ "VIEW",
  /*  321 */ "WAL",
  /*  322 */ "cmd",
  /*  323 */ "account_options",
  /*  324 */ "alter_account_options",
  /*  325 */ "literal",
  /*  326 */ "alter_account_option",
  /*  327 */ "user_name",
  /*  328 */ "sysinfo_opt",
  /*  329 */ "privileges",
  /*  330 */ "priv_level",
  /*  331 */ "priv_type_list",
  /*  332 */ "priv_type",
  /*  333 */ "db_name",
  /*  334 */ "topic_name",
  /*  335 */ "dnode_endpoint",
  /*  336 */ "force_opt",
  /*  337 */ "not_exists_opt",
  /*  338 */ "db_options",
  /*  339 */ "exists_opt",
  /*  340 */ "alter_db_options",
  /*  341 */ "speed_opt",
  /*  342 */ "integer_list",
  /*  343 */ "variable_list",
  /*  344 */ "retention_list",
  /*  345 */ "alter_db_option",
  /*  346 */ "retention",
  /*  347 */ "full_table_name",
  /*  348 */ "column_def_list",
  /*  349 */ "tags_def_opt",
  /*  350 */ "table_options",
  /*  351 */ "multi_create_clause",
  /*  352 */ "tags_def",
  /*  353 */ "multi_drop_clause",
  /*  354 */ "alter_table_clause",
  /*  355 */ "alter_table_options",
  /*  356 */ "column_name",
  /*  357 */ "type_name",
  /*  358 */ "signed_literal",
  /*  359 */ "create_subtable_clause",
  /*  360 */ "specific_cols_opt",
  /*  361 */ "expression_list",
  /*  362 */ "drop_table_clause",
  /*  363 */ "col_name_list",
  /*  364 */ "table_name",
  /*  365 */ "column_def",
  /*  366 */ "duration_list",
  /*  367 */ "rollup_func_list",
  /*  368 */ "alter_table_option",
  /*  369 */ "duration_literal",
  /*  370 */ "rollup_func_name",
  /*  371 */ "function_name",
  /*  372 */ "col_name",
  /*  373 */ "db_name_cond_opt",
  /*  374 */ "like_pattern_opt",
  /*  375 */ "table_name_cond",
  /*  376 */ "from_db_opt",
  /*  377 */ "tag_list_opt",
  /*  378 */ "tag_item",
  /*  379 */ "column_alias",
  /*  380 */ "index_options",
  /*  381 */ "func_list",
  /*  382 */ "sliding_opt",
  /*  383 */ "sma_stream_opt",
  /*  384 */ "func",
  /*  385 */ "query_or_subquery",
  /*  386 */ "cgroup_name",
  /*  387 */ "analyze_opt",
  /*  388 */ "explain_options",
  /*  389 */ "agg_func_opt",
  /*  390 */ "bufsize_opt",
  /*  391 */ "stream_name",
  /*  392 */ "stream_options",
  /*  393 */ "subtable_opt",
  /*  394 */ "expression",
  /*  395 */ "dnode_list",
  /*  396 */ "where_clause_opt",
  /*  397 */ "signed",
  /*  398 */ "literal_func",
  /*  399 */ "literal_list",
  /*  400 */ "table_alias",
  /*  401 */ "expr_or_subquery",
  /*  402 */ "pseudo_column",
  /*  403 */ "column_reference",
  /*  404 */ "function_expression",
  /*  405 */ "case_when_expression",
  /*  406 */ "star_func",
  /*  407 */ "star_func_para_list",
  /*  408 */ "noarg_func",
  /*  409 */ "other_para_list",
  /*  410 */ "star_func_para",
  /*  411 */ "when_then_list",
  /*  412 */ "case_when_else_opt",
  /*  413 */ "common_expression",
  /*  414 */ "when_then_expr",
  /*  415 */ "predicate",
  /*  416 */ "compare_op",
  /*  417 */ "in_op",
  /*  418 */ "in_predicate_value",
  /*  419 */ "boolean_value_expression",
  /*  420 */ "boolean_primary",
  /*  421 */ "from_clause_opt",
  /*  422 */ "table_reference_list",
  /*  423 */ "table_reference",
  /*  424 */ "table_primary",
  /*  425 */ "joined_table",
  /*  426 */ "alias_opt",
  /*  427 */ "subquery",
  /*  428 */ "parenthesized_joined_table",
  /*  429 */ "join_type",
  /*  430 */ "search_condition",
  /*  431 */ "query_specification",
  /*  432 */ "set_quantifier_opt",
  /*  433 */ "select_list",
  /*  434 */ "partition_by_clause_opt",
  /*  435 */ "range_opt",
  /*  436 */ "every_opt",
  /*  437 */ "fill_opt",
  /*  438 */ "twindow_clause_opt",
  /*  439 */ "group_by_clause_opt",
  /*  440 */ "having_clause_opt",
  /*  441 */ "select_item",
  /*  442 */ "partition_list",
  /*  443 */ "partition_item",
  /*  444 */ "fill_mode",
  /*  445 */ "group_by_list",
  /*  446 */ "query_expression",
  /*  447 */ "query_simple",
  /*  448 */ "order_by_clause_opt",
  /*  449 */ "slimit_clause_opt",
  /*  450 */ "limit_clause_opt",
  /*  451 */ "union_query_expression",
  /*  452 */ "query_simple_or_subquery",
  /*  453 */ "sort_specification_list",
  /*  454 */ "sort_specification",
  /*  455 */ "ordering_specification_opt",
  /*  456 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  73 */ "not_exists_opt ::=",
 /*  74 */ "exists_opt ::= IF EXISTS",
 /*  75 */ "exists_opt ::=",
 /*  76 */ "db_options ::=",
 /*  77 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  78 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  79 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  81 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  83 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  84 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options KEEP integer_list",
 /*  86 */ "db_options ::= db_options KEEP variable_list",
 /*  87 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  88 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  89 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  91 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  92 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  93 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  94 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  95 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 104 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 105 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 107 */ "alter_db_options ::= alter_db_option",
 /* 108 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 109 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 110 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 111 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 112 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 113 */ "alter_db_option ::= KEEP integer_list",
 /* 114 */ "alter_db_option ::= KEEP variable_list",
 /* 115 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 116 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 117 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 118 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 119 */ "integer_list ::= NK_INTEGER",
 /* 120 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 121 */ "variable_list ::= NK_VARIABLE",
 /* 122 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 123 */ "retention_list ::= retention",
 /* 124 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 125 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 126 */ "speed_opt ::=",
 /* 127 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 128 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 129 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 130 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 131 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 132 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 133 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 134 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 135 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 136 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 142 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 144 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 145 */ "multi_create_clause ::= create_subtable_clause",
 /* 146 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 147 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 148 */ "multi_drop_clause ::= drop_table_clause",
 /* 149 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 150 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 151 */ "specific_cols_opt ::=",
 /* 152 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 153 */ "full_table_name ::= table_name",
 /* 154 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 155 */ "column_def_list ::= column_def",
 /* 156 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 157 */ "column_def ::= column_name type_name",
 /* 158 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 159 */ "type_name ::= BOOL",
 /* 160 */ "type_name ::= TINYINT",
 /* 161 */ "type_name ::= SMALLINT",
 /* 162 */ "type_name ::= INT",
 /* 163 */ "type_name ::= INTEGER",
 /* 164 */ "type_name ::= BIGINT",
 /* 165 */ "type_name ::= FLOAT",
 /* 166 */ "type_name ::= DOUBLE",
 /* 167 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TIMESTAMP",
 /* 169 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TINYINT UNSIGNED",
 /* 171 */ "type_name ::= SMALLINT UNSIGNED",
 /* 172 */ "type_name ::= INT UNSIGNED",
 /* 173 */ "type_name ::= BIGINT UNSIGNED",
 /* 174 */ "type_name ::= JSON",
 /* 175 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 176 */ "type_name ::= MEDIUMBLOB",
 /* 177 */ "type_name ::= BLOB",
 /* 178 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL",
 /* 180 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 182 */ "tags_def_opt ::=",
 /* 183 */ "tags_def_opt ::= tags_def",
 /* 184 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 185 */ "table_options ::=",
 /* 186 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 187 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 188 */ "table_options ::= table_options WATERMARK duration_list",
 /* 189 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 190 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 191 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 192 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 193 */ "alter_table_options ::= alter_table_option",
 /* 194 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 195 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 196 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 197 */ "duration_list ::= duration_literal",
 /* 198 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 199 */ "rollup_func_list ::= rollup_func_name",
 /* 200 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 201 */ "rollup_func_name ::= function_name",
 /* 202 */ "rollup_func_name ::= FIRST",
 /* 203 */ "rollup_func_name ::= LAST",
 /* 204 */ "col_name_list ::= col_name",
 /* 205 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 206 */ "col_name ::= column_name",
 /* 207 */ "cmd ::= SHOW DNODES",
 /* 208 */ "cmd ::= SHOW USERS",
 /* 209 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 210 */ "cmd ::= SHOW DATABASES",
 /* 211 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 214 */ "cmd ::= SHOW MNODES",
 /* 215 */ "cmd ::= SHOW QNODES",
 /* 216 */ "cmd ::= SHOW FUNCTIONS",
 /* 217 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 218 */ "cmd ::= SHOW STREAMS",
 /* 219 */ "cmd ::= SHOW ACCOUNTS",
 /* 220 */ "cmd ::= SHOW APPS",
 /* 221 */ "cmd ::= SHOW CONNECTIONS",
 /* 222 */ "cmd ::= SHOW LICENCES",
 /* 223 */ "cmd ::= SHOW GRANTS",
 /* 224 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 225 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 226 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 227 */ "cmd ::= SHOW QUERIES",
 /* 228 */ "cmd ::= SHOW SCORES",
 /* 229 */ "cmd ::= SHOW TOPICS",
 /* 230 */ "cmd ::= SHOW VARIABLES",
 /* 231 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 232 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 233 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 234 */ "cmd ::= SHOW BNODES",
 /* 235 */ "cmd ::= SHOW SNODES",
 /* 236 */ "cmd ::= SHOW CLUSTER",
 /* 237 */ "cmd ::= SHOW TRANSACTIONS",
 /* 238 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 239 */ "cmd ::= SHOW CONSUMERS",
 /* 240 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 241 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 242 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 244 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 245 */ "db_name_cond_opt ::=",
 /* 246 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 247 */ "like_pattern_opt ::=",
 /* 248 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 249 */ "table_name_cond ::= table_name",
 /* 250 */ "from_db_opt ::=",
 /* 251 */ "from_db_opt ::= FROM db_name",
 /* 252 */ "tag_list_opt ::=",
 /* 253 */ "tag_list_opt ::= tag_item",
 /* 254 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 255 */ "tag_item ::= TBNAME",
 /* 256 */ "tag_item ::= QTAGS",
 /* 257 */ "tag_item ::= column_name",
 /* 258 */ "tag_item ::= column_name column_alias",
 /* 259 */ "tag_item ::= column_name AS column_alias",
 /* 260 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 261 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 262 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 263 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 264 */ "func_list ::= func",
 /* 265 */ "func_list ::= func_list NK_COMMA func",
 /* 266 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 267 */ "sma_stream_opt ::=",
 /* 268 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 269 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 270 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 271 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 272 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 273 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 274 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 275 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 276 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 277 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 278 */ "cmd ::= DESC full_table_name",
 /* 279 */ "cmd ::= DESCRIBE full_table_name",
 /* 280 */ "cmd ::= RESET QUERY CACHE",
 /* 281 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 282 */ "analyze_opt ::=",
 /* 283 */ "analyze_opt ::= ANALYZE",
 /* 284 */ "explain_options ::=",
 /* 285 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 286 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 287 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 288 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 289 */ "agg_func_opt ::=",
 /* 290 */ "agg_func_opt ::= AGGREGATE",
 /* 291 */ "bufsize_opt ::=",
 /* 292 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 293 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 294 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 295 */ "stream_options ::=",
 /* 296 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 297 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 298 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 299 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 300 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 301 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 302 */ "subtable_opt ::=",
 /* 303 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 304 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 305 */ "cmd ::= KILL QUERY NK_STRING",
 /* 306 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 307 */ "cmd ::= BALANCE VGROUP",
 /* 308 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 309 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 310 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 311 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 312 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 313 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 314 */ "cmd ::= query_or_subquery",
 /* 315 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 316 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 317 */ "literal ::= NK_INTEGER",
 /* 318 */ "literal ::= NK_FLOAT",
 /* 319 */ "literal ::= NK_STRING",
 /* 320 */ "literal ::= NK_BOOL",
 /* 321 */ "literal ::= TIMESTAMP NK_STRING",
 /* 322 */ "literal ::= duration_literal",
 /* 323 */ "literal ::= NULL",
 /* 324 */ "literal ::= NK_QUESTION",
 /* 325 */ "duration_literal ::= NK_VARIABLE",
 /* 326 */ "signed ::= NK_INTEGER",
 /* 327 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 328 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 329 */ "signed ::= NK_FLOAT",
 /* 330 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 331 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 332 */ "signed_literal ::= signed",
 /* 333 */ "signed_literal ::= NK_STRING",
 /* 334 */ "signed_literal ::= NK_BOOL",
 /* 335 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 336 */ "signed_literal ::= duration_literal",
 /* 337 */ "signed_literal ::= NULL",
 /* 338 */ "signed_literal ::= literal_func",
 /* 339 */ "signed_literal ::= NK_QUESTION",
 /* 340 */ "literal_list ::= signed_literal",
 /* 341 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 342 */ "db_name ::= NK_ID",
 /* 343 */ "table_name ::= NK_ID",
 /* 344 */ "column_name ::= NK_ID",
 /* 345 */ "function_name ::= NK_ID",
 /* 346 */ "table_alias ::= NK_ID",
 /* 347 */ "column_alias ::= NK_ID",
 /* 348 */ "user_name ::= NK_ID",
 /* 349 */ "topic_name ::= NK_ID",
 /* 350 */ "stream_name ::= NK_ID",
 /* 351 */ "cgroup_name ::= NK_ID",
 /* 352 */ "expr_or_subquery ::= expression",
 /* 353 */ "expression ::= literal",
 /* 354 */ "expression ::= pseudo_column",
 /* 355 */ "expression ::= column_reference",
 /* 356 */ "expression ::= function_expression",
 /* 357 */ "expression ::= case_when_expression",
 /* 358 */ "expression ::= NK_LP expression NK_RP",
 /* 359 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 360 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 361 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 362 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 363 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 364 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 365 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 366 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 367 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 368 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 369 */ "expression_list ::= expr_or_subquery",
 /* 370 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 371 */ "column_reference ::= column_name",
 /* 372 */ "column_reference ::= table_name NK_DOT column_name",
 /* 373 */ "pseudo_column ::= ROWTS",
 /* 374 */ "pseudo_column ::= TBNAME",
 /* 375 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 376 */ "pseudo_column ::= QSTART",
 /* 377 */ "pseudo_column ::= QEND",
 /* 378 */ "pseudo_column ::= QDURATION",
 /* 379 */ "pseudo_column ::= WSTART",
 /* 380 */ "pseudo_column ::= WEND",
 /* 381 */ "pseudo_column ::= WDURATION",
 /* 382 */ "pseudo_column ::= IROWTS",
 /* 383 */ "pseudo_column ::= QTAGS",
 /* 384 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 385 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 386 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 387 */ "function_expression ::= literal_func",
 /* 388 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 389 */ "literal_func ::= NOW",
 /* 390 */ "noarg_func ::= NOW",
 /* 391 */ "noarg_func ::= TODAY",
 /* 392 */ "noarg_func ::= TIMEZONE",
 /* 393 */ "noarg_func ::= DATABASE",
 /* 394 */ "noarg_func ::= CLIENT_VERSION",
 /* 395 */ "noarg_func ::= SERVER_VERSION",
 /* 396 */ "noarg_func ::= SERVER_STATUS",
 /* 397 */ "noarg_func ::= CURRENT_USER",
 /* 398 */ "noarg_func ::= USER",
 /* 399 */ "star_func ::= COUNT",
 /* 400 */ "star_func ::= FIRST",
 /* 401 */ "star_func ::= LAST",
 /* 402 */ "star_func ::= LAST_ROW",
 /* 403 */ "star_func_para_list ::= NK_STAR",
 /* 404 */ "star_func_para_list ::= other_para_list",
 /* 405 */ "other_para_list ::= star_func_para",
 /* 406 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 407 */ "star_func_para ::= expr_or_subquery",
 /* 408 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 409 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 410 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 411 */ "when_then_list ::= when_then_expr",
 /* 412 */ "when_then_list ::= when_then_list when_then_expr",
 /* 413 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 414 */ "case_when_else_opt ::=",
 /* 415 */ "case_when_else_opt ::= ELSE common_expression",
 /* 416 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 417 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 418 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 419 */ "predicate ::= expr_or_subquery IS NULL",
 /* 420 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 421 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 422 */ "compare_op ::= NK_LT",
 /* 423 */ "compare_op ::= NK_GT",
 /* 424 */ "compare_op ::= NK_LE",
 /* 425 */ "compare_op ::= NK_GE",
 /* 426 */ "compare_op ::= NK_NE",
 /* 427 */ "compare_op ::= NK_EQ",
 /* 428 */ "compare_op ::= LIKE",
 /* 429 */ "compare_op ::= NOT LIKE",
 /* 430 */ "compare_op ::= MATCH",
 /* 431 */ "compare_op ::= NMATCH",
 /* 432 */ "compare_op ::= CONTAINS",
 /* 433 */ "in_op ::= IN",
 /* 434 */ "in_op ::= NOT IN",
 /* 435 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 436 */ "boolean_value_expression ::= boolean_primary",
 /* 437 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 438 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 439 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 440 */ "boolean_primary ::= predicate",
 /* 441 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 442 */ "common_expression ::= expr_or_subquery",
 /* 443 */ "common_expression ::= boolean_value_expression",
 /* 444 */ "from_clause_opt ::=",
 /* 445 */ "from_clause_opt ::= FROM table_reference_list",
 /* 446 */ "table_reference_list ::= table_reference",
 /* 447 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 448 */ "table_reference ::= table_primary",
 /* 449 */ "table_reference ::= joined_table",
 /* 450 */ "table_primary ::= table_name alias_opt",
 /* 451 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 452 */ "table_primary ::= subquery alias_opt",
 /* 453 */ "table_primary ::= parenthesized_joined_table",
 /* 454 */ "alias_opt ::=",
 /* 455 */ "alias_opt ::= table_alias",
 /* 456 */ "alias_opt ::= AS table_alias",
 /* 457 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 458 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 459 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 460 */ "join_type ::=",
 /* 461 */ "join_type ::= INNER",
 /* 462 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 463 */ "set_quantifier_opt ::=",
 /* 464 */ "set_quantifier_opt ::= DISTINCT",
 /* 465 */ "set_quantifier_opt ::= ALL",
 /* 466 */ "select_list ::= select_item",
 /* 467 */ "select_list ::= select_list NK_COMMA select_item",
 /* 468 */ "select_item ::= NK_STAR",
 /* 469 */ "select_item ::= common_expression",
 /* 470 */ "select_item ::= common_expression column_alias",
 /* 471 */ "select_item ::= common_expression AS column_alias",
 /* 472 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 473 */ "where_clause_opt ::=",
 /* 474 */ "where_clause_opt ::= WHERE search_condition",
 /* 475 */ "partition_by_clause_opt ::=",
 /* 476 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 477 */ "partition_list ::= partition_item",
 /* 478 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 479 */ "partition_item ::= expr_or_subquery",
 /* 480 */ "partition_item ::= expr_or_subquery column_alias",
 /* 481 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 482 */ "twindow_clause_opt ::=",
 /* 483 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 484 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 485 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 486 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 487 */ "sliding_opt ::=",
 /* 488 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 489 */ "fill_opt ::=",
 /* 490 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 491 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 492 */ "fill_mode ::= NONE",
 /* 493 */ "fill_mode ::= PREV",
 /* 494 */ "fill_mode ::= NULL",
 /* 495 */ "fill_mode ::= LINEAR",
 /* 496 */ "fill_mode ::= NEXT",
 /* 497 */ "group_by_clause_opt ::=",
 /* 498 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 499 */ "group_by_list ::= expr_or_subquery",
 /* 500 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 501 */ "having_clause_opt ::=",
 /* 502 */ "having_clause_opt ::= HAVING search_condition",
 /* 503 */ "range_opt ::=",
 /* 504 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 505 */ "every_opt ::=",
 /* 506 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 507 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 508 */ "query_simple ::= query_specification",
 /* 509 */ "query_simple ::= union_query_expression",
 /* 510 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 511 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 512 */ "query_simple_or_subquery ::= query_simple",
 /* 513 */ "query_simple_or_subquery ::= subquery",
 /* 514 */ "query_or_subquery ::= query_expression",
 /* 515 */ "query_or_subquery ::= subquery",
 /* 516 */ "order_by_clause_opt ::=",
 /* 517 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 518 */ "slimit_clause_opt ::=",
 /* 519 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 520 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 521 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 522 */ "limit_clause_opt ::=",
 /* 523 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 524 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 525 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 526 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 527 */ "subquery ::= NK_LP subquery NK_RP",
 /* 528 */ "search_condition ::= common_expression",
 /* 529 */ "sort_specification_list ::= sort_specification",
 /* 530 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 531 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 532 */ "ordering_specification_opt ::=",
 /* 533 */ "ordering_specification_opt ::= ASC",
 /* 534 */ "ordering_specification_opt ::= DESC",
 /* 535 */ "null_ordering_opt ::=",
 /* 536 */ "null_ordering_opt ::= NULLS FIRST",
 /* 537 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 322: /* cmd */
    case 325: /* literal */
    case 338: /* db_options */
    case 340: /* alter_db_options */
    case 346: /* retention */
    case 347: /* full_table_name */
    case 350: /* table_options */
    case 354: /* alter_table_clause */
    case 355: /* alter_table_options */
    case 358: /* signed_literal */
    case 359: /* create_subtable_clause */
    case 362: /* drop_table_clause */
    case 365: /* column_def */
    case 369: /* duration_literal */
    case 370: /* rollup_func_name */
    case 372: /* col_name */
    case 373: /* db_name_cond_opt */
    case 374: /* like_pattern_opt */
    case 375: /* table_name_cond */
    case 376: /* from_db_opt */
    case 378: /* tag_item */
    case 380: /* index_options */
    case 382: /* sliding_opt */
    case 383: /* sma_stream_opt */
    case 384: /* func */
    case 385: /* query_or_subquery */
    case 388: /* explain_options */
    case 392: /* stream_options */
    case 393: /* subtable_opt */
    case 394: /* expression */
    case 396: /* where_clause_opt */
    case 397: /* signed */
    case 398: /* literal_func */
    case 401: /* expr_or_subquery */
    case 402: /* pseudo_column */
    case 403: /* column_reference */
    case 404: /* function_expression */
    case 405: /* case_when_expression */
    case 410: /* star_func_para */
    case 412: /* case_when_else_opt */
    case 413: /* common_expression */
    case 414: /* when_then_expr */
    case 415: /* predicate */
    case 418: /* in_predicate_value */
    case 419: /* boolean_value_expression */
    case 420: /* boolean_primary */
    case 421: /* from_clause_opt */
    case 422: /* table_reference_list */
    case 423: /* table_reference */
    case 424: /* table_primary */
    case 425: /* joined_table */
    case 427: /* subquery */
    case 428: /* parenthesized_joined_table */
    case 430: /* search_condition */
    case 431: /* query_specification */
    case 435: /* range_opt */
    case 436: /* every_opt */
    case 437: /* fill_opt */
    case 438: /* twindow_clause_opt */
    case 440: /* having_clause_opt */
    case 441: /* select_item */
    case 443: /* partition_item */
    case 446: /* query_expression */
    case 447: /* query_simple */
    case 449: /* slimit_clause_opt */
    case 450: /* limit_clause_opt */
    case 451: /* union_query_expression */
    case 452: /* query_simple_or_subquery */
    case 454: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy148)); 
}
      break;
    case 323: /* account_options */
    case 324: /* alter_account_options */
    case 326: /* alter_account_option */
    case 341: /* speed_opt */
    case 390: /* bufsize_opt */
{
 
}
      break;
    case 327: /* user_name */
    case 330: /* priv_level */
    case 333: /* db_name */
    case 334: /* topic_name */
    case 335: /* dnode_endpoint */
    case 356: /* column_name */
    case 364: /* table_name */
    case 371: /* function_name */
    case 379: /* column_alias */
    case 386: /* cgroup_name */
    case 391: /* stream_name */
    case 400: /* table_alias */
    case 406: /* star_func */
    case 408: /* noarg_func */
    case 426: /* alias_opt */
{
 
}
      break;
    case 328: /* sysinfo_opt */
{
 
}
      break;
    case 329: /* privileges */
    case 331: /* priv_type_list */
    case 332: /* priv_type */
{
 
}
      break;
    case 336: /* force_opt */
    case 337: /* not_exists_opt */
    case 339: /* exists_opt */
    case 387: /* analyze_opt */
    case 389: /* agg_func_opt */
    case 432: /* set_quantifier_opt */
{
 
}
      break;
    case 342: /* integer_list */
    case 343: /* variable_list */
    case 344: /* retention_list */
    case 348: /* column_def_list */
    case 349: /* tags_def_opt */
    case 351: /* multi_create_clause */
    case 352: /* tags_def */
    case 353: /* multi_drop_clause */
    case 360: /* specific_cols_opt */
    case 361: /* expression_list */
    case 363: /* col_name_list */
    case 366: /* duration_list */
    case 367: /* rollup_func_list */
    case 377: /* tag_list_opt */
    case 381: /* func_list */
    case 395: /* dnode_list */
    case 399: /* literal_list */
    case 407: /* star_func_para_list */
    case 409: /* other_para_list */
    case 411: /* when_then_list */
    case 433: /* select_list */
    case 434: /* partition_by_clause_opt */
    case 439: /* group_by_clause_opt */
    case 442: /* partition_list */
    case 445: /* group_by_list */
    case 448: /* order_by_clause_opt */
    case 453: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy404)); 
}
      break;
    case 345: /* alter_db_option */
    case 368: /* alter_table_option */
{
 
}
      break;
    case 357: /* type_name */
{
 
}
      break;
    case 416: /* compare_op */
    case 417: /* in_op */
{
 
}
      break;
    case 429: /* join_type */
{
 
}
      break;
    case 444: /* fill_mode */
{
 
}
      break;
    case 455: /* ordering_specification_opt */
{
 
}
      break;
    case 456: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  322,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  322,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  323,    0 }, /* (2) account_options ::= */
  {  323,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  323,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  323,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  323,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  323,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  323,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  323,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  323,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  323,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  324,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  324,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  326,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  326,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  326,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  326,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  326,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  326,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  326,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  326,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  326,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  326,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  322,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  322,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  322,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  322,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  322,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  328,    0 }, /* (29) sysinfo_opt ::= */
  {  328,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  322,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  322,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  329,   -1 }, /* (33) privileges ::= ALL */
  {  329,   -1 }, /* (34) privileges ::= priv_type_list */
  {  329,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  331,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  331,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  332,   -1 }, /* (38) priv_type ::= READ */
  {  332,   -1 }, /* (39) priv_type ::= WRITE */
  {  330,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  330,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  330,   -1 }, /* (42) priv_level ::= topic_name */
  {  322,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  322,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  322,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  322,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  322,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  322,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  322,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  322,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  335,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  335,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  335,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  336,    0 }, /* (54) force_opt ::= */
  {  336,   -1 }, /* (55) force_opt ::= FORCE */
  {  322,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  322,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  322,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  322,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  322,   -2 }, /* (68) cmd ::= USE db_name */
  {  322,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  322,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  322,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  337,   -3 }, /* (72) not_exists_opt ::= IF NOT EXISTS */
  {  337,    0 }, /* (73) not_exists_opt ::= */
  {  339,   -2 }, /* (74) exists_opt ::= IF EXISTS */
  {  339,    0 }, /* (75) exists_opt ::= */
  {  338,    0 }, /* (76) db_options ::= */
  {  338,   -3 }, /* (77) db_options ::= db_options BUFFER NK_INTEGER */
  {  338,   -3 }, /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
  {  338,   -3 }, /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  338,   -3 }, /* (80) db_options ::= db_options COMP NK_INTEGER */
  {  338,   -3 }, /* (81) db_options ::= db_options DURATION NK_INTEGER */
  {  338,   -3 }, /* (82) db_options ::= db_options DURATION NK_VARIABLE */
  {  338,   -3 }, /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
  {  338,   -3 }, /* (84) db_options ::= db_options MINROWS NK_INTEGER */
  {  338,   -3 }, /* (85) db_options ::= db_options KEEP integer_list */
  {  338,   -3 }, /* (86) db_options ::= db_options KEEP variable_list */
  {  338,   -3 }, /* (87) db_options ::= db_options PAGES NK_INTEGER */
  {  338,   -3 }, /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  338,   -3 }, /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  338,   -3 }, /* (90) db_options ::= db_options PRECISION NK_STRING */
  {  338,   -3 }, /* (91) db_options ::= db_options REPLICA NK_INTEGER */
  {  338,   -3 }, /* (92) db_options ::= db_options VGROUPS NK_INTEGER */
  {  338,   -3 }, /* (93) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  338,   -3 }, /* (94) db_options ::= db_options RETENTIONS retention_list */
  {  338,   -3 }, /* (95) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  338,   -3 }, /* (96) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  338,   -3 }, /* (97) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  338,   -3 }, /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  338,   -4 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  338,   -3 }, /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  338,   -4 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  338,   -3 }, /* (102) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  338,   -3 }, /* (103) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  338,   -3 }, /* (104) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  338,   -3 }, /* (105) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  338,   -3 }, /* (106) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  340,   -1 }, /* (107) alter_db_options ::= alter_db_option */
  {  340,   -2 }, /* (108) alter_db_options ::= alter_db_options alter_db_option */
  {  345,   -2 }, /* (109) alter_db_option ::= BUFFER NK_INTEGER */
  {  345,   -2 }, /* (110) alter_db_option ::= CACHEMODEL NK_STRING */
  {  345,   -2 }, /* (111) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  345,   -2 }, /* (112) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  345,   -2 }, /* (113) alter_db_option ::= KEEP integer_list */
  {  345,   -2 }, /* (114) alter_db_option ::= KEEP variable_list */
  {  345,   -2 }, /* (115) alter_db_option ::= PAGES NK_INTEGER */
  {  345,   -2 }, /* (116) alter_db_option ::= REPLICA NK_INTEGER */
  {  345,   -2 }, /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  345,   -2 }, /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  342,   -1 }, /* (119) integer_list ::= NK_INTEGER */
  {  342,   -3 }, /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  343,   -1 }, /* (121) variable_list ::= NK_VARIABLE */
  {  343,   -3 }, /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  344,   -1 }, /* (123) retention_list ::= retention */
  {  344,   -3 }, /* (124) retention_list ::= retention_list NK_COMMA retention */
  {  346,   -3 }, /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  341,    0 }, /* (126) speed_opt ::= */
  {  341,   -2 }, /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  322,   -9 }, /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  322,   -3 }, /* (129) cmd ::= CREATE TABLE multi_create_clause */
  {  322,   -9 }, /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  322,   -3 }, /* (131) cmd ::= DROP TABLE multi_drop_clause */
  {  322,   -4 }, /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
  {  322,   -3 }, /* (133) cmd ::= ALTER TABLE alter_table_clause */
  {  322,   -3 }, /* (134) cmd ::= ALTER STABLE alter_table_clause */
  {  354,   -2 }, /* (135) alter_table_clause ::= full_table_name alter_table_options */
  {  354,   -5 }, /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  354,   -4 }, /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  354,   -5 }, /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  354,   -5 }, /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  354,   -5 }, /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  354,   -4 }, /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  354,   -5 }, /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  354,   -5 }, /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  354,   -6 }, /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  351,   -1 }, /* (145) multi_create_clause ::= create_subtable_clause */
  {  351,   -2 }, /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  359,  -10 }, /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  353,   -1 }, /* (148) multi_drop_clause ::= drop_table_clause */
  {  353,   -2 }, /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  362,   -2 }, /* (150) drop_table_clause ::= exists_opt full_table_name */
  {  360,    0 }, /* (151) specific_cols_opt ::= */
  {  360,   -3 }, /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  347,   -1 }, /* (153) full_table_name ::= table_name */
  {  347,   -3 }, /* (154) full_table_name ::= db_name NK_DOT table_name */
  {  348,   -1 }, /* (155) column_def_list ::= column_def */
  {  348,   -3 }, /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
  {  365,   -2 }, /* (157) column_def ::= column_name type_name */
  {  365,   -4 }, /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
  {  357,   -1 }, /* (159) type_name ::= BOOL */
  {  357,   -1 }, /* (160) type_name ::= TINYINT */
  {  357,   -1 }, /* (161) type_name ::= SMALLINT */
  {  357,   -1 }, /* (162) type_name ::= INT */
  {  357,   -1 }, /* (163) type_name ::= INTEGER */
  {  357,   -1 }, /* (164) type_name ::= BIGINT */
  {  357,   -1 }, /* (165) type_name ::= FLOAT */
  {  357,   -1 }, /* (166) type_name ::= DOUBLE */
  {  357,   -4 }, /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  357,   -1 }, /* (168) type_name ::= TIMESTAMP */
  {  357,   -4 }, /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  357,   -2 }, /* (170) type_name ::= TINYINT UNSIGNED */
  {  357,   -2 }, /* (171) type_name ::= SMALLINT UNSIGNED */
  {  357,   -2 }, /* (172) type_name ::= INT UNSIGNED */
  {  357,   -2 }, /* (173) type_name ::= BIGINT UNSIGNED */
  {  357,   -1 }, /* (174) type_name ::= JSON */
  {  357,   -4 }, /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  357,   -1 }, /* (176) type_name ::= MEDIUMBLOB */
  {  357,   -1 }, /* (177) type_name ::= BLOB */
  {  357,   -4 }, /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  357,   -1 }, /* (179) type_name ::= DECIMAL */
  {  357,   -4 }, /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  357,   -6 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  349,    0 }, /* (182) tags_def_opt ::= */
  {  349,   -1 }, /* (183) tags_def_opt ::= tags_def */
  {  352,   -4 }, /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  350,    0 }, /* (185) table_options ::= */
  {  350,   -3 }, /* (186) table_options ::= table_options COMMENT NK_STRING */
  {  350,   -3 }, /* (187) table_options ::= table_options MAX_DELAY duration_list */
  {  350,   -3 }, /* (188) table_options ::= table_options WATERMARK duration_list */
  {  350,   -5 }, /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  350,   -3 }, /* (190) table_options ::= table_options TTL NK_INTEGER */
  {  350,   -5 }, /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  350,   -3 }, /* (192) table_options ::= table_options DELETE_MARK duration_list */
  {  355,   -1 }, /* (193) alter_table_options ::= alter_table_option */
  {  355,   -2 }, /* (194) alter_table_options ::= alter_table_options alter_table_option */
  {  368,   -2 }, /* (195) alter_table_option ::= COMMENT NK_STRING */
  {  368,   -2 }, /* (196) alter_table_option ::= TTL NK_INTEGER */
  {  366,   -1 }, /* (197) duration_list ::= duration_literal */
  {  366,   -3 }, /* (198) duration_list ::= duration_list NK_COMMA duration_literal */
  {  367,   -1 }, /* (199) rollup_func_list ::= rollup_func_name */
  {  367,   -3 }, /* (200) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  370,   -1 }, /* (201) rollup_func_name ::= function_name */
  {  370,   -1 }, /* (202) rollup_func_name ::= FIRST */
  {  370,   -1 }, /* (203) rollup_func_name ::= LAST */
  {  363,   -1 }, /* (204) col_name_list ::= col_name */
  {  363,   -3 }, /* (205) col_name_list ::= col_name_list NK_COMMA col_name */
  {  372,   -1 }, /* (206) col_name ::= column_name */
  {  322,   -2 }, /* (207) cmd ::= SHOW DNODES */
  {  322,   -2 }, /* (208) cmd ::= SHOW USERS */
  {  322,   -3 }, /* (209) cmd ::= SHOW USER PRIVILEGES */
  {  322,   -2 }, /* (210) cmd ::= SHOW DATABASES */
  {  322,   -4 }, /* (211) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  322,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  322,   -3 }, /* (213) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  322,   -2 }, /* (214) cmd ::= SHOW MNODES */
  {  322,   -2 }, /* (215) cmd ::= SHOW QNODES */
  {  322,   -2 }, /* (216) cmd ::= SHOW FUNCTIONS */
  {  322,   -5 }, /* (217) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  322,   -2 }, /* (218) cmd ::= SHOW STREAMS */
  {  322,   -2 }, /* (219) cmd ::= SHOW ACCOUNTS */
  {  322,   -2 }, /* (220) cmd ::= SHOW APPS */
  {  322,   -2 }, /* (221) cmd ::= SHOW CONNECTIONS */
  {  322,   -2 }, /* (222) cmd ::= SHOW LICENCES */
  {  322,   -2 }, /* (223) cmd ::= SHOW GRANTS */
  {  322,   -4 }, /* (224) cmd ::= SHOW CREATE DATABASE db_name */
  {  322,   -4 }, /* (225) cmd ::= SHOW CREATE TABLE full_table_name */
  {  322,   -4 }, /* (226) cmd ::= SHOW CREATE STABLE full_table_name */
  {  322,   -2 }, /* (227) cmd ::= SHOW QUERIES */
  {  322,   -2 }, /* (228) cmd ::= SHOW SCORES */
  {  322,   -2 }, /* (229) cmd ::= SHOW TOPICS */
  {  322,   -2 }, /* (230) cmd ::= SHOW VARIABLES */
  {  322,   -3 }, /* (231) cmd ::= SHOW CLUSTER VARIABLES */
  {  322,   -3 }, /* (232) cmd ::= SHOW LOCAL VARIABLES */
  {  322,   -5 }, /* (233) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  322,   -2 }, /* (234) cmd ::= SHOW BNODES */
  {  322,   -2 }, /* (235) cmd ::= SHOW SNODES */
  {  322,   -2 }, /* (236) cmd ::= SHOW CLUSTER */
  {  322,   -2 }, /* (237) cmd ::= SHOW TRANSACTIONS */
  {  322,   -4 }, /* (238) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  322,   -2 }, /* (239) cmd ::= SHOW CONSUMERS */
  {  322,   -2 }, /* (240) cmd ::= SHOW SUBSCRIPTIONS */
  {  322,   -5 }, /* (241) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  322,   -7 }, /* (242) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  322,   -3 }, /* (243) cmd ::= SHOW VNODES NK_INTEGER */
  {  322,   -3 }, /* (244) cmd ::= SHOW VNODES NK_STRING */
  {  373,    0 }, /* (245) db_name_cond_opt ::= */
  {  373,   -2 }, /* (246) db_name_cond_opt ::= db_name NK_DOT */
  {  374,    0 }, /* (247) like_pattern_opt ::= */
  {  374,   -2 }, /* (248) like_pattern_opt ::= LIKE NK_STRING */
  {  375,   -1 }, /* (249) table_name_cond ::= table_name */
  {  376,    0 }, /* (250) from_db_opt ::= */
  {  376,   -2 }, /* (251) from_db_opt ::= FROM db_name */
  {  377,    0 }, /* (252) tag_list_opt ::= */
  {  377,   -1 }, /* (253) tag_list_opt ::= tag_item */
  {  377,   -3 }, /* (254) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  378,   -1 }, /* (255) tag_item ::= TBNAME */
  {  378,   -1 }, /* (256) tag_item ::= QTAGS */
  {  378,   -1 }, /* (257) tag_item ::= column_name */
  {  378,   -2 }, /* (258) tag_item ::= column_name column_alias */
  {  378,   -3 }, /* (259) tag_item ::= column_name AS column_alias */
  {  322,   -8 }, /* (260) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  322,   -4 }, /* (261) cmd ::= DROP INDEX exists_opt full_table_name */
  {  380,  -10 }, /* (262) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  380,  -12 }, /* (263) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  381,   -1 }, /* (264) func_list ::= func */
  {  381,   -3 }, /* (265) func_list ::= func_list NK_COMMA func */
  {  384,   -4 }, /* (266) func ::= function_name NK_LP expression_list NK_RP */
  {  383,    0 }, /* (267) sma_stream_opt ::= */
  {  383,   -3 }, /* (268) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  383,   -3 }, /* (269) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  383,   -3 }, /* (270) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  322,   -6 }, /* (271) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  322,   -7 }, /* (272) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  322,   -9 }, /* (273) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  322,   -7 }, /* (274) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  322,   -9 }, /* (275) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  322,   -4 }, /* (276) cmd ::= DROP TOPIC exists_opt topic_name */
  {  322,   -7 }, /* (277) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  322,   -2 }, /* (278) cmd ::= DESC full_table_name */
  {  322,   -2 }, /* (279) cmd ::= DESCRIBE full_table_name */
  {  322,   -3 }, /* (280) cmd ::= RESET QUERY CACHE */
  {  322,   -4 }, /* (281) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  387,    0 }, /* (282) analyze_opt ::= */
  {  387,   -1 }, /* (283) analyze_opt ::= ANALYZE */
  {  388,    0 }, /* (284) explain_options ::= */
  {  388,   -3 }, /* (285) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  388,   -3 }, /* (286) explain_options ::= explain_options RATIO NK_FLOAT */
  {  322,  -10 }, /* (287) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  322,   -4 }, /* (288) cmd ::= DROP FUNCTION exists_opt function_name */
  {  389,    0 }, /* (289) agg_func_opt ::= */
  {  389,   -1 }, /* (290) agg_func_opt ::= AGGREGATE */
  {  390,    0 }, /* (291) bufsize_opt ::= */
  {  390,   -2 }, /* (292) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  322,  -11 }, /* (293) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  322,   -4 }, /* (294) cmd ::= DROP STREAM exists_opt stream_name */
  {  392,    0 }, /* (295) stream_options ::= */
  {  392,   -3 }, /* (296) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  392,   -3 }, /* (297) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  392,   -4 }, /* (298) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  392,   -3 }, /* (299) stream_options ::= stream_options WATERMARK duration_literal */
  {  392,   -4 }, /* (300) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  392,   -3 }, /* (301) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  393,    0 }, /* (302) subtable_opt ::= */
  {  393,   -4 }, /* (303) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  322,   -3 }, /* (304) cmd ::= KILL CONNECTION NK_INTEGER */
  {  322,   -3 }, /* (305) cmd ::= KILL QUERY NK_STRING */
  {  322,   -3 }, /* (306) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  322,   -2 }, /* (307) cmd ::= BALANCE VGROUP */
  {  322,   -4 }, /* (308) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  322,   -4 }, /* (309) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  322,   -3 }, /* (310) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  395,   -2 }, /* (311) dnode_list ::= DNODE NK_INTEGER */
  {  395,   -3 }, /* (312) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  322,   -4 }, /* (313) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  322,   -1 }, /* (314) cmd ::= query_or_subquery */
  {  322,   -7 }, /* (315) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  322,   -4 }, /* (316) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  325,   -1 }, /* (317) literal ::= NK_INTEGER */
  {  325,   -1 }, /* (318) literal ::= NK_FLOAT */
  {  325,   -1 }, /* (319) literal ::= NK_STRING */
  {  325,   -1 }, /* (320) literal ::= NK_BOOL */
  {  325,   -2 }, /* (321) literal ::= TIMESTAMP NK_STRING */
  {  325,   -1 }, /* (322) literal ::= duration_literal */
  {  325,   -1 }, /* (323) literal ::= NULL */
  {  325,   -1 }, /* (324) literal ::= NK_QUESTION */
  {  369,   -1 }, /* (325) duration_literal ::= NK_VARIABLE */
  {  397,   -1 }, /* (326) signed ::= NK_INTEGER */
  {  397,   -2 }, /* (327) signed ::= NK_PLUS NK_INTEGER */
  {  397,   -2 }, /* (328) signed ::= NK_MINUS NK_INTEGER */
  {  397,   -1 }, /* (329) signed ::= NK_FLOAT */
  {  397,   -2 }, /* (330) signed ::= NK_PLUS NK_FLOAT */
  {  397,   -2 }, /* (331) signed ::= NK_MINUS NK_FLOAT */
  {  358,   -1 }, /* (332) signed_literal ::= signed */
  {  358,   -1 }, /* (333) signed_literal ::= NK_STRING */
  {  358,   -1 }, /* (334) signed_literal ::= NK_BOOL */
  {  358,   -2 }, /* (335) signed_literal ::= TIMESTAMP NK_STRING */
  {  358,   -1 }, /* (336) signed_literal ::= duration_literal */
  {  358,   -1 }, /* (337) signed_literal ::= NULL */
  {  358,   -1 }, /* (338) signed_literal ::= literal_func */
  {  358,   -1 }, /* (339) signed_literal ::= NK_QUESTION */
  {  399,   -1 }, /* (340) literal_list ::= signed_literal */
  {  399,   -3 }, /* (341) literal_list ::= literal_list NK_COMMA signed_literal */
  {  333,   -1 }, /* (342) db_name ::= NK_ID */
  {  364,   -1 }, /* (343) table_name ::= NK_ID */
  {  356,   -1 }, /* (344) column_name ::= NK_ID */
  {  371,   -1 }, /* (345) function_name ::= NK_ID */
  {  400,   -1 }, /* (346) table_alias ::= NK_ID */
  {  379,   -1 }, /* (347) column_alias ::= NK_ID */
  {  327,   -1 }, /* (348) user_name ::= NK_ID */
  {  334,   -1 }, /* (349) topic_name ::= NK_ID */
  {  391,   -1 }, /* (350) stream_name ::= NK_ID */
  {  386,   -1 }, /* (351) cgroup_name ::= NK_ID */
  {  401,   -1 }, /* (352) expr_or_subquery ::= expression */
  {  394,   -1 }, /* (353) expression ::= literal */
  {  394,   -1 }, /* (354) expression ::= pseudo_column */
  {  394,   -1 }, /* (355) expression ::= column_reference */
  {  394,   -1 }, /* (356) expression ::= function_expression */
  {  394,   -1 }, /* (357) expression ::= case_when_expression */
  {  394,   -3 }, /* (358) expression ::= NK_LP expression NK_RP */
  {  394,   -2 }, /* (359) expression ::= NK_PLUS expr_or_subquery */
  {  394,   -2 }, /* (360) expression ::= NK_MINUS expr_or_subquery */
  {  394,   -3 }, /* (361) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  394,   -3 }, /* (362) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  394,   -3 }, /* (363) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  394,   -3 }, /* (364) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  394,   -3 }, /* (365) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  394,   -3 }, /* (366) expression ::= column_reference NK_ARROW NK_STRING */
  {  394,   -3 }, /* (367) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  394,   -3 }, /* (368) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  361,   -1 }, /* (369) expression_list ::= expr_or_subquery */
  {  361,   -3 }, /* (370) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  403,   -1 }, /* (371) column_reference ::= column_name */
  {  403,   -3 }, /* (372) column_reference ::= table_name NK_DOT column_name */
  {  402,   -1 }, /* (373) pseudo_column ::= ROWTS */
  {  402,   -1 }, /* (374) pseudo_column ::= TBNAME */
  {  402,   -3 }, /* (375) pseudo_column ::= table_name NK_DOT TBNAME */
  {  402,   -1 }, /* (376) pseudo_column ::= QSTART */
  {  402,   -1 }, /* (377) pseudo_column ::= QEND */
  {  402,   -1 }, /* (378) pseudo_column ::= QDURATION */
  {  402,   -1 }, /* (379) pseudo_column ::= WSTART */
  {  402,   -1 }, /* (380) pseudo_column ::= WEND */
  {  402,   -1 }, /* (381) pseudo_column ::= WDURATION */
  {  402,   -1 }, /* (382) pseudo_column ::= IROWTS */
  {  402,   -1 }, /* (383) pseudo_column ::= QTAGS */
  {  404,   -4 }, /* (384) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  404,   -4 }, /* (385) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  404,   -6 }, /* (386) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  404,   -1 }, /* (387) function_expression ::= literal_func */
  {  398,   -3 }, /* (388) literal_func ::= noarg_func NK_LP NK_RP */
  {  398,   -1 }, /* (389) literal_func ::= NOW */
  {  408,   -1 }, /* (390) noarg_func ::= NOW */
  {  408,   -1 }, /* (391) noarg_func ::= TODAY */
  {  408,   -1 }, /* (392) noarg_func ::= TIMEZONE */
  {  408,   -1 }, /* (393) noarg_func ::= DATABASE */
  {  408,   -1 }, /* (394) noarg_func ::= CLIENT_VERSION */
  {  408,   -1 }, /* (395) noarg_func ::= SERVER_VERSION */
  {  408,   -1 }, /* (396) noarg_func ::= SERVER_STATUS */
  {  408,   -1 }, /* (397) noarg_func ::= CURRENT_USER */
  {  408,   -1 }, /* (398) noarg_func ::= USER */
  {  406,   -1 }, /* (399) star_func ::= COUNT */
  {  406,   -1 }, /* (400) star_func ::= FIRST */
  {  406,   -1 }, /* (401) star_func ::= LAST */
  {  406,   -1 }, /* (402) star_func ::= LAST_ROW */
  {  407,   -1 }, /* (403) star_func_para_list ::= NK_STAR */
  {  407,   -1 }, /* (404) star_func_para_list ::= other_para_list */
  {  409,   -1 }, /* (405) other_para_list ::= star_func_para */
  {  409,   -3 }, /* (406) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  410,   -1 }, /* (407) star_func_para ::= expr_or_subquery */
  {  410,   -3 }, /* (408) star_func_para ::= table_name NK_DOT NK_STAR */
  {  405,   -4 }, /* (409) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  405,   -5 }, /* (410) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  411,   -1 }, /* (411) when_then_list ::= when_then_expr */
  {  411,   -2 }, /* (412) when_then_list ::= when_then_list when_then_expr */
  {  414,   -4 }, /* (413) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  412,    0 }, /* (414) case_when_else_opt ::= */
  {  412,   -2 }, /* (415) case_when_else_opt ::= ELSE common_expression */
  {  415,   -3 }, /* (416) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  415,   -5 }, /* (417) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  415,   -6 }, /* (418) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  415,   -3 }, /* (419) predicate ::= expr_or_subquery IS NULL */
  {  415,   -4 }, /* (420) predicate ::= expr_or_subquery IS NOT NULL */
  {  415,   -3 }, /* (421) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  416,   -1 }, /* (422) compare_op ::= NK_LT */
  {  416,   -1 }, /* (423) compare_op ::= NK_GT */
  {  416,   -1 }, /* (424) compare_op ::= NK_LE */
  {  416,   -1 }, /* (425) compare_op ::= NK_GE */
  {  416,   -1 }, /* (426) compare_op ::= NK_NE */
  {  416,   -1 }, /* (427) compare_op ::= NK_EQ */
  {  416,   -1 }, /* (428) compare_op ::= LIKE */
  {  416,   -2 }, /* (429) compare_op ::= NOT LIKE */
  {  416,   -1 }, /* (430) compare_op ::= MATCH */
  {  416,   -1 }, /* (431) compare_op ::= NMATCH */
  {  416,   -1 }, /* (432) compare_op ::= CONTAINS */
  {  417,   -1 }, /* (433) in_op ::= IN */
  {  417,   -2 }, /* (434) in_op ::= NOT IN */
  {  418,   -3 }, /* (435) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  419,   -1 }, /* (436) boolean_value_expression ::= boolean_primary */
  {  419,   -2 }, /* (437) boolean_value_expression ::= NOT boolean_primary */
  {  419,   -3 }, /* (438) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  419,   -3 }, /* (439) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  420,   -1 }, /* (440) boolean_primary ::= predicate */
  {  420,   -3 }, /* (441) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  413,   -1 }, /* (442) common_expression ::= expr_or_subquery */
  {  413,   -1 }, /* (443) common_expression ::= boolean_value_expression */
  {  421,    0 }, /* (444) from_clause_opt ::= */
  {  421,   -2 }, /* (445) from_clause_opt ::= FROM table_reference_list */
  {  422,   -1 }, /* (446) table_reference_list ::= table_reference */
  {  422,   -3 }, /* (447) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  423,   -1 }, /* (448) table_reference ::= table_primary */
  {  423,   -1 }, /* (449) table_reference ::= joined_table */
  {  424,   -2 }, /* (450) table_primary ::= table_name alias_opt */
  {  424,   -4 }, /* (451) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  424,   -2 }, /* (452) table_primary ::= subquery alias_opt */
  {  424,   -1 }, /* (453) table_primary ::= parenthesized_joined_table */
  {  426,    0 }, /* (454) alias_opt ::= */
  {  426,   -1 }, /* (455) alias_opt ::= table_alias */
  {  426,   -2 }, /* (456) alias_opt ::= AS table_alias */
  {  428,   -3 }, /* (457) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  428,   -3 }, /* (458) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  425,   -6 }, /* (459) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  429,    0 }, /* (460) join_type ::= */
  {  429,   -1 }, /* (461) join_type ::= INNER */
  {  431,  -12 }, /* (462) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  432,    0 }, /* (463) set_quantifier_opt ::= */
  {  432,   -1 }, /* (464) set_quantifier_opt ::= DISTINCT */
  {  432,   -1 }, /* (465) set_quantifier_opt ::= ALL */
  {  433,   -1 }, /* (466) select_list ::= select_item */
  {  433,   -3 }, /* (467) select_list ::= select_list NK_COMMA select_item */
  {  441,   -1 }, /* (468) select_item ::= NK_STAR */
  {  441,   -1 }, /* (469) select_item ::= common_expression */
  {  441,   -2 }, /* (470) select_item ::= common_expression column_alias */
  {  441,   -3 }, /* (471) select_item ::= common_expression AS column_alias */
  {  441,   -3 }, /* (472) select_item ::= table_name NK_DOT NK_STAR */
  {  396,    0 }, /* (473) where_clause_opt ::= */
  {  396,   -2 }, /* (474) where_clause_opt ::= WHERE search_condition */
  {  434,    0 }, /* (475) partition_by_clause_opt ::= */
  {  434,   -3 }, /* (476) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  442,   -1 }, /* (477) partition_list ::= partition_item */
  {  442,   -3 }, /* (478) partition_list ::= partition_list NK_COMMA partition_item */
  {  443,   -1 }, /* (479) partition_item ::= expr_or_subquery */
  {  443,   -2 }, /* (480) partition_item ::= expr_or_subquery column_alias */
  {  443,   -3 }, /* (481) partition_item ::= expr_or_subquery AS column_alias */
  {  438,    0 }, /* (482) twindow_clause_opt ::= */
  {  438,   -6 }, /* (483) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  438,   -4 }, /* (484) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  438,   -6 }, /* (485) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  438,   -8 }, /* (486) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  382,    0 }, /* (487) sliding_opt ::= */
  {  382,   -4 }, /* (488) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  437,    0 }, /* (489) fill_opt ::= */
  {  437,   -4 }, /* (490) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  437,   -6 }, /* (491) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  444,   -1 }, /* (492) fill_mode ::= NONE */
  {  444,   -1 }, /* (493) fill_mode ::= PREV */
  {  444,   -1 }, /* (494) fill_mode ::= NULL */
  {  444,   -1 }, /* (495) fill_mode ::= LINEAR */
  {  444,   -1 }, /* (496) fill_mode ::= NEXT */
  {  439,    0 }, /* (497) group_by_clause_opt ::= */
  {  439,   -3 }, /* (498) group_by_clause_opt ::= GROUP BY group_by_list */
  {  445,   -1 }, /* (499) group_by_list ::= expr_or_subquery */
  {  445,   -3 }, /* (500) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  440,    0 }, /* (501) having_clause_opt ::= */
  {  440,   -2 }, /* (502) having_clause_opt ::= HAVING search_condition */
  {  435,    0 }, /* (503) range_opt ::= */
  {  435,   -6 }, /* (504) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  436,    0 }, /* (505) every_opt ::= */
  {  436,   -4 }, /* (506) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  446,   -4 }, /* (507) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  447,   -1 }, /* (508) query_simple ::= query_specification */
  {  447,   -1 }, /* (509) query_simple ::= union_query_expression */
  {  451,   -4 }, /* (510) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  451,   -3 }, /* (511) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  452,   -1 }, /* (512) query_simple_or_subquery ::= query_simple */
  {  452,   -1 }, /* (513) query_simple_or_subquery ::= subquery */
  {  385,   -1 }, /* (514) query_or_subquery ::= query_expression */
  {  385,   -1 }, /* (515) query_or_subquery ::= subquery */
  {  448,    0 }, /* (516) order_by_clause_opt ::= */
  {  448,   -3 }, /* (517) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  449,    0 }, /* (518) slimit_clause_opt ::= */
  {  449,   -2 }, /* (519) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  449,   -4 }, /* (520) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  449,   -4 }, /* (521) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  450,    0 }, /* (522) limit_clause_opt ::= */
  {  450,   -2 }, /* (523) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  450,   -4 }, /* (524) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  450,   -4 }, /* (525) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  427,   -3 }, /* (526) subquery ::= NK_LP query_expression NK_RP */
  {  427,   -3 }, /* (527) subquery ::= NK_LP subquery NK_RP */
  {  430,   -1 }, /* (528) search_condition ::= common_expression */
  {  453,   -1 }, /* (529) sort_specification_list ::= sort_specification */
  {  453,   -3 }, /* (530) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  454,   -3 }, /* (531) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  455,    0 }, /* (532) ordering_specification_opt ::= */
  {  455,   -1 }, /* (533) ordering_specification_opt ::= ASC */
  {  455,   -1 }, /* (534) ordering_specification_opt ::= DESC */
  {  456,    0 }, /* (535) null_ordering_opt ::= */
  {  456,   -2 }, /* (536) null_ordering_opt ::= NULLS FIRST */
  {  456,   -2 }, /* (537) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,323,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,324,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,323,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,325,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,326,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,324,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,326,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,325,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy199, &yymsp[-1].minor.yy0, yymsp[0].minor.yy33); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy199, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy199, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy199, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy199); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy33 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy33 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy525, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy199); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy525, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy199); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy525 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy525 = yymsp[0].minor.yy525; }
  yymsp[0].minor.yy525 = yylhsminor.yy525;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy525 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy525 = yymsp[-2].minor.yy525 | yymsp[0].minor.yy525; }
  yymsp[-2].minor.yy525 = yylhsminor.yy525;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy525 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy525 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy199 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy199 = yylhsminor.yy199;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy199 = yymsp[-2].minor.yy199; }
  yymsp[-2].minor.yy199 = yylhsminor.yy199;
        break;
      case 42: /* priv_level ::= topic_name */
      case 455: /* alias_opt ::= table_alias */ yytestcase(yyruleno==455);
{ yylhsminor.yy199 = yymsp[0].minor.yy199; }
  yymsp[0].minor.yy199 = yylhsminor.yy199;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy199, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy397); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy199, yymsp[0].minor.yy397); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 342: /* db_name ::= NK_ID */ yytestcase(yyruleno==342);
      case 343: /* table_name ::= NK_ID */ yytestcase(yyruleno==343);
      case 344: /* column_name ::= NK_ID */ yytestcase(yyruleno==344);
      case 345: /* function_name ::= NK_ID */ yytestcase(yyruleno==345);
      case 346: /* table_alias ::= NK_ID */ yytestcase(yyruleno==346);
      case 347: /* column_alias ::= NK_ID */ yytestcase(yyruleno==347);
      case 348: /* user_name ::= NK_ID */ yytestcase(yyruleno==348);
      case 349: /* topic_name ::= NK_ID */ yytestcase(yyruleno==349);
      case 350: /* stream_name ::= NK_ID */ yytestcase(yyruleno==350);
      case 351: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==351);
      case 390: /* noarg_func ::= NOW */ yytestcase(yyruleno==390);
      case 391: /* noarg_func ::= TODAY */ yytestcase(yyruleno==391);
      case 392: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==392);
      case 393: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==393);
      case 394: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==394);
      case 395: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==395);
      case 396: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==396);
      case 397: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==397);
      case 398: /* noarg_func ::= USER */ yytestcase(yyruleno==398);
      case 399: /* star_func ::= COUNT */ yytestcase(yyruleno==399);
      case 400: /* star_func ::= FIRST */ yytestcase(yyruleno==400);
      case 401: /* star_func ::= LAST */ yytestcase(yyruleno==401);
      case 402: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==402);
{ yylhsminor.yy199 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy199 = yylhsminor.yy199;
        break;
      case 54: /* force_opt ::= */
      case 73: /* not_exists_opt ::= */ yytestcase(yyruleno==73);
      case 75: /* exists_opt ::= */ yytestcase(yyruleno==75);
      case 282: /* analyze_opt ::= */ yytestcase(yyruleno==282);
      case 289: /* agg_func_opt ::= */ yytestcase(yyruleno==289);
      case 463: /* set_quantifier_opt ::= */ yytestcase(yyruleno==463);
{ yymsp[1].minor.yy397 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 283: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==283);
      case 290: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==290);
      case 464: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==464);
{ yymsp[0].minor.yy397 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy397, &yymsp[-1].minor.yy199, yymsp[0].minor.yy148); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy199); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy199); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy199, yymsp[0].minor.yy148); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy199); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy199, yymsp[0].minor.yy706); }
        break;
      case 72: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy397 = true; }
        break;
      case 74: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy397 = true; }
        break;
      case 76: /* db_options ::= */
{ yymsp[1].minor.yy148 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 77: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 78: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 79: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 80: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 81: /* db_options ::= db_options DURATION NK_INTEGER */
      case 82: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==82);
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 83: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 84: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 85: /* db_options ::= db_options KEEP integer_list */
      case 86: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==86);
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_KEEP, yymsp[0].minor.yy404); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 87: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 88: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 89: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 90: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 91: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 92: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 93: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 94: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_RETENTIONS, yymsp[0].minor.yy404); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 95: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 96: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 97: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-3].minor.yy148, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-3].minor.yy148, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 102: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 103: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 104: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 105: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 106: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 107: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy148 = createAlterDatabaseOptions(pCxt); yylhsminor.yy148 = setAlterDatabaseOption(pCxt, yylhsminor.yy148, &yymsp[0].minor.yy123); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 108: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy148 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy148, &yymsp[0].minor.yy123); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 109: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy123.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= KEEP integer_list */
      case 114: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==114);
{ yymsp[-1].minor.yy123.type = DB_OPTION_KEEP; yymsp[-1].minor.yy123.pList = yymsp[0].minor.yy404; }
        break;
      case 115: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_PAGES; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_WAL; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy404 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 120: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 312: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==312);
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 121: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy404 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 122: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 123: /* retention_list ::= retention */
      case 145: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==145);
      case 148: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==148);
      case 155: /* column_def_list ::= column_def */ yytestcase(yyruleno==155);
      case 199: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==199);
      case 204: /* col_name_list ::= col_name */ yytestcase(yyruleno==204);
      case 253: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==253);
      case 264: /* func_list ::= func */ yytestcase(yyruleno==264);
      case 340: /* literal_list ::= signed_literal */ yytestcase(yyruleno==340);
      case 405: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==405);
      case 411: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==411);
      case 466: /* select_list ::= select_item */ yytestcase(yyruleno==466);
      case 477: /* partition_list ::= partition_item */ yytestcase(yyruleno==477);
      case 529: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==529);
{ yylhsminor.yy404 = createNodeList(pCxt, yymsp[0].minor.yy148); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 124: /* retention_list ::= retention_list NK_COMMA retention */
      case 156: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==205);
      case 254: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==254);
      case 265: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==265);
      case 341: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==341);
      case 406: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==406);
      case 467: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==467);
      case 478: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==478);
      case 530: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==530);
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, yymsp[0].minor.yy148); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 125: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy148 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 126: /* speed_opt ::= */
      case 291: /* bufsize_opt ::= */ yytestcase(yyruleno==291);
{ yymsp[1].minor.yy706 = 0; }
        break;
      case 127: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 292: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==292);
{ yymsp[-1].minor.yy706 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 128: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 130: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==130);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy397, yymsp[-5].minor.yy148, yymsp[-3].minor.yy404, yymsp[-1].minor.yy404, yymsp[0].minor.yy148); }
        break;
      case 129: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy404); }
        break;
      case 131: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy404); }
        break;
      case 132: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy397, yymsp[0].minor.yy148); }
        break;
      case 133: /* cmd ::= ALTER TABLE alter_table_clause */
      case 314: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==314);
{ pCxt->pRootNode = yymsp[0].minor.yy148; }
        break;
      case 134: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy148); }
        break;
      case 135: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy148 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy148 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy148, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy199, yymsp[0].minor.yy530); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy148 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy148, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy199); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy148 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy148, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy199, yymsp[0].minor.yy530); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy148 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy148, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy199, &yymsp[0].minor.yy199); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 140: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy148 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy148, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy199, yymsp[0].minor.yy530); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 141: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy148 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy148, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy199); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 142: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy148 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy148, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy199, yymsp[0].minor.yy530); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 143: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy148 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy148, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy199, &yymsp[0].minor.yy199); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 144: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy148 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy148, &yymsp[-2].minor.yy199, yymsp[0].minor.yy148); }
  yymsp[-5].minor.yy148 = yylhsminor.yy148;
        break;
      case 146: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 149: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==149);
      case 412: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==412);
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-1].minor.yy404, yymsp[0].minor.yy148); }
  yymsp[-1].minor.yy404 = yylhsminor.yy404;
        break;
      case 147: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy148 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy397, yymsp[-8].minor.yy148, yymsp[-6].minor.yy148, yymsp[-5].minor.yy404, yymsp[-2].minor.yy404, yymsp[0].minor.yy148); }
  yymsp[-9].minor.yy148 = yylhsminor.yy148;
        break;
      case 150: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy148 = createDropTableClause(pCxt, yymsp[-1].minor.yy397, yymsp[0].minor.yy148); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 151: /* specific_cols_opt ::= */
      case 182: /* tags_def_opt ::= */ yytestcase(yyruleno==182);
      case 252: /* tag_list_opt ::= */ yytestcase(yyruleno==252);
      case 475: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==475);
      case 497: /* group_by_clause_opt ::= */ yytestcase(yyruleno==497);
      case 516: /* order_by_clause_opt ::= */ yytestcase(yyruleno==516);
{ yymsp[1].minor.yy404 = NULL; }
        break;
      case 152: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy404 = yymsp[-1].minor.yy404; }
        break;
      case 153: /* full_table_name ::= table_name */
{ yylhsminor.yy148 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy199, NULL); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 154: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy148 = createRealTableNode(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy199, NULL); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 157: /* column_def ::= column_name type_name */
{ yylhsminor.yy148 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy199, yymsp[0].minor.yy530, NULL); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 158: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy148 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy199, yymsp[-2].minor.yy530, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 159: /* type_name ::= BOOL */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 160: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 161: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 162: /* type_name ::= INT */
      case 163: /* type_name ::= INTEGER */ yytestcase(yyruleno==163);
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 164: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 165: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 166: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 167: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy530 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 169: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy530 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy530 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy530 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 172: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy530 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 173: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy530 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 174: /* type_name ::= JSON */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 175: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy530 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 176: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 177: /* type_name ::= BLOB */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 178: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy530 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 180: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy530 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy530 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* tags_def_opt ::= tags_def */
      case 404: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==404);
{ yylhsminor.yy404 = yymsp[0].minor.yy404; }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 184: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy404 = yymsp[-1].minor.yy404; }
        break;
      case 185: /* table_options ::= */
{ yymsp[1].minor.yy148 = createDefaultTableOptions(pCxt); }
        break;
      case 186: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-2].minor.yy148, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 187: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-2].minor.yy148, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy404); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 188: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-2].minor.yy148, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy404); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 189: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-4].minor.yy148, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy404); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 190: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-2].minor.yy148, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 191: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-4].minor.yy148, TABLE_OPTION_SMA, yymsp[-1].minor.yy404); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 192: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-2].minor.yy148, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy404); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 193: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy148 = createAlterTableOptions(pCxt); yylhsminor.yy148 = setTableOption(pCxt, yylhsminor.yy148, yymsp[0].minor.yy123.type, &yymsp[0].minor.yy123.val); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 194: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-1].minor.yy148, yymsp[0].minor.yy123.type, &yymsp[0].minor.yy123.val); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 195: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy123.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 196: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy123.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* duration_list ::= duration_literal */
      case 369: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==369);
{ yylhsminor.yy404 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy148)); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 198: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 370: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==370);
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, releaseRawExprNode(pCxt, yymsp[0].minor.yy148)); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 201: /* rollup_func_name ::= function_name */
{ yylhsminor.yy148 = createFunctionNode(pCxt, &yymsp[0].minor.yy199, NULL); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 202: /* rollup_func_name ::= FIRST */
      case 203: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==203);
      case 256: /* tag_item ::= QTAGS */ yytestcase(yyruleno==256);
{ yylhsminor.yy148 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 206: /* col_name ::= column_name */
      case 257: /* tag_item ::= column_name */ yytestcase(yyruleno==257);
{ yylhsminor.yy148 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy199); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 207: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 208: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 209: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 210: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 211: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy148, yymsp[0].minor.yy148, OP_TYPE_LIKE); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy148, yymsp[0].minor.yy148, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy148, NULL, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy148, yymsp[-1].minor.yy148, OP_TYPE_EQUAL); }
        break;
      case 218: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 219: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 220: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 221: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 222: /* cmd ::= SHOW LICENCES */
      case 223: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==223);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 224: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy199); }
        break;
      case 225: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy148); }
        break;
      case 226: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy148); }
        break;
      case 227: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 228: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 229: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 230: /* cmd ::= SHOW VARIABLES */
      case 231: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==231);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 232: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy148); }
        break;
      case 234: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 235: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 237: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 238: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy148); }
        break;
      case 239: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 240: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 241: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy148, yymsp[-1].minor.yy148, OP_TYPE_EQUAL); }
        break;
      case 242: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy148, yymsp[0].minor.yy148, yymsp[-3].minor.yy404); }
        break;
      case 243: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 245: /* db_name_cond_opt ::= */
      case 250: /* from_db_opt ::= */ yytestcase(yyruleno==250);
{ yymsp[1].minor.yy148 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 246: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy148 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy199); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 247: /* like_pattern_opt ::= */
      case 302: /* subtable_opt ::= */ yytestcase(yyruleno==302);
      case 414: /* case_when_else_opt ::= */ yytestcase(yyruleno==414);
      case 444: /* from_clause_opt ::= */ yytestcase(yyruleno==444);
      case 473: /* where_clause_opt ::= */ yytestcase(yyruleno==473);
      case 482: /* twindow_clause_opt ::= */ yytestcase(yyruleno==482);
      case 487: /* sliding_opt ::= */ yytestcase(yyruleno==487);
      case 489: /* fill_opt ::= */ yytestcase(yyruleno==489);
      case 501: /* having_clause_opt ::= */ yytestcase(yyruleno==501);
      case 503: /* range_opt ::= */ yytestcase(yyruleno==503);
      case 505: /* every_opt ::= */ yytestcase(yyruleno==505);
      case 518: /* slimit_clause_opt ::= */ yytestcase(yyruleno==518);
      case 522: /* limit_clause_opt ::= */ yytestcase(yyruleno==522);
{ yymsp[1].minor.yy148 = NULL; }
        break;
      case 248: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 249: /* table_name_cond ::= table_name */
{ yylhsminor.yy148 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy199); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 251: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy148 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy199); }
        break;
      case 255: /* tag_item ::= TBNAME */
{ yylhsminor.yy148 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 258: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy148 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy199), &yymsp[0].minor.yy199); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 259: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy148 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy199), &yymsp[0].minor.yy199); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 260: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy397, yymsp[-3].minor.yy148, yymsp[-1].minor.yy148, NULL, yymsp[0].minor.yy148); }
        break;
      case 261: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy397, yymsp[0].minor.yy148); }
        break;
      case 262: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy148 = createIndexOption(pCxt, yymsp[-7].minor.yy404, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), NULL, yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 263: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy148 = createIndexOption(pCxt, yymsp[-9].minor.yy404, releaseRawExprNode(pCxt, yymsp[-5].minor.yy148), releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 266: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy148 = createFunctionNode(pCxt, &yymsp[-3].minor.yy199, yymsp[-1].minor.yy404); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 267: /* sma_stream_opt ::= */
      case 295: /* stream_options ::= */ yytestcase(yyruleno==295);
{ yymsp[1].minor.yy148 = createStreamOptions(pCxt); }
        break;
      case 268: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 299: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==299);
{ ((SStreamOptions*)yymsp[-2].minor.yy148)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy148); yylhsminor.yy148 = yymsp[-2].minor.yy148; }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 269: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy148)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy148); yylhsminor.yy148 = yymsp[-2].minor.yy148; }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 270: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy148)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy148); yylhsminor.yy148 = yymsp[-2].minor.yy148; }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 271: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy397, &yymsp[-2].minor.yy199, yymsp[0].minor.yy148); }
        break;
      case 272: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy397, &yymsp[-3].minor.yy199, &yymsp[0].minor.yy199, false); }
        break;
      case 273: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy397, &yymsp[-5].minor.yy199, &yymsp[0].minor.yy199, true); }
        break;
      case 274: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy397, &yymsp[-3].minor.yy199, yymsp[0].minor.yy148, false); }
        break;
      case 275: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy397, &yymsp[-5].minor.yy199, yymsp[0].minor.yy148, true); }
        break;
      case 276: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy199); }
        break;
      case 277: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy397, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy199); }
        break;
      case 278: /* cmd ::= DESC full_table_name */
      case 279: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==279);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy148); }
        break;
      case 280: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 281: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy397, yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 284: /* explain_options ::= */
{ yymsp[1].minor.yy148 = createDefaultExplainOptions(pCxt); }
        break;
      case 285: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy148 = setExplainVerbose(pCxt, yymsp[-2].minor.yy148, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 286: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy148 = setExplainRatio(pCxt, yymsp[-2].minor.yy148, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 287: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy397, yymsp[-8].minor.yy397, &yymsp[-5].minor.yy199, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy530, yymsp[0].minor.yy706); }
        break;
      case 288: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy199); }
        break;
      case 293: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy397, &yymsp[-7].minor.yy199, yymsp[-4].minor.yy148, yymsp[-6].minor.yy148, yymsp[-3].minor.yy404, yymsp[-2].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 294: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy199); }
        break;
      case 296: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy148)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy148 = yymsp[-2].minor.yy148; }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 297: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy148)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy148 = yymsp[-2].minor.yy148; }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 298: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy148)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy148)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy148); yylhsminor.yy148 = yymsp[-3].minor.yy148; }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 300: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy148)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy148 = yymsp[-3].minor.yy148; }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 301: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy148)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy148 = yymsp[-2].minor.yy148; }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 303: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 488: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==488);
      case 506: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==506);
{ yymsp[-3].minor.yy148 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy148); }
        break;
      case 304: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 305: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 306: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 307: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 308: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 309: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy404); }
        break;
      case 310: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 311: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy404 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 313: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 315: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy148, yymsp[-2].minor.yy404, yymsp[0].minor.yy148); }
        break;
      case 316: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy148, NULL, yymsp[0].minor.yy148); }
        break;
      case 317: /* literal ::= NK_INTEGER */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 318: /* literal ::= NK_FLOAT */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 319: /* literal ::= NK_STRING */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 320: /* literal ::= NK_BOOL */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 321: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 322: /* literal ::= duration_literal */
      case 332: /* signed_literal ::= signed */ yytestcase(yyruleno==332);
      case 352: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==352);
      case 353: /* expression ::= literal */ yytestcase(yyruleno==353);
      case 354: /* expression ::= pseudo_column */ yytestcase(yyruleno==354);
      case 355: /* expression ::= column_reference */ yytestcase(yyruleno==355);
      case 356: /* expression ::= function_expression */ yytestcase(yyruleno==356);
      case 357: /* expression ::= case_when_expression */ yytestcase(yyruleno==357);
      case 387: /* function_expression ::= literal_func */ yytestcase(yyruleno==387);
      case 436: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==436);
      case 440: /* boolean_primary ::= predicate */ yytestcase(yyruleno==440);
      case 442: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==442);
      case 443: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==443);
      case 446: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==446);
      case 448: /* table_reference ::= table_primary */ yytestcase(yyruleno==448);
      case 449: /* table_reference ::= joined_table */ yytestcase(yyruleno==449);
      case 453: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==453);
      case 508: /* query_simple ::= query_specification */ yytestcase(yyruleno==508);
      case 509: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==509);
      case 512: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==512);
      case 514: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==514);
{ yylhsminor.yy148 = yymsp[0].minor.yy148; }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 323: /* literal ::= NULL */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 324: /* literal ::= NK_QUESTION */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 325: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 326: /* signed ::= NK_INTEGER */
{ yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 327: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 328: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 329: /* signed ::= NK_FLOAT */
{ yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 330: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 331: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 333: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 334: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 335: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 336: /* signed_literal ::= duration_literal */
      case 338: /* signed_literal ::= literal_func */ yytestcase(yyruleno==338);
      case 407: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==407);
      case 469: /* select_item ::= common_expression */ yytestcase(yyruleno==469);
      case 479: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==479);
      case 513: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==513);
      case 515: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==515);
      case 528: /* search_condition ::= common_expression */ yytestcase(yyruleno==528);
{ yylhsminor.yy148 = releaseRawExprNode(pCxt, yymsp[0].minor.yy148); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 337: /* signed_literal ::= NULL */
{ yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 339: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy148 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 358: /* expression ::= NK_LP expression NK_RP */
      case 441: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==441);
      case 527: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==527);
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy148)); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 359: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy148));
                                                                                  }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 360: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy148), NULL));
                                                                                  }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 361: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148))); 
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 362: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148))); 
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 363: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148))); 
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 364: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148))); 
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 365: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 366: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 367: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 368: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 371: /* column_reference ::= column_name */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy199, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy199)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 372: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy199, createColumnNode(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy199)); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 373: /* pseudo_column ::= ROWTS */
      case 374: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==374);
      case 376: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==376);
      case 377: /* pseudo_column ::= QEND */ yytestcase(yyruleno==377);
      case 378: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==378);
      case 379: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==379);
      case 380: /* pseudo_column ::= WEND */ yytestcase(yyruleno==380);
      case 381: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==381);
      case 382: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==382);
      case 383: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==383);
      case 389: /* literal_func ::= NOW */ yytestcase(yyruleno==389);
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 375: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy199)))); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 384: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 385: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==385);
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy199, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy199, yymsp[-1].minor.yy404)); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 386: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), yymsp[-1].minor.yy530)); }
  yymsp[-5].minor.yy148 = yylhsminor.yy148;
        break;
      case 388: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy199, NULL)); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 403: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy404 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 408: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 472: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==472);
{ yylhsminor.yy148 = createColumnNode(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 409: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy404, yymsp[-1].minor.yy148)); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 410: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), yymsp[-2].minor.yy404, yymsp[-1].minor.yy148)); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 413: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy148 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)); }
        break;
      case 415: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy148 = releaseRawExprNode(pCxt, yymsp[0].minor.yy148); }
        break;
      case 416: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 421: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==421);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy20, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 417: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy148), releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 418: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy148), releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-5].minor.yy148 = yylhsminor.yy148;
        break;
      case 419: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), NULL));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 420: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), NULL));
                                                                                  }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 422: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy20 = OP_TYPE_LOWER_THAN; }
        break;
      case 423: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy20 = OP_TYPE_GREATER_THAN; }
        break;
      case 424: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy20 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 425: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy20 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 426: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy20 = OP_TYPE_NOT_EQUAL; }
        break;
      case 427: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy20 = OP_TYPE_EQUAL; }
        break;
      case 428: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy20 = OP_TYPE_LIKE; }
        break;
      case 429: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy20 = OP_TYPE_NOT_LIKE; }
        break;
      case 430: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy20 = OP_TYPE_MATCH; }
        break;
      case 431: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy20 = OP_TYPE_NMATCH; }
        break;
      case 432: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy20 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 433: /* in_op ::= IN */
{ yymsp[0].minor.yy20 = OP_TYPE_IN; }
        break;
      case 434: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy20 = OP_TYPE_NOT_IN; }
        break;
      case 435: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy404)); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 437: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy148), NULL));
                                                                                  }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 438: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 439: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 445: /* from_clause_opt ::= FROM table_reference_list */
      case 474: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==474);
      case 502: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==502);
{ yymsp[-1].minor.yy148 = yymsp[0].minor.yy148; }
        break;
      case 447: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy148 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy148, yymsp[0].minor.yy148, NULL); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 450: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy148 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy199, &yymsp[0].minor.yy199); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 451: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy148 = createRealTableNode(pCxt, &yymsp[-3].minor.yy199, &yymsp[-1].minor.yy199, &yymsp[0].minor.yy199); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 452: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy148 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy148), &yymsp[0].minor.yy199); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 454: /* alias_opt ::= */
{ yymsp[1].minor.yy199 = nil_token;  }
        break;
      case 456: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy199 = yymsp[0].minor.yy199; }
        break;
      case 457: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 458: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==458);
{ yymsp[-2].minor.yy148 = yymsp[-1].minor.yy148; }
        break;
      case 459: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy148 = createJoinTableNode(pCxt, yymsp[-4].minor.yy470, yymsp[-5].minor.yy148, yymsp[-2].minor.yy148, yymsp[0].minor.yy148); }
  yymsp[-5].minor.yy148 = yylhsminor.yy148;
        break;
      case 460: /* join_type ::= */
{ yymsp[1].minor.yy470 = JOIN_TYPE_INNER; }
        break;
      case 461: /* join_type ::= INNER */
{ yymsp[0].minor.yy470 = JOIN_TYPE_INNER; }
        break;
      case 462: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy148 = createSelectStmt(pCxt, yymsp[-10].minor.yy397, yymsp[-9].minor.yy404, yymsp[-8].minor.yy148);
                                                                                    yymsp[-11].minor.yy148 = addWhereClause(pCxt, yymsp[-11].minor.yy148, yymsp[-7].minor.yy148);
                                                                                    yymsp[-11].minor.yy148 = addPartitionByClause(pCxt, yymsp[-11].minor.yy148, yymsp[-6].minor.yy404);
                                                                                    yymsp[-11].minor.yy148 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy148, yymsp[-2].minor.yy148);
                                                                                    yymsp[-11].minor.yy148 = addGroupByClause(pCxt, yymsp[-11].minor.yy148, yymsp[-1].minor.yy404);
                                                                                    yymsp[-11].minor.yy148 = addHavingClause(pCxt, yymsp[-11].minor.yy148, yymsp[0].minor.yy148);
                                                                                    yymsp[-11].minor.yy148 = addRangeClause(pCxt, yymsp[-11].minor.yy148, yymsp[-5].minor.yy148);
                                                                                    yymsp[-11].minor.yy148 = addEveryClause(pCxt, yymsp[-11].minor.yy148, yymsp[-4].minor.yy148);
                                                                                    yymsp[-11].minor.yy148 = addFillClause(pCxt, yymsp[-11].minor.yy148, yymsp[-3].minor.yy148);
                                                                                  }
        break;
      case 465: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy397 = false; }
        break;
      case 468: /* select_item ::= NK_STAR */
{ yylhsminor.yy148 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 470: /* select_item ::= common_expression column_alias */
      case 480: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==480);
{ yylhsminor.yy148 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy148), &yymsp[0].minor.yy199); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 471: /* select_item ::= common_expression AS column_alias */
      case 481: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==481);
{ yylhsminor.yy148 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), &yymsp[0].minor.yy199); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 476: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 498: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==498);
      case 517: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==517);
{ yymsp[-2].minor.yy404 = yymsp[0].minor.yy404; }
        break;
      case 483: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy148 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), releaseRawExprNode(pCxt, yymsp[-1].minor.yy148)); }
        break;
      case 484: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy148 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy148)); }
        break;
      case 485: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy148 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), NULL, yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 486: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy148 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy148), releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 490: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy148 = createFillNode(pCxt, yymsp[-1].minor.yy334, NULL); }
        break;
      case 491: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy148 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy404)); }
        break;
      case 492: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy334 = FILL_MODE_NONE; }
        break;
      case 493: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy334 = FILL_MODE_PREV; }
        break;
      case 494: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy334 = FILL_MODE_NULL; }
        break;
      case 495: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy334 = FILL_MODE_LINEAR; }
        break;
      case 496: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy334 = FILL_MODE_NEXT; }
        break;
      case 499: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy404 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy148))); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 500: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy148))); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 504: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy148 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), releaseRawExprNode(pCxt, yymsp[-1].minor.yy148)); }
        break;
      case 507: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy148 = addOrderByClause(pCxt, yymsp[-3].minor.yy148, yymsp[-2].minor.yy404);
                                                                                    yylhsminor.yy148 = addSlimitClause(pCxt, yylhsminor.yy148, yymsp[-1].minor.yy148);
                                                                                    yylhsminor.yy148 = addLimitClause(pCxt, yylhsminor.yy148, yymsp[0].minor.yy148);
                                                                                  }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 510: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy148 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy148, yymsp[0].minor.yy148); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 511: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy148 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy148, yymsp[0].minor.yy148); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 519: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 523: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==523);
{ yymsp[-1].minor.yy148 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 520: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 524: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==524);
{ yymsp[-3].minor.yy148 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 521: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 525: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==525);
{ yymsp[-3].minor.yy148 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 526: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy148); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 531: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy148 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), yymsp[-1].minor.yy898, yymsp[0].minor.yy499); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 532: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy898 = ORDER_ASC; }
        break;
      case 533: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy898 = ORDER_ASC; }
        break;
      case 534: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy898 = ORDER_DESC; }
        break;
      case 535: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy499 = NULL_ORDER_DEFAULT; }
        break;
      case 536: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy499 = NULL_ORDER_FIRST; }
        break;
      case 537: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy499 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
