/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 308
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  ENullOrder yy81;
  SNode* yy168;
  SDataType yy224;
  SAlterOption yy277;
  SNodeList* yy376;
  EFillMode yy382;
  SToken yy393;
  EOperatorType yy436;
  int32_t yy508;
  bool yy537;
  EOrder yy554;
  EJoinType yy596;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYNSTATE             518
#define YYNRULE              400
#define YYNTOKEN             202
#define YY_MAX_SHIFT         517
#define YY_MIN_SHIFTREDUCE   776
#define YY_MAX_SHIFTREDUCE   1175
#define YY_ERROR_ACTION      1176
#define YY_ACCEPT_ACTION     1177
#define YY_NO_ACTION         1178
#define YY_MIN_REDUCE        1179
#define YY_MAX_REDUCE        1578
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1488)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   255,  432,  272, 1447,  267,   52, 1218, 1380,  275,   25,
 /*    10 */   193,  304,   31,   29,  121, 1371, 1373, 1431,   96, 1431,
 /*    20 */   264,  444, 1012, 1431,  445, 1333, 1288, 1463,  367, 1427,
 /*    30 */  1433, 1427, 1433,   72,  429, 1427, 1434,  117, 1010, 1340,
 /*    40 */   352, 1251, 1557,  310,  431,  254, 1284,   11, 1418, 1293,
 /*    50 */  1338,  263, 1225,  413, 1017,  130,  813,  432,  812, 1555,
 /*    60 */    31,   29, 1118, 1381,  231, 1448, 1449, 1452,  264, 1270,
 /*    70 */  1012,    1,   12,  236,   31,   29,  814,  444,  100, 1340,
 /*    80 */   413,  444,  264,  445, 1012,  269, 1010,  343,   31,   29,
 /*    90 */  1338, 1418,   72, 1035,  514,   11,  264,  417, 1012,  358,
 /*   100 */  1010,  366, 1017,  360,  858,  100, 1011,  365, 1293,   11,
 /*   110 */    97,   98,  361,  359, 1010,  362, 1017, 1034, 1340,    1,
 /*   120 */   860,  186, 1503,  412,  276,  411,  445,  208, 1557, 1338,
 /*   130 */  1017,  476,   12,    1, 1222,  308, 1463,  116,   98, 1191,
 /*   140 */  1013,  130,  514,  429, 1032, 1555,  445,    7,  127, 1503,
 /*   150 */  1504, 1293, 1508,  478, 1011,  309,  514, 1016, 1036, 1037,
 /*   160 */  1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1011,  482,
 /*   170 */   514, 1293,  475,  474,  473,  406,  472,  163, 1117,  131,
 /*   180 */   131,  355, 1011,  502,  501,  500,  499,  279, 1013,  498,
 /*   190 */   497,  496,  102,  491,  490,  489,  488,  487,  486,  485,
 /*   200 */   484,  108, 1013,  357,    6, 1016, 1036, 1037, 1062, 1063,
 /*   210 */  1064, 1065, 1066, 1067, 1068, 1069, 1013,  510,  509, 1016,
 /*   220 */  1036, 1037, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069,
 /*   230 */  1038, 1036, 1037, 1016, 1036, 1037, 1062, 1063, 1064, 1065,
 /*   240 */  1066, 1067, 1068, 1069, 1142, 1271,   31,   29,  430,   32,
 /*   250 */    30,   28,   27,   26,  264,  131, 1012,  136,  407,   31,
 /*   260 */    29,  235,  303, 1032,  302,  445,   65,  264, 1180, 1012,
 /*   270 */   322,  403, 1010,  334,  315,  400, 1140, 1141, 1143, 1144,
 /*   280 */   101,  131,  335,   50, 1202, 1010,   49, 1285, 1017,   84,
 /*   290 */  1293,  343,   83,   82,   81,   80,   79,   78,   77,   76,
 /*   300 */    75, 1017,  131,  131,  329,    7,  480,  896,  468,  467,
 /*   310 */   466,  900,  465,  902,  903,  464,  905,  461,    7,  911,
 /*   320 */   458,  913,  914,  455,  452,  408,  404,   84,  514, 1418,
 /*   330 */    83,   82,   81,   80,   79,   78,   77,   76,   75, 1113,
 /*   340 */  1011,  514,  188,   32,   30,   28,   27,   26,  364,  363,
 /*   350 */   140,  139,  333, 1011, 1116,  328,  327,  326,  325,  324,
 /*   360 */   445,  321,  320,  319,  318,  314,  313,  312,  311,  316,
 /*   370 */  1172,    9,    8, 1033, 1013,   32,   30,   28,   27,   26,
 /*   380 */    32,   30,   28,   27,   26, 1293, 1201, 1013,  483, 1200,
 /*   390 */  1265, 1016, 1036, 1037, 1062, 1063, 1064, 1065, 1066, 1067,
 /*   400 */  1068, 1069,  421, 1132, 1016, 1036, 1037, 1062, 1063, 1064,
 /*   410 */  1065, 1066, 1067, 1068, 1069,  238, 1282,   31,   29,   32,
 /*   420 */    30,   28,   27,   26,  366,  264,  360, 1012, 1199, 1447,
 /*   430 */   365, 1418,  371,   97, 1418,  361,  359, 1171,  362,  471,
 /*   440 */  1050,  445, 1094, 1010, 1447, 1557,  445,  379, 1081,  268,
 /*   450 */   342, 1269,  380, 1463,  238, 1290, 1368,  114, 1556, 1017,
 /*   460 */   429,  165, 1555,  138,  374, 1295, 1293,   52, 1463,  368,
 /*   470 */   431, 1293,  164, 1418, 1418,  416,    1,  445, 1278,  417,
 /*   480 */    28,   27,   26, 1557, 1198,  431,  442, 1081, 1289, 1418,
 /*   490 */   227, 1448, 1449, 1452, 1082, 1280,  130,  480,   42,  514,
 /*   500 */  1555,   41, 1293, 1197, 1083,   69, 1448, 1449, 1452, 1496,
 /*   510 */  1557, 1011, 1086,  257, 1492,  125,  274,  495,  493, 1276,
 /*   520 */  1177, 1039, 1087,  130,  114,  215,  420, 1555, 1323, 1418,
 /*   530 */   115,  422, 1295, 1082, 1524,  221,   24,  262, 1076, 1077,
 /*   540 */  1078, 1079, 1080, 1084, 1085, 1013,   22,  219, 1418, 1196,
 /*   550 */  1195, 1086,   32,   30,   28,   27,   26,  141, 1515, 1113,
 /*   560 */   168, 1447, 1016, 1036, 1037, 1062, 1063, 1064, 1065, 1066,
 /*   570 */  1067, 1068, 1069,  280, 1447,   24,  262, 1076, 1077, 1078,
 /*   580 */  1079, 1080, 1084, 1085,  295, 1463,  388,  271,  270,   59,
 /*   590 */  1510,  445,  429,  114, 1418, 1418, 1510, 1025, 1463,  297,
 /*   600 */   443, 1296,  431,  413, 1557,  429, 1418, 1194, 1507,  445,
 /*   610 */  1286,  417, 1050, 1018, 1506,  431, 1293,  130,  207, 1418,
 /*   620 */    67, 1555,   68, 1448, 1449, 1452, 1496,  470,  100, 1017,
 /*   630 */   237, 1492,  277,  174, 1293,   70, 1448, 1449, 1452, 1496,
 /*   640 */   114,  812, 1557, 1495, 1492,   48,   47,  307, 1295,  135,
 /*   650 */  1193, 1252, 1418, 1192,  301,  130, 1407,  350, 1190, 1555,
 /*   660 */   248,   98,  244,  517,  293, 1447,  289,  285,  132,  446,
 /*   670 */   415,  126, 1503, 1504, 1189, 1508, 1188,  212, 1125, 1510,
 /*   680 */    95, 1021,  156,  163, 1034,  154,  506,  355,  211, 1463,
 /*   690 */   494,  131,  287, 1187,  298, 1418,  416, 1505,  445,  249,
 /*   700 */  1447,  247,  246, 1418,  354, 1186,  431,  278,  428,  357,
 /*   710 */  1418, 1185, 1184, 1183,   66, 1026,  106,  205,  419, 1418,
 /*   720 */   392, 1418, 1182, 1293, 1463, 1020,   69, 1448, 1449, 1452,
 /*   730 */  1496,  429, 1029, 1340,  257, 1492,  125, 1213, 1418,  401,
 /*   740 */  1340,  431, 1447,  158, 1372, 1418,  157,  441,  189,  160,
 /*   750 */  1418, 1339,  159, 1447,  396, 1523, 1418, 1418, 1418,  369,
 /*   760 */  1211,   69, 1448, 1449, 1452, 1496, 1463, 1418,  378,  257,
 /*   770 */  1492, 1569,  395,  429,  190,  170,  162, 1463, 1447,  161,
 /*   780 */  1530,  376,  372,  431,  429,   44,  424, 1418,  338, 1139,
 /*   790 */   996,  177,  167, 1023,  431,  179,    9,    8, 1418,  413,
 /*   800 */   389,  397, 1463,   69, 1448, 1449, 1452, 1496, 1334,  429,
 /*   810 */  1019,  257, 1492, 1569,  231, 1448, 1449, 1452, 1073,  431,
 /*   820 */    64, 1447, 1553, 1418,  100, 1174, 1175,   33,  387,   33,
 /*   830 */    61, 1088, 1447, 1047, 1438,  183,  349,  832, 1012,   69,
 /*   840 */  1448, 1449, 1452, 1496,  390, 1463, 1436,  257, 1492, 1569,
 /*   850 */  1526,   33,  429,  833, 1010,  979, 1463,   98, 1514, 1464,
 /*   860 */   196,   94,  431,  429,  198,  437, 1418,  128, 1503, 1504,
 /*   870 */  1017, 1508,  104,  431, 1447, 1557,  204, 1418, 1022,  414,
 /*   880 */   192,    2,   70, 1448, 1449, 1452, 1496, 1032,  130,  282,
 /*   890 */   427, 1492, 1555,  118, 1448, 1449, 1452,  286, 1463,  243,
 /*   900 */   106,  245, 1447,   44,  889,  429,  858,  884,  450,  104,
 /*   910 */   514,  988,  917,  921,  213,  431,  105,  425,  151, 1418,
 /*   920 */   927,  124, 1011,  317,  106, 1370, 1463,  348,  926,  150,
 /*   930 */  1447,  418, 1570,  429,  137,   70, 1448, 1449, 1452, 1496,
 /*   940 */   323,  104,  330,  431, 1493,  107,  331, 1418,  332,  336,
 /*   950 */  1043,  337, 1042,  339, 1463,   53, 1013,  143,  148, 1447,
 /*   960 */   340,  429, 1041,  230, 1448, 1449, 1452,   21,  341,  146,
 /*   970 */    51,  431, 1040, 1016,  351, 1418,  344,   32,   30,   28,
 /*   980 */    27,   26,  149, 1463, 1447,  383,  356,  353,  381,   74,
 /*   990 */   429,  118, 1448, 1449, 1452,  409,  253, 1283,  384,  153,
 /*  1000 */   431,  382,  391, 1279, 1418,  155,  109,  261, 1463,  110,
 /*  1010 */  1281, 1277,  147,  111,  120,  429,  144,  112, 1447,  169,
 /*  1020 */   231, 1448, 1449, 1452,   23,  431, 1179,  393,  172, 1418,
 /*  1030 */  1571, 1039,  265,  142,   32,   30,   28,   27,   26,  402,
 /*  1040 */  1527,  394, 1463, 1017,  435,  231, 1448, 1449, 1452,  429,
 /*  1050 */    93,   92,   91,   90,   89,   88,   87,   86,   85,  431,
 /*  1060 */  1537,  175, 1447, 1418,  399,    5,  178,  410, 1447,  256,
 /*  1070 */   398,  405, 1113,    4, 1038,   99,  123,   34, 1517,  224,
 /*  1080 */  1448, 1449, 1452, 1536,  185,  258, 1463,  184,  182, 1511,
 /*  1090 */    17,  426, 1463,  429,  423, 1478, 1447, 1572,  191,  429,
 /*  1100 */  1379,  433, 1554,  431, 1447,  434,  438, 1418,  439,  431,
 /*  1110 */  1378,  200,  266, 1418,  202,  214,  440,   58, 1294,   60,
 /*  1120 */  1463,  448, 1266,  229, 1448, 1449, 1452,  429, 1463,  232,
 /*  1130 */  1448, 1449, 1452,  477,  216,  429,  210,  431, 1447,  222,
 /*  1140 */    40, 1418,  513,  223,  220,  431, 1268, 1412,  218, 1418,
 /*  1150 */  1447, 1411,  281, 1408,  283,  284, 1006,  225, 1448, 1449,
 /*  1160 */  1452, 1007, 1463,  133, 1406,  233, 1448, 1449, 1452,  429,
 /*  1170 */   288,  290,  291,  292, 1463, 1405,  294, 1404,  296,  431,
 /*  1180 */  1395,  429,  134, 1418,  299,  300,  991,  990, 1389, 1388,
 /*  1190 */  1387,  431,  305,  306, 1386, 1418, 1447,  962, 1363,  226,
 /*  1200 */  1448, 1449, 1452, 1362,  208, 1361, 1360, 1359,  476, 1358,
 /*  1210 */  1357,  234, 1448, 1449, 1452, 1356, 1355, 1354, 1353, 1352,
 /*  1220 */  1463, 1447, 1351,  103, 1350, 1349, 1348,  429, 1347, 1346,
 /*  1230 */   478, 1345, 1447,  964, 1344, 1343, 1342,  431, 1341, 1224,
 /*  1240 */  1403, 1418, 1397, 1385, 1376, 1463, 1272,  145,  825,  475,
 /*  1250 */   474,  473,  429,  472, 1223, 1221, 1463, 1460, 1448, 1449,
 /*  1260 */  1452,  345,  431,  429,  347, 1210, 1418, 1209, 1447,  346,
 /*  1270 */  1206, 1274,   73,  431, 1447,  152,  494, 1418,  932,  934,
 /*  1280 */  1273,  492, 1459, 1448, 1449, 1452,  857,  856,  855,  854,
 /*  1290 */   851,  850, 1463, 1458, 1448, 1449, 1452, 1219, 1463,  429,
 /*  1300 */   250, 1214, 1447,  251, 1212,  429,  252,  370, 1205,  431,
 /*  1310 */  1447,  373,  375, 1418, 1204,  431,  377, 1402,   71, 1418,
 /*  1320 */   166,  998, 1396,   43,  113,  385, 1463,  386,  122,  241,
 /*  1330 */  1448, 1449, 1452,  429, 1463,  240, 1448, 1449, 1452, 1384,
 /*  1340 */  1383,  429, 1375,  431, 1447,   54,   37, 1418,  171,   14,
 /*  1350 */     3,  431, 1436,   33,  173, 1418,   38,   15,  176, 1138,
 /*  1360 */   119,  181,  180,  242, 1448, 1449, 1452,   19, 1463,   10,
 /*  1370 */    55,  239, 1448, 1449, 1452,  429,   56,   20, 1131, 1110,
 /*  1380 */    36,   16, 1109,  187, 1160,  431, 1159, 1165,  259, 1418,
 /*  1390 */  1164, 1163,  260,    8,  129, 1048,   13,   35,   18,  194,
 /*  1400 */   195, 1136, 1074,  197,  199,  228, 1448, 1449, 1452,  436,
 /*  1410 */  1374,  201,   45, 1435,   57,   61, 1027,  918,  206,  203,
 /*  1420 */    39,  449,  273,  915,  453,  456,  447,  451,  454,  895,
 /*  1430 */   912,  457,  910,  906,  459,  460,  462,  904,  463,  929,
 /*  1440 */    62,   46,   63,  909,  928,  923,  469,  925,  823,  479,
 /*  1450 */   481,  908,  846,  864,  845,  907,  209,  844,  843,  842,
 /*  1460 */   841,  839,  840,  859,  836,  861,  835,  834,  831,  830,
 /*  1470 */   829,  828, 1220,  503,  504, 1208, 1207,  505,  507,  508,
 /*  1480 */  1203,  511,  512, 1178, 1014,  217,  515,  516,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   233,  246,  233,  205,  249,  213,    0,  252,  238,  271,
 /*    10 */   272,  255,   12,   13,  228,  245,  246,  250,  226,  250,
 /*    20 */    20,   20,   22,  250,  211,  239,  234,  229,   22,  262,
 /*    30 */   263,  262,  263,  220,  236,  262,  263,  214,   38,  229,
 /*    40 */   227,  218,  286,  211,  246,  235,  205,   47,  250,  236,
 /*    50 */   240,  253,    0,  211,   54,  299,   20,  246,   22,  303,
 /*    60 */    12,   13,   14,  252,  266,  267,  268,  269,   20,    0,
 /*    70 */    22,   71,   71,  241,   12,   13,   40,   20,  236,  229,
 /*    80 */   211,   20,   20,  211,   22,  235,   38,   46,   12,   13,
 /*    90 */   240,  250,  220,   20,   94,   47,   20,  255,   22,  227,
 /*   100 */    38,   49,   54,   51,   38,  236,  106,   55,  236,   47,
 /*   110 */    58,  269,   60,   61,   38,   63,   54,   20,  229,   71,
 /*   120 */    54,  279,  280,  281,  235,  283,  211,   58,  286,  240,
 /*   130 */    54,   62,   71,   71,    0,  220,  229,  204,  269,  206,
 /*   140 */   140,  299,   94,  236,   20,  303,  211,   71,  279,  280,
 /*   150 */   281,  236,  283,   84,  106,  220,   94,  157,  158,  159,
 /*   160 */   160,  161,  162,  163,  164,  165,  166,  167,  106,   54,
 /*   170 */    94,  236,  103,  104,  105,  268,  107,   58,    4,  179,
 /*   180 */   179,   62,  106,   49,   50,   51,   52,   53,  140,   55,
 /*   190 */    56,   57,   58,   59,   60,   61,   62,   63,   64,   65,
 /*   200 */    66,   67,  140,   84,   43,  157,  158,  159,  160,  161,
 /*   210 */   162,  163,  164,  165,  166,  167,  140,  208,  209,  157,
 /*   220 */   158,  159,  160,  161,  162,  163,  164,  165,  166,  167,
 /*   230 */    20,  158,  159,  157,  158,  159,  160,  161,  162,  163,
 /*   240 */   164,  165,  166,  167,  157,    0,   12,   13,   14,   12,
 /*   250 */    13,   14,   15,   16,   20,  179,   22,   44,   20,   12,
 /*   260 */    13,   18,  139,   20,  141,  211,  210,   20,    0,   22,
 /*   270 */    27,  130,   38,   30,  220,  188,  189,  190,  191,  192,
 /*   280 */   224,  179,   39,   70,  205,   38,   73,  231,   54,   21,
 /*   290 */   236,   46,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   300 */    32,   54,  179,  179,   64,   71,   46,   85,   86,   87,
 /*   310 */    88,   89,   90,   91,   92,   93,   94,   95,   71,   97,
 /*   320 */    98,   99,  100,  101,  102,  184,  185,   21,   94,  250,
 /*   330 */    24,   25,   26,   27,   28,   29,   30,   31,   32,  178,
 /*   340 */   106,   94,  132,   12,   13,   14,   15,   16,  215,  216,
 /*   350 */   110,  111,  109,  106,  180,  112,  113,  114,  115,  116,
 /*   360 */   211,  118,  119,  120,  121,  122,  123,  124,  125,  220,
 /*   370 */   133,    1,    2,   20,  140,   12,   13,   14,   15,   16,
 /*   380 */    12,   13,   14,   15,   16,  236,  205,  140,  217,  205,
 /*   390 */   219,  157,  158,  159,  160,  161,  162,  163,  164,  165,
 /*   400 */   166,  167,   68,   72,  157,  158,  159,  160,  161,  162,
 /*   410 */   163,  164,  165,  166,  167,   47,  230,   12,   13,   12,
 /*   420 */    13,   14,   15,   16,   49,   20,   51,   22,  205,  205,
 /*   430 */    55,  250,    4,   58,  250,   60,   61,  200,   63,   82,
 /*   440 */    72,  211,   72,   38,  205,  286,  211,   19,   80,  221,
 /*   450 */   220,    0,  255,  229,   47,  220,  236,  229,  299,   54,
 /*   460 */   236,   33,  303,  243,   36,  237,  236,  213,  229,   41,
 /*   470 */   246,  236,   44,  250,  250,  236,   71,  211,  230,  255,
 /*   480 */    14,   15,   16,  286,  205,  246,  220,   80,  234,  250,
 /*   490 */   266,  267,  268,  269,  126,  230,  299,   46,   70,   94,
 /*   500 */   303,   73,  236,  205,  126,  266,  267,  268,  269,  270,
 /*   510 */   286,  106,  144,  274,  275,  276,  221,  215,  216,  230,
 /*   520 */   202,   20,  144,  299,  229,  222,    3,  303,  225,  250,
 /*   530 */    18,  197,  237,  126,  295,   23,  168,  169,  170,  171,
 /*   540 */   172,  173,  174,  175,  176,  140,  168,   35,  250,  205,
 /*   550 */   205,  144,   12,   13,   14,   15,   16,   45,  177,  178,
 /*   560 */   230,  205,  157,  158,  159,  160,  161,  162,  163,  164,
 /*   570 */   165,  166,  167,  255,  205,  168,  169,  170,  171,  172,
 /*   580 */   173,  174,  175,  176,  136,  229,  258,   12,   13,  210,
 /*   590 */   264,  211,  236,  229,  250,  250,  264,   22,  229,  151,
 /*   600 */   220,  237,  246,  211,  286,  236,  250,  205,  282,  211,
 /*   610 */   231,  255,   72,   38,  282,  246,  236,  299,  220,  250,
 /*   620 */   108,  303,  266,  267,  268,  269,  270,  230,  236,   54,
 /*   630 */   274,  275,  221,  132,  236,  266,  267,  268,  269,  270,
 /*   640 */   229,   22,  286,  274,  275,  133,  134,  135,  237,  137,
 /*   650 */   205,  218,  250,  206,  142,  299,    0,   38,  205,  303,
 /*   660 */    35,  269,  150,   19,  152,  205,  154,  155,  156,   94,
 /*   670 */   278,  279,  280,  281,  205,  283,  205,   33,   14,  264,
 /*   680 */    36,  106,   75,   58,   20,   78,   42,   62,   44,  229,
 /*   690 */    68,  179,   36,  205,   72,  250,  236,  282,  211,   74,
 /*   700 */   205,   76,   77,  250,   79,  205,  246,  220,   47,   84,
 /*   710 */   250,  205,  205,  205,   70,  140,   68,   73,  195,  250,
 /*   720 */    72,  250,  205,  236,  229,   38,  266,  267,  268,  269,
 /*   730 */   270,  236,  157,  229,  274,  275,  276,    0,  250,  297,
 /*   740 */   229,  246,  205,   75,  240,  250,   78,  103,  288,   75,
 /*   750 */   250,  240,   78,  205,  294,  295,  250,  250,  250,   22,
 /*   760 */     0,  266,  267,  268,  269,  270,  229,  250,   21,  274,
 /*   770 */   275,  276,  128,  236,  306,  131,   75,  229,  205,   78,
 /*   780 */   285,   34,   22,  246,  236,   68,   68,  250,  246,   72,
 /*   790 */   146,   68,  148,  106,  246,   72,    1,    2,  250,  211,
 /*   800 */   211,  253,  229,  266,  267,  268,  269,  270,  239,  236,
 /*   810 */    38,  274,  275,  276,  266,  267,  268,  269,  157,  246,
 /*   820 */    71,  205,  285,  250,  236,  158,  159,   68,  246,   68,
 /*   830 */    81,   72,  205,   72,   71,  291,  208,   38,   22,  266,
 /*   840 */   267,  268,  269,  270,  255,  229,   83,  274,  275,  276,
 /*   850 */   265,   68,  236,   54,   38,   72,  229,  269,  285,  229,
 /*   860 */    68,   68,  246,  236,   72,   72,  250,  279,  280,  281,
 /*   870 */    54,  283,   68,  246,  205,  286,   72,  250,  106,  284,
 /*   880 */   300,  287,  266,  267,  268,  269,  270,   20,  299,  211,
 /*   890 */   274,  275,  303,  266,  267,  268,  269,   36,  229,  261,
 /*   900 */    68,  215,  205,   68,   72,  236,   38,   72,   68,   68,
 /*   910 */    94,  138,   72,   72,  256,  246,   68,  199,   33,  250,
 /*   920 */    72,   36,  106,  211,   68,  211,  229,   42,   72,   44,
 /*   930 */   205,  304,  305,  236,  117,  266,  267,  268,  269,  270,
 /*   940 */   244,   68,  242,  246,  275,   72,  126,  250,  242,  211,
 /*   950 */    20,  260,   20,  254,  229,   70,  140,  213,   73,  205,
 /*   960 */   236,  236,   20,  266,  267,  268,  269,    2,  247,  213,
 /*   970 */   213,  246,   20,  157,  207,  250,  211,   12,   13,   14,
 /*   980 */    15,   16,  213,  229,  205,  147,  215,  229,  236,  211,
 /*   990 */   236,  266,  267,  268,  269,  298,  207,  229,  259,  229,
 /*  1000 */   246,  260,  254,  229,  250,  229,  229,  253,  229,  229,
 /*  1010 */   229,  229,  127,  229,  129,  236,  131,  229,  205,  210,
 /*  1020 */   266,  267,  268,  269,    2,  246,    0,  236,  210,  250,
 /*  1030 */   305,   20,  253,  148,   12,   13,   14,   15,   16,  187,
 /*  1040 */   265,  247,  229,   54,  186,  266,  267,  268,  269,  236,
 /*  1050 */    24,   25,   26,   27,   28,   29,   30,   31,   32,  246,
 /*  1060 */   296,  251,  205,  250,  250,  194,  251,  193,  205,  250,
 /*  1070 */   182,  250,  178,  181,   20,  236,  290,  117,  293,  266,
 /*  1080 */   267,  268,  269,  296,  277,  201,  229,  289,  292,  264,
 /*  1090 */    71,  198,  229,  236,  196,  273,  205,  307,  301,  236,
 /*  1100 */   251,  250,  302,  246,  205,  250,  129,  250,  248,  246,
 /*  1110 */   251,  236,  250,  250,  210,  225,  247,  210,  236,   71,
 /*  1120 */   229,  232,  219,  266,  267,  268,  269,  236,  229,  266,
 /*  1130 */   267,  268,  269,  215,  211,  236,  210,  246,  205,  223,
 /*  1140 */   257,  250,  207,  223,  203,  246,    0,    0,  212,  250,
 /*  1150 */   205,    0,   61,    0,   38,  153,   38,  266,  267,  268,
 /*  1160 */   269,   38,  229,   38,    0,  266,  267,  268,  269,  236,
 /*  1170 */   153,   38,   38,  153,  229,    0,   38,    0,   38,  246,
 /*  1180 */     0,  236,   71,  250,  144,  143,  106,  140,    0,    0,
 /*  1190 */     0,  246,   50,  136,    0,  250,  205,   83,    0,  266,
 /*  1200 */   267,  268,  269,    0,   58,    0,    0,    0,   62,    0,
 /*  1210 */     0,  266,  267,  268,  269,    0,    0,    0,    0,    0,
 /*  1220 */   229,  205,    0,  117,    0,    0,    0,  236,    0,    0,
 /*  1230 */    84,    0,  205,   22,    0,    0,    0,  246,    0,    0,
 /*  1240 */     0,  250,    0,    0,    0,  229,    0,   43,   48,  103,
 /*  1250 */   104,  105,  236,  107,    0,    0,  229,  266,  267,  268,
 /*  1260 */   269,   38,  246,  236,   43,    0,  250,    0,  205,   36,
 /*  1270 */     0,    0,   80,  246,  205,   78,   68,  250,   22,   38,
 /*  1280 */     0,   68,  266,  267,  268,  269,   38,   38,   38,   38,
 /*  1290 */    38,   38,  229,  266,  267,  268,  269,    0,  229,  236,
 /*  1300 */    22,    0,  205,   22,    0,  236,   22,   39,    0,  246,
 /*  1310 */   205,   38,   22,  250,    0,  246,   22,    0,   20,  250,
 /*  1320 */   149,   38,    0,  132,  145,   22,  229,  132,  129,  266,
 /*  1330 */   267,  268,  269,  236,  229,  266,  267,  268,  269,    0,
 /*  1340 */     0,  236,    0,  246,  205,   71,  132,  250,   43,  183,
 /*  1350 */    68,  246,   83,   68,  127,  250,   68,  183,   72,   72,
 /*  1360 */    71,   68,   71,  266,  267,  268,  269,   71,  229,  183,
 /*  1370 */    71,  266,  267,  268,  269,  236,    4,   68,   72,   72,
 /*  1380 */    68,   68,   72,   83,   38,  246,   38,   72,   38,  250,
 /*  1390 */    38,   38,   38,    2,   83,   72,   71,  177,   71,   83,
 /*  1400 */    72,   72,  157,   71,   71,  266,  267,  268,  269,  130,
 /*  1410 */     0,   43,   71,   83,   71,   81,   22,   72,   83,  127,
 /*  1420 */    71,   38,   38,   72,   38,   38,   82,   71,   71,   22,
 /*  1430 */    72,   71,   96,   72,   38,   71,   38,   72,   71,   38,
 /*  1440 */    71,   71,   71,   96,  106,   22,   84,   38,   48,   47,
 /*  1450 */    69,   96,   38,   54,   38,   96,   68,   38,   38,   38,
 /*  1460 */    38,   22,   38,   38,   38,   54,   38,   38,   38,   38,
 /*  1470 */    38,   38,    0,   38,   36,    0,    0,   43,   38,   37,
 /*  1480 */     0,   22,   21,  308,   22,   22,   21,   20,  308,  308,
 /*  1490 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
 /*  1500 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
 /*  1510 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
 /*  1520 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
 /*  1530 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
 /*  1540 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
 /*  1550 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
 /*  1560 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
 /*  1570 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
 /*  1580 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
 /*  1590 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
 /*  1600 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
 /*  1610 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
 /*  1620 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
 /*  1630 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
 /*  1640 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
 /*  1650 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
 /*  1660 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
 /*  1670 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
 /*  1680 */   308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
};
#define YY_SHIFT_COUNT    (517)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1480)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   512,    0,   48,   62,   62,   62,   62,   76,   62,   62,
 /*    10 */   247,  405,    1,  234,  247,  247,  247,  247,  247,  247,
 /*    20 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*    30 */   247,  247,  247,  247,   61,   61,   61,  124,  575,  575,
 /*    40 */   123,   57,   57,  102,  575,   73,   73,   57,   57,   57,
 /*    50 */    57,   57,   57,   41,   97,  238,  102,   97,   57,   57,
 /*    60 */    97,   57,   97,   97,   97,   57,  260,  243,  368,  407,
 /*    70 */   407,  306,  625,  816,  375,  816,  816,  816,  816,  816,
 /*    80 */   816,  816,  816,  816,  816,  816,  816,  816,  816,  816,
 /*    90 */   816,  816,  816,  816,   73,   36,  245,   66,  210,  210,
 /*   100 */   210,  451,   66,  353,   97,   97,   97,  357,  115,  222,
 /*   110 */   222,  222,  222,  222,  222,  644,  268,   52,  237,   87,
 /*   120 */    73,  119,   73,  141,  619,  501,  381,  161,  381,  664,
 /*   130 */   523,  174,  867,  861,  868,  773,  867,  867,  817,  820,
 /*   140 */   820,  867,  930,  932,   41,  353,  942,   41,   41,  867,
 /*   150 */    41,  952,   97,   97,   97,   97,   97,   97,   97,   97,
 /*   160 */    97,   97,   97,  868,  867,  952,  353,  930,  838,  932,
 /*   170 */   260,  353,  942,  260, 1011,  852,  858,  989,  852,  858,
 /*   180 */   989,  989,  871,  874,  888,  892,  894,  353, 1054,  960,
 /*   190 */   884,  893,  898, 1019,   97,  858,  989,  989,  858,  989,
 /*   200 */   977,  353,  942,  260,  357,  260,  353, 1048,  868,  115,
 /*   210 */   867,  260,  952, 1488, 1488, 1488, 1488, 1488,  134,  885,
 /*   220 */  1026,  428,   69, 1146,  331,  965, 1022,  540,  363,  363,
 /*   230 */   363,  363,  363,  363,  363,  213,  240,  370,  378,  466,
 /*   240 */   466,  466,  466,  656,  448,  622,  607,  668,  674,  701,
 /*   250 */     6,  737,  760,  747,  648,  717,  723,  795,  667,  334,
 /*   260 */   718,  759,  661,  761,  763,  783,  792,  793,  804,  832,
 /*   270 */   687,  772,  835,  840,  841,  848,  856,  873,  749,  799,
 /*   280 */  1147, 1151, 1091, 1153, 1116, 1002, 1118, 1123, 1125, 1017,
 /*   290 */  1164, 1133, 1134, 1020, 1175, 1138, 1177, 1140, 1180, 1111,
 /*   300 */  1040, 1042, 1080, 1047, 1188, 1189, 1142, 1057, 1190, 1194,
 /*   310 */  1114, 1198, 1203, 1205, 1206, 1207, 1209, 1210, 1215, 1216,
 /*   320 */  1217, 1218, 1219, 1222, 1106, 1224, 1225, 1226, 1228, 1229,
 /*   330 */  1231, 1211, 1234, 1235, 1236, 1238, 1239, 1240, 1242, 1243,
 /*   340 */  1244, 1204, 1246, 1200, 1254, 1255, 1223, 1233, 1221, 1265,
 /*   350 */  1267, 1270, 1271, 1192, 1197, 1241, 1208, 1256, 1280, 1248,
 /*   360 */  1249, 1250, 1251, 1213, 1208, 1252, 1253, 1297, 1278, 1301,
 /*   370 */  1281, 1268, 1304, 1284, 1273, 1308, 1290, 1314, 1294, 1298,
 /*   380 */  1317, 1191, 1171, 1283, 1322, 1179, 1303, 1195, 1199, 1339,
 /*   390 */  1340, 1214, 1342, 1274, 1305, 1227, 1282, 1285, 1166, 1286,
 /*   400 */  1288, 1287, 1289, 1291, 1296, 1306, 1293, 1269, 1299, 1309,
 /*   410 */  1174, 1307, 1310, 1300, 1220, 1312, 1311, 1315, 1313, 1186,
 /*   420 */  1372, 1346, 1348, 1350, 1352, 1353, 1354, 1391, 1245, 1316,
 /*   430 */  1323, 1325, 1327, 1328, 1329, 1332, 1333, 1279, 1341, 1410,
 /*   440 */  1368, 1292, 1343, 1334, 1330, 1335, 1394, 1349, 1344, 1345,
 /*   450 */  1383, 1384, 1356, 1351, 1386, 1357, 1358, 1387, 1360, 1361,
 /*   460 */  1396, 1364, 1365, 1398, 1367, 1336, 1347, 1355, 1359, 1407,
 /*   470 */  1362, 1369, 1401, 1338, 1370, 1371, 1409, 1208, 1423, 1400,
 /*   480 */  1402, 1399, 1381, 1388, 1414, 1416, 1419, 1420, 1421, 1422,
 /*   490 */  1424, 1439, 1411, 1213, 1425, 1208, 1426, 1428, 1429, 1430,
 /*   500 */  1431, 1432, 1433, 1472, 1435, 1438, 1434, 1475, 1440, 1442,
 /*   510 */  1476, 1480, 1459, 1461, 1462, 1463, 1465, 1467,
};
#define YY_REDUCE_COUNT (217)
#define YY_REDUCE_MIN   (-262)
#define YY_REDUCE_MAX   (1139)
static const short yy_reduce_ofst[] = {
 /*     0 */   318,  356,  460,  239,  495,  537,  573,  224,  369,  616,
 /*    10 */   627,  669, -158, -202,  548,  697,  725,  754,  779,  813,
 /*    20 */   857,  863,  891,  899,  933,  945,  991, 1016, 1027, 1063,
 /*    30 */  1069, 1097, 1105, 1139,  392, -131,  588,  589, -233, -231,
 /*    40 */  -244, -187, -128,  197, -227, -245, -230,  -85,  -65,   54,
 /*    50 */   149,  230,  235, -208, -190,  -93,  159,  228,  266,  380,
 /*    60 */  -150,  398,  295, -111,  411,  487,   56, -168, -262, -262,
 /*    70 */  -262,  -67, -214, -159, -177,   79,  181,  184,  223,  279,
 /*    80 */   298,  344,  345,  402,  445,  453,  469,  471,  488,  500,
 /*    90 */   506,  507,  508,  517, -189,    9,  254,  133,  326,  332,
 /*   100 */   415,  379,  302,  220,  364,  504,  511,  303,  171,  186,
 /*   110 */   248,  265,  289,  330,  397,  328,  447,  433,  468,  442,
 /*   120 */   542,  569,  582,  544,  628,  585,  595,  595,  595,  630,
 /*   130 */   580,  594,  678,  638,  686,  658,  712,  714,  696,  700,
 /*   140 */   706,  738,  691,  699,  744,  724,  721,  756,  757,  765,
 /*   150 */   769,  767,  758,  768,  770,  774,  776,  777,  780,  781,
 /*   160 */   782,  784,  788,  771,  778,  789,  752,  741,  739,  748,
 /*   170 */   809,  791,  794,  818,  775,  764,  810,  814,  787,  815,
 /*   180 */   819,  821,  785,  796,  786,  798,  595,  839,  825,  807,
 /*   190 */   790,  800,  797,  822,  630,  849,  851,  855,  859,  862,
 /*   200 */   860,  875,  869,  904,  890,  907,  882,  889,  918,  903,
 /*   210 */   923,  926,  935,  883,  916,  920,  936,  941,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*    10 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*    20 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*    30 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*    40 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*    50 */  1176, 1176, 1176, 1229, 1176, 1176, 1176, 1176, 1176, 1176,
 /*    60 */  1176, 1176, 1176, 1176, 1176, 1176, 1227, 1364, 1176, 1498,
 /*    70 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*    80 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*    90 */  1176, 1176, 1176, 1176, 1176, 1176, 1229, 1176, 1509, 1509,
 /*   100 */  1509, 1227, 1176, 1176, 1176, 1176, 1176, 1322, 1176, 1176,
 /*   110 */  1176, 1176, 1176, 1176, 1176, 1398, 1176, 1176, 1573, 1176,
 /*   120 */  1176, 1275, 1176, 1533, 1176, 1525, 1501, 1515, 1502, 1176,
 /*   130 */  1558, 1518, 1176, 1176, 1176, 1390, 1176, 1176, 1369, 1366,
 /*   140 */  1366, 1176, 1176, 1176, 1229, 1176, 1176, 1229, 1229, 1176,
 /*   150 */  1229, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*   160 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1400, 1176,
 /*   170 */  1227, 1176, 1176, 1227, 1176, 1540, 1538, 1176, 1540, 1538,
 /*   180 */  1176, 1176, 1552, 1548, 1531, 1529, 1515, 1176, 1176, 1176,
 /*   190 */  1576, 1564, 1560, 1176, 1176, 1538, 1176, 1176, 1538, 1176,
 /*   200 */  1377, 1176, 1176, 1227, 1176, 1227, 1176, 1291, 1176, 1176,
 /*   210 */  1176, 1227, 1176, 1392, 1325, 1325, 1230, 1181, 1176, 1176,
 /*   220 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1462, 1551,
 /*   230 */  1550, 1461, 1475, 1474, 1473, 1176, 1176, 1176, 1176, 1456,
 /*   240 */  1457, 1455, 1454, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*   250 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1499, 1176, 1561,
 /*   260 */  1565, 1176, 1176, 1176, 1437, 1176, 1176, 1176, 1176, 1176,
 /*   270 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*   280 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*   290 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*   300 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*   310 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*   320 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*   330 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*   340 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*   350 */  1176, 1176, 1176, 1176, 1176, 1176, 1336, 1176, 1176, 1176,
 /*   360 */  1176, 1176, 1176, 1256, 1255, 1176, 1176, 1176, 1176, 1176,
 /*   370 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*   380 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*   390 */  1176, 1176, 1176, 1176, 1176, 1176, 1522, 1532, 1176, 1176,
 /*   400 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1437, 1176, 1549,
 /*   410 */  1176, 1508, 1504, 1176, 1176, 1500, 1176, 1176, 1559, 1176,
 /*   420 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1494, 1176, 1176,
 /*   430 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*   440 */  1176, 1176, 1176, 1176, 1436, 1176, 1176, 1176, 1176, 1176,
 /*   450 */  1176, 1176, 1319, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*   460 */  1176, 1176, 1176, 1176, 1176, 1304, 1302, 1301, 1300, 1176,
 /*   470 */  1297, 1176, 1176, 1176, 1176, 1176, 1176, 1327, 1176, 1176,
 /*   480 */  1176, 1176, 1176, 1250, 1176, 1176, 1176, 1176, 1176, 1176,
 /*   490 */  1176, 1176, 1176, 1241, 1176, 1240, 1176, 1176, 1176, 1176,
 /*   500 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
 /*   510 */  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "DATABASE",
  /*   45 */ "USE",
  /*   46 */ "IF",
  /*   47 */ "NOT",
  /*   48 */ "EXISTS",
  /*   49 */ "BLOCKS",
  /*   50 */ "CACHE",
  /*   51 */ "CACHELAST",
  /*   52 */ "COMP",
  /*   53 */ "DAYS",
  /*   54 */ "NK_VARIABLE",
  /*   55 */ "FSYNC",
  /*   56 */ "MAXROWS",
  /*   57 */ "MINROWS",
  /*   58 */ "KEEP",
  /*   59 */ "PRECISION",
  /*   60 */ "QUORUM",
  /*   61 */ "REPLICA",
  /*   62 */ "TTL",
  /*   63 */ "WAL",
  /*   64 */ "VGROUPS",
  /*   65 */ "SINGLE_STABLE",
  /*   66 */ "STREAM_MODE",
  /*   67 */ "RETENTIONS",
  /*   68 */ "NK_COMMA",
  /*   69 */ "NK_COLON",
  /*   70 */ "TABLE",
  /*   71 */ "NK_LP",
  /*   72 */ "NK_RP",
  /*   73 */ "STABLE",
  /*   74 */ "ADD",
  /*   75 */ "COLUMN",
  /*   76 */ "MODIFY",
  /*   77 */ "RENAME",
  /*   78 */ "TAG",
  /*   79 */ "SET",
  /*   80 */ "NK_EQ",
  /*   81 */ "USING",
  /*   82 */ "TAGS",
  /*   83 */ "NK_DOT",
  /*   84 */ "COMMENT",
  /*   85 */ "BOOL",
  /*   86 */ "TINYINT",
  /*   87 */ "SMALLINT",
  /*   88 */ "INT",
  /*   89 */ "INTEGER",
  /*   90 */ "BIGINT",
  /*   91 */ "FLOAT",
  /*   92 */ "DOUBLE",
  /*   93 */ "BINARY",
  /*   94 */ "TIMESTAMP",
  /*   95 */ "NCHAR",
  /*   96 */ "UNSIGNED",
  /*   97 */ "JSON",
  /*   98 */ "VARCHAR",
  /*   99 */ "MEDIUMBLOB",
  /*  100 */ "BLOB",
  /*  101 */ "VARBINARY",
  /*  102 */ "DECIMAL",
  /*  103 */ "SMA",
  /*  104 */ "ROLLUP",
  /*  105 */ "FILE_FACTOR",
  /*  106 */ "NK_FLOAT",
  /*  107 */ "DELAY",
  /*  108 */ "SHOW",
  /*  109 */ "DATABASES",
  /*  110 */ "TABLES",
  /*  111 */ "STABLES",
  /*  112 */ "MNODES",
  /*  113 */ "MODULES",
  /*  114 */ "QNODES",
  /*  115 */ "FUNCTIONS",
  /*  116 */ "INDEXES",
  /*  117 */ "FROM",
  /*  118 */ "ACCOUNTS",
  /*  119 */ "APPS",
  /*  120 */ "CONNECTIONS",
  /*  121 */ "LICENCE",
  /*  122 */ "QUERIES",
  /*  123 */ "SCORES",
  /*  124 */ "TOPICS",
  /*  125 */ "VARIABLES",
  /*  126 */ "LIKE",
  /*  127 */ "INDEX",
  /*  128 */ "FULLTEXT",
  /*  129 */ "FUNCTION",
  /*  130 */ "INTERVAL",
  /*  131 */ "TOPIC",
  /*  132 */ "AS",
  /*  133 */ "DESC",
  /*  134 */ "DESCRIBE",
  /*  135 */ "RESET",
  /*  136 */ "QUERY",
  /*  137 */ "EXPLAIN",
  /*  138 */ "ANALYZE",
  /*  139 */ "VERBOSE",
  /*  140 */ "NK_BOOL",
  /*  141 */ "RATIO",
  /*  142 */ "COMPACT",
  /*  143 */ "VNODES",
  /*  144 */ "IN",
  /*  145 */ "OUTPUTTYPE",
  /*  146 */ "AGGREGATE",
  /*  147 */ "BUFSIZE",
  /*  148 */ "STREAM",
  /*  149 */ "INTO",
  /*  150 */ "KILL",
  /*  151 */ "CONNECTION",
  /*  152 */ "MERGE",
  /*  153 */ "VGROUP",
  /*  154 */ "REDISTRIBUTE",
  /*  155 */ "SPLIT",
  /*  156 */ "SYNCDB",
  /*  157 */ "NULL",
  /*  158 */ "FIRST",
  /*  159 */ "LAST",
  /*  160 */ "NOW",
  /*  161 */ "ROWTS",
  /*  162 */ "TBNAME",
  /*  163 */ "QSTARTTS",
  /*  164 */ "QENDTS",
  /*  165 */ "WSTARTTS",
  /*  166 */ "WENDTS",
  /*  167 */ "WDURATION",
  /*  168 */ "BETWEEN",
  /*  169 */ "IS",
  /*  170 */ "NK_LT",
  /*  171 */ "NK_GT",
  /*  172 */ "NK_LE",
  /*  173 */ "NK_GE",
  /*  174 */ "NK_NE",
  /*  175 */ "MATCH",
  /*  176 */ "NMATCH",
  /*  177 */ "JOIN",
  /*  178 */ "INNER",
  /*  179 */ "SELECT",
  /*  180 */ "DISTINCT",
  /*  181 */ "WHERE",
  /*  182 */ "PARTITION",
  /*  183 */ "BY",
  /*  184 */ "SESSION",
  /*  185 */ "STATE_WINDOW",
  /*  186 */ "SLIDING",
  /*  187 */ "FILL",
  /*  188 */ "VALUE",
  /*  189 */ "NONE",
  /*  190 */ "PREV",
  /*  191 */ "LINEAR",
  /*  192 */ "NEXT",
  /*  193 */ "GROUP",
  /*  194 */ "HAVING",
  /*  195 */ "ORDER",
  /*  196 */ "SLIMIT",
  /*  197 */ "SOFFSET",
  /*  198 */ "LIMIT",
  /*  199 */ "OFFSET",
  /*  200 */ "ASC",
  /*  201 */ "NULLS",
  /*  202 */ "cmd",
  /*  203 */ "account_options",
  /*  204 */ "alter_account_options",
  /*  205 */ "literal",
  /*  206 */ "alter_account_option",
  /*  207 */ "user_name",
  /*  208 */ "dnode_endpoint",
  /*  209 */ "dnode_host_name",
  /*  210 */ "not_exists_opt",
  /*  211 */ "db_name",
  /*  212 */ "db_options",
  /*  213 */ "exists_opt",
  /*  214 */ "alter_db_options",
  /*  215 */ "integer_list",
  /*  216 */ "variable_list",
  /*  217 */ "retention_list",
  /*  218 */ "alter_db_option",
  /*  219 */ "retention",
  /*  220 */ "full_table_name",
  /*  221 */ "column_def_list",
  /*  222 */ "tags_def_opt",
  /*  223 */ "table_options",
  /*  224 */ "multi_create_clause",
  /*  225 */ "tags_def",
  /*  226 */ "multi_drop_clause",
  /*  227 */ "alter_table_clause",
  /*  228 */ "alter_table_options",
  /*  229 */ "column_name",
  /*  230 */ "type_name",
  /*  231 */ "create_subtable_clause",
  /*  232 */ "specific_tags_opt",
  /*  233 */ "literal_list",
  /*  234 */ "drop_table_clause",
  /*  235 */ "col_name_list",
  /*  236 */ "table_name",
  /*  237 */ "column_def",
  /*  238 */ "func_name_list",
  /*  239 */ "alter_table_option",
  /*  240 */ "col_name",
  /*  241 */ "db_name_cond_opt",
  /*  242 */ "like_pattern_opt",
  /*  243 */ "table_name_cond",
  /*  244 */ "from_db_opt",
  /*  245 */ "func_name",
  /*  246 */ "function_name",
  /*  247 */ "index_name",
  /*  248 */ "index_options",
  /*  249 */ "func_list",
  /*  250 */ "duration_literal",
  /*  251 */ "sliding_opt",
  /*  252 */ "func",
  /*  253 */ "expression_list",
  /*  254 */ "topic_name",
  /*  255 */ "query_expression",
  /*  256 */ "analyze_opt",
  /*  257 */ "explain_options",
  /*  258 */ "agg_func_opt",
  /*  259 */ "bufsize_opt",
  /*  260 */ "stream_name",
  /*  261 */ "dnode_list",
  /*  262 */ "signed",
  /*  263 */ "signed_literal",
  /*  264 */ "table_alias",
  /*  265 */ "column_alias",
  /*  266 */ "expression",
  /*  267 */ "pseudo_column",
  /*  268 */ "column_reference",
  /*  269 */ "subquery",
  /*  270 */ "predicate",
  /*  271 */ "compare_op",
  /*  272 */ "in_op",
  /*  273 */ "in_predicate_value",
  /*  274 */ "boolean_value_expression",
  /*  275 */ "boolean_primary",
  /*  276 */ "common_expression",
  /*  277 */ "from_clause",
  /*  278 */ "table_reference_list",
  /*  279 */ "table_reference",
  /*  280 */ "table_primary",
  /*  281 */ "joined_table",
  /*  282 */ "alias_opt",
  /*  283 */ "parenthesized_joined_table",
  /*  284 */ "join_type",
  /*  285 */ "search_condition",
  /*  286 */ "query_specification",
  /*  287 */ "set_quantifier_opt",
  /*  288 */ "select_list",
  /*  289 */ "where_clause_opt",
  /*  290 */ "partition_by_clause_opt",
  /*  291 */ "twindow_clause_opt",
  /*  292 */ "group_by_clause_opt",
  /*  293 */ "having_clause_opt",
  /*  294 */ "select_sublist",
  /*  295 */ "select_item",
  /*  296 */ "fill_opt",
  /*  297 */ "fill_mode",
  /*  298 */ "group_by_list",
  /*  299 */ "query_expression_body",
  /*  300 */ "order_by_clause_opt",
  /*  301 */ "slimit_clause_opt",
  /*  302 */ "limit_clause_opt",
  /*  303 */ "query_primary",
  /*  304 */ "sort_specification_list",
  /*  305 */ "sort_specification",
  /*  306 */ "ordering_specification_opt",
  /*  307 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  44 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  45 */ "cmd ::= USE db_name",
 /*  46 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  47 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  48 */ "not_exists_opt ::=",
 /*  49 */ "exists_opt ::= IF EXISTS",
 /*  50 */ "exists_opt ::=",
 /*  51 */ "db_options ::=",
 /*  52 */ "db_options ::= db_options BLOCKS NK_INTEGER",
 /*  53 */ "db_options ::= db_options CACHE NK_INTEGER",
 /*  54 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  55 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  56 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  57 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  58 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  59 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  60 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  61 */ "db_options ::= db_options KEEP integer_list",
 /*  62 */ "db_options ::= db_options KEEP variable_list",
 /*  63 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  64 */ "db_options ::= db_options QUORUM NK_INTEGER",
 /*  65 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  66 */ "db_options ::= db_options TTL NK_INTEGER",
 /*  67 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  68 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  69 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  70 */ "db_options ::= db_options STREAM_MODE NK_INTEGER",
 /*  71 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  72 */ "alter_db_options ::= alter_db_option",
 /*  73 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  74 */ "alter_db_option ::= BLOCKS NK_INTEGER",
 /*  75 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  76 */ "alter_db_option ::= KEEP integer_list",
 /*  77 */ "alter_db_option ::= KEEP variable_list",
 /*  78 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  79 */ "alter_db_option ::= QUORUM NK_INTEGER",
 /*  80 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  81 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  82 */ "integer_list ::= NK_INTEGER",
 /*  83 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /*  84 */ "variable_list ::= NK_VARIABLE",
 /*  85 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /*  86 */ "retention_list ::= retention",
 /*  87 */ "retention_list ::= retention_list NK_COMMA retention",
 /*  88 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /*  89 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  90 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  91 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /*  92 */ "cmd ::= DROP TABLE multi_drop_clause",
 /*  93 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /*  94 */ "cmd ::= ALTER TABLE alter_table_clause",
 /*  95 */ "cmd ::= ALTER STABLE alter_table_clause",
 /*  96 */ "alter_table_clause ::= full_table_name alter_table_options",
 /*  97 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /*  98 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /*  99 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 100 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 101 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 102 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 103 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 104 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 105 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /* 106 */ "multi_create_clause ::= create_subtable_clause",
 /* 107 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 108 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP",
 /* 109 */ "multi_drop_clause ::= drop_table_clause",
 /* 110 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 111 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 112 */ "specific_tags_opt ::=",
 /* 113 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 114 */ "full_table_name ::= table_name",
 /* 115 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 116 */ "column_def_list ::= column_def",
 /* 117 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 118 */ "column_def ::= column_name type_name",
 /* 119 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 120 */ "type_name ::= BOOL",
 /* 121 */ "type_name ::= TINYINT",
 /* 122 */ "type_name ::= SMALLINT",
 /* 123 */ "type_name ::= INT",
 /* 124 */ "type_name ::= INTEGER",
 /* 125 */ "type_name ::= BIGINT",
 /* 126 */ "type_name ::= FLOAT",
 /* 127 */ "type_name ::= DOUBLE",
 /* 128 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 129 */ "type_name ::= TIMESTAMP",
 /* 130 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 131 */ "type_name ::= TINYINT UNSIGNED",
 /* 132 */ "type_name ::= SMALLINT UNSIGNED",
 /* 133 */ "type_name ::= INT UNSIGNED",
 /* 134 */ "type_name ::= BIGINT UNSIGNED",
 /* 135 */ "type_name ::= JSON",
 /* 136 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 137 */ "type_name ::= MEDIUMBLOB",
 /* 138 */ "type_name ::= BLOB",
 /* 139 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 140 */ "type_name ::= DECIMAL",
 /* 141 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 142 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 143 */ "tags_def_opt ::=",
 /* 144 */ "tags_def_opt ::= tags_def",
 /* 145 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 146 */ "table_options ::=",
 /* 147 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 148 */ "table_options ::= table_options KEEP integer_list",
 /* 149 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 150 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 151 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 152 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 153 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 154 */ "alter_table_options ::= alter_table_option",
 /* 155 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 156 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 157 */ "alter_table_option ::= KEEP integer_list",
 /* 158 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 159 */ "col_name_list ::= col_name",
 /* 160 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 161 */ "col_name ::= column_name",
 /* 162 */ "cmd ::= SHOW DNODES",
 /* 163 */ "cmd ::= SHOW USERS",
 /* 164 */ "cmd ::= SHOW DATABASES",
 /* 165 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 166 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 167 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 168 */ "cmd ::= SHOW MNODES",
 /* 169 */ "cmd ::= SHOW MODULES",
 /* 170 */ "cmd ::= SHOW QNODES",
 /* 171 */ "cmd ::= SHOW FUNCTIONS",
 /* 172 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 173 */ "cmd ::= SHOW STREAMS",
 /* 174 */ "cmd ::= SHOW ACCOUNTS",
 /* 175 */ "cmd ::= SHOW APPS",
 /* 176 */ "cmd ::= SHOW CONNECTIONS",
 /* 177 */ "cmd ::= SHOW LICENCE",
 /* 178 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 179 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 180 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 181 */ "cmd ::= SHOW QUERIES",
 /* 182 */ "cmd ::= SHOW SCORES",
 /* 183 */ "cmd ::= SHOW TOPICS",
 /* 184 */ "cmd ::= SHOW VARIABLES",
 /* 185 */ "db_name_cond_opt ::=",
 /* 186 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 187 */ "like_pattern_opt ::=",
 /* 188 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 189 */ "table_name_cond ::= table_name",
 /* 190 */ "from_db_opt ::=",
 /* 191 */ "from_db_opt ::= FROM db_name",
 /* 192 */ "func_name_list ::= func_name",
 /* 193 */ "func_name_list ::= func_name_list NK_COMMA col_name",
 /* 194 */ "func_name ::= function_name",
 /* 195 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 196 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 197 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 198 */ "index_options ::=",
 /* 199 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 200 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 201 */ "func_list ::= func",
 /* 202 */ "func_list ::= func_list NK_COMMA func",
 /* 203 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 204 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 205 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name",
 /* 206 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 207 */ "cmd ::= DESC full_table_name",
 /* 208 */ "cmd ::= DESCRIBE full_table_name",
 /* 209 */ "cmd ::= RESET QUERY CACHE",
 /* 210 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 211 */ "analyze_opt ::=",
 /* 212 */ "analyze_opt ::= ANALYZE",
 /* 213 */ "explain_options ::=",
 /* 214 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 215 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 216 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 217 */ "cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 218 */ "cmd ::= DROP FUNCTION function_name",
 /* 219 */ "agg_func_opt ::=",
 /* 220 */ "agg_func_opt ::= AGGREGATE",
 /* 221 */ "bufsize_opt ::=",
 /* 222 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 223 */ "cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression",
 /* 224 */ "cmd ::= DROP STREAM stream_name",
 /* 225 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 226 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 227 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 228 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 229 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 230 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 231 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 232 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 233 */ "cmd ::= query_expression",
 /* 234 */ "literal ::= NK_INTEGER",
 /* 235 */ "literal ::= NK_FLOAT",
 /* 236 */ "literal ::= NK_STRING",
 /* 237 */ "literal ::= NK_BOOL",
 /* 238 */ "literal ::= TIMESTAMP NK_STRING",
 /* 239 */ "literal ::= duration_literal",
 /* 240 */ "literal ::= NULL",
 /* 241 */ "duration_literal ::= NK_VARIABLE",
 /* 242 */ "signed ::= NK_INTEGER",
 /* 243 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 244 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 245 */ "signed ::= NK_FLOAT",
 /* 246 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 247 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 248 */ "signed_literal ::= signed",
 /* 249 */ "signed_literal ::= NK_STRING",
 /* 250 */ "signed_literal ::= NK_BOOL",
 /* 251 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 252 */ "signed_literal ::= duration_literal",
 /* 253 */ "signed_literal ::= NULL",
 /* 254 */ "literal_list ::= signed_literal",
 /* 255 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 256 */ "db_name ::= NK_ID",
 /* 257 */ "table_name ::= NK_ID",
 /* 258 */ "column_name ::= NK_ID",
 /* 259 */ "function_name ::= NK_ID",
 /* 260 */ "function_name ::= FIRST",
 /* 261 */ "function_name ::= LAST",
 /* 262 */ "table_alias ::= NK_ID",
 /* 263 */ "column_alias ::= NK_ID",
 /* 264 */ "user_name ::= NK_ID",
 /* 265 */ "index_name ::= NK_ID",
 /* 266 */ "topic_name ::= NK_ID",
 /* 267 */ "stream_name ::= NK_ID",
 /* 268 */ "expression ::= literal",
 /* 269 */ "expression ::= pseudo_column",
 /* 270 */ "expression ::= column_reference",
 /* 271 */ "expression ::= function_name NK_LP expression_list NK_RP",
 /* 272 */ "expression ::= function_name NK_LP NK_STAR NK_RP",
 /* 273 */ "expression ::= subquery",
 /* 274 */ "expression ::= NK_LP expression NK_RP",
 /* 275 */ "expression ::= NK_PLUS expression",
 /* 276 */ "expression ::= NK_MINUS expression",
 /* 277 */ "expression ::= expression NK_PLUS expression",
 /* 278 */ "expression ::= expression NK_MINUS expression",
 /* 279 */ "expression ::= expression NK_STAR expression",
 /* 280 */ "expression ::= expression NK_SLASH expression",
 /* 281 */ "expression ::= expression NK_REM expression",
 /* 282 */ "expression_list ::= expression",
 /* 283 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 284 */ "column_reference ::= column_name",
 /* 285 */ "column_reference ::= table_name NK_DOT column_name",
 /* 286 */ "pseudo_column ::= NOW",
 /* 287 */ "pseudo_column ::= ROWTS",
 /* 288 */ "pseudo_column ::= TBNAME",
 /* 289 */ "pseudo_column ::= QSTARTTS",
 /* 290 */ "pseudo_column ::= QENDTS",
 /* 291 */ "pseudo_column ::= WSTARTTS",
 /* 292 */ "pseudo_column ::= WENDTS",
 /* 293 */ "pseudo_column ::= WDURATION",
 /* 294 */ "predicate ::= expression compare_op expression",
 /* 295 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 296 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 297 */ "predicate ::= expression IS NULL",
 /* 298 */ "predicate ::= expression IS NOT NULL",
 /* 299 */ "predicate ::= expression in_op in_predicate_value",
 /* 300 */ "compare_op ::= NK_LT",
 /* 301 */ "compare_op ::= NK_GT",
 /* 302 */ "compare_op ::= NK_LE",
 /* 303 */ "compare_op ::= NK_GE",
 /* 304 */ "compare_op ::= NK_NE",
 /* 305 */ "compare_op ::= NK_EQ",
 /* 306 */ "compare_op ::= LIKE",
 /* 307 */ "compare_op ::= NOT LIKE",
 /* 308 */ "compare_op ::= MATCH",
 /* 309 */ "compare_op ::= NMATCH",
 /* 310 */ "in_op ::= IN",
 /* 311 */ "in_op ::= NOT IN",
 /* 312 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 313 */ "boolean_value_expression ::= boolean_primary",
 /* 314 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 315 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 316 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 317 */ "boolean_primary ::= predicate",
 /* 318 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 319 */ "common_expression ::= expression",
 /* 320 */ "common_expression ::= boolean_value_expression",
 /* 321 */ "from_clause ::= FROM table_reference_list",
 /* 322 */ "table_reference_list ::= table_reference",
 /* 323 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 324 */ "table_reference ::= table_primary",
 /* 325 */ "table_reference ::= joined_table",
 /* 326 */ "table_primary ::= table_name alias_opt",
 /* 327 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 328 */ "table_primary ::= subquery alias_opt",
 /* 329 */ "table_primary ::= parenthesized_joined_table",
 /* 330 */ "alias_opt ::=",
 /* 331 */ "alias_opt ::= table_alias",
 /* 332 */ "alias_opt ::= AS table_alias",
 /* 333 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 334 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 335 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 336 */ "join_type ::=",
 /* 337 */ "join_type ::= INNER",
 /* 338 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 339 */ "set_quantifier_opt ::=",
 /* 340 */ "set_quantifier_opt ::= DISTINCT",
 /* 341 */ "set_quantifier_opt ::= ALL",
 /* 342 */ "select_list ::= NK_STAR",
 /* 343 */ "select_list ::= select_sublist",
 /* 344 */ "select_sublist ::= select_item",
 /* 345 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 346 */ "select_item ::= common_expression",
 /* 347 */ "select_item ::= common_expression column_alias",
 /* 348 */ "select_item ::= common_expression AS column_alias",
 /* 349 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 350 */ "where_clause_opt ::=",
 /* 351 */ "where_clause_opt ::= WHERE search_condition",
 /* 352 */ "partition_by_clause_opt ::=",
 /* 353 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 354 */ "twindow_clause_opt ::=",
 /* 355 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 356 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 357 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 358 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 359 */ "sliding_opt ::=",
 /* 360 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 361 */ "fill_opt ::=",
 /* 362 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 363 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 364 */ "fill_mode ::= NONE",
 /* 365 */ "fill_mode ::= PREV",
 /* 366 */ "fill_mode ::= NULL",
 /* 367 */ "fill_mode ::= LINEAR",
 /* 368 */ "fill_mode ::= NEXT",
 /* 369 */ "group_by_clause_opt ::=",
 /* 370 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 371 */ "group_by_list ::= expression",
 /* 372 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 373 */ "having_clause_opt ::=",
 /* 374 */ "having_clause_opt ::= HAVING search_condition",
 /* 375 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 376 */ "query_expression_body ::= query_primary",
 /* 377 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 378 */ "query_primary ::= query_specification",
 /* 379 */ "order_by_clause_opt ::=",
 /* 380 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 381 */ "slimit_clause_opt ::=",
 /* 382 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 383 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 384 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 385 */ "limit_clause_opt ::=",
 /* 386 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 387 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 388 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 389 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 390 */ "search_condition ::= common_expression",
 /* 391 */ "sort_specification_list ::= sort_specification",
 /* 392 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 393 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 394 */ "ordering_specification_opt ::=",
 /* 395 */ "ordering_specification_opt ::= ASC",
 /* 396 */ "ordering_specification_opt ::= DESC",
 /* 397 */ "null_ordering_opt ::=",
 /* 398 */ "null_ordering_opt ::= NULLS FIRST",
 /* 399 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 202: /* cmd */
    case 205: /* literal */
    case 212: /* db_options */
    case 214: /* alter_db_options */
    case 219: /* retention */
    case 220: /* full_table_name */
    case 223: /* table_options */
    case 227: /* alter_table_clause */
    case 228: /* alter_table_options */
    case 231: /* create_subtable_clause */
    case 234: /* drop_table_clause */
    case 237: /* column_def */
    case 240: /* col_name */
    case 241: /* db_name_cond_opt */
    case 242: /* like_pattern_opt */
    case 243: /* table_name_cond */
    case 244: /* from_db_opt */
    case 245: /* func_name */
    case 248: /* index_options */
    case 250: /* duration_literal */
    case 251: /* sliding_opt */
    case 252: /* func */
    case 255: /* query_expression */
    case 257: /* explain_options */
    case 262: /* signed */
    case 263: /* signed_literal */
    case 266: /* expression */
    case 267: /* pseudo_column */
    case 268: /* column_reference */
    case 269: /* subquery */
    case 270: /* predicate */
    case 273: /* in_predicate_value */
    case 274: /* boolean_value_expression */
    case 275: /* boolean_primary */
    case 276: /* common_expression */
    case 277: /* from_clause */
    case 278: /* table_reference_list */
    case 279: /* table_reference */
    case 280: /* table_primary */
    case 281: /* joined_table */
    case 283: /* parenthesized_joined_table */
    case 285: /* search_condition */
    case 286: /* query_specification */
    case 289: /* where_clause_opt */
    case 291: /* twindow_clause_opt */
    case 293: /* having_clause_opt */
    case 295: /* select_item */
    case 296: /* fill_opt */
    case 299: /* query_expression_body */
    case 301: /* slimit_clause_opt */
    case 302: /* limit_clause_opt */
    case 303: /* query_primary */
    case 305: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy168)); 
}
      break;
    case 203: /* account_options */
    case 204: /* alter_account_options */
    case 206: /* alter_account_option */
    case 259: /* bufsize_opt */
{
 
}
      break;
    case 207: /* user_name */
    case 208: /* dnode_endpoint */
    case 209: /* dnode_host_name */
    case 211: /* db_name */
    case 229: /* column_name */
    case 236: /* table_name */
    case 246: /* function_name */
    case 247: /* index_name */
    case 254: /* topic_name */
    case 260: /* stream_name */
    case 264: /* table_alias */
    case 265: /* column_alias */
    case 282: /* alias_opt */
{
 
}
      break;
    case 210: /* not_exists_opt */
    case 213: /* exists_opt */
    case 256: /* analyze_opt */
    case 258: /* agg_func_opt */
    case 287: /* set_quantifier_opt */
{
 
}
      break;
    case 215: /* integer_list */
    case 216: /* variable_list */
    case 217: /* retention_list */
    case 221: /* column_def_list */
    case 222: /* tags_def_opt */
    case 224: /* multi_create_clause */
    case 225: /* tags_def */
    case 226: /* multi_drop_clause */
    case 232: /* specific_tags_opt */
    case 233: /* literal_list */
    case 235: /* col_name_list */
    case 238: /* func_name_list */
    case 249: /* func_list */
    case 253: /* expression_list */
    case 261: /* dnode_list */
    case 288: /* select_list */
    case 290: /* partition_by_clause_opt */
    case 292: /* group_by_clause_opt */
    case 294: /* select_sublist */
    case 298: /* group_by_list */
    case 300: /* order_by_clause_opt */
    case 304: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy376)); 
}
      break;
    case 218: /* alter_db_option */
    case 239: /* alter_table_option */
{
 
}
      break;
    case 230: /* type_name */
{
 
}
      break;
    case 271: /* compare_op */
    case 272: /* in_op */
{
 
}
      break;
    case 284: /* join_type */
{
 
}
      break;
    case 297: /* fill_mode */
{
 
}
      break;
    case 306: /* ordering_specification_opt */
{
 
}
      break;
    case 307: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  202,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  202,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  203,    0 }, /* (2) account_options ::= */
  {  203,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  203,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  203,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  203,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  203,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  203,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  203,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  203,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  203,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  204,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  204,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  206,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  206,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  206,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  206,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  206,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  206,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  206,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  206,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  206,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  206,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  202,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  202,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  202,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  202,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  202,   -3 }, /* (28) cmd ::= CREATE DNODE dnode_endpoint */
  {  202,   -5 }, /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  202,   -3 }, /* (30) cmd ::= DROP DNODE NK_INTEGER */
  {  202,   -3 }, /* (31) cmd ::= DROP DNODE dnode_endpoint */
  {  202,   -4 }, /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  202,   -5 }, /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  202,   -4 }, /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
  {  202,   -5 }, /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  208,   -1 }, /* (36) dnode_endpoint ::= NK_STRING */
  {  209,   -1 }, /* (37) dnode_host_name ::= NK_ID */
  {  209,   -1 }, /* (38) dnode_host_name ::= NK_IPTOKEN */
  {  202,   -3 }, /* (39) cmd ::= ALTER LOCAL NK_STRING */
  {  202,   -4 }, /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  202,   -5 }, /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  202,   -5 }, /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  202,   -5 }, /* (43) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  202,   -4 }, /* (44) cmd ::= DROP DATABASE exists_opt db_name */
  {  202,   -2 }, /* (45) cmd ::= USE db_name */
  {  202,   -4 }, /* (46) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  210,   -3 }, /* (47) not_exists_opt ::= IF NOT EXISTS */
  {  210,    0 }, /* (48) not_exists_opt ::= */
  {  213,   -2 }, /* (49) exists_opt ::= IF EXISTS */
  {  213,    0 }, /* (50) exists_opt ::= */
  {  212,    0 }, /* (51) db_options ::= */
  {  212,   -3 }, /* (52) db_options ::= db_options BLOCKS NK_INTEGER */
  {  212,   -3 }, /* (53) db_options ::= db_options CACHE NK_INTEGER */
  {  212,   -3 }, /* (54) db_options ::= db_options CACHELAST NK_INTEGER */
  {  212,   -3 }, /* (55) db_options ::= db_options COMP NK_INTEGER */
  {  212,   -3 }, /* (56) db_options ::= db_options DAYS NK_INTEGER */
  {  212,   -3 }, /* (57) db_options ::= db_options DAYS NK_VARIABLE */
  {  212,   -3 }, /* (58) db_options ::= db_options FSYNC NK_INTEGER */
  {  212,   -3 }, /* (59) db_options ::= db_options MAXROWS NK_INTEGER */
  {  212,   -3 }, /* (60) db_options ::= db_options MINROWS NK_INTEGER */
  {  212,   -3 }, /* (61) db_options ::= db_options KEEP integer_list */
  {  212,   -3 }, /* (62) db_options ::= db_options KEEP variable_list */
  {  212,   -3 }, /* (63) db_options ::= db_options PRECISION NK_STRING */
  {  212,   -3 }, /* (64) db_options ::= db_options QUORUM NK_INTEGER */
  {  212,   -3 }, /* (65) db_options ::= db_options REPLICA NK_INTEGER */
  {  212,   -3 }, /* (66) db_options ::= db_options TTL NK_INTEGER */
  {  212,   -3 }, /* (67) db_options ::= db_options WAL NK_INTEGER */
  {  212,   -3 }, /* (68) db_options ::= db_options VGROUPS NK_INTEGER */
  {  212,   -3 }, /* (69) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  212,   -3 }, /* (70) db_options ::= db_options STREAM_MODE NK_INTEGER */
  {  212,   -3 }, /* (71) db_options ::= db_options RETENTIONS retention_list */
  {  214,   -1 }, /* (72) alter_db_options ::= alter_db_option */
  {  214,   -2 }, /* (73) alter_db_options ::= alter_db_options alter_db_option */
  {  218,   -2 }, /* (74) alter_db_option ::= BLOCKS NK_INTEGER */
  {  218,   -2 }, /* (75) alter_db_option ::= FSYNC NK_INTEGER */
  {  218,   -2 }, /* (76) alter_db_option ::= KEEP integer_list */
  {  218,   -2 }, /* (77) alter_db_option ::= KEEP variable_list */
  {  218,   -2 }, /* (78) alter_db_option ::= WAL NK_INTEGER */
  {  218,   -2 }, /* (79) alter_db_option ::= QUORUM NK_INTEGER */
  {  218,   -2 }, /* (80) alter_db_option ::= CACHELAST NK_INTEGER */
  {  218,   -2 }, /* (81) alter_db_option ::= REPLICA NK_INTEGER */
  {  215,   -1 }, /* (82) integer_list ::= NK_INTEGER */
  {  215,   -3 }, /* (83) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  216,   -1 }, /* (84) variable_list ::= NK_VARIABLE */
  {  216,   -3 }, /* (85) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  217,   -1 }, /* (86) retention_list ::= retention */
  {  217,   -3 }, /* (87) retention_list ::= retention_list NK_COMMA retention */
  {  219,   -3 }, /* (88) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  202,   -9 }, /* (89) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  202,   -3 }, /* (90) cmd ::= CREATE TABLE multi_create_clause */
  {  202,   -9 }, /* (91) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  202,   -3 }, /* (92) cmd ::= DROP TABLE multi_drop_clause */
  {  202,   -4 }, /* (93) cmd ::= DROP STABLE exists_opt full_table_name */
  {  202,   -3 }, /* (94) cmd ::= ALTER TABLE alter_table_clause */
  {  202,   -3 }, /* (95) cmd ::= ALTER STABLE alter_table_clause */
  {  227,   -2 }, /* (96) alter_table_clause ::= full_table_name alter_table_options */
  {  227,   -5 }, /* (97) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  227,   -4 }, /* (98) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  227,   -5 }, /* (99) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  227,   -5 }, /* (100) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  227,   -5 }, /* (101) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  227,   -4 }, /* (102) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  227,   -5 }, /* (103) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  227,   -5 }, /* (104) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  227,   -6 }, /* (105) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
  {  224,   -1 }, /* (106) multi_create_clause ::= create_subtable_clause */
  {  224,   -2 }, /* (107) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  231,   -9 }, /* (108) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
  {  226,   -1 }, /* (109) multi_drop_clause ::= drop_table_clause */
  {  226,   -2 }, /* (110) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  234,   -2 }, /* (111) drop_table_clause ::= exists_opt full_table_name */
  {  232,    0 }, /* (112) specific_tags_opt ::= */
  {  232,   -3 }, /* (113) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  220,   -1 }, /* (114) full_table_name ::= table_name */
  {  220,   -3 }, /* (115) full_table_name ::= db_name NK_DOT table_name */
  {  221,   -1 }, /* (116) column_def_list ::= column_def */
  {  221,   -3 }, /* (117) column_def_list ::= column_def_list NK_COMMA column_def */
  {  237,   -2 }, /* (118) column_def ::= column_name type_name */
  {  237,   -4 }, /* (119) column_def ::= column_name type_name COMMENT NK_STRING */
  {  230,   -1 }, /* (120) type_name ::= BOOL */
  {  230,   -1 }, /* (121) type_name ::= TINYINT */
  {  230,   -1 }, /* (122) type_name ::= SMALLINT */
  {  230,   -1 }, /* (123) type_name ::= INT */
  {  230,   -1 }, /* (124) type_name ::= INTEGER */
  {  230,   -1 }, /* (125) type_name ::= BIGINT */
  {  230,   -1 }, /* (126) type_name ::= FLOAT */
  {  230,   -1 }, /* (127) type_name ::= DOUBLE */
  {  230,   -4 }, /* (128) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  230,   -1 }, /* (129) type_name ::= TIMESTAMP */
  {  230,   -4 }, /* (130) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  230,   -2 }, /* (131) type_name ::= TINYINT UNSIGNED */
  {  230,   -2 }, /* (132) type_name ::= SMALLINT UNSIGNED */
  {  230,   -2 }, /* (133) type_name ::= INT UNSIGNED */
  {  230,   -2 }, /* (134) type_name ::= BIGINT UNSIGNED */
  {  230,   -1 }, /* (135) type_name ::= JSON */
  {  230,   -4 }, /* (136) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  230,   -1 }, /* (137) type_name ::= MEDIUMBLOB */
  {  230,   -1 }, /* (138) type_name ::= BLOB */
  {  230,   -4 }, /* (139) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  230,   -1 }, /* (140) type_name ::= DECIMAL */
  {  230,   -4 }, /* (141) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  230,   -6 }, /* (142) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  222,    0 }, /* (143) tags_def_opt ::= */
  {  222,   -1 }, /* (144) tags_def_opt ::= tags_def */
  {  225,   -4 }, /* (145) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  223,    0 }, /* (146) table_options ::= */
  {  223,   -3 }, /* (147) table_options ::= table_options COMMENT NK_STRING */
  {  223,   -3 }, /* (148) table_options ::= table_options KEEP integer_list */
  {  223,   -3 }, /* (149) table_options ::= table_options TTL NK_INTEGER */
  {  223,   -5 }, /* (150) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  223,   -5 }, /* (151) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  223,   -3 }, /* (152) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  223,   -3 }, /* (153) table_options ::= table_options DELAY NK_INTEGER */
  {  228,   -1 }, /* (154) alter_table_options ::= alter_table_option */
  {  228,   -2 }, /* (155) alter_table_options ::= alter_table_options alter_table_option */
  {  239,   -2 }, /* (156) alter_table_option ::= COMMENT NK_STRING */
  {  239,   -2 }, /* (157) alter_table_option ::= KEEP integer_list */
  {  239,   -2 }, /* (158) alter_table_option ::= TTL NK_INTEGER */
  {  235,   -1 }, /* (159) col_name_list ::= col_name */
  {  235,   -3 }, /* (160) col_name_list ::= col_name_list NK_COMMA col_name */
  {  240,   -1 }, /* (161) col_name ::= column_name */
  {  202,   -2 }, /* (162) cmd ::= SHOW DNODES */
  {  202,   -2 }, /* (163) cmd ::= SHOW USERS */
  {  202,   -2 }, /* (164) cmd ::= SHOW DATABASES */
  {  202,   -4 }, /* (165) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  202,   -4 }, /* (166) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  202,   -3 }, /* (167) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  202,   -2 }, /* (168) cmd ::= SHOW MNODES */
  {  202,   -2 }, /* (169) cmd ::= SHOW MODULES */
  {  202,   -2 }, /* (170) cmd ::= SHOW QNODES */
  {  202,   -2 }, /* (171) cmd ::= SHOW FUNCTIONS */
  {  202,   -5 }, /* (172) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  202,   -2 }, /* (173) cmd ::= SHOW STREAMS */
  {  202,   -2 }, /* (174) cmd ::= SHOW ACCOUNTS */
  {  202,   -2 }, /* (175) cmd ::= SHOW APPS */
  {  202,   -2 }, /* (176) cmd ::= SHOW CONNECTIONS */
  {  202,   -2 }, /* (177) cmd ::= SHOW LICENCE */
  {  202,   -4 }, /* (178) cmd ::= SHOW CREATE DATABASE db_name */
  {  202,   -4 }, /* (179) cmd ::= SHOW CREATE TABLE full_table_name */
  {  202,   -4 }, /* (180) cmd ::= SHOW CREATE STABLE full_table_name */
  {  202,   -2 }, /* (181) cmd ::= SHOW QUERIES */
  {  202,   -2 }, /* (182) cmd ::= SHOW SCORES */
  {  202,   -2 }, /* (183) cmd ::= SHOW TOPICS */
  {  202,   -2 }, /* (184) cmd ::= SHOW VARIABLES */
  {  241,    0 }, /* (185) db_name_cond_opt ::= */
  {  241,   -2 }, /* (186) db_name_cond_opt ::= db_name NK_DOT */
  {  242,    0 }, /* (187) like_pattern_opt ::= */
  {  242,   -2 }, /* (188) like_pattern_opt ::= LIKE NK_STRING */
  {  243,   -1 }, /* (189) table_name_cond ::= table_name */
  {  244,    0 }, /* (190) from_db_opt ::= */
  {  244,   -2 }, /* (191) from_db_opt ::= FROM db_name */
  {  238,   -1 }, /* (192) func_name_list ::= func_name */
  {  238,   -3 }, /* (193) func_name_list ::= func_name_list NK_COMMA col_name */
  {  245,   -1 }, /* (194) func_name ::= function_name */
  {  202,   -8 }, /* (195) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  202,  -10 }, /* (196) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  202,   -6 }, /* (197) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  248,    0 }, /* (198) index_options ::= */
  {  248,   -9 }, /* (199) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  248,  -11 }, /* (200) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  249,   -1 }, /* (201) func_list ::= func */
  {  249,   -3 }, /* (202) func_list ::= func_list NK_COMMA func */
  {  252,   -4 }, /* (203) func ::= function_name NK_LP expression_list NK_RP */
  {  202,   -6 }, /* (204) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  202,   -6 }, /* (205) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
  {  202,   -4 }, /* (206) cmd ::= DROP TOPIC exists_opt topic_name */
  {  202,   -2 }, /* (207) cmd ::= DESC full_table_name */
  {  202,   -2 }, /* (208) cmd ::= DESCRIBE full_table_name */
  {  202,   -3 }, /* (209) cmd ::= RESET QUERY CACHE */
  {  202,   -4 }, /* (210) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  256,    0 }, /* (211) analyze_opt ::= */
  {  256,   -1 }, /* (212) analyze_opt ::= ANALYZE */
  {  257,    0 }, /* (213) explain_options ::= */
  {  257,   -3 }, /* (214) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  257,   -3 }, /* (215) explain_options ::= explain_options RATIO NK_FLOAT */
  {  202,   -6 }, /* (216) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  202,   -9 }, /* (217) cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  202,   -3 }, /* (218) cmd ::= DROP FUNCTION function_name */
  {  258,    0 }, /* (219) agg_func_opt ::= */
  {  258,   -1 }, /* (220) agg_func_opt ::= AGGREGATE */
  {  259,    0 }, /* (221) bufsize_opt ::= */
  {  259,   -2 }, /* (222) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  202,   -7 }, /* (223) cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression */
  {  202,   -3 }, /* (224) cmd ::= DROP STREAM stream_name */
  {  202,   -3 }, /* (225) cmd ::= KILL CONNECTION NK_INTEGER */
  {  202,   -3 }, /* (226) cmd ::= KILL QUERY NK_INTEGER */
  {  202,   -4 }, /* (227) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  202,   -4 }, /* (228) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  202,   -3 }, /* (229) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  261,   -2 }, /* (230) dnode_list ::= DNODE NK_INTEGER */
  {  261,   -3 }, /* (231) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  202,   -3 }, /* (232) cmd ::= SYNCDB db_name REPLICA */
  {  202,   -1 }, /* (233) cmd ::= query_expression */
  {  205,   -1 }, /* (234) literal ::= NK_INTEGER */
  {  205,   -1 }, /* (235) literal ::= NK_FLOAT */
  {  205,   -1 }, /* (236) literal ::= NK_STRING */
  {  205,   -1 }, /* (237) literal ::= NK_BOOL */
  {  205,   -2 }, /* (238) literal ::= TIMESTAMP NK_STRING */
  {  205,   -1 }, /* (239) literal ::= duration_literal */
  {  205,   -1 }, /* (240) literal ::= NULL */
  {  250,   -1 }, /* (241) duration_literal ::= NK_VARIABLE */
  {  262,   -1 }, /* (242) signed ::= NK_INTEGER */
  {  262,   -2 }, /* (243) signed ::= NK_PLUS NK_INTEGER */
  {  262,   -2 }, /* (244) signed ::= NK_MINUS NK_INTEGER */
  {  262,   -1 }, /* (245) signed ::= NK_FLOAT */
  {  262,   -2 }, /* (246) signed ::= NK_PLUS NK_FLOAT */
  {  262,   -2 }, /* (247) signed ::= NK_MINUS NK_FLOAT */
  {  263,   -1 }, /* (248) signed_literal ::= signed */
  {  263,   -1 }, /* (249) signed_literal ::= NK_STRING */
  {  263,   -1 }, /* (250) signed_literal ::= NK_BOOL */
  {  263,   -2 }, /* (251) signed_literal ::= TIMESTAMP NK_STRING */
  {  263,   -1 }, /* (252) signed_literal ::= duration_literal */
  {  263,   -1 }, /* (253) signed_literal ::= NULL */
  {  233,   -1 }, /* (254) literal_list ::= signed_literal */
  {  233,   -3 }, /* (255) literal_list ::= literal_list NK_COMMA signed_literal */
  {  211,   -1 }, /* (256) db_name ::= NK_ID */
  {  236,   -1 }, /* (257) table_name ::= NK_ID */
  {  229,   -1 }, /* (258) column_name ::= NK_ID */
  {  246,   -1 }, /* (259) function_name ::= NK_ID */
  {  246,   -1 }, /* (260) function_name ::= FIRST */
  {  246,   -1 }, /* (261) function_name ::= LAST */
  {  264,   -1 }, /* (262) table_alias ::= NK_ID */
  {  265,   -1 }, /* (263) column_alias ::= NK_ID */
  {  207,   -1 }, /* (264) user_name ::= NK_ID */
  {  247,   -1 }, /* (265) index_name ::= NK_ID */
  {  254,   -1 }, /* (266) topic_name ::= NK_ID */
  {  260,   -1 }, /* (267) stream_name ::= NK_ID */
  {  266,   -1 }, /* (268) expression ::= literal */
  {  266,   -1 }, /* (269) expression ::= pseudo_column */
  {  266,   -1 }, /* (270) expression ::= column_reference */
  {  266,   -4 }, /* (271) expression ::= function_name NK_LP expression_list NK_RP */
  {  266,   -4 }, /* (272) expression ::= function_name NK_LP NK_STAR NK_RP */
  {  266,   -1 }, /* (273) expression ::= subquery */
  {  266,   -3 }, /* (274) expression ::= NK_LP expression NK_RP */
  {  266,   -2 }, /* (275) expression ::= NK_PLUS expression */
  {  266,   -2 }, /* (276) expression ::= NK_MINUS expression */
  {  266,   -3 }, /* (277) expression ::= expression NK_PLUS expression */
  {  266,   -3 }, /* (278) expression ::= expression NK_MINUS expression */
  {  266,   -3 }, /* (279) expression ::= expression NK_STAR expression */
  {  266,   -3 }, /* (280) expression ::= expression NK_SLASH expression */
  {  266,   -3 }, /* (281) expression ::= expression NK_REM expression */
  {  253,   -1 }, /* (282) expression_list ::= expression */
  {  253,   -3 }, /* (283) expression_list ::= expression_list NK_COMMA expression */
  {  268,   -1 }, /* (284) column_reference ::= column_name */
  {  268,   -3 }, /* (285) column_reference ::= table_name NK_DOT column_name */
  {  267,   -1 }, /* (286) pseudo_column ::= NOW */
  {  267,   -1 }, /* (287) pseudo_column ::= ROWTS */
  {  267,   -1 }, /* (288) pseudo_column ::= TBNAME */
  {  267,   -1 }, /* (289) pseudo_column ::= QSTARTTS */
  {  267,   -1 }, /* (290) pseudo_column ::= QENDTS */
  {  267,   -1 }, /* (291) pseudo_column ::= WSTARTTS */
  {  267,   -1 }, /* (292) pseudo_column ::= WENDTS */
  {  267,   -1 }, /* (293) pseudo_column ::= WDURATION */
  {  270,   -3 }, /* (294) predicate ::= expression compare_op expression */
  {  270,   -5 }, /* (295) predicate ::= expression BETWEEN expression AND expression */
  {  270,   -6 }, /* (296) predicate ::= expression NOT BETWEEN expression AND expression */
  {  270,   -3 }, /* (297) predicate ::= expression IS NULL */
  {  270,   -4 }, /* (298) predicate ::= expression IS NOT NULL */
  {  270,   -3 }, /* (299) predicate ::= expression in_op in_predicate_value */
  {  271,   -1 }, /* (300) compare_op ::= NK_LT */
  {  271,   -1 }, /* (301) compare_op ::= NK_GT */
  {  271,   -1 }, /* (302) compare_op ::= NK_LE */
  {  271,   -1 }, /* (303) compare_op ::= NK_GE */
  {  271,   -1 }, /* (304) compare_op ::= NK_NE */
  {  271,   -1 }, /* (305) compare_op ::= NK_EQ */
  {  271,   -1 }, /* (306) compare_op ::= LIKE */
  {  271,   -2 }, /* (307) compare_op ::= NOT LIKE */
  {  271,   -1 }, /* (308) compare_op ::= MATCH */
  {  271,   -1 }, /* (309) compare_op ::= NMATCH */
  {  272,   -1 }, /* (310) in_op ::= IN */
  {  272,   -2 }, /* (311) in_op ::= NOT IN */
  {  273,   -3 }, /* (312) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  274,   -1 }, /* (313) boolean_value_expression ::= boolean_primary */
  {  274,   -2 }, /* (314) boolean_value_expression ::= NOT boolean_primary */
  {  274,   -3 }, /* (315) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  274,   -3 }, /* (316) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  275,   -1 }, /* (317) boolean_primary ::= predicate */
  {  275,   -3 }, /* (318) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  276,   -1 }, /* (319) common_expression ::= expression */
  {  276,   -1 }, /* (320) common_expression ::= boolean_value_expression */
  {  277,   -2 }, /* (321) from_clause ::= FROM table_reference_list */
  {  278,   -1 }, /* (322) table_reference_list ::= table_reference */
  {  278,   -3 }, /* (323) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  279,   -1 }, /* (324) table_reference ::= table_primary */
  {  279,   -1 }, /* (325) table_reference ::= joined_table */
  {  280,   -2 }, /* (326) table_primary ::= table_name alias_opt */
  {  280,   -4 }, /* (327) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  280,   -2 }, /* (328) table_primary ::= subquery alias_opt */
  {  280,   -1 }, /* (329) table_primary ::= parenthesized_joined_table */
  {  282,    0 }, /* (330) alias_opt ::= */
  {  282,   -1 }, /* (331) alias_opt ::= table_alias */
  {  282,   -2 }, /* (332) alias_opt ::= AS table_alias */
  {  283,   -3 }, /* (333) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  283,   -3 }, /* (334) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  281,   -6 }, /* (335) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  284,    0 }, /* (336) join_type ::= */
  {  284,   -1 }, /* (337) join_type ::= INNER */
  {  286,   -9 }, /* (338) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  287,    0 }, /* (339) set_quantifier_opt ::= */
  {  287,   -1 }, /* (340) set_quantifier_opt ::= DISTINCT */
  {  287,   -1 }, /* (341) set_quantifier_opt ::= ALL */
  {  288,   -1 }, /* (342) select_list ::= NK_STAR */
  {  288,   -1 }, /* (343) select_list ::= select_sublist */
  {  294,   -1 }, /* (344) select_sublist ::= select_item */
  {  294,   -3 }, /* (345) select_sublist ::= select_sublist NK_COMMA select_item */
  {  295,   -1 }, /* (346) select_item ::= common_expression */
  {  295,   -2 }, /* (347) select_item ::= common_expression column_alias */
  {  295,   -3 }, /* (348) select_item ::= common_expression AS column_alias */
  {  295,   -3 }, /* (349) select_item ::= table_name NK_DOT NK_STAR */
  {  289,    0 }, /* (350) where_clause_opt ::= */
  {  289,   -2 }, /* (351) where_clause_opt ::= WHERE search_condition */
  {  290,    0 }, /* (352) partition_by_clause_opt ::= */
  {  290,   -3 }, /* (353) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  291,    0 }, /* (354) twindow_clause_opt ::= */
  {  291,   -6 }, /* (355) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  291,   -4 }, /* (356) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  291,   -6 }, /* (357) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  291,   -8 }, /* (358) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  251,    0 }, /* (359) sliding_opt ::= */
  {  251,   -4 }, /* (360) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  296,    0 }, /* (361) fill_opt ::= */
  {  296,   -4 }, /* (362) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  296,   -6 }, /* (363) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  297,   -1 }, /* (364) fill_mode ::= NONE */
  {  297,   -1 }, /* (365) fill_mode ::= PREV */
  {  297,   -1 }, /* (366) fill_mode ::= NULL */
  {  297,   -1 }, /* (367) fill_mode ::= LINEAR */
  {  297,   -1 }, /* (368) fill_mode ::= NEXT */
  {  292,    0 }, /* (369) group_by_clause_opt ::= */
  {  292,   -3 }, /* (370) group_by_clause_opt ::= GROUP BY group_by_list */
  {  298,   -1 }, /* (371) group_by_list ::= expression */
  {  298,   -3 }, /* (372) group_by_list ::= group_by_list NK_COMMA expression */
  {  293,    0 }, /* (373) having_clause_opt ::= */
  {  293,   -2 }, /* (374) having_clause_opt ::= HAVING search_condition */
  {  255,   -4 }, /* (375) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  299,   -1 }, /* (376) query_expression_body ::= query_primary */
  {  299,   -4 }, /* (377) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  303,   -1 }, /* (378) query_primary ::= query_specification */
  {  300,    0 }, /* (379) order_by_clause_opt ::= */
  {  300,   -3 }, /* (380) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  301,    0 }, /* (381) slimit_clause_opt ::= */
  {  301,   -2 }, /* (382) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  301,   -4 }, /* (383) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  301,   -4 }, /* (384) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  302,    0 }, /* (385) limit_clause_opt ::= */
  {  302,   -2 }, /* (386) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  302,   -4 }, /* (387) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  302,   -4 }, /* (388) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  269,   -3 }, /* (389) subquery ::= NK_LP query_expression NK_RP */
  {  285,   -1 }, /* (390) search_condition ::= common_expression */
  {  304,   -1 }, /* (391) sort_specification_list ::= sort_specification */
  {  304,   -3 }, /* (392) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  305,   -3 }, /* (393) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  306,    0 }, /* (394) ordering_specification_opt ::= */
  {  306,   -1 }, /* (395) ordering_specification_opt ::= ASC */
  {  306,   -1 }, /* (396) ordering_specification_opt ::= DESC */
  {  307,    0 }, /* (397) null_ordering_opt ::= */
  {  307,   -2 }, /* (398) null_ordering_opt ::= NULLS FIRST */
  {  307,   -2 }, /* (399) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,203,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,204,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,203,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,205,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,206,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,204,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,206,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,205,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy393, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy393, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy393, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy393); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy393, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy393, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy393); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 256: /* db_name ::= NK_ID */ yytestcase(yyruleno==256);
      case 257: /* table_name ::= NK_ID */ yytestcase(yyruleno==257);
      case 258: /* column_name ::= NK_ID */ yytestcase(yyruleno==258);
      case 259: /* function_name ::= NK_ID */ yytestcase(yyruleno==259);
      case 260: /* function_name ::= FIRST */ yytestcase(yyruleno==260);
      case 261: /* function_name ::= LAST */ yytestcase(yyruleno==261);
      case 262: /* table_alias ::= NK_ID */ yytestcase(yyruleno==262);
      case 263: /* column_alias ::= NK_ID */ yytestcase(yyruleno==263);
      case 264: /* user_name ::= NK_ID */ yytestcase(yyruleno==264);
      case 265: /* index_name ::= NK_ID */ yytestcase(yyruleno==265);
      case 266: /* topic_name ::= NK_ID */ yytestcase(yyruleno==266);
      case 267: /* stream_name ::= NK_ID */ yytestcase(yyruleno==267);
{ yylhsminor.yy393 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy393 = yylhsminor.yy393;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateQnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropQnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy537, &yymsp[-1].minor.yy393, yymsp[0].minor.yy168); }
        break;
      case 44: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy537, &yymsp[0].minor.yy393); }
        break;
      case 45: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy393); }
        break;
      case 46: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy393, yymsp[0].minor.yy168); }
        break;
      case 47: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy537 = true; }
        break;
      case 48: /* not_exists_opt ::= */
      case 50: /* exists_opt ::= */ yytestcase(yyruleno==50);
      case 211: /* analyze_opt ::= */ yytestcase(yyruleno==211);
      case 219: /* agg_func_opt ::= */ yytestcase(yyruleno==219);
      case 339: /* set_quantifier_opt ::= */ yytestcase(yyruleno==339);
{ yymsp[1].minor.yy537 = false; }
        break;
      case 49: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy537 = true; }
        break;
      case 51: /* db_options ::= */
{ yymsp[1].minor.yy168 = createDatabaseOptions(pCxt); }
        break;
      case 52: /* db_options ::= db_options BLOCKS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy168)->pNumOfBlocks = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 53: /* db_options ::= db_options CACHE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy168)->pCacheBlockSize = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 54: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy168)->pCachelast = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 55: /* db_options ::= db_options COMP NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy168)->pCompressionLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 56: /* db_options ::= db_options DAYS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy168)->pDaysPerFile = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 57: /* db_options ::= db_options DAYS NK_VARIABLE */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy168)->pDaysPerFile = (SValueNode*)createDurationValueNode(pCxt, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 58: /* db_options ::= db_options FSYNC NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy168)->pFsyncPeriod = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 59: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy168)->pMaxRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 60: /* db_options ::= db_options MINROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy168)->pMinRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 61: /* db_options ::= db_options KEEP integer_list */
      case 62: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==62);
{ ((SDatabaseOptions*)yymsp[-2].minor.yy168)->pKeep = yymsp[0].minor.yy376; yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 63: /* db_options ::= db_options PRECISION NK_STRING */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy168)->pPrecision = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 64: /* db_options ::= db_options QUORUM NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy168)->pQuorum = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 65: /* db_options ::= db_options REPLICA NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy168)->pReplica = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 66: /* db_options ::= db_options TTL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy168)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 67: /* db_options ::= db_options WAL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy168)->pWalLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 68: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy168)->pNumOfVgroups = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 69: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy168)->pSingleStable = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 70: /* db_options ::= db_options STREAM_MODE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy168)->pStreamMode = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 71: /* db_options ::= db_options RETENTIONS retention_list */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy168)->pRetentions = yymsp[0].minor.yy376; yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 72: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy168 = createDatabaseOptions(pCxt); yylhsminor.yy168 = setDatabaseAlterOption(pCxt, yylhsminor.yy168, &yymsp[0].minor.yy277); }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 73: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy168 = setDatabaseAlterOption(pCxt, yymsp[-1].minor.yy168, &yymsp[0].minor.yy277); }
  yymsp[-1].minor.yy168 = yylhsminor.yy168;
        break;
      case 74: /* alter_db_option ::= BLOCKS NK_INTEGER */
{ yymsp[-1].minor.yy277.type = DB_OPTION_BLOCKS; yymsp[-1].minor.yy277.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 75: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy277.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy277.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 76: /* alter_db_option ::= KEEP integer_list */
      case 77: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==77);
{ yymsp[-1].minor.yy277.type = DB_OPTION_KEEP; yymsp[-1].minor.yy277.pList = yymsp[0].minor.yy376; }
        break;
      case 78: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy277.type = DB_OPTION_WAL; yymsp[-1].minor.yy277.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 79: /* alter_db_option ::= QUORUM NK_INTEGER */
{ yymsp[-1].minor.yy277.type = DB_OPTION_QUORUM; yymsp[-1].minor.yy277.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 80: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy277.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy277.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 81: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy277.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy277.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 82: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy376 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 83: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 231: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==231);
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 84: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy376 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 85: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 86: /* retention_list ::= retention */
      case 106: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==106);
      case 109: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==109);
      case 116: /* column_def_list ::= column_def */ yytestcase(yyruleno==116);
      case 159: /* col_name_list ::= col_name */ yytestcase(yyruleno==159);
      case 192: /* func_name_list ::= func_name */ yytestcase(yyruleno==192);
      case 201: /* func_list ::= func */ yytestcase(yyruleno==201);
      case 254: /* literal_list ::= signed_literal */ yytestcase(yyruleno==254);
      case 344: /* select_sublist ::= select_item */ yytestcase(yyruleno==344);
      case 391: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==391);
{ yylhsminor.yy376 = createNodeList(pCxt, yymsp[0].minor.yy168); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 87: /* retention_list ::= retention_list NK_COMMA retention */
      case 117: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==117);
      case 160: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==160);
      case 193: /* func_name_list ::= func_name_list NK_COMMA col_name */ yytestcase(yyruleno==193);
      case 202: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==202);
      case 255: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==255);
      case 345: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==345);
      case 392: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==392);
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, yymsp[0].minor.yy168); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 88: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy168 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 89: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 91: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==91);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy537, yymsp[-5].minor.yy168, yymsp[-3].minor.yy376, yymsp[-1].minor.yy376, yymsp[0].minor.yy168); }
        break;
      case 90: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy376); }
        break;
      case 92: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy376); }
        break;
      case 93: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy537, yymsp[0].minor.yy168); }
        break;
      case 94: /* cmd ::= ALTER TABLE alter_table_clause */
      case 95: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==95);
      case 233: /* cmd ::= query_expression */ yytestcase(yyruleno==233);
{ pCxt->pRootNode = yymsp[0].minor.yy168; }
        break;
      case 96: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy168 = createAlterTableOption(pCxt, yymsp[-1].minor.yy168, yymsp[0].minor.yy168); }
  yymsp[-1].minor.yy168 = yylhsminor.yy168;
        break;
      case 97: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy168 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy168, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy393, yymsp[0].minor.yy224); }
  yymsp[-4].minor.yy168 = yylhsminor.yy168;
        break;
      case 98: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy168 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy168, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy393); }
  yymsp[-3].minor.yy168 = yylhsminor.yy168;
        break;
      case 99: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy168 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy168, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy393, yymsp[0].minor.yy224); }
  yymsp[-4].minor.yy168 = yylhsminor.yy168;
        break;
      case 100: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy168 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy168, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy393, &yymsp[0].minor.yy393); }
  yymsp[-4].minor.yy168 = yylhsminor.yy168;
        break;
      case 101: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy168 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy168, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy393, yymsp[0].minor.yy224); }
  yymsp[-4].minor.yy168 = yylhsminor.yy168;
        break;
      case 102: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy168 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy168, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy393); }
  yymsp[-3].minor.yy168 = yylhsminor.yy168;
        break;
      case 103: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy168 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy168, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy393, yymsp[0].minor.yy224); }
  yymsp[-4].minor.yy168 = yylhsminor.yy168;
        break;
      case 104: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy168 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy168, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy393, &yymsp[0].minor.yy393); }
  yymsp[-4].minor.yy168 = yylhsminor.yy168;
        break;
      case 105: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy168 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy168, &yymsp[-2].minor.yy393, yymsp[0].minor.yy168); }
  yymsp[-5].minor.yy168 = yylhsminor.yy168;
        break;
      case 107: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 110: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==110);
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-1].minor.yy376, yymsp[0].minor.yy168); }
  yymsp[-1].minor.yy376 = yylhsminor.yy376;
        break;
      case 108: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
{ yylhsminor.yy168 = createCreateSubTableClause(pCxt, yymsp[-8].minor.yy537, yymsp[-7].minor.yy168, yymsp[-5].minor.yy168, yymsp[-4].minor.yy376, yymsp[-1].minor.yy376); }
  yymsp[-8].minor.yy168 = yylhsminor.yy168;
        break;
      case 111: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy168 = createDropTableClause(pCxt, yymsp[-1].minor.yy537, yymsp[0].minor.yy168); }
  yymsp[-1].minor.yy168 = yylhsminor.yy168;
        break;
      case 112: /* specific_tags_opt ::= */
      case 143: /* tags_def_opt ::= */ yytestcase(yyruleno==143);
      case 352: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==352);
      case 369: /* group_by_clause_opt ::= */ yytestcase(yyruleno==369);
      case 379: /* order_by_clause_opt ::= */ yytestcase(yyruleno==379);
{ yymsp[1].minor.yy376 = NULL; }
        break;
      case 113: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy376 = yymsp[-1].minor.yy376; }
        break;
      case 114: /* full_table_name ::= table_name */
{ yylhsminor.yy168 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy393, NULL); }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 115: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy168 = createRealTableNode(pCxt, &yymsp[-2].minor.yy393, &yymsp[0].minor.yy393, NULL); }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 118: /* column_def ::= column_name type_name */
{ yylhsminor.yy168 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy393, yymsp[0].minor.yy224, NULL); }
  yymsp[-1].minor.yy168 = yylhsminor.yy168;
        break;
      case 119: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy168 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy393, yymsp[-2].minor.yy224, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy168 = yylhsminor.yy168;
        break;
      case 120: /* type_name ::= BOOL */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 121: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 122: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 123: /* type_name ::= INT */
      case 124: /* type_name ::= INTEGER */ yytestcase(yyruleno==124);
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 125: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 126: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 127: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 128: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy224 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 129: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 130: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy224 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 131: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy224 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 132: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy224 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 133: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy224 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 134: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy224 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 135: /* type_name ::= JSON */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 136: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy224 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 137: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 138: /* type_name ::= BLOB */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 139: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy224 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 140: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 141: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy224 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 142: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy224 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 144: /* tags_def_opt ::= tags_def */
      case 343: /* select_list ::= select_sublist */ yytestcase(yyruleno==343);
{ yylhsminor.yy376 = yymsp[0].minor.yy376; }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 145: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy376 = yymsp[-1].minor.yy376; }
        break;
      case 146: /* table_options ::= */
{ yymsp[1].minor.yy168 = createTableOptions(pCxt); }
        break;
      case 147: /* table_options ::= table_options COMMENT NK_STRING */
{ ((STableOptions*)yymsp[-2].minor.yy168)->pComments = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 148: /* table_options ::= table_options KEEP integer_list */
{ ((STableOptions*)yymsp[-2].minor.yy168)->pKeep = yymsp[0].minor.yy376; yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 149: /* table_options ::= table_options TTL NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy168)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 150: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy168)->pSma = yymsp[-1].minor.yy376; yylhsminor.yy168 = yymsp[-4].minor.yy168; }
  yymsp[-4].minor.yy168 = yylhsminor.yy168;
        break;
      case 151: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy168)->pFuncs = yymsp[-1].minor.yy376; yylhsminor.yy168 = yymsp[-4].minor.yy168; }
  yymsp[-4].minor.yy168 = yylhsminor.yy168;
        break;
      case 152: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ ((STableOptions*)yymsp[-2].minor.yy168)->pFilesFactor = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 153: /* table_options ::= table_options DELAY NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy168)->pDelay = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy168 = yymsp[-2].minor.yy168; }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 154: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy168 = createTableOptions(pCxt); yylhsminor.yy168 = setTableAlterOption(pCxt, yylhsminor.yy168, &yymsp[0].minor.yy277); }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 155: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy168 = setTableAlterOption(pCxt, yymsp[-1].minor.yy168, &yymsp[0].minor.yy277); }
  yymsp[-1].minor.yy168 = yylhsminor.yy168;
        break;
      case 156: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy277.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy277.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 157: /* alter_table_option ::= KEEP integer_list */
{ yymsp[-1].minor.yy277.type = TABLE_OPTION_KEEP; yymsp[-1].minor.yy277.pList = yymsp[0].minor.yy376; }
        break;
      case 158: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy277.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy277.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 161: /* col_name ::= column_name */
{ yylhsminor.yy168 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy393); }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 162: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 163: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 164: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 165: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy168, yymsp[0].minor.yy168); }
        break;
      case 166: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy168, yymsp[0].minor.yy168); }
        break;
      case 167: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy168, NULL); }
        break;
      case 168: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 169: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 170: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 171: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 172: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy168, yymsp[0].minor.yy168); }
        break;
      case 173: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 174: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 175: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 176: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 177: /* cmd ::= SHOW LICENCE */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 178: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy393); }
        break;
      case 179: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy168); }
        break;
      case 180: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy168); }
        break;
      case 181: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 182: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 183: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 184: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 185: /* db_name_cond_opt ::= */
      case 190: /* from_db_opt ::= */ yytestcase(yyruleno==190);
{ yymsp[1].minor.yy168 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 186: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy168 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy393); }
  yymsp[-1].minor.yy168 = yylhsminor.yy168;
        break;
      case 187: /* like_pattern_opt ::= */
      case 198: /* index_options ::= */ yytestcase(yyruleno==198);
      case 350: /* where_clause_opt ::= */ yytestcase(yyruleno==350);
      case 354: /* twindow_clause_opt ::= */ yytestcase(yyruleno==354);
      case 359: /* sliding_opt ::= */ yytestcase(yyruleno==359);
      case 361: /* fill_opt ::= */ yytestcase(yyruleno==361);
      case 373: /* having_clause_opt ::= */ yytestcase(yyruleno==373);
      case 381: /* slimit_clause_opt ::= */ yytestcase(yyruleno==381);
      case 385: /* limit_clause_opt ::= */ yytestcase(yyruleno==385);
{ yymsp[1].minor.yy168 = NULL; }
        break;
      case 188: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy168 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 189: /* table_name_cond ::= table_name */
{ yylhsminor.yy168 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy393); }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 191: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy168 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy393); }
        break;
      case 194: /* func_name ::= function_name */
{ yylhsminor.yy168 = createFunctionNode(pCxt, &yymsp[0].minor.yy393, NULL); }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 195: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy537, &yymsp[-3].minor.yy393, &yymsp[-1].minor.yy393, NULL, yymsp[0].minor.yy168); }
        break;
      case 196: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy537, &yymsp[-5].minor.yy393, &yymsp[-3].minor.yy393, yymsp[-1].minor.yy376, NULL); }
        break;
      case 197: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy537, &yymsp[-2].minor.yy393, &yymsp[0].minor.yy393); }
        break;
      case 199: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy168 = createIndexOption(pCxt, yymsp[-6].minor.yy376, releaseRawExprNode(pCxt, yymsp[-2].minor.yy168), NULL, yymsp[0].minor.yy168); }
        break;
      case 200: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy168 = createIndexOption(pCxt, yymsp[-8].minor.yy376, releaseRawExprNode(pCxt, yymsp[-4].minor.yy168), releaseRawExprNode(pCxt, yymsp[-2].minor.yy168), yymsp[0].minor.yy168); }
        break;
      case 203: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy168 = createFunctionNode(pCxt, &yymsp[-3].minor.yy393, yymsp[-1].minor.yy376); }
  yymsp[-3].minor.yy168 = yylhsminor.yy168;
        break;
      case 204: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy537, &yymsp[-2].minor.yy393, yymsp[0].minor.yy168, NULL); }
        break;
      case 205: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy537, &yymsp[-2].minor.yy393, NULL, &yymsp[0].minor.yy393); }
        break;
      case 206: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy537, &yymsp[0].minor.yy393); }
        break;
      case 207: /* cmd ::= DESC full_table_name */
      case 208: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==208);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy168); }
        break;
      case 209: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 210: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy537, yymsp[-1].minor.yy168, yymsp[0].minor.yy168); }
        break;
      case 212: /* analyze_opt ::= ANALYZE */
      case 220: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==220);
      case 340: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==340);
{ yymsp[0].minor.yy537 = true; }
        break;
      case 213: /* explain_options ::= */
{ yymsp[1].minor.yy168 = createDefaultExplainOptions(pCxt); }
        break;
      case 214: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy168 = setExplainVerbose(pCxt, yymsp[-2].minor.yy168, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 215: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy168 = setExplainRatio(pCxt, yymsp[-2].minor.yy168, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 216: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy376); }
        break;
      case 217: /* cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy537, &yymsp[-5].minor.yy393, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy224, yymsp[0].minor.yy508); }
        break;
      case 218: /* cmd ::= DROP FUNCTION function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, &yymsp[0].minor.yy393); }
        break;
      case 221: /* bufsize_opt ::= */
{ yymsp[1].minor.yy508 = 0; }
        break;
      case 222: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy508 = strtol(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 223: /* cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, &yymsp[-4].minor.yy393, &yymsp[-2].minor.yy393, yymsp[0].minor.yy168); }
        break;
      case 224: /* cmd ::= DROP STREAM stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, &yymsp[0].minor.yy393); }
        break;
      case 225: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 226: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 227: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 228: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy376); }
        break;
      case 229: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 230: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy376 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 232: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy393); }
        break;
      case 234: /* literal ::= NK_INTEGER */
{ yylhsminor.yy168 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 235: /* literal ::= NK_FLOAT */
{ yylhsminor.yy168 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 236: /* literal ::= NK_STRING */
{ yylhsminor.yy168 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 237: /* literal ::= NK_BOOL */
{ yylhsminor.yy168 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 238: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy168 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy168 = yylhsminor.yy168;
        break;
      case 239: /* literal ::= duration_literal */
      case 248: /* signed_literal ::= signed */ yytestcase(yyruleno==248);
      case 268: /* expression ::= literal */ yytestcase(yyruleno==268);
      case 269: /* expression ::= pseudo_column */ yytestcase(yyruleno==269);
      case 270: /* expression ::= column_reference */ yytestcase(yyruleno==270);
      case 273: /* expression ::= subquery */ yytestcase(yyruleno==273);
      case 313: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==313);
      case 317: /* boolean_primary ::= predicate */ yytestcase(yyruleno==317);
      case 319: /* common_expression ::= expression */ yytestcase(yyruleno==319);
      case 320: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==320);
      case 322: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==322);
      case 324: /* table_reference ::= table_primary */ yytestcase(yyruleno==324);
      case 325: /* table_reference ::= joined_table */ yytestcase(yyruleno==325);
      case 329: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==329);
      case 376: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==376);
      case 378: /* query_primary ::= query_specification */ yytestcase(yyruleno==378);
{ yylhsminor.yy168 = yymsp[0].minor.yy168; }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 240: /* literal ::= NULL */
{ yylhsminor.yy168 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL)); }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 241: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy168 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 242: /* signed ::= NK_INTEGER */
{ yylhsminor.yy168 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 243: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy168 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 244: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy168 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy168 = yylhsminor.yy168;
        break;
      case 245: /* signed ::= NK_FLOAT */
{ yylhsminor.yy168 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 246: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy168 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 247: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy168 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy168 = yylhsminor.yy168;
        break;
      case 249: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy168 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 250: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy168 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 251: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy168 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 252: /* signed_literal ::= duration_literal */
      case 390: /* search_condition ::= common_expression */ yytestcase(yyruleno==390);
{ yylhsminor.yy168 = releaseRawExprNode(pCxt, yymsp[0].minor.yy168); }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 253: /* signed_literal ::= NULL */
{ yymsp[0].minor.yy168 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL); }
        break;
      case 271: /* expression ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy168 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy393, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy393, yymsp[-1].minor.yy376)); }
  yymsp[-3].minor.yy168 = yylhsminor.yy168;
        break;
      case 272: /* expression ::= function_name NK_LP NK_STAR NK_RP */
{ yylhsminor.yy168 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy393, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy393, createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy0)))); }
  yymsp[-3].minor.yy168 = yylhsminor.yy168;
        break;
      case 274: /* expression ::= NK_LP expression NK_RP */
      case 318: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==318);
{ yylhsminor.yy168 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy168)); }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 275: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy168);
                                                                                    yylhsminor.yy168 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy168));
                                                                                  }
  yymsp[-1].minor.yy168 = yylhsminor.yy168;
        break;
      case 276: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy168);
                                                                                    yylhsminor.yy168 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy168), NULL));
                                                                                  }
  yymsp[-1].minor.yy168 = yylhsminor.yy168;
        break;
      case 277: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy168);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy168);
                                                                                    yylhsminor.yy168 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy168), releaseRawExprNode(pCxt, yymsp[0].minor.yy168))); 
                                                                                  }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 278: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy168);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy168);
                                                                                    yylhsminor.yy168 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy168), releaseRawExprNode(pCxt, yymsp[0].minor.yy168))); 
                                                                                  }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 279: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy168);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy168);
                                                                                    yylhsminor.yy168 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy168), releaseRawExprNode(pCxt, yymsp[0].minor.yy168))); 
                                                                                  }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 280: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy168);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy168);
                                                                                    yylhsminor.yy168 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy168), releaseRawExprNode(pCxt, yymsp[0].minor.yy168))); 
                                                                                  }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 281: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy168);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy168);
                                                                                    yylhsminor.yy168 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy168), releaseRawExprNode(pCxt, yymsp[0].minor.yy168))); 
                                                                                  }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 282: /* expression_list ::= expression */
{ yylhsminor.yy376 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy168)); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 283: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, releaseRawExprNode(pCxt, yymsp[0].minor.yy168)); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 284: /* column_reference ::= column_name */
{ yylhsminor.yy168 = createRawExprNode(pCxt, &yymsp[0].minor.yy393, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy393)); }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 285: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy168 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy393, &yymsp[0].minor.yy393, createColumnNode(pCxt, &yymsp[-2].minor.yy393, &yymsp[0].minor.yy393)); }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 286: /* pseudo_column ::= NOW */
      case 287: /* pseudo_column ::= ROWTS */ yytestcase(yyruleno==287);
      case 288: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==288);
      case 289: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==289);
      case 290: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==290);
      case 291: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==291);
      case 292: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==292);
      case 293: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==293);
{ yylhsminor.yy168 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 294: /* predicate ::= expression compare_op expression */
      case 299: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==299);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy168);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy168);
                                                                                    yylhsminor.yy168 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy436, releaseRawExprNode(pCxt, yymsp[-2].minor.yy168), releaseRawExprNode(pCxt, yymsp[0].minor.yy168)));
                                                                                  }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 295: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy168);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy168);
                                                                                    yylhsminor.yy168 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy168), releaseRawExprNode(pCxt, yymsp[-2].minor.yy168), releaseRawExprNode(pCxt, yymsp[0].minor.yy168)));
                                                                                  }
  yymsp[-4].minor.yy168 = yylhsminor.yy168;
        break;
      case 296: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy168);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy168);
                                                                                    yylhsminor.yy168 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy168), releaseRawExprNode(pCxt, yymsp[-5].minor.yy168), releaseRawExprNode(pCxt, yymsp[0].minor.yy168)));
                                                                                  }
  yymsp[-5].minor.yy168 = yylhsminor.yy168;
        break;
      case 297: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy168);
                                                                                    yylhsminor.yy168 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy168), NULL));
                                                                                  }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 298: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy168);
                                                                                    yylhsminor.yy168 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy168), NULL));
                                                                                  }
  yymsp[-3].minor.yy168 = yylhsminor.yy168;
        break;
      case 300: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy436 = OP_TYPE_LOWER_THAN; }
        break;
      case 301: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy436 = OP_TYPE_GREATER_THAN; }
        break;
      case 302: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy436 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 303: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy436 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 304: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy436 = OP_TYPE_NOT_EQUAL; }
        break;
      case 305: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy436 = OP_TYPE_EQUAL; }
        break;
      case 306: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy436 = OP_TYPE_LIKE; }
        break;
      case 307: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy436 = OP_TYPE_NOT_LIKE; }
        break;
      case 308: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy436 = OP_TYPE_MATCH; }
        break;
      case 309: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy436 = OP_TYPE_NMATCH; }
        break;
      case 310: /* in_op ::= IN */
{ yymsp[0].minor.yy436 = OP_TYPE_IN; }
        break;
      case 311: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy436 = OP_TYPE_NOT_IN; }
        break;
      case 312: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy168 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy376)); }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 314: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy168);
                                                                                    yylhsminor.yy168 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy168), NULL));
                                                                                  }
  yymsp[-1].minor.yy168 = yylhsminor.yy168;
        break;
      case 315: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy168);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy168);
                                                                                    yylhsminor.yy168 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy168), releaseRawExprNode(pCxt, yymsp[0].minor.yy168)));
                                                                                  }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 316: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy168);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy168);
                                                                                    yylhsminor.yy168 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy168), releaseRawExprNode(pCxt, yymsp[0].minor.yy168)));
                                                                                  }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 321: /* from_clause ::= FROM table_reference_list */
      case 351: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==351);
      case 374: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==374);
{ yymsp[-1].minor.yy168 = yymsp[0].minor.yy168; }
        break;
      case 323: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy168 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy168, yymsp[0].minor.yy168, NULL); }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 326: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy168 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy393, &yymsp[0].minor.yy393); }
  yymsp[-1].minor.yy168 = yylhsminor.yy168;
        break;
      case 327: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy168 = createRealTableNode(pCxt, &yymsp[-3].minor.yy393, &yymsp[-1].minor.yy393, &yymsp[0].minor.yy393); }
  yymsp[-3].minor.yy168 = yylhsminor.yy168;
        break;
      case 328: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy168 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy168), &yymsp[0].minor.yy393); }
  yymsp[-1].minor.yy168 = yylhsminor.yy168;
        break;
      case 330: /* alias_opt ::= */
{ yymsp[1].minor.yy393 = nil_token;  }
        break;
      case 331: /* alias_opt ::= table_alias */
{ yylhsminor.yy393 = yymsp[0].minor.yy393; }
  yymsp[0].minor.yy393 = yylhsminor.yy393;
        break;
      case 332: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy393 = yymsp[0].minor.yy393; }
        break;
      case 333: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 334: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==334);
{ yymsp[-2].minor.yy168 = yymsp[-1].minor.yy168; }
        break;
      case 335: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy168 = createJoinTableNode(pCxt, yymsp[-4].minor.yy596, yymsp[-5].minor.yy168, yymsp[-2].minor.yy168, yymsp[0].minor.yy168); }
  yymsp[-5].minor.yy168 = yylhsminor.yy168;
        break;
      case 336: /* join_type ::= */
{ yymsp[1].minor.yy596 = JOIN_TYPE_INNER; }
        break;
      case 337: /* join_type ::= INNER */
{ yymsp[0].minor.yy596 = JOIN_TYPE_INNER; }
        break;
      case 338: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy168 = createSelectStmt(pCxt, yymsp[-7].minor.yy537, yymsp[-6].minor.yy376, yymsp[-5].minor.yy168);
                                                                                    yymsp[-8].minor.yy168 = addWhereClause(pCxt, yymsp[-8].minor.yy168, yymsp[-4].minor.yy168);
                                                                                    yymsp[-8].minor.yy168 = addPartitionByClause(pCxt, yymsp[-8].minor.yy168, yymsp[-3].minor.yy376);
                                                                                    yymsp[-8].minor.yy168 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy168, yymsp[-2].minor.yy168);
                                                                                    yymsp[-8].minor.yy168 = addGroupByClause(pCxt, yymsp[-8].minor.yy168, yymsp[-1].minor.yy376);
                                                                                    yymsp[-8].minor.yy168 = addHavingClause(pCxt, yymsp[-8].minor.yy168, yymsp[0].minor.yy168);
                                                                                  }
        break;
      case 341: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy537 = false; }
        break;
      case 342: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy376 = NULL; }
        break;
      case 346: /* select_item ::= common_expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy168);
                                                                                    yylhsminor.yy168 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy168), &t);
                                                                                  }
  yymsp[0].minor.yy168 = yylhsminor.yy168;
        break;
      case 347: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy168 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy168), &yymsp[0].minor.yy393); }
  yymsp[-1].minor.yy168 = yylhsminor.yy168;
        break;
      case 348: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy168 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy168), &yymsp[0].minor.yy393); }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 349: /* select_item ::= table_name NK_DOT NK_STAR */
{ yylhsminor.yy168 = createColumnNode(pCxt, &yymsp[-2].minor.yy393, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 353: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 370: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==370);
      case 380: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==380);
{ yymsp[-2].minor.yy376 = yymsp[0].minor.yy376; }
        break;
      case 355: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy168 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy168), releaseRawExprNode(pCxt, yymsp[-1].minor.yy168)); }
        break;
      case 356: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy168 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy168)); }
        break;
      case 357: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy168 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy168), NULL, yymsp[-1].minor.yy168, yymsp[0].minor.yy168); }
        break;
      case 358: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy168 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy168), releaseRawExprNode(pCxt, yymsp[-3].minor.yy168), yymsp[-1].minor.yy168, yymsp[0].minor.yy168); }
        break;
      case 360: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy168 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy168); }
        break;
      case 362: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy168 = createFillNode(pCxt, yymsp[-1].minor.yy382, NULL); }
        break;
      case 363: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy168 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy376)); }
        break;
      case 364: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy382 = FILL_MODE_NONE; }
        break;
      case 365: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy382 = FILL_MODE_PREV; }
        break;
      case 366: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy382 = FILL_MODE_NULL; }
        break;
      case 367: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy382 = FILL_MODE_LINEAR; }
        break;
      case 368: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy382 = FILL_MODE_NEXT; }
        break;
      case 371: /* group_by_list ::= expression */
{ yylhsminor.yy376 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy168))); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 372: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy168))); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 375: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy168 = addOrderByClause(pCxt, yymsp[-3].minor.yy168, yymsp[-2].minor.yy376);
                                                                                    yylhsminor.yy168 = addSlimitClause(pCxt, yylhsminor.yy168, yymsp[-1].minor.yy168);
                                                                                    yylhsminor.yy168 = addLimitClause(pCxt, yylhsminor.yy168, yymsp[0].minor.yy168);
                                                                                  }
  yymsp[-3].minor.yy168 = yylhsminor.yy168;
        break;
      case 377: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy168 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy168, yymsp[0].minor.yy168); }
  yymsp[-3].minor.yy168 = yylhsminor.yy168;
        break;
      case 382: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 386: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==386);
{ yymsp[-1].minor.yy168 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 383: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 387: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==387);
{ yymsp[-3].minor.yy168 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 384: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 388: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==388);
{ yymsp[-3].minor.yy168 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 389: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy168 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy168); }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 393: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy168 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy168), yymsp[-1].minor.yy554, yymsp[0].minor.yy81); }
  yymsp[-2].minor.yy168 = yylhsminor.yy168;
        break;
      case 394: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy554 = ORDER_ASC; }
        break;
      case 395: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy554 = ORDER_ASC; }
        break;
      case 396: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy554 = ORDER_DESC; }
        break;
      case 397: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy81 = NULL_ORDER_DEFAULT; }
        break;
      case 398: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy81 = NULL_ORDER_FIRST; }
        break;
      case 399: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy81 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
