/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 478
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SNode* yy184;
  int8_t yy231;
  SAlterOption yy361;
  EFillMode yy362;
  SDataType yy388;
  STokenPair yy409;
  EJoinType yy416;
  EOperatorType yy424;
  int32_t yy480;
  SNodeList* yy532;
  int64_t yy541;
  ENullOrder yy617;
  SToken yy649;
  EOrder yy706;
  bool yy829;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             777
#define YYNRULE              587
#define YYNRULE_WITH_ACTION  587
#define YYNTOKEN             332
#define YY_MAX_SHIFT         776
#define YY_MIN_SHIFTREDUCE   1151
#define YY_MAX_SHIFTREDUCE   1737
#define YY_ERROR_ACTION      1738
#define YY_ACCEPT_ACTION     1739
#define YY_NO_ACTION         1740
#define YY_MIN_REDUCE        1741
#define YY_MAX_REDUCE        2327
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (3182)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  2139, 1764, 2303,  514,  167, 2298,  515, 1777,   38,  296,
 /*    10 */   682, 1856,   48,   46, 1665,   47,   45,   44,   43,   42,
 /*    20 */   394, 2302, 1514,   41,   40, 2299, 2301,   47,   45,   44,
 /*    30 */    43,   42,  519, 1595, 1814, 1512, 2157,  439,  516,  397,
 /*    40 */  1669,  522,  643,  140,  515, 1777, 1539,  162, 2107, 2107,
 /*    50 */   684,  625,   41,   40,  373, 1917,   47,   45,   44,   43,
 /*    60 */    42, 1590, 1965, 2033, 1542,   41,   40,   19, 1539,   47,
 /*    70 */    45,   44,   43,   42, 1520,  385,  667, 2157, 2030,  655,
 /*    80 */   338, 2138,  153,  668, 1915, 2174,  566,  565,  332, 2140,
 /*    90 */   688, 2142, 2143,  683,  681,  678,  669, 2192,  168,  773,
 /*   100 */  1753,  133,   15,  750,  749,  748,  747,  404,  552,  746,
 /*   110 */   745,  144,  740,  739,  738,  737,  736,  735,  734,  157,
 /*   120 */   730,  729,  728,  403,  402,  725,  724,  723,  722,  721,
 /*   130 */  2303,  624,  101, 2298,  668, 1915,  531, 1539, 1597, 1598,
 /*   140 */  1207,   56, 1206,  275, 2235,  642,  667,  134,  641, 2302,
 /*   150 */  2298,  180,  133, 2299, 2300,  226, 1908,  166,   51,  557,
 /*   160 */  1704, 1541,  316, 1954,   62,  630,  184, 1763, 1570, 1580,
 /*   170 */  2299,  632, 2303, 1208, 1596, 1599,  314,   73,   41,   40,
 /*   180 */    72, 1741,   47,   45,   44,   43,   42,  653, 1515, 1541,
 /*   190 */  1513,  339,   41,   40, 1571, 1734,   47,   45,   44,   43,
 /*   200 */    42,  207,  496,  494,  491,  132,  131,  130,  129,  128,
 /*   210 */   127,  126,  125,  124,  255, 2107,  621, 1518, 1519, 1817,
 /*   220 */  1569, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579,  680,
 /*   230 */   676, 1588, 1589, 1591, 1592, 1593, 1594,    2,   48,   46,
 /*   240 */  1514,   62, 1184,  342,  142, 1537,  394, 2198, 1514,  431,
 /*   250 */   626,  430,  470, 1512,  477,  484,  643,  140,  483, 1595,
 /*   260 */   123, 1512, 1967,  122,  121,  120,  119,  118,  117,  116,
 /*   270 */   115,  114, 1727, 1681,  453,  107,  485, 1966,  429,  109,
 /*   280 */   455, 1186, 1693, 1189, 1190, 1428, 1429, 1590,  570,  569,
 /*   290 */   568,  141, 1520,   19, 1733,  560,  137,  564, 1967, 1907,
 /*   300 */  1520,  563,  627,  622,  615,  372,  562,  567,  367,  366,
 /*   310 */   187,  277,  561, 1965,  200,  199,  187,  773,  720,   81,
 /*   320 */    80,  436, 1539,  196,  191,  773,  360, 2033,   15,  618,
 /*   330 */   617, 1691, 1692, 1694, 1695, 1696,  667,  476,  443,  277,
 /*   340 */  1961, 1962, 2031,  655,   66,  340,  744,  742,  422, 1540,
 /*   350 */  2125,  420,  416,  412,  409,  429,  645,  182, 2235, 2236,
 /*   360 */  2121,  138, 2240,   84, 1597, 1598,   83,  481,  278, 1538,
 /*   370 */   475,  474,  473,  472,  469,  468,  467,  466,  465,  461,
 /*   380 */   460,  459,  458,  341,  450,  449,  448,   87,  445,  444,
 /*   390 */   358, 1189, 1190,  187, 1570, 1580, 2117, 2123,  389, 1540,
 /*   400 */  1596, 1599,  631,  361,   62, 2298, 1515,  678, 1513,   62,
 /*   410 */  1539,   93, 1910,  242, 1515, 2128, 1513,  241,   51, 2242,
 /*   420 */   630,  184,  106,   41,   40, 2299,  632,   47,   45,   44,
 /*   430 */    43,   42,  103,   41,   40, 1518, 1519,   47,   45,   44,
 /*   440 */    43,   42,   62, 1518, 1519, 2239, 1569, 1572, 1573, 1574,
 /*   450 */  1575, 1576, 1577, 1578, 1579,  680,  676, 1588, 1589, 1591,
 /*   460 */  1592, 1593, 1594,    2,   12,   48,   46, 1373, 1374,   30,
 /*   470 */  2130,  654, 1997,  394, 1339, 1514,  399,   90,  346, 1960,
 /*   480 */  1962,  371,  351,  586, 1542, 1283, 1595,  177, 1512, 1330,
 /*   490 */   710,  709,  708, 1334,  707, 1336, 1337,  706,  703,   62,
 /*   500 */  1345,  700, 1347, 1348,  697,  694,  426,  359, 2016,  227,
 /*   510 */   668, 1915, 2139,  712, 1590, 1742, 1958, 1445, 1446,  654,
 /*   520 */    19,  529,  646, 2026, 1285,  172, 1624, 1520,  189,  177,
 /*   530 */   428,  424,  548,  544,  540,  536,  123,  224,  654,  122,
 /*   540 */   121,  120,  119,  118,  117,  116,  115,  114, 2157, 1906,
 /*   550 */  2017, 1605,  773, 1444, 1447,   15,  187, 1539, 1571, 2121,
 /*   560 */  2107,  187,  684,   52,  209,  570,  569,  568,  517,  652,
 /*   570 */  1784, 2026,  560,  137,  564,  211, 1762,   88,  563,  517,
 /*   580 */   222, 1784, 1625,  562,  567,  367,  366, 1892,  663,  561,
 /*   590 */  2026, 1597, 1598, 2138,  187, 2117, 2123, 2174,  668, 1915,
 /*   600 */   110, 2140,  688, 2142, 2143,  683,  678,  678, 1967,  386,
 /*   610 */   593, 1207,  181, 1206, 2227,  382,   57,  165,  388, 2223,
 /*   620 */  2242, 1570, 1580, 1965, 2107, 1917, 1739, 1596, 1599,  457,
 /*   630 */  1967,  186,  668, 1915,  193,  668, 1915,  357,  456, 2253,
 /*   640 */  1890, 1515,   12, 1513, 1208, 1965, 2238,  221,  215, 1761,
 /*   650 */   437,  187,  220,  438,  527, 2302,   37,  392, 1619, 1620,
 /*   660 */  1621, 1622, 1623, 1627, 1628, 1629, 1630,   44,   43,   42,
 /*   670 */  1518, 1519,  213, 1569, 1572, 1573, 1574, 1575, 1576, 1577,
 /*   680 */  1578, 1579,  680,  676, 1588, 1589, 1591, 1592, 1593, 1594,
 /*   690 */     2,   48,   46, 1600,  584, 1520,  407, 2107,  433,  394,
 /*   700 */   406, 1514,  432, 2126, 1760, 1571, 2139,  582,  631,  580,
 /*   710 */  1967, 2298, 1595, 2121, 1512,  187,  685,  387,  718,  155,
 /*   720 */   154,  715,  714,  713,  152, 1965,  630,  184, 1294,   41,
 /*   730 */    40, 2299,  632,   47,   45,   44,   43,   42, 1542,  397,
 /*   740 */  1590, 1293, 2157,  606, 1967,  606, 2298,  165, 2298, 2117,
 /*   750 */  2123,  398, 2107, 1520, 2107, 1917,  684, 1298, 1891, 1965,
 /*   760 */   678, 2304,  184, 2304,  184, 2012, 2299,  632, 2299,  632,
 /*   770 */  1297,  718,  155,  154,  715,  714,  713,  152,  773,  511,
 /*   780 */    12,   49,   10, 2139,  400,  649,  509, 2138,  711,  505,
 /*   790 */   501, 2174,  165,  685,  110, 2140,  688, 2142, 2143,  683,
 /*   800 */  1917,  678,  668, 1915,  143,  486,  150, 2198, 2227,  192,
 /*   810 */  1192,  153,  388, 2223,  243,   34, 1538, 1597, 1598, 2157,
 /*   820 */   447,   41,   40, 2242,  720,   47,   45,   44,   43,   42,
 /*   830 */    36, 2107,  606,  684,  488, 2298,   41,   40, 1759, 1758,
 /*   840 */    47,   45,   44,   43,   42,  643,  140, 1570, 1580, 2237,
 /*   850 */  2304,  184,  253, 1596, 1599, 2299,  632,   14,   13, 2090,
 /*   860 */   287,  288,  668, 1915, 2138,  286, 1662, 1515, 2174, 1513,
 /*   870 */  1482,  110, 2140,  688, 2142, 2143,  683,  670,  678, 2199,
 /*   880 */   462, 1487, 1488, 2202, 1757, 2227, 2107, 2107,  254,  388,
 /*   890 */  2223,  164, 2100, 1756,  732,   91, 1518, 1519, 1626, 1569,
 /*   900 */  1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579,  680,  676,
 /*   910 */  1588, 1589, 1591, 1592, 1593, 1594,    2,   48,   46,   87,
 /*   920 */   575,  165,  672, 2101, 2199,  394,  634, 1514, 1755, 1918,
 /*   930 */  2012, 2012, 2107, 2139, 1904,  585,  668, 1915, 1595,  606,
 /*   940 */  1512, 2107, 2298,  646, 1911,  591,  183, 2235, 2236,  240,
 /*   950 */   138, 2240, 1900,  716,  463, 1752, 1958, 2304,  184, 1638,
 /*   960 */  2247, 1658, 2299,  632, 1751,  578, 1590,  668, 1915, 2157,
 /*   970 */   606,  572,   35, 2298,  194,  198, 2107,  239,  364, 1520,
 /*   980 */  2074, 2107, 1631,  684, 1750,  530,  643,  140, 2304,  184,
 /*   990 */   668, 1915,  606, 2299,  632, 2298,  718,  155,  154,  715,
 /*  1000 */   714,  713,  152, 2107,  773, 1749,    9,   49, 1912, 2139,
 /*  1010 */  2304,  184, 2107, 1748, 2138, 2299,  632,   70, 2174,  685,
 /*  1020 */    69,  110, 2140,  688, 2142, 2143,  683,  244,  678,  668,
 /*  1030 */  1915,  635, 2107,  181, 1747, 2227,  668, 1915,  717,  388,
 /*  1040 */  2223, 1958,  638, 1597, 1598, 2157,  365,  245,  363,  362,
 /*  1050 */   733,  554, 1877, 2107,  602, 1746,   54, 2107,    3,  684,
 /*  1060 */  2254, 2107, 1745,  668, 1915, 2093,  668, 1915,  668, 1915,
 /*  1070 */   421, 1744,  556, 1570, 1580,  310,  555, 1893, 1944, 1596,
 /*  1080 */  1599,  647, 2107,  146,  651,  135,  291,  185, 2235, 2236,
 /*  1090 */  2138,  138, 2240, 1515, 2174, 1513,  675,  110, 2140,  688,
 /*  1100 */  2142, 2143,  683, 2107,  678,  440,  668, 1915,  556, 2200,
 /*  1110 */  2107, 2227,  555,   74,  414,  388, 2223, 1661,  441, 2107,
 /*  1120 */   153,  148, 1518, 1519,  665, 1569, 1572, 1573, 1574, 1575,
 /*  1130 */  1576, 1577, 1578, 1579,  680,  676, 1588, 1589, 1591, 1592,
 /*  1140 */  1593, 1594,    2,   48,   46,  668, 1915,  668, 1915, 1523,
 /*  1150 */    50,  394,  232, 1514,  234,  230,  558,  233,  668, 1915,
 /*  1160 */   559, 1801,   82,  401, 1595,  666, 1512, 2139,  236,  238,
 /*  1170 */    50,  235,  237, 1793, 1791,  252,  297,  685, 1281, 1485,
 /*  1180 */   259, 1902, 1279,  571,  588,  605,  587, 1736, 1737, 1522,
 /*  1190 */  2139, 1898, 1590, 1240,   50,  573,  576,   14,   13,  726,
 /*  1200 */   685,  727, 1786, 2157, 1857, 1520,  153,   50,  375, 1690,
 /*  1210 */  1919,  249,  679,  284,   71, 2107, 1754,  684, 1787, 2267,
 /*  1220 */  1658, 1259,  272, 1257,  619,  151, 2157,  153,   64, 1689,
 /*  1230 */   773,  225, 1241,   15,   50,  692,  266, 2158, 2107,  261,
 /*  1240 */   684, 2139,  151,  153,  405, 2021, 1616, 1778, 2138, 1955,
 /*  1250 */   136,  685, 2174, 1581,  151,  333, 2140,  688, 2142, 2143,
 /*  1260 */   683, 2257,  678,  636, 1783,  650, 1442,  644,  768, 1597,
 /*  1270 */  1598, 2138,  289,  660,  274, 2174,  639, 2157,  110, 2140,
 /*  1280 */   688, 2142, 2143,  683,  293,  678, 1324, 1632,  271, 2107,
 /*  1290 */  2318,  684, 2227,  309, 1351,    1,  388, 2223,    5, 1570,
 /*  1300 */  1580, 1355, 1362,  408, 1526, 1596, 1599,   55,  413, 1360,
 /*  1310 */   355, 1465,  304,  156,  197,  442, 1542, 2022,  446, 1515,
 /*  1320 */   479, 1513, 2138,  451, 1537,  464, 2174, 2014,  471,  169,
 /*  1330 */  2140,  688, 2142, 2143,  683,  478,  678,  480,  489,  487,
 /*  1340 */   490,  201,  492,  202, 1525,  493,  204,  495, 1518, 1519,
 /*  1350 */   497, 1569, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579,
 /*  1360 */   680,  676, 1588, 1589, 1591, 1592, 1593, 1594,    2, 2139,
 /*  1370 */  2265, 1543,  512,    4,  513,  520, 1545,  521,  212,  685,
 /*  1380 */   523, 2261, 1540,  214, 1544,  525,  524, 1546,  526,  217,
 /*  1390 */   528,  532,  219, 1210,  551,   85, 2139,   86,  553, 1905,
 /*  1400 */   549,  550,  223,  229,  345, 2157,  685, 2083, 2274,  590,
 /*  1410 */   112,  592,   89, 2080,  596,  305,  595, 2107,  149,  684,
 /*  1420 */   246,  597,  248,  250, 1901,  231,  158,  159, 1472, 1903,
 /*  1430 */  1899,  160, 2157,  601,  603,  161, 2273, 2272,  620,  658,
 /*  1440 */   629, 2249,    8, 2321, 2107,  611,  684,  173,  265,  267,
 /*  1450 */  2138, 2079,  610,  268, 2174,  640,  600,  110, 2140,  688,
 /*  1460 */  2142, 2143,  683,  616,  678, 2258,  609, 2268, 2139, 2318,
 /*  1470 */   377, 2227,  623,  257,  608,  388, 2223, 2138,  685,  260,
 /*  1480 */   613, 2174,  378, 2297,  110, 2140,  688, 2142, 2143,  683,
 /*  1490 */   637,  678,  273, 1658,  139, 1541, 2318,  270, 2227,  648,
 /*  1500 */  2139,  279,  388, 2223, 2157,  381, 2243,   96, 1547, 2027,
 /*  1510 */   685,  656, 2292,  306,  307,  657, 2107, 2041,  684,  661,
 /*  1520 */    61, 2040, 2039,  384,  662, 1916,   98,  308, 2139,  100,
 /*  1530 */   102, 2208,  769,  269,  335, 1959, 2157,  300,  685,  690,
 /*  1540 */  2246,  311,  772, 1878,  347,  770,   53,  348, 2107, 2138,
 /*  1550 */   684, 2099,  315, 2174,  320, 2098,  110, 2140,  688, 2142,
 /*  1560 */  2143,  683,  313,  678, 2157,  334,  324, 2097, 2318,   78,
 /*  1570 */  2227, 2094,  410, 1505,  388, 2223, 2107, 1506,  684,  411,
 /*  1580 */   190, 2138,  415, 2092,  417, 2174,  419,  418,  110, 2140,
 /*  1590 */   688, 2142, 2143,  683, 2091,  678,  356, 2089,  423, 2088,
 /*  1600 */  2318, 2087, 2227,  425,  391,  390,  388, 2223,  427, 2138,
 /*  1610 */    79, 1468, 1467, 2174, 1528, 2053,  110, 2140,  688, 2142,
 /*  1620 */  2143,  683,  594,  678, 2052, 1595, 2139, 1521, 2318, 2051,
 /*  1630 */  2227,  434,  435, 2050,  388, 2223,  685, 2049, 1419, 2005,
 /*  1640 */   776, 2004, 2002, 2001,  145, 2000, 2003, 1999, 1998, 1996,
 /*  1650 */  1995, 1994,  195, 1590,  303,  452, 1993,  454, 2007, 1992,
 /*  1660 */  1991, 1990, 2157,  482,  147, 1977, 1520, 1989, 1988, 1987,
 /*  1670 */   176, 1986, 1985, 1984, 2107, 1983,  684,  766,  762,  758,
 /*  1680 */   754, 1982,  301, 1981, 1980, 1979, 1978, 1976, 1975, 2006,
 /*  1690 */  1974,  674, 1421, 1972, 1971, 1970, 1969, 1968, 2139, 1973,
 /*  1700 */  1295,  343, 1299,  344, 1820,  203, 1819, 2138,  685, 1291,
 /*  1710 */  1818, 2174, 1816,  205,  110, 2140,  688, 2142, 2143,  683,
 /*  1720 */  1813,  678,  108,  206, 1812,  294,  671, 1805, 2227, 1795,
 /*  1730 */   500,  499,  388, 2223, 2157,  498,  502, 1773,  506, 1191,
 /*  1740 */  1772,  504,  510, 2070, 2060, 2048, 2107,  503,  684,  218,
 /*  1750 */   508,  208,   76, 2047,  507, 2127,   77,  664,  178,  210,
 /*  1760 */   216, 2025,  179,  518, 1894, 1815, 1811,  533, 1809,  535,
 /*  1770 */   537,  534,  538,  539, 1807,  543,  541,  542, 1804, 2138,
 /*  1780 */  1529,  545, 1524, 2174, 1790, 1789,  111, 2140,  688, 2142,
 /*  1790 */  2143,  683,  281,  678, 1233,  547, 2139,  280,  546, 1769,
 /*  1800 */  2227, 1366, 1367, 1895, 2226, 2223,  685, 1896, 1282, 1532,
 /*  1810 */  1534, 1280, 1278,  741,  743, 1277, 1276,  247, 1275, 1269,
 /*  1820 */  2139, 1274,  676, 1588, 1589, 1591, 1592, 1593, 1594,   63,
 /*  1830 */   685, 1271, 2157, 1270, 1802, 1268,  368, 1794,  369, 1792,
 /*  1840 */   228,  574,  370,  577, 2107, 1768,  684,  579, 1767, 1766,
 /*  1850 */   581,  583,  113, 1496, 1492, 2069, 2157, 1494, 1491,   29,
 /*  1860 */    67, 1478, 1474, 1476, 2059,  598, 2046,  163, 2107, 2044,
 /*  1870 */   684, 2303,   20,   31,   17, 1706,   23, 2138,    6,    7,
 /*  1880 */    21, 2174,  612,   65,  111, 2140,  688, 2142, 2143,  683,
 /*  1890 */   614,  678,  258,  256, 2139,   22, 1688,  171, 2227,  264,
 /*  1900 */   263,  686,  673, 2223,  685, 2174,  262,   32,  111, 2140,
 /*  1910 */   688, 2142, 2143,  683, 2139,  678,  604,   58,  599, 2128,
 /*  1920 */  1680,   24, 2227,  251,  685,  374,  350, 2223,   92, 1721,
 /*  1930 */  2157,   33, 1720,  379, 1725,   18, 1726,  276, 1727, 1724,
 /*  1940 */   380, 1655, 2107, 1654,  684,   60, 2045,  174, 2043, 2042,
 /*  1950 */  2157, 2024,   94,   95,  282,   25, 2023,  283,   97,  103,
 /*  1960 */  1686,  285, 2107,  290,  684,   68,   26,  659,  295,   99,
 /*  1970 */  1607, 1606,   11,  292,   13, 2138, 1530, 1617, 2177, 2174,
 /*  1980 */   175, 1585,  169, 2140,  688, 2142, 2143,  683,  677,  678,
 /*  1990 */    59, 1583, 1582,   39,   16, 2138, 1554,   27, 2139, 2174,
 /*  2000 */   188, 1562,  170, 2140,  688, 2142, 2143,  683,  685,  678,
 /*  2010 */    28,  691, 1352,  396,  693,  695,  689,  698,  701, 1349,
 /*  2020 */   696,  704,  607, 2264, 1361,  687, 1346, 2139,  699,  298,
 /*  2030 */  1340,  702, 1357, 1338, 2157, 1344,  705,  685,  104,  105,
 /*  2040 */    75, 1343, 1231, 1265, 1342, 1289, 2107, 1264,  684, 1341,
 /*  2050 */  1263,  719, 1262,  633, 2319, 1261, 1260, 1258, 1256, 1255,
 /*  2060 */  1254,  731,  299, 2157, 1252, 1251, 1250, 1249,  376, 1248,
 /*  2070 */  1247, 1246, 1286, 1284, 1243, 2107, 1242,  684, 1239, 2138,
 /*  2080 */  1237, 1238, 1236, 2174, 1810,  751,  111, 2140,  688, 2142,
 /*  2090 */  2143,  683,  753,  678, 1808,  755,  757,  752,  756, 1806,
 /*  2100 */  2227,  759,  761,  760, 1803, 2224,  763,  765, 2138, 1788,
 /*  2110 */   764,  767, 2174, 1181, 1765,  333, 2140,  688, 2142, 2143,
 /*  2120 */   683,  771,  678, 2139,  302, 1516, 1740,  312,  774, 1740,
 /*  2130 */   775, 1740, 1740,  685, 1740, 1740, 2139, 1740, 1740, 1740,
 /*  2140 */  1740, 1740, 1740, 1740, 1740, 1740,  685, 1740, 1740, 1740,
 /*  2150 */  1740, 1740, 1740, 2139, 1740, 1740, 1740, 1740, 1740, 2157,
 /*  2160 */  1740, 1740, 1740,  685, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2170 */  1740, 2107, 2157,  684, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2180 */  1740, 1740, 1740, 1740, 2107, 1740,  684, 1740, 1740, 2157,
 /*  2190 */  1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2200 */  1740, 2107, 1740,  684, 2138, 1740, 1740, 1740, 2174, 1740,
 /*  2210 */  1740,  326, 2140,  688, 2142, 2143,  683, 2138,  678, 1740,
 /*  2220 */  2139, 2174, 1740, 1740,  170, 2140,  688, 2142, 2143,  683,
 /*  2230 */   685,  678, 1740, 1740,  589, 1740, 1740, 2139, 2174, 1740,
 /*  2240 */  1740,  328, 2140,  688, 2142, 2143,  683,  682,  678, 1740,
 /*  2250 */  2139, 1740, 1740, 1740,  628, 1740, 2157, 1740, 1740, 1740,
 /*  2260 */   685,  383, 1740, 1740, 1740, 1740, 1740, 1740, 2107, 1740,
 /*  2270 */   684, 1740, 1740, 2157, 1740, 1740, 2320, 1740, 1740, 1740,
 /*  2280 */  1740, 1740, 1740, 1740, 1740, 2107, 2157,  684, 1740, 1740,
 /*  2290 */  1740,  393, 1740, 1740, 1740, 1740, 1740, 1740, 2107, 1740,
 /*  2300 */   684, 2138, 1740, 1740, 1740, 2174, 1740, 1740,  333, 2140,
 /*  2310 */   688, 2142, 2143,  683, 1740,  678, 1740, 1740, 2138, 1740,
 /*  2320 */  1740, 1740, 2174, 2139, 1740,  332, 2140,  688, 2142, 2143,
 /*  2330 */   683, 2138,  678,  685, 2193, 2174, 1740, 1740,  333, 2140,
 /*  2340 */   688, 2142, 2143,  683, 2139,  678, 1740, 1740, 1740, 1740,
 /*  2350 */  1740, 1740, 1740, 1740,  685, 1740, 1740, 1740, 1740, 2157,
 /*  2360 */  1740, 1740, 1740, 1740,  395, 1740, 1740, 1740, 1740, 1740,
 /*  2370 */  1740, 2107, 1740,  684, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2380 */  2157, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2390 */  2139, 1740, 2107, 1740,  684, 1740, 1740, 1740, 1740, 1740,
 /*  2400 */   685, 1740, 1740, 1740, 2138, 1740, 1740, 1740, 2174, 1740,
 /*  2410 */  1740,  333, 2140,  688, 2142, 2143,  683, 1740,  678, 1740,
 /*  2420 */  1740, 1740, 1740, 1740, 1740, 2138, 2157, 1740, 1740, 2174,
 /*  2430 */  1740, 1740,  317, 2140,  688, 2142, 2143,  683, 2107,  678,
 /*  2440 */   684, 2139, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2450 */  1740,  685, 1740, 1740, 2139, 1740, 1740, 1740, 1740, 1740,
 /*  2460 */  1740, 1740, 1740, 1740,  685, 1740, 1740, 1740, 1740, 1740,
 /*  2470 */  1740, 2138, 1740, 1740, 1740, 2174, 1740, 2157,  318, 2140,
 /*  2480 */   688, 2142, 2143,  683, 1740,  678, 1740, 1740, 1740, 2107,
 /*  2490 */  2157,  684, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2500 */  1740, 1740, 2107, 1740,  684, 1740, 1740, 1740, 1740, 1740,
 /*  2510 */  1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2520 */  1740, 1740, 2138, 1740, 1740, 1740, 2174, 1740, 1740,  319,
 /*  2530 */  2140,  688, 2142, 2143,  683, 2138,  678, 1740, 1740, 2174,
 /*  2540 */  2139, 1740,  325, 2140,  688, 2142, 2143,  683, 1740,  678,
 /*  2550 */   685, 1740, 1740, 2139, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2560 */  1740, 1740, 1740,  685, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2570 */  2139, 1740, 1740, 1740, 1740, 1740, 2157, 1740, 1740, 1740,
 /*  2580 */   685, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 2107, 2157,
 /*  2590 */   684, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2600 */  1740, 2107, 1740,  684, 2139, 1740, 2157, 1740, 1740, 1740,
 /*  2610 */  1740, 1740, 1740, 1740,  685, 1740, 1740, 1740, 2107, 1740,
 /*  2620 */   684, 2138, 1740, 1740, 1740, 2174, 1740, 1740,  329, 2140,
 /*  2630 */   688, 2142, 2143,  683, 2138,  678, 1740, 1740, 2174, 1740,
 /*  2640 */  2157,  321, 2140,  688, 2142, 2143,  683, 1740,  678, 1740,
 /*  2650 */  1740, 2138, 2107, 1740,  684, 2174, 1740, 1740,  330, 2140,
 /*  2660 */   688, 2142, 2143,  683, 2139,  678, 1740, 1740, 1740, 1740,
 /*  2670 */  1740, 1740, 1740, 1740,  685, 1740, 1740, 2139, 1740, 1740,
 /*  2680 */  1740, 1740, 1740, 1740, 1740, 2138, 1740,  685, 1740, 2174,
 /*  2690 */  1740, 1740,  322, 2140,  688, 2142, 2143,  683, 1740,  678,
 /*  2700 */  2157, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2710 */  1740, 1740, 2107, 2157,  684, 1740, 1740, 1740, 1740, 1740,
 /*  2720 */  1740, 1740, 1740, 1740, 1740, 2107, 1740,  684, 2139, 1740,
 /*  2730 */  1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,  685, 1740,
 /*  2740 */  1740, 1740, 1740, 1740, 1740, 2138, 1740, 1740, 1740, 2174,
 /*  2750 */  2139, 1740,  331, 2140,  688, 2142, 2143,  683, 2138,  678,
 /*  2760 */   685, 1740, 2174, 1740, 2157,  323, 2140,  688, 2142, 2143,
 /*  2770 */   683, 1740,  678, 1740, 2139, 1740, 2107, 1740,  684, 1740,
 /*  2780 */  1740, 1740, 1740, 1740,  685, 1740, 2157, 1740, 1740, 1740,
 /*  2790 */  1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 2107, 1740,
 /*  2800 */   684, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 2138,
 /*  2810 */  2157, 1740, 1740, 2174, 1740, 1740,  336, 2140,  688, 2142,
 /*  2820 */  2143,  683, 2107,  678,  684, 1740, 1740, 1740, 1740, 1740,
 /*  2830 */  1740, 2138, 1740, 1740, 1740, 2174, 1740, 1740,  337, 2140,
 /*  2840 */   688, 2142, 2143,  683, 1740,  678, 1740, 1740, 1740, 1740,
 /*  2850 */  1740, 1740, 1740, 1740, 1740, 2138, 1740, 1740, 2139, 2174,
 /*  2860 */  1740, 1740, 2151, 2140,  688, 2142, 2143,  683,  685,  678,
 /*  2870 */  1740, 2139, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2880 */  1740,  685, 1740, 1740, 1740, 1740, 2139, 1740, 1740, 1740,
 /*  2890 */  1740, 1740, 1740, 1740, 2157, 1740,  685, 1740, 1740, 1740,
 /*  2900 */  1740, 1740, 1740, 1740, 1740, 1740, 2107, 2157,  684, 1740,
 /*  2910 */  1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 2107,
 /*  2920 */  1740,  684, 2157, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2930 */  1740, 1740, 1740, 1740, 2107, 1740,  684, 1740, 1740, 2138,
 /*  2940 */  1740, 1740, 1740, 2174, 1740, 1740, 2150, 2140,  688, 2142,
 /*  2950 */  2143,  683, 2138,  678, 1740, 1740, 2174, 1740, 1740, 2149,
 /*  2960 */  2140,  688, 2142, 2143,  683, 1740,  678, 2138, 1740, 1740,
 /*  2970 */  2139, 2174, 1740, 1740,  352, 2140,  688, 2142, 2143,  683,
 /*  2980 */   685,  678, 1740, 1740, 1740, 1740, 1740, 2139, 1740, 1740,
 /*  2990 */  1740, 1740, 1740, 1740, 1740, 1740, 1740,  685, 1740, 1740,
 /*  3000 */  2139, 1740, 1740, 1740, 1740, 1740, 2157, 1740, 1740, 1740,
 /*  3010 */   685, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 2107, 1740,
 /*  3020 */   684, 2139, 1740, 2157, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  3030 */  1740,  685, 1740, 1740, 1740, 2107, 2157,  684, 1740, 1740,
 /*  3040 */  1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 2107, 1740,
 /*  3050 */   684, 2138, 1740, 1740, 1740, 2174, 1740, 2157,  353, 2140,
 /*  3060 */   688, 2142, 2143,  683, 1740,  678, 1740, 1740, 2138, 2107,
 /*  3070 */  1740,  684, 2174, 1740, 1740,  349, 2140,  688, 2142, 2143,
 /*  3080 */   683, 2138,  678, 1740, 1740, 2174, 2139, 1740,  354, 2140,
 /*  3090 */   688, 2142, 2143,  683, 1740,  678,  685, 1740, 1740, 1740,
 /*  3100 */  1740, 1740,  686, 1740, 1740, 1740, 2174, 1740, 1740,  328,
 /*  3110 */  2140,  688, 2142, 2143,  683, 1740,  678, 1740, 1740, 1740,
 /*  3120 */  1740, 1740, 2157, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  3130 */  1740, 1740, 1740, 1740, 2107, 1740,  684, 1740, 1740, 1740,
 /*  3140 */  1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  3150 */  1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  3160 */  1740, 1740, 1740, 1740, 1740, 1740, 1740, 2138, 1740, 1740,
 /*  3170 */  1740, 2174, 1740, 1740,  327, 2140,  688, 2142, 2143,  683,
 /*  3180 */  1740,  678,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   335,  335,  449,  339,  353,  452,  342,  343,  438,  439,
 /*    10 */   345,  360,   12,   13,   14,   12,   13,   14,   15,   16,
 /*    20 */    20,  468,   22,    8,    9,  472,  473,   12,   13,   14,
 /*    30 */    15,   16,   14,   33,    0,   35,  371,  344,   20,  363,
 /*    40 */    14,  339,  344,  345,  342,  343,   20,  371,  383,  383,
 /*    50 */   385,  345,    8,    9,  378,  379,   12,   13,   14,   15,
 /*    60 */    16,   61,  386,  385,   20,    8,    9,   67,   20,   12,
 /*    70 */    13,   14,   15,   16,   74,  397,   20,  371,  400,  401,
 /*    80 */   387,  416,   44,  344,  345,  420,  357,  358,  423,  424,
 /*    90 */   425,  426,  427,  428,  429,  430,  431,  432,  334,   99,
 /*   100 */   336,  362,  102,   69,   70,   71,   72,   73,  369,   75,
 /*   110 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   120 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   130 */   449,  425,  350,  452,  344,  345,   66,   20,  138,  139,
 /*   140 */    20,  103,   22,  445,  446,  447,   20,  449,  450,  468,
 /*   150 */   452,  370,  362,  472,  473,   35,  374,   18,  102,  369,
 /*   160 */   103,   20,   23,  382,  102,  467,  468,  335,  168,  169,
 /*   170 */   472,  473,    3,   53,  174,  175,   37,   38,    8,    9,
 /*   180 */    41,    0,   12,   13,   14,   15,   16,   20,  188,   20,
 /*   190 */   190,   52,    8,    9,  168,  180,   12,   13,   14,   15,
 /*   200 */    16,   62,   63,   64,   65,   24,   25,   26,   27,   28,
 /*   210 */    29,   30,   31,   32,  170,  383,  173,  217,  218,    0,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,  233,  234,  235,  236,  237,   12,   13,
 /*   240 */    22,  102,    4,   18,  433,   20,   20,  436,   22,  187,
 /*   250 */    20,  189,   27,   35,   83,   30,  344,  345,   33,   33,
 /*   260 */    21,   35,  371,   24,   25,   26,   27,   28,   29,   30,
 /*   270 */    31,   32,  103,  103,   49,  350,   51,  386,  216,  140,
 /*   280 */    55,   43,  217,   45,   46,  168,  169,   61,   69,   70,
 /*   290 */    71,  366,   74,   67,  279,   76,   77,   78,  371,  374,
 /*   300 */    74,   82,  259,  260,  261,  378,   87,   88,   89,   90,
 /*   310 */   254,  170,   93,  386,  143,  144,  254,   99,   66,  180,
 /*   320 */   181,  182,   20,   61,  185,   99,  101,  385,  102,  264,
 /*   330 */   265,  266,  267,  268,  269,  270,   20,  166,  113,  170,
 /*   340 */   384,  385,  400,  401,    4,  206,  357,  358,  209,   20,
 /*   350 */   373,  212,  213,  214,  215,  216,  444,  445,  446,  447,
 /*   360 */   383,  449,  450,  101,  138,  139,  104,  142,   61,   20,
 /*   370 */   145,  146,  147,  148,  149,  150,  151,  152,  153,  154,
 /*   380 */   155,  156,  157,  158,  159,  160,  161,  352,  163,  164,
 /*   390 */   165,   45,   46,  254,  168,  169,  419,  420,  421,   20,
 /*   400 */   174,  175,  449,  368,  102,  452,  188,  430,  190,  102,
 /*   410 */    20,  104,  377,  133,  188,   47,  190,  137,  102,  422,
 /*   420 */   467,  468,  102,    8,    9,  472,  473,   12,   13,   14,
 /*   430 */    15,   16,  112,    8,    9,  217,  218,   12,   13,   14,
 /*   440 */    15,   16,  102,  217,  218,  448,  220,  221,  222,  223,
 /*   450 */   224,  225,  226,  227,  228,  229,  230,  231,  232,  233,
 /*   460 */   234,  235,  236,  237,  238,   12,   13,  138,  139,   44,
 /*   470 */   102,  344,    0,   20,   99,   22,  381,  197,  198,  384,
 /*   480 */   385,  201,   67,  203,   20,   35,   33,  371,   35,  114,
 /*   490 */   115,  116,  117,  118,  119,  120,  121,  122,  123,  102,
 /*   500 */   125,  126,  127,  128,  129,  130,  183,  391,  392,   33,
 /*   510 */   344,  345,  335,  380,   61,    0,  383,  138,  139,  344,
 /*   520 */    67,  394,  345,  396,   74,   49,  111,   74,  362,  371,
 /*   530 */   207,  208,   56,   57,   58,   59,   21,   61,  344,   24,
 /*   540 */    25,   26,   27,   28,   29,   30,   31,   32,  371,  373,
 /*   550 */   392,   14,   99,  174,  175,  102,  254,   20,  168,  383,
 /*   560 */   383,  254,  385,  102,  340,   69,   70,   71,  344,  394,
 /*   570 */   346,  396,   76,   77,   78,  340,  335,  101,   82,  344,
 /*   580 */   104,  346,  167,   87,   88,   89,   90,    0,  394,   93,
 /*   590 */   396,  138,  139,  416,  254,  419,  420,  420,  344,  345,
 /*   600 */   423,  424,  425,  426,  427,  428,  430,  430,  371,  363,
 /*   610 */   113,   20,  435,   22,  437,  378,  362,  371,  441,  442,
 /*   620 */   422,  168,  169,  386,  383,  379,  332,  174,  175,  157,
 /*   630 */   371,  454,  344,  345,  170,  344,  345,  378,  166,  462,
 /*   640 */     0,  188,  238,  190,   53,  386,  448,  171,  172,  335,
 /*   650 */   362,  254,  176,  362,  178,    3,  241,  242,  243,  244,
 /*   660 */   245,  246,  247,  248,  249,  250,  251,   14,   15,   16,
 /*   670 */   217,  218,  196,  220,  221,  222,  223,  224,  225,  226,
 /*   680 */   227,  228,  229,  230,  231,  232,  233,  234,  235,  236,
 /*   690 */   237,   12,   13,   14,   21,   74,  402,  383,  402,   20,
 /*   700 */   406,   22,  406,  373,  335,  168,  335,   34,  449,   36,
 /*   710 */   371,  452,   33,  383,   35,  254,  345,  378,  131,  132,
 /*   720 */   133,  134,  135,  136,  137,  386,  467,  468,   22,    8,
 /*   730 */     9,  472,  473,   12,   13,   14,   15,   16,   20,  363,
 /*   740 */    61,   35,  371,  449,  371,  449,  452,  371,  452,  419,
 /*   750 */   420,  378,  383,   74,  383,  379,  385,   22,    0,  386,
 /*   760 */   430,  467,  468,  467,  468,  345,  472,  473,  472,  473,
 /*   770 */    35,  131,  132,  133,  134,  135,  136,  137,   99,   49,
 /*   780 */   238,  102,  240,  335,  363,  402,   56,  416,  113,   59,
 /*   790 */    60,  420,  371,  345,  423,  424,  425,  426,  427,  428,
 /*   800 */   379,  430,  344,  345,  433,   99,  435,  436,  437,  389,
 /*   810 */    14,   44,  441,  442,  132,    2,   20,  138,  139,  371,
 /*   820 */   362,    8,    9,  422,   66,   12,   13,   14,   15,   16,
 /*   830 */     2,  383,  449,  385,   99,  452,    8,    9,  335,  335,
 /*   840 */    12,   13,   14,   15,   16,  344,  345,  168,  169,  448,
 /*   850 */   467,  468,   61,  174,  175,  472,  473,    1,    2,    0,
 /*   860 */   132,  133,  344,  345,  416,  137,    4,  188,  420,  190,
 /*   870 */   103,  423,  424,  425,  426,  427,  428,  434,  430,  436,
 /*   880 */   362,  199,  200,  435,  335,  437,  383,  383,  170,  441,
 /*   890 */   442,  170,  402,  335,   74,  104,  217,  218,  167,  220,
 /*   900 */   221,  222,  223,  224,  225,  226,  227,  228,  229,  230,
 /*   910 */   231,  232,  233,  234,  235,  236,  237,   12,   13,  352,
 /*   920 */     4,  371,  434,  402,  436,   20,  274,   22,  335,  379,
 /*   930 */   345,  345,  383,  335,  372,   19,  344,  345,   33,  449,
 /*   940 */    35,  383,  452,  345,  377,  402,  445,  446,  447,   33,
 /*   950 */   449,  450,  372,  380,  362,  335,  383,  467,  468,  103,
 /*   960 */   252,  253,  472,  473,  335,   49,   61,  344,  345,  371,
 /*   970 */   449,   55,  241,  452,  389,  389,  383,   61,   37,   74,
 /*   980 */   367,  383,  251,  385,  335,  362,  344,  345,  467,  468,
 /*   990 */   344,  345,  449,  472,  473,  452,  131,  132,  133,  134,
 /*  1000 */   135,  136,  137,  383,   99,  335,   39,  102,  362,  335,
 /*  1010 */   467,  468,  383,  335,  416,  472,  473,  101,  420,  345,
 /*  1020 */   104,  423,  424,  425,  426,  427,  428,  414,  430,  344,
 /*  1030 */   345,   44,  383,  435,  335,  437,  344,  345,  380,  441,
 /*  1040 */   442,  383,   44,  138,  139,  371,  105,  362,  107,  108,
 /*  1050 */   359,  110,  361,  383,  362,  335,   42,  383,   44,  385,
 /*  1060 */   462,  383,  335,  344,  345,    0,  344,  345,  344,  345,
 /*  1070 */   211,  335,  131,  168,  169,  364,  135,    0,  367,  174,
 /*  1080 */   175,  362,  383,   42,  362,   44,  362,  445,  446,  447,
 /*  1090 */   416,  449,  450,  188,  420,  190,   67,  423,  424,  425,
 /*  1100 */   426,  427,  428,  383,  430,   22,  344,  345,  131,  435,
 /*  1110 */   383,  437,  135,  113,   49,  441,  442,  255,   35,  383,
 /*  1120 */    44,   44,  217,  218,  362,  220,  221,  222,  223,  224,
 /*  1130 */   225,  226,  227,  228,  229,  230,  231,  232,  233,  234,
 /*  1140 */   235,  236,  237,   12,   13,  344,  345,  344,  345,   35,
 /*  1150 */    44,   20,  106,   22,  106,  109,   13,  109,  344,  345,
 /*  1160 */    13,    0,  162,  362,   33,  362,   35,  335,  106,  106,
 /*  1170 */    44,  109,  109,    0,    0,  407,  362,  345,   35,  103,
 /*  1180 */    44,  372,   35,   22,  202,   48,  204,  138,  139,   35,
 /*  1190 */   335,  372,   61,   35,   44,   22,   22,    1,    2,   13,
 /*  1200 */   345,   13,  347,  371,  360,   74,   44,   44,  376,  103,
 /*  1210 */   372,  372,  372,   44,   44,  383,  336,  385,    0,  393,
 /*  1220 */   253,   35,  476,   35,  465,   44,  371,   44,   44,  103,
 /*  1230 */    99,  348,   74,  102,   44,   44,  459,  371,  383,  103,
 /*  1240 */   385,  335,   44,   44,  348,  393,  217,  343,  416,  382,
 /*  1250 */    44,  345,  420,  103,   44,  423,  424,  425,  426,  427,
 /*  1260 */   428,  393,  430,  276,  345,  103,  103,  451,   50,  138,
 /*  1270 */   139,  416,  103,  103,  469,  420,  278,  371,  423,  424,
 /*  1280 */   425,  426,  427,  428,  103,  430,  103,  103,  443,  383,
 /*  1290 */   435,  385,  437,  103,  103,  453,  441,  442,  256,  168,
 /*  1300 */   169,  103,  103,  418,  190,  174,  175,  170,   49,  103,
 /*  1310 */   417,  186,  404,  103,   42,  390,   20,  393,  390,  188,
 /*  1320 */   167,  190,  416,  388,   20,  344,  420,  344,  390,  423,
 /*  1330 */   424,  425,  426,  427,  428,  388,  430,  388,  100,   98,
 /*  1340 */   356,  355,   97,  344,  190,  354,  344,  344,  217,  218,
 /*  1350 */   344,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*  1360 */   229,  230,  231,  232,  233,  234,  235,  236,  237,  335,
 /*  1370 */   464,   20,  337,   48,  341,  337,   20,  341,  352,  345,
 /*  1380 */   411,  347,   20,  352,   20,  346,  385,   20,  403,  352,
 /*  1390 */   346,  344,  352,   54,  337,  352,  335,  352,  371,  371,
 /*  1400 */   349,  349,  352,  371,  337,  371,  345,  383,  347,  205,
 /*  1410 */   344,  415,  102,  383,  194,  411,  193,  383,  413,  385,
 /*  1420 */   350,  410,  409,  350,  371,  371,  371,  371,  192,  371,
 /*  1430 */   371,  371,  371,  408,  344,  371,  458,  458,  263,  262,
 /*  1440 */   179,  461,  271,  477,  383,  273,  385,  458,  460,  457,
 /*  1450 */   416,  383,  383,  456,  420,  277,  385,  423,  424,  425,
 /*  1460 */   426,  427,  428,  383,  430,  393,  272,  393,  335,  435,
 /*  1470 */   383,  437,  383,  398,  257,  441,  442,  416,  345,  398,
 /*  1480 */   347,  420,  280,  471,  423,  424,  425,  426,  427,  428,
 /*  1490 */   275,  430,  470,  253,  345,   20,  435,  418,  437,  344,
 /*  1500 */   335,  350,  441,  442,  371,  346,  422,  350,   20,  396,
 /*  1510 */   345,  383,  347,  398,  398,  383,  383,  383,  385,  172,
 /*  1520 */   102,  383,  383,  383,  395,  345,  350,  367,  335,  350,
 /*  1530 */   102,  440,   36,  455,  412,  383,  371,  350,  345,  375,
 /*  1540 */   347,  344,  337,  361,  399,  338,  405,  399,  383,  416,
 /*  1550 */   385,    0,  333,  420,  365,    0,  423,  424,  425,  426,
 /*  1560 */   427,  428,  351,  430,  371,  365,  365,    0,  435,   42,
 /*  1570 */   437,    0,   35,   35,  441,  442,  383,   35,  385,  210,
 /*  1580 */    35,  416,  210,    0,   35,  420,  210,   35,  423,  424,
 /*  1590 */   425,  426,  427,  428,    0,  430,  210,    0,   35,    0,
 /*  1600 */   435,    0,  437,   22,   12,   13,  441,  442,   35,  416,
 /*  1610 */   197,  190,  188,  420,   22,    0,  423,  424,  425,  426,
 /*  1620 */   427,  428,    1,  430,    0,   33,  335,   35,  435,    0,
 /*  1630 */   437,  184,  183,    0,  441,  442,  345,    0,   47,    0,
 /*  1640 */    19,    0,    0,    0,   42,    0,    0,    0,    0,    0,
 /*  1650 */     0,    0,  157,   61,   33,   35,    0,  157,    0,    0,
 /*  1660 */     0,    0,  371,  141,   42,    0,   74,    0,    0,    0,
 /*  1670 */    49,    0,    0,    0,  383,    0,  385,   56,   57,   58,
 /*  1680 */    59,    0,   61,    0,    0,    0,    0,    0,    0,    0,
 /*  1690 */     0,   99,   22,    0,    0,    0,    0,    0,  335,    0,
 /*  1700 */    22,   48,   22,   48,    0,   61,    0,  416,  345,   35,
 /*  1710 */     0,  420,    0,   61,  423,  424,  425,  426,  427,  428,
 /*  1720 */     0,  430,  101,   61,    0,  104,  435,    0,  437,    0,
 /*  1730 */    39,   49,  441,  442,  371,   35,   35,    0,   35,   14,
 /*  1740 */     0,   39,   35,    0,    0,    0,  383,   49,  385,  179,
 /*  1750 */    39,   42,   39,    0,   49,   47,   39,  136,   44,   40,
 /*  1760 */    39,    0,   47,   47,    0,    0,    0,   35,    0,   39,
 /*  1770 */    35,   49,   49,   39,    0,   39,   35,   49,    0,  416,
 /*  1780 */   188,   35,  190,  420,    0,    0,  423,  424,  425,  426,
 /*  1790 */   427,  428,  171,  430,   68,   39,  335,  176,   49,    0,
 /*  1800 */   437,   22,   35,    0,  441,  442,  345,    0,   35,  217,
 /*  1810 */   218,   35,   35,   44,   44,   35,   35,  196,   35,   22,
 /*  1820 */   335,   35,  230,  231,  232,  233,  234,  235,  236,  111,
 /*  1830 */   345,   35,  371,   35,    0,   35,   22,    0,   22,    0,
 /*  1840 */   109,   51,   22,   35,  383,    0,  385,   35,    0,    0,
 /*  1850 */    35,   22,   20,  103,   35,    0,  371,   35,   35,  102,
 /*  1860 */   102,  195,   35,   22,    0,   22,    0,  191,  383,    0,
 /*  1870 */   385,    3,   44,  102,  258,  103,  258,  416,   48,   48,
 /*  1880 */    44,  420,  100,    3,  423,  424,  425,  426,  427,  428,
 /*  1890 */    98,  430,  103,  102,  335,   44,  103,  102,  437,   47,
 /*  1900 */    44,  416,  441,  442,  345,  420,  102,  102,  423,  424,
 /*  1910 */   425,  426,  427,  428,  335,  430,  177,  170,  170,   47,
 /*  1920 */   103,   44,  437,  172,  345,  170,  441,  442,  102,   35,
 /*  1930 */   371,   44,   35,   35,   35,  258,  103,   47,  103,   35,
 /*  1940 */    35,  103,  383,  103,  385,   44,    0,   47,    0,    0,
 /*  1950 */   371,    0,  102,   39,   47,  102,    0,  103,   39,  112,
 /*  1960 */   103,  102,  383,  102,  385,  102,   44,  173,   47,  102,
 /*  1970 */   100,  100,  239,  171,    2,  416,   22,  217,  102,  420,
 /*  1980 */    47,  103,  423,  424,  425,  426,  427,  428,  102,  430,
 /*  1990 */   252,  103,  103,  102,  102,  416,  103,  102,  335,  420,
 /*  2000 */    47,   22,  423,  424,  425,  426,  427,  428,  345,  430,
 /*  2010 */   102,   35,  103,   35,  102,   35,  113,   35,   35,  103,
 /*  2020 */   102,   35,  463,  464,   35,  219,  103,  335,  102,   44,
 /*  2030 */   103,  102,   22,  103,  371,  124,  102,  345,  102,  102,
 /*  2040 */   102,  124,   68,   35,  124,   74,  383,   35,  385,  124,
 /*  2050 */    35,   67,   35,  474,  475,   35,   35,   35,   35,   35,
 /*  2060 */    35,   96,   44,  371,   35,   35,   35,   22,  376,   35,
 /*  2070 */    35,   35,   74,   35,   35,  383,   35,  385,   35,  416,
 /*  2080 */    22,   35,   35,  420,    0,   35,  423,  424,  425,  426,
 /*  2090 */   427,  428,   39,  430,    0,   35,   39,   49,   49,    0,
 /*  2100 */   437,   35,   39,   49,    0,  442,   35,   39,  416,    0,
 /*  2110 */    49,   35,  420,   35,    0,  423,  424,  425,  426,  427,
 /*  2120 */   428,   21,  430,  335,   22,   22,  478,   22,   21,  478,
 /*  2130 */    20,  478,  478,  345,  478,  478,  335,  478,  478,  478,
 /*  2140 */   478,  478,  478,  478,  478,  478,  345,  478,  478,  478,
 /*  2150 */   478,  478,  478,  335,  478,  478,  478,  478,  478,  371,
 /*  2160 */   478,  478,  478,  345,  478,  478,  478,  478,  478,  478,
 /*  2170 */   478,  383,  371,  385,  478,  478,  478,  478,  478,  478,
 /*  2180 */   478,  478,  478,  478,  383,  478,  385,  478,  478,  371,
 /*  2190 */   478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
 /*  2200 */   478,  383,  478,  385,  416,  478,  478,  478,  420,  478,
 /*  2210 */   478,  423,  424,  425,  426,  427,  428,  416,  430,  478,
 /*  2220 */   335,  420,  478,  478,  423,  424,  425,  426,  427,  428,
 /*  2230 */   345,  430,  478,  478,  416,  478,  478,  335,  420,  478,
 /*  2240 */   478,  423,  424,  425,  426,  427,  428,  345,  430,  478,
 /*  2250 */   335,  478,  478,  478,  466,  478,  371,  478,  478,  478,
 /*  2260 */   345,  376,  478,  478,  478,  478,  478,  478,  383,  478,
 /*  2270 */   385,  478,  478,  371,  478,  478,  475,  478,  478,  478,
 /*  2280 */   478,  478,  478,  478,  478,  383,  371,  385,  478,  478,
 /*  2290 */   478,  376,  478,  478,  478,  478,  478,  478,  383,  478,
 /*  2300 */   385,  416,  478,  478,  478,  420,  478,  478,  423,  424,
 /*  2310 */   425,  426,  427,  428,  478,  430,  478,  478,  416,  478,
 /*  2320 */   478,  478,  420,  335,  478,  423,  424,  425,  426,  427,
 /*  2330 */   428,  416,  430,  345,  432,  420,  478,  478,  423,  424,
 /*  2340 */   425,  426,  427,  428,  335,  430,  478,  478,  478,  478,
 /*  2350 */   478,  478,  478,  478,  345,  478,  478,  478,  478,  371,
 /*  2360 */   478,  478,  478,  478,  376,  478,  478,  478,  478,  478,
 /*  2370 */   478,  383,  478,  385,  478,  478,  478,  478,  478,  478,
 /*  2380 */   371,  478,  478,  478,  478,  478,  478,  478,  478,  478,
 /*  2390 */   335,  478,  383,  478,  385,  478,  478,  478,  478,  478,
 /*  2400 */   345,  478,  478,  478,  416,  478,  478,  478,  420,  478,
 /*  2410 */   478,  423,  424,  425,  426,  427,  428,  478,  430,  478,
 /*  2420 */   478,  478,  478,  478,  478,  416,  371,  478,  478,  420,
 /*  2430 */   478,  478,  423,  424,  425,  426,  427,  428,  383,  430,
 /*  2440 */   385,  335,  478,  478,  478,  478,  478,  478,  478,  478,
 /*  2450 */   478,  345,  478,  478,  335,  478,  478,  478,  478,  478,
 /*  2460 */   478,  478,  478,  478,  345,  478,  478,  478,  478,  478,
 /*  2470 */   478,  416,  478,  478,  478,  420,  478,  371,  423,  424,
 /*  2480 */   425,  426,  427,  428,  478,  430,  478,  478,  478,  383,
 /*  2490 */   371,  385,  478,  478,  478,  478,  478,  478,  478,  478,
 /*  2500 */   478,  478,  383,  478,  385,  478,  478,  478,  478,  478,
 /*  2510 */   478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
 /*  2520 */   478,  478,  416,  478,  478,  478,  420,  478,  478,  423,
 /*  2530 */   424,  425,  426,  427,  428,  416,  430,  478,  478,  420,
 /*  2540 */   335,  478,  423,  424,  425,  426,  427,  428,  478,  430,
 /*  2550 */   345,  478,  478,  335,  478,  478,  478,  478,  478,  478,
 /*  2560 */   478,  478,  478,  345,  478,  478,  478,  478,  478,  478,
 /*  2570 */   335,  478,  478,  478,  478,  478,  371,  478,  478,  478,
 /*  2580 */   345,  478,  478,  478,  478,  478,  478,  478,  383,  371,
 /*  2590 */   385,  478,  478,  478,  478,  478,  478,  478,  478,  478,
 /*  2600 */   478,  383,  478,  385,  335,  478,  371,  478,  478,  478,
 /*  2610 */   478,  478,  478,  478,  345,  478,  478,  478,  383,  478,
 /*  2620 */   385,  416,  478,  478,  478,  420,  478,  478,  423,  424,
 /*  2630 */   425,  426,  427,  428,  416,  430,  478,  478,  420,  478,
 /*  2640 */   371,  423,  424,  425,  426,  427,  428,  478,  430,  478,
 /*  2650 */   478,  416,  383,  478,  385,  420,  478,  478,  423,  424,
 /*  2660 */   425,  426,  427,  428,  335,  430,  478,  478,  478,  478,
 /*  2670 */   478,  478,  478,  478,  345,  478,  478,  335,  478,  478,
 /*  2680 */   478,  478,  478,  478,  478,  416,  478,  345,  478,  420,
 /*  2690 */   478,  478,  423,  424,  425,  426,  427,  428,  478,  430,
 /*  2700 */   371,  478,  478,  478,  478,  478,  478,  478,  478,  478,
 /*  2710 */   478,  478,  383,  371,  385,  478,  478,  478,  478,  478,
 /*  2720 */   478,  478,  478,  478,  478,  383,  478,  385,  335,  478,
 /*  2730 */   478,  478,  478,  478,  478,  478,  478,  478,  345,  478,
 /*  2740 */   478,  478,  478,  478,  478,  416,  478,  478,  478,  420,
 /*  2750 */   335,  478,  423,  424,  425,  426,  427,  428,  416,  430,
 /*  2760 */   345,  478,  420,  478,  371,  423,  424,  425,  426,  427,
 /*  2770 */   428,  478,  430,  478,  335,  478,  383,  478,  385,  478,
 /*  2780 */   478,  478,  478,  478,  345,  478,  371,  478,  478,  478,
 /*  2790 */   478,  478,  478,  478,  478,  478,  478,  478,  383,  478,
 /*  2800 */   385,  478,  478,  478,  478,  478,  478,  478,  478,  416,
 /*  2810 */   371,  478,  478,  420,  478,  478,  423,  424,  425,  426,
 /*  2820 */   427,  428,  383,  430,  385,  478,  478,  478,  478,  478,
 /*  2830 */   478,  416,  478,  478,  478,  420,  478,  478,  423,  424,
 /*  2840 */   425,  426,  427,  428,  478,  430,  478,  478,  478,  478,
 /*  2850 */   478,  478,  478,  478,  478,  416,  478,  478,  335,  420,
 /*  2860 */   478,  478,  423,  424,  425,  426,  427,  428,  345,  430,
 /*  2870 */   478,  335,  478,  478,  478,  478,  478,  478,  478,  478,
 /*  2880 */   478,  345,  478,  478,  478,  478,  335,  478,  478,  478,
 /*  2890 */   478,  478,  478,  478,  371,  478,  345,  478,  478,  478,
 /*  2900 */   478,  478,  478,  478,  478,  478,  383,  371,  385,  478,
 /*  2910 */   478,  478,  478,  478,  478,  478,  478,  478,  478,  383,
 /*  2920 */   478,  385,  371,  478,  478,  478,  478,  478,  478,  478,
 /*  2930 */   478,  478,  478,  478,  383,  478,  385,  478,  478,  416,
 /*  2940 */   478,  478,  478,  420,  478,  478,  423,  424,  425,  426,
 /*  2950 */   427,  428,  416,  430,  478,  478,  420,  478,  478,  423,
 /*  2960 */   424,  425,  426,  427,  428,  478,  430,  416,  478,  478,
 /*  2970 */   335,  420,  478,  478,  423,  424,  425,  426,  427,  428,
 /*  2980 */   345,  430,  478,  478,  478,  478,  478,  335,  478,  478,
 /*  2990 */   478,  478,  478,  478,  478,  478,  478,  345,  478,  478,
 /*  3000 */   335,  478,  478,  478,  478,  478,  371,  478,  478,  478,
 /*  3010 */   345,  478,  478,  478,  478,  478,  478,  478,  383,  478,
 /*  3020 */   385,  335,  478,  371,  478,  478,  478,  478,  478,  478,
 /*  3030 */   478,  345,  478,  478,  478,  383,  371,  385,  478,  478,
 /*  3040 */   478,  478,  478,  478,  478,  478,  478,  478,  383,  478,
 /*  3050 */   385,  416,  478,  478,  478,  420,  478,  371,  423,  424,
 /*  3060 */   425,  426,  427,  428,  478,  430,  478,  478,  416,  383,
 /*  3070 */   478,  385,  420,  478,  478,  423,  424,  425,  426,  427,
 /*  3080 */   428,  416,  430,  478,  478,  420,  335,  478,  423,  424,
 /*  3090 */   425,  426,  427,  428,  478,  430,  345,  478,  478,  478,
 /*  3100 */   478,  478,  416,  478,  478,  478,  420,  478,  478,  423,
 /*  3110 */   424,  425,  426,  427,  428,  478,  430,  478,  478,  478,
 /*  3120 */   478,  478,  371,  478,  478,  478,  478,  478,  478,  478,
 /*  3130 */   478,  478,  478,  478,  383,  478,  385,  478,  478,  478,
 /*  3140 */   478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
 /*  3150 */   478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
 /*  3160 */   478,  478,  478,  478,  478,  478,  478,  416,  478,  478,
 /*  3170 */   478,  420,  478,  478,  423,  424,  425,  426,  427,  428,
 /*  3180 */   478,  430,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3190 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3200 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3210 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3220 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3230 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3240 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3250 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3260 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3270 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3280 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3290 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3300 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3310 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3320 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3330 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3340 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3350 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3360 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3370 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3380 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3390 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3400 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3410 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3420 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3430 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3440 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3450 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3460 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3470 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3480 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3490 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3500 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3510 */   332,  332,  332,  332,
};
#define YY_SHIFT_COUNT    (776)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2114)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   139,    0,  226,    0,  453,  453,  453,  453,  453,  453,
 /*    10 */   453,  453,  453,  453,  453,  453,  679,  905,  905, 1131,
 /*    20 */   905,  905,  905,  905,  905,  905,  905,  905,  905,  905,
 /*    30 */   905,  905,  905,  905,  905,  905,  905,  905,  905,  905,
 /*    40 */   905,  905,  905,  905,  905,  905,  905,  905,  905,  905,
 /*    50 */   905,   56,  302,   62,  316,  307,  397,  461,  397,  316,
 /*    60 */   316, 1592,  397, 1592, 1592,  340,  397,   48,  379,  126,
 /*    70 */   126,  379,  238,  238,  117,  329,   18,   18,  126,  126,
 /*    80 */   126,  126,  126,  126,  126,  167,  126,  126,   70,   48,
 /*    90 */   126,  126,  230,  126,   48,  126,  167,  126,  167,   48,
 /*   100 */   126,  126,   48,  126,   48,   48,   48,  126,  252,  225,
 /*   110 */   415,  415,  496,  239,  218,  218,  218,  218,  218,  218,
 /*   120 */   218,  218,  218,  218,  218,  218,  218,  218,  218,  218,
 /*   130 */   218,  218,  218,  941,  169,  117,  329,  450,  141,  141,
 /*   140 */   141,  758,  542,  542,  450,  349,  349,  349,   70,  497,
 /*   150 */   404,   48,  621,   48,  621,  621,  675,  820,  375,  375,
 /*   160 */   375,  375,  375,  375,  375,  375, 1621,  219,  515,   44,
 /*   170 */    15,   65,  120,   43,   26,  537,  591,  464,  346,  796,
 /*   180 */   977,  718,  708,  967,  652,  708, 1014,  862,  390, 1042,
 /*   190 */  1259, 1125, 1272, 1296, 1272, 1153, 1304, 1304, 1272, 1153,
 /*   200 */  1153, 1238, 1241, 1304, 1245, 1304, 1304, 1304, 1351, 1325,
 /*   210 */  1351, 1325, 1356,   70, 1362,   70, 1364, 1367,   70, 1364,
 /*   220 */    70,   70,   70, 1304,   70, 1339, 1339, 1351,   48,   48,
 /*   230 */    48,   48,   48,   48,   48,   48,   48,   48,   48, 1304,
 /*   240 */  1351,  621,  621,  621, 1204, 1310, 1356,  252, 1220, 1223,
 /*   250 */  1362,  252, 1236, 1304, 1296, 1296,  621, 1175, 1177,  621,
 /*   260 */  1175, 1177,  621,  621,   48, 1171, 1261, 1175, 1172, 1194,
 /*   270 */  1217, 1042, 1202, 1178, 1215, 1240,  349, 1475, 1304, 1364,
 /*   280 */   252,  252, 1488, 1177,  621,  621,  621,  621,  621, 1177,
 /*   290 */   621, 1347,  252,  675,  252,  349, 1418, 1428,  621,  820,
 /*   300 */  1304,  252, 1496, 1351, 3182, 3182, 3182, 3182, 3182, 3182,
 /*   310 */  3182, 3182, 3182,   34,  476,  181,  916,   57,  425,  170,
 /*   320 */   587,  813,  828,  721,  640,  184,  184,  184,  184,  184,
 /*   330 */   184,  184,  184,  184,  865,  280,    3,    3,  171,  730,
 /*   340 */   323,  472,  262,  706,  735,  673,  682,  728,  728,  653,
 /*   350 */   856,  731,  653,  653,  653, 1065,  859,   38, 1083, 1041,
 /*   360 */  1000, 1077, 1046, 1048, 1062, 1063, 1143, 1147, 1161, 1173,
 /*   370 */  1174,  982,  767, 1076,  791, 1106, 1126, 1136, 1049,  987,
 /*   380 */   998, 1137, 1162, 1163, 1169, 1170, 1181, 1183, 1196, 1184,
 /*   390 */  1114, 1154, 1029, 1150,  368, 1190, 1191, 1198, 1199, 1206,
 /*   400 */  1210,  320, 1186, 1188, 1158, 1218, 1551, 1555, 1567, 1527,
 /*   410 */  1571, 1537, 1369, 1538, 1542, 1545, 1372, 1583, 1549, 1552,
 /*   420 */  1376, 1594, 1386, 1597, 1563, 1599, 1581, 1601, 1573, 1413,
 /*   430 */  1421, 1424, 1615, 1624, 1629, 1447, 1449, 1633, 1637, 1591,
 /*   440 */  1639, 1641, 1642, 1602, 1643, 1645, 1646, 1647, 1648, 1649,
 /*   450 */  1650, 1651, 1495, 1620, 1656, 1500, 1658, 1659, 1660, 1661,
 /*   460 */  1667, 1668, 1669, 1671, 1672, 1673, 1675, 1681, 1683, 1684,
 /*   470 */  1685, 1686, 1622, 1665, 1687, 1688, 1689, 1690, 1699, 1670,
 /*   480 */  1693, 1694, 1695, 1522, 1696, 1697, 1678, 1653, 1680, 1655,
 /*   490 */  1704, 1644, 1674, 1706, 1652, 1710, 1662, 1712, 1720, 1700,
 /*   500 */  1682, 1691, 1724, 1701, 1698, 1702, 1727, 1703, 1705, 1711,
 /*   510 */  1729, 1707, 1737, 1709, 1713, 1714, 1708, 1715, 1725, 1716,
 /*   520 */  1740, 1719, 1717, 1743, 1744, 1745, 1721, 1570, 1753, 1761,
 /*   530 */  1764, 1726, 1765, 1766, 1732, 1722, 1730, 1768, 1735, 1723,
 /*   540 */  1734, 1774, 1741, 1728, 1736, 1778, 1746, 1749, 1756, 1784,
 /*   550 */  1785, 1799, 1807, 1718, 1731, 1767, 1779, 1803, 1773, 1776,
 /*   560 */  1777, 1780, 1781, 1783, 1786, 1769, 1770, 1796, 1798, 1797,
 /*   570 */  1800, 1834, 1814, 1837, 1816, 1790, 1839, 1820, 1808, 1845,
 /*   580 */  1812, 1848, 1815, 1849, 1829, 1832, 1819, 1822, 1823, 1750,
 /*   590 */  1757, 1855, 1747, 1758, 1666, 1827, 1841, 1864, 1676, 1843,
 /*   600 */  1748, 1751, 1866, 1869, 1755, 1739, 1868, 1828, 1616, 1771,
 /*   610 */  1772, 1791, 1830, 1782, 1831, 1792, 1789, 1836, 1851, 1793,
 /*   620 */  1795, 1804, 1805, 1817, 1856, 1852, 1872, 1826, 1887, 1618,
 /*   630 */  1833, 1835, 1880, 1877, 1677, 1894, 1897, 1898, 1899, 1904,
 /*   640 */  1905, 1838, 1840, 1890, 1738, 1901, 1900, 1946, 1948, 1949,
 /*   650 */  1951, 1850, 1914, 1708, 1907, 1853, 1854, 1857, 1859, 1861,
 /*   660 */  1794, 1863, 1956, 1919, 1802, 1867, 1847, 1708, 1921, 1922,
 /*   670 */  1870, 1733, 1871, 1972, 1954, 1760, 1876, 1878, 1886, 1888,
 /*   680 */  1891, 1889, 1933, 1892, 1895, 1953, 1893, 1979, 1806, 1908,
 /*   690 */  1903, 1909, 1976, 1978, 1912, 1916, 1980, 1918, 1923, 1982,
 /*   700 */  1926, 1927, 1983, 1929, 1930, 1986, 1934, 1911, 1917, 1920,
 /*   710 */  1925, 1936, 1985, 1937, 1989, 1938, 1985, 1985, 2010, 1974,
 /*   720 */  1984, 2008, 2012, 2015, 2017, 2020, 2021, 2022, 2023, 2024,
 /*   730 */  2025, 1971, 1965, 2018, 2029, 2030, 2031, 2045, 2034, 2035,
 /*   740 */  2036, 1998, 1769, 2038, 1770, 2039, 2041, 2043, 2046, 2058,
 /*   750 */  2047, 2084, 2050, 2048, 2053, 2094, 2060, 2049, 2057, 2099,
 /*   760 */  2066, 2054, 2063, 2104, 2071, 2061, 2068, 2109, 2076, 2078,
 /*   770 */  2114, 2102, 2100, 2103, 2105, 2107, 2110,
};
#define YY_REDUCE_COUNT (312)
#define YY_REDUCE_MIN   (-447)
#define YY_REDUCE_MAX   (2751)
static const short yy_reduce_ofst[] = {
 /*     0 */   294,  177,  371,  598,  855, 1034, 1061, 1133, 1165, 1193,
 /*    10 */   448,  674, 1291, 1363, 1461, 1485, -335, 1559, 1579, 1663,
 /*    20 */   906,  832, 1692, 1788, 1801, 1885, 1902, 1915, 1988, 1818,
 /*    30 */  2009, 2055, 2106, 2119, 2205, 2218, 2235, 2269, 2329, 2342,
 /*    40 */  2393, 2415, 2439, 2523, 2536, 2551, 2635, 2652, 2665, 2686,
 /*    50 */  2751, -302,  259,  296,  -88,  383,  490,  521,  543,  501,
 /*    60 */   642,  -23,  -47,  176,  330, -447, -319, -324, -322, -261,
 /*    70 */  -210,  -58, -336, -298,  116,   95,  224,  235,  166,  254,
 /*    80 */   288,  291,  458,  518,  592,  127,  623,  646,   35,  -73,
 /*    90 */   685,  692, -294,  719,  237,  722,  175,  724,  194,  246,
 /*   100 */   762,  803,  339,  814,  376,  373,  421,  801,  -75, -307,
 /*   110 */  -430, -430, -349, -236, -334, -168,  241,  314,  369,  503,
 /*   120 */   504,  549,  558,  593,  620,  629,  649,  670,  678,  699,
 /*   130 */   720,  727,  736, -219,   -3,  158,  -44, -271,   -3,  198,
 /*   140 */   401, -218,  443,  488,  -11,  420,  585,  586,  567,  613,
 /*   150 */  -189,  550,  133, -109,  573,  658,  711,  691,  562,  580,
 /*   160 */   809,  819,  838,  839,  840,  838,  768,  844,  880,  826,
 /*   170 */   746,  759,  883,  777,  866,  866,  896,  852,  904,  919,
 /*   180 */   867,  868,  816,  816,  805,  816,  845,  842,  866,  885,
 /*   190 */   893,  908,  925,  924,  928,  935,  981,  983,  938,  947,
 /*   200 */   949,  984,  986,  999,  991, 1002, 1003, 1006, 1035, 1033,
 /*   210 */  1038, 1036,  969, 1026, 1001, 1031, 1039,  985, 1037, 1044,
 /*   220 */  1040, 1043, 1045, 1047, 1050, 1051, 1052, 1057, 1027, 1028,
 /*   230 */  1032, 1053, 1054, 1055, 1056, 1058, 1059, 1060, 1064, 1066,
 /*   240 */  1067, 1024, 1030, 1068,  996, 1005, 1004, 1070, 1011, 1013,
 /*   250 */  1071, 1073, 1025, 1090, 1072, 1074, 1069,  978, 1075, 1080,
 /*   260 */   979, 1081, 1087, 1089,  866,  980,  988,  989,  992,  997,
 /*   270 */  1078, 1079,  966, 1012, 1022,  816, 1149, 1084, 1155, 1159,
 /*   280 */  1151, 1157, 1113, 1115, 1128, 1132, 1134, 1138, 1139, 1116,
 /*   290 */  1140, 1129, 1176, 1160, 1179, 1180, 1091, 1164, 1152, 1182,
 /*   300 */  1197, 1187, 1207, 1205, 1141, 1122, 1145, 1148, 1189, 1200,
 /*   310 */  1201, 1211, 1219,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*    10 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*    20 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*    30 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*    40 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*    50 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*    60 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*    70 */  1738, 1738, 1738, 1738, 2015, 1738, 1738, 1738, 1738, 1738,
 /*    80 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1824, 1738,
 /*    90 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   100 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1822, 2008,
 /*   110 */  2229, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   120 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   130 */  1738, 1738, 1738, 1738, 2241, 1738, 1738, 1738, 2241, 2241,
 /*   140 */  2241, 1822, 2201, 2201, 1738, 1738, 1738, 1738, 1824, 2073,
 /*   150 */  1738, 1738, 1738, 1738, 1738, 1738, 1943, 1738, 1738, 1738,
 /*   160 */  1738, 1738, 1967, 1738, 1738, 1738, 2067, 1738, 1738, 2266,
 /*   170 */  2322, 1738, 1738, 2269, 1738, 1738, 1738, 2020, 1738, 1738,
 /*   180 */  1897, 2256, 2233, 2247, 2306, 2234, 2231, 2250, 1738, 2260,
 /*   190 */  1738, 2054, 2013, 1738, 2013, 2010, 1738, 1738, 2013, 2010,
 /*   200 */  2010, 1886, 1882, 1738, 1880, 1738, 1738, 1738, 1738, 1785,
 /*   210 */  1738, 1785, 1738, 1824, 1738, 1824, 1738, 1738, 1824, 1738,
 /*   220 */  1824, 1824, 1824, 1738, 1824, 1799, 1799, 1738, 1738, 1738,
 /*   230 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   240 */  1738, 1738, 1738, 1738, 2085, 2071, 1738, 1822, 2065, 2063,
 /*   250 */  1738, 1822, 2061, 1738, 1738, 1738, 1738, 2277, 2275, 1738,
 /*   260 */  2277, 2275, 1738, 1738, 1738, 2291, 2287, 2277, 2295, 2293,
 /*   270 */  2262, 2260, 2325, 2312, 2308, 2247, 1738, 1738, 1738, 1738,
 /*   280 */  1822, 1822, 1738, 2275, 1738, 1738, 1738, 1738, 1738, 2275,
 /*   290 */  1738, 1738, 1822, 1738, 1822, 1738, 1738, 1913, 1738, 1738,
 /*   300 */  1738, 1822, 1770, 1738, 2056, 2076, 2038, 2038, 1946, 1946,
 /*   310 */  1946, 1825, 1743, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   320 */  1738, 1738, 1738, 1738, 1738, 2290, 2289, 2156, 1738, 2205,
 /*   330 */  2204, 2203, 2194, 2155, 1909, 1738, 2154, 2153, 1738, 1738,
 /*   340 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 2029, 2028, 2147,
 /*   350 */  1738, 1738, 2148, 2146, 2145, 1738, 1738, 1738, 1738, 1738,
 /*   360 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   370 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 2309,
 /*   380 */  2313, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 2230, 1738,
 /*   390 */  1738, 1738, 1738, 1738, 2129, 1738, 1738, 1738, 1738, 1738,
 /*   400 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   410 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   420 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   430 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   440 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   450 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   460 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   470 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   480 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   490 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   500 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   510 */  1738, 1738, 1738, 1738, 1738, 1775, 2134, 1738, 1738, 1738,
 /*   520 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   530 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   540 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   550 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   560 */  1738, 1738, 1738, 1738, 1738, 1863, 1862, 1738, 1738, 1738,
 /*   570 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   580 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 2138,
 /*   590 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   600 */  1738, 1738, 1738, 1738, 1738, 1738, 2305, 2263, 1738, 1738,
 /*   610 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   620 */  1738, 1738, 1738, 1738, 1738, 1738, 2129, 1738, 2288, 1738,
 /*   630 */  1738, 2303, 1738, 2307, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   640 */  1738, 2240, 2236, 1738, 1738, 2232, 1738, 1738, 1738, 1738,
 /*   650 */  1738, 1738, 1738, 2137, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   660 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 2128, 1738, 2191,
 /*   670 */  1738, 1738, 1738, 2225, 1738, 1738, 2176, 1738, 1738, 1738,
 /*   680 */  1738, 1738, 1738, 1738, 1738, 1738, 2138, 1738, 2141, 1738,
 /*   690 */  1738, 1738, 1738, 1738, 1940, 1738, 1738, 1738, 1738, 1738,
 /*   700 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1925, 1923, 1922,
 /*   710 */  1921, 1738, 1953, 1738, 1738, 1738, 1949, 1948, 1738, 1738,
 /*   720 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   730 */  1738, 1738, 1738, 1843, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   740 */  1738, 1738, 1835, 1738, 1834, 1738, 1738, 1738, 1738, 1738,
 /*   750 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   760 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   770 */  1738, 1738, 1738, 1738, 1738, 1738, 1738,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*       WITH => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /*    RESTORE => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*      VNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*  TIMESTAMP => nothing */
  281,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*   LANGUAGE => nothing */
    0,  /*    REPLACE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*     LEADER => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  281,  /*      AFTER => ABORT */
  281,  /*     ATTACH => ABORT */
  281,  /*     BEFORE => ABORT */
  281,  /*      BEGIN => ABORT */
  281,  /*     BITAND => ABORT */
  281,  /*     BITNOT => ABORT */
  281,  /*      BITOR => ABORT */
  281,  /*     BLOCKS => ABORT */
  281,  /*     CHANGE => ABORT */
  281,  /*      COMMA => ABORT */
  281,  /*     CONCAT => ABORT */
  281,  /*   CONFLICT => ABORT */
  281,  /*       COPY => ABORT */
  281,  /*   DEFERRED => ABORT */
  281,  /* DELIMITERS => ABORT */
  281,  /*     DETACH => ABORT */
  281,  /*     DIVIDE => ABORT */
  281,  /*        DOT => ABORT */
  281,  /*       EACH => ABORT */
  281,  /*       FAIL => ABORT */
  281,  /*       FILE => ABORT */
  281,  /*        FOR => ABORT */
  281,  /*       GLOB => ABORT */
  281,  /*         ID => ABORT */
  281,  /*  IMMEDIATE => ABORT */
  281,  /*     IMPORT => ABORT */
  281,  /*  INITIALLY => ABORT */
  281,  /*    INSTEAD => ABORT */
  281,  /*     ISNULL => ABORT */
  281,  /*        KEY => ABORT */
  281,  /*    MODULES => ABORT */
  281,  /*  NK_BITNOT => ABORT */
  281,  /*    NK_SEMI => ABORT */
  281,  /*    NOTNULL => ABORT */
  281,  /*         OF => ABORT */
  281,  /*       PLUS => ABORT */
  281,  /*  PRIVILEGE => ABORT */
  281,  /*      RAISE => ABORT */
  281,  /*   RESTRICT => ABORT */
  281,  /*        ROW => ABORT */
  281,  /*       SEMI => ABORT */
  281,  /*       STAR => ABORT */
  281,  /*  STATEMENT => ABORT */
  281,  /*     STRICT => ABORT */
  281,  /*     STRING => ABORT */
  281,  /*      TIMES => ABORT */
  281,  /*     VALUES => ABORT */
  281,  /*   VARIABLE => ABORT */
  281,  /*       VIEW => ABORT */
  281,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "WITH",
  /*   49 */ "DNODE",
  /*   50 */ "PORT",
  /*   51 */ "DNODES",
  /*   52 */ "RESTORE",
  /*   53 */ "NK_IPTOKEN",
  /*   54 */ "FORCE",
  /*   55 */ "LOCAL",
  /*   56 */ "QNODE",
  /*   57 */ "BNODE",
  /*   58 */ "SNODE",
  /*   59 */ "MNODE",
  /*   60 */ "VNODE",
  /*   61 */ "DATABASE",
  /*   62 */ "USE",
  /*   63 */ "FLUSH",
  /*   64 */ "TRIM",
  /*   65 */ "COMPACT",
  /*   66 */ "IF",
  /*   67 */ "NOT",
  /*   68 */ "EXISTS",
  /*   69 */ "BUFFER",
  /*   70 */ "CACHEMODEL",
  /*   71 */ "CACHESIZE",
  /*   72 */ "COMP",
  /*   73 */ "DURATION",
  /*   74 */ "NK_VARIABLE",
  /*   75 */ "MAXROWS",
  /*   76 */ "MINROWS",
  /*   77 */ "KEEP",
  /*   78 */ "PAGES",
  /*   79 */ "PAGESIZE",
  /*   80 */ "TSDB_PAGESIZE",
  /*   81 */ "PRECISION",
  /*   82 */ "REPLICA",
  /*   83 */ "VGROUPS",
  /*   84 */ "SINGLE_STABLE",
  /*   85 */ "RETENTIONS",
  /*   86 */ "SCHEMALESS",
  /*   87 */ "WAL_LEVEL",
  /*   88 */ "WAL_FSYNC_PERIOD",
  /*   89 */ "WAL_RETENTION_PERIOD",
  /*   90 */ "WAL_RETENTION_SIZE",
  /*   91 */ "WAL_ROLL_PERIOD",
  /*   92 */ "WAL_SEGMENT_SIZE",
  /*   93 */ "STT_TRIGGER",
  /*   94 */ "TABLE_PREFIX",
  /*   95 */ "TABLE_SUFFIX",
  /*   96 */ "NK_COLON",
  /*   97 */ "MAX_SPEED",
  /*   98 */ "START",
  /*   99 */ "TIMESTAMP",
  /*  100 */ "END",
  /*  101 */ "TABLE",
  /*  102 */ "NK_LP",
  /*  103 */ "NK_RP",
  /*  104 */ "STABLE",
  /*  105 */ "ADD",
  /*  106 */ "COLUMN",
  /*  107 */ "MODIFY",
  /*  108 */ "RENAME",
  /*  109 */ "TAG",
  /*  110 */ "SET",
  /*  111 */ "NK_EQ",
  /*  112 */ "USING",
  /*  113 */ "TAGS",
  /*  114 */ "BOOL",
  /*  115 */ "TINYINT",
  /*  116 */ "SMALLINT",
  /*  117 */ "INT",
  /*  118 */ "INTEGER",
  /*  119 */ "BIGINT",
  /*  120 */ "FLOAT",
  /*  121 */ "DOUBLE",
  /*  122 */ "BINARY",
  /*  123 */ "NCHAR",
  /*  124 */ "UNSIGNED",
  /*  125 */ "JSON",
  /*  126 */ "VARCHAR",
  /*  127 */ "MEDIUMBLOB",
  /*  128 */ "BLOB",
  /*  129 */ "VARBINARY",
  /*  130 */ "DECIMAL",
  /*  131 */ "COMMENT",
  /*  132 */ "MAX_DELAY",
  /*  133 */ "WATERMARK",
  /*  134 */ "ROLLUP",
  /*  135 */ "TTL",
  /*  136 */ "SMA",
  /*  137 */ "DELETE_MARK",
  /*  138 */ "FIRST",
  /*  139 */ "LAST",
  /*  140 */ "SHOW",
  /*  141 */ "PRIVILEGES",
  /*  142 */ "DATABASES",
  /*  143 */ "TABLES",
  /*  144 */ "STABLES",
  /*  145 */ "MNODES",
  /*  146 */ "QNODES",
  /*  147 */ "FUNCTIONS",
  /*  148 */ "INDEXES",
  /*  149 */ "ACCOUNTS",
  /*  150 */ "APPS",
  /*  151 */ "CONNECTIONS",
  /*  152 */ "LICENCES",
  /*  153 */ "GRANTS",
  /*  154 */ "QUERIES",
  /*  155 */ "SCORES",
  /*  156 */ "TOPICS",
  /*  157 */ "VARIABLES",
  /*  158 */ "CLUSTER",
  /*  159 */ "BNODES",
  /*  160 */ "SNODES",
  /*  161 */ "TRANSACTIONS",
  /*  162 */ "DISTRIBUTED",
  /*  163 */ "CONSUMERS",
  /*  164 */ "SUBSCRIPTIONS",
  /*  165 */ "VNODES",
  /*  166 */ "ALIVE",
  /*  167 */ "LIKE",
  /*  168 */ "TBNAME",
  /*  169 */ "QTAGS",
  /*  170 */ "AS",
  /*  171 */ "INDEX",
  /*  172 */ "FUNCTION",
  /*  173 */ "INTERVAL",
  /*  174 */ "COUNT",
  /*  175 */ "LAST_ROW",
  /*  176 */ "TOPIC",
  /*  177 */ "META",
  /*  178 */ "CONSUMER",
  /*  179 */ "GROUP",
  /*  180 */ "DESC",
  /*  181 */ "DESCRIBE",
  /*  182 */ "RESET",
  /*  183 */ "QUERY",
  /*  184 */ "CACHE",
  /*  185 */ "EXPLAIN",
  /*  186 */ "ANALYZE",
  /*  187 */ "VERBOSE",
  /*  188 */ "NK_BOOL",
  /*  189 */ "RATIO",
  /*  190 */ "NK_FLOAT",
  /*  191 */ "OUTPUTTYPE",
  /*  192 */ "AGGREGATE",
  /*  193 */ "BUFSIZE",
  /*  194 */ "LANGUAGE",
  /*  195 */ "REPLACE",
  /*  196 */ "STREAM",
  /*  197 */ "INTO",
  /*  198 */ "TRIGGER",
  /*  199 */ "AT_ONCE",
  /*  200 */ "WINDOW_CLOSE",
  /*  201 */ "IGNORE",
  /*  202 */ "EXPIRED",
  /*  203 */ "FILL_HISTORY",
  /*  204 */ "UPDATE",
  /*  205 */ "SUBTABLE",
  /*  206 */ "KILL",
  /*  207 */ "CONNECTION",
  /*  208 */ "TRANSACTION",
  /*  209 */ "BALANCE",
  /*  210 */ "VGROUP",
  /*  211 */ "LEADER",
  /*  212 */ "MERGE",
  /*  213 */ "REDISTRIBUTE",
  /*  214 */ "SPLIT",
  /*  215 */ "DELETE",
  /*  216 */ "INSERT",
  /*  217 */ "NULL",
  /*  218 */ "NK_QUESTION",
  /*  219 */ "NK_ARROW",
  /*  220 */ "ROWTS",
  /*  221 */ "QSTART",
  /*  222 */ "QEND",
  /*  223 */ "QDURATION",
  /*  224 */ "WSTART",
  /*  225 */ "WEND",
  /*  226 */ "WDURATION",
  /*  227 */ "IROWTS",
  /*  228 */ "ISFILLED",
  /*  229 */ "CAST",
  /*  230 */ "NOW",
  /*  231 */ "TODAY",
  /*  232 */ "TIMEZONE",
  /*  233 */ "CLIENT_VERSION",
  /*  234 */ "SERVER_VERSION",
  /*  235 */ "SERVER_STATUS",
  /*  236 */ "CURRENT_USER",
  /*  237 */ "CASE",
  /*  238 */ "WHEN",
  /*  239 */ "THEN",
  /*  240 */ "ELSE",
  /*  241 */ "BETWEEN",
  /*  242 */ "IS",
  /*  243 */ "NK_LT",
  /*  244 */ "NK_GT",
  /*  245 */ "NK_LE",
  /*  246 */ "NK_GE",
  /*  247 */ "NK_NE",
  /*  248 */ "MATCH",
  /*  249 */ "NMATCH",
  /*  250 */ "CONTAINS",
  /*  251 */ "IN",
  /*  252 */ "JOIN",
  /*  253 */ "INNER",
  /*  254 */ "SELECT",
  /*  255 */ "DISTINCT",
  /*  256 */ "WHERE",
  /*  257 */ "PARTITION",
  /*  258 */ "BY",
  /*  259 */ "SESSION",
  /*  260 */ "STATE_WINDOW",
  /*  261 */ "EVENT_WINDOW",
  /*  262 */ "SLIDING",
  /*  263 */ "FILL",
  /*  264 */ "VALUE",
  /*  265 */ "VALUE_F",
  /*  266 */ "NONE",
  /*  267 */ "PREV",
  /*  268 */ "NULL_F",
  /*  269 */ "LINEAR",
  /*  270 */ "NEXT",
  /*  271 */ "HAVING",
  /*  272 */ "RANGE",
  /*  273 */ "EVERY",
  /*  274 */ "ORDER",
  /*  275 */ "SLIMIT",
  /*  276 */ "SOFFSET",
  /*  277 */ "LIMIT",
  /*  278 */ "OFFSET",
  /*  279 */ "ASC",
  /*  280 */ "NULLS",
  /*  281 */ "ABORT",
  /*  282 */ "AFTER",
  /*  283 */ "ATTACH",
  /*  284 */ "BEFORE",
  /*  285 */ "BEGIN",
  /*  286 */ "BITAND",
  /*  287 */ "BITNOT",
  /*  288 */ "BITOR",
  /*  289 */ "BLOCKS",
  /*  290 */ "CHANGE",
  /*  291 */ "COMMA",
  /*  292 */ "CONCAT",
  /*  293 */ "CONFLICT",
  /*  294 */ "COPY",
  /*  295 */ "DEFERRED",
  /*  296 */ "DELIMITERS",
  /*  297 */ "DETACH",
  /*  298 */ "DIVIDE",
  /*  299 */ "DOT",
  /*  300 */ "EACH",
  /*  301 */ "FAIL",
  /*  302 */ "FILE",
  /*  303 */ "FOR",
  /*  304 */ "GLOB",
  /*  305 */ "ID",
  /*  306 */ "IMMEDIATE",
  /*  307 */ "IMPORT",
  /*  308 */ "INITIALLY",
  /*  309 */ "INSTEAD",
  /*  310 */ "ISNULL",
  /*  311 */ "KEY",
  /*  312 */ "MODULES",
  /*  313 */ "NK_BITNOT",
  /*  314 */ "NK_SEMI",
  /*  315 */ "NOTNULL",
  /*  316 */ "OF",
  /*  317 */ "PLUS",
  /*  318 */ "PRIVILEGE",
  /*  319 */ "RAISE",
  /*  320 */ "RESTRICT",
  /*  321 */ "ROW",
  /*  322 */ "SEMI",
  /*  323 */ "STAR",
  /*  324 */ "STATEMENT",
  /*  325 */ "STRICT",
  /*  326 */ "STRING",
  /*  327 */ "TIMES",
  /*  328 */ "VALUES",
  /*  329 */ "VARIABLE",
  /*  330 */ "VIEW",
  /*  331 */ "WAL",
  /*  332 */ "cmd",
  /*  333 */ "account_options",
  /*  334 */ "alter_account_options",
  /*  335 */ "literal",
  /*  336 */ "alter_account_option",
  /*  337 */ "user_name",
  /*  338 */ "sysinfo_opt",
  /*  339 */ "privileges",
  /*  340 */ "priv_level",
  /*  341 */ "with_opt",
  /*  342 */ "priv_type_list",
  /*  343 */ "priv_type",
  /*  344 */ "db_name",
  /*  345 */ "table_name",
  /*  346 */ "topic_name",
  /*  347 */ "search_condition",
  /*  348 */ "dnode_endpoint",
  /*  349 */ "force_opt",
  /*  350 */ "not_exists_opt",
  /*  351 */ "db_options",
  /*  352 */ "exists_opt",
  /*  353 */ "alter_db_options",
  /*  354 */ "speed_opt",
  /*  355 */ "start_opt",
  /*  356 */ "end_opt",
  /*  357 */ "integer_list",
  /*  358 */ "variable_list",
  /*  359 */ "retention_list",
  /*  360 */ "alter_db_option",
  /*  361 */ "retention",
  /*  362 */ "full_table_name",
  /*  363 */ "column_def_list",
  /*  364 */ "tags_def_opt",
  /*  365 */ "table_options",
  /*  366 */ "multi_create_clause",
  /*  367 */ "tags_def",
  /*  368 */ "multi_drop_clause",
  /*  369 */ "alter_table_clause",
  /*  370 */ "alter_table_options",
  /*  371 */ "column_name",
  /*  372 */ "type_name",
  /*  373 */ "signed_literal",
  /*  374 */ "create_subtable_clause",
  /*  375 */ "specific_cols_opt",
  /*  376 */ "expression_list",
  /*  377 */ "drop_table_clause",
  /*  378 */ "col_name_list",
  /*  379 */ "column_def",
  /*  380 */ "duration_list",
  /*  381 */ "rollup_func_list",
  /*  382 */ "alter_table_option",
  /*  383 */ "duration_literal",
  /*  384 */ "rollup_func_name",
  /*  385 */ "function_name",
  /*  386 */ "col_name",
  /*  387 */ "db_name_cond_opt",
  /*  388 */ "like_pattern_opt",
  /*  389 */ "table_name_cond",
  /*  390 */ "from_db_opt",
  /*  391 */ "tag_list_opt",
  /*  392 */ "tag_item",
  /*  393 */ "column_alias",
  /*  394 */ "full_index_name",
  /*  395 */ "index_options",
  /*  396 */ "index_name",
  /*  397 */ "func_list",
  /*  398 */ "sliding_opt",
  /*  399 */ "sma_stream_opt",
  /*  400 */ "func",
  /*  401 */ "sma_func_name",
  /*  402 */ "query_or_subquery",
  /*  403 */ "cgroup_name",
  /*  404 */ "analyze_opt",
  /*  405 */ "explain_options",
  /*  406 */ "insert_query",
  /*  407 */ "or_replace_opt",
  /*  408 */ "agg_func_opt",
  /*  409 */ "bufsize_opt",
  /*  410 */ "language_opt",
  /*  411 */ "stream_name",
  /*  412 */ "stream_options",
  /*  413 */ "col_list_opt",
  /*  414 */ "tag_def_or_ref_opt",
  /*  415 */ "subtable_opt",
  /*  416 */ "expression",
  /*  417 */ "dnode_list",
  /*  418 */ "where_clause_opt",
  /*  419 */ "signed",
  /*  420 */ "literal_func",
  /*  421 */ "literal_list",
  /*  422 */ "table_alias",
  /*  423 */ "expr_or_subquery",
  /*  424 */ "pseudo_column",
  /*  425 */ "column_reference",
  /*  426 */ "function_expression",
  /*  427 */ "case_when_expression",
  /*  428 */ "star_func",
  /*  429 */ "star_func_para_list",
  /*  430 */ "noarg_func",
  /*  431 */ "other_para_list",
  /*  432 */ "star_func_para",
  /*  433 */ "when_then_list",
  /*  434 */ "case_when_else_opt",
  /*  435 */ "common_expression",
  /*  436 */ "when_then_expr",
  /*  437 */ "predicate",
  /*  438 */ "compare_op",
  /*  439 */ "in_op",
  /*  440 */ "in_predicate_value",
  /*  441 */ "boolean_value_expression",
  /*  442 */ "boolean_primary",
  /*  443 */ "from_clause_opt",
  /*  444 */ "table_reference_list",
  /*  445 */ "table_reference",
  /*  446 */ "table_primary",
  /*  447 */ "joined_table",
  /*  448 */ "alias_opt",
  /*  449 */ "subquery",
  /*  450 */ "parenthesized_joined_table",
  /*  451 */ "join_type",
  /*  452 */ "query_specification",
  /*  453 */ "set_quantifier_opt",
  /*  454 */ "select_list",
  /*  455 */ "partition_by_clause_opt",
  /*  456 */ "range_opt",
  /*  457 */ "every_opt",
  /*  458 */ "fill_opt",
  /*  459 */ "twindow_clause_opt",
  /*  460 */ "group_by_clause_opt",
  /*  461 */ "having_clause_opt",
  /*  462 */ "select_item",
  /*  463 */ "partition_list",
  /*  464 */ "partition_item",
  /*  465 */ "fill_mode",
  /*  466 */ "group_by_list",
  /*  467 */ "query_expression",
  /*  468 */ "query_simple",
  /*  469 */ "order_by_clause_opt",
  /*  470 */ "slimit_clause_opt",
  /*  471 */ "limit_clause_opt",
  /*  472 */ "union_query_expression",
  /*  473 */ "query_simple_or_subquery",
  /*  474 */ "sort_specification_list",
  /*  475 */ "sort_specification",
  /*  476 */ "ordering_specification_opt",
  /*  477 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level with_opt TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= db_name NK_DOT table_name",
 /*  43 */ "priv_level ::= topic_name",
 /*  44 */ "with_opt ::=",
 /*  45 */ "with_opt ::= WITH search_condition",
 /*  46 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  47 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  48 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  49 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  50 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  51 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  52 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  53 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  54 */ "cmd ::= RESTORE DNODE NK_INTEGER",
 /*  55 */ "dnode_endpoint ::= NK_STRING",
 /*  56 */ "dnode_endpoint ::= NK_ID",
 /*  57 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  58 */ "force_opt ::=",
 /*  59 */ "force_opt ::= FORCE",
 /*  60 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  61 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  62 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= RESTORE QNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  67 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  68 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  69 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  70 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  71 */ "cmd ::= RESTORE MNODE ON DNODE NK_INTEGER",
 /*  72 */ "cmd ::= RESTORE VNODE ON DNODE NK_INTEGER",
 /*  73 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  74 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  75 */ "cmd ::= USE db_name",
 /*  76 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  77 */ "cmd ::= FLUSH DATABASE db_name",
 /*  78 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  79 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  80 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  81 */ "not_exists_opt ::=",
 /*  82 */ "exists_opt ::= IF EXISTS",
 /*  83 */ "exists_opt ::=",
 /*  84 */ "db_options ::=",
 /*  85 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  86 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  87 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  88 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  89 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  90 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  91 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  92 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  93 */ "db_options ::= db_options KEEP integer_list",
 /*  94 */ "db_options ::= db_options KEEP variable_list",
 /*  95 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  96 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  97 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  98 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  99 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /* 100 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /* 101 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /* 102 */ "db_options ::= db_options RETENTIONS retention_list",
 /* 103 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /* 105 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /* 106 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 107 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 108 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 109 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 110 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 111 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 112 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 113 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 114 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 115 */ "alter_db_options ::= alter_db_option",
 /* 116 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 117 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 118 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 119 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 120 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 121 */ "alter_db_option ::= KEEP integer_list",
 /* 122 */ "alter_db_option ::= KEEP variable_list",
 /* 123 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 124 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 125 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 126 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 127 */ "alter_db_option ::= MINROWS NK_INTEGER",
 /* 128 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER",
 /* 129 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 130 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER",
 /* 131 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 132 */ "integer_list ::= NK_INTEGER",
 /* 133 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 134 */ "variable_list ::= NK_VARIABLE",
 /* 135 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 136 */ "retention_list ::= retention",
 /* 137 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 138 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 139 */ "speed_opt ::=",
 /* 140 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 141 */ "start_opt ::=",
 /* 142 */ "start_opt ::= START WITH NK_INTEGER",
 /* 143 */ "start_opt ::= START WITH NK_STRING",
 /* 144 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 145 */ "end_opt ::=",
 /* 146 */ "end_opt ::= END WITH NK_INTEGER",
 /* 147 */ "end_opt ::= END WITH NK_STRING",
 /* 148 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 149 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 150 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 151 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 152 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 153 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 154 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 155 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 156 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 157 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 158 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 159 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 160 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 161 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 162 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 163 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 164 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 165 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 166 */ "multi_create_clause ::= create_subtable_clause",
 /* 167 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 168 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 169 */ "multi_drop_clause ::= drop_table_clause",
 /* 170 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 171 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 172 */ "specific_cols_opt ::=",
 /* 173 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 174 */ "full_table_name ::= table_name",
 /* 175 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 176 */ "column_def_list ::= column_def",
 /* 177 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 178 */ "column_def ::= column_name type_name",
 /* 179 */ "type_name ::= BOOL",
 /* 180 */ "type_name ::= TINYINT",
 /* 181 */ "type_name ::= SMALLINT",
 /* 182 */ "type_name ::= INT",
 /* 183 */ "type_name ::= INTEGER",
 /* 184 */ "type_name ::= BIGINT",
 /* 185 */ "type_name ::= FLOAT",
 /* 186 */ "type_name ::= DOUBLE",
 /* 187 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 188 */ "type_name ::= TIMESTAMP",
 /* 189 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 190 */ "type_name ::= TINYINT UNSIGNED",
 /* 191 */ "type_name ::= SMALLINT UNSIGNED",
 /* 192 */ "type_name ::= INT UNSIGNED",
 /* 193 */ "type_name ::= BIGINT UNSIGNED",
 /* 194 */ "type_name ::= JSON",
 /* 195 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 196 */ "type_name ::= MEDIUMBLOB",
 /* 197 */ "type_name ::= BLOB",
 /* 198 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 199 */ "type_name ::= DECIMAL",
 /* 200 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 201 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 202 */ "tags_def_opt ::=",
 /* 203 */ "tags_def_opt ::= tags_def",
 /* 204 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 205 */ "table_options ::=",
 /* 206 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 207 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 208 */ "table_options ::= table_options WATERMARK duration_list",
 /* 209 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 210 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 211 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 212 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 213 */ "alter_table_options ::= alter_table_option",
 /* 214 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 215 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 216 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 217 */ "duration_list ::= duration_literal",
 /* 218 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 219 */ "rollup_func_list ::= rollup_func_name",
 /* 220 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 221 */ "rollup_func_name ::= function_name",
 /* 222 */ "rollup_func_name ::= FIRST",
 /* 223 */ "rollup_func_name ::= LAST",
 /* 224 */ "col_name_list ::= col_name",
 /* 225 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 226 */ "col_name ::= column_name",
 /* 227 */ "cmd ::= SHOW DNODES",
 /* 228 */ "cmd ::= SHOW USERS",
 /* 229 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 230 */ "cmd ::= SHOW DATABASES",
 /* 231 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 232 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 233 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 234 */ "cmd ::= SHOW MNODES",
 /* 235 */ "cmd ::= SHOW QNODES",
 /* 236 */ "cmd ::= SHOW FUNCTIONS",
 /* 237 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 238 */ "cmd ::= SHOW STREAMS",
 /* 239 */ "cmd ::= SHOW ACCOUNTS",
 /* 240 */ "cmd ::= SHOW APPS",
 /* 241 */ "cmd ::= SHOW CONNECTIONS",
 /* 242 */ "cmd ::= SHOW LICENCES",
 /* 243 */ "cmd ::= SHOW GRANTS",
 /* 244 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 245 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 246 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 247 */ "cmd ::= SHOW QUERIES",
 /* 248 */ "cmd ::= SHOW SCORES",
 /* 249 */ "cmd ::= SHOW TOPICS",
 /* 250 */ "cmd ::= SHOW VARIABLES",
 /* 251 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 252 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 253 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 254 */ "cmd ::= SHOW BNODES",
 /* 255 */ "cmd ::= SHOW SNODES",
 /* 256 */ "cmd ::= SHOW CLUSTER",
 /* 257 */ "cmd ::= SHOW TRANSACTIONS",
 /* 258 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 259 */ "cmd ::= SHOW CONSUMERS",
 /* 260 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 261 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 262 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 263 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 264 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 265 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 266 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 267 */ "db_name_cond_opt ::=",
 /* 268 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 269 */ "like_pattern_opt ::=",
 /* 270 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 271 */ "table_name_cond ::= table_name",
 /* 272 */ "from_db_opt ::=",
 /* 273 */ "from_db_opt ::= FROM db_name",
 /* 274 */ "tag_list_opt ::=",
 /* 275 */ "tag_list_opt ::= tag_item",
 /* 276 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 277 */ "tag_item ::= TBNAME",
 /* 278 */ "tag_item ::= QTAGS",
 /* 279 */ "tag_item ::= column_name",
 /* 280 */ "tag_item ::= column_name column_alias",
 /* 281 */ "tag_item ::= column_name AS column_alias",
 /* 282 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 283 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 284 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 285 */ "full_index_name ::= index_name",
 /* 286 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 287 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 288 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 289 */ "func_list ::= func",
 /* 290 */ "func_list ::= func_list NK_COMMA func",
 /* 291 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 292 */ "sma_func_name ::= function_name",
 /* 293 */ "sma_func_name ::= COUNT",
 /* 294 */ "sma_func_name ::= FIRST",
 /* 295 */ "sma_func_name ::= LAST",
 /* 296 */ "sma_func_name ::= LAST_ROW",
 /* 297 */ "sma_stream_opt ::=",
 /* 298 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 299 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 300 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 301 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 302 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 303 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 304 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 305 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 306 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 307 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 308 */ "cmd ::= DESC full_table_name",
 /* 309 */ "cmd ::= DESCRIBE full_table_name",
 /* 310 */ "cmd ::= RESET QUERY CACHE",
 /* 311 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 312 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 313 */ "analyze_opt ::=",
 /* 314 */ "analyze_opt ::= ANALYZE",
 /* 315 */ "explain_options ::=",
 /* 316 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 317 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 318 */ "cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt",
 /* 319 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 320 */ "agg_func_opt ::=",
 /* 321 */ "agg_func_opt ::= AGGREGATE",
 /* 322 */ "bufsize_opt ::=",
 /* 323 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 324 */ "language_opt ::=",
 /* 325 */ "language_opt ::= LANGUAGE NK_STRING",
 /* 326 */ "or_replace_opt ::=",
 /* 327 */ "or_replace_opt ::= OR REPLACE",
 /* 328 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 329 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 330 */ "col_list_opt ::=",
 /* 331 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 332 */ "tag_def_or_ref_opt ::=",
 /* 333 */ "tag_def_or_ref_opt ::= tags_def",
 /* 334 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 335 */ "stream_options ::=",
 /* 336 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 337 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 338 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 339 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 340 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 341 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 342 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 343 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 344 */ "subtable_opt ::=",
 /* 345 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 346 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 347 */ "cmd ::= KILL QUERY NK_STRING",
 /* 348 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 349 */ "cmd ::= BALANCE VGROUP",
 /* 350 */ "cmd ::= BALANCE VGROUP LEADER",
 /* 351 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 352 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 353 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 354 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 355 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 356 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 357 */ "cmd ::= query_or_subquery",
 /* 358 */ "cmd ::= insert_query",
 /* 359 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 360 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 361 */ "literal ::= NK_INTEGER",
 /* 362 */ "literal ::= NK_FLOAT",
 /* 363 */ "literal ::= NK_STRING",
 /* 364 */ "literal ::= NK_BOOL",
 /* 365 */ "literal ::= TIMESTAMP NK_STRING",
 /* 366 */ "literal ::= duration_literal",
 /* 367 */ "literal ::= NULL",
 /* 368 */ "literal ::= NK_QUESTION",
 /* 369 */ "duration_literal ::= NK_VARIABLE",
 /* 370 */ "signed ::= NK_INTEGER",
 /* 371 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 372 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 373 */ "signed ::= NK_FLOAT",
 /* 374 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 375 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 376 */ "signed_literal ::= signed",
 /* 377 */ "signed_literal ::= NK_STRING",
 /* 378 */ "signed_literal ::= NK_BOOL",
 /* 379 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 380 */ "signed_literal ::= duration_literal",
 /* 381 */ "signed_literal ::= NULL",
 /* 382 */ "signed_literal ::= literal_func",
 /* 383 */ "signed_literal ::= NK_QUESTION",
 /* 384 */ "literal_list ::= signed_literal",
 /* 385 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 386 */ "db_name ::= NK_ID",
 /* 387 */ "table_name ::= NK_ID",
 /* 388 */ "column_name ::= NK_ID",
 /* 389 */ "function_name ::= NK_ID",
 /* 390 */ "table_alias ::= NK_ID",
 /* 391 */ "column_alias ::= NK_ID",
 /* 392 */ "user_name ::= NK_ID",
 /* 393 */ "topic_name ::= NK_ID",
 /* 394 */ "stream_name ::= NK_ID",
 /* 395 */ "cgroup_name ::= NK_ID",
 /* 396 */ "index_name ::= NK_ID",
 /* 397 */ "expr_or_subquery ::= expression",
 /* 398 */ "expression ::= literal",
 /* 399 */ "expression ::= pseudo_column",
 /* 400 */ "expression ::= column_reference",
 /* 401 */ "expression ::= function_expression",
 /* 402 */ "expression ::= case_when_expression",
 /* 403 */ "expression ::= NK_LP expression NK_RP",
 /* 404 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 405 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 406 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 407 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 408 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 409 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 410 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 411 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 412 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 413 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 414 */ "expression_list ::= expr_or_subquery",
 /* 415 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 416 */ "column_reference ::= column_name",
 /* 417 */ "column_reference ::= table_name NK_DOT column_name",
 /* 418 */ "pseudo_column ::= ROWTS",
 /* 419 */ "pseudo_column ::= TBNAME",
 /* 420 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 421 */ "pseudo_column ::= QSTART",
 /* 422 */ "pseudo_column ::= QEND",
 /* 423 */ "pseudo_column ::= QDURATION",
 /* 424 */ "pseudo_column ::= WSTART",
 /* 425 */ "pseudo_column ::= WEND",
 /* 426 */ "pseudo_column ::= WDURATION",
 /* 427 */ "pseudo_column ::= IROWTS",
 /* 428 */ "pseudo_column ::= ISFILLED",
 /* 429 */ "pseudo_column ::= QTAGS",
 /* 430 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 431 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 432 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 433 */ "function_expression ::= literal_func",
 /* 434 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 435 */ "literal_func ::= NOW",
 /* 436 */ "noarg_func ::= NOW",
 /* 437 */ "noarg_func ::= TODAY",
 /* 438 */ "noarg_func ::= TIMEZONE",
 /* 439 */ "noarg_func ::= DATABASE",
 /* 440 */ "noarg_func ::= CLIENT_VERSION",
 /* 441 */ "noarg_func ::= SERVER_VERSION",
 /* 442 */ "noarg_func ::= SERVER_STATUS",
 /* 443 */ "noarg_func ::= CURRENT_USER",
 /* 444 */ "noarg_func ::= USER",
 /* 445 */ "star_func ::= COUNT",
 /* 446 */ "star_func ::= FIRST",
 /* 447 */ "star_func ::= LAST",
 /* 448 */ "star_func ::= LAST_ROW",
 /* 449 */ "star_func_para_list ::= NK_STAR",
 /* 450 */ "star_func_para_list ::= other_para_list",
 /* 451 */ "other_para_list ::= star_func_para",
 /* 452 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 453 */ "star_func_para ::= expr_or_subquery",
 /* 454 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 455 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 456 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 457 */ "when_then_list ::= when_then_expr",
 /* 458 */ "when_then_list ::= when_then_list when_then_expr",
 /* 459 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 460 */ "case_when_else_opt ::=",
 /* 461 */ "case_when_else_opt ::= ELSE common_expression",
 /* 462 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 463 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 464 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 465 */ "predicate ::= expr_or_subquery IS NULL",
 /* 466 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 467 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 468 */ "compare_op ::= NK_LT",
 /* 469 */ "compare_op ::= NK_GT",
 /* 470 */ "compare_op ::= NK_LE",
 /* 471 */ "compare_op ::= NK_GE",
 /* 472 */ "compare_op ::= NK_NE",
 /* 473 */ "compare_op ::= NK_EQ",
 /* 474 */ "compare_op ::= LIKE",
 /* 475 */ "compare_op ::= NOT LIKE",
 /* 476 */ "compare_op ::= MATCH",
 /* 477 */ "compare_op ::= NMATCH",
 /* 478 */ "compare_op ::= CONTAINS",
 /* 479 */ "in_op ::= IN",
 /* 480 */ "in_op ::= NOT IN",
 /* 481 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 482 */ "boolean_value_expression ::= boolean_primary",
 /* 483 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 484 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 485 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 486 */ "boolean_primary ::= predicate",
 /* 487 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 488 */ "common_expression ::= expr_or_subquery",
 /* 489 */ "common_expression ::= boolean_value_expression",
 /* 490 */ "from_clause_opt ::=",
 /* 491 */ "from_clause_opt ::= FROM table_reference_list",
 /* 492 */ "table_reference_list ::= table_reference",
 /* 493 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 494 */ "table_reference ::= table_primary",
 /* 495 */ "table_reference ::= joined_table",
 /* 496 */ "table_primary ::= table_name alias_opt",
 /* 497 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 498 */ "table_primary ::= subquery alias_opt",
 /* 499 */ "table_primary ::= parenthesized_joined_table",
 /* 500 */ "alias_opt ::=",
 /* 501 */ "alias_opt ::= table_alias",
 /* 502 */ "alias_opt ::= AS table_alias",
 /* 503 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 504 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 505 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 506 */ "join_type ::=",
 /* 507 */ "join_type ::= INNER",
 /* 508 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 509 */ "set_quantifier_opt ::=",
 /* 510 */ "set_quantifier_opt ::= DISTINCT",
 /* 511 */ "set_quantifier_opt ::= ALL",
 /* 512 */ "select_list ::= select_item",
 /* 513 */ "select_list ::= select_list NK_COMMA select_item",
 /* 514 */ "select_item ::= NK_STAR",
 /* 515 */ "select_item ::= common_expression",
 /* 516 */ "select_item ::= common_expression column_alias",
 /* 517 */ "select_item ::= common_expression AS column_alias",
 /* 518 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 519 */ "where_clause_opt ::=",
 /* 520 */ "where_clause_opt ::= WHERE search_condition",
 /* 521 */ "partition_by_clause_opt ::=",
 /* 522 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 523 */ "partition_list ::= partition_item",
 /* 524 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 525 */ "partition_item ::= expr_or_subquery",
 /* 526 */ "partition_item ::= expr_or_subquery column_alias",
 /* 527 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 528 */ "twindow_clause_opt ::=",
 /* 529 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 530 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 531 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 532 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 533 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 534 */ "sliding_opt ::=",
 /* 535 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 536 */ "fill_opt ::=",
 /* 537 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 538 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP",
 /* 539 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP",
 /* 540 */ "fill_mode ::= NONE",
 /* 541 */ "fill_mode ::= PREV",
 /* 542 */ "fill_mode ::= NULL",
 /* 543 */ "fill_mode ::= NULL_F",
 /* 544 */ "fill_mode ::= LINEAR",
 /* 545 */ "fill_mode ::= NEXT",
 /* 546 */ "group_by_clause_opt ::=",
 /* 547 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 548 */ "group_by_list ::= expr_or_subquery",
 /* 549 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 550 */ "having_clause_opt ::=",
 /* 551 */ "having_clause_opt ::= HAVING search_condition",
 /* 552 */ "range_opt ::=",
 /* 553 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 554 */ "every_opt ::=",
 /* 555 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 556 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 557 */ "query_simple ::= query_specification",
 /* 558 */ "query_simple ::= union_query_expression",
 /* 559 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 560 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 561 */ "query_simple_or_subquery ::= query_simple",
 /* 562 */ "query_simple_or_subquery ::= subquery",
 /* 563 */ "query_or_subquery ::= query_expression",
 /* 564 */ "query_or_subquery ::= subquery",
 /* 565 */ "order_by_clause_opt ::=",
 /* 566 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 567 */ "slimit_clause_opt ::=",
 /* 568 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 569 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 570 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 571 */ "limit_clause_opt ::=",
 /* 572 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 573 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 574 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 575 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 576 */ "subquery ::= NK_LP subquery NK_RP",
 /* 577 */ "search_condition ::= common_expression",
 /* 578 */ "sort_specification_list ::= sort_specification",
 /* 579 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 580 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 581 */ "ordering_specification_opt ::=",
 /* 582 */ "ordering_specification_opt ::= ASC",
 /* 583 */ "ordering_specification_opt ::= DESC",
 /* 584 */ "null_ordering_opt ::=",
 /* 585 */ "null_ordering_opt ::= NULLS FIRST",
 /* 586 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 332: /* cmd */
    case 335: /* literal */
    case 341: /* with_opt */
    case 347: /* search_condition */
    case 351: /* db_options */
    case 353: /* alter_db_options */
    case 355: /* start_opt */
    case 356: /* end_opt */
    case 361: /* retention */
    case 362: /* full_table_name */
    case 365: /* table_options */
    case 369: /* alter_table_clause */
    case 370: /* alter_table_options */
    case 373: /* signed_literal */
    case 374: /* create_subtable_clause */
    case 377: /* drop_table_clause */
    case 379: /* column_def */
    case 383: /* duration_literal */
    case 384: /* rollup_func_name */
    case 386: /* col_name */
    case 387: /* db_name_cond_opt */
    case 388: /* like_pattern_opt */
    case 389: /* table_name_cond */
    case 390: /* from_db_opt */
    case 392: /* tag_item */
    case 394: /* full_index_name */
    case 395: /* index_options */
    case 398: /* sliding_opt */
    case 399: /* sma_stream_opt */
    case 400: /* func */
    case 402: /* query_or_subquery */
    case 405: /* explain_options */
    case 406: /* insert_query */
    case 412: /* stream_options */
    case 415: /* subtable_opt */
    case 416: /* expression */
    case 418: /* where_clause_opt */
    case 419: /* signed */
    case 420: /* literal_func */
    case 423: /* expr_or_subquery */
    case 424: /* pseudo_column */
    case 425: /* column_reference */
    case 426: /* function_expression */
    case 427: /* case_when_expression */
    case 432: /* star_func_para */
    case 434: /* case_when_else_opt */
    case 435: /* common_expression */
    case 436: /* when_then_expr */
    case 437: /* predicate */
    case 440: /* in_predicate_value */
    case 441: /* boolean_value_expression */
    case 442: /* boolean_primary */
    case 443: /* from_clause_opt */
    case 444: /* table_reference_list */
    case 445: /* table_reference */
    case 446: /* table_primary */
    case 447: /* joined_table */
    case 449: /* subquery */
    case 450: /* parenthesized_joined_table */
    case 452: /* query_specification */
    case 456: /* range_opt */
    case 457: /* every_opt */
    case 458: /* fill_opt */
    case 459: /* twindow_clause_opt */
    case 461: /* having_clause_opt */
    case 462: /* select_item */
    case 464: /* partition_item */
    case 467: /* query_expression */
    case 468: /* query_simple */
    case 470: /* slimit_clause_opt */
    case 471: /* limit_clause_opt */
    case 472: /* union_query_expression */
    case 473: /* query_simple_or_subquery */
    case 475: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy184)); 
}
      break;
    case 333: /* account_options */
    case 334: /* alter_account_options */
    case 336: /* alter_account_option */
    case 354: /* speed_opt */
    case 409: /* bufsize_opt */
{
 
}
      break;
    case 337: /* user_name */
    case 344: /* db_name */
    case 345: /* table_name */
    case 346: /* topic_name */
    case 348: /* dnode_endpoint */
    case 371: /* column_name */
    case 385: /* function_name */
    case 393: /* column_alias */
    case 396: /* index_name */
    case 401: /* sma_func_name */
    case 403: /* cgroup_name */
    case 410: /* language_opt */
    case 411: /* stream_name */
    case 422: /* table_alias */
    case 428: /* star_func */
    case 430: /* noarg_func */
    case 448: /* alias_opt */
{
 
}
      break;
    case 338: /* sysinfo_opt */
{
 
}
      break;
    case 339: /* privileges */
    case 342: /* priv_type_list */
    case 343: /* priv_type */
{
 
}
      break;
    case 340: /* priv_level */
{
 
}
      break;
    case 349: /* force_opt */
    case 350: /* not_exists_opt */
    case 352: /* exists_opt */
    case 404: /* analyze_opt */
    case 407: /* or_replace_opt */
    case 408: /* agg_func_opt */
    case 453: /* set_quantifier_opt */
{
 
}
      break;
    case 357: /* integer_list */
    case 358: /* variable_list */
    case 359: /* retention_list */
    case 363: /* column_def_list */
    case 364: /* tags_def_opt */
    case 366: /* multi_create_clause */
    case 367: /* tags_def */
    case 368: /* multi_drop_clause */
    case 375: /* specific_cols_opt */
    case 376: /* expression_list */
    case 378: /* col_name_list */
    case 380: /* duration_list */
    case 381: /* rollup_func_list */
    case 391: /* tag_list_opt */
    case 397: /* func_list */
    case 413: /* col_list_opt */
    case 414: /* tag_def_or_ref_opt */
    case 417: /* dnode_list */
    case 421: /* literal_list */
    case 429: /* star_func_para_list */
    case 431: /* other_para_list */
    case 433: /* when_then_list */
    case 454: /* select_list */
    case 455: /* partition_by_clause_opt */
    case 460: /* group_by_clause_opt */
    case 463: /* partition_list */
    case 466: /* group_by_list */
    case 469: /* order_by_clause_opt */
    case 474: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy532)); 
}
      break;
    case 360: /* alter_db_option */
    case 382: /* alter_table_option */
{
 
}
      break;
    case 372: /* type_name */
{
 
}
      break;
    case 438: /* compare_op */
    case 439: /* in_op */
{
 
}
      break;
    case 451: /* join_type */
{
 
}
      break;
    case 465: /* fill_mode */
{
 
}
      break;
    case 476: /* ordering_specification_opt */
{
 
}
      break;
    case 477: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<sizeof(yy_action)/sizeof(yy_action[0]) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
   332,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   332,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
   333,  /* (2) account_options ::= */
   333,  /* (3) account_options ::= account_options PPS literal */
   333,  /* (4) account_options ::= account_options TSERIES literal */
   333,  /* (5) account_options ::= account_options STORAGE literal */
   333,  /* (6) account_options ::= account_options STREAMS literal */
   333,  /* (7) account_options ::= account_options QTIME literal */
   333,  /* (8) account_options ::= account_options DBS literal */
   333,  /* (9) account_options ::= account_options USERS literal */
   333,  /* (10) account_options ::= account_options CONNS literal */
   333,  /* (11) account_options ::= account_options STATE literal */
   334,  /* (12) alter_account_options ::= alter_account_option */
   334,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   336,  /* (14) alter_account_option ::= PASS literal */
   336,  /* (15) alter_account_option ::= PPS literal */
   336,  /* (16) alter_account_option ::= TSERIES literal */
   336,  /* (17) alter_account_option ::= STORAGE literal */
   336,  /* (18) alter_account_option ::= STREAMS literal */
   336,  /* (19) alter_account_option ::= QTIME literal */
   336,  /* (20) alter_account_option ::= DBS literal */
   336,  /* (21) alter_account_option ::= USERS literal */
   336,  /* (22) alter_account_option ::= CONNS literal */
   336,  /* (23) alter_account_option ::= STATE literal */
   332,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   332,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   332,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   332,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   332,  /* (28) cmd ::= DROP USER user_name */
   338,  /* (29) sysinfo_opt ::= */
   338,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   332,  /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
   332,  /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
   339,  /* (33) privileges ::= ALL */
   339,  /* (34) privileges ::= priv_type_list */
   339,  /* (35) privileges ::= SUBSCRIBE */
   342,  /* (36) priv_type_list ::= priv_type */
   342,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   343,  /* (38) priv_type ::= READ */
   343,  /* (39) priv_type ::= WRITE */
   340,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   340,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   340,  /* (42) priv_level ::= db_name NK_DOT table_name */
   340,  /* (43) priv_level ::= topic_name */
   341,  /* (44) with_opt ::= */
   341,  /* (45) with_opt ::= WITH search_condition */
   332,  /* (46) cmd ::= CREATE DNODE dnode_endpoint */
   332,  /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   332,  /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
   332,  /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
   332,  /* (50) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   332,  /* (51) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   332,  /* (52) cmd ::= ALTER ALL DNODES NK_STRING */
   332,  /* (53) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   332,  /* (54) cmd ::= RESTORE DNODE NK_INTEGER */
   348,  /* (55) dnode_endpoint ::= NK_STRING */
   348,  /* (56) dnode_endpoint ::= NK_ID */
   348,  /* (57) dnode_endpoint ::= NK_IPTOKEN */
   349,  /* (58) force_opt ::= */
   349,  /* (59) force_opt ::= FORCE */
   332,  /* (60) cmd ::= ALTER LOCAL NK_STRING */
   332,  /* (61) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   332,  /* (62) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   332,  /* (63) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   332,  /* (64) cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
   332,  /* (65) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   332,  /* (66) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   332,  /* (67) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   332,  /* (68) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   332,  /* (69) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   332,  /* (70) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   332,  /* (71) cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
   332,  /* (72) cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
   332,  /* (73) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   332,  /* (74) cmd ::= DROP DATABASE exists_opt db_name */
   332,  /* (75) cmd ::= USE db_name */
   332,  /* (76) cmd ::= ALTER DATABASE db_name alter_db_options */
   332,  /* (77) cmd ::= FLUSH DATABASE db_name */
   332,  /* (78) cmd ::= TRIM DATABASE db_name speed_opt */
   332,  /* (79) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
   350,  /* (80) not_exists_opt ::= IF NOT EXISTS */
   350,  /* (81) not_exists_opt ::= */
   352,  /* (82) exists_opt ::= IF EXISTS */
   352,  /* (83) exists_opt ::= */
   351,  /* (84) db_options ::= */
   351,  /* (85) db_options ::= db_options BUFFER NK_INTEGER */
   351,  /* (86) db_options ::= db_options CACHEMODEL NK_STRING */
   351,  /* (87) db_options ::= db_options CACHESIZE NK_INTEGER */
   351,  /* (88) db_options ::= db_options COMP NK_INTEGER */
   351,  /* (89) db_options ::= db_options DURATION NK_INTEGER */
   351,  /* (90) db_options ::= db_options DURATION NK_VARIABLE */
   351,  /* (91) db_options ::= db_options MAXROWS NK_INTEGER */
   351,  /* (92) db_options ::= db_options MINROWS NK_INTEGER */
   351,  /* (93) db_options ::= db_options KEEP integer_list */
   351,  /* (94) db_options ::= db_options KEEP variable_list */
   351,  /* (95) db_options ::= db_options PAGES NK_INTEGER */
   351,  /* (96) db_options ::= db_options PAGESIZE NK_INTEGER */
   351,  /* (97) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   351,  /* (98) db_options ::= db_options PRECISION NK_STRING */
   351,  /* (99) db_options ::= db_options REPLICA NK_INTEGER */
   351,  /* (100) db_options ::= db_options VGROUPS NK_INTEGER */
   351,  /* (101) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   351,  /* (102) db_options ::= db_options RETENTIONS retention_list */
   351,  /* (103) db_options ::= db_options SCHEMALESS NK_INTEGER */
   351,  /* (104) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   351,  /* (105) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   351,  /* (106) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   351,  /* (107) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   351,  /* (108) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   351,  /* (109) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   351,  /* (110) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   351,  /* (111) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   351,  /* (112) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   351,  /* (113) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
   351,  /* (114) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
   353,  /* (115) alter_db_options ::= alter_db_option */
   353,  /* (116) alter_db_options ::= alter_db_options alter_db_option */
   360,  /* (117) alter_db_option ::= BUFFER NK_INTEGER */
   360,  /* (118) alter_db_option ::= CACHEMODEL NK_STRING */
   360,  /* (119) alter_db_option ::= CACHESIZE NK_INTEGER */
   360,  /* (120) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   360,  /* (121) alter_db_option ::= KEEP integer_list */
   360,  /* (122) alter_db_option ::= KEEP variable_list */
   360,  /* (123) alter_db_option ::= PAGES NK_INTEGER */
   360,  /* (124) alter_db_option ::= REPLICA NK_INTEGER */
   360,  /* (125) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   360,  /* (126) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   360,  /* (127) alter_db_option ::= MINROWS NK_INTEGER */
   360,  /* (128) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
   360,  /* (129) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   360,  /* (130) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
   360,  /* (131) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   357,  /* (132) integer_list ::= NK_INTEGER */
   357,  /* (133) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   358,  /* (134) variable_list ::= NK_VARIABLE */
   358,  /* (135) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   359,  /* (136) retention_list ::= retention */
   359,  /* (137) retention_list ::= retention_list NK_COMMA retention */
   361,  /* (138) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
   354,  /* (139) speed_opt ::= */
   354,  /* (140) speed_opt ::= MAX_SPEED NK_INTEGER */
   355,  /* (141) start_opt ::= */
   355,  /* (142) start_opt ::= START WITH NK_INTEGER */
   355,  /* (143) start_opt ::= START WITH NK_STRING */
   355,  /* (144) start_opt ::= START WITH TIMESTAMP NK_STRING */
   356,  /* (145) end_opt ::= */
   356,  /* (146) end_opt ::= END WITH NK_INTEGER */
   356,  /* (147) end_opt ::= END WITH NK_STRING */
   356,  /* (148) end_opt ::= END WITH TIMESTAMP NK_STRING */
   332,  /* (149) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   332,  /* (150) cmd ::= CREATE TABLE multi_create_clause */
   332,  /* (151) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   332,  /* (152) cmd ::= DROP TABLE multi_drop_clause */
   332,  /* (153) cmd ::= DROP STABLE exists_opt full_table_name */
   332,  /* (154) cmd ::= ALTER TABLE alter_table_clause */
   332,  /* (155) cmd ::= ALTER STABLE alter_table_clause */
   369,  /* (156) alter_table_clause ::= full_table_name alter_table_options */
   369,  /* (157) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   369,  /* (158) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   369,  /* (159) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   369,  /* (160) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   369,  /* (161) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   369,  /* (162) alter_table_clause ::= full_table_name DROP TAG column_name */
   369,  /* (163) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   369,  /* (164) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   369,  /* (165) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   366,  /* (166) multi_create_clause ::= create_subtable_clause */
   366,  /* (167) multi_create_clause ::= multi_create_clause create_subtable_clause */
   374,  /* (168) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   368,  /* (169) multi_drop_clause ::= drop_table_clause */
   368,  /* (170) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
   377,  /* (171) drop_table_clause ::= exists_opt full_table_name */
   375,  /* (172) specific_cols_opt ::= */
   375,  /* (173) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   362,  /* (174) full_table_name ::= table_name */
   362,  /* (175) full_table_name ::= db_name NK_DOT table_name */
   363,  /* (176) column_def_list ::= column_def */
   363,  /* (177) column_def_list ::= column_def_list NK_COMMA column_def */
   379,  /* (178) column_def ::= column_name type_name */
   372,  /* (179) type_name ::= BOOL */
   372,  /* (180) type_name ::= TINYINT */
   372,  /* (181) type_name ::= SMALLINT */
   372,  /* (182) type_name ::= INT */
   372,  /* (183) type_name ::= INTEGER */
   372,  /* (184) type_name ::= BIGINT */
   372,  /* (185) type_name ::= FLOAT */
   372,  /* (186) type_name ::= DOUBLE */
   372,  /* (187) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   372,  /* (188) type_name ::= TIMESTAMP */
   372,  /* (189) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   372,  /* (190) type_name ::= TINYINT UNSIGNED */
   372,  /* (191) type_name ::= SMALLINT UNSIGNED */
   372,  /* (192) type_name ::= INT UNSIGNED */
   372,  /* (193) type_name ::= BIGINT UNSIGNED */
   372,  /* (194) type_name ::= JSON */
   372,  /* (195) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   372,  /* (196) type_name ::= MEDIUMBLOB */
   372,  /* (197) type_name ::= BLOB */
   372,  /* (198) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   372,  /* (199) type_name ::= DECIMAL */
   372,  /* (200) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   372,  /* (201) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
   364,  /* (202) tags_def_opt ::= */
   364,  /* (203) tags_def_opt ::= tags_def */
   367,  /* (204) tags_def ::= TAGS NK_LP column_def_list NK_RP */
   365,  /* (205) table_options ::= */
   365,  /* (206) table_options ::= table_options COMMENT NK_STRING */
   365,  /* (207) table_options ::= table_options MAX_DELAY duration_list */
   365,  /* (208) table_options ::= table_options WATERMARK duration_list */
   365,  /* (209) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   365,  /* (210) table_options ::= table_options TTL NK_INTEGER */
   365,  /* (211) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   365,  /* (212) table_options ::= table_options DELETE_MARK duration_list */
   370,  /* (213) alter_table_options ::= alter_table_option */
   370,  /* (214) alter_table_options ::= alter_table_options alter_table_option */
   382,  /* (215) alter_table_option ::= COMMENT NK_STRING */
   382,  /* (216) alter_table_option ::= TTL NK_INTEGER */
   380,  /* (217) duration_list ::= duration_literal */
   380,  /* (218) duration_list ::= duration_list NK_COMMA duration_literal */
   381,  /* (219) rollup_func_list ::= rollup_func_name */
   381,  /* (220) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   384,  /* (221) rollup_func_name ::= function_name */
   384,  /* (222) rollup_func_name ::= FIRST */
   384,  /* (223) rollup_func_name ::= LAST */
   378,  /* (224) col_name_list ::= col_name */
   378,  /* (225) col_name_list ::= col_name_list NK_COMMA col_name */
   386,  /* (226) col_name ::= column_name */
   332,  /* (227) cmd ::= SHOW DNODES */
   332,  /* (228) cmd ::= SHOW USERS */
   332,  /* (229) cmd ::= SHOW USER PRIVILEGES */
   332,  /* (230) cmd ::= SHOW DATABASES */
   332,  /* (231) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   332,  /* (232) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   332,  /* (233) cmd ::= SHOW db_name_cond_opt VGROUPS */
   332,  /* (234) cmd ::= SHOW MNODES */
   332,  /* (235) cmd ::= SHOW QNODES */
   332,  /* (236) cmd ::= SHOW FUNCTIONS */
   332,  /* (237) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   332,  /* (238) cmd ::= SHOW STREAMS */
   332,  /* (239) cmd ::= SHOW ACCOUNTS */
   332,  /* (240) cmd ::= SHOW APPS */
   332,  /* (241) cmd ::= SHOW CONNECTIONS */
   332,  /* (242) cmd ::= SHOW LICENCES */
   332,  /* (243) cmd ::= SHOW GRANTS */
   332,  /* (244) cmd ::= SHOW CREATE DATABASE db_name */
   332,  /* (245) cmd ::= SHOW CREATE TABLE full_table_name */
   332,  /* (246) cmd ::= SHOW CREATE STABLE full_table_name */
   332,  /* (247) cmd ::= SHOW QUERIES */
   332,  /* (248) cmd ::= SHOW SCORES */
   332,  /* (249) cmd ::= SHOW TOPICS */
   332,  /* (250) cmd ::= SHOW VARIABLES */
   332,  /* (251) cmd ::= SHOW CLUSTER VARIABLES */
   332,  /* (252) cmd ::= SHOW LOCAL VARIABLES */
   332,  /* (253) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   332,  /* (254) cmd ::= SHOW BNODES */
   332,  /* (255) cmd ::= SHOW SNODES */
   332,  /* (256) cmd ::= SHOW CLUSTER */
   332,  /* (257) cmd ::= SHOW TRANSACTIONS */
   332,  /* (258) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   332,  /* (259) cmd ::= SHOW CONSUMERS */
   332,  /* (260) cmd ::= SHOW SUBSCRIPTIONS */
   332,  /* (261) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   332,  /* (262) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   332,  /* (263) cmd ::= SHOW VNODES NK_INTEGER */
   332,  /* (264) cmd ::= SHOW VNODES NK_STRING */
   332,  /* (265) cmd ::= SHOW db_name_cond_opt ALIVE */
   332,  /* (266) cmd ::= SHOW CLUSTER ALIVE */
   387,  /* (267) db_name_cond_opt ::= */
   387,  /* (268) db_name_cond_opt ::= db_name NK_DOT */
   388,  /* (269) like_pattern_opt ::= */
   388,  /* (270) like_pattern_opt ::= LIKE NK_STRING */
   389,  /* (271) table_name_cond ::= table_name */
   390,  /* (272) from_db_opt ::= */
   390,  /* (273) from_db_opt ::= FROM db_name */
   391,  /* (274) tag_list_opt ::= */
   391,  /* (275) tag_list_opt ::= tag_item */
   391,  /* (276) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   392,  /* (277) tag_item ::= TBNAME */
   392,  /* (278) tag_item ::= QTAGS */
   392,  /* (279) tag_item ::= column_name */
   392,  /* (280) tag_item ::= column_name column_alias */
   392,  /* (281) tag_item ::= column_name AS column_alias */
   332,  /* (282) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   332,  /* (283) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
   332,  /* (284) cmd ::= DROP INDEX exists_opt full_index_name */
   394,  /* (285) full_index_name ::= index_name */
   394,  /* (286) full_index_name ::= db_name NK_DOT index_name */
   395,  /* (287) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
   395,  /* (288) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   397,  /* (289) func_list ::= func */
   397,  /* (290) func_list ::= func_list NK_COMMA func */
   400,  /* (291) func ::= sma_func_name NK_LP expression_list NK_RP */
   401,  /* (292) sma_func_name ::= function_name */
   401,  /* (293) sma_func_name ::= COUNT */
   401,  /* (294) sma_func_name ::= FIRST */
   401,  /* (295) sma_func_name ::= LAST */
   401,  /* (296) sma_func_name ::= LAST_ROW */
   399,  /* (297) sma_stream_opt ::= */
   399,  /* (298) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   399,  /* (299) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   399,  /* (300) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   332,  /* (301) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   332,  /* (302) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   332,  /* (303) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   332,  /* (304) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   332,  /* (305) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   332,  /* (306) cmd ::= DROP TOPIC exists_opt topic_name */
   332,  /* (307) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   332,  /* (308) cmd ::= DESC full_table_name */
   332,  /* (309) cmd ::= DESCRIBE full_table_name */
   332,  /* (310) cmd ::= RESET QUERY CACHE */
   332,  /* (311) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   332,  /* (312) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
   404,  /* (313) analyze_opt ::= */
   404,  /* (314) analyze_opt ::= ANALYZE */
   405,  /* (315) explain_options ::= */
   405,  /* (316) explain_options ::= explain_options VERBOSE NK_BOOL */
   405,  /* (317) explain_options ::= explain_options RATIO NK_FLOAT */
   332,  /* (318) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
   332,  /* (319) cmd ::= DROP FUNCTION exists_opt function_name */
   408,  /* (320) agg_func_opt ::= */
   408,  /* (321) agg_func_opt ::= AGGREGATE */
   409,  /* (322) bufsize_opt ::= */
   409,  /* (323) bufsize_opt ::= BUFSIZE NK_INTEGER */
   410,  /* (324) language_opt ::= */
   410,  /* (325) language_opt ::= LANGUAGE NK_STRING */
   407,  /* (326) or_replace_opt ::= */
   407,  /* (327) or_replace_opt ::= OR REPLACE */
   332,  /* (328) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
   332,  /* (329) cmd ::= DROP STREAM exists_opt stream_name */
   413,  /* (330) col_list_opt ::= */
   413,  /* (331) col_list_opt ::= NK_LP col_name_list NK_RP */
   414,  /* (332) tag_def_or_ref_opt ::= */
   414,  /* (333) tag_def_or_ref_opt ::= tags_def */
   414,  /* (334) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
   412,  /* (335) stream_options ::= */
   412,  /* (336) stream_options ::= stream_options TRIGGER AT_ONCE */
   412,  /* (337) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   412,  /* (338) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   412,  /* (339) stream_options ::= stream_options WATERMARK duration_literal */
   412,  /* (340) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   412,  /* (341) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   412,  /* (342) stream_options ::= stream_options DELETE_MARK duration_literal */
   412,  /* (343) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
   415,  /* (344) subtable_opt ::= */
   415,  /* (345) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   332,  /* (346) cmd ::= KILL CONNECTION NK_INTEGER */
   332,  /* (347) cmd ::= KILL QUERY NK_STRING */
   332,  /* (348) cmd ::= KILL TRANSACTION NK_INTEGER */
   332,  /* (349) cmd ::= BALANCE VGROUP */
   332,  /* (350) cmd ::= BALANCE VGROUP LEADER */
   332,  /* (351) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   332,  /* (352) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   332,  /* (353) cmd ::= SPLIT VGROUP NK_INTEGER */
   417,  /* (354) dnode_list ::= DNODE NK_INTEGER */
   417,  /* (355) dnode_list ::= dnode_list DNODE NK_INTEGER */
   332,  /* (356) cmd ::= DELETE FROM full_table_name where_clause_opt */
   332,  /* (357) cmd ::= query_or_subquery */
   332,  /* (358) cmd ::= insert_query */
   406,  /* (359) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   406,  /* (360) insert_query ::= INSERT INTO full_table_name query_or_subquery */
   335,  /* (361) literal ::= NK_INTEGER */
   335,  /* (362) literal ::= NK_FLOAT */
   335,  /* (363) literal ::= NK_STRING */
   335,  /* (364) literal ::= NK_BOOL */
   335,  /* (365) literal ::= TIMESTAMP NK_STRING */
   335,  /* (366) literal ::= duration_literal */
   335,  /* (367) literal ::= NULL */
   335,  /* (368) literal ::= NK_QUESTION */
   383,  /* (369) duration_literal ::= NK_VARIABLE */
   419,  /* (370) signed ::= NK_INTEGER */
   419,  /* (371) signed ::= NK_PLUS NK_INTEGER */
   419,  /* (372) signed ::= NK_MINUS NK_INTEGER */
   419,  /* (373) signed ::= NK_FLOAT */
   419,  /* (374) signed ::= NK_PLUS NK_FLOAT */
   419,  /* (375) signed ::= NK_MINUS NK_FLOAT */
   373,  /* (376) signed_literal ::= signed */
   373,  /* (377) signed_literal ::= NK_STRING */
   373,  /* (378) signed_literal ::= NK_BOOL */
   373,  /* (379) signed_literal ::= TIMESTAMP NK_STRING */
   373,  /* (380) signed_literal ::= duration_literal */
   373,  /* (381) signed_literal ::= NULL */
   373,  /* (382) signed_literal ::= literal_func */
   373,  /* (383) signed_literal ::= NK_QUESTION */
   421,  /* (384) literal_list ::= signed_literal */
   421,  /* (385) literal_list ::= literal_list NK_COMMA signed_literal */
   344,  /* (386) db_name ::= NK_ID */
   345,  /* (387) table_name ::= NK_ID */
   371,  /* (388) column_name ::= NK_ID */
   385,  /* (389) function_name ::= NK_ID */
   422,  /* (390) table_alias ::= NK_ID */
   393,  /* (391) column_alias ::= NK_ID */
   337,  /* (392) user_name ::= NK_ID */
   346,  /* (393) topic_name ::= NK_ID */
   411,  /* (394) stream_name ::= NK_ID */
   403,  /* (395) cgroup_name ::= NK_ID */
   396,  /* (396) index_name ::= NK_ID */
   423,  /* (397) expr_or_subquery ::= expression */
   416,  /* (398) expression ::= literal */
   416,  /* (399) expression ::= pseudo_column */
   416,  /* (400) expression ::= column_reference */
   416,  /* (401) expression ::= function_expression */
   416,  /* (402) expression ::= case_when_expression */
   416,  /* (403) expression ::= NK_LP expression NK_RP */
   416,  /* (404) expression ::= NK_PLUS expr_or_subquery */
   416,  /* (405) expression ::= NK_MINUS expr_or_subquery */
   416,  /* (406) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   416,  /* (407) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   416,  /* (408) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   416,  /* (409) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   416,  /* (410) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   416,  /* (411) expression ::= column_reference NK_ARROW NK_STRING */
   416,  /* (412) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   416,  /* (413) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   376,  /* (414) expression_list ::= expr_or_subquery */
   376,  /* (415) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   425,  /* (416) column_reference ::= column_name */
   425,  /* (417) column_reference ::= table_name NK_DOT column_name */
   424,  /* (418) pseudo_column ::= ROWTS */
   424,  /* (419) pseudo_column ::= TBNAME */
   424,  /* (420) pseudo_column ::= table_name NK_DOT TBNAME */
   424,  /* (421) pseudo_column ::= QSTART */
   424,  /* (422) pseudo_column ::= QEND */
   424,  /* (423) pseudo_column ::= QDURATION */
   424,  /* (424) pseudo_column ::= WSTART */
   424,  /* (425) pseudo_column ::= WEND */
   424,  /* (426) pseudo_column ::= WDURATION */
   424,  /* (427) pseudo_column ::= IROWTS */
   424,  /* (428) pseudo_column ::= ISFILLED */
   424,  /* (429) pseudo_column ::= QTAGS */
   426,  /* (430) function_expression ::= function_name NK_LP expression_list NK_RP */
   426,  /* (431) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   426,  /* (432) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   426,  /* (433) function_expression ::= literal_func */
   420,  /* (434) literal_func ::= noarg_func NK_LP NK_RP */
   420,  /* (435) literal_func ::= NOW */
   430,  /* (436) noarg_func ::= NOW */
   430,  /* (437) noarg_func ::= TODAY */
   430,  /* (438) noarg_func ::= TIMEZONE */
   430,  /* (439) noarg_func ::= DATABASE */
   430,  /* (440) noarg_func ::= CLIENT_VERSION */
   430,  /* (441) noarg_func ::= SERVER_VERSION */
   430,  /* (442) noarg_func ::= SERVER_STATUS */
   430,  /* (443) noarg_func ::= CURRENT_USER */
   430,  /* (444) noarg_func ::= USER */
   428,  /* (445) star_func ::= COUNT */
   428,  /* (446) star_func ::= FIRST */
   428,  /* (447) star_func ::= LAST */
   428,  /* (448) star_func ::= LAST_ROW */
   429,  /* (449) star_func_para_list ::= NK_STAR */
   429,  /* (450) star_func_para_list ::= other_para_list */
   431,  /* (451) other_para_list ::= star_func_para */
   431,  /* (452) other_para_list ::= other_para_list NK_COMMA star_func_para */
   432,  /* (453) star_func_para ::= expr_or_subquery */
   432,  /* (454) star_func_para ::= table_name NK_DOT NK_STAR */
   427,  /* (455) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   427,  /* (456) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   433,  /* (457) when_then_list ::= when_then_expr */
   433,  /* (458) when_then_list ::= when_then_list when_then_expr */
   436,  /* (459) when_then_expr ::= WHEN common_expression THEN common_expression */
   434,  /* (460) case_when_else_opt ::= */
   434,  /* (461) case_when_else_opt ::= ELSE common_expression */
   437,  /* (462) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   437,  /* (463) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   437,  /* (464) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   437,  /* (465) predicate ::= expr_or_subquery IS NULL */
   437,  /* (466) predicate ::= expr_or_subquery IS NOT NULL */
   437,  /* (467) predicate ::= expr_or_subquery in_op in_predicate_value */
   438,  /* (468) compare_op ::= NK_LT */
   438,  /* (469) compare_op ::= NK_GT */
   438,  /* (470) compare_op ::= NK_LE */
   438,  /* (471) compare_op ::= NK_GE */
   438,  /* (472) compare_op ::= NK_NE */
   438,  /* (473) compare_op ::= NK_EQ */
   438,  /* (474) compare_op ::= LIKE */
   438,  /* (475) compare_op ::= NOT LIKE */
   438,  /* (476) compare_op ::= MATCH */
   438,  /* (477) compare_op ::= NMATCH */
   438,  /* (478) compare_op ::= CONTAINS */
   439,  /* (479) in_op ::= IN */
   439,  /* (480) in_op ::= NOT IN */
   440,  /* (481) in_predicate_value ::= NK_LP literal_list NK_RP */
   441,  /* (482) boolean_value_expression ::= boolean_primary */
   441,  /* (483) boolean_value_expression ::= NOT boolean_primary */
   441,  /* (484) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   441,  /* (485) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   442,  /* (486) boolean_primary ::= predicate */
   442,  /* (487) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   435,  /* (488) common_expression ::= expr_or_subquery */
   435,  /* (489) common_expression ::= boolean_value_expression */
   443,  /* (490) from_clause_opt ::= */
   443,  /* (491) from_clause_opt ::= FROM table_reference_list */
   444,  /* (492) table_reference_list ::= table_reference */
   444,  /* (493) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   445,  /* (494) table_reference ::= table_primary */
   445,  /* (495) table_reference ::= joined_table */
   446,  /* (496) table_primary ::= table_name alias_opt */
   446,  /* (497) table_primary ::= db_name NK_DOT table_name alias_opt */
   446,  /* (498) table_primary ::= subquery alias_opt */
   446,  /* (499) table_primary ::= parenthesized_joined_table */
   448,  /* (500) alias_opt ::= */
   448,  /* (501) alias_opt ::= table_alias */
   448,  /* (502) alias_opt ::= AS table_alias */
   450,  /* (503) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   450,  /* (504) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   447,  /* (505) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
   451,  /* (506) join_type ::= */
   451,  /* (507) join_type ::= INNER */
   452,  /* (508) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
   453,  /* (509) set_quantifier_opt ::= */
   453,  /* (510) set_quantifier_opt ::= DISTINCT */
   453,  /* (511) set_quantifier_opt ::= ALL */
   454,  /* (512) select_list ::= select_item */
   454,  /* (513) select_list ::= select_list NK_COMMA select_item */
   462,  /* (514) select_item ::= NK_STAR */
   462,  /* (515) select_item ::= common_expression */
   462,  /* (516) select_item ::= common_expression column_alias */
   462,  /* (517) select_item ::= common_expression AS column_alias */
   462,  /* (518) select_item ::= table_name NK_DOT NK_STAR */
   418,  /* (519) where_clause_opt ::= */
   418,  /* (520) where_clause_opt ::= WHERE search_condition */
   455,  /* (521) partition_by_clause_opt ::= */
   455,  /* (522) partition_by_clause_opt ::= PARTITION BY partition_list */
   463,  /* (523) partition_list ::= partition_item */
   463,  /* (524) partition_list ::= partition_list NK_COMMA partition_item */
   464,  /* (525) partition_item ::= expr_or_subquery */
   464,  /* (526) partition_item ::= expr_or_subquery column_alias */
   464,  /* (527) partition_item ::= expr_or_subquery AS column_alias */
   459,  /* (528) twindow_clause_opt ::= */
   459,  /* (529) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   459,  /* (530) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   459,  /* (531) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   459,  /* (532) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   459,  /* (533) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
   398,  /* (534) sliding_opt ::= */
   398,  /* (535) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
   458,  /* (536) fill_opt ::= */
   458,  /* (537) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   458,  /* (538) fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
   458,  /* (539) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
   465,  /* (540) fill_mode ::= NONE */
   465,  /* (541) fill_mode ::= PREV */
   465,  /* (542) fill_mode ::= NULL */
   465,  /* (543) fill_mode ::= NULL_F */
   465,  /* (544) fill_mode ::= LINEAR */
   465,  /* (545) fill_mode ::= NEXT */
   460,  /* (546) group_by_clause_opt ::= */
   460,  /* (547) group_by_clause_opt ::= GROUP BY group_by_list */
   466,  /* (548) group_by_list ::= expr_or_subquery */
   466,  /* (549) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
   461,  /* (550) having_clause_opt ::= */
   461,  /* (551) having_clause_opt ::= HAVING search_condition */
   456,  /* (552) range_opt ::= */
   456,  /* (553) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
   457,  /* (554) every_opt ::= */
   457,  /* (555) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   467,  /* (556) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   468,  /* (557) query_simple ::= query_specification */
   468,  /* (558) query_simple ::= union_query_expression */
   472,  /* (559) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   472,  /* (560) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   473,  /* (561) query_simple_or_subquery ::= query_simple */
   473,  /* (562) query_simple_or_subquery ::= subquery */
   402,  /* (563) query_or_subquery ::= query_expression */
   402,  /* (564) query_or_subquery ::= subquery */
   469,  /* (565) order_by_clause_opt ::= */
   469,  /* (566) order_by_clause_opt ::= ORDER BY sort_specification_list */
   470,  /* (567) slimit_clause_opt ::= */
   470,  /* (568) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   470,  /* (569) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   470,  /* (570) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   471,  /* (571) limit_clause_opt ::= */
   471,  /* (572) limit_clause_opt ::= LIMIT NK_INTEGER */
   471,  /* (573) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   471,  /* (574) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   449,  /* (575) subquery ::= NK_LP query_expression NK_RP */
   449,  /* (576) subquery ::= NK_LP subquery NK_RP */
   347,  /* (577) search_condition ::= common_expression */
   474,  /* (578) sort_specification_list ::= sort_specification */
   474,  /* (579) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   475,  /* (580) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
   476,  /* (581) ordering_specification_opt ::= */
   476,  /* (582) ordering_specification_opt ::= ASC */
   476,  /* (583) ordering_specification_opt ::= DESC */
   477,  /* (584) null_ordering_opt ::= */
   477,  /* (585) null_ordering_opt ::= NULLS FIRST */
   477,  /* (586) null_ordering_opt ::= NULLS LAST */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -6,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   -4,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
    0,  /* (2) account_options ::= */
   -3,  /* (3) account_options ::= account_options PPS literal */
   -3,  /* (4) account_options ::= account_options TSERIES literal */
   -3,  /* (5) account_options ::= account_options STORAGE literal */
   -3,  /* (6) account_options ::= account_options STREAMS literal */
   -3,  /* (7) account_options ::= account_options QTIME literal */
   -3,  /* (8) account_options ::= account_options DBS literal */
   -3,  /* (9) account_options ::= account_options USERS literal */
   -3,  /* (10) account_options ::= account_options CONNS literal */
   -3,  /* (11) account_options ::= account_options STATE literal */
   -1,  /* (12) alter_account_options ::= alter_account_option */
   -2,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   -2,  /* (14) alter_account_option ::= PASS literal */
   -2,  /* (15) alter_account_option ::= PPS literal */
   -2,  /* (16) alter_account_option ::= TSERIES literal */
   -2,  /* (17) alter_account_option ::= STORAGE literal */
   -2,  /* (18) alter_account_option ::= STREAMS literal */
   -2,  /* (19) alter_account_option ::= QTIME literal */
   -2,  /* (20) alter_account_option ::= DBS literal */
   -2,  /* (21) alter_account_option ::= USERS literal */
   -2,  /* (22) alter_account_option ::= CONNS literal */
   -2,  /* (23) alter_account_option ::= STATE literal */
   -6,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   -5,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   -5,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   -5,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   -3,  /* (28) cmd ::= DROP USER user_name */
    0,  /* (29) sysinfo_opt ::= */
   -2,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   -7,  /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
   -7,  /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
   -1,  /* (33) privileges ::= ALL */
   -1,  /* (34) privileges ::= priv_type_list */
   -1,  /* (35) privileges ::= SUBSCRIBE */
   -1,  /* (36) priv_type_list ::= priv_type */
   -3,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   -1,  /* (38) priv_type ::= READ */
   -1,  /* (39) priv_type ::= WRITE */
   -3,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   -3,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   -3,  /* (42) priv_level ::= db_name NK_DOT table_name */
   -1,  /* (43) priv_level ::= topic_name */
    0,  /* (44) with_opt ::= */
   -2,  /* (45) with_opt ::= WITH search_condition */
   -3,  /* (46) cmd ::= CREATE DNODE dnode_endpoint */
   -5,  /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   -4,  /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
   -4,  /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
   -4,  /* (50) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   -5,  /* (51) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   -4,  /* (52) cmd ::= ALTER ALL DNODES NK_STRING */
   -5,  /* (53) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   -3,  /* (54) cmd ::= RESTORE DNODE NK_INTEGER */
   -1,  /* (55) dnode_endpoint ::= NK_STRING */
   -1,  /* (56) dnode_endpoint ::= NK_ID */
   -1,  /* (57) dnode_endpoint ::= NK_IPTOKEN */
    0,  /* (58) force_opt ::= */
   -1,  /* (59) force_opt ::= FORCE */
   -3,  /* (60) cmd ::= ALTER LOCAL NK_STRING */
   -4,  /* (61) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   -5,  /* (62) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   -5,  /* (63) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   -5,  /* (64) cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
   -5,  /* (65) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   -5,  /* (66) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   -5,  /* (67) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   -5,  /* (68) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   -5,  /* (69) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   -5,  /* (70) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   -5,  /* (71) cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
   -5,  /* (72) cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
   -5,  /* (73) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   -4,  /* (74) cmd ::= DROP DATABASE exists_opt db_name */
   -2,  /* (75) cmd ::= USE db_name */
   -4,  /* (76) cmd ::= ALTER DATABASE db_name alter_db_options */
   -3,  /* (77) cmd ::= FLUSH DATABASE db_name */
   -4,  /* (78) cmd ::= TRIM DATABASE db_name speed_opt */
   -5,  /* (79) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
   -3,  /* (80) not_exists_opt ::= IF NOT EXISTS */
    0,  /* (81) not_exists_opt ::= */
   -2,  /* (82) exists_opt ::= IF EXISTS */
    0,  /* (83) exists_opt ::= */
    0,  /* (84) db_options ::= */
   -3,  /* (85) db_options ::= db_options BUFFER NK_INTEGER */
   -3,  /* (86) db_options ::= db_options CACHEMODEL NK_STRING */
   -3,  /* (87) db_options ::= db_options CACHESIZE NK_INTEGER */
   -3,  /* (88) db_options ::= db_options COMP NK_INTEGER */
   -3,  /* (89) db_options ::= db_options DURATION NK_INTEGER */
   -3,  /* (90) db_options ::= db_options DURATION NK_VARIABLE */
   -3,  /* (91) db_options ::= db_options MAXROWS NK_INTEGER */
   -3,  /* (92) db_options ::= db_options MINROWS NK_INTEGER */
   -3,  /* (93) db_options ::= db_options KEEP integer_list */
   -3,  /* (94) db_options ::= db_options KEEP variable_list */
   -3,  /* (95) db_options ::= db_options PAGES NK_INTEGER */
   -3,  /* (96) db_options ::= db_options PAGESIZE NK_INTEGER */
   -3,  /* (97) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   -3,  /* (98) db_options ::= db_options PRECISION NK_STRING */
   -3,  /* (99) db_options ::= db_options REPLICA NK_INTEGER */
   -3,  /* (100) db_options ::= db_options VGROUPS NK_INTEGER */
   -3,  /* (101) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   -3,  /* (102) db_options ::= db_options RETENTIONS retention_list */
   -3,  /* (103) db_options ::= db_options SCHEMALESS NK_INTEGER */
   -3,  /* (104) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   -3,  /* (105) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   -3,  /* (106) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   -4,  /* (107) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -3,  /* (108) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   -4,  /* (109) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -3,  /* (110) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   -3,  /* (111) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   -3,  /* (112) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   -3,  /* (113) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
   -3,  /* (114) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
   -1,  /* (115) alter_db_options ::= alter_db_option */
   -2,  /* (116) alter_db_options ::= alter_db_options alter_db_option */
   -2,  /* (117) alter_db_option ::= BUFFER NK_INTEGER */
   -2,  /* (118) alter_db_option ::= CACHEMODEL NK_STRING */
   -2,  /* (119) alter_db_option ::= CACHESIZE NK_INTEGER */
   -2,  /* (120) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   -2,  /* (121) alter_db_option ::= KEEP integer_list */
   -2,  /* (122) alter_db_option ::= KEEP variable_list */
   -2,  /* (123) alter_db_option ::= PAGES NK_INTEGER */
   -2,  /* (124) alter_db_option ::= REPLICA NK_INTEGER */
   -2,  /* (125) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   -2,  /* (126) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   -2,  /* (127) alter_db_option ::= MINROWS NK_INTEGER */
   -2,  /* (128) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
   -3,  /* (129) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -2,  /* (130) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
   -3,  /* (131) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -1,  /* (132) integer_list ::= NK_INTEGER */
   -3,  /* (133) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   -1,  /* (134) variable_list ::= NK_VARIABLE */
   -3,  /* (135) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   -1,  /* (136) retention_list ::= retention */
   -3,  /* (137) retention_list ::= retention_list NK_COMMA retention */
   -3,  /* (138) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
    0,  /* (139) speed_opt ::= */
   -2,  /* (140) speed_opt ::= MAX_SPEED NK_INTEGER */
    0,  /* (141) start_opt ::= */
   -3,  /* (142) start_opt ::= START WITH NK_INTEGER */
   -3,  /* (143) start_opt ::= START WITH NK_STRING */
   -4,  /* (144) start_opt ::= START WITH TIMESTAMP NK_STRING */
    0,  /* (145) end_opt ::= */
   -3,  /* (146) end_opt ::= END WITH NK_INTEGER */
   -3,  /* (147) end_opt ::= END WITH NK_STRING */
   -4,  /* (148) end_opt ::= END WITH TIMESTAMP NK_STRING */
   -9,  /* (149) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   -3,  /* (150) cmd ::= CREATE TABLE multi_create_clause */
   -9,  /* (151) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   -3,  /* (152) cmd ::= DROP TABLE multi_drop_clause */
   -4,  /* (153) cmd ::= DROP STABLE exists_opt full_table_name */
   -3,  /* (154) cmd ::= ALTER TABLE alter_table_clause */
   -3,  /* (155) cmd ::= ALTER STABLE alter_table_clause */
   -2,  /* (156) alter_table_clause ::= full_table_name alter_table_options */
   -5,  /* (157) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   -4,  /* (158) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   -5,  /* (159) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   -5,  /* (160) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   -5,  /* (161) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   -4,  /* (162) alter_table_clause ::= full_table_name DROP TAG column_name */
   -5,  /* (163) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   -5,  /* (164) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   -6,  /* (165) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   -1,  /* (166) multi_create_clause ::= create_subtable_clause */
   -2,  /* (167) multi_create_clause ::= multi_create_clause create_subtable_clause */
  -10,  /* (168) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   -1,  /* (169) multi_drop_clause ::= drop_table_clause */
   -3,  /* (170) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
   -2,  /* (171) drop_table_clause ::= exists_opt full_table_name */
    0,  /* (172) specific_cols_opt ::= */
   -3,  /* (173) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   -1,  /* (174) full_table_name ::= table_name */
   -3,  /* (175) full_table_name ::= db_name NK_DOT table_name */
   -1,  /* (176) column_def_list ::= column_def */
   -3,  /* (177) column_def_list ::= column_def_list NK_COMMA column_def */
   -2,  /* (178) column_def ::= column_name type_name */
   -1,  /* (179) type_name ::= BOOL */
   -1,  /* (180) type_name ::= TINYINT */
   -1,  /* (181) type_name ::= SMALLINT */
   -1,  /* (182) type_name ::= INT */
   -1,  /* (183) type_name ::= INTEGER */
   -1,  /* (184) type_name ::= BIGINT */
   -1,  /* (185) type_name ::= FLOAT */
   -1,  /* (186) type_name ::= DOUBLE */
   -4,  /* (187) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (188) type_name ::= TIMESTAMP */
   -4,  /* (189) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   -2,  /* (190) type_name ::= TINYINT UNSIGNED */
   -2,  /* (191) type_name ::= SMALLINT UNSIGNED */
   -2,  /* (192) type_name ::= INT UNSIGNED */
   -2,  /* (193) type_name ::= BIGINT UNSIGNED */
   -1,  /* (194) type_name ::= JSON */
   -4,  /* (195) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   -1,  /* (196) type_name ::= MEDIUMBLOB */
   -1,  /* (197) type_name ::= BLOB */
   -4,  /* (198) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (199) type_name ::= DECIMAL */
   -4,  /* (200) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   -6,  /* (201) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
    0,  /* (202) tags_def_opt ::= */
   -1,  /* (203) tags_def_opt ::= tags_def */
   -4,  /* (204) tags_def ::= TAGS NK_LP column_def_list NK_RP */
    0,  /* (205) table_options ::= */
   -3,  /* (206) table_options ::= table_options COMMENT NK_STRING */
   -3,  /* (207) table_options ::= table_options MAX_DELAY duration_list */
   -3,  /* (208) table_options ::= table_options WATERMARK duration_list */
   -5,  /* (209) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   -3,  /* (210) table_options ::= table_options TTL NK_INTEGER */
   -5,  /* (211) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   -3,  /* (212) table_options ::= table_options DELETE_MARK duration_list */
   -1,  /* (213) alter_table_options ::= alter_table_option */
   -2,  /* (214) alter_table_options ::= alter_table_options alter_table_option */
   -2,  /* (215) alter_table_option ::= COMMENT NK_STRING */
   -2,  /* (216) alter_table_option ::= TTL NK_INTEGER */
   -1,  /* (217) duration_list ::= duration_literal */
   -3,  /* (218) duration_list ::= duration_list NK_COMMA duration_literal */
   -1,  /* (219) rollup_func_list ::= rollup_func_name */
   -3,  /* (220) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   -1,  /* (221) rollup_func_name ::= function_name */
   -1,  /* (222) rollup_func_name ::= FIRST */
   -1,  /* (223) rollup_func_name ::= LAST */
   -1,  /* (224) col_name_list ::= col_name */
   -3,  /* (225) col_name_list ::= col_name_list NK_COMMA col_name */
   -1,  /* (226) col_name ::= column_name */
   -2,  /* (227) cmd ::= SHOW DNODES */
   -2,  /* (228) cmd ::= SHOW USERS */
   -3,  /* (229) cmd ::= SHOW USER PRIVILEGES */
   -2,  /* (230) cmd ::= SHOW DATABASES */
   -4,  /* (231) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   -4,  /* (232) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   -3,  /* (233) cmd ::= SHOW db_name_cond_opt VGROUPS */
   -2,  /* (234) cmd ::= SHOW MNODES */
   -2,  /* (235) cmd ::= SHOW QNODES */
   -2,  /* (236) cmd ::= SHOW FUNCTIONS */
   -5,  /* (237) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   -2,  /* (238) cmd ::= SHOW STREAMS */
   -2,  /* (239) cmd ::= SHOW ACCOUNTS */
   -2,  /* (240) cmd ::= SHOW APPS */
   -2,  /* (241) cmd ::= SHOW CONNECTIONS */
   -2,  /* (242) cmd ::= SHOW LICENCES */
   -2,  /* (243) cmd ::= SHOW GRANTS */
   -4,  /* (244) cmd ::= SHOW CREATE DATABASE db_name */
   -4,  /* (245) cmd ::= SHOW CREATE TABLE full_table_name */
   -4,  /* (246) cmd ::= SHOW CREATE STABLE full_table_name */
   -2,  /* (247) cmd ::= SHOW QUERIES */
   -2,  /* (248) cmd ::= SHOW SCORES */
   -2,  /* (249) cmd ::= SHOW TOPICS */
   -2,  /* (250) cmd ::= SHOW VARIABLES */
   -3,  /* (251) cmd ::= SHOW CLUSTER VARIABLES */
   -3,  /* (252) cmd ::= SHOW LOCAL VARIABLES */
   -5,  /* (253) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   -2,  /* (254) cmd ::= SHOW BNODES */
   -2,  /* (255) cmd ::= SHOW SNODES */
   -2,  /* (256) cmd ::= SHOW CLUSTER */
   -2,  /* (257) cmd ::= SHOW TRANSACTIONS */
   -4,  /* (258) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   -2,  /* (259) cmd ::= SHOW CONSUMERS */
   -2,  /* (260) cmd ::= SHOW SUBSCRIPTIONS */
   -5,  /* (261) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   -7,  /* (262) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   -3,  /* (263) cmd ::= SHOW VNODES NK_INTEGER */
   -3,  /* (264) cmd ::= SHOW VNODES NK_STRING */
   -3,  /* (265) cmd ::= SHOW db_name_cond_opt ALIVE */
   -3,  /* (266) cmd ::= SHOW CLUSTER ALIVE */
    0,  /* (267) db_name_cond_opt ::= */
   -2,  /* (268) db_name_cond_opt ::= db_name NK_DOT */
    0,  /* (269) like_pattern_opt ::= */
   -2,  /* (270) like_pattern_opt ::= LIKE NK_STRING */
   -1,  /* (271) table_name_cond ::= table_name */
    0,  /* (272) from_db_opt ::= */
   -2,  /* (273) from_db_opt ::= FROM db_name */
    0,  /* (274) tag_list_opt ::= */
   -1,  /* (275) tag_list_opt ::= tag_item */
   -3,  /* (276) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   -1,  /* (277) tag_item ::= TBNAME */
   -1,  /* (278) tag_item ::= QTAGS */
   -1,  /* (279) tag_item ::= column_name */
   -2,  /* (280) tag_item ::= column_name column_alias */
   -3,  /* (281) tag_item ::= column_name AS column_alias */
   -8,  /* (282) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   -9,  /* (283) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
   -4,  /* (284) cmd ::= DROP INDEX exists_opt full_index_name */
   -1,  /* (285) full_index_name ::= index_name */
   -3,  /* (286) full_index_name ::= db_name NK_DOT index_name */
  -10,  /* (287) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  -12,  /* (288) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   -1,  /* (289) func_list ::= func */
   -3,  /* (290) func_list ::= func_list NK_COMMA func */
   -4,  /* (291) func ::= sma_func_name NK_LP expression_list NK_RP */
   -1,  /* (292) sma_func_name ::= function_name */
   -1,  /* (293) sma_func_name ::= COUNT */
   -1,  /* (294) sma_func_name ::= FIRST */
   -1,  /* (295) sma_func_name ::= LAST */
   -1,  /* (296) sma_func_name ::= LAST_ROW */
    0,  /* (297) sma_stream_opt ::= */
   -3,  /* (298) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   -3,  /* (299) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   -3,  /* (300) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   -6,  /* (301) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   -7,  /* (302) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   -9,  /* (303) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   -7,  /* (304) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   -9,  /* (305) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   -4,  /* (306) cmd ::= DROP TOPIC exists_opt topic_name */
   -7,  /* (307) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   -2,  /* (308) cmd ::= DESC full_table_name */
   -2,  /* (309) cmd ::= DESCRIBE full_table_name */
   -3,  /* (310) cmd ::= RESET QUERY CACHE */
   -4,  /* (311) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   -4,  /* (312) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
    0,  /* (313) analyze_opt ::= */
   -1,  /* (314) analyze_opt ::= ANALYZE */
    0,  /* (315) explain_options ::= */
   -3,  /* (316) explain_options ::= explain_options VERBOSE NK_BOOL */
   -3,  /* (317) explain_options ::= explain_options RATIO NK_FLOAT */
  -12,  /* (318) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
   -4,  /* (319) cmd ::= DROP FUNCTION exists_opt function_name */
    0,  /* (320) agg_func_opt ::= */
   -1,  /* (321) agg_func_opt ::= AGGREGATE */
    0,  /* (322) bufsize_opt ::= */
   -2,  /* (323) bufsize_opt ::= BUFSIZE NK_INTEGER */
    0,  /* (324) language_opt ::= */
   -2,  /* (325) language_opt ::= LANGUAGE NK_STRING */
    0,  /* (326) or_replace_opt ::= */
   -2,  /* (327) or_replace_opt ::= OR REPLACE */
  -12,  /* (328) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
   -4,  /* (329) cmd ::= DROP STREAM exists_opt stream_name */
    0,  /* (330) col_list_opt ::= */
   -3,  /* (331) col_list_opt ::= NK_LP col_name_list NK_RP */
    0,  /* (332) tag_def_or_ref_opt ::= */
   -1,  /* (333) tag_def_or_ref_opt ::= tags_def */
   -4,  /* (334) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
    0,  /* (335) stream_options ::= */
   -3,  /* (336) stream_options ::= stream_options TRIGGER AT_ONCE */
   -3,  /* (337) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   -4,  /* (338) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   -3,  /* (339) stream_options ::= stream_options WATERMARK duration_literal */
   -4,  /* (340) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   -3,  /* (341) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   -3,  /* (342) stream_options ::= stream_options DELETE_MARK duration_literal */
   -4,  /* (343) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
    0,  /* (344) subtable_opt ::= */
   -4,  /* (345) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   -3,  /* (346) cmd ::= KILL CONNECTION NK_INTEGER */
   -3,  /* (347) cmd ::= KILL QUERY NK_STRING */
   -3,  /* (348) cmd ::= KILL TRANSACTION NK_INTEGER */
   -2,  /* (349) cmd ::= BALANCE VGROUP */
   -3,  /* (350) cmd ::= BALANCE VGROUP LEADER */
   -4,  /* (351) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   -4,  /* (352) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   -3,  /* (353) cmd ::= SPLIT VGROUP NK_INTEGER */
   -2,  /* (354) dnode_list ::= DNODE NK_INTEGER */
   -3,  /* (355) dnode_list ::= dnode_list DNODE NK_INTEGER */
   -4,  /* (356) cmd ::= DELETE FROM full_table_name where_clause_opt */
   -1,  /* (357) cmd ::= query_or_subquery */
   -1,  /* (358) cmd ::= insert_query */
   -7,  /* (359) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   -4,  /* (360) insert_query ::= INSERT INTO full_table_name query_or_subquery */
   -1,  /* (361) literal ::= NK_INTEGER */
   -1,  /* (362) literal ::= NK_FLOAT */
   -1,  /* (363) literal ::= NK_STRING */
   -1,  /* (364) literal ::= NK_BOOL */
   -2,  /* (365) literal ::= TIMESTAMP NK_STRING */
   -1,  /* (366) literal ::= duration_literal */
   -1,  /* (367) literal ::= NULL */
   -1,  /* (368) literal ::= NK_QUESTION */
   -1,  /* (369) duration_literal ::= NK_VARIABLE */
   -1,  /* (370) signed ::= NK_INTEGER */
   -2,  /* (371) signed ::= NK_PLUS NK_INTEGER */
   -2,  /* (372) signed ::= NK_MINUS NK_INTEGER */
   -1,  /* (373) signed ::= NK_FLOAT */
   -2,  /* (374) signed ::= NK_PLUS NK_FLOAT */
   -2,  /* (375) signed ::= NK_MINUS NK_FLOAT */
   -1,  /* (376) signed_literal ::= signed */
   -1,  /* (377) signed_literal ::= NK_STRING */
   -1,  /* (378) signed_literal ::= NK_BOOL */
   -2,  /* (379) signed_literal ::= TIMESTAMP NK_STRING */
   -1,  /* (380) signed_literal ::= duration_literal */
   -1,  /* (381) signed_literal ::= NULL */
   -1,  /* (382) signed_literal ::= literal_func */
   -1,  /* (383) signed_literal ::= NK_QUESTION */
   -1,  /* (384) literal_list ::= signed_literal */
   -3,  /* (385) literal_list ::= literal_list NK_COMMA signed_literal */
   -1,  /* (386) db_name ::= NK_ID */
   -1,  /* (387) table_name ::= NK_ID */
   -1,  /* (388) column_name ::= NK_ID */
   -1,  /* (389) function_name ::= NK_ID */
   -1,  /* (390) table_alias ::= NK_ID */
   -1,  /* (391) column_alias ::= NK_ID */
   -1,  /* (392) user_name ::= NK_ID */
   -1,  /* (393) topic_name ::= NK_ID */
   -1,  /* (394) stream_name ::= NK_ID */
   -1,  /* (395) cgroup_name ::= NK_ID */
   -1,  /* (396) index_name ::= NK_ID */
   -1,  /* (397) expr_or_subquery ::= expression */
   -1,  /* (398) expression ::= literal */
   -1,  /* (399) expression ::= pseudo_column */
   -1,  /* (400) expression ::= column_reference */
   -1,  /* (401) expression ::= function_expression */
   -1,  /* (402) expression ::= case_when_expression */
   -3,  /* (403) expression ::= NK_LP expression NK_RP */
   -2,  /* (404) expression ::= NK_PLUS expr_or_subquery */
   -2,  /* (405) expression ::= NK_MINUS expr_or_subquery */
   -3,  /* (406) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   -3,  /* (407) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   -3,  /* (408) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   -3,  /* (409) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   -3,  /* (410) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   -3,  /* (411) expression ::= column_reference NK_ARROW NK_STRING */
   -3,  /* (412) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   -3,  /* (413) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   -1,  /* (414) expression_list ::= expr_or_subquery */
   -3,  /* (415) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   -1,  /* (416) column_reference ::= column_name */
   -3,  /* (417) column_reference ::= table_name NK_DOT column_name */
   -1,  /* (418) pseudo_column ::= ROWTS */
   -1,  /* (419) pseudo_column ::= TBNAME */
   -3,  /* (420) pseudo_column ::= table_name NK_DOT TBNAME */
   -1,  /* (421) pseudo_column ::= QSTART */
   -1,  /* (422) pseudo_column ::= QEND */
   -1,  /* (423) pseudo_column ::= QDURATION */
   -1,  /* (424) pseudo_column ::= WSTART */
   -1,  /* (425) pseudo_column ::= WEND */
   -1,  /* (426) pseudo_column ::= WDURATION */
   -1,  /* (427) pseudo_column ::= IROWTS */
   -1,  /* (428) pseudo_column ::= ISFILLED */
   -1,  /* (429) pseudo_column ::= QTAGS */
   -4,  /* (430) function_expression ::= function_name NK_LP expression_list NK_RP */
   -4,  /* (431) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   -6,  /* (432) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   -1,  /* (433) function_expression ::= literal_func */
   -3,  /* (434) literal_func ::= noarg_func NK_LP NK_RP */
   -1,  /* (435) literal_func ::= NOW */
   -1,  /* (436) noarg_func ::= NOW */
   -1,  /* (437) noarg_func ::= TODAY */
   -1,  /* (438) noarg_func ::= TIMEZONE */
   -1,  /* (439) noarg_func ::= DATABASE */
   -1,  /* (440) noarg_func ::= CLIENT_VERSION */
   -1,  /* (441) noarg_func ::= SERVER_VERSION */
   -1,  /* (442) noarg_func ::= SERVER_STATUS */
   -1,  /* (443) noarg_func ::= CURRENT_USER */
   -1,  /* (444) noarg_func ::= USER */
   -1,  /* (445) star_func ::= COUNT */
   -1,  /* (446) star_func ::= FIRST */
   -1,  /* (447) star_func ::= LAST */
   -1,  /* (448) star_func ::= LAST_ROW */
   -1,  /* (449) star_func_para_list ::= NK_STAR */
   -1,  /* (450) star_func_para_list ::= other_para_list */
   -1,  /* (451) other_para_list ::= star_func_para */
   -3,  /* (452) other_para_list ::= other_para_list NK_COMMA star_func_para */
   -1,  /* (453) star_func_para ::= expr_or_subquery */
   -3,  /* (454) star_func_para ::= table_name NK_DOT NK_STAR */
   -4,  /* (455) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   -5,  /* (456) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   -1,  /* (457) when_then_list ::= when_then_expr */
   -2,  /* (458) when_then_list ::= when_then_list when_then_expr */
   -4,  /* (459) when_then_expr ::= WHEN common_expression THEN common_expression */
    0,  /* (460) case_when_else_opt ::= */
   -2,  /* (461) case_when_else_opt ::= ELSE common_expression */
   -3,  /* (462) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   -5,  /* (463) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   -6,  /* (464) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   -3,  /* (465) predicate ::= expr_or_subquery IS NULL */
   -4,  /* (466) predicate ::= expr_or_subquery IS NOT NULL */
   -3,  /* (467) predicate ::= expr_or_subquery in_op in_predicate_value */
   -1,  /* (468) compare_op ::= NK_LT */
   -1,  /* (469) compare_op ::= NK_GT */
   -1,  /* (470) compare_op ::= NK_LE */
   -1,  /* (471) compare_op ::= NK_GE */
   -1,  /* (472) compare_op ::= NK_NE */
   -1,  /* (473) compare_op ::= NK_EQ */
   -1,  /* (474) compare_op ::= LIKE */
   -2,  /* (475) compare_op ::= NOT LIKE */
   -1,  /* (476) compare_op ::= MATCH */
   -1,  /* (477) compare_op ::= NMATCH */
   -1,  /* (478) compare_op ::= CONTAINS */
   -1,  /* (479) in_op ::= IN */
   -2,  /* (480) in_op ::= NOT IN */
   -3,  /* (481) in_predicate_value ::= NK_LP literal_list NK_RP */
   -1,  /* (482) boolean_value_expression ::= boolean_primary */
   -2,  /* (483) boolean_value_expression ::= NOT boolean_primary */
   -3,  /* (484) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   -3,  /* (485) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   -1,  /* (486) boolean_primary ::= predicate */
   -3,  /* (487) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   -1,  /* (488) common_expression ::= expr_or_subquery */
   -1,  /* (489) common_expression ::= boolean_value_expression */
    0,  /* (490) from_clause_opt ::= */
   -2,  /* (491) from_clause_opt ::= FROM table_reference_list */
   -1,  /* (492) table_reference_list ::= table_reference */
   -3,  /* (493) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   -1,  /* (494) table_reference ::= table_primary */
   -1,  /* (495) table_reference ::= joined_table */
   -2,  /* (496) table_primary ::= table_name alias_opt */
   -4,  /* (497) table_primary ::= db_name NK_DOT table_name alias_opt */
   -2,  /* (498) table_primary ::= subquery alias_opt */
   -1,  /* (499) table_primary ::= parenthesized_joined_table */
    0,  /* (500) alias_opt ::= */
   -1,  /* (501) alias_opt ::= table_alias */
   -2,  /* (502) alias_opt ::= AS table_alias */
   -3,  /* (503) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   -3,  /* (504) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   -6,  /* (505) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
    0,  /* (506) join_type ::= */
   -1,  /* (507) join_type ::= INNER */
  -12,  /* (508) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
    0,  /* (509) set_quantifier_opt ::= */
   -1,  /* (510) set_quantifier_opt ::= DISTINCT */
   -1,  /* (511) set_quantifier_opt ::= ALL */
   -1,  /* (512) select_list ::= select_item */
   -3,  /* (513) select_list ::= select_list NK_COMMA select_item */
   -1,  /* (514) select_item ::= NK_STAR */
   -1,  /* (515) select_item ::= common_expression */
   -2,  /* (516) select_item ::= common_expression column_alias */
   -3,  /* (517) select_item ::= common_expression AS column_alias */
   -3,  /* (518) select_item ::= table_name NK_DOT NK_STAR */
    0,  /* (519) where_clause_opt ::= */
   -2,  /* (520) where_clause_opt ::= WHERE search_condition */
    0,  /* (521) partition_by_clause_opt ::= */
   -3,  /* (522) partition_by_clause_opt ::= PARTITION BY partition_list */
   -1,  /* (523) partition_list ::= partition_item */
   -3,  /* (524) partition_list ::= partition_list NK_COMMA partition_item */
   -1,  /* (525) partition_item ::= expr_or_subquery */
   -2,  /* (526) partition_item ::= expr_or_subquery column_alias */
   -3,  /* (527) partition_item ::= expr_or_subquery AS column_alias */
    0,  /* (528) twindow_clause_opt ::= */
   -6,  /* (529) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   -4,  /* (530) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   -6,  /* (531) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   -8,  /* (532) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   -7,  /* (533) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
    0,  /* (534) sliding_opt ::= */
   -4,  /* (535) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
    0,  /* (536) fill_opt ::= */
   -4,  /* (537) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   -6,  /* (538) fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
   -6,  /* (539) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
   -1,  /* (540) fill_mode ::= NONE */
   -1,  /* (541) fill_mode ::= PREV */
   -1,  /* (542) fill_mode ::= NULL */
   -1,  /* (543) fill_mode ::= NULL_F */
   -1,  /* (544) fill_mode ::= LINEAR */
   -1,  /* (545) fill_mode ::= NEXT */
    0,  /* (546) group_by_clause_opt ::= */
   -3,  /* (547) group_by_clause_opt ::= GROUP BY group_by_list */
   -1,  /* (548) group_by_list ::= expr_or_subquery */
   -3,  /* (549) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
    0,  /* (550) having_clause_opt ::= */
   -2,  /* (551) having_clause_opt ::= HAVING search_condition */
    0,  /* (552) range_opt ::= */
   -6,  /* (553) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
    0,  /* (554) every_opt ::= */
   -4,  /* (555) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   -4,  /* (556) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   -1,  /* (557) query_simple ::= query_specification */
   -1,  /* (558) query_simple ::= union_query_expression */
   -4,  /* (559) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   -3,  /* (560) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   -1,  /* (561) query_simple_or_subquery ::= query_simple */
   -1,  /* (562) query_simple_or_subquery ::= subquery */
   -1,  /* (563) query_or_subquery ::= query_expression */
   -1,  /* (564) query_or_subquery ::= subquery */
    0,  /* (565) order_by_clause_opt ::= */
   -3,  /* (566) order_by_clause_opt ::= ORDER BY sort_specification_list */
    0,  /* (567) slimit_clause_opt ::= */
   -2,  /* (568) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   -4,  /* (569) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   -4,  /* (570) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
    0,  /* (571) limit_clause_opt ::= */
   -2,  /* (572) limit_clause_opt ::= LIMIT NK_INTEGER */
   -4,  /* (573) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   -4,  /* (574) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   -3,  /* (575) subquery ::= NK_LP query_expression NK_RP */
   -3,  /* (576) subquery ::= NK_LP subquery NK_RP */
   -1,  /* (577) search_condition ::= common_expression */
   -1,  /* (578) sort_specification_list ::= sort_specification */
   -3,  /* (579) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   -3,  /* (580) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
    0,  /* (581) ordering_specification_opt ::= */
   -1,  /* (582) ordering_specification_opt ::= ASC */
   -1,  /* (583) ordering_specification_opt ::= DESC */
    0,  /* (584) null_ordering_opt ::= */
   -2,  /* (585) null_ordering_opt ::= NULLS FIRST */
   -2,  /* (586) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,333,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,334,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,333,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,335,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,336,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,334,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,336,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,335,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy649, &yymsp[-1].minor.yy0, yymsp[0].minor.yy231); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy649, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy649, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy649, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy649); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy231 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy231 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-5].minor.yy541, &yymsp[-3].minor.yy409, &yymsp[0].minor.yy649, yymsp[-2].minor.yy184); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-5].minor.yy541, &yymsp[-3].minor.yy409, &yymsp[0].minor.yy649, yymsp[-2].minor.yy184); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy541 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy541 = yymsp[0].minor.yy541; }
  yymsp[0].minor.yy541 = yylhsminor.yy541;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy541 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy541 = yymsp[-2].minor.yy541 | yymsp[0].minor.yy541; }
  yymsp[-2].minor.yy541 = yylhsminor.yy541;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy541 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy541 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy409.first = yymsp[-2].minor.yy0; yylhsminor.yy409.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy409 = yylhsminor.yy409;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy409.first = yymsp[-2].minor.yy649; yylhsminor.yy409.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy409 = yylhsminor.yy409;
        break;
      case 42: /* priv_level ::= db_name NK_DOT table_name */
{ yylhsminor.yy409.first = yymsp[-2].minor.yy649; yylhsminor.yy409.second = yymsp[0].minor.yy649; }
  yymsp[-2].minor.yy409 = yylhsminor.yy409;
        break;
      case 43: /* priv_level ::= topic_name */
{ yylhsminor.yy409.first = yymsp[0].minor.yy649; yylhsminor.yy409.second = nil_token; }
  yymsp[0].minor.yy409 = yylhsminor.yy409;
        break;
      case 44: /* with_opt ::= */
      case 141: /* start_opt ::= */ yytestcase(yyruleno==141);
      case 145: /* end_opt ::= */ yytestcase(yyruleno==145);
      case 269: /* like_pattern_opt ::= */ yytestcase(yyruleno==269);
      case 344: /* subtable_opt ::= */ yytestcase(yyruleno==344);
      case 460: /* case_when_else_opt ::= */ yytestcase(yyruleno==460);
      case 490: /* from_clause_opt ::= */ yytestcase(yyruleno==490);
      case 519: /* where_clause_opt ::= */ yytestcase(yyruleno==519);
      case 528: /* twindow_clause_opt ::= */ yytestcase(yyruleno==528);
      case 534: /* sliding_opt ::= */ yytestcase(yyruleno==534);
      case 536: /* fill_opt ::= */ yytestcase(yyruleno==536);
      case 550: /* having_clause_opt ::= */ yytestcase(yyruleno==550);
      case 552: /* range_opt ::= */ yytestcase(yyruleno==552);
      case 554: /* every_opt ::= */ yytestcase(yyruleno==554);
      case 567: /* slimit_clause_opt ::= */ yytestcase(yyruleno==567);
      case 571: /* limit_clause_opt ::= */ yytestcase(yyruleno==571);
{ yymsp[1].minor.yy184 = NULL; }
        break;
      case 45: /* with_opt ::= WITH search_condition */
      case 491: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==491);
      case 520: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==520);
      case 551: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==551);
{ yymsp[-1].minor.yy184 = yymsp[0].minor.yy184; }
        break;
      case 46: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy649, NULL); }
        break;
      case 47: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy649, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy829); }
        break;
      case 49: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy649, yymsp[0].minor.yy829); }
        break;
      case 50: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 51: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 52: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= RESTORE DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_DNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* dnode_endpoint ::= NK_STRING */
      case 56: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==56);
      case 57: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==57);
      case 293: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==293);
      case 294: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==294);
      case 295: /* sma_func_name ::= LAST */ yytestcase(yyruleno==295);
      case 296: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==296);
      case 386: /* db_name ::= NK_ID */ yytestcase(yyruleno==386);
      case 387: /* table_name ::= NK_ID */ yytestcase(yyruleno==387);
      case 388: /* column_name ::= NK_ID */ yytestcase(yyruleno==388);
      case 389: /* function_name ::= NK_ID */ yytestcase(yyruleno==389);
      case 390: /* table_alias ::= NK_ID */ yytestcase(yyruleno==390);
      case 391: /* column_alias ::= NK_ID */ yytestcase(yyruleno==391);
      case 392: /* user_name ::= NK_ID */ yytestcase(yyruleno==392);
      case 393: /* topic_name ::= NK_ID */ yytestcase(yyruleno==393);
      case 394: /* stream_name ::= NK_ID */ yytestcase(yyruleno==394);
      case 395: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==395);
      case 396: /* index_name ::= NK_ID */ yytestcase(yyruleno==396);
      case 436: /* noarg_func ::= NOW */ yytestcase(yyruleno==436);
      case 437: /* noarg_func ::= TODAY */ yytestcase(yyruleno==437);
      case 438: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==438);
      case 439: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==439);
      case 440: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==440);
      case 441: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==441);
      case 442: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==442);
      case 443: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==443);
      case 444: /* noarg_func ::= USER */ yytestcase(yyruleno==444);
      case 445: /* star_func ::= COUNT */ yytestcase(yyruleno==445);
      case 446: /* star_func ::= FIRST */ yytestcase(yyruleno==446);
      case 447: /* star_func ::= LAST */ yytestcase(yyruleno==447);
      case 448: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==448);
{ yylhsminor.yy649 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy649 = yylhsminor.yy649;
        break;
      case 58: /* force_opt ::= */
      case 81: /* not_exists_opt ::= */ yytestcase(yyruleno==81);
      case 83: /* exists_opt ::= */ yytestcase(yyruleno==83);
      case 313: /* analyze_opt ::= */ yytestcase(yyruleno==313);
      case 320: /* agg_func_opt ::= */ yytestcase(yyruleno==320);
      case 326: /* or_replace_opt ::= */ yytestcase(yyruleno==326);
      case 509: /* set_quantifier_opt ::= */ yytestcase(yyruleno==509);
{ yymsp[1].minor.yy829 = false; }
        break;
      case 59: /* force_opt ::= FORCE */
      case 314: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==314);
      case 321: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==321);
      case 510: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==510);
{ yymsp[0].minor.yy829 = true; }
        break;
      case 60: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 61: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 67: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 68: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 69: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 70: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 71: /* cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 72: /* cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_VNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 73: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy829, &yymsp[-1].minor.yy649, yymsp[0].minor.yy184); }
        break;
      case 74: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy829, &yymsp[0].minor.yy649); }
        break;
      case 75: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy649); }
        break;
      case 76: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy649, yymsp[0].minor.yy184); }
        break;
      case 77: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy649); }
        break;
      case 78: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy649, yymsp[0].minor.yy480); }
        break;
      case 79: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy649, yymsp[-1].minor.yy184, yymsp[0].minor.yy184); }
        break;
      case 80: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy829 = true; }
        break;
      case 82: /* exists_opt ::= IF EXISTS */
      case 327: /* or_replace_opt ::= OR REPLACE */ yytestcase(yyruleno==327);
{ yymsp[-1].minor.yy829 = true; }
        break;
      case 84: /* db_options ::= */
{ yymsp[1].minor.yy184 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 85: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 86: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 87: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 88: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 89: /* db_options ::= db_options DURATION NK_INTEGER */
      case 90: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==90);
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 91: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 92: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 93: /* db_options ::= db_options KEEP integer_list */
      case 94: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==94);
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_KEEP, yymsp[0].minor.yy532); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 95: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 96: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 97: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 98: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 99: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 100: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 101: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 102: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_RETENTIONS, yymsp[0].minor.yy532); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 103: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 104: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 105: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 106: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 107: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-3].minor.yy184, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 108: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 109: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-3].minor.yy184, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 110: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 111: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 112: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 113: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 114: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 115: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy184 = createAlterDatabaseOptions(pCxt); yylhsminor.yy184 = setAlterDatabaseOption(pCxt, yylhsminor.yy184, &yymsp[0].minor.yy361); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 116: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy184 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy184, &yymsp[0].minor.yy361); }
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 117: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy361.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy361.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy361.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy361.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
        break;
      case 121: /* alter_db_option ::= KEEP integer_list */
      case 122: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==122);
{ yymsp[-1].minor.yy361.type = DB_OPTION_KEEP; yymsp[-1].minor.yy361.pList = yymsp[0].minor.yy532; }
        break;
      case 123: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy361.type = DB_OPTION_PAGES; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
        break;
      case 124: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy361.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
        break;
      case 125: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy361.type = DB_OPTION_WAL; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
        break;
      case 126: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy361.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
        break;
      case 127: /* alter_db_option ::= MINROWS NK_INTEGER */
{ yymsp[-1].minor.yy361.type = DB_OPTION_MINROWS; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
        break;
      case 128: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy361.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
        break;
      case 129: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy361.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-2].minor.yy361.val = t;
                                                                                  }
        break;
      case 130: /* alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
{ yymsp[-1].minor.yy361.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
        break;
      case 131: /* alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy361.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-2].minor.yy361.val = t;
                                                                                  }
        break;
      case 132: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy532 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy532 = yylhsminor.yy532;
        break;
      case 133: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 355: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==355);
{ yylhsminor.yy532 = addNodeToList(pCxt, yymsp[-2].minor.yy532, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy532 = yylhsminor.yy532;
        break;
      case 134: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy532 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy532 = yylhsminor.yy532;
        break;
      case 135: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy532 = addNodeToList(pCxt, yymsp[-2].minor.yy532, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy532 = yylhsminor.yy532;
        break;
      case 136: /* retention_list ::= retention */
      case 166: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==166);
      case 169: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==169);
      case 176: /* column_def_list ::= column_def */ yytestcase(yyruleno==176);
      case 219: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==219);
      case 224: /* col_name_list ::= col_name */ yytestcase(yyruleno==224);
      case 275: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==275);
      case 289: /* func_list ::= func */ yytestcase(yyruleno==289);
      case 384: /* literal_list ::= signed_literal */ yytestcase(yyruleno==384);
      case 451: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==451);
      case 457: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==457);
      case 512: /* select_list ::= select_item */ yytestcase(yyruleno==512);
      case 523: /* partition_list ::= partition_item */ yytestcase(yyruleno==523);
      case 578: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==578);
{ yylhsminor.yy532 = createNodeList(pCxt, yymsp[0].minor.yy184); }
  yymsp[0].minor.yy532 = yylhsminor.yy532;
        break;
      case 137: /* retention_list ::= retention_list NK_COMMA retention */
      case 170: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==170);
      case 177: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==177);
      case 220: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==220);
      case 225: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==225);
      case 276: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==276);
      case 290: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==290);
      case 385: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==385);
      case 452: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==452);
      case 513: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==513);
      case 524: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==524);
      case 579: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==579);
{ yylhsminor.yy532 = addNodeToList(pCxt, yymsp[-2].minor.yy532, yymsp[0].minor.yy184); }
  yymsp[-2].minor.yy532 = yylhsminor.yy532;
        break;
      case 138: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy184 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 139: /* speed_opt ::= */
      case 322: /* bufsize_opt ::= */ yytestcase(yyruleno==322);
{ yymsp[1].minor.yy480 = 0; }
        break;
      case 140: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 323: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==323);
{ yymsp[-1].minor.yy480 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 142: /* start_opt ::= START WITH NK_INTEGER */
      case 146: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==146);
{ yymsp[-2].minor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 143: /* start_opt ::= START WITH NK_STRING */
      case 147: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==147);
{ yymsp[-2].minor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 144: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 148: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==148);
{ yymsp[-3].minor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 149: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 151: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==151);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy829, yymsp[-5].minor.yy184, yymsp[-3].minor.yy532, yymsp[-1].minor.yy532, yymsp[0].minor.yy184); }
        break;
      case 150: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy532); }
        break;
      case 152: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy532); }
        break;
      case 153: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy829, yymsp[0].minor.yy184); }
        break;
      case 154: /* cmd ::= ALTER TABLE alter_table_clause */
      case 357: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==357);
      case 358: /* cmd ::= insert_query */ yytestcase(yyruleno==358);
{ pCxt->pRootNode = yymsp[0].minor.yy184; }
        break;
      case 155: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy184); }
        break;
      case 156: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy184 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy184, yymsp[0].minor.yy184); }
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 157: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy184 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy184, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy649, yymsp[0].minor.yy388); }
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 158: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy184 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy184, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy649); }
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 159: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy184 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy184, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy649, yymsp[0].minor.yy388); }
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 160: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy184 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy184, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy649, &yymsp[0].minor.yy649); }
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 161: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy184 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy184, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy649, yymsp[0].minor.yy388); }
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 162: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy184 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy184, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy649); }
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 163: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy184 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy184, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy649, yymsp[0].minor.yy388); }
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 164: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy184 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy184, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy649, &yymsp[0].minor.yy649); }
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 165: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy184 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy184, &yymsp[-2].minor.yy649, yymsp[0].minor.yy184); }
  yymsp[-5].minor.yy184 = yylhsminor.yy184;
        break;
      case 167: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 458: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==458);
{ yylhsminor.yy532 = addNodeToList(pCxt, yymsp[-1].minor.yy532, yymsp[0].minor.yy184); }
  yymsp[-1].minor.yy532 = yylhsminor.yy532;
        break;
      case 168: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy184 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy829, yymsp[-8].minor.yy184, yymsp[-6].minor.yy184, yymsp[-5].minor.yy532, yymsp[-2].minor.yy532, yymsp[0].minor.yy184); }
  yymsp[-9].minor.yy184 = yylhsminor.yy184;
        break;
      case 171: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy184 = createDropTableClause(pCxt, yymsp[-1].minor.yy829, yymsp[0].minor.yy184); }
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 172: /* specific_cols_opt ::= */
      case 202: /* tags_def_opt ::= */ yytestcase(yyruleno==202);
      case 274: /* tag_list_opt ::= */ yytestcase(yyruleno==274);
      case 330: /* col_list_opt ::= */ yytestcase(yyruleno==330);
      case 332: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==332);
      case 521: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==521);
      case 546: /* group_by_clause_opt ::= */ yytestcase(yyruleno==546);
      case 565: /* order_by_clause_opt ::= */ yytestcase(yyruleno==565);
{ yymsp[1].minor.yy532 = NULL; }
        break;
      case 173: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 331: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==331);
{ yymsp[-2].minor.yy532 = yymsp[-1].minor.yy532; }
        break;
      case 174: /* full_table_name ::= table_name */
{ yylhsminor.yy184 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy649, NULL); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 175: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy184 = createRealTableNode(pCxt, &yymsp[-2].minor.yy649, &yymsp[0].minor.yy649, NULL); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 178: /* column_def ::= column_name type_name */
{ yylhsminor.yy184 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy649, yymsp[0].minor.yy388, NULL); }
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 179: /* type_name ::= BOOL */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 180: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 181: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 182: /* type_name ::= INT */
      case 183: /* type_name ::= INTEGER */ yytestcase(yyruleno==183);
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 184: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 185: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 186: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 187: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy388 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 188: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 189: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy388 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 190: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy388 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 191: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy388 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 192: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy388 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 193: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy388 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 194: /* type_name ::= JSON */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 195: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy388 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 196: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 197: /* type_name ::= BLOB */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 198: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy388 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 199: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 200: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy388 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 201: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy388 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 203: /* tags_def_opt ::= tags_def */
      case 333: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==333);
      case 450: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==450);
{ yylhsminor.yy532 = yymsp[0].minor.yy532; }
  yymsp[0].minor.yy532 = yylhsminor.yy532;
        break;
      case 204: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 334: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==334);
{ yymsp[-3].minor.yy532 = yymsp[-1].minor.yy532; }
        break;
      case 205: /* table_options ::= */
{ yymsp[1].minor.yy184 = createDefaultTableOptions(pCxt); }
        break;
      case 206: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy184 = setTableOption(pCxt, yymsp[-2].minor.yy184, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 207: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy184 = setTableOption(pCxt, yymsp[-2].minor.yy184, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy532); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 208: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy184 = setTableOption(pCxt, yymsp[-2].minor.yy184, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy532); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 209: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy184 = setTableOption(pCxt, yymsp[-4].minor.yy184, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy532); }
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 210: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy184 = setTableOption(pCxt, yymsp[-2].minor.yy184, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 211: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy184 = setTableOption(pCxt, yymsp[-4].minor.yy184, TABLE_OPTION_SMA, yymsp[-1].minor.yy532); }
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 212: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy184 = setTableOption(pCxt, yymsp[-2].minor.yy184, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy532); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 213: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy184 = createAlterTableOptions(pCxt); yylhsminor.yy184 = setTableOption(pCxt, yylhsminor.yy184, yymsp[0].minor.yy361.type, &yymsp[0].minor.yy361.val); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 214: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy184 = setTableOption(pCxt, yymsp[-1].minor.yy184, yymsp[0].minor.yy361.type, &yymsp[0].minor.yy361.val); }
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 215: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy361.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
        break;
      case 216: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy361.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
        break;
      case 217: /* duration_list ::= duration_literal */
      case 414: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==414);
{ yylhsminor.yy532 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy184)); }
  yymsp[0].minor.yy532 = yylhsminor.yy532;
        break;
      case 218: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 415: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==415);
{ yylhsminor.yy532 = addNodeToList(pCxt, yymsp[-2].minor.yy532, releaseRawExprNode(pCxt, yymsp[0].minor.yy184)); }
  yymsp[-2].minor.yy532 = yylhsminor.yy532;
        break;
      case 221: /* rollup_func_name ::= function_name */
{ yylhsminor.yy184 = createFunctionNode(pCxt, &yymsp[0].minor.yy649, NULL); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 222: /* rollup_func_name ::= FIRST */
      case 223: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==223);
      case 278: /* tag_item ::= QTAGS */ yytestcase(yyruleno==278);
{ yylhsminor.yy184 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 226: /* col_name ::= column_name */
      case 279: /* tag_item ::= column_name */ yytestcase(yyruleno==279);
{ yylhsminor.yy184 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy649); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 227: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 228: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 229: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 230: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 231: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy184, yymsp[0].minor.yy184, OP_TYPE_LIKE); }
        break;
      case 232: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy184, yymsp[0].minor.yy184, OP_TYPE_LIKE); }
        break;
      case 233: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy184, NULL, OP_TYPE_LIKE); }
        break;
      case 234: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 235: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 237: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy184, yymsp[-1].minor.yy184, OP_TYPE_EQUAL); }
        break;
      case 238: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 239: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 240: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 241: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 242: /* cmd ::= SHOW LICENCES */
      case 243: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==243);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 244: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy649); }
        break;
      case 245: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy184); }
        break;
      case 246: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy184); }
        break;
      case 247: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 248: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 249: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 250: /* cmd ::= SHOW VARIABLES */
      case 251: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==251);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 252: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 253: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy184); }
        break;
      case 254: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 255: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 256: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 257: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 258: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy184); }
        break;
      case 259: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 260: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 261: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy184, yymsp[-1].minor.yy184, OP_TYPE_EQUAL); }
        break;
      case 262: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy184, yymsp[0].minor.yy184, yymsp[-3].minor.yy532); }
        break;
      case 263: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 264: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 265: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy184,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 266: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 267: /* db_name_cond_opt ::= */
      case 272: /* from_db_opt ::= */ yytestcase(yyruleno==272);
{ yymsp[1].minor.yy184 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 268: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy184 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy649); }
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 270: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 271: /* table_name_cond ::= table_name */
{ yylhsminor.yy184 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy649); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 273: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy184 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy649); }
        break;
      case 277: /* tag_item ::= TBNAME */
{ yylhsminor.yy184 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 280: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy184 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy649), &yymsp[0].minor.yy649); }
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 281: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy184 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy649), &yymsp[0].minor.yy649); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 282: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy829, yymsp[-3].minor.yy184, yymsp[-1].minor.yy184, NULL, yymsp[0].minor.yy184); }
        break;
      case 283: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy829, yymsp[-5].minor.yy184, yymsp[-3].minor.yy184, yymsp[-1].minor.yy532, NULL); }
        break;
      case 284: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy829, yymsp[0].minor.yy184); }
        break;
      case 285: /* full_index_name ::= index_name */
{ yylhsminor.yy184 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy649); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 286: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy184 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy649, &yymsp[0].minor.yy649); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 287: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy184 = createIndexOption(pCxt, yymsp[-7].minor.yy532, releaseRawExprNode(pCxt, yymsp[-3].minor.yy184), NULL, yymsp[-1].minor.yy184, yymsp[0].minor.yy184); }
        break;
      case 288: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy184 = createIndexOption(pCxt, yymsp[-9].minor.yy532, releaseRawExprNode(pCxt, yymsp[-5].minor.yy184), releaseRawExprNode(pCxt, yymsp[-3].minor.yy184), yymsp[-1].minor.yy184, yymsp[0].minor.yy184); }
        break;
      case 291: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy184 = createFunctionNode(pCxt, &yymsp[-3].minor.yy649, yymsp[-1].minor.yy532); }
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 292: /* sma_func_name ::= function_name */
      case 501: /* alias_opt ::= table_alias */ yytestcase(yyruleno==501);
{ yylhsminor.yy649 = yymsp[0].minor.yy649; }
  yymsp[0].minor.yy649 = yylhsminor.yy649;
        break;
      case 297: /* sma_stream_opt ::= */
      case 335: /* stream_options ::= */ yytestcase(yyruleno==335);
{ yymsp[1].minor.yy184 = createStreamOptions(pCxt); }
        break;
      case 298: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy184)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy184); yylhsminor.yy184 = yymsp[-2].minor.yy184; }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 299: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy184)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy184); yylhsminor.yy184 = yymsp[-2].minor.yy184; }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 300: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy184)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy184); yylhsminor.yy184 = yymsp[-2].minor.yy184; }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 301: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy829, &yymsp[-2].minor.yy649, yymsp[0].minor.yy184); }
        break;
      case 302: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy829, &yymsp[-3].minor.yy649, &yymsp[0].minor.yy649, false); }
        break;
      case 303: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy829, &yymsp[-5].minor.yy649, &yymsp[0].minor.yy649, true); }
        break;
      case 304: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy829, &yymsp[-3].minor.yy649, yymsp[0].minor.yy184, false); }
        break;
      case 305: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy829, &yymsp[-5].minor.yy649, yymsp[0].minor.yy184, true); }
        break;
      case 306: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy829, &yymsp[0].minor.yy649); }
        break;
      case 307: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy829, &yymsp[-2].minor.yy649, &yymsp[0].minor.yy649); }
        break;
      case 308: /* cmd ::= DESC full_table_name */
      case 309: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==309);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy184); }
        break;
      case 310: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 311: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 312: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==312);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy829, yymsp[-1].minor.yy184, yymsp[0].minor.yy184); }
        break;
      case 315: /* explain_options ::= */
{ yymsp[1].minor.yy184 = createDefaultExplainOptions(pCxt); }
        break;
      case 316: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy184 = setExplainVerbose(pCxt, yymsp[-2].minor.yy184, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 317: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy184 = setExplainRatio(pCxt, yymsp[-2].minor.yy184, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 318: /* cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy829, yymsp[-9].minor.yy829, &yymsp[-6].minor.yy649, &yymsp[-4].minor.yy0, yymsp[-2].minor.yy388, yymsp[-1].minor.yy480, &yymsp[0].minor.yy649, yymsp[-10].minor.yy829); }
        break;
      case 319: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy829, &yymsp[0].minor.yy649); }
        break;
      case 324: /* language_opt ::= */
{ yymsp[1].minor.yy649 = nil_token; }
        break;
      case 325: /* language_opt ::= LANGUAGE NK_STRING */
{ yymsp[-1].minor.yy649 = yymsp[0].minor.yy0; }
        break;
      case 328: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy829, &yymsp[-8].minor.yy649, yymsp[-5].minor.yy184, yymsp[-7].minor.yy184, yymsp[-3].minor.yy532, yymsp[-2].minor.yy184, yymsp[0].minor.yy184, yymsp[-4].minor.yy532); }
        break;
      case 329: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy829, &yymsp[0].minor.yy649); }
        break;
      case 336: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 337: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==337);
{ yylhsminor.yy184 = setStreamOptions(pCxt, yymsp[-2].minor.yy184, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 338: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ yylhsminor.yy184 = setStreamOptions(pCxt, yymsp[-3].minor.yy184, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy184)); }
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 339: /* stream_options ::= stream_options WATERMARK duration_literal */
{ yylhsminor.yy184 = setStreamOptions(pCxt, yymsp[-2].minor.yy184, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy184)); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 340: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ yylhsminor.yy184 = setStreamOptions(pCxt, yymsp[-3].minor.yy184, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 341: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ yylhsminor.yy184 = setStreamOptions(pCxt, yymsp[-2].minor.yy184, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 342: /* stream_options ::= stream_options DELETE_MARK duration_literal */
{ yylhsminor.yy184 = setStreamOptions(pCxt, yymsp[-2].minor.yy184, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy184)); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 343: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ yylhsminor.yy184 = setStreamOptions(pCxt, yymsp[-3].minor.yy184, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 345: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 535: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==535);
      case 555: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==555);
{ yymsp[-3].minor.yy184 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy184); }
        break;
      case 346: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 347: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 348: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 349: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 350: /* cmd ::= BALANCE VGROUP LEADER */
{ pCxt->pRootNode = createBalanceVgroupLeaderStmt(pCxt); }
        break;
      case 351: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 352: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy532); }
        break;
      case 353: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 354: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy532 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 356: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy184, yymsp[0].minor.yy184); }
        break;
      case 359: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy184 = createInsertStmt(pCxt, yymsp[-4].minor.yy184, yymsp[-2].minor.yy532, yymsp[0].minor.yy184); }
        break;
      case 360: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy184 = createInsertStmt(pCxt, yymsp[-1].minor.yy184, NULL, yymsp[0].minor.yy184); }
        break;
      case 361: /* literal ::= NK_INTEGER */
{ yylhsminor.yy184 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 362: /* literal ::= NK_FLOAT */
{ yylhsminor.yy184 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 363: /* literal ::= NK_STRING */
{ yylhsminor.yy184 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 364: /* literal ::= NK_BOOL */
{ yylhsminor.yy184 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 365: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 366: /* literal ::= duration_literal */
      case 376: /* signed_literal ::= signed */ yytestcase(yyruleno==376);
      case 397: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==397);
      case 398: /* expression ::= literal */ yytestcase(yyruleno==398);
      case 399: /* expression ::= pseudo_column */ yytestcase(yyruleno==399);
      case 400: /* expression ::= column_reference */ yytestcase(yyruleno==400);
      case 401: /* expression ::= function_expression */ yytestcase(yyruleno==401);
      case 402: /* expression ::= case_when_expression */ yytestcase(yyruleno==402);
      case 433: /* function_expression ::= literal_func */ yytestcase(yyruleno==433);
      case 482: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==482);
      case 486: /* boolean_primary ::= predicate */ yytestcase(yyruleno==486);
      case 488: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==488);
      case 489: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==489);
      case 492: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==492);
      case 494: /* table_reference ::= table_primary */ yytestcase(yyruleno==494);
      case 495: /* table_reference ::= joined_table */ yytestcase(yyruleno==495);
      case 499: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==499);
      case 557: /* query_simple ::= query_specification */ yytestcase(yyruleno==557);
      case 558: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==558);
      case 561: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==561);
      case 563: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==563);
{ yylhsminor.yy184 = yymsp[0].minor.yy184; }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 367: /* literal ::= NULL */
{ yylhsminor.yy184 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 368: /* literal ::= NK_QUESTION */
{ yylhsminor.yy184 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 369: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy184 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 370: /* signed ::= NK_INTEGER */
{ yylhsminor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 371: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 372: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 373: /* signed ::= NK_FLOAT */
{ yylhsminor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 374: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 375: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 377: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 378: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 379: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 380: /* signed_literal ::= duration_literal */
      case 382: /* signed_literal ::= literal_func */ yytestcase(yyruleno==382);
      case 453: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==453);
      case 515: /* select_item ::= common_expression */ yytestcase(yyruleno==515);
      case 525: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==525);
      case 562: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==562);
      case 564: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==564);
      case 577: /* search_condition ::= common_expression */ yytestcase(yyruleno==577);
{ yylhsminor.yy184 = releaseRawExprNode(pCxt, yymsp[0].minor.yy184); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 381: /* signed_literal ::= NULL */
{ yylhsminor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 383: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy184 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 403: /* expression ::= NK_LP expression NK_RP */
      case 487: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==487);
      case 576: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==576);
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy184)); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 404: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy184));
                                                                                  }
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 405: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy184), NULL));
                                                                                  }
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 406: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184))); 
                                                                                  }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 407: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184))); 
                                                                                  }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 408: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184))); 
                                                                                  }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 409: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184))); 
                                                                                  }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 410: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184)));
                                                                                  }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 411: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 412: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184)));
                                                                                  }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 413: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184)));
                                                                                  }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 416: /* column_reference ::= column_name */
{ yylhsminor.yy184 = createRawExprNode(pCxt, &yymsp[0].minor.yy649, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy649)); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 417: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy649, &yymsp[0].minor.yy649, createColumnNode(pCxt, &yymsp[-2].minor.yy649, &yymsp[0].minor.yy649)); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 418: /* pseudo_column ::= ROWTS */
      case 419: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==419);
      case 421: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==421);
      case 422: /* pseudo_column ::= QEND */ yytestcase(yyruleno==422);
      case 423: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==423);
      case 424: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==424);
      case 425: /* pseudo_column ::= WEND */ yytestcase(yyruleno==425);
      case 426: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==426);
      case 427: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==427);
      case 428: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==428);
      case 429: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==429);
      case 435: /* literal_func ::= NOW */ yytestcase(yyruleno==435);
{ yylhsminor.yy184 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 420: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy649, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy649)))); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 430: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 431: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==431);
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy649, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy649, yymsp[-1].minor.yy532)); }
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 432: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy184), yymsp[-1].minor.yy388)); }
  yymsp[-5].minor.yy184 = yylhsminor.yy184;
        break;
      case 434: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy649, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy649, NULL)); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 449: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy532 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy532 = yylhsminor.yy532;
        break;
      case 454: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 518: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==518);
{ yylhsminor.yy184 = createColumnNode(pCxt, &yymsp[-2].minor.yy649, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 455: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy532, yymsp[-1].minor.yy184)); }
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 456: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy184), yymsp[-2].minor.yy532, yymsp[-1].minor.yy184)); }
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 459: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy184 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184)); }
        break;
      case 461: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy184 = releaseRawExprNode(pCxt, yymsp[0].minor.yy184); }
        break;
      case 462: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 467: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==467);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy424, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184)));
                                                                                  }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 463: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy184), releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184)));
                                                                                  }
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 464: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy184), releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184)));
                                                                                  }
  yymsp[-5].minor.yy184 = yylhsminor.yy184;
        break;
      case 465: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), NULL));
                                                                                  }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 466: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy184), NULL));
                                                                                  }
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 468: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy424 = OP_TYPE_LOWER_THAN; }
        break;
      case 469: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy424 = OP_TYPE_GREATER_THAN; }
        break;
      case 470: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy424 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 471: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy424 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 472: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy424 = OP_TYPE_NOT_EQUAL; }
        break;
      case 473: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy424 = OP_TYPE_EQUAL; }
        break;
      case 474: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy424 = OP_TYPE_LIKE; }
        break;
      case 475: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy424 = OP_TYPE_NOT_LIKE; }
        break;
      case 476: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy424 = OP_TYPE_MATCH; }
        break;
      case 477: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy424 = OP_TYPE_NMATCH; }
        break;
      case 478: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy424 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 479: /* in_op ::= IN */
{ yymsp[0].minor.yy424 = OP_TYPE_IN; }
        break;
      case 480: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy424 = OP_TYPE_NOT_IN; }
        break;
      case 481: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy532)); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 483: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy184), NULL));
                                                                                  }
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 484: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184)));
                                                                                  }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 485: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184)));
                                                                                  }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 493: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy184 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy184, yymsp[0].minor.yy184, NULL); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 496: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy184 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy649, &yymsp[0].minor.yy649); }
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 497: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy184 = createRealTableNode(pCxt, &yymsp[-3].minor.yy649, &yymsp[-1].minor.yy649, &yymsp[0].minor.yy649); }
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 498: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy184 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy184), &yymsp[0].minor.yy649); }
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 500: /* alias_opt ::= */
{ yymsp[1].minor.yy649 = nil_token;  }
        break;
      case 502: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy649 = yymsp[0].minor.yy649; }
        break;
      case 503: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 504: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==504);
{ yymsp[-2].minor.yy184 = yymsp[-1].minor.yy184; }
        break;
      case 505: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy184 = createJoinTableNode(pCxt, yymsp[-4].minor.yy416, yymsp[-5].minor.yy184, yymsp[-2].minor.yy184, yymsp[0].minor.yy184); }
  yymsp[-5].minor.yy184 = yylhsminor.yy184;
        break;
      case 506: /* join_type ::= */
{ yymsp[1].minor.yy416 = JOIN_TYPE_INNER; }
        break;
      case 507: /* join_type ::= INNER */
{ yymsp[0].minor.yy416 = JOIN_TYPE_INNER; }
        break;
      case 508: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy184 = createSelectStmt(pCxt, yymsp[-10].minor.yy829, yymsp[-9].minor.yy532, yymsp[-8].minor.yy184);
                                                                                    yymsp[-11].minor.yy184 = addWhereClause(pCxt, yymsp[-11].minor.yy184, yymsp[-7].minor.yy184);
                                                                                    yymsp[-11].minor.yy184 = addPartitionByClause(pCxt, yymsp[-11].minor.yy184, yymsp[-6].minor.yy532);
                                                                                    yymsp[-11].minor.yy184 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy184, yymsp[-2].minor.yy184);
                                                                                    yymsp[-11].minor.yy184 = addGroupByClause(pCxt, yymsp[-11].minor.yy184, yymsp[-1].minor.yy532);
                                                                                    yymsp[-11].minor.yy184 = addHavingClause(pCxt, yymsp[-11].minor.yy184, yymsp[0].minor.yy184);
                                                                                    yymsp[-11].minor.yy184 = addRangeClause(pCxt, yymsp[-11].minor.yy184, yymsp[-5].minor.yy184);
                                                                                    yymsp[-11].minor.yy184 = addEveryClause(pCxt, yymsp[-11].minor.yy184, yymsp[-4].minor.yy184);
                                                                                    yymsp[-11].minor.yy184 = addFillClause(pCxt, yymsp[-11].minor.yy184, yymsp[-3].minor.yy184);
                                                                                  }
        break;
      case 511: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy829 = false; }
        break;
      case 514: /* select_item ::= NK_STAR */
{ yylhsminor.yy184 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 516: /* select_item ::= common_expression column_alias */
      case 526: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==526);
{ yylhsminor.yy184 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy184), &yymsp[0].minor.yy649); }
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 517: /* select_item ::= common_expression AS column_alias */
      case 527: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==527);
{ yylhsminor.yy184 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), &yymsp[0].minor.yy649); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 522: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 547: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==547);
      case 566: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==566);
{ yymsp[-2].minor.yy532 = yymsp[0].minor.yy532; }
        break;
      case 529: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy184 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy184), releaseRawExprNode(pCxt, yymsp[-1].minor.yy184)); }
        break;
      case 530: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy184 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy184)); }
        break;
      case 531: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy184 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy184), NULL, yymsp[-1].minor.yy184, yymsp[0].minor.yy184); }
        break;
      case 532: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy184 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy184), releaseRawExprNode(pCxt, yymsp[-3].minor.yy184), yymsp[-1].minor.yy184, yymsp[0].minor.yy184); }
        break;
      case 533: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy184 = createEventWindowNode(pCxt, yymsp[-3].minor.yy184, yymsp[0].minor.yy184); }
        break;
      case 537: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy184 = createFillNode(pCxt, yymsp[-1].minor.yy362, NULL); }
        break;
      case 538: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
{ yymsp[-5].minor.yy184 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy532)); }
        break;
      case 539: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
{ yymsp[-5].minor.yy184 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy532)); }
        break;
      case 540: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy362 = FILL_MODE_NONE; }
        break;
      case 541: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy362 = FILL_MODE_PREV; }
        break;
      case 542: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy362 = FILL_MODE_NULL; }
        break;
      case 543: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy362 = FILL_MODE_NULL_F; }
        break;
      case 544: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy362 = FILL_MODE_LINEAR; }
        break;
      case 545: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy362 = FILL_MODE_NEXT; }
        break;
      case 548: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy532 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy184))); }
  yymsp[0].minor.yy532 = yylhsminor.yy532;
        break;
      case 549: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy532 = addNodeToList(pCxt, yymsp[-2].minor.yy532, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy184))); }
  yymsp[-2].minor.yy532 = yylhsminor.yy532;
        break;
      case 553: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy184 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy184), releaseRawExprNode(pCxt, yymsp[-1].minor.yy184)); }
        break;
      case 556: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy184 = addOrderByClause(pCxt, yymsp[-3].minor.yy184, yymsp[-2].minor.yy532);
                                                                                    yylhsminor.yy184 = addSlimitClause(pCxt, yylhsminor.yy184, yymsp[-1].minor.yy184);
                                                                                    yylhsminor.yy184 = addLimitClause(pCxt, yylhsminor.yy184, yymsp[0].minor.yy184);
                                                                                  }
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 559: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy184 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy184, yymsp[0].minor.yy184); }
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 560: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy184 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy184, yymsp[0].minor.yy184); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 568: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 572: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==572);
{ yymsp[-1].minor.yy184 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 569: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 573: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==573);
{ yymsp[-3].minor.yy184 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 570: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 574: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==574);
{ yymsp[-3].minor.yy184 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 575: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy184); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 580: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy184 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), yymsp[-1].minor.yy706, yymsp[0].minor.yy617); }
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 581: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy706 = ORDER_ASC; }
        break;
      case 582: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy706 = ORDER_ASC; }
        break;
      case 583: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy706 = ORDER_DESC; }
        break;
      case 584: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy617 = NULL_ORDER_DEFAULT; }
        break;
      case 585: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy617 = NULL_ORDER_FIRST; }
        break;
      case 586: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy617 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
