/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 465
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EJoinType yy42;
  int8_t yy113;
  int64_t yy159;
  SToken yy179;
  EOperatorType yy290;
  EFillMode yy324;
  SDataType yy394;
  ENullOrder yy487;
  SNode* yy602;
  bool yy767;
  int32_t yy820;
  SAlterOption yy845;
  SNodeList* yy874;
  EOrder yy878;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             730
#define YYNRULE              553
#define YYNTOKEN             326
#define YY_MAX_SHIFT         729
#define YY_MIN_SHIFTREDUCE   1081
#define YY_MAX_SHIFTREDUCE   1633
#define YY_ERROR_ACTION      1634
#define YY_ACCEPT_ACTION     1635
#define YY_NO_ACTION         1636
#define YY_MIN_REDUCE        1637
#define YY_MAX_REDUCE        2189
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2706)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1909,  471,  376,  472, 1673, 1836, 1838,  480, 1989,  472,
 /*    10 */  1673, 1909,   45,   43, 1563, 1907,  606,  173, 1650, 1985,
 /*    20 */   371, 1989, 1412,  362, 1843, 1781, 1906,  606, 2003,   35,
 /*    30 */   283,  339, 1985, 1493, 1660, 1410, 1985,  618,  342, 1892,
 /*    40 */  1841,  470,   38,   37,  475, 1679,   44,   42,   41,   40,
 /*    50 */    39, 1981, 1987,  353,  416,  594,  604,  582, 1488, 2021,
 /*    60 */   618, 2160,  629,   18, 1981, 1987,  366,  597, 1981, 1987,
 /*    70 */  1418,  619, 1971, 1635,  635,  629,  581,  179, 1971,  629,
 /*    80 */  1843, 2161,  583,   45,   43,  130,  138,  351, 1437, 1114,
 /*    90 */   618,  371,  510, 1412,  325,   14, 1841,  335, 1437,  582,
 /*   100 */  1843, 2002, 1790, 2160, 1493, 2038, 1410,  359,  107, 2004,
 /*   110 */   639, 2006, 2007,  634,   64,  629, 1841,  726,  581,  179,
 /*   120 */   176,  265, 2091, 2161,  583,  191,  365, 2087, 1116, 1488,
 /*   130 */  1119, 1120, 1495, 1496,   18,   48, 1990,  577, 1522,  386,
 /*   140 */   181, 1418,   44,   42,   41,   40,   39, 1985, 2117,  262,
 /*   150 */  2099,  593,  479,  131,  592,  475, 1679, 2160,   60, 2021,
 /*   160 */    90,   81, 1468, 1478,   80,   48,   14,  576, 1494, 1497,
 /*   170 */   274,  275,  581,  179,  163,  273, 1649, 2161,  583, 1981,
 /*   180 */  1987,  477,  558, 1413,    8, 1411, 2160,  473,  726,  346,
 /*   190 */   629,  233,   38,   37, 1820, 1523,   44,   42,   41,   40,
 /*   200 */    39, 2166,  179, 1495, 1496,   60, 2161,  583, 1416, 1417,
 /*   210 */   575, 1467, 1470, 1471, 1472, 1473, 1474, 1475, 1476, 1477,
 /*   220 */   631,  627, 1486, 1487, 1489, 1490, 1491, 1492,    2,  572,
 /*   230 */  1338, 1339, 1439, 1468, 1478,   60,  489,   84,  120, 1494,
 /*   240 */  1497,  119,  118,  117,  116,  115,  114,  113,  112,  111,
 /*   250 */   347,  134,  345,  344, 1413,  512, 1411,   38,   37,  514,
 /*   260 */  1785,   44,   42,   41,   40,   39,  673,   34,  369, 1517,
 /*   270 */  1518, 1519, 1520, 1521, 1525, 1526, 1527, 1528,  173, 1416,
 /*   280 */  1417,  513, 1467, 1470, 1471, 1472, 1473, 1474, 1475, 1476,
 /*   290 */  1477,  631,  627, 1486, 1487, 1489, 1490, 1491, 1492,    2,
 /*   300 */  1893,   11,   45,   43, 1706,  605, 1133, 1659, 1132,  182,
 /*   310 */   371, 1658, 1412,  578,  573,  567,  182,   11, 2003,    9,
 /*   320 */    60,  216,  409, 1493,  408, 1410, 1240,  661,  660,  659,
 /*   330 */  1244,  658, 1246, 1247,  657, 1249,  654, 1134, 1255,  651,
 /*   340 */  1257, 1258,  648,  645, 1567, 1600,  405, 2164, 1488, 2021,
 /*   350 */  1437, 1971,  487,   18, 1902, 1971,  182,  636,  619, 1630,
 /*   360 */  1418, 1133, 1971, 1132,  635, 1436, 1437,  407,  403,  525,
 /*   370 */   524,  523,  130,   45,   43, 1498,  264,  135,  519,  515,
 /*   380 */  2106,  371,  518, 1412, 1992,   14,  182,  517,  522, 1790,
 /*   390 */  1556, 2002, 1134,  516, 1493, 2038, 1410,  605,  107, 2004,
 /*   400 */   639, 2006, 2007,  634, 2003,  629, 2103,  726,  141, 2165,
 /*   410 */   147, 2062, 2091, 2160,   31,  217,  365, 2087, 1524, 1488,
 /*   420 */    38,   37, 1495, 1496,   44,   42,   41,   40,   39, 2164,
 /*   430 */   168, 1418, 1994, 2161, 2163, 2021,  506,  502,  498,  494,
 /*   440 */   214,   60, 1418,  636,  603, 1503, 1902, 2165, 1971,  619,
 /*   450 */   635, 1437, 1468, 1478, 1629, 1438,   46,  539, 1494, 1497,
 /*   460 */   104,   38,   37,   54, 1439,   44,   42,   41,   40,   39,
 /*   470 */   537,  182,  535, 1413,  139, 1411,   85, 2002,  726,  212,
 /*   480 */  1790, 2038, 1782,  454,  165, 2004,  639, 2006, 2007,  634,
 /*   490 */    32,  629, 1469, 1495, 1496, 1657,  664,   27, 1416, 1417,
 /*   500 */  1529, 1467, 1470, 1471, 1472, 1473, 1474, 1475, 1476, 1477,
 /*   510 */   631,  627, 1486, 1487, 1489, 1490, 1491, 1492,    2,  525,
 /*   520 */   524,  523,   84, 1468, 1478,  559, 2128,  135,  519, 1494,
 /*   530 */  1497,  164,  518,   11,   49,  619, 1744,  517,  522, 1971,
 /*   540 */  1623,  195,  194,  516, 1413, 1786, 1411,  211,  205,  184,
 /*   550 */  1656,  685,  210,   38,   37,  485, 1779,   44,   42,   41,
 /*   560 */    40,   39, 1438,  605,  453, 1440, 1790, 1355, 1356, 1416,
 /*   570 */  1417,  203, 1467, 1470, 1471, 1472, 1473, 1474, 1475, 1476,
 /*   580 */  1477,  631,  627, 1486, 1487, 1489, 1490, 1491, 1492,    2,
 /*   590 */    45,   43,  182, 1469, 1971,  671, 1837, 1838,  371, 1638,
 /*   600 */  1412,  521,  520, 1354, 1357, 1590, 2003, 1873,  264,  585,
 /*   610 */   614, 1493, 1902, 1410,  152,  151,  668,  667,  666,  149,
 /*   620 */   120, 1775,  594,  119,  118,  117,  116,  115,  114,  113,
 /*   630 */   112,  111,   13,   12,   38,   37, 1488, 2021,   44,   42,
 /*   640 */    41,   40,   39, 2165, 1768,  597,  619, 2160, 1418, 1777,
 /*   650 */  1971,  175,  635,  138,  569, 1588, 1589, 1591, 1592, 1888,
 /*   660 */   414,   45,   43, 2164, 1830, 1843,  231, 2161, 2162,  371,
 /*   670 */   187, 1412,  364,   46, 1283, 1284,  232, 1790,  621, 2002,
 /*   680 */  2063, 1841, 1493, 2038, 1410,  182,  107, 2004,  639, 2006,
 /*   690 */  2007,  634, 2003,  629,  619,  726, 1843, 1766,  176,  623,
 /*   700 */  2091, 2063, 1200,  375,  365, 2087,  489, 1488,  415,  242,
 /*   710 */  1495, 1496, 1841, 1655, 1773,  596,  177, 2099, 2100, 1418,
 /*   720 */   136, 2104, 1579, 2021, 1637, 1790, 2118, 1536,  237,   87,
 /*   730 */   330,  636, 1412,  543, 1654,  541, 1971, 1202,  635, 1653,
 /*   740 */  1468, 1478, 1389, 1390,   14, 1410, 1494, 1497,  129,  128,
 /*   750 */   127,  126,  125,  124,  123,  122,  121, 1971,  434,  673,
 /*   760 */   630, 1413,  686, 1411, 1760, 2002,  726,  433,  663, 2038,
 /*   770 */   697,  695,  165, 2004,  639, 2006, 2007,  634, 1971,  629,
 /*   780 */  1418, 1495, 1496, 1971, 2106, 1652, 1416, 1417,  410, 1467,
 /*   790 */  1470, 1471, 1472, 1473, 1474, 1475, 1476, 1477,  631,  627,
 /*   800 */  1486, 1487, 1489, 1490, 1491, 1492,    2,  619, 1888, 1888,
 /*   810 */  2102, 1468, 1478,  328, 2129, 1435,  619, 1494, 1497,  189,
 /*   820 */   193,  424,  447,  619,   98,  461, 2106,  726,  460, 1971,
 /*   830 */   439,  558, 1413, 1843, 1411, 2160,  363,  440, 1790,  553,
 /*   840 */    41,   40,   39,  430,  161,  462, 1783, 1790,  432, 1842,
 /*   850 */  2166,  179, 2101, 1792, 1790, 2161,  583, 1416, 1417, 1958,
 /*   860 */  1467, 1470, 1471, 1472, 1473, 1474, 1475, 1476, 1477,  631,
 /*   870 */   627, 1486, 1487, 1489, 1490, 1491, 1492,    2, 1767,  374,
 /*   880 */  1119, 1120,  161,  162, 1651,  619,  619,  161,  303,  343,
 /*   890 */  1703, 1793,  514, 1413, 1765, 1411, 1792, 1437,   33,  488,
 /*   900 */  1787,  420,  301,   70,   38,   37,   69,  393,   44,   42,
 /*   910 */    41,   40,   39,  377,  513, 1745, 1790, 1790, 1416, 1417,
 /*   920 */   140,  161,  259, 2062,  199,  467,  465, 2131, 1971,  665,
 /*   930 */  1792,  458, 1834, 1560,  452,  451,  450,  449,  446,  445,
 /*   940 */   444,  443,  442,  438,  437,  436,  435,  327,  427,  426,
 /*   950 */   425,  570,  422,  421,  341,  703,  702,  701,  700,  381,
 /*   960 */    60,  699,  698,  142,  693,  692,  691,  690,  689,  688,
 /*   970 */   687,  154,  683,  682,  681,  380,  379,  678,  677,  676,
 /*   980 */   675,  674, 1648,  530, 1440,  671,   38,   37,  594,  417,
 /*   990 */    44,   42,   41,   40,   39, 1632, 1633, 1440,  540,  106,
 /*  1000 */   619,  671,  418,  619,  152,  151,  668,  667,  666,  149,
 /*  1010 */  2111, 1556,  230, 1647,  234,  619, 2003,  284,  586,  138,
 /*  1020 */   152,  151,  668,  667,  666,  149, 1971,  533,  594,  554,
 /*  1030 */   619, 1790,  527, 1646, 1790, 1645,  619,  229,  150, 1469,
 /*  1040 */    78,   77,  413,  253,  598,  186, 1790, 2021, 1644,  669,
 /*  1050 */   602,  670, 1834,  297, 1834,  636, 1820, 1971, 1693,  138,
 /*  1060 */  1971, 1790,  635,  326,  619, 1643,  401, 1790,  399,  395,
 /*  1070 */   391,  388,  385,   67, 2003,  589,   66, 1971,  278, 1971,
 /*  1080 */   526, 1421,  178, 2099, 2100, 1642,  136, 2104,  619, 2002,
 /*  1090 */    53,  215, 1971, 2038,   71, 1790,  107, 2004,  639, 2006,
 /*  1100 */  2007,  634,  616,  629, 2003, 2021,   13,   12, 2180, 1971,
 /*  1110 */  2091,  182,  150,  636,  365, 2087,  382, 2022, 1971, 1790,
 /*  1120 */   635, 2003,  180, 2099, 2100, 2125,  136, 2104,  188, 1971,
 /*  1130 */  1641,  619,   38,   37, 1674, 2021,   44,   42,   41,   40,
 /*  1140 */    39,  241,  160,  636,   79,  617, 1640, 2002, 1971,  619,
 /*  1150 */   635, 2038, 2021, 1686,  107, 2004,  639, 2006, 2007,  634,
 /*  1160 */   636,  629, 1790,  378, 1387, 1971, 2180,  635, 2091,   50,
 /*  1170 */  1684,    3,  365, 2087, 1971,  528, 1559, 2002, 2003,  240,
 /*  1180 */  1790, 2038,  600, 2138,  313, 2004,  639, 2006, 2007,  634,
 /*  1190 */  1971,  629,  531,  144, 2002,  132,  222,  224, 2038,  220,
 /*  1200 */   223,  107, 2004,  639, 2006, 2007,  634, 1420,  629, 2021,
 /*  1210 */  1897,  226, 1831, 2180,  225, 2091,   52,  636,   88,  365,
 /*  1220 */  2087,  384, 1971,  557,  635,  558,   62,  626,  579, 2160,
 /*  1230 */   565, 1424,  228,  368,  367,  227, 2003, 2121,  246,  595,
 /*  1240 */   150,  587,   47, 1426, 2166,  179,    1,  271,  258, 2161,
 /*  1250 */   583, 2002,   47, 1680, 1493, 2038, 1419,    4,  107, 2004,
 /*  1260 */   639, 2006, 2007,  634,  558,  629, 2003, 2021, 2160,  261,
 /*  1270 */  2180, 1162, 2091,   68,  148,  636,  365, 2087, 1587, 1488,
 /*  1280 */  1971,  150,  635, 2166,  179,  103,  679, 2154, 2161,  583,
 /*  1290 */   248, 1418,  601,  387, 1352,  100,  392, 2021, 2003,  276,
 /*  1300 */   590,  340,  721,   62, 1479,  636, 1163,   47, 1181, 2002,
 /*  1310 */  1971,  643,  635, 2038,  291,  148,  107, 2004,  639, 2006,
 /*  1320 */  2007,  634,  150,  629,  133,  611,  280, 1374, 2180, 2021,
 /*  1330 */  2091,  192,  680, 1233,  365, 2087,  148,  636,  625, 2002,
 /*  1340 */  1440,  419, 1971, 2038,  635, 2110,  107, 2004,  639, 2006,
 /*  1350 */  2007,  634,  383,  629, 1179, 1530, 1898, 1423, 2066,  296,
 /*  1360 */  2091,  423,  456, 1261,  365, 2087, 1435, 1265,  428,  441,
 /*  1370 */   455, 2002, 1514, 1890, 1272, 2038, 1270, 2003,  107, 2004,
 /*  1380 */   639, 2006, 2007,  634,  448,  629,  457,  463,  153,  464,
 /*  1390 */  2064,  196, 2091,  466,  468,  558,  365, 2087, 1441, 2160,
 /*  1400 */   469,  478, 1443,  481, 1427,  202, 1422, 1438, 2021,  482,
 /*  1410 */   204, 1442,  483, 1444, 2166,  179,  636,  484,  207, 2161,
 /*  1420 */   583, 1971,  486,  635,  209,  546,   82,  490,   83, 1430,
 /*  1430 */  1432,  213, 1136,  507,  508, 2003,  511, 1780,  509,  219,
 /*  1440 */  1776,  110,  627, 1486, 1487, 1489, 1490, 1491, 1492,  221,
 /*  1450 */  2002,  155,  156,  329, 2038, 2003, 1778,  107, 2004,  639,
 /*  1460 */  2006, 2007,  634, 1774,  629,  545, 2021,  547,  558,  622,
 /*  1470 */   157, 2091, 2160,  158,  636,  365, 2087,  235,   86, 1971,
 /*  1480 */   292,  635, 1948,  548, 1947,  238, 2021, 2166,  179,  552,
 /*  1490 */   571,  555, 2161,  583,  636,  146,  549,  609, 2122, 1971,
 /*  1500 */  2132,  635,  562,  568, 2137, 2136,  244,  247, 2002,    7,
 /*  1510 */   354,  574, 2038, 2003,  580,  108, 2004,  639, 2006, 2007,
 /*  1520 */   634, 2113,  629,  560,  563,  252,  355,  561, 2002, 2091,
 /*  1530 */   255,  169, 2038, 2090, 2087,  108, 2004,  639, 2006, 2007,
 /*  1540 */   634,  588,  629, 2003, 2021,  254,  257,  591, 1556, 2091,
 /*  1550 */   256,  137,  636,  624, 2087, 1439, 2107, 1971,  358,  635,
 /*  1560 */  2003,  599, 1445,  266, 2183, 1903,   93,  612,  293,  294,
 /*  1570 */   607,  613,  608,  260, 2021, 1917,   95, 1916, 2159, 1915,
 /*  1580 */   361,   97,  633,  295, 1791,   59,  637, 1971, 2072,  635,
 /*  1590 */  2038, 2021,   99,  108, 2004,  639, 2006, 2007,  634,  636,
 /*  1600 */   629, 1835,  641,  298, 1971,  722,  635, 2091, 1761,  723,
 /*  1610 */   287,  334, 2087,  725,   51,  331, 2002, 2003,  300,  307,
 /*  1620 */  2038,  332,  322,  319, 2004,  639, 2006, 2007,  634,  632,
 /*  1630 */   629,  620, 2056, 2002,  302,  321, 1965, 2038,  311, 1964,
 /*  1640 */   166, 2004,  639, 2006, 2007,  634,   75,  629, 2021, 1963,
 /*  1650 */  1962,   76, 1959,  389,  390, 1404,  636, 1405,  185,  394,
 /*  1660 */  1957, 1971,  396,  635, 2003,  397,  398, 1956,  400, 1955,
 /*  1670 */   402, 1954, 1953,  404, 1377,  406, 1376, 1928, 1927,  411,
 /*  1680 */   412, 2003, 1926, 1925, 1329, 1881, 1880, 1878, 1877,  143,
 /*  1690 */  2002, 1876,  584, 2181, 2038, 2021, 1879,  108, 2004,  639,
 /*  1700 */  2006, 2007,  634,  636,  629, 1875, 1874, 1872, 1971,  190,
 /*  1710 */   635, 2091, 2021, 1871, 1870,  429, 2088,  360, 1869,  431,
 /*  1720 */   636, 1883, 1868, 1867, 1866, 1971, 1865,  635, 1864, 1863,
 /*  1730 */  1862, 1861, 1860, 1859, 1858, 1857, 2003, 2002, 1856, 1855,
 /*  1740 */  1854, 2038,  145, 1853,  166, 2004,  639, 2006, 2007,  634,
 /*  1750 */  1852,  629, 1851, 1882, 2002, 1850, 1849, 1848, 2038, 2003,
 /*  1760 */  1847,  320, 2004,  639, 2006, 2007,  634, 2021,  629, 1331,
 /*  1770 */  1846, 1845, 1844,  459, 1708,  633, 1208,  197, 1707, 1705,
 /*  1780 */  1971, 1669,  635,  198,  200,   73, 1668, 1122,  174, 1121,
 /*  1790 */  2021, 2003, 1991, 1941, 1935,  370,  474, 2182,  636,  201,
 /*  1800 */    74,  476, 1924, 1971,  206,  635,  208, 1923, 1901, 2002,
 /*  1810 */  1769, 1704, 1155, 2038, 1702,  491,  319, 2004,  639, 2006,
 /*  1820 */  2007,  634, 2021,  629,  492, 2057,  493,  372, 1700,  497,
 /*  1830 */   636,  495, 2002,  496, 1698, 1971, 2038,  635, 2003,  320,
 /*  1840 */  2004,  639, 2006, 2007,  634,  500,  629,  499,  501, 1696,
 /*  1850 */   503,  504,  729, 1683, 1682,  505, 1665, 1771, 1277, 1276,
 /*  1860 */   218, 1770, 2003,  694, 2002, 1199,  290,   61, 2038, 2021,
 /*  1870 */  1198,  320, 2004,  639, 2006, 2007,  634,  636,  629, 1197,
 /*  1880 */  1196,  172, 1971,  696,  635, 1193, 1192,  719,  715,  711,
 /*  1890 */   707,  288, 1191, 2021, 1190, 1694,  348, 1687,  349, 1685,
 /*  1900 */   350,  636,  529,  532, 1664, 1663, 1971,  534,  635, 1662,
 /*  1910 */   536,  544,  538,  109, 1394, 2038, 1393, 1396,  315, 2004,
 /*  1920 */   639, 2006, 2007,  634,   26,  629, 1940,  105, 2003, 1383,
 /*  1930 */   281,  542,   55, 1934,  550, 2002, 1922,  159, 1920, 2038,
 /*  1940 */  2165,  551,  304, 2004,  639, 2006, 2007,  634,  239,  629,
 /*  1950 */  2003,   19,  352,   16, 1602,  556,  564,   28,  566, 2021,
 /*  1960 */   243,   58,    5,  615,   63,  245,    6,  636,  250, 1586,
 /*  1970 */   251,   30, 1971, 1578,  635, 2003, 1992,  167,  249,   29,
 /*  1980 */    89, 2021, 1622, 1623,   21, 1617, 1616,  356, 1621,  636,
 /*  1990 */  1620,  357, 1553,  263, 1971,  170,  635, 1552,  268,   92,
 /*  2000 */  1899, 2002,   57,  267, 1921, 2038, 2021, 1919,  305, 2004,
 /*  2010 */   639, 2006, 2007,  634,  636,  629,   20, 1918, 1900, 1971,
 /*  2020 */  1381,  635,  236, 2002,  269,   91,   22, 2038,   56,  272,
 /*  2030 */   306, 2004,  639, 2006, 2007,  634,  277,  629, 2003,   17,
 /*  2040 */   270, 1584,   65,  282,   94,   23, 1505,  610, 2002,   96,
 /*  2050 */    12,   10, 2038, 1504,  279,  312, 2004,  639, 2006, 2007,
 /*  2060 */   634, 1428,  629, 1515,  100, 2041, 2003, 1483,  628, 2021,
 /*  2070 */  1481,   36,  171,  183, 1480,   15,   24,  636,  640, 1452,
 /*  2080 */  1460,  638, 1971,   25,  635, 1262,  642,  373,  644,  646,
 /*  2090 */  1259, 1256,  647,  650,  649,  652, 2003, 2021, 1250, 1248,
 /*  2100 */   655,  653, 1239,  656, 1254,  636, 1253,  101,  285, 1252,
 /*  2110 */  1971, 2002,  635, 1267,  102, 2038,  662, 1271,  316, 2004,
 /*  2120 */   639, 2006, 2007,  634,   72,  629, 1153, 2021, 2003, 1251,
 /*  2130 */   672, 1187, 1186, 1185, 1184,  636, 1183, 1182, 1180, 2002,
 /*  2140 */  1971, 1178,  635, 2038, 1177, 1176,  308, 2004,  639, 2006,
 /*  2150 */  2007,  634,  286,  629, 1206,  684, 1174, 1173, 1172, 2021,
 /*  2160 */  2003, 1171, 1170, 1169, 1168, 1203, 1201,  636, 1165, 2002,
 /*  2170 */  1164, 1161, 1971, 2038,  635, 1160,  317, 2004,  639, 2006,
 /*  2180 */  2007,  634, 1159,  629, 1158, 1701,  704,  706, 1699,  705,
 /*  2190 */   708, 2021, 2003,  709, 1697,  710,  712,  714,  713,  636,
 /*  2200 */  1695, 2002,  716,  718, 1971, 2038,  635,  717,  309, 2004,
 /*  2210 */   639, 2006, 2007,  634, 1681,  629,  720, 2003, 1111, 1661,
 /*  2220 */   289, 1414,  724, 2021,  299,  727,  728, 1636, 1636, 1636,
 /*  2230 */  1636,  636, 1636, 2002, 1636, 1636, 1971, 2038,  635, 1636,
 /*  2240 */   318, 2004,  639, 2006, 2007,  634, 1636,  629, 2021, 2003,
 /*  2250 */  1636, 1636, 1636, 1636, 1636, 1636,  636, 1636, 1636, 1636,
 /*  2260 */  1636, 1971, 1636,  635, 1636, 2002, 1636, 1636, 1636, 2038,
 /*  2270 */  1636, 1636,  310, 2004,  639, 2006, 2007,  634, 1636,  629,
 /*  2280 */  2021, 1636, 1636, 1636, 1636, 1636, 1636, 1636,  636, 1636,
 /*  2290 */  2002, 1636, 1636, 1971, 2038,  635, 1636,  323, 2004,  639,
 /*  2300 */  2006, 2007,  634, 1636,  629, 1636, 1636, 1636, 1636, 1636,
 /*  2310 */  1636, 2003, 1636, 1636, 1636, 1636, 1636, 1636, 1636, 1636,
 /*  2320 */  1636, 1636, 2002, 1636, 1636, 1636, 2038, 1636, 2003,  324,
 /*  2330 */  2004,  639, 2006, 2007,  634, 1636,  629, 1636, 1636, 1636,
 /*  2340 */  1636, 1636, 2021, 1636, 1636, 1636, 1636, 1636, 1636, 1636,
 /*  2350 */   636, 1636, 1636, 1636, 1636, 1971, 1636,  635, 1636, 2021,
 /*  2360 */  1636, 1636, 1636, 1636, 1636, 1636, 1636,  636, 1636, 1636,
 /*  2370 */  1636, 1636, 1971, 1636,  635, 1636, 1636, 1636, 1636, 1636,
 /*  2380 */  1636, 1636, 1636, 1636, 2002, 2003, 1636, 1636, 2038, 1636,
 /*  2390 */  1636, 2015, 2004,  639, 2006, 2007,  634, 1636,  629, 1636,
 /*  2400 */  1636, 2002, 1636, 1636, 1636, 2038, 1636, 2003, 2014, 2004,
 /*  2410 */   639, 2006, 2007,  634, 1636,  629, 2021, 1636, 1636, 1636,
 /*  2420 */  1636, 1636, 1636, 1636,  636, 1636, 1636, 1636, 1636, 1971,
 /*  2430 */  1636,  635, 1636, 1636, 1636, 1636, 1636, 1636, 2021, 1636,
 /*  2440 */  1636, 1636, 1636, 1636, 1636, 1636,  636, 1636, 1636, 1636,
 /*  2450 */  1636, 1971, 1636,  635, 1636, 1636, 1636, 1636, 2002, 1636,
 /*  2460 */  1636, 1636, 2038, 1636, 1636, 2013, 2004,  639, 2006, 2007,
 /*  2470 */   634, 1636,  629, 2003, 1636, 1636, 1636, 1636, 1636, 1636,
 /*  2480 */  2002, 1636, 1636, 1636, 2038, 1636, 1636,  336, 2004,  639,
 /*  2490 */  2006, 2007,  634, 1636,  629, 1636, 1636, 2003, 1636, 1636,
 /*  2500 */  1636, 1636, 1636, 1636, 2021, 1636, 1636, 1636, 1636, 1636,
 /*  2510 */  1636, 1636,  636, 1636, 1636, 1636, 1636, 1971, 1636,  635,
 /*  2520 */  1636, 1636, 1636, 1636, 1636, 1636, 1636, 1636, 2021, 1636,
 /*  2530 */  1636, 1636, 1636, 1636, 1636, 1636,  636, 1636, 1636, 1636,
 /*  2540 */  1636, 1971, 1636,  635, 1636, 1636, 2002, 1636, 1636, 1636,
 /*  2550 */  2038, 1636, 1636,  337, 2004,  639, 2006, 2007,  634, 1636,
 /*  2560 */   629, 2003, 1636, 1636, 1636, 1636, 1636, 1636, 1636, 1636,
 /*  2570 */  2002, 1636, 1636, 1636, 2038, 1636, 1636,  333, 2004,  639,
 /*  2580 */  2006, 2007,  634, 1636,  629, 1636, 2003, 1636, 1636, 1636,
 /*  2590 */  1636, 1636, 2021, 1636, 1636, 1636, 1636, 1636, 1636, 1636,
 /*  2600 */   636, 1636, 1636, 1636, 1636, 1971, 1636,  635, 1636, 1636,
 /*  2610 */  1636, 1636, 1636, 1636, 1636, 1636, 1636, 2021, 2003, 1636,
 /*  2620 */  1636, 1636, 1636, 1636, 1636,  636, 1636, 1636, 1636, 1636,
 /*  2630 */  1971, 1636,  635, 1636, 2002, 1636, 1636, 1636, 2038, 1636,
 /*  2640 */  1636,  338, 2004,  639, 2006, 2007,  634, 1636,  629, 2021,
 /*  2650 */  1636, 1636, 1636, 1636, 1636, 1636, 1636,  636, 1636,  637,
 /*  2660 */  1636, 1636, 1971, 2038,  635, 1636,  315, 2004,  639, 2006,
 /*  2670 */  2007,  634, 1636,  629, 1636, 1636, 1636, 1636, 1636, 1636,
 /*  2680 */  1636, 1636, 1636, 1636, 1636, 1636, 1636, 1636, 1636, 1636,
 /*  2690 */  1636, 2002, 1636, 1636, 1636, 2038, 1636, 1636,  314, 2004,
 /*  2700 */   639, 2006, 2007,  634, 1636,  629,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   375,  333,  371,  335,  336,  374,  375,  333,  362,  335,
 /*    10 */   336,  375,   12,   13,   14,  390,  391,  360,  330,  373,
 /*    20 */    20,  362,   22,  387,  360,  362,  390,  391,  329,  424,
 /*    30 */   425,  367,  373,   33,  329,   35,  373,   20,  381,  382,
 /*    40 */   376,  334,    8,    9,  337,  338,   12,   13,   14,   15,
 /*    50 */    16,  405,  406,  407,  337,  337,   20,  435,   58,  360,
 /*    60 */    20,  439,  416,   63,  405,  406,  407,  368,  405,  406,
 /*    70 */    70,  337,  373,  326,  375,  416,  454,  455,  373,  416,
 /*    80 */   360,  459,  460,   12,   13,  351,  368,  367,   20,    4,
 /*    90 */    20,   20,  358,   22,  377,   95,  376,   63,   20,  435,
 /*   100 */   360,  402,  368,  439,   33,  406,   35,  367,  409,  410,
 /*   110 */   411,  412,  413,  414,    4,  416,  376,  117,  454,  455,
 /*   120 */   421,   58,  423,  459,  460,   58,  427,  428,   43,   58,
 /*   130 */    45,   46,  132,  133,   63,   95,  362,   20,  104,  392,
 /*   140 */   441,   70,   12,   13,   14,   15,   16,  373,  449,  431,
 /*   150 */   432,  433,  334,  435,  436,  337,  338,  439,   95,  360,
 /*   160 */    97,   94,  162,  163,   97,   95,   95,  368,  168,  169,
 /*   170 */   126,  127,  454,  455,  328,  131,  330,  459,  460,  405,
 /*   180 */   406,   14,  435,  183,   39,  185,  439,   20,  117,   37,
 /*   190 */   416,  353,    8,    9,  356,  161,   12,   13,   14,   15,
 /*   200 */    16,  454,  455,  132,  133,   95,  459,  460,  208,  209,
 /*   210 */   411,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  167,
 /*   230 */   162,  163,   20,  162,  163,   95,   62,  343,   21,  168,
 /*   240 */   169,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   250 */    98,  357,  100,  101,  183,  103,  185,    8,    9,  107,
 /*   260 */   366,   12,   13,   14,   15,   16,   62,  233,  234,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,  242,  243,  360,  208,
 /*   280 */   209,  129,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   290 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*   300 */   382,  230,   12,   13,    0,  337,   20,  329,   22,  246,
 /*   310 */    20,  329,   22,  251,  252,  253,  246,  230,  329,  232,
 /*   320 */    95,   35,  182,   33,  184,   35,  108,  109,  110,  111,
 /*   330 */   112,  113,  114,  115,  116,  117,  118,   51,  120,  121,
 /*   340 */   122,  123,  124,  125,   14,   96,  178,    3,   58,  360,
 /*   350 */    20,  373,  384,   63,  386,  373,  246,  368,  337,  175,
 /*   360 */    70,   20,  373,   22,  375,   20,   20,  199,  200,   65,
 /*   370 */    66,   67,  351,   12,   13,   14,  164,   73,   74,  358,
 /*   380 */   408,   20,   78,   22,   47,   95,  246,   83,   84,  368,
 /*   390 */   245,  402,   51,   89,   33,  406,   35,  337,  409,  410,
 /*   400 */   411,  412,  413,  414,  329,  416,  434,  117,  419,  435,
 /*   410 */   421,  422,  423,  439,    2,   33,  427,  428,  161,   58,
 /*   420 */     8,    9,  132,  133,   12,   13,   14,   15,   16,  455,
 /*   430 */    48,   70,   95,  459,  460,  360,   54,   55,   56,   57,
 /*   440 */    58,   95,   70,  368,  384,   14,  386,    3,  373,  337,
 /*   450 */   375,   20,  162,  163,  270,   20,   95,   21,  168,  169,
 /*   460 */   341,    8,    9,  351,   20,   12,   13,   14,   15,   16,
 /*   470 */    34,  246,   36,  183,  355,  185,   94,  402,  117,   97,
 /*   480 */   368,  406,  363,   79,  409,  410,  411,  412,  413,  414,
 /*   490 */   233,  416,  162,  132,  133,  329,  106,   44,  208,  209,
 /*   500 */   243,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   510 */   220,  221,  222,  223,  224,  225,  226,  227,  228,   65,
 /*   520 */    66,   67,  343,  162,  163,  450,  451,   73,   74,  168,
 /*   530 */   169,  344,   78,  230,   95,  337,  349,   83,   84,  373,
 /*   540 */    96,  137,  138,   89,  183,  366,  185,  165,  166,  351,
 /*   550 */   329,   70,  170,    8,    9,  173,  361,   12,   13,   14,
 /*   560 */    15,   16,   20,  337,  160,   20,  368,  132,  133,  208,
 /*   570 */   209,  189,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   580 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*   590 */    12,   13,  246,  162,  373,  107,  374,  375,   20,    0,
 /*   600 */    22,  346,  347,  168,  169,  208,  329,    0,  164,  265,
 /*   610 */   384,   33,  386,   35,  126,  127,  128,  129,  130,  131,
 /*   620 */    21,  361,  337,   24,   25,   26,   27,   28,   29,   30,
 /*   630 */    31,   32,    1,    2,    8,    9,   58,  360,   12,   13,
 /*   640 */    14,   15,   16,  435,    0,  368,  337,  439,   70,  361,
 /*   650 */   373,  359,  375,  368,  257,  258,  259,  260,  261,  368,
 /*   660 */   351,   12,   13,  455,  372,  360,  127,  459,  460,   20,
 /*   670 */   379,   22,  367,   95,  132,  133,  126,  368,  420,  402,
 /*   680 */   422,  376,   33,  406,   35,  246,  409,  410,  411,  412,
 /*   690 */   413,  414,  329,  416,  337,  117,  360,    0,  421,  420,
 /*   700 */   423,  422,   35,  367,  427,  428,   62,   58,  351,  164,
 /*   710 */   132,  133,  376,  329,  361,  430,  431,  432,  433,   70,
 /*   720 */   435,  436,   96,  360,    0,  368,  449,   96,  361,  190,
 /*   730 */   191,  368,   22,  194,  329,  196,  373,   70,  375,  329,
 /*   740 */   162,  163,  192,  193,   95,   35,  168,  169,   24,   25,
 /*   750 */    26,   27,   28,   29,   30,   31,   32,  373,  151,   62,
 /*   760 */   361,  183,  348,  185,  350,  402,  117,  160,  361,  406,
 /*   770 */   346,  347,  409,  410,  411,  412,  413,  414,  373,  416,
 /*   780 */    70,  132,  133,  373,  408,  329,  208,  209,  392,  211,
 /*   790 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   800 */   222,  223,  224,  225,  226,  227,  228,  337,  368,  368,
 /*   810 */   434,  162,  163,   18,  451,   20,  337,  168,  169,  379,
 /*   820 */   379,  351,   27,  337,  341,   30,  408,  117,   33,  373,
 /*   830 */   351,  435,  183,  360,  185,  439,  352,  351,  368,  396,
 /*   840 */    14,   15,   16,   48,  360,   50,  363,  368,   53,  376,
 /*   850 */   454,  455,  434,  369,  368,  459,  460,  208,  209,    0,
 /*   860 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   870 */   221,  222,  223,  224,  225,  226,  227,  228,    0,  352,
 /*   880 */    45,   46,  360,   18,  329,  337,  337,  360,   23,   94,
 /*   890 */     0,  369,  107,  183,    0,  185,  369,   20,    2,  351,
 /*   900 */   351,  106,   37,   38,    8,    9,   41,   48,   12,   13,
 /*   910 */    14,   15,   16,  352,  129,  349,  368,  368,  208,  209,
 /*   920 */   419,  360,  463,  422,   59,   60,   61,  383,  373,  370,
 /*   930 */   369,  136,  373,    4,  139,  140,  141,  142,  143,  144,
 /*   940 */   145,  146,  147,  148,  149,  150,  151,  152,  153,  154,
 /*   950 */   155,  452,  157,  158,  159,   65,   66,   67,   68,   69,
 /*   960 */    95,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   970 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   980 */    90,   91,  329,    4,   20,  107,    8,    9,  337,   22,
 /*   990 */    12,   13,   14,   15,   16,  132,  133,   20,   19,  134,
 /*  1000 */   337,  107,   35,  337,  126,  127,  128,  129,  130,  131,
 /*  1010 */   244,  245,   33,  329,  351,  337,  329,  351,   44,  368,
 /*  1020 */   126,  127,  128,  129,  130,  131,  373,   48,  337,  351,
 /*  1030 */   337,  368,   53,  329,  368,  329,  337,   58,   44,  162,
 /*  1040 */   175,  176,  177,  446,  351,  180,  368,  360,  329,  370,
 /*  1050 */   351,  370,  373,  353,  373,  368,  356,  373,    0,  368,
 /*  1060 */   373,  368,  375,  198,  337,  329,  201,  368,  203,  204,
 /*  1070 */   205,  206,  207,   94,  329,   44,   97,  373,  351,  373,
 /*  1080 */    22,   35,  431,  432,  433,  329,  435,  436,  337,  402,
 /*  1090 */    96,  339,  373,  406,  106,  368,  409,  410,  411,  412,
 /*  1100 */   413,  414,  351,  416,  329,  360,    1,    2,  421,  373,
 /*  1110 */   423,  246,   44,  368,  427,  428,  339,  360,  373,  368,
 /*  1120 */   375,  329,  431,  432,  433,  438,  435,  436,  164,  373,
 /*  1130 */   329,  337,    8,    9,  336,  360,   12,   13,   14,   15,
 /*  1140 */    16,  164,  164,  368,  156,  351,  329,  402,  373,  337,
 /*  1150 */   375,  406,  360,    0,  409,  410,  411,  412,  413,  414,
 /*  1160 */   368,  416,  368,  351,   96,  373,  421,  375,  423,   42,
 /*  1170 */     0,   44,  427,  428,  373,   22,  247,  402,  329,   58,
 /*  1180 */   368,  406,  392,  438,  409,  410,  411,  412,  413,  414,
 /*  1190 */   373,  416,   22,   42,  402,   44,   99,   99,  406,  102,
 /*  1200 */   102,  409,  410,  411,  412,  413,  414,   35,  416,  360,
 /*  1210 */   383,   99,  372,  421,  102,  423,  164,  368,   97,  427,
 /*  1220 */   428,  392,  373,  171,  375,  435,   44,   63,  453,  439,
 /*  1230 */   438,  185,   99,   12,   13,  102,  329,  383,   44,  437,
 /*  1240 */    44,  267,   44,   22,  454,  455,  440,   44,  429,  459,
 /*  1250 */   460,  402,   44,    0,   33,  406,   35,  248,  409,  410,
 /*  1260 */   411,  412,  413,  414,  435,  416,  329,  360,  439,  456,
 /*  1270 */   421,   35,  423,   44,   44,  368,  427,  428,   96,   58,
 /*  1280 */   373,   44,  375,  454,  455,   95,   13,  438,  459,  460,
 /*  1290 */    96,   70,   96,  404,   96,  105,   48,  360,  329,   96,
 /*  1300 */   269,  403,   49,   44,   96,  368,   70,   44,   35,  402,
 /*  1310 */   373,   44,  375,  406,  394,   44,  409,  410,  411,  412,
 /*  1320 */   413,  414,   44,  416,   44,   96,   96,  181,  421,  360,
 /*  1330 */   423,   42,   13,   96,  427,  428,   44,  368,  117,  402,
 /*  1340 */    20,  380,  373,  406,  375,  438,  409,  410,  411,  412,
 /*  1350 */   413,  414,  392,  416,   35,   96,  383,  185,  421,   96,
 /*  1360 */   423,  380,  161,   96,  427,  428,   20,   96,  378,  337,
 /*  1370 */   378,  402,  208,  337,   96,  406,   96,  329,  409,  410,
 /*  1380 */   411,  412,  413,  414,  380,  416,  378,   93,   96,  345,
 /*  1390 */   421,  337,  423,  337,  337,  435,  427,  428,   20,  439,
 /*  1400 */   331,  331,   20,  398,  183,  343,  185,   20,  360,  375,
 /*  1410 */   343,   20,  338,   20,  454,  455,  368,  393,  343,  459,
 /*  1420 */   460,  373,  338,  375,  343,  392,  343,  337,  343,  208,
 /*  1430 */   209,  343,   52,  340,  340,  329,  360,  360,  331,  360,
 /*  1440 */   360,  337,  221,  222,  223,  224,  225,  226,  227,  360,
 /*  1450 */   402,  360,  360,  331,  406,  329,  360,  409,  410,  411,
 /*  1460 */   412,  413,  414,  360,  416,  197,  360,  401,  435,  421,
 /*  1470 */   360,  423,  439,  360,  368,  427,  428,  341,   95,  373,
 /*  1480 */   398,  375,  373,  188,  373,  341,  360,  454,  455,  375,
 /*  1490 */   256,  337,  459,  460,  368,  400,  397,  255,  383,  373,
 /*  1500 */   383,  375,  373,  373,  445,  445,  388,  388,  402,  262,
 /*  1510 */   373,  373,  406,  329,  174,  409,  410,  411,  412,  413,
 /*  1520 */   414,  448,  416,  249,  264,  447,  271,  263,  402,  423,
 /*  1530 */   443,  445,  406,  427,  428,  409,  410,  411,  412,  413,
 /*  1540 */   414,  266,  416,  329,  360,  444,  404,  268,  245,  423,
 /*  1550 */   442,  368,  368,  427,  428,   20,  408,  373,  338,  375,
 /*  1560 */   329,  337,   20,  341,  464,  386,  341,  166,  388,  388,
 /*  1570 */   373,  385,  373,  457,  360,  373,  341,  373,  458,  373,
 /*  1580 */   373,  341,  368,  356,  368,   95,  402,  373,  426,  375,
 /*  1590 */   406,  360,   95,  409,  410,  411,  412,  413,  414,  368,
 /*  1600 */   416,  373,  364,  337,  373,   36,  375,  423,  350,  332,
 /*  1610 */   341,  427,  428,  331,  395,  389,  402,  329,  342,  354,
 /*  1620 */   406,  389,  399,  409,  410,  411,  412,  413,  414,  415,
 /*  1630 */   416,  417,  418,  402,  327,  354,    0,  406,  354,    0,
 /*  1640 */   409,  410,  411,  412,  413,  414,  190,  416,  360,    0,
 /*  1650 */     0,   42,    0,   35,  202,   35,  368,   35,   35,  202,
 /*  1660 */     0,  373,   35,  375,  329,   35,  202,    0,  202,    0,
 /*  1670 */    35,    0,    0,   22,  185,   35,  183,    0,    0,  179,
 /*  1680 */   178,  329,    0,    0,   47,    0,    0,    0,    0,   42,
 /*  1690 */   402,    0,  461,  462,  406,  360,    0,  409,  410,  411,
 /*  1700 */   412,  413,  414,  368,  416,    0,    0,    0,  373,  151,
 /*  1710 */   375,  423,  360,    0,    0,   35,  428,  365,    0,  151,
 /*  1720 */   368,    0,    0,    0,    0,  373,    0,  375,    0,    0,
 /*  1730 */     0,    0,    0,    0,    0,    0,  329,  402,    0,    0,
 /*  1740 */     0,  406,   42,    0,  409,  410,  411,  412,  413,  414,
 /*  1750 */     0,  416,    0,    0,  402,    0,    0,    0,  406,  329,
 /*  1760 */     0,  409,  410,  411,  412,  413,  414,  360,  416,   22,
 /*  1770 */     0,    0,    0,  135,    0,  368,   35,   58,    0,    0,
 /*  1780 */   373,    0,  375,   58,   42,   39,    0,   14,   44,   14,
 /*  1790 */   360,  329,   47,    0,    0,  365,   47,  462,  368,   40,
 /*  1800 */    39,   47,    0,  373,   39,  375,  174,    0,    0,  402,
 /*  1810 */     0,    0,   64,  406,    0,   35,  409,  410,  411,  412,
 /*  1820 */   413,  414,  360,  416,   48,  418,   39,  365,    0,   39,
 /*  1830 */   368,   35,  402,   48,    0,  373,  406,  375,  329,  409,
 /*  1840 */   410,  411,  412,  413,  414,   48,  416,   35,   39,    0,
 /*  1850 */    35,   48,   19,    0,    0,   39,    0,    0,   35,   22,
 /*  1860 */   102,    0,  329,   44,  402,   35,   33,  104,  406,  360,
 /*  1870 */    35,  409,  410,  411,  412,  413,  414,  368,  416,   35,
 /*  1880 */    35,   48,  373,   44,  375,   35,   35,   54,   55,   56,
 /*  1890 */    57,   58,   22,  360,   35,    0,   22,    0,   22,    0,
 /*  1900 */    22,  368,   50,   35,    0,    0,  373,   35,  375,    0,
 /*  1910 */    35,  402,   22,   20,   35,  406,   35,   96,  409,  410,
 /*  1920 */   411,  412,  413,  414,   95,  416,    0,   94,  329,   35,
 /*  1930 */    97,  195,  164,    0,   22,  402,    0,  186,    0,  406,
 /*  1940 */     3,  164,  409,  410,  411,  412,  413,  414,  166,  416,
 /*  1950 */   329,   44,  164,  250,   96,  172,  229,   95,  254,  360,
 /*  1960 */    95,   44,  171,  130,    3,   96,  171,  368,   44,   96,
 /*  1970 */    47,   44,  373,   96,  375,  329,   47,   95,   95,   95,
 /*  1980 */    95,  360,   96,   96,   44,   35,   35,   35,   35,  368,
 /*  1990 */    35,   35,   96,   47,  373,   47,  375,   96,  165,   39,
 /*  2000 */     0,  402,   44,  170,    0,  406,  360,    0,  409,  410,
 /*  2010 */   411,  412,  413,  414,  368,  416,  250,    0,    0,  373,
 /*  2020 */   187,  375,  189,  402,   47,   95,   95,  406,  244,   95,
 /*  2030 */   409,  410,  411,  412,  413,  414,   95,  416,  329,  250,
 /*  2040 */    96,   96,   95,   47,   39,   44,  229,  167,  402,   95,
 /*  2050 */     2,  231,  406,  229,  165,  409,  410,  411,  412,  413,
 /*  2060 */   414,   22,  416,  208,  105,   95,  329,   96,   95,  360,
 /*  2070 */    96,   95,   47,   47,   96,   95,   95,  368,  106,   96,
 /*  2080 */    22,  210,  373,   95,  375,   96,   35,   35,   95,   35,
 /*  2090 */    96,   96,   95,   95,   35,   35,  329,  360,   96,   96,
 /*  2100 */    35,   95,   22,   95,  119,  368,  119,   95,   44,  119,
 /*  2110 */   373,  402,  375,   22,   95,  406,  107,   35,  409,  410,
 /*  2120 */   411,  412,  413,  414,   95,  416,   64,  360,  329,  119,
 /*  2130 */    63,   35,   35,   35,   35,  368,   35,   35,   35,  402,
 /*  2140 */   373,   35,  375,  406,   35,   35,  409,  410,  411,  412,
 /*  2150 */   413,  414,   44,  416,   70,   92,   35,   35,   35,  360,
 /*  2160 */   329,   22,   35,   35,   35,   70,   35,  368,   35,  402,
 /*  2170 */    35,   35,  373,  406,  375,   35,  409,  410,  411,  412,
 /*  2180 */   413,  414,   22,  416,   35,    0,   35,   39,    0,   48,
 /*  2190 */    35,  360,  329,   48,    0,   39,   35,   39,   48,  368,
 /*  2200 */     0,  402,   35,   39,  373,  406,  375,   48,  409,  410,
 /*  2210 */   411,  412,  413,  414,    0,  416,   35,  329,   35,    0,
 /*  2220 */    22,   22,   21,  360,   22,   21,   20,  465,  465,  465,
 /*  2230 */   465,  368,  465,  402,  465,  465,  373,  406,  375,  465,
 /*  2240 */   409,  410,  411,  412,  413,  414,  465,  416,  360,  329,
 /*  2250 */   465,  465,  465,  465,  465,  465,  368,  465,  465,  465,
 /*  2260 */   465,  373,  465,  375,  465,  402,  465,  465,  465,  406,
 /*  2270 */   465,  465,  409,  410,  411,  412,  413,  414,  465,  416,
 /*  2280 */   360,  465,  465,  465,  465,  465,  465,  465,  368,  465,
 /*  2290 */   402,  465,  465,  373,  406,  375,  465,  409,  410,  411,
 /*  2300 */   412,  413,  414,  465,  416,  465,  465,  465,  465,  465,
 /*  2310 */   465,  329,  465,  465,  465,  465,  465,  465,  465,  465,
 /*  2320 */   465,  465,  402,  465,  465,  465,  406,  465,  329,  409,
 /*  2330 */   410,  411,  412,  413,  414,  465,  416,  465,  465,  465,
 /*  2340 */   465,  465,  360,  465,  465,  465,  465,  465,  465,  465,
 /*  2350 */   368,  465,  465,  465,  465,  373,  465,  375,  465,  360,
 /*  2360 */   465,  465,  465,  465,  465,  465,  465,  368,  465,  465,
 /*  2370 */   465,  465,  373,  465,  375,  465,  465,  465,  465,  465,
 /*  2380 */   465,  465,  465,  465,  402,  329,  465,  465,  406,  465,
 /*  2390 */   465,  409,  410,  411,  412,  413,  414,  465,  416,  465,
 /*  2400 */   465,  402,  465,  465,  465,  406,  465,  329,  409,  410,
 /*  2410 */   411,  412,  413,  414,  465,  416,  360,  465,  465,  465,
 /*  2420 */   465,  465,  465,  465,  368,  465,  465,  465,  465,  373,
 /*  2430 */   465,  375,  465,  465,  465,  465,  465,  465,  360,  465,
 /*  2440 */   465,  465,  465,  465,  465,  465,  368,  465,  465,  465,
 /*  2450 */   465,  373,  465,  375,  465,  465,  465,  465,  402,  465,
 /*  2460 */   465,  465,  406,  465,  465,  409,  410,  411,  412,  413,
 /*  2470 */   414,  465,  416,  329,  465,  465,  465,  465,  465,  465,
 /*  2480 */   402,  465,  465,  465,  406,  465,  465,  409,  410,  411,
 /*  2490 */   412,  413,  414,  465,  416,  465,  465,  329,  465,  465,
 /*  2500 */   465,  465,  465,  465,  360,  465,  465,  465,  465,  465,
 /*  2510 */   465,  465,  368,  465,  465,  465,  465,  373,  465,  375,
 /*  2520 */   465,  465,  465,  465,  465,  465,  465,  465,  360,  465,
 /*  2530 */   465,  465,  465,  465,  465,  465,  368,  465,  465,  465,
 /*  2540 */   465,  373,  465,  375,  465,  465,  402,  465,  465,  465,
 /*  2550 */   406,  465,  465,  409,  410,  411,  412,  413,  414,  465,
 /*  2560 */   416,  329,  465,  465,  465,  465,  465,  465,  465,  465,
 /*  2570 */   402,  465,  465,  465,  406,  465,  465,  409,  410,  411,
 /*  2580 */   412,  413,  414,  465,  416,  465,  329,  465,  465,  465,
 /*  2590 */   465,  465,  360,  465,  465,  465,  465,  465,  465,  465,
 /*  2600 */   368,  465,  465,  465,  465,  373,  465,  375,  465,  465,
 /*  2610 */   465,  465,  465,  465,  465,  465,  465,  360,  329,  465,
 /*  2620 */   465,  465,  465,  465,  465,  368,  465,  465,  465,  465,
 /*  2630 */   373,  465,  375,  465,  402,  465,  465,  465,  406,  465,
 /*  2640 */   465,  409,  410,  411,  412,  413,  414,  465,  416,  360,
 /*  2650 */   465,  465,  465,  465,  465,  465,  465,  368,  465,  402,
 /*  2660 */   465,  465,  373,  406,  375,  465,  409,  410,  411,  412,
 /*  2670 */   413,  414,  465,  416,  465,  465,  465,  465,  465,  465,
 /*  2680 */   465,  465,  465,  465,  465,  465,  465,  465,  465,  465,
 /*  2690 */   465,  402,  465,  465,  465,  406,  465,  465,  409,  410,
 /*  2700 */   411,  412,  413,  414,  465,  416,
};
#define YY_SHIFT_COUNT    (729)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2219)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   865,    0,   71,    0,  290,  290,  290,  290,  290,  290,
 /*    10 */   290,  290,  290,  290,  290,  361,  578,  578,  649,  578,
 /*    20 */   578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
 /*    30 */   578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
 /*    40 */   578,  578,  578,  578,  578,  578,  578,  578,   70,  346,
 /*    50 */    40,  140,   63,  225,  439,  225,   40,   40, 1221, 1221,
 /*    60 */   225, 1221, 1221,  110,  225,  435,   17,   17,  435,   85,
 /*    70 */    85,   68,  542,  167,  167,   17,   17,   17,   17,   17,
 /*    80 */    17,   17,   36,   17,   17,  174,   78,   17,   17,  117,
 /*    90 */    17,   78,   17,   36,   17,   36,   78,   17,   17,   78,
 /*   100 */    17,   78,   78,   78,   17,  204,  795,   34,   34,  217,
 /*   110 */   454,  710,  710,  710,  710,  710,  710,  710,  710,  710,
 /*   120 */   710,  710,  710,  710,  710,  710,  710,  710,  710,  710,
 /*   130 */   152,  444,   68,  542,  644,  667,  212,  212,  212,  697,
 /*   140 */    87,   87,  667,  345,  345,  345,  390,  303,   78,  372,
 /*   150 */    78,  372,  372,  390,  481,  218,  218,  218,  218,  218,
 /*   160 */   218,  218, 1833,  599,  304,  545,  184,  397,  286,   62,
 /*   170 */   330,  431,  341,  964,  835,  785,  977,  766,  145,  344,
 /*   180 */   766, 1127,  929,  877, 1009, 1248, 1146, 1289, 1320, 1289,
 /*   190 */  1201, 1346, 1346, 1289, 1201, 1201, 1294, 1346, 1346, 1346,
 /*   200 */  1378, 1378, 1382,  174, 1387,  174, 1391, 1393,  174, 1391,
 /*   210 */   174,  174,  174, 1346,  174, 1380, 1380, 1378,   78,   78,
 /*   220 */    78,   78,   78,   78,   78,   78,   78,   78,   78, 1346,
 /*   230 */  1378,  372,  372, 1268, 1383, 1382,  204, 1295, 1387,  204,
 /*   240 */  1346, 1320, 1320,  372, 1234, 1242,  372, 1234, 1242,  372,
 /*   250 */   372,   78, 1247, 1340, 1234, 1260, 1264, 1274, 1009, 1255,
 /*   260 */  1279, 1275, 1303,  345, 1535, 1346, 1391,  204,  204, 1542,
 /*   270 */  1242,  372,  372,  372,  372,  372, 1242,  372, 1401,  204,
 /*   280 */   390,  204,  345, 1490, 1497,  372,  481, 1346,  204, 1569,
 /*   290 */  1378, 2706, 2706, 2706, 2706, 2706, 2706, 2706, 2706, 2706,
 /*   300 */   890,  382,  724,  979,  249,  453,  626,  878,  412,  896,
 /*   310 */   978,  894, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124,
 /*   320 */  1124,  488,  539,  130,  130,  404,  168,  607,   67,  436,
 /*   330 */   550,   44,   44,  826,  631,  257,  826,  826,  826,  994,
 /*   340 */   859,  967, 1151,  988, 1097, 1098, 1112, 1133, 1058, 1153,
 /*   350 */  1170, 1068, 1121, 1182, 1194,  863,  974, 1031, 1052, 1196,
 /*   360 */  1198, 1203, 1229, 1230, 1237, 1105, 1259, 1046, 1172, 1164,
 /*   370 */  1208,  337, 1263, 1267, 1271, 1278, 1280, 1292, 1190, 1273,
 /*   380 */  1319, 1236, 1253, 1636, 1639, 1456, 1649, 1650, 1609, 1652,
 /*   390 */  1618, 1452, 1620, 1622, 1623, 1457, 1660, 1627, 1630, 1464,
 /*   400 */  1667, 1466, 1669, 1635, 1671, 1651, 1672, 1640, 1489, 1493,
 /*   410 */  1677, 1678, 1500, 1502, 1682, 1683, 1637, 1685, 1686, 1687,
 /*   420 */  1647, 1688, 1691, 1696, 1705, 1706, 1707, 1713, 1714, 1558,
 /*   430 */  1680, 1718, 1568, 1721, 1722, 1723, 1724, 1726, 1728, 1729,
 /*   440 */  1730, 1731, 1732, 1733, 1734, 1735, 1738, 1739, 1740, 1700,
 /*   450 */  1743, 1750, 1752, 1753, 1755, 1756, 1747, 1757, 1760, 1770,
 /*   460 */  1638, 1771, 1772, 1741, 1774, 1719, 1778, 1725, 1779, 1781,
 /*   470 */  1742, 1746, 1744, 1745, 1773, 1749, 1775, 1754, 1786, 1759,
 /*   480 */  1761, 1793, 1794, 1802, 1765, 1632, 1807, 1808, 1810, 1748,
 /*   490 */  1811, 1814, 1780, 1776, 1787, 1828, 1796, 1785, 1790, 1834,
 /*   500 */  1812, 1797, 1809, 1849, 1815, 1803, 1816, 1853, 1854, 1856,
 /*   510 */  1857, 1763, 1758, 1823, 1837, 1861, 1830, 1835, 1844, 1845,
 /*   520 */  1819, 1839, 1850, 1851, 1870, 1859, 1895, 1874, 1897, 1876,
 /*   530 */  1852, 1899, 1878, 1868, 1904, 1872, 1905, 1875, 1909, 1890,
 /*   540 */  1893, 1879, 1881, 1736, 1821, 1829, 1926, 1768, 1894, 1933,
 /*   550 */  1751, 1912, 1777, 1782, 1936, 1938, 1788, 1783, 1937, 1907,
 /*   560 */  1703, 1862, 1858, 1865, 1791, 1727, 1795, 1704, 1869, 1917,
 /*   570 */  1873, 1882, 1883, 1884, 1877, 1924, 1923, 1929, 1885, 1927,
 /*   580 */  1766, 1886, 1887, 1961, 1940, 1789, 1950, 1951, 1952, 1953,
 /*   590 */  1955, 1956, 1896, 1901, 1946, 1784, 1958, 1948, 2004, 2007,
 /*   600 */  2017, 2018, 1930, 1960, 1745, 1977, 1931, 1944, 1945, 1934,
 /*   610 */  1941, 1880, 1947, 2000, 2005, 1889, 1954, 1959, 1745, 1996,
 /*   620 */  2001, 1817, 1820, 1824, 2048, 2039, 1855, 1970, 1971, 1973,
 /*   630 */  1974, 1976, 1978, 2025, 1980, 1981, 2026, 1983, 2058, 1871,
 /*   640 */  1988, 1972, 1989, 2051, 2052, 1993, 1994, 2054, 1997, 1995,
 /*   650 */  2059, 1998, 2002, 2060, 2006, 2003, 2065, 2008, 1985, 1987,
 /*   660 */  1990, 2010, 2080, 2009, 2012, 2064, 2019, 2082, 2029, 2064,
 /*   670 */  2064, 2091, 2062, 2067, 2096, 2097, 2098, 2099, 2101, 2102,
 /*   680 */  2103, 2106, 2109, 2110, 2084, 2063, 2108, 2121, 2122, 2123,
 /*   690 */  2139, 2127, 2128, 2129, 2095, 1819, 2131, 1839, 2133, 2135,
 /*   700 */  2136, 2140, 2160, 2149, 2185, 2151, 2141, 2148, 2188, 2155,
 /*   710 */  2145, 2156, 2194, 2161, 2150, 2158, 2200, 2167, 2159, 2164,
 /*   720 */  2214, 2181, 2183, 2219, 2198, 2201, 2199, 2202, 2204, 2206,
};
#define YY_REDUCE_COUNT (299)
#define YY_REDUCE_MIN   (-395)
#define YY_REDUCE_MAX   (2289)
static const short yy_reduce_ofst[] = {
 /*     0 */  -253, -301,  -11,  277,  687,  745,  792,  849,  907,  937,
 /*    10 */   969, 1048, 1106, 1126, 1184, 1214,   75, 1231, 1288,  363,
 /*    20 */   775, 1335, 1352, 1407, 1430, 1462, 1509, 1533, 1599, 1621,
 /*    30 */  1646, 1709, 1737, 1767, 1799, 1831, 1863, 1888, 1920, 1982,
 /*    40 */  1999, 2056, 2078, 2144, 2168, 2232, 2257, 2289, -282, -336,
 /*    50 */   285,  396,  790,  829,  960, 1033,  651,  691, -354, -341,
 /*    60 */  -378, -337, -226,  -26,  208, -364, -266,   21, -375, -332,
 /*    70 */  -326, -343, -369, -293, -182,  112,  198,  309,  357,  470,
 /*    80 */   479,  486,  -32,  548,  549, -106, -280,  663,  678, -201,
 /*    90 */   693, -260,  699,   60,  727,  226,  484,  751,  794,  305,
 /*   100 */   666,  527,  336,  561,  812,  119, -283, -395, -395, -154,
 /*   110 */   187, -295,  -22,  -18,  166,  221,  384,  405,  410,  456,
 /*   120 */   555,  653,  684,  704,  706,  719,  736,  756,  801,  817,
 /*   130 */   292,  -28,  -82,  222,  179,  255,  -28,  376,  418,  483,
 /*   140 */   258,  279,  424,  291,  440,  441, -162,  501,  522,  559,
 /*   150 */   473,  679,  681,  700,  414,  195,  260,  288,  353,  367,
 /*   160 */   399,  407,  443, -312,  566,  544,  459,  499,  752,  597,
 /*   170 */   757,  757,  777,  827,  798,  840,  854,  802,  802,  813,
 /*   180 */   802,  819,  806,  757,  889,  898,  920,  961,  973,  981,
 /*   190 */   990, 1032, 1036, 1004,  992, 1008, 1044, 1054, 1056, 1057,
 /*   200 */  1069, 1070, 1005, 1062, 1034, 1067, 1074, 1024, 1075, 1084,
 /*   210 */  1081, 1083, 1085, 1090, 1088, 1093, 1094, 1107, 1076, 1077,
 /*   220 */  1079, 1080, 1089, 1091, 1092, 1096, 1103, 1110, 1113, 1104,
 /*   230 */  1122, 1109, 1111, 1066, 1095, 1082, 1136, 1099, 1114, 1144,
 /*   240 */  1154, 1115, 1117, 1129, 1059, 1118, 1130, 1060, 1119, 1137,
 /*   250 */  1138,  757, 1073, 1078, 1086, 1101, 1087, 1108, 1142, 1100,
 /*   260 */  1120, 1116,  802, 1183, 1148, 1224, 1220, 1222, 1225, 1179,
 /*   270 */  1180, 1197, 1199, 1202, 1204, 1206, 1181, 1207, 1186, 1235,
 /*   280 */  1227, 1240, 1216, 1162, 1238, 1228, 1258, 1266, 1269, 1277,
 /*   290 */  1282, 1219, 1223, 1226, 1232, 1265, 1281, 1284, 1276, 1307,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*    10 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*    20 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*    30 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*    40 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*    50 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*    60 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*    70 */  1634, 1891, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*    80 */  1634, 1634, 1634, 1634, 1634, 1712, 1634, 1634, 1634, 1634,
 /*    90 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   100 */  1634, 1634, 1634, 1634, 1634, 1710, 1884, 2093, 1634, 1634,
 /*   110 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   120 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   130 */  1634, 2105, 1634, 1634, 1712, 1634, 2105, 2105, 2105, 1710,
 /*   140 */  2065, 2065, 1634, 1634, 1634, 1634, 1819, 1634, 1634, 1634,
 /*   150 */  1634, 1634, 1634, 1819, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   160 */  1634, 1634, 1936, 1634, 1634, 2130, 2184, 1634, 1634, 2133,
 /*   170 */  1634, 1634, 1634, 1896, 1634, 1772, 2120, 2097, 2111, 2168,
 /*   180 */  2098, 2095, 2114, 1634, 2124, 1634, 1929, 1889, 1634, 1889,
 /*   190 */  1886, 1634, 1634, 1889, 1886, 1886, 1763, 1634, 1634, 1634,
 /*   200 */  1634, 1634, 1634, 1712, 1634, 1712, 1634, 1634, 1712, 1634,
 /*   210 */  1712, 1712, 1712, 1634, 1712, 1691, 1691, 1634, 1634, 1634,
 /*   220 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   230 */  1634, 1634, 1634, 1951, 1942, 1634, 1710, 1938, 1634, 1710,
 /*   240 */  1634, 1634, 1634, 1634, 2141, 2139, 1634, 2141, 2139, 1634,
 /*   250 */  1634, 1634, 2153, 2149, 2141, 2157, 2155, 2126, 2124, 2187,
 /*   260 */  2174, 2170, 2111, 1634, 1634, 1634, 1634, 1710, 1710, 1634,
 /*   270 */  2139, 1634, 1634, 1634, 1634, 1634, 2139, 1634, 1634, 1710,
 /*   280 */  1634, 1710, 1634, 1634, 1788, 1634, 1634, 1634, 1710, 1666,
 /*   290 */  1634, 1931, 1944, 1914, 1914, 1822, 1822, 1822, 1713, 1639,
 /*   300 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   310 */  1634, 1634, 2152, 2151, 2020, 1634, 2069, 2068, 2067, 2058,
 /*   320 */  2019, 1784, 1634, 2018, 2017, 1634, 1634, 1634, 1634, 1634,
 /*   330 */  1634, 1905, 1904, 2011, 1634, 1634, 2012, 2010, 2009, 1634,
 /*   340 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   350 */  1634, 1634, 1634, 1634, 1634, 1634, 2171, 2175, 1634, 1634,
 /*   360 */  1634, 1634, 1634, 1634, 1634, 2094, 1634, 1634, 1634, 1634,
 /*   370 */  1634, 1993, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   380 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   390 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   400 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   410 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   420 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   430 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   440 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   450 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   460 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   470 */  1634, 1634, 1671, 1998, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   480 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   490 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   500 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   510 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   520 */  1751, 1750, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   530 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   540 */  1634, 1634, 1634, 1634, 2002, 1634, 1634, 1634, 1634, 1634,
 /*   550 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 2167, 2127,
 /*   560 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   570 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1993, 1634, 2150,
 /*   580 */  1634, 1634, 2165, 1634, 2169, 1634, 1634, 1634, 1634, 1634,
 /*   590 */  1634, 1634, 2104, 2100, 1634, 1634, 2096, 1634, 1634, 1634,
 /*   600 */  1634, 1634, 1634, 1634, 2001, 1634, 1634, 1634, 1634, 1634,
 /*   610 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1992, 1634,
 /*   620 */  2055, 1634, 1634, 1634, 2089, 1634, 1634, 2040, 1634, 1634,
 /*   630 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 2002, 1634, 2005,
 /*   640 */  1634, 1634, 1634, 1634, 1634, 1816, 1634, 1634, 1634, 1634,
 /*   650 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1801, 1799,
 /*   660 */  1798, 1797, 1634, 1794, 1634, 1829, 1634, 1634, 1634, 1825,
 /*   670 */  1824, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   680 */  1634, 1634, 1634, 1634, 1634, 1634, 1731, 1634, 1634, 1634,
 /*   690 */  1634, 1634, 1634, 1634, 1634, 1723, 1634, 1722, 1634, 1634,
 /*   700 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   710 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
 /*   720 */  1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634, 1634,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
  272,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*      START => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  272,  /*      AFTER => ABORT */
  272,  /*     ATTACH => ABORT */
  272,  /*     BEFORE => ABORT */
  272,  /*      BEGIN => ABORT */
  272,  /*     BITAND => ABORT */
  272,  /*     BITNOT => ABORT */
  272,  /*      BITOR => ABORT */
  272,  /*     BLOCKS => ABORT */
  272,  /*     CHANGE => ABORT */
  272,  /*      COMMA => ABORT */
  272,  /*    COMPACT => ABORT */
  272,  /*     CONCAT => ABORT */
  272,  /*   CONFLICT => ABORT */
  272,  /*       COPY => ABORT */
  272,  /*   DEFERRED => ABORT */
  272,  /* DELIMITERS => ABORT */
  272,  /*     DETACH => ABORT */
  272,  /*     DIVIDE => ABORT */
  272,  /*        DOT => ABORT */
  272,  /*       EACH => ABORT */
  272,  /*       FAIL => ABORT */
  272,  /*       FILE => ABORT */
  272,  /*        FOR => ABORT */
  272,  /*       GLOB => ABORT */
  272,  /*         ID => ABORT */
  272,  /*  IMMEDIATE => ABORT */
  272,  /*     IMPORT => ABORT */
  272,  /*  INITIALLY => ABORT */
  272,  /*    INSTEAD => ABORT */
  272,  /*     ISNULL => ABORT */
  272,  /*        KEY => ABORT */
  272,  /*    MODULES => ABORT */
  272,  /*  NK_BITNOT => ABORT */
  272,  /*    NK_SEMI => ABORT */
  272,  /*    NOTNULL => ABORT */
  272,  /*         OF => ABORT */
  272,  /*       PLUS => ABORT */
  272,  /*  PRIVILEGE => ABORT */
  272,  /*      RAISE => ABORT */
  272,  /*    REPLACE => ABORT */
  272,  /*   RESTRICT => ABORT */
  272,  /*        ROW => ABORT */
  272,  /*       SEMI => ABORT */
  272,  /*       STAR => ABORT */
  272,  /*  STATEMENT => ABORT */
  272,  /*     STRICT => ABORT */
  272,  /*     STRING => ABORT */
  272,  /*      TIMES => ABORT */
  272,  /*     UPDATE => ABORT */
  272,  /*     VALUES => ABORT */
  272,  /*   VARIABLE => ABORT */
  272,  /*       VIEW => ABORT */
  272,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "IF",
  /*   63 */ "NOT",
  /*   64 */ "EXISTS",
  /*   65 */ "BUFFER",
  /*   66 */ "CACHEMODEL",
  /*   67 */ "CACHESIZE",
  /*   68 */ "COMP",
  /*   69 */ "DURATION",
  /*   70 */ "NK_VARIABLE",
  /*   71 */ "MAXROWS",
  /*   72 */ "MINROWS",
  /*   73 */ "KEEP",
  /*   74 */ "PAGES",
  /*   75 */ "PAGESIZE",
  /*   76 */ "TSDB_PAGESIZE",
  /*   77 */ "PRECISION",
  /*   78 */ "REPLICA",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "WAL_LEVEL",
  /*   84 */ "WAL_FSYNC_PERIOD",
  /*   85 */ "WAL_RETENTION_PERIOD",
  /*   86 */ "WAL_RETENTION_SIZE",
  /*   87 */ "WAL_ROLL_PERIOD",
  /*   88 */ "WAL_SEGMENT_SIZE",
  /*   89 */ "STT_TRIGGER",
  /*   90 */ "TABLE_PREFIX",
  /*   91 */ "TABLE_SUFFIX",
  /*   92 */ "NK_COLON",
  /*   93 */ "MAX_SPEED",
  /*   94 */ "TABLE",
  /*   95 */ "NK_LP",
  /*   96 */ "NK_RP",
  /*   97 */ "STABLE",
  /*   98 */ "ADD",
  /*   99 */ "COLUMN",
  /*  100 */ "MODIFY",
  /*  101 */ "RENAME",
  /*  102 */ "TAG",
  /*  103 */ "SET",
  /*  104 */ "NK_EQ",
  /*  105 */ "USING",
  /*  106 */ "TAGS",
  /*  107 */ "COMMENT",
  /*  108 */ "BOOL",
  /*  109 */ "TINYINT",
  /*  110 */ "SMALLINT",
  /*  111 */ "INT",
  /*  112 */ "INTEGER",
  /*  113 */ "BIGINT",
  /*  114 */ "FLOAT",
  /*  115 */ "DOUBLE",
  /*  116 */ "BINARY",
  /*  117 */ "TIMESTAMP",
  /*  118 */ "NCHAR",
  /*  119 */ "UNSIGNED",
  /*  120 */ "JSON",
  /*  121 */ "VARCHAR",
  /*  122 */ "MEDIUMBLOB",
  /*  123 */ "BLOB",
  /*  124 */ "VARBINARY",
  /*  125 */ "DECIMAL",
  /*  126 */ "MAX_DELAY",
  /*  127 */ "WATERMARK",
  /*  128 */ "ROLLUP",
  /*  129 */ "TTL",
  /*  130 */ "SMA",
  /*  131 */ "DELETE_MARK",
  /*  132 */ "FIRST",
  /*  133 */ "LAST",
  /*  134 */ "SHOW",
  /*  135 */ "PRIVILEGES",
  /*  136 */ "DATABASES",
  /*  137 */ "TABLES",
  /*  138 */ "STABLES",
  /*  139 */ "MNODES",
  /*  140 */ "QNODES",
  /*  141 */ "FUNCTIONS",
  /*  142 */ "INDEXES",
  /*  143 */ "ACCOUNTS",
  /*  144 */ "APPS",
  /*  145 */ "CONNECTIONS",
  /*  146 */ "LICENCES",
  /*  147 */ "GRANTS",
  /*  148 */ "QUERIES",
  /*  149 */ "SCORES",
  /*  150 */ "TOPICS",
  /*  151 */ "VARIABLES",
  /*  152 */ "CLUSTER",
  /*  153 */ "BNODES",
  /*  154 */ "SNODES",
  /*  155 */ "TRANSACTIONS",
  /*  156 */ "DISTRIBUTED",
  /*  157 */ "CONSUMERS",
  /*  158 */ "SUBSCRIPTIONS",
  /*  159 */ "VNODES",
  /*  160 */ "ALIVE",
  /*  161 */ "LIKE",
  /*  162 */ "TBNAME",
  /*  163 */ "QTAGS",
  /*  164 */ "AS",
  /*  165 */ "INDEX",
  /*  166 */ "FUNCTION",
  /*  167 */ "INTERVAL",
  /*  168 */ "COUNT",
  /*  169 */ "LAST_ROW",
  /*  170 */ "TOPIC",
  /*  171 */ "WITH",
  /*  172 */ "META",
  /*  173 */ "CONSUMER",
  /*  174 */ "GROUP",
  /*  175 */ "DESC",
  /*  176 */ "DESCRIBE",
  /*  177 */ "RESET",
  /*  178 */ "QUERY",
  /*  179 */ "CACHE",
  /*  180 */ "EXPLAIN",
  /*  181 */ "ANALYZE",
  /*  182 */ "VERBOSE",
  /*  183 */ "NK_BOOL",
  /*  184 */ "RATIO",
  /*  185 */ "NK_FLOAT",
  /*  186 */ "OUTPUTTYPE",
  /*  187 */ "AGGREGATE",
  /*  188 */ "BUFSIZE",
  /*  189 */ "STREAM",
  /*  190 */ "INTO",
  /*  191 */ "TRIGGER",
  /*  192 */ "AT_ONCE",
  /*  193 */ "WINDOW_CLOSE",
  /*  194 */ "IGNORE",
  /*  195 */ "EXPIRED",
  /*  196 */ "FILL_HISTORY",
  /*  197 */ "SUBTABLE",
  /*  198 */ "KILL",
  /*  199 */ "CONNECTION",
  /*  200 */ "TRANSACTION",
  /*  201 */ "BALANCE",
  /*  202 */ "VGROUP",
  /*  203 */ "MERGE",
  /*  204 */ "REDISTRIBUTE",
  /*  205 */ "SPLIT",
  /*  206 */ "DELETE",
  /*  207 */ "INSERT",
  /*  208 */ "NULL",
  /*  209 */ "NK_QUESTION",
  /*  210 */ "NK_ARROW",
  /*  211 */ "ROWTS",
  /*  212 */ "QSTART",
  /*  213 */ "QEND",
  /*  214 */ "QDURATION",
  /*  215 */ "WSTART",
  /*  216 */ "WEND",
  /*  217 */ "WDURATION",
  /*  218 */ "IROWTS",
  /*  219 */ "ISFILLED",
  /*  220 */ "CAST",
  /*  221 */ "NOW",
  /*  222 */ "TODAY",
  /*  223 */ "TIMEZONE",
  /*  224 */ "CLIENT_VERSION",
  /*  225 */ "SERVER_VERSION",
  /*  226 */ "SERVER_STATUS",
  /*  227 */ "CURRENT_USER",
  /*  228 */ "CASE",
  /*  229 */ "END",
  /*  230 */ "WHEN",
  /*  231 */ "THEN",
  /*  232 */ "ELSE",
  /*  233 */ "BETWEEN",
  /*  234 */ "IS",
  /*  235 */ "NK_LT",
  /*  236 */ "NK_GT",
  /*  237 */ "NK_LE",
  /*  238 */ "NK_GE",
  /*  239 */ "NK_NE",
  /*  240 */ "MATCH",
  /*  241 */ "NMATCH",
  /*  242 */ "CONTAINS",
  /*  243 */ "IN",
  /*  244 */ "JOIN",
  /*  245 */ "INNER",
  /*  246 */ "SELECT",
  /*  247 */ "DISTINCT",
  /*  248 */ "WHERE",
  /*  249 */ "PARTITION",
  /*  250 */ "BY",
  /*  251 */ "SESSION",
  /*  252 */ "STATE_WINDOW",
  /*  253 */ "EVENT_WINDOW",
  /*  254 */ "START",
  /*  255 */ "SLIDING",
  /*  256 */ "FILL",
  /*  257 */ "VALUE",
  /*  258 */ "NONE",
  /*  259 */ "PREV",
  /*  260 */ "LINEAR",
  /*  261 */ "NEXT",
  /*  262 */ "HAVING",
  /*  263 */ "RANGE",
  /*  264 */ "EVERY",
  /*  265 */ "ORDER",
  /*  266 */ "SLIMIT",
  /*  267 */ "SOFFSET",
  /*  268 */ "LIMIT",
  /*  269 */ "OFFSET",
  /*  270 */ "ASC",
  /*  271 */ "NULLS",
  /*  272 */ "ABORT",
  /*  273 */ "AFTER",
  /*  274 */ "ATTACH",
  /*  275 */ "BEFORE",
  /*  276 */ "BEGIN",
  /*  277 */ "BITAND",
  /*  278 */ "BITNOT",
  /*  279 */ "BITOR",
  /*  280 */ "BLOCKS",
  /*  281 */ "CHANGE",
  /*  282 */ "COMMA",
  /*  283 */ "COMPACT",
  /*  284 */ "CONCAT",
  /*  285 */ "CONFLICT",
  /*  286 */ "COPY",
  /*  287 */ "DEFERRED",
  /*  288 */ "DELIMITERS",
  /*  289 */ "DETACH",
  /*  290 */ "DIVIDE",
  /*  291 */ "DOT",
  /*  292 */ "EACH",
  /*  293 */ "FAIL",
  /*  294 */ "FILE",
  /*  295 */ "FOR",
  /*  296 */ "GLOB",
  /*  297 */ "ID",
  /*  298 */ "IMMEDIATE",
  /*  299 */ "IMPORT",
  /*  300 */ "INITIALLY",
  /*  301 */ "INSTEAD",
  /*  302 */ "ISNULL",
  /*  303 */ "KEY",
  /*  304 */ "MODULES",
  /*  305 */ "NK_BITNOT",
  /*  306 */ "NK_SEMI",
  /*  307 */ "NOTNULL",
  /*  308 */ "OF",
  /*  309 */ "PLUS",
  /*  310 */ "PRIVILEGE",
  /*  311 */ "RAISE",
  /*  312 */ "REPLACE",
  /*  313 */ "RESTRICT",
  /*  314 */ "ROW",
  /*  315 */ "SEMI",
  /*  316 */ "STAR",
  /*  317 */ "STATEMENT",
  /*  318 */ "STRICT",
  /*  319 */ "STRING",
  /*  320 */ "TIMES",
  /*  321 */ "UPDATE",
  /*  322 */ "VALUES",
  /*  323 */ "VARIABLE",
  /*  324 */ "VIEW",
  /*  325 */ "WAL",
  /*  326 */ "cmd",
  /*  327 */ "account_options",
  /*  328 */ "alter_account_options",
  /*  329 */ "literal",
  /*  330 */ "alter_account_option",
  /*  331 */ "user_name",
  /*  332 */ "sysinfo_opt",
  /*  333 */ "privileges",
  /*  334 */ "priv_level",
  /*  335 */ "priv_type_list",
  /*  336 */ "priv_type",
  /*  337 */ "db_name",
  /*  338 */ "topic_name",
  /*  339 */ "dnode_endpoint",
  /*  340 */ "force_opt",
  /*  341 */ "not_exists_opt",
  /*  342 */ "db_options",
  /*  343 */ "exists_opt",
  /*  344 */ "alter_db_options",
  /*  345 */ "speed_opt",
  /*  346 */ "integer_list",
  /*  347 */ "variable_list",
  /*  348 */ "retention_list",
  /*  349 */ "alter_db_option",
  /*  350 */ "retention",
  /*  351 */ "full_table_name",
  /*  352 */ "column_def_list",
  /*  353 */ "tags_def_opt",
  /*  354 */ "table_options",
  /*  355 */ "multi_create_clause",
  /*  356 */ "tags_def",
  /*  357 */ "multi_drop_clause",
  /*  358 */ "alter_table_clause",
  /*  359 */ "alter_table_options",
  /*  360 */ "column_name",
  /*  361 */ "type_name",
  /*  362 */ "signed_literal",
  /*  363 */ "create_subtable_clause",
  /*  364 */ "specific_cols_opt",
  /*  365 */ "expression_list",
  /*  366 */ "drop_table_clause",
  /*  367 */ "col_name_list",
  /*  368 */ "table_name",
  /*  369 */ "column_def",
  /*  370 */ "duration_list",
  /*  371 */ "rollup_func_list",
  /*  372 */ "alter_table_option",
  /*  373 */ "duration_literal",
  /*  374 */ "rollup_func_name",
  /*  375 */ "function_name",
  /*  376 */ "col_name",
  /*  377 */ "db_name_cond_opt",
  /*  378 */ "like_pattern_opt",
  /*  379 */ "table_name_cond",
  /*  380 */ "from_db_opt",
  /*  381 */ "tag_list_opt",
  /*  382 */ "tag_item",
  /*  383 */ "column_alias",
  /*  384 */ "full_index_name",
  /*  385 */ "index_options",
  /*  386 */ "index_name",
  /*  387 */ "func_list",
  /*  388 */ "sliding_opt",
  /*  389 */ "sma_stream_opt",
  /*  390 */ "func",
  /*  391 */ "sma_func_name",
  /*  392 */ "query_or_subquery",
  /*  393 */ "cgroup_name",
  /*  394 */ "analyze_opt",
  /*  395 */ "explain_options",
  /*  396 */ "agg_func_opt",
  /*  397 */ "bufsize_opt",
  /*  398 */ "stream_name",
  /*  399 */ "stream_options",
  /*  400 */ "col_list_opt",
  /*  401 */ "subtable_opt",
  /*  402 */ "expression",
  /*  403 */ "dnode_list",
  /*  404 */ "where_clause_opt",
  /*  405 */ "signed",
  /*  406 */ "literal_func",
  /*  407 */ "literal_list",
  /*  408 */ "table_alias",
  /*  409 */ "expr_or_subquery",
  /*  410 */ "pseudo_column",
  /*  411 */ "column_reference",
  /*  412 */ "function_expression",
  /*  413 */ "case_when_expression",
  /*  414 */ "star_func",
  /*  415 */ "star_func_para_list",
  /*  416 */ "noarg_func",
  /*  417 */ "other_para_list",
  /*  418 */ "star_func_para",
  /*  419 */ "when_then_list",
  /*  420 */ "case_when_else_opt",
  /*  421 */ "common_expression",
  /*  422 */ "when_then_expr",
  /*  423 */ "predicate",
  /*  424 */ "compare_op",
  /*  425 */ "in_op",
  /*  426 */ "in_predicate_value",
  /*  427 */ "boolean_value_expression",
  /*  428 */ "boolean_primary",
  /*  429 */ "from_clause_opt",
  /*  430 */ "table_reference_list",
  /*  431 */ "table_reference",
  /*  432 */ "table_primary",
  /*  433 */ "joined_table",
  /*  434 */ "alias_opt",
  /*  435 */ "subquery",
  /*  436 */ "parenthesized_joined_table",
  /*  437 */ "join_type",
  /*  438 */ "search_condition",
  /*  439 */ "query_specification",
  /*  440 */ "set_quantifier_opt",
  /*  441 */ "select_list",
  /*  442 */ "partition_by_clause_opt",
  /*  443 */ "range_opt",
  /*  444 */ "every_opt",
  /*  445 */ "fill_opt",
  /*  446 */ "twindow_clause_opt",
  /*  447 */ "group_by_clause_opt",
  /*  448 */ "having_clause_opt",
  /*  449 */ "select_item",
  /*  450 */ "partition_list",
  /*  451 */ "partition_item",
  /*  452 */ "fill_mode",
  /*  453 */ "group_by_list",
  /*  454 */ "query_expression",
  /*  455 */ "query_simple",
  /*  456 */ "order_by_clause_opt",
  /*  457 */ "slimit_clause_opt",
  /*  458 */ "limit_clause_opt",
  /*  459 */ "union_query_expression",
  /*  460 */ "query_simple_or_subquery",
  /*  461 */ "sort_specification_list",
  /*  462 */ "sort_specification",
  /*  463 */ "ordering_specification_opt",
  /*  464 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  73 */ "not_exists_opt ::=",
 /*  74 */ "exists_opt ::= IF EXISTS",
 /*  75 */ "exists_opt ::=",
 /*  76 */ "db_options ::=",
 /*  77 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  78 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  79 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  81 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  83 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  84 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options KEEP integer_list",
 /*  86 */ "db_options ::= db_options KEEP variable_list",
 /*  87 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  88 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  89 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  91 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  92 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  93 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  94 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  95 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 104 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 105 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 107 */ "alter_db_options ::= alter_db_option",
 /* 108 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 109 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 110 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 111 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 112 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 113 */ "alter_db_option ::= KEEP integer_list",
 /* 114 */ "alter_db_option ::= KEEP variable_list",
 /* 115 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 116 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 117 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 118 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 119 */ "integer_list ::= NK_INTEGER",
 /* 120 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 121 */ "variable_list ::= NK_VARIABLE",
 /* 122 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 123 */ "retention_list ::= retention",
 /* 124 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 125 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 126 */ "speed_opt ::=",
 /* 127 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 128 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 129 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 130 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 131 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 132 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 133 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 134 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 135 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 136 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 142 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 144 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 145 */ "multi_create_clause ::= create_subtable_clause",
 /* 146 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 147 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 148 */ "multi_drop_clause ::= drop_table_clause",
 /* 149 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 150 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 151 */ "specific_cols_opt ::=",
 /* 152 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 153 */ "full_table_name ::= table_name",
 /* 154 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 155 */ "column_def_list ::= column_def",
 /* 156 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 157 */ "column_def ::= column_name type_name",
 /* 158 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 159 */ "type_name ::= BOOL",
 /* 160 */ "type_name ::= TINYINT",
 /* 161 */ "type_name ::= SMALLINT",
 /* 162 */ "type_name ::= INT",
 /* 163 */ "type_name ::= INTEGER",
 /* 164 */ "type_name ::= BIGINT",
 /* 165 */ "type_name ::= FLOAT",
 /* 166 */ "type_name ::= DOUBLE",
 /* 167 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TIMESTAMP",
 /* 169 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TINYINT UNSIGNED",
 /* 171 */ "type_name ::= SMALLINT UNSIGNED",
 /* 172 */ "type_name ::= INT UNSIGNED",
 /* 173 */ "type_name ::= BIGINT UNSIGNED",
 /* 174 */ "type_name ::= JSON",
 /* 175 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 176 */ "type_name ::= MEDIUMBLOB",
 /* 177 */ "type_name ::= BLOB",
 /* 178 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL",
 /* 180 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 182 */ "tags_def_opt ::=",
 /* 183 */ "tags_def_opt ::= tags_def",
 /* 184 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 185 */ "table_options ::=",
 /* 186 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 187 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 188 */ "table_options ::= table_options WATERMARK duration_list",
 /* 189 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 190 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 191 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 192 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 193 */ "alter_table_options ::= alter_table_option",
 /* 194 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 195 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 196 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 197 */ "duration_list ::= duration_literal",
 /* 198 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 199 */ "rollup_func_list ::= rollup_func_name",
 /* 200 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 201 */ "rollup_func_name ::= function_name",
 /* 202 */ "rollup_func_name ::= FIRST",
 /* 203 */ "rollup_func_name ::= LAST",
 /* 204 */ "col_name_list ::= col_name",
 /* 205 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 206 */ "col_name ::= column_name",
 /* 207 */ "cmd ::= SHOW DNODES",
 /* 208 */ "cmd ::= SHOW USERS",
 /* 209 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 210 */ "cmd ::= SHOW DATABASES",
 /* 211 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 214 */ "cmd ::= SHOW MNODES",
 /* 215 */ "cmd ::= SHOW QNODES",
 /* 216 */ "cmd ::= SHOW FUNCTIONS",
 /* 217 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 218 */ "cmd ::= SHOW STREAMS",
 /* 219 */ "cmd ::= SHOW ACCOUNTS",
 /* 220 */ "cmd ::= SHOW APPS",
 /* 221 */ "cmd ::= SHOW CONNECTIONS",
 /* 222 */ "cmd ::= SHOW LICENCES",
 /* 223 */ "cmd ::= SHOW GRANTS",
 /* 224 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 225 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 226 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 227 */ "cmd ::= SHOW QUERIES",
 /* 228 */ "cmd ::= SHOW SCORES",
 /* 229 */ "cmd ::= SHOW TOPICS",
 /* 230 */ "cmd ::= SHOW VARIABLES",
 /* 231 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 232 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 233 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 234 */ "cmd ::= SHOW BNODES",
 /* 235 */ "cmd ::= SHOW SNODES",
 /* 236 */ "cmd ::= SHOW CLUSTER",
 /* 237 */ "cmd ::= SHOW TRANSACTIONS",
 /* 238 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 239 */ "cmd ::= SHOW CONSUMERS",
 /* 240 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 241 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 242 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 244 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 245 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 246 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 247 */ "db_name_cond_opt ::=",
 /* 248 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 249 */ "like_pattern_opt ::=",
 /* 250 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 251 */ "table_name_cond ::= table_name",
 /* 252 */ "from_db_opt ::=",
 /* 253 */ "from_db_opt ::= FROM db_name",
 /* 254 */ "tag_list_opt ::=",
 /* 255 */ "tag_list_opt ::= tag_item",
 /* 256 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 257 */ "tag_item ::= TBNAME",
 /* 258 */ "tag_item ::= QTAGS",
 /* 259 */ "tag_item ::= column_name",
 /* 260 */ "tag_item ::= column_name column_alias",
 /* 261 */ "tag_item ::= column_name AS column_alias",
 /* 262 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 263 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 264 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 265 */ "full_index_name ::= index_name",
 /* 266 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 267 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 268 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 269 */ "func_list ::= func",
 /* 270 */ "func_list ::= func_list NK_COMMA func",
 /* 271 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 272 */ "sma_func_name ::= function_name",
 /* 273 */ "sma_func_name ::= COUNT",
 /* 274 */ "sma_func_name ::= FIRST",
 /* 275 */ "sma_func_name ::= LAST",
 /* 276 */ "sma_func_name ::= LAST_ROW",
 /* 277 */ "sma_stream_opt ::=",
 /* 278 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 279 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 280 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 281 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 282 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 283 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 284 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 285 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 286 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 287 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 288 */ "cmd ::= DESC full_table_name",
 /* 289 */ "cmd ::= DESCRIBE full_table_name",
 /* 290 */ "cmd ::= RESET QUERY CACHE",
 /* 291 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 292 */ "analyze_opt ::=",
 /* 293 */ "analyze_opt ::= ANALYZE",
 /* 294 */ "explain_options ::=",
 /* 295 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 296 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 297 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 298 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 299 */ "agg_func_opt ::=",
 /* 300 */ "agg_func_opt ::= AGGREGATE",
 /* 301 */ "bufsize_opt ::=",
 /* 302 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 303 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tags_def_opt subtable_opt AS query_or_subquery",
 /* 304 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 305 */ "col_list_opt ::=",
 /* 306 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 307 */ "stream_options ::=",
 /* 308 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 309 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 310 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 311 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 312 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 313 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 314 */ "subtable_opt ::=",
 /* 315 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 316 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 317 */ "cmd ::= KILL QUERY NK_STRING",
 /* 318 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 319 */ "cmd ::= BALANCE VGROUP",
 /* 320 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 321 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 322 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 323 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 324 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 325 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 326 */ "cmd ::= query_or_subquery",
 /* 327 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 328 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 329 */ "literal ::= NK_INTEGER",
 /* 330 */ "literal ::= NK_FLOAT",
 /* 331 */ "literal ::= NK_STRING",
 /* 332 */ "literal ::= NK_BOOL",
 /* 333 */ "literal ::= TIMESTAMP NK_STRING",
 /* 334 */ "literal ::= duration_literal",
 /* 335 */ "literal ::= NULL",
 /* 336 */ "literal ::= NK_QUESTION",
 /* 337 */ "duration_literal ::= NK_VARIABLE",
 /* 338 */ "signed ::= NK_INTEGER",
 /* 339 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 340 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 341 */ "signed ::= NK_FLOAT",
 /* 342 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 343 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 344 */ "signed_literal ::= signed",
 /* 345 */ "signed_literal ::= NK_STRING",
 /* 346 */ "signed_literal ::= NK_BOOL",
 /* 347 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 348 */ "signed_literal ::= duration_literal",
 /* 349 */ "signed_literal ::= NULL",
 /* 350 */ "signed_literal ::= literal_func",
 /* 351 */ "signed_literal ::= NK_QUESTION",
 /* 352 */ "literal_list ::= signed_literal",
 /* 353 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 354 */ "db_name ::= NK_ID",
 /* 355 */ "table_name ::= NK_ID",
 /* 356 */ "column_name ::= NK_ID",
 /* 357 */ "function_name ::= NK_ID",
 /* 358 */ "table_alias ::= NK_ID",
 /* 359 */ "column_alias ::= NK_ID",
 /* 360 */ "user_name ::= NK_ID",
 /* 361 */ "topic_name ::= NK_ID",
 /* 362 */ "stream_name ::= NK_ID",
 /* 363 */ "cgroup_name ::= NK_ID",
 /* 364 */ "index_name ::= NK_ID",
 /* 365 */ "expr_or_subquery ::= expression",
 /* 366 */ "expression ::= literal",
 /* 367 */ "expression ::= pseudo_column",
 /* 368 */ "expression ::= column_reference",
 /* 369 */ "expression ::= function_expression",
 /* 370 */ "expression ::= case_when_expression",
 /* 371 */ "expression ::= NK_LP expression NK_RP",
 /* 372 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 373 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 374 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 375 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 376 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 377 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 378 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 379 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 380 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 381 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 382 */ "expression_list ::= expr_or_subquery",
 /* 383 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 384 */ "column_reference ::= column_name",
 /* 385 */ "column_reference ::= table_name NK_DOT column_name",
 /* 386 */ "pseudo_column ::= ROWTS",
 /* 387 */ "pseudo_column ::= TBNAME",
 /* 388 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 389 */ "pseudo_column ::= QSTART",
 /* 390 */ "pseudo_column ::= QEND",
 /* 391 */ "pseudo_column ::= QDURATION",
 /* 392 */ "pseudo_column ::= WSTART",
 /* 393 */ "pseudo_column ::= WEND",
 /* 394 */ "pseudo_column ::= WDURATION",
 /* 395 */ "pseudo_column ::= IROWTS",
 /* 396 */ "pseudo_column ::= ISFILLED",
 /* 397 */ "pseudo_column ::= QTAGS",
 /* 398 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 399 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 400 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 401 */ "function_expression ::= literal_func",
 /* 402 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 403 */ "literal_func ::= NOW",
 /* 404 */ "noarg_func ::= NOW",
 /* 405 */ "noarg_func ::= TODAY",
 /* 406 */ "noarg_func ::= TIMEZONE",
 /* 407 */ "noarg_func ::= DATABASE",
 /* 408 */ "noarg_func ::= CLIENT_VERSION",
 /* 409 */ "noarg_func ::= SERVER_VERSION",
 /* 410 */ "noarg_func ::= SERVER_STATUS",
 /* 411 */ "noarg_func ::= CURRENT_USER",
 /* 412 */ "noarg_func ::= USER",
 /* 413 */ "star_func ::= COUNT",
 /* 414 */ "star_func ::= FIRST",
 /* 415 */ "star_func ::= LAST",
 /* 416 */ "star_func ::= LAST_ROW",
 /* 417 */ "star_func_para_list ::= NK_STAR",
 /* 418 */ "star_func_para_list ::= other_para_list",
 /* 419 */ "other_para_list ::= star_func_para",
 /* 420 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 421 */ "star_func_para ::= expr_or_subquery",
 /* 422 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 423 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 424 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 425 */ "when_then_list ::= when_then_expr",
 /* 426 */ "when_then_list ::= when_then_list when_then_expr",
 /* 427 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 428 */ "case_when_else_opt ::=",
 /* 429 */ "case_when_else_opt ::= ELSE common_expression",
 /* 430 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 431 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 432 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 433 */ "predicate ::= expr_or_subquery IS NULL",
 /* 434 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 435 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 436 */ "compare_op ::= NK_LT",
 /* 437 */ "compare_op ::= NK_GT",
 /* 438 */ "compare_op ::= NK_LE",
 /* 439 */ "compare_op ::= NK_GE",
 /* 440 */ "compare_op ::= NK_NE",
 /* 441 */ "compare_op ::= NK_EQ",
 /* 442 */ "compare_op ::= LIKE",
 /* 443 */ "compare_op ::= NOT LIKE",
 /* 444 */ "compare_op ::= MATCH",
 /* 445 */ "compare_op ::= NMATCH",
 /* 446 */ "compare_op ::= CONTAINS",
 /* 447 */ "in_op ::= IN",
 /* 448 */ "in_op ::= NOT IN",
 /* 449 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 450 */ "boolean_value_expression ::= boolean_primary",
 /* 451 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 452 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 453 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 454 */ "boolean_primary ::= predicate",
 /* 455 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 456 */ "common_expression ::= expr_or_subquery",
 /* 457 */ "common_expression ::= boolean_value_expression",
 /* 458 */ "from_clause_opt ::=",
 /* 459 */ "from_clause_opt ::= FROM table_reference_list",
 /* 460 */ "table_reference_list ::= table_reference",
 /* 461 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 462 */ "table_reference ::= table_primary",
 /* 463 */ "table_reference ::= joined_table",
 /* 464 */ "table_primary ::= table_name alias_opt",
 /* 465 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 466 */ "table_primary ::= subquery alias_opt",
 /* 467 */ "table_primary ::= parenthesized_joined_table",
 /* 468 */ "alias_opt ::=",
 /* 469 */ "alias_opt ::= table_alias",
 /* 470 */ "alias_opt ::= AS table_alias",
 /* 471 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 472 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 473 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 474 */ "join_type ::=",
 /* 475 */ "join_type ::= INNER",
 /* 476 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 477 */ "set_quantifier_opt ::=",
 /* 478 */ "set_quantifier_opt ::= DISTINCT",
 /* 479 */ "set_quantifier_opt ::= ALL",
 /* 480 */ "select_list ::= select_item",
 /* 481 */ "select_list ::= select_list NK_COMMA select_item",
 /* 482 */ "select_item ::= NK_STAR",
 /* 483 */ "select_item ::= common_expression",
 /* 484 */ "select_item ::= common_expression column_alias",
 /* 485 */ "select_item ::= common_expression AS column_alias",
 /* 486 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 487 */ "where_clause_opt ::=",
 /* 488 */ "where_clause_opt ::= WHERE search_condition",
 /* 489 */ "partition_by_clause_opt ::=",
 /* 490 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 491 */ "partition_list ::= partition_item",
 /* 492 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 493 */ "partition_item ::= expr_or_subquery",
 /* 494 */ "partition_item ::= expr_or_subquery column_alias",
 /* 495 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 496 */ "twindow_clause_opt ::=",
 /* 497 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 498 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 499 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 500 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 501 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 502 */ "sliding_opt ::=",
 /* 503 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 504 */ "fill_opt ::=",
 /* 505 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 506 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 507 */ "fill_mode ::= NONE",
 /* 508 */ "fill_mode ::= PREV",
 /* 509 */ "fill_mode ::= NULL",
 /* 510 */ "fill_mode ::= LINEAR",
 /* 511 */ "fill_mode ::= NEXT",
 /* 512 */ "group_by_clause_opt ::=",
 /* 513 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 514 */ "group_by_list ::= expr_or_subquery",
 /* 515 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 516 */ "having_clause_opt ::=",
 /* 517 */ "having_clause_opt ::= HAVING search_condition",
 /* 518 */ "range_opt ::=",
 /* 519 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 520 */ "every_opt ::=",
 /* 521 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 522 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 523 */ "query_simple ::= query_specification",
 /* 524 */ "query_simple ::= union_query_expression",
 /* 525 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 526 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 527 */ "query_simple_or_subquery ::= query_simple",
 /* 528 */ "query_simple_or_subquery ::= subquery",
 /* 529 */ "query_or_subquery ::= query_expression",
 /* 530 */ "query_or_subquery ::= subquery",
 /* 531 */ "order_by_clause_opt ::=",
 /* 532 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 533 */ "slimit_clause_opt ::=",
 /* 534 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 535 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 536 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 537 */ "limit_clause_opt ::=",
 /* 538 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 539 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 540 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 541 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 542 */ "subquery ::= NK_LP subquery NK_RP",
 /* 543 */ "search_condition ::= common_expression",
 /* 544 */ "sort_specification_list ::= sort_specification",
 /* 545 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 546 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 547 */ "ordering_specification_opt ::=",
 /* 548 */ "ordering_specification_opt ::= ASC",
 /* 549 */ "ordering_specification_opt ::= DESC",
 /* 550 */ "null_ordering_opt ::=",
 /* 551 */ "null_ordering_opt ::= NULLS FIRST",
 /* 552 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 326: /* cmd */
    case 329: /* literal */
    case 342: /* db_options */
    case 344: /* alter_db_options */
    case 350: /* retention */
    case 351: /* full_table_name */
    case 354: /* table_options */
    case 358: /* alter_table_clause */
    case 359: /* alter_table_options */
    case 362: /* signed_literal */
    case 363: /* create_subtable_clause */
    case 366: /* drop_table_clause */
    case 369: /* column_def */
    case 373: /* duration_literal */
    case 374: /* rollup_func_name */
    case 376: /* col_name */
    case 377: /* db_name_cond_opt */
    case 378: /* like_pattern_opt */
    case 379: /* table_name_cond */
    case 380: /* from_db_opt */
    case 382: /* tag_item */
    case 384: /* full_index_name */
    case 385: /* index_options */
    case 388: /* sliding_opt */
    case 389: /* sma_stream_opt */
    case 390: /* func */
    case 392: /* query_or_subquery */
    case 395: /* explain_options */
    case 399: /* stream_options */
    case 401: /* subtable_opt */
    case 402: /* expression */
    case 404: /* where_clause_opt */
    case 405: /* signed */
    case 406: /* literal_func */
    case 409: /* expr_or_subquery */
    case 410: /* pseudo_column */
    case 411: /* column_reference */
    case 412: /* function_expression */
    case 413: /* case_when_expression */
    case 418: /* star_func_para */
    case 420: /* case_when_else_opt */
    case 421: /* common_expression */
    case 422: /* when_then_expr */
    case 423: /* predicate */
    case 426: /* in_predicate_value */
    case 427: /* boolean_value_expression */
    case 428: /* boolean_primary */
    case 429: /* from_clause_opt */
    case 430: /* table_reference_list */
    case 431: /* table_reference */
    case 432: /* table_primary */
    case 433: /* joined_table */
    case 435: /* subquery */
    case 436: /* parenthesized_joined_table */
    case 438: /* search_condition */
    case 439: /* query_specification */
    case 443: /* range_opt */
    case 444: /* every_opt */
    case 445: /* fill_opt */
    case 446: /* twindow_clause_opt */
    case 448: /* having_clause_opt */
    case 449: /* select_item */
    case 451: /* partition_item */
    case 454: /* query_expression */
    case 455: /* query_simple */
    case 457: /* slimit_clause_opt */
    case 458: /* limit_clause_opt */
    case 459: /* union_query_expression */
    case 460: /* query_simple_or_subquery */
    case 462: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy602)); 
}
      break;
    case 327: /* account_options */
    case 328: /* alter_account_options */
    case 330: /* alter_account_option */
    case 345: /* speed_opt */
    case 397: /* bufsize_opt */
{
 
}
      break;
    case 331: /* user_name */
    case 334: /* priv_level */
    case 337: /* db_name */
    case 338: /* topic_name */
    case 339: /* dnode_endpoint */
    case 360: /* column_name */
    case 368: /* table_name */
    case 375: /* function_name */
    case 383: /* column_alias */
    case 386: /* index_name */
    case 391: /* sma_func_name */
    case 393: /* cgroup_name */
    case 398: /* stream_name */
    case 408: /* table_alias */
    case 414: /* star_func */
    case 416: /* noarg_func */
    case 434: /* alias_opt */
{
 
}
      break;
    case 332: /* sysinfo_opt */
{
 
}
      break;
    case 333: /* privileges */
    case 335: /* priv_type_list */
    case 336: /* priv_type */
{
 
}
      break;
    case 340: /* force_opt */
    case 341: /* not_exists_opt */
    case 343: /* exists_opt */
    case 394: /* analyze_opt */
    case 396: /* agg_func_opt */
    case 440: /* set_quantifier_opt */
{
 
}
      break;
    case 346: /* integer_list */
    case 347: /* variable_list */
    case 348: /* retention_list */
    case 352: /* column_def_list */
    case 353: /* tags_def_opt */
    case 355: /* multi_create_clause */
    case 356: /* tags_def */
    case 357: /* multi_drop_clause */
    case 364: /* specific_cols_opt */
    case 365: /* expression_list */
    case 367: /* col_name_list */
    case 370: /* duration_list */
    case 371: /* rollup_func_list */
    case 381: /* tag_list_opt */
    case 387: /* func_list */
    case 400: /* col_list_opt */
    case 403: /* dnode_list */
    case 407: /* literal_list */
    case 415: /* star_func_para_list */
    case 417: /* other_para_list */
    case 419: /* when_then_list */
    case 441: /* select_list */
    case 442: /* partition_by_clause_opt */
    case 447: /* group_by_clause_opt */
    case 450: /* partition_list */
    case 453: /* group_by_list */
    case 456: /* order_by_clause_opt */
    case 461: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy874)); 
}
      break;
    case 349: /* alter_db_option */
    case 372: /* alter_table_option */
{
 
}
      break;
    case 361: /* type_name */
{
 
}
      break;
    case 424: /* compare_op */
    case 425: /* in_op */
{
 
}
      break;
    case 437: /* join_type */
{
 
}
      break;
    case 452: /* fill_mode */
{
 
}
      break;
    case 463: /* ordering_specification_opt */
{
 
}
      break;
    case 464: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  326,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  326,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  327,    0 }, /* (2) account_options ::= */
  {  327,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  327,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  327,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  327,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  327,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  327,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  327,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  327,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  327,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  328,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  328,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  330,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  330,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  330,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  330,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  330,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  330,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  330,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  330,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  330,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  330,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  326,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  326,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  326,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  326,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  326,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  332,    0 }, /* (29) sysinfo_opt ::= */
  {  332,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  326,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  326,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  333,   -1 }, /* (33) privileges ::= ALL */
  {  333,   -1 }, /* (34) privileges ::= priv_type_list */
  {  333,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  335,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  335,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  336,   -1 }, /* (38) priv_type ::= READ */
  {  336,   -1 }, /* (39) priv_type ::= WRITE */
  {  334,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  334,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  334,   -1 }, /* (42) priv_level ::= topic_name */
  {  326,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  326,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  326,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  326,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  326,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  326,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  326,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  326,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  339,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  339,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  339,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  340,    0 }, /* (54) force_opt ::= */
  {  340,   -1 }, /* (55) force_opt ::= FORCE */
  {  326,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  326,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  326,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  326,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  326,   -2 }, /* (68) cmd ::= USE db_name */
  {  326,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  326,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  326,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  341,   -3 }, /* (72) not_exists_opt ::= IF NOT EXISTS */
  {  341,    0 }, /* (73) not_exists_opt ::= */
  {  343,   -2 }, /* (74) exists_opt ::= IF EXISTS */
  {  343,    0 }, /* (75) exists_opt ::= */
  {  342,    0 }, /* (76) db_options ::= */
  {  342,   -3 }, /* (77) db_options ::= db_options BUFFER NK_INTEGER */
  {  342,   -3 }, /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
  {  342,   -3 }, /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  342,   -3 }, /* (80) db_options ::= db_options COMP NK_INTEGER */
  {  342,   -3 }, /* (81) db_options ::= db_options DURATION NK_INTEGER */
  {  342,   -3 }, /* (82) db_options ::= db_options DURATION NK_VARIABLE */
  {  342,   -3 }, /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
  {  342,   -3 }, /* (84) db_options ::= db_options MINROWS NK_INTEGER */
  {  342,   -3 }, /* (85) db_options ::= db_options KEEP integer_list */
  {  342,   -3 }, /* (86) db_options ::= db_options KEEP variable_list */
  {  342,   -3 }, /* (87) db_options ::= db_options PAGES NK_INTEGER */
  {  342,   -3 }, /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  342,   -3 }, /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  342,   -3 }, /* (90) db_options ::= db_options PRECISION NK_STRING */
  {  342,   -3 }, /* (91) db_options ::= db_options REPLICA NK_INTEGER */
  {  342,   -3 }, /* (92) db_options ::= db_options VGROUPS NK_INTEGER */
  {  342,   -3 }, /* (93) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  342,   -3 }, /* (94) db_options ::= db_options RETENTIONS retention_list */
  {  342,   -3 }, /* (95) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  342,   -3 }, /* (96) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  342,   -3 }, /* (97) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  342,   -3 }, /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  342,   -4 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  342,   -3 }, /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  342,   -4 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  342,   -3 }, /* (102) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  342,   -3 }, /* (103) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  342,   -3 }, /* (104) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  342,   -3 }, /* (105) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  342,   -3 }, /* (106) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  344,   -1 }, /* (107) alter_db_options ::= alter_db_option */
  {  344,   -2 }, /* (108) alter_db_options ::= alter_db_options alter_db_option */
  {  349,   -2 }, /* (109) alter_db_option ::= BUFFER NK_INTEGER */
  {  349,   -2 }, /* (110) alter_db_option ::= CACHEMODEL NK_STRING */
  {  349,   -2 }, /* (111) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  349,   -2 }, /* (112) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  349,   -2 }, /* (113) alter_db_option ::= KEEP integer_list */
  {  349,   -2 }, /* (114) alter_db_option ::= KEEP variable_list */
  {  349,   -2 }, /* (115) alter_db_option ::= PAGES NK_INTEGER */
  {  349,   -2 }, /* (116) alter_db_option ::= REPLICA NK_INTEGER */
  {  349,   -2 }, /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  349,   -2 }, /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  346,   -1 }, /* (119) integer_list ::= NK_INTEGER */
  {  346,   -3 }, /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  347,   -1 }, /* (121) variable_list ::= NK_VARIABLE */
  {  347,   -3 }, /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  348,   -1 }, /* (123) retention_list ::= retention */
  {  348,   -3 }, /* (124) retention_list ::= retention_list NK_COMMA retention */
  {  350,   -3 }, /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  345,    0 }, /* (126) speed_opt ::= */
  {  345,   -2 }, /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  326,   -9 }, /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  326,   -3 }, /* (129) cmd ::= CREATE TABLE multi_create_clause */
  {  326,   -9 }, /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  326,   -3 }, /* (131) cmd ::= DROP TABLE multi_drop_clause */
  {  326,   -4 }, /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
  {  326,   -3 }, /* (133) cmd ::= ALTER TABLE alter_table_clause */
  {  326,   -3 }, /* (134) cmd ::= ALTER STABLE alter_table_clause */
  {  358,   -2 }, /* (135) alter_table_clause ::= full_table_name alter_table_options */
  {  358,   -5 }, /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  358,   -4 }, /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  358,   -5 }, /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  358,   -5 }, /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  358,   -5 }, /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  358,   -4 }, /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  358,   -5 }, /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  358,   -5 }, /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  358,   -6 }, /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  355,   -1 }, /* (145) multi_create_clause ::= create_subtable_clause */
  {  355,   -2 }, /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  363,  -10 }, /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  357,   -1 }, /* (148) multi_drop_clause ::= drop_table_clause */
  {  357,   -2 }, /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  366,   -2 }, /* (150) drop_table_clause ::= exists_opt full_table_name */
  {  364,    0 }, /* (151) specific_cols_opt ::= */
  {  364,   -3 }, /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  351,   -1 }, /* (153) full_table_name ::= table_name */
  {  351,   -3 }, /* (154) full_table_name ::= db_name NK_DOT table_name */
  {  352,   -1 }, /* (155) column_def_list ::= column_def */
  {  352,   -3 }, /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
  {  369,   -2 }, /* (157) column_def ::= column_name type_name */
  {  369,   -4 }, /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
  {  361,   -1 }, /* (159) type_name ::= BOOL */
  {  361,   -1 }, /* (160) type_name ::= TINYINT */
  {  361,   -1 }, /* (161) type_name ::= SMALLINT */
  {  361,   -1 }, /* (162) type_name ::= INT */
  {  361,   -1 }, /* (163) type_name ::= INTEGER */
  {  361,   -1 }, /* (164) type_name ::= BIGINT */
  {  361,   -1 }, /* (165) type_name ::= FLOAT */
  {  361,   -1 }, /* (166) type_name ::= DOUBLE */
  {  361,   -4 }, /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  361,   -1 }, /* (168) type_name ::= TIMESTAMP */
  {  361,   -4 }, /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  361,   -2 }, /* (170) type_name ::= TINYINT UNSIGNED */
  {  361,   -2 }, /* (171) type_name ::= SMALLINT UNSIGNED */
  {  361,   -2 }, /* (172) type_name ::= INT UNSIGNED */
  {  361,   -2 }, /* (173) type_name ::= BIGINT UNSIGNED */
  {  361,   -1 }, /* (174) type_name ::= JSON */
  {  361,   -4 }, /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  361,   -1 }, /* (176) type_name ::= MEDIUMBLOB */
  {  361,   -1 }, /* (177) type_name ::= BLOB */
  {  361,   -4 }, /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  361,   -1 }, /* (179) type_name ::= DECIMAL */
  {  361,   -4 }, /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  361,   -6 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  353,    0 }, /* (182) tags_def_opt ::= */
  {  353,   -1 }, /* (183) tags_def_opt ::= tags_def */
  {  356,   -4 }, /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  354,    0 }, /* (185) table_options ::= */
  {  354,   -3 }, /* (186) table_options ::= table_options COMMENT NK_STRING */
  {  354,   -3 }, /* (187) table_options ::= table_options MAX_DELAY duration_list */
  {  354,   -3 }, /* (188) table_options ::= table_options WATERMARK duration_list */
  {  354,   -5 }, /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  354,   -3 }, /* (190) table_options ::= table_options TTL NK_INTEGER */
  {  354,   -5 }, /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  354,   -3 }, /* (192) table_options ::= table_options DELETE_MARK duration_list */
  {  359,   -1 }, /* (193) alter_table_options ::= alter_table_option */
  {  359,   -2 }, /* (194) alter_table_options ::= alter_table_options alter_table_option */
  {  372,   -2 }, /* (195) alter_table_option ::= COMMENT NK_STRING */
  {  372,   -2 }, /* (196) alter_table_option ::= TTL NK_INTEGER */
  {  370,   -1 }, /* (197) duration_list ::= duration_literal */
  {  370,   -3 }, /* (198) duration_list ::= duration_list NK_COMMA duration_literal */
  {  371,   -1 }, /* (199) rollup_func_list ::= rollup_func_name */
  {  371,   -3 }, /* (200) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  374,   -1 }, /* (201) rollup_func_name ::= function_name */
  {  374,   -1 }, /* (202) rollup_func_name ::= FIRST */
  {  374,   -1 }, /* (203) rollup_func_name ::= LAST */
  {  367,   -1 }, /* (204) col_name_list ::= col_name */
  {  367,   -3 }, /* (205) col_name_list ::= col_name_list NK_COMMA col_name */
  {  376,   -1 }, /* (206) col_name ::= column_name */
  {  326,   -2 }, /* (207) cmd ::= SHOW DNODES */
  {  326,   -2 }, /* (208) cmd ::= SHOW USERS */
  {  326,   -3 }, /* (209) cmd ::= SHOW USER PRIVILEGES */
  {  326,   -2 }, /* (210) cmd ::= SHOW DATABASES */
  {  326,   -4 }, /* (211) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  326,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  326,   -3 }, /* (213) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  326,   -2 }, /* (214) cmd ::= SHOW MNODES */
  {  326,   -2 }, /* (215) cmd ::= SHOW QNODES */
  {  326,   -2 }, /* (216) cmd ::= SHOW FUNCTIONS */
  {  326,   -5 }, /* (217) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  326,   -2 }, /* (218) cmd ::= SHOW STREAMS */
  {  326,   -2 }, /* (219) cmd ::= SHOW ACCOUNTS */
  {  326,   -2 }, /* (220) cmd ::= SHOW APPS */
  {  326,   -2 }, /* (221) cmd ::= SHOW CONNECTIONS */
  {  326,   -2 }, /* (222) cmd ::= SHOW LICENCES */
  {  326,   -2 }, /* (223) cmd ::= SHOW GRANTS */
  {  326,   -4 }, /* (224) cmd ::= SHOW CREATE DATABASE db_name */
  {  326,   -4 }, /* (225) cmd ::= SHOW CREATE TABLE full_table_name */
  {  326,   -4 }, /* (226) cmd ::= SHOW CREATE STABLE full_table_name */
  {  326,   -2 }, /* (227) cmd ::= SHOW QUERIES */
  {  326,   -2 }, /* (228) cmd ::= SHOW SCORES */
  {  326,   -2 }, /* (229) cmd ::= SHOW TOPICS */
  {  326,   -2 }, /* (230) cmd ::= SHOW VARIABLES */
  {  326,   -3 }, /* (231) cmd ::= SHOW CLUSTER VARIABLES */
  {  326,   -3 }, /* (232) cmd ::= SHOW LOCAL VARIABLES */
  {  326,   -5 }, /* (233) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  326,   -2 }, /* (234) cmd ::= SHOW BNODES */
  {  326,   -2 }, /* (235) cmd ::= SHOW SNODES */
  {  326,   -2 }, /* (236) cmd ::= SHOW CLUSTER */
  {  326,   -2 }, /* (237) cmd ::= SHOW TRANSACTIONS */
  {  326,   -4 }, /* (238) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  326,   -2 }, /* (239) cmd ::= SHOW CONSUMERS */
  {  326,   -2 }, /* (240) cmd ::= SHOW SUBSCRIPTIONS */
  {  326,   -5 }, /* (241) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  326,   -7 }, /* (242) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  326,   -3 }, /* (243) cmd ::= SHOW VNODES NK_INTEGER */
  {  326,   -3 }, /* (244) cmd ::= SHOW VNODES NK_STRING */
  {  326,   -3 }, /* (245) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  326,   -3 }, /* (246) cmd ::= SHOW CLUSTER ALIVE */
  {  377,    0 }, /* (247) db_name_cond_opt ::= */
  {  377,   -2 }, /* (248) db_name_cond_opt ::= db_name NK_DOT */
  {  378,    0 }, /* (249) like_pattern_opt ::= */
  {  378,   -2 }, /* (250) like_pattern_opt ::= LIKE NK_STRING */
  {  379,   -1 }, /* (251) table_name_cond ::= table_name */
  {  380,    0 }, /* (252) from_db_opt ::= */
  {  380,   -2 }, /* (253) from_db_opt ::= FROM db_name */
  {  381,    0 }, /* (254) tag_list_opt ::= */
  {  381,   -1 }, /* (255) tag_list_opt ::= tag_item */
  {  381,   -3 }, /* (256) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  382,   -1 }, /* (257) tag_item ::= TBNAME */
  {  382,   -1 }, /* (258) tag_item ::= QTAGS */
  {  382,   -1 }, /* (259) tag_item ::= column_name */
  {  382,   -2 }, /* (260) tag_item ::= column_name column_alias */
  {  382,   -3 }, /* (261) tag_item ::= column_name AS column_alias */
  {  326,   -8 }, /* (262) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  326,   -9 }, /* (263) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  326,   -4 }, /* (264) cmd ::= DROP INDEX exists_opt full_index_name */
  {  384,   -1 }, /* (265) full_index_name ::= index_name */
  {  384,   -3 }, /* (266) full_index_name ::= db_name NK_DOT index_name */
  {  385,  -10 }, /* (267) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  385,  -12 }, /* (268) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  387,   -1 }, /* (269) func_list ::= func */
  {  387,   -3 }, /* (270) func_list ::= func_list NK_COMMA func */
  {  390,   -4 }, /* (271) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  391,   -1 }, /* (272) sma_func_name ::= function_name */
  {  391,   -1 }, /* (273) sma_func_name ::= COUNT */
  {  391,   -1 }, /* (274) sma_func_name ::= FIRST */
  {  391,   -1 }, /* (275) sma_func_name ::= LAST */
  {  391,   -1 }, /* (276) sma_func_name ::= LAST_ROW */
  {  389,    0 }, /* (277) sma_stream_opt ::= */
  {  389,   -3 }, /* (278) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  389,   -3 }, /* (279) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  389,   -3 }, /* (280) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  326,   -6 }, /* (281) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  326,   -7 }, /* (282) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  326,   -9 }, /* (283) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  326,   -7 }, /* (284) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  326,   -9 }, /* (285) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  326,   -4 }, /* (286) cmd ::= DROP TOPIC exists_opt topic_name */
  {  326,   -7 }, /* (287) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  326,   -2 }, /* (288) cmd ::= DESC full_table_name */
  {  326,   -2 }, /* (289) cmd ::= DESCRIBE full_table_name */
  {  326,   -3 }, /* (290) cmd ::= RESET QUERY CACHE */
  {  326,   -4 }, /* (291) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  394,    0 }, /* (292) analyze_opt ::= */
  {  394,   -1 }, /* (293) analyze_opt ::= ANALYZE */
  {  395,    0 }, /* (294) explain_options ::= */
  {  395,   -3 }, /* (295) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  395,   -3 }, /* (296) explain_options ::= explain_options RATIO NK_FLOAT */
  {  326,  -10 }, /* (297) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  326,   -4 }, /* (298) cmd ::= DROP FUNCTION exists_opt function_name */
  {  396,    0 }, /* (299) agg_func_opt ::= */
  {  396,   -1 }, /* (300) agg_func_opt ::= AGGREGATE */
  {  397,    0 }, /* (301) bufsize_opt ::= */
  {  397,   -2 }, /* (302) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  326,  -12 }, /* (303) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tags_def_opt subtable_opt AS query_or_subquery */
  {  326,   -4 }, /* (304) cmd ::= DROP STREAM exists_opt stream_name */
  {  400,    0 }, /* (305) col_list_opt ::= */
  {  400,   -3 }, /* (306) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  399,    0 }, /* (307) stream_options ::= */
  {  399,   -3 }, /* (308) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  399,   -3 }, /* (309) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  399,   -4 }, /* (310) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  399,   -3 }, /* (311) stream_options ::= stream_options WATERMARK duration_literal */
  {  399,   -4 }, /* (312) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  399,   -3 }, /* (313) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  401,    0 }, /* (314) subtable_opt ::= */
  {  401,   -4 }, /* (315) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  326,   -3 }, /* (316) cmd ::= KILL CONNECTION NK_INTEGER */
  {  326,   -3 }, /* (317) cmd ::= KILL QUERY NK_STRING */
  {  326,   -3 }, /* (318) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  326,   -2 }, /* (319) cmd ::= BALANCE VGROUP */
  {  326,   -4 }, /* (320) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  326,   -4 }, /* (321) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  326,   -3 }, /* (322) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  403,   -2 }, /* (323) dnode_list ::= DNODE NK_INTEGER */
  {  403,   -3 }, /* (324) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  326,   -4 }, /* (325) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  326,   -1 }, /* (326) cmd ::= query_or_subquery */
  {  326,   -7 }, /* (327) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  326,   -4 }, /* (328) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  329,   -1 }, /* (329) literal ::= NK_INTEGER */
  {  329,   -1 }, /* (330) literal ::= NK_FLOAT */
  {  329,   -1 }, /* (331) literal ::= NK_STRING */
  {  329,   -1 }, /* (332) literal ::= NK_BOOL */
  {  329,   -2 }, /* (333) literal ::= TIMESTAMP NK_STRING */
  {  329,   -1 }, /* (334) literal ::= duration_literal */
  {  329,   -1 }, /* (335) literal ::= NULL */
  {  329,   -1 }, /* (336) literal ::= NK_QUESTION */
  {  373,   -1 }, /* (337) duration_literal ::= NK_VARIABLE */
  {  405,   -1 }, /* (338) signed ::= NK_INTEGER */
  {  405,   -2 }, /* (339) signed ::= NK_PLUS NK_INTEGER */
  {  405,   -2 }, /* (340) signed ::= NK_MINUS NK_INTEGER */
  {  405,   -1 }, /* (341) signed ::= NK_FLOAT */
  {  405,   -2 }, /* (342) signed ::= NK_PLUS NK_FLOAT */
  {  405,   -2 }, /* (343) signed ::= NK_MINUS NK_FLOAT */
  {  362,   -1 }, /* (344) signed_literal ::= signed */
  {  362,   -1 }, /* (345) signed_literal ::= NK_STRING */
  {  362,   -1 }, /* (346) signed_literal ::= NK_BOOL */
  {  362,   -2 }, /* (347) signed_literal ::= TIMESTAMP NK_STRING */
  {  362,   -1 }, /* (348) signed_literal ::= duration_literal */
  {  362,   -1 }, /* (349) signed_literal ::= NULL */
  {  362,   -1 }, /* (350) signed_literal ::= literal_func */
  {  362,   -1 }, /* (351) signed_literal ::= NK_QUESTION */
  {  407,   -1 }, /* (352) literal_list ::= signed_literal */
  {  407,   -3 }, /* (353) literal_list ::= literal_list NK_COMMA signed_literal */
  {  337,   -1 }, /* (354) db_name ::= NK_ID */
  {  368,   -1 }, /* (355) table_name ::= NK_ID */
  {  360,   -1 }, /* (356) column_name ::= NK_ID */
  {  375,   -1 }, /* (357) function_name ::= NK_ID */
  {  408,   -1 }, /* (358) table_alias ::= NK_ID */
  {  383,   -1 }, /* (359) column_alias ::= NK_ID */
  {  331,   -1 }, /* (360) user_name ::= NK_ID */
  {  338,   -1 }, /* (361) topic_name ::= NK_ID */
  {  398,   -1 }, /* (362) stream_name ::= NK_ID */
  {  393,   -1 }, /* (363) cgroup_name ::= NK_ID */
  {  386,   -1 }, /* (364) index_name ::= NK_ID */
  {  409,   -1 }, /* (365) expr_or_subquery ::= expression */
  {  402,   -1 }, /* (366) expression ::= literal */
  {  402,   -1 }, /* (367) expression ::= pseudo_column */
  {  402,   -1 }, /* (368) expression ::= column_reference */
  {  402,   -1 }, /* (369) expression ::= function_expression */
  {  402,   -1 }, /* (370) expression ::= case_when_expression */
  {  402,   -3 }, /* (371) expression ::= NK_LP expression NK_RP */
  {  402,   -2 }, /* (372) expression ::= NK_PLUS expr_or_subquery */
  {  402,   -2 }, /* (373) expression ::= NK_MINUS expr_or_subquery */
  {  402,   -3 }, /* (374) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  402,   -3 }, /* (375) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  402,   -3 }, /* (376) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  402,   -3 }, /* (377) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  402,   -3 }, /* (378) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  402,   -3 }, /* (379) expression ::= column_reference NK_ARROW NK_STRING */
  {  402,   -3 }, /* (380) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  402,   -3 }, /* (381) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  365,   -1 }, /* (382) expression_list ::= expr_or_subquery */
  {  365,   -3 }, /* (383) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  411,   -1 }, /* (384) column_reference ::= column_name */
  {  411,   -3 }, /* (385) column_reference ::= table_name NK_DOT column_name */
  {  410,   -1 }, /* (386) pseudo_column ::= ROWTS */
  {  410,   -1 }, /* (387) pseudo_column ::= TBNAME */
  {  410,   -3 }, /* (388) pseudo_column ::= table_name NK_DOT TBNAME */
  {  410,   -1 }, /* (389) pseudo_column ::= QSTART */
  {  410,   -1 }, /* (390) pseudo_column ::= QEND */
  {  410,   -1 }, /* (391) pseudo_column ::= QDURATION */
  {  410,   -1 }, /* (392) pseudo_column ::= WSTART */
  {  410,   -1 }, /* (393) pseudo_column ::= WEND */
  {  410,   -1 }, /* (394) pseudo_column ::= WDURATION */
  {  410,   -1 }, /* (395) pseudo_column ::= IROWTS */
  {  410,   -1 }, /* (396) pseudo_column ::= ISFILLED */
  {  410,   -1 }, /* (397) pseudo_column ::= QTAGS */
  {  412,   -4 }, /* (398) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  412,   -4 }, /* (399) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  412,   -6 }, /* (400) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  412,   -1 }, /* (401) function_expression ::= literal_func */
  {  406,   -3 }, /* (402) literal_func ::= noarg_func NK_LP NK_RP */
  {  406,   -1 }, /* (403) literal_func ::= NOW */
  {  416,   -1 }, /* (404) noarg_func ::= NOW */
  {  416,   -1 }, /* (405) noarg_func ::= TODAY */
  {  416,   -1 }, /* (406) noarg_func ::= TIMEZONE */
  {  416,   -1 }, /* (407) noarg_func ::= DATABASE */
  {  416,   -1 }, /* (408) noarg_func ::= CLIENT_VERSION */
  {  416,   -1 }, /* (409) noarg_func ::= SERVER_VERSION */
  {  416,   -1 }, /* (410) noarg_func ::= SERVER_STATUS */
  {  416,   -1 }, /* (411) noarg_func ::= CURRENT_USER */
  {  416,   -1 }, /* (412) noarg_func ::= USER */
  {  414,   -1 }, /* (413) star_func ::= COUNT */
  {  414,   -1 }, /* (414) star_func ::= FIRST */
  {  414,   -1 }, /* (415) star_func ::= LAST */
  {  414,   -1 }, /* (416) star_func ::= LAST_ROW */
  {  415,   -1 }, /* (417) star_func_para_list ::= NK_STAR */
  {  415,   -1 }, /* (418) star_func_para_list ::= other_para_list */
  {  417,   -1 }, /* (419) other_para_list ::= star_func_para */
  {  417,   -3 }, /* (420) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  418,   -1 }, /* (421) star_func_para ::= expr_or_subquery */
  {  418,   -3 }, /* (422) star_func_para ::= table_name NK_DOT NK_STAR */
  {  413,   -4 }, /* (423) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  413,   -5 }, /* (424) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  419,   -1 }, /* (425) when_then_list ::= when_then_expr */
  {  419,   -2 }, /* (426) when_then_list ::= when_then_list when_then_expr */
  {  422,   -4 }, /* (427) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  420,    0 }, /* (428) case_when_else_opt ::= */
  {  420,   -2 }, /* (429) case_when_else_opt ::= ELSE common_expression */
  {  423,   -3 }, /* (430) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  423,   -5 }, /* (431) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  423,   -6 }, /* (432) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  423,   -3 }, /* (433) predicate ::= expr_or_subquery IS NULL */
  {  423,   -4 }, /* (434) predicate ::= expr_or_subquery IS NOT NULL */
  {  423,   -3 }, /* (435) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  424,   -1 }, /* (436) compare_op ::= NK_LT */
  {  424,   -1 }, /* (437) compare_op ::= NK_GT */
  {  424,   -1 }, /* (438) compare_op ::= NK_LE */
  {  424,   -1 }, /* (439) compare_op ::= NK_GE */
  {  424,   -1 }, /* (440) compare_op ::= NK_NE */
  {  424,   -1 }, /* (441) compare_op ::= NK_EQ */
  {  424,   -1 }, /* (442) compare_op ::= LIKE */
  {  424,   -2 }, /* (443) compare_op ::= NOT LIKE */
  {  424,   -1 }, /* (444) compare_op ::= MATCH */
  {  424,   -1 }, /* (445) compare_op ::= NMATCH */
  {  424,   -1 }, /* (446) compare_op ::= CONTAINS */
  {  425,   -1 }, /* (447) in_op ::= IN */
  {  425,   -2 }, /* (448) in_op ::= NOT IN */
  {  426,   -3 }, /* (449) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  427,   -1 }, /* (450) boolean_value_expression ::= boolean_primary */
  {  427,   -2 }, /* (451) boolean_value_expression ::= NOT boolean_primary */
  {  427,   -3 }, /* (452) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  427,   -3 }, /* (453) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  428,   -1 }, /* (454) boolean_primary ::= predicate */
  {  428,   -3 }, /* (455) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  421,   -1 }, /* (456) common_expression ::= expr_or_subquery */
  {  421,   -1 }, /* (457) common_expression ::= boolean_value_expression */
  {  429,    0 }, /* (458) from_clause_opt ::= */
  {  429,   -2 }, /* (459) from_clause_opt ::= FROM table_reference_list */
  {  430,   -1 }, /* (460) table_reference_list ::= table_reference */
  {  430,   -3 }, /* (461) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  431,   -1 }, /* (462) table_reference ::= table_primary */
  {  431,   -1 }, /* (463) table_reference ::= joined_table */
  {  432,   -2 }, /* (464) table_primary ::= table_name alias_opt */
  {  432,   -4 }, /* (465) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  432,   -2 }, /* (466) table_primary ::= subquery alias_opt */
  {  432,   -1 }, /* (467) table_primary ::= parenthesized_joined_table */
  {  434,    0 }, /* (468) alias_opt ::= */
  {  434,   -1 }, /* (469) alias_opt ::= table_alias */
  {  434,   -2 }, /* (470) alias_opt ::= AS table_alias */
  {  436,   -3 }, /* (471) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  436,   -3 }, /* (472) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  433,   -6 }, /* (473) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  437,    0 }, /* (474) join_type ::= */
  {  437,   -1 }, /* (475) join_type ::= INNER */
  {  439,  -12 }, /* (476) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  440,    0 }, /* (477) set_quantifier_opt ::= */
  {  440,   -1 }, /* (478) set_quantifier_opt ::= DISTINCT */
  {  440,   -1 }, /* (479) set_quantifier_opt ::= ALL */
  {  441,   -1 }, /* (480) select_list ::= select_item */
  {  441,   -3 }, /* (481) select_list ::= select_list NK_COMMA select_item */
  {  449,   -1 }, /* (482) select_item ::= NK_STAR */
  {  449,   -1 }, /* (483) select_item ::= common_expression */
  {  449,   -2 }, /* (484) select_item ::= common_expression column_alias */
  {  449,   -3 }, /* (485) select_item ::= common_expression AS column_alias */
  {  449,   -3 }, /* (486) select_item ::= table_name NK_DOT NK_STAR */
  {  404,    0 }, /* (487) where_clause_opt ::= */
  {  404,   -2 }, /* (488) where_clause_opt ::= WHERE search_condition */
  {  442,    0 }, /* (489) partition_by_clause_opt ::= */
  {  442,   -3 }, /* (490) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  450,   -1 }, /* (491) partition_list ::= partition_item */
  {  450,   -3 }, /* (492) partition_list ::= partition_list NK_COMMA partition_item */
  {  451,   -1 }, /* (493) partition_item ::= expr_or_subquery */
  {  451,   -2 }, /* (494) partition_item ::= expr_or_subquery column_alias */
  {  451,   -3 }, /* (495) partition_item ::= expr_or_subquery AS column_alias */
  {  446,    0 }, /* (496) twindow_clause_opt ::= */
  {  446,   -6 }, /* (497) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  446,   -4 }, /* (498) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  446,   -6 }, /* (499) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  446,   -8 }, /* (500) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  446,   -7 }, /* (501) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  388,    0 }, /* (502) sliding_opt ::= */
  {  388,   -4 }, /* (503) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  445,    0 }, /* (504) fill_opt ::= */
  {  445,   -4 }, /* (505) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  445,   -6 }, /* (506) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  452,   -1 }, /* (507) fill_mode ::= NONE */
  {  452,   -1 }, /* (508) fill_mode ::= PREV */
  {  452,   -1 }, /* (509) fill_mode ::= NULL */
  {  452,   -1 }, /* (510) fill_mode ::= LINEAR */
  {  452,   -1 }, /* (511) fill_mode ::= NEXT */
  {  447,    0 }, /* (512) group_by_clause_opt ::= */
  {  447,   -3 }, /* (513) group_by_clause_opt ::= GROUP BY group_by_list */
  {  453,   -1 }, /* (514) group_by_list ::= expr_or_subquery */
  {  453,   -3 }, /* (515) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  448,    0 }, /* (516) having_clause_opt ::= */
  {  448,   -2 }, /* (517) having_clause_opt ::= HAVING search_condition */
  {  443,    0 }, /* (518) range_opt ::= */
  {  443,   -6 }, /* (519) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  444,    0 }, /* (520) every_opt ::= */
  {  444,   -4 }, /* (521) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  454,   -4 }, /* (522) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  455,   -1 }, /* (523) query_simple ::= query_specification */
  {  455,   -1 }, /* (524) query_simple ::= union_query_expression */
  {  459,   -4 }, /* (525) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  459,   -3 }, /* (526) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  460,   -1 }, /* (527) query_simple_or_subquery ::= query_simple */
  {  460,   -1 }, /* (528) query_simple_or_subquery ::= subquery */
  {  392,   -1 }, /* (529) query_or_subquery ::= query_expression */
  {  392,   -1 }, /* (530) query_or_subquery ::= subquery */
  {  456,    0 }, /* (531) order_by_clause_opt ::= */
  {  456,   -3 }, /* (532) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  457,    0 }, /* (533) slimit_clause_opt ::= */
  {  457,   -2 }, /* (534) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  457,   -4 }, /* (535) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  457,   -4 }, /* (536) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  458,    0 }, /* (537) limit_clause_opt ::= */
  {  458,   -2 }, /* (538) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  458,   -4 }, /* (539) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  458,   -4 }, /* (540) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  435,   -3 }, /* (541) subquery ::= NK_LP query_expression NK_RP */
  {  435,   -3 }, /* (542) subquery ::= NK_LP subquery NK_RP */
  {  438,   -1 }, /* (543) search_condition ::= common_expression */
  {  461,   -1 }, /* (544) sort_specification_list ::= sort_specification */
  {  461,   -3 }, /* (545) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  462,   -3 }, /* (546) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  463,    0 }, /* (547) ordering_specification_opt ::= */
  {  463,   -1 }, /* (548) ordering_specification_opt ::= ASC */
  {  463,   -1 }, /* (549) ordering_specification_opt ::= DESC */
  {  464,    0 }, /* (550) null_ordering_opt ::= */
  {  464,   -2 }, /* (551) null_ordering_opt ::= NULLS FIRST */
  {  464,   -2 }, /* (552) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,327,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,328,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,327,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,330,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,328,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,330,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy179, &yymsp[-1].minor.yy0, yymsp[0].minor.yy113); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy179, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy179, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy179, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy179); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy113 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy113 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy159, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy179); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy159, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy179); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy159 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy159 = yymsp[0].minor.yy159; }
  yymsp[0].minor.yy159 = yylhsminor.yy159;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy159 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy159 = yymsp[-2].minor.yy159 | yymsp[0].minor.yy159; }
  yymsp[-2].minor.yy159 = yylhsminor.yy159;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy159 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy159 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy179 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy179 = yylhsminor.yy179;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy179 = yymsp[-2].minor.yy179; }
  yymsp[-2].minor.yy179 = yylhsminor.yy179;
        break;
      case 42: /* priv_level ::= topic_name */
      case 272: /* sma_func_name ::= function_name */ yytestcase(yyruleno==272);
      case 469: /* alias_opt ::= table_alias */ yytestcase(yyruleno==469);
{ yylhsminor.yy179 = yymsp[0].minor.yy179; }
  yymsp[0].minor.yy179 = yylhsminor.yy179;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy179, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy767); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy179, yymsp[0].minor.yy767); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 273: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==273);
      case 274: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==274);
      case 275: /* sma_func_name ::= LAST */ yytestcase(yyruleno==275);
      case 276: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==276);
      case 354: /* db_name ::= NK_ID */ yytestcase(yyruleno==354);
      case 355: /* table_name ::= NK_ID */ yytestcase(yyruleno==355);
      case 356: /* column_name ::= NK_ID */ yytestcase(yyruleno==356);
      case 357: /* function_name ::= NK_ID */ yytestcase(yyruleno==357);
      case 358: /* table_alias ::= NK_ID */ yytestcase(yyruleno==358);
      case 359: /* column_alias ::= NK_ID */ yytestcase(yyruleno==359);
      case 360: /* user_name ::= NK_ID */ yytestcase(yyruleno==360);
      case 361: /* topic_name ::= NK_ID */ yytestcase(yyruleno==361);
      case 362: /* stream_name ::= NK_ID */ yytestcase(yyruleno==362);
      case 363: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==363);
      case 364: /* index_name ::= NK_ID */ yytestcase(yyruleno==364);
      case 404: /* noarg_func ::= NOW */ yytestcase(yyruleno==404);
      case 405: /* noarg_func ::= TODAY */ yytestcase(yyruleno==405);
      case 406: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==406);
      case 407: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==407);
      case 408: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==408);
      case 409: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==409);
      case 410: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==410);
      case 411: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==411);
      case 412: /* noarg_func ::= USER */ yytestcase(yyruleno==412);
      case 413: /* star_func ::= COUNT */ yytestcase(yyruleno==413);
      case 414: /* star_func ::= FIRST */ yytestcase(yyruleno==414);
      case 415: /* star_func ::= LAST */ yytestcase(yyruleno==415);
      case 416: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==416);
{ yylhsminor.yy179 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy179 = yylhsminor.yy179;
        break;
      case 54: /* force_opt ::= */
      case 73: /* not_exists_opt ::= */ yytestcase(yyruleno==73);
      case 75: /* exists_opt ::= */ yytestcase(yyruleno==75);
      case 292: /* analyze_opt ::= */ yytestcase(yyruleno==292);
      case 299: /* agg_func_opt ::= */ yytestcase(yyruleno==299);
      case 477: /* set_quantifier_opt ::= */ yytestcase(yyruleno==477);
{ yymsp[1].minor.yy767 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 293: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==293);
      case 300: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==300);
      case 478: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==478);
{ yymsp[0].minor.yy767 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy767, &yymsp[-1].minor.yy179, yymsp[0].minor.yy602); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy767, &yymsp[0].minor.yy179); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy179); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy179, yymsp[0].minor.yy602); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy179); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy179, yymsp[0].minor.yy820); }
        break;
      case 72: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy767 = true; }
        break;
      case 74: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy767 = true; }
        break;
      case 76: /* db_options ::= */
{ yymsp[1].minor.yy602 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 77: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 78: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 79: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 80: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 81: /* db_options ::= db_options DURATION NK_INTEGER */
      case 82: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==82);
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 83: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 84: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 85: /* db_options ::= db_options KEEP integer_list */
      case 86: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==86);
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_KEEP, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 87: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 88: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 89: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 90: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 91: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 92: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 93: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 94: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_RETENTIONS, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 95: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 96: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 97: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-3].minor.yy602, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-3].minor.yy602, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 102: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 103: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 104: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 105: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 106: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 107: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy602 = createAlterDatabaseOptions(pCxt); yylhsminor.yy602 = setAlterDatabaseOption(pCxt, yylhsminor.yy602, &yymsp[0].minor.yy845); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 108: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy602 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy602, &yymsp[0].minor.yy845); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 109: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy845.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy845.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy845.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy845.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= KEEP integer_list */
      case 114: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==114);
{ yymsp[-1].minor.yy845.type = DB_OPTION_KEEP; yymsp[-1].minor.yy845.pList = yymsp[0].minor.yy874; }
        break;
      case 115: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy845.type = DB_OPTION_PAGES; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy845.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy845.type = DB_OPTION_WAL; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy845.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy874 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 120: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 324: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==324);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 121: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy874 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 122: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 123: /* retention_list ::= retention */
      case 145: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==145);
      case 148: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==148);
      case 155: /* column_def_list ::= column_def */ yytestcase(yyruleno==155);
      case 199: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==199);
      case 204: /* col_name_list ::= col_name */ yytestcase(yyruleno==204);
      case 255: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==255);
      case 269: /* func_list ::= func */ yytestcase(yyruleno==269);
      case 352: /* literal_list ::= signed_literal */ yytestcase(yyruleno==352);
      case 419: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==419);
      case 425: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==425);
      case 480: /* select_list ::= select_item */ yytestcase(yyruleno==480);
      case 491: /* partition_list ::= partition_item */ yytestcase(yyruleno==491);
      case 544: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==544);
{ yylhsminor.yy874 = createNodeList(pCxt, yymsp[0].minor.yy602); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 124: /* retention_list ::= retention_list NK_COMMA retention */
      case 156: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==205);
      case 256: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==256);
      case 270: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==270);
      case 353: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==353);
      case 420: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==420);
      case 481: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==481);
      case 492: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==492);
      case 545: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==545);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, yymsp[0].minor.yy602); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 125: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy602 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 126: /* speed_opt ::= */
      case 301: /* bufsize_opt ::= */ yytestcase(yyruleno==301);
{ yymsp[1].minor.yy820 = 0; }
        break;
      case 127: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 302: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==302);
{ yymsp[-1].minor.yy820 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 128: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 130: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==130);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy767, yymsp[-5].minor.yy602, yymsp[-3].minor.yy874, yymsp[-1].minor.yy874, yymsp[0].minor.yy602); }
        break;
      case 129: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy874); }
        break;
      case 131: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy874); }
        break;
      case 132: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy767, yymsp[0].minor.yy602); }
        break;
      case 133: /* cmd ::= ALTER TABLE alter_table_clause */
      case 326: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==326);
{ pCxt->pRootNode = yymsp[0].minor.yy602; }
        break;
      case 134: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy602); }
        break;
      case 135: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy602 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy602, yymsp[0].minor.yy602); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy602 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy602, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy179, yymsp[0].minor.yy394); }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy602 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy602, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy179); }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy602 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy602, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy179, yymsp[0].minor.yy394); }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy602 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy602, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy179, &yymsp[0].minor.yy179); }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 140: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy602 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy602, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy179, yymsp[0].minor.yy394); }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 141: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy602 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy602, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy179); }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 142: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy602 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy602, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy179, yymsp[0].minor.yy394); }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 143: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy602 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy602, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy179, &yymsp[0].minor.yy179); }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 144: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy602 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy602, &yymsp[-2].minor.yy179, yymsp[0].minor.yy602); }
  yymsp[-5].minor.yy602 = yylhsminor.yy602;
        break;
      case 146: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 149: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==149);
      case 426: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==426);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-1].minor.yy874, yymsp[0].minor.yy602); }
  yymsp[-1].minor.yy874 = yylhsminor.yy874;
        break;
      case 147: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy602 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy767, yymsp[-8].minor.yy602, yymsp[-6].minor.yy602, yymsp[-5].minor.yy874, yymsp[-2].minor.yy874, yymsp[0].minor.yy602); }
  yymsp[-9].minor.yy602 = yylhsminor.yy602;
        break;
      case 150: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy602 = createDropTableClause(pCxt, yymsp[-1].minor.yy767, yymsp[0].minor.yy602); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 151: /* specific_cols_opt ::= */
      case 182: /* tags_def_opt ::= */ yytestcase(yyruleno==182);
      case 254: /* tag_list_opt ::= */ yytestcase(yyruleno==254);
      case 305: /* col_list_opt ::= */ yytestcase(yyruleno==305);
      case 489: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==489);
      case 512: /* group_by_clause_opt ::= */ yytestcase(yyruleno==512);
      case 531: /* order_by_clause_opt ::= */ yytestcase(yyruleno==531);
{ yymsp[1].minor.yy874 = NULL; }
        break;
      case 152: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 306: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==306);
{ yymsp[-2].minor.yy874 = yymsp[-1].minor.yy874; }
        break;
      case 153: /* full_table_name ::= table_name */
{ yylhsminor.yy602 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy179, NULL); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 154: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy602 = createRealTableNode(pCxt, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy179, NULL); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 157: /* column_def ::= column_name type_name */
{ yylhsminor.yy602 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy179, yymsp[0].minor.yy394, NULL); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 158: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy602 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy179, yymsp[-2].minor.yy394, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 159: /* type_name ::= BOOL */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 160: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 161: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 162: /* type_name ::= INT */
      case 163: /* type_name ::= INTEGER */ yytestcase(yyruleno==163);
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 164: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 165: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 166: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 167: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy394 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 169: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy394 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy394 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy394 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 172: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy394 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 173: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy394 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 174: /* type_name ::= JSON */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 175: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy394 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 176: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 177: /* type_name ::= BLOB */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 178: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy394 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 180: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy394 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy394 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* tags_def_opt ::= tags_def */
      case 418: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==418);
{ yylhsminor.yy874 = yymsp[0].minor.yy874; }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 184: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy874 = yymsp[-1].minor.yy874; }
        break;
      case 185: /* table_options ::= */
{ yymsp[1].minor.yy602 = createDefaultTableOptions(pCxt); }
        break;
      case 186: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy602 = setTableOption(pCxt, yymsp[-2].minor.yy602, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 187: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy602 = setTableOption(pCxt, yymsp[-2].minor.yy602, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 188: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy602 = setTableOption(pCxt, yymsp[-2].minor.yy602, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 189: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy602 = setTableOption(pCxt, yymsp[-4].minor.yy602, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy874); }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 190: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy602 = setTableOption(pCxt, yymsp[-2].minor.yy602, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 191: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy602 = setTableOption(pCxt, yymsp[-4].minor.yy602, TABLE_OPTION_SMA, yymsp[-1].minor.yy874); }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 192: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy602 = setTableOption(pCxt, yymsp[-2].minor.yy602, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 193: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy602 = createAlterTableOptions(pCxt); yylhsminor.yy602 = setTableOption(pCxt, yylhsminor.yy602, yymsp[0].minor.yy845.type, &yymsp[0].minor.yy845.val); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 194: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy602 = setTableOption(pCxt, yymsp[-1].minor.yy602, yymsp[0].minor.yy845.type, &yymsp[0].minor.yy845.val); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 195: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy845.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 196: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy845.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* duration_list ::= duration_literal */
      case 382: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==382);
{ yylhsminor.yy874 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy602)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 198: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 383: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==383);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, releaseRawExprNode(pCxt, yymsp[0].minor.yy602)); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 201: /* rollup_func_name ::= function_name */
{ yylhsminor.yy602 = createFunctionNode(pCxt, &yymsp[0].minor.yy179, NULL); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 202: /* rollup_func_name ::= FIRST */
      case 203: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==203);
      case 258: /* tag_item ::= QTAGS */ yytestcase(yyruleno==258);
{ yylhsminor.yy602 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 206: /* col_name ::= column_name */
      case 259: /* tag_item ::= column_name */ yytestcase(yyruleno==259);
{ yylhsminor.yy602 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy179); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 207: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 208: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 209: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 210: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 211: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy602, yymsp[0].minor.yy602, OP_TYPE_LIKE); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy602, yymsp[0].minor.yy602, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy602, NULL, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy602, yymsp[-1].minor.yy602, OP_TYPE_EQUAL); }
        break;
      case 218: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 219: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 220: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 221: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 222: /* cmd ::= SHOW LICENCES */
      case 223: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==223);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 224: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy179); }
        break;
      case 225: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy602); }
        break;
      case 226: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy602); }
        break;
      case 227: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 228: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 229: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 230: /* cmd ::= SHOW VARIABLES */
      case 231: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==231);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 232: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy602); }
        break;
      case 234: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 235: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 237: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 238: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy602); }
        break;
      case 239: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 240: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 241: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy602, yymsp[-1].minor.yy602, OP_TYPE_EQUAL); }
        break;
      case 242: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy602, yymsp[0].minor.yy602, yymsp[-3].minor.yy874); }
        break;
      case 243: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 245: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy602,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 246: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 247: /* db_name_cond_opt ::= */
      case 252: /* from_db_opt ::= */ yytestcase(yyruleno==252);
{ yymsp[1].minor.yy602 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 248: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy602 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy179); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 249: /* like_pattern_opt ::= */
      case 314: /* subtable_opt ::= */ yytestcase(yyruleno==314);
      case 428: /* case_when_else_opt ::= */ yytestcase(yyruleno==428);
      case 458: /* from_clause_opt ::= */ yytestcase(yyruleno==458);
      case 487: /* where_clause_opt ::= */ yytestcase(yyruleno==487);
      case 496: /* twindow_clause_opt ::= */ yytestcase(yyruleno==496);
      case 502: /* sliding_opt ::= */ yytestcase(yyruleno==502);
      case 504: /* fill_opt ::= */ yytestcase(yyruleno==504);
      case 516: /* having_clause_opt ::= */ yytestcase(yyruleno==516);
      case 518: /* range_opt ::= */ yytestcase(yyruleno==518);
      case 520: /* every_opt ::= */ yytestcase(yyruleno==520);
      case 533: /* slimit_clause_opt ::= */ yytestcase(yyruleno==533);
      case 537: /* limit_clause_opt ::= */ yytestcase(yyruleno==537);
{ yymsp[1].minor.yy602 = NULL; }
        break;
      case 250: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 251: /* table_name_cond ::= table_name */
{ yylhsminor.yy602 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy179); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 253: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy602 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy179); }
        break;
      case 257: /* tag_item ::= TBNAME */
{ yylhsminor.yy602 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 260: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy602 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy179), &yymsp[0].minor.yy179); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 261: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy602 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy179), &yymsp[0].minor.yy179); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 262: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy767, yymsp[-3].minor.yy602, yymsp[-1].minor.yy602, NULL, yymsp[0].minor.yy602); }
        break;
      case 263: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy767, yymsp[-5].minor.yy602, yymsp[-3].minor.yy602, yymsp[-1].minor.yy874, NULL); }
        break;
      case 264: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy767, yymsp[0].minor.yy602); }
        break;
      case 265: /* full_index_name ::= index_name */
{ yylhsminor.yy602 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy179); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 266: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy602 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy179); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 267: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy602 = createIndexOption(pCxt, yymsp[-7].minor.yy874, releaseRawExprNode(pCxt, yymsp[-3].minor.yy602), NULL, yymsp[-1].minor.yy602, yymsp[0].minor.yy602); }
        break;
      case 268: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy602 = createIndexOption(pCxt, yymsp[-9].minor.yy874, releaseRawExprNode(pCxt, yymsp[-5].minor.yy602), releaseRawExprNode(pCxt, yymsp[-3].minor.yy602), yymsp[-1].minor.yy602, yymsp[0].minor.yy602); }
        break;
      case 271: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy602 = createFunctionNode(pCxt, &yymsp[-3].minor.yy179, yymsp[-1].minor.yy874); }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 277: /* sma_stream_opt ::= */
      case 307: /* stream_options ::= */ yytestcase(yyruleno==307);
{ yymsp[1].minor.yy602 = createStreamOptions(pCxt); }
        break;
      case 278: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 311: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==311);
{ ((SStreamOptions*)yymsp[-2].minor.yy602)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy602); yylhsminor.yy602 = yymsp[-2].minor.yy602; }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 279: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy602)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy602); yylhsminor.yy602 = yymsp[-2].minor.yy602; }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 280: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy602)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy602); yylhsminor.yy602 = yymsp[-2].minor.yy602; }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 281: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy767, &yymsp[-2].minor.yy179, yymsp[0].minor.yy602); }
        break;
      case 282: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy767, &yymsp[-3].minor.yy179, &yymsp[0].minor.yy179, false); }
        break;
      case 283: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy767, &yymsp[-5].minor.yy179, &yymsp[0].minor.yy179, true); }
        break;
      case 284: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy767, &yymsp[-3].minor.yy179, yymsp[0].minor.yy602, false); }
        break;
      case 285: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy767, &yymsp[-5].minor.yy179, yymsp[0].minor.yy602, true); }
        break;
      case 286: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy767, &yymsp[0].minor.yy179); }
        break;
      case 287: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy767, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy179); }
        break;
      case 288: /* cmd ::= DESC full_table_name */
      case 289: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==289);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy602); }
        break;
      case 290: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 291: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy767, yymsp[-1].minor.yy602, yymsp[0].minor.yy602); }
        break;
      case 294: /* explain_options ::= */
{ yymsp[1].minor.yy602 = createDefaultExplainOptions(pCxt); }
        break;
      case 295: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy602 = setExplainVerbose(pCxt, yymsp[-2].minor.yy602, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 296: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy602 = setExplainRatio(pCxt, yymsp[-2].minor.yy602, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 297: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy767, yymsp[-8].minor.yy767, &yymsp[-5].minor.yy179, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy394, yymsp[0].minor.yy820); }
        break;
      case 298: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy767, &yymsp[0].minor.yy179); }
        break;
      case 303: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy767, &yymsp[-8].minor.yy179, yymsp[-5].minor.yy602, yymsp[-7].minor.yy602, yymsp[-3].minor.yy874, yymsp[-2].minor.yy602, yymsp[0].minor.yy602, yymsp[-4].minor.yy874); }
        break;
      case 304: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy767, &yymsp[0].minor.yy179); }
        break;
      case 308: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy602)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy602 = yymsp[-2].minor.yy602; }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 309: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy602)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy602 = yymsp[-2].minor.yy602; }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 310: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy602)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy602)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy602); yylhsminor.yy602 = yymsp[-3].minor.yy602; }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 312: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy602)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy602 = yymsp[-3].minor.yy602; }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 313: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy602)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy602 = yymsp[-2].minor.yy602; }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 315: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 503: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==503);
      case 521: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==521);
{ yymsp[-3].minor.yy602 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy602); }
        break;
      case 316: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 317: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 318: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 319: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 320: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 321: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy874); }
        break;
      case 322: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 323: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy874 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 325: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy602, yymsp[0].minor.yy602); }
        break;
      case 327: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy602, yymsp[-2].minor.yy874, yymsp[0].minor.yy602); }
        break;
      case 328: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy602, NULL, yymsp[0].minor.yy602); }
        break;
      case 329: /* literal ::= NK_INTEGER */
{ yylhsminor.yy602 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 330: /* literal ::= NK_FLOAT */
{ yylhsminor.yy602 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 331: /* literal ::= NK_STRING */
{ yylhsminor.yy602 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 332: /* literal ::= NK_BOOL */
{ yylhsminor.yy602 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 333: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 334: /* literal ::= duration_literal */
      case 344: /* signed_literal ::= signed */ yytestcase(yyruleno==344);
      case 365: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==365);
      case 366: /* expression ::= literal */ yytestcase(yyruleno==366);
      case 367: /* expression ::= pseudo_column */ yytestcase(yyruleno==367);
      case 368: /* expression ::= column_reference */ yytestcase(yyruleno==368);
      case 369: /* expression ::= function_expression */ yytestcase(yyruleno==369);
      case 370: /* expression ::= case_when_expression */ yytestcase(yyruleno==370);
      case 401: /* function_expression ::= literal_func */ yytestcase(yyruleno==401);
      case 450: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==450);
      case 454: /* boolean_primary ::= predicate */ yytestcase(yyruleno==454);
      case 456: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==456);
      case 457: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==457);
      case 460: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==460);
      case 462: /* table_reference ::= table_primary */ yytestcase(yyruleno==462);
      case 463: /* table_reference ::= joined_table */ yytestcase(yyruleno==463);
      case 467: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==467);
      case 523: /* query_simple ::= query_specification */ yytestcase(yyruleno==523);
      case 524: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==524);
      case 527: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==527);
      case 529: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==529);
{ yylhsminor.yy602 = yymsp[0].minor.yy602; }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 335: /* literal ::= NULL */
{ yylhsminor.yy602 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 336: /* literal ::= NK_QUESTION */
{ yylhsminor.yy602 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 337: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy602 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 338: /* signed ::= NK_INTEGER */
{ yylhsminor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 339: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 340: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 341: /* signed ::= NK_FLOAT */
{ yylhsminor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 342: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 343: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 345: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 346: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 347: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 348: /* signed_literal ::= duration_literal */
      case 350: /* signed_literal ::= literal_func */ yytestcase(yyruleno==350);
      case 421: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==421);
      case 483: /* select_item ::= common_expression */ yytestcase(yyruleno==483);
      case 493: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==493);
      case 528: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==528);
      case 530: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==530);
      case 543: /* search_condition ::= common_expression */ yytestcase(yyruleno==543);
{ yylhsminor.yy602 = releaseRawExprNode(pCxt, yymsp[0].minor.yy602); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 349: /* signed_literal ::= NULL */
{ yylhsminor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 351: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy602 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 371: /* expression ::= NK_LP expression NK_RP */
      case 455: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==455);
      case 542: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==542);
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy602)); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 372: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy602));
                                                                                  }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 373: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy602), NULL));
                                                                                  }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 374: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602))); 
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 375: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602))); 
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 376: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602))); 
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 377: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602))); 
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 378: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602)));
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 379: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 380: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602)));
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 381: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602)));
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 384: /* column_reference ::= column_name */
{ yylhsminor.yy602 = createRawExprNode(pCxt, &yymsp[0].minor.yy179, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy179)); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 385: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy179, createColumnNode(pCxt, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy179)); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 386: /* pseudo_column ::= ROWTS */
      case 387: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==387);
      case 389: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==389);
      case 390: /* pseudo_column ::= QEND */ yytestcase(yyruleno==390);
      case 391: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==391);
      case 392: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==392);
      case 393: /* pseudo_column ::= WEND */ yytestcase(yyruleno==393);
      case 394: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==394);
      case 395: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==395);
      case 396: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==396);
      case 397: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==397);
      case 403: /* literal_func ::= NOW */ yytestcase(yyruleno==403);
{ yylhsminor.yy602 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 388: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy179)))); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 398: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 399: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==399);
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy179, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy179, yymsp[-1].minor.yy874)); }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 400: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy602), yymsp[-1].minor.yy394)); }
  yymsp[-5].minor.yy602 = yylhsminor.yy602;
        break;
      case 402: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy179, NULL)); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 417: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy874 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 422: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 486: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==486);
{ yylhsminor.yy602 = createColumnNode(pCxt, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 423: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy874, yymsp[-1].minor.yy602)); }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 424: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy602), yymsp[-2].minor.yy874, yymsp[-1].minor.yy602)); }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 427: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy602 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602)); }
        break;
      case 429: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy602 = releaseRawExprNode(pCxt, yymsp[0].minor.yy602); }
        break;
      case 430: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 435: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==435);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy290, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602)));
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 431: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy602), releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602)));
                                                                                  }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 432: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy602), releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602)));
                                                                                  }
  yymsp[-5].minor.yy602 = yylhsminor.yy602;
        break;
      case 433: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), NULL));
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 434: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy602), NULL));
                                                                                  }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 436: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy290 = OP_TYPE_LOWER_THAN; }
        break;
      case 437: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy290 = OP_TYPE_GREATER_THAN; }
        break;
      case 438: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy290 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 439: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy290 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 440: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy290 = OP_TYPE_NOT_EQUAL; }
        break;
      case 441: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy290 = OP_TYPE_EQUAL; }
        break;
      case 442: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy290 = OP_TYPE_LIKE; }
        break;
      case 443: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy290 = OP_TYPE_NOT_LIKE; }
        break;
      case 444: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy290 = OP_TYPE_MATCH; }
        break;
      case 445: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy290 = OP_TYPE_NMATCH; }
        break;
      case 446: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy290 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 447: /* in_op ::= IN */
{ yymsp[0].minor.yy290 = OP_TYPE_IN; }
        break;
      case 448: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy290 = OP_TYPE_NOT_IN; }
        break;
      case 449: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy874)); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 451: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy602), NULL));
                                                                                  }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 452: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602)));
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 453: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602)));
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 459: /* from_clause_opt ::= FROM table_reference_list */
      case 488: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==488);
      case 517: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==517);
{ yymsp[-1].minor.yy602 = yymsp[0].minor.yy602; }
        break;
      case 461: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy602 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy602, yymsp[0].minor.yy602, NULL); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 464: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy602 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy179, &yymsp[0].minor.yy179); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 465: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy602 = createRealTableNode(pCxt, &yymsp[-3].minor.yy179, &yymsp[-1].minor.yy179, &yymsp[0].minor.yy179); }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 466: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy602 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy602), &yymsp[0].minor.yy179); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 468: /* alias_opt ::= */
{ yymsp[1].minor.yy179 = nil_token;  }
        break;
      case 470: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy179 = yymsp[0].minor.yy179; }
        break;
      case 471: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 472: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==472);
{ yymsp[-2].minor.yy602 = yymsp[-1].minor.yy602; }
        break;
      case 473: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy602 = createJoinTableNode(pCxt, yymsp[-4].minor.yy42, yymsp[-5].minor.yy602, yymsp[-2].minor.yy602, yymsp[0].minor.yy602); }
  yymsp[-5].minor.yy602 = yylhsminor.yy602;
        break;
      case 474: /* join_type ::= */
{ yymsp[1].minor.yy42 = JOIN_TYPE_INNER; }
        break;
      case 475: /* join_type ::= INNER */
{ yymsp[0].minor.yy42 = JOIN_TYPE_INNER; }
        break;
      case 476: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy602 = createSelectStmt(pCxt, yymsp[-10].minor.yy767, yymsp[-9].minor.yy874, yymsp[-8].minor.yy602);
                                                                                    yymsp[-11].minor.yy602 = addWhereClause(pCxt, yymsp[-11].minor.yy602, yymsp[-7].minor.yy602);
                                                                                    yymsp[-11].minor.yy602 = addPartitionByClause(pCxt, yymsp[-11].minor.yy602, yymsp[-6].minor.yy874);
                                                                                    yymsp[-11].minor.yy602 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy602, yymsp[-2].minor.yy602);
                                                                                    yymsp[-11].minor.yy602 = addGroupByClause(pCxt, yymsp[-11].minor.yy602, yymsp[-1].minor.yy874);
                                                                                    yymsp[-11].minor.yy602 = addHavingClause(pCxt, yymsp[-11].minor.yy602, yymsp[0].minor.yy602);
                                                                                    yymsp[-11].minor.yy602 = addRangeClause(pCxt, yymsp[-11].minor.yy602, yymsp[-5].minor.yy602);
                                                                                    yymsp[-11].minor.yy602 = addEveryClause(pCxt, yymsp[-11].minor.yy602, yymsp[-4].minor.yy602);
                                                                                    yymsp[-11].minor.yy602 = addFillClause(pCxt, yymsp[-11].minor.yy602, yymsp[-3].minor.yy602);
                                                                                  }
        break;
      case 479: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy767 = false; }
        break;
      case 482: /* select_item ::= NK_STAR */
{ yylhsminor.yy602 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 484: /* select_item ::= common_expression column_alias */
      case 494: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==494);
{ yylhsminor.yy602 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy602), &yymsp[0].minor.yy179); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 485: /* select_item ::= common_expression AS column_alias */
      case 495: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==495);
{ yylhsminor.yy602 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), &yymsp[0].minor.yy179); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 490: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 513: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==513);
      case 532: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==532);
{ yymsp[-2].minor.yy874 = yymsp[0].minor.yy874; }
        break;
      case 497: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy602 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy602), releaseRawExprNode(pCxt, yymsp[-1].minor.yy602)); }
        break;
      case 498: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy602 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy602)); }
        break;
      case 499: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy602 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy602), NULL, yymsp[-1].minor.yy602, yymsp[0].minor.yy602); }
        break;
      case 500: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy602 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy602), releaseRawExprNode(pCxt, yymsp[-3].minor.yy602), yymsp[-1].minor.yy602, yymsp[0].minor.yy602); }
        break;
      case 501: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy602 = createEventWindowNode(pCxt, yymsp[-3].minor.yy602, yymsp[0].minor.yy602); }
        break;
      case 505: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy602 = createFillNode(pCxt, yymsp[-1].minor.yy324, NULL); }
        break;
      case 506: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy602 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy874)); }
        break;
      case 507: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy324 = FILL_MODE_NONE; }
        break;
      case 508: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy324 = FILL_MODE_PREV; }
        break;
      case 509: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy324 = FILL_MODE_NULL; }
        break;
      case 510: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy324 = FILL_MODE_LINEAR; }
        break;
      case 511: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy324 = FILL_MODE_NEXT; }
        break;
      case 514: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy874 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy602))); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 515: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy602))); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 519: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy602 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy602), releaseRawExprNode(pCxt, yymsp[-1].minor.yy602)); }
        break;
      case 522: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy602 = addOrderByClause(pCxt, yymsp[-3].minor.yy602, yymsp[-2].minor.yy874);
                                                                                    yylhsminor.yy602 = addSlimitClause(pCxt, yylhsminor.yy602, yymsp[-1].minor.yy602);
                                                                                    yylhsminor.yy602 = addLimitClause(pCxt, yylhsminor.yy602, yymsp[0].minor.yy602);
                                                                                  }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 525: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy602 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy602, yymsp[0].minor.yy602); }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 526: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy602 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy602, yymsp[0].minor.yy602); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 534: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 538: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==538);
{ yymsp[-1].minor.yy602 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 535: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 539: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==539);
{ yymsp[-3].minor.yy602 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 536: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 540: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==540);
{ yymsp[-3].minor.yy602 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 541: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy602); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 546: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy602 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), yymsp[-1].minor.yy878, yymsp[0].minor.yy487); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 547: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy878 = ORDER_ASC; }
        break;
      case 548: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy878 = ORDER_ASC; }
        break;
      case 549: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy878 = ORDER_DESC; }
        break;
      case 550: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy487 = NULL_ORDER_DEFAULT; }
        break;
      case 551: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy487 = NULL_ORDER_FIRST; }
        break;
      case 552: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy487 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
