/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 258
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  ENullOrder yy73;
  SNodeList* yy136;
  SNode* yy140;
  EJoinType yy144;
  SToken yy149;
  EOrder yy158;
  int32_t yy160;
  SAlterOption yy233;
  SDataType yy256;
  EFillMode yy306;
  EOperatorType yy320;
  bool yy497;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYNSTATE             430
#define YYNRULE              337
#define YYNTOKEN             163
#define YY_MAX_SHIFT         429
#define YY_MIN_SHIFTREDUCE   662
#define YY_MAX_SHIFTREDUCE   998
#define YY_ERROR_ACTION      999
#define YY_ACCEPT_ACTION     1000
#define YY_NO_ACTION         1001
#define YY_MIN_REDUCE        1002
#define YY_MAX_REDUCE        1338
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1263)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1045, 1204,  225,   43,   24,  170,  362, 1200, 1206, 1095,
 /*    10 */   250,  269,   89,   31,   29,   27,   26,   25,   20, 1204,
 /*    20 */  1101,   27,   26,   25, 1084, 1200, 1205, 1106,   31,   29,
 /*    30 */    27,   26,   25,  361, 1000,   78,  209,  869,   77,   76,
 /*    40 */    75,   74,   73,   72,   71,   70,   69, 1091,  211,  414,
 /*    50 */   413,  412,  411,  410,  409,  408,  407,  406,  405,  404,
 /*    60 */   403,  402,  401,  400,  399,  398,  397,  396, 1003,  105,
 /*    70 */   270, 1014,  881,   31,   29,   27,   26,   25, 1231,  132,
 /*    80 */   904,  349,  111,  249,  237,  346, 1216, 1180,  275,   78,
 /*    90 */   131,   22,   77,   76,   75,   74,   73,   72,   71,   70,
 /*   100 */    69,   31,   29,   27,   26,   25, 1231, 1317,  211,  291,
 /*   110 */   320,  286,  270,  346,  290,   44,  905,  289,  129,  287,
 /*   120 */   117,  345,  288,  348, 1315,   23,  232, 1192,  899,  900,
 /*   130 */   901,  902,  903,  907,  908,  909, 1082,  204, 1217, 1220,
 /*   140 */   904,  772,  385,  384,  383,  776,  382,  778,  779,  381,
 /*   150 */   781,  378,  109,  787,  375,  789,  790,  372,  369, 1151,
 /*   160 */  1216,  849,  128, 1144,  305,  224,  125,   43,  326,  189,
 /*   170 */  1149,  361, 1136,   30,   28,  941,  905,  847,  258,  242,
 /*   180 */  1231,  234,  395,  849, 1102,   23,  232,  346,  899,  900,
 /*   190 */   901,  902,  903,  907,  908,  909, 1204,  348,  361,  847,
 /*   200 */   896, 1192, 1200, 1205,  306,  362,  334,  848,   12,  118,
 /*   210 */    66,   61, 1217, 1220, 1256, 1216,  965,  279,  210, 1252,
 /*   220 */  1168,   10,  122,  121,   30,   28, 1106,  120, 1317,  848,
 /*   230 */  1317,    1,  234,  426,  849, 1231,  316,  963,  964,  966,
 /*   240 */   967,  117,  333,  117, 1216, 1315,  245, 1315,   10,  324,
 /*   250 */   847,  337,  348, 1171, 1173,  426, 1192,  349,  699,   12,
 /*   260 */   698,  850,  853, 1181, 1231,  362,   62, 1217, 1220, 1256,
 /*   270 */    66,  333,  283,  227, 1252,  112,  282,  285,  700,  330,
 /*   280 */   848,  348,    1,  850,  853, 1192, 1106,  166,  118,    9,
 /*   290 */     8,   59, 1216,  312, 1283,   62, 1217, 1220, 1256,  284,
 /*   300 */    92,   93,  227, 1252,  112, 1317,  426,  330, 1098,  106,
 /*   310 */  1073,  906, 1231,   31,   29,   27,   26,   25, 1316,  346,
 /*   320 */    21, 1216, 1315, 1284,  395, 1270,   90,  871,   92,  348,
 /*   330 */   910,  422,  421, 1192,  850,  853,  114, 1263, 1264,  870,
 /*   340 */  1268, 1231, 1267,   62, 1217, 1220, 1256,  334,  346,  118,
 /*   350 */   227, 1252, 1329,  698,   90, 1097, 1216,  867,  348,  917,
 /*   360 */  1231, 1290, 1192,  868,  163, 1263,  329,  346,  328,  277,
 /*   370 */   238, 1317,   62, 1217, 1220, 1256, 1231,  362,  104,  227,
 /*   380 */  1252, 1329, 1103,  346,  117, 1216, 1108,  388, 1315, 1025,
 /*   390 */  1313, 1093,  323,  348,   30,   28, 1192, 1192, 1106, 1024,
 /*   400 */  1270,  336,  234,  104,  849, 1231, 1083,   62, 1217, 1220,
 /*   410 */  1256, 1109,  346, 1151,  227, 1252, 1329, 1266,  362,  239,
 /*   420 */   847, 1151,  348,  359, 1149, 1274, 1192,  246,  165,   12,
 /*   430 */  1192,  334, 1149,   30,   28, 1015,  199, 1217, 1220, 1106,
 /*   440 */  1192,  234, 1216,  849,  194, 1023, 1022, 1021,  137,  196,
 /*   450 */   848,  135,    1, 1041,  319, 1317,   30,   28,  347,  847,
 /*   460 */     6,  195, 1231,  392,  234, 1216,  849,  391,  117,  346,
 /*   470 */  1020,  123, 1315, 1151,  118,  292,  426,  325,  321,  348,
 /*   480 */  1019, 1018,  847, 1192, 1172, 1231, 1192, 1192, 1192,  848,
 /*   490 */   393,    7,  346,   63, 1217, 1220, 1256, 1151,  872, 1089,
 /*   500 */  1255, 1252,  348, 1048,  850,  853, 1192,  948, 1150,  390,
 /*   510 */   389, 1192,  848,  869,    7,  426,   63, 1217, 1220, 1256,
 /*   520 */   244, 1192, 1192,  344, 1252,   30,   28,  303,  104,   30,
 /*   530 */    28,   64,  387,  234,  341,  849, 1108,  234,  426,  849,
 /*   540 */   301, 1216, 1270,  850,  853, 1002,   31,   29,   27,   26,
 /*   550 */    25,  847,  291,  936,  286,  847, 1017,  290,  118, 1265,
 /*   560 */   289, 1231,  287,  118, 1216,  288,  850,  853,  346,   87,
 /*   570 */    86,   85,   84,   83,   82,   81,   80,   79,  348,  867,
 /*   580 */  1036,  848, 1192,    7, 1231,  848,  251,    1, 1074,  263,
 /*   590 */  1016,  346,  107, 1217, 1220,  940,  429, 1192,  264,  151,
 /*   600 */  1216,  348,  294,  167,  362, 1192,  247,  426,  342,  360,
 /*   610 */   187,  426,  308,   88,  104,   63, 1217, 1220, 1256,  418,
 /*   620 */  1231,  186, 1108, 1253,   98, 1106, 1013,  346,  317,  335,
 /*   630 */  1330, 1192, 1034, 1012, 1011,  850,  853,  348,  362,  850,
 /*   640 */   853, 1192, 1145,  184,  233,  362,   60, 1010, 1009,  182,
 /*   650 */   248,  205, 1217, 1220,  297, 1008,  160, 1007, 1216, 1106,
 /*   660 */  1275,  936, 1232, 1216,  276,  262, 1106, 1192,  257,  256,
 /*   670 */   255,  254,  253,  338, 1192, 1192, 1006,  856, 1231,  139,
 /*   680 */   358, 1216,  138, 1231,  141,  346, 1216,  140, 1192, 1192,
 /*   690 */   346,  855,  994,  995,  311,  348, 1192,  147, 1192, 1192,
 /*   700 */   348, 1231,  313,  330, 1192,  331, 1231,  859,  346,  205,
 /*   710 */  1217, 1220, 1005,  346,  107, 1217, 1220, 1192,  348,    9,
 /*   720 */     8,  858, 1192,  348,   92,  231,  867, 1192, 1216,  939,
 /*   730 */   235, 1216,  205, 1217, 1220, 1286, 1216,  205, 1217, 1220,
 /*   740 */    31,   29,   27,   26,   25,  339,  330, 1170, 1231,   52,
 /*   750 */    90, 1231, 1331, 1192,  169,  346, 1231, 1081,  346,  332,
 /*   760 */   113, 1263, 1264,  346, 1268,  348, 1099,   92,  348, 1192,
 /*   770 */     2,  119, 1192,  348, 1216,  143,  260, 1192,  142,  203,
 /*   780 */  1217, 1220,  206, 1217, 1220,  962,  156,  197, 1217, 1220,
 /*   790 */   252,  259,  261,   90, 1231,  265, 1216,   41,  154,  881,
 /*   800 */   911,  346, 1216,  115, 1263, 1264,  875, 1268,  997,  998,
 /*   810 */   266,  348,   32,  267,  392, 1192, 1231,  124,  391,  874,
 /*   820 */   878,   58, 1231,  346,  127,  207, 1217, 1220, 1210,  346,
 /*   830 */  1216,   54,   32,  348,  842,  268, 1216, 1192,  271,  348,
 /*   840 */  1208,  393,   42, 1192,  278,  130,   32,  198, 1217, 1220,
 /*   850 */  1231,  873,   68,  208, 1217, 1220, 1231,  346,  175,  280,
 /*   860 */   390,  389,  223,  346, 1216, 1096,  354,  348,  181,  134,
 /*   870 */   173, 1192, 1092,  348,  765,  136,  100, 1192,   95,  101,
 /*   880 */    96, 1228, 1217, 1220, 1231, 1094,   98, 1227, 1217, 1220,
 /*   890 */   760,  346, 1216, 1090,  793,  797,  102,  803, 1216,  802,
 /*   900 */   310,  348,   41,  103,  146, 1192,  367,   96,   99,   97,
 /*   910 */   149,   98, 1231,  307,  309, 1226, 1217, 1220, 1231,  346,
 /*   920 */    96,  872,  318, 1297, 1287,  346,  352,  152,  853,  348,
 /*   930 */   315, 1296, 1216, 1192,  226,  348,    5,  159,  155, 1192,
 /*   940 */  1216,  322,  327,  214, 1217, 1220,  241,  240, 1277,  213,
 /*   950 */  1217, 1220, 1231,  314,    4,  161,  861,  936,   91,  346,
 /*   960 */  1231,  871,  110, 1271,   33,  162,  228,  346, 1216,  348,
 /*   970 */  1332,  340,  854, 1192,  296,  218,  343,  348,   17, 1238,
 /*   980 */  1179, 1192,  168,  215, 1217, 1220,  350, 1314, 1231,  304,
 /*   990 */   351,  212, 1217, 1220,  355,  346, 1178,  283,  356,  236,
 /*  1000 */   177,  282,  857,  145,  357,  348,  299,  179,   53, 1192,
 /*  1010 */    51,  293,  188,  219,  144,  217,  216,  190,  281,  202,
 /*  1020 */  1217, 1220, 1107,  365,  284,  185,  425,  200,  363,  201,
 /*  1030 */   192,  193, 1186,  825, 1163, 1162,   94, 1161, 1160,   40,
 /*  1040 */  1159, 1158,   39, 1157, 1156,  827, 1155, 1154, 1153, 1152,
 /*  1050 */  1047, 1185, 1176,  126, 1085,  711,  862,  853, 1046, 1044,
 /*  1060 */   272,  273,  274, 1033, 1032, 1029, 1087,   67,  133,  808,
 /*  1070 */  1086,  807, 1042, 1037,  740,  806, 1035,  739, 1028,  220,
 /*  1080 */   738, 1027,  221,  737,  222, 1184, 1183,   36, 1175,  150,
 /*  1090 */   300,  302,    3,  736,  735,   65,   45,   32,   14,  153,
 /*  1100 */   295,   37,   15,  158,   19,  298, 1208,   34,   11,  164,
 /*  1110 */    48,    8,   35,   16,  148,  897,  353, 1174,  180, 1001,
 /*  1120 */  1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001,
 /*  1130 */   983,  982,  229,  987,  986,  230,  863, 1001, 1001, 1001,
 /*  1140 */  1001, 1001, 1001,  178, 1001,  961, 1001,  108, 1001,  157,
 /*  1150 */  1001,  955,   46, 1001,  954,  933, 1001,   47, 1001, 1001,
 /*  1160 */   932, 1001,  988, 1001, 1001, 1001, 1001, 1001, 1001,  366,
 /*  1170 */   879,   13,  116,   18,  243,  172,  959,  174,  176, 1001,
 /*  1180 */   171,   49,   50, 1001, 1207,   38,  370, 1001,  373,  794,
 /*  1190 */    54,  376,  771, 1001,  379,  183, 1001,  364,  799, 1001,
 /*  1200 */  1001, 1001,  368,  731,  791,  371, 1043, 1001,  788,  723,
 /*  1210 */  1001,  428,  423,  801,  374,  786,  800,  782, 1001, 1001,
 /*  1220 */  1001,  730,  377,  729,  728,  709,  780,  727,  380,  394,
 /*  1230 */   785,  726, 1031,  725,  724,  417,  722,  721, 1030, 1026,
 /*  1240 */   416,  720,   55,   56,   57,  415,  420,  732,  719,  424,
 /*  1250 */  1001,  851,  718,  717,  716,  386,  715,  784,  191,  783,
 /*  1260 */   714,  419,  427,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     0,  207,  190,  174,  221,  222,  172,  213,  214,  187,
 /*    10 */   172,  177,  183,   12,   13,   14,   15,   16,    2,  207,
 /*    20 */   191,   14,   15,   16,    0,  213,  214,  193,   12,   13,
 /*    30 */    14,   15,   16,   20,  163,   21,  198,   20,   24,   25,
 /*    40 */    26,   27,   28,   29,   30,   31,   32,  187,   47,   49,
 /*    50 */    50,   51,   52,   53,   54,   55,   56,   57,   58,   59,
 /*    60 */    60,   61,   62,   63,   64,   65,   66,   67,    0,  165,
 /*    70 */    46,  167,   71,   12,   13,   14,   15,   16,  186,   33,
 /*    80 */    79,  203,   36,  212,  206,  193,  166,  209,   42,   21,
 /*    90 */    44,    2,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   100 */    32,   12,   13,   14,   15,   16,  186,  236,   47,   49,
 /*   110 */   218,   51,   46,  193,   54,   69,  115,   57,   72,   59,
 /*   120 */   249,   47,   62,  203,  253,  124,  125,  207,  127,  128,
 /*   130 */   129,  130,  131,  132,  133,  134,    0,  217,  218,  219,
 /*   140 */    79,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   150 */    94,   95,  185,   97,   98,   99,  100,  101,  102,  186,
 /*   160 */   166,   22,  116,  196,  172,  192,  120,  174,  248,  179,
 /*   170 */   197,   20,  182,   12,   13,   14,  115,   38,   63,  190,
 /*   180 */   186,   20,   46,   22,  191,  124,  125,  193,  127,  128,
 /*   190 */   129,  130,  131,  132,  133,  134,  207,  203,   20,   38,
 /*   200 */   126,  207,  213,  214,  212,  172,  212,   68,   47,  137,
 /*   210 */   177,  217,  218,  219,  220,  166,  126,  184,  224,  225,
 /*   220 */   193,   70,  107,  108,   12,   13,  193,  200,  236,   68,
 /*   230 */   236,   70,   20,   94,   22,  186,  146,  147,  148,  149,
 /*   240 */   150,  249,  193,  249,  166,  253,  195,  253,   70,   20,
 /*   250 */    38,    3,  203,  202,  203,   94,  207,  203,   20,   47,
 /*   260 */    22,  122,  123,  209,  186,  172,  217,  218,  219,  220,
 /*   270 */   177,  193,   57,  224,  225,  226,   61,  184,   40,  172,
 /*   280 */    68,  203,   70,  122,  123,  207,  193,  238,  137,    1,
 /*   290 */     2,  171,  166,  244,  245,  217,  218,  219,  220,   84,
 /*   300 */   193,  181,  224,  225,  226,  236,   94,  172,  188,  175,
 /*   310 */   176,  115,  186,   12,   13,   14,   15,   16,  249,  193,
 /*   320 */   124,  166,  253,  245,   46,  215,  219,   20,  193,  203,
 /*   330 */   134,  169,  170,  207,  122,  123,  229,  230,  231,   20,
 /*   340 */   233,  186,  232,  217,  218,  219,  220,  212,  193,  137,
 /*   350 */   224,  225,  226,   22,  219,  166,  166,   20,  203,   71,
 /*   360 */   186,  235,  207,   20,  229,  230,  231,  193,  233,   38,
 /*   370 */   178,  236,  217,  218,  219,  220,  186,  172,  186,  224,
 /*   380 */   225,  226,  177,  193,  249,  166,  194,   81,  253,  166,
 /*   390 */   235,  187,  218,  203,   12,   13,  207,  207,  193,  166,
 /*   400 */   215,  153,   20,  186,   22,  186,    0,  217,  218,  219,
 /*   410 */   220,  194,  193,  186,  224,  225,  226,  232,  172,  192,
 /*   420 */    38,  186,  203,  177,  197,  235,  207,  192,  121,   47,
 /*   430 */   207,  212,  197,   12,   13,  167,  217,  218,  219,  193,
 /*   440 */   207,   20,  166,   22,   18,  166,  166,  166,   74,   23,
 /*   450 */    68,   77,   70,    0,  119,  236,   12,   13,   14,   38,
 /*   460 */    43,   35,  186,   57,   20,  166,   22,   61,  249,  193,
 /*   470 */   166,   45,  253,  186,  137,   22,   94,  142,  143,  203,
 /*   480 */   166,  166,   38,  207,  197,  186,  207,  207,  207,   68,
 /*   490 */    84,   70,  193,  217,  218,  219,  220,  186,   20,  187,
 /*   500 */   224,  225,  203,    0,  122,  123,  207,   14,  197,  103,
 /*   510 */   104,  207,   68,   20,   70,   94,  217,  218,  219,  220,
 /*   520 */   178,  207,  207,  224,  225,   12,   13,   21,  186,   12,
 /*   530 */    13,  105,  187,   20,   83,   22,  194,   20,   94,   22,
 /*   540 */    34,  166,  215,  122,  123,    0,   12,   13,   14,   15,
 /*   550 */    16,   38,   49,  136,   51,   38,  166,   54,  137,  232,
 /*   560 */    57,  186,   59,  137,  166,   62,  122,  123,  193,   24,
 /*   570 */    25,   26,   27,   28,   29,   30,   31,   32,  203,   20,
 /*   580 */     0,   68,  207,   70,  186,   68,   27,   70,  176,   30,
 /*   590 */   166,  193,  217,  218,  219,    4,   19,  207,   39,  121,
 /*   600 */   166,  203,   22,  256,  172,  207,  178,   94,  157,  177,
 /*   610 */    33,   94,   71,   36,  186,  217,  218,  219,  220,   42,
 /*   620 */   186,   44,  194,  225,   83,  193,  166,  193,  247,  254,
 /*   630 */   255,  207,    0,  166,  166,  122,  123,  203,  172,  122,
 /*   640 */   123,  207,  196,  177,  210,  172,   69,  166,  166,   72,
 /*   650 */   177,  217,  218,  219,   22,  166,  241,  166,  166,  193,
 /*   660 */   135,  136,  186,  166,  169,  106,  193,  207,  109,  110,
 /*   670 */   111,  112,  113,   83,  207,  207,  166,   38,  186,   74,
 /*   680 */   103,  166,   77,  186,   74,  193,  166,   77,  207,  207,
 /*   690 */   193,   38,  158,  159,  117,  203,  207,  120,  207,  207,
 /*   700 */   203,  186,  210,  172,  207,  234,  186,   68,  193,  217,
 /*   710 */   218,  219,  166,  193,  217,  218,  219,  207,  203,    1,
 /*   720 */     2,   68,  207,  203,  193,  210,   20,  207,  166,  138,
 /*   730 */   210,  166,  217,  218,  219,  216,  166,  217,  218,  219,
 /*   740 */    12,   13,   14,   15,   16,  155,  172,  172,  186,  171,
 /*   750 */   219,  186,  255,  207,  250,  193,  186,    0,  193,  228,
 /*   760 */   229,  230,  231,  193,  233,  203,  188,  193,  203,  207,
 /*   770 */   237,  114,  207,  203,  166,   74,  115,  207,   77,  217,
 /*   780 */   218,  219,  217,  218,  219,   71,   71,  217,  218,  219,
 /*   790 */   201,  199,  199,  219,  186,  172,  166,   83,   83,   71,
 /*   800 */    71,  193,  166,  229,  230,  231,   20,  233,  161,  162,
 /*   810 */   211,  203,   83,  193,   57,  207,  186,  174,   61,   20,
 /*   820 */    71,   70,  186,  193,  174,  217,  218,  219,   70,  193,
 /*   830 */   166,   80,   83,  203,   71,  204,  166,  207,  172,  203,
 /*   840 */    82,   84,  174,  207,  168,  174,   83,  217,  218,  219,
 /*   850 */   186,   20,  172,  217,  218,  219,  186,  193,   71,  186,
 /*   860 */   103,  104,  168,  193,  166,  186,   71,  203,   71,  186,
 /*   870 */    83,  207,  186,  203,   71,  186,  186,  207,   83,  186,
 /*   880 */    83,  217,  218,  219,  186,  186,   83,  217,  218,  219,
 /*   890 */    71,  193,  166,  186,   71,   71,  186,   71,  166,   71,
 /*   900 */   204,  203,   83,  186,  171,  207,   83,   83,   71,   83,
 /*   910 */   171,   83,  186,  211,  193,  217,  218,  219,  186,  193,
 /*   920 */    83,   20,  145,  246,  216,  193,  144,  208,  123,  203,
 /*   930 */   207,  246,  166,  207,  207,  203,  152,  242,  208,  207,
 /*   940 */   166,  207,  151,  217,  218,  219,   12,   13,  243,  217,
 /*   950 */   218,  219,  186,  140,  139,  239,   22,  136,  193,  193,
 /*   960 */   186,   20,  240,  215,  114,  227,  160,  193,  166,  203,
 /*   970 */   257,  154,   38,  207,    4,   35,  156,  203,   70,  223,
 /*   980 */   208,  207,  251,  217,  218,  219,  207,  252,  186,   19,
 /*   990 */   207,  217,  218,  219,  118,  193,  208,   57,  205,  207,
 /*  1000 */   193,   61,   68,   33,  204,  203,   36,  171,   70,  207,
 /*  1010 */   171,   41,  182,   73,   44,   75,   76,  172,   78,  217,
 /*  1020 */   218,  219,  193,  189,   84,  171,  168,  180,   94,  180,
 /*  1030 */   173,  164,    0,   82,    0,    0,  114,    0,    0,   69,
 /*  1040 */     0,    0,   72,    0,    0,   22,    0,    0,    0,    0,
 /*  1050 */     0,    0,    0,   43,    0,   48,  122,  123,    0,    0,
 /*  1060 */    38,   36,   43,    0,    0,    0,    0,   79,   77,   38,
 /*  1070 */     0,   38,    0,    0,   38,   22,    0,   38,    0,   22,
 /*  1080 */    38,    0,   22,   38,   22,    0,    0,  121,    0,  116,
 /*  1090 */    22,   22,   83,   38,   38,   20,   70,   83,  141,   71,
 /*  1100 */    39,   83,  141,   83,   83,   38,   82,  135,  141,   82,
 /*  1110 */     4,    2,   83,   83,   43,  126,  119,    0,  116,  258,
 /*  1120 */   258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
 /*  1130 */    38,   38,   38,   38,   38,   38,   22,  258,  258,  258,
 /*  1140 */   258,  258,  258,   43,  258,   71,  258,   70,  258,   70,
 /*  1150 */   258,   71,   70,  258,   71,   71,  258,   70,  258,  258,
 /*  1160 */    71,  258,   71,  258,  258,  258,  258,  258,  258,   38,
 /*  1170 */    71,   70,   82,   70,   38,   71,   71,   70,   70,  258,
 /*  1180 */    82,   70,   70,  258,   82,   70,   38,  258,   38,   71,
 /*  1190 */    80,   38,   22,  258,   38,   82,  258,   81,   22,  258,
 /*  1200 */   258,  258,   70,   22,   71,   70,    0,  258,   71,   22,
 /*  1210 */   258,   20,   22,   38,   70,   96,   38,   71,  258,  258,
 /*  1220 */   258,   38,   70,   38,   38,   48,   71,   38,   70,   47,
 /*  1230 */    96,   38,    0,   38,   38,   43,   38,   38,    0,    0,
 /*  1240 */    36,   38,   70,   70,   70,   38,   37,   68,   38,   21,
 /*  1250 */   258,   22,   38,   38,   38,   84,   38,   96,   22,   96,
 /*  1260 */    38,   38,   21,  258,  258,  258,  258,  258,  258,  258,
 /*  1270 */   258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
 /*  1280 */   258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
 /*  1290 */   258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
 /*  1300 */   258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
 /*  1310 */   258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
 /*  1320 */   258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
 /*  1330 */   258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
 /*  1340 */   258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
 /*  1350 */   258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
 /*  1360 */   258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
 /*  1370 */   258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
 /*  1380 */   258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
 /*  1390 */   258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
 /*  1400 */   258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
 /*  1410 */   258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
 /*  1420 */   258,  258,  258,  258,  258,  258,
};
#define YY_SHIFT_COUNT    (429)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1241)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   426,  212,  161,  382,  382,  382,  382,  421,  382,  382,
 /*    10 */   151,  513,  517,  444,  513,  513,  513,  513,  513,  513,
 /*    20 */   513,  513,  513,  513,  513,  513,  513,  513,  513,  513,
 /*    30 */   513,  513,  513,  178,  178,  178,  337,  934,  934,   13,
 /*    40 */    13,  934,   13,   13,   66,   17,  229,  229,   72,  319,
 /*    50 */    17,   13,   13,   17,   13,   17,  319,   17,   17,   13,
 /*    60 */   278,    1,   61,   61,  559,   14,  940,  139,   60,  139,
 /*    70 */   139,  139,  139,  139,  139,  139,  139,  139,  139,  139,
 /*    80 */   139,  139,  139,  139,  139,  139,  139,  139,  238,   24,
 /*    90 */   307,  307,  307,  136,  343,  319,   17,   17,   17,  306,
 /*   100 */    56,   56,   56,   56,   56,   68,  503,  534,   90,  215,
 /*   110 */   335,  331,  478,  525,  417,  525,  493,  248,  591,  706,
 /*   120 */   657,  661,  661,  706,  786,   66,  343,  799,   66,   66,
 /*   130 */   706,   66,  831,   17,   17,   17,   17,   17,   17,   17,
 /*   140 */    17,   17,   17,   17,  706,  831,  786,  278,  343,  799,
 /*   150 */   278,  901,  777,  782,  805,  777,  782,  805,  805,  784,
 /*   160 */   791,  813,  815,  821,  343,  941,  850,  806,  820,  817,
 /*   170 */   908,   17,  782,  805,  805,  782,  805,  876,  343,  799,
 /*   180 */   278,  306,  278,  343,  938,  706,  278,  831, 1263, 1263,
 /*   190 */  1263, 1263,    0,  545,  577,   46,  970,   16,   89,  728,
 /*   200 */   406,  757,  301,  301,  301,  301,  301,  301,  301,  115,
 /*   210 */   288,  196,    7,    7,    7,    7,  374,  605,  610,  701,
 /*   220 */   453,  580,  632,  506,  541,  714,  715,  718,  647,  590,
 /*   230 */   451,  729,   74,  749,  758,  763,  787,  795,  797,  803,
 /*   240 */   639,  653,  819,  823,  824,  826,  828,  837,  751, 1032,
 /*   250 */   951, 1034, 1035,  922, 1037, 1038, 1040, 1041, 1043, 1044,
 /*   260 */  1023, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1010, 1054,
 /*   270 */  1007, 1058, 1059, 1022, 1025, 1019, 1063, 1064, 1065, 1066,
 /*   280 */   988,  991, 1031, 1033, 1053, 1070, 1036, 1039, 1042, 1045,
 /*   290 */  1055, 1056, 1072, 1057, 1073, 1060, 1061, 1076, 1062, 1067,
 /*   300 */  1078, 1068, 1081, 1069, 1075, 1085, 1086,  966, 1088, 1026,
 /*   310 */  1071,  973, 1009, 1014,  957, 1028, 1018, 1074, 1077, 1079,
 /*   320 */  1080, 1082, 1083, 1020, 1024, 1087, 1021,  961, 1084, 1089,
 /*   330 */  1027,  972, 1029, 1090, 1091, 1030,  967, 1106, 1092, 1093,
 /*   340 */  1094, 1095, 1096, 1097, 1109,  989, 1098, 1099, 1101, 1103,
 /*   350 */  1104, 1105, 1107, 1108,  997, 1111, 1117, 1100, 1002, 1112,
 /*   360 */  1110, 1102, 1113, 1114, 1115, 1116, 1118, 1131, 1136, 1132,
 /*   370 */  1133, 1148, 1135, 1137, 1150, 1144, 1146, 1153, 1152, 1155,
 /*   380 */  1156, 1158, 1119, 1134, 1161, 1163, 1170, 1171, 1172, 1173,
 /*   390 */  1174, 1175, 1178, 1176, 1177, 1182, 1179, 1181, 1183, 1185,
 /*   400 */  1186, 1189, 1193, 1195, 1196, 1187, 1198, 1199, 1203, 1210,
 /*   410 */  1214, 1215, 1216, 1218, 1222, 1206, 1207, 1204, 1192, 1232,
 /*   420 */  1223, 1209, 1238, 1239, 1190, 1228, 1229, 1236, 1241, 1191,
};
#define YY_REDUCE_COUNT (191)
#define YY_REDUCE_MIN   (-217)
#define YY_REDUCE_MAX   (867)
static const short yy_reduce_ofst[] = {
 /*     0 */  -129,   -6,   49,   78,  126,  155,  190,  219,  276,  299,
 /*    10 */   135,  375,  398,  434,  492,  -80,  497,  515,  520,  562,
 /*    20 */   565,  570,  608,  630,  636,  664,  670,  698,  726,  732,
 /*    30 */   766,  774,  802,  531,  107,  574,   -8, -188,  -11,   33,
 /*    40 */    93, -206, -166,  205, -171,  -27, -108,  174,   69, -122,
 /*    50 */   192,  246,  432,  227,  466,  342,   51,  235,  428,  473,
 /*    60 */   120, -217, -217, -217, -162,  -96,  -33,  189,  134,  223,
 /*    70 */   233,  279,  280,  281,  304,  314,  315,  390,  424,  460,
 /*    80 */   467,  468,  481,  482,  489,  491,  510,  546,  162,   -7,
 /*    90 */   110,  185,  327,  578,   27,   54,  217,  287,  311,  -10,
 /*   100 */  -178, -140,  204,  312,  345,  268,  412,  347,  381,  446,
 /*   110 */   415,  495,  519,  471,  471,  471,  476,  504,  533,  575,
 /*   120 */   589,  592,  593,  623,  599,  643,  620,  631,  650,  668,
 /*   130 */   666,  671,  676,  673,  679,  683,  686,  689,  690,  693,
 /*   140 */   699,  707,  710,  717,  680,  694,  702,  733,  721,  696,
 /*   150 */   739,  708,  677,  719,  723,  685,  730,  727,  734,  705,
 /*   160 */   695,  722,  716,  471,  765,  748,  738,  713,  735,  731,
 /*   170 */   756,  476,  772,  779,  783,  788,  792,  793,  807,  800,
 /*   180 */   836,  830,  839,  829,  834,  845,  854,  858,  847,  849,
 /*   190 */   857,  867,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   999,  999,  999,  999,  999,  999,  999,  999,  999,  999,
 /*    10 */   999,  999,  999,  999,  999,  999,  999,  999,  999,  999,
 /*    20 */   999,  999,  999,  999,  999,  999,  999,  999,  999,  999,
 /*    30 */   999,  999,  999,  999,  999,  999,  999,  999,  999,  999,
 /*    40 */   999,  999,  999,  999, 1052,  999,  999,  999,  999,  999,
 /*    50 */   999,  999,  999,  999,  999,  999,  999,  999,  999,  999,
 /*    60 */  1050,  999, 1258,  999, 1164,  999,  999,  999,  999,  999,
 /*    70 */   999,  999,  999,  999,  999,  999,  999,  999,  999,  999,
 /*    80 */   999,  999,  999,  999,  999,  999,  999,  999,  999, 1052,
 /*    90 */  1269, 1269, 1269, 1050,  999,  999,  999,  999,  999, 1135,
 /*   100 */   999,  999,  999,  999,  999,  999,  999, 1333,  999, 1088,
 /*   110 */  1293,  999, 1285, 1261, 1275, 1262,  999, 1318, 1278,  999,
 /*   120 */  1169, 1166, 1166,  999,  999, 1052,  999,  999, 1052, 1052,
 /*   130 */   999, 1052,  999,  999,  999,  999,  999,  999,  999,  999,
 /*   140 */   999,  999,  999,  999,  999,  999,  999, 1050,  999,  999,
 /*   150 */  1050,  999, 1300, 1298,  999, 1300, 1298,  999,  999, 1312,
 /*   160 */  1308, 1291, 1289, 1275,  999,  999,  999, 1336, 1324, 1320,
 /*   170 */   999,  999, 1298,  999,  999, 1298,  999, 1177,  999,  999,
 /*   180 */  1050,  999, 1050,  999, 1104,  999, 1050,  999, 1138, 1138,
 /*   190 */  1053, 1004,  999,  999,  999,  999,  999,  999,  999,  999,
 /*   200 */   999,  999, 1230, 1311, 1310, 1229, 1235, 1234, 1233,  999,
 /*   210 */   999,  999, 1224, 1225, 1223, 1222,  999,  999,  999,  999,
 /*   220 */   999,  999,  999,  999,  999,  999,  999, 1259,  999, 1321,
 /*   230 */  1325,  999,  999,  999, 1209,  999,  999,  999,  999,  999,
 /*   240 */   999,  999,  999,  999,  999,  999,  999,  999,  999,  999,
 /*   250 */   999,  999,  999,  999,  999,  999,  999,  999,  999,  999,
 /*   260 */   999,  999,  999,  999,  999,  999,  999,  999,  999,  999,
 /*   270 */   999,  999,  999,  999,  999,  999,  999,  999,  999,  999,
 /*   280 */   999,  999,  999,  999,  999,  999,  999,  999,  999,  999,
 /*   290 */   999,  999,  999,  999,  999,  999,  999,  999,  999,  999,
 /*   300 */   999,  999,  999,  999,  999,  999,  999,  999,  999,  999,
 /*   310 */   999,  999, 1282, 1292,  999,  999,  999,  999,  999,  999,
 /*   320 */   999,  999,  999,  999, 1209,  999, 1309,  999, 1268, 1264,
 /*   330 */   999,  999, 1260,  999,  999, 1319,  999,  999,  999,  999,
 /*   340 */   999,  999,  999,  999, 1254,  999,  999,  999,  999,  999,
 /*   350 */   999,  999,  999,  999,  999,  999,  999,  999,  999,  999,
 /*   360 */   999, 1208,  999,  999,  999,  999,  999,  999,  999, 1132,
 /*   370 */   999,  999,  999,  999,  999,  999,  999,  999,  999,  999,
 /*   380 */   999,  999, 1117, 1115, 1114, 1113,  999, 1110,  999,  999,
 /*   390 */   999,  999,  999,  999,  999,  999,  999,  999,  999,  999,
 /*   400 */   999,  999,  999,  999,  999,  999,  999,  999,  999,  999,
 /*   410 */   999,  999,  999,  999,  999,  999,  999,  999,  999,  999,
 /*   420 */   999,  999,  999,  999,  999,  999,  999,  999,  999,  999,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "DATABASE",
  /*   45 */ "USE",
  /*   46 */ "IF",
  /*   47 */ "NOT",
  /*   48 */ "EXISTS",
  /*   49 */ "BLOCKS",
  /*   50 */ "CACHE",
  /*   51 */ "CACHELAST",
  /*   52 */ "COMP",
  /*   53 */ "DAYS",
  /*   54 */ "FSYNC",
  /*   55 */ "MAXROWS",
  /*   56 */ "MINROWS",
  /*   57 */ "KEEP",
  /*   58 */ "PRECISION",
  /*   59 */ "QUORUM",
  /*   60 */ "REPLICA",
  /*   61 */ "TTL",
  /*   62 */ "WAL",
  /*   63 */ "VGROUPS",
  /*   64 */ "SINGLE_STABLE",
  /*   65 */ "STREAM_MODE",
  /*   66 */ "RETENTIONS",
  /*   67 */ "FILE_FACTOR",
  /*   68 */ "NK_FLOAT",
  /*   69 */ "TABLE",
  /*   70 */ "NK_LP",
  /*   71 */ "NK_RP",
  /*   72 */ "STABLE",
  /*   73 */ "ADD",
  /*   74 */ "COLUMN",
  /*   75 */ "MODIFY",
  /*   76 */ "RENAME",
  /*   77 */ "TAG",
  /*   78 */ "SET",
  /*   79 */ "NK_EQ",
  /*   80 */ "USING",
  /*   81 */ "TAGS",
  /*   82 */ "NK_DOT",
  /*   83 */ "NK_COMMA",
  /*   84 */ "COMMENT",
  /*   85 */ "BOOL",
  /*   86 */ "TINYINT",
  /*   87 */ "SMALLINT",
  /*   88 */ "INT",
  /*   89 */ "INTEGER",
  /*   90 */ "BIGINT",
  /*   91 */ "FLOAT",
  /*   92 */ "DOUBLE",
  /*   93 */ "BINARY",
  /*   94 */ "TIMESTAMP",
  /*   95 */ "NCHAR",
  /*   96 */ "UNSIGNED",
  /*   97 */ "JSON",
  /*   98 */ "VARCHAR",
  /*   99 */ "MEDIUMBLOB",
  /*  100 */ "BLOB",
  /*  101 */ "VARBINARY",
  /*  102 */ "DECIMAL",
  /*  103 */ "SMA",
  /*  104 */ "ROLLUP",
  /*  105 */ "SHOW",
  /*  106 */ "DATABASES",
  /*  107 */ "TABLES",
  /*  108 */ "STABLES",
  /*  109 */ "MNODES",
  /*  110 */ "MODULES",
  /*  111 */ "QNODES",
  /*  112 */ "FUNCTIONS",
  /*  113 */ "INDEXES",
  /*  114 */ "FROM",
  /*  115 */ "LIKE",
  /*  116 */ "INDEX",
  /*  117 */ "FULLTEXT",
  /*  118 */ "FUNCTION",
  /*  119 */ "INTERVAL",
  /*  120 */ "TOPIC",
  /*  121 */ "AS",
  /*  122 */ "NK_BOOL",
  /*  123 */ "NK_VARIABLE",
  /*  124 */ "BETWEEN",
  /*  125 */ "IS",
  /*  126 */ "NULL",
  /*  127 */ "NK_LT",
  /*  128 */ "NK_GT",
  /*  129 */ "NK_LE",
  /*  130 */ "NK_GE",
  /*  131 */ "NK_NE",
  /*  132 */ "MATCH",
  /*  133 */ "NMATCH",
  /*  134 */ "IN",
  /*  135 */ "JOIN",
  /*  136 */ "INNER",
  /*  137 */ "SELECT",
  /*  138 */ "DISTINCT",
  /*  139 */ "WHERE",
  /*  140 */ "PARTITION",
  /*  141 */ "BY",
  /*  142 */ "SESSION",
  /*  143 */ "STATE_WINDOW",
  /*  144 */ "SLIDING",
  /*  145 */ "FILL",
  /*  146 */ "VALUE",
  /*  147 */ "NONE",
  /*  148 */ "PREV",
  /*  149 */ "LINEAR",
  /*  150 */ "NEXT",
  /*  151 */ "GROUP",
  /*  152 */ "HAVING",
  /*  153 */ "ORDER",
  /*  154 */ "SLIMIT",
  /*  155 */ "SOFFSET",
  /*  156 */ "LIMIT",
  /*  157 */ "OFFSET",
  /*  158 */ "ASC",
  /*  159 */ "DESC",
  /*  160 */ "NULLS",
  /*  161 */ "FIRST",
  /*  162 */ "LAST",
  /*  163 */ "cmd",
  /*  164 */ "account_options",
  /*  165 */ "alter_account_options",
  /*  166 */ "literal",
  /*  167 */ "alter_account_option",
  /*  168 */ "user_name",
  /*  169 */ "dnode_endpoint",
  /*  170 */ "dnode_host_name",
  /*  171 */ "not_exists_opt",
  /*  172 */ "db_name",
  /*  173 */ "db_options",
  /*  174 */ "exists_opt",
  /*  175 */ "alter_db_options",
  /*  176 */ "alter_db_option",
  /*  177 */ "full_table_name",
  /*  178 */ "column_def_list",
  /*  179 */ "tags_def_opt",
  /*  180 */ "table_options",
  /*  181 */ "multi_create_clause",
  /*  182 */ "tags_def",
  /*  183 */ "multi_drop_clause",
  /*  184 */ "alter_table_clause",
  /*  185 */ "alter_table_options",
  /*  186 */ "column_name",
  /*  187 */ "type_name",
  /*  188 */ "create_subtable_clause",
  /*  189 */ "specific_tags_opt",
  /*  190 */ "literal_list",
  /*  191 */ "drop_table_clause",
  /*  192 */ "col_name_list",
  /*  193 */ "table_name",
  /*  194 */ "column_def",
  /*  195 */ "func_name_list",
  /*  196 */ "alter_table_option",
  /*  197 */ "col_name",
  /*  198 */ "db_name_cond_opt",
  /*  199 */ "like_pattern_opt",
  /*  200 */ "table_name_cond",
  /*  201 */ "from_db_opt",
  /*  202 */ "func_name",
  /*  203 */ "function_name",
  /*  204 */ "index_name",
  /*  205 */ "index_options",
  /*  206 */ "func_list",
  /*  207 */ "duration_literal",
  /*  208 */ "sliding_opt",
  /*  209 */ "func",
  /*  210 */ "expression_list",
  /*  211 */ "topic_name",
  /*  212 */ "query_expression",
  /*  213 */ "signed",
  /*  214 */ "signed_literal",
  /*  215 */ "table_alias",
  /*  216 */ "column_alias",
  /*  217 */ "expression",
  /*  218 */ "column_reference",
  /*  219 */ "subquery",
  /*  220 */ "predicate",
  /*  221 */ "compare_op",
  /*  222 */ "in_op",
  /*  223 */ "in_predicate_value",
  /*  224 */ "boolean_value_expression",
  /*  225 */ "boolean_primary",
  /*  226 */ "common_expression",
  /*  227 */ "from_clause",
  /*  228 */ "table_reference_list",
  /*  229 */ "table_reference",
  /*  230 */ "table_primary",
  /*  231 */ "joined_table",
  /*  232 */ "alias_opt",
  /*  233 */ "parenthesized_joined_table",
  /*  234 */ "join_type",
  /*  235 */ "search_condition",
  /*  236 */ "query_specification",
  /*  237 */ "set_quantifier_opt",
  /*  238 */ "select_list",
  /*  239 */ "where_clause_opt",
  /*  240 */ "partition_by_clause_opt",
  /*  241 */ "twindow_clause_opt",
  /*  242 */ "group_by_clause_opt",
  /*  243 */ "having_clause_opt",
  /*  244 */ "select_sublist",
  /*  245 */ "select_item",
  /*  246 */ "fill_opt",
  /*  247 */ "fill_mode",
  /*  248 */ "group_by_list",
  /*  249 */ "query_expression_body",
  /*  250 */ "order_by_clause_opt",
  /*  251 */ "slimit_clause_opt",
  /*  252 */ "limit_clause_opt",
  /*  253 */ "query_primary",
  /*  254 */ "sort_specification_list",
  /*  255 */ "sort_specification",
  /*  256 */ "ordering_specification_opt",
  /*  257 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  44 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  45 */ "cmd ::= USE db_name",
 /*  46 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  47 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  48 */ "not_exists_opt ::=",
 /*  49 */ "exists_opt ::= IF EXISTS",
 /*  50 */ "exists_opt ::=",
 /*  51 */ "db_options ::=",
 /*  52 */ "db_options ::= db_options BLOCKS NK_INTEGER",
 /*  53 */ "db_options ::= db_options CACHE NK_INTEGER",
 /*  54 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  55 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  56 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  57 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  58 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  59 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  60 */ "db_options ::= db_options KEEP NK_INTEGER",
 /*  61 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  62 */ "db_options ::= db_options QUORUM NK_INTEGER",
 /*  63 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  64 */ "db_options ::= db_options TTL NK_INTEGER",
 /*  65 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  66 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  67 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  68 */ "db_options ::= db_options STREAM_MODE NK_INTEGER",
 /*  69 */ "db_options ::= db_options RETENTIONS NK_STRING",
 /*  70 */ "db_options ::= db_options FILE_FACTOR NK_FLOAT",
 /*  71 */ "alter_db_options ::= alter_db_option",
 /*  72 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  73 */ "alter_db_option ::= BLOCKS NK_INTEGER",
 /*  74 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  75 */ "alter_db_option ::= KEEP NK_INTEGER",
 /*  76 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  77 */ "alter_db_option ::= QUORUM NK_INTEGER",
 /*  78 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  79 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  80 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  81 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /*  82 */ "cmd ::= DROP TABLE multi_drop_clause",
 /*  83 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /*  84 */ "cmd ::= ALTER TABLE alter_table_clause",
 /*  85 */ "cmd ::= ALTER STABLE alter_table_clause",
 /*  86 */ "alter_table_clause ::= full_table_name alter_table_options",
 /*  87 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /*  88 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /*  89 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /*  90 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /*  91 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /*  92 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /*  93 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /*  94 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /*  95 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /*  96 */ "multi_create_clause ::= create_subtable_clause",
 /*  97 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /*  98 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP",
 /*  99 */ "multi_drop_clause ::= drop_table_clause",
 /* 100 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 101 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 102 */ "specific_tags_opt ::=",
 /* 103 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 104 */ "full_table_name ::= table_name",
 /* 105 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 106 */ "column_def_list ::= column_def",
 /* 107 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 108 */ "column_def ::= column_name type_name",
 /* 109 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 110 */ "type_name ::= BOOL",
 /* 111 */ "type_name ::= TINYINT",
 /* 112 */ "type_name ::= SMALLINT",
 /* 113 */ "type_name ::= INT",
 /* 114 */ "type_name ::= INTEGER",
 /* 115 */ "type_name ::= BIGINT",
 /* 116 */ "type_name ::= FLOAT",
 /* 117 */ "type_name ::= DOUBLE",
 /* 118 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 119 */ "type_name ::= TIMESTAMP",
 /* 120 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 121 */ "type_name ::= TINYINT UNSIGNED",
 /* 122 */ "type_name ::= SMALLINT UNSIGNED",
 /* 123 */ "type_name ::= INT UNSIGNED",
 /* 124 */ "type_name ::= BIGINT UNSIGNED",
 /* 125 */ "type_name ::= JSON",
 /* 126 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 127 */ "type_name ::= MEDIUMBLOB",
 /* 128 */ "type_name ::= BLOB",
 /* 129 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 130 */ "type_name ::= DECIMAL",
 /* 131 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 132 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 133 */ "tags_def_opt ::=",
 /* 134 */ "tags_def_opt ::= tags_def",
 /* 135 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 136 */ "table_options ::=",
 /* 137 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 138 */ "table_options ::= table_options KEEP NK_INTEGER",
 /* 139 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 140 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 141 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 142 */ "alter_table_options ::= alter_table_option",
 /* 143 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 144 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 145 */ "alter_table_option ::= KEEP NK_INTEGER",
 /* 146 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 147 */ "col_name_list ::= col_name",
 /* 148 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 149 */ "col_name ::= column_name",
 /* 150 */ "cmd ::= SHOW DNODES",
 /* 151 */ "cmd ::= SHOW USERS",
 /* 152 */ "cmd ::= SHOW DATABASES",
 /* 153 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 154 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 155 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 156 */ "cmd ::= SHOW MNODES",
 /* 157 */ "cmd ::= SHOW MODULES",
 /* 158 */ "cmd ::= SHOW QNODES",
 /* 159 */ "cmd ::= SHOW FUNCTIONS",
 /* 160 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 161 */ "cmd ::= SHOW STREAMS",
 /* 162 */ "db_name_cond_opt ::=",
 /* 163 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 164 */ "like_pattern_opt ::=",
 /* 165 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 166 */ "table_name_cond ::= table_name",
 /* 167 */ "from_db_opt ::=",
 /* 168 */ "from_db_opt ::= FROM db_name",
 /* 169 */ "func_name_list ::= func_name",
 /* 170 */ "func_name_list ::= func_name_list NK_COMMA col_name",
 /* 171 */ "func_name ::= function_name",
 /* 172 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 173 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 174 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 175 */ "index_options ::=",
 /* 176 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 177 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 178 */ "func_list ::= func",
 /* 179 */ "func_list ::= func_list NK_COMMA func",
 /* 180 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 181 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 182 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name",
 /* 183 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 184 */ "cmd ::= query_expression",
 /* 185 */ "literal ::= NK_INTEGER",
 /* 186 */ "literal ::= NK_FLOAT",
 /* 187 */ "literal ::= NK_STRING",
 /* 188 */ "literal ::= NK_BOOL",
 /* 189 */ "literal ::= TIMESTAMP NK_STRING",
 /* 190 */ "literal ::= duration_literal",
 /* 191 */ "duration_literal ::= NK_VARIABLE",
 /* 192 */ "signed ::= NK_INTEGER",
 /* 193 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 194 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 195 */ "signed ::= NK_FLOAT",
 /* 196 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 197 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 198 */ "signed_literal ::= signed",
 /* 199 */ "signed_literal ::= NK_STRING",
 /* 200 */ "signed_literal ::= NK_BOOL",
 /* 201 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 202 */ "signed_literal ::= duration_literal",
 /* 203 */ "literal_list ::= signed_literal",
 /* 204 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 205 */ "db_name ::= NK_ID",
 /* 206 */ "table_name ::= NK_ID",
 /* 207 */ "column_name ::= NK_ID",
 /* 208 */ "function_name ::= NK_ID",
 /* 209 */ "table_alias ::= NK_ID",
 /* 210 */ "column_alias ::= NK_ID",
 /* 211 */ "user_name ::= NK_ID",
 /* 212 */ "index_name ::= NK_ID",
 /* 213 */ "topic_name ::= NK_ID",
 /* 214 */ "expression ::= literal",
 /* 215 */ "expression ::= column_reference",
 /* 216 */ "expression ::= function_name NK_LP expression_list NK_RP",
 /* 217 */ "expression ::= function_name NK_LP NK_STAR NK_RP",
 /* 218 */ "expression ::= subquery",
 /* 219 */ "expression ::= NK_LP expression NK_RP",
 /* 220 */ "expression ::= NK_PLUS expression",
 /* 221 */ "expression ::= NK_MINUS expression",
 /* 222 */ "expression ::= expression NK_PLUS expression",
 /* 223 */ "expression ::= expression NK_MINUS expression",
 /* 224 */ "expression ::= expression NK_STAR expression",
 /* 225 */ "expression ::= expression NK_SLASH expression",
 /* 226 */ "expression ::= expression NK_REM expression",
 /* 227 */ "expression_list ::= expression",
 /* 228 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 229 */ "column_reference ::= column_name",
 /* 230 */ "column_reference ::= table_name NK_DOT column_name",
 /* 231 */ "predicate ::= expression compare_op expression",
 /* 232 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 233 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 234 */ "predicate ::= expression IS NULL",
 /* 235 */ "predicate ::= expression IS NOT NULL",
 /* 236 */ "predicate ::= expression in_op in_predicate_value",
 /* 237 */ "compare_op ::= NK_LT",
 /* 238 */ "compare_op ::= NK_GT",
 /* 239 */ "compare_op ::= NK_LE",
 /* 240 */ "compare_op ::= NK_GE",
 /* 241 */ "compare_op ::= NK_NE",
 /* 242 */ "compare_op ::= NK_EQ",
 /* 243 */ "compare_op ::= LIKE",
 /* 244 */ "compare_op ::= NOT LIKE",
 /* 245 */ "compare_op ::= MATCH",
 /* 246 */ "compare_op ::= NMATCH",
 /* 247 */ "in_op ::= IN",
 /* 248 */ "in_op ::= NOT IN",
 /* 249 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 250 */ "boolean_value_expression ::= boolean_primary",
 /* 251 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 252 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 253 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 254 */ "boolean_primary ::= predicate",
 /* 255 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 256 */ "common_expression ::= expression",
 /* 257 */ "common_expression ::= boolean_value_expression",
 /* 258 */ "from_clause ::= FROM table_reference_list",
 /* 259 */ "table_reference_list ::= table_reference",
 /* 260 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 261 */ "table_reference ::= table_primary",
 /* 262 */ "table_reference ::= joined_table",
 /* 263 */ "table_primary ::= table_name alias_opt",
 /* 264 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 265 */ "table_primary ::= subquery alias_opt",
 /* 266 */ "table_primary ::= parenthesized_joined_table",
 /* 267 */ "alias_opt ::=",
 /* 268 */ "alias_opt ::= table_alias",
 /* 269 */ "alias_opt ::= AS table_alias",
 /* 270 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 271 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 272 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 273 */ "join_type ::=",
 /* 274 */ "join_type ::= INNER",
 /* 275 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 276 */ "set_quantifier_opt ::=",
 /* 277 */ "set_quantifier_opt ::= DISTINCT",
 /* 278 */ "set_quantifier_opt ::= ALL",
 /* 279 */ "select_list ::= NK_STAR",
 /* 280 */ "select_list ::= select_sublist",
 /* 281 */ "select_sublist ::= select_item",
 /* 282 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 283 */ "select_item ::= common_expression",
 /* 284 */ "select_item ::= common_expression column_alias",
 /* 285 */ "select_item ::= common_expression AS column_alias",
 /* 286 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 287 */ "where_clause_opt ::=",
 /* 288 */ "where_clause_opt ::= WHERE search_condition",
 /* 289 */ "partition_by_clause_opt ::=",
 /* 290 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 291 */ "twindow_clause_opt ::=",
 /* 292 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 293 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP",
 /* 294 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 295 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 296 */ "sliding_opt ::=",
 /* 297 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 298 */ "fill_opt ::=",
 /* 299 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 300 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 301 */ "fill_mode ::= NONE",
 /* 302 */ "fill_mode ::= PREV",
 /* 303 */ "fill_mode ::= NULL",
 /* 304 */ "fill_mode ::= LINEAR",
 /* 305 */ "fill_mode ::= NEXT",
 /* 306 */ "group_by_clause_opt ::=",
 /* 307 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 308 */ "group_by_list ::= expression",
 /* 309 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 310 */ "having_clause_opt ::=",
 /* 311 */ "having_clause_opt ::= HAVING search_condition",
 /* 312 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 313 */ "query_expression_body ::= query_primary",
 /* 314 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 315 */ "query_primary ::= query_specification",
 /* 316 */ "order_by_clause_opt ::=",
 /* 317 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 318 */ "slimit_clause_opt ::=",
 /* 319 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 320 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 321 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 322 */ "limit_clause_opt ::=",
 /* 323 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 324 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 325 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 326 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 327 */ "search_condition ::= common_expression",
 /* 328 */ "sort_specification_list ::= sort_specification",
 /* 329 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 330 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 331 */ "ordering_specification_opt ::=",
 /* 332 */ "ordering_specification_opt ::= ASC",
 /* 333 */ "ordering_specification_opt ::= DESC",
 /* 334 */ "null_ordering_opt ::=",
 /* 335 */ "null_ordering_opt ::= NULLS FIRST",
 /* 336 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 163: /* cmd */
    case 166: /* literal */
    case 173: /* db_options */
    case 175: /* alter_db_options */
    case 177: /* full_table_name */
    case 180: /* table_options */
    case 184: /* alter_table_clause */
    case 185: /* alter_table_options */
    case 188: /* create_subtable_clause */
    case 191: /* drop_table_clause */
    case 194: /* column_def */
    case 197: /* col_name */
    case 198: /* db_name_cond_opt */
    case 199: /* like_pattern_opt */
    case 200: /* table_name_cond */
    case 201: /* from_db_opt */
    case 202: /* func_name */
    case 205: /* index_options */
    case 207: /* duration_literal */
    case 208: /* sliding_opt */
    case 209: /* func */
    case 212: /* query_expression */
    case 213: /* signed */
    case 214: /* signed_literal */
    case 217: /* expression */
    case 218: /* column_reference */
    case 219: /* subquery */
    case 220: /* predicate */
    case 223: /* in_predicate_value */
    case 224: /* boolean_value_expression */
    case 225: /* boolean_primary */
    case 226: /* common_expression */
    case 227: /* from_clause */
    case 228: /* table_reference_list */
    case 229: /* table_reference */
    case 230: /* table_primary */
    case 231: /* joined_table */
    case 233: /* parenthesized_joined_table */
    case 235: /* search_condition */
    case 236: /* query_specification */
    case 239: /* where_clause_opt */
    case 241: /* twindow_clause_opt */
    case 243: /* having_clause_opt */
    case 245: /* select_item */
    case 246: /* fill_opt */
    case 249: /* query_expression_body */
    case 251: /* slimit_clause_opt */
    case 252: /* limit_clause_opt */
    case 253: /* query_primary */
    case 255: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy140)); 
}
      break;
    case 164: /* account_options */
    case 165: /* alter_account_options */
    case 167: /* alter_account_option */
{
 
}
      break;
    case 168: /* user_name */
    case 169: /* dnode_endpoint */
    case 170: /* dnode_host_name */
    case 172: /* db_name */
    case 186: /* column_name */
    case 193: /* table_name */
    case 203: /* function_name */
    case 204: /* index_name */
    case 211: /* topic_name */
    case 215: /* table_alias */
    case 216: /* column_alias */
    case 232: /* alias_opt */
{
 
}
      break;
    case 171: /* not_exists_opt */
    case 174: /* exists_opt */
    case 237: /* set_quantifier_opt */
{
 
}
      break;
    case 176: /* alter_db_option */
    case 196: /* alter_table_option */
{
 
}
      break;
    case 178: /* column_def_list */
    case 179: /* tags_def_opt */
    case 181: /* multi_create_clause */
    case 182: /* tags_def */
    case 183: /* multi_drop_clause */
    case 189: /* specific_tags_opt */
    case 190: /* literal_list */
    case 192: /* col_name_list */
    case 195: /* func_name_list */
    case 206: /* func_list */
    case 210: /* expression_list */
    case 238: /* select_list */
    case 240: /* partition_by_clause_opt */
    case 242: /* group_by_clause_opt */
    case 244: /* select_sublist */
    case 248: /* group_by_list */
    case 250: /* order_by_clause_opt */
    case 254: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy136)); 
}
      break;
    case 187: /* type_name */
{
 
}
      break;
    case 221: /* compare_op */
    case 222: /* in_op */
{
 
}
      break;
    case 234: /* join_type */
{
 
}
      break;
    case 247: /* fill_mode */
{
 
}
      break;
    case 256: /* ordering_specification_opt */
{
 
}
      break;
    case 257: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  163,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  163,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  164,    0 }, /* (2) account_options ::= */
  {  164,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  164,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  164,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  164,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  164,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  164,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  164,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  164,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  164,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  165,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  165,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  167,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  167,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  167,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  167,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  167,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  167,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  167,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  167,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  167,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  167,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  163,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  163,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  163,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  163,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  163,   -3 }, /* (28) cmd ::= CREATE DNODE dnode_endpoint */
  {  163,   -5 }, /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  163,   -3 }, /* (30) cmd ::= DROP DNODE NK_INTEGER */
  {  163,   -3 }, /* (31) cmd ::= DROP DNODE dnode_endpoint */
  {  163,   -4 }, /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  163,   -5 }, /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  163,   -4 }, /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
  {  163,   -5 }, /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  169,   -1 }, /* (36) dnode_endpoint ::= NK_STRING */
  {  170,   -1 }, /* (37) dnode_host_name ::= NK_ID */
  {  170,   -1 }, /* (38) dnode_host_name ::= NK_IPTOKEN */
  {  163,   -3 }, /* (39) cmd ::= ALTER LOCAL NK_STRING */
  {  163,   -4 }, /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  163,   -5 }, /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  163,   -5 }, /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  163,   -5 }, /* (43) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  163,   -4 }, /* (44) cmd ::= DROP DATABASE exists_opt db_name */
  {  163,   -2 }, /* (45) cmd ::= USE db_name */
  {  163,   -4 }, /* (46) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  171,   -3 }, /* (47) not_exists_opt ::= IF NOT EXISTS */
  {  171,    0 }, /* (48) not_exists_opt ::= */
  {  174,   -2 }, /* (49) exists_opt ::= IF EXISTS */
  {  174,    0 }, /* (50) exists_opt ::= */
  {  173,    0 }, /* (51) db_options ::= */
  {  173,   -3 }, /* (52) db_options ::= db_options BLOCKS NK_INTEGER */
  {  173,   -3 }, /* (53) db_options ::= db_options CACHE NK_INTEGER */
  {  173,   -3 }, /* (54) db_options ::= db_options CACHELAST NK_INTEGER */
  {  173,   -3 }, /* (55) db_options ::= db_options COMP NK_INTEGER */
  {  173,   -3 }, /* (56) db_options ::= db_options DAYS NK_INTEGER */
  {  173,   -3 }, /* (57) db_options ::= db_options FSYNC NK_INTEGER */
  {  173,   -3 }, /* (58) db_options ::= db_options MAXROWS NK_INTEGER */
  {  173,   -3 }, /* (59) db_options ::= db_options MINROWS NK_INTEGER */
  {  173,   -3 }, /* (60) db_options ::= db_options KEEP NK_INTEGER */
  {  173,   -3 }, /* (61) db_options ::= db_options PRECISION NK_STRING */
  {  173,   -3 }, /* (62) db_options ::= db_options QUORUM NK_INTEGER */
  {  173,   -3 }, /* (63) db_options ::= db_options REPLICA NK_INTEGER */
  {  173,   -3 }, /* (64) db_options ::= db_options TTL NK_INTEGER */
  {  173,   -3 }, /* (65) db_options ::= db_options WAL NK_INTEGER */
  {  173,   -3 }, /* (66) db_options ::= db_options VGROUPS NK_INTEGER */
  {  173,   -3 }, /* (67) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  173,   -3 }, /* (68) db_options ::= db_options STREAM_MODE NK_INTEGER */
  {  173,   -3 }, /* (69) db_options ::= db_options RETENTIONS NK_STRING */
  {  173,   -3 }, /* (70) db_options ::= db_options FILE_FACTOR NK_FLOAT */
  {  175,   -1 }, /* (71) alter_db_options ::= alter_db_option */
  {  175,   -2 }, /* (72) alter_db_options ::= alter_db_options alter_db_option */
  {  176,   -2 }, /* (73) alter_db_option ::= BLOCKS NK_INTEGER */
  {  176,   -2 }, /* (74) alter_db_option ::= FSYNC NK_INTEGER */
  {  176,   -2 }, /* (75) alter_db_option ::= KEEP NK_INTEGER */
  {  176,   -2 }, /* (76) alter_db_option ::= WAL NK_INTEGER */
  {  176,   -2 }, /* (77) alter_db_option ::= QUORUM NK_INTEGER */
  {  176,   -2 }, /* (78) alter_db_option ::= CACHELAST NK_INTEGER */
  {  163,   -9 }, /* (79) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  163,   -3 }, /* (80) cmd ::= CREATE TABLE multi_create_clause */
  {  163,   -9 }, /* (81) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  163,   -3 }, /* (82) cmd ::= DROP TABLE multi_drop_clause */
  {  163,   -4 }, /* (83) cmd ::= DROP STABLE exists_opt full_table_name */
  {  163,   -3 }, /* (84) cmd ::= ALTER TABLE alter_table_clause */
  {  163,   -3 }, /* (85) cmd ::= ALTER STABLE alter_table_clause */
  {  184,   -2 }, /* (86) alter_table_clause ::= full_table_name alter_table_options */
  {  184,   -5 }, /* (87) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  184,   -4 }, /* (88) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  184,   -5 }, /* (89) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  184,   -5 }, /* (90) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  184,   -5 }, /* (91) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  184,   -4 }, /* (92) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  184,   -5 }, /* (93) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  184,   -5 }, /* (94) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  184,   -6 }, /* (95) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
  {  181,   -1 }, /* (96) multi_create_clause ::= create_subtable_clause */
  {  181,   -2 }, /* (97) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  188,   -9 }, /* (98) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
  {  183,   -1 }, /* (99) multi_drop_clause ::= drop_table_clause */
  {  183,   -2 }, /* (100) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  191,   -2 }, /* (101) drop_table_clause ::= exists_opt full_table_name */
  {  189,    0 }, /* (102) specific_tags_opt ::= */
  {  189,   -3 }, /* (103) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  177,   -1 }, /* (104) full_table_name ::= table_name */
  {  177,   -3 }, /* (105) full_table_name ::= db_name NK_DOT table_name */
  {  178,   -1 }, /* (106) column_def_list ::= column_def */
  {  178,   -3 }, /* (107) column_def_list ::= column_def_list NK_COMMA column_def */
  {  194,   -2 }, /* (108) column_def ::= column_name type_name */
  {  194,   -4 }, /* (109) column_def ::= column_name type_name COMMENT NK_STRING */
  {  187,   -1 }, /* (110) type_name ::= BOOL */
  {  187,   -1 }, /* (111) type_name ::= TINYINT */
  {  187,   -1 }, /* (112) type_name ::= SMALLINT */
  {  187,   -1 }, /* (113) type_name ::= INT */
  {  187,   -1 }, /* (114) type_name ::= INTEGER */
  {  187,   -1 }, /* (115) type_name ::= BIGINT */
  {  187,   -1 }, /* (116) type_name ::= FLOAT */
  {  187,   -1 }, /* (117) type_name ::= DOUBLE */
  {  187,   -4 }, /* (118) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  187,   -1 }, /* (119) type_name ::= TIMESTAMP */
  {  187,   -4 }, /* (120) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  187,   -2 }, /* (121) type_name ::= TINYINT UNSIGNED */
  {  187,   -2 }, /* (122) type_name ::= SMALLINT UNSIGNED */
  {  187,   -2 }, /* (123) type_name ::= INT UNSIGNED */
  {  187,   -2 }, /* (124) type_name ::= BIGINT UNSIGNED */
  {  187,   -1 }, /* (125) type_name ::= JSON */
  {  187,   -4 }, /* (126) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  187,   -1 }, /* (127) type_name ::= MEDIUMBLOB */
  {  187,   -1 }, /* (128) type_name ::= BLOB */
  {  187,   -4 }, /* (129) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  187,   -1 }, /* (130) type_name ::= DECIMAL */
  {  187,   -4 }, /* (131) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  187,   -6 }, /* (132) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  179,    0 }, /* (133) tags_def_opt ::= */
  {  179,   -1 }, /* (134) tags_def_opt ::= tags_def */
  {  182,   -4 }, /* (135) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  180,    0 }, /* (136) table_options ::= */
  {  180,   -3 }, /* (137) table_options ::= table_options COMMENT NK_STRING */
  {  180,   -3 }, /* (138) table_options ::= table_options KEEP NK_INTEGER */
  {  180,   -3 }, /* (139) table_options ::= table_options TTL NK_INTEGER */
  {  180,   -5 }, /* (140) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  180,   -5 }, /* (141) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  185,   -1 }, /* (142) alter_table_options ::= alter_table_option */
  {  185,   -2 }, /* (143) alter_table_options ::= alter_table_options alter_table_option */
  {  196,   -2 }, /* (144) alter_table_option ::= COMMENT NK_STRING */
  {  196,   -2 }, /* (145) alter_table_option ::= KEEP NK_INTEGER */
  {  196,   -2 }, /* (146) alter_table_option ::= TTL NK_INTEGER */
  {  192,   -1 }, /* (147) col_name_list ::= col_name */
  {  192,   -3 }, /* (148) col_name_list ::= col_name_list NK_COMMA col_name */
  {  197,   -1 }, /* (149) col_name ::= column_name */
  {  163,   -2 }, /* (150) cmd ::= SHOW DNODES */
  {  163,   -2 }, /* (151) cmd ::= SHOW USERS */
  {  163,   -2 }, /* (152) cmd ::= SHOW DATABASES */
  {  163,   -4 }, /* (153) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  163,   -4 }, /* (154) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  163,   -3 }, /* (155) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  163,   -2 }, /* (156) cmd ::= SHOW MNODES */
  {  163,   -2 }, /* (157) cmd ::= SHOW MODULES */
  {  163,   -2 }, /* (158) cmd ::= SHOW QNODES */
  {  163,   -2 }, /* (159) cmd ::= SHOW FUNCTIONS */
  {  163,   -5 }, /* (160) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  163,   -2 }, /* (161) cmd ::= SHOW STREAMS */
  {  198,    0 }, /* (162) db_name_cond_opt ::= */
  {  198,   -2 }, /* (163) db_name_cond_opt ::= db_name NK_DOT */
  {  199,    0 }, /* (164) like_pattern_opt ::= */
  {  199,   -2 }, /* (165) like_pattern_opt ::= LIKE NK_STRING */
  {  200,   -1 }, /* (166) table_name_cond ::= table_name */
  {  201,    0 }, /* (167) from_db_opt ::= */
  {  201,   -2 }, /* (168) from_db_opt ::= FROM db_name */
  {  195,   -1 }, /* (169) func_name_list ::= func_name */
  {  195,   -3 }, /* (170) func_name_list ::= func_name_list NK_COMMA col_name */
  {  202,   -1 }, /* (171) func_name ::= function_name */
  {  163,   -8 }, /* (172) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  163,  -10 }, /* (173) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  163,   -6 }, /* (174) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  205,    0 }, /* (175) index_options ::= */
  {  205,   -9 }, /* (176) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  205,  -11 }, /* (177) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  206,   -1 }, /* (178) func_list ::= func */
  {  206,   -3 }, /* (179) func_list ::= func_list NK_COMMA func */
  {  209,   -4 }, /* (180) func ::= function_name NK_LP expression_list NK_RP */
  {  163,   -6 }, /* (181) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  163,   -6 }, /* (182) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
  {  163,   -4 }, /* (183) cmd ::= DROP TOPIC exists_opt topic_name */
  {  163,   -1 }, /* (184) cmd ::= query_expression */
  {  166,   -1 }, /* (185) literal ::= NK_INTEGER */
  {  166,   -1 }, /* (186) literal ::= NK_FLOAT */
  {  166,   -1 }, /* (187) literal ::= NK_STRING */
  {  166,   -1 }, /* (188) literal ::= NK_BOOL */
  {  166,   -2 }, /* (189) literal ::= TIMESTAMP NK_STRING */
  {  166,   -1 }, /* (190) literal ::= duration_literal */
  {  207,   -1 }, /* (191) duration_literal ::= NK_VARIABLE */
  {  213,   -1 }, /* (192) signed ::= NK_INTEGER */
  {  213,   -2 }, /* (193) signed ::= NK_PLUS NK_INTEGER */
  {  213,   -2 }, /* (194) signed ::= NK_MINUS NK_INTEGER */
  {  213,   -1 }, /* (195) signed ::= NK_FLOAT */
  {  213,   -2 }, /* (196) signed ::= NK_PLUS NK_FLOAT */
  {  213,   -2 }, /* (197) signed ::= NK_MINUS NK_FLOAT */
  {  214,   -1 }, /* (198) signed_literal ::= signed */
  {  214,   -1 }, /* (199) signed_literal ::= NK_STRING */
  {  214,   -1 }, /* (200) signed_literal ::= NK_BOOL */
  {  214,   -2 }, /* (201) signed_literal ::= TIMESTAMP NK_STRING */
  {  214,   -1 }, /* (202) signed_literal ::= duration_literal */
  {  190,   -1 }, /* (203) literal_list ::= signed_literal */
  {  190,   -3 }, /* (204) literal_list ::= literal_list NK_COMMA signed_literal */
  {  172,   -1 }, /* (205) db_name ::= NK_ID */
  {  193,   -1 }, /* (206) table_name ::= NK_ID */
  {  186,   -1 }, /* (207) column_name ::= NK_ID */
  {  203,   -1 }, /* (208) function_name ::= NK_ID */
  {  215,   -1 }, /* (209) table_alias ::= NK_ID */
  {  216,   -1 }, /* (210) column_alias ::= NK_ID */
  {  168,   -1 }, /* (211) user_name ::= NK_ID */
  {  204,   -1 }, /* (212) index_name ::= NK_ID */
  {  211,   -1 }, /* (213) topic_name ::= NK_ID */
  {  217,   -1 }, /* (214) expression ::= literal */
  {  217,   -1 }, /* (215) expression ::= column_reference */
  {  217,   -4 }, /* (216) expression ::= function_name NK_LP expression_list NK_RP */
  {  217,   -4 }, /* (217) expression ::= function_name NK_LP NK_STAR NK_RP */
  {  217,   -1 }, /* (218) expression ::= subquery */
  {  217,   -3 }, /* (219) expression ::= NK_LP expression NK_RP */
  {  217,   -2 }, /* (220) expression ::= NK_PLUS expression */
  {  217,   -2 }, /* (221) expression ::= NK_MINUS expression */
  {  217,   -3 }, /* (222) expression ::= expression NK_PLUS expression */
  {  217,   -3 }, /* (223) expression ::= expression NK_MINUS expression */
  {  217,   -3 }, /* (224) expression ::= expression NK_STAR expression */
  {  217,   -3 }, /* (225) expression ::= expression NK_SLASH expression */
  {  217,   -3 }, /* (226) expression ::= expression NK_REM expression */
  {  210,   -1 }, /* (227) expression_list ::= expression */
  {  210,   -3 }, /* (228) expression_list ::= expression_list NK_COMMA expression */
  {  218,   -1 }, /* (229) column_reference ::= column_name */
  {  218,   -3 }, /* (230) column_reference ::= table_name NK_DOT column_name */
  {  220,   -3 }, /* (231) predicate ::= expression compare_op expression */
  {  220,   -5 }, /* (232) predicate ::= expression BETWEEN expression AND expression */
  {  220,   -6 }, /* (233) predicate ::= expression NOT BETWEEN expression AND expression */
  {  220,   -3 }, /* (234) predicate ::= expression IS NULL */
  {  220,   -4 }, /* (235) predicate ::= expression IS NOT NULL */
  {  220,   -3 }, /* (236) predicate ::= expression in_op in_predicate_value */
  {  221,   -1 }, /* (237) compare_op ::= NK_LT */
  {  221,   -1 }, /* (238) compare_op ::= NK_GT */
  {  221,   -1 }, /* (239) compare_op ::= NK_LE */
  {  221,   -1 }, /* (240) compare_op ::= NK_GE */
  {  221,   -1 }, /* (241) compare_op ::= NK_NE */
  {  221,   -1 }, /* (242) compare_op ::= NK_EQ */
  {  221,   -1 }, /* (243) compare_op ::= LIKE */
  {  221,   -2 }, /* (244) compare_op ::= NOT LIKE */
  {  221,   -1 }, /* (245) compare_op ::= MATCH */
  {  221,   -1 }, /* (246) compare_op ::= NMATCH */
  {  222,   -1 }, /* (247) in_op ::= IN */
  {  222,   -2 }, /* (248) in_op ::= NOT IN */
  {  223,   -3 }, /* (249) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  224,   -1 }, /* (250) boolean_value_expression ::= boolean_primary */
  {  224,   -2 }, /* (251) boolean_value_expression ::= NOT boolean_primary */
  {  224,   -3 }, /* (252) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  224,   -3 }, /* (253) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  225,   -1 }, /* (254) boolean_primary ::= predicate */
  {  225,   -3 }, /* (255) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  226,   -1 }, /* (256) common_expression ::= expression */
  {  226,   -1 }, /* (257) common_expression ::= boolean_value_expression */
  {  227,   -2 }, /* (258) from_clause ::= FROM table_reference_list */
  {  228,   -1 }, /* (259) table_reference_list ::= table_reference */
  {  228,   -3 }, /* (260) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  229,   -1 }, /* (261) table_reference ::= table_primary */
  {  229,   -1 }, /* (262) table_reference ::= joined_table */
  {  230,   -2 }, /* (263) table_primary ::= table_name alias_opt */
  {  230,   -4 }, /* (264) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  230,   -2 }, /* (265) table_primary ::= subquery alias_opt */
  {  230,   -1 }, /* (266) table_primary ::= parenthesized_joined_table */
  {  232,    0 }, /* (267) alias_opt ::= */
  {  232,   -1 }, /* (268) alias_opt ::= table_alias */
  {  232,   -2 }, /* (269) alias_opt ::= AS table_alias */
  {  233,   -3 }, /* (270) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  233,   -3 }, /* (271) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  231,   -6 }, /* (272) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  234,    0 }, /* (273) join_type ::= */
  {  234,   -1 }, /* (274) join_type ::= INNER */
  {  236,   -9 }, /* (275) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  237,    0 }, /* (276) set_quantifier_opt ::= */
  {  237,   -1 }, /* (277) set_quantifier_opt ::= DISTINCT */
  {  237,   -1 }, /* (278) set_quantifier_opt ::= ALL */
  {  238,   -1 }, /* (279) select_list ::= NK_STAR */
  {  238,   -1 }, /* (280) select_list ::= select_sublist */
  {  244,   -1 }, /* (281) select_sublist ::= select_item */
  {  244,   -3 }, /* (282) select_sublist ::= select_sublist NK_COMMA select_item */
  {  245,   -1 }, /* (283) select_item ::= common_expression */
  {  245,   -2 }, /* (284) select_item ::= common_expression column_alias */
  {  245,   -3 }, /* (285) select_item ::= common_expression AS column_alias */
  {  245,   -3 }, /* (286) select_item ::= table_name NK_DOT NK_STAR */
  {  239,    0 }, /* (287) where_clause_opt ::= */
  {  239,   -2 }, /* (288) where_clause_opt ::= WHERE search_condition */
  {  240,    0 }, /* (289) partition_by_clause_opt ::= */
  {  240,   -3 }, /* (290) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  241,    0 }, /* (291) twindow_clause_opt ::= */
  {  241,   -6 }, /* (292) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  241,   -4 }, /* (293) twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP */
  {  241,   -6 }, /* (294) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  241,   -8 }, /* (295) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  208,    0 }, /* (296) sliding_opt ::= */
  {  208,   -4 }, /* (297) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  246,    0 }, /* (298) fill_opt ::= */
  {  246,   -4 }, /* (299) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  246,   -6 }, /* (300) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  247,   -1 }, /* (301) fill_mode ::= NONE */
  {  247,   -1 }, /* (302) fill_mode ::= PREV */
  {  247,   -1 }, /* (303) fill_mode ::= NULL */
  {  247,   -1 }, /* (304) fill_mode ::= LINEAR */
  {  247,   -1 }, /* (305) fill_mode ::= NEXT */
  {  242,    0 }, /* (306) group_by_clause_opt ::= */
  {  242,   -3 }, /* (307) group_by_clause_opt ::= GROUP BY group_by_list */
  {  248,   -1 }, /* (308) group_by_list ::= expression */
  {  248,   -3 }, /* (309) group_by_list ::= group_by_list NK_COMMA expression */
  {  243,    0 }, /* (310) having_clause_opt ::= */
  {  243,   -2 }, /* (311) having_clause_opt ::= HAVING search_condition */
  {  212,   -4 }, /* (312) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  249,   -1 }, /* (313) query_expression_body ::= query_primary */
  {  249,   -4 }, /* (314) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  253,   -1 }, /* (315) query_primary ::= query_specification */
  {  250,    0 }, /* (316) order_by_clause_opt ::= */
  {  250,   -3 }, /* (317) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  251,    0 }, /* (318) slimit_clause_opt ::= */
  {  251,   -2 }, /* (319) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  251,   -4 }, /* (320) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  251,   -4 }, /* (321) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  252,    0 }, /* (322) limit_clause_opt ::= */
  {  252,   -2 }, /* (323) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  252,   -4 }, /* (324) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  252,   -4 }, /* (325) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  219,   -3 }, /* (326) subquery ::= NK_LP query_expression NK_RP */
  {  235,   -1 }, /* (327) search_condition ::= common_expression */
  {  254,   -1 }, /* (328) sort_specification_list ::= sort_specification */
  {  254,   -3 }, /* (329) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  255,   -3 }, /* (330) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  256,    0 }, /* (331) ordering_specification_opt ::= */
  {  256,   -1 }, /* (332) ordering_specification_opt ::= ASC */
  {  256,   -1 }, /* (333) ordering_specification_opt ::= DESC */
  {  257,    0 }, /* (334) null_ordering_opt ::= */
  {  257,   -2 }, /* (335) null_ordering_opt ::= NULLS FIRST */
  {  257,   -2 }, /* (336) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,164,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,165,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,164,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,166,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,167,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,165,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,167,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,166,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy149, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy149, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy149, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy149); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy149, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy149, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy149); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 205: /* db_name ::= NK_ID */ yytestcase(yyruleno==205);
      case 206: /* table_name ::= NK_ID */ yytestcase(yyruleno==206);
      case 207: /* column_name ::= NK_ID */ yytestcase(yyruleno==207);
      case 208: /* function_name ::= NK_ID */ yytestcase(yyruleno==208);
      case 209: /* table_alias ::= NK_ID */ yytestcase(yyruleno==209);
      case 210: /* column_alias ::= NK_ID */ yytestcase(yyruleno==210);
      case 211: /* user_name ::= NK_ID */ yytestcase(yyruleno==211);
      case 212: /* index_name ::= NK_ID */ yytestcase(yyruleno==212);
      case 213: /* topic_name ::= NK_ID */ yytestcase(yyruleno==213);
{ yylhsminor.yy149 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy149 = yylhsminor.yy149;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateQnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropQnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy497, &yymsp[-1].minor.yy149, yymsp[0].minor.yy140); }
        break;
      case 44: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy497, &yymsp[0].minor.yy149); }
        break;
      case 45: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy149); }
        break;
      case 46: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy149, yymsp[0].minor.yy140); }
        break;
      case 47: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy497 = true; }
        break;
      case 48: /* not_exists_opt ::= */
      case 50: /* exists_opt ::= */ yytestcase(yyruleno==50);
      case 276: /* set_quantifier_opt ::= */ yytestcase(yyruleno==276);
{ yymsp[1].minor.yy497 = false; }
        break;
      case 49: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy497 = true; }
        break;
      case 51: /* db_options ::= */
{ yymsp[1].minor.yy140 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 52: /* db_options ::= db_options BLOCKS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_BLOCKS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 53: /* db_options ::= db_options CACHE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_CACHE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 54: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 55: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 56: /* db_options ::= db_options DAYS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 57: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 58: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 59: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 60: /* db_options ::= db_options KEEP NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_KEEP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 61: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 62: /* db_options ::= db_options QUORUM NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_QUORUM, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 63: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 64: /* db_options ::= db_options TTL NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 65: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 66: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 67: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 68: /* db_options ::= db_options STREAM_MODE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_STREAM_MODE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 69: /* db_options ::= db_options RETENTIONS NK_STRING */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_RETENTIONS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 70: /* db_options ::= db_options FILE_FACTOR NK_FLOAT */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_FILE_FACTOR, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 71: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy140 = createDefaultAlterDatabaseOptions(pCxt); yylhsminor.yy140 = setDatabaseOption(pCxt, yylhsminor.yy140, yymsp[0].minor.yy233.type, &yymsp[0].minor.yy233.val); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 72: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy233.type, &yymsp[0].minor.yy233.val); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 73: /* alter_db_option ::= BLOCKS NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_BLOCKS; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 74: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 75: /* alter_db_option ::= KEEP NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_KEEP; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 76: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_WAL; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 77: /* alter_db_option ::= QUORUM NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_QUORUM; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 78: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 79: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 81: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==81);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy497, yymsp[-5].minor.yy140, yymsp[-3].minor.yy136, yymsp[-1].minor.yy136, yymsp[0].minor.yy140); }
        break;
      case 80: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy136); }
        break;
      case 82: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy136); }
        break;
      case 83: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy497, yymsp[0].minor.yy140); }
        break;
      case 84: /* cmd ::= ALTER TABLE alter_table_clause */
      case 85: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==85);
      case 184: /* cmd ::= query_expression */ yytestcase(yyruleno==184);
{ pCxt->pRootNode = yymsp[0].minor.yy140; }
        break;
      case 86: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy140 = createAlterTableOption(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 87: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy149, yymsp[0].minor.yy256); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 88: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy140 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy140, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy149); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 89: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy149, yymsp[0].minor.yy256); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 90: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy140 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy149, &yymsp[0].minor.yy149); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 91: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy149, yymsp[0].minor.yy256); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 92: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy140 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy140, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy149); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 93: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy149, yymsp[0].minor.yy256); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 94: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy140 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy149, &yymsp[0].minor.yy149); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 95: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy140 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy140, &yymsp[-2].minor.yy149, yymsp[0].minor.yy140); }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 96: /* multi_create_clause ::= create_subtable_clause */
      case 99: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==99);
      case 106: /* column_def_list ::= column_def */ yytestcase(yyruleno==106);
      case 147: /* col_name_list ::= col_name */ yytestcase(yyruleno==147);
      case 169: /* func_name_list ::= func_name */ yytestcase(yyruleno==169);
      case 178: /* func_list ::= func */ yytestcase(yyruleno==178);
      case 203: /* literal_list ::= signed_literal */ yytestcase(yyruleno==203);
      case 281: /* select_sublist ::= select_item */ yytestcase(yyruleno==281);
      case 328: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==328);
{ yylhsminor.yy136 = createNodeList(pCxt, yymsp[0].minor.yy140); }
  yymsp[0].minor.yy136 = yylhsminor.yy136;
        break;
      case 97: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 100: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==100);
{ yylhsminor.yy136 = addNodeToList(pCxt, yymsp[-1].minor.yy136, yymsp[0].minor.yy140); }
  yymsp[-1].minor.yy136 = yylhsminor.yy136;
        break;
      case 98: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
{ yylhsminor.yy140 = createCreateSubTableClause(pCxt, yymsp[-8].minor.yy497, yymsp[-7].minor.yy140, yymsp[-5].minor.yy140, yymsp[-4].minor.yy136, yymsp[-1].minor.yy136); }
  yymsp[-8].minor.yy140 = yylhsminor.yy140;
        break;
      case 101: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy140 = createDropTableClause(pCxt, yymsp[-1].minor.yy497, yymsp[0].minor.yy140); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 102: /* specific_tags_opt ::= */
      case 133: /* tags_def_opt ::= */ yytestcase(yyruleno==133);
      case 289: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==289);
      case 306: /* group_by_clause_opt ::= */ yytestcase(yyruleno==306);
      case 316: /* order_by_clause_opt ::= */ yytestcase(yyruleno==316);
{ yymsp[1].minor.yy136 = NULL; }
        break;
      case 103: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy136 = yymsp[-1].minor.yy136; }
        break;
      case 104: /* full_table_name ::= table_name */
{ yylhsminor.yy140 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy149, NULL); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 105: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy140 = createRealTableNode(pCxt, &yymsp[-2].minor.yy149, &yymsp[0].minor.yy149, NULL); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 107: /* column_def_list ::= column_def_list NK_COMMA column_def */
      case 148: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==148);
      case 170: /* func_name_list ::= func_name_list NK_COMMA col_name */ yytestcase(yyruleno==170);
      case 179: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==179);
      case 204: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==204);
      case 282: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==282);
      case 329: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==329);
{ yylhsminor.yy136 = addNodeToList(pCxt, yymsp[-2].minor.yy136, yymsp[0].minor.yy140); }
  yymsp[-2].minor.yy136 = yylhsminor.yy136;
        break;
      case 108: /* column_def ::= column_name type_name */
{ yylhsminor.yy140 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy149, yymsp[0].minor.yy256, NULL); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 109: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy140 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy149, yymsp[-2].minor.yy256, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 110: /* type_name ::= BOOL */
{ yymsp[0].minor.yy256 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 111: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy256 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 112: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy256 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 113: /* type_name ::= INT */
      case 114: /* type_name ::= INTEGER */ yytestcase(yyruleno==114);
{ yymsp[0].minor.yy256 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 115: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy256 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 116: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy256 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 117: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy256 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 118: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy256 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 119: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy256 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 120: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy256 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 121: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy256 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 122: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy256 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 123: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy256 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 124: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy256 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 125: /* type_name ::= JSON */
{ yymsp[0].minor.yy256 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 126: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy256 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 127: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy256 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 128: /* type_name ::= BLOB */
{ yymsp[0].minor.yy256 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 129: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy256 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 130: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy256 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 131: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy256 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 132: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy256 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 134: /* tags_def_opt ::= tags_def */
      case 280: /* select_list ::= select_sublist */ yytestcase(yyruleno==280);
{ yylhsminor.yy136 = yymsp[0].minor.yy136; }
  yymsp[0].minor.yy136 = yylhsminor.yy136;
        break;
      case 135: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy136 = yymsp[-1].minor.yy136; }
        break;
      case 136: /* table_options ::= */
{ yymsp[1].minor.yy140 = createDefaultTableOptions(pCxt); }
        break;
      case 137: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 138: /* table_options ::= table_options KEEP NK_INTEGER */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_KEEP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 139: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 140: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy140 = setTableSmaOption(pCxt, yymsp[-4].minor.yy140, yymsp[-1].minor.yy136); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 141: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ yylhsminor.yy140 = setTableRollupOption(pCxt, yymsp[-4].minor.yy140, yymsp[-1].minor.yy136); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 142: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy140 = createDefaultAlterTableOptions(pCxt); yylhsminor.yy140 = setTableOption(pCxt, yylhsminor.yy140, yymsp[0].minor.yy233.type, &yymsp[0].minor.yy233.val); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 143: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy233.type, &yymsp[0].minor.yy233.val); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 144: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy233.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 145: /* alter_table_option ::= KEEP NK_INTEGER */
{ yymsp[-1].minor.yy233.type = TABLE_OPTION_KEEP; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 146: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy233.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 149: /* col_name ::= column_name */
{ yylhsminor.yy140 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy149); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 150: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 151: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 152: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 153: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 154: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 155: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy140, NULL); }
        break;
      case 156: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 157: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 158: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 159: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 160: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 161: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 162: /* db_name_cond_opt ::= */
      case 167: /* from_db_opt ::= */ yytestcase(yyruleno==167);
{ yymsp[1].minor.yy140 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 163: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy149); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 164: /* like_pattern_opt ::= */
      case 175: /* index_options ::= */ yytestcase(yyruleno==175);
      case 287: /* where_clause_opt ::= */ yytestcase(yyruleno==287);
      case 291: /* twindow_clause_opt ::= */ yytestcase(yyruleno==291);
      case 296: /* sliding_opt ::= */ yytestcase(yyruleno==296);
      case 298: /* fill_opt ::= */ yytestcase(yyruleno==298);
      case 310: /* having_clause_opt ::= */ yytestcase(yyruleno==310);
      case 318: /* slimit_clause_opt ::= */ yytestcase(yyruleno==318);
      case 322: /* limit_clause_opt ::= */ yytestcase(yyruleno==322);
{ yymsp[1].minor.yy140 = NULL; }
        break;
      case 165: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 166: /* table_name_cond ::= table_name */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy149); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 168: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy149); }
        break;
      case 171: /* func_name ::= function_name */
{ yylhsminor.yy140 = createFunctionNode(pCxt, &yymsp[0].minor.yy149, NULL); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 172: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy497, &yymsp[-3].minor.yy149, &yymsp[-1].minor.yy149, NULL, yymsp[0].minor.yy140); }
        break;
      case 173: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy497, &yymsp[-5].minor.yy149, &yymsp[-3].minor.yy149, yymsp[-1].minor.yy136, NULL); }
        break;
      case 174: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy497, &yymsp[-2].minor.yy149, &yymsp[0].minor.yy149); }
        break;
      case 176: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy140 = createIndexOption(pCxt, yymsp[-6].minor.yy136, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), NULL, yymsp[0].minor.yy140); }
        break;
      case 177: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy140 = createIndexOption(pCxt, yymsp[-8].minor.yy136, releaseRawExprNode(pCxt, yymsp[-4].minor.yy140), releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), yymsp[0].minor.yy140); }
        break;
      case 180: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy140 = createFunctionNode(pCxt, &yymsp[-3].minor.yy149, yymsp[-1].minor.yy136); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 181: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy497, &yymsp[-2].minor.yy149, yymsp[0].minor.yy140, NULL); }
        break;
      case 182: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy497, &yymsp[-2].minor.yy149, NULL, &yymsp[0].minor.yy149); }
        break;
      case 183: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy497, &yymsp[0].minor.yy149); }
        break;
      case 185: /* literal ::= NK_INTEGER */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 186: /* literal ::= NK_FLOAT */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 187: /* literal ::= NK_STRING */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 188: /* literal ::= NK_BOOL */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 189: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 190: /* literal ::= duration_literal */
      case 198: /* signed_literal ::= signed */ yytestcase(yyruleno==198);
      case 214: /* expression ::= literal */ yytestcase(yyruleno==214);
      case 215: /* expression ::= column_reference */ yytestcase(yyruleno==215);
      case 218: /* expression ::= subquery */ yytestcase(yyruleno==218);
      case 250: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==250);
      case 254: /* boolean_primary ::= predicate */ yytestcase(yyruleno==254);
      case 256: /* common_expression ::= expression */ yytestcase(yyruleno==256);
      case 257: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==257);
      case 259: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==259);
      case 261: /* table_reference ::= table_primary */ yytestcase(yyruleno==261);
      case 262: /* table_reference ::= joined_table */ yytestcase(yyruleno==262);
      case 266: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==266);
      case 313: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==313);
      case 315: /* query_primary ::= query_specification */ yytestcase(yyruleno==315);
{ yylhsminor.yy140 = yymsp[0].minor.yy140; }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 191: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 192: /* signed ::= NK_INTEGER */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 193: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 194: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 195: /* signed ::= NK_FLOAT */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 196: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 197: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 199: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 200: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 201: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 202: /* signed_literal ::= duration_literal */
      case 327: /* search_condition ::= common_expression */ yytestcase(yyruleno==327);
{ yylhsminor.yy140 = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 216: /* expression ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy149, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy149, yymsp[-1].minor.yy136)); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 217: /* expression ::= function_name NK_LP NK_STAR NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy149, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy149, createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy0)))); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 219: /* expression ::= NK_LP expression NK_RP */
      case 255: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==255);
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 220: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy140));
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 221: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[0].minor.yy140), NULL));
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 222: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 223: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 224: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 225: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 226: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 227: /* expression_list ::= expression */
{ yylhsminor.yy136 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[0].minor.yy136 = yylhsminor.yy136;
        break;
      case 228: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy136 = addNodeToList(pCxt, yymsp[-2].minor.yy136, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[-2].minor.yy136 = yylhsminor.yy136;
        break;
      case 229: /* column_reference ::= column_name */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy149, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy149)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 230: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy149, &yymsp[0].minor.yy149, createColumnNode(pCxt, &yymsp[-2].minor.yy149, &yymsp[0].minor.yy149)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 231: /* predicate ::= expression compare_op expression */
      case 236: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==236);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy320, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 232: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy140), releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 233: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[-5].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 234: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), NULL));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 235: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), NULL));
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 237: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy320 = OP_TYPE_LOWER_THAN; }
        break;
      case 238: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy320 = OP_TYPE_GREATER_THAN; }
        break;
      case 239: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy320 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 240: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy320 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 241: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy320 = OP_TYPE_NOT_EQUAL; }
        break;
      case 242: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy320 = OP_TYPE_EQUAL; }
        break;
      case 243: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy320 = OP_TYPE_LIKE; }
        break;
      case 244: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy320 = OP_TYPE_NOT_LIKE; }
        break;
      case 245: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy320 = OP_TYPE_MATCH; }
        break;
      case 246: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy320 = OP_TYPE_NMATCH; }
        break;
      case 247: /* in_op ::= IN */
{ yymsp[0].minor.yy320 = OP_TYPE_IN; }
        break;
      case 248: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy320 = OP_TYPE_NOT_IN; }
        break;
      case 249: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy136)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 251: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy140), NULL));
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 252: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 253: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 258: /* from_clause ::= FROM table_reference_list */
      case 288: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==288);
      case 311: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==311);
{ yymsp[-1].minor.yy140 = yymsp[0].minor.yy140; }
        break;
      case 260: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy140 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy140, yymsp[0].minor.yy140, NULL); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 263: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy140 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy149, &yymsp[0].minor.yy149); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 264: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy140 = createRealTableNode(pCxt, &yymsp[-3].minor.yy149, &yymsp[-1].minor.yy149, &yymsp[0].minor.yy149); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 265: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy140 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140), &yymsp[0].minor.yy149); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 267: /* alias_opt ::= */
{ yymsp[1].minor.yy149 = nil_token;  }
        break;
      case 268: /* alias_opt ::= table_alias */
{ yylhsminor.yy149 = yymsp[0].minor.yy149; }
  yymsp[0].minor.yy149 = yylhsminor.yy149;
        break;
      case 269: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy149 = yymsp[0].minor.yy149; }
        break;
      case 270: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 271: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==271);
{ yymsp[-2].minor.yy140 = yymsp[-1].minor.yy140; }
        break;
      case 272: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy140 = createJoinTableNode(pCxt, yymsp[-4].minor.yy144, yymsp[-5].minor.yy140, yymsp[-2].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 273: /* join_type ::= */
{ yymsp[1].minor.yy144 = JOIN_TYPE_INNER; }
        break;
      case 274: /* join_type ::= INNER */
{ yymsp[0].minor.yy144 = JOIN_TYPE_INNER; }
        break;
      case 275: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy140 = createSelectStmt(pCxt, yymsp[-7].minor.yy497, yymsp[-6].minor.yy136, yymsp[-5].minor.yy140);
                                                                                    yymsp[-8].minor.yy140 = addWhereClause(pCxt, yymsp[-8].minor.yy140, yymsp[-4].minor.yy140);
                                                                                    yymsp[-8].minor.yy140 = addPartitionByClause(pCxt, yymsp[-8].minor.yy140, yymsp[-3].minor.yy136);
                                                                                    yymsp[-8].minor.yy140 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy140, yymsp[-2].minor.yy140);
                                                                                    yymsp[-8].minor.yy140 = addGroupByClause(pCxt, yymsp[-8].minor.yy140, yymsp[-1].minor.yy136);
                                                                                    yymsp[-8].minor.yy140 = addHavingClause(pCxt, yymsp[-8].minor.yy140, yymsp[0].minor.yy140);
                                                                                  }
        break;
      case 277: /* set_quantifier_opt ::= DISTINCT */
{ yymsp[0].minor.yy497 = true; }
        break;
      case 278: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy497 = false; }
        break;
      case 279: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy136 = NULL; }
        break;
      case 283: /* select_item ::= common_expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy140), &t);
                                                                                  }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 284: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy140 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140), &yymsp[0].minor.yy149); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 285: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy140 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), &yymsp[0].minor.yy149); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 286: /* select_item ::= table_name NK_DOT NK_STAR */
{ yylhsminor.yy140 = createColumnNode(pCxt, &yymsp[-2].minor.yy149, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 290: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 307: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==307);
      case 317: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==317);
{ yymsp[-2].minor.yy136 = yymsp[0].minor.yy136; }
        break;
      case 292: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy140 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
        break;
      case 293: /* twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP */
{ yymsp[-3].minor.yy140 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
        break;
      case 294: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy140 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), NULL, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 295: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy140 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy140), releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 297: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy140 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy140); }
        break;
      case 299: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy140 = createFillNode(pCxt, yymsp[-1].minor.yy306, NULL); }
        break;
      case 300: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy140 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy136)); }
        break;
      case 301: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy306 = FILL_MODE_NONE; }
        break;
      case 302: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy306 = FILL_MODE_PREV; }
        break;
      case 303: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy306 = FILL_MODE_NULL; }
        break;
      case 304: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy306 = FILL_MODE_LINEAR; }
        break;
      case 305: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy306 = FILL_MODE_NEXT; }
        break;
      case 308: /* group_by_list ::= expression */
{ yylhsminor.yy136 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); }
  yymsp[0].minor.yy136 = yylhsminor.yy136;
        break;
      case 309: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy136 = addNodeToList(pCxt, yymsp[-2].minor.yy136, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); }
  yymsp[-2].minor.yy136 = yylhsminor.yy136;
        break;
      case 312: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy140 = addOrderByClause(pCxt, yymsp[-3].minor.yy140, yymsp[-2].minor.yy136);
                                                                                    yylhsminor.yy140 = addSlimitClause(pCxt, yylhsminor.yy140, yymsp[-1].minor.yy140);
                                                                                    yylhsminor.yy140 = addLimitClause(pCxt, yylhsminor.yy140, yymsp[0].minor.yy140);
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 314: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy140 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 319: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 323: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==323);
{ yymsp[-1].minor.yy140 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 320: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 324: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==324);
{ yymsp[-3].minor.yy140 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 321: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 325: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==325);
{ yymsp[-3].minor.yy140 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 326: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy140); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 330: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy140 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), yymsp[-1].minor.yy158, yymsp[0].minor.yy73); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 331: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy158 = ORDER_ASC; }
        break;
      case 332: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy158 = ORDER_ASC; }
        break;
      case 333: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy158 = ORDER_DESC; }
        break;
      case 334: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy73 = NULL_ORDER_DEFAULT; }
        break;
      case 335: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy73 = NULL_ORDER_FIRST; }
        break;
      case 336: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy73 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
