/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 426
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SAlterOption yy5;
  int8_t yy59;
  int64_t yy69;
  EJoinType yy156;
  SNodeList* yy172;
  EFillMode yy186;
  SToken yy209;
  int32_t yy232;
  SNode* yy272;
  bool yy293;
  EOperatorType yy392;
  ENullOrder yy493;
  SDataType yy616;
  EOrder yy818;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             667
#define YYNRULE              489
#define YYNTOKEN             305
#define YY_MAX_SHIFT         666
#define YY_MIN_SHIFTREDUCE   972
#define YY_MAX_SHIFTREDUCE   1460
#define YY_ERROR_ACTION      1461
#define YY_ACCEPT_ACTION     1462
#define YY_NO_ACTION         1463
#define YY_MIN_REDUCE        1464
#define YY_MAX_REDUCE        1952
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2259)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   433, 1930,  434, 1499, 1593,  441,  526,  434, 1499,  513,
 /*    10 */    30,  260,   39,   37, 1929,  326,  325,  117, 1927, 1702,
 /*    20 */   339, 1465, 1261,  146,  471,   40,   38,   36,   35,   34,
 /*    30 */  1786,  552, 1606, 1337, 1604, 1259,  344,  552, 1287, 1649,
 /*    40 */  1651,  378,  107, 1774,  526,  106,  105,  104,  103,  102,
 /*    50 */   101,  100,   99,   98, 1770,  117, 1332,  432, 1804,   64,
 /*    60 */   436,   14,  476,   36,   35,   34,  553,  148, 1267, 1476,
 /*    70 */   450, 1756, 1604,  577,   39,   37, 1400, 1595, 1766, 1772,
 /*    80 */   328, 1930,  339, 1526, 1261, 1804,  217, 1286, 1770,    1,
 /*    90 */   571, 1005, 1656,  542,  164, 1337, 1818, 1259, 1927,  327,
 /*   100 */    95, 1787,  580, 1789, 1790,  576,   43,  571, 1654,  158,
 /*   110 */  1864,  663, 1766, 1772,  330, 1860,  159,  513, 1332,   63,
 /*   120 */  1930,   78, 1643,   14,  571, 1339, 1340, 1703,  163,  541,
 /*   130 */  1267, 1009, 1010,  165,   33,   32, 1890, 1927,   40,   38,
 /*   140 */    36,   35,   34,  543,   63,   63,  640,  639,  638,  637,
 /*   150 */   349,    2,  636,  635,  128,  630,  629,  628,  627,  626,
 /*   160 */   625,  624,  139,  620,  619,  618,  348,  347,  615,  614,
 /*   170 */  1262,  107, 1260,  663,  106,  105,  104,  103,  102,  101,
 /*   180 */   100,   99,   98,  440, 1775, 1287,  436, 1339, 1340,  223,
 /*   190 */   224,   11,   10, 1265, 1266, 1770, 1314, 1315, 1317, 1318,
 /*   200 */  1319, 1320, 1321, 1322,  573,  569, 1330, 1331, 1333, 1334,
 /*   210 */  1335, 1336, 1338, 1341, 1464,  496, 1431,   33,   32, 1766,
 /*   220 */  1772,   40,   38,   36,   35,   34,  526,  167,  494,  150,
 /*   230 */   492,  571, 1262, 1564, 1260, 1261,  210,   55,  116,  115,
 /*   240 */   114,  113,  112,  111,  110,  109,  108,  305, 1259,   63,
 /*   250 */   516, 1701,   22,  300, 1604, 1265, 1266,  167, 1314, 1315,
 /*   260 */  1317, 1318, 1319, 1320, 1321, 1322,  573,  569, 1330, 1331,
 /*   270 */  1333, 1334, 1335, 1336, 1338, 1341,   39,   37, 1650, 1651,
 /*   280 */  1373, 1267,  167,  167,  339,  552, 1261,  613, 1286,   49,
 /*   290 */  1160, 1161,   76,  305, 1786, 1487,  516, 1337, 1421, 1259,
 /*   300 */  1118,  602,  601,  600, 1122,  599, 1124, 1125,  598, 1127,
 /*   310 */   595,  342, 1133,  592, 1135, 1136,  589,  586, 1285,  146,
 /*   320 */  1332, 1581, 1804,  173,  663,   14,  479,  478, 1606,  377,
 /*   330 */   553,  376, 1267, 1656, 1930, 1756, 1756,  577,   39,   37,
 /*   340 */   312,  535, 1419, 1420, 1422, 1423,  339, 1928, 1261, 1654,
 /*   350 */  1705, 1927,   84,    2,   42,   71, 1656,   63,   70, 1337,
 /*   360 */  1818, 1259, 1267,  343,   95, 1787,  580, 1789, 1790,  576,
 /*   370 */   605,  571, 1654, 1597, 1864,  663,  345, 1589,  330, 1860,
 /*   380 */   159, 1288, 1332, 1262,  146, 1260, 1022,  167, 1021, 1339,
 /*   390 */  1340,   33,   32, 1606, 1267,   40,   38,   36,   35,   34,
 /*   400 */  1891, 1930,  384,   39,   37, 1342, 1265, 1266, 1486, 1485,
 /*   410 */   611,  339, 1786, 1261,  165,    8, 1023,  438, 1927,  634,
 /*   420 */   632, 1080,  611, 1284, 1337,  622, 1259,  167,  549,  137,
 /*   430 */   136,  608,  607,  606, 1262, 1695, 1260,  663, 1484,  303,
 /*   440 */  1804,  137,  136,  608,  607,  606,  172, 1332,  575, 1756,
 /*   450 */  1756, 1339, 1340, 1756, 1082,  577,  127, 1265, 1266, 1267,
 /*   460 */  1314, 1315, 1317, 1318, 1319, 1320, 1321, 1322,  573,  569,
 /*   470 */  1330, 1331, 1333, 1334, 1335, 1336, 1338, 1341, 1818, 1756,
 /*   480 */     9, 1591,  293, 1787,  580, 1789, 1790,  576,  574,  571,
 /*   490 */   568, 1836,  167,   74,  125,  167, 1262,  222, 1260,   33,
 /*   500 */    32, 1529,  663,   40,   38,   36,   35,   34,  551,  160,
 /*   510 */  1872, 1873, 1587, 1877, 1483, 1600, 1339, 1340,  252, 1265,
 /*   520 */  1266, 1579, 1314, 1315, 1317, 1318, 1319, 1320, 1321, 1322,
 /*   530 */   573,  569, 1330, 1331, 1333, 1334, 1335, 1336, 1338, 1341,
 /*   540 */  1700,  526,  300,   33,   32, 1457,   91,   40,   38,   36,
 /*   550 */    35,   34,  169,  167,  316, 1756, 1241, 1242,  623,  124,
 /*   560 */  1576, 1262, 1879, 1260,   26,  482,  481, 1596, 1462, 1604,
 /*   570 */    33,   32,  123, 1582,   40,   38,   36,   35,   34,  213,
 /*   580 */  1786, 1411,  477,  480, 1265, 1266, 1876, 1314, 1315, 1317,
 /*   590 */  1318, 1319, 1320, 1321, 1322,  573,  569, 1330, 1331, 1333,
 /*   600 */  1334, 1335, 1336, 1338, 1341,   39,   37,  475, 1804,  317,
 /*   610 */   146,  315,  314,  339,  473, 1261,  578, 1361,  475, 1607,
 /*   620 */   549, 1756,  611,  577,   28, 1299, 1337,  354, 1259,  474,
 /*   630 */    33,   32, 1456,  450,   40,   38,   36,   35,   34,  538,
 /*   640 */   474,  137,  136,  608,  607,  606, 1818, 1695,  127, 1332,
 /*   650 */    96, 1787,  580, 1789, 1790,  576,  572,  571,  175,   74,
 /*   660 */  1864, 1267,  526,  609, 1863, 1860, 1647, 1930,  554,  512,
 /*   670 */    33,   32,  122,  382,   40,   38,   36,   35,   34,   27,
 /*   680 */   164, 1599,    9, 1482, 1927, 1022,  125, 1021,    7, 1366,
 /*   690 */  1604,   33,   32, 1481, 1565,   40,   38,   36,   35,   34,
 /*   700 */   469,  250, 1872,  548,  663,  547,   33,   32, 1930, 1930,
 /*   710 */    40,   38,   36,   35,   34, 1023,  544,  539, 1339, 1340,
 /*   720 */   526,  166,  164,  307, 1756, 1927, 1927,  135,  487, 1404,
 /*   730 */   526,  383,   39,   37, 1756, 1286, 1480,  302, 1879, 1284,
 /*   740 */   339,  389, 1261,  497,  307,  526,  412,  604, 1604,  424,
 /*   750 */   526,  549, 1299, 1337, 1477, 1259,  404,  209, 1604,   61,
 /*   760 */  1359,  405, 1875, 1262,  373, 1260,  397, 1479,  425, 1478,
 /*   770 */   399,  490,  255, 1604,   54,  484, 1332, 1756, 1604,  127,
 /*   780 */   208, 1359, 1475,  375,  371,  419, 1265, 1266, 1267, 1314,
 /*   790 */  1315, 1317, 1318, 1319, 1320, 1321, 1322,  573,  569, 1330,
 /*   800 */  1331, 1333, 1334, 1335, 1336, 1338, 1341,  390, 1756,    2,
 /*   810 */  1756, 1397,   58,  526, 1360,   57, 1879,  125,  505,  386,
 /*   820 */  1289,   33,   32, 1756,  448,   40,   38,   36,   35,   34,
 /*   830 */  1474,  663,  161, 1872, 1873, 1360, 1877,  177,  176, 1505,
 /*   840 */  1874, 1604, 1347, 1009, 1010, 1339, 1340,  423, 1286, 1580,
 /*   850 */   418,  417,  416,  415,  414,  411,  410,  409,  408,  407,
 /*   860 */   403,  402,  401,  400,  394,  393,  392,  391,  549,  388,
 /*   870 */   387, 1756, 1656,  616, 1473, 1393,   29,  337, 1354, 1355,
 /*   880 */  1356, 1357, 1358, 1362, 1363, 1364, 1365,  658, 1655,  468,
 /*   890 */  1262,  610, 1260, 1286, 1647, 1068,  127,   29,  337, 1354,
 /*   900 */  1355, 1356, 1357, 1358, 1362, 1363, 1364, 1365,  272,  613,
 /*   910 */   536, 1634, 1316, 1265, 1266, 1756, 1314, 1315, 1317, 1318,
 /*   920 */  1319, 1320, 1321, 1322,  573,  569, 1330, 1331, 1333, 1334,
 /*   930 */  1335, 1336, 1338, 1341,  125,  147, 1472, 1786,  561,  352,
 /*   940 */   278,  351, 1884, 1393, 1743,  482,  481, 1516, 1774,  162,
 /*   950 */  1872, 1873,  123, 1877,  276,   60, 1805,  232,   59, 1770,
 /*   960 */   526,  526,  477,  480, 1471, 1804,   44,    4,  244,  483,
 /*   970 */   145,  449, 1601,  578,  180,  429,  427, 1756, 1756, 1930,
 /*   980 */   577, 1930, 1500, 1766, 1772,  334, 1470, 1786, 1604, 1604,
 /*   990 */   526,  361,  164,  554,  164,  571, 1927,  216, 1927,  498,
 /*  1000 */   556,  499, 1469, 1818, 1468, 1756,   63,   94, 1787,  580,
 /*  1010 */  1789, 1790,  576,  526,  571, 1804,  558, 1864, 1604,  336,
 /*  1020 */   335,  306, 1860,  578,  506, 1316,  526, 1756, 1756, 1275,
 /*  1030 */   577,  201,   77, 1930,  199, 1396, 1644,  510,  526, 1930,
 /*  1040 */  1337, 1604, 1268, 1756,   93, 1756,  166, 1511, 1467,  227,
 /*  1050 */  1927,  350,  164, 1818, 1604, 1786, 1927,   95, 1787,  580,
 /*  1060 */  1789, 1790,  576, 1332,  571,  526, 1604, 1864,   41,  485,
 /*  1070 */  1316,  330, 1860, 1943,  526, 1267,  522,   53,  509,   68,
 /*  1080 */    67,  381, 1898, 1804,  171,  524,  221,  203,  526, 1756,
 /*  1090 */   202,  578,  205, 1604,  207,  204, 1756,  206,  577,  525,
 /*  1100 */   301, 1509, 1604,  369, 1894,  367,  363,  359,  356,  353,
 /*  1110 */  1270,  554,  131,  526, 1786, 1212, 1604, 1269,  566,  567,
 /*  1120 */   526, 1818,  134,  488,  261,   94, 1787,  580, 1789, 1790,
 /*  1130 */   576,  346,  571,  225,  135, 1864,   51,  550,  666,  306,
 /*  1140 */  1860, 1604, 1804,  562,  167,  236,   51,  323, 1604,   41,
 /*  1150 */   578, 1930,  267,   90, 1786, 1756,  617,  577,   41,  519,
 /*  1160 */  1777,   11,   10,   87,  164,  249,  156,    3, 1927,  229,
 /*  1170 */   254,  656,  652,  648,  644,  265,  584, 1276, 1066, 1271,
 /*  1180 */  1818, 1111, 1804, 1418,  294, 1787,  580, 1789, 1790,  576,
 /*  1190 */   578,  571,  239, 1367, 1786, 1756, 1323,  577, 1459, 1460,
 /*  1200 */  1279, 1281,  257, 1779,  259,  271,  134,   92,  135,    5,
 /*  1210 */   230, 1049,  569, 1330, 1331, 1333, 1334, 1335, 1336,  559,
 /*  1220 */  1818,  360, 1804, 1139,   95, 1787,  580, 1789, 1790,  576,
 /*  1230 */   578,  571,  268,  355, 1864, 1756,  119,  577,  330, 1860,
 /*  1240 */  1943,  134,  549,  523, 1050,  313, 1228, 1273,  174, 1921,
 /*  1250 */   385, 1351, 1284, 1143, 1272, 1150,  406,  413, 1697,  421,
 /*  1260 */  1818,  420,  422, 1786,   95, 1787,  580, 1789, 1790,  576,
 /*  1270 */   127,  571,  426,  428, 1864,  219,  430, 1290,  330, 1860,
 /*  1280 */  1943,  431,  439, 1148, 1292,  442,  183,  443,  138, 1883,
 /*  1290 */   554, 1804, 1291, 1235,  185,  212,  444, 1293,  188,  578,
 /*  1300 */   445,  190,  447,   72, 1756,   73,  577,  451,  125,  194,
 /*  1310 */   470,  472, 1594,  198,  118, 1590,  304, 1786,  200,  554,
 /*  1320 */   140,  269,  141,  250, 1872,  548, 1592,  547, 1588, 1818,
 /*  1330 */  1930,  142,  143,  285, 1787,  580, 1789, 1790,  576,  211,
 /*  1340 */   571,  500, 1736,  164,  214, 1804,  507, 1927,  504,  511,
 /*  1350 */   218,  322,  534,  578,  514,  520,  501, 1735, 1756, 1930,
 /*  1360 */   577,  132, 1707,  517,  324, 1289,   81, 1786,  521,  133,
 /*  1370 */   270,   83,  166,  554,  537, 1605, 1927,  530, 1905,  234,
 /*  1380 */  1895,  238,    6, 1818, 1786,  532,  533,  285, 1787,  580,
 /*  1390 */  1789, 1790,  576,  329,  571, 1804,  546,  531,  540,  529,
 /*  1400 */   528,  248, 1288,  578, 1393,  126,  563,  560, 1756,   48,
 /*  1410 */   577, 1880, 1804, 1930, 1904,   85, 1648,  331, 1577,  659,
 /*  1420 */   578,  582,  264,  660,  243, 1756,  164,  577,  153, 1886,
 /*  1430 */  1927,  247,  245, 1818, 1786,  246,  253,   96, 1787,  580,
 /*  1440 */  1789, 1790,  576, 1845,  571,  273,  662, 1864,  299,  275,
 /*  1450 */  1818,  565, 1860,  256,  149, 1787,  580, 1789, 1790,  576,
 /*  1460 */  1786,  571, 1804,   52, 1946, 1926,  557,  286,  296,  258,
 /*  1470 */   578,  564,  295, 1750,  277, 1756, 1749,  577,   65, 1748,
 /*  1480 */  1747,   66, 1744,  357,  358, 1253, 1254,  170, 1804,  362,
 /*  1490 */  1742,  364,  365,  527,  366, 1741,  578,  368,  555, 1944,
 /*  1500 */  1818, 1756, 1740,  577,   96, 1787,  580, 1789, 1790,  576,
 /*  1510 */  1786,  571,  370, 1739, 1864,  372, 1738, 1230,  374, 1861,
 /*  1520 */  1231, 1718, 1786,  379,  380, 1716, 1818, 1717, 1715, 1690,
 /*  1530 */   294, 1787,  580, 1789, 1790,  576, 1786,  571, 1804, 1689,
 /*  1540 */  1200,  129, 1688, 1687,   69, 1686,  578,  395, 1681,  396,
 /*  1550 */  1804, 1756, 1685,  577, 1684, 1683, 1682,  398,  578, 1680,
 /*  1560 */  1679, 1678, 1677, 1756, 1804,  577, 1676, 1675, 1674, 1673,
 /*  1570 */  1672, 1671,  575, 1670, 1669, 1668, 1818, 1756, 1667,  577,
 /*  1580 */   289, 1787,  580, 1789, 1790,  576,  130,  571, 1818, 1786,
 /*  1590 */  1666, 1665,  149, 1787,  580, 1789, 1790,  576, 1664,  571,
 /*  1600 */  1663, 1662, 1818, 1202, 1660, 1659,  293, 1787,  580, 1789,
 /*  1610 */  1790,  576, 1661,  571, 1658, 1837, 1657, 1804,  545, 1531,
 /*  1620 */   178, 1530,  338,  120,  181,  578,  196, 1528,  179, 1496,
 /*  1630 */  1756,  157,  577,  435, 1012,  437, 1011, 1945, 1495,  182,
 /*  1640 */   152,  121, 1786,  452,  453,  467,  463,  459,  455,  195,
 /*  1650 */  1731, 1725, 1714,  189, 1786, 1818,  187, 1713, 1699,  294,
 /*  1660 */  1787,  580, 1789, 1790,  576, 1583,  571, 1527, 1786, 1042,
 /*  1670 */  1804, 1525,  454, 1523,  456,  340,  458,  457,  578, 1521,
 /*  1680 */   460,   75, 1804, 1756,  193,  577,  462,  461, 1519,  464,
 /*  1690 */   578,  465,  466, 1508, 1507, 1756, 1804,  577, 1492, 1585,
 /*  1700 */  1153, 1154,  197, 1584,  578, 1079, 1074,   50, 1818, 1756,
 /*  1710 */  1517,  577,  294, 1787,  580, 1789, 1790,  576,  631,  571,
 /*  1720 */  1818, 1076, 1786,  633,  279, 1787,  580, 1789, 1790,  576,
 /*  1730 */  1075,  571, 1512,  318, 1818,  319, 1786, 1510,  280, 1787,
 /*  1740 */   580, 1789, 1790,  576,  320,  571,  192,  186, 1786,  191,
 /*  1750 */  1804,  486,  489,  446, 1491,  491, 1490, 1489,  578,  493,
 /*  1760 */   495,   97, 1730, 1756, 1804,  577, 1237,   56, 1724,  184,
 /*  1770 */   502, 1712,  578, 1710,  508,  503, 1804, 1756,  215,  577,
 /*  1780 */  1711, 1709,  321, 1708,  578,   15,  144,  220, 1818, 1756,
 /*  1790 */  1245,  577,  281, 1787,  580, 1789, 1790,  576, 1706,  571,
 /*  1800 */  1698,  226, 1818,  518,   79, 1786,  288, 1787,  580, 1789,
 /*  1810 */  1790,  576,  228,  571, 1818, 1786,  515,   80,  290, 1787,
 /*  1820 */   580, 1789, 1790,  576,   82,  571,   87,   41,  231,   23,
 /*  1830 */    47, 1786, 1433, 1804,  233,  241,  235, 1415,  237,  242,
 /*  1840 */  1417,  578,   16, 1804,   25, 1777, 1756,  151,  577,  240,
 /*  1850 */    24,  578,   46, 1410,   86, 1786, 1756,   17,  577, 1804,
 /*  1860 */  1390,  251, 1389, 1776,  154, 1450,   45,  578,   18, 1439,
 /*  1870 */  1445, 1818, 1756,   13,  577,  282, 1787,  580, 1789, 1790,
 /*  1880 */   576, 1818,  571, 1804, 1444,  291, 1787,  580, 1789, 1790,
 /*  1890 */   576,  578,  571,  332, 1449, 1448, 1756, 1818,  577,  333,
 /*  1900 */    10,  283, 1787,  580, 1789, 1790,  576, 1277,  571, 1352,
 /*  1910 */    19, 1786, 1821, 1307, 1327,  570,  155, 1325,   31,  581,
 /*  1920 */  1324, 1818,   12,   20,  168,  292, 1787,  580, 1789, 1790,
 /*  1930 */   576, 1786,  571,   21,  583, 1140,  341,  585,  579, 1804,
 /*  1940 */  1137,  587,  588,  590, 1134,  591,  593,  578,  596, 1132,
 /*  1950 */   594, 1786, 1756, 1128,  577, 1126, 1131,  597, 1117, 1804,
 /*  1960 */  1130,   88, 1149,  603, 1129,   89,   62,  578,  262, 1145,
 /*  1970 */   612, 1786, 1756, 1071,  577, 1070, 1040, 1818, 1069, 1804,
 /*  1980 */  1067,  284, 1787,  580, 1789, 1790,  576,  578,  571, 1065,
 /*  1990 */  1064, 1786, 1756, 1063,  577,  263, 1086, 1818, 1061, 1804,
 /*  2000 */  1060,  297, 1787,  580, 1789, 1790,  576,  578,  571,  621,
 /*  2010 */  1059, 1058, 1756, 1057,  577, 1056, 1055, 1818, 1083, 1804,
 /*  2020 */  1081,  298, 1787,  580, 1789, 1790,  576,  578,  571, 1052,
 /*  2030 */  1051, 1786, 1756, 1048,  577, 1047, 1046, 1818, 1045, 1524,
 /*  2040 */   641, 1798, 1787,  580, 1789, 1790,  576, 1786,  571,  642,
 /*  2050 */   643, 1522,  645,  646,  647, 1520,  649, 1818,  651, 1804,
 /*  2060 */   650, 1797, 1787,  580, 1789, 1790,  576,  578,  571, 1518,
 /*  2070 */   653,  654, 1756,  655,  577, 1804, 1506,  657, 1002, 1488,
 /*  2080 */   266,  661,  664,  578, 1263,  274,  665, 1463, 1756, 1463,
 /*  2090 */   577, 1463, 1463, 1463, 1463, 1463, 1463, 1818, 1786, 1463,
 /*  2100 */  1463, 1796, 1787,  580, 1789, 1790,  576, 1463,  571, 1463,
 /*  2110 */  1463, 1463, 1463, 1818, 1786, 1463, 1463,  310, 1787,  580,
 /*  2120 */  1789, 1790,  576, 1463,  571, 1463, 1804, 1463, 1463, 1463,
 /*  2130 */  1463, 1463, 1463, 1463,  578, 1463, 1463, 1463, 1463, 1756,
 /*  2140 */  1463,  577, 1804, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*  2150 */   578, 1463, 1463, 1463, 1463, 1756, 1463,  577, 1463, 1463,
 /*  2160 */  1463, 1463, 1463, 1463, 1818, 1786, 1463, 1463,  309, 1787,
 /*  2170 */   580, 1789, 1790,  576, 1463,  571, 1463, 1463, 1463, 1463,
 /*  2180 */  1818, 1786, 1463, 1463,  311, 1787,  580, 1789, 1790,  576,
 /*  2190 */  1463,  571, 1463, 1804, 1463, 1463, 1463, 1463, 1463, 1463,
 /*  2200 */  1463,  578, 1463, 1463, 1463, 1463, 1756, 1463,  577, 1804,
 /*  2210 */  1463, 1463, 1463, 1463, 1463, 1463, 1463,  578, 1463, 1463,
 /*  2220 */  1463, 1463, 1756, 1463,  577, 1463, 1463, 1463, 1463, 1463,
 /*  2230 */  1463, 1818, 1463, 1463, 1463,  308, 1787,  580, 1789, 1790,
 /*  2240 */   576, 1463,  571, 1463, 1463, 1463, 1463, 1818, 1463, 1463,
 /*  2250 */  1463,  287, 1787,  580, 1789, 1790,  576, 1463,  571,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   312,  404,  314,  315,  337,  312,  316,  314,  315,  351,
 /*    10 */   389,  390,   12,   13,  417,  328,  358,  327,  421,  361,
 /*    20 */    20,    0,   22,  336,  334,   12,   13,   14,   15,   16,
 /*    30 */   308,   20,  345,   33,  344,   35,  347,   20,   20,  350,
 /*    40 */   351,  364,   21,  338,  316,   24,   25,   26,   27,   28,
 /*    50 */    29,   30,   31,   32,  349,  327,   56,  313,  336,    4,
 /*    60 */   316,   61,  334,   14,   15,   16,  344,  307,   68,  309,
 /*    70 */    60,  349,  344,  351,   12,   13,   14,  338,  373,  374,
 /*    80 */   375,  404,   20,    0,   22,  336,   56,   20,  349,   89,
 /*    90 */   385,    4,  336,  344,  417,   33,  374,   35,  421,  343,
 /*   100 */   378,  379,  380,  381,  382,  383,   89,  385,  352,  335,
 /*   110 */   388,  111,  373,  374,  392,  393,  394,  351,   56,   89,
 /*   120 */   404,   91,  348,   61,  385,  125,  126,  361,  406,  380,
 /*   130 */    68,   44,   45,  417,    8,    9,  414,  421,   12,   13,
 /*   140 */    14,   15,   16,   20,   89,   89,   63,   64,   65,   66,
 /*   150 */    67,   89,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   160 */    77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   170 */   170,   21,  172,  111,   24,   25,   26,   27,   28,   29,
 /*   180 */    30,   31,   32,  313,  338,   20,  316,  125,  126,  120,
 /*   190 */   121,    1,    2,  193,  194,  349,  196,  197,  198,  199,
 /*   200 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,    0,   21,   90,    8,    9,  373,
 /*   220 */   374,   12,   13,   14,   15,   16,  316,  227,   34,  321,
 /*   230 */    36,  385,  170,  325,  172,   22,  121,  327,   24,   25,
 /*   240 */    26,   27,   28,   29,   30,   31,   32,  178,   35,   89,
 /*   250 */   181,  360,   43,  362,  344,  193,  194,  227,  196,  197,
 /*   260 */   198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
 /*   270 */   208,  209,  210,  211,  212,  213,   12,   13,  350,  351,
 /*   280 */    90,   68,  227,  227,   20,   20,   22,   60,   20,   89,
 /*   290 */   125,  126,  177,  178,  308,  308,  181,   33,  193,   35,
 /*   300 */   102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
 /*   310 */   112,  328,  114,  115,  116,  117,  118,  119,   20,  336,
 /*   320 */    56,    0,  336,   56,  111,   61,  322,  323,  345,  169,
 /*   330 */   344,  171,   68,  336,  404,  349,  349,  351,   12,   13,
 /*   340 */   343,  236,  237,  238,  239,  240,   20,  417,   22,  352,
 /*   350 */     0,  421,  318,   89,   89,   88,  336,   89,   91,   33,
 /*   360 */   374,   35,   68,  343,  378,  379,  380,  381,  382,  383,
 /*   370 */   100,  385,  352,  339,  388,  111,  328,  337,  392,  393,
 /*   380 */   394,   20,   56,  170,  336,  172,   20,  227,   22,  125,
 /*   390 */   126,    8,    9,  345,   68,   12,   13,   14,   15,   16,
 /*   400 */   414,  404,  316,   12,   13,   14,  193,  194,  308,  308,
 /*   410 */   101,   20,  308,   22,  417,   89,   50,   14,  421,  322,
 /*   420 */   323,   35,  101,   20,   33,   68,   35,  227,  316,  120,
 /*   430 */   121,  122,  123,  124,  170,  344,  172,  111,  308,  353,
 /*   440 */   336,  120,  121,  122,  123,  124,  355,   56,  344,  349,
 /*   450 */   349,  125,  126,  349,   68,  351,  344,  193,  194,   68,
 /*   460 */   196,  197,  198,  199,  200,  201,  202,  203,  204,  205,
 /*   470 */   206,  207,  208,  209,  210,  211,  212,  213,  374,  349,
 /*   480 */    89,  337,  378,  379,  380,  381,  382,  383,  384,  385,
 /*   490 */   386,  387,  227,  320,  382,  227,  170,  120,  172,    8,
 /*   500 */     9,    0,  111,   12,   13,   14,   15,   16,  396,  397,
 /*   510 */   398,  399,  337,  401,  308,  342,  125,  126,  157,  193,
 /*   520 */   194,    0,  196,  197,  198,  199,  200,  201,  202,  203,
 /*   530 */   204,  205,  206,  207,  208,  209,  210,  211,  212,  213,
 /*   540 */   360,  316,  362,    8,    9,  162,  318,   12,   13,   14,
 /*   550 */    15,   16,  327,  227,   37,  349,  179,  180,  324,  331,
 /*   560 */   326,  170,  376,  172,    2,   64,   65,  339,  305,  344,
 /*   570 */     8,    9,   71,    0,   12,   13,   14,   15,   16,  337,
 /*   580 */   308,   90,   81,   82,  193,  194,  400,  196,  197,  198,
 /*   590 */   199,  200,  201,  202,  203,  204,  205,  206,  207,  208,
 /*   600 */   209,  210,  211,  212,  213,   12,   13,  101,  336,   92,
 /*   610 */   336,   94,   95,   20,   97,   22,  344,  152,  101,  345,
 /*   620 */   316,  349,  101,  351,    2,   90,   33,  364,   35,  123,
 /*   630 */     8,    9,  249,   60,   12,   13,   14,   15,   16,  155,
 /*   640 */   123,  120,  121,  122,  123,  124,  374,  344,  344,   56,
 /*   650 */   378,  379,  380,  381,  382,  383,  337,  385,  355,  320,
 /*   660 */   388,   68,  316,  346,  392,  393,  349,  404,  364,  364,
 /*   670 */     8,    9,  333,  327,   12,   13,   14,   15,   16,  214,
 /*   680 */   417,  342,   89,  308,  421,   20,  382,   22,   39,  224,
 /*   690 */   344,    8,    9,  308,  325,   12,   13,   14,   15,   16,
 /*   700 */    35,  397,  398,  399,  111,  401,    8,    9,  404,  404,
 /*   710 */    12,   13,   14,   15,   16,   50,  232,  233,  125,  126,
 /*   720 */   316,  417,  417,   61,  349,  421,  421,   43,    4,   14,
 /*   730 */   316,  327,   12,   13,  349,   20,  308,   18,  376,   20,
 /*   740 */    20,  327,   22,   19,   61,  316,   27,  337,  344,   30,
 /*   750 */   316,  316,   90,   33,  309,   35,  327,   33,  344,    3,
 /*   760 */    98,  327,  400,  170,  165,  172,   47,  308,   49,  308,
 /*   770 */    51,   47,  424,  344,   90,   51,   56,  349,  344,  344,
 /*   780 */    56,   98,  308,  184,  185,   77,  193,  194,   68,  196,
 /*   790 */   197,  198,  199,  200,  201,  202,  203,  204,  205,  206,
 /*   800 */   207,  208,  209,  210,  211,  212,  213,   88,  349,   89,
 /*   810 */   349,    4,   88,  316,  152,   91,  376,  382,  368,  100,
 /*   820 */    20,    8,    9,  349,  327,   12,   13,   14,   15,   16,
 /*   830 */   308,  111,  397,  398,  399,  152,  401,  129,  130,    0,
 /*   840 */   400,  344,   14,   44,   45,  125,  126,  128,   20,    0,
 /*   850 */   131,  132,  133,  134,  135,  136,  137,  138,  139,  140,
 /*   860 */   141,  142,  143,  144,  145,  146,  147,  148,  316,  150,
 /*   870 */   151,  349,  336,   13,  308,  226,  214,  215,  216,  217,
 /*   880 */   218,  219,  220,  221,  222,  223,  224,   48,  352,  317,
 /*   890 */   170,  346,  172,   20,  349,   35,  344,  214,  215,  216,
 /*   900 */   217,  218,  219,  220,  221,  222,  223,  224,  329,   60,
 /*   910 */   415,  332,  197,  193,  194,  349,  196,  197,  198,  199,
 /*   920 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   930 */   210,  211,  212,  213,  382,   18,  308,  308,   43,  364,
 /*   940 */    23,  364,  225,  226,    0,   64,   65,    0,  338,  397,
 /*   950 */   398,  399,   71,  401,   37,   38,  336,  157,   41,  349,
 /*   960 */   316,  316,   81,   82,  308,  336,   42,   43,  411,   22,
 /*   970 */   157,  327,  327,  344,   57,   58,   59,  349,  349,  404,
 /*   980 */   351,  404,  315,  373,  374,  375,  308,  308,  344,  344,
 /*   990 */   316,   47,  417,  364,  417,  385,  421,   56,  421,  364,
 /*  1000 */   244,  327,  308,  374,  308,  349,   89,  378,  379,  380,
 /*  1010 */   381,  382,  383,  316,  385,  336,   43,  388,  344,   12,
 /*  1020 */    13,  392,  393,  344,  327,  197,  316,  349,  349,   22,
 /*  1030 */   351,   93,   91,  404,   96,  228,  348,  327,  316,  404,
 /*  1040 */    33,  344,   35,  349,  127,  349,  417,    0,  308,  327,
 /*  1050 */   421,  317,  417,  374,  344,  308,  421,  378,  379,  380,
 /*  1060 */   381,  382,  383,   56,  385,  316,  344,  388,   43,   22,
 /*  1070 */   197,  392,  393,  394,  316,   68,  327,  157,  158,  162,
 /*  1080 */   163,  164,  403,  336,  167,  327,   43,   93,  316,  349,
 /*  1090 */    96,  344,   93,  344,   93,   96,  349,   96,  351,  327,
 /*  1100 */   183,    0,  344,  186,  377,  188,  189,  190,  191,  192,
 /*  1110 */    35,  364,   43,  316,  308,   90,  344,   35,  111,   61,
 /*  1120 */   316,  374,   43,   22,  327,  378,  379,  380,  381,  382,
 /*  1130 */   383,  327,  385,   90,   43,  388,   43,  402,   19,  392,
 /*  1140 */   393,  344,  336,  248,  227,   43,   43,  341,  344,   43,
 /*  1150 */   344,  404,   33,   89,  308,  349,   13,  351,   43,   90,
 /*  1160 */    46,    1,    2,   99,  417,  395,   47,  405,  421,   90,
 /*  1170 */   418,   52,   53,   54,   55,   56,   43,  170,   35,  172,
 /*  1180 */   374,   90,  336,   90,  378,  379,  380,  381,  382,  383,
 /*  1190 */   344,  385,   90,   90,  308,  349,   90,  351,  125,  126,
 /*  1200 */   193,  194,  418,   89,  418,   90,   43,   88,   43,  229,
 /*  1210 */    91,   35,  205,  206,  207,  208,  209,  210,  211,  246,
 /*  1220 */   374,   47,  336,   90,  378,  379,  380,  381,  382,  383,
 /*  1230 */   344,  385,  366,  372,  388,  349,   43,  351,  392,  393,
 /*  1240 */   394,   43,  316,  124,   68,  371,  168,  172,   42,  403,
 /*  1250 */   356,  193,   20,   90,  172,   90,  316,  356,  316,  152,
 /*  1260 */   374,  354,  354,  308,  378,  379,  380,  381,  382,  383,
 /*  1270 */   344,  385,  316,  316,  388,  156,  316,   20,  392,  393,
 /*  1280 */   394,  310,  310,   90,   20,  370,  320,  351,   90,  403,
 /*  1290 */   364,  336,   20,  174,  320,  176,  363,   20,  320,  344,
 /*  1300 */   365,  320,  363,  320,  349,  320,  351,  316,  382,  320,
 /*  1310 */   310,  336,  336,  336,  316,  336,  310,  308,  336,  364,
 /*  1320 */   336,  370,  336,  397,  398,  399,  336,  401,  336,  374,
 /*  1330 */   404,  336,  336,  378,  379,  380,  381,  382,  383,  318,
 /*  1340 */   385,  175,  349,  417,  318,  336,  316,  421,  351,  316,
 /*  1350 */   318,  363,  234,  344,  349,  154,  369,  349,  349,  404,
 /*  1360 */   351,  359,  349,  349,  349,   20,  318,  308,  357,  359,
 /*  1370 */   332,  318,  417,  364,  235,  344,  421,  349,  410,  359,
 /*  1380 */   377,  359,  241,  374,  308,  349,  349,  378,  379,  380,
 /*  1390 */   381,  382,  383,  349,  385,  336,  161,  243,  349,  242,
 /*  1400 */   230,  372,   20,  344,  226,  344,  247,  245,  349,   89,
 /*  1410 */   351,  376,  336,  404,  410,   89,  349,  250,  326,   36,
 /*  1420 */   344,  340,  318,  311,  412,  349,  417,  351,  410,  413,
 /*  1430 */   421,  407,  409,  374,  308,  408,  419,  378,  379,  380,
 /*  1440 */   381,  382,  383,  391,  385,  316,  310,  388,  362,  319,
 /*  1450 */   374,  392,  393,  419,  378,  379,  380,  381,  382,  383,
 /*  1460 */   308,  385,  336,  367,  425,  420,  420,  330,  330,  419,
 /*  1470 */   344,  420,  330,    0,  306,  349,    0,  351,  177,    0,
 /*  1480 */     0,   42,    0,   35,  187,   35,   35,   35,  336,  187,
 /*  1490 */     0,   35,   35,  341,  187,    0,  344,  187,  422,  423,
 /*  1500 */   374,  349,    0,  351,  378,  379,  380,  381,  382,  383,
 /*  1510 */   308,  385,   35,    0,  388,   22,    0,  170,   35,  393,
 /*  1520 */   172,    0,  308,  166,  165,    0,  374,    0,    0,    0,
 /*  1530 */   378,  379,  380,  381,  382,  383,  308,  385,  336,    0,
 /*  1540 */    46,   42,    0,    0,  149,    0,  344,  144,    0,   35,
 /*  1550 */   336,  349,    0,  351,    0,    0,    0,  144,  344,    0,
 /*  1560 */     0,    0,    0,  349,  336,  351,    0,    0,    0,    0,
 /*  1570 */     0,    0,  344,    0,    0,    0,  374,  349,    0,  351,
 /*  1580 */   378,  379,  380,  381,  382,  383,   42,  385,  374,  308,
 /*  1590 */     0,    0,  378,  379,  380,  381,  382,  383,    0,  385,
 /*  1600 */     0,    0,  374,   22,    0,    0,  378,  379,  380,  381,
 /*  1610 */   382,  383,    0,  385,    0,  387,    0,  336,  416,    0,
 /*  1620 */    56,    0,  341,   39,   42,  344,   33,    0,   56,    0,
 /*  1630 */   349,   43,  351,   46,   14,   46,   14,  423,    0,   40,
 /*  1640 */    47,   39,  308,   35,   47,   52,   53,   54,   55,   56,
 /*  1650 */     0,    0,    0,  161,  308,  374,   39,    0,    0,  378,
 /*  1660 */   379,  380,  381,  382,  383,    0,  385,    0,  308,   62,
 /*  1670 */   336,    0,   39,    0,   35,  341,   39,   47,  344,    0,
 /*  1680 */    35,   88,  336,  349,   91,  351,   39,   47,    0,   35,
 /*  1690 */   344,   47,   39,    0,    0,  349,  336,  351,    0,    0,
 /*  1700 */    22,   35,   96,    0,  344,   35,   22,   98,  374,  349,
 /*  1710 */     0,  351,  378,  379,  380,  381,  382,  383,   43,  385,
 /*  1720 */   374,   35,  308,   43,  378,  379,  380,  381,  382,  383,
 /*  1730 */    35,  385,    0,   22,  374,   22,  308,    0,  378,  379,
 /*  1740 */   380,  381,  382,  383,   22,  385,  153,  154,  308,  156,
 /*  1750 */   336,   49,   35,  160,    0,   35,    0,    0,  344,   35,
 /*  1760 */    22,   20,    0,  349,  336,  351,   35,  157,    0,  176,
 /*  1770 */    22,    0,  344,    0,  159,  157,  336,  349,  154,  351,
 /*  1780 */     0,    0,  157,    0,  344,   89,  173,   90,  374,  349,
 /*  1790 */    35,  351,  378,  379,  380,  381,  382,  383,    0,  385,
 /*  1800 */     0,   89,  374,  155,   89,  308,  378,  379,  380,  381,
 /*  1810 */   382,  383,  153,  385,  374,  308,  182,   39,  378,  379,
 /*  1820 */   380,  381,  382,  383,   89,  385,   99,   43,   46,   89,
 /*  1830 */    43,  308,   90,  336,   89,   43,   90,   90,   89,   46,
 /*  1840 */    90,  344,  231,  336,   43,   46,  349,   89,  351,   89,
 /*  1850 */    89,  344,   43,   90,   89,  308,  349,  231,  351,  336,
 /*  1860 */    90,   46,   90,   46,   46,   90,  225,  344,   43,   90,
 /*  1870 */    35,  374,  349,  231,  351,  378,  379,  380,  381,  382,
 /*  1880 */   383,  374,  385,  336,   35,  378,  379,  380,  381,  382,
 /*  1890 */   383,  344,  385,   35,   35,   35,  349,  374,  351,   35,
 /*  1900 */     2,  378,  379,  380,  381,  382,  383,   22,  385,  193,
 /*  1910 */    43,  308,   89,   22,   90,   89,   46,   90,   89,  100,
 /*  1920 */    90,  374,   89,   89,   46,  378,  379,  380,  381,  382,
 /*  1930 */   383,  308,  385,   89,   35,   90,   35,   89,  195,  336,
 /*  1940 */    90,   35,   89,   35,   90,   89,   35,  344,   35,  113,
 /*  1950 */    89,  308,  349,   90,  351,   90,  113,   89,   22,  336,
 /*  1960 */   113,   89,   35,  101,  113,   89,   89,  344,   43,   22,
 /*  1970 */    61,  308,  349,   35,  351,   35,   62,  374,   35,  336,
 /*  1980 */    35,  378,  379,  380,  381,  382,  383,  344,  385,   35,
 /*  1990 */    35,  308,  349,   35,  351,   43,   68,  374,   35,  336,
 /*  2000 */    35,  378,  379,  380,  381,  382,  383,  344,  385,   87,
 /*  2010 */    22,   35,  349,   22,  351,   35,   35,  374,   68,  336,
 /*  2020 */    35,  378,  379,  380,  381,  382,  383,  344,  385,   35,
 /*  2030 */    35,  308,  349,   35,  351,   35,   22,  374,   35,    0,
 /*  2040 */    35,  378,  379,  380,  381,  382,  383,  308,  385,   47,
 /*  2050 */    39,    0,   35,   47,   39,    0,   35,  374,   39,  336,
 /*  2060 */    47,  378,  379,  380,  381,  382,  383,  344,  385,    0,
 /*  2070 */    35,   47,  349,   39,  351,  336,    0,   35,   35,    0,
 /*  2080 */    22,   21,   21,  344,   22,   22,   20,  426,  349,  426,
 /*  2090 */   351,  426,  426,  426,  426,  426,  426,  374,  308,  426,
 /*  2100 */   426,  378,  379,  380,  381,  382,  383,  426,  385,  426,
 /*  2110 */   426,  426,  426,  374,  308,  426,  426,  378,  379,  380,
 /*  2120 */   381,  382,  383,  426,  385,  426,  336,  426,  426,  426,
 /*  2130 */   426,  426,  426,  426,  344,  426,  426,  426,  426,  349,
 /*  2140 */   426,  351,  336,  426,  426,  426,  426,  426,  426,  426,
 /*  2150 */   344,  426,  426,  426,  426,  349,  426,  351,  426,  426,
 /*  2160 */   426,  426,  426,  426,  374,  308,  426,  426,  378,  379,
 /*  2170 */   380,  381,  382,  383,  426,  385,  426,  426,  426,  426,
 /*  2180 */   374,  308,  426,  426,  378,  379,  380,  381,  382,  383,
 /*  2190 */   426,  385,  426,  336,  426,  426,  426,  426,  426,  426,
 /*  2200 */   426,  344,  426,  426,  426,  426,  349,  426,  351,  336,
 /*  2210 */   426,  426,  426,  426,  426,  426,  426,  344,  426,  426,
 /*  2220 */   426,  426,  349,  426,  351,  426,  426,  426,  426,  426,
 /*  2230 */   426,  374,  426,  426,  426,  378,  379,  380,  381,  382,
 /*  2240 */   383,  426,  385,  426,  426,  426,  426,  374,  426,  426,
 /*  2250 */   426,  378,  379,  380,  381,  382,  383,  426,  385,  426,
 /*  2260 */   426,  426,  426,  426,  426,  426,  426,  426,  426,  426,
 /*  2270 */   426,  426,  426,  426,  426,  426,  426,  426,  426,  426,
 /*  2280 */   426,  426,  426,  426,  426,  426,  426,  426,  426,  426,
 /*  2290 */   426,  426,  426,  426,  426,  426,  426,  426,  426,  426,
 /*  2300 */   426,  426,  426,  426,  426,  426,  426,  426,  426,  426,
 /*  2310 */   426,  426,  426,  426,  426,  426,  426,  426,  426,  426,
 /*  2320 */   426,  426,  426,  426,  426,  426,  426,  426,  426,  426,
 /*  2330 */   426,  426,  426,  426,  426,  426,  426,  426,  426,  426,
 /*  2340 */   426,  426,  426,  426,  426,  426,  426,  426,  426,  426,
 /*  2350 */   426,  426,  426,  426,  426,  426,  426,  426,  426,  426,
 /*  2360 */   426,  426,  426,  426,  426,  426,  426,  426,  426,  426,
 /*  2370 */   426,  426,  426,  426,  426,  426,  426,  426,  426,  426,
 /*  2380 */   426,  426,  426,  426,  426,  426,  426,  426,  426,  426,
 /*  2390 */   426,  426,
};
#define YY_SHIFT_COUNT    (666)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2079)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   917,    0,    0,   62,   62,  264,  264,  264,  326,  326,
 /*    10 */   264,  264,  391,  593,  720,  593,  593,  593,  593,  593,
 /*    20 */   593,  593,  593,  593,  593,  593,  593,  593,  593,  593,
 /*    30 */   593,  593,  593,  593,  593,  593,  593,  593,  593,  593,
 /*    40 */   593,  593,  265,  265,   17,   17,   17, 1007, 1007,  268,
 /*    50 */  1007, 1007,  160,   30,   56,  200,   56,   11,   11,   87,
 /*    60 */    87,   55,  165,   56,   56,   11,   11,   11,   11,   11,
 /*    70 */    11,   11,   11,   11,   11,   10,   11,   11,   11,   18,
 /*    80 */    11,   11,   67,   11,   11,   67,  123,   11,   67,   67,
 /*    90 */    67,   11,  227,  719,  662,  683,  683,  150,  213,  213,
 /*   100 */   213,  213,  213,  213,  213,  213,  213,  213,  213,  213,
 /*   110 */   213,  213,  213,  213,  213,  213,  213,  517,  881,  165,
 /*   120 */   403,  403,  573,  386,  849,  361,  361,  361,  386,  298,
 /*   130 */   298,   18,  350,  350,   67,   67,  294,  294,  270,  357,
 /*   140 */   198,  198,  198,  198,  198,  198,  198, 1119,   21,  383,
 /*   150 */   501,  105,  665,  484,  715,  828,  366,  799,  506,  800,
 /*   160 */   717,  649,  717,  924,  756,  756,  756,  807,  873,  980,
 /*   170 */  1174, 1078, 1206, 1232, 1232, 1206, 1107, 1107, 1232, 1232,
 /*   180 */  1232, 1257, 1257, 1264,   10,   18,   10, 1272, 1277,   10,
 /*   190 */  1272,   10,   10,   10, 1232,   10, 1257,   67,   67,   67,
 /*   200 */    67,   67,   67,   67,   67,   67,   67,   67, 1232, 1257,
 /*   210 */   294, 1264,  227, 1166,   18,  227, 1232, 1232, 1272,  227,
 /*   220 */  1118,  294,  294,  294,  294, 1118,  294, 1201,  227,  270,
 /*   230 */   227,  298, 1345,  294, 1139, 1118,  294,  294, 1139, 1118,
 /*   240 */   294,  294,   67, 1141, 1235, 1139, 1154, 1157, 1170,  980,
 /*   250 */  1178,  298, 1382, 1159, 1162, 1167, 1159, 1162, 1159, 1162,
 /*   260 */  1320, 1326,  294,  357, 1232,  227, 1383, 1257, 2259, 2259,
 /*   270 */  2259, 2259, 2259, 2259, 2259,   83, 1593,  214,  724,  126,
 /*   280 */   209,  491,  562,  622,  813,  535,  321,  698,  698,  698,
 /*   290 */   698,  698,  698,  698,  698,  521,  309,   13,   13,  115,
 /*   300 */    69,  599,  267,  708,  194,  377,  190,  465,   49,   49,
 /*   310 */    49,   49,  684,  944,  938,  994,  999, 1001,  947, 1047,
 /*   320 */  1101,  941,  920, 1025, 1043, 1069, 1079, 1091, 1093, 1102,
 /*   330 */  1160, 1073,  973,  895, 1103, 1075, 1082, 1058, 1106, 1114,
 /*   340 */  1115, 1133, 1163, 1165, 1193, 1198, 1064,  860, 1143, 1176,
 /*   350 */   839, 1473, 1476, 1301, 1479, 1480, 1439, 1482, 1448, 1297,
 /*   360 */  1450, 1451, 1452, 1302, 1490, 1456, 1457, 1307, 1495, 1310,
 /*   370 */  1502, 1477, 1513, 1493, 1516, 1483, 1348, 1347, 1521, 1527,
 /*   380 */  1357, 1359, 1525, 1528, 1494, 1529, 1499, 1539, 1542, 1543,
 /*   390 */  1395, 1545, 1552, 1554, 1555, 1556, 1403, 1514, 1548, 1413,
 /*   400 */  1559, 1560, 1561, 1562, 1566, 1567, 1568, 1569, 1570, 1571,
 /*   410 */  1573, 1574, 1575, 1578, 1544, 1590, 1591, 1598, 1600, 1601,
 /*   420 */  1612, 1581, 1604, 1605, 1614, 1616, 1619, 1564, 1621, 1572,
 /*   430 */  1627, 1629, 1582, 1584, 1588, 1620, 1587, 1622, 1589, 1638,
 /*   440 */  1599, 1602, 1650, 1651, 1652, 1617, 1492, 1657, 1658, 1665,
 /*   450 */  1607, 1667, 1671, 1608, 1597, 1633, 1673, 1639, 1630, 1637,
 /*   460 */  1679, 1645, 1640, 1647, 1688, 1654, 1644, 1653, 1693, 1694,
 /*   470 */  1698, 1699, 1609, 1606, 1666, 1678, 1703, 1670, 1675, 1680,
 /*   480 */  1686, 1695, 1684, 1710, 1711, 1732, 1713, 1702, 1737, 1722,
 /*   490 */  1717, 1754, 1720, 1756, 1724, 1757, 1738, 1741, 1762, 1610,
 /*   500 */  1731, 1768, 1613, 1748, 1618, 1624, 1771, 1773, 1625, 1615,
 /*   510 */  1780, 1781, 1783, 1696, 1697, 1755, 1634, 1798, 1712, 1648,
 /*   520 */  1715, 1800, 1778, 1659, 1735, 1727, 1782, 1784, 1611, 1740,
 /*   530 */  1742, 1745, 1746, 1747, 1749, 1787, 1750, 1758, 1760, 1761,
 /*   540 */  1763, 1792, 1793, 1799, 1765, 1801, 1626, 1770, 1772, 1815,
 /*   550 */  1641, 1809, 1817, 1818, 1775, 1825, 1642, 1779, 1835, 1849,
 /*   560 */  1858, 1859, 1860, 1864, 1779, 1898, 1885, 1716, 1867, 1823,
 /*   570 */  1824, 1826, 1827, 1829, 1830, 1870, 1833, 1834, 1878, 1891,
 /*   580 */  1743, 1844, 1819, 1845, 1899, 1901, 1848, 1850, 1906, 1853,
 /*   590 */  1854, 1908, 1856, 1863, 1911, 1861, 1865, 1913, 1868, 1836,
 /*   600 */  1843, 1847, 1851, 1936, 1862, 1872, 1876, 1927, 1877, 1925,
 /*   610 */  1925, 1947, 1914, 1909, 1938, 1940, 1943, 1945, 1954, 1955,
 /*   620 */  1958, 1928, 1922, 1952, 1963, 1965, 1988, 1976, 1991, 1980,
 /*   630 */  1981, 1950, 1675, 1985, 1680, 1994, 1995, 1998, 2000, 2014,
 /*   640 */  2003, 2039, 2005, 2002, 2011, 2051, 2017, 2006, 2015, 2055,
 /*   650 */  2021, 2013, 2019, 2069, 2035, 2024, 2034, 2076, 2042, 2043,
 /*   660 */  2079, 2058, 2060, 2062, 2063, 2061, 2066,
};
#define YY_REDUCE_COUNT (274)
#define YY_REDUCE_MIN   (-403)
#define YY_REDUCE_MAX   (1873)
static const short yy_reduce_ofst[] = {
 /*     0 */   263,  629,  747, -278,  -14,  679,  846,  886,  955, 1009,
 /*    10 */   272, 1059,  104, 1076, 1126,  806, 1152, 1202, 1214, 1228,
 /*    20 */  1281, 1334, 1346, 1360, 1414, 1428, 1440, 1497, 1507, 1523,
 /*    30 */  1547, 1603, 1623, 1643, 1663, 1683, 1723, 1739, 1790, 1806,
 /*    40 */  1857, 1873,  304,  926,  112,  435,  552, -295,  610,   -3,
 /*    50 */  -261, -154, -323,  305,  575,  577,  635, -310, -272, -312,
 /*    60 */  -307, -403, -311, -284,  -70,  -90,  225,  346,  404,  414,
 /*    70 */   429,  434,  497,  644,  645,  339,  674,  697,  710, -342,
 /*    80 */   722,  749, -313,  758,  772, -244, -251,  797,  -17,   20,
 /*    90 */    48,  804,  228,   86, -379, -379, -379, -240,  -13,  100,
 /*   100 */   101,  130,  206,  375,  385,  428,  459,  461,  474,  522,
 /*   110 */   566,  628,  656,  678,  694,  696,  740, -226,  -92,  -72,
 /*   120 */  -256, -130,  173,    4,   34,  186,  362,  440,   97,   91,
 /*   130 */   303, -234, -109,  180,  274,  536,  317,  545,  579,  234,
 /*   140 */  -333,   40,  144,  175,  242,  319,  410,  450,  445,  348,
 /*   150 */   369,  495,  572,  557,  620,  620,  734,  667,  688,  727,
 /*   160 */   735,  735,  735,  770,  752,  784,  786,  762,  620,  861,
 /*   170 */   874,  866,  894,  940,  942,  901,  907,  908,  956,  957,
 /*   180 */   960,  971,  972,  915,  966,  936,  974,  933,  935,  978,
 /*   190 */   939,  981,  983,  985,  991,  989, 1000,  975,  976,  977,
 /*   200 */   979,  982,  984,  986,  990,  992,  995,  996,  998, 1006,
 /*   210 */   993,  951, 1021,  987,  997, 1026, 1030, 1033,  988, 1032,
 /*   220 */  1002, 1005, 1008, 1013, 1014, 1010, 1015, 1011, 1048, 1038,
 /*   230 */  1053, 1031, 1003, 1028,  968, 1020, 1036, 1037, 1004, 1022,
 /*   240 */  1044, 1049,  620, 1016, 1012, 1018, 1023, 1027, 1024, 1029,
 /*   250 */   735, 1061, 1035, 1045, 1017, 1039, 1046, 1034, 1051, 1050,
 /*   260 */  1052, 1081, 1067, 1092, 1129, 1104, 1112, 1136, 1096, 1086,
 /*   270 */  1137, 1138, 1142, 1130, 1168,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*    10 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*    20 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*    30 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*    40 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*    50 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*    60 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*    70 */  1461, 1461, 1461, 1461, 1461, 1535, 1461, 1461, 1461, 1461,
 /*    80 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*    90 */  1461, 1461, 1533, 1691, 1461, 1866, 1461, 1461, 1461, 1461,
 /*   100 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   110 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   120 */  1461, 1461, 1535, 1461, 1533, 1878, 1878, 1878, 1461, 1461,
 /*   130 */  1461, 1461, 1732, 1732, 1461, 1461, 1461, 1461, 1633, 1461,
 /*   140 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1726, 1461, 1947,
 /*   150 */  1461, 1461, 1461, 1901, 1461, 1461, 1461, 1461, 1586, 1893,
 /*   160 */  1870, 1884, 1871, 1868, 1932, 1932, 1932, 1887, 1461, 1897,
 /*   170 */  1461, 1719, 1696, 1461, 1461, 1696, 1693, 1693, 1461, 1461,
 /*   180 */  1461, 1461, 1461, 1461, 1535, 1461, 1535, 1461, 1461, 1535,
 /*   190 */  1461, 1535, 1535, 1535, 1461, 1535, 1461, 1461, 1461, 1461,
 /*   200 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   210 */  1461, 1461, 1533, 1728, 1461, 1533, 1461, 1461, 1461, 1533,
 /*   220 */  1906, 1461, 1461, 1461, 1461, 1906, 1461, 1461, 1533, 1461,
 /*   230 */  1533, 1461, 1461, 1461, 1908, 1906, 1461, 1461, 1908, 1906,
 /*   240 */  1461, 1461, 1461, 1920, 1916, 1908, 1924, 1922, 1899, 1897,
 /*   250 */  1884, 1461, 1461, 1938, 1934, 1950, 1938, 1934, 1938, 1934,
 /*   260 */  1461, 1602, 1461, 1461, 1461, 1533, 1493, 1461, 1721, 1732,
 /*   270 */  1636, 1636, 1636, 1536, 1466, 1461, 1461, 1461, 1461, 1461,
 /*   280 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1803, 1919, 1918,
 /*   290 */  1842, 1841, 1840, 1838, 1802, 1461, 1598, 1801, 1800, 1461,
 /*   300 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1794, 1795,
 /*   310 */  1793, 1792, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   320 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   330 */  1867, 1461, 1935, 1939, 1461, 1461, 1461, 1461, 1461, 1778,
 /*   340 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   350 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   360 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   370 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   380 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   390 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   400 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   410 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   420 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   430 */  1461, 1461, 1461, 1461, 1498, 1461, 1461, 1461, 1461, 1461,
 /*   440 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   450 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   460 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   470 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1570, 1569,
 /*   480 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   490 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   500 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   510 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1736, 1461, 1461,
 /*   520 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1900, 1461, 1461,
 /*   530 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   540 */  1461, 1461, 1461, 1778, 1461, 1917, 1461, 1877, 1873, 1461,
 /*   550 */  1461, 1869, 1777, 1461, 1461, 1933, 1461, 1461, 1461, 1461,
 /*   560 */  1461, 1461, 1461, 1461, 1461, 1862, 1461, 1461, 1835, 1820,
 /*   570 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   580 */  1788, 1461, 1461, 1461, 1461, 1461, 1630, 1461, 1461, 1461,
 /*   590 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1615,
 /*   600 */  1613, 1612, 1611, 1461, 1608, 1461, 1461, 1461, 1461, 1639,
 /*   610 */  1638, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   620 */  1461, 1461, 1461, 1554, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   630 */  1461, 1461, 1546, 1461, 1545, 1461, 1461, 1461, 1461, 1461,
 /*   640 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   650 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*   660 */  1461, 1461, 1461, 1461, 1461, 1461, 1461,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  251,  /*      AFTER => ABORT */
  251,  /*     ATTACH => ABORT */
  251,  /*     BEFORE => ABORT */
  251,  /*      BEGIN => ABORT */
  251,  /*     BITAND => ABORT */
  251,  /*     BITNOT => ABORT */
  251,  /*      BITOR => ABORT */
  251,  /*     BLOCKS => ABORT */
  251,  /*     CHANGE => ABORT */
  251,  /*      COMMA => ABORT */
  251,  /*    COMPACT => ABORT */
  251,  /*     CONCAT => ABORT */
  251,  /*   CONFLICT => ABORT */
  251,  /*       COPY => ABORT */
  251,  /*   DEFERRED => ABORT */
  251,  /* DELIMITERS => ABORT */
  251,  /*     DETACH => ABORT */
  251,  /*     DIVIDE => ABORT */
  251,  /*        DOT => ABORT */
  251,  /*       EACH => ABORT */
  251,  /*        END => ABORT */
  251,  /*       FAIL => ABORT */
  251,  /*       FILE => ABORT */
  251,  /*        FOR => ABORT */
  251,  /*       GLOB => ABORT */
  251,  /*         ID => ABORT */
  251,  /*  IMMEDIATE => ABORT */
  251,  /*     IMPORT => ABORT */
  251,  /*  INITIALLY => ABORT */
  251,  /*    INSTEAD => ABORT */
  251,  /*     ISNULL => ABORT */
  251,  /*        KEY => ABORT */
  251,  /*  NK_BITNOT => ABORT */
  251,  /*    NK_SEMI => ABORT */
  251,  /*    NOTNULL => ABORT */
  251,  /*         OF => ABORT */
  251,  /*       PLUS => ABORT */
  251,  /*  PRIVILEGE => ABORT */
  251,  /*      RAISE => ABORT */
  251,  /*    REPLACE => ABORT */
  251,  /*   RESTRICT => ABORT */
  251,  /*        ROW => ABORT */
  251,  /*       SEMI => ABORT */
  251,  /*       STAR => ABORT */
  251,  /*  STATEMENT => ABORT */
  251,  /*     STRING => ABORT */
  251,  /*      TIMES => ABORT */
  251,  /*     UPDATE => ABORT */
  251,  /*     VALUES => ABORT */
  251,  /*   VARIABLE => ABORT */
  251,  /*       VIEW => ABORT */
  251,  /*     VNODES => ABORT */
  251,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "MAXROWS",
  /*   70 */ "MINROWS",
  /*   71 */ "KEEP",
  /*   72 */ "PAGES",
  /*   73 */ "PAGESIZE",
  /*   74 */ "PRECISION",
  /*   75 */ "REPLICA",
  /*   76 */ "STRICT",
  /*   77 */ "VGROUPS",
  /*   78 */ "SINGLE_STABLE",
  /*   79 */ "RETENTIONS",
  /*   80 */ "SCHEMALESS",
  /*   81 */ "WAL_LEVEL",
  /*   82 */ "WAL_FSYNC_PERIOD",
  /*   83 */ "WAL_RETENTION_PERIOD",
  /*   84 */ "WAL_RETENTION_SIZE",
  /*   85 */ "WAL_ROLL_PERIOD",
  /*   86 */ "WAL_SEGMENT_SIZE",
  /*   87 */ "NK_COLON",
  /*   88 */ "TABLE",
  /*   89 */ "NK_LP",
  /*   90 */ "NK_RP",
  /*   91 */ "STABLE",
  /*   92 */ "ADD",
  /*   93 */ "COLUMN",
  /*   94 */ "MODIFY",
  /*   95 */ "RENAME",
  /*   96 */ "TAG",
  /*   97 */ "SET",
  /*   98 */ "NK_EQ",
  /*   99 */ "USING",
  /*  100 */ "TAGS",
  /*  101 */ "COMMENT",
  /*  102 */ "BOOL",
  /*  103 */ "TINYINT",
  /*  104 */ "SMALLINT",
  /*  105 */ "INT",
  /*  106 */ "INTEGER",
  /*  107 */ "BIGINT",
  /*  108 */ "FLOAT",
  /*  109 */ "DOUBLE",
  /*  110 */ "BINARY",
  /*  111 */ "TIMESTAMP",
  /*  112 */ "NCHAR",
  /*  113 */ "UNSIGNED",
  /*  114 */ "JSON",
  /*  115 */ "VARCHAR",
  /*  116 */ "MEDIUMBLOB",
  /*  117 */ "BLOB",
  /*  118 */ "VARBINARY",
  /*  119 */ "DECIMAL",
  /*  120 */ "MAX_DELAY",
  /*  121 */ "WATERMARK",
  /*  122 */ "ROLLUP",
  /*  123 */ "TTL",
  /*  124 */ "SMA",
  /*  125 */ "FIRST",
  /*  126 */ "LAST",
  /*  127 */ "SHOW",
  /*  128 */ "DATABASES",
  /*  129 */ "TABLES",
  /*  130 */ "STABLES",
  /*  131 */ "MNODES",
  /*  132 */ "MODULES",
  /*  133 */ "QNODES",
  /*  134 */ "FUNCTIONS",
  /*  135 */ "INDEXES",
  /*  136 */ "ACCOUNTS",
  /*  137 */ "APPS",
  /*  138 */ "CONNECTIONS",
  /*  139 */ "LICENCES",
  /*  140 */ "GRANTS",
  /*  141 */ "QUERIES",
  /*  142 */ "SCORES",
  /*  143 */ "TOPICS",
  /*  144 */ "VARIABLES",
  /*  145 */ "BNODES",
  /*  146 */ "SNODES",
  /*  147 */ "CLUSTER",
  /*  148 */ "TRANSACTIONS",
  /*  149 */ "DISTRIBUTED",
  /*  150 */ "CONSUMERS",
  /*  151 */ "SUBSCRIPTIONS",
  /*  152 */ "LIKE",
  /*  153 */ "INDEX",
  /*  154 */ "FUNCTION",
  /*  155 */ "INTERVAL",
  /*  156 */ "TOPIC",
  /*  157 */ "AS",
  /*  158 */ "WITH",
  /*  159 */ "META",
  /*  160 */ "CONSUMER",
  /*  161 */ "GROUP",
  /*  162 */ "DESC",
  /*  163 */ "DESCRIBE",
  /*  164 */ "RESET",
  /*  165 */ "QUERY",
  /*  166 */ "CACHE",
  /*  167 */ "EXPLAIN",
  /*  168 */ "ANALYZE",
  /*  169 */ "VERBOSE",
  /*  170 */ "NK_BOOL",
  /*  171 */ "RATIO",
  /*  172 */ "NK_FLOAT",
  /*  173 */ "OUTPUTTYPE",
  /*  174 */ "AGGREGATE",
  /*  175 */ "BUFSIZE",
  /*  176 */ "STREAM",
  /*  177 */ "INTO",
  /*  178 */ "TRIGGER",
  /*  179 */ "AT_ONCE",
  /*  180 */ "WINDOW_CLOSE",
  /*  181 */ "IGNORE",
  /*  182 */ "EXPIRED",
  /*  183 */ "KILL",
  /*  184 */ "CONNECTION",
  /*  185 */ "TRANSACTION",
  /*  186 */ "BALANCE",
  /*  187 */ "VGROUP",
  /*  188 */ "MERGE",
  /*  189 */ "REDISTRIBUTE",
  /*  190 */ "SPLIT",
  /*  191 */ "DELETE",
  /*  192 */ "INSERT",
  /*  193 */ "NULL",
  /*  194 */ "NK_QUESTION",
  /*  195 */ "NK_ARROW",
  /*  196 */ "ROWTS",
  /*  197 */ "TBNAME",
  /*  198 */ "QSTART",
  /*  199 */ "QEND",
  /*  200 */ "QDURATION",
  /*  201 */ "WSTART",
  /*  202 */ "WEND",
  /*  203 */ "WDURATION",
  /*  204 */ "CAST",
  /*  205 */ "NOW",
  /*  206 */ "TODAY",
  /*  207 */ "TIMEZONE",
  /*  208 */ "CLIENT_VERSION",
  /*  209 */ "SERVER_VERSION",
  /*  210 */ "SERVER_STATUS",
  /*  211 */ "CURRENT_USER",
  /*  212 */ "COUNT",
  /*  213 */ "LAST_ROW",
  /*  214 */ "BETWEEN",
  /*  215 */ "IS",
  /*  216 */ "NK_LT",
  /*  217 */ "NK_GT",
  /*  218 */ "NK_LE",
  /*  219 */ "NK_GE",
  /*  220 */ "NK_NE",
  /*  221 */ "MATCH",
  /*  222 */ "NMATCH",
  /*  223 */ "CONTAINS",
  /*  224 */ "IN",
  /*  225 */ "JOIN",
  /*  226 */ "INNER",
  /*  227 */ "SELECT",
  /*  228 */ "DISTINCT",
  /*  229 */ "WHERE",
  /*  230 */ "PARTITION",
  /*  231 */ "BY",
  /*  232 */ "SESSION",
  /*  233 */ "STATE_WINDOW",
  /*  234 */ "SLIDING",
  /*  235 */ "FILL",
  /*  236 */ "VALUE",
  /*  237 */ "NONE",
  /*  238 */ "PREV",
  /*  239 */ "LINEAR",
  /*  240 */ "NEXT",
  /*  241 */ "HAVING",
  /*  242 */ "RANGE",
  /*  243 */ "EVERY",
  /*  244 */ "ORDER",
  /*  245 */ "SLIMIT",
  /*  246 */ "SOFFSET",
  /*  247 */ "LIMIT",
  /*  248 */ "OFFSET",
  /*  249 */ "ASC",
  /*  250 */ "NULLS",
  /*  251 */ "ABORT",
  /*  252 */ "AFTER",
  /*  253 */ "ATTACH",
  /*  254 */ "BEFORE",
  /*  255 */ "BEGIN",
  /*  256 */ "BITAND",
  /*  257 */ "BITNOT",
  /*  258 */ "BITOR",
  /*  259 */ "BLOCKS",
  /*  260 */ "CHANGE",
  /*  261 */ "COMMA",
  /*  262 */ "COMPACT",
  /*  263 */ "CONCAT",
  /*  264 */ "CONFLICT",
  /*  265 */ "COPY",
  /*  266 */ "DEFERRED",
  /*  267 */ "DELIMITERS",
  /*  268 */ "DETACH",
  /*  269 */ "DIVIDE",
  /*  270 */ "DOT",
  /*  271 */ "EACH",
  /*  272 */ "END",
  /*  273 */ "FAIL",
  /*  274 */ "FILE",
  /*  275 */ "FOR",
  /*  276 */ "GLOB",
  /*  277 */ "ID",
  /*  278 */ "IMMEDIATE",
  /*  279 */ "IMPORT",
  /*  280 */ "INITIALLY",
  /*  281 */ "INSTEAD",
  /*  282 */ "ISNULL",
  /*  283 */ "KEY",
  /*  284 */ "NK_BITNOT",
  /*  285 */ "NK_SEMI",
  /*  286 */ "NOTNULL",
  /*  287 */ "OF",
  /*  288 */ "PLUS",
  /*  289 */ "PRIVILEGE",
  /*  290 */ "RAISE",
  /*  291 */ "REPLACE",
  /*  292 */ "RESTRICT",
  /*  293 */ "ROW",
  /*  294 */ "SEMI",
  /*  295 */ "STAR",
  /*  296 */ "STATEMENT",
  /*  297 */ "STRING",
  /*  298 */ "TIMES",
  /*  299 */ "UPDATE",
  /*  300 */ "VALUES",
  /*  301 */ "VARIABLE",
  /*  302 */ "VIEW",
  /*  303 */ "VNODES",
  /*  304 */ "WAL",
  /*  305 */ "cmd",
  /*  306 */ "account_options",
  /*  307 */ "alter_account_options",
  /*  308 */ "literal",
  /*  309 */ "alter_account_option",
  /*  310 */ "user_name",
  /*  311 */ "sysinfo_opt",
  /*  312 */ "privileges",
  /*  313 */ "priv_level",
  /*  314 */ "priv_type_list",
  /*  315 */ "priv_type",
  /*  316 */ "db_name",
  /*  317 */ "dnode_endpoint",
  /*  318 */ "not_exists_opt",
  /*  319 */ "db_options",
  /*  320 */ "exists_opt",
  /*  321 */ "alter_db_options",
  /*  322 */ "integer_list",
  /*  323 */ "variable_list",
  /*  324 */ "retention_list",
  /*  325 */ "alter_db_option",
  /*  326 */ "retention",
  /*  327 */ "full_table_name",
  /*  328 */ "column_def_list",
  /*  329 */ "tags_def_opt",
  /*  330 */ "table_options",
  /*  331 */ "multi_create_clause",
  /*  332 */ "tags_def",
  /*  333 */ "multi_drop_clause",
  /*  334 */ "alter_table_clause",
  /*  335 */ "alter_table_options",
  /*  336 */ "column_name",
  /*  337 */ "type_name",
  /*  338 */ "signed_literal",
  /*  339 */ "create_subtable_clause",
  /*  340 */ "specific_cols_opt",
  /*  341 */ "expression_list",
  /*  342 */ "drop_table_clause",
  /*  343 */ "col_name_list",
  /*  344 */ "table_name",
  /*  345 */ "column_def",
  /*  346 */ "duration_list",
  /*  347 */ "rollup_func_list",
  /*  348 */ "alter_table_option",
  /*  349 */ "duration_literal",
  /*  350 */ "rollup_func_name",
  /*  351 */ "function_name",
  /*  352 */ "col_name",
  /*  353 */ "db_name_cond_opt",
  /*  354 */ "like_pattern_opt",
  /*  355 */ "table_name_cond",
  /*  356 */ "from_db_opt",
  /*  357 */ "index_options",
  /*  358 */ "func_list",
  /*  359 */ "sliding_opt",
  /*  360 */ "sma_stream_opt",
  /*  361 */ "func",
  /*  362 */ "stream_options",
  /*  363 */ "topic_name",
  /*  364 */ "query_expression",
  /*  365 */ "cgroup_name",
  /*  366 */ "analyze_opt",
  /*  367 */ "explain_options",
  /*  368 */ "agg_func_opt",
  /*  369 */ "bufsize_opt",
  /*  370 */ "stream_name",
  /*  371 */ "dnode_list",
  /*  372 */ "where_clause_opt",
  /*  373 */ "signed",
  /*  374 */ "literal_func",
  /*  375 */ "literal_list",
  /*  376 */ "table_alias",
  /*  377 */ "column_alias",
  /*  378 */ "expression",
  /*  379 */ "pseudo_column",
  /*  380 */ "column_reference",
  /*  381 */ "function_expression",
  /*  382 */ "subquery",
  /*  383 */ "star_func",
  /*  384 */ "star_func_para_list",
  /*  385 */ "noarg_func",
  /*  386 */ "other_para_list",
  /*  387 */ "star_func_para",
  /*  388 */ "predicate",
  /*  389 */ "compare_op",
  /*  390 */ "in_op",
  /*  391 */ "in_predicate_value",
  /*  392 */ "boolean_value_expression",
  /*  393 */ "boolean_primary",
  /*  394 */ "common_expression",
  /*  395 */ "from_clause_opt",
  /*  396 */ "table_reference_list",
  /*  397 */ "table_reference",
  /*  398 */ "table_primary",
  /*  399 */ "joined_table",
  /*  400 */ "alias_opt",
  /*  401 */ "parenthesized_joined_table",
  /*  402 */ "join_type",
  /*  403 */ "search_condition",
  /*  404 */ "query_specification",
  /*  405 */ "set_quantifier_opt",
  /*  406 */ "select_list",
  /*  407 */ "partition_by_clause_opt",
  /*  408 */ "range_opt",
  /*  409 */ "every_opt",
  /*  410 */ "fill_opt",
  /*  411 */ "twindow_clause_opt",
  /*  412 */ "group_by_clause_opt",
  /*  413 */ "having_clause_opt",
  /*  414 */ "select_item",
  /*  415 */ "fill_mode",
  /*  416 */ "group_by_list",
  /*  417 */ "query_expression_body",
  /*  418 */ "order_by_clause_opt",
  /*  419 */ "slimit_clause_opt",
  /*  420 */ "limit_clause_opt",
  /*  421 */ "query_primary",
  /*  422 */ "sort_specification_list",
  /*  423 */ "sort_specification",
  /*  424 */ "ordering_specification_opt",
  /*  425 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options KEEP integer_list",
 /*  82 */ "db_options ::= db_options KEEP variable_list",
 /*  83 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  84 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  85 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  86 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  87 */ "db_options ::= db_options STRICT NK_STRING",
 /*  88 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  89 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  90 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  91 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  92 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  93 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  94 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 100 */ "alter_db_options ::= alter_db_option",
 /* 101 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 102 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 103 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 104 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 105 */ "alter_db_option ::= KEEP integer_list",
 /* 106 */ "alter_db_option ::= KEEP variable_list",
 /* 107 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 108 */ "integer_list ::= NK_INTEGER",
 /* 109 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 110 */ "variable_list ::= NK_VARIABLE",
 /* 111 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 112 */ "retention_list ::= retention",
 /* 113 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 114 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 115 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 116 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 117 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 118 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 119 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 120 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 121 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 122 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 123 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 124 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 125 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 126 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 127 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 128 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 129 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 130 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 131 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 132 */ "multi_create_clause ::= create_subtable_clause",
 /* 133 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 134 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 135 */ "multi_drop_clause ::= drop_table_clause",
 /* 136 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 137 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 138 */ "specific_cols_opt ::=",
 /* 139 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 140 */ "full_table_name ::= table_name",
 /* 141 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 142 */ "column_def_list ::= column_def",
 /* 143 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 144 */ "column_def ::= column_name type_name",
 /* 145 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 146 */ "type_name ::= BOOL",
 /* 147 */ "type_name ::= TINYINT",
 /* 148 */ "type_name ::= SMALLINT",
 /* 149 */ "type_name ::= INT",
 /* 150 */ "type_name ::= INTEGER",
 /* 151 */ "type_name ::= BIGINT",
 /* 152 */ "type_name ::= FLOAT",
 /* 153 */ "type_name ::= DOUBLE",
 /* 154 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 155 */ "type_name ::= TIMESTAMP",
 /* 156 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= TINYINT UNSIGNED",
 /* 158 */ "type_name ::= SMALLINT UNSIGNED",
 /* 159 */ "type_name ::= INT UNSIGNED",
 /* 160 */ "type_name ::= BIGINT UNSIGNED",
 /* 161 */ "type_name ::= JSON",
 /* 162 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 163 */ "type_name ::= MEDIUMBLOB",
 /* 164 */ "type_name ::= BLOB",
 /* 165 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 166 */ "type_name ::= DECIMAL",
 /* 167 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 169 */ "tags_def_opt ::=",
 /* 170 */ "tags_def_opt ::= tags_def",
 /* 171 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 172 */ "table_options ::=",
 /* 173 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 174 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 175 */ "table_options ::= table_options WATERMARK duration_list",
 /* 176 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 177 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 178 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 179 */ "alter_table_options ::= alter_table_option",
 /* 180 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 181 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 182 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 183 */ "duration_list ::= duration_literal",
 /* 184 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 185 */ "rollup_func_list ::= rollup_func_name",
 /* 186 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 187 */ "rollup_func_name ::= function_name",
 /* 188 */ "rollup_func_name ::= FIRST",
 /* 189 */ "rollup_func_name ::= LAST",
 /* 190 */ "col_name_list ::= col_name",
 /* 191 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 192 */ "col_name ::= column_name",
 /* 193 */ "cmd ::= SHOW DNODES",
 /* 194 */ "cmd ::= SHOW USERS",
 /* 195 */ "cmd ::= SHOW DATABASES",
 /* 196 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 197 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 198 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 199 */ "cmd ::= SHOW MNODES",
 /* 200 */ "cmd ::= SHOW MODULES",
 /* 201 */ "cmd ::= SHOW QNODES",
 /* 202 */ "cmd ::= SHOW FUNCTIONS",
 /* 203 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 204 */ "cmd ::= SHOW STREAMS",
 /* 205 */ "cmd ::= SHOW ACCOUNTS",
 /* 206 */ "cmd ::= SHOW APPS",
 /* 207 */ "cmd ::= SHOW CONNECTIONS",
 /* 208 */ "cmd ::= SHOW LICENCES",
 /* 209 */ "cmd ::= SHOW GRANTS",
 /* 210 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 211 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 212 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 213 */ "cmd ::= SHOW QUERIES",
 /* 214 */ "cmd ::= SHOW SCORES",
 /* 215 */ "cmd ::= SHOW TOPICS",
 /* 216 */ "cmd ::= SHOW VARIABLES",
 /* 217 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 218 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 219 */ "cmd ::= SHOW BNODES",
 /* 220 */ "cmd ::= SHOW SNODES",
 /* 221 */ "cmd ::= SHOW CLUSTER",
 /* 222 */ "cmd ::= SHOW TRANSACTIONS",
 /* 223 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 224 */ "cmd ::= SHOW CONSUMERS",
 /* 225 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 226 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 227 */ "db_name_cond_opt ::=",
 /* 228 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 229 */ "like_pattern_opt ::=",
 /* 230 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 231 */ "table_name_cond ::= table_name",
 /* 232 */ "from_db_opt ::=",
 /* 233 */ "from_db_opt ::= FROM db_name",
 /* 234 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 235 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 236 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 237 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 238 */ "func_list ::= func",
 /* 239 */ "func_list ::= func_list NK_COMMA func",
 /* 240 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 241 */ "sma_stream_opt ::=",
 /* 242 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 243 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 244 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 245 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 246 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 247 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 248 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 249 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 250 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 251 */ "cmd ::= DESC full_table_name",
 /* 252 */ "cmd ::= DESCRIBE full_table_name",
 /* 253 */ "cmd ::= RESET QUERY CACHE",
 /* 254 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 255 */ "analyze_opt ::=",
 /* 256 */ "analyze_opt ::= ANALYZE",
 /* 257 */ "explain_options ::=",
 /* 258 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 259 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 260 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 261 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 262 */ "agg_func_opt ::=",
 /* 263 */ "agg_func_opt ::= AGGREGATE",
 /* 264 */ "bufsize_opt ::=",
 /* 265 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 266 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name AS query_expression",
 /* 267 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 268 */ "stream_options ::=",
 /* 269 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 270 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 271 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 272 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 273 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 274 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 275 */ "cmd ::= KILL QUERY NK_STRING",
 /* 276 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 277 */ "cmd ::= BALANCE VGROUP",
 /* 278 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 279 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 280 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 281 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 282 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 283 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 284 */ "cmd ::= query_expression",
 /* 285 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression",
 /* 286 */ "cmd ::= INSERT INTO full_table_name query_expression",
 /* 287 */ "literal ::= NK_INTEGER",
 /* 288 */ "literal ::= NK_FLOAT",
 /* 289 */ "literal ::= NK_STRING",
 /* 290 */ "literal ::= NK_BOOL",
 /* 291 */ "literal ::= TIMESTAMP NK_STRING",
 /* 292 */ "literal ::= duration_literal",
 /* 293 */ "literal ::= NULL",
 /* 294 */ "literal ::= NK_QUESTION",
 /* 295 */ "duration_literal ::= NK_VARIABLE",
 /* 296 */ "signed ::= NK_INTEGER",
 /* 297 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 298 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 299 */ "signed ::= NK_FLOAT",
 /* 300 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 301 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 302 */ "signed_literal ::= signed",
 /* 303 */ "signed_literal ::= NK_STRING",
 /* 304 */ "signed_literal ::= NK_BOOL",
 /* 305 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 306 */ "signed_literal ::= duration_literal",
 /* 307 */ "signed_literal ::= NULL",
 /* 308 */ "signed_literal ::= literal_func",
 /* 309 */ "signed_literal ::= NK_QUESTION",
 /* 310 */ "literal_list ::= signed_literal",
 /* 311 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 312 */ "db_name ::= NK_ID",
 /* 313 */ "table_name ::= NK_ID",
 /* 314 */ "column_name ::= NK_ID",
 /* 315 */ "function_name ::= NK_ID",
 /* 316 */ "table_alias ::= NK_ID",
 /* 317 */ "column_alias ::= NK_ID",
 /* 318 */ "user_name ::= NK_ID",
 /* 319 */ "topic_name ::= NK_ID",
 /* 320 */ "stream_name ::= NK_ID",
 /* 321 */ "cgroup_name ::= NK_ID",
 /* 322 */ "expression ::= literal",
 /* 323 */ "expression ::= pseudo_column",
 /* 324 */ "expression ::= column_reference",
 /* 325 */ "expression ::= function_expression",
 /* 326 */ "expression ::= subquery",
 /* 327 */ "expression ::= NK_LP expression NK_RP",
 /* 328 */ "expression ::= NK_PLUS expression",
 /* 329 */ "expression ::= NK_MINUS expression",
 /* 330 */ "expression ::= expression NK_PLUS expression",
 /* 331 */ "expression ::= expression NK_MINUS expression",
 /* 332 */ "expression ::= expression NK_STAR expression",
 /* 333 */ "expression ::= expression NK_SLASH expression",
 /* 334 */ "expression ::= expression NK_REM expression",
 /* 335 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 336 */ "expression ::= expression NK_BITAND expression",
 /* 337 */ "expression ::= expression NK_BITOR expression",
 /* 338 */ "expression_list ::= expression",
 /* 339 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 340 */ "column_reference ::= column_name",
 /* 341 */ "column_reference ::= table_name NK_DOT column_name",
 /* 342 */ "pseudo_column ::= ROWTS",
 /* 343 */ "pseudo_column ::= TBNAME",
 /* 344 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 345 */ "pseudo_column ::= QSTART",
 /* 346 */ "pseudo_column ::= QEND",
 /* 347 */ "pseudo_column ::= QDURATION",
 /* 348 */ "pseudo_column ::= WSTART",
 /* 349 */ "pseudo_column ::= WEND",
 /* 350 */ "pseudo_column ::= WDURATION",
 /* 351 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 352 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 353 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 354 */ "function_expression ::= literal_func",
 /* 355 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 356 */ "literal_func ::= NOW",
 /* 357 */ "noarg_func ::= NOW",
 /* 358 */ "noarg_func ::= TODAY",
 /* 359 */ "noarg_func ::= TIMEZONE",
 /* 360 */ "noarg_func ::= DATABASE",
 /* 361 */ "noarg_func ::= CLIENT_VERSION",
 /* 362 */ "noarg_func ::= SERVER_VERSION",
 /* 363 */ "noarg_func ::= SERVER_STATUS",
 /* 364 */ "noarg_func ::= CURRENT_USER",
 /* 365 */ "noarg_func ::= USER",
 /* 366 */ "star_func ::= COUNT",
 /* 367 */ "star_func ::= FIRST",
 /* 368 */ "star_func ::= LAST",
 /* 369 */ "star_func ::= LAST_ROW",
 /* 370 */ "star_func_para_list ::= NK_STAR",
 /* 371 */ "star_func_para_list ::= other_para_list",
 /* 372 */ "other_para_list ::= star_func_para",
 /* 373 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 374 */ "star_func_para ::= expression",
 /* 375 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 376 */ "predicate ::= expression compare_op expression",
 /* 377 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 378 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 379 */ "predicate ::= expression IS NULL",
 /* 380 */ "predicate ::= expression IS NOT NULL",
 /* 381 */ "predicate ::= expression in_op in_predicate_value",
 /* 382 */ "compare_op ::= NK_LT",
 /* 383 */ "compare_op ::= NK_GT",
 /* 384 */ "compare_op ::= NK_LE",
 /* 385 */ "compare_op ::= NK_GE",
 /* 386 */ "compare_op ::= NK_NE",
 /* 387 */ "compare_op ::= NK_EQ",
 /* 388 */ "compare_op ::= LIKE",
 /* 389 */ "compare_op ::= NOT LIKE",
 /* 390 */ "compare_op ::= MATCH",
 /* 391 */ "compare_op ::= NMATCH",
 /* 392 */ "compare_op ::= CONTAINS",
 /* 393 */ "in_op ::= IN",
 /* 394 */ "in_op ::= NOT IN",
 /* 395 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 396 */ "boolean_value_expression ::= boolean_primary",
 /* 397 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 398 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 399 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 400 */ "boolean_primary ::= predicate",
 /* 401 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 402 */ "common_expression ::= expression",
 /* 403 */ "common_expression ::= boolean_value_expression",
 /* 404 */ "from_clause_opt ::=",
 /* 405 */ "from_clause_opt ::= FROM table_reference_list",
 /* 406 */ "table_reference_list ::= table_reference",
 /* 407 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 408 */ "table_reference ::= table_primary",
 /* 409 */ "table_reference ::= joined_table",
 /* 410 */ "table_primary ::= table_name alias_opt",
 /* 411 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 412 */ "table_primary ::= subquery alias_opt",
 /* 413 */ "table_primary ::= parenthesized_joined_table",
 /* 414 */ "alias_opt ::=",
 /* 415 */ "alias_opt ::= table_alias",
 /* 416 */ "alias_opt ::= AS table_alias",
 /* 417 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 418 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 419 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 420 */ "join_type ::=",
 /* 421 */ "join_type ::= INNER",
 /* 422 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 423 */ "set_quantifier_opt ::=",
 /* 424 */ "set_quantifier_opt ::= DISTINCT",
 /* 425 */ "set_quantifier_opt ::= ALL",
 /* 426 */ "select_list ::= select_item",
 /* 427 */ "select_list ::= select_list NK_COMMA select_item",
 /* 428 */ "select_item ::= NK_STAR",
 /* 429 */ "select_item ::= common_expression",
 /* 430 */ "select_item ::= common_expression column_alias",
 /* 431 */ "select_item ::= common_expression AS column_alias",
 /* 432 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 433 */ "where_clause_opt ::=",
 /* 434 */ "where_clause_opt ::= WHERE search_condition",
 /* 435 */ "partition_by_clause_opt ::=",
 /* 436 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 437 */ "twindow_clause_opt ::=",
 /* 438 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 439 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 440 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 441 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 442 */ "sliding_opt ::=",
 /* 443 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 444 */ "fill_opt ::=",
 /* 445 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 446 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 447 */ "fill_mode ::= NONE",
 /* 448 */ "fill_mode ::= PREV",
 /* 449 */ "fill_mode ::= NULL",
 /* 450 */ "fill_mode ::= LINEAR",
 /* 451 */ "fill_mode ::= NEXT",
 /* 452 */ "group_by_clause_opt ::=",
 /* 453 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 454 */ "group_by_list ::= expression",
 /* 455 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 456 */ "having_clause_opt ::=",
 /* 457 */ "having_clause_opt ::= HAVING search_condition",
 /* 458 */ "range_opt ::=",
 /* 459 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 460 */ "every_opt ::=",
 /* 461 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 462 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 463 */ "query_expression_body ::= query_primary",
 /* 464 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 465 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 466 */ "query_primary ::= query_specification",
 /* 467 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 468 */ "order_by_clause_opt ::=",
 /* 469 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 470 */ "slimit_clause_opt ::=",
 /* 471 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 472 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 473 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 474 */ "limit_clause_opt ::=",
 /* 475 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 476 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 477 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 478 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 479 */ "search_condition ::= common_expression",
 /* 480 */ "sort_specification_list ::= sort_specification",
 /* 481 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 482 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 483 */ "ordering_specification_opt ::=",
 /* 484 */ "ordering_specification_opt ::= ASC",
 /* 485 */ "ordering_specification_opt ::= DESC",
 /* 486 */ "null_ordering_opt ::=",
 /* 487 */ "null_ordering_opt ::= NULLS FIRST",
 /* 488 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 305: /* cmd */
    case 308: /* literal */
    case 319: /* db_options */
    case 321: /* alter_db_options */
    case 326: /* retention */
    case 327: /* full_table_name */
    case 330: /* table_options */
    case 334: /* alter_table_clause */
    case 335: /* alter_table_options */
    case 338: /* signed_literal */
    case 339: /* create_subtable_clause */
    case 342: /* drop_table_clause */
    case 345: /* column_def */
    case 349: /* duration_literal */
    case 350: /* rollup_func_name */
    case 352: /* col_name */
    case 353: /* db_name_cond_opt */
    case 354: /* like_pattern_opt */
    case 355: /* table_name_cond */
    case 356: /* from_db_opt */
    case 357: /* index_options */
    case 359: /* sliding_opt */
    case 360: /* sma_stream_opt */
    case 361: /* func */
    case 362: /* stream_options */
    case 364: /* query_expression */
    case 367: /* explain_options */
    case 372: /* where_clause_opt */
    case 373: /* signed */
    case 374: /* literal_func */
    case 378: /* expression */
    case 379: /* pseudo_column */
    case 380: /* column_reference */
    case 381: /* function_expression */
    case 382: /* subquery */
    case 387: /* star_func_para */
    case 388: /* predicate */
    case 391: /* in_predicate_value */
    case 392: /* boolean_value_expression */
    case 393: /* boolean_primary */
    case 394: /* common_expression */
    case 395: /* from_clause_opt */
    case 396: /* table_reference_list */
    case 397: /* table_reference */
    case 398: /* table_primary */
    case 399: /* joined_table */
    case 401: /* parenthesized_joined_table */
    case 403: /* search_condition */
    case 404: /* query_specification */
    case 408: /* range_opt */
    case 409: /* every_opt */
    case 410: /* fill_opt */
    case 411: /* twindow_clause_opt */
    case 413: /* having_clause_opt */
    case 414: /* select_item */
    case 417: /* query_expression_body */
    case 419: /* slimit_clause_opt */
    case 420: /* limit_clause_opt */
    case 421: /* query_primary */
    case 423: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy272)); 
}
      break;
    case 306: /* account_options */
    case 307: /* alter_account_options */
    case 309: /* alter_account_option */
    case 369: /* bufsize_opt */
{
 
}
      break;
    case 310: /* user_name */
    case 313: /* priv_level */
    case 316: /* db_name */
    case 317: /* dnode_endpoint */
    case 336: /* column_name */
    case 344: /* table_name */
    case 351: /* function_name */
    case 363: /* topic_name */
    case 365: /* cgroup_name */
    case 370: /* stream_name */
    case 376: /* table_alias */
    case 377: /* column_alias */
    case 383: /* star_func */
    case 385: /* noarg_func */
    case 400: /* alias_opt */
{
 
}
      break;
    case 311: /* sysinfo_opt */
{
 
}
      break;
    case 312: /* privileges */
    case 314: /* priv_type_list */
    case 315: /* priv_type */
{
 
}
      break;
    case 318: /* not_exists_opt */
    case 320: /* exists_opt */
    case 366: /* analyze_opt */
    case 368: /* agg_func_opt */
    case 405: /* set_quantifier_opt */
{
 
}
      break;
    case 322: /* integer_list */
    case 323: /* variable_list */
    case 324: /* retention_list */
    case 328: /* column_def_list */
    case 329: /* tags_def_opt */
    case 331: /* multi_create_clause */
    case 332: /* tags_def */
    case 333: /* multi_drop_clause */
    case 340: /* specific_cols_opt */
    case 341: /* expression_list */
    case 343: /* col_name_list */
    case 346: /* duration_list */
    case 347: /* rollup_func_list */
    case 358: /* func_list */
    case 371: /* dnode_list */
    case 375: /* literal_list */
    case 384: /* star_func_para_list */
    case 386: /* other_para_list */
    case 406: /* select_list */
    case 407: /* partition_by_clause_opt */
    case 412: /* group_by_clause_opt */
    case 416: /* group_by_list */
    case 418: /* order_by_clause_opt */
    case 422: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy172)); 
}
      break;
    case 325: /* alter_db_option */
    case 348: /* alter_table_option */
{
 
}
      break;
    case 337: /* type_name */
{
 
}
      break;
    case 389: /* compare_op */
    case 390: /* in_op */
{
 
}
      break;
    case 402: /* join_type */
{
 
}
      break;
    case 415: /* fill_mode */
{
 
}
      break;
    case 424: /* ordering_specification_opt */
{
 
}
      break;
    case 425: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  305,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  305,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  306,    0 }, /* (2) account_options ::= */
  {  306,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  306,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  306,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  306,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  306,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  306,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  306,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  306,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  306,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  307,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  307,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  309,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  309,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  309,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  309,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  309,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  309,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  309,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  309,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  309,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  309,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  305,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  305,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  305,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  305,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  305,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  311,    0 }, /* (29) sysinfo_opt ::= */
  {  311,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  305,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  305,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  312,   -1 }, /* (33) privileges ::= ALL */
  {  312,   -1 }, /* (34) privileges ::= priv_type_list */
  {  314,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  314,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  315,   -1 }, /* (37) priv_type ::= READ */
  {  315,   -1 }, /* (38) priv_type ::= WRITE */
  {  313,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  313,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  305,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  305,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  305,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  305,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  305,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  305,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  305,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  305,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  317,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  317,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  317,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  305,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  305,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  305,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  305,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  305,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  305,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  305,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  305,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  305,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  305,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  305,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  305,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  305,   -2 }, /* (64) cmd ::= USE db_name */
  {  305,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  305,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  305,   -3 }, /* (67) cmd ::= TRIM DATABASE db_name */
  {  318,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  318,    0 }, /* (69) not_exists_opt ::= */
  {  320,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  320,    0 }, /* (71) exists_opt ::= */
  {  319,    0 }, /* (72) db_options ::= */
  {  319,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  319,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  319,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  319,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  319,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  319,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  319,   -3 }, /* (79) db_options ::= db_options MAXROWS NK_INTEGER */
  {  319,   -3 }, /* (80) db_options ::= db_options MINROWS NK_INTEGER */
  {  319,   -3 }, /* (81) db_options ::= db_options KEEP integer_list */
  {  319,   -3 }, /* (82) db_options ::= db_options KEEP variable_list */
  {  319,   -3 }, /* (83) db_options ::= db_options PAGES NK_INTEGER */
  {  319,   -3 }, /* (84) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  319,   -3 }, /* (85) db_options ::= db_options PRECISION NK_STRING */
  {  319,   -3 }, /* (86) db_options ::= db_options REPLICA NK_INTEGER */
  {  319,   -3 }, /* (87) db_options ::= db_options STRICT NK_STRING */
  {  319,   -3 }, /* (88) db_options ::= db_options VGROUPS NK_INTEGER */
  {  319,   -3 }, /* (89) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  319,   -3 }, /* (90) db_options ::= db_options RETENTIONS retention_list */
  {  319,   -3 }, /* (91) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  319,   -3 }, /* (92) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  319,   -3 }, /* (93) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  319,   -3 }, /* (94) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  319,   -4 }, /* (95) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  319,   -3 }, /* (96) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  319,   -4 }, /* (97) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  319,   -3 }, /* (98) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  319,   -3 }, /* (99) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  321,   -1 }, /* (100) alter_db_options ::= alter_db_option */
  {  321,   -2 }, /* (101) alter_db_options ::= alter_db_options alter_db_option */
  {  325,   -2 }, /* (102) alter_db_option ::= CACHEMODEL NK_STRING */
  {  325,   -2 }, /* (103) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  325,   -2 }, /* (104) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  325,   -2 }, /* (105) alter_db_option ::= KEEP integer_list */
  {  325,   -2 }, /* (106) alter_db_option ::= KEEP variable_list */
  {  325,   -2 }, /* (107) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  322,   -1 }, /* (108) integer_list ::= NK_INTEGER */
  {  322,   -3 }, /* (109) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  323,   -1 }, /* (110) variable_list ::= NK_VARIABLE */
  {  323,   -3 }, /* (111) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  324,   -1 }, /* (112) retention_list ::= retention */
  {  324,   -3 }, /* (113) retention_list ::= retention_list NK_COMMA retention */
  {  326,   -3 }, /* (114) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  305,   -9 }, /* (115) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  305,   -3 }, /* (116) cmd ::= CREATE TABLE multi_create_clause */
  {  305,   -9 }, /* (117) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  305,   -3 }, /* (118) cmd ::= DROP TABLE multi_drop_clause */
  {  305,   -4 }, /* (119) cmd ::= DROP STABLE exists_opt full_table_name */
  {  305,   -3 }, /* (120) cmd ::= ALTER TABLE alter_table_clause */
  {  305,   -3 }, /* (121) cmd ::= ALTER STABLE alter_table_clause */
  {  334,   -2 }, /* (122) alter_table_clause ::= full_table_name alter_table_options */
  {  334,   -5 }, /* (123) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  334,   -4 }, /* (124) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  334,   -5 }, /* (125) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  334,   -5 }, /* (126) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  334,   -5 }, /* (127) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  334,   -4 }, /* (128) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  334,   -5 }, /* (129) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  334,   -5 }, /* (130) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  334,   -6 }, /* (131) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  331,   -1 }, /* (132) multi_create_clause ::= create_subtable_clause */
  {  331,   -2 }, /* (133) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  339,  -10 }, /* (134) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  333,   -1 }, /* (135) multi_drop_clause ::= drop_table_clause */
  {  333,   -2 }, /* (136) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  342,   -2 }, /* (137) drop_table_clause ::= exists_opt full_table_name */
  {  340,    0 }, /* (138) specific_cols_opt ::= */
  {  340,   -3 }, /* (139) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  327,   -1 }, /* (140) full_table_name ::= table_name */
  {  327,   -3 }, /* (141) full_table_name ::= db_name NK_DOT table_name */
  {  328,   -1 }, /* (142) column_def_list ::= column_def */
  {  328,   -3 }, /* (143) column_def_list ::= column_def_list NK_COMMA column_def */
  {  345,   -2 }, /* (144) column_def ::= column_name type_name */
  {  345,   -4 }, /* (145) column_def ::= column_name type_name COMMENT NK_STRING */
  {  337,   -1 }, /* (146) type_name ::= BOOL */
  {  337,   -1 }, /* (147) type_name ::= TINYINT */
  {  337,   -1 }, /* (148) type_name ::= SMALLINT */
  {  337,   -1 }, /* (149) type_name ::= INT */
  {  337,   -1 }, /* (150) type_name ::= INTEGER */
  {  337,   -1 }, /* (151) type_name ::= BIGINT */
  {  337,   -1 }, /* (152) type_name ::= FLOAT */
  {  337,   -1 }, /* (153) type_name ::= DOUBLE */
  {  337,   -4 }, /* (154) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  337,   -1 }, /* (155) type_name ::= TIMESTAMP */
  {  337,   -4 }, /* (156) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  337,   -2 }, /* (157) type_name ::= TINYINT UNSIGNED */
  {  337,   -2 }, /* (158) type_name ::= SMALLINT UNSIGNED */
  {  337,   -2 }, /* (159) type_name ::= INT UNSIGNED */
  {  337,   -2 }, /* (160) type_name ::= BIGINT UNSIGNED */
  {  337,   -1 }, /* (161) type_name ::= JSON */
  {  337,   -4 }, /* (162) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  337,   -1 }, /* (163) type_name ::= MEDIUMBLOB */
  {  337,   -1 }, /* (164) type_name ::= BLOB */
  {  337,   -4 }, /* (165) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  337,   -1 }, /* (166) type_name ::= DECIMAL */
  {  337,   -4 }, /* (167) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  337,   -6 }, /* (168) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  329,    0 }, /* (169) tags_def_opt ::= */
  {  329,   -1 }, /* (170) tags_def_opt ::= tags_def */
  {  332,   -4 }, /* (171) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  330,    0 }, /* (172) table_options ::= */
  {  330,   -3 }, /* (173) table_options ::= table_options COMMENT NK_STRING */
  {  330,   -3 }, /* (174) table_options ::= table_options MAX_DELAY duration_list */
  {  330,   -3 }, /* (175) table_options ::= table_options WATERMARK duration_list */
  {  330,   -5 }, /* (176) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  330,   -3 }, /* (177) table_options ::= table_options TTL NK_INTEGER */
  {  330,   -5 }, /* (178) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  335,   -1 }, /* (179) alter_table_options ::= alter_table_option */
  {  335,   -2 }, /* (180) alter_table_options ::= alter_table_options alter_table_option */
  {  348,   -2 }, /* (181) alter_table_option ::= COMMENT NK_STRING */
  {  348,   -2 }, /* (182) alter_table_option ::= TTL NK_INTEGER */
  {  346,   -1 }, /* (183) duration_list ::= duration_literal */
  {  346,   -3 }, /* (184) duration_list ::= duration_list NK_COMMA duration_literal */
  {  347,   -1 }, /* (185) rollup_func_list ::= rollup_func_name */
  {  347,   -3 }, /* (186) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  350,   -1 }, /* (187) rollup_func_name ::= function_name */
  {  350,   -1 }, /* (188) rollup_func_name ::= FIRST */
  {  350,   -1 }, /* (189) rollup_func_name ::= LAST */
  {  343,   -1 }, /* (190) col_name_list ::= col_name */
  {  343,   -3 }, /* (191) col_name_list ::= col_name_list NK_COMMA col_name */
  {  352,   -1 }, /* (192) col_name ::= column_name */
  {  305,   -2 }, /* (193) cmd ::= SHOW DNODES */
  {  305,   -2 }, /* (194) cmd ::= SHOW USERS */
  {  305,   -2 }, /* (195) cmd ::= SHOW DATABASES */
  {  305,   -4 }, /* (196) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  305,   -4 }, /* (197) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  305,   -3 }, /* (198) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  305,   -2 }, /* (199) cmd ::= SHOW MNODES */
  {  305,   -2 }, /* (200) cmd ::= SHOW MODULES */
  {  305,   -2 }, /* (201) cmd ::= SHOW QNODES */
  {  305,   -2 }, /* (202) cmd ::= SHOW FUNCTIONS */
  {  305,   -5 }, /* (203) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  305,   -2 }, /* (204) cmd ::= SHOW STREAMS */
  {  305,   -2 }, /* (205) cmd ::= SHOW ACCOUNTS */
  {  305,   -2 }, /* (206) cmd ::= SHOW APPS */
  {  305,   -2 }, /* (207) cmd ::= SHOW CONNECTIONS */
  {  305,   -2 }, /* (208) cmd ::= SHOW LICENCES */
  {  305,   -2 }, /* (209) cmd ::= SHOW GRANTS */
  {  305,   -4 }, /* (210) cmd ::= SHOW CREATE DATABASE db_name */
  {  305,   -4 }, /* (211) cmd ::= SHOW CREATE TABLE full_table_name */
  {  305,   -4 }, /* (212) cmd ::= SHOW CREATE STABLE full_table_name */
  {  305,   -2 }, /* (213) cmd ::= SHOW QUERIES */
  {  305,   -2 }, /* (214) cmd ::= SHOW SCORES */
  {  305,   -2 }, /* (215) cmd ::= SHOW TOPICS */
  {  305,   -2 }, /* (216) cmd ::= SHOW VARIABLES */
  {  305,   -3 }, /* (217) cmd ::= SHOW LOCAL VARIABLES */
  {  305,   -4 }, /* (218) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  305,   -2 }, /* (219) cmd ::= SHOW BNODES */
  {  305,   -2 }, /* (220) cmd ::= SHOW SNODES */
  {  305,   -2 }, /* (221) cmd ::= SHOW CLUSTER */
  {  305,   -2 }, /* (222) cmd ::= SHOW TRANSACTIONS */
  {  305,   -4 }, /* (223) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  305,   -2 }, /* (224) cmd ::= SHOW CONSUMERS */
  {  305,   -2 }, /* (225) cmd ::= SHOW SUBSCRIPTIONS */
  {  305,   -5 }, /* (226) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  353,    0 }, /* (227) db_name_cond_opt ::= */
  {  353,   -2 }, /* (228) db_name_cond_opt ::= db_name NK_DOT */
  {  354,    0 }, /* (229) like_pattern_opt ::= */
  {  354,   -2 }, /* (230) like_pattern_opt ::= LIKE NK_STRING */
  {  355,   -1 }, /* (231) table_name_cond ::= table_name */
  {  356,    0 }, /* (232) from_db_opt ::= */
  {  356,   -2 }, /* (233) from_db_opt ::= FROM db_name */
  {  305,   -8 }, /* (234) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  305,   -4 }, /* (235) cmd ::= DROP INDEX exists_opt full_table_name */
  {  357,  -10 }, /* (236) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  357,  -12 }, /* (237) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  358,   -1 }, /* (238) func_list ::= func */
  {  358,   -3 }, /* (239) func_list ::= func_list NK_COMMA func */
  {  361,   -4 }, /* (240) func ::= function_name NK_LP expression_list NK_RP */
  {  360,    0 }, /* (241) sma_stream_opt ::= */
  {  360,   -3 }, /* (242) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  360,   -3 }, /* (243) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  305,   -6 }, /* (244) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  305,   -7 }, /* (245) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  305,   -9 }, /* (246) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  305,   -7 }, /* (247) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  305,   -9 }, /* (248) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  305,   -4 }, /* (249) cmd ::= DROP TOPIC exists_opt topic_name */
  {  305,   -7 }, /* (250) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  305,   -2 }, /* (251) cmd ::= DESC full_table_name */
  {  305,   -2 }, /* (252) cmd ::= DESCRIBE full_table_name */
  {  305,   -3 }, /* (253) cmd ::= RESET QUERY CACHE */
  {  305,   -4 }, /* (254) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  366,    0 }, /* (255) analyze_opt ::= */
  {  366,   -1 }, /* (256) analyze_opt ::= ANALYZE */
  {  367,    0 }, /* (257) explain_options ::= */
  {  367,   -3 }, /* (258) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  367,   -3 }, /* (259) explain_options ::= explain_options RATIO NK_FLOAT */
  {  305,  -10 }, /* (260) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  305,   -4 }, /* (261) cmd ::= DROP FUNCTION exists_opt function_name */
  {  368,    0 }, /* (262) agg_func_opt ::= */
  {  368,   -1 }, /* (263) agg_func_opt ::= AGGREGATE */
  {  369,    0 }, /* (264) bufsize_opt ::= */
  {  369,   -2 }, /* (265) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  305,   -9 }, /* (266) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name AS query_expression */
  {  305,   -4 }, /* (267) cmd ::= DROP STREAM exists_opt stream_name */
  {  362,    0 }, /* (268) stream_options ::= */
  {  362,   -3 }, /* (269) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  362,   -3 }, /* (270) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  362,   -4 }, /* (271) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  362,   -3 }, /* (272) stream_options ::= stream_options WATERMARK duration_literal */
  {  362,   -4 }, /* (273) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  305,   -3 }, /* (274) cmd ::= KILL CONNECTION NK_INTEGER */
  {  305,   -3 }, /* (275) cmd ::= KILL QUERY NK_STRING */
  {  305,   -3 }, /* (276) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  305,   -2 }, /* (277) cmd ::= BALANCE VGROUP */
  {  305,   -4 }, /* (278) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  305,   -4 }, /* (279) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  305,   -3 }, /* (280) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  371,   -2 }, /* (281) dnode_list ::= DNODE NK_INTEGER */
  {  371,   -3 }, /* (282) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  305,   -4 }, /* (283) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  305,   -1 }, /* (284) cmd ::= query_expression */
  {  305,   -7 }, /* (285) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
  {  305,   -4 }, /* (286) cmd ::= INSERT INTO full_table_name query_expression */
  {  308,   -1 }, /* (287) literal ::= NK_INTEGER */
  {  308,   -1 }, /* (288) literal ::= NK_FLOAT */
  {  308,   -1 }, /* (289) literal ::= NK_STRING */
  {  308,   -1 }, /* (290) literal ::= NK_BOOL */
  {  308,   -2 }, /* (291) literal ::= TIMESTAMP NK_STRING */
  {  308,   -1 }, /* (292) literal ::= duration_literal */
  {  308,   -1 }, /* (293) literal ::= NULL */
  {  308,   -1 }, /* (294) literal ::= NK_QUESTION */
  {  349,   -1 }, /* (295) duration_literal ::= NK_VARIABLE */
  {  373,   -1 }, /* (296) signed ::= NK_INTEGER */
  {  373,   -2 }, /* (297) signed ::= NK_PLUS NK_INTEGER */
  {  373,   -2 }, /* (298) signed ::= NK_MINUS NK_INTEGER */
  {  373,   -1 }, /* (299) signed ::= NK_FLOAT */
  {  373,   -2 }, /* (300) signed ::= NK_PLUS NK_FLOAT */
  {  373,   -2 }, /* (301) signed ::= NK_MINUS NK_FLOAT */
  {  338,   -1 }, /* (302) signed_literal ::= signed */
  {  338,   -1 }, /* (303) signed_literal ::= NK_STRING */
  {  338,   -1 }, /* (304) signed_literal ::= NK_BOOL */
  {  338,   -2 }, /* (305) signed_literal ::= TIMESTAMP NK_STRING */
  {  338,   -1 }, /* (306) signed_literal ::= duration_literal */
  {  338,   -1 }, /* (307) signed_literal ::= NULL */
  {  338,   -1 }, /* (308) signed_literal ::= literal_func */
  {  338,   -1 }, /* (309) signed_literal ::= NK_QUESTION */
  {  375,   -1 }, /* (310) literal_list ::= signed_literal */
  {  375,   -3 }, /* (311) literal_list ::= literal_list NK_COMMA signed_literal */
  {  316,   -1 }, /* (312) db_name ::= NK_ID */
  {  344,   -1 }, /* (313) table_name ::= NK_ID */
  {  336,   -1 }, /* (314) column_name ::= NK_ID */
  {  351,   -1 }, /* (315) function_name ::= NK_ID */
  {  376,   -1 }, /* (316) table_alias ::= NK_ID */
  {  377,   -1 }, /* (317) column_alias ::= NK_ID */
  {  310,   -1 }, /* (318) user_name ::= NK_ID */
  {  363,   -1 }, /* (319) topic_name ::= NK_ID */
  {  370,   -1 }, /* (320) stream_name ::= NK_ID */
  {  365,   -1 }, /* (321) cgroup_name ::= NK_ID */
  {  378,   -1 }, /* (322) expression ::= literal */
  {  378,   -1 }, /* (323) expression ::= pseudo_column */
  {  378,   -1 }, /* (324) expression ::= column_reference */
  {  378,   -1 }, /* (325) expression ::= function_expression */
  {  378,   -1 }, /* (326) expression ::= subquery */
  {  378,   -3 }, /* (327) expression ::= NK_LP expression NK_RP */
  {  378,   -2 }, /* (328) expression ::= NK_PLUS expression */
  {  378,   -2 }, /* (329) expression ::= NK_MINUS expression */
  {  378,   -3 }, /* (330) expression ::= expression NK_PLUS expression */
  {  378,   -3 }, /* (331) expression ::= expression NK_MINUS expression */
  {  378,   -3 }, /* (332) expression ::= expression NK_STAR expression */
  {  378,   -3 }, /* (333) expression ::= expression NK_SLASH expression */
  {  378,   -3 }, /* (334) expression ::= expression NK_REM expression */
  {  378,   -3 }, /* (335) expression ::= column_reference NK_ARROW NK_STRING */
  {  378,   -3 }, /* (336) expression ::= expression NK_BITAND expression */
  {  378,   -3 }, /* (337) expression ::= expression NK_BITOR expression */
  {  341,   -1 }, /* (338) expression_list ::= expression */
  {  341,   -3 }, /* (339) expression_list ::= expression_list NK_COMMA expression */
  {  380,   -1 }, /* (340) column_reference ::= column_name */
  {  380,   -3 }, /* (341) column_reference ::= table_name NK_DOT column_name */
  {  379,   -1 }, /* (342) pseudo_column ::= ROWTS */
  {  379,   -1 }, /* (343) pseudo_column ::= TBNAME */
  {  379,   -3 }, /* (344) pseudo_column ::= table_name NK_DOT TBNAME */
  {  379,   -1 }, /* (345) pseudo_column ::= QSTART */
  {  379,   -1 }, /* (346) pseudo_column ::= QEND */
  {  379,   -1 }, /* (347) pseudo_column ::= QDURATION */
  {  379,   -1 }, /* (348) pseudo_column ::= WSTART */
  {  379,   -1 }, /* (349) pseudo_column ::= WEND */
  {  379,   -1 }, /* (350) pseudo_column ::= WDURATION */
  {  381,   -4 }, /* (351) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  381,   -4 }, /* (352) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  381,   -6 }, /* (353) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  381,   -1 }, /* (354) function_expression ::= literal_func */
  {  374,   -3 }, /* (355) literal_func ::= noarg_func NK_LP NK_RP */
  {  374,   -1 }, /* (356) literal_func ::= NOW */
  {  385,   -1 }, /* (357) noarg_func ::= NOW */
  {  385,   -1 }, /* (358) noarg_func ::= TODAY */
  {  385,   -1 }, /* (359) noarg_func ::= TIMEZONE */
  {  385,   -1 }, /* (360) noarg_func ::= DATABASE */
  {  385,   -1 }, /* (361) noarg_func ::= CLIENT_VERSION */
  {  385,   -1 }, /* (362) noarg_func ::= SERVER_VERSION */
  {  385,   -1 }, /* (363) noarg_func ::= SERVER_STATUS */
  {  385,   -1 }, /* (364) noarg_func ::= CURRENT_USER */
  {  385,   -1 }, /* (365) noarg_func ::= USER */
  {  383,   -1 }, /* (366) star_func ::= COUNT */
  {  383,   -1 }, /* (367) star_func ::= FIRST */
  {  383,   -1 }, /* (368) star_func ::= LAST */
  {  383,   -1 }, /* (369) star_func ::= LAST_ROW */
  {  384,   -1 }, /* (370) star_func_para_list ::= NK_STAR */
  {  384,   -1 }, /* (371) star_func_para_list ::= other_para_list */
  {  386,   -1 }, /* (372) other_para_list ::= star_func_para */
  {  386,   -3 }, /* (373) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  387,   -1 }, /* (374) star_func_para ::= expression */
  {  387,   -3 }, /* (375) star_func_para ::= table_name NK_DOT NK_STAR */
  {  388,   -3 }, /* (376) predicate ::= expression compare_op expression */
  {  388,   -5 }, /* (377) predicate ::= expression BETWEEN expression AND expression */
  {  388,   -6 }, /* (378) predicate ::= expression NOT BETWEEN expression AND expression */
  {  388,   -3 }, /* (379) predicate ::= expression IS NULL */
  {  388,   -4 }, /* (380) predicate ::= expression IS NOT NULL */
  {  388,   -3 }, /* (381) predicate ::= expression in_op in_predicate_value */
  {  389,   -1 }, /* (382) compare_op ::= NK_LT */
  {  389,   -1 }, /* (383) compare_op ::= NK_GT */
  {  389,   -1 }, /* (384) compare_op ::= NK_LE */
  {  389,   -1 }, /* (385) compare_op ::= NK_GE */
  {  389,   -1 }, /* (386) compare_op ::= NK_NE */
  {  389,   -1 }, /* (387) compare_op ::= NK_EQ */
  {  389,   -1 }, /* (388) compare_op ::= LIKE */
  {  389,   -2 }, /* (389) compare_op ::= NOT LIKE */
  {  389,   -1 }, /* (390) compare_op ::= MATCH */
  {  389,   -1 }, /* (391) compare_op ::= NMATCH */
  {  389,   -1 }, /* (392) compare_op ::= CONTAINS */
  {  390,   -1 }, /* (393) in_op ::= IN */
  {  390,   -2 }, /* (394) in_op ::= NOT IN */
  {  391,   -3 }, /* (395) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  392,   -1 }, /* (396) boolean_value_expression ::= boolean_primary */
  {  392,   -2 }, /* (397) boolean_value_expression ::= NOT boolean_primary */
  {  392,   -3 }, /* (398) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  392,   -3 }, /* (399) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  393,   -1 }, /* (400) boolean_primary ::= predicate */
  {  393,   -3 }, /* (401) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  394,   -1 }, /* (402) common_expression ::= expression */
  {  394,   -1 }, /* (403) common_expression ::= boolean_value_expression */
  {  395,    0 }, /* (404) from_clause_opt ::= */
  {  395,   -2 }, /* (405) from_clause_opt ::= FROM table_reference_list */
  {  396,   -1 }, /* (406) table_reference_list ::= table_reference */
  {  396,   -3 }, /* (407) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  397,   -1 }, /* (408) table_reference ::= table_primary */
  {  397,   -1 }, /* (409) table_reference ::= joined_table */
  {  398,   -2 }, /* (410) table_primary ::= table_name alias_opt */
  {  398,   -4 }, /* (411) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  398,   -2 }, /* (412) table_primary ::= subquery alias_opt */
  {  398,   -1 }, /* (413) table_primary ::= parenthesized_joined_table */
  {  400,    0 }, /* (414) alias_opt ::= */
  {  400,   -1 }, /* (415) alias_opt ::= table_alias */
  {  400,   -2 }, /* (416) alias_opt ::= AS table_alias */
  {  401,   -3 }, /* (417) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  401,   -3 }, /* (418) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  399,   -6 }, /* (419) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  402,    0 }, /* (420) join_type ::= */
  {  402,   -1 }, /* (421) join_type ::= INNER */
  {  404,  -12 }, /* (422) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  405,    0 }, /* (423) set_quantifier_opt ::= */
  {  405,   -1 }, /* (424) set_quantifier_opt ::= DISTINCT */
  {  405,   -1 }, /* (425) set_quantifier_opt ::= ALL */
  {  406,   -1 }, /* (426) select_list ::= select_item */
  {  406,   -3 }, /* (427) select_list ::= select_list NK_COMMA select_item */
  {  414,   -1 }, /* (428) select_item ::= NK_STAR */
  {  414,   -1 }, /* (429) select_item ::= common_expression */
  {  414,   -2 }, /* (430) select_item ::= common_expression column_alias */
  {  414,   -3 }, /* (431) select_item ::= common_expression AS column_alias */
  {  414,   -3 }, /* (432) select_item ::= table_name NK_DOT NK_STAR */
  {  372,    0 }, /* (433) where_clause_opt ::= */
  {  372,   -2 }, /* (434) where_clause_opt ::= WHERE search_condition */
  {  407,    0 }, /* (435) partition_by_clause_opt ::= */
  {  407,   -3 }, /* (436) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  411,    0 }, /* (437) twindow_clause_opt ::= */
  {  411,   -6 }, /* (438) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  411,   -4 }, /* (439) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  411,   -6 }, /* (440) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  411,   -8 }, /* (441) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  359,    0 }, /* (442) sliding_opt ::= */
  {  359,   -4 }, /* (443) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  410,    0 }, /* (444) fill_opt ::= */
  {  410,   -4 }, /* (445) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  410,   -6 }, /* (446) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  415,   -1 }, /* (447) fill_mode ::= NONE */
  {  415,   -1 }, /* (448) fill_mode ::= PREV */
  {  415,   -1 }, /* (449) fill_mode ::= NULL */
  {  415,   -1 }, /* (450) fill_mode ::= LINEAR */
  {  415,   -1 }, /* (451) fill_mode ::= NEXT */
  {  412,    0 }, /* (452) group_by_clause_opt ::= */
  {  412,   -3 }, /* (453) group_by_clause_opt ::= GROUP BY group_by_list */
  {  416,   -1 }, /* (454) group_by_list ::= expression */
  {  416,   -3 }, /* (455) group_by_list ::= group_by_list NK_COMMA expression */
  {  413,    0 }, /* (456) having_clause_opt ::= */
  {  413,   -2 }, /* (457) having_clause_opt ::= HAVING search_condition */
  {  408,    0 }, /* (458) range_opt ::= */
  {  408,   -6 }, /* (459) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  409,    0 }, /* (460) every_opt ::= */
  {  409,   -4 }, /* (461) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  364,   -4 }, /* (462) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  417,   -1 }, /* (463) query_expression_body ::= query_primary */
  {  417,   -4 }, /* (464) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  417,   -3 }, /* (465) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  421,   -1 }, /* (466) query_primary ::= query_specification */
  {  421,   -6 }, /* (467) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  418,    0 }, /* (468) order_by_clause_opt ::= */
  {  418,   -3 }, /* (469) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  419,    0 }, /* (470) slimit_clause_opt ::= */
  {  419,   -2 }, /* (471) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  419,   -4 }, /* (472) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  419,   -4 }, /* (473) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  420,    0 }, /* (474) limit_clause_opt ::= */
  {  420,   -2 }, /* (475) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  420,   -4 }, /* (476) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  420,   -4 }, /* (477) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  382,   -3 }, /* (478) subquery ::= NK_LP query_expression NK_RP */
  {  403,   -1 }, /* (479) search_condition ::= common_expression */
  {  422,   -1 }, /* (480) sort_specification_list ::= sort_specification */
  {  422,   -3 }, /* (481) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  423,   -3 }, /* (482) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  424,    0 }, /* (483) ordering_specification_opt ::= */
  {  424,   -1 }, /* (484) ordering_specification_opt ::= ASC */
  {  424,   -1 }, /* (485) ordering_specification_opt ::= DESC */
  {  425,    0 }, /* (486) null_ordering_opt ::= */
  {  425,   -2 }, /* (487) null_ordering_opt ::= NULLS FIRST */
  {  425,   -2 }, /* (488) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,306,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,307,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,306,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,308,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,309,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,307,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,309,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,308,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy209, &yymsp[-1].minor.yy0, yymsp[0].minor.yy59); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy209, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy209, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy209, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy59 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy59 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy69, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy69, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy69 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy69 = yymsp[0].minor.yy69; }
  yymsp[0].minor.yy69 = yylhsminor.yy69;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy69 = yymsp[-2].minor.yy69 | yymsp[0].minor.yy69; }
  yymsp[-2].minor.yy69 = yylhsminor.yy69;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy69 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy69 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy209 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy209 = yylhsminor.yy209;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy209 = yymsp[-2].minor.yy209; }
  yymsp[-2].minor.yy209 = yylhsminor.yy209;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy209, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 312: /* db_name ::= NK_ID */ yytestcase(yyruleno==312);
      case 313: /* table_name ::= NK_ID */ yytestcase(yyruleno==313);
      case 314: /* column_name ::= NK_ID */ yytestcase(yyruleno==314);
      case 315: /* function_name ::= NK_ID */ yytestcase(yyruleno==315);
      case 316: /* table_alias ::= NK_ID */ yytestcase(yyruleno==316);
      case 317: /* column_alias ::= NK_ID */ yytestcase(yyruleno==317);
      case 318: /* user_name ::= NK_ID */ yytestcase(yyruleno==318);
      case 319: /* topic_name ::= NK_ID */ yytestcase(yyruleno==319);
      case 320: /* stream_name ::= NK_ID */ yytestcase(yyruleno==320);
      case 321: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==321);
      case 357: /* noarg_func ::= NOW */ yytestcase(yyruleno==357);
      case 358: /* noarg_func ::= TODAY */ yytestcase(yyruleno==358);
      case 359: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==359);
      case 360: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==360);
      case 361: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==361);
      case 362: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==362);
      case 363: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==363);
      case 364: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==364);
      case 365: /* noarg_func ::= USER */ yytestcase(yyruleno==365);
      case 366: /* star_func ::= COUNT */ yytestcase(yyruleno==366);
      case 367: /* star_func ::= FIRST */ yytestcase(yyruleno==367);
      case 368: /* star_func ::= LAST */ yytestcase(yyruleno==368);
      case 369: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==369);
{ yylhsminor.yy209 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy209 = yylhsminor.yy209;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy293, &yymsp[-1].minor.yy209, yymsp[0].minor.yy272); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy293, &yymsp[0].minor.yy209); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy209, yymsp[0].minor.yy272); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy293 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 255: /* analyze_opt ::= */ yytestcase(yyruleno==255);
      case 262: /* agg_func_opt ::= */ yytestcase(yyruleno==262);
      case 423: /* set_quantifier_opt ::= */ yytestcase(yyruleno==423);
{ yymsp[1].minor.yy293 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy293 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy272 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 79: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 80: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 81: /* db_options ::= db_options KEEP integer_list */
      case 82: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==82);
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_KEEP, yymsp[0].minor.yy172); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 83: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 84: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 85: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 86: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 87: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 88: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 89: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 90: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_RETENTIONS, yymsp[0].minor.yy172); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 91: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 92: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 93: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 94: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 95: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-3].minor.yy272, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy272 = yylhsminor.yy272;
        break;
      case 96: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-3].minor.yy272, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy272 = yylhsminor.yy272;
        break;
      case 98: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 99: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy272 = setDatabaseOption(pCxt, yymsp[-2].minor.yy272, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 100: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy272 = createAlterDatabaseOptions(pCxt); yylhsminor.yy272 = setAlterDatabaseOption(pCxt, yylhsminor.yy272, &yymsp[0].minor.yy5); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 101: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy272 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy272, &yymsp[0].minor.yy5); }
  yymsp[-1].minor.yy272 = yylhsminor.yy272;
        break;
      case 102: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy5.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy5.val = yymsp[0].minor.yy0; }
        break;
      case 103: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy5.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy5.val = yymsp[0].minor.yy0; }
        break;
      case 104: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy5.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy5.val = yymsp[0].minor.yy0; }
        break;
      case 105: /* alter_db_option ::= KEEP integer_list */
      case 106: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==106);
{ yymsp[-1].minor.yy5.type = DB_OPTION_KEEP; yymsp[-1].minor.yy5.pList = yymsp[0].minor.yy172; }
        break;
      case 107: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy5.type = DB_OPTION_WAL; yymsp[-1].minor.yy5.val = yymsp[0].minor.yy0; }
        break;
      case 108: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy172 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 109: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 282: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==282);
{ yylhsminor.yy172 = addNodeToList(pCxt, yymsp[-2].minor.yy172, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 110: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy172 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 111: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy172 = addNodeToList(pCxt, yymsp[-2].minor.yy172, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 112: /* retention_list ::= retention */
      case 132: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==132);
      case 135: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==135);
      case 142: /* column_def_list ::= column_def */ yytestcase(yyruleno==142);
      case 185: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==185);
      case 190: /* col_name_list ::= col_name */ yytestcase(yyruleno==190);
      case 238: /* func_list ::= func */ yytestcase(yyruleno==238);
      case 310: /* literal_list ::= signed_literal */ yytestcase(yyruleno==310);
      case 372: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==372);
      case 426: /* select_list ::= select_item */ yytestcase(yyruleno==426);
      case 480: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==480);
{ yylhsminor.yy172 = createNodeList(pCxt, yymsp[0].minor.yy272); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 113: /* retention_list ::= retention_list NK_COMMA retention */
      case 143: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==143);
      case 186: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==186);
      case 191: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==191);
      case 239: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==239);
      case 311: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==311);
      case 373: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==373);
      case 427: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==427);
      case 481: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==481);
{ yylhsminor.yy172 = addNodeToList(pCxt, yymsp[-2].minor.yy172, yymsp[0].minor.yy272); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 114: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy272 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 115: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 117: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==117);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy293, yymsp[-5].minor.yy272, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, yymsp[0].minor.yy272); }
        break;
      case 116: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy172); }
        break;
      case 118: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy172); }
        break;
      case 119: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy293, yymsp[0].minor.yy272); }
        break;
      case 120: /* cmd ::= ALTER TABLE alter_table_clause */
      case 284: /* cmd ::= query_expression */ yytestcase(yyruleno==284);
{ pCxt->pRootNode = yymsp[0].minor.yy272; }
        break;
      case 121: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy272); }
        break;
      case 122: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy272 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy272, yymsp[0].minor.yy272); }
  yymsp[-1].minor.yy272 = yylhsminor.yy272;
        break;
      case 123: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy272 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy272, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy209, yymsp[0].minor.yy616); }
  yymsp[-4].minor.yy272 = yylhsminor.yy272;
        break;
      case 124: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy272 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy272, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy209); }
  yymsp[-3].minor.yy272 = yylhsminor.yy272;
        break;
      case 125: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy272 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy272, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy209, yymsp[0].minor.yy616); }
  yymsp[-4].minor.yy272 = yylhsminor.yy272;
        break;
      case 126: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy272 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy272, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-4].minor.yy272 = yylhsminor.yy272;
        break;
      case 127: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy272 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy272, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy209, yymsp[0].minor.yy616); }
  yymsp[-4].minor.yy272 = yylhsminor.yy272;
        break;
      case 128: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy272 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy272, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy209); }
  yymsp[-3].minor.yy272 = yylhsminor.yy272;
        break;
      case 129: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy272 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy272, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy209, yymsp[0].minor.yy616); }
  yymsp[-4].minor.yy272 = yylhsminor.yy272;
        break;
      case 130: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy272 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy272, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-4].minor.yy272 = yylhsminor.yy272;
        break;
      case 131: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy272 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy272, &yymsp[-2].minor.yy209, yymsp[0].minor.yy272); }
  yymsp[-5].minor.yy272 = yylhsminor.yy272;
        break;
      case 133: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 136: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==136);
{ yylhsminor.yy172 = addNodeToList(pCxt, yymsp[-1].minor.yy172, yymsp[0].minor.yy272); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 134: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy272 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy293, yymsp[-8].minor.yy272, yymsp[-6].minor.yy272, yymsp[-5].minor.yy172, yymsp[-2].minor.yy172, yymsp[0].minor.yy272); }
  yymsp[-9].minor.yy272 = yylhsminor.yy272;
        break;
      case 137: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy272 = createDropTableClause(pCxt, yymsp[-1].minor.yy293, yymsp[0].minor.yy272); }
  yymsp[-1].minor.yy272 = yylhsminor.yy272;
        break;
      case 138: /* specific_cols_opt ::= */
      case 169: /* tags_def_opt ::= */ yytestcase(yyruleno==169);
      case 435: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==435);
      case 452: /* group_by_clause_opt ::= */ yytestcase(yyruleno==452);
      case 468: /* order_by_clause_opt ::= */ yytestcase(yyruleno==468);
{ yymsp[1].minor.yy172 = NULL; }
        break;
      case 139: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy172 = yymsp[-1].minor.yy172; }
        break;
      case 140: /* full_table_name ::= table_name */
{ yylhsminor.yy272 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy209, NULL); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 141: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy272 = createRealTableNode(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209, NULL); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 144: /* column_def ::= column_name type_name */
{ yylhsminor.yy272 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy209, yymsp[0].minor.yy616, NULL); }
  yymsp[-1].minor.yy272 = yylhsminor.yy272;
        break;
      case 145: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy272 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy209, yymsp[-2].minor.yy616, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy272 = yylhsminor.yy272;
        break;
      case 146: /* type_name ::= BOOL */
{ yymsp[0].minor.yy616 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 147: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy616 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 148: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy616 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 149: /* type_name ::= INT */
      case 150: /* type_name ::= INTEGER */ yytestcase(yyruleno==150);
{ yymsp[0].minor.yy616 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 151: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy616 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 152: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy616 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 153: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy616 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 154: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy616 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 155: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy616 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 156: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy616 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy616 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 158: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy616 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 159: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy616 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 160: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy616 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 161: /* type_name ::= JSON */
{ yymsp[0].minor.yy616 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 162: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy616 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 163: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy616 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 164: /* type_name ::= BLOB */
{ yymsp[0].minor.yy616 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 165: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy616 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 166: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy616 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 167: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy616 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 168: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy616 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 170: /* tags_def_opt ::= tags_def */
      case 371: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==371);
{ yylhsminor.yy172 = yymsp[0].minor.yy172; }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 171: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy172 = yymsp[-1].minor.yy172; }
        break;
      case 172: /* table_options ::= */
{ yymsp[1].minor.yy272 = createDefaultTableOptions(pCxt); }
        break;
      case 173: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy272 = setTableOption(pCxt, yymsp[-2].minor.yy272, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 174: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy272 = setTableOption(pCxt, yymsp[-2].minor.yy272, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy172); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 175: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy272 = setTableOption(pCxt, yymsp[-2].minor.yy272, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy172); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 176: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy272 = setTableOption(pCxt, yymsp[-4].minor.yy272, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy172); }
  yymsp[-4].minor.yy272 = yylhsminor.yy272;
        break;
      case 177: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy272 = setTableOption(pCxt, yymsp[-2].minor.yy272, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 178: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy272 = setTableOption(pCxt, yymsp[-4].minor.yy272, TABLE_OPTION_SMA, yymsp[-1].minor.yy172); }
  yymsp[-4].minor.yy272 = yylhsminor.yy272;
        break;
      case 179: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy272 = createAlterTableOptions(pCxt); yylhsminor.yy272 = setTableOption(pCxt, yylhsminor.yy272, yymsp[0].minor.yy5.type, &yymsp[0].minor.yy5.val); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 180: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy272 = setTableOption(pCxt, yymsp[-1].minor.yy272, yymsp[0].minor.yy5.type, &yymsp[0].minor.yy5.val); }
  yymsp[-1].minor.yy272 = yylhsminor.yy272;
        break;
      case 181: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy5.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy5.val = yymsp[0].minor.yy0; }
        break;
      case 182: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy5.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy5.val = yymsp[0].minor.yy0; }
        break;
      case 183: /* duration_list ::= duration_literal */
      case 338: /* expression_list ::= expression */ yytestcase(yyruleno==338);
{ yylhsminor.yy172 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy272)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 184: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 339: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==339);
{ yylhsminor.yy172 = addNodeToList(pCxt, yymsp[-2].minor.yy172, releaseRawExprNode(pCxt, yymsp[0].minor.yy272)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 187: /* rollup_func_name ::= function_name */
{ yylhsminor.yy272 = createFunctionNode(pCxt, &yymsp[0].minor.yy209, NULL); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 188: /* rollup_func_name ::= FIRST */
      case 189: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==189);
{ yylhsminor.yy272 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 192: /* col_name ::= column_name */
{ yylhsminor.yy272 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy209); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 193: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 194: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 195: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 196: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy272, yymsp[0].minor.yy272, OP_TYPE_LIKE); }
        break;
      case 197: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy272, yymsp[0].minor.yy272, OP_TYPE_LIKE); }
        break;
      case 198: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy272, NULL, OP_TYPE_LIKE); }
        break;
      case 199: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 200: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 201: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 202: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 203: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy272, yymsp[-1].minor.yy272, OP_TYPE_EQUAL); }
        break;
      case 204: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 205: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 206: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 207: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 208: /* cmd ::= SHOW LICENCES */
      case 209: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==209);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 210: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 211: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy272); }
        break;
      case 212: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy272); }
        break;
      case 213: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 214: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 215: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 216: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 217: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 218: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 219: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 220: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 221: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 222: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 223: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy272); }
        break;
      case 224: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 225: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 226: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy272, yymsp[-1].minor.yy272, OP_TYPE_EQUAL); }
        break;
      case 227: /* db_name_cond_opt ::= */
      case 232: /* from_db_opt ::= */ yytestcase(yyruleno==232);
{ yymsp[1].minor.yy272 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 228: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy272 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy209); }
  yymsp[-1].minor.yy272 = yylhsminor.yy272;
        break;
      case 229: /* like_pattern_opt ::= */
      case 404: /* from_clause_opt ::= */ yytestcase(yyruleno==404);
      case 433: /* where_clause_opt ::= */ yytestcase(yyruleno==433);
      case 437: /* twindow_clause_opt ::= */ yytestcase(yyruleno==437);
      case 442: /* sliding_opt ::= */ yytestcase(yyruleno==442);
      case 444: /* fill_opt ::= */ yytestcase(yyruleno==444);
      case 456: /* having_clause_opt ::= */ yytestcase(yyruleno==456);
      case 458: /* range_opt ::= */ yytestcase(yyruleno==458);
      case 460: /* every_opt ::= */ yytestcase(yyruleno==460);
      case 470: /* slimit_clause_opt ::= */ yytestcase(yyruleno==470);
      case 474: /* limit_clause_opt ::= */ yytestcase(yyruleno==474);
{ yymsp[1].minor.yy272 = NULL; }
        break;
      case 230: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy272 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 231: /* table_name_cond ::= table_name */
{ yylhsminor.yy272 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy209); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 233: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy272 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy209); }
        break;
      case 234: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy293, yymsp[-3].minor.yy272, yymsp[-1].minor.yy272, NULL, yymsp[0].minor.yy272); }
        break;
      case 235: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy293, yymsp[0].minor.yy272); }
        break;
      case 236: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy272 = createIndexOption(pCxt, yymsp[-7].minor.yy172, releaseRawExprNode(pCxt, yymsp[-3].minor.yy272), NULL, yymsp[-1].minor.yy272, yymsp[0].minor.yy272); }
        break;
      case 237: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy272 = createIndexOption(pCxt, yymsp[-9].minor.yy172, releaseRawExprNode(pCxt, yymsp[-5].minor.yy272), releaseRawExprNode(pCxt, yymsp[-3].minor.yy272), yymsp[-1].minor.yy272, yymsp[0].minor.yy272); }
        break;
      case 240: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy272 = createFunctionNode(pCxt, &yymsp[-3].minor.yy209, yymsp[-1].minor.yy172); }
  yymsp[-3].minor.yy272 = yylhsminor.yy272;
        break;
      case 241: /* sma_stream_opt ::= */
      case 268: /* stream_options ::= */ yytestcase(yyruleno==268);
{ yymsp[1].minor.yy272 = createStreamOptions(pCxt); }
        break;
      case 242: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 272: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==272);
{ ((SStreamOptions*)yymsp[-2].minor.yy272)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy272); yylhsminor.yy272 = yymsp[-2].minor.yy272; }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 243: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy272)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy272); yylhsminor.yy272 = yymsp[-2].minor.yy272; }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 244: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy293, &yymsp[-2].minor.yy209, yymsp[0].minor.yy272); }
        break;
      case 245: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy293, &yymsp[-3].minor.yy209, &yymsp[0].minor.yy209, false); }
        break;
      case 246: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy293, &yymsp[-5].minor.yy209, &yymsp[0].minor.yy209, true); }
        break;
      case 247: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy293, &yymsp[-3].minor.yy209, yymsp[0].minor.yy272, false); }
        break;
      case 248: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy293, &yymsp[-5].minor.yy209, yymsp[0].minor.yy272, true); }
        break;
      case 249: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy293, &yymsp[0].minor.yy209); }
        break;
      case 250: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy293, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209); }
        break;
      case 251: /* cmd ::= DESC full_table_name */
      case 252: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==252);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy272); }
        break;
      case 253: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 254: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy293, yymsp[-1].minor.yy272, yymsp[0].minor.yy272); }
        break;
      case 256: /* analyze_opt ::= ANALYZE */
      case 263: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==263);
      case 424: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==424);
{ yymsp[0].minor.yy293 = true; }
        break;
      case 257: /* explain_options ::= */
{ yymsp[1].minor.yy272 = createDefaultExplainOptions(pCxt); }
        break;
      case 258: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy272 = setExplainVerbose(pCxt, yymsp[-2].minor.yy272, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 259: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy272 = setExplainRatio(pCxt, yymsp[-2].minor.yy272, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 260: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy293, yymsp[-8].minor.yy293, &yymsp[-5].minor.yy209, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy616, yymsp[0].minor.yy232); }
        break;
      case 261: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy293, &yymsp[0].minor.yy209); }
        break;
      case 264: /* bufsize_opt ::= */
{ yymsp[1].minor.yy232 = 0; }
        break;
      case 265: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy232 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 266: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-6].minor.yy293, &yymsp[-5].minor.yy209, yymsp[-2].minor.yy272, yymsp[-4].minor.yy272, yymsp[0].minor.yy272); }
        break;
      case 267: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy293, &yymsp[0].minor.yy209); }
        break;
      case 269: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy272)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy272 = yymsp[-2].minor.yy272; }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 270: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy272)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy272 = yymsp[-2].minor.yy272; }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 271: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy272)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy272)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy272); yylhsminor.yy272 = yymsp[-3].minor.yy272; }
  yymsp[-3].minor.yy272 = yylhsminor.yy272;
        break;
      case 273: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy272)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy272 = yymsp[-3].minor.yy272; }
  yymsp[-3].minor.yy272 = yylhsminor.yy272;
        break;
      case 274: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 275: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 276: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 277: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 278: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 279: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy172); }
        break;
      case 280: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 281: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy172 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 283: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy272, yymsp[0].minor.yy272); }
        break;
      case 285: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy272, yymsp[-2].minor.yy172, yymsp[0].minor.yy272); }
        break;
      case 286: /* cmd ::= INSERT INTO full_table_name query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy272, NULL, yymsp[0].minor.yy272); }
        break;
      case 287: /* literal ::= NK_INTEGER */
{ yylhsminor.yy272 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 288: /* literal ::= NK_FLOAT */
{ yylhsminor.yy272 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 289: /* literal ::= NK_STRING */
{ yylhsminor.yy272 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 290: /* literal ::= NK_BOOL */
{ yylhsminor.yy272 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 291: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy272 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy272 = yylhsminor.yy272;
        break;
      case 292: /* literal ::= duration_literal */
      case 302: /* signed_literal ::= signed */ yytestcase(yyruleno==302);
      case 322: /* expression ::= literal */ yytestcase(yyruleno==322);
      case 323: /* expression ::= pseudo_column */ yytestcase(yyruleno==323);
      case 324: /* expression ::= column_reference */ yytestcase(yyruleno==324);
      case 325: /* expression ::= function_expression */ yytestcase(yyruleno==325);
      case 326: /* expression ::= subquery */ yytestcase(yyruleno==326);
      case 354: /* function_expression ::= literal_func */ yytestcase(yyruleno==354);
      case 396: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==396);
      case 400: /* boolean_primary ::= predicate */ yytestcase(yyruleno==400);
      case 402: /* common_expression ::= expression */ yytestcase(yyruleno==402);
      case 403: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==403);
      case 406: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==406);
      case 408: /* table_reference ::= table_primary */ yytestcase(yyruleno==408);
      case 409: /* table_reference ::= joined_table */ yytestcase(yyruleno==409);
      case 413: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==413);
      case 463: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==463);
      case 466: /* query_primary ::= query_specification */ yytestcase(yyruleno==466);
{ yylhsminor.yy272 = yymsp[0].minor.yy272; }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 293: /* literal ::= NULL */
{ yylhsminor.yy272 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 294: /* literal ::= NK_QUESTION */
{ yylhsminor.yy272 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 295: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy272 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 296: /* signed ::= NK_INTEGER */
{ yylhsminor.yy272 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 297: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy272 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 298: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy272 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy272 = yylhsminor.yy272;
        break;
      case 299: /* signed ::= NK_FLOAT */
{ yylhsminor.yy272 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 300: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy272 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 301: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy272 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy272 = yylhsminor.yy272;
        break;
      case 303: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy272 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 304: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy272 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 305: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy272 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 306: /* signed_literal ::= duration_literal */
      case 308: /* signed_literal ::= literal_func */ yytestcase(yyruleno==308);
      case 374: /* star_func_para ::= expression */ yytestcase(yyruleno==374);
      case 429: /* select_item ::= common_expression */ yytestcase(yyruleno==429);
      case 479: /* search_condition ::= common_expression */ yytestcase(yyruleno==479);
{ yylhsminor.yy272 = releaseRawExprNode(pCxt, yymsp[0].minor.yy272); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 307: /* signed_literal ::= NULL */
{ yylhsminor.yy272 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 309: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy272 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 327: /* expression ::= NK_LP expression NK_RP */
      case 401: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==401);
{ yylhsminor.yy272 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy272)); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 328: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy272);
                                                                                    yylhsminor.yy272 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy272));
                                                                                  }
  yymsp[-1].minor.yy272 = yylhsminor.yy272;
        break;
      case 329: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy272);
                                                                                    yylhsminor.yy272 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy272), NULL));
                                                                                  }
  yymsp[-1].minor.yy272 = yylhsminor.yy272;
        break;
      case 330: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy272);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy272);
                                                                                    yylhsminor.yy272 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy272), releaseRawExprNode(pCxt, yymsp[0].minor.yy272))); 
                                                                                  }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 331: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy272);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy272);
                                                                                    yylhsminor.yy272 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy272), releaseRawExprNode(pCxt, yymsp[0].minor.yy272))); 
                                                                                  }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 332: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy272);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy272);
                                                                                    yylhsminor.yy272 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy272), releaseRawExprNode(pCxt, yymsp[0].minor.yy272))); 
                                                                                  }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 333: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy272);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy272);
                                                                                    yylhsminor.yy272 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy272), releaseRawExprNode(pCxt, yymsp[0].minor.yy272))); 
                                                                                  }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 334: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy272);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy272);
                                                                                    yylhsminor.yy272 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy272), releaseRawExprNode(pCxt, yymsp[0].minor.yy272)));
                                                                                  }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 335: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy272);
                                                                                    yylhsminor.yy272 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy272), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 336: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy272);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy272);
                                                                                    yylhsminor.yy272 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy272), releaseRawExprNode(pCxt, yymsp[0].minor.yy272)));
                                                                                  }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 337: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy272);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy272);
                                                                                    yylhsminor.yy272 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy272), releaseRawExprNode(pCxt, yymsp[0].minor.yy272)));
                                                                                  }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 340: /* column_reference ::= column_name */
{ yylhsminor.yy272 = createRawExprNode(pCxt, &yymsp[0].minor.yy209, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy209)); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 341: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy272 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209, createColumnNode(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209)); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 342: /* pseudo_column ::= ROWTS */
      case 343: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==343);
      case 345: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==345);
      case 346: /* pseudo_column ::= QEND */ yytestcase(yyruleno==346);
      case 347: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==347);
      case 348: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==348);
      case 349: /* pseudo_column ::= WEND */ yytestcase(yyruleno==349);
      case 350: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==350);
      case 356: /* literal_func ::= NOW */ yytestcase(yyruleno==356);
{ yylhsminor.yy272 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 344: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy272 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy209)))); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 351: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 352: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==352);
{ yylhsminor.yy272 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy209, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy209, yymsp[-1].minor.yy172)); }
  yymsp[-3].minor.yy272 = yylhsminor.yy272;
        break;
      case 353: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy272 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy272), yymsp[-1].minor.yy616)); }
  yymsp[-5].minor.yy272 = yylhsminor.yy272;
        break;
      case 355: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy272 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy209, NULL)); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 370: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy172 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 375: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 432: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==432);
{ yylhsminor.yy272 = createColumnNode(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 376: /* predicate ::= expression compare_op expression */
      case 381: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==381);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy272);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy272);
                                                                                    yylhsminor.yy272 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy392, releaseRawExprNode(pCxt, yymsp[-2].minor.yy272), releaseRawExprNode(pCxt, yymsp[0].minor.yy272)));
                                                                                  }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 377: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy272);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy272);
                                                                                    yylhsminor.yy272 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy272), releaseRawExprNode(pCxt, yymsp[-2].minor.yy272), releaseRawExprNode(pCxt, yymsp[0].minor.yy272)));
                                                                                  }
  yymsp[-4].minor.yy272 = yylhsminor.yy272;
        break;
      case 378: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy272);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy272);
                                                                                    yylhsminor.yy272 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy272), releaseRawExprNode(pCxt, yymsp[-2].minor.yy272), releaseRawExprNode(pCxt, yymsp[0].minor.yy272)));
                                                                                  }
  yymsp[-5].minor.yy272 = yylhsminor.yy272;
        break;
      case 379: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy272);
                                                                                    yylhsminor.yy272 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy272), NULL));
                                                                                  }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 380: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy272);
                                                                                    yylhsminor.yy272 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy272), NULL));
                                                                                  }
  yymsp[-3].minor.yy272 = yylhsminor.yy272;
        break;
      case 382: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy392 = OP_TYPE_LOWER_THAN; }
        break;
      case 383: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy392 = OP_TYPE_GREATER_THAN; }
        break;
      case 384: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy392 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 385: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy392 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 386: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy392 = OP_TYPE_NOT_EQUAL; }
        break;
      case 387: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy392 = OP_TYPE_EQUAL; }
        break;
      case 388: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy392 = OP_TYPE_LIKE; }
        break;
      case 389: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy392 = OP_TYPE_NOT_LIKE; }
        break;
      case 390: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy392 = OP_TYPE_MATCH; }
        break;
      case 391: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy392 = OP_TYPE_NMATCH; }
        break;
      case 392: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy392 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 393: /* in_op ::= IN */
{ yymsp[0].minor.yy392 = OP_TYPE_IN; }
        break;
      case 394: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy392 = OP_TYPE_NOT_IN; }
        break;
      case 395: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy272 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy172)); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 397: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy272);
                                                                                    yylhsminor.yy272 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy272), NULL));
                                                                                  }
  yymsp[-1].minor.yy272 = yylhsminor.yy272;
        break;
      case 398: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy272);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy272);
                                                                                    yylhsminor.yy272 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy272), releaseRawExprNode(pCxt, yymsp[0].minor.yy272)));
                                                                                  }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 399: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy272);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy272);
                                                                                    yylhsminor.yy272 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy272), releaseRawExprNode(pCxt, yymsp[0].minor.yy272)));
                                                                                  }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 405: /* from_clause_opt ::= FROM table_reference_list */
      case 434: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==434);
      case 457: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==457);
{ yymsp[-1].minor.yy272 = yymsp[0].minor.yy272; }
        break;
      case 407: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy272 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy272, yymsp[0].minor.yy272, NULL); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 410: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy272 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-1].minor.yy272 = yylhsminor.yy272;
        break;
      case 411: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy272 = createRealTableNode(pCxt, &yymsp[-3].minor.yy209, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-3].minor.yy272 = yylhsminor.yy272;
        break;
      case 412: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy272 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy272), &yymsp[0].minor.yy209); }
  yymsp[-1].minor.yy272 = yylhsminor.yy272;
        break;
      case 414: /* alias_opt ::= */
{ yymsp[1].minor.yy209 = nil_token;  }
        break;
      case 415: /* alias_opt ::= table_alias */
{ yylhsminor.yy209 = yymsp[0].minor.yy209; }
  yymsp[0].minor.yy209 = yylhsminor.yy209;
        break;
      case 416: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy209 = yymsp[0].minor.yy209; }
        break;
      case 417: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 418: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==418);
{ yymsp[-2].minor.yy272 = yymsp[-1].minor.yy272; }
        break;
      case 419: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy272 = createJoinTableNode(pCxt, yymsp[-4].minor.yy156, yymsp[-5].minor.yy272, yymsp[-2].minor.yy272, yymsp[0].minor.yy272); }
  yymsp[-5].minor.yy272 = yylhsminor.yy272;
        break;
      case 420: /* join_type ::= */
{ yymsp[1].minor.yy156 = JOIN_TYPE_INNER; }
        break;
      case 421: /* join_type ::= INNER */
{ yymsp[0].minor.yy156 = JOIN_TYPE_INNER; }
        break;
      case 422: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy272 = createSelectStmt(pCxt, yymsp[-10].minor.yy293, yymsp[-9].minor.yy172, yymsp[-8].minor.yy272);
                                                                                    yymsp[-11].minor.yy272 = addWhereClause(pCxt, yymsp[-11].minor.yy272, yymsp[-7].minor.yy272);
                                                                                    yymsp[-11].minor.yy272 = addPartitionByClause(pCxt, yymsp[-11].minor.yy272, yymsp[-6].minor.yy172);
                                                                                    yymsp[-11].minor.yy272 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy272, yymsp[-2].minor.yy272);
                                                                                    yymsp[-11].minor.yy272 = addGroupByClause(pCxt, yymsp[-11].minor.yy272, yymsp[-1].minor.yy172);
                                                                                    yymsp[-11].minor.yy272 = addHavingClause(pCxt, yymsp[-11].minor.yy272, yymsp[0].minor.yy272);
                                                                                    yymsp[-11].minor.yy272 = addRangeClause(pCxt, yymsp[-11].minor.yy272, yymsp[-5].minor.yy272);
                                                                                    yymsp[-11].minor.yy272 = addEveryClause(pCxt, yymsp[-11].minor.yy272, yymsp[-4].minor.yy272);
                                                                                    yymsp[-11].minor.yy272 = addFillClause(pCxt, yymsp[-11].minor.yy272, yymsp[-3].minor.yy272);
                                                                                  }
        break;
      case 425: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy293 = false; }
        break;
      case 428: /* select_item ::= NK_STAR */
{ yylhsminor.yy272 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 430: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy272 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy272), &yymsp[0].minor.yy209); }
  yymsp[-1].minor.yy272 = yylhsminor.yy272;
        break;
      case 431: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy272 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy272), &yymsp[0].minor.yy209); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 436: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 453: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==453);
      case 469: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==469);
{ yymsp[-2].minor.yy172 = yymsp[0].minor.yy172; }
        break;
      case 438: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy272 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy272), releaseRawExprNode(pCxt, yymsp[-1].minor.yy272)); }
        break;
      case 439: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy272 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy272)); }
        break;
      case 440: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy272 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy272), NULL, yymsp[-1].minor.yy272, yymsp[0].minor.yy272); }
        break;
      case 441: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy272 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy272), releaseRawExprNode(pCxt, yymsp[-3].minor.yy272), yymsp[-1].minor.yy272, yymsp[0].minor.yy272); }
        break;
      case 443: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 461: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==461);
{ yymsp[-3].minor.yy272 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy272); }
        break;
      case 445: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy272 = createFillNode(pCxt, yymsp[-1].minor.yy186, NULL); }
        break;
      case 446: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy272 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy172)); }
        break;
      case 447: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy186 = FILL_MODE_NONE; }
        break;
      case 448: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy186 = FILL_MODE_PREV; }
        break;
      case 449: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy186 = FILL_MODE_NULL; }
        break;
      case 450: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy186 = FILL_MODE_LINEAR; }
        break;
      case 451: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy186 = FILL_MODE_NEXT; }
        break;
      case 454: /* group_by_list ::= expression */
{ yylhsminor.yy172 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy272))); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 455: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy172 = addNodeToList(pCxt, yymsp[-2].minor.yy172, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy272))); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 459: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy272 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy272), releaseRawExprNode(pCxt, yymsp[-1].minor.yy272)); }
        break;
      case 462: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy272 = addOrderByClause(pCxt, yymsp[-3].minor.yy272, yymsp[-2].minor.yy172);
                                                                                    yylhsminor.yy272 = addSlimitClause(pCxt, yylhsminor.yy272, yymsp[-1].minor.yy272);
                                                                                    yylhsminor.yy272 = addLimitClause(pCxt, yylhsminor.yy272, yymsp[0].minor.yy272);
                                                                                  }
  yymsp[-3].minor.yy272 = yylhsminor.yy272;
        break;
      case 464: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy272 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy272, yymsp[0].minor.yy272); }
  yymsp[-3].minor.yy272 = yylhsminor.yy272;
        break;
      case 465: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy272 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy272, yymsp[0].minor.yy272); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 467: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ 
                                                                                    yymsp[-5].minor.yy272 = addOrderByClause(pCxt, yymsp[-4].minor.yy272, yymsp[-3].minor.yy172);
                                                                                    yymsp[-5].minor.yy272 = addSlimitClause(pCxt, yymsp[-5].minor.yy272, yymsp[-2].minor.yy272);
                                                                                    yymsp[-5].minor.yy272 = addLimitClause(pCxt, yymsp[-5].minor.yy272, yymsp[-1].minor.yy272);
                                                                                  }
        break;
      case 471: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 475: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==475);
{ yymsp[-1].minor.yy272 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 472: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 476: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==476);
{ yymsp[-3].minor.yy272 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 473: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 477: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==477);
{ yymsp[-3].minor.yy272 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 478: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy272 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy272); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 482: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy272 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy272), yymsp[-1].minor.yy818, yymsp[0].minor.yy493); }
  yymsp[-2].minor.yy272 = yylhsminor.yy272;
        break;
      case 483: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy818 = ORDER_ASC; }
        break;
      case 484: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy818 = ORDER_ASC; }
        break;
      case 485: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy818 = ORDER_DESC; }
        break;
      case 486: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy493 = NULL_ORDER_DEFAULT; }
        break;
      case 487: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy493 = NULL_ORDER_FIRST; }
        break;
      case 488: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy493 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
