/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 379
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy58;
  bool yy151;
  int8_t yy285;
  SNodeList* yy356;
  SToken yy361;
  SAlterOption yy409;
  int64_t yy457;
  EFillMode yy494;
  EJoinType yy504;
  EOperatorType yy526;
  SDataType yy600;
  ENullOrder yy613;
  SNode* yy616;
  int32_t yy734;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             669
#define YYNRULE              491
#define YYNTOKEN             256
#define YY_MAX_SHIFT         668
#define YY_MIN_SHIFTREDUCE   974
#define YY_MAX_SHIFTREDUCE   1464
#define YY_ERROR_ACTION      1465
#define YY_ACCEPT_ACTION     1466
#define YY_NO_ACTION         1467
#define YY_MIN_REDUCE        1468
#define YY_MAX_REDUCE        1958
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2547)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   532,   73, 1466,  436,  555,  437, 1503,  327,  520,   73,
 /*    10 */  1658,  115,   39,   37,  119,  142,  326,  312,  474, 1703,
 /*    20 */   340, 1469, 1264, 1601, 1608,  145, 1656,  555, 1606, 1562,
 /*    30 */  1810, 1602,  124, 1341,  444, 1262,  437, 1503,  548,  558,
 /*    40 */   345,  389,  105, 1651, 1653,  104,  103,  102,  101,  100,
 /*    50 */    99,   98,   97,   96,   81,  124, 1336, 1491, 1792,   33,
 /*    60 */    32,   14,  353,   40,   38,   36,   35,   34, 1270,   39,
 /*    70 */    37, 1404,  122,  558,  558, 1599,  547,  340,  303, 1264,
 /*    80 */  1936, 1290,  144, 1936, 1480,    1, 1810,  158, 1878, 1879,
 /*    90 */  1341, 1883, 1262,  162,  584,  122, 1935, 1933, 1761, 1761,
 /*   100 */  1933,  583,  435, 1936,   64,  439, 1289,  665,  532,  557,
 /*   110 */   157, 1878, 1879, 1336, 1883,  560,  161, 1290,   14,   55,
 /*   120 */  1933, 1343, 1344,   30,  261, 1270, 1824,  131,  155,  221,
 /*   130 */    91, 1793,  586, 1795, 1796,  582, 1606,  577,   43,   42,
 /*   140 */  1870, 1645,    2,  105,  306, 1866,  104,  103,  102,  101,
 /*   150 */   100,   99,   98,   97,   96,  343, 1936,   40,   38,   36,
 /*   160 */    35,   34, 1080,  142,  665,   63, 1265,  195, 1263,  163,
 /*   170 */    54,   63, 1608, 1933,  383,  519,  351,  443, 1343, 1344,
 /*   180 */   439,  148, 1160, 1161, 1401,   63,  470,  466,  462,  458,
 /*   190 */   194, 1243, 1244, 1268, 1269, 1082, 1318, 1319, 1321, 1322,
 /*   200 */  1323, 1324, 1325, 1326,  579,  575, 1334, 1335, 1337, 1338,
 /*   210 */  1339, 1340, 1342, 1345, 1936, 1936, 1936, 1936,   74, 1652,
 /*   220 */  1653,  192, 1024, 1265, 1023, 1263,  164,  162,  161,  161,
 /*   230 */   161, 1933, 1933, 1933, 1933,   33,   32,  350,   63,   40,
 /*   240 */    38,   36,   35,   34, 1490,  382,  171,  381,  555,  564,
 /*   250 */  1268, 1269, 1025, 1318, 1319, 1321, 1322, 1323, 1324, 1325,
 /*   260 */  1326,  579,  575, 1334, 1335, 1337, 1338, 1339, 1340, 1342,
 /*   270 */  1345,   39,   37, 1468,   71, 1289,  124,   70, 1936,  340,
 /*   280 */   164, 1264, 1792,  191,  184, 1761,  189, 1584,  307,   49,
 /*   290 */   449,  161, 1341,  453, 1262, 1933,  532,  114,  113,  112,
 /*   300 */   111,  110,  109,  108,  107,  106,  164,  115, 1289,  182,
 /*   310 */  1810, 1489,  164, 1303,  479, 1336,  122, 1936,  559,  505,
 /*   320 */    14, 1363, 1488, 1761, 1606,  583,  164, 1270,   39,   37,
 /*   330 */  1934,  159, 1878, 1879, 1933, 1883,  340,  532, 1264, 1530,
 /*   340 */   317,  485,  484, 1425,    2,  478, 1658,  453,  166, 1341,
 /*   350 */  1824, 1262, 1761,  328,   92, 1793,  586, 1795, 1796,  582,
 /*   360 */  1936,  577, 1656, 1761, 1870, 1606,  665,  477,  331, 1866,
 /*   370 */   156, 1582, 1336,  161,  549, 1364, 1658, 1933, 1291,  164,
 /*   380 */  1343, 1344,  160,  344, 1270,  541, 1423, 1424, 1426, 1427,
 /*   390 */  1896,  318, 1656,  316,  315, 1702,  476,  300, 1369, 1706,
 /*   400 */   478,    8,  642,  641,  640,  639,  348, 1400,  638,  637,
 /*   410 */   636,  125,  631,  630,  629,  628,  627,  626,  625,  624,
 /*   420 */   135,  620,  477,  665, 1024, 1265, 1023, 1263,   33,   32,
 /*   430 */   164,  619,   40,   38,   36,   35,   34, 1343, 1344,  472,
 /*   440 */  1007,   29,  338, 1358, 1359, 1360, 1361, 1362, 1366, 1367,
 /*   450 */  1368,  565, 1268, 1269, 1025, 1318, 1319, 1321, 1322, 1323,
 /*   460 */  1324, 1325, 1326,  579,  575, 1334, 1335, 1337, 1338, 1339,
 /*   470 */  1340, 1342, 1345, 1583,  216,  222,  223,  489,  488,  487,
 /*   480 */  1011, 1012, 1265,  486, 1263, 1320,  120,  483,  635,  633,
 /*   490 */   482,  481,  480,   33,   32, 1533, 1779,   40,   38,   36,
 /*   500 */    35,   34,  209,   63,  619,   77, 1487, 1775,  422, 1268,
 /*   510 */  1269,  253, 1318, 1319, 1321, 1322, 1323, 1324, 1325, 1326,
 /*   520 */   579,  575, 1334, 1335, 1337, 1338, 1339, 1340, 1342, 1345,
 /*   530 */    39,   37, 1346, 1771, 1777,  329,  305,  441,  340,  522,
 /*   540 */  1264, 1792,  164, 1287,  215,  577,  307, 1761, 1701,  346,
 /*   550 */   300, 1341,  532, 1262,  175,  174, 1509,  142,  489,  488,
 /*   560 */   487,   75,  305,  387,  486,  522, 1608,  120,  483, 1810,
 /*   570 */   617,  482,  481,  480, 1336,   76, 1365,  559, 1461, 1363,
 /*   580 */  1606,  544, 1761,  494,  583, 1658, 1270,   39,   37,  133,
 /*   590 */   132,  614,  613,  612,  532,  340,  532, 1264,  504, 1370,
 /*   600 */  1696, 1657,  567,    9,  660,  388,  503,  392, 1341, 1824,
 /*   610 */  1262,  173,  208,   92, 1793,  586, 1795, 1796,  582,  501,
 /*   620 */   577,  499, 1606, 1870, 1606,  665,  497,  331, 1866,  156,
 /*   630 */   491, 1336,  374, 1364, 1597,  207,  532,  532, 1288, 1343,
 /*   640 */  1344, 1779,   27, 1270,  164, 1775,   88,  407,  408, 1897,
 /*   650 */  1595, 1408, 1775, 1486,  376,  372, 1369, 1289, 1270,  121,
 /*   660 */     9,  550,  545,   58, 1606, 1606,   57, 1598, 1460,   33,
 /*   670 */    32, 1771, 1777,   40,   38,   36,   35,   34, 1771, 1777,
 /*   680 */   335,  520,  665,  577, 1265, 1351, 1263,   36,   35,   34,
 /*   690 */   577, 1289, 1704, 1485, 1761,  611, 1343, 1344, 1581,   29,
 /*   700 */   338, 1358, 1359, 1360, 1361, 1362, 1366, 1367, 1368,   11,
 /*   710 */    10, 1268, 1269,   61, 1318, 1319, 1321, 1322, 1323, 1324,
 /*   720 */  1325, 1326,  579,  575, 1334, 1335, 1337, 1338, 1339, 1340,
 /*   730 */  1342, 1345,   33,   32, 1761, 1885,   40,   38,   36,   35,
 /*   740 */    34, 1265,  615, 1263,  623, 1649, 1578, 1435, 1118,  608,
 /*   750 */   607,  606, 1122,  605, 1124, 1125,  604, 1127,  601, 1882,
 /*   760 */  1133,  598, 1135, 1136,  595,  592, 1484,   22, 1268, 1269,
 /*   770 */  1483, 1318, 1319, 1321, 1322, 1323, 1324, 1325, 1326,  579,
 /*   780 */   575, 1334, 1335, 1337, 1338, 1339, 1340, 1342, 1345,   39,
 /*   790 */    37,  302, 1051, 1287, 1377,  617,  142,  340,  532, 1264,
 /*   800 */   415, 1792,  532,  427,  622, 1609,  568, 1761,  532,  452,
 /*   810 */  1341, 1761, 1262, 1603,  133,  132,  614,  613,  612, 1735,
 /*   820 */   400,  532,  428, 1747,  402, 1052, 1606,  532,  532, 1810,
 /*   830 */  1606, 1292,  513, 1336, 1320,    7, 1606,  584,  517,  530,
 /*   840 */  1482, 1479, 1761,  634,  583, 1270,   33,   32,   87, 1606,
 /*   850 */    40,   38,   36,   35,   34, 1606, 1606,  393,   84,   33,
 /*   860 */    32,  532,    2,   40,   38,   36,   35,   34, 1320, 1824,
 /*   870 */   362,  617,  531,   93, 1793,  586, 1795, 1796,  582, 1591,
 /*   880 */   577, 1761, 1761, 1870,  665, 1478,  377, 1869, 1866, 1606,
 /*   890 */   133,  132,  614,  613,  612,   44,    4,  426, 1343, 1344,
 /*   900 */   421,  420,  419,  418,  417,  414,  413,  412,  411,  410,
 /*   910 */   406,  405,  404,  403,  397,  396,  395,  394, 1885,  391,
 /*   920 */   390, 1593, 1477,   26, 1415, 1885, 1761,  143, 1589,   33,
 /*   930 */    32, 1476,  279,   40,   38,   36,   35,   34, 1011, 1012,
 /*   940 */  1273,  532, 1881, 1265,  212, 1263,  277,   60,   28, 1880,
 /*   950 */    59,  512,  262,  562,   33,   32, 1475,   41,   40,   38,
 /*   960 */    36,   35,   34, 1761,  233, 1792,  178,  432,  430, 1606,
 /*   970 */  1268, 1269, 1761, 1318, 1319, 1321, 1322, 1323, 1324, 1325,
 /*   980 */  1326,  579,  575, 1334, 1335, 1337, 1338, 1339, 1340, 1342,
 /*   990 */  1345,  668,  532, 1810,   63,  273,  616, 1761, 1636, 1649,
 /*  1000 */  1211,  584,  578,  347,  141,  268, 1761, 1474,  583, 1473,
 /*  1010 */    33,   32, 1472, 1471,   40,   38,   36,   35,   34,  153,
 /*  1020 */  1606, 1397,  560, 1520,  658,  654,  650,  646,  266, 1272,
 /*  1030 */  1890, 1397,   90, 1824,   53,  516, 1782,   91, 1793,  586,
 /*  1040 */  1795, 1796,  582,  220,  577,  490, 1792, 1870, 1761, 1515,
 /*  1050 */  1761,  306, 1866, 1761, 1761,  200,   89, 1513,  198,  231,
 /*  1060 */   337,  336,  202, 1936,  127,  201,  573,   68,   67,  386,
 /*  1070 */  1278,  492,  170, 1276, 1810, 1784,  161,  610,  380,  495,
 /*  1080 */  1933, 1341,  584, 1271,  130, 1481,  224, 1761, 1303,  583,
 /*  1090 */  1563,  301,  529,  256,  370,  131,  368,  364,  360,  167,
 /*  1100 */   355,  352, 1780,  204, 1336,  206,  203,  525,  205,   51,
 /*  1110 */    41,  237,  542, 1775, 1824,   51, 1270,   41,   92, 1793,
 /*  1120 */   586, 1795, 1796,  582,  218,  577,  590,  230, 1870,   11,
 /*  1130 */    10,  471,  331, 1866, 1949,  164, 1792, 1811, 1111, 1771,
 /*  1140 */  1777, 1463, 1464, 1904,  130, 1235,  131,  211,  116,  506,
 /*  1150 */   130,  577, 1422, 1327,  240,  572,  245,  349, 1371, 1504,
 /*  1160 */   272, 1646, 1275, 1900, 1810,  556,  250,    3,  255, 1139,
 /*  1170 */   258,    5,  584,  260,  354, 1287,  361, 1761,  357,  583,
 /*  1180 */   313, 1080, 1227,  314,  269,  409, 1698, 1143,  424, 1150,
 /*  1190 */   172, 1148, 1792,  134,  416,  423,  425,  429, 1355,  431,
 /*  1200 */   434,  433, 1293,  442, 1824, 1296,  445,  181,   93, 1793,
 /*  1210 */   586, 1795, 1796,  582, 1279,  577, 1274,  446, 1870,  183,
 /*  1220 */  1810, 1295,  571, 1866, 1297,  448,  186,  447,  584,  188,
 /*  1230 */  1294,  450,  451, 1761, 1792,  583,  190,  454,   72,  193,
 /*  1240 */   473, 1282, 1284,  475, 1596,   95,  197, 1592,  199,  136,
 /*  1250 */   137, 1594,  304,  575, 1334, 1335, 1337, 1338, 1339, 1340,
 /*  1260 */  1824, 1590, 1810,  138,   92, 1793,  586, 1795, 1796,  582,
 /*  1270 */   584,  577,  139,  270, 1870, 1761,  210,  583,  331, 1866,
 /*  1280 */  1949, 1740,  507,  540,  511,  526,  213, 1792,  217, 1927,
 /*  1290 */   508,  514,  518,  521,  128,  323, 1739, 1792, 1708,  523,
 /*  1300 */   129,  325, 1824,  226,  527,  528,   92, 1793,  586, 1795,
 /*  1310 */  1796,  582,  228,  577,  271, 1810, 1870, 1607, 1292,  543,
 /*  1320 */   331, 1866, 1949,  584,   80, 1810,  536,  538, 1761,  539,
 /*  1330 */   583, 1889, 1264,  584, 1901,  330,  546,    6, 1761,  534,
 /*  1340 */   583,  235,  244,  239,  552, 1262,  537, 1792, 1397, 1911,
 /*  1350 */  1910,  150,  535,  123,  560, 1824, 1291, 1792, 1892,  280,
 /*  1360 */  1793,  586, 1795, 1796,  582, 1824,  577,  249,  246,  286,
 /*  1370 */  1793,  586, 1795, 1796,  582, 1810,  577,  569, 1270,  332,
 /*  1380 */  1886,  566, 1932,  584,  254, 1810,  563,  257, 1761, 1952,
 /*  1390 */   583,   48,   82,  581,  247, 1936, 1650,  248, 1761, 1579,
 /*  1400 */   583,  274,  265, 1851,  560,  588,  661,  570,  163,  662,
 /*  1410 */   664,  259, 1933,   52,  149, 1824,  278,  665, 1755,  286,
 /*  1420 */  1793,  586, 1795, 1796,  582, 1824,  577,  276, 1754,  294,
 /*  1430 */  1793,  586, 1795, 1796,  582,  580,  577,  574, 1842, 1792,
 /*  1440 */   555,  287,  297,  296,   65, 1936, 1753, 1752,   66, 1751,
 /*  1450 */   356, 1748,  358,  359, 1255, 1256,  168,  363,  161, 1746,
 /*  1460 */   365,  366, 1933,  367, 1745,  369, 1744, 1810,  124, 1743,
 /*  1470 */   371, 1742,  373,  375, 1725,  584, 1265,  169, 1263,  378,
 /*  1480 */  1761,  379,  583, 1230, 1229, 1719, 1718,  384,  385,  560,
 /*  1490 */  1717, 1716, 1691, 1792, 1199, 1690, 1689,   69, 1688, 1687,
 /*  1500 */  1686, 1685, 1684, 1268, 1269,  398, 1683, 1824,  122,  401,
 /*  1510 */   399,  146, 1793,  586, 1795, 1796,  582, 1792,  577, 1682,
 /*  1520 */  1681, 1810,  126,  251, 1878,  554, 1680,  553, 1679,  584,
 /*  1530 */  1936, 1678, 1677, 1676, 1761, 1675,  583, 1674, 1673, 1672,
 /*  1540 */  1671, 1670, 1669,  163, 1668, 1810, 1667, 1933, 1666, 1665,
 /*  1550 */   324, 1664, 1663,  584,  117,  561, 1950, 1662, 1761, 1661,
 /*  1560 */   583, 1824, 1660, 1659, 1535,   93, 1793,  586, 1795, 1796,
 /*  1570 */   582, 1792,  577,  176, 1534, 1870, 1201,  177, 1532, 1500,
 /*  1580 */  1867, 1792, 1014, 1013, 1499, 1824,  154,  179, 1733,  295,
 /*  1590 */  1793,  586, 1795, 1796,  582, 1727,  577, 1715,  180, 1810,
 /*  1600 */   118,  438,  440, 1714,  533,  185, 1700,  584, 1585, 1810,
 /*  1610 */   187, 1531, 1761, 1529,  583, 1044,  455,  584,  456,  457,
 /*  1620 */  1527,  459, 1761,  460,  583, 1525,  461, 1523,  463,  465,
 /*  1630 */   464, 1792,  468,  467, 1512,  469, 1511, 1496, 1587, 1824,
 /*  1640 */  1154,   50,  196,  295, 1793,  586, 1795, 1796,  582, 1824,
 /*  1650 */   577, 1153, 1586,  290, 1793,  586, 1795, 1796,  582, 1810,
 /*  1660 */   577, 1079,  632, 1078,  634, 1077, 1076,  584, 1073, 1071,
 /*  1670 */  1072, 1521, 1761,  319,  583, 1070, 1516,  320, 1514,  321,
 /*  1680 */   496, 1792, 1495,  498, 1494,  500, 1493,  502,  493,   94,
 /*  1690 */  1732,  551,  509, 1792, 1237, 1726,  140, 1713, 1711, 1824,
 /*  1700 */  1712, 1710, 1709,  146, 1793,  586, 1795, 1796,  582, 1810,
 /*  1710 */   577, 1247, 1707,   56, 1699,   41,  227,  581,  510,   84,
 /*  1720 */   214, 1810, 1761,   16,  583,  232,  339,   15,  322,  584,
 /*  1730 */   219,  225,  515,  243, 1761, 1437,  583,   47,   78,   79,
 /*  1740 */   524,   23,  242,  229,  236,  234,   25, 1419, 1951, 1824,
 /*  1750 */  1421,  238,  147,  294, 1793,  586, 1795, 1796,  582,  241,
 /*  1760 */   577, 1824, 1843, 1782,   17,  295, 1793,  586, 1795, 1796,
 /*  1770 */   582, 1792,  577,   24,  252, 1414,   83,   46, 1781, 1394,
 /*  1780 */  1449, 1792, 1393,  151,   18, 1448,  333, 1453, 1452,   10,
 /*  1790 */  1454,   45, 1443,  334, 1280, 1356, 1827, 1311,   19, 1810,
 /*  1800 */   589, 1331, 1329,   13,  341,  576,   31,  584, 1328, 1810,
 /*  1810 */   152,   12, 1761,  165,  583,   20,   21,  584,  585,  587,
 /*  1820 */   342, 1140, 1761,  591,  583, 1137,  593,  594,  596, 1134,
 /*  1830 */  1128, 1792,  597,  599,  600,  602, 1132, 1117, 1131, 1824,
 /*  1840 */  1149, 1792, 1126,  295, 1793,  586, 1795, 1796,  582, 1824,
 /*  1850 */   577, 1792,  263,  281, 1793,  586, 1795, 1796,  582, 1810,
 /*  1860 */   577,  603,   85,  609,   86,   62, 1130,  584, 1129, 1810,
 /*  1870 */  1145,  618, 1761, 1042,  583, 1086, 1067,  584,  621, 1810,
 /*  1880 */   264, 1065, 1761, 1062,  583, 1064, 1063,  584, 1061, 1060,
 /*  1890 */  1059, 1058, 1761, 1083,  583, 1081, 1048, 1055, 1054, 1824,
 /*  1900 */  1053, 1050, 1528,  282, 1793,  586, 1795, 1796,  582, 1824,
 /*  1910 */   577, 1049, 1047,  289, 1793,  586, 1795, 1796,  582, 1824,
 /*  1920 */   577,  643,  644,  291, 1793,  586, 1795, 1796,  582,  645,
 /*  1930 */   577, 1526, 1792,  647,  648,  649, 1524, 1522,  651,  652,
 /*  1940 */   653,  655,  656,  657, 1510,  659, 1004, 1492,  267,  663,
 /*  1950 */   666, 1792, 1266,  667,  275, 1467, 1467, 1467, 1467, 1467,
 /*  1960 */  1810, 1467, 1467, 1467, 1467, 1467, 1467, 1467,  584, 1467,
 /*  1970 */  1467, 1467, 1467, 1761, 1467,  583, 1467, 1467, 1467, 1810,
 /*  1980 */  1467, 1467, 1467, 1467, 1467, 1467, 1467,  584, 1467, 1467,
 /*  1990 */  1467, 1467, 1761, 1467,  583, 1467, 1467, 1467, 1467, 1467,
 /*  2000 */  1824, 1467, 1467, 1467,  283, 1793,  586, 1795, 1796,  582,
 /*  2010 */  1467,  577, 1467, 1792, 1467, 1467, 1467, 1467, 1467, 1824,
 /*  2020 */  1467, 1467, 1467,  292, 1793,  586, 1795, 1796,  582, 1792,
 /*  2030 */   577, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467,
 /*  2040 */  1467, 1810, 1467, 1467, 1467, 1467, 1467, 1467, 1467,  584,
 /*  2050 */  1467, 1467, 1467, 1467, 1761, 1467,  583, 1810, 1467, 1467,
 /*  2060 */  1467, 1467, 1467, 1467, 1467,  584, 1467, 1467, 1467, 1467,
 /*  2070 */  1761, 1467,  583, 1467, 1467, 1467, 1467, 1467, 1467, 1467,
 /*  2080 */  1467, 1824, 1792, 1467, 1467,  284, 1793,  586, 1795, 1796,
 /*  2090 */   582, 1467,  577, 1467, 1467, 1467, 1467, 1824, 1467, 1792,
 /*  2100 */  1467,  293, 1793,  586, 1795, 1796,  582, 1467,  577, 1467,
 /*  2110 */  1810, 1467, 1467, 1467, 1467, 1467, 1467, 1467,  584, 1467,
 /*  2120 */  1467, 1467, 1467, 1761, 1467,  583, 1467, 1810, 1467, 1467,
 /*  2130 */  1467, 1467, 1467, 1467, 1467,  584, 1467, 1467, 1467, 1467,
 /*  2140 */  1761, 1467,  583, 1467, 1467, 1467, 1467, 1467, 1467, 1467,
 /*  2150 */  1824, 1467, 1792, 1467,  285, 1793,  586, 1795, 1796,  582,
 /*  2160 */  1467,  577, 1467, 1467, 1792, 1467, 1467, 1824, 1467, 1467,
 /*  2170 */  1467,  298, 1793,  586, 1795, 1796,  582, 1467,  577, 1467,
 /*  2180 */  1810, 1467, 1467, 1467, 1467, 1467, 1467, 1467,  584, 1467,
 /*  2190 */  1467, 1467, 1810, 1761, 1467,  583, 1467, 1467, 1467, 1467,
 /*  2200 */   584, 1467, 1467, 1467, 1467, 1761, 1467,  583, 1467, 1467,
 /*  2210 */  1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467,
 /*  2220 */  1824, 1467, 1467, 1467,  299, 1793,  586, 1795, 1796,  582,
 /*  2230 */  1467,  577, 1824, 1792, 1467, 1467, 1804, 1793,  586, 1795,
 /*  2240 */  1796,  582, 1467,  577, 1467, 1467, 1467, 1792, 1467, 1467,
 /*  2250 */  1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467,
 /*  2260 */  1467, 1810, 1467, 1467, 1467, 1467, 1467, 1467, 1467,  584,
 /*  2270 */  1467, 1467, 1467, 1467, 1761, 1810,  583, 1467, 1467, 1467,
 /*  2280 */  1467, 1467, 1467,  584, 1467, 1467, 1467, 1467, 1761, 1792,
 /*  2290 */   583, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467,
 /*  2300 */  1467, 1824, 1467, 1467, 1467, 1803, 1793,  586, 1795, 1796,
 /*  2310 */   582, 1467,  577, 1467, 1467, 1824, 1467, 1810, 1467, 1802,
 /*  2320 */  1793,  586, 1795, 1796,  582,  584,  577, 1467, 1467, 1467,
 /*  2330 */  1761, 1467,  583, 1467, 1467, 1467, 1467, 1467, 1467, 1467,
 /*  2340 */  1467, 1792, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467,
 /*  2350 */  1467, 1467, 1467, 1467, 1467, 1467, 1467, 1824, 1467, 1792,
 /*  2360 */  1467,  310, 1793,  586, 1795, 1796,  582, 1467,  577, 1810,
 /*  2370 */  1467, 1467, 1467, 1467, 1467, 1467, 1467,  584, 1467, 1467,
 /*  2380 */  1467, 1467, 1761, 1792,  583, 1467, 1467, 1810, 1467, 1467,
 /*  2390 */  1467, 1467, 1467, 1467, 1467,  584, 1467, 1467, 1467, 1467,
 /*  2400 */  1761, 1467,  583, 1467, 1467, 1467, 1467, 1467, 1467, 1824,
 /*  2410 */  1467, 1810, 1467,  309, 1793,  586, 1795, 1796,  582,  584,
 /*  2420 */   577, 1467, 1467, 1467, 1761, 1467,  583, 1824, 1467, 1467,
 /*  2430 */  1467,  311, 1793,  586, 1795, 1796,  582, 1467,  577,  555,
 /*  2440 */  1792, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467,
 /*  2450 */  1467, 1824, 1467, 1467, 1467,  308, 1793,  586, 1795, 1796,
 /*  2460 */   582, 1467,  577, 1467, 1467, 1467, 1467,  124, 1810, 1467,
 /*  2470 */  1467, 1467, 1467, 1467, 1467, 1467,  584, 1467, 1467, 1467,
 /*  2480 */  1467, 1761, 1467,  583, 1467, 1467, 1467, 1467,  560, 1467,
 /*  2490 */  1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467,
 /*  2500 */  1467, 1467, 1467, 1467, 1467, 1467, 1467,  122, 1824, 1467,
 /*  2510 */  1467, 1467,  288, 1793,  586, 1795, 1796,  582, 1467,  577,
 /*  2520 */  1467, 1467,  251, 1878,  554, 1467,  553, 1467, 1467, 1936,
 /*  2530 */  1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467,
 /*  2540 */  1467, 1467,  161, 1467, 1467, 1467, 1933,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   267,  271,  256,  263,  267,  265,  266,  279,  302,  271,
 /*    10 */   287,  278,   12,   13,  284,  287,  310,  294,  285,  313,
 /*    20 */    20,    0,   22,  293,  296,  272,  303,  267,  295,  276,
 /*    30 */   287,  293,  295,   33,  263,   35,  265,  266,  295,   20,
 /*    40 */   298,  267,   21,  301,  302,   24,   25,   26,   27,   28,
 /*    50 */    29,   30,   31,   32,  269,  295,   56,  259,  259,    8,
 /*    60 */     9,   61,  316,   12,   13,   14,   15,   16,   68,   12,
 /*    70 */    13,   14,  335,   20,   20,  290,  333,   20,  304,   22,
 /*    80 */   357,   20,  258,  357,  260,   85,  287,  350,  351,  352,
 /*    90 */    33,  354,   35,  370,  295,  335,  370,  374,  300,  300,
 /*   100 */   374,  302,  264,  357,    4,  267,   20,  107,  267,  349,
 /*   110 */   350,  351,  352,   56,  354,  316,  370,   20,   61,  278,
 /*   120 */   374,  121,  122,  342,  343,   68,  327,   43,  286,  116,
 /*   130 */   331,  332,  333,  334,  335,  336,  295,  338,   85,   85,
 /*   140 */   341,  299,   85,   21,  345,  346,   24,   25,   26,   27,
 /*   150 */    28,   29,   30,   31,   32,  279,  357,   12,   13,   14,
 /*   160 */    15,   16,   35,  287,  107,   85,  166,   33,  168,  370,
 /*   170 */    86,   85,  296,  374,  316,  316,  316,  264,  121,  122,
 /*   180 */   267,   47,  121,  122,    4,   85,   52,   53,   54,   55,
 /*   190 */    56,  178,  179,  193,  194,   68,  196,  197,  198,  199,
 /*   200 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,  357,  357,  357,  357,   84,  301,
 /*   220 */   302,   87,   20,  166,   22,  168,  226,  370,  370,  370,
 /*   230 */   370,  374,  374,  374,  374,    8,    9,  316,   85,   12,
 /*   240 */    13,   14,   15,   16,  259,  165,   56,  167,  267,   43,
 /*   250 */   193,  194,   50,  196,  197,  198,  199,  200,  201,  202,
 /*   260 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*   270 */   213,   12,   13,    0,   84,   20,  295,   87,  357,   20,
 /*   280 */   226,   22,  259,  149,  150,  300,  152,    0,   61,   85,
 /*   290 */   156,  370,   33,   60,   35,  374,  267,   24,   25,   26,
 /*   300 */    27,   28,   29,   30,   31,   32,  226,  278,   20,  175,
 /*   310 */   287,  259,  226,   86,  285,   56,  335,  357,  295,  316,
 /*   320 */    61,   94,  259,  300,  295,  302,  226,   68,   12,   13,
 /*   330 */   370,  350,  351,  352,  374,  354,   20,  267,   22,    0,
 /*   340 */    37,  273,  274,  193,   85,   97,  287,   60,  278,   33,
 /*   350 */   327,   35,  300,  294,  331,  332,  333,  334,  335,  336,
 /*   360 */   357,  338,  303,  300,  341,  295,  107,  119,  345,  346,
 /*   370 */   347,    0,   56,  370,   20,  148,  287,  374,   20,  226,
 /*   380 */   121,  122,  359,  294,   68,  235,  236,  237,  238,  239,
 /*   390 */   367,   88,  303,   90,   91,  312,   93,  314,  171,    0,
 /*   400 */    97,   85,   63,   64,   65,   66,   67,  227,   69,   70,
 /*   410 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   420 */    81,   82,  119,  107,   20,  166,   22,  168,    8,    9,
 /*   430 */   226,   60,   12,   13,   14,   15,   16,  121,  122,   35,
 /*   440 */     4,  214,  215,  216,  217,  218,  219,  220,  221,  222,
 /*   450 */   223,  245,  193,  194,   50,  196,  197,  198,  199,  200,
 /*   460 */   201,  202,  203,  204,  205,  206,  207,  208,  209,  210,
 /*   470 */   211,  212,  213,    0,   56,  116,  117,   63,   64,   65,
 /*   480 */    44,   45,  166,   69,  168,  197,   72,   73,  273,  274,
 /*   490 */    76,   77,   78,    8,    9,    0,  289,   12,   13,   14,
 /*   500 */    15,   16,  117,   85,   60,   87,  259,  300,   79,  193,
 /*   510 */   194,  153,  196,  197,  198,  199,  200,  201,  202,  203,
 /*   520 */   204,  205,  206,  207,  208,  209,  210,  211,  212,  213,
 /*   530 */    12,   13,   14,  326,  327,  328,  177,   14,   20,  180,
 /*   540 */    22,  259,  226,   20,   56,  338,   61,  300,  312,  279,
 /*   550 */   314,   33,  267,   35,  125,  126,    0,  287,   63,   64,
 /*   560 */    65,  176,  177,  278,   69,  180,  296,   72,   73,  287,
 /*   570 */    97,   76,   77,   78,   56,   87,  148,  295,  158,   94,
 /*   580 */   295,  151,  300,    4,  302,  287,   68,   12,   13,  116,
 /*   590 */   117,  118,  119,  120,  267,   20,  267,   22,   19,  171,
 /*   600 */   295,  303,   43,   85,   48,  278,   21,  278,   33,  327,
 /*   610 */    35,  306,   33,  331,  332,  333,  334,  335,  336,   34,
 /*   620 */   338,   36,  295,  341,  295,  107,   47,  345,  346,  347,
 /*   630 */    51,   56,  161,  148,  289,   56,  267,  267,   20,  121,
 /*   640 */   122,  289,  214,   68,  226,  300,  269,  278,  278,  367,
 /*   650 */   288,   14,  300,  259,  183,  184,  171,   20,   68,  282,
 /*   660 */    85,  231,  232,   84,  295,  295,   87,  290,  248,    8,
 /*   670 */     9,  326,  327,   12,   13,   14,   15,   16,  326,  327,
 /*   680 */   328,  302,  107,  338,  166,   14,  168,   14,   15,   16,
 /*   690 */   338,   20,  313,  259,  300,   96,  121,  122,    0,  214,
 /*   700 */   215,  216,  217,  218,  219,  220,  221,  222,  223,    1,
 /*   710 */     2,  193,  194,    3,  196,  197,  198,  199,  200,  201,
 /*   720 */   202,  203,  204,  205,  206,  207,  208,  209,  210,  211,
 /*   730 */   212,  213,    8,    9,  300,  329,   12,   13,   14,   15,
 /*   740 */    16,  166,  297,  168,  275,  300,  277,   86,   98,   99,
 /*   750 */   100,  101,  102,  103,  104,  105,  106,  107,  108,  353,
 /*   760 */   110,  111,  112,  113,  114,  115,  259,   43,  193,  194,
 /*   770 */   259,  196,  197,  198,  199,  200,  201,  202,  203,  204,
 /*   780 */   205,  206,  207,  208,  209,  210,  211,  212,  213,   12,
 /*   790 */    13,   18,   35,   20,   86,   97,  287,   20,  267,   22,
 /*   800 */    27,  259,  267,   30,   68,  296,  247,  300,  267,  278,
 /*   810 */    33,  300,   35,  278,  116,  117,  118,  119,  120,  278,
 /*   820 */    47,  267,   49,    0,   51,   68,  295,  267,  267,  287,
 /*   830 */   295,   20,  278,   56,  197,   39,  295,  295,  278,  278,
 /*   840 */   259,  259,  300,   43,  302,   68,    8,    9,   85,  295,
 /*   850 */    12,   13,   14,   15,   16,  295,  295,   84,   95,    8,
 /*   860 */     9,  267,   85,   12,   13,   14,   15,   16,  197,  327,
 /*   870 */    47,   97,  278,  331,  332,  333,  334,  335,  336,  288,
 /*   880 */   338,  300,  300,  341,  107,  259,   86,  345,  346,  295,
 /*   890 */   116,  117,  118,  119,  120,   42,   43,  124,  121,  122,
 /*   900 */   127,  128,  129,  130,  131,  132,  133,  134,  135,  136,
 /*   910 */   137,  138,  139,  140,  141,  142,  143,  144,  329,  146,
 /*   920 */   147,  288,  259,    2,   86,  329,  300,   18,  288,    8,
 /*   930 */     9,  259,   23,   12,   13,   14,   15,   16,   44,   45,
 /*   940 */    35,  267,  353,  166,  288,  168,   37,   38,    2,  353,
 /*   950 */    41,  320,  278,  243,    8,    9,  259,   43,   12,   13,
 /*   960 */    14,   15,   16,  300,  153,  259,   57,   58,   59,  295,
 /*   970 */   193,  194,  300,  196,  197,  198,  199,  200,  201,  202,
 /*   980 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*   990 */   213,   19,  267,  287,   85,  280,  297,  300,  283,  300,
 /*  1000 */    86,  295,  288,  278,  153,   33,  300,  259,  302,  259,
 /*  1010 */     8,    9,  259,  259,   12,   13,   14,   15,   16,   47,
 /*  1020 */   295,  225,  316,    0,   52,   53,   54,   55,   56,   35,
 /*  1030 */   224,  225,  123,  327,  153,  154,   46,  331,  332,  333,
 /*  1040 */   334,  335,  336,   43,  338,   22,  259,  341,  300,    0,
 /*  1050 */   300,  345,  346,  300,  300,   89,   84,    0,   92,   87,
 /*  1060 */    12,   13,   89,  357,   43,   92,   61,  158,  159,  160,
 /*  1070 */    22,   22,  163,  168,  287,   85,  370,  288,  169,   22,
 /*  1080 */   374,   33,  295,   35,   43,  260,   86,  300,   86,  302,
 /*  1090 */   276,  182,  120,  377,  185,   43,  187,  188,  189,  190,
 /*  1100 */   191,  192,  289,   89,   56,   89,   92,   86,   92,   43,
 /*  1110 */    43,   43,  368,  300,  327,   43,   68,   43,  331,  332,
 /*  1120 */   333,  334,  335,  336,  152,  338,   43,   86,  341,    1,
 /*  1130 */     2,  268,  345,  346,  347,  226,  259,  287,   86,  326,
 /*  1140 */   327,  121,  122,  356,   43,  173,   43,  175,   43,  323,
 /*  1150 */    43,  338,   86,   86,   86,  107,  364,  268,   86,  266,
 /*  1160 */    86,  299,  168,  330,  287,  355,  348,  358,  371,   86,
 /*  1170 */   371,  228,  295,  371,  325,   20,   47,  300,  267,  302,
 /*  1180 */   324,   35,  164,  273,  318,  267,  267,   86,  148,   86,
 /*  1190 */    42,   86,  259,   86,  307,  305,  305,  267,  193,  267,
 /*  1200 */   261,  267,   20,  261,  327,   20,  322,  271,  331,  332,
 /*  1210 */   333,  334,  335,  336,  166,  338,  168,  302,  341,  271,
 /*  1220 */   287,   20,  345,  346,   20,  317,  271,  315,  295,  271,
 /*  1230 */    20,  315,  308,  300,  259,  302,  271,  267,  271,  271,
 /*  1240 */   261,  193,  194,  287,  287,  267,  287,  287,  287,  287,
 /*  1250 */   287,  287,  261,  205,  206,  207,  208,  209,  210,  211,
 /*  1260 */   327,  287,  287,  287,  331,  332,  333,  334,  335,  336,
 /*  1270 */   295,  338,  287,  322,  341,  300,  269,  302,  345,  346,
 /*  1280 */   347,  300,  174,  233,  302,  150,  269,  259,  269,  356,
 /*  1290 */   321,  267,  267,  300,  311,  315,  300,  259,  300,  300,
 /*  1300 */   311,  300,  327,  295,  309,  308,  331,  332,  333,  334,
 /*  1310 */   335,  336,  269,  338,  283,  287,  341,  295,   20,  234,
 /*  1320 */   345,  346,  347,  295,  269,  287,  300,  300,  300,  300,
 /*  1330 */   302,  356,   22,  295,  330,  300,  300,  240,  300,  229,
 /*  1340 */   302,  311,  365,  311,  157,   35,  242,  259,  225,  363,
 /*  1350 */   363,  363,  241,  295,  316,  327,   20,  259,  366,  331,
 /*  1360 */   332,  333,  334,  335,  336,  327,  338,  325,  362,  331,
 /*  1370 */   332,  333,  334,  335,  336,  287,  338,  246,   68,  249,
 /*  1380 */   329,  244,  373,  295,  372,  287,  373,  372,  300,  378,
 /*  1390 */   302,   85,   85,  295,  361,  357,  300,  360,  300,  277,
 /*  1400 */   302,  267,  269,  344,  316,  291,   36,  373,  370,  262,
 /*  1410 */   261,  372,  374,  319,  314,  327,  257,  107,    0,  331,
 /*  1420 */   332,  333,  334,  335,  336,  327,  338,  270,    0,  331,
 /*  1430 */   332,  333,  334,  335,  336,  337,  338,  339,  340,  259,
 /*  1440 */   267,  281,  281,  281,  176,  357,    0,    0,   42,    0,
 /*  1450 */    76,    0,   35,  186,   35,   35,   35,  186,  370,    0,
 /*  1460 */    35,   35,  374,  186,    0,  186,    0,  287,  295,    0,
 /*  1470 */    35,    0,   22,   35,    0,  295,  166,   85,  168,  171,
 /*  1480 */   300,  170,  302,  168,  166,    0,    0,  162,  161,  316,
 /*  1490 */     0,    0,    0,  259,   46,    0,    0,  145,    0,    0,
 /*  1500 */     0,    0,    0,  193,  194,  140,    0,  327,  335,  140,
 /*  1510 */    35,  331,  332,  333,  334,  335,  336,  259,  338,    0,
 /*  1520 */     0,  287,   42,  350,  351,  352,    0,  354,    0,  295,
 /*  1530 */   357,    0,    0,    0,  300,    0,  302,    0,    0,    0,
 /*  1540 */     0,    0,    0,  370,    0,  287,    0,  374,    0,    0,
 /*  1550 */   292,    0,    0,  295,   39,  375,  376,    0,  300,    0,
 /*  1560 */   302,  327,    0,    0,    0,  331,  332,  333,  334,  335,
 /*  1570 */   336,  259,  338,   56,    0,  341,   22,   56,    0,    0,
 /*  1580 */   346,  259,   14,   14,    0,  327,   43,   42,    0,  331,
 /*  1590 */   332,  333,  334,  335,  336,    0,  338,    0,   40,  287,
 /*  1600 */    39,   46,   46,    0,  292,   39,    0,  295,    0,  287,
 /*  1610 */   157,    0,  300,    0,  302,   62,   35,  295,   47,   39,
 /*  1620 */     0,   35,  300,   47,  302,    0,   39,    0,   35,   39,
 /*  1630 */    47,  259,   47,   35,    0,   39,    0,    0,    0,  327,
 /*  1640 */    35,   94,   92,  331,  332,  333,  334,  335,  336,  327,
 /*  1650 */   338,   22,    0,  331,  332,  333,  334,  335,  336,  287,
 /*  1660 */   338,   35,   43,   35,   43,   35,   35,  295,   35,   22,
 /*  1670 */    35,    0,  300,   22,  302,   35,    0,   22,    0,   22,
 /*  1680 */    35,  259,    0,   35,    0,   35,    0,   22,   49,   20,
 /*  1690 */     0,  369,   22,  259,   35,    0,  172,    0,    0,  327,
 /*  1700 */     0,    0,    0,  331,  332,  333,  334,  335,  336,  287,
 /*  1710 */   338,  181,    0,  153,    0,   43,   39,  295,  153,   95,
 /*  1720 */   150,  287,  300,  230,  302,   46,  292,   85,  153,  295,
 /*  1730 */    86,   85,  155,   46,  300,   86,  302,   43,   85,   85,
 /*  1740 */   151,   85,   43,  149,   86,   85,   43,   86,  376,  327,
 /*  1750 */    86,   85,   85,  331,  332,  333,  334,  335,  336,   85,
 /*  1760 */   338,  327,  340,   46,  230,  331,  332,  333,  334,  335,
 /*  1770 */   336,  259,  338,   85,   46,   86,   85,   43,   46,   86,
 /*  1780 */    35,  259,   86,   46,   43,   35,   35,   35,   35,    2,
 /*  1790 */    86,  224,   86,   35,   22,  193,   85,   22,   43,  287,
 /*  1800 */    35,   86,   86,  230,  292,   85,   85,  295,   86,  287,
 /*  1810 */    46,   85,  300,   46,  302,   85,   85,  295,  195,   96,
 /*  1820 */    35,   86,  300,   85,  302,   86,   35,   85,   35,   86,
 /*  1830 */    86,  259,   85,   35,   85,   35,  109,   22,  109,  327,
 /*  1840 */    35,  259,   86,  331,  332,  333,  334,  335,  336,  327,
 /*  1850 */   338,  259,   43,  331,  332,  333,  334,  335,  336,  287,
 /*  1860 */   338,   85,   85,   97,   85,   85,  109,  295,  109,  287,
 /*  1870 */    22,   61,  300,   62,  302,   68,   35,  295,   83,  287,
 /*  1880 */    43,   35,  300,   22,  302,   35,   35,  295,   35,   22,
 /*  1890 */    35,   35,  300,   68,  302,   35,   22,   35,   35,  327,
 /*  1900 */    35,   35,    0,  331,  332,  333,  334,  335,  336,  327,
 /*  1910 */   338,   35,   35,  331,  332,  333,  334,  335,  336,  327,
 /*  1920 */   338,   35,   47,  331,  332,  333,  334,  335,  336,   39,
 /*  1930 */   338,    0,  259,   35,   47,   39,    0,    0,   35,   47,
 /*  1940 */    39,   35,   47,   39,    0,   35,   35,    0,   22,   21,
 /*  1950 */    21,  259,   22,   20,   22,  379,  379,  379,  379,  379,
 /*  1960 */   287,  379,  379,  379,  379,  379,  379,  379,  295,  379,
 /*  1970 */   379,  379,  379,  300,  379,  302,  379,  379,  379,  287,
 /*  1980 */   379,  379,  379,  379,  379,  379,  379,  295,  379,  379,
 /*  1990 */   379,  379,  300,  379,  302,  379,  379,  379,  379,  379,
 /*  2000 */   327,  379,  379,  379,  331,  332,  333,  334,  335,  336,
 /*  2010 */   379,  338,  379,  259,  379,  379,  379,  379,  379,  327,
 /*  2020 */   379,  379,  379,  331,  332,  333,  334,  335,  336,  259,
 /*  2030 */   338,  379,  379,  379,  379,  379,  379,  379,  379,  379,
 /*  2040 */   379,  287,  379,  379,  379,  379,  379,  379,  379,  295,
 /*  2050 */   379,  379,  379,  379,  300,  379,  302,  287,  379,  379,
 /*  2060 */   379,  379,  379,  379,  379,  295,  379,  379,  379,  379,
 /*  2070 */   300,  379,  302,  379,  379,  379,  379,  379,  379,  379,
 /*  2080 */   379,  327,  259,  379,  379,  331,  332,  333,  334,  335,
 /*  2090 */   336,  379,  338,  379,  379,  379,  379,  327,  379,  259,
 /*  2100 */   379,  331,  332,  333,  334,  335,  336,  379,  338,  379,
 /*  2110 */   287,  379,  379,  379,  379,  379,  379,  379,  295,  379,
 /*  2120 */   379,  379,  379,  300,  379,  302,  379,  287,  379,  379,
 /*  2130 */   379,  379,  379,  379,  379,  295,  379,  379,  379,  379,
 /*  2140 */   300,  379,  302,  379,  379,  379,  379,  379,  379,  379,
 /*  2150 */   327,  379,  259,  379,  331,  332,  333,  334,  335,  336,
 /*  2160 */   379,  338,  379,  379,  259,  379,  379,  327,  379,  379,
 /*  2170 */   379,  331,  332,  333,  334,  335,  336,  379,  338,  379,
 /*  2180 */   287,  379,  379,  379,  379,  379,  379,  379,  295,  379,
 /*  2190 */   379,  379,  287,  300,  379,  302,  379,  379,  379,  379,
 /*  2200 */   295,  379,  379,  379,  379,  300,  379,  302,  379,  379,
 /*  2210 */   379,  379,  379,  379,  379,  379,  379,  379,  379,  379,
 /*  2220 */   327,  379,  379,  379,  331,  332,  333,  334,  335,  336,
 /*  2230 */   379,  338,  327,  259,  379,  379,  331,  332,  333,  334,
 /*  2240 */   335,  336,  379,  338,  379,  379,  379,  259,  379,  379,
 /*  2250 */   379,  379,  379,  379,  379,  379,  379,  379,  379,  379,
 /*  2260 */   379,  287,  379,  379,  379,  379,  379,  379,  379,  295,
 /*  2270 */   379,  379,  379,  379,  300,  287,  302,  379,  379,  379,
 /*  2280 */   379,  379,  379,  295,  379,  379,  379,  379,  300,  259,
 /*  2290 */   302,  379,  379,  379,  379,  379,  379,  379,  379,  379,
 /*  2300 */   379,  327,  379,  379,  379,  331,  332,  333,  334,  335,
 /*  2310 */   336,  379,  338,  379,  379,  327,  379,  287,  379,  331,
 /*  2320 */   332,  333,  334,  335,  336,  295,  338,  379,  379,  379,
 /*  2330 */   300,  379,  302,  379,  379,  379,  379,  379,  379,  379,
 /*  2340 */   379,  259,  379,  379,  379,  379,  379,  379,  379,  379,
 /*  2350 */   379,  379,  379,  379,  379,  379,  379,  327,  379,  259,
 /*  2360 */   379,  331,  332,  333,  334,  335,  336,  379,  338,  287,
 /*  2370 */   379,  379,  379,  379,  379,  379,  379,  295,  379,  379,
 /*  2380 */   379,  379,  300,  259,  302,  379,  379,  287,  379,  379,
 /*  2390 */   379,  379,  379,  379,  379,  295,  379,  379,  379,  379,
 /*  2400 */   300,  379,  302,  379,  379,  379,  379,  379,  379,  327,
 /*  2410 */   379,  287,  379,  331,  332,  333,  334,  335,  336,  295,
 /*  2420 */   338,  379,  379,  379,  300,  379,  302,  327,  379,  379,
 /*  2430 */   379,  331,  332,  333,  334,  335,  336,  379,  338,  267,
 /*  2440 */   259,  379,  379,  379,  379,  379,  379,  379,  379,  379,
 /*  2450 */   379,  327,  379,  379,  379,  331,  332,  333,  334,  335,
 /*  2460 */   336,  379,  338,  379,  379,  379,  379,  295,  287,  379,
 /*  2470 */   379,  379,  379,  379,  379,  379,  295,  379,  379,  379,
 /*  2480 */   379,  300,  379,  302,  379,  379,  379,  379,  316,  379,
 /*  2490 */   379,  379,  379,  379,  379,  379,  379,  379,  379,  379,
 /*  2500 */   379,  379,  379,  379,  379,  379,  379,  335,  327,  379,
 /*  2510 */   379,  379,  331,  332,  333,  334,  335,  336,  379,  338,
 /*  2520 */   379,  379,  350,  351,  352,  379,  354,  379,  379,  357,
 /*  2530 */   379,  379,  379,  379,  379,  379,  379,  379,  379,  379,
 /*  2540 */   379,  379,  370,  379,  379,  379,  374,
};
#define YY_SHIFT_COUNT    (668)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1947)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   909,    0,    0,   57,   57,  259,  259,  259,  316,  316,
 /*    10 */   259,  259,  518,  575,  777,  575,  575,  575,  575,  575,
 /*    20 */   575,  575,  575,  575,  575,  575,  575,  575,  575,  575,
 /*    30 */   575,  575,  575,  575,  575,  575,  575,  575,  575,  575,
 /*    40 */   575,  575,   54,   54,   53,   53,   53, 1048, 1048,   86,
 /*    50 */  1048, 1048,   80,  418,  153,  204,  153,   19,   19,  436,
 /*    60 */   436,  100,   61,  153,  153,   19,   19,   19,   19,   19,
 /*    70 */    19,   19,   19,   19,  233,   19,   19,   19,   97,  255,
 /*    80 */    19,   19,  255,  354,   19,  255,  255,  255,   19,  444,
 /*    90 */   773,  227,  485,  485,  122,  414, 1310, 1310, 1310, 1310,
 /*   100 */  1310, 1310, 1310, 1310, 1310, 1310, 1310, 1310, 1310, 1310,
 /*   110 */  1310, 1310, 1310, 1310, 1310,  303,   61,  523,  523,  287,
 /*   120 */   127,  371,  358,  358,  358,  127,  618,   97,  399,  399,
 /*   130 */   255,  255,  590,  590,  599,  736,  650,  650,  650,  650,
 /*   140 */   650,  650,  650,  972,   21,  495,  420,  150,  404,  385,
 /*   150 */   430,  637,  671,  202,  894,  248,  811,  806,  796,  806,
 /*   160 */   853,  710,  710,  710,  180,  288,  943, 1155, 1129, 1146,
 /*   170 */  1018, 1155, 1155, 1148, 1040, 1040, 1155, 1155, 1155, 1182,
 /*   180 */  1182, 1185,  233,   97,  233, 1201, 1204,  233, 1201,  233,
 /*   190 */  1210,  233,  233, 1155,  233, 1182,  255,  255,  255,  255,
 /*   200 */   255,  255,  255,  255,  255,  255,  255, 1155, 1182,  590,
 /*   210 */  1185,  444, 1108,   97,  444, 1155, 1155, 1201,  444, 1050,
 /*   220 */   590,  590,  590,  590, 1050,  590, 1135,  618, 1210,  444,
 /*   230 */   599,  444,  618, 1298,  590, 1085, 1050,  590,  590, 1085,
 /*   240 */  1050,  590,  590,  255, 1097, 1187, 1085, 1104, 1111, 1110,
 /*   250 */   943, 1123,  618, 1336, 1131, 1137, 1130, 1131, 1137, 1131,
 /*   260 */  1137, 1306, 1307,  590,  736, 1155,  444, 1370, 1182, 2547,
 /*   270 */  2547, 2547, 2547, 2547, 2547, 2547,  339,  134,  273,  579,
 /*   280 */   661,  724,  838,  921,  946,  851, 1002,  473,   51,   51,
 /*   290 */    51,   51,   51,   51,   51,   51,  698,  774,  145,  145,
 /*   300 */   359,  471,  190,  429,  585,   13,  708,  428,  673,  673,
 /*   310 */   673,  673,   84,  823,  800,  966,  973, 1014, 1016, 1023,
 /*   320 */  1049, 1057,  488,  881,  914, 1000, 1021, 1041, 1052, 1066,
 /*   330 */  1068, 1128, 1020,  206,  559, 1072,  905,  994, 1005, 1067,
 /*   340 */   990, 1074, 1083, 1101, 1103, 1105, 1107,  763,  757,  556,
 /*   350 */  1418, 1428, 1268, 1446, 1447, 1406, 1449, 1374, 1451, 1417,
 /*   360 */  1267, 1419, 1420, 1421, 1271, 1459, 1425, 1426, 1277, 1464,
 /*   370 */  1279, 1466, 1435, 1469, 1450, 1471, 1438, 1474, 1392, 1308,
 /*   380 */  1311, 1315, 1318, 1485, 1486, 1325, 1327, 1490, 1491, 1448,
 /*   390 */  1492, 1495, 1496, 1352, 1498, 1499, 1500, 1501, 1502, 1365,
 /*   400 */  1475, 1506, 1369, 1519, 1520, 1526, 1528, 1531, 1532, 1533,
 /*   410 */  1535, 1537, 1538, 1539, 1540, 1541, 1542, 1480, 1544, 1546,
 /*   420 */  1548, 1549, 1551, 1552, 1554, 1557, 1559, 1562, 1563, 1564,
 /*   430 */  1517, 1574, 1521, 1578, 1579, 1545, 1515, 1543, 1568, 1555,
 /*   440 */  1569, 1556, 1584, 1558, 1561, 1588, 1595, 1597, 1566, 1453,
 /*   450 */  1603, 1606, 1608, 1553, 1611, 1613, 1581, 1571, 1580, 1620,
 /*   460 */  1586, 1576, 1587, 1625, 1593, 1583, 1590, 1627, 1598, 1585,
 /*   470 */  1596, 1634, 1636, 1637, 1638, 1547, 1550, 1605, 1629, 1652,
 /*   480 */  1626, 1628, 1630, 1631, 1619, 1621, 1633, 1635, 1647, 1640,
 /*   490 */  1671, 1651, 1676, 1655, 1639, 1678, 1657, 1645, 1682, 1648,
 /*   500 */  1684, 1650, 1686, 1665, 1669, 1690, 1560, 1659, 1695, 1524,
 /*   510 */  1670, 1565, 1570, 1697, 1698, 1575, 1577, 1700, 1701, 1702,
 /*   520 */  1642, 1644, 1530, 1712, 1646, 1589, 1653, 1714, 1677, 1594,
 /*   530 */  1654, 1624, 1679, 1672, 1493, 1656, 1649, 1660, 1658, 1661,
 /*   540 */  1666, 1694, 1664, 1667, 1674, 1688, 1689, 1699, 1687, 1717,
 /*   550 */  1691, 1703, 1534, 1693, 1696, 1728, 1567, 1734, 1732, 1737,
 /*   560 */  1704, 1741, 1573, 1706, 1745, 1750, 1751, 1752, 1753, 1758,
 /*   570 */  1706, 1787, 1772, 1602, 1755, 1711, 1715, 1720, 1716, 1721,
 /*   580 */  1722, 1764, 1726, 1730, 1767, 1775, 1623, 1731, 1723, 1735,
 /*   590 */  1765, 1785, 1738, 1739, 1791, 1742, 1743, 1793, 1747, 1744,
 /*   600 */  1798, 1749, 1756, 1800, 1776, 1727, 1729, 1757, 1759, 1815,
 /*   610 */  1766, 1777, 1779, 1805, 1780, 1809, 1809, 1848, 1811, 1810,
 /*   620 */  1841, 1807, 1795, 1837, 1846, 1850, 1851, 1861, 1853, 1867,
 /*   630 */  1855, 1856, 1825, 1619, 1860, 1621, 1862, 1863, 1865, 1866,
 /*   640 */  1876, 1874, 1877, 1902, 1886, 1875, 1890, 1931, 1898, 1887,
 /*   650 */  1896, 1936, 1903, 1892, 1901, 1937, 1906, 1895, 1904, 1944,
 /*   660 */  1910, 1911, 1947, 1926, 1928, 1930, 1932, 1929, 1933,
};
#define YY_REDUCE_COUNT (275)
#define YY_REDUCE_MIN   (-294)
#define YY_REDUCE_MAX   (2181)
static const short yy_reduce_ofst[] = {
 /*     0 */  -254, -201,  706,   23,  282,  787,  933,  975, 1038, 1088,
 /*    10 */   542,  877, 1098, 1180, 1234, 1258, 1312, 1322, 1372, 1422,
 /*    20 */  1434, 1512, 1028, 1522, 1572, 1582, 1592, 1673, 1692, 1754,
 /*    30 */  1770, 1823, 1840, 1893, 1905, 1974, 1988, 2030, 2082, 2100,
 /*    40 */  2124, 2181, 1173, 2172, -240, -263,  -19,  207,  352, -277,
 /*    50 */   345,  813, -142, -141, -140,  -79,    3, -267,   29, -260,
 /*    60 */  -229, -274, -258, -143,  -40, -159,   70,  285,  327,  329,
 /*    70 */   369,  370,  531,  535, -270,  541,  554,  560, -294, -272,
 /*    80 */   561,  594,   59, -257,  674, -124,   89,  270,  725,  377,
 /*    90 */  -226, -219, -219, -219, -176, -247, -202,  -15,   52,   63,
 /*   100 */   247,  394,  434,  507,  511,  581,  582,  626,  663,  672,
 /*   110 */   697,  748,  750,  753,  754, -158,  -82, -162,  -87, -262,
 /*   120 */    68, -215,  406,  589,  596,  215,  305,  379,   83,  236,
 /*   130 */   509,  298,  445,  699,  715,  469,  362,  591,  633,  640,
 /*   140 */   656,  714,  789,  631,  825,  814,  716,  744,  863,  826,
 /*   150 */   792,  850,  850,  889,  893,  862,  833,  810,  810,  810,
 /*   160 */   818,  797,  799,  802,  809,  850,  849,  911,  856,  910,
 /*   170 */   866,  918,  919,  887,  890,  891,  930,  932,  934,  939,
 /*   180 */   942,  884,  936,  915,  948,  912,  908,  955,  916,  958,
 /*   190 */   924,  965,  967,  970,  968,  979,  956,  957,  959,  960,
 /*   200 */   961,  962,  963,  964,  974,  976,  985,  978,  991,  981,
 /*   210 */   951, 1007,  969,  982, 1017, 1024, 1025,  980, 1019,  983,
 /*   220 */   993,  996,  998,  999,  989, 1001,  995, 1008,  997, 1043,
 /*   230 */  1031, 1055, 1022, 1004, 1026,  986, 1030, 1027, 1029,  987,
 /*   240 */  1032, 1035, 1036,  850,  992,  977,  988, 1006, 1033, 1037,
 /*   250 */  1042,  810, 1058, 1051, 1009, 1012, 1011, 1013, 1015, 1034,
 /*   260 */  1039, 1059, 1114, 1096, 1122, 1134, 1133, 1147, 1149, 1094,
 /*   270 */  1100, 1160, 1161, 1162, 1157, 1159,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*    10 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*    20 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*    30 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*    40 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*    50 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*    60 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*    70 */  1465, 1465, 1465, 1465, 1539, 1465, 1465, 1465, 1465, 1465,
 /*    80 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1537,
 /*    90 */  1692, 1465, 1872, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   100 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   110 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1539,
 /*   120 */  1465, 1537, 1884, 1884, 1884, 1465, 1465, 1465, 1736, 1736,
 /*   130 */  1465, 1465, 1465, 1465, 1635, 1465, 1465, 1465, 1465, 1465,
 /*   140 */  1465, 1465, 1465, 1728, 1465, 1465, 1953, 1465, 1465, 1734,
 /*   150 */  1907, 1465, 1465, 1465, 1465, 1588, 1899, 1876, 1890, 1877,
 /*   160 */  1874, 1938, 1938, 1938, 1893, 1465, 1903, 1465, 1465, 1465,
 /*   170 */  1720, 1465, 1465, 1697, 1694, 1694, 1465, 1465, 1465, 1465,
 /*   180 */  1465, 1465, 1539, 1465, 1539, 1465, 1465, 1539, 1465, 1539,
 /*   190 */  1465, 1539, 1539, 1465, 1539, 1465, 1465, 1465, 1465, 1465,
 /*   200 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   210 */  1465, 1537, 1730, 1465, 1537, 1465, 1465, 1465, 1537, 1912,
 /*   220 */  1465, 1465, 1465, 1465, 1912, 1465, 1465, 1465, 1465, 1537,
 /*   230 */  1465, 1537, 1465, 1465, 1465, 1914, 1912, 1465, 1465, 1914,
 /*   240 */  1912, 1465, 1465, 1465, 1926, 1922, 1914, 1930, 1928, 1905,
 /*   250 */  1903, 1890, 1465, 1465, 1944, 1940, 1956, 1944, 1940, 1944,
 /*   260 */  1940, 1465, 1604, 1465, 1465, 1465, 1537, 1497, 1465, 1722,
 /*   270 */  1736, 1638, 1638, 1638, 1540, 1470, 1465, 1465, 1465, 1465,
 /*   280 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1809, 1925,
 /*   290 */  1924, 1848, 1847, 1846, 1844, 1808, 1465, 1600, 1807, 1806,
 /*   300 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1800, 1801,
 /*   310 */  1799, 1798, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   320 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   330 */  1465, 1873, 1465, 1941, 1945, 1465, 1465, 1465, 1465, 1465,
 /*   340 */  1783, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   350 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   360 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   370 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   380 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   390 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   400 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   410 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   420 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   430 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1502, 1465, 1465,
 /*   440 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   450 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   460 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   470 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   480 */  1465, 1465, 1465, 1465, 1569, 1568, 1465, 1465, 1465, 1465,
 /*   490 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   500 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   510 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   520 */  1465, 1465, 1465, 1740, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   530 */  1465, 1465, 1465, 1906, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   540 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1783,
 /*   550 */  1465, 1923, 1465, 1883, 1879, 1465, 1465, 1875, 1782, 1465,
 /*   560 */  1465, 1939, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   570 */  1465, 1868, 1465, 1465, 1841, 1826, 1465, 1465, 1465, 1465,
 /*   580 */  1465, 1465, 1465, 1465, 1465, 1465, 1794, 1465, 1465, 1465,
 /*   590 */  1465, 1465, 1632, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   600 */  1465, 1465, 1465, 1465, 1465, 1617, 1615, 1614, 1613, 1465,
 /*   610 */  1610, 1465, 1465, 1465, 1465, 1641, 1640, 1465, 1465, 1465,
 /*   620 */  1465, 1465, 1465, 1560, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   630 */  1465, 1465, 1465, 1551, 1465, 1550, 1465, 1465, 1465, 1465,
 /*   640 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   650 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*   660 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  250,  /*  NK_BITNOT => ID */
  250,  /*     VALUES => ID */
  250,  /*     IMPORT => ID */
  250,  /*    NK_SEMI => ID */
  250,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "FSYNC",
  /*   70 */ "MAXROWS",
  /*   71 */ "MINROWS",
  /*   72 */ "KEEP",
  /*   73 */ "PAGES",
  /*   74 */ "PAGESIZE",
  /*   75 */ "PRECISION",
  /*   76 */ "REPLICA",
  /*   77 */ "STRICT",
  /*   78 */ "WAL",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "NK_COLON",
  /*   84 */ "TABLE",
  /*   85 */ "NK_LP",
  /*   86 */ "NK_RP",
  /*   87 */ "STABLE",
  /*   88 */ "ADD",
  /*   89 */ "COLUMN",
  /*   90 */ "MODIFY",
  /*   91 */ "RENAME",
  /*   92 */ "TAG",
  /*   93 */ "SET",
  /*   94 */ "NK_EQ",
  /*   95 */ "USING",
  /*   96 */ "TAGS",
  /*   97 */ "COMMENT",
  /*   98 */ "BOOL",
  /*   99 */ "TINYINT",
  /*  100 */ "SMALLINT",
  /*  101 */ "INT",
  /*  102 */ "INTEGER",
  /*  103 */ "BIGINT",
  /*  104 */ "FLOAT",
  /*  105 */ "DOUBLE",
  /*  106 */ "BINARY",
  /*  107 */ "TIMESTAMP",
  /*  108 */ "NCHAR",
  /*  109 */ "UNSIGNED",
  /*  110 */ "JSON",
  /*  111 */ "VARCHAR",
  /*  112 */ "MEDIUMBLOB",
  /*  113 */ "BLOB",
  /*  114 */ "VARBINARY",
  /*  115 */ "DECIMAL",
  /*  116 */ "MAX_DELAY",
  /*  117 */ "WATERMARK",
  /*  118 */ "ROLLUP",
  /*  119 */ "TTL",
  /*  120 */ "SMA",
  /*  121 */ "FIRST",
  /*  122 */ "LAST",
  /*  123 */ "SHOW",
  /*  124 */ "DATABASES",
  /*  125 */ "TABLES",
  /*  126 */ "STABLES",
  /*  127 */ "MNODES",
  /*  128 */ "MODULES",
  /*  129 */ "QNODES",
  /*  130 */ "FUNCTIONS",
  /*  131 */ "INDEXES",
  /*  132 */ "ACCOUNTS",
  /*  133 */ "APPS",
  /*  134 */ "CONNECTIONS",
  /*  135 */ "LICENCE",
  /*  136 */ "GRANTS",
  /*  137 */ "QUERIES",
  /*  138 */ "SCORES",
  /*  139 */ "TOPICS",
  /*  140 */ "VARIABLES",
  /*  141 */ "BNODES",
  /*  142 */ "SNODES",
  /*  143 */ "CLUSTER",
  /*  144 */ "TRANSACTIONS",
  /*  145 */ "DISTRIBUTED",
  /*  146 */ "CONSUMERS",
  /*  147 */ "SUBSCRIPTIONS",
  /*  148 */ "LIKE",
  /*  149 */ "INDEX",
  /*  150 */ "FUNCTION",
  /*  151 */ "INTERVAL",
  /*  152 */ "TOPIC",
  /*  153 */ "AS",
  /*  154 */ "WITH",
  /*  155 */ "META",
  /*  156 */ "CONSUMER",
  /*  157 */ "GROUP",
  /*  158 */ "DESC",
  /*  159 */ "DESCRIBE",
  /*  160 */ "RESET",
  /*  161 */ "QUERY",
  /*  162 */ "CACHE",
  /*  163 */ "EXPLAIN",
  /*  164 */ "ANALYZE",
  /*  165 */ "VERBOSE",
  /*  166 */ "NK_BOOL",
  /*  167 */ "RATIO",
  /*  168 */ "NK_FLOAT",
  /*  169 */ "COMPACT",
  /*  170 */ "VNODES",
  /*  171 */ "IN",
  /*  172 */ "OUTPUTTYPE",
  /*  173 */ "AGGREGATE",
  /*  174 */ "BUFSIZE",
  /*  175 */ "STREAM",
  /*  176 */ "INTO",
  /*  177 */ "TRIGGER",
  /*  178 */ "AT_ONCE",
  /*  179 */ "WINDOW_CLOSE",
  /*  180 */ "IGNORE",
  /*  181 */ "EXPIRED",
  /*  182 */ "KILL",
  /*  183 */ "CONNECTION",
  /*  184 */ "TRANSACTION",
  /*  185 */ "BALANCE",
  /*  186 */ "VGROUP",
  /*  187 */ "MERGE",
  /*  188 */ "REDISTRIBUTE",
  /*  189 */ "SPLIT",
  /*  190 */ "SYNCDB",
  /*  191 */ "DELETE",
  /*  192 */ "INSERT",
  /*  193 */ "NULL",
  /*  194 */ "NK_QUESTION",
  /*  195 */ "NK_ARROW",
  /*  196 */ "ROWTS",
  /*  197 */ "TBNAME",
  /*  198 */ "QSTART",
  /*  199 */ "QEND",
  /*  200 */ "QDURATION",
  /*  201 */ "WSTART",
  /*  202 */ "WEND",
  /*  203 */ "WDURATION",
  /*  204 */ "CAST",
  /*  205 */ "NOW",
  /*  206 */ "TODAY",
  /*  207 */ "TIMEZONE",
  /*  208 */ "CLIENT_VERSION",
  /*  209 */ "SERVER_VERSION",
  /*  210 */ "SERVER_STATUS",
  /*  211 */ "CURRENT_USER",
  /*  212 */ "COUNT",
  /*  213 */ "LAST_ROW",
  /*  214 */ "BETWEEN",
  /*  215 */ "IS",
  /*  216 */ "NK_LT",
  /*  217 */ "NK_GT",
  /*  218 */ "NK_LE",
  /*  219 */ "NK_GE",
  /*  220 */ "NK_NE",
  /*  221 */ "MATCH",
  /*  222 */ "NMATCH",
  /*  223 */ "CONTAINS",
  /*  224 */ "JOIN",
  /*  225 */ "INNER",
  /*  226 */ "SELECT",
  /*  227 */ "DISTINCT",
  /*  228 */ "WHERE",
  /*  229 */ "PARTITION",
  /*  230 */ "BY",
  /*  231 */ "SESSION",
  /*  232 */ "STATE_WINDOW",
  /*  233 */ "SLIDING",
  /*  234 */ "FILL",
  /*  235 */ "VALUE",
  /*  236 */ "NONE",
  /*  237 */ "PREV",
  /*  238 */ "LINEAR",
  /*  239 */ "NEXT",
  /*  240 */ "HAVING",
  /*  241 */ "RANGE",
  /*  242 */ "EVERY",
  /*  243 */ "ORDER",
  /*  244 */ "SLIMIT",
  /*  245 */ "SOFFSET",
  /*  246 */ "LIMIT",
  /*  247 */ "OFFSET",
  /*  248 */ "ASC",
  /*  249 */ "NULLS",
  /*  250 */ "ID",
  /*  251 */ "NK_BITNOT",
  /*  252 */ "VALUES",
  /*  253 */ "IMPORT",
  /*  254 */ "NK_SEMI",
  /*  255 */ "FILE",
  /*  256 */ "cmd",
  /*  257 */ "account_options",
  /*  258 */ "alter_account_options",
  /*  259 */ "literal",
  /*  260 */ "alter_account_option",
  /*  261 */ "user_name",
  /*  262 */ "sysinfo_opt",
  /*  263 */ "privileges",
  /*  264 */ "priv_level",
  /*  265 */ "priv_type_list",
  /*  266 */ "priv_type",
  /*  267 */ "db_name",
  /*  268 */ "dnode_endpoint",
  /*  269 */ "not_exists_opt",
  /*  270 */ "db_options",
  /*  271 */ "exists_opt",
  /*  272 */ "alter_db_options",
  /*  273 */ "integer_list",
  /*  274 */ "variable_list",
  /*  275 */ "retention_list",
  /*  276 */ "alter_db_option",
  /*  277 */ "retention",
  /*  278 */ "full_table_name",
  /*  279 */ "column_def_list",
  /*  280 */ "tags_def_opt",
  /*  281 */ "table_options",
  /*  282 */ "multi_create_clause",
  /*  283 */ "tags_def",
  /*  284 */ "multi_drop_clause",
  /*  285 */ "alter_table_clause",
  /*  286 */ "alter_table_options",
  /*  287 */ "column_name",
  /*  288 */ "type_name",
  /*  289 */ "signed_literal",
  /*  290 */ "create_subtable_clause",
  /*  291 */ "specific_cols_opt",
  /*  292 */ "expression_list",
  /*  293 */ "drop_table_clause",
  /*  294 */ "col_name_list",
  /*  295 */ "table_name",
  /*  296 */ "column_def",
  /*  297 */ "duration_list",
  /*  298 */ "rollup_func_list",
  /*  299 */ "alter_table_option",
  /*  300 */ "duration_literal",
  /*  301 */ "rollup_func_name",
  /*  302 */ "function_name",
  /*  303 */ "col_name",
  /*  304 */ "db_name_cond_opt",
  /*  305 */ "like_pattern_opt",
  /*  306 */ "table_name_cond",
  /*  307 */ "from_db_opt",
  /*  308 */ "index_name",
  /*  309 */ "index_options",
  /*  310 */ "func_list",
  /*  311 */ "sliding_opt",
  /*  312 */ "sma_stream_opt",
  /*  313 */ "func",
  /*  314 */ "stream_options",
  /*  315 */ "topic_name",
  /*  316 */ "query_expression",
  /*  317 */ "cgroup_name",
  /*  318 */ "analyze_opt",
  /*  319 */ "explain_options",
  /*  320 */ "agg_func_opt",
  /*  321 */ "bufsize_opt",
  /*  322 */ "stream_name",
  /*  323 */ "into_opt",
  /*  324 */ "dnode_list",
  /*  325 */ "where_clause_opt",
  /*  326 */ "signed",
  /*  327 */ "literal_func",
  /*  328 */ "literal_list",
  /*  329 */ "table_alias",
  /*  330 */ "column_alias",
  /*  331 */ "expression",
  /*  332 */ "pseudo_column",
  /*  333 */ "column_reference",
  /*  334 */ "function_expression",
  /*  335 */ "subquery",
  /*  336 */ "star_func",
  /*  337 */ "star_func_para_list",
  /*  338 */ "noarg_func",
  /*  339 */ "other_para_list",
  /*  340 */ "star_func_para",
  /*  341 */ "predicate",
  /*  342 */ "compare_op",
  /*  343 */ "in_op",
  /*  344 */ "in_predicate_value",
  /*  345 */ "boolean_value_expression",
  /*  346 */ "boolean_primary",
  /*  347 */ "common_expression",
  /*  348 */ "from_clause_opt",
  /*  349 */ "table_reference_list",
  /*  350 */ "table_reference",
  /*  351 */ "table_primary",
  /*  352 */ "joined_table",
  /*  353 */ "alias_opt",
  /*  354 */ "parenthesized_joined_table",
  /*  355 */ "join_type",
  /*  356 */ "search_condition",
  /*  357 */ "query_specification",
  /*  358 */ "set_quantifier_opt",
  /*  359 */ "select_list",
  /*  360 */ "partition_by_clause_opt",
  /*  361 */ "range_opt",
  /*  362 */ "every_opt",
  /*  363 */ "fill_opt",
  /*  364 */ "twindow_clause_opt",
  /*  365 */ "group_by_clause_opt",
  /*  366 */ "having_clause_opt",
  /*  367 */ "select_item",
  /*  368 */ "fill_mode",
  /*  369 */ "group_by_list",
  /*  370 */ "query_expression_body",
  /*  371 */ "order_by_clause_opt",
  /*  372 */ "slimit_clause_opt",
  /*  373 */ "limit_clause_opt",
  /*  374 */ "query_primary",
  /*  375 */ "sort_specification_list",
  /*  376 */ "sort_specification",
  /*  377 */ "ordering_specification_opt",
  /*  378 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  80 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  82 */ "db_options ::= db_options KEEP integer_list",
 /*  83 */ "db_options ::= db_options KEEP variable_list",
 /*  84 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  85 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  86 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  87 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  88 */ "db_options ::= db_options STRICT NK_STRING",
 /*  89 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  90 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  91 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  92 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  93 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  94 */ "alter_db_options ::= alter_db_option",
 /*  95 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  96 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  97 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /*  98 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /*  99 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /* 100 */ "alter_db_option ::= KEEP integer_list",
 /* 101 */ "alter_db_option ::= KEEP variable_list",
 /* 102 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 103 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 104 */ "alter_db_option ::= STRICT NK_INTEGER",
 /* 105 */ "alter_db_option ::= WAL NK_INTEGER",
 /* 106 */ "integer_list ::= NK_INTEGER",
 /* 107 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 108 */ "variable_list ::= NK_VARIABLE",
 /* 109 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 110 */ "retention_list ::= retention",
 /* 111 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 112 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 113 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 114 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 115 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 116 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 117 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 118 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 119 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 120 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 121 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 122 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 123 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 124 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 125 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 126 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 127 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 128 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 129 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 130 */ "multi_create_clause ::= create_subtable_clause",
 /* 131 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 132 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 133 */ "multi_drop_clause ::= drop_table_clause",
 /* 134 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 135 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 136 */ "specific_cols_opt ::=",
 /* 137 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 138 */ "full_table_name ::= table_name",
 /* 139 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 140 */ "column_def_list ::= column_def",
 /* 141 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 142 */ "column_def ::= column_name type_name",
 /* 143 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 144 */ "type_name ::= BOOL",
 /* 145 */ "type_name ::= TINYINT",
 /* 146 */ "type_name ::= SMALLINT",
 /* 147 */ "type_name ::= INT",
 /* 148 */ "type_name ::= INTEGER",
 /* 149 */ "type_name ::= BIGINT",
 /* 150 */ "type_name ::= FLOAT",
 /* 151 */ "type_name ::= DOUBLE",
 /* 152 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 153 */ "type_name ::= TIMESTAMP",
 /* 154 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 155 */ "type_name ::= TINYINT UNSIGNED",
 /* 156 */ "type_name ::= SMALLINT UNSIGNED",
 /* 157 */ "type_name ::= INT UNSIGNED",
 /* 158 */ "type_name ::= BIGINT UNSIGNED",
 /* 159 */ "type_name ::= JSON",
 /* 160 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 161 */ "type_name ::= MEDIUMBLOB",
 /* 162 */ "type_name ::= BLOB",
 /* 163 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 164 */ "type_name ::= DECIMAL",
 /* 165 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 166 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 167 */ "tags_def_opt ::=",
 /* 168 */ "tags_def_opt ::= tags_def",
 /* 169 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 170 */ "table_options ::=",
 /* 171 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 172 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 173 */ "table_options ::= table_options WATERMARK duration_list",
 /* 174 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 175 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 176 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 177 */ "alter_table_options ::= alter_table_option",
 /* 178 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 179 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 180 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 181 */ "duration_list ::= duration_literal",
 /* 182 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 183 */ "rollup_func_list ::= rollup_func_name",
 /* 184 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 185 */ "rollup_func_name ::= function_name",
 /* 186 */ "rollup_func_name ::= FIRST",
 /* 187 */ "rollup_func_name ::= LAST",
 /* 188 */ "col_name_list ::= col_name",
 /* 189 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 190 */ "col_name ::= column_name",
 /* 191 */ "cmd ::= SHOW DNODES",
 /* 192 */ "cmd ::= SHOW USERS",
 /* 193 */ "cmd ::= SHOW DATABASES",
 /* 194 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 195 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 196 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 197 */ "cmd ::= SHOW MNODES",
 /* 198 */ "cmd ::= SHOW MODULES",
 /* 199 */ "cmd ::= SHOW QNODES",
 /* 200 */ "cmd ::= SHOW FUNCTIONS",
 /* 201 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 202 */ "cmd ::= SHOW STREAMS",
 /* 203 */ "cmd ::= SHOW ACCOUNTS",
 /* 204 */ "cmd ::= SHOW APPS",
 /* 205 */ "cmd ::= SHOW CONNECTIONS",
 /* 206 */ "cmd ::= SHOW LICENCE",
 /* 207 */ "cmd ::= SHOW GRANTS",
 /* 208 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 209 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 210 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 211 */ "cmd ::= SHOW QUERIES",
 /* 212 */ "cmd ::= SHOW SCORES",
 /* 213 */ "cmd ::= SHOW TOPICS",
 /* 214 */ "cmd ::= SHOW VARIABLES",
 /* 215 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 216 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 217 */ "cmd ::= SHOW BNODES",
 /* 218 */ "cmd ::= SHOW SNODES",
 /* 219 */ "cmd ::= SHOW CLUSTER",
 /* 220 */ "cmd ::= SHOW TRANSACTIONS",
 /* 221 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 222 */ "cmd ::= SHOW CONSUMERS",
 /* 223 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 224 */ "db_name_cond_opt ::=",
 /* 225 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 226 */ "like_pattern_opt ::=",
 /* 227 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 228 */ "table_name_cond ::= table_name",
 /* 229 */ "from_db_opt ::=",
 /* 230 */ "from_db_opt ::= FROM db_name",
 /* 231 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 232 */ "cmd ::= DROP INDEX exists_opt index_name",
 /* 233 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 234 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 235 */ "func_list ::= func",
 /* 236 */ "func_list ::= func_list NK_COMMA func",
 /* 237 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 238 */ "sma_stream_opt ::=",
 /* 239 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 240 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 241 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 242 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 243 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 244 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 245 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 246 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 247 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 248 */ "cmd ::= DESC full_table_name",
 /* 249 */ "cmd ::= DESCRIBE full_table_name",
 /* 250 */ "cmd ::= RESET QUERY CACHE",
 /* 251 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 252 */ "analyze_opt ::=",
 /* 253 */ "analyze_opt ::= ANALYZE",
 /* 254 */ "explain_options ::=",
 /* 255 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 256 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 257 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 258 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 259 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 260 */ "agg_func_opt ::=",
 /* 261 */ "agg_func_opt ::= AGGREGATE",
 /* 262 */ "bufsize_opt ::=",
 /* 263 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 264 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 265 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 266 */ "into_opt ::=",
 /* 267 */ "into_opt ::= INTO full_table_name",
 /* 268 */ "stream_options ::=",
 /* 269 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 270 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 271 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 272 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 273 */ "stream_options ::= stream_options IGNORE EXPIRED",
 /* 274 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 275 */ "cmd ::= KILL QUERY NK_STRING",
 /* 276 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 277 */ "cmd ::= BALANCE VGROUP",
 /* 278 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 279 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 280 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 281 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 282 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 283 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 284 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 285 */ "cmd ::= query_expression",
 /* 286 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression",
 /* 287 */ "cmd ::= INSERT INTO full_table_name query_expression",
 /* 288 */ "literal ::= NK_INTEGER",
 /* 289 */ "literal ::= NK_FLOAT",
 /* 290 */ "literal ::= NK_STRING",
 /* 291 */ "literal ::= NK_BOOL",
 /* 292 */ "literal ::= TIMESTAMP NK_STRING",
 /* 293 */ "literal ::= duration_literal",
 /* 294 */ "literal ::= NULL",
 /* 295 */ "literal ::= NK_QUESTION",
 /* 296 */ "duration_literal ::= NK_VARIABLE",
 /* 297 */ "signed ::= NK_INTEGER",
 /* 298 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 299 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 300 */ "signed ::= NK_FLOAT",
 /* 301 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 302 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 303 */ "signed_literal ::= signed",
 /* 304 */ "signed_literal ::= NK_STRING",
 /* 305 */ "signed_literal ::= NK_BOOL",
 /* 306 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 307 */ "signed_literal ::= duration_literal",
 /* 308 */ "signed_literal ::= NULL",
 /* 309 */ "signed_literal ::= literal_func",
 /* 310 */ "signed_literal ::= NK_QUESTION",
 /* 311 */ "literal_list ::= signed_literal",
 /* 312 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 313 */ "db_name ::= NK_ID",
 /* 314 */ "table_name ::= NK_ID",
 /* 315 */ "column_name ::= NK_ID",
 /* 316 */ "function_name ::= NK_ID",
 /* 317 */ "table_alias ::= NK_ID",
 /* 318 */ "column_alias ::= NK_ID",
 /* 319 */ "user_name ::= NK_ID",
 /* 320 */ "index_name ::= NK_ID",
 /* 321 */ "topic_name ::= NK_ID",
 /* 322 */ "stream_name ::= NK_ID",
 /* 323 */ "cgroup_name ::= NK_ID",
 /* 324 */ "expression ::= literal",
 /* 325 */ "expression ::= pseudo_column",
 /* 326 */ "expression ::= column_reference",
 /* 327 */ "expression ::= function_expression",
 /* 328 */ "expression ::= subquery",
 /* 329 */ "expression ::= NK_LP expression NK_RP",
 /* 330 */ "expression ::= NK_PLUS expression",
 /* 331 */ "expression ::= NK_MINUS expression",
 /* 332 */ "expression ::= expression NK_PLUS expression",
 /* 333 */ "expression ::= expression NK_MINUS expression",
 /* 334 */ "expression ::= expression NK_STAR expression",
 /* 335 */ "expression ::= expression NK_SLASH expression",
 /* 336 */ "expression ::= expression NK_REM expression",
 /* 337 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 338 */ "expression ::= expression NK_BITAND expression",
 /* 339 */ "expression ::= expression NK_BITOR expression",
 /* 340 */ "expression_list ::= expression",
 /* 341 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 342 */ "column_reference ::= column_name",
 /* 343 */ "column_reference ::= table_name NK_DOT column_name",
 /* 344 */ "pseudo_column ::= ROWTS",
 /* 345 */ "pseudo_column ::= TBNAME",
 /* 346 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 347 */ "pseudo_column ::= QSTART",
 /* 348 */ "pseudo_column ::= QEND",
 /* 349 */ "pseudo_column ::= QDURATION",
 /* 350 */ "pseudo_column ::= WSTART",
 /* 351 */ "pseudo_column ::= WEND",
 /* 352 */ "pseudo_column ::= WDURATION",
 /* 353 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 354 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 355 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 356 */ "function_expression ::= literal_func",
 /* 357 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 358 */ "literal_func ::= NOW",
 /* 359 */ "noarg_func ::= NOW",
 /* 360 */ "noarg_func ::= TODAY",
 /* 361 */ "noarg_func ::= TIMEZONE",
 /* 362 */ "noarg_func ::= DATABASE",
 /* 363 */ "noarg_func ::= CLIENT_VERSION",
 /* 364 */ "noarg_func ::= SERVER_VERSION",
 /* 365 */ "noarg_func ::= SERVER_STATUS",
 /* 366 */ "noarg_func ::= CURRENT_USER",
 /* 367 */ "noarg_func ::= USER",
 /* 368 */ "star_func ::= COUNT",
 /* 369 */ "star_func ::= FIRST",
 /* 370 */ "star_func ::= LAST",
 /* 371 */ "star_func ::= LAST_ROW",
 /* 372 */ "star_func_para_list ::= NK_STAR",
 /* 373 */ "star_func_para_list ::= other_para_list",
 /* 374 */ "other_para_list ::= star_func_para",
 /* 375 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 376 */ "star_func_para ::= expression",
 /* 377 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 378 */ "predicate ::= expression compare_op expression",
 /* 379 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 380 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 381 */ "predicate ::= expression IS NULL",
 /* 382 */ "predicate ::= expression IS NOT NULL",
 /* 383 */ "predicate ::= expression in_op in_predicate_value",
 /* 384 */ "compare_op ::= NK_LT",
 /* 385 */ "compare_op ::= NK_GT",
 /* 386 */ "compare_op ::= NK_LE",
 /* 387 */ "compare_op ::= NK_GE",
 /* 388 */ "compare_op ::= NK_NE",
 /* 389 */ "compare_op ::= NK_EQ",
 /* 390 */ "compare_op ::= LIKE",
 /* 391 */ "compare_op ::= NOT LIKE",
 /* 392 */ "compare_op ::= MATCH",
 /* 393 */ "compare_op ::= NMATCH",
 /* 394 */ "compare_op ::= CONTAINS",
 /* 395 */ "in_op ::= IN",
 /* 396 */ "in_op ::= NOT IN",
 /* 397 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 398 */ "boolean_value_expression ::= boolean_primary",
 /* 399 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 400 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 401 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 402 */ "boolean_primary ::= predicate",
 /* 403 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 404 */ "common_expression ::= expression",
 /* 405 */ "common_expression ::= boolean_value_expression",
 /* 406 */ "from_clause_opt ::=",
 /* 407 */ "from_clause_opt ::= FROM table_reference_list",
 /* 408 */ "table_reference_list ::= table_reference",
 /* 409 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 410 */ "table_reference ::= table_primary",
 /* 411 */ "table_reference ::= joined_table",
 /* 412 */ "table_primary ::= table_name alias_opt",
 /* 413 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 414 */ "table_primary ::= subquery alias_opt",
 /* 415 */ "table_primary ::= parenthesized_joined_table",
 /* 416 */ "alias_opt ::=",
 /* 417 */ "alias_opt ::= table_alias",
 /* 418 */ "alias_opt ::= AS table_alias",
 /* 419 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 420 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 421 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 422 */ "join_type ::=",
 /* 423 */ "join_type ::= INNER",
 /* 424 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 425 */ "set_quantifier_opt ::=",
 /* 426 */ "set_quantifier_opt ::= DISTINCT",
 /* 427 */ "set_quantifier_opt ::= ALL",
 /* 428 */ "select_list ::= select_item",
 /* 429 */ "select_list ::= select_list NK_COMMA select_item",
 /* 430 */ "select_item ::= NK_STAR",
 /* 431 */ "select_item ::= common_expression",
 /* 432 */ "select_item ::= common_expression column_alias",
 /* 433 */ "select_item ::= common_expression AS column_alias",
 /* 434 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 435 */ "where_clause_opt ::=",
 /* 436 */ "where_clause_opt ::= WHERE search_condition",
 /* 437 */ "partition_by_clause_opt ::=",
 /* 438 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 439 */ "twindow_clause_opt ::=",
 /* 440 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 441 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 442 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 443 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 444 */ "sliding_opt ::=",
 /* 445 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 446 */ "fill_opt ::=",
 /* 447 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 448 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 449 */ "fill_mode ::= NONE",
 /* 450 */ "fill_mode ::= PREV",
 /* 451 */ "fill_mode ::= NULL",
 /* 452 */ "fill_mode ::= LINEAR",
 /* 453 */ "fill_mode ::= NEXT",
 /* 454 */ "group_by_clause_opt ::=",
 /* 455 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 456 */ "group_by_list ::= expression",
 /* 457 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 458 */ "having_clause_opt ::=",
 /* 459 */ "having_clause_opt ::= HAVING search_condition",
 /* 460 */ "range_opt ::=",
 /* 461 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 462 */ "every_opt ::=",
 /* 463 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 464 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 465 */ "query_expression_body ::= query_primary",
 /* 466 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 467 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 468 */ "query_primary ::= query_specification",
 /* 469 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 470 */ "order_by_clause_opt ::=",
 /* 471 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 472 */ "slimit_clause_opt ::=",
 /* 473 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 474 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 475 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 476 */ "limit_clause_opt ::=",
 /* 477 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 478 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 479 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 480 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 481 */ "search_condition ::= common_expression",
 /* 482 */ "sort_specification_list ::= sort_specification",
 /* 483 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 484 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 485 */ "ordering_specification_opt ::=",
 /* 486 */ "ordering_specification_opt ::= ASC",
 /* 487 */ "ordering_specification_opt ::= DESC",
 /* 488 */ "null_ordering_opt ::=",
 /* 489 */ "null_ordering_opt ::= NULLS FIRST",
 /* 490 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 256: /* cmd */
    case 259: /* literal */
    case 270: /* db_options */
    case 272: /* alter_db_options */
    case 277: /* retention */
    case 278: /* full_table_name */
    case 281: /* table_options */
    case 285: /* alter_table_clause */
    case 286: /* alter_table_options */
    case 289: /* signed_literal */
    case 290: /* create_subtable_clause */
    case 293: /* drop_table_clause */
    case 296: /* column_def */
    case 300: /* duration_literal */
    case 301: /* rollup_func_name */
    case 303: /* col_name */
    case 304: /* db_name_cond_opt */
    case 305: /* like_pattern_opt */
    case 306: /* table_name_cond */
    case 307: /* from_db_opt */
    case 309: /* index_options */
    case 311: /* sliding_opt */
    case 312: /* sma_stream_opt */
    case 313: /* func */
    case 314: /* stream_options */
    case 316: /* query_expression */
    case 319: /* explain_options */
    case 323: /* into_opt */
    case 325: /* where_clause_opt */
    case 326: /* signed */
    case 327: /* literal_func */
    case 331: /* expression */
    case 332: /* pseudo_column */
    case 333: /* column_reference */
    case 334: /* function_expression */
    case 335: /* subquery */
    case 340: /* star_func_para */
    case 341: /* predicate */
    case 344: /* in_predicate_value */
    case 345: /* boolean_value_expression */
    case 346: /* boolean_primary */
    case 347: /* common_expression */
    case 348: /* from_clause_opt */
    case 349: /* table_reference_list */
    case 350: /* table_reference */
    case 351: /* table_primary */
    case 352: /* joined_table */
    case 354: /* parenthesized_joined_table */
    case 356: /* search_condition */
    case 357: /* query_specification */
    case 361: /* range_opt */
    case 362: /* every_opt */
    case 363: /* fill_opt */
    case 364: /* twindow_clause_opt */
    case 366: /* having_clause_opt */
    case 367: /* select_item */
    case 370: /* query_expression_body */
    case 372: /* slimit_clause_opt */
    case 373: /* limit_clause_opt */
    case 374: /* query_primary */
    case 376: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy616)); 
}
      break;
    case 257: /* account_options */
    case 258: /* alter_account_options */
    case 260: /* alter_account_option */
    case 321: /* bufsize_opt */
{
 
}
      break;
    case 261: /* user_name */
    case 264: /* priv_level */
    case 267: /* db_name */
    case 268: /* dnode_endpoint */
    case 287: /* column_name */
    case 295: /* table_name */
    case 302: /* function_name */
    case 308: /* index_name */
    case 315: /* topic_name */
    case 317: /* cgroup_name */
    case 322: /* stream_name */
    case 329: /* table_alias */
    case 330: /* column_alias */
    case 336: /* star_func */
    case 338: /* noarg_func */
    case 353: /* alias_opt */
{
 
}
      break;
    case 262: /* sysinfo_opt */
{
 
}
      break;
    case 263: /* privileges */
    case 265: /* priv_type_list */
    case 266: /* priv_type */
{
 
}
      break;
    case 269: /* not_exists_opt */
    case 271: /* exists_opt */
    case 318: /* analyze_opt */
    case 320: /* agg_func_opt */
    case 358: /* set_quantifier_opt */
{
 
}
      break;
    case 273: /* integer_list */
    case 274: /* variable_list */
    case 275: /* retention_list */
    case 279: /* column_def_list */
    case 280: /* tags_def_opt */
    case 282: /* multi_create_clause */
    case 283: /* tags_def */
    case 284: /* multi_drop_clause */
    case 291: /* specific_cols_opt */
    case 292: /* expression_list */
    case 294: /* col_name_list */
    case 297: /* duration_list */
    case 298: /* rollup_func_list */
    case 310: /* func_list */
    case 324: /* dnode_list */
    case 328: /* literal_list */
    case 337: /* star_func_para_list */
    case 339: /* other_para_list */
    case 359: /* select_list */
    case 360: /* partition_by_clause_opt */
    case 365: /* group_by_clause_opt */
    case 369: /* group_by_list */
    case 371: /* order_by_clause_opt */
    case 375: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy356)); 
}
      break;
    case 276: /* alter_db_option */
    case 299: /* alter_table_option */
{
 
}
      break;
    case 288: /* type_name */
{
 
}
      break;
    case 342: /* compare_op */
    case 343: /* in_op */
{
 
}
      break;
    case 355: /* join_type */
{
 
}
      break;
    case 368: /* fill_mode */
{
 
}
      break;
    case 377: /* ordering_specification_opt */
{
 
}
      break;
    case 378: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  256,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  256,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  257,    0 }, /* (2) account_options ::= */
  {  257,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  257,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  257,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  257,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  257,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  257,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  257,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  257,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  257,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  258,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  258,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  260,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  260,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  260,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  260,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  260,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  260,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  260,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  260,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  260,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  260,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  256,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  256,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  256,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  256,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  256,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  262,    0 }, /* (29) sysinfo_opt ::= */
  {  262,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  256,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  256,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  263,   -1 }, /* (33) privileges ::= ALL */
  {  263,   -1 }, /* (34) privileges ::= priv_type_list */
  {  265,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  265,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  266,   -1 }, /* (37) priv_type ::= READ */
  {  266,   -1 }, /* (38) priv_type ::= WRITE */
  {  264,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  264,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  256,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  256,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  256,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  256,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  256,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  256,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  256,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  256,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  268,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  268,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  268,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  256,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  256,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  256,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  256,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  256,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  256,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  256,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  256,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  256,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  256,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  256,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  256,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  256,   -2 }, /* (64) cmd ::= USE db_name */
  {  256,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  256,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  256,   -3 }, /* (67) cmd ::= TRIM DATABASE db_name */
  {  269,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  269,    0 }, /* (69) not_exists_opt ::= */
  {  271,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  271,    0 }, /* (71) exists_opt ::= */
  {  270,    0 }, /* (72) db_options ::= */
  {  270,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  270,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  270,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  270,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  270,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  270,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  270,   -3 }, /* (79) db_options ::= db_options FSYNC NK_INTEGER */
  {  270,   -3 }, /* (80) db_options ::= db_options MAXROWS NK_INTEGER */
  {  270,   -3 }, /* (81) db_options ::= db_options MINROWS NK_INTEGER */
  {  270,   -3 }, /* (82) db_options ::= db_options KEEP integer_list */
  {  270,   -3 }, /* (83) db_options ::= db_options KEEP variable_list */
  {  270,   -3 }, /* (84) db_options ::= db_options PAGES NK_INTEGER */
  {  270,   -3 }, /* (85) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  270,   -3 }, /* (86) db_options ::= db_options PRECISION NK_STRING */
  {  270,   -3 }, /* (87) db_options ::= db_options REPLICA NK_INTEGER */
  {  270,   -3 }, /* (88) db_options ::= db_options STRICT NK_STRING */
  {  270,   -3 }, /* (89) db_options ::= db_options WAL NK_INTEGER */
  {  270,   -3 }, /* (90) db_options ::= db_options VGROUPS NK_INTEGER */
  {  270,   -3 }, /* (91) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  270,   -3 }, /* (92) db_options ::= db_options RETENTIONS retention_list */
  {  270,   -3 }, /* (93) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  272,   -1 }, /* (94) alter_db_options ::= alter_db_option */
  {  272,   -2 }, /* (95) alter_db_options ::= alter_db_options alter_db_option */
  {  276,   -2 }, /* (96) alter_db_option ::= BUFFER NK_INTEGER */
  {  276,   -2 }, /* (97) alter_db_option ::= CACHEMODEL NK_STRING */
  {  276,   -2 }, /* (98) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  276,   -2 }, /* (99) alter_db_option ::= FSYNC NK_INTEGER */
  {  276,   -2 }, /* (100) alter_db_option ::= KEEP integer_list */
  {  276,   -2 }, /* (101) alter_db_option ::= KEEP variable_list */
  {  276,   -2 }, /* (102) alter_db_option ::= PAGES NK_INTEGER */
  {  276,   -2 }, /* (103) alter_db_option ::= REPLICA NK_INTEGER */
  {  276,   -2 }, /* (104) alter_db_option ::= STRICT NK_INTEGER */
  {  276,   -2 }, /* (105) alter_db_option ::= WAL NK_INTEGER */
  {  273,   -1 }, /* (106) integer_list ::= NK_INTEGER */
  {  273,   -3 }, /* (107) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  274,   -1 }, /* (108) variable_list ::= NK_VARIABLE */
  {  274,   -3 }, /* (109) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  275,   -1 }, /* (110) retention_list ::= retention */
  {  275,   -3 }, /* (111) retention_list ::= retention_list NK_COMMA retention */
  {  277,   -3 }, /* (112) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  256,   -9 }, /* (113) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  256,   -3 }, /* (114) cmd ::= CREATE TABLE multi_create_clause */
  {  256,   -9 }, /* (115) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  256,   -3 }, /* (116) cmd ::= DROP TABLE multi_drop_clause */
  {  256,   -4 }, /* (117) cmd ::= DROP STABLE exists_opt full_table_name */
  {  256,   -3 }, /* (118) cmd ::= ALTER TABLE alter_table_clause */
  {  256,   -3 }, /* (119) cmd ::= ALTER STABLE alter_table_clause */
  {  285,   -2 }, /* (120) alter_table_clause ::= full_table_name alter_table_options */
  {  285,   -5 }, /* (121) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  285,   -4 }, /* (122) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  285,   -5 }, /* (123) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  285,   -5 }, /* (124) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  285,   -5 }, /* (125) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  285,   -4 }, /* (126) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  285,   -5 }, /* (127) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  285,   -5 }, /* (128) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  285,   -6 }, /* (129) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  282,   -1 }, /* (130) multi_create_clause ::= create_subtable_clause */
  {  282,   -2 }, /* (131) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  290,  -10 }, /* (132) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  284,   -1 }, /* (133) multi_drop_clause ::= drop_table_clause */
  {  284,   -2 }, /* (134) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  293,   -2 }, /* (135) drop_table_clause ::= exists_opt full_table_name */
  {  291,    0 }, /* (136) specific_cols_opt ::= */
  {  291,   -3 }, /* (137) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  278,   -1 }, /* (138) full_table_name ::= table_name */
  {  278,   -3 }, /* (139) full_table_name ::= db_name NK_DOT table_name */
  {  279,   -1 }, /* (140) column_def_list ::= column_def */
  {  279,   -3 }, /* (141) column_def_list ::= column_def_list NK_COMMA column_def */
  {  296,   -2 }, /* (142) column_def ::= column_name type_name */
  {  296,   -4 }, /* (143) column_def ::= column_name type_name COMMENT NK_STRING */
  {  288,   -1 }, /* (144) type_name ::= BOOL */
  {  288,   -1 }, /* (145) type_name ::= TINYINT */
  {  288,   -1 }, /* (146) type_name ::= SMALLINT */
  {  288,   -1 }, /* (147) type_name ::= INT */
  {  288,   -1 }, /* (148) type_name ::= INTEGER */
  {  288,   -1 }, /* (149) type_name ::= BIGINT */
  {  288,   -1 }, /* (150) type_name ::= FLOAT */
  {  288,   -1 }, /* (151) type_name ::= DOUBLE */
  {  288,   -4 }, /* (152) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  288,   -1 }, /* (153) type_name ::= TIMESTAMP */
  {  288,   -4 }, /* (154) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  288,   -2 }, /* (155) type_name ::= TINYINT UNSIGNED */
  {  288,   -2 }, /* (156) type_name ::= SMALLINT UNSIGNED */
  {  288,   -2 }, /* (157) type_name ::= INT UNSIGNED */
  {  288,   -2 }, /* (158) type_name ::= BIGINT UNSIGNED */
  {  288,   -1 }, /* (159) type_name ::= JSON */
  {  288,   -4 }, /* (160) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  288,   -1 }, /* (161) type_name ::= MEDIUMBLOB */
  {  288,   -1 }, /* (162) type_name ::= BLOB */
  {  288,   -4 }, /* (163) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  288,   -1 }, /* (164) type_name ::= DECIMAL */
  {  288,   -4 }, /* (165) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  288,   -6 }, /* (166) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  280,    0 }, /* (167) tags_def_opt ::= */
  {  280,   -1 }, /* (168) tags_def_opt ::= tags_def */
  {  283,   -4 }, /* (169) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  281,    0 }, /* (170) table_options ::= */
  {  281,   -3 }, /* (171) table_options ::= table_options COMMENT NK_STRING */
  {  281,   -3 }, /* (172) table_options ::= table_options MAX_DELAY duration_list */
  {  281,   -3 }, /* (173) table_options ::= table_options WATERMARK duration_list */
  {  281,   -5 }, /* (174) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  281,   -3 }, /* (175) table_options ::= table_options TTL NK_INTEGER */
  {  281,   -5 }, /* (176) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  286,   -1 }, /* (177) alter_table_options ::= alter_table_option */
  {  286,   -2 }, /* (178) alter_table_options ::= alter_table_options alter_table_option */
  {  299,   -2 }, /* (179) alter_table_option ::= COMMENT NK_STRING */
  {  299,   -2 }, /* (180) alter_table_option ::= TTL NK_INTEGER */
  {  297,   -1 }, /* (181) duration_list ::= duration_literal */
  {  297,   -3 }, /* (182) duration_list ::= duration_list NK_COMMA duration_literal */
  {  298,   -1 }, /* (183) rollup_func_list ::= rollup_func_name */
  {  298,   -3 }, /* (184) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  301,   -1 }, /* (185) rollup_func_name ::= function_name */
  {  301,   -1 }, /* (186) rollup_func_name ::= FIRST */
  {  301,   -1 }, /* (187) rollup_func_name ::= LAST */
  {  294,   -1 }, /* (188) col_name_list ::= col_name */
  {  294,   -3 }, /* (189) col_name_list ::= col_name_list NK_COMMA col_name */
  {  303,   -1 }, /* (190) col_name ::= column_name */
  {  256,   -2 }, /* (191) cmd ::= SHOW DNODES */
  {  256,   -2 }, /* (192) cmd ::= SHOW USERS */
  {  256,   -2 }, /* (193) cmd ::= SHOW DATABASES */
  {  256,   -4 }, /* (194) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  256,   -4 }, /* (195) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  256,   -3 }, /* (196) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  256,   -2 }, /* (197) cmd ::= SHOW MNODES */
  {  256,   -2 }, /* (198) cmd ::= SHOW MODULES */
  {  256,   -2 }, /* (199) cmd ::= SHOW QNODES */
  {  256,   -2 }, /* (200) cmd ::= SHOW FUNCTIONS */
  {  256,   -5 }, /* (201) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  256,   -2 }, /* (202) cmd ::= SHOW STREAMS */
  {  256,   -2 }, /* (203) cmd ::= SHOW ACCOUNTS */
  {  256,   -2 }, /* (204) cmd ::= SHOW APPS */
  {  256,   -2 }, /* (205) cmd ::= SHOW CONNECTIONS */
  {  256,   -2 }, /* (206) cmd ::= SHOW LICENCE */
  {  256,   -2 }, /* (207) cmd ::= SHOW GRANTS */
  {  256,   -4 }, /* (208) cmd ::= SHOW CREATE DATABASE db_name */
  {  256,   -4 }, /* (209) cmd ::= SHOW CREATE TABLE full_table_name */
  {  256,   -4 }, /* (210) cmd ::= SHOW CREATE STABLE full_table_name */
  {  256,   -2 }, /* (211) cmd ::= SHOW QUERIES */
  {  256,   -2 }, /* (212) cmd ::= SHOW SCORES */
  {  256,   -2 }, /* (213) cmd ::= SHOW TOPICS */
  {  256,   -2 }, /* (214) cmd ::= SHOW VARIABLES */
  {  256,   -3 }, /* (215) cmd ::= SHOW LOCAL VARIABLES */
  {  256,   -4 }, /* (216) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  256,   -2 }, /* (217) cmd ::= SHOW BNODES */
  {  256,   -2 }, /* (218) cmd ::= SHOW SNODES */
  {  256,   -2 }, /* (219) cmd ::= SHOW CLUSTER */
  {  256,   -2 }, /* (220) cmd ::= SHOW TRANSACTIONS */
  {  256,   -4 }, /* (221) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  256,   -2 }, /* (222) cmd ::= SHOW CONSUMERS */
  {  256,   -2 }, /* (223) cmd ::= SHOW SUBSCRIPTIONS */
  {  304,    0 }, /* (224) db_name_cond_opt ::= */
  {  304,   -2 }, /* (225) db_name_cond_opt ::= db_name NK_DOT */
  {  305,    0 }, /* (226) like_pattern_opt ::= */
  {  305,   -2 }, /* (227) like_pattern_opt ::= LIKE NK_STRING */
  {  306,   -1 }, /* (228) table_name_cond ::= table_name */
  {  307,    0 }, /* (229) from_db_opt ::= */
  {  307,   -2 }, /* (230) from_db_opt ::= FROM db_name */
  {  256,   -8 }, /* (231) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  256,   -4 }, /* (232) cmd ::= DROP INDEX exists_opt index_name */
  {  309,  -10 }, /* (233) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  309,  -12 }, /* (234) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  310,   -1 }, /* (235) func_list ::= func */
  {  310,   -3 }, /* (236) func_list ::= func_list NK_COMMA func */
  {  313,   -4 }, /* (237) func ::= function_name NK_LP expression_list NK_RP */
  {  312,    0 }, /* (238) sma_stream_opt ::= */
  {  312,   -3 }, /* (239) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  312,   -3 }, /* (240) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  256,   -6 }, /* (241) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  256,   -7 }, /* (242) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  256,   -9 }, /* (243) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  256,   -7 }, /* (244) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  256,   -9 }, /* (245) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  256,   -4 }, /* (246) cmd ::= DROP TOPIC exists_opt topic_name */
  {  256,   -7 }, /* (247) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  256,   -2 }, /* (248) cmd ::= DESC full_table_name */
  {  256,   -2 }, /* (249) cmd ::= DESCRIBE full_table_name */
  {  256,   -3 }, /* (250) cmd ::= RESET QUERY CACHE */
  {  256,   -4 }, /* (251) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  318,    0 }, /* (252) analyze_opt ::= */
  {  318,   -1 }, /* (253) analyze_opt ::= ANALYZE */
  {  319,    0 }, /* (254) explain_options ::= */
  {  319,   -3 }, /* (255) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  319,   -3 }, /* (256) explain_options ::= explain_options RATIO NK_FLOAT */
  {  256,   -6 }, /* (257) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  256,  -10 }, /* (258) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  256,   -4 }, /* (259) cmd ::= DROP FUNCTION exists_opt function_name */
  {  320,    0 }, /* (260) agg_func_opt ::= */
  {  320,   -1 }, /* (261) agg_func_opt ::= AGGREGATE */
  {  321,    0 }, /* (262) bufsize_opt ::= */
  {  321,   -2 }, /* (263) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  256,   -8 }, /* (264) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  256,   -4 }, /* (265) cmd ::= DROP STREAM exists_opt stream_name */
  {  323,    0 }, /* (266) into_opt ::= */
  {  323,   -2 }, /* (267) into_opt ::= INTO full_table_name */
  {  314,    0 }, /* (268) stream_options ::= */
  {  314,   -3 }, /* (269) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  314,   -3 }, /* (270) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  314,   -4 }, /* (271) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  314,   -3 }, /* (272) stream_options ::= stream_options WATERMARK duration_literal */
  {  314,   -3 }, /* (273) stream_options ::= stream_options IGNORE EXPIRED */
  {  256,   -3 }, /* (274) cmd ::= KILL CONNECTION NK_INTEGER */
  {  256,   -3 }, /* (275) cmd ::= KILL QUERY NK_STRING */
  {  256,   -3 }, /* (276) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  256,   -2 }, /* (277) cmd ::= BALANCE VGROUP */
  {  256,   -4 }, /* (278) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  256,   -4 }, /* (279) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  256,   -3 }, /* (280) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  324,   -2 }, /* (281) dnode_list ::= DNODE NK_INTEGER */
  {  324,   -3 }, /* (282) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  256,   -3 }, /* (283) cmd ::= SYNCDB db_name REPLICA */
  {  256,   -4 }, /* (284) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  256,   -1 }, /* (285) cmd ::= query_expression */
  {  256,   -7 }, /* (286) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
  {  256,   -4 }, /* (287) cmd ::= INSERT INTO full_table_name query_expression */
  {  259,   -1 }, /* (288) literal ::= NK_INTEGER */
  {  259,   -1 }, /* (289) literal ::= NK_FLOAT */
  {  259,   -1 }, /* (290) literal ::= NK_STRING */
  {  259,   -1 }, /* (291) literal ::= NK_BOOL */
  {  259,   -2 }, /* (292) literal ::= TIMESTAMP NK_STRING */
  {  259,   -1 }, /* (293) literal ::= duration_literal */
  {  259,   -1 }, /* (294) literal ::= NULL */
  {  259,   -1 }, /* (295) literal ::= NK_QUESTION */
  {  300,   -1 }, /* (296) duration_literal ::= NK_VARIABLE */
  {  326,   -1 }, /* (297) signed ::= NK_INTEGER */
  {  326,   -2 }, /* (298) signed ::= NK_PLUS NK_INTEGER */
  {  326,   -2 }, /* (299) signed ::= NK_MINUS NK_INTEGER */
  {  326,   -1 }, /* (300) signed ::= NK_FLOAT */
  {  326,   -2 }, /* (301) signed ::= NK_PLUS NK_FLOAT */
  {  326,   -2 }, /* (302) signed ::= NK_MINUS NK_FLOAT */
  {  289,   -1 }, /* (303) signed_literal ::= signed */
  {  289,   -1 }, /* (304) signed_literal ::= NK_STRING */
  {  289,   -1 }, /* (305) signed_literal ::= NK_BOOL */
  {  289,   -2 }, /* (306) signed_literal ::= TIMESTAMP NK_STRING */
  {  289,   -1 }, /* (307) signed_literal ::= duration_literal */
  {  289,   -1 }, /* (308) signed_literal ::= NULL */
  {  289,   -1 }, /* (309) signed_literal ::= literal_func */
  {  289,   -1 }, /* (310) signed_literal ::= NK_QUESTION */
  {  328,   -1 }, /* (311) literal_list ::= signed_literal */
  {  328,   -3 }, /* (312) literal_list ::= literal_list NK_COMMA signed_literal */
  {  267,   -1 }, /* (313) db_name ::= NK_ID */
  {  295,   -1 }, /* (314) table_name ::= NK_ID */
  {  287,   -1 }, /* (315) column_name ::= NK_ID */
  {  302,   -1 }, /* (316) function_name ::= NK_ID */
  {  329,   -1 }, /* (317) table_alias ::= NK_ID */
  {  330,   -1 }, /* (318) column_alias ::= NK_ID */
  {  261,   -1 }, /* (319) user_name ::= NK_ID */
  {  308,   -1 }, /* (320) index_name ::= NK_ID */
  {  315,   -1 }, /* (321) topic_name ::= NK_ID */
  {  322,   -1 }, /* (322) stream_name ::= NK_ID */
  {  317,   -1 }, /* (323) cgroup_name ::= NK_ID */
  {  331,   -1 }, /* (324) expression ::= literal */
  {  331,   -1 }, /* (325) expression ::= pseudo_column */
  {  331,   -1 }, /* (326) expression ::= column_reference */
  {  331,   -1 }, /* (327) expression ::= function_expression */
  {  331,   -1 }, /* (328) expression ::= subquery */
  {  331,   -3 }, /* (329) expression ::= NK_LP expression NK_RP */
  {  331,   -2 }, /* (330) expression ::= NK_PLUS expression */
  {  331,   -2 }, /* (331) expression ::= NK_MINUS expression */
  {  331,   -3 }, /* (332) expression ::= expression NK_PLUS expression */
  {  331,   -3 }, /* (333) expression ::= expression NK_MINUS expression */
  {  331,   -3 }, /* (334) expression ::= expression NK_STAR expression */
  {  331,   -3 }, /* (335) expression ::= expression NK_SLASH expression */
  {  331,   -3 }, /* (336) expression ::= expression NK_REM expression */
  {  331,   -3 }, /* (337) expression ::= column_reference NK_ARROW NK_STRING */
  {  331,   -3 }, /* (338) expression ::= expression NK_BITAND expression */
  {  331,   -3 }, /* (339) expression ::= expression NK_BITOR expression */
  {  292,   -1 }, /* (340) expression_list ::= expression */
  {  292,   -3 }, /* (341) expression_list ::= expression_list NK_COMMA expression */
  {  333,   -1 }, /* (342) column_reference ::= column_name */
  {  333,   -3 }, /* (343) column_reference ::= table_name NK_DOT column_name */
  {  332,   -1 }, /* (344) pseudo_column ::= ROWTS */
  {  332,   -1 }, /* (345) pseudo_column ::= TBNAME */
  {  332,   -3 }, /* (346) pseudo_column ::= table_name NK_DOT TBNAME */
  {  332,   -1 }, /* (347) pseudo_column ::= QSTART */
  {  332,   -1 }, /* (348) pseudo_column ::= QEND */
  {  332,   -1 }, /* (349) pseudo_column ::= QDURATION */
  {  332,   -1 }, /* (350) pseudo_column ::= WSTART */
  {  332,   -1 }, /* (351) pseudo_column ::= WEND */
  {  332,   -1 }, /* (352) pseudo_column ::= WDURATION */
  {  334,   -4 }, /* (353) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  334,   -4 }, /* (354) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  334,   -6 }, /* (355) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  334,   -1 }, /* (356) function_expression ::= literal_func */
  {  327,   -3 }, /* (357) literal_func ::= noarg_func NK_LP NK_RP */
  {  327,   -1 }, /* (358) literal_func ::= NOW */
  {  338,   -1 }, /* (359) noarg_func ::= NOW */
  {  338,   -1 }, /* (360) noarg_func ::= TODAY */
  {  338,   -1 }, /* (361) noarg_func ::= TIMEZONE */
  {  338,   -1 }, /* (362) noarg_func ::= DATABASE */
  {  338,   -1 }, /* (363) noarg_func ::= CLIENT_VERSION */
  {  338,   -1 }, /* (364) noarg_func ::= SERVER_VERSION */
  {  338,   -1 }, /* (365) noarg_func ::= SERVER_STATUS */
  {  338,   -1 }, /* (366) noarg_func ::= CURRENT_USER */
  {  338,   -1 }, /* (367) noarg_func ::= USER */
  {  336,   -1 }, /* (368) star_func ::= COUNT */
  {  336,   -1 }, /* (369) star_func ::= FIRST */
  {  336,   -1 }, /* (370) star_func ::= LAST */
  {  336,   -1 }, /* (371) star_func ::= LAST_ROW */
  {  337,   -1 }, /* (372) star_func_para_list ::= NK_STAR */
  {  337,   -1 }, /* (373) star_func_para_list ::= other_para_list */
  {  339,   -1 }, /* (374) other_para_list ::= star_func_para */
  {  339,   -3 }, /* (375) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  340,   -1 }, /* (376) star_func_para ::= expression */
  {  340,   -3 }, /* (377) star_func_para ::= table_name NK_DOT NK_STAR */
  {  341,   -3 }, /* (378) predicate ::= expression compare_op expression */
  {  341,   -5 }, /* (379) predicate ::= expression BETWEEN expression AND expression */
  {  341,   -6 }, /* (380) predicate ::= expression NOT BETWEEN expression AND expression */
  {  341,   -3 }, /* (381) predicate ::= expression IS NULL */
  {  341,   -4 }, /* (382) predicate ::= expression IS NOT NULL */
  {  341,   -3 }, /* (383) predicate ::= expression in_op in_predicate_value */
  {  342,   -1 }, /* (384) compare_op ::= NK_LT */
  {  342,   -1 }, /* (385) compare_op ::= NK_GT */
  {  342,   -1 }, /* (386) compare_op ::= NK_LE */
  {  342,   -1 }, /* (387) compare_op ::= NK_GE */
  {  342,   -1 }, /* (388) compare_op ::= NK_NE */
  {  342,   -1 }, /* (389) compare_op ::= NK_EQ */
  {  342,   -1 }, /* (390) compare_op ::= LIKE */
  {  342,   -2 }, /* (391) compare_op ::= NOT LIKE */
  {  342,   -1 }, /* (392) compare_op ::= MATCH */
  {  342,   -1 }, /* (393) compare_op ::= NMATCH */
  {  342,   -1 }, /* (394) compare_op ::= CONTAINS */
  {  343,   -1 }, /* (395) in_op ::= IN */
  {  343,   -2 }, /* (396) in_op ::= NOT IN */
  {  344,   -3 }, /* (397) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  345,   -1 }, /* (398) boolean_value_expression ::= boolean_primary */
  {  345,   -2 }, /* (399) boolean_value_expression ::= NOT boolean_primary */
  {  345,   -3 }, /* (400) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  345,   -3 }, /* (401) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  346,   -1 }, /* (402) boolean_primary ::= predicate */
  {  346,   -3 }, /* (403) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  347,   -1 }, /* (404) common_expression ::= expression */
  {  347,   -1 }, /* (405) common_expression ::= boolean_value_expression */
  {  348,    0 }, /* (406) from_clause_opt ::= */
  {  348,   -2 }, /* (407) from_clause_opt ::= FROM table_reference_list */
  {  349,   -1 }, /* (408) table_reference_list ::= table_reference */
  {  349,   -3 }, /* (409) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  350,   -1 }, /* (410) table_reference ::= table_primary */
  {  350,   -1 }, /* (411) table_reference ::= joined_table */
  {  351,   -2 }, /* (412) table_primary ::= table_name alias_opt */
  {  351,   -4 }, /* (413) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  351,   -2 }, /* (414) table_primary ::= subquery alias_opt */
  {  351,   -1 }, /* (415) table_primary ::= parenthesized_joined_table */
  {  353,    0 }, /* (416) alias_opt ::= */
  {  353,   -1 }, /* (417) alias_opt ::= table_alias */
  {  353,   -2 }, /* (418) alias_opt ::= AS table_alias */
  {  354,   -3 }, /* (419) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  354,   -3 }, /* (420) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  352,   -6 }, /* (421) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  355,    0 }, /* (422) join_type ::= */
  {  355,   -1 }, /* (423) join_type ::= INNER */
  {  357,  -12 }, /* (424) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  358,    0 }, /* (425) set_quantifier_opt ::= */
  {  358,   -1 }, /* (426) set_quantifier_opt ::= DISTINCT */
  {  358,   -1 }, /* (427) set_quantifier_opt ::= ALL */
  {  359,   -1 }, /* (428) select_list ::= select_item */
  {  359,   -3 }, /* (429) select_list ::= select_list NK_COMMA select_item */
  {  367,   -1 }, /* (430) select_item ::= NK_STAR */
  {  367,   -1 }, /* (431) select_item ::= common_expression */
  {  367,   -2 }, /* (432) select_item ::= common_expression column_alias */
  {  367,   -3 }, /* (433) select_item ::= common_expression AS column_alias */
  {  367,   -3 }, /* (434) select_item ::= table_name NK_DOT NK_STAR */
  {  325,    0 }, /* (435) where_clause_opt ::= */
  {  325,   -2 }, /* (436) where_clause_opt ::= WHERE search_condition */
  {  360,    0 }, /* (437) partition_by_clause_opt ::= */
  {  360,   -3 }, /* (438) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  364,    0 }, /* (439) twindow_clause_opt ::= */
  {  364,   -6 }, /* (440) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  364,   -4 }, /* (441) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  364,   -6 }, /* (442) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  364,   -8 }, /* (443) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  311,    0 }, /* (444) sliding_opt ::= */
  {  311,   -4 }, /* (445) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  363,    0 }, /* (446) fill_opt ::= */
  {  363,   -4 }, /* (447) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  363,   -6 }, /* (448) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  368,   -1 }, /* (449) fill_mode ::= NONE */
  {  368,   -1 }, /* (450) fill_mode ::= PREV */
  {  368,   -1 }, /* (451) fill_mode ::= NULL */
  {  368,   -1 }, /* (452) fill_mode ::= LINEAR */
  {  368,   -1 }, /* (453) fill_mode ::= NEXT */
  {  365,    0 }, /* (454) group_by_clause_opt ::= */
  {  365,   -3 }, /* (455) group_by_clause_opt ::= GROUP BY group_by_list */
  {  369,   -1 }, /* (456) group_by_list ::= expression */
  {  369,   -3 }, /* (457) group_by_list ::= group_by_list NK_COMMA expression */
  {  366,    0 }, /* (458) having_clause_opt ::= */
  {  366,   -2 }, /* (459) having_clause_opt ::= HAVING search_condition */
  {  361,    0 }, /* (460) range_opt ::= */
  {  361,   -6 }, /* (461) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  362,    0 }, /* (462) every_opt ::= */
  {  362,   -4 }, /* (463) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  316,   -4 }, /* (464) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  370,   -1 }, /* (465) query_expression_body ::= query_primary */
  {  370,   -4 }, /* (466) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  370,   -3 }, /* (467) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  374,   -1 }, /* (468) query_primary ::= query_specification */
  {  374,   -6 }, /* (469) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  371,    0 }, /* (470) order_by_clause_opt ::= */
  {  371,   -3 }, /* (471) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  372,    0 }, /* (472) slimit_clause_opt ::= */
  {  372,   -2 }, /* (473) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  372,   -4 }, /* (474) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  372,   -4 }, /* (475) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  373,    0 }, /* (476) limit_clause_opt ::= */
  {  373,   -2 }, /* (477) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  373,   -4 }, /* (478) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  373,   -4 }, /* (479) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  335,   -3 }, /* (480) subquery ::= NK_LP query_expression NK_RP */
  {  356,   -1 }, /* (481) search_condition ::= common_expression */
  {  375,   -1 }, /* (482) sort_specification_list ::= sort_specification */
  {  375,   -3 }, /* (483) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  376,   -3 }, /* (484) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  377,    0 }, /* (485) ordering_specification_opt ::= */
  {  377,   -1 }, /* (486) ordering_specification_opt ::= ASC */
  {  377,   -1 }, /* (487) ordering_specification_opt ::= DESC */
  {  378,    0 }, /* (488) null_ordering_opt ::= */
  {  378,   -2 }, /* (489) null_ordering_opt ::= NULLS FIRST */
  {  378,   -2 }, /* (490) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,257,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,258,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,257,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,259,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,260,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,258,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,260,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,259,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy361, &yymsp[-1].minor.yy0, yymsp[0].minor.yy285); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy361, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy361, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy361, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy361); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy285 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy285 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy457, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy361); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy457, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy361); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy457 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy457 = yymsp[0].minor.yy457; }
  yymsp[0].minor.yy457 = yylhsminor.yy457;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy457 = yymsp[-2].minor.yy457 | yymsp[0].minor.yy457; }
  yymsp[-2].minor.yy457 = yylhsminor.yy457;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy457 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy457 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy361 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy361 = yylhsminor.yy361;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy361 = yymsp[-2].minor.yy361; }
  yymsp[-2].minor.yy361 = yylhsminor.yy361;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy361, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy361); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 313: /* db_name ::= NK_ID */ yytestcase(yyruleno==313);
      case 314: /* table_name ::= NK_ID */ yytestcase(yyruleno==314);
      case 315: /* column_name ::= NK_ID */ yytestcase(yyruleno==315);
      case 316: /* function_name ::= NK_ID */ yytestcase(yyruleno==316);
      case 317: /* table_alias ::= NK_ID */ yytestcase(yyruleno==317);
      case 318: /* column_alias ::= NK_ID */ yytestcase(yyruleno==318);
      case 319: /* user_name ::= NK_ID */ yytestcase(yyruleno==319);
      case 320: /* index_name ::= NK_ID */ yytestcase(yyruleno==320);
      case 321: /* topic_name ::= NK_ID */ yytestcase(yyruleno==321);
      case 322: /* stream_name ::= NK_ID */ yytestcase(yyruleno==322);
      case 323: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==323);
      case 359: /* noarg_func ::= NOW */ yytestcase(yyruleno==359);
      case 360: /* noarg_func ::= TODAY */ yytestcase(yyruleno==360);
      case 361: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==361);
      case 362: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==362);
      case 363: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==363);
      case 364: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==364);
      case 365: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==365);
      case 366: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==366);
      case 367: /* noarg_func ::= USER */ yytestcase(yyruleno==367);
      case 368: /* star_func ::= COUNT */ yytestcase(yyruleno==368);
      case 369: /* star_func ::= FIRST */ yytestcase(yyruleno==369);
      case 370: /* star_func ::= LAST */ yytestcase(yyruleno==370);
      case 371: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==371);
{ yylhsminor.yy361 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy361 = yylhsminor.yy361;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy151, &yymsp[-1].minor.yy361, yymsp[0].minor.yy616); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy151, &yymsp[0].minor.yy361); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy361); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy361, yymsp[0].minor.yy616); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy361); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[0].minor.yy361); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy151 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 252: /* analyze_opt ::= */ yytestcase(yyruleno==252);
      case 260: /* agg_func_opt ::= */ yytestcase(yyruleno==260);
      case 425: /* set_quantifier_opt ::= */ yytestcase(yyruleno==425);
{ yymsp[1].minor.yy151 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy151 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy616 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 79: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 80: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 81: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 82: /* db_options ::= db_options KEEP integer_list */
      case 83: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==83);
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_KEEP, yymsp[0].minor.yy356); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 84: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 85: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 86: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 87: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 88: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 89: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 90: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 91: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 92: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_RETENTIONS, yymsp[0].minor.yy356); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 93: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 94: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy616 = createAlterDatabaseOptions(pCxt); yylhsminor.yy616 = setAlterDatabaseOption(pCxt, yylhsminor.yy616, &yymsp[0].minor.yy409); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 95: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy616 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy616, &yymsp[0].minor.yy409); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 96: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy409.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy409.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 98: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy409.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy409.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 100: /* alter_db_option ::= KEEP integer_list */
      case 101: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==101);
{ yymsp[-1].minor.yy409.type = DB_OPTION_KEEP; yymsp[-1].minor.yy409.pList = yymsp[0].minor.yy356; }
        break;
      case 102: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy409.type = DB_OPTION_PAGES; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 103: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy409.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 104: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy409.type = DB_OPTION_STRICT; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 105: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy409.type = DB_OPTION_WAL; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 106: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy356 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 107: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 282: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==282);
{ yylhsminor.yy356 = addNodeToList(pCxt, yymsp[-2].minor.yy356, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy356 = yylhsminor.yy356;
        break;
      case 108: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy356 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 109: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy356 = addNodeToList(pCxt, yymsp[-2].minor.yy356, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy356 = yylhsminor.yy356;
        break;
      case 110: /* retention_list ::= retention */
      case 130: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==130);
      case 133: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==133);
      case 140: /* column_def_list ::= column_def */ yytestcase(yyruleno==140);
      case 183: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==183);
      case 188: /* col_name_list ::= col_name */ yytestcase(yyruleno==188);
      case 235: /* func_list ::= func */ yytestcase(yyruleno==235);
      case 311: /* literal_list ::= signed_literal */ yytestcase(yyruleno==311);
      case 374: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==374);
      case 428: /* select_list ::= select_item */ yytestcase(yyruleno==428);
      case 482: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==482);
{ yylhsminor.yy356 = createNodeList(pCxt, yymsp[0].minor.yy616); }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 111: /* retention_list ::= retention_list NK_COMMA retention */
      case 141: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==141);
      case 184: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==184);
      case 189: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==189);
      case 236: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==236);
      case 312: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==312);
      case 375: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==375);
      case 429: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==429);
      case 483: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==483);
{ yylhsminor.yy356 = addNodeToList(pCxt, yymsp[-2].minor.yy356, yymsp[0].minor.yy616); }
  yymsp[-2].minor.yy356 = yylhsminor.yy356;
        break;
      case 112: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy616 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 113: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 115: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==115);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy151, yymsp[-5].minor.yy616, yymsp[-3].minor.yy356, yymsp[-1].minor.yy356, yymsp[0].minor.yy616); }
        break;
      case 114: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy356); }
        break;
      case 116: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy356); }
        break;
      case 117: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy151, yymsp[0].minor.yy616); }
        break;
      case 118: /* cmd ::= ALTER TABLE alter_table_clause */
      case 285: /* cmd ::= query_expression */ yytestcase(yyruleno==285);
{ pCxt->pRootNode = yymsp[0].minor.yy616; }
        break;
      case 119: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy616); }
        break;
      case 120: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy616 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 121: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy616 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy361, yymsp[0].minor.yy600); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 122: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy616 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy616, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy361); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 123: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy616 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy361, yymsp[0].minor.yy600); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 124: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy616 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy361, &yymsp[0].minor.yy361); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 125: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy616 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy361, yymsp[0].minor.yy600); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 126: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy616 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy616, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy361); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 127: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy616 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy361, yymsp[0].minor.yy600); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 128: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy616 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy361, &yymsp[0].minor.yy361); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 129: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy616 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy616, &yymsp[-2].minor.yy361, yymsp[0].minor.yy616); }
  yymsp[-5].minor.yy616 = yylhsminor.yy616;
        break;
      case 131: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 134: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==134);
{ yylhsminor.yy356 = addNodeToList(pCxt, yymsp[-1].minor.yy356, yymsp[0].minor.yy616); }
  yymsp[-1].minor.yy356 = yylhsminor.yy356;
        break;
      case 132: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy616 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy151, yymsp[-8].minor.yy616, yymsp[-6].minor.yy616, yymsp[-5].minor.yy356, yymsp[-2].minor.yy356, yymsp[0].minor.yy616); }
  yymsp[-9].minor.yy616 = yylhsminor.yy616;
        break;
      case 135: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy616 = createDropTableClause(pCxt, yymsp[-1].minor.yy151, yymsp[0].minor.yy616); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 136: /* specific_cols_opt ::= */
      case 167: /* tags_def_opt ::= */ yytestcase(yyruleno==167);
      case 437: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==437);
      case 454: /* group_by_clause_opt ::= */ yytestcase(yyruleno==454);
      case 470: /* order_by_clause_opt ::= */ yytestcase(yyruleno==470);
{ yymsp[1].minor.yy356 = NULL; }
        break;
      case 137: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy356 = yymsp[-1].minor.yy356; }
        break;
      case 138: /* full_table_name ::= table_name */
{ yylhsminor.yy616 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy361, NULL); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 139: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy616 = createRealTableNode(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy361, NULL); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 142: /* column_def ::= column_name type_name */
{ yylhsminor.yy616 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy361, yymsp[0].minor.yy600, NULL); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 143: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy616 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy361, yymsp[-2].minor.yy600, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 144: /* type_name ::= BOOL */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 145: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 146: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 147: /* type_name ::= INT */
      case 148: /* type_name ::= INTEGER */ yytestcase(yyruleno==148);
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 149: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 150: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 151: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 152: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy600 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 153: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 154: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy600 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 155: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy600 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 156: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy600 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 157: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy600 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 158: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy600 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 159: /* type_name ::= JSON */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 160: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy600 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 161: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 162: /* type_name ::= BLOB */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 163: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy600 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 164: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 165: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy600 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 166: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy600 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 168: /* tags_def_opt ::= tags_def */
      case 373: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==373);
{ yylhsminor.yy356 = yymsp[0].minor.yy356; }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 169: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy356 = yymsp[-1].minor.yy356; }
        break;
      case 170: /* table_options ::= */
{ yymsp[1].minor.yy616 = createDefaultTableOptions(pCxt); }
        break;
      case 171: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-2].minor.yy616, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 172: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-2].minor.yy616, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy356); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 173: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-2].minor.yy616, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy356); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 174: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-4].minor.yy616, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy356); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 175: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-2].minor.yy616, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 176: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-4].minor.yy616, TABLE_OPTION_SMA, yymsp[-1].minor.yy356); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 177: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy616 = createAlterTableOptions(pCxt); yylhsminor.yy616 = setTableOption(pCxt, yylhsminor.yy616, yymsp[0].minor.yy409.type, &yymsp[0].minor.yy409.val); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 178: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-1].minor.yy616, yymsp[0].minor.yy409.type, &yymsp[0].minor.yy409.val); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 179: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy409.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 180: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy409.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 181: /* duration_list ::= duration_literal */
      case 340: /* expression_list ::= expression */ yytestcase(yyruleno==340);
{ yylhsminor.yy356 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy616)); }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 182: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 341: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==341);
{ yylhsminor.yy356 = addNodeToList(pCxt, yymsp[-2].minor.yy356, releaseRawExprNode(pCxt, yymsp[0].minor.yy616)); }
  yymsp[-2].minor.yy356 = yylhsminor.yy356;
        break;
      case 185: /* rollup_func_name ::= function_name */
{ yylhsminor.yy616 = createFunctionNode(pCxt, &yymsp[0].minor.yy361, NULL); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 186: /* rollup_func_name ::= FIRST */
      case 187: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==187);
{ yylhsminor.yy616 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 190: /* col_name ::= column_name */
{ yylhsminor.yy616 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy361); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 191: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 192: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 193: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 194: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy616, yymsp[0].minor.yy616, OP_TYPE_LIKE); }
        break;
      case 195: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy616, yymsp[0].minor.yy616, OP_TYPE_LIKE); }
        break;
      case 196: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy616, NULL, OP_TYPE_LIKE); }
        break;
      case 197: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 198: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 199: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 200: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 201: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy616, yymsp[-1].minor.yy616, OP_TYPE_EQUAL); }
        break;
      case 202: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 203: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 204: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 205: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 206: /* cmd ::= SHOW LICENCE */
      case 207: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==207);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT); }
        break;
      case 208: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy361); }
        break;
      case 209: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy616); }
        break;
      case 210: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy616); }
        break;
      case 211: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 212: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 213: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 214: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 215: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 216: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 217: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 218: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 219: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 220: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 221: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy616); }
        break;
      case 222: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 223: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 224: /* db_name_cond_opt ::= */
      case 229: /* from_db_opt ::= */ yytestcase(yyruleno==229);
{ yymsp[1].minor.yy616 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 225: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy361); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 226: /* like_pattern_opt ::= */
      case 266: /* into_opt ::= */ yytestcase(yyruleno==266);
      case 406: /* from_clause_opt ::= */ yytestcase(yyruleno==406);
      case 435: /* where_clause_opt ::= */ yytestcase(yyruleno==435);
      case 439: /* twindow_clause_opt ::= */ yytestcase(yyruleno==439);
      case 444: /* sliding_opt ::= */ yytestcase(yyruleno==444);
      case 446: /* fill_opt ::= */ yytestcase(yyruleno==446);
      case 458: /* having_clause_opt ::= */ yytestcase(yyruleno==458);
      case 460: /* range_opt ::= */ yytestcase(yyruleno==460);
      case 462: /* every_opt ::= */ yytestcase(yyruleno==462);
      case 472: /* slimit_clause_opt ::= */ yytestcase(yyruleno==472);
      case 476: /* limit_clause_opt ::= */ yytestcase(yyruleno==476);
{ yymsp[1].minor.yy616 = NULL; }
        break;
      case 227: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 228: /* table_name_cond ::= table_name */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy361); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 230: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy361); }
        break;
      case 231: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy151, &yymsp[-3].minor.yy361, &yymsp[-1].minor.yy361, NULL, yymsp[0].minor.yy616); }
        break;
      case 232: /* cmd ::= DROP INDEX exists_opt index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy151, &yymsp[0].minor.yy361); }
        break;
      case 233: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy616 = createIndexOption(pCxt, yymsp[-7].minor.yy356, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), NULL, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 234: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy616 = createIndexOption(pCxt, yymsp[-9].minor.yy356, releaseRawExprNode(pCxt, yymsp[-5].minor.yy616), releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 237: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy616 = createFunctionNode(pCxt, &yymsp[-3].minor.yy361, yymsp[-1].minor.yy356); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 238: /* sma_stream_opt ::= */
      case 268: /* stream_options ::= */ yytestcase(yyruleno==268);
{ yymsp[1].minor.yy616 = createStreamOptions(pCxt); }
        break;
      case 239: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 272: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==272);
{ ((SStreamOptions*)yymsp[-2].minor.yy616)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy616); yylhsminor.yy616 = yymsp[-2].minor.yy616; }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 240: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy616)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy616); yylhsminor.yy616 = yymsp[-2].minor.yy616; }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 241: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy151, &yymsp[-2].minor.yy361, yymsp[0].minor.yy616); }
        break;
      case 242: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy151, &yymsp[-3].minor.yy361, &yymsp[0].minor.yy361, false); }
        break;
      case 243: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy151, &yymsp[-5].minor.yy361, &yymsp[0].minor.yy361, true); }
        break;
      case 244: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy151, &yymsp[-3].minor.yy361, yymsp[0].minor.yy616, false); }
        break;
      case 245: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy151, &yymsp[-5].minor.yy361, yymsp[0].minor.yy616, true); }
        break;
      case 246: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy151, &yymsp[0].minor.yy361); }
        break;
      case 247: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy151, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy361); }
        break;
      case 248: /* cmd ::= DESC full_table_name */
      case 249: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==249);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy616); }
        break;
      case 250: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 251: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy151, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 253: /* analyze_opt ::= ANALYZE */
      case 261: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==261);
      case 426: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==426);
{ yymsp[0].minor.yy151 = true; }
        break;
      case 254: /* explain_options ::= */
{ yymsp[1].minor.yy616 = createDefaultExplainOptions(pCxt); }
        break;
      case 255: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy616 = setExplainVerbose(pCxt, yymsp[-2].minor.yy616, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 256: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy616 = setExplainRatio(pCxt, yymsp[-2].minor.yy616, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 257: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy356); }
        break;
      case 258: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy151, yymsp[-8].minor.yy151, &yymsp[-5].minor.yy361, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy600, yymsp[0].minor.yy734); }
        break;
      case 259: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy151, &yymsp[0].minor.yy361); }
        break;
      case 262: /* bufsize_opt ::= */
{ yymsp[1].minor.yy734 = 0; }
        break;
      case 263: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy734 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 264: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy151, &yymsp[-4].minor.yy361, yymsp[-2].minor.yy616, yymsp[-3].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 265: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy151, &yymsp[0].minor.yy361); }
        break;
      case 267: /* into_opt ::= INTO full_table_name */
      case 407: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==407);
      case 436: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==436);
      case 459: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==459);
{ yymsp[-1].minor.yy616 = yymsp[0].minor.yy616; }
        break;
      case 269: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy616)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy616 = yymsp[-2].minor.yy616; }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 270: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy616)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy616 = yymsp[-2].minor.yy616; }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 271: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy616)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy616)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy616); yylhsminor.yy616 = yymsp[-3].minor.yy616; }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 273: /* stream_options ::= stream_options IGNORE EXPIRED */
{ ((SStreamOptions*)yymsp[-2].minor.yy616)->ignoreExpired = true; yylhsminor.yy616 = yymsp[-2].minor.yy616; }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 274: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 275: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 276: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 277: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 278: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 279: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy356); }
        break;
      case 280: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 281: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy356 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 283: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy361); }
        break;
      case 284: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 286: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy616, yymsp[-2].minor.yy356, yymsp[0].minor.yy616); }
        break;
      case 287: /* cmd ::= INSERT INTO full_table_name query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy616, NULL, yymsp[0].minor.yy616); }
        break;
      case 288: /* literal ::= NK_INTEGER */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 289: /* literal ::= NK_FLOAT */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 290: /* literal ::= NK_STRING */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 291: /* literal ::= NK_BOOL */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 292: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 293: /* literal ::= duration_literal */
      case 303: /* signed_literal ::= signed */ yytestcase(yyruleno==303);
      case 324: /* expression ::= literal */ yytestcase(yyruleno==324);
      case 325: /* expression ::= pseudo_column */ yytestcase(yyruleno==325);
      case 326: /* expression ::= column_reference */ yytestcase(yyruleno==326);
      case 327: /* expression ::= function_expression */ yytestcase(yyruleno==327);
      case 328: /* expression ::= subquery */ yytestcase(yyruleno==328);
      case 356: /* function_expression ::= literal_func */ yytestcase(yyruleno==356);
      case 398: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==398);
      case 402: /* boolean_primary ::= predicate */ yytestcase(yyruleno==402);
      case 404: /* common_expression ::= expression */ yytestcase(yyruleno==404);
      case 405: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==405);
      case 408: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==408);
      case 410: /* table_reference ::= table_primary */ yytestcase(yyruleno==410);
      case 411: /* table_reference ::= joined_table */ yytestcase(yyruleno==411);
      case 415: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==415);
      case 465: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==465);
      case 468: /* query_primary ::= query_specification */ yytestcase(yyruleno==468);
{ yylhsminor.yy616 = yymsp[0].minor.yy616; }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 294: /* literal ::= NULL */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 295: /* literal ::= NK_QUESTION */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 296: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 297: /* signed ::= NK_INTEGER */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 298: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 299: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 300: /* signed ::= NK_FLOAT */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 301: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 302: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 304: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 305: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 306: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 307: /* signed_literal ::= duration_literal */
      case 309: /* signed_literal ::= literal_func */ yytestcase(yyruleno==309);
      case 376: /* star_func_para ::= expression */ yytestcase(yyruleno==376);
      case 431: /* select_item ::= common_expression */ yytestcase(yyruleno==431);
      case 481: /* search_condition ::= common_expression */ yytestcase(yyruleno==481);
{ yylhsminor.yy616 = releaseRawExprNode(pCxt, yymsp[0].minor.yy616); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 308: /* signed_literal ::= NULL */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 310: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy616 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 329: /* expression ::= NK_LP expression NK_RP */
      case 403: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==403);
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy616)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 330: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy616));
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 331: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy616), NULL));
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 332: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 333: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 334: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 335: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 336: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 337: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 338: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 339: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 342: /* column_reference ::= column_name */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy361, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy361)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 343: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy361, createColumnNode(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy361)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 344: /* pseudo_column ::= ROWTS */
      case 345: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==345);
      case 347: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==347);
      case 348: /* pseudo_column ::= QEND */ yytestcase(yyruleno==348);
      case 349: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==349);
      case 350: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==350);
      case 351: /* pseudo_column ::= WEND */ yytestcase(yyruleno==351);
      case 352: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==352);
      case 358: /* literal_func ::= NOW */ yytestcase(yyruleno==358);
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 346: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy361)))); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 353: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 354: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==354);
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy361, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy361, yymsp[-1].minor.yy356)); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 355: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), yymsp[-1].minor.yy600)); }
  yymsp[-5].minor.yy616 = yylhsminor.yy616;
        break;
      case 357: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy361, NULL)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 372: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy356 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 377: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 434: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==434);
{ yylhsminor.yy616 = createColumnNode(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 378: /* predicate ::= expression compare_op expression */
      case 383: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==383);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy526, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 379: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy616), releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 380: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy616), releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-5].minor.yy616 = yylhsminor.yy616;
        break;
      case 381: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), NULL));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 382: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), NULL));
                                                                                  }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 384: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy526 = OP_TYPE_LOWER_THAN; }
        break;
      case 385: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy526 = OP_TYPE_GREATER_THAN; }
        break;
      case 386: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy526 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 387: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy526 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 388: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy526 = OP_TYPE_NOT_EQUAL; }
        break;
      case 389: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy526 = OP_TYPE_EQUAL; }
        break;
      case 390: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy526 = OP_TYPE_LIKE; }
        break;
      case 391: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy526 = OP_TYPE_NOT_LIKE; }
        break;
      case 392: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy526 = OP_TYPE_MATCH; }
        break;
      case 393: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy526 = OP_TYPE_NMATCH; }
        break;
      case 394: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy526 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 395: /* in_op ::= IN */
{ yymsp[0].minor.yy526 = OP_TYPE_IN; }
        break;
      case 396: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy526 = OP_TYPE_NOT_IN; }
        break;
      case 397: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy356)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 399: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy616), NULL));
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 400: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 401: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 409: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy616 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy616, yymsp[0].minor.yy616, NULL); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 412: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy616 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy361, &yymsp[0].minor.yy361); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 413: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy616 = createRealTableNode(pCxt, &yymsp[-3].minor.yy361, &yymsp[-1].minor.yy361, &yymsp[0].minor.yy361); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 414: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy616 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy616), &yymsp[0].minor.yy361); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 416: /* alias_opt ::= */
{ yymsp[1].minor.yy361 = nil_token;  }
        break;
      case 417: /* alias_opt ::= table_alias */
{ yylhsminor.yy361 = yymsp[0].minor.yy361; }
  yymsp[0].minor.yy361 = yylhsminor.yy361;
        break;
      case 418: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy361 = yymsp[0].minor.yy361; }
        break;
      case 419: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 420: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==420);
{ yymsp[-2].minor.yy616 = yymsp[-1].minor.yy616; }
        break;
      case 421: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy616 = createJoinTableNode(pCxt, yymsp[-4].minor.yy504, yymsp[-5].minor.yy616, yymsp[-2].minor.yy616, yymsp[0].minor.yy616); }
  yymsp[-5].minor.yy616 = yylhsminor.yy616;
        break;
      case 422: /* join_type ::= */
{ yymsp[1].minor.yy504 = JOIN_TYPE_INNER; }
        break;
      case 423: /* join_type ::= INNER */
{ yymsp[0].minor.yy504 = JOIN_TYPE_INNER; }
        break;
      case 424: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy616 = createSelectStmt(pCxt, yymsp[-10].minor.yy151, yymsp[-9].minor.yy356, yymsp[-8].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addWhereClause(pCxt, yymsp[-11].minor.yy616, yymsp[-7].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addPartitionByClause(pCxt, yymsp[-11].minor.yy616, yymsp[-6].minor.yy356);
                                                                                    yymsp[-11].minor.yy616 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy616, yymsp[-2].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addGroupByClause(pCxt, yymsp[-11].minor.yy616, yymsp[-1].minor.yy356);
                                                                                    yymsp[-11].minor.yy616 = addHavingClause(pCxt, yymsp[-11].minor.yy616, yymsp[0].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addRangeClause(pCxt, yymsp[-11].minor.yy616, yymsp[-5].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addEveryClause(pCxt, yymsp[-11].minor.yy616, yymsp[-4].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addFillClause(pCxt, yymsp[-11].minor.yy616, yymsp[-3].minor.yy616);
                                                                                  }
        break;
      case 427: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy151 = false; }
        break;
      case 430: /* select_item ::= NK_STAR */
{ yylhsminor.yy616 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 432: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy616 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy616), &yymsp[0].minor.yy361); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 433: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy616 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), &yymsp[0].minor.yy361); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 438: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 455: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==455);
      case 471: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==471);
{ yymsp[-2].minor.yy356 = yymsp[0].minor.yy356; }
        break;
      case 440: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy616 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), releaseRawExprNode(pCxt, yymsp[-1].minor.yy616)); }
        break;
      case 441: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy616 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy616)); }
        break;
      case 442: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy616 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), NULL, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 443: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy616 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy616), releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 445: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 463: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==463);
{ yymsp[-3].minor.yy616 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy616); }
        break;
      case 447: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy616 = createFillNode(pCxt, yymsp[-1].minor.yy494, NULL); }
        break;
      case 448: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy616 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy356)); }
        break;
      case 449: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy494 = FILL_MODE_NONE; }
        break;
      case 450: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy494 = FILL_MODE_PREV; }
        break;
      case 451: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy494 = FILL_MODE_NULL; }
        break;
      case 452: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy494 = FILL_MODE_LINEAR; }
        break;
      case 453: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy494 = FILL_MODE_NEXT; }
        break;
      case 456: /* group_by_list ::= expression */
{ yylhsminor.yy356 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 457: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy356 = addNodeToList(pCxt, yymsp[-2].minor.yy356, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); }
  yymsp[-2].minor.yy356 = yylhsminor.yy356;
        break;
      case 461: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy616 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), releaseRawExprNode(pCxt, yymsp[-1].minor.yy616)); }
        break;
      case 464: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy616 = addOrderByClause(pCxt, yymsp[-3].minor.yy616, yymsp[-2].minor.yy356);
                                                                                    yylhsminor.yy616 = addSlimitClause(pCxt, yylhsminor.yy616, yymsp[-1].minor.yy616);
                                                                                    yylhsminor.yy616 = addLimitClause(pCxt, yylhsminor.yy616, yymsp[0].minor.yy616);
                                                                                  }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 466: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy616 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy616, yymsp[0].minor.yy616); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 467: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy616 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy616, yymsp[0].minor.yy616); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 469: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ 
                                                                                    yymsp[-5].minor.yy616 = addOrderByClause(pCxt, yymsp[-4].minor.yy616, yymsp[-3].minor.yy356);
                                                                                    yymsp[-5].minor.yy616 = addSlimitClause(pCxt, yymsp[-5].minor.yy616, yymsp[-2].minor.yy616);
                                                                                    yymsp[-5].minor.yy616 = addLimitClause(pCxt, yymsp[-5].minor.yy616, yymsp[-1].minor.yy616);
                                                                                  }
        break;
      case 473: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 477: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==477);
{ yymsp[-1].minor.yy616 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 474: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 478: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==478);
{ yymsp[-3].minor.yy616 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 475: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 479: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==479);
{ yymsp[-3].minor.yy616 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 480: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy616); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 484: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy616 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), yymsp[-1].minor.yy58, yymsp[0].minor.yy613); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 485: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy58 = ORDER_ASC; }
        break;
      case 486: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy58 = ORDER_ASC; }
        break;
      case 487: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy58 = ORDER_DESC; }
        break;
      case 488: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy613 = NULL_ORDER_DEFAULT; }
        break;
      case 489: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy613 = NULL_ORDER_FIRST; }
        break;
      case 490: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy613 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
