/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 472
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  int32_t yy20;
  EOrder yy34;
  bool yy89;
  int64_t yy93;
  SToken yy97;
  EJoinType yy116;
  ENullOrder yy265;
  SAlterOption yy285;
  EOperatorType yy396;
  int8_t yy519;
  SNodeList* yy520;
  STokenPair yy569;
  EFillMode yy646;
  SNode* yy792;
  SDataType yy848;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             753
#define YYNRULE              574
#define YYNTOKEN             328
#define YY_MAX_SHIFT         752
#define YY_MIN_SHIFTREDUCE   1121
#define YY_MAX_SHIFTREDUCE   1694
#define YY_ERROR_ACTION      1695
#define YY_ACCEPT_ACTION     1696
#define YY_NO_ACTION         1697
#define YY_MIN_REDUCE        1698
#define YY_MAX_REDUCE        2271
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2744)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  2083,  380,  393, 1982, 2247, 1909, 1911,  644, 1864,  165,
 /*    10 */   661, 1961,   46,   44, 1622,  379, 2069, 1866, 1979,  631,
 /*    20 */   388, 1498, 1471,   39,   38,  133, 2065,   45,   43,   42,
 /*    30 */    41,   40,  532, 1552,  123, 1469, 2101,  122,  121,  120,
 /*    40 */   119,  118,  117,  116,  115,  114,   36,  294, 2051, 1176,
 /*    50 */   660, 1175,  643,  427,  643,  192, 2083,  426, 1982, 1547,
 /*    60 */  2061, 2067,  369,  209,  226,   19,  661,  497, 2069, 1741,
 /*    70 */   167,  654, 1477, 1980,  631,  619,  140, 1809, 2065, 2082,
 /*    80 */   348, 1177,  168, 2118, 1710, 1855,  169, 2084,  664, 2086,
 /*    90 */  2087,  659, 2101,  654,  511, 2065, 1256,  749,  582,  211,
 /*   100 */    15, 2242, 1684,  497, 2051, 1741,  660,  619,  140, 1255,
 /*   110 */    46,   44, 2061, 2067,  370,  433, 2248,  184,  388,  499,
 /*   120 */  1471, 2243,  608,  654, 1581,  496,  583, 2208,   62, 2061,
 /*   130 */  2067, 1552,   49, 1469,   49, 2082, 1554, 1555, 2069, 2118,
 /*   140 */   654,   66,  110, 2084,  664, 2086, 2087,  659, 2065,  654,
 /*   150 */  1497, 1721,  143,  180,  150, 2142, 2171, 1547,  336, 1619,
 /*   160 */   382, 2167, 1176,   19, 1175, 1903, 1527, 1537, 1496,  275,
 /*   170 */  1477,  480, 1553, 1556,  273, 2179,  618, 1496,  134,  617,
 /*   180 */  1582, 2242, 2061, 2067,  383, 1720, 1472,  494, 1470, 1498,
 /*   190 */   495, 1734, 1961,  654, 1177,  749,  606,  184,   15, 2051,
 /*   200 */   502, 2243,  608,  495, 1734,  621,  182, 2179, 2180,  643,
 /*   210 */   138, 2184, 1475, 1476, 1698, 1526, 1529, 1530, 1531, 1532,
 /*   220 */  1533, 1534, 1535, 1536,  656,  652, 1545, 1546, 1548, 1549,
 /*   230 */  1550, 1551,    2, 2051, 1554, 1555,  194,   62,  132,  131,
 /*   240 */   130,  129,  128,  127,  126,  125,  124, 2019,   62, 1910,
 /*   250 */  1911,   35,  386, 1576, 1577, 1578, 1579, 1580, 1584, 1585,
 /*   260 */  1586, 1587,   32,  629, 1527, 1537, 1335, 1336,   39,   38,
 /*   270 */  1553, 1556,   45,   43,   42,   41,   40,  187, 1301,  602,
 /*   280 */  1696,  242,  177,  187, 1472,  241, 1470,   45,   43,   42,
 /*   290 */    41,   40,  244, 1292,  686,  685,  684, 1296,  683, 1298,
 /*   300 */  1299,  682,  679, 1966, 1307,  676, 1309, 1310,  673,  670,
 /*   310 */  1475, 1476, 1841, 1526, 1529, 1530, 1531, 1532, 1533, 1534,
 /*   320 */  1535, 1536,  656,  652, 1545, 1546, 1548, 1549, 1550, 1551,
 /*   330 */     2,   12,   46,   44, 1839,  227, 2070,  275,  644, 1864,
 /*   340 */   388, 1699, 1471,   90,  343, 2246, 2065,  365, 1154,  564,
 /*   350 */   401,  172, 1719, 1552,  400, 1469,  133,  528,  524,  520,
 /*   360 */   516,  224,  123,  537,  696,  122,  121,  120,  119,  118,
 /*   370 */   117,  116,  115,  114,   62,  548,  547,  546, 1245, 1547,
 /*   380 */  2061, 2067,  538,  137,  542,   19,  187, 1156,  541, 1159,
 /*   390 */  1160,  654, 1477,  540,  545,  582,   34,  187, 2242,  539,
 /*   400 */  2051,   88,   39,   38,  222, 1618,   45,   43,   42,   41,
 /*   410 */    40,  276, 2083, 2248,  184, 1247,  177,  749, 2243,  608,
 /*   420 */    15,   74,  661,  694,  155,  154,  691,  690,  689,  152,
 /*   430 */    46,   44, 1557, 1162,  107, 1496,  355, 1965,  388, 1495,
 /*   440 */  1471,  694,  155,  154,  691,  690,  689,  152, 2101,   50,
 /*   450 */   141, 1552,   62, 1469,   93, 1840, 1554, 1555, 1856,  425,
 /*   460 */  2051,  424,  660,  694,  155,  154,  691,  690,  689,  152,
 /*   470 */    82,  221,  215,  391, 2083,  630,  220, 1547,  507,  644,
 /*   480 */  1864,  162, 1718, 1717,  622,  423, 1527, 1537,  367, 1866,
 /*   490 */  1477, 2082, 1553, 1556,  213, 2118, 1914,  189,  111, 2084,
 /*   500 */   664, 2086, 2087,  659, 1495,  654, 1472,  646, 1470, 2143,
 /*   510 */  2101, 1716, 2171, 1916, 1916,  749, 2170, 2167,   47,  696,
 /*   520 */   353,  366, 2051,  187,  660,  509,  471, 1975, 1914, 1914,
 /*   530 */  2051, 2051, 1475, 1476, 1583, 1526, 1529, 1530, 1531, 1532,
 /*   540 */  1533, 1534, 1535, 1536,  656,  652, 1545, 1546, 1548, 1549,
 /*   550 */  1550, 1551,    2, 2082, 1554, 1555,  648, 2118, 2143, 2051,
 /*   560 */   110, 2084,  664, 2086, 2087,  659,   12,  654,  544,  543,
 /*   570 */   644, 1864,  181,  597, 2171, 1650,  619,  140,  382, 2167,
 /*   580 */   752, 1390, 1391,  106, 1527, 1537,  200,  199,   55,  607,
 /*   590 */  1553, 1556, 2242,  103,  301,  601,  644, 1864,  187, 2198,
 /*   600 */   571,  187,  243, 2186, 1472,   33, 1470,  606,  184,  470,
 /*   610 */   176,  610, 2243,  608,  431, 1588,  742,  738,  734,  730,
 /*   620 */   299, 2101,  594,  593, 1648, 1649, 1651, 1652, 1653, 2183,
 /*   630 */  1475, 1476, 1770, 1526, 1529, 1530, 1531, 1532, 1533, 1534,
 /*   640 */  1535, 1536,  656,  652, 1545, 1546, 1548, 1549, 1550, 1551,
 /*   650 */     2,   46,   44,   87, 2083, 1916,  603,  598,  591,  388,
 /*   660 */   108, 1471,  376,  292,  661,  619,  140, 1445, 1446,  357,
 /*   670 */  1914,  420, 1552,  600, 1469,  183, 2179, 2180, 1859,  138,
 /*   680 */  2184,   39,   38, 1496, 2186,   45,   43,   42,   41,   40,
 /*   690 */  2101,  644, 1864,  422,  418,  640,  644, 1864, 1547,  548,
 /*   700 */   547,  546, 2051, 2186,  660, 1477,  538,  137,  542,  432,
 /*   710 */  2182, 1477,  541,   12,  441,   10, 1961,  540,  545,  142,
 /*   720 */    39,   38, 2142,  539,   45,   43,   42,   41,   40, 2181,
 /*   730 */   279, 1916, 1499, 2082,  101,  278,  749, 2118,  381,   47,
 /*   740 */   170, 2084,  664, 2086, 2087,  659, 1914,  654, 1471,   46,
 /*   750 */    44, 1434, 2083,  247,  196,  391, 1715,  388, 1857, 1471,
 /*   760 */   198, 1469,  658,  165,  185, 2179, 2180, 1626,  138, 2184,
 /*   770 */  1552, 1866, 1469, 1496, 1661, 1554, 1555,  644, 1864,   39,
 /*   780 */    38,  644, 1864,   45,   43,   42,   41,   40, 2101,  687,
 /*   790 */  1497,  609, 2263,  165,   84,  456, 1547,   83, 1477,  457,
 /*   800 */  2051, 1867,  660, 1499, 2051, 1527, 1537,  688,  394, 1477,
 /*   810 */  1907, 1553, 1556,  562,   39,   38,  165, 1260,   45,   43,
 /*   820 */    42,   41,   40,  749, 1866, 1472,  560, 1470,  558, 1528,
 /*   830 */  1259, 2082,  644, 1864,  749, 2118,  630,   15,  330, 2084,
 /*   840 */   664, 2086, 2087,  659,  657,  654,  645, 2136,  611,  360,
 /*   850 */   510, 1475, 1476, 1714, 1526, 1529, 1530, 1531, 1532, 1533,
 /*   860 */  1534, 1535, 1536,  656,  652, 1545, 1546, 1548, 1549, 1550,
 /*   870 */  1551,    2, 1638, 1554, 1555,   87, 1853,   39,   38, 1916,
 /*   880 */   253,   45,   43,   42,   41,   40,  628,  709, 1975, 1826,
 /*   890 */    14,   13,  482,  339, 1915, 1494,  630,    9,  644, 1864,
 /*   900 */  1860, 2051,  464, 1527, 1537,  478, 1407, 1408,  477, 1553,
 /*   910 */  1556,  708, 1472,   28, 1470,  361, 1861,  359,  358, 1528,
 /*   920 */   534, 1744, 1713, 1472,  447, 1470,  479,   39,   38,  449,
 /*   930 */  1849,   45,   43,   42,   41,   40, 1499,  625, 1475, 1476,
 /*   940 */   251,  536, 1406, 1409, 2044,  535,  639, 1842, 1975, 1475,
 /*   950 */  1476,  193, 1526, 1529, 1530, 1531, 1532, 1533, 1534, 1535,
 /*   960 */  1536,  656,  652, 1545, 1546, 1548, 1549, 1550, 1551,    2,
 /*   970 */  2051,  744,   39,   38,  356, 1767,   45,   43,   42,   41,
 /*   980 */    40, 1562,  582,   91, 1691, 2242,  437, 1496, 1916,  582,
 /*   990 */  1595,  148, 2242,  644, 1864,  392,  644, 1864,  644, 1864,
 /*  1000 */  2248,  184,   52, 1914,    3, 2243,  608, 2248,  184, 2191,
 /*  1010 */  1615,  245, 2243,  608,  627,  475,  578, 1851,  469,  468,
 /*  1020 */   467,  466,  463,  462,  461,  460,  459,  455,  454,  453,
 /*  1030 */   452,  338,  444,  443,  442, 1847,  439,  438,  354,   42,
 /*  1040 */    41,   40,  726,  725,  724,  723,  398, 1946,  722,  721,
 /*  1050 */   144,  716,  715,  714,  713,  712,  711,  710,  157,  706,
 /*  1060 */   705,  704,  397,  396,  701,  700,  699,  698,  697,  166,
 /*  1070 */   553, 2083,  644, 1864,  314,  612,  644, 1864, 1712,  607,
 /*  1080 */  1690,  622, 2242, 1709,  252,  563,  644, 1864,  312,   73,
 /*  1090 */   295, 2083,   72, 1868,  623,  285,  286,  606,  184,  240,
 /*  1100 */   284,  661, 2243,  608,  289, 2247, 1615, 2101, 2242,  720,
 /*  1110 */   718,  207,  490,  488,  485,  556,  644, 1864, 1708, 2051,
 /*  1120 */   550,  660,  644, 1864, 2246,  239, 2051, 2101, 2243, 2245,
 /*  1130 */   434, 2051,  164, 1528,  641, 1159, 1160,  644, 1864, 2051,
 /*  1140 */   642,  660,  614,  435, 1707, 1706, 2045, 1705, 1480,  536,
 /*  1150 */  2082,   62, 1704,  535, 2118,  395,  569,  110, 2084,  664,
 /*  1160 */  2086, 2087,  659, 2037,  654,   70, 2051, 1479,   69,  181,
 /*  1170 */  2082, 2171,  577, 1703, 2118,  382, 2167,  169, 2084,  664,
 /*  1180 */  2086, 2087,  659,  692,  654, 1702, 1907, 2083,  186,  109,
 /*  1190 */  1701,  582, 2051, 2051, 2242, 2051, 2197,  661,  153, 1743,
 /*  1200 */  2051,  582,  451,  693, 2242,  308, 1907, 1810, 1893, 2248,
 /*  1210 */   184,  450,  408,  232, 2243,  608,  230,  581, 2209, 2248,
 /*  1220 */   184, 2051,  651, 2101, 2243,  608,  146, 1711,  135,   81,
 /*  1230 */    80,  430, 1757, 2051,  191, 2051, 2083,  660, 2051,  234,
 /*  1240 */   236,  153,  233,  235, 2247,  153,  661, 2242, 2205,  238,
 /*  1250 */    64,   64,  237,  337,  549,   54,  416, 1750,  414,  410,
 /*  1260 */   406,  403,  423, 2246,  257, 2072, 2082, 2243, 2244,  248,
 /*  1270 */  2118, 1748, 2101,  110, 2084,  664, 2086, 2087,  659,  551,
 /*  1280 */   654,  566,  153,  565, 2051, 2262,  660, 2171, 1693, 1694,
 /*  1290 */    48,  382, 2167,  554, 2083,  655,  282,   71, 1440,  151,
 /*  1300 */   187, 1483, 1443,  153,  661,  270, 2218, 1647, 1646,   14,
 /*  1310 */    13,   64, 1206,   48, 2211, 2082,  595,   48, 2074, 2118,
 /*  1320 */  1482,  259,  110, 2084,  664, 2086, 2087,  659,  225,  654,
 /*  1330 */  2101,  264,  668,  151, 2262,  702, 2171,   53,  153,  626,
 /*  1340 */   382, 2167, 2051,  703,  660, 2102,  136, 1404,  151, 1207,
 /*  1350 */   399, 1970, 2083,  287,  636, 1735,  291, 1225, 1740, 1904,
 /*  1360 */  1286, 2201,  661,  620,  589, 1223,  272,  269, 1589, 1573,
 /*  1370 */  1538,  615,    5, 2082,  307,    1,  407, 2118,  402,  352,
 /*  1380 */   110, 2084,  664, 2086, 2087,  659, 1427,  654, 2101, 1313,
 /*  1390 */  1317,  302, 2262,  197, 2171, 1324, 2083,  436,  382, 2167,
 /*  1400 */  2051, 1499,  660, 1322, 1971,  156,  661,  473, 2236,  440,
 /*  1410 */   445, 1494,  458, 1963,  465,  472,  474,  483,  202,  484,
 /*  1420 */   481,  201,  204,  486, 2083,  487,  489,  491, 1500,  492,
 /*  1430 */     4, 2082, 2101, 1502,  661, 2118, 2190,  493,  110, 2084,
 /*  1440 */   664, 2086, 2087,  659, 2051,  654,  660,  500,  385,  384,
 /*  1450 */  2262,  503, 2171,  501,  212, 1497,  382, 2167, 1485,  214,
 /*  1460 */  2101,  504, 1501, 1503,  505,  217,  508,  506,  219, 1552,
 /*  1470 */   512, 1478, 2051,   85,  660, 2082,   86,  223,  529, 2118,
 /*  1480 */  1179,  531,  110, 2084,  664, 2086, 2087,  659,  530,  654,
 /*  1490 */   533, 2028,  568, 1854, 2262, 1547, 2171,  342,  229,   89,
 /*  1500 */   382, 2167,  112, 2082, 1850,  231, 2083, 2118, 1477,  158,
 /*  1510 */   110, 2084,  664, 2086, 2087,  659,  661,  654,  159, 2025,
 /*  1520 */  1852, 2083, 2262, 1848, 2171,  160,  161,  570,  382, 2167,
 /*  1530 */   572,  661,  303,  650, 2024,  246,  579,  249, 2202, 2212,
 /*  1540 */   586,  149, 2101,  573,  596,    8,  576, 2217,  605,  592,
 /*  1550 */   634, 2216,  371,  599, 2051,  263,  660, 2101, 2193,  173,
 /*  1560 */   255,  258,  584,  587,  585,  372,  265, 2083,  267, 2051,
 /*  1570 */   616,  660,  268, 2265, 1615, 2241,  613,  661,  139, 1498,
 /*  1580 */   624,  375, 1504,  632, 1976, 2082,  637, 2187,  304, 2118,
 /*  1590 */   277, 2083,  324, 2084,  664, 2086, 2087,  659,  633,  654,
 /*  1600 */  2082,  661,   96, 2101, 2118,  271, 1990,  110, 2084,  664,
 /*  1610 */  2086, 2087,  659, 1989,  654, 2051,  305,  660,  266, 2146,
 /*  1620 */  1988, 2171, 1486, 2083, 1481,  382, 2167, 2101,  378,   98,
 /*  1630 */   100,  306,   61,  661,  638,  604,  102, 1865, 1827, 2051,
 /*  1640 */  1908,  660, 2152,  666,  745,  309, 2082,  298, 1489, 1491,
 /*  1650 */  2118,  746,   51,  170, 2084,  664, 2086, 2087,  659, 2101,
 /*  1660 */   654,  652, 1545, 1546, 1548, 1549, 1550, 1551,  748,  333,
 /*  1670 */  2082, 2051,  318,  660, 2118,  344,  332,  110, 2084,  664,
 /*  1680 */  2086, 2087,  659,  311,  654,  313,  322, 2043, 2042, 2144,
 /*  1690 */  2041, 2171, 2038,   78, 2083,  382, 2167,  404,  345,  405,
 /*  1700 */  1462, 1463, 2082,  190,  661, 2264, 2118,  409, 2036,  110,
 /*  1710 */  2084,  664, 2086, 2087,  659,  411,  654,  412,  413, 2035,
 /*  1720 */   415,  647, 2034, 2171, 2083,  419,  417,  382, 2167, 2033,
 /*  1730 */  2101, 2032,  421,   79,  661, 1430, 1429, 2002, 2001, 2000,
 /*  1740 */   428,  429, 2051, 1999,  660, 1998, 1381, 1954, 1953, 1951,
 /*  1750 */  1950,  145, 1949, 1952, 1948, 1947, 2083, 1945, 1944, 1943,
 /*  1760 */  2101,  195,  446, 1942,  448, 1956,  661, 1941, 1940, 1939,
 /*  1770 */  1938, 1937, 2051, 2082,  660, 1936, 1935, 2118, 1934, 1933,
 /*  1780 */   111, 2084,  664, 2086, 2087,  659, 1932,  654, 1931, 1930,
 /*  1790 */  2083, 1929, 2101, 1928, 2171, 1927, 1926, 1925,  649, 2167,
 /*  1800 */   661, 1924,  147,  662, 2051, 1955,  660, 2118, 1923, 1922,
 /*  1810 */   111, 2084,  664, 2086, 2087,  659, 1383,  654, 1921, 1920,
 /*  1820 */  1919, 1918,  476, 1917, 2171, 1257, 2101, 1773,  347, 2167,
 /*  1830 */   340,  377, 1261,  341, 1253, 2082,  203, 1772, 2051, 2118,
 /*  1840 */   660, 1771,  111, 2084,  664, 2086, 2087,  659, 2083,  654,
 /*  1850 */  1769,  205, 1730,  208,   76, 1729, 2171,  206,  658, 2071,
 /*  1860 */   178, 2168, 1161, 2015,  179, 2083,  210,   77, 2009, 2082,
 /*  1870 */  1997,  498,  216, 2118, 1996,  661,  331, 2084,  664, 2086,
 /*  1880 */  2087,  659,  218,  654, 2101, 1974, 1843, 1768, 1199, 1766,
 /*  1890 */   515,  513,  514, 1764,  517,  518, 2051,  519,  660, 1762,
 /*  1900 */   521, 2101,  522,  523, 1760,  527,  387,  525, 1747, 2083,
 /*  1910 */   526, 1746, 1726, 2051, 1845,  660,   63, 1329, 1328,  661,
 /*  1920 */   228, 1844,  717, 1244,  719, 1243, 1242, 2082, 1235, 1241,
 /*  1930 */  1240, 2118, 2083, 1237,  330, 2084,  664, 2086, 2087,  659,
 /*  1940 */  1236,  654,  661, 2137, 2082, 2101, 1758, 1751, 2118,  362,
 /*  1950 */   389,  331, 2084,  664, 2086, 2087,  659, 2051,  654,  660,
 /*  1960 */  1234,  363, 1749,  364,  552,  555, 1725,  557, 2101, 1724,
 /*  1970 */   559, 1723,  561, 1450,  113, 1452, 1454, 1449, 2014, 1436,
 /*  1980 */  2051, 2083,  660,   27,   67, 2008,  574, 1995, 2082,  163,
 /*  1990 */  1993,  661, 2118,   56, 2083,  331, 2084,  664, 2086, 2087,
 /*  2000 */   659,  250,  654,  575,  661, 2247,  368,  580, 1663,   20,
 /*  2010 */    29,  567,   59,  588,   17, 2118,  254, 2101,  326, 2084,
 /*  2020 */   664, 2086, 2087,  659,    6,  654,   60,    7,  171, 2051,
 /*  2030 */  2101,  660,  590,  261,  256, 1645,   21,   31,  262, 2072,
 /*  2040 */    65, 1678, 2051, 2083,  660,  260, 1677,   22,   30,  373,
 /*  2050 */  1637,   92, 1682,  661, 1681,   18, 2083, 1683, 1684,  374,
 /*  2060 */  2082, 1612, 1611,  274, 2118,   58,  661,  315, 2084,  664,
 /*  2070 */  2086, 2087,  659, 2082,  654,  174,   57, 2118, 1994, 2101,
 /*  2080 */   316, 2084,  664, 2086, 2087,  659, 1992,  654, 1991, 1973,
 /*  2090 */    95, 2051, 2101,  660,   94,  280,   23,  635, 1972,  281,
 /*  2100 */  1643,  283,   97,  293, 2051, 2083,  660,  288,   68,   99,
 /*  2110 */   103,   24,  290, 1564,   13,  661, 1563, 1487,  175,  188,
 /*  2120 */  2121, 1574, 2082, 1542, 1540,  653, 2118,   37, 1519,  317,
 /*  2130 */  2084,  664, 2086, 2087,  659, 2082,  654,   11,   16, 2118,
 /*  2140 */  1539, 2101,  323, 2084,  664, 2086, 2087,  659, 1511,  654,
 /*  2150 */    25,  665,   26, 2051, 1314,  660,  667,  390,  669,  671,
 /*  2160 */  1311, 2083,  672,  674,  677, 1308,  663, 1302,  675,  678,
 /*  2170 */   680,  661, 1323, 1319, 1300,  681, 2083, 1306,  296, 1305,
 /*  2180 */   104, 1197, 1304, 1303, 2082,  105,  661,   75, 2118, 1231,
 /*  2190 */   695,  327, 2084,  664, 2086, 2087,  659, 2101,  654, 1230,
 /*  2200 */  1229, 1228, 1227, 1226, 1224, 1222, 1221, 1220, 1251, 2051,
 /*  2210 */  2083,  660, 2101,  707, 1218, 1217, 1216,  297, 1215, 1214,
 /*  2220 */   661, 1213, 1212, 1246, 2051, 1248,  660, 1209, 1208, 1205,
 /*  2230 */  1204, 1203, 1202, 1765,  727, 1763,  731,  729, 1761,  728,
 /*  2240 */  2082,  733,  735, 1759, 2118,  737, 2101,  319, 2084,  664,
 /*  2250 */  2086, 2087,  659,  732,  654, 2082,  739,  736, 2051, 2118,
 /*  2260 */   660,  740,  328, 2084,  664, 2086, 2087,  659, 2083,  654,
 /*  2270 */   741, 1745,  743, 1722, 1151,  300,  747,  750,  661, 1473,
 /*  2280 */   310,  751, 1697, 1697, 2083, 1697, 1697, 1697, 1697, 2082,
 /*  2290 */  1697, 1697, 1697, 2118,  661, 1697,  320, 2084,  664, 2086,
 /*  2300 */  2087,  659, 1697,  654, 2101, 1697, 1697, 1697, 1697, 1697,
 /*  2310 */  1697, 1697, 2083, 1697, 1697, 1697, 2051, 1697,  660, 1697,
 /*  2320 */  2101, 1697,  661, 1697, 1697, 1697, 1697, 1697, 2083, 1697,
 /*  2330 */  1697, 1697, 2051, 1697,  660, 1697, 1697, 1697,  661, 1697,
 /*  2340 */  1697, 1697, 1697, 1697, 1697, 1697, 1697, 2082, 2101, 1697,
 /*  2350 */  1697, 2118, 1697, 1697,  329, 2084,  664, 2086, 2087,  659,
 /*  2360 */  2051,  654,  660, 2082, 2101, 1697, 1697, 2118, 1697, 1697,
 /*  2370 */   321, 2084,  664, 2086, 2087,  659, 2051,  654,  660, 1697,
 /*  2380 */  1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697,
 /*  2390 */  1697, 2082, 1697, 1697, 1697, 2118, 2083, 1697,  334, 2084,
 /*  2400 */   664, 2086, 2087,  659, 1697,  654,  661, 2082, 1697, 1697,
 /*  2410 */  1697, 2118, 2083, 1697,  335, 2084,  664, 2086, 2087,  659,
 /*  2420 */  1697,  654,  661, 1697, 1697, 1697, 1697, 1697, 1697, 1697,
 /*  2430 */  1697, 1697, 2101, 1697, 1697, 1697, 1697, 1697, 1697, 1697,
 /*  2440 */  1697, 1697, 1697, 1697, 2051, 1697,  660, 1697, 2101, 1697,
 /*  2450 */  1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 2083, 1697,
 /*  2460 */  2051, 1697,  660, 1697, 1697, 1697, 1697, 1697,  661, 1697,
 /*  2470 */  1697, 2083, 1697, 1697, 1697, 2082, 1697, 1697, 1697, 2118,
 /*  2480 */  1697,  661, 2095, 2084,  664, 2086, 2087,  659, 1697,  654,
 /*  2490 */  1697, 2082, 1697, 1697, 2101, 2118, 1697, 1697, 2094, 2084,
 /*  2500 */   664, 2086, 2087,  659, 1697,  654, 2051, 2101,  660, 1697,
 /*  2510 */  1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 2051,
 /*  2520 */  2083,  660, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697,
 /*  2530 */   661, 1697, 1697, 1697, 1697, 1697, 1697, 2082, 1697, 1697,
 /*  2540 */  1697, 2118, 2083, 1697, 2093, 2084,  664, 2086, 2087,  659,
 /*  2550 */  2082,  654,  661, 1697, 2118, 1697, 2101,  349, 2084,  664,
 /*  2560 */  2086, 2087,  659, 1697,  654, 1697, 1697, 1697, 2051, 1697,
 /*  2570 */   660, 1697, 1697, 1697, 1697, 1697, 2083, 1697, 2101, 1697,
 /*  2580 */  1697, 1697, 1697, 1697, 1697, 1697,  661, 1697, 1697, 1697,
 /*  2590 */  2051, 2083,  660, 1697, 1697, 1697, 1697, 1697, 1697, 2082,
 /*  2600 */  1697,  661, 1697, 2118, 1697, 1697,  350, 2084,  664, 2086,
 /*  2610 */  2087,  659, 2101,  654, 1697, 1697, 1697, 1697, 1697, 1697,
 /*  2620 */  1697, 2082, 1697, 1697, 2051, 2118,  660, 2101,  346, 2084,
 /*  2630 */   664, 2086, 2087,  659, 1697,  654, 1697, 1697, 1697, 2051,
 /*  2640 */  1697,  660, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697,
 /*  2650 */  2083, 1697, 1697, 1697, 1697, 2082, 1697, 1697, 1697, 2118,
 /*  2660 */   661, 1697,  351, 2084,  664, 2086, 2087,  659, 1697,  654,
 /*  2670 */   662, 1697, 1697, 1697, 2118, 1697, 1697,  326, 2084,  664,
 /*  2680 */  2086, 2087,  659, 1697,  654, 1697, 2101, 1697, 1697, 1697,
 /*  2690 */  1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 2051, 1697,
 /*  2700 */   660, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697,
 /*  2710 */  1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697,
 /*  2720 */  1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 2082,
 /*  2730 */  1697, 1697, 1697, 2118, 1697, 1697,  325, 2084,  664, 2086,
 /*  2740 */  2087,  659, 1697,  654,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   331,  359,  377,  381,    3,  380,  381,  340,  341,  367,
 /*    10 */   341,  341,   12,   13,   14,  393,  369,  375,  396,  397,
 /*    20 */    20,   20,   22,    8,    9,  358,  379,   12,   13,   14,
 /*    30 */    15,   16,  365,   33,   21,   35,  367,   24,   25,   26,
 /*    40 */    27,   28,   29,   30,   31,   32,  432,  433,  379,   20,
 /*    50 */   381,   22,   20,  398,   20,  385,  331,  402,  381,   59,
 /*    60 */   413,  414,  415,  336,   35,   65,  341,  340,  369,  342,
 /*    70 */   349,  424,   72,  396,  397,  340,  341,  356,  379,  410,
 /*    80 */    65,   52,  330,  414,  332,  369,  417,  418,  419,  420,
 /*    90 */   421,  422,  367,  424,   64,  379,   22,   97,  443,  336,
 /*   100 */   100,  446,  101,  340,  379,  342,  381,  340,  341,   35,
 /*   110 */    12,   13,  413,  414,  415,  340,  461,  462,   20,   14,
 /*   120 */    22,  466,  467,  424,  109,   20,  457,  458,  100,  413,
 /*   130 */   414,   33,  100,   35,  100,  410,  136,  137,  369,  414,
 /*   140 */   424,    4,  417,  418,  419,  420,  421,  422,  379,  424,
 /*   150 */    20,  331,  427,  366,  429,  430,  431,   59,  383,    4,
 /*   160 */   435,  436,   20,   65,   22,  378,  166,  167,   20,  168,
 /*   170 */    72,   97,  172,  173,  439,  440,  441,   20,  443,  444,
 /*   180 */   165,  446,  413,  414,  415,  331,  186,  335,  188,   20,
 /*   190 */   338,  339,  341,  424,   52,   97,  461,  462,  100,  379,
 /*   200 */   335,  466,  467,  338,  339,  438,  439,  440,  441,   20,
 /*   210 */   443,  444,  212,  213,    0,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,  379,  136,  137,  385,  100,   24,   25,
 /*   240 */    26,   27,   28,   29,   30,   31,   32,  363,  100,  380,
 /*   250 */   381,  236,  237,  238,  239,  240,  241,  242,  243,  244,
 /*   260 */   245,  246,    2,   20,  166,  167,  136,  137,    8,    9,
 /*   270 */   172,  173,   12,   13,   14,   15,   16,  249,   97,   20,
 /*   280 */   328,  131,  367,  249,  186,  135,  188,   12,   13,   14,
 /*   290 */    15,   16,  408,  112,  113,  114,  115,  116,  117,  118,
 /*   300 */   119,  120,  121,  388,  123,  124,  125,  126,  127,  128,
 /*   310 */   212,  213,    0,  215,  216,  217,  218,  219,  220,  221,
 /*   320 */   222,  223,  224,  225,  226,  227,  228,  229,  230,  231,
 /*   330 */   232,  233,   12,   13,    0,   33,  369,  168,  340,  341,
 /*   340 */    20,    0,   22,  193,  194,    3,  379,  197,    4,  199,
 /*   350 */   398,   49,  331,   33,  402,   35,  358,   55,   56,   57,
 /*   360 */    58,   59,   21,  365,   64,   24,   25,   26,   27,   28,
 /*   370 */    29,   30,   31,   32,  100,   67,   68,   69,   35,   59,
 /*   380 */   413,  414,   74,   75,   76,   65,  249,   43,   80,   45,
 /*   390 */    46,  424,   72,   85,   86,  443,    2,  249,  446,   91,
 /*   400 */   379,   99,    8,    9,  102,  250,   12,   13,   14,   15,
 /*   410 */    16,   59,  331,  461,  462,   72,  367,   97,  466,  467,
 /*   420 */   100,  111,  341,  129,  130,  131,  132,  133,  134,  135,
 /*   430 */    12,   13,   14,   14,  346,   20,  387,  388,   20,   20,
 /*   440 */    22,  129,  130,  131,  132,  133,  134,  135,  367,  100,
 /*   450 */   362,   33,  100,   35,  102,    0,  136,  137,  370,  185,
 /*   460 */   379,  187,  381,  129,  130,  131,  132,  133,  134,  135,
 /*   470 */   160,  169,  170,  359,  331,  340,  174,   59,  176,  340,
 /*   480 */   341,  367,  331,  331,  341,  211,  166,  167,  374,  375,
 /*   490 */    72,  410,  172,  173,  192,  414,  382,  358,  417,  418,
 /*   500 */   419,  420,  421,  422,   20,  424,  186,  428,  188,  430,
 /*   510 */   367,  331,  431,  367,  367,   97,  435,  436,  100,   64,
 /*   520 */   374,  374,  379,  249,  381,  390,   81,  392,  382,  382,
 /*   530 */   379,  379,  212,  213,  165,  215,  216,  217,  218,  219,
 /*   540 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   550 */   230,  231,  232,  410,  136,  137,  428,  414,  430,  379,
 /*   560 */   417,  418,  419,  420,  421,  422,  233,  424,  353,  354,
 /*   570 */   340,  341,  429,  171,  431,  212,  340,  341,  435,  436,
 /*   580 */    19,  166,  167,  100,  166,  167,  141,  142,  358,  443,
 /*   590 */   172,  173,  446,  110,   33,  341,  340,  341,  249,  456,
 /*   600 */   111,  249,  130,  416,  186,  236,  188,  461,  462,  164,
 /*   610 */    49,  269,  466,  467,  358,  246,   55,   56,   57,   58,
 /*   620 */    59,  367,  259,  260,  261,  262,  263,  264,  265,  442,
 /*   630 */   212,  213,    0,  215,  216,  217,  218,  219,  220,  221,
 /*   640 */   222,  223,  224,  225,  226,  227,  228,  229,  230,  231,
 /*   650 */   232,   12,   13,  348,  331,  367,  254,  255,  256,   20,
 /*   660 */    99,   22,  374,  102,  341,  340,  341,  195,  196,  364,
 /*   670 */   382,  181,   33,  419,   35,  439,  440,  441,  373,  443,
 /*   680 */   444,    8,    9,   20,  416,   12,   13,   14,   15,   16,
 /*   690 */   367,  340,  341,  203,  204,  134,  340,  341,   59,   67,
 /*   700 */    68,   69,  379,  416,  381,   72,   74,   75,   76,  358,
 /*   710 */   442,   72,   80,  233,  358,  235,  341,   85,   86,  427,
 /*   720 */     8,    9,  430,   91,   12,   13,   14,   15,   16,  442,
 /*   730 */   169,  367,   20,  410,  346,  174,   97,  414,  374,  100,
 /*   740 */   417,  418,  419,  420,  421,  422,  382,  424,   22,   12,
 /*   750 */    13,  190,  331,  192,   59,  359,  331,   20,  370,   22,
 /*   760 */   385,   35,  341,  367,  439,  440,  441,   14,  443,  444,
 /*   770 */    33,  375,   35,   20,  101,  136,  137,  340,  341,    8,
 /*   780 */     9,  340,  341,   12,   13,   14,   15,   16,  367,  111,
 /*   790 */    20,  468,  469,  367,   99,  358,   59,  102,   72,  358,
 /*   800 */   379,  375,  381,   20,  379,  166,  167,  376,  359,   72,
 /*   810 */   379,  172,  173,   21,    8,    9,  367,   22,   12,   13,
 /*   820 */    14,   15,   16,   97,  375,  186,   34,  188,   36,  166,
 /*   830 */    35,  410,  340,  341,   97,  414,  340,  100,  417,  418,
 /*   840 */   419,  420,  421,  422,  423,  424,  425,  426,   44,   37,
 /*   850 */   358,  212,  213,  331,  215,  216,  217,  218,  219,  220,
 /*   860 */   221,  222,  223,  224,  225,  226,  227,  228,  229,  230,
 /*   870 */   231,  232,  101,  136,  137,  348,  368,    8,    9,  367,
 /*   880 */   168,   12,   13,   14,   15,   16,  390,  355,  392,  357,
 /*   890 */     1,    2,   97,   18,  382,   20,  340,   39,  340,  341,
 /*   900 */   373,  379,   27,  166,  167,   30,  136,  137,   33,  172,
 /*   910 */   173,   72,  186,   44,  188,  103,  358,  105,  106,  166,
 /*   920 */   108,    0,  331,  186,   49,  188,   51,    8,    9,   54,
 /*   930 */   368,   12,   13,   14,   15,   16,   20,  398,  212,  213,
 /*   940 */    59,  129,  172,  173,  398,  133,  390,    0,  392,  212,
 /*   950 */   213,  168,  215,  216,  217,  218,  219,  220,  221,  222,
 /*   960 */   223,  224,  225,  226,  227,  228,  229,  230,  231,  232,
 /*   970 */   379,   50,    8,    9,   99,    0,   12,   13,   14,   15,
 /*   980 */    16,   14,  443,  102,  178,  446,  111,   20,  367,  443,
 /*   990 */   101,   44,  446,  340,  341,  374,  340,  341,  340,  341,
 /*  1000 */   461,  462,   42,  382,   44,  466,  467,  461,  462,  247,
 /*  1010 */   248,  358,  466,  467,  358,  140,  358,  368,  143,  144,
 /*  1020 */   145,  146,  147,  148,  149,  150,  151,  152,  153,  154,
 /*  1030 */   155,  156,  157,  158,  159,  368,  161,  162,  163,   14,
 /*  1040 */    15,   16,   67,   68,   69,   70,   71,    0,   73,   74,
 /*  1050 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*  1060 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   18,
 /*  1070 */     4,  331,  340,  341,   23,  271,  340,  341,  331,  443,
 /*  1080 */   274,  341,  446,  331,  168,   19,  340,  341,   37,   38,
 /*  1090 */   358,  331,   41,  368,  358,  130,  131,  461,  462,   33,
 /*  1100 */   135,  341,  466,  467,  358,  443,  248,  367,  446,  353,
 /*  1110 */   354,   60,   61,   62,   63,   49,  340,  341,  331,  379,
 /*  1120 */    54,  381,  340,  341,  462,   59,  379,  367,  466,  467,
 /*  1130 */    22,  379,  168,  166,  358,   45,   46,  340,  341,  379,
 /*  1140 */   358,  381,   44,   35,  331,  331,  398,  331,   35,  129,
 /*  1150 */   410,  100,  331,  133,  414,  358,  398,  417,  418,  419,
 /*  1160 */   420,  421,  422,    0,  424,   99,  379,   35,  102,  429,
 /*  1170 */   410,  431,  403,  331,  414,  435,  436,  417,  418,  419,
 /*  1180 */   420,  421,  422,  376,  424,  331,  379,  331,  448,  138,
 /*  1190 */   331,  443,  379,  379,  446,  379,  456,  341,   44,  343,
 /*  1200 */   379,  443,  155,  376,  446,  360,  379,  356,  363,  461,
 /*  1210 */   462,  164,   49,  104,  466,  467,  107,   48,  458,  461,
 /*  1220 */   462,  379,   65,  367,  466,  467,   42,  332,   44,  178,
 /*  1230 */   179,  180,    0,  379,  183,  379,  331,  381,  379,  104,
 /*  1240 */   104,   44,  107,  107,  443,   44,  341,  446,  343,  104,
 /*  1250 */    44,   44,  107,  202,   22,  101,  205,    0,  207,  208,
 /*  1260 */   209,  210,  211,  462,   44,   47,  410,  466,  467,  368,
 /*  1270 */   414,    0,  367,  417,  418,  419,  420,  421,  422,   22,
 /*  1280 */   424,  198,   44,  200,  379,  429,  381,  431,  136,  137,
 /*  1290 */    44,  435,  436,   22,  331,  368,   44,   44,  101,   44,
 /*  1300 */   249,  188,  101,   44,  341,  470,  343,  101,  101,    1,
 /*  1310 */     2,   44,   35,   44,  389,  410,  459,   44,  100,  414,
 /*  1320 */   188,  101,  417,  418,  419,  420,  421,  422,  344,  424,
 /*  1330 */   367,  453,   44,   44,  429,   13,  431,  168,   44,  101,
 /*  1340 */   435,  436,  379,   13,  381,  367,   44,  101,   44,   72,
 /*  1350 */   344,  389,  331,  101,  101,  339,  101,   35,  341,  378,
 /*  1360 */   101,  389,  341,  445,  343,   35,  463,  437,  101,  212,
 /*  1370 */   101,  273,  251,  410,  101,  447,   49,  414,  412,  411,
 /*  1380 */   417,  418,  419,  420,  421,  422,  184,  424,  367,  101,
 /*  1390 */   101,  400,  429,   42,  431,  101,  331,  386,  435,  436,
 /*  1400 */   379,   20,  381,  101,  389,  101,  341,  165,  343,  386,
 /*  1410 */   384,   20,  340,  340,  386,  384,  384,   98,  340,  352,
 /*  1420 */    96,  351,  340,   95,  331,  350,  340,  340,   20,  333,
 /*  1430 */    48,  410,  367,   20,  341,  414,  343,  337,  417,  418,
 /*  1440 */   419,  420,  421,  422,  379,  424,  381,  333,   12,   13,
 /*  1450 */   429,  405,  431,  337,  348,   20,  435,  436,   22,  348,
 /*  1460 */   367,  381,   20,   20,  342,  348,  342,  399,  348,   33,
 /*  1470 */   340,   35,  379,  348,  381,  410,  348,  348,  345,  414,
 /*  1480 */    53,  333,  417,  418,  419,  420,  421,  422,  345,  424,
 /*  1490 */   367,  379,  201,  367,  429,   59,  431,  333,  367,  100,
 /*  1500 */   435,  436,  340,  410,  367,  367,  331,  414,   72,  367,
 /*  1510 */   417,  418,  419,  420,  421,  422,  341,  424,  367,  379,
 /*  1520 */   367,  331,  429,  367,  431,  367,  367,  409,  435,  436,
 /*  1530 */   191,  341,  405,   97,  379,  346,  340,  346,  389,  389,
 /*  1540 */   379,  407,  367,  404,  258,  266,  381,  452,  177,  379,
 /*  1550 */   257,  452,  379,  379,  379,  454,  381,  367,  455,  452,
 /*  1560 */   394,  394,  252,  268,  267,  275,  451,  331,  449,  379,
 /*  1570 */   272,  381,  412,  471,  248,  465,  270,  341,  341,   20,
 /*  1580 */   340,  342,   20,  379,  392,  410,  170,  416,  394,  414,
 /*  1590 */   346,  331,  417,  418,  419,  420,  421,  422,  379,  424,
 /*  1600 */   410,  341,  346,  367,  414,  464,  379,  417,  418,  419,
 /*  1610 */   420,  421,  422,  379,  424,  379,  394,  381,  450,  429,
 /*  1620 */   379,  431,  186,  331,  188,  435,  436,  367,  379,  346,
 /*  1630 */   346,  363,  100,  341,  391,  460,  100,  341,  357,  379,
 /*  1640 */   379,  381,  434,  371,   36,  340,  410,  346,  212,  213,
 /*  1650 */   414,  334,  401,  417,  418,  419,  420,  421,  422,  367,
 /*  1660 */   424,  225,  226,  227,  228,  229,  230,  231,  333,  406,
 /*  1670 */   410,  379,  361,  381,  414,  395,  361,  417,  418,  419,
 /*  1680 */   420,  421,  422,  347,  424,  329,  361,    0,    0,  429,
 /*  1690 */     0,  431,    0,   42,  331,  435,  436,   35,  395,  206,
 /*  1700 */    35,   35,  410,   35,  341,  469,  414,  206,    0,  417,
 /*  1710 */   418,  419,  420,  421,  422,   35,  424,   35,  206,    0,
 /*  1720 */   206,  429,    0,  431,  331,   22,   35,  435,  436,    0,
 /*  1730 */   367,    0,   35,  193,  341,  188,  186,    0,    0,    0,
 /*  1740 */   182,  181,  379,    0,  381,    0,   47,    0,    0,    0,
 /*  1750 */     0,   42,    0,    0,    0,    0,  331,    0,    0,    0,
 /*  1760 */   367,  155,   35,    0,  155,    0,  341,    0,    0,    0,
 /*  1770 */     0,    0,  379,  410,  381,    0,    0,  414,    0,    0,
 /*  1780 */   417,  418,  419,  420,  421,  422,    0,  424,    0,    0,
 /*  1790 */   331,    0,  367,    0,  431,    0,    0,    0,  435,  436,
 /*  1800 */   341,    0,   42,  410,  379,    0,  381,  414,    0,    0,
 /*  1810 */   417,  418,  419,  420,  421,  422,   22,  424,    0,    0,
 /*  1820 */     0,    0,  139,    0,  431,   22,  367,    0,  435,  436,
 /*  1830 */    48,  372,   22,   48,   35,  410,   59,    0,  379,  414,
 /*  1840 */   381,    0,  417,  418,  419,  420,  421,  422,  331,  424,
 /*  1850 */     0,   59,    0,   42,   39,    0,  431,   59,  341,   47,
 /*  1860 */    44,  436,   14,    0,   47,  331,   40,   39,    0,  410,
 /*  1870 */     0,   47,   39,  414,    0,  341,  417,  418,  419,  420,
 /*  1880 */   421,  422,  177,  424,  367,    0,    0,    0,   66,    0,
 /*  1890 */    39,   35,   49,    0,   35,   49,  379,   39,  381,    0,
 /*  1900 */    35,  367,   49,   39,    0,   39,  372,   35,    0,  331,
 /*  1910 */    49,    0,    0,  379,    0,  381,  109,   35,   22,  341,
 /*  1920 */   107,    0,   44,   35,   44,   35,   35,  410,   22,   35,
 /*  1930 */    35,  414,  331,   35,  417,  418,  419,  420,  421,  422,
 /*  1940 */    35,  424,  341,  426,  410,  367,    0,    0,  414,   22,
 /*  1950 */   372,  417,  418,  419,  420,  421,  422,  379,  424,  381,
 /*  1960 */    35,   22,    0,   22,   51,   35,    0,   35,  367,    0,
 /*  1970 */    35,    0,   22,   35,   20,   35,  101,   35,    0,   35,
 /*  1980 */   379,  331,  381,  100,  100,    0,   22,    0,  410,  189,
 /*  1990 */     0,  341,  414,  168,  331,  417,  418,  419,  420,  421,
 /*  2000 */   422,  170,  424,  168,  341,    3,  168,  175,  101,   44,
 /*  2010 */   100,  410,   44,   98,  253,  414,  100,  367,  417,  418,
 /*  2020 */   419,  420,  421,  422,   48,  424,   44,   48,  100,  379,
 /*  2030 */   367,  381,   96,   44,  101,  101,  253,   44,   47,   47,
 /*  2040 */     3,   35,  379,  331,  381,  100,   35,   44,  100,   35,
 /*  2050 */   101,  100,   35,  341,   35,  253,  331,  101,  101,   35,
 /*  2060 */   410,  101,  101,   47,  414,   44,  341,  417,  418,  419,
 /*  2070 */   420,  421,  422,  410,  424,   47,  247,  414,    0,  367,
 /*  2080 */   417,  418,  419,  420,  421,  422,    0,  424,    0,    0,
 /*  2090 */    39,  379,  367,  381,  100,   47,  100,  171,    0,  101,
 /*  2100 */   101,  100,   39,   47,  379,  331,  381,  100,  100,  100,
 /*  2110 */   110,   44,  169,   98,    2,  341,   98,   22,   47,   47,
 /*  2120 */   100,  212,  410,  101,  101,  100,  414,  100,   22,  417,
 /*  2130 */   418,  419,  420,  421,  422,  410,  424,  234,  100,  414,
 /*  2140 */   101,  367,  417,  418,  419,  420,  421,  422,  101,  424,
 /*  2150 */   100,  111,  100,  379,  101,  381,   35,   35,  100,   35,
 /*  2160 */   101,  331,  100,   35,   35,  101,  214,  101,  100,  100,
 /*  2170 */    35,  341,   35,   22,  101,  100,  331,  122,   44,  122,
 /*  2180 */   100,   66,  122,  122,  410,  100,  341,  100,  414,   35,
 /*  2190 */    65,  417,  418,  419,  420,  421,  422,  367,  424,   35,
 /*  2200 */    35,   35,   35,   35,   35,   35,   35,   35,   72,  379,
 /*  2210 */   331,  381,  367,   94,   35,   35,   35,   44,   22,   35,
 /*  2220 */   341,   35,   35,   35,  379,   72,  381,   35,   35,   35,
 /*  2230 */    35,   22,   35,    0,   35,    0,   35,   39,    0,   49,
 /*  2240 */   410,   39,   35,    0,  414,   39,  367,  417,  418,  419,
 /*  2250 */   420,  421,  422,   49,  424,  410,   35,   49,  379,  414,
 /*  2260 */   381,   49,  417,  418,  419,  420,  421,  422,  331,  424,
 /*  2270 */    39,    0,   35,    0,   35,   22,   21,   21,  341,   22,
 /*  2280 */    22,   20,  472,  472,  331,  472,  472,  472,  472,  410,
 /*  2290 */   472,  472,  472,  414,  341,  472,  417,  418,  419,  420,
 /*  2300 */   421,  422,  472,  424,  367,  472,  472,  472,  472,  472,
 /*  2310 */   472,  472,  331,  472,  472,  472,  379,  472,  381,  472,
 /*  2320 */   367,  472,  341,  472,  472,  472,  472,  472,  331,  472,
 /*  2330 */   472,  472,  379,  472,  381,  472,  472,  472,  341,  472,
 /*  2340 */   472,  472,  472,  472,  472,  472,  472,  410,  367,  472,
 /*  2350 */   472,  414,  472,  472,  417,  418,  419,  420,  421,  422,
 /*  2360 */   379,  424,  381,  410,  367,  472,  472,  414,  472,  472,
 /*  2370 */   417,  418,  419,  420,  421,  422,  379,  424,  381,  472,
 /*  2380 */   472,  472,  472,  472,  472,  472,  472,  472,  472,  472,
 /*  2390 */   472,  410,  472,  472,  472,  414,  331,  472,  417,  418,
 /*  2400 */   419,  420,  421,  422,  472,  424,  341,  410,  472,  472,
 /*  2410 */   472,  414,  331,  472,  417,  418,  419,  420,  421,  422,
 /*  2420 */   472,  424,  341,  472,  472,  472,  472,  472,  472,  472,
 /*  2430 */   472,  472,  367,  472,  472,  472,  472,  472,  472,  472,
 /*  2440 */   472,  472,  472,  472,  379,  472,  381,  472,  367,  472,
 /*  2450 */   472,  472,  472,  472,  472,  472,  472,  472,  331,  472,
 /*  2460 */   379,  472,  381,  472,  472,  472,  472,  472,  341,  472,
 /*  2470 */   472,  331,  472,  472,  472,  410,  472,  472,  472,  414,
 /*  2480 */   472,  341,  417,  418,  419,  420,  421,  422,  472,  424,
 /*  2490 */   472,  410,  472,  472,  367,  414,  472,  472,  417,  418,
 /*  2500 */   419,  420,  421,  422,  472,  424,  379,  367,  381,  472,
 /*  2510 */   472,  472,  472,  472,  472,  472,  472,  472,  472,  379,
 /*  2520 */   331,  381,  472,  472,  472,  472,  472,  472,  472,  472,
 /*  2530 */   341,  472,  472,  472,  472,  472,  472,  410,  472,  472,
 /*  2540 */   472,  414,  331,  472,  417,  418,  419,  420,  421,  422,
 /*  2550 */   410,  424,  341,  472,  414,  472,  367,  417,  418,  419,
 /*  2560 */   420,  421,  422,  472,  424,  472,  472,  472,  379,  472,
 /*  2570 */   381,  472,  472,  472,  472,  472,  331,  472,  367,  472,
 /*  2580 */   472,  472,  472,  472,  472,  472,  341,  472,  472,  472,
 /*  2590 */   379,  331,  381,  472,  472,  472,  472,  472,  472,  410,
 /*  2600 */   472,  341,  472,  414,  472,  472,  417,  418,  419,  420,
 /*  2610 */   421,  422,  367,  424,  472,  472,  472,  472,  472,  472,
 /*  2620 */   472,  410,  472,  472,  379,  414,  381,  367,  417,  418,
 /*  2630 */   419,  420,  421,  422,  472,  424,  472,  472,  472,  379,
 /*  2640 */   472,  381,  472,  472,  472,  472,  472,  472,  472,  472,
 /*  2650 */   331,  472,  472,  472,  472,  410,  472,  472,  472,  414,
 /*  2660 */   341,  472,  417,  418,  419,  420,  421,  422,  472,  424,
 /*  2670 */   410,  472,  472,  472,  414,  472,  472,  417,  418,  419,
 /*  2680 */   420,  421,  422,  472,  424,  472,  367,  472,  472,  472,
 /*  2690 */   472,  472,  472,  472,  472,  472,  472,  472,  379,  472,
 /*  2700 */   381,  472,  472,  472,  472,  472,  472,  472,  472,  472,
 /*  2710 */   472,  472,  472,  472,  472,  472,  472,  472,  472,  472,
 /*  2720 */   472,  472,  472,  472,  472,  472,  472,  472,  472,  410,
 /*  2730 */   472,  472,  472,  414,  472,  472,  417,  418,  419,  420,
 /*  2740 */   421,  422,  472,  424,
};
#define YY_SHIFT_COUNT    (752)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2273)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1051,    0,   98,    0,  320,  320,  320,  320,  320,  320,
 /*    10 */   320,  320,  320,  320,  320,  320,  418,  639,  639,  737,
 /*    20 */   639,  639,  639,  639,  639,  639,  639,  639,  639,  639,
 /*    30 */   639,  639,  639,  639,  639,  639,  639,  639,  639,  639,
 /*    40 */   639,  639,  639,  639,  639,  639,  639,  639,  639,   34,
 /*    50 */   148,  274,   32,  352,   28,  349,   28,   32,   32, 1436,
 /*    60 */  1436, 1436,   28, 1436, 1436,  137,   28,  157,  770,  189,
 /*    70 */   189,  770,  344,  344,  415,  130,  105,  105,  189,  189,
 /*    80 */   189,  189,  189,  189,  189,  243,  189,  189,   30,  157,
 /*    90 */   189,  189,  259,  189,  157,  189,  243,  189,  243,  157,
 /*   100 */   189,  189,  157,  189,  157,  157,  157,  189,  300,  875,
 /*   110 */    15,   15,  308,   13,  726,  726,  726,  726,  726,  726,
 /*   120 */   726,  726,  726,  726,  726,  726,  726,  726,  726,  726,
 /*   130 */   726,  726,  726,  812,    1,  415,  130,  343,  169,  169,
 /*   140 */   169,  455,  480,  480,  343,  484,  484,  484,   30,  489,
 /*   150 */   333,  157,  633,  157,  633,  633,  678,  839,  181,  181,
 /*   160 */   181,  181,  181,  181,  181,  181,  561,  632,  341,  712,
 /*   170 */   806,  363,   29,  402,  753,  967,  142,  783, 1090,  419,
 /*   180 */  1020,  916,  762,  858,  342,  762,  960,  155,  663, 1121,
 /*   190 */  1327, 1202, 1351, 1381, 1351, 1242, 1391, 1391, 1351, 1242,
 /*   200 */  1242, 1319, 1324, 1391, 1328, 1391, 1391, 1391, 1408, 1382,
 /*   210 */  1408, 1382, 1413,   30, 1435,   30, 1442, 1443,   30, 1442,
 /*   220 */    30,   30,   30, 1391,   30, 1427, 1427, 1408,  157,  157,
 /*   230 */   157,  157,  157,  157,  157,  157,  157,  157,  157, 1391,
 /*   240 */  1408,  633,  633,  633, 1291, 1399, 1413,  300, 1339, 1435,
 /*   250 */   300, 1391, 1381, 1381,  633, 1286, 1293,  633, 1286, 1293,
 /*   260 */   633,  633,  157, 1279, 1371, 1286, 1295, 1297, 1310, 1121,
 /*   270 */  1290, 1298, 1306, 1326,  484, 1559, 1391, 1442,  300,  300,
 /*   280 */  1562, 1293,  633,  633,  633,  633,  633, 1293,  633, 1416,
 /*   290 */   300,  678,  300,  484, 1532, 1536,  633,  839, 1391,  300,
 /*   300 */  1608, 1408, 2744, 2744, 2744, 2744, 2744, 2744, 2744, 2744,
 /*   310 */  2744,  975,  302,  214, 1066,  673,  869,  771,  312,  260,
 /*   320 */   394,  964,  334,  919,  919,  919,  919,  919,  919,  919,
 /*   330 */   919,  919,  294,  150,  275,  275,  445,  490, 1047,  695,
 /*   340 */    74,  795,  792,  472,  965,  965, 1025,  889,  369, 1025,
 /*   350 */  1025, 1025, 1163, 1154, 1108, 1184,  310,  947, 1109, 1135,
 /*   360 */  1136, 1145, 1232, 1257, 1271, 1083, 1197, 1201,  881, 1206,
 /*   370 */  1207, 1220, 1152,  804, 1098, 1169, 1238, 1246, 1252, 1253,
 /*   380 */  1255, 1259, 1308, 1267, 1113, 1132, 1157, 1269, 1218, 1273,
 /*   390 */  1288, 1289, 1294, 1302, 1304,  483, 1322, 1330, 1277,  921,
 /*   400 */  1687, 1688, 1690, 1651, 1692, 1662, 1493, 1665, 1666, 1668,
 /*   410 */  1501, 1708, 1680, 1682, 1512, 1719, 1514, 1722, 1691, 1729,
 /*   420 */  1703, 1731, 1697, 1540, 1547, 1550, 1737, 1738, 1739, 1558,
 /*   430 */  1560, 1743, 1745, 1699, 1747, 1748, 1749, 1709, 1750, 1752,
 /*   440 */  1753, 1754, 1755, 1757, 1758, 1759, 1606, 1727, 1763, 1609,
 /*   450 */  1765, 1767, 1768, 1769, 1770, 1771, 1775, 1776, 1778, 1779,
 /*   460 */  1786, 1788, 1789, 1791, 1793, 1795, 1760, 1796, 1797, 1801,
 /*   470 */  1805, 1808, 1809, 1794, 1818, 1819, 1820, 1683, 1821, 1823,
 /*   480 */  1803, 1782, 1810, 1785, 1827, 1777, 1799, 1837, 1792, 1841,
 /*   490 */  1798, 1850, 1852, 1811, 1815, 1816, 1812, 1817, 1848, 1824,
 /*   500 */  1855, 1826, 1828, 1863, 1868, 1870, 1833, 1705, 1874, 1885,
 /*   510 */  1886, 1822, 1887, 1889, 1856, 1843, 1851, 1893, 1859, 1846,
 /*   520 */  1858, 1899, 1865, 1853, 1864, 1904, 1872, 1861, 1866, 1908,
 /*   530 */  1911, 1912, 1914, 1807, 1813, 1882, 1896, 1921, 1888, 1890,
 /*   540 */  1891, 1894, 1895, 1878, 1880, 1898, 1905, 1906, 1925, 1946,
 /*   550 */  1927, 1947, 1939, 1913, 1962, 1941, 1930, 1966, 1932, 1969,
 /*   560 */  1935, 1971, 1950, 1954, 1938, 1940, 1942, 1875, 1883, 1978,
 /*   570 */  1825, 1884, 1944, 1985, 1800, 1964, 1835, 1831, 1987, 1990,
 /*   580 */  1838, 1832, 2002, 1965, 1761, 1910, 1907, 1916, 1976, 1915,
 /*   590 */  1979, 1936, 1933, 1968, 1982, 1934, 1928, 1945, 1948, 1949,
 /*   600 */  1989, 1991, 1992, 1951, 1993, 1783, 1956, 1957, 2037, 2003,
 /*   610 */  1802, 2006, 2011, 2014, 2017, 2019, 2024, 1960, 1961, 2016,
 /*   620 */  1829, 2021, 2028, 2078, 2086, 2088, 2089, 1994, 2051, 1812,
 /*   630 */  2048, 1996, 1998, 1999, 2001, 2007, 1926, 2008, 2098, 2063,
 /*   640 */  1943, 2009, 2000, 1812, 2056, 2067, 2015, 1903, 2018, 2112,
 /*   650 */  2095, 1909, 2020, 2022, 2025, 2023, 2027, 2039, 2071, 2038,
 /*   660 */  2050, 2072, 2047, 2106, 1952, 2052, 2040, 2053, 2121, 2122,
 /*   670 */  2058, 2059, 2124, 2062, 2064, 2128, 2068, 2066, 2129, 2069,
 /*   680 */  2073, 2135, 2075, 2055, 2057, 2060, 2061, 2080, 2134, 2085,
 /*   690 */  2137, 2087, 2134, 2134, 2151, 2115, 2125, 2154, 2164, 2165,
 /*   700 */  2166, 2167, 2168, 2169, 2170, 2171, 2172, 2136, 2119, 2173,
 /*   710 */  2179, 2180, 2181, 2196, 2184, 2186, 2187, 2153, 1878, 2188,
 /*   720 */  1880, 2192, 2193, 2194, 2195, 2209, 2197, 2233, 2199, 2190,
 /*   730 */  2198, 2235, 2201, 2204, 2202, 2238, 2207, 2208, 2206, 2243,
 /*   740 */  2221, 2212, 2231, 2271, 2237, 2239, 2273, 2253, 2255, 2257,
 /*   750 */  2258, 2256, 2261,
};
#define YY_REDUCE_COUNT (310)
#define YY_REDUCE_MIN   (-386)
#define YY_REDUCE_MAX   (2319)
static const short yy_reduce_ofst[] = {
 /*     0 */   -48,  740, -275,  143,  856,  905,  963, 1021, 1065, 1093,
 /*    10 */  1190, 1260, 1292,   81, 1363, 1393,  421, -331,  323, 1425,
 /*    20 */   760, 1175, 1236, 1459, 1517, 1534, 1578, 1601, 1650, 1663,
 /*    30 */  1712, 1725, 1774, 1830, 1845, 1879, 1937, 1953, 1981, 1997,
 /*    40 */  2065, 2081, 2127, 2140, 2189, 2211, 2245, 2260, 2319, -265,
 /*    50 */   146, -345, -233,  539,  546,  748,  758,  236,  325, -353,
 /*    60 */  -301, -231,  636, -284,  -33,  662,  801,  114, -378, -333,
 /*    70 */    -2, -323, -148, -135,   49, -375, -273, -237,  139,  230,
 /*    80 */   256,  351,  356,  437,  441,  135,  492,  558,  305,  147,
 /*    90 */   653,  658,  254,  736,  288,  656,  496,  746,  556, -358,
 /*   100 */   776,  782,  364,  732,  396,  621,  449,  797,   88, -225,
 /*   110 */  -386, -386, -279, -248, -180, -146,   21,  151,  152,  180,
 /*   120 */   425,  522,  591,  747,  752,  787,  813,  814,  816,  821,
 /*   130 */   842,  854,  859, -213,  187,  -85, -131,  215,  187,  268,
 /*   140 */   287,  388,   79,  128,  756, -330, -149,  375,  527, -116,
 /*   150 */   292,  426,  431,  512,  807,  827,  845,  532,  508,  562,
 /*   160 */   649,  667,  725,  901,  927,  725,  769,  851,  895,  925,
 /*   170 */   835,  857,  984,  878,  978,  978, 1006,  962, 1016, 1017,
 /*   180 */   981,  972,  918,  918,  903,  918,  930,  928,  978,  966,
 /*   190 */   968,  991, 1011, 1015, 1023, 1026, 1072, 1073, 1028, 1031,
 /*   200 */  1032, 1067, 1070, 1078, 1075, 1082, 1086, 1087, 1096, 1100,
 /*   210 */  1114, 1116, 1046, 1106, 1080, 1111, 1122, 1068, 1117, 1124,
 /*   220 */  1120, 1125, 1128, 1130, 1129, 1133, 1143, 1148, 1123, 1126,
 /*   230 */  1131, 1137, 1138, 1142, 1151, 1153, 1156, 1158, 1159, 1162,
 /*   240 */  1164, 1112, 1140, 1155, 1118, 1134, 1127, 1189, 1139, 1165,
 /*   250 */  1191, 1196, 1149, 1150, 1161, 1095, 1166, 1170, 1099, 1167,
 /*   260 */  1173, 1174,  978, 1103, 1101, 1107, 1115, 1168, 1119, 1160,
 /*   270 */  1102, 1110, 1141,  918, 1237, 1171, 1240, 1239, 1244, 1256,
 /*   280 */  1192, 1194, 1204, 1219, 1227, 1234, 1241, 1222, 1249, 1243,
 /*   290 */  1283, 1268, 1284, 1296, 1208, 1272, 1261, 1281, 1305, 1301,
 /*   300 */  1317, 1335, 1251, 1263, 1280, 1303, 1311, 1315, 1325, 1336,
 /*   310 */  1356,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*    10 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*    20 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*    30 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*    40 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*    50 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*    60 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*    70 */  1695, 1695, 1695, 1695, 1964, 1695, 1695, 1695, 1695, 1695,
 /*    80 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1777, 1695,
 /*    90 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   100 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1775, 1957,
 /*   110 */  2173, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   120 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   130 */  1695, 1695, 1695, 1695, 2185, 1695, 1695, 1695, 2185, 2185,
 /*   140 */  2185, 1775, 2145, 2145, 1695, 1695, 1695, 1695, 1777, 2018,
 /*   150 */  1695, 1695, 1695, 1695, 1695, 1695, 1892, 1695, 1695, 1695,
 /*   160 */  1695, 1695, 1916, 1695, 1695, 1695, 2010, 1695, 1695, 2210,
 /*   170 */  2266, 1695, 1695, 2213, 1695, 1695, 1695, 1969, 1695, 1695,
 /*   180 */  1846, 2200, 2177, 2191, 2250, 2178, 2175, 2194, 1695, 2204,
 /*   190 */  1695, 2003, 1962, 1695, 1962, 1959, 1695, 1695, 1962, 1959,
 /*   200 */  1959, 1835, 1831, 1695, 1829, 1695, 1695, 1695, 1695, 1742,
 /*   210 */  1695, 1742, 1695, 1777, 1695, 1777, 1695, 1695, 1777, 1695,
 /*   220 */  1777, 1777, 1777, 1695, 1777, 1755, 1755, 1695, 1695, 1695,
 /*   230 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   240 */  1695, 1695, 1695, 1695, 2030, 2016, 1695, 1775, 2012, 1695,
 /*   250 */  1775, 1695, 1695, 1695, 1695, 2221, 2219, 1695, 2221, 2219,
 /*   260 */  1695, 1695, 1695, 2235, 2231, 2221, 2239, 2237, 2206, 2204,
 /*   270 */  2269, 2256, 2252, 2191, 1695, 1695, 1695, 1695, 1775, 1775,
 /*   280 */  1695, 2219, 1695, 1695, 1695, 1695, 1695, 2219, 1695, 1695,
 /*   290 */  1775, 1695, 1775, 1695, 1695, 1862, 1695, 1695, 1695, 1775,
 /*   300 */  1727, 1695, 2005, 2021, 1987, 1987, 1895, 1895, 1895, 1778,
 /*   310 */  1700, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   320 */  1695, 1695, 1695, 2234, 2233, 2100, 1695, 2149, 2148, 2147,
 /*   330 */  2138, 2099, 1858, 1695, 2098, 2097, 1695, 1695, 1695, 1695,
 /*   340 */  1695, 1695, 1695, 1695, 1978, 1977, 2091, 1695, 1695, 2092,
 /*   350 */  2090, 2089, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   360 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   370 */  1695, 1695, 1695, 2253, 2257, 1695, 1695, 1695, 1695, 1695,
 /*   380 */  1695, 1695, 2174, 1695, 1695, 1695, 1695, 1695, 2073, 1695,
 /*   390 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   400 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   410 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   420 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   430 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   440 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   450 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   460 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   470 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   480 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   490 */  1695, 1695, 1695, 1695, 1695, 1732, 2078, 1695, 1695, 1695,
 /*   500 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   510 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   520 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   530 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   540 */  1695, 1695, 1695, 1816, 1815, 1695, 1695, 1695, 1695, 1695,
 /*   550 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   560 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 2082, 1695, 1695,
 /*   570 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   580 */  1695, 1695, 2249, 2207, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   590 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   600 */  1695, 1695, 2073, 1695, 2232, 1695, 1695, 2247, 1695, 2251,
 /*   610 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 2184, 2180, 1695,
 /*   620 */  1695, 2176, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 2081,
 /*   630 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   640 */  1695, 1695, 1695, 2072, 1695, 2135, 1695, 1695, 1695, 2169,
 /*   650 */  1695, 1695, 2120, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   660 */  1695, 1695, 2082, 1695, 2085, 1695, 1695, 1695, 1695, 1695,
 /*   670 */  1889, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   680 */  1695, 1695, 1695, 1874, 1872, 1871, 1870, 1695, 1902, 1695,
 /*   690 */  1695, 1695, 1898, 1897, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   700 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1796,
 /*   710 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1788, 1695,
 /*   720 */  1787, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   730 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   740 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   750 */  1695, 1695, 1695,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*       WITH => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*  TIMESTAMP => nothing */
  276,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  276,  /*      AFTER => ABORT */
  276,  /*     ATTACH => ABORT */
  276,  /*     BEFORE => ABORT */
  276,  /*      BEGIN => ABORT */
  276,  /*     BITAND => ABORT */
  276,  /*     BITNOT => ABORT */
  276,  /*      BITOR => ABORT */
  276,  /*     BLOCKS => ABORT */
  276,  /*     CHANGE => ABORT */
  276,  /*      COMMA => ABORT */
  276,  /*     CONCAT => ABORT */
  276,  /*   CONFLICT => ABORT */
  276,  /*       COPY => ABORT */
  276,  /*   DEFERRED => ABORT */
  276,  /* DELIMITERS => ABORT */
  276,  /*     DETACH => ABORT */
  276,  /*     DIVIDE => ABORT */
  276,  /*        DOT => ABORT */
  276,  /*       EACH => ABORT */
  276,  /*       FAIL => ABORT */
  276,  /*       FILE => ABORT */
  276,  /*        FOR => ABORT */
  276,  /*       GLOB => ABORT */
  276,  /*         ID => ABORT */
  276,  /*  IMMEDIATE => ABORT */
  276,  /*     IMPORT => ABORT */
  276,  /*  INITIALLY => ABORT */
  276,  /*    INSTEAD => ABORT */
  276,  /*     ISNULL => ABORT */
  276,  /*        KEY => ABORT */
  276,  /*    MODULES => ABORT */
  276,  /*  NK_BITNOT => ABORT */
  276,  /*    NK_SEMI => ABORT */
  276,  /*    NOTNULL => ABORT */
  276,  /*         OF => ABORT */
  276,  /*       PLUS => ABORT */
  276,  /*  PRIVILEGE => ABORT */
  276,  /*      RAISE => ABORT */
  276,  /*    REPLACE => ABORT */
  276,  /*   RESTRICT => ABORT */
  276,  /*        ROW => ABORT */
  276,  /*       SEMI => ABORT */
  276,  /*       STAR => ABORT */
  276,  /*  STATEMENT => ABORT */
  276,  /*     STRICT => ABORT */
  276,  /*     STRING => ABORT */
  276,  /*      TIMES => ABORT */
  276,  /*     VALUES => ABORT */
  276,  /*   VARIABLE => ABORT */
  276,  /*       VIEW => ABORT */
  276,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "WITH",
  /*   49 */ "DNODE",
  /*   50 */ "PORT",
  /*   51 */ "DNODES",
  /*   52 */ "NK_IPTOKEN",
  /*   53 */ "FORCE",
  /*   54 */ "LOCAL",
  /*   55 */ "QNODE",
  /*   56 */ "BNODE",
  /*   57 */ "SNODE",
  /*   58 */ "MNODE",
  /*   59 */ "DATABASE",
  /*   60 */ "USE",
  /*   61 */ "FLUSH",
  /*   62 */ "TRIM",
  /*   63 */ "COMPACT",
  /*   64 */ "IF",
  /*   65 */ "NOT",
  /*   66 */ "EXISTS",
  /*   67 */ "BUFFER",
  /*   68 */ "CACHEMODEL",
  /*   69 */ "CACHESIZE",
  /*   70 */ "COMP",
  /*   71 */ "DURATION",
  /*   72 */ "NK_VARIABLE",
  /*   73 */ "MAXROWS",
  /*   74 */ "MINROWS",
  /*   75 */ "KEEP",
  /*   76 */ "PAGES",
  /*   77 */ "PAGESIZE",
  /*   78 */ "TSDB_PAGESIZE",
  /*   79 */ "PRECISION",
  /*   80 */ "REPLICA",
  /*   81 */ "VGROUPS",
  /*   82 */ "SINGLE_STABLE",
  /*   83 */ "RETENTIONS",
  /*   84 */ "SCHEMALESS",
  /*   85 */ "WAL_LEVEL",
  /*   86 */ "WAL_FSYNC_PERIOD",
  /*   87 */ "WAL_RETENTION_PERIOD",
  /*   88 */ "WAL_RETENTION_SIZE",
  /*   89 */ "WAL_ROLL_PERIOD",
  /*   90 */ "WAL_SEGMENT_SIZE",
  /*   91 */ "STT_TRIGGER",
  /*   92 */ "TABLE_PREFIX",
  /*   93 */ "TABLE_SUFFIX",
  /*   94 */ "NK_COLON",
  /*   95 */ "MAX_SPEED",
  /*   96 */ "START",
  /*   97 */ "TIMESTAMP",
  /*   98 */ "END",
  /*   99 */ "TABLE",
  /*  100 */ "NK_LP",
  /*  101 */ "NK_RP",
  /*  102 */ "STABLE",
  /*  103 */ "ADD",
  /*  104 */ "COLUMN",
  /*  105 */ "MODIFY",
  /*  106 */ "RENAME",
  /*  107 */ "TAG",
  /*  108 */ "SET",
  /*  109 */ "NK_EQ",
  /*  110 */ "USING",
  /*  111 */ "TAGS",
  /*  112 */ "BOOL",
  /*  113 */ "TINYINT",
  /*  114 */ "SMALLINT",
  /*  115 */ "INT",
  /*  116 */ "INTEGER",
  /*  117 */ "BIGINT",
  /*  118 */ "FLOAT",
  /*  119 */ "DOUBLE",
  /*  120 */ "BINARY",
  /*  121 */ "NCHAR",
  /*  122 */ "UNSIGNED",
  /*  123 */ "JSON",
  /*  124 */ "VARCHAR",
  /*  125 */ "MEDIUMBLOB",
  /*  126 */ "BLOB",
  /*  127 */ "VARBINARY",
  /*  128 */ "DECIMAL",
  /*  129 */ "COMMENT",
  /*  130 */ "MAX_DELAY",
  /*  131 */ "WATERMARK",
  /*  132 */ "ROLLUP",
  /*  133 */ "TTL",
  /*  134 */ "SMA",
  /*  135 */ "DELETE_MARK",
  /*  136 */ "FIRST",
  /*  137 */ "LAST",
  /*  138 */ "SHOW",
  /*  139 */ "PRIVILEGES",
  /*  140 */ "DATABASES",
  /*  141 */ "TABLES",
  /*  142 */ "STABLES",
  /*  143 */ "MNODES",
  /*  144 */ "QNODES",
  /*  145 */ "FUNCTIONS",
  /*  146 */ "INDEXES",
  /*  147 */ "ACCOUNTS",
  /*  148 */ "APPS",
  /*  149 */ "CONNECTIONS",
  /*  150 */ "LICENCES",
  /*  151 */ "GRANTS",
  /*  152 */ "QUERIES",
  /*  153 */ "SCORES",
  /*  154 */ "TOPICS",
  /*  155 */ "VARIABLES",
  /*  156 */ "CLUSTER",
  /*  157 */ "BNODES",
  /*  158 */ "SNODES",
  /*  159 */ "TRANSACTIONS",
  /*  160 */ "DISTRIBUTED",
  /*  161 */ "CONSUMERS",
  /*  162 */ "SUBSCRIPTIONS",
  /*  163 */ "VNODES",
  /*  164 */ "ALIVE",
  /*  165 */ "LIKE",
  /*  166 */ "TBNAME",
  /*  167 */ "QTAGS",
  /*  168 */ "AS",
  /*  169 */ "INDEX",
  /*  170 */ "FUNCTION",
  /*  171 */ "INTERVAL",
  /*  172 */ "COUNT",
  /*  173 */ "LAST_ROW",
  /*  174 */ "TOPIC",
  /*  175 */ "META",
  /*  176 */ "CONSUMER",
  /*  177 */ "GROUP",
  /*  178 */ "DESC",
  /*  179 */ "DESCRIBE",
  /*  180 */ "RESET",
  /*  181 */ "QUERY",
  /*  182 */ "CACHE",
  /*  183 */ "EXPLAIN",
  /*  184 */ "ANALYZE",
  /*  185 */ "VERBOSE",
  /*  186 */ "NK_BOOL",
  /*  187 */ "RATIO",
  /*  188 */ "NK_FLOAT",
  /*  189 */ "OUTPUTTYPE",
  /*  190 */ "AGGREGATE",
  /*  191 */ "BUFSIZE",
  /*  192 */ "STREAM",
  /*  193 */ "INTO",
  /*  194 */ "TRIGGER",
  /*  195 */ "AT_ONCE",
  /*  196 */ "WINDOW_CLOSE",
  /*  197 */ "IGNORE",
  /*  198 */ "EXPIRED",
  /*  199 */ "FILL_HISTORY",
  /*  200 */ "UPDATE",
  /*  201 */ "SUBTABLE",
  /*  202 */ "KILL",
  /*  203 */ "CONNECTION",
  /*  204 */ "TRANSACTION",
  /*  205 */ "BALANCE",
  /*  206 */ "VGROUP",
  /*  207 */ "MERGE",
  /*  208 */ "REDISTRIBUTE",
  /*  209 */ "SPLIT",
  /*  210 */ "DELETE",
  /*  211 */ "INSERT",
  /*  212 */ "NULL",
  /*  213 */ "NK_QUESTION",
  /*  214 */ "NK_ARROW",
  /*  215 */ "ROWTS",
  /*  216 */ "QSTART",
  /*  217 */ "QEND",
  /*  218 */ "QDURATION",
  /*  219 */ "WSTART",
  /*  220 */ "WEND",
  /*  221 */ "WDURATION",
  /*  222 */ "IROWTS",
  /*  223 */ "ISFILLED",
  /*  224 */ "CAST",
  /*  225 */ "NOW",
  /*  226 */ "TODAY",
  /*  227 */ "TIMEZONE",
  /*  228 */ "CLIENT_VERSION",
  /*  229 */ "SERVER_VERSION",
  /*  230 */ "SERVER_STATUS",
  /*  231 */ "CURRENT_USER",
  /*  232 */ "CASE",
  /*  233 */ "WHEN",
  /*  234 */ "THEN",
  /*  235 */ "ELSE",
  /*  236 */ "BETWEEN",
  /*  237 */ "IS",
  /*  238 */ "NK_LT",
  /*  239 */ "NK_GT",
  /*  240 */ "NK_LE",
  /*  241 */ "NK_GE",
  /*  242 */ "NK_NE",
  /*  243 */ "MATCH",
  /*  244 */ "NMATCH",
  /*  245 */ "CONTAINS",
  /*  246 */ "IN",
  /*  247 */ "JOIN",
  /*  248 */ "INNER",
  /*  249 */ "SELECT",
  /*  250 */ "DISTINCT",
  /*  251 */ "WHERE",
  /*  252 */ "PARTITION",
  /*  253 */ "BY",
  /*  254 */ "SESSION",
  /*  255 */ "STATE_WINDOW",
  /*  256 */ "EVENT_WINDOW",
  /*  257 */ "SLIDING",
  /*  258 */ "FILL",
  /*  259 */ "VALUE",
  /*  260 */ "VALUE_F",
  /*  261 */ "NONE",
  /*  262 */ "PREV",
  /*  263 */ "NULL_F",
  /*  264 */ "LINEAR",
  /*  265 */ "NEXT",
  /*  266 */ "HAVING",
  /*  267 */ "RANGE",
  /*  268 */ "EVERY",
  /*  269 */ "ORDER",
  /*  270 */ "SLIMIT",
  /*  271 */ "SOFFSET",
  /*  272 */ "LIMIT",
  /*  273 */ "OFFSET",
  /*  274 */ "ASC",
  /*  275 */ "NULLS",
  /*  276 */ "ABORT",
  /*  277 */ "AFTER",
  /*  278 */ "ATTACH",
  /*  279 */ "BEFORE",
  /*  280 */ "BEGIN",
  /*  281 */ "BITAND",
  /*  282 */ "BITNOT",
  /*  283 */ "BITOR",
  /*  284 */ "BLOCKS",
  /*  285 */ "CHANGE",
  /*  286 */ "COMMA",
  /*  287 */ "CONCAT",
  /*  288 */ "CONFLICT",
  /*  289 */ "COPY",
  /*  290 */ "DEFERRED",
  /*  291 */ "DELIMITERS",
  /*  292 */ "DETACH",
  /*  293 */ "DIVIDE",
  /*  294 */ "DOT",
  /*  295 */ "EACH",
  /*  296 */ "FAIL",
  /*  297 */ "FILE",
  /*  298 */ "FOR",
  /*  299 */ "GLOB",
  /*  300 */ "ID",
  /*  301 */ "IMMEDIATE",
  /*  302 */ "IMPORT",
  /*  303 */ "INITIALLY",
  /*  304 */ "INSTEAD",
  /*  305 */ "ISNULL",
  /*  306 */ "KEY",
  /*  307 */ "MODULES",
  /*  308 */ "NK_BITNOT",
  /*  309 */ "NK_SEMI",
  /*  310 */ "NOTNULL",
  /*  311 */ "OF",
  /*  312 */ "PLUS",
  /*  313 */ "PRIVILEGE",
  /*  314 */ "RAISE",
  /*  315 */ "REPLACE",
  /*  316 */ "RESTRICT",
  /*  317 */ "ROW",
  /*  318 */ "SEMI",
  /*  319 */ "STAR",
  /*  320 */ "STATEMENT",
  /*  321 */ "STRICT",
  /*  322 */ "STRING",
  /*  323 */ "TIMES",
  /*  324 */ "VALUES",
  /*  325 */ "VARIABLE",
  /*  326 */ "VIEW",
  /*  327 */ "WAL",
  /*  328 */ "cmd",
  /*  329 */ "account_options",
  /*  330 */ "alter_account_options",
  /*  331 */ "literal",
  /*  332 */ "alter_account_option",
  /*  333 */ "user_name",
  /*  334 */ "sysinfo_opt",
  /*  335 */ "privileges",
  /*  336 */ "priv_level",
  /*  337 */ "with_opt",
  /*  338 */ "priv_type_list",
  /*  339 */ "priv_type",
  /*  340 */ "db_name",
  /*  341 */ "table_name",
  /*  342 */ "topic_name",
  /*  343 */ "search_condition",
  /*  344 */ "dnode_endpoint",
  /*  345 */ "force_opt",
  /*  346 */ "not_exists_opt",
  /*  347 */ "db_options",
  /*  348 */ "exists_opt",
  /*  349 */ "alter_db_options",
  /*  350 */ "speed_opt",
  /*  351 */ "start_opt",
  /*  352 */ "end_opt",
  /*  353 */ "integer_list",
  /*  354 */ "variable_list",
  /*  355 */ "retention_list",
  /*  356 */ "alter_db_option",
  /*  357 */ "retention",
  /*  358 */ "full_table_name",
  /*  359 */ "column_def_list",
  /*  360 */ "tags_def_opt",
  /*  361 */ "table_options",
  /*  362 */ "multi_create_clause",
  /*  363 */ "tags_def",
  /*  364 */ "multi_drop_clause",
  /*  365 */ "alter_table_clause",
  /*  366 */ "alter_table_options",
  /*  367 */ "column_name",
  /*  368 */ "type_name",
  /*  369 */ "signed_literal",
  /*  370 */ "create_subtable_clause",
  /*  371 */ "specific_cols_opt",
  /*  372 */ "expression_list",
  /*  373 */ "drop_table_clause",
  /*  374 */ "col_name_list",
  /*  375 */ "column_def",
  /*  376 */ "duration_list",
  /*  377 */ "rollup_func_list",
  /*  378 */ "alter_table_option",
  /*  379 */ "duration_literal",
  /*  380 */ "rollup_func_name",
  /*  381 */ "function_name",
  /*  382 */ "col_name",
  /*  383 */ "db_name_cond_opt",
  /*  384 */ "like_pattern_opt",
  /*  385 */ "table_name_cond",
  /*  386 */ "from_db_opt",
  /*  387 */ "tag_list_opt",
  /*  388 */ "tag_item",
  /*  389 */ "column_alias",
  /*  390 */ "full_index_name",
  /*  391 */ "index_options",
  /*  392 */ "index_name",
  /*  393 */ "func_list",
  /*  394 */ "sliding_opt",
  /*  395 */ "sma_stream_opt",
  /*  396 */ "func",
  /*  397 */ "sma_func_name",
  /*  398 */ "query_or_subquery",
  /*  399 */ "cgroup_name",
  /*  400 */ "analyze_opt",
  /*  401 */ "explain_options",
  /*  402 */ "insert_query",
  /*  403 */ "agg_func_opt",
  /*  404 */ "bufsize_opt",
  /*  405 */ "stream_name",
  /*  406 */ "stream_options",
  /*  407 */ "col_list_opt",
  /*  408 */ "tag_def_or_ref_opt",
  /*  409 */ "subtable_opt",
  /*  410 */ "expression",
  /*  411 */ "dnode_list",
  /*  412 */ "where_clause_opt",
  /*  413 */ "signed",
  /*  414 */ "literal_func",
  /*  415 */ "literal_list",
  /*  416 */ "table_alias",
  /*  417 */ "expr_or_subquery",
  /*  418 */ "pseudo_column",
  /*  419 */ "column_reference",
  /*  420 */ "function_expression",
  /*  421 */ "case_when_expression",
  /*  422 */ "star_func",
  /*  423 */ "star_func_para_list",
  /*  424 */ "noarg_func",
  /*  425 */ "other_para_list",
  /*  426 */ "star_func_para",
  /*  427 */ "when_then_list",
  /*  428 */ "case_when_else_opt",
  /*  429 */ "common_expression",
  /*  430 */ "when_then_expr",
  /*  431 */ "predicate",
  /*  432 */ "compare_op",
  /*  433 */ "in_op",
  /*  434 */ "in_predicate_value",
  /*  435 */ "boolean_value_expression",
  /*  436 */ "boolean_primary",
  /*  437 */ "from_clause_opt",
  /*  438 */ "table_reference_list",
  /*  439 */ "table_reference",
  /*  440 */ "table_primary",
  /*  441 */ "joined_table",
  /*  442 */ "alias_opt",
  /*  443 */ "subquery",
  /*  444 */ "parenthesized_joined_table",
  /*  445 */ "join_type",
  /*  446 */ "query_specification",
  /*  447 */ "set_quantifier_opt",
  /*  448 */ "select_list",
  /*  449 */ "partition_by_clause_opt",
  /*  450 */ "range_opt",
  /*  451 */ "every_opt",
  /*  452 */ "fill_opt",
  /*  453 */ "twindow_clause_opt",
  /*  454 */ "group_by_clause_opt",
  /*  455 */ "having_clause_opt",
  /*  456 */ "select_item",
  /*  457 */ "partition_list",
  /*  458 */ "partition_item",
  /*  459 */ "fill_mode",
  /*  460 */ "group_by_list",
  /*  461 */ "query_expression",
  /*  462 */ "query_simple",
  /*  463 */ "order_by_clause_opt",
  /*  464 */ "slimit_clause_opt",
  /*  465 */ "limit_clause_opt",
  /*  466 */ "union_query_expression",
  /*  467 */ "query_simple_or_subquery",
  /*  468 */ "sort_specification_list",
  /*  469 */ "sort_specification",
  /*  470 */ "ordering_specification_opt",
  /*  471 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level with_opt TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= db_name NK_DOT table_name",
 /*  43 */ "priv_level ::= topic_name",
 /*  44 */ "with_opt ::=",
 /*  45 */ "with_opt ::= WITH search_condition",
 /*  46 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  47 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  48 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  49 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  50 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  51 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  52 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  53 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  54 */ "dnode_endpoint ::= NK_STRING",
 /*  55 */ "dnode_endpoint ::= NK_ID",
 /*  56 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  57 */ "force_opt ::=",
 /*  58 */ "force_opt ::= FORCE",
 /*  59 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  60 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  61 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  67 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  68 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  69 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  70 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  71 */ "cmd ::= USE db_name",
 /*  72 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  73 */ "cmd ::= FLUSH DATABASE db_name",
 /*  74 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  75 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  76 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  77 */ "not_exists_opt ::=",
 /*  78 */ "exists_opt ::= IF EXISTS",
 /*  79 */ "exists_opt ::=",
 /*  80 */ "db_options ::=",
 /*  81 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  82 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  83 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  84 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  85 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  86 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  87 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  88 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  89 */ "db_options ::= db_options KEEP integer_list",
 /*  90 */ "db_options ::= db_options KEEP variable_list",
 /*  91 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  92 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  93 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  94 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  95 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  96 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  97 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  98 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  99 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 106 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 107 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 108 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 109 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 110 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 111 */ "alter_db_options ::= alter_db_option",
 /* 112 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 113 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 114 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 115 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 116 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 117 */ "alter_db_option ::= KEEP integer_list",
 /* 118 */ "alter_db_option ::= KEEP variable_list",
 /* 119 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 120 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 121 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 122 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 123 */ "alter_db_option ::= MINROWS NK_INTEGER",
 /* 124 */ "integer_list ::= NK_INTEGER",
 /* 125 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 126 */ "variable_list ::= NK_VARIABLE",
 /* 127 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 128 */ "retention_list ::= retention",
 /* 129 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 130 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 131 */ "speed_opt ::=",
 /* 132 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 133 */ "start_opt ::=",
 /* 134 */ "start_opt ::= START WITH NK_INTEGER",
 /* 135 */ "start_opt ::= START WITH NK_STRING",
 /* 136 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 137 */ "end_opt ::=",
 /* 138 */ "end_opt ::= END WITH NK_INTEGER",
 /* 139 */ "end_opt ::= END WITH NK_STRING",
 /* 140 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 141 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 142 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 143 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 144 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 145 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 146 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 147 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 148 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 149 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 150 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 151 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 152 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 153 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 154 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 155 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 156 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 157 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 158 */ "multi_create_clause ::= create_subtable_clause",
 /* 159 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 160 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 161 */ "multi_drop_clause ::= drop_table_clause",
 /* 162 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 163 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 164 */ "specific_cols_opt ::=",
 /* 165 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 166 */ "full_table_name ::= table_name",
 /* 167 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 168 */ "column_def_list ::= column_def",
 /* 169 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 170 */ "column_def ::= column_name type_name",
 /* 171 */ "type_name ::= BOOL",
 /* 172 */ "type_name ::= TINYINT",
 /* 173 */ "type_name ::= SMALLINT",
 /* 174 */ "type_name ::= INT",
 /* 175 */ "type_name ::= INTEGER",
 /* 176 */ "type_name ::= BIGINT",
 /* 177 */ "type_name ::= FLOAT",
 /* 178 */ "type_name ::= DOUBLE",
 /* 179 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 180 */ "type_name ::= TIMESTAMP",
 /* 181 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 182 */ "type_name ::= TINYINT UNSIGNED",
 /* 183 */ "type_name ::= SMALLINT UNSIGNED",
 /* 184 */ "type_name ::= INT UNSIGNED",
 /* 185 */ "type_name ::= BIGINT UNSIGNED",
 /* 186 */ "type_name ::= JSON",
 /* 187 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 188 */ "type_name ::= MEDIUMBLOB",
 /* 189 */ "type_name ::= BLOB",
 /* 190 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 191 */ "type_name ::= DECIMAL",
 /* 192 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 193 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 194 */ "tags_def_opt ::=",
 /* 195 */ "tags_def_opt ::= tags_def",
 /* 196 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 197 */ "table_options ::=",
 /* 198 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 199 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 200 */ "table_options ::= table_options WATERMARK duration_list",
 /* 201 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 202 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 203 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 204 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 205 */ "alter_table_options ::= alter_table_option",
 /* 206 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 207 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 208 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 209 */ "duration_list ::= duration_literal",
 /* 210 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 211 */ "rollup_func_list ::= rollup_func_name",
 /* 212 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 213 */ "rollup_func_name ::= function_name",
 /* 214 */ "rollup_func_name ::= FIRST",
 /* 215 */ "rollup_func_name ::= LAST",
 /* 216 */ "col_name_list ::= col_name",
 /* 217 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 218 */ "col_name ::= column_name",
 /* 219 */ "cmd ::= SHOW DNODES",
 /* 220 */ "cmd ::= SHOW USERS",
 /* 221 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 222 */ "cmd ::= SHOW DATABASES",
 /* 223 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 224 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 225 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 226 */ "cmd ::= SHOW MNODES",
 /* 227 */ "cmd ::= SHOW QNODES",
 /* 228 */ "cmd ::= SHOW FUNCTIONS",
 /* 229 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 230 */ "cmd ::= SHOW STREAMS",
 /* 231 */ "cmd ::= SHOW ACCOUNTS",
 /* 232 */ "cmd ::= SHOW APPS",
 /* 233 */ "cmd ::= SHOW CONNECTIONS",
 /* 234 */ "cmd ::= SHOW LICENCES",
 /* 235 */ "cmd ::= SHOW GRANTS",
 /* 236 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 237 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 238 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 239 */ "cmd ::= SHOW QUERIES",
 /* 240 */ "cmd ::= SHOW SCORES",
 /* 241 */ "cmd ::= SHOW TOPICS",
 /* 242 */ "cmd ::= SHOW VARIABLES",
 /* 243 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 244 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 245 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 246 */ "cmd ::= SHOW BNODES",
 /* 247 */ "cmd ::= SHOW SNODES",
 /* 248 */ "cmd ::= SHOW CLUSTER",
 /* 249 */ "cmd ::= SHOW TRANSACTIONS",
 /* 250 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 251 */ "cmd ::= SHOW CONSUMERS",
 /* 252 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 253 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 254 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 255 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 256 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 257 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 258 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 259 */ "db_name_cond_opt ::=",
 /* 260 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 261 */ "like_pattern_opt ::=",
 /* 262 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 263 */ "table_name_cond ::= table_name",
 /* 264 */ "from_db_opt ::=",
 /* 265 */ "from_db_opt ::= FROM db_name",
 /* 266 */ "tag_list_opt ::=",
 /* 267 */ "tag_list_opt ::= tag_item",
 /* 268 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 269 */ "tag_item ::= TBNAME",
 /* 270 */ "tag_item ::= QTAGS",
 /* 271 */ "tag_item ::= column_name",
 /* 272 */ "tag_item ::= column_name column_alias",
 /* 273 */ "tag_item ::= column_name AS column_alias",
 /* 274 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 275 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 276 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 277 */ "full_index_name ::= index_name",
 /* 278 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 279 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 280 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 281 */ "func_list ::= func",
 /* 282 */ "func_list ::= func_list NK_COMMA func",
 /* 283 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 284 */ "sma_func_name ::= function_name",
 /* 285 */ "sma_func_name ::= COUNT",
 /* 286 */ "sma_func_name ::= FIRST",
 /* 287 */ "sma_func_name ::= LAST",
 /* 288 */ "sma_func_name ::= LAST_ROW",
 /* 289 */ "sma_stream_opt ::=",
 /* 290 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 291 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 292 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 293 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 294 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 295 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 296 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 297 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 298 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 299 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 300 */ "cmd ::= DESC full_table_name",
 /* 301 */ "cmd ::= DESCRIBE full_table_name",
 /* 302 */ "cmd ::= RESET QUERY CACHE",
 /* 303 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 304 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 305 */ "analyze_opt ::=",
 /* 306 */ "analyze_opt ::= ANALYZE",
 /* 307 */ "explain_options ::=",
 /* 308 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 309 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 310 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 311 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 312 */ "agg_func_opt ::=",
 /* 313 */ "agg_func_opt ::= AGGREGATE",
 /* 314 */ "bufsize_opt ::=",
 /* 315 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 316 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 317 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 318 */ "col_list_opt ::=",
 /* 319 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 320 */ "tag_def_or_ref_opt ::=",
 /* 321 */ "tag_def_or_ref_opt ::= tags_def",
 /* 322 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 323 */ "stream_options ::=",
 /* 324 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 325 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 326 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 327 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 328 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 329 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 330 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 331 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 332 */ "subtable_opt ::=",
 /* 333 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 334 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 335 */ "cmd ::= KILL QUERY NK_STRING",
 /* 336 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 337 */ "cmd ::= BALANCE VGROUP",
 /* 338 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 339 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 340 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 341 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 342 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 343 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 344 */ "cmd ::= query_or_subquery",
 /* 345 */ "cmd ::= insert_query",
 /* 346 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 347 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 348 */ "literal ::= NK_INTEGER",
 /* 349 */ "literal ::= NK_FLOAT",
 /* 350 */ "literal ::= NK_STRING",
 /* 351 */ "literal ::= NK_BOOL",
 /* 352 */ "literal ::= TIMESTAMP NK_STRING",
 /* 353 */ "literal ::= duration_literal",
 /* 354 */ "literal ::= NULL",
 /* 355 */ "literal ::= NK_QUESTION",
 /* 356 */ "duration_literal ::= NK_VARIABLE",
 /* 357 */ "signed ::= NK_INTEGER",
 /* 358 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 359 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 360 */ "signed ::= NK_FLOAT",
 /* 361 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 362 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 363 */ "signed_literal ::= signed",
 /* 364 */ "signed_literal ::= NK_STRING",
 /* 365 */ "signed_literal ::= NK_BOOL",
 /* 366 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 367 */ "signed_literal ::= duration_literal",
 /* 368 */ "signed_literal ::= NULL",
 /* 369 */ "signed_literal ::= literal_func",
 /* 370 */ "signed_literal ::= NK_QUESTION",
 /* 371 */ "literal_list ::= signed_literal",
 /* 372 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 373 */ "db_name ::= NK_ID",
 /* 374 */ "table_name ::= NK_ID",
 /* 375 */ "column_name ::= NK_ID",
 /* 376 */ "function_name ::= NK_ID",
 /* 377 */ "table_alias ::= NK_ID",
 /* 378 */ "column_alias ::= NK_ID",
 /* 379 */ "user_name ::= NK_ID",
 /* 380 */ "topic_name ::= NK_ID",
 /* 381 */ "stream_name ::= NK_ID",
 /* 382 */ "cgroup_name ::= NK_ID",
 /* 383 */ "index_name ::= NK_ID",
 /* 384 */ "expr_or_subquery ::= expression",
 /* 385 */ "expression ::= literal",
 /* 386 */ "expression ::= pseudo_column",
 /* 387 */ "expression ::= column_reference",
 /* 388 */ "expression ::= function_expression",
 /* 389 */ "expression ::= case_when_expression",
 /* 390 */ "expression ::= NK_LP expression NK_RP",
 /* 391 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 392 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 393 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 394 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 395 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 396 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 397 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 398 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 399 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 400 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 401 */ "expression_list ::= expr_or_subquery",
 /* 402 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 403 */ "column_reference ::= column_name",
 /* 404 */ "column_reference ::= table_name NK_DOT column_name",
 /* 405 */ "pseudo_column ::= ROWTS",
 /* 406 */ "pseudo_column ::= TBNAME",
 /* 407 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 408 */ "pseudo_column ::= QSTART",
 /* 409 */ "pseudo_column ::= QEND",
 /* 410 */ "pseudo_column ::= QDURATION",
 /* 411 */ "pseudo_column ::= WSTART",
 /* 412 */ "pseudo_column ::= WEND",
 /* 413 */ "pseudo_column ::= WDURATION",
 /* 414 */ "pseudo_column ::= IROWTS",
 /* 415 */ "pseudo_column ::= ISFILLED",
 /* 416 */ "pseudo_column ::= QTAGS",
 /* 417 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 418 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 419 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 420 */ "function_expression ::= literal_func",
 /* 421 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 422 */ "literal_func ::= NOW",
 /* 423 */ "noarg_func ::= NOW",
 /* 424 */ "noarg_func ::= TODAY",
 /* 425 */ "noarg_func ::= TIMEZONE",
 /* 426 */ "noarg_func ::= DATABASE",
 /* 427 */ "noarg_func ::= CLIENT_VERSION",
 /* 428 */ "noarg_func ::= SERVER_VERSION",
 /* 429 */ "noarg_func ::= SERVER_STATUS",
 /* 430 */ "noarg_func ::= CURRENT_USER",
 /* 431 */ "noarg_func ::= USER",
 /* 432 */ "star_func ::= COUNT",
 /* 433 */ "star_func ::= FIRST",
 /* 434 */ "star_func ::= LAST",
 /* 435 */ "star_func ::= LAST_ROW",
 /* 436 */ "star_func_para_list ::= NK_STAR",
 /* 437 */ "star_func_para_list ::= other_para_list",
 /* 438 */ "other_para_list ::= star_func_para",
 /* 439 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 440 */ "star_func_para ::= expr_or_subquery",
 /* 441 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 442 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 443 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 444 */ "when_then_list ::= when_then_expr",
 /* 445 */ "when_then_list ::= when_then_list when_then_expr",
 /* 446 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 447 */ "case_when_else_opt ::=",
 /* 448 */ "case_when_else_opt ::= ELSE common_expression",
 /* 449 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 450 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 451 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 452 */ "predicate ::= expr_or_subquery IS NULL",
 /* 453 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 454 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 455 */ "compare_op ::= NK_LT",
 /* 456 */ "compare_op ::= NK_GT",
 /* 457 */ "compare_op ::= NK_LE",
 /* 458 */ "compare_op ::= NK_GE",
 /* 459 */ "compare_op ::= NK_NE",
 /* 460 */ "compare_op ::= NK_EQ",
 /* 461 */ "compare_op ::= LIKE",
 /* 462 */ "compare_op ::= NOT LIKE",
 /* 463 */ "compare_op ::= MATCH",
 /* 464 */ "compare_op ::= NMATCH",
 /* 465 */ "compare_op ::= CONTAINS",
 /* 466 */ "in_op ::= IN",
 /* 467 */ "in_op ::= NOT IN",
 /* 468 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 469 */ "boolean_value_expression ::= boolean_primary",
 /* 470 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 471 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 472 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 473 */ "boolean_primary ::= predicate",
 /* 474 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 475 */ "common_expression ::= expr_or_subquery",
 /* 476 */ "common_expression ::= boolean_value_expression",
 /* 477 */ "from_clause_opt ::=",
 /* 478 */ "from_clause_opt ::= FROM table_reference_list",
 /* 479 */ "table_reference_list ::= table_reference",
 /* 480 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 481 */ "table_reference ::= table_primary",
 /* 482 */ "table_reference ::= joined_table",
 /* 483 */ "table_primary ::= table_name alias_opt",
 /* 484 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 485 */ "table_primary ::= subquery alias_opt",
 /* 486 */ "table_primary ::= parenthesized_joined_table",
 /* 487 */ "alias_opt ::=",
 /* 488 */ "alias_opt ::= table_alias",
 /* 489 */ "alias_opt ::= AS table_alias",
 /* 490 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 491 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 492 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 493 */ "join_type ::=",
 /* 494 */ "join_type ::= INNER",
 /* 495 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 496 */ "set_quantifier_opt ::=",
 /* 497 */ "set_quantifier_opt ::= DISTINCT",
 /* 498 */ "set_quantifier_opt ::= ALL",
 /* 499 */ "select_list ::= select_item",
 /* 500 */ "select_list ::= select_list NK_COMMA select_item",
 /* 501 */ "select_item ::= NK_STAR",
 /* 502 */ "select_item ::= common_expression",
 /* 503 */ "select_item ::= common_expression column_alias",
 /* 504 */ "select_item ::= common_expression AS column_alias",
 /* 505 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 506 */ "where_clause_opt ::=",
 /* 507 */ "where_clause_opt ::= WHERE search_condition",
 /* 508 */ "partition_by_clause_opt ::=",
 /* 509 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 510 */ "partition_list ::= partition_item",
 /* 511 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 512 */ "partition_item ::= expr_or_subquery",
 /* 513 */ "partition_item ::= expr_or_subquery column_alias",
 /* 514 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 515 */ "twindow_clause_opt ::=",
 /* 516 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 517 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 518 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 519 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 520 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 521 */ "sliding_opt ::=",
 /* 522 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 523 */ "fill_opt ::=",
 /* 524 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 525 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 526 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP",
 /* 527 */ "fill_mode ::= NONE",
 /* 528 */ "fill_mode ::= PREV",
 /* 529 */ "fill_mode ::= NULL",
 /* 530 */ "fill_mode ::= NULL_F",
 /* 531 */ "fill_mode ::= LINEAR",
 /* 532 */ "fill_mode ::= NEXT",
 /* 533 */ "group_by_clause_opt ::=",
 /* 534 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 535 */ "group_by_list ::= expr_or_subquery",
 /* 536 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 537 */ "having_clause_opt ::=",
 /* 538 */ "having_clause_opt ::= HAVING search_condition",
 /* 539 */ "range_opt ::=",
 /* 540 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 541 */ "every_opt ::=",
 /* 542 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 543 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 544 */ "query_simple ::= query_specification",
 /* 545 */ "query_simple ::= union_query_expression",
 /* 546 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 547 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 548 */ "query_simple_or_subquery ::= query_simple",
 /* 549 */ "query_simple_or_subquery ::= subquery",
 /* 550 */ "query_or_subquery ::= query_expression",
 /* 551 */ "query_or_subquery ::= subquery",
 /* 552 */ "order_by_clause_opt ::=",
 /* 553 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 554 */ "slimit_clause_opt ::=",
 /* 555 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 556 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 557 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 558 */ "limit_clause_opt ::=",
 /* 559 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 560 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 561 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 562 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 563 */ "subquery ::= NK_LP subquery NK_RP",
 /* 564 */ "search_condition ::= common_expression",
 /* 565 */ "sort_specification_list ::= sort_specification",
 /* 566 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 567 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 568 */ "ordering_specification_opt ::=",
 /* 569 */ "ordering_specification_opt ::= ASC",
 /* 570 */ "ordering_specification_opt ::= DESC",
 /* 571 */ "null_ordering_opt ::=",
 /* 572 */ "null_ordering_opt ::= NULLS FIRST",
 /* 573 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 328: /* cmd */
    case 331: /* literal */
    case 337: /* with_opt */
    case 343: /* search_condition */
    case 347: /* db_options */
    case 349: /* alter_db_options */
    case 351: /* start_opt */
    case 352: /* end_opt */
    case 357: /* retention */
    case 358: /* full_table_name */
    case 361: /* table_options */
    case 365: /* alter_table_clause */
    case 366: /* alter_table_options */
    case 369: /* signed_literal */
    case 370: /* create_subtable_clause */
    case 373: /* drop_table_clause */
    case 375: /* column_def */
    case 379: /* duration_literal */
    case 380: /* rollup_func_name */
    case 382: /* col_name */
    case 383: /* db_name_cond_opt */
    case 384: /* like_pattern_opt */
    case 385: /* table_name_cond */
    case 386: /* from_db_opt */
    case 388: /* tag_item */
    case 390: /* full_index_name */
    case 391: /* index_options */
    case 394: /* sliding_opt */
    case 395: /* sma_stream_opt */
    case 396: /* func */
    case 398: /* query_or_subquery */
    case 401: /* explain_options */
    case 402: /* insert_query */
    case 406: /* stream_options */
    case 409: /* subtable_opt */
    case 410: /* expression */
    case 412: /* where_clause_opt */
    case 413: /* signed */
    case 414: /* literal_func */
    case 417: /* expr_or_subquery */
    case 418: /* pseudo_column */
    case 419: /* column_reference */
    case 420: /* function_expression */
    case 421: /* case_when_expression */
    case 426: /* star_func_para */
    case 428: /* case_when_else_opt */
    case 429: /* common_expression */
    case 430: /* when_then_expr */
    case 431: /* predicate */
    case 434: /* in_predicate_value */
    case 435: /* boolean_value_expression */
    case 436: /* boolean_primary */
    case 437: /* from_clause_opt */
    case 438: /* table_reference_list */
    case 439: /* table_reference */
    case 440: /* table_primary */
    case 441: /* joined_table */
    case 443: /* subquery */
    case 444: /* parenthesized_joined_table */
    case 446: /* query_specification */
    case 450: /* range_opt */
    case 451: /* every_opt */
    case 452: /* fill_opt */
    case 453: /* twindow_clause_opt */
    case 455: /* having_clause_opt */
    case 456: /* select_item */
    case 458: /* partition_item */
    case 461: /* query_expression */
    case 462: /* query_simple */
    case 464: /* slimit_clause_opt */
    case 465: /* limit_clause_opt */
    case 466: /* union_query_expression */
    case 467: /* query_simple_or_subquery */
    case 469: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy792)); 
}
      break;
    case 329: /* account_options */
    case 330: /* alter_account_options */
    case 332: /* alter_account_option */
    case 350: /* speed_opt */
    case 404: /* bufsize_opt */
{
 
}
      break;
    case 333: /* user_name */
    case 340: /* db_name */
    case 341: /* table_name */
    case 342: /* topic_name */
    case 344: /* dnode_endpoint */
    case 367: /* column_name */
    case 381: /* function_name */
    case 389: /* column_alias */
    case 392: /* index_name */
    case 397: /* sma_func_name */
    case 399: /* cgroup_name */
    case 405: /* stream_name */
    case 416: /* table_alias */
    case 422: /* star_func */
    case 424: /* noarg_func */
    case 442: /* alias_opt */
{
 
}
      break;
    case 334: /* sysinfo_opt */
{
 
}
      break;
    case 335: /* privileges */
    case 338: /* priv_type_list */
    case 339: /* priv_type */
{
 
}
      break;
    case 336: /* priv_level */
{
 
}
      break;
    case 345: /* force_opt */
    case 346: /* not_exists_opt */
    case 348: /* exists_opt */
    case 400: /* analyze_opt */
    case 403: /* agg_func_opt */
    case 447: /* set_quantifier_opt */
{
 
}
      break;
    case 353: /* integer_list */
    case 354: /* variable_list */
    case 355: /* retention_list */
    case 359: /* column_def_list */
    case 360: /* tags_def_opt */
    case 362: /* multi_create_clause */
    case 363: /* tags_def */
    case 364: /* multi_drop_clause */
    case 371: /* specific_cols_opt */
    case 372: /* expression_list */
    case 374: /* col_name_list */
    case 376: /* duration_list */
    case 377: /* rollup_func_list */
    case 387: /* tag_list_opt */
    case 393: /* func_list */
    case 407: /* col_list_opt */
    case 408: /* tag_def_or_ref_opt */
    case 411: /* dnode_list */
    case 415: /* literal_list */
    case 423: /* star_func_para_list */
    case 425: /* other_para_list */
    case 427: /* when_then_list */
    case 448: /* select_list */
    case 449: /* partition_by_clause_opt */
    case 454: /* group_by_clause_opt */
    case 457: /* partition_list */
    case 460: /* group_by_list */
    case 463: /* order_by_clause_opt */
    case 468: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy520)); 
}
      break;
    case 356: /* alter_db_option */
    case 378: /* alter_table_option */
{
 
}
      break;
    case 368: /* type_name */
{
 
}
      break;
    case 432: /* compare_op */
    case 433: /* in_op */
{
 
}
      break;
    case 445: /* join_type */
{
 
}
      break;
    case 459: /* fill_mode */
{
 
}
      break;
    case 470: /* ordering_specification_opt */
{
 
}
      break;
    case 471: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  328,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  328,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  329,    0 }, /* (2) account_options ::= */
  {  329,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  329,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  329,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  329,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  329,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  329,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  329,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  329,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  329,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  330,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  330,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  332,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  332,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  332,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  332,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  332,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  332,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  332,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  332,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  332,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  332,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  328,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  328,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  328,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  328,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  328,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  334,    0 }, /* (29) sysinfo_opt ::= */
  {  334,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  328,   -7 }, /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
  {  328,   -7 }, /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
  {  335,   -1 }, /* (33) privileges ::= ALL */
  {  335,   -1 }, /* (34) privileges ::= priv_type_list */
  {  335,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  338,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  338,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  339,   -1 }, /* (38) priv_type ::= READ */
  {  339,   -1 }, /* (39) priv_type ::= WRITE */
  {  336,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  336,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  336,   -3 }, /* (42) priv_level ::= db_name NK_DOT table_name */
  {  336,   -1 }, /* (43) priv_level ::= topic_name */
  {  337,    0 }, /* (44) with_opt ::= */
  {  337,   -2 }, /* (45) with_opt ::= WITH search_condition */
  {  328,   -3 }, /* (46) cmd ::= CREATE DNODE dnode_endpoint */
  {  328,   -5 }, /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  328,   -4 }, /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  328,   -4 }, /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  328,   -4 }, /* (50) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  328,   -5 }, /* (51) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  328,   -4 }, /* (52) cmd ::= ALTER ALL DNODES NK_STRING */
  {  328,   -5 }, /* (53) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  344,   -1 }, /* (54) dnode_endpoint ::= NK_STRING */
  {  344,   -1 }, /* (55) dnode_endpoint ::= NK_ID */
  {  344,   -1 }, /* (56) dnode_endpoint ::= NK_IPTOKEN */
  {  345,    0 }, /* (57) force_opt ::= */
  {  345,   -1 }, /* (58) force_opt ::= FORCE */
  {  328,   -3 }, /* (59) cmd ::= ALTER LOCAL NK_STRING */
  {  328,   -4 }, /* (60) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  328,   -5 }, /* (61) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (62) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (63) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (64) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (65) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (66) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (67) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (68) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (69) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  328,   -4 }, /* (70) cmd ::= DROP DATABASE exists_opt db_name */
  {  328,   -2 }, /* (71) cmd ::= USE db_name */
  {  328,   -4 }, /* (72) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  328,   -3 }, /* (73) cmd ::= FLUSH DATABASE db_name */
  {  328,   -4 }, /* (74) cmd ::= TRIM DATABASE db_name speed_opt */
  {  328,   -5 }, /* (75) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
  {  346,   -3 }, /* (76) not_exists_opt ::= IF NOT EXISTS */
  {  346,    0 }, /* (77) not_exists_opt ::= */
  {  348,   -2 }, /* (78) exists_opt ::= IF EXISTS */
  {  348,    0 }, /* (79) exists_opt ::= */
  {  347,    0 }, /* (80) db_options ::= */
  {  347,   -3 }, /* (81) db_options ::= db_options BUFFER NK_INTEGER */
  {  347,   -3 }, /* (82) db_options ::= db_options CACHEMODEL NK_STRING */
  {  347,   -3 }, /* (83) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  347,   -3 }, /* (84) db_options ::= db_options COMP NK_INTEGER */
  {  347,   -3 }, /* (85) db_options ::= db_options DURATION NK_INTEGER */
  {  347,   -3 }, /* (86) db_options ::= db_options DURATION NK_VARIABLE */
  {  347,   -3 }, /* (87) db_options ::= db_options MAXROWS NK_INTEGER */
  {  347,   -3 }, /* (88) db_options ::= db_options MINROWS NK_INTEGER */
  {  347,   -3 }, /* (89) db_options ::= db_options KEEP integer_list */
  {  347,   -3 }, /* (90) db_options ::= db_options KEEP variable_list */
  {  347,   -3 }, /* (91) db_options ::= db_options PAGES NK_INTEGER */
  {  347,   -3 }, /* (92) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  347,   -3 }, /* (93) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  347,   -3 }, /* (94) db_options ::= db_options PRECISION NK_STRING */
  {  347,   -3 }, /* (95) db_options ::= db_options REPLICA NK_INTEGER */
  {  347,   -3 }, /* (96) db_options ::= db_options VGROUPS NK_INTEGER */
  {  347,   -3 }, /* (97) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  347,   -3 }, /* (98) db_options ::= db_options RETENTIONS retention_list */
  {  347,   -3 }, /* (99) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  347,   -3 }, /* (100) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  347,   -3 }, /* (101) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  347,   -3 }, /* (102) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  347,   -4 }, /* (103) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  347,   -3 }, /* (104) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  347,   -4 }, /* (105) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  347,   -3 }, /* (106) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  347,   -3 }, /* (107) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  347,   -3 }, /* (108) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  347,   -3 }, /* (109) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  347,   -3 }, /* (110) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  349,   -1 }, /* (111) alter_db_options ::= alter_db_option */
  {  349,   -2 }, /* (112) alter_db_options ::= alter_db_options alter_db_option */
  {  356,   -2 }, /* (113) alter_db_option ::= BUFFER NK_INTEGER */
  {  356,   -2 }, /* (114) alter_db_option ::= CACHEMODEL NK_STRING */
  {  356,   -2 }, /* (115) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  356,   -2 }, /* (116) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  356,   -2 }, /* (117) alter_db_option ::= KEEP integer_list */
  {  356,   -2 }, /* (118) alter_db_option ::= KEEP variable_list */
  {  356,   -2 }, /* (119) alter_db_option ::= PAGES NK_INTEGER */
  {  356,   -2 }, /* (120) alter_db_option ::= REPLICA NK_INTEGER */
  {  356,   -2 }, /* (121) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  356,   -2 }, /* (122) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  356,   -2 }, /* (123) alter_db_option ::= MINROWS NK_INTEGER */
  {  353,   -1 }, /* (124) integer_list ::= NK_INTEGER */
  {  353,   -3 }, /* (125) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  354,   -1 }, /* (126) variable_list ::= NK_VARIABLE */
  {  354,   -3 }, /* (127) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  355,   -1 }, /* (128) retention_list ::= retention */
  {  355,   -3 }, /* (129) retention_list ::= retention_list NK_COMMA retention */
  {  357,   -3 }, /* (130) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  350,    0 }, /* (131) speed_opt ::= */
  {  350,   -2 }, /* (132) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  351,    0 }, /* (133) start_opt ::= */
  {  351,   -3 }, /* (134) start_opt ::= START WITH NK_INTEGER */
  {  351,   -3 }, /* (135) start_opt ::= START WITH NK_STRING */
  {  351,   -4 }, /* (136) start_opt ::= START WITH TIMESTAMP NK_STRING */
  {  352,    0 }, /* (137) end_opt ::= */
  {  352,   -3 }, /* (138) end_opt ::= END WITH NK_INTEGER */
  {  352,   -3 }, /* (139) end_opt ::= END WITH NK_STRING */
  {  352,   -4 }, /* (140) end_opt ::= END WITH TIMESTAMP NK_STRING */
  {  328,   -9 }, /* (141) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  328,   -3 }, /* (142) cmd ::= CREATE TABLE multi_create_clause */
  {  328,   -9 }, /* (143) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  328,   -3 }, /* (144) cmd ::= DROP TABLE multi_drop_clause */
  {  328,   -4 }, /* (145) cmd ::= DROP STABLE exists_opt full_table_name */
  {  328,   -3 }, /* (146) cmd ::= ALTER TABLE alter_table_clause */
  {  328,   -3 }, /* (147) cmd ::= ALTER STABLE alter_table_clause */
  {  365,   -2 }, /* (148) alter_table_clause ::= full_table_name alter_table_options */
  {  365,   -5 }, /* (149) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  365,   -4 }, /* (150) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  365,   -5 }, /* (151) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  365,   -5 }, /* (152) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  365,   -5 }, /* (153) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  365,   -4 }, /* (154) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  365,   -5 }, /* (155) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  365,   -5 }, /* (156) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  365,   -6 }, /* (157) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  362,   -1 }, /* (158) multi_create_clause ::= create_subtable_clause */
  {  362,   -2 }, /* (159) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  370,  -10 }, /* (160) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  364,   -1 }, /* (161) multi_drop_clause ::= drop_table_clause */
  {  364,   -3 }, /* (162) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
  {  373,   -2 }, /* (163) drop_table_clause ::= exists_opt full_table_name */
  {  371,    0 }, /* (164) specific_cols_opt ::= */
  {  371,   -3 }, /* (165) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  358,   -1 }, /* (166) full_table_name ::= table_name */
  {  358,   -3 }, /* (167) full_table_name ::= db_name NK_DOT table_name */
  {  359,   -1 }, /* (168) column_def_list ::= column_def */
  {  359,   -3 }, /* (169) column_def_list ::= column_def_list NK_COMMA column_def */
  {  375,   -2 }, /* (170) column_def ::= column_name type_name */
  {  368,   -1 }, /* (171) type_name ::= BOOL */
  {  368,   -1 }, /* (172) type_name ::= TINYINT */
  {  368,   -1 }, /* (173) type_name ::= SMALLINT */
  {  368,   -1 }, /* (174) type_name ::= INT */
  {  368,   -1 }, /* (175) type_name ::= INTEGER */
  {  368,   -1 }, /* (176) type_name ::= BIGINT */
  {  368,   -1 }, /* (177) type_name ::= FLOAT */
  {  368,   -1 }, /* (178) type_name ::= DOUBLE */
  {  368,   -4 }, /* (179) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  368,   -1 }, /* (180) type_name ::= TIMESTAMP */
  {  368,   -4 }, /* (181) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  368,   -2 }, /* (182) type_name ::= TINYINT UNSIGNED */
  {  368,   -2 }, /* (183) type_name ::= SMALLINT UNSIGNED */
  {  368,   -2 }, /* (184) type_name ::= INT UNSIGNED */
  {  368,   -2 }, /* (185) type_name ::= BIGINT UNSIGNED */
  {  368,   -1 }, /* (186) type_name ::= JSON */
  {  368,   -4 }, /* (187) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  368,   -1 }, /* (188) type_name ::= MEDIUMBLOB */
  {  368,   -1 }, /* (189) type_name ::= BLOB */
  {  368,   -4 }, /* (190) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  368,   -1 }, /* (191) type_name ::= DECIMAL */
  {  368,   -4 }, /* (192) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  368,   -6 }, /* (193) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  360,    0 }, /* (194) tags_def_opt ::= */
  {  360,   -1 }, /* (195) tags_def_opt ::= tags_def */
  {  363,   -4 }, /* (196) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  361,    0 }, /* (197) table_options ::= */
  {  361,   -3 }, /* (198) table_options ::= table_options COMMENT NK_STRING */
  {  361,   -3 }, /* (199) table_options ::= table_options MAX_DELAY duration_list */
  {  361,   -3 }, /* (200) table_options ::= table_options WATERMARK duration_list */
  {  361,   -5 }, /* (201) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  361,   -3 }, /* (202) table_options ::= table_options TTL NK_INTEGER */
  {  361,   -5 }, /* (203) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  361,   -3 }, /* (204) table_options ::= table_options DELETE_MARK duration_list */
  {  366,   -1 }, /* (205) alter_table_options ::= alter_table_option */
  {  366,   -2 }, /* (206) alter_table_options ::= alter_table_options alter_table_option */
  {  378,   -2 }, /* (207) alter_table_option ::= COMMENT NK_STRING */
  {  378,   -2 }, /* (208) alter_table_option ::= TTL NK_INTEGER */
  {  376,   -1 }, /* (209) duration_list ::= duration_literal */
  {  376,   -3 }, /* (210) duration_list ::= duration_list NK_COMMA duration_literal */
  {  377,   -1 }, /* (211) rollup_func_list ::= rollup_func_name */
  {  377,   -3 }, /* (212) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  380,   -1 }, /* (213) rollup_func_name ::= function_name */
  {  380,   -1 }, /* (214) rollup_func_name ::= FIRST */
  {  380,   -1 }, /* (215) rollup_func_name ::= LAST */
  {  374,   -1 }, /* (216) col_name_list ::= col_name */
  {  374,   -3 }, /* (217) col_name_list ::= col_name_list NK_COMMA col_name */
  {  382,   -1 }, /* (218) col_name ::= column_name */
  {  328,   -2 }, /* (219) cmd ::= SHOW DNODES */
  {  328,   -2 }, /* (220) cmd ::= SHOW USERS */
  {  328,   -3 }, /* (221) cmd ::= SHOW USER PRIVILEGES */
  {  328,   -2 }, /* (222) cmd ::= SHOW DATABASES */
  {  328,   -4 }, /* (223) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  328,   -4 }, /* (224) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  328,   -3 }, /* (225) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  328,   -2 }, /* (226) cmd ::= SHOW MNODES */
  {  328,   -2 }, /* (227) cmd ::= SHOW QNODES */
  {  328,   -2 }, /* (228) cmd ::= SHOW FUNCTIONS */
  {  328,   -5 }, /* (229) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  328,   -2 }, /* (230) cmd ::= SHOW STREAMS */
  {  328,   -2 }, /* (231) cmd ::= SHOW ACCOUNTS */
  {  328,   -2 }, /* (232) cmd ::= SHOW APPS */
  {  328,   -2 }, /* (233) cmd ::= SHOW CONNECTIONS */
  {  328,   -2 }, /* (234) cmd ::= SHOW LICENCES */
  {  328,   -2 }, /* (235) cmd ::= SHOW GRANTS */
  {  328,   -4 }, /* (236) cmd ::= SHOW CREATE DATABASE db_name */
  {  328,   -4 }, /* (237) cmd ::= SHOW CREATE TABLE full_table_name */
  {  328,   -4 }, /* (238) cmd ::= SHOW CREATE STABLE full_table_name */
  {  328,   -2 }, /* (239) cmd ::= SHOW QUERIES */
  {  328,   -2 }, /* (240) cmd ::= SHOW SCORES */
  {  328,   -2 }, /* (241) cmd ::= SHOW TOPICS */
  {  328,   -2 }, /* (242) cmd ::= SHOW VARIABLES */
  {  328,   -3 }, /* (243) cmd ::= SHOW CLUSTER VARIABLES */
  {  328,   -3 }, /* (244) cmd ::= SHOW LOCAL VARIABLES */
  {  328,   -5 }, /* (245) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  328,   -2 }, /* (246) cmd ::= SHOW BNODES */
  {  328,   -2 }, /* (247) cmd ::= SHOW SNODES */
  {  328,   -2 }, /* (248) cmd ::= SHOW CLUSTER */
  {  328,   -2 }, /* (249) cmd ::= SHOW TRANSACTIONS */
  {  328,   -4 }, /* (250) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  328,   -2 }, /* (251) cmd ::= SHOW CONSUMERS */
  {  328,   -2 }, /* (252) cmd ::= SHOW SUBSCRIPTIONS */
  {  328,   -5 }, /* (253) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  328,   -7 }, /* (254) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  328,   -3 }, /* (255) cmd ::= SHOW VNODES NK_INTEGER */
  {  328,   -3 }, /* (256) cmd ::= SHOW VNODES NK_STRING */
  {  328,   -3 }, /* (257) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  328,   -3 }, /* (258) cmd ::= SHOW CLUSTER ALIVE */
  {  383,    0 }, /* (259) db_name_cond_opt ::= */
  {  383,   -2 }, /* (260) db_name_cond_opt ::= db_name NK_DOT */
  {  384,    0 }, /* (261) like_pattern_opt ::= */
  {  384,   -2 }, /* (262) like_pattern_opt ::= LIKE NK_STRING */
  {  385,   -1 }, /* (263) table_name_cond ::= table_name */
  {  386,    0 }, /* (264) from_db_opt ::= */
  {  386,   -2 }, /* (265) from_db_opt ::= FROM db_name */
  {  387,    0 }, /* (266) tag_list_opt ::= */
  {  387,   -1 }, /* (267) tag_list_opt ::= tag_item */
  {  387,   -3 }, /* (268) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  388,   -1 }, /* (269) tag_item ::= TBNAME */
  {  388,   -1 }, /* (270) tag_item ::= QTAGS */
  {  388,   -1 }, /* (271) tag_item ::= column_name */
  {  388,   -2 }, /* (272) tag_item ::= column_name column_alias */
  {  388,   -3 }, /* (273) tag_item ::= column_name AS column_alias */
  {  328,   -8 }, /* (274) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  328,   -9 }, /* (275) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  328,   -4 }, /* (276) cmd ::= DROP INDEX exists_opt full_index_name */
  {  390,   -1 }, /* (277) full_index_name ::= index_name */
  {  390,   -3 }, /* (278) full_index_name ::= db_name NK_DOT index_name */
  {  391,  -10 }, /* (279) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  391,  -12 }, /* (280) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  393,   -1 }, /* (281) func_list ::= func */
  {  393,   -3 }, /* (282) func_list ::= func_list NK_COMMA func */
  {  396,   -4 }, /* (283) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  397,   -1 }, /* (284) sma_func_name ::= function_name */
  {  397,   -1 }, /* (285) sma_func_name ::= COUNT */
  {  397,   -1 }, /* (286) sma_func_name ::= FIRST */
  {  397,   -1 }, /* (287) sma_func_name ::= LAST */
  {  397,   -1 }, /* (288) sma_func_name ::= LAST_ROW */
  {  395,    0 }, /* (289) sma_stream_opt ::= */
  {  395,   -3 }, /* (290) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  395,   -3 }, /* (291) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  395,   -3 }, /* (292) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  328,   -6 }, /* (293) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  328,   -7 }, /* (294) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  328,   -9 }, /* (295) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  328,   -7 }, /* (296) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  328,   -9 }, /* (297) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  328,   -4 }, /* (298) cmd ::= DROP TOPIC exists_opt topic_name */
  {  328,   -7 }, /* (299) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  328,   -2 }, /* (300) cmd ::= DESC full_table_name */
  {  328,   -2 }, /* (301) cmd ::= DESCRIBE full_table_name */
  {  328,   -3 }, /* (302) cmd ::= RESET QUERY CACHE */
  {  328,   -4 }, /* (303) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  328,   -4 }, /* (304) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
  {  400,    0 }, /* (305) analyze_opt ::= */
  {  400,   -1 }, /* (306) analyze_opt ::= ANALYZE */
  {  401,    0 }, /* (307) explain_options ::= */
  {  401,   -3 }, /* (308) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  401,   -3 }, /* (309) explain_options ::= explain_options RATIO NK_FLOAT */
  {  328,  -10 }, /* (310) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  328,   -4 }, /* (311) cmd ::= DROP FUNCTION exists_opt function_name */
  {  403,    0 }, /* (312) agg_func_opt ::= */
  {  403,   -1 }, /* (313) agg_func_opt ::= AGGREGATE */
  {  404,    0 }, /* (314) bufsize_opt ::= */
  {  404,   -2 }, /* (315) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  328,  -12 }, /* (316) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  328,   -4 }, /* (317) cmd ::= DROP STREAM exists_opt stream_name */
  {  407,    0 }, /* (318) col_list_opt ::= */
  {  407,   -3 }, /* (319) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  408,    0 }, /* (320) tag_def_or_ref_opt ::= */
  {  408,   -1 }, /* (321) tag_def_or_ref_opt ::= tags_def */
  {  408,   -4 }, /* (322) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  406,    0 }, /* (323) stream_options ::= */
  {  406,   -3 }, /* (324) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  406,   -3 }, /* (325) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  406,   -4 }, /* (326) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  406,   -3 }, /* (327) stream_options ::= stream_options WATERMARK duration_literal */
  {  406,   -4 }, /* (328) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  406,   -3 }, /* (329) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  406,   -3 }, /* (330) stream_options ::= stream_options DELETE_MARK duration_literal */
  {  406,   -4 }, /* (331) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
  {  409,    0 }, /* (332) subtable_opt ::= */
  {  409,   -4 }, /* (333) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  328,   -3 }, /* (334) cmd ::= KILL CONNECTION NK_INTEGER */
  {  328,   -3 }, /* (335) cmd ::= KILL QUERY NK_STRING */
  {  328,   -3 }, /* (336) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  328,   -2 }, /* (337) cmd ::= BALANCE VGROUP */
  {  328,   -4 }, /* (338) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  328,   -4 }, /* (339) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  328,   -3 }, /* (340) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  411,   -2 }, /* (341) dnode_list ::= DNODE NK_INTEGER */
  {  411,   -3 }, /* (342) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  328,   -4 }, /* (343) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  328,   -1 }, /* (344) cmd ::= query_or_subquery */
  {  328,   -1 }, /* (345) cmd ::= insert_query */
  {  402,   -7 }, /* (346) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  402,   -4 }, /* (347) insert_query ::= INSERT INTO full_table_name query_or_subquery */
  {  331,   -1 }, /* (348) literal ::= NK_INTEGER */
  {  331,   -1 }, /* (349) literal ::= NK_FLOAT */
  {  331,   -1 }, /* (350) literal ::= NK_STRING */
  {  331,   -1 }, /* (351) literal ::= NK_BOOL */
  {  331,   -2 }, /* (352) literal ::= TIMESTAMP NK_STRING */
  {  331,   -1 }, /* (353) literal ::= duration_literal */
  {  331,   -1 }, /* (354) literal ::= NULL */
  {  331,   -1 }, /* (355) literal ::= NK_QUESTION */
  {  379,   -1 }, /* (356) duration_literal ::= NK_VARIABLE */
  {  413,   -1 }, /* (357) signed ::= NK_INTEGER */
  {  413,   -2 }, /* (358) signed ::= NK_PLUS NK_INTEGER */
  {  413,   -2 }, /* (359) signed ::= NK_MINUS NK_INTEGER */
  {  413,   -1 }, /* (360) signed ::= NK_FLOAT */
  {  413,   -2 }, /* (361) signed ::= NK_PLUS NK_FLOAT */
  {  413,   -2 }, /* (362) signed ::= NK_MINUS NK_FLOAT */
  {  369,   -1 }, /* (363) signed_literal ::= signed */
  {  369,   -1 }, /* (364) signed_literal ::= NK_STRING */
  {  369,   -1 }, /* (365) signed_literal ::= NK_BOOL */
  {  369,   -2 }, /* (366) signed_literal ::= TIMESTAMP NK_STRING */
  {  369,   -1 }, /* (367) signed_literal ::= duration_literal */
  {  369,   -1 }, /* (368) signed_literal ::= NULL */
  {  369,   -1 }, /* (369) signed_literal ::= literal_func */
  {  369,   -1 }, /* (370) signed_literal ::= NK_QUESTION */
  {  415,   -1 }, /* (371) literal_list ::= signed_literal */
  {  415,   -3 }, /* (372) literal_list ::= literal_list NK_COMMA signed_literal */
  {  340,   -1 }, /* (373) db_name ::= NK_ID */
  {  341,   -1 }, /* (374) table_name ::= NK_ID */
  {  367,   -1 }, /* (375) column_name ::= NK_ID */
  {  381,   -1 }, /* (376) function_name ::= NK_ID */
  {  416,   -1 }, /* (377) table_alias ::= NK_ID */
  {  389,   -1 }, /* (378) column_alias ::= NK_ID */
  {  333,   -1 }, /* (379) user_name ::= NK_ID */
  {  342,   -1 }, /* (380) topic_name ::= NK_ID */
  {  405,   -1 }, /* (381) stream_name ::= NK_ID */
  {  399,   -1 }, /* (382) cgroup_name ::= NK_ID */
  {  392,   -1 }, /* (383) index_name ::= NK_ID */
  {  417,   -1 }, /* (384) expr_or_subquery ::= expression */
  {  410,   -1 }, /* (385) expression ::= literal */
  {  410,   -1 }, /* (386) expression ::= pseudo_column */
  {  410,   -1 }, /* (387) expression ::= column_reference */
  {  410,   -1 }, /* (388) expression ::= function_expression */
  {  410,   -1 }, /* (389) expression ::= case_when_expression */
  {  410,   -3 }, /* (390) expression ::= NK_LP expression NK_RP */
  {  410,   -2 }, /* (391) expression ::= NK_PLUS expr_or_subquery */
  {  410,   -2 }, /* (392) expression ::= NK_MINUS expr_or_subquery */
  {  410,   -3 }, /* (393) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  410,   -3 }, /* (394) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  410,   -3 }, /* (395) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  410,   -3 }, /* (396) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  410,   -3 }, /* (397) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  410,   -3 }, /* (398) expression ::= column_reference NK_ARROW NK_STRING */
  {  410,   -3 }, /* (399) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  410,   -3 }, /* (400) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  372,   -1 }, /* (401) expression_list ::= expr_or_subquery */
  {  372,   -3 }, /* (402) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  419,   -1 }, /* (403) column_reference ::= column_name */
  {  419,   -3 }, /* (404) column_reference ::= table_name NK_DOT column_name */
  {  418,   -1 }, /* (405) pseudo_column ::= ROWTS */
  {  418,   -1 }, /* (406) pseudo_column ::= TBNAME */
  {  418,   -3 }, /* (407) pseudo_column ::= table_name NK_DOT TBNAME */
  {  418,   -1 }, /* (408) pseudo_column ::= QSTART */
  {  418,   -1 }, /* (409) pseudo_column ::= QEND */
  {  418,   -1 }, /* (410) pseudo_column ::= QDURATION */
  {  418,   -1 }, /* (411) pseudo_column ::= WSTART */
  {  418,   -1 }, /* (412) pseudo_column ::= WEND */
  {  418,   -1 }, /* (413) pseudo_column ::= WDURATION */
  {  418,   -1 }, /* (414) pseudo_column ::= IROWTS */
  {  418,   -1 }, /* (415) pseudo_column ::= ISFILLED */
  {  418,   -1 }, /* (416) pseudo_column ::= QTAGS */
  {  420,   -4 }, /* (417) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  420,   -4 }, /* (418) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  420,   -6 }, /* (419) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  420,   -1 }, /* (420) function_expression ::= literal_func */
  {  414,   -3 }, /* (421) literal_func ::= noarg_func NK_LP NK_RP */
  {  414,   -1 }, /* (422) literal_func ::= NOW */
  {  424,   -1 }, /* (423) noarg_func ::= NOW */
  {  424,   -1 }, /* (424) noarg_func ::= TODAY */
  {  424,   -1 }, /* (425) noarg_func ::= TIMEZONE */
  {  424,   -1 }, /* (426) noarg_func ::= DATABASE */
  {  424,   -1 }, /* (427) noarg_func ::= CLIENT_VERSION */
  {  424,   -1 }, /* (428) noarg_func ::= SERVER_VERSION */
  {  424,   -1 }, /* (429) noarg_func ::= SERVER_STATUS */
  {  424,   -1 }, /* (430) noarg_func ::= CURRENT_USER */
  {  424,   -1 }, /* (431) noarg_func ::= USER */
  {  422,   -1 }, /* (432) star_func ::= COUNT */
  {  422,   -1 }, /* (433) star_func ::= FIRST */
  {  422,   -1 }, /* (434) star_func ::= LAST */
  {  422,   -1 }, /* (435) star_func ::= LAST_ROW */
  {  423,   -1 }, /* (436) star_func_para_list ::= NK_STAR */
  {  423,   -1 }, /* (437) star_func_para_list ::= other_para_list */
  {  425,   -1 }, /* (438) other_para_list ::= star_func_para */
  {  425,   -3 }, /* (439) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  426,   -1 }, /* (440) star_func_para ::= expr_or_subquery */
  {  426,   -3 }, /* (441) star_func_para ::= table_name NK_DOT NK_STAR */
  {  421,   -4 }, /* (442) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  421,   -5 }, /* (443) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  427,   -1 }, /* (444) when_then_list ::= when_then_expr */
  {  427,   -2 }, /* (445) when_then_list ::= when_then_list when_then_expr */
  {  430,   -4 }, /* (446) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  428,    0 }, /* (447) case_when_else_opt ::= */
  {  428,   -2 }, /* (448) case_when_else_opt ::= ELSE common_expression */
  {  431,   -3 }, /* (449) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  431,   -5 }, /* (450) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  431,   -6 }, /* (451) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  431,   -3 }, /* (452) predicate ::= expr_or_subquery IS NULL */
  {  431,   -4 }, /* (453) predicate ::= expr_or_subquery IS NOT NULL */
  {  431,   -3 }, /* (454) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  432,   -1 }, /* (455) compare_op ::= NK_LT */
  {  432,   -1 }, /* (456) compare_op ::= NK_GT */
  {  432,   -1 }, /* (457) compare_op ::= NK_LE */
  {  432,   -1 }, /* (458) compare_op ::= NK_GE */
  {  432,   -1 }, /* (459) compare_op ::= NK_NE */
  {  432,   -1 }, /* (460) compare_op ::= NK_EQ */
  {  432,   -1 }, /* (461) compare_op ::= LIKE */
  {  432,   -2 }, /* (462) compare_op ::= NOT LIKE */
  {  432,   -1 }, /* (463) compare_op ::= MATCH */
  {  432,   -1 }, /* (464) compare_op ::= NMATCH */
  {  432,   -1 }, /* (465) compare_op ::= CONTAINS */
  {  433,   -1 }, /* (466) in_op ::= IN */
  {  433,   -2 }, /* (467) in_op ::= NOT IN */
  {  434,   -3 }, /* (468) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  435,   -1 }, /* (469) boolean_value_expression ::= boolean_primary */
  {  435,   -2 }, /* (470) boolean_value_expression ::= NOT boolean_primary */
  {  435,   -3 }, /* (471) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  435,   -3 }, /* (472) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  436,   -1 }, /* (473) boolean_primary ::= predicate */
  {  436,   -3 }, /* (474) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  429,   -1 }, /* (475) common_expression ::= expr_or_subquery */
  {  429,   -1 }, /* (476) common_expression ::= boolean_value_expression */
  {  437,    0 }, /* (477) from_clause_opt ::= */
  {  437,   -2 }, /* (478) from_clause_opt ::= FROM table_reference_list */
  {  438,   -1 }, /* (479) table_reference_list ::= table_reference */
  {  438,   -3 }, /* (480) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  439,   -1 }, /* (481) table_reference ::= table_primary */
  {  439,   -1 }, /* (482) table_reference ::= joined_table */
  {  440,   -2 }, /* (483) table_primary ::= table_name alias_opt */
  {  440,   -4 }, /* (484) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  440,   -2 }, /* (485) table_primary ::= subquery alias_opt */
  {  440,   -1 }, /* (486) table_primary ::= parenthesized_joined_table */
  {  442,    0 }, /* (487) alias_opt ::= */
  {  442,   -1 }, /* (488) alias_opt ::= table_alias */
  {  442,   -2 }, /* (489) alias_opt ::= AS table_alias */
  {  444,   -3 }, /* (490) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  444,   -3 }, /* (491) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  441,   -6 }, /* (492) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  445,    0 }, /* (493) join_type ::= */
  {  445,   -1 }, /* (494) join_type ::= INNER */
  {  446,  -12 }, /* (495) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  447,    0 }, /* (496) set_quantifier_opt ::= */
  {  447,   -1 }, /* (497) set_quantifier_opt ::= DISTINCT */
  {  447,   -1 }, /* (498) set_quantifier_opt ::= ALL */
  {  448,   -1 }, /* (499) select_list ::= select_item */
  {  448,   -3 }, /* (500) select_list ::= select_list NK_COMMA select_item */
  {  456,   -1 }, /* (501) select_item ::= NK_STAR */
  {  456,   -1 }, /* (502) select_item ::= common_expression */
  {  456,   -2 }, /* (503) select_item ::= common_expression column_alias */
  {  456,   -3 }, /* (504) select_item ::= common_expression AS column_alias */
  {  456,   -3 }, /* (505) select_item ::= table_name NK_DOT NK_STAR */
  {  412,    0 }, /* (506) where_clause_opt ::= */
  {  412,   -2 }, /* (507) where_clause_opt ::= WHERE search_condition */
  {  449,    0 }, /* (508) partition_by_clause_opt ::= */
  {  449,   -3 }, /* (509) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  457,   -1 }, /* (510) partition_list ::= partition_item */
  {  457,   -3 }, /* (511) partition_list ::= partition_list NK_COMMA partition_item */
  {  458,   -1 }, /* (512) partition_item ::= expr_or_subquery */
  {  458,   -2 }, /* (513) partition_item ::= expr_or_subquery column_alias */
  {  458,   -3 }, /* (514) partition_item ::= expr_or_subquery AS column_alias */
  {  453,    0 }, /* (515) twindow_clause_opt ::= */
  {  453,   -6 }, /* (516) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  453,   -4 }, /* (517) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  453,   -6 }, /* (518) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  453,   -8 }, /* (519) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  453,   -7 }, /* (520) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  394,    0 }, /* (521) sliding_opt ::= */
  {  394,   -4 }, /* (522) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  452,    0 }, /* (523) fill_opt ::= */
  {  452,   -4 }, /* (524) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  452,   -6 }, /* (525) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  452,   -6 }, /* (526) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
  {  459,   -1 }, /* (527) fill_mode ::= NONE */
  {  459,   -1 }, /* (528) fill_mode ::= PREV */
  {  459,   -1 }, /* (529) fill_mode ::= NULL */
  {  459,   -1 }, /* (530) fill_mode ::= NULL_F */
  {  459,   -1 }, /* (531) fill_mode ::= LINEAR */
  {  459,   -1 }, /* (532) fill_mode ::= NEXT */
  {  454,    0 }, /* (533) group_by_clause_opt ::= */
  {  454,   -3 }, /* (534) group_by_clause_opt ::= GROUP BY group_by_list */
  {  460,   -1 }, /* (535) group_by_list ::= expr_or_subquery */
  {  460,   -3 }, /* (536) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  455,    0 }, /* (537) having_clause_opt ::= */
  {  455,   -2 }, /* (538) having_clause_opt ::= HAVING search_condition */
  {  450,    0 }, /* (539) range_opt ::= */
  {  450,   -6 }, /* (540) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  451,    0 }, /* (541) every_opt ::= */
  {  451,   -4 }, /* (542) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  461,   -4 }, /* (543) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  462,   -1 }, /* (544) query_simple ::= query_specification */
  {  462,   -1 }, /* (545) query_simple ::= union_query_expression */
  {  466,   -4 }, /* (546) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  466,   -3 }, /* (547) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  467,   -1 }, /* (548) query_simple_or_subquery ::= query_simple */
  {  467,   -1 }, /* (549) query_simple_or_subquery ::= subquery */
  {  398,   -1 }, /* (550) query_or_subquery ::= query_expression */
  {  398,   -1 }, /* (551) query_or_subquery ::= subquery */
  {  463,    0 }, /* (552) order_by_clause_opt ::= */
  {  463,   -3 }, /* (553) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  464,    0 }, /* (554) slimit_clause_opt ::= */
  {  464,   -2 }, /* (555) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  464,   -4 }, /* (556) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  464,   -4 }, /* (557) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  465,    0 }, /* (558) limit_clause_opt ::= */
  {  465,   -2 }, /* (559) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  465,   -4 }, /* (560) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  465,   -4 }, /* (561) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  443,   -3 }, /* (562) subquery ::= NK_LP query_expression NK_RP */
  {  443,   -3 }, /* (563) subquery ::= NK_LP subquery NK_RP */
  {  343,   -1 }, /* (564) search_condition ::= common_expression */
  {  468,   -1 }, /* (565) sort_specification_list ::= sort_specification */
  {  468,   -3 }, /* (566) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  469,   -3 }, /* (567) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  470,    0 }, /* (568) ordering_specification_opt ::= */
  {  470,   -1 }, /* (569) ordering_specification_opt ::= ASC */
  {  470,   -1 }, /* (570) ordering_specification_opt ::= DESC */
  {  471,    0 }, /* (571) null_ordering_opt ::= */
  {  471,   -2 }, /* (572) null_ordering_opt ::= NULLS FIRST */
  {  471,   -2 }, /* (573) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,329,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,330,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,329,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,331,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,332,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,330,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,332,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,331,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy97, &yymsp[-1].minor.yy0, yymsp[0].minor.yy519); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy97, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy97, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy97, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy97); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy519 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy519 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-5].minor.yy93, &yymsp[-3].minor.yy569, &yymsp[0].minor.yy97, yymsp[-2].minor.yy792); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-5].minor.yy93, &yymsp[-3].minor.yy569, &yymsp[0].minor.yy97, yymsp[-2].minor.yy792); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy93 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy93 = yymsp[0].minor.yy93; }
  yymsp[0].minor.yy93 = yylhsminor.yy93;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy93 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy93 = yymsp[-2].minor.yy93 | yymsp[0].minor.yy93; }
  yymsp[-2].minor.yy93 = yylhsminor.yy93;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy93 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy93 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy569.first = yymsp[-2].minor.yy0; yylhsminor.yy569.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy569 = yylhsminor.yy569;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy569.first = yymsp[-2].minor.yy97; yylhsminor.yy569.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy569 = yylhsminor.yy569;
        break;
      case 42: /* priv_level ::= db_name NK_DOT table_name */
{ yylhsminor.yy569.first = yymsp[-2].minor.yy97; yylhsminor.yy569.second = yymsp[0].minor.yy97; }
  yymsp[-2].minor.yy569 = yylhsminor.yy569;
        break;
      case 43: /* priv_level ::= topic_name */
{ yylhsminor.yy569.first = yymsp[0].minor.yy97; yylhsminor.yy569.second = nil_token; }
  yymsp[0].minor.yy569 = yylhsminor.yy569;
        break;
      case 44: /* with_opt ::= */
      case 133: /* start_opt ::= */ yytestcase(yyruleno==133);
      case 137: /* end_opt ::= */ yytestcase(yyruleno==137);
      case 261: /* like_pattern_opt ::= */ yytestcase(yyruleno==261);
      case 332: /* subtable_opt ::= */ yytestcase(yyruleno==332);
      case 447: /* case_when_else_opt ::= */ yytestcase(yyruleno==447);
      case 477: /* from_clause_opt ::= */ yytestcase(yyruleno==477);
      case 506: /* where_clause_opt ::= */ yytestcase(yyruleno==506);
      case 515: /* twindow_clause_opt ::= */ yytestcase(yyruleno==515);
      case 521: /* sliding_opt ::= */ yytestcase(yyruleno==521);
      case 523: /* fill_opt ::= */ yytestcase(yyruleno==523);
      case 537: /* having_clause_opt ::= */ yytestcase(yyruleno==537);
      case 539: /* range_opt ::= */ yytestcase(yyruleno==539);
      case 541: /* every_opt ::= */ yytestcase(yyruleno==541);
      case 554: /* slimit_clause_opt ::= */ yytestcase(yyruleno==554);
      case 558: /* limit_clause_opt ::= */ yytestcase(yyruleno==558);
{ yymsp[1].minor.yy792 = NULL; }
        break;
      case 45: /* with_opt ::= WITH search_condition */
      case 478: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==478);
      case 507: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==507);
      case 538: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==538);
{ yymsp[-1].minor.yy792 = yymsp[0].minor.yy792; }
        break;
      case 46: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy97, NULL); }
        break;
      case 47: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy97, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy89); }
        break;
      case 49: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy97, yymsp[0].minor.yy89); }
        break;
      case 50: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 51: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 52: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* dnode_endpoint ::= NK_STRING */
      case 55: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==55);
      case 56: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==56);
      case 285: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==285);
      case 286: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==286);
      case 287: /* sma_func_name ::= LAST */ yytestcase(yyruleno==287);
      case 288: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==288);
      case 373: /* db_name ::= NK_ID */ yytestcase(yyruleno==373);
      case 374: /* table_name ::= NK_ID */ yytestcase(yyruleno==374);
      case 375: /* column_name ::= NK_ID */ yytestcase(yyruleno==375);
      case 376: /* function_name ::= NK_ID */ yytestcase(yyruleno==376);
      case 377: /* table_alias ::= NK_ID */ yytestcase(yyruleno==377);
      case 378: /* column_alias ::= NK_ID */ yytestcase(yyruleno==378);
      case 379: /* user_name ::= NK_ID */ yytestcase(yyruleno==379);
      case 380: /* topic_name ::= NK_ID */ yytestcase(yyruleno==380);
      case 381: /* stream_name ::= NK_ID */ yytestcase(yyruleno==381);
      case 382: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==382);
      case 383: /* index_name ::= NK_ID */ yytestcase(yyruleno==383);
      case 423: /* noarg_func ::= NOW */ yytestcase(yyruleno==423);
      case 424: /* noarg_func ::= TODAY */ yytestcase(yyruleno==424);
      case 425: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==425);
      case 426: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==426);
      case 427: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==427);
      case 428: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==428);
      case 429: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==429);
      case 430: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==430);
      case 431: /* noarg_func ::= USER */ yytestcase(yyruleno==431);
      case 432: /* star_func ::= COUNT */ yytestcase(yyruleno==432);
      case 433: /* star_func ::= FIRST */ yytestcase(yyruleno==433);
      case 434: /* star_func ::= LAST */ yytestcase(yyruleno==434);
      case 435: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==435);
{ yylhsminor.yy97 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy97 = yylhsminor.yy97;
        break;
      case 57: /* force_opt ::= */
      case 77: /* not_exists_opt ::= */ yytestcase(yyruleno==77);
      case 79: /* exists_opt ::= */ yytestcase(yyruleno==79);
      case 305: /* analyze_opt ::= */ yytestcase(yyruleno==305);
      case 312: /* agg_func_opt ::= */ yytestcase(yyruleno==312);
      case 496: /* set_quantifier_opt ::= */ yytestcase(yyruleno==496);
{ yymsp[1].minor.yy89 = false; }
        break;
      case 58: /* force_opt ::= FORCE */
      case 306: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==306);
      case 313: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==313);
      case 497: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==497);
{ yymsp[0].minor.yy89 = true; }
        break;
      case 59: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 60: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 67: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 68: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 69: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy89, &yymsp[-1].minor.yy97, yymsp[0].minor.yy792); }
        break;
      case 70: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy97); }
        break;
      case 71: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy97); }
        break;
      case 72: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy97, yymsp[0].minor.yy792); }
        break;
      case 73: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy97); }
        break;
      case 74: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy97, yymsp[0].minor.yy20); }
        break;
      case 75: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy97, yymsp[-1].minor.yy792, yymsp[0].minor.yy792); }
        break;
      case 76: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy89 = true; }
        break;
      case 78: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy89 = true; }
        break;
      case 80: /* db_options ::= */
{ yymsp[1].minor.yy792 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 81: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 82: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 83: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 84: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 85: /* db_options ::= db_options DURATION NK_INTEGER */
      case 86: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==86);
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 87: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 88: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 89: /* db_options ::= db_options KEEP integer_list */
      case 90: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==90);
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_KEEP, yymsp[0].minor.yy520); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 91: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 92: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 93: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 94: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 95: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 96: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 97: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 98: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_RETENTIONS, yymsp[0].minor.yy520); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 99: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 100: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 101: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 103: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-3].minor.yy792, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 104: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 105: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-3].minor.yy792, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 106: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 107: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 108: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 109: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 110: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 111: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy792 = createAlterDatabaseOptions(pCxt); yylhsminor.yy792 = setAlterDatabaseOption(pCxt, yylhsminor.yy792, &yymsp[0].minor.yy285); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 112: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy792 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy792, &yymsp[0].minor.yy285); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 113: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy285.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy285.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 115: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy285.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy285.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= KEEP integer_list */
      case 118: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==118);
{ yymsp[-1].minor.yy285.type = DB_OPTION_KEEP; yymsp[-1].minor.yy285.pList = yymsp[0].minor.yy520; }
        break;
      case 119: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy285.type = DB_OPTION_PAGES; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy285.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 121: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy285.type = DB_OPTION_WAL; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 122: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy285.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 123: /* alter_db_option ::= MINROWS NK_INTEGER */
{ yymsp[-1].minor.yy285.type = DB_OPTION_MINROWS; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 124: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy520 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 125: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 342: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==342);
{ yylhsminor.yy520 = addNodeToList(pCxt, yymsp[-2].minor.yy520, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 126: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy520 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 127: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy520 = addNodeToList(pCxt, yymsp[-2].minor.yy520, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 128: /* retention_list ::= retention */
      case 158: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==158);
      case 161: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==161);
      case 168: /* column_def_list ::= column_def */ yytestcase(yyruleno==168);
      case 211: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==211);
      case 216: /* col_name_list ::= col_name */ yytestcase(yyruleno==216);
      case 267: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==267);
      case 281: /* func_list ::= func */ yytestcase(yyruleno==281);
      case 371: /* literal_list ::= signed_literal */ yytestcase(yyruleno==371);
      case 438: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==438);
      case 444: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==444);
      case 499: /* select_list ::= select_item */ yytestcase(yyruleno==499);
      case 510: /* partition_list ::= partition_item */ yytestcase(yyruleno==510);
      case 565: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==565);
{ yylhsminor.yy520 = createNodeList(pCxt, yymsp[0].minor.yy792); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 129: /* retention_list ::= retention_list NK_COMMA retention */
      case 162: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==162);
      case 169: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==169);
      case 212: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==212);
      case 217: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==217);
      case 268: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==268);
      case 282: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==282);
      case 372: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==372);
      case 439: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==439);
      case 500: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==500);
      case 511: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==511);
      case 566: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==566);
{ yylhsminor.yy520 = addNodeToList(pCxt, yymsp[-2].minor.yy520, yymsp[0].minor.yy792); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 130: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy792 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 131: /* speed_opt ::= */
      case 314: /* bufsize_opt ::= */ yytestcase(yyruleno==314);
{ yymsp[1].minor.yy20 = 0; }
        break;
      case 132: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 315: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==315);
{ yymsp[-1].minor.yy20 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 134: /* start_opt ::= START WITH NK_INTEGER */
      case 138: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==138);
{ yymsp[-2].minor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 135: /* start_opt ::= START WITH NK_STRING */
      case 139: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==139);
{ yymsp[-2].minor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 136: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 140: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==140);
{ yymsp[-3].minor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 141: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 143: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==143);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy89, yymsp[-5].minor.yy792, yymsp[-3].minor.yy520, yymsp[-1].minor.yy520, yymsp[0].minor.yy792); }
        break;
      case 142: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy520); }
        break;
      case 144: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy520); }
        break;
      case 145: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy89, yymsp[0].minor.yy792); }
        break;
      case 146: /* cmd ::= ALTER TABLE alter_table_clause */
      case 344: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==344);
      case 345: /* cmd ::= insert_query */ yytestcase(yyruleno==345);
{ pCxt->pRootNode = yymsp[0].minor.yy792; }
        break;
      case 147: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy792); }
        break;
      case 148: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy792 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy792, yymsp[0].minor.yy792); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 149: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy792 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy792, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy97, yymsp[0].minor.yy848); }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 150: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy792 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy792, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy97); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 151: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy792 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy792, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy97, yymsp[0].minor.yy848); }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 152: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy792 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy792, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy97, &yymsp[0].minor.yy97); }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 153: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy792 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy792, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy97, yymsp[0].minor.yy848); }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 154: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy792 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy792, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy97); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 155: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy792 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy792, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy97, yymsp[0].minor.yy848); }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 156: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy792 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy792, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy97, &yymsp[0].minor.yy97); }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 157: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy792 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy792, &yymsp[-2].minor.yy97, yymsp[0].minor.yy792); }
  yymsp[-5].minor.yy792 = yylhsminor.yy792;
        break;
      case 159: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 445: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==445);
{ yylhsminor.yy520 = addNodeToList(pCxt, yymsp[-1].minor.yy520, yymsp[0].minor.yy792); }
  yymsp[-1].minor.yy520 = yylhsminor.yy520;
        break;
      case 160: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy792 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy89, yymsp[-8].minor.yy792, yymsp[-6].minor.yy792, yymsp[-5].minor.yy520, yymsp[-2].minor.yy520, yymsp[0].minor.yy792); }
  yymsp[-9].minor.yy792 = yylhsminor.yy792;
        break;
      case 163: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy792 = createDropTableClause(pCxt, yymsp[-1].minor.yy89, yymsp[0].minor.yy792); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 164: /* specific_cols_opt ::= */
      case 194: /* tags_def_opt ::= */ yytestcase(yyruleno==194);
      case 266: /* tag_list_opt ::= */ yytestcase(yyruleno==266);
      case 318: /* col_list_opt ::= */ yytestcase(yyruleno==318);
      case 320: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==320);
      case 508: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==508);
      case 533: /* group_by_clause_opt ::= */ yytestcase(yyruleno==533);
      case 552: /* order_by_clause_opt ::= */ yytestcase(yyruleno==552);
{ yymsp[1].minor.yy520 = NULL; }
        break;
      case 165: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 319: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==319);
{ yymsp[-2].minor.yy520 = yymsp[-1].minor.yy520; }
        break;
      case 166: /* full_table_name ::= table_name */
{ yylhsminor.yy792 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy97, NULL); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 167: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy792 = createRealTableNode(pCxt, &yymsp[-2].minor.yy97, &yymsp[0].minor.yy97, NULL); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 170: /* column_def ::= column_name type_name */
{ yylhsminor.yy792 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy97, yymsp[0].minor.yy848, NULL); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 171: /* type_name ::= BOOL */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 172: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 173: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 174: /* type_name ::= INT */
      case 175: /* type_name ::= INTEGER */ yytestcase(yyruleno==175);
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 176: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 177: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 178: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 179: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy848 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 180: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 181: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy848 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 182: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy848 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 183: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy848 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 184: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy848 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 185: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy848 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 186: /* type_name ::= JSON */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 187: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy848 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 188: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 189: /* type_name ::= BLOB */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 190: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy848 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 191: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 192: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy848 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 193: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy848 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 195: /* tags_def_opt ::= tags_def */
      case 321: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==321);
      case 437: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==437);
{ yylhsminor.yy520 = yymsp[0].minor.yy520; }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 196: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 322: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==322);
{ yymsp[-3].minor.yy520 = yymsp[-1].minor.yy520; }
        break;
      case 197: /* table_options ::= */
{ yymsp[1].minor.yy792 = createDefaultTableOptions(pCxt); }
        break;
      case 198: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy792 = setTableOption(pCxt, yymsp[-2].minor.yy792, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 199: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy792 = setTableOption(pCxt, yymsp[-2].minor.yy792, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy520); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 200: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy792 = setTableOption(pCxt, yymsp[-2].minor.yy792, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy520); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 201: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy792 = setTableOption(pCxt, yymsp[-4].minor.yy792, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy520); }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 202: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy792 = setTableOption(pCxt, yymsp[-2].minor.yy792, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 203: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy792 = setTableOption(pCxt, yymsp[-4].minor.yy792, TABLE_OPTION_SMA, yymsp[-1].minor.yy520); }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 204: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy792 = setTableOption(pCxt, yymsp[-2].minor.yy792, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy520); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 205: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy792 = createAlterTableOptions(pCxt); yylhsminor.yy792 = setTableOption(pCxt, yylhsminor.yy792, yymsp[0].minor.yy285.type, &yymsp[0].minor.yy285.val); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 206: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy792 = setTableOption(pCxt, yymsp[-1].minor.yy792, yymsp[0].minor.yy285.type, &yymsp[0].minor.yy285.val); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 207: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy285.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 208: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy285.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 209: /* duration_list ::= duration_literal */
      case 401: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==401);
{ yylhsminor.yy520 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy792)); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 210: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 402: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==402);
{ yylhsminor.yy520 = addNodeToList(pCxt, yymsp[-2].minor.yy520, releaseRawExprNode(pCxt, yymsp[0].minor.yy792)); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 213: /* rollup_func_name ::= function_name */
{ yylhsminor.yy792 = createFunctionNode(pCxt, &yymsp[0].minor.yy97, NULL); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 214: /* rollup_func_name ::= FIRST */
      case 215: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==215);
      case 270: /* tag_item ::= QTAGS */ yytestcase(yyruleno==270);
{ yylhsminor.yy792 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 218: /* col_name ::= column_name */
      case 271: /* tag_item ::= column_name */ yytestcase(yyruleno==271);
{ yylhsminor.yy792 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy97); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 219: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 220: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 221: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 222: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 223: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy792, yymsp[0].minor.yy792, OP_TYPE_LIKE); }
        break;
      case 224: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy792, yymsp[0].minor.yy792, OP_TYPE_LIKE); }
        break;
      case 225: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy792, NULL, OP_TYPE_LIKE); }
        break;
      case 226: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 227: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 228: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 229: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy792, yymsp[-1].minor.yy792, OP_TYPE_EQUAL); }
        break;
      case 230: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 231: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 232: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 233: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 234: /* cmd ::= SHOW LICENCES */
      case 235: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==235);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 236: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy97); }
        break;
      case 237: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy792); }
        break;
      case 238: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy792); }
        break;
      case 239: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 240: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 241: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 242: /* cmd ::= SHOW VARIABLES */
      case 243: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==243);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 244: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 245: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy792); }
        break;
      case 246: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 247: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 248: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 249: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 250: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy792); }
        break;
      case 251: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 252: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 253: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy792, yymsp[-1].minor.yy792, OP_TYPE_EQUAL); }
        break;
      case 254: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy792, yymsp[0].minor.yy792, yymsp[-3].minor.yy520); }
        break;
      case 255: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 256: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 257: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy792,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 258: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 259: /* db_name_cond_opt ::= */
      case 264: /* from_db_opt ::= */ yytestcase(yyruleno==264);
{ yymsp[1].minor.yy792 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 260: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy792 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy97); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 262: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 263: /* table_name_cond ::= table_name */
{ yylhsminor.yy792 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy97); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 265: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy792 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy97); }
        break;
      case 269: /* tag_item ::= TBNAME */
{ yylhsminor.yy792 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 272: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy792 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy97), &yymsp[0].minor.yy97); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 273: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy792 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy97), &yymsp[0].minor.yy97); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 274: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy89, yymsp[-3].minor.yy792, yymsp[-1].minor.yy792, NULL, yymsp[0].minor.yy792); }
        break;
      case 275: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy89, yymsp[-5].minor.yy792, yymsp[-3].minor.yy792, yymsp[-1].minor.yy520, NULL); }
        break;
      case 276: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy89, yymsp[0].minor.yy792); }
        break;
      case 277: /* full_index_name ::= index_name */
{ yylhsminor.yy792 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy97); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 278: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy792 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy97, &yymsp[0].minor.yy97); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 279: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy792 = createIndexOption(pCxt, yymsp[-7].minor.yy520, releaseRawExprNode(pCxt, yymsp[-3].minor.yy792), NULL, yymsp[-1].minor.yy792, yymsp[0].minor.yy792); }
        break;
      case 280: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy792 = createIndexOption(pCxt, yymsp[-9].minor.yy520, releaseRawExprNode(pCxt, yymsp[-5].minor.yy792), releaseRawExprNode(pCxt, yymsp[-3].minor.yy792), yymsp[-1].minor.yy792, yymsp[0].minor.yy792); }
        break;
      case 283: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy792 = createFunctionNode(pCxt, &yymsp[-3].minor.yy97, yymsp[-1].minor.yy520); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 284: /* sma_func_name ::= function_name */
      case 488: /* alias_opt ::= table_alias */ yytestcase(yyruleno==488);
{ yylhsminor.yy97 = yymsp[0].minor.yy97; }
  yymsp[0].minor.yy97 = yylhsminor.yy97;
        break;
      case 289: /* sma_stream_opt ::= */
      case 323: /* stream_options ::= */ yytestcase(yyruleno==323);
{ yymsp[1].minor.yy792 = createStreamOptions(pCxt); }
        break;
      case 290: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy792)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy792); yylhsminor.yy792 = yymsp[-2].minor.yy792; }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 291: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy792)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy792); yylhsminor.yy792 = yymsp[-2].minor.yy792; }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 292: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy792)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy792); yylhsminor.yy792 = yymsp[-2].minor.yy792; }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 293: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy89, &yymsp[-2].minor.yy97, yymsp[0].minor.yy792); }
        break;
      case 294: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy89, &yymsp[-3].minor.yy97, &yymsp[0].minor.yy97, false); }
        break;
      case 295: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy89, &yymsp[-5].minor.yy97, &yymsp[0].minor.yy97, true); }
        break;
      case 296: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy89, &yymsp[-3].minor.yy97, yymsp[0].minor.yy792, false); }
        break;
      case 297: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy89, &yymsp[-5].minor.yy97, yymsp[0].minor.yy792, true); }
        break;
      case 298: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy97); }
        break;
      case 299: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy89, &yymsp[-2].minor.yy97, &yymsp[0].minor.yy97); }
        break;
      case 300: /* cmd ::= DESC full_table_name */
      case 301: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==301);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy792); }
        break;
      case 302: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 303: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 304: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==304);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy89, yymsp[-1].minor.yy792, yymsp[0].minor.yy792); }
        break;
      case 307: /* explain_options ::= */
{ yymsp[1].minor.yy792 = createDefaultExplainOptions(pCxt); }
        break;
      case 308: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy792 = setExplainVerbose(pCxt, yymsp[-2].minor.yy792, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 309: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy792 = setExplainRatio(pCxt, yymsp[-2].minor.yy792, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 310: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy89, yymsp[-8].minor.yy89, &yymsp[-5].minor.yy97, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy848, yymsp[0].minor.yy20); }
        break;
      case 311: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy97); }
        break;
      case 316: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy89, &yymsp[-8].minor.yy97, yymsp[-5].minor.yy792, yymsp[-7].minor.yy792, yymsp[-3].minor.yy520, yymsp[-2].minor.yy792, yymsp[0].minor.yy792, yymsp[-4].minor.yy520); }
        break;
      case 317: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy97); }
        break;
      case 324: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 325: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==325);
{ yylhsminor.yy792 = setStreamOptions(pCxt, yymsp[-2].minor.yy792, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 326: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ yylhsminor.yy792 = setStreamOptions(pCxt, yymsp[-3].minor.yy792, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy792)); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 327: /* stream_options ::= stream_options WATERMARK duration_literal */
{ yylhsminor.yy792 = setStreamOptions(pCxt, yymsp[-2].minor.yy792, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy792)); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 328: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ yylhsminor.yy792 = setStreamOptions(pCxt, yymsp[-3].minor.yy792, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 329: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ yylhsminor.yy792 = setStreamOptions(pCxt, yymsp[-2].minor.yy792, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 330: /* stream_options ::= stream_options DELETE_MARK duration_literal */
{ yylhsminor.yy792 = setStreamOptions(pCxt, yymsp[-2].minor.yy792, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy792)); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 331: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ yylhsminor.yy792 = setStreamOptions(pCxt, yymsp[-3].minor.yy792, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 333: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 522: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==522);
      case 542: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==542);
{ yymsp[-3].minor.yy792 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy792); }
        break;
      case 334: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 335: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 336: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 337: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 338: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 339: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy520); }
        break;
      case 340: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 341: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy520 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 343: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy792, yymsp[0].minor.yy792); }
        break;
      case 346: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy792 = createInsertStmt(pCxt, yymsp[-4].minor.yy792, yymsp[-2].minor.yy520, yymsp[0].minor.yy792); }
        break;
      case 347: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy792 = createInsertStmt(pCxt, yymsp[-1].minor.yy792, NULL, yymsp[0].minor.yy792); }
        break;
      case 348: /* literal ::= NK_INTEGER */
{ yylhsminor.yy792 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 349: /* literal ::= NK_FLOAT */
{ yylhsminor.yy792 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 350: /* literal ::= NK_STRING */
{ yylhsminor.yy792 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 351: /* literal ::= NK_BOOL */
{ yylhsminor.yy792 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 352: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 353: /* literal ::= duration_literal */
      case 363: /* signed_literal ::= signed */ yytestcase(yyruleno==363);
      case 384: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==384);
      case 385: /* expression ::= literal */ yytestcase(yyruleno==385);
      case 386: /* expression ::= pseudo_column */ yytestcase(yyruleno==386);
      case 387: /* expression ::= column_reference */ yytestcase(yyruleno==387);
      case 388: /* expression ::= function_expression */ yytestcase(yyruleno==388);
      case 389: /* expression ::= case_when_expression */ yytestcase(yyruleno==389);
      case 420: /* function_expression ::= literal_func */ yytestcase(yyruleno==420);
      case 469: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==469);
      case 473: /* boolean_primary ::= predicate */ yytestcase(yyruleno==473);
      case 475: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==475);
      case 476: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==476);
      case 479: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==479);
      case 481: /* table_reference ::= table_primary */ yytestcase(yyruleno==481);
      case 482: /* table_reference ::= joined_table */ yytestcase(yyruleno==482);
      case 486: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==486);
      case 544: /* query_simple ::= query_specification */ yytestcase(yyruleno==544);
      case 545: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==545);
      case 548: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==548);
      case 550: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==550);
{ yylhsminor.yy792 = yymsp[0].minor.yy792; }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 354: /* literal ::= NULL */
{ yylhsminor.yy792 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 355: /* literal ::= NK_QUESTION */
{ yylhsminor.yy792 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 356: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy792 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 357: /* signed ::= NK_INTEGER */
{ yylhsminor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 358: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 359: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 360: /* signed ::= NK_FLOAT */
{ yylhsminor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 361: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 362: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 364: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 365: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 366: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 367: /* signed_literal ::= duration_literal */
      case 369: /* signed_literal ::= literal_func */ yytestcase(yyruleno==369);
      case 440: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==440);
      case 502: /* select_item ::= common_expression */ yytestcase(yyruleno==502);
      case 512: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==512);
      case 549: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==549);
      case 551: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==551);
      case 564: /* search_condition ::= common_expression */ yytestcase(yyruleno==564);
{ yylhsminor.yy792 = releaseRawExprNode(pCxt, yymsp[0].minor.yy792); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 368: /* signed_literal ::= NULL */
{ yylhsminor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 370: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy792 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 390: /* expression ::= NK_LP expression NK_RP */
      case 474: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==474);
      case 563: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==563);
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy792)); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 391: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy792));
                                                                                  }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 392: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy792), NULL));
                                                                                  }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 393: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792))); 
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 394: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792))); 
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 395: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792))); 
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 396: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792))); 
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 397: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792)));
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 398: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 399: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792)));
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 400: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792)));
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 403: /* column_reference ::= column_name */
{ yylhsminor.yy792 = createRawExprNode(pCxt, &yymsp[0].minor.yy97, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy97)); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 404: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy97, &yymsp[0].minor.yy97, createColumnNode(pCxt, &yymsp[-2].minor.yy97, &yymsp[0].minor.yy97)); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 405: /* pseudo_column ::= ROWTS */
      case 406: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==406);
      case 408: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==408);
      case 409: /* pseudo_column ::= QEND */ yytestcase(yyruleno==409);
      case 410: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==410);
      case 411: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==411);
      case 412: /* pseudo_column ::= WEND */ yytestcase(yyruleno==412);
      case 413: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==413);
      case 414: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==414);
      case 415: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==415);
      case 416: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==416);
      case 422: /* literal_func ::= NOW */ yytestcase(yyruleno==422);
{ yylhsminor.yy792 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 407: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy97, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy97)))); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 417: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 418: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==418);
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy97, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy97, yymsp[-1].minor.yy520)); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 419: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy792), yymsp[-1].minor.yy848)); }
  yymsp[-5].minor.yy792 = yylhsminor.yy792;
        break;
      case 421: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy97, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy97, NULL)); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 436: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy520 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 441: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 505: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==505);
{ yylhsminor.yy792 = createColumnNode(pCxt, &yymsp[-2].minor.yy97, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 442: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy520, yymsp[-1].minor.yy792)); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 443: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy792), yymsp[-2].minor.yy520, yymsp[-1].minor.yy792)); }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 446: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy792 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792)); }
        break;
      case 448: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy792 = releaseRawExprNode(pCxt, yymsp[0].minor.yy792); }
        break;
      case 449: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 454: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==454);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy396, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792)));
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 450: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy792), releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792)));
                                                                                  }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 451: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy792), releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792)));
                                                                                  }
  yymsp[-5].minor.yy792 = yylhsminor.yy792;
        break;
      case 452: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), NULL));
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 453: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy792), NULL));
                                                                                  }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 455: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy396 = OP_TYPE_LOWER_THAN; }
        break;
      case 456: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy396 = OP_TYPE_GREATER_THAN; }
        break;
      case 457: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy396 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 458: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy396 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 459: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy396 = OP_TYPE_NOT_EQUAL; }
        break;
      case 460: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy396 = OP_TYPE_EQUAL; }
        break;
      case 461: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy396 = OP_TYPE_LIKE; }
        break;
      case 462: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy396 = OP_TYPE_NOT_LIKE; }
        break;
      case 463: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy396 = OP_TYPE_MATCH; }
        break;
      case 464: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy396 = OP_TYPE_NMATCH; }
        break;
      case 465: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy396 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 466: /* in_op ::= IN */
{ yymsp[0].minor.yy396 = OP_TYPE_IN; }
        break;
      case 467: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy396 = OP_TYPE_NOT_IN; }
        break;
      case 468: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy520)); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 470: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy792), NULL));
                                                                                  }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 471: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792)));
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 472: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792)));
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 480: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy792 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy792, yymsp[0].minor.yy792, NULL); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 483: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy792 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy97, &yymsp[0].minor.yy97); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 484: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy792 = createRealTableNode(pCxt, &yymsp[-3].minor.yy97, &yymsp[-1].minor.yy97, &yymsp[0].minor.yy97); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 485: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy792 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy792), &yymsp[0].minor.yy97); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 487: /* alias_opt ::= */
{ yymsp[1].minor.yy97 = nil_token;  }
        break;
      case 489: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy97 = yymsp[0].minor.yy97; }
        break;
      case 490: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 491: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==491);
{ yymsp[-2].minor.yy792 = yymsp[-1].minor.yy792; }
        break;
      case 492: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy792 = createJoinTableNode(pCxt, yymsp[-4].minor.yy116, yymsp[-5].minor.yy792, yymsp[-2].minor.yy792, yymsp[0].minor.yy792); }
  yymsp[-5].minor.yy792 = yylhsminor.yy792;
        break;
      case 493: /* join_type ::= */
{ yymsp[1].minor.yy116 = JOIN_TYPE_INNER; }
        break;
      case 494: /* join_type ::= INNER */
{ yymsp[0].minor.yy116 = JOIN_TYPE_INNER; }
        break;
      case 495: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy792 = createSelectStmt(pCxt, yymsp[-10].minor.yy89, yymsp[-9].minor.yy520, yymsp[-8].minor.yy792);
                                                                                    yymsp[-11].minor.yy792 = addWhereClause(pCxt, yymsp[-11].minor.yy792, yymsp[-7].minor.yy792);
                                                                                    yymsp[-11].minor.yy792 = addPartitionByClause(pCxt, yymsp[-11].minor.yy792, yymsp[-6].minor.yy520);
                                                                                    yymsp[-11].minor.yy792 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy792, yymsp[-2].minor.yy792);
                                                                                    yymsp[-11].minor.yy792 = addGroupByClause(pCxt, yymsp[-11].minor.yy792, yymsp[-1].minor.yy520);
                                                                                    yymsp[-11].minor.yy792 = addHavingClause(pCxt, yymsp[-11].minor.yy792, yymsp[0].minor.yy792);
                                                                                    yymsp[-11].minor.yy792 = addRangeClause(pCxt, yymsp[-11].minor.yy792, yymsp[-5].minor.yy792);
                                                                                    yymsp[-11].minor.yy792 = addEveryClause(pCxt, yymsp[-11].minor.yy792, yymsp[-4].minor.yy792);
                                                                                    yymsp[-11].minor.yy792 = addFillClause(pCxt, yymsp[-11].minor.yy792, yymsp[-3].minor.yy792);
                                                                                  }
        break;
      case 498: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy89 = false; }
        break;
      case 501: /* select_item ::= NK_STAR */
{ yylhsminor.yy792 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 503: /* select_item ::= common_expression column_alias */
      case 513: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==513);
{ yylhsminor.yy792 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy792), &yymsp[0].minor.yy97); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 504: /* select_item ::= common_expression AS column_alias */
      case 514: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==514);
{ yylhsminor.yy792 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), &yymsp[0].minor.yy97); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 509: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 534: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==534);
      case 553: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==553);
{ yymsp[-2].minor.yy520 = yymsp[0].minor.yy520; }
        break;
      case 516: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy792 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy792), releaseRawExprNode(pCxt, yymsp[-1].minor.yy792)); }
        break;
      case 517: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy792 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy792)); }
        break;
      case 518: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy792 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy792), NULL, yymsp[-1].minor.yy792, yymsp[0].minor.yy792); }
        break;
      case 519: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy792 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy792), releaseRawExprNode(pCxt, yymsp[-3].minor.yy792), yymsp[-1].minor.yy792, yymsp[0].minor.yy792); }
        break;
      case 520: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy792 = createEventWindowNode(pCxt, yymsp[-3].minor.yy792, yymsp[0].minor.yy792); }
        break;
      case 524: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy792 = createFillNode(pCxt, yymsp[-1].minor.yy646, NULL); }
        break;
      case 525: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy792 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy520)); }
        break;
      case 526: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy792 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy520)); }
        break;
      case 527: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy646 = FILL_MODE_NONE; }
        break;
      case 528: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy646 = FILL_MODE_PREV; }
        break;
      case 529: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy646 = FILL_MODE_NULL; }
        break;
      case 530: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy646 = FILL_MODE_NULL_F; }
        break;
      case 531: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy646 = FILL_MODE_LINEAR; }
        break;
      case 532: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy646 = FILL_MODE_NEXT; }
        break;
      case 535: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy520 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy792))); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 536: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy520 = addNodeToList(pCxt, yymsp[-2].minor.yy520, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy792))); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 540: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy792 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy792), releaseRawExprNode(pCxt, yymsp[-1].minor.yy792)); }
        break;
      case 543: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy792 = addOrderByClause(pCxt, yymsp[-3].minor.yy792, yymsp[-2].minor.yy520);
                                                                                    yylhsminor.yy792 = addSlimitClause(pCxt, yylhsminor.yy792, yymsp[-1].minor.yy792);
                                                                                    yylhsminor.yy792 = addLimitClause(pCxt, yylhsminor.yy792, yymsp[0].minor.yy792);
                                                                                  }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 546: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy792 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy792, yymsp[0].minor.yy792); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 547: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy792 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy792, yymsp[0].minor.yy792); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 555: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 559: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==559);
{ yymsp[-1].minor.yy792 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 556: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 560: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==560);
{ yymsp[-3].minor.yy792 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 557: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 561: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==561);
{ yymsp[-3].minor.yy792 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 562: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy792); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 567: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy792 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), yymsp[-1].minor.yy34, yymsp[0].minor.yy265); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 568: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy34 = ORDER_ASC; }
        break;
      case 569: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy34 = ORDER_ASC; }
        break;
      case 570: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy34 = ORDER_DESC; }
        break;
      case 571: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy265 = NULL_ORDER_DEFAULT; }
        break;
      case 572: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy265 = NULL_ORDER_FIRST; }
        break;
      case 573: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy265 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
