---
sidebar_label: 错误码
title: TDengine C/C++ 连接器错误码
description: C/C++ 连接器的错误码列表和详细说明
---

本文中详细列举了在使用 TDengine C/C++ 连接器时客户端可能得到的错误码以及所要采取的相应动作。其它语言的连接器在使用原生连接方式时也会所得到的返回码返回给连接器的调用者。

  | **Error Code** | **说明**           | 如何处理错误 |
  | -------------- | ------------------ | ------------ |
  | 0              | 请求处理成功       | None         |
  | -1             | 请求失败，未知原因 | TODO        |
  | 0x0003         | RPC 认证失败       |   TODO           |
  | 0x0004 | RPC 重定向 |TODO| 
  | 0x000B | 无法建立连接 |TODO|
  | 0x0015 | FQDN 解析失败 |检查各个dnode配置的FQDN是否正确，并且能够从其它节点 ping 到 |
  | 0x0017 | 端口已经被占用 | 检查所配置的端口被哪个进程占用，关闭该进程以释放端口；或者更改配置使用另一端口号 |
  | 0x0018 | 连接被断开 | 检查 dnode 进程是否还在，如果无异常检查网络情况  |
  | 0x0013 | 客户端和服务端的时间未同步 | 检查客户端和服务端的时间设置是否同步|
  | 0x0014 | 数据库不可用 |检查数据库是否存在，检查数据库的vgroups的状态 |
  | 0x0100 | 该操作不支持 | 参考SQL手册，使用正确的操作 |
  | 0x0102 | 无法分配内存，系统内存耗尽 | 检查系统中内存被耗尽的原因，采取措施释放内存。如果内存是被 dnode 耗尽的话重启该进程 |
  | 0x0104 | 文件被破坏 | TODO |
  | 0x0111 | 操作在进行中 | 等待该操作完成  | 
  | 0x0115 | 无效的消息 | TODO |
  | 0x0116 | 无效的消息长度 | TODO |
  | 0x0117 | 无效指针 | TODO |
  | 0x0118 | 无效参数 |  |
  | 0x0119 | 无效配置 | 检查配置参数的值是否在合法值域范围内 |
  | 0x011A | 无效选项 | 检查配置中是否有不支持的无效配置项 |
  | 0x011B | 无效的JSON 格式 | 修正插入数据中的JSON值|
  | 0x011C | 无效版本号 | 检查客户端版本是否匹配，更换正确的客户端 |
  | 0x011D | 无效版本信息 | 检查客户端版本是否匹配，更换正确的客户端 |
  | 0x011E | 版本不匹配 | TODO |
  | 0x011F | 校验和错误  | TODO |
  | 0x0120 | 数据压缩失败 | TODO |
  | 0x0121 | 消息未处理 | TODO |
  | 0x0122 | 配置未找到 | TODO|
  | 0x0123 | 重复初始化 | TODO |
  | 0x0124 | 无法将重复的key加入hash| TODO |
  | 0x0125 | 需要重试 | 重试 |
  | 0x0126 | RPC 队列内存耗尽 | TODO |
  | 0x0127 | 无效的时间戳 | 修正插入数据 |
  | 0x0128 | 消息解码失败 | 检查客户端版本是否匹配和兼容 |
  | 0x0129 | 磁盘耗尽 | TODO |
  | 0x012A | TODO | TODO |
  | 0x0200 | 无效操作 | 检查SQL命令，根据SQL手册使用正确的操作|
  | 0x0201 | 无效的查询句柄  | TODO |
  | 0x0202 | 无效的客户端/服务端时间组合 | TODO |
  | 0x0203 | 无效值 | TODO |
  | 0x0204 | 无效的客户端版本 | 检查客户端版本是否匹配，更换为正确的客户端版本 |
  | 0x0205 | TODO | TODO |
  | 0x0206 | 无效的 FQDN | 检查服务器 fqdn 配置是否正确，是否能够从其它服务器访问到该 fqdn |
  | 0x0207 | 用户名长度过长 |  检查用户名长度是否过长 | 
  | 0x0208 | 密码长度过长 | 检查密码长度是否过长 |
  | 0x0209 | 数据库名字长度过长 | 检查数据库名是否过长 | 
  | 0x020A | 表名长度过长 | 检查表名是否过长 |
  | 0x020B | 无效连接 | 检查该连接是否已经断开 |
  | 0x020C | 系统内存耗尽  | 检查系统中内存被耗尽的原因，尝试释放出内存 |
  | 0x020D | 磁盘空间耗尽 | 检查系统中磁盘耗尽的原因，尝试释放或增加磁盘空间 |
  | 0x020E | 查询缓存被清除 |TODO |
  | 0x020F | 查询已经被结束 | 尝试优化查询条件再重启查询 | 
  | 0x0210 | 结果集过大无法存储 | 尝试优化查询条件，缩小结果集，再重启查询 |
  | 0x0211 | 数据库不可用  | 查看数据库是否存在，查看数据库的 vgroups 状态 |
  | 0x0212 | 操作正在进行中 | 等待操作完成 |
  | 0x0213 | 连接被服务端断开 | 查看服务端进程是否发生 crash 等异常终止情况 |
  | 0x0214 | 没有写权限 | 只进行读操作或者尝试获取写权限 |
  | 0x0215 | 连接被 kill | 重新建立连接 | 
  | 0x0216 | SQL 语法错误 | 参考 SQL手册，纠正语法错误再重试 |
  | 0x0217 | 未指定数据库或者指定的数据库不可用 | 指定数据库，或者检查指定数据库的状态 | 
  | 0x0218 | 所查询的表不存在 | 确认表名后纠正查询语句 | 
  | 0x0219 | SQL 语句超长 | 根据 maxSQLLength 缩短SQL语句或者加大maxSQLLength （如果还未配置到上限）| 
  | 0x021A | 空文件  | TODO |
  | 0x021B | Line 协议语法错误 | 纠正插入语句 |
  | 0x021C | 元数据未被缓存 | TODO |
  | 0x021D | 重复的列名 | 纠正SQL语句中的相应错误 |
  | 0x021E | tag 过长 | 纠正过长的 tag |
  | 0x021F | 列名过长 | 纠正过长的列名 |
  | 0x0220 | 重复的表名**TODO** | TODO|
  | 0x0221 | JSON 格式错误 | 纠正错误的 JSON 结构 |
  | 0x0222 | JSON 中使用了无效的数据类型 | 纠正 JSON 结构中的错误 |
  | 0x0224 | 超出了所支持的值域  | 纠正到值域范围内 |
  | 0x0229 | 无效的 tsc 输入  **TODO** | TODO  |
  | 0x022A | stmt API 使用错误 | 根据参考手册正确使用 |
  | 0x022B | stmt 使用时未指定表名 | 指定表名 |
  | 0x022C | 不支持 stmt 子名 | 根据参考手册纠正错误用法 | 
  | 0x022D | 查询被 kill | 优化查询语句，尽量减小计算量和结果集，然后重新启动查询  |
  | 0x022E | 在当前配置的查询策略下没有可用的计算节点 | 创建新的 qnode |
  | 0x022F | 所指定的表不是超级表 | 确认下该查询场景适用于超级表还是子表/普通表，如果是前者则纠正为超级表名 |
  | 0x0303 | 没有权限进行所发起的操作 | 申请权限或调整操作 |
  | 0x0304 | 管理节点内部错误  | TODO |
  | 0x0305 | 无效连接 | TODO |
  | 0x030B | 所要展示的操作其数据已经因为超时而被删除 | 更换想要展示操作或者放弃此次操作 |
  | 0x030C | 无效的查询ID| 确认正确的查询ID再重新发起 |
  | 0x030D | 无效的流ID| 确认正确的流ID再重新发起|
  | 0x030E | 无效的连接ID| 确认正确的连接ID再重新发起|
  | 0x0310 | mnode已经在运行 | 无须采取任何动作 |
  | 0x0311 | 配置同步失败 | TODO |
  | 0x0312 | 无法启动同步 | TODO |
  | 0x0313 | 无法创建 mnode 对应的目录  | 确认磁盘上是否有可用空间以及是否有相应的写权限 |
  | 0x0314 | 启动组件失败 | TODO |
  | 0x0315 | 用户帐号被禁用 | 联系管理员激活该帐号 |
  | 0x0320 | 元数据中已经存在所要创建的对象 | 检查所要创建的对象，比如超级表或表，是否已经存在 |
  | 0x0321 | 元数据库中非预期的一般性错误 | TODO |
  | 0x0322 | 无效的表类型 | TODO |
  | 0x0323 | 所要查找的对象不存在 | TODO |
  | 0x0325 | 无效的 key 类型 | TODO  |
  | 0x0326 | 无效的动作类型 | TODO |
  | 0x0327 | 无效的状态类型 | TODO |
  | 0x0328 | 无效的原始数据版本 | TODO |
  | 0x0329 | 无效的原始数据长度 | TODO |
  | 0x032A | 无效的原始数据内容 | TODO |
  | 0x032B | 无效的 wal 版本 | TODO |
  | 0x032C | 对象创建中 | TODO |
  | 0x032D | 对象停止中 | TODO |
  | 0x0330 | dnode 已经存在 | 无需任何动作，放弃重复创建dnode的操作 | 
  | 0x0331 | dnode 不存在 | 确认所要查询或者操作的dnode ID 或者 end point 是否正确  | 
  | 0x0332 | vgroup 不存在 | 确认所要查询或者操作的vgroup ID 是否正确  |
  | 0x0333 | 系统拒绝 drop 其角色是 leader 的 mnode | 放弃该操作 |
  | 0x0334 | 没有足够的 dnode 创建所指定的 vgroups | 增加 dnode 或者修改现有dnode的配置参数 `supportVgroups` |
  | 0x0335 | 集群中各个dnode的配置不一致 | 检查各个dnode的配置参数确保其一致 |
  | 0x0338 | 所要查询或操作的vgroup不在所指定的dnode中| 检查vgroup ID 和 dnode ID是否正确 |
  | 0x0339 | 所要查询或操作的 vgroup 已经在所指定的dnode中 | 检查 vgroup ID 和 dnode ID是否正确 |
  | 0x033B | 集群 ID 不匹配 | TODO |
  | 0x0340 | 该帐户已经存在 | 放弃重复创建帐户的操作 | 
  | 0x0342 | 无效的帐户选项 | 检查创建帐户时的参数选项是否正确 |
  | 0x0343 | 帐户授权已经过期 | 联系管理员重新授权 |
  | 0x0344 | 无效帐户 | 联系管理员确认帐户 |
  | 0x0345 | 操作的帐户过多，无法支持 | 减少同时操作的帐户数 |
  | 0x0350 | 用户已经存在 | 放弃重复创建用户的操作 |
  | 0x0351 | 无效用户 | 检查并确认正确用户 |
  | 0x0352 | 无效的用户名格式 | 查看参考手册修改用户名 |
  | 0x0353 | 无效的密码格式 | 查看参考手册修改密码 |
  | 0x0354 | 无法从连接中获取用户名 | 检查客户端环境初始化是否使用了正确的用户名 |
  | 0x0355 | 一次尝试操作的用户过多 | 查看参考手册减少同时操作的用户数 |
  | 0x0356 | 无效的修改操作 | 查看参考手册使用正确的操作 |
  | 0x0357 | 认证失败 | 使用正确的用户名和密码 |
  | 0x0360 | 要创建的超级表已经存在 | 放弃重复创建的操作或者删除该超级表再重新创建 |
  | 0x0362 | 所使用或查询的超级表不存在 | 确认超级表名是否正确，如果正确则需要先创建超级表 |
  | 0x0364 | 标签过多 | 查看参考手册减少标签数量 |
  | 0x0365 | 列过多 | 查看参考手册减少列数量  |
  | 0x0369 | 要添加的标签已经存在 | 修改标签名 |
  | 0x036A | 要查询或修改的标签不存在 | 确认标签名是否正确  |
  | 0x036B | 要添加的列已经存在 | 修改列名或者放弃该操作 |
  | 0x036C | 要查询或修改的列不存在 | 确认列名是否正确  |
  | 0x036E | 无效的超级表操作 | 查看参考手册进行正确的操作 |
  | 0x036F | 错误的行字节数 | TODO |
  | 0x0370 | 无效的函数名 | 确认函数名是否正确  |
  | 0x0372 | 无效的函数代码  | 无效的函数编码 |
  | 0x0373 | 该函数已经存在 | 修改函数名或者放弃该操作|
  | 0x0374 | 所引用的函数不存在 | 确认函数名是否正确  |
  | 0x0375 | 无效的 bufSize | 查看参考手册修改 bufSize |
  | 0x0378 | 无效的函数注释 | 查看参考手册修改函数注释 |
  | 0x0379 | 无效的函数检索消息 | TODO |
  | 0x0380 | 未指定数据库或者指定的数据库不可用 | 指定数据库，或者检查所指定的数据库的状态 |
  | 0x0381 | 数据库已经存在 | 放弃重复创建，或者修改数据库名 |
  | 0x0382 | 无效的数据库参数 | 查看参考手册使用正确的参数 |
  | 0x0383 | 无效的数据库名称 | 查看参考手册使用正确的数据库名 | 
  | 0x0385 | 该帐号下的数据库过多 | 删除旧的数据库再尝试创建新数据库 |
  | 0x0388 | 数据库不存在 | 确认数据库名是否正确  |
  | 0x0389 | 无效的数据库帐户 | 确认帐户是否正确  |
  | 0x038A | 数据库参数未修改 | 查看参考手册确认修改的参数和值是否正确 |
  | 0x038B | 索引不存在 |确认索引名称是否正确  |
  | 0x039A | 无效的系统表名 | 查看参考手册确认表名是否正确  |
  | 0x03A0 | mnode 已经存在 | 放弃该操作 |
  | 0x03A1 | mnode 不存在 | 确认要查看或操作的 mnode ID   |
  | 0x03A2 | qnode 已经存在 | 放弃该操作 |
  | 0x03A3 | qnode 不存在 | 确认要查看或操作的 qnode ID 是否正确 |
  | 0x03A8 | mnode 的 replica 不能小于1 | 停止  drop mnode |
  | 0x03A9 | mnode 的 replica 不能大于3 | 停止  create mnode |
  | 0x03B0 | dnode 数量过多 | 停止添加新的 dnode |
  | 0x03B1 | dnode 没有足够的可用内存 | 检查所在系统的内存使用情况 ，尝试释放出内存 |
  | 0x03B2 | 无效的 dnode 配置 | 查看参考手册纠正配置 |
  | 0x03B3 | 无效的 dnode 地址 | 确认 dnode 的 FQDN 和 serverPort参数是否正确 |
  | 0x03B4 | 无效的 dnode ID | 确认正确的 dnode ID |
  | 0x03B5 | vgroup 的分布未发生变化  | TODO |
  | 0x03B6 | 存在状态为 offline 的 dnode | drop 这些 dnode 或者启动相应的 dnode 使其状态为 ready |
  | 0x03B7 | 无效的 vgroup 副本 | TODO |
  | 0x03C0 | topic 与超级表冲突 | TODO |
  | 0x03C1 | 订阅了过多的超级表 | 查看参考手册减少超级表数量 |
  | 0x03C2 | 无效的 超级表修改参数 | 查看参考手册进行纠正 |
  | 0x03C3 | 超级表参数未被修改 | 查看参考手册确认参数是否正确 |
  | 0x03C4 | 该字段被某个主题所使用 | TODO |
  | 0x03C5 | 该数据库是单超级表模式 | 修改数据库为多超级表模式或者放弃创建新的超级表 |
  | 0x03C6 | 修改超级表使用了无效的 schema 版本 | TODO |
  | 0x03C7 | 修改超级表使用了无效的超级表 ID | 确认超级表使用是否正确  |
  | 0x03C8 | 该字段被 tsma 所使用 | TODO |
  | 0x03D0 | 该事务已经存在 | TODO |
  | 0x03D1 | 该事务不存在 | TODO |
  | 0x03D2 | 要 kill 的 stage 不存在 | TODO |
  | 0x03D3 | 冲突的事务没有完成 | TODO |
  | 0x03D4 | 未知的事务错误 | TODO |
  | 0x03D5 | 事务提交日志已满 | TODO |
  | 0x03DF | 在执行事务时无法建立连接  | 等待事务完成尝试重新建立连接 |
  | 0x03E0 | Topic 已经存在 | 修改 topic 名字或者放弃创建重复的 topic |
  | 0x03E1 | Topic 不存在 | 确认 Topic 名字是否正确  |
  | 0x03E2 | Topic 过多 | 尝试删除不用的 topic 再建立新的，或者放弃此次操作 |
  | 0x03E3 | 无效的 Topic | 确认 Topic 是否正确  |
  | 0x03E4 | 建立 Topic 的查询子名无效 | 查看参考手册纠正查询子名 |
  | 0x03E5 | 建立 Topic 的参数无效 | 查看参考手册使用正确的参数  |
  | 0x03E6 | 消费者不存在  | 确认正确的消费者 ID |
  | 0x03E7 | 消费者未修改 | TODO |
  | 0x03E8 | 订阅不存在 | 确认正确的订阅 ID |
  | 0x03E9 | 偏移量不存在 | 纠正偏移量 |
  | 0x03EA | 消费者不可用 | TODO |
  | 0x03EB | 无法删除已经被订阅的 Topic | 先取消订阅再尝试删除  |
  | 0x03EC | Consumer group正在被某些消费者使用 | TODO |
  | 0x03F0 | 流已经存在 | 修改流名称或者放弃创建该流 |
  | 0x03F1 | 要查询或操作的流不存在 | 确认正确的流 ID |
  | 0x03F2 | 无效的流参数 | 查看参考手册纠正错误的参数 |
  | 0x0480 | SMA 已经存在 | 修改 SMA 名称或者放弃创建 | 
  | 0x0481 | SMA 不存在 | 确认正确的 SMA 名称或者 ID |
  | 0x0482 | SMA 参数错误 | 查看参考手册纠正参数 |
  | 0x0408 | 节点不在线 | TODO |
  | 0x0409 | 节点已经部署 | TODO |
  | 0x040A | 节点未部署 | TODO |
  | 0x0500 | 该动作作在进行中| TODO |
  | 0x0501 | 消息未被处理 | TODO |
  | 0x0502 | 该动作需要被重新处理 | TODO |
  | 0x0503 | 无效的 vgroup ID | 检查确认正确的 vgroups ID |
  | 0x0504 | vnode 初始化失败 | TODO |
  | 0x0505 | 系统磁盘空间耗尽 | 尝试释放或者增加磁盘空间 |
  | 0x0506 | 对磁盘文件没有写权限 | 检查启动 TDengine 的系统帐号的写权限 | 
  | 0x0507 | 数据文件缺失 | TODO |
  | 0x0508 | vnode 没有可用内存 | TODO |
  | 0x0509 | vnode 中未预期的一般性错误 | TODO |
  | 0x050C | 数据库无空闲内存 | TODO |
  | 0x050D | 数据库正在删除中 | TODO |
  | 0x050E | 数据库正在更新中 | TODO |
  | 0x0510 | 数据库正在关闭中 | TODO |
  | 0x0511 | 数据库被暂停操作 | TODO |
  | 0x0512 | 数据库写操作被拒绝 | 检查用户权限，申请写操作授权 | 
  | 0x0513 | 数据库正在同步中 | TODO |
  | 0x0514 | 无效的 tsdb 状态 | TODO |
  | 0x0520 | 指定的表不存在 | 检查确认正确的表名 |
  | 0x0521 | 指定的SMA 不存在 | 检查确认正确的 SMA名称 |
  | 0x0522 | Hash 值不匹配 | TODO |
  | 0x0523 | 指定的表不存在 | 检查确认正确的表名 |
  | 0x0524 | 无效的表动作 | TODO |
  | 0x0525 | 列名已经存在 | 修改列名或放弃操作 |
  | 0x0526 | 列名不存在 | 确认正确的列名 |
  | 0x0527 | 该列已经被订阅  | 先取消订阅再操作或者放弃操作 |
  | 0x0528 | 无效的配置文件  | 检查配置文件的路径和访问权限 |
  | 0x0529 | 无效的 term 文件  | TODO |
  | 0x0600 | 无效的表 ID | 确认表名是否正确  |
  | 0x0601 | 无效的表 类型 | TODO |
  | 0x0602 | 无效的 schema 版本 | TODO |
  | 0x0603 | 表已经存在 | 修改表名或放弃操作 |
  | 0x0604 | 配置无效 | 查看参考手册纠正配置 |
  | 0x0605 | TSDB 初始化失败 | TODO |
  | 0x0606 | 磁盘空间耗尽 | 查看磁盘空间耗尽的原因，尝试释放或增加磁盘空间 |
  | 0x0607 | 磁盘文件没有访问权限 | 确认启动集群的系统帐户是否有相应的写权限 |
  | 0x0608 | 数据文件被破坏 | TODO |
  | 0x0609 | 内存耗尽 | 检查内存被耗尽的原因，尝试释放内存 |
  | 0x060A | 标签版本过老 | TODO |
  | 0x060B | 时间戳不在允许范围内 | 查看参考手册了解允许写入的时间戳规则 |
  | 0x060C | 提交消息被破坏 | TODO |
  | 0x060D | 无效操作 | TODO |
  | 0x060E | 建表消息无效 | TODO |
  | 0x060F | 内存跳表中没有表的数据 | TODO |
  | 0x0610 | 文件已经存在 | TODO |
  | 0x0611 | 需要重新配置该表 | TODO |
  | 0x0612 | 建表的信息无效 | TODO |
  | 0x0613 | 磁盘空间耗尽 | 尝试释放或增加磁盘空间 |
  | 0x0614 | 消息被破坏 |TODO |
  | 0x0615 | 无效的标签值  | 修正标签值 |
  | 0x0616 | 未缓存最后一行的原始数据 | 修改数据库的 cacheModel 参数 |
  | 0x0618 | 该表不存在 | 检查表名是否正确  |
  | 0x0619 | 超级表已经存在 | 修改超级表名再次尝试 |
  | 0x061A | 超级表不存在 | 检查超级表名是否正确  |
  | 0x061B | 表被重新创建 | TODO |
  | 0x061C | TDB 环境打开错误 | N/A |
  | 0x0700 | 无效的查询句柄  | N/A |
  | 0x0701 | 无效的消息 | TODO |
  | 0x0702 | 磁盘空间耗尽 | 尝试释放或增加磁盘空间 |
  | 0x0703 | 系统内存耗尽 | 尝试释放内存 |
  | 0x0704 | 未知错误  | TODO |
  | 0x0705 | 重复的 Join Key | 修正查询语句中的 Join Key |
  | 0x0706 | 标签过滤条件过多 | 减小查询语句中的标签过滤条件  |
  | 0x0707 | 查询不可用 | TODO |
  | 0x0708 | TODO | TODO |
  | 0x0709 | TODO | TODO |
  | 0x070A | 查询中的时间窗口过多 | 修改查询语句以减小时间窗口的数量  |
  | 0x070B | 查询缓冲区达到上限 | TODO |
  | 0x070C | 多副本数据不一致 | TODO |
  | 0x070D | 系统错误 | TODO |
  | 0x070E | 无效的时间范围 | 修正查询语句中的时间范围 | 
  | 0x070F | 无效输入  | 修正查询语句 |
  | 0x0720 | 调度器不存在 | TODO |
  | 0x0721 | 任务不存在 | TODO |
  | 0x0722 | 任务已经存在 | TODO |
  | 0x0723 | 任务上下文不存在 | TODO |
  | 0x0724 | 任务被取消 | TODO |
  | 0x0725 | 任务被停止 | TODO |
  | 0x0726 | 任务正在取消中 | TODO |
  | 0x0727 | 任务正在停止中 | TODO |
  | 0x0728 | 重复操作 | TODO |
  | 0x0729 | 任务消息错误 | TODO |
  | 0x072A | 作业已经被释放  | TODO |
  | 0x072B | 任务状态错误  | TODO |
  | 0x072C | in 和 not in 操作符不支持 JSON 类型 | 修正查询语句 |
  | 0x072D | 此处不支持 JSON |修正查询语句 |
  | 0x072E | group 和 partition by 不支持 JSON 类型 |
  | 0x072F | 查询作业不存在 | TODO |
  | 0x0800 | License 已经过期  | 重新激活或获取 License |
  | 0x0801 | 受限于 License 无法创建 dnode | 获取新的License |
  | 0x0802 | 受限于 License 无法创建帐户 | 获取新的 License |
  | 0x0803 | 受限于 License 无法创建表 | 获取新的 License |
  | 0x0804 | 受限于 License 无法创建数据库  | 获取新的 License |
  | 0x0805 | 受限于 License 无法创建用户  | 获取新的 License |
  | 0x0806 | 受限于 License 无法创建连接  | 获取新的 License |
  | 0x0807 | 受限于 License 无法创建流  | 获取新的 License |
  | 0x0808 | 写入速度受限于 License  | 获取新的 License |
  | 0x0809 | 存储容量受限于 License  | 获取新的 License |
  | 0x080A | 查询时间受限于 License  | 获取新的 License |
  | 0x080B | CPU 核数受限于 License  | 获取新的 License |
  | 0x080C | 受限于 License 无法创建超级表 | 获取新的 License |
  | 0x080D | 受限于 License 无法创建表 | 获取新的 License |
  | 0x0A00 | TQ 无效配置 | TODO |
  | 0x0A01 | TQ 初始化失败 | TODO |
  | 0x0A02 | TQ 磁盘空间耗尽 | 尝试释放或增加磁盘空间 | 
  | 0x0A03 | TQ 没有写磁盘权限 | 确认启动集群的系统帐号是否具有写磁盘权限 |
  | 0x0A04 | TQ 文件被破坏 | TODO |
  | 0x0A05 | TQ 内存耗尽 | 尝试释放内存 |
  | 0x0A06 | TQ 文件已经存在 | TODO |
  | 0x0A07 | TQ 创建目录失败 | TODO |
  | 0x0A08 | TQ meta 中不存在该 key | TODO |
  | 0x0A09 | meta key在事务中不存在 | TODO |
  | 0x0A0A | meta key在事务中重复 | TODO |
  | 0x0A0B | 消费组不存在 | 指定正确的消费组 |
  | 0x0A0C | 该表的 schema 不存在 | 确认表名是否正确  |
  | 0x0A0D | 没有已经提交的 offset | TODO |
  | 0x1000 | WAL 未知错误 | TODO |
  | 0x1001 | WAL 文件被破坏 | TODO |
  | 0x1002 | WAL 大小超出上限 | TODO |
  | 0x1003 | WAL 使用了错误的版本号 | TODO |
  | 0x1004 | 系统内存耗尽 | 尝试释放内存 | 
  | 0x1005 | WAL 日志不存在 | TODO |
  | 0x2201 | 无效的 mount 配置 | 修正 mount 配置参数 |
  | 0x2202 | mount 点过多 | TODO |
  | 0x2203 | 重复的 primary mount | TODO |
  | 0x2204 | primary mount 缺失 | TODO |
  | 0x2205 | no mount at tier: TODO  | TODO |
  | 0x2206 | 文件已经存在 | 更改文件名或者删除该文件  |
  | 0x2207 | 无效的级别 | TODO |
  | 0x2208 | 没有可用磁盘 | TODO |
  | 0x220F | 系统内存耗尽 | TODO |
  | 0x2400 | catalog 内部错误 | TODO |
  | 0x2401 | 无效的 catalog 输入参数 | TODO |
  | 0x2402 | catalog 不可用 | TODO |
  | 0x2403 | catalog 系统错误 | TODO |
  | 0x2404 |  数据库被删除 | TODO |
  | 0x2405 | catalog 不可用 | TODO |
  | 0x2406 | 表元数据和 vgroup 不匹配 | TODO |
  | 0x2407 | catalog 不存在 | TODO |
  | 0x2550 | 无效的消息顺序 | TODO |
  | 0x2501 | 调度器状态错误  | TODO |
  | 0x2502 | 调度器内部错误 | TODO |
  | 0x2504 | 任务超时 | TODO |
  | 0x2505 | 作业正在停止中 | TODO |
  | 0x2600 | 语法错误 | 参考 SQL 手册纠正 |
  | 0x2601 | 不完整的 SQL 语句 | 参考 SQL 手册纠正 |
  | 0x2602 | 无效列名 | 使用正确的列名 |
  | 0x2603 | 表不存在 | 使用正确的表名 |
  | 0x2604 | 表名定义有二义性 | 参考 SQL 手册纠正 |
  | 0x2605 | 无效的值类型 | 参考 SQL 手册纠正 |
  | 0x2608 | 此处不能使用聚合查询 | 参考 SQL 手册纠正 |
  | 0x2609 | ORDER BY 只能用于查询语句中的结果列 | 参考 SQL 手册纠正 |
  | 0x260A | GROUP BY 缺失表达式 (TODO) | 参考 SQL 手册纠正 |
  | 0x260B | 不是 SELECT 表达式 | 参考 SQL 手册纠正 |
  | 0x260C | 不是单一分组的分组函数 (TODO) | 参考 SQL 手册纠正 |
  | 0x260D | 标签数量不匹配 | 参考 SQL 手册纠正 |
  | 0x260E | 无效的标签名 | 改用正确的标签名 |
  | 0x2610 | 名字或密码过长 | 参考 SQL 手册纠正 |
  | 0x2611 | 密码不能为空 | 提供非空密码 |
  | 0x2612 | 端口无效 | 端口号必须在 (0,65535) 范围内 |
  | 0x2613 | 地址格式错误 | 正确格式是 "fqdn: port" |
  | 0x2614 | 该语句不再支持 | 参考 SQL 手册纠正 |
  | 0x2615 | 时间窗口过小 | 参考 SQL 手册纠正 |
  | 0x2616 | 未指定数据库 | 在表名或超级表名前添加 "<dbname\>." 指定数据库 |
  | 0x2617 | 标识符无效 | 参考 SQL 手册纠正 |
  | 0x2618 | 该数据库中不存在对应的超级表 | 使用正确的数据库名或者超级表名 |
  | 0x2619 | 数据库参数无效 | 参考 SQL 手册纠正 |
  | 0x261A | 建表参数无效 | 参考 SQL 手册纠正 |
  | 0x2624 | GROUP BY 和 窗口子句不能共用 | 参考 SQL 手册纠正 |
  | 0x2627 | 聚合函数不支持嵌套 | 参考 SQL 手册纠正 |
  | 0x2628 | 在 integer/bool/varchar 类型的列上只支持 状态窗口 | 参考 SQL 手册纠正 |
  | 0x2629 | 标签列上不支持状态窗口 | 参考 SQL 手册纠正 |
  | 0x262A | 状态窗口查询不支持超级表 | 参考 SQL 手册纠正 |
  | 0x262B | 会话之间的 gap 应该是大于 0 的固定大小的窗口 | 参考 SQL 手册纠正 |
  | 0x262C | 只在主键时间戳列上支持会话 | 参考 SQL 手册纠正 |
  | 0x262D | 窗口偏移量不能是负值 | 参考 SQL 手册纠正 |
  | 0x262E | 当 interval 的单位是 "year" 时 offset 的单位不能是 "month" | 参考 SQL 手册纠正 |
  | 0x262F | offset 所指定的时间长度应该小于 interval 所指定的时间长度 | 参考 SQL 手册纠正 |
  | 0x2630 | 当 interval 是自然年/月时不能使用 slidig | 参考 SQL 手册纠正 |
  | 0x2631 | sliding 所指定的时间长度不能大于 interval 所指定的时间长度 | 参考 SQL 手册纠正 |
  | 0x2632 | sliding 不能小于 interval 的 1%% | 参考 SQL 手册纠正 |
  | 0x2633 | 当使用 JSON 类型的 tag 时只允许这一个 tag 的存在 | 去除其它 tag |
  | 0x2634 | 查询块中包含的结果列的数量不正确  | TODO |
  | 0x2635 | 时间戳不正确 | TODO |
  | 0x2637 | offset/soffset 不能小于 0 | 纠正 offset/soffset |
  | 0x2638 | offset/soffset 只能用于 partition by | 参考 SQL 手册纠正 |
  | 0x2639 | 无效的 topic 查询 | TODO |
  | 0x263A | 不能批量删除超级表 | 请逐个删除 |
  | 0x263B | 查询时间范围未指定起止时间或者时间范围过大 | 参考 SQL 手册纠正 |
  | 0x263C | 重复的列表 | 参考 SQL 手册纠正 |
  | 0x263D | 标签长度超过上限 | 参考 SQL 手册纠正 |
  | 0x263E | 行长度超过上限 | 参考 SQL 手册纠正 |
  | 0x263F | 不合法的列数量 | 参考 SQL 手册纠正 |
  | 0x2640 | 列数过多 | 参考 SQL 手册纠正 |
  | 0x2641 | 首列必须是时间戳 | 参考 SQL 手册纠正 |
  | 0x2642 | binary/nchar 类型的列长度无效 | 参考 SQL 手册纠正 |
  | 0x2643 | 标签列数量无效 | 参考 SQL 手册纠正 |
  | 0x2644 | 无权进行该操作 | 参考 SQL 手册纠正 |
  | 0x2645 | 无效的流查询 | 参考 SQL 手册纠正 |
  | 0x2646 | 无效的 _c0 或 _rowts 表达式 | 参考 SQL 手册纠正 |
  | 0x2647 | 无效的时间线函数  | 参考 SQL 手册纠正 |
  | 0x2648 | 无效的密码 | 参考 SQL 手册纠正 |
  | 0x2649 | 无效的 alter table 语句  | 参考 SQL 手册纠正 |
  | 0x264A | 不能删除时间戳主列 | 参考 SQL 手册纠正 |
  | 0x264B | 只有 binary/nchar 类型的列能够修改长度 | 参考 SQL 手册纠正 |
  | 0x264C | 无效的 tbname 伪列 | 参考 SQL 手册纠正 |
  | 0x264D | 无效的函数名 | 参考 SQL 手册纠正 |
  | 0x264E | 注释过长 | 参考 SQL 手册纠正 |
  | 0x264F | 有些函数只能用在查询的 SELECT 列表中，且不能与其它非标量函数或列混用 | 参考 SQL 手册纠正 |
  | 0x2650 | 不支持窗口查询，因为子查询的结果不包含时间戳列 | 参考 SQL 手册纠正 |
  | 0x2651 | 任何列都不能被删除  | 参考 SQL 手册纠正 |
  | 0x2652 | 只有 标签列可以是 JSON 类型 | 参考 SQL 手册纠正 |
  | 0x2653 | 列或标签的值过长 | 参考 SQL 手册纠正 |
  | 0x2655 | DELETE 语句必须有一个确定的时间范围 | 参考 SQL 手册纠正 |
  | 0x2656 | REDISTRIBUTE VGROUP 语句只支持 1 到 3 个 vgroup | 参考 SQL 手册纠正 |
  | 0x2657 | 不支持 Fill | 参考 SQL 手册纠正 |
  | 0x2658 | 无效的窗口伪列 | 参考 SQL 手册纠正 |
  | 0x2659 | 不允许做窗口查询: TODO   | 参考 SQL 手册纠正 |
  | 0x265A | 不允许做流计算: TODO  | 参考 SQL 手册纠正 |
  | 0x265B | 不允许做 Group By | 参考 SQL 手册纠正 |
  | 0x265D | interp 子句错误  | 参考 SQL 手册纠正 |
  | 0x265E | 窗口查询中不支持该函数 | 参考 SQL 手册纠正 |
  | 0x265F | 只支持单表 | 参考 SQL 手册纠正 |
  | 0x2660 | 无效的 SMA 索引  | 参考 SQL 手册纠正 |
  | 0x2661 | 无效的 SELECT 表达式 | 参考 SQL 手册纠正 |
  | 0x2662 | 获取表的元数据失败 | TODO |
  | 0x2663 | 表名/表名不唯一 | 参考 SQL 手册纠正 |
  | 0x266F | 解析器内部错误 | TODO |
  | 0x2700 | 计划器内部错误 | TODO |
  | 0x2701 | TODO | TODO |
  | 0x2702 | 不支持 cross join | 参考 SQL 手册纠正 |
  | 0x2800 | 函数内部错误 | 参考 SQL 手册纠正 |
  | 0x2801 | 函数参数个数错误 | 参考 SQL 手册纠正 |
  | 0x2802 | 函数参数类型错误 | 参考 SQL 手册纠正 |
  | 0x2803 | 函数参数值错误 | 参考 SQL 手册纠正 |
  | 0x2804 | 非内置函数 | 参考 SQL 手册纠正 |
  | 0x2901 | UDF 正在停止 | TODO |
  | 0x2902 | UDF 管道读取错误 | TODO |
  | 0x2903 | UDF 连接错误  | TODO |
  | 0x2904 | UDF 管道缺失 | TODO |
  | 0x2905 | UDF 加载失败 | TODO |
  | 0x2906 | UDF 无效状态 | TODO |
  | 0x2907 | UDF 无效输入 | TODO |
  | 0x2908 | UDF 没有函数句柄 | TODO |
  | 0x2909 | UDF 无效的 bufsize | TODO |
  | 0x290A | UDF 无效的输出类型 | TODO |
  | 0x3000 | 无效的行协议类型 | 修正数据中的协议类型 |
  | 0x3001 | 无效的时间戳精度类型 | 修正时间戳精度类型 |
  | 0x3002 | 无效的数据格式 | 修正数据格式 |
  | 0x3003 | 无效的无模式数据库配置 | 修改配置 |
  | 0x3004 | 写入类型与之前的不同 | 修正写入类型 |
  | 0x3100 | TSMA 初始化失败 | TODO |
  | 0x3101 | TSMA 已经存在 | 放弃重复建立 TSMA |
  | 0x3102 | 元数据中没有 TSMA 索引 | TODO |
  | 0x3103 | 无效的 TSMA 环境 | TODO |
  | 0x3104 | 无效的 TSMA 状态  | TODO |
  | 0x3105 | 无效的 TSMA 指针 | TODO |
  | 0x3106 | 无效的 TSMA 参数 | 参考 SQL 手册纠正 |
  | 0x3107 | cache 中没有该 TSMA 的索引  | TODO |
  | 0x3150 | 无效的 RSMA 索引  | TODO |
  | 0x3151 | 无效的 RSMA 状态 | TODO |
  | 0x3152 | RSMA 创建 qtaskinfo 失败 | TODO |
  | 0x3153 | RSMA 文件被破坏 | TODO |
  | 0x3200 | 索引正在重建中 |TODO |
  | 0x3201 | 无效的索引文件  | TODO |
  | 0x4000 | 无效消息 | TODO |