/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 469
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOperatorType yy2;
  SNode* yy42;
  bool yy103;
  EOrder yy106;
  SNodeList* yy110;
  SToken yy225;
  EFillMode yy410;
  SDataType yy448;
  SAlterOption yy459;
  int32_t yy508;
  ENullOrder yy599;
  EJoinType yy638;
  int64_t yy641;
  int8_t yy705;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             741
#define YYNRULE              562
#define YYNTOKEN             328
#define YY_MAX_SHIFT         740
#define YY_MIN_SHIFTREDUCE   1099
#define YY_MAX_SHIFTREDUCE   1660
#define YY_ERROR_ACTION      1661
#define YY_ACCEPT_ACTION     1662
#define YY_NO_ACTION         1663
#define YY_MIN_REDUCE        1664
#define YY_MAX_REDUCE        2225
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2749)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1937, 2201, 1796,  605,  480, 2196,  481, 1700,  489, 1807,
 /*    10 */   481, 1700,   45,   43, 1588, 1935,  617,   31,  176,  178,
 /*    20 */   378, 2200, 1437,   38,   37, 2197, 2199,   44,   42,   41,
 /*    30 */    40,   39, 1858, 1518,  140, 1435, 1462, 2037, 1871,  346,
 /*    40 */  1920, 2023,   38,   37,  611,  356,   44,   42,   41,   40,
 /*    50 */    39,  423, 2019, 2201, 1869,   38,   37, 2196, 1513,   44,
 /*    60 */    42,   41,   40,   39,   18,  498,  383, 1465, 2055, 1864,
 /*    70 */  1866, 1443, 1662, 2200,  167,  605,  644, 2197, 2198, 1772,
 /*    80 */  1151, 2005, 1150,  646,   45,   43, 2015, 2021,  359,  568,
 /*    90 */  1132,  329,  378, 2196, 1437,  220,   14,  640,  339,  181,
 /*   100 */  2133, 2134,  548,  138, 2138, 1518,  140, 1435, 2202,  182,
 /*   110 */   600, 1152, 2036, 2197,  594,  546, 2072,  544,  737,  323,
 /*   120 */  2038,  650, 2040, 2041,  645,  643,  640,  631, 2090, 1134,
 /*   130 */  1513, 1137, 1138, 1520, 1521,  629,   18,  479,  391, 1547,
 /*   140 */   484, 1706,  390, 1443, 1687, 1259,  672,  671,  670, 1263,
 /*   150 */   669, 1265, 1266,  668, 1268,  665,  176, 1274,  662, 1276,
 /*   160 */  1277,  659,  656, 1493, 1503, 1937,  605,  615,   14, 1519,
 /*   170 */  1522,  266, 2133,  604,  381,  133,  603,  369, 1921, 2196,
 /*   180 */  1934,  617,  161,  568, 1438,  616, 1436, 2196, 2005,  357,
 /*   190 */   737, 1820,  629,  269,  592,  182, 1548,  140, 1869, 2197,
 /*   200 */   594,  498, 2202,  182,  629, 1520, 1521, 2197,  594,  588,
 /*   210 */  1441, 1442,  246, 1492, 1495, 1496, 1497, 1498, 1499, 1500,
 /*   220 */  1501, 1502,  642,  638, 1511, 1512, 1514, 1515, 1516, 1517,
 /*   230 */     2,   61,  496,   92, 1930, 1493, 1503,  583,  106,  684,
 /*   240 */   122, 1519, 1522,  121,  120,  119,  118,  117,  116,  115,
 /*   250 */   114,  113,  141, 1592,  350,  166, 1438, 1676, 1436, 1462,
 /*   260 */  1810,  607,  180, 2133, 2134, 1461,  138, 2138,   48,   34,
 /*   270 */   376, 1542, 1543, 1544, 1545, 1546, 1550, 1551, 1552, 1553,
 /*   280 */    48,   61, 1441, 1442, 1219, 1492, 1495, 1496, 1497, 1498,
 /*   290 */  1499, 1500, 1501, 1502,  642,  638, 1511, 1512, 1514, 1515,
 /*   300 */  1516, 1517,    2, 2023,   11,   45,   43,   44,   42,   41,
 /*   310 */    40,   39, 1462,  378, 2019, 1437,  351,  740,  349,  348,
 /*   320 */  1221,  521,  589,  584,  577,  523, 1518, 1462, 1435,  488,
 /*   330 */  2037,  294,  484, 1706,  605,   35,  287,   38,   37,  601,
 /*   340 */   410,   44,   42,   41,   40,   39,  175,  522, 2015, 2021,
 /*   350 */   360, 1513,  730,  726,  722,  718,  292,   18,   86,  640,
 /*   360 */   486, 2055,  412,  408, 1443,  140,  482,  557,  415,  647,
 /*   370 */   414, 2140,  136, 1151, 2005, 1150,  646,   45,   43, 1523,
 /*   380 */  1463, 1813, 2201,  185,   11,  378,    9, 1437,   61,   14,
 /*   390 */   278,  279,   65,  107,  413,  277,  285, 2137, 1518, 1464,
 /*   400 */  1435,  632, 1494, 2097, 1152, 2036, 1733,  630, 1686, 2072,
 /*   410 */   630,  737,  168, 2038,  650, 2040, 2041,  645, 1665,  640,
 /*   420 */   185,  132,  676, 1513,  187, 1862, 1520, 1521,  519,  626,
 /*   430 */   183, 2133, 2134,  185,  138, 2138, 1443,  630, 1818,  122,
 /*   440 */    11, 1818,  121,  120,  119,  118,  117,  116,  115,  114,
 /*   450 */   113,  132, 2005,  569, 2162,  194, 1493, 1503,  524, 1871,
 /*   460 */   100,   46, 1519, 1522,  272,  634,  366, 2097, 1818,  271,
 /*   470 */  1357, 1358,  534,  533,  532, 1869, 1650, 1438, 2026, 1436,
 /*   480 */   137,  528, 1811,  737,   61,  527, 1401,  461,  240, 1901,
 /*   490 */   526,  531,   83, 1302, 1303,   82,  525,  236, 1520, 1521,
 /*   500 */  1865, 1866, 1463, 1441, 1442, 1657, 1492, 1495, 1496, 1497,
 /*   510 */  1498, 1499, 1500, 1501, 1502,  642,  638, 1511, 1512, 1514,
 /*   520 */  1515, 1516, 1517,    2,  534,  533,  532, 2028, 1493, 1503,
 /*   530 */  1664, 1871,  137,  528, 1519, 1522,  630,  527,  344,  630,
 /*   540 */   185, 1464,  526,  531,  268,  198,  197, 1869,  525, 1438,
 /*   550 */    54, 1436,  616,  421,  131,  130,  129,  128,  127,  126,
 /*   560 */   125,  124,  123, 1412, 1413,  417, 1181, 1818,  460,  416,
 /*   570 */  1818,   41,   40,   39, 2037, 1441, 1442,  616, 1492, 1495,
 /*   580 */  1496, 1497, 1498, 1499, 1500, 1501, 1502,  642,  638, 1511,
 /*   590 */  1512, 1514, 1515, 1516, 1517,    2,   45,   43, 1446,  614,
 /*   600 */  1916, 1930, 1182, 1656,  378, 2055, 1437,  630,  593,  630,
 /*   610 */   568,  190, 2196,  647, 2196, 1374, 1375, 1518, 2005, 1435,
 /*   620 */   646,  422,  221,  431,  625,   61, 1930,  592,  182, 2202,
 /*   630 */   182,   49, 2197,  594, 2197,  594,  185,  171, 1818, 1685,
 /*   640 */  1818,  441, 1513,  515,  511,  507,  503,  218,  630, 2036,
 /*   650 */   440, 1373, 1376, 2072, 1616, 1443,  110, 2038,  650, 2040,
 /*   660 */  2041,  645,  446,  640,  424,  370, 1528, 1684,   45,   43,
 /*   670 */  2125, 1465, 1462,  164, 2124, 2121,  378,  425, 1437, 1818,
 /*   680 */    46,  539, 1820, 2005,   87, 1683,  268,  216, 1443, 1518,
 /*   690 */  1682, 1435,  142,   38,   37, 2096,  549,   44,   42,   41,
 /*   700 */    40,   39,  737,  580,  579, 1614, 1615, 1617, 1618, 1619,
 /*   710 */   234, 2005, 1871, 1809, 1513,   38,   37, 1520, 1521,   44,
 /*   720 */    42,   41,   40,   39, 2019,  542,   33, 1443, 1870, 2005,
 /*   730 */   536, 1795,   38,   37, 2005,  233,   44,   42,   41,   40,
 /*   740 */    39, 1681,  593, 1680, 1679, 1549, 2196, 1493, 1503, 1449,
 /*   750 */   630,   27,   14, 1519, 1522,  215,  209,  675, 2015, 2021,
 /*   760 */   214,  592,  182,  494,  447, 1803, 2197,  594, 1438,  640,
 /*   770 */  1436,  164,   69, 1678,  737,   68, 2055,  185, 1675,  207,
 /*   780 */  1821, 1818, 1627,  185,  587, 2005, 1974, 2005, 2005, 1520,
 /*   790 */  1521, 1674,   13,   12, 1441, 1442,  696, 1492, 1495, 1496,
 /*   800 */  1497, 1498, 1499, 1500, 1501, 1502,  642,  638, 1511, 1512,
 /*   810 */  1514, 1515, 1516, 1517,    2, 1494,  191, 2005,   32, 1493,
 /*   820 */  1503,  332, 2005, 1460,  682, 1519, 1522,  235, 1554,  586,
 /*   830 */   454,   86,  237,  468, 1871, 2005,  467, 1137, 1138,  682,
 /*   840 */  1438,  371, 1436,  154,  153,  679,  678,  677,  151, 1673,
 /*   850 */  1869,  437, 1465,  469, 1814, 1794,  439, 1916,  154,  153,
 /*   860 */   679,  678,  677,  151,  530,  529, 1441, 1442,  192, 1492,
 /*   870 */  1495, 1496, 1497, 1498, 1499, 1500, 1501, 1502,  642,  638,
 /*   880 */  1511, 1512, 1514, 1515, 1516, 1517,    2,  381, 1561,  563,
 /*   890 */    89,  334,  165, 2005,  355,  164,  550,  307,  347, 1730,
 /*   900 */   630,   38,   37, 1793, 1820,   44,   42,   41,   40,   39,
 /*   910 */   427,  305,   72, 1805,  497,   71, 1672,    8,  684,   38,
 /*   920 */    37, 1871,  384,   44,   42,   41,   40,   39,  382,  301,
 /*   930 */   164, 1818, 1848,  203,  476,  474,  471, 1869, 2140, 1820,
 /*   940 */   465,  708,  706,  459,  458,  457,  456,  453,  452,  451,
 /*   950 */   450,  449,  445,  444,  443,  442,  331,  434,  433,  432,
 /*   960 */  2005,  429,  428,  345, 2136,  714,  713,  712,  711,  388,
 /*   970 */    61,  710,  709,  144,  704,  703,  702,  701,  700,  699,
 /*   980 */   698,  156,  694,  693,  692,  387,  386,  689,  688,  687,
 /*   990 */   686,  685,  630,  630, 1671,   38,   37,  245, 1998,   44,
 /*  1000 */    42,   41,   40,   39, 1437,  630, 1815,  238, 1604,  108,
 /*  1010 */  2037,  682, 2200,  630,  630,  630, 1585, 1435,  697,  627,
 /*  1020 */  1788, 1670, 1669, 1818, 1818, 1668, 1667,  628,  564,  609,
 /*  1030 */   154,  153,  679,  678,  677,  151, 1818, 1916, 2005,  523,
 /*  1040 */    51, 2055,    3,  568, 1818, 1818, 1818, 2196,  196,  608,
 /*  1050 */    80,   79,  420, 1443, 2005,  189,  646,  630,  163, 2037,
 /*  1060 */  2140,  522, 2202,  182,  152, 2005, 2005, 2197,  594, 2005,
 /*  1070 */  2005,  613,  680, 2023,  330, 1862, 1462,  406,   73,  404,
 /*  1080 */   400,  396,  393,  413, 2019, 2036, 2135,  244, 1818, 2072,
 /*  1090 */  2055, 2024,  109, 2038,  650, 2040, 2041,  645,  647,  640,
 /*  1100 */   737,  597, 2019, 2005,  179,  646, 2125, 2145, 1581,  630,
 /*  1110 */   372, 2121,  681, 1991,  146, 1862,  134,   53, 2015, 2021,
 /*  1120 */   373,  630,  185,  282,  184, 1581, 2037,   90,   81,  640,
 /*  1130 */  1999, 1801, 2151,  152, 2036,  288, 2015, 2021, 2072,  674,
 /*  1140 */  1818,  109, 2038,  650, 2040, 2041,  645,  640,  640,  630,
 /*  1150 */   152,  143, 1818,  149, 2096, 2125,  241, 2055, 2037,  372,
 /*  1160 */  2121,  398, 1720,  385,  226,  608, 1438,  224, 1436, 1713,
 /*  1170 */  2005,  228,  646,  230,  227,  568,  229,   63,  232, 2196,
 /*  1180 */  1818,  231,   63,  250,  535,  552, 1407,  551,  637, 2055,
 /*  1190 */  1677,  537, 1441, 1442, 2202,  182, 1711,  647,  641, 2197,
 /*  1200 */   594, 2036, 2005, 1410,  646, 2072, 1445, 2037,  109, 2038,
 /*  1210 */   650, 2040, 2041,  645,   52,  640, 1659, 1660,  540, 1494,
 /*  1220 */   179,  567, 2125,  152,   47, 1707,  372, 2121,  275, 2165,
 /*  1230 */  1613,   70,  150, 2036,  152, 1612,  252, 2072, 2055, 1773,
 /*  1240 */   109, 2038,  650, 2040, 2041,  645,  647,  640, 2152,   13,
 /*  1250 */    12, 2005, 2216,  646, 2125,  105,   63,  555,  372, 2121,
 /*  1260 */    47, 1584,   47,  654,  150,  102, 2037,  263,  581, 2159,
 /*  1270 */   219,  152,  135,  690,  732,  257,  612, 1371,  596,  150,
 /*  1280 */  2056,  280, 2036,  389,  622,  284, 2072, 1252, 1701,  109,
 /*  1290 */  2038,  650, 2040, 2041,  645, 1200,  640, 2055,  691, 1925,
 /*  1300 */  2037, 2216,  568, 2125, 1859,  647, 2196,  372, 2121, 1555,
 /*  1310 */  2005, 2155,  646, 1504,  606,  300, 1280, 1284, 2172,  265,
 /*  1320 */  1198, 2202,  182,  262, 1291, 1289, 2197,  594,  598,    1,
 /*  1330 */     4, 2055,  155,  392, 1539,  397, 1394,  295,  195,  647,
 /*  1340 */   343, 2036,  426, 1465, 2005, 2072,  646, 1926,  109, 2038,
 /*  1350 */   650, 2040, 2041,  645,  430,  640,  463, 1448,  435, 1460,
 /*  1360 */  2216,  448, 2125, 1918,  462,  455,  372, 2121,  464,  470,
 /*  1370 */   472,  200,  473, 2037,  475, 2036,  477,  575, 1466, 2072,
 /*  1380 */   478,  487,  109, 2038,  650, 2040, 2041,  645, 1468,  640,
 /*  1390 */   206,  490,  375,  374, 2216, 1463, 2125,  208,  491, 1467,
 /*  1400 */   372, 2121, 1451,  492, 2055, 1469,  493,  211,  495,  499,
 /*  1410 */   213, 2190,  647, 1518,   84, 1444, 1154, 2005,  518,  646,
 /*  1420 */    85,  217, 2037,  516,  517,  112,  333,   88,  520, 1808,
 /*  1430 */  1980,  554,  556, 1979,  148,  296,  223,  239, 1513, 1804,
 /*  1440 */   558,  225,  242,  559,  565, 2156,  157,  582, 2036,  158,
 /*  1450 */  1806, 1443, 2072, 2055, 1802,  109, 2038,  650, 2040, 2041,
 /*  1460 */   645,  647,  640,  159,  160, 2171, 2005, 2216,  646, 2125,
 /*  1470 */   620,  572,  562,  372, 2121, 2166,    7, 2170,  578,  361,
 /*  1480 */   591,  571,  585,  573, 2144, 2147, 2037,  248,  251,  256,
 /*  1490 */   172,  570,  258,  259, 2219,  139,  260, 2036,  636,  362,
 /*  1500 */   264, 2072,  602,  599,  109, 2038,  650, 2040, 2041,  645,
 /*  1510 */  1581,  640, 1464, 2195,  610,  270, 2100, 2055, 2125,  261,
 /*  1520 */  2141,  365,  372, 2121, 1470,  647,   95,  297, 1931,  623,
 /*  1530 */  2005,  618,  646,  619,  298, 1945, 1944,  624, 1943,  368,
 /*  1540 */    97,   99,   60,  299, 1819, 2106,  101, 1789,  652,  291,
 /*  1550 */   302, 1863,  733,  326, 2037,  734,  311,  335,  336,  736,
 /*  1560 */   325, 2036,   50,  315, 1452, 2072, 1447,  306,  109, 2038,
 /*  1570 */   650, 2040, 2041,  645, 1997,  640, 1996, 1995,  304,   77,
 /*  1580 */  2098, 1992, 2125,  394, 2037, 2055,  372, 2121,  395, 1428,
 /*  1590 */  1455, 1457, 1429,  647,  188,  399, 1990,  401, 2005,  402,
 /*  1600 */   646,  403, 1989,  638, 1511, 1512, 1514, 1515, 1516, 1517,
 /*  1610 */   405, 1988, 1987,  407, 2037, 2055,  409, 1986,   78,  411,
 /*  1620 */  1397, 1396, 1957,  647, 1956, 1955, 1954,  418, 2005, 2036,
 /*  1630 */   646,  419, 1953, 2072, 1348, 1909,  109, 2038,  650, 2040,
 /*  1640 */  2041,  645, 1908,  640, 2037, 2055, 1906,  145,  633, 1905,
 /*  1650 */  2125, 1904, 1907,  647,  372, 2121, 1903, 1902, 2005, 2036,
 /*  1660 */   646, 1900, 1899, 2072,  193,  436,  110, 2038,  650, 2040,
 /*  1670 */  2041,  645, 1898,  640, 1897, 2055,  438, 1911, 2037, 1896,
 /*  1680 */  2125, 1895, 1894,  647,  635, 2121, 1893, 1892, 2005,  648,
 /*  1690 */   646, 1891, 1890, 2072, 1889, 1888,  110, 2038,  650, 2040,
 /*  1700 */  2041,  645, 1887,  640, 1886, 2037, 1885, 1884, 1883, 2055,
 /*  1710 */  2125, 1882,  147, 1881,  338, 2121, 1880,  647, 1879, 2036,
 /*  1720 */  1910, 1878, 2005, 2072,  646, 1877,  169, 2038,  650, 2040,
 /*  1730 */  2041,  645, 1350,  640, 1876, 1875, 2055, 1874, 1873,  466,
 /*  1740 */  1872, 1736,  199, 1735,  647, 1734,  201, 1227,  202, 2005,
 /*  1750 */  1732,  646, 2025, 2036, 2037, 1696,  204, 2072,   75,  177,
 /*  1760 */   168, 2038,  650, 2040, 2041,  645, 1695,  640, 1140,  483,
 /*  1770 */  1139,  485,  205, 1970, 1964,   76, 1952, 1951,  595, 2217,
 /*  1780 */  2036,  210,  212, 1929, 2072, 2055, 1797,  110, 2038,  650,
 /*  1790 */  2040, 2041,  645,  647,  640, 1174, 1731, 1729, 2005,  500,
 /*  1800 */   646, 2125, 2163, 1727,  502,  501, 2122,  504,  505,  506,
 /*  1810 */  1725,  509, 1723,  508,  510,  512, 2037,  513, 1710, 1709,
 /*  1820 */   514, 1692, 1799, 1296, 1295, 1798, 1218, 1217,   62, 2036,
 /*  1830 */   222,  705, 1721, 2072, 1216, 1215,  317, 2038,  650, 2040,
 /*  1840 */  2041,  645,  707,  640, 1212, 1210, 1211, 2055, 2037, 1209,
 /*  1850 */   352, 1714,  353, 1712,  538,  647,  354, 1691, 1690,  541,
 /*  1860 */  2005,  543,  646, 1689,  545,  547,  111,   26, 1417, 1969,
 /*  1870 */  1418, 1416, 1403, 1963,   55, 1950,  560, 1948,   66, 2055,
 /*  1880 */   590, 1420,  561,  162,  367, 2201,   19,  647,   16,   28,
 /*  1890 */   247, 2036, 2005,  243,  646, 2072,  358, 2037,  169, 2038,
 /*  1900 */   650, 2040, 2041,  645, 1629,  640,  566,  574,   58,  576,
 /*  1910 */   249,    5,   59, 1611, 2037,  254,    6, 1603,   20,  255,
 /*  1920 */    30, 2026,   64, 2036, 1649,   17, 1644, 2072, 2055,   21,
 /*  1930 */   324, 2038,  650, 2040, 2041,  645,  644,  640, 1650, 1643,
 /*  1940 */   170, 2005,  363,  646,  253, 2055, 2037, 1648,   29, 1647,
 /*  1950 */   377, 2218,   91,  647,   57,  364, 1578, 1577, 2005, 1949,
 /*  1960 */   646, 1947, 1946,  267,  173, 1928,   93,   94,  273, 1927,
 /*  1970 */    96, 2037, 2036,  621,   56,   22, 2072, 2055,   23,  323,
 /*  1980 */  2038,  650, 2040, 2041,  645,  647,  640,  274, 2091, 2036,
 /*  1990 */  2005, 1609,  646, 2072,  102, 2037,  324, 2038,  650, 2040,
 /*  2000 */  2041,  645, 2055,  640,  276,  281,  283,  379,   12,   67,
 /*  2010 */   647,  286, 1453,  174,   98, 2005, 1530,  646, 1540, 2075,
 /*  2020 */  2037,  553,   10, 1508, 1506, 2072, 2055, 1505,  319, 2038,
 /*  2030 */   650, 2040, 2041,  645,  647,  640,  639, 1529,   36, 2005,
 /*  2040 */    15,  646,   24,  649,  186, 1477, 2036, 1485,   25,  653,
 /*  2050 */  2072, 2055,  651,  324, 2038,  650, 2040, 2041,  645,  647,
 /*  2060 */   640,  380,  657,  655, 2005, 1281,  646, 1278, 1275,  658,
 /*  2070 */  2036,  660,  661,  663, 2072, 1269,  664,  308, 2038,  650,
 /*  2080 */  2040, 2041,  645, 2037,  640, 1267,  666,  667, 1258,  103,
 /*  2090 */   673,  289, 1290, 1286, 1273, 2036,  104, 1272,   74, 2072,
 /*  2100 */  1172, 1271,  309, 2038,  650, 2040, 2041,  645,  683,  640,
 /*  2110 */  2037, 1206, 1270, 1205, 2055, 1204, 1203, 1202, 1201, 1225,
 /*  2120 */  1199, 1197,  647, 1196, 1195,  695, 1193, 2005, 1192,  646,
 /*  2130 */  1191,  290, 2037, 1189, 1190, 1188, 1187, 1220, 1222, 1184,
 /*  2140 */  1183, 2055, 1180, 1179, 1178, 1177, 1728,  716,  715,  647,
 /*  2150 */  1726,  719, 1724,  717, 2005, 1722,  646,  720, 2036,  721,
 /*  2160 */   723, 1708, 2072, 2055,  727,  310, 2038,  650, 2040, 2041,
 /*  2170 */   645,  647,  640,  725,  724,  728, 2005,  729,  646,  731,
 /*  2180 */  1129, 1688,  293,  735,  738, 2036, 1439,  303,  739, 2072,
 /*  2190 */  1663, 1663,  316, 2038,  650, 2040, 2041,  645, 1663,  640,
 /*  2200 */  1663, 1663, 1663, 1663, 1663, 1663, 1663, 2036, 1663, 1663,
 /*  2210 */  1663, 2072, 2037, 1663,  320, 2038,  650, 2040, 2041,  645,
 /*  2220 */  1663,  640, 1663, 1663, 1663, 1663, 1663, 1663, 1663, 2037,
 /*  2230 */  1663, 1663, 1663, 1663, 1663, 1663, 1663, 1663, 1663, 1663,
 /*  2240 */  1663, 1663, 1663, 2055, 1663, 1663, 2037, 1663, 1663, 1663,
 /*  2250 */  1663,  647, 1663, 1663, 1663, 1663, 2005, 1663,  646, 1663,
 /*  2260 */  2055, 1663, 1663, 1663, 1663, 1663, 1663, 1663,  647, 1663,
 /*  2270 */  1663, 1663, 1663, 2005, 1663,  646, 1663, 2055, 2037, 1663,
 /*  2280 */  1663, 1663, 1663, 1663, 1663,  647, 1663, 2036, 1663, 1663,
 /*  2290 */  2005, 2072,  646, 1663,  312, 2038,  650, 2040, 2041,  645,
 /*  2300 */  1663,  640, 1663, 2037, 2036, 1663, 1663, 1663, 2072, 2055,
 /*  2310 */  1663,  321, 2038,  650, 2040, 2041,  645,  647,  640, 1663,
 /*  2320 */  1663, 2036, 2005, 1663,  646, 2072, 1663, 2037,  313, 2038,
 /*  2330 */   650, 2040, 2041,  645, 2055,  640, 1663, 1663, 1663, 1663,
 /*  2340 */  1663, 1663,  647, 1663, 1663, 1663, 1663, 2005, 1663,  646,
 /*  2350 */  1663, 1663, 2037, 2036, 1663, 1663, 1663, 2072, 2055, 1663,
 /*  2360 */   322, 2038,  650, 2040, 2041,  645,  647,  640, 1663, 1663,
 /*  2370 */  1663, 2005, 1663,  646, 1663, 1663, 1663, 1663, 2036, 1663,
 /*  2380 */  1663, 1663, 2072, 2055, 1663,  314, 2038,  650, 2040, 2041,
 /*  2390 */   645,  647,  640, 1663, 1663, 1663, 2005, 1663,  646, 1663,
 /*  2400 */  1663, 1663, 2036, 1663, 1663, 1663, 2072, 1663, 1663,  327,
 /*  2410 */  2038,  650, 2040, 2041,  645, 2037,  640, 1663, 1663, 1663,
 /*  2420 */  1663, 1663, 1663, 1663, 1663, 1663, 1663, 2036, 1663, 1663,
 /*  2430 */  1663, 2072, 1663, 1663,  328, 2038,  650, 2040, 2041,  645,
 /*  2440 */  1663,  640, 2037, 1663, 1663, 1663, 2055, 1663, 1663, 1663,
 /*  2450 */  1663, 1663, 1663, 1663,  647, 1663, 1663, 1663, 1663, 2005,
 /*  2460 */  1663,  646, 1663, 1663, 2037, 1663, 1663, 1663, 1663, 1663,
 /*  2470 */  1663, 1663, 1663, 2055, 1663, 1663, 1663, 1663, 1663, 1663,
 /*  2480 */  1663,  647, 1663, 1663, 1663, 1663, 2005, 1663,  646, 1663,
 /*  2490 */  2036, 1663, 1663, 1663, 2072, 2055, 1663, 2049, 2038,  650,
 /*  2500 */  2040, 2041,  645,  647,  640, 1663, 1663, 1663, 2005, 1663,
 /*  2510 */   646, 1663, 1663, 1663, 1663, 1663, 1663, 2036, 1663, 1663,
 /*  2520 */  1663, 2072, 1663, 1663, 2048, 2038,  650, 2040, 2041,  645,
 /*  2530 */  1663,  640, 1663, 1663, 1663, 1663, 1663, 1663, 1663, 2036,
 /*  2540 */  1663, 1663, 1663, 2072, 2037, 1663, 2047, 2038,  650, 2040,
 /*  2550 */  2041,  645, 1663,  640, 1663, 1663, 1663, 1663, 1663, 1663,
 /*  2560 */  1663, 2037, 1663, 1663, 1663, 1663, 1663, 1663, 1663, 1663,
 /*  2570 */  1663, 1663, 1663, 1663, 1663, 2055, 1663, 1663, 2037, 1663,
 /*  2580 */  1663, 1663, 1663,  647, 1663, 1663, 1663, 1663, 2005, 1663,
 /*  2590 */   646, 1663, 2055, 1663, 1663, 1663, 1663, 1663, 1663, 1663,
 /*  2600 */   647, 1663, 1663, 1663, 1663, 2005, 1663,  646, 1663, 2055,
 /*  2610 */  2037, 1663, 1663, 1663, 1663, 1663, 1663,  647, 1663, 2036,
 /*  2620 */  1663, 1663, 2005, 2072,  646, 1663,  340, 2038,  650, 2040,
 /*  2630 */  2041,  645, 1663,  640, 1663, 2037, 2036, 1663, 1663, 1663,
 /*  2640 */  2072, 2055, 1663,  341, 2038,  650, 2040, 2041,  645,  647,
 /*  2650 */   640, 1663, 1663, 2036, 2005, 1663,  646, 2072, 1663, 2037,
 /*  2660 */   337, 2038,  650, 2040, 2041,  645, 2055,  640, 1663, 1663,
 /*  2670 */  1663, 1663, 1663, 1663,  647, 1663, 1663, 1663, 1663, 2005,
 /*  2680 */  1663,  646, 1663, 1663, 1663, 2036, 1663, 1663, 1663, 2072,
 /*  2690 */  2055, 1663,  342, 2038,  650, 2040, 2041,  645,  647,  640,
 /*  2700 */  1663, 1663, 1663, 2005, 1663,  646, 1663, 1663, 1663, 1663,
 /*  2710 */   648, 1663, 1663, 1663, 2072, 1663, 1663,  319, 2038,  650,
 /*  2720 */  2040, 2041,  645, 1663,  640, 1663, 1663, 1663, 1663, 1663,
 /*  2730 */  1663, 1663, 1663, 1663, 2036, 1663, 1663, 1663, 2072, 1663,
 /*  2740 */  1663,  318, 2038,  650, 2040, 2041,  645, 1663,  640,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   377,  439,    0,  339,  335,  443,  337,  338,  335,  363,
 /*    10 */   337,  338,   12,   13,   14,  392,  393,    2,  362,  361,
 /*    20 */    20,  459,   22,    8,    9,  463,  464,   12,   13,   14,
 /*    30 */    15,   16,  374,   33,  370,   35,   20,  331,  362,  383,
 /*    40 */   384,  364,    8,    9,  394,  369,   12,   13,   14,   15,
 /*    50 */    16,  339,  375,  439,  378,    8,    9,  443,   58,   12,
 /*    60 */    13,   14,   15,   16,   64,   63,  373,   20,  362,  376,
 /*    70 */   377,   71,  328,  459,  346,  339,  370,  463,  464,  351,
 /*    80 */    20,  375,   22,  377,   12,   13,  409,  410,  411,  439,
 /*    90 */     4,  379,   20,  443,   22,   35,   96,  420,   64,  435,
 /*   100 */   436,  437,   21,  439,  440,   33,  370,   35,  458,  459,
 /*   110 */    44,   51,  406,  463,  464,   34,  410,   36,  118,  413,
 /*   120 */   414,  415,  416,  417,  418,  419,  420,  421,  422,   43,
 /*   130 */    58,   45,   46,  133,  134,   20,   64,  336,  394,  105,
 /*   140 */   339,  340,  398,   71,  331,  109,  110,  111,  112,  113,
 /*   150 */   114,  115,  116,  117,  118,  119,  362,  121,  122,  123,
 /*   160 */   124,  125,  126,  163,  164,  377,  339,   20,   96,  169,
 /*   170 */   170,  435,  436,  437,  354,  439,  440,  389,  384,  443,
 /*   180 */   392,  393,  362,  439,  184,  339,  186,  443,  375,  369,
 /*   190 */   118,  371,   20,   58,  458,  459,  162,  370,  378,  463,
 /*   200 */   464,   63,  458,  459,   20,  133,  134,  463,  464,   20,
 /*   210 */   210,  211,  165,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */   230,   96,  386,   98,  388,  163,  164,  168,  343,   63,
 /*   240 */    21,  169,  170,   24,   25,   26,   27,   28,   29,   30,
 /*   250 */    31,   32,  357,   14,   37,  330,  184,  332,  186,   20,
 /*   260 */   365,  434,  435,  436,  437,   20,  439,  440,   96,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,  242,  243,  244,  245,
 /*   280 */    96,   96,  210,  211,   35,  213,  214,  215,  216,  217,
 /*   290 */   218,  219,  220,  221,  222,  223,  224,  225,  226,  227,
 /*   300 */   228,  229,  230,  364,  232,   12,   13,   12,   13,   14,
 /*   310 */    15,   16,   20,   20,  375,   22,   99,   19,  101,  102,
 /*   320 */    71,  104,  253,  254,  255,  108,   33,   20,   35,  336,
 /*   330 */   331,   33,  339,  340,  339,  428,  429,    8,    9,  273,
 /*   340 */   179,   12,   13,   14,   15,   16,   48,  130,  409,  410,
 /*   350 */   411,   58,   54,   55,   56,   57,   58,   64,  345,  420,
 /*   360 */    14,  362,  201,  202,   71,  370,   20,  107,  183,  370,
 /*   370 */   185,  412,  359,   20,  375,   22,  377,   12,   13,   14,
 /*   380 */    20,  368,    3,  248,  232,   20,  234,   22,   96,   96,
 /*   390 */   127,  128,    4,   95,  209,  132,   98,  438,   33,   20,
 /*   400 */    35,  424,  163,  426,   51,  406,    0,  339,  331,  410,
 /*   410 */   339,  118,  413,  414,  415,  416,  417,  418,    0,  420,
 /*   420 */   248,  353,  372,   58,  353,  375,  133,  134,  360,  131,
 /*   430 */   435,  436,  437,  248,  439,  440,   71,  339,  370,   21,
 /*   440 */   232,  370,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   450 */    32,  353,  375,  454,  455,   58,  163,  164,  360,  362,
 /*   460 */   343,   96,  169,  170,  166,  424,  369,  426,  370,  171,
 /*   470 */   163,  164,   66,   67,   68,  378,   97,  184,   47,  186,
 /*   480 */    74,   75,  365,  118,   96,   79,  188,   80,  190,    0,
 /*   490 */    84,   85,   95,  133,  134,   98,   90,  127,  133,  134,
 /*   500 */   376,  377,   20,  210,  211,  176,  213,  214,  215,  216,
 /*   510 */   217,  218,  219,  220,  221,  222,  223,  224,  225,  226,
 /*   520 */   227,  228,  229,  230,   66,   67,   68,   96,  163,  164,
 /*   530 */     0,  362,   74,   75,  169,  170,  339,   79,  369,  339,
 /*   540 */   248,   20,   84,   85,  165,  138,  139,  378,   90,  184,
 /*   550 */   353,  186,  339,  353,   24,   25,   26,   27,   28,   29,
 /*   560 */    30,   31,   32,  193,  194,  394,   35,  370,  161,  398,
 /*   570 */   370,   14,   15,   16,  331,  210,  211,  339,  213,  214,
 /*   580 */   215,  216,  217,  218,  219,  220,  221,  222,  223,  224,
 /*   590 */   225,  226,  227,  228,  229,  230,   12,   13,   35,  386,
 /*   600 */   370,  388,   71,  274,   20,  362,   22,  339,  439,  339,
 /*   610 */   439,  381,  443,  370,  443,  133,  134,   33,  375,   35,
 /*   620 */   377,  353,   33,  353,  386,   96,  388,  458,  459,  458,
 /*   630 */   459,   96,  463,  464,  463,  464,  248,   48,  370,  331,
 /*   640 */   370,  152,   58,   54,   55,   56,   57,   58,  339,  406,
 /*   650 */   161,  169,  170,  410,  210,   71,  413,  414,  415,  416,
 /*   660 */   417,  418,  353,  420,   22,  354,   14,  331,   12,   13,
 /*   670 */   427,   20,   20,  362,  431,  432,   20,   35,   22,  370,
 /*   680 */    96,    4,  371,  375,   95,  331,  165,   98,   71,   33,
 /*   690 */   331,   35,  423,    8,    9,  426,   19,   12,   13,   14,
 /*   700 */    15,   16,  118,  259,  260,  261,  262,  263,  264,  265,
 /*   710 */    33,  375,  362,  364,   58,    8,    9,  133,  134,   12,
 /*   720 */    13,   14,   15,   16,  375,   48,    2,   71,  378,  375,
 /*   730 */    53,    0,    8,    9,  375,   58,   12,   13,   14,   15,
 /*   740 */    16,  331,  439,  331,  331,  162,  443,  163,  164,  186,
 /*   750 */   339,   44,   96,  169,  170,  166,  167,  107,  409,  410,
 /*   760 */   171,  458,  459,  174,  353,  363,  463,  464,  184,  420,
 /*   770 */   186,  362,   95,  331,  118,   98,  362,  248,  331,  190,
 /*   780 */   371,  370,   97,  248,  370,  375,  358,  375,  375,  133,
 /*   790 */   134,  331,    1,    2,  210,  211,   71,  213,  214,  215,
 /*   800 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   810 */   226,  227,  228,  229,  230,  163,  165,  375,  235,  163,
 /*   820 */   164,   18,  375,   20,  108,  169,  170,  128,  245,  415,
 /*   830 */    27,  345,  404,   30,  362,  375,   33,   45,   46,  108,
 /*   840 */   184,  369,  186,  127,  128,  129,  130,  131,  132,  331,
 /*   850 */   378,   48,   20,   50,  368,    0,   53,  370,  127,  128,
 /*   860 */   129,  130,  131,  132,  348,  349,  210,  211,  381,  213,
 /*   870 */   214,  215,  216,  217,  218,  219,  220,  221,  222,  223,
 /*   880 */   224,  225,  226,  227,  228,  229,  230,  354,   97,  399,
 /*   890 */   191,  192,   18,  375,  195,  362,  197,   23,   95,    0,
 /*   900 */   339,    8,    9,    0,  371,   12,   13,   14,   15,   16,
 /*   910 */   107,   37,   38,  363,  353,   41,  331,   39,   63,    8,
 /*   920 */     9,  362,  354,   12,   13,   14,   15,   16,  369,  355,
 /*   930 */   362,  370,  358,   59,   60,   61,   62,  378,  412,  371,
 /*   940 */   137,  348,  349,  140,  141,  142,  143,  144,  145,  146,
 /*   950 */   147,  148,  149,  150,  151,  152,  153,  154,  155,  156,
 /*   960 */   375,  158,  159,  160,  438,   66,   67,   68,   69,   70,
 /*   970 */    96,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   980 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   990 */    91,   92,  339,  339,  331,    8,    9,  165,  394,   12,
 /*  1000 */    13,   14,   15,   16,   22,  339,  353,  353,   97,  135,
 /*  1010 */   331,  108,    3,  339,  339,  339,    4,   35,  350,  353,
 /*  1020 */   352,  331,  331,  370,  370,  331,  331,  353,  353,  353,
 /*  1030 */   127,  128,  129,  130,  131,  132,  370,  370,  375,  108,
 /*  1040 */    42,  362,   44,  439,  370,  370,  370,  443,  381,  370,
 /*  1050 */   176,  177,  178,   71,  375,  181,  377,  339,  165,  331,
 /*  1060 */   412,  130,  458,  459,   44,  375,  375,  463,  464,  375,
 /*  1070 */   375,  353,  372,  364,  200,  375,   20,  203,  107,  205,
 /*  1080 */   206,  207,  208,  209,  375,  406,  438,   58,  370,  410,
 /*  1090 */   362,  364,  413,  414,  415,  416,  417,  418,  370,  420,
 /*  1100 */   118,   44,  375,  375,  425,  377,  427,  246,  247,  339,
 /*  1110 */   431,  432,  372,    0,   42,  375,   44,   97,  409,  410,
 /*  1120 */   411,  339,  248,  353,  445,  247,  331,   98,  157,  420,
 /*  1130 */   394,  363,  453,   44,  406,  353,  409,  410,  410,  363,
 /*  1140 */   370,  413,  414,  415,  416,  417,  418,  420,  420,  339,
 /*  1150 */    44,  423,  370,  425,  426,  427,  363,  362,  331,  431,
 /*  1160 */   432,   48,    0,  353,  100,  370,  184,  103,  186,    0,
 /*  1170 */   375,  100,  377,  100,  103,  439,  103,   44,  100,  443,
 /*  1180 */   370,  103,   44,   44,   22,  196,   97,  198,   64,  362,
 /*  1190 */   332,   22,  210,  211,  458,  459,    0,  370,  363,  463,
 /*  1200 */   464,  406,  375,   97,  377,  410,   35,  331,  413,  414,
 /*  1210 */   415,  416,  417,  418,  165,  420,  133,  134,   22,  163,
 /*  1220 */   425,  172,  427,   44,   44,    0,  431,  432,   44,  385,
 /*  1230 */    97,   44,   44,  406,   44,   97,   97,  410,  362,  351,
 /*  1240 */   413,  414,  415,  416,  417,  418,  370,  420,  453,    1,
 /*  1250 */     2,  375,  425,  377,  427,   96,   44,  394,  431,  432,
 /*  1260 */    44,  249,   44,   44,   44,  106,  331,  467,  456,  442,
 /*  1270 */   341,   44,   44,   13,   49,  450,   97,   97,  269,   44,
 /*  1280 */   362,   97,  406,  341,   97,   97,  410,   97,  338,  413,
 /*  1290 */   414,  415,  416,  417,  418,   35,  420,  362,   13,  385,
 /*  1300 */   331,  425,  439,  427,  374,  370,  443,  431,  432,   97,
 /*  1310 */   375,  385,  377,   97,  441,   97,   97,   97,  442,  460,
 /*  1320 */    35,  458,  459,  433,   97,   97,  463,  464,  271,  444,
 /*  1330 */   250,  362,   97,  408,  210,   48,  182,  396,   42,  370,
 /*  1340 */   407,  406,  382,   20,  375,  410,  377,  385,  413,  414,
 /*  1350 */   415,  416,  417,  418,  382,  420,  162,  186,  380,   20,
 /*  1360 */   425,  339,  427,  339,  380,  382,  431,  432,  380,  339,
 /*  1370 */    94,  339,  347,  331,  339,  406,  339,  442,   20,  410,
 /*  1380 */   333,  333,  413,  414,  415,  416,  417,  418,   20,  420,
 /*  1390 */   345,  401,   12,   13,  425,   20,  427,  345,  377,   20,
 /*  1400 */   431,  432,   22,  340,  362,   20,  395,  345,  340,  339,
 /*  1410 */   345,  442,  370,   33,  345,   35,   52,  375,  333,  377,
 /*  1420 */   345,  345,  331,  342,  342,  339,  333,   96,  362,  362,
 /*  1430 */   375,  199,  405,  375,  403,  401,  362,  343,   58,  362,
 /*  1440 */   189,  362,  343,  400,  339,  385,  362,  258,  406,  362,
 /*  1450 */   362,   71,  410,  362,  362,  413,  414,  415,  416,  417,
 /*  1460 */   418,  370,  420,  362,  362,  449,  375,  425,  377,  427,
 /*  1470 */   257,  375,  377,  431,  432,  385,  266,  449,  375,  375,
 /*  1480 */   175,  267,  375,  268,  442,  452,  331,  390,  390,  451,
 /*  1490 */   449,  251,  448,  447,  468,  370,  446,  406,  118,  275,
 /*  1500 */   461,  410,  272,  270,  413,  414,  415,  416,  417,  418,
 /*  1510 */   247,  420,   20,  462,  339,  343,  425,  362,  427,  408,
 /*  1520 */   412,  340,  431,  432,   20,  370,  343,  390,  388,  167,
 /*  1530 */   375,  375,  377,  375,  390,  375,  375,  387,  375,  375,
 /*  1540 */   343,  343,   96,  358,  370,  430,   96,  352,  366,  343,
 /*  1550 */   339,  375,   36,  402,  331,  334,  356,  391,  391,  333,
 /*  1560 */   356,  406,  397,  356,  184,  410,  186,  329,  413,  414,
 /*  1570 */   415,  416,  417,  418,    0,  420,    0,    0,  344,   42,
 /*  1580 */   425,    0,  427,   35,  331,  362,  431,  432,  204,   35,
 /*  1590 */   210,  211,   35,  370,   35,  204,    0,   35,  375,   35,
 /*  1600 */   377,  204,    0,  223,  224,  225,  226,  227,  228,  229,
 /*  1610 */   204,    0,    0,   35,  331,  362,   22,    0,  191,   35,
 /*  1620 */   186,  184,    0,  370,    0,    0,    0,  180,  375,  406,
 /*  1630 */   377,  179,    0,  410,   47,    0,  413,  414,  415,  416,
 /*  1640 */   417,  418,    0,  420,  331,  362,    0,   42,  425,    0,
 /*  1650 */   427,    0,    0,  370,  431,  432,    0,    0,  375,  406,
 /*  1660 */   377,    0,    0,  410,  152,   35,  413,  414,  415,  416,
 /*  1670 */   417,  418,    0,  420,    0,  362,  152,    0,  331,    0,
 /*  1680 */   427,    0,    0,  370,  431,  432,    0,    0,  375,  406,
 /*  1690 */   377,    0,    0,  410,    0,    0,  413,  414,  415,  416,
 /*  1700 */   417,  418,    0,  420,    0,  331,    0,    0,    0,  362,
 /*  1710 */   427,    0,   42,    0,  431,  432,    0,  370,    0,  406,
 /*  1720 */     0,    0,  375,  410,  377,    0,  413,  414,  415,  416,
 /*  1730 */   417,  418,   22,  420,    0,    0,  362,    0,    0,  136,
 /*  1740 */     0,    0,   58,    0,  370,    0,   58,   35,   58,  375,
 /*  1750 */     0,  377,   47,  406,  331,    0,   42,  410,   39,   44,
 /*  1760 */   413,  414,  415,  416,  417,  418,    0,  420,   14,   47,
 /*  1770 */    14,   47,   40,    0,    0,   39,    0,    0,  465,  466,
 /*  1780 */   406,   39,  175,    0,  410,  362,    0,  413,  414,  415,
 /*  1790 */   416,  417,  418,  370,  420,   65,    0,    0,  375,   35,
 /*  1800 */   377,  427,  455,    0,   39,   48,  432,   35,   48,   39,
 /*  1810 */     0,   48,    0,   35,   39,   35,  331,   48,    0,    0,
 /*  1820 */    39,    0,    0,   35,   22,    0,   35,   35,  105,  406,
 /*  1830 */   103,   44,    0,  410,   35,   35,  413,  414,  415,  416,
 /*  1840 */   417,  418,   44,  420,   35,   22,   35,  362,  331,   35,
 /*  1850 */    22,    0,   22,    0,   50,  370,   22,    0,    0,   35,
 /*  1860 */   375,   35,  377,    0,   35,   22,   20,   96,   35,    0,
 /*  1870 */    35,   35,   35,    0,  165,    0,   22,    0,   96,  362,
 /*  1880 */   457,   97,  165,  187,  367,    3,   44,  370,  252,   96,
 /*  1890 */    96,  406,  375,  167,  377,  410,  165,  331,  413,  414,
 /*  1900 */   415,  416,  417,  418,   97,  420,  173,  231,   44,  256,
 /*  1910 */    97,  172,   44,   97,  331,   44,  172,   97,  252,   47,
 /*  1920 */    44,   47,    3,  406,   97,  252,   35,  410,  362,   44,
 /*  1930 */   413,  414,  415,  416,  417,  418,  370,  420,   97,   35,
 /*  1940 */    96,  375,   35,  377,   96,  362,  331,   35,   96,   35,
 /*  1950 */   367,  466,   96,  370,   44,   35,   97,   97,  375,    0,
 /*  1960 */   377,    0,    0,   47,   47,    0,   96,   39,   47,    0,
 /*  1970 */    39,  331,  406,  168,  246,   96,  410,  362,   44,  413,
 /*  1980 */   414,  415,  416,  417,  418,  370,  420,   97,  422,  406,
 /*  1990 */   375,   97,  377,  410,  106,  331,  413,  414,  415,  416,
 /*  2000 */   417,  418,  362,  420,   96,   96,  166,  367,    2,   96,
 /*  2010 */   370,   47,   22,   47,   96,  375,  231,  377,  210,   96,
 /*  2020 */   331,  406,  233,   97,   97,  410,  362,   97,  413,  414,
 /*  2030 */   415,  416,  417,  418,  370,  420,   96,  231,   96,  375,
 /*  2040 */    96,  377,   96,  212,   47,   97,  406,   22,   96,   35,
 /*  2050 */   410,  362,  107,  413,  414,  415,  416,  417,  418,  370,
 /*  2060 */   420,   35,   35,   96,  375,   97,  377,   97,   97,   96,
 /*  2070 */   406,   35,   96,   35,  410,   97,   96,  413,  414,  415,
 /*  2080 */   416,  417,  418,  331,  420,   97,   35,   96,   22,   96,
 /*  2090 */   108,   44,   35,   22,  120,  406,   96,  120,   96,  410,
 /*  2100 */    65,  120,  413,  414,  415,  416,  417,  418,   64,  420,
 /*  2110 */   331,   35,  120,   35,  362,   35,   35,   35,   35,   71,
 /*  2120 */    35,   35,  370,   35,   35,   93,   35,  375,   35,  377,
 /*  2130 */    35,   44,  331,   35,   22,   35,   35,   35,   71,   35,
 /*  2140 */    35,  362,   35,   35,   22,   35,    0,   48,   35,  370,
 /*  2150 */     0,   35,    0,   39,  375,    0,  377,   48,  406,   39,
 /*  2160 */    35,    0,  410,  362,   35,  413,  414,  415,  416,  417,
 /*  2170 */   418,  370,  420,   39,   48,   48,  375,   39,  377,   35,
 /*  2180 */    35,    0,   22,   21,   21,  406,   22,   22,   20,  410,
 /*  2190 */   469,  469,  413,  414,  415,  416,  417,  418,  469,  420,
 /*  2200 */   469,  469,  469,  469,  469,  469,  469,  406,  469,  469,
 /*  2210 */   469,  410,  331,  469,  413,  414,  415,  416,  417,  418,
 /*  2220 */   469,  420,  469,  469,  469,  469,  469,  469,  469,  331,
 /*  2230 */   469,  469,  469,  469,  469,  469,  469,  469,  469,  469,
 /*  2240 */   469,  469,  469,  362,  469,  469,  331,  469,  469,  469,
 /*  2250 */   469,  370,  469,  469,  469,  469,  375,  469,  377,  469,
 /*  2260 */   362,  469,  469,  469,  469,  469,  469,  469,  370,  469,
 /*  2270 */   469,  469,  469,  375,  469,  377,  469,  362,  331,  469,
 /*  2280 */   469,  469,  469,  469,  469,  370,  469,  406,  469,  469,
 /*  2290 */   375,  410,  377,  469,  413,  414,  415,  416,  417,  418,
 /*  2300 */   469,  420,  469,  331,  406,  469,  469,  469,  410,  362,
 /*  2310 */   469,  413,  414,  415,  416,  417,  418,  370,  420,  469,
 /*  2320 */   469,  406,  375,  469,  377,  410,  469,  331,  413,  414,
 /*  2330 */   415,  416,  417,  418,  362,  420,  469,  469,  469,  469,
 /*  2340 */   469,  469,  370,  469,  469,  469,  469,  375,  469,  377,
 /*  2350 */   469,  469,  331,  406,  469,  469,  469,  410,  362,  469,
 /*  2360 */   413,  414,  415,  416,  417,  418,  370,  420,  469,  469,
 /*  2370 */   469,  375,  469,  377,  469,  469,  469,  469,  406,  469,
 /*  2380 */   469,  469,  410,  362,  469,  413,  414,  415,  416,  417,
 /*  2390 */   418,  370,  420,  469,  469,  469,  375,  469,  377,  469,
 /*  2400 */   469,  469,  406,  469,  469,  469,  410,  469,  469,  413,
 /*  2410 */   414,  415,  416,  417,  418,  331,  420,  469,  469,  469,
 /*  2420 */   469,  469,  469,  469,  469,  469,  469,  406,  469,  469,
 /*  2430 */   469,  410,  469,  469,  413,  414,  415,  416,  417,  418,
 /*  2440 */   469,  420,  331,  469,  469,  469,  362,  469,  469,  469,
 /*  2450 */   469,  469,  469,  469,  370,  469,  469,  469,  469,  375,
 /*  2460 */   469,  377,  469,  469,  331,  469,  469,  469,  469,  469,
 /*  2470 */   469,  469,  469,  362,  469,  469,  469,  469,  469,  469,
 /*  2480 */   469,  370,  469,  469,  469,  469,  375,  469,  377,  469,
 /*  2490 */   406,  469,  469,  469,  410,  362,  469,  413,  414,  415,
 /*  2500 */   416,  417,  418,  370,  420,  469,  469,  469,  375,  469,
 /*  2510 */   377,  469,  469,  469,  469,  469,  469,  406,  469,  469,
 /*  2520 */   469,  410,  469,  469,  413,  414,  415,  416,  417,  418,
 /*  2530 */   469,  420,  469,  469,  469,  469,  469,  469,  469,  406,
 /*  2540 */   469,  469,  469,  410,  331,  469,  413,  414,  415,  416,
 /*  2550 */   417,  418,  469,  420,  469,  469,  469,  469,  469,  469,
 /*  2560 */   469,  331,  469,  469,  469,  469,  469,  469,  469,  469,
 /*  2570 */   469,  469,  469,  469,  469,  362,  469,  469,  331,  469,
 /*  2580 */   469,  469,  469,  370,  469,  469,  469,  469,  375,  469,
 /*  2590 */   377,  469,  362,  469,  469,  469,  469,  469,  469,  469,
 /*  2600 */   370,  469,  469,  469,  469,  375,  469,  377,  469,  362,
 /*  2610 */   331,  469,  469,  469,  469,  469,  469,  370,  469,  406,
 /*  2620 */   469,  469,  375,  410,  377,  469,  413,  414,  415,  416,
 /*  2630 */   417,  418,  469,  420,  469,  331,  406,  469,  469,  469,
 /*  2640 */   410,  362,  469,  413,  414,  415,  416,  417,  418,  370,
 /*  2650 */   420,  469,  469,  406,  375,  469,  377,  410,  469,  331,
 /*  2660 */   413,  414,  415,  416,  417,  418,  362,  420,  469,  469,
 /*  2670 */   469,  469,  469,  469,  370,  469,  469,  469,  469,  375,
 /*  2680 */   469,  377,  469,  469,  469,  406,  469,  469,  469,  410,
 /*  2690 */   362,  469,  413,  414,  415,  416,  417,  418,  370,  420,
 /*  2700 */   469,  469,  469,  375,  469,  377,  469,  469,  469,  469,
 /*  2710 */   406,  469,  469,  469,  410,  469,  469,  413,  414,  415,
 /*  2720 */   416,  417,  418,  469,  420,  469,  469,  469,  469,  469,
 /*  2730 */   469,  469,  469,  469,  406,  469,  469,  469,  410,  469,
 /*  2740 */   469,  413,  414,  415,  416,  417,  418,  469,  420,
};
#define YY_SHIFT_COUNT    (740)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2181)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   874,    0,   72,    0,  293,  293,  293,  293,  293,  293,
 /*    10 */   293,  293,  293,  293,  293,  365,  584,  584,  656,  584,
 /*    20 */   584,  584,  584,  584,  584,  584,  584,  584,  584,  584,
 /*    30 */   584,  584,  584,  584,  584,  584,  584,  584,  584,  584,
 /*    40 */   584,  584,  584,  584,  584,  584,  584,  584,  172,  292,
 /*    50 */   185,  184,  135,  529,  535,  529,  184,  184, 1380, 1380,
 /*    60 */  1380,  529, 1380, 1380,  388,  529,   16,  482,  115,  115,
 /*    70 */   482,   86,   86,  307,  360,  346,  346,  115,  115,  115,
 /*    80 */   115,  115,  115,  115,  147,  115,  115,  138,   16,  115,
 /*    90 */   115,  189,  115,   16,  115,  147,  115,  147,   16,  115,
 /*   100 */   115,   16,  115,   16,   16,   16,  115,  176,  803,   34,
 /*   110 */    34,  219,  458,  982,  982,  982,  982,  982,  982,  982,
 /*   120 */   982,  982,  982,  982,  982,  982,  982,  982,  982,  982,
 /*   130 */   982,  982,  217,  379,  307,  360,    2,  249,  521,  521,
 /*   140 */   521,  855,  152,  152,  249,  245,  245,  245,  260,  208,
 /*   150 */    16,  617,   16,  617,  617,  650,  725,   36,   36,   36,
 /*   160 */    36,   36,   36,   36,   36,  298,  418,  406,   47,  329,
 /*   170 */   444,   60,   69,  239,  652,  353,  651,  792,  931,  832,
 /*   180 */   861,  878, 1009,  861,  998, 1012, 1056, 1080, 1287, 1154,
 /*   190 */  1296, 1323, 1296, 1194, 1339, 1339, 1296, 1194, 1194, 1339,
 /*   200 */  1276, 1339, 1339, 1339, 1358, 1358, 1368,  138, 1375,  138,
 /*   210 */  1379, 1385,  138, 1379,  138,  138,  138, 1339,  138, 1364,
 /*   220 */  1364, 1358,   16,   16,   16,   16,   16,   16,   16,   16,
 /*   230 */    16,   16,   16, 1339, 1358,  617,  617, 1232, 1331, 1368,
 /*   240 */   176, 1251, 1375,  176, 1339, 1323, 1323,  617, 1189, 1213,
 /*   250 */   617, 1189, 1213,  617,  617,   16, 1210, 1305, 1189, 1215,
 /*   260 */  1214, 1240, 1080, 1224, 1230, 1233, 1263,  245, 1492, 1339,
 /*   270 */  1379,  176,  176, 1504, 1213,  617,  617,  617,  617,  617,
 /*   280 */  1213,  617, 1362,  176,  650,  176,  245, 1446, 1450,  617,
 /*   290 */   725, 1339,  176, 1516, 1358, 2749, 2749, 2749, 2749, 2749,
 /*   300 */  2749, 2749, 2749, 2749,  899,  589,  530,  677,  685,  707,
 /*   310 */   911,  731,   15,  724,  893,  903,  987,  987,  987,  987,
 /*   320 */   987,  987,  987,  987,  987,  716,  699,  295,  295,  407,
 /*   330 */   161,  489,  397,   81,  370,  263,  263,  557,  791,  583,
 /*   340 */   557,  557,  557, 1113, 1020,  642, 1072,  971, 1064, 1071,
 /*   350 */  1073, 1078, 1162, 1169, 1196,  989, 1089, 1106, 1029, 1133,
 /*   360 */  1138, 1139, 1083, 1057,   66, 1049, 1179, 1180, 1184, 1187,
 /*   370 */  1188, 1190, 1248, 1212,  563, 1171, 1124, 1216,  431, 1218,
 /*   380 */  1219, 1220, 1227, 1228, 1235, 1159, 1260, 1285,  531, 1225,
 /*   390 */  1574, 1576, 1577, 1537, 1581, 1548, 1384, 1554, 1557, 1559,
 /*   400 */  1391, 1596, 1562, 1564, 1397, 1602, 1406, 1611, 1578, 1612,
 /*   410 */  1594, 1617, 1584, 1427, 1434, 1437, 1622, 1624, 1625, 1447,
 /*   420 */  1452, 1626, 1632, 1587, 1635, 1642, 1646, 1605, 1649, 1651,
 /*   430 */  1652, 1656, 1657, 1661, 1662, 1672, 1512, 1630, 1674, 1524,
 /*   440 */  1677, 1679, 1681, 1682, 1686, 1687, 1691, 1692, 1694, 1695,
 /*   450 */  1702, 1704, 1706, 1707, 1708, 1711, 1670, 1713, 1716, 1718,
 /*   460 */  1720, 1721, 1725, 1710, 1734, 1735, 1737, 1603, 1738, 1740,
 /*   470 */  1741, 1684, 1712, 1743, 1688, 1745, 1690, 1750, 1755, 1714,
 /*   480 */  1719, 1715, 1705, 1754, 1722, 1756, 1724, 1766, 1732, 1736,
 /*   490 */  1773, 1774, 1776, 1742, 1607, 1777, 1783, 1786, 1730, 1796,
 /*   500 */  1797, 1764, 1757, 1765, 1803, 1772, 1760, 1770, 1810, 1778,
 /*   510 */  1763, 1775, 1812, 1780, 1769, 1781, 1818, 1819, 1821, 1822,
 /*   520 */  1723, 1727, 1788, 1802, 1825, 1791, 1792, 1799, 1800, 1787,
 /*   530 */  1798, 1809, 1811, 1823, 1814, 1832, 1828, 1851, 1830, 1804,
 /*   540 */  1853, 1834, 1824, 1857, 1826, 1858, 1829, 1863, 1843, 1846,
 /*   550 */  1833, 1835, 1836, 1784, 1771, 1869, 1709, 1782, 1837, 1873,
 /*   560 */  1696, 1854, 1717, 1726, 1875, 1877, 1731, 1733, 1882, 1842,
 /*   570 */  1636, 1793, 1807, 1794, 1739, 1676, 1744, 1653, 1813, 1864,
 /*   580 */  1868, 1816, 1844, 1848, 1852, 1820, 1871, 1872, 1874, 1856,
 /*   590 */  1876, 1666, 1827, 1841, 1919, 1885, 1673, 1891, 1904, 1907,
 /*   600 */  1912, 1914, 1920, 1859, 1860, 1916, 1728, 1910, 1917, 1959,
 /*   610 */  1961, 1962, 1965, 1870, 1928, 1705, 1921, 1879, 1890, 1894,
 /*   620 */  1908, 1909, 1805, 1913, 1969, 1931, 1840, 1918, 1888, 1705,
 /*   630 */  1964, 1934, 1785, 1789, 1806, 2006, 1990, 1808, 1923, 1926,
 /*   640 */  1940, 1927, 1942, 1930, 1966, 1944, 1946, 1997, 1948, 2025,
 /*   650 */  1831, 1952, 1945, 1968, 2014, 2026, 1967, 1970, 2027, 1973,
 /*   660 */  1971, 2036, 1976, 1978, 2038, 1980, 1988, 2051, 1991, 1974,
 /*   670 */  1977, 1981, 1992, 2066, 1982, 1993, 2047, 2000, 2057, 2002,
 /*   680 */  2047, 2047, 2071, 2035, 2044, 2076, 2078, 2080, 2081, 2082,
 /*   690 */  2083, 2085, 2086, 2088, 2089, 2048, 2032, 2087, 2091, 2093,
 /*   700 */  2095, 2112, 2098, 2100, 2101, 2067, 1787, 2102, 1798, 2104,
 /*   710 */  2105, 2107, 2108, 2122, 2110, 2146, 2113, 2099, 2114, 2150,
 /*   720 */  2116, 2109, 2120, 2152, 2125, 2126, 2134, 2155, 2129, 2127,
 /*   730 */  2138, 2161, 2144, 2145, 2181, 2160, 2162, 2164, 2165, 2163,
 /*   740 */  2168,
};
#define YY_REDUCE_COUNT (303)
#define YY_REDUCE_MIN   (-438)
#define YY_REDUCE_MAX   (2328)
static const short yy_reduce_ofst[] = {
 /*     0 */  -256,  679,  728,  795,  827,  876,  935,  969, 1042, 1091,
 /*    10 */  1155, 1223,  243, 1253, 1283, -294,   -1, 1313, 1374, 1347,
 /*    20 */  1423, 1485, 1517, 1566, 1583, 1640, 1615, 1664, 1689, 1752,
 /*    30 */  1779, 1801, 1881, 1898, 1915, 1947, 1972, 1996, 2021, 2084,
 /*    40 */  2111, 2133, 2213, 2230, 2247, 2279, 2304, 2328, -264,  169,
 /*    50 */   171, -173, -350,  604,  736,  863, -336,   -5, -323,  -61,
 /*    60 */   709,  303,  349,  727, -438, -386, -180, -212,   68,   98,
 /*    70 */  -377, -331, -327, -344, -307, -199,   -7,   71,  197,  200,
 /*    80 */   268,  270,  309,  411, -154,  561,  653,   13, -324,  654,
 /*    90 */   675,  414,  676,   97,  718,  213,  770,  238,  311,  666,
 /*   100 */   674,  472,  782,  533,  559,  568,  810, -105, -288,  -93,
 /*   110 */   -93,  -75, -272, -187,   77,  308,  336,  354,  359,  410,
 /*   120 */   412,  413,  442,  447,  460,  518,  585,  663,  690,  691,
 /*   130 */   694,  695, -342,  -41, -206,  124,  486,  516,  -41,  526,
 /*   140 */   648,  117,  -23,   41,  593,  230,  487,  667,  428,  269,
 /*   150 */   409,   50,  350,  700,  740,  574,  668, -354,  402,  550,
 /*   160 */   768,  776,  793,  835,  776,  490,  858,  888,  844,  800,
 /*   170 */   812,  929,  825,  918,  918,  942,  914,  950,  930,  926,
 /*   180 */   873,  873,  859,  873,  890,  885,  918,  925,  933,  941,
 /*   190 */   960,  962,  972,  978, 1022, 1024,  983,  984,  988, 1030,
 /*   200 */  1025, 1032, 1035, 1037, 1047, 1048,  990, 1045, 1021, 1052,
 /*   210 */  1063, 1011, 1062, 1068, 1065, 1069, 1075, 1070, 1076, 1081,
 /*   220 */  1082, 1085, 1066, 1067, 1074, 1077, 1079, 1084, 1087, 1088,
 /*   230 */  1092, 1101, 1102, 1086, 1093, 1055, 1058, 1027, 1031, 1034,
 /*   240 */  1094, 1043, 1095, 1099, 1105, 1060, 1090, 1096, 1016, 1097,
 /*   250 */  1103, 1028, 1098, 1104, 1107,  918, 1033, 1038, 1041, 1044,
 /*   260 */  1046, 1050, 1111, 1026, 1051, 1039,  873, 1125, 1108, 1175,
 /*   270 */  1181, 1172, 1183, 1140, 1137, 1156, 1158, 1160, 1161, 1163,
 /*   280 */  1144, 1164, 1150, 1197, 1185, 1198, 1174, 1115, 1182, 1176,
 /*   290 */  1195, 1211, 1206, 1221, 1226, 1165, 1151, 1166, 1167, 1200,
 /*   300 */  1204, 1207, 1234, 1238,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*    10 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*    20 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*    30 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*    40 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*    50 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*    60 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*    70 */  1661, 1661, 1661, 1919, 1661, 1661, 1661, 1661, 1661, 1661,
 /*    80 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1740, 1661, 1661,
 /*    90 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   100 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1738, 1912, 2127,
 /*   110 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   120 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   130 */  1661, 1661, 1661, 2139, 1661, 1661, 1740, 1661, 2139, 2139,
 /*   140 */  2139, 1738, 2099, 2099, 1661, 1661, 1661, 1661, 1973, 1661,
 /*   150 */  1661, 1661, 1661, 1661, 1661, 1847, 1661, 1661, 1661, 1661,
 /*   160 */  1661, 1871, 1661, 1661, 1661, 1965, 1661, 1661, 2164, 2220,
 /*   170 */  1661, 1661, 2167, 1661, 1661, 1661, 1924, 1661, 1800, 2154,
 /*   180 */  2131, 2145, 2204, 2132, 2129, 2148, 1661, 2158, 1661, 1958,
 /*   190 */  1917, 1661, 1917, 1914, 1661, 1661, 1917, 1914, 1914, 1661,
 /*   200 */  1791, 1661, 1661, 1661, 1661, 1661, 1661, 1740, 1661, 1740,
 /*   210 */  1661, 1661, 1740, 1661, 1740, 1740, 1740, 1661, 1740, 1718,
 /*   220 */  1718, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   230 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1984, 1971, 1661,
 /*   240 */  1738, 1967, 1661, 1738, 1661, 1661, 1661, 1661, 2175, 2173,
 /*   250 */  1661, 2175, 2173, 1661, 1661, 1661, 2189, 2185, 2175, 2193,
 /*   260 */  2191, 2160, 2158, 2223, 2210, 2206, 2145, 1661, 1661, 1661,
 /*   270 */  1661, 1738, 1738, 1661, 2173, 1661, 1661, 1661, 1661, 1661,
 /*   280 */  2173, 1661, 1661, 1738, 1661, 1738, 1661, 1661, 1816, 1661,
 /*   290 */  1661, 1661, 1738, 1693, 1661, 1960, 1976, 1942, 1942, 1850,
 /*   300 */  1850, 1850, 1741, 1666, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   310 */  1661, 1661, 1661, 1661, 1661, 1661, 2188, 2187, 2054, 1661,
 /*   320 */  2103, 2102, 2101, 2092, 2053, 1812, 1661, 2052, 2051, 1661,
 /*   330 */  1661, 1661, 1661, 1661, 1661, 1933, 1932, 2045, 1661, 1661,
 /*   340 */  2046, 2044, 2043, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   350 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   360 */  1661, 1661, 1661, 2207, 2211, 1661, 1661, 1661, 1661, 1661,
 /*   370 */  1661, 1661, 2128, 1661, 1661, 1661, 1661, 1661, 2027, 1661,
 /*   380 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   390 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   400 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   410 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   420 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   430 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   440 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   450 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   460 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   470 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   480 */  1661, 1698, 2032, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   490 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   500 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   510 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   520 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1779,
 /*   530 */  1778, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   540 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   550 */  1661, 1661, 1661, 2036, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   560 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 2203, 2161,
 /*   570 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   580 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 2027, 1661,
 /*   590 */  2186, 1661, 1661, 2201, 1661, 2205, 1661, 1661, 1661, 1661,
 /*   600 */  1661, 1661, 1661, 2138, 2134, 1661, 1661, 2130, 1661, 1661,
 /*   610 */  1661, 1661, 1661, 1661, 1661, 2035, 1661, 1661, 1661, 1661,
 /*   620 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 2026,
 /*   630 */  1661, 2089, 1661, 1661, 1661, 2123, 1661, 1661, 2074, 1661,
 /*   640 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 2036, 1661,
 /*   650 */  2039, 1661, 1661, 1661, 1661, 1661, 1844, 1661, 1661, 1661,
 /*   660 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1829,
 /*   670 */  1827, 1826, 1825, 1661, 1822, 1661, 1857, 1661, 1661, 1661,
 /*   680 */  1853, 1852, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   690 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1759, 1661, 1661,
 /*   700 */  1661, 1661, 1661, 1661, 1661, 1661, 1751, 1661, 1750, 1661,
 /*   710 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   720 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   730 */  1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
 /*   740 */  1661,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
  276,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*      START => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  276,  /*      AFTER => ABORT */
  276,  /*     ATTACH => ABORT */
  276,  /*     BEFORE => ABORT */
  276,  /*      BEGIN => ABORT */
  276,  /*     BITAND => ABORT */
  276,  /*     BITNOT => ABORT */
  276,  /*      BITOR => ABORT */
  276,  /*     BLOCKS => ABORT */
  276,  /*     CHANGE => ABORT */
  276,  /*      COMMA => ABORT */
  276,  /*     CONCAT => ABORT */
  276,  /*   CONFLICT => ABORT */
  276,  /*       COPY => ABORT */
  276,  /*   DEFERRED => ABORT */
  276,  /* DELIMITERS => ABORT */
  276,  /*     DETACH => ABORT */
  276,  /*     DIVIDE => ABORT */
  276,  /*        DOT => ABORT */
  276,  /*       EACH => ABORT */
  276,  /*       FAIL => ABORT */
  276,  /*       FILE => ABORT */
  276,  /*        FOR => ABORT */
  276,  /*       GLOB => ABORT */
  276,  /*         ID => ABORT */
  276,  /*  IMMEDIATE => ABORT */
  276,  /*     IMPORT => ABORT */
  276,  /*  INITIALLY => ABORT */
  276,  /*    INSTEAD => ABORT */
  276,  /*     ISNULL => ABORT */
  276,  /*        KEY => ABORT */
  276,  /*    MODULES => ABORT */
  276,  /*  NK_BITNOT => ABORT */
  276,  /*    NK_SEMI => ABORT */
  276,  /*    NOTNULL => ABORT */
  276,  /*         OF => ABORT */
  276,  /*       PLUS => ABORT */
  276,  /*  PRIVILEGE => ABORT */
  276,  /*      RAISE => ABORT */
  276,  /*    REPLACE => ABORT */
  276,  /*   RESTRICT => ABORT */
  276,  /*        ROW => ABORT */
  276,  /*       SEMI => ABORT */
  276,  /*       STAR => ABORT */
  276,  /*  STATEMENT => ABORT */
  276,  /*     STRICT => ABORT */
  276,  /*     STRING => ABORT */
  276,  /*      TIMES => ABORT */
  276,  /*     VALUES => ABORT */
  276,  /*   VARIABLE => ABORT */
  276,  /*       VIEW => ABORT */
  276,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "COMPACT",
  /*   63 */ "IF",
  /*   64 */ "NOT",
  /*   65 */ "EXISTS",
  /*   66 */ "BUFFER",
  /*   67 */ "CACHEMODEL",
  /*   68 */ "CACHESIZE",
  /*   69 */ "COMP",
  /*   70 */ "DURATION",
  /*   71 */ "NK_VARIABLE",
  /*   72 */ "MAXROWS",
  /*   73 */ "MINROWS",
  /*   74 */ "KEEP",
  /*   75 */ "PAGES",
  /*   76 */ "PAGESIZE",
  /*   77 */ "TSDB_PAGESIZE",
  /*   78 */ "PRECISION",
  /*   79 */ "REPLICA",
  /*   80 */ "VGROUPS",
  /*   81 */ "SINGLE_STABLE",
  /*   82 */ "RETENTIONS",
  /*   83 */ "SCHEMALESS",
  /*   84 */ "WAL_LEVEL",
  /*   85 */ "WAL_FSYNC_PERIOD",
  /*   86 */ "WAL_RETENTION_PERIOD",
  /*   87 */ "WAL_RETENTION_SIZE",
  /*   88 */ "WAL_ROLL_PERIOD",
  /*   89 */ "WAL_SEGMENT_SIZE",
  /*   90 */ "STT_TRIGGER",
  /*   91 */ "TABLE_PREFIX",
  /*   92 */ "TABLE_SUFFIX",
  /*   93 */ "NK_COLON",
  /*   94 */ "MAX_SPEED",
  /*   95 */ "TABLE",
  /*   96 */ "NK_LP",
  /*   97 */ "NK_RP",
  /*   98 */ "STABLE",
  /*   99 */ "ADD",
  /*  100 */ "COLUMN",
  /*  101 */ "MODIFY",
  /*  102 */ "RENAME",
  /*  103 */ "TAG",
  /*  104 */ "SET",
  /*  105 */ "NK_EQ",
  /*  106 */ "USING",
  /*  107 */ "TAGS",
  /*  108 */ "COMMENT",
  /*  109 */ "BOOL",
  /*  110 */ "TINYINT",
  /*  111 */ "SMALLINT",
  /*  112 */ "INT",
  /*  113 */ "INTEGER",
  /*  114 */ "BIGINT",
  /*  115 */ "FLOAT",
  /*  116 */ "DOUBLE",
  /*  117 */ "BINARY",
  /*  118 */ "TIMESTAMP",
  /*  119 */ "NCHAR",
  /*  120 */ "UNSIGNED",
  /*  121 */ "JSON",
  /*  122 */ "VARCHAR",
  /*  123 */ "MEDIUMBLOB",
  /*  124 */ "BLOB",
  /*  125 */ "VARBINARY",
  /*  126 */ "DECIMAL",
  /*  127 */ "MAX_DELAY",
  /*  128 */ "WATERMARK",
  /*  129 */ "ROLLUP",
  /*  130 */ "TTL",
  /*  131 */ "SMA",
  /*  132 */ "DELETE_MARK",
  /*  133 */ "FIRST",
  /*  134 */ "LAST",
  /*  135 */ "SHOW",
  /*  136 */ "PRIVILEGES",
  /*  137 */ "DATABASES",
  /*  138 */ "TABLES",
  /*  139 */ "STABLES",
  /*  140 */ "MNODES",
  /*  141 */ "QNODES",
  /*  142 */ "FUNCTIONS",
  /*  143 */ "INDEXES",
  /*  144 */ "ACCOUNTS",
  /*  145 */ "APPS",
  /*  146 */ "CONNECTIONS",
  /*  147 */ "LICENCES",
  /*  148 */ "GRANTS",
  /*  149 */ "QUERIES",
  /*  150 */ "SCORES",
  /*  151 */ "TOPICS",
  /*  152 */ "VARIABLES",
  /*  153 */ "CLUSTER",
  /*  154 */ "BNODES",
  /*  155 */ "SNODES",
  /*  156 */ "TRANSACTIONS",
  /*  157 */ "DISTRIBUTED",
  /*  158 */ "CONSUMERS",
  /*  159 */ "SUBSCRIPTIONS",
  /*  160 */ "VNODES",
  /*  161 */ "ALIVE",
  /*  162 */ "LIKE",
  /*  163 */ "TBNAME",
  /*  164 */ "QTAGS",
  /*  165 */ "AS",
  /*  166 */ "INDEX",
  /*  167 */ "FUNCTION",
  /*  168 */ "INTERVAL",
  /*  169 */ "COUNT",
  /*  170 */ "LAST_ROW",
  /*  171 */ "TOPIC",
  /*  172 */ "WITH",
  /*  173 */ "META",
  /*  174 */ "CONSUMER",
  /*  175 */ "GROUP",
  /*  176 */ "DESC",
  /*  177 */ "DESCRIBE",
  /*  178 */ "RESET",
  /*  179 */ "QUERY",
  /*  180 */ "CACHE",
  /*  181 */ "EXPLAIN",
  /*  182 */ "ANALYZE",
  /*  183 */ "VERBOSE",
  /*  184 */ "NK_BOOL",
  /*  185 */ "RATIO",
  /*  186 */ "NK_FLOAT",
  /*  187 */ "OUTPUTTYPE",
  /*  188 */ "AGGREGATE",
  /*  189 */ "BUFSIZE",
  /*  190 */ "STREAM",
  /*  191 */ "INTO",
  /*  192 */ "TRIGGER",
  /*  193 */ "AT_ONCE",
  /*  194 */ "WINDOW_CLOSE",
  /*  195 */ "IGNORE",
  /*  196 */ "EXPIRED",
  /*  197 */ "FILL_HISTORY",
  /*  198 */ "UPDATE",
  /*  199 */ "SUBTABLE",
  /*  200 */ "KILL",
  /*  201 */ "CONNECTION",
  /*  202 */ "TRANSACTION",
  /*  203 */ "BALANCE",
  /*  204 */ "VGROUP",
  /*  205 */ "MERGE",
  /*  206 */ "REDISTRIBUTE",
  /*  207 */ "SPLIT",
  /*  208 */ "DELETE",
  /*  209 */ "INSERT",
  /*  210 */ "NULL",
  /*  211 */ "NK_QUESTION",
  /*  212 */ "NK_ARROW",
  /*  213 */ "ROWTS",
  /*  214 */ "QSTART",
  /*  215 */ "QEND",
  /*  216 */ "QDURATION",
  /*  217 */ "WSTART",
  /*  218 */ "WEND",
  /*  219 */ "WDURATION",
  /*  220 */ "IROWTS",
  /*  221 */ "ISFILLED",
  /*  222 */ "CAST",
  /*  223 */ "NOW",
  /*  224 */ "TODAY",
  /*  225 */ "TIMEZONE",
  /*  226 */ "CLIENT_VERSION",
  /*  227 */ "SERVER_VERSION",
  /*  228 */ "SERVER_STATUS",
  /*  229 */ "CURRENT_USER",
  /*  230 */ "CASE",
  /*  231 */ "END",
  /*  232 */ "WHEN",
  /*  233 */ "THEN",
  /*  234 */ "ELSE",
  /*  235 */ "BETWEEN",
  /*  236 */ "IS",
  /*  237 */ "NK_LT",
  /*  238 */ "NK_GT",
  /*  239 */ "NK_LE",
  /*  240 */ "NK_GE",
  /*  241 */ "NK_NE",
  /*  242 */ "MATCH",
  /*  243 */ "NMATCH",
  /*  244 */ "CONTAINS",
  /*  245 */ "IN",
  /*  246 */ "JOIN",
  /*  247 */ "INNER",
  /*  248 */ "SELECT",
  /*  249 */ "DISTINCT",
  /*  250 */ "WHERE",
  /*  251 */ "PARTITION",
  /*  252 */ "BY",
  /*  253 */ "SESSION",
  /*  254 */ "STATE_WINDOW",
  /*  255 */ "EVENT_WINDOW",
  /*  256 */ "START",
  /*  257 */ "SLIDING",
  /*  258 */ "FILL",
  /*  259 */ "VALUE",
  /*  260 */ "VALUE_F",
  /*  261 */ "NONE",
  /*  262 */ "PREV",
  /*  263 */ "NULL_F",
  /*  264 */ "LINEAR",
  /*  265 */ "NEXT",
  /*  266 */ "HAVING",
  /*  267 */ "RANGE",
  /*  268 */ "EVERY",
  /*  269 */ "ORDER",
  /*  270 */ "SLIMIT",
  /*  271 */ "SOFFSET",
  /*  272 */ "LIMIT",
  /*  273 */ "OFFSET",
  /*  274 */ "ASC",
  /*  275 */ "NULLS",
  /*  276 */ "ABORT",
  /*  277 */ "AFTER",
  /*  278 */ "ATTACH",
  /*  279 */ "BEFORE",
  /*  280 */ "BEGIN",
  /*  281 */ "BITAND",
  /*  282 */ "BITNOT",
  /*  283 */ "BITOR",
  /*  284 */ "BLOCKS",
  /*  285 */ "CHANGE",
  /*  286 */ "COMMA",
  /*  287 */ "CONCAT",
  /*  288 */ "CONFLICT",
  /*  289 */ "COPY",
  /*  290 */ "DEFERRED",
  /*  291 */ "DELIMITERS",
  /*  292 */ "DETACH",
  /*  293 */ "DIVIDE",
  /*  294 */ "DOT",
  /*  295 */ "EACH",
  /*  296 */ "FAIL",
  /*  297 */ "FILE",
  /*  298 */ "FOR",
  /*  299 */ "GLOB",
  /*  300 */ "ID",
  /*  301 */ "IMMEDIATE",
  /*  302 */ "IMPORT",
  /*  303 */ "INITIALLY",
  /*  304 */ "INSTEAD",
  /*  305 */ "ISNULL",
  /*  306 */ "KEY",
  /*  307 */ "MODULES",
  /*  308 */ "NK_BITNOT",
  /*  309 */ "NK_SEMI",
  /*  310 */ "NOTNULL",
  /*  311 */ "OF",
  /*  312 */ "PLUS",
  /*  313 */ "PRIVILEGE",
  /*  314 */ "RAISE",
  /*  315 */ "REPLACE",
  /*  316 */ "RESTRICT",
  /*  317 */ "ROW",
  /*  318 */ "SEMI",
  /*  319 */ "STAR",
  /*  320 */ "STATEMENT",
  /*  321 */ "STRICT",
  /*  322 */ "STRING",
  /*  323 */ "TIMES",
  /*  324 */ "VALUES",
  /*  325 */ "VARIABLE",
  /*  326 */ "VIEW",
  /*  327 */ "WAL",
  /*  328 */ "cmd",
  /*  329 */ "account_options",
  /*  330 */ "alter_account_options",
  /*  331 */ "literal",
  /*  332 */ "alter_account_option",
  /*  333 */ "user_name",
  /*  334 */ "sysinfo_opt",
  /*  335 */ "privileges",
  /*  336 */ "priv_level",
  /*  337 */ "priv_type_list",
  /*  338 */ "priv_type",
  /*  339 */ "db_name",
  /*  340 */ "topic_name",
  /*  341 */ "dnode_endpoint",
  /*  342 */ "force_opt",
  /*  343 */ "not_exists_opt",
  /*  344 */ "db_options",
  /*  345 */ "exists_opt",
  /*  346 */ "alter_db_options",
  /*  347 */ "speed_opt",
  /*  348 */ "integer_list",
  /*  349 */ "variable_list",
  /*  350 */ "retention_list",
  /*  351 */ "alter_db_option",
  /*  352 */ "retention",
  /*  353 */ "full_table_name",
  /*  354 */ "column_def_list",
  /*  355 */ "tags_def_opt",
  /*  356 */ "table_options",
  /*  357 */ "multi_create_clause",
  /*  358 */ "tags_def",
  /*  359 */ "multi_drop_clause",
  /*  360 */ "alter_table_clause",
  /*  361 */ "alter_table_options",
  /*  362 */ "column_name",
  /*  363 */ "type_name",
  /*  364 */ "signed_literal",
  /*  365 */ "create_subtable_clause",
  /*  366 */ "specific_cols_opt",
  /*  367 */ "expression_list",
  /*  368 */ "drop_table_clause",
  /*  369 */ "col_name_list",
  /*  370 */ "table_name",
  /*  371 */ "column_def",
  /*  372 */ "duration_list",
  /*  373 */ "rollup_func_list",
  /*  374 */ "alter_table_option",
  /*  375 */ "duration_literal",
  /*  376 */ "rollup_func_name",
  /*  377 */ "function_name",
  /*  378 */ "col_name",
  /*  379 */ "db_name_cond_opt",
  /*  380 */ "like_pattern_opt",
  /*  381 */ "table_name_cond",
  /*  382 */ "from_db_opt",
  /*  383 */ "tag_list_opt",
  /*  384 */ "tag_item",
  /*  385 */ "column_alias",
  /*  386 */ "full_index_name",
  /*  387 */ "index_options",
  /*  388 */ "index_name",
  /*  389 */ "func_list",
  /*  390 */ "sliding_opt",
  /*  391 */ "sma_stream_opt",
  /*  392 */ "func",
  /*  393 */ "sma_func_name",
  /*  394 */ "query_or_subquery",
  /*  395 */ "cgroup_name",
  /*  396 */ "analyze_opt",
  /*  397 */ "explain_options",
  /*  398 */ "insert_query",
  /*  399 */ "agg_func_opt",
  /*  400 */ "bufsize_opt",
  /*  401 */ "stream_name",
  /*  402 */ "stream_options",
  /*  403 */ "col_list_opt",
  /*  404 */ "tag_def_or_ref_opt",
  /*  405 */ "subtable_opt",
  /*  406 */ "expression",
  /*  407 */ "dnode_list",
  /*  408 */ "where_clause_opt",
  /*  409 */ "signed",
  /*  410 */ "literal_func",
  /*  411 */ "literal_list",
  /*  412 */ "table_alias",
  /*  413 */ "expr_or_subquery",
  /*  414 */ "pseudo_column",
  /*  415 */ "column_reference",
  /*  416 */ "function_expression",
  /*  417 */ "case_when_expression",
  /*  418 */ "star_func",
  /*  419 */ "star_func_para_list",
  /*  420 */ "noarg_func",
  /*  421 */ "other_para_list",
  /*  422 */ "star_func_para",
  /*  423 */ "when_then_list",
  /*  424 */ "case_when_else_opt",
  /*  425 */ "common_expression",
  /*  426 */ "when_then_expr",
  /*  427 */ "predicate",
  /*  428 */ "compare_op",
  /*  429 */ "in_op",
  /*  430 */ "in_predicate_value",
  /*  431 */ "boolean_value_expression",
  /*  432 */ "boolean_primary",
  /*  433 */ "from_clause_opt",
  /*  434 */ "table_reference_list",
  /*  435 */ "table_reference",
  /*  436 */ "table_primary",
  /*  437 */ "joined_table",
  /*  438 */ "alias_opt",
  /*  439 */ "subquery",
  /*  440 */ "parenthesized_joined_table",
  /*  441 */ "join_type",
  /*  442 */ "search_condition",
  /*  443 */ "query_specification",
  /*  444 */ "set_quantifier_opt",
  /*  445 */ "select_list",
  /*  446 */ "partition_by_clause_opt",
  /*  447 */ "range_opt",
  /*  448 */ "every_opt",
  /*  449 */ "fill_opt",
  /*  450 */ "twindow_clause_opt",
  /*  451 */ "group_by_clause_opt",
  /*  452 */ "having_clause_opt",
  /*  453 */ "select_item",
  /*  454 */ "partition_list",
  /*  455 */ "partition_item",
  /*  456 */ "fill_mode",
  /*  457 */ "group_by_list",
  /*  458 */ "query_expression",
  /*  459 */ "query_simple",
  /*  460 */ "order_by_clause_opt",
  /*  461 */ "slimit_clause_opt",
  /*  462 */ "limit_clause_opt",
  /*  463 */ "union_query_expression",
  /*  464 */ "query_simple_or_subquery",
  /*  465 */ "sort_specification_list",
  /*  466 */ "sort_specification",
  /*  467 */ "ordering_specification_opt",
  /*  468 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "cmd ::= COMPACT DATABASE db_name",
 /*  73 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  74 */ "not_exists_opt ::=",
 /*  75 */ "exists_opt ::= IF EXISTS",
 /*  76 */ "exists_opt ::=",
 /*  77 */ "db_options ::=",
 /*  78 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  79 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  80 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  81 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  83 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  84 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  86 */ "db_options ::= db_options KEEP integer_list",
 /*  87 */ "db_options ::= db_options KEEP variable_list",
 /*  88 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  89 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  92 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  93 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  94 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  95 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  96 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 107 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 108 */ "alter_db_options ::= alter_db_option",
 /* 109 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 110 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 111 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 112 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 114 */ "alter_db_option ::= KEEP integer_list",
 /* 115 */ "alter_db_option ::= KEEP variable_list",
 /* 116 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 117 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 118 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 119 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 120 */ "integer_list ::= NK_INTEGER",
 /* 121 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 122 */ "variable_list ::= NK_VARIABLE",
 /* 123 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 124 */ "retention_list ::= retention",
 /* 125 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 126 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 127 */ "speed_opt ::=",
 /* 128 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 129 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 130 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 131 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 132 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 133 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 134 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 135 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 136 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 137 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 138 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 139 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 140 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 141 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 142 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 143 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 144 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 145 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 146 */ "multi_create_clause ::= create_subtable_clause",
 /* 147 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 148 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 149 */ "multi_drop_clause ::= drop_table_clause",
 /* 150 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 151 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 152 */ "specific_cols_opt ::=",
 /* 153 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 154 */ "full_table_name ::= table_name",
 /* 155 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 156 */ "column_def_list ::= column_def",
 /* 157 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 158 */ "column_def ::= column_name type_name",
 /* 159 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 160 */ "type_name ::= BOOL",
 /* 161 */ "type_name ::= TINYINT",
 /* 162 */ "type_name ::= SMALLINT",
 /* 163 */ "type_name ::= INT",
 /* 164 */ "type_name ::= INTEGER",
 /* 165 */ "type_name ::= BIGINT",
 /* 166 */ "type_name ::= FLOAT",
 /* 167 */ "type_name ::= DOUBLE",
 /* 168 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 169 */ "type_name ::= TIMESTAMP",
 /* 170 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 171 */ "type_name ::= TINYINT UNSIGNED",
 /* 172 */ "type_name ::= SMALLINT UNSIGNED",
 /* 173 */ "type_name ::= INT UNSIGNED",
 /* 174 */ "type_name ::= BIGINT UNSIGNED",
 /* 175 */ "type_name ::= JSON",
 /* 176 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 177 */ "type_name ::= MEDIUMBLOB",
 /* 178 */ "type_name ::= BLOB",
 /* 179 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 180 */ "type_name ::= DECIMAL",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 182 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 183 */ "tags_def_opt ::=",
 /* 184 */ "tags_def_opt ::= tags_def",
 /* 185 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 186 */ "table_options ::=",
 /* 187 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 188 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 189 */ "table_options ::= table_options WATERMARK duration_list",
 /* 190 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 191 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 192 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 193 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 194 */ "alter_table_options ::= alter_table_option",
 /* 195 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 196 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 197 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 198 */ "duration_list ::= duration_literal",
 /* 199 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 200 */ "rollup_func_list ::= rollup_func_name",
 /* 201 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 202 */ "rollup_func_name ::= function_name",
 /* 203 */ "rollup_func_name ::= FIRST",
 /* 204 */ "rollup_func_name ::= LAST",
 /* 205 */ "col_name_list ::= col_name",
 /* 206 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 207 */ "col_name ::= column_name",
 /* 208 */ "cmd ::= SHOW DNODES",
 /* 209 */ "cmd ::= SHOW USERS",
 /* 210 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 211 */ "cmd ::= SHOW DATABASES",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 214 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 215 */ "cmd ::= SHOW MNODES",
 /* 216 */ "cmd ::= SHOW QNODES",
 /* 217 */ "cmd ::= SHOW FUNCTIONS",
 /* 218 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 219 */ "cmd ::= SHOW STREAMS",
 /* 220 */ "cmd ::= SHOW ACCOUNTS",
 /* 221 */ "cmd ::= SHOW APPS",
 /* 222 */ "cmd ::= SHOW CONNECTIONS",
 /* 223 */ "cmd ::= SHOW LICENCES",
 /* 224 */ "cmd ::= SHOW GRANTS",
 /* 225 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 226 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 227 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 228 */ "cmd ::= SHOW QUERIES",
 /* 229 */ "cmd ::= SHOW SCORES",
 /* 230 */ "cmd ::= SHOW TOPICS",
 /* 231 */ "cmd ::= SHOW VARIABLES",
 /* 232 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 233 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 234 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 235 */ "cmd ::= SHOW BNODES",
 /* 236 */ "cmd ::= SHOW SNODES",
 /* 237 */ "cmd ::= SHOW CLUSTER",
 /* 238 */ "cmd ::= SHOW TRANSACTIONS",
 /* 239 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 240 */ "cmd ::= SHOW CONSUMERS",
 /* 241 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 242 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 244 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 245 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 246 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 247 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 248 */ "db_name_cond_opt ::=",
 /* 249 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 250 */ "like_pattern_opt ::=",
 /* 251 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 252 */ "table_name_cond ::= table_name",
 /* 253 */ "from_db_opt ::=",
 /* 254 */ "from_db_opt ::= FROM db_name",
 /* 255 */ "tag_list_opt ::=",
 /* 256 */ "tag_list_opt ::= tag_item",
 /* 257 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 258 */ "tag_item ::= TBNAME",
 /* 259 */ "tag_item ::= QTAGS",
 /* 260 */ "tag_item ::= column_name",
 /* 261 */ "tag_item ::= column_name column_alias",
 /* 262 */ "tag_item ::= column_name AS column_alias",
 /* 263 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 264 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 265 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 266 */ "full_index_name ::= index_name",
 /* 267 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 268 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 269 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 270 */ "func_list ::= func",
 /* 271 */ "func_list ::= func_list NK_COMMA func",
 /* 272 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 273 */ "sma_func_name ::= function_name",
 /* 274 */ "sma_func_name ::= COUNT",
 /* 275 */ "sma_func_name ::= FIRST",
 /* 276 */ "sma_func_name ::= LAST",
 /* 277 */ "sma_func_name ::= LAST_ROW",
 /* 278 */ "sma_stream_opt ::=",
 /* 279 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 280 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 281 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 282 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 283 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 284 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 285 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 286 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 287 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 288 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 289 */ "cmd ::= DESC full_table_name",
 /* 290 */ "cmd ::= DESCRIBE full_table_name",
 /* 291 */ "cmd ::= RESET QUERY CACHE",
 /* 292 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 293 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 294 */ "analyze_opt ::=",
 /* 295 */ "analyze_opt ::= ANALYZE",
 /* 296 */ "explain_options ::=",
 /* 297 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 298 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 299 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 300 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 301 */ "agg_func_opt ::=",
 /* 302 */ "agg_func_opt ::= AGGREGATE",
 /* 303 */ "bufsize_opt ::=",
 /* 304 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 305 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 306 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 307 */ "col_list_opt ::=",
 /* 308 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 309 */ "tag_def_or_ref_opt ::=",
 /* 310 */ "tag_def_or_ref_opt ::= tags_def",
 /* 311 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 312 */ "stream_options ::=",
 /* 313 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 314 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 315 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 316 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 317 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 318 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 319 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 320 */ "subtable_opt ::=",
 /* 321 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 322 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 323 */ "cmd ::= KILL QUERY NK_STRING",
 /* 324 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 325 */ "cmd ::= BALANCE VGROUP",
 /* 326 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 327 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 328 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 329 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 330 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 331 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 332 */ "cmd ::= query_or_subquery",
 /* 333 */ "cmd ::= insert_query",
 /* 334 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 335 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 336 */ "literal ::= NK_INTEGER",
 /* 337 */ "literal ::= NK_FLOAT",
 /* 338 */ "literal ::= NK_STRING",
 /* 339 */ "literal ::= NK_BOOL",
 /* 340 */ "literal ::= TIMESTAMP NK_STRING",
 /* 341 */ "literal ::= duration_literal",
 /* 342 */ "literal ::= NULL",
 /* 343 */ "literal ::= NK_QUESTION",
 /* 344 */ "duration_literal ::= NK_VARIABLE",
 /* 345 */ "signed ::= NK_INTEGER",
 /* 346 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 347 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 348 */ "signed ::= NK_FLOAT",
 /* 349 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 350 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 351 */ "signed_literal ::= signed",
 /* 352 */ "signed_literal ::= NK_STRING",
 /* 353 */ "signed_literal ::= NK_BOOL",
 /* 354 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 355 */ "signed_literal ::= duration_literal",
 /* 356 */ "signed_literal ::= NULL",
 /* 357 */ "signed_literal ::= literal_func",
 /* 358 */ "signed_literal ::= NK_QUESTION",
 /* 359 */ "literal_list ::= signed_literal",
 /* 360 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 361 */ "db_name ::= NK_ID",
 /* 362 */ "table_name ::= NK_ID",
 /* 363 */ "column_name ::= NK_ID",
 /* 364 */ "function_name ::= NK_ID",
 /* 365 */ "table_alias ::= NK_ID",
 /* 366 */ "column_alias ::= NK_ID",
 /* 367 */ "user_name ::= NK_ID",
 /* 368 */ "topic_name ::= NK_ID",
 /* 369 */ "stream_name ::= NK_ID",
 /* 370 */ "cgroup_name ::= NK_ID",
 /* 371 */ "index_name ::= NK_ID",
 /* 372 */ "expr_or_subquery ::= expression",
 /* 373 */ "expression ::= literal",
 /* 374 */ "expression ::= pseudo_column",
 /* 375 */ "expression ::= column_reference",
 /* 376 */ "expression ::= function_expression",
 /* 377 */ "expression ::= case_when_expression",
 /* 378 */ "expression ::= NK_LP expression NK_RP",
 /* 379 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 380 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 381 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 382 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 383 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 384 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 385 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 386 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 387 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 388 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 389 */ "expression_list ::= expr_or_subquery",
 /* 390 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 391 */ "column_reference ::= column_name",
 /* 392 */ "column_reference ::= table_name NK_DOT column_name",
 /* 393 */ "pseudo_column ::= ROWTS",
 /* 394 */ "pseudo_column ::= TBNAME",
 /* 395 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 396 */ "pseudo_column ::= QSTART",
 /* 397 */ "pseudo_column ::= QEND",
 /* 398 */ "pseudo_column ::= QDURATION",
 /* 399 */ "pseudo_column ::= WSTART",
 /* 400 */ "pseudo_column ::= WEND",
 /* 401 */ "pseudo_column ::= WDURATION",
 /* 402 */ "pseudo_column ::= IROWTS",
 /* 403 */ "pseudo_column ::= ISFILLED",
 /* 404 */ "pseudo_column ::= QTAGS",
 /* 405 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 406 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 407 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 408 */ "function_expression ::= literal_func",
 /* 409 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 410 */ "literal_func ::= NOW",
 /* 411 */ "noarg_func ::= NOW",
 /* 412 */ "noarg_func ::= TODAY",
 /* 413 */ "noarg_func ::= TIMEZONE",
 /* 414 */ "noarg_func ::= DATABASE",
 /* 415 */ "noarg_func ::= CLIENT_VERSION",
 /* 416 */ "noarg_func ::= SERVER_VERSION",
 /* 417 */ "noarg_func ::= SERVER_STATUS",
 /* 418 */ "noarg_func ::= CURRENT_USER",
 /* 419 */ "noarg_func ::= USER",
 /* 420 */ "star_func ::= COUNT",
 /* 421 */ "star_func ::= FIRST",
 /* 422 */ "star_func ::= LAST",
 /* 423 */ "star_func ::= LAST_ROW",
 /* 424 */ "star_func_para_list ::= NK_STAR",
 /* 425 */ "star_func_para_list ::= other_para_list",
 /* 426 */ "other_para_list ::= star_func_para",
 /* 427 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 428 */ "star_func_para ::= expr_or_subquery",
 /* 429 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 430 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 431 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 432 */ "when_then_list ::= when_then_expr",
 /* 433 */ "when_then_list ::= when_then_list when_then_expr",
 /* 434 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 435 */ "case_when_else_opt ::=",
 /* 436 */ "case_when_else_opt ::= ELSE common_expression",
 /* 437 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 438 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 439 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 440 */ "predicate ::= expr_or_subquery IS NULL",
 /* 441 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 442 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 443 */ "compare_op ::= NK_LT",
 /* 444 */ "compare_op ::= NK_GT",
 /* 445 */ "compare_op ::= NK_LE",
 /* 446 */ "compare_op ::= NK_GE",
 /* 447 */ "compare_op ::= NK_NE",
 /* 448 */ "compare_op ::= NK_EQ",
 /* 449 */ "compare_op ::= LIKE",
 /* 450 */ "compare_op ::= NOT LIKE",
 /* 451 */ "compare_op ::= MATCH",
 /* 452 */ "compare_op ::= NMATCH",
 /* 453 */ "compare_op ::= CONTAINS",
 /* 454 */ "in_op ::= IN",
 /* 455 */ "in_op ::= NOT IN",
 /* 456 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 457 */ "boolean_value_expression ::= boolean_primary",
 /* 458 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 459 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 460 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 461 */ "boolean_primary ::= predicate",
 /* 462 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 463 */ "common_expression ::= expr_or_subquery",
 /* 464 */ "common_expression ::= boolean_value_expression",
 /* 465 */ "from_clause_opt ::=",
 /* 466 */ "from_clause_opt ::= FROM table_reference_list",
 /* 467 */ "table_reference_list ::= table_reference",
 /* 468 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 469 */ "table_reference ::= table_primary",
 /* 470 */ "table_reference ::= joined_table",
 /* 471 */ "table_primary ::= table_name alias_opt",
 /* 472 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 473 */ "table_primary ::= subquery alias_opt",
 /* 474 */ "table_primary ::= parenthesized_joined_table",
 /* 475 */ "alias_opt ::=",
 /* 476 */ "alias_opt ::= table_alias",
 /* 477 */ "alias_opt ::= AS table_alias",
 /* 478 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 479 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 480 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 481 */ "join_type ::=",
 /* 482 */ "join_type ::= INNER",
 /* 483 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 484 */ "set_quantifier_opt ::=",
 /* 485 */ "set_quantifier_opt ::= DISTINCT",
 /* 486 */ "set_quantifier_opt ::= ALL",
 /* 487 */ "select_list ::= select_item",
 /* 488 */ "select_list ::= select_list NK_COMMA select_item",
 /* 489 */ "select_item ::= NK_STAR",
 /* 490 */ "select_item ::= common_expression",
 /* 491 */ "select_item ::= common_expression column_alias",
 /* 492 */ "select_item ::= common_expression AS column_alias",
 /* 493 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 494 */ "where_clause_opt ::=",
 /* 495 */ "where_clause_opt ::= WHERE search_condition",
 /* 496 */ "partition_by_clause_opt ::=",
 /* 497 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 498 */ "partition_list ::= partition_item",
 /* 499 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 500 */ "partition_item ::= expr_or_subquery",
 /* 501 */ "partition_item ::= expr_or_subquery column_alias",
 /* 502 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 503 */ "twindow_clause_opt ::=",
 /* 504 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 505 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 506 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 507 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 508 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 509 */ "sliding_opt ::=",
 /* 510 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 511 */ "fill_opt ::=",
 /* 512 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 513 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 514 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP",
 /* 515 */ "fill_mode ::= NONE",
 /* 516 */ "fill_mode ::= PREV",
 /* 517 */ "fill_mode ::= NULL",
 /* 518 */ "fill_mode ::= NULL_F",
 /* 519 */ "fill_mode ::= LINEAR",
 /* 520 */ "fill_mode ::= NEXT",
 /* 521 */ "group_by_clause_opt ::=",
 /* 522 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 523 */ "group_by_list ::= expr_or_subquery",
 /* 524 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 525 */ "having_clause_opt ::=",
 /* 526 */ "having_clause_opt ::= HAVING search_condition",
 /* 527 */ "range_opt ::=",
 /* 528 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 529 */ "every_opt ::=",
 /* 530 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 531 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 532 */ "query_simple ::= query_specification",
 /* 533 */ "query_simple ::= union_query_expression",
 /* 534 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 535 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 536 */ "query_simple_or_subquery ::= query_simple",
 /* 537 */ "query_simple_or_subquery ::= subquery",
 /* 538 */ "query_or_subquery ::= query_expression",
 /* 539 */ "query_or_subquery ::= subquery",
 /* 540 */ "order_by_clause_opt ::=",
 /* 541 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 542 */ "slimit_clause_opt ::=",
 /* 543 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 544 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 545 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 546 */ "limit_clause_opt ::=",
 /* 547 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 548 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 549 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 550 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 551 */ "subquery ::= NK_LP subquery NK_RP",
 /* 552 */ "search_condition ::= common_expression",
 /* 553 */ "sort_specification_list ::= sort_specification",
 /* 554 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 555 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 556 */ "ordering_specification_opt ::=",
 /* 557 */ "ordering_specification_opt ::= ASC",
 /* 558 */ "ordering_specification_opt ::= DESC",
 /* 559 */ "null_ordering_opt ::=",
 /* 560 */ "null_ordering_opt ::= NULLS FIRST",
 /* 561 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 328: /* cmd */
    case 331: /* literal */
    case 344: /* db_options */
    case 346: /* alter_db_options */
    case 352: /* retention */
    case 353: /* full_table_name */
    case 356: /* table_options */
    case 360: /* alter_table_clause */
    case 361: /* alter_table_options */
    case 364: /* signed_literal */
    case 365: /* create_subtable_clause */
    case 368: /* drop_table_clause */
    case 371: /* column_def */
    case 375: /* duration_literal */
    case 376: /* rollup_func_name */
    case 378: /* col_name */
    case 379: /* db_name_cond_opt */
    case 380: /* like_pattern_opt */
    case 381: /* table_name_cond */
    case 382: /* from_db_opt */
    case 384: /* tag_item */
    case 386: /* full_index_name */
    case 387: /* index_options */
    case 390: /* sliding_opt */
    case 391: /* sma_stream_opt */
    case 392: /* func */
    case 394: /* query_or_subquery */
    case 397: /* explain_options */
    case 398: /* insert_query */
    case 402: /* stream_options */
    case 405: /* subtable_opt */
    case 406: /* expression */
    case 408: /* where_clause_opt */
    case 409: /* signed */
    case 410: /* literal_func */
    case 413: /* expr_or_subquery */
    case 414: /* pseudo_column */
    case 415: /* column_reference */
    case 416: /* function_expression */
    case 417: /* case_when_expression */
    case 422: /* star_func_para */
    case 424: /* case_when_else_opt */
    case 425: /* common_expression */
    case 426: /* when_then_expr */
    case 427: /* predicate */
    case 430: /* in_predicate_value */
    case 431: /* boolean_value_expression */
    case 432: /* boolean_primary */
    case 433: /* from_clause_opt */
    case 434: /* table_reference_list */
    case 435: /* table_reference */
    case 436: /* table_primary */
    case 437: /* joined_table */
    case 439: /* subquery */
    case 440: /* parenthesized_joined_table */
    case 442: /* search_condition */
    case 443: /* query_specification */
    case 447: /* range_opt */
    case 448: /* every_opt */
    case 449: /* fill_opt */
    case 450: /* twindow_clause_opt */
    case 452: /* having_clause_opt */
    case 453: /* select_item */
    case 455: /* partition_item */
    case 458: /* query_expression */
    case 459: /* query_simple */
    case 461: /* slimit_clause_opt */
    case 462: /* limit_clause_opt */
    case 463: /* union_query_expression */
    case 464: /* query_simple_or_subquery */
    case 466: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy42)); 
}
      break;
    case 329: /* account_options */
    case 330: /* alter_account_options */
    case 332: /* alter_account_option */
    case 347: /* speed_opt */
    case 400: /* bufsize_opt */
{
 
}
      break;
    case 333: /* user_name */
    case 336: /* priv_level */
    case 339: /* db_name */
    case 340: /* topic_name */
    case 341: /* dnode_endpoint */
    case 362: /* column_name */
    case 370: /* table_name */
    case 377: /* function_name */
    case 385: /* column_alias */
    case 388: /* index_name */
    case 393: /* sma_func_name */
    case 395: /* cgroup_name */
    case 401: /* stream_name */
    case 412: /* table_alias */
    case 418: /* star_func */
    case 420: /* noarg_func */
    case 438: /* alias_opt */
{
 
}
      break;
    case 334: /* sysinfo_opt */
{
 
}
      break;
    case 335: /* privileges */
    case 337: /* priv_type_list */
    case 338: /* priv_type */
{
 
}
      break;
    case 342: /* force_opt */
    case 343: /* not_exists_opt */
    case 345: /* exists_opt */
    case 396: /* analyze_opt */
    case 399: /* agg_func_opt */
    case 444: /* set_quantifier_opt */
{
 
}
      break;
    case 348: /* integer_list */
    case 349: /* variable_list */
    case 350: /* retention_list */
    case 354: /* column_def_list */
    case 355: /* tags_def_opt */
    case 357: /* multi_create_clause */
    case 358: /* tags_def */
    case 359: /* multi_drop_clause */
    case 366: /* specific_cols_opt */
    case 367: /* expression_list */
    case 369: /* col_name_list */
    case 372: /* duration_list */
    case 373: /* rollup_func_list */
    case 383: /* tag_list_opt */
    case 389: /* func_list */
    case 403: /* col_list_opt */
    case 404: /* tag_def_or_ref_opt */
    case 407: /* dnode_list */
    case 411: /* literal_list */
    case 419: /* star_func_para_list */
    case 421: /* other_para_list */
    case 423: /* when_then_list */
    case 445: /* select_list */
    case 446: /* partition_by_clause_opt */
    case 451: /* group_by_clause_opt */
    case 454: /* partition_list */
    case 457: /* group_by_list */
    case 460: /* order_by_clause_opt */
    case 465: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy110)); 
}
      break;
    case 351: /* alter_db_option */
    case 374: /* alter_table_option */
{
 
}
      break;
    case 363: /* type_name */
{
 
}
      break;
    case 428: /* compare_op */
    case 429: /* in_op */
{
 
}
      break;
    case 441: /* join_type */
{
 
}
      break;
    case 456: /* fill_mode */
{
 
}
      break;
    case 467: /* ordering_specification_opt */
{
 
}
      break;
    case 468: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  328,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  328,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  329,    0 }, /* (2) account_options ::= */
  {  329,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  329,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  329,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  329,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  329,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  329,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  329,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  329,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  329,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  330,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  330,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  332,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  332,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  332,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  332,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  332,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  332,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  332,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  332,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  332,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  332,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  328,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  328,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  328,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  328,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  328,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  334,    0 }, /* (29) sysinfo_opt ::= */
  {  334,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  328,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  328,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  335,   -1 }, /* (33) privileges ::= ALL */
  {  335,   -1 }, /* (34) privileges ::= priv_type_list */
  {  335,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  337,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  337,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  338,   -1 }, /* (38) priv_type ::= READ */
  {  338,   -1 }, /* (39) priv_type ::= WRITE */
  {  336,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  336,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  336,   -1 }, /* (42) priv_level ::= topic_name */
  {  328,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  328,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  328,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  328,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  328,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  328,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  328,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  328,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  341,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  341,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  341,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  342,    0 }, /* (54) force_opt ::= */
  {  342,   -1 }, /* (55) force_opt ::= FORCE */
  {  328,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  328,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  328,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  328,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  328,   -2 }, /* (68) cmd ::= USE db_name */
  {  328,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  328,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  328,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  328,   -3 }, /* (72) cmd ::= COMPACT DATABASE db_name */
  {  343,   -3 }, /* (73) not_exists_opt ::= IF NOT EXISTS */
  {  343,    0 }, /* (74) not_exists_opt ::= */
  {  345,   -2 }, /* (75) exists_opt ::= IF EXISTS */
  {  345,    0 }, /* (76) exists_opt ::= */
  {  344,    0 }, /* (77) db_options ::= */
  {  344,   -3 }, /* (78) db_options ::= db_options BUFFER NK_INTEGER */
  {  344,   -3 }, /* (79) db_options ::= db_options CACHEMODEL NK_STRING */
  {  344,   -3 }, /* (80) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  344,   -3 }, /* (81) db_options ::= db_options COMP NK_INTEGER */
  {  344,   -3 }, /* (82) db_options ::= db_options DURATION NK_INTEGER */
  {  344,   -3 }, /* (83) db_options ::= db_options DURATION NK_VARIABLE */
  {  344,   -3 }, /* (84) db_options ::= db_options MAXROWS NK_INTEGER */
  {  344,   -3 }, /* (85) db_options ::= db_options MINROWS NK_INTEGER */
  {  344,   -3 }, /* (86) db_options ::= db_options KEEP integer_list */
  {  344,   -3 }, /* (87) db_options ::= db_options KEEP variable_list */
  {  344,   -3 }, /* (88) db_options ::= db_options PAGES NK_INTEGER */
  {  344,   -3 }, /* (89) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  344,   -3 }, /* (90) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  344,   -3 }, /* (91) db_options ::= db_options PRECISION NK_STRING */
  {  344,   -3 }, /* (92) db_options ::= db_options REPLICA NK_INTEGER */
  {  344,   -3 }, /* (93) db_options ::= db_options VGROUPS NK_INTEGER */
  {  344,   -3 }, /* (94) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  344,   -3 }, /* (95) db_options ::= db_options RETENTIONS retention_list */
  {  344,   -3 }, /* (96) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  344,   -3 }, /* (97) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  344,   -3 }, /* (98) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  344,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  344,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  344,   -3 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  344,   -4 }, /* (102) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  344,   -3 }, /* (103) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  344,   -3 }, /* (104) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  344,   -3 }, /* (105) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  344,   -3 }, /* (106) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  344,   -3 }, /* (107) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  346,   -1 }, /* (108) alter_db_options ::= alter_db_option */
  {  346,   -2 }, /* (109) alter_db_options ::= alter_db_options alter_db_option */
  {  351,   -2 }, /* (110) alter_db_option ::= BUFFER NK_INTEGER */
  {  351,   -2 }, /* (111) alter_db_option ::= CACHEMODEL NK_STRING */
  {  351,   -2 }, /* (112) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  351,   -2 }, /* (113) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  351,   -2 }, /* (114) alter_db_option ::= KEEP integer_list */
  {  351,   -2 }, /* (115) alter_db_option ::= KEEP variable_list */
  {  351,   -2 }, /* (116) alter_db_option ::= PAGES NK_INTEGER */
  {  351,   -2 }, /* (117) alter_db_option ::= REPLICA NK_INTEGER */
  {  351,   -2 }, /* (118) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  351,   -2 }, /* (119) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  348,   -1 }, /* (120) integer_list ::= NK_INTEGER */
  {  348,   -3 }, /* (121) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  349,   -1 }, /* (122) variable_list ::= NK_VARIABLE */
  {  349,   -3 }, /* (123) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  350,   -1 }, /* (124) retention_list ::= retention */
  {  350,   -3 }, /* (125) retention_list ::= retention_list NK_COMMA retention */
  {  352,   -3 }, /* (126) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  347,    0 }, /* (127) speed_opt ::= */
  {  347,   -2 }, /* (128) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  328,   -9 }, /* (129) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  328,   -3 }, /* (130) cmd ::= CREATE TABLE multi_create_clause */
  {  328,   -9 }, /* (131) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  328,   -3 }, /* (132) cmd ::= DROP TABLE multi_drop_clause */
  {  328,   -4 }, /* (133) cmd ::= DROP STABLE exists_opt full_table_name */
  {  328,   -3 }, /* (134) cmd ::= ALTER TABLE alter_table_clause */
  {  328,   -3 }, /* (135) cmd ::= ALTER STABLE alter_table_clause */
  {  360,   -2 }, /* (136) alter_table_clause ::= full_table_name alter_table_options */
  {  360,   -5 }, /* (137) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  360,   -4 }, /* (138) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  360,   -5 }, /* (139) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  360,   -5 }, /* (140) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  360,   -5 }, /* (141) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  360,   -4 }, /* (142) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  360,   -5 }, /* (143) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  360,   -5 }, /* (144) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  360,   -6 }, /* (145) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  357,   -1 }, /* (146) multi_create_clause ::= create_subtable_clause */
  {  357,   -2 }, /* (147) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  365,  -10 }, /* (148) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  359,   -1 }, /* (149) multi_drop_clause ::= drop_table_clause */
  {  359,   -2 }, /* (150) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  368,   -2 }, /* (151) drop_table_clause ::= exists_opt full_table_name */
  {  366,    0 }, /* (152) specific_cols_opt ::= */
  {  366,   -3 }, /* (153) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  353,   -1 }, /* (154) full_table_name ::= table_name */
  {  353,   -3 }, /* (155) full_table_name ::= db_name NK_DOT table_name */
  {  354,   -1 }, /* (156) column_def_list ::= column_def */
  {  354,   -3 }, /* (157) column_def_list ::= column_def_list NK_COMMA column_def */
  {  371,   -2 }, /* (158) column_def ::= column_name type_name */
  {  371,   -4 }, /* (159) column_def ::= column_name type_name COMMENT NK_STRING */
  {  363,   -1 }, /* (160) type_name ::= BOOL */
  {  363,   -1 }, /* (161) type_name ::= TINYINT */
  {  363,   -1 }, /* (162) type_name ::= SMALLINT */
  {  363,   -1 }, /* (163) type_name ::= INT */
  {  363,   -1 }, /* (164) type_name ::= INTEGER */
  {  363,   -1 }, /* (165) type_name ::= BIGINT */
  {  363,   -1 }, /* (166) type_name ::= FLOAT */
  {  363,   -1 }, /* (167) type_name ::= DOUBLE */
  {  363,   -4 }, /* (168) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  363,   -1 }, /* (169) type_name ::= TIMESTAMP */
  {  363,   -4 }, /* (170) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  363,   -2 }, /* (171) type_name ::= TINYINT UNSIGNED */
  {  363,   -2 }, /* (172) type_name ::= SMALLINT UNSIGNED */
  {  363,   -2 }, /* (173) type_name ::= INT UNSIGNED */
  {  363,   -2 }, /* (174) type_name ::= BIGINT UNSIGNED */
  {  363,   -1 }, /* (175) type_name ::= JSON */
  {  363,   -4 }, /* (176) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  363,   -1 }, /* (177) type_name ::= MEDIUMBLOB */
  {  363,   -1 }, /* (178) type_name ::= BLOB */
  {  363,   -4 }, /* (179) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  363,   -1 }, /* (180) type_name ::= DECIMAL */
  {  363,   -4 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  363,   -6 }, /* (182) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  355,    0 }, /* (183) tags_def_opt ::= */
  {  355,   -1 }, /* (184) tags_def_opt ::= tags_def */
  {  358,   -4 }, /* (185) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  356,    0 }, /* (186) table_options ::= */
  {  356,   -3 }, /* (187) table_options ::= table_options COMMENT NK_STRING */
  {  356,   -3 }, /* (188) table_options ::= table_options MAX_DELAY duration_list */
  {  356,   -3 }, /* (189) table_options ::= table_options WATERMARK duration_list */
  {  356,   -5 }, /* (190) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  356,   -3 }, /* (191) table_options ::= table_options TTL NK_INTEGER */
  {  356,   -5 }, /* (192) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  356,   -3 }, /* (193) table_options ::= table_options DELETE_MARK duration_list */
  {  361,   -1 }, /* (194) alter_table_options ::= alter_table_option */
  {  361,   -2 }, /* (195) alter_table_options ::= alter_table_options alter_table_option */
  {  374,   -2 }, /* (196) alter_table_option ::= COMMENT NK_STRING */
  {  374,   -2 }, /* (197) alter_table_option ::= TTL NK_INTEGER */
  {  372,   -1 }, /* (198) duration_list ::= duration_literal */
  {  372,   -3 }, /* (199) duration_list ::= duration_list NK_COMMA duration_literal */
  {  373,   -1 }, /* (200) rollup_func_list ::= rollup_func_name */
  {  373,   -3 }, /* (201) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  376,   -1 }, /* (202) rollup_func_name ::= function_name */
  {  376,   -1 }, /* (203) rollup_func_name ::= FIRST */
  {  376,   -1 }, /* (204) rollup_func_name ::= LAST */
  {  369,   -1 }, /* (205) col_name_list ::= col_name */
  {  369,   -3 }, /* (206) col_name_list ::= col_name_list NK_COMMA col_name */
  {  378,   -1 }, /* (207) col_name ::= column_name */
  {  328,   -2 }, /* (208) cmd ::= SHOW DNODES */
  {  328,   -2 }, /* (209) cmd ::= SHOW USERS */
  {  328,   -3 }, /* (210) cmd ::= SHOW USER PRIVILEGES */
  {  328,   -2 }, /* (211) cmd ::= SHOW DATABASES */
  {  328,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  328,   -4 }, /* (213) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  328,   -3 }, /* (214) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  328,   -2 }, /* (215) cmd ::= SHOW MNODES */
  {  328,   -2 }, /* (216) cmd ::= SHOW QNODES */
  {  328,   -2 }, /* (217) cmd ::= SHOW FUNCTIONS */
  {  328,   -5 }, /* (218) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  328,   -2 }, /* (219) cmd ::= SHOW STREAMS */
  {  328,   -2 }, /* (220) cmd ::= SHOW ACCOUNTS */
  {  328,   -2 }, /* (221) cmd ::= SHOW APPS */
  {  328,   -2 }, /* (222) cmd ::= SHOW CONNECTIONS */
  {  328,   -2 }, /* (223) cmd ::= SHOW LICENCES */
  {  328,   -2 }, /* (224) cmd ::= SHOW GRANTS */
  {  328,   -4 }, /* (225) cmd ::= SHOW CREATE DATABASE db_name */
  {  328,   -4 }, /* (226) cmd ::= SHOW CREATE TABLE full_table_name */
  {  328,   -4 }, /* (227) cmd ::= SHOW CREATE STABLE full_table_name */
  {  328,   -2 }, /* (228) cmd ::= SHOW QUERIES */
  {  328,   -2 }, /* (229) cmd ::= SHOW SCORES */
  {  328,   -2 }, /* (230) cmd ::= SHOW TOPICS */
  {  328,   -2 }, /* (231) cmd ::= SHOW VARIABLES */
  {  328,   -3 }, /* (232) cmd ::= SHOW CLUSTER VARIABLES */
  {  328,   -3 }, /* (233) cmd ::= SHOW LOCAL VARIABLES */
  {  328,   -5 }, /* (234) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  328,   -2 }, /* (235) cmd ::= SHOW BNODES */
  {  328,   -2 }, /* (236) cmd ::= SHOW SNODES */
  {  328,   -2 }, /* (237) cmd ::= SHOW CLUSTER */
  {  328,   -2 }, /* (238) cmd ::= SHOW TRANSACTIONS */
  {  328,   -4 }, /* (239) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  328,   -2 }, /* (240) cmd ::= SHOW CONSUMERS */
  {  328,   -2 }, /* (241) cmd ::= SHOW SUBSCRIPTIONS */
  {  328,   -5 }, /* (242) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  328,   -7 }, /* (243) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  328,   -3 }, /* (244) cmd ::= SHOW VNODES NK_INTEGER */
  {  328,   -3 }, /* (245) cmd ::= SHOW VNODES NK_STRING */
  {  328,   -3 }, /* (246) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  328,   -3 }, /* (247) cmd ::= SHOW CLUSTER ALIVE */
  {  379,    0 }, /* (248) db_name_cond_opt ::= */
  {  379,   -2 }, /* (249) db_name_cond_opt ::= db_name NK_DOT */
  {  380,    0 }, /* (250) like_pattern_opt ::= */
  {  380,   -2 }, /* (251) like_pattern_opt ::= LIKE NK_STRING */
  {  381,   -1 }, /* (252) table_name_cond ::= table_name */
  {  382,    0 }, /* (253) from_db_opt ::= */
  {  382,   -2 }, /* (254) from_db_opt ::= FROM db_name */
  {  383,    0 }, /* (255) tag_list_opt ::= */
  {  383,   -1 }, /* (256) tag_list_opt ::= tag_item */
  {  383,   -3 }, /* (257) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  384,   -1 }, /* (258) tag_item ::= TBNAME */
  {  384,   -1 }, /* (259) tag_item ::= QTAGS */
  {  384,   -1 }, /* (260) tag_item ::= column_name */
  {  384,   -2 }, /* (261) tag_item ::= column_name column_alias */
  {  384,   -3 }, /* (262) tag_item ::= column_name AS column_alias */
  {  328,   -8 }, /* (263) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  328,   -9 }, /* (264) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  328,   -4 }, /* (265) cmd ::= DROP INDEX exists_opt full_index_name */
  {  386,   -1 }, /* (266) full_index_name ::= index_name */
  {  386,   -3 }, /* (267) full_index_name ::= db_name NK_DOT index_name */
  {  387,  -10 }, /* (268) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  387,  -12 }, /* (269) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  389,   -1 }, /* (270) func_list ::= func */
  {  389,   -3 }, /* (271) func_list ::= func_list NK_COMMA func */
  {  392,   -4 }, /* (272) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  393,   -1 }, /* (273) sma_func_name ::= function_name */
  {  393,   -1 }, /* (274) sma_func_name ::= COUNT */
  {  393,   -1 }, /* (275) sma_func_name ::= FIRST */
  {  393,   -1 }, /* (276) sma_func_name ::= LAST */
  {  393,   -1 }, /* (277) sma_func_name ::= LAST_ROW */
  {  391,    0 }, /* (278) sma_stream_opt ::= */
  {  391,   -3 }, /* (279) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  391,   -3 }, /* (280) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  391,   -3 }, /* (281) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  328,   -6 }, /* (282) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  328,   -7 }, /* (283) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  328,   -9 }, /* (284) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  328,   -7 }, /* (285) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  328,   -9 }, /* (286) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  328,   -4 }, /* (287) cmd ::= DROP TOPIC exists_opt topic_name */
  {  328,   -7 }, /* (288) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  328,   -2 }, /* (289) cmd ::= DESC full_table_name */
  {  328,   -2 }, /* (290) cmd ::= DESCRIBE full_table_name */
  {  328,   -3 }, /* (291) cmd ::= RESET QUERY CACHE */
  {  328,   -4 }, /* (292) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  328,   -4 }, /* (293) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
  {  396,    0 }, /* (294) analyze_opt ::= */
  {  396,   -1 }, /* (295) analyze_opt ::= ANALYZE */
  {  397,    0 }, /* (296) explain_options ::= */
  {  397,   -3 }, /* (297) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  397,   -3 }, /* (298) explain_options ::= explain_options RATIO NK_FLOAT */
  {  328,  -10 }, /* (299) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  328,   -4 }, /* (300) cmd ::= DROP FUNCTION exists_opt function_name */
  {  399,    0 }, /* (301) agg_func_opt ::= */
  {  399,   -1 }, /* (302) agg_func_opt ::= AGGREGATE */
  {  400,    0 }, /* (303) bufsize_opt ::= */
  {  400,   -2 }, /* (304) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  328,  -12 }, /* (305) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  328,   -4 }, /* (306) cmd ::= DROP STREAM exists_opt stream_name */
  {  403,    0 }, /* (307) col_list_opt ::= */
  {  403,   -3 }, /* (308) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  404,    0 }, /* (309) tag_def_or_ref_opt ::= */
  {  404,   -1 }, /* (310) tag_def_or_ref_opt ::= tags_def */
  {  404,   -4 }, /* (311) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  402,    0 }, /* (312) stream_options ::= */
  {  402,   -3 }, /* (313) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  402,   -3 }, /* (314) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  402,   -4 }, /* (315) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  402,   -3 }, /* (316) stream_options ::= stream_options WATERMARK duration_literal */
  {  402,   -4 }, /* (317) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  402,   -3 }, /* (318) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  402,   -4 }, /* (319) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
  {  405,    0 }, /* (320) subtable_opt ::= */
  {  405,   -4 }, /* (321) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  328,   -3 }, /* (322) cmd ::= KILL CONNECTION NK_INTEGER */
  {  328,   -3 }, /* (323) cmd ::= KILL QUERY NK_STRING */
  {  328,   -3 }, /* (324) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  328,   -2 }, /* (325) cmd ::= BALANCE VGROUP */
  {  328,   -4 }, /* (326) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  328,   -4 }, /* (327) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  328,   -3 }, /* (328) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  407,   -2 }, /* (329) dnode_list ::= DNODE NK_INTEGER */
  {  407,   -3 }, /* (330) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  328,   -4 }, /* (331) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  328,   -1 }, /* (332) cmd ::= query_or_subquery */
  {  328,   -1 }, /* (333) cmd ::= insert_query */
  {  398,   -7 }, /* (334) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  398,   -4 }, /* (335) insert_query ::= INSERT INTO full_table_name query_or_subquery */
  {  331,   -1 }, /* (336) literal ::= NK_INTEGER */
  {  331,   -1 }, /* (337) literal ::= NK_FLOAT */
  {  331,   -1 }, /* (338) literal ::= NK_STRING */
  {  331,   -1 }, /* (339) literal ::= NK_BOOL */
  {  331,   -2 }, /* (340) literal ::= TIMESTAMP NK_STRING */
  {  331,   -1 }, /* (341) literal ::= duration_literal */
  {  331,   -1 }, /* (342) literal ::= NULL */
  {  331,   -1 }, /* (343) literal ::= NK_QUESTION */
  {  375,   -1 }, /* (344) duration_literal ::= NK_VARIABLE */
  {  409,   -1 }, /* (345) signed ::= NK_INTEGER */
  {  409,   -2 }, /* (346) signed ::= NK_PLUS NK_INTEGER */
  {  409,   -2 }, /* (347) signed ::= NK_MINUS NK_INTEGER */
  {  409,   -1 }, /* (348) signed ::= NK_FLOAT */
  {  409,   -2 }, /* (349) signed ::= NK_PLUS NK_FLOAT */
  {  409,   -2 }, /* (350) signed ::= NK_MINUS NK_FLOAT */
  {  364,   -1 }, /* (351) signed_literal ::= signed */
  {  364,   -1 }, /* (352) signed_literal ::= NK_STRING */
  {  364,   -1 }, /* (353) signed_literal ::= NK_BOOL */
  {  364,   -2 }, /* (354) signed_literal ::= TIMESTAMP NK_STRING */
  {  364,   -1 }, /* (355) signed_literal ::= duration_literal */
  {  364,   -1 }, /* (356) signed_literal ::= NULL */
  {  364,   -1 }, /* (357) signed_literal ::= literal_func */
  {  364,   -1 }, /* (358) signed_literal ::= NK_QUESTION */
  {  411,   -1 }, /* (359) literal_list ::= signed_literal */
  {  411,   -3 }, /* (360) literal_list ::= literal_list NK_COMMA signed_literal */
  {  339,   -1 }, /* (361) db_name ::= NK_ID */
  {  370,   -1 }, /* (362) table_name ::= NK_ID */
  {  362,   -1 }, /* (363) column_name ::= NK_ID */
  {  377,   -1 }, /* (364) function_name ::= NK_ID */
  {  412,   -1 }, /* (365) table_alias ::= NK_ID */
  {  385,   -1 }, /* (366) column_alias ::= NK_ID */
  {  333,   -1 }, /* (367) user_name ::= NK_ID */
  {  340,   -1 }, /* (368) topic_name ::= NK_ID */
  {  401,   -1 }, /* (369) stream_name ::= NK_ID */
  {  395,   -1 }, /* (370) cgroup_name ::= NK_ID */
  {  388,   -1 }, /* (371) index_name ::= NK_ID */
  {  413,   -1 }, /* (372) expr_or_subquery ::= expression */
  {  406,   -1 }, /* (373) expression ::= literal */
  {  406,   -1 }, /* (374) expression ::= pseudo_column */
  {  406,   -1 }, /* (375) expression ::= column_reference */
  {  406,   -1 }, /* (376) expression ::= function_expression */
  {  406,   -1 }, /* (377) expression ::= case_when_expression */
  {  406,   -3 }, /* (378) expression ::= NK_LP expression NK_RP */
  {  406,   -2 }, /* (379) expression ::= NK_PLUS expr_or_subquery */
  {  406,   -2 }, /* (380) expression ::= NK_MINUS expr_or_subquery */
  {  406,   -3 }, /* (381) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  406,   -3 }, /* (382) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  406,   -3 }, /* (383) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  406,   -3 }, /* (384) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  406,   -3 }, /* (385) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  406,   -3 }, /* (386) expression ::= column_reference NK_ARROW NK_STRING */
  {  406,   -3 }, /* (387) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  406,   -3 }, /* (388) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  367,   -1 }, /* (389) expression_list ::= expr_or_subquery */
  {  367,   -3 }, /* (390) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  415,   -1 }, /* (391) column_reference ::= column_name */
  {  415,   -3 }, /* (392) column_reference ::= table_name NK_DOT column_name */
  {  414,   -1 }, /* (393) pseudo_column ::= ROWTS */
  {  414,   -1 }, /* (394) pseudo_column ::= TBNAME */
  {  414,   -3 }, /* (395) pseudo_column ::= table_name NK_DOT TBNAME */
  {  414,   -1 }, /* (396) pseudo_column ::= QSTART */
  {  414,   -1 }, /* (397) pseudo_column ::= QEND */
  {  414,   -1 }, /* (398) pseudo_column ::= QDURATION */
  {  414,   -1 }, /* (399) pseudo_column ::= WSTART */
  {  414,   -1 }, /* (400) pseudo_column ::= WEND */
  {  414,   -1 }, /* (401) pseudo_column ::= WDURATION */
  {  414,   -1 }, /* (402) pseudo_column ::= IROWTS */
  {  414,   -1 }, /* (403) pseudo_column ::= ISFILLED */
  {  414,   -1 }, /* (404) pseudo_column ::= QTAGS */
  {  416,   -4 }, /* (405) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  416,   -4 }, /* (406) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  416,   -6 }, /* (407) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  416,   -1 }, /* (408) function_expression ::= literal_func */
  {  410,   -3 }, /* (409) literal_func ::= noarg_func NK_LP NK_RP */
  {  410,   -1 }, /* (410) literal_func ::= NOW */
  {  420,   -1 }, /* (411) noarg_func ::= NOW */
  {  420,   -1 }, /* (412) noarg_func ::= TODAY */
  {  420,   -1 }, /* (413) noarg_func ::= TIMEZONE */
  {  420,   -1 }, /* (414) noarg_func ::= DATABASE */
  {  420,   -1 }, /* (415) noarg_func ::= CLIENT_VERSION */
  {  420,   -1 }, /* (416) noarg_func ::= SERVER_VERSION */
  {  420,   -1 }, /* (417) noarg_func ::= SERVER_STATUS */
  {  420,   -1 }, /* (418) noarg_func ::= CURRENT_USER */
  {  420,   -1 }, /* (419) noarg_func ::= USER */
  {  418,   -1 }, /* (420) star_func ::= COUNT */
  {  418,   -1 }, /* (421) star_func ::= FIRST */
  {  418,   -1 }, /* (422) star_func ::= LAST */
  {  418,   -1 }, /* (423) star_func ::= LAST_ROW */
  {  419,   -1 }, /* (424) star_func_para_list ::= NK_STAR */
  {  419,   -1 }, /* (425) star_func_para_list ::= other_para_list */
  {  421,   -1 }, /* (426) other_para_list ::= star_func_para */
  {  421,   -3 }, /* (427) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  422,   -1 }, /* (428) star_func_para ::= expr_or_subquery */
  {  422,   -3 }, /* (429) star_func_para ::= table_name NK_DOT NK_STAR */
  {  417,   -4 }, /* (430) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  417,   -5 }, /* (431) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  423,   -1 }, /* (432) when_then_list ::= when_then_expr */
  {  423,   -2 }, /* (433) when_then_list ::= when_then_list when_then_expr */
  {  426,   -4 }, /* (434) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  424,    0 }, /* (435) case_when_else_opt ::= */
  {  424,   -2 }, /* (436) case_when_else_opt ::= ELSE common_expression */
  {  427,   -3 }, /* (437) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  427,   -5 }, /* (438) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  427,   -6 }, /* (439) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  427,   -3 }, /* (440) predicate ::= expr_or_subquery IS NULL */
  {  427,   -4 }, /* (441) predicate ::= expr_or_subquery IS NOT NULL */
  {  427,   -3 }, /* (442) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  428,   -1 }, /* (443) compare_op ::= NK_LT */
  {  428,   -1 }, /* (444) compare_op ::= NK_GT */
  {  428,   -1 }, /* (445) compare_op ::= NK_LE */
  {  428,   -1 }, /* (446) compare_op ::= NK_GE */
  {  428,   -1 }, /* (447) compare_op ::= NK_NE */
  {  428,   -1 }, /* (448) compare_op ::= NK_EQ */
  {  428,   -1 }, /* (449) compare_op ::= LIKE */
  {  428,   -2 }, /* (450) compare_op ::= NOT LIKE */
  {  428,   -1 }, /* (451) compare_op ::= MATCH */
  {  428,   -1 }, /* (452) compare_op ::= NMATCH */
  {  428,   -1 }, /* (453) compare_op ::= CONTAINS */
  {  429,   -1 }, /* (454) in_op ::= IN */
  {  429,   -2 }, /* (455) in_op ::= NOT IN */
  {  430,   -3 }, /* (456) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  431,   -1 }, /* (457) boolean_value_expression ::= boolean_primary */
  {  431,   -2 }, /* (458) boolean_value_expression ::= NOT boolean_primary */
  {  431,   -3 }, /* (459) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  431,   -3 }, /* (460) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  432,   -1 }, /* (461) boolean_primary ::= predicate */
  {  432,   -3 }, /* (462) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  425,   -1 }, /* (463) common_expression ::= expr_or_subquery */
  {  425,   -1 }, /* (464) common_expression ::= boolean_value_expression */
  {  433,    0 }, /* (465) from_clause_opt ::= */
  {  433,   -2 }, /* (466) from_clause_opt ::= FROM table_reference_list */
  {  434,   -1 }, /* (467) table_reference_list ::= table_reference */
  {  434,   -3 }, /* (468) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  435,   -1 }, /* (469) table_reference ::= table_primary */
  {  435,   -1 }, /* (470) table_reference ::= joined_table */
  {  436,   -2 }, /* (471) table_primary ::= table_name alias_opt */
  {  436,   -4 }, /* (472) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  436,   -2 }, /* (473) table_primary ::= subquery alias_opt */
  {  436,   -1 }, /* (474) table_primary ::= parenthesized_joined_table */
  {  438,    0 }, /* (475) alias_opt ::= */
  {  438,   -1 }, /* (476) alias_opt ::= table_alias */
  {  438,   -2 }, /* (477) alias_opt ::= AS table_alias */
  {  440,   -3 }, /* (478) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  440,   -3 }, /* (479) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  437,   -6 }, /* (480) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  441,    0 }, /* (481) join_type ::= */
  {  441,   -1 }, /* (482) join_type ::= INNER */
  {  443,  -12 }, /* (483) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  444,    0 }, /* (484) set_quantifier_opt ::= */
  {  444,   -1 }, /* (485) set_quantifier_opt ::= DISTINCT */
  {  444,   -1 }, /* (486) set_quantifier_opt ::= ALL */
  {  445,   -1 }, /* (487) select_list ::= select_item */
  {  445,   -3 }, /* (488) select_list ::= select_list NK_COMMA select_item */
  {  453,   -1 }, /* (489) select_item ::= NK_STAR */
  {  453,   -1 }, /* (490) select_item ::= common_expression */
  {  453,   -2 }, /* (491) select_item ::= common_expression column_alias */
  {  453,   -3 }, /* (492) select_item ::= common_expression AS column_alias */
  {  453,   -3 }, /* (493) select_item ::= table_name NK_DOT NK_STAR */
  {  408,    0 }, /* (494) where_clause_opt ::= */
  {  408,   -2 }, /* (495) where_clause_opt ::= WHERE search_condition */
  {  446,    0 }, /* (496) partition_by_clause_opt ::= */
  {  446,   -3 }, /* (497) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  454,   -1 }, /* (498) partition_list ::= partition_item */
  {  454,   -3 }, /* (499) partition_list ::= partition_list NK_COMMA partition_item */
  {  455,   -1 }, /* (500) partition_item ::= expr_or_subquery */
  {  455,   -2 }, /* (501) partition_item ::= expr_or_subquery column_alias */
  {  455,   -3 }, /* (502) partition_item ::= expr_or_subquery AS column_alias */
  {  450,    0 }, /* (503) twindow_clause_opt ::= */
  {  450,   -6 }, /* (504) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  450,   -4 }, /* (505) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  450,   -6 }, /* (506) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  450,   -8 }, /* (507) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  450,   -7 }, /* (508) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  390,    0 }, /* (509) sliding_opt ::= */
  {  390,   -4 }, /* (510) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  449,    0 }, /* (511) fill_opt ::= */
  {  449,   -4 }, /* (512) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  449,   -6 }, /* (513) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  449,   -6 }, /* (514) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
  {  456,   -1 }, /* (515) fill_mode ::= NONE */
  {  456,   -1 }, /* (516) fill_mode ::= PREV */
  {  456,   -1 }, /* (517) fill_mode ::= NULL */
  {  456,   -1 }, /* (518) fill_mode ::= NULL_F */
  {  456,   -1 }, /* (519) fill_mode ::= LINEAR */
  {  456,   -1 }, /* (520) fill_mode ::= NEXT */
  {  451,    0 }, /* (521) group_by_clause_opt ::= */
  {  451,   -3 }, /* (522) group_by_clause_opt ::= GROUP BY group_by_list */
  {  457,   -1 }, /* (523) group_by_list ::= expr_or_subquery */
  {  457,   -3 }, /* (524) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  452,    0 }, /* (525) having_clause_opt ::= */
  {  452,   -2 }, /* (526) having_clause_opt ::= HAVING search_condition */
  {  447,    0 }, /* (527) range_opt ::= */
  {  447,   -6 }, /* (528) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  448,    0 }, /* (529) every_opt ::= */
  {  448,   -4 }, /* (530) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  458,   -4 }, /* (531) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  459,   -1 }, /* (532) query_simple ::= query_specification */
  {  459,   -1 }, /* (533) query_simple ::= union_query_expression */
  {  463,   -4 }, /* (534) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  463,   -3 }, /* (535) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  464,   -1 }, /* (536) query_simple_or_subquery ::= query_simple */
  {  464,   -1 }, /* (537) query_simple_or_subquery ::= subquery */
  {  394,   -1 }, /* (538) query_or_subquery ::= query_expression */
  {  394,   -1 }, /* (539) query_or_subquery ::= subquery */
  {  460,    0 }, /* (540) order_by_clause_opt ::= */
  {  460,   -3 }, /* (541) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  461,    0 }, /* (542) slimit_clause_opt ::= */
  {  461,   -2 }, /* (543) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  461,   -4 }, /* (544) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  461,   -4 }, /* (545) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  462,    0 }, /* (546) limit_clause_opt ::= */
  {  462,   -2 }, /* (547) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  462,   -4 }, /* (548) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  462,   -4 }, /* (549) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  439,   -3 }, /* (550) subquery ::= NK_LP query_expression NK_RP */
  {  439,   -3 }, /* (551) subquery ::= NK_LP subquery NK_RP */
  {  442,   -1 }, /* (552) search_condition ::= common_expression */
  {  465,   -1 }, /* (553) sort_specification_list ::= sort_specification */
  {  465,   -3 }, /* (554) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  466,   -3 }, /* (555) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  467,    0 }, /* (556) ordering_specification_opt ::= */
  {  467,   -1 }, /* (557) ordering_specification_opt ::= ASC */
  {  467,   -1 }, /* (558) ordering_specification_opt ::= DESC */
  {  468,    0 }, /* (559) null_ordering_opt ::= */
  {  468,   -2 }, /* (560) null_ordering_opt ::= NULLS FIRST */
  {  468,   -2 }, /* (561) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,329,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,330,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,329,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,331,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,332,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,330,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,332,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,331,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy225, &yymsp[-1].minor.yy0, yymsp[0].minor.yy705); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy225, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy225, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy225, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy705 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy705 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy641, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy641, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy641 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy641 = yymsp[0].minor.yy641; }
  yymsp[0].minor.yy641 = yylhsminor.yy641;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy641 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy641 = yymsp[-2].minor.yy641 | yymsp[0].minor.yy641; }
  yymsp[-2].minor.yy641 = yylhsminor.yy641;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy641 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy641 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy225 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy225 = yylhsminor.yy225;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy225 = yymsp[-2].minor.yy225; }
  yymsp[-2].minor.yy225 = yylhsminor.yy225;
        break;
      case 42: /* priv_level ::= topic_name */
      case 273: /* sma_func_name ::= function_name */ yytestcase(yyruleno==273);
      case 476: /* alias_opt ::= table_alias */ yytestcase(yyruleno==476);
{ yylhsminor.yy225 = yymsp[0].minor.yy225; }
  yymsp[0].minor.yy225 = yylhsminor.yy225;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy225, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy103); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy225, yymsp[0].minor.yy103); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 274: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==274);
      case 275: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==275);
      case 276: /* sma_func_name ::= LAST */ yytestcase(yyruleno==276);
      case 277: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==277);
      case 361: /* db_name ::= NK_ID */ yytestcase(yyruleno==361);
      case 362: /* table_name ::= NK_ID */ yytestcase(yyruleno==362);
      case 363: /* column_name ::= NK_ID */ yytestcase(yyruleno==363);
      case 364: /* function_name ::= NK_ID */ yytestcase(yyruleno==364);
      case 365: /* table_alias ::= NK_ID */ yytestcase(yyruleno==365);
      case 366: /* column_alias ::= NK_ID */ yytestcase(yyruleno==366);
      case 367: /* user_name ::= NK_ID */ yytestcase(yyruleno==367);
      case 368: /* topic_name ::= NK_ID */ yytestcase(yyruleno==368);
      case 369: /* stream_name ::= NK_ID */ yytestcase(yyruleno==369);
      case 370: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==370);
      case 371: /* index_name ::= NK_ID */ yytestcase(yyruleno==371);
      case 411: /* noarg_func ::= NOW */ yytestcase(yyruleno==411);
      case 412: /* noarg_func ::= TODAY */ yytestcase(yyruleno==412);
      case 413: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==413);
      case 414: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==414);
      case 415: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==415);
      case 416: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==416);
      case 417: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==417);
      case 418: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==418);
      case 419: /* noarg_func ::= USER */ yytestcase(yyruleno==419);
      case 420: /* star_func ::= COUNT */ yytestcase(yyruleno==420);
      case 421: /* star_func ::= FIRST */ yytestcase(yyruleno==421);
      case 422: /* star_func ::= LAST */ yytestcase(yyruleno==422);
      case 423: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==423);
{ yylhsminor.yy225 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy225 = yylhsminor.yy225;
        break;
      case 54: /* force_opt ::= */
      case 74: /* not_exists_opt ::= */ yytestcase(yyruleno==74);
      case 76: /* exists_opt ::= */ yytestcase(yyruleno==76);
      case 294: /* analyze_opt ::= */ yytestcase(yyruleno==294);
      case 301: /* agg_func_opt ::= */ yytestcase(yyruleno==301);
      case 484: /* set_quantifier_opt ::= */ yytestcase(yyruleno==484);
{ yymsp[1].minor.yy103 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 295: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==295);
      case 302: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==302);
      case 485: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==485);
{ yymsp[0].minor.yy103 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy103, &yymsp[-1].minor.yy225, yymsp[0].minor.yy42); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy103, &yymsp[0].minor.yy225); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy225, yymsp[0].minor.yy42); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy225, yymsp[0].minor.yy508); }
        break;
      case 72: /* cmd ::= COMPACT DATABASE db_name */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 73: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy103 = true; }
        break;
      case 75: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy103 = true; }
        break;
      case 77: /* db_options ::= */
{ yymsp[1].minor.yy42 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 78: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 79: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 80: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 81: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 82: /* db_options ::= db_options DURATION NK_INTEGER */
      case 83: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==83);
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 84: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 85: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 86: /* db_options ::= db_options KEEP integer_list */
      case 87: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==87);
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_KEEP, yymsp[0].minor.yy110); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 88: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 89: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 90: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 91: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 92: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 93: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 94: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 95: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_RETENTIONS, yymsp[0].minor.yy110); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 96: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 97: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 98: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-3].minor.yy42, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-3].minor.yy42, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 103: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 104: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 105: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 106: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 107: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 108: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy42 = createAlterDatabaseOptions(pCxt); yylhsminor.yy42 = setAlterDatabaseOption(pCxt, yylhsminor.yy42, &yymsp[0].minor.yy459); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 109: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy42 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy42, &yymsp[0].minor.yy459); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 110: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy459.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= KEEP integer_list */
      case 115: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==115);
{ yymsp[-1].minor.yy459.type = DB_OPTION_KEEP; yymsp[-1].minor.yy459.pList = yymsp[0].minor.yy110; }
        break;
      case 116: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_PAGES; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_WAL; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy110 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 121: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 330: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==330);
{ yylhsminor.yy110 = addNodeToList(pCxt, yymsp[-2].minor.yy110, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy110 = yylhsminor.yy110;
        break;
      case 122: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy110 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 123: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy110 = addNodeToList(pCxt, yymsp[-2].minor.yy110, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy110 = yylhsminor.yy110;
        break;
      case 124: /* retention_list ::= retention */
      case 146: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==146);
      case 149: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==149);
      case 156: /* column_def_list ::= column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name */ yytestcase(yyruleno==205);
      case 256: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==256);
      case 270: /* func_list ::= func */ yytestcase(yyruleno==270);
      case 359: /* literal_list ::= signed_literal */ yytestcase(yyruleno==359);
      case 426: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==426);
      case 432: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==432);
      case 487: /* select_list ::= select_item */ yytestcase(yyruleno==487);
      case 498: /* partition_list ::= partition_item */ yytestcase(yyruleno==498);
      case 553: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==553);
{ yylhsminor.yy110 = createNodeList(pCxt, yymsp[0].minor.yy42); }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 125: /* retention_list ::= retention_list NK_COMMA retention */
      case 157: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==157);
      case 201: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==201);
      case 206: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==206);
      case 257: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==257);
      case 271: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==271);
      case 360: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==360);
      case 427: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==427);
      case 488: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==488);
      case 499: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==499);
      case 554: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==554);
{ yylhsminor.yy110 = addNodeToList(pCxt, yymsp[-2].minor.yy110, yymsp[0].minor.yy42); }
  yymsp[-2].minor.yy110 = yylhsminor.yy110;
        break;
      case 126: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy42 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 127: /* speed_opt ::= */
      case 303: /* bufsize_opt ::= */ yytestcase(yyruleno==303);
{ yymsp[1].minor.yy508 = 0; }
        break;
      case 128: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 304: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==304);
{ yymsp[-1].minor.yy508 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 129: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 131: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==131);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy103, yymsp[-5].minor.yy42, yymsp[-3].minor.yy110, yymsp[-1].minor.yy110, yymsp[0].minor.yy42); }
        break;
      case 130: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy110); }
        break;
      case 132: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy110); }
        break;
      case 133: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy103, yymsp[0].minor.yy42); }
        break;
      case 134: /* cmd ::= ALTER TABLE alter_table_clause */
      case 332: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==332);
      case 333: /* cmd ::= insert_query */ yytestcase(yyruleno==333);
{ pCxt->pRootNode = yymsp[0].minor.yy42; }
        break;
      case 135: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy42); }
        break;
      case 136: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy42 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 137: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy42 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 138: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy42 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy42, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy225); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 139: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy42 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 140: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy42 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 141: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy42 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 142: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy42 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy42, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy225); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 143: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy42 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 144: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy42 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 145: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy42 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy42, &yymsp[-2].minor.yy225, yymsp[0].minor.yy42); }
  yymsp[-5].minor.yy42 = yylhsminor.yy42;
        break;
      case 147: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 150: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==150);
      case 433: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==433);
{ yylhsminor.yy110 = addNodeToList(pCxt, yymsp[-1].minor.yy110, yymsp[0].minor.yy42); }
  yymsp[-1].minor.yy110 = yylhsminor.yy110;
        break;
      case 148: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy42 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy103, yymsp[-8].minor.yy42, yymsp[-6].minor.yy42, yymsp[-5].minor.yy110, yymsp[-2].minor.yy110, yymsp[0].minor.yy42); }
  yymsp[-9].minor.yy42 = yylhsminor.yy42;
        break;
      case 151: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy42 = createDropTableClause(pCxt, yymsp[-1].minor.yy103, yymsp[0].minor.yy42); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 152: /* specific_cols_opt ::= */
      case 183: /* tags_def_opt ::= */ yytestcase(yyruleno==183);
      case 255: /* tag_list_opt ::= */ yytestcase(yyruleno==255);
      case 307: /* col_list_opt ::= */ yytestcase(yyruleno==307);
      case 309: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==309);
      case 496: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==496);
      case 521: /* group_by_clause_opt ::= */ yytestcase(yyruleno==521);
      case 540: /* order_by_clause_opt ::= */ yytestcase(yyruleno==540);
{ yymsp[1].minor.yy110 = NULL; }
        break;
      case 153: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 308: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==308);
{ yymsp[-2].minor.yy110 = yymsp[-1].minor.yy110; }
        break;
      case 154: /* full_table_name ::= table_name */
{ yylhsminor.yy42 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy225, NULL); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 155: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy42 = createRealTableNode(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225, NULL); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 158: /* column_def ::= column_name type_name */
{ yylhsminor.yy42 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448, NULL); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 159: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy42 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy225, yymsp[-2].minor.yy448, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 160: /* type_name ::= BOOL */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 161: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 162: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 163: /* type_name ::= INT */
      case 164: /* type_name ::= INTEGER */ yytestcase(yyruleno==164);
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 165: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 166: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 167: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 168: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 169: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 170: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 171: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 172: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 173: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 174: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 175: /* type_name ::= JSON */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 176: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 177: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 178: /* type_name ::= BLOB */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 179: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 180: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 182: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 184: /* tags_def_opt ::= tags_def */
      case 310: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==310);
      case 425: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==425);
{ yylhsminor.yy110 = yymsp[0].minor.yy110; }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 185: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 311: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==311);
{ yymsp[-3].minor.yy110 = yymsp[-1].minor.yy110; }
        break;
      case 186: /* table_options ::= */
{ yymsp[1].minor.yy42 = createDefaultTableOptions(pCxt); }
        break;
      case 187: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-2].minor.yy42, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 188: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-2].minor.yy42, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy110); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 189: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-2].minor.yy42, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy110); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 190: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-4].minor.yy42, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy110); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 191: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-2].minor.yy42, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 192: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-4].minor.yy42, TABLE_OPTION_SMA, yymsp[-1].minor.yy110); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 193: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-2].minor.yy42, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy110); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 194: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy42 = createAlterTableOptions(pCxt); yylhsminor.yy42 = setTableOption(pCxt, yylhsminor.yy42, yymsp[0].minor.yy459.type, &yymsp[0].minor.yy459.val); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 195: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-1].minor.yy42, yymsp[0].minor.yy459.type, &yymsp[0].minor.yy459.val); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 196: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy459.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy459.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 198: /* duration_list ::= duration_literal */
      case 389: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==389);
{ yylhsminor.yy110 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy42)); }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 199: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 390: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==390);
{ yylhsminor.yy110 = addNodeToList(pCxt, yymsp[-2].minor.yy110, releaseRawExprNode(pCxt, yymsp[0].minor.yy42)); }
  yymsp[-2].minor.yy110 = yylhsminor.yy110;
        break;
      case 202: /* rollup_func_name ::= function_name */
{ yylhsminor.yy42 = createFunctionNode(pCxt, &yymsp[0].minor.yy225, NULL); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 203: /* rollup_func_name ::= FIRST */
      case 204: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==204);
      case 259: /* tag_item ::= QTAGS */ yytestcase(yyruleno==259);
{ yylhsminor.yy42 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 207: /* col_name ::= column_name */
      case 260: /* tag_item ::= column_name */ yytestcase(yyruleno==260);
{ yylhsminor.yy42 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy225); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 208: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 209: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 210: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 211: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy42, yymsp[0].minor.yy42, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy42, yymsp[0].minor.yy42, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy42, NULL, OP_TYPE_LIKE); }
        break;
      case 215: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 217: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 218: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy42, yymsp[-1].minor.yy42, OP_TYPE_EQUAL); }
        break;
      case 219: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 220: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 221: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 222: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 223: /* cmd ::= SHOW LICENCES */
      case 224: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==224);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 225: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 226: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy42); }
        break;
      case 227: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy42); }
        break;
      case 228: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 229: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 230: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 231: /* cmd ::= SHOW VARIABLES */
      case 232: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==232);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 234: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy42); }
        break;
      case 235: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 237: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 238: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 239: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy42); }
        break;
      case 240: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 241: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 242: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy42, yymsp[-1].minor.yy42, OP_TYPE_EQUAL); }
        break;
      case 243: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy42, yymsp[0].minor.yy42, yymsp[-3].minor.yy110); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 245: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 246: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy42,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 247: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 248: /* db_name_cond_opt ::= */
      case 253: /* from_db_opt ::= */ yytestcase(yyruleno==253);
{ yymsp[1].minor.yy42 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 249: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy42 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy225); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 250: /* like_pattern_opt ::= */
      case 320: /* subtable_opt ::= */ yytestcase(yyruleno==320);
      case 435: /* case_when_else_opt ::= */ yytestcase(yyruleno==435);
      case 465: /* from_clause_opt ::= */ yytestcase(yyruleno==465);
      case 494: /* where_clause_opt ::= */ yytestcase(yyruleno==494);
      case 503: /* twindow_clause_opt ::= */ yytestcase(yyruleno==503);
      case 509: /* sliding_opt ::= */ yytestcase(yyruleno==509);
      case 511: /* fill_opt ::= */ yytestcase(yyruleno==511);
      case 525: /* having_clause_opt ::= */ yytestcase(yyruleno==525);
      case 527: /* range_opt ::= */ yytestcase(yyruleno==527);
      case 529: /* every_opt ::= */ yytestcase(yyruleno==529);
      case 542: /* slimit_clause_opt ::= */ yytestcase(yyruleno==542);
      case 546: /* limit_clause_opt ::= */ yytestcase(yyruleno==546);
{ yymsp[1].minor.yy42 = NULL; }
        break;
      case 251: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 252: /* table_name_cond ::= table_name */
{ yylhsminor.yy42 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy225); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 254: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy42 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 258: /* tag_item ::= TBNAME */
{ yylhsminor.yy42 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 261: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy42 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy225), &yymsp[0].minor.yy225); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 262: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy42 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy225), &yymsp[0].minor.yy225); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 263: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy103, yymsp[-3].minor.yy42, yymsp[-1].minor.yy42, NULL, yymsp[0].minor.yy42); }
        break;
      case 264: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy103, yymsp[-5].minor.yy42, yymsp[-3].minor.yy42, yymsp[-1].minor.yy110, NULL); }
        break;
      case 265: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy103, yymsp[0].minor.yy42); }
        break;
      case 266: /* full_index_name ::= index_name */
{ yylhsminor.yy42 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy225); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 267: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy42 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 268: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy42 = createIndexOption(pCxt, yymsp[-7].minor.yy110, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), NULL, yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 269: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy42 = createIndexOption(pCxt, yymsp[-9].minor.yy110, releaseRawExprNode(pCxt, yymsp[-5].minor.yy42), releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 272: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy42 = createFunctionNode(pCxt, &yymsp[-3].minor.yy225, yymsp[-1].minor.yy110); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 278: /* sma_stream_opt ::= */
      case 312: /* stream_options ::= */ yytestcase(yyruleno==312);
{ yymsp[1].minor.yy42 = createStreamOptions(pCxt); }
        break;
      case 279: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 316: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==316);
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 280: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 281: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 282: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy103, &yymsp[-2].minor.yy225, yymsp[0].minor.yy42); }
        break;
      case 283: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy103, &yymsp[-3].minor.yy225, &yymsp[0].minor.yy225, false); }
        break;
      case 284: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy103, &yymsp[-5].minor.yy225, &yymsp[0].minor.yy225, true); }
        break;
      case 285: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy103, &yymsp[-3].minor.yy225, yymsp[0].minor.yy42, false); }
        break;
      case 286: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy103, &yymsp[-5].minor.yy225, yymsp[0].minor.yy42, true); }
        break;
      case 287: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy103, &yymsp[0].minor.yy225); }
        break;
      case 288: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy103, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225); }
        break;
      case 289: /* cmd ::= DESC full_table_name */
      case 290: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==290);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy42); }
        break;
      case 291: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 292: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 293: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==293);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy103, yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 296: /* explain_options ::= */
{ yymsp[1].minor.yy42 = createDefaultExplainOptions(pCxt); }
        break;
      case 297: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy42 = setExplainVerbose(pCxt, yymsp[-2].minor.yy42, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 298: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy42 = setExplainRatio(pCxt, yymsp[-2].minor.yy42, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 299: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy103, yymsp[-8].minor.yy103, &yymsp[-5].minor.yy225, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy448, yymsp[0].minor.yy508); }
        break;
      case 300: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy103, &yymsp[0].minor.yy225); }
        break;
      case 305: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy103, &yymsp[-8].minor.yy225, yymsp[-5].minor.yy42, yymsp[-7].minor.yy42, yymsp[-3].minor.yy110, yymsp[-2].minor.yy42, yymsp[0].minor.yy42, yymsp[-4].minor.yy110); }
        break;
      case 306: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy103, &yymsp[0].minor.yy225); }
        break;
      case 313: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 314: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 315: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy42)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy42)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); yylhsminor.yy42 = yymsp[-3].minor.yy42; }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 317: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy42)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy42 = yymsp[-3].minor.yy42; }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 318: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 319: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy42)->ignoreUpdate = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy42 = yymsp[-3].minor.yy42; }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 321: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 510: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==510);
      case 530: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==530);
{ yymsp[-3].minor.yy42 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy42); }
        break;
      case 322: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 323: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 324: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 325: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 326: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 327: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy110); }
        break;
      case 328: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 329: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy110 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 331: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 334: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy42 = createInsertStmt(pCxt, yymsp[-4].minor.yy42, yymsp[-2].minor.yy110, yymsp[0].minor.yy42); }
        break;
      case 335: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy42 = createInsertStmt(pCxt, yymsp[-1].minor.yy42, NULL, yymsp[0].minor.yy42); }
        break;
      case 336: /* literal ::= NK_INTEGER */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 337: /* literal ::= NK_FLOAT */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 338: /* literal ::= NK_STRING */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 339: /* literal ::= NK_BOOL */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 340: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 341: /* literal ::= duration_literal */
      case 351: /* signed_literal ::= signed */ yytestcase(yyruleno==351);
      case 372: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==372);
      case 373: /* expression ::= literal */ yytestcase(yyruleno==373);
      case 374: /* expression ::= pseudo_column */ yytestcase(yyruleno==374);
      case 375: /* expression ::= column_reference */ yytestcase(yyruleno==375);
      case 376: /* expression ::= function_expression */ yytestcase(yyruleno==376);
      case 377: /* expression ::= case_when_expression */ yytestcase(yyruleno==377);
      case 408: /* function_expression ::= literal_func */ yytestcase(yyruleno==408);
      case 457: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==457);
      case 461: /* boolean_primary ::= predicate */ yytestcase(yyruleno==461);
      case 463: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==463);
      case 464: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==464);
      case 467: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==467);
      case 469: /* table_reference ::= table_primary */ yytestcase(yyruleno==469);
      case 470: /* table_reference ::= joined_table */ yytestcase(yyruleno==470);
      case 474: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==474);
      case 532: /* query_simple ::= query_specification */ yytestcase(yyruleno==532);
      case 533: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==533);
      case 536: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==536);
      case 538: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==538);
{ yylhsminor.yy42 = yymsp[0].minor.yy42; }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 342: /* literal ::= NULL */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 343: /* literal ::= NK_QUESTION */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 344: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 345: /* signed ::= NK_INTEGER */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 346: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 347: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 348: /* signed ::= NK_FLOAT */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 349: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 350: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 352: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 353: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 354: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 355: /* signed_literal ::= duration_literal */
      case 357: /* signed_literal ::= literal_func */ yytestcase(yyruleno==357);
      case 428: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==428);
      case 490: /* select_item ::= common_expression */ yytestcase(yyruleno==490);
      case 500: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==500);
      case 537: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==537);
      case 539: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==539);
      case 552: /* search_condition ::= common_expression */ yytestcase(yyruleno==552);
{ yylhsminor.yy42 = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 356: /* signed_literal ::= NULL */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 358: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy42 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 378: /* expression ::= NK_LP expression NK_RP */
      case 462: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==462);
      case 551: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==551);
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy42)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 379: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy42));
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 380: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy42), NULL));
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 381: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 382: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 383: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 384: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 385: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 386: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 387: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 388: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 391: /* column_reference ::= column_name */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy225, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy225)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 392: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225, createColumnNode(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 393: /* pseudo_column ::= ROWTS */
      case 394: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==394);
      case 396: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==396);
      case 397: /* pseudo_column ::= QEND */ yytestcase(yyruleno==397);
      case 398: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==398);
      case 399: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==399);
      case 400: /* pseudo_column ::= WEND */ yytestcase(yyruleno==400);
      case 401: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==401);
      case 402: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==402);
      case 403: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==403);
      case 404: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==404);
      case 410: /* literal_func ::= NOW */ yytestcase(yyruleno==410);
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 395: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy225)))); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 405: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 406: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==406);
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy225, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy225, yymsp[-1].minor.yy110)); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 407: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), yymsp[-1].minor.yy448)); }
  yymsp[-5].minor.yy42 = yylhsminor.yy42;
        break;
      case 409: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy225, NULL)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 424: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy110 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 429: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 493: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==493);
{ yylhsminor.yy42 = createColumnNode(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 430: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy110, yymsp[-1].minor.yy42)); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 431: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), yymsp[-2].minor.yy110, yymsp[-1].minor.yy42)); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 434: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy42 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)); }
        break;
      case 436: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy42 = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); }
        break;
      case 437: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 442: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==442);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy2, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 438: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy42), releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 439: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy42), releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-5].minor.yy42 = yylhsminor.yy42;
        break;
      case 440: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), NULL));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 441: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), NULL));
                                                                                  }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 443: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy2 = OP_TYPE_LOWER_THAN; }
        break;
      case 444: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy2 = OP_TYPE_GREATER_THAN; }
        break;
      case 445: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy2 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 446: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy2 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 447: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy2 = OP_TYPE_NOT_EQUAL; }
        break;
      case 448: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy2 = OP_TYPE_EQUAL; }
        break;
      case 449: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy2 = OP_TYPE_LIKE; }
        break;
      case 450: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy2 = OP_TYPE_NOT_LIKE; }
        break;
      case 451: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy2 = OP_TYPE_MATCH; }
        break;
      case 452: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy2 = OP_TYPE_NMATCH; }
        break;
      case 453: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy2 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 454: /* in_op ::= IN */
{ yymsp[0].minor.yy2 = OP_TYPE_IN; }
        break;
      case 455: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy2 = OP_TYPE_NOT_IN; }
        break;
      case 456: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy110)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 458: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy42), NULL));
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 459: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 460: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 466: /* from_clause_opt ::= FROM table_reference_list */
      case 495: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==495);
      case 526: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==526);
{ yymsp[-1].minor.yy42 = yymsp[0].minor.yy42; }
        break;
      case 468: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy42 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy42, yymsp[0].minor.yy42, NULL); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 471: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy42 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 472: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy42 = createRealTableNode(pCxt, &yymsp[-3].minor.yy225, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 473: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy42 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy42), &yymsp[0].minor.yy225); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 475: /* alias_opt ::= */
{ yymsp[1].minor.yy225 = nil_token;  }
        break;
      case 477: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy225 = yymsp[0].minor.yy225; }
        break;
      case 478: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 479: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==479);
{ yymsp[-2].minor.yy42 = yymsp[-1].minor.yy42; }
        break;
      case 480: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy42 = createJoinTableNode(pCxt, yymsp[-4].minor.yy638, yymsp[-5].minor.yy42, yymsp[-2].minor.yy42, yymsp[0].minor.yy42); }
  yymsp[-5].minor.yy42 = yylhsminor.yy42;
        break;
      case 481: /* join_type ::= */
{ yymsp[1].minor.yy638 = JOIN_TYPE_INNER; }
        break;
      case 482: /* join_type ::= INNER */
{ yymsp[0].minor.yy638 = JOIN_TYPE_INNER; }
        break;
      case 483: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy42 = createSelectStmt(pCxt, yymsp[-10].minor.yy103, yymsp[-9].minor.yy110, yymsp[-8].minor.yy42);
                                                                                    yymsp[-11].minor.yy42 = addWhereClause(pCxt, yymsp[-11].minor.yy42, yymsp[-7].minor.yy42);
                                                                                    yymsp[-11].minor.yy42 = addPartitionByClause(pCxt, yymsp[-11].minor.yy42, yymsp[-6].minor.yy110);
                                                                                    yymsp[-11].minor.yy42 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy42, yymsp[-2].minor.yy42);
                                                                                    yymsp[-11].minor.yy42 = addGroupByClause(pCxt, yymsp[-11].minor.yy42, yymsp[-1].minor.yy110);
                                                                                    yymsp[-11].minor.yy42 = addHavingClause(pCxt, yymsp[-11].minor.yy42, yymsp[0].minor.yy42);
                                                                                    yymsp[-11].minor.yy42 = addRangeClause(pCxt, yymsp[-11].minor.yy42, yymsp[-5].minor.yy42);
                                                                                    yymsp[-11].minor.yy42 = addEveryClause(pCxt, yymsp[-11].minor.yy42, yymsp[-4].minor.yy42);
                                                                                    yymsp[-11].minor.yy42 = addFillClause(pCxt, yymsp[-11].minor.yy42, yymsp[-3].minor.yy42);
                                                                                  }
        break;
      case 486: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy103 = false; }
        break;
      case 489: /* select_item ::= NK_STAR */
{ yylhsminor.yy42 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 491: /* select_item ::= common_expression column_alias */
      case 501: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==501);
{ yylhsminor.yy42 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy42), &yymsp[0].minor.yy225); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 492: /* select_item ::= common_expression AS column_alias */
      case 502: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==502);
{ yylhsminor.yy42 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), &yymsp[0].minor.yy225); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 497: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 522: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==522);
      case 541: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==541);
{ yymsp[-2].minor.yy110 = yymsp[0].minor.yy110; }
        break;
      case 504: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy42 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), releaseRawExprNode(pCxt, yymsp[-1].minor.yy42)); }
        break;
      case 505: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy42 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy42)); }
        break;
      case 506: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy42 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), NULL, yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 507: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy42 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy42), releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 508: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy42 = createEventWindowNode(pCxt, yymsp[-3].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 512: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy42 = createFillNode(pCxt, yymsp[-1].minor.yy410, NULL); }
        break;
      case 513: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy42 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy110)); }
        break;
      case 514: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy42 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy110)); }
        break;
      case 515: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy410 = FILL_MODE_NONE; }
        break;
      case 516: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy410 = FILL_MODE_PREV; }
        break;
      case 517: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy410 = FILL_MODE_NULL; }
        break;
      case 518: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy410 = FILL_MODE_NULL_F; }
        break;
      case 519: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy410 = FILL_MODE_LINEAR; }
        break;
      case 520: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy410 = FILL_MODE_NEXT; }
        break;
      case 523: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy110 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 524: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy110 = addNodeToList(pCxt, yymsp[-2].minor.yy110, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); }
  yymsp[-2].minor.yy110 = yylhsminor.yy110;
        break;
      case 528: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy42 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), releaseRawExprNode(pCxt, yymsp[-1].minor.yy42)); }
        break;
      case 531: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy42 = addOrderByClause(pCxt, yymsp[-3].minor.yy42, yymsp[-2].minor.yy110);
                                                                                    yylhsminor.yy42 = addSlimitClause(pCxt, yylhsminor.yy42, yymsp[-1].minor.yy42);
                                                                                    yylhsminor.yy42 = addLimitClause(pCxt, yylhsminor.yy42, yymsp[0].minor.yy42);
                                                                                  }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 534: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy42 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy42, yymsp[0].minor.yy42); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 535: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy42 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy42, yymsp[0].minor.yy42); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 543: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 547: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==547);
{ yymsp[-1].minor.yy42 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 544: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 548: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==548);
{ yymsp[-3].minor.yy42 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 545: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 549: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==549);
{ yymsp[-3].minor.yy42 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 550: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy42); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 555: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy42 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), yymsp[-1].minor.yy106, yymsp[0].minor.yy599); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 556: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy106 = ORDER_ASC; }
        break;
      case 557: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy106 = ORDER_ASC; }
        break;
      case 558: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy106 = ORDER_DESC; }
        break;
      case 559: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy599 = NULL_ORDER_DEFAULT; }
        break;
      case 560: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy599 = NULL_ORDER_FIRST; }
        break;
      case 561: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy599 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
