###################################################################
#           Copyright (c) 2021 by TAOS Technologies, Inc.
#                     All rights reserved.
#
#  This file is proprietary and confidential to TAOS Technologies.
#  No part of this file may be reproduced, stored, transmitted,
#  disclosed or used in any form or by any means other than as
#  expressly provided by the written permission from Jianhui Tao
#
###################################################################

# -*- coding: utf-8 -*-

import sys
from util.log import *
from util.cases import *
from util.sql import *


class TDTestCase:
    def caseDescription(self):
        '''
        case1<Ganlin Zhao>: [TD-11220]<feature>: time related functions
        '''
        return

    def init(self, conn, logSql):
        tdLog.debug("start to execute %s" % __file__)
        tdSql.init(conn.cursor(), logSql)

    def getBuildPath(self):
        selfPath = os.path.dirname(os.path.realpath(__file__))

        if ("community" in selfPath):
            projPath = selfPath[:selfPath.find("community")]
        else:
            projPath = selfPath[:selfPath.find("tests")]

        for root, dirs, files in os.walk(projPath):
            if ("taosd" in files):
                rootRealPath = os.path.dirname(os.path.realpath(root))
                if ("packaging" not in rootRealPath):
                    buildPath = root[:len(root) - len("/build/bin")]
                    break
        return buildPath

    def getISOTimeFmt(self, epoch, precision = None, delta = datetime.timedelta(hours = 8)):
        if precision == "m":
            time = datetime.datetime.fromtimestamp(epoch / 1000, tz = datetime.timezone(delta))
            time_str = time.strftime("%Y-%m-%dT%H:%M:%S.%f%z")
            tz = time_str[-5:]
            return time_str[:-8] + tz
        elif precision == "u":
            time = datetime.datetime.fromtimestamp(epoch / 1000000, tz = datetime.timezone(delta))
            return time.strftime("%Y-%m-%dT%H:%M:%S.%f%z")
        elif precision == "n":
            time = datetime.datetime.fromtimestamp(epoch / 1000000000, tz = datetime.timezone(delta))
            time_str = time.strftime("%Y-%m-%dT%H:%M:%S.%f%z")
            tz = time_str[-5:]
            nanoDigits = str(epoch)[-3:]
            return time_str[:-5] + nanoDigits + tz

        else:
            time = datetime.datetime.fromtimestamp(epoch, tz = datetime.timezone(delta))
            return time.strftime("%Y-%m-%dT%H:%M:%S%z")

    def checkTimestampEqual(self, elm, expect_elm):
        caller = inspect.getframeinfo(inspect.stack()[1][0])
        if len(elm) == len(expect_elm):
            delta = abs(int(elm[-1]) - int(expect_elm[-1]))
            if delta == 1: #ignore 1 second diff
                new_elm = expect_elm[0:-1] + elm[-1]
            else:
                new_elm = expect_elm;
            if elm == new_elm:
                tdLog.info("sql:%s, elm:%s == expect_elm:%s" % (tdSql.sql, elm, new_elm))
            else:
                args = (caller.filename, caller.lineno, tdSql.sql, elm, new_elm)
                tdLog.exit("%s(%d) failed: sql:%s, elm:%s != expect_elm:%s" % args)
        else:
            args = (caller.filename, caller.lineno, tdSql.sql, elm, expect_elm)
            tdLog.exit("%s(%d) failed: sql:%s, elm:%s != expect_elm:%s" % args)


    def run(self):
        print("running {}".format(__file__))

        #Prepare data
        #db precision "ms"
        tdSql.execute("drop database if exists db_m")
        tdSql.execute("create database if not exists db_m")
        tdSql.execute('use db_m')

        tdSql.execute("create stable stb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb using stb tags ('2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00', '1970-01-01 08:01:01', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', '1970-01-01 08:01:01', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #db precision "us"
        tdSql.execute("drop database if exists db_u")
        tdSql.execute("create database if not exists db_u precision 'us'")
        tdSql.execute('use db_u')

        tdSql.execute("create stable stb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb using stb tags ('2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00', '1970-01-01 08:01:01', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', '1970-01-01 08:01:01', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #db precision "ns"
        tdSql.execute("drop database if exists db_n")
        tdSql.execute("create database if not exists db_n precision 'ns'")
        tdSql.execute('use db_n')

        tdSql.execute("create stable stb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb using stb tags ('2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00', '1970-01-01 08:01:01', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', '1970-01-01 08:01:01', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #execute query
        print("============== STEP 1: select timetruncate() with milliesecond db precision ================== ")

        tdSql.execute('use db_m')
        #epoch as input
        ts = 61
        tdSql.query("select timetruncate(%d, 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate(%d, 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate(%d, 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")

        tdSql.query("select timetruncate(%d, 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate(%d, 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate(%d, 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")

        tdSql.query("select timetruncate(%d, 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate(%d, 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate(%d, 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")

        tdSql.query("select timetruncate(%d, 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:00")
        tdSql.query("select timetruncate(%d, 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:00")
        tdSql.query("select timetruncate(%d, 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:00")

        tdSql.query("select timetruncate(%d, 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate(%d, 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate(%d, 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")

        tdSql.query("select timetruncate(%d, 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")

        tdSql.query("select timetruncate(%d, 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")

        ts = 92986230
        tdSql.query("select timetruncate(%d, 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate(%d, 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate(%d, 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")

        tdSql.query("select timetruncate(%d, 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate(%d, 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate(%d, 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")

        tdSql.query("select timetruncate(%d, 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate(%d, 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate(%d, 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")

        tdSql.query("select timetruncate(%d, 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:00")
        tdSql.query("select timetruncate(%d, 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:00")
        tdSql.query("select timetruncate(%d, 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:00")

        tdSql.query("select timetruncate(%d, 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:00:00")
        tdSql.query("select timetruncate(%d, 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:00:00")
        tdSql.query("select timetruncate(%d, 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:00:00")

        tdSql.query("select timetruncate(%d, 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 08:00:00")

        tdSql.query("select timetruncate(%d, 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-07 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-07 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-07 08:00:00")

        ts = 1643779830123
        tdSql.query("select timetruncate(%d, 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate(%d, 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate(%d, 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate(%d, 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate(%d, 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")

        tdSql.query("select timetruncate(%d, 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate(%d, 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate(%d, 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")

        tdSql.query("select timetruncate(%d, 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate(%d, 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate(%d, 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")

        tdSql.query("select timetruncate(%d, 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")

        tdSql.query("select timetruncate(%d, 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")

        ts = 1643779830123456
        tdSql.query("select timetruncate(%d, 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate(%d, 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate(%d, 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate(%d, 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate(%d, 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")

        tdSql.query("select timetruncate(%d, 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate(%d, 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate(%d, 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")

        tdSql.query("select timetruncate(%d, 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate(%d, 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate(%d, 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")

        tdSql.query("select timetruncate(%d, 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")

        tdSql.query("select timetruncate(%d, 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")

        ts = 1643779830123456789
        tdSql.query("select timetruncate(%d, 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate(%d, 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate(%d, 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate(%d, 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate(%d, 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")

        tdSql.query("select timetruncate(%d, 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate(%d, 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate(%d, 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")

        tdSql.query("select timetruncate(%d, 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate(%d, 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate(%d, 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")

        tdSql.query("select timetruncate(%d, 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")

        tdSql.query("select timetruncate(%d, 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")

        #datetime string as input
        ts = "1970-01-01 08:01:01" # 61
        tdSql.query("select timetruncate('%s', 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate('%s', 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate('%s', 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")

        tdSql.query("select timetruncate('%s', 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate('%s', 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate('%s', 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")

        tdSql.query("select timetruncate('%s', 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate('%s', 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate('%s', 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")

        tdSql.query("select timetruncate('%s', 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:00")
        tdSql.query("select timetruncate('%s', 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:00")
        tdSql.query("select timetruncate('%s', 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:00")

        tdSql.query("select timetruncate('%s', 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate('%s', 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate('%s', 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")

        tdSql.query("select timetruncate('%s', 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")

        tdSql.query("select timetruncate('%s', 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")

        ts = "1972-12-12 13:30:30" # 92986230
        tdSql.query("select timetruncate('%s', 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate('%s', 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate('%s', 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")

        tdSql.query("select timetruncate('%s', 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate('%s', 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate('%s', 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")

        tdSql.query("select timetruncate('%s', 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate('%s', 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate('%s', 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")

        tdSql.query("select timetruncate('%s', 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:00")
        tdSql.query("select timetruncate('%s', 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:00")
        tdSql.query("select timetruncate('%s', 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:00")

        tdSql.query("select timetruncate('%s', 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:00:00")
        tdSql.query("select timetruncate('%s', 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:00:00")
        tdSql.query("select timetruncate('%s', 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:00:00")

        tdSql.query("select timetruncate('%s', 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 08:00:00")

        tdSql.query("select timetruncate('%s', 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-07 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-07 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-07 08:00:00")

        ts = "2001-09-09 09:46:39" # 999999999
        tdSql.query("select timetruncate('%s', 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        tdSql.query("select timetruncate('%s', 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        tdSql.query("select timetruncate('%s', 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")

        tdSql.query("select timetruncate('%s', 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        tdSql.query("select timetruncate('%s', 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        tdSql.query("select timetruncate('%s', 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")

        tdSql.query("select timetruncate('%s', 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        tdSql.query("select timetruncate('%s', 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        tdSql.query("select timetruncate('%s', 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")

        tdSql.query("select timetruncate('%s', 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:00")
        tdSql.query("select timetruncate('%s', 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:00")
        tdSql.query("select timetruncate('%s', 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:00")

        tdSql.query("select timetruncate('%s', 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:00:00")
        tdSql.query("select timetruncate('%s', 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:00:00")
        tdSql.query("select timetruncate('%s', 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:00:00")

        tdSql.query("select timetruncate('%s', 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 08:00:00")

        tdSql.query("select timetruncate('%s', 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-06 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-06 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-06 08:00:00")

        ts = "2022-02-02 13:30:30.123" # 1643779830123
        tdSql.query("select timetruncate('%s', 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate('%s', 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate('%s', 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate('%s', 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate('%s', 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")

        tdSql.query("select timetruncate('%s', 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate('%s', 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate('%s', 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")

        tdSql.query("select timetruncate('%s', 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate('%s', 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate('%s', 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")

        tdSql.query("select timetruncate('%s', 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")

        tdSql.query("select timetruncate('%s', 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")

        ts = "2022-02-02 13:30:30.123456" # 1643779830123456
        tdSql.query("select timetruncate('%s', 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate('%s', 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate('%s', 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate('%s', 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate('%s', 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")

        tdSql.query("select timetruncate('%s', 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate('%s', 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate('%s', 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")

        tdSql.query("select timetruncate('%s', 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate('%s', 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate('%s', 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")

        tdSql.query("select timetruncate('%s', 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")

        tdSql.query("select timetruncate('%s', 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")

        ts = "2022-02-02 13:30:30.123456789" # 1643779830123456789
        tdSql.query("select timetruncate('%s', 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate('%s', 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate('%s', 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate('%s', 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate('%s', 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")

        tdSql.query("select timetruncate('%s', 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate('%s', 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate('%s', 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")

        tdSql.query("select timetruncate('%s', 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate('%s', 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate('%s', 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")

        tdSql.query("select timetruncate('%s', 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")

        tdSql.query("select timetruncate('%s', 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")

        #timestamp column as input
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:01', '1972-12-12 13:30:30', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:02', '2001-09-09 09:46:39', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:03', '2022-02-02 13:30:30.123', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:04', '2022-02-02 13:30:30.123456', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:05', '2022-02-02 13:30:30.123456789', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:01', '1972-12-12 13:30:30', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:02', '2001-09-09 09:46:39', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:03', '2022-02-02 13:30:30.123', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:04', '2022-02-02 13:30:30.123456', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:05', '2022-02-02 13:30:30.123456789', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #primary ts column
        tdSql.query("select timetruncate(ts, 1u) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select timetruncate(ts, 1u) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select timetruncate(ts, 1u) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")

        tdSql.query("select timetruncate(ts, 1a) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select timetruncate(ts, 1a) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select timetruncate(ts, 1a) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")

        tdSql.query("select timetruncate(ts, 1s) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select timetruncate(ts, 1s) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select timetruncate(ts, 1s) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")

        tdSql.query("select timetruncate(ts, 1m) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select timetruncate(ts, 1m) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select timetruncate(ts, 1m) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")

        tdSql.query("select timetruncate(ts, 1h) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select timetruncate(ts, 1h) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select timetruncate(ts, 1h) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")

        tdSql.query("select timetruncate(ts, 1d) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        tdSql.query("select timetruncate(ts, 1d) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        tdSql.query("select timetruncate(ts, 1d) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")

        tdSql.query("select timetruncate(ts, 1w) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(ts, 1w) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(ts, 1w) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")

        #normal ts column
        tdSql.query("select timetruncate(col_timestamp, 1u) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(col_timestamp, 1u) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(col_timestamp, 1u) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate(col_timestamp, 1a) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(col_timestamp, 1a) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(col_timestamp, 1a) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate(col_timestamp, 1s) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate(col_timestamp, 1s) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate(col_timestamp, 1s) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")

        tdSql.query("select timetruncate(col_timestamp, 1m) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate(col_timestamp, 1m) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate(col_timestamp, 1m) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")

        tdSql.query("select timetruncate(col_timestamp, 1h) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate(col_timestamp, 1h) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate(col_timestamp, 1h) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")

        tdSql.query("select timetruncate(col_timestamp, 1d) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate(col_timestamp, 1d) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate(col_timestamp, 1d) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")

        tdSql.query("select timetruncate(col_timestamp, 1w) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-07 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-06 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(col_timestamp, 1w) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-07 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-06 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(col_timestamp, 1w) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-07 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-06 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")

        print("============== STEP 2: select timetruncate() with microsecond db precision ================== ")

        tdSql.execute('use db_u')

        #epoch as input
        ts = 61
        tdSql.query("select timetruncate(%d, 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate(%d, 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate(%d, 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")

        tdSql.query("select timetruncate(%d, 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate(%d, 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate(%d, 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")

        tdSql.query("select timetruncate(%d, 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate(%d, 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate(%d, 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")

        tdSql.query("select timetruncate(%d, 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:00")
        tdSql.query("select timetruncate(%d, 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:00")
        tdSql.query("select timetruncate(%d, 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:00")

        tdSql.query("select timetruncate(%d, 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate(%d, 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate(%d, 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")

        tdSql.query("select timetruncate(%d, 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")

        tdSql.query("select timetruncate(%d, 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")

        ts = 92986230
        tdSql.query("select timetruncate(%d, 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate(%d, 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate(%d, 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")

        tdSql.query("select timetruncate(%d, 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate(%d, 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate(%d, 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")

        tdSql.query("select timetruncate(%d, 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate(%d, 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate(%d, 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")

        tdSql.query("select timetruncate(%d, 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:00")
        tdSql.query("select timetruncate(%d, 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:00")
        tdSql.query("select timetruncate(%d, 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:00")

        tdSql.query("select timetruncate(%d, 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:00:00")
        tdSql.query("select timetruncate(%d, 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:00:00")
        tdSql.query("select timetruncate(%d, 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:00:00")

        tdSql.query("select timetruncate(%d, 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 08:00:00")

        tdSql.query("select timetruncate(%d, 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-07 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-07 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-07 08:00:00")

        ts = 1643779830123
        tdSql.query("select timetruncate(%d, 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate(%d, 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate(%d, 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate(%d, 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate(%d, 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")

        tdSql.query("select timetruncate(%d, 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate(%d, 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate(%d, 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")

        tdSql.query("select timetruncate(%d, 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate(%d, 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate(%d, 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")

        tdSql.query("select timetruncate(%d, 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")

        tdSql.query("select timetruncate(%d, 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")

        ts = 1643779830123456
        tdSql.query("select timetruncate(%d, 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123456")
        tdSql.query("select timetruncate(%d, 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123456")
        tdSql.query("select timetruncate(%d, 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123456")

        tdSql.query("select timetruncate(%d, 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate(%d, 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate(%d, 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate(%d, 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")

        tdSql.query("select timetruncate(%d, 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate(%d, 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate(%d, 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")

        tdSql.query("select timetruncate(%d, 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate(%d, 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate(%d, 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")

        tdSql.query("select timetruncate(%d, 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")

        tdSql.query("select timetruncate(%d, 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")

        ts = 1643779830123456789
        tdSql.query("select timetruncate(%d, 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123456")
        tdSql.query("select timetruncate(%d, 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123456")
        tdSql.query("select timetruncate(%d, 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123456")

        tdSql.query("select timetruncate(%d, 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(%d, 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate(%d, 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate(%d, 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate(%d, 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")

        tdSql.query("select timetruncate(%d, 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate(%d, 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate(%d, 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")

        tdSql.query("select timetruncate(%d, 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate(%d, 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate(%d, 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")

        tdSql.query("select timetruncate(%d, 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate(%d, 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")

        tdSql.query("select timetruncate(%d, 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(%d, 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")

        #datetime string as input
        ts = "1970-01-01 08:01:01" # 61
        tdSql.query("select timetruncate('%s', 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate('%s', 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate('%s', 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")

        tdSql.query("select timetruncate('%s', 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate('%s', 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate('%s', 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")

        tdSql.query("select timetruncate('%s', 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate('%s', 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        tdSql.query("select timetruncate('%s', 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")

        tdSql.query("select timetruncate('%s', 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:00")
        tdSql.query("select timetruncate('%s', 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:00")
        tdSql.query("select timetruncate('%s', 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:00")

        tdSql.query("select timetruncate('%s', 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate('%s', 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate('%s', 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")

        tdSql.query("select timetruncate('%s', 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")

        tdSql.query("select timetruncate('%s', 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")

        ts = "1972-12-12 13:30:30" # 92986230
        tdSql.query("select timetruncate('%s', 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate('%s', 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate('%s', 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")

        tdSql.query("select timetruncate('%s', 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate('%s', 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate('%s', 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")

        tdSql.query("select timetruncate('%s', 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate('%s', 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        tdSql.query("select timetruncate('%s', 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")

        tdSql.query("select timetruncate('%s', 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:00")
        tdSql.query("select timetruncate('%s', 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:00")
        tdSql.query("select timetruncate('%s', 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:00")

        tdSql.query("select timetruncate('%s', 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:00:00")
        tdSql.query("select timetruncate('%s', 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:00:00")
        tdSql.query("select timetruncate('%s', 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:00:00")

        tdSql.query("select timetruncate('%s', 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-12 08:00:00")

        tdSql.query("select timetruncate('%s', 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-07 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-07 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1972-12-07 08:00:00")

        ts = "2001-09-09 09:46:39" # 999999999
        tdSql.query("select timetruncate('%s', 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        tdSql.query("select timetruncate('%s', 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        tdSql.query("select timetruncate('%s', 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")

        tdSql.query("select timetruncate('%s', 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        tdSql.query("select timetruncate('%s', 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        tdSql.query("select timetruncate('%s', 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")

        tdSql.query("select timetruncate('%s', 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        tdSql.query("select timetruncate('%s', 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        tdSql.query("select timetruncate('%s', 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")

        tdSql.query("select timetruncate('%s', 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:00")
        tdSql.query("select timetruncate('%s', 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:00")
        tdSql.query("select timetruncate('%s', 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:00")

        tdSql.query("select timetruncate('%s', 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:00:00")
        tdSql.query("select timetruncate('%s', 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:00:00")
        tdSql.query("select timetruncate('%s', 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:00:00")

        tdSql.query("select timetruncate('%s', 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-09 08:00:00")

        tdSql.query("select timetruncate('%s', 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-06 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-06 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2001-09-06 08:00:00")

        ts = "2022-02-02 13:30:30.123" # 1643779830123
        tdSql.query("select timetruncate('%s', 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate('%s', 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate('%s', 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate('%s', 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate('%s', 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")

        tdSql.query("select timetruncate('%s', 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate('%s', 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate('%s', 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")

        tdSql.query("select timetruncate('%s', 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate('%s', 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate('%s', 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")

        tdSql.query("select timetruncate('%s', 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")

        tdSql.query("select timetruncate('%s', 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")

        ts = "2022-02-02 13:30:30.123456" # 1643779830123456
        tdSql.query("select timetruncate('%s', 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123456")
        tdSql.query("select timetruncate('%s', 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123456")
        tdSql.query("select timetruncate('%s', 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123456")

        tdSql.query("select timetruncate('%s', 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate('%s', 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate('%s', 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate('%s', 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")

        tdSql.query("select timetruncate('%s', 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate('%s', 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate('%s', 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")

        tdSql.query("select timetruncate('%s', 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate('%s', 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate('%s', 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")

        tdSql.query("select timetruncate('%s', 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")

        tdSql.query("select timetruncate('%s', 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")

        ts = "2022-02-02 13:30:30.123456789" # 1643779830123456789
        tdSql.query("select timetruncate('%s', 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123456")
        tdSql.query("select timetruncate('%s', 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123456")
        tdSql.query("select timetruncate('%s', 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123456")

        tdSql.query("select timetruncate('%s', 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate('%s', 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate('%s', 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate('%s', 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate('%s', 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")

        tdSql.query("select timetruncate('%s', 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate('%s', 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate('%s', 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")

        tdSql.query("select timetruncate('%s', 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate('%s', 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate('%s', 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")

        tdSql.query("select timetruncate('%s', 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate('%s', 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")

        tdSql.query("select timetruncate('%s', 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate('%s', 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")

        #timestamp column as input
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:01', '1972-12-12 13:30:30', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:02', '2001-09-09 09:46:39', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:03', '2022-02-02 13:30:30.123', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:04', '2022-02-02 13:30:30.123456', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:05', '2022-02-02 13:30:30.123456789', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:01', '1972-12-12 13:30:30', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:02', '2001-09-09 09:46:39', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:03', '2022-02-02 13:30:30.123', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:04', '2022-02-02 13:30:30.123456', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:05', '2022-02-02 13:30:30.123456789', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #primary ts column
        tdSql.query("select timetruncate(ts, 1u) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select timetruncate(ts, 1u) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select timetruncate(ts, 1u) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")

        tdSql.query("select timetruncate(ts, 1a) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select timetruncate(ts, 1a) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select timetruncate(ts, 1a) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")

        tdSql.query("select timetruncate(ts, 1s) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select timetruncate(ts, 1s) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select timetruncate(ts, 1s) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")

        tdSql.query("select timetruncate(ts, 1m) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select timetruncate(ts, 1m) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select timetruncate(ts, 1m) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")

        tdSql.query("select timetruncate(ts, 1h) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select timetruncate(ts, 1h) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select timetruncate(ts, 1h) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")

        tdSql.query("select timetruncate(ts, 1d) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        tdSql.query("select timetruncate(ts, 1d) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        tdSql.query("select timetruncate(ts, 1d) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-01 08:00:00")

        tdSql.query("select timetruncate(ts, 1w) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(ts, 1w) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(ts, 1w) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")

        #normal ts column
        tdSql.query("select timetruncate(col_timestamp, 1u) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123456")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123456")
        tdSql.query("select timetruncate(col_timestamp, 1u) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123456")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123456")
        tdSql.query("select timetruncate(col_timestamp, 1u) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123456")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123456")

        tdSql.query("select timetruncate(col_timestamp, 1a) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(col_timestamp, 1a) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        tdSql.query("select timetruncate(col_timestamp, 1a) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30.123000")

        tdSql.query("select timetruncate(col_timestamp, 1s) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate(col_timestamp, 1s) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        tdSql.query("select timetruncate(col_timestamp, 1s) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:30")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:39")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:30")

        tdSql.query("select timetruncate(col_timestamp, 1m) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate(col_timestamp, 1m) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        tdSql.query("select timetruncate(col_timestamp, 1m) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:01:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:30:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:46:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:30:00")

        tdSql.query("select timetruncate(col_timestamp, 1h) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate(col_timestamp, 1h) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        tdSql.query("select timetruncate(col_timestamp, 1h) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 13:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 09:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 13:00:00")

        tdSql.query("select timetruncate(col_timestamp, 1d) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate(col_timestamp, 1d) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        tdSql.query("select timetruncate(col_timestamp, 1d) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-12 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-09 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 08:00:00")

        tdSql.query("select timetruncate(col_timestamp, 1w) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-07 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-06 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(col_timestamp, 1w) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-07 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-06 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        tdSql.query("select timetruncate(col_timestamp, 1w) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "1970-01-01 08:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "1972-12-07 08:00:00")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2001-09-06 08:00:00")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-01-27 08:00:00")

        print("============== STEP 3: select timetruncate() with nanosecond db precision ================== ")

        tdSql.execute('use db_n')
        #epoch as input
        factor = 1000000000
        ts = 61
        #TODO: return value bug, taos shell shows correct value
        #tdSql.query("select timetruncate(%d, 1u) from tb" %ts)
        #tdSql.checkRows(1)
        #tdSql.checkEqual(str(res), str(61 * factor))
        #tdSql.query("select timetruncate(%d, 1u) from ctb" %ts)
        #tdSql.checkRows(1)
        #res = tdSql.getData(0, 0)
        #tdSql.checkEqual(str(res), str(61 * factor))
        #tdSql.query("select timetruncate(%d, 1u) from stb" %ts)
        #tdSql.checkRows(1)
        #res = tdSql.getData(0, 0)
        #tdSql.checkEqual(str(res), str(61 * factor))

        tdSql.query("select timetruncate(%d, 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(61 * factor))
        tdSql.query("select timetruncate(%d, 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(61 * factor))
        tdSql.query("select timetruncate(%d, 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(61 * factor))

        tdSql.query("select timetruncate(%d, 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(61 * factor))
        tdSql.query("select timetruncate(%d, 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(61 * factor))
        tdSql.query("select timetruncate(%d, 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(61 * factor))

        tdSql.query("select timetruncate(%d, 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(60 * factor))
        tdSql.query("select timetruncate(%d, 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(60 * factor))
        tdSql.query("select timetruncate(%d, 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(60 * factor))

        tdSql.query("select timetruncate(%d, 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(0))
        tdSql.query("select timetruncate(%d, 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(0))
        tdSql.query("select timetruncate(%d, 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(0))

        tdSql.query("select timetruncate(%d, 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(0))
        tdSql.query("select timetruncate(%d, 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(0))
        tdSql.query("select timetruncate(%d, 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(0))

        tdSql.query("select timetruncate(%d, 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(0))
        tdSql.query("select timetruncate(%d, 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(0))
        tdSql.query("select timetruncate(%d, 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(0))

        ts = 92986230
        tdSql.query("select timetruncate(%d, 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * factor))
        tdSql.query("select timetruncate(%d, 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * factor))
        tdSql.query("select timetruncate(%d, 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * factor))

        tdSql.query("select timetruncate(%d, 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * factor))
        tdSql.query("select timetruncate(%d, 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * factor))
        tdSql.query("select timetruncate(%d, 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * factor))

        tdSql.query("select timetruncate(%d, 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * factor))
        tdSql.query("select timetruncate(%d, 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * factor))
        tdSql.query("select timetruncate(%d, 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * factor))

        tdSql.query("select timetruncate(%d, 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 30) * factor))
        tdSql.query("select timetruncate(%d, 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 30) * factor))
        tdSql.query("select timetruncate(%d, 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 30) * factor))

        tdSql.query("select timetruncate(%d, 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 30*60 - 30) * factor))

        tdSql.query("select timetruncate(%d, 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 5*60*60 - 30*60 - 30) * factor))

        tdSql.query("select timetruncate(%d, 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 5*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 5*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 5*24*60*60 - 5*60*60 - 30*60 - 30) * factor))

        ts = 1643779830123
        tdSql.query("select timetruncate(%d, 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * int(factor/1000)))
        tdSql.query("select timetruncate(%d, 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * int(factor/1000)))
        tdSql.query("select timetruncate(%d, 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * int(factor/1000)))

        tdSql.query("select timetruncate(%d, 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * int(factor/1000)))
        tdSql.query("select timetruncate(%d, 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * int(factor/1000)))
        tdSql.query("select timetruncate(%d, 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * int(factor/1000)))

        tdSql.query("select timetruncate(%d, 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000) * factor))
        tdSql.query("select timetruncate(%d, 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000) * factor))
        tdSql.query("select timetruncate(%d, 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000) * factor))

        tdSql.query("select timetruncate(%d, 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 30) * factor))
        tdSql.query("select timetruncate(%d, 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 30) * factor))
        tdSql.query("select timetruncate(%d, 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 30) * factor))

        tdSql.query("select timetruncate(%d, 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 30*60 - 30) * factor))

        tdSql.query("select timetruncate(%d, 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 5*60*60 - 30*60 - 30) * factor))

        tdSql.query("select timetruncate(%d, 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))

        ts = 1643779830123456
        tdSql.query("select timetruncate(%d, 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * int(factor/1000000)))
        tdSql.query("select timetruncate(%d, 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * int(factor/1000000)))
        tdSql.query("select timetruncate(%d, 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * int(factor/1000000)))

        tdSql.query("select timetruncate(%d, 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000) * int(factor/1000)))
        tdSql.query("select timetruncate(%d, 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000) * int(factor/1000)))
        tdSql.query("select timetruncate(%d, 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000) * int(factor/1000)))

        tdSql.query("select timetruncate(%d, 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000000) * factor))
        tdSql.query("select timetruncate(%d, 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000000) * factor))
        tdSql.query("select timetruncate(%d, 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000000) * factor))

        tdSql.query("select timetruncate(%d, 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 30) * factor))
        tdSql.query("select timetruncate(%d, 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 30) * factor))
        tdSql.query("select timetruncate(%d, 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 30) * factor))

        tdSql.query("select timetruncate(%d, 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 30*60 - 30) * factor))

        tdSql.query("select timetruncate(%d, 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 5*60*60 - 30*60 - 30) * factor))

        tdSql.query("select timetruncate(%d, 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))

        ts = 1643779830123456789
        tdSql.query("select timetruncate(%d, 1u) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000) * int(factor/1000000)))
        tdSql.query("select timetruncate(%d, 1u) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000) * int(factor/1000000)))
        tdSql.query("select timetruncate(%d, 1u) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000) * int(factor/1000000)))

        tdSql.query("select timetruncate(%d, 1a) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000000) * int(factor/1000)))
        tdSql.query("select timetruncate(%d, 1a) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000000) * int(factor/1000)))
        tdSql.query("select timetruncate(%d, 1a) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000000) * int(factor/1000)))

        tdSql.query("select timetruncate(%d, 1s) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / factor) * factor))
        tdSql.query("select timetruncate(%d, 1s) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / factor) * factor))
        tdSql.query("select timetruncate(%d, 1s) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / factor) * factor))

        tdSql.query("select timetruncate(%d, 1m) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 30) * factor))
        tdSql.query("select timetruncate(%d, 1m) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 30) * factor))
        tdSql.query("select timetruncate(%d, 1m) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 30) * factor))

        tdSql.query("select timetruncate(%d, 1h) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1h) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1h) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 30*60 - 30) * factor))

        tdSql.query("select timetruncate(%d, 1d) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1d) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1d) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 5*60*60 - 30*60 - 30) * factor))

        tdSql.query("select timetruncate(%d, 1w) from tb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1w) from ctb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(%d, 1w) from stb" %ts)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))

        #datetime string as input
        tdSql.execute("use db_n")
        factor = 1000000000
        ts_str = "1970-01-01 08:01:01" # 61
        #TODO: return value bug, taos shell shows correct value
        #tdSql.query("select timetruncate('%s', 1u) from tb" %ts_str)
        #tdSql.checkRows(1)
        #tdSql.checkEqual(str(res), str(61 * factor))
        #tdSql.query("select timetruncate('%s', 1u) from tb" %ts_str)
        #tdSql.checkRows(1)
        #res = tdSql.getData(0, 0)
        #tdSql.checkEqual(str(res), str(61 * factor))
        #tdSql.query("select timetruncate('%s', 1u) from tb" %ts_str)
        #tdSql.checkRows(1)
        #res = tdSql.getData(0, 0)
        #tdSql.checkEqual(str(res), str(61 * factor))

        tdSql.query("select timetruncate('%s', 1a) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(61 * factor))
        tdSql.query("select timetruncate('%s', 1a) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(61 * factor))
        tdSql.query("select timetruncate('%s', 1a) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(61 * factor))

        tdSql.query("select timetruncate('%s', 1s) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(61 * factor))
        tdSql.query("select timetruncate('%s', 1s) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(61 * factor))
        tdSql.query("select timetruncate('%s', 1s) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(61 * factor))

        tdSql.query("select timetruncate('%s', 1m) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(60 * factor))
        tdSql.query("select timetruncate('%s', 1m) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(60 * factor))
        tdSql.query("select timetruncate('%s', 1m) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(60 * factor))

        tdSql.query("select timetruncate('%s', 1h) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(0))
        tdSql.query("select timetruncate('%s', 1h) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(0))
        tdSql.query("select timetruncate('%s', 1h) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(0))

        tdSql.query("select timetruncate('%s', 1d) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(0))
        tdSql.query("select timetruncate('%s', 1d) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(0))
        tdSql.query("select timetruncate('%s', 1d) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(0))

        tdSql.query("select timetruncate('%s', 1w) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(0))
        tdSql.query("select timetruncate('%s', 1w) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(0))
        tdSql.query("select timetruncate('%s', 1w) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(0))


        ts_str = "1972-12-12 13:30:30" # 92986230
        ts = 92986230
        tdSql.query("select timetruncate('%s', 1u) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * factor))
        tdSql.query("select timetruncate('%s', 1u) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * factor))
        tdSql.query("select timetruncate('%s', 1u) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * factor))

        tdSql.query("select timetruncate('%s', 1a) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * factor))
        tdSql.query("select timetruncate('%s', 1a) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * factor))
        tdSql.query("select timetruncate('%s', 1a) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * factor))

        tdSql.query("select timetruncate('%s', 1s) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * factor))
        tdSql.query("select timetruncate('%s', 1s) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * factor))
        tdSql.query("select timetruncate('%s', 1s) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * factor))

        tdSql.query("select timetruncate('%s', 1m) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 30) * factor))
        tdSql.query("select timetruncate('%s', 1m) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 30) * factor))
        tdSql.query("select timetruncate('%s', 1m) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 30) * factor))

        tdSql.query("select timetruncate('%s', 1h) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1h) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1h) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 30*60 - 30) * factor))

        tdSql.query("select timetruncate('%s', 1d) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1d) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1d) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 5*60*60 - 30*60 - 30) * factor))

        tdSql.query("select timetruncate('%s', 1w) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 5*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1w) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 5*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1w) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((ts - 5*24*60*60 - 5*60*60 - 30*60 - 30) * factor))

        ts_str = "2022-02-02 13:30:30.123" # 1643779830123
        ts = 1643779830123
        tdSql.query("select timetruncate('%s', 1u) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * int(factor/1000)))
        tdSql.query("select timetruncate('%s', 1u) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * int(factor/1000)))
        tdSql.query("select timetruncate('%s', 1u) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * int(factor/1000)))

        tdSql.query("select timetruncate('%s', 1a) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * int(factor/1000)))
        tdSql.query("select timetruncate('%s', 1a) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * int(factor/1000)))
        tdSql.query("select timetruncate('%s', 1a) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * int(factor/1000)))

        tdSql.query("select timetruncate('%s', 1s) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000) * factor))
        tdSql.query("select timetruncate('%s', 1s) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000) * factor))
        tdSql.query("select timetruncate('%s', 1s) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000) * factor))

        tdSql.query("select timetruncate('%s', 1m) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 30) * factor))
        tdSql.query("select timetruncate('%s', 1m) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 30) * factor))
        tdSql.query("select timetruncate('%s', 1m) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 30) * factor))

        tdSql.query("select timetruncate('%s', 1h) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1h) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1h) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 30*60 - 30) * factor))

        tdSql.query("select timetruncate('%s', 1d) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1d) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1d) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 5*60*60 - 30*60 - 30) * factor))

        tdSql.query("select timetruncate('%s', 1w) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1w) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1w) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))

        ts_str = "2022-02-02 13:30:30.123456" # 1643779830123456
        ts = 1643779830123456
        tdSql.query("select timetruncate('%s', 1u) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * int(factor/1000000)))
        tdSql.query("select timetruncate('%s', 1u) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * int(factor/1000000)))
        tdSql.query("select timetruncate('%s', 1u) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts * int(factor/1000000)))

        tdSql.query("select timetruncate('%s', 1a) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000) * int(factor/1000)))
        tdSql.query("select timetruncate('%s', 1a) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000) * int(factor/1000)))
        tdSql.query("select timetruncate('%s', 1a) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000) * int(factor/1000)))

        tdSql.query("select timetruncate('%s', 1s) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000000) * factor))
        tdSql.query("select timetruncate('%s', 1s) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000000) * factor))
        tdSql.query("select timetruncate('%s', 1s) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000000) * factor))

        tdSql.query("select timetruncate('%s', 1m) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 30) * factor))
        tdSql.query("select timetruncate('%s', 1m) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 30) * factor))
        tdSql.query("select timetruncate('%s', 1m) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 30) * factor))

        tdSql.query("select timetruncate('%s', 1h) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1h) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1h) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 30*60 - 30) * factor))

        tdSql.query("select timetruncate('%s', 1d) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1d) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1d) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 5*60*60 - 30*60 - 30) * factor))

        tdSql.query("select timetruncate('%s', 1w) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1w) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1w) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / 1000000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))

        ts_str = "2022-02-02 13:30:30.123456789" # 1643779830123456789
        ts = 1643779830123456789
        tdSql.query("select timetruncate('%s', 1u) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000) * int(factor/1000000)))
        tdSql.query("select timetruncate('%s', 1u) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000) * int(factor/1000000)))
        tdSql.query("select timetruncate('%s', 1u) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000) * int(factor/1000000)))

        tdSql.query("select timetruncate('%s', 1a) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000000) * int(factor/1000)))
        tdSql.query("select timetruncate('%s', 1a) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000000) * int(factor/1000)))
        tdSql.query("select timetruncate('%s', 1a) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / 1000000) * int(factor/1000)))

        tdSql.query("select timetruncate('%s', 1s) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / factor) * factor))
        tdSql.query("select timetruncate('%s', 1s) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / factor) * factor))
        tdSql.query("select timetruncate('%s', 1s) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts / factor) * factor))

        tdSql.query("select timetruncate('%s', 1m) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 30) * factor))
        tdSql.query("select timetruncate('%s', 1m) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 30) * factor))
        tdSql.query("select timetruncate('%s', 1m) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 30) * factor))

        tdSql.query("select timetruncate('%s', 1h) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1h) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1h) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 30*60 - 30) * factor))

        tdSql.query("select timetruncate('%s', 1d) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1d) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1d) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 5*60*60 - 30*60 - 30) * factor))

        tdSql.query("select timetruncate('%s', 1w) from tb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1w) from ctb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate('%s', 1w) from stb" %ts_str)
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str((int(ts / factor) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))

        #timestamp column as input
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:01', '1972-12-12 13:30:30', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:02', '2001-09-09 09:46:39', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:03', '2022-02-02 13:30:30.123', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:04', '2022-02-02 13:30:30.123456', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:05', '2022-02-02 13:30:30.123456789', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:01', '1972-12-12 13:30:30', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:02', '2001-09-09 09:46:39', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:03', '2022-02-02 13:30:30.123', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:04', '2022-02-02 13:30:30.123456', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:05', '2022-02-02 13:30:30.123456789', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #primary ts column
        tdSql.query("select timetruncate(ts, 1u) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643738401000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643738402000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643738403000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643738404000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643738405000000000))
        tdSql.query("select timetruncate(ts, 1u) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643738401000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643738402000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643738403000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643738404000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643738405000000000))
        tdSql.query("select timetruncate(ts, 1u) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643738401000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643738402000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643738403000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643738404000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643738405000000000))

        tdSql.query("select timetruncate(ts, 1a) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643738401000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643738402000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643738403000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643738404000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643738405000000000))
        tdSql.query("select timetruncate(ts, 1a) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643738401000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643738402000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643738403000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643738404000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643738405000000000))
        tdSql.query("select timetruncate(ts, 1a) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643738401000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643738402000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643738403000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643738404000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643738405000000000))


        tdSql.query("select timetruncate(ts, 1s) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643738401000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643738402000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643738403000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643738404000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643738405000000000))
        tdSql.query("select timetruncate(ts, 1s) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643738401000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643738402000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643738403000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643738404000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643738405000000000))
        tdSql.query("select timetruncate(ts, 1s) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643738401000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643738402000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643738403000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643738404000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643738405000000000))

        tdSql.query("select timetruncate(ts, 1m) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        tdSql.query("select timetruncate(ts, 1m) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        tdSql.query("select timetruncate(ts, 1m) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))

        tdSql.query("select timetruncate(ts, 1h) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        tdSql.query("select timetruncate(ts, 1h) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        tdSql.query("select timetruncate(ts, 1h) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643738400000000000))

        tdSql.query("select timetruncate(ts, 1d) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643673600000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643673600000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643673600000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643673600000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643673600000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643673600000000000))
        tdSql.query("select timetruncate(ts, 1d) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643673600000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643673600000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643673600000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643673600000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643673600000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643673600000000000))
        tdSql.query("select timetruncate(ts, 1d) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643673600000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643673600000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643673600000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643673600000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643673600000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643673600000000000))

        tdSql.query("select timetruncate(ts, 1w) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643241600000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643241600000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643241600000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643241600000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643241600000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643241600000000000))
        tdSql.query("select timetruncate(ts, 1w) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643241600000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643241600000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643241600000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643241600000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643241600000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643241600000000000))
        tdSql.query("select timetruncate(ts, 1w) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(1643241600000000000))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(1643241600000000000))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(1643241600000000000))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(1643241600000000000))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(1643241600000000000))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(1643241600000000000))

        #normal ts column
        factor = 1000000000
        ts = [61, 92986230, 999999999, 1643779830123, 1643779830123456, 1643779830123456789]

        tdSql.query("select timetruncate(col_timestamp, 1u) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts[0] * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(ts[1] * factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(ts[2] * factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(ts[3] * int(factor / 1000)))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(ts[4] * int(factor / 1000000)))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(int(ts[5] / 1000) * int(factor / 1000000)))
        tdSql.query("select timetruncate(col_timestamp, 1u) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts[0] * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(ts[1] * factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(ts[2] * factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(ts[3] * int(factor / 1000)))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(ts[4] * int(factor / 1000000)))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(int(ts[5] / 1000) * int(factor / 1000000)))
        tdSql.query("select timetruncate(col_timestamp, 1u) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts[0] * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(ts[1] * factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(ts[2] * factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(ts[3] * int(factor / 1000)))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(ts[4] * int(factor / 1000000)))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(int(ts[5] / 1000) * int(factor / 1000000)))

        tdSql.query("select timetruncate(col_timestamp, 1a) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts[0] * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(ts[1] * factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(ts[2] * factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(ts[3] * int(factor / 1000)))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(int(ts[4] / 1000) * int(factor / 1000)))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(int(ts[5] / 1000000) * int(factor / 1000)))
        tdSql.query("select timetruncate(col_timestamp, 1a) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts[0] * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(ts[1] * factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(ts[2] * factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(ts[3] * int(factor / 1000)))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(int(ts[4] / 1000) * int(factor / 1000)))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(int(ts[5] / 1000000) * int(factor / 1000)))
        tdSql.query("select timetruncate(col_timestamp, 1a) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts[0] * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(ts[1] * factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(ts[2] * factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(ts[3] * int(factor / 1000)))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(int(ts[4] / 1000) * int(factor / 1000)))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(int(ts[5] / 1000000) * int(factor / 1000)))

        tdSql.query("select timetruncate(col_timestamp, 1s) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts[0] * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(ts[1] * factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(ts[2] * factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(int(ts[3] / 1000) * factor))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(int(ts[4] / 1000000) * factor))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(int(ts[5] / 1000000000) * factor))
        tdSql.query("select timetruncate(col_timestamp, 1s) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts[0] * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(ts[1] * factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(ts[2] * factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(int(ts[3] / 1000) * factor))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(int(ts[4] / 1000000) * factor))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(int(ts[5] / 1000000000) * factor))
        tdSql.query("select timetruncate(col_timestamp, 1s) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(ts[0] * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(ts[1] * factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(ts[2] * factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str(int(ts[3] / 1000) * factor))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str(int(ts[4] / 1000000) * factor))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str(int(ts[5] / 1000000000) * factor))

        tdSql.query("select timetruncate(col_timestamp, 1m) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts[0] - 1) * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(int(ts[1] - 30)* factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(int(ts[2] - 39)* factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str((int(ts[3] / 1000) -30) * factor))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str((int(ts[4] / 1000000) - 30) * factor))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str((int(ts[5] / 1000000000) - 30) * factor))
        tdSql.query("select timetruncate(col_timestamp, 1m) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts[0] - 1) * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(int(ts[1] - 30)* factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(int(ts[2] - 39)* factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str((int(ts[3] / 1000) -30) * factor))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str((int(ts[4] / 1000000) - 30) * factor))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str((int(ts[5] / 1000000000) - 30) * factor))
        tdSql.query("select timetruncate(col_timestamp, 1m) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts[0] - 1) * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(int(ts[1] - 30)* factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(int(ts[2] - 39)* factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str((int(ts[3] / 1000) -30) * factor))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str((int(ts[4] / 1000000) - 30) * factor))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str((int(ts[5] / 1000000000) - 30) * factor))

        tdSql.query("select timetruncate(col_timestamp, 1h) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts[0] - 1*60 - 1) * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(int(ts[1] - 30*60 - 30)* factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(int(ts[2] - 46*60 - 39)* factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str((int(ts[3] / 1000) - 30*60 - 30) * factor))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str((int(ts[4] / 1000000) - 30*60 - 30) * factor))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str((int(ts[5] / 1000000000) - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(col_timestamp, 1h) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts[0] - 1*60 - 1) * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(int(ts[1] - 30*60 - 30)* factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(int(ts[2] - 46*60 - 39)* factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str((int(ts[3] / 1000) - 30*60 - 30) * factor))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str((int(ts[4] / 1000000) - 30*60 - 30) * factor))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str((int(ts[5] / 1000000000) - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(col_timestamp, 1h) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts[0] - 1*60 - 1) * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(int(ts[1] - 30*60 - 30)* factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(int(ts[2] - 46*60 - 39)* factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str((int(ts[3] / 1000) - 30*60 - 30) * factor))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str((int(ts[4] / 1000000) - 30*60 - 30) * factor))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str((int(ts[5] / 1000000000) - 30*60 - 30) * factor))

        tdSql.query("select timetruncate(col_timestamp, 1d) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts[0] - 1*60 - 1) * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(int(ts[1] - 5*60*60 - 30*60 - 30)* factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(int(ts[2] - 1*60*60 - 46*60 - 39)* factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str((int(ts[3] / 1000) - 5*60*60 - 30*60 - 30) * factor))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str((int(ts[4] / 1000000) - 5*60*60 - 30*60 - 30) * factor))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str((int(ts[5] / 1000000000) - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(col_timestamp, 1d) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts[0] - 1*60 - 1) * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(int(ts[1] - 5*60*60 - 30*60 - 30)* factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(int(ts[2] - 1*60*60 - 46*60 - 39)* factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str((int(ts[3] / 1000) - 5*60*60 - 30*60 - 30) * factor))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str((int(ts[4] / 1000000) - 5*60*60 - 30*60 - 30) * factor))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str((int(ts[5] / 1000000000) - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(col_timestamp, 1d) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts[0] - 1*60 - 1) * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(int(ts[1] - 5*60*60 - 30*60 - 30)* factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(int(ts[2] - 1*60*60 - 46*60 - 39)* factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str((int(ts[3] / 1000) - 5*60*60 - 30*60 - 30) * factor))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str((int(ts[4] / 1000000) - 5*60*60 - 30*60 - 30) * factor))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str((int(ts[5] / 1000000000) - 5*60*60 - 30*60 - 30) * factor))

        tdSql.query("select timetruncate(col_timestamp, 1w) from tb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts[0] - 1*60 - 1) * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(int(ts[1] - 5*24*60*60 - 5*60*60 - 30*60 - 30)* factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(int(ts[2] - 3*24*60*60 - 1*60*60 - 46*60 - 39)* factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str((int(ts[3] / 1000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str((int(ts[4] / 1000000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str((int(ts[5] / 1000000000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(col_timestamp, 1w) from ctb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts[0] - 1*60 - 1) * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(int(ts[1] - 5*24*60*60 - 5*60*60 - 30*60 - 30)* factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(int(ts[2] - 3*24*60*60 - 1*60*60 - 46*60 - 39)* factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str((int(ts[3] / 1000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str((int(ts[4] / 1000000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str((int(ts[5] / 1000000000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        tdSql.query("select timetruncate(col_timestamp, 1w) from stb")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), str(int(ts[0] - 1*60 - 1) * factor))
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), str(int(ts[1] - 5*24*60*60 - 5*60*60 - 30*60 - 30)* factor))
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), str(int(ts[2] - 3*24*60*60 - 1*60*60 - 46*60 - 39)* factor))
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), str((int(ts[3] / 1000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), str((int(ts[4] / 1000000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), str((int(ts[5] / 1000000000) - 6*24*60*60 - 5*60*60 - 30*60 - 30) * factor))

        print("============== STEP 4: select timetruncate() other use cases ================== ")
        tdSql.execute("drop database if exists db_m")
        tdSql.execute("create database if not exists db_m")
        tdSql.execute('use db_m')

        tdSql.execute("create stable stb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb using stb tags ('2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        ts = 1643738400
        #timetruncate(), col
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),col_bigint from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, 1)
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),col_bigint from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, 1)
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),col_bigint from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, 1)

        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),col_bool from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, True)
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),col_bool from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, True)
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),col_bool from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, True)

        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),col_float from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),col_float from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),col_float from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),col_binary from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, "abc")
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),col_binary from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, "abc")
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),col_binary from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, "abc")

        tdSql.query("select ts, col_smallint, col_float, timetruncate('2022-02-02 02:02:02', 1h), col_binary, col_timestamp from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(6)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(0, 2, 1.0)
        res = tdSql.getData(0, 3)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 4, "abc")
        res = tdSql.getData(0, 5)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select ts, col_smallint, col_float, timetruncate('2022-02-02 02:02:02', 1h), col_binary, col_timestamp from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(6)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(0, 2, 1.0)
        res = tdSql.getData(0, 3)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 4, "abc")
        res = tdSql.getData(0, 5)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select ts, col_smallint, col_float, timetruncate('2022-02-02 02:02:02', 1h), col_binary, col_timestamp from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(6)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(0, 2, 1.0)
        res = tdSql.getData(0, 3)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 4, "abc")
        res = tdSql.getData(0, 5)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")

        #timetruncate(), tag
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),tag_bigint from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, 1)
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),tag_bigint from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, 1)

        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),tag_bool from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, True)
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),tag_bool from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, True)

        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),tag_float from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),tag_float from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),tag_binary from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, "abc")
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),tag_binary from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, "abc")

        tdSql.query("select tag_smallint, tag_float, timetruncate('2022-02-02 02:02:02', 1h), tag_binary, tag_timestamp from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 3, "abc")
        res = tdSql.getData(0, 4)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select tag_smallint, tag_float, timetruncate('2022-02-02 02:02:02', 1h), tag_binary, tag_timestamp from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 3, "abc")
        res = tdSql.getData(0, 4)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")

        #timetruncate(),tbname
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),tbname from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, "tb")
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),tbname from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, "ctb")
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),tbname from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, "ctb")

        #timetruncate(),_c0/_C0
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),_c0 from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),_c0 from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),_c0 from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")

        tdSql.query("select _C0,timetruncate('2022-02-02 02:02:02', 1h) from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select _C0,timetruncate('2022-02-02 02:02:02', 1h) from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select _C0,timetruncate('2022-02-02 02:02:02', 1h) from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')

        #timetruncate(),func()
        #can only be used with scalar functions together
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),ceil(col_bigint) from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, 1)
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),ceil(col_bigint) from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, 1)
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),ceil(col_bigint) from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, 1)

        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),round(col_float) from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),round(col_float) from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),round(col_float) from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),floor(1.5) from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),floor(1.5) from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),floor(1.5) from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select abs(-1),timetruncate('2022-02-02 02:02:02', 1h) from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select abs(-1),timetruncate('2022-02-02 02:02:02', 1h) from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select abs(-1),timetruncate('2022-02-02 02:02:02', 1h) from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')

        tdSql.query("select pow(2,2),timetruncate('2022-02-02 02:02:02', 1h) from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 4.0)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select pow(2,2),timetruncate('2022-02-02 02:02:02', 1h) from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 4.0)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select pow(2,2),timetruncate('2022-02-02 02:02:02', 1h) from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 4.0)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')

        #timetruncate(),timetruncate()
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),timetruncate('2022-02-02 02:02:02', 1h),timetruncate('2022-02-02 02:02:02', 1h) from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),timetruncate('2022-02-02 02:02:02', 1h),timetruncate('2022-02-02 02:02:02', 1h) from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h),timetruncate('2022-02-02 02:02:02', 1h),timetruncate('2022-02-02 02:02:02', 1h) from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')

        #timetruncate(),constant
        tdSql.query("select 123,123.0,true,'123',timetruncate('2022-02-02 02:02:02', 1h) from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 123)
        tdSql.checkData(0, 1, 123.0)
        tdSql.checkData(0, 2, True)
        tdSql.checkData(0, 3, '123')
        res = tdSql.getData(0, 4)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select 123,123.0,true,'123',timetruncate('2022-02-02 02:02:02', 1h) from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 123)
        tdSql.checkData(0, 1, 123.0)
        tdSql.checkData(0, 2, True)
        tdSql.checkData(0, 3, '123')
        res = tdSql.getData(0, 4)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select 123,123.0,true,'123',timetruncate('2022-02-02 02:02:02', 1h) from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 123)
        tdSql.checkData(0, 1, 123.0)
        tdSql.checkData(0, 2, True)
        tdSql.checkData(0, 3, '123')
        res = tdSql.getData(0, 4)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')

        #insert some more data
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.001', '2022-02-02 02:00:00.001', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.001', '2022-02-02 02:00:00.001', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.002', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.002', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #order by
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h) from tb order by ts" )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h) from ctb order by ts" )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h) from stb order by ts" )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')

        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h) from tb order by ts desc" )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h) from ctb order by ts desc" )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h) from stb order by ts desc" )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')

        #limit/offset
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h) from tb limit 2" )
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h) from ctb limit 2" )
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h) from stb limit 2" )
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')

        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h) from tb limit 2 offset 1" )
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h) from ctb limit 2 offset 1" )
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h) from stb limit 2 offset 1" )
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')

        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h) from tb limit 1,2" )
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h) from ctb limit 1,2" )
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select timetruncate('2022-02-02 02:02:02', 1h) from stb limit 1,2" )
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')

        #join
        tdSql.execute("create stable stb1 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb1 using stb1 tags (now, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb1 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb1 values ('2022-01-01 00:00:00.000', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb1 values ('2022-01-01 00:00:00.001', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb1 values ('2022-01-01 00:00:00.002', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.execute("insert into tb1 values ('2022-01-01 00:00:00.000', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb1 values ('2022-01-01 00:00:00.001', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb1 values ('2022-01-01 00:00:00.002', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.execute("create stable stb2 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb2 using stb2 tags (now, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb2 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb2 values ('2022-01-01 00:00:00.000', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb2 values ('2022-01-01 00:00:00.001', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb2 values ('2022-01-01 00:00:00.002', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.execute("insert into tb2 values ('2022-01-01 00:00:00.000', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb2 values ('2022-01-01 00:00:00.001', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb2 values ('2022-01-01 00:00:00.002', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.query('select timetruncate(\'2022-02-02 02:02:02\', 1h) from tb1, tb2 where tb1.col_timestamp = tb2.col_timestamp' );
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')

        tdSql.query('select timetruncate(\'2022-02-02 02:02:02\', 1h) from ctb1, ctb2 where ctb1.col_timestamp = ctb2.col_timestamp' );
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')

        tdSql.query('select timetruncate(\'2022-02-02 02:02:02\', 1h) from stb1, stb2 where stb1.col_timestamp = stb2.col_timestamp and stb1.tag_int = stb2.tag_int' );
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')

        #union all
        tdSql.query('select timetruncate(\'2022-02-02 02:02:02\', 1h) from tb1 union all select timetruncate(\'2022-02-02 02:02:02\', 1h) from tb2')
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query('select timetruncate(\'2022-02-02 02:02:02\', 1h) from ctb1 union all select timetruncate(\'2022-02-02 02:02:02\', 1h) from ctb2')
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query('select timetruncate(\'2022-02-02 02:02:02\', 1h) from stb1 union all select timetruncate(\'2022-02-02 02:02:02\', 1h) from stb2')
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')

        #nested query
        tdSql.query('select timetruncate(\'2022-02-02 02:02:02\', 1h) from (select * from tb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query('select timetruncate(\'2022-02-02 02:02:02\', 1h) from (select * from ctb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query('select timetruncate(\'2022-02-02 02:02:02\', 1h) from (select * from stb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')

        tdSql.query('select timetruncate(\'2022-02-02 02:02:02\', 1h) from (select col_int as val from tb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query('select timetruncate(\'2022-02-02 02:02:02\', 1h) from (select col_int as val from ctb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query('select timetruncate(\'2022-02-02 02:02:02\', 1h) from (select col_int as val from stb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')

        tdSql.query('select * from (select timetruncate(\'2022-02-02 02:02:02\', 1h) from tb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query('select * from (select timetruncate(\'2022-02-02 02:02:02\', 1h) from ctb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query('select * from (select timetruncate(\'2022-02-02 02:02:02\', 1h) from stb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')

        tdSql.query('select _c0 from (select timetruncate(\'2022-02-02 02:02:02\', 1h) from tb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query('select _c0 from (select timetruncate(\'2022-02-02 02:02:02\', 1h) from ctb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query('select _c0 from (select timetruncate(\'2022-02-02 02:02:02\', 1h) from stb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')

        tdSql.query('select timetruncate(\'2022-02-02 02:02:02\', 1h) from (select timetruncate(\'2022-02-02 02:02:02\', 1h) from tb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query('select timetruncate(\'2022-02-02 02:02:02\', 1h) from (select timetruncate(\'2022-02-02 02:02:02\', 1h) from ctb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query('select timetruncate(\'2022-02-02 02:02:02\', 1h) from (select timetruncate(\'2022-02-02 02:02:02\', 1h) from stb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')

        ##ERROR CASES
        #param
        tdSql.error("select timetruncate(1) from tb")
        tdSql.error("select timetruncate(1) from ctb")
        tdSql.error("select timetruncate(1) from stb")
        tdSql.error("select timetruncate(1.0) from tb")
        tdSql.error("select timetruncate(1.0) from ctb")
        tdSql.error("select timetruncate(1.0) from stb")
        tdSql.error("select timetruncate(true) from tb")
        tdSql.error("select timetruncate(true) from ctb")
        tdSql.error("select timetruncate(true) from stb")
        tdSql.error("select timetruncate(\"abc\") from tb")
        tdSql.error("select timetruncate(\"abc\") from ctb")
        tdSql.error("select timetruncate(\"abc\") from stb")
        tdSql.error("select timetruncate(abc) from tb")
        tdSql.error("select timetruncate(abc) from ctb")
        tdSql.error("select timetruncate(abc) from stb")
        tdSql.error("select timetruncate(col_timestamp) from tb")
        tdSql.error("select timetruncate(col_timestamp) from ctb")
        tdSql.error("select timetruncate(col_timestamp) from stb")
        tdSql.error("select timetruncate(tag_timestamp) from tb")
        tdSql.error("select timetruncate(tag_timestamp) from ctb")
        tdSql.error("select timetruncate(tag_timestamp) from stb")

        #tdSql.error("select timetruncate(-1, 1s) from tb")
        #tdSql.error("select timetruncate(-1, 1s) from ctb")
        #tdSql.error("select timetruncate(-1, 1s) from stb")
        #tdSql.error("select timetruncate(1, 1s) from tb")
        #tdSql.error("select timetruncate(1, 1s) from ctb")
        #tdSql.error("select timetruncate(1, 1s) from stb")
        tdSql.error("select timetruncate(true, 1s) from tb")
        tdSql.error("select timetruncate(true, 1s) from ctb")
        tdSql.error("select timetruncate(true, 1s) from stb")
        tdSql.error("select timetruncate(1.5, 1s) from tb")
        tdSql.error("select timetruncate(1.5, 1s) from ctb")
        tdSql.error("select timetruncate(1.5, 1s) from stb")
        #tdSql.error("select timetruncate('abc', 1s) from tb")
        #tdSql.error("select timetruncate('abc', 1s) from ctb")
        #tdSql.error("select timetruncate('abc', 1s) from stb")
        tdSql.error("select timetruncate(*, 1s) from tb")
        tdSql.error("select timetruncate(*, 1s) from ctb")
        tdSql.error("select timetruncate(*, 1s) from stb")
        tdSql.error("select timetruncate(tbname, 1s) from tb")
        tdSql.error("select timetruncate(tbname, 1s) from ctb")
        tdSql.error("select timetruncate(tbname, 1s) from stb")
        tdSql.error("select timetruncate(col_bigint, 1s) from tb")
        tdSql.error("select timetruncate(col_bigint, 1s) from ctb")
        tdSql.error("select timetruncate(col_bigint, 1s) from stb")
        tdSql.error("select timetruncate(col_double, 1s) from tb")
        tdSql.error("select timetruncate(col_double, 1s) from ctb")
        tdSql.error("select timetruncate(col_double, 1s) from stb")
        tdSql.error("select timetruncate(col_bool, 1s) from tb")
        tdSql.error("select timetruncate(col_bool, 1s) from ctb")
        tdSql.error("select timetruncate(col_bool, 1s) from stb")
        tdSql.error("select timetruncate(col_binary, 1s) from tb")
        tdSql.error("select timetruncate(col_binary, 1s) from ctb")
        tdSql.error("select timetruncate(col_binary, 1s) from stb")
        tdSql.error("select timetruncate(tag_timestamp, 1s) from tb")
        tdSql.error("select timetruncate(tag_timestamp, 1s) from ctb")
        tdSql.error("select timetruncate(tag_timestamp, 1s) from stb")
        tdSql.error("select timetruncate(tag_bigint, 1s) from tb")
        tdSql.error("select timetruncate(tag_bigint, 1s) from ctb")
        tdSql.error("select timetruncate(tag_bigint, 1s) from stb")
        tdSql.error("select timetruncate(tag_double, 1s) from tb")
        tdSql.error("select timetruncate(tag_double, 1s) from ctb")
        tdSql.error("select timetruncate(tag_double, 1s) from stb")
        tdSql.error("select timetruncate(tag_bool, 1s) from tb")
        tdSql.error("select timetruncate(tag_bool, 1s) from ctb")
        tdSql.error("select timetruncate(tag_bool, 1s) from stb")
        tdSql.error("select timetruncate(tag_binary, 1s) from tb")
        tdSql.error("select timetruncate(tag_binary, 1s) from ctb")
        tdSql.error("select timetruncate(tag_binary, 1s) from stb")

        tdSql.error("select timetruncate(ts,1) from tb")
        tdSql.error("select timetruncate(ts,1) from ctb")
        tdSql.error("select timetruncate(ts,1) from stb")
        tdSql.error("select timetruncate(ts,true) from tb")
        tdSql.error("select timetruncate(ts,true) from ctb")
        tdSql.error("select timetruncate(ts,true) from stb")
        tdSql.error("select timetruncate(ts,1.5) from tb")
        tdSql.error("select timetruncate(ts,1.5) from ctb")
        tdSql.error("select timetruncate(ts,1.5) from stb")
        tdSql.error("select timetruncate(ts,'abc') from tb")
        tdSql.error("select timetruncate(ts,'abc') from ctb")
        tdSql.error("select timetruncate(ts,'abc') from stb")
        tdSql.error("select timetruncate(ts,*) from tb")
        tdSql.error("select timetruncate(ts,*) from ctb")
        tdSql.error("select timetruncate(ts,*) from stb")
        tdSql.error("select timetruncate(ts,tbname) from tb")
        tdSql.error("select timetruncate(ts,tbname) from ctb")
        tdSql.error("select timetruncate(ts,tbname) from stb")
        tdSql.error("select timetruncate(ts,col_bigint) from tb")
        tdSql.error("select timetruncate(ts,col_bigint) from ctb")
        tdSql.error("select timetruncate(ts,col_bigint) from stb")
        tdSql.error("select timetruncate(ts,col_double) from tb")
        tdSql.error("select timetruncate(ts,col_double) from ctb")
        tdSql.error("select timetruncate(ts,col_double) from stb")
        tdSql.error("select timetruncate(ts,col_bool) from tb")
        tdSql.error("select timetruncate(ts,col_bool) from ctb")
        tdSql.error("select timetruncate(ts,col_bool) from stb")
        tdSql.error("select timetruncate(ts,col_binary) from tb")
        tdSql.error("select timetruncate(ts,col_binary) from ctb")
        tdSql.error("select timetruncate(ts,col_binary) from stb")
        tdSql.error("select timetruncate(ts,tag_timestamp) from tb")
        tdSql.error("select timetruncate(ts,tag_timestamp) from ctb")
        tdSql.error("select timetruncate(ts,tag_timestamp) from stb")
        tdSql.error("select timetruncate(ts,tag_bigint) from tb")
        tdSql.error("select timetruncate(ts,tag_bigint) from ctb")
        tdSql.error("select timetruncate(ts,tag_bigint) from stb")
        tdSql.error("select timetruncate(ts,tag_double) from tb")
        tdSql.error("select timetruncate(ts,tag_double) from ctb")
        tdSql.error("select timetruncate(ts,tag_double) from stb")
        tdSql.error("select timetruncate(ts,tag_bool) from tb")
        tdSql.error("select timetruncate(ts,tag_bool) from ctb")
        tdSql.error("select timetruncate(ts,tag_bool) from stb")
        tdSql.error("select timetruncate(ts,tag_binary) from tb")
        tdSql.error("select timetruncate(ts,tag_binary) from ctb")
        tdSql.error("select timetruncate(ts,tag_binary) from stb")

        tdSql.error("select timetruncate(1,'abc',col_bigint) from tb")
        tdSql.error("select timetruncate(1,'abc',col_bigint) from ctb")
        tdSql.error("select timetruncate(1,'abc',col_bigint) from stb")


        #distinct
        tdSql.error("select distinct timetruncate(ts, 1m) from tb")
        tdSql.error("select distinct timetruncate(ts, 1m) from ctb")
        tdSql.error("select distinct timetruncate(ts, 1m) from stb")

        #arithmetic
        tdSql.error("select timetruncate(ts, 1m) + count(*) from tb")
        tdSql.error("select timetruncate(ts, 1m) + count(*) from ctb")
        tdSql.error("select timetruncate(ts, 1m) + count(*) from stb")
        tdSql.error("select timetruncate(ts, 1m) + avg(col_timestamp) from tb")
        tdSql.error("select timetruncate(ts, 1m) + avg(col_timestamp) from ctb")
        tdSql.error("select timetruncate(ts, 1m) + avg(col_timestamp) from stb")
        tdSql.error("select timetruncate(ts, 1m) + sum(col_int) from tb")
        tdSql.error("select timetruncate(ts, 1m) + sum(col_int) from ctb")
        tdSql.error("select timetruncate(ts, 1m) + sum(col_int) from stb")

        tdSql.error("select timetruncate(ts, 1m) + max(col_timestamp) from tb")
        tdSql.error("select timetruncate(ts, 1m) + max(col_timestamp) from ctb")
        tdSql.error("select timetruncate(ts, 1m) + max(col_timestamp) from stb")
        tdSql.error("select timetruncate(ts, 1m) + first(col_timestamp) from tb")
        tdSql.error("select timetruncate(ts, 1m) + first(col_timestamp) from ctb")
        tdSql.error("select timetruncate(ts, 1m) + first(col_timestamp) from stb")
        tdSql.error("select timetruncate(ts, 1m) + top(col_timestamp, 1) from tb")
        tdSql.error("select timetruncate(ts, 1m) + top(col_timestamp, 1) from ctb")
        tdSql.error("select timetruncate(ts, 1m) + top(col_timestamp, 1) from stb")

        tdSql.error("select timetruncate(ts, 1m) + ceil(col_float) from tb")
        tdSql.error("select timetruncate(ts, 1m) + ceil(col_float) from ctb")
        tdSql.error("select timetruncate(ts, 1m) + ceil(col_float) from stb")
        tdSql.error("select timetruncate(ts, 1m) + floor(col_int) from tb")
        tdSql.error("select timetruncate(ts, 1m) + floor(col_int) from ctb")
        tdSql.error("select timetruncate(ts, 1m) + floor(col_int) from stb")
        tdSql.error("select timetruncate(ts, 1m) + round(1.5) from tb")
        tdSql.error("select timetruncate(ts, 1m) + round(1.5) from ctb")
        tdSql.error("select timetruncate(ts, 1m) + round(1.5) from stb")
        tdSql.error("select timetruncate(ts, 1m) + diff(col_timestamp) from tb")
        tdSql.error("select timetruncate(ts, 1m) + diff(col_timestamp) from ctb")
        tdSql.error("select timetruncate(ts, 1m) + diff(col_timestamp) from stb")

        tdSql.error("select timetruncate(ts, 1m) + 1 from tb")
        tdSql.error("select timetruncate(ts, 1m) + 1 from ctb")
        tdSql.error("select timetruncate(ts, 1m) + 1 from stb")
        tdSql.error("select timetruncate(ts, 1m) + 1.5 from tb")
        tdSql.error("select timetruncate(ts, 1m) + 1.5 from ctb")
        tdSql.error("select timetruncate(ts, 1m) + 1.5 from stb")
        #tdSql.error("select timetruncate(ts, 1m) + true from tb")
        #tdSql.error("select timetruncate(ts, 1m) + true from ctb")
        #tdSql.error("select timetruncate(ts, 1m) + true from stb")
        tdSql.error("select timetruncate(ts, 1m) + 'abc' from tb")
        tdSql.error("select timetruncate(ts, 1m) + 'abc' from ctb")
        tdSql.error("select timetruncate(ts, 1m) + 'abc' from stb")
        tdSql.error("select timetruncate(ts, 1m) + abc from tb")
        tdSql.error("select timetruncate(ts, 1m) + abc from ctb")
        tdSql.error("select timetruncate(ts, 1m) + abc from stb")

        #tdSql.error("select timetruncate(ts, 1m) + ts from tb")
        #tdSql.error("select timetruncate(ts, 1m) + ts from ctb")
        #tdSql.error("select timetruncate(ts, 1m) + ts from stb")
        #tdSql.error("select timetruncate(ts, 1m) + col_timestamp from tb")
        #tdSql.error("select timetruncate(ts, 1m) + col_timestamp from ctb")
        #tdSql.error("select timetruncate(ts, 1m) + col_timestamp from stb")
        tdSql.error("select timetruncate(ts, 1m) + col_tinyint from tb")
        tdSql.error("select timetruncate(ts, 1m) + col_tinyint from ctb")
        tdSql.error("select timetruncate(ts, 1m) + col_tinyint from stb")
        tdSql.error("select timetruncate(ts, 1m) + col_smallint from tb")
        tdSql.error("select timetruncate(ts, 1m) + col_smallint from ctb")
        tdSql.error("select timetruncate(ts, 1m) + col_smallint from stb")
        tdSql.error("select timetruncate(ts, 1m) + col_int from tb")
        tdSql.error("select timetruncate(ts, 1m) + col_int from ctb")
        tdSql.error("select timetruncate(ts, 1m) + col_int from stb")
        tdSql.error("select timetruncate(ts, 1m) + col_bigint from tb")
        tdSql.error("select timetruncate(ts, 1m) + col_bigint from ctb")
        tdSql.error("select timetruncate(ts, 1m) + col_bigint from stb")
        tdSql.error("select timetruncate(ts, 1m) + col_bool from tb")
        tdSql.error("select timetruncate(ts, 1m) + col_bool from ctb")
        tdSql.error("select timetruncate(ts, 1m) + col_bool from stb")
        tdSql.error("select timetruncate(ts, 1m) + col_float from tb")
        tdSql.error("select timetruncate(ts, 1m) + col_float from ctb")
        tdSql.error("select timetruncate(ts, 1m) + col_float from stb")
        tdSql.error("select timetruncate(ts, 1m) + col_double from tb")
        tdSql.error("select timetruncate(ts, 1m) + col_double from ctb")
        tdSql.error("select timetruncate(ts, 1m) + col_double from stb")
        tdSql.error("select timetruncate(ts, 1m) + col_binary from tb")
        tdSql.error("select timetruncate(ts, 1m) + col_binary from ctb")
        tdSql.error("select timetruncate(ts, 1m) + col_binary from stb")
        tdSql.error("select timetruncate(ts, 1m) + col_nchar from tb")
        tdSql.error("select timetruncate(ts, 1m) + col_nchar from ctb")
        tdSql.error("select timetruncate(ts, 1m) + col_nchar from stb")

        tdSql.error("select timetruncate(ts, 1m) + tag_timestamp from tb")
        tdSql.error("select timetruncate(ts, 1m) + tag_timestamp from ctb")
        tdSql.error("select timetruncate(ts, 1m) + tag_timestamp from stb")
        tdSql.error("select timetruncate(ts, 1m) + tag_tinyint from tb")
        tdSql.error("select timetruncate(ts, 1m) + tag_tinyint from ctb")
        tdSql.error("select timetruncate(ts, 1m) + tag_tinyint from stb")
        tdSql.error("select timetruncate(ts, 1m) + tag_smallint from tb")
        tdSql.error("select timetruncate(ts, 1m) + tag_smallint from ctb")
        tdSql.error("select timetruncate(ts, 1m) + tag_smallint from stb")
        tdSql.error("select timetruncate(ts, 1m) + tag_int from tb")
        tdSql.error("select timetruncate(ts, 1m) + tag_int from ctb")
        tdSql.error("select timetruncate(ts, 1m) + tag_int from stb")
        tdSql.error("select timetruncate(ts, 1m) + tag_bigint from tb")
        tdSql.error("select timetruncate(ts, 1m) + tag_bigint from ctb")
        tdSql.error("select timetruncate(ts, 1m) + tag_bigint from stb")
        tdSql.error("select timetruncate(ts, 1m) + tag_bool from tb")
        tdSql.error("select timetruncate(ts, 1m) + tag_bool from ctb")
        tdSql.error("select timetruncate(ts, 1m) + tag_bool from stb")
        tdSql.error("select timetruncate(ts, 1m) + tag_float from tb")
        tdSql.error("select timetruncate(ts, 1m) + tag_float from ctb")
        tdSql.error("select timetruncate(ts, 1m) + tag_float from stb")
        tdSql.error("select timetruncate(ts, 1m) + tag_double from tb")
        tdSql.error("select timetruncate(ts, 1m) + tag_double from ctb")
        tdSql.error("select timetruncate(ts, 1m) + tag_double from stb")
        tdSql.error("select timetruncate(ts, 1m) + tag_binary from tb")
        tdSql.error("select timetruncate(ts, 1m) + tag_binary from ctb")
        tdSql.error("select timetruncate(ts, 1m) + tag_binary from stb")
        tdSql.error("select timetruncate(ts, 1m) + tag_nchar from tb")
        tdSql.error("select timetruncate(ts, 1m) + tag_nchar from ctb")
        tdSql.error("select timetruncate(ts, 1m) + tag_nchar from stb")

        tdSql.error("select timetruncate(ts, 1m) + 0.5b from tb")
        tdSql.error("select timetruncate(ts, 1m) + 0.5b from ctb")
        tdSql.error("select timetruncate(ts, 1m) + 0.5b from stb")
        tdSql.error("select timetruncate(ts, 1m) + 1.5u from tb")
        tdSql.error("select timetruncate(ts, 1m) + 1.5u from ctb")
        tdSql.error("select timetruncate(ts, 1m) + 1.5u from stb")
        tdSql.error("select timetruncate(ts, 1m) + 2.5a from tb")
        tdSql.error("select timetruncate(ts, 1m) + 2.5a from ctb")
        tdSql.error("select timetruncate(ts, 1m) + 2.5a from stb")
        tdSql.error("select timetruncate(ts, 1m) + 3.5s from tb")
        tdSql.error("select timetruncate(ts, 1m) + 3.5s from ctb")
        tdSql.error("select timetruncate(ts, 1m) + 3.5s from stb")
        tdSql.error("select timetruncate(ts, 1m) + 4.5m from tb")
        tdSql.error("select timetruncate(ts, 1m) + 4.5m from ctb")
        tdSql.error("select timetruncate(ts, 1m) + 4.5m from stb")
        tdSql.error("select timetruncate(ts, 1m) + 5.5h from tb")
        tdSql.error("select timetruncate(ts, 1m) + 5.5h from ctb")
        tdSql.error("select timetruncate(ts, 1m) + 5.5h from stb")
        tdSql.error("select timetruncate(ts, 1m) + 6.5d from tb")
        tdSql.error("select timetruncate(ts, 1m) + 6.5d from ctb")
        tdSql.error("select timetruncate(ts, 1m) + 6.5d from stb")
        tdSql.error("select timetruncate(ts, 1m) + 7.5w from tb")
        tdSql.error("select timetruncate(ts, 1m) + 7.5w from ctb")
        tdSql.error("select timetruncate(ts, 1m) + 7.5w from stb")

        tdSql.error("select timetruncate(ts, 1m) - 0.5b from tb")
        tdSql.error("select timetruncate(ts, 1m) - 0.5b from ctb")
        tdSql.error("select timetruncate(ts, 1m) - 0.5b from stb")
        tdSql.error("select timetruncate(ts, 1m) - 1.5u from tb")
        tdSql.error("select timetruncate(ts, 1m) - 1.5u from ctb")
        tdSql.error("select timetruncate(ts, 1m) - 1.5u from stb")
        tdSql.error("select timetruncate(ts, 1m) - 2.5a from tb")
        tdSql.error("select timetruncate(ts, 1m) - 2.5a from ctb")
        tdSql.error("select timetruncate(ts, 1m) - 2.5a from stb")
        tdSql.error("select timetruncate(ts, 1m) - 3.5s from tb")
        tdSql.error("select timetruncate(ts, 1m) - 3.5s from ctb")
        tdSql.error("select timetruncate(ts, 1m) - 3.5s from stb")
        tdSql.error("select timetruncate(ts, 1m) - 4.5m from tb")
        tdSql.error("select timetruncate(ts, 1m) - 4.5m from ctb")
        tdSql.error("select timetruncate(ts, 1m) - 4.5m from stb")
        tdSql.error("select timetruncate(ts, 1m) - 5.5h from tb")
        tdSql.error("select timetruncate(ts, 1m) - 5.5h from ctb")
        tdSql.error("select timetruncate(ts, 1m) - 5.5h from stb")
        tdSql.error("select timetruncate(ts, 1m) - 6.5d from tb")
        tdSql.error("select timetruncate(ts, 1m) - 6.5d from ctb")
        tdSql.error("select timetruncate(ts, 1m) - 6.5d from stb")
        tdSql.error("select timetruncate(ts, 1m) - 7.5w from tb")
        tdSql.error("select timetruncate(ts, 1m) - 7.5w from ctb")
        tdSql.error("select timetruncate(ts, 1m) - 7.5w from stb")

        tdSql.error("select timetruncate(ts, 1m) * 1d from tb")
        tdSql.error("select timetruncate(ts, 1m) * 1d from ctb")
        tdSql.error("select timetruncate(ts, 1m) * 1d from stb")
        tdSql.error("select timetruncate(ts, 1m) / 5m from tb")
        tdSql.error("select timetruncate(ts, 1m) / 5m from ctb")
        tdSql.error("select timetruncate(ts, 1m) / 5m from stb")
        tdSql.error("select timetruncate(ts, 1m) % 10h from tb")
        tdSql.error("select timetruncate(ts, 1m) % 10h from ctb")
        tdSql.error("select timetruncate(ts, 1m) % 10h from stb")
        tdSql.error("select timetruncate(ts, 1m) + 1a * 60b from tb")
        tdSql.error("select timetruncate(ts, 1m) + 1a * 60b from ctb")
        tdSql.error("select timetruncate(ts, 1m) + 1a * 60b from stb")
        tdSql.error("select timetruncate(ts, 1m) + 1s * 60 from tb")
        tdSql.error("select timetruncate(ts, 1m) + 1s * 60 from ctb")
        tdSql.error("select timetruncate(ts, 1m) + 1s * 60 from stb")

        #timetruncate(), func()
        tdSql.error("select timetruncate(ts, 1m),count(*) from tb")
        tdSql.error("select timetruncate(ts, 1m),count(*) from ctb")
        tdSql.error("select timetruncate(ts, 1m),count(*) from stb")
        tdSql.error("select timetruncate(ts, 1m),avg(col_timestamp) from tb")
        tdSql.error("select timetruncate(ts, 1m),avg(col_timestamp) from ctb")
        tdSql.error("select timetruncate(ts, 1m),avg(col_timestamp) from stb")
        tdSql.error("select timetruncate(ts, 1m),sum(col_int) from tb")
        tdSql.error("select timetruncate(ts, 1m),sum(col_int) from ctb")
        tdSql.error("select timetruncate(ts, 1m),sum(col_int) from stb")

        tdSql.error("select timetruncate(ts, 1m),max(col_timestamp) from tb")
        tdSql.error("select timetruncate(ts, 1m),max(col_timestamp) from ctb")
        tdSql.error("select timetruncate(ts, 1m),max(col_timestamp) from stb")
        tdSql.error("select timetruncate(ts, 1m),first(col_timestamp) from tb")
        tdSql.error("select timetruncate(ts, 1m),first(col_timestamp) from ctb")
        tdSql.error("select timetruncate(ts, 1m),first(col_timestamp) from stb")
        tdSql.error("select timetruncate(ts, 1m),top(col_timestamp, 1) from tb")
        tdSql.error("select timetruncate(ts, 1m),top(col_timestamp, 1) from ctb")
        tdSql.error("select timetruncate(ts, 1m),top(col_timestamp, 1) from stb")

        #session
        tdSql.error("select timetruncate(ts, 1m) from tb session(ts, 1d)")
        tdSql.error("select timetruncate(ts, 1m) from ctb session(ts, 1h)")
        tdSql.error("select timetruncate(ts, 1m) from stb session(ts, 1m)")

        #state_window
        tdSql.error('select timetruncate(ts, 1m) from tb state_window(col_timestamp);')
        tdSql.error('select timetruncate(ts, 1m) from tb state_window(col_tinyint);')
        tdSql.error('select timetruncate(ts, 1m) from tb state_window(col_smallint);')
        tdSql.error('select timetruncate(ts, 1m) from tb state_window(col_int);')
        tdSql.error('select timetruncate(ts, 1m) from tb state_window(col_bigint);')
        tdSql.error('select timetruncate(ts, 1m) from tb state_window(col_bool);')
        tdSql.error('select timetruncate(ts, 1m) from tb state_window(col_float);')
        tdSql.error('select timetruncate(ts, 1m) from tb state_window(col_double);')
        tdSql.error('select timetruncate(ts, 1m) from tb state_window(col_binary);')
        tdSql.error('select timetruncate(ts, 1m) from tb state_window(col_nchar);')

        #interval/sliding
        tdSql.error('select timetruncate(ts, 1m) from tb interval(1y)')
        tdSql.error('select timetruncate(ts, 1m) from tb interval(1n)')
        tdSql.error('select timetruncate(ts, 1m) from tb interval(1w)')
        tdSql.error('select timetruncate(ts, 1m) from tb interval(1d)')
        tdSql.error('select timetruncate(ts, 1m) from tb interval(1h)')
        tdSql.error('select timetruncate(ts, 1m) from tb interval(1s)')
        tdSql.error('select timetruncate(ts, 1m) from tb interval(1y) sliding(1y)')
        tdSql.error('select timetruncate(ts, 1m) from tb interval(1n) sliding(1n)')
        tdSql.error('select timetruncate(ts, 1m) from tb interval(1w) sliding(1w)')
        tdSql.error('select timetruncate(ts, 1m) from tb interval(1d) sliding(1d)')
        tdSql.error('select timetruncate(ts, 1m) from tb interval(1h) sliding(1h)')
        tdSql.error('select timetruncate(ts, 1m) from tb interval(1s) sliding(1s)')

        #group by
        tdSql.error('select timetruncate(ts, 1m) from stb group by ts;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by col_tinyint;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by col_smallint;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by col_int;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by col_bigint;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by col_bool;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by col_float;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by col_double;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by col_binary;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by col_nchar;')

        tdSql.error('select timetruncate(ts, 1m) from stb group by tag_tinyint;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by tag_smallint;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by tag_int;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by tag_bigint;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by tag_bool;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by tag_float;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by tag_double;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by tag_binary;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by tag_nchar;')

        tdSql.error('select timetruncate(ts, 1m) from stb group by tbname;')

        tdSql.error('select timetruncate(ts, 1m) from stb group by tag_tinyint,col_tinyint;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by tag_smallint,col_smallint;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by tag_int,col_int;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by tag_bigint,col_bigint;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by tag_bool,col_bool;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by tag_float,col_float;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by tag_double,col_double;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by tag_binary,col_binary;')
        tdSql.error('select timetruncate(ts, 1m) from stb group by tag_nchar,col_nchar;')

        #order by
        tdSql.error('select timetruncate(ts, 1m) from stb order by col_tinyint;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by col_tinyint desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by col_smallint;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by col_smallint desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by col_int;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by col_int desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by col_bigint;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by col_bigint desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by col_bool;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by col_bool desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by col_float;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by col_float desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by col_double;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by col_double desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by col_double;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by col_double desc;')

        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_timestamp;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_timestamp desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_tinyint;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_tinyint desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_smallint;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_smallint desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_int;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_int desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_bigint;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_bigint desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_bool;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_bool desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_float;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_float desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_double;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_double desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_double;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_double desc;')

        tdSql.error('select timetruncate(ts, 1m) from stb order by tbname;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tbname desc;')

        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_timestamp,col_timestamp;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_timestamp,col_timestamp desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_tinyint,col_timestamp;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_tinyint,col_timestamp desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_smallint,col_timestamp;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_smallint,col_timestamp desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_int,col_timestamp;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_int,col_timestamp desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_bigint,col_timestamp;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_bigint,col_timestamp desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_bool,col_timestamp;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_bool,col_timestamp desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_float,col_timestamp;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_float,col_timestamp desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_double,col_timestamp;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_double,col_timestamp desc;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_double,col_timestamp;')
        tdSql.error('select timetruncate(ts, 1m) from stb order by tag_double,col_timestamp desc;')

        tdSql.execute('drop database db_m')
        tdSql.execute('drop database db_u')
        tdSql.execute('drop database db_n')

    def stop(self):
        tdSql.close()
        tdLog.success("%s successfully executed" % __file__)


tdCases.addWindows(__file__, TDTestCase())
tdCases.addLinux(__file__, TDTestCase())
