/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 441
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EFillMode yy18;
  EOperatorType yy128;
  bool yy173;
  SNodeList* yy334;
  int8_t yy341;
  int64_t yy459;
  ENullOrder yy487;
  SAlterOption yy515;
  EJoinType yy540;
  SNode* yy560;
  SDataType yy574;
  EOrder yy596;
  SToken yy659;
  int32_t yy676;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             679
#define YYNRULE              509
#define YYNTOKEN             313
#define YY_MAX_SHIFT         678
#define YY_MIN_SHIFTREDUCE   1000
#define YY_MAX_SHIFTREDUCE   1508
#define YY_ERROR_ACTION      1509
#define YY_ACCEPT_ACTION     1510
#define YY_NO_ACTION         1511
#define YY_MIN_REDUCE        1512
#define YY_MAX_REDUCE        2020
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2662)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   530,  556, 1760,  530,  435, 1829,  436, 1547,   32,  258,
 /*    10 */  1843,  117,   42,   40,  117, 1996, 1825, 1033,  473, 1646,
 /*    20 */   339,  478, 1296,   41,   39,   38,   37,   36, 1657, 1323,
 /*    30 */  1991, 1657, 1323, 1374, 1577, 1294,  571,  571, 1861, 1648,
 /*    40 */  1821, 1827,  327,  555,  166, 1510,  572,  325, 1992,  557,
 /*    50 */  1825, 1811, 1642,  584,  578,  150, 1369, 1037, 1038,  571,
 /*    60 */   443,   16,  436, 1547, 1659, 1861,   60, 1843, 1302,   42,
 /*    70 */    40, 1444,  440,  550, 1821, 1827, 1875,  339, 1319, 1296,
 /*    80 */    95, 1841, 1842, 1844,  588, 1846, 1847,  583,  578,  578,
 /*    90 */  1374,  530, 1294,    1,  163, 1861, 1928,  384,  485,  484,
 /*   100 */   332, 1924,   50,  572,  354,  124, 1498,   56, 1811,   44,
 /*   110 */   584,  549,  152, 1369, 1524,  675,  480,  483,   16, 1657,
 /*   120 */   513, 1955,  479,  344, 1829, 1302, 1702, 1704,  452, 1376,
 /*   130 */  1377,  212,   44, 1875,  301, 1825, 1996,   95, 1841, 1842,
 /*   140 */  1844,  588, 1846, 1847,  583, 1830,  578, 1703, 1704, 1991,
 /*   150 */     1,  163,   45, 1928, 1843,   56, 1825,  332, 1924, 1821,
 /*   160 */  1827,  333, 1997,  166,  532, 1991, 1900, 1992,  557, 1709,
 /*   170 */   168,  257,  675,  578,  257, 1297,  326, 1295, 1954, 1995,
 /*   180 */  1821, 1827, 1861, 1992, 1994, 1707, 1376, 1377,   77,  303,
 /*   190 */   585, 1322,  520,  568,  578, 1811,  154,  584, 1300, 1301,
 /*   200 */  1616, 1351, 1352, 1354, 1355, 1356, 1357, 1358, 1359,  580,
 /*   210 */   576, 1367, 1368, 1370, 1371, 1372, 1373, 1375, 1378,    3,
 /*   220 */  1875,  130,  162,  621,   95, 1841, 1842, 1844,  588, 1846,
 /*   230 */  1847,  583, 1297,  578, 1295, 1696,  127,  169,  137, 1899,
 /*   240 */  1928, 1465,   35,   34,  332, 1924,   41,   39,   38,   37,
 /*   250 */    36,  169, 1050,  169, 1049, 1300, 1301,  128, 1351, 1352,
 /*   260 */  1354, 1355, 1356, 1357, 1358, 1359,  580,  576, 1367, 1368,
 /*   270 */  1370, 1371, 1372, 1373, 1375, 1378,    3,   42,   40,  165,
 /*   280 */  1936, 1937, 1051, 1941,   11,  339, 1321, 1296, 1322,  543,
 /*   290 */  1463, 1464, 1466, 1467,  434, 1843,  169,  438, 1374,  169,
 /*   300 */  1294,   56, 1151,  610,  609,  608, 1155,  607, 1157, 1158,
 /*   310 */   606, 1160,  603,  568, 1166,  600, 1168, 1169,  597,  594,
 /*   320 */   421, 1369,   11, 1861,    9,  219,   16, 1635, 1475,  225,
 /*   330 */   226,  585,  530, 1302,   42,   40, 1811,  613,  584,  546,
 /*   340 */  1709,  130,  339,  171, 1296,   35,   34,  343, 1535,   41,
 /*   350 */    39,   38,   37,   36, 1324, 1374, 1707, 1294,    1,   56,
 /*   360 */  1657, 1875,   56, 1113,   79,   95, 1841, 1842, 1844,  588,
 /*   370 */  1846, 1847,  583,  373,  578,  179,  178,  119, 1369, 1903,
 /*   380 */   675, 1928,  377,   16,  376,  332, 1924,  452,  303, 1811,
 /*   390 */  1302,  520,  375,  371, 1376, 1377, 1115, 1193, 1194,  255,
 /*   400 */  1936,  567, 1513,  566,   35,   34, 1991,  530,   41,   39,
 /*   410 */    38,   37,   36,  442,  617,    1,  438, 1700,  382,  555,
 /*   420 */   166,  552,  547,  107, 1992,  557,  106,  105,  104,  103,
 /*   430 */   102,  101,  100,   99,   98, 1657,  517,  675, 1633,   24,
 /*   440 */  1297, 1448, 1295,  324,   85,  169, 1757, 1321, 1534, 1302,
 /*   450 */   107, 1376, 1377,  106,  105,  104,  103,  102,  101,  100,
 /*   460 */    99,   98, 1321, 1300, 1301, 1650, 1351, 1352, 1354, 1355,
 /*   470 */  1356, 1357, 1358, 1359,  580,  576, 1367, 1368, 1370, 1371,
 /*   480 */  1372, 1373, 1375, 1378,    3, 1512,   11,   35,   34, 1811,
 /*   490 */   530,   41,   39,   38,   37,   36,  234, 1297,  621, 1295,
 /*   500 */  1995,  383,  126,  169, 1505, 1899,  169,  315,  633,  116,
 /*   510 */   115,  114,  113,  112,  111,  110,  109,  108, 1657, 1943,
 /*   520 */  1300, 1301,  551, 1351, 1352, 1354, 1355, 1356, 1357, 1358,
 /*   530 */  1359,  580,  576, 1367, 1368, 1370, 1371, 1372, 1373, 1375,
 /*   540 */  1378,    3,   42,   40, 1709,  224, 1296,  342, 1940, 1644,
 /*   550 */   339,  310, 1296,  482,  481,  150,  563,   75,   75, 1294,
 /*   560 */  1707,  568,  198, 1374, 1659, 1294,  316,  530,  314,  313,
 /*   570 */   123,  475, 1050, 1455, 1049,  477,  156, 1533,  391, 1652,
 /*   580 */  1653,  469,  465,  461,  457,  197, 1369,  471,  556,  130,
 /*   590 */    92, 1843, 1302,  619, 1320, 1657, 1504,  476, 1302,   42,
 /*   600 */    40, 1379, 1051,  125, 1943, 1276, 1277,  339, 1640, 1296,
 /*   610 */   568, 1649,  141,  140,  616,  615,  614, 1991, 1811, 1861,
 /*   620 */  1374,   76, 1294,    8,  195,  128,  530,  585,  215, 1353,
 /*   630 */   555,  166, 1811, 1939,  584, 1992,  557,  406,  130,  675,
 /*   640 */   175,  530, 1532, 1369, 1384,  675,  570,  164, 1936, 1937,
 /*   650 */  1321, 1941,  407,  579, 1657, 1302, 1709, 1875,  499, 1376,
 /*   660 */  1377,   95, 1841, 1842, 1844,  588, 1846, 1847,  583, 1657,
 /*   670 */   578,  497, 1708,  495,  128, 2011,   72, 1928,  530,   71,
 /*   680 */     8,  332, 1924, 1811, 1843,  485,  484,  194,  188,  450,
 /*   690 */   193, 1962,  124,  534,  448, 1900,  167, 1936, 1937, 1297,
 /*   700 */  1941, 1295,  675,  480,  483, 1297, 1657, 1295, 1750,  479,
 /*   710 */   186, 1531, 1861,   38,   37,   36, 1376, 1377, 1634,  174,
 /*   720 */   585,  150, 1300, 1301, 1530, 1811,  508,  584, 1300, 1301,
 /*   730 */  1660, 1351, 1352, 1354, 1355, 1356, 1357, 1358, 1359,  580,
 /*   740 */   576, 1367, 1368, 1370, 1371, 1372, 1373, 1375, 1378,    3,
 /*   750 */  1875,  559, 1811, 1943,   95, 1841, 1842, 1844,  588, 1846,
 /*   760 */  1847,  583, 1297,  578, 1295, 1811,   28,  169, 1901, 1529,
 /*   770 */  1928,  564,   35,   34,  332, 1924,   41,   39,   38,   37,
 /*   780 */    36, 1528, 1938, 1843, 1527, 1300, 1301,    7, 1351, 1352,
 /*   790 */  1354, 1355, 1356, 1357, 1358, 1359,  580,  576, 1367, 1368,
 /*   800 */  1370, 1371, 1372, 1373, 1375, 1378,    3,   42,   40, 1526,
 /*   810 */  1811, 1861,  345,  646,  644,  339,  322, 1296,  618,  585,
 /*   820 */   150, 1700, 1811,  619, 1811, 1811,  584,   30, 1374, 1659,
 /*   830 */  1294,  378, 1353,   35,   34, 1037, 1038,   41,   39,   38,
 /*   840 */    37,   36,  141,  140,  616,  615,  614,  513, 1321, 1875,
 /*   850 */  1811, 1369, 1523,  292, 1841, 1842, 1844,  588, 1846, 1847,
 /*   860 */   583,  218,  578, 1302,   42,   40, 1750,  612, 1756,  517,
 /*   870 */   298,  530,  339, 1755, 1296,  298, 1991,  177,  678, 1758,
 /*   880 */  1522,  634,  451, 1629, 1525, 1374, 1405, 1294,    8, 1997,
 /*   890 */   166,  252,  265, 1811, 1992,  557, 1617,   35,   34, 1657,
 /*   900 */    78,   41,   39,   38,   37,   36,  160,  530, 1369,  477,
 /*   910 */   675,  668,  664,  660,  656,  263,  516, 1521, 1654, 1077,
 /*   920 */  1302, 1811,   35,   34, 1376, 1377,   41,   39,   38,   37,
 /*   930 */    36,  476,  513,   35,   34, 1657,   91,   41,   39,   38,
 /*   940 */    37,   36,   13,   12,  270,    1,   88, 1687,  530,  530,
 /*   950 */   306,   93, 1078,   29,  232,  530, 1305,  530, 1811,  502,
 /*   960 */   509, 1991,  530, 1410,   46,    4,  514,  675,  229, 1441,
 /*   970 */  1297,  139, 1295,  526, 1997,  166, 1657, 1657, 1520, 1992,
 /*   980 */   557, 1376, 1377, 1657, 1437, 1657,  544,  527, 1948, 1437,
 /*   990 */  1657, 1403, 1519, 1300, 1301, 1564, 1351, 1352, 1354, 1355,
 /*  1000 */  1356, 1357, 1358, 1359,  580,  576, 1367, 1368, 1370, 1371,
 /*  1010 */  1372, 1373, 1375, 1378,    3,  530,  300,  486, 1319, 1811,
 /*  1020 */   221,  385,   49,   48,  512,  414,  528, 1297,  426, 1295,
 /*  1030 */  1353, 1518, 1798, 1811,  386, 1417,  352, 1517, 1270, 1516,
 /*  1040 */   214,  203, 1515, 1657,  201,  399, 1404,  427, 1862,  401,
 /*  1050 */  1300, 1301,  513, 1351, 1352, 1354, 1355, 1356, 1357, 1358,
 /*  1060 */  1359,  580,  576, 1367, 1368, 1370, 1371, 1372, 1373, 1375,
 /*  1070 */  1378,    3, 1811,  530,  205, 1559,  149,  204, 1811,  361,
 /*  1080 */  1811, 1991,  530, 1811,  529,  207,  151,  560,  206, 1557,
 /*  1090 */   392,  276, 1632,  259, 1997,  166,  575,  488, 1308, 1992,
 /*  1100 */   557, 1657,  388, 1574,  209,  274,   64,  208,   43,   63,
 /*  1110 */  1657,  491,  223,   31,  336, 1398, 1399, 1400, 1401, 1402,
 /*  1120 */  1406, 1407, 1408, 1409,  470,  182,  431,  429,   13,   12,
 /*  1130 */   425, 1507, 1508,  420,  419,  418,  417,  416,  413,  412,
 /*  1140 */   411,  410,  409,  405,  404,  403,  402,  396,  395,  394,
 /*  1150 */   393,  246,  390,  389,  312,  134, 1996,  350,  138, 1247,
 /*  1160 */   139,   56, 1548,  227,   58, 1996,  652,  651,  650,  649,
 /*  1170 */   349,  238,  648,  647,  131,  642,  641,  640,  639,  638,
 /*  1180 */   637,  636,  635,  143,  631,  630,  629,  348,  347,  626,
 /*  1190 */   625,  624,  623,  622, 1991, 1304,  530,  619,   58,   94,
 /*  1200 */  1697, 1958, 1843, 1440,   43, 1832,  523,  346, 1995,  231,
 /*  1210 */   627, 1144, 1992, 1993,  254, 1462,  141,  140,  616,  615,
 /*  1220 */   614, 1553,  241,  569, 1657,  251,  628,    2,    5,   43,
 /*  1230 */  1861,  592, 1097, 1395,  355,   69,   68,  381,  585,  138,
 /*  1240 */   173,  360,  490, 1811,  311,  584,  139, 1498, 1095, 1411,
 /*  1250 */   120,  351, 1834,  138, 1263, 1360,  299,  500,  176,  369,
 /*  1260 */   387,  367,  363,  359,  356,  353,  266,  513, 1875,  670,
 /*  1270 */  1319,  211,   96,  586,  338, 1844,  588, 1846, 1847,  583,
 /*  1280 */   269,  578, 1172,  501, 1843,  493,  408, 1752, 1928,  487,
 /*  1290 */  1176,  415,  305, 1924,  210,  423, 1991, 1183,  422,  513,
 /*  1300 */   561, 1181,  424, 1991,  142,  169,  428,  430,  432, 1997,
 /*  1310 */   166, 1325, 1861, 1327, 1992,  557,  555,  166,  433,  441,
 /*  1320 */   585, 1992,  557,  444,  185, 1811,  445,  584, 1991, 1326,
 /*  1330 */    62,  187,  446,   61, 1328,  449,  190, 1307,  192,  447,
 /*  1340 */    73, 1997,  166,   74, 1843,  453, 1992,  557,  196,  472,
 /*  1350 */  1875, 1791,  267,  474,   95, 1841, 1842, 1844,  588, 1846,
 /*  1360 */  1847,  583, 1647,  578,  118,  302, 1843,  200, 2011, 1643,
 /*  1370 */  1928,  202, 1861,  144,  332, 1924,  507,  145, 1645,  213,
 /*  1380 */   585, 1641,  146,  147, 1985, 1811,  503,  584,  504,  216,
 /*  1390 */   510,  515,  542,  321, 1861,  524,  220,  135,  518, 1790,
 /*  1400 */  1762,  525,  585,  521,   82,  323,   84, 1811, 1658,  584,
 /*  1410 */  1875,  268,  136, 1324,   95, 1841, 1842, 1844,  588, 1846,
 /*  1420 */  1847,  583, 1843,  578,  545,  236,  240, 1969, 2011,  538,
 /*  1430 */  1928,  540, 1875,  541,  332, 1924,  285,  586,  338, 1844,
 /*  1440 */   588, 1846, 1847,  583, 1947,  578, 1959,  335,  334, 1968,
 /*  1450 */  1861,  328,  548,    6,  554,  536,  537, 1310,  585,  250,
 /*  1460 */   329,  539,  565, 1811, 2014,  584,  562, 1991, 1374, 1437,
 /*  1470 */  1303,  129, 1323,   55,  247, 1950,  245,  157,  248,   86,
 /*  1480 */   555,  166,  249, 1843, 1944, 1992,  557, 1909, 1875, 1990,
 /*  1490 */   590, 1369,   95, 1841, 1842, 1844,  588, 1846, 1847,  583,
 /*  1500 */  1701,  578, 1630, 1302,  271, 1843,  533,  262, 1928,  671,
 /*  1510 */   253, 1861,  332, 1924,  672,   47,  674,  297,  273,  585,
 /*  1520 */   283,  294,  293,  275, 1811, 1805,  584,   66, 1803, 1802,
 /*  1530 */    67, 1799,  357, 1861, 1804,  358, 1288, 1289,  172,  362,
 /*  1540 */  1797,  585,  364,  365,  366, 1796, 1811,  368,  584, 1875,
 /*  1550 */   574, 1795,  370,   96, 1841, 1842, 1844,  588, 1846, 1847,
 /*  1560 */   583, 1794,  578,  372, 1793,  374, 1266, 1265, 1773, 1928,
 /*  1570 */  1772, 1875,  379, 1927, 1924,   96, 1841, 1842, 1844,  588,
 /*  1580 */  1846, 1847,  583,  380,  578, 1771, 1770, 1745, 1235, 1843,
 /*  1590 */  1744, 1928, 1743, 1742,  132,  573, 1924, 1741, 1740,   70,
 /*  1600 */  1739, 1738, 1737, 1736, 1735,  397,  398, 1734,  400, 1733,
 /*  1610 */  1311, 1732, 1306, 1731, 1730, 1729, 1728, 1861, 1727, 1726,
 /*  1620 */  1725, 1724, 1723, 1722, 1721,  582, 1720, 1719, 1718, 1717,
 /*  1630 */  1811,  133,  584, 1314, 1316, 1716, 1715, 1714, 1713, 1237,
 /*  1640 */  1712, 1711, 1710, 1579, 1843,  576, 1367, 1368, 1370, 1371,
 /*  1650 */  1372, 1373, 1578, 1576, 1544, 1875,  437, 1543, 1040,  291,
 /*  1660 */  1841, 1842, 1844,  588, 1846, 1847,  583,  581,  578,  531,
 /*  1670 */  1893,  121, 1861,  183,  184, 1039,  161, 1786,  122, 1780,
 /*  1680 */   585,  180, 1769, 1768,  191, 1811,  181,  584,  189, 1754,
 /*  1690 */  1636,  439, 1575, 1573,  454,  455, 1571, 1843,  458, 1569,
 /*  1700 */   462,  456,  459,  460, 1567,  463,  464,  466,  468, 1070,
 /*  1710 */  1875, 1556, 1555,  467,  153, 1841, 1842, 1844,  588, 1846,
 /*  1720 */  1847,  583, 1540,  578, 1638, 1861, 1187, 1186, 1637, 1112,
 /*  1730 */  1111,  643, 1108,  585, 1565, 1107, 1106, 1560, 1811,  317,
 /*  1740 */   584,  645,  318, 1558,  492,  319, 1539, 1538,  494, 1843,
 /*  1750 */   489,  199,   57,  496, 1537,  498,   97, 1785, 1779,  148,
 /*  1760 */  1272, 1843,  505, 1875,  217,  558, 2012,   96, 1841, 1842,
 /*  1770 */  1844,  588, 1846, 1847,  583, 1843,  578, 1861, 1767, 1765,
 /*  1780 */  1996, 1766, 1764, 1928, 1763,  582, 1280, 1761, 1925, 1861,
 /*  1790 */  1811, 1753,  584,  519,  535,   81,   17,  585,  233, 1386,
 /*  1800 */    10,  222, 1811, 1861,  584,   18,   43,   19, 1385,  228,
 /*  1810 */   244,  585,   80,   88,  230, 1875, 1811,   54,  584,  291,
 /*  1820 */  1841, 1842, 1844,  588, 1846, 1847,  583, 1875,  578, 1843,
 /*  1830 */  1894,  292, 1841, 1842, 1844,  588, 1846, 1847,  583,  511,
 /*  1840 */   578, 1875,   51, 1843,  522,  287, 1841, 1842, 1844,  588,
 /*  1850 */  1846, 1847,  583,   83,  578, 1477,  243, 1861,   25,  235,
 /*  1860 */  1832,   27,  237, 1459,  506,  585,  239,   59,  320, 1461,
 /*  1870 */  1811, 1861,  584,  155,   21, 1492,  337, 1454,  242,  585,
 /*  1880 */  1497,   26,   87, 1491, 1811,  330,  584, 1496,  553, 1498,
 /*  1890 */  1495,  331, 1434, 1843, 1433, 1875,   53,  256,   12,  153,
 /*  1900 */  1841, 1842, 1844,  588, 1846, 1847,  583, 1831,  578, 1875,
 /*  1910 */  1312,   20, 1843,  292, 1841, 1842, 1844,  588, 1846, 1847,
 /*  1920 */   583, 1861,  578,  158, 1396, 1878,  340,   15, 1364,  585,
 /*  1930 */   577,  159, 1362, 1361, 1811,   33,  584,   14,   22,  170,
 /*  1940 */  1861, 1336, 1344,   52,  587,  589,  591,   23,  585,  341,
 /*  1950 */   593, 2013, 1173, 1811, 1170,  584,  595, 1167,  596, 1875,
 /*  1960 */   598,  599, 1843,  292, 1841, 1842, 1844,  588, 1846, 1847,
 /*  1970 */   583,  601,  578, 1161,  602,  604, 1843, 1159, 1875,  605,
 /*  1980 */  1150, 1182,  277, 1841, 1842, 1844,  588, 1846, 1847,  583,
 /*  1990 */  1861,  578, 1165, 1164,  611, 1163,   89, 1162,  585,   90,
 /*  2000 */    65, 1178,  260, 1811, 1861,  584, 1068, 1103,  620, 1102,
 /*  2010 */  1101, 1100,  585, 1099,  632, 1098, 1096, 1811, 1094,  584,
 /*  2020 */  1093, 1092, 1119, 1090, 1089,  261, 1088, 1087, 1875, 1086,
 /*  2030 */  1085, 1843,  278, 1841, 1842, 1844,  588, 1846, 1847,  583,
 /*  2040 */  1084,  578, 1875, 1083, 1114, 1116,  279, 1841, 1842, 1844,
 /*  2050 */   588, 1846, 1847,  583, 1080,  578, 1079, 1843, 1076, 1861,
 /*  2060 */  1075, 1074, 1073, 1572,  653,  655, 1570,  585,  657,  654,
 /*  2070 */   659,  658, 1811, 1568,  584,  661,  663,  662, 1566,  665,
 /*  2080 */   667,  666, 1554, 1843,  669, 1861, 1030, 1536,  677,  264,
 /*  2090 */   673, 1511, 1298,  585,  272,  676, 1511, 1875, 1811, 1511,
 /*  2100 */   584,  286, 1841, 1842, 1844,  588, 1846, 1847,  583, 1843,
 /*  2110 */   578, 1861, 1511, 1511, 1511, 1511, 1511, 1511, 1511,  585,
 /*  2120 */  1511, 1511, 1511, 1875, 1811, 1511,  584,  288, 1841, 1842,
 /*  2130 */  1844,  588, 1846, 1847,  583, 1843,  578, 1861, 1511, 1511,
 /*  2140 */  1511, 1511, 1511, 1511, 1511,  585, 1511, 1511, 1511, 1875,
 /*  2150 */  1811, 1511,  584,  280, 1841, 1842, 1844,  588, 1846, 1847,
 /*  2160 */   583, 1511,  578, 1861, 1511, 1511, 1511, 1511, 1511, 1511,
 /*  2170 */  1511,  585, 1511, 1511, 1511, 1875, 1811, 1511,  584,  289,
 /*  2180 */  1841, 1842, 1844,  588, 1846, 1847,  583, 1843,  578, 1511,
 /*  2190 */  1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
 /*  2200 */  1511, 1875, 1511, 1843, 1511,  281, 1841, 1842, 1844,  588,
 /*  2210 */  1846, 1847,  583, 1511,  578, 1861, 1511, 1511, 1511, 1511,
 /*  2220 */  1511, 1511, 1511,  585, 1511, 1511, 1511, 1511, 1811, 1511,
 /*  2230 */   584, 1861, 1511, 1511, 1511, 1511, 1511, 1511, 1511,  585,
 /*  2240 */  1511, 1511, 1511, 1511, 1811, 1511,  584, 1511, 1511, 1511,
 /*  2250 */  1511, 1511, 1511, 1875, 1511, 1511, 1511,  290, 1841, 1842,
 /*  2260 */  1844,  588, 1846, 1847,  583, 1843,  578, 1511, 1511, 1875,
 /*  2270 */  1511, 1511, 1511,  282, 1841, 1842, 1844,  588, 1846, 1847,
 /*  2280 */   583, 1843,  578, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
 /*  2290 */  1511, 1511, 1511, 1861, 1511, 1511, 1511, 1511, 1511, 1511,
 /*  2300 */  1511,  585, 1511, 1511, 1511, 1511, 1811, 1511,  584, 1861,
 /*  2310 */  1511, 1511, 1511, 1511, 1511, 1511, 1511,  585, 1511, 1511,
 /*  2320 */  1511, 1511, 1811, 1511,  584, 1511, 1511, 1511, 1511, 1511,
 /*  2330 */  1511, 1875, 1511, 1511, 1843,  295, 1841, 1842, 1844,  588,
 /*  2340 */  1846, 1847,  583, 1511,  578, 1511, 1511, 1875, 1843, 1511,
 /*  2350 */  1511,  296, 1841, 1842, 1844,  588, 1846, 1847,  583, 1511,
 /*  2360 */   578, 1511, 1861, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
 /*  2370 */   585, 1511, 1511, 1511, 1511, 1811, 1861,  584, 1511, 1511,
 /*  2380 */  1511, 1511, 1511, 1511,  585, 1511, 1511, 1511, 1511, 1811,
 /*  2390 */  1511,  584, 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
 /*  2400 */  1875, 1511, 1843, 1511, 1855, 1841, 1842, 1844,  588, 1846,
 /*  2410 */  1847,  583, 1511,  578, 1875, 1511, 1511, 1511, 1854, 1841,
 /*  2420 */  1842, 1844,  588, 1846, 1847,  583, 1843,  578, 1511, 1511,
 /*  2430 */  1861, 1511, 1511, 1511, 1511, 1511, 1511, 1511,  585, 1511,
 /*  2440 */  1511, 1511, 1511, 1811, 1511,  584, 1511, 1511, 1511, 1511,
 /*  2450 */  1511, 1511, 1843, 1511, 1861, 1511, 1511, 1511, 1511, 1511,
 /*  2460 */  1511, 1511,  585, 1511, 1511, 1511, 1511, 1811, 1875,  584,
 /*  2470 */  1511, 1511, 1853, 1841, 1842, 1844,  588, 1846, 1847,  583,
 /*  2480 */  1861,  578, 1511, 1511, 1511, 1511, 1511, 1511,  585, 1511,
 /*  2490 */  1511, 1511, 1875, 1811, 1511,  584,  307, 1841, 1842, 1844,
 /*  2500 */   588, 1846, 1847,  583, 1843,  578, 1511, 1511, 1511, 1511,
 /*  2510 */  1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1875, 1511,
 /*  2520 */  1843, 1511,  308, 1841, 1842, 1844,  588, 1846, 1847,  583,
 /*  2530 */  1511,  578, 1861, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
 /*  2540 */   585, 1511, 1511, 1511, 1511, 1811, 1511,  584, 1861, 1511,
 /*  2550 */  1511, 1511, 1511, 1511, 1511, 1511,  585, 1511, 1511, 1511,
 /*  2560 */  1511, 1811, 1511,  584, 1511, 1511, 1511, 1511, 1511, 1511,
 /*  2570 */  1875, 1511, 1511, 1511,  304, 1841, 1842, 1844,  588, 1846,
 /*  2580 */  1847,  583, 1843,  578, 1511, 1511, 1875, 1511, 1511, 1511,
 /*  2590 */   309, 1841, 1842, 1844,  588, 1846, 1847,  583, 1511,  578,
 /*  2600 */  1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
 /*  2610 */  1861, 1511, 1511, 1511, 1511, 1511, 1511, 1511,  585, 1511,
 /*  2620 */  1511, 1511, 1511, 1811, 1511,  584, 1511, 1511, 1511, 1511,
 /*  2630 */  1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
 /*  2640 */  1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1875, 1511,
 /*  2650 */  1511, 1511,  284, 1841, 1842, 1844,  588, 1846, 1847,  583,
 /*  2660 */  1511,  578,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   324,  388,    0,  324,  320,  346,  322,  323,  403,  404,
 /*    10 */   316,  335,   12,   13,  335,    3,  357,    4,  342,  345,
 /*    20 */    20,  342,   22,   12,   13,   14,   15,   16,  352,   20,
 /*    30 */   417,  352,   20,   33,    0,   35,   20,   20,  344,  346,
 /*    40 */   381,  382,  383,  430,  431,  313,  352,  336,  435,  436,
 /*    50 */   357,  357,  345,  359,  395,  344,   56,   44,   45,   20,
 /*    60 */   320,   61,  322,  323,  353,  344,    4,  316,   68,   12,
 /*    70 */    13,   14,   14,  352,  381,  382,  382,   20,   20,   22,
 /*    80 */   386,  387,  388,  389,  390,  391,  392,  393,  395,  395,
 /*    90 */    33,  324,   35,   93,  400,  344,  402,  324,   64,   65,
 /*   100 */   406,  407,  335,  352,  372,   71,   94,   93,  357,   93,
 /*   110 */   359,  390,  315,   56,  317,  115,   82,   83,   61,  352,
 /*   120 */   388,  427,   88,  355,  346,   68,  358,  359,   60,  129,
 /*   130 */   130,  125,   93,  382,  361,  357,  388,  386,  387,  388,
 /*   140 */   389,  390,  391,  392,  393,  346,  395,  358,  359,  417,
 /*   150 */    93,  400,   93,  402,  316,   93,  357,  406,  407,  381,
 /*   160 */   382,  383,  430,  431,  399,  417,  401,  435,  436,  344,
 /*   170 */   419,  162,  115,  395,  162,  175,  351,  177,  427,  431,
 /*   180 */   381,  382,  344,  435,  436,  360,  129,  130,  182,  183,
 /*   190 */   352,   20,  186,  324,  395,  357,  329,  359,  198,  199,
 /*   200 */   333,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   382,  352,  343,   60,  386,  387,  388,  389,  390,  391,
 /*   230 */   392,  393,  175,  395,  177,  356,  398,  237,  400,  401,
 /*   240 */   402,  198,    8,    9,  406,  407,   12,   13,   14,   15,
 /*   250 */    16,  237,   20,  237,   22,  198,  199,  388,  201,  202,
 /*   260 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*   270 */   213,  214,  215,  216,  217,  218,  219,   12,   13,  410,
 /*   280 */   411,  412,   50,  414,  221,   20,   20,   22,   20,  246,
 /*   290 */   247,  248,  249,  250,  321,  316,  237,  324,   33,  237,
 /*   300 */    35,   93,  106,  107,  108,  109,  110,  111,  112,  113,
 /*   310 */   114,  115,  116,  324,  118,  119,  120,  121,  122,  123,
 /*   320 */    78,   56,  221,  344,  223,   56,   61,    0,   94,  124,
 /*   330 */   125,  352,  324,   68,   12,   13,  357,  104,  359,  160,
 /*   340 */   344,  352,   20,  335,   22,    8,    9,  351,  316,   12,
 /*   350 */    13,   14,   15,   16,   20,   33,  360,   35,   93,   93,
 /*   360 */   352,  382,   93,   35,   95,  386,  387,  388,  389,  390,
 /*   370 */   391,  392,  393,  170,  395,  133,  134,  388,   56,  400,
 /*   380 */   115,  402,  174,   61,  176,  406,  407,   60,  183,  357,
 /*   390 */    68,  186,  189,  190,  129,  130,   68,  129,  130,  410,
 /*   400 */   411,  412,    0,  414,    8,    9,  417,  324,   12,   13,
 /*   410 */    14,   15,   16,  321,  354,   93,  324,  357,  335,  430,
 /*   420 */   431,  242,  243,   21,  435,  436,   24,   25,   26,   27,
 /*   430 */    28,   29,   30,   31,   32,  352,  359,  115,    0,   43,
 /*   440 */   175,   14,  177,  366,  326,  237,  369,   20,  316,   68,
 /*   450 */    21,  129,  130,   24,   25,   26,   27,   28,   29,   30,
 /*   460 */    31,   32,   20,  198,  199,  347,  201,  202,  203,  204,
 /*   470 */   205,  206,  207,  208,  209,  210,  211,  212,  213,  214,
 /*   480 */   215,  216,  217,  218,  219,    0,  221,    8,    9,  357,
 /*   490 */   324,   12,   13,   14,   15,   16,  162,  175,   60,  177,
 /*   500 */     3,  335,  398,  237,  167,  401,  237,   37,   68,   24,
 /*   510 */    25,   26,   27,   28,   29,   30,   31,   32,  352,  384,
 /*   520 */   198,  199,   20,  201,  202,  203,  204,  205,  206,  207,
 /*   530 */   208,  209,  210,  211,  212,  213,  214,  215,  216,  217,
 /*   540 */   218,  219,   12,   13,  344,  124,   22,  336,  413,  345,
 /*   550 */    20,  351,   22,  330,  331,  344,   43,  328,  328,   35,
 /*   560 */   360,  324,   33,   33,  353,   35,   96,  324,   98,   99,
 /*   570 */   341,  101,   20,   94,   22,  105,   47,  316,  335,  350,
 /*   580 */   350,   52,   53,   54,   55,   56,   56,   35,  388,  352,
 /*   590 */   326,  316,   68,  105,   20,  352,  259,  127,   68,   12,
 /*   600 */    13,   14,   50,  339,  384,  184,  185,   20,  345,   22,
 /*   610 */   324,  347,  124,  125,  126,  127,  128,  417,  357,  344,
 /*   620 */    33,   92,   35,   93,   95,  388,  324,  352,  345,  202,
 /*   630 */   430,  431,  357,  413,  359,  435,  436,  335,  352,  115,
 /*   640 */    56,  324,  316,   56,   14,  115,  409,  410,  411,  412,
 /*   650 */    20,  414,  335,  345,  352,   68,  344,  382,   21,  129,
 /*   660 */   130,  386,  387,  388,  389,  390,  391,  392,  393,  352,
 /*   670 */   395,   34,  360,   36,  388,  400,   92,  402,  324,   95,
 /*   680 */    93,  406,  407,  357,  316,   64,   65,  158,  159,  335,
 /*   690 */   161,  416,   71,  399,  165,  401,  410,  411,  412,  175,
 /*   700 */   414,  177,  115,   82,   83,  175,  352,  177,  352,   88,
 /*   710 */   181,  316,  344,   14,   15,   16,  129,  130,    0,  363,
 /*   720 */   352,  344,  198,  199,  316,  357,  376,  359,  198,  199,
 /*   730 */   353,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   740 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   750 */   382,  254,  357,  384,  386,  387,  388,  389,  390,  391,
 /*   760 */   392,  393,  175,  395,  177,  357,    2,  237,  400,  316,
 /*   770 */   402,  258,    8,    9,  406,  407,   12,   13,   14,   15,
 /*   780 */    16,  316,  413,  316,  316,  198,  199,   39,  201,  202,
 /*   790 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*   800 */   213,  214,  215,  216,  217,  218,  219,   12,   13,  316,
 /*   810 */   357,  344,  336,  330,  331,   20,  349,   22,  354,  352,
 /*   820 */   344,  357,  357,  105,  357,  357,  359,    2,   33,  353,
 /*   830 */    35,  372,  202,    8,    9,   44,   45,   12,   13,   14,
 /*   840 */    15,   16,  124,  125,  126,  127,  128,  388,   20,  382,
 /*   850 */   357,   56,  316,  386,  387,  388,  389,  390,  391,  392,
 /*   860 */   393,   56,  395,   68,   12,   13,  352,  345,  368,  359,
 /*   870 */   370,  324,   20,  368,   22,  370,  417,  363,   19,  369,
 /*   880 */   316,  332,  335,  334,  317,   33,  157,   35,   93,  430,
 /*   890 */   431,  439,   33,  357,  435,  436,  333,    8,    9,  352,
 /*   900 */    95,   12,   13,   14,   15,   16,   47,  324,   56,  105,
 /*   910 */   115,   52,   53,   54,   55,   56,  372,  316,  335,   35,
 /*   920 */    68,  357,    8,    9,  129,  130,   12,   13,   14,   15,
 /*   930 */    16,  127,  388,    8,    9,  352,   93,   12,   13,   14,
 /*   940 */    15,   16,    1,    2,  337,   93,  103,  340,  324,  324,
 /*   950 */    61,   92,   68,  224,   95,  324,   35,  324,  357,  335,
 /*   960 */   335,  417,  324,  234,   42,   43,  335,  115,  335,    4,
 /*   970 */   175,   43,  177,  335,  430,  431,  352,  352,  316,  435,
 /*   980 */   436,  129,  130,  352,  236,  352,  428,  128,  235,  236,
 /*   990 */   352,  102,  316,  198,  199,    0,  201,  202,  203,  204,
 /*  1000 */   205,  206,  207,  208,  209,  210,  211,  212,  213,  214,
 /*  1010 */   215,  216,  217,  218,  219,  324,   18,   22,   20,  357,
 /*  1020 */   161,   22,   94,  162,  163,   27,  335,  175,   30,  177,
 /*  1030 */   202,  316,    0,  357,   35,   94,  372,  316,  179,  316,
 /*  1040 */   181,   97,  316,  352,  100,   47,  157,   49,  344,   51,
 /*  1050 */   198,  199,  388,  201,  202,  203,  204,  205,  206,  207,
 /*  1060 */   208,  209,  210,  211,  212,  213,  214,  215,  216,  217,
 /*  1070 */   218,  219,  357,  324,   97,    0,  162,  100,  357,   47,
 /*  1080 */   357,  417,  324,  357,  335,   97,   18,   43,  100,    0,
 /*  1090 */    92,   23,    0,  335,  430,  431,   61,   22,  177,  435,
 /*  1100 */   436,  352,  104,    0,   97,   37,   38,  100,   43,   41,
 /*  1110 */   352,   22,   43,  224,  225,  226,  227,  228,  229,  230,
 /*  1120 */   231,  232,  233,  234,  325,   57,   58,   59,    1,    2,
 /*  1130 */   132,  129,  130,  135,  136,  137,  138,  139,  140,  141,
 /*  1140 */   142,  143,  144,  145,  146,  147,  148,  149,  150,  151,
 /*  1150 */   152,  424,  154,  155,  156,   43,    3,  325,   43,   94,
 /*  1160 */    43,   93,  323,   94,   43,  388,   63,   64,   65,   66,
 /*  1170 */    67,   43,   69,   70,   71,   72,   73,   74,   75,   76,
 /*  1180 */    77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*  1190 */    87,   88,   89,   90,  417,   35,  324,  105,   43,  131,
 /*  1200 */   356,  385,  316,  238,   43,   46,   94,  335,  431,   94,
 /*  1210 */    13,   94,  435,  436,  432,   94,  124,  125,  126,  127,
 /*  1220 */   128,    0,   94,  415,  352,  408,   13,  418,  239,   43,
 /*  1230 */   344,   43,   35,  198,  380,  167,  168,  169,  352,   43,
 /*  1240 */   172,   47,    4,  357,  379,  359,   43,   94,   35,   94,
 /*  1250 */    43,  372,   93,   43,  173,   94,  188,   19,   42,  191,
 /*  1260 */   364,  193,  194,  195,  196,  197,  374,  388,  382,   48,
 /*  1270 */    20,   33,  386,  387,  388,  389,  390,  391,  392,  393,
 /*  1280 */    94,  395,   94,  372,  316,   47,  324,  324,  402,   51,
 /*  1290 */    94,  364,  406,  407,   56,  157,  417,   94,  362,  388,
 /*  1300 */   256,   94,  362,  417,   94,  237,  324,  324,  324,  430,
 /*  1310 */   431,   20,  344,   20,  435,  436,  430,  431,  318,  318,
 /*  1320 */   352,  435,  436,  378,  328,  357,  359,  359,  417,   20,
 /*  1330 */    92,  328,  371,   95,   20,  371,  328,  177,  328,  373,
 /*  1340 */   328,  430,  431,  328,  316,  324,  435,  436,  328,  318,
 /*  1350 */   382,  357,  378,  344,  386,  387,  388,  389,  390,  391,
 /*  1360 */   392,  393,  344,  395,  324,  318,  316,  344,  400,  344,
 /*  1370 */   402,  344,  344,  344,  406,  407,  359,  344,  344,  326,
 /*  1380 */   352,  344,  344,  344,  416,  357,  180,  359,  377,  326,
 /*  1390 */   324,  324,  244,  371,  344,  159,  326,  367,  357,  357,
 /*  1400 */   357,  365,  352,  357,  326,  357,  326,  357,  352,  359,
 /*  1410 */   382,  340,  367,   20,  386,  387,  388,  389,  390,  391,
 /*  1420 */   392,  393,  316,  395,  245,  367,  367,  423,  400,  357,
 /*  1430 */   402,  357,  382,  357,  406,  407,  386,  387,  388,  389,
 /*  1440 */   390,  391,  392,  393,  416,  395,  385,   12,   13,  423,
 /*  1450 */   344,  357,  357,  251,  166,  240,  252,   22,  352,  380,
 /*  1460 */   260,  253,  257,  357,  440,  359,  255,  417,   33,  236,
 /*  1470 */    35,  352,   20,   93,  422,  426,  425,  423,  421,   93,
 /*  1480 */   430,  431,  420,  316,  384,  435,  436,  405,  382,  434,
 /*  1490 */   348,   56,  386,  387,  388,  389,  390,  391,  392,  393,
 /*  1500 */   357,  395,  334,   68,  324,  316,  400,  326,  402,   36,
 /*  1510 */   433,  344,  406,  407,  319,  375,  318,  370,  327,  352,
 /*  1520 */   338,  338,  338,  314,  357,    0,  359,  182,    0,    0,
 /*  1530 */    42,    0,   35,  344,    0,  192,   35,   35,   35,  192,
 /*  1540 */     0,  352,   35,   35,  192,    0,  357,  192,  359,  382,
 /*  1550 */   115,    0,   35,  386,  387,  388,  389,  390,  391,  392,
 /*  1560 */   393,    0,  395,   22,    0,   35,  177,  175,    0,  402,
 /*  1570 */     0,  382,  171,  406,  407,  386,  387,  388,  389,  390,
 /*  1580 */   391,  392,  393,  170,  395,    0,    0,    0,   46,  316,
 /*  1590 */     0,  402,    0,    0,   42,  406,  407,    0,    0,  153,
 /*  1600 */     0,    0,    0,    0,    0,  148,   35,    0,  148,    0,
 /*  1610 */   175,    0,  177,    0,    0,    0,    0,  344,    0,    0,
 /*  1620 */     0,    0,    0,    0,    0,  352,    0,    0,    0,    0,
 /*  1630 */   357,   42,  359,  198,  199,    0,    0,    0,    0,   22,
 /*  1640 */     0,    0,    0,    0,  316,  210,  211,  212,  213,  214,
 /*  1650 */   215,  216,    0,    0,    0,  382,   46,    0,   14,  386,
 /*  1660 */   387,  388,  389,  390,  391,  392,  393,  394,  395,  396,
 /*  1670 */   397,   39,  344,   42,   40,   14,   43,    0,   39,    0,
 /*  1680 */   352,   56,    0,    0,  166,  357,   56,  359,   39,    0,
 /*  1690 */     0,   46,    0,    0,   35,   47,    0,  316,   35,    0,
 /*  1700 */    35,   39,   47,   39,    0,   47,   39,   35,   39,   62,
 /*  1710 */   382,    0,    0,   47,  386,  387,  388,  389,  390,  391,
 /*  1720 */   392,  393,    0,  395,    0,  344,   35,   22,    0,   35,
 /*  1730 */    35,   43,   35,  352,    0,   35,   22,    0,  357,   22,
 /*  1740 */   359,   43,   22,    0,   35,   22,    0,    0,   35,  316,
 /*  1750 */    49,  100,  102,   35,    0,   22,   20,    0,    0,  178,
 /*  1760 */    35,  316,   22,  382,  159,  437,  438,  386,  387,  388,
 /*  1770 */   389,  390,  391,  392,  393,  316,  395,  344,    0,    0,
 /*  1780 */     3,    0,    0,  402,    0,  352,   35,    0,  407,  344,
 /*  1790 */   357,    0,  359,  187,  349,   39,   93,  352,   46,  220,
 /*  1800 */   222,   94,  357,  344,  359,   43,   43,  241,  220,   93,
 /*  1810 */    46,  352,   93,  103,  158,  382,  357,   43,  359,  386,
 /*  1820 */   387,  388,  389,  390,  391,  392,  393,  382,  395,  316,
 /*  1830 */   397,  386,  387,  388,  389,  390,  391,  392,  393,  164,
 /*  1840 */   395,  382,  162,  316,  160,  386,  387,  388,  389,  390,
 /*  1850 */   391,  392,  393,   93,  395,   94,   43,  344,   93,   93,
 /*  1860 */    46,   43,   94,   94,  162,  352,   93,    3,  162,   94,
 /*  1870 */   357,  344,  359,   93,   43,   35,  349,   94,   93,  352,
 /*  1880 */    94,   93,   93,   35,  357,   35,  359,   35,  429,   94,
 /*  1890 */    35,   35,   94,  316,   94,  382,   43,   46,    2,  386,
 /*  1900 */   387,  388,  389,  390,  391,  392,  393,   46,  395,  382,
 /*  1910 */    22,  241,  316,  386,  387,  388,  389,  390,  391,  392,
 /*  1920 */   393,  344,  395,   46,  198,   93,  349,  241,   94,  352,
 /*  1930 */    93,   46,   94,   94,  357,   93,  359,   93,   93,   46,
 /*  1940 */   344,   94,   22,  235,  200,  104,   35,   93,  352,   35,
 /*  1950 */    93,  438,   94,  357,   94,  359,   35,   94,   93,  382,
 /*  1960 */    35,   93,  316,  386,  387,  388,  389,  390,  391,  392,
 /*  1970 */   393,   35,  395,   94,   93,   35,  316,   94,  382,   93,
 /*  1980 */    22,   35,  386,  387,  388,  389,  390,  391,  392,  393,
 /*  1990 */   344,  395,  117,  117,  105,  117,   93,  117,  352,   93,
 /*  2000 */    93,   22,   43,  357,  344,  359,   62,   35,   61,   35,
 /*  2010 */    35,   35,  352,   35,   91,   35,   35,  357,   35,  359,
 /*  2020 */    35,   35,   68,   35,   35,   43,   22,   35,  382,   22,
 /*  2030 */    35,  316,  386,  387,  388,  389,  390,  391,  392,  393,
 /*  2040 */    35,  395,  382,   35,   35,   68,  386,  387,  388,  389,
 /*  2050 */   390,  391,  392,  393,   35,  395,   35,  316,   35,  344,
 /*  2060 */    35,   22,   35,    0,   35,   39,    0,  352,   35,   47,
 /*  2070 */    39,   47,  357,    0,  359,   35,   39,   47,    0,   35,
 /*  2080 */    39,   47,    0,  316,   35,  344,   35,    0,   20,   22,
 /*  2090 */    21,  441,   22,  352,   22,   21,  441,  382,  357,  441,
 /*  2100 */   359,  386,  387,  388,  389,  390,  391,  392,  393,  316,
 /*  2110 */   395,  344,  441,  441,  441,  441,  441,  441,  441,  352,
 /*  2120 */   441,  441,  441,  382,  357,  441,  359,  386,  387,  388,
 /*  2130 */   389,  390,  391,  392,  393,  316,  395,  344,  441,  441,
 /*  2140 */   441,  441,  441,  441,  441,  352,  441,  441,  441,  382,
 /*  2150 */   357,  441,  359,  386,  387,  388,  389,  390,  391,  392,
 /*  2160 */   393,  441,  395,  344,  441,  441,  441,  441,  441,  441,
 /*  2170 */   441,  352,  441,  441,  441,  382,  357,  441,  359,  386,
 /*  2180 */   387,  388,  389,  390,  391,  392,  393,  316,  395,  441,
 /*  2190 */   441,  441,  441,  441,  441,  441,  441,  441,  441,  441,
 /*  2200 */   441,  382,  441,  316,  441,  386,  387,  388,  389,  390,
 /*  2210 */   391,  392,  393,  441,  395,  344,  441,  441,  441,  441,
 /*  2220 */   441,  441,  441,  352,  441,  441,  441,  441,  357,  441,
 /*  2230 */   359,  344,  441,  441,  441,  441,  441,  441,  441,  352,
 /*  2240 */   441,  441,  441,  441,  357,  441,  359,  441,  441,  441,
 /*  2250 */   441,  441,  441,  382,  441,  441,  441,  386,  387,  388,
 /*  2260 */   389,  390,  391,  392,  393,  316,  395,  441,  441,  382,
 /*  2270 */   441,  441,  441,  386,  387,  388,  389,  390,  391,  392,
 /*  2280 */   393,  316,  395,  441,  441,  441,  441,  441,  441,  441,
 /*  2290 */   441,  441,  441,  344,  441,  441,  441,  441,  441,  441,
 /*  2300 */   441,  352,  441,  441,  441,  441,  357,  441,  359,  344,
 /*  2310 */   441,  441,  441,  441,  441,  441,  441,  352,  441,  441,
 /*  2320 */   441,  441,  357,  441,  359,  441,  441,  441,  441,  441,
 /*  2330 */   441,  382,  441,  441,  316,  386,  387,  388,  389,  390,
 /*  2340 */   391,  392,  393,  441,  395,  441,  441,  382,  316,  441,
 /*  2350 */   441,  386,  387,  388,  389,  390,  391,  392,  393,  441,
 /*  2360 */   395,  441,  344,  441,  441,  441,  441,  441,  441,  441,
 /*  2370 */   352,  441,  441,  441,  441,  357,  344,  359,  441,  441,
 /*  2380 */   441,  441,  441,  441,  352,  441,  441,  441,  441,  357,
 /*  2390 */   441,  359,  441,  441,  441,  441,  441,  441,  441,  441,
 /*  2400 */   382,  441,  316,  441,  386,  387,  388,  389,  390,  391,
 /*  2410 */   392,  393,  441,  395,  382,  441,  441,  441,  386,  387,
 /*  2420 */   388,  389,  390,  391,  392,  393,  316,  395,  441,  441,
 /*  2430 */   344,  441,  441,  441,  441,  441,  441,  441,  352,  441,
 /*  2440 */   441,  441,  441,  357,  441,  359,  441,  441,  441,  441,
 /*  2450 */   441,  441,  316,  441,  344,  441,  441,  441,  441,  441,
 /*  2460 */   441,  441,  352,  441,  441,  441,  441,  357,  382,  359,
 /*  2470 */   441,  441,  386,  387,  388,  389,  390,  391,  392,  393,
 /*  2480 */   344,  395,  441,  441,  441,  441,  441,  441,  352,  441,
 /*  2490 */   441,  441,  382,  357,  441,  359,  386,  387,  388,  389,
 /*  2500 */   390,  391,  392,  393,  316,  395,  441,  441,  441,  441,
 /*  2510 */   441,  441,  441,  441,  441,  441,  441,  441,  382,  441,
 /*  2520 */   316,  441,  386,  387,  388,  389,  390,  391,  392,  393,
 /*  2530 */   441,  395,  344,  441,  441,  441,  441,  441,  441,  441,
 /*  2540 */   352,  441,  441,  441,  441,  357,  441,  359,  344,  441,
 /*  2550 */   441,  441,  441,  441,  441,  441,  352,  441,  441,  441,
 /*  2560 */   441,  357,  441,  359,  441,  441,  441,  441,  441,  441,
 /*  2570 */   382,  441,  441,  441,  386,  387,  388,  389,  390,  391,
 /*  2580 */   392,  393,  316,  395,  441,  441,  382,  441,  441,  441,
 /*  2590 */   386,  387,  388,  389,  390,  391,  392,  393,  441,  395,
 /*  2600 */   441,  441,  441,  441,  441,  441,  441,  441,  441,  441,
 /*  2610 */   344,  441,  441,  441,  441,  441,  441,  441,  352,  441,
 /*  2620 */   441,  441,  441,  357,  441,  359,  441,  441,  441,  441,
 /*  2630 */   441,  441,  441,  441,  441,  441,  441,  441,  441,  441,
 /*  2640 */   441,  441,  441,  441,  441,  441,  441,  441,  382,  441,
 /*  2650 */   441,  441,  386,  387,  388,  389,  390,  391,  392,  393,
 /*  2660 */   441,  395,
};
#define YY_SHIFT_COUNT    (678)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2087)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1068,    0,   57,  265,   57,  322,  322,  322,  530,  322,
 /*    10 */   322,  322,  322,  322,  587,  795,  852,  795,  795,  795,
 /*    20 */   795,  795,  795,  795,  795,  795,  795,  795,  795,  795,
 /*    30 */   795,  795,  795,  795,  795,  795,  795,  795,  795,  795,
 /*    40 */   795,  795,  795,  795,   16,  266,   39,  208,  269,   14,
 /*    50 */    59,   14,   39,   39, 1435, 1435,   14, 1435, 1435,   62,
 /*    60 */    14,   17,   17,   13,   13,  268,   17,   17,   17,   17,
 /*    70 */    17,   17,   17,   17,   17,   17,   68,   17,   17,   17,
 /*    80 */   171,   17,   17,  442,   17,   17,  442,  502,   17,  442,
 /*    90 */   442,  442,   17,  163,  998,  889,  889,  429,  524,  524,
 /*   100 */   524,  524,  524,  524,  524,  524,  524,  524,  524,  524,
 /*   110 */   524,  524,  524,  524,  524,  524,  524,  470,  621,   12,
 /*   120 */   268,   58,   58,  327,  328,  438,  101,  101,    9,    9,
 /*   130 */     9,  328,  574,  574,  171,    2,    2,   63,  442,  442,
 /*   140 */   381,  381,  233,  440,  196,  196,  196,  196,  196,  196,
 /*   150 */   196,  859,  402,  337,   34,   43,  552,  179,  427,  630,
 /*   160 */   232,  791,  804,  334,  753,  748,  497,  753,  922,  965,
 /*   170 */   828,  989, 1194, 1081, 1216, 1250, 1250, 1216, 1138, 1138,
 /*   180 */  1250, 1250, 1250, 1291, 1291, 1293,   68,  171,   68, 1309,
 /*   190 */  1314,   68, 1309,   68,   68,   68, 1250,   68, 1291,  442,
 /*   200 */   442,  442,  442,  442,  442,  442,  442,  442,  442,  442,
 /*   210 */  1250, 1291,  381, 1293,  163, 1206,  171,  163, 1250, 1250,
 /*   220 */  1309,  163, 1148,  381,  381,  381,  381, 1148,  381, 1236,
 /*   230 */   163,  233,  163,  574, 1393,  381, 1179, 1148,  381,  381,
 /*   240 */  1179, 1148,  381,  381,  442, 1202, 1288, 1179, 1208, 1204,
 /*   250 */  1215,  989, 1200, 1205, 1211, 1233,  574, 1452, 1380, 1386,
 /*   260 */   381,  440, 1250,  163, 1473, 1291, 2662, 2662, 2662, 2662,
 /*   270 */  2662, 2662, 2662, 1103,  529,  485, 1238,  234,  396,  479,
 /*   280 */   764,  825,  914,  718,  925,  925,  925,  925,  925,  925,
 /*   290 */   925,  925,  925, 1092,  488,   11,   11,    6,  205,  203,
 /*   300 */   584,  242,  637,  421,  699,  941,  729,  699,  699,  699,
 /*   310 */   928, 1032,  999,  944,  977,  988, 1007,  995, 1075, 1089,
 /*   320 */   805,  861, 1065, 1069, 1112, 1115, 1117, 1121, 1128, 1002,
 /*   330 */  1044,  513, 1127, 1155,  921, 1160, 1035, 1161, 1153, 1159,
 /*   340 */  1186, 1188, 1196, 1203, 1207, 1210,  843, 1197, 1213,  884,
 /*   350 */  1221, 1525, 1534, 1345, 1528, 1529, 1488, 1531, 1497, 1343,
 /*   360 */  1501, 1502, 1503, 1347, 1540, 1507, 1508, 1352, 1545, 1355,
 /*   370 */  1551, 1517, 1561, 1541, 1564, 1530, 1389, 1392, 1568, 1570,
 /*   380 */  1401, 1413, 1585, 1586, 1542, 1587, 1590, 1592, 1552, 1593,
 /*   390 */  1597, 1598, 1446, 1600, 1601, 1602, 1603, 1604, 1457, 1571,
 /*   400 */  1607, 1460, 1609, 1611, 1613, 1614, 1615, 1616, 1618, 1619,
 /*   410 */  1620, 1621, 1622, 1623, 1624, 1626, 1589, 1627, 1628, 1629,
 /*   420 */  1635, 1636, 1637, 1617, 1638, 1640, 1641, 1642, 1643, 1625,
 /*   430 */  1652, 1630, 1653, 1654, 1631, 1632, 1633, 1644, 1610, 1661,
 /*   440 */  1645, 1657, 1634, 1639, 1677, 1679, 1682, 1649, 1518, 1683,
 /*   450 */  1689, 1690, 1647, 1692, 1693, 1659, 1648, 1662, 1696, 1663,
 /*   460 */  1655, 1664, 1699, 1665, 1658, 1667, 1704, 1672, 1666, 1669,
 /*   470 */  1711, 1712, 1722, 1724, 1650, 1651, 1691, 1705, 1728, 1694,
 /*   480 */  1695, 1688, 1698, 1697, 1700, 1714, 1734, 1717, 1737, 1720,
 /*   490 */  1701, 1743, 1723, 1709, 1746, 1713, 1747, 1718, 1754, 1733,
 /*   500 */  1736, 1757, 1680, 1725, 1758, 1581, 1740, 1702, 1605, 1778,
 /*   510 */  1779, 1706, 1675, 1777, 1781, 1782, 1784, 1703, 1707, 1751,
 /*   520 */  1606, 1787, 1716, 1684, 1719, 1791, 1756, 1656, 1760, 1710,
 /*   530 */  1752, 1762, 1579, 1578, 1588, 1763, 1566, 1765, 1761, 1766,
 /*   540 */  1768, 1769, 1773, 1774, 1775, 1780, 1785, 1788, 1783, 1813,
 /*   550 */  1764, 1814, 1789, 1818, 1670, 1786, 1795, 1864, 1831, 1686,
 /*   560 */  1840, 1848, 1850, 1852, 1855, 1856, 1798, 1800, 1851, 1708,
 /*   570 */  1853, 1861, 1877, 1896, 1888, 1726, 1832, 1834, 1837, 1838,
 /*   580 */  1842, 1839, 1885, 1844, 1845, 1893, 1847, 1920, 1744, 1854,
 /*   590 */  1841, 1858, 1911, 1914, 1857, 1860, 1921, 1865, 1863, 1925,
 /*   600 */  1868, 1879, 1936, 1881, 1883, 1940, 1886, 1875, 1876, 1878,
 /*   610 */  1880, 1958, 1889, 1903, 1906, 1946, 1907, 1959, 1959, 1979,
 /*   620 */  1944, 1947, 1972, 1974, 1975, 1976, 1978, 1980, 1981, 1983,
 /*   630 */  1985, 1986, 1954, 1923, 1982, 1988, 1989, 2004, 1992, 2007,
 /*   640 */  1995, 2005, 2008, 1977, 1688, 2009, 1698, 2019, 2021, 2023,
 /*   650 */  2025, 2039, 2027, 2063, 2029, 2022, 2026, 2066, 2033, 2024,
 /*   660 */  2031, 2073, 2040, 2030, 2037, 2078, 2044, 2034, 2041, 2082,
 /*   670 */  2049, 2051, 2087, 2067, 2069, 2070, 2072, 2074, 2068,
};
#define YY_REDUCE_COUNT (272)
#define YY_REDUCE_MIN   (-395)
#define YY_REDUCE_MAX   (2266)
static const short yy_reduce_ofst[] = {
 /*     0 */  -268,  886, -249, -162, -306,  275,  968, 1028, 1050,  -21,
 /*    10 */   368, 1106, 1167, 1189, 1273, 1328, 1381,  467, 1433, 1445,
 /*    20 */  1459, 1513, 1527, 1577, 1596, 1646, 1660, 1715, 1741, 1767,
 /*    30 */  1793, 1819, 1871, 1887, 1949, 1965, 2018, 2032, 2086, 2110,
 /*    40 */  2136, 2188, 2204, 2266,  -11,  200,  237,  459,  544,  664,
 /*    50 */   879,  911, -131,  286, -341, -222, -387, -307, -201, -252,
 /*    60 */   777, -324, -321, -316, -260, -232, -233,    8,   83,  166,
 /*    70 */   243,  302,  317,  354,  547,  583,  229,  624,  625,  631,
 /*    80 */    77,  633,  638, -289,  691,  749, -175, -279,  758,  211,
 /*    90 */    -4,  476,  872,  264, -227, -395, -395, -203,   32,  132,
 /*   100 */   261,  326,  395,  408,  453,  465,  468,  493,  536,  564,
 /*   110 */   601,  662,  676,  715,  721,  723,  726, -121, -133,  135,
 /*   120 */  -211,  -27,   92,  230,  223,  118, -235,  294,  135,  220,
 /*   130 */   369,  483,  356,  514,  510,  500,  505,  104,  377,  312,
 /*   140 */    60,  464,  607,  549, -326, -293,  204,  263,  283,  308,
 /*   150 */   522,  350,  567,  452,  563,  558,  799,  727,  704,  704,
 /*   160 */   832,  839,  844,  816,  808,  808,  782,  808,  817,  809,
 /*   170 */   704,  854,  865,  892,  896,  962,  963,  927,  936,  940,
 /*   180 */   982,  983,  984, 1000, 1001,  945,  996,  967, 1003,  961,
 /*   190 */   966, 1008,  964, 1010, 1012, 1015, 1021, 1020, 1031, 1009,
 /*   200 */  1018, 1023, 1025, 1027, 1029, 1033, 1034, 1037, 1038, 1039,
 /*   210 */  1040, 1047,  994,  974, 1053, 1011, 1017, 1063, 1066, 1067,
 /*   220 */  1022, 1070, 1030, 1041, 1042, 1043, 1046, 1045, 1048, 1036,
 /*   230 */  1078, 1071, 1080, 1056, 1061, 1072, 1004, 1058, 1074, 1076,
 /*   240 */  1026, 1059, 1094, 1095,  704, 1049, 1051, 1054, 1052, 1057,
 /*   250 */  1062, 1079, 1024, 1055, 1077,  808, 1119, 1100, 1082, 1142,
 /*   260 */  1143, 1168, 1180, 1181, 1195, 1198, 1140, 1147, 1182, 1183,
 /*   270 */  1184, 1191, 1209,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*    10 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*    20 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*    30 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*    40 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*    50 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*    60 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*    70 */  1509, 1509, 1509, 1509, 1509, 1509, 1583, 1509, 1509, 1509,
 /*    80 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*    90 */  1509, 1509, 1509, 1581, 1746, 1930, 1509, 1509, 1509, 1509,
 /*   100 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   110 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1942,
 /*   120 */  1509, 1509, 1509, 1583, 1509, 1581, 1902, 1902, 1942, 1942,
 /*   130 */  1942, 1509, 1509, 1509, 1509, 1787, 1787, 1509, 1509, 1509,
 /*   140 */  1509, 1509, 1686, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   150 */  1509, 1781, 1509, 2015, 1509, 1509, 1509, 1965, 1509, 1509,
 /*   160 */  1509, 1509, 1639, 1957, 1934, 1948, 1999, 1935, 1932, 1951,
 /*   170 */  1509, 1961, 1509, 1774, 1751, 1509, 1509, 1751, 1748, 1748,
 /*   180 */  1509, 1509, 1509, 1509, 1509, 1509, 1583, 1509, 1583, 1509,
 /*   190 */  1509, 1583, 1509, 1583, 1583, 1583, 1509, 1583, 1509, 1509,
 /*   200 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   210 */  1509, 1509, 1509, 1509, 1581, 1783, 1509, 1581, 1509, 1509,
 /*   220 */  1509, 1581, 1970, 1509, 1509, 1509, 1509, 1970, 1509, 1509,
 /*   230 */  1581, 1509, 1581, 1509, 1509, 1509, 1972, 1970, 1509, 1509,
 /*   240 */  1972, 1970, 1509, 1509, 1509, 1984, 1980, 1972, 1988, 1986,
 /*   250 */  1963, 1961, 2018, 2005, 2001, 1948, 1509, 1509, 1509, 1655,
 /*   260 */  1509, 1509, 1509, 1581, 1541, 1509, 1776, 1787, 1689, 1689,
 /*   270 */  1689, 1584, 1514, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   280 */  1509, 1509, 1509, 1509, 1860, 1509, 1983, 1982, 1906, 1905,
 /*   290 */  1904, 1895, 1859, 1509, 1651, 1858, 1857, 1509, 1509, 1509,
 /*   300 */  1509, 1509, 1509, 1509, 1851, 1509, 1509, 1852, 1850, 1849,
 /*   310 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   320 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   330 */  2002, 2006, 1931, 1509, 1509, 1509, 1509, 1509, 1842, 1833,
 /*   340 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   350 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   360 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   370 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   380 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   390 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   400 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   410 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   420 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   430 */  1509, 1509, 1509, 1509, 1509, 1509, 1546, 1509, 1509, 1509,
 /*   440 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   450 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   460 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   470 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   480 */  1509, 1622, 1621, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   490 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   500 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   510 */  1509, 1509, 1509, 1998, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   520 */  1509, 1791, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   530 */  1509, 1892, 1509, 1509, 1509, 1964, 1509, 1509, 1509, 1509,
 /*   540 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   550 */  1509, 1833, 1509, 1981, 1509, 1509, 1996, 1509, 2000, 1509,
 /*   560 */  1509, 1509, 1509, 1509, 1509, 1509, 1941, 1937, 1509, 1509,
 /*   570 */  1933, 1832, 1509, 1926, 1509, 1509, 1877, 1509, 1509, 1509,
 /*   580 */  1509, 1509, 1509, 1509, 1509, 1509, 1841, 1509, 1845, 1509,
 /*   590 */  1509, 1509, 1509, 1509, 1683, 1509, 1509, 1509, 1509, 1509,
 /*   600 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1668, 1666, 1665,
 /*   610 */  1664, 1509, 1661, 1509, 1509, 1509, 1509, 1692, 1691, 1509,
 /*   620 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   630 */  1509, 1509, 1509, 1509, 1603, 1509, 1509, 1509, 1509, 1509,
 /*   640 */  1509, 1509, 1509, 1509, 1594, 1509, 1593, 1509, 1509, 1509,
 /*   650 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   660 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
 /*   670 */  1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509, 1509,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  261,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  261,  /*      AFTER => ABORT */
  261,  /*     ATTACH => ABORT */
  261,  /*     BEFORE => ABORT */
  261,  /*      BEGIN => ABORT */
  261,  /*     BITAND => ABORT */
  261,  /*     BITNOT => ABORT */
  261,  /*      BITOR => ABORT */
  261,  /*     BLOCKS => ABORT */
  261,  /*     CHANGE => ABORT */
  261,  /*      COMMA => ABORT */
  261,  /*    COMPACT => ABORT */
  261,  /*     CONCAT => ABORT */
  261,  /*   CONFLICT => ABORT */
  261,  /*       COPY => ABORT */
  261,  /*   DEFERRED => ABORT */
  261,  /* DELIMITERS => ABORT */
  261,  /*     DETACH => ABORT */
  261,  /*     DIVIDE => ABORT */
  261,  /*        DOT => ABORT */
  261,  /*       EACH => ABORT */
  261,  /*       FAIL => ABORT */
  261,  /*       FILE => ABORT */
  261,  /*        FOR => ABORT */
  261,  /*       GLOB => ABORT */
  261,  /*         ID => ABORT */
  261,  /*  IMMEDIATE => ABORT */
  261,  /*     IMPORT => ABORT */
  261,  /*  INITIALLY => ABORT */
  261,  /*    INSTEAD => ABORT */
  261,  /*     ISNULL => ABORT */
  261,  /*        KEY => ABORT */
  261,  /*  NK_BITNOT => ABORT */
  261,  /*    NK_SEMI => ABORT */
  261,  /*    NOTNULL => ABORT */
  261,  /*         OF => ABORT */
  261,  /*       PLUS => ABORT */
  261,  /*  PRIVILEGE => ABORT */
  261,  /*      RAISE => ABORT */
  261,  /*    REPLACE => ABORT */
  261,  /*   RESTRICT => ABORT */
  261,  /*        ROW => ABORT */
  261,  /*       SEMI => ABORT */
  261,  /*       STAR => ABORT */
  261,  /*  STATEMENT => ABORT */
  261,  /*     STRING => ABORT */
  261,  /*      TIMES => ABORT */
  261,  /*     UPDATE => ABORT */
  261,  /*     VALUES => ABORT */
  261,  /*   VARIABLE => ABORT */
  261,  /*       VIEW => ABORT */
  261,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "MAXROWS",
  /*   70 */ "MINROWS",
  /*   71 */ "KEEP",
  /*   72 */ "PAGES",
  /*   73 */ "PAGESIZE",
  /*   74 */ "TSDB_PAGESIZE",
  /*   75 */ "PRECISION",
  /*   76 */ "REPLICA",
  /*   77 */ "STRICT",
  /*   78 */ "VGROUPS",
  /*   79 */ "SINGLE_STABLE",
  /*   80 */ "RETENTIONS",
  /*   81 */ "SCHEMALESS",
  /*   82 */ "WAL_LEVEL",
  /*   83 */ "WAL_FSYNC_PERIOD",
  /*   84 */ "WAL_RETENTION_PERIOD",
  /*   85 */ "WAL_RETENTION_SIZE",
  /*   86 */ "WAL_ROLL_PERIOD",
  /*   87 */ "WAL_SEGMENT_SIZE",
  /*   88 */ "STT_TRIGGER",
  /*   89 */ "TABLE_PREFIX",
  /*   90 */ "TABLE_SUFFIX",
  /*   91 */ "NK_COLON",
  /*   92 */ "TABLE",
  /*   93 */ "NK_LP",
  /*   94 */ "NK_RP",
  /*   95 */ "STABLE",
  /*   96 */ "ADD",
  /*   97 */ "COLUMN",
  /*   98 */ "MODIFY",
  /*   99 */ "RENAME",
  /*  100 */ "TAG",
  /*  101 */ "SET",
  /*  102 */ "NK_EQ",
  /*  103 */ "USING",
  /*  104 */ "TAGS",
  /*  105 */ "COMMENT",
  /*  106 */ "BOOL",
  /*  107 */ "TINYINT",
  /*  108 */ "SMALLINT",
  /*  109 */ "INT",
  /*  110 */ "INTEGER",
  /*  111 */ "BIGINT",
  /*  112 */ "FLOAT",
  /*  113 */ "DOUBLE",
  /*  114 */ "BINARY",
  /*  115 */ "TIMESTAMP",
  /*  116 */ "NCHAR",
  /*  117 */ "UNSIGNED",
  /*  118 */ "JSON",
  /*  119 */ "VARCHAR",
  /*  120 */ "MEDIUMBLOB",
  /*  121 */ "BLOB",
  /*  122 */ "VARBINARY",
  /*  123 */ "DECIMAL",
  /*  124 */ "MAX_DELAY",
  /*  125 */ "WATERMARK",
  /*  126 */ "ROLLUP",
  /*  127 */ "TTL",
  /*  128 */ "SMA",
  /*  129 */ "FIRST",
  /*  130 */ "LAST",
  /*  131 */ "SHOW",
  /*  132 */ "DATABASES",
  /*  133 */ "TABLES",
  /*  134 */ "STABLES",
  /*  135 */ "MNODES",
  /*  136 */ "MODULES",
  /*  137 */ "QNODES",
  /*  138 */ "FUNCTIONS",
  /*  139 */ "INDEXES",
  /*  140 */ "ACCOUNTS",
  /*  141 */ "APPS",
  /*  142 */ "CONNECTIONS",
  /*  143 */ "LICENCES",
  /*  144 */ "GRANTS",
  /*  145 */ "QUERIES",
  /*  146 */ "SCORES",
  /*  147 */ "TOPICS",
  /*  148 */ "VARIABLES",
  /*  149 */ "BNODES",
  /*  150 */ "SNODES",
  /*  151 */ "CLUSTER",
  /*  152 */ "TRANSACTIONS",
  /*  153 */ "DISTRIBUTED",
  /*  154 */ "CONSUMERS",
  /*  155 */ "SUBSCRIPTIONS",
  /*  156 */ "VNODES",
  /*  157 */ "LIKE",
  /*  158 */ "INDEX",
  /*  159 */ "FUNCTION",
  /*  160 */ "INTERVAL",
  /*  161 */ "TOPIC",
  /*  162 */ "AS",
  /*  163 */ "WITH",
  /*  164 */ "META",
  /*  165 */ "CONSUMER",
  /*  166 */ "GROUP",
  /*  167 */ "DESC",
  /*  168 */ "DESCRIBE",
  /*  169 */ "RESET",
  /*  170 */ "QUERY",
  /*  171 */ "CACHE",
  /*  172 */ "EXPLAIN",
  /*  173 */ "ANALYZE",
  /*  174 */ "VERBOSE",
  /*  175 */ "NK_BOOL",
  /*  176 */ "RATIO",
  /*  177 */ "NK_FLOAT",
  /*  178 */ "OUTPUTTYPE",
  /*  179 */ "AGGREGATE",
  /*  180 */ "BUFSIZE",
  /*  181 */ "STREAM",
  /*  182 */ "INTO",
  /*  183 */ "TRIGGER",
  /*  184 */ "AT_ONCE",
  /*  185 */ "WINDOW_CLOSE",
  /*  186 */ "IGNORE",
  /*  187 */ "EXPIRED",
  /*  188 */ "KILL",
  /*  189 */ "CONNECTION",
  /*  190 */ "TRANSACTION",
  /*  191 */ "BALANCE",
  /*  192 */ "VGROUP",
  /*  193 */ "MERGE",
  /*  194 */ "REDISTRIBUTE",
  /*  195 */ "SPLIT",
  /*  196 */ "DELETE",
  /*  197 */ "INSERT",
  /*  198 */ "NULL",
  /*  199 */ "NK_QUESTION",
  /*  200 */ "NK_ARROW",
  /*  201 */ "ROWTS",
  /*  202 */ "TBNAME",
  /*  203 */ "QSTART",
  /*  204 */ "QEND",
  /*  205 */ "QDURATION",
  /*  206 */ "WSTART",
  /*  207 */ "WEND",
  /*  208 */ "WDURATION",
  /*  209 */ "CAST",
  /*  210 */ "NOW",
  /*  211 */ "TODAY",
  /*  212 */ "TIMEZONE",
  /*  213 */ "CLIENT_VERSION",
  /*  214 */ "SERVER_VERSION",
  /*  215 */ "SERVER_STATUS",
  /*  216 */ "CURRENT_USER",
  /*  217 */ "COUNT",
  /*  218 */ "LAST_ROW",
  /*  219 */ "CASE",
  /*  220 */ "END",
  /*  221 */ "WHEN",
  /*  222 */ "THEN",
  /*  223 */ "ELSE",
  /*  224 */ "BETWEEN",
  /*  225 */ "IS",
  /*  226 */ "NK_LT",
  /*  227 */ "NK_GT",
  /*  228 */ "NK_LE",
  /*  229 */ "NK_GE",
  /*  230 */ "NK_NE",
  /*  231 */ "MATCH",
  /*  232 */ "NMATCH",
  /*  233 */ "CONTAINS",
  /*  234 */ "IN",
  /*  235 */ "JOIN",
  /*  236 */ "INNER",
  /*  237 */ "SELECT",
  /*  238 */ "DISTINCT",
  /*  239 */ "WHERE",
  /*  240 */ "PARTITION",
  /*  241 */ "BY",
  /*  242 */ "SESSION",
  /*  243 */ "STATE_WINDOW",
  /*  244 */ "SLIDING",
  /*  245 */ "FILL",
  /*  246 */ "VALUE",
  /*  247 */ "NONE",
  /*  248 */ "PREV",
  /*  249 */ "LINEAR",
  /*  250 */ "NEXT",
  /*  251 */ "HAVING",
  /*  252 */ "RANGE",
  /*  253 */ "EVERY",
  /*  254 */ "ORDER",
  /*  255 */ "SLIMIT",
  /*  256 */ "SOFFSET",
  /*  257 */ "LIMIT",
  /*  258 */ "OFFSET",
  /*  259 */ "ASC",
  /*  260 */ "NULLS",
  /*  261 */ "ABORT",
  /*  262 */ "AFTER",
  /*  263 */ "ATTACH",
  /*  264 */ "BEFORE",
  /*  265 */ "BEGIN",
  /*  266 */ "BITAND",
  /*  267 */ "BITNOT",
  /*  268 */ "BITOR",
  /*  269 */ "BLOCKS",
  /*  270 */ "CHANGE",
  /*  271 */ "COMMA",
  /*  272 */ "COMPACT",
  /*  273 */ "CONCAT",
  /*  274 */ "CONFLICT",
  /*  275 */ "COPY",
  /*  276 */ "DEFERRED",
  /*  277 */ "DELIMITERS",
  /*  278 */ "DETACH",
  /*  279 */ "DIVIDE",
  /*  280 */ "DOT",
  /*  281 */ "EACH",
  /*  282 */ "FAIL",
  /*  283 */ "FILE",
  /*  284 */ "FOR",
  /*  285 */ "GLOB",
  /*  286 */ "ID",
  /*  287 */ "IMMEDIATE",
  /*  288 */ "IMPORT",
  /*  289 */ "INITIALLY",
  /*  290 */ "INSTEAD",
  /*  291 */ "ISNULL",
  /*  292 */ "KEY",
  /*  293 */ "NK_BITNOT",
  /*  294 */ "NK_SEMI",
  /*  295 */ "NOTNULL",
  /*  296 */ "OF",
  /*  297 */ "PLUS",
  /*  298 */ "PRIVILEGE",
  /*  299 */ "RAISE",
  /*  300 */ "REPLACE",
  /*  301 */ "RESTRICT",
  /*  302 */ "ROW",
  /*  303 */ "SEMI",
  /*  304 */ "STAR",
  /*  305 */ "STATEMENT",
  /*  306 */ "STRING",
  /*  307 */ "TIMES",
  /*  308 */ "UPDATE",
  /*  309 */ "VALUES",
  /*  310 */ "VARIABLE",
  /*  311 */ "VIEW",
  /*  312 */ "WAL",
  /*  313 */ "cmd",
  /*  314 */ "account_options",
  /*  315 */ "alter_account_options",
  /*  316 */ "literal",
  /*  317 */ "alter_account_option",
  /*  318 */ "user_name",
  /*  319 */ "sysinfo_opt",
  /*  320 */ "privileges",
  /*  321 */ "priv_level",
  /*  322 */ "priv_type_list",
  /*  323 */ "priv_type",
  /*  324 */ "db_name",
  /*  325 */ "dnode_endpoint",
  /*  326 */ "not_exists_opt",
  /*  327 */ "db_options",
  /*  328 */ "exists_opt",
  /*  329 */ "alter_db_options",
  /*  330 */ "integer_list",
  /*  331 */ "variable_list",
  /*  332 */ "retention_list",
  /*  333 */ "alter_db_option",
  /*  334 */ "retention",
  /*  335 */ "full_table_name",
  /*  336 */ "column_def_list",
  /*  337 */ "tags_def_opt",
  /*  338 */ "table_options",
  /*  339 */ "multi_create_clause",
  /*  340 */ "tags_def",
  /*  341 */ "multi_drop_clause",
  /*  342 */ "alter_table_clause",
  /*  343 */ "alter_table_options",
  /*  344 */ "column_name",
  /*  345 */ "type_name",
  /*  346 */ "signed_literal",
  /*  347 */ "create_subtable_clause",
  /*  348 */ "specific_cols_opt",
  /*  349 */ "expression_list",
  /*  350 */ "drop_table_clause",
  /*  351 */ "col_name_list",
  /*  352 */ "table_name",
  /*  353 */ "column_def",
  /*  354 */ "duration_list",
  /*  355 */ "rollup_func_list",
  /*  356 */ "alter_table_option",
  /*  357 */ "duration_literal",
  /*  358 */ "rollup_func_name",
  /*  359 */ "function_name",
  /*  360 */ "col_name",
  /*  361 */ "db_name_cond_opt",
  /*  362 */ "like_pattern_opt",
  /*  363 */ "table_name_cond",
  /*  364 */ "from_db_opt",
  /*  365 */ "index_options",
  /*  366 */ "func_list",
  /*  367 */ "sliding_opt",
  /*  368 */ "sma_stream_opt",
  /*  369 */ "func",
  /*  370 */ "stream_options",
  /*  371 */ "topic_name",
  /*  372 */ "query_or_subquery",
  /*  373 */ "cgroup_name",
  /*  374 */ "analyze_opt",
  /*  375 */ "explain_options",
  /*  376 */ "agg_func_opt",
  /*  377 */ "bufsize_opt",
  /*  378 */ "stream_name",
  /*  379 */ "dnode_list",
  /*  380 */ "where_clause_opt",
  /*  381 */ "signed",
  /*  382 */ "literal_func",
  /*  383 */ "literal_list",
  /*  384 */ "table_alias",
  /*  385 */ "column_alias",
  /*  386 */ "expr_or_subquery",
  /*  387 */ "expression",
  /*  388 */ "subquery",
  /*  389 */ "pseudo_column",
  /*  390 */ "column_reference",
  /*  391 */ "function_expression",
  /*  392 */ "case_when_expression",
  /*  393 */ "star_func",
  /*  394 */ "star_func_para_list",
  /*  395 */ "noarg_func",
  /*  396 */ "other_para_list",
  /*  397 */ "star_func_para",
  /*  398 */ "when_then_list",
  /*  399 */ "case_when_else_opt",
  /*  400 */ "common_expression",
  /*  401 */ "when_then_expr",
  /*  402 */ "predicate",
  /*  403 */ "compare_op",
  /*  404 */ "in_op",
  /*  405 */ "in_predicate_value",
  /*  406 */ "boolean_value_expression",
  /*  407 */ "boolean_primary",
  /*  408 */ "from_clause_opt",
  /*  409 */ "table_reference_list",
  /*  410 */ "table_reference",
  /*  411 */ "table_primary",
  /*  412 */ "joined_table",
  /*  413 */ "alias_opt",
  /*  414 */ "parenthesized_joined_table",
  /*  415 */ "join_type",
  /*  416 */ "search_condition",
  /*  417 */ "query_specification",
  /*  418 */ "set_quantifier_opt",
  /*  419 */ "select_list",
  /*  420 */ "partition_by_clause_opt",
  /*  421 */ "range_opt",
  /*  422 */ "every_opt",
  /*  423 */ "fill_opt",
  /*  424 */ "twindow_clause_opt",
  /*  425 */ "group_by_clause_opt",
  /*  426 */ "having_clause_opt",
  /*  427 */ "select_item",
  /*  428 */ "fill_mode",
  /*  429 */ "group_by_list",
  /*  430 */ "query_expression",
  /*  431 */ "query_simple",
  /*  432 */ "order_by_clause_opt",
  /*  433 */ "slimit_clause_opt",
  /*  434 */ "limit_clause_opt",
  /*  435 */ "union_query_expression",
  /*  436 */ "query_simple_or_subquery",
  /*  437 */ "sort_specification_list",
  /*  438 */ "sort_specification",
  /*  439 */ "ordering_specification_opt",
  /*  440 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options KEEP integer_list",
 /*  82 */ "db_options ::= db_options KEEP variable_list",
 /*  83 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  84 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  85 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  86 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  87 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  88 */ "db_options ::= db_options STRICT NK_STRING",
 /*  89 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  90 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  91 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  92 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  93 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  94 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 102 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 103 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 104 */ "alter_db_options ::= alter_db_option",
 /* 105 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 106 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 107 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 108 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 109 */ "alter_db_option ::= KEEP integer_list",
 /* 110 */ "alter_db_option ::= KEEP variable_list",
 /* 111 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 112 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 113 */ "integer_list ::= NK_INTEGER",
 /* 114 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 115 */ "variable_list ::= NK_VARIABLE",
 /* 116 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 117 */ "retention_list ::= retention",
 /* 118 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 119 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 120 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 121 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 122 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 123 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 124 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 125 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 126 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 127 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 128 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 129 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 130 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 131 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 132 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 133 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 134 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 135 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 136 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 137 */ "multi_create_clause ::= create_subtable_clause",
 /* 138 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 139 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 140 */ "multi_drop_clause ::= drop_table_clause",
 /* 141 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 142 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 143 */ "specific_cols_opt ::=",
 /* 144 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 145 */ "full_table_name ::= table_name",
 /* 146 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 147 */ "column_def_list ::= column_def",
 /* 148 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 149 */ "column_def ::= column_name type_name",
 /* 150 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 151 */ "type_name ::= BOOL",
 /* 152 */ "type_name ::= TINYINT",
 /* 153 */ "type_name ::= SMALLINT",
 /* 154 */ "type_name ::= INT",
 /* 155 */ "type_name ::= INTEGER",
 /* 156 */ "type_name ::= BIGINT",
 /* 157 */ "type_name ::= FLOAT",
 /* 158 */ "type_name ::= DOUBLE",
 /* 159 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 160 */ "type_name ::= TIMESTAMP",
 /* 161 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 162 */ "type_name ::= TINYINT UNSIGNED",
 /* 163 */ "type_name ::= SMALLINT UNSIGNED",
 /* 164 */ "type_name ::= INT UNSIGNED",
 /* 165 */ "type_name ::= BIGINT UNSIGNED",
 /* 166 */ "type_name ::= JSON",
 /* 167 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= MEDIUMBLOB",
 /* 169 */ "type_name ::= BLOB",
 /* 170 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 171 */ "type_name ::= DECIMAL",
 /* 172 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 173 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 174 */ "tags_def_opt ::=",
 /* 175 */ "tags_def_opt ::= tags_def",
 /* 176 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 177 */ "table_options ::=",
 /* 178 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 179 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 180 */ "table_options ::= table_options WATERMARK duration_list",
 /* 181 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 182 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 183 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 184 */ "alter_table_options ::= alter_table_option",
 /* 185 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 186 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 187 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 188 */ "duration_list ::= duration_literal",
 /* 189 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 190 */ "rollup_func_list ::= rollup_func_name",
 /* 191 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 192 */ "rollup_func_name ::= function_name",
 /* 193 */ "rollup_func_name ::= FIRST",
 /* 194 */ "rollup_func_name ::= LAST",
 /* 195 */ "col_name_list ::= col_name",
 /* 196 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 197 */ "col_name ::= column_name",
 /* 198 */ "cmd ::= SHOW DNODES",
 /* 199 */ "cmd ::= SHOW USERS",
 /* 200 */ "cmd ::= SHOW DATABASES",
 /* 201 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 202 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 203 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 204 */ "cmd ::= SHOW MNODES",
 /* 205 */ "cmd ::= SHOW MODULES",
 /* 206 */ "cmd ::= SHOW QNODES",
 /* 207 */ "cmd ::= SHOW FUNCTIONS",
 /* 208 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 209 */ "cmd ::= SHOW STREAMS",
 /* 210 */ "cmd ::= SHOW ACCOUNTS",
 /* 211 */ "cmd ::= SHOW APPS",
 /* 212 */ "cmd ::= SHOW CONNECTIONS",
 /* 213 */ "cmd ::= SHOW LICENCES",
 /* 214 */ "cmd ::= SHOW GRANTS",
 /* 215 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 216 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 217 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 218 */ "cmd ::= SHOW QUERIES",
 /* 219 */ "cmd ::= SHOW SCORES",
 /* 220 */ "cmd ::= SHOW TOPICS",
 /* 221 */ "cmd ::= SHOW VARIABLES",
 /* 222 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 223 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 224 */ "cmd ::= SHOW BNODES",
 /* 225 */ "cmd ::= SHOW SNODES",
 /* 226 */ "cmd ::= SHOW CLUSTER",
 /* 227 */ "cmd ::= SHOW TRANSACTIONS",
 /* 228 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 229 */ "cmd ::= SHOW CONSUMERS",
 /* 230 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 231 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 232 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 233 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 234 */ "db_name_cond_opt ::=",
 /* 235 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 236 */ "like_pattern_opt ::=",
 /* 237 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 238 */ "table_name_cond ::= table_name",
 /* 239 */ "from_db_opt ::=",
 /* 240 */ "from_db_opt ::= FROM db_name",
 /* 241 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 242 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 243 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 244 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 245 */ "func_list ::= func",
 /* 246 */ "func_list ::= func_list NK_COMMA func",
 /* 247 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 248 */ "sma_stream_opt ::=",
 /* 249 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 250 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 251 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 252 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 253 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 254 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 255 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 256 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 257 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 258 */ "cmd ::= DESC full_table_name",
 /* 259 */ "cmd ::= DESCRIBE full_table_name",
 /* 260 */ "cmd ::= RESET QUERY CACHE",
 /* 261 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 262 */ "analyze_opt ::=",
 /* 263 */ "analyze_opt ::= ANALYZE",
 /* 264 */ "explain_options ::=",
 /* 265 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 266 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 267 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 268 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 269 */ "agg_func_opt ::=",
 /* 270 */ "agg_func_opt ::= AGGREGATE",
 /* 271 */ "bufsize_opt ::=",
 /* 272 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 273 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name AS query_or_subquery",
 /* 274 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 275 */ "stream_options ::=",
 /* 276 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 277 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 278 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 279 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 280 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 281 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 282 */ "cmd ::= KILL QUERY NK_STRING",
 /* 283 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 284 */ "cmd ::= BALANCE VGROUP",
 /* 285 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 286 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 287 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 288 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 289 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 290 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 291 */ "cmd ::= query_or_subquery",
 /* 292 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 293 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 294 */ "literal ::= NK_INTEGER",
 /* 295 */ "literal ::= NK_FLOAT",
 /* 296 */ "literal ::= NK_STRING",
 /* 297 */ "literal ::= NK_BOOL",
 /* 298 */ "literal ::= TIMESTAMP NK_STRING",
 /* 299 */ "literal ::= duration_literal",
 /* 300 */ "literal ::= NULL",
 /* 301 */ "literal ::= NK_QUESTION",
 /* 302 */ "duration_literal ::= NK_VARIABLE",
 /* 303 */ "signed ::= NK_INTEGER",
 /* 304 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 305 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 306 */ "signed ::= NK_FLOAT",
 /* 307 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 308 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 309 */ "signed_literal ::= signed",
 /* 310 */ "signed_literal ::= NK_STRING",
 /* 311 */ "signed_literal ::= NK_BOOL",
 /* 312 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 313 */ "signed_literal ::= duration_literal",
 /* 314 */ "signed_literal ::= NULL",
 /* 315 */ "signed_literal ::= literal_func",
 /* 316 */ "signed_literal ::= NK_QUESTION",
 /* 317 */ "literal_list ::= signed_literal",
 /* 318 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 319 */ "db_name ::= NK_ID",
 /* 320 */ "table_name ::= NK_ID",
 /* 321 */ "column_name ::= NK_ID",
 /* 322 */ "function_name ::= NK_ID",
 /* 323 */ "table_alias ::= NK_ID",
 /* 324 */ "column_alias ::= NK_ID",
 /* 325 */ "user_name ::= NK_ID",
 /* 326 */ "topic_name ::= NK_ID",
 /* 327 */ "stream_name ::= NK_ID",
 /* 328 */ "cgroup_name ::= NK_ID",
 /* 329 */ "expr_or_subquery ::= expression",
 /* 330 */ "expr_or_subquery ::= subquery",
 /* 331 */ "expression ::= literal",
 /* 332 */ "expression ::= pseudo_column",
 /* 333 */ "expression ::= column_reference",
 /* 334 */ "expression ::= function_expression",
 /* 335 */ "expression ::= case_when_expression",
 /* 336 */ "expression ::= NK_LP expression NK_RP",
 /* 337 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 338 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 339 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 340 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 341 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 342 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 343 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 344 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 345 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 346 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 347 */ "expression_list ::= expr_or_subquery",
 /* 348 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 349 */ "column_reference ::= column_name",
 /* 350 */ "column_reference ::= table_name NK_DOT column_name",
 /* 351 */ "pseudo_column ::= ROWTS",
 /* 352 */ "pseudo_column ::= TBNAME",
 /* 353 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 354 */ "pseudo_column ::= QSTART",
 /* 355 */ "pseudo_column ::= QEND",
 /* 356 */ "pseudo_column ::= QDURATION",
 /* 357 */ "pseudo_column ::= WSTART",
 /* 358 */ "pseudo_column ::= WEND",
 /* 359 */ "pseudo_column ::= WDURATION",
 /* 360 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 361 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 362 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 363 */ "function_expression ::= literal_func",
 /* 364 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 365 */ "literal_func ::= NOW",
 /* 366 */ "noarg_func ::= NOW",
 /* 367 */ "noarg_func ::= TODAY",
 /* 368 */ "noarg_func ::= TIMEZONE",
 /* 369 */ "noarg_func ::= DATABASE",
 /* 370 */ "noarg_func ::= CLIENT_VERSION",
 /* 371 */ "noarg_func ::= SERVER_VERSION",
 /* 372 */ "noarg_func ::= SERVER_STATUS",
 /* 373 */ "noarg_func ::= CURRENT_USER",
 /* 374 */ "noarg_func ::= USER",
 /* 375 */ "star_func ::= COUNT",
 /* 376 */ "star_func ::= FIRST",
 /* 377 */ "star_func ::= LAST",
 /* 378 */ "star_func ::= LAST_ROW",
 /* 379 */ "star_func_para_list ::= NK_STAR",
 /* 380 */ "star_func_para_list ::= other_para_list",
 /* 381 */ "other_para_list ::= star_func_para",
 /* 382 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 383 */ "star_func_para ::= expr_or_subquery",
 /* 384 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 385 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 386 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 387 */ "when_then_list ::= when_then_expr",
 /* 388 */ "when_then_list ::= when_then_list when_then_expr",
 /* 389 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 390 */ "case_when_else_opt ::=",
 /* 391 */ "case_when_else_opt ::= ELSE common_expression",
 /* 392 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 393 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 394 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 395 */ "predicate ::= expr_or_subquery IS NULL",
 /* 396 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 397 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 398 */ "compare_op ::= NK_LT",
 /* 399 */ "compare_op ::= NK_GT",
 /* 400 */ "compare_op ::= NK_LE",
 /* 401 */ "compare_op ::= NK_GE",
 /* 402 */ "compare_op ::= NK_NE",
 /* 403 */ "compare_op ::= NK_EQ",
 /* 404 */ "compare_op ::= LIKE",
 /* 405 */ "compare_op ::= NOT LIKE",
 /* 406 */ "compare_op ::= MATCH",
 /* 407 */ "compare_op ::= NMATCH",
 /* 408 */ "compare_op ::= CONTAINS",
 /* 409 */ "in_op ::= IN",
 /* 410 */ "in_op ::= NOT IN",
 /* 411 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 412 */ "boolean_value_expression ::= boolean_primary",
 /* 413 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 414 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 415 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 416 */ "boolean_primary ::= predicate",
 /* 417 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 418 */ "common_expression ::= expr_or_subquery",
 /* 419 */ "common_expression ::= boolean_value_expression",
 /* 420 */ "from_clause_opt ::=",
 /* 421 */ "from_clause_opt ::= FROM table_reference_list",
 /* 422 */ "table_reference_list ::= table_reference",
 /* 423 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 424 */ "table_reference ::= table_primary",
 /* 425 */ "table_reference ::= joined_table",
 /* 426 */ "table_primary ::= table_name alias_opt",
 /* 427 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 428 */ "table_primary ::= subquery alias_opt",
 /* 429 */ "table_primary ::= parenthesized_joined_table",
 /* 430 */ "alias_opt ::=",
 /* 431 */ "alias_opt ::= table_alias",
 /* 432 */ "alias_opt ::= AS table_alias",
 /* 433 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 434 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 435 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 436 */ "join_type ::=",
 /* 437 */ "join_type ::= INNER",
 /* 438 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 439 */ "set_quantifier_opt ::=",
 /* 440 */ "set_quantifier_opt ::= DISTINCT",
 /* 441 */ "set_quantifier_opt ::= ALL",
 /* 442 */ "select_list ::= select_item",
 /* 443 */ "select_list ::= select_list NK_COMMA select_item",
 /* 444 */ "select_item ::= NK_STAR",
 /* 445 */ "select_item ::= common_expression",
 /* 446 */ "select_item ::= common_expression column_alias",
 /* 447 */ "select_item ::= common_expression AS column_alias",
 /* 448 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 449 */ "where_clause_opt ::=",
 /* 450 */ "where_clause_opt ::= WHERE search_condition",
 /* 451 */ "partition_by_clause_opt ::=",
 /* 452 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 453 */ "twindow_clause_opt ::=",
 /* 454 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 455 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 456 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 457 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 458 */ "sliding_opt ::=",
 /* 459 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 460 */ "fill_opt ::=",
 /* 461 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 462 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 463 */ "fill_mode ::= NONE",
 /* 464 */ "fill_mode ::= PREV",
 /* 465 */ "fill_mode ::= NULL",
 /* 466 */ "fill_mode ::= LINEAR",
 /* 467 */ "fill_mode ::= NEXT",
 /* 468 */ "group_by_clause_opt ::=",
 /* 469 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 470 */ "group_by_list ::= expr_or_subquery",
 /* 471 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 472 */ "having_clause_opt ::=",
 /* 473 */ "having_clause_opt ::= HAVING search_condition",
 /* 474 */ "range_opt ::=",
 /* 475 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 476 */ "every_opt ::=",
 /* 477 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 478 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 479 */ "query_simple ::= query_specification",
 /* 480 */ "query_simple ::= union_query_expression",
 /* 481 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 482 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 483 */ "query_simple_or_subquery ::= query_simple",
 /* 484 */ "query_simple_or_subquery ::= subquery",
 /* 485 */ "query_or_subquery ::= query_expression",
 /* 486 */ "query_or_subquery ::= subquery",
 /* 487 */ "order_by_clause_opt ::=",
 /* 488 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 489 */ "slimit_clause_opt ::=",
 /* 490 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 491 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 492 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 493 */ "limit_clause_opt ::=",
 /* 494 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 495 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 496 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 497 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 498 */ "subquery ::= NK_LP subquery NK_RP",
 /* 499 */ "search_condition ::= common_expression",
 /* 500 */ "sort_specification_list ::= sort_specification",
 /* 501 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 502 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 503 */ "ordering_specification_opt ::=",
 /* 504 */ "ordering_specification_opt ::= ASC",
 /* 505 */ "ordering_specification_opt ::= DESC",
 /* 506 */ "null_ordering_opt ::=",
 /* 507 */ "null_ordering_opt ::= NULLS FIRST",
 /* 508 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 313: /* cmd */
    case 316: /* literal */
    case 327: /* db_options */
    case 329: /* alter_db_options */
    case 334: /* retention */
    case 335: /* full_table_name */
    case 338: /* table_options */
    case 342: /* alter_table_clause */
    case 343: /* alter_table_options */
    case 346: /* signed_literal */
    case 347: /* create_subtable_clause */
    case 350: /* drop_table_clause */
    case 353: /* column_def */
    case 357: /* duration_literal */
    case 358: /* rollup_func_name */
    case 360: /* col_name */
    case 361: /* db_name_cond_opt */
    case 362: /* like_pattern_opt */
    case 363: /* table_name_cond */
    case 364: /* from_db_opt */
    case 365: /* index_options */
    case 367: /* sliding_opt */
    case 368: /* sma_stream_opt */
    case 369: /* func */
    case 370: /* stream_options */
    case 372: /* query_or_subquery */
    case 375: /* explain_options */
    case 380: /* where_clause_opt */
    case 381: /* signed */
    case 382: /* literal_func */
    case 386: /* expr_or_subquery */
    case 387: /* expression */
    case 388: /* subquery */
    case 389: /* pseudo_column */
    case 390: /* column_reference */
    case 391: /* function_expression */
    case 392: /* case_when_expression */
    case 397: /* star_func_para */
    case 399: /* case_when_else_opt */
    case 400: /* common_expression */
    case 401: /* when_then_expr */
    case 402: /* predicate */
    case 405: /* in_predicate_value */
    case 406: /* boolean_value_expression */
    case 407: /* boolean_primary */
    case 408: /* from_clause_opt */
    case 409: /* table_reference_list */
    case 410: /* table_reference */
    case 411: /* table_primary */
    case 412: /* joined_table */
    case 414: /* parenthesized_joined_table */
    case 416: /* search_condition */
    case 417: /* query_specification */
    case 421: /* range_opt */
    case 422: /* every_opt */
    case 423: /* fill_opt */
    case 424: /* twindow_clause_opt */
    case 426: /* having_clause_opt */
    case 427: /* select_item */
    case 430: /* query_expression */
    case 431: /* query_simple */
    case 433: /* slimit_clause_opt */
    case 434: /* limit_clause_opt */
    case 435: /* union_query_expression */
    case 436: /* query_simple_or_subquery */
    case 438: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy560)); 
}
      break;
    case 314: /* account_options */
    case 315: /* alter_account_options */
    case 317: /* alter_account_option */
    case 377: /* bufsize_opt */
{
 
}
      break;
    case 318: /* user_name */
    case 321: /* priv_level */
    case 324: /* db_name */
    case 325: /* dnode_endpoint */
    case 344: /* column_name */
    case 352: /* table_name */
    case 359: /* function_name */
    case 371: /* topic_name */
    case 373: /* cgroup_name */
    case 378: /* stream_name */
    case 384: /* table_alias */
    case 385: /* column_alias */
    case 393: /* star_func */
    case 395: /* noarg_func */
    case 413: /* alias_opt */
{
 
}
      break;
    case 319: /* sysinfo_opt */
{
 
}
      break;
    case 320: /* privileges */
    case 322: /* priv_type_list */
    case 323: /* priv_type */
{
 
}
      break;
    case 326: /* not_exists_opt */
    case 328: /* exists_opt */
    case 374: /* analyze_opt */
    case 376: /* agg_func_opt */
    case 418: /* set_quantifier_opt */
{
 
}
      break;
    case 330: /* integer_list */
    case 331: /* variable_list */
    case 332: /* retention_list */
    case 336: /* column_def_list */
    case 337: /* tags_def_opt */
    case 339: /* multi_create_clause */
    case 340: /* tags_def */
    case 341: /* multi_drop_clause */
    case 348: /* specific_cols_opt */
    case 349: /* expression_list */
    case 351: /* col_name_list */
    case 354: /* duration_list */
    case 355: /* rollup_func_list */
    case 366: /* func_list */
    case 379: /* dnode_list */
    case 383: /* literal_list */
    case 394: /* star_func_para_list */
    case 396: /* other_para_list */
    case 398: /* when_then_list */
    case 419: /* select_list */
    case 420: /* partition_by_clause_opt */
    case 425: /* group_by_clause_opt */
    case 429: /* group_by_list */
    case 432: /* order_by_clause_opt */
    case 437: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy334)); 
}
      break;
    case 333: /* alter_db_option */
    case 356: /* alter_table_option */
{
 
}
      break;
    case 345: /* type_name */
{
 
}
      break;
    case 403: /* compare_op */
    case 404: /* in_op */
{
 
}
      break;
    case 415: /* join_type */
{
 
}
      break;
    case 428: /* fill_mode */
{
 
}
      break;
    case 439: /* ordering_specification_opt */
{
 
}
      break;
    case 440: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  313,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  313,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  314,    0 }, /* (2) account_options ::= */
  {  314,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  314,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  314,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  314,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  314,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  314,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  314,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  314,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  314,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  315,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  315,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  317,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  317,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  317,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  317,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  317,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  317,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  317,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  317,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  317,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  317,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  313,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  313,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  313,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  313,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  313,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  319,    0 }, /* (29) sysinfo_opt ::= */
  {  319,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  313,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  313,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  320,   -1 }, /* (33) privileges ::= ALL */
  {  320,   -1 }, /* (34) privileges ::= priv_type_list */
  {  322,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  322,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  323,   -1 }, /* (37) priv_type ::= READ */
  {  323,   -1 }, /* (38) priv_type ::= WRITE */
  {  321,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  321,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  313,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  313,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  313,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  313,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  313,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  313,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  313,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  313,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  325,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  325,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  325,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  313,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  313,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  313,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  313,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  313,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  313,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  313,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  313,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  313,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  313,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  313,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  313,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  313,   -2 }, /* (64) cmd ::= USE db_name */
  {  313,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  313,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  313,   -3 }, /* (67) cmd ::= TRIM DATABASE db_name */
  {  326,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  326,    0 }, /* (69) not_exists_opt ::= */
  {  328,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  328,    0 }, /* (71) exists_opt ::= */
  {  327,    0 }, /* (72) db_options ::= */
  {  327,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  327,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  327,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  327,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  327,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  327,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  327,   -3 }, /* (79) db_options ::= db_options MAXROWS NK_INTEGER */
  {  327,   -3 }, /* (80) db_options ::= db_options MINROWS NK_INTEGER */
  {  327,   -3 }, /* (81) db_options ::= db_options KEEP integer_list */
  {  327,   -3 }, /* (82) db_options ::= db_options KEEP variable_list */
  {  327,   -3 }, /* (83) db_options ::= db_options PAGES NK_INTEGER */
  {  327,   -3 }, /* (84) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  327,   -3 }, /* (85) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  327,   -3 }, /* (86) db_options ::= db_options PRECISION NK_STRING */
  {  327,   -3 }, /* (87) db_options ::= db_options REPLICA NK_INTEGER */
  {  327,   -3 }, /* (88) db_options ::= db_options STRICT NK_STRING */
  {  327,   -3 }, /* (89) db_options ::= db_options VGROUPS NK_INTEGER */
  {  327,   -3 }, /* (90) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  327,   -3 }, /* (91) db_options ::= db_options RETENTIONS retention_list */
  {  327,   -3 }, /* (92) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  327,   -3 }, /* (93) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  327,   -3 }, /* (94) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  327,   -3 }, /* (95) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  327,   -4 }, /* (96) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  327,   -3 }, /* (97) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  327,   -4 }, /* (98) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  327,   -3 }, /* (99) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  327,   -3 }, /* (100) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  327,   -3 }, /* (101) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  327,   -3 }, /* (102) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  327,   -3 }, /* (103) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  329,   -1 }, /* (104) alter_db_options ::= alter_db_option */
  {  329,   -2 }, /* (105) alter_db_options ::= alter_db_options alter_db_option */
  {  333,   -2 }, /* (106) alter_db_option ::= CACHEMODEL NK_STRING */
  {  333,   -2 }, /* (107) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  333,   -2 }, /* (108) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  333,   -2 }, /* (109) alter_db_option ::= KEEP integer_list */
  {  333,   -2 }, /* (110) alter_db_option ::= KEEP variable_list */
  {  333,   -2 }, /* (111) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  333,   -2 }, /* (112) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  330,   -1 }, /* (113) integer_list ::= NK_INTEGER */
  {  330,   -3 }, /* (114) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  331,   -1 }, /* (115) variable_list ::= NK_VARIABLE */
  {  331,   -3 }, /* (116) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  332,   -1 }, /* (117) retention_list ::= retention */
  {  332,   -3 }, /* (118) retention_list ::= retention_list NK_COMMA retention */
  {  334,   -3 }, /* (119) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  313,   -9 }, /* (120) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  313,   -3 }, /* (121) cmd ::= CREATE TABLE multi_create_clause */
  {  313,   -9 }, /* (122) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  313,   -3 }, /* (123) cmd ::= DROP TABLE multi_drop_clause */
  {  313,   -4 }, /* (124) cmd ::= DROP STABLE exists_opt full_table_name */
  {  313,   -3 }, /* (125) cmd ::= ALTER TABLE alter_table_clause */
  {  313,   -3 }, /* (126) cmd ::= ALTER STABLE alter_table_clause */
  {  342,   -2 }, /* (127) alter_table_clause ::= full_table_name alter_table_options */
  {  342,   -5 }, /* (128) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  342,   -4 }, /* (129) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  342,   -5 }, /* (130) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  342,   -5 }, /* (131) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  342,   -5 }, /* (132) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  342,   -4 }, /* (133) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  342,   -5 }, /* (134) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  342,   -5 }, /* (135) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  342,   -6 }, /* (136) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  339,   -1 }, /* (137) multi_create_clause ::= create_subtable_clause */
  {  339,   -2 }, /* (138) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  347,  -10 }, /* (139) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  341,   -1 }, /* (140) multi_drop_clause ::= drop_table_clause */
  {  341,   -2 }, /* (141) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  350,   -2 }, /* (142) drop_table_clause ::= exists_opt full_table_name */
  {  348,    0 }, /* (143) specific_cols_opt ::= */
  {  348,   -3 }, /* (144) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  335,   -1 }, /* (145) full_table_name ::= table_name */
  {  335,   -3 }, /* (146) full_table_name ::= db_name NK_DOT table_name */
  {  336,   -1 }, /* (147) column_def_list ::= column_def */
  {  336,   -3 }, /* (148) column_def_list ::= column_def_list NK_COMMA column_def */
  {  353,   -2 }, /* (149) column_def ::= column_name type_name */
  {  353,   -4 }, /* (150) column_def ::= column_name type_name COMMENT NK_STRING */
  {  345,   -1 }, /* (151) type_name ::= BOOL */
  {  345,   -1 }, /* (152) type_name ::= TINYINT */
  {  345,   -1 }, /* (153) type_name ::= SMALLINT */
  {  345,   -1 }, /* (154) type_name ::= INT */
  {  345,   -1 }, /* (155) type_name ::= INTEGER */
  {  345,   -1 }, /* (156) type_name ::= BIGINT */
  {  345,   -1 }, /* (157) type_name ::= FLOAT */
  {  345,   -1 }, /* (158) type_name ::= DOUBLE */
  {  345,   -4 }, /* (159) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  345,   -1 }, /* (160) type_name ::= TIMESTAMP */
  {  345,   -4 }, /* (161) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  345,   -2 }, /* (162) type_name ::= TINYINT UNSIGNED */
  {  345,   -2 }, /* (163) type_name ::= SMALLINT UNSIGNED */
  {  345,   -2 }, /* (164) type_name ::= INT UNSIGNED */
  {  345,   -2 }, /* (165) type_name ::= BIGINT UNSIGNED */
  {  345,   -1 }, /* (166) type_name ::= JSON */
  {  345,   -4 }, /* (167) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  345,   -1 }, /* (168) type_name ::= MEDIUMBLOB */
  {  345,   -1 }, /* (169) type_name ::= BLOB */
  {  345,   -4 }, /* (170) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  345,   -1 }, /* (171) type_name ::= DECIMAL */
  {  345,   -4 }, /* (172) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  345,   -6 }, /* (173) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  337,    0 }, /* (174) tags_def_opt ::= */
  {  337,   -1 }, /* (175) tags_def_opt ::= tags_def */
  {  340,   -4 }, /* (176) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  338,    0 }, /* (177) table_options ::= */
  {  338,   -3 }, /* (178) table_options ::= table_options COMMENT NK_STRING */
  {  338,   -3 }, /* (179) table_options ::= table_options MAX_DELAY duration_list */
  {  338,   -3 }, /* (180) table_options ::= table_options WATERMARK duration_list */
  {  338,   -5 }, /* (181) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  338,   -3 }, /* (182) table_options ::= table_options TTL NK_INTEGER */
  {  338,   -5 }, /* (183) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  343,   -1 }, /* (184) alter_table_options ::= alter_table_option */
  {  343,   -2 }, /* (185) alter_table_options ::= alter_table_options alter_table_option */
  {  356,   -2 }, /* (186) alter_table_option ::= COMMENT NK_STRING */
  {  356,   -2 }, /* (187) alter_table_option ::= TTL NK_INTEGER */
  {  354,   -1 }, /* (188) duration_list ::= duration_literal */
  {  354,   -3 }, /* (189) duration_list ::= duration_list NK_COMMA duration_literal */
  {  355,   -1 }, /* (190) rollup_func_list ::= rollup_func_name */
  {  355,   -3 }, /* (191) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  358,   -1 }, /* (192) rollup_func_name ::= function_name */
  {  358,   -1 }, /* (193) rollup_func_name ::= FIRST */
  {  358,   -1 }, /* (194) rollup_func_name ::= LAST */
  {  351,   -1 }, /* (195) col_name_list ::= col_name */
  {  351,   -3 }, /* (196) col_name_list ::= col_name_list NK_COMMA col_name */
  {  360,   -1 }, /* (197) col_name ::= column_name */
  {  313,   -2 }, /* (198) cmd ::= SHOW DNODES */
  {  313,   -2 }, /* (199) cmd ::= SHOW USERS */
  {  313,   -2 }, /* (200) cmd ::= SHOW DATABASES */
  {  313,   -4 }, /* (201) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  313,   -4 }, /* (202) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  313,   -3 }, /* (203) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  313,   -2 }, /* (204) cmd ::= SHOW MNODES */
  {  313,   -2 }, /* (205) cmd ::= SHOW MODULES */
  {  313,   -2 }, /* (206) cmd ::= SHOW QNODES */
  {  313,   -2 }, /* (207) cmd ::= SHOW FUNCTIONS */
  {  313,   -5 }, /* (208) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  313,   -2 }, /* (209) cmd ::= SHOW STREAMS */
  {  313,   -2 }, /* (210) cmd ::= SHOW ACCOUNTS */
  {  313,   -2 }, /* (211) cmd ::= SHOW APPS */
  {  313,   -2 }, /* (212) cmd ::= SHOW CONNECTIONS */
  {  313,   -2 }, /* (213) cmd ::= SHOW LICENCES */
  {  313,   -2 }, /* (214) cmd ::= SHOW GRANTS */
  {  313,   -4 }, /* (215) cmd ::= SHOW CREATE DATABASE db_name */
  {  313,   -4 }, /* (216) cmd ::= SHOW CREATE TABLE full_table_name */
  {  313,   -4 }, /* (217) cmd ::= SHOW CREATE STABLE full_table_name */
  {  313,   -2 }, /* (218) cmd ::= SHOW QUERIES */
  {  313,   -2 }, /* (219) cmd ::= SHOW SCORES */
  {  313,   -2 }, /* (220) cmd ::= SHOW TOPICS */
  {  313,   -2 }, /* (221) cmd ::= SHOW VARIABLES */
  {  313,   -3 }, /* (222) cmd ::= SHOW LOCAL VARIABLES */
  {  313,   -4 }, /* (223) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  313,   -2 }, /* (224) cmd ::= SHOW BNODES */
  {  313,   -2 }, /* (225) cmd ::= SHOW SNODES */
  {  313,   -2 }, /* (226) cmd ::= SHOW CLUSTER */
  {  313,   -2 }, /* (227) cmd ::= SHOW TRANSACTIONS */
  {  313,   -4 }, /* (228) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  313,   -2 }, /* (229) cmd ::= SHOW CONSUMERS */
  {  313,   -2 }, /* (230) cmd ::= SHOW SUBSCRIPTIONS */
  {  313,   -5 }, /* (231) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  313,   -3 }, /* (232) cmd ::= SHOW VNODES NK_INTEGER */
  {  313,   -3 }, /* (233) cmd ::= SHOW VNODES NK_STRING */
  {  361,    0 }, /* (234) db_name_cond_opt ::= */
  {  361,   -2 }, /* (235) db_name_cond_opt ::= db_name NK_DOT */
  {  362,    0 }, /* (236) like_pattern_opt ::= */
  {  362,   -2 }, /* (237) like_pattern_opt ::= LIKE NK_STRING */
  {  363,   -1 }, /* (238) table_name_cond ::= table_name */
  {  364,    0 }, /* (239) from_db_opt ::= */
  {  364,   -2 }, /* (240) from_db_opt ::= FROM db_name */
  {  313,   -8 }, /* (241) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  313,   -4 }, /* (242) cmd ::= DROP INDEX exists_opt full_table_name */
  {  365,  -10 }, /* (243) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  365,  -12 }, /* (244) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  366,   -1 }, /* (245) func_list ::= func */
  {  366,   -3 }, /* (246) func_list ::= func_list NK_COMMA func */
  {  369,   -4 }, /* (247) func ::= function_name NK_LP expression_list NK_RP */
  {  368,    0 }, /* (248) sma_stream_opt ::= */
  {  368,   -3 }, /* (249) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  368,   -3 }, /* (250) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  313,   -6 }, /* (251) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  313,   -7 }, /* (252) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  313,   -9 }, /* (253) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  313,   -7 }, /* (254) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  313,   -9 }, /* (255) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  313,   -4 }, /* (256) cmd ::= DROP TOPIC exists_opt topic_name */
  {  313,   -7 }, /* (257) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  313,   -2 }, /* (258) cmd ::= DESC full_table_name */
  {  313,   -2 }, /* (259) cmd ::= DESCRIBE full_table_name */
  {  313,   -3 }, /* (260) cmd ::= RESET QUERY CACHE */
  {  313,   -4 }, /* (261) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  374,    0 }, /* (262) analyze_opt ::= */
  {  374,   -1 }, /* (263) analyze_opt ::= ANALYZE */
  {  375,    0 }, /* (264) explain_options ::= */
  {  375,   -3 }, /* (265) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  375,   -3 }, /* (266) explain_options ::= explain_options RATIO NK_FLOAT */
  {  313,  -10 }, /* (267) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  313,   -4 }, /* (268) cmd ::= DROP FUNCTION exists_opt function_name */
  {  376,    0 }, /* (269) agg_func_opt ::= */
  {  376,   -1 }, /* (270) agg_func_opt ::= AGGREGATE */
  {  377,    0 }, /* (271) bufsize_opt ::= */
  {  377,   -2 }, /* (272) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  313,   -9 }, /* (273) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name AS query_or_subquery */
  {  313,   -4 }, /* (274) cmd ::= DROP STREAM exists_opt stream_name */
  {  370,    0 }, /* (275) stream_options ::= */
  {  370,   -3 }, /* (276) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  370,   -3 }, /* (277) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  370,   -4 }, /* (278) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  370,   -3 }, /* (279) stream_options ::= stream_options WATERMARK duration_literal */
  {  370,   -4 }, /* (280) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  313,   -3 }, /* (281) cmd ::= KILL CONNECTION NK_INTEGER */
  {  313,   -3 }, /* (282) cmd ::= KILL QUERY NK_STRING */
  {  313,   -3 }, /* (283) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  313,   -2 }, /* (284) cmd ::= BALANCE VGROUP */
  {  313,   -4 }, /* (285) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  313,   -4 }, /* (286) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  313,   -3 }, /* (287) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  379,   -2 }, /* (288) dnode_list ::= DNODE NK_INTEGER */
  {  379,   -3 }, /* (289) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  313,   -4 }, /* (290) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  313,   -1 }, /* (291) cmd ::= query_or_subquery */
  {  313,   -7 }, /* (292) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  313,   -4 }, /* (293) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  316,   -1 }, /* (294) literal ::= NK_INTEGER */
  {  316,   -1 }, /* (295) literal ::= NK_FLOAT */
  {  316,   -1 }, /* (296) literal ::= NK_STRING */
  {  316,   -1 }, /* (297) literal ::= NK_BOOL */
  {  316,   -2 }, /* (298) literal ::= TIMESTAMP NK_STRING */
  {  316,   -1 }, /* (299) literal ::= duration_literal */
  {  316,   -1 }, /* (300) literal ::= NULL */
  {  316,   -1 }, /* (301) literal ::= NK_QUESTION */
  {  357,   -1 }, /* (302) duration_literal ::= NK_VARIABLE */
  {  381,   -1 }, /* (303) signed ::= NK_INTEGER */
  {  381,   -2 }, /* (304) signed ::= NK_PLUS NK_INTEGER */
  {  381,   -2 }, /* (305) signed ::= NK_MINUS NK_INTEGER */
  {  381,   -1 }, /* (306) signed ::= NK_FLOAT */
  {  381,   -2 }, /* (307) signed ::= NK_PLUS NK_FLOAT */
  {  381,   -2 }, /* (308) signed ::= NK_MINUS NK_FLOAT */
  {  346,   -1 }, /* (309) signed_literal ::= signed */
  {  346,   -1 }, /* (310) signed_literal ::= NK_STRING */
  {  346,   -1 }, /* (311) signed_literal ::= NK_BOOL */
  {  346,   -2 }, /* (312) signed_literal ::= TIMESTAMP NK_STRING */
  {  346,   -1 }, /* (313) signed_literal ::= duration_literal */
  {  346,   -1 }, /* (314) signed_literal ::= NULL */
  {  346,   -1 }, /* (315) signed_literal ::= literal_func */
  {  346,   -1 }, /* (316) signed_literal ::= NK_QUESTION */
  {  383,   -1 }, /* (317) literal_list ::= signed_literal */
  {  383,   -3 }, /* (318) literal_list ::= literal_list NK_COMMA signed_literal */
  {  324,   -1 }, /* (319) db_name ::= NK_ID */
  {  352,   -1 }, /* (320) table_name ::= NK_ID */
  {  344,   -1 }, /* (321) column_name ::= NK_ID */
  {  359,   -1 }, /* (322) function_name ::= NK_ID */
  {  384,   -1 }, /* (323) table_alias ::= NK_ID */
  {  385,   -1 }, /* (324) column_alias ::= NK_ID */
  {  318,   -1 }, /* (325) user_name ::= NK_ID */
  {  371,   -1 }, /* (326) topic_name ::= NK_ID */
  {  378,   -1 }, /* (327) stream_name ::= NK_ID */
  {  373,   -1 }, /* (328) cgroup_name ::= NK_ID */
  {  386,   -1 }, /* (329) expr_or_subquery ::= expression */
  {  386,   -1 }, /* (330) expr_or_subquery ::= subquery */
  {  387,   -1 }, /* (331) expression ::= literal */
  {  387,   -1 }, /* (332) expression ::= pseudo_column */
  {  387,   -1 }, /* (333) expression ::= column_reference */
  {  387,   -1 }, /* (334) expression ::= function_expression */
  {  387,   -1 }, /* (335) expression ::= case_when_expression */
  {  387,   -3 }, /* (336) expression ::= NK_LP expression NK_RP */
  {  387,   -2 }, /* (337) expression ::= NK_PLUS expr_or_subquery */
  {  387,   -2 }, /* (338) expression ::= NK_MINUS expr_or_subquery */
  {  387,   -3 }, /* (339) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  387,   -3 }, /* (340) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  387,   -3 }, /* (341) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  387,   -3 }, /* (342) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  387,   -3 }, /* (343) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  387,   -3 }, /* (344) expression ::= column_reference NK_ARROW NK_STRING */
  {  387,   -3 }, /* (345) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  387,   -3 }, /* (346) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  349,   -1 }, /* (347) expression_list ::= expr_or_subquery */
  {  349,   -3 }, /* (348) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  390,   -1 }, /* (349) column_reference ::= column_name */
  {  390,   -3 }, /* (350) column_reference ::= table_name NK_DOT column_name */
  {  389,   -1 }, /* (351) pseudo_column ::= ROWTS */
  {  389,   -1 }, /* (352) pseudo_column ::= TBNAME */
  {  389,   -3 }, /* (353) pseudo_column ::= table_name NK_DOT TBNAME */
  {  389,   -1 }, /* (354) pseudo_column ::= QSTART */
  {  389,   -1 }, /* (355) pseudo_column ::= QEND */
  {  389,   -1 }, /* (356) pseudo_column ::= QDURATION */
  {  389,   -1 }, /* (357) pseudo_column ::= WSTART */
  {  389,   -1 }, /* (358) pseudo_column ::= WEND */
  {  389,   -1 }, /* (359) pseudo_column ::= WDURATION */
  {  391,   -4 }, /* (360) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  391,   -4 }, /* (361) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  391,   -6 }, /* (362) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  391,   -1 }, /* (363) function_expression ::= literal_func */
  {  382,   -3 }, /* (364) literal_func ::= noarg_func NK_LP NK_RP */
  {  382,   -1 }, /* (365) literal_func ::= NOW */
  {  395,   -1 }, /* (366) noarg_func ::= NOW */
  {  395,   -1 }, /* (367) noarg_func ::= TODAY */
  {  395,   -1 }, /* (368) noarg_func ::= TIMEZONE */
  {  395,   -1 }, /* (369) noarg_func ::= DATABASE */
  {  395,   -1 }, /* (370) noarg_func ::= CLIENT_VERSION */
  {  395,   -1 }, /* (371) noarg_func ::= SERVER_VERSION */
  {  395,   -1 }, /* (372) noarg_func ::= SERVER_STATUS */
  {  395,   -1 }, /* (373) noarg_func ::= CURRENT_USER */
  {  395,   -1 }, /* (374) noarg_func ::= USER */
  {  393,   -1 }, /* (375) star_func ::= COUNT */
  {  393,   -1 }, /* (376) star_func ::= FIRST */
  {  393,   -1 }, /* (377) star_func ::= LAST */
  {  393,   -1 }, /* (378) star_func ::= LAST_ROW */
  {  394,   -1 }, /* (379) star_func_para_list ::= NK_STAR */
  {  394,   -1 }, /* (380) star_func_para_list ::= other_para_list */
  {  396,   -1 }, /* (381) other_para_list ::= star_func_para */
  {  396,   -3 }, /* (382) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  397,   -1 }, /* (383) star_func_para ::= expr_or_subquery */
  {  397,   -3 }, /* (384) star_func_para ::= table_name NK_DOT NK_STAR */
  {  392,   -4 }, /* (385) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  392,   -5 }, /* (386) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  398,   -1 }, /* (387) when_then_list ::= when_then_expr */
  {  398,   -2 }, /* (388) when_then_list ::= when_then_list when_then_expr */
  {  401,   -4 }, /* (389) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  399,    0 }, /* (390) case_when_else_opt ::= */
  {  399,   -2 }, /* (391) case_when_else_opt ::= ELSE common_expression */
  {  402,   -3 }, /* (392) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  402,   -5 }, /* (393) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  402,   -6 }, /* (394) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  402,   -3 }, /* (395) predicate ::= expr_or_subquery IS NULL */
  {  402,   -4 }, /* (396) predicate ::= expr_or_subquery IS NOT NULL */
  {  402,   -3 }, /* (397) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  403,   -1 }, /* (398) compare_op ::= NK_LT */
  {  403,   -1 }, /* (399) compare_op ::= NK_GT */
  {  403,   -1 }, /* (400) compare_op ::= NK_LE */
  {  403,   -1 }, /* (401) compare_op ::= NK_GE */
  {  403,   -1 }, /* (402) compare_op ::= NK_NE */
  {  403,   -1 }, /* (403) compare_op ::= NK_EQ */
  {  403,   -1 }, /* (404) compare_op ::= LIKE */
  {  403,   -2 }, /* (405) compare_op ::= NOT LIKE */
  {  403,   -1 }, /* (406) compare_op ::= MATCH */
  {  403,   -1 }, /* (407) compare_op ::= NMATCH */
  {  403,   -1 }, /* (408) compare_op ::= CONTAINS */
  {  404,   -1 }, /* (409) in_op ::= IN */
  {  404,   -2 }, /* (410) in_op ::= NOT IN */
  {  405,   -3 }, /* (411) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  406,   -1 }, /* (412) boolean_value_expression ::= boolean_primary */
  {  406,   -2 }, /* (413) boolean_value_expression ::= NOT boolean_primary */
  {  406,   -3 }, /* (414) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  406,   -3 }, /* (415) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  407,   -1 }, /* (416) boolean_primary ::= predicate */
  {  407,   -3 }, /* (417) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  400,   -1 }, /* (418) common_expression ::= expr_or_subquery */
  {  400,   -1 }, /* (419) common_expression ::= boolean_value_expression */
  {  408,    0 }, /* (420) from_clause_opt ::= */
  {  408,   -2 }, /* (421) from_clause_opt ::= FROM table_reference_list */
  {  409,   -1 }, /* (422) table_reference_list ::= table_reference */
  {  409,   -3 }, /* (423) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  410,   -1 }, /* (424) table_reference ::= table_primary */
  {  410,   -1 }, /* (425) table_reference ::= joined_table */
  {  411,   -2 }, /* (426) table_primary ::= table_name alias_opt */
  {  411,   -4 }, /* (427) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  411,   -2 }, /* (428) table_primary ::= subquery alias_opt */
  {  411,   -1 }, /* (429) table_primary ::= parenthesized_joined_table */
  {  413,    0 }, /* (430) alias_opt ::= */
  {  413,   -1 }, /* (431) alias_opt ::= table_alias */
  {  413,   -2 }, /* (432) alias_opt ::= AS table_alias */
  {  414,   -3 }, /* (433) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  414,   -3 }, /* (434) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  412,   -6 }, /* (435) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  415,    0 }, /* (436) join_type ::= */
  {  415,   -1 }, /* (437) join_type ::= INNER */
  {  417,  -12 }, /* (438) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  418,    0 }, /* (439) set_quantifier_opt ::= */
  {  418,   -1 }, /* (440) set_quantifier_opt ::= DISTINCT */
  {  418,   -1 }, /* (441) set_quantifier_opt ::= ALL */
  {  419,   -1 }, /* (442) select_list ::= select_item */
  {  419,   -3 }, /* (443) select_list ::= select_list NK_COMMA select_item */
  {  427,   -1 }, /* (444) select_item ::= NK_STAR */
  {  427,   -1 }, /* (445) select_item ::= common_expression */
  {  427,   -2 }, /* (446) select_item ::= common_expression column_alias */
  {  427,   -3 }, /* (447) select_item ::= common_expression AS column_alias */
  {  427,   -3 }, /* (448) select_item ::= table_name NK_DOT NK_STAR */
  {  380,    0 }, /* (449) where_clause_opt ::= */
  {  380,   -2 }, /* (450) where_clause_opt ::= WHERE search_condition */
  {  420,    0 }, /* (451) partition_by_clause_opt ::= */
  {  420,   -3 }, /* (452) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  424,    0 }, /* (453) twindow_clause_opt ::= */
  {  424,   -6 }, /* (454) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  424,   -4 }, /* (455) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  424,   -6 }, /* (456) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  424,   -8 }, /* (457) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  367,    0 }, /* (458) sliding_opt ::= */
  {  367,   -4 }, /* (459) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  423,    0 }, /* (460) fill_opt ::= */
  {  423,   -4 }, /* (461) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  423,   -6 }, /* (462) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  428,   -1 }, /* (463) fill_mode ::= NONE */
  {  428,   -1 }, /* (464) fill_mode ::= PREV */
  {  428,   -1 }, /* (465) fill_mode ::= NULL */
  {  428,   -1 }, /* (466) fill_mode ::= LINEAR */
  {  428,   -1 }, /* (467) fill_mode ::= NEXT */
  {  425,    0 }, /* (468) group_by_clause_opt ::= */
  {  425,   -3 }, /* (469) group_by_clause_opt ::= GROUP BY group_by_list */
  {  429,   -1 }, /* (470) group_by_list ::= expr_or_subquery */
  {  429,   -3 }, /* (471) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  426,    0 }, /* (472) having_clause_opt ::= */
  {  426,   -2 }, /* (473) having_clause_opt ::= HAVING search_condition */
  {  421,    0 }, /* (474) range_opt ::= */
  {  421,   -6 }, /* (475) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  422,    0 }, /* (476) every_opt ::= */
  {  422,   -4 }, /* (477) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  430,   -4 }, /* (478) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  431,   -1 }, /* (479) query_simple ::= query_specification */
  {  431,   -1 }, /* (480) query_simple ::= union_query_expression */
  {  435,   -4 }, /* (481) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  435,   -3 }, /* (482) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  436,   -1 }, /* (483) query_simple_or_subquery ::= query_simple */
  {  436,   -1 }, /* (484) query_simple_or_subquery ::= subquery */
  {  372,   -1 }, /* (485) query_or_subquery ::= query_expression */
  {  372,   -1 }, /* (486) query_or_subquery ::= subquery */
  {  432,    0 }, /* (487) order_by_clause_opt ::= */
  {  432,   -3 }, /* (488) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  433,    0 }, /* (489) slimit_clause_opt ::= */
  {  433,   -2 }, /* (490) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  433,   -4 }, /* (491) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  433,   -4 }, /* (492) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  434,    0 }, /* (493) limit_clause_opt ::= */
  {  434,   -2 }, /* (494) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  434,   -4 }, /* (495) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  434,   -4 }, /* (496) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  388,   -3 }, /* (497) subquery ::= NK_LP query_expression NK_RP */
  {  388,   -3 }, /* (498) subquery ::= NK_LP subquery NK_RP */
  {  416,   -1 }, /* (499) search_condition ::= common_expression */
  {  437,   -1 }, /* (500) sort_specification_list ::= sort_specification */
  {  437,   -3 }, /* (501) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  438,   -3 }, /* (502) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  439,    0 }, /* (503) ordering_specification_opt ::= */
  {  439,   -1 }, /* (504) ordering_specification_opt ::= ASC */
  {  439,   -1 }, /* (505) ordering_specification_opt ::= DESC */
  {  440,    0 }, /* (506) null_ordering_opt ::= */
  {  440,   -2 }, /* (507) null_ordering_opt ::= NULLS FIRST */
  {  440,   -2 }, /* (508) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,314,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,315,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,314,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,316,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,317,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,315,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,317,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,316,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy659, &yymsp[-1].minor.yy0, yymsp[0].minor.yy341); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy659, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy659, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy659, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy659); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy341 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy341 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy459, &yymsp[-2].minor.yy659, &yymsp[0].minor.yy659); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy459, &yymsp[-2].minor.yy659, &yymsp[0].minor.yy659); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy459 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy459 = yymsp[0].minor.yy459; }
  yymsp[0].minor.yy459 = yylhsminor.yy459;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy459 = yymsp[-2].minor.yy459 | yymsp[0].minor.yy459; }
  yymsp[-2].minor.yy459 = yylhsminor.yy459;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy459 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy459 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy659 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy659 = yylhsminor.yy659;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy659 = yymsp[-2].minor.yy659; }
  yymsp[-2].minor.yy659 = yylhsminor.yy659;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy659, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy659, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy659); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 319: /* db_name ::= NK_ID */ yytestcase(yyruleno==319);
      case 320: /* table_name ::= NK_ID */ yytestcase(yyruleno==320);
      case 321: /* column_name ::= NK_ID */ yytestcase(yyruleno==321);
      case 322: /* function_name ::= NK_ID */ yytestcase(yyruleno==322);
      case 323: /* table_alias ::= NK_ID */ yytestcase(yyruleno==323);
      case 324: /* column_alias ::= NK_ID */ yytestcase(yyruleno==324);
      case 325: /* user_name ::= NK_ID */ yytestcase(yyruleno==325);
      case 326: /* topic_name ::= NK_ID */ yytestcase(yyruleno==326);
      case 327: /* stream_name ::= NK_ID */ yytestcase(yyruleno==327);
      case 328: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==328);
      case 366: /* noarg_func ::= NOW */ yytestcase(yyruleno==366);
      case 367: /* noarg_func ::= TODAY */ yytestcase(yyruleno==367);
      case 368: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==368);
      case 369: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==369);
      case 370: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==370);
      case 371: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==371);
      case 372: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==372);
      case 373: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==373);
      case 374: /* noarg_func ::= USER */ yytestcase(yyruleno==374);
      case 375: /* star_func ::= COUNT */ yytestcase(yyruleno==375);
      case 376: /* star_func ::= FIRST */ yytestcase(yyruleno==376);
      case 377: /* star_func ::= LAST */ yytestcase(yyruleno==377);
      case 378: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==378);
{ yylhsminor.yy659 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy659 = yylhsminor.yy659;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy173, &yymsp[-1].minor.yy659, yymsp[0].minor.yy560); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy173, &yymsp[0].minor.yy659); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy659); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy659, yymsp[0].minor.yy560); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy659); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[0].minor.yy659); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy173 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 262: /* analyze_opt ::= */ yytestcase(yyruleno==262);
      case 269: /* agg_func_opt ::= */ yytestcase(yyruleno==269);
      case 439: /* set_quantifier_opt ::= */ yytestcase(yyruleno==439);
{ yymsp[1].minor.yy173 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy173 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy560 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 79: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 80: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 81: /* db_options ::= db_options KEEP integer_list */
      case 82: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==82);
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_KEEP, yymsp[0].minor.yy334); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 83: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 84: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 85: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 86: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 87: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 88: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 89: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 90: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 91: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_RETENTIONS, yymsp[0].minor.yy334); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 92: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 93: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 94: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 95: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 96: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-3].minor.yy560, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-3].minor.yy560, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 99: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 100: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 101: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 102: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 103: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 104: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy560 = createAlterDatabaseOptions(pCxt); yylhsminor.yy560 = setAlterDatabaseOption(pCxt, yylhsminor.yy560, &yymsp[0].minor.yy515); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 105: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy560 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy560, &yymsp[0].minor.yy515); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 106: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy515.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy515.val = yymsp[0].minor.yy0; }
        break;
      case 107: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy515.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy515.val = yymsp[0].minor.yy0; }
        break;
      case 108: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy515.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy515.val = yymsp[0].minor.yy0; }
        break;
      case 109: /* alter_db_option ::= KEEP integer_list */
      case 110: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==110);
{ yymsp[-1].minor.yy515.type = DB_OPTION_KEEP; yymsp[-1].minor.yy515.pList = yymsp[0].minor.yy334; }
        break;
      case 111: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy515.type = DB_OPTION_WAL; yymsp[-1].minor.yy515.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy515.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy515.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy334 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy334 = yylhsminor.yy334;
        break;
      case 114: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 289: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==289);
{ yylhsminor.yy334 = addNodeToList(pCxt, yymsp[-2].minor.yy334, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy334 = yylhsminor.yy334;
        break;
      case 115: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy334 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy334 = yylhsminor.yy334;
        break;
      case 116: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy334 = addNodeToList(pCxt, yymsp[-2].minor.yy334, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy334 = yylhsminor.yy334;
        break;
      case 117: /* retention_list ::= retention */
      case 137: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==137);
      case 140: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==140);
      case 147: /* column_def_list ::= column_def */ yytestcase(yyruleno==147);
      case 190: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==190);
      case 195: /* col_name_list ::= col_name */ yytestcase(yyruleno==195);
      case 245: /* func_list ::= func */ yytestcase(yyruleno==245);
      case 317: /* literal_list ::= signed_literal */ yytestcase(yyruleno==317);
      case 381: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==381);
      case 387: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==387);
      case 442: /* select_list ::= select_item */ yytestcase(yyruleno==442);
      case 500: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==500);
{ yylhsminor.yy334 = createNodeList(pCxt, yymsp[0].minor.yy560); }
  yymsp[0].minor.yy334 = yylhsminor.yy334;
        break;
      case 118: /* retention_list ::= retention_list NK_COMMA retention */
      case 148: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==148);
      case 191: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==191);
      case 196: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==196);
      case 246: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==246);
      case 318: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==318);
      case 382: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==382);
      case 443: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==443);
      case 501: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==501);
{ yylhsminor.yy334 = addNodeToList(pCxt, yymsp[-2].minor.yy334, yymsp[0].minor.yy560); }
  yymsp[-2].minor.yy334 = yylhsminor.yy334;
        break;
      case 119: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy560 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 120: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 122: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==122);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy173, yymsp[-5].minor.yy560, yymsp[-3].minor.yy334, yymsp[-1].minor.yy334, yymsp[0].minor.yy560); }
        break;
      case 121: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy334); }
        break;
      case 123: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy334); }
        break;
      case 124: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy173, yymsp[0].minor.yy560); }
        break;
      case 125: /* cmd ::= ALTER TABLE alter_table_clause */
      case 291: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==291);
{ pCxt->pRootNode = yymsp[0].minor.yy560; }
        break;
      case 126: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy560); }
        break;
      case 127: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy560 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy560, yymsp[0].minor.yy560); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 128: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy560 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy560, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy659, yymsp[0].minor.yy574); }
  yymsp[-4].minor.yy560 = yylhsminor.yy560;
        break;
      case 129: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy560 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy560, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy659); }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 130: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy560 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy560, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy659, yymsp[0].minor.yy574); }
  yymsp[-4].minor.yy560 = yylhsminor.yy560;
        break;
      case 131: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy560 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy560, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy659, &yymsp[0].minor.yy659); }
  yymsp[-4].minor.yy560 = yylhsminor.yy560;
        break;
      case 132: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy560 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy560, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy659, yymsp[0].minor.yy574); }
  yymsp[-4].minor.yy560 = yylhsminor.yy560;
        break;
      case 133: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy560 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy560, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy659); }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 134: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy560 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy560, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy659, yymsp[0].minor.yy574); }
  yymsp[-4].minor.yy560 = yylhsminor.yy560;
        break;
      case 135: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy560 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy560, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy659, &yymsp[0].minor.yy659); }
  yymsp[-4].minor.yy560 = yylhsminor.yy560;
        break;
      case 136: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy560 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy560, &yymsp[-2].minor.yy659, yymsp[0].minor.yy560); }
  yymsp[-5].minor.yy560 = yylhsminor.yy560;
        break;
      case 138: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 141: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==141);
      case 388: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==388);
{ yylhsminor.yy334 = addNodeToList(pCxt, yymsp[-1].minor.yy334, yymsp[0].minor.yy560); }
  yymsp[-1].minor.yy334 = yylhsminor.yy334;
        break;
      case 139: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy560 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy173, yymsp[-8].minor.yy560, yymsp[-6].minor.yy560, yymsp[-5].minor.yy334, yymsp[-2].minor.yy334, yymsp[0].minor.yy560); }
  yymsp[-9].minor.yy560 = yylhsminor.yy560;
        break;
      case 142: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy560 = createDropTableClause(pCxt, yymsp[-1].minor.yy173, yymsp[0].minor.yy560); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 143: /* specific_cols_opt ::= */
      case 174: /* tags_def_opt ::= */ yytestcase(yyruleno==174);
      case 451: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==451);
      case 468: /* group_by_clause_opt ::= */ yytestcase(yyruleno==468);
      case 487: /* order_by_clause_opt ::= */ yytestcase(yyruleno==487);
{ yymsp[1].minor.yy334 = NULL; }
        break;
      case 144: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy334 = yymsp[-1].minor.yy334; }
        break;
      case 145: /* full_table_name ::= table_name */
{ yylhsminor.yy560 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy659, NULL); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 146: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy560 = createRealTableNode(pCxt, &yymsp[-2].minor.yy659, &yymsp[0].minor.yy659, NULL); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 149: /* column_def ::= column_name type_name */
{ yylhsminor.yy560 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy659, yymsp[0].minor.yy574, NULL); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 150: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy560 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy659, yymsp[-2].minor.yy574, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 151: /* type_name ::= BOOL */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 152: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 153: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 154: /* type_name ::= INT */
      case 155: /* type_name ::= INTEGER */ yytestcase(yyruleno==155);
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 156: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 157: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 158: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 159: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy574 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 160: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 161: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy574 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 162: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy574 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 163: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy574 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 164: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy574 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 165: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy574 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 166: /* type_name ::= JSON */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 167: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy574 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 169: /* type_name ::= BLOB */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 170: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy574 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 171: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 172: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy574 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 173: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy574 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 175: /* tags_def_opt ::= tags_def */
      case 380: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==380);
{ yylhsminor.yy334 = yymsp[0].minor.yy334; }
  yymsp[0].minor.yy334 = yylhsminor.yy334;
        break;
      case 176: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy334 = yymsp[-1].minor.yy334; }
        break;
      case 177: /* table_options ::= */
{ yymsp[1].minor.yy560 = createDefaultTableOptions(pCxt); }
        break;
      case 178: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy560 = setTableOption(pCxt, yymsp[-2].minor.yy560, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 179: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy560 = setTableOption(pCxt, yymsp[-2].minor.yy560, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy334); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 180: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy560 = setTableOption(pCxt, yymsp[-2].minor.yy560, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy334); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 181: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy560 = setTableOption(pCxt, yymsp[-4].minor.yy560, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy334); }
  yymsp[-4].minor.yy560 = yylhsminor.yy560;
        break;
      case 182: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy560 = setTableOption(pCxt, yymsp[-2].minor.yy560, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 183: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy560 = setTableOption(pCxt, yymsp[-4].minor.yy560, TABLE_OPTION_SMA, yymsp[-1].minor.yy334); }
  yymsp[-4].minor.yy560 = yylhsminor.yy560;
        break;
      case 184: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy560 = createAlterTableOptions(pCxt); yylhsminor.yy560 = setTableOption(pCxt, yylhsminor.yy560, yymsp[0].minor.yy515.type, &yymsp[0].minor.yy515.val); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 185: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy560 = setTableOption(pCxt, yymsp[-1].minor.yy560, yymsp[0].minor.yy515.type, &yymsp[0].minor.yy515.val); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 186: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy515.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy515.val = yymsp[0].minor.yy0; }
        break;
      case 187: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy515.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy515.val = yymsp[0].minor.yy0; }
        break;
      case 188: /* duration_list ::= duration_literal */
      case 347: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==347);
{ yylhsminor.yy334 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy560)); }
  yymsp[0].minor.yy334 = yylhsminor.yy334;
        break;
      case 189: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 348: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==348);
{ yylhsminor.yy334 = addNodeToList(pCxt, yymsp[-2].minor.yy334, releaseRawExprNode(pCxt, yymsp[0].minor.yy560)); }
  yymsp[-2].minor.yy334 = yylhsminor.yy334;
        break;
      case 192: /* rollup_func_name ::= function_name */
{ yylhsminor.yy560 = createFunctionNode(pCxt, &yymsp[0].minor.yy659, NULL); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 193: /* rollup_func_name ::= FIRST */
      case 194: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==194);
{ yylhsminor.yy560 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 197: /* col_name ::= column_name */
{ yylhsminor.yy560 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy659); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 198: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 199: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 200: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 201: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy560, yymsp[0].minor.yy560, OP_TYPE_LIKE); }
        break;
      case 202: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy560, yymsp[0].minor.yy560, OP_TYPE_LIKE); }
        break;
      case 203: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy560, NULL, OP_TYPE_LIKE); }
        break;
      case 204: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 205: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 206: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 207: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 208: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy560, yymsp[-1].minor.yy560, OP_TYPE_EQUAL); }
        break;
      case 209: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 210: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 211: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 212: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 213: /* cmd ::= SHOW LICENCES */
      case 214: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==214);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 215: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy659); }
        break;
      case 216: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy560); }
        break;
      case 217: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy560); }
        break;
      case 218: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 219: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 220: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 221: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 222: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 223: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 224: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 225: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 226: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 227: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 228: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy560); }
        break;
      case 229: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 230: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 231: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy560, yymsp[-1].minor.yy560, OP_TYPE_EQUAL); }
        break;
      case 232: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 233: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 234: /* db_name_cond_opt ::= */
      case 239: /* from_db_opt ::= */ yytestcase(yyruleno==239);
{ yymsp[1].minor.yy560 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 235: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy659); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 236: /* like_pattern_opt ::= */
      case 390: /* case_when_else_opt ::= */ yytestcase(yyruleno==390);
      case 420: /* from_clause_opt ::= */ yytestcase(yyruleno==420);
      case 449: /* where_clause_opt ::= */ yytestcase(yyruleno==449);
      case 453: /* twindow_clause_opt ::= */ yytestcase(yyruleno==453);
      case 458: /* sliding_opt ::= */ yytestcase(yyruleno==458);
      case 460: /* fill_opt ::= */ yytestcase(yyruleno==460);
      case 472: /* having_clause_opt ::= */ yytestcase(yyruleno==472);
      case 474: /* range_opt ::= */ yytestcase(yyruleno==474);
      case 476: /* every_opt ::= */ yytestcase(yyruleno==476);
      case 489: /* slimit_clause_opt ::= */ yytestcase(yyruleno==489);
      case 493: /* limit_clause_opt ::= */ yytestcase(yyruleno==493);
{ yymsp[1].minor.yy560 = NULL; }
        break;
      case 237: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 238: /* table_name_cond ::= table_name */
{ yylhsminor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy659); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 240: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy659); }
        break;
      case 241: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy173, yymsp[-3].minor.yy560, yymsp[-1].minor.yy560, NULL, yymsp[0].minor.yy560); }
        break;
      case 242: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy173, yymsp[0].minor.yy560); }
        break;
      case 243: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy560 = createIndexOption(pCxt, yymsp[-7].minor.yy334, releaseRawExprNode(pCxt, yymsp[-3].minor.yy560), NULL, yymsp[-1].minor.yy560, yymsp[0].minor.yy560); }
        break;
      case 244: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy560 = createIndexOption(pCxt, yymsp[-9].minor.yy334, releaseRawExprNode(pCxt, yymsp[-5].minor.yy560), releaseRawExprNode(pCxt, yymsp[-3].minor.yy560), yymsp[-1].minor.yy560, yymsp[0].minor.yy560); }
        break;
      case 247: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy560 = createFunctionNode(pCxt, &yymsp[-3].minor.yy659, yymsp[-1].minor.yy334); }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 248: /* sma_stream_opt ::= */
      case 275: /* stream_options ::= */ yytestcase(yyruleno==275);
{ yymsp[1].minor.yy560 = createStreamOptions(pCxt); }
        break;
      case 249: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 279: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==279);
{ ((SStreamOptions*)yymsp[-2].minor.yy560)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy560); yylhsminor.yy560 = yymsp[-2].minor.yy560; }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 250: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy560)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy560); yylhsminor.yy560 = yymsp[-2].minor.yy560; }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 251: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy173, &yymsp[-2].minor.yy659, yymsp[0].minor.yy560); }
        break;
      case 252: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy173, &yymsp[-3].minor.yy659, &yymsp[0].minor.yy659, false); }
        break;
      case 253: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy173, &yymsp[-5].minor.yy659, &yymsp[0].minor.yy659, true); }
        break;
      case 254: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy173, &yymsp[-3].minor.yy659, yymsp[0].minor.yy560, false); }
        break;
      case 255: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy173, &yymsp[-5].minor.yy659, yymsp[0].minor.yy560, true); }
        break;
      case 256: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy173, &yymsp[0].minor.yy659); }
        break;
      case 257: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy173, &yymsp[-2].minor.yy659, &yymsp[0].minor.yy659); }
        break;
      case 258: /* cmd ::= DESC full_table_name */
      case 259: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==259);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy560); }
        break;
      case 260: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 261: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy173, yymsp[-1].minor.yy560, yymsp[0].minor.yy560); }
        break;
      case 263: /* analyze_opt ::= ANALYZE */
      case 270: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==270);
      case 440: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==440);
{ yymsp[0].minor.yy173 = true; }
        break;
      case 264: /* explain_options ::= */
{ yymsp[1].minor.yy560 = createDefaultExplainOptions(pCxt); }
        break;
      case 265: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy560 = setExplainVerbose(pCxt, yymsp[-2].minor.yy560, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 266: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy560 = setExplainRatio(pCxt, yymsp[-2].minor.yy560, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 267: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy173, yymsp[-8].minor.yy173, &yymsp[-5].minor.yy659, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy574, yymsp[0].minor.yy676); }
        break;
      case 268: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy173, &yymsp[0].minor.yy659); }
        break;
      case 271: /* bufsize_opt ::= */
{ yymsp[1].minor.yy676 = 0; }
        break;
      case 272: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy676 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 273: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-6].minor.yy173, &yymsp[-5].minor.yy659, yymsp[-2].minor.yy560, yymsp[-4].minor.yy560, yymsp[0].minor.yy560); }
        break;
      case 274: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy173, &yymsp[0].minor.yy659); }
        break;
      case 276: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy560)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy560 = yymsp[-2].minor.yy560; }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 277: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy560)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy560 = yymsp[-2].minor.yy560; }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 278: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy560)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy560)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy560); yylhsminor.yy560 = yymsp[-3].minor.yy560; }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 280: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy560)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy560 = yymsp[-3].minor.yy560; }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 281: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 282: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 283: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 284: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 285: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 286: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy334); }
        break;
      case 287: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 288: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy334 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 290: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy560, yymsp[0].minor.yy560); }
        break;
      case 292: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy560, yymsp[-2].minor.yy334, yymsp[0].minor.yy560); }
        break;
      case 293: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy560, NULL, yymsp[0].minor.yy560); }
        break;
      case 294: /* literal ::= NK_INTEGER */
{ yylhsminor.yy560 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 295: /* literal ::= NK_FLOAT */
{ yylhsminor.yy560 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 296: /* literal ::= NK_STRING */
{ yylhsminor.yy560 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 297: /* literal ::= NK_BOOL */
{ yylhsminor.yy560 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 298: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 299: /* literal ::= duration_literal */
      case 309: /* signed_literal ::= signed */ yytestcase(yyruleno==309);
      case 329: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==329);
      case 330: /* expr_or_subquery ::= subquery */ yytestcase(yyruleno==330);
      case 331: /* expression ::= literal */ yytestcase(yyruleno==331);
      case 332: /* expression ::= pseudo_column */ yytestcase(yyruleno==332);
      case 333: /* expression ::= column_reference */ yytestcase(yyruleno==333);
      case 334: /* expression ::= function_expression */ yytestcase(yyruleno==334);
      case 335: /* expression ::= case_when_expression */ yytestcase(yyruleno==335);
      case 363: /* function_expression ::= literal_func */ yytestcase(yyruleno==363);
      case 412: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==412);
      case 416: /* boolean_primary ::= predicate */ yytestcase(yyruleno==416);
      case 418: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==418);
      case 419: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==419);
      case 422: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==422);
      case 424: /* table_reference ::= table_primary */ yytestcase(yyruleno==424);
      case 425: /* table_reference ::= joined_table */ yytestcase(yyruleno==425);
      case 429: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==429);
      case 479: /* query_simple ::= query_specification */ yytestcase(yyruleno==479);
      case 480: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==480);
      case 483: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==483);
      case 485: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==485);
{ yylhsminor.yy560 = yymsp[0].minor.yy560; }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 300: /* literal ::= NULL */
{ yylhsminor.yy560 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 301: /* literal ::= NK_QUESTION */
{ yylhsminor.yy560 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 302: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy560 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 303: /* signed ::= NK_INTEGER */
{ yylhsminor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 304: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 305: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 306: /* signed ::= NK_FLOAT */
{ yylhsminor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 307: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 308: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 310: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 311: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 312: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 313: /* signed_literal ::= duration_literal */
      case 315: /* signed_literal ::= literal_func */ yytestcase(yyruleno==315);
      case 383: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==383);
      case 445: /* select_item ::= common_expression */ yytestcase(yyruleno==445);
      case 484: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==484);
      case 486: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==486);
      case 499: /* search_condition ::= common_expression */ yytestcase(yyruleno==499);
{ yylhsminor.yy560 = releaseRawExprNode(pCxt, yymsp[0].minor.yy560); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 314: /* signed_literal ::= NULL */
{ yylhsminor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 316: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy560 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 336: /* expression ::= NK_LP expression NK_RP */
      case 417: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==417);
      case 498: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==498);
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy560)); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 337: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy560));
                                                                                  }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 338: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy560), NULL));
                                                                                  }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 339: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560))); 
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 340: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560))); 
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 341: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560))); 
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 342: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560))); 
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 343: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560)));
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 344: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 345: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560)));
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 346: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560)));
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 349: /* column_reference ::= column_name */
{ yylhsminor.yy560 = createRawExprNode(pCxt, &yymsp[0].minor.yy659, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy659)); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 350: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy659, &yymsp[0].minor.yy659, createColumnNode(pCxt, &yymsp[-2].minor.yy659, &yymsp[0].minor.yy659)); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 351: /* pseudo_column ::= ROWTS */
      case 352: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==352);
      case 354: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==354);
      case 355: /* pseudo_column ::= QEND */ yytestcase(yyruleno==355);
      case 356: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==356);
      case 357: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==357);
      case 358: /* pseudo_column ::= WEND */ yytestcase(yyruleno==358);
      case 359: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==359);
      case 365: /* literal_func ::= NOW */ yytestcase(yyruleno==365);
{ yylhsminor.yy560 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 353: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy659, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy659)))); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 360: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 361: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==361);
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy659, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy659, yymsp[-1].minor.yy334)); }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 362: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy560), yymsp[-1].minor.yy574)); }
  yymsp[-5].minor.yy560 = yylhsminor.yy560;
        break;
      case 364: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy659, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy659, NULL)); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 379: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy334 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy334 = yylhsminor.yy334;
        break;
      case 384: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 448: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==448);
{ yylhsminor.yy560 = createColumnNode(pCxt, &yymsp[-2].minor.yy659, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 385: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy334, yymsp[-1].minor.yy560)); }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 386: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy560), yymsp[-2].minor.yy334, yymsp[-1].minor.yy560)); }
  yymsp[-4].minor.yy560 = yylhsminor.yy560;
        break;
      case 389: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy560 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560)); }
        break;
      case 391: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy560 = releaseRawExprNode(pCxt, yymsp[0].minor.yy560); }
        break;
      case 392: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 397: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==397);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy128, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560)));
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 393: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy560), releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560)));
                                                                                  }
  yymsp[-4].minor.yy560 = yylhsminor.yy560;
        break;
      case 394: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy560), releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560)));
                                                                                  }
  yymsp[-5].minor.yy560 = yylhsminor.yy560;
        break;
      case 395: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), NULL));
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 396: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy560), NULL));
                                                                                  }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 398: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy128 = OP_TYPE_LOWER_THAN; }
        break;
      case 399: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy128 = OP_TYPE_GREATER_THAN; }
        break;
      case 400: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy128 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 401: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy128 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 402: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy128 = OP_TYPE_NOT_EQUAL; }
        break;
      case 403: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy128 = OP_TYPE_EQUAL; }
        break;
      case 404: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy128 = OP_TYPE_LIKE; }
        break;
      case 405: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy128 = OP_TYPE_NOT_LIKE; }
        break;
      case 406: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy128 = OP_TYPE_MATCH; }
        break;
      case 407: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy128 = OP_TYPE_NMATCH; }
        break;
      case 408: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy128 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 409: /* in_op ::= IN */
{ yymsp[0].minor.yy128 = OP_TYPE_IN; }
        break;
      case 410: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy128 = OP_TYPE_NOT_IN; }
        break;
      case 411: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy334)); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 413: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy560), NULL));
                                                                                  }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 414: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560)));
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 415: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560)));
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 421: /* from_clause_opt ::= FROM table_reference_list */
      case 450: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==450);
      case 473: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==473);
{ yymsp[-1].minor.yy560 = yymsp[0].minor.yy560; }
        break;
      case 423: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy560 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy560, yymsp[0].minor.yy560, NULL); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 426: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy560 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy659, &yymsp[0].minor.yy659); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 427: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy560 = createRealTableNode(pCxt, &yymsp[-3].minor.yy659, &yymsp[-1].minor.yy659, &yymsp[0].minor.yy659); }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 428: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy560 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy560), &yymsp[0].minor.yy659); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 430: /* alias_opt ::= */
{ yymsp[1].minor.yy659 = nil_token;  }
        break;
      case 431: /* alias_opt ::= table_alias */
{ yylhsminor.yy659 = yymsp[0].minor.yy659; }
  yymsp[0].minor.yy659 = yylhsminor.yy659;
        break;
      case 432: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy659 = yymsp[0].minor.yy659; }
        break;
      case 433: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 434: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==434);
{ yymsp[-2].minor.yy560 = yymsp[-1].minor.yy560; }
        break;
      case 435: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy560 = createJoinTableNode(pCxt, yymsp[-4].minor.yy540, yymsp[-5].minor.yy560, yymsp[-2].minor.yy560, yymsp[0].minor.yy560); }
  yymsp[-5].minor.yy560 = yylhsminor.yy560;
        break;
      case 436: /* join_type ::= */
{ yymsp[1].minor.yy540 = JOIN_TYPE_INNER; }
        break;
      case 437: /* join_type ::= INNER */
{ yymsp[0].minor.yy540 = JOIN_TYPE_INNER; }
        break;
      case 438: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy560 = createSelectStmt(pCxt, yymsp[-10].minor.yy173, yymsp[-9].minor.yy334, yymsp[-8].minor.yy560);
                                                                                    yymsp[-11].minor.yy560 = addWhereClause(pCxt, yymsp[-11].minor.yy560, yymsp[-7].minor.yy560);
                                                                                    yymsp[-11].minor.yy560 = addPartitionByClause(pCxt, yymsp[-11].minor.yy560, yymsp[-6].minor.yy334);
                                                                                    yymsp[-11].minor.yy560 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy560, yymsp[-2].minor.yy560);
                                                                                    yymsp[-11].minor.yy560 = addGroupByClause(pCxt, yymsp[-11].minor.yy560, yymsp[-1].minor.yy334);
                                                                                    yymsp[-11].minor.yy560 = addHavingClause(pCxt, yymsp[-11].minor.yy560, yymsp[0].minor.yy560);
                                                                                    yymsp[-11].minor.yy560 = addRangeClause(pCxt, yymsp[-11].minor.yy560, yymsp[-5].minor.yy560);
                                                                                    yymsp[-11].minor.yy560 = addEveryClause(pCxt, yymsp[-11].minor.yy560, yymsp[-4].minor.yy560);
                                                                                    yymsp[-11].minor.yy560 = addFillClause(pCxt, yymsp[-11].minor.yy560, yymsp[-3].minor.yy560);
                                                                                  }
        break;
      case 441: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy173 = false; }
        break;
      case 444: /* select_item ::= NK_STAR */
{ yylhsminor.yy560 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 446: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy560 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy560), &yymsp[0].minor.yy659); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 447: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy560 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), &yymsp[0].minor.yy659); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 452: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 469: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==469);
      case 488: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==488);
{ yymsp[-2].minor.yy334 = yymsp[0].minor.yy334; }
        break;
      case 454: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy560 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy560), releaseRawExprNode(pCxt, yymsp[-1].minor.yy560)); }
        break;
      case 455: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy560 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy560)); }
        break;
      case 456: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy560 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy560), NULL, yymsp[-1].minor.yy560, yymsp[0].minor.yy560); }
        break;
      case 457: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy560 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy560), releaseRawExprNode(pCxt, yymsp[-3].minor.yy560), yymsp[-1].minor.yy560, yymsp[0].minor.yy560); }
        break;
      case 459: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 477: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==477);
{ yymsp[-3].minor.yy560 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy560); }
        break;
      case 461: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy560 = createFillNode(pCxt, yymsp[-1].minor.yy18, NULL); }
        break;
      case 462: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy560 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy334)); }
        break;
      case 463: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy18 = FILL_MODE_NONE; }
        break;
      case 464: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy18 = FILL_MODE_PREV; }
        break;
      case 465: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy18 = FILL_MODE_NULL; }
        break;
      case 466: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy18 = FILL_MODE_LINEAR; }
        break;
      case 467: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy18 = FILL_MODE_NEXT; }
        break;
      case 470: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy334 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy560))); }
  yymsp[0].minor.yy334 = yylhsminor.yy334;
        break;
      case 471: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy334 = addNodeToList(pCxt, yymsp[-2].minor.yy334, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy560))); }
  yymsp[-2].minor.yy334 = yylhsminor.yy334;
        break;
      case 475: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy560 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy560), releaseRawExprNode(pCxt, yymsp[-1].minor.yy560)); }
        break;
      case 478: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy560 = addOrderByClause(pCxt, yymsp[-3].minor.yy560, yymsp[-2].minor.yy334);
                                                                                    yylhsminor.yy560 = addSlimitClause(pCxt, yylhsminor.yy560, yymsp[-1].minor.yy560);
                                                                                    yylhsminor.yy560 = addLimitClause(pCxt, yylhsminor.yy560, yymsp[0].minor.yy560);
                                                                                  }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 481: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy560 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy560, yymsp[0].minor.yy560); }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 482: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy560 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy560, yymsp[0].minor.yy560); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 490: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 494: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==494);
{ yymsp[-1].minor.yy560 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 491: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 495: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==495);
{ yymsp[-3].minor.yy560 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 492: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 496: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==496);
{ yymsp[-3].minor.yy560 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 497: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy560); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 502: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy560 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), yymsp[-1].minor.yy596, yymsp[0].minor.yy487); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 503: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy596 = ORDER_ASC; }
        break;
      case 504: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy596 = ORDER_ASC; }
        break;
      case 505: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy596 = ORDER_DESC; }
        break;
      case 506: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy487 = NULL_ORDER_DEFAULT; }
        break;
      case 507: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy487 = NULL_ORDER_FIRST; }
        break;
      case 508: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy487 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
