# TDengine的运营与维护

## <a class="anchor" id="planning"></a>容量规划

使用 TDengine 来搭建一个物联网大数据平台，计算资源、存储资源需要根据业务场景进行规划。下面分别讨论系统运行所需要的内存、CPU 以及硬盘空间。

### 内存需求

每个 Database 可以创建固定数目的 vgroup，默认与 CPU 核数相同，可通过 maxVgroupsPerDb 配置；vgroup 中的每个副本会是一个 vnode；每个 vnode 会占用固定大小的内存（大小与数据库的配置参数 blocks 和 cache 有关)；每个 Table 会占用与标签总长度有关的内存；此外，系统会有一些固定的内存开销。因此，每个 DB 需要的系统内存可通过如下公式计算：

```
Database Memory Size = maxVgroupsPerDb * (blocks * cache + 10MB) + numOfTables * (tagSizePerTable + 0.5KB)
```

示例：假设是 4 核机器，cache 是缺省大小 16M, blocks 是缺省值 6，并且一个 DB 中有 10 万张表，标签总长度是 256 字节，则这个 DB 总的内存需求为：4 \* (16 \* 6 + 10) + 100000 \* (0.25 + 0.5) / 1000 = 499M。

在实际的系统运维中，我们通常会更关心 TDengine 服务进程（taosd）会占用的内存量。
```
taosd 内存总量 = vnode 内存 + mnode 内存 + 查询内存
```

其中：
1. “vnode 内存”指的是集群中所有的 Database 存储分摊到当前 taosd 节点上所占用的内存资源。可以按上文“Database Memory Size”计算公式估算每个 DB 的内存占用量进行加总，再按集群中总共的 TDengine 节点数做平均（如果设置为多副本，则还需要乘以对应的副本倍数）。
2. “mnode 内存”指的是集群中管理节点所占用的资源。如果一个 taosd 节点上分布有 mnode 管理节点，则内存消耗还需要增加“0.2KB * 集群中数据表总数”。
3. “查询内存”指的是服务端处理查询请求时所需要占用的内存。单条查询语句至少会占用“0.2KB * 查询涉及的数据表总数”的内存量。

注意：以上内存估算方法，主要讲解了系统的“必须内存需求”，而不是“内存总数上限”。在实际运行的生产环境中，由于操作系统缓存、资源管理调度等方面的原因，内存规划应当在估算结果的基础上保留一定冗余，以维持系统状态和系统性能的稳定性。并且，生产环境通常会配置系统资源的监控工具，以便及时发现硬件资源的紧缺情况。

最后，如果内存充裕，可以考虑加大 Blocks 的配置，这样更多数据将保存在内存里，提高查询速度。

#### 客户端内存需求

客户端应用采用 taosc 客户端驱动连接服务端，会有内存需求的开销。

客户端的内存开销主要由写入过程中的 SQL 语句、表的元数据信息缓存、以及结构性开销构成。系统最大容纳的表数量为 N（每个通过超级表创建的表的 meta data 开销约 256 字节），最大并行写入线程数量 T，最大 SQL 语句长度 S（通常是 1 Mbytes）。由此可以进行客户端内存开销的估算（单位 MBytes）：
```
M = (T * S * 3 + (N / 4096) + 100)
```

举例如下：用户最大并发写入线程数 100，子表数总数 10,000,000，那么客户端的内存最低要求是：
```
100 * 3 + (10000000 / 4096) + 100 = 2741 (MBytes)
```

即配置 3 GBytes 内存是最低要求。

### CPU 需求

CPU 的需求取决于如下两方面：

* **数据插入** TDengine 单核每秒能至少处理一万个插入请求。每个插入请求可以带多条记录，一次插入一条记录与插入 10 条记录，消耗的计算资源差别很小。因此每次插入，条数越大，插入效率越高。如果一个插入请求带 200 条以上记录，单核就能达到每秒插入 100 万条记录的速度。但对前端数据采集的要求越高，因为需要缓存记录，然后一批插入。
* **查询需求** TDengine 提供高效的查询，但是每个场景的查询差异很大，查询频次变化也很大，难以给出客观数字。需要用户针对自己的场景，写一些查询语句，才能确定。

因此仅对数据插入而言，CPU 是可以估算出来的，但查询所耗的计算资源无法估算。在实际运营过程中，不建议 CPU 使用率超过 50%，超过后，需要增加新的节点，以获得更多计算资源。

### 存储需求

TDengine 相对于通用数据库，有超高的压缩比，在绝大多数场景下，TDengine 的压缩比不会低于 5 倍，有的场合，压缩比可达到 10 倍以上，取决于实际场景的数据特征。压缩前的原始数据大小可通过如下方式计算：

```
Raw DataSize = numOfTables * rowSizePerTable * rowsPerTable
```

示例：1000 万台智能电表，每台电表每 15 分钟采集一次数据，每次采集的数据 128 字节，那么一年的原始数据量是：10000000 \* 128 \* 24 \* 60 / 15 \* 365 = 44.8512T。TDengine大概需要消耗 44.851 / 5 = 8.97024T 空间。

用户可以通过参数 keep，设置数据在磁盘中的最大保存时长。为进一步减少存储成本，TDengine 还提供多级存储，最冷的数据可以存放在最廉价的存储介质上，应用的访问不用做任何调整，只是读取速度降低了。

为提高速度，可以配置多块硬盘，这样可以并发写入或读取数据。需要提醒的是，TDengine 采取多副本的方式提供数据的高可靠，因此不再需要采用昂贵的磁盘阵列。

### 物理机或虚拟机台数

根据上面的内存、CPU、存储的预估，就可以知道整个系统需要多少核、多少内存、多少存储空间。如果数据副本数不为 1，总需求量需要再乘以副本数。

因为 TDengine 具有很好的水平扩展能力，根据总量，再根据单个物理机或虚拟机的资源，就可以轻松决定需要购置多少台物理机或虚拟机了。

**立即计算 CPU、内存、存储，请参见：[资源估算方法](https://www.taosdata.com/config/config.html)。**

## <a class="anchor" id="tolerance"></a>容错和灾备

### 容错

TDengine支持**WAL**（Write Ahead Log）机制，实现数据的容错能力，保证数据的高可用。

TDengine接收到应用的请求数据包时，先将请求的原始数据包写入数据库日志文件，等数据成功写入数据库数据文件后，再删除相应的WAL。这样保证了TDengine能够在断电等因素导致的服务重启时从数据库日志文件中恢复数据，避免数据的丢失。

涉及的系统配置参数有两个：

- walLevel：WAL级别，0：不写wal; 1：写wal, 但不执行fsync; 2：写wal, 而且执行fsync。
- fsync：当walLevel设置为2时，执行fsync的周期。设置为0，表示每次写入，立即执行fsync。

如果要100%的保证数据不丢失，需要将walLevel设置为2，fsync设置为0。这时写入速度将会下降。但如果应用侧启动的写数据的线程数达到一定的数量(超过50)，那么写入数据的性能也会很不错，只会比fsync设置为3000毫秒下降30%左右。

### 灾备

TDengine的集群通过多个副本的机制，来提供系统的高可用性，实现灾备能力。

TDengine集群是由mnode负责管理的，为保证mnode的高可靠，可以配置多个mnode副本，副本数由系统配置参数numOfMnodes决定，为了支持高可靠，需要设置大于1。为保证元数据的强一致性，mnode副本之间通过同步方式进行数据复制，保证了元数据的强一致性。

TDengine集群中的时序数据的副本数是与数据库关联的，一个集群里可以有多个数据库，每个数据库可以配置不同的副本数。创建数据库时，通过参数replica 指定副本数。为了支持高可靠，需要设置副本数大于1。

TDengine集群的节点数必须大于等于副本数，否则创建表时将报错。

当TDengine集群中的节点部署在不同的物理机上，并设置多个副本数时，就实现了系统的高可靠性，无需再使用其他软件或工具。TDengine企业版还可以将副本部署在不同机房，从而实现异地容灾。

## <a class="anchor" id="config"></a>服务端配置

TDengine系统后台服务由taosd提供，可以在配置文件taos.cfg里修改配置参数，以满足不同场景的需求。配置文件的缺省位置在/etc/taos目录，可以通过taosd命令行执行参数-c指定配置文件目录。比如taosd -c /home/user来指定配置文件位于/home/user这个目录。

另外可以使用 “-C” 显示当前服务器配置参数：

```
taosd -C
```

下面仅仅列出一些重要的配置参数，更多的参数请看配置文件里的说明。各个参数的详细介绍及作用请看前述章节，而且这些参数的缺省配置都是可以工作的，一般无需设置。**注意：配置文件参数修改后，需要重启*taosd*服务，或客户端应用才能生效。**

| **#** | **配置参数名称**        | **内部** | **SC** | **单位** | **含义**                                                     | **取值范围**                                                 | **缺省值**                                                   | **补充说明**                                                     |
| ----- | ----------------------- | -------- | -------- | -------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ |
| 1     | firstEP                 |          | **SC**   |          | taosd启动时，主动连接的集群中首个dnode的end point           |                                                              | localhost:6030                                            |                                                              |
| 2     | secondEP                | YES      | **SC**   |          | taosd启动时，如果firstEp连接不上，尝试连接集群中第二个dnode的end point |                                                              | 无                                                           |                                                              |
| 3     | fqdn                    |          | **SC**   |          | 数据节点的FQDN。如果习惯IP地址访问，可设置为该节点的IP地址。   |                                                              | 缺省为操作系统配置的第一个hostname。                             | 这个参数值的长度需要控制在 96 个字符以内。                         |
| 4     | serverPort              |          | **SC**   |          | taosd启动后，对外服务的端口号                              |                                                              | 6030                                                         | RESTful服务使用的端口号是在此基础上+11，即默认值为6041。            |
| 5     | logDir                  |          | **SC**   |          | 日志文件目录，客户端和服务器的运行日志将写入该目录           |                                                              | /var/log/taos                                                |                                                              |
| 6     | scriptDir               | YES      | **S**    |          |                                                              |                                                              |                                                              |                                                              |
| 7     | dataDir                 |          | **S**    |          | 数据文件目录，所有的数据文件都将写入该目录                   |                                                              | /var/lib/taos                                                |                                                              |
| 8     | arbitrator              |          | **S**    |          | 系统中裁决器的end point                                      |                                                              | 空                                                           |                                                              |
| 9     | numOfThreadsPerCore     |          | **SC**   |          | 每个CPU核生成的队列消费者线程数量                            |                                                              | 1.0                                                          |                                                              |
| 10    | ratioOfQueryThreads     |          | **S**    |          | 设置查询线程的最大数量                                      | 0：表示只有1个查询线程；1：表示最大和CPU核数相等的查询线程；2：表示最大建立2倍CPU核数的查询线程。                                                             | 1                                                          | 该值可以为小数，即0.5表示最大建立CPU核数一半的查询线程。                                      |
| 11    | numOfMnodes             |          | **S**    |          | 系统中管理节点个数                                           |                                                              | 3                                                            |                                                              |
| 12    | vnodeBak                |          | **S**    |          | 删除vnode时是否备份vnode目录                                 | 0：否，1：是                                                 | 1                                                            |                                                              |
| 13    | telemetryRePorting      |          | **S**    |          | 是否允许 TDengine 采集和上报基本使用信息                       | 0：不允许；1：允许                                                 | 1                                                            |                                                              |
| 14    | balance                 |          | **S**    |          | 是否启动负载均衡                                             | 0，1                                                         | 1                                                            |                                                              |
| 15    | balanceInterval         | YES      | **S**    | 秒       | 管理节点在正常运行状态下，检查负载均衡的时间间隔             | 1-30000                                                      | 300                                                          |                                                              |
| 16    | role                    |          | **S**    |          | dnode的可选角色                                              | 0：any（既可作为mnode，也可分配vnode）；1：mgmt（只能作为mnode，不能分配vnode）；2：dnode（不能作为mnode，只能分配vnode） | 0                                                            |                                                              |
| 17    | maxTmerCtrl             |          | **SC**   | 个       | 定时器个数                                                   | 8-2048                                                       | 512                                                          |                                                              |
| 18    | monitorInterval         |          | **S**    | 秒       | 监控数据库记录系统参数（CPU/内存）的时间间隔                 | 1-600                                                        | 30                                                           |                                                              |
| 19    | offlineThreshold        |          | **S**    | 秒       | dnode离线阈值，超过该时间将导致dnode离线                     | 5-7200000                                                    | 86400*10（10天）                                             |                                                              |
| 20    | rpcTimer                |          | **SC**   | 毫秒     | rpc重试时长                                                  | 100-3000                                                     | 300                                                          |                                                              |
| 21    | rpcMaxTime              |          | **SC**   | 秒       | rpc等待应答最大时长                                          | 100-7200                                                     | 600                                                          |                                                              |
| 22    | statusInterval          |          | **S**    | 秒       | dnode向mnode报告状态间隔                                     | 1-10                                                         | 1                                                            |                                                              |
| 23    | shellActivityTimer      |          | **SC**   | 秒       | shell客户端向mnode发送心跳间隔                               | 1-120                                                        | 3                                                            |                                                              |
| 24    | tableMetaKeepTimer      |          | **S**    | 秒       | 表的元数据cache时长                                          | 1-8640000                                                    | 7200                                                         |                                                              |
| 25    | minSlidingTime          |          | **S**    | 毫秒     | 最小滑动窗口时长                                             | 10-1000000                                                   | 10                                                           | 支持us补值后，这个值就是1us了。                              |
| 26    | minIntervalTime         |          | **S**    | 毫秒     | 时间窗口最小值                                               | 1-1000000                                                    | 10                                                           |                                                              |
| 27    | stream                  |          | **S**    |         | 是否启用连续查询（流计算功能）                                  | 0：不允许；1：允许                                             | 1                                                            |                                                              |
| 28    | maxStreamCompDelay      |          | **S**    | 毫秒     | 连续查询启动最大延迟                                         | 10-1000000000                                                | 20000                                                        | 为避免多个stream同时执行占用太多系统资源，程序中对stream的执行时间人为增加了一些随机的延时。maxFirstStreamCompDelay 是stream第一次执行前最少要等待的时间。streamCompDelayRatio 是延迟时间的计算系数，它乘以查询的 interval 后为延迟时间基准。maxStreamCompDelay是延迟时间基准的上限。实际延迟时间为一个不超过延迟时间基准的随机值。stream某次计算失败后需要重试，retryStreamCompDelay是重试的等待时间基准。实际重试等待时间为不超过等待时间基准的随机值。 |
| 29    | maxFirstStreamCompDelay |          | **S**    | 毫秒     | 第一次连续查询启动最大延迟                                   | 10-1000000000                                                | 10000                                                        |                                                              |
| 30    | retryStreamCompDelay    |          | **S**    | 毫秒     | 连续查询重试等待间隔                                         | 10-1000000000                                                | 10                                                           |                                                              |
| 31    | streamCompDelayRatio    |          | **S**    |          | 连续查询的延迟时间计算系数                                   | 0.1-0.9                                                      | 0.1                                                          |                                                              |
| 32    | maxVgroupsPerDb         |          | **S**    |          | 每个DB中 能够使用的最大vnode个数                             | 0-8192                                                       |                                                              |                                                              |
| 33    | maxTablesPerVnode       |          | **S**    |          | 每个vnode中能够创建的最大表个数                              |                                                              | 1000000                                                      |                                                              |
| 34    | minTablesPerVnode       | YES      | **S**    |          | 每个vnode中必须创建的最小表个数                              |                                                              | 100                                                          |                                                              |
| 35    | tableIncStepPerVnode    | YES      | **S**    |          | 每个vnode中超过最小表数后递增步长                            |                                                              | 1000                                                         |                                                              |
| 36    | cache                   |          | **S**    | MB       | 内存块的大小                                                 |                                                              | 16                                                           |                                                              |
| 37    | blocks                  |          | **S**    |          | 每个vnode（tsdb）中有多少cache大小的内存块。因此一个vnode的用的内存大小粗略为（cache * blocks） |                                                              | 6                                                            |                                                              |
| 38    | days                    |          | **S**    | 天       | 数据文件存储数据的时间跨度                                   |                                                              | 10                                                           |                                                              |
| 39    | keep                    |          | **S**    | 天       | 数据保留的天数                                               |                                                              | 3650                                                         |                                                              |
| 40    | minRows                 |          | **S**    |          | 文件块中记录的最小条数                                       |                                                              | 100                                                          |                                                              |
| 41    | maxRows                 |          | **S**    |          | 文件块中记录的最大条数                                       |                                                              | 4096                                                         |                                                              |
| 42    | quorum                  |          | **S**    |          | 多副本环境下指令执行的确认数要求                                 | 1,2                                                          | 1                                                            |                                                              |
| 43    | comp                    |          | **S**    |          | 文件压缩标志位                                               | 0：关闭，1:一阶段压缩，2:两阶段压缩                          | 2                                                            |                                                              |
| 44    | walLevel                |          | **S**    |          | WAL级别                                                      | 1：写wal, 但不执行fsync; 2：写wal,  而且执行fsync            | 1                                                            |                                                              |
| 45    | fsync                   |          | **S**    | 毫秒     | 当wal设置为2时，执行fsync的周期                              | 最小为0，表示每次写入，立即执行fsync；最大为180000（三分钟） | 3000                                                         |                                                              |
| 46    | replica                 |          | **S**    |          | 副本个数                                                     | 1-3                                                          | 1                                                            |                                                              |
| 47    | mqttHostName            | YES      | **S**    |          | mqtt uri                                                     |                                                              |                                                              | [mqtt://username:password@hostname:1883/taos/](mqtt://username:password@hostname:1883/taos/) |
| 48    | mqttPort                | YES      | **S**    |          | mqtt client name                                             |                                                              |                                                              | 1883                                                         |
| 49    | mqttTopic               | YES      | **S**    |          |                                                              |                                                              |                                                              | /test                                                        |
| 50    | compressMsgSize         |          | **S**    | bytes    | 客户端与服务器之间进行消息通讯过程中，对通讯的消息进行压缩的阈值。如果要压缩消息，建议设置为64330字节，即大于64330字节的消息体才进行压缩。 | `0 `表示对所有的消息均进行压缩  >0: 超过该值的消息才进行压缩  -1: 不压缩 | -1                                                           |                                                              |
| 51    | maxSQLLength            |          | **C**    | bytes    | 单条SQL语句允许的最长限制                                      | 65480-1048576                                                | 1048576                                                        |                                                              |
| 52    | maxNumOfOrderedRes      |          | **SC**   |          | 支持超级表时间排序允许的最多记录数限制                       |                                                              | 10万                                                         |                                                              |
| 53    | timezone                |          | **SC**   |          | 时区                                                         |                                                              | 从系统中动态获取当前的时区设置                               |                                                              |
| 54    | locale                  |          | **SC**   |          | 系统区位信息及编码格式                                       |                                                              | 系统中动态获取，如果自动获取失败，需要用户在配置文件设置或通过API设置 |                                                              |
| 55    | charset                 |          | **SC**   |          | 字符集编码                                                   |                                                              | 系统中动态获取，如果自动获取失败，需要用户在配置文件设置或通过API设置 |                                                              |
| 56    | maxShellConns           |          | **S**    |          | 一个dnode容许的连接数                                        | 10-50000000                                                  | 5000                                                         |                                                              |
| 57    | maxConnections          |          | **S**    |          | 一个数据库连接所容许的dnode连接数                            | 1-100000                                                     | 5000                                                         | 实际测试下来，如果默认没有配，选 50 个 worker thread 会产生 Network unavailable |
| 58    | minimalLogDirGB         |          | **SC**   | GB       | 当日志文件夹的磁盘大小小于该值时，停止写日志                 |                                                              | 0.1                                                          |                                                              |
| 59    | minimalTmpDirGB         |          | **SC**   | GB       | 当日志文件夹的磁盘大小小于该值时，停止写临时文件             |                                                              | 0.1                                                          |                                                              |
| 60    | minimalDataDirGB        |          | **S**    | GB       | 当日志文件夹的磁盘大小小于该值时，停止写时序数据             |                                                              | 0.1                                                          |                                                              |
| 61    | mnodeEqualVnodeNum      |          | **S**    |          | 一个mnode等同于vnode消耗的个数                               |                                                              | 4                                                            |                                                              |
| 62    | http                    |          | **S**    |          | 服务器内部的http服务开关。                                   | 0：关闭http服务， 1：激活http服务。                          | 1                                                            |                                                              |
| 63    | mqtt                    | YES      | **S**    |          | 服务器内部的mqtt服务开关。                                   | 0：关闭mqtt服务， 1：激活mqtt服务。                          | 0                                                            |                                                              |
| 64    | monitor                 |          | **S**    |          | 服务器内部的系统监控开关。监控主要负责收集物理节点的负载状况，包括CPU、内存、硬盘、网络带宽、HTTP请求量的监控记录，记录信息存储在`LOG`库中。 | 0：关闭监控服务， 1：激活监控服务。                          | 0                                                            |                                                              |
| 65    | httpEnableRecordSql     |          | **S**    |          | 内部使用，记录通过RESTFul接口，产生的SQL调用                 |                                                              | 0                                                            | 生成的文件（httpnote.0/httpnote.1），与服务端日志所在目录相同。 |
| 66    | httpMaxThreads          |          | **S**    |          | RESTFul接口的线程数                                          |                                                              | 2                                                            |                                                              |
| 67    | telegrafUseFieldNum     | YES      |          |          |                                                              |                                                              |                                                              |                                                              |
| 68    | restfulRowLimit         |          | **S**    |          | RESTFul接口单次返回的记录条数                                |                                                              | 10240                                                        | 最大10,000,000                                               |
| 69    | numOfLogLines           |          | **SC**   |          | 单个日志文件允许的最大行数。                                 |                                                              | 10,000,000                                                   |                                                              |
| 70    | asyncLog                |          | **SC**   |          | 日志写入模式                                                 | 0：同步、1：异步                                             | 1                                                            |                                                              |
| 71    | logKeepDays             |          | **SC**   | 天       | 日志文件的最长保存时间                                         |                                                              | 0                                                            | 大于0时，日志文件会被重命名为taosdlog.xxx，其中xxx为日志文件最后修改的时间戳。       |
| 72    | debugFlag               |          | **SC**   |          | 运行日志开关                                                 | 131（输出错误和警告日志），135（输出错误、警告和调试日志），143（输出错误、警告、调试和跟踪日志） | 131或135（不同模块有不同的默认值）                               |                                           |
| 73    | mDebugFlag              |          | **S**    |          | 管理模块的日志开关                                           | 同上                                                         | 135                                                          |                                                              |
| 74    | dDebugFlag              |          | **SC**   |          | dnode模块的日志开关                                          | 同上                                                         | 135                                                          |                                                              |
| 75    | sDebugFlag              |          | **SC**   |          | sync模块的日志开关                                           | 同上                                                         | 135                                                          |                                                              |
| 76    | wDebugFlag              |          | **SC**   |          | wal模块的日志开关                                            | 同上                                                         | 135                                                          |                                                              |
| 77    | sdbDebugFlag            |          | **SC**   |          | sdb模块的日志开关                                            | 同上                                                         | 135                                                          |                                                              |
| 78    | rpcDebugFlag            |          | **SC**   |          | rpc模块的日志开关                                            | 同上                                                         |                                                              |                                                              |
| 79    | tmrDebugFlag            |          | **SC**   |          | 定时器模块的日志开关                                         | 同上                                                         |                                                              |                                                              |
| 80    | cDebugFlag              |          | **C**    |          | client模块的日志开关                                         | 同上                                                         |                                                              |                                                              |
| 81    | jniDebugFlag            |          | **C**    |          | jni模块的日志开关                                            | 同上                                                         |                                                              |                                                              |
| 82    | odbcDebugFlag           |          | **C**    |          | odbc模块的日志开关                                           | 同上                                                         |                                                              |                                                              |
| 83    | uDebugFlag              |          | **SC**   |          | 共用功能模块的日志开关                                       | 同上                                                         |                                                              |                                                              |
| 84    | httpDebugFlag           |          | **S**    |          | http模块的日志开关                                           | 同上                                                         |                                                              |                                                              |
| 85    | mqttDebugFlag           |          | **S**    |          | mqtt模块的日志开关                                           | 同上                                                         |                                                              |                                                              |
| 86    | monitorDebugFlag        |          | **S**    |          | 监控模块的日志开关                                           | 同上                                                         |                                                              |                                                              |
| 87    | qDebugFlag              |          | **SC**   |          | 查询模块的日志开关                                           | 同上                                                         |                                                              |                                                              |
| 88    | vDebugFlag              |          | **SC**   |          | vnode模块的日志开关                                          | 同上                                                         |                                                              |                                                              |
| 89    | tsdbDebugFlag           |          | **S**    |          | TSDB模块的日志开关                                           | 同上                                                         |                                                              |                                                              |
| 90    | cqDebugFlag             |          | **SC**   |          | 连续查询模块的日志开关                                       | 同上                                                         |                                                              |                                                              |
| 91    | tscEnableRecordSql      |          | **C**    |          | 是否记录客户端sql语句到文件                                  | 0：否，1：是                                                 | 0                                                            | 生成的文件（tscnote-xxxx.0/tscnote-xxx.1，xxxx是pid），与客户端日志所在目录相同。 |
| 92    | enableCoreFile          |          | **SC**   |          | 是否开启服务crash时生成core文件                              | 0：否，1：是                                                 | 1                                                            | 不同的启动方式，生成core文件的目录如下：1、systemctl start taosd启动：生成的core在根目录下；2、手动启动，就在taosd执行目录下。 |
| 93    | gitinfo                 | YES      | **SC**   |          |                                                              | 1                                                            |                                                              |                                                              |
| 94    | gitinfoofInternal       | YES      | **SC**   |          |                                                              | 2                                                            |                                                              |                                                              |
| 95    | Buildinfo               | YES      | **SC**   |          |                                                              | 3                                                            |                                                              |                                                              |
| 96    | version                 | YES      | **SC**   |          |                                                              | 4                                                            |                                                              |                                                              |
| 97    |                         |          |          |          |                                                              |                                                              |                                                              |                                                              |
| 98    | maxBinaryDisplayWidth   |          | **C**    |          | Taos shell中binary 和 nchar字段的显示宽度上限，超过此限制的部分将被隐藏 | 5    -                                                       | 30                                                           | 实际上限按以下规则计算：如果字段值的长度大于 maxBinaryDisplayWidth，则显示上限为 **字段名长度** 和 **maxBinaryDisplayWidth** 的较大者。否则，上限为 **字段名长度** 和 **字段值长度** 的较大者。可在 shell 中通过命令 set max_binary_display_width nn动态修改此选项 |
| 99    | queryBufferSize         |          | **S**    | MB       | 为所有并发查询占用保留的内存大小。                           |                                                              |                                                              | 计算规则可以根据实际应用可能的最大并发数和表的数字相乘，再乘 170 。（2.0.15 以前的版本中，此参数的单位是字节） |
| 100   | ratioOfQueryCores       |          | **S**    |          | 设置查询线程的最大数量。                                     |                                                              |                                                              | 最小值0 表示只有1个查询线程；最大值2表示最大建立2倍CPU核数的查询线程。默认为1，表示最大和CPU核数相等的查询线程。该值可以为小数，即0.5表示最大建立CPU核数一半的查询线程。 |
| 101   | update                  |          | **S**    |          | 允许更新已存在的数据行                                         | 0：不允许更新；1：允许整行更新；2：允许部分列更新。（2.1.7.0 版本开始此参数支持设为 2，在此之前取值只能是 [0, 1]）                                                      | 0                                                            | 2.0.8.0 版本之前，不支持此参数。                                                       |
| 102   | cacheLast               |          | **S**    |          | 是否在内存中缓存子表的最近数据                                  | 0：关闭；1：缓存子表最近一行数据；2：缓存子表每一列的最近的非NULL值；3：同时打开缓存最近行和列功能。（2.1.2.0 版本开始此参数支持 0～3 的取值范围，在此之前取值只能是 [0, 1]）                      | 0                                                            | 2.1.2.0 版本之前、2.0.20.7 版本之前在 taos.cfg 文件中不支持此参数。                                             |
| 103   | numOfCommitThreads      | YES      | **S**    |          | 设置写入线程的最大数量                                       |                                                              |                                                              |                                                              |
| 104   | maxWildCardsLength      |          | **C**    | bytes    | 设定 LIKE 算子的通配符字符串允许的最大长度                     | 0-16384                                                       | 100                                                          | 2.1.6.1 版本新增。                                                     |
| 105  | compressColData         |          | **S**    | bytes    | 客户端与服务器之间进行消息通讯过程中，对服务器端查询结果进行列压缩的阈值。 | 0: 对所有查询结果均进行压缩  >0: 查询结果中任意列大小超过该值的消息才进行压缩  -1: 不压缩 | -1                                                           | 2.3.0.0 版本新增。                     |
| 106    | tsdbMetaCompactRatio      |          | **C**    |          | tsdb meta文件中冗余数据超过多少阈值，开启meta文件的压缩功能                                  | 0：不开启，[1-100]：冗余数据比例                                                 | 0                                                            |  |
| 107    | rpcForceTcp | | **SC**|  | 强制使用TCP传输 | 0: 不开启 1: 开启 ｜  0 ｜ 在网络比较差的环境中，建议开启。2.0版本新增。｜
| 108    | maxNumOfDistinctRes | | **S**|  | 允许返回的distinct结果最大行数 |默认值为10万，最大值1亿 | 10万 ｜ 2.3版本新增。｜
| 109    | clientMerge | | **C**|  | 是否允许客户端对写入数据去重 |0：不开启，1：开启｜  0 ｜ 2.3版本新增。｜
| 110   | httpDBNameMandatory | | **S**|  | 是否在URL中输入 数据库名称|0：不开启，1：开启｜  0 ｜ 2.3版本新增。｜

**注意：**对于端口，TDengine会使用从serverPort起13个连续的TCP和UDP端口号，请务必在防火墙打开。因此如果是缺省配置，需要打开从6030到6042共13个端口，而且必须TCP和UDP都打开。（详细的端口情况请参见 [TDengine 2.0 端口说明](https://www.taosdata.com/cn/documentation/faq#port)）

不同应用场景的数据往往具有不同的数据特征，比如保留天数、副本数、采集频次、记录大小、采集点的数量、压缩等都可完全不同。为获得在存储上的最高效率，TDengine提供如下存储相关的系统配置参数（既可以作为 create database 指令的参数，也可以写在 taos.cfg 配置文件中用来设定创建新数据库时所采用的默认值）：

| **#** | **配置参数名称** | **单位** | **含义**                                                     | **取值范围**                                     | **缺省值** |
| ----- | ---------------- | -------- | ------------------------------------------------------------ | ------------------------------------------------ | ---------- |
| 1     | days             | 天       | 一个数据文件存储数据的时间跨度                               |                                                  | 10         |
| 2     | keep             | 天       | （可通过 alter database 修改<!-- REPLACE_OPEN_TO_ENTERPRISE__KEEP_PARAM_DESCRIPTION_IN_PARAM_LIST -->）数据库中数据保留的天数。                            | 3650       |
| 3     | cache            | MB       | 内存块的大小                                                 |                                                  | 16         |
| 4     | blocks           |          | （可通过 alter database 修改）每个 VNODE（TSDB）中有多少个 cache 大小的内存块。因此一个 VNODE 使用的内存大小粗略为（cache * blocks）。                  |                                                  | 6          |
| 5     | quorum           |          | （可通过 alter database 修改）多副本环境下指令执行的确认数要求   | 1-2                                              | 1          |
| 6     | minRows          |          | 文件块中记录的最小条数                                       |                                                  | 100        |
| 7     | maxRows          |          | 文件块中记录的最大条数                                       |                                                  | 4096       |
| 8     | comp             |          | （可通过 alter database 修改）文件压缩标志位                                               | 0：关闭，1:一阶段压缩，2:两阶段压缩              | 2          |
| 9     | walLevel         |          | （作为 database 的参数时名为 wal；在 taos.cfg 中作为参数时需要写作 walLevel）WAL级别          | 1：写wal，但不执行fsync；2：写wal, 而且执行fsync | 1          |
| 10    | fsync            | 毫秒     | 当wal设置为2时，执行fsync的周期。设置为0，表示每次写入，立即执行fsync。                         |                                                  | 3000       |
| 11    | replica          |          | （可通过 alter database 修改）副本个数                                                     | 1-3                                            | 1          |
| 12    | precision        |          | 时间戳精度标识（2.1.2.0 版本之前、2.0.20.7 版本之前在 taos.cfg 文件中不支持此参数。）（从 2.1.5.0 版本开始，新增对纳秒时间精度的支持）           | ms 表示毫秒，us 表示微秒，ns 表示纳秒                 | ms         |
| 13    | update           |          | 是否允许数据更新（从 2.1.7.0 版本开始此参数支持 0～2 的取值范围，在此之前取值只能是 [0, 1]；而 2.0.8.0 之前的版本在 SQL 指令中不支持此参数。）                                                  | 0：不允许；1：允许更新整行；2：允许部分列更新。                                           | 0          |
| 14    | cacheLast        |          | （可通过 alter database 修改）是否在内存中缓存子表的最近数据（从 2.1.2.0 版本开始此参数支持 0～3 的取值范围，在此之前取值只能是 [0, 1]；而 2.0.11.0 之前的版本在 SQL 指令中不支持此参数。）（2.1.2.0 版本之前、2.0.20.7 版本之前在 taos.cfg 文件中不支持此参数。）                         | 0：关闭；1：缓存子表最近一行数据；2：缓存子表每一列的最近的非NULL值；3：同时打开缓存最近行和列功能               | 0          |

对于一个应用场景，可能有多种数据特征的数据并存，最佳的设计是将具有相同数据特征的表放在一个库里，这样一个应用有多个库，而每个库可以配置不同的存储参数，从而保证系统有最优的性能。TDengine允许应用在创建库时指定上述存储参数，如果指定，该参数就将覆盖对应的系统配置参数。举例，有下述SQL：

```mysql
 CREATE DATABASE demo DAYS 10 CACHE 32 BLOCKS 8 REPLICA 3 UPDATE 1;
```

该SQL创建了一个库demo, 每个数据文件存储10天数据，内存块为32兆字节，每个VNODE占用8个内存块，副本数为3，允许更新，而其他参数与系统配置完全一致。

一个数据库创建成功后，仅部分参数可以修改并实时生效，其余参数不能修改：

| **参数名**  | **能否修改** | **范围**                                                     | **修改语法示例**                      |
| ----------- | ------------ | ------------------------------------------------------------ | ------------------------------------- |
| name        |              |                                                              |                                       |
| create time |              |                                                              |                                       |
| ntables     |              |                                                              |                                       |
| vgroups     |              |                                                              |                                       |
| replica     | **YES**      | 在线dnode数目为1：1-1；2：1-2；>=3：1-3                         | ALTER DATABASE <dbname> REPLICA *n*   |
| quorum      | **YES**      | 1-2                                                          | ALTER DATABASE <dbname> QUORUM *n*    |
| days        |              |                                                              |                                       |
| keep        | **YES**      | days-365000                                                  | ALTER DATABASE <dbname> KEEP *n*      |
| cache       |              |                                                              |                                       |
| blocks      | **YES**      | 3-1000                                                       | ALTER DATABASE <dbname> BLOCKS *n*    |
| minrows     |              |                                                              |                                       |
| maxrows     |              |                                                              |                                       |
| wal         |              |                                                              |                                       |
| fsync       |              |                                                              |                                       |
| comp        | **YES**      | 0-2                                                          | ALTER DATABASE <dbname> COMP *n*      |
| precision   |              |                                                              |                                       |
| status      |              |                                                              |                                       |
| update      |              |                                                              |                                       |
| cachelast   | **YES**      | 0 \| 1 \| 2 \| 3                                             | ALTER DATABASE <dbname> CACHELAST *n* |

**说明：**在 2.1.3.0 版本之前，通过 ALTER DATABASE 语句修改这些参数后，需要重启服务器才能生效。

TDengine集群中加入一个新的dnode时，涉及集群相关的一些参数必须与已有集群的配置相同，否则不能成功加入到集群中。会进行校验的参数如下：

- numOfMnodes：系统中管理节点个数。默认值：3。（2.0 版本从 2.0.20.11 开始、2.1 及以上版本从 2.1.6.0 开始，numOfMnodes 默认值改为 1。）
- mnodeEqualVnodeNum: 一个mnode等同于vnode消耗的个数。默认值：4。
- offlineThreshold: dnode离线阈值，超过该时间将导致该dnode从集群中删除。单位为秒，默认值：86400*10（即10天）。
- statusInterval: dnode向mnode报告状态时长。单位为秒，默认值：1。
- maxTablesPerVnode: 每个vnode中能够创建的最大表个数。默认值：1000000。
- maxVgroupsPerDb: 每个数据库中能够使用的最大vgroup个数。
- arbitrator: 系统中裁决器的end point，缺省为空。
- timezone、locale、charset 的配置见客户端配置。（2.0.20.0 及以上的版本里，集群中加入新节点已不要求 locale 和 charset 参数取值一致）
- balance：是否启用负载均衡。0：否，1：是。默认值：1。
- flowctrl：是否启用非阻塞流控。0：否，1：是。默认值：1。
- slaveQuery：是否启用 slave vnode 参与查询。0：否，1：是。默认值：1。
- adjustMaster：是否启用 vnode master 负载均衡。0：否，1：是。默认值：1。

为方便调试，可通过SQL语句临时调整每个dnode的日志配置，系统重启后会失效：

```mysql
ALTER DNODE <dnode_id> <config>
```

- dnode_id: 可以通过SQL语句"SHOW DNODES"命令获取
- config: 要调整的日志参数，在如下列表中取值
    > resetlog 截断旧日志文件，创建一个新日志文件
    > debugFlag  < 131 | 135 | 143 > 设置debugFlag为131、135或者143

例如：
```
    alter dnode 1 debugFlag 135;
```

## <a class="anchor" id="client"></a>客户端及应用驱动配置

TDengine系统的前台交互客户端应用程序为taos，以及应用驱动，它与taosd共享同一个配置文件taos.cfg。运行taos时，使用参数-c指定配置文件目录，如taos -c /home/cfg，表示使用/home/cfg/目录下的taos.cfg配置文件中的参数，缺省目录是/etc/taos。更多taos的使用方法请见帮助信息 `taos --help`。本节主要说明 taos 客户端应用在配置文件 taos.cfg 文件中使用到的参数。

**2.0.10.0 之后版本支持命令行以下参数显示当前客户端参数的配置**

```bash
taos -C  或  taos --dump-config
```

客户端及应用驱动配置参数列表及解释

- firstEp: taos启动时，主动连接的集群中第一个taosd实例的end point, 缺省值为 localhost:6030。

- secondEp: taos 启动时，如果 firstEp 连不上，将尝试连接 secondEp。

- locale：系统区位信息及编码格式。

    默认值：系统中动态获取，如果自动获取失败，需要用户在配置文件设置或通过API设置。

    TDengine为存储中文、日文、韩文等非ASCII编码的宽字符，提供一种专门的字段类型nchar。写入nchar字段的数据将统一采用UCS4-LE格式进行编码并发送到服务器。需要注意的是，编码正确性是客户端来保证。因此，如果用户想要正常使用nchar字段来存储诸如中文、日文、韩文等非ASCII字符，需要正确设置客户端的编码格式。

    客户端的输入的字符均采用操作系统当前默认的编码格式，在Linux系统上多为UTF-8，部分中文系统编码则可能是GB18030或GBK等。在docker环境中默认的编码是POSIX。在中文版Windows系统中，编码则是CP936。客户端需要确保正确设置自己所使用的字符集，即客户端运行的操作系统当前编码字符集，才能保证nchar中的数据正确转换为UCS4-LE编码格式。

    在 Linux 中 locale 的命名规则为: <语言>\_<地区>.<字符集编码> 如：zh_CN.UTF-8，zh代表中文，CN代表大陆地区，UTF-8表示字符集。字符集编码为客户端正确解析本地字符串提供编码转换的说明。Linux系统与 Mac OSX 系统可以通过设置locale来确定系统的字符编码，由于Windows使用的locale中不是POSIX标准的locale格式，因此在Windows下需要采用另一个配置参数charset来指定字符编码。在Linux 系统中也可以使用charset来指定字符编码。

- charset：字符集编码。

    默认值：系统中动态获取，如果自动获取失败，需要用户在配置文件设置或通过API设置。

    如果配置文件中不设置charset，在Linux系统中，taos在启动时候，自动读取系统当前的locale信息，并从locale信息中解析提取charset编码格式。如果自动读取locale信息失败，则尝试读取charset配置，如果读取charset配置也失败，则中断启动过程。

    在Linux系统中，locale信息包含了字符编码信息，因此正确设置了Linux系统locale以后可以不用再单独设置charset。例如：
    ```
    locale zh_CN.UTF-8
    ```
    在Windows系统中，无法从locale获取系统当前编码。如果无法从配置文件中读取字符串编码信息，taos默认设置为字符编码为CP936。其等效在配置文件中添加如下配置：
    ```
    charset CP936
    ```
    如果需要调整字符编码，请查阅当前操作系统使用的编码，并在配置文件中正确设置。

    在Linux系统中，如果用户同时设置了locale和字符集编码charset，并且locale和charset的不一致，后设置的值将覆盖前面设置的值。
    ```
    locale zh_CN.UTF-8
    charset GBK
    ```
    则charset的有效值是GBK。
    ```
    charset GBK
    locale zh_CN.UTF-8
    ```
    charset的有效值是UTF-8。

    日志的配置参数，与server 的配置参数完全一样。

- timezone

    默认值：动态获取当前客户端运行系统所在的时区。
  
    为应对多时区的数据写入和查询问题，TDengine 采用 Unix 时间戳(Unix Timestamp)来记录和存储时间戳。Unix 时间戳的特点决定了任一时刻不论在任何时区，产生的时间戳均一致。需要注意的是，Unix时间戳是在客户端完成转换和记录。为了确保客户端其他形式的时间转换为正确的 Unix 时间戳，需要设置正确的时区。

    在Linux系统中，客户端会自动读取系统设置的时区信息。用户也可以采用多种方式在配置文件设置时区。例如：
    ```
    timezone UTC-8
    timezone GMT-8
    timezone Asia/Shanghai
    ```
    均是合法的设置东八区时区的格式。但需注意，Windows 下并不支持 `timezone Asia/Shanghai` 这样的写法，而必须写成 `timezone UTC-8`。

    时区的设置对于查询和写入SQL语句中非Unix时间戳的内容（时间戳字符串、关键词now的解析）产生影响。例如：
    ```sql
    SELECT count(*) FROM table_name WHERE TS<'2019-04-11 12:01:08';
    ```
    在东八区，SQL语句等效于
    ```sql
    SELECT count(*) FROM table_name WHERE TS<1554955268000;
    ```
    在UTC时区，SQL语句等效于
    ```sql
    SELECT count(*) FROM table_name WHERE TS<1554984068000;
    ```
    为了避免使用字符串时间格式带来的不确定性，也可以直接使用Unix时间戳。此外，还可以在SQL语句中使用带有时区的时间戳字符串，例如：RFC3339格式的时间戳字符串，2013-04-12T15:52:01.123+08:00或者ISO-8601格式时间戳字符串2013-04-12T15:52:01.123+0800。上述两个字符串转化为Unix时间戳不受系统所在时区的影响。

    启动taos时，也可以从命令行指定一个taosd实例的end point，否则就从taos.cfg读取。

- maxBinaryDisplayWidth

    Shell中 binary 和 nchar 字段的显示宽度上限，超过此限制的部分将被隐藏。默认值：30。可在 taos shell 中通过命令 set max_binary_display_width nn 动态修改此选项。

## <a class="anchor" id="user"></a>用户管理

系统管理员可以在CLI界面里添加、删除用户，也可以修改密码。CLI里SQL语法如下：

```sql
CREATE USER <user_name> PASS <'password'>;
```

创建用户，并指定用户名和密码，密码需要用单引号引起来，单引号为英文半角

```sql
DROP USER <user_name>;
```

删除用户，限root用户使用

```sql
ALTER USER <user_name> PASS <'password'>;
```

修改用户密码，为避免被转换为小写，密码需要用单引号引用，单引号为英文半角

```sql
ALTER USER <user_name> PRIVILEGE <write|read>;
```

修改用户权限为：write 或 read，不需要添加单引号

说明：系统内共有 super/write/read 三种权限级别，但目前不允许通过 alter 指令把 super 权限赋予用户。

```mysql
SHOW USERS;
```

显示所有用户

**注意：**SQL 语法中，< >表示需要用户输入的部分，但请不要输入< >本身。

## <a class="anchor" id="import"></a>数据导入

TDengine提供多种方便的数据导入功能，一种按脚本文件导入，一种按数据文件导入，一种是taosdump工具导入本身导出的文件。

**按脚本文件导入**

TDengine的shell支持source filename命令，用于批量运行文件中的SQL语句。用户可将建库、建表、写数据等SQL命令写在同一个文件中，每条命令单独一行，在shell中运行source命令，即可按顺序批量运行文件中的SQL语句。以‘#’开头的SQL语句被认为是注释，shell将自动忽略。

**按数据文件导入**

TDengine也支持在shell对已存在的表从CSV文件中进行数据导入。CSV文件只属于一张表且CSV文件中的数据格式需与要导入表的结构相同，在导入的时候，其语法如下：

```mysql
insert into tb1 file 'path/data.csv';
```
**注意：如果CSV文件首行存在描述信息，请手动删除后再导入。如某列为空，填NULL，无引号。**

例如，现在存在一个子表d1001, 其表结构如下：

```mysql
taos> DESCRIBE d1001
             Field              |        Type        |   Length    |    Note    |
=================================================================================
 ts                             | TIMESTAMP          |           8 |            |
 current                        | FLOAT              |           4 |            |
 voltage                        | INT                |           4 |            |
 phase                          | FLOAT              |           4 |            |
 location                       | BINARY             |          64 | TAG        |
 groupid                        | INT                |           4 | TAG        |
```
要导入的data.csv的格式如下：

```csv
'2018-10-04 06:38:05.000',10.30000,219,0.31000
'2018-10-05 06:38:15.000',12.60000,218,0.33000
'2018-10-06 06:38:16.800',13.30000,221,0.32000
'2018-10-07 06:38:05.000',13.30000,219,0.33000
'2018-10-08 06:38:05.000',14.30000,219,0.34000
'2018-10-09 06:38:05.000',15.30000,219,0.35000
'2018-10-10 06:38:05.000',16.30000,219,0.31000
'2018-10-11 06:38:05.000',17.30000,219,0.32000
'2018-10-12 06:38:05.000',18.30000,219,0.31000
```
那么可以用如下命令导入数据：

```mysql
taos> insert into d1001 file '~/data.csv';
Query OK, 9 row(s) affected (0.004763s)
```

**taosdump工具导入**

TDengine提供了方便的数据库导入导出工具taosdump。用户可以将taosdump从一个系统导出的数据，导入到其他系统中。具体使用方法，请参见博客：[TDengine DUMP工具使用指南](https://www.taosdata.com/blog/2020/03/09/1334.html)。

## <a class="anchor" id="export"></a>数据导出

为方便数据导出，TDengine提供了两种导出方式，分别是按表导出和用taosdump导出。

**按表导出CSV文件**

如果用户需要导出一个表或一个STable中的数据，可在taos shell中运行：

```mysql
select * from <tb_name> >> data.csv;
```

这样，表tb_name中的数据就会按照CSV格式导出到文件data.csv中。

**用taosdump导出数据**

利用taosdump，用户可以根据需要选择导出所有数据库、一个数据库或者数据库中的一张表，所有数据或一时间段的数据，甚至仅仅表的定义。

具体使用方法，请参见博客：[TDengine DUMP工具使用指南](https://www.taosdata.com/blog/2020/03/09/1334.html)。

## <a class="anchor" id="status"></a>系统连接、任务查询管理

系统管理员可以从CLI查询系统的连接、正在进行的查询、流式计算，并且可以关闭连接、停止正在进行的查询和流式计算。CLI里SQL语法如下：

```mysql
SHOW CONNECTIONS;
```

显示数据库的连接，其中一列显示ip:port, 为连接的IP地址和端口号。

```mysql
KILL CONNECTION <connection-id>;
```

强制关闭数据库连接，其中的connection-id是SHOW CONNECTIONS中显示的第一列的数字。

```mysql
SHOW QUERIES;
```

显示数据查询，其中第一列显示的以冒号隔开的两个数字为query-id，为发起该query应用连接的connection-id和查询次数。

```mysql
KILL QUERY <query-id>;
```

强制关闭数据查询，其中query-id是SHOW QUERIES中显示的 connection-id:query-no字串，如“105:2”，拷贝粘贴即可。

```mysql
SHOW STREAMS;
```

显示流式计算，其中第一列显示的以冒号隔开的两个数字为stream-id, 为启动该stream应用连接的connection-id和发起stream的次数。

```mysql
KILL STREAM <stream-id>;
```

强制关闭流式计算，其中的中stream-id是SHOW STREAMS中显示的connection-id:stream-no字串，如103:2，拷贝粘贴即可。

## <a class="anchor" id="monitoring"></a>系统监控

TDengine启动后，会自动创建一个监测数据库log，并自动将服务器的CPU、内存、硬盘空间、带宽、请求数、磁盘读写速度、慢查询等信息定时写入该数据库。TDengine还将重要的系统操作（比如登录、创建、删除数据库等）日志以及各种错误报警信息记录下来存放在log库里。系统管理员可以从CLI直接查看这个数据库，也可以在WEB通过图形化界面查看这些监测信息。

这些监测信息的采集缺省是打开的，但可以修改配置文件里的选项monitor将其关闭或打开。

### TDinsight - 使用监控数据库 + Grafana 对 TDengine 进行监控的解决方案

从 2.3.3.0 开始，监控数据库将提供更多的监控项，您可以从 [TDinsight Grafana Dashboard](https://grafana.com/grafana/dashboards/15167) 了解如何使用 TDinsight 方案对 TDengine 进行监控。

我们提供了一个自动化脚本 `TDinsight.sh` 对TDinsight进行部署。

下载 `TDinsight.sh`：

```bash
wget https://github.com/taosdata/grafanaplugin/raw/master/dashboards/TDinsight.sh
chmod +x TDinsight.sh
```

准备：

1. TDengine Server 信息：
    * TDengine RESTful 服务：对本地而言，可以是 http://localhost:6041 ，使用参数 `-a`。
    * TDengine 用户名和密码，使用 `-u` `-p` 参数设置。

2. Grafana 告警通知
   * 使用已经存在的Grafana Notification Channel `uid`，参数 `-E`。该参数可以使用 `curl -u admin:admin localhost:3000/api/alert-notifications |jq` 来获取。
  
        ```bash
        sudo ./TDinsight.sh -a http://localhost:6041 -u root -p taosdata -E <notifier uid>
        ```

   * 使用 TDengine 数据源插件内置的阿里云短信告警通知，使用 `-s` 启用之，并设置如下参数：
        1. 阿里云短信服务Key ID，参数 `-I`
        2. 阿里云短信服务Key Secret，参数 `K`
        3. 阿里云短信服务签名，参数 `-S`
        4. 短信通知模板号，参数 `-C`
        5. 短信通知模板输入参数，JSON格式，参数 `-T`，如 `{"alarm_level":"%s","time":"%s","name":"%s","content":"%s"}`
        6. 逗号分隔的通知手机列表，参数 `-B`

        ```bash
        sudo ./TDinsight.sh -a http://localhost:6041 -u root -p taosdata -s \
          -I XXXXXXX -K XXXXXXXX -S taosdata -C SMS_1111111 -B 18900000000 \
          -T '{"alarm_level":"%s","time":"%s","name":"%s","content":"%s"}'
        ```

运行程序并重启 Grafana 服务，打开面板：<http://localhost:3000/d/tdinsight>。

更多使用场景和限制请参考[TDinsight](https://github.com/taosdata/grafanaplugin/blob/master/dashboards/TDinsight.md) 文档。

<a class="anchor" id="optimize"></a>
## 性能优化

因数据行 [update](https://www.taosdata.com/cn/documentation/faq#update)、表删除、数据过期等原因，TDengine 的磁盘存储文件有可能出现数据碎片，影响查询操作的性能表现。从 2.1.3.0 版本开始，新增 SQL 指令 COMPACT 来启动碎片重整过程：

```mysql
COMPACT VNODES IN (vg_id1, vg_id2, ...)
```

COMPACT 命令对指定的一个或多个 VGroup 启动碎片重整，系统会通过任务队列尽快安排重整操作的具体执行。COMPACT 指令所需的 VGroup id，可以通过 `SHOW VGROUPS;` 指令的输出结果获取；而且在 `SHOW VGROUPS;` 中会有一个 compacting 列，值为 2 时表示对应的 VGroup 处于排队等待进行重整的状态，值为 1 时表示正在进行碎片重整，为 0 时则表示并没有处于重整状态（未要求进行重整或已经完成重整）。

需要注意的是，碎片重整操作会大幅消耗磁盘 I/O。因此在重整进行期间，有可能会影响节点的写入和查询性能，甚至在极端情况下导致短时间的阻写。

<a class="anchor" id="tsz_compress"></a>
## 浮点数有损压缩

在车联网等物联网智能应用场景中，经常会采集和存储海量的浮点数类型数据，如果能更高效地对此类数据进行压缩，那么不但能够节省数据存储的硬件资源，也能够因降低磁盘 I/O 数据量而提升系统性能表现。

从 2.1.6.0 版本开始，TDengine 提供一种名为 TSZ 的新型数据压缩算法，无论设置为有损压缩还是无损压缩，都能够显著提升浮点数类型数据的压缩率表现。目前该功能以可选模块的方式进行发布，可以通过添加特定的编译参数来启用该功能（也即常规安装包中暂未包含该功能）。

**需要注意的是，该功能一旦启用，效果是全局的，也即会对系统中所有的 FLOAT、DOUBLE 类型的数据生效。同时，在启用了浮点数有损压缩功能后写入的数据，也无法被未启用该功能的版本载入，并有可能因此而导致数据库服务报错退出。**

### 创建支持 TSZ 压缩算法的 TDengine 版本

TSZ 模块保存在单独的代码仓库 https://github.com/taosdata/TSZ 中。可以通过以下步骤创建包含此模块的 TDengine 版本：
1. TDengine 中的插件目前只支持通过 SSH 的方式拉取和编译，所以需要自己先配置好通过 SSH 拉取 GitHub 代码的环境。
2. `git clone git@github.com:taosdata/TDengine -b your_branchname --recurse-submodules` 通过 `--recurse-submodules` 使依赖模块的源代码可以被一并下载。
3. `mkdir debug && cd debug` 进入单独的编译目录。
4. `cmake .. -DTSZ_ENABLED=true` 其中参数 `-DTSZ_ENABLED=true` 表示在编译过程中加入对 TSZ 插件功能的支持。如果成功激活对 TSZ 模块的编译，那么 CMAKE 过程中也会显示 `build with TSZ enabled` 字样。
5. 编译成功后，包含 TSZ 浮点压缩功能的插件便已经编译进了 TDengine 中了，可以通过调整 taos.cfg 中的配置参数来使用此功能了。

### 通过配置文件来启用 TSZ 压缩算法

如果要启用 TSZ 压缩算法，除了在 TDengine 的编译过程需要声明启用 TSZ 模块之外，还需要在 taos.cfg 配置文件中对以下参数进行设置：
* lossyColumns：配置要进行有损压缩的浮点数数据类型。参数值类型为字符串，含义为：空 - 关闭有损压缩；float - 只对 FLOAT 类型进行有损压缩；double - 只对 DOUBLE 类型进行有损压缩；float|double：对 FLOAT 和 DOUBLE 类型都进行有损压缩。默认值是“空”，也即关闭有损压缩。
* fPrecision：设置 float 类型浮点数压缩精度，小于此值的浮点数尾数部分将被截断。参数值类型为 FLOAT，最小值为 0.0，最大值为 100,000.0。缺省值为 0.00000001（1E-8）。
* dPrecision：设置 double 类型浮点数压缩精度，小于此值的浮点数尾数部分将被截断。参数值类型为 DOUBLE，最小值为 0.0，最大值为 100,000.0。缺省值为 0.0000000000000001（1E-16）。
* maxRange：表示数据的最大浮动范围。一般无需调整，在数据具有特定特征时可以配合 range 参数来实现极高的数据压缩率。默认值为 500。
* range：表示数据大体浮动范围。一般无需调整，在数据具有特定特征时可以配合 maxRange 参数来实现极高的数据压缩率。默认值为 100。

**注意：**对 cfg 配置文件中参数值的任何调整，都需要重新启动 taosd 才能生效。并且以上选项为全局配置选项，配置后对所有数据库中所有表的 FLOAT 及 DOUBLE 类型的字段生效。

## <a class="anchor" id="directories"></a>文件目录结构

安装TDengine后，默认会在操作系统中生成下列目录或文件：

| **目录/文件**             | **说明**                                                     |
| ------------------------- | ------------------------------------------------------------ |
| /usr/local/taos/bin       | TDengine可执行文件目录。其中的执行文件都会软链接到/usr/bin目录下。 |
| /usr/local/taos/connector | TDengine各种连接器目录。                                     |
| /usr/local/taos/driver    | TDengine动态链接库目录。会软链接到/usr/lib目录下。           |
| /usr/local/taos/examples  | TDengine各种语言应用示例目录。                               |
| /usr/local/taos/include   | TDengine对外提供的C语言接口的头文件。                        |
| /etc/taos/taos.cfg        | TDengine默认[配置文件]                                       |
| /var/lib/taos             | TDengine默认数据文件目录。可通过[配置文件]修改位置。         |
| /var/log/taos             | TDengine默认日志文件目录。可通过[配置文件]修改位置。         |

**可执行文件**

TDengine的所有可执行文件默认存放在 _/usr/local/taos/bin_ 目录下。其中包括：

- *taosd*：TDengine服务端可执行文件
- *taos*：TDengine Shell可执行文件
- *taosdump*：数据导入导出工具
- *taosdemo*：TDengine测试工具
- remove.sh：卸载TDengine的脚本，请谨慎执行，链接到/usr/bin目录下的**rmtaos**命令。会删除TDengine的安装目录/usr/local/taos，但会保留/etc/taos、/var/lib/taos、/var/log/taos。

您可以通过修改系统配置文件taos.cfg来配置不同的数据目录和日志目录。

## TDengine 的启动、停止、卸载

TDengine 使用 Linux 系统的 systemd/systemctl/service 来管理系统的启动和、停止、重启操作。TDengine 的服务进程是 taosd，默认情况下 TDengine 在系统启动后将自动启动。DBA 可以通过 systemd/systemctl/service 手动操作停止、启动、重新启动服务。

以 systemctl 为例，命令如下：

-    启动服务进程：`systemctl start taosd` 

-    停止服务进程：`systemctl stop taosd`

-    重启服务进程：`systemctl restart taosd`

-    查看服务状态：`systemctl status taosd`

如果服务进程处于活动状态，则 status 指令会显示如下的相关信息：
```
......

Active: active (running) 

......
```

如果后台服务进程处于停止状态，则 status 指令会显示如下的相关信息：
```
......

Active: inactive (dead)

......
```

卸载 TDengine，只需要执行如下命令：
```
rmtaos
```

**警告：执行该命令后，TDengine 程序将被完全删除，务必谨慎使用。**

## <a class="anchor" id="keywords"></a>TDengine参数限制与保留关键字

**名称命名规则**

1. 合法字符：英文字符、数字和下划线
2. 允许英文字符或下划线开头，不允许以数字开头
3. 不区分大小写

**密码合法字符集**

`[a-zA-Z0-9!?$%^&*()_–+={[}]:;@~#|<,>.?/]`

去掉了 ```‘“`\```  (单双引号、撇号、反斜杠、空格)

- 数据库名：不能包含“.”以及特殊字符，不能超过 32 个字符
- 表名：不能包含“.”以及特殊字符，与所属数据库名一起，不能超过 192 个字符，每行数据最大长度 16k 个字符
- 表的列名：不能包含特殊字符，不能超过 64 个字符
- 数据库名、表名、列名，都不能以数字开头，合法的可用字符集是“英文字符、数字和下划线”
- 表的列数：不能超过 1024 列，最少需要 2 列，第一列必须是时间戳（从 2.1.7.0 版本开始，改为最多支持 4096 列）
- 记录的最大长度：包括时间戳 8 byte，不能超过 16KB（每个 BINARY/NCHAR 类型的列还会额外占用 2 个 byte 的存储位置）
- 单条 SQL 语句默认最大字符串长度：1048576 byte，但可通过系统配置参数 maxSQLLength 修改，取值范围 65480 ~ 1048576 byte
- 数据库副本数：不能超过 3
- 用户名：不能超过 23 个 byte
- 用户密码：不能超过 15 个 byte
- 标签(Tags)数量：不能超过 128 个，可以 0 个
- 标签的总长度：不能超过 16K byte
- 记录条数：仅受存储空间限制
- 表的个数：仅受节点个数限制
- 库的个数：仅受节点个数限制
- 单个库上虚拟节点个数：不能超过 64 个
- 库的数目，超级表的数目、表的数目，系统不做限制，仅受系统资源限制
- SELECT 语句的查询结果，最多允许返回 1024 列（语句中的函数调用可能也会占用一些列空间），超限时需要显式指定较少的返回数据列，以避免语句执行报错。（从 2.1.7.0 版本开始，改为最多允许 4096 列）

目前 TDengine 有将近 200 个内部保留关键字，这些关键字无论大小写均不可以用作库名、表名、STable 名、数据列名及标签列名等。这些关键字列表如下：

|  关键字列表  |              |              |              |              |
| ------------ | ------------ | ------------ | ------------ | ------------ |
| ABORT        | CREATE       | IGNORE       | NULL         | STAR         |
| ACCOUNT      | CTIME        | IMMEDIATE    | OF           | STATE        |
| ACCOUNTS     | DATABASE     | IMPORT       | OFFSET       | STATEMENT    |
| ADD          | DATABASES    | IN           | OR           | STATE_WINDOW |
| AFTER        | DAYS         | INITIALLY    | ORDER        | STORAGE      |
| ALL          | DBS          | INSERT       | PARTITIONS   | STREAM       |
| ALTER        | DEFERRED     | INSTEAD      | PASS         | STREAMS      |
| AND          | DELIMITERS   | INT          | PLUS         | STRING       |
| AS           | DESC         | INTEGER      | PPS          | SYNCDB       |
| ASC          | DESCRIBE     | INTERVAL     | PRECISION    | TABLE        |
| ATTACH       | DETACH       | INTO         | PREV         | TABLES       |
| BEFORE       | DISTINCT     | IS           | PRIVILEGE    | TAG          |
| BEGIN        | DIVIDE       | ISNULL       | QTIME        | TAGS         |
| BETWEEN      | DNODE        | JOIN         | QUERIES      | TBNAME       |
| BIGINT       | DNODES       | KEEP         | QUERY        | TIMES        |
| BINARY       | DOT          | KEY          | QUORUM       | TIMESTAMP    |
| BITAND       | DOUBLE       | KILL         | RAISE        | TINYINT      |
| BITNOT       | DROP         | LE           | REM          | TOPIC        |
| BITOR        | EACH         | LIKE         | REPLACE      | TOPICS       |
| BLOCKS       | END          | LIMIT        | REPLICA      | TRIGGER      |
| BOOL         | EQ           | LINEAR       | RESET        | TSERIES      |
| BY           | EXISTS       | LOCAL        | RESTRICT     | UMINUS       |
| CACHE        | EXPLAIN      | LP           | ROW          | UNION        |
| CACHELAST    | FAIL         | LSHIFT       | RP           | UNSIGNED     |
| CASCADE      | FILE         | LT           | RSHIFT       | UPDATE       |
| CHANGE       | FILL         | MATCH        | SCORES       | UPLUS        |
| CLUSTER      | FLOAT        | MAXROWS      | SELECT       | USE          |
| COLON        | FOR          | MINROWS      | SEMI         | USER         |
| COLUMN       | FROM         | MINUS        | SESSION      | USERS        |
| COMMA        | FSYNC        | MNODES       | SET          | USING        |
| COMP         | GE           | MODIFY       | SHOW         | VALUES       |
| COMPACT      | GLOB         | MODULES      | SLASH        | VARIABLE     |
| CONCAT       | GRANTS       | NCHAR        | SLIDING      | VARIABLES    |
| CONFLICT     | GROUP        | NE           | SLIMIT       | VGROUPS      |
| CONNECTION   | GT           | NONE         | SMALLINT     | VIEW         |
| CONNECTIONS  | HAVING       | NOT          | SOFFSET      | VNODES       |
| CONNS        | ID           | NOTNULL      | STABLE       | WAL          |
| COPY         | IF           | NOW          | STABLES      | WHERE        |

## 诊断及其他

#### 网络连接诊断

当出现客户端应用无法访问服务端时，需要确认客户端与服务端之间网络的各端口连通情况，以便有针对性地排除故障。

目前网络连接诊断支持在：Linux 与 Linux，Linux 与 Windows 之间进行诊断测试。

诊断步骤：

1. 如拟诊断的端口范围与服务器 taosd 实例的端口范围相同，须先停掉 taosd 实例
2. 服务端命令行输入：`taos -n server -P <port>`  以服务端身份启动对端口 port 为基准端口的监听
3. 客户端命令行输入：`taos -n client -h <fqdn of server> -P <port>`  以客户端身份启动对指定的服务器、指定的端口发送测试包

服务端运行正常的话会输出以下信息：

```bash
# taos -n server -P 6000
12/21 14:50:13.522509 0x7f536f455200 UTL work as server, host:172.27.0.7 startPort:6000 endPort:6011 pkgLen:1000

12/21 14:50:13.522659 0x7f5352242700 UTL TCP server at port:6000 is listening
12/21 14:50:13.522727 0x7f5351240700 UTL TCP server at port:6001 is listening
...
...
...
12/21 14:50:13.523954 0x7f5342fed700 UTL TCP server at port:6011 is listening
12/21 14:50:13.523989 0x7f53437ee700 UTL UDP server at port:6010 is listening
12/21 14:50:13.524019 0x7f53427ec700 UTL UDP server at port:6011 is listening
12/21 14:50:22.192849 0x7f5352242700 UTL TCP: read:1000 bytes from 172.27.0.8 at 6000
12/21 14:50:22.192993 0x7f5352242700 UTL TCP: write:1000 bytes to 172.27.0.8 at 6000
12/21 14:50:22.237082 0x7f5351a41700 UTL UDP: recv:1000 bytes from 172.27.0.8 at 6000
12/21 14:50:22.237203 0x7f5351a41700 UTL UDP: send:1000 bytes to 172.27.0.8 at 6000
12/21 14:50:22.237450 0x7f5351240700 UTL TCP: read:1000 bytes from 172.27.0.8 at 6001
12/21 14:50:22.237576 0x7f5351240700 UTL TCP: write:1000 bytes to 172.27.0.8 at 6001
12/21 14:50:22.281038 0x7f5350a3f700 UTL UDP: recv:1000 bytes from 172.27.0.8 at 6001
12/21 14:50:22.281141 0x7f5350a3f700 UTL UDP: send:1000 bytes to 172.27.0.8 at 6001
...
...
...
12/21 14:50:22.677443 0x7f5342fed700 UTL TCP: read:1000 bytes from 172.27.0.8 at 6011
12/21 14:50:22.677576 0x7f5342fed700 UTL TCP: write:1000 bytes to 172.27.0.8 at 6011
12/21 14:50:22.721144 0x7f53427ec700 UTL UDP: recv:1000 bytes from 172.27.0.8 at 6011
12/21 14:50:22.721261 0x7f53427ec700 UTL UDP: send:1000 bytes to 172.27.0.8 at 6011
```

客户端运行正常会输出以下信息：

```bash
# taos -n client -h 172.27.0.7 -P 6000
12/21 14:50:22.192434 0x7fc95d859200 UTL work as client, host:172.27.0.7 startPort:6000 endPort:6011 pkgLen:1000

12/21 14:50:22.192472 0x7fc95d859200 UTL server ip:172.27.0.7 is resolved from host:172.27.0.7
12/21 14:50:22.236869 0x7fc95d859200 UTL successed to test TCP port:6000
12/21 14:50:22.237215 0x7fc95d859200 UTL successed to test UDP port:6000
...
...
...
12/21 14:50:22.676891 0x7fc95d859200 UTL successed to test TCP port:6010
12/21 14:50:22.677240 0x7fc95d859200 UTL successed to test UDP port:6010
12/21 14:50:22.720893 0x7fc95d859200 UTL successed to test TCP port:6011
12/21 14:50:22.721274 0x7fc95d859200 UTL successed to test UDP port:6011
```

仔细阅读打印出来的错误信息，可以帮助管理员找到原因，以解决问题。

#### 启动状态及RPC诊断

`taos -n startup -h <fqdn of server>`

判断 taosd 服务端是否成功启动，是数据库管理员经常遇到的一种情形。特别当若干台服务器组成集群时，判断每个服务端实例是否成功启动就会是一个重要问题。除检索 taosd 服务端日志文件进行问题定位、分析外，还可以通过 `taos -n startup -h <fqdn of server>` 来诊断一个 taosd 进程的启动状态。

针对多台服务器组成的集群，当服务启动过程耗时较长时，可通过该命令行来诊断每台服务器的 taosd 实例的启动状态，以准确定位问题。

`taos -n rpc -h <fqdn of server>` 

该命令用来诊断已经启动的 taosd 实例的端口是否可正常访问。如果 taosd 程序异常或者失去响应，可以通过 `taos -n rpc -h <fqdn of server>` 来发起一个与指定 fqdn 的 rpc 通信，看看 taosd 是否能收到，以此来判定是网络问题还是 taosd 程序异常问题。

#### sync 及 arbitrator 诊断

```
taos -n sync -P 6040 -h <fqdn of server>
taos -n sync -P 6042 -h <fqdn of server>
```

用来诊断 sync 端口是否工作正常，判断服务端 sync 模块是否成功工作。另外，-P 6042 用来诊断 arbitrator 是否配置正常，判断指定服务器的 arbitrator 是否能正常工作。

#### 网络速度诊断

`taos -n speed -h <fqdn of server> -P 6030 -N 10 -l 10000000 -S TCP`

从 2.2.0.0 版本开始，taos 工具新提供了一个网络速度诊断的模式，可以对一个正在运行中的 taosd 实例或者 `taos -n server` 方式模拟的一个服务端实例，以非压缩传输的方式进行网络测速。这个模式下可供调整的参数如下：

-n：设为“speed”时，表示对网络速度进行诊断。
-h：所要连接的服务端的 FQDN 或 ip 地址。如果不设置这一项，会使用本机 taos.cfg 文件中 FQDN 参数的设置作为默认值。
-P：所连接服务端的网络端口。默认值为 6030。
-N：诊断过程中使用的网络包总数。最小值是 1、最大值是 10000，默认值为 100。
-l：单个网络包的大小（单位：字节）。最小值是 1024、最大值是 1024 * 1024 * 1024，默认值为 1000。
-S：网络封包的类型。可以是 TCP 或 UDP，默认值为 TCP。

#### FQDN 解析速度诊断

`taos -n fqdn -h <fqdn of server>`

从 2.2.0.0 版本开始，taos 工具新提供了一个 FQDN 解析速度的诊断模式，可以对一个目标 FQDN 地址尝试解析，并记录解析过程中所消耗的时间。这个模式下可供调整的参数如下：

-n：设为“fqdn”时，表示对 FQDN 解析进行诊断。
-h：所要解析的目标 FQDN 地址。如果不设置这一项，会使用本机 taos.cfg 文件中 FQDN 参数的设置作为默认值。

#### 服务端日志

taosd 服务端日志文件标志位 debugflag 默认为 131，在 debug 时往往需要将其提升到 135 或 143 。

一旦设定为 135 或 143，日志文件增长很快，特别是写入、查询请求量较大时，增长速度惊人。如合并保存日志，很容易把日志内的关键信息（如配置信息、错误信息等）冲掉。为此，服务端将重要信息日志与其他日志分开存放：

- taosinfo    存放重要信息日志
- taosdlog    存放其他日志

其中，taosinfo 日志文件最大长度由 numOfLogLines 来进行配置，一个 taosd 实例最多保留两个文件。

taosd 服务端日志采用异步落盘写入机制，优点是可以避免硬盘写入压力太大，对性能造成很大影响。缺点是，在极端情况下，存在少量日志行数丢失的可能。

