/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 471
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SNode* yy140;
  EFillMode yy174;
  int32_t yy214;
  SNodeList* yy220;
  int64_t yy303;
  bool yy587;
  SDataType yy682;
  ENullOrder yy697;
  EOperatorType yy794;
  SAlterOption yy809;
  EJoinType yy852;
  int8_t yy857;
  EOrder yy866;
  SToken yy881;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             750
#define YYNRULE              571
#define YYNTOKEN             328
#define YY_MAX_SHIFT         749
#define YY_MIN_SHIFTREDUCE   1116
#define YY_MAX_SHIFTREDUCE   1686
#define YY_ERROR_ACTION      1687
#define YY_ACCEPT_ACTION     1688
#define YY_NO_ACTION         1689
#define YY_MIN_REDUCE        1690
#define YY_MAX_REDUCE        2260
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2669)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1971, 1842,  387, 2072,  429,  604,  627, 2058,  141, 2231,
 /*    10 */   161, 2131,   45,   43, 1614, 1969,  628,  363, 2054, 1855,
 /*    20 */   384, 2058, 1463,  616,  603,  182, 1903, 2058,  496, 2232,
 /*    30 */   605, 2026, 2054, 1544,  492, 1461, 2090,  640, 2054,   44,
 /*    40 */    42,   41,   40,   39,  619, 1168,  332, 1167,  640, 2040,
 /*    50 */  1488,  657, 2050, 2056,  365,  506,  139, 1964, 1539, 1905,
 /*    60 */   222, 2236, 1905,  651,   18, 2231, 2050, 2056,  366,  349,
 /*    70 */  1688, 1469, 2050, 2056,  379, 1904, 1169,  651, 1903,  404,
 /*    80 */  2071, 2235,  176,  651, 2107, 2232, 2234,  109, 2073,  661,
 /*    90 */  2075, 2076,  656, 1149,  651,  166, 1950,  746,   65,  179,
 /*   100 */    14, 2160, 1798,  351, 1954,  378, 2156,  190,   38,   37,
 /*   110 */    45,   43,   44,   42,   41,   40,   39,   48,  384,  184,
 /*   120 */  1463,  269, 2168,  615,  176,  133,  614, 2186,   48, 2231,
 /*   130 */    61, 1544, 1151, 1461, 1154, 1155, 1546, 1547,  397,  604,
 /*   140 */   622,   31,  396, 2231,  603,  182, 1955,   38,   37, 2232,
 /*   150 */   605,   44,   42,   41,   40,   39, 1539,  389,  603,  182,
 /*   160 */  1898, 1900,   18, 2232,  605, 1489, 1519, 1529, 1713, 1469,
 /*   170 */  1756,  122, 1545, 1548,  121,  120,  119,  118,  117,  116,
 /*   180 */   115,  114,  113,  579, 1971,  579, 1464, 2231, 1462, 2231,
 /*   190 */   490,  105,  491, 1726,   61,  746,  375,  164,   14, 1968,
 /*   200 */   628,  102, 2237,  182, 2237,  182, 1856, 2232,  605, 2232,
 /*   210 */   605, 1488, 1467, 1468, 2040, 1518, 1521, 1522, 1523, 1524,
 /*   220 */  1525, 1526, 1527, 1528,  653,  649, 1537, 1538, 1540, 1541,
 /*   230 */  1542, 1543,    2, 1488, 1546, 1547,  723,  722,  721,  720,
 /*   240 */   394,   73,  719,  718,  143,  713,  712,  711,  710,  709,
 /*   250 */   708,  707,  156,  703,  702,  701,  393,  392,  698,  697,
 /*   260 */   696,  695,  694, 2236, 1519, 1529, 1712, 2231,   38,   37,
 /*   270 */  1545, 1548,   44,   42,   41,   40,   39,  185, 1683,  185,
 /*   280 */  1491, 1327, 1328, 2235, 1464, 1618, 1462, 2232, 2233,  467,
 /*   290 */    81, 1488,  594,   38,   37,  627,  627,   44,   42,   41,
 /*   300 */    40,   39,  691,  154,  153,  688,  687,  686,  151, 2175,
 /*   310 */  1467, 1468, 2040, 1518, 1521, 1522, 1523, 1524, 1525, 1526,
 /*   320 */  1527, 1528,  653,  649, 1537, 1538, 1540, 1541, 1542, 1543,
 /*   330 */     2,   11,   45,   43, 1759, 2172,  499, 1844,  491, 1726,
 /*   340 */   384, 1293, 1463,  185,  625,  636, 1964, 1964, 2054,  344,
 /*   350 */   198,  197,  167, 1544, 1702, 1461, 1284,  683,  682,  681,
 /*   360 */  1288,  680, 1290, 1291,  679,  676, 2175, 1299,  673, 1301,
 /*   370 */  1302,  670,  667,  466, 1682,  600,  595,  588, 1539, 1382,
 /*   380 */  1383, 2072, 2050, 2056,   18,  489,  508,   86,  494, 1732,
 /*   390 */  2033, 1469, 2171,  651, 1573, 1642,  640,  545,  544,  543,
 /*   400 */   545,  544,  543,  353,  535,  136,  539,  535,  136,  539,
 /*   410 */   538,  416, 1848,  538, 2090,  537,  542,  746,  537,  542,
 /*   420 */    14,  536,  658, 1490,  536,  106,  626, 2040,  249,  657,
 /*   430 */    45,   43, 1549,  418,  414,  579, 1711, 1520,  384, 2231,
 /*   440 */  1463,  140,  591,  590, 1640, 1641, 1643, 1644, 1645, 1845,
 /*   450 */  1574, 1544,   61, 1461, 2237,  182, 1546, 1547, 2071, 2232,
 /*   460 */   605,  100, 2107, 2090,  599,  109, 2073,  661, 2075, 2076,
 /*   470 */   656,  598,  651, 1691, 1905,  142, 1539,  149, 2131, 2160,
 /*   480 */   641,  362, 2040,  378, 2156, 1846, 1519, 1529,  693, 1469,
 /*   490 */  1903, 2175, 1545, 1548,  122, 1487,  187,  121,  120,  119,
 /*   500 */   118,  117,  116,  115,  114,  113, 1464,  498, 1462,   49,
 /*   510 */   494, 1732,  568, 1853, 1935,  746,  597, 2170,   46,   11,
 /*   520 */  1237,   34,  382, 1568, 1569, 1570, 1571, 1572, 1576, 1577,
 /*   530 */  1578, 1579, 1467, 1468, 1690, 1518, 1521, 1522, 1523, 1524,
 /*   540 */  1525, 1526, 1527, 1528,  653,  649, 1537, 1538, 1540, 1541,
 /*   550 */  1542, 1543,    2,  423, 1546, 1547, 1239,  422,  131,  130,
 /*   560 */   129,  128,  127,  126,  125,  124,  123,  641,  178,   38,
 /*   570 */    37,  271, 1554,   44,   42,   41,   40,   39, 1488, 2072,
 /*   580 */  1168, 1892, 1167,   54, 1519, 1529,  616, 1469,   38,   37,
 /*   590 */  1545, 1548,   44,   42,   41,   40,   39,  376,  579,  387,
 /*   600 */  1853,  185, 2231, 1491, 1464,  164, 1462,  164,   41,   40,
 /*   610 */    39, 1169, 2090,  559, 1855,  684, 1855, 2237,  182,  139,
 /*   620 */   619, 1491, 2232,  605,   27, 2040,  557,  657,  555, 1838,
 /*   630 */  1467, 1468, 1830, 1518, 1521, 1522, 1523, 1524, 1525, 1526,
 /*   640 */  1527, 1528,  653,  649, 1537, 1538, 1540, 1541, 1542, 1543,
 /*   650 */     2,   45,   43, 2034,   35,  290, 2071,  272,  185,  384,
 /*   660 */  2107, 1463, 1653,  109, 2073,  661, 2075, 2076,  656,  447,
 /*   670 */   651,  641, 1544, 1710, 1461,  179,  533, 2160,  446, 1248,
 /*   680 */   532,  378, 2156,  618,  180, 2168, 2169,  427,  137, 2173,
 /*   690 */   238,  550, 1247,  641,  237,  705, 2072, 1539,  579,   61,
 /*   700 */  1709,   92, 2231, 2187, 1853,  641,  560,   38,   37,  132,
 /*   710 */  1469,   44,   42,   41,   40,   39,  529, 2237,  182, 2040,
 /*   720 */   236,  132, 2232,  605, 1520, 1905, 1853,  641,  534, 2090,
 /*   730 */   541,  540,  372, 1899, 1900,  553,  746,  658, 1853,   46,
 /*   740 */   547, 1903, 2040,  241,  657,  235, 2040,  194, 1708,   45,
 /*   750 */    43,  191,   89,  339,  476, 1840,  361,  384,  561, 1463,
 /*   760 */  1853,  691,  154,  153,  688,  687,  686,  151, 2059,  248,
 /*   770 */  1544,  566, 1461, 2071, 1489, 1546, 1547, 2107,    8, 2054,
 /*   780 */   168, 2073,  661, 2075, 2076,  656,   69,  651,   83,   68,
 /*   790 */    33,   82,   13,   12, 2040, 1539,   38,   37, 2072,  641,
 /*   800 */    44,   42,   41,   40,   39, 1519, 1529, 1707, 1469, 1829,
 /*   810 */  1836, 1545, 1548, 2050, 2056,  428,  579,  641,  281,  282,
 /*   820 */  2231,  580, 2197,  280,  651, 1464, 2236, 1462, 1154, 1155,
 /*   830 */   390, 2090, 1853,  437,  746, 2237,  182,   14,  164,  658,
 /*   840 */  2232,  605,  685, 1490, 2040, 1896,  657, 1855,  185, 1611,
 /*   850 */  1853, 1467, 1468, 2040, 1518, 1521, 1522, 1523, 1524, 1525,
 /*   860 */  1526, 1527, 1528,  653,  649, 1537, 1538, 1540, 1541, 1542,
 /*   870 */  1543,    2,  693, 1546, 1547, 2071, 1706,  717,  715, 2107,
 /*   880 */   239,  641,  109, 2073,  661, 2075, 2076,  656,  165,  651,
 /*   890 */  1399, 1400, 1587,  310, 2135,  616, 2160,  452, 1733, 1905,
 /*   900 */   378, 2156, 1705, 1519, 1529, 1704,  377,  308,   72, 1545,
 /*   910 */  1548,   71,   38,   37, 1853, 1903,   44,   42,   41,   40,
 /*   920 */    39,  574, 2040, 1464, 1676, 1462, 1398, 1401,  139,  205,
 /*   930 */   486,  484,  481, 1575,   38,   37, 1701, 2235,   44,   42,
 /*   940 */    41,   40,   39, 1700, 2072, 1437, 1438,  741, 2040, 1467,
 /*   950 */  1468, 2040, 1518, 1521, 1522, 1523, 1524, 1525, 1526, 1527,
 /*   960 */  1528,  653,  649, 1537, 1538, 1540, 1541, 1542, 1543,    2,
 /*   970 */    61,  335, 1905, 1486, 2072, 2180, 1607, 2090, 1699,  388,
 /*   980 */   460, 1857, 2040,  474,  641,  658,  473, 1607, 1903, 2040,
 /*   990 */  2040,  271,  657,  181, 2168, 2169, 1252,  137, 2173, 1698,
 /*  1000 */   453,  443,  244,  475,   32, 1630,  445, 2090,  108, 1251,
 /*  1010 */   641,  641,  373, 1799, 1580,  658, 1828, 1853, 1685, 1686,
 /*  1020 */  2040, 2071,  657,  641, 2040, 2107,  507, 1850,  109, 2073,
 /*  1030 */   661, 2075, 2076,  656,   11,  651,    9, 1697, 1696,  575,
 /*  1040 */  2251,   61, 2160, 1853, 1853, 2040,  378, 2156,   80,   79,
 /*  1050 */   426, 2071,  352,  189,  641, 2107, 1853, 2194,  327, 2073,
 /*  1060 */   661, 2075, 2076,  656,  433,  651,  643, 1695, 2132, 1463,
 /*  1070 */   620,  478,  333,  611,  645,  412, 2132,  410,  406,  402,
 /*  1080 */   399,  419, 1461, 2040, 2040, 1488, 1694, 1853, 1693, 2072,
 /*  1090 */   652,  578,   86,  471,  163, 1610,  465,  464,  463,  462,
 /*  1100 */   459,  458,  457,  456,  455,  451,  450,  449,  448,  334,
 /*  1110 */   440,  439,  438, 2040,  435,  434,  350, 1849, 1469,  185,
 /*  1120 */   641,  608, 2090,  641,  641,  641,  421,  706,  420, 1815,
 /*  1130 */   658, 1950, 2040, 2200, 2040, 2040,  624,  657, 2072,  285,
 /*  1140 */   638,  639,  192, 1950,  746,  691,  154,  153,  688,  687,
 /*  1150 */   686,  151,  419, 1853,  196, 2008, 1853, 1853, 1853,  304,
 /*  1160 */   152,  689, 1882,   52, 1896,  641, 2071,  641, 1831,  430,
 /*  1170 */  2107, 2090, 1746,  109, 2073,  661, 2075, 2076,  656,  658,
 /*  1180 */   651,  291,  431,  391, 2040, 2251,  657, 2160,   13,   12,
 /*  1190 */   185,  378, 2156,  690,  546,  152, 1896, 2072, 1853,  152,
 /*  1200 */  1853,  240, 2207,  607,   51,  145,    3,  134,  228, 1472,
 /*  1210 */   230,  226,  147,  229,  247, 2071, 1471,   53,  232, 2107,
 /*  1220 */  2072,  231,  109, 2073,  661, 2075, 2076,  656, 1739,  651,
 /*  1230 */  2090, 1520, 1737, 1464, 2251, 1462, 2160,   63,  658,  234,
 /*  1240 */   378, 2156,  233, 2040,  563,  657,  562,  648, 1703,  266,
 /*  1250 */   548,  586, 1432, 2090,  551,   63, 1435,  592,   90, 1467,
 /*  1260 */  1468,  658,  253,  152,   47,  221, 2040,  699,  657,  278,
 /*  1270 */    70,  150,  260,  152, 2071,   63, 2091,   47, 2107,   47,
 /*  1280 */   395,  109, 2073,  661, 2075, 2076,  656, 2061,  651, 1217,
 /*  1290 */   665, 1893,  150, 2251, 1639, 2160,  152, 2071, 2072,  378,
 /*  1300 */  2156, 2107,  612,  700,  109, 2073,  661, 2075, 2076,  656,
 /*  1310 */  2225,  651, 1638,  135,  381,  380, 2251,  616, 2160,  255,
 /*  1320 */   623, 1396,  378, 2156, 1477, 1215,  283,  633,  287, 1959,
 /*  1330 */  1278, 2090, 1581, 2179, 1530, 1544,  303, 1470, 1198,  658,
 /*  1340 */  2063, 1727, 2190,  223, 2040,  150,  657, 1305,  609, 1309,
 /*  1350 */   139,  617,  268, 1316,  265,    1,    4, 2072,  171,  398,
 /*  1360 */  1539,  403, 1475,  348,  525,  521,  517,  513,  220, 1474,
 /*  1370 */  1314,  298, 1419, 1469, 1199, 2071,  195,  432, 1960, 2107,
 /*  1380 */  2072,  356,  109, 2073,  661, 2075, 2076,  656, 1491,  651,
 /*  1390 */  2090,  436,  441, 1486, 2133, 1565, 2160,  454,  658,  647,
 /*  1400 */   378, 2156,  155, 2040,  469,  657, 1952,  461,  480,   87,
 /*  1410 */   468,  477,  218, 2090,  470,  183, 2168, 2169,  479,  137,
 /*  1420 */  2173,  658,  199,  200,  482,  483, 2040,  202,  657,  485,
 /*  1430 */   487, 1492,  488,  497, 2071, 1494,  500,  208, 2107, 1489,
 /*  1440 */   501,  109, 2073,  661, 2075, 2076,  656,  357,  651,  355,
 /*  1450 */   354, 1493,  531,  644,  210, 2160, 1495, 2071,  502,  378,
 /*  1460 */  2156, 2107, 2072,  503,  110, 2073,  661, 2075, 2076,  656,
 /*  1470 */   213,  651,  505,  533,  215,   84,  509,  532, 2160,  217,
 /*  1480 */   211,   85, 2159, 2156,  216,  219,  504, 1171, 1478, 2017,
 /*  1490 */  1473,  526,  527,  528, 2014, 2090, 2013,  530, 1843,  338,
 /*  1500 */   111,  565,  209,  658,  567,  225, 1839,  227, 2040,  157,
 /*  1510 */   657, 2072,  158,   88, 1481, 1483, 1841, 1837,  159,  242,
 /*  1520 */   148,  160,  569,  299,  570,  573, 2191,  649, 1537, 1538,
 /*  1530 */  1540, 1541, 1542, 1543, 2072,  245,  576,  593, 2206, 2071,
 /*  1540 */   631,  583,  589, 2107, 2090, 2201,  110, 2073,  661, 2075,
 /*  1550 */  2076,  656,  658,  651, 2205,  367,  596, 2040,    7,  657,
 /*  1560 */  2160,  251,  254,  602,  646, 2156,  259, 2090,  368,  581,
 /*  1570 */   267,  582,  172,  584,  261,  655,  262, 2182, 2254,  613,
 /*  1580 */  2040,  264,  657, 1607,  610,  138,  263, 1490,  659, 2176,
 /*  1590 */  2230,  371, 2107,  273,  621,  110, 2073,  661, 2075, 2076,
 /*  1600 */   656,   95,  651, 1496, 1965,   97, 2072,  300,  301, 2160,
 /*  1610 */   634, 2071,  635,  343, 2156, 2107,   99, 1854,  326, 2073,
 /*  1620 */   661, 2075, 2076,  656,  654,  651,  642, 2125,  302, 2072,
 /*  1630 */   629,   60, 2141,  630, 1979,  101, 1978, 1977,  374, 2090,
 /*  1640 */   663, 1897, 1816,  749,  742,  305,  743,  658,  745,  314,
 /*  1650 */  2032,  294, 2040,  329,  657,  328,  340,  297,  309,  341,
 /*  1660 */  2031, 2030, 2090, 2072,   50,  307, 2027,  318,   77,  400,
 /*  1670 */   658,  401,  175, 1454, 1455, 2040,  188,  657,  739,  735,
 /*  1680 */   731,  727,  295, 2071,  405, 2025,  407, 2107,  408, 2072,
 /*  1690 */   169, 2073,  661, 2075, 2076,  656, 2090,  651,  409, 2024,
 /*  1700 */   411, 2023,  413, 2022,  658,  415, 2071, 2021,  417, 2040,
 /*  1710 */  2107,  657,   78,  110, 2073,  661, 2075, 2076,  656, 1991,
 /*  1720 */   651, 1422, 2090,  107, 1421, 1990,  288, 2160, 1989,  424,
 /*  1730 */   658,  425, 2157, 1988, 1987, 2040, 1373,  657, 1943, 1942,
 /*  1740 */  2071, 1940,  606, 2252, 2107, 1939,  144,  168, 2073,  661,
 /*  1750 */  2075, 2076,  656, 2072,  651, 1938, 1941, 1937,  637,  193,
 /*  1760 */  1931,  442,  444, 1945, 1930, 1929, 2071, 1936, 1934, 1933,
 /*  1770 */  2107, 1932, 1928,  320, 2073,  661, 2075, 2076,  656, 1927,
 /*  1780 */   651, 1926, 1925, 1924, 1923, 2072, 2090, 1922, 1921, 2198,
 /*  1790 */  1920, 1919, 1918,  275,  658, 1917, 1916, 1915,  274, 2040,
 /*  1800 */   146,  657, 1914, 1913, 1944, 1912, 1911, 1375, 1910, 1909,
 /*  1810 */  2072, 1908, 1907,  472, 1426, 1906,  243,  601, 2090,  336,
 /*  1820 */  1249, 1253, 1762,  337,  201, 1761,  655, 1760, 1245, 1758,
 /*  1830 */  2071, 2040,  203,  657, 2107,  204, 1722,  169, 2073,  661,
 /*  1840 */  2075, 2076,  656, 2090,  651,  177, 1721, 2060,  383,  206,
 /*  1850 */  2004,  658,   75, 1157, 1156,   76, 2040,  493,  657, 2072,
 /*  1860 */   207,  495, 2071, 1998, 1986,  212, 2107,  214, 1985,  326,
 /*  1870 */  2073,  661, 2075, 2076,  656, 2072,  651, 1963, 2126, 1832,
 /*  1880 */  1757, 1755, 1191,  510,  512,  511, 1753, 2071,  514,  515,
 /*  1890 */  2253, 2107, 2090,  516,  327, 2073,  661, 2075, 2076,  656,
 /*  1900 */   658,  651, 1751,  519,  518, 2040,  520,  657, 2090, 1749,
 /*  1910 */   522,  524, 1736,  385,  523, 1735,  658, 1718, 1834, 1321,
 /*  1920 */  1833, 2040, 1320,  657, 2072, 1236,  224,   62, 1235, 1234,
 /*  1930 */  1233, 1232,  714,  716, 1229, 1227,  564, 1747, 1228, 1226,
 /*  1940 */  2107, 2072, 1740,  322, 2073,  661, 2075, 2076,  656,  358,
 /*  1950 */   651,  359, 2071, 1738,  360,  549, 2107, 2090, 2072,  327,
 /*  1960 */  2073,  661, 2075, 2076,  656,  658,  651, 1717,  552,  554,
 /*  1970 */  2040, 1716,  657,  556, 2090, 1715,  558,  112, 1442, 1444,
 /*  1980 */  1441, 2003,  658, 1446, 1428,   26, 1997, 2040,  571,  657,
 /*  1990 */  1984, 2090,   55,  246, 1982, 2236,  577,   66,  572,  658,
 /*  2000 */    19, 2071,  364,   16, 2040, 2107,  657, 2072,  311, 2073,
 /*  2010 */   661, 2075, 2076,  656,   58,  651,   28,  162, 2071,    5,
 /*  2020 */  1655,  250, 2107, 2072,  585,  312, 2073,  661, 2075, 2076,
 /*  2030 */   656,    6,  651,   59,  587, 2071,   64,  252,  258, 2107,
 /*  2040 */  2090, 2072,  313, 2073,  661, 2075, 2076,  656,  658,  651,
 /*  2050 */   257, 1637,  170, 2040, 2061,  657, 2090,   30,  256,   29,
 /*  2060 */    21, 1629,   91, 1670,  658, 1675, 1676, 1669,  270, 2040,
 /*  2070 */   369,  657, 1674, 1673, 2090,  370,  173, 1604, 1603, 1983,
 /*  2080 */    57, 1981,  658,   93, 2071,   56,   20, 2040, 2107,  657,
 /*  2090 */  2072,  319, 2073,  661, 2075, 2076,  656,   17,  651, 1980,
 /*  2100 */  2071, 1962,   94,  276, 2107,   22, 2072,  323, 2073,  661,
 /*  2110 */  2075, 2076,  656, 1961,  651,  277, 1635,  279, 2071,  284,
 /*  2120 */    67,   96, 2107, 2090,  286,  315, 2073,  661, 2075, 2076,
 /*  2130 */   656,  658,  651,  102,   98,  289, 2040,   23,  657, 2090,
 /*  2140 */   632, 1556,   10, 1555,   12, 1479, 2110,  658, 1534,  650,
 /*  2150 */   174, 1532, 2040, 1566,  657,   36,  186, 1511, 1531,   15,
 /*  2160 */    24,  660, 1503, 2072,   25,  662, 1306, 2071,  664,  386,
 /*  2170 */   666, 2107, 1303,  668,  324, 2073,  661, 2075, 2076,  656,
 /*  2180 */  2072,  651,  671, 2071,  669,  674, 1300, 2107, 1294,  672,
 /*  2190 */   316, 2073,  661, 2075, 2076,  656, 2090,  651,  675,  677,
 /*  2200 */  1298, 1292,  678,  292,  658, 1315,  103,  104, 1297, 2040,
 /*  2210 */    74,  657, 1296, 2090, 1295, 1311, 1189,  692, 1223, 1222,
 /*  2220 */  1221,  658, 1220, 1219, 1218, 1216, 2040, 1214,  657, 2072,
 /*  2230 */  1213, 1212, 1243,  704, 1210,  293, 1209, 1208, 1207, 1206,
 /*  2240 */  2071, 1205, 1204, 1240, 2107, 2072, 1238,  325, 2073,  661,
 /*  2250 */  2075, 2076,  656, 1201,  651, 1200, 1197, 2071, 1196, 1195,
 /*  2260 */  1194, 2107, 2090, 1754,  317, 2073,  661, 2075, 2076,  656,
 /*  2270 */   658,  651,  725,  724,  726, 2040, 1752,  657, 2090,  728,
 /*  2280 */   729,  730, 1750,  732,  733, 1748,  658,  736,  734,  737,
 /*  2290 */   738, 2040, 1734,  657, 2072,  740, 1146, 1714,  748,  296,
 /*  2300 */   744, 1689, 1465,  306,  747, 1689, 2071, 1689, 1689, 1689,
 /*  2310 */  2107, 1689, 1689,  330, 2073,  661, 2075, 2076,  656, 2072,
 /*  2320 */   651, 1689, 2071, 1689, 1689, 1689, 2107, 2090, 1689,  331,
 /*  2330 */  2073,  661, 2075, 2076,  656,  658,  651, 1689, 1689, 1689,
 /*  2340 */  2040, 1689,  657, 2072, 1689, 1689, 1689, 1689, 1689, 1689,
 /*  2350 */  1689, 1689, 2090, 1689, 1689, 1689, 1689, 1689, 1689, 1689,
 /*  2360 */   658, 1689, 1689, 1689, 1689, 2040, 1689,  657, 1689, 1689,
 /*  2370 */  1689, 2071, 1689, 1689, 1689, 2107, 2090, 1689, 2084, 2073,
 /*  2380 */   661, 2075, 2076,  656,  658,  651, 1689, 1689, 1689, 2040,
 /*  2390 */  1689,  657, 1689, 1689, 1689, 1689, 2071, 1689, 1689, 1689,
 /*  2400 */  2107, 1689, 1689, 2083, 2073,  661, 2075, 2076,  656, 1689,
 /*  2410 */   651, 1689, 1689, 1689, 2072, 1689, 1689, 1689, 1689, 1689,
 /*  2420 */  2071, 1689, 1689, 1689, 2107, 1689, 1689, 2082, 2073,  661,
 /*  2430 */  2075, 2076,  656, 1689,  651, 1689, 2072, 1689, 1689, 1689,
 /*  2440 */  1689, 1689, 1689, 1689, 1689, 1689, 1689, 2090, 1689, 1689,
 /*  2450 */  1689, 1689, 1689, 1689, 1689,  658, 1689, 1689, 1689, 1689,
 /*  2460 */  2040, 1689,  657, 2072, 1689, 1689, 1689, 1689, 1689, 2090,
 /*  2470 */  1689, 1689, 1689, 1689, 1689, 1689, 1689,  658, 1689, 1689,
 /*  2480 */  1689, 1689, 2040, 1689,  657, 1689, 1689, 1689, 1689, 1689,
 /*  2490 */  1689, 2071, 1689, 1689, 1689, 2107, 2090, 1689,  345, 2073,
 /*  2500 */   661, 2075, 2076,  656,  658,  651, 1689, 1689, 1689, 2040,
 /*  2510 */  1689,  657, 2072, 2071, 1689, 1689, 1689, 2107, 1689, 1689,
 /*  2520 */   346, 2073,  661, 2075, 2076,  656, 1689,  651, 2072, 1689,
 /*  2530 */  1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689,
 /*  2540 */  2071, 1689, 1689, 1689, 2107, 2090, 1689,  342, 2073,  661,
 /*  2550 */  2075, 2076,  656,  658,  651, 1689, 1689, 1689, 2040, 1689,
 /*  2560 */   657, 2090, 1689, 1689, 1689, 1689, 1689, 1689, 1689,  658,
 /*  2570 */  1689, 1689, 1689, 1689, 2040, 1689,  657, 2072, 1689, 1689,
 /*  2580 */  1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689, 2071,
 /*  2590 */  1689, 1689, 1689, 2107, 1689, 1689,  347, 2073,  661, 2075,
 /*  2600 */  2076,  656, 1689,  651, 1689,  659, 1689, 1689, 1689, 2107,
 /*  2610 */  2090, 1689,  322, 2073,  661, 2075, 2076,  656,  658,  651,
 /*  2620 */  1689, 1689, 1689, 2040, 1689,  657, 1689, 1689, 1689, 1689,
 /*  2630 */  1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689,
 /*  2640 */  1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689,
 /*  2650 */  1689, 1689, 1689, 1689, 2071, 1689, 1689, 1689, 2107, 1689,
 /*  2660 */  1689,  321, 2073,  661, 2075, 2076,  656, 1689,  651,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   379,  365,  356,  331,  339,  441,  339,  366,  425,  445,
 /*    10 */   364,  428,   12,   13,   14,  394,  395,  371,  377,  373,
 /*    20 */    20,  366,   22,  339,  460,  461,  380,  366,   14,  465,
 /*    30 */   466,    0,  377,   33,   20,   35,  364,   20,  377,   12,
 /*    40 */    13,   14,   15,   16,  372,   20,  381,   22,   20,  377,
 /*    50 */    20,  379,  411,  412,  413,  388,  372,  390,   58,  364,
 /*    60 */    35,  441,  364,  422,   64,  445,  411,  412,  413,  371,
 /*    70 */   328,   71,  411,  412,  413,  380,   51,  422,  380,   48,
 /*    80 */   408,  461,  364,  422,  412,  465,  466,  415,  416,  417,
 /*    90 */   418,  419,  420,    4,  422,  346,  372,   97,    4,  427,
 /*   100 */   100,  429,  353,  385,  386,  433,  434,  383,    8,    9,
 /*   110 */    12,   13,   12,   13,   14,   15,   16,  100,   20,  447,
 /*   120 */    22,  437,  438,  439,  364,  441,  442,  455,  100,  445,
 /*   130 */   100,   33,   43,   35,   45,   46,  136,  137,  396,  441,
 /*   140 */   396,    2,  400,  445,  460,  461,  386,    8,    9,  465,
 /*   150 */   466,   12,   13,   14,   15,   16,   58,  375,  460,  461,
 /*   160 */   378,  379,   64,  465,  466,   20,  166,  167,  331,   71,
 /*   170 */     0,   21,  172,  173,   24,   25,   26,   27,   28,   29,
 /*   180 */    30,   31,   32,  441,  379,  441,  186,  445,  188,  445,
 /*   190 */   335,  100,  337,  338,  100,   97,  391,  364,  100,  394,
 /*   200 */   395,  110,  460,  461,  460,  461,  373,  465,  466,  465,
 /*   210 */   466,   20,  212,  213,  377,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,   20,  136,  137,   66,   67,   68,   69,
 /*   240 */    70,  111,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   250 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   260 */    90,   91,   92,  441,  166,  167,  331,  445,    8,    9,
 /*   270 */   172,  173,   12,   13,   14,   15,   16,  249,  178,  249,
 /*   280 */    20,  136,  137,  461,  186,   14,  188,  465,  466,   80,
 /*   290 */   160,   20,  171,    8,    9,  339,  339,   12,   13,   14,
 /*   300 */    15,   16,  129,  130,  131,  132,  133,  134,  135,  414,
 /*   310 */   212,  213,  377,  215,  216,  217,  218,  219,  220,  221,
 /*   320 */   222,  223,  224,  225,  226,  227,  228,  229,  230,  231,
 /*   330 */   232,  233,   12,   13,    0,  440,  335,  366,  337,  338,
 /*   340 */    20,   97,   22,  249,  388,  388,  390,  390,  377,   64,
 /*   350 */   141,  142,  330,   33,  332,   35,  112,  113,  114,  115,
 /*   360 */   116,  117,  118,  119,  120,  121,  414,  123,  124,  125,
 /*   370 */   126,  127,  128,  164,  274,  254,  255,  256,   58,  166,
 /*   380 */   167,  331,  411,  412,   64,  336,   63,  345,  339,  340,
 /*   390 */   396,   71,  440,  422,  109,  212,   20,   66,   67,   68,
 /*   400 */    66,   67,   68,  361,   73,   74,   75,   73,   74,   75,
 /*   410 */    79,  181,  370,   79,  364,   84,   85,   97,   84,   85,
 /*   420 */   100,   90,  372,   20,   90,  343,   20,  377,  168,  379,
 /*   430 */    12,   13,   14,  203,  204,  441,  331,  166,   20,  445,
 /*   440 */    22,  359,  259,  260,  261,  262,  263,  264,  265,  367,
 /*   450 */   165,   33,  100,   35,  460,  461,  136,  137,  408,  465,
 /*   460 */   466,  343,  412,  364,   20,  415,  416,  417,  418,  419,
 /*   470 */   420,  372,  422,    0,  364,  425,   58,  427,  428,  429,
 /*   480 */   339,  371,  377,  433,  434,  367,  166,  167,   63,   71,
 /*   490 */   380,  414,  172,  173,   21,   20,  355,   24,   25,   26,
 /*   500 */    27,   28,   29,   30,   31,   32,  186,  336,  188,  100,
 /*   510 */   339,  340,  111,  372,    0,   97,  417,  440,  100,  233,
 /*   520 */    35,  236,  237,  238,  239,  240,  241,  242,  243,  244,
 /*   530 */   245,  246,  212,  213,    0,  215,  216,  217,  218,  219,
 /*   540 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   550 */   230,  231,  232,  396,  136,  137,   71,  400,   24,   25,
 /*   560 */    26,   27,   28,   29,   30,   31,   32,  339,  363,    8,
 /*   570 */     9,  168,   14,   12,   13,   14,   15,   16,   20,  331,
 /*   580 */    20,  376,   22,  355,  166,  167,  339,   71,    8,    9,
 /*   590 */   172,  173,   12,   13,   14,   15,   16,  356,  441,  356,
 /*   600 */   372,  249,  445,   20,  186,  364,  188,  364,   14,   15,
 /*   610 */    16,   51,  364,   21,  373,  111,  373,  460,  461,  372,
 /*   620 */   372,   20,  465,  466,   44,  377,   34,  379,   36,  365,
 /*   630 */   212,  213,    0,  215,  216,  217,  218,  219,  220,  221,
 /*   640 */   222,  223,  224,  225,  226,  227,  228,  229,  230,  231,
 /*   650 */   232,   12,   13,  396,  430,  431,  408,   58,  249,   20,
 /*   660 */   412,   22,  101,  415,  416,  417,  418,  419,  420,  155,
 /*   670 */   422,  339,   33,  331,   35,  427,  129,  429,  164,   22,
 /*   680 */   133,  433,  434,  436,  437,  438,  439,  355,  441,  442,
 /*   690 */   131,    4,   35,  339,  135,   71,  331,   58,  441,  100,
 /*   700 */   331,  102,  445,  455,  372,  339,   19,    8,    9,  355,
 /*   710 */    71,   12,   13,   14,   15,   16,  362,  460,  461,  377,
 /*   720 */    33,  355,  465,  466,  166,  364,  372,  339,  362,  364,
 /*   730 */   350,  351,  371,  378,  379,   48,   97,  372,  372,  100,
 /*   740 */    53,  380,  377,  355,  379,   58,  377,   58,  331,   12,
 /*   750 */    13,  168,  193,  194,   97,  365,  197,   20,  199,   22,
 /*   760 */   372,  129,  130,  131,  132,  133,  134,  135,  366,  168,
 /*   770 */    33,  396,   35,  408,   20,  136,  137,  412,   39,  377,
 /*   780 */   415,  416,  417,  418,  419,  420,   99,  422,   99,  102,
 /*   790 */     2,  102,    1,    2,  377,   58,    8,    9,  331,  339,
 /*   800 */    12,   13,   14,   15,   16,  166,  167,  331,   71,    0,
 /*   810 */   365,  172,  173,  411,  412,  355,  441,  339,  130,  131,
 /*   820 */   445,  456,  457,  135,  422,  186,    3,  188,   45,   46,
 /*   830 */   356,  364,  372,  355,   97,  460,  461,  100,  364,  372,
 /*   840 */   465,  466,  374,   20,  377,  377,  379,  373,  249,    4,
 /*   850 */   372,  212,  213,  377,  215,  216,  217,  218,  219,  220,
 /*   860 */   221,  222,  223,  224,  225,  226,  227,  228,  229,  230,
 /*   870 */   231,  232,   63,  136,  137,  408,  331,  350,  351,  412,
 /*   880 */   130,  339,  415,  416,  417,  418,  419,  420,   18,  422,
 /*   890 */   136,  137,  101,   23,  427,  339,  429,  355,    0,  364,
 /*   900 */   433,  434,  331,  166,  167,  331,  371,   37,   38,  172,
 /*   910 */   173,   41,    8,    9,  372,  380,   12,   13,   14,   15,
 /*   920 */    16,  401,  377,  186,  101,  188,  172,  173,  372,   59,
 /*   930 */    60,   61,   62,  165,    8,    9,  331,    3,   12,   13,
 /*   940 */    14,   15,   16,  331,  331,  195,  196,   49,  377,  212,
 /*   950 */   213,  377,  215,  216,  217,  218,  219,  220,  221,  222,
 /*   960 */   223,  224,  225,  226,  227,  228,  229,  230,  231,  232,
 /*   970 */   100,   18,  364,   20,  331,  247,  248,  364,  331,  371,
 /*   980 */    27,  365,  377,   30,  339,  372,   33,  248,  380,  377,
 /*   990 */   377,  168,  379,  437,  438,  439,   22,  441,  442,  331,
 /*  1000 */   355,   48,  365,   50,  236,  101,   53,  364,  138,   35,
 /*  1010 */   339,  339,  369,  353,  246,  372,    0,  372,  136,  137,
 /*  1020 */   377,  408,  379,  339,  377,  412,  355,  355,  415,  416,
 /*  1030 */   417,  418,  419,  420,  233,  422,  235,  331,  331,  355,
 /*  1040 */   427,  100,  429,  372,  372,  377,  433,  434,  178,  179,
 /*  1050 */   180,  408,   99,  183,  339,  412,  372,  444,  415,  416,
 /*  1060 */   417,  418,  419,  420,  111,  422,  426,  331,  428,   22,
 /*  1070 */   355,   97,  202,   44,  426,  205,  428,  207,  208,  209,
 /*  1080 */   210,  211,   35,  377,  377,   20,  331,  372,  331,  331,
 /*  1090 */   365,   96,  345,  140,  168,  250,  143,  144,  145,  146,
 /*  1100 */   147,  148,  149,  150,  151,  152,  153,  154,  155,  156,
 /*  1110 */   157,  158,  159,  377,  161,  162,  163,  370,   71,  249,
 /*  1120 */   339,   44,  364,  339,  339,  339,  185,  352,  187,  354,
 /*  1130 */   372,  372,  377,  387,  377,  377,  355,  379,  331,  355,
 /*  1140 */   355,  355,  383,  372,   97,  129,  130,  131,  132,  133,
 /*  1150 */   134,  135,  211,  372,  383,  360,  372,  372,  372,  357,
 /*  1160 */    44,  374,  360,  168,  377,  339,  408,  339,    0,   22,
 /*  1170 */   412,  364,    0,  415,  416,  417,  418,  419,  420,  372,
 /*  1180 */   422,  355,   35,  355,  377,  427,  379,  429,    1,    2,
 /*  1190 */   249,  433,  434,  374,   22,   44,  377,  331,  372,   44,
 /*  1200 */   372,  406,  444,  269,   42,   42,   44,   44,  104,   35,
 /*  1210 */   104,  107,   44,  107,   58,  408,   35,  101,  104,  412,
 /*  1220 */   331,  107,  415,  416,  417,  418,  419,  420,    0,  422,
 /*  1230 */   364,  166,    0,  186,  427,  188,  429,   44,  372,  104,
 /*  1240 */   433,  434,  107,  377,  198,  379,  200,   64,  332,  469,
 /*  1250 */    22,  444,  101,  364,   22,   44,  101,  458,  102,  212,
 /*  1260 */   213,  372,   44,   44,   44,  341,  377,   13,  379,   44,
 /*  1270 */    44,   44,  452,   44,  408,   44,  364,   44,  412,   44,
 /*  1280 */   341,  415,  416,  417,  418,  419,  420,   47,  422,   35,
 /*  1290 */    44,  376,   44,  427,  101,  429,   44,  408,  331,  433,
 /*  1300 */   434,  412,  273,   13,  415,  416,  417,  418,  419,  420,
 /*  1310 */   444,  422,  101,   44,   12,   13,  427,  339,  429,  101,
 /*  1320 */   101,  101,  433,  434,   22,   35,  101,  101,  101,  387,
 /*  1330 */   101,  364,  101,  444,  101,   33,  101,   35,   35,  372,
 /*  1340 */   100,  338,  387,   33,  377,   44,  379,  101,  271,  101,
 /*  1350 */   372,  443,  462,  101,  435,  446,  251,  331,   48,  410,
 /*  1360 */    58,   48,  188,  409,   54,   55,   56,   57,   58,  188,
 /*  1370 */   101,  398,  184,   71,   71,  408,   42,  384,  387,  412,
 /*  1380 */   331,   37,  415,  416,  417,  418,  419,  420,   20,  422,
 /*  1390 */   364,  384,  382,   20,  427,  212,  429,  339,  372,   97,
 /*  1400 */   433,  434,  101,  377,  165,  379,  339,  384,  349,   99,
 /*  1410 */   382,   95,  102,  364,  382,  437,  438,  439,   98,  441,
 /*  1420 */   442,  372,  348,  339,   94,  347,  377,  339,  379,  339,
 /*  1430 */   339,   20,  333,  333,  408,   20,  403,  345,  412,   20,
 /*  1440 */   379,  415,  416,  417,  418,  419,  420,  103,  422,  105,
 /*  1450 */   106,   20,  108,  427,  345,  429,   20,  408,  340,  433,
 /*  1460 */   434,  412,  331,  397,  415,  416,  417,  418,  419,  420,
 /*  1470 */   345,  422,  340,  129,  345,  345,  339,  133,  429,  169,
 /*  1480 */   170,  345,  433,  434,  174,  345,  176,   52,  186,  377,
 /*  1490 */   188,  342,  342,  333,  377,  364,  377,  364,  364,  333,
 /*  1500 */   339,  201,  192,  372,  407,  364,  364,  364,  377,  364,
 /*  1510 */   379,  331,  364,  100,  212,  213,  364,  364,  364,  343,
 /*  1520 */   405,  364,  191,  403,  402,  379,  387,  225,  226,  227,
 /*  1530 */   228,  229,  230,  231,  331,  343,  339,  258,  451,  408,
 /*  1540 */   257,  377,  377,  412,  364,  387,  415,  416,  417,  418,
 /*  1550 */   419,  420,  372,  422,  451,  377,  377,  377,  266,  379,
 /*  1560 */   429,  392,  392,  177,  433,  434,  453,  364,  275,  252,
 /*  1570 */   463,  267,  451,  268,  450,  372,  449,  454,  470,  272,
 /*  1580 */   377,  410,  379,  248,  270,  372,  448,   20,  408,  414,
 /*  1590 */   464,  340,  412,  343,  339,  415,  416,  417,  418,  419,
 /*  1600 */   420,  343,  422,   20,  390,  343,  331,  392,  392,  429,
 /*  1610 */   170,  408,  389,  433,  434,  412,  343,  372,  415,  416,
 /*  1620 */   417,  418,  419,  420,  421,  422,  423,  424,  360,  331,
 /*  1630 */   377,  100,  432,  377,  377,  100,  377,  377,  377,  364,
 /*  1640 */   368,  377,  354,   19,   36,  339,  334,  372,  333,  358,
 /*  1650 */     0,  343,  377,  404,  379,  358,  393,   33,  329,  393,
 /*  1660 */     0,    0,  364,  331,  399,  344,    0,  358,   42,   35,
 /*  1670 */   372,  206,   48,   35,   35,  377,   35,  379,   54,   55,
 /*  1680 */    56,   57,   58,  408,  206,    0,   35,  412,   35,  331,
 /*  1690 */   415,  416,  417,  418,  419,  420,  364,  422,  206,    0,
 /*  1700 */   206,    0,   35,    0,  372,   22,  408,    0,   35,  377,
 /*  1710 */   412,  379,  193,  415,  416,  417,  418,  419,  420,    0,
 /*  1720 */   422,  188,  364,   99,  186,    0,  102,  429,    0,  182,
 /*  1730 */   372,  181,  434,    0,    0,  377,   47,  379,    0,    0,
 /*  1740 */   408,    0,  467,  468,  412,    0,   42,  415,  416,  417,
 /*  1750 */   418,  419,  420,  331,  422,    0,    0,    0,  134,  155,
 /*  1760 */     0,   35,  155,    0,    0,    0,  408,    0,    0,    0,
 /*  1770 */   412,    0,    0,  415,  416,  417,  418,  419,  420,    0,
 /*  1780 */   422,    0,    0,    0,    0,  331,  364,    0,    0,  457,
 /*  1790 */     0,    0,    0,  169,  372,    0,    0,    0,  174,  377,
 /*  1800 */    42,  379,    0,    0,    0,    0,    0,   22,    0,    0,
 /*  1810 */   331,    0,    0,  139,  190,    0,  192,  459,  364,   96,
 /*  1820 */    22,   22,    0,   96,   58,    0,  372,    0,   35,    0,
 /*  1830 */   408,  377,   58,  379,  412,   58,    0,  415,  416,  417,
 /*  1840 */   418,  419,  420,  364,  422,   44,    0,   47,  369,   42,
 /*  1850 */     0,  372,   39,   14,   14,   39,  377,   47,  379,  331,
 /*  1860 */    40,   47,  408,    0,    0,   39,  412,  177,    0,  415,
 /*  1870 */   416,  417,  418,  419,  420,  331,  422,    0,  424,    0,
 /*  1880 */     0,    0,   65,   35,   39,   48,    0,  408,   35,   48,
 /*  1890 */   468,  412,  364,   39,  415,  416,  417,  418,  419,  420,
 /*  1900 */   372,  422,    0,   48,   35,  377,   39,  379,  364,    0,
 /*  1910 */    35,   39,    0,  369,   48,    0,  372,    0,    0,   35,
 /*  1920 */     0,  377,   22,  379,  331,   35,  107,  109,   35,   35,
 /*  1930 */    35,   35,   44,   44,   35,   22,  408,    0,   35,   35,
 /*  1940 */   412,  331,    0,  415,  416,  417,  418,  419,  420,   22,
 /*  1950 */   422,   22,  408,    0,   22,   50,  412,  364,  331,  415,
 /*  1960 */   416,  417,  418,  419,  420,  372,  422,    0,   35,   35,
 /*  1970 */   377,    0,  379,   35,  364,    0,   22,   20,   35,   35,
 /*  1980 */    35,    0,  372,  101,   35,  100,    0,  377,   22,  379,
 /*  1990 */     0,  364,  168,  170,    0,    3,  175,  100,  168,  372,
 /*  2000 */    44,  408,  168,  253,  377,  412,  379,  331,  415,  416,
 /*  2010 */   417,  418,  419,  420,   44,  422,  100,  189,  408,   96,
 /*  2020 */   101,  100,  412,  331,   98,  415,  416,  417,  418,  419,
 /*  2030 */   420,   96,  422,   44,   95,  408,    3,  101,   47,  412,
 /*  2040 */   364,  331,  415,  416,  417,  418,  419,  420,  372,  422,
 /*  2050 */    44,  101,  100,  377,   47,  379,  364,   44,  100,  100,
 /*  2060 */    44,  101,  100,   35,  372,  101,  101,   35,   47,  377,
 /*  2070 */    35,  379,   35,   35,  364,   35,   47,  101,  101,    0,
 /*  2080 */    44,    0,  372,  100,  408,  247,  253,  377,  412,  379,
 /*  2090 */   331,  415,  416,  417,  418,  419,  420,  253,  422,    0,
 /*  2100 */   408,    0,   39,   47,  412,  100,  331,  415,  416,  417,
 /*  2110 */   418,  419,  420,    0,  422,  101,  101,  100,  408,  100,
 /*  2120 */   100,   39,  412,  364,  169,  415,  416,  417,  418,  419,
 /*  2130 */   420,  372,  422,  110,  100,   47,  377,   44,  379,  364,
 /*  2140 */   171,   98,  234,   98,    2,   22,  100,  372,  101,  100,
 /*  2150 */    47,  101,  377,  212,  379,  100,   47,   22,  101,  100,
 /*  2160 */   100,  214,  101,  331,  100,  111,  101,  408,   35,   35,
 /*  2170 */   100,  412,  101,   35,  415,  416,  417,  418,  419,  420,
 /*  2180 */   331,  422,   35,  408,  100,   35,  101,  412,  101,  100,
 /*  2190 */   415,  416,  417,  418,  419,  420,  364,  422,  100,   35,
 /*  2200 */   122,  101,  100,   44,  372,   35,  100,  100,  122,  377,
 /*  2210 */   100,  379,  122,  364,  122,   22,   65,   64,   35,   35,
 /*  2220 */    35,  372,   35,   35,   35,   35,  377,   35,  379,  331,
 /*  2230 */    35,   35,   71,   93,   35,   44,   35,   35,   22,   35,
 /*  2240 */   408,   35,   35,   71,  412,  331,   35,  415,  416,  417,
 /*  2250 */   418,  419,  420,   35,  422,   35,   35,  408,   35,   22,
 /*  2260 */    35,  412,  364,    0,  415,  416,  417,  418,  419,  420,
 /*  2270 */   372,  422,   48,   35,   39,  377,    0,  379,  364,   35,
 /*  2280 */    48,   39,    0,   35,   48,    0,  372,   35,   39,   48,
 /*  2290 */    39,  377,    0,  379,  331,   35,   35,    0,   20,   22,
 /*  2300 */    21,  471,   22,   22,   21,  471,  408,  471,  471,  471,
 /*  2310 */   412,  471,  471,  415,  416,  417,  418,  419,  420,  331,
 /*  2320 */   422,  471,  408,  471,  471,  471,  412,  364,  471,  415,
 /*  2330 */   416,  417,  418,  419,  420,  372,  422,  471,  471,  471,
 /*  2340 */   377,  471,  379,  331,  471,  471,  471,  471,  471,  471,
 /*  2350 */   471,  471,  364,  471,  471,  471,  471,  471,  471,  471,
 /*  2360 */   372,  471,  471,  471,  471,  377,  471,  379,  471,  471,
 /*  2370 */   471,  408,  471,  471,  471,  412,  364,  471,  415,  416,
 /*  2380 */   417,  418,  419,  420,  372,  422,  471,  471,  471,  377,
 /*  2390 */   471,  379,  471,  471,  471,  471,  408,  471,  471,  471,
 /*  2400 */   412,  471,  471,  415,  416,  417,  418,  419,  420,  471,
 /*  2410 */   422,  471,  471,  471,  331,  471,  471,  471,  471,  471,
 /*  2420 */   408,  471,  471,  471,  412,  471,  471,  415,  416,  417,
 /*  2430 */   418,  419,  420,  471,  422,  471,  331,  471,  471,  471,
 /*  2440 */   471,  471,  471,  471,  471,  471,  471,  364,  471,  471,
 /*  2450 */   471,  471,  471,  471,  471,  372,  471,  471,  471,  471,
 /*  2460 */   377,  471,  379,  331,  471,  471,  471,  471,  471,  364,
 /*  2470 */   471,  471,  471,  471,  471,  471,  471,  372,  471,  471,
 /*  2480 */   471,  471,  377,  471,  379,  471,  471,  471,  471,  471,
 /*  2490 */   471,  408,  471,  471,  471,  412,  364,  471,  415,  416,
 /*  2500 */   417,  418,  419,  420,  372,  422,  471,  471,  471,  377,
 /*  2510 */   471,  379,  331,  408,  471,  471,  471,  412,  471,  471,
 /*  2520 */   415,  416,  417,  418,  419,  420,  471,  422,  331,  471,
 /*  2530 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
 /*  2540 */   408,  471,  471,  471,  412,  364,  471,  415,  416,  417,
 /*  2550 */   418,  419,  420,  372,  422,  471,  471,  471,  377,  471,
 /*  2560 */   379,  364,  471,  471,  471,  471,  471,  471,  471,  372,
 /*  2570 */   471,  471,  471,  471,  377,  471,  379,  331,  471,  471,
 /*  2580 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  408,
 /*  2590 */   471,  471,  471,  412,  471,  471,  415,  416,  417,  418,
 /*  2600 */   419,  420,  471,  422,  471,  408,  471,  471,  471,  412,
 /*  2610 */   364,  471,  415,  416,  417,  418,  419,  420,  372,  422,
 /*  2620 */   471,  471,  471,  377,  471,  379,  471,  471,  471,  471,
 /*  2630 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
 /*  2640 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
 /*  2650 */   471,  471,  471,  471,  408,  471,  471,  471,  412,  471,
 /*  2660 */   471,  415,  416,  417,  418,  419,  420,  471,  422,
};
#define YY_SHIFT_COUNT    (749)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2297)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   870,    0,   98,    0,  320,  320,  320,  320,  320,  320,
 /*    10 */   320,  320,  320,  320,  320,  418,  639,  639,  737,  639,
 /*    20 */   639,  639,  639,  639,  639,  639,  639,  639,  639,  639,
 /*    30 */   639,  639,  639,  639,  639,  639,  639,  639,  639,  639,
 /*    40 */   639,  639,  639,  639,  639,  639,  639,  639,   28,   30,
 /*    50 */   941,   17,  599,  352,  409,  352,   17,   17, 1302, 1302,
 /*    60 */  1302,  352, 1302, 1302,   94,  352,  191,  754,  376,  376,
 /*    70 */   754,   89,   89,  213,  145,   14,   14,  376,  376,  376,
 /*    80 */   376,  376,  376,  376,  406,  376,  376,  323,  191,  376,
 /*    90 */   376,  444,  376,  191,  376,  406,  376,  406,  191,  376,
 /*   100 */   376,  191,  376,  191,  191,  191,  376,  425,  953,  285,
 /*   110 */   285,  331,  150, 1047, 1047, 1047, 1047, 1047, 1047, 1047,
 /*   120 */  1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047,
 /*   130 */  1047, 1047, 1344,  823,  213,  145,  485,  403,  403,  403,
 /*   140 */   809,  801,  801,  485,  475,  475,  475,  323,  401,  286,
 /*   150 */   191,  516,  191,  516,  516,  504,  624,  244,  244,  244,
 /*   160 */   244,  244,  244,  244,  244, 1624,  334,  473,  260,  100,
 /*   170 */   183,   25,  121,  271,  558,  560,  583,  783,  547,  601,
 /*   180 */   728,  739,  934,  728, 1162,  845, 1065, 1105, 1313, 1188,
 /*   190 */  1334, 1368, 1334, 1239, 1373, 1373, 1334, 1239, 1239, 1320,
 /*   200 */  1316, 1373, 1330, 1373, 1373, 1373, 1411, 1411, 1415,  323,
 /*   210 */  1419,  323, 1431, 1436,  323, 1431,  323,  323,  323, 1373,
 /*   220 */   323, 1435, 1435, 1411,  191,  191,  191,  191,  191,  191,
 /*   230 */   191,  191,  191,  191,  191, 1373, 1411,  516,  516,  516,
 /*   240 */  1300, 1413, 1415,  425, 1331, 1419,  425, 1373, 1368, 1368,
 /*   250 */   516, 1279, 1283,  516, 1279, 1283,  516,  516,  191, 1292,
 /*   260 */  1386, 1279, 1305, 1304, 1317, 1105, 1293, 1307, 1314, 1335,
 /*   270 */   475, 1567, 1373, 1431,  425,  425, 1583, 1283,  516,  516,
 /*   280 */   516,  516,  516, 1283,  516, 1440,  425,  504,  425,  475,
 /*   290 */  1531, 1535,  516,  624, 1373,  425, 1608, 1411, 2669, 2669,
 /*   300 */  2669, 2669, 2669, 2669, 2669, 2669, 2669,  170, 1310,  534,
 /*   310 */   687,  561,  580,  904,  632,  139,  788,  926, 1016,  699,
 /*   320 */   699,  699,  699,  699,  699,  699,  699,  699,  173,  559,
 /*   330 */    27,   27,  209,  230,  514,  689,  657,  974,  592,  750,
 /*   340 */   688,  688,  594,  791,  768,  594,  594,  594,   31, 1116,
 /*   350 */  1147, 1163,  130, 1168, 1104, 1106, 1114, 1135, 1172, 1228,
 /*   360 */  1232, 1046, 1151, 1155, 1156, 1193, 1211, 1218,  882, 1077,
 /*   370 */  1029,  995, 1219, 1220, 1225, 1226, 1227, 1229, 1187, 1231,
 /*   380 */  1174, 1181, 1183, 1233, 1240, 1235, 1246, 1248, 1252, 1269,
 /*   390 */  1301,   91, 1254, 1290, 1303,  898, 1650, 1660, 1661, 1626,
 /*   400 */  1666, 1634, 1465, 1638, 1639, 1641, 1478, 1685, 1651, 1653,
 /*   410 */  1492, 1699, 1494, 1701, 1667, 1703, 1683, 1707, 1673, 1519,
 /*   420 */  1533, 1538, 1719, 1725, 1728, 1547, 1550, 1733, 1734, 1689,
 /*   430 */  1738, 1739, 1741, 1704, 1745, 1755, 1756, 1757, 1767, 1768,
 /*   440 */  1769, 1771, 1604, 1726, 1760, 1607, 1763, 1764, 1765, 1772,
 /*   450 */  1779, 1781, 1782, 1783, 1784, 1787, 1788, 1790, 1791, 1792,
 /*   460 */  1795, 1796, 1758, 1797, 1802, 1803, 1804, 1805, 1806, 1785,
 /*   470 */  1808, 1809, 1811, 1674, 1812, 1815, 1798, 1723, 1799, 1727,
 /*   480 */  1822, 1766, 1793, 1825, 1774, 1827, 1777, 1829, 1836, 1807,
 /*   490 */  1813, 1801, 1800, 1839, 1810, 1840, 1814, 1846, 1820, 1816,
 /*   500 */  1850, 1863, 1864, 1826, 1690, 1868, 1877, 1879, 1817, 1880,
 /*   510 */  1881, 1848, 1837, 1845, 1886, 1853, 1841, 1854, 1902, 1869,
 /*   520 */  1855, 1867, 1909, 1875, 1866, 1872, 1912, 1915, 1917, 1918,
 /*   530 */  1818, 1819, 1884, 1900, 1920, 1890, 1893, 1894, 1895, 1896,
 /*   540 */  1888, 1889, 1899, 1903, 1913, 1904, 1937, 1927, 1942, 1929,
 /*   550 */  1905, 1953, 1932, 1933, 1967, 1934, 1971, 1938, 1975, 1954,
 /*   560 */  1957, 1943, 1944, 1945, 1882, 1885, 1981, 1824, 1897, 1949,
 /*   570 */  1986, 1828, 1966, 1830, 1823, 1990, 1994, 1834, 1821, 1992,
 /*   580 */  1956, 1750, 1916, 1919, 1921, 1923, 1926, 1935, 1939, 1936,
 /*   590 */  1970, 1989, 1950, 1952, 1958, 1959, 1960, 2006, 1991, 2007,
 /*   600 */  1962, 2013, 1833, 1964, 1965, 2033, 2016, 1844, 2028, 2032,
 /*   610 */  2035, 2037, 2038, 2040, 1976, 1977, 2021, 1838, 2036, 2029,
 /*   620 */  2079, 2081, 2099, 2101, 1983, 2063, 1800, 2056, 2005, 2014,
 /*   630 */  2015, 2017, 2019, 1969, 2020, 2113, 2082, 1955, 2034, 2023,
 /*   640 */  1800, 2088, 2093, 2043, 1908, 2045, 2142, 2123, 1941, 2046,
 /*   650 */  2047, 2049, 2050, 2055, 2057, 2103, 2059, 2060, 2109, 2061,
 /*   660 */  2135, 1947, 2064, 2054, 2065, 2133, 2134, 2070, 2071, 2138,
 /*   670 */  2084, 2085, 2147, 2089, 2087, 2150, 2098, 2100, 2164, 2102,
 /*   680 */  2078, 2086, 2090, 2092, 2106, 2159, 2107, 2170, 2110, 2159,
 /*   690 */  2159, 2193, 2151, 2153, 2183, 2184, 2185, 2187, 2188, 2189,
 /*   700 */  2190, 2192, 2195, 2196, 2161, 2140, 2191, 2199, 2201, 2202,
 /*   710 */  2216, 2204, 2206, 2207, 2172, 1888, 2211, 1889, 2218, 2220,
 /*   720 */  2221, 2223, 2237, 2225, 2263, 2238, 2224, 2235, 2276, 2244,
 /*   730 */  2232, 2242, 2282, 2248, 2236, 2249, 2285, 2252, 2241, 2251,
 /*   740 */  2292, 2260, 2261, 2297, 2277, 2279, 2280, 2281, 2283, 2278,
};
#define YY_REDUCE_COUNT (306)
#define YY_REDUCE_MIN   (-436)
#define YY_REDUCE_MAX   (2246)
static const short yy_reduce_ofst[] = {
 /*     0 */  -258, -328,   50,  248,  613,  758,  807,  866,  889,  467,
 /*    10 */   967, 1026, 1049, 1131, 1180, 1203,  365, 1275, 1298, 1332,
 /*    20 */  1358, 1422,  643, 1454, 1479, 1544, 1528, 1593, 1610, 1627,
 /*    30 */  1676, 1692, 1710, 1759, 1775, 1832, 1849, 1898, 1914, 1963,
 /*    40 */  1988, 2012, 2083, 2105, 2132, 2181, 2197, 2246, -316, -302,
 /*    50 */   157,  247, -256,   -6,  257,  375,  556,  978, -359, -345,
 /*    60 */  -339, -436,  -29,  402, -380, -178, -354, -195,  354,  366,
 /*    70 */  -379, -145,    1, -282, -218,   49,  171,  141,  228,  332,
 /*    80 */   460,  478,  542,  645, -333,  671,  672,   42,  110,  388,
 /*    90 */   684,   99,  715,  361,  781,  -44,  784,  -43,  241,  785,
 /*   100 */   786,  535,  826,  243,  608,  474,  828,   82, -335,  224,
 /*   110 */   224, -251,   22, -163,  -65,  105,  342,  369,  417,  476,
 /*   120 */   545,  571,  574,  605,  612,  647,  668,  706,  707,  736,
 /*   130 */   755,  757,  205, -105, -240,  355,  380, -105,  -48,   77,
 /*   140 */   118,  640,  648,  527, -276,  759,  771,  747,  795, -417,
 /*   150 */  -167,  468, -305,  787,  819,  802,  775, -364,  264,  390,
 /*   160 */   445,  616,  637,  725,  616,  520,  660,  916,  746,  780,
 /*   170 */   799,  924,  820,  912,  912,  939,  942, 1003,  915,  955,
 /*   180 */   908,  908,  890,  908,  919,  909,  912,  949,  954,  973,
 /*   190 */   993,  991, 1007, 1010, 1058, 1067, 1023, 1028, 1032, 1059,
 /*   200 */  1074, 1084, 1078, 1088, 1090, 1091, 1099, 1100, 1033, 1092,
 /*   210 */  1061, 1109, 1118, 1066, 1125, 1132, 1129, 1130, 1136, 1137,
 /*   220 */  1140, 1149, 1150, 1160, 1133, 1134, 1141, 1142, 1143, 1145,
 /*   230 */  1148, 1152, 1153, 1154, 1157, 1161, 1166, 1112, 1117, 1119,
 /*   240 */  1097, 1115, 1120, 1176, 1122, 1146, 1192, 1197, 1139, 1158,
 /*   250 */  1164, 1087, 1169, 1165, 1103, 1170, 1178, 1179,  912, 1123,
 /*   260 */  1113, 1121, 1124, 1127, 1138, 1171, 1108, 1126, 1107,  908,
 /*   270 */  1213, 1175, 1255, 1251, 1250, 1258, 1214, 1215, 1253, 1256,
 /*   280 */  1257, 1259, 1260, 1216, 1261, 1223, 1262, 1268, 1273, 1245,
 /*   290 */  1200, 1272, 1264, 1288, 1306, 1308, 1312, 1315, 1265, 1249,
 /*   300 */  1263, 1266, 1291, 1297, 1309, 1321, 1329,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*    10 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*    20 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*    30 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*    40 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*    50 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*    60 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*    70 */  1687, 1687, 1687, 1953, 1687, 1687, 1687, 1687, 1687, 1687,
 /*    80 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1766, 1687, 1687,
 /*    90 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   100 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1764, 1946, 2162,
 /*   110 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   120 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   130 */  1687, 1687, 1687, 2174, 1687, 1687, 1687, 2174, 2174, 2174,
 /*   140 */  1764, 2134, 2134, 1687, 1687, 1687, 1687, 1766, 2007, 1687,
 /*   150 */  1687, 1687, 1687, 1687, 1687, 1881, 1687, 1687, 1687, 1687,
 /*   160 */  1687, 1905, 1687, 1687, 1687, 1999, 1687, 1687, 2199, 2255,
 /*   170 */  1687, 1687, 2202, 1687, 1687, 1687, 1958, 1687, 1835, 2189,
 /*   180 */  2166, 2180, 2239, 2167, 2164, 2183, 1687, 2193, 1687, 1992,
 /*   190 */  1951, 1687, 1951, 1948, 1687, 1687, 1951, 1948, 1948, 1824,
 /*   200 */  1820, 1687, 1818, 1687, 1687, 1687, 1687, 1687, 1687, 1766,
 /*   210 */  1687, 1766, 1687, 1687, 1766, 1687, 1766, 1766, 1766, 1687,
 /*   220 */  1766, 1744, 1744, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   230 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   240 */  2019, 2005, 1687, 1764, 2001, 1687, 1764, 1687, 1687, 1687,
 /*   250 */  1687, 2210, 2208, 1687, 2210, 2208, 1687, 1687, 1687, 2224,
 /*   260 */  2220, 2210, 2228, 2226, 2195, 2193, 2258, 2245, 2241, 2180,
 /*   270 */  1687, 1687, 1687, 1687, 1764, 1764, 1687, 2208, 1687, 1687,
 /*   280 */  1687, 1687, 1687, 2208, 1687, 1687, 1764, 1687, 1764, 1687,
 /*   290 */  1687, 1851, 1687, 1687, 1687, 1764, 1719, 1687, 1994, 2010,
 /*   300 */  1976, 1976, 1884, 1884, 1884, 1767, 1692, 1687, 1687, 1687,
 /*   310 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 2223,
 /*   320 */  2222, 2089, 1687, 2138, 2137, 2136, 2127, 2088, 1847, 1687,
 /*   330 */  2087, 2086, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   340 */  1967, 1966, 2080, 1687, 1687, 2081, 2079, 2078, 1687, 1687,
 /*   350 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   360 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 2242,
 /*   370 */  2246, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 2163, 1687,
 /*   380 */  1687, 1687, 1687, 1687, 2062, 1687, 1687, 1687, 1687, 1687,
 /*   390 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   400 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   410 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   420 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   430 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   440 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   450 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   460 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   470 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   480 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   490 */  1687, 1724, 2067, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   500 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   510 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   520 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   530 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   540 */  1805, 1804, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   550 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   560 */  1687, 1687, 1687, 1687, 2071, 1687, 1687, 1687, 1687, 1687,
 /*   570 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 2238,
 /*   580 */  2196, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   590 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 2062,
 /*   600 */  1687, 2221, 1687, 1687, 2236, 1687, 2240, 1687, 1687, 1687,
 /*   610 */  1687, 1687, 1687, 1687, 2173, 2169, 1687, 1687, 2165, 1687,
 /*   620 */  1687, 1687, 1687, 1687, 1687, 1687, 2070, 1687, 1687, 1687,
 /*   630 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   640 */  2061, 1687, 2124, 1687, 1687, 1687, 2158, 1687, 1687, 2109,
 /*   650 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 2071,
 /*   660 */  1687, 2074, 1687, 1687, 1687, 1687, 1687, 1878, 1687, 1687,
 /*   670 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   680 */  1863, 1861, 1860, 1859, 1687, 1891, 1687, 1687, 1687, 1887,
 /*   690 */  1886, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   700 */  1687, 1687, 1687, 1687, 1687, 1687, 1785, 1687, 1687, 1687,
 /*   710 */  1687, 1687, 1687, 1687, 1687, 1777, 1687, 1776, 1687, 1687,
 /*   720 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   730 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   740 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*       WITH => nothing */
    0,  /*  TIMESTAMP => nothing */
  276,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  276,  /*      AFTER => ABORT */
  276,  /*     ATTACH => ABORT */
  276,  /*     BEFORE => ABORT */
  276,  /*      BEGIN => ABORT */
  276,  /*     BITAND => ABORT */
  276,  /*     BITNOT => ABORT */
  276,  /*      BITOR => ABORT */
  276,  /*     BLOCKS => ABORT */
  276,  /*     CHANGE => ABORT */
  276,  /*      COMMA => ABORT */
  276,  /*     CONCAT => ABORT */
  276,  /*   CONFLICT => ABORT */
  276,  /*       COPY => ABORT */
  276,  /*   DEFERRED => ABORT */
  276,  /* DELIMITERS => ABORT */
  276,  /*     DETACH => ABORT */
  276,  /*     DIVIDE => ABORT */
  276,  /*        DOT => ABORT */
  276,  /*       EACH => ABORT */
  276,  /*       FAIL => ABORT */
  276,  /*       FILE => ABORT */
  276,  /*        FOR => ABORT */
  276,  /*       GLOB => ABORT */
  276,  /*         ID => ABORT */
  276,  /*  IMMEDIATE => ABORT */
  276,  /*     IMPORT => ABORT */
  276,  /*  INITIALLY => ABORT */
  276,  /*    INSTEAD => ABORT */
  276,  /*     ISNULL => ABORT */
  276,  /*        KEY => ABORT */
  276,  /*    MODULES => ABORT */
  276,  /*  NK_BITNOT => ABORT */
  276,  /*    NK_SEMI => ABORT */
  276,  /*    NOTNULL => ABORT */
  276,  /*         OF => ABORT */
  276,  /*       PLUS => ABORT */
  276,  /*  PRIVILEGE => ABORT */
  276,  /*      RAISE => ABORT */
  276,  /*    REPLACE => ABORT */
  276,  /*   RESTRICT => ABORT */
  276,  /*        ROW => ABORT */
  276,  /*       SEMI => ABORT */
  276,  /*       STAR => ABORT */
  276,  /*  STATEMENT => ABORT */
  276,  /*     STRICT => ABORT */
  276,  /*     STRING => ABORT */
  276,  /*      TIMES => ABORT */
  276,  /*     VALUES => ABORT */
  276,  /*   VARIABLE => ABORT */
  276,  /*       VIEW => ABORT */
  276,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "COMPACT",
  /*   63 */ "IF",
  /*   64 */ "NOT",
  /*   65 */ "EXISTS",
  /*   66 */ "BUFFER",
  /*   67 */ "CACHEMODEL",
  /*   68 */ "CACHESIZE",
  /*   69 */ "COMP",
  /*   70 */ "DURATION",
  /*   71 */ "NK_VARIABLE",
  /*   72 */ "MAXROWS",
  /*   73 */ "MINROWS",
  /*   74 */ "KEEP",
  /*   75 */ "PAGES",
  /*   76 */ "PAGESIZE",
  /*   77 */ "TSDB_PAGESIZE",
  /*   78 */ "PRECISION",
  /*   79 */ "REPLICA",
  /*   80 */ "VGROUPS",
  /*   81 */ "SINGLE_STABLE",
  /*   82 */ "RETENTIONS",
  /*   83 */ "SCHEMALESS",
  /*   84 */ "WAL_LEVEL",
  /*   85 */ "WAL_FSYNC_PERIOD",
  /*   86 */ "WAL_RETENTION_PERIOD",
  /*   87 */ "WAL_RETENTION_SIZE",
  /*   88 */ "WAL_ROLL_PERIOD",
  /*   89 */ "WAL_SEGMENT_SIZE",
  /*   90 */ "STT_TRIGGER",
  /*   91 */ "TABLE_PREFIX",
  /*   92 */ "TABLE_SUFFIX",
  /*   93 */ "NK_COLON",
  /*   94 */ "MAX_SPEED",
  /*   95 */ "START",
  /*   96 */ "WITH",
  /*   97 */ "TIMESTAMP",
  /*   98 */ "END",
  /*   99 */ "TABLE",
  /*  100 */ "NK_LP",
  /*  101 */ "NK_RP",
  /*  102 */ "STABLE",
  /*  103 */ "ADD",
  /*  104 */ "COLUMN",
  /*  105 */ "MODIFY",
  /*  106 */ "RENAME",
  /*  107 */ "TAG",
  /*  108 */ "SET",
  /*  109 */ "NK_EQ",
  /*  110 */ "USING",
  /*  111 */ "TAGS",
  /*  112 */ "BOOL",
  /*  113 */ "TINYINT",
  /*  114 */ "SMALLINT",
  /*  115 */ "INT",
  /*  116 */ "INTEGER",
  /*  117 */ "BIGINT",
  /*  118 */ "FLOAT",
  /*  119 */ "DOUBLE",
  /*  120 */ "BINARY",
  /*  121 */ "NCHAR",
  /*  122 */ "UNSIGNED",
  /*  123 */ "JSON",
  /*  124 */ "VARCHAR",
  /*  125 */ "MEDIUMBLOB",
  /*  126 */ "BLOB",
  /*  127 */ "VARBINARY",
  /*  128 */ "DECIMAL",
  /*  129 */ "COMMENT",
  /*  130 */ "MAX_DELAY",
  /*  131 */ "WATERMARK",
  /*  132 */ "ROLLUP",
  /*  133 */ "TTL",
  /*  134 */ "SMA",
  /*  135 */ "DELETE_MARK",
  /*  136 */ "FIRST",
  /*  137 */ "LAST",
  /*  138 */ "SHOW",
  /*  139 */ "PRIVILEGES",
  /*  140 */ "DATABASES",
  /*  141 */ "TABLES",
  /*  142 */ "STABLES",
  /*  143 */ "MNODES",
  /*  144 */ "QNODES",
  /*  145 */ "FUNCTIONS",
  /*  146 */ "INDEXES",
  /*  147 */ "ACCOUNTS",
  /*  148 */ "APPS",
  /*  149 */ "CONNECTIONS",
  /*  150 */ "LICENCES",
  /*  151 */ "GRANTS",
  /*  152 */ "QUERIES",
  /*  153 */ "SCORES",
  /*  154 */ "TOPICS",
  /*  155 */ "VARIABLES",
  /*  156 */ "CLUSTER",
  /*  157 */ "BNODES",
  /*  158 */ "SNODES",
  /*  159 */ "TRANSACTIONS",
  /*  160 */ "DISTRIBUTED",
  /*  161 */ "CONSUMERS",
  /*  162 */ "SUBSCRIPTIONS",
  /*  163 */ "VNODES",
  /*  164 */ "ALIVE",
  /*  165 */ "LIKE",
  /*  166 */ "TBNAME",
  /*  167 */ "QTAGS",
  /*  168 */ "AS",
  /*  169 */ "INDEX",
  /*  170 */ "FUNCTION",
  /*  171 */ "INTERVAL",
  /*  172 */ "COUNT",
  /*  173 */ "LAST_ROW",
  /*  174 */ "TOPIC",
  /*  175 */ "META",
  /*  176 */ "CONSUMER",
  /*  177 */ "GROUP",
  /*  178 */ "DESC",
  /*  179 */ "DESCRIBE",
  /*  180 */ "RESET",
  /*  181 */ "QUERY",
  /*  182 */ "CACHE",
  /*  183 */ "EXPLAIN",
  /*  184 */ "ANALYZE",
  /*  185 */ "VERBOSE",
  /*  186 */ "NK_BOOL",
  /*  187 */ "RATIO",
  /*  188 */ "NK_FLOAT",
  /*  189 */ "OUTPUTTYPE",
  /*  190 */ "AGGREGATE",
  /*  191 */ "BUFSIZE",
  /*  192 */ "STREAM",
  /*  193 */ "INTO",
  /*  194 */ "TRIGGER",
  /*  195 */ "AT_ONCE",
  /*  196 */ "WINDOW_CLOSE",
  /*  197 */ "IGNORE",
  /*  198 */ "EXPIRED",
  /*  199 */ "FILL_HISTORY",
  /*  200 */ "UPDATE",
  /*  201 */ "SUBTABLE",
  /*  202 */ "KILL",
  /*  203 */ "CONNECTION",
  /*  204 */ "TRANSACTION",
  /*  205 */ "BALANCE",
  /*  206 */ "VGROUP",
  /*  207 */ "MERGE",
  /*  208 */ "REDISTRIBUTE",
  /*  209 */ "SPLIT",
  /*  210 */ "DELETE",
  /*  211 */ "INSERT",
  /*  212 */ "NULL",
  /*  213 */ "NK_QUESTION",
  /*  214 */ "NK_ARROW",
  /*  215 */ "ROWTS",
  /*  216 */ "QSTART",
  /*  217 */ "QEND",
  /*  218 */ "QDURATION",
  /*  219 */ "WSTART",
  /*  220 */ "WEND",
  /*  221 */ "WDURATION",
  /*  222 */ "IROWTS",
  /*  223 */ "ISFILLED",
  /*  224 */ "CAST",
  /*  225 */ "NOW",
  /*  226 */ "TODAY",
  /*  227 */ "TIMEZONE",
  /*  228 */ "CLIENT_VERSION",
  /*  229 */ "SERVER_VERSION",
  /*  230 */ "SERVER_STATUS",
  /*  231 */ "CURRENT_USER",
  /*  232 */ "CASE",
  /*  233 */ "WHEN",
  /*  234 */ "THEN",
  /*  235 */ "ELSE",
  /*  236 */ "BETWEEN",
  /*  237 */ "IS",
  /*  238 */ "NK_LT",
  /*  239 */ "NK_GT",
  /*  240 */ "NK_LE",
  /*  241 */ "NK_GE",
  /*  242 */ "NK_NE",
  /*  243 */ "MATCH",
  /*  244 */ "NMATCH",
  /*  245 */ "CONTAINS",
  /*  246 */ "IN",
  /*  247 */ "JOIN",
  /*  248 */ "INNER",
  /*  249 */ "SELECT",
  /*  250 */ "DISTINCT",
  /*  251 */ "WHERE",
  /*  252 */ "PARTITION",
  /*  253 */ "BY",
  /*  254 */ "SESSION",
  /*  255 */ "STATE_WINDOW",
  /*  256 */ "EVENT_WINDOW",
  /*  257 */ "SLIDING",
  /*  258 */ "FILL",
  /*  259 */ "VALUE",
  /*  260 */ "VALUE_F",
  /*  261 */ "NONE",
  /*  262 */ "PREV",
  /*  263 */ "NULL_F",
  /*  264 */ "LINEAR",
  /*  265 */ "NEXT",
  /*  266 */ "HAVING",
  /*  267 */ "RANGE",
  /*  268 */ "EVERY",
  /*  269 */ "ORDER",
  /*  270 */ "SLIMIT",
  /*  271 */ "SOFFSET",
  /*  272 */ "LIMIT",
  /*  273 */ "OFFSET",
  /*  274 */ "ASC",
  /*  275 */ "NULLS",
  /*  276 */ "ABORT",
  /*  277 */ "AFTER",
  /*  278 */ "ATTACH",
  /*  279 */ "BEFORE",
  /*  280 */ "BEGIN",
  /*  281 */ "BITAND",
  /*  282 */ "BITNOT",
  /*  283 */ "BITOR",
  /*  284 */ "BLOCKS",
  /*  285 */ "CHANGE",
  /*  286 */ "COMMA",
  /*  287 */ "CONCAT",
  /*  288 */ "CONFLICT",
  /*  289 */ "COPY",
  /*  290 */ "DEFERRED",
  /*  291 */ "DELIMITERS",
  /*  292 */ "DETACH",
  /*  293 */ "DIVIDE",
  /*  294 */ "DOT",
  /*  295 */ "EACH",
  /*  296 */ "FAIL",
  /*  297 */ "FILE",
  /*  298 */ "FOR",
  /*  299 */ "GLOB",
  /*  300 */ "ID",
  /*  301 */ "IMMEDIATE",
  /*  302 */ "IMPORT",
  /*  303 */ "INITIALLY",
  /*  304 */ "INSTEAD",
  /*  305 */ "ISNULL",
  /*  306 */ "KEY",
  /*  307 */ "MODULES",
  /*  308 */ "NK_BITNOT",
  /*  309 */ "NK_SEMI",
  /*  310 */ "NOTNULL",
  /*  311 */ "OF",
  /*  312 */ "PLUS",
  /*  313 */ "PRIVILEGE",
  /*  314 */ "RAISE",
  /*  315 */ "REPLACE",
  /*  316 */ "RESTRICT",
  /*  317 */ "ROW",
  /*  318 */ "SEMI",
  /*  319 */ "STAR",
  /*  320 */ "STATEMENT",
  /*  321 */ "STRICT",
  /*  322 */ "STRING",
  /*  323 */ "TIMES",
  /*  324 */ "VALUES",
  /*  325 */ "VARIABLE",
  /*  326 */ "VIEW",
  /*  327 */ "WAL",
  /*  328 */ "cmd",
  /*  329 */ "account_options",
  /*  330 */ "alter_account_options",
  /*  331 */ "literal",
  /*  332 */ "alter_account_option",
  /*  333 */ "user_name",
  /*  334 */ "sysinfo_opt",
  /*  335 */ "privileges",
  /*  336 */ "priv_level",
  /*  337 */ "priv_type_list",
  /*  338 */ "priv_type",
  /*  339 */ "db_name",
  /*  340 */ "topic_name",
  /*  341 */ "dnode_endpoint",
  /*  342 */ "force_opt",
  /*  343 */ "not_exists_opt",
  /*  344 */ "db_options",
  /*  345 */ "exists_opt",
  /*  346 */ "alter_db_options",
  /*  347 */ "speed_opt",
  /*  348 */ "start_opt",
  /*  349 */ "end_opt",
  /*  350 */ "integer_list",
  /*  351 */ "variable_list",
  /*  352 */ "retention_list",
  /*  353 */ "alter_db_option",
  /*  354 */ "retention",
  /*  355 */ "full_table_name",
  /*  356 */ "column_def_list",
  /*  357 */ "tags_def_opt",
  /*  358 */ "table_options",
  /*  359 */ "multi_create_clause",
  /*  360 */ "tags_def",
  /*  361 */ "multi_drop_clause",
  /*  362 */ "alter_table_clause",
  /*  363 */ "alter_table_options",
  /*  364 */ "column_name",
  /*  365 */ "type_name",
  /*  366 */ "signed_literal",
  /*  367 */ "create_subtable_clause",
  /*  368 */ "specific_cols_opt",
  /*  369 */ "expression_list",
  /*  370 */ "drop_table_clause",
  /*  371 */ "col_name_list",
  /*  372 */ "table_name",
  /*  373 */ "column_def",
  /*  374 */ "duration_list",
  /*  375 */ "rollup_func_list",
  /*  376 */ "alter_table_option",
  /*  377 */ "duration_literal",
  /*  378 */ "rollup_func_name",
  /*  379 */ "function_name",
  /*  380 */ "col_name",
  /*  381 */ "db_name_cond_opt",
  /*  382 */ "like_pattern_opt",
  /*  383 */ "table_name_cond",
  /*  384 */ "from_db_opt",
  /*  385 */ "tag_list_opt",
  /*  386 */ "tag_item",
  /*  387 */ "column_alias",
  /*  388 */ "full_index_name",
  /*  389 */ "index_options",
  /*  390 */ "index_name",
  /*  391 */ "func_list",
  /*  392 */ "sliding_opt",
  /*  393 */ "sma_stream_opt",
  /*  394 */ "func",
  /*  395 */ "sma_func_name",
  /*  396 */ "query_or_subquery",
  /*  397 */ "cgroup_name",
  /*  398 */ "analyze_opt",
  /*  399 */ "explain_options",
  /*  400 */ "insert_query",
  /*  401 */ "agg_func_opt",
  /*  402 */ "bufsize_opt",
  /*  403 */ "stream_name",
  /*  404 */ "stream_options",
  /*  405 */ "col_list_opt",
  /*  406 */ "tag_def_or_ref_opt",
  /*  407 */ "subtable_opt",
  /*  408 */ "expression",
  /*  409 */ "dnode_list",
  /*  410 */ "where_clause_opt",
  /*  411 */ "signed",
  /*  412 */ "literal_func",
  /*  413 */ "literal_list",
  /*  414 */ "table_alias",
  /*  415 */ "expr_or_subquery",
  /*  416 */ "pseudo_column",
  /*  417 */ "column_reference",
  /*  418 */ "function_expression",
  /*  419 */ "case_when_expression",
  /*  420 */ "star_func",
  /*  421 */ "star_func_para_list",
  /*  422 */ "noarg_func",
  /*  423 */ "other_para_list",
  /*  424 */ "star_func_para",
  /*  425 */ "when_then_list",
  /*  426 */ "case_when_else_opt",
  /*  427 */ "common_expression",
  /*  428 */ "when_then_expr",
  /*  429 */ "predicate",
  /*  430 */ "compare_op",
  /*  431 */ "in_op",
  /*  432 */ "in_predicate_value",
  /*  433 */ "boolean_value_expression",
  /*  434 */ "boolean_primary",
  /*  435 */ "from_clause_opt",
  /*  436 */ "table_reference_list",
  /*  437 */ "table_reference",
  /*  438 */ "table_primary",
  /*  439 */ "joined_table",
  /*  440 */ "alias_opt",
  /*  441 */ "subquery",
  /*  442 */ "parenthesized_joined_table",
  /*  443 */ "join_type",
  /*  444 */ "search_condition",
  /*  445 */ "query_specification",
  /*  446 */ "set_quantifier_opt",
  /*  447 */ "select_list",
  /*  448 */ "partition_by_clause_opt",
  /*  449 */ "range_opt",
  /*  450 */ "every_opt",
  /*  451 */ "fill_opt",
  /*  452 */ "twindow_clause_opt",
  /*  453 */ "group_by_clause_opt",
  /*  454 */ "having_clause_opt",
  /*  455 */ "select_item",
  /*  456 */ "partition_list",
  /*  457 */ "partition_item",
  /*  458 */ "fill_mode",
  /*  459 */ "group_by_list",
  /*  460 */ "query_expression",
  /*  461 */ "query_simple",
  /*  462 */ "order_by_clause_opt",
  /*  463 */ "slimit_clause_opt",
  /*  464 */ "limit_clause_opt",
  /*  465 */ "union_query_expression",
  /*  466 */ "query_simple_or_subquery",
  /*  467 */ "sort_specification_list",
  /*  468 */ "sort_specification",
  /*  469 */ "ordering_specification_opt",
  /*  470 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  73 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  74 */ "not_exists_opt ::=",
 /*  75 */ "exists_opt ::= IF EXISTS",
 /*  76 */ "exists_opt ::=",
 /*  77 */ "db_options ::=",
 /*  78 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  79 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  80 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  81 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  83 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  84 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  86 */ "db_options ::= db_options KEEP integer_list",
 /*  87 */ "db_options ::= db_options KEEP variable_list",
 /*  88 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  89 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  92 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  93 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  94 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  95 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  96 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 107 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 108 */ "alter_db_options ::= alter_db_option",
 /* 109 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 110 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 111 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 112 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 114 */ "alter_db_option ::= KEEP integer_list",
 /* 115 */ "alter_db_option ::= KEEP variable_list",
 /* 116 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 117 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 118 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 119 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 120 */ "alter_db_option ::= MINROWS NK_INTEGER",
 /* 121 */ "integer_list ::= NK_INTEGER",
 /* 122 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 123 */ "variable_list ::= NK_VARIABLE",
 /* 124 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 125 */ "retention_list ::= retention",
 /* 126 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 127 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 128 */ "speed_opt ::=",
 /* 129 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 130 */ "start_opt ::=",
 /* 131 */ "start_opt ::= START WITH NK_INTEGER",
 /* 132 */ "start_opt ::= START WITH NK_STRING",
 /* 133 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 134 */ "end_opt ::=",
 /* 135 */ "end_opt ::= END WITH NK_INTEGER",
 /* 136 */ "end_opt ::= END WITH NK_STRING",
 /* 137 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 138 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 139 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 140 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 141 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 142 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 143 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 144 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 145 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 146 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 147 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 148 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 149 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 150 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 151 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 152 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 153 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 154 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 155 */ "multi_create_clause ::= create_subtable_clause",
 /* 156 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 157 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 158 */ "multi_drop_clause ::= drop_table_clause",
 /* 159 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 160 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 161 */ "specific_cols_opt ::=",
 /* 162 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 163 */ "full_table_name ::= table_name",
 /* 164 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 165 */ "column_def_list ::= column_def",
 /* 166 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 167 */ "column_def ::= column_name type_name",
 /* 168 */ "type_name ::= BOOL",
 /* 169 */ "type_name ::= TINYINT",
 /* 170 */ "type_name ::= SMALLINT",
 /* 171 */ "type_name ::= INT",
 /* 172 */ "type_name ::= INTEGER",
 /* 173 */ "type_name ::= BIGINT",
 /* 174 */ "type_name ::= FLOAT",
 /* 175 */ "type_name ::= DOUBLE",
 /* 176 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 177 */ "type_name ::= TIMESTAMP",
 /* 178 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= TINYINT UNSIGNED",
 /* 180 */ "type_name ::= SMALLINT UNSIGNED",
 /* 181 */ "type_name ::= INT UNSIGNED",
 /* 182 */ "type_name ::= BIGINT UNSIGNED",
 /* 183 */ "type_name ::= JSON",
 /* 184 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 185 */ "type_name ::= MEDIUMBLOB",
 /* 186 */ "type_name ::= BLOB",
 /* 187 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 188 */ "type_name ::= DECIMAL",
 /* 189 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 190 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 191 */ "tags_def_opt ::=",
 /* 192 */ "tags_def_opt ::= tags_def",
 /* 193 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 194 */ "table_options ::=",
 /* 195 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 196 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 197 */ "table_options ::= table_options WATERMARK duration_list",
 /* 198 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 199 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 200 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 201 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 202 */ "alter_table_options ::= alter_table_option",
 /* 203 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 204 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 205 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 206 */ "duration_list ::= duration_literal",
 /* 207 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 208 */ "rollup_func_list ::= rollup_func_name",
 /* 209 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 210 */ "rollup_func_name ::= function_name",
 /* 211 */ "rollup_func_name ::= FIRST",
 /* 212 */ "rollup_func_name ::= LAST",
 /* 213 */ "col_name_list ::= col_name",
 /* 214 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 215 */ "col_name ::= column_name",
 /* 216 */ "cmd ::= SHOW DNODES",
 /* 217 */ "cmd ::= SHOW USERS",
 /* 218 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 219 */ "cmd ::= SHOW DATABASES",
 /* 220 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 221 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 222 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 223 */ "cmd ::= SHOW MNODES",
 /* 224 */ "cmd ::= SHOW QNODES",
 /* 225 */ "cmd ::= SHOW FUNCTIONS",
 /* 226 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 227 */ "cmd ::= SHOW STREAMS",
 /* 228 */ "cmd ::= SHOW ACCOUNTS",
 /* 229 */ "cmd ::= SHOW APPS",
 /* 230 */ "cmd ::= SHOW CONNECTIONS",
 /* 231 */ "cmd ::= SHOW LICENCES",
 /* 232 */ "cmd ::= SHOW GRANTS",
 /* 233 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 234 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 235 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 236 */ "cmd ::= SHOW QUERIES",
 /* 237 */ "cmd ::= SHOW SCORES",
 /* 238 */ "cmd ::= SHOW TOPICS",
 /* 239 */ "cmd ::= SHOW VARIABLES",
 /* 240 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 241 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 242 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 243 */ "cmd ::= SHOW BNODES",
 /* 244 */ "cmd ::= SHOW SNODES",
 /* 245 */ "cmd ::= SHOW CLUSTER",
 /* 246 */ "cmd ::= SHOW TRANSACTIONS",
 /* 247 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 248 */ "cmd ::= SHOW CONSUMERS",
 /* 249 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 250 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 251 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 252 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 253 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 254 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 255 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 256 */ "db_name_cond_opt ::=",
 /* 257 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 258 */ "like_pattern_opt ::=",
 /* 259 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 260 */ "table_name_cond ::= table_name",
 /* 261 */ "from_db_opt ::=",
 /* 262 */ "from_db_opt ::= FROM db_name",
 /* 263 */ "tag_list_opt ::=",
 /* 264 */ "tag_list_opt ::= tag_item",
 /* 265 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 266 */ "tag_item ::= TBNAME",
 /* 267 */ "tag_item ::= QTAGS",
 /* 268 */ "tag_item ::= column_name",
 /* 269 */ "tag_item ::= column_name column_alias",
 /* 270 */ "tag_item ::= column_name AS column_alias",
 /* 271 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 272 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 273 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 274 */ "full_index_name ::= index_name",
 /* 275 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 276 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 277 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 278 */ "func_list ::= func",
 /* 279 */ "func_list ::= func_list NK_COMMA func",
 /* 280 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 281 */ "sma_func_name ::= function_name",
 /* 282 */ "sma_func_name ::= COUNT",
 /* 283 */ "sma_func_name ::= FIRST",
 /* 284 */ "sma_func_name ::= LAST",
 /* 285 */ "sma_func_name ::= LAST_ROW",
 /* 286 */ "sma_stream_opt ::=",
 /* 287 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 288 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 289 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 290 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 291 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 292 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 293 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 294 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 295 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 296 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 297 */ "cmd ::= DESC full_table_name",
 /* 298 */ "cmd ::= DESCRIBE full_table_name",
 /* 299 */ "cmd ::= RESET QUERY CACHE",
 /* 300 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 301 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 302 */ "analyze_opt ::=",
 /* 303 */ "analyze_opt ::= ANALYZE",
 /* 304 */ "explain_options ::=",
 /* 305 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 306 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 307 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 308 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 309 */ "agg_func_opt ::=",
 /* 310 */ "agg_func_opt ::= AGGREGATE",
 /* 311 */ "bufsize_opt ::=",
 /* 312 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 313 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 314 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 315 */ "col_list_opt ::=",
 /* 316 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 317 */ "tag_def_or_ref_opt ::=",
 /* 318 */ "tag_def_or_ref_opt ::= tags_def",
 /* 319 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 320 */ "stream_options ::=",
 /* 321 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 322 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 323 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 324 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 325 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 326 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 327 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 328 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 329 */ "subtable_opt ::=",
 /* 330 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 331 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 332 */ "cmd ::= KILL QUERY NK_STRING",
 /* 333 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 334 */ "cmd ::= BALANCE VGROUP",
 /* 335 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 336 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 337 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 338 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 339 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 340 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 341 */ "cmd ::= query_or_subquery",
 /* 342 */ "cmd ::= insert_query",
 /* 343 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 344 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 345 */ "literal ::= NK_INTEGER",
 /* 346 */ "literal ::= NK_FLOAT",
 /* 347 */ "literal ::= NK_STRING",
 /* 348 */ "literal ::= NK_BOOL",
 /* 349 */ "literal ::= TIMESTAMP NK_STRING",
 /* 350 */ "literal ::= duration_literal",
 /* 351 */ "literal ::= NULL",
 /* 352 */ "literal ::= NK_QUESTION",
 /* 353 */ "duration_literal ::= NK_VARIABLE",
 /* 354 */ "signed ::= NK_INTEGER",
 /* 355 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 356 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 357 */ "signed ::= NK_FLOAT",
 /* 358 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 359 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 360 */ "signed_literal ::= signed",
 /* 361 */ "signed_literal ::= NK_STRING",
 /* 362 */ "signed_literal ::= NK_BOOL",
 /* 363 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 364 */ "signed_literal ::= duration_literal",
 /* 365 */ "signed_literal ::= NULL",
 /* 366 */ "signed_literal ::= literal_func",
 /* 367 */ "signed_literal ::= NK_QUESTION",
 /* 368 */ "literal_list ::= signed_literal",
 /* 369 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 370 */ "db_name ::= NK_ID",
 /* 371 */ "table_name ::= NK_ID",
 /* 372 */ "column_name ::= NK_ID",
 /* 373 */ "function_name ::= NK_ID",
 /* 374 */ "table_alias ::= NK_ID",
 /* 375 */ "column_alias ::= NK_ID",
 /* 376 */ "user_name ::= NK_ID",
 /* 377 */ "topic_name ::= NK_ID",
 /* 378 */ "stream_name ::= NK_ID",
 /* 379 */ "cgroup_name ::= NK_ID",
 /* 380 */ "index_name ::= NK_ID",
 /* 381 */ "expr_or_subquery ::= expression",
 /* 382 */ "expression ::= literal",
 /* 383 */ "expression ::= pseudo_column",
 /* 384 */ "expression ::= column_reference",
 /* 385 */ "expression ::= function_expression",
 /* 386 */ "expression ::= case_when_expression",
 /* 387 */ "expression ::= NK_LP expression NK_RP",
 /* 388 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 389 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 390 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 391 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 392 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 393 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 394 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 395 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 396 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 397 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 398 */ "expression_list ::= expr_or_subquery",
 /* 399 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 400 */ "column_reference ::= column_name",
 /* 401 */ "column_reference ::= table_name NK_DOT column_name",
 /* 402 */ "pseudo_column ::= ROWTS",
 /* 403 */ "pseudo_column ::= TBNAME",
 /* 404 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 405 */ "pseudo_column ::= QSTART",
 /* 406 */ "pseudo_column ::= QEND",
 /* 407 */ "pseudo_column ::= QDURATION",
 /* 408 */ "pseudo_column ::= WSTART",
 /* 409 */ "pseudo_column ::= WEND",
 /* 410 */ "pseudo_column ::= WDURATION",
 /* 411 */ "pseudo_column ::= IROWTS",
 /* 412 */ "pseudo_column ::= ISFILLED",
 /* 413 */ "pseudo_column ::= QTAGS",
 /* 414 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 415 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 416 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 417 */ "function_expression ::= literal_func",
 /* 418 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 419 */ "literal_func ::= NOW",
 /* 420 */ "noarg_func ::= NOW",
 /* 421 */ "noarg_func ::= TODAY",
 /* 422 */ "noarg_func ::= TIMEZONE",
 /* 423 */ "noarg_func ::= DATABASE",
 /* 424 */ "noarg_func ::= CLIENT_VERSION",
 /* 425 */ "noarg_func ::= SERVER_VERSION",
 /* 426 */ "noarg_func ::= SERVER_STATUS",
 /* 427 */ "noarg_func ::= CURRENT_USER",
 /* 428 */ "noarg_func ::= USER",
 /* 429 */ "star_func ::= COUNT",
 /* 430 */ "star_func ::= FIRST",
 /* 431 */ "star_func ::= LAST",
 /* 432 */ "star_func ::= LAST_ROW",
 /* 433 */ "star_func_para_list ::= NK_STAR",
 /* 434 */ "star_func_para_list ::= other_para_list",
 /* 435 */ "other_para_list ::= star_func_para",
 /* 436 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 437 */ "star_func_para ::= expr_or_subquery",
 /* 438 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 439 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 440 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 441 */ "when_then_list ::= when_then_expr",
 /* 442 */ "when_then_list ::= when_then_list when_then_expr",
 /* 443 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 444 */ "case_when_else_opt ::=",
 /* 445 */ "case_when_else_opt ::= ELSE common_expression",
 /* 446 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 447 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 448 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 449 */ "predicate ::= expr_or_subquery IS NULL",
 /* 450 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 451 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 452 */ "compare_op ::= NK_LT",
 /* 453 */ "compare_op ::= NK_GT",
 /* 454 */ "compare_op ::= NK_LE",
 /* 455 */ "compare_op ::= NK_GE",
 /* 456 */ "compare_op ::= NK_NE",
 /* 457 */ "compare_op ::= NK_EQ",
 /* 458 */ "compare_op ::= LIKE",
 /* 459 */ "compare_op ::= NOT LIKE",
 /* 460 */ "compare_op ::= MATCH",
 /* 461 */ "compare_op ::= NMATCH",
 /* 462 */ "compare_op ::= CONTAINS",
 /* 463 */ "in_op ::= IN",
 /* 464 */ "in_op ::= NOT IN",
 /* 465 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 466 */ "boolean_value_expression ::= boolean_primary",
 /* 467 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 468 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 469 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 470 */ "boolean_primary ::= predicate",
 /* 471 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 472 */ "common_expression ::= expr_or_subquery",
 /* 473 */ "common_expression ::= boolean_value_expression",
 /* 474 */ "from_clause_opt ::=",
 /* 475 */ "from_clause_opt ::= FROM table_reference_list",
 /* 476 */ "table_reference_list ::= table_reference",
 /* 477 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 478 */ "table_reference ::= table_primary",
 /* 479 */ "table_reference ::= joined_table",
 /* 480 */ "table_primary ::= table_name alias_opt",
 /* 481 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 482 */ "table_primary ::= subquery alias_opt",
 /* 483 */ "table_primary ::= parenthesized_joined_table",
 /* 484 */ "alias_opt ::=",
 /* 485 */ "alias_opt ::= table_alias",
 /* 486 */ "alias_opt ::= AS table_alias",
 /* 487 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 488 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 489 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 490 */ "join_type ::=",
 /* 491 */ "join_type ::= INNER",
 /* 492 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 493 */ "set_quantifier_opt ::=",
 /* 494 */ "set_quantifier_opt ::= DISTINCT",
 /* 495 */ "set_quantifier_opt ::= ALL",
 /* 496 */ "select_list ::= select_item",
 /* 497 */ "select_list ::= select_list NK_COMMA select_item",
 /* 498 */ "select_item ::= NK_STAR",
 /* 499 */ "select_item ::= common_expression",
 /* 500 */ "select_item ::= common_expression column_alias",
 /* 501 */ "select_item ::= common_expression AS column_alias",
 /* 502 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 503 */ "where_clause_opt ::=",
 /* 504 */ "where_clause_opt ::= WHERE search_condition",
 /* 505 */ "partition_by_clause_opt ::=",
 /* 506 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 507 */ "partition_list ::= partition_item",
 /* 508 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 509 */ "partition_item ::= expr_or_subquery",
 /* 510 */ "partition_item ::= expr_or_subquery column_alias",
 /* 511 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 512 */ "twindow_clause_opt ::=",
 /* 513 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 514 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 515 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 516 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 517 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 518 */ "sliding_opt ::=",
 /* 519 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 520 */ "fill_opt ::=",
 /* 521 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 522 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 523 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP",
 /* 524 */ "fill_mode ::= NONE",
 /* 525 */ "fill_mode ::= PREV",
 /* 526 */ "fill_mode ::= NULL",
 /* 527 */ "fill_mode ::= NULL_F",
 /* 528 */ "fill_mode ::= LINEAR",
 /* 529 */ "fill_mode ::= NEXT",
 /* 530 */ "group_by_clause_opt ::=",
 /* 531 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 532 */ "group_by_list ::= expr_or_subquery",
 /* 533 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 534 */ "having_clause_opt ::=",
 /* 535 */ "having_clause_opt ::= HAVING search_condition",
 /* 536 */ "range_opt ::=",
 /* 537 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 538 */ "every_opt ::=",
 /* 539 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 540 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 541 */ "query_simple ::= query_specification",
 /* 542 */ "query_simple ::= union_query_expression",
 /* 543 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 544 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 545 */ "query_simple_or_subquery ::= query_simple",
 /* 546 */ "query_simple_or_subquery ::= subquery",
 /* 547 */ "query_or_subquery ::= query_expression",
 /* 548 */ "query_or_subquery ::= subquery",
 /* 549 */ "order_by_clause_opt ::=",
 /* 550 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 551 */ "slimit_clause_opt ::=",
 /* 552 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 553 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 554 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 555 */ "limit_clause_opt ::=",
 /* 556 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 557 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 558 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 559 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 560 */ "subquery ::= NK_LP subquery NK_RP",
 /* 561 */ "search_condition ::= common_expression",
 /* 562 */ "sort_specification_list ::= sort_specification",
 /* 563 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 564 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 565 */ "ordering_specification_opt ::=",
 /* 566 */ "ordering_specification_opt ::= ASC",
 /* 567 */ "ordering_specification_opt ::= DESC",
 /* 568 */ "null_ordering_opt ::=",
 /* 569 */ "null_ordering_opt ::= NULLS FIRST",
 /* 570 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 328: /* cmd */
    case 331: /* literal */
    case 344: /* db_options */
    case 346: /* alter_db_options */
    case 348: /* start_opt */
    case 349: /* end_opt */
    case 354: /* retention */
    case 355: /* full_table_name */
    case 358: /* table_options */
    case 362: /* alter_table_clause */
    case 363: /* alter_table_options */
    case 366: /* signed_literal */
    case 367: /* create_subtable_clause */
    case 370: /* drop_table_clause */
    case 373: /* column_def */
    case 377: /* duration_literal */
    case 378: /* rollup_func_name */
    case 380: /* col_name */
    case 381: /* db_name_cond_opt */
    case 382: /* like_pattern_opt */
    case 383: /* table_name_cond */
    case 384: /* from_db_opt */
    case 386: /* tag_item */
    case 388: /* full_index_name */
    case 389: /* index_options */
    case 392: /* sliding_opt */
    case 393: /* sma_stream_opt */
    case 394: /* func */
    case 396: /* query_or_subquery */
    case 399: /* explain_options */
    case 400: /* insert_query */
    case 404: /* stream_options */
    case 407: /* subtable_opt */
    case 408: /* expression */
    case 410: /* where_clause_opt */
    case 411: /* signed */
    case 412: /* literal_func */
    case 415: /* expr_or_subquery */
    case 416: /* pseudo_column */
    case 417: /* column_reference */
    case 418: /* function_expression */
    case 419: /* case_when_expression */
    case 424: /* star_func_para */
    case 426: /* case_when_else_opt */
    case 427: /* common_expression */
    case 428: /* when_then_expr */
    case 429: /* predicate */
    case 432: /* in_predicate_value */
    case 433: /* boolean_value_expression */
    case 434: /* boolean_primary */
    case 435: /* from_clause_opt */
    case 436: /* table_reference_list */
    case 437: /* table_reference */
    case 438: /* table_primary */
    case 439: /* joined_table */
    case 441: /* subquery */
    case 442: /* parenthesized_joined_table */
    case 444: /* search_condition */
    case 445: /* query_specification */
    case 449: /* range_opt */
    case 450: /* every_opt */
    case 451: /* fill_opt */
    case 452: /* twindow_clause_opt */
    case 454: /* having_clause_opt */
    case 455: /* select_item */
    case 457: /* partition_item */
    case 460: /* query_expression */
    case 461: /* query_simple */
    case 463: /* slimit_clause_opt */
    case 464: /* limit_clause_opt */
    case 465: /* union_query_expression */
    case 466: /* query_simple_or_subquery */
    case 468: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy140)); 
}
      break;
    case 329: /* account_options */
    case 330: /* alter_account_options */
    case 332: /* alter_account_option */
    case 347: /* speed_opt */
    case 402: /* bufsize_opt */
{
 
}
      break;
    case 333: /* user_name */
    case 336: /* priv_level */
    case 339: /* db_name */
    case 340: /* topic_name */
    case 341: /* dnode_endpoint */
    case 364: /* column_name */
    case 372: /* table_name */
    case 379: /* function_name */
    case 387: /* column_alias */
    case 390: /* index_name */
    case 395: /* sma_func_name */
    case 397: /* cgroup_name */
    case 403: /* stream_name */
    case 414: /* table_alias */
    case 420: /* star_func */
    case 422: /* noarg_func */
    case 440: /* alias_opt */
{
 
}
      break;
    case 334: /* sysinfo_opt */
{
 
}
      break;
    case 335: /* privileges */
    case 337: /* priv_type_list */
    case 338: /* priv_type */
{
 
}
      break;
    case 342: /* force_opt */
    case 343: /* not_exists_opt */
    case 345: /* exists_opt */
    case 398: /* analyze_opt */
    case 401: /* agg_func_opt */
    case 446: /* set_quantifier_opt */
{
 
}
      break;
    case 350: /* integer_list */
    case 351: /* variable_list */
    case 352: /* retention_list */
    case 356: /* column_def_list */
    case 357: /* tags_def_opt */
    case 359: /* multi_create_clause */
    case 360: /* tags_def */
    case 361: /* multi_drop_clause */
    case 368: /* specific_cols_opt */
    case 369: /* expression_list */
    case 371: /* col_name_list */
    case 374: /* duration_list */
    case 375: /* rollup_func_list */
    case 385: /* tag_list_opt */
    case 391: /* func_list */
    case 405: /* col_list_opt */
    case 406: /* tag_def_or_ref_opt */
    case 409: /* dnode_list */
    case 413: /* literal_list */
    case 421: /* star_func_para_list */
    case 423: /* other_para_list */
    case 425: /* when_then_list */
    case 447: /* select_list */
    case 448: /* partition_by_clause_opt */
    case 453: /* group_by_clause_opt */
    case 456: /* partition_list */
    case 459: /* group_by_list */
    case 462: /* order_by_clause_opt */
    case 467: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy220)); 
}
      break;
    case 353: /* alter_db_option */
    case 376: /* alter_table_option */
{
 
}
      break;
    case 365: /* type_name */
{
 
}
      break;
    case 430: /* compare_op */
    case 431: /* in_op */
{
 
}
      break;
    case 443: /* join_type */
{
 
}
      break;
    case 458: /* fill_mode */
{
 
}
      break;
    case 469: /* ordering_specification_opt */
{
 
}
      break;
    case 470: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  328,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  328,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  329,    0 }, /* (2) account_options ::= */
  {  329,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  329,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  329,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  329,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  329,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  329,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  329,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  329,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  329,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  330,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  330,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  332,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  332,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  332,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  332,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  332,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  332,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  332,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  332,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  332,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  332,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  328,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  328,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  328,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  328,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  328,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  334,    0 }, /* (29) sysinfo_opt ::= */
  {  334,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  328,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  328,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  335,   -1 }, /* (33) privileges ::= ALL */
  {  335,   -1 }, /* (34) privileges ::= priv_type_list */
  {  335,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  337,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  337,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  338,   -1 }, /* (38) priv_type ::= READ */
  {  338,   -1 }, /* (39) priv_type ::= WRITE */
  {  336,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  336,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  336,   -1 }, /* (42) priv_level ::= topic_name */
  {  328,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  328,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  328,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  328,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  328,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  328,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  328,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  328,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  341,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  341,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  341,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  342,    0 }, /* (54) force_opt ::= */
  {  342,   -1 }, /* (55) force_opt ::= FORCE */
  {  328,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  328,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  328,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  328,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  328,   -2 }, /* (68) cmd ::= USE db_name */
  {  328,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  328,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  328,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  328,   -5 }, /* (72) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
  {  343,   -3 }, /* (73) not_exists_opt ::= IF NOT EXISTS */
  {  343,    0 }, /* (74) not_exists_opt ::= */
  {  345,   -2 }, /* (75) exists_opt ::= IF EXISTS */
  {  345,    0 }, /* (76) exists_opt ::= */
  {  344,    0 }, /* (77) db_options ::= */
  {  344,   -3 }, /* (78) db_options ::= db_options BUFFER NK_INTEGER */
  {  344,   -3 }, /* (79) db_options ::= db_options CACHEMODEL NK_STRING */
  {  344,   -3 }, /* (80) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  344,   -3 }, /* (81) db_options ::= db_options COMP NK_INTEGER */
  {  344,   -3 }, /* (82) db_options ::= db_options DURATION NK_INTEGER */
  {  344,   -3 }, /* (83) db_options ::= db_options DURATION NK_VARIABLE */
  {  344,   -3 }, /* (84) db_options ::= db_options MAXROWS NK_INTEGER */
  {  344,   -3 }, /* (85) db_options ::= db_options MINROWS NK_INTEGER */
  {  344,   -3 }, /* (86) db_options ::= db_options KEEP integer_list */
  {  344,   -3 }, /* (87) db_options ::= db_options KEEP variable_list */
  {  344,   -3 }, /* (88) db_options ::= db_options PAGES NK_INTEGER */
  {  344,   -3 }, /* (89) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  344,   -3 }, /* (90) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  344,   -3 }, /* (91) db_options ::= db_options PRECISION NK_STRING */
  {  344,   -3 }, /* (92) db_options ::= db_options REPLICA NK_INTEGER */
  {  344,   -3 }, /* (93) db_options ::= db_options VGROUPS NK_INTEGER */
  {  344,   -3 }, /* (94) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  344,   -3 }, /* (95) db_options ::= db_options RETENTIONS retention_list */
  {  344,   -3 }, /* (96) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  344,   -3 }, /* (97) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  344,   -3 }, /* (98) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  344,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  344,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  344,   -3 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  344,   -4 }, /* (102) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  344,   -3 }, /* (103) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  344,   -3 }, /* (104) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  344,   -3 }, /* (105) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  344,   -3 }, /* (106) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  344,   -3 }, /* (107) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  346,   -1 }, /* (108) alter_db_options ::= alter_db_option */
  {  346,   -2 }, /* (109) alter_db_options ::= alter_db_options alter_db_option */
  {  353,   -2 }, /* (110) alter_db_option ::= BUFFER NK_INTEGER */
  {  353,   -2 }, /* (111) alter_db_option ::= CACHEMODEL NK_STRING */
  {  353,   -2 }, /* (112) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  353,   -2 }, /* (113) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  353,   -2 }, /* (114) alter_db_option ::= KEEP integer_list */
  {  353,   -2 }, /* (115) alter_db_option ::= KEEP variable_list */
  {  353,   -2 }, /* (116) alter_db_option ::= PAGES NK_INTEGER */
  {  353,   -2 }, /* (117) alter_db_option ::= REPLICA NK_INTEGER */
  {  353,   -2 }, /* (118) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  353,   -2 }, /* (119) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  353,   -2 }, /* (120) alter_db_option ::= MINROWS NK_INTEGER */
  {  350,   -1 }, /* (121) integer_list ::= NK_INTEGER */
  {  350,   -3 }, /* (122) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  351,   -1 }, /* (123) variable_list ::= NK_VARIABLE */
  {  351,   -3 }, /* (124) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  352,   -1 }, /* (125) retention_list ::= retention */
  {  352,   -3 }, /* (126) retention_list ::= retention_list NK_COMMA retention */
  {  354,   -3 }, /* (127) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  347,    0 }, /* (128) speed_opt ::= */
  {  347,   -2 }, /* (129) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  348,    0 }, /* (130) start_opt ::= */
  {  348,   -3 }, /* (131) start_opt ::= START WITH NK_INTEGER */
  {  348,   -3 }, /* (132) start_opt ::= START WITH NK_STRING */
  {  348,   -4 }, /* (133) start_opt ::= START WITH TIMESTAMP NK_STRING */
  {  349,    0 }, /* (134) end_opt ::= */
  {  349,   -3 }, /* (135) end_opt ::= END WITH NK_INTEGER */
  {  349,   -3 }, /* (136) end_opt ::= END WITH NK_STRING */
  {  349,   -4 }, /* (137) end_opt ::= END WITH TIMESTAMP NK_STRING */
  {  328,   -9 }, /* (138) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  328,   -3 }, /* (139) cmd ::= CREATE TABLE multi_create_clause */
  {  328,   -9 }, /* (140) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  328,   -3 }, /* (141) cmd ::= DROP TABLE multi_drop_clause */
  {  328,   -4 }, /* (142) cmd ::= DROP STABLE exists_opt full_table_name */
  {  328,   -3 }, /* (143) cmd ::= ALTER TABLE alter_table_clause */
  {  328,   -3 }, /* (144) cmd ::= ALTER STABLE alter_table_clause */
  {  362,   -2 }, /* (145) alter_table_clause ::= full_table_name alter_table_options */
  {  362,   -5 }, /* (146) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  362,   -4 }, /* (147) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  362,   -5 }, /* (148) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  362,   -5 }, /* (149) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  362,   -5 }, /* (150) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  362,   -4 }, /* (151) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  362,   -5 }, /* (152) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  362,   -5 }, /* (153) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  362,   -6 }, /* (154) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  359,   -1 }, /* (155) multi_create_clause ::= create_subtable_clause */
  {  359,   -2 }, /* (156) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  367,  -10 }, /* (157) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  361,   -1 }, /* (158) multi_drop_clause ::= drop_table_clause */
  {  361,   -3 }, /* (159) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
  {  370,   -2 }, /* (160) drop_table_clause ::= exists_opt full_table_name */
  {  368,    0 }, /* (161) specific_cols_opt ::= */
  {  368,   -3 }, /* (162) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  355,   -1 }, /* (163) full_table_name ::= table_name */
  {  355,   -3 }, /* (164) full_table_name ::= db_name NK_DOT table_name */
  {  356,   -1 }, /* (165) column_def_list ::= column_def */
  {  356,   -3 }, /* (166) column_def_list ::= column_def_list NK_COMMA column_def */
  {  373,   -2 }, /* (167) column_def ::= column_name type_name */
  {  365,   -1 }, /* (168) type_name ::= BOOL */
  {  365,   -1 }, /* (169) type_name ::= TINYINT */
  {  365,   -1 }, /* (170) type_name ::= SMALLINT */
  {  365,   -1 }, /* (171) type_name ::= INT */
  {  365,   -1 }, /* (172) type_name ::= INTEGER */
  {  365,   -1 }, /* (173) type_name ::= BIGINT */
  {  365,   -1 }, /* (174) type_name ::= FLOAT */
  {  365,   -1 }, /* (175) type_name ::= DOUBLE */
  {  365,   -4 }, /* (176) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  365,   -1 }, /* (177) type_name ::= TIMESTAMP */
  {  365,   -4 }, /* (178) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  365,   -2 }, /* (179) type_name ::= TINYINT UNSIGNED */
  {  365,   -2 }, /* (180) type_name ::= SMALLINT UNSIGNED */
  {  365,   -2 }, /* (181) type_name ::= INT UNSIGNED */
  {  365,   -2 }, /* (182) type_name ::= BIGINT UNSIGNED */
  {  365,   -1 }, /* (183) type_name ::= JSON */
  {  365,   -4 }, /* (184) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  365,   -1 }, /* (185) type_name ::= MEDIUMBLOB */
  {  365,   -1 }, /* (186) type_name ::= BLOB */
  {  365,   -4 }, /* (187) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  365,   -1 }, /* (188) type_name ::= DECIMAL */
  {  365,   -4 }, /* (189) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  365,   -6 }, /* (190) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  357,    0 }, /* (191) tags_def_opt ::= */
  {  357,   -1 }, /* (192) tags_def_opt ::= tags_def */
  {  360,   -4 }, /* (193) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  358,    0 }, /* (194) table_options ::= */
  {  358,   -3 }, /* (195) table_options ::= table_options COMMENT NK_STRING */
  {  358,   -3 }, /* (196) table_options ::= table_options MAX_DELAY duration_list */
  {  358,   -3 }, /* (197) table_options ::= table_options WATERMARK duration_list */
  {  358,   -5 }, /* (198) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  358,   -3 }, /* (199) table_options ::= table_options TTL NK_INTEGER */
  {  358,   -5 }, /* (200) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  358,   -3 }, /* (201) table_options ::= table_options DELETE_MARK duration_list */
  {  363,   -1 }, /* (202) alter_table_options ::= alter_table_option */
  {  363,   -2 }, /* (203) alter_table_options ::= alter_table_options alter_table_option */
  {  376,   -2 }, /* (204) alter_table_option ::= COMMENT NK_STRING */
  {  376,   -2 }, /* (205) alter_table_option ::= TTL NK_INTEGER */
  {  374,   -1 }, /* (206) duration_list ::= duration_literal */
  {  374,   -3 }, /* (207) duration_list ::= duration_list NK_COMMA duration_literal */
  {  375,   -1 }, /* (208) rollup_func_list ::= rollup_func_name */
  {  375,   -3 }, /* (209) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  378,   -1 }, /* (210) rollup_func_name ::= function_name */
  {  378,   -1 }, /* (211) rollup_func_name ::= FIRST */
  {  378,   -1 }, /* (212) rollup_func_name ::= LAST */
  {  371,   -1 }, /* (213) col_name_list ::= col_name */
  {  371,   -3 }, /* (214) col_name_list ::= col_name_list NK_COMMA col_name */
  {  380,   -1 }, /* (215) col_name ::= column_name */
  {  328,   -2 }, /* (216) cmd ::= SHOW DNODES */
  {  328,   -2 }, /* (217) cmd ::= SHOW USERS */
  {  328,   -3 }, /* (218) cmd ::= SHOW USER PRIVILEGES */
  {  328,   -2 }, /* (219) cmd ::= SHOW DATABASES */
  {  328,   -4 }, /* (220) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  328,   -4 }, /* (221) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  328,   -3 }, /* (222) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  328,   -2 }, /* (223) cmd ::= SHOW MNODES */
  {  328,   -2 }, /* (224) cmd ::= SHOW QNODES */
  {  328,   -2 }, /* (225) cmd ::= SHOW FUNCTIONS */
  {  328,   -5 }, /* (226) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  328,   -2 }, /* (227) cmd ::= SHOW STREAMS */
  {  328,   -2 }, /* (228) cmd ::= SHOW ACCOUNTS */
  {  328,   -2 }, /* (229) cmd ::= SHOW APPS */
  {  328,   -2 }, /* (230) cmd ::= SHOW CONNECTIONS */
  {  328,   -2 }, /* (231) cmd ::= SHOW LICENCES */
  {  328,   -2 }, /* (232) cmd ::= SHOW GRANTS */
  {  328,   -4 }, /* (233) cmd ::= SHOW CREATE DATABASE db_name */
  {  328,   -4 }, /* (234) cmd ::= SHOW CREATE TABLE full_table_name */
  {  328,   -4 }, /* (235) cmd ::= SHOW CREATE STABLE full_table_name */
  {  328,   -2 }, /* (236) cmd ::= SHOW QUERIES */
  {  328,   -2 }, /* (237) cmd ::= SHOW SCORES */
  {  328,   -2 }, /* (238) cmd ::= SHOW TOPICS */
  {  328,   -2 }, /* (239) cmd ::= SHOW VARIABLES */
  {  328,   -3 }, /* (240) cmd ::= SHOW CLUSTER VARIABLES */
  {  328,   -3 }, /* (241) cmd ::= SHOW LOCAL VARIABLES */
  {  328,   -5 }, /* (242) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  328,   -2 }, /* (243) cmd ::= SHOW BNODES */
  {  328,   -2 }, /* (244) cmd ::= SHOW SNODES */
  {  328,   -2 }, /* (245) cmd ::= SHOW CLUSTER */
  {  328,   -2 }, /* (246) cmd ::= SHOW TRANSACTIONS */
  {  328,   -4 }, /* (247) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  328,   -2 }, /* (248) cmd ::= SHOW CONSUMERS */
  {  328,   -2 }, /* (249) cmd ::= SHOW SUBSCRIPTIONS */
  {  328,   -5 }, /* (250) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  328,   -7 }, /* (251) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  328,   -3 }, /* (252) cmd ::= SHOW VNODES NK_INTEGER */
  {  328,   -3 }, /* (253) cmd ::= SHOW VNODES NK_STRING */
  {  328,   -3 }, /* (254) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  328,   -3 }, /* (255) cmd ::= SHOW CLUSTER ALIVE */
  {  381,    0 }, /* (256) db_name_cond_opt ::= */
  {  381,   -2 }, /* (257) db_name_cond_opt ::= db_name NK_DOT */
  {  382,    0 }, /* (258) like_pattern_opt ::= */
  {  382,   -2 }, /* (259) like_pattern_opt ::= LIKE NK_STRING */
  {  383,   -1 }, /* (260) table_name_cond ::= table_name */
  {  384,    0 }, /* (261) from_db_opt ::= */
  {  384,   -2 }, /* (262) from_db_opt ::= FROM db_name */
  {  385,    0 }, /* (263) tag_list_opt ::= */
  {  385,   -1 }, /* (264) tag_list_opt ::= tag_item */
  {  385,   -3 }, /* (265) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  386,   -1 }, /* (266) tag_item ::= TBNAME */
  {  386,   -1 }, /* (267) tag_item ::= QTAGS */
  {  386,   -1 }, /* (268) tag_item ::= column_name */
  {  386,   -2 }, /* (269) tag_item ::= column_name column_alias */
  {  386,   -3 }, /* (270) tag_item ::= column_name AS column_alias */
  {  328,   -8 }, /* (271) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  328,   -9 }, /* (272) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  328,   -4 }, /* (273) cmd ::= DROP INDEX exists_opt full_index_name */
  {  388,   -1 }, /* (274) full_index_name ::= index_name */
  {  388,   -3 }, /* (275) full_index_name ::= db_name NK_DOT index_name */
  {  389,  -10 }, /* (276) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  389,  -12 }, /* (277) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  391,   -1 }, /* (278) func_list ::= func */
  {  391,   -3 }, /* (279) func_list ::= func_list NK_COMMA func */
  {  394,   -4 }, /* (280) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  395,   -1 }, /* (281) sma_func_name ::= function_name */
  {  395,   -1 }, /* (282) sma_func_name ::= COUNT */
  {  395,   -1 }, /* (283) sma_func_name ::= FIRST */
  {  395,   -1 }, /* (284) sma_func_name ::= LAST */
  {  395,   -1 }, /* (285) sma_func_name ::= LAST_ROW */
  {  393,    0 }, /* (286) sma_stream_opt ::= */
  {  393,   -3 }, /* (287) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  393,   -3 }, /* (288) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  393,   -3 }, /* (289) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  328,   -6 }, /* (290) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  328,   -7 }, /* (291) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  328,   -9 }, /* (292) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  328,   -7 }, /* (293) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  328,   -9 }, /* (294) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  328,   -4 }, /* (295) cmd ::= DROP TOPIC exists_opt topic_name */
  {  328,   -7 }, /* (296) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  328,   -2 }, /* (297) cmd ::= DESC full_table_name */
  {  328,   -2 }, /* (298) cmd ::= DESCRIBE full_table_name */
  {  328,   -3 }, /* (299) cmd ::= RESET QUERY CACHE */
  {  328,   -4 }, /* (300) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  328,   -4 }, /* (301) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
  {  398,    0 }, /* (302) analyze_opt ::= */
  {  398,   -1 }, /* (303) analyze_opt ::= ANALYZE */
  {  399,    0 }, /* (304) explain_options ::= */
  {  399,   -3 }, /* (305) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  399,   -3 }, /* (306) explain_options ::= explain_options RATIO NK_FLOAT */
  {  328,  -10 }, /* (307) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  328,   -4 }, /* (308) cmd ::= DROP FUNCTION exists_opt function_name */
  {  401,    0 }, /* (309) agg_func_opt ::= */
  {  401,   -1 }, /* (310) agg_func_opt ::= AGGREGATE */
  {  402,    0 }, /* (311) bufsize_opt ::= */
  {  402,   -2 }, /* (312) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  328,  -12 }, /* (313) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  328,   -4 }, /* (314) cmd ::= DROP STREAM exists_opt stream_name */
  {  405,    0 }, /* (315) col_list_opt ::= */
  {  405,   -3 }, /* (316) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  406,    0 }, /* (317) tag_def_or_ref_opt ::= */
  {  406,   -1 }, /* (318) tag_def_or_ref_opt ::= tags_def */
  {  406,   -4 }, /* (319) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  404,    0 }, /* (320) stream_options ::= */
  {  404,   -3 }, /* (321) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  404,   -3 }, /* (322) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  404,   -4 }, /* (323) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  404,   -3 }, /* (324) stream_options ::= stream_options WATERMARK duration_literal */
  {  404,   -4 }, /* (325) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  404,   -3 }, /* (326) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  404,   -3 }, /* (327) stream_options ::= stream_options DELETE_MARK duration_literal */
  {  404,   -4 }, /* (328) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
  {  407,    0 }, /* (329) subtable_opt ::= */
  {  407,   -4 }, /* (330) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  328,   -3 }, /* (331) cmd ::= KILL CONNECTION NK_INTEGER */
  {  328,   -3 }, /* (332) cmd ::= KILL QUERY NK_STRING */
  {  328,   -3 }, /* (333) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  328,   -2 }, /* (334) cmd ::= BALANCE VGROUP */
  {  328,   -4 }, /* (335) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  328,   -4 }, /* (336) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  328,   -3 }, /* (337) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  409,   -2 }, /* (338) dnode_list ::= DNODE NK_INTEGER */
  {  409,   -3 }, /* (339) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  328,   -4 }, /* (340) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  328,   -1 }, /* (341) cmd ::= query_or_subquery */
  {  328,   -1 }, /* (342) cmd ::= insert_query */
  {  400,   -7 }, /* (343) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  400,   -4 }, /* (344) insert_query ::= INSERT INTO full_table_name query_or_subquery */
  {  331,   -1 }, /* (345) literal ::= NK_INTEGER */
  {  331,   -1 }, /* (346) literal ::= NK_FLOAT */
  {  331,   -1 }, /* (347) literal ::= NK_STRING */
  {  331,   -1 }, /* (348) literal ::= NK_BOOL */
  {  331,   -2 }, /* (349) literal ::= TIMESTAMP NK_STRING */
  {  331,   -1 }, /* (350) literal ::= duration_literal */
  {  331,   -1 }, /* (351) literal ::= NULL */
  {  331,   -1 }, /* (352) literal ::= NK_QUESTION */
  {  377,   -1 }, /* (353) duration_literal ::= NK_VARIABLE */
  {  411,   -1 }, /* (354) signed ::= NK_INTEGER */
  {  411,   -2 }, /* (355) signed ::= NK_PLUS NK_INTEGER */
  {  411,   -2 }, /* (356) signed ::= NK_MINUS NK_INTEGER */
  {  411,   -1 }, /* (357) signed ::= NK_FLOAT */
  {  411,   -2 }, /* (358) signed ::= NK_PLUS NK_FLOAT */
  {  411,   -2 }, /* (359) signed ::= NK_MINUS NK_FLOAT */
  {  366,   -1 }, /* (360) signed_literal ::= signed */
  {  366,   -1 }, /* (361) signed_literal ::= NK_STRING */
  {  366,   -1 }, /* (362) signed_literal ::= NK_BOOL */
  {  366,   -2 }, /* (363) signed_literal ::= TIMESTAMP NK_STRING */
  {  366,   -1 }, /* (364) signed_literal ::= duration_literal */
  {  366,   -1 }, /* (365) signed_literal ::= NULL */
  {  366,   -1 }, /* (366) signed_literal ::= literal_func */
  {  366,   -1 }, /* (367) signed_literal ::= NK_QUESTION */
  {  413,   -1 }, /* (368) literal_list ::= signed_literal */
  {  413,   -3 }, /* (369) literal_list ::= literal_list NK_COMMA signed_literal */
  {  339,   -1 }, /* (370) db_name ::= NK_ID */
  {  372,   -1 }, /* (371) table_name ::= NK_ID */
  {  364,   -1 }, /* (372) column_name ::= NK_ID */
  {  379,   -1 }, /* (373) function_name ::= NK_ID */
  {  414,   -1 }, /* (374) table_alias ::= NK_ID */
  {  387,   -1 }, /* (375) column_alias ::= NK_ID */
  {  333,   -1 }, /* (376) user_name ::= NK_ID */
  {  340,   -1 }, /* (377) topic_name ::= NK_ID */
  {  403,   -1 }, /* (378) stream_name ::= NK_ID */
  {  397,   -1 }, /* (379) cgroup_name ::= NK_ID */
  {  390,   -1 }, /* (380) index_name ::= NK_ID */
  {  415,   -1 }, /* (381) expr_or_subquery ::= expression */
  {  408,   -1 }, /* (382) expression ::= literal */
  {  408,   -1 }, /* (383) expression ::= pseudo_column */
  {  408,   -1 }, /* (384) expression ::= column_reference */
  {  408,   -1 }, /* (385) expression ::= function_expression */
  {  408,   -1 }, /* (386) expression ::= case_when_expression */
  {  408,   -3 }, /* (387) expression ::= NK_LP expression NK_RP */
  {  408,   -2 }, /* (388) expression ::= NK_PLUS expr_or_subquery */
  {  408,   -2 }, /* (389) expression ::= NK_MINUS expr_or_subquery */
  {  408,   -3 }, /* (390) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  408,   -3 }, /* (391) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  408,   -3 }, /* (392) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  408,   -3 }, /* (393) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  408,   -3 }, /* (394) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  408,   -3 }, /* (395) expression ::= column_reference NK_ARROW NK_STRING */
  {  408,   -3 }, /* (396) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  408,   -3 }, /* (397) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  369,   -1 }, /* (398) expression_list ::= expr_or_subquery */
  {  369,   -3 }, /* (399) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  417,   -1 }, /* (400) column_reference ::= column_name */
  {  417,   -3 }, /* (401) column_reference ::= table_name NK_DOT column_name */
  {  416,   -1 }, /* (402) pseudo_column ::= ROWTS */
  {  416,   -1 }, /* (403) pseudo_column ::= TBNAME */
  {  416,   -3 }, /* (404) pseudo_column ::= table_name NK_DOT TBNAME */
  {  416,   -1 }, /* (405) pseudo_column ::= QSTART */
  {  416,   -1 }, /* (406) pseudo_column ::= QEND */
  {  416,   -1 }, /* (407) pseudo_column ::= QDURATION */
  {  416,   -1 }, /* (408) pseudo_column ::= WSTART */
  {  416,   -1 }, /* (409) pseudo_column ::= WEND */
  {  416,   -1 }, /* (410) pseudo_column ::= WDURATION */
  {  416,   -1 }, /* (411) pseudo_column ::= IROWTS */
  {  416,   -1 }, /* (412) pseudo_column ::= ISFILLED */
  {  416,   -1 }, /* (413) pseudo_column ::= QTAGS */
  {  418,   -4 }, /* (414) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  418,   -4 }, /* (415) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  418,   -6 }, /* (416) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  418,   -1 }, /* (417) function_expression ::= literal_func */
  {  412,   -3 }, /* (418) literal_func ::= noarg_func NK_LP NK_RP */
  {  412,   -1 }, /* (419) literal_func ::= NOW */
  {  422,   -1 }, /* (420) noarg_func ::= NOW */
  {  422,   -1 }, /* (421) noarg_func ::= TODAY */
  {  422,   -1 }, /* (422) noarg_func ::= TIMEZONE */
  {  422,   -1 }, /* (423) noarg_func ::= DATABASE */
  {  422,   -1 }, /* (424) noarg_func ::= CLIENT_VERSION */
  {  422,   -1 }, /* (425) noarg_func ::= SERVER_VERSION */
  {  422,   -1 }, /* (426) noarg_func ::= SERVER_STATUS */
  {  422,   -1 }, /* (427) noarg_func ::= CURRENT_USER */
  {  422,   -1 }, /* (428) noarg_func ::= USER */
  {  420,   -1 }, /* (429) star_func ::= COUNT */
  {  420,   -1 }, /* (430) star_func ::= FIRST */
  {  420,   -1 }, /* (431) star_func ::= LAST */
  {  420,   -1 }, /* (432) star_func ::= LAST_ROW */
  {  421,   -1 }, /* (433) star_func_para_list ::= NK_STAR */
  {  421,   -1 }, /* (434) star_func_para_list ::= other_para_list */
  {  423,   -1 }, /* (435) other_para_list ::= star_func_para */
  {  423,   -3 }, /* (436) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  424,   -1 }, /* (437) star_func_para ::= expr_or_subquery */
  {  424,   -3 }, /* (438) star_func_para ::= table_name NK_DOT NK_STAR */
  {  419,   -4 }, /* (439) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  419,   -5 }, /* (440) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  425,   -1 }, /* (441) when_then_list ::= when_then_expr */
  {  425,   -2 }, /* (442) when_then_list ::= when_then_list when_then_expr */
  {  428,   -4 }, /* (443) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  426,    0 }, /* (444) case_when_else_opt ::= */
  {  426,   -2 }, /* (445) case_when_else_opt ::= ELSE common_expression */
  {  429,   -3 }, /* (446) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  429,   -5 }, /* (447) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  429,   -6 }, /* (448) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  429,   -3 }, /* (449) predicate ::= expr_or_subquery IS NULL */
  {  429,   -4 }, /* (450) predicate ::= expr_or_subquery IS NOT NULL */
  {  429,   -3 }, /* (451) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  430,   -1 }, /* (452) compare_op ::= NK_LT */
  {  430,   -1 }, /* (453) compare_op ::= NK_GT */
  {  430,   -1 }, /* (454) compare_op ::= NK_LE */
  {  430,   -1 }, /* (455) compare_op ::= NK_GE */
  {  430,   -1 }, /* (456) compare_op ::= NK_NE */
  {  430,   -1 }, /* (457) compare_op ::= NK_EQ */
  {  430,   -1 }, /* (458) compare_op ::= LIKE */
  {  430,   -2 }, /* (459) compare_op ::= NOT LIKE */
  {  430,   -1 }, /* (460) compare_op ::= MATCH */
  {  430,   -1 }, /* (461) compare_op ::= NMATCH */
  {  430,   -1 }, /* (462) compare_op ::= CONTAINS */
  {  431,   -1 }, /* (463) in_op ::= IN */
  {  431,   -2 }, /* (464) in_op ::= NOT IN */
  {  432,   -3 }, /* (465) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  433,   -1 }, /* (466) boolean_value_expression ::= boolean_primary */
  {  433,   -2 }, /* (467) boolean_value_expression ::= NOT boolean_primary */
  {  433,   -3 }, /* (468) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  433,   -3 }, /* (469) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  434,   -1 }, /* (470) boolean_primary ::= predicate */
  {  434,   -3 }, /* (471) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  427,   -1 }, /* (472) common_expression ::= expr_or_subquery */
  {  427,   -1 }, /* (473) common_expression ::= boolean_value_expression */
  {  435,    0 }, /* (474) from_clause_opt ::= */
  {  435,   -2 }, /* (475) from_clause_opt ::= FROM table_reference_list */
  {  436,   -1 }, /* (476) table_reference_list ::= table_reference */
  {  436,   -3 }, /* (477) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  437,   -1 }, /* (478) table_reference ::= table_primary */
  {  437,   -1 }, /* (479) table_reference ::= joined_table */
  {  438,   -2 }, /* (480) table_primary ::= table_name alias_opt */
  {  438,   -4 }, /* (481) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  438,   -2 }, /* (482) table_primary ::= subquery alias_opt */
  {  438,   -1 }, /* (483) table_primary ::= parenthesized_joined_table */
  {  440,    0 }, /* (484) alias_opt ::= */
  {  440,   -1 }, /* (485) alias_opt ::= table_alias */
  {  440,   -2 }, /* (486) alias_opt ::= AS table_alias */
  {  442,   -3 }, /* (487) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  442,   -3 }, /* (488) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  439,   -6 }, /* (489) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  443,    0 }, /* (490) join_type ::= */
  {  443,   -1 }, /* (491) join_type ::= INNER */
  {  445,  -12 }, /* (492) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  446,    0 }, /* (493) set_quantifier_opt ::= */
  {  446,   -1 }, /* (494) set_quantifier_opt ::= DISTINCT */
  {  446,   -1 }, /* (495) set_quantifier_opt ::= ALL */
  {  447,   -1 }, /* (496) select_list ::= select_item */
  {  447,   -3 }, /* (497) select_list ::= select_list NK_COMMA select_item */
  {  455,   -1 }, /* (498) select_item ::= NK_STAR */
  {  455,   -1 }, /* (499) select_item ::= common_expression */
  {  455,   -2 }, /* (500) select_item ::= common_expression column_alias */
  {  455,   -3 }, /* (501) select_item ::= common_expression AS column_alias */
  {  455,   -3 }, /* (502) select_item ::= table_name NK_DOT NK_STAR */
  {  410,    0 }, /* (503) where_clause_opt ::= */
  {  410,   -2 }, /* (504) where_clause_opt ::= WHERE search_condition */
  {  448,    0 }, /* (505) partition_by_clause_opt ::= */
  {  448,   -3 }, /* (506) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  456,   -1 }, /* (507) partition_list ::= partition_item */
  {  456,   -3 }, /* (508) partition_list ::= partition_list NK_COMMA partition_item */
  {  457,   -1 }, /* (509) partition_item ::= expr_or_subquery */
  {  457,   -2 }, /* (510) partition_item ::= expr_or_subquery column_alias */
  {  457,   -3 }, /* (511) partition_item ::= expr_or_subquery AS column_alias */
  {  452,    0 }, /* (512) twindow_clause_opt ::= */
  {  452,   -6 }, /* (513) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  452,   -4 }, /* (514) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  452,   -6 }, /* (515) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  452,   -8 }, /* (516) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  452,   -7 }, /* (517) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  392,    0 }, /* (518) sliding_opt ::= */
  {  392,   -4 }, /* (519) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  451,    0 }, /* (520) fill_opt ::= */
  {  451,   -4 }, /* (521) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  451,   -6 }, /* (522) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  451,   -6 }, /* (523) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
  {  458,   -1 }, /* (524) fill_mode ::= NONE */
  {  458,   -1 }, /* (525) fill_mode ::= PREV */
  {  458,   -1 }, /* (526) fill_mode ::= NULL */
  {  458,   -1 }, /* (527) fill_mode ::= NULL_F */
  {  458,   -1 }, /* (528) fill_mode ::= LINEAR */
  {  458,   -1 }, /* (529) fill_mode ::= NEXT */
  {  453,    0 }, /* (530) group_by_clause_opt ::= */
  {  453,   -3 }, /* (531) group_by_clause_opt ::= GROUP BY group_by_list */
  {  459,   -1 }, /* (532) group_by_list ::= expr_or_subquery */
  {  459,   -3 }, /* (533) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  454,    0 }, /* (534) having_clause_opt ::= */
  {  454,   -2 }, /* (535) having_clause_opt ::= HAVING search_condition */
  {  449,    0 }, /* (536) range_opt ::= */
  {  449,   -6 }, /* (537) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  450,    0 }, /* (538) every_opt ::= */
  {  450,   -4 }, /* (539) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  460,   -4 }, /* (540) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  461,   -1 }, /* (541) query_simple ::= query_specification */
  {  461,   -1 }, /* (542) query_simple ::= union_query_expression */
  {  465,   -4 }, /* (543) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  465,   -3 }, /* (544) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  466,   -1 }, /* (545) query_simple_or_subquery ::= query_simple */
  {  466,   -1 }, /* (546) query_simple_or_subquery ::= subquery */
  {  396,   -1 }, /* (547) query_or_subquery ::= query_expression */
  {  396,   -1 }, /* (548) query_or_subquery ::= subquery */
  {  462,    0 }, /* (549) order_by_clause_opt ::= */
  {  462,   -3 }, /* (550) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  463,    0 }, /* (551) slimit_clause_opt ::= */
  {  463,   -2 }, /* (552) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  463,   -4 }, /* (553) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  463,   -4 }, /* (554) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  464,    0 }, /* (555) limit_clause_opt ::= */
  {  464,   -2 }, /* (556) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  464,   -4 }, /* (557) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  464,   -4 }, /* (558) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  441,   -3 }, /* (559) subquery ::= NK_LP query_expression NK_RP */
  {  441,   -3 }, /* (560) subquery ::= NK_LP subquery NK_RP */
  {  444,   -1 }, /* (561) search_condition ::= common_expression */
  {  467,   -1 }, /* (562) sort_specification_list ::= sort_specification */
  {  467,   -3 }, /* (563) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  468,   -3 }, /* (564) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  469,    0 }, /* (565) ordering_specification_opt ::= */
  {  469,   -1 }, /* (566) ordering_specification_opt ::= ASC */
  {  469,   -1 }, /* (567) ordering_specification_opt ::= DESC */
  {  470,    0 }, /* (568) null_ordering_opt ::= */
  {  470,   -2 }, /* (569) null_ordering_opt ::= NULLS FIRST */
  {  470,   -2 }, /* (570) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,329,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,330,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,329,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,331,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,332,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,330,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,332,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,331,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy881, &yymsp[-1].minor.yy0, yymsp[0].minor.yy857); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy881, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy881, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy881, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy857 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy857 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy303, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy303, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy303 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy303 = yymsp[0].minor.yy303; }
  yymsp[0].minor.yy303 = yylhsminor.yy303;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy303 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy303 = yymsp[-2].minor.yy303 | yymsp[0].minor.yy303; }
  yymsp[-2].minor.yy303 = yylhsminor.yy303;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy303 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy303 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy881 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy881 = yylhsminor.yy881;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy881 = yymsp[-2].minor.yy881; }
  yymsp[-2].minor.yy881 = yylhsminor.yy881;
        break;
      case 42: /* priv_level ::= topic_name */
      case 281: /* sma_func_name ::= function_name */ yytestcase(yyruleno==281);
      case 485: /* alias_opt ::= table_alias */ yytestcase(yyruleno==485);
{ yylhsminor.yy881 = yymsp[0].minor.yy881; }
  yymsp[0].minor.yy881 = yylhsminor.yy881;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy881, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy587); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy881, yymsp[0].minor.yy587); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 282: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==282);
      case 283: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==283);
      case 284: /* sma_func_name ::= LAST */ yytestcase(yyruleno==284);
      case 285: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==285);
      case 370: /* db_name ::= NK_ID */ yytestcase(yyruleno==370);
      case 371: /* table_name ::= NK_ID */ yytestcase(yyruleno==371);
      case 372: /* column_name ::= NK_ID */ yytestcase(yyruleno==372);
      case 373: /* function_name ::= NK_ID */ yytestcase(yyruleno==373);
      case 374: /* table_alias ::= NK_ID */ yytestcase(yyruleno==374);
      case 375: /* column_alias ::= NK_ID */ yytestcase(yyruleno==375);
      case 376: /* user_name ::= NK_ID */ yytestcase(yyruleno==376);
      case 377: /* topic_name ::= NK_ID */ yytestcase(yyruleno==377);
      case 378: /* stream_name ::= NK_ID */ yytestcase(yyruleno==378);
      case 379: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==379);
      case 380: /* index_name ::= NK_ID */ yytestcase(yyruleno==380);
      case 420: /* noarg_func ::= NOW */ yytestcase(yyruleno==420);
      case 421: /* noarg_func ::= TODAY */ yytestcase(yyruleno==421);
      case 422: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==422);
      case 423: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==423);
      case 424: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==424);
      case 425: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==425);
      case 426: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==426);
      case 427: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==427);
      case 428: /* noarg_func ::= USER */ yytestcase(yyruleno==428);
      case 429: /* star_func ::= COUNT */ yytestcase(yyruleno==429);
      case 430: /* star_func ::= FIRST */ yytestcase(yyruleno==430);
      case 431: /* star_func ::= LAST */ yytestcase(yyruleno==431);
      case 432: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==432);
{ yylhsminor.yy881 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy881 = yylhsminor.yy881;
        break;
      case 54: /* force_opt ::= */
      case 74: /* not_exists_opt ::= */ yytestcase(yyruleno==74);
      case 76: /* exists_opt ::= */ yytestcase(yyruleno==76);
      case 302: /* analyze_opt ::= */ yytestcase(yyruleno==302);
      case 309: /* agg_func_opt ::= */ yytestcase(yyruleno==309);
      case 493: /* set_quantifier_opt ::= */ yytestcase(yyruleno==493);
{ yymsp[1].minor.yy587 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 303: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==303);
      case 310: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==310);
      case 494: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==494);
{ yymsp[0].minor.yy587 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy587, &yymsp[-1].minor.yy881, yymsp[0].minor.yy140); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy587, &yymsp[0].minor.yy881); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy881, yymsp[0].minor.yy140); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy881, yymsp[0].minor.yy214); }
        break;
      case 72: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy881, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 73: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy587 = true; }
        break;
      case 75: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy587 = true; }
        break;
      case 77: /* db_options ::= */
{ yymsp[1].minor.yy140 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 78: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 79: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 80: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 81: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 82: /* db_options ::= db_options DURATION NK_INTEGER */
      case 83: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==83);
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 84: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 85: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 86: /* db_options ::= db_options KEEP integer_list */
      case 87: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==87);
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_KEEP, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 88: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 89: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 90: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 91: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 92: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 93: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 94: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 95: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_RETENTIONS, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 96: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 97: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 98: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-3].minor.yy140, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-3].minor.yy140, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 103: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 104: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 105: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 106: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 107: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 108: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy140 = createAlterDatabaseOptions(pCxt); yylhsminor.yy140 = setAlterDatabaseOption(pCxt, yylhsminor.yy140, &yymsp[0].minor.yy809); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 109: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy140 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy140, &yymsp[0].minor.yy809); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 110: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy809.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= KEEP integer_list */
      case 115: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==115);
{ yymsp[-1].minor.yy809.type = DB_OPTION_KEEP; yymsp[-1].minor.yy809.pList = yymsp[0].minor.yy220; }
        break;
      case 116: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_PAGES; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_WAL; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* alter_db_option ::= MINROWS NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_MINROWS; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 121: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy220 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 122: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 339: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==339);
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 123: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy220 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 124: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 125: /* retention_list ::= retention */
      case 155: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==155);
      case 158: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==158);
      case 165: /* column_def_list ::= column_def */ yytestcase(yyruleno==165);
      case 208: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==208);
      case 213: /* col_name_list ::= col_name */ yytestcase(yyruleno==213);
      case 264: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==264);
      case 278: /* func_list ::= func */ yytestcase(yyruleno==278);
      case 368: /* literal_list ::= signed_literal */ yytestcase(yyruleno==368);
      case 435: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==435);
      case 441: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==441);
      case 496: /* select_list ::= select_item */ yytestcase(yyruleno==496);
      case 507: /* partition_list ::= partition_item */ yytestcase(yyruleno==507);
      case 562: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==562);
{ yylhsminor.yy220 = createNodeList(pCxt, yymsp[0].minor.yy140); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 126: /* retention_list ::= retention_list NK_COMMA retention */
      case 159: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==159);
      case 166: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==166);
      case 209: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==209);
      case 214: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==214);
      case 265: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==265);
      case 279: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==279);
      case 369: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==369);
      case 436: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==436);
      case 497: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==497);
      case 508: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==508);
      case 563: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==563);
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, yymsp[0].minor.yy140); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 127: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy140 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 128: /* speed_opt ::= */
      case 311: /* bufsize_opt ::= */ yytestcase(yyruleno==311);
{ yymsp[1].minor.yy214 = 0; }
        break;
      case 129: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 312: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==312);
{ yymsp[-1].minor.yy214 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 130: /* start_opt ::= */
      case 134: /* end_opt ::= */ yytestcase(yyruleno==134);
      case 258: /* like_pattern_opt ::= */ yytestcase(yyruleno==258);
      case 329: /* subtable_opt ::= */ yytestcase(yyruleno==329);
      case 444: /* case_when_else_opt ::= */ yytestcase(yyruleno==444);
      case 474: /* from_clause_opt ::= */ yytestcase(yyruleno==474);
      case 503: /* where_clause_opt ::= */ yytestcase(yyruleno==503);
      case 512: /* twindow_clause_opt ::= */ yytestcase(yyruleno==512);
      case 518: /* sliding_opt ::= */ yytestcase(yyruleno==518);
      case 520: /* fill_opt ::= */ yytestcase(yyruleno==520);
      case 534: /* having_clause_opt ::= */ yytestcase(yyruleno==534);
      case 536: /* range_opt ::= */ yytestcase(yyruleno==536);
      case 538: /* every_opt ::= */ yytestcase(yyruleno==538);
      case 551: /* slimit_clause_opt ::= */ yytestcase(yyruleno==551);
      case 555: /* limit_clause_opt ::= */ yytestcase(yyruleno==555);
{ yymsp[1].minor.yy140 = NULL; }
        break;
      case 131: /* start_opt ::= START WITH NK_INTEGER */
      case 135: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==135);
{ yymsp[-2].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 132: /* start_opt ::= START WITH NK_STRING */
      case 136: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==136);
{ yymsp[-2].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 133: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 137: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==137);
{ yymsp[-3].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 138: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 140: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==140);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy587, yymsp[-5].minor.yy140, yymsp[-3].minor.yy220, yymsp[-1].minor.yy220, yymsp[0].minor.yy140); }
        break;
      case 139: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy220); }
        break;
      case 141: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy220); }
        break;
      case 142: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy587, yymsp[0].minor.yy140); }
        break;
      case 143: /* cmd ::= ALTER TABLE alter_table_clause */
      case 341: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==341);
      case 342: /* cmd ::= insert_query */ yytestcase(yyruleno==342);
{ pCxt->pRootNode = yymsp[0].minor.yy140; }
        break;
      case 144: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy140); }
        break;
      case 145: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy140 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 146: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 147: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy140 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy140, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy881); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 148: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 149: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy140 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 150: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 151: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy140 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy140, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy881); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 152: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 153: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy140 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 154: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy140 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy140, &yymsp[-2].minor.yy881, yymsp[0].minor.yy140); }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 156: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 442: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==442);
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-1].minor.yy220, yymsp[0].minor.yy140); }
  yymsp[-1].minor.yy220 = yylhsminor.yy220;
        break;
      case 157: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy140 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy587, yymsp[-8].minor.yy140, yymsp[-6].minor.yy140, yymsp[-5].minor.yy220, yymsp[-2].minor.yy220, yymsp[0].minor.yy140); }
  yymsp[-9].minor.yy140 = yylhsminor.yy140;
        break;
      case 160: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy140 = createDropTableClause(pCxt, yymsp[-1].minor.yy587, yymsp[0].minor.yy140); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 161: /* specific_cols_opt ::= */
      case 191: /* tags_def_opt ::= */ yytestcase(yyruleno==191);
      case 263: /* tag_list_opt ::= */ yytestcase(yyruleno==263);
      case 315: /* col_list_opt ::= */ yytestcase(yyruleno==315);
      case 317: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==317);
      case 505: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==505);
      case 530: /* group_by_clause_opt ::= */ yytestcase(yyruleno==530);
      case 549: /* order_by_clause_opt ::= */ yytestcase(yyruleno==549);
{ yymsp[1].minor.yy220 = NULL; }
        break;
      case 162: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 316: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==316);
{ yymsp[-2].minor.yy220 = yymsp[-1].minor.yy220; }
        break;
      case 163: /* full_table_name ::= table_name */
{ yylhsminor.yy140 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy881, NULL); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 164: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy140 = createRealTableNode(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881, NULL); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 167: /* column_def ::= column_name type_name */
{ yylhsminor.yy140 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682, NULL); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 168: /* type_name ::= BOOL */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 169: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 170: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 171: /* type_name ::= INT */
      case 172: /* type_name ::= INTEGER */ yytestcase(yyruleno==172);
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 173: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 174: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 175: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 176: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 177: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 178: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy682 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 180: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy682 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 181: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy682 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 182: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy682 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 183: /* type_name ::= JSON */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 184: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 185: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 186: /* type_name ::= BLOB */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 187: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 188: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 189: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 190: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy682 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 192: /* tags_def_opt ::= tags_def */
      case 318: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==318);
      case 434: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==434);
{ yylhsminor.yy220 = yymsp[0].minor.yy220; }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 193: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 319: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==319);
{ yymsp[-3].minor.yy220 = yymsp[-1].minor.yy220; }
        break;
      case 194: /* table_options ::= */
{ yymsp[1].minor.yy140 = createDefaultTableOptions(pCxt); }
        break;
      case 195: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 196: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 197: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 198: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-4].minor.yy140, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy220); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 199: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 200: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-4].minor.yy140, TABLE_OPTION_SMA, yymsp[-1].minor.yy220); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 201: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 202: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy140 = createAlterTableOptions(pCxt); yylhsminor.yy140 = setTableOption(pCxt, yylhsminor.yy140, yymsp[0].minor.yy809.type, &yymsp[0].minor.yy809.val); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 203: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy809.type, &yymsp[0].minor.yy809.val); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 204: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy809.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 205: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy809.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 206: /* duration_list ::= duration_literal */
      case 398: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==398);
{ yylhsminor.yy220 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 207: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 399: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==399);
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 210: /* rollup_func_name ::= function_name */
{ yylhsminor.yy140 = createFunctionNode(pCxt, &yymsp[0].minor.yy881, NULL); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 211: /* rollup_func_name ::= FIRST */
      case 212: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==212);
      case 267: /* tag_item ::= QTAGS */ yytestcase(yyruleno==267);
{ yylhsminor.yy140 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 215: /* col_name ::= column_name */
      case 268: /* tag_item ::= column_name */ yytestcase(yyruleno==268);
{ yylhsminor.yy140 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy881); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 216: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 217: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 218: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 219: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 220: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy140, yymsp[0].minor.yy140, OP_TYPE_LIKE); }
        break;
      case 221: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy140, yymsp[0].minor.yy140, OP_TYPE_LIKE); }
        break;
      case 222: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy140, NULL, OP_TYPE_LIKE); }
        break;
      case 223: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 224: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 225: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 226: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy140, yymsp[-1].minor.yy140, OP_TYPE_EQUAL); }
        break;
      case 227: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 228: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 229: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 230: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 231: /* cmd ::= SHOW LICENCES */
      case 232: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==232);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 233: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 234: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy140); }
        break;
      case 235: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy140); }
        break;
      case 236: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 237: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 238: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 239: /* cmd ::= SHOW VARIABLES */
      case 240: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==240);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 241: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 242: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy140); }
        break;
      case 243: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 244: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 245: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 246: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 247: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy140); }
        break;
      case 248: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 249: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 250: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy140, yymsp[-1].minor.yy140, OP_TYPE_EQUAL); }
        break;
      case 251: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy140, yymsp[-3].minor.yy220); }
        break;
      case 252: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 253: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 254: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy140,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 255: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 256: /* db_name_cond_opt ::= */
      case 261: /* from_db_opt ::= */ yytestcase(yyruleno==261);
{ yymsp[1].minor.yy140 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 257: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy140 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 259: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 260: /* table_name_cond ::= table_name */
{ yylhsminor.yy140 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy881); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 262: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy140 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 266: /* tag_item ::= TBNAME */
{ yylhsminor.yy140 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 269: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy140 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy881), &yymsp[0].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 270: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy140 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy881), &yymsp[0].minor.yy881); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 271: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy587, yymsp[-3].minor.yy140, yymsp[-1].minor.yy140, NULL, yymsp[0].minor.yy140); }
        break;
      case 272: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy587, yymsp[-5].minor.yy140, yymsp[-3].minor.yy140, yymsp[-1].minor.yy220, NULL); }
        break;
      case 273: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy587, yymsp[0].minor.yy140); }
        break;
      case 274: /* full_index_name ::= index_name */
{ yylhsminor.yy140 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy881); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 275: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy140 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 276: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy140 = createIndexOption(pCxt, yymsp[-7].minor.yy220, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), NULL, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 277: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy140 = createIndexOption(pCxt, yymsp[-9].minor.yy220, releaseRawExprNode(pCxt, yymsp[-5].minor.yy140), releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 280: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy140 = createFunctionNode(pCxt, &yymsp[-3].minor.yy881, yymsp[-1].minor.yy220); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 286: /* sma_stream_opt ::= */
      case 320: /* stream_options ::= */ yytestcase(yyruleno==320);
{ yymsp[1].minor.yy140 = createStreamOptions(pCxt); }
        break;
      case 287: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy140)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 288: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy140)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 289: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy140)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 290: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy587, &yymsp[-2].minor.yy881, yymsp[0].minor.yy140); }
        break;
      case 291: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy587, &yymsp[-3].minor.yy881, &yymsp[0].minor.yy881, false); }
        break;
      case 292: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy587, &yymsp[-5].minor.yy881, &yymsp[0].minor.yy881, true); }
        break;
      case 293: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy587, &yymsp[-3].minor.yy881, yymsp[0].minor.yy140, false); }
        break;
      case 294: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy587, &yymsp[-5].minor.yy881, yymsp[0].minor.yy140, true); }
        break;
      case 295: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy587, &yymsp[0].minor.yy881); }
        break;
      case 296: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy587, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881); }
        break;
      case 297: /* cmd ::= DESC full_table_name */
      case 298: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==298);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy140); }
        break;
      case 299: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 300: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 301: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==301);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy587, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 304: /* explain_options ::= */
{ yymsp[1].minor.yy140 = createDefaultExplainOptions(pCxt); }
        break;
      case 305: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy140 = setExplainVerbose(pCxt, yymsp[-2].minor.yy140, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 306: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy140 = setExplainRatio(pCxt, yymsp[-2].minor.yy140, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 307: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy587, yymsp[-8].minor.yy587, &yymsp[-5].minor.yy881, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy682, yymsp[0].minor.yy214); }
        break;
      case 308: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy587, &yymsp[0].minor.yy881); }
        break;
      case 313: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy587, &yymsp[-8].minor.yy881, yymsp[-5].minor.yy140, yymsp[-7].minor.yy140, yymsp[-3].minor.yy220, yymsp[-2].minor.yy140, yymsp[0].minor.yy140, yymsp[-4].minor.yy220); }
        break;
      case 314: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy587, &yymsp[0].minor.yy881); }
        break;
      case 321: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 322: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==322);
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-2].minor.yy140, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 323: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-3].minor.yy140, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 324: /* stream_options ::= stream_options WATERMARK duration_literal */
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-2].minor.yy140, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 325: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-3].minor.yy140, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 326: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-2].minor.yy140, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 327: /* stream_options ::= stream_options DELETE_MARK duration_literal */
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-2].minor.yy140, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 328: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-3].minor.yy140, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 330: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 519: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==519);
      case 539: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==539);
{ yymsp[-3].minor.yy140 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy140); }
        break;
      case 331: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 332: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 333: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 334: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 335: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 336: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy220); }
        break;
      case 337: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 338: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy220 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 340: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 343: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy140 = createInsertStmt(pCxt, yymsp[-4].minor.yy140, yymsp[-2].minor.yy220, yymsp[0].minor.yy140); }
        break;
      case 344: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy140 = createInsertStmt(pCxt, yymsp[-1].minor.yy140, NULL, yymsp[0].minor.yy140); }
        break;
      case 345: /* literal ::= NK_INTEGER */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 346: /* literal ::= NK_FLOAT */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 347: /* literal ::= NK_STRING */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 348: /* literal ::= NK_BOOL */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 349: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 350: /* literal ::= duration_literal */
      case 360: /* signed_literal ::= signed */ yytestcase(yyruleno==360);
      case 381: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==381);
      case 382: /* expression ::= literal */ yytestcase(yyruleno==382);
      case 383: /* expression ::= pseudo_column */ yytestcase(yyruleno==383);
      case 384: /* expression ::= column_reference */ yytestcase(yyruleno==384);
      case 385: /* expression ::= function_expression */ yytestcase(yyruleno==385);
      case 386: /* expression ::= case_when_expression */ yytestcase(yyruleno==386);
      case 417: /* function_expression ::= literal_func */ yytestcase(yyruleno==417);
      case 466: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==466);
      case 470: /* boolean_primary ::= predicate */ yytestcase(yyruleno==470);
      case 472: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==472);
      case 473: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==473);
      case 476: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==476);
      case 478: /* table_reference ::= table_primary */ yytestcase(yyruleno==478);
      case 479: /* table_reference ::= joined_table */ yytestcase(yyruleno==479);
      case 483: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==483);
      case 541: /* query_simple ::= query_specification */ yytestcase(yyruleno==541);
      case 542: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==542);
      case 545: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==545);
      case 547: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==547);
{ yylhsminor.yy140 = yymsp[0].minor.yy140; }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 351: /* literal ::= NULL */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 352: /* literal ::= NK_QUESTION */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 353: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 354: /* signed ::= NK_INTEGER */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 355: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 356: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 357: /* signed ::= NK_FLOAT */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 358: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 359: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 361: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 362: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 363: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 364: /* signed_literal ::= duration_literal */
      case 366: /* signed_literal ::= literal_func */ yytestcase(yyruleno==366);
      case 437: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==437);
      case 499: /* select_item ::= common_expression */ yytestcase(yyruleno==499);
      case 509: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==509);
      case 546: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==546);
      case 548: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==548);
      case 561: /* search_condition ::= common_expression */ yytestcase(yyruleno==561);
{ yylhsminor.yy140 = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 365: /* signed_literal ::= NULL */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 367: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy140 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 387: /* expression ::= NK_LP expression NK_RP */
      case 471: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==471);
      case 560: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==560);
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 388: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy140));
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 389: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy140), NULL));
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 390: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 391: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 392: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 393: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 394: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 395: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 396: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 397: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 400: /* column_reference ::= column_name */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy881, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy881)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 401: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881, createColumnNode(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 402: /* pseudo_column ::= ROWTS */
      case 403: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==403);
      case 405: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==405);
      case 406: /* pseudo_column ::= QEND */ yytestcase(yyruleno==406);
      case 407: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==407);
      case 408: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==408);
      case 409: /* pseudo_column ::= WEND */ yytestcase(yyruleno==409);
      case 410: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==410);
      case 411: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==411);
      case 412: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==412);
      case 413: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==413);
      case 419: /* literal_func ::= NOW */ yytestcase(yyruleno==419);
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 404: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy881)))); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 414: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 415: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==415);
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy881, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy881, yymsp[-1].minor.yy220)); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 416: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), yymsp[-1].minor.yy682)); }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 418: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy881, NULL)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 433: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy220 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 438: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 502: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==502);
{ yylhsminor.yy140 = createColumnNode(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 439: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy220, yymsp[-1].minor.yy140)); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 440: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), yymsp[-2].minor.yy220, yymsp[-1].minor.yy140)); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 443: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy140 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
        break;
      case 445: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy140 = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); }
        break;
      case 446: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 451: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==451);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy794, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 447: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy140), releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 448: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy140), releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 449: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), NULL));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 450: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), NULL));
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 452: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy794 = OP_TYPE_LOWER_THAN; }
        break;
      case 453: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy794 = OP_TYPE_GREATER_THAN; }
        break;
      case 454: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy794 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 455: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy794 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 456: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy794 = OP_TYPE_NOT_EQUAL; }
        break;
      case 457: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy794 = OP_TYPE_EQUAL; }
        break;
      case 458: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy794 = OP_TYPE_LIKE; }
        break;
      case 459: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy794 = OP_TYPE_NOT_LIKE; }
        break;
      case 460: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy794 = OP_TYPE_MATCH; }
        break;
      case 461: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy794 = OP_TYPE_NMATCH; }
        break;
      case 462: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy794 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 463: /* in_op ::= IN */
{ yymsp[0].minor.yy794 = OP_TYPE_IN; }
        break;
      case 464: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy794 = OP_TYPE_NOT_IN; }
        break;
      case 465: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy220)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 467: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy140), NULL));
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 468: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 469: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 475: /* from_clause_opt ::= FROM table_reference_list */
      case 504: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==504);
      case 535: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==535);
{ yymsp[-1].minor.yy140 = yymsp[0].minor.yy140; }
        break;
      case 477: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy140 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy140, yymsp[0].minor.yy140, NULL); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 480: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy140 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 481: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy140 = createRealTableNode(pCxt, &yymsp[-3].minor.yy881, &yymsp[-1].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 482: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy140 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140), &yymsp[0].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 484: /* alias_opt ::= */
{ yymsp[1].minor.yy881 = nil_token;  }
        break;
      case 486: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy881 = yymsp[0].minor.yy881; }
        break;
      case 487: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 488: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==488);
{ yymsp[-2].minor.yy140 = yymsp[-1].minor.yy140; }
        break;
      case 489: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy140 = createJoinTableNode(pCxt, yymsp[-4].minor.yy852, yymsp[-5].minor.yy140, yymsp[-2].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 490: /* join_type ::= */
{ yymsp[1].minor.yy852 = JOIN_TYPE_INNER; }
        break;
      case 491: /* join_type ::= INNER */
{ yymsp[0].minor.yy852 = JOIN_TYPE_INNER; }
        break;
      case 492: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy140 = createSelectStmt(pCxt, yymsp[-10].minor.yy587, yymsp[-9].minor.yy220, yymsp[-8].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addWhereClause(pCxt, yymsp[-11].minor.yy140, yymsp[-7].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addPartitionByClause(pCxt, yymsp[-11].minor.yy140, yymsp[-6].minor.yy220);
                                                                                    yymsp[-11].minor.yy140 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy140, yymsp[-2].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addGroupByClause(pCxt, yymsp[-11].minor.yy140, yymsp[-1].minor.yy220);
                                                                                    yymsp[-11].minor.yy140 = addHavingClause(pCxt, yymsp[-11].minor.yy140, yymsp[0].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addRangeClause(pCxt, yymsp[-11].minor.yy140, yymsp[-5].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addEveryClause(pCxt, yymsp[-11].minor.yy140, yymsp[-4].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addFillClause(pCxt, yymsp[-11].minor.yy140, yymsp[-3].minor.yy140);
                                                                                  }
        break;
      case 495: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy587 = false; }
        break;
      case 498: /* select_item ::= NK_STAR */
{ yylhsminor.yy140 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 500: /* select_item ::= common_expression column_alias */
      case 510: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==510);
{ yylhsminor.yy140 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140), &yymsp[0].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 501: /* select_item ::= common_expression AS column_alias */
      case 511: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==511);
{ yylhsminor.yy140 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), &yymsp[0].minor.yy881); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 506: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 531: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==531);
      case 550: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==550);
{ yymsp[-2].minor.yy220 = yymsp[0].minor.yy220; }
        break;
      case 513: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy140 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
        break;
      case 514: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy140 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
        break;
      case 515: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy140 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), NULL, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 516: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy140 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy140), releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 517: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy140 = createEventWindowNode(pCxt, yymsp[-3].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 521: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy140 = createFillNode(pCxt, yymsp[-1].minor.yy174, NULL); }
        break;
      case 522: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy140 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy220)); }
        break;
      case 523: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy140 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy220)); }
        break;
      case 524: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy174 = FILL_MODE_NONE; }
        break;
      case 525: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy174 = FILL_MODE_PREV; }
        break;
      case 526: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy174 = FILL_MODE_NULL; }
        break;
      case 527: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy174 = FILL_MODE_NULL_F; }
        break;
      case 528: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy174 = FILL_MODE_LINEAR; }
        break;
      case 529: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy174 = FILL_MODE_NEXT; }
        break;
      case 532: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy220 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 533: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 537: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy140 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
        break;
      case 540: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy140 = addOrderByClause(pCxt, yymsp[-3].minor.yy140, yymsp[-2].minor.yy220);
                                                                                    yylhsminor.yy140 = addSlimitClause(pCxt, yylhsminor.yy140, yymsp[-1].minor.yy140);
                                                                                    yylhsminor.yy140 = addLimitClause(pCxt, yylhsminor.yy140, yymsp[0].minor.yy140);
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 543: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy140 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 544: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy140 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 552: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 556: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==556);
{ yymsp[-1].minor.yy140 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 553: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 557: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==557);
{ yymsp[-3].minor.yy140 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 554: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 558: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==558);
{ yymsp[-3].minor.yy140 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 559: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy140); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 564: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy140 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), yymsp[-1].minor.yy866, yymsp[0].minor.yy697); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 565: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy866 = ORDER_ASC; }
        break;
      case 566: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy866 = ORDER_ASC; }
        break;
      case 567: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy866 = ORDER_DESC; }
        break;
      case 568: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy697 = NULL_ORDER_DEFAULT; }
        break;
      case 569: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy697 = NULL_ORDER_FIRST; }
        break;
      case 570: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy697 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
