/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 376
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EJoinType yy52;
  bool yy89;
  SDataType yy224;
  int32_t yy228;
  SNode* yy248;
  SAlterOption yy301;
  ENullOrder yy345;
  SToken yy401;
  EOrder yy482;
  int64_t yy525;
  SNodeList* yy552;
  EFillMode yy582;
  int8_t yy695;
  EOperatorType yy716;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             656
#define YYNRULE              484
#define YYNTOKEN             253
#define YY_MAX_SHIFT         655
#define YY_MIN_SHIFTREDUCE   957
#define YY_MAX_SHIFTREDUCE   1440
#define YY_ERROR_ACTION      1441
#define YY_ACCEPT_ACTION     1442
#define YY_NO_ACTION         1443
#define YY_MIN_REDUCE        1444
#define YY_MAX_REDUCE        1927
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2612)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   425,   69,  426, 1479,  433, 1679,  426, 1479, 1749, 1780,
 /*    10 */  1570,  318,   39,   37,  115, 1749,  555,  521,  335, 1746,
 /*    20 */   327, 1746, 1242, 1574,  330,  374, 1746, 1676,   40,   38,
 /*    30 */    36,   35,   34, 1317,  101, 1240, 1568,  100,   99,   98,
 /*    40 */    97,   96,   95,   94,   93,   92, 1742, 1748, 1742, 1748,
 /*    50 */  1625, 1626, 1762, 1742, 1748,  520, 1312,  573,   61,  573,
 /*    60 */    14, 1007,  151, 1006,  573, 1905, 1248,  569,  990,   39,
 /*    70 */    37, 1380, 1444, 1750,  491, 1618,  461,  327,  157, 1242,
 /*    80 */  1780, 1509, 1902,    1, 1746,  569,  528,  489,  552,  487,
 /*    90 */  1317, 1008, 1240, 1732,   84,  551,  110,  109,  108,  107,
 /*   100 */   106,  105,  104,  103,  102,  652,  211,  120,  994,  995,
 /*   110 */   532, 1742, 1748, 1312,  119, 1571,  569,   14,  442, 1319,
 /*   120 */  1320, 1793,  573, 1248,   87, 1763,  554, 1765, 1766,  550,
 /*   130 */    42,  573,  507,   60, 1839,   73, 1905,   60,  300, 1835,
 /*   140 */     2,  522,  339,  477,  476, 1624, 1626,  655,  475, 1904,
 /*   150 */  1905,  116,  472, 1902,  117,  471,  470,  469,  528, 1384,
 /*   160 */    58,  263,  652,  159, 1243, 1266, 1241, 1902,  530,  153,
 /*   170 */  1847, 1848, 1905, 1852,  493,  149, 1319, 1320, 1556,   43,
 /*   180 */   645,  641,  637,  633,  261,  157,  119, 1720, 1442, 1902,
 /*   190 */  1246, 1247,  517, 1295, 1296, 1298, 1299, 1300, 1301, 1302,
 /*   200 */   547,  571, 1310, 1311, 1313, 1314, 1315, 1316, 1318, 1321,
 /*   210 */    85,   33,   32,  255, 1905,   40,   38,   36,   35,   34,
 /*   220 */   204, 1243,  160, 1241,   11,   10,  117,  157, 1631,   30,
 /*   230 */   241, 1902,   33,   32,  353,  332,   40,   38,   36,   35,
 /*   240 */    34,  154, 1847, 1848, 1629, 1852,  566, 1246, 1247,  344,
 /*   250 */  1295, 1296, 1298, 1299, 1300, 1301, 1302,  547,  571, 1310,
 /*   260 */  1311, 1313, 1314, 1315, 1316, 1318, 1321,   39,   37,  160,
 /*   270 */   523,  518,  160,  605,  331,  327,  160, 1242,  213,   71,
 /*   280 */   306, 1267,  138,  559,  301, 1557,  570, 1411, 1317, 1905,
 /*   290 */  1240, 1581,  129,  128,  602,  601,  600,  111,  570, 1215,
 /*   300 */   424,  206,  157,  428,  463, 1905, 1902, 1353, 1280,  162,
 /*   310 */  1905, 1312,  246,  247, 1579,   14, 1339,  140,  158, 1456,
 /*   320 */   570, 1248, 1902, 1903,   39,   37, 1579, 1902,  477,  476,
 /*   330 */   380,  567,  327,  475, 1242, 1506,  116,  472,    2, 1297,
 /*   340 */   471,  470,  469, 1267,  442, 1317,   60, 1240, 1579, 1098,
 /*   350 */   596,  595,  594, 1102,  593, 1104, 1105,  592, 1107,  589,
 /*   360 */   652, 1113,  586, 1115, 1116,  583,  580,  298, 1312,  337,
 /*   370 */  1340, 1669,   69,  306, 1319, 1320,  559,  138, 1248, 1467,
 /*   380 */  1140, 1141,  169,   33,   32, 1631, 1581,   40,   38,   36,
 /*   390 */    35,   34,  338, 1345, 1575,    8,  534,  629,  628,  627,
 /*   400 */   342, 1629,  626,  625,  624,  121,  619,  618,  617,  616,
 /*   410 */   615,  614,  613,  612,  131,  608,  340,  652,   22, 1243,
 /*   420 */  1732, 1241,   33,   32,  138, 1266,   40,   38,   36,   35,
 /*   430 */    34, 1319, 1320, 1581,   29,  325, 1334, 1335, 1336, 1337,
 /*   440 */  1338, 1342, 1343, 1344,  432, 1246, 1247,  428, 1295, 1296,
 /*   450 */  1298, 1299, 1300, 1301, 1302,  547,  571, 1310, 1311, 1313,
 /*   460 */  1314, 1315, 1316, 1318, 1321,   33,   32,  607,  570,   40,
 /*   470 */    38,   36,   35,   34, 1327, 1265, 1243,   78, 1241,  111,
 /*   480 */  1266,   36,   35,   34, 1242,  160,  468,   33,   32,  474,
 /*   490 */   473,   40,   38,   36,   35,   34, 1579, 1240, 1572, 1466,
 /*   500 */   141,  528, 1246, 1247, 1536, 1295, 1296, 1298, 1299, 1300,
 /*   510 */  1301, 1302,  547,  571, 1310, 1311, 1313, 1314, 1315, 1316,
 /*   520 */  1318, 1321,   39,   37, 1322,   60,  413,  605, 1248,  119,
 /*   530 */   327, 1445, 1242, 1465,  160, 1007, 1464, 1006,  430,  301,
 /*   540 */  1732, 1391, 1555, 1317, 1264, 1240,  129,  128,  602,  601,
 /*   550 */   600,  532,  101,  528, 1401,  100,   99,   98,   97,   96,
 /*   560 */    95,   94,   93,   92,  570, 1008, 1312,  652, 1268,  117,
 /*   570 */  1437, 1339,  171,  170, 1732,  378, 1248, 1732,  599,   39,
 /*   580 */    37,  119, 1266,  570,  231, 1847,  527,  327,  526, 1242,
 /*   590 */  1854, 1905, 1579,    9,  379,  514, 1399, 1400, 1402, 1403,
 /*   600 */  1317,  607, 1240,  532,  159,  373, 1762,  372, 1902,  365,
 /*   610 */  1463, 1579,   33,   32, 1851,  652,   40,   38,   36,   35,
 /*   620 */    34,  117, 1752, 1312, 1675, 1340, 1243,  295, 1241, 1319,
 /*   630 */  1320,  367,  363, 1248, 1780,  570,  231, 1847,  527, 1248,
 /*   640 */   526, 1631,  552, 1905,  167,  610,  383, 1732, 1345,  551,
 /*   650 */     9, 1732, 1246, 1247, 1297,   26,  157, 1630, 1436, 1754,
 /*   660 */  1902,   33,   32, 1579,  160,   40,   38,   36,   35,   34,
 /*   670 */    67, 1060,  652,   66, 1243, 1793, 1241,    7,  142, 1763,
 /*   680 */   554, 1765, 1766,  550, 1485,  573, 1319, 1320, 1554,   29,
 /*   690 */   325, 1334, 1335, 1336, 1337, 1338, 1342, 1343, 1344,  233,
 /*   700 */  1246, 1247, 1062, 1295, 1296, 1298, 1299, 1300, 1301, 1302,
 /*   710 */   547,  571, 1310, 1311, 1313, 1314, 1315, 1316, 1318, 1321,
 /*   720 */    33,   32,  533, 1919,   40,   38,   36,   35,   34, 1854,
 /*   730 */  1854, 1243,  647, 1241,   28,  623,  621,  536,  555, 1674,
 /*   740 */    33,   32,  295,  311,   40,   38,   36,   35,   34, 1677,
 /*   750 */   138, 1269,  528, 1850, 1849,  137, 1297, 1246, 1247, 1582,
 /*   760 */  1295, 1296, 1298, 1299, 1300, 1301, 1302,  547,  571, 1310,
 /*   770 */  1311, 1313, 1314, 1315, 1316, 1318, 1321,   39,   37,  297,
 /*   780 */   119, 1264, 1564,  605,  611,  327, 1551, 1242,  406, 1762,
 /*   790 */  1341,  418,  312, 1462,  310,  309, 1280,  465, 1317, 1377,
 /*   800 */  1240,  467,  129,  128,  602,  601,  600, 1566,  391,  500,
 /*   810 */   419,  603,  393, 1346, 1622, 1461,  570, 1780,  245, 1460,
 /*   820 */   117, 1312, 1537,  466, 1562,  552,  482,  398,  207,  570,
 /*   830 */  1732, 1248,  551, 1459, 1732,  155, 1847, 1848, 1458, 1852,
 /*   840 */   399,  492,  546,  384, 1579,   33,   32, 1457,    2,   40,
 /*   850 */    38,   36,   35,   34,   27,  203, 1732, 1579, 1793, 1373,
 /*   860 */  1732,   89, 1763,  554, 1765, 1766,  550, 1455,  573,  485,
 /*   870 */   652, 1839,  598,  479, 1732, 1838, 1835,  539,  202, 1732,
 /*   880 */  1223, 1224,  214,  417, 1319, 1320,  412,  411,  410,  409,
 /*   890 */   408,  405,  404,  403,  402,  401,  397,  396,  395,  394,
 /*   900 */   388,  387,  386,  385,   55,  382,  381,   54, 1732,  236,
 /*   910 */  1454,  570,  570,  139,  570,  570,  604,  460,  274, 1622,
 /*   920 */   994,  995,  441, 1576,  544, 1708,  501,  195,  467, 1243,
 /*   930 */   193, 1241,  272,   57,  268,  537,   56, 1609,  197, 1579,
 /*   940 */  1579,  196, 1579, 1579, 1859, 1373, 1453,  494, 1762,  515,
 /*   950 */   466, 1732,  173,  421, 1452, 1246, 1247, 1451, 1295, 1296,
 /*   960 */  1298, 1299, 1300, 1301, 1302,  547,  571, 1310, 1311, 1313,
 /*   970 */  1314, 1315, 1316, 1318, 1321,  570, 1780,  570,   60,  570,
 /*   980 */  1251,  570,   44,    4,  552, 1450,  505, 1732,  568, 1732,
 /*   990 */   257,  551,  341, 1496, 1250, 1732,  622, 1449, 1732,  199,
 /*  1000 */  1448, 1447,  198, 1579,   50, 1579,  532, 1579,  201, 1579,
 /*  1010 */  1491,  200,   52,  504,  210,  478,   86, 1793, 1376,  218,
 /*  1020 */    87, 1763,  554, 1765, 1766,  550, 1732,  573, 1489,   41,
 /*  1030 */  1839,   41,  480, 1762,  300, 1835,  225,  368, 1732,   11,
 /*  1040 */    10, 1732, 1732,   72,   41, 1398, 1905, 1439, 1440,  243,
 /*  1050 */   483,   64,   63,  377, 1331,  123,  166,  126,  127,  157,
 /*  1060 */   220, 1780,  371, 1902, 1032, 1781,  343, 1480, 1619,  531,
 /*  1070 */  1347,  529, 1303,   50, 1732,  296,  551,  540,  361, 1869,
 /*  1080 */   359,  355,  351,  163,  346, 1191,  578,  126, 1762,  127,
 /*  1090 */   248,  112,  230,  126,   83, 1033,  562,    3,  254, 1091,
 /*  1100 */  1264,  235, 1793,  238,   80,   88, 1763,  554, 1765, 1766,
 /*  1110 */   550, 1254,  573,    5,  267, 1839, 1780,  160,  240,  320,
 /*  1120 */  1835,  152,  345,  348,  531, 1253,  352, 1119, 1123, 1732,
 /*  1130 */  1130,  551, 1128,  156,  130,  307, 1060,  308,  400, 1207,
 /*  1140 */   264, 1865, 1671, 1762,  168,  407,  415,  414,  416,  420,
 /*  1150 */   422, 1270,  423, 1273,  431,  434,  176, 1793,  178,  435,
 /*  1160 */    88, 1763,  554, 1765, 1766,  550, 1272,  573,  436, 1274,
 /*  1170 */  1839, 1780,  437,  181,  320, 1835,  152,  183,  439,  552,
 /*  1180 */  1271,  185,  440,   68, 1732,  188,  551,  443,  462,   91,
 /*  1190 */   464, 1569,  192,  299, 1565,  194, 1866, 1713,  132,  265,
 /*  1200 */   133,  496, 1567, 1563,  134, 1762,  135,  205,  495,  208,
 /*  1210 */   502,  506, 1793, 1269,  317,   88, 1763,  554, 1765, 1766,
 /*  1220 */   550,  212,  573,  499, 1870, 1839,  511,  516, 1880,  320,
 /*  1230 */  1835, 1918,  558, 1780,  216,  513,  319,  525,    6,  219,
 /*  1240 */  1873,  552,  334,  333, 1879,  519, 1732,  512,  551,  509,
 /*  1250 */   510,  226, 1256, 1373, 1861,  224,  229,  227,  146,  228,
 /*  1260 */   118, 1268, 1855, 1317,  541, 1249,  538,   18,  321,  556,
 /*  1270 */   124,  557,  234, 1762, 1793, 1712, 1681,   88, 1763,  554,
 /*  1280 */  1765, 1766,  550,  125,  573,  563, 1312, 1839,  560,  329,
 /*  1290 */   564,  320, 1835, 1918,  565, 1820, 1248, 1901,  266,  250,
 /*  1300 */   252, 1780, 1896,   77,  535,   79,  237, 1921, 1580,  552,
 /*  1310 */   648,  269,  542,  239, 1732,  576,  551, 1623,  260, 1552,
 /*  1320 */   649,  651,   51,  271,  273, 1726, 1725,  290,   62,  292,
 /*  1330 */  1724,  145,  291,  347, 1721,  574,  349,  350, 1235, 1236,
 /*  1340 */  1762,  164, 1793,  190, 1719,   88, 1763,  554, 1765, 1766,
 /*  1350 */   550,  354,  573,  356,  357, 1839,  358,  144, 1718,  320,
 /*  1360 */  1835, 1918,  459,  455,  451,  447,  189,  360, 1780, 1717,
 /*  1370 */  1858,  362, 1716,  364, 1715,  366,  552, 1698,  165,  369,
 /*  1380 */   370, 1732, 1692,  551, 1210, 1209, 1691,  375,  376, 1690,
 /*  1390 */  1689, 1179,   70, 1664, 1257,  187, 1252,   65,  532, 1663,
 /*  1400 */  1662, 1661, 1660, 1659, 1658, 1657,  389, 1656,  390, 1793,
 /*  1410 */   392, 1655,  281, 1763,  554, 1765, 1766,  550, 1762,  573,
 /*  1420 */  1260, 1654, 1653, 1652, 1651, 1650, 1649, 1648, 1647, 1646,
 /*  1430 */  1645,  571, 1310, 1311, 1313, 1314, 1315, 1316, 1905, 1644,
 /*  1440 */  1643, 1642, 1641, 1640, 1639, 1638, 1780, 1637,  122, 1636,
 /*  1450 */  1635,  159, 1634, 1181,  552, 1902, 1633,  186,  179, 1732,
 /*  1460 */   184,  551, 1632, 1510,  438,  172, 1508, 1476,  997,  996,
 /*  1470 */  1475, 1706, 1762,  113,  174, 1700,  532,  175,  150,  427,
 /*  1480 */  1688, 1687,  429,  177,  182,  114, 1673, 1793, 1558, 1507,
 /*  1490 */   281, 1763,  554, 1765, 1766,  550,  180,  573, 1505, 1762,
 /*  1500 */  1780, 1503, 1501,  444,  446,  445,  449,  448,  552, 1026,
 /*  1510 */  1499,  452,  450, 1732,  456,  551, 1905,  454, 1488, 1487,
 /*  1520 */  1472,  453, 1560,  458, 1559, 1134, 1133, 1780,  191,  157,
 /*  1530 */   457, 1059, 1058, 1902, 1057,  549, 1497,  620, 1056, 1492,
 /*  1540 */  1732, 1793,  551,   49,   89, 1763,  554, 1765, 1766,  550,
 /*  1550 */   622,  573, 1053, 1762, 1839,  313, 1052,  314,  543, 1835,
 /*  1560 */  1051,  481, 1490,  315,  484, 1471,  486, 1470, 1793,  488,
 /*  1570 */  1469,  288, 1763,  554, 1765, 1766,  550,  548,  573,  545,
 /*  1580 */  1811, 1780,  490,   90, 1705, 1217, 1699,  136,  497,  552,
 /*  1590 */  1686, 1684, 1685, 1683, 1732, 1682,  551,   41,   23,   47,
 /*  1600 */  1413,   15,   16, 1762,   53,   45,  215,  222,   10,  209,
 /*  1610 */   217,  498, 1397,  143,  223,  316, 1390, 1752,   25,  232,
 /*  1620 */   221,   24, 1793,   74,   46,   89, 1763,  554, 1765, 1766,
 /*  1630 */   550, 1780,  573, 1370,  147, 1839, 1369, 1430,  503,  552,
 /*  1640 */  1836,   17,   13, 1425, 1732, 1419,  551, 1424,  322, 1429,
 /*  1650 */  1428,  323,   19, 1762, 1288, 1680, 1305,   31,  508, 1332,
 /*  1660 */  1304,   12,   20,  148,  161,   21, 1227,  242,  244, 1762,
 /*  1670 */  1672, 1395, 1793,  251,  553,  289, 1763,  554, 1765, 1766,
 /*  1680 */   550, 1780,  573,  249,   75,   76, 1796,   80, 1751,  552,
 /*  1690 */   256,  561,  253,  572, 1732, 1307,  551, 1780, 1258,  575,
 /*  1700 */   577,  336,   48,  581, 1120,  552, 1117,  579,  582,  584,
 /*  1710 */  1732, 1114,  551,  585,  587, 1108,  588, 1097,  590, 1106,
 /*  1720 */   591,  597, 1793, 1129,   81,  284, 1763,  554, 1765, 1766,
 /*  1730 */   550,   82,  573, 1762,   59, 1112, 1111,  258, 1793, 1125,
 /*  1740 */   606,  142, 1763,  554, 1765, 1766,  550, 1024,  573, 1762,
 /*  1750 */  1110, 1048, 1109, 1066,  609,  259, 1046, 1045, 1044, 1043,
 /*  1760 */  1042, 1780, 1041,  524, 1040, 1039, 1063, 1061, 1036,  552,
 /*  1770 */  1035, 1034, 1031, 1030, 1732, 1504,  551, 1780, 1029,  630,
 /*  1780 */   632,  631, 1502,  634,  636,  549, 1920, 1500,  324,  635,
 /*  1790 */  1732,  638,  551,  639,  640, 1498,  642,  643,  644, 1762,
 /*  1800 */  1486,  646, 1793,  987, 1468,  289, 1763,  554, 1765, 1766,
 /*  1810 */   550,  262,  573,  650,  653, 1762, 1244, 1443, 1793,  270,
 /*  1820 */  1443,  288, 1763,  554, 1765, 1766,  550, 1780,  573,  654,
 /*  1830 */  1812, 1443, 1443, 1443, 1443,  552, 1443, 1443, 1443, 1443,
 /*  1840 */  1732, 1443,  551, 1780, 1443, 1443, 1443, 1443, 1443, 1443,
 /*  1850 */  1443,  552, 1443, 1443,  326, 1443, 1732, 1443,  551, 1443,
 /*  1860 */  1443, 1443, 1443, 1443, 1443, 1443, 1443, 1443, 1793, 1443,
 /*  1870 */   328,  289, 1763,  554, 1765, 1766,  550, 1443,  573, 1762,
 /*  1880 */  1443, 1443, 1443, 1443, 1793, 1443, 1443,  289, 1763,  554,
 /*  1890 */  1765, 1766,  550, 1443,  573, 1443, 1762, 1443, 1443, 1443,
 /*  1900 */  1443, 1443, 1443, 1443, 1443, 1443, 1443, 1780, 1443, 1443,
 /*  1910 */  1443, 1443, 1443, 1443, 1443,  552, 1443, 1443, 1443, 1443,
 /*  1920 */  1732, 1443,  551, 1443, 1780, 1443, 1443, 1443, 1443, 1443,
 /*  1930 */  1443, 1443,  552, 1443, 1443, 1443, 1443, 1732, 1762,  551,
 /*  1940 */  1443, 1443, 1443, 1443, 1443, 1443, 1443, 1443, 1793, 1443,
 /*  1950 */  1443,  275, 1763,  554, 1765, 1766,  550, 1443,  573, 1443,
 /*  1960 */  1443, 1443, 1762, 1443, 1443, 1793, 1780, 1443,  276, 1763,
 /*  1970 */   554, 1765, 1766,  550,  552,  573, 1443, 1443, 1443, 1732,
 /*  1980 */  1443,  551, 1443, 1443, 1443, 1443, 1443, 1443, 1443, 1443,
 /*  1990 */  1780, 1443, 1443, 1443, 1443, 1443, 1443, 1443,  552, 1443,
 /*  2000 */  1443, 1443, 1443, 1732, 1443,  551, 1443, 1793, 1443, 1443,
 /*  2010 */   277, 1763,  554, 1765, 1766,  550, 1443,  573, 1762, 1443,
 /*  2020 */  1443, 1443, 1443, 1443, 1443, 1443, 1443, 1443, 1443, 1443,
 /*  2030 */  1443, 1793, 1443, 1443,  283, 1763,  554, 1765, 1766,  550,
 /*  2040 */  1443,  573, 1762, 1443, 1443, 1443, 1780, 1443, 1443, 1443,
 /*  2050 */  1443, 1443, 1443, 1443,  552, 1443, 1443, 1443, 1443, 1732,
 /*  2060 */  1443,  551, 1443, 1443, 1443, 1443, 1443, 1443, 1443, 1443,
 /*  2070 */  1780, 1443, 1443, 1443, 1443, 1443, 1443, 1443,  552, 1443,
 /*  2080 */  1443, 1443, 1443, 1732, 1762,  551, 1443, 1793, 1443, 1443,
 /*  2090 */   285, 1763,  554, 1765, 1766,  550, 1443,  573, 1443, 1443,
 /*  2100 */  1762, 1443, 1443, 1443, 1443, 1443, 1443, 1443, 1443, 1443,
 /*  2110 */  1443, 1793, 1780, 1443,  278, 1763,  554, 1765, 1766,  550,
 /*  2120 */   552,  573, 1443, 1443, 1443, 1732, 1443,  551, 1780, 1443,
 /*  2130 */  1443, 1443, 1443, 1443, 1443, 1443,  552, 1443, 1443, 1443,
 /*  2140 */  1443, 1732, 1443,  551, 1443, 1443, 1443, 1443, 1443, 1443,
 /*  2150 */  1443, 1443, 1443, 1793, 1443, 1443,  286, 1763,  554, 1765,
 /*  2160 */  1766,  550, 1443,  573, 1762, 1443, 1443, 1443, 1443, 1793,
 /*  2170 */  1443, 1443,  279, 1763,  554, 1765, 1766,  550, 1443,  573,
 /*  2180 */  1443, 1762, 1443, 1443, 1443, 1443, 1443, 1443, 1443, 1443,
 /*  2190 */  1443, 1443, 1780, 1443, 1443, 1443, 1443, 1443, 1443, 1443,
 /*  2200 */   552, 1443, 1443, 1443, 1443, 1732, 1443,  551, 1443, 1780,
 /*  2210 */  1443, 1443, 1443, 1443, 1443, 1443, 1443,  552, 1443, 1443,
 /*  2220 */  1443, 1443, 1732, 1762,  551, 1443, 1443, 1443, 1443, 1443,
 /*  2230 */  1443, 1443, 1443, 1793, 1443, 1443,  287, 1763,  554, 1765,
 /*  2240 */  1766,  550, 1443,  573, 1443, 1443, 1443, 1762, 1443, 1443,
 /*  2250 */  1793, 1780, 1443,  280, 1763,  554, 1765, 1766,  550,  552,
 /*  2260 */   573, 1443, 1443, 1443, 1732, 1443,  551, 1443, 1443, 1443,
 /*  2270 */  1443, 1443, 1443, 1443, 1443, 1780, 1443, 1443, 1443, 1443,
 /*  2280 */  1443, 1443, 1443,  552, 1443, 1443, 1443, 1443, 1732, 1443,
 /*  2290 */   551, 1443, 1793, 1443, 1443,  293, 1763,  554, 1765, 1766,
 /*  2300 */   550, 1443,  573, 1762, 1443, 1443, 1443, 1443, 1443, 1443,
 /*  2310 */  1443, 1443, 1443, 1443, 1443, 1443, 1793, 1443, 1443,  294,
 /*  2320 */  1763,  554, 1765, 1766,  550, 1443,  573, 1762, 1443, 1443,
 /*  2330 */  1443, 1780, 1443, 1443, 1443, 1443, 1443, 1443, 1443,  552,
 /*  2340 */  1443, 1443, 1443, 1443, 1732, 1443,  551, 1443, 1443, 1443,
 /*  2350 */  1443, 1443, 1443, 1443, 1443, 1780, 1443, 1443, 1443, 1443,
 /*  2360 */  1443, 1443, 1443,  552, 1443, 1443, 1443, 1443, 1732, 1762,
 /*  2370 */   551, 1443, 1793, 1443, 1443, 1774, 1763,  554, 1765, 1766,
 /*  2380 */   550, 1443,  573, 1443, 1443, 1762, 1443, 1443, 1443, 1443,
 /*  2390 */  1443, 1443, 1443, 1443, 1443, 1443, 1793, 1780, 1443, 1773,
 /*  2400 */  1763,  554, 1765, 1766,  550,  552,  573, 1443, 1443, 1443,
 /*  2410 */  1732, 1443,  551, 1780, 1443, 1443, 1443, 1443, 1443, 1443,
 /*  2420 */  1443,  552, 1443, 1443, 1443, 1443, 1732, 1443,  551, 1443,
 /*  2430 */  1443, 1443, 1443, 1443, 1443, 1443, 1443, 1443, 1793, 1443,
 /*  2440 */  1443, 1772, 1763,  554, 1765, 1766,  550, 1443,  573, 1762,
 /*  2450 */  1443, 1443, 1443, 1443, 1793, 1443, 1443,  304, 1763,  554,
 /*  2460 */  1765, 1766,  550, 1443,  573, 1443, 1762, 1443, 1443, 1443,
 /*  2470 */  1443, 1443, 1443, 1443, 1443, 1443, 1443, 1780, 1443, 1443,
 /*  2480 */  1443, 1443, 1443, 1443, 1443,  552, 1443, 1443, 1443, 1443,
 /*  2490 */  1732, 1443,  551, 1443, 1780, 1443, 1443, 1443, 1443, 1443,
 /*  2500 */  1443, 1443,  552, 1443, 1443, 1443, 1443, 1732, 1762,  551,
 /*  2510 */  1443, 1443, 1443, 1443, 1443, 1443, 1443, 1443, 1793, 1443,
 /*  2520 */  1443,  303, 1763,  554, 1765, 1766,  550, 1443,  573, 1443,
 /*  2530 */  1443, 1443, 1762, 1443, 1443, 1793, 1780, 1443,  305, 1763,
 /*  2540 */   554, 1765, 1766,  550,  552,  573, 1443, 1443, 1443, 1732,
 /*  2550 */  1443,  551, 1443, 1443, 1443, 1443, 1443, 1443, 1443, 1443,
 /*  2560 */  1780, 1443, 1443, 1443, 1443, 1443, 1443, 1443,  552, 1443,
 /*  2570 */  1443, 1443, 1443, 1732, 1443,  551, 1443, 1793, 1443, 1443,
 /*  2580 */   302, 1763,  554, 1765, 1766,  550, 1443,  573, 1443, 1443,
 /*  2590 */  1443, 1443, 1443, 1443, 1443, 1443, 1443, 1443, 1443, 1443,
 /*  2600 */  1443, 1793, 1443, 1443,  282, 1763,  554, 1765, 1766,  550,
 /*  2610 */  1443,  573,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   260,  268,  262,  263,  260,    0,  262,  263,  286,  284,
 /*    10 */   286,  289,   12,   13,  281,  286,  299,  292,  289,  297,
 /*    20 */    20,  297,   22,  290,  307,  314,  297,  310,   12,   13,
 /*    30 */    14,   15,   16,   33,   21,   35,  285,   24,   25,   26,
 /*    40 */    27,   28,   29,   30,   31,   32,  324,  325,  324,  325,
 /*    50 */   298,  299,  256,  324,  325,  330,   56,  335,    4,  335,
 /*    60 */    60,   20,  283,   22,  335,  354,   66,   20,    4,   12,
 /*    70 */    13,   14,    0,  286,   21,  296,   35,   20,  367,   22,
 /*    80 */   284,    0,  371,   83,  297,   20,  264,   34,  292,   36,
 /*    90 */    33,   50,   35,  297,  266,  299,   24,   25,   26,   27,
 /*   100 */    28,   29,   30,   31,   32,  105,   56,  279,   44,   45,
 /*   110 */   314,  324,  325,   56,  292,  287,   20,   60,   59,  119,
 /*   120 */   120,  325,  335,   66,  328,  329,  330,  331,  332,  333,
 /*   130 */    83,  335,  314,   83,  338,   85,  354,   83,  342,  343,
 /*   140 */    83,   20,  295,   62,   63,  298,  299,   19,   67,  367,
 /*   150 */   354,   70,   71,  371,  332,   74,   75,   76,  264,   14,
 /*   160 */     3,   33,  105,  367,  164,   20,  166,  371,  346,  347,
 /*   170 */   348,  349,  354,  351,  314,   47,  119,  120,    0,   83,
 /*   180 */    52,   53,   54,   55,   56,  367,  292,    0,  253,  371,
 /*   190 */   190,  191,  149,  193,  194,  195,  196,  197,  198,  199,
 /*   200 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */    82,    8,    9,   85,  354,   12,   13,   14,   15,   16,
 /*   220 */   115,  164,  222,  166,    1,    2,  332,  367,  284,  339,
 /*   230 */   340,  371,    8,    9,   47,  291,   12,   13,   14,   15,
 /*   240 */    16,  347,  348,  349,  300,  351,  118,  190,  191,  314,
 /*   250 */   193,  194,  195,  196,  197,  198,  199,  200,  201,  202,
 /*   260 */   203,  204,  205,  206,  207,  208,  209,   12,   13,  222,
 /*   270 */   227,  228,  222,   95,  276,   20,  222,   22,  150,  174,
 /*   280 */   175,   20,  284,  178,   60,    0,  264,   84,   33,  354,
 /*   290 */    35,  293,  114,  115,  116,  117,  118,  275,  264,  171,
 /*   300 */   261,  173,  367,  264,  282,  354,  371,   84,   84,  275,
 /*   310 */   354,   56,  114,  115,  292,   60,   92,  255,  367,  257,
 /*   320 */   264,   66,  371,  367,   12,   13,  292,  371,   62,   63,
 /*   330 */   264,  275,   20,   67,   22,    0,   70,   71,   83,  194,
 /*   340 */    74,   75,   76,   20,   59,   33,   83,   35,  292,   96,
 /*   350 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*   360 */   105,  108,  109,  110,  111,  112,  113,  301,   56,  276,
 /*   370 */   146,  292,  268,  175,  119,  120,  178,  284,   66,  256,
 /*   380 */   119,  120,  303,    8,    9,  284,  293,   12,   13,   14,
 /*   390 */    15,   16,  291,  169,  290,   83,  239,   62,   63,   64,
 /*   400 */    65,  300,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   410 */    75,   76,   77,   78,   79,   80,  276,  105,   43,  164,
 /*   420 */   297,  166,    8,    9,  284,   20,   12,   13,   14,   15,
 /*   430 */    16,  119,  120,  293,  210,  211,  212,  213,  214,  215,
 /*   440 */   216,  217,  218,  219,  261,  190,  191,  264,  193,  194,
 /*   450 */   195,  196,  197,  198,  199,  200,  201,  202,  203,  204,
 /*   460 */   205,  206,  207,  208,  209,    8,    9,   59,  264,   12,
 /*   470 */    13,   14,   15,   16,   14,   20,  164,  266,  166,  275,
 /*   480 */    20,   14,   15,   16,   22,  222,  282,    8,    9,  270,
 /*   490 */   271,   12,   13,   14,   15,   16,  292,   35,  287,  256,
 /*   500 */   269,  264,  190,  191,  273,  193,  194,  195,  196,  197,
 /*   510 */   198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
 /*   520 */   208,  209,   12,   13,   14,   83,   77,   95,   66,  292,
 /*   530 */    20,    0,   22,  256,  222,   20,  256,   22,   14,   60,
 /*   540 */   297,   84,    0,   33,   20,   35,  114,  115,  116,  117,
 /*   550 */   118,  314,   21,  264,  190,   24,   25,   26,   27,   28,
 /*   560 */    29,   30,   31,   32,  264,   50,   56,  105,   20,  332,
 /*   570 */   156,   92,  123,  124,  297,  275,   66,  297,   94,   12,
 /*   580 */    13,  292,   20,  264,  347,  348,  349,   20,  351,   22,
 /*   590 */   326,  354,  292,   83,  275,  231,  232,  233,  234,  235,
 /*   600 */    33,   59,   35,  314,  367,  163,  256,  165,  371,  159,
 /*   610 */   256,  292,    8,    9,  350,  105,   12,   13,   14,   15,
 /*   620 */    16,  332,   46,   56,  309,  146,  164,  312,  166,  119,
 /*   630 */   120,  181,  182,   66,  284,  264,  347,  348,  349,   66,
 /*   640 */   351,  284,  292,  354,   56,   66,  275,  297,  169,  299,
 /*   650 */    83,  297,  190,  191,  194,    2,  367,  300,  244,   83,
 /*   660 */   371,    8,    9,  292,  222,   12,   13,   14,   15,   16,
 /*   670 */    82,   35,  105,   85,  164,  325,  166,   39,  328,  329,
 /*   680 */   330,  331,  332,  333,    0,  335,  119,  120,    0,  210,
 /*   690 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  151,
 /*   700 */   190,  191,   66,  193,  194,  195,  196,  197,  198,  199,
 /*   710 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   720 */     8,    9,  372,  373,   12,   13,   14,   15,   16,  326,
 /*   730 */   326,  164,   48,  166,    2,  270,  271,   43,  299,  309,
 /*   740 */     8,    9,  312,   37,   12,   13,   14,   15,   16,  310,
 /*   750 */   284,   20,  264,  350,  350,  151,  194,  190,  191,  293,
 /*   760 */   193,  194,  195,  196,  197,  198,  199,  200,  201,  202,
 /*   770 */   203,  204,  205,  206,  207,  208,  209,   12,   13,   18,
 /*   780 */   292,   20,  285,   95,  272,   20,  274,   22,   27,  256,
 /*   790 */   146,   30,   86,  256,   88,   89,   84,   91,   33,    4,
 /*   800 */    35,   95,  114,  115,  116,  117,  118,  285,   47,  318,
 /*   810 */    49,  294,   51,  169,  297,  256,  264,  284,  114,  256,
 /*   820 */   332,   56,  273,  117,  285,  292,    4,  275,  285,  264,
 /*   830 */   297,   66,  299,  256,  297,  347,  348,  349,  256,  351,
 /*   840 */   275,   19,  285,   82,  292,    8,    9,  257,   83,   12,
 /*   850 */    13,   14,   15,   16,  210,   33,  297,  292,  325,  221,
 /*   860 */   297,  328,  329,  330,  331,  332,  333,  256,  335,   47,
 /*   870 */   105,  338,  285,   51,  297,  342,  343,   43,   56,  297,
 /*   880 */   176,  177,  151,  122,  119,  120,  125,  126,  127,  128,
 /*   890 */   129,  130,  131,  132,  133,  134,  135,  136,  137,  138,
 /*   900 */   139,  140,  141,  142,   82,  144,  145,   85,  297,  374,
 /*   910 */   256,  264,  264,   18,  264,  264,  294,  265,   23,  297,
 /*   920 */    44,   45,  275,  275,   60,  275,  275,   87,   95,  164,
 /*   930 */    90,  166,   37,   38,  277,  241,   41,  280,   87,  292,
 /*   940 */   292,   90,  292,  292,  220,  221,  256,  321,  256,  365,
 /*   950 */   117,  297,   57,   58,  256,  190,  191,  256,  193,  194,
 /*   960 */   195,  196,  197,  198,  199,  200,  201,  202,  203,  204,
 /*   970 */   205,  206,  207,  208,  209,  264,  284,  264,   83,  264,
 /*   980 */    35,  264,   42,   43,  292,  256,  275,  297,  275,  297,
 /*   990 */   275,  299,  275,    0,   35,  297,   43,  256,  297,   87,
 /*  1000 */   256,  256,   90,  292,   43,  292,  314,  292,   87,  292,
 /*  1010 */     0,   90,  151,  152,   56,   22,  121,  325,  223,   43,
 /*  1020 */   328,  329,  330,  331,  332,  333,  297,  335,    0,   43,
 /*  1030 */   338,   43,   22,  256,  342,  343,  361,   84,  297,    1,
 /*  1040 */     2,  297,  297,   85,   43,   84,  354,  119,  120,   43,
 /*  1050 */    22,  156,  157,  158,  190,   43,  161,   43,   43,  367,
 /*  1060 */    84,  284,  167,  371,   35,  284,  265,  263,  296,  292,
 /*  1070 */    84,  352,   84,   43,  297,  180,  299,  243,  183,  327,
 /*  1080 */   185,  186,  187,  188,  189,   84,   43,   43,  256,   43,
 /*  1090 */    84,   43,  345,   43,   83,   66,   84,  355,   84,   84,
 /*  1100 */    20,  368,  325,  368,   93,  328,  329,  330,  331,  332,
 /*  1110 */   333,  166,  335,  224,   84,  338,  284,  222,  368,  342,
 /*  1120 */   343,  344,  323,  264,  292,  166,   47,   84,   84,  297,
 /*  1130 */    84,  299,   84,  356,   84,  322,   35,  270,  264,  162,
 /*  1140 */   316,  364,  264,  256,   42,  304,  146,  302,  302,  264,
 /*  1150 */   264,   20,  258,   20,  258,  320,  268,  325,  268,  299,
 /*  1160 */   328,  329,  330,  331,  332,  333,   20,  335,  313,   20,
 /*  1170 */   338,  284,  315,  268,  342,  343,  344,  268,  313,  292,
 /*  1180 */    20,  268,  305,  268,  297,  268,  299,  264,  258,  264,
 /*  1190 */   284,  284,  284,  258,  284,  284,  364,  297,  284,  320,
 /*  1200 */   284,  319,  284,  284,  284,  256,  284,  266,  172,  266,
 /*  1210 */   264,  264,  325,   20,  313,  328,  329,  330,  331,  332,
 /*  1220 */   333,  266,  335,  299,  327,  338,  297,  230,  360,  342,
 /*  1230 */   343,  344,  229,  284,  308,  297,  297,  155,  236,  308,
 /*  1240 */   353,  292,   12,   13,  360,  297,  297,  238,  299,  225,
 /*  1250 */   237,  359,   22,  221,  363,  362,  323,  358,  360,  357,
 /*  1260 */   292,   20,  326,   33,  242,   35,  240,   83,  245,  297,
 /*  1270 */   308,  297,  369,  256,  325,  297,  297,  328,  329,  330,
 /*  1280 */   331,  332,  333,  308,  335,  148,   56,  338,  297,  297,
 /*  1290 */   306,  342,  343,  344,  305,  341,   66,  370,  280,  292,
 /*  1300 */   266,  284,  353,  266,  370,   83,  369,  375,  292,  292,
 /*  1310 */    36,  264,  370,  369,  297,  288,  299,  297,  266,  274,
 /*  1320 */   259,  258,  317,  267,  254,    0,    0,  278,   42,  278,
 /*  1330 */     0,  312,  278,   74,    0,  105,   35,  184,   35,   35,
 /*  1340 */   256,   35,  325,   33,    0,  328,  329,  330,  331,  332,
 /*  1350 */   333,  184,  335,   35,   35,  338,  184,   47,    0,  342,
 /*  1360 */   343,  344,   52,   53,   54,   55,   56,  184,  284,    0,
 /*  1370 */   353,   35,    0,   22,    0,   35,  292,    0,   83,  169,
 /*  1380 */   168,  297,    0,  299,  166,  164,    0,  160,  159,    0,
 /*  1390 */     0,   46,   82,    0,  164,   85,  166,  143,  314,    0,
 /*  1400 */     0,    0,    0,    0,    0,    0,  138,    0,   35,  325,
 /*  1410 */   138,    0,  328,  329,  330,  331,  332,  333,  256,  335,
 /*  1420 */   190,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 /*  1430 */     0,  201,  202,  203,  204,  205,  206,  207,  354,    0,
 /*  1440 */     0,    0,    0,    0,    0,    0,  284,    0,   42,    0,
 /*  1450 */     0,  367,    0,   22,  292,  371,    0,  147,  148,  297,
 /*  1460 */   150,  299,    0,    0,  154,   56,    0,    0,   14,   14,
 /*  1470 */     0,    0,  256,   39,   42,    0,  314,   40,   43,   46,
 /*  1480 */     0,    0,   46,  173,  155,   39,    0,  325,    0,    0,
 /*  1490 */   328,  329,  330,  331,  332,  333,   39,  335,    0,  256,
 /*  1500 */   284,    0,    0,   35,   39,   47,   47,   35,  292,   61,
 /*  1510 */     0,   35,   39,  297,   35,  299,  354,   39,    0,    0,
 /*  1520 */     0,   47,    0,   39,    0,   35,   22,  284,   90,  367,
 /*  1530 */    47,   35,   35,  371,   35,  292,    0,   43,   35,    0,
 /*  1540 */   297,  325,  299,   92,  328,  329,  330,  331,  332,  333,
 /*  1550 */    43,  335,   35,  256,  338,   22,   35,   22,  342,  343,
 /*  1560 */    35,   49,    0,   22,   35,    0,   35,    0,  325,   35,
 /*  1570 */     0,  328,  329,  330,  331,  332,  333,  334,  335,  336,
 /*  1580 */   337,  284,   22,   20,    0,   35,    0,  170,   22,  292,
 /*  1590 */     0,    0,    0,    0,  297,    0,  299,   43,   83,   43,
 /*  1600 */    84,  226,  226,  256,  151,  220,   83,   43,    2,  148,
 /*  1610 */    84,  151,   84,   83,   46,  151,   84,   46,   43,   46,
 /*  1620 */    83,   83,  325,   83,   43,  328,  329,  330,  331,  332,
 /*  1630 */   333,  284,  335,   84,   46,  338,   84,   84,  153,  292,
 /*  1640 */   343,   43,  226,   35,  297,   84,  299,   35,   35,   35,
 /*  1650 */    35,   35,   43,  256,   22,    0,   84,   83,  311,  190,
 /*  1660 */    84,   83,   83,   46,   46,   83,  179,   84,   83,  256,
 /*  1670 */     0,   84,  325,   39,  192,  328,  329,  330,  331,  332,
 /*  1680 */   333,  284,  335,   83,   83,   83,   83,   93,   46,  292,
 /*  1690 */    46,  149,  147,   83,  297,   84,  299,  284,   22,   94,
 /*  1700 */    35,   35,   83,   35,   84,  292,   84,   83,   83,   35,
 /*  1710 */   297,   84,  299,   83,   35,   84,   83,   22,   35,   84,
 /*  1720 */    83,   95,  325,   35,   83,  328,  329,  330,  331,  332,
 /*  1730 */   333,   83,  335,  256,   83,  107,  107,   43,  325,   22,
 /*  1740 */    60,  328,  329,  330,  331,  332,  333,   61,  335,  256,
 /*  1750 */   107,   35,  107,   66,   81,   43,   35,   35,   35,   35,
 /*  1760 */    35,  284,   22,  366,   35,   35,   66,   35,   35,  292,
 /*  1770 */    35,   35,   35,   35,  297,    0,  299,  284,   35,   35,
 /*  1780 */    39,   47,    0,   35,   39,  292,  373,    0,  311,   47,
 /*  1790 */   297,   35,  299,   47,   39,    0,   35,   47,   39,  256,
 /*  1800 */     0,   35,  325,   35,    0,  328,  329,  330,  331,  332,
 /*  1810 */   333,   22,  335,   21,   21,  256,   22,  376,  325,   22,
 /*  1820 */   376,  328,  329,  330,  331,  332,  333,  284,  335,   20,
 /*  1830 */   337,  376,  376,  376,  376,  292,  376,  376,  376,  376,
 /*  1840 */   297,  376,  299,  284,  376,  376,  376,  376,  376,  376,
 /*  1850 */   376,  292,  376,  376,  311,  376,  297,  376,  299,  376,
 /*  1860 */   376,  376,  376,  376,  376,  376,  376,  376,  325,  376,
 /*  1870 */   311,  328,  329,  330,  331,  332,  333,  376,  335,  256,
 /*  1880 */   376,  376,  376,  376,  325,  376,  376,  328,  329,  330,
 /*  1890 */   331,  332,  333,  376,  335,  376,  256,  376,  376,  376,
 /*  1900 */   376,  376,  376,  376,  376,  376,  376,  284,  376,  376,
 /*  1910 */   376,  376,  376,  376,  376,  292,  376,  376,  376,  376,
 /*  1920 */   297,  376,  299,  376,  284,  376,  376,  376,  376,  376,
 /*  1930 */   376,  376,  292,  376,  376,  376,  376,  297,  256,  299,
 /*  1940 */   376,  376,  376,  376,  376,  376,  376,  376,  325,  376,
 /*  1950 */   376,  328,  329,  330,  331,  332,  333,  376,  335,  376,
 /*  1960 */   376,  376,  256,  376,  376,  325,  284,  376,  328,  329,
 /*  1970 */   330,  331,  332,  333,  292,  335,  376,  376,  376,  297,
 /*  1980 */   376,  299,  376,  376,  376,  376,  376,  376,  376,  376,
 /*  1990 */   284,  376,  376,  376,  376,  376,  376,  376,  292,  376,
 /*  2000 */   376,  376,  376,  297,  376,  299,  376,  325,  376,  376,
 /*  2010 */   328,  329,  330,  331,  332,  333,  376,  335,  256,  376,
 /*  2020 */   376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
 /*  2030 */   376,  325,  376,  376,  328,  329,  330,  331,  332,  333,
 /*  2040 */   376,  335,  256,  376,  376,  376,  284,  376,  376,  376,
 /*  2050 */   376,  376,  376,  376,  292,  376,  376,  376,  376,  297,
 /*  2060 */   376,  299,  376,  376,  376,  376,  376,  376,  376,  376,
 /*  2070 */   284,  376,  376,  376,  376,  376,  376,  376,  292,  376,
 /*  2080 */   376,  376,  376,  297,  256,  299,  376,  325,  376,  376,
 /*  2090 */   328,  329,  330,  331,  332,  333,  376,  335,  376,  376,
 /*  2100 */   256,  376,  376,  376,  376,  376,  376,  376,  376,  376,
 /*  2110 */   376,  325,  284,  376,  328,  329,  330,  331,  332,  333,
 /*  2120 */   292,  335,  376,  376,  376,  297,  376,  299,  284,  376,
 /*  2130 */   376,  376,  376,  376,  376,  376,  292,  376,  376,  376,
 /*  2140 */   376,  297,  376,  299,  376,  376,  376,  376,  376,  376,
 /*  2150 */   376,  376,  376,  325,  376,  376,  328,  329,  330,  331,
 /*  2160 */   332,  333,  376,  335,  256,  376,  376,  376,  376,  325,
 /*  2170 */   376,  376,  328,  329,  330,  331,  332,  333,  376,  335,
 /*  2180 */   376,  256,  376,  376,  376,  376,  376,  376,  376,  376,
 /*  2190 */   376,  376,  284,  376,  376,  376,  376,  376,  376,  376,
 /*  2200 */   292,  376,  376,  376,  376,  297,  376,  299,  376,  284,
 /*  2210 */   376,  376,  376,  376,  376,  376,  376,  292,  376,  376,
 /*  2220 */   376,  376,  297,  256,  299,  376,  376,  376,  376,  376,
 /*  2230 */   376,  376,  376,  325,  376,  376,  328,  329,  330,  331,
 /*  2240 */   332,  333,  376,  335,  376,  376,  376,  256,  376,  376,
 /*  2250 */   325,  284,  376,  328,  329,  330,  331,  332,  333,  292,
 /*  2260 */   335,  376,  376,  376,  297,  376,  299,  376,  376,  376,
 /*  2270 */   376,  376,  376,  376,  376,  284,  376,  376,  376,  376,
 /*  2280 */   376,  376,  376,  292,  376,  376,  376,  376,  297,  376,
 /*  2290 */   299,  376,  325,  376,  376,  328,  329,  330,  331,  332,
 /*  2300 */   333,  376,  335,  256,  376,  376,  376,  376,  376,  376,
 /*  2310 */   376,  376,  376,  376,  376,  376,  325,  376,  376,  328,
 /*  2320 */   329,  330,  331,  332,  333,  376,  335,  256,  376,  376,
 /*  2330 */   376,  284,  376,  376,  376,  376,  376,  376,  376,  292,
 /*  2340 */   376,  376,  376,  376,  297,  376,  299,  376,  376,  376,
 /*  2350 */   376,  376,  376,  376,  376,  284,  376,  376,  376,  376,
 /*  2360 */   376,  376,  376,  292,  376,  376,  376,  376,  297,  256,
 /*  2370 */   299,  376,  325,  376,  376,  328,  329,  330,  331,  332,
 /*  2380 */   333,  376,  335,  376,  376,  256,  376,  376,  376,  376,
 /*  2390 */   376,  376,  376,  376,  376,  376,  325,  284,  376,  328,
 /*  2400 */   329,  330,  331,  332,  333,  292,  335,  376,  376,  376,
 /*  2410 */   297,  376,  299,  284,  376,  376,  376,  376,  376,  376,
 /*  2420 */   376,  292,  376,  376,  376,  376,  297,  376,  299,  376,
 /*  2430 */   376,  376,  376,  376,  376,  376,  376,  376,  325,  376,
 /*  2440 */   376,  328,  329,  330,  331,  332,  333,  376,  335,  256,
 /*  2450 */   376,  376,  376,  376,  325,  376,  376,  328,  329,  330,
 /*  2460 */   331,  332,  333,  376,  335,  376,  256,  376,  376,  376,
 /*  2470 */   376,  376,  376,  376,  376,  376,  376,  284,  376,  376,
 /*  2480 */   376,  376,  376,  376,  376,  292,  376,  376,  376,  376,
 /*  2490 */   297,  376,  299,  376,  284,  376,  376,  376,  376,  376,
 /*  2500 */   376,  376,  292,  376,  376,  376,  376,  297,  256,  299,
 /*  2510 */   376,  376,  376,  376,  376,  376,  376,  376,  325,  376,
 /*  2520 */   376,  328,  329,  330,  331,  332,  333,  376,  335,  376,
 /*  2530 */   376,  376,  256,  376,  376,  325,  284,  376,  328,  329,
 /*  2540 */   330,  331,  332,  333,  292,  335,  376,  376,  376,  297,
 /*  2550 */   376,  299,  376,  376,  376,  376,  376,  376,  376,  376,
 /*  2560 */   284,  376,  376,  376,  376,  376,  376,  376,  292,  376,
 /*  2570 */   376,  376,  376,  297,  376,  299,  376,  325,  376,  376,
 /*  2580 */   328,  329,  330,  331,  332,  333,  376,  335,  376,  376,
 /*  2590 */   376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
 /*  2600 */   376,  325,  376,  376,  328,  329,  330,  331,  332,  333,
 /*  2610 */   376,  335,
};
#define YY_SHIFT_COUNT    (655)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1809)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   895,    0,    0,   57,   57,  255,  255,  255,  312,  312,
 /*    10 */   255,  255,  510,  567,  765,  567,  567,  567,  567,  567,
 /*    20 */   567,  567,  567,  567,  567,  567,  567,  567,  567,  567,
 /*    30 */   567,  567,  567,  567,  567,  567,  567,  567,  567,  567,
 /*    40 */   567,  567,   47,   47,   96,   96,   96, 1230, 1230, 1230,
 /*    50 */  1230,  442,   50,  263,   65,   65,   64,   64,   54,  261,
 /*    60 */   263,  263,   65,   65,   65,   65,   65,   65,   65,   65,
 /*    70 */    59,   65,   65,   65,  121,  323,  405,   65,   65,  405,
 /*    80 */    65,  405,  405,  405,   65,  408,  761,  224,  479,  479,
 /*    90 */    13,  266,  462,  462,  462,  462,  462,  462,  462,  462,
 /*   100 */   462,  462,  462,  462,  462,  462,  462,  462,  462,  462,
 /*   110 */   462,  706,  261,  524,  524,  285,  636,  548,  548,  548,
 /*   120 */   542,  636,  455,  323,    5,    5,  405,  405,  573,  573,
 /*   130 */   484,  579,  253,  253,  253,  253,  253,  253,  253,  128,
 /*   140 */   531,   81,  414,  364,   41,  105,   43,  145,  460,  515,
 /*   150 */   876,  833,  731,  724,  638,  724,  940,  157,  157,  157,
 /*   160 */   795,  562,  889, 1080, 1079, 1101,  977, 1080, 1080, 1102,
 /*   170 */  1000, 1000, 1080, 1080, 1131, 1131, 1133,   59,  323,   59,
 /*   180 */  1146, 1149,   59, 1146,   59, 1160,   59,   59, 1080,   59,
 /*   190 */  1131,  405,  405,  405,  405,  405,  405,  405,  405,  405,
 /*   200 */   405,  405, 1080, 1131,  573, 1133,  408, 1036,  323,  408,
 /*   210 */  1080, 1080, 1146,  408, 1193,  573,  997, 1003,  573,  997,
 /*   220 */  1003,  573,  573,  405, 1002, 1082,  997, 1009, 1013, 1024,
 /*   230 */   889, 1032,  455, 1241, 1022, 1026, 1023, 1022, 1026, 1022,
 /*   240 */  1026, 1184, 1003,  573,  573,  573,  573,  573, 1003,  573,
 /*   250 */  1137,  455, 1160,  408,  484,  408,  455, 1222,  573,  579,
 /*   260 */  1080,  408, 1274, 1131, 2612, 2612, 2612, 2612, 2612, 2612,
 /*   270 */  2612,  335, 1310,   72,  822,  203,  375,  457,  653,  732,
 /*   280 */   604,  712,  837,  837,  837,  837,  837,  837,  837,  837,
 /*   290 */   178,  688,  432,   16,   16,  198,  450,  588,  449,   53,
 /*   300 */   223,  644,  467,  467,  467,  467,  704,  187,  953,  840,
 /*   310 */   851,  912,  921,  993, 1010, 1028,  958,  861,  961,  976,
 /*   320 */  1038,  928,  694,  834,  986,  864,  988,  576, 1001, 1006,
 /*   330 */  1012, 1014, 1015,  945,  959, 1030, 1043, 1044, 1046, 1048,
 /*   340 */  1050, 1011, 1029,  684, 1325, 1326, 1286, 1330, 1259, 1334,
 /*   350 */  1301, 1153, 1303, 1304, 1306, 1167, 1344, 1318, 1319, 1172,
 /*   360 */  1358, 1183, 1369, 1336, 1372, 1351, 1374, 1340, 1377, 1295,
 /*   370 */  1210, 1212, 1218, 1221, 1382, 1386, 1227, 1229, 1389, 1390,
 /*   380 */  1345, 1393, 1399, 1400, 1254, 1401, 1402, 1403, 1404, 1405,
 /*   390 */  1268, 1373, 1407, 1272, 1411, 1421, 1422, 1423, 1424, 1425,
 /*   400 */  1426, 1427, 1428, 1429, 1430, 1439, 1440, 1441, 1406, 1442,
 /*   410 */  1443, 1444, 1445, 1447, 1449, 1431, 1450, 1452, 1456, 1462,
 /*   420 */  1463, 1409, 1466, 1467, 1432, 1434, 1435, 1454, 1433, 1455,
 /*   430 */  1436, 1470, 1437, 1446, 1471, 1475, 1480, 1457, 1329, 1481,
 /*   440 */  1486, 1488, 1448, 1489, 1498, 1468, 1458, 1465, 1501, 1472,
 /*   450 */  1459, 1473, 1502, 1476, 1474, 1478, 1510, 1479, 1483, 1484,
 /*   460 */  1518, 1519, 1520, 1522, 1451, 1438, 1490, 1504, 1524, 1496,
 /*   470 */  1497, 1499, 1503, 1494, 1507, 1517, 1521, 1525, 1536, 1533,
 /*   480 */  1539, 1535, 1512, 1562, 1541, 1529, 1565, 1531, 1567, 1534,
 /*   490 */  1570, 1560, 1563, 1584, 1453, 1550, 1586, 1417, 1566, 1460,
 /*   500 */  1461, 1590, 1591, 1464, 1485, 1592, 1593, 1595, 1554, 1375,
 /*   510 */  1515, 1516, 1523, 1526, 1556, 1528, 1530, 1537, 1538, 1532,
 /*   520 */  1564, 1568, 1571, 1540, 1575, 1376, 1549, 1552, 1573, 1385,
 /*   530 */  1581, 1588, 1553, 1598, 1416, 1561, 1608, 1612, 1613, 1614,
 /*   540 */  1615, 1616, 1561, 1606, 1469, 1609, 1572, 1574, 1576, 1617,
 /*   550 */  1578, 1579, 1618, 1632, 1482, 1582, 1583, 1587, 1585, 1487,
 /*   560 */  1655, 1600, 1542, 1601, 1670, 1634, 1545, 1602, 1594, 1642,
 /*   570 */  1644, 1603, 1611, 1610, 1676, 1619, 1605, 1620, 1665, 1666,
 /*   580 */  1624, 1622, 1668, 1625, 1627, 1674, 1630, 1631, 1679, 1633,
 /*   590 */  1635, 1683, 1637, 1628, 1629, 1643, 1645, 1695, 1626, 1641,
 /*   600 */  1648, 1688, 1651, 1694, 1694, 1717, 1686, 1680, 1716, 1687,
 /*   610 */  1673, 1712, 1721, 1722, 1723, 1724, 1725, 1740, 1729, 1730,
 /*   620 */  1700, 1494, 1732, 1507, 1733, 1735, 1736, 1737, 1738, 1743,
 /*   630 */  1775, 1744, 1734, 1741, 1782, 1748, 1742, 1745, 1787, 1756,
 /*   640 */  1746, 1755, 1795, 1761, 1750, 1759, 1800, 1766, 1768, 1804,
 /*   650 */  1789, 1792, 1794, 1797, 1793, 1809,
};
#define YY_REDUCE_COUNT (270)
#define YY_REDUCE_MIN   (-289)
#define YY_REDUCE_MAX   (2276)
static const short yy_reduce_ofst[] = {
 /*     0 */   -65, -204,  692,  777,  832,  887,  949, 1017, 1084, 1162,
 /*    10 */   533, 1216, 1243,  350, 1297, 1347, 1397, 1413, 1477, 1493,
 /*    20 */  1543, 1559, 1623, 1640, 1682, 1706, 1762, 1786, 1828, 1844,
 /*    30 */  1908, 1925, 1967, 1991, 2047, 2071, 2113, 2129, 2193, 2210,
 /*    40 */  2252, 2276,  237,  289, -178, -106,  488, -278, -271, -276,
 /*    50 */  -213, -289, -182, -140,   22,  204, -260, -256, -218, -153,
 /*    60 */   -49,  -44,   34,  300,  319,  371,  552,  565,  647,  648,
 /*    70 */  -267,  650,  651,  711, -275, -283,   -2,   56,  713,  -56,
 /*    80 */   715,   93,  101,  140,  717, -172,   66, -110, -110, -110,
 /*    90 */    62,  231,  123,  243,  277,  280,  354,  537,  559,  563,
 /*   100 */   577,  582,  611,  654,  690,  698,  701,  729,  741,  744,
 /*   110 */   745, -221, -248,   39,  183,  104,  219,  264,  403,  404,
 /*   120 */   211,  465,   79,  439,  315,  430,  466,  357,  517,  622,
 /*   130 */   657,  512, -249,  497,  522,  539,  543,  557,  587,  491,
 /*   140 */   590,  549,  535,  584,  652,  626,  675,  781,  781,  801,
 /*   150 */   804,  772,  752,  719,  719,  719,  747,  733,  735,  750,
 /*   160 */   742,  781,  799,  859,  813,  867,  824,  874,  878,  841,
 /*   170 */   845,  846,  885,  886,  894,  896,  835,  888,  860,  890,
 /*   180 */   855,  857,  905,  865,  909,  877,  913,  915,  923,  917,
 /*   190 */   930,  906,  907,  908,  910,  911,  914,  916,  918,  919,
 /*   200 */   920,  922,  925,  935,  900,  879,  941,  882,  924,  943,
 /*   210 */   946,  947,  901,  955,  897,  929,  868,  926,  938,  884,
 /*   220 */   931,  939,  948,  781,  891,  893,  898,  892,  899,  902,
 /*   230 */   933,  719,  968,  936,  927,  903,  932,  934,  937,  942,
 /*   240 */   944,  954,  962,  972,  974,  978,  979,  991,  975,  992,
 /*   250 */   984, 1007,  989, 1034, 1018, 1037, 1016, 1027, 1020, 1045,
 /*   260 */  1047, 1052, 1061, 1063, 1005, 1019, 1049, 1051, 1054, 1056,
 /*   270 */  1070,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*    10 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*    20 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*    30 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*    40 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*    50 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*    60 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*    70 */  1514, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*    80 */  1441, 1441, 1441, 1441, 1441, 1512, 1665, 1441, 1841, 1441,
 /*    90 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   100 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   110 */  1441, 1441, 1441, 1441, 1441, 1514, 1441, 1853, 1853, 1853,
 /*   120 */  1512, 1441, 1441, 1441, 1709, 1709, 1441, 1441, 1441, 1441,
 /*   130 */  1608, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1701,
 /*   140 */  1441, 1441, 1922, 1441, 1441, 1707, 1876, 1441, 1441, 1441,
 /*   150 */  1441, 1561, 1868, 1845, 1859, 1846, 1843, 1907, 1907, 1907,
 /*   160 */  1862, 1441, 1872, 1441, 1441, 1441, 1693, 1441, 1441, 1670,
 /*   170 */  1667, 1667, 1441, 1441, 1441, 1441, 1441, 1514, 1441, 1514,
 /*   180 */  1441, 1441, 1514, 1441, 1514, 1441, 1514, 1514, 1441, 1514,
 /*   190 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   200 */  1441, 1441, 1441, 1441, 1441, 1441, 1512, 1703, 1441, 1512,
 /*   210 */  1441, 1441, 1441, 1512, 1441, 1441, 1883, 1881, 1441, 1883,
 /*   220 */  1881, 1441, 1441, 1441, 1895, 1891, 1883, 1899, 1897, 1874,
 /*   230 */  1872, 1859, 1441, 1441, 1913, 1909, 1925, 1913, 1909, 1913,
 /*   240 */  1909, 1441, 1881, 1441, 1441, 1441, 1441, 1441, 1881, 1441,
 /*   250 */  1441, 1441, 1441, 1512, 1441, 1512, 1441, 1577, 1441, 1441,
 /*   260 */  1441, 1512, 1473, 1441, 1695, 1709, 1611, 1611, 1611, 1515,
 /*   270 */  1446, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   280 */  1441, 1441, 1779, 1894, 1893, 1817, 1816, 1815, 1813, 1778,
 /*   290 */  1441, 1441, 1573, 1777, 1776, 1441, 1441, 1441, 1441, 1441,
 /*   300 */  1441, 1441, 1770, 1771, 1769, 1768, 1441, 1441, 1441, 1441,
 /*   310 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   320 */  1842, 1441, 1910, 1914, 1441, 1441, 1441, 1753, 1441, 1441,
 /*   330 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   340 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   350 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   360 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   370 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   380 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   390 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   400 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   410 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   420 */  1441, 1441, 1441, 1441, 1441, 1441, 1478, 1441, 1441, 1441,
 /*   430 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   440 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   450 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   460 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   470 */  1441, 1441, 1441, 1542, 1541, 1441, 1441, 1441, 1441, 1441,
 /*   480 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   490 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   500 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1875, 1441,
 /*   510 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   520 */  1441, 1441, 1753, 1441, 1892, 1441, 1852, 1848, 1441, 1441,
 /*   530 */  1844, 1441, 1441, 1908, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   540 */  1441, 1441, 1441, 1837, 1441, 1810, 1441, 1441, 1441, 1441,
 /*   550 */  1441, 1441, 1441, 1441, 1764, 1441, 1441, 1441, 1441, 1441,
 /*   560 */  1713, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1752,
 /*   570 */  1441, 1795, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   580 */  1605, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   590 */  1441, 1441, 1441, 1590, 1588, 1587, 1586, 1441, 1583, 1441,
 /*   600 */  1441, 1441, 1441, 1614, 1613, 1441, 1441, 1441, 1441, 1441,
 /*   610 */  1441, 1534, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   620 */  1441, 1525, 1441, 1524, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   630 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   640 */  1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441,
 /*   650 */  1441, 1441, 1441, 1441, 1441, 1441,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  246,  /*  NK_BITNOT => ID */
  246,  /*     INSERT => ID */
  246,  /*     VALUES => ID */
  246,  /*     IMPORT => ID */
  246,  /*    NK_SEMI => ID */
  246,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "IF",
  /*   60 */ "NOT",
  /*   61 */ "EXISTS",
  /*   62 */ "BUFFER",
  /*   63 */ "CACHELAST",
  /*   64 */ "COMP",
  /*   65 */ "DURATION",
  /*   66 */ "NK_VARIABLE",
  /*   67 */ "FSYNC",
  /*   68 */ "MAXROWS",
  /*   69 */ "MINROWS",
  /*   70 */ "KEEP",
  /*   71 */ "PAGES",
  /*   72 */ "PAGESIZE",
  /*   73 */ "PRECISION",
  /*   74 */ "REPLICA",
  /*   75 */ "STRICT",
  /*   76 */ "WAL",
  /*   77 */ "VGROUPS",
  /*   78 */ "SINGLE_STABLE",
  /*   79 */ "RETENTIONS",
  /*   80 */ "SCHEMALESS",
  /*   81 */ "NK_COLON",
  /*   82 */ "TABLE",
  /*   83 */ "NK_LP",
  /*   84 */ "NK_RP",
  /*   85 */ "STABLE",
  /*   86 */ "ADD",
  /*   87 */ "COLUMN",
  /*   88 */ "MODIFY",
  /*   89 */ "RENAME",
  /*   90 */ "TAG",
  /*   91 */ "SET",
  /*   92 */ "NK_EQ",
  /*   93 */ "USING",
  /*   94 */ "TAGS",
  /*   95 */ "COMMENT",
  /*   96 */ "BOOL",
  /*   97 */ "TINYINT",
  /*   98 */ "SMALLINT",
  /*   99 */ "INT",
  /*  100 */ "INTEGER",
  /*  101 */ "BIGINT",
  /*  102 */ "FLOAT",
  /*  103 */ "DOUBLE",
  /*  104 */ "BINARY",
  /*  105 */ "TIMESTAMP",
  /*  106 */ "NCHAR",
  /*  107 */ "UNSIGNED",
  /*  108 */ "JSON",
  /*  109 */ "VARCHAR",
  /*  110 */ "MEDIUMBLOB",
  /*  111 */ "BLOB",
  /*  112 */ "VARBINARY",
  /*  113 */ "DECIMAL",
  /*  114 */ "MAX_DELAY",
  /*  115 */ "WATERMARK",
  /*  116 */ "ROLLUP",
  /*  117 */ "TTL",
  /*  118 */ "SMA",
  /*  119 */ "FIRST",
  /*  120 */ "LAST",
  /*  121 */ "SHOW",
  /*  122 */ "DATABASES",
  /*  123 */ "TABLES",
  /*  124 */ "STABLES",
  /*  125 */ "MNODES",
  /*  126 */ "MODULES",
  /*  127 */ "QNODES",
  /*  128 */ "FUNCTIONS",
  /*  129 */ "INDEXES",
  /*  130 */ "ACCOUNTS",
  /*  131 */ "APPS",
  /*  132 */ "CONNECTIONS",
  /*  133 */ "LICENCE",
  /*  134 */ "GRANTS",
  /*  135 */ "QUERIES",
  /*  136 */ "SCORES",
  /*  137 */ "TOPICS",
  /*  138 */ "VARIABLES",
  /*  139 */ "BNODES",
  /*  140 */ "SNODES",
  /*  141 */ "CLUSTER",
  /*  142 */ "TRANSACTIONS",
  /*  143 */ "DISTRIBUTED",
  /*  144 */ "CONSUMERS",
  /*  145 */ "SUBSCRIPTIONS",
  /*  146 */ "LIKE",
  /*  147 */ "INDEX",
  /*  148 */ "FUNCTION",
  /*  149 */ "INTERVAL",
  /*  150 */ "TOPIC",
  /*  151 */ "AS",
  /*  152 */ "WITH",
  /*  153 */ "META",
  /*  154 */ "CONSUMER",
  /*  155 */ "GROUP",
  /*  156 */ "DESC",
  /*  157 */ "DESCRIBE",
  /*  158 */ "RESET",
  /*  159 */ "QUERY",
  /*  160 */ "CACHE",
  /*  161 */ "EXPLAIN",
  /*  162 */ "ANALYZE",
  /*  163 */ "VERBOSE",
  /*  164 */ "NK_BOOL",
  /*  165 */ "RATIO",
  /*  166 */ "NK_FLOAT",
  /*  167 */ "COMPACT",
  /*  168 */ "VNODES",
  /*  169 */ "IN",
  /*  170 */ "OUTPUTTYPE",
  /*  171 */ "AGGREGATE",
  /*  172 */ "BUFSIZE",
  /*  173 */ "STREAM",
  /*  174 */ "INTO",
  /*  175 */ "TRIGGER",
  /*  176 */ "AT_ONCE",
  /*  177 */ "WINDOW_CLOSE",
  /*  178 */ "IGNORE",
  /*  179 */ "EXPIRED",
  /*  180 */ "KILL",
  /*  181 */ "CONNECTION",
  /*  182 */ "TRANSACTION",
  /*  183 */ "BALANCE",
  /*  184 */ "VGROUP",
  /*  185 */ "MERGE",
  /*  186 */ "REDISTRIBUTE",
  /*  187 */ "SPLIT",
  /*  188 */ "SYNCDB",
  /*  189 */ "DELETE",
  /*  190 */ "NULL",
  /*  191 */ "NK_QUESTION",
  /*  192 */ "NK_ARROW",
  /*  193 */ "ROWTS",
  /*  194 */ "TBNAME",
  /*  195 */ "QSTARTTS",
  /*  196 */ "QENDTS",
  /*  197 */ "WSTARTTS",
  /*  198 */ "WENDTS",
  /*  199 */ "WDURATION",
  /*  200 */ "CAST",
  /*  201 */ "NOW",
  /*  202 */ "TODAY",
  /*  203 */ "TIMEZONE",
  /*  204 */ "CLIENT_VERSION",
  /*  205 */ "SERVER_VERSION",
  /*  206 */ "SERVER_STATUS",
  /*  207 */ "CURRENT_USER",
  /*  208 */ "COUNT",
  /*  209 */ "LAST_ROW",
  /*  210 */ "BETWEEN",
  /*  211 */ "IS",
  /*  212 */ "NK_LT",
  /*  213 */ "NK_GT",
  /*  214 */ "NK_LE",
  /*  215 */ "NK_GE",
  /*  216 */ "NK_NE",
  /*  217 */ "MATCH",
  /*  218 */ "NMATCH",
  /*  219 */ "CONTAINS",
  /*  220 */ "JOIN",
  /*  221 */ "INNER",
  /*  222 */ "SELECT",
  /*  223 */ "DISTINCT",
  /*  224 */ "WHERE",
  /*  225 */ "PARTITION",
  /*  226 */ "BY",
  /*  227 */ "SESSION",
  /*  228 */ "STATE_WINDOW",
  /*  229 */ "SLIDING",
  /*  230 */ "FILL",
  /*  231 */ "VALUE",
  /*  232 */ "NONE",
  /*  233 */ "PREV",
  /*  234 */ "LINEAR",
  /*  235 */ "NEXT",
  /*  236 */ "HAVING",
  /*  237 */ "RANGE",
  /*  238 */ "EVERY",
  /*  239 */ "ORDER",
  /*  240 */ "SLIMIT",
  /*  241 */ "SOFFSET",
  /*  242 */ "LIMIT",
  /*  243 */ "OFFSET",
  /*  244 */ "ASC",
  /*  245 */ "NULLS",
  /*  246 */ "ID",
  /*  247 */ "NK_BITNOT",
  /*  248 */ "INSERT",
  /*  249 */ "VALUES",
  /*  250 */ "IMPORT",
  /*  251 */ "NK_SEMI",
  /*  252 */ "FILE",
  /*  253 */ "cmd",
  /*  254 */ "account_options",
  /*  255 */ "alter_account_options",
  /*  256 */ "literal",
  /*  257 */ "alter_account_option",
  /*  258 */ "user_name",
  /*  259 */ "sysinfo_opt",
  /*  260 */ "privileges",
  /*  261 */ "priv_level",
  /*  262 */ "priv_type_list",
  /*  263 */ "priv_type",
  /*  264 */ "db_name",
  /*  265 */ "dnode_endpoint",
  /*  266 */ "not_exists_opt",
  /*  267 */ "db_options",
  /*  268 */ "exists_opt",
  /*  269 */ "alter_db_options",
  /*  270 */ "integer_list",
  /*  271 */ "variable_list",
  /*  272 */ "retention_list",
  /*  273 */ "alter_db_option",
  /*  274 */ "retention",
  /*  275 */ "full_table_name",
  /*  276 */ "column_def_list",
  /*  277 */ "tags_def_opt",
  /*  278 */ "table_options",
  /*  279 */ "multi_create_clause",
  /*  280 */ "tags_def",
  /*  281 */ "multi_drop_clause",
  /*  282 */ "alter_table_clause",
  /*  283 */ "alter_table_options",
  /*  284 */ "column_name",
  /*  285 */ "type_name",
  /*  286 */ "signed_literal",
  /*  287 */ "create_subtable_clause",
  /*  288 */ "specific_tags_opt",
  /*  289 */ "literal_list",
  /*  290 */ "drop_table_clause",
  /*  291 */ "col_name_list",
  /*  292 */ "table_name",
  /*  293 */ "column_def",
  /*  294 */ "duration_list",
  /*  295 */ "rollup_func_list",
  /*  296 */ "alter_table_option",
  /*  297 */ "duration_literal",
  /*  298 */ "rollup_func_name",
  /*  299 */ "function_name",
  /*  300 */ "col_name",
  /*  301 */ "db_name_cond_opt",
  /*  302 */ "like_pattern_opt",
  /*  303 */ "table_name_cond",
  /*  304 */ "from_db_opt",
  /*  305 */ "index_name",
  /*  306 */ "index_options",
  /*  307 */ "func_list",
  /*  308 */ "sliding_opt",
  /*  309 */ "sma_stream_opt",
  /*  310 */ "func",
  /*  311 */ "expression_list",
  /*  312 */ "stream_options",
  /*  313 */ "topic_name",
  /*  314 */ "query_expression",
  /*  315 */ "cgroup_name",
  /*  316 */ "analyze_opt",
  /*  317 */ "explain_options",
  /*  318 */ "agg_func_opt",
  /*  319 */ "bufsize_opt",
  /*  320 */ "stream_name",
  /*  321 */ "into_opt",
  /*  322 */ "dnode_list",
  /*  323 */ "where_clause_opt",
  /*  324 */ "signed",
  /*  325 */ "literal_func",
  /*  326 */ "table_alias",
  /*  327 */ "column_alias",
  /*  328 */ "expression",
  /*  329 */ "pseudo_column",
  /*  330 */ "column_reference",
  /*  331 */ "function_expression",
  /*  332 */ "subquery",
  /*  333 */ "star_func",
  /*  334 */ "star_func_para_list",
  /*  335 */ "noarg_func",
  /*  336 */ "other_para_list",
  /*  337 */ "star_func_para",
  /*  338 */ "predicate",
  /*  339 */ "compare_op",
  /*  340 */ "in_op",
  /*  341 */ "in_predicate_value",
  /*  342 */ "boolean_value_expression",
  /*  343 */ "boolean_primary",
  /*  344 */ "common_expression",
  /*  345 */ "from_clause_opt",
  /*  346 */ "table_reference_list",
  /*  347 */ "table_reference",
  /*  348 */ "table_primary",
  /*  349 */ "joined_table",
  /*  350 */ "alias_opt",
  /*  351 */ "parenthesized_joined_table",
  /*  352 */ "join_type",
  /*  353 */ "search_condition",
  /*  354 */ "query_specification",
  /*  355 */ "set_quantifier_opt",
  /*  356 */ "select_list",
  /*  357 */ "partition_by_clause_opt",
  /*  358 */ "range_opt",
  /*  359 */ "every_opt",
  /*  360 */ "fill_opt",
  /*  361 */ "twindow_clause_opt",
  /*  362 */ "group_by_clause_opt",
  /*  363 */ "having_clause_opt",
  /*  364 */ "select_item",
  /*  365 */ "fill_mode",
  /*  366 */ "group_by_list",
  /*  367 */ "query_expression_body",
  /*  368 */ "order_by_clause_opt",
  /*  369 */ "slimit_clause_opt",
  /*  370 */ "limit_clause_opt",
  /*  371 */ "query_primary",
  /*  372 */ "sort_specification_list",
  /*  373 */ "sort_specification",
  /*  374 */ "ordering_specification_opt",
  /*  375 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  68 */ "not_exists_opt ::=",
 /*  69 */ "exists_opt ::= IF EXISTS",
 /*  70 */ "exists_opt ::=",
 /*  71 */ "db_options ::=",
 /*  72 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  73 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  74 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  75 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  76 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  77 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  78 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  79 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options KEEP integer_list",
 /*  81 */ "db_options ::= db_options KEEP variable_list",
 /*  82 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  83 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  84 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  85 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  86 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  87 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  88 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  89 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  90 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  91 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  92 */ "alter_db_options ::= alter_db_option",
 /*  93 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  94 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  95 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  96 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  97 */ "alter_db_option ::= KEEP integer_list",
 /*  98 */ "alter_db_option ::= KEEP variable_list",
 /*  99 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 100 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 101 */ "alter_db_option ::= STRICT NK_INTEGER",
 /* 102 */ "alter_db_option ::= WAL NK_INTEGER",
 /* 103 */ "integer_list ::= NK_INTEGER",
 /* 104 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 105 */ "variable_list ::= NK_VARIABLE",
 /* 106 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 107 */ "retention_list ::= retention",
 /* 108 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 109 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 110 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 111 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 112 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 113 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 114 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 115 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 116 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 117 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 118 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 119 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 120 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 121 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 122 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 123 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 124 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 125 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 126 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 127 */ "multi_create_clause ::= create_subtable_clause",
 /* 128 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 129 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 130 */ "multi_drop_clause ::= drop_table_clause",
 /* 131 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 132 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 133 */ "specific_tags_opt ::=",
 /* 134 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 135 */ "full_table_name ::= table_name",
 /* 136 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 137 */ "column_def_list ::= column_def",
 /* 138 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 139 */ "column_def ::= column_name type_name",
 /* 140 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 141 */ "type_name ::= BOOL",
 /* 142 */ "type_name ::= TINYINT",
 /* 143 */ "type_name ::= SMALLINT",
 /* 144 */ "type_name ::= INT",
 /* 145 */ "type_name ::= INTEGER",
 /* 146 */ "type_name ::= BIGINT",
 /* 147 */ "type_name ::= FLOAT",
 /* 148 */ "type_name ::= DOUBLE",
 /* 149 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 150 */ "type_name ::= TIMESTAMP",
 /* 151 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 152 */ "type_name ::= TINYINT UNSIGNED",
 /* 153 */ "type_name ::= SMALLINT UNSIGNED",
 /* 154 */ "type_name ::= INT UNSIGNED",
 /* 155 */ "type_name ::= BIGINT UNSIGNED",
 /* 156 */ "type_name ::= JSON",
 /* 157 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 158 */ "type_name ::= MEDIUMBLOB",
 /* 159 */ "type_name ::= BLOB",
 /* 160 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 161 */ "type_name ::= DECIMAL",
 /* 162 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 163 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 164 */ "tags_def_opt ::=",
 /* 165 */ "tags_def_opt ::= tags_def",
 /* 166 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 167 */ "table_options ::=",
 /* 168 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 169 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 170 */ "table_options ::= table_options WATERMARK duration_list",
 /* 171 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 172 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 173 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 174 */ "alter_table_options ::= alter_table_option",
 /* 175 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 176 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 177 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 178 */ "duration_list ::= duration_literal",
 /* 179 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 180 */ "rollup_func_list ::= rollup_func_name",
 /* 181 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 182 */ "rollup_func_name ::= function_name",
 /* 183 */ "rollup_func_name ::= FIRST",
 /* 184 */ "rollup_func_name ::= LAST",
 /* 185 */ "col_name_list ::= col_name",
 /* 186 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 187 */ "col_name ::= column_name",
 /* 188 */ "cmd ::= SHOW DNODES",
 /* 189 */ "cmd ::= SHOW USERS",
 /* 190 */ "cmd ::= SHOW DATABASES",
 /* 191 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 192 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 193 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 194 */ "cmd ::= SHOW MNODES",
 /* 195 */ "cmd ::= SHOW MODULES",
 /* 196 */ "cmd ::= SHOW QNODES",
 /* 197 */ "cmd ::= SHOW FUNCTIONS",
 /* 198 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 199 */ "cmd ::= SHOW STREAMS",
 /* 200 */ "cmd ::= SHOW ACCOUNTS",
 /* 201 */ "cmd ::= SHOW APPS",
 /* 202 */ "cmd ::= SHOW CONNECTIONS",
 /* 203 */ "cmd ::= SHOW LICENCE",
 /* 204 */ "cmd ::= SHOW GRANTS",
 /* 205 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 206 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 207 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 208 */ "cmd ::= SHOW QUERIES",
 /* 209 */ "cmd ::= SHOW SCORES",
 /* 210 */ "cmd ::= SHOW TOPICS",
 /* 211 */ "cmd ::= SHOW VARIABLES",
 /* 212 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 213 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 214 */ "cmd ::= SHOW BNODES",
 /* 215 */ "cmd ::= SHOW SNODES",
 /* 216 */ "cmd ::= SHOW CLUSTER",
 /* 217 */ "cmd ::= SHOW TRANSACTIONS",
 /* 218 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 219 */ "cmd ::= SHOW CONSUMERS",
 /* 220 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 221 */ "db_name_cond_opt ::=",
 /* 222 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 223 */ "like_pattern_opt ::=",
 /* 224 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 225 */ "table_name_cond ::= table_name",
 /* 226 */ "from_db_opt ::=",
 /* 227 */ "from_db_opt ::= FROM db_name",
 /* 228 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 229 */ "cmd ::= DROP INDEX exists_opt index_name",
 /* 230 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 231 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 232 */ "func_list ::= func",
 /* 233 */ "func_list ::= func_list NK_COMMA func",
 /* 234 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 235 */ "sma_stream_opt ::=",
 /* 236 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 237 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 238 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 239 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 240 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 241 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 242 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 243 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 244 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 245 */ "cmd ::= DESC full_table_name",
 /* 246 */ "cmd ::= DESCRIBE full_table_name",
 /* 247 */ "cmd ::= RESET QUERY CACHE",
 /* 248 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 249 */ "analyze_opt ::=",
 /* 250 */ "analyze_opt ::= ANALYZE",
 /* 251 */ "explain_options ::=",
 /* 252 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 253 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 254 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 255 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 256 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 257 */ "agg_func_opt ::=",
 /* 258 */ "agg_func_opt ::= AGGREGATE",
 /* 259 */ "bufsize_opt ::=",
 /* 260 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 261 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 262 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 263 */ "into_opt ::=",
 /* 264 */ "into_opt ::= INTO full_table_name",
 /* 265 */ "stream_options ::=",
 /* 266 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 267 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 268 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 269 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 270 */ "stream_options ::= stream_options IGNORE EXPIRED",
 /* 271 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 272 */ "cmd ::= KILL QUERY NK_STRING",
 /* 273 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 274 */ "cmd ::= BALANCE VGROUP",
 /* 275 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 276 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 277 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 278 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 279 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 280 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 281 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 282 */ "cmd ::= query_expression",
 /* 283 */ "literal ::= NK_INTEGER",
 /* 284 */ "literal ::= NK_FLOAT",
 /* 285 */ "literal ::= NK_STRING",
 /* 286 */ "literal ::= NK_BOOL",
 /* 287 */ "literal ::= TIMESTAMP NK_STRING",
 /* 288 */ "literal ::= duration_literal",
 /* 289 */ "literal ::= NULL",
 /* 290 */ "literal ::= NK_QUESTION",
 /* 291 */ "duration_literal ::= NK_VARIABLE",
 /* 292 */ "signed ::= NK_INTEGER",
 /* 293 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 294 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 295 */ "signed ::= NK_FLOAT",
 /* 296 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 297 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 298 */ "signed_literal ::= signed",
 /* 299 */ "signed_literal ::= NK_STRING",
 /* 300 */ "signed_literal ::= NK_BOOL",
 /* 301 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 302 */ "signed_literal ::= duration_literal",
 /* 303 */ "signed_literal ::= NULL",
 /* 304 */ "signed_literal ::= literal_func",
 /* 305 */ "literal_list ::= signed_literal",
 /* 306 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 307 */ "db_name ::= NK_ID",
 /* 308 */ "table_name ::= NK_ID",
 /* 309 */ "column_name ::= NK_ID",
 /* 310 */ "function_name ::= NK_ID",
 /* 311 */ "table_alias ::= NK_ID",
 /* 312 */ "column_alias ::= NK_ID",
 /* 313 */ "user_name ::= NK_ID",
 /* 314 */ "index_name ::= NK_ID",
 /* 315 */ "topic_name ::= NK_ID",
 /* 316 */ "stream_name ::= NK_ID",
 /* 317 */ "cgroup_name ::= NK_ID",
 /* 318 */ "expression ::= literal",
 /* 319 */ "expression ::= pseudo_column",
 /* 320 */ "expression ::= column_reference",
 /* 321 */ "expression ::= function_expression",
 /* 322 */ "expression ::= subquery",
 /* 323 */ "expression ::= NK_LP expression NK_RP",
 /* 324 */ "expression ::= NK_PLUS expression",
 /* 325 */ "expression ::= NK_MINUS expression",
 /* 326 */ "expression ::= expression NK_PLUS expression",
 /* 327 */ "expression ::= expression NK_MINUS expression",
 /* 328 */ "expression ::= expression NK_STAR expression",
 /* 329 */ "expression ::= expression NK_SLASH expression",
 /* 330 */ "expression ::= expression NK_REM expression",
 /* 331 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 332 */ "expression ::= expression NK_BITAND expression",
 /* 333 */ "expression ::= expression NK_BITOR expression",
 /* 334 */ "expression_list ::= expression",
 /* 335 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 336 */ "column_reference ::= column_name",
 /* 337 */ "column_reference ::= table_name NK_DOT column_name",
 /* 338 */ "pseudo_column ::= ROWTS",
 /* 339 */ "pseudo_column ::= TBNAME",
 /* 340 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 341 */ "pseudo_column ::= QSTARTTS",
 /* 342 */ "pseudo_column ::= QENDTS",
 /* 343 */ "pseudo_column ::= WSTARTTS",
 /* 344 */ "pseudo_column ::= WENDTS",
 /* 345 */ "pseudo_column ::= WDURATION",
 /* 346 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 347 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 348 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 349 */ "function_expression ::= literal_func",
 /* 350 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 351 */ "literal_func ::= NOW",
 /* 352 */ "noarg_func ::= NOW",
 /* 353 */ "noarg_func ::= TODAY",
 /* 354 */ "noarg_func ::= TIMEZONE",
 /* 355 */ "noarg_func ::= DATABASE",
 /* 356 */ "noarg_func ::= CLIENT_VERSION",
 /* 357 */ "noarg_func ::= SERVER_VERSION",
 /* 358 */ "noarg_func ::= SERVER_STATUS",
 /* 359 */ "noarg_func ::= CURRENT_USER",
 /* 360 */ "noarg_func ::= USER",
 /* 361 */ "star_func ::= COUNT",
 /* 362 */ "star_func ::= FIRST",
 /* 363 */ "star_func ::= LAST",
 /* 364 */ "star_func ::= LAST_ROW",
 /* 365 */ "star_func_para_list ::= NK_STAR",
 /* 366 */ "star_func_para_list ::= other_para_list",
 /* 367 */ "other_para_list ::= star_func_para",
 /* 368 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 369 */ "star_func_para ::= expression",
 /* 370 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 371 */ "predicate ::= expression compare_op expression",
 /* 372 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 373 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 374 */ "predicate ::= expression IS NULL",
 /* 375 */ "predicate ::= expression IS NOT NULL",
 /* 376 */ "predicate ::= expression in_op in_predicate_value",
 /* 377 */ "compare_op ::= NK_LT",
 /* 378 */ "compare_op ::= NK_GT",
 /* 379 */ "compare_op ::= NK_LE",
 /* 380 */ "compare_op ::= NK_GE",
 /* 381 */ "compare_op ::= NK_NE",
 /* 382 */ "compare_op ::= NK_EQ",
 /* 383 */ "compare_op ::= LIKE",
 /* 384 */ "compare_op ::= NOT LIKE",
 /* 385 */ "compare_op ::= MATCH",
 /* 386 */ "compare_op ::= NMATCH",
 /* 387 */ "compare_op ::= CONTAINS",
 /* 388 */ "in_op ::= IN",
 /* 389 */ "in_op ::= NOT IN",
 /* 390 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 391 */ "boolean_value_expression ::= boolean_primary",
 /* 392 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 393 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 394 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 395 */ "boolean_primary ::= predicate",
 /* 396 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 397 */ "common_expression ::= expression",
 /* 398 */ "common_expression ::= boolean_value_expression",
 /* 399 */ "from_clause_opt ::=",
 /* 400 */ "from_clause_opt ::= FROM table_reference_list",
 /* 401 */ "table_reference_list ::= table_reference",
 /* 402 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 403 */ "table_reference ::= table_primary",
 /* 404 */ "table_reference ::= joined_table",
 /* 405 */ "table_primary ::= table_name alias_opt",
 /* 406 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 407 */ "table_primary ::= subquery alias_opt",
 /* 408 */ "table_primary ::= parenthesized_joined_table",
 /* 409 */ "alias_opt ::=",
 /* 410 */ "alias_opt ::= table_alias",
 /* 411 */ "alias_opt ::= AS table_alias",
 /* 412 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 413 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 414 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 415 */ "join_type ::=",
 /* 416 */ "join_type ::= INNER",
 /* 417 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 418 */ "set_quantifier_opt ::=",
 /* 419 */ "set_quantifier_opt ::= DISTINCT",
 /* 420 */ "set_quantifier_opt ::= ALL",
 /* 421 */ "select_list ::= select_item",
 /* 422 */ "select_list ::= select_list NK_COMMA select_item",
 /* 423 */ "select_item ::= NK_STAR",
 /* 424 */ "select_item ::= common_expression",
 /* 425 */ "select_item ::= common_expression column_alias",
 /* 426 */ "select_item ::= common_expression AS column_alias",
 /* 427 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 428 */ "where_clause_opt ::=",
 /* 429 */ "where_clause_opt ::= WHERE search_condition",
 /* 430 */ "partition_by_clause_opt ::=",
 /* 431 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 432 */ "twindow_clause_opt ::=",
 /* 433 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 434 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 435 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 436 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 437 */ "sliding_opt ::=",
 /* 438 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 439 */ "fill_opt ::=",
 /* 440 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 441 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 442 */ "fill_mode ::= NONE",
 /* 443 */ "fill_mode ::= PREV",
 /* 444 */ "fill_mode ::= NULL",
 /* 445 */ "fill_mode ::= LINEAR",
 /* 446 */ "fill_mode ::= NEXT",
 /* 447 */ "group_by_clause_opt ::=",
 /* 448 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 449 */ "group_by_list ::= expression",
 /* 450 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 451 */ "having_clause_opt ::=",
 /* 452 */ "having_clause_opt ::= HAVING search_condition",
 /* 453 */ "range_opt ::=",
 /* 454 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 455 */ "every_opt ::=",
 /* 456 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 457 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 458 */ "query_expression_body ::= query_primary",
 /* 459 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 460 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 461 */ "query_primary ::= query_specification",
 /* 462 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 463 */ "order_by_clause_opt ::=",
 /* 464 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 465 */ "slimit_clause_opt ::=",
 /* 466 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 467 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 468 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 469 */ "limit_clause_opt ::=",
 /* 470 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 471 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 472 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 473 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 474 */ "search_condition ::= common_expression",
 /* 475 */ "sort_specification_list ::= sort_specification",
 /* 476 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 477 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 478 */ "ordering_specification_opt ::=",
 /* 479 */ "ordering_specification_opt ::= ASC",
 /* 480 */ "ordering_specification_opt ::= DESC",
 /* 481 */ "null_ordering_opt ::=",
 /* 482 */ "null_ordering_opt ::= NULLS FIRST",
 /* 483 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 253: /* cmd */
    case 256: /* literal */
    case 267: /* db_options */
    case 269: /* alter_db_options */
    case 274: /* retention */
    case 275: /* full_table_name */
    case 278: /* table_options */
    case 282: /* alter_table_clause */
    case 283: /* alter_table_options */
    case 286: /* signed_literal */
    case 287: /* create_subtable_clause */
    case 290: /* drop_table_clause */
    case 293: /* column_def */
    case 297: /* duration_literal */
    case 298: /* rollup_func_name */
    case 300: /* col_name */
    case 301: /* db_name_cond_opt */
    case 302: /* like_pattern_opt */
    case 303: /* table_name_cond */
    case 304: /* from_db_opt */
    case 306: /* index_options */
    case 308: /* sliding_opt */
    case 309: /* sma_stream_opt */
    case 310: /* func */
    case 312: /* stream_options */
    case 314: /* query_expression */
    case 317: /* explain_options */
    case 321: /* into_opt */
    case 323: /* where_clause_opt */
    case 324: /* signed */
    case 325: /* literal_func */
    case 328: /* expression */
    case 329: /* pseudo_column */
    case 330: /* column_reference */
    case 331: /* function_expression */
    case 332: /* subquery */
    case 337: /* star_func_para */
    case 338: /* predicate */
    case 341: /* in_predicate_value */
    case 342: /* boolean_value_expression */
    case 343: /* boolean_primary */
    case 344: /* common_expression */
    case 345: /* from_clause_opt */
    case 346: /* table_reference_list */
    case 347: /* table_reference */
    case 348: /* table_primary */
    case 349: /* joined_table */
    case 351: /* parenthesized_joined_table */
    case 353: /* search_condition */
    case 354: /* query_specification */
    case 358: /* range_opt */
    case 359: /* every_opt */
    case 360: /* fill_opt */
    case 361: /* twindow_clause_opt */
    case 363: /* having_clause_opt */
    case 364: /* select_item */
    case 367: /* query_expression_body */
    case 369: /* slimit_clause_opt */
    case 370: /* limit_clause_opt */
    case 371: /* query_primary */
    case 373: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy248)); 
}
      break;
    case 254: /* account_options */
    case 255: /* alter_account_options */
    case 257: /* alter_account_option */
    case 319: /* bufsize_opt */
{
 
}
      break;
    case 258: /* user_name */
    case 261: /* priv_level */
    case 264: /* db_name */
    case 265: /* dnode_endpoint */
    case 284: /* column_name */
    case 292: /* table_name */
    case 299: /* function_name */
    case 305: /* index_name */
    case 313: /* topic_name */
    case 315: /* cgroup_name */
    case 320: /* stream_name */
    case 326: /* table_alias */
    case 327: /* column_alias */
    case 333: /* star_func */
    case 335: /* noarg_func */
    case 350: /* alias_opt */
{
 
}
      break;
    case 259: /* sysinfo_opt */
{
 
}
      break;
    case 260: /* privileges */
    case 262: /* priv_type_list */
    case 263: /* priv_type */
{
 
}
      break;
    case 266: /* not_exists_opt */
    case 268: /* exists_opt */
    case 316: /* analyze_opt */
    case 318: /* agg_func_opt */
    case 355: /* set_quantifier_opt */
{
 
}
      break;
    case 270: /* integer_list */
    case 271: /* variable_list */
    case 272: /* retention_list */
    case 276: /* column_def_list */
    case 277: /* tags_def_opt */
    case 279: /* multi_create_clause */
    case 280: /* tags_def */
    case 281: /* multi_drop_clause */
    case 288: /* specific_tags_opt */
    case 289: /* literal_list */
    case 291: /* col_name_list */
    case 294: /* duration_list */
    case 295: /* rollup_func_list */
    case 307: /* func_list */
    case 311: /* expression_list */
    case 322: /* dnode_list */
    case 334: /* star_func_para_list */
    case 336: /* other_para_list */
    case 356: /* select_list */
    case 357: /* partition_by_clause_opt */
    case 362: /* group_by_clause_opt */
    case 366: /* group_by_list */
    case 368: /* order_by_clause_opt */
    case 372: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy552)); 
}
      break;
    case 273: /* alter_db_option */
    case 296: /* alter_table_option */
{
 
}
      break;
    case 285: /* type_name */
{
 
}
      break;
    case 339: /* compare_op */
    case 340: /* in_op */
{
 
}
      break;
    case 352: /* join_type */
{
 
}
      break;
    case 365: /* fill_mode */
{
 
}
      break;
    case 374: /* ordering_specification_opt */
{
 
}
      break;
    case 375: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  253,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  253,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  254,    0 }, /* (2) account_options ::= */
  {  254,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  254,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  254,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  254,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  254,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  254,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  254,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  254,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  254,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  255,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  255,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  257,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  257,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  257,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  257,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  257,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  257,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  257,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  257,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  257,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  257,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  253,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  253,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  253,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  253,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  253,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  259,    0 }, /* (29) sysinfo_opt ::= */
  {  259,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  253,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  253,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  260,   -1 }, /* (33) privileges ::= ALL */
  {  260,   -1 }, /* (34) privileges ::= priv_type_list */
  {  262,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  262,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  263,   -1 }, /* (37) priv_type ::= READ */
  {  263,   -1 }, /* (38) priv_type ::= WRITE */
  {  261,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  261,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  253,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  253,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  253,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  253,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  253,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  253,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  253,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  253,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  265,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  265,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  265,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  253,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  253,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  253,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  253,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  253,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  253,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  253,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  253,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  253,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  253,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  253,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  253,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  253,   -2 }, /* (64) cmd ::= USE db_name */
  {  253,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  253,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  266,   -3 }, /* (67) not_exists_opt ::= IF NOT EXISTS */
  {  266,    0 }, /* (68) not_exists_opt ::= */
  {  268,   -2 }, /* (69) exists_opt ::= IF EXISTS */
  {  268,    0 }, /* (70) exists_opt ::= */
  {  267,    0 }, /* (71) db_options ::= */
  {  267,   -3 }, /* (72) db_options ::= db_options BUFFER NK_INTEGER */
  {  267,   -3 }, /* (73) db_options ::= db_options CACHELAST NK_INTEGER */
  {  267,   -3 }, /* (74) db_options ::= db_options COMP NK_INTEGER */
  {  267,   -3 }, /* (75) db_options ::= db_options DURATION NK_INTEGER */
  {  267,   -3 }, /* (76) db_options ::= db_options DURATION NK_VARIABLE */
  {  267,   -3 }, /* (77) db_options ::= db_options FSYNC NK_INTEGER */
  {  267,   -3 }, /* (78) db_options ::= db_options MAXROWS NK_INTEGER */
  {  267,   -3 }, /* (79) db_options ::= db_options MINROWS NK_INTEGER */
  {  267,   -3 }, /* (80) db_options ::= db_options KEEP integer_list */
  {  267,   -3 }, /* (81) db_options ::= db_options KEEP variable_list */
  {  267,   -3 }, /* (82) db_options ::= db_options PAGES NK_INTEGER */
  {  267,   -3 }, /* (83) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  267,   -3 }, /* (84) db_options ::= db_options PRECISION NK_STRING */
  {  267,   -3 }, /* (85) db_options ::= db_options REPLICA NK_INTEGER */
  {  267,   -3 }, /* (86) db_options ::= db_options STRICT NK_INTEGER */
  {  267,   -3 }, /* (87) db_options ::= db_options WAL NK_INTEGER */
  {  267,   -3 }, /* (88) db_options ::= db_options VGROUPS NK_INTEGER */
  {  267,   -3 }, /* (89) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  267,   -3 }, /* (90) db_options ::= db_options RETENTIONS retention_list */
  {  267,   -3 }, /* (91) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  269,   -1 }, /* (92) alter_db_options ::= alter_db_option */
  {  269,   -2 }, /* (93) alter_db_options ::= alter_db_options alter_db_option */
  {  273,   -2 }, /* (94) alter_db_option ::= BUFFER NK_INTEGER */
  {  273,   -2 }, /* (95) alter_db_option ::= CACHELAST NK_INTEGER */
  {  273,   -2 }, /* (96) alter_db_option ::= FSYNC NK_INTEGER */
  {  273,   -2 }, /* (97) alter_db_option ::= KEEP integer_list */
  {  273,   -2 }, /* (98) alter_db_option ::= KEEP variable_list */
  {  273,   -2 }, /* (99) alter_db_option ::= PAGES NK_INTEGER */
  {  273,   -2 }, /* (100) alter_db_option ::= REPLICA NK_INTEGER */
  {  273,   -2 }, /* (101) alter_db_option ::= STRICT NK_INTEGER */
  {  273,   -2 }, /* (102) alter_db_option ::= WAL NK_INTEGER */
  {  270,   -1 }, /* (103) integer_list ::= NK_INTEGER */
  {  270,   -3 }, /* (104) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  271,   -1 }, /* (105) variable_list ::= NK_VARIABLE */
  {  271,   -3 }, /* (106) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  272,   -1 }, /* (107) retention_list ::= retention */
  {  272,   -3 }, /* (108) retention_list ::= retention_list NK_COMMA retention */
  {  274,   -3 }, /* (109) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  253,   -9 }, /* (110) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  253,   -3 }, /* (111) cmd ::= CREATE TABLE multi_create_clause */
  {  253,   -9 }, /* (112) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  253,   -3 }, /* (113) cmd ::= DROP TABLE multi_drop_clause */
  {  253,   -4 }, /* (114) cmd ::= DROP STABLE exists_opt full_table_name */
  {  253,   -3 }, /* (115) cmd ::= ALTER TABLE alter_table_clause */
  {  253,   -3 }, /* (116) cmd ::= ALTER STABLE alter_table_clause */
  {  282,   -2 }, /* (117) alter_table_clause ::= full_table_name alter_table_options */
  {  282,   -5 }, /* (118) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  282,   -4 }, /* (119) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  282,   -5 }, /* (120) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  282,   -5 }, /* (121) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  282,   -5 }, /* (122) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  282,   -4 }, /* (123) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  282,   -5 }, /* (124) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  282,   -5 }, /* (125) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  282,   -6 }, /* (126) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  279,   -1 }, /* (127) multi_create_clause ::= create_subtable_clause */
  {  279,   -2 }, /* (128) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  287,  -10 }, /* (129) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  281,   -1 }, /* (130) multi_drop_clause ::= drop_table_clause */
  {  281,   -2 }, /* (131) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  290,   -2 }, /* (132) drop_table_clause ::= exists_opt full_table_name */
  {  288,    0 }, /* (133) specific_tags_opt ::= */
  {  288,   -3 }, /* (134) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  275,   -1 }, /* (135) full_table_name ::= table_name */
  {  275,   -3 }, /* (136) full_table_name ::= db_name NK_DOT table_name */
  {  276,   -1 }, /* (137) column_def_list ::= column_def */
  {  276,   -3 }, /* (138) column_def_list ::= column_def_list NK_COMMA column_def */
  {  293,   -2 }, /* (139) column_def ::= column_name type_name */
  {  293,   -4 }, /* (140) column_def ::= column_name type_name COMMENT NK_STRING */
  {  285,   -1 }, /* (141) type_name ::= BOOL */
  {  285,   -1 }, /* (142) type_name ::= TINYINT */
  {  285,   -1 }, /* (143) type_name ::= SMALLINT */
  {  285,   -1 }, /* (144) type_name ::= INT */
  {  285,   -1 }, /* (145) type_name ::= INTEGER */
  {  285,   -1 }, /* (146) type_name ::= BIGINT */
  {  285,   -1 }, /* (147) type_name ::= FLOAT */
  {  285,   -1 }, /* (148) type_name ::= DOUBLE */
  {  285,   -4 }, /* (149) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  285,   -1 }, /* (150) type_name ::= TIMESTAMP */
  {  285,   -4 }, /* (151) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  285,   -2 }, /* (152) type_name ::= TINYINT UNSIGNED */
  {  285,   -2 }, /* (153) type_name ::= SMALLINT UNSIGNED */
  {  285,   -2 }, /* (154) type_name ::= INT UNSIGNED */
  {  285,   -2 }, /* (155) type_name ::= BIGINT UNSIGNED */
  {  285,   -1 }, /* (156) type_name ::= JSON */
  {  285,   -4 }, /* (157) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  285,   -1 }, /* (158) type_name ::= MEDIUMBLOB */
  {  285,   -1 }, /* (159) type_name ::= BLOB */
  {  285,   -4 }, /* (160) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  285,   -1 }, /* (161) type_name ::= DECIMAL */
  {  285,   -4 }, /* (162) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  285,   -6 }, /* (163) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  277,    0 }, /* (164) tags_def_opt ::= */
  {  277,   -1 }, /* (165) tags_def_opt ::= tags_def */
  {  280,   -4 }, /* (166) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  278,    0 }, /* (167) table_options ::= */
  {  278,   -3 }, /* (168) table_options ::= table_options COMMENT NK_STRING */
  {  278,   -3 }, /* (169) table_options ::= table_options MAX_DELAY duration_list */
  {  278,   -3 }, /* (170) table_options ::= table_options WATERMARK duration_list */
  {  278,   -5 }, /* (171) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  278,   -3 }, /* (172) table_options ::= table_options TTL NK_INTEGER */
  {  278,   -5 }, /* (173) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  283,   -1 }, /* (174) alter_table_options ::= alter_table_option */
  {  283,   -2 }, /* (175) alter_table_options ::= alter_table_options alter_table_option */
  {  296,   -2 }, /* (176) alter_table_option ::= COMMENT NK_STRING */
  {  296,   -2 }, /* (177) alter_table_option ::= TTL NK_INTEGER */
  {  294,   -1 }, /* (178) duration_list ::= duration_literal */
  {  294,   -3 }, /* (179) duration_list ::= duration_list NK_COMMA duration_literal */
  {  295,   -1 }, /* (180) rollup_func_list ::= rollup_func_name */
  {  295,   -3 }, /* (181) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  298,   -1 }, /* (182) rollup_func_name ::= function_name */
  {  298,   -1 }, /* (183) rollup_func_name ::= FIRST */
  {  298,   -1 }, /* (184) rollup_func_name ::= LAST */
  {  291,   -1 }, /* (185) col_name_list ::= col_name */
  {  291,   -3 }, /* (186) col_name_list ::= col_name_list NK_COMMA col_name */
  {  300,   -1 }, /* (187) col_name ::= column_name */
  {  253,   -2 }, /* (188) cmd ::= SHOW DNODES */
  {  253,   -2 }, /* (189) cmd ::= SHOW USERS */
  {  253,   -2 }, /* (190) cmd ::= SHOW DATABASES */
  {  253,   -4 }, /* (191) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  253,   -4 }, /* (192) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  253,   -3 }, /* (193) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  253,   -2 }, /* (194) cmd ::= SHOW MNODES */
  {  253,   -2 }, /* (195) cmd ::= SHOW MODULES */
  {  253,   -2 }, /* (196) cmd ::= SHOW QNODES */
  {  253,   -2 }, /* (197) cmd ::= SHOW FUNCTIONS */
  {  253,   -5 }, /* (198) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  253,   -2 }, /* (199) cmd ::= SHOW STREAMS */
  {  253,   -2 }, /* (200) cmd ::= SHOW ACCOUNTS */
  {  253,   -2 }, /* (201) cmd ::= SHOW APPS */
  {  253,   -2 }, /* (202) cmd ::= SHOW CONNECTIONS */
  {  253,   -2 }, /* (203) cmd ::= SHOW LICENCE */
  {  253,   -2 }, /* (204) cmd ::= SHOW GRANTS */
  {  253,   -4 }, /* (205) cmd ::= SHOW CREATE DATABASE db_name */
  {  253,   -4 }, /* (206) cmd ::= SHOW CREATE TABLE full_table_name */
  {  253,   -4 }, /* (207) cmd ::= SHOW CREATE STABLE full_table_name */
  {  253,   -2 }, /* (208) cmd ::= SHOW QUERIES */
  {  253,   -2 }, /* (209) cmd ::= SHOW SCORES */
  {  253,   -2 }, /* (210) cmd ::= SHOW TOPICS */
  {  253,   -2 }, /* (211) cmd ::= SHOW VARIABLES */
  {  253,   -3 }, /* (212) cmd ::= SHOW LOCAL VARIABLES */
  {  253,   -4 }, /* (213) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  253,   -2 }, /* (214) cmd ::= SHOW BNODES */
  {  253,   -2 }, /* (215) cmd ::= SHOW SNODES */
  {  253,   -2 }, /* (216) cmd ::= SHOW CLUSTER */
  {  253,   -2 }, /* (217) cmd ::= SHOW TRANSACTIONS */
  {  253,   -4 }, /* (218) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  253,   -2 }, /* (219) cmd ::= SHOW CONSUMERS */
  {  253,   -2 }, /* (220) cmd ::= SHOW SUBSCRIPTIONS */
  {  301,    0 }, /* (221) db_name_cond_opt ::= */
  {  301,   -2 }, /* (222) db_name_cond_opt ::= db_name NK_DOT */
  {  302,    0 }, /* (223) like_pattern_opt ::= */
  {  302,   -2 }, /* (224) like_pattern_opt ::= LIKE NK_STRING */
  {  303,   -1 }, /* (225) table_name_cond ::= table_name */
  {  304,    0 }, /* (226) from_db_opt ::= */
  {  304,   -2 }, /* (227) from_db_opt ::= FROM db_name */
  {  253,   -8 }, /* (228) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  253,   -4 }, /* (229) cmd ::= DROP INDEX exists_opt index_name */
  {  306,  -10 }, /* (230) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  306,  -12 }, /* (231) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  307,   -1 }, /* (232) func_list ::= func */
  {  307,   -3 }, /* (233) func_list ::= func_list NK_COMMA func */
  {  310,   -4 }, /* (234) func ::= function_name NK_LP expression_list NK_RP */
  {  309,    0 }, /* (235) sma_stream_opt ::= */
  {  309,   -3 }, /* (236) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  309,   -3 }, /* (237) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  253,   -6 }, /* (238) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  253,   -7 }, /* (239) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  253,   -9 }, /* (240) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  253,   -7 }, /* (241) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  253,   -9 }, /* (242) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  253,   -4 }, /* (243) cmd ::= DROP TOPIC exists_opt topic_name */
  {  253,   -7 }, /* (244) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  253,   -2 }, /* (245) cmd ::= DESC full_table_name */
  {  253,   -2 }, /* (246) cmd ::= DESCRIBE full_table_name */
  {  253,   -3 }, /* (247) cmd ::= RESET QUERY CACHE */
  {  253,   -4 }, /* (248) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  316,    0 }, /* (249) analyze_opt ::= */
  {  316,   -1 }, /* (250) analyze_opt ::= ANALYZE */
  {  317,    0 }, /* (251) explain_options ::= */
  {  317,   -3 }, /* (252) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  317,   -3 }, /* (253) explain_options ::= explain_options RATIO NK_FLOAT */
  {  253,   -6 }, /* (254) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  253,  -10 }, /* (255) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  253,   -4 }, /* (256) cmd ::= DROP FUNCTION exists_opt function_name */
  {  318,    0 }, /* (257) agg_func_opt ::= */
  {  318,   -1 }, /* (258) agg_func_opt ::= AGGREGATE */
  {  319,    0 }, /* (259) bufsize_opt ::= */
  {  319,   -2 }, /* (260) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  253,   -8 }, /* (261) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  253,   -4 }, /* (262) cmd ::= DROP STREAM exists_opt stream_name */
  {  321,    0 }, /* (263) into_opt ::= */
  {  321,   -2 }, /* (264) into_opt ::= INTO full_table_name */
  {  312,    0 }, /* (265) stream_options ::= */
  {  312,   -3 }, /* (266) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  312,   -3 }, /* (267) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  312,   -4 }, /* (268) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  312,   -3 }, /* (269) stream_options ::= stream_options WATERMARK duration_literal */
  {  312,   -3 }, /* (270) stream_options ::= stream_options IGNORE EXPIRED */
  {  253,   -3 }, /* (271) cmd ::= KILL CONNECTION NK_INTEGER */
  {  253,   -3 }, /* (272) cmd ::= KILL QUERY NK_STRING */
  {  253,   -3 }, /* (273) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  253,   -2 }, /* (274) cmd ::= BALANCE VGROUP */
  {  253,   -4 }, /* (275) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  253,   -4 }, /* (276) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  253,   -3 }, /* (277) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  322,   -2 }, /* (278) dnode_list ::= DNODE NK_INTEGER */
  {  322,   -3 }, /* (279) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  253,   -3 }, /* (280) cmd ::= SYNCDB db_name REPLICA */
  {  253,   -4 }, /* (281) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  253,   -1 }, /* (282) cmd ::= query_expression */
  {  256,   -1 }, /* (283) literal ::= NK_INTEGER */
  {  256,   -1 }, /* (284) literal ::= NK_FLOAT */
  {  256,   -1 }, /* (285) literal ::= NK_STRING */
  {  256,   -1 }, /* (286) literal ::= NK_BOOL */
  {  256,   -2 }, /* (287) literal ::= TIMESTAMP NK_STRING */
  {  256,   -1 }, /* (288) literal ::= duration_literal */
  {  256,   -1 }, /* (289) literal ::= NULL */
  {  256,   -1 }, /* (290) literal ::= NK_QUESTION */
  {  297,   -1 }, /* (291) duration_literal ::= NK_VARIABLE */
  {  324,   -1 }, /* (292) signed ::= NK_INTEGER */
  {  324,   -2 }, /* (293) signed ::= NK_PLUS NK_INTEGER */
  {  324,   -2 }, /* (294) signed ::= NK_MINUS NK_INTEGER */
  {  324,   -1 }, /* (295) signed ::= NK_FLOAT */
  {  324,   -2 }, /* (296) signed ::= NK_PLUS NK_FLOAT */
  {  324,   -2 }, /* (297) signed ::= NK_MINUS NK_FLOAT */
  {  286,   -1 }, /* (298) signed_literal ::= signed */
  {  286,   -1 }, /* (299) signed_literal ::= NK_STRING */
  {  286,   -1 }, /* (300) signed_literal ::= NK_BOOL */
  {  286,   -2 }, /* (301) signed_literal ::= TIMESTAMP NK_STRING */
  {  286,   -1 }, /* (302) signed_literal ::= duration_literal */
  {  286,   -1 }, /* (303) signed_literal ::= NULL */
  {  286,   -1 }, /* (304) signed_literal ::= literal_func */
  {  289,   -1 }, /* (305) literal_list ::= signed_literal */
  {  289,   -3 }, /* (306) literal_list ::= literal_list NK_COMMA signed_literal */
  {  264,   -1 }, /* (307) db_name ::= NK_ID */
  {  292,   -1 }, /* (308) table_name ::= NK_ID */
  {  284,   -1 }, /* (309) column_name ::= NK_ID */
  {  299,   -1 }, /* (310) function_name ::= NK_ID */
  {  326,   -1 }, /* (311) table_alias ::= NK_ID */
  {  327,   -1 }, /* (312) column_alias ::= NK_ID */
  {  258,   -1 }, /* (313) user_name ::= NK_ID */
  {  305,   -1 }, /* (314) index_name ::= NK_ID */
  {  313,   -1 }, /* (315) topic_name ::= NK_ID */
  {  320,   -1 }, /* (316) stream_name ::= NK_ID */
  {  315,   -1 }, /* (317) cgroup_name ::= NK_ID */
  {  328,   -1 }, /* (318) expression ::= literal */
  {  328,   -1 }, /* (319) expression ::= pseudo_column */
  {  328,   -1 }, /* (320) expression ::= column_reference */
  {  328,   -1 }, /* (321) expression ::= function_expression */
  {  328,   -1 }, /* (322) expression ::= subquery */
  {  328,   -3 }, /* (323) expression ::= NK_LP expression NK_RP */
  {  328,   -2 }, /* (324) expression ::= NK_PLUS expression */
  {  328,   -2 }, /* (325) expression ::= NK_MINUS expression */
  {  328,   -3 }, /* (326) expression ::= expression NK_PLUS expression */
  {  328,   -3 }, /* (327) expression ::= expression NK_MINUS expression */
  {  328,   -3 }, /* (328) expression ::= expression NK_STAR expression */
  {  328,   -3 }, /* (329) expression ::= expression NK_SLASH expression */
  {  328,   -3 }, /* (330) expression ::= expression NK_REM expression */
  {  328,   -3 }, /* (331) expression ::= column_reference NK_ARROW NK_STRING */
  {  328,   -3 }, /* (332) expression ::= expression NK_BITAND expression */
  {  328,   -3 }, /* (333) expression ::= expression NK_BITOR expression */
  {  311,   -1 }, /* (334) expression_list ::= expression */
  {  311,   -3 }, /* (335) expression_list ::= expression_list NK_COMMA expression */
  {  330,   -1 }, /* (336) column_reference ::= column_name */
  {  330,   -3 }, /* (337) column_reference ::= table_name NK_DOT column_name */
  {  329,   -1 }, /* (338) pseudo_column ::= ROWTS */
  {  329,   -1 }, /* (339) pseudo_column ::= TBNAME */
  {  329,   -3 }, /* (340) pseudo_column ::= table_name NK_DOT TBNAME */
  {  329,   -1 }, /* (341) pseudo_column ::= QSTARTTS */
  {  329,   -1 }, /* (342) pseudo_column ::= QENDTS */
  {  329,   -1 }, /* (343) pseudo_column ::= WSTARTTS */
  {  329,   -1 }, /* (344) pseudo_column ::= WENDTS */
  {  329,   -1 }, /* (345) pseudo_column ::= WDURATION */
  {  331,   -4 }, /* (346) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  331,   -4 }, /* (347) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  331,   -6 }, /* (348) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  331,   -1 }, /* (349) function_expression ::= literal_func */
  {  325,   -3 }, /* (350) literal_func ::= noarg_func NK_LP NK_RP */
  {  325,   -1 }, /* (351) literal_func ::= NOW */
  {  335,   -1 }, /* (352) noarg_func ::= NOW */
  {  335,   -1 }, /* (353) noarg_func ::= TODAY */
  {  335,   -1 }, /* (354) noarg_func ::= TIMEZONE */
  {  335,   -1 }, /* (355) noarg_func ::= DATABASE */
  {  335,   -1 }, /* (356) noarg_func ::= CLIENT_VERSION */
  {  335,   -1 }, /* (357) noarg_func ::= SERVER_VERSION */
  {  335,   -1 }, /* (358) noarg_func ::= SERVER_STATUS */
  {  335,   -1 }, /* (359) noarg_func ::= CURRENT_USER */
  {  335,   -1 }, /* (360) noarg_func ::= USER */
  {  333,   -1 }, /* (361) star_func ::= COUNT */
  {  333,   -1 }, /* (362) star_func ::= FIRST */
  {  333,   -1 }, /* (363) star_func ::= LAST */
  {  333,   -1 }, /* (364) star_func ::= LAST_ROW */
  {  334,   -1 }, /* (365) star_func_para_list ::= NK_STAR */
  {  334,   -1 }, /* (366) star_func_para_list ::= other_para_list */
  {  336,   -1 }, /* (367) other_para_list ::= star_func_para */
  {  336,   -3 }, /* (368) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  337,   -1 }, /* (369) star_func_para ::= expression */
  {  337,   -3 }, /* (370) star_func_para ::= table_name NK_DOT NK_STAR */
  {  338,   -3 }, /* (371) predicate ::= expression compare_op expression */
  {  338,   -5 }, /* (372) predicate ::= expression BETWEEN expression AND expression */
  {  338,   -6 }, /* (373) predicate ::= expression NOT BETWEEN expression AND expression */
  {  338,   -3 }, /* (374) predicate ::= expression IS NULL */
  {  338,   -4 }, /* (375) predicate ::= expression IS NOT NULL */
  {  338,   -3 }, /* (376) predicate ::= expression in_op in_predicate_value */
  {  339,   -1 }, /* (377) compare_op ::= NK_LT */
  {  339,   -1 }, /* (378) compare_op ::= NK_GT */
  {  339,   -1 }, /* (379) compare_op ::= NK_LE */
  {  339,   -1 }, /* (380) compare_op ::= NK_GE */
  {  339,   -1 }, /* (381) compare_op ::= NK_NE */
  {  339,   -1 }, /* (382) compare_op ::= NK_EQ */
  {  339,   -1 }, /* (383) compare_op ::= LIKE */
  {  339,   -2 }, /* (384) compare_op ::= NOT LIKE */
  {  339,   -1 }, /* (385) compare_op ::= MATCH */
  {  339,   -1 }, /* (386) compare_op ::= NMATCH */
  {  339,   -1 }, /* (387) compare_op ::= CONTAINS */
  {  340,   -1 }, /* (388) in_op ::= IN */
  {  340,   -2 }, /* (389) in_op ::= NOT IN */
  {  341,   -3 }, /* (390) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  342,   -1 }, /* (391) boolean_value_expression ::= boolean_primary */
  {  342,   -2 }, /* (392) boolean_value_expression ::= NOT boolean_primary */
  {  342,   -3 }, /* (393) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  342,   -3 }, /* (394) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  343,   -1 }, /* (395) boolean_primary ::= predicate */
  {  343,   -3 }, /* (396) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  344,   -1 }, /* (397) common_expression ::= expression */
  {  344,   -1 }, /* (398) common_expression ::= boolean_value_expression */
  {  345,    0 }, /* (399) from_clause_opt ::= */
  {  345,   -2 }, /* (400) from_clause_opt ::= FROM table_reference_list */
  {  346,   -1 }, /* (401) table_reference_list ::= table_reference */
  {  346,   -3 }, /* (402) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  347,   -1 }, /* (403) table_reference ::= table_primary */
  {  347,   -1 }, /* (404) table_reference ::= joined_table */
  {  348,   -2 }, /* (405) table_primary ::= table_name alias_opt */
  {  348,   -4 }, /* (406) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  348,   -2 }, /* (407) table_primary ::= subquery alias_opt */
  {  348,   -1 }, /* (408) table_primary ::= parenthesized_joined_table */
  {  350,    0 }, /* (409) alias_opt ::= */
  {  350,   -1 }, /* (410) alias_opt ::= table_alias */
  {  350,   -2 }, /* (411) alias_opt ::= AS table_alias */
  {  351,   -3 }, /* (412) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  351,   -3 }, /* (413) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  349,   -6 }, /* (414) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  352,    0 }, /* (415) join_type ::= */
  {  352,   -1 }, /* (416) join_type ::= INNER */
  {  354,  -12 }, /* (417) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  355,    0 }, /* (418) set_quantifier_opt ::= */
  {  355,   -1 }, /* (419) set_quantifier_opt ::= DISTINCT */
  {  355,   -1 }, /* (420) set_quantifier_opt ::= ALL */
  {  356,   -1 }, /* (421) select_list ::= select_item */
  {  356,   -3 }, /* (422) select_list ::= select_list NK_COMMA select_item */
  {  364,   -1 }, /* (423) select_item ::= NK_STAR */
  {  364,   -1 }, /* (424) select_item ::= common_expression */
  {  364,   -2 }, /* (425) select_item ::= common_expression column_alias */
  {  364,   -3 }, /* (426) select_item ::= common_expression AS column_alias */
  {  364,   -3 }, /* (427) select_item ::= table_name NK_DOT NK_STAR */
  {  323,    0 }, /* (428) where_clause_opt ::= */
  {  323,   -2 }, /* (429) where_clause_opt ::= WHERE search_condition */
  {  357,    0 }, /* (430) partition_by_clause_opt ::= */
  {  357,   -3 }, /* (431) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  361,    0 }, /* (432) twindow_clause_opt ::= */
  {  361,   -6 }, /* (433) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  361,   -4 }, /* (434) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  361,   -6 }, /* (435) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  361,   -8 }, /* (436) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  308,    0 }, /* (437) sliding_opt ::= */
  {  308,   -4 }, /* (438) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  360,    0 }, /* (439) fill_opt ::= */
  {  360,   -4 }, /* (440) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  360,   -6 }, /* (441) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  365,   -1 }, /* (442) fill_mode ::= NONE */
  {  365,   -1 }, /* (443) fill_mode ::= PREV */
  {  365,   -1 }, /* (444) fill_mode ::= NULL */
  {  365,   -1 }, /* (445) fill_mode ::= LINEAR */
  {  365,   -1 }, /* (446) fill_mode ::= NEXT */
  {  362,    0 }, /* (447) group_by_clause_opt ::= */
  {  362,   -3 }, /* (448) group_by_clause_opt ::= GROUP BY group_by_list */
  {  366,   -1 }, /* (449) group_by_list ::= expression */
  {  366,   -3 }, /* (450) group_by_list ::= group_by_list NK_COMMA expression */
  {  363,    0 }, /* (451) having_clause_opt ::= */
  {  363,   -2 }, /* (452) having_clause_opt ::= HAVING search_condition */
  {  358,    0 }, /* (453) range_opt ::= */
  {  358,   -6 }, /* (454) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  359,    0 }, /* (455) every_opt ::= */
  {  359,   -4 }, /* (456) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  314,   -4 }, /* (457) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  367,   -1 }, /* (458) query_expression_body ::= query_primary */
  {  367,   -4 }, /* (459) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  367,   -3 }, /* (460) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  371,   -1 }, /* (461) query_primary ::= query_specification */
  {  371,   -6 }, /* (462) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  368,    0 }, /* (463) order_by_clause_opt ::= */
  {  368,   -3 }, /* (464) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  369,    0 }, /* (465) slimit_clause_opt ::= */
  {  369,   -2 }, /* (466) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  369,   -4 }, /* (467) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  369,   -4 }, /* (468) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  370,    0 }, /* (469) limit_clause_opt ::= */
  {  370,   -2 }, /* (470) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  370,   -4 }, /* (471) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  370,   -4 }, /* (472) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  332,   -3 }, /* (473) subquery ::= NK_LP query_expression NK_RP */
  {  353,   -1 }, /* (474) search_condition ::= common_expression */
  {  372,   -1 }, /* (475) sort_specification_list ::= sort_specification */
  {  372,   -3 }, /* (476) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  373,   -3 }, /* (477) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  374,    0 }, /* (478) ordering_specification_opt ::= */
  {  374,   -1 }, /* (479) ordering_specification_opt ::= ASC */
  {  374,   -1 }, /* (480) ordering_specification_opt ::= DESC */
  {  375,    0 }, /* (481) null_ordering_opt ::= */
  {  375,   -2 }, /* (482) null_ordering_opt ::= NULLS FIRST */
  {  375,   -2 }, /* (483) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,254,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,255,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,254,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,256,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,257,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,255,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,257,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,256,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy401, &yymsp[-1].minor.yy0, yymsp[0].minor.yy695); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy401, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy401, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy401, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy401); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy695 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy695 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy525, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy401); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy525, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy401); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy525 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy525 = yymsp[0].minor.yy525; }
  yymsp[0].minor.yy525 = yylhsminor.yy525;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy525 = yymsp[-2].minor.yy525 | yymsp[0].minor.yy525; }
  yymsp[-2].minor.yy525 = yylhsminor.yy525;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy525 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy525 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy401 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy401 = yylhsminor.yy401;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy401 = yymsp[-2].minor.yy401; }
  yymsp[-2].minor.yy401 = yylhsminor.yy401;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy401, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy401); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 307: /* db_name ::= NK_ID */ yytestcase(yyruleno==307);
      case 308: /* table_name ::= NK_ID */ yytestcase(yyruleno==308);
      case 309: /* column_name ::= NK_ID */ yytestcase(yyruleno==309);
      case 310: /* function_name ::= NK_ID */ yytestcase(yyruleno==310);
      case 311: /* table_alias ::= NK_ID */ yytestcase(yyruleno==311);
      case 312: /* column_alias ::= NK_ID */ yytestcase(yyruleno==312);
      case 313: /* user_name ::= NK_ID */ yytestcase(yyruleno==313);
      case 314: /* index_name ::= NK_ID */ yytestcase(yyruleno==314);
      case 315: /* topic_name ::= NK_ID */ yytestcase(yyruleno==315);
      case 316: /* stream_name ::= NK_ID */ yytestcase(yyruleno==316);
      case 317: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==317);
      case 352: /* noarg_func ::= NOW */ yytestcase(yyruleno==352);
      case 353: /* noarg_func ::= TODAY */ yytestcase(yyruleno==353);
      case 354: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==354);
      case 355: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==355);
      case 356: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==356);
      case 357: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==357);
      case 358: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==358);
      case 359: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==359);
      case 360: /* noarg_func ::= USER */ yytestcase(yyruleno==360);
      case 361: /* star_func ::= COUNT */ yytestcase(yyruleno==361);
      case 362: /* star_func ::= FIRST */ yytestcase(yyruleno==362);
      case 363: /* star_func ::= LAST */ yytestcase(yyruleno==363);
      case 364: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==364);
{ yylhsminor.yy401 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy401 = yylhsminor.yy401;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy89, &yymsp[-1].minor.yy401, yymsp[0].minor.yy248); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy401); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy401); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy401, yymsp[0].minor.yy248); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy401); }
        break;
      case 67: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy89 = true; }
        break;
      case 68: /* not_exists_opt ::= */
      case 70: /* exists_opt ::= */ yytestcase(yyruleno==70);
      case 249: /* analyze_opt ::= */ yytestcase(yyruleno==249);
      case 257: /* agg_func_opt ::= */ yytestcase(yyruleno==257);
      case 418: /* set_quantifier_opt ::= */ yytestcase(yyruleno==418);
{ yymsp[1].minor.yy89 = false; }
        break;
      case 69: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy89 = true; }
        break;
      case 71: /* db_options ::= */
{ yymsp[1].minor.yy248 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 72: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 73: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 74: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 75: /* db_options ::= db_options DURATION NK_INTEGER */
      case 76: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==76);
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 77: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 78: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 79: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 80: /* db_options ::= db_options KEEP integer_list */
      case 81: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==81);
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_KEEP, yymsp[0].minor.yy552); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 82: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 83: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 84: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 85: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 86: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 87: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 88: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 89: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 90: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_RETENTIONS, yymsp[0].minor.yy552); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 91: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 92: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy248 = createAlterDatabaseOptions(pCxt); yylhsminor.yy248 = setAlterDatabaseOption(pCxt, yylhsminor.yy248, &yymsp[0].minor.yy301); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 93: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy248 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy248, &yymsp[0].minor.yy301); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 94: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 95: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= KEEP integer_list */
      case 98: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==98);
{ yymsp[-1].minor.yy301.type = DB_OPTION_KEEP; yymsp[-1].minor.yy301.pList = yymsp[0].minor.yy552; }
        break;
      case 99: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_PAGES; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 100: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 101: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_STRICT; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 102: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_WAL; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 103: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy552 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy552 = yylhsminor.yy552;
        break;
      case 104: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 279: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==279);
{ yylhsminor.yy552 = addNodeToList(pCxt, yymsp[-2].minor.yy552, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy552 = yylhsminor.yy552;
        break;
      case 105: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy552 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy552 = yylhsminor.yy552;
        break;
      case 106: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy552 = addNodeToList(pCxt, yymsp[-2].minor.yy552, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy552 = yylhsminor.yy552;
        break;
      case 107: /* retention_list ::= retention */
      case 127: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==127);
      case 130: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==130);
      case 137: /* column_def_list ::= column_def */ yytestcase(yyruleno==137);
      case 180: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==180);
      case 185: /* col_name_list ::= col_name */ yytestcase(yyruleno==185);
      case 232: /* func_list ::= func */ yytestcase(yyruleno==232);
      case 305: /* literal_list ::= signed_literal */ yytestcase(yyruleno==305);
      case 367: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==367);
      case 421: /* select_list ::= select_item */ yytestcase(yyruleno==421);
      case 475: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==475);
{ yylhsminor.yy552 = createNodeList(pCxt, yymsp[0].minor.yy248); }
  yymsp[0].minor.yy552 = yylhsminor.yy552;
        break;
      case 108: /* retention_list ::= retention_list NK_COMMA retention */
      case 138: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==138);
      case 181: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==181);
      case 186: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==186);
      case 233: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==233);
      case 306: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==306);
      case 368: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==368);
      case 422: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==422);
      case 476: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==476);
{ yylhsminor.yy552 = addNodeToList(pCxt, yymsp[-2].minor.yy552, yymsp[0].minor.yy248); }
  yymsp[-2].minor.yy552 = yylhsminor.yy552;
        break;
      case 109: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy248 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 110: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 112: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==112);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy89, yymsp[-5].minor.yy248, yymsp[-3].minor.yy552, yymsp[-1].minor.yy552, yymsp[0].minor.yy248); }
        break;
      case 111: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy552); }
        break;
      case 113: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy552); }
        break;
      case 114: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy89, yymsp[0].minor.yy248); }
        break;
      case 115: /* cmd ::= ALTER TABLE alter_table_clause */
      case 116: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==116);
      case 282: /* cmd ::= query_expression */ yytestcase(yyruleno==282);
{ pCxt->pRootNode = yymsp[0].minor.yy248; }
        break;
      case 117: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy248 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy248, yymsp[0].minor.yy248); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 118: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy248 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy248, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy401, yymsp[0].minor.yy224); }
  yymsp[-4].minor.yy248 = yylhsminor.yy248;
        break;
      case 119: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy248 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy248, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy401); }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 120: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy248 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy248, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy401, yymsp[0].minor.yy224); }
  yymsp[-4].minor.yy248 = yylhsminor.yy248;
        break;
      case 121: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy248 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy248, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy401, &yymsp[0].minor.yy401); }
  yymsp[-4].minor.yy248 = yylhsminor.yy248;
        break;
      case 122: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy248 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy248, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy401, yymsp[0].minor.yy224); }
  yymsp[-4].minor.yy248 = yylhsminor.yy248;
        break;
      case 123: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy248 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy248, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy401); }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 124: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy248 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy248, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy401, yymsp[0].minor.yy224); }
  yymsp[-4].minor.yy248 = yylhsminor.yy248;
        break;
      case 125: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy248 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy248, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy401, &yymsp[0].minor.yy401); }
  yymsp[-4].minor.yy248 = yylhsminor.yy248;
        break;
      case 126: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy248 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy248, &yymsp[-2].minor.yy401, yymsp[0].minor.yy248); }
  yymsp[-5].minor.yy248 = yylhsminor.yy248;
        break;
      case 128: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 131: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==131);
{ yylhsminor.yy552 = addNodeToList(pCxt, yymsp[-1].minor.yy552, yymsp[0].minor.yy248); }
  yymsp[-1].minor.yy552 = yylhsminor.yy552;
        break;
      case 129: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy248 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy89, yymsp[-8].minor.yy248, yymsp[-6].minor.yy248, yymsp[-5].minor.yy552, yymsp[-2].minor.yy552, yymsp[0].minor.yy248); }
  yymsp[-9].minor.yy248 = yylhsminor.yy248;
        break;
      case 132: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy248 = createDropTableClause(pCxt, yymsp[-1].minor.yy89, yymsp[0].minor.yy248); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 133: /* specific_tags_opt ::= */
      case 164: /* tags_def_opt ::= */ yytestcase(yyruleno==164);
      case 430: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==430);
      case 447: /* group_by_clause_opt ::= */ yytestcase(yyruleno==447);
      case 463: /* order_by_clause_opt ::= */ yytestcase(yyruleno==463);
{ yymsp[1].minor.yy552 = NULL; }
        break;
      case 134: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy552 = yymsp[-1].minor.yy552; }
        break;
      case 135: /* full_table_name ::= table_name */
{ yylhsminor.yy248 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy401, NULL); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 136: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy248 = createRealTableNode(pCxt, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy401, NULL); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 139: /* column_def ::= column_name type_name */
{ yylhsminor.yy248 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy401, yymsp[0].minor.yy224, NULL); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 140: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy248 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy401, yymsp[-2].minor.yy224, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 141: /* type_name ::= BOOL */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 142: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 143: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 144: /* type_name ::= INT */
      case 145: /* type_name ::= INTEGER */ yytestcase(yyruleno==145);
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 146: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 147: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 148: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 149: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy224 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 150: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 151: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy224 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 152: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy224 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 153: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy224 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 154: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy224 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 155: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy224 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 156: /* type_name ::= JSON */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 157: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy224 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 158: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 159: /* type_name ::= BLOB */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 160: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy224 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 161: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 162: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy224 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 163: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy224 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 165: /* tags_def_opt ::= tags_def */
      case 366: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==366);
{ yylhsminor.yy552 = yymsp[0].minor.yy552; }
  yymsp[0].minor.yy552 = yylhsminor.yy552;
        break;
      case 166: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy552 = yymsp[-1].minor.yy552; }
        break;
      case 167: /* table_options ::= */
{ yymsp[1].minor.yy248 = createDefaultTableOptions(pCxt); }
        break;
      case 168: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy248 = setTableOption(pCxt, yymsp[-2].minor.yy248, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 169: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy248 = setTableOption(pCxt, yymsp[-2].minor.yy248, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy552); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 170: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy248 = setTableOption(pCxt, yymsp[-2].minor.yy248, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy552); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 171: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy248 = setTableOption(pCxt, yymsp[-4].minor.yy248, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy552); }
  yymsp[-4].minor.yy248 = yylhsminor.yy248;
        break;
      case 172: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy248 = setTableOption(pCxt, yymsp[-2].minor.yy248, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 173: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy248 = setTableOption(pCxt, yymsp[-4].minor.yy248, TABLE_OPTION_SMA, yymsp[-1].minor.yy552); }
  yymsp[-4].minor.yy248 = yylhsminor.yy248;
        break;
      case 174: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy248 = createAlterTableOptions(pCxt); yylhsminor.yy248 = setTableOption(pCxt, yylhsminor.yy248, yymsp[0].minor.yy301.type, &yymsp[0].minor.yy301.val); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 175: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy248 = setTableOption(pCxt, yymsp[-1].minor.yy248, yymsp[0].minor.yy301.type, &yymsp[0].minor.yy301.val); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 176: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy301.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 177: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy301.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 178: /* duration_list ::= duration_literal */
      case 334: /* expression_list ::= expression */ yytestcase(yyruleno==334);
{ yylhsminor.yy552 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy248)); }
  yymsp[0].minor.yy552 = yylhsminor.yy552;
        break;
      case 179: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 335: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==335);
{ yylhsminor.yy552 = addNodeToList(pCxt, yymsp[-2].minor.yy552, releaseRawExprNode(pCxt, yymsp[0].minor.yy248)); }
  yymsp[-2].minor.yy552 = yylhsminor.yy552;
        break;
      case 182: /* rollup_func_name ::= function_name */
{ yylhsminor.yy248 = createFunctionNode(pCxt, &yymsp[0].minor.yy401, NULL); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 183: /* rollup_func_name ::= FIRST */
      case 184: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==184);
{ yylhsminor.yy248 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 187: /* col_name ::= column_name */
{ yylhsminor.yy248 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy401); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 188: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 189: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 190: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 191: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy248, yymsp[0].minor.yy248, OP_TYPE_LIKE); }
        break;
      case 192: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy248, yymsp[0].minor.yy248, OP_TYPE_LIKE); }
        break;
      case 193: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy248, NULL, OP_TYPE_LIKE); }
        break;
      case 194: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 195: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 196: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 197: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 198: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy248, yymsp[-1].minor.yy248, OP_TYPE_EQUAL); }
        break;
      case 199: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 200: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 201: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 202: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 203: /* cmd ::= SHOW LICENCE */
      case 204: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==204);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT); }
        break;
      case 205: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy401); }
        break;
      case 206: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy248); }
        break;
      case 207: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy248); }
        break;
      case 208: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 209: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 210: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 211: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 212: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 213: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 214: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 217: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 218: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy248); }
        break;
      case 219: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 220: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 221: /* db_name_cond_opt ::= */
      case 226: /* from_db_opt ::= */ yytestcase(yyruleno==226);
{ yymsp[1].minor.yy248 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 222: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy401); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 223: /* like_pattern_opt ::= */
      case 263: /* into_opt ::= */ yytestcase(yyruleno==263);
      case 399: /* from_clause_opt ::= */ yytestcase(yyruleno==399);
      case 428: /* where_clause_opt ::= */ yytestcase(yyruleno==428);
      case 432: /* twindow_clause_opt ::= */ yytestcase(yyruleno==432);
      case 437: /* sliding_opt ::= */ yytestcase(yyruleno==437);
      case 439: /* fill_opt ::= */ yytestcase(yyruleno==439);
      case 451: /* having_clause_opt ::= */ yytestcase(yyruleno==451);
      case 453: /* range_opt ::= */ yytestcase(yyruleno==453);
      case 455: /* every_opt ::= */ yytestcase(yyruleno==455);
      case 465: /* slimit_clause_opt ::= */ yytestcase(yyruleno==465);
      case 469: /* limit_clause_opt ::= */ yytestcase(yyruleno==469);
{ yymsp[1].minor.yy248 = NULL; }
        break;
      case 224: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 225: /* table_name_cond ::= table_name */
{ yylhsminor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy401); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 227: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy401); }
        break;
      case 228: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy89, &yymsp[-3].minor.yy401, &yymsp[-1].minor.yy401, NULL, yymsp[0].minor.yy248); }
        break;
      case 229: /* cmd ::= DROP INDEX exists_opt index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy401); }
        break;
      case 230: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy248 = createIndexOption(pCxt, yymsp[-7].minor.yy552, releaseRawExprNode(pCxt, yymsp[-3].minor.yy248), NULL, yymsp[-1].minor.yy248, yymsp[0].minor.yy248); }
        break;
      case 231: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy248 = createIndexOption(pCxt, yymsp[-9].minor.yy552, releaseRawExprNode(pCxt, yymsp[-5].minor.yy248), releaseRawExprNode(pCxt, yymsp[-3].minor.yy248), yymsp[-1].minor.yy248, yymsp[0].minor.yy248); }
        break;
      case 234: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy248 = createFunctionNode(pCxt, &yymsp[-3].minor.yy401, yymsp[-1].minor.yy552); }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 235: /* sma_stream_opt ::= */
      case 265: /* stream_options ::= */ yytestcase(yyruleno==265);
{ yymsp[1].minor.yy248 = createStreamOptions(pCxt); }
        break;
      case 236: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 269: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==269);
{ ((SStreamOptions*)yymsp[-2].minor.yy248)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy248); yylhsminor.yy248 = yymsp[-2].minor.yy248; }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 237: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy248)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy248); yylhsminor.yy248 = yymsp[-2].minor.yy248; }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 238: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy89, &yymsp[-2].minor.yy401, yymsp[0].minor.yy248); }
        break;
      case 239: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy89, &yymsp[-3].minor.yy401, &yymsp[0].minor.yy401, false); }
        break;
      case 240: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy89, &yymsp[-5].minor.yy401, &yymsp[0].minor.yy401, true); }
        break;
      case 241: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy89, &yymsp[-3].minor.yy401, yymsp[0].minor.yy248, false); }
        break;
      case 242: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy89, &yymsp[-5].minor.yy401, yymsp[0].minor.yy248, true); }
        break;
      case 243: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy401); }
        break;
      case 244: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy89, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy401); }
        break;
      case 245: /* cmd ::= DESC full_table_name */
      case 246: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==246);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy248); }
        break;
      case 247: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 248: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy89, yymsp[-1].minor.yy248, yymsp[0].minor.yy248); }
        break;
      case 250: /* analyze_opt ::= ANALYZE */
      case 258: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==258);
      case 419: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==419);
{ yymsp[0].minor.yy89 = true; }
        break;
      case 251: /* explain_options ::= */
{ yymsp[1].minor.yy248 = createDefaultExplainOptions(pCxt); }
        break;
      case 252: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy248 = setExplainVerbose(pCxt, yymsp[-2].minor.yy248, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 253: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy248 = setExplainRatio(pCxt, yymsp[-2].minor.yy248, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 254: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy552); }
        break;
      case 255: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy89, yymsp[-8].minor.yy89, &yymsp[-5].minor.yy401, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy224, yymsp[0].minor.yy228); }
        break;
      case 256: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy401); }
        break;
      case 259: /* bufsize_opt ::= */
{ yymsp[1].minor.yy228 = 0; }
        break;
      case 260: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy228 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 261: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy89, &yymsp[-4].minor.yy401, yymsp[-2].minor.yy248, yymsp[-3].minor.yy248, yymsp[0].minor.yy248); }
        break;
      case 262: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy401); }
        break;
      case 264: /* into_opt ::= INTO full_table_name */
      case 400: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==400);
      case 429: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==429);
      case 452: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==452);
{ yymsp[-1].minor.yy248 = yymsp[0].minor.yy248; }
        break;
      case 266: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy248)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy248 = yymsp[-2].minor.yy248; }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 267: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy248)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy248 = yymsp[-2].minor.yy248; }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 268: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy248)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy248)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy248); yylhsminor.yy248 = yymsp[-3].minor.yy248; }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 270: /* stream_options ::= stream_options IGNORE EXPIRED */
{ ((SStreamOptions*)yymsp[-2].minor.yy248)->ignoreExpired = true; yylhsminor.yy248 = yymsp[-2].minor.yy248; }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 271: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 272: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 273: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 274: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 275: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 276: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy552); }
        break;
      case 277: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 278: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy552 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 280: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy401); }
        break;
      case 281: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy248, yymsp[0].minor.yy248); }
        break;
      case 283: /* literal ::= NK_INTEGER */
{ yylhsminor.yy248 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 284: /* literal ::= NK_FLOAT */
{ yylhsminor.yy248 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 285: /* literal ::= NK_STRING */
{ yylhsminor.yy248 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 286: /* literal ::= NK_BOOL */
{ yylhsminor.yy248 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 287: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 288: /* literal ::= duration_literal */
      case 298: /* signed_literal ::= signed */ yytestcase(yyruleno==298);
      case 318: /* expression ::= literal */ yytestcase(yyruleno==318);
      case 319: /* expression ::= pseudo_column */ yytestcase(yyruleno==319);
      case 320: /* expression ::= column_reference */ yytestcase(yyruleno==320);
      case 321: /* expression ::= function_expression */ yytestcase(yyruleno==321);
      case 322: /* expression ::= subquery */ yytestcase(yyruleno==322);
      case 349: /* function_expression ::= literal_func */ yytestcase(yyruleno==349);
      case 391: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==391);
      case 395: /* boolean_primary ::= predicate */ yytestcase(yyruleno==395);
      case 397: /* common_expression ::= expression */ yytestcase(yyruleno==397);
      case 398: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==398);
      case 401: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==401);
      case 403: /* table_reference ::= table_primary */ yytestcase(yyruleno==403);
      case 404: /* table_reference ::= joined_table */ yytestcase(yyruleno==404);
      case 408: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==408);
      case 458: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==458);
      case 461: /* query_primary ::= query_specification */ yytestcase(yyruleno==461);
{ yylhsminor.yy248 = yymsp[0].minor.yy248; }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 289: /* literal ::= NULL */
{ yylhsminor.yy248 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 290: /* literal ::= NK_QUESTION */
{ yylhsminor.yy248 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 291: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy248 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 292: /* signed ::= NK_INTEGER */
{ yylhsminor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 293: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 294: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 295: /* signed ::= NK_FLOAT */
{ yylhsminor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 296: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 297: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 299: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 300: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 301: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 302: /* signed_literal ::= duration_literal */
      case 304: /* signed_literal ::= literal_func */ yytestcase(yyruleno==304);
      case 369: /* star_func_para ::= expression */ yytestcase(yyruleno==369);
      case 424: /* select_item ::= common_expression */ yytestcase(yyruleno==424);
      case 474: /* search_condition ::= common_expression */ yytestcase(yyruleno==474);
{ yylhsminor.yy248 = releaseRawExprNode(pCxt, yymsp[0].minor.yy248); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 303: /* signed_literal ::= NULL */
{ yylhsminor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 323: /* expression ::= NK_LP expression NK_RP */
      case 396: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==396);
{ yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy248)); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 324: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy248));
                                                                                  }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 325: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy248), NULL));
                                                                                  }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 326: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248))); 
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 327: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248))); 
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 328: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248))); 
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 329: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248))); 
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 330: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248)));
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 331: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 332: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248)));
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 333: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248)));
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 336: /* column_reference ::= column_name */
{ yylhsminor.yy248 = createRawExprNode(pCxt, &yymsp[0].minor.yy401, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy401)); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 337: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy401, createColumnNode(pCxt, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy401)); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 338: /* pseudo_column ::= ROWTS */
      case 339: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==339);
      case 341: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==341);
      case 342: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==342);
      case 343: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==343);
      case 344: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==344);
      case 345: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==345);
      case 351: /* literal_func ::= NOW */ yytestcase(yyruleno==351);
{ yylhsminor.yy248 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 340: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy401)))); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 346: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 347: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==347);
{ yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy401, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy401, yymsp[-1].minor.yy552)); }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 348: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy248), yymsp[-1].minor.yy224)); }
  yymsp[-5].minor.yy248 = yylhsminor.yy248;
        break;
      case 350: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy401, NULL)); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 365: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy552 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy552 = yylhsminor.yy552;
        break;
      case 370: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 427: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==427);
{ yylhsminor.yy248 = createColumnNode(pCxt, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 371: /* predicate ::= expression compare_op expression */
      case 376: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==376);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy716, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248)));
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 372: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy248), releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248)));
                                                                                  }
  yymsp[-4].minor.yy248 = yylhsminor.yy248;
        break;
      case 373: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy248), releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248)));
                                                                                  }
  yymsp[-5].minor.yy248 = yylhsminor.yy248;
        break;
      case 374: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), NULL));
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 375: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy248), NULL));
                                                                                  }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 377: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy716 = OP_TYPE_LOWER_THAN; }
        break;
      case 378: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy716 = OP_TYPE_GREATER_THAN; }
        break;
      case 379: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy716 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 380: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy716 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 381: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy716 = OP_TYPE_NOT_EQUAL; }
        break;
      case 382: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy716 = OP_TYPE_EQUAL; }
        break;
      case 383: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy716 = OP_TYPE_LIKE; }
        break;
      case 384: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy716 = OP_TYPE_NOT_LIKE; }
        break;
      case 385: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy716 = OP_TYPE_MATCH; }
        break;
      case 386: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy716 = OP_TYPE_NMATCH; }
        break;
      case 387: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy716 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 388: /* in_op ::= IN */
{ yymsp[0].minor.yy716 = OP_TYPE_IN; }
        break;
      case 389: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy716 = OP_TYPE_NOT_IN; }
        break;
      case 390: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy552)); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 392: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy248), NULL));
                                                                                  }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 393: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248)));
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 394: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248)));
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 402: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy248 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy248, yymsp[0].minor.yy248, NULL); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 405: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy248 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy401, &yymsp[0].minor.yy401); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 406: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy248 = createRealTableNode(pCxt, &yymsp[-3].minor.yy401, &yymsp[-1].minor.yy401, &yymsp[0].minor.yy401); }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 407: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy248 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy248), &yymsp[0].minor.yy401); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 409: /* alias_opt ::= */
{ yymsp[1].minor.yy401 = nil_token;  }
        break;
      case 410: /* alias_opt ::= table_alias */
{ yylhsminor.yy401 = yymsp[0].minor.yy401; }
  yymsp[0].minor.yy401 = yylhsminor.yy401;
        break;
      case 411: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy401 = yymsp[0].minor.yy401; }
        break;
      case 412: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 413: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==413);
{ yymsp[-2].minor.yy248 = yymsp[-1].minor.yy248; }
        break;
      case 414: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy248 = createJoinTableNode(pCxt, yymsp[-4].minor.yy52, yymsp[-5].minor.yy248, yymsp[-2].minor.yy248, yymsp[0].minor.yy248); }
  yymsp[-5].minor.yy248 = yylhsminor.yy248;
        break;
      case 415: /* join_type ::= */
{ yymsp[1].minor.yy52 = JOIN_TYPE_INNER; }
        break;
      case 416: /* join_type ::= INNER */
{ yymsp[0].minor.yy52 = JOIN_TYPE_INNER; }
        break;
      case 417: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy248 = createSelectStmt(pCxt, yymsp[-10].minor.yy89, yymsp[-9].minor.yy552, yymsp[-8].minor.yy248);
                                                                                    yymsp[-11].minor.yy248 = addWhereClause(pCxt, yymsp[-11].minor.yy248, yymsp[-7].minor.yy248);
                                                                                    yymsp[-11].minor.yy248 = addPartitionByClause(pCxt, yymsp[-11].minor.yy248, yymsp[-6].minor.yy552);
                                                                                    yymsp[-11].minor.yy248 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy248, yymsp[-2].minor.yy248);
                                                                                    yymsp[-11].minor.yy248 = addGroupByClause(pCxt, yymsp[-11].minor.yy248, yymsp[-1].minor.yy552);
                                                                                    yymsp[-11].minor.yy248 = addHavingClause(pCxt, yymsp[-11].minor.yy248, yymsp[0].minor.yy248);
                                                                                    yymsp[-11].minor.yy248 = addRangeClause(pCxt, yymsp[-11].minor.yy248, yymsp[-5].minor.yy248);
                                                                                    yymsp[-11].minor.yy248 = addEveryClause(pCxt, yymsp[-11].minor.yy248, yymsp[-4].minor.yy248);
                                                                                    yymsp[-11].minor.yy248 = addFillClause(pCxt, yymsp[-11].minor.yy248, yymsp[-3].minor.yy248);
                                                                                  }
        break;
      case 420: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy89 = false; }
        break;
      case 423: /* select_item ::= NK_STAR */
{ yylhsminor.yy248 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 425: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy248 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy248), &yymsp[0].minor.yy401); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 426: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy248 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), &yymsp[0].minor.yy401); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 431: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 448: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==448);
      case 464: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==464);
{ yymsp[-2].minor.yy552 = yymsp[0].minor.yy552; }
        break;
      case 433: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy248 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy248), releaseRawExprNode(pCxt, yymsp[-1].minor.yy248)); }
        break;
      case 434: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy248 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy248)); }
        break;
      case 435: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy248 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy248), NULL, yymsp[-1].minor.yy248, yymsp[0].minor.yy248); }
        break;
      case 436: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy248 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy248), releaseRawExprNode(pCxt, yymsp[-3].minor.yy248), yymsp[-1].minor.yy248, yymsp[0].minor.yy248); }
        break;
      case 438: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 456: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==456);
{ yymsp[-3].minor.yy248 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy248); }
        break;
      case 440: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy248 = createFillNode(pCxt, yymsp[-1].minor.yy582, NULL); }
        break;
      case 441: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy248 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy552)); }
        break;
      case 442: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy582 = FILL_MODE_NONE; }
        break;
      case 443: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy582 = FILL_MODE_PREV; }
        break;
      case 444: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy582 = FILL_MODE_NULL; }
        break;
      case 445: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy582 = FILL_MODE_LINEAR; }
        break;
      case 446: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy582 = FILL_MODE_NEXT; }
        break;
      case 449: /* group_by_list ::= expression */
{ yylhsminor.yy552 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy248))); }
  yymsp[0].minor.yy552 = yylhsminor.yy552;
        break;
      case 450: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy552 = addNodeToList(pCxt, yymsp[-2].minor.yy552, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy248))); }
  yymsp[-2].minor.yy552 = yylhsminor.yy552;
        break;
      case 454: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy248 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy248), releaseRawExprNode(pCxt, yymsp[-1].minor.yy248)); }
        break;
      case 457: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy248 = addOrderByClause(pCxt, yymsp[-3].minor.yy248, yymsp[-2].minor.yy552);
                                                                                    yylhsminor.yy248 = addSlimitClause(pCxt, yylhsminor.yy248, yymsp[-1].minor.yy248);
                                                                                    yylhsminor.yy248 = addLimitClause(pCxt, yylhsminor.yy248, yymsp[0].minor.yy248);
                                                                                  }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 459: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy248 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy248, yymsp[0].minor.yy248); }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 460: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy248 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy248, yymsp[0].minor.yy248); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 462: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy248 = yymsp[-4].minor.yy248; }
  yy_destructor(yypParser,368,&yymsp[-3].minor);
  yy_destructor(yypParser,369,&yymsp[-2].minor);
  yy_destructor(yypParser,370,&yymsp[-1].minor);
        break;
      case 466: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 470: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==470);
{ yymsp[-1].minor.yy248 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 467: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 471: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==471);
{ yymsp[-3].minor.yy248 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 468: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 472: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==472);
{ yymsp[-3].minor.yy248 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 473: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy248); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 477: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy248 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), yymsp[-1].minor.yy482, yymsp[0].minor.yy345); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 478: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy482 = ORDER_ASC; }
        break;
      case 479: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy482 = ORDER_ASC; }
        break;
      case 480: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy482 = ORDER_DESC; }
        break;
      case 481: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy345 = NULL_ORDER_DEFAULT; }
        break;
      case 482: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy345 = NULL_ORDER_FIRST; }
        break;
      case 483: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy345 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
