/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 472
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  int32_t yy20;
  EOrder yy34;
  bool yy89;
  int64_t yy93;
  SToken yy97;
  EJoinType yy116;
  ENullOrder yy265;
  SAlterOption yy285;
  EOperatorType yy396;
  int8_t yy519;
  SNodeList* yy520;
  STokenPair yy569;
  EFillMode yy646;
  SNode* yy792;
  SDataType yy848;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             755
#define YYNRULE              575
#define YYNTOKEN             328
#define YY_MAX_SHIFT         754
#define YY_MIN_SHIFTREDUCE   1123
#define YY_MAX_SHIFTREDUCE   1697
#define YY_ERROR_ACTION      1698
#define YY_ACCEPT_ACTION     1699
#define YY_NO_ACTION         1700
#define YY_MIN_REDUCE        1701
#define YY_MAX_REDUCE        2275
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2778)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  2087,  494, 1920, 1986,  495, 1737, 1856,  644, 1867,  366,
 /*    10 */   661, 1965,   46,   44, 1625,  379, 2073, 1918, 1983,  631,
 /*    20 */   388,  601, 1474,   39,   38,  133, 2069,   45,   43,   42,
 /*    30 */    41,   40,  532, 1555,  123, 1472, 2105,  122,  121,  120,
 /*    40 */   119,  118,  117,  116,  115,  114,  499, 2105, 2055, 1178,
 /*    50 */   660, 1177,  496,  427, 1986,  192, 2087,  426, 1858, 1550,
 /*    60 */  2065, 2071,  369,   66,  226,   19,  661,  511, 2069, 1984,
 /*    70 */   631,  654, 1480,  180,  502,  619,  140,  495, 1737, 2086,
 /*    80 */   348, 1179, 1247, 2122,  643, 1907,  169, 2088,  664, 2090,
 /*    90 */  2091,  659, 2105,  654,  177, 1499,  434,  751,  582,  600,
 /*   100 */    15, 2246, 2065, 2071, 2055, 1499,  660,  619,  140,  435,
 /*   110 */    46,   44, 1474,  654,  355, 1969, 2252,  184,  388, 1249,
 /*   120 */  1474, 2247,  608,  167, 1584, 1472,  583, 2212,  209, 1699,
 /*   130 */  1812, 1555,  497, 1472, 1744, 2086, 1557, 1558, 2073, 2122,
 /*   140 */  1950, 1965,  110, 2088,  664, 2090, 2091,  659, 2069,  654,
 /*   150 */  1156,  168,  143, 1713,  150, 2146, 2175, 1550,   62,   62,
 /*   160 */   382, 2171, 1480,   19,   49,  211, 1530, 1540,  643,  497,
 /*   170 */  1480, 1744, 1556, 1559,  273, 2183,  618,  643,  134,  617,
 /*   180 */  1585, 2246, 2065, 2071,  370,  194, 1475,  751, 1473, 1158,
 /*   190 */   629, 1161, 1162,  654, 2073,  751,  606,  184,   15,  401,
 /*   200 */  1499, 2247,  608,  400, 2069,  621,  182, 2183, 2184, 1843,
 /*   210 */   138, 2188, 1478, 1479, 1773, 1529, 1532, 1533, 1534, 1535,
 /*   220 */  1536, 1537, 1538, 1539,  656,  652, 1548, 1549, 1551, 1552,
 /*   230 */  1553, 1554,    2,  393, 1557, 1558, 1913, 1915, 2065, 2071,
 /*   240 */   383, 1393, 1394,  425,  582,  424,  698, 2246,   49,  654,
 /*   250 */    87,   35,  386, 1579, 1580, 1581, 1582, 1583, 1587, 1588,
 /*   260 */  1589, 1590, 2252,  184, 1530, 1540,  357, 2247,  608,  423,
 /*   270 */  1556, 1559, 1920,  698,  607, 1862, 1475, 2246, 1473,  376,
 /*   280 */    62,  548,  547,  546, 1475, 1629, 1473, 1918,  538,  137,
 /*   290 */   542, 1499,  606,  184,  541,  451, 1653, 2247,  608,  540,
 /*   300 */   545,  602, 1478, 1479,  450,  539, 2023,  187,  187, 1500,
 /*   310 */  1478, 1479, 1844, 1529, 1532, 1533, 1534, 1535, 1536, 1537,
 /*   320 */  1538, 1539,  656,  652, 1548, 1549, 1551, 1552, 1553, 1554,
 /*   330 */     2,   12,   46,   44,  644, 1867,  644, 1867,  696, 1724,
 /*   340 */   388, 1702, 1474,  594,  593, 1651, 1652, 1654, 1655, 1656,
 /*   350 */   625,  244,  189, 1555,   55, 1472,  155,  154,  693,  692,
 /*   360 */   691,  152,  123,  433, 1498,  122,  121,  120,  119,  118,
 /*   370 */   117,  116,  115,  114,   45,   43,   42,   41,   40, 1550,
 /*   380 */   276,  548,  547,  546,  243,   19, 1920, 2055,  538,  137,
 /*   390 */   542,  571, 1480,  381,  541,  582, 1164,  187, 2246,  540,
 /*   400 */   545, 1918, 1498,   39,   38,  539,  336,   45,   43,   42,
 /*   410 */    41,   40, 2087, 2252,  184, 2190, 2251,  751, 2247,  608,
 /*   420 */    15,   62,  661,   93,  696, 1338, 1339,  619,  140,  187,
 /*   430 */    46,   44, 1560, 1501,  644, 1867,  597, 1531,  388, 1701,
 /*   440 */  1474, 2187,  155,  154,  693,  692,  691,  152, 2105, 1448,
 /*   450 */  1449, 1555,  133, 1472,  644, 1867, 1557, 1558,   62,  537,
 /*   460 */  2055,  630,  660,  132,  131,  130,  129,  128,  127,  126,
 /*   470 */   125,  124,  431,  630, 2087,   39,   38, 1550,   12,   45,
 /*   480 */    43,   42,   41,   40,  622, 1965, 1530, 1540,  380,  165,
 /*   490 */  1480, 2086, 1556, 1559, 1258, 2122,  165, 1870,  111, 2088,
 /*   500 */   664, 2090, 2091,  659, 1869,  654, 1475, 1257, 1473, 1501,
 /*   510 */  2105,  509, 2175, 1979, 1687,  751, 2174, 2171,   47,  603,
 /*   520 */   598,  591, 2055,  628,  660, 1979,  183, 2183, 2184,  198,
 /*   530 */   138, 2188, 1478, 1479,   87, 1529, 1532, 1533, 1534, 1535,
 /*   540 */  1536, 1537, 1538, 1539,  656,  652, 1548, 1549, 1551, 1552,
 /*   550 */  1553, 1554,    2, 2086, 1557, 1558, 2250, 2122,  196, 1863,
 /*   560 */   110, 2088,  664, 2090, 2091,  659, 2190,  654, 1664,  480,
 /*   570 */   187, 1723,  181, 1694, 2175, 1480,  619,  140,  382, 2171,
 /*   580 */   391,  275,  644, 1867, 1530, 1540,  611, 1920,  162,  391,
 /*   590 */  1556, 1559, 2186, 1304,  353,  367, 1869,  165,   84, 2202,
 /*   600 */   432,   83, 1918, 1918, 1475, 1869, 1473,  187,  630, 1295,
 /*   610 */   686,  685,  684, 1299,  683, 1301, 1302,  682,  679, 2055,
 /*   620 */  1310,  676, 1312, 1313,  673,  670, 1565,   42,   41,   40,
 /*   630 */  1478, 1479, 1499, 1529, 1532, 1533, 1534, 1535, 1536, 1537,
 /*   640 */  1538, 1539,  656,  652, 1548, 1549, 1551, 1552, 1553, 1554,
 /*   650 */     2,   46,   44,  710, 2087,  644, 1867,  275,  639,  388,
 /*   660 */  1979, 1474,  394,  607,  661,   12, 2246,   10,  553, 1693,
 /*   670 */   165, 1262, 1555,  441, 1472,  185, 2183, 2184, 1869,  138,
 /*   680 */  2188,  606,  184,  563, 1261,  360, 2247,  608,   39,   38,
 /*   690 */  2105,  107,   45,   43,   42,   41,   40,  240, 1550,  644,
 /*   700 */  1867, 1920, 2055, 2190,  660,  242,    9,  141,  392,  241,
 /*   710 */  1722, 1480,  153,  556,  177, 1859, 1918,  456,  550,  142,
 /*   720 */    39,   38, 2146,  239,   45,   43,   42,   41,   40, 2185,
 /*   730 */   644, 1867, 1502, 2086,  471, 1970,  751, 2122, 1502,   47,
 /*   740 */   170, 2088,  664, 2090, 2091,  659,  482,  654,  457,   46,
 /*   750 */    44,  361, 2087,  359,  358,  689,  534,  388, 2055, 1474,
 /*   760 */   536, 1852,  658,   70,  644, 1867,   69,   90,  343,   54,
 /*   770 */  1555,  365, 1472,  564, 2251, 1557, 1558, 2246, 1531,   39,
 /*   780 */    38,  535,  510,   45,   43,   42,   41,   40, 2105,  644,
 /*   790 */  1867,  609, 2267, 2250,  200,  199, 1550, 2247, 2249,   50,
 /*   800 */  2055,  562,  660,  644, 1867, 1530, 1540, 1864,  646, 1480,
 /*   810 */  2147, 1556, 1559,  612,  560,   28,  558,  470,  644, 1867,
 /*   820 */  1586,  245,  610,  285,  286, 1475,  420, 1473,  284,  101,
 /*   830 */  1500, 2086,  644, 1867,  751, 2122,  578,   15,  330, 2088,
 /*   840 */   664, 2090, 2091,  659,  657,  654,  645, 2140,  422,  418,
 /*   850 */   623, 1478, 1479, 1860, 1529, 1532, 1533, 1534, 1535, 1536,
 /*   860 */  1537, 1538, 1539,  656,  652, 1548, 1549, 1551, 1552, 1553,
 /*   870 */  1554,    2, 1842, 1557, 1558,   36,  294,   39,   38, 1854,
 /*   880 */   253,   45,   43,   42,   41,   40,  193,   14,   13,  644,
 /*   890 */  1867,   33,  648,  339, 2147, 1497,  644, 1867, 1178, 1850,
 /*   900 */  1177, 1591,  464, 1530, 1540,  478,   32,  627,  477, 1556,
 /*   910 */  1559,  688,   39,   38,  289, 1618,   45,   43,   42,   41,
 /*   920 */    40,   34, 1622, 1475,  447, 1473,  479,   39,   38,  449,
 /*   930 */  1179,   45,   43,   42,   41,   40,   39,   38, 1914, 1915,
 /*   940 */    45,   43,   42,   41,   40, 2048, 1410, 1411,  187, 1478,
 /*   950 */  1479, 1499, 1529, 1532, 1533, 1534, 1535, 1536, 1537, 1538,
 /*   960 */  1539,  656,  652, 1548, 1549, 1551, 1552, 1553, 1554,    2,
 /*   970 */  1641,  644, 1867,  536,  356, 1770, 2251,  544,  543, 2246,
 /*   980 */   644, 1867, 1409, 1412,  696,  690,  437, 1598, 1911,  641,
 /*   990 */   582, 1721, 1720, 2246,  535, 2250,  722,  720,  642, 2247,
 /*  1000 */  2248, 1920,  155,  154,  693,  692,  691,  152, 2252,  184,
 /*  1010 */  1161, 1162,  614, 2247,  608,  475, 1919,  577,  469,  468,
 /*  1020 */   467,  466,  463,  462,  461,  460,  459,  455,  454,  453,
 /*  1030 */   452,  338,  444,  443,  442, 2049,  439,  438,  354, 2055,
 /*  1040 */  2055,  248,  728,  727,  726,  725,  398, 1719,  724,  723,
 /*  1050 */   144,  718,  717,  716,  715,  714,  713,  712,  157,  708,
 /*  1060 */   707,  706,  397,  396,  703,  702,  701,  700,  699,  166,
 /*  1070 */   694, 2087, 1718, 1911,  314,  644, 1867, 1717, 1716, 1502,
 /*  1080 */   582,  622, 1715, 2246,  644, 1867, 2195, 1618,  312,   73,
 /*  1090 */  2074, 2087,   72,  295, 1712, 2055,  164, 1531, 2252,  184,
 /*  1100 */  2069,  661,  395, 2247,  608, 1711,  695, 2105, 1710, 1911,
 /*  1110 */  1760,  207,  490,  488,  485, 1709, 1483, 1708, 1707, 2055,
 /*  1120 */  2055,  660, 1753,  581, 1706, 2055, 2055, 2105,  308, 1845,
 /*  1130 */  2055, 1897,  549,  232, 2065, 2071,  230, 1705, 1704, 2055,
 /*  1140 */   234,  660, 2055,  233,  551,  654,  569,  711, 1714, 1829,
 /*  1150 */  2086,   62, 2041, 2055, 2122,   74, 2055,  110, 2088,  664,
 /*  1160 */  2090, 2091,  659, 2055,  654, 2055, 2055,  153, 1621,  181,
 /*  1170 */  2086, 2175, 2055,  148, 2122,  382, 2171,  169, 2088,  664,
 /*  1180 */  2090, 2091,  659,  153,  654, 2055, 2055, 2087,  186,  109,
 /*  1190 */    52,  582,    3,  146, 2246,  135, 2201,  661, 1751, 1746,
 /*  1200 */   236,  408,  238,  235,   82,  237,  566,   64,  565, 2252,
 /*  1210 */   184,   64,  251,  655, 2247,  608, 1696, 1697, 2213, 1482,
 /*  1220 */   554,  651,  257, 2105, 1443,  153,   48,  252,  270,   81,
 /*  1230 */    80,  430,  282,   71,  191, 2055, 2087,  660,  151,  153,
 /*  1240 */  1446,  615, 2215,   53,   64,   48,  661, 1747, 2209, 1813,
 /*  1250 */    14,   13, 2076,  337,   48,   91,  416,  668,  414,  410,
 /*  1260 */   406,  403,  423,  151, 1650,  225, 2086,  595, 1649, 1486,
 /*  1270 */  2122,  153, 2105,  110, 2088,  664, 2090, 2091,  659,  259,
 /*  1280 */   654,  136,  626, 1407, 2055, 2266,  660, 2175,  151,  287,
 /*  1290 */   636,  382, 2171,  106, 2087,  291, 1288,  746, 1208,  704,
 /*  1300 */   187, 1592, 1541,  103,  661, 2078, 2222,  264, 2106,  705,
 /*  1310 */   399,  307, 1974, 1738, 1316, 2086, 1908, 1743, 2205, 2122,
 /*  1320 */  1320, 1227,  110, 2088,  664, 2090, 2091,  659, 1327,  654,
 /*  1330 */  2105, 1225,  620,  272, 2266, 1209, 2175,  269, 1325,    1,
 /*  1340 */   382, 2171, 2055,    5,  660,  156,  402,  407,  352, 1430,
 /*  1350 */   302,  197, 2087,  436, 1502,  445,  440,  473, 1975, 1497,
 /*  1360 */   458,  472,  661, 1967,  589,  465,  474,  483, 1576,  484,
 /*  1370 */   481,  202, 1485, 2086,  486,  201,  487, 2122,  204,  489,
 /*  1380 */   110, 2088,  664, 2090, 2091,  659,  491,  654, 2105, 1503,
 /*  1390 */   492,    4, 2266,  493, 2175,  500, 2087,  501,  382, 2171,
 /*  1400 */  2055, 1505,  660,  503, 1500, 1504,  661, 1506, 2240,  212,
 /*  1410 */   505,  504,  214,  506,  217,  508,  512,  219,   85,   86,
 /*  1420 */   223, 1181,  529,  530, 2087,  533, 2032,  531, 2029,  112,
 /*  1430 */  1857, 2086, 2105, 2028,  661, 2122, 2194,  342,  110, 2088,
 /*  1440 */   664, 2090, 2091,  659, 2055,  654,  660,  568,  385,  384,
 /*  1450 */  2266,  229, 2175, 1853,  231,  158,  382, 2171, 1488,  570,
 /*  1460 */  2105,   89,  159,  246, 1855,  249, 1851,  160,  161, 1555,
 /*  1470 */   579, 1481, 2055,  572,  660, 2086,  596, 2221,  634, 2122,
 /*  1480 */  2206,  149,  110, 2088,  664, 2090, 2091,  659,  303,  654,
 /*  1490 */   576, 2216,  586,  592, 2266, 1550, 2175,  255,    8,  371,
 /*  1500 */   382, 2171,  258, 2086, 2220,  599, 2087, 2122, 1480,  573,
 /*  1510 */   110, 2088,  664, 2090, 2091,  659,  661,  654,  605,  173,
 /*  1520 */   587, 2087, 2266,  585, 2175,  584,  372,  268,  382, 2171,
 /*  1530 */   616,  661,  613,  650, 2197,  266,  263, 1618,  139, 1501,
 /*  1540 */  2191,  265, 2105,  624,  375,  277, 1507, 1980,  304,  632,
 /*  1550 */    96,  633, 1994, 1993, 2055,  267,  660, 2105, 1992,  378,
 /*  1560 */   305,  637,  638,   98, 1868,   61,  100, 2087, 2156, 2055,
 /*  1570 */   306,  660,  102, 1830,  309, 1912, 2245,  661, 2269,  666,
 /*  1580 */   271,  298,  747,  333,  748, 2086,  750,   51,  313, 2122,
 /*  1590 */   318, 2087,  324, 2088,  664, 2090, 2091,  659, 2047,  654,
 /*  1600 */  2086,  661,  332, 2105, 2122, 2046,  344,  110, 2088,  664,
 /*  1610 */  2090, 2091,  659,  311,  654, 2055,  322,  660, 2045, 2150,
 /*  1620 */   345, 2175, 1489, 2087, 1484,  382, 2171, 2105,   78, 2042,
 /*  1630 */   404, 1465,  405,  661, 1466,  604,  409,  190, 2040, 2055,
 /*  1640 */   413,  660,  411,  412, 2039,  415, 2086, 2038, 1492, 1494,
 /*  1650 */  2122,  417, 2037,  170, 2088,  664, 2090, 2091,  659, 2105,
 /*  1660 */   654,  652, 1548, 1549, 1551, 1552, 1553, 1554,  419, 2036,
 /*  1670 */  2086, 2055,  421,  660, 2122,   79, 1433,  110, 2088,  664,
 /*  1680 */  2090, 2091,  659, 1432,  654, 2006, 2005, 2004,  428, 2148,
 /*  1690 */   429, 2175, 2003, 2002, 2087,  382, 2171, 1958, 1384, 1957,
 /*  1700 */  1955,  145, 2086, 1954,  661, 2268, 2122, 1953, 1956,  110,
 /*  1710 */  2088,  664, 2090, 2091,  659, 1952,  654, 1951, 1949, 1948,
 /*  1720 */  1947,  647,  195, 2175, 2087,  446, 1946,  382, 2171,  448,
 /*  1730 */  2105, 1960, 1945, 1944,  661, 1943, 1942, 1941, 1940, 1939,
 /*  1740 */  1938, 1937, 2055, 1936,  660, 1935, 1934, 1933, 1932, 1931,
 /*  1750 */  1930,  147, 1929, 1928, 1959, 1927, 2087, 1926, 1925, 1924,
 /*  1760 */  2105, 1923,  476, 1922, 1386, 1921,  661, 1776, 1775,  340,
 /*  1770 */   203,  341, 2055, 2086,  660,  205, 1774, 2122, 1259, 1255,
 /*  1780 */   111, 2088,  664, 2090, 2091,  659, 1263,  654,  206, 1772,
 /*  1790 */  2087, 1733, 2105,  208, 2175, 1163, 1732, 2019,  649, 2171,
 /*  1800 */   661,   76, 2013,  662, 2055,   77,  660, 2122, 2001,  210,
 /*  1810 */   111, 2088,  664, 2090, 2091,  659,  178,  654, 2075,  216,
 /*  1820 */   179,  498,  218, 2000, 2175, 1978, 2105,  513,  347, 2171,
 /*  1830 */  1846,  377, 1771, 1769,  514, 2086, 1201,  515, 2055, 2122,
 /*  1840 */   660, 1767,  111, 2088,  664, 2090, 2091,  659, 2087,  654,
 /*  1850 */   517,  519,  518, 1765,  521,  522, 2175,  523,  658, 1763,
 /*  1860 */   526, 2172, 1750,  525, 1749, 2087, 1729, 1848,  527, 2086,
 /*  1870 */  1332, 1331, 1847, 2122, 1246,  661,  331, 2088,  664, 2090,
 /*  1880 */  2091,  659,  228,  654, 2105, 1245,   63, 1244,  719, 1243,
 /*  1890 */  1242,  721, 1239, 1238, 1761, 1237, 2055,  362,  660,  363,
 /*  1900 */  1236, 2105, 1754, 1752,  364,  555,  387,  552, 1728, 2087,
 /*  1910 */  1727,  557, 1726, 2055,  559,  660,  113,  561, 1453,  661,
 /*  1920 */  1455, 1452, 1457, 2018,   27, 1439,   67, 2086,   56, 2012,
 /*  1930 */  1999, 2122, 2087,  754,  330, 2088,  664, 2090, 2091,  659,
 /*  1940 */   574,  654,  661, 2141, 2086, 2105, 1997,  301, 2122,  250,
 /*  1950 */   389,  331, 2088,  664, 2090, 2091,  659, 2055,  654,  660,
 /*  1960 */  2251,  575,  368,  176,   20,  580,   17,    6, 2105,  744,
 /*  1970 */   740,  736,  732,  299,   29,  163,    7,  590,  588, 1666,
 /*  1980 */  2055, 2087,  660,   59,  254,   60,  261,  171, 2086,  256,
 /*  1990 */  1648,  661, 2122,  260,  262,  331, 2088,  664, 2090, 2091,
 /*  2000 */   659,   30,  654, 2076,   31, 1640,   92,   65, 1686,   22,
 /*  2010 */  1687,  567, 1681,  108, 1680, 2122,  292, 2105,  326, 2088,
 /*  2020 */   664, 2090, 2091,  659,  373,  654, 1685, 1684,  374, 2055,
 /*  2030 */   274,  660, 1615, 1614,   57,   21,   18, 2087,   58, 1998,
 /*  2040 */  1996, 1995,  174, 1977,   94,   95,  280,  661,  640,   23,
 /*  2050 */  1976,  281, 1646, 2087,  283,  288,  293,   97,  103,   68,
 /*  2060 */  2086,  290,  635,  661, 2122,   24,   99,  315, 2088,  664,
 /*  2070 */  2090, 2091,  659, 2105,  654, 1490, 1567,   11, 1566,   13,
 /*  2080 */  1577, 2125,  653,  279,   37, 2055, 1545,  660,  278, 2105,
 /*  2090 */  1522, 1543,  175,  188,  667,  390,  671, 1542,   16,  665,
 /*  2100 */    25, 2055, 1514,  660, 1437,   26,  247,  674, 1317, 2087,
 /*  2110 */   669,  663, 1314,  672,  677, 1311, 2086, 1305,  680,  661,
 /*  2120 */  2122, 1303,  675,  316, 2088,  664, 2090, 2091,  659,  678,
 /*  2130 */   654,  681, 2086, 1294,  104, 1309, 2122,  296, 1308,  317,
 /*  2140 */  2088,  664, 2090, 2091,  659, 2105,  654, 1307, 1306,  687,
 /*  2150 */  1326,  105,   75, 1322, 1233, 1199,  697, 2055, 2087,  660,
 /*  2160 */  1232, 1231, 1230, 1229, 1228, 1226, 1253, 1224,  661, 1223,
 /*  2170 */  1222, 2087,  709, 1220, 1219, 1218, 1217,  297, 1216, 1215,
 /*  2180 */  1214,  661, 1250, 1248, 1211, 1210, 1207, 1206, 2086, 1205,
 /*  2190 */  1204, 1768, 2122, 1766, 2105,  323, 2088,  664, 2090, 2091,
 /*  2200 */   659,  729,  654,  731,  733,  730, 2055, 2105,  660,  734,
 /*  2210 */   735, 1764,  737,  739,  738, 1762,  741,  742,  743, 2055,
 /*  2220 */  1748,  660,  745, 1153, 1725,  300,  749, 1700, 1476,  752,
 /*  2230 */  2087,  310,  753, 1700, 1700, 1700, 1700, 2086, 1700, 1700,
 /*  2240 */   661, 2122, 1700, 1700,  327, 2088,  664, 2090, 2091,  659,
 /*  2250 */  2086,  654, 1700, 1700, 2122, 1700, 1700,  319, 2088,  664,
 /*  2260 */  2090, 2091,  659, 1700,  654, 1700, 2105, 1700, 1700, 1700,
 /*  2270 */  1700, 1700, 1700, 1700, 2087, 1700, 1700, 1700, 2055, 1700,
 /*  2280 */   660, 1700, 1700, 1700,  661, 1700, 1700, 1700, 1700, 2087,
 /*  2290 */  1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700,  661,
 /*  2300 */  1700, 1700, 2087, 1700, 1700, 1700, 1700, 1700, 1700, 2086,
 /*  2310 */  2105, 1700,  661, 2122, 1700, 1700,  328, 2088,  664, 2090,
 /*  2320 */  2091,  659, 2055,  654,  660, 2105, 1700, 1700, 1700, 1700,
 /*  2330 */  1700, 1700, 1700, 1700, 1700, 1700, 1700, 2055, 2105,  660,
 /*  2340 */  1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 2087, 1700,
 /*  2350 */  2055, 1700,  660, 2086, 1700, 1700, 1700, 2122,  661, 1700,
 /*  2360 */   320, 2088,  664, 2090, 2091,  659, 1700,  654, 2086, 1700,
 /*  2370 */  1700, 1700, 2122, 1700, 1700,  329, 2088,  664, 2090, 2091,
 /*  2380 */   659, 2086,  654, 1700, 2105, 2122, 1700,  227,  321, 2088,
 /*  2390 */   664, 2090, 2091,  659, 1700,  654, 2055, 1700,  660, 1700,
 /*  2400 */  1700, 1700, 1700,  172, 2087, 1700, 1700, 1700, 1700,  528,
 /*  2410 */   524,  520,  516,  224,  661, 1700, 1700, 1700, 1700, 2087,
 /*  2420 */  1700, 1700, 1700, 1700, 1700, 1700, 1700, 2086, 1700,  661,
 /*  2430 */  1700, 2122, 1700, 1700,  334, 2088,  664, 2090, 2091,  659,
 /*  2440 */  2105,  654, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700,
 /*  2450 */  1700, 1700, 2055,   88,  660, 2105,  222, 1700, 1700, 1700,
 /*  2460 */  1700, 1700, 1700, 1700, 1700, 1700, 1700, 2055, 2087,  660,
 /*  2470 */  1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700,  661, 1700,
 /*  2480 */  1700, 1700, 1700, 2086, 1700, 1700, 1700, 2122, 1700, 2087,
 /*  2490 */   335, 2088,  664, 2090, 2091,  659, 1700,  654, 2086,  661,
 /*  2500 */  1700, 1700, 2122, 1700, 2105, 2099, 2088,  664, 2090, 2091,
 /*  2510 */   659, 1700,  654, 1700, 1700, 1700, 2055, 1700,  660, 1700,
 /*  2520 */  1700, 1700, 1700,  221,  215, 2105, 1700, 1700,  220, 1700,
 /*  2530 */   507, 1700, 1700, 1700, 1700, 1700, 1700, 2055, 2087,  660,
 /*  2540 */  1700, 1700, 1700, 1700, 1700, 1700,  213, 2086,  661, 1700,
 /*  2550 */  1700, 2122, 1700, 2087, 2098, 2088,  664, 2090, 2091,  659,
 /*  2560 */  1700,  654, 1700,  661, 1700, 1700, 1700, 1700, 2086, 1700,
 /*  2570 */  1700, 1700, 2122, 1700, 2105, 2097, 2088,  664, 2090, 2091,
 /*  2580 */   659, 1700,  654, 1700, 1700, 1700, 2055, 1700,  660, 2105,
 /*  2590 */  1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700,
 /*  2600 */  1700, 2055, 1700,  660, 1700, 1700, 1700, 1700, 1700, 1700,
 /*  2610 */  1700, 1700, 2087, 1700, 1700, 1700, 1700, 2086, 1700, 1700,
 /*  2620 */  1700, 2122,  661, 1700,  349, 2088,  664, 2090, 2091,  659,
 /*  2630 */  1700,  654, 2086, 1700, 1700, 1700, 2122, 1700, 1700,  350,
 /*  2640 */  2088,  664, 2090, 2091,  659, 1700,  654, 1700, 2105, 1700,
 /*  2650 */  1700, 1700, 1700, 1700, 1700, 1700, 2087, 1700, 1700, 1700,
 /*  2660 */  2055, 1700,  660, 1700, 1700, 1700,  661, 1700, 1700, 1700,
 /*  2670 */  1700, 2087, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700,
 /*  2680 */  1700,  661, 1700, 1700, 2087, 1700, 1700, 1700, 1700, 1700,
 /*  2690 */  1700, 2086, 2105, 1700,  661, 2122, 1700, 1700,  346, 2088,
 /*  2700 */   664, 2090, 2091,  659, 2055,  654,  660, 2105, 1700, 1700,
 /*  2710 */  1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 2055,
 /*  2720 */  2105,  660, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700,
 /*  2730 */  1700, 1700, 2055, 1700,  660, 2086, 1700, 1700, 1700, 2122,
 /*  2740 */  1700, 1700,  351, 2088,  664, 2090, 2091,  659, 1700,  654,
 /*  2750 */   662, 1700, 1700, 1700, 2122, 1700, 1700,  326, 2088,  664,
 /*  2760 */  2090, 2091,  659, 2086,  654, 1700, 1700, 2122, 1700, 1700,
 /*  2770 */   325, 2088,  664, 2090, 2091,  659, 1700,  654,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   331,  335,  367,  381,  338,  339,  368,  340,  341,  374,
 /*    10 */   341,  341,   12,   13,   14,  393,  369,  382,  396,  397,
 /*    20 */    20,  341,   22,    8,    9,  358,  379,   12,   13,   14,
 /*    30 */    15,   16,  365,   33,   21,   35,  367,   24,   25,   26,
 /*    40 */    27,   28,   29,   30,   31,   32,   14,  367,  379,   20,
 /*    50 */   381,   22,   20,  398,  381,  385,  331,  402,  369,   59,
 /*    60 */   413,  414,  415,    4,   35,   65,  341,   64,  379,  396,
 /*    70 */   397,  424,   72,  366,  335,  340,  341,  338,  339,  410,
 /*    80 */    65,   52,   35,  414,   20,  378,  417,  418,  419,  420,
 /*    90 */   421,  422,  367,  424,  367,   20,   22,   97,  443,  419,
 /*   100 */   100,  446,  413,  414,  379,   20,  381,  340,  341,   35,
 /*   110 */    12,   13,   22,  424,  387,  388,  461,  462,   20,   72,
 /*   120 */    22,  466,  467,  349,  109,   35,  457,  458,  336,  328,
 /*   130 */   356,   33,  340,   35,  342,  410,  136,  137,  369,  414,
 /*   140 */     0,  341,  417,  418,  419,  420,  421,  422,  379,  424,
 /*   150 */     4,  330,  427,  332,  429,  430,  431,   59,  100,  100,
 /*   160 */   435,  436,   72,   65,  100,  336,  166,  167,   20,  340,
 /*   170 */    72,  342,  172,  173,  439,  440,  441,   20,  443,  444,
 /*   180 */   165,  446,  413,  414,  415,  385,  186,   97,  188,   43,
 /*   190 */    20,   45,   46,  424,  369,   97,  461,  462,  100,  398,
 /*   200 */    20,  466,  467,  402,  379,  438,  439,  440,  441,    0,
 /*   210 */   443,  444,  212,  213,    0,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,  377,  136,  137,  380,  381,  413,  414,
 /*   240 */   415,  166,  167,  185,  443,  187,   64,  446,  100,  424,
 /*   250 */   348,  236,  237,  238,  239,  240,  241,  242,  243,  244,
 /*   260 */   245,  246,  461,  462,  166,  167,  364,  466,  467,  211,
 /*   270 */   172,  173,  367,   64,  443,  373,  186,  446,  188,  374,
 /*   280 */   100,   67,   68,   69,  186,   14,  188,  382,   74,   75,
 /*   290 */    76,   20,  461,  462,   80,  155,  212,  466,  467,   85,
 /*   300 */    86,   20,  212,  213,  164,   91,  363,  249,  249,   20,
 /*   310 */   212,  213,    0,  215,  216,  217,  218,  219,  220,  221,
 /*   320 */   222,  223,  224,  225,  226,  227,  228,  229,  230,  231,
 /*   330 */   232,  233,   12,   13,  340,  341,  340,  341,  112,  331,
 /*   340 */    20,    0,   22,  259,  260,  261,  262,  263,  264,  265,
 /*   350 */   398,  408,  358,   33,  358,   35,  130,  131,  132,  133,
 /*   360 */   134,  135,   21,  340,   20,   24,   25,   26,   27,   28,
 /*   370 */    29,   30,   31,   32,   12,   13,   14,   15,   16,   59,
 /*   380 */    59,   67,   68,   69,  130,   65,  367,  379,   74,   75,
 /*   390 */    76,  111,   72,  374,   80,  443,   14,  249,  446,   85,
 /*   400 */    86,  382,   20,    8,    9,   91,  383,   12,   13,   14,
 /*   410 */    15,   16,  331,  461,  462,  416,    3,   97,  466,  467,
 /*   420 */   100,  100,  341,  102,  112,  136,  137,  340,  341,  249,
 /*   430 */    12,   13,   14,   20,  340,  341,  171,  166,   20,    0,
 /*   440 */    22,  442,  130,  131,  132,  133,  134,  135,  367,  195,
 /*   450 */   196,   33,  358,   35,  340,  341,  136,  137,  100,  365,
 /*   460 */   379,  340,  381,   24,   25,   26,   27,   28,   29,   30,
 /*   470 */    31,   32,  358,  340,  331,    8,    9,   59,  233,   12,
 /*   480 */    13,   14,   15,   16,  341,  341,  166,  167,  359,  367,
 /*   490 */    72,  410,  172,  173,   22,  414,  367,  375,  417,  418,
 /*   500 */   419,  420,  421,  422,  375,  424,  186,   35,  188,   20,
 /*   510 */   367,  390,  431,  392,  101,   97,  435,  436,  100,  254,
 /*   520 */   255,  256,  379,  390,  381,  392,  439,  440,  441,  385,
 /*   530 */   443,  444,  212,  213,  348,  215,  216,  217,  218,  219,
 /*   540 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   550 */   230,  231,  232,  410,  136,  137,    3,  414,   59,  373,
 /*   560 */   417,  418,  419,  420,  421,  422,  416,  424,  101,   97,
 /*   570 */   249,  331,  429,  178,  431,   72,  340,  341,  435,  436,
 /*   580 */   359,  168,  340,  341,  166,  167,   44,  367,  367,  359,
 /*   590 */   172,  173,  442,   97,  374,  374,  375,  367,   99,  456,
 /*   600 */   358,  102,  382,  382,  186,  375,  188,  249,  340,  113,
 /*   610 */   114,  115,  116,  117,  118,  119,  120,  121,  122,  379,
 /*   620 */   124,  125,  126,  127,  128,  129,   14,   14,   15,   16,
 /*   630 */   212,  213,   20,  215,  216,  217,  218,  219,  220,  221,
 /*   640 */   222,  223,  224,  225,  226,  227,  228,  229,  230,  231,
 /*   650 */   232,   12,   13,   72,  331,  340,  341,  168,  390,   20,
 /*   660 */   392,   22,  359,  443,  341,  233,  446,  235,    4,  274,
 /*   670 */   367,   22,   33,  358,   35,  439,  440,  441,  375,  443,
 /*   680 */   444,  461,  462,   19,   35,   37,  466,  467,    8,    9,
 /*   690 */   367,  346,   12,   13,   14,   15,   16,   33,   59,  340,
 /*   700 */   341,  367,  379,  416,  381,  131,   39,  362,  374,  135,
 /*   710 */   331,   72,   44,   49,  367,  370,  382,  358,   54,  427,
 /*   720 */     8,    9,  430,   59,   12,   13,   14,   15,   16,  442,
 /*   730 */   340,  341,   20,  410,   81,  388,   97,  414,   20,  100,
 /*   740 */   417,  418,  419,  420,  421,  422,   97,  424,  358,   12,
 /*   750 */    13,  103,  331,  105,  106,  111,  108,   20,  379,   22,
 /*   760 */   112,  368,  341,   99,  340,  341,  102,  193,  194,  101,
 /*   770 */    33,  197,   35,  199,  443,  136,  137,  446,  166,    8,
 /*   780 */     9,  133,  358,   12,   13,   14,   15,   16,  367,  340,
 /*   790 */   341,  468,  469,  462,  141,  142,   59,  466,  467,  100,
 /*   800 */   379,   21,  381,  340,  341,  166,  167,  358,  428,   72,
 /*   810 */   430,  172,  173,  271,   34,   44,   36,  164,  340,  341,
 /*   820 */   165,  358,  269,  130,  131,  186,  181,  188,  135,  346,
 /*   830 */    20,  410,  340,  341,   97,  414,  358,  100,  417,  418,
 /*   840 */   419,  420,  421,  422,  423,  424,  425,  426,  203,  204,
 /*   850 */   358,  212,  213,  370,  215,  216,  217,  218,  219,  220,
 /*   860 */   221,  222,  223,  224,  225,  226,  227,  228,  229,  230,
 /*   870 */   231,  232,    0,  136,  137,  432,  433,    8,    9,  368,
 /*   880 */   168,   12,   13,   14,   15,   16,  168,    1,    2,  340,
 /*   890 */   341,  236,  428,   18,  430,   20,  340,  341,   20,  368,
 /*   900 */    22,  246,   27,  166,  167,   30,    2,  358,   33,  172,
 /*   910 */   173,  368,    8,    9,  358,  248,   12,   13,   14,   15,
 /*   920 */    16,    2,    4,  186,   49,  188,   51,    8,    9,   54,
 /*   930 */    52,   12,   13,   14,   15,   16,    8,    9,  380,  381,
 /*   940 */    12,   13,   14,   15,   16,  398,  136,  137,  249,  212,
 /*   950 */   213,   20,  215,  216,  217,  218,  219,  220,  221,  222,
 /*   960 */   223,  224,  225,  226,  227,  228,  229,  230,  231,  232,
 /*   970 */   101,  340,  341,  112,   99,    0,  443,  353,  354,  446,
 /*   980 */   340,  341,  172,  173,  112,  376,  111,  101,  379,  358,
 /*   990 */   443,  331,  331,  446,  133,  462,  353,  354,  358,  466,
 /*  1000 */   467,  367,  130,  131,  132,  133,  134,  135,  461,  462,
 /*  1010 */    45,   46,   44,  466,  467,  140,  382,  403,  143,  144,
 /*  1020 */   145,  146,  147,  148,  149,  150,  151,  152,  153,  154,
 /*  1030 */   155,  156,  157,  158,  159,  398,  161,  162,  163,  379,
 /*  1040 */   379,  368,   67,   68,   69,   70,   71,  331,   73,   74,
 /*  1050 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*  1060 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   18,
 /*  1070 */   376,  331,  331,  379,   23,  340,  341,  331,  331,   20,
 /*  1080 */   443,  341,  331,  446,  340,  341,  247,  248,   37,   38,
 /*  1090 */   369,  331,   41,  358,  331,  379,  168,  166,  461,  462,
 /*  1100 */   379,  341,  358,  466,  467,  331,  376,  367,  331,  379,
 /*  1110 */     0,   60,   61,   62,   63,  331,   35,  331,  331,  379,
 /*  1120 */   379,  381,    0,   48,  331,  379,  379,  367,  360,    0,
 /*  1130 */   379,  363,   22,  104,  413,  414,  107,  331,  331,  379,
 /*  1140 */   104,  381,  379,  107,   22,  424,  398,  355,  332,  357,
 /*  1150 */   410,  100,    0,  379,  414,  111,  379,  417,  418,  419,
 /*  1160 */   420,  421,  422,  379,  424,  379,  379,   44,  250,  429,
 /*  1170 */   410,  431,  379,   44,  414,  435,  436,  417,  418,  419,
 /*  1180 */   420,  421,  422,   44,  424,  379,  379,  331,  448,  138,
 /*  1190 */    42,  443,   44,   42,  446,   44,  456,  341,    0,  343,
 /*  1200 */   104,   49,  104,  107,  160,  107,  198,   44,  200,  461,
 /*  1210 */   462,   44,   59,  368,  466,  467,  136,  137,  458,   35,
 /*  1220 */    22,   65,   44,  367,  101,   44,   44,  168,  470,  178,
 /*  1230 */   179,  180,   44,   44,  183,  379,  331,  381,   44,   44,
 /*  1240 */   101,  273,  389,  168,   44,   44,  341,    0,  343,  356,
 /*  1250 */     1,    2,   47,  202,   44,  102,  205,   44,  207,  208,
 /*  1260 */   209,  210,  211,   44,  101,  344,  410,  459,  101,  188,
 /*  1270 */   414,   44,  367,  417,  418,  419,  420,  421,  422,  101,
 /*  1280 */   424,   44,  101,  101,  379,  429,  381,  431,   44,  101,
 /*  1290 */   101,  435,  436,  100,  331,  101,  101,   50,   35,   13,
 /*  1300 */   249,  101,  101,  110,  341,  100,  343,  453,  367,   13,
 /*  1310 */   344,  101,  389,  339,  101,  410,  378,  341,  389,  414,
 /*  1320 */   101,   35,  417,  418,  419,  420,  421,  422,  101,  424,
 /*  1330 */   367,   35,  445,  463,  429,   72,  431,  437,  101,  447,
 /*  1340 */   435,  436,  379,  251,  381,  101,  412,   49,  411,  184,
 /*  1350 */   400,   42,  331,  386,   20,  384,  386,  165,  389,   20,
 /*  1360 */   340,  384,  341,  340,  343,  386,  384,   98,  212,  352,
 /*  1370 */    96,  340,  188,  410,   95,  351,  350,  414,  340,  340,
 /*  1380 */   417,  418,  419,  420,  421,  422,  340,  424,  367,   20,
 /*  1390 */   333,   48,  429,  337,  431,  333,  331,  337,  435,  436,
 /*  1400 */   379,   20,  381,  405,   20,   20,  341,   20,  343,  348,
 /*  1410 */   342,  381,  348,  399,  348,  342,  340,  348,  348,  348,
 /*  1420 */   348,   53,  345,  345,  331,  367,  379,  333,  379,  340,
 /*  1430 */   367,  410,  367,  379,  341,  414,  343,  333,  417,  418,
 /*  1440 */   419,  420,  421,  422,  379,  424,  381,  201,   12,   13,
 /*  1450 */   429,  367,  431,  367,  367,  367,  435,  436,   22,  409,
 /*  1460 */   367,  100,  367,  346,  367,  346,  367,  367,  367,   33,
 /*  1470 */   340,   35,  379,  191,  381,  410,  258,  452,  257,  414,
 /*  1480 */   389,  407,  417,  418,  419,  420,  421,  422,  405,  424,
 /*  1490 */   381,  389,  379,  379,  429,   59,  431,  394,  266,  379,
 /*  1500 */   435,  436,  394,  410,  452,  379,  331,  414,   72,  404,
 /*  1510 */   417,  418,  419,  420,  421,  422,  341,  424,  177,  452,
 /*  1520 */   268,  331,  429,  267,  431,  252,  275,  412,  435,  436,
 /*  1530 */   272,  341,  270,   97,  455,  450,  454,  248,  341,   20,
 /*  1540 */   416,  451,  367,  340,  342,  346,   20,  392,  394,  379,
 /*  1550 */   346,  379,  379,  379,  379,  449,  381,  367,  379,  379,
 /*  1560 */   394,  170,  391,  346,  341,  100,  346,  331,  434,  379,
 /*  1570 */   363,  381,  100,  357,  340,  379,  465,  341,  471,  371,
 /*  1580 */   464,  346,   36,  406,  334,  410,  333,  401,  329,  414,
 /*  1590 */   361,  331,  417,  418,  419,  420,  421,  422,    0,  424,
 /*  1600 */   410,  341,  361,  367,  414,    0,  395,  417,  418,  419,
 /*  1610 */   420,  421,  422,  347,  424,  379,  361,  381,    0,  429,
 /*  1620 */   395,  431,  186,  331,  188,  435,  436,  367,   42,    0,
 /*  1630 */    35,   35,  206,  341,   35,  460,  206,   35,    0,  379,
 /*  1640 */   206,  381,   35,   35,    0,  206,  410,    0,  212,  213,
 /*  1650 */   414,   35,    0,  417,  418,  419,  420,  421,  422,  367,
 /*  1660 */   424,  225,  226,  227,  228,  229,  230,  231,   22,    0,
 /*  1670 */   410,  379,   35,  381,  414,  193,  188,  417,  418,  419,
 /*  1680 */   420,  421,  422,  186,  424,    0,    0,    0,  182,  429,
 /*  1690 */   181,  431,    0,    0,  331,  435,  436,    0,   47,    0,
 /*  1700 */     0,   42,  410,    0,  341,  469,  414,    0,    0,  417,
 /*  1710 */   418,  419,  420,  421,  422,    0,  424,    0,    0,    0,
 /*  1720 */     0,  429,  155,  431,  331,   35,    0,  435,  436,  155,
 /*  1730 */   367,    0,    0,    0,  341,    0,    0,    0,    0,    0,
 /*  1740 */     0,    0,  379,    0,  381,    0,    0,    0,    0,    0,
 /*  1750 */     0,   42,    0,    0,    0,    0,  331,    0,    0,    0,
 /*  1760 */   367,    0,  139,    0,   22,    0,  341,    0,    0,   48,
 /*  1770 */    59,   48,  379,  410,  381,   59,    0,  414,   22,   35,
 /*  1780 */   417,  418,  419,  420,  421,  422,   22,  424,   59,    0,
 /*  1790 */   331,    0,  367,   42,  431,   14,    0,    0,  435,  436,
 /*  1800 */   341,   39,    0,  410,  379,   39,  381,  414,    0,   40,
 /*  1810 */   417,  418,  419,  420,  421,  422,   44,  424,   47,   39,
 /*  1820 */    47,   47,  177,    0,  431,    0,  367,   35,  435,  436,
 /*  1830 */     0,  372,    0,    0,   49,  410,   66,   39,  379,  414,
 /*  1840 */   381,    0,  417,  418,  419,  420,  421,  422,  331,  424,
 /*  1850 */    35,   39,   49,    0,   35,   49,  431,   39,  341,    0,
 /*  1860 */    49,  436,    0,   35,    0,  331,    0,    0,   39,  410,
 /*  1870 */    35,   22,    0,  414,   35,  341,  417,  418,  419,  420,
 /*  1880 */   421,  422,  107,  424,  367,   35,  109,   35,   44,   35,
 /*  1890 */    35,   44,   35,   35,    0,   22,  379,   22,  381,   22,
 /*  1900 */    35,  367,    0,    0,   22,   35,  372,   51,    0,  331,
 /*  1910 */     0,   35,    0,  379,   35,  381,   20,   22,   35,  341,
 /*  1920 */    35,   35,  101,    0,  100,   35,  100,  410,  168,    0,
 /*  1930 */     0,  414,  331,   19,  417,  418,  419,  420,  421,  422,
 /*  1940 */    22,  424,  341,  426,  410,  367,    0,   33,  414,  170,
 /*  1950 */   372,  417,  418,  419,  420,  421,  422,  379,  424,  381,
 /*  1960 */     3,  168,  168,   49,   44,  175,  253,   48,  367,   55,
 /*  1970 */    56,   57,   58,   59,  100,  189,   48,   96,   98,  101,
 /*  1980 */   379,  331,  381,   44,  100,   44,   44,  100,  410,  101,
 /*  1990 */   101,  341,  414,  100,   47,  417,  418,  419,  420,  421,
 /*  2000 */   422,  100,  424,   47,   44,  101,  100,    3,  101,   44,
 /*  2010 */   101,  410,   35,   99,   35,  414,  102,  367,  417,  418,
 /*  2020 */   419,  420,  421,  422,   35,  424,   35,   35,   35,  379,
 /*  2030 */    47,  381,  101,  101,  247,  253,  253,  331,   44,    0,
 /*  2040 */     0,    0,   47,    0,  100,   39,   47,  341,  134,  100,
 /*  2050 */     0,  101,  101,  331,  100,  100,   47,   39,  110,  100,
 /*  2060 */   410,  169,  171,  341,  414,   44,  100,  417,  418,  419,
 /*  2070 */   420,  421,  422,  367,  424,   22,   98,  234,   98,    2,
 /*  2080 */   212,  100,  100,  169,  100,  379,  101,  381,  174,  367,
 /*  2090 */    22,  101,   47,   47,   35,   35,   35,  101,  100,  111,
 /*  2100 */   100,  379,  101,  381,  190,  100,  192,   35,  101,  331,
 /*  2110 */   100,  214,  101,  100,   35,  101,  410,  101,   35,  341,
 /*  2120 */   414,  101,  100,  417,  418,  419,  420,  421,  422,  100,
 /*  2130 */   424,  100,  410,   22,  100,  123,  414,   44,  123,  417,
 /*  2140 */   418,  419,  420,  421,  422,  367,  424,  123,  123,  112,
 /*  2150 */    35,  100,  100,   22,   35,   66,   65,  379,  331,  381,
 /*  2160 */    35,   35,   35,   35,   35,   35,   72,   35,  341,   35,
 /*  2170 */    35,  331,   94,   35,   35,   35,   22,   44,   35,   35,
 /*  2180 */    35,  341,   72,   35,   35,   35,   35,   35,  410,   22,
 /*  2190 */    35,    0,  414,    0,  367,  417,  418,  419,  420,  421,
 /*  2200 */   422,   35,  424,   39,   35,   49,  379,  367,  381,   49,
 /*  2210 */    39,    0,   35,   39,   49,    0,   35,   49,   39,  379,
 /*  2220 */     0,  381,   35,   35,    0,   22,   21,  472,   22,   21,
 /*  2230 */   331,   22,   20,  472,  472,  472,  472,  410,  472,  472,
 /*  2240 */   341,  414,  472,  472,  417,  418,  419,  420,  421,  422,
 /*  2250 */   410,  424,  472,  472,  414,  472,  472,  417,  418,  419,
 /*  2260 */   420,  421,  422,  472,  424,  472,  367,  472,  472,  472,
 /*  2270 */   472,  472,  472,  472,  331,  472,  472,  472,  379,  472,
 /*  2280 */   381,  472,  472,  472,  341,  472,  472,  472,  472,  331,
 /*  2290 */   472,  472,  472,  472,  472,  472,  472,  472,  472,  341,
 /*  2300 */   472,  472,  331,  472,  472,  472,  472,  472,  472,  410,
 /*  2310 */   367,  472,  341,  414,  472,  472,  417,  418,  419,  420,
 /*  2320 */   421,  422,  379,  424,  381,  367,  472,  472,  472,  472,
 /*  2330 */   472,  472,  472,  472,  472,  472,  472,  379,  367,  381,
 /*  2340 */   472,  472,  472,  472,  472,  472,  472,  472,  331,  472,
 /*  2350 */   379,  472,  381,  410,  472,  472,  472,  414,  341,  472,
 /*  2360 */   417,  418,  419,  420,  421,  422,  472,  424,  410,  472,
 /*  2370 */   472,  472,  414,  472,  472,  417,  418,  419,  420,  421,
 /*  2380 */   422,  410,  424,  472,  367,  414,  472,   33,  417,  418,
 /*  2390 */   419,  420,  421,  422,  472,  424,  379,  472,  381,  472,
 /*  2400 */   472,  472,  472,   49,  331,  472,  472,  472,  472,   55,
 /*  2410 */    56,   57,   58,   59,  341,  472,  472,  472,  472,  331,
 /*  2420 */   472,  472,  472,  472,  472,  472,  472,  410,  472,  341,
 /*  2430 */   472,  414,  472,  472,  417,  418,  419,  420,  421,  422,
 /*  2440 */   367,  424,  472,  472,  472,  472,  472,  472,  472,  472,
 /*  2450 */   472,  472,  379,   99,  381,  367,  102,  472,  472,  472,
 /*  2460 */   472,  472,  472,  472,  472,  472,  472,  379,  331,  381,
 /*  2470 */   472,  472,  472,  472,  472,  472,  472,  472,  341,  472,
 /*  2480 */   472,  472,  472,  410,  472,  472,  472,  414,  472,  331,
 /*  2490 */   417,  418,  419,  420,  421,  422,  472,  424,  410,  341,
 /*  2500 */   472,  472,  414,  472,  367,  417,  418,  419,  420,  421,
 /*  2510 */   422,  472,  424,  472,  472,  472,  379,  472,  381,  472,
 /*  2520 */   472,  472,  472,  169,  170,  367,  472,  472,  174,  472,
 /*  2530 */   176,  472,  472,  472,  472,  472,  472,  379,  331,  381,
 /*  2540 */   472,  472,  472,  472,  472,  472,  192,  410,  341,  472,
 /*  2550 */   472,  414,  472,  331,  417,  418,  419,  420,  421,  422,
 /*  2560 */   472,  424,  472,  341,  472,  472,  472,  472,  410,  472,
 /*  2570 */   472,  472,  414,  472,  367,  417,  418,  419,  420,  421,
 /*  2580 */   422,  472,  424,  472,  472,  472,  379,  472,  381,  367,
 /*  2590 */   472,  472,  472,  472,  472,  472,  472,  472,  472,  472,
 /*  2600 */   472,  379,  472,  381,  472,  472,  472,  472,  472,  472,
 /*  2610 */   472,  472,  331,  472,  472,  472,  472,  410,  472,  472,
 /*  2620 */   472,  414,  341,  472,  417,  418,  419,  420,  421,  422,
 /*  2630 */   472,  424,  410,  472,  472,  472,  414,  472,  472,  417,
 /*  2640 */   418,  419,  420,  421,  422,  472,  424,  472,  367,  472,
 /*  2650 */   472,  472,  472,  472,  472,  472,  331,  472,  472,  472,
 /*  2660 */   379,  472,  381,  472,  472,  472,  341,  472,  472,  472,
 /*  2670 */   472,  331,  472,  472,  472,  472,  472,  472,  472,  472,
 /*  2680 */   472,  341,  472,  472,  331,  472,  472,  472,  472,  472,
 /*  2690 */   472,  410,  367,  472,  341,  414,  472,  472,  417,  418,
 /*  2700 */   419,  420,  421,  422,  379,  424,  381,  367,  472,  472,
 /*  2710 */   472,  472,  472,  472,  472,  472,  472,  472,  472,  379,
 /*  2720 */   367,  381,  472,  472,  472,  472,  472,  472,  472,  472,
 /*  2730 */   472,  472,  379,  472,  381,  410,  472,  472,  472,  414,
 /*  2740 */   472,  472,  417,  418,  419,  420,  421,  422,  472,  424,
 /*  2750 */   410,  472,  472,  472,  414,  472,  472,  417,  418,  419,
 /*  2760 */   420,  421,  422,  410,  424,  472,  472,  414,  472,  472,
 /*  2770 */   417,  418,  419,  420,  421,  422,  472,  424,
};
#define YY_SHIFT_COUNT    (754)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2354)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1051,    0,   98,    0,  320,  320,  320,  320,  320,  320,
 /*    10 */   320,  320,  320,  320,  320,  320,  418,  639,  639,  737,
 /*    20 */   639,  639,  639,  639,  639,  639,  639,  639,  639,  639,
 /*    30 */   639,  639,  639,  639,  639,  639,  639,  639,  639,  639,
 /*    40 */   639,  639,  639,  639,  639,  639,  639,  639,  639,  148,
 /*    50 */   180,   58,   64,  321,  358,  699,  358,   64,   64, 1436,
 /*    60 */  1436, 1436,  358, 1436, 1436,   59,  358,   85,  810,  157,
 /*    70 */   157,  810,  146,  146,   75,  289,   32,   32,  157,  157,
 /*    80 */   157,  157,  157,  157,  157,  170,  157,  157,    3,   85,
 /*    90 */   157,  157,  281,  157,   85,  157,  170,  157,  170,   85,
 /*   100 */   157,  157,   85,  157,   85,   85,   85,  157,  182,  875,
 /*   110 */    15,   15,  314,   13,   90,   90,   90,   90,   90,   90,
 /*   120 */    90,   90,   90,   90,   90,   90,   90,   90,   90,   90,
 /*   130 */    90,   90,   90,  648,  413,   75,  289,   47,  489,  489,
 /*   140 */   489,  209,  432,  432,   47,  344,  344,  344,    3,  280,
 /*   150 */   245,   85,  503,   85,  503,  503,  644,  581,  496,  496,
 /*   160 */   496,  496,  496,  496,  496,  496, 1914,  214,  341,  712,
 /*   170 */   395,   84,   29,  265,  271,  612,  878,  718,  965,  382,
 /*   180 */   861, 1059,  839,  667,  553,  839, 1148,  918,  931, 1092,
 /*   190 */  1298, 1165, 1309, 1334, 1309, 1192, 1339, 1339, 1309, 1192,
 /*   200 */  1192, 1269, 1274, 1339, 1279, 1339, 1339, 1339, 1369, 1343,
 /*   210 */  1369, 1343, 1381,    3, 1384,    3, 1385, 1387,    3, 1385,
 /*   220 */     3,    3,    3, 1339,    3, 1368, 1368, 1369,   85,   85,
 /*   230 */    85,   85,   85,   85,   85,   85,   85,   85,   85, 1339,
 /*   240 */  1369,  503,  503,  503, 1246, 1361, 1381,  182, 1282, 1384,
 /*   250 */   182, 1339, 1334, 1334,  503, 1218, 1221,  503, 1218, 1221,
 /*   260 */   503,  503,   85, 1232, 1341, 1218, 1252, 1256, 1273, 1092,
 /*   270 */  1251, 1258, 1262, 1289,  344, 1519, 1339, 1385,  182,  182,
 /*   280 */  1526, 1221,  503,  503,  503,  503,  503, 1221,  503, 1391,
 /*   290 */   182,  644,  182,  344, 1465, 1472,  503,  581, 1339,  182,
 /*   300 */  1546, 1369, 2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
 /*   310 */  2778,  975, 2354,  439,  664,  467,  771,  869,  312,  904,
 /*   320 */   919,  928,  872,  680,  680,  680,  680,  680,  680,  680,
 /*   330 */   680,  680,  226,  574,  362,  362,  653,  645,  140,  499,
 /*   340 */   472,  649,  780,  254,  693,  693,  613,  886,  655,  613,
 /*   350 */   613,  613, 1152,  668,   74, 1151, 1044, 1129, 1029, 1036,
 /*   360 */  1096, 1098, 1110, 1122, 1198, 1008, 1123, 1139, 1153, 1163,
 /*   370 */  1167, 1178, 1080,  542,  968, 1075, 1181, 1182, 1188, 1189,
 /*   380 */  1194, 1195, 1249, 1200, 1081, 1184, 1156, 1201, 1205, 1210,
 /*   390 */  1213, 1219, 1227, 1237, 1244, 1193, 1286, 1296, 1263, 1247,
 /*   400 */  1598, 1605, 1618, 1586, 1629, 1595, 1426, 1596, 1599, 1602,
 /*   410 */  1430, 1638, 1607, 1608, 1434, 1644, 1439, 1647, 1616, 1652,
 /*   420 */  1646, 1669, 1637, 1482, 1488, 1497, 1685, 1686, 1687, 1506,
 /*   430 */  1509, 1692, 1693, 1651, 1697, 1699, 1700, 1659, 1703, 1707,
 /*   440 */  1708, 1715, 1717, 1718, 1719, 1720, 1567, 1690, 1726, 1574,
 /*   450 */  1731, 1732, 1733, 1735, 1736, 1737, 1738, 1739, 1740, 1741,
 /*   460 */  1743, 1745, 1746, 1747, 1748, 1749, 1709, 1750, 1752, 1753,
 /*   470 */  1754, 1755, 1757, 1742, 1758, 1759, 1761, 1623, 1763, 1765,
 /*   480 */  1756, 1721, 1764, 1723, 1767, 1711, 1744, 1768, 1716, 1776,
 /*   490 */  1729, 1789, 1791, 1751, 1762, 1772, 1771, 1773, 1781, 1774,
 /*   500 */  1796, 1769, 1766, 1797, 1802, 1808, 1780, 1645, 1823, 1825,
 /*   510 */  1830, 1770, 1832, 1833, 1792, 1785, 1798, 1841, 1815, 1803,
 /*   520 */  1812, 1853, 1819, 1806, 1818, 1859, 1828, 1811, 1829, 1862,
 /*   530 */  1864, 1866, 1867, 1777, 1775, 1835, 1849, 1872, 1839, 1850,
 /*   540 */  1852, 1854, 1855, 1844, 1847, 1857, 1858, 1873, 1865, 1894,
 /*   550 */  1875, 1902, 1877, 1856, 1903, 1882, 1870, 1908, 1876, 1910,
 /*   560 */  1879, 1912, 1895, 1896, 1883, 1885, 1886, 1821, 1824, 1923,
 /*   570 */  1760, 1826, 1890, 1929, 1786, 1918, 1793, 1779, 1930, 1946,
 /*   580 */  1794, 1790, 1957, 1920, 1713, 1874, 1878, 1884, 1919, 1880,
 /*   590 */  1928, 1881, 1888, 1939, 1941, 1889, 1887, 1893, 1901, 1904,
 /*   600 */  1942, 1947, 1956, 1906, 1960, 1782, 1907, 1909, 2004, 1965,
 /*   610 */  1783, 1977, 1979, 1989, 1991, 1992, 1993, 1931, 1932, 1983,
 /*   620 */  1787, 1994, 1995, 2039, 2040, 2041, 2043, 1944, 2006, 1771,
 /*   630 */  1999, 1949, 1950, 1951, 1954, 1955, 1891, 1959, 2050, 2018,
 /*   640 */  1892, 1966, 1948, 1771, 2009, 2021, 1978, 1843, 1980, 2077,
 /*   650 */  2053, 1868, 1981, 1985, 1982, 1990, 1984, 1996, 2045, 1998,
 /*   660 */  2000, 2046, 2001, 2068, 1897, 2005, 1988, 2007, 2059, 2060,
 /*   670 */  2010, 2011, 2061, 2013, 2014, 2072, 2022, 2016, 2079, 2029,
 /*   680 */  2020, 2083, 2031, 2012, 2015, 2024, 2025, 2111, 2037, 2034,
 /*   690 */  2093, 2051, 2115, 2052, 2093, 2093, 2131, 2089, 2091, 2119,
 /*   700 */  2125, 2126, 2127, 2128, 2129, 2130, 2132, 2134, 2135, 2094,
 /*   710 */  2078, 2133, 2138, 2139, 2140, 2154, 2143, 2144, 2145, 2110,
 /*   720 */  1844, 2148, 1847, 2149, 2150, 2151, 2152, 2167, 2155, 2191,
 /*   730 */  2166, 2156, 2164, 2193, 2169, 2160, 2171, 2211, 2177, 2165,
 /*   740 */  2174, 2215, 2181, 2168, 2179, 2220, 2187, 2188, 2224, 2203,
 /*   750 */  2205, 2206, 2209, 2208, 2212,
};
#define YY_REDUCE_COUNT (310)
#define YY_REDUCE_MIN   (-378)
#define YY_REDUCE_MAX   (2353)
static const short yy_reduce_ofst[] = {
 /*     0 */  -199,  740, -275,  143,  856,  905,  963, 1021, 1065, 1093,
 /*    10 */  1190, 1260, 1292,   81, 1363, 1393,  421, -331,  323, 1425,
 /*    20 */   760, 1175, 1236, 1459, 1517, 1534, 1578, 1601, 1650, 1706,
 /*    30 */  1722, 1778, 1827, 1840, 1899, 1943, 1958, 1971, 2017, 2073,
 /*    40 */  2088, 2137, 2158, 2207, 2222, 2281, 2325, 2340, 2353, -265,
 /*    50 */   220, -345, -233,  -48,  547,  637,  748,   87,  236, -353,
 /*    60 */  -231, -175, -169, -311,  721,  331,  533,  221, -378, -333,
 /*    70 */    94, -327, -334, -261, -273, -144, -208, -171,   -6,   -4,
 /*    80 */   114,  242,  315,  359,  390,  121,  424,  449,  -98, -365,
 /*    90 */   463,  478, -320,  492,  -95,  549,  133,  556,  268,  129,
 /*   100 */   631,  640,   19,  735,  230,  334,  303,  744,  345,   23,
 /*   110 */   443,  443, -226, -179,    8,  240,  379,  660,  661,  716,
 /*   120 */   741,  746,  747,  751,  763,  774,  777,  784,  786,  787,
 /*   130 */   793,  806,  807, -293,   -1,  347,  558,  624,   -1,  150,
 /*   140 */   287,  483,  380,  464,  643, -330, -200,  144,  186,  -57,
 /*   150 */   292,  122,  609,  634,  694,  730,  768,  792, -362,  393,
 /*   160 */   511,  531,  543,  673,  845,  543,  614,  893,  816,  853,
 /*   170 */   758,  808,  921,  854,  941,  941,  966,  923,  974,  976,
 /*   180 */   938,  929,  887,  887,  870,  887,  900,  892,  941,  934,
 /*   190 */   937,  950,  967,  969,  970,  971, 1020, 1023,  979,  977,
 /*   200 */   982, 1017, 1024, 1031, 1026, 1038, 1039, 1046, 1057, 1056,
 /*   210 */  1062, 1060,  998, 1061, 1030, 1064, 1068, 1014, 1066, 1073,
 /*   220 */  1069, 1070, 1071, 1076, 1072, 1077, 1078, 1094, 1058, 1063,
 /*   230 */  1084, 1086, 1087, 1088, 1095, 1097, 1099, 1100, 1101, 1089,
 /*   240 */  1104, 1047, 1049, 1054, 1050, 1074, 1083, 1117, 1105, 1109,
 /*   250 */  1119, 1130, 1091, 1102, 1113, 1025, 1103, 1114, 1052, 1108,
 /*   260 */  1120, 1126,  941, 1079, 1082, 1067, 1090, 1085, 1106, 1115,
 /*   270 */  1107, 1111, 1116,  887, 1197, 1124, 1203, 1202, 1199, 1204,
 /*   280 */  1155, 1154, 1170, 1172, 1173, 1174, 1179, 1166, 1180, 1171,
 /*   290 */  1217, 1207, 1220, 1223, 1134, 1208, 1196, 1216, 1234, 1235,
 /*   300 */  1250, 1253, 1186, 1177, 1211, 1225, 1229, 1241, 1255, 1266,
 /*   310 */  1259,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*    10 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*    20 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*    30 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*    40 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*    50 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*    60 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*    70 */  1698, 1698, 1698, 1698, 1968, 1698, 1698, 1698, 1698, 1698,
 /*    80 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1780, 1698,
 /*    90 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   100 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1778, 1961,
 /*   110 */  2177, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   120 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   130 */  1698, 1698, 1698, 1698, 2189, 1698, 1698, 1698, 2189, 2189,
 /*   140 */  2189, 1778, 2149, 2149, 1698, 1698, 1698, 1698, 1780, 2022,
 /*   150 */  1698, 1698, 1698, 1698, 1698, 1698, 1896, 1698, 1698, 1698,
 /*   160 */  1698, 1698, 1920, 1698, 1698, 1698, 2014, 1698, 1698, 2214,
 /*   170 */  2270, 1698, 1698, 2217, 1698, 1698, 1698, 1973, 1698, 1698,
 /*   180 */  1849, 2204, 2181, 2195, 2254, 2182, 2179, 2198, 1698, 2208,
 /*   190 */  1698, 2007, 1966, 1698, 1966, 1963, 1698, 1698, 1966, 1963,
 /*   200 */  1963, 1838, 1834, 1698, 1832, 1698, 1698, 1698, 1698, 1745,
 /*   210 */  1698, 1745, 1698, 1780, 1698, 1780, 1698, 1698, 1780, 1698,
 /*   220 */  1780, 1780, 1780, 1698, 1780, 1758, 1758, 1698, 1698, 1698,
 /*   230 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   240 */  1698, 1698, 1698, 1698, 2034, 2020, 1698, 1778, 2016, 1698,
 /*   250 */  1778, 1698, 1698, 1698, 1698, 2225, 2223, 1698, 2225, 2223,
 /*   260 */  1698, 1698, 1698, 2239, 2235, 2225, 2243, 2241, 2210, 2208,
 /*   270 */  2273, 2260, 2256, 2195, 1698, 1698, 1698, 1698, 1778, 1778,
 /*   280 */  1698, 2223, 1698, 1698, 1698, 1698, 1698, 2223, 1698, 1698,
 /*   290 */  1778, 1698, 1778, 1698, 1698, 1865, 1698, 1698, 1698, 1778,
 /*   300 */  1730, 1698, 2009, 2025, 1991, 1991, 1899, 1899, 1899, 1781,
 /*   310 */  1703, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   320 */  1698, 1698, 1698, 2238, 2237, 2104, 1698, 2153, 2152, 2151,
 /*   330 */  2142, 2103, 1861, 1698, 2102, 2101, 1698, 1698, 1698, 1698,
 /*   340 */  1698, 1698, 1698, 1698, 1982, 1981, 2095, 1698, 1698, 2096,
 /*   350 */  2094, 2093, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   360 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   370 */  1698, 1698, 1698, 2257, 2261, 1698, 1698, 1698, 1698, 1698,
 /*   380 */  1698, 1698, 2178, 1698, 1698, 1698, 1698, 1698, 2077, 1698,
 /*   390 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   400 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   410 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   420 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   430 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   440 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   450 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   460 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   470 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   480 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   490 */  1698, 1698, 1698, 1698, 1698, 1735, 2082, 1698, 1698, 1698,
 /*   500 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   510 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   520 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   530 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   540 */  1698, 1698, 1698, 1819, 1818, 1698, 1698, 1698, 1698, 1698,
 /*   550 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   560 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 2086, 1698, 1698,
 /*   570 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   580 */  1698, 1698, 2253, 2211, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   590 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   600 */  1698, 1698, 2077, 1698, 2236, 1698, 1698, 2251, 1698, 2255,
 /*   610 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 2188, 2184, 1698,
 /*   620 */  1698, 2180, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 2085,
 /*   630 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   640 */  1698, 1698, 1698, 2076, 1698, 2139, 1698, 1698, 1698, 2173,
 /*   650 */  1698, 1698, 2124, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   660 */  1698, 1698, 2086, 1698, 2089, 1698, 1698, 1698, 1698, 1698,
 /*   670 */  1893, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   680 */  1698, 1698, 1698, 1878, 1876, 1875, 1874, 1698, 1871, 1698,
 /*   690 */  1906, 1698, 1698, 1698, 1902, 1901, 1698, 1698, 1698, 1698,
 /*   700 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   710 */  1698, 1799, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   720 */  1791, 1698, 1790, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   730 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   740 */  1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698,
 /*   750 */  1698, 1698, 1698, 1698, 1698,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*       WITH => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*  TIMESTAMP => nothing */
  276,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  276,  /*      AFTER => ABORT */
  276,  /*     ATTACH => ABORT */
  276,  /*     BEFORE => ABORT */
  276,  /*      BEGIN => ABORT */
  276,  /*     BITAND => ABORT */
  276,  /*     BITNOT => ABORT */
  276,  /*      BITOR => ABORT */
  276,  /*     BLOCKS => ABORT */
  276,  /*     CHANGE => ABORT */
  276,  /*      COMMA => ABORT */
  276,  /*     CONCAT => ABORT */
  276,  /*   CONFLICT => ABORT */
  276,  /*       COPY => ABORT */
  276,  /*   DEFERRED => ABORT */
  276,  /* DELIMITERS => ABORT */
  276,  /*     DETACH => ABORT */
  276,  /*     DIVIDE => ABORT */
  276,  /*        DOT => ABORT */
  276,  /*       EACH => ABORT */
  276,  /*       FAIL => ABORT */
  276,  /*       FILE => ABORT */
  276,  /*        FOR => ABORT */
  276,  /*       GLOB => ABORT */
  276,  /*         ID => ABORT */
  276,  /*  IMMEDIATE => ABORT */
  276,  /*     IMPORT => ABORT */
  276,  /*  INITIALLY => ABORT */
  276,  /*    INSTEAD => ABORT */
  276,  /*     ISNULL => ABORT */
  276,  /*        KEY => ABORT */
  276,  /*    MODULES => ABORT */
  276,  /*  NK_BITNOT => ABORT */
  276,  /*    NK_SEMI => ABORT */
  276,  /*    NOTNULL => ABORT */
  276,  /*         OF => ABORT */
  276,  /*       PLUS => ABORT */
  276,  /*  PRIVILEGE => ABORT */
  276,  /*      RAISE => ABORT */
  276,  /*    REPLACE => ABORT */
  276,  /*   RESTRICT => ABORT */
  276,  /*        ROW => ABORT */
  276,  /*       SEMI => ABORT */
  276,  /*       STAR => ABORT */
  276,  /*  STATEMENT => ABORT */
  276,  /*     STRICT => ABORT */
  276,  /*     STRING => ABORT */
  276,  /*      TIMES => ABORT */
  276,  /*     VALUES => ABORT */
  276,  /*   VARIABLE => ABORT */
  276,  /*       VIEW => ABORT */
  276,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "WITH",
  /*   49 */ "DNODE",
  /*   50 */ "PORT",
  /*   51 */ "DNODES",
  /*   52 */ "NK_IPTOKEN",
  /*   53 */ "FORCE",
  /*   54 */ "LOCAL",
  /*   55 */ "QNODE",
  /*   56 */ "BNODE",
  /*   57 */ "SNODE",
  /*   58 */ "MNODE",
  /*   59 */ "DATABASE",
  /*   60 */ "USE",
  /*   61 */ "FLUSH",
  /*   62 */ "TRIM",
  /*   63 */ "COMPACT",
  /*   64 */ "IF",
  /*   65 */ "NOT",
  /*   66 */ "EXISTS",
  /*   67 */ "BUFFER",
  /*   68 */ "CACHEMODEL",
  /*   69 */ "CACHESIZE",
  /*   70 */ "COMP",
  /*   71 */ "DURATION",
  /*   72 */ "NK_VARIABLE",
  /*   73 */ "MAXROWS",
  /*   74 */ "MINROWS",
  /*   75 */ "KEEP",
  /*   76 */ "PAGES",
  /*   77 */ "PAGESIZE",
  /*   78 */ "TSDB_PAGESIZE",
  /*   79 */ "PRECISION",
  /*   80 */ "REPLICA",
  /*   81 */ "VGROUPS",
  /*   82 */ "SINGLE_STABLE",
  /*   83 */ "RETENTIONS",
  /*   84 */ "SCHEMALESS",
  /*   85 */ "WAL_LEVEL",
  /*   86 */ "WAL_FSYNC_PERIOD",
  /*   87 */ "WAL_RETENTION_PERIOD",
  /*   88 */ "WAL_RETENTION_SIZE",
  /*   89 */ "WAL_ROLL_PERIOD",
  /*   90 */ "WAL_SEGMENT_SIZE",
  /*   91 */ "STT_TRIGGER",
  /*   92 */ "TABLE_PREFIX",
  /*   93 */ "TABLE_SUFFIX",
  /*   94 */ "NK_COLON",
  /*   95 */ "MAX_SPEED",
  /*   96 */ "START",
  /*   97 */ "TIMESTAMP",
  /*   98 */ "END",
  /*   99 */ "TABLE",
  /*  100 */ "NK_LP",
  /*  101 */ "NK_RP",
  /*  102 */ "STABLE",
  /*  103 */ "ADD",
  /*  104 */ "COLUMN",
  /*  105 */ "MODIFY",
  /*  106 */ "RENAME",
  /*  107 */ "TAG",
  /*  108 */ "SET",
  /*  109 */ "NK_EQ",
  /*  110 */ "USING",
  /*  111 */ "TAGS",
  /*  112 */ "COMMENT",
  /*  113 */ "BOOL",
  /*  114 */ "TINYINT",
  /*  115 */ "SMALLINT",
  /*  116 */ "INT",
  /*  117 */ "INTEGER",
  /*  118 */ "BIGINT",
  /*  119 */ "FLOAT",
  /*  120 */ "DOUBLE",
  /*  121 */ "BINARY",
  /*  122 */ "NCHAR",
  /*  123 */ "UNSIGNED",
  /*  124 */ "JSON",
  /*  125 */ "VARCHAR",
  /*  126 */ "MEDIUMBLOB",
  /*  127 */ "BLOB",
  /*  128 */ "VARBINARY",
  /*  129 */ "DECIMAL",
  /*  130 */ "MAX_DELAY",
  /*  131 */ "WATERMARK",
  /*  132 */ "ROLLUP",
  /*  133 */ "TTL",
  /*  134 */ "SMA",
  /*  135 */ "DELETE_MARK",
  /*  136 */ "FIRST",
  /*  137 */ "LAST",
  /*  138 */ "SHOW",
  /*  139 */ "PRIVILEGES",
  /*  140 */ "DATABASES",
  /*  141 */ "TABLES",
  /*  142 */ "STABLES",
  /*  143 */ "MNODES",
  /*  144 */ "QNODES",
  /*  145 */ "FUNCTIONS",
  /*  146 */ "INDEXES",
  /*  147 */ "ACCOUNTS",
  /*  148 */ "APPS",
  /*  149 */ "CONNECTIONS",
  /*  150 */ "LICENCES",
  /*  151 */ "GRANTS",
  /*  152 */ "QUERIES",
  /*  153 */ "SCORES",
  /*  154 */ "TOPICS",
  /*  155 */ "VARIABLES",
  /*  156 */ "CLUSTER",
  /*  157 */ "BNODES",
  /*  158 */ "SNODES",
  /*  159 */ "TRANSACTIONS",
  /*  160 */ "DISTRIBUTED",
  /*  161 */ "CONSUMERS",
  /*  162 */ "SUBSCRIPTIONS",
  /*  163 */ "VNODES",
  /*  164 */ "ALIVE",
  /*  165 */ "LIKE",
  /*  166 */ "TBNAME",
  /*  167 */ "QTAGS",
  /*  168 */ "AS",
  /*  169 */ "INDEX",
  /*  170 */ "FUNCTION",
  /*  171 */ "INTERVAL",
  /*  172 */ "COUNT",
  /*  173 */ "LAST_ROW",
  /*  174 */ "TOPIC",
  /*  175 */ "META",
  /*  176 */ "CONSUMER",
  /*  177 */ "GROUP",
  /*  178 */ "DESC",
  /*  179 */ "DESCRIBE",
  /*  180 */ "RESET",
  /*  181 */ "QUERY",
  /*  182 */ "CACHE",
  /*  183 */ "EXPLAIN",
  /*  184 */ "ANALYZE",
  /*  185 */ "VERBOSE",
  /*  186 */ "NK_BOOL",
  /*  187 */ "RATIO",
  /*  188 */ "NK_FLOAT",
  /*  189 */ "OUTPUTTYPE",
  /*  190 */ "AGGREGATE",
  /*  191 */ "BUFSIZE",
  /*  192 */ "STREAM",
  /*  193 */ "INTO",
  /*  194 */ "TRIGGER",
  /*  195 */ "AT_ONCE",
  /*  196 */ "WINDOW_CLOSE",
  /*  197 */ "IGNORE",
  /*  198 */ "EXPIRED",
  /*  199 */ "FILL_HISTORY",
  /*  200 */ "UPDATE",
  /*  201 */ "SUBTABLE",
  /*  202 */ "KILL",
  /*  203 */ "CONNECTION",
  /*  204 */ "TRANSACTION",
  /*  205 */ "BALANCE",
  /*  206 */ "VGROUP",
  /*  207 */ "MERGE",
  /*  208 */ "REDISTRIBUTE",
  /*  209 */ "SPLIT",
  /*  210 */ "DELETE",
  /*  211 */ "INSERT",
  /*  212 */ "NULL",
  /*  213 */ "NK_QUESTION",
  /*  214 */ "NK_ARROW",
  /*  215 */ "ROWTS",
  /*  216 */ "QSTART",
  /*  217 */ "QEND",
  /*  218 */ "QDURATION",
  /*  219 */ "WSTART",
  /*  220 */ "WEND",
  /*  221 */ "WDURATION",
  /*  222 */ "IROWTS",
  /*  223 */ "ISFILLED",
  /*  224 */ "CAST",
  /*  225 */ "NOW",
  /*  226 */ "TODAY",
  /*  227 */ "TIMEZONE",
  /*  228 */ "CLIENT_VERSION",
  /*  229 */ "SERVER_VERSION",
  /*  230 */ "SERVER_STATUS",
  /*  231 */ "CURRENT_USER",
  /*  232 */ "CASE",
  /*  233 */ "WHEN",
  /*  234 */ "THEN",
  /*  235 */ "ELSE",
  /*  236 */ "BETWEEN",
  /*  237 */ "IS",
  /*  238 */ "NK_LT",
  /*  239 */ "NK_GT",
  /*  240 */ "NK_LE",
  /*  241 */ "NK_GE",
  /*  242 */ "NK_NE",
  /*  243 */ "MATCH",
  /*  244 */ "NMATCH",
  /*  245 */ "CONTAINS",
  /*  246 */ "IN",
  /*  247 */ "JOIN",
  /*  248 */ "INNER",
  /*  249 */ "SELECT",
  /*  250 */ "DISTINCT",
  /*  251 */ "WHERE",
  /*  252 */ "PARTITION",
  /*  253 */ "BY",
  /*  254 */ "SESSION",
  /*  255 */ "STATE_WINDOW",
  /*  256 */ "EVENT_WINDOW",
  /*  257 */ "SLIDING",
  /*  258 */ "FILL",
  /*  259 */ "VALUE",
  /*  260 */ "VALUE_F",
  /*  261 */ "NONE",
  /*  262 */ "PREV",
  /*  263 */ "NULL_F",
  /*  264 */ "LINEAR",
  /*  265 */ "NEXT",
  /*  266 */ "HAVING",
  /*  267 */ "RANGE",
  /*  268 */ "EVERY",
  /*  269 */ "ORDER",
  /*  270 */ "SLIMIT",
  /*  271 */ "SOFFSET",
  /*  272 */ "LIMIT",
  /*  273 */ "OFFSET",
  /*  274 */ "ASC",
  /*  275 */ "NULLS",
  /*  276 */ "ABORT",
  /*  277 */ "AFTER",
  /*  278 */ "ATTACH",
  /*  279 */ "BEFORE",
  /*  280 */ "BEGIN",
  /*  281 */ "BITAND",
  /*  282 */ "BITNOT",
  /*  283 */ "BITOR",
  /*  284 */ "BLOCKS",
  /*  285 */ "CHANGE",
  /*  286 */ "COMMA",
  /*  287 */ "CONCAT",
  /*  288 */ "CONFLICT",
  /*  289 */ "COPY",
  /*  290 */ "DEFERRED",
  /*  291 */ "DELIMITERS",
  /*  292 */ "DETACH",
  /*  293 */ "DIVIDE",
  /*  294 */ "DOT",
  /*  295 */ "EACH",
  /*  296 */ "FAIL",
  /*  297 */ "FILE",
  /*  298 */ "FOR",
  /*  299 */ "GLOB",
  /*  300 */ "ID",
  /*  301 */ "IMMEDIATE",
  /*  302 */ "IMPORT",
  /*  303 */ "INITIALLY",
  /*  304 */ "INSTEAD",
  /*  305 */ "ISNULL",
  /*  306 */ "KEY",
  /*  307 */ "MODULES",
  /*  308 */ "NK_BITNOT",
  /*  309 */ "NK_SEMI",
  /*  310 */ "NOTNULL",
  /*  311 */ "OF",
  /*  312 */ "PLUS",
  /*  313 */ "PRIVILEGE",
  /*  314 */ "RAISE",
  /*  315 */ "REPLACE",
  /*  316 */ "RESTRICT",
  /*  317 */ "ROW",
  /*  318 */ "SEMI",
  /*  319 */ "STAR",
  /*  320 */ "STATEMENT",
  /*  321 */ "STRICT",
  /*  322 */ "STRING",
  /*  323 */ "TIMES",
  /*  324 */ "VALUES",
  /*  325 */ "VARIABLE",
  /*  326 */ "VIEW",
  /*  327 */ "WAL",
  /*  328 */ "cmd",
  /*  329 */ "account_options",
  /*  330 */ "alter_account_options",
  /*  331 */ "literal",
  /*  332 */ "alter_account_option",
  /*  333 */ "user_name",
  /*  334 */ "sysinfo_opt",
  /*  335 */ "privileges",
  /*  336 */ "priv_level",
  /*  337 */ "with_opt",
  /*  338 */ "priv_type_list",
  /*  339 */ "priv_type",
  /*  340 */ "db_name",
  /*  341 */ "table_name",
  /*  342 */ "topic_name",
  /*  343 */ "search_condition",
  /*  344 */ "dnode_endpoint",
  /*  345 */ "force_opt",
  /*  346 */ "not_exists_opt",
  /*  347 */ "db_options",
  /*  348 */ "exists_opt",
  /*  349 */ "alter_db_options",
  /*  350 */ "speed_opt",
  /*  351 */ "start_opt",
  /*  352 */ "end_opt",
  /*  353 */ "integer_list",
  /*  354 */ "variable_list",
  /*  355 */ "retention_list",
  /*  356 */ "alter_db_option",
  /*  357 */ "retention",
  /*  358 */ "full_table_name",
  /*  359 */ "column_def_list",
  /*  360 */ "tags_def_opt",
  /*  361 */ "table_options",
  /*  362 */ "multi_create_clause",
  /*  363 */ "tags_def",
  /*  364 */ "multi_drop_clause",
  /*  365 */ "alter_table_clause",
  /*  366 */ "alter_table_options",
  /*  367 */ "column_name",
  /*  368 */ "type_name",
  /*  369 */ "signed_literal",
  /*  370 */ "create_subtable_clause",
  /*  371 */ "specific_cols_opt",
  /*  372 */ "expression_list",
  /*  373 */ "drop_table_clause",
  /*  374 */ "col_name_list",
  /*  375 */ "column_def",
  /*  376 */ "duration_list",
  /*  377 */ "rollup_func_list",
  /*  378 */ "alter_table_option",
  /*  379 */ "duration_literal",
  /*  380 */ "rollup_func_name",
  /*  381 */ "function_name",
  /*  382 */ "col_name",
  /*  383 */ "db_name_cond_opt",
  /*  384 */ "like_pattern_opt",
  /*  385 */ "table_name_cond",
  /*  386 */ "from_db_opt",
  /*  387 */ "tag_list_opt",
  /*  388 */ "tag_item",
  /*  389 */ "column_alias",
  /*  390 */ "full_index_name",
  /*  391 */ "index_options",
  /*  392 */ "index_name",
  /*  393 */ "func_list",
  /*  394 */ "sliding_opt",
  /*  395 */ "sma_stream_opt",
  /*  396 */ "func",
  /*  397 */ "sma_func_name",
  /*  398 */ "query_or_subquery",
  /*  399 */ "cgroup_name",
  /*  400 */ "analyze_opt",
  /*  401 */ "explain_options",
  /*  402 */ "insert_query",
  /*  403 */ "agg_func_opt",
  /*  404 */ "bufsize_opt",
  /*  405 */ "stream_name",
  /*  406 */ "stream_options",
  /*  407 */ "col_list_opt",
  /*  408 */ "tag_def_or_ref_opt",
  /*  409 */ "subtable_opt",
  /*  410 */ "expression",
  /*  411 */ "dnode_list",
  /*  412 */ "where_clause_opt",
  /*  413 */ "signed",
  /*  414 */ "literal_func",
  /*  415 */ "literal_list",
  /*  416 */ "table_alias",
  /*  417 */ "expr_or_subquery",
  /*  418 */ "pseudo_column",
  /*  419 */ "column_reference",
  /*  420 */ "function_expression",
  /*  421 */ "case_when_expression",
  /*  422 */ "star_func",
  /*  423 */ "star_func_para_list",
  /*  424 */ "noarg_func",
  /*  425 */ "other_para_list",
  /*  426 */ "star_func_para",
  /*  427 */ "when_then_list",
  /*  428 */ "case_when_else_opt",
  /*  429 */ "common_expression",
  /*  430 */ "when_then_expr",
  /*  431 */ "predicate",
  /*  432 */ "compare_op",
  /*  433 */ "in_op",
  /*  434 */ "in_predicate_value",
  /*  435 */ "boolean_value_expression",
  /*  436 */ "boolean_primary",
  /*  437 */ "from_clause_opt",
  /*  438 */ "table_reference_list",
  /*  439 */ "table_reference",
  /*  440 */ "table_primary",
  /*  441 */ "joined_table",
  /*  442 */ "alias_opt",
  /*  443 */ "subquery",
  /*  444 */ "parenthesized_joined_table",
  /*  445 */ "join_type",
  /*  446 */ "query_specification",
  /*  447 */ "set_quantifier_opt",
  /*  448 */ "select_list",
  /*  449 */ "partition_by_clause_opt",
  /*  450 */ "range_opt",
  /*  451 */ "every_opt",
  /*  452 */ "fill_opt",
  /*  453 */ "twindow_clause_opt",
  /*  454 */ "group_by_clause_opt",
  /*  455 */ "having_clause_opt",
  /*  456 */ "select_item",
  /*  457 */ "partition_list",
  /*  458 */ "partition_item",
  /*  459 */ "fill_mode",
  /*  460 */ "group_by_list",
  /*  461 */ "query_expression",
  /*  462 */ "query_simple",
  /*  463 */ "order_by_clause_opt",
  /*  464 */ "slimit_clause_opt",
  /*  465 */ "limit_clause_opt",
  /*  466 */ "union_query_expression",
  /*  467 */ "query_simple_or_subquery",
  /*  468 */ "sort_specification_list",
  /*  469 */ "sort_specification",
  /*  470 */ "ordering_specification_opt",
  /*  471 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level with_opt TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= db_name NK_DOT table_name",
 /*  43 */ "priv_level ::= topic_name",
 /*  44 */ "with_opt ::=",
 /*  45 */ "with_opt ::= WITH search_condition",
 /*  46 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  47 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  48 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  49 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  50 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  51 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  52 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  53 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  54 */ "dnode_endpoint ::= NK_STRING",
 /*  55 */ "dnode_endpoint ::= NK_ID",
 /*  56 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  57 */ "force_opt ::=",
 /*  58 */ "force_opt ::= FORCE",
 /*  59 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  60 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  61 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  67 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  68 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  69 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  70 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  71 */ "cmd ::= USE db_name",
 /*  72 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  73 */ "cmd ::= FLUSH DATABASE db_name",
 /*  74 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  75 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  76 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  77 */ "not_exists_opt ::=",
 /*  78 */ "exists_opt ::= IF EXISTS",
 /*  79 */ "exists_opt ::=",
 /*  80 */ "db_options ::=",
 /*  81 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  82 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  83 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  84 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  85 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  86 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  87 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  88 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  89 */ "db_options ::= db_options KEEP integer_list",
 /*  90 */ "db_options ::= db_options KEEP variable_list",
 /*  91 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  92 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  93 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  94 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  95 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  96 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  97 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  98 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  99 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 106 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 107 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 108 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 109 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 110 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 111 */ "alter_db_options ::= alter_db_option",
 /* 112 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 113 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 114 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 115 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 116 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 117 */ "alter_db_option ::= KEEP integer_list",
 /* 118 */ "alter_db_option ::= KEEP variable_list",
 /* 119 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 120 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 121 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 122 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 123 */ "alter_db_option ::= MINROWS NK_INTEGER",
 /* 124 */ "integer_list ::= NK_INTEGER",
 /* 125 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 126 */ "variable_list ::= NK_VARIABLE",
 /* 127 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 128 */ "retention_list ::= retention",
 /* 129 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 130 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 131 */ "speed_opt ::=",
 /* 132 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 133 */ "start_opt ::=",
 /* 134 */ "start_opt ::= START WITH NK_INTEGER",
 /* 135 */ "start_opt ::= START WITH NK_STRING",
 /* 136 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 137 */ "end_opt ::=",
 /* 138 */ "end_opt ::= END WITH NK_INTEGER",
 /* 139 */ "end_opt ::= END WITH NK_STRING",
 /* 140 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 141 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 142 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 143 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 144 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 145 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 146 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 147 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 148 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 149 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 150 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 151 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 152 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 153 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 154 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 155 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 156 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 157 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 158 */ "multi_create_clause ::= create_subtable_clause",
 /* 159 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 160 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 161 */ "multi_drop_clause ::= drop_table_clause",
 /* 162 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 163 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 164 */ "specific_cols_opt ::=",
 /* 165 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 166 */ "full_table_name ::= table_name",
 /* 167 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 168 */ "column_def_list ::= column_def",
 /* 169 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 170 */ "column_def ::= column_name type_name",
 /* 171 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 172 */ "type_name ::= BOOL",
 /* 173 */ "type_name ::= TINYINT",
 /* 174 */ "type_name ::= SMALLINT",
 /* 175 */ "type_name ::= INT",
 /* 176 */ "type_name ::= INTEGER",
 /* 177 */ "type_name ::= BIGINT",
 /* 178 */ "type_name ::= FLOAT",
 /* 179 */ "type_name ::= DOUBLE",
 /* 180 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= TIMESTAMP",
 /* 182 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 183 */ "type_name ::= TINYINT UNSIGNED",
 /* 184 */ "type_name ::= SMALLINT UNSIGNED",
 /* 185 */ "type_name ::= INT UNSIGNED",
 /* 186 */ "type_name ::= BIGINT UNSIGNED",
 /* 187 */ "type_name ::= JSON",
 /* 188 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 189 */ "type_name ::= MEDIUMBLOB",
 /* 190 */ "type_name ::= BLOB",
 /* 191 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 192 */ "type_name ::= DECIMAL",
 /* 193 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 194 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 195 */ "tags_def_opt ::=",
 /* 196 */ "tags_def_opt ::= tags_def",
 /* 197 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 198 */ "table_options ::=",
 /* 199 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 200 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 201 */ "table_options ::= table_options WATERMARK duration_list",
 /* 202 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 203 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 204 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 205 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 206 */ "alter_table_options ::= alter_table_option",
 /* 207 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 208 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 209 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 210 */ "duration_list ::= duration_literal",
 /* 211 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 212 */ "rollup_func_list ::= rollup_func_name",
 /* 213 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 214 */ "rollup_func_name ::= function_name",
 /* 215 */ "rollup_func_name ::= FIRST",
 /* 216 */ "rollup_func_name ::= LAST",
 /* 217 */ "col_name_list ::= col_name",
 /* 218 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 219 */ "col_name ::= column_name",
 /* 220 */ "cmd ::= SHOW DNODES",
 /* 221 */ "cmd ::= SHOW USERS",
 /* 222 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 223 */ "cmd ::= SHOW DATABASES",
 /* 224 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 225 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 226 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 227 */ "cmd ::= SHOW MNODES",
 /* 228 */ "cmd ::= SHOW QNODES",
 /* 229 */ "cmd ::= SHOW FUNCTIONS",
 /* 230 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 231 */ "cmd ::= SHOW STREAMS",
 /* 232 */ "cmd ::= SHOW ACCOUNTS",
 /* 233 */ "cmd ::= SHOW APPS",
 /* 234 */ "cmd ::= SHOW CONNECTIONS",
 /* 235 */ "cmd ::= SHOW LICENCES",
 /* 236 */ "cmd ::= SHOW GRANTS",
 /* 237 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 238 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 239 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 240 */ "cmd ::= SHOW QUERIES",
 /* 241 */ "cmd ::= SHOW SCORES",
 /* 242 */ "cmd ::= SHOW TOPICS",
 /* 243 */ "cmd ::= SHOW VARIABLES",
 /* 244 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 245 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 246 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 247 */ "cmd ::= SHOW BNODES",
 /* 248 */ "cmd ::= SHOW SNODES",
 /* 249 */ "cmd ::= SHOW CLUSTER",
 /* 250 */ "cmd ::= SHOW TRANSACTIONS",
 /* 251 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 252 */ "cmd ::= SHOW CONSUMERS",
 /* 253 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 254 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 255 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 256 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 257 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 258 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 259 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 260 */ "db_name_cond_opt ::=",
 /* 261 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 262 */ "like_pattern_opt ::=",
 /* 263 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 264 */ "table_name_cond ::= table_name",
 /* 265 */ "from_db_opt ::=",
 /* 266 */ "from_db_opt ::= FROM db_name",
 /* 267 */ "tag_list_opt ::=",
 /* 268 */ "tag_list_opt ::= tag_item",
 /* 269 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 270 */ "tag_item ::= TBNAME",
 /* 271 */ "tag_item ::= QTAGS",
 /* 272 */ "tag_item ::= column_name",
 /* 273 */ "tag_item ::= column_name column_alias",
 /* 274 */ "tag_item ::= column_name AS column_alias",
 /* 275 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 276 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 277 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 278 */ "full_index_name ::= index_name",
 /* 279 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 280 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 281 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 282 */ "func_list ::= func",
 /* 283 */ "func_list ::= func_list NK_COMMA func",
 /* 284 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 285 */ "sma_func_name ::= function_name",
 /* 286 */ "sma_func_name ::= COUNT",
 /* 287 */ "sma_func_name ::= FIRST",
 /* 288 */ "sma_func_name ::= LAST",
 /* 289 */ "sma_func_name ::= LAST_ROW",
 /* 290 */ "sma_stream_opt ::=",
 /* 291 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 292 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 293 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 294 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 295 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 296 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 297 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 298 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 299 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 300 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 301 */ "cmd ::= DESC full_table_name",
 /* 302 */ "cmd ::= DESCRIBE full_table_name",
 /* 303 */ "cmd ::= RESET QUERY CACHE",
 /* 304 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 305 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 306 */ "analyze_opt ::=",
 /* 307 */ "analyze_opt ::= ANALYZE",
 /* 308 */ "explain_options ::=",
 /* 309 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 310 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 311 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 312 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 313 */ "agg_func_opt ::=",
 /* 314 */ "agg_func_opt ::= AGGREGATE",
 /* 315 */ "bufsize_opt ::=",
 /* 316 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 317 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 318 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 319 */ "col_list_opt ::=",
 /* 320 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 321 */ "tag_def_or_ref_opt ::=",
 /* 322 */ "tag_def_or_ref_opt ::= tags_def",
 /* 323 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 324 */ "stream_options ::=",
 /* 325 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 326 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 327 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 328 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 329 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 330 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 331 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 332 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 333 */ "subtable_opt ::=",
 /* 334 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 335 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 336 */ "cmd ::= KILL QUERY NK_STRING",
 /* 337 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 338 */ "cmd ::= BALANCE VGROUP",
 /* 339 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 340 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 341 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 342 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 343 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 344 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 345 */ "cmd ::= query_or_subquery",
 /* 346 */ "cmd ::= insert_query",
 /* 347 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 348 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 349 */ "literal ::= NK_INTEGER",
 /* 350 */ "literal ::= NK_FLOAT",
 /* 351 */ "literal ::= NK_STRING",
 /* 352 */ "literal ::= NK_BOOL",
 /* 353 */ "literal ::= TIMESTAMP NK_STRING",
 /* 354 */ "literal ::= duration_literal",
 /* 355 */ "literal ::= NULL",
 /* 356 */ "literal ::= NK_QUESTION",
 /* 357 */ "duration_literal ::= NK_VARIABLE",
 /* 358 */ "signed ::= NK_INTEGER",
 /* 359 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 360 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 361 */ "signed ::= NK_FLOAT",
 /* 362 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 363 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 364 */ "signed_literal ::= signed",
 /* 365 */ "signed_literal ::= NK_STRING",
 /* 366 */ "signed_literal ::= NK_BOOL",
 /* 367 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 368 */ "signed_literal ::= duration_literal",
 /* 369 */ "signed_literal ::= NULL",
 /* 370 */ "signed_literal ::= literal_func",
 /* 371 */ "signed_literal ::= NK_QUESTION",
 /* 372 */ "literal_list ::= signed_literal",
 /* 373 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 374 */ "db_name ::= NK_ID",
 /* 375 */ "table_name ::= NK_ID",
 /* 376 */ "column_name ::= NK_ID",
 /* 377 */ "function_name ::= NK_ID",
 /* 378 */ "table_alias ::= NK_ID",
 /* 379 */ "column_alias ::= NK_ID",
 /* 380 */ "user_name ::= NK_ID",
 /* 381 */ "topic_name ::= NK_ID",
 /* 382 */ "stream_name ::= NK_ID",
 /* 383 */ "cgroup_name ::= NK_ID",
 /* 384 */ "index_name ::= NK_ID",
 /* 385 */ "expr_or_subquery ::= expression",
 /* 386 */ "expression ::= literal",
 /* 387 */ "expression ::= pseudo_column",
 /* 388 */ "expression ::= column_reference",
 /* 389 */ "expression ::= function_expression",
 /* 390 */ "expression ::= case_when_expression",
 /* 391 */ "expression ::= NK_LP expression NK_RP",
 /* 392 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 393 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 394 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 395 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 396 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 397 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 398 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 399 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 400 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 401 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 402 */ "expression_list ::= expr_or_subquery",
 /* 403 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 404 */ "column_reference ::= column_name",
 /* 405 */ "column_reference ::= table_name NK_DOT column_name",
 /* 406 */ "pseudo_column ::= ROWTS",
 /* 407 */ "pseudo_column ::= TBNAME",
 /* 408 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 409 */ "pseudo_column ::= QSTART",
 /* 410 */ "pseudo_column ::= QEND",
 /* 411 */ "pseudo_column ::= QDURATION",
 /* 412 */ "pseudo_column ::= WSTART",
 /* 413 */ "pseudo_column ::= WEND",
 /* 414 */ "pseudo_column ::= WDURATION",
 /* 415 */ "pseudo_column ::= IROWTS",
 /* 416 */ "pseudo_column ::= ISFILLED",
 /* 417 */ "pseudo_column ::= QTAGS",
 /* 418 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 419 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 420 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 421 */ "function_expression ::= literal_func",
 /* 422 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 423 */ "literal_func ::= NOW",
 /* 424 */ "noarg_func ::= NOW",
 /* 425 */ "noarg_func ::= TODAY",
 /* 426 */ "noarg_func ::= TIMEZONE",
 /* 427 */ "noarg_func ::= DATABASE",
 /* 428 */ "noarg_func ::= CLIENT_VERSION",
 /* 429 */ "noarg_func ::= SERVER_VERSION",
 /* 430 */ "noarg_func ::= SERVER_STATUS",
 /* 431 */ "noarg_func ::= CURRENT_USER",
 /* 432 */ "noarg_func ::= USER",
 /* 433 */ "star_func ::= COUNT",
 /* 434 */ "star_func ::= FIRST",
 /* 435 */ "star_func ::= LAST",
 /* 436 */ "star_func ::= LAST_ROW",
 /* 437 */ "star_func_para_list ::= NK_STAR",
 /* 438 */ "star_func_para_list ::= other_para_list",
 /* 439 */ "other_para_list ::= star_func_para",
 /* 440 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 441 */ "star_func_para ::= expr_or_subquery",
 /* 442 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 443 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 444 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 445 */ "when_then_list ::= when_then_expr",
 /* 446 */ "when_then_list ::= when_then_list when_then_expr",
 /* 447 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 448 */ "case_when_else_opt ::=",
 /* 449 */ "case_when_else_opt ::= ELSE common_expression",
 /* 450 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 451 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 452 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 453 */ "predicate ::= expr_or_subquery IS NULL",
 /* 454 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 455 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 456 */ "compare_op ::= NK_LT",
 /* 457 */ "compare_op ::= NK_GT",
 /* 458 */ "compare_op ::= NK_LE",
 /* 459 */ "compare_op ::= NK_GE",
 /* 460 */ "compare_op ::= NK_NE",
 /* 461 */ "compare_op ::= NK_EQ",
 /* 462 */ "compare_op ::= LIKE",
 /* 463 */ "compare_op ::= NOT LIKE",
 /* 464 */ "compare_op ::= MATCH",
 /* 465 */ "compare_op ::= NMATCH",
 /* 466 */ "compare_op ::= CONTAINS",
 /* 467 */ "in_op ::= IN",
 /* 468 */ "in_op ::= NOT IN",
 /* 469 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 470 */ "boolean_value_expression ::= boolean_primary",
 /* 471 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 472 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 473 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 474 */ "boolean_primary ::= predicate",
 /* 475 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 476 */ "common_expression ::= expr_or_subquery",
 /* 477 */ "common_expression ::= boolean_value_expression",
 /* 478 */ "from_clause_opt ::=",
 /* 479 */ "from_clause_opt ::= FROM table_reference_list",
 /* 480 */ "table_reference_list ::= table_reference",
 /* 481 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 482 */ "table_reference ::= table_primary",
 /* 483 */ "table_reference ::= joined_table",
 /* 484 */ "table_primary ::= table_name alias_opt",
 /* 485 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 486 */ "table_primary ::= subquery alias_opt",
 /* 487 */ "table_primary ::= parenthesized_joined_table",
 /* 488 */ "alias_opt ::=",
 /* 489 */ "alias_opt ::= table_alias",
 /* 490 */ "alias_opt ::= AS table_alias",
 /* 491 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 492 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 493 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 494 */ "join_type ::=",
 /* 495 */ "join_type ::= INNER",
 /* 496 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 497 */ "set_quantifier_opt ::=",
 /* 498 */ "set_quantifier_opt ::= DISTINCT",
 /* 499 */ "set_quantifier_opt ::= ALL",
 /* 500 */ "select_list ::= select_item",
 /* 501 */ "select_list ::= select_list NK_COMMA select_item",
 /* 502 */ "select_item ::= NK_STAR",
 /* 503 */ "select_item ::= common_expression",
 /* 504 */ "select_item ::= common_expression column_alias",
 /* 505 */ "select_item ::= common_expression AS column_alias",
 /* 506 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 507 */ "where_clause_opt ::=",
 /* 508 */ "where_clause_opt ::= WHERE search_condition",
 /* 509 */ "partition_by_clause_opt ::=",
 /* 510 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 511 */ "partition_list ::= partition_item",
 /* 512 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 513 */ "partition_item ::= expr_or_subquery",
 /* 514 */ "partition_item ::= expr_or_subquery column_alias",
 /* 515 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 516 */ "twindow_clause_opt ::=",
 /* 517 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 518 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 519 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 520 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 521 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 522 */ "sliding_opt ::=",
 /* 523 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 524 */ "fill_opt ::=",
 /* 525 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 526 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 527 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP",
 /* 528 */ "fill_mode ::= NONE",
 /* 529 */ "fill_mode ::= PREV",
 /* 530 */ "fill_mode ::= NULL",
 /* 531 */ "fill_mode ::= NULL_F",
 /* 532 */ "fill_mode ::= LINEAR",
 /* 533 */ "fill_mode ::= NEXT",
 /* 534 */ "group_by_clause_opt ::=",
 /* 535 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 536 */ "group_by_list ::= expr_or_subquery",
 /* 537 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 538 */ "having_clause_opt ::=",
 /* 539 */ "having_clause_opt ::= HAVING search_condition",
 /* 540 */ "range_opt ::=",
 /* 541 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 542 */ "every_opt ::=",
 /* 543 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 544 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 545 */ "query_simple ::= query_specification",
 /* 546 */ "query_simple ::= union_query_expression",
 /* 547 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 548 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 549 */ "query_simple_or_subquery ::= query_simple",
 /* 550 */ "query_simple_or_subquery ::= subquery",
 /* 551 */ "query_or_subquery ::= query_expression",
 /* 552 */ "query_or_subquery ::= subquery",
 /* 553 */ "order_by_clause_opt ::=",
 /* 554 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 555 */ "slimit_clause_opt ::=",
 /* 556 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 557 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 558 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 559 */ "limit_clause_opt ::=",
 /* 560 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 561 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 562 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 563 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 564 */ "subquery ::= NK_LP subquery NK_RP",
 /* 565 */ "search_condition ::= common_expression",
 /* 566 */ "sort_specification_list ::= sort_specification",
 /* 567 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 568 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 569 */ "ordering_specification_opt ::=",
 /* 570 */ "ordering_specification_opt ::= ASC",
 /* 571 */ "ordering_specification_opt ::= DESC",
 /* 572 */ "null_ordering_opt ::=",
 /* 573 */ "null_ordering_opt ::= NULLS FIRST",
 /* 574 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 328: /* cmd */
    case 331: /* literal */
    case 337: /* with_opt */
    case 343: /* search_condition */
    case 347: /* db_options */
    case 349: /* alter_db_options */
    case 351: /* start_opt */
    case 352: /* end_opt */
    case 357: /* retention */
    case 358: /* full_table_name */
    case 361: /* table_options */
    case 365: /* alter_table_clause */
    case 366: /* alter_table_options */
    case 369: /* signed_literal */
    case 370: /* create_subtable_clause */
    case 373: /* drop_table_clause */
    case 375: /* column_def */
    case 379: /* duration_literal */
    case 380: /* rollup_func_name */
    case 382: /* col_name */
    case 383: /* db_name_cond_opt */
    case 384: /* like_pattern_opt */
    case 385: /* table_name_cond */
    case 386: /* from_db_opt */
    case 388: /* tag_item */
    case 390: /* full_index_name */
    case 391: /* index_options */
    case 394: /* sliding_opt */
    case 395: /* sma_stream_opt */
    case 396: /* func */
    case 398: /* query_or_subquery */
    case 401: /* explain_options */
    case 402: /* insert_query */
    case 406: /* stream_options */
    case 409: /* subtable_opt */
    case 410: /* expression */
    case 412: /* where_clause_opt */
    case 413: /* signed */
    case 414: /* literal_func */
    case 417: /* expr_or_subquery */
    case 418: /* pseudo_column */
    case 419: /* column_reference */
    case 420: /* function_expression */
    case 421: /* case_when_expression */
    case 426: /* star_func_para */
    case 428: /* case_when_else_opt */
    case 429: /* common_expression */
    case 430: /* when_then_expr */
    case 431: /* predicate */
    case 434: /* in_predicate_value */
    case 435: /* boolean_value_expression */
    case 436: /* boolean_primary */
    case 437: /* from_clause_opt */
    case 438: /* table_reference_list */
    case 439: /* table_reference */
    case 440: /* table_primary */
    case 441: /* joined_table */
    case 443: /* subquery */
    case 444: /* parenthesized_joined_table */
    case 446: /* query_specification */
    case 450: /* range_opt */
    case 451: /* every_opt */
    case 452: /* fill_opt */
    case 453: /* twindow_clause_opt */
    case 455: /* having_clause_opt */
    case 456: /* select_item */
    case 458: /* partition_item */
    case 461: /* query_expression */
    case 462: /* query_simple */
    case 464: /* slimit_clause_opt */
    case 465: /* limit_clause_opt */
    case 466: /* union_query_expression */
    case 467: /* query_simple_or_subquery */
    case 469: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy792)); 
}
      break;
    case 329: /* account_options */
    case 330: /* alter_account_options */
    case 332: /* alter_account_option */
    case 350: /* speed_opt */
    case 404: /* bufsize_opt */
{
 
}
      break;
    case 333: /* user_name */
    case 340: /* db_name */
    case 341: /* table_name */
    case 342: /* topic_name */
    case 344: /* dnode_endpoint */
    case 367: /* column_name */
    case 381: /* function_name */
    case 389: /* column_alias */
    case 392: /* index_name */
    case 397: /* sma_func_name */
    case 399: /* cgroup_name */
    case 405: /* stream_name */
    case 416: /* table_alias */
    case 422: /* star_func */
    case 424: /* noarg_func */
    case 442: /* alias_opt */
{
 
}
      break;
    case 334: /* sysinfo_opt */
{
 
}
      break;
    case 335: /* privileges */
    case 338: /* priv_type_list */
    case 339: /* priv_type */
{
 
}
      break;
    case 336: /* priv_level */
{
 
}
      break;
    case 345: /* force_opt */
    case 346: /* not_exists_opt */
    case 348: /* exists_opt */
    case 400: /* analyze_opt */
    case 403: /* agg_func_opt */
    case 447: /* set_quantifier_opt */
{
 
}
      break;
    case 353: /* integer_list */
    case 354: /* variable_list */
    case 355: /* retention_list */
    case 359: /* column_def_list */
    case 360: /* tags_def_opt */
    case 362: /* multi_create_clause */
    case 363: /* tags_def */
    case 364: /* multi_drop_clause */
    case 371: /* specific_cols_opt */
    case 372: /* expression_list */
    case 374: /* col_name_list */
    case 376: /* duration_list */
    case 377: /* rollup_func_list */
    case 387: /* tag_list_opt */
    case 393: /* func_list */
    case 407: /* col_list_opt */
    case 408: /* tag_def_or_ref_opt */
    case 411: /* dnode_list */
    case 415: /* literal_list */
    case 423: /* star_func_para_list */
    case 425: /* other_para_list */
    case 427: /* when_then_list */
    case 448: /* select_list */
    case 449: /* partition_by_clause_opt */
    case 454: /* group_by_clause_opt */
    case 457: /* partition_list */
    case 460: /* group_by_list */
    case 463: /* order_by_clause_opt */
    case 468: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy520)); 
}
      break;
    case 356: /* alter_db_option */
    case 378: /* alter_table_option */
{
 
}
      break;
    case 368: /* type_name */
{
 
}
      break;
    case 432: /* compare_op */
    case 433: /* in_op */
{
 
}
      break;
    case 445: /* join_type */
{
 
}
      break;
    case 459: /* fill_mode */
{
 
}
      break;
    case 470: /* ordering_specification_opt */
{
 
}
      break;
    case 471: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  328,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  328,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  329,    0 }, /* (2) account_options ::= */
  {  329,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  329,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  329,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  329,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  329,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  329,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  329,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  329,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  329,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  330,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  330,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  332,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  332,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  332,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  332,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  332,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  332,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  332,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  332,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  332,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  332,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  328,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  328,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  328,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  328,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  328,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  334,    0 }, /* (29) sysinfo_opt ::= */
  {  334,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  328,   -7 }, /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
  {  328,   -7 }, /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
  {  335,   -1 }, /* (33) privileges ::= ALL */
  {  335,   -1 }, /* (34) privileges ::= priv_type_list */
  {  335,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  338,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  338,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  339,   -1 }, /* (38) priv_type ::= READ */
  {  339,   -1 }, /* (39) priv_type ::= WRITE */
  {  336,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  336,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  336,   -3 }, /* (42) priv_level ::= db_name NK_DOT table_name */
  {  336,   -1 }, /* (43) priv_level ::= topic_name */
  {  337,    0 }, /* (44) with_opt ::= */
  {  337,   -2 }, /* (45) with_opt ::= WITH search_condition */
  {  328,   -3 }, /* (46) cmd ::= CREATE DNODE dnode_endpoint */
  {  328,   -5 }, /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  328,   -4 }, /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  328,   -4 }, /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  328,   -4 }, /* (50) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  328,   -5 }, /* (51) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  328,   -4 }, /* (52) cmd ::= ALTER ALL DNODES NK_STRING */
  {  328,   -5 }, /* (53) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  344,   -1 }, /* (54) dnode_endpoint ::= NK_STRING */
  {  344,   -1 }, /* (55) dnode_endpoint ::= NK_ID */
  {  344,   -1 }, /* (56) dnode_endpoint ::= NK_IPTOKEN */
  {  345,    0 }, /* (57) force_opt ::= */
  {  345,   -1 }, /* (58) force_opt ::= FORCE */
  {  328,   -3 }, /* (59) cmd ::= ALTER LOCAL NK_STRING */
  {  328,   -4 }, /* (60) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  328,   -5 }, /* (61) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (62) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (63) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (64) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (65) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (66) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (67) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (68) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (69) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  328,   -4 }, /* (70) cmd ::= DROP DATABASE exists_opt db_name */
  {  328,   -2 }, /* (71) cmd ::= USE db_name */
  {  328,   -4 }, /* (72) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  328,   -3 }, /* (73) cmd ::= FLUSH DATABASE db_name */
  {  328,   -4 }, /* (74) cmd ::= TRIM DATABASE db_name speed_opt */
  {  328,   -5 }, /* (75) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
  {  346,   -3 }, /* (76) not_exists_opt ::= IF NOT EXISTS */
  {  346,    0 }, /* (77) not_exists_opt ::= */
  {  348,   -2 }, /* (78) exists_opt ::= IF EXISTS */
  {  348,    0 }, /* (79) exists_opt ::= */
  {  347,    0 }, /* (80) db_options ::= */
  {  347,   -3 }, /* (81) db_options ::= db_options BUFFER NK_INTEGER */
  {  347,   -3 }, /* (82) db_options ::= db_options CACHEMODEL NK_STRING */
  {  347,   -3 }, /* (83) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  347,   -3 }, /* (84) db_options ::= db_options COMP NK_INTEGER */
  {  347,   -3 }, /* (85) db_options ::= db_options DURATION NK_INTEGER */
  {  347,   -3 }, /* (86) db_options ::= db_options DURATION NK_VARIABLE */
  {  347,   -3 }, /* (87) db_options ::= db_options MAXROWS NK_INTEGER */
  {  347,   -3 }, /* (88) db_options ::= db_options MINROWS NK_INTEGER */
  {  347,   -3 }, /* (89) db_options ::= db_options KEEP integer_list */
  {  347,   -3 }, /* (90) db_options ::= db_options KEEP variable_list */
  {  347,   -3 }, /* (91) db_options ::= db_options PAGES NK_INTEGER */
  {  347,   -3 }, /* (92) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  347,   -3 }, /* (93) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  347,   -3 }, /* (94) db_options ::= db_options PRECISION NK_STRING */
  {  347,   -3 }, /* (95) db_options ::= db_options REPLICA NK_INTEGER */
  {  347,   -3 }, /* (96) db_options ::= db_options VGROUPS NK_INTEGER */
  {  347,   -3 }, /* (97) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  347,   -3 }, /* (98) db_options ::= db_options RETENTIONS retention_list */
  {  347,   -3 }, /* (99) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  347,   -3 }, /* (100) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  347,   -3 }, /* (101) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  347,   -3 }, /* (102) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  347,   -4 }, /* (103) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  347,   -3 }, /* (104) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  347,   -4 }, /* (105) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  347,   -3 }, /* (106) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  347,   -3 }, /* (107) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  347,   -3 }, /* (108) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  347,   -3 }, /* (109) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  347,   -3 }, /* (110) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  349,   -1 }, /* (111) alter_db_options ::= alter_db_option */
  {  349,   -2 }, /* (112) alter_db_options ::= alter_db_options alter_db_option */
  {  356,   -2 }, /* (113) alter_db_option ::= BUFFER NK_INTEGER */
  {  356,   -2 }, /* (114) alter_db_option ::= CACHEMODEL NK_STRING */
  {  356,   -2 }, /* (115) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  356,   -2 }, /* (116) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  356,   -2 }, /* (117) alter_db_option ::= KEEP integer_list */
  {  356,   -2 }, /* (118) alter_db_option ::= KEEP variable_list */
  {  356,   -2 }, /* (119) alter_db_option ::= PAGES NK_INTEGER */
  {  356,   -2 }, /* (120) alter_db_option ::= REPLICA NK_INTEGER */
  {  356,   -2 }, /* (121) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  356,   -2 }, /* (122) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  356,   -2 }, /* (123) alter_db_option ::= MINROWS NK_INTEGER */
  {  353,   -1 }, /* (124) integer_list ::= NK_INTEGER */
  {  353,   -3 }, /* (125) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  354,   -1 }, /* (126) variable_list ::= NK_VARIABLE */
  {  354,   -3 }, /* (127) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  355,   -1 }, /* (128) retention_list ::= retention */
  {  355,   -3 }, /* (129) retention_list ::= retention_list NK_COMMA retention */
  {  357,   -3 }, /* (130) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  350,    0 }, /* (131) speed_opt ::= */
  {  350,   -2 }, /* (132) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  351,    0 }, /* (133) start_opt ::= */
  {  351,   -3 }, /* (134) start_opt ::= START WITH NK_INTEGER */
  {  351,   -3 }, /* (135) start_opt ::= START WITH NK_STRING */
  {  351,   -4 }, /* (136) start_opt ::= START WITH TIMESTAMP NK_STRING */
  {  352,    0 }, /* (137) end_opt ::= */
  {  352,   -3 }, /* (138) end_opt ::= END WITH NK_INTEGER */
  {  352,   -3 }, /* (139) end_opt ::= END WITH NK_STRING */
  {  352,   -4 }, /* (140) end_opt ::= END WITH TIMESTAMP NK_STRING */
  {  328,   -9 }, /* (141) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  328,   -3 }, /* (142) cmd ::= CREATE TABLE multi_create_clause */
  {  328,   -9 }, /* (143) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  328,   -3 }, /* (144) cmd ::= DROP TABLE multi_drop_clause */
  {  328,   -4 }, /* (145) cmd ::= DROP STABLE exists_opt full_table_name */
  {  328,   -3 }, /* (146) cmd ::= ALTER TABLE alter_table_clause */
  {  328,   -3 }, /* (147) cmd ::= ALTER STABLE alter_table_clause */
  {  365,   -2 }, /* (148) alter_table_clause ::= full_table_name alter_table_options */
  {  365,   -5 }, /* (149) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  365,   -4 }, /* (150) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  365,   -5 }, /* (151) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  365,   -5 }, /* (152) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  365,   -5 }, /* (153) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  365,   -4 }, /* (154) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  365,   -5 }, /* (155) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  365,   -5 }, /* (156) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  365,   -6 }, /* (157) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  362,   -1 }, /* (158) multi_create_clause ::= create_subtable_clause */
  {  362,   -2 }, /* (159) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  370,  -10 }, /* (160) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  364,   -1 }, /* (161) multi_drop_clause ::= drop_table_clause */
  {  364,   -3 }, /* (162) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
  {  373,   -2 }, /* (163) drop_table_clause ::= exists_opt full_table_name */
  {  371,    0 }, /* (164) specific_cols_opt ::= */
  {  371,   -3 }, /* (165) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  358,   -1 }, /* (166) full_table_name ::= table_name */
  {  358,   -3 }, /* (167) full_table_name ::= db_name NK_DOT table_name */
  {  359,   -1 }, /* (168) column_def_list ::= column_def */
  {  359,   -3 }, /* (169) column_def_list ::= column_def_list NK_COMMA column_def */
  {  375,   -2 }, /* (170) column_def ::= column_name type_name */
  {  375,   -4 }, /* (171) column_def ::= column_name type_name COMMENT NK_STRING */
  {  368,   -1 }, /* (172) type_name ::= BOOL */
  {  368,   -1 }, /* (173) type_name ::= TINYINT */
  {  368,   -1 }, /* (174) type_name ::= SMALLINT */
  {  368,   -1 }, /* (175) type_name ::= INT */
  {  368,   -1 }, /* (176) type_name ::= INTEGER */
  {  368,   -1 }, /* (177) type_name ::= BIGINT */
  {  368,   -1 }, /* (178) type_name ::= FLOAT */
  {  368,   -1 }, /* (179) type_name ::= DOUBLE */
  {  368,   -4 }, /* (180) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  368,   -1 }, /* (181) type_name ::= TIMESTAMP */
  {  368,   -4 }, /* (182) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  368,   -2 }, /* (183) type_name ::= TINYINT UNSIGNED */
  {  368,   -2 }, /* (184) type_name ::= SMALLINT UNSIGNED */
  {  368,   -2 }, /* (185) type_name ::= INT UNSIGNED */
  {  368,   -2 }, /* (186) type_name ::= BIGINT UNSIGNED */
  {  368,   -1 }, /* (187) type_name ::= JSON */
  {  368,   -4 }, /* (188) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  368,   -1 }, /* (189) type_name ::= MEDIUMBLOB */
  {  368,   -1 }, /* (190) type_name ::= BLOB */
  {  368,   -4 }, /* (191) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  368,   -1 }, /* (192) type_name ::= DECIMAL */
  {  368,   -4 }, /* (193) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  368,   -6 }, /* (194) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  360,    0 }, /* (195) tags_def_opt ::= */
  {  360,   -1 }, /* (196) tags_def_opt ::= tags_def */
  {  363,   -4 }, /* (197) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  361,    0 }, /* (198) table_options ::= */
  {  361,   -3 }, /* (199) table_options ::= table_options COMMENT NK_STRING */
  {  361,   -3 }, /* (200) table_options ::= table_options MAX_DELAY duration_list */
  {  361,   -3 }, /* (201) table_options ::= table_options WATERMARK duration_list */
  {  361,   -5 }, /* (202) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  361,   -3 }, /* (203) table_options ::= table_options TTL NK_INTEGER */
  {  361,   -5 }, /* (204) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  361,   -3 }, /* (205) table_options ::= table_options DELETE_MARK duration_list */
  {  366,   -1 }, /* (206) alter_table_options ::= alter_table_option */
  {  366,   -2 }, /* (207) alter_table_options ::= alter_table_options alter_table_option */
  {  378,   -2 }, /* (208) alter_table_option ::= COMMENT NK_STRING */
  {  378,   -2 }, /* (209) alter_table_option ::= TTL NK_INTEGER */
  {  376,   -1 }, /* (210) duration_list ::= duration_literal */
  {  376,   -3 }, /* (211) duration_list ::= duration_list NK_COMMA duration_literal */
  {  377,   -1 }, /* (212) rollup_func_list ::= rollup_func_name */
  {  377,   -3 }, /* (213) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  380,   -1 }, /* (214) rollup_func_name ::= function_name */
  {  380,   -1 }, /* (215) rollup_func_name ::= FIRST */
  {  380,   -1 }, /* (216) rollup_func_name ::= LAST */
  {  374,   -1 }, /* (217) col_name_list ::= col_name */
  {  374,   -3 }, /* (218) col_name_list ::= col_name_list NK_COMMA col_name */
  {  382,   -1 }, /* (219) col_name ::= column_name */
  {  328,   -2 }, /* (220) cmd ::= SHOW DNODES */
  {  328,   -2 }, /* (221) cmd ::= SHOW USERS */
  {  328,   -3 }, /* (222) cmd ::= SHOW USER PRIVILEGES */
  {  328,   -2 }, /* (223) cmd ::= SHOW DATABASES */
  {  328,   -4 }, /* (224) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  328,   -4 }, /* (225) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  328,   -3 }, /* (226) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  328,   -2 }, /* (227) cmd ::= SHOW MNODES */
  {  328,   -2 }, /* (228) cmd ::= SHOW QNODES */
  {  328,   -2 }, /* (229) cmd ::= SHOW FUNCTIONS */
  {  328,   -5 }, /* (230) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  328,   -2 }, /* (231) cmd ::= SHOW STREAMS */
  {  328,   -2 }, /* (232) cmd ::= SHOW ACCOUNTS */
  {  328,   -2 }, /* (233) cmd ::= SHOW APPS */
  {  328,   -2 }, /* (234) cmd ::= SHOW CONNECTIONS */
  {  328,   -2 }, /* (235) cmd ::= SHOW LICENCES */
  {  328,   -2 }, /* (236) cmd ::= SHOW GRANTS */
  {  328,   -4 }, /* (237) cmd ::= SHOW CREATE DATABASE db_name */
  {  328,   -4 }, /* (238) cmd ::= SHOW CREATE TABLE full_table_name */
  {  328,   -4 }, /* (239) cmd ::= SHOW CREATE STABLE full_table_name */
  {  328,   -2 }, /* (240) cmd ::= SHOW QUERIES */
  {  328,   -2 }, /* (241) cmd ::= SHOW SCORES */
  {  328,   -2 }, /* (242) cmd ::= SHOW TOPICS */
  {  328,   -2 }, /* (243) cmd ::= SHOW VARIABLES */
  {  328,   -3 }, /* (244) cmd ::= SHOW CLUSTER VARIABLES */
  {  328,   -3 }, /* (245) cmd ::= SHOW LOCAL VARIABLES */
  {  328,   -5 }, /* (246) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  328,   -2 }, /* (247) cmd ::= SHOW BNODES */
  {  328,   -2 }, /* (248) cmd ::= SHOW SNODES */
  {  328,   -2 }, /* (249) cmd ::= SHOW CLUSTER */
  {  328,   -2 }, /* (250) cmd ::= SHOW TRANSACTIONS */
  {  328,   -4 }, /* (251) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  328,   -2 }, /* (252) cmd ::= SHOW CONSUMERS */
  {  328,   -2 }, /* (253) cmd ::= SHOW SUBSCRIPTIONS */
  {  328,   -5 }, /* (254) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  328,   -7 }, /* (255) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  328,   -3 }, /* (256) cmd ::= SHOW VNODES NK_INTEGER */
  {  328,   -3 }, /* (257) cmd ::= SHOW VNODES NK_STRING */
  {  328,   -3 }, /* (258) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  328,   -3 }, /* (259) cmd ::= SHOW CLUSTER ALIVE */
  {  383,    0 }, /* (260) db_name_cond_opt ::= */
  {  383,   -2 }, /* (261) db_name_cond_opt ::= db_name NK_DOT */
  {  384,    0 }, /* (262) like_pattern_opt ::= */
  {  384,   -2 }, /* (263) like_pattern_opt ::= LIKE NK_STRING */
  {  385,   -1 }, /* (264) table_name_cond ::= table_name */
  {  386,    0 }, /* (265) from_db_opt ::= */
  {  386,   -2 }, /* (266) from_db_opt ::= FROM db_name */
  {  387,    0 }, /* (267) tag_list_opt ::= */
  {  387,   -1 }, /* (268) tag_list_opt ::= tag_item */
  {  387,   -3 }, /* (269) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  388,   -1 }, /* (270) tag_item ::= TBNAME */
  {  388,   -1 }, /* (271) tag_item ::= QTAGS */
  {  388,   -1 }, /* (272) tag_item ::= column_name */
  {  388,   -2 }, /* (273) tag_item ::= column_name column_alias */
  {  388,   -3 }, /* (274) tag_item ::= column_name AS column_alias */
  {  328,   -8 }, /* (275) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  328,   -9 }, /* (276) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  328,   -4 }, /* (277) cmd ::= DROP INDEX exists_opt full_index_name */
  {  390,   -1 }, /* (278) full_index_name ::= index_name */
  {  390,   -3 }, /* (279) full_index_name ::= db_name NK_DOT index_name */
  {  391,  -10 }, /* (280) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  391,  -12 }, /* (281) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  393,   -1 }, /* (282) func_list ::= func */
  {  393,   -3 }, /* (283) func_list ::= func_list NK_COMMA func */
  {  396,   -4 }, /* (284) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  397,   -1 }, /* (285) sma_func_name ::= function_name */
  {  397,   -1 }, /* (286) sma_func_name ::= COUNT */
  {  397,   -1 }, /* (287) sma_func_name ::= FIRST */
  {  397,   -1 }, /* (288) sma_func_name ::= LAST */
  {  397,   -1 }, /* (289) sma_func_name ::= LAST_ROW */
  {  395,    0 }, /* (290) sma_stream_opt ::= */
  {  395,   -3 }, /* (291) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  395,   -3 }, /* (292) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  395,   -3 }, /* (293) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  328,   -6 }, /* (294) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  328,   -7 }, /* (295) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  328,   -9 }, /* (296) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  328,   -7 }, /* (297) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  328,   -9 }, /* (298) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  328,   -4 }, /* (299) cmd ::= DROP TOPIC exists_opt topic_name */
  {  328,   -7 }, /* (300) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  328,   -2 }, /* (301) cmd ::= DESC full_table_name */
  {  328,   -2 }, /* (302) cmd ::= DESCRIBE full_table_name */
  {  328,   -3 }, /* (303) cmd ::= RESET QUERY CACHE */
  {  328,   -4 }, /* (304) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  328,   -4 }, /* (305) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
  {  400,    0 }, /* (306) analyze_opt ::= */
  {  400,   -1 }, /* (307) analyze_opt ::= ANALYZE */
  {  401,    0 }, /* (308) explain_options ::= */
  {  401,   -3 }, /* (309) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  401,   -3 }, /* (310) explain_options ::= explain_options RATIO NK_FLOAT */
  {  328,  -10 }, /* (311) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  328,   -4 }, /* (312) cmd ::= DROP FUNCTION exists_opt function_name */
  {  403,    0 }, /* (313) agg_func_opt ::= */
  {  403,   -1 }, /* (314) agg_func_opt ::= AGGREGATE */
  {  404,    0 }, /* (315) bufsize_opt ::= */
  {  404,   -2 }, /* (316) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  328,  -12 }, /* (317) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  328,   -4 }, /* (318) cmd ::= DROP STREAM exists_opt stream_name */
  {  407,    0 }, /* (319) col_list_opt ::= */
  {  407,   -3 }, /* (320) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  408,    0 }, /* (321) tag_def_or_ref_opt ::= */
  {  408,   -1 }, /* (322) tag_def_or_ref_opt ::= tags_def */
  {  408,   -4 }, /* (323) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  406,    0 }, /* (324) stream_options ::= */
  {  406,   -3 }, /* (325) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  406,   -3 }, /* (326) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  406,   -4 }, /* (327) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  406,   -3 }, /* (328) stream_options ::= stream_options WATERMARK duration_literal */
  {  406,   -4 }, /* (329) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  406,   -3 }, /* (330) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  406,   -3 }, /* (331) stream_options ::= stream_options DELETE_MARK duration_literal */
  {  406,   -4 }, /* (332) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
  {  409,    0 }, /* (333) subtable_opt ::= */
  {  409,   -4 }, /* (334) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  328,   -3 }, /* (335) cmd ::= KILL CONNECTION NK_INTEGER */
  {  328,   -3 }, /* (336) cmd ::= KILL QUERY NK_STRING */
  {  328,   -3 }, /* (337) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  328,   -2 }, /* (338) cmd ::= BALANCE VGROUP */
  {  328,   -4 }, /* (339) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  328,   -4 }, /* (340) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  328,   -3 }, /* (341) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  411,   -2 }, /* (342) dnode_list ::= DNODE NK_INTEGER */
  {  411,   -3 }, /* (343) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  328,   -4 }, /* (344) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  328,   -1 }, /* (345) cmd ::= query_or_subquery */
  {  328,   -1 }, /* (346) cmd ::= insert_query */
  {  402,   -7 }, /* (347) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  402,   -4 }, /* (348) insert_query ::= INSERT INTO full_table_name query_or_subquery */
  {  331,   -1 }, /* (349) literal ::= NK_INTEGER */
  {  331,   -1 }, /* (350) literal ::= NK_FLOAT */
  {  331,   -1 }, /* (351) literal ::= NK_STRING */
  {  331,   -1 }, /* (352) literal ::= NK_BOOL */
  {  331,   -2 }, /* (353) literal ::= TIMESTAMP NK_STRING */
  {  331,   -1 }, /* (354) literal ::= duration_literal */
  {  331,   -1 }, /* (355) literal ::= NULL */
  {  331,   -1 }, /* (356) literal ::= NK_QUESTION */
  {  379,   -1 }, /* (357) duration_literal ::= NK_VARIABLE */
  {  413,   -1 }, /* (358) signed ::= NK_INTEGER */
  {  413,   -2 }, /* (359) signed ::= NK_PLUS NK_INTEGER */
  {  413,   -2 }, /* (360) signed ::= NK_MINUS NK_INTEGER */
  {  413,   -1 }, /* (361) signed ::= NK_FLOAT */
  {  413,   -2 }, /* (362) signed ::= NK_PLUS NK_FLOAT */
  {  413,   -2 }, /* (363) signed ::= NK_MINUS NK_FLOAT */
  {  369,   -1 }, /* (364) signed_literal ::= signed */
  {  369,   -1 }, /* (365) signed_literal ::= NK_STRING */
  {  369,   -1 }, /* (366) signed_literal ::= NK_BOOL */
  {  369,   -2 }, /* (367) signed_literal ::= TIMESTAMP NK_STRING */
  {  369,   -1 }, /* (368) signed_literal ::= duration_literal */
  {  369,   -1 }, /* (369) signed_literal ::= NULL */
  {  369,   -1 }, /* (370) signed_literal ::= literal_func */
  {  369,   -1 }, /* (371) signed_literal ::= NK_QUESTION */
  {  415,   -1 }, /* (372) literal_list ::= signed_literal */
  {  415,   -3 }, /* (373) literal_list ::= literal_list NK_COMMA signed_literal */
  {  340,   -1 }, /* (374) db_name ::= NK_ID */
  {  341,   -1 }, /* (375) table_name ::= NK_ID */
  {  367,   -1 }, /* (376) column_name ::= NK_ID */
  {  381,   -1 }, /* (377) function_name ::= NK_ID */
  {  416,   -1 }, /* (378) table_alias ::= NK_ID */
  {  389,   -1 }, /* (379) column_alias ::= NK_ID */
  {  333,   -1 }, /* (380) user_name ::= NK_ID */
  {  342,   -1 }, /* (381) topic_name ::= NK_ID */
  {  405,   -1 }, /* (382) stream_name ::= NK_ID */
  {  399,   -1 }, /* (383) cgroup_name ::= NK_ID */
  {  392,   -1 }, /* (384) index_name ::= NK_ID */
  {  417,   -1 }, /* (385) expr_or_subquery ::= expression */
  {  410,   -1 }, /* (386) expression ::= literal */
  {  410,   -1 }, /* (387) expression ::= pseudo_column */
  {  410,   -1 }, /* (388) expression ::= column_reference */
  {  410,   -1 }, /* (389) expression ::= function_expression */
  {  410,   -1 }, /* (390) expression ::= case_when_expression */
  {  410,   -3 }, /* (391) expression ::= NK_LP expression NK_RP */
  {  410,   -2 }, /* (392) expression ::= NK_PLUS expr_or_subquery */
  {  410,   -2 }, /* (393) expression ::= NK_MINUS expr_or_subquery */
  {  410,   -3 }, /* (394) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  410,   -3 }, /* (395) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  410,   -3 }, /* (396) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  410,   -3 }, /* (397) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  410,   -3 }, /* (398) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  410,   -3 }, /* (399) expression ::= column_reference NK_ARROW NK_STRING */
  {  410,   -3 }, /* (400) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  410,   -3 }, /* (401) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  372,   -1 }, /* (402) expression_list ::= expr_or_subquery */
  {  372,   -3 }, /* (403) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  419,   -1 }, /* (404) column_reference ::= column_name */
  {  419,   -3 }, /* (405) column_reference ::= table_name NK_DOT column_name */
  {  418,   -1 }, /* (406) pseudo_column ::= ROWTS */
  {  418,   -1 }, /* (407) pseudo_column ::= TBNAME */
  {  418,   -3 }, /* (408) pseudo_column ::= table_name NK_DOT TBNAME */
  {  418,   -1 }, /* (409) pseudo_column ::= QSTART */
  {  418,   -1 }, /* (410) pseudo_column ::= QEND */
  {  418,   -1 }, /* (411) pseudo_column ::= QDURATION */
  {  418,   -1 }, /* (412) pseudo_column ::= WSTART */
  {  418,   -1 }, /* (413) pseudo_column ::= WEND */
  {  418,   -1 }, /* (414) pseudo_column ::= WDURATION */
  {  418,   -1 }, /* (415) pseudo_column ::= IROWTS */
  {  418,   -1 }, /* (416) pseudo_column ::= ISFILLED */
  {  418,   -1 }, /* (417) pseudo_column ::= QTAGS */
  {  420,   -4 }, /* (418) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  420,   -4 }, /* (419) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  420,   -6 }, /* (420) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  420,   -1 }, /* (421) function_expression ::= literal_func */
  {  414,   -3 }, /* (422) literal_func ::= noarg_func NK_LP NK_RP */
  {  414,   -1 }, /* (423) literal_func ::= NOW */
  {  424,   -1 }, /* (424) noarg_func ::= NOW */
  {  424,   -1 }, /* (425) noarg_func ::= TODAY */
  {  424,   -1 }, /* (426) noarg_func ::= TIMEZONE */
  {  424,   -1 }, /* (427) noarg_func ::= DATABASE */
  {  424,   -1 }, /* (428) noarg_func ::= CLIENT_VERSION */
  {  424,   -1 }, /* (429) noarg_func ::= SERVER_VERSION */
  {  424,   -1 }, /* (430) noarg_func ::= SERVER_STATUS */
  {  424,   -1 }, /* (431) noarg_func ::= CURRENT_USER */
  {  424,   -1 }, /* (432) noarg_func ::= USER */
  {  422,   -1 }, /* (433) star_func ::= COUNT */
  {  422,   -1 }, /* (434) star_func ::= FIRST */
  {  422,   -1 }, /* (435) star_func ::= LAST */
  {  422,   -1 }, /* (436) star_func ::= LAST_ROW */
  {  423,   -1 }, /* (437) star_func_para_list ::= NK_STAR */
  {  423,   -1 }, /* (438) star_func_para_list ::= other_para_list */
  {  425,   -1 }, /* (439) other_para_list ::= star_func_para */
  {  425,   -3 }, /* (440) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  426,   -1 }, /* (441) star_func_para ::= expr_or_subquery */
  {  426,   -3 }, /* (442) star_func_para ::= table_name NK_DOT NK_STAR */
  {  421,   -4 }, /* (443) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  421,   -5 }, /* (444) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  427,   -1 }, /* (445) when_then_list ::= when_then_expr */
  {  427,   -2 }, /* (446) when_then_list ::= when_then_list when_then_expr */
  {  430,   -4 }, /* (447) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  428,    0 }, /* (448) case_when_else_opt ::= */
  {  428,   -2 }, /* (449) case_when_else_opt ::= ELSE common_expression */
  {  431,   -3 }, /* (450) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  431,   -5 }, /* (451) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  431,   -6 }, /* (452) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  431,   -3 }, /* (453) predicate ::= expr_or_subquery IS NULL */
  {  431,   -4 }, /* (454) predicate ::= expr_or_subquery IS NOT NULL */
  {  431,   -3 }, /* (455) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  432,   -1 }, /* (456) compare_op ::= NK_LT */
  {  432,   -1 }, /* (457) compare_op ::= NK_GT */
  {  432,   -1 }, /* (458) compare_op ::= NK_LE */
  {  432,   -1 }, /* (459) compare_op ::= NK_GE */
  {  432,   -1 }, /* (460) compare_op ::= NK_NE */
  {  432,   -1 }, /* (461) compare_op ::= NK_EQ */
  {  432,   -1 }, /* (462) compare_op ::= LIKE */
  {  432,   -2 }, /* (463) compare_op ::= NOT LIKE */
  {  432,   -1 }, /* (464) compare_op ::= MATCH */
  {  432,   -1 }, /* (465) compare_op ::= NMATCH */
  {  432,   -1 }, /* (466) compare_op ::= CONTAINS */
  {  433,   -1 }, /* (467) in_op ::= IN */
  {  433,   -2 }, /* (468) in_op ::= NOT IN */
  {  434,   -3 }, /* (469) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  435,   -1 }, /* (470) boolean_value_expression ::= boolean_primary */
  {  435,   -2 }, /* (471) boolean_value_expression ::= NOT boolean_primary */
  {  435,   -3 }, /* (472) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  435,   -3 }, /* (473) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  436,   -1 }, /* (474) boolean_primary ::= predicate */
  {  436,   -3 }, /* (475) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  429,   -1 }, /* (476) common_expression ::= expr_or_subquery */
  {  429,   -1 }, /* (477) common_expression ::= boolean_value_expression */
  {  437,    0 }, /* (478) from_clause_opt ::= */
  {  437,   -2 }, /* (479) from_clause_opt ::= FROM table_reference_list */
  {  438,   -1 }, /* (480) table_reference_list ::= table_reference */
  {  438,   -3 }, /* (481) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  439,   -1 }, /* (482) table_reference ::= table_primary */
  {  439,   -1 }, /* (483) table_reference ::= joined_table */
  {  440,   -2 }, /* (484) table_primary ::= table_name alias_opt */
  {  440,   -4 }, /* (485) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  440,   -2 }, /* (486) table_primary ::= subquery alias_opt */
  {  440,   -1 }, /* (487) table_primary ::= parenthesized_joined_table */
  {  442,    0 }, /* (488) alias_opt ::= */
  {  442,   -1 }, /* (489) alias_opt ::= table_alias */
  {  442,   -2 }, /* (490) alias_opt ::= AS table_alias */
  {  444,   -3 }, /* (491) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  444,   -3 }, /* (492) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  441,   -6 }, /* (493) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  445,    0 }, /* (494) join_type ::= */
  {  445,   -1 }, /* (495) join_type ::= INNER */
  {  446,  -12 }, /* (496) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  447,    0 }, /* (497) set_quantifier_opt ::= */
  {  447,   -1 }, /* (498) set_quantifier_opt ::= DISTINCT */
  {  447,   -1 }, /* (499) set_quantifier_opt ::= ALL */
  {  448,   -1 }, /* (500) select_list ::= select_item */
  {  448,   -3 }, /* (501) select_list ::= select_list NK_COMMA select_item */
  {  456,   -1 }, /* (502) select_item ::= NK_STAR */
  {  456,   -1 }, /* (503) select_item ::= common_expression */
  {  456,   -2 }, /* (504) select_item ::= common_expression column_alias */
  {  456,   -3 }, /* (505) select_item ::= common_expression AS column_alias */
  {  456,   -3 }, /* (506) select_item ::= table_name NK_DOT NK_STAR */
  {  412,    0 }, /* (507) where_clause_opt ::= */
  {  412,   -2 }, /* (508) where_clause_opt ::= WHERE search_condition */
  {  449,    0 }, /* (509) partition_by_clause_opt ::= */
  {  449,   -3 }, /* (510) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  457,   -1 }, /* (511) partition_list ::= partition_item */
  {  457,   -3 }, /* (512) partition_list ::= partition_list NK_COMMA partition_item */
  {  458,   -1 }, /* (513) partition_item ::= expr_or_subquery */
  {  458,   -2 }, /* (514) partition_item ::= expr_or_subquery column_alias */
  {  458,   -3 }, /* (515) partition_item ::= expr_or_subquery AS column_alias */
  {  453,    0 }, /* (516) twindow_clause_opt ::= */
  {  453,   -6 }, /* (517) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  453,   -4 }, /* (518) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  453,   -6 }, /* (519) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  453,   -8 }, /* (520) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  453,   -7 }, /* (521) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  394,    0 }, /* (522) sliding_opt ::= */
  {  394,   -4 }, /* (523) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  452,    0 }, /* (524) fill_opt ::= */
  {  452,   -4 }, /* (525) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  452,   -6 }, /* (526) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  452,   -6 }, /* (527) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
  {  459,   -1 }, /* (528) fill_mode ::= NONE */
  {  459,   -1 }, /* (529) fill_mode ::= PREV */
  {  459,   -1 }, /* (530) fill_mode ::= NULL */
  {  459,   -1 }, /* (531) fill_mode ::= NULL_F */
  {  459,   -1 }, /* (532) fill_mode ::= LINEAR */
  {  459,   -1 }, /* (533) fill_mode ::= NEXT */
  {  454,    0 }, /* (534) group_by_clause_opt ::= */
  {  454,   -3 }, /* (535) group_by_clause_opt ::= GROUP BY group_by_list */
  {  460,   -1 }, /* (536) group_by_list ::= expr_or_subquery */
  {  460,   -3 }, /* (537) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  455,    0 }, /* (538) having_clause_opt ::= */
  {  455,   -2 }, /* (539) having_clause_opt ::= HAVING search_condition */
  {  450,    0 }, /* (540) range_opt ::= */
  {  450,   -6 }, /* (541) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  451,    0 }, /* (542) every_opt ::= */
  {  451,   -4 }, /* (543) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  461,   -4 }, /* (544) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  462,   -1 }, /* (545) query_simple ::= query_specification */
  {  462,   -1 }, /* (546) query_simple ::= union_query_expression */
  {  466,   -4 }, /* (547) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  466,   -3 }, /* (548) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  467,   -1 }, /* (549) query_simple_or_subquery ::= query_simple */
  {  467,   -1 }, /* (550) query_simple_or_subquery ::= subquery */
  {  398,   -1 }, /* (551) query_or_subquery ::= query_expression */
  {  398,   -1 }, /* (552) query_or_subquery ::= subquery */
  {  463,    0 }, /* (553) order_by_clause_opt ::= */
  {  463,   -3 }, /* (554) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  464,    0 }, /* (555) slimit_clause_opt ::= */
  {  464,   -2 }, /* (556) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  464,   -4 }, /* (557) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  464,   -4 }, /* (558) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  465,    0 }, /* (559) limit_clause_opt ::= */
  {  465,   -2 }, /* (560) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  465,   -4 }, /* (561) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  465,   -4 }, /* (562) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  443,   -3 }, /* (563) subquery ::= NK_LP query_expression NK_RP */
  {  443,   -3 }, /* (564) subquery ::= NK_LP subquery NK_RP */
  {  343,   -1 }, /* (565) search_condition ::= common_expression */
  {  468,   -1 }, /* (566) sort_specification_list ::= sort_specification */
  {  468,   -3 }, /* (567) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  469,   -3 }, /* (568) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  470,    0 }, /* (569) ordering_specification_opt ::= */
  {  470,   -1 }, /* (570) ordering_specification_opt ::= ASC */
  {  470,   -1 }, /* (571) ordering_specification_opt ::= DESC */
  {  471,    0 }, /* (572) null_ordering_opt ::= */
  {  471,   -2 }, /* (573) null_ordering_opt ::= NULLS FIRST */
  {  471,   -2 }, /* (574) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,329,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,330,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,329,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,331,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,332,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,330,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,332,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,331,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy97, &yymsp[-1].minor.yy0, yymsp[0].minor.yy519); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy97, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy97, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy97, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy97); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy519 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy519 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-5].minor.yy93, &yymsp[-3].minor.yy569, &yymsp[0].minor.yy97, yymsp[-2].minor.yy792); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-5].minor.yy93, &yymsp[-3].minor.yy569, &yymsp[0].minor.yy97, yymsp[-2].minor.yy792); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy93 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy93 = yymsp[0].minor.yy93; }
  yymsp[0].minor.yy93 = yylhsminor.yy93;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy93 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy93 = yymsp[-2].minor.yy93 | yymsp[0].minor.yy93; }
  yymsp[-2].minor.yy93 = yylhsminor.yy93;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy93 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy93 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy569.first = yymsp[-2].minor.yy0; yylhsminor.yy569.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy569 = yylhsminor.yy569;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy569.first = yymsp[-2].minor.yy97; yylhsminor.yy569.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy569 = yylhsminor.yy569;
        break;
      case 42: /* priv_level ::= db_name NK_DOT table_name */
{ yylhsminor.yy569.first = yymsp[-2].minor.yy97; yylhsminor.yy569.second = yymsp[0].minor.yy97; }
  yymsp[-2].minor.yy569 = yylhsminor.yy569;
        break;
      case 43: /* priv_level ::= topic_name */
{ yylhsminor.yy569.first = yymsp[0].minor.yy97; yylhsminor.yy569.second = nil_token; }
  yymsp[0].minor.yy569 = yylhsminor.yy569;
        break;
      case 44: /* with_opt ::= */
      case 133: /* start_opt ::= */ yytestcase(yyruleno==133);
      case 137: /* end_opt ::= */ yytestcase(yyruleno==137);
      case 262: /* like_pattern_opt ::= */ yytestcase(yyruleno==262);
      case 333: /* subtable_opt ::= */ yytestcase(yyruleno==333);
      case 448: /* case_when_else_opt ::= */ yytestcase(yyruleno==448);
      case 478: /* from_clause_opt ::= */ yytestcase(yyruleno==478);
      case 507: /* where_clause_opt ::= */ yytestcase(yyruleno==507);
      case 516: /* twindow_clause_opt ::= */ yytestcase(yyruleno==516);
      case 522: /* sliding_opt ::= */ yytestcase(yyruleno==522);
      case 524: /* fill_opt ::= */ yytestcase(yyruleno==524);
      case 538: /* having_clause_opt ::= */ yytestcase(yyruleno==538);
      case 540: /* range_opt ::= */ yytestcase(yyruleno==540);
      case 542: /* every_opt ::= */ yytestcase(yyruleno==542);
      case 555: /* slimit_clause_opt ::= */ yytestcase(yyruleno==555);
      case 559: /* limit_clause_opt ::= */ yytestcase(yyruleno==559);
{ yymsp[1].minor.yy792 = NULL; }
        break;
      case 45: /* with_opt ::= WITH search_condition */
      case 479: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==479);
      case 508: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==508);
      case 539: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==539);
{ yymsp[-1].minor.yy792 = yymsp[0].minor.yy792; }
        break;
      case 46: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy97, NULL); }
        break;
      case 47: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy97, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy89); }
        break;
      case 49: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy97, yymsp[0].minor.yy89); }
        break;
      case 50: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 51: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 52: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* dnode_endpoint ::= NK_STRING */
      case 55: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==55);
      case 56: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==56);
      case 286: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==286);
      case 287: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==287);
      case 288: /* sma_func_name ::= LAST */ yytestcase(yyruleno==288);
      case 289: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==289);
      case 374: /* db_name ::= NK_ID */ yytestcase(yyruleno==374);
      case 375: /* table_name ::= NK_ID */ yytestcase(yyruleno==375);
      case 376: /* column_name ::= NK_ID */ yytestcase(yyruleno==376);
      case 377: /* function_name ::= NK_ID */ yytestcase(yyruleno==377);
      case 378: /* table_alias ::= NK_ID */ yytestcase(yyruleno==378);
      case 379: /* column_alias ::= NK_ID */ yytestcase(yyruleno==379);
      case 380: /* user_name ::= NK_ID */ yytestcase(yyruleno==380);
      case 381: /* topic_name ::= NK_ID */ yytestcase(yyruleno==381);
      case 382: /* stream_name ::= NK_ID */ yytestcase(yyruleno==382);
      case 383: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==383);
      case 384: /* index_name ::= NK_ID */ yytestcase(yyruleno==384);
      case 424: /* noarg_func ::= NOW */ yytestcase(yyruleno==424);
      case 425: /* noarg_func ::= TODAY */ yytestcase(yyruleno==425);
      case 426: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==426);
      case 427: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==427);
      case 428: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==428);
      case 429: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==429);
      case 430: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==430);
      case 431: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==431);
      case 432: /* noarg_func ::= USER */ yytestcase(yyruleno==432);
      case 433: /* star_func ::= COUNT */ yytestcase(yyruleno==433);
      case 434: /* star_func ::= FIRST */ yytestcase(yyruleno==434);
      case 435: /* star_func ::= LAST */ yytestcase(yyruleno==435);
      case 436: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==436);
{ yylhsminor.yy97 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy97 = yylhsminor.yy97;
        break;
      case 57: /* force_opt ::= */
      case 77: /* not_exists_opt ::= */ yytestcase(yyruleno==77);
      case 79: /* exists_opt ::= */ yytestcase(yyruleno==79);
      case 306: /* analyze_opt ::= */ yytestcase(yyruleno==306);
      case 313: /* agg_func_opt ::= */ yytestcase(yyruleno==313);
      case 497: /* set_quantifier_opt ::= */ yytestcase(yyruleno==497);
{ yymsp[1].minor.yy89 = false; }
        break;
      case 58: /* force_opt ::= FORCE */
      case 307: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==307);
      case 314: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==314);
      case 498: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==498);
{ yymsp[0].minor.yy89 = true; }
        break;
      case 59: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 60: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 67: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 68: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 69: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy89, &yymsp[-1].minor.yy97, yymsp[0].minor.yy792); }
        break;
      case 70: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy97); }
        break;
      case 71: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy97); }
        break;
      case 72: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy97, yymsp[0].minor.yy792); }
        break;
      case 73: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy97); }
        break;
      case 74: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy97, yymsp[0].minor.yy20); }
        break;
      case 75: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy97, yymsp[-1].minor.yy792, yymsp[0].minor.yy792); }
        break;
      case 76: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy89 = true; }
        break;
      case 78: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy89 = true; }
        break;
      case 80: /* db_options ::= */
{ yymsp[1].minor.yy792 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 81: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 82: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 83: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 84: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 85: /* db_options ::= db_options DURATION NK_INTEGER */
      case 86: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==86);
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 87: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 88: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 89: /* db_options ::= db_options KEEP integer_list */
      case 90: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==90);
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_KEEP, yymsp[0].minor.yy520); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 91: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 92: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 93: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 94: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 95: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 96: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 97: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 98: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_RETENTIONS, yymsp[0].minor.yy520); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 99: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 100: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 101: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 103: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-3].minor.yy792, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 104: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 105: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-3].minor.yy792, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 106: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 107: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 108: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 109: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 110: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy792 = setDatabaseOption(pCxt, yymsp[-2].minor.yy792, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 111: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy792 = createAlterDatabaseOptions(pCxt); yylhsminor.yy792 = setAlterDatabaseOption(pCxt, yylhsminor.yy792, &yymsp[0].minor.yy285); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 112: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy792 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy792, &yymsp[0].minor.yy285); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 113: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy285.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy285.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 115: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy285.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy285.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= KEEP integer_list */
      case 118: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==118);
{ yymsp[-1].minor.yy285.type = DB_OPTION_KEEP; yymsp[-1].minor.yy285.pList = yymsp[0].minor.yy520; }
        break;
      case 119: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy285.type = DB_OPTION_PAGES; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy285.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 121: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy285.type = DB_OPTION_WAL; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 122: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy285.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 123: /* alter_db_option ::= MINROWS NK_INTEGER */
{ yymsp[-1].minor.yy285.type = DB_OPTION_MINROWS; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 124: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy520 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 125: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 343: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==343);
{ yylhsminor.yy520 = addNodeToList(pCxt, yymsp[-2].minor.yy520, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 126: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy520 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 127: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy520 = addNodeToList(pCxt, yymsp[-2].minor.yy520, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 128: /* retention_list ::= retention */
      case 158: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==158);
      case 161: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==161);
      case 168: /* column_def_list ::= column_def */ yytestcase(yyruleno==168);
      case 212: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==212);
      case 217: /* col_name_list ::= col_name */ yytestcase(yyruleno==217);
      case 268: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==268);
      case 282: /* func_list ::= func */ yytestcase(yyruleno==282);
      case 372: /* literal_list ::= signed_literal */ yytestcase(yyruleno==372);
      case 439: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==439);
      case 445: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==445);
      case 500: /* select_list ::= select_item */ yytestcase(yyruleno==500);
      case 511: /* partition_list ::= partition_item */ yytestcase(yyruleno==511);
      case 566: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==566);
{ yylhsminor.yy520 = createNodeList(pCxt, yymsp[0].minor.yy792); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 129: /* retention_list ::= retention_list NK_COMMA retention */
      case 162: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==162);
      case 169: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==169);
      case 213: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==213);
      case 218: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==218);
      case 269: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==269);
      case 283: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==283);
      case 373: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==373);
      case 440: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==440);
      case 501: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==501);
      case 512: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==512);
      case 567: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==567);
{ yylhsminor.yy520 = addNodeToList(pCxt, yymsp[-2].minor.yy520, yymsp[0].minor.yy792); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 130: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy792 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 131: /* speed_opt ::= */
      case 315: /* bufsize_opt ::= */ yytestcase(yyruleno==315);
{ yymsp[1].minor.yy20 = 0; }
        break;
      case 132: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 316: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==316);
{ yymsp[-1].minor.yy20 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 134: /* start_opt ::= START WITH NK_INTEGER */
      case 138: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==138);
{ yymsp[-2].minor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 135: /* start_opt ::= START WITH NK_STRING */
      case 139: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==139);
{ yymsp[-2].minor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 136: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 140: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==140);
{ yymsp[-3].minor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 141: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 143: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==143);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy89, yymsp[-5].minor.yy792, yymsp[-3].minor.yy520, yymsp[-1].minor.yy520, yymsp[0].minor.yy792); }
        break;
      case 142: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy520); }
        break;
      case 144: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy520); }
        break;
      case 145: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy89, yymsp[0].minor.yy792); }
        break;
      case 146: /* cmd ::= ALTER TABLE alter_table_clause */
      case 345: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==345);
      case 346: /* cmd ::= insert_query */ yytestcase(yyruleno==346);
{ pCxt->pRootNode = yymsp[0].minor.yy792; }
        break;
      case 147: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy792); }
        break;
      case 148: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy792 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy792, yymsp[0].minor.yy792); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 149: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy792 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy792, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy97, yymsp[0].minor.yy848); }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 150: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy792 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy792, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy97); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 151: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy792 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy792, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy97, yymsp[0].minor.yy848); }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 152: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy792 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy792, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy97, &yymsp[0].minor.yy97); }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 153: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy792 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy792, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy97, yymsp[0].minor.yy848); }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 154: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy792 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy792, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy97); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 155: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy792 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy792, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy97, yymsp[0].minor.yy848); }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 156: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy792 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy792, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy97, &yymsp[0].minor.yy97); }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 157: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy792 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy792, &yymsp[-2].minor.yy97, yymsp[0].minor.yy792); }
  yymsp[-5].minor.yy792 = yylhsminor.yy792;
        break;
      case 159: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 446: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==446);
{ yylhsminor.yy520 = addNodeToList(pCxt, yymsp[-1].minor.yy520, yymsp[0].minor.yy792); }
  yymsp[-1].minor.yy520 = yylhsminor.yy520;
        break;
      case 160: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy792 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy89, yymsp[-8].minor.yy792, yymsp[-6].minor.yy792, yymsp[-5].minor.yy520, yymsp[-2].minor.yy520, yymsp[0].minor.yy792); }
  yymsp[-9].minor.yy792 = yylhsminor.yy792;
        break;
      case 163: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy792 = createDropTableClause(pCxt, yymsp[-1].minor.yy89, yymsp[0].minor.yy792); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 164: /* specific_cols_opt ::= */
      case 195: /* tags_def_opt ::= */ yytestcase(yyruleno==195);
      case 267: /* tag_list_opt ::= */ yytestcase(yyruleno==267);
      case 319: /* col_list_opt ::= */ yytestcase(yyruleno==319);
      case 321: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==321);
      case 509: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==509);
      case 534: /* group_by_clause_opt ::= */ yytestcase(yyruleno==534);
      case 553: /* order_by_clause_opt ::= */ yytestcase(yyruleno==553);
{ yymsp[1].minor.yy520 = NULL; }
        break;
      case 165: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 320: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==320);
{ yymsp[-2].minor.yy520 = yymsp[-1].minor.yy520; }
        break;
      case 166: /* full_table_name ::= table_name */
{ yylhsminor.yy792 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy97, NULL); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 167: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy792 = createRealTableNode(pCxt, &yymsp[-2].minor.yy97, &yymsp[0].minor.yy97, NULL); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 170: /* column_def ::= column_name type_name */
{ yylhsminor.yy792 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy97, yymsp[0].minor.yy848, NULL); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 171: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy792 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy97, yymsp[-2].minor.yy848, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 172: /* type_name ::= BOOL */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 173: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 174: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 175: /* type_name ::= INT */
      case 176: /* type_name ::= INTEGER */ yytestcase(yyruleno==176);
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 177: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 178: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 179: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 180: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy848 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 181: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 182: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy848 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 183: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy848 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 184: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy848 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 185: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy848 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 186: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy848 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 187: /* type_name ::= JSON */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 188: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy848 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 189: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 190: /* type_name ::= BLOB */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 191: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy848 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 192: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy848 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 193: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy848 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 194: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy848 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 196: /* tags_def_opt ::= tags_def */
      case 322: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==322);
      case 438: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==438);
{ yylhsminor.yy520 = yymsp[0].minor.yy520; }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 197: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 323: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==323);
{ yymsp[-3].minor.yy520 = yymsp[-1].minor.yy520; }
        break;
      case 198: /* table_options ::= */
{ yymsp[1].minor.yy792 = createDefaultTableOptions(pCxt); }
        break;
      case 199: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy792 = setTableOption(pCxt, yymsp[-2].minor.yy792, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 200: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy792 = setTableOption(pCxt, yymsp[-2].minor.yy792, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy520); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 201: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy792 = setTableOption(pCxt, yymsp[-2].minor.yy792, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy520); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 202: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy792 = setTableOption(pCxt, yymsp[-4].minor.yy792, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy520); }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 203: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy792 = setTableOption(pCxt, yymsp[-2].minor.yy792, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 204: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy792 = setTableOption(pCxt, yymsp[-4].minor.yy792, TABLE_OPTION_SMA, yymsp[-1].minor.yy520); }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 205: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy792 = setTableOption(pCxt, yymsp[-2].minor.yy792, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy520); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 206: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy792 = createAlterTableOptions(pCxt); yylhsminor.yy792 = setTableOption(pCxt, yylhsminor.yy792, yymsp[0].minor.yy285.type, &yymsp[0].minor.yy285.val); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 207: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy792 = setTableOption(pCxt, yymsp[-1].minor.yy792, yymsp[0].minor.yy285.type, &yymsp[0].minor.yy285.val); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 208: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy285.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 209: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy285.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy285.val = yymsp[0].minor.yy0; }
        break;
      case 210: /* duration_list ::= duration_literal */
      case 402: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==402);
{ yylhsminor.yy520 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy792)); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 211: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 403: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==403);
{ yylhsminor.yy520 = addNodeToList(pCxt, yymsp[-2].minor.yy520, releaseRawExprNode(pCxt, yymsp[0].minor.yy792)); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 214: /* rollup_func_name ::= function_name */
{ yylhsminor.yy792 = createFunctionNode(pCxt, &yymsp[0].minor.yy97, NULL); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 215: /* rollup_func_name ::= FIRST */
      case 216: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==216);
      case 271: /* tag_item ::= QTAGS */ yytestcase(yyruleno==271);
{ yylhsminor.yy792 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 219: /* col_name ::= column_name */
      case 272: /* tag_item ::= column_name */ yytestcase(yyruleno==272);
{ yylhsminor.yy792 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy97); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 220: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 221: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 222: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 223: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 224: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy792, yymsp[0].minor.yy792, OP_TYPE_LIKE); }
        break;
      case 225: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy792, yymsp[0].minor.yy792, OP_TYPE_LIKE); }
        break;
      case 226: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy792, NULL, OP_TYPE_LIKE); }
        break;
      case 227: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 228: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 229: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 230: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy792, yymsp[-1].minor.yy792, OP_TYPE_EQUAL); }
        break;
      case 231: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 232: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 233: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 234: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 235: /* cmd ::= SHOW LICENCES */
      case 236: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==236);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 237: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy97); }
        break;
      case 238: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy792); }
        break;
      case 239: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy792); }
        break;
      case 240: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 241: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 242: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 243: /* cmd ::= SHOW VARIABLES */
      case 244: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==244);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 245: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 246: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy792); }
        break;
      case 247: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 248: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 249: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 250: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 251: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy792); }
        break;
      case 252: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 253: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 254: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy792, yymsp[-1].minor.yy792, OP_TYPE_EQUAL); }
        break;
      case 255: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy792, yymsp[0].minor.yy792, yymsp[-3].minor.yy520); }
        break;
      case 256: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 257: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 258: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy792,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 259: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 260: /* db_name_cond_opt ::= */
      case 265: /* from_db_opt ::= */ yytestcase(yyruleno==265);
{ yymsp[1].minor.yy792 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 261: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy792 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy97); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 263: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 264: /* table_name_cond ::= table_name */
{ yylhsminor.yy792 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy97); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 266: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy792 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy97); }
        break;
      case 270: /* tag_item ::= TBNAME */
{ yylhsminor.yy792 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 273: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy792 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy97), &yymsp[0].minor.yy97); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 274: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy792 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy97), &yymsp[0].minor.yy97); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 275: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy89, yymsp[-3].minor.yy792, yymsp[-1].minor.yy792, NULL, yymsp[0].minor.yy792); }
        break;
      case 276: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy89, yymsp[-5].minor.yy792, yymsp[-3].minor.yy792, yymsp[-1].minor.yy520, NULL); }
        break;
      case 277: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy89, yymsp[0].minor.yy792); }
        break;
      case 278: /* full_index_name ::= index_name */
{ yylhsminor.yy792 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy97); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 279: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy792 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy97, &yymsp[0].minor.yy97); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 280: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy792 = createIndexOption(pCxt, yymsp[-7].minor.yy520, releaseRawExprNode(pCxt, yymsp[-3].minor.yy792), NULL, yymsp[-1].minor.yy792, yymsp[0].minor.yy792); }
        break;
      case 281: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy792 = createIndexOption(pCxt, yymsp[-9].minor.yy520, releaseRawExprNode(pCxt, yymsp[-5].minor.yy792), releaseRawExprNode(pCxt, yymsp[-3].minor.yy792), yymsp[-1].minor.yy792, yymsp[0].minor.yy792); }
        break;
      case 284: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy792 = createFunctionNode(pCxt, &yymsp[-3].minor.yy97, yymsp[-1].minor.yy520); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 285: /* sma_func_name ::= function_name */
      case 489: /* alias_opt ::= table_alias */ yytestcase(yyruleno==489);
{ yylhsminor.yy97 = yymsp[0].minor.yy97; }
  yymsp[0].minor.yy97 = yylhsminor.yy97;
        break;
      case 290: /* sma_stream_opt ::= */
      case 324: /* stream_options ::= */ yytestcase(yyruleno==324);
{ yymsp[1].minor.yy792 = createStreamOptions(pCxt); }
        break;
      case 291: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy792)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy792); yylhsminor.yy792 = yymsp[-2].minor.yy792; }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 292: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy792)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy792); yylhsminor.yy792 = yymsp[-2].minor.yy792; }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 293: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy792)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy792); yylhsminor.yy792 = yymsp[-2].minor.yy792; }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 294: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy89, &yymsp[-2].minor.yy97, yymsp[0].minor.yy792); }
        break;
      case 295: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy89, &yymsp[-3].minor.yy97, &yymsp[0].minor.yy97, false); }
        break;
      case 296: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy89, &yymsp[-5].minor.yy97, &yymsp[0].minor.yy97, true); }
        break;
      case 297: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy89, &yymsp[-3].minor.yy97, yymsp[0].minor.yy792, false); }
        break;
      case 298: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy89, &yymsp[-5].minor.yy97, yymsp[0].minor.yy792, true); }
        break;
      case 299: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy97); }
        break;
      case 300: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy89, &yymsp[-2].minor.yy97, &yymsp[0].minor.yy97); }
        break;
      case 301: /* cmd ::= DESC full_table_name */
      case 302: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==302);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy792); }
        break;
      case 303: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 304: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 305: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==305);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy89, yymsp[-1].minor.yy792, yymsp[0].minor.yy792); }
        break;
      case 308: /* explain_options ::= */
{ yymsp[1].minor.yy792 = createDefaultExplainOptions(pCxt); }
        break;
      case 309: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy792 = setExplainVerbose(pCxt, yymsp[-2].minor.yy792, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 310: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy792 = setExplainRatio(pCxt, yymsp[-2].minor.yy792, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 311: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy89, yymsp[-8].minor.yy89, &yymsp[-5].minor.yy97, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy848, yymsp[0].minor.yy20); }
        break;
      case 312: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy97); }
        break;
      case 317: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy89, &yymsp[-8].minor.yy97, yymsp[-5].minor.yy792, yymsp[-7].minor.yy792, yymsp[-3].minor.yy520, yymsp[-2].minor.yy792, yymsp[0].minor.yy792, yymsp[-4].minor.yy520); }
        break;
      case 318: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy97); }
        break;
      case 325: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 326: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==326);
{ yylhsminor.yy792 = setStreamOptions(pCxt, yymsp[-2].minor.yy792, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 327: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ yylhsminor.yy792 = setStreamOptions(pCxt, yymsp[-3].minor.yy792, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy792)); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 328: /* stream_options ::= stream_options WATERMARK duration_literal */
{ yylhsminor.yy792 = setStreamOptions(pCxt, yymsp[-2].minor.yy792, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy792)); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 329: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ yylhsminor.yy792 = setStreamOptions(pCxt, yymsp[-3].minor.yy792, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 330: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ yylhsminor.yy792 = setStreamOptions(pCxt, yymsp[-2].minor.yy792, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 331: /* stream_options ::= stream_options DELETE_MARK duration_literal */
{ yylhsminor.yy792 = setStreamOptions(pCxt, yymsp[-2].minor.yy792, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy792)); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 332: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ yylhsminor.yy792 = setStreamOptions(pCxt, yymsp[-3].minor.yy792, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 334: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 523: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==523);
      case 543: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==543);
{ yymsp[-3].minor.yy792 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy792); }
        break;
      case 335: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 336: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 337: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 338: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 339: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 340: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy520); }
        break;
      case 341: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 342: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy520 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 344: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy792, yymsp[0].minor.yy792); }
        break;
      case 347: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy792 = createInsertStmt(pCxt, yymsp[-4].minor.yy792, yymsp[-2].minor.yy520, yymsp[0].minor.yy792); }
        break;
      case 348: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy792 = createInsertStmt(pCxt, yymsp[-1].minor.yy792, NULL, yymsp[0].minor.yy792); }
        break;
      case 349: /* literal ::= NK_INTEGER */
{ yylhsminor.yy792 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 350: /* literal ::= NK_FLOAT */
{ yylhsminor.yy792 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 351: /* literal ::= NK_STRING */
{ yylhsminor.yy792 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 352: /* literal ::= NK_BOOL */
{ yylhsminor.yy792 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 353: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 354: /* literal ::= duration_literal */
      case 364: /* signed_literal ::= signed */ yytestcase(yyruleno==364);
      case 385: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==385);
      case 386: /* expression ::= literal */ yytestcase(yyruleno==386);
      case 387: /* expression ::= pseudo_column */ yytestcase(yyruleno==387);
      case 388: /* expression ::= column_reference */ yytestcase(yyruleno==388);
      case 389: /* expression ::= function_expression */ yytestcase(yyruleno==389);
      case 390: /* expression ::= case_when_expression */ yytestcase(yyruleno==390);
      case 421: /* function_expression ::= literal_func */ yytestcase(yyruleno==421);
      case 470: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==470);
      case 474: /* boolean_primary ::= predicate */ yytestcase(yyruleno==474);
      case 476: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==476);
      case 477: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==477);
      case 480: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==480);
      case 482: /* table_reference ::= table_primary */ yytestcase(yyruleno==482);
      case 483: /* table_reference ::= joined_table */ yytestcase(yyruleno==483);
      case 487: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==487);
      case 545: /* query_simple ::= query_specification */ yytestcase(yyruleno==545);
      case 546: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==546);
      case 549: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==549);
      case 551: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==551);
{ yylhsminor.yy792 = yymsp[0].minor.yy792; }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 355: /* literal ::= NULL */
{ yylhsminor.yy792 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 356: /* literal ::= NK_QUESTION */
{ yylhsminor.yy792 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 357: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy792 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 358: /* signed ::= NK_INTEGER */
{ yylhsminor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 359: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 360: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 361: /* signed ::= NK_FLOAT */
{ yylhsminor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 362: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 363: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 365: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 366: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 367: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 368: /* signed_literal ::= duration_literal */
      case 370: /* signed_literal ::= literal_func */ yytestcase(yyruleno==370);
      case 441: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==441);
      case 503: /* select_item ::= common_expression */ yytestcase(yyruleno==503);
      case 513: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==513);
      case 550: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==550);
      case 552: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==552);
      case 565: /* search_condition ::= common_expression */ yytestcase(yyruleno==565);
{ yylhsminor.yy792 = releaseRawExprNode(pCxt, yymsp[0].minor.yy792); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 369: /* signed_literal ::= NULL */
{ yylhsminor.yy792 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 371: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy792 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 391: /* expression ::= NK_LP expression NK_RP */
      case 475: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==475);
      case 564: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==564);
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy792)); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 392: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy792));
                                                                                  }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 393: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy792), NULL));
                                                                                  }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 394: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792))); 
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 395: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792))); 
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 396: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792))); 
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 397: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792))); 
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 398: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792)));
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 399: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 400: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792)));
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 401: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792)));
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 404: /* column_reference ::= column_name */
{ yylhsminor.yy792 = createRawExprNode(pCxt, &yymsp[0].minor.yy97, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy97)); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 405: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy97, &yymsp[0].minor.yy97, createColumnNode(pCxt, &yymsp[-2].minor.yy97, &yymsp[0].minor.yy97)); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 406: /* pseudo_column ::= ROWTS */
      case 407: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==407);
      case 409: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==409);
      case 410: /* pseudo_column ::= QEND */ yytestcase(yyruleno==410);
      case 411: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==411);
      case 412: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==412);
      case 413: /* pseudo_column ::= WEND */ yytestcase(yyruleno==413);
      case 414: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==414);
      case 415: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==415);
      case 416: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==416);
      case 417: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==417);
      case 423: /* literal_func ::= NOW */ yytestcase(yyruleno==423);
{ yylhsminor.yy792 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 408: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy97, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy97)))); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 418: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 419: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==419);
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy97, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy97, yymsp[-1].minor.yy520)); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 420: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy792), yymsp[-1].minor.yy848)); }
  yymsp[-5].minor.yy792 = yylhsminor.yy792;
        break;
      case 422: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy97, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy97, NULL)); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 437: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy520 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 442: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 506: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==506);
{ yylhsminor.yy792 = createColumnNode(pCxt, &yymsp[-2].minor.yy97, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 443: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy520, yymsp[-1].minor.yy792)); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 444: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy792), yymsp[-2].minor.yy520, yymsp[-1].minor.yy792)); }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 447: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy792 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792)); }
        break;
      case 449: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy792 = releaseRawExprNode(pCxt, yymsp[0].minor.yy792); }
        break;
      case 450: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 455: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==455);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy396, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792)));
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 451: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy792), releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792)));
                                                                                  }
  yymsp[-4].minor.yy792 = yylhsminor.yy792;
        break;
      case 452: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy792), releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792)));
                                                                                  }
  yymsp[-5].minor.yy792 = yylhsminor.yy792;
        break;
      case 453: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), NULL));
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 454: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy792), NULL));
                                                                                  }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 456: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy396 = OP_TYPE_LOWER_THAN; }
        break;
      case 457: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy396 = OP_TYPE_GREATER_THAN; }
        break;
      case 458: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy396 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 459: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy396 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 460: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy396 = OP_TYPE_NOT_EQUAL; }
        break;
      case 461: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy396 = OP_TYPE_EQUAL; }
        break;
      case 462: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy396 = OP_TYPE_LIKE; }
        break;
      case 463: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy396 = OP_TYPE_NOT_LIKE; }
        break;
      case 464: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy396 = OP_TYPE_MATCH; }
        break;
      case 465: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy396 = OP_TYPE_NMATCH; }
        break;
      case 466: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy396 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 467: /* in_op ::= IN */
{ yymsp[0].minor.yy396 = OP_TYPE_IN; }
        break;
      case 468: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy396 = OP_TYPE_NOT_IN; }
        break;
      case 469: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy520)); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 471: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy792), NULL));
                                                                                  }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 472: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792)));
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 473: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy792);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy792);
                                                                                    yylhsminor.yy792 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), releaseRawExprNode(pCxt, yymsp[0].minor.yy792)));
                                                                                  }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 481: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy792 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy792, yymsp[0].minor.yy792, NULL); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 484: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy792 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy97, &yymsp[0].minor.yy97); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 485: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy792 = createRealTableNode(pCxt, &yymsp[-3].minor.yy97, &yymsp[-1].minor.yy97, &yymsp[0].minor.yy97); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 486: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy792 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy792), &yymsp[0].minor.yy97); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 488: /* alias_opt ::= */
{ yymsp[1].minor.yy97 = nil_token;  }
        break;
      case 490: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy97 = yymsp[0].minor.yy97; }
        break;
      case 491: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 492: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==492);
{ yymsp[-2].minor.yy792 = yymsp[-1].minor.yy792; }
        break;
      case 493: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy792 = createJoinTableNode(pCxt, yymsp[-4].minor.yy116, yymsp[-5].minor.yy792, yymsp[-2].minor.yy792, yymsp[0].minor.yy792); }
  yymsp[-5].minor.yy792 = yylhsminor.yy792;
        break;
      case 494: /* join_type ::= */
{ yymsp[1].minor.yy116 = JOIN_TYPE_INNER; }
        break;
      case 495: /* join_type ::= INNER */
{ yymsp[0].minor.yy116 = JOIN_TYPE_INNER; }
        break;
      case 496: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy792 = createSelectStmt(pCxt, yymsp[-10].minor.yy89, yymsp[-9].minor.yy520, yymsp[-8].minor.yy792);
                                                                                    yymsp[-11].minor.yy792 = addWhereClause(pCxt, yymsp[-11].minor.yy792, yymsp[-7].minor.yy792);
                                                                                    yymsp[-11].minor.yy792 = addPartitionByClause(pCxt, yymsp[-11].minor.yy792, yymsp[-6].minor.yy520);
                                                                                    yymsp[-11].minor.yy792 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy792, yymsp[-2].minor.yy792);
                                                                                    yymsp[-11].minor.yy792 = addGroupByClause(pCxt, yymsp[-11].minor.yy792, yymsp[-1].minor.yy520);
                                                                                    yymsp[-11].minor.yy792 = addHavingClause(pCxt, yymsp[-11].minor.yy792, yymsp[0].minor.yy792);
                                                                                    yymsp[-11].minor.yy792 = addRangeClause(pCxt, yymsp[-11].minor.yy792, yymsp[-5].minor.yy792);
                                                                                    yymsp[-11].minor.yy792 = addEveryClause(pCxt, yymsp[-11].minor.yy792, yymsp[-4].minor.yy792);
                                                                                    yymsp[-11].minor.yy792 = addFillClause(pCxt, yymsp[-11].minor.yy792, yymsp[-3].minor.yy792);
                                                                                  }
        break;
      case 499: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy89 = false; }
        break;
      case 502: /* select_item ::= NK_STAR */
{ yylhsminor.yy792 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy792 = yylhsminor.yy792;
        break;
      case 504: /* select_item ::= common_expression column_alias */
      case 514: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==514);
{ yylhsminor.yy792 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy792), &yymsp[0].minor.yy97); }
  yymsp[-1].minor.yy792 = yylhsminor.yy792;
        break;
      case 505: /* select_item ::= common_expression AS column_alias */
      case 515: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==515);
{ yylhsminor.yy792 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), &yymsp[0].minor.yy97); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 510: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 535: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==535);
      case 554: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==554);
{ yymsp[-2].minor.yy520 = yymsp[0].minor.yy520; }
        break;
      case 517: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy792 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy792), releaseRawExprNode(pCxt, yymsp[-1].minor.yy792)); }
        break;
      case 518: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy792 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy792)); }
        break;
      case 519: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy792 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy792), NULL, yymsp[-1].minor.yy792, yymsp[0].minor.yy792); }
        break;
      case 520: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy792 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy792), releaseRawExprNode(pCxt, yymsp[-3].minor.yy792), yymsp[-1].minor.yy792, yymsp[0].minor.yy792); }
        break;
      case 521: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy792 = createEventWindowNode(pCxt, yymsp[-3].minor.yy792, yymsp[0].minor.yy792); }
        break;
      case 525: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy792 = createFillNode(pCxt, yymsp[-1].minor.yy646, NULL); }
        break;
      case 526: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy792 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy520)); }
        break;
      case 527: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy792 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy520)); }
        break;
      case 528: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy646 = FILL_MODE_NONE; }
        break;
      case 529: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy646 = FILL_MODE_PREV; }
        break;
      case 530: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy646 = FILL_MODE_NULL; }
        break;
      case 531: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy646 = FILL_MODE_NULL_F; }
        break;
      case 532: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy646 = FILL_MODE_LINEAR; }
        break;
      case 533: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy646 = FILL_MODE_NEXT; }
        break;
      case 536: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy520 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy792))); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 537: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy520 = addNodeToList(pCxt, yymsp[-2].minor.yy520, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy792))); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 541: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy792 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy792), releaseRawExprNode(pCxt, yymsp[-1].minor.yy792)); }
        break;
      case 544: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy792 = addOrderByClause(pCxt, yymsp[-3].minor.yy792, yymsp[-2].minor.yy520);
                                                                                    yylhsminor.yy792 = addSlimitClause(pCxt, yylhsminor.yy792, yymsp[-1].minor.yy792);
                                                                                    yylhsminor.yy792 = addLimitClause(pCxt, yylhsminor.yy792, yymsp[0].minor.yy792);
                                                                                  }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 547: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy792 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy792, yymsp[0].minor.yy792); }
  yymsp[-3].minor.yy792 = yylhsminor.yy792;
        break;
      case 548: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy792 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy792, yymsp[0].minor.yy792); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 556: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 560: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==560);
{ yymsp[-1].minor.yy792 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 557: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 561: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==561);
{ yymsp[-3].minor.yy792 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 558: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 562: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==562);
{ yymsp[-3].minor.yy792 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 563: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy792 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy792); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 568: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy792 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy792), yymsp[-1].minor.yy34, yymsp[0].minor.yy265); }
  yymsp[-2].minor.yy792 = yylhsminor.yy792;
        break;
      case 569: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy34 = ORDER_ASC; }
        break;
      case 570: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy34 = ORDER_ASC; }
        break;
      case 571: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy34 = ORDER_DESC; }
        break;
      case 572: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy265 = NULL_ORDER_DEFAULT; }
        break;
      case 573: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy265 = NULL_ORDER_FIRST; }
        break;
      case 574: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy265 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
