###################################################################
#           Copyright (c) 2016 by TAOS Technologies, Inc.
#                     All rights reserved.
#
#  This file is proprietary and confidential to TAOS Technologies.
#  No part of this file may be reproduced, stored, transmitted,
#  disclosed or used in any form or by any means other than as
#  expressly provided by the written permission from Jianhui Tao
#
###################################################################

# -*- coding: utf-8 -*-

import sys
import taos
from util.log import *
from util.cases import *
from util.sql import *
import numpy as np
import random


class TDTestCase:
    def init(self, conn, logSql):
        tdLog.debug("start to execute %s" % __file__)
        tdSql.init(conn.cursor())

    def randomInt(self):
        return random.randint(-2147483647, 2147483647)

    def randomUInt(self):
        return random.randint(0, 4294967294)

    def randomBigint(self):
        return random.randint(-2**63 + 1, 2**63 - 1)

    def randomUBigint(self):
        return random.randint(0, 18446744073709551614)

    def randomDouble(self):
        return random.random()

    def randomNchar(self):
        return random.choice('abcdefghijklmnopqrstuvwxyz')

    def randomSmallint(self):
        return random.randint(-32767, 32767)

    def randomUSmallint(self):
        return random.randint(0, 65534)

    def randomTinyint(self):
        return random.randint(-127, 127)

    def randomUTinyint(self):
        return random.randint(0, 254)

    def run(self):
        select_command = [
            "round(ts)",
            "round(timestamp_col)",
            "round(int_col)",
            "round(bigint_col)",
            "round(float_col)",
            "round(double_col)",
            "round(binary_col)",
            "round(smallint_col)",
            "round(tinyint_col)",
            "round(bool_col)",
            "round(nchar_col)",
            "round(uint_col)",
            "round(ubigint_col)",
            "round(usmallint_col)",
            "round(utinyint_col)",
            "round(timestamp_tag)",
            "round(int_tag)",
            "round(bigint_tag)",
            "round(float_tag)",
            "round(double_tag)",
            "round(binary_tag)",
            "round(smallint_tag)",
            "round(tinyint_tag)",
            "round(bool_tag)",
            "round(nchar_tag)",
            "round(uint_tag)",
            "round(ubigint_tag)",
            "round(usmallint_tag)",
            "round(utinyint_tag)",
            "count(round(int_col))",
            "count(round(bigint_col))",
            "count(round(float_col))",
            "count(round(double_col))",
            "count(round(smallint_col))",
            "count(round(tinyint_col))",
            "count(round(uint_col))",
            "count(round(ubigint_col))",
            "count(round(usmallint_col))",
            "count(round(utinyint_col))",
            "avg(round(int_col))",
            "avg(round(bigint_col))",
            "avg(round(float_col))",
            "avg(round(double_col))",
            "avg(round(smallint_col))",
            "avg(round(tinyint_col))",
            "avg(round(uint_col))",
            "avg(round(ubigint_col))",
            "avg(round(usmallint_col))",
            "avg(round(utinyint_col))",
            "twa(round(int_col))",
            "twa(round(bigint_col))",
            "twa(round(float_col))",
            "twa(round(double_col))",
            "twa(round(smallint_col))",
            "twa(round(tinyint_col))",
            "twa(round(uint_col))",
            "twa(round(ubigint_col))",
            "twa(round(usmallint_col))",
            "twa(round(utinyint_col))",
            "sum(round(int_col))",
            "sum(round(bigint_col))",
            "sum(round(float_col))",
            "sum(round(double_col))",
            "sum(round(smallint_col))",
            "sum(round(tinyint_col))",
            "sum(round(uint_col))",
            "sum(round(ubigint_col))",
            "sum(round(usmallint_col))",
            "sum(round(utinyint_col))",
            "stddev(round(int_col))",
            "stddev(round(bigint_col))",
            "stddev(round(float_col))",
            "stddev(round(double_col))",
            "stddev(round(smallint_col))",
            "stddev(round(tinyint_col))",
            "stddev(round(uint_col))",
            "stddev(round(ubigint_col))",
            "stddev(round(usmallint_col))",
            "stddev(round(utinyint_col))",
            "irate(round(int_col))",
            "irate(round(bigint_col))",
            "irate(round(float_col))",
            "irate(round(double_col))",
            "irate(round(smallint_col))",
            "irate(round(tinyint_col))",
            "irate(round(uint_col))",
            "irate(round(ubigint_col))",
            "irate(round(usmallint_col))",
            "irate(round(utinyint_col))",
            "leastsquares(round(int_col), 1, 1)",
            "leastsquares(round(bigint_col), 1, 1)",
            "leastsquares(round(float_col), 1, 1)",
            "leastsquares(round(double_col), 1, 1)",
            "leastsquares(round(smallint_col), 1, 1)",
            "leastsquares(round(tinyint_col), 1, 1)",
            "leastsquares(round(uint_col), 1, 1)",
            "leastsquares(round(ubigint_col), 1, 1)",
            "leastsquares(round(usmallint_col), 1, 1)",
            "leastsquares(round(utinyint_col), 1, 1)",
            "min(round(int_col))",
            "min(round(bigint_col))",
            "min(round(float_col))",
            "min(round(double_col))",
            "min(round(smallint_col))",
            "min(round(tinyint_col))",
            "min(round(uint_col))",
            "min(round(ubigint_col))",
            "min(round(usmallint_col))",
            "min(round(utinyint_col))",
            "max(round(int_col))",
            "max(round(bigint_col))",
            "max(round(float_col))",
            "max(round(double_col))",
            "max(round(smallint_col))",
            "max(round(tinyint_col))",
            "max(round(uint_col))",
            "max(round(ubigint_col))",
            "max(round(usmallint_col))",
            "max(round(utinyint_col))",
            "first(round(int_col))",
            "first(round(bigint_col))",
            "first(round(float_col))",
            "first(round(double_col))",
            "first(round(smallint_col))",
            "first(round(tinyint_col))",
            "first(round(uint_col))",
            "first(round(ubigint_col))",
            "first(round(usmallint_col))",
            "first(round(utinyint_col))",
            "last(round(int_col))",
            "last(round(bigint_col))",
            "last(round(float_col))",
            "last(round(double_col))",
            "last(round(smallint_col))",
            "last(round(tinyint_col))",
            "last(round(uint_col))",
            "last(round(ubigint_col))",
            "last(round(usmallint_col))",
            "last(round(utinyint_col))",
            "top(round(int_col), 1)",
            "top(round(bigint_col), 1)",
            "top(round(float_col), 1)",
            "top(round(double_col), 1)",
            "top(round(smallint_col), 1)",
            "top(round(tinyint_col), 1)",
            "top(round(uint_col), 1)",
            "top(round(ubigint_col), 1)",
            "top(round(usmallint_col), 1)",
            "top(round(utinyint_col), 1)",
            "bottom(round(int_col), 1)",
            "bottom(round(bigint_col), 1)",
            "bottom(round(float_col), 1)",
            "bottom(round(double_col), 1)",
            "bottom(round(smallint_col), 1)",
            "bottom(round(tinyint_col), 1)",
            "bottom(round(uint_col), 1)",
            "bottom(round(ubigint_col), 1)",
            "bottom(round(usmallint_col), 1)",
            "bottom(round(utinyint_col), 1)",
            "percentile(round(int_col), 20)",
            "percentile(round(bigint_col), 20)",
            "percentile(round(float_col), 20)",
            "percentile(round(double_col), 20)",
            "percentile(round(smallint_col), 20)",
            "percentile(round(tinyint_col), 20)",
            "percentile(round(uint_col), 20)",
            "percentile(round(ubigint_col), 20)",
            "percentile(round(usmallint_col), 20)",
            "percentile(round(utinyint_col), 20)",
            "apercentile(round(int_col), 20)",
            "apercentile(round(bigint_col), 20)",
            "apercentile(round(float_col), 20)",
            "apercentile(round(double_col), 20)",
            "apercentile(round(smallint_col), 20)",
            "apercentile(round(tinyint_col), 20)",
            "apercentile(round(uint_col), 20)",
            "apercentile(round(ubigint_col), 20)",
            "apercentile(round(usmallint_col), 20)",
            "apercentile(round(utinyint_col), 20)",
            "last_row(round(int_col))",
            "last_row(round(bigint_col))",
            "last_row(round(float_col))",
            "last_row(round(double_col))",
            "last_row(round(smallint_col))",
            "last_row(round(tinyint_col))",
            "last_row(round(uint_col))",
            "last_row(round(ubigint_col))",
            "last_row(round(usmallint_col))",
            "last_row(round(utinyint_col))",
            "interp(round(int_col))",
            "interp(round(bigint_col))",
            "interp(round(float_col))",
            "interp(round(double_col))",
            "interp(round(smallint_col))",
            "interp(round(tinyint_col))",
            "interp(round(uint_col))",
            "interp(round(ubigint_col))",
            "interp(round(usmallint_col))",
            "interp(round(utinyint_col))",
            "diff(round(int_col))",
            "diff(round(bigint_col))",
            "diff(round(float_col))",
            "diff(round(double_col))",
            "diff(round(smallint_col))",
            "diff(round(tinyint_col))",
            "diff(round(uint_col))",
            "diff(round(ubigint_col))",
            "diff(round(usmallint_col))",
            "diff(round(utinyint_col))",
            "spread(round(int_col))",
            "spread(round(bigint_col))",
            "spread(round(float_col))",
            "spread(round(double_col))",
            "spread(round(smallint_col))",
            "spread(round(tinyint_col))",
            "spread(round(uint_col))",
            "spread(round(ubigint_col))",
            "spread(round(usmallint_col))",
            "spread(round(utinyint_col))",
            "derivative(round(int_col), 1s, 0)",
            "derivative(round(bigint_col), 1s, 0)",
            "derivative(round(float_col), 1s, 0)",
            "derivative(round(double_col), 1s, 0)",
            "derivative(round(smallint_col), 1s, 0)",
            "derivative(round(tinyint_col), 1s, 0)",
            "derivative(round(uint_col), 1s, 0)",
            "derivative(round(ubigint_col), 1s, 0)",
            "derivative(round(usmallint_col), 1s, 0)",
            "derivative(round(utinyint_col), 1s, 0)",
            "round(int_col) - round(int_col)",
            "round(bigint_col) - round(bigint_col)",
            "round(float_col) - round(float_col)",
            "round(double_col) - round(double_col)",
            "round(smallint_col) - round(smallint_col)",
            "round(tinyint_col) - round(tinyint_col)",
            "round(uint_col) - round(uint_col)",
            "round(ubigint_col) - round(ubigint_col)",
            "round(usmallint_col) - round(usmallint_col)",
            "round(utinyint_col) - round(utinyint_col)",
            "round(int_col) / round(int_col)",
            "round(bigint_col) / round(bigint_col)",
            "round(float_col) / round(float_col)",
            "round(double_col) / round(double_col)",
            "round(smallint_col) / round(smallint_col)",
            "round(tinyint_col) / round(tinyint_col)",
            "round(uint_col) / round(uint_col)",
            "round(ubigint_col) / round(ubigint_col)",
            "round(usmallint_col) / round(usmallint_col)",
            "round(utinyint_col) / round(utinyint_col)",
            "round(int_col) * round(int_col)",
            "round(bigint_col) * round(bigint_col)",
            "round(float_col) * round(float_col)",
            "round(double_col) * round(double_col)",
            "round(smallint_col) * round(smallint_col)",
            "round(tinyint_col) * round(tinyint_col)",
            "round(uint_col) * round(uint_col)",
            "round(ubigint_col) * round(ubigint_col)",
            "round(usmallint_col) * round(usmallint_col)",
            "round(utinyint_col) * round(utinyint_col)",
            "round(count(ts))",
            "round(count(timestamp_col))",
            "round(count(int_col))",
            "round(count(bigint_col))",
            "round(count(float_col))",
            "round(count(double_col))",
            "round(count(binary_col))",
            "round(count(smallint_col))",
            "round(count(tinyint_col))",
            "round(count(bool_col))",
            "round(count(nchar_col))",
            "round(count(uint_col))",
            "round(count(ubigint_col))",
            "round(count(usmallint_col))",
            "round(count(utinyint_col))",
            "round(count(timestamp_tag))",
            "round(count(int_tag))",
            "round(count(bigint_tag))",
            "round(count(float_tag))",
            "round(count(double_tag))",
            "round(count(binary_tag))",
            "round(count(smallint_tag))",
            "round(count(tinyint_tag))",
            "round(count(bool_tag))",
            "round(count(nchar_tag))",
            "round(count(uint_tag))",
            "round(count(ubigint_tag))",
            "round(count(usmallint_tag))",
            "round(count(utinyint_tag))",
            "round(avg(ts))",
            "round(avg(timestamp_col))",
            "round(avg(int_col))",
            "round(avg(bigint_col))",
            "round(avg(float_col))",
            "round(avg(double_col))",
            "round(avg(binary_col))",
            "round(avg(smallint_col))",
            "round(avg(tinyint_col))",
            "round(avg(bool_col))",
            "round(avg(nchar_col))",
            "round(avg(uint_col))",
            "round(avg(ubigint_col))",
            "round(avg(usmallint_col))",
            "round(avg(utinyint_col))",
            "round(avg(timestamp_tag))",
            "round(avg(int_tag))",
            "round(avg(bigint_tag))",
            "round(avg(float_tag))",
            "round(avg(double_tag))",
            "round(avg(binary_tag))",
            "round(avg(smallint_tag))",
            "round(avg(tinyint_tag))",
            "round(avg(bool_tag))",
            "round(avg(nchar_tag))",
            "round(avg(uint_tag))",
            "round(avg(ubigint_tag))",
            "round(avg(usmallint_tag))",
            "round(avg(utinyint_tag))",
            "round(twa(ts))",
            "round(twa(timestamp_col))",
            "round(twa(int_col))",
            "round(twa(bigint_col))",
            "round(twa(float_col))",
            "round(twa(double_col))",
            "round(twa(binary_col))",
            "round(twa(smallint_col))",
            "round(twa(tinyint_col))",
            "round(twa(bool_col))",
            "round(twa(nchar_col))",
            "round(twa(uint_col))",
            "round(twa(ubigint_col))",
            "round(twa(usmallint_col))",
            "round(twa(utinyint_col))",
            "round(twa(timestamp_tag))",
            "round(twa(int_tag))",
            "round(twa(bigint_tag))",
            "round(twa(float_tag))",
            "round(twa(double_tag))",
            "round(twa(binary_tag))",
            "round(twa(smallint_tag))",
            "round(twa(tinyint_tag))",
            "round(twa(bool_tag))",
            "round(twa(nchar_tag))",
            "round(twa(uint_tag))",
            "round(twa(ubigint_tag))",
            "round(twa(usmallint_tag))",
            "round(twa(utinyint_tag))",
            "round(sum(ts))",
            "round(sum(timestamp_col))",
            "round(sum(int_col))",
            "round(sum(bigint_col))",
            "round(sum(float_col))",
            "round(sum(double_col))",
            "round(sum(binary_col))",
            "round(sum(smallint_col))",
            "round(sum(tinyint_col))",
            "round(sum(bool_col))",
            "round(sum(nchar_col))",
            "round(sum(uint_col))",
            "round(sum(ubigint_col))",
            "round(sum(usmallint_col))",
            "round(sum(utinyint_col))",
            "round(sum(timestamp_tag))",
            "round(sum(int_tag))",
            "round(sum(bigint_tag))",
            "round(sum(float_tag))",
            "round(sum(double_tag))",
            "round(sum(binary_tag))",
            "round(sum(smallint_tag))",
            "round(sum(tinyint_tag))",
            "round(sum(bool_tag))",
            "round(sum(nchar_tag))",
            "round(sum(uint_tag))",
            "round(sum(ubigint_tag))",
            "round(sum(usmallint_tag))",
            "round(sum(utinyint_tag))",
            "round(stddev(ts))",
            "round(stddev(timestamp_col))",
            "round(stddev(int_col))",
            "round(stddev(bigint_col))",
            "round(stddev(float_col))",
            "round(stddev(double_col))",
            "round(stddev(binary_col))",
            "round(stddev(smallint_col))",
            "round(stddev(tinyint_col))",
            "round(stddev(bool_col))",
            "round(stddev(nchar_col))",
            "round(stddev(uint_col))",
            "round(stddev(ubigint_col))",
            "round(stddev(usmallint_col))",
            "round(stddev(utinyint_col))",
            "round(stddev(timestamp_tag))",
            "round(stddev(int_tag))",
            "round(stddev(bigint_tag))",
            "round(stddev(float_tag))",
            "round(stddev(double_tag))",
            "round(stddev(binary_tag))",
            "round(stddev(smallint_tag))",
            "round(stddev(tinyint_tag))",
            "round(stddev(bool_tag))",
            "round(stddev(nchar_tag))",
            "round(stddev(uint_tag))",
            "round(stddev(ubigint_tag))",
            "round(stddev(usmallint_tag))",
            "round(stddev(utinyint_tag))",
            "round(leastsquares(ts, 1, 1))",
            "round(leastsquares(timestamp_col, 1, 1))",
            "round(leastsquares(int_col, 1, 1))",
            "round(leastsquares(bigint_col, 1, 1))",
            "round(leastsquares(float_col, 1, 1))",
            "round(leastsquares(double_col, 1, 1))",
            "round(leastsquares(binary_col, 1, 1))",
            "round(leastsquares(smallint_col, 1, 1))",
            "round(leastsquares(tinyint_col, 1, 1))",
            "round(leastsquares(bool_col, 1, 1))",
            "round(leastsquares(nchar_col, 1, 1))",
            "round(leastsquares(uint_col, 1, 1))",
            "round(leastsquares(ubigint_col, 1, 1))",
            "round(leastsquares(usmallint_col, 1, 1))",
            "round(leastsquares(utinyint_col, 1, 1))",
            "round(leastsquares(timestamp_tag, 1, 1))",
            "round(leastsquares(int_tag, 1, 1))",
            "round(leastsquares(bigint_tag, 1, 1))",
            "round(leastsquares(float_tag, 1, 1))",
            "round(leastsquares(double_tag, 1, 1))",
            "round(leastsquares(binary_tag, 1, 1))",
            "round(leastsquares(smallint_tag, 1, 1))",
            "round(leastsquares(tinyint_tag, 1, 1))",
            "round(leastsquares(bool_tag, 1, 1))",
            "round(leastsquares(nchar_tag, 1, 1))",
            "round(leastsquares(uint_tag, 1, 1))",
            "round(leastsquares(ubigint_tag, 1, 1))",
            "round(leastsquares(usmallint_tag, 1, 1))",
            "round(leastsquares(utinyint_tag, 1, 1))",
            "round(irate(ts))",
            "round(irate(timestamp_col))",
            "round(irate(int_col))",
            "round(irate(bigint_col))",
            "round(irate(float_col))",
            "round(irate(double_col))",
            "round(irate(binary_col))",
            "round(irate(smallint_col))",
            "round(irate(tinyint_col))",
            "round(irate(bool_col))",
            "round(irate(nchar_col))",
            "round(irate(uint_col))",
            "round(irate(ubigint_col))",
            "round(irate(usmallint_col))",
            "round(irate(utinyint_col))",
            "round(irate(timestamp_tag))",
            "round(irate(int_tag))",
            "round(irate(bigint_tag))",
            "round(irate(float_tag))",
            "round(irate(double_tag))",
            "round(irate(binary_tag))",
            "round(irate(smallint_tag))",
            "round(irate(tinyint_tag))",
            "round(irate(bool_tag))",
            "round(irate(nchar_tag))",
            "round(irate(uint_tag))",
            "round(irate(ubigint_tag))",
            "round(irate(usmallint_tag))",
            "round(irate(utinyint_tag))",
            "round(min(ts))",
            "round(min(timestamp_col))",
            "round(min(int_col))",
            "round(min(bigint_col))",
            "round(min(float_col))",
            "round(min(double_col))",
            "round(min(binary_col))",
            "round(min(smallint_col))",
            "round(min(tinyint_col))",
            "round(min(bool_col))",
            "round(min(nchar_col))",
            "round(min(uint_col))",
            "round(min(ubigint_col))",
            "round(min(usmallint_col))",
            "round(min(utinyint_col))",
            "round(min(timestamp_tag))",
            "round(min(int_tag))",
            "round(min(bigint_tag))",
            "round(min(float_tag))",
            "round(min(double_tag))",
            "round(min(binary_tag))",
            "round(min(smallint_tag))",
            "round(min(tinyint_tag))",
            "round(min(bool_tag))",
            "round(min(nchar_tag))",
            "round(min(uint_tag))",
            "round(min(ubigint_tag))",
            "round(min(usmallint_tag))",
            "round(min(utinyint_tag))",
            "round(max(ts))",
            "round(max(timestamp_col))",
            "round(max(int_col))",
            "round(max(bigint_col))",
            "round(max(float_col))",
            "round(max(double_col))",
            "round(max(binary_col))",
            "round(max(smallint_col))",
            "round(max(tinyint_col))",
            "round(max(bool_col))",
            "round(max(nchar_col))",
            "round(max(uint_col))",
            "round(max(ubigint_col))",
            "round(max(usmallint_col))",
            "round(max(utinyint_col))",
            "round(max(timestamp_tag))",
            "round(max(int_tag))",
            "round(max(bigint_tag))",
            "round(max(float_tag))",
            "round(max(double_tag))",
            "round(max(binary_tag))",
            "round(max(smallint_tag))",
            "round(max(tinyint_tag))",
            "round(max(bool_tag))",
            "round(max(nchar_tag))",
            "round(max(uint_tag))",
            "round(max(ubigint_tag))",
            "round(max(usmallint_tag))",
            "round(max(utinyint_tag))",
            "round(first(ts))",
            "round(first(timestamp_col))",
            "round(first(int_col))",
            "round(first(bigint_col))",
            "round(first(float_col))",
            "round(first(double_col))",
            "round(first(binary_col))",
            "round(first(smallint_col))",
            "round(first(tinyint_col))",
            "round(first(bool_col))",
            "round(first(nchar_col))",
            "round(first(uint_col))",
            "round(first(ubigint_col))",
            "round(first(usmallint_col))",
            "round(first(utinyint_col))",
            "round(first(timestamp_tag))",
            "round(first(int_tag))",
            "round(first(bigint_tag))",
            "round(first(float_tag))",
            "round(first(double_tag))",
            "round(first(binary_tag))",
            "round(first(smallint_tag))",
            "round(first(tinyint_tag))",
            "round(first(bool_tag))",
            "round(first(nchar_tag))",
            "round(first(uint_tag))",
            "round(first(ubigint_tag))",
            "round(first(usmallint_tag))",
            "round(first(utinyint_tag))",
            "round(last(ts))",
            "round(last(timestamp_col))",
            "round(last(int_col))",
            "round(last(bigint_col))",
            "round(last(float_col))",
            "round(last(double_col))",
            "round(last(binary_col))",
            "round(last(smallint_col))",
            "round(last(tinyint_col))",
            "round(last(bool_col))",
            "round(last(nchar_col))",
            "round(last(uint_col))",
            "round(last(ubigint_col))",
            "round(last(usmallint_col))",
            "round(last(utinyint_col))",
            "round(last(timestamp_tag))",
            "round(last(int_tag))",
            "round(last(bigint_tag))",
            "round(last(float_tag))",
            "round(last(double_tag))",
            "round(last(binary_tag))",
            "round(last(smallint_tag))",
            "round(last(tinyint_tag))",
            "round(last(bool_tag))",
            "round(last(nchar_tag))",
            "round(last(uint_tag))",
            "round(last(ubigint_tag))",
            "round(last(usmallint_tag))",
            "round(last(utinyint_tag))",
            "round(top(ts, 1))",
            "round(top(timestamp_col, 1))",
            "round(top(int_col, 1))",
            "round(top(bigint_col, 1))",
            "round(top(float_col, 1))",
            "round(top(double_col, 1))",
            "round(top(binary_col, 1))",
            "round(top(smallint_col, 1))",
            "round(top(tinyint_col, 1))",
            "round(top(bool_col, 1))",
            "round(top(nchar_col, 1))",
            "round(top(uint_col, 1))",
            "round(top(ubigint_col, 1))",
            "round(top(usmallint_col, 1))",
            "round(top(utinyint_col, 1))",
            "round(top(timestamp_tag, 1))",
            "round(top(int_tag, 1))",
            "round(top(bigint_tag, 1))",
            "round(top(float_tag, 1))",
            "round(top(double_tag, 1))",
            "round(top(binary_tag, 1))",
            "round(top(smallint_tag, 1))",
            "round(top(tinyint_tag, 1))",
            "round(top(bool_tag, 1))",
            "round(top(nchar_tag, 1))",
            "round(top(uint_tag, 1))",
            "round(top(ubigint_tag, 1))",
            "round(top(usmallint_tag, 1))",
            "round(top(utinyint_tag, 1))",
            "round(bottom(ts, 1))",
            "round(bottom(timestamp_col, 1))",
            "round(bottom(int_col, 1))",
            "round(bottom(bigint_col, 1))",
            "round(bottom(float_col, 1))",
            "round(bottom(double_col, 1))",
            "round(bottom(binary_col, 1))",
            "round(bottom(smallint_col, 1))",
            "round(bottom(tinyint_col, 1))",
            "round(bottom(bool_col, 1))",
            "round(bottom(nchar_col, 1))",
            "round(bottom(uint_col, 1))",
            "round(bottom(ubigint_col, 1))",
            "round(bottom(usmallint_col, 1))",
            "round(bottom(utinyint_col, 1))",
            "round(bottom(timestamp_tag, 1))",
            "round(bottom(int_tag, 1))",
            "round(bottom(bigint_tag, 1))",
            "round(bottom(float_tag, 1))",
            "round(bottom(double_tag, 1))",
            "round(bottom(binary_tag, 1))",
            "round(bottom(smallint_tag, 1))",
            "round(bottom(tinyint_tag, 1))",
            "round(bottom(bool_tag, 1))",
            "round(bottom(nchar_tag, 1))",
            "round(bottom(uint_tag, 1))",
            "round(bottom(ubigint_tag, 1))",
            "round(bottom(usmallint_tag, 1))",
            "round(bottom(utinyint_tag, 1))",
            "round(percentile(ts, 1))",
            "round(percentile(timestamp_col, 1))",
            "round(percentile(int_col, 1))",
            "round(percentile(bigint_col, 1))",
            "round(percentile(float_col, 1))",
            "round(percentile(double_col, 1))",
            "round(percentile(binary_col, 1))",
            "round(percentile(smallint_col, 1))",
            "round(percentile(tinyint_col, 1))",
            "round(percentile(bool_col, 1))",
            "round(percentile(nchar_col, 1))",
            "round(percentile(uint_col, 1))",
            "round(percentile(ubigint_col, 1))",
            "round(percentile(usmallint_col, 1))",
            "round(percentile(utinyint_col, 1))",
            "round(percentile(timestamp_tag, 1))",
            "round(percentile(int_tag, 1))",
            "round(percentile(bigint_tag, 1))",
            "round(percentile(float_tag, 1))",
            "round(percentile(double_tag, 1))",
            "round(percentile(binary_tag, 1))",
            "round(percentile(smallint_tag, 1))",
            "round(percentile(tinyint_tag, 1))",
            "round(percentile(bool_tag, 1))",
            "round(percentile(nchar_tag, 1))",
            "round(percentile(uint_tag, 1))",
            "round(percentile(ubigint_tag, 1))",
            "round(percentile(usmallint_tag, 1))",
            "round(percentile(utinyint_tag, 1))",
            "round(apercentile(ts, 1))",
            "round(apercentile(timestamp_col, 1))",
            "round(apercentile(int_col, 1))",
            "round(apercentile(bigint_col, 1))",
            "round(apercentile(float_col, 1))",
            "round(apercentile(double_col, 1))",
            "round(apercentile(binary_col, 1))",
            "round(apercentile(smallint_col, 1))",
            "round(apercentile(tinyint_col, 1))",
            "round(apercentile(bool_col, 1))",
            "round(apercentile(nchar_col, 1))",
            "round(apercentile(uint_col, 1))",
            "round(apercentile(ubigint_col, 1))",
            "round(apercentile(usmallint_col, 1))",
            "round(apercentile(utinyint_col, 1))",
            "round(apercentile(timestamp_tag, 1))",
            "round(apercentile(int_tag, 1))",
            "round(apercentile(bigint_tag, 1))",
            "round(apercentile(float_tag, 1))",
            "round(apercentile(double_tag, 1))",
            "round(apercentile(binary_tag, 1))",
            "round(apercentile(smallint_tag, 1))",
            "round(apercentile(tinyint_tag, 1))",
            "round(apercentile(bool_tag, 1))",
            "round(apercentile(nchar_tag, 1))",
            "round(apercentile(uint_tag, 1))",
            "round(apercentile(ubigint_tag, 1))",
            "round(apercentile(usmallint_tag, 1))",
            "round(apercentile(utinyint_tag, 1))",
            "round(last_row(ts))",
            "round(last_row(timestamp_col))",
            "round(last_row(int_col))",
            "round(last_row(bigint_col))",
            "round(last_row(float_col))",
            "round(last_row(double_col))",
            "round(last_row(binary_col))",
            "round(last_row(smallint_col))",
            "round(last_row(tinyint_col))",
            "round(last_row(bool_col))",
            "round(last_row(nchar_col))",
            "round(last_row(uint_col))",
            "round(last_row(ubigint_col))",
            "round(last_row(usmallint_col))",
            "round(last_row(utinyint_col))",
            "round(last_row(timestamp_tag))",
            "round(last_row(int_tag))",
            "round(last_row(bigint_tag))",
            "round(last_row(float_tag))",
            "round(last_row(double_tag))",
            "round(last_row(binary_tag))",
            "round(last_row(smallint_tag))",
            "round(last_row(tinyint_tag))",
            "round(last_row(bool_tag))",
            "round(last_row(nchar_tag))",
            "round(last_row(uint_tag))",
            "round(last_row(ubigint_tag))",
            "round(last_row(usmallint_tag))",
            "round(last_row(utinyint_tag))",
            "round(interp(ts))",
            "round(interp(timestamp_col))",
            "round(interp(int_col))",
            "round(interp(bigint_col))",
            "round(interp(float_col))",
            "round(interp(double_col))",
            "round(interp(binary_col))",
            "round(interp(smallint_col))",
            "round(interp(tinyint_col))",
            "round(interp(bool_col))",
            "round(interp(nchar_col))",
            "round(interp(uint_col))",
            "round(interp(ubigint_col))",
            "round(interp(usmallint_col))",
            "round(interp(utinyint_col))",
            "round(interp(timestamp_tag))",
            "round(interp(int_tag))",
            "round(interp(bigint_tag))",
            "round(interp(float_tag))",
            "round(interp(double_tag))",
            "round(interp(binary_tag))",
            "round(interp(smallint_tag))",
            "round(interp(tinyint_tag))",
            "round(interp(bool_tag))",
            "round(interp(nchar_tag))",
            "round(interp(uint_tag))",
            "round(interp(ubigint_tag))",
            "round(interp(usmallint_tag))",
            "round(interp(utinyint_tag))",
            "round(diff(ts))",
            "round(diff(timestamp_col))",
            "round(diff(int_col))",
            "round(diff(bigint_col))",
            "round(diff(float_col))",
            "round(diff(double_col))",
            "round(diff(binary_col))",
            "round(diff(smallint_col))",
            "round(diff(tinyint_col))",
            "round(diff(bool_col))",
            "round(diff(nchar_col))",
            "round(diff(uint_col))",
            "round(diff(ubigint_col))",
            "round(diff(usmallint_col))",
            "round(diff(utinyint_col))",
            "round(diff(timestamp_tag))",
            "round(diff(int_tag))",
            "round(diff(bigint_tag))",
            "round(diff(float_tag))",
            "round(diff(double_tag))",
            "round(diff(binary_tag))",
            "round(diff(smallint_tag))",
            "round(diff(tinyint_tag))",
            "round(diff(bool_tag))",
            "round(diff(nchar_tag))",
            "round(diff(uint_tag))",
            "round(diff(ubigint_tag))",
            "round(diff(usmallint_tag))",
            "round(diff(utinyint_tag))",
            "round(spread(ts))",
            "round(spread(timestamp_col))",
            "round(spread(int_col))",
            "round(spread(bigint_col))",
            "round(spread(float_col))",
            "round(spread(double_col))",
            "round(spread(binary_col))",
            "round(spread(smallint_col))",
            "round(spread(tinyint_col))",
            "round(spread(bool_col))",
            "round(spread(nchar_col))",
            "round(spread(uint_col))",
            "round(spread(ubigint_col))",
            "round(spread(usmallint_col))",
            "round(spread(utinyint_col))",
            "round(spread(timestamp_tag))",
            "round(spread(int_tag))",
            "round(spread(bigint_tag))",
            "round(spread(float_tag))",
            "round(spread(double_tag))",
            "round(spread(binary_tag))",
            "round(spread(smallint_tag))",
            "round(spread(tinyint_tag))",
            "round(spread(bool_tag))",
            "round(spread(nchar_tag))",
            "round(spread(uint_tag))",
            "round(spread(ubigint_tag))",
            "round(spread(usmallint_tag))",
            "round(spread(utinyint_tag))",
            "round(derivative(ts, 1s, 0))",
            "round(derivative(timestamp_col, 1s, 0))",
            "round(derivative(int_col, 1s, 0))",
            "round(derivative(bigint_col, 1s, 0))",
            "round(derivative(float_col, 1s, 0))",
            "round(derivative(double_col, 1s, 0))",
            "round(derivative(binary_col, 1s, 0))",
            "round(derivative(smallint_col, 1s, 0))",
            "round(derivative(tinyint_col, 1s, 0))",
            "round(derivative(bool_col, 1s, 0))",
            "round(derivative(nchar_col, 1s, 0))",
            "round(derivative(uint_col, 1s, 0))",
            "round(derivative(ubigint_col, 1s, 0))",
            "round(derivative(usmallint_col, 1s, 0))",
            "round(derivative(utinyint_col, 1s, 0))",
            "round(derivative(timestamp_tag, 1s, 0))",
            "round(derivative(int_tag, 1s, 0))",
            "round(derivative(bigint_tag, 1s, 0))",
            "round(derivative(float_tag, 1s, 0))",
            "round(derivative(double_tag, 1s, 0))",
            "round(derivative(binary_tag, 1s, 0))",
            "round(derivative(smallint_tag, 1s, 0))",
            "round(derivative(tinyint_tag, 1s, 0))",
            "round(derivative(bool_tag, 1s, 0))",
            "round(derivative(nchar_tag, 1s, 0))",
            "round(derivative(uint_tag, 1s, 0))",
            "round(derivative(ubigint_tag, 1s, 0))",
            "round(derivative(usmallint_tag, 1s, 0))",
            "round(derivative(utinyint_tag, 1s, 0))",
            "round(ts + ts)",
            "round(timestamp_col + timestamp_col)",
            "round(int_col + int_col)",
            "round(bigint_col + bigint_col)",
            "round(float_col + float_col)",
            "round(double_col + double_col)",
            "round(binary_col + binary_col)",
            "round(smallint_col + smallint_col)",
            "round(tinyint_col + tinyint_col)",
            "round(bool_col + bool_col)",
            "round(nchar_col + nchar_col)",
            "round(uint_col + uint_col)",
            "round(ubigint_col + ubigint_col)",
            "round(usmallint_col + usmallint_col)",
            "round(utinyint_col + utinyint_col)",
            "round(timestamp_tag + timestamp_tag)",
            "round(int_tag + int_tag)",
            "round(bigint_tag + bigint_tag)",
            "round(float_tag + float_tag)",
            "round(double_tag + double_tag)",
            "round(binary_tag + binary_tag)",
            "round(smallint_tag + smallint_tag)",
            "round(tinyint_tag + tinyint_tag)",
            "round(bool_tag + bool_tag)",
            "round(nchar_tag + nchar_tag)",
            "round(uint_tag + uint_tag)",
            "round(ubigint_tag + ubigint_tag)",
            "round(usmallint_tag + usmallint_tag)",
            "round(utinyint_tag + utinyint_tag)",
            "round(ts - ts)",
            "round(timestamp_col - timestamp_col)",
            "round(int_col - int_col)",
            "round(bigint_col - bigint_col)",
            "round(float_col - float_col)",
            "round(double_col - double_col)",
            "round(binary_col - binary_col)",
            "round(smallint_col - smallint_col)",
            "round(tinyint_col - tinyint_col)",
            "round(bool_col - bool_col)",
            "round(nchar_col - nchar_col)",
            "round(uint_col - uint_col)",
            "round(ubigint_col - ubigint_col)",
            "round(usmallint_col - usmallint_col)",
            "round(utinyint_col - utinyint_col)",
            "round(timestamp_tag - timestamp_tag)",
            "round(int_tag - int_tag)",
            "round(bigint_tag - bigint_tag)",
            "round(float_tag - float_tag)",
            "round(double_tag - double_tag)",
            "round(binary_tag - binary_tag)",
            "round(smallint_tag - smallint_tag)",
            "round(tinyint_tag - tinyint_tag)",
            "round(bool_tag - bool_tag)",
            "round(nchar_tag - nchar_tag)",
            "round(uint_tag - uint_tag)",
            "round(ubigint_tag - ubigint_tag)",
            "round(usmallint_tag - usmallint_tag)",
            "round(utinyint_tag - utinyint_tag)",
            "round(ts * ts)",
            "round(timestamp_col * timestamp_col)",
            "round(int_col * int_col)",
            "round(bigint_col * bigint_col)",
            "round(float_col * float_col)",
            "round(double_col * double_col)",
            "round(binary_col * binary_col)",
            "round(smallint_col * smallint_col)",
            "round(tinyint_col * tinyint_col)",
            "round(bool_col * bool_col)",
            "round(nchar_col * nchar_col)",
            "round(uint_col * uint_col)",
            "round(ubigint_col * ubigint_col)",
            "round(usmallint_col * usmallint_col)",
            "round(utinyint_col * utinyint_col)",
            "round(timestamp_tag * timestamp_tag)",
            "round(int_tag * int_tag)",
            "round(bigint_tag * bigint_tag)",
            "round(float_tag * float_tag)",
            "round(double_tag * double_tag)",
            "round(binary_tag * binary_tag)",
            "round(smallint_tag * smallint_tag)",
            "round(tinyint_tag * tinyint_tag)",
            "round(bool_tag * bool_tag)",
            "round(nchar_tag * nchar_tag)",
            "round(uint_tag * uint_tag)",
            "round(ubigint_tag * ubigint_tag)",
            "round(usmallint_tag * usmallint_tag)",
            "round(utinyint_tag * utinyint_tag)",
            "round(ts / ts)",
            "round(timestamp_col / timestamp_col)",
            "round(int_col / int_col)",
            "round(bigint_col / bigint_col)",
            "round(float_col / float_col)",
            "round(double_col / double_col)",
            "round(binary_col / binary_col)",
            "round(smallint_col / smallint_col)",
            "round(tinyint_col / tinyint_col)",
            "round(bool_col / bool_col)",
            "round(nchar_col / nchar_col)",
            "round(uint_col / uint_col)",
            "round(ubigint_col / ubigint_col)",
            "round(usmallint_col / usmallint_col)",
            "round(utinyint_col / utinyint_col)",
            "round(timestamp_tag / timestamp_tag)",
            "round(int_tag / int_tag)",
            "round(bigint_tag / bigint_tag)",
            "round(float_tag / float_tag)",
            "round(double_tag / double_tag)",
            "round(binary_tag / binary_tag)",
            "round(smallint_tag / smallint_tag)",
            "round(tinyint_tag / tinyint_tag)",
            "round(bool_tag / bool_tag)",
            "round(nchar_tag / nchar_tag)",
            "round(uint_tag / uint_tag)",
            "round(ubigint_tag / ubigint_tag)",
            "round(usmallint_tag / usmallint_tag)",
            "round(utinyint_tag / utinyint_tag)",
            "int_col, round(int_col), int_col",
            "bigint_col, round(bigint_col), bigint_col",
            "float_col, round(float_col), float_col",
            "double_col, round(double_col), double_col",
            "smallint_col, round(smallint_col), smallint_col",
            "tinyint_col, round(tinyint_col), tinyint_col",
            "uint_col, round(uint_col), uint_col",
            "ubigint_col, round(ubigint_col), ubigint_col",
            "usmallint_col, round(usmallint_col), usmallint_col",
            "utinyint_col, round(utinyint_col), utinyint_col",
            "count(int_col), round(int_col), count(int_col)",
            "count(bigint_col), round(bigint_col), count(bigint_col)",
            "count(float_col), round(float_col), count(float_col)",
            "count(double_col), round(double_col), count(double_col)",
            "count(smallint_col), round(smallint_col), count(smallint_col)",
            "count(tinyint_col), round(tinyint_col), count(tinyint_col)",
            "count(uint_col), round(uint_col), count(uint_col)",
            "count(ubigint_col), round(ubigint_col), count(ubigint_col)",
            "count(usmallint_col), round(usmallint_col), count(usmallint_col)",
            "count(utinyint_col), round(utinyint_col), count(utinyint_col)",
            "avg(int_col), round(int_col), avg(int_col)",
            "avg(bigint_col), round(bigint_col), avg(bigint_col)",
            "avg(float_col), round(float_col), avg(float_col)",
            "avg(double_col), round(double_col), avg(double_col)",
            "avg(smallint_col), round(smallint_col), avg(smallint_col)",
            "avg(tinyint_col), round(tinyint_col), avg(tinyint_col)",
            "avg(uint_col), round(uint_col), avg(uint_col)",
            "avg(ubigint_col), round(ubigint_col), avg(ubigint_col)",
            "avg(usmallint_col), round(usmallint_col), avg(usmallint_col)",
            "avg(utinyint_col), round(utinyint_col), avg(utinyint_col)",
            "twa(int_col), round(int_col), twa(int_col)",
            "twa(bigint_col), round(bigint_col), twa(bigint_col)",
            "twa(float_col), round(float_col), twa(float_col)",
            "twa(double_col), round(double_col), twa(double_col)",
            "twa(smallint_col), round(smallint_col), twa(smallint_col)",
            "twa(tinyint_col), round(tinyint_col), twa(tinyint_col)",
            "twa(uint_col), round(uint_col), twa(uint_col)",
            "twa(ubigint_col), round(ubigint_col), twa(ubigint_col)",
            "twa(usmallint_col), round(usmallint_col), twa(usmallint_col)",
            "twa(utinyint_col), round(utinyint_col), twa(utinyint_col)",
            "sum(int_col), round(int_col), sum(int_col)",
            "sum(bigint_col), round(bigint_col), sum(bigint_col)",
            "sum(float_col), round(float_col), sum(float_col)",
            "sum(double_col), round(double_col), sum(double_col)",
            "sum(smallint_col), round(smallint_col), sum(smallint_col)",
            "sum(tinyint_col), round(tinyint_col), sum(tinyint_col)",
            "sum(uint_col), round(uint_col), sum(uint_col)",
            "sum(ubigint_col), round(ubigint_col), sum(ubigint_col)",
            "sum(usmallint_col), round(usmallint_col), sum(usmallint_col)",
            "sum(utinyint_col), round(utinyint_col), sum(utinyint_col)",
            "stddev(int_col), round(int_col), stddev(int_col)",
            "stddev(bigint_col), round(bigint_col), stddev(bigint_col)",
            "stddev(float_col), round(float_col), stddev(float_col)",
            "stddev(double_col), round(double_col), stddev(double_col)",
            "stddev(smallint_col), round(smallint_col), stddev(smallint_col)",
            "stddev(tinyint_col), round(tinyint_col), stddev(tinyint_col)",
            "stddev(uint_col), round(uint_col), stddev(uint_col)",
            "stddev(ubigint_col), round(ubigint_col), stddev(ubigint_col)",
            "stddev(usmallint_col), round(usmallint_col), stddev(usmallint_col)",
            "stddev(utinyint_col), round(utinyint_col), stddev(utinyint_col)",
            "irate(int_col), round(int_col), irate(int_col)",
            "irate(bigint_col), round(bigint_col), irate(bigint_col)",
            "irate(float_col), round(float_col), irate(float_col)",
            "irate(double_col), round(double_col), irate(double_col)",
            "irate(smallint_col), round(smallint_col), irate(smallint_col)",
            "irate(tinyint_col), round(tinyint_col), irate(tinyint_col)",
            "irate(uint_col), round(uint_col), irate(uint_col)",
            "irate(ubigint_col), round(ubigint_col), irate(ubigint_col)",
            "irate(usmallint_col), round(usmallint_col), irate(usmallint_col)",
            "irate(utinyint_col), round(utinyint_col), irate(utinyint_col)",
            "min(int_col), round(int_col), min(int_col)",
            "min(bigint_col), round(bigint_col), min(bigint_col)",
            "min(float_col), round(float_col), min(float_col)",
            "min(double_col), round(double_col), min(double_col)",
            "min(smallint_col), round(smallint_col), min(smallint_col)",
            "min(tinyint_col), round(tinyint_col), min(tinyint_col)",
            "min(uint_col), round(uint_col), min(uint_col)",
            "min(ubigint_col), round(ubigint_col), min(ubigint_col)",
            "min(usmallint_col), round(usmallint_col), min(usmallint_col)",
            "min(utinyint_col), round(utinyint_col), min(utinyint_col)",
            "max(int_col), round(int_col), max(int_col)",
            "max(bigint_col), round(bigint_col), max(bigint_col)",
            "max(float_col), round(float_col), max(float_col)",
            "max(double_col), round(double_col), max(double_col)",
            "max(smallint_col), round(smallint_col), max(smallint_col)",
            "max(tinyint_col), round(tinyint_col), max(tinyint_col)",
            "max(uint_col), round(uint_col), max(uint_col)",
            "max(ubigint_col), round(ubigint_col), max(ubigint_col)",
            "max(usmallint_col), round(usmallint_col), max(usmallint_col)",
            "max(utinyint_col), round(utinyint_col), max(utinyint_col)",
            "first(int_col), round(int_col), first(int_col)",
            "first(bigint_col), round(bigint_col), first(bigint_col)",
            "first(float_col), round(float_col), first(float_col)",
            "first(double_col), round(double_col), first(double_col)",
            "first(smallint_col), round(smallint_col), first(smallint_col)",
            "first(tinyint_col), round(tinyint_col), first(tinyint_col)",
            "first(uint_col), round(uint_col), first(uint_col)",
            "first(ubigint_col), round(ubigint_col), first(ubigint_col)",
            "first(usmallint_col), round(usmallint_col), first(usmallint_col)",
            "first(utinyint_col), round(utinyint_col), first(utinyint_col)",
            "last(int_col), round(int_col), last(int_col)",
            "last(bigint_col), round(bigint_col), last(bigint_col)",
            "last(float_col), round(float_col), last(float_col)",
            "last(double_col), round(double_col), last(double_col)",
            "last(smallint_col), round(smallint_col), last(smallint_col)",
            "last(tinyint_col), round(tinyint_col), last(tinyint_col)",
            "last(uint_col), round(uint_col), last(uint_col)",
            "last(ubigint_col), round(ubigint_col), last(ubigint_col)",
            "last(usmallint_col), round(usmallint_col), last(usmallint_col)",
            "last(utinyint_col), round(utinyint_col), last(utinyint_col)",
            "last_row(int_col), round(int_col), last_row(int_col)",
            "last_row(bigint_col), round(bigint_col), last_row(bigint_col)",
            "last_row(float_col), round(float_col), last_row(float_col)",
            "last_row(double_col), round(double_col), last_row(double_col)",
            "last_row(smallint_col), round(smallint_col), last_row(smallint_col)",
            "last_row(tinyint_col), round(tinyint_col), last_row(tinyint_col)",
            "last_row(uint_col), round(uint_col), last_row(uint_col)",
            "last_row(ubigint_col), round(ubigint_col), last_row(ubigint_col)",
            "last_row(usmallint_col), round(usmallint_col), last_row(usmallint_col)",
            "last_row(utinyint_col), round(utinyint_col), last_row(utinyint_col)",
            "interp(int_col), round(int_col), interp(int_col)",
            "interp(bigint_col), round(bigint_col), interp(bigint_col)",
            "interp(float_col), round(float_col), interp(float_col)",
            "interp(double_col), round(double_col), interp(double_col)",
            "interp(smallint_col), round(smallint_col), interp(smallint_col)",
            "interp(tinyint_col), round(tinyint_col), interp(tinyint_col)",
            "interp(uint_col), round(uint_col), interp(uint_col)",
            "interp(ubigint_col), round(ubigint_col), interp(ubigint_col)",
            "interp(usmallint_col), round(usmallint_col), interp(usmallint_col)",
            "interp(utinyint_col), round(utinyint_col), interp(utinyint_col)",
            "diff(int_col), round(int_col), diff(int_col)",
            "diff(bigint_col), round(bigint_col), diff(bigint_col)",
            "diff(float_col), round(float_col), diff(float_col)",
            "diff(double_col), round(double_col), diff(double_col)",
            "diff(smallint_col), round(smallint_col), diff(smallint_col)",
            "diff(tinyint_col), round(tinyint_col), diff(tinyint_col)",
            "diff(uint_col), round(uint_col), diff(uint_col)",
            "diff(ubigint_col), round(ubigint_col), diff(ubigint_col)",
            "diff(usmallint_col), round(usmallint_col), diff(usmallint_col)",
            "diff(utinyint_col), round(utinyint_col), diff(utinyint_col)",
            "spread(int_col), round(int_col), spread(int_col)",
            "spread(bigint_col), round(bigint_col), spread(bigint_col)",
            "spread(float_col), round(float_col), spread(float_col)",
            "spread(double_col), round(double_col), spread(double_col)",
            "spread(smallint_col), round(smallint_col), spread(smallint_col)",
            "spread(tinyint_col), round(tinyint_col), spread(tinyint_col)",
            "spread(uint_col), round(uint_col), spread(uint_col)",
            "spread(ubigint_col), round(ubigint_col), spread(ubigint_col)",
            "spread(usmallint_col), round(usmallint_col), spread(usmallint_col)",
            "spread(utinyint_col), round(utinyint_col), spread(utinyint_col)",
            "leastsquares(int_col, 1, 1), round(int_col), leastsquares(int_col, 1, 1)",
            "leastsquares(bigint_col, 1, 1), round(bigint_col), leastsquares(bigint_col, 1, 1)",
            "leastsquares(float_col, 1, 1), round(float_col), leastsquares(float_col, 1, 1)",
            "leastsquares(double_col, 1, 1), round(double_col), leastsquares(double_col, 1, 1)",
            "leastsquares(smallint_col, 1, 1), round(smallint_col), leastsquares(smallint_col, 1, 1)",
            "leastsquares(tinyint_col, 1, 1), round(tinyint_col), leastsquares(tinyint_col, 1, 1)",
            "leastsquares(uint_col, 1, 1), round(uint_col), leastsquares(uint_col, 1, 1)",
            "leastsquares(ubigint_col, 1, 1), round(ubigint_col), leastsquares(ubigint_col, 1, 1)",
            "leastsquares(usmallint_col, 1, 1), round(usmallint_col), leastsquares(usmallint_col, 1, 1)",
            "leastsquares(utinyint_col, 1, 1), round(utinyint_col), leastsquares(utinyint_col, 1, 1)",
            "top(int_col, 1), round(int_col), top(int_col, 1)",
            "top(bigint_col, 1), round(bigint_col), top(bigint_col, 1)",
            "top(float_col, 1), round(float_col), top(float_col, 1)",
            "top(double_col, 1), round(double_col), top(double_col, 1)",
            "top(smallint_col, 1), round(smallint_col), top(smallint_col, 1)",
            "top(tinyint_col, 1), round(tinyint_col), top(tinyint_col, 1)",
            "top(uint_col, 1), round(uint_col), top(uint_col, 1)",
            "top(ubigint_col, 1), round(ubigint_col), top(ubigint_col, 1)",
            "top(usmallint_col, 1), round(usmallint_col), top(usmallint_col, 1)",
            "top(utinyint_col, 1), round(utinyint_col), top(utinyint_col, 1)",
            "bottom(int_col, 1), round(int_col), bottom(int_col, 1)",
            "bottom(bigint_col, 1), round(bigint_col), bottom(bigint_col, 1)",
            "bottom(float_col, 1), round(float_col), bottom(float_col, 1)",
            "bottom(double_col, 1), round(double_col), bottom(double_col, 1)",
            "bottom(smallint_col, 1), round(smallint_col), bottom(smallint_col, 1)",
            "bottom(tinyint_col, 1), round(tinyint_col), bottom(tinyint_col, 1)",
            "bottom(uint_col, 1), round(uint_col), bottom(uint_col, 1)",
            "bottom(ubigint_col, 1), round(ubigint_col), bottom(ubigint_col, 1)",
            "bottom(usmallint_col, 1), round(usmallint_col), bottom(usmallint_col, 1)",
            "bottom(utinyint_col, 1), round(utinyint_col), bottom(utinyint_col, 1)",
            "percentile(int_col, 1), round(int_col), percentile(int_col, 1)",
            "percentile(bigint_col, 1), round(bigint_col), percentile(bigint_col, 1)",
            "percentile(float_col, 1), round(float_col), percentile(float_col, 1)",
            "percentile(double_col, 1), round(double_col), percentile(double_col, 1)",
            "percentile(smallint_col, 1), round(smallint_col), percentile(smallint_col, 1)",
            "percentile(tinyint_col, 1), round(tinyint_col), percentile(tinyint_col, 1)",
            "percentile(uint_col, 1), round(uint_col), percentile(uint_col, 1)",
            "percentile(ubigint_col, 1), round(ubigint_col), percentile(ubigint_col, 1)",
            "percentile(usmallint_col, 1), round(usmallint_col), percentile(usmallint_col, 1)",
            "percentile(utinyint_col, 1), round(utinyint_col), percentile(utinyint_col, 1)",
            "apercentile(int_col, 1), round(int_col), apercentile(int_col, 1)",
            "apercentile(bigint_col, 1), round(bigint_col), apercentile(bigint_col, 1)",
            "apercentile(float_col, 1), round(float_col), apercentile(float_col, 1)",
            "apercentile(double_col, 1), round(double_col), apercentile(double_col, 1)",
            "apercentile(smallint_col, 1), round(smallint_col), apercentile(smallint_col, 1)",
            "apercentile(tinyint_col, 1), round(tinyint_col), apercentile(tinyint_col, 1)",
            "apercentile(uint_col, 1), round(uint_col), apercentile(uint_col, 1)",
            "apercentile(ubigint_col, 1), round(ubigint_col), apercentile(ubigint_col, 1)",
            "apercentile(usmallint_col, 1), round(usmallint_col), apercentile(usmallint_col, 1)",
            "apercentile(utinyint_col, 1), round(utinyint_col), apercentile(utinyint_col, 1)",
            "derivative(int_col, 1s, 0), round(int_col), derivative(int_col, 1s, 0)",
            "derivative(bigint_col, 1s, 0), round(bigint_col), derivative(bigint_col, 1s, 0)",
            "derivative(float_col, 1s, 0), round(float_col), derivative(float_col, 1s, 0)",
            "derivative(double_col, 1s, 0), round(double_col), derivative(double_col, 1s, 0)",
            "derivative(smallint_col, 1s, 0), round(smallint_col), derivative(smallint_col, 1s, 0)",
            "derivative(tinyint_col, 1s, 0), round(tinyint_col), derivative(tinyint_col, 1s, 0)",
            "derivative(uint_col, 1s, 0), round(uint_col), derivative(uint_col, 1s, 0)",
            "derivative(ubigint_col, 1s, 0), round(ubigint_col), derivative(ubigint_col, 1s, 0)",
            "derivative(usmallint_col, 1s, 0), round(usmallint_col), derivative(usmallint_col, 1s, 0)",
            "derivative(utinyint_col, 1s, 0), round(utinyint_col), derivative(utinyint_col, 1s, 0)",
            "1, round(int_col), 1",
            "1, round(bigint_col), 1",
            "1, round(float_col), 1",
            "1, round(double_col), 1",
            "1, round(smallint_col), 1",
            "1, round(tinyint_col), 1",
            "1, round(uint_col), 1",
            "1, round(ubigint_col), 1",
            "1, round(usmallint_col), 1",
            "1, round(utinyint_col), 1",
            "round(int_col) as anyName",
            "round(bigint_col) as anyName",
            "round(float_col) as anyName",
            "round(double_col) as anyName",
            "round(smallint_col) as anyName",
            "round(tinyint_col) as anyName",
            "round(uint_col) as anyName",
            "round(ubigint_col) as anyName",
            "round(usmallint_col) as anyName",
            "round(utinyint_col) as anyName",
            "distinct round(int_col)",
            "distinct round(bigint_col)",
            "distinct round(float_col)",
            "distinct round(double_col)",
            "distinct round(smallint_col)",
            "distinct round(tinyint_col)",
            "distinct round(uint_col)",
            "distinct round(ubigint_col)",
            "distinct round(usmallint_col)",
            "distinct round(utinyint_col)",
        ]
        simple_select_command = [
            "round(super.int_col)",
            "round(super.bigint_col)",
            "round(super.float_col)",
            "round(super.double_col)",
            "round(super.smallint_col)",
            "round(super.tinyint_col)",
            "round(super.uint_col)",
            "round(super.ubigint_col)",
            "round(super.usmallint_col)",
            "round(super.utinyint_col)",
            "round(t1.int_col)",
            "round(t1.bigint_col)",
            "round(t1.float_col)",
            "round(t1.double_col)",
            "round(t1.smallint_col)",
            "round(t1.tinyint_col)",
            "round(t1.uint_col)",
            "round(t1.ubigint_col)",
            "round(t1.usmallint_col)",
            "round(t1.utinyint_col)",
        ]
        from_command = [" from super", " from t1"]
        advance_from_command = [
            " from super", " from t1",
            " from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag"
        ]
        filter_command = [
            "", " session(ts, 1s)", " state_window(int_col)", " interval (1s)",
            " interval (1s) sliding (1s)", " group by (ts)"
        ]
        fill_command = [
            "", " fill(prev)", " fill(next)", " fill(null)", " fill(1)",
            " fill(linear)"
        ]
        tdSql.prepare()
        tdSql.execute(
            "create stable super (ts timestamp, timestamp_col timestamp, int_col int, bigint_col bigint, float_col float,\
                double_col double, binary_col binary(8), smallint_col smallint, tinyint_col tinyint, bool_col bool, nchar_col nchar(8), \
                uint_col int unsigned, ubigint_col bigint unsigned, usmallint_col smallint unsigned,  utinyint_col tinyint unsigned) tags (int_tag int, bigint_tag bigint, \
                    float_tag float, double_tag double, binary_tag binary(8), smallint_tag smallint, tinyint_tag tinyint, bool_tag bool, nchar_tag nchar(8),\
                        uint_tag int unsigned, ubigint_tag bigint unsigned, usmallint_tag smallint unsigned, utinyint_tag tinyint unsigned, timestamp_tag timestamp)"
        )
        tdSql.execute(
            "create stable superb (ts timestamp, timestamp_col timestamp, int_col int, bigint_col bigint, float_col float,\
                double_col double, binary_col binary(8), smallint_col smallint, tinyint_col tinyint, bool_col bool, nchar_col nchar(8), \
                uint_col int unsigned, ubigint_col bigint unsigned, usmallint_col smallint unsigned,  utinyint_col tinyint unsigned) tags (int_tag int, bigint_tag bigint, \
                    float_tag float, double_tag double, binary_tag binary(8), smallint_tag smallint, tinyint_tag tinyint, bool_tag bool, nchar_tag nchar(8),\
                        uint_tag int unsigned, ubigint_tag bigint unsigned, usmallint_tag smallint unsigned, utinyint_tag tinyint unsigned, timestamp_tag timestamp)"
        )
        tdSql.execute(
            "create table t1 using super tags (1, %d, %f, %f, '%s', %d, %d, 1, '%s', %d, %d, %d, %d, %s)"
            % (self.randomBigint(), self.randomDouble(), self.randomDouble(),
               self.randomNchar(), self.randomSmallint(), self.randomTinyint(),
               self.randomNchar(), self.randomUInt(), self.randomUBigint(),
               self.randomUSmallint(), self.randomUTinyint(), 'now'))
        tdSql.execute(
            "insert into t1 values (1629796215891, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 1, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "insert into t1 values (1629796215892, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 0, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "insert into t1 values (1629796215893, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 1, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "insert into t1 values (1629796215894, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 0, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "create table t2 using superb tags (1, %d, %f, %f, '%s', %d, %d, 1, '%s', %d, %d, %d, %d, %s)"
            % (self.randomBigint(), self.randomDouble(), self.randomDouble(),
               self.randomNchar(), self.randomSmallint(), self.randomTinyint(),
               self.randomNchar(), self.randomUInt(), self.randomUBigint(),
               self.randomUSmallint(), self.randomUTinyint(), 'now'))
        tdSql.execute(
            "insert into t2 values (1629796215891, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 1, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "insert into t2 values (1629796215892, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 0, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "insert into t2 values (1629796215893, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 1, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        tdSql.execute(
            "insert into t2 values (1629796215894, 1629796215891, %d, %d, %f, %f, '%s', %d, %d, 0, '%s', %d, %d, %d, %d)"
            % (self.randomInt(), self.randomBigint(), self.randomDouble(),
               self.randomDouble(), self.randomNchar(), self.randomSmallint(),
               self.randomTinyint(), self.randomNchar(), self.randomUInt(),
               self.randomUBigint(), self.randomUSmallint(),
               self.randomUTinyint()))
        
        shouldPass = ['select round(int_col) from super',
         'select round(int_col) from t1',
         'select round(bigint_col) from super',
         'select round(bigint_col) from t1',
         'select round(float_col) from super',
         'select round(float_col) from t1',
         'select round(double_col) from super',
         'select round(double_col) from t1',
         'select round(smallint_col) from super',
         'select round(smallint_col) from t1',
         'select round(tinyint_col) from super',
         'select round(tinyint_col) from t1',
         'select round(uint_col) from super',
         'select round(uint_col) from t1',
         'select round(ubigint_col) from super',
         'select round(ubigint_col) from t1',
         'select round(usmallint_col) from super',
         'select round(usmallint_col) from t1',
         'select round(utinyint_col) from super',
         'select round(utinyint_col) from t1',
         'select round(int_col) - round(int_col) from super',
         'select round(int_col) - round(int_col) from t1',
         'select round(bigint_col) - round(bigint_col) from super',
         'select round(bigint_col) - round(bigint_col) from t1',
         'select round(float_col) - round(float_col) from super',
         'select round(float_col) - round(float_col) from t1',
         'select round(double_col) - round(double_col) from super',
         'select round(double_col) - round(double_col) from t1',
         'select round(smallint_col) - round(smallint_col) from super',
         'select round(smallint_col) - round(smallint_col) from t1',
         'select round(tinyint_col) - round(tinyint_col) from super',
         'select round(tinyint_col) - round(tinyint_col) from t1',
         'select round(uint_col) - round(uint_col) from super',
         'select round(uint_col) - round(uint_col) from t1',
         'select round(ubigint_col) - round(ubigint_col) from super',
         'select round(ubigint_col) - round(ubigint_col) from t1',
         'select round(usmallint_col) - round(usmallint_col) from super',
         'select round(usmallint_col) - round(usmallint_col) from t1',
         'select round(utinyint_col) - round(utinyint_col) from super',
         'select round(utinyint_col) - round(utinyint_col) from t1',
         'select round(int_col) / round(int_col) from super',
         'select round(int_col) / round(int_col) from t1',
         'select round(bigint_col) / round(bigint_col) from super',
         'select round(bigint_col) / round(bigint_col) from t1',
         'select round(float_col) / round(float_col) from super',
         'select round(float_col) / round(float_col) from t1',
         'select round(double_col) / round(double_col) from super',
         'select round(double_col) / round(double_col) from t1',
         'select round(smallint_col) / round(smallint_col) from super',
         'select round(smallint_col) / round(smallint_col) from t1',
         'select round(tinyint_col) / round(tinyint_col) from super',
         'select round(tinyint_col) / round(tinyint_col) from t1',
         'select round(uint_col) / round(uint_col) from super',
         'select round(uint_col) / round(uint_col) from t1',
         'select round(ubigint_col) / round(ubigint_col) from super',
         'select round(ubigint_col) / round(ubigint_col) from t1',
         'select round(usmallint_col) / round(usmallint_col) from super',
         'select round(usmallint_col) / round(usmallint_col) from t1',
         'select round(utinyint_col) / round(utinyint_col) from super',
         'select round(utinyint_col) / round(utinyint_col) from t1',
         'select round(int_col) * round(int_col) from super',
         'select round(int_col) * round(int_col) from t1',
         'select round(bigint_col) * round(bigint_col) from super',
         'select round(bigint_col) * round(bigint_col) from t1',
         'select round(float_col) * round(float_col) from super',
         'select round(float_col) * round(float_col) from t1',
         'select round(double_col) * round(double_col) from super',
         'select round(double_col) * round(double_col) from t1',
         'select round(smallint_col) * round(smallint_col) from super',
         'select round(smallint_col) * round(smallint_col) from t1',
         'select round(tinyint_col) * round(tinyint_col) from super',
         'select round(tinyint_col) * round(tinyint_col) from t1',
         'select round(uint_col) * round(uint_col) from super',
         'select round(uint_col) * round(uint_col) from t1',
         'select round(ubigint_col) * round(ubigint_col) from super',
         'select round(ubigint_col) * round(ubigint_col) from t1',
         'select round(usmallint_col) * round(usmallint_col) from super',
         'select round(usmallint_col) * round(usmallint_col) from t1',
         'select round(utinyint_col) * round(utinyint_col) from super',
         'select round(utinyint_col) * round(utinyint_col) from t1',
         'select round(count(ts)) from super',
         'select round(count(ts)) from t1',
         'select round(count(timestamp_col)) from super',
         'select round(count(timestamp_col)) from t1',
         'select round(count(int_col)) from super',
         'select round(count(int_col)) from t1',
         'select round(count(bigint_col)) from super',
         'select round(count(bigint_col)) from t1',
         'select round(count(float_col)) from super',
         'select round(count(float_col)) from t1',
         'select round(count(double_col)) from super',
         'select round(count(double_col)) from t1',
         'select round(count(binary_col)) from super',
         'select round(count(binary_col)) from t1',
         'select round(count(smallint_col)) from super',
         'select round(count(smallint_col)) from t1',
         'select round(count(tinyint_col)) from super',
         'select round(count(tinyint_col)) from t1',
         'select round(count(bool_col)) from super',
         'select round(count(bool_col)) from t1',
         'select round(count(nchar_col)) from super',
         'select round(count(nchar_col)) from t1',
         'select round(count(uint_col)) from super',
         'select round(count(uint_col)) from t1',
         'select round(count(ubigint_col)) from super',
         'select round(count(ubigint_col)) from t1',
         'select round(count(usmallint_col)) from super',
         'select round(count(usmallint_col)) from t1',
         'select round(count(utinyint_col)) from super',
         'select round(count(utinyint_col)) from t1',
         'select round(count(timestamp_tag)) from super',
         'select round(count(timestamp_tag)) from t1',
         'select round(count(int_tag)) from super',
         'select round(count(int_tag)) from t1',
         'select round(count(bigint_tag)) from super',
         'select round(count(bigint_tag)) from t1',
         'select round(count(float_tag)) from super',
         'select round(count(float_tag)) from t1',
         'select round(count(double_tag)) from super',
         'select round(count(double_tag)) from t1',
         'select round(count(binary_tag)) from super',
         'select round(count(binary_tag)) from t1',
         'select round(count(smallint_tag)) from super',
         'select round(count(smallint_tag)) from t1',
         'select round(count(tinyint_tag)) from super',
         'select round(count(tinyint_tag)) from t1',
         'select round(count(bool_tag)) from super',
         'select round(count(bool_tag)) from t1',
         'select round(count(nchar_tag)) from super',
         'select round(count(nchar_tag)) from t1',
         'select round(count(uint_tag)) from super',
         'select round(count(uint_tag)) from t1',
         'select round(count(ubigint_tag)) from super',
         'select round(count(ubigint_tag)) from t1',
         'select round(count(usmallint_tag)) from super',
         'select round(count(usmallint_tag)) from t1',
         'select round(count(utinyint_tag)) from super',
         'select round(count(utinyint_tag)) from t1',
         'select round(avg(int_col)) from super',
         'select round(avg(int_col)) from t1',
         'select round(avg(bigint_col)) from super',
         'select round(avg(bigint_col)) from t1',
         'select round(avg(float_col)) from super',
         'select round(avg(float_col)) from t1',
         'select round(avg(double_col)) from super',
         'select round(avg(double_col)) from t1',
         'select round(avg(smallint_col)) from super',
         'select round(avg(smallint_col)) from t1',
         'select round(avg(tinyint_col)) from super',
         'select round(avg(tinyint_col)) from t1',
         'select round(avg(uint_col)) from super',
         'select round(avg(uint_col)) from t1',
         'select round(avg(ubigint_col)) from super',
         'select round(avg(ubigint_col)) from t1',
         'select round(avg(usmallint_col)) from super',
         'select round(avg(usmallint_col)) from t1',
         'select round(avg(utinyint_col)) from super',
         'select round(avg(utinyint_col)) from t1',
         'select round(twa(int_col)) from t1',
         'select round(twa(bigint_col)) from t1',
         'select round(twa(float_col)) from t1',
         'select round(twa(double_col)) from t1',
         'select round(twa(smallint_col)) from t1',
         'select round(twa(tinyint_col)) from t1',
         'select round(twa(uint_col)) from t1',
         'select round(twa(ubigint_col)) from t1',
         'select round(twa(usmallint_col)) from t1',
         'select round(twa(utinyint_col)) from t1',
         'select round(sum(int_col)) from super',
         'select round(sum(int_col)) from t1',
         'select round(sum(bigint_col)) from super',
         'select round(sum(bigint_col)) from t1',
         'select round(sum(float_col)) from super',
         'select round(sum(float_col)) from t1',
         'select round(sum(double_col)) from super',
         'select round(sum(double_col)) from t1',
         'select round(sum(smallint_col)) from super',
         'select round(sum(smallint_col)) from t1',
         'select round(sum(tinyint_col)) from super',
         'select round(sum(tinyint_col)) from t1',
         'select round(sum(uint_col)) from super',
         'select round(sum(uint_col)) from t1',
         'select round(sum(ubigint_col)) from super',
         'select round(sum(ubigint_col)) from t1',
         'select round(sum(usmallint_col)) from super',
         'select round(sum(usmallint_col)) from t1',
         'select round(sum(utinyint_col)) from super',
         'select round(sum(utinyint_col)) from t1',
         'select round(stddev(int_col)) from super',
         'select round(stddev(int_col)) from t1',
         'select round(stddev(bigint_col)) from super',
         'select round(stddev(bigint_col)) from t1',
         'select round(stddev(float_col)) from super',
         'select round(stddev(float_col)) from t1',
         'select round(stddev(double_col)) from super',
         'select round(stddev(double_col)) from t1',
         'select round(stddev(smallint_col)) from super',
         'select round(stddev(smallint_col)) from t1',
         'select round(stddev(tinyint_col)) from super',
         'select round(stddev(tinyint_col)) from t1',
         'select round(stddev(uint_col)) from super',
         'select round(stddev(uint_col)) from t1',
         'select round(stddev(ubigint_col)) from super',
         'select round(stddev(ubigint_col)) from t1',
         'select round(stddev(usmallint_col)) from super',
         'select round(stddev(usmallint_col)) from t1',
         'select round(stddev(utinyint_col)) from super',
         'select round(stddev(utinyint_col)) from t1',
         'select round(irate(int_col)) from t1',
         'select round(irate(bigint_col)) from t1',
         'select round(irate(float_col)) from t1',
         'select round(irate(double_col)) from t1',
         'select round(irate(smallint_col)) from t1',
         'select round(irate(tinyint_col)) from t1',
         'select round(irate(uint_col)) from t1',
         'select round(irate(ubigint_col)) from t1',
         'select round(irate(usmallint_col)) from t1',
         'select round(irate(utinyint_col)) from t1',
         'select round(min(int_col)) from super',
         'select round(min(int_col)) from t1',
         'select round(min(bigint_col)) from super',
         'select round(min(bigint_col)) from t1',
         'select round(min(float_col)) from super',
         'select round(min(float_col)) from t1',
         'select round(min(double_col)) from super',
         'select round(min(double_col)) from t1',
         'select round(min(smallint_col)) from super',
         'select round(min(smallint_col)) from t1',
         'select round(min(tinyint_col)) from super',
         'select round(min(tinyint_col)) from t1',
         'select round(min(uint_col)) from super',
         'select round(min(uint_col)) from t1',
         'select round(min(ubigint_col)) from super',
         'select round(min(ubigint_col)) from t1',
         'select round(min(usmallint_col)) from super',
         'select round(min(usmallint_col)) from t1',
         'select round(min(utinyint_col)) from super',
         'select round(min(utinyint_col)) from t1',
         'select round(max(int_col)) from super',
         'select round(max(int_col)) from t1',
         'select round(max(bigint_col)) from super',
         'select round(max(bigint_col)) from t1',
         'select round(max(float_col)) from super',
         'select round(max(float_col)) from t1',
         'select round(max(double_col)) from super',
         'select round(max(double_col)) from t1',
         'select round(max(smallint_col)) from super',
         'select round(max(smallint_col)) from t1',
         'select round(max(tinyint_col)) from super',
         'select round(max(tinyint_col)) from t1',
         'select round(max(uint_col)) from super',
         'select round(max(uint_col)) from t1',
         'select round(max(ubigint_col)) from super',
         'select round(max(ubigint_col)) from t1',
         'select round(max(usmallint_col)) from super',
         'select round(max(usmallint_col)) from t1',
         'select round(max(utinyint_col)) from super',
         'select round(max(utinyint_col)) from t1',
         'select round(first(int_col)) from super',
         'select round(first(int_col)) from t1',
         'select round(first(bigint_col)) from super',
         'select round(first(bigint_col)) from t1',
         'select round(first(float_col)) from super',
         'select round(first(float_col)) from t1',
         'select round(first(double_col)) from super',
         'select round(first(double_col)) from t1',
         'select round(first(smallint_col)) from super',
         'select round(first(smallint_col)) from t1',
         'select round(first(tinyint_col)) from super',
         'select round(first(tinyint_col)) from t1',
         'select round(first(uint_col)) from super',
         'select round(first(uint_col)) from t1',
         'select round(first(ubigint_col)) from super',
         'select round(first(ubigint_col)) from t1',
         'select round(first(usmallint_col)) from super',
         'select round(first(usmallint_col)) from t1',
         'select round(first(utinyint_col)) from super',
         'select round(first(utinyint_col)) from t1',
         'select round(last(int_col)) from super',
         'select round(last(int_col)) from t1',
         'select round(last(bigint_col)) from super',
         'select round(last(bigint_col)) from t1',
         'select round(last(float_col)) from super',
         'select round(last(float_col)) from t1',
         'select round(last(double_col)) from super',
         'select round(last(double_col)) from t1',
         'select round(last(smallint_col)) from super',
         'select round(last(smallint_col)) from t1',
         'select round(last(tinyint_col)) from super',
         'select round(last(tinyint_col)) from t1',
         'select round(last(uint_col)) from super',
         'select round(last(uint_col)) from t1',
         'select round(last(ubigint_col)) from super',
         'select round(last(ubigint_col)) from t1',
         'select round(last(usmallint_col)) from super',
         'select round(last(usmallint_col)) from t1',
         'select round(last(utinyint_col)) from super',
         'select round(last(utinyint_col)) from t1',
         'select round(percentile(int_col, 1)) from t1',
         'select round(percentile(bigint_col, 1)) from t1',
         'select round(percentile(float_col, 1)) from t1',
         'select round(percentile(double_col, 1)) from t1',
         'select round(percentile(smallint_col, 1)) from t1',
         'select round(percentile(tinyint_col, 1)) from t1',
         'select round(percentile(uint_col, 1)) from t1',
         'select round(percentile(ubigint_col, 1)) from t1',
         'select round(percentile(usmallint_col, 1)) from t1',
         'select round(percentile(utinyint_col, 1)) from t1',
         'select round(apercentile(int_col, 1)) from super',
         'select round(apercentile(int_col, 1)) from t1',
         'select round(apercentile(bigint_col, 1)) from super',
         'select round(apercentile(bigint_col, 1)) from t1',
         'select round(apercentile(float_col, 1)) from super',
         'select round(apercentile(float_col, 1)) from t1',
         'select round(apercentile(double_col, 1)) from super',
         'select round(apercentile(double_col, 1)) from t1',
         'select round(apercentile(smallint_col, 1)) from super',
         'select round(apercentile(smallint_col, 1)) from t1',
         'select round(apercentile(tinyint_col, 1)) from super',
         'select round(apercentile(tinyint_col, 1)) from t1',
         'select round(apercentile(uint_col, 1)) from super',
         'select round(apercentile(uint_col, 1)) from t1',
         'select round(apercentile(ubigint_col, 1)) from super',
         'select round(apercentile(ubigint_col, 1)) from t1',
         'select round(apercentile(usmallint_col, 1)) from super',
         'select round(apercentile(usmallint_col, 1)) from t1',
         'select round(apercentile(utinyint_col, 1)) from super',
         'select round(apercentile(utinyint_col, 1)) from t1',
         'select round(last_row(int_col)) from super',
         'select round(last_row(int_col)) from t1',
         'select round(last_row(bigint_col)) from super',
         'select round(last_row(bigint_col)) from t1',
         'select round(last_row(float_col)) from super',
         'select round(last_row(float_col)) from t1',
         'select round(last_row(double_col)) from super',
         'select round(last_row(double_col)) from t1',
         'select round(last_row(smallint_col)) from super',
         'select round(last_row(smallint_col)) from t1',
         'select round(last_row(tinyint_col)) from super',
         'select round(last_row(tinyint_col)) from t1',
         'select round(last_row(uint_col)) from super',
         'select round(last_row(uint_col)) from t1',
         'select round(last_row(ubigint_col)) from super',
         'select round(last_row(ubigint_col)) from t1',
         'select round(last_row(usmallint_col)) from super',
         'select round(last_row(usmallint_col)) from t1',
         'select round(last_row(utinyint_col)) from super',
         'select round(last_row(utinyint_col)) from t1',
         'select round(interp(int_col)) from t1',
         'select round(interp(bigint_col)) from t1',
         'select round(interp(float_col)) from t1',
         'select round(interp(double_col)) from t1',
         'select round(interp(smallint_col)) from t1',
         'select round(interp(tinyint_col)) from t1',
         'select round(interp(uint_col)) from t1',
         'select round(interp(ubigint_col)) from t1',
         'select round(interp(usmallint_col)) from t1',
         'select round(interp(utinyint_col)) from t1',
         'select round(spread(ts)) from super',
         'select round(spread(ts)) from t1',
         'select round(spread(timestamp_col)) from super',
         'select round(spread(timestamp_col)) from t1',
         'select round(spread(int_col)) from super',
         'select round(spread(int_col)) from t1',
         'select round(spread(bigint_col)) from super',
         'select round(spread(bigint_col)) from t1',
         'select round(spread(float_col)) from super',
         'select round(spread(float_col)) from t1',
         'select round(spread(double_col)) from super',
         'select round(spread(double_col)) from t1',
         'select round(spread(smallint_col)) from super',
         'select round(spread(smallint_col)) from t1',
         'select round(spread(tinyint_col)) from super',
         'select round(spread(tinyint_col)) from t1',
         'select round(spread(uint_col)) from super',
         'select round(spread(uint_col)) from t1',
         'select round(spread(ubigint_col)) from super',
         'select round(spread(ubigint_col)) from t1',
         'select round(spread(usmallint_col)) from super',
         'select round(spread(usmallint_col)) from t1',
         'select round(spread(utinyint_col)) from super',
         'select round(spread(utinyint_col)) from t1',
         'select round(int_col + int_col) from super',
         'select round(int_col + int_col) from t1',
         'select round(bigint_col + bigint_col) from super',
         'select round(bigint_col + bigint_col) from t1',
         'select round(float_col + float_col) from super',
         'select round(float_col + float_col) from t1',
         'select round(double_col + double_col) from super',
         'select round(double_col + double_col) from t1',
         'select round(smallint_col + smallint_col) from super',
         'select round(smallint_col + smallint_col) from t1',
         'select round(tinyint_col + tinyint_col) from super',
         'select round(tinyint_col + tinyint_col) from t1',
         'select round(uint_col + uint_col) from super',
         'select round(uint_col + uint_col) from t1',
         'select round(ubigint_col + ubigint_col) from super',
         'select round(ubigint_col + ubigint_col) from t1',
         'select round(usmallint_col + usmallint_col) from super',
         'select round(usmallint_col + usmallint_col) from t1',
         'select round(utinyint_col + utinyint_col) from super',
         'select round(utinyint_col + utinyint_col) from t1',
         'select round(int_col - int_col) from super',
         'select round(int_col - int_col) from t1',
         'select round(bigint_col - bigint_col) from super',
         'select round(bigint_col - bigint_col) from t1',
         'select round(float_col - float_col) from super',
         'select round(float_col - float_col) from t1',
         'select round(double_col - double_col) from super',
         'select round(double_col - double_col) from t1',
         'select round(smallint_col - smallint_col) from super',
         'select round(smallint_col - smallint_col) from t1',
         'select round(tinyint_col - tinyint_col) from super',
         'select round(tinyint_col - tinyint_col) from t1',
         'select round(uint_col - uint_col) from super',
         'select round(uint_col - uint_col) from t1',
         'select round(ubigint_col - ubigint_col) from super',
         'select round(ubigint_col - ubigint_col) from t1',
         'select round(usmallint_col - usmallint_col) from super',
         'select round(usmallint_col - usmallint_col) from t1',
         'select round(utinyint_col - utinyint_col) from super',
         'select round(utinyint_col - utinyint_col) from t1',
         'select round(int_col * int_col) from super',
         'select round(int_col * int_col) from t1',
         'select round(bigint_col * bigint_col) from super',
         'select round(bigint_col * bigint_col) from t1',
         'select round(float_col * float_col) from super',
         'select round(float_col * float_col) from t1',
         'select round(double_col * double_col) from super',
         'select round(double_col * double_col) from t1',
         'select round(smallint_col * smallint_col) from super',
         'select round(smallint_col * smallint_col) from t1',
         'select round(tinyint_col * tinyint_col) from super',
         'select round(tinyint_col * tinyint_col) from t1',
         'select round(uint_col * uint_col) from super',
         'select round(uint_col * uint_col) from t1',
         'select round(ubigint_col * ubigint_col) from super',
         'select round(ubigint_col * ubigint_col) from t1',
         'select round(usmallint_col * usmallint_col) from super',
         'select round(usmallint_col * usmallint_col) from t1',
         'select round(utinyint_col * utinyint_col) from super',
         'select round(utinyint_col * utinyint_col) from t1',
         'select round(int_col / int_col) from super',
         'select round(int_col / int_col) from t1',
         'select round(bigint_col / bigint_col) from super',
         'select round(bigint_col / bigint_col) from t1',
         'select round(float_col / float_col) from super',
         'select round(float_col / float_col) from t1',
         'select round(double_col / double_col) from super',
         'select round(double_col / double_col) from t1',
         'select round(smallint_col / smallint_col) from super',
         'select round(smallint_col / smallint_col) from t1',
         'select round(tinyint_col / tinyint_col) from super',
         'select round(tinyint_col / tinyint_col) from t1',
         'select round(uint_col / uint_col) from super',
         'select round(uint_col / uint_col) from t1',
         'select round(ubigint_col / ubigint_col) from super',
         'select round(ubigint_col / ubigint_col) from t1',
         'select round(usmallint_col / usmallint_col) from super',
         'select round(usmallint_col / usmallint_col) from t1',
         'select round(utinyint_col / utinyint_col) from super',
         'select round(utinyint_col / utinyint_col) from t1',
         'select int_col, round(int_col), int_col from super',
         'select int_col, round(int_col), int_col from t1',
         'select bigint_col, round(bigint_col), bigint_col from super',
         'select bigint_col, round(bigint_col), bigint_col from t1',
         'select float_col, round(float_col), float_col from super',
         'select float_col, round(float_col), float_col from t1',
         'select double_col, round(double_col), double_col from super',
         'select double_col, round(double_col), double_col from t1',
         'select smallint_col, round(smallint_col), smallint_col from super',
         'select smallint_col, round(smallint_col), smallint_col from t1',
         'select tinyint_col, round(tinyint_col), tinyint_col from super',
         'select tinyint_col, round(tinyint_col), tinyint_col from t1',
         'select uint_col, round(uint_col), uint_col from super',
         'select uint_col, round(uint_col), uint_col from t1',
         'select ubigint_col, round(ubigint_col), ubigint_col from super',
         'select ubigint_col, round(ubigint_col), ubigint_col from t1',
         'select usmallint_col, round(usmallint_col), usmallint_col from super',
         'select usmallint_col, round(usmallint_col), usmallint_col from t1',
         'select utinyint_col, round(utinyint_col), utinyint_col from super',
         'select utinyint_col, round(utinyint_col), utinyint_col from t1',
         'select 1, round(int_col), 1 from super',
         'select 1, round(int_col), 1 from t1',
         'select 1, round(bigint_col), 1 from super',
         'select 1, round(bigint_col), 1 from t1',
         'select 1, round(float_col), 1 from super',
         'select 1, round(float_col), 1 from t1',
         'select 1, round(double_col), 1 from super',
         'select 1, round(double_col), 1 from t1',
         'select 1, round(smallint_col), 1 from super',
         'select 1, round(smallint_col), 1 from t1',
         'select 1, round(tinyint_col), 1 from super',
         'select 1, round(tinyint_col), 1 from t1',
         'select 1, round(uint_col), 1 from super',
         'select 1, round(uint_col), 1 from t1',
         'select 1, round(ubigint_col), 1 from super',
         'select 1, round(ubigint_col), 1 from t1',
         'select 1, round(usmallint_col), 1 from super',
         'select 1, round(usmallint_col), 1 from t1',
         'select 1, round(utinyint_col), 1 from super',
         'select 1, round(utinyint_col), 1 from t1',
         'select round(int_col) as anyName from super',
         'select round(int_col) as anyName from t1',
         'select round(bigint_col) as anyName from super',
         'select round(bigint_col) as anyName from t1',
         'select round(float_col) as anyName from super',
         'select round(float_col) as anyName from t1',
         'select round(double_col) as anyName from super',
         'select round(double_col) as anyName from t1',
         'select round(smallint_col) as anyName from super',
         'select round(smallint_col) as anyName from t1',
         'select round(tinyint_col) as anyName from super',
         'select round(tinyint_col) as anyName from t1',
         'select round(uint_col) as anyName from super',
         'select round(uint_col) as anyName from t1',
         'select round(ubigint_col) as anyName from super',
         'select round(ubigint_col) as anyName from t1',
         'select round(usmallint_col) as anyName from super',
         'select round(usmallint_col) as anyName from t1',
         'select round(utinyint_col) as anyName from super',
         'select round(utinyint_col) as anyName from t1']


        shouldPass2 = ['select round(super.int_col) from super',
            'select round(super.int_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select round(super.bigint_col) from super',
            'select round(super.bigint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select round(super.float_col) from super',
            'select round(super.float_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select round(super.double_col) from super',
            'select round(super.double_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select round(super.smallint_col) from super',
            'select round(super.smallint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select round(super.tinyint_col) from super',
            'select round(super.tinyint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select round(super.uint_col) from super',
            'select round(super.uint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select round(super.ubigint_col) from super',
            'select round(super.ubigint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select round(super.usmallint_col) from super',
            'select round(super.usmallint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select round(super.utinyint_col) from super',
            'select round(super.utinyint_col) from super, superb where super.ts = superb.ts and super.int_tag = superb.int_tag',
            'select round(t1.int_col) from t1',
            'select round(t1.bigint_col) from t1',
            'select round(t1.float_col) from t1',
            'select round(t1.double_col) from t1',
            'select round(t1.smallint_col) from t1',
            'select round(t1.tinyint_col) from t1',
            'select round(t1.uint_col) from t1',
            'select round(t1.ubigint_col) from t1',
            'select round(t1.usmallint_col) from t1',
            'select round(t1.utinyint_col) from t1']

          
        for s in range(len(select_command)):
            for f in range(len(from_command)):
                sql = "select " + select_command[s] + from_command[f]
                if sql in shouldPass:
                    tdSql.query(sql)
                else:
                    tdSql.error(sql)
        for sim in range(len(simple_select_command)):
            for fr in range(len(advance_from_command)):
                for filter in range(len(filter_command)):
                    for fill in range(len(fill_command)):
                        sql = "select " + simple_select_command[
                            sim] + advance_from_command[fr] + filter_command[
                                filter] + fill_command[fill]
                        if sql in shouldPass2:        
                            tdSql.query(sql)
                        else:
                            tdSql.error(sql)                    
    def stop(self):
        tdSql.close()
        tdLog.success("%s successfully executed" % __file__)


tdCases.addWindows(__file__, TDTestCase())
tdCases.addLinux(__file__, TDTestCase())
