/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 304
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOperatorType yy60;
  SNode* yy104;
  SToken yy129;
  bool yy185;
  int32_t yy196;
  SAlterOption yy253;
  SNodeList* yy312;
  SDataType yy336;
  EOrder yy354;
  ENullOrder yy489;
  EJoinType yy532;
  EFillMode yy550;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYNSTATE             511
#define YYNRULE              390
#define YYNTOKEN             201
#define YY_MAX_SHIFT         510
#define YY_MIN_SHIFTREDUCE   762
#define YY_MAX_SHIFTREDUCE   1151
#define YY_ERROR_ACTION      1152
#define YY_ACCEPT_ACTION     1153
#define YY_NO_ACTION         1154
#define YY_MIN_REDUCE        1155
#define YY_MAX_REDUCE        1544
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1461)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1250,  441,  441,  266,  441, 1246, 1413,   72,  305,  307,
 /*    10 */    72,  111,   31,   29,  349,  409,  253,  355,   21, 1263,
 /*    20 */   262, 1153,  990, 1261, 1261,  270, 1261, 1429,   32,   30,
 /*    30 */    28,   27,   26, 1399,  412,  441,  234,   98,  988,  117,
 /*    40 */   409,  306, 1399, 1014,  427, 1395, 1401,   11, 1386, 1429,
 /*    50 */  1301,   31,   29, 1094, 1395, 1401,  425, 1261,  799,  262,
 /*    60 */   798,  990,   98,  409,   69, 1414, 1415, 1418, 1462,    1,
 /*    70 */    96,  277,  255, 1458,  120, 1413, 1308,  988,  800,  411,
 /*    80 */   121, 1469, 1470, 1308, 1474,   98,   11, 1340,  402,  252,
 /*    90 */    31,   29,  507, 1490, 1306,   96, 1429, 1252,  262,  326,
 /*   100 */   990,  440, 1523,  425,  989,  122, 1469, 1470,    1, 1474,
 /*   110 */    23,   25,  191,  427, 1399,  125,  988, 1386,   96, 1521,
 /*   120 */    32,   30,   28,   27,   26,   11, 1395, 1402,  123, 1469,
 /*   130 */  1470,  507, 1474,   70, 1414, 1415, 1418, 1462,  991, 1386,
 /*   140 */   440, 1461, 1458,  989,  135,  134, 1413,    1,   32,   30,
 /*   150 */    28,   27,   26,  186,   65,  994,  995, 1038, 1039, 1040,
 /*   160 */  1041, 1042, 1043, 1044, 1045,   99,  233, 1429, 1010, 1406,
 /*   170 */   507,  300, 1253,  299,  425,  319,  126,  991,  331, 1010,
 /*   180 */   428, 1404,  989,  265,  427,  273, 1348,  332, 1386,   12,
 /*   190 */  1413,  126, 1339, 1341,  994,  995, 1038, 1039, 1040, 1041,
 /*   200 */  1042, 1043, 1044, 1045,   69, 1414, 1415, 1418, 1462,  441,
 /*   210 */   126, 1429,  255, 1458, 1535,  312,  991, 1239,  425, 1308,
 /*   220 */   159,  441, 1336, 1496,  352,  267,  440,  313,  427,  133,
 /*   230 */  1306, 1261, 1386,  994,  995, 1038, 1039, 1040, 1041, 1042,
 /*   240 */  1043, 1044, 1045, 1261, 1237,  354,   31,   29,   70, 1414,
 /*   250 */  1415, 1418, 1462,  340,  262,  330,  990, 1459,  325,  324,
 /*   260 */   323,  322,  321,  340,  318,  317,  316,  315,  311,  310,
 /*   270 */   309,  308,  988,   84, 1118,   12,   83,   82,   81,   80,
 /*   280 */    79,   78,   77,   76,   75,   31,   29,  426, 1156,  362,
 /*   290 */   476,  357,  301,  262,  361,  990,  126,  160,  213,  358,
 /*   300 */   356, 1291,  359,    7,  396, 1116, 1117, 1119, 1120,   84,
 /*   310 */  1178,  988,   83,   82,   81,   80,   79,   78,   77,   76,
 /*   320 */    75,  441, 1308, 1523,   31,   29,  507,  339,  274,  399,
 /*   330 */   476,  441,  262, 1306,  990,  126,  125, 1258,  989,  114,
 /*   340 */  1521, 1225,    7, 1261, 1012,   32,   30,   28,   27,   26,
 /*   350 */   988,  131, 1386, 1261,  874,  464,  463,  462,  878,  461,
 /*   360 */   880,  881,  460,  883,  457,  507,  889,  454,  891,  892,
 /*   370 */   451,  448,  991, 1177,  113,   48, 1167,  989,   47,  403,
 /*   380 */  1413,    7,  404,  400,   32,   30,   28,   27,   26,  994,
 /*   390 */   995, 1038, 1039, 1040, 1041, 1042, 1043, 1044, 1045,  441,
 /*   400 */  1523, 1429, 1201, 1108,  507,  438,  111,  385,  425, 1013,
 /*   410 */   126,  991, 1176, 1522, 1264, 1386,  989, 1521,  427,  503,
 /*   420 */   502, 1261, 1386,   32,   30,   28,   27,   26,  994,  995,
 /*   430 */  1038, 1039, 1040, 1041, 1042, 1043, 1044, 1045,  115, 1414,
 /*   440 */  1415, 1418,    6,   32,   30,   28,   27,   26,  386,  272,
 /*   450 */   991,  362, 1015,  357, 1386, 1248,  361,  111,  236,  160,
 /*   460 */   246,  358,  356, 1175,  359, 1263, 1413,  994,  995, 1038,
 /*   470 */  1039, 1040, 1041, 1042, 1043, 1044, 1045, 1537,  236, 1523,
 /*   480 */    31,   29,  159,    9,    8, 1011,  352, 1429,  262, 1057,
 /*   490 */   990, 1155,  125, 1059,  425,  292, 1521,  247,  376,  245,
 /*   500 */   244, 1026,  351, 1148,  427, 1386,  988,  354, 1386, 1057,
 /*   510 */   294, 1063, 1174,  413, 1173,   93,   92,   91,   90,   89,
 /*   520 */    88,   87,   86,   85,   68, 1414, 1415, 1418, 1462, 1523,
 /*   530 */    50,  275,  235, 1458,   22, 1058,  416,    1, 1308,  111,
 /*   540 */    95,   50,  125, 1172, 1523,  441, 1521, 1263, 1256, 1307,
 /*   550 */   798,  439, 1070, 1062, 1386, 1058, 1386,  125,  467, 1257,
 /*   560 */   507, 1521,  172,  417,  441,  441,  347, 1261, 1171, 1147,
 /*   570 */   205,  276,  989, 1062, 1089, 1170,   24,  260, 1052, 1053,
 /*   580 */  1054, 1055, 1056, 1060, 1061, 1386, 1261, 1261, 1244,   32,
 /*   590 */    30,   28,   27,   26, 1169, 1166,   24,  260, 1052, 1053,
 /*   600 */  1054, 1055, 1056, 1060, 1061, 1198,  991,   28,   27,   26,
 /*   610 */  1386,  147,  428, 1101,  119, 1093,  112, 1386, 1349, 1012,
 /*   620 */   345,  219,  146,  994,  995, 1038, 1039, 1040, 1041, 1042,
 /*   630 */  1043, 1044, 1045,  217, 1165, 1476, 1386, 1386, 1164, 1163,
 /*   640 */  1162, 1161, 1160,  136, 1159, 1158,   51, 1026,  420,  144,
 /*   650 */   998, 1413, 1375, 1473,  495,  494,  493,  492,  491,  490,
 /*   660 */   489,  488,  207,  485,  484,  483,  482,  481,  480,  479,
 /*   670 */   478,  477, 1429, 1476, 1476,  424, 1386,  165,   58,  425,
 /*   680 */  1386, 1386, 1386, 1386, 1386,  466, 1386, 1386,  284,  427,
 /*   690 */   418, 1472, 1471, 1386, 1481, 1089, 1254,  486,  152, 1413,
 /*   700 */   295,  150,  374,  143,   67,  138,  384,  140, 1168,   69,
 /*   710 */  1414, 1415, 1418, 1462, 1226,  372, 1001,  255, 1458, 1535,
 /*   720 */  1429, 1194, 1189,  154,  137,  415,  153,  412, 1519,   46,
 /*   730 */    45,  304,  156,  130, 1187,  155,  158,  427,  298,  157,
 /*   740 */  1302, 1386, 1413,  363,  365,   64,  242,  188,  290,  397,
 /*   750 */   286,  282,  127,    9,    8,   60,  368,   69, 1414, 1415,
 /*   760 */  1418, 1462,  181, 1429,  346,  255, 1458,  120,  104,   44,
 /*   770 */   425,  388, 1115,  175,  126,  997,  177,  421, 1413,  187,
 /*   780 */   427, 1150, 1151, 1049, 1386,  392, 1489,   33, 1092,  410,
 /*   790 */  1064,   33,   33,  194, 1023,  957,  196, 1492, 1430, 1429,
 /*   800 */    69, 1414, 1415, 1418, 1462, 1413,  425,  190,  255, 1458,
 /*   810 */  1535,  101,  102,    2,  433,  202,  427, 1010,  104, 1480,
 /*   820 */  1386,  867,  283,  279,  241,  413, 1429,  409,  510,  243,
 /*   830 */   966,   44,  841,  425,  862,  211,  225, 1414, 1415, 1418,
 /*   840 */   320, 1000,  210,  427,  314,   94, 1338, 1386,  132,   98,
 /*   850 */   333,  499,  446,  209,  102,  895, 1523,  899,  103,  104,
 /*   860 */  1413,  905,  904,   70, 1414, 1415, 1418, 1462,  413,  125,
 /*   870 */   328,  423, 1458, 1521, 1019,  327,  329,   66,  334, 1018,
 /*   880 */   203, 1429,   96,  102,  335,  336,  105,  139,  425,  337,
 /*   890 */  1017,  338,  184, 1469,  408,  142,  407,   49,  427, 1523,
 /*   900 */   341,  145, 1386, 1016, 1413,  348,   74,  350,  379, 1413,
 /*   910 */   437, 1251,  125,  149,  378,  380, 1521, 1247,  115, 1414,
 /*   920 */  1415, 1418,  151,  106,  353, 1429,  360,  377,  107, 1249,
 /*   930 */  1429, 1015,  425, 1245,  108,  391,  109,  425,  168,  167,
 /*   940 */   170,  251,  427,  387,  398,  389, 1386,  427, 1493,  261,
 /*   950 */   390, 1386,  431,  974,  393,  164,  414, 1536,  383, 1503,
 /*   960 */   995,  173,  229, 1414, 1415, 1418, 1413,  229, 1414, 1415,
 /*   970 */  1418, 1413, 1502,  395,    5,  176, 1089,  394,  254,  406,
 /*   980 */  1483,   97,  401,    4, 1014,   17,   34, 1429,  256, 1477,
 /*   990 */   422,  183, 1429,  419,  425, 1347,  429,  435,  198,  425,
 /*  1000 */   430,  264,  182,  180,  427,  118, 1346, 1413, 1386,  427,
 /*  1010 */  1444,  434, 1262, 1386,  436, 1413,  259,  200,   59,   57,
 /*  1020 */   212, 1520,  214,  208,  228, 1414, 1415, 1418, 1429,  229,
 /*  1030 */  1414, 1415, 1418,  473,  444,  425, 1429,  189,  487,  506,
 /*  1040 */   220, 1413, 1538,  425,  221,  427,   40,  216, 1380, 1386,
 /*  1050 */  1413,  218,  263,  427, 1379,  278,  405, 1386, 1376,  280,
 /*  1060 */   281,  984, 1429,  285,  985,  229, 1414, 1415, 1418,  425,
 /*  1070 */   128, 1429, 1374,  222, 1414, 1415, 1418, 1413,  425,  427,
 /*  1080 */   287,  288,  289, 1386, 1373, 1413, 1372,  291,  427, 1363,
 /*  1090 */   293,  129, 1386,  296,  297,  969, 1357,  968, 1429,  227,
 /*  1100 */  1414, 1415, 1418, 1356,  303,  425, 1429,  302,  230, 1414,
 /*  1110 */  1415, 1418, 1355,  425, 1354,  427,  940, 1331, 1330, 1386,
 /*  1120 */  1329, 1413, 1328,  427, 1327, 1326, 1413, 1386, 1325, 1324,
 /*  1130 */  1323, 1322, 1321, 1320, 1319,  223, 1414, 1415, 1418,  100,
 /*  1140 */  1318, 1317, 1429,  231, 1414, 1415, 1418, 1429, 1316,  425,
 /*  1150 */  1315, 1314, 1313, 1312,  425, 1311, 1310,  942, 1309,  427,
 /*  1160 */  1200, 1371, 1413, 1386,  427, 1365, 1353, 1413, 1386, 1344,
 /*  1170 */   141, 1240, 1199, 1413,  811, 1197,  342, 1186,  343,  224,
 /*  1180 */  1414, 1415, 1418, 1429,  232, 1414, 1415, 1418, 1429,  344,
 /*  1190 */   425, 1185, 1182, 1242, 1429,  425,  910,   73, 1241,  148,
 /*  1200 */   427,  425,  912,  486, 1386,  427,  840, 1195,  839, 1386,
 /*  1210 */   248,  427, 1190, 1188, 1413, 1386,  838,  837,  835,  834,
 /*  1220 */  1426, 1414, 1415, 1418,  249, 1425, 1414, 1415, 1418, 1413,
 /*  1230 */   250, 1424, 1414, 1415, 1418, 1429,  366,  369,  269,  268,
 /*  1240 */  1413,  371,  425, 1181, 1180,  373, 1370,   71, 1003, 1238,
 /*  1250 */  1429,   43,  427,  163,  976, 1413, 1386,  425, 1364,  110,
 /*  1260 */   381, 1429, 1352,  990,  996, 1236, 1351,  427,  425,  382,
 /*  1270 */   166, 1386,  239, 1414, 1415, 1418, 1429,   37,  427,  988,
 /*  1280 */  1343, 1413, 1386,  425,   52,  169,  116,  238, 1414, 1415,
 /*  1290 */  1418,    3,  367,  427,  178,   33,   38, 1386,  240, 1414,
 /*  1300 */  1415, 1418, 1429,  174, 1114,   19,  206,  375,  171,  425,
 /*  1310 */   472, 1404,  179,  237, 1414, 1415, 1418,   14,  442,  427,
 /*  1320 */  1107,  162,  206, 1386,  370,   53,  472,   20,  185,  364,
 /*  1330 */   999,  474,  161,  507,   15,  124,   35, 1086, 1085,  226,
 /*  1340 */  1414, 1415, 1418,   36, 1141,  989,   16,  474,   54, 1136,
 /*  1350 */   471,  470,  469,   10,  468, 1135,   42,  257, 1140,   41,
 /*  1360 */  1139,  258,    8,  192, 1004, 1050,  471,  470,  469, 1024,
 /*  1370 */   468,   13,   18, 1342,  193, 1112,  195,  197,   55,  991,
 /*  1380 */   432, 1007,  995,  199,  201,   56, 1005, 1403,  896,   60,
 /*  1390 */    39,  445,  271,  204,  443,  447,  994,  995,  893,  449,
 /*  1400 */   450,  452,  890,  453,  455,  884,  456,  458,  882,  888,
 /*  1410 */   459,  873,  465,  907,   61,   62,   63,  906,  887,  886,
 /*  1420 */   903,  885,  901,  831,  809,  475,  830,  823,  829,  828,
 /*  1430 */   827,  826,  825,  824,  842,  821,  820,  819, 1196, 1184,
 /*  1440 */   818,  817,  816, 1183,  815,  814,  496,  497,  500,  501,
 /*  1450 */  1179,  504,  498,  505, 1154,  992,  215,  508, 1154, 1154,
 /*  1460 */   509,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   226,  210,  210,  217,  210,  226,  204,  216,  216,  210,
 /*    10 */   216,  225,   12,   13,  223,  210,  229,  223,    2,  233,
 /*    20 */    20,  201,   22,  232,  232,  229,  232,  225,   12,   13,
 /*    30 */    14,   15,   16,  246,  232,  210,  237,  232,   38,  224,
 /*    40 */   210,  216,  246,   20,  242,  258,  259,   47,  246,  225,
 /*    50 */   235,   12,   13,   14,  258,  259,  232,  232,   20,   20,
 /*    60 */    22,   22,  232,  210,  262,  263,  264,  265,  266,   69,
 /*    70 */   265,  251,  270,  271,  272,  204,  225,   38,   40,  274,
 /*    80 */   275,  276,  277,  225,  279,  232,   47,  236,  264,  231,
 /*    90 */    12,   13,   92,  291,  236,  265,  225,  204,   20,   63,
 /*   100 */    22,   20,  282,  232,  104,  275,  276,  277,   69,  279,
 /*   110 */     2,  267,  268,  242,  246,  295,   38,  246,  265,  299,
 /*   120 */    12,   13,   14,   15,   16,   47,  258,  259,  275,  276,
 /*   130 */   277,   92,  279,  262,  263,  264,  265,  266,  138,  246,
 /*   140 */    20,  270,  271,  104,  108,  109,  204,   69,   12,   13,
 /*   150 */    14,   15,   16,  130,  209,  155,  156,  157,  158,  159,
 /*   160 */   160,  161,  162,  163,  164,  220,   18,  225,   20,   69,
 /*   170 */    92,  137,  227,  139,  232,   27,  176,  138,   30,   20,
 /*   180 */   242,   81,  104,  245,  242,  234,  248,   39,  246,   69,
 /*   190 */   204,  176,  241,  242,  155,  156,  157,  158,  159,  160,
 /*   200 */   161,  162,  163,  164,  262,  263,  264,  265,  266,  210,
 /*   210 */   176,  225,  270,  271,  272,  216,  138,    0,  232,  225,
 /*   220 */    57,  210,  232,  281,   61,  231,   20,  216,  242,  239,
 /*   230 */   236,  232,  246,  155,  156,  157,  158,  159,  160,  161,
 /*   240 */   162,  163,  164,  232,    0,   82,   12,   13,  262,  263,
 /*   250 */   264,  265,  266,   46,   20,  107,   22,  271,  110,  111,
 /*   260 */   112,  113,  114,   46,  116,  117,  118,  119,  120,  121,
 /*   270 */   122,  123,   38,   21,  155,   69,   24,   25,   26,   27,
 /*   280 */    28,   29,   30,   31,   32,   12,   13,   14,    0,   49,
 /*   290 */    46,   51,  251,   20,   54,   22,  176,   57,  218,   59,
 /*   300 */    60,  221,   62,   69,  185,  186,  187,  188,  189,   21,
 /*   310 */   204,   38,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   320 */    32,  210,  225,  282,   12,   13,   92,  216,  231,  128,
 /*   330 */    46,  210,   20,  236,   22,  176,  295,  216,  104,  213,
 /*   340 */   299,  215,   69,  232,   20,   12,   13,   14,   15,   16,
 /*   350 */    38,   44,  246,  232,   83,   84,   85,   86,   87,   88,
 /*   360 */    89,   90,   91,   92,   93,   92,   95,   96,   97,   98,
 /*   370 */    99,  100,  138,  204,  203,   68,  205,  104,   71,   20,
 /*   380 */   204,   69,  181,  182,   12,   13,   14,   15,   16,  155,
 /*   390 */   156,  157,  158,  159,  160,  161,  162,  163,  164,  210,
 /*   400 */   282,  225,    0,   70,   92,  216,  225,  210,  232,   20,
 /*   410 */   176,  138,  204,  295,  233,  246,  104,  299,  242,  207,
 /*   420 */   208,  232,  246,   12,   13,   14,   15,   16,  155,  156,
 /*   430 */   157,  158,  159,  160,  161,  162,  163,  164,  262,  263,
 /*   440 */   264,  265,   43,   12,   13,   14,   15,   16,  251,  217,
 /*   450 */   138,   49,   20,   51,  246,  226,   54,  225,   47,   57,
 /*   460 */    35,   59,   60,  204,   62,  233,  204,  155,  156,  157,
 /*   470 */   158,  159,  160,  161,  162,  163,  164,  301,   47,  282,
 /*   480 */    12,   13,   57,    1,    2,   20,   61,  225,   20,   78,
 /*   490 */    22,    0,  295,  124,  232,  134,  299,   72,  251,   74,
 /*   500 */    75,   70,   77,  131,  242,  246,   38,   82,  246,   78,
 /*   510 */   149,  142,  204,  251,  204,   24,   25,   26,   27,   28,
 /*   520 */    29,   30,   31,   32,  262,  263,  264,  265,  266,  282,
 /*   530 */   212,  217,  270,  271,  165,  124,    3,   69,  225,  225,
 /*   540 */   222,  212,  295,  204,  282,  210,  299,  233,  230,  236,
 /*   550 */    22,  216,   70,  142,  246,  124,  246,  295,   80,  230,
 /*   560 */    92,  299,  130,   67,  210,  210,   38,  232,  204,  197,
 /*   570 */   216,  216,  104,  142,  175,  204,  165,  166,  167,  168,
 /*   580 */   169,  170,  171,  172,  173,  246,  232,  232,  226,   12,
 /*   590 */    13,   14,   15,   16,  204,  204,  165,  166,  167,  168,
 /*   600 */   169,  170,  171,  172,  173,    0,  138,   14,   15,   16,
 /*   610 */   246,   33,  242,   14,   36,    4,   18,  246,  248,   20,
 /*   620 */    42,   23,   44,  155,  156,  157,  158,  159,  160,  161,
 /*   630 */   162,  163,  164,   35,  204,  260,  246,  246,  204,  204,
 /*   640 */   204,  204,  204,   45,  204,  204,   68,   70,   67,   71,
 /*   650 */    38,  204,    0,  278,   49,   50,   51,   52,   53,   54,
 /*   660 */    55,   56,   57,   58,   59,   60,   61,   62,   63,   64,
 /*   670 */    65,   66,  225,  260,  260,   47,  246,  226,  209,  232,
 /*   680 */   246,  246,  246,  246,  246,  226,  246,  246,   36,  242,
 /*   690 */   194,  278,  278,  246,  174,  175,  227,   67,   73,  204,
 /*   700 */    70,   76,   21,  125,  106,  127,  254,  129,  205,  262,
 /*   710 */   263,  264,  265,  266,  215,   34,  104,  270,  271,  272,
 /*   720 */   225,    0,    0,   73,  146,  192,   76,  232,  281,  131,
 /*   730 */   132,  133,   73,  135,    0,   76,   73,  242,  140,   76,
 /*   740 */   235,  246,  204,   22,   22,   69,  148,  302,  150,  293,
 /*   750 */   152,  153,  154,    1,    2,   79,   22,  262,  263,  264,
 /*   760 */   265,  266,  287,  225,  207,  270,  271,  272,   67,   67,
 /*   770 */   232,   70,   70,   67,  176,   38,   70,  196,  204,  284,
 /*   780 */   242,  199,  200,  155,  246,  290,  291,   67,  177,  280,
 /*   790 */    70,   67,   67,   67,   70,   70,   70,  261,  225,  225,
 /*   800 */   262,  263,  264,  265,  266,  204,  232,  296,  270,  271,
 /*   810 */   272,   67,   67,  283,   70,   70,  242,   20,   67,  281,
 /*   820 */   246,   70,   36,  210,  257,  251,  225,  210,   19,  214,
 /*   830 */   136,   67,   38,  232,   70,  252,  262,  263,  264,  265,
 /*   840 */   240,  104,   33,  242,  210,   36,  210,  246,  115,  232,
 /*   850 */   210,   42,   67,   44,   67,   70,  282,   70,   67,   67,
 /*   860 */   204,   70,   70,  262,  263,  264,  265,  266,  251,  295,
 /*   870 */   124,  270,  271,  299,   20,  238,  238,   68,  256,   20,
 /*   880 */    71,  225,  265,   67,  242,  250,   70,  212,  232,  232,
 /*   890 */    20,  243,  275,  276,  277,  212,  279,  212,  242,  282,
 /*   900 */   210,  212,  246,   20,  204,  206,  210,  225,  145,  204,
 /*   910 */   101,  225,  295,  225,  256,  255,  299,  225,  262,  263,
 /*   920 */   264,  265,  225,  225,  214,  225,  214,  232,  225,  225,
 /*   930 */   225,   20,  232,  225,  225,  126,  225,  232,  129,  209,
 /*   940 */   209,  206,  242,  250,  184,  232,  246,  242,  261,  249,
 /*   950 */   243,  246,  183,  144,  249,  146,  300,  301,  242,  292,
 /*   960 */   156,  247,  262,  263,  264,  265,  204,  262,  263,  264,
 /*   970 */   265,  204,  292,  246,  191,  247,  175,  179,  246,  190,
 /*   980 */   289,  232,  246,  178,   20,   69,  115,  225,  198,  260,
 /*   990 */   195,  273,  225,  193,  232,  247,  246,  244,  232,  232,
 /*  1000 */   246,  246,  285,  288,  242,  286,  247,  204,  246,  242,
 /*  1010 */   269,  127,  232,  246,  243,  204,  249,  209,   69,  209,
 /*  1020 */   221,  298,  210,  209,  262,  263,  264,  265,  225,  262,
 /*  1030 */   263,  264,  265,  214,  228,  232,  225,  297,  214,  206,
 /*  1040 */   219,  204,  303,  232,  219,  242,  253,  211,    0,  246,
 /*  1050 */   204,  202,  249,  242,    0,   60,  294,  246,    0,   38,
 /*  1060 */   151,   38,  225,  151,   38,  262,  263,  264,  265,  232,
 /*  1070 */    38,  225,    0,  262,  263,  264,  265,  204,  232,  242,
 /*  1080 */    38,   38,  151,  246,    0,  204,    0,   38,  242,    0,
 /*  1090 */    38,   69,  246,  142,  141,  104,    0,  138,  225,  262,
 /*  1100 */   263,  264,  265,    0,  134,  232,  225,   50,  262,  263,
 /*  1110 */   264,  265,    0,  232,    0,  242,   81,    0,    0,  246,
 /*  1120 */     0,  204,    0,  242,    0,    0,  204,  246,    0,    0,
 /*  1130 */     0,    0,    0,    0,    0,  262,  263,  264,  265,  115,
 /*  1140 */     0,    0,  225,  262,  263,  264,  265,  225,    0,  232,
 /*  1150 */     0,    0,    0,    0,  232,    0,    0,   22,    0,  242,
 /*  1160 */     0,    0,  204,  246,  242,    0,    0,  204,  246,    0,
 /*  1170 */    43,    0,    0,  204,   48,    0,   38,    0,   36,  262,
 /*  1180 */   263,  264,  265,  225,  262,  263,  264,  265,  225,   43,
 /*  1190 */   232,    0,    0,    0,  225,  232,   22,   78,    0,   76,
 /*  1200 */   242,  232,   38,   67,  246,  242,   38,    0,   38,  246,
 /*  1210 */    22,  242,    0,    0,  204,  246,   38,   38,   38,   38,
 /*  1220 */   262,  263,  264,  265,   22,  262,  263,  264,  265,  204,
 /*  1230 */    22,  262,  263,  264,  265,  225,   39,   38,   12,   13,
 /*  1240 */   204,   22,  232,    0,    0,   22,    0,   20,   22,    0,
 /*  1250 */   225,  130,  242,  147,   38,  204,  246,  232,    0,  143,
 /*  1260 */    22,  225,    0,   22,   38,    0,    0,  242,  232,  130,
 /*  1270 */   127,  246,  262,  263,  264,  265,  225,  130,  242,   38,
 /*  1280 */     0,  204,  246,  232,   69,   43,   69,  262,  263,  264,
 /*  1290 */   265,   67,    4,  242,   69,   67,   67,  246,  262,  263,
 /*  1300 */   264,  265,  225,   70,   70,   69,   57,   19,  125,  232,
 /*  1310 */    61,   81,   67,  262,  263,  264,  265,  180,   92,  242,
 /*  1320 */    70,   33,   57,  246,   36,   69,   61,   67,   81,   41,
 /*  1330 */   104,   82,   44,   92,  180,   81,  174,   70,   70,  262,
 /*  1340 */   263,  264,  265,   67,   70,  104,   67,   82,    4,   38,
 /*  1350 */   101,  102,  103,  180,  105,   38,   68,   38,   38,   71,
 /*  1360 */    38,   38,    2,   81,  138,  155,  101,  102,  103,   70,
 /*  1370 */   105,   69,   69,    0,   70,   70,   69,   69,   69,  138,
 /*  1380 */   128,  155,  156,   43,  125,   69,   22,   81,   70,   79,
 /*  1390 */    69,   38,   38,   81,   80,   69,  155,  156,   70,   38,
 /*  1400 */    69,   38,   70,   69,   38,   70,   69,   38,   70,   94,
 /*  1410 */    69,   22,   82,   38,   69,   69,   69,  104,   94,   94,
 /*  1420 */    38,   94,   22,   22,   48,   47,   38,   22,   38,   38,
 /*  1430 */    38,   38,   38,   38,   38,   38,   38,   38,    0,    0,
 /*  1440 */    38,   38,   38,    0,   38,   38,   38,   36,   38,   37,
 /*  1450 */     0,   22,   43,   21,  304,   22,   22,   21,  304,  304,
 /*  1460 */    20,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1470 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1480 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1490 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1500 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1510 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1520 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1530 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1540 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1550 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1560 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1570 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1580 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1590 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1600 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1610 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1620 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1630 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1640 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1650 */   304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
 /*  1660 */   304,  304,
};
#define YY_SHIFT_COUNT    (510)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1450)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   598,    0,   39,   78,   78,   78,   78,  234,   78,   78,
 /*    10 */   312,  468,  120,  273,  312,  312,  312,  312,  312,  312,
 /*    20 */   312,  312,  312,  312,  312,  312,  312,  312,  312,  312,
 /*    30 */   312,  312,  312,  312,  206,  206,  206,  159, 1226, 1226,
 /*    40 */    34,   81,   81,   15, 1226,   81,   81,   81,   81,   81,
 /*    50 */    81,  207,  324,  359,   15,  389,  324,   81,   81,  324,
 /*    60 */    81,  324,  389,  324,  324,   81,  284,  148,  431,  411,
 /*    70 */   411,  252,  425, 1241,  240, 1241, 1241, 1241, 1241, 1241,
 /*    80 */  1241, 1241, 1241, 1241, 1241, 1241, 1241, 1241, 1241, 1241,
 /*    90 */  1241, 1241, 1241, 1241,   38,  217,   23,   23,   23,  244,
 /*   100 */   465,  389,  324,  324,  324,  478,  271,  271,  271,  271,
 /*   110 */   271,  271,  809,  288,  402,  372,  119,  163,  201,  528,
 /*   120 */   432,  520,  399,  520,  599,  533,  611,  797,  786,  794,
 /*   130 */   694,  797,  797,  733,  746,  746,  797,  854,  389,  859,
 /*   140 */   207,  465,  870,  207,  207,  797,  207,  883,  324,  324,
 /*   150 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  794,
 /*   160 */   794,  797,  883,  465,  854,  763,  389,  859,  284,  465,
 /*   170 */   870,  284,  911,  760,  769,  804,  760,  769,  804,  804,
 /*   180 */   783,  789,  798,  805,  801,  465,  964,  871,  790,  795,
 /*   190 */   800,  916,  324,  769,  804,  804,  769,  804,  884,  465,
 /*   200 */   870,  284,  478,  284,  465,  949,  794,  794,  797,  284,
 /*   210 */   883, 1461, 1461, 1461, 1461, 1461,  605,  578,  491, 1288,
 /*   220 */  1249, 1265,  333,   16,  108,  577,  136,  136,  136,  136,
 /*   230 */   136,  136,  136,  307,   36,  482,  369,  593,  593,  593,
 /*   240 */   593,  652,  361,  630,  625,  650,  659,  663,  721,  722,
 /*   250 */   734,  681,  701,  702,  706,  752,  582,  496,  581,  720,
 /*   260 */   628,  724,  100,  725,  726,  744,  745,  751,  612,  737,
 /*   270 */   764,  785,  787,  791,  792,  816,  676, 1048, 1054,  995,
 /*   280 */  1058, 1021,  909, 1023, 1026, 1032,  912, 1072, 1042, 1043,
 /*   290 */   931, 1084, 1049, 1086, 1052, 1089, 1022,  951,  953,  991,
 /*   300 */   959, 1096, 1103, 1057,  970, 1112, 1114, 1035, 1117, 1118,
 /*   310 */  1120, 1122, 1124, 1125, 1128, 1129, 1130, 1131, 1132, 1133,
 /*   320 */  1134, 1024, 1140, 1141, 1148, 1150, 1151, 1152, 1135, 1153,
 /*   330 */  1155, 1156, 1158, 1160, 1161, 1165, 1166, 1169, 1127, 1171,
 /*   340 */  1126, 1172, 1175, 1138, 1142, 1146, 1177, 1191, 1192, 1193,
 /*   350 */  1119, 1123, 1164, 1136, 1174, 1198, 1168, 1170, 1178, 1179,
 /*   360 */  1136, 1180, 1181, 1207, 1188, 1212, 1202, 1197, 1213, 1208,
 /*   370 */  1199, 1243, 1219, 1244, 1223, 1227, 1246, 1121, 1106, 1216,
 /*   380 */  1258, 1116, 1238, 1139, 1143, 1262, 1266, 1147, 1280, 1215,
 /*   390 */  1242, 1183, 1224, 1228, 1137, 1233, 1229, 1234, 1217, 1225,
 /*   400 */  1236, 1250, 1245, 1230, 1256, 1260, 1154, 1267, 1268, 1247,
 /*   410 */  1162, 1276, 1254, 1274, 1279, 1173, 1344, 1311, 1317, 1319,
 /*   420 */  1320, 1322, 1323, 1360, 1210, 1282, 1299, 1302, 1303, 1304,
 /*   430 */  1305, 1307, 1308, 1252, 1309, 1373, 1340, 1259, 1316, 1310,
 /*   440 */  1306, 1312, 1364, 1321, 1314, 1318, 1353, 1354, 1326, 1328,
 /*   450 */  1361, 1331, 1332, 1363, 1334, 1335, 1366, 1337, 1338, 1369,
 /*   460 */  1341, 1315, 1324, 1325, 1327, 1389, 1330, 1345, 1375, 1313,
 /*   470 */  1346, 1347, 1382, 1136, 1400, 1376, 1378, 1401, 1388, 1390,
 /*   480 */  1391, 1392, 1393, 1394, 1395, 1405, 1396, 1136, 1397, 1398,
 /*   490 */  1399, 1402, 1403, 1404, 1406, 1407, 1438, 1408, 1411, 1409,
 /*   500 */  1439, 1410, 1412, 1443, 1450, 1429, 1432, 1433, 1434, 1436,
 /*   510 */  1440,
};
#define YY_REDUCE_COUNT (215)
#define YY_REDUCE_MIN   (-226)
#define YY_REDUCE_MAX   (1077)
static const short yy_reduce_ofst[] = {
 /*     0 */  -180,  262,  495, -198,  -58,  447,  538,  574, -129,  601,
 /*    10 */   656,  -14,  617,  700,  705,  762,  176,  767,  803,  811,
 /*    20 */   837,  846,  873,  881,  917,  922,  958,  963,  969, 1010,
 /*    30 */  1025, 1036, 1051, 1077, -195, -170, -147,  197, -213, -204,
 /*    40 */    41, -209, -206,  247, -132, -208, -175,   -1,   11,  111,
 /*    50 */   121,  318, -142, -176,  118,  -62, -214,  189,  335,   -6,
 /*    60 */   354,  232,  -49,   97,  314,  355,  -55, -201, -156, -156,
 /*    70 */  -156,  171, -185, -107,  126,  106,  169,  208,  259,  308,
 /*    80 */   310,  339,  364,  371,  390,  391,  430,  434,  435,  436,
 /*    90 */   437,  438,  440,  441,  212,  329,  375,  413,  414,  469,
 /*   100 */   -10,  370,  181, -149,  313,   80, -226, -221,  229,  362,
 /*   110 */   451,  459,  452,  503,  499,  445,  456,  505,  475,  557,
 /*   120 */   536,  509,  509,  509,  573,  511,  530,  613,  567,  615,
 /*   130 */   583,  634,  636,  600,  637,  638,  640,  622,  642,  635,
 /*   140 */   675,  657,  648,  683,  685,  690,  689,  699,  682,  686,
 /*   150 */   688,  692,  697,  698,  703,  704,  708,  709,  711,  710,
 /*   160 */   712,  696,  735,  695,  658,  660,  716,  693,  730,  713,
 /*   170 */   707,  731,  687,  667,  714,  727,  680,  728,  732,  736,
 /*   180 */   691,  715,  719,  717,  509,  749,  729,  718,  739,  723,
 /*   190 */   740,  741,  573,  748,  750,  754,  759,  755,  753,  766,
 /*   200 */   771,  808,  799,  810,  780,  806,  819,  824,  812,  814,
 /*   210 */   833,  793,  821,  825,  836,  849,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*    10 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*    20 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*    30 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*    40 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*    50 */  1152, 1205, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*    60 */  1152, 1152, 1152, 1152, 1152, 1152, 1203, 1332, 1152, 1464,
 /*    70 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*    80 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*    90 */  1152, 1152, 1152, 1152, 1152, 1205, 1475, 1475, 1475, 1203,
 /*   100 */  1152, 1152, 1152, 1152, 1152, 1290, 1152, 1152, 1152, 1152,
 /*   110 */  1152, 1152, 1366, 1152, 1152, 1539, 1152, 1243, 1499, 1152,
 /*   120 */  1491, 1467, 1481, 1468, 1152, 1524, 1484, 1152, 1152, 1152,
 /*   130 */  1358, 1152, 1152, 1337, 1334, 1334, 1152, 1152, 1152, 1152,
 /*   140 */  1205, 1152, 1152, 1205, 1205, 1152, 1205, 1152, 1152, 1152,
 /*   150 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   160 */  1152, 1152, 1152, 1152, 1152, 1368, 1152, 1152, 1203, 1152,
 /*   170 */  1152, 1203, 1152, 1506, 1504, 1152, 1506, 1504, 1152, 1152,
 /*   180 */  1518, 1514, 1497, 1495, 1481, 1152, 1152, 1152, 1542, 1530,
 /*   190 */  1526, 1152, 1152, 1504, 1152, 1152, 1504, 1152, 1345, 1152,
 /*   200 */  1152, 1203, 1152, 1203, 1152, 1259, 1152, 1152, 1152, 1203,
 /*   210 */  1152, 1360, 1293, 1293, 1206, 1157, 1152, 1152, 1152, 1152,
 /*   220 */  1152, 1152, 1152, 1152, 1152, 1152, 1428, 1517, 1516, 1427,
 /*   230 */  1441, 1440, 1439, 1152, 1152, 1152, 1152, 1422, 1423, 1421,
 /*   240 */  1420, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   250 */  1152, 1152, 1152, 1152, 1152, 1465, 1152, 1527, 1531, 1152,
 /*   260 */  1152, 1152, 1405, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   270 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   280 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   290 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   300 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   310 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   320 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   330 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   340 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   350 */  1152, 1152, 1152, 1304, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   360 */  1229, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   370 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   380 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   390 */  1152, 1152, 1488, 1498, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   400 */  1152, 1152, 1152, 1405, 1152, 1515, 1152, 1474, 1470, 1152,
 /*   410 */  1152, 1466, 1152, 1152, 1525, 1152, 1152, 1152, 1152, 1152,
 /*   420 */  1152, 1152, 1152, 1460, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   430 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   440 */  1404, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1287, 1152,
 /*   450 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   460 */  1152, 1272, 1270, 1269, 1268, 1152, 1265, 1152, 1152, 1152,
 /*   470 */  1152, 1152, 1152, 1295, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   480 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1215, 1152, 1152,
 /*   490 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   500 */  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152,
 /*   510 */  1152,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "DATABASE",
  /*   45 */ "USE",
  /*   46 */ "IF",
  /*   47 */ "NOT",
  /*   48 */ "EXISTS",
  /*   49 */ "BLOCKS",
  /*   50 */ "CACHE",
  /*   51 */ "CACHELAST",
  /*   52 */ "COMP",
  /*   53 */ "DAYS",
  /*   54 */ "FSYNC",
  /*   55 */ "MAXROWS",
  /*   56 */ "MINROWS",
  /*   57 */ "KEEP",
  /*   58 */ "PRECISION",
  /*   59 */ "QUORUM",
  /*   60 */ "REPLICA",
  /*   61 */ "TTL",
  /*   62 */ "WAL",
  /*   63 */ "VGROUPS",
  /*   64 */ "SINGLE_STABLE",
  /*   65 */ "STREAM_MODE",
  /*   66 */ "RETENTIONS",
  /*   67 */ "NK_COMMA",
  /*   68 */ "TABLE",
  /*   69 */ "NK_LP",
  /*   70 */ "NK_RP",
  /*   71 */ "STABLE",
  /*   72 */ "ADD",
  /*   73 */ "COLUMN",
  /*   74 */ "MODIFY",
  /*   75 */ "RENAME",
  /*   76 */ "TAG",
  /*   77 */ "SET",
  /*   78 */ "NK_EQ",
  /*   79 */ "USING",
  /*   80 */ "TAGS",
  /*   81 */ "NK_DOT",
  /*   82 */ "COMMENT",
  /*   83 */ "BOOL",
  /*   84 */ "TINYINT",
  /*   85 */ "SMALLINT",
  /*   86 */ "INT",
  /*   87 */ "INTEGER",
  /*   88 */ "BIGINT",
  /*   89 */ "FLOAT",
  /*   90 */ "DOUBLE",
  /*   91 */ "BINARY",
  /*   92 */ "TIMESTAMP",
  /*   93 */ "NCHAR",
  /*   94 */ "UNSIGNED",
  /*   95 */ "JSON",
  /*   96 */ "VARCHAR",
  /*   97 */ "MEDIUMBLOB",
  /*   98 */ "BLOB",
  /*   99 */ "VARBINARY",
  /*  100 */ "DECIMAL",
  /*  101 */ "SMA",
  /*  102 */ "ROLLUP",
  /*  103 */ "FILE_FACTOR",
  /*  104 */ "NK_FLOAT",
  /*  105 */ "DELAY",
  /*  106 */ "SHOW",
  /*  107 */ "DATABASES",
  /*  108 */ "TABLES",
  /*  109 */ "STABLES",
  /*  110 */ "MNODES",
  /*  111 */ "MODULES",
  /*  112 */ "QNODES",
  /*  113 */ "FUNCTIONS",
  /*  114 */ "INDEXES",
  /*  115 */ "FROM",
  /*  116 */ "ACCOUNTS",
  /*  117 */ "APPS",
  /*  118 */ "CONNECTIONS",
  /*  119 */ "LICENCE",
  /*  120 */ "QUERIES",
  /*  121 */ "SCORES",
  /*  122 */ "TOPICS",
  /*  123 */ "VARIABLES",
  /*  124 */ "LIKE",
  /*  125 */ "INDEX",
  /*  126 */ "FULLTEXT",
  /*  127 */ "FUNCTION",
  /*  128 */ "INTERVAL",
  /*  129 */ "TOPIC",
  /*  130 */ "AS",
  /*  131 */ "DESC",
  /*  132 */ "DESCRIBE",
  /*  133 */ "RESET",
  /*  134 */ "QUERY",
  /*  135 */ "EXPLAIN",
  /*  136 */ "ANALYZE",
  /*  137 */ "VERBOSE",
  /*  138 */ "NK_BOOL",
  /*  139 */ "RATIO",
  /*  140 */ "COMPACT",
  /*  141 */ "VNODES",
  /*  142 */ "IN",
  /*  143 */ "OUTPUTTYPE",
  /*  144 */ "AGGREGATE",
  /*  145 */ "BUFSIZE",
  /*  146 */ "STREAM",
  /*  147 */ "INTO",
  /*  148 */ "KILL",
  /*  149 */ "CONNECTION",
  /*  150 */ "MERGE",
  /*  151 */ "VGROUP",
  /*  152 */ "REDISTRIBUTE",
  /*  153 */ "SPLIT",
  /*  154 */ "SYNCDB",
  /*  155 */ "NULL",
  /*  156 */ "NK_VARIABLE",
  /*  157 */ "NOW",
  /*  158 */ "ROWTS",
  /*  159 */ "TBNAME",
  /*  160 */ "QSTARTTS",
  /*  161 */ "QENDTS",
  /*  162 */ "WSTARTTS",
  /*  163 */ "WENDTS",
  /*  164 */ "WDURATION",
  /*  165 */ "BETWEEN",
  /*  166 */ "IS",
  /*  167 */ "NK_LT",
  /*  168 */ "NK_GT",
  /*  169 */ "NK_LE",
  /*  170 */ "NK_GE",
  /*  171 */ "NK_NE",
  /*  172 */ "MATCH",
  /*  173 */ "NMATCH",
  /*  174 */ "JOIN",
  /*  175 */ "INNER",
  /*  176 */ "SELECT",
  /*  177 */ "DISTINCT",
  /*  178 */ "WHERE",
  /*  179 */ "PARTITION",
  /*  180 */ "BY",
  /*  181 */ "SESSION",
  /*  182 */ "STATE_WINDOW",
  /*  183 */ "SLIDING",
  /*  184 */ "FILL",
  /*  185 */ "VALUE",
  /*  186 */ "NONE",
  /*  187 */ "PREV",
  /*  188 */ "LINEAR",
  /*  189 */ "NEXT",
  /*  190 */ "GROUP",
  /*  191 */ "HAVING",
  /*  192 */ "ORDER",
  /*  193 */ "SLIMIT",
  /*  194 */ "SOFFSET",
  /*  195 */ "LIMIT",
  /*  196 */ "OFFSET",
  /*  197 */ "ASC",
  /*  198 */ "NULLS",
  /*  199 */ "FIRST",
  /*  200 */ "LAST",
  /*  201 */ "cmd",
  /*  202 */ "account_options",
  /*  203 */ "alter_account_options",
  /*  204 */ "literal",
  /*  205 */ "alter_account_option",
  /*  206 */ "user_name",
  /*  207 */ "dnode_endpoint",
  /*  208 */ "dnode_host_name",
  /*  209 */ "not_exists_opt",
  /*  210 */ "db_name",
  /*  211 */ "db_options",
  /*  212 */ "exists_opt",
  /*  213 */ "alter_db_options",
  /*  214 */ "integer_list",
  /*  215 */ "alter_db_option",
  /*  216 */ "full_table_name",
  /*  217 */ "column_def_list",
  /*  218 */ "tags_def_opt",
  /*  219 */ "table_options",
  /*  220 */ "multi_create_clause",
  /*  221 */ "tags_def",
  /*  222 */ "multi_drop_clause",
  /*  223 */ "alter_table_clause",
  /*  224 */ "alter_table_options",
  /*  225 */ "column_name",
  /*  226 */ "type_name",
  /*  227 */ "create_subtable_clause",
  /*  228 */ "specific_tags_opt",
  /*  229 */ "literal_list",
  /*  230 */ "drop_table_clause",
  /*  231 */ "col_name_list",
  /*  232 */ "table_name",
  /*  233 */ "column_def",
  /*  234 */ "func_name_list",
  /*  235 */ "alter_table_option",
  /*  236 */ "col_name",
  /*  237 */ "db_name_cond_opt",
  /*  238 */ "like_pattern_opt",
  /*  239 */ "table_name_cond",
  /*  240 */ "from_db_opt",
  /*  241 */ "func_name",
  /*  242 */ "function_name",
  /*  243 */ "index_name",
  /*  244 */ "index_options",
  /*  245 */ "func_list",
  /*  246 */ "duration_literal",
  /*  247 */ "sliding_opt",
  /*  248 */ "func",
  /*  249 */ "expression_list",
  /*  250 */ "topic_name",
  /*  251 */ "query_expression",
  /*  252 */ "analyze_opt",
  /*  253 */ "explain_options",
  /*  254 */ "agg_func_opt",
  /*  255 */ "bufsize_opt",
  /*  256 */ "stream_name",
  /*  257 */ "dnode_list",
  /*  258 */ "signed",
  /*  259 */ "signed_literal",
  /*  260 */ "table_alias",
  /*  261 */ "column_alias",
  /*  262 */ "expression",
  /*  263 */ "pseudo_column",
  /*  264 */ "column_reference",
  /*  265 */ "subquery",
  /*  266 */ "predicate",
  /*  267 */ "compare_op",
  /*  268 */ "in_op",
  /*  269 */ "in_predicate_value",
  /*  270 */ "boolean_value_expression",
  /*  271 */ "boolean_primary",
  /*  272 */ "common_expression",
  /*  273 */ "from_clause",
  /*  274 */ "table_reference_list",
  /*  275 */ "table_reference",
  /*  276 */ "table_primary",
  /*  277 */ "joined_table",
  /*  278 */ "alias_opt",
  /*  279 */ "parenthesized_joined_table",
  /*  280 */ "join_type",
  /*  281 */ "search_condition",
  /*  282 */ "query_specification",
  /*  283 */ "set_quantifier_opt",
  /*  284 */ "select_list",
  /*  285 */ "where_clause_opt",
  /*  286 */ "partition_by_clause_opt",
  /*  287 */ "twindow_clause_opt",
  /*  288 */ "group_by_clause_opt",
  /*  289 */ "having_clause_opt",
  /*  290 */ "select_sublist",
  /*  291 */ "select_item",
  /*  292 */ "fill_opt",
  /*  293 */ "fill_mode",
  /*  294 */ "group_by_list",
  /*  295 */ "query_expression_body",
  /*  296 */ "order_by_clause_opt",
  /*  297 */ "slimit_clause_opt",
  /*  298 */ "limit_clause_opt",
  /*  299 */ "query_primary",
  /*  300 */ "sort_specification_list",
  /*  301 */ "sort_specification",
  /*  302 */ "ordering_specification_opt",
  /*  303 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  44 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  45 */ "cmd ::= USE db_name",
 /*  46 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  47 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  48 */ "not_exists_opt ::=",
 /*  49 */ "exists_opt ::= IF EXISTS",
 /*  50 */ "exists_opt ::=",
 /*  51 */ "db_options ::=",
 /*  52 */ "db_options ::= db_options BLOCKS NK_INTEGER",
 /*  53 */ "db_options ::= db_options CACHE NK_INTEGER",
 /*  54 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  55 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  56 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  57 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  58 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  59 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  60 */ "db_options ::= db_options KEEP integer_list",
 /*  61 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  62 */ "db_options ::= db_options QUORUM NK_INTEGER",
 /*  63 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  64 */ "db_options ::= db_options TTL NK_INTEGER",
 /*  65 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  66 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  67 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  68 */ "db_options ::= db_options STREAM_MODE NK_INTEGER",
 /*  69 */ "db_options ::= db_options RETENTIONS NK_STRING",
 /*  70 */ "alter_db_options ::= alter_db_option",
 /*  71 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  72 */ "alter_db_option ::= BLOCKS NK_INTEGER",
 /*  73 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  74 */ "alter_db_option ::= KEEP integer_list",
 /*  75 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  76 */ "alter_db_option ::= QUORUM NK_INTEGER",
 /*  77 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  78 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  79 */ "integer_list ::= NK_INTEGER",
 /*  80 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /*  81 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  82 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  83 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /*  84 */ "cmd ::= DROP TABLE multi_drop_clause",
 /*  85 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /*  86 */ "cmd ::= ALTER TABLE alter_table_clause",
 /*  87 */ "cmd ::= ALTER STABLE alter_table_clause",
 /*  88 */ "alter_table_clause ::= full_table_name alter_table_options",
 /*  89 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /*  90 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /*  91 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /*  92 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /*  93 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /*  94 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /*  95 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /*  96 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /*  97 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /*  98 */ "multi_create_clause ::= create_subtable_clause",
 /*  99 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 100 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP",
 /* 101 */ "multi_drop_clause ::= drop_table_clause",
 /* 102 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 103 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 104 */ "specific_tags_opt ::=",
 /* 105 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 106 */ "full_table_name ::= table_name",
 /* 107 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 108 */ "column_def_list ::= column_def",
 /* 109 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 110 */ "column_def ::= column_name type_name",
 /* 111 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 112 */ "type_name ::= BOOL",
 /* 113 */ "type_name ::= TINYINT",
 /* 114 */ "type_name ::= SMALLINT",
 /* 115 */ "type_name ::= INT",
 /* 116 */ "type_name ::= INTEGER",
 /* 117 */ "type_name ::= BIGINT",
 /* 118 */ "type_name ::= FLOAT",
 /* 119 */ "type_name ::= DOUBLE",
 /* 120 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 121 */ "type_name ::= TIMESTAMP",
 /* 122 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 123 */ "type_name ::= TINYINT UNSIGNED",
 /* 124 */ "type_name ::= SMALLINT UNSIGNED",
 /* 125 */ "type_name ::= INT UNSIGNED",
 /* 126 */ "type_name ::= BIGINT UNSIGNED",
 /* 127 */ "type_name ::= JSON",
 /* 128 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 129 */ "type_name ::= MEDIUMBLOB",
 /* 130 */ "type_name ::= BLOB",
 /* 131 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 132 */ "type_name ::= DECIMAL",
 /* 133 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 134 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 135 */ "tags_def_opt ::=",
 /* 136 */ "tags_def_opt ::= tags_def",
 /* 137 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 138 */ "table_options ::=",
 /* 139 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 140 */ "table_options ::= table_options KEEP integer_list",
 /* 141 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 142 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 143 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 144 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 145 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 146 */ "alter_table_options ::= alter_table_option",
 /* 147 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 148 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 149 */ "alter_table_option ::= KEEP integer_list",
 /* 150 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 151 */ "col_name_list ::= col_name",
 /* 152 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 153 */ "col_name ::= column_name",
 /* 154 */ "cmd ::= SHOW DNODES",
 /* 155 */ "cmd ::= SHOW USERS",
 /* 156 */ "cmd ::= SHOW DATABASES",
 /* 157 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 158 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 159 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 160 */ "cmd ::= SHOW MNODES",
 /* 161 */ "cmd ::= SHOW MODULES",
 /* 162 */ "cmd ::= SHOW QNODES",
 /* 163 */ "cmd ::= SHOW FUNCTIONS",
 /* 164 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 165 */ "cmd ::= SHOW STREAMS",
 /* 166 */ "cmd ::= SHOW ACCOUNTS",
 /* 167 */ "cmd ::= SHOW APPS",
 /* 168 */ "cmd ::= SHOW CONNECTIONS",
 /* 169 */ "cmd ::= SHOW LICENCE",
 /* 170 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 171 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 172 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 173 */ "cmd ::= SHOW QUERIES",
 /* 174 */ "cmd ::= SHOW SCORES",
 /* 175 */ "cmd ::= SHOW TOPICS",
 /* 176 */ "cmd ::= SHOW VARIABLES",
 /* 177 */ "db_name_cond_opt ::=",
 /* 178 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 179 */ "like_pattern_opt ::=",
 /* 180 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 181 */ "table_name_cond ::= table_name",
 /* 182 */ "from_db_opt ::=",
 /* 183 */ "from_db_opt ::= FROM db_name",
 /* 184 */ "func_name_list ::= func_name",
 /* 185 */ "func_name_list ::= func_name_list NK_COMMA col_name",
 /* 186 */ "func_name ::= function_name",
 /* 187 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 188 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 189 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 190 */ "index_options ::=",
 /* 191 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 192 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 193 */ "func_list ::= func",
 /* 194 */ "func_list ::= func_list NK_COMMA func",
 /* 195 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 196 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 197 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name",
 /* 198 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 199 */ "cmd ::= DESC full_table_name",
 /* 200 */ "cmd ::= DESCRIBE full_table_name",
 /* 201 */ "cmd ::= RESET QUERY CACHE",
 /* 202 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 203 */ "analyze_opt ::=",
 /* 204 */ "analyze_opt ::= ANALYZE",
 /* 205 */ "explain_options ::=",
 /* 206 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 207 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 208 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 209 */ "cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 210 */ "cmd ::= DROP FUNCTION function_name",
 /* 211 */ "agg_func_opt ::=",
 /* 212 */ "agg_func_opt ::= AGGREGATE",
 /* 213 */ "bufsize_opt ::=",
 /* 214 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 215 */ "cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression",
 /* 216 */ "cmd ::= DROP STREAM stream_name",
 /* 217 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 218 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 219 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 220 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 221 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 222 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 223 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 224 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 225 */ "cmd ::= query_expression",
 /* 226 */ "literal ::= NK_INTEGER",
 /* 227 */ "literal ::= NK_FLOAT",
 /* 228 */ "literal ::= NK_STRING",
 /* 229 */ "literal ::= NK_BOOL",
 /* 230 */ "literal ::= TIMESTAMP NK_STRING",
 /* 231 */ "literal ::= duration_literal",
 /* 232 */ "literal ::= NULL",
 /* 233 */ "duration_literal ::= NK_VARIABLE",
 /* 234 */ "signed ::= NK_INTEGER",
 /* 235 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 236 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 237 */ "signed ::= NK_FLOAT",
 /* 238 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 239 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 240 */ "signed_literal ::= signed",
 /* 241 */ "signed_literal ::= NK_STRING",
 /* 242 */ "signed_literal ::= NK_BOOL",
 /* 243 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 244 */ "signed_literal ::= duration_literal",
 /* 245 */ "signed_literal ::= NULL",
 /* 246 */ "literal_list ::= signed_literal",
 /* 247 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 248 */ "db_name ::= NK_ID",
 /* 249 */ "table_name ::= NK_ID",
 /* 250 */ "column_name ::= NK_ID",
 /* 251 */ "function_name ::= NK_ID",
 /* 252 */ "table_alias ::= NK_ID",
 /* 253 */ "column_alias ::= NK_ID",
 /* 254 */ "user_name ::= NK_ID",
 /* 255 */ "index_name ::= NK_ID",
 /* 256 */ "topic_name ::= NK_ID",
 /* 257 */ "stream_name ::= NK_ID",
 /* 258 */ "expression ::= literal",
 /* 259 */ "expression ::= pseudo_column",
 /* 260 */ "expression ::= column_reference",
 /* 261 */ "expression ::= function_name NK_LP expression_list NK_RP",
 /* 262 */ "expression ::= function_name NK_LP NK_STAR NK_RP",
 /* 263 */ "expression ::= subquery",
 /* 264 */ "expression ::= NK_LP expression NK_RP",
 /* 265 */ "expression ::= NK_PLUS expression",
 /* 266 */ "expression ::= NK_MINUS expression",
 /* 267 */ "expression ::= expression NK_PLUS expression",
 /* 268 */ "expression ::= expression NK_MINUS expression",
 /* 269 */ "expression ::= expression NK_STAR expression",
 /* 270 */ "expression ::= expression NK_SLASH expression",
 /* 271 */ "expression ::= expression NK_REM expression",
 /* 272 */ "expression_list ::= expression",
 /* 273 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 274 */ "column_reference ::= column_name",
 /* 275 */ "column_reference ::= table_name NK_DOT column_name",
 /* 276 */ "pseudo_column ::= NOW",
 /* 277 */ "pseudo_column ::= ROWTS",
 /* 278 */ "pseudo_column ::= TBNAME",
 /* 279 */ "pseudo_column ::= QSTARTTS",
 /* 280 */ "pseudo_column ::= QENDTS",
 /* 281 */ "pseudo_column ::= WSTARTTS",
 /* 282 */ "pseudo_column ::= WENDTS",
 /* 283 */ "pseudo_column ::= WDURATION",
 /* 284 */ "predicate ::= expression compare_op expression",
 /* 285 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 286 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 287 */ "predicate ::= expression IS NULL",
 /* 288 */ "predicate ::= expression IS NOT NULL",
 /* 289 */ "predicate ::= expression in_op in_predicate_value",
 /* 290 */ "compare_op ::= NK_LT",
 /* 291 */ "compare_op ::= NK_GT",
 /* 292 */ "compare_op ::= NK_LE",
 /* 293 */ "compare_op ::= NK_GE",
 /* 294 */ "compare_op ::= NK_NE",
 /* 295 */ "compare_op ::= NK_EQ",
 /* 296 */ "compare_op ::= LIKE",
 /* 297 */ "compare_op ::= NOT LIKE",
 /* 298 */ "compare_op ::= MATCH",
 /* 299 */ "compare_op ::= NMATCH",
 /* 300 */ "in_op ::= IN",
 /* 301 */ "in_op ::= NOT IN",
 /* 302 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 303 */ "boolean_value_expression ::= boolean_primary",
 /* 304 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 305 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 306 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 307 */ "boolean_primary ::= predicate",
 /* 308 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 309 */ "common_expression ::= expression",
 /* 310 */ "common_expression ::= boolean_value_expression",
 /* 311 */ "from_clause ::= FROM table_reference_list",
 /* 312 */ "table_reference_list ::= table_reference",
 /* 313 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 314 */ "table_reference ::= table_primary",
 /* 315 */ "table_reference ::= joined_table",
 /* 316 */ "table_primary ::= table_name alias_opt",
 /* 317 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 318 */ "table_primary ::= subquery alias_opt",
 /* 319 */ "table_primary ::= parenthesized_joined_table",
 /* 320 */ "alias_opt ::=",
 /* 321 */ "alias_opt ::= table_alias",
 /* 322 */ "alias_opt ::= AS table_alias",
 /* 323 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 324 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 325 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 326 */ "join_type ::=",
 /* 327 */ "join_type ::= INNER",
 /* 328 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 329 */ "set_quantifier_opt ::=",
 /* 330 */ "set_quantifier_opt ::= DISTINCT",
 /* 331 */ "set_quantifier_opt ::= ALL",
 /* 332 */ "select_list ::= NK_STAR",
 /* 333 */ "select_list ::= select_sublist",
 /* 334 */ "select_sublist ::= select_item",
 /* 335 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 336 */ "select_item ::= common_expression",
 /* 337 */ "select_item ::= common_expression column_alias",
 /* 338 */ "select_item ::= common_expression AS column_alias",
 /* 339 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 340 */ "where_clause_opt ::=",
 /* 341 */ "where_clause_opt ::= WHERE search_condition",
 /* 342 */ "partition_by_clause_opt ::=",
 /* 343 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 344 */ "twindow_clause_opt ::=",
 /* 345 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 346 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 347 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 348 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 349 */ "sliding_opt ::=",
 /* 350 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 351 */ "fill_opt ::=",
 /* 352 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 353 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 354 */ "fill_mode ::= NONE",
 /* 355 */ "fill_mode ::= PREV",
 /* 356 */ "fill_mode ::= NULL",
 /* 357 */ "fill_mode ::= LINEAR",
 /* 358 */ "fill_mode ::= NEXT",
 /* 359 */ "group_by_clause_opt ::=",
 /* 360 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 361 */ "group_by_list ::= expression",
 /* 362 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 363 */ "having_clause_opt ::=",
 /* 364 */ "having_clause_opt ::= HAVING search_condition",
 /* 365 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 366 */ "query_expression_body ::= query_primary",
 /* 367 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 368 */ "query_primary ::= query_specification",
 /* 369 */ "order_by_clause_opt ::=",
 /* 370 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 371 */ "slimit_clause_opt ::=",
 /* 372 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 373 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 374 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 375 */ "limit_clause_opt ::=",
 /* 376 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 377 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 378 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 379 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 380 */ "search_condition ::= common_expression",
 /* 381 */ "sort_specification_list ::= sort_specification",
 /* 382 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 383 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 384 */ "ordering_specification_opt ::=",
 /* 385 */ "ordering_specification_opt ::= ASC",
 /* 386 */ "ordering_specification_opt ::= DESC",
 /* 387 */ "null_ordering_opt ::=",
 /* 388 */ "null_ordering_opt ::= NULLS FIRST",
 /* 389 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 201: /* cmd */
    case 204: /* literal */
    case 211: /* db_options */
    case 213: /* alter_db_options */
    case 216: /* full_table_name */
    case 219: /* table_options */
    case 223: /* alter_table_clause */
    case 224: /* alter_table_options */
    case 227: /* create_subtable_clause */
    case 230: /* drop_table_clause */
    case 233: /* column_def */
    case 236: /* col_name */
    case 237: /* db_name_cond_opt */
    case 238: /* like_pattern_opt */
    case 239: /* table_name_cond */
    case 240: /* from_db_opt */
    case 241: /* func_name */
    case 244: /* index_options */
    case 246: /* duration_literal */
    case 247: /* sliding_opt */
    case 248: /* func */
    case 251: /* query_expression */
    case 253: /* explain_options */
    case 258: /* signed */
    case 259: /* signed_literal */
    case 262: /* expression */
    case 263: /* pseudo_column */
    case 264: /* column_reference */
    case 265: /* subquery */
    case 266: /* predicate */
    case 269: /* in_predicate_value */
    case 270: /* boolean_value_expression */
    case 271: /* boolean_primary */
    case 272: /* common_expression */
    case 273: /* from_clause */
    case 274: /* table_reference_list */
    case 275: /* table_reference */
    case 276: /* table_primary */
    case 277: /* joined_table */
    case 279: /* parenthesized_joined_table */
    case 281: /* search_condition */
    case 282: /* query_specification */
    case 285: /* where_clause_opt */
    case 287: /* twindow_clause_opt */
    case 289: /* having_clause_opt */
    case 291: /* select_item */
    case 292: /* fill_opt */
    case 295: /* query_expression_body */
    case 297: /* slimit_clause_opt */
    case 298: /* limit_clause_opt */
    case 299: /* query_primary */
    case 301: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy104)); 
}
      break;
    case 202: /* account_options */
    case 203: /* alter_account_options */
    case 205: /* alter_account_option */
    case 255: /* bufsize_opt */
{
 
}
      break;
    case 206: /* user_name */
    case 207: /* dnode_endpoint */
    case 208: /* dnode_host_name */
    case 210: /* db_name */
    case 225: /* column_name */
    case 232: /* table_name */
    case 242: /* function_name */
    case 243: /* index_name */
    case 250: /* topic_name */
    case 256: /* stream_name */
    case 260: /* table_alias */
    case 261: /* column_alias */
    case 278: /* alias_opt */
{
 
}
      break;
    case 209: /* not_exists_opt */
    case 212: /* exists_opt */
    case 252: /* analyze_opt */
    case 254: /* agg_func_opt */
    case 283: /* set_quantifier_opt */
{
 
}
      break;
    case 214: /* integer_list */
    case 217: /* column_def_list */
    case 218: /* tags_def_opt */
    case 220: /* multi_create_clause */
    case 221: /* tags_def */
    case 222: /* multi_drop_clause */
    case 228: /* specific_tags_opt */
    case 229: /* literal_list */
    case 231: /* col_name_list */
    case 234: /* func_name_list */
    case 245: /* func_list */
    case 249: /* expression_list */
    case 257: /* dnode_list */
    case 284: /* select_list */
    case 286: /* partition_by_clause_opt */
    case 288: /* group_by_clause_opt */
    case 290: /* select_sublist */
    case 294: /* group_by_list */
    case 296: /* order_by_clause_opt */
    case 300: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy312)); 
}
      break;
    case 215: /* alter_db_option */
    case 235: /* alter_table_option */
{
 
}
      break;
    case 226: /* type_name */
{
 
}
      break;
    case 267: /* compare_op */
    case 268: /* in_op */
{
 
}
      break;
    case 280: /* join_type */
{
 
}
      break;
    case 293: /* fill_mode */
{
 
}
      break;
    case 302: /* ordering_specification_opt */
{
 
}
      break;
    case 303: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  201,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  201,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  202,    0 }, /* (2) account_options ::= */
  {  202,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  202,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  202,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  202,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  202,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  202,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  202,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  202,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  202,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  203,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  203,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  205,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  205,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  205,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  205,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  205,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  205,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  205,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  205,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  205,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  205,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  201,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  201,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  201,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  201,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  201,   -3 }, /* (28) cmd ::= CREATE DNODE dnode_endpoint */
  {  201,   -5 }, /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  201,   -3 }, /* (30) cmd ::= DROP DNODE NK_INTEGER */
  {  201,   -3 }, /* (31) cmd ::= DROP DNODE dnode_endpoint */
  {  201,   -4 }, /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  201,   -5 }, /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  201,   -4 }, /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
  {  201,   -5 }, /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  207,   -1 }, /* (36) dnode_endpoint ::= NK_STRING */
  {  208,   -1 }, /* (37) dnode_host_name ::= NK_ID */
  {  208,   -1 }, /* (38) dnode_host_name ::= NK_IPTOKEN */
  {  201,   -3 }, /* (39) cmd ::= ALTER LOCAL NK_STRING */
  {  201,   -4 }, /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  201,   -5 }, /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  201,   -5 }, /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  201,   -5 }, /* (43) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  201,   -4 }, /* (44) cmd ::= DROP DATABASE exists_opt db_name */
  {  201,   -2 }, /* (45) cmd ::= USE db_name */
  {  201,   -4 }, /* (46) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  209,   -3 }, /* (47) not_exists_opt ::= IF NOT EXISTS */
  {  209,    0 }, /* (48) not_exists_opt ::= */
  {  212,   -2 }, /* (49) exists_opt ::= IF EXISTS */
  {  212,    0 }, /* (50) exists_opt ::= */
  {  211,    0 }, /* (51) db_options ::= */
  {  211,   -3 }, /* (52) db_options ::= db_options BLOCKS NK_INTEGER */
  {  211,   -3 }, /* (53) db_options ::= db_options CACHE NK_INTEGER */
  {  211,   -3 }, /* (54) db_options ::= db_options CACHELAST NK_INTEGER */
  {  211,   -3 }, /* (55) db_options ::= db_options COMP NK_INTEGER */
  {  211,   -3 }, /* (56) db_options ::= db_options DAYS NK_INTEGER */
  {  211,   -3 }, /* (57) db_options ::= db_options FSYNC NK_INTEGER */
  {  211,   -3 }, /* (58) db_options ::= db_options MAXROWS NK_INTEGER */
  {  211,   -3 }, /* (59) db_options ::= db_options MINROWS NK_INTEGER */
  {  211,   -3 }, /* (60) db_options ::= db_options KEEP integer_list */
  {  211,   -3 }, /* (61) db_options ::= db_options PRECISION NK_STRING */
  {  211,   -3 }, /* (62) db_options ::= db_options QUORUM NK_INTEGER */
  {  211,   -3 }, /* (63) db_options ::= db_options REPLICA NK_INTEGER */
  {  211,   -3 }, /* (64) db_options ::= db_options TTL NK_INTEGER */
  {  211,   -3 }, /* (65) db_options ::= db_options WAL NK_INTEGER */
  {  211,   -3 }, /* (66) db_options ::= db_options VGROUPS NK_INTEGER */
  {  211,   -3 }, /* (67) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  211,   -3 }, /* (68) db_options ::= db_options STREAM_MODE NK_INTEGER */
  {  211,   -3 }, /* (69) db_options ::= db_options RETENTIONS NK_STRING */
  {  213,   -1 }, /* (70) alter_db_options ::= alter_db_option */
  {  213,   -2 }, /* (71) alter_db_options ::= alter_db_options alter_db_option */
  {  215,   -2 }, /* (72) alter_db_option ::= BLOCKS NK_INTEGER */
  {  215,   -2 }, /* (73) alter_db_option ::= FSYNC NK_INTEGER */
  {  215,   -2 }, /* (74) alter_db_option ::= KEEP integer_list */
  {  215,   -2 }, /* (75) alter_db_option ::= WAL NK_INTEGER */
  {  215,   -2 }, /* (76) alter_db_option ::= QUORUM NK_INTEGER */
  {  215,   -2 }, /* (77) alter_db_option ::= CACHELAST NK_INTEGER */
  {  215,   -2 }, /* (78) alter_db_option ::= REPLICA NK_INTEGER */
  {  214,   -1 }, /* (79) integer_list ::= NK_INTEGER */
  {  214,   -3 }, /* (80) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  201,   -9 }, /* (81) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  201,   -3 }, /* (82) cmd ::= CREATE TABLE multi_create_clause */
  {  201,   -9 }, /* (83) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  201,   -3 }, /* (84) cmd ::= DROP TABLE multi_drop_clause */
  {  201,   -4 }, /* (85) cmd ::= DROP STABLE exists_opt full_table_name */
  {  201,   -3 }, /* (86) cmd ::= ALTER TABLE alter_table_clause */
  {  201,   -3 }, /* (87) cmd ::= ALTER STABLE alter_table_clause */
  {  223,   -2 }, /* (88) alter_table_clause ::= full_table_name alter_table_options */
  {  223,   -5 }, /* (89) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  223,   -4 }, /* (90) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  223,   -5 }, /* (91) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  223,   -5 }, /* (92) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  223,   -5 }, /* (93) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  223,   -4 }, /* (94) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  223,   -5 }, /* (95) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  223,   -5 }, /* (96) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  223,   -6 }, /* (97) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
  {  220,   -1 }, /* (98) multi_create_clause ::= create_subtable_clause */
  {  220,   -2 }, /* (99) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  227,   -9 }, /* (100) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
  {  222,   -1 }, /* (101) multi_drop_clause ::= drop_table_clause */
  {  222,   -2 }, /* (102) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  230,   -2 }, /* (103) drop_table_clause ::= exists_opt full_table_name */
  {  228,    0 }, /* (104) specific_tags_opt ::= */
  {  228,   -3 }, /* (105) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  216,   -1 }, /* (106) full_table_name ::= table_name */
  {  216,   -3 }, /* (107) full_table_name ::= db_name NK_DOT table_name */
  {  217,   -1 }, /* (108) column_def_list ::= column_def */
  {  217,   -3 }, /* (109) column_def_list ::= column_def_list NK_COMMA column_def */
  {  233,   -2 }, /* (110) column_def ::= column_name type_name */
  {  233,   -4 }, /* (111) column_def ::= column_name type_name COMMENT NK_STRING */
  {  226,   -1 }, /* (112) type_name ::= BOOL */
  {  226,   -1 }, /* (113) type_name ::= TINYINT */
  {  226,   -1 }, /* (114) type_name ::= SMALLINT */
  {  226,   -1 }, /* (115) type_name ::= INT */
  {  226,   -1 }, /* (116) type_name ::= INTEGER */
  {  226,   -1 }, /* (117) type_name ::= BIGINT */
  {  226,   -1 }, /* (118) type_name ::= FLOAT */
  {  226,   -1 }, /* (119) type_name ::= DOUBLE */
  {  226,   -4 }, /* (120) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  226,   -1 }, /* (121) type_name ::= TIMESTAMP */
  {  226,   -4 }, /* (122) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  226,   -2 }, /* (123) type_name ::= TINYINT UNSIGNED */
  {  226,   -2 }, /* (124) type_name ::= SMALLINT UNSIGNED */
  {  226,   -2 }, /* (125) type_name ::= INT UNSIGNED */
  {  226,   -2 }, /* (126) type_name ::= BIGINT UNSIGNED */
  {  226,   -1 }, /* (127) type_name ::= JSON */
  {  226,   -4 }, /* (128) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  226,   -1 }, /* (129) type_name ::= MEDIUMBLOB */
  {  226,   -1 }, /* (130) type_name ::= BLOB */
  {  226,   -4 }, /* (131) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  226,   -1 }, /* (132) type_name ::= DECIMAL */
  {  226,   -4 }, /* (133) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  226,   -6 }, /* (134) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  218,    0 }, /* (135) tags_def_opt ::= */
  {  218,   -1 }, /* (136) tags_def_opt ::= tags_def */
  {  221,   -4 }, /* (137) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  219,    0 }, /* (138) table_options ::= */
  {  219,   -3 }, /* (139) table_options ::= table_options COMMENT NK_STRING */
  {  219,   -3 }, /* (140) table_options ::= table_options KEEP integer_list */
  {  219,   -3 }, /* (141) table_options ::= table_options TTL NK_INTEGER */
  {  219,   -5 }, /* (142) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  219,   -5 }, /* (143) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  219,   -3 }, /* (144) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  219,   -3 }, /* (145) table_options ::= table_options DELAY NK_INTEGER */
  {  224,   -1 }, /* (146) alter_table_options ::= alter_table_option */
  {  224,   -2 }, /* (147) alter_table_options ::= alter_table_options alter_table_option */
  {  235,   -2 }, /* (148) alter_table_option ::= COMMENT NK_STRING */
  {  235,   -2 }, /* (149) alter_table_option ::= KEEP integer_list */
  {  235,   -2 }, /* (150) alter_table_option ::= TTL NK_INTEGER */
  {  231,   -1 }, /* (151) col_name_list ::= col_name */
  {  231,   -3 }, /* (152) col_name_list ::= col_name_list NK_COMMA col_name */
  {  236,   -1 }, /* (153) col_name ::= column_name */
  {  201,   -2 }, /* (154) cmd ::= SHOW DNODES */
  {  201,   -2 }, /* (155) cmd ::= SHOW USERS */
  {  201,   -2 }, /* (156) cmd ::= SHOW DATABASES */
  {  201,   -4 }, /* (157) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  201,   -4 }, /* (158) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  201,   -3 }, /* (159) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  201,   -2 }, /* (160) cmd ::= SHOW MNODES */
  {  201,   -2 }, /* (161) cmd ::= SHOW MODULES */
  {  201,   -2 }, /* (162) cmd ::= SHOW QNODES */
  {  201,   -2 }, /* (163) cmd ::= SHOW FUNCTIONS */
  {  201,   -5 }, /* (164) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  201,   -2 }, /* (165) cmd ::= SHOW STREAMS */
  {  201,   -2 }, /* (166) cmd ::= SHOW ACCOUNTS */
  {  201,   -2 }, /* (167) cmd ::= SHOW APPS */
  {  201,   -2 }, /* (168) cmd ::= SHOW CONNECTIONS */
  {  201,   -2 }, /* (169) cmd ::= SHOW LICENCE */
  {  201,   -4 }, /* (170) cmd ::= SHOW CREATE DATABASE db_name */
  {  201,   -4 }, /* (171) cmd ::= SHOW CREATE TABLE full_table_name */
  {  201,   -4 }, /* (172) cmd ::= SHOW CREATE STABLE full_table_name */
  {  201,   -2 }, /* (173) cmd ::= SHOW QUERIES */
  {  201,   -2 }, /* (174) cmd ::= SHOW SCORES */
  {  201,   -2 }, /* (175) cmd ::= SHOW TOPICS */
  {  201,   -2 }, /* (176) cmd ::= SHOW VARIABLES */
  {  237,    0 }, /* (177) db_name_cond_opt ::= */
  {  237,   -2 }, /* (178) db_name_cond_opt ::= db_name NK_DOT */
  {  238,    0 }, /* (179) like_pattern_opt ::= */
  {  238,   -2 }, /* (180) like_pattern_opt ::= LIKE NK_STRING */
  {  239,   -1 }, /* (181) table_name_cond ::= table_name */
  {  240,    0 }, /* (182) from_db_opt ::= */
  {  240,   -2 }, /* (183) from_db_opt ::= FROM db_name */
  {  234,   -1 }, /* (184) func_name_list ::= func_name */
  {  234,   -3 }, /* (185) func_name_list ::= func_name_list NK_COMMA col_name */
  {  241,   -1 }, /* (186) func_name ::= function_name */
  {  201,   -8 }, /* (187) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  201,  -10 }, /* (188) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  201,   -6 }, /* (189) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  244,    0 }, /* (190) index_options ::= */
  {  244,   -9 }, /* (191) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  244,  -11 }, /* (192) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  245,   -1 }, /* (193) func_list ::= func */
  {  245,   -3 }, /* (194) func_list ::= func_list NK_COMMA func */
  {  248,   -4 }, /* (195) func ::= function_name NK_LP expression_list NK_RP */
  {  201,   -6 }, /* (196) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  201,   -6 }, /* (197) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
  {  201,   -4 }, /* (198) cmd ::= DROP TOPIC exists_opt topic_name */
  {  201,   -2 }, /* (199) cmd ::= DESC full_table_name */
  {  201,   -2 }, /* (200) cmd ::= DESCRIBE full_table_name */
  {  201,   -3 }, /* (201) cmd ::= RESET QUERY CACHE */
  {  201,   -4 }, /* (202) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  252,    0 }, /* (203) analyze_opt ::= */
  {  252,   -1 }, /* (204) analyze_opt ::= ANALYZE */
  {  253,    0 }, /* (205) explain_options ::= */
  {  253,   -3 }, /* (206) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  253,   -3 }, /* (207) explain_options ::= explain_options RATIO NK_FLOAT */
  {  201,   -6 }, /* (208) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  201,   -9 }, /* (209) cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  201,   -3 }, /* (210) cmd ::= DROP FUNCTION function_name */
  {  254,    0 }, /* (211) agg_func_opt ::= */
  {  254,   -1 }, /* (212) agg_func_opt ::= AGGREGATE */
  {  255,    0 }, /* (213) bufsize_opt ::= */
  {  255,   -2 }, /* (214) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  201,   -7 }, /* (215) cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression */
  {  201,   -3 }, /* (216) cmd ::= DROP STREAM stream_name */
  {  201,   -3 }, /* (217) cmd ::= KILL CONNECTION NK_INTEGER */
  {  201,   -3 }, /* (218) cmd ::= KILL QUERY NK_INTEGER */
  {  201,   -4 }, /* (219) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  201,   -4 }, /* (220) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  201,   -3 }, /* (221) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  257,   -2 }, /* (222) dnode_list ::= DNODE NK_INTEGER */
  {  257,   -3 }, /* (223) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  201,   -3 }, /* (224) cmd ::= SYNCDB db_name REPLICA */
  {  201,   -1 }, /* (225) cmd ::= query_expression */
  {  204,   -1 }, /* (226) literal ::= NK_INTEGER */
  {  204,   -1 }, /* (227) literal ::= NK_FLOAT */
  {  204,   -1 }, /* (228) literal ::= NK_STRING */
  {  204,   -1 }, /* (229) literal ::= NK_BOOL */
  {  204,   -2 }, /* (230) literal ::= TIMESTAMP NK_STRING */
  {  204,   -1 }, /* (231) literal ::= duration_literal */
  {  204,   -1 }, /* (232) literal ::= NULL */
  {  246,   -1 }, /* (233) duration_literal ::= NK_VARIABLE */
  {  258,   -1 }, /* (234) signed ::= NK_INTEGER */
  {  258,   -2 }, /* (235) signed ::= NK_PLUS NK_INTEGER */
  {  258,   -2 }, /* (236) signed ::= NK_MINUS NK_INTEGER */
  {  258,   -1 }, /* (237) signed ::= NK_FLOAT */
  {  258,   -2 }, /* (238) signed ::= NK_PLUS NK_FLOAT */
  {  258,   -2 }, /* (239) signed ::= NK_MINUS NK_FLOAT */
  {  259,   -1 }, /* (240) signed_literal ::= signed */
  {  259,   -1 }, /* (241) signed_literal ::= NK_STRING */
  {  259,   -1 }, /* (242) signed_literal ::= NK_BOOL */
  {  259,   -2 }, /* (243) signed_literal ::= TIMESTAMP NK_STRING */
  {  259,   -1 }, /* (244) signed_literal ::= duration_literal */
  {  259,   -1 }, /* (245) signed_literal ::= NULL */
  {  229,   -1 }, /* (246) literal_list ::= signed_literal */
  {  229,   -3 }, /* (247) literal_list ::= literal_list NK_COMMA signed_literal */
  {  210,   -1 }, /* (248) db_name ::= NK_ID */
  {  232,   -1 }, /* (249) table_name ::= NK_ID */
  {  225,   -1 }, /* (250) column_name ::= NK_ID */
  {  242,   -1 }, /* (251) function_name ::= NK_ID */
  {  260,   -1 }, /* (252) table_alias ::= NK_ID */
  {  261,   -1 }, /* (253) column_alias ::= NK_ID */
  {  206,   -1 }, /* (254) user_name ::= NK_ID */
  {  243,   -1 }, /* (255) index_name ::= NK_ID */
  {  250,   -1 }, /* (256) topic_name ::= NK_ID */
  {  256,   -1 }, /* (257) stream_name ::= NK_ID */
  {  262,   -1 }, /* (258) expression ::= literal */
  {  262,   -1 }, /* (259) expression ::= pseudo_column */
  {  262,   -1 }, /* (260) expression ::= column_reference */
  {  262,   -4 }, /* (261) expression ::= function_name NK_LP expression_list NK_RP */
  {  262,   -4 }, /* (262) expression ::= function_name NK_LP NK_STAR NK_RP */
  {  262,   -1 }, /* (263) expression ::= subquery */
  {  262,   -3 }, /* (264) expression ::= NK_LP expression NK_RP */
  {  262,   -2 }, /* (265) expression ::= NK_PLUS expression */
  {  262,   -2 }, /* (266) expression ::= NK_MINUS expression */
  {  262,   -3 }, /* (267) expression ::= expression NK_PLUS expression */
  {  262,   -3 }, /* (268) expression ::= expression NK_MINUS expression */
  {  262,   -3 }, /* (269) expression ::= expression NK_STAR expression */
  {  262,   -3 }, /* (270) expression ::= expression NK_SLASH expression */
  {  262,   -3 }, /* (271) expression ::= expression NK_REM expression */
  {  249,   -1 }, /* (272) expression_list ::= expression */
  {  249,   -3 }, /* (273) expression_list ::= expression_list NK_COMMA expression */
  {  264,   -1 }, /* (274) column_reference ::= column_name */
  {  264,   -3 }, /* (275) column_reference ::= table_name NK_DOT column_name */
  {  263,   -1 }, /* (276) pseudo_column ::= NOW */
  {  263,   -1 }, /* (277) pseudo_column ::= ROWTS */
  {  263,   -1 }, /* (278) pseudo_column ::= TBNAME */
  {  263,   -1 }, /* (279) pseudo_column ::= QSTARTTS */
  {  263,   -1 }, /* (280) pseudo_column ::= QENDTS */
  {  263,   -1 }, /* (281) pseudo_column ::= WSTARTTS */
  {  263,   -1 }, /* (282) pseudo_column ::= WENDTS */
  {  263,   -1 }, /* (283) pseudo_column ::= WDURATION */
  {  266,   -3 }, /* (284) predicate ::= expression compare_op expression */
  {  266,   -5 }, /* (285) predicate ::= expression BETWEEN expression AND expression */
  {  266,   -6 }, /* (286) predicate ::= expression NOT BETWEEN expression AND expression */
  {  266,   -3 }, /* (287) predicate ::= expression IS NULL */
  {  266,   -4 }, /* (288) predicate ::= expression IS NOT NULL */
  {  266,   -3 }, /* (289) predicate ::= expression in_op in_predicate_value */
  {  267,   -1 }, /* (290) compare_op ::= NK_LT */
  {  267,   -1 }, /* (291) compare_op ::= NK_GT */
  {  267,   -1 }, /* (292) compare_op ::= NK_LE */
  {  267,   -1 }, /* (293) compare_op ::= NK_GE */
  {  267,   -1 }, /* (294) compare_op ::= NK_NE */
  {  267,   -1 }, /* (295) compare_op ::= NK_EQ */
  {  267,   -1 }, /* (296) compare_op ::= LIKE */
  {  267,   -2 }, /* (297) compare_op ::= NOT LIKE */
  {  267,   -1 }, /* (298) compare_op ::= MATCH */
  {  267,   -1 }, /* (299) compare_op ::= NMATCH */
  {  268,   -1 }, /* (300) in_op ::= IN */
  {  268,   -2 }, /* (301) in_op ::= NOT IN */
  {  269,   -3 }, /* (302) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  270,   -1 }, /* (303) boolean_value_expression ::= boolean_primary */
  {  270,   -2 }, /* (304) boolean_value_expression ::= NOT boolean_primary */
  {  270,   -3 }, /* (305) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  270,   -3 }, /* (306) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  271,   -1 }, /* (307) boolean_primary ::= predicate */
  {  271,   -3 }, /* (308) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  272,   -1 }, /* (309) common_expression ::= expression */
  {  272,   -1 }, /* (310) common_expression ::= boolean_value_expression */
  {  273,   -2 }, /* (311) from_clause ::= FROM table_reference_list */
  {  274,   -1 }, /* (312) table_reference_list ::= table_reference */
  {  274,   -3 }, /* (313) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  275,   -1 }, /* (314) table_reference ::= table_primary */
  {  275,   -1 }, /* (315) table_reference ::= joined_table */
  {  276,   -2 }, /* (316) table_primary ::= table_name alias_opt */
  {  276,   -4 }, /* (317) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  276,   -2 }, /* (318) table_primary ::= subquery alias_opt */
  {  276,   -1 }, /* (319) table_primary ::= parenthesized_joined_table */
  {  278,    0 }, /* (320) alias_opt ::= */
  {  278,   -1 }, /* (321) alias_opt ::= table_alias */
  {  278,   -2 }, /* (322) alias_opt ::= AS table_alias */
  {  279,   -3 }, /* (323) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  279,   -3 }, /* (324) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  277,   -6 }, /* (325) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  280,    0 }, /* (326) join_type ::= */
  {  280,   -1 }, /* (327) join_type ::= INNER */
  {  282,   -9 }, /* (328) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  283,    0 }, /* (329) set_quantifier_opt ::= */
  {  283,   -1 }, /* (330) set_quantifier_opt ::= DISTINCT */
  {  283,   -1 }, /* (331) set_quantifier_opt ::= ALL */
  {  284,   -1 }, /* (332) select_list ::= NK_STAR */
  {  284,   -1 }, /* (333) select_list ::= select_sublist */
  {  290,   -1 }, /* (334) select_sublist ::= select_item */
  {  290,   -3 }, /* (335) select_sublist ::= select_sublist NK_COMMA select_item */
  {  291,   -1 }, /* (336) select_item ::= common_expression */
  {  291,   -2 }, /* (337) select_item ::= common_expression column_alias */
  {  291,   -3 }, /* (338) select_item ::= common_expression AS column_alias */
  {  291,   -3 }, /* (339) select_item ::= table_name NK_DOT NK_STAR */
  {  285,    0 }, /* (340) where_clause_opt ::= */
  {  285,   -2 }, /* (341) where_clause_opt ::= WHERE search_condition */
  {  286,    0 }, /* (342) partition_by_clause_opt ::= */
  {  286,   -3 }, /* (343) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  287,    0 }, /* (344) twindow_clause_opt ::= */
  {  287,   -6 }, /* (345) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  287,   -4 }, /* (346) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  287,   -6 }, /* (347) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  287,   -8 }, /* (348) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  247,    0 }, /* (349) sliding_opt ::= */
  {  247,   -4 }, /* (350) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  292,    0 }, /* (351) fill_opt ::= */
  {  292,   -4 }, /* (352) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  292,   -6 }, /* (353) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  293,   -1 }, /* (354) fill_mode ::= NONE */
  {  293,   -1 }, /* (355) fill_mode ::= PREV */
  {  293,   -1 }, /* (356) fill_mode ::= NULL */
  {  293,   -1 }, /* (357) fill_mode ::= LINEAR */
  {  293,   -1 }, /* (358) fill_mode ::= NEXT */
  {  288,    0 }, /* (359) group_by_clause_opt ::= */
  {  288,   -3 }, /* (360) group_by_clause_opt ::= GROUP BY group_by_list */
  {  294,   -1 }, /* (361) group_by_list ::= expression */
  {  294,   -3 }, /* (362) group_by_list ::= group_by_list NK_COMMA expression */
  {  289,    0 }, /* (363) having_clause_opt ::= */
  {  289,   -2 }, /* (364) having_clause_opt ::= HAVING search_condition */
  {  251,   -4 }, /* (365) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  295,   -1 }, /* (366) query_expression_body ::= query_primary */
  {  295,   -4 }, /* (367) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  299,   -1 }, /* (368) query_primary ::= query_specification */
  {  296,    0 }, /* (369) order_by_clause_opt ::= */
  {  296,   -3 }, /* (370) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  297,    0 }, /* (371) slimit_clause_opt ::= */
  {  297,   -2 }, /* (372) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  297,   -4 }, /* (373) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  297,   -4 }, /* (374) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  298,    0 }, /* (375) limit_clause_opt ::= */
  {  298,   -2 }, /* (376) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  298,   -4 }, /* (377) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  298,   -4 }, /* (378) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  265,   -3 }, /* (379) subquery ::= NK_LP query_expression NK_RP */
  {  281,   -1 }, /* (380) search_condition ::= common_expression */
  {  300,   -1 }, /* (381) sort_specification_list ::= sort_specification */
  {  300,   -3 }, /* (382) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  301,   -3 }, /* (383) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  302,    0 }, /* (384) ordering_specification_opt ::= */
  {  302,   -1 }, /* (385) ordering_specification_opt ::= ASC */
  {  302,   -1 }, /* (386) ordering_specification_opt ::= DESC */
  {  303,    0 }, /* (387) null_ordering_opt ::= */
  {  303,   -2 }, /* (388) null_ordering_opt ::= NULLS FIRST */
  {  303,   -2 }, /* (389) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,202,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,203,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,202,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,204,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,205,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,203,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,205,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,204,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy129, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy129, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy129, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 248: /* db_name ::= NK_ID */ yytestcase(yyruleno==248);
      case 249: /* table_name ::= NK_ID */ yytestcase(yyruleno==249);
      case 250: /* column_name ::= NK_ID */ yytestcase(yyruleno==250);
      case 251: /* function_name ::= NK_ID */ yytestcase(yyruleno==251);
      case 252: /* table_alias ::= NK_ID */ yytestcase(yyruleno==252);
      case 253: /* column_alias ::= NK_ID */ yytestcase(yyruleno==253);
      case 254: /* user_name ::= NK_ID */ yytestcase(yyruleno==254);
      case 255: /* index_name ::= NK_ID */ yytestcase(yyruleno==255);
      case 256: /* topic_name ::= NK_ID */ yytestcase(yyruleno==256);
      case 257: /* stream_name ::= NK_ID */ yytestcase(yyruleno==257);
{ yylhsminor.yy129 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy129 = yylhsminor.yy129;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateQnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropQnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy185, &yymsp[-1].minor.yy129, yymsp[0].minor.yy104); }
        break;
      case 44: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy185, &yymsp[0].minor.yy129); }
        break;
      case 45: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 46: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy129, yymsp[0].minor.yy104); }
        break;
      case 47: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy185 = true; }
        break;
      case 48: /* not_exists_opt ::= */
      case 50: /* exists_opt ::= */ yytestcase(yyruleno==50);
      case 203: /* analyze_opt ::= */ yytestcase(yyruleno==203);
      case 211: /* agg_func_opt ::= */ yytestcase(yyruleno==211);
      case 329: /* set_quantifier_opt ::= */ yytestcase(yyruleno==329);
{ yymsp[1].minor.yy185 = false; }
        break;
      case 49: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy185 = true; }
        break;
      case 51: /* db_options ::= */
{ yymsp[1].minor.yy104 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 52: /* db_options ::= db_options BLOCKS NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_BLOCKS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 53: /* db_options ::= db_options CACHE NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_CACHE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 54: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 55: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 56: /* db_options ::= db_options DAYS NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 57: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 58: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 59: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 60: /* db_options ::= db_options KEEP integer_list */
{ yylhsminor.yy104 = setDatabaseKeepOption(pCxt, yymsp[-2].minor.yy104, yymsp[0].minor.yy312); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 61: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 62: /* db_options ::= db_options QUORUM NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_QUORUM, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 63: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 64: /* db_options ::= db_options TTL NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 65: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 66: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 67: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 68: /* db_options ::= db_options STREAM_MODE NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_STREAM_MODE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 69: /* db_options ::= db_options RETENTIONS NK_STRING */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_RETENTIONS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 70: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy104 = createDefaultAlterDatabaseOptions(pCxt); yylhsminor.yy104 = setDatabaseAlterOption(pCxt, yylhsminor.yy104, &yymsp[0].minor.yy253); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 71: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy104 = setDatabaseAlterOption(pCxt, yymsp[-1].minor.yy104, &yymsp[0].minor.yy253); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 72: /* alter_db_option ::= BLOCKS NK_INTEGER */
{ yymsp[-1].minor.yy253.type = DB_OPTION_BLOCKS; yymsp[-1].minor.yy253.val = yymsp[0].minor.yy0; }
        break;
      case 73: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy253.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy253.val = yymsp[0].minor.yy0; }
        break;
      case 74: /* alter_db_option ::= KEEP integer_list */
{ yymsp[-1].minor.yy253.type = DB_OPTION_KEEP; yymsp[-1].minor.yy253.pKeep = yymsp[0].minor.yy312; }
        break;
      case 75: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy253.type = DB_OPTION_WAL; yymsp[-1].minor.yy253.val = yymsp[0].minor.yy0; }
        break;
      case 76: /* alter_db_option ::= QUORUM NK_INTEGER */
{ yymsp[-1].minor.yy253.type = DB_OPTION_QUORUM; yymsp[-1].minor.yy253.val = yymsp[0].minor.yy0; }
        break;
      case 77: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy253.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy253.val = yymsp[0].minor.yy0; }
        break;
      case 78: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy253.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy253.val = yymsp[0].minor.yy0; }
        break;
      case 79: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy312 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 80: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 223: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==223);
{ yylhsminor.yy312 = addNodeToList(pCxt, yymsp[-2].minor.yy312, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 81: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 83: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==83);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy185, yymsp[-5].minor.yy104, yymsp[-3].minor.yy312, yymsp[-1].minor.yy312, yymsp[0].minor.yy104); }
        break;
      case 82: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy312); }
        break;
      case 84: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy312); }
        break;
      case 85: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy185, yymsp[0].minor.yy104); }
        break;
      case 86: /* cmd ::= ALTER TABLE alter_table_clause */
      case 87: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==87);
      case 225: /* cmd ::= query_expression */ yytestcase(yyruleno==225);
{ pCxt->pRootNode = yymsp[0].minor.yy104; }
        break;
      case 88: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy104 = createAlterTableOption(pCxt, yymsp[-1].minor.yy104, yymsp[0].minor.yy104); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 89: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy104 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy104, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy129, yymsp[0].minor.yy336); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 90: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy104 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy104, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy129); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 91: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy104 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy104, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy129, yymsp[0].minor.yy336); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 92: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy104 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy104, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy129, &yymsp[0].minor.yy129); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 93: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy104 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy104, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy129, yymsp[0].minor.yy336); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 94: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy104 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy104, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy129); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 95: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy104 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy104, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy129, yymsp[0].minor.yy336); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 96: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy104 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy104, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy129, &yymsp[0].minor.yy129); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 97: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy104 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy104, &yymsp[-2].minor.yy129, yymsp[0].minor.yy104); }
  yymsp[-5].minor.yy104 = yylhsminor.yy104;
        break;
      case 98: /* multi_create_clause ::= create_subtable_clause */
      case 101: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==101);
      case 108: /* column_def_list ::= column_def */ yytestcase(yyruleno==108);
      case 151: /* col_name_list ::= col_name */ yytestcase(yyruleno==151);
      case 184: /* func_name_list ::= func_name */ yytestcase(yyruleno==184);
      case 193: /* func_list ::= func */ yytestcase(yyruleno==193);
      case 246: /* literal_list ::= signed_literal */ yytestcase(yyruleno==246);
      case 334: /* select_sublist ::= select_item */ yytestcase(yyruleno==334);
      case 381: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==381);
{ yylhsminor.yy312 = createNodeList(pCxt, yymsp[0].minor.yy104); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 99: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 102: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==102);
{ yylhsminor.yy312 = addNodeToList(pCxt, yymsp[-1].minor.yy312, yymsp[0].minor.yy104); }
  yymsp[-1].minor.yy312 = yylhsminor.yy312;
        break;
      case 100: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
{ yylhsminor.yy104 = createCreateSubTableClause(pCxt, yymsp[-8].minor.yy185, yymsp[-7].minor.yy104, yymsp[-5].minor.yy104, yymsp[-4].minor.yy312, yymsp[-1].minor.yy312); }
  yymsp[-8].minor.yy104 = yylhsminor.yy104;
        break;
      case 103: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy104 = createDropTableClause(pCxt, yymsp[-1].minor.yy185, yymsp[0].minor.yy104); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 104: /* specific_tags_opt ::= */
      case 135: /* tags_def_opt ::= */ yytestcase(yyruleno==135);
      case 342: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==342);
      case 359: /* group_by_clause_opt ::= */ yytestcase(yyruleno==359);
      case 369: /* order_by_clause_opt ::= */ yytestcase(yyruleno==369);
{ yymsp[1].minor.yy312 = NULL; }
        break;
      case 105: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy312 = yymsp[-1].minor.yy312; }
        break;
      case 106: /* full_table_name ::= table_name */
{ yylhsminor.yy104 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy129, NULL); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 107: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy104 = createRealTableNode(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129, NULL); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 109: /* column_def_list ::= column_def_list NK_COMMA column_def */
      case 152: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==152);
      case 185: /* func_name_list ::= func_name_list NK_COMMA col_name */ yytestcase(yyruleno==185);
      case 194: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==194);
      case 247: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==247);
      case 335: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==335);
      case 382: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==382);
{ yylhsminor.yy312 = addNodeToList(pCxt, yymsp[-2].minor.yy312, yymsp[0].minor.yy104); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 110: /* column_def ::= column_name type_name */
{ yylhsminor.yy104 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy129, yymsp[0].minor.yy336, NULL); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 111: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy104 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy129, yymsp[-2].minor.yy336, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 112: /* type_name ::= BOOL */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 113: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 114: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 115: /* type_name ::= INT */
      case 116: /* type_name ::= INTEGER */ yytestcase(yyruleno==116);
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 117: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 118: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 119: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 120: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy336 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 121: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 122: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy336 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 123: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy336 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 124: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy336 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 125: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy336 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 126: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy336 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 127: /* type_name ::= JSON */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 128: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy336 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 129: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 130: /* type_name ::= BLOB */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 131: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy336 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 132: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy336 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 133: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy336 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 134: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy336 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 136: /* tags_def_opt ::= tags_def */
      case 333: /* select_list ::= select_sublist */ yytestcase(yyruleno==333);
{ yylhsminor.yy312 = yymsp[0].minor.yy312; }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 137: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy312 = yymsp[-1].minor.yy312; }
        break;
      case 138: /* table_options ::= */
{ yymsp[1].minor.yy104 = createDefaultTableOptions(pCxt); }
        break;
      case 139: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy104 = setTableOption(pCxt, yymsp[-2].minor.yy104, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 140: /* table_options ::= table_options KEEP integer_list */
{ yylhsminor.yy104 = setTableKeepOption(pCxt, yymsp[-2].minor.yy104, yymsp[0].minor.yy312); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 141: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy104 = setTableOption(pCxt, yymsp[-2].minor.yy104, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 142: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy104 = setTableSmaOption(pCxt, yymsp[-4].minor.yy104, yymsp[-1].minor.yy312); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 143: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ yylhsminor.yy104 = setTableRollupOption(pCxt, yymsp[-4].minor.yy104, yymsp[-1].minor.yy312); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 144: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ yylhsminor.yy104 = setTableOption(pCxt, yymsp[-2].minor.yy104, TABLE_OPTION_FILE_FACTOR, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 145: /* table_options ::= table_options DELAY NK_INTEGER */
{ yylhsminor.yy104 = setTableOption(pCxt, yymsp[-2].minor.yy104, TABLE_OPTION_DELAY, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 146: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy104 = createDefaultAlterTableOptions(pCxt); yylhsminor.yy104 = setTableAlterOption(pCxt, yylhsminor.yy104, &yymsp[0].minor.yy253); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 147: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy104 = setTableAlterOption(pCxt, yymsp[-1].minor.yy104, &yymsp[0].minor.yy253); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 148: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy253.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy253.val = yymsp[0].minor.yy0; }
        break;
      case 149: /* alter_table_option ::= KEEP integer_list */
{ yymsp[-1].minor.yy253.type = TABLE_OPTION_KEEP; yymsp[-1].minor.yy253.pKeep = yymsp[0].minor.yy312; }
        break;
      case 150: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy253.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy253.val = yymsp[0].minor.yy0; }
        break;
      case 153: /* col_name ::= column_name */
{ yylhsminor.yy104 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy129); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 154: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 155: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 156: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 157: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy104, yymsp[0].minor.yy104); }
        break;
      case 158: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy104, yymsp[0].minor.yy104); }
        break;
      case 159: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy104, NULL); }
        break;
      case 160: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 161: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 162: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 163: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 164: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy104, yymsp[0].minor.yy104); }
        break;
      case 165: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 166: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 167: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 168: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 169: /* cmd ::= SHOW LICENCE */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 170: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 171: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy104); }
        break;
      case 172: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy104); }
        break;
      case 173: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 174: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 175: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 176: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 177: /* db_name_cond_opt ::= */
      case 182: /* from_db_opt ::= */ yytestcase(yyruleno==182);
{ yymsp[1].minor.yy104 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 178: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy129); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 179: /* like_pattern_opt ::= */
      case 190: /* index_options ::= */ yytestcase(yyruleno==190);
      case 340: /* where_clause_opt ::= */ yytestcase(yyruleno==340);
      case 344: /* twindow_clause_opt ::= */ yytestcase(yyruleno==344);
      case 349: /* sliding_opt ::= */ yytestcase(yyruleno==349);
      case 351: /* fill_opt ::= */ yytestcase(yyruleno==351);
      case 363: /* having_clause_opt ::= */ yytestcase(yyruleno==363);
      case 371: /* slimit_clause_opt ::= */ yytestcase(yyruleno==371);
      case 375: /* limit_clause_opt ::= */ yytestcase(yyruleno==375);
{ yymsp[1].minor.yy104 = NULL; }
        break;
      case 180: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 181: /* table_name_cond ::= table_name */
{ yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy129); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 183: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy129); }
        break;
      case 186: /* func_name ::= function_name */
{ yylhsminor.yy104 = createFunctionNode(pCxt, &yymsp[0].minor.yy129, NULL); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 187: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy185, &yymsp[-3].minor.yy129, &yymsp[-1].minor.yy129, NULL, yymsp[0].minor.yy104); }
        break;
      case 188: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy185, &yymsp[-5].minor.yy129, &yymsp[-3].minor.yy129, yymsp[-1].minor.yy312, NULL); }
        break;
      case 189: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy185, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129); }
        break;
      case 191: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy104 = createIndexOption(pCxt, yymsp[-6].minor.yy312, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), NULL, yymsp[0].minor.yy104); }
        break;
      case 192: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy104 = createIndexOption(pCxt, yymsp[-8].minor.yy312, releaseRawExprNode(pCxt, yymsp[-4].minor.yy104), releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), yymsp[0].minor.yy104); }
        break;
      case 195: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy104 = createFunctionNode(pCxt, &yymsp[-3].minor.yy129, yymsp[-1].minor.yy312); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 196: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy185, &yymsp[-2].minor.yy129, yymsp[0].minor.yy104, NULL); }
        break;
      case 197: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy185, &yymsp[-2].minor.yy129, NULL, &yymsp[0].minor.yy129); }
        break;
      case 198: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy185, &yymsp[0].minor.yy129); }
        break;
      case 199: /* cmd ::= DESC full_table_name */
      case 200: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==200);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy104); }
        break;
      case 201: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 202: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy185, yymsp[-1].minor.yy104, yymsp[0].minor.yy104); }
        break;
      case 204: /* analyze_opt ::= ANALYZE */
      case 212: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==212);
      case 330: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==330);
{ yymsp[0].minor.yy185 = true; }
        break;
      case 205: /* explain_options ::= */
{ yymsp[1].minor.yy104 = createDefaultExplainOptions(pCxt); }
        break;
      case 206: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy104 = setExplainVerbose(pCxt, yymsp[-2].minor.yy104, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 207: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy104 = setExplainRatio(pCxt, yymsp[-2].minor.yy104, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 208: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy312); }
        break;
      case 209: /* cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy185, &yymsp[-5].minor.yy129, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy336, yymsp[0].minor.yy196); }
        break;
      case 210: /* cmd ::= DROP FUNCTION function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 213: /* bufsize_opt ::= */
{ yymsp[1].minor.yy196 = 0; }
        break;
      case 214: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy196 = strtol(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 215: /* cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, &yymsp[-4].minor.yy129, &yymsp[-2].minor.yy129, yymsp[0].minor.yy104); }
        break;
      case 216: /* cmd ::= DROP STREAM stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 217: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 218: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 219: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 220: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy312); }
        break;
      case 221: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 222: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy312 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 224: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy129); }
        break;
      case 226: /* literal ::= NK_INTEGER */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 227: /* literal ::= NK_FLOAT */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 228: /* literal ::= NK_STRING */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 229: /* literal ::= NK_BOOL */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 230: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 231: /* literal ::= duration_literal */
      case 240: /* signed_literal ::= signed */ yytestcase(yyruleno==240);
      case 258: /* expression ::= literal */ yytestcase(yyruleno==258);
      case 259: /* expression ::= pseudo_column */ yytestcase(yyruleno==259);
      case 260: /* expression ::= column_reference */ yytestcase(yyruleno==260);
      case 263: /* expression ::= subquery */ yytestcase(yyruleno==263);
      case 303: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==303);
      case 307: /* boolean_primary ::= predicate */ yytestcase(yyruleno==307);
      case 309: /* common_expression ::= expression */ yytestcase(yyruleno==309);
      case 310: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==310);
      case 312: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==312);
      case 314: /* table_reference ::= table_primary */ yytestcase(yyruleno==314);
      case 315: /* table_reference ::= joined_table */ yytestcase(yyruleno==315);
      case 319: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==319);
      case 366: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==366);
      case 368: /* query_primary ::= query_specification */ yytestcase(yyruleno==368);
{ yylhsminor.yy104 = yymsp[0].minor.yy104; }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 232: /* literal ::= NULL */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 233: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 234: /* signed ::= NK_INTEGER */
{ yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 235: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 236: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 237: /* signed ::= NK_FLOAT */
{ yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 238: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 239: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 241: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 242: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 243: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 244: /* signed_literal ::= duration_literal */
      case 380: /* search_condition ::= common_expression */ yytestcase(yyruleno==380);
{ yylhsminor.yy104 = releaseRawExprNode(pCxt, yymsp[0].minor.yy104); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 245: /* signed_literal ::= NULL */
{ yymsp[0].minor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL); }
        break;
      case 261: /* expression ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy129, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy129, yymsp[-1].minor.yy312)); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 262: /* expression ::= function_name NK_LP NK_STAR NK_RP */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy129, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy129, createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy0)))); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 264: /* expression ::= NK_LP expression NK_RP */
      case 308: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==308);
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy104)); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 265: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy104));
                                                                                  }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 266: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy104), NULL));
                                                                                  }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 267: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); 
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 268: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); 
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 269: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); 
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 270: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); 
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 271: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); 
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 272: /* expression_list ::= expression */
{ yylhsminor.yy312 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy104)); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 273: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy312 = addNodeToList(pCxt, yymsp[-2].minor.yy312, releaseRawExprNode(pCxt, yymsp[0].minor.yy104)); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 274: /* column_reference ::= column_name */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy129, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy129)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 275: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129, createColumnNode(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129)); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 276: /* pseudo_column ::= NOW */
      case 277: /* pseudo_column ::= ROWTS */ yytestcase(yyruleno==277);
      case 278: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==278);
      case 279: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==279);
      case 280: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==280);
      case 281: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==281);
      case 282: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==282);
      case 283: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==283);
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 284: /* predicate ::= expression compare_op expression */
      case 289: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==289);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy60, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104)));
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 285: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy104), releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104)));
                                                                                  }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 286: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[-5].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104)));
                                                                                  }
  yymsp[-5].minor.yy104 = yylhsminor.yy104;
        break;
      case 287: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), NULL));
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 288: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy104), NULL));
                                                                                  }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 290: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy60 = OP_TYPE_LOWER_THAN; }
        break;
      case 291: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy60 = OP_TYPE_GREATER_THAN; }
        break;
      case 292: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy60 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 293: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy60 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 294: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy60 = OP_TYPE_NOT_EQUAL; }
        break;
      case 295: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy60 = OP_TYPE_EQUAL; }
        break;
      case 296: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy60 = OP_TYPE_LIKE; }
        break;
      case 297: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy60 = OP_TYPE_NOT_LIKE; }
        break;
      case 298: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy60 = OP_TYPE_MATCH; }
        break;
      case 299: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy60 = OP_TYPE_NMATCH; }
        break;
      case 300: /* in_op ::= IN */
{ yymsp[0].minor.yy60 = OP_TYPE_IN; }
        break;
      case 301: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy60 = OP_TYPE_NOT_IN; }
        break;
      case 302: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy312)); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 304: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy104), NULL));
                                                                                  }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 305: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104)));
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 306: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104)));
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 311: /* from_clause ::= FROM table_reference_list */
      case 341: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==341);
      case 364: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==364);
{ yymsp[-1].minor.yy104 = yymsp[0].minor.yy104; }
        break;
      case 313: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy104 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy104, yymsp[0].minor.yy104, NULL); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 316: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy104 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy129, &yymsp[0].minor.yy129); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 317: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy104 = createRealTableNode(pCxt, &yymsp[-3].minor.yy129, &yymsp[-1].minor.yy129, &yymsp[0].minor.yy129); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 318: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy104 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy104), &yymsp[0].minor.yy129); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 320: /* alias_opt ::= */
{ yymsp[1].minor.yy129 = nil_token;  }
        break;
      case 321: /* alias_opt ::= table_alias */
{ yylhsminor.yy129 = yymsp[0].minor.yy129; }
  yymsp[0].minor.yy129 = yylhsminor.yy129;
        break;
      case 322: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy129 = yymsp[0].minor.yy129; }
        break;
      case 323: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 324: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==324);
{ yymsp[-2].minor.yy104 = yymsp[-1].minor.yy104; }
        break;
      case 325: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy104 = createJoinTableNode(pCxt, yymsp[-4].minor.yy532, yymsp[-5].minor.yy104, yymsp[-2].minor.yy104, yymsp[0].minor.yy104); }
  yymsp[-5].minor.yy104 = yylhsminor.yy104;
        break;
      case 326: /* join_type ::= */
{ yymsp[1].minor.yy532 = JOIN_TYPE_INNER; }
        break;
      case 327: /* join_type ::= INNER */
{ yymsp[0].minor.yy532 = JOIN_TYPE_INNER; }
        break;
      case 328: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy104 = createSelectStmt(pCxt, yymsp[-7].minor.yy185, yymsp[-6].minor.yy312, yymsp[-5].minor.yy104);
                                                                                    yymsp[-8].minor.yy104 = addWhereClause(pCxt, yymsp[-8].minor.yy104, yymsp[-4].minor.yy104);
                                                                                    yymsp[-8].minor.yy104 = addPartitionByClause(pCxt, yymsp[-8].minor.yy104, yymsp[-3].minor.yy312);
                                                                                    yymsp[-8].minor.yy104 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy104, yymsp[-2].minor.yy104);
                                                                                    yymsp[-8].minor.yy104 = addGroupByClause(pCxt, yymsp[-8].minor.yy104, yymsp[-1].minor.yy312);
                                                                                    yymsp[-8].minor.yy104 = addHavingClause(pCxt, yymsp[-8].minor.yy104, yymsp[0].minor.yy104);
                                                                                  }
        break;
      case 331: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy185 = false; }
        break;
      case 332: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy312 = NULL; }
        break;
      case 336: /* select_item ::= common_expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy104), &t);
                                                                                  }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 337: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy104 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy104), &yymsp[0].minor.yy129); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 338: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy104 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), &yymsp[0].minor.yy129); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 339: /* select_item ::= table_name NK_DOT NK_STAR */
{ yylhsminor.yy104 = createColumnNode(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 343: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 360: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==360);
      case 370: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==370);
{ yymsp[-2].minor.yy312 = yymsp[0].minor.yy312; }
        break;
      case 345: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy104 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy104), releaseRawExprNode(pCxt, yymsp[-1].minor.yy104)); }
        break;
      case 346: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy104 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy104)); }
        break;
      case 347: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy104 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy104), NULL, yymsp[-1].minor.yy104, yymsp[0].minor.yy104); }
        break;
      case 348: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy104 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy104), releaseRawExprNode(pCxt, yymsp[-3].minor.yy104), yymsp[-1].minor.yy104, yymsp[0].minor.yy104); }
        break;
      case 350: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy104 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy104); }
        break;
      case 352: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy104 = createFillNode(pCxt, yymsp[-1].minor.yy550, NULL); }
        break;
      case 353: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy104 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy312)); }
        break;
      case 354: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy550 = FILL_MODE_NONE; }
        break;
      case 355: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy550 = FILL_MODE_PREV; }
        break;
      case 356: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy550 = FILL_MODE_NULL; }
        break;
      case 357: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy550 = FILL_MODE_LINEAR; }
        break;
      case 358: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy550 = FILL_MODE_NEXT; }
        break;
      case 361: /* group_by_list ::= expression */
{ yylhsminor.yy312 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 362: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy312 = addNodeToList(pCxt, yymsp[-2].minor.yy312, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 365: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy104 = addOrderByClause(pCxt, yymsp[-3].minor.yy104, yymsp[-2].minor.yy312);
                                                                                    yylhsminor.yy104 = addSlimitClause(pCxt, yylhsminor.yy104, yymsp[-1].minor.yy104);
                                                                                    yylhsminor.yy104 = addLimitClause(pCxt, yylhsminor.yy104, yymsp[0].minor.yy104);
                                                                                  }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 367: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy104 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy104, yymsp[0].minor.yy104); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 372: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 376: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==376);
{ yymsp[-1].minor.yy104 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 373: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 377: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==377);
{ yymsp[-3].minor.yy104 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 374: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 378: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==378);
{ yymsp[-3].minor.yy104 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 379: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy104); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 383: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy104 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), yymsp[-1].minor.yy354, yymsp[0].minor.yy489); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 384: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy354 = ORDER_ASC; }
        break;
      case 385: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy354 = ORDER_ASC; }
        break;
      case 386: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy354 = ORDER_DESC; }
        break;
      case 387: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy489 = NULL_ORDER_DEFAULT; }
        break;
      case 388: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy489 = NULL_ORDER_FIRST; }
        break;
      case 389: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy489 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
