/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 274
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SAlterOption yy29;
  SNodeList* yy40;
  ENullOrder yy177;
  EOrder yy210;
  EOperatorType yy328;
  SNode* yy364;
  EJoinType yy392;
  SDataType yy420;
  SToken yy437;
  int32_t yy460;
  EFillMode yy478;
  bool yy493;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYNSTATE             438
#define YYNRULE              354
#define YYNTOKEN             176
#define YY_MAX_SHIFT         437
#define YY_MIN_SHIFTREDUCE   684
#define YY_MAX_SHIFTREDUCE   1037
#define YY_ERROR_ACTION      1038
#define YY_ACCEPT_ACTION     1039
#define YY_NO_ACTION         1040
#define YY_MIN_REDUCE        1041
#define YY_MAX_REDUCE        1394
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1305)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1251,  337,   24,  172,  356,  356,  256,  241, 1247, 1254,
 /*    10 */  1220, 1221,   31,   29,   27,   26,   25, 1264,  369,  369,
 /*    20 */     9,    8,   93,   67,   67,   31,   29,   27,   26,   25,
 /*    30 */   286,  292,  337, 1373,  106,   60, 1053, 1280,  369, 1144,
 /*    40 */  1144,  341, 1135,  276,  353,   94,  118,  215, 1084,  249,
 /*    50 */  1371,   91, 1136,   93,  355,  979, 1211, 1213, 1238, 1144,
 /*    60 */   215,  165, 1319,  336,  110,  335, 1087,   44, 1373,  913,
 /*    70 */    63, 1265, 1266, 1269, 1312, 1184,   90,  943,  231, 1308,
 /*    80 */  1385,  118,   91, 1238, 1139, 1371,  107, 1111,  956, 1346,
 /*    90 */   943,  339,  114, 1319, 1320,  257, 1324,  422,  421,  420,
 /*   100 */   419,  418,  417,  416,  415,  414,  413,  412,  411,  410,
 /*   110 */   409,  408,  407,  406,  405,  298,  944,  293,  105,  242,
 /*   120 */   297,  213,  898,  296,  368,  294, 1147,  105,  295,  944,
 /*   130 */    31,   29,   27,   26,   25, 1146,  368, 1122,   23,  236,
 /*   140 */   938,  939,  940,  941,  942,  946,  947,  948,   27,   26,
 /*   150 */    25,   23,  236,  938,  939,  940,  941,  942,  946,  947,
 /*   160 */   948,  793,  392,  391,  390,  797,  389,  799,  800,  388,
 /*   170 */   802,  385, 1264,  808,  382,  810,  811,  379,  376,  229,
 /*   180 */    30,   28,  337,  277,   12,   30,   28,  980,  238,  277,
 /*   190 */   878,  246, 1280,  238, 1264,  878, 1251,  310,  255,  353,
 /*   200 */   254, 1191,  978,   93, 1247, 1253,  876,  228, 1251,  355,
 /*   210 */   308,  876, 1189, 1238, 1280,   11, 1247, 1253,  341,  369,
 /*   220 */    11,  340,  248,  119, 1141,   62, 1265, 1266, 1269, 1312,
 /*   230 */   105,  355,   91,  214, 1308, 1238,    1,  265, 1146, 1120,
 /*   240 */  1144,    1,  115, 1319, 1320, 1373, 1324,   63, 1265, 1266,
 /*   250 */  1269, 1312,  119, 1191,  720,  231, 1308,  113,  118,  243,
 /*   260 */   434,    6, 1371,  902, 1189,  434,  119,  430,  429,  168,
 /*   270 */   284,  312,  877, 1280, 1280,  319, 1339,  877,   30,   28,
 /*   280 */   353,  353,  124,  123,  222,  404,  238, 1264,  878, 1033,
 /*   290 */  1034,  326, 1331,  975,  879,   53,  882,  883,  204,  879,
 /*   300 */   926,  882,  883,  204,  876,  926,  290, 1280,  327,  330,
 /*   310 */   289,  313, 1137,   11,  340,  721, 1373,  720,  119, 1264,
 /*   320 */   223, 1191,  221,  220,  355,  288,  332,  328, 1238, 1372,
 /*   330 */  1064,  291, 1212, 1371,    1,  722,  119,  368, 1373, 1280,
 /*   340 */    63, 1265, 1266, 1269, 1312,  404,  353,  369,  231, 1308,
 /*   350 */   113,  118,  366,   30,   28, 1371,  355,  369,  434,  900,
 /*   360 */  1238,  238,  367,  878,  395,  167, 1264,  975, 1144, 1340,
 /*   370 */   877, 1238,   63, 1265, 1266, 1269, 1312, 1191, 1144,  876,
 /*   380 */   231, 1308, 1385,  250, 1063,   12, 1280,  192, 1189,  331,
 /*   390 */  1174, 1369,  879,  353,  882,  883,  204,  337,  926,  139,
 /*   400 */   251, 1062,  137,  355,   30,   28,  354, 1238,  105,    7,
 /*   410 */   369,  303,  238,  348,  878,  186, 1146,   44,   93,   63,
 /*   420 */  1265, 1266, 1269, 1312, 1061, 1238,  311,  231, 1308, 1385,
 /*   430 */   876, 1144,  945,  434, 1140,  987,   30,   28, 1330,  345,
 /*   440 */   147,  900, 1238,  306,  238,  877,  878,   91,  300, 1060,
 /*   450 */  1326,  146, 1264, 1059,   21, 1191,  901,  116, 1319, 1320,
 /*   460 */     7, 1324,  876,  949,  899, 1238, 1190,  879, 1323,  882,
 /*   470 */   883,  204, 1280,  926,   41,   30,   28,   40, 1004,  353,
 /*   480 */  1121, 1326,  369,  238,  434,  878, 1058,  252, 1208,  355,
 /*   490 */  1238,  119,    7, 1238, 1238,  122,  877, 1039,  341, 1322,
 /*   500 */   344,  876,  349, 1144, 1057,  205, 1265, 1266, 1269,  323,
 /*   510 */  1002, 1003, 1005, 1006, 1326,  290,  434, 1056,  879,  289,
 /*   520 */   882,  883,  204, 1055,  926, 1373,  346, 1238,  877,  898,
 /*   530 */  1052,    1, 1321,    9,    8,  903,  258,  401,  118,  270,
 /*   540 */   291,  400, 1371, 1264,  141, 1238,  253,  140,  271, 1133,
 /*   550 */   879,  352,  882,  883,  204,  434,  926,  143, 1238,  886,
 /*   560 */   142, 1051,  402, 1280, 1238,   20, 1050,  877, 1049, 1112,
 /*   570 */   353, 1238, 1129, 1373, 1264,   31,   29,   27,   26,   25,
 /*   580 */   355,  399,  398,  397, 1238,  396,  118, 1036, 1037,  879,
 /*   590 */  1371,  882,  883,  204, 1280,  926,   64, 1265, 1266, 1269,
 /*   600 */  1312,  353, 1238,  145, 1311, 1308,  144, 1238, 1131, 1238,
 /*   610 */  1048,  355, 1047, 1264,  315, 1238,  269, 1046, 1264,  264,
 /*   620 */   263,  262,  261,  260, 1045,  889,   99,   64, 1265, 1266,
 /*   630 */  1269, 1312,  935, 1280, 1001,  351, 1308,  153, 1280,  298,
 /*   640 */   353,  293, 1080, 1127,  297,  353,   42,  296, 1075,  294,
 /*   650 */   355, 1238,  295, 1238, 1238,  355, 1264, 1119, 1238, 1238,
 /*   660 */  1042,  885, 1044,  343,  299, 1238,  108, 1265, 1266, 1269,
 /*   670 */   301,   64, 1265, 1266, 1269, 1312, 1280,  169,  394, 1054,
 /*   680 */  1309,   78,  158,  353,   77,   76,   75,   74,   73,   72,
 /*   690 */    71,   70,   69,  355,  156,  324, 1264, 1238, 1073,  878,
 /*   700 */   237, 1264, 1185, 1238,  342, 1386,  162,  950,  283,  209,
 /*   710 */  1265, 1266, 1269, 1258,  401,  876, 1280, 1342,  400,   32,
 /*   720 */   304, 1280,  910,  353,  865, 1256,  338,  888,  353, 1281,
 /*   730 */   171,  871,  177,  355,   32,  361,   32, 1238,  355,  402,
 /*   740 */   320,  183, 1238, 1264,  175,    2,  190,   96,  898,  209,
 /*   750 */  1265, 1266, 1269,   97,  208, 1265, 1266, 1269,  399,  398,
 /*   760 */   397, 1210,  396, 1280,  121,   22,  259,  267,  266,  434,
 /*   770 */   353,  786,  268, 1264,  272,   31,   29,   27,   26,   25,
 /*   780 */   355,  877,  781,   99, 1238,  906,  333,  126,   31,   29,
 /*   790 */    27,   26,   25, 1280,   42, 1264,  108, 1265, 1266, 1269,
 /*   800 */   353,  273,  274,  879,  814,  882,  883,  818,  905,  824,
 /*   810 */   355,  823,  100,  129, 1238, 1280,  374,  235,  275,   97,
 /*   820 */   437,   98,  353,   99,   97,  278,  209, 1265, 1266, 1269,
 /*   830 */    43,  132,  355,  904,  189, 1387, 1238,   89,  287,  239,
 /*   840 */   285,  314,  227,  426,  317,  188,   59,   88,  209, 1265,
 /*   850 */  1266, 1269, 1041, 1134,   78,  136,   55,   77,   76,   75,
 /*   860 */    74,   73,   72,   71,   70,   69, 1130,  138,   61,  101,
 /*   870 */  1264,  184,  102, 1132, 1128,  103,   87,   86,   85,   84,
 /*   880 */    83,   82,   81,   80,   79,  104,  316,  148,  151,  925,
 /*   890 */  1280,  927,  928,  929,  930,  931,  903,  353, 1353,  325,
 /*   900 */   197, 1264,  365,  359,  154,  199,  883,  355,  322, 1343,
 /*   910 */   157, 1238, 1352,  230,  329,    5,  161,  198,  334,  318,
 /*   920 */   321, 1280,  149,  207, 1265, 1266, 1269,  125,  353,  975,
 /*   930 */  1333, 1264,   31,   29,   27,   26,   25,  111,  355,    4,
 /*   940 */   163,  902, 1238,   92, 1327,   33,  232,   17,  164,  347,
 /*   950 */   350, 1280, 1388, 1264,  210, 1265, 1266, 1269,  353, 1294,
 /*   960 */  1370,  362,  170,  179,  191, 1219, 1218,  357,  355,  358,
 /*   970 */   364,  240, 1238, 1280,  363, 1264,  181,   52, 1145,   54,
 /*   980 */   353,  372,  193,  187,  202, 1265, 1266, 1269,   65,  913,
 /*   990 */   355,  433,  195,   39, 1238, 1280,  200, 1264,  201,  196,
 /*  1000 */  1232,  874,  353,  873, 1226,  120,  211, 1265, 1266, 1269,
 /*  1010 */   848, 1203,  355, 1202,   95, 1201, 1238, 1280, 1200, 1264,
 /*  1020 */  1199, 1198, 1197, 1196,  353,  850, 1195, 1194,  203, 1265,
 /*  1030 */  1266, 1269,  119, 1193,  355, 1192, 1086, 1225, 1238, 1280,
 /*  1040 */  1216, 1264,  128, 1123,  733, 1085,  353, 1083,  279,  281,
 /*  1050 */   212, 1265, 1266, 1269, 1072,  280,  355, 1071, 1068, 1125,
 /*  1060 */  1238, 1280,   68, 1264,  135, 1124,  831,  830,  353,  761,
 /*  1070 */   829, 1081, 1277, 1265, 1266, 1269,  760,  759,  355,  758,
 /*  1080 */   757, 1076, 1238, 1280,  756,  224,  225, 1264,  302, 1074,
 /*  1090 */   353,  226, 1067,  305, 1276, 1265, 1266, 1269,  307, 1066,
 /*  1100 */   355,  309,   66, 1224, 1238, 1223,   36, 1280,  152,  150,
 /*  1110 */    14, 1264, 1215,    3,  353,   32, 1275, 1265, 1266, 1269,
 /*  1120 */   245,  244,  155,   15,  355,   37,   34,   10, 1238,   46,
 /*  1130 */   891, 1280,  160, 1264,   49, 1022, 1000,  994,  353,  993,
 /*  1140 */   218, 1265, 1266, 1269,  972,  109,  884, 1021,  355,  233,
 /*  1150 */     8,  159, 1238, 1280,   47, 1264,   48, 1026, 1256,  971,
 /*  1160 */   353,   19, 1025, 1027,  217, 1265, 1266, 1269,   35,  234,
 /*  1170 */   355,  166,   13,  117, 1238, 1280,   16, 1264,  936,  911,
 /*  1180 */   173,   18,  353,  174,  998,  176,  219, 1265, 1266, 1269,
 /*  1190 */   178,   50,  355,  360, 1214,  180, 1238, 1280,   55,  893,
 /*  1200 */   370,  182,   51,   38,  353, 1255,  185,  371,  216, 1265,
 /*  1210 */  1266, 1269,  887,  815,  355,  375,  134,  373, 1238,  112,
 /*  1220 */   247,  807,  812,  377,  378,  282,  809,  133,  380,  381,
 /*  1230 */   206, 1265, 1266, 1269,  892,  803,  895,  883,  383,  384,
 /*  1240 */   386,  801,  387,  806,  805,  804,  792,  393,   56,  826,
 /*  1250 */    45,  822,   57,  131,   58,  821,  820,  731,  825,  403,
 /*  1260 */   753,  752,  745,  751,  750,  749,  748,  747,  746,  744,
 /*  1270 */   743,  742, 1082,  741,  740,  739, 1070,  738, 1069,  737,
 /*  1280 */   736,  423,  424,  427,  428, 1065,  431,  425,  432, 1040,
 /*  1290 */   880,  194,  435,  436, 1040, 1040, 1040, 1040, 1040, 1040,
 /*  1300 */   130, 1040, 1040, 1040,  127,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   220,  185,  237,  238,  216,  216,  225,  219,  228,  229,
 /*    10 */   222,  222,   12,   13,   14,   15,   16,  179,  185,  185,
 /*    20 */     1,    2,  206,  190,  190,   12,   13,   14,   15,   16,
 /*    30 */   197,  197,  185,  252,  178,  184,  180,  199,  185,  206,
 /*    40 */   206,  225,  179,  190,  206,  194,  265,   47,    0,  208,
 /*    50 */   269,  235,  201,  206,  216,    4,  215,  216,  220,  206,
 /*    60 */    47,  245,  246,  247,  198,  249,    0,  187,  252,   69,
 /*    70 */   232,  233,  234,  235,  236,  209,  196,   77,  240,  241,
 /*    80 */   242,  265,  235,  220,  204,  269,  188,  189,   69,  251,
 /*    90 */    77,  244,  245,  246,  247,  185,  249,   49,   50,   51,
 /*   100 */    52,   53,   54,   55,   56,   57,   58,   59,   60,   61,
 /*   110 */    62,   63,   64,   65,   66,   49,  116,   51,  199,  191,
 /*   120 */    54,  211,   20,   57,   20,   59,  207,  199,   62,  116,
 /*   130 */    12,   13,   14,   15,   16,  207,   20,    0,  138,  139,
 /*   140 */   140,  141,  142,  143,  144,  145,  146,  147,   14,   15,
 /*   150 */    16,  138,  139,  140,  141,  142,  143,  144,  145,  146,
 /*   160 */   147,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   170 */    92,   93,  179,   95,   96,   97,   98,   99,  100,  203,
 /*   180 */    12,   13,  185,   46,   68,   12,   13,   14,   20,   46,
 /*   190 */    22,  203,  199,   20,  179,   22,  220,   21,  125,  206,
 /*   200 */   127,  199,  151,  206,  228,  229,   38,  205,  220,  216,
 /*   210 */    34,   38,  210,  220,  199,   47,  228,  229,  225,  185,
 /*   220 */    47,  206,  191,  150,  190,  232,  233,  234,  235,  236,
 /*   230 */   199,  216,  235,  240,  241,  220,   68,   63,  207,    0,
 /*   240 */   206,   68,  245,  246,  247,  252,  249,  232,  233,  234,
 /*   250 */   235,  236,  150,  199,   22,  240,  241,  242,  265,  205,
 /*   260 */    92,   43,  269,   20,  210,   92,  150,  182,  183,  254,
 /*   270 */    38,  185,  104,  199,  199,  260,  261,  104,   12,   13,
 /*   280 */   206,  206,  108,  109,   35,   46,   20,  179,   22,  171,
 /*   290 */   172,  120,  148,  149,  126,  184,  128,  129,  130,  126,
 /*   300 */   132,  128,  129,  130,   38,  132,   57,  199,  234,  234,
 /*   310 */    61,  225,  201,   47,  206,   20,  252,   22,  150,  179,
 /*   320 */    71,  199,   73,   74,  216,   76,  155,  156,  220,  265,
 /*   330 */   179,   82,  210,  269,   68,   40,  150,   20,  252,  199,
 /*   340 */   232,  233,  234,  235,  236,   46,  206,  185,  240,  241,
 /*   350 */   242,  265,  190,   12,   13,  269,  216,  185,   92,   20,
 /*   360 */   220,   20,  190,   22,   79,  122,  179,  149,  206,  261,
 /*   370 */   104,  220,  232,  233,  234,  235,  236,  199,  206,   38,
 /*   380 */   240,  241,  242,  205,  179,   68,  199,  192,  210,   20,
 /*   390 */   195,  251,  126,  206,  128,  129,  130,  185,  132,   72,
 /*   400 */   191,  179,   75,  216,   12,   13,   14,  220,  199,   68,
 /*   410 */   185,    4,   20,   81,   22,  190,  207,  187,  206,  232,
 /*   420 */   233,  234,  235,  236,  179,  220,   19,  240,  241,  242,
 /*   430 */    38,  206,  116,   92,  204,   14,   12,   13,  251,   81,
 /*   440 */    33,   20,  220,   36,   20,  104,   22,  235,   41,  179,
 /*   450 */   230,   44,  179,  179,  138,  199,   20,  245,  246,  247,
 /*   460 */    68,  249,   38,  147,   20,  220,  210,  126,  248,  128,
 /*   470 */   129,  130,  199,  132,   67,   12,   13,   70,  128,  206,
 /*   480 */     0,  230,  185,   20,   92,   22,  179,  190,  206,  216,
 /*   490 */   220,  150,   68,  220,  220,  213,  104,  176,  225,  248,
 /*   500 */     3,   38,  170,  206,  179,  232,  233,  234,  235,  159,
 /*   510 */   160,  161,  162,  163,  230,   57,   92,  179,  126,   61,
 /*   520 */   128,  129,  130,  179,  132,  252,  168,  220,  104,   20,
 /*   530 */   179,   68,  248,    1,    2,   20,   27,   57,  265,   30,
 /*   540 */    82,   61,  269,  179,   72,  220,  225,   75,   39,  200,
 /*   550 */   126,   47,  128,  129,  130,   92,  132,   72,  220,   38,
 /*   560 */    75,  179,   82,  199,  220,    2,  179,  104,  179,  189,
 /*   570 */   206,  220,  200,  252,  179,   12,   13,   14,   15,   16,
 /*   580 */   216,  101,  102,  103,  220,  105,  265,  174,  175,  126,
 /*   590 */   269,  128,  129,  130,  199,  132,  232,  233,  234,  235,
 /*   600 */   236,  206,  220,   72,  240,  241,   75,  220,  200,  220,
 /*   610 */   179,  216,  179,  179,   69,  220,  107,  179,  179,  110,
 /*   620 */   111,  112,  113,  114,  179,  104,   81,  232,  233,  234,
 /*   630 */   235,  236,  128,  199,   69,  240,  241,  122,  199,   49,
 /*   640 */   206,   51,    0,  200,   54,  206,   81,   57,    0,   59,
 /*   650 */   216,  220,   62,  220,  220,  216,  179,    0,  220,  220,
 /*   660 */     0,   38,  179,  166,   22,  220,  232,  233,  234,  235,
 /*   670 */    22,  232,  233,  234,  235,  236,  199,  272,  200,  180,
 /*   680 */   241,   21,   69,  206,   24,   25,   26,   27,   28,   29,
 /*   690 */    30,   31,   32,  216,   81,  263,  179,  220,    0,   22,
 /*   700 */   223,  179,  209,  220,  270,  271,  257,   69,  182,  232,
 /*   710 */   233,  234,  235,   68,   57,   38,  199,  231,   61,   81,
 /*   720 */    22,  199,   69,  206,   69,   80,  250,  104,  206,  199,
 /*   730 */   266,  124,   69,  216,   81,   69,   81,  220,  216,   82,
 /*   740 */   223,   69,  220,  179,   81,  253,  226,   81,   20,  232,
 /*   750 */   233,  234,  235,   81,  232,  233,  234,  235,  101,  102,
 /*   760 */   103,  185,  105,  199,  115,    2,  214,  116,  212,   92,
 /*   770 */   206,   69,  212,  179,  185,   12,   13,   14,   15,   16,
 /*   780 */   216,  104,   69,   81,  220,   20,  264,  187,   12,   13,
 /*   790 */    14,   15,   16,  199,   81,  179,  232,  233,  234,  235,
 /*   800 */   206,  224,  206,  126,   69,  128,  129,   69,   20,   69,
 /*   810 */   216,   69,   69,  187,  220,  199,   81,  223,  217,   81,
 /*   820 */    19,   81,  206,   81,   81,  185,  232,  233,  234,  235,
 /*   830 */   187,  187,  216,   20,   33,  271,  220,   36,  199,  223,
 /*   840 */   181,  224,  181,   42,  217,   44,   68,  185,  232,  233,
 /*   850 */   234,  235,    0,  199,   21,  199,   78,   24,   25,   26,
 /*   860 */    27,   28,   29,   30,   31,   32,  199,  199,   67,  199,
 /*   870 */   179,   70,  199,  199,  199,  199,   24,   25,   26,   27,
 /*   880 */    28,   29,   30,   31,   32,  199,  206,  184,  184,  131,
 /*   890 */   199,  133,  134,  135,  136,  137,   20,  206,  262,  158,
 /*   900 */    18,  179,  101,  157,  221,   23,  129,  216,  220,  231,
 /*   910 */   221,  220,  262,  220,  220,  165,  258,   35,  164,  118,
 /*   920 */   153,  199,  121,  232,  233,  234,  235,   45,  206,  149,
 /*   930 */   259,  179,   12,   13,   14,   15,   16,  256,  216,  152,
 /*   940 */   255,   20,  220,  206,  230,  115,  173,   68,  243,  167,
 /*   950 */   169,  199,  273,  179,  232,  233,  234,  235,  206,  239,
 /*   960 */   268,  119,  267,  206,  195,  221,  221,  220,  216,  220,
 /*   970 */   217,  220,  220,  199,  218,  179,  184,  184,  206,   68,
 /*   980 */   206,  202,  185,  184,  232,  233,  234,  235,  106,   69,
 /*   990 */   216,  181,  186,  227,  220,  199,  193,  179,  193,  177,
 /*  1000 */     0,  104,  206,  126,    0,  123,  232,  233,  234,  235,
 /*  1010 */    80,    0,  216,    0,  115,    0,  220,  199,    0,  179,
 /*  1020 */     0,    0,    0,    0,  206,   22,    0,    0,  232,  233,
 /*  1030 */   234,  235,  150,    0,  216,    0,    0,    0,  220,  199,
 /*  1040 */     0,  179,   43,    0,   48,    0,  206,    0,   38,   43,
 /*  1050 */   232,  233,  234,  235,    0,   36,  216,    0,    0,    0,
 /*  1060 */   220,  199,   77,  179,   75,    0,   38,   38,  206,   38,
 /*  1070 */    22,    0,  232,  233,  234,  235,   38,   38,  216,   38,
 /*  1080 */    38,    0,  220,  199,   38,   22,   22,  179,   39,    0,
 /*  1090 */   206,   22,    0,   38,  232,  233,  234,  235,   22,    0,
 /*  1100 */   216,   22,   20,    0,  220,    0,  122,  199,  117,   43,
 /*  1110 */   154,  179,    0,   81,  206,   81,  232,  233,  234,  235,
 /*  1120 */    12,   13,   69,  154,  216,   81,  148,  154,  220,   68,
 /*  1130 */    22,  199,   81,  179,    4,   38,   69,   69,  206,   69,
 /*  1140 */   232,  233,  234,  235,   69,   68,   38,   38,  216,   38,
 /*  1150 */     2,   68,  220,  199,   68,  179,   68,   38,   80,   69,
 /*  1160 */   206,   81,   38,   69,  232,  233,  234,  235,   81,   38,
 /*  1170 */   216,   80,   68,   80,  220,  199,   81,  179,  128,   69,
 /*  1180 */    80,   68,  206,   69,   69,   68,  232,  233,  234,  235,
 /*  1190 */    68,   68,  216,  120,    0,   43,  220,  199,   78,   22,
 /*  1200 */    92,  117,   68,   68,  206,   80,   80,   79,  232,  233,
 /*  1210 */   234,  235,  104,   69,  216,   68,   33,   38,  220,   36,
 /*  1220 */    38,   94,   69,   38,   68,   42,   69,   44,   38,   68,
 /*  1230 */   232,  233,  234,  235,  126,   69,  128,  129,   38,   68,
 /*  1240 */    38,   69,   68,   94,   94,   94,   22,   82,   68,   38,
 /*  1250 */    67,   38,   68,   70,   68,   38,   22,   48,  104,   47,
 /*  1260 */    22,   38,   22,   38,   38,   38,   38,   38,   38,   38,
 /*  1270 */    38,   38,    0,   38,   38,   38,    0,   38,    0,   38,
 /*  1280 */    38,   38,   36,   38,   37,    0,   22,   43,   21,  274,
 /*  1290 */    22,   22,   21,   20,  274,  274,  274,  274,  274,  274,
 /*  1300 */   117,  274,  274,  274,  121,  274,  274,  274,  274,  274,
 /*  1310 */   274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
 /*  1320 */   274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
 /*  1330 */   274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
 /*  1340 */   274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
 /*  1350 */   274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
 /*  1360 */   274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
 /*  1370 */   274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
 /*  1380 */   274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
 /*  1390 */   274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
 /*  1400 */   274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
 /*  1410 */   274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
 /*  1420 */   274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
 /*  1430 */   274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
 /*  1440 */   274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
 /*  1450 */   274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
 /*  1460 */   274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
};
#define YY_SHIFT_COUNT    (437)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1285)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   882,  168,  173,  266,  266,  266,  266,  341,  266,  266,
 /*    10 */   424,  463,  116,  392,  424,  424,  424,  424,  424,  424,
 /*    20 */   424,  424,  424,  424,  424,  424,  424,  424,  424,  424,
 /*    30 */   424,  424,  424,  317,  317,  317,  102, 1108, 1108,   73,
 /*    40 */   104,  104, 1108,  104,  104,  143,  339,  369,  369,  186,
 /*    50 */   436,  339,  104,  104,  339,  104,  339,  436,  339,  339,
 /*    60 */   104,  299,    0,   13,   13,  509,  833,  249,  677,  677,
 /*    70 */   677,  677,  677,  677,  677,  677,  677,  677,  677,  677,
 /*    80 */   677,  677,  677,  677,  677,  677,  677,  677,  590,  295,
 /*    90 */   137,  243,  243,  243,  239,  444,  436,  339,  339,  339,
 /*   100 */   285,   78,   78,   78,   78,   78,  660,   66,  118,  350,
 /*   110 */   458,  171,  232,  515,  144,  218,  144,  421,  497,   51,
 /*   120 */   607,  728,  649,  651,  651,  728,  765,  143,  444,  788,
 /*   130 */   143,  143,  728,  143,  813,  339,  339,  339,  339,  339,
 /*   140 */   339,  339,  339,  339,  339,  339,  728,  813,  765,  299,
 /*   150 */   444,  788,  299,  876,  741,  746,  777,  741,  746,  777,
 /*   160 */   777,  750,  754,  767,  787,  780,  444,  921,  830,  773,
 /*   170 */   781,  782,  879,  339,  746,  777,  777,  746,  777,  842,
 /*   180 */   444,  788,  299,  285,  299,  444,  911,  728,  299,  813,
 /*   190 */  1305, 1305, 1305, 1305, 1305,   48,  852,  801, 1183,  407,
 /*   200 */   480,  657,  563,  763,  758,  920,  776,  776,  776,  776,
 /*   210 */   776,  776,  776,  174,   19,  316,  134,  134,  134,  134,
 /*   220 */   327,  472,  485,  531,  642,  648,  698,  176,  545,  565,
 /*   230 */   613,  532,  413,  358,  332,  638,  504,  653,  645,  655,
 /*   240 */   663,  666,  672,  702,  521,  623,  713,  735,  738,  740,
 /*   250 */   742,  743,  778, 1000,  897,  877, 1004,  930, 1011, 1013,
 /*   260 */   899, 1015, 1018, 1020, 1021, 1022, 1023, 1003, 1026, 1027,
 /*   270 */  1033, 1035, 1036, 1037, 1040,  999, 1043,  996, 1045, 1047,
 /*   280 */  1010, 1019, 1006, 1054, 1057, 1058, 1059,  985,  989, 1028,
 /*   290 */  1029, 1048, 1065, 1031, 1038, 1039, 1041, 1042, 1046, 1071,
 /*   300 */  1063, 1081, 1064, 1049, 1089, 1069, 1055, 1092, 1076, 1099,
 /*   310 */  1079, 1082, 1103, 1105,  984, 1112, 1061, 1066,  991, 1032,
 /*   320 */  1034,  956, 1053, 1044, 1067, 1077, 1083, 1068, 1086, 1070,
 /*   330 */  1051, 1078, 1088, 1080,  969, 1075, 1090, 1091,  978, 1087,
 /*   340 */  1093, 1094, 1095,  973, 1130, 1097, 1109, 1111, 1119, 1124,
 /*   350 */  1131, 1148, 1050, 1100, 1110, 1104, 1113, 1114, 1115, 1117,
 /*   360 */  1122, 1073, 1123, 1194, 1152, 1084, 1134, 1120, 1125, 1126,
 /*   370 */  1177, 1135, 1128, 1144, 1179, 1182, 1147, 1153, 1185, 1156,
 /*   380 */  1157, 1190, 1161, 1166, 1200, 1171, 1172, 1202, 1174, 1127,
 /*   390 */  1149, 1150, 1151, 1224, 1165, 1180, 1211, 1154, 1184, 1186,
 /*   400 */  1213, 1217, 1234, 1209, 1212, 1238, 1223, 1225, 1226, 1227,
 /*   410 */  1228, 1229, 1230, 1240, 1231, 1232, 1233, 1235, 1236, 1237,
 /*   420 */  1239, 1241, 1242, 1272, 1243, 1246, 1244, 1276, 1245, 1247,
 /*   430 */  1278, 1285, 1264, 1267, 1268, 1269, 1271, 1273,
};
#define YY_REDUCE_COUNT (194)
#define YY_REDUCE_MIN   (-235)
#define YY_REDUCE_MAX   (998)
static const short yy_reduce_ofst[] = {
 /*     0 */   321,   -7,   15,  108, -162,  140,  187,  273,  364,  395,
 /*    10 */   434,  439, -184,  477,  517,  522,  564,  594,  616,  691,
 /*    20 */   722,  752,  774,  796,  818,  840,  862,  884,  908,  932,
 /*    30 */   954,  976,  998, -153,   -3,  212,   86,  -24,  -12, -219,
 /*    40 */  -167, -166, -220, -147,   34, -120,    2,   74,   75,   64,
 /*    50 */  -212,  -72,  162,  172,   54,  225,   31, -159,  178,  209,
 /*    60 */   297, -149, -235, -235, -235,  -90, -144, -134, -137,  151,
 /*    70 */   205,  222,  245,  270,  274,  307,  325,  338,  344,  351,
 /*    80 */   382,  387,  389,  431,  433,  438,  445,  483, -102,   85,
 /*    90 */   230,  220,  251,  284,  111,  282, -211,  -81,  122,  256,
 /*   100 */   195,  349,  372,  408,  443,  478,  499,  380,  405,  432,
 /*   110 */   493,  449,  526,  486,  476,  476,  476,  530,  464,  492,
 /*   120 */   520,  576,  552,  556,  560,  589,  577,  600,  596,  601,
 /*   130 */   626,  643,  640,  644,  659,  639,  654,  656,  667,  668,
 /*   140 */   670,  673,  674,  675,  676,  686,  662,  661,  617,  703,
 /*   150 */   680,  627,  704,  678,  636,  683,  688,  650,  689,  693,
 /*   160 */   694,  671,  658,  681,  685,  476,  737,  714,  705,  679,
 /*   170 */   692,  695,  720,  530,  744,  747,  749,  745,  751,  756,
 /*   180 */   757,  753,  792,  769,  793,  772,  779,  797,  799,  810,
 /*   190 */   766,  803,  805,  806,  822,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*    10 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*    20 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*    30 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*    40 */  1038, 1038, 1038, 1038, 1038, 1091, 1038, 1038, 1038, 1038,
 /*    50 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*    60 */  1038, 1089, 1038, 1314, 1038, 1204, 1038, 1038, 1038, 1038,
 /*    70 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*    80 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*    90 */  1091, 1325, 1325, 1325, 1089, 1038, 1038, 1038, 1038, 1038,
 /*   100 */  1173, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1389, 1038,
 /*   110 */  1126, 1349, 1038, 1341, 1317, 1331, 1318, 1038, 1374, 1334,
 /*   120 */  1227, 1038, 1209, 1206, 1206, 1038, 1038, 1091, 1038, 1038,
 /*   130 */  1091, 1091, 1038, 1091, 1038, 1038, 1038, 1038, 1038, 1038,
 /*   140 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1089,
 /*   150 */  1038, 1038, 1089, 1038, 1356, 1354, 1038, 1356, 1354, 1038,
 /*   160 */  1038, 1368, 1364, 1347, 1345, 1331, 1038, 1038, 1038, 1392,
 /*   170 */  1380, 1376, 1038, 1038, 1354, 1038, 1038, 1354, 1038, 1217,
 /*   180 */  1038, 1038, 1089, 1038, 1089, 1038, 1142, 1038, 1089, 1038,
 /*   190 */  1229, 1176, 1176, 1092, 1043, 1038, 1038, 1038, 1038, 1038,
 /*   200 */  1038, 1038, 1038, 1038, 1038, 1038, 1279, 1367, 1366, 1278,
 /*   210 */  1291, 1290, 1289, 1038, 1038, 1038, 1273, 1274, 1272, 1271,
 /*   220 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*   230 */  1038, 1315, 1038, 1377, 1381, 1038, 1038, 1038, 1257, 1038,
 /*   240 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*   250 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*   260 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*   270 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*   280 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*   290 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*   300 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*   310 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1338,
 /*   320 */  1348, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*   330 */  1038, 1257, 1038, 1365, 1038, 1324, 1320, 1038, 1038, 1316,
 /*   340 */  1038, 1038, 1375, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*   350 */  1038, 1310, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*   360 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1256, 1038,
 /*   370 */  1038, 1038, 1038, 1038, 1038, 1038, 1170, 1038, 1038, 1038,
 /*   380 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1155,
 /*   390 */  1153, 1152, 1151, 1038, 1148, 1038, 1038, 1038, 1038, 1038,
 /*   400 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*   410 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*   420 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
 /*   430 */  1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "DATABASE",
  /*   45 */ "USE",
  /*   46 */ "IF",
  /*   47 */ "NOT",
  /*   48 */ "EXISTS",
  /*   49 */ "BLOCKS",
  /*   50 */ "CACHE",
  /*   51 */ "CACHELAST",
  /*   52 */ "COMP",
  /*   53 */ "DAYS",
  /*   54 */ "FSYNC",
  /*   55 */ "MAXROWS",
  /*   56 */ "MINROWS",
  /*   57 */ "KEEP",
  /*   58 */ "PRECISION",
  /*   59 */ "QUORUM",
  /*   60 */ "REPLICA",
  /*   61 */ "TTL",
  /*   62 */ "WAL",
  /*   63 */ "VGROUPS",
  /*   64 */ "SINGLE_STABLE",
  /*   65 */ "STREAM_MODE",
  /*   66 */ "RETENTIONS",
  /*   67 */ "TABLE",
  /*   68 */ "NK_LP",
  /*   69 */ "NK_RP",
  /*   70 */ "STABLE",
  /*   71 */ "ADD",
  /*   72 */ "COLUMN",
  /*   73 */ "MODIFY",
  /*   74 */ "RENAME",
  /*   75 */ "TAG",
  /*   76 */ "SET",
  /*   77 */ "NK_EQ",
  /*   78 */ "USING",
  /*   79 */ "TAGS",
  /*   80 */ "NK_DOT",
  /*   81 */ "NK_COMMA",
  /*   82 */ "COMMENT",
  /*   83 */ "BOOL",
  /*   84 */ "TINYINT",
  /*   85 */ "SMALLINT",
  /*   86 */ "INT",
  /*   87 */ "INTEGER",
  /*   88 */ "BIGINT",
  /*   89 */ "FLOAT",
  /*   90 */ "DOUBLE",
  /*   91 */ "BINARY",
  /*   92 */ "TIMESTAMP",
  /*   93 */ "NCHAR",
  /*   94 */ "UNSIGNED",
  /*   95 */ "JSON",
  /*   96 */ "VARCHAR",
  /*   97 */ "MEDIUMBLOB",
  /*   98 */ "BLOB",
  /*   99 */ "VARBINARY",
  /*  100 */ "DECIMAL",
  /*  101 */ "SMA",
  /*  102 */ "ROLLUP",
  /*  103 */ "FILE_FACTOR",
  /*  104 */ "NK_FLOAT",
  /*  105 */ "DELAY",
  /*  106 */ "SHOW",
  /*  107 */ "DATABASES",
  /*  108 */ "TABLES",
  /*  109 */ "STABLES",
  /*  110 */ "MNODES",
  /*  111 */ "MODULES",
  /*  112 */ "QNODES",
  /*  113 */ "FUNCTIONS",
  /*  114 */ "INDEXES",
  /*  115 */ "FROM",
  /*  116 */ "LIKE",
  /*  117 */ "INDEX",
  /*  118 */ "FULLTEXT",
  /*  119 */ "FUNCTION",
  /*  120 */ "INTERVAL",
  /*  121 */ "TOPIC",
  /*  122 */ "AS",
  /*  123 */ "EXPLAIN",
  /*  124 */ "ANALYZE",
  /*  125 */ "VERBOSE",
  /*  126 */ "NK_BOOL",
  /*  127 */ "RATIO",
  /*  128 */ "NULL",
  /*  129 */ "NK_VARIABLE",
  /*  130 */ "NK_UNDERLINE",
  /*  131 */ "ROWTS",
  /*  132 */ "TBNAME",
  /*  133 */ "QSTARTTS",
  /*  134 */ "QENDTS",
  /*  135 */ "WSTARTTS",
  /*  136 */ "WENDTS",
  /*  137 */ "WDURATION",
  /*  138 */ "BETWEEN",
  /*  139 */ "IS",
  /*  140 */ "NK_LT",
  /*  141 */ "NK_GT",
  /*  142 */ "NK_LE",
  /*  143 */ "NK_GE",
  /*  144 */ "NK_NE",
  /*  145 */ "MATCH",
  /*  146 */ "NMATCH",
  /*  147 */ "IN",
  /*  148 */ "JOIN",
  /*  149 */ "INNER",
  /*  150 */ "SELECT",
  /*  151 */ "DISTINCT",
  /*  152 */ "WHERE",
  /*  153 */ "PARTITION",
  /*  154 */ "BY",
  /*  155 */ "SESSION",
  /*  156 */ "STATE_WINDOW",
  /*  157 */ "SLIDING",
  /*  158 */ "FILL",
  /*  159 */ "VALUE",
  /*  160 */ "NONE",
  /*  161 */ "PREV",
  /*  162 */ "LINEAR",
  /*  163 */ "NEXT",
  /*  164 */ "GROUP",
  /*  165 */ "HAVING",
  /*  166 */ "ORDER",
  /*  167 */ "SLIMIT",
  /*  168 */ "SOFFSET",
  /*  169 */ "LIMIT",
  /*  170 */ "OFFSET",
  /*  171 */ "ASC",
  /*  172 */ "DESC",
  /*  173 */ "NULLS",
  /*  174 */ "FIRST",
  /*  175 */ "LAST",
  /*  176 */ "cmd",
  /*  177 */ "account_options",
  /*  178 */ "alter_account_options",
  /*  179 */ "literal",
  /*  180 */ "alter_account_option",
  /*  181 */ "user_name",
  /*  182 */ "dnode_endpoint",
  /*  183 */ "dnode_host_name",
  /*  184 */ "not_exists_opt",
  /*  185 */ "db_name",
  /*  186 */ "db_options",
  /*  187 */ "exists_opt",
  /*  188 */ "alter_db_options",
  /*  189 */ "alter_db_option",
  /*  190 */ "full_table_name",
  /*  191 */ "column_def_list",
  /*  192 */ "tags_def_opt",
  /*  193 */ "table_options",
  /*  194 */ "multi_create_clause",
  /*  195 */ "tags_def",
  /*  196 */ "multi_drop_clause",
  /*  197 */ "alter_table_clause",
  /*  198 */ "alter_table_options",
  /*  199 */ "column_name",
  /*  200 */ "type_name",
  /*  201 */ "create_subtable_clause",
  /*  202 */ "specific_tags_opt",
  /*  203 */ "literal_list",
  /*  204 */ "drop_table_clause",
  /*  205 */ "col_name_list",
  /*  206 */ "table_name",
  /*  207 */ "column_def",
  /*  208 */ "func_name_list",
  /*  209 */ "alter_table_option",
  /*  210 */ "col_name",
  /*  211 */ "db_name_cond_opt",
  /*  212 */ "like_pattern_opt",
  /*  213 */ "table_name_cond",
  /*  214 */ "from_db_opt",
  /*  215 */ "func_name",
  /*  216 */ "function_name",
  /*  217 */ "index_name",
  /*  218 */ "index_options",
  /*  219 */ "func_list",
  /*  220 */ "duration_literal",
  /*  221 */ "sliding_opt",
  /*  222 */ "func",
  /*  223 */ "expression_list",
  /*  224 */ "topic_name",
  /*  225 */ "query_expression",
  /*  226 */ "analyze_opt",
  /*  227 */ "explain_options",
  /*  228 */ "signed",
  /*  229 */ "signed_literal",
  /*  230 */ "table_alias",
  /*  231 */ "column_alias",
  /*  232 */ "expression",
  /*  233 */ "pseudo_column",
  /*  234 */ "column_reference",
  /*  235 */ "subquery",
  /*  236 */ "predicate",
  /*  237 */ "compare_op",
  /*  238 */ "in_op",
  /*  239 */ "in_predicate_value",
  /*  240 */ "boolean_value_expression",
  /*  241 */ "boolean_primary",
  /*  242 */ "common_expression",
  /*  243 */ "from_clause",
  /*  244 */ "table_reference_list",
  /*  245 */ "table_reference",
  /*  246 */ "table_primary",
  /*  247 */ "joined_table",
  /*  248 */ "alias_opt",
  /*  249 */ "parenthesized_joined_table",
  /*  250 */ "join_type",
  /*  251 */ "search_condition",
  /*  252 */ "query_specification",
  /*  253 */ "set_quantifier_opt",
  /*  254 */ "select_list",
  /*  255 */ "where_clause_opt",
  /*  256 */ "partition_by_clause_opt",
  /*  257 */ "twindow_clause_opt",
  /*  258 */ "group_by_clause_opt",
  /*  259 */ "having_clause_opt",
  /*  260 */ "select_sublist",
  /*  261 */ "select_item",
  /*  262 */ "fill_opt",
  /*  263 */ "fill_mode",
  /*  264 */ "group_by_list",
  /*  265 */ "query_expression_body",
  /*  266 */ "order_by_clause_opt",
  /*  267 */ "slimit_clause_opt",
  /*  268 */ "limit_clause_opt",
  /*  269 */ "query_primary",
  /*  270 */ "sort_specification_list",
  /*  271 */ "sort_specification",
  /*  272 */ "ordering_specification_opt",
  /*  273 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  44 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  45 */ "cmd ::= USE db_name",
 /*  46 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  47 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  48 */ "not_exists_opt ::=",
 /*  49 */ "exists_opt ::= IF EXISTS",
 /*  50 */ "exists_opt ::=",
 /*  51 */ "db_options ::=",
 /*  52 */ "db_options ::= db_options BLOCKS NK_INTEGER",
 /*  53 */ "db_options ::= db_options CACHE NK_INTEGER",
 /*  54 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  55 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  56 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  57 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  58 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  59 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  60 */ "db_options ::= db_options KEEP NK_INTEGER",
 /*  61 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  62 */ "db_options ::= db_options QUORUM NK_INTEGER",
 /*  63 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  64 */ "db_options ::= db_options TTL NK_INTEGER",
 /*  65 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  66 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  67 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  68 */ "db_options ::= db_options STREAM_MODE NK_INTEGER",
 /*  69 */ "db_options ::= db_options RETENTIONS NK_STRING",
 /*  70 */ "alter_db_options ::= alter_db_option",
 /*  71 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  72 */ "alter_db_option ::= BLOCKS NK_INTEGER",
 /*  73 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  74 */ "alter_db_option ::= KEEP NK_INTEGER",
 /*  75 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  76 */ "alter_db_option ::= QUORUM NK_INTEGER",
 /*  77 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  78 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  79 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  80 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /*  81 */ "cmd ::= DROP TABLE multi_drop_clause",
 /*  82 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /*  83 */ "cmd ::= ALTER TABLE alter_table_clause",
 /*  84 */ "cmd ::= ALTER STABLE alter_table_clause",
 /*  85 */ "alter_table_clause ::= full_table_name alter_table_options",
 /*  86 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /*  87 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /*  88 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /*  89 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /*  90 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /*  91 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /*  92 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /*  93 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /*  94 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /*  95 */ "multi_create_clause ::= create_subtable_clause",
 /*  96 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /*  97 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP",
 /*  98 */ "multi_drop_clause ::= drop_table_clause",
 /*  99 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 100 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 101 */ "specific_tags_opt ::=",
 /* 102 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 103 */ "full_table_name ::= table_name",
 /* 104 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 105 */ "column_def_list ::= column_def",
 /* 106 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 107 */ "column_def ::= column_name type_name",
 /* 108 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 109 */ "type_name ::= BOOL",
 /* 110 */ "type_name ::= TINYINT",
 /* 111 */ "type_name ::= SMALLINT",
 /* 112 */ "type_name ::= INT",
 /* 113 */ "type_name ::= INTEGER",
 /* 114 */ "type_name ::= BIGINT",
 /* 115 */ "type_name ::= FLOAT",
 /* 116 */ "type_name ::= DOUBLE",
 /* 117 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 118 */ "type_name ::= TIMESTAMP",
 /* 119 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 120 */ "type_name ::= TINYINT UNSIGNED",
 /* 121 */ "type_name ::= SMALLINT UNSIGNED",
 /* 122 */ "type_name ::= INT UNSIGNED",
 /* 123 */ "type_name ::= BIGINT UNSIGNED",
 /* 124 */ "type_name ::= JSON",
 /* 125 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 126 */ "type_name ::= MEDIUMBLOB",
 /* 127 */ "type_name ::= BLOB",
 /* 128 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 129 */ "type_name ::= DECIMAL",
 /* 130 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 131 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 132 */ "tags_def_opt ::=",
 /* 133 */ "tags_def_opt ::= tags_def",
 /* 134 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 135 */ "table_options ::=",
 /* 136 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 137 */ "table_options ::= table_options KEEP NK_INTEGER",
 /* 138 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 139 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 140 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 141 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 142 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 143 */ "alter_table_options ::= alter_table_option",
 /* 144 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 145 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 146 */ "alter_table_option ::= KEEP NK_INTEGER",
 /* 147 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 148 */ "col_name_list ::= col_name",
 /* 149 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 150 */ "col_name ::= column_name",
 /* 151 */ "cmd ::= SHOW DNODES",
 /* 152 */ "cmd ::= SHOW USERS",
 /* 153 */ "cmd ::= SHOW DATABASES",
 /* 154 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 155 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 156 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 157 */ "cmd ::= SHOW MNODES",
 /* 158 */ "cmd ::= SHOW MODULES",
 /* 159 */ "cmd ::= SHOW QNODES",
 /* 160 */ "cmd ::= SHOW FUNCTIONS",
 /* 161 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 162 */ "cmd ::= SHOW STREAMS",
 /* 163 */ "db_name_cond_opt ::=",
 /* 164 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 165 */ "like_pattern_opt ::=",
 /* 166 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 167 */ "table_name_cond ::= table_name",
 /* 168 */ "from_db_opt ::=",
 /* 169 */ "from_db_opt ::= FROM db_name",
 /* 170 */ "func_name_list ::= func_name",
 /* 171 */ "func_name_list ::= func_name_list NK_COMMA col_name",
 /* 172 */ "func_name ::= function_name",
 /* 173 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 174 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 175 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 176 */ "index_options ::=",
 /* 177 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 178 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 179 */ "func_list ::= func",
 /* 180 */ "func_list ::= func_list NK_COMMA func",
 /* 181 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 182 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 183 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name",
 /* 184 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 185 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 186 */ "analyze_opt ::=",
 /* 187 */ "analyze_opt ::= ANALYZE",
 /* 188 */ "explain_options ::=",
 /* 189 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 190 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 191 */ "cmd ::= query_expression",
 /* 192 */ "literal ::= NK_INTEGER",
 /* 193 */ "literal ::= NK_FLOAT",
 /* 194 */ "literal ::= NK_STRING",
 /* 195 */ "literal ::= NK_BOOL",
 /* 196 */ "literal ::= TIMESTAMP NK_STRING",
 /* 197 */ "literal ::= duration_literal",
 /* 198 */ "literal ::= NULL",
 /* 199 */ "duration_literal ::= NK_VARIABLE",
 /* 200 */ "signed ::= NK_INTEGER",
 /* 201 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 202 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 203 */ "signed ::= NK_FLOAT",
 /* 204 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 205 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 206 */ "signed_literal ::= signed",
 /* 207 */ "signed_literal ::= NK_STRING",
 /* 208 */ "signed_literal ::= NK_BOOL",
 /* 209 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 210 */ "signed_literal ::= duration_literal",
 /* 211 */ "signed_literal ::= NULL",
 /* 212 */ "literal_list ::= signed_literal",
 /* 213 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 214 */ "db_name ::= NK_ID",
 /* 215 */ "table_name ::= NK_ID",
 /* 216 */ "column_name ::= NK_ID",
 /* 217 */ "function_name ::= NK_ID",
 /* 218 */ "table_alias ::= NK_ID",
 /* 219 */ "column_alias ::= NK_ID",
 /* 220 */ "user_name ::= NK_ID",
 /* 221 */ "index_name ::= NK_ID",
 /* 222 */ "topic_name ::= NK_ID",
 /* 223 */ "expression ::= literal",
 /* 224 */ "expression ::= pseudo_column",
 /* 225 */ "expression ::= column_reference",
 /* 226 */ "expression ::= function_name NK_LP expression_list NK_RP",
 /* 227 */ "expression ::= function_name NK_LP NK_STAR NK_RP",
 /* 228 */ "expression ::= subquery",
 /* 229 */ "expression ::= NK_LP expression NK_RP",
 /* 230 */ "expression ::= NK_PLUS expression",
 /* 231 */ "expression ::= NK_MINUS expression",
 /* 232 */ "expression ::= expression NK_PLUS expression",
 /* 233 */ "expression ::= expression NK_MINUS expression",
 /* 234 */ "expression ::= expression NK_STAR expression",
 /* 235 */ "expression ::= expression NK_SLASH expression",
 /* 236 */ "expression ::= expression NK_REM expression",
 /* 237 */ "expression_list ::= expression",
 /* 238 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 239 */ "column_reference ::= column_name",
 /* 240 */ "column_reference ::= table_name NK_DOT column_name",
 /* 241 */ "pseudo_column ::= NK_UNDERLINE ROWTS",
 /* 242 */ "pseudo_column ::= TBNAME",
 /* 243 */ "pseudo_column ::= NK_UNDERLINE QSTARTTS",
 /* 244 */ "pseudo_column ::= NK_UNDERLINE QENDTS",
 /* 245 */ "pseudo_column ::= NK_UNDERLINE WSTARTTS",
 /* 246 */ "pseudo_column ::= NK_UNDERLINE WENDTS",
 /* 247 */ "pseudo_column ::= NK_UNDERLINE WDURATION",
 /* 248 */ "predicate ::= expression compare_op expression",
 /* 249 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 250 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 251 */ "predicate ::= expression IS NULL",
 /* 252 */ "predicate ::= expression IS NOT NULL",
 /* 253 */ "predicate ::= expression in_op in_predicate_value",
 /* 254 */ "compare_op ::= NK_LT",
 /* 255 */ "compare_op ::= NK_GT",
 /* 256 */ "compare_op ::= NK_LE",
 /* 257 */ "compare_op ::= NK_GE",
 /* 258 */ "compare_op ::= NK_NE",
 /* 259 */ "compare_op ::= NK_EQ",
 /* 260 */ "compare_op ::= LIKE",
 /* 261 */ "compare_op ::= NOT LIKE",
 /* 262 */ "compare_op ::= MATCH",
 /* 263 */ "compare_op ::= NMATCH",
 /* 264 */ "in_op ::= IN",
 /* 265 */ "in_op ::= NOT IN",
 /* 266 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 267 */ "boolean_value_expression ::= boolean_primary",
 /* 268 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 269 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 270 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 271 */ "boolean_primary ::= predicate",
 /* 272 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 273 */ "common_expression ::= expression",
 /* 274 */ "common_expression ::= boolean_value_expression",
 /* 275 */ "from_clause ::= FROM table_reference_list",
 /* 276 */ "table_reference_list ::= table_reference",
 /* 277 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 278 */ "table_reference ::= table_primary",
 /* 279 */ "table_reference ::= joined_table",
 /* 280 */ "table_primary ::= table_name alias_opt",
 /* 281 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 282 */ "table_primary ::= subquery alias_opt",
 /* 283 */ "table_primary ::= parenthesized_joined_table",
 /* 284 */ "alias_opt ::=",
 /* 285 */ "alias_opt ::= table_alias",
 /* 286 */ "alias_opt ::= AS table_alias",
 /* 287 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 288 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 289 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 290 */ "join_type ::=",
 /* 291 */ "join_type ::= INNER",
 /* 292 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 293 */ "set_quantifier_opt ::=",
 /* 294 */ "set_quantifier_opt ::= DISTINCT",
 /* 295 */ "set_quantifier_opt ::= ALL",
 /* 296 */ "select_list ::= NK_STAR",
 /* 297 */ "select_list ::= select_sublist",
 /* 298 */ "select_sublist ::= select_item",
 /* 299 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 300 */ "select_item ::= common_expression",
 /* 301 */ "select_item ::= common_expression column_alias",
 /* 302 */ "select_item ::= common_expression AS column_alias",
 /* 303 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 304 */ "where_clause_opt ::=",
 /* 305 */ "where_clause_opt ::= WHERE search_condition",
 /* 306 */ "partition_by_clause_opt ::=",
 /* 307 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 308 */ "twindow_clause_opt ::=",
 /* 309 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 310 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP",
 /* 311 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 312 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 313 */ "sliding_opt ::=",
 /* 314 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 315 */ "fill_opt ::=",
 /* 316 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 317 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 318 */ "fill_mode ::= NONE",
 /* 319 */ "fill_mode ::= PREV",
 /* 320 */ "fill_mode ::= NULL",
 /* 321 */ "fill_mode ::= LINEAR",
 /* 322 */ "fill_mode ::= NEXT",
 /* 323 */ "group_by_clause_opt ::=",
 /* 324 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 325 */ "group_by_list ::= expression",
 /* 326 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 327 */ "having_clause_opt ::=",
 /* 328 */ "having_clause_opt ::= HAVING search_condition",
 /* 329 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 330 */ "query_expression_body ::= query_primary",
 /* 331 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 332 */ "query_primary ::= query_specification",
 /* 333 */ "order_by_clause_opt ::=",
 /* 334 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 335 */ "slimit_clause_opt ::=",
 /* 336 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 337 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 338 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 339 */ "limit_clause_opt ::=",
 /* 340 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 341 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 342 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 343 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 344 */ "search_condition ::= common_expression",
 /* 345 */ "sort_specification_list ::= sort_specification",
 /* 346 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 347 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 348 */ "ordering_specification_opt ::=",
 /* 349 */ "ordering_specification_opt ::= ASC",
 /* 350 */ "ordering_specification_opt ::= DESC",
 /* 351 */ "null_ordering_opt ::=",
 /* 352 */ "null_ordering_opt ::= NULLS FIRST",
 /* 353 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 176: /* cmd */
    case 179: /* literal */
    case 186: /* db_options */
    case 188: /* alter_db_options */
    case 190: /* full_table_name */
    case 193: /* table_options */
    case 197: /* alter_table_clause */
    case 198: /* alter_table_options */
    case 201: /* create_subtable_clause */
    case 204: /* drop_table_clause */
    case 207: /* column_def */
    case 210: /* col_name */
    case 211: /* db_name_cond_opt */
    case 212: /* like_pattern_opt */
    case 213: /* table_name_cond */
    case 214: /* from_db_opt */
    case 215: /* func_name */
    case 218: /* index_options */
    case 220: /* duration_literal */
    case 221: /* sliding_opt */
    case 222: /* func */
    case 225: /* query_expression */
    case 227: /* explain_options */
    case 228: /* signed */
    case 229: /* signed_literal */
    case 232: /* expression */
    case 233: /* pseudo_column */
    case 234: /* column_reference */
    case 235: /* subquery */
    case 236: /* predicate */
    case 239: /* in_predicate_value */
    case 240: /* boolean_value_expression */
    case 241: /* boolean_primary */
    case 242: /* common_expression */
    case 243: /* from_clause */
    case 244: /* table_reference_list */
    case 245: /* table_reference */
    case 246: /* table_primary */
    case 247: /* joined_table */
    case 249: /* parenthesized_joined_table */
    case 251: /* search_condition */
    case 252: /* query_specification */
    case 255: /* where_clause_opt */
    case 257: /* twindow_clause_opt */
    case 259: /* having_clause_opt */
    case 261: /* select_item */
    case 262: /* fill_opt */
    case 265: /* query_expression_body */
    case 267: /* slimit_clause_opt */
    case 268: /* limit_clause_opt */
    case 269: /* query_primary */
    case 271: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy364)); 
}
      break;
    case 177: /* account_options */
    case 178: /* alter_account_options */
    case 180: /* alter_account_option */
{
 
}
      break;
    case 181: /* user_name */
    case 182: /* dnode_endpoint */
    case 183: /* dnode_host_name */
    case 185: /* db_name */
    case 199: /* column_name */
    case 206: /* table_name */
    case 216: /* function_name */
    case 217: /* index_name */
    case 224: /* topic_name */
    case 230: /* table_alias */
    case 231: /* column_alias */
    case 248: /* alias_opt */
{
 
}
      break;
    case 184: /* not_exists_opt */
    case 187: /* exists_opt */
    case 226: /* analyze_opt */
    case 253: /* set_quantifier_opt */
{
 
}
      break;
    case 189: /* alter_db_option */
    case 209: /* alter_table_option */
{
 
}
      break;
    case 191: /* column_def_list */
    case 192: /* tags_def_opt */
    case 194: /* multi_create_clause */
    case 195: /* tags_def */
    case 196: /* multi_drop_clause */
    case 202: /* specific_tags_opt */
    case 203: /* literal_list */
    case 205: /* col_name_list */
    case 208: /* func_name_list */
    case 219: /* func_list */
    case 223: /* expression_list */
    case 254: /* select_list */
    case 256: /* partition_by_clause_opt */
    case 258: /* group_by_clause_opt */
    case 260: /* select_sublist */
    case 264: /* group_by_list */
    case 266: /* order_by_clause_opt */
    case 270: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy40)); 
}
      break;
    case 200: /* type_name */
{
 
}
      break;
    case 237: /* compare_op */
    case 238: /* in_op */
{
 
}
      break;
    case 250: /* join_type */
{
 
}
      break;
    case 263: /* fill_mode */
{
 
}
      break;
    case 272: /* ordering_specification_opt */
{
 
}
      break;
    case 273: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  176,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  176,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  177,    0 }, /* (2) account_options ::= */
  {  177,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  177,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  177,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  177,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  177,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  177,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  177,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  177,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  177,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  178,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  178,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  180,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  180,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  180,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  180,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  180,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  180,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  180,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  180,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  180,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  180,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  176,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  176,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  176,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  176,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  176,   -3 }, /* (28) cmd ::= CREATE DNODE dnode_endpoint */
  {  176,   -5 }, /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  176,   -3 }, /* (30) cmd ::= DROP DNODE NK_INTEGER */
  {  176,   -3 }, /* (31) cmd ::= DROP DNODE dnode_endpoint */
  {  176,   -4 }, /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  176,   -5 }, /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  176,   -4 }, /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
  {  176,   -5 }, /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  182,   -1 }, /* (36) dnode_endpoint ::= NK_STRING */
  {  183,   -1 }, /* (37) dnode_host_name ::= NK_ID */
  {  183,   -1 }, /* (38) dnode_host_name ::= NK_IPTOKEN */
  {  176,   -3 }, /* (39) cmd ::= ALTER LOCAL NK_STRING */
  {  176,   -4 }, /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  176,   -5 }, /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  176,   -5 }, /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  176,   -5 }, /* (43) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  176,   -4 }, /* (44) cmd ::= DROP DATABASE exists_opt db_name */
  {  176,   -2 }, /* (45) cmd ::= USE db_name */
  {  176,   -4 }, /* (46) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  184,   -3 }, /* (47) not_exists_opt ::= IF NOT EXISTS */
  {  184,    0 }, /* (48) not_exists_opt ::= */
  {  187,   -2 }, /* (49) exists_opt ::= IF EXISTS */
  {  187,    0 }, /* (50) exists_opt ::= */
  {  186,    0 }, /* (51) db_options ::= */
  {  186,   -3 }, /* (52) db_options ::= db_options BLOCKS NK_INTEGER */
  {  186,   -3 }, /* (53) db_options ::= db_options CACHE NK_INTEGER */
  {  186,   -3 }, /* (54) db_options ::= db_options CACHELAST NK_INTEGER */
  {  186,   -3 }, /* (55) db_options ::= db_options COMP NK_INTEGER */
  {  186,   -3 }, /* (56) db_options ::= db_options DAYS NK_INTEGER */
  {  186,   -3 }, /* (57) db_options ::= db_options FSYNC NK_INTEGER */
  {  186,   -3 }, /* (58) db_options ::= db_options MAXROWS NK_INTEGER */
  {  186,   -3 }, /* (59) db_options ::= db_options MINROWS NK_INTEGER */
  {  186,   -3 }, /* (60) db_options ::= db_options KEEP NK_INTEGER */
  {  186,   -3 }, /* (61) db_options ::= db_options PRECISION NK_STRING */
  {  186,   -3 }, /* (62) db_options ::= db_options QUORUM NK_INTEGER */
  {  186,   -3 }, /* (63) db_options ::= db_options REPLICA NK_INTEGER */
  {  186,   -3 }, /* (64) db_options ::= db_options TTL NK_INTEGER */
  {  186,   -3 }, /* (65) db_options ::= db_options WAL NK_INTEGER */
  {  186,   -3 }, /* (66) db_options ::= db_options VGROUPS NK_INTEGER */
  {  186,   -3 }, /* (67) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  186,   -3 }, /* (68) db_options ::= db_options STREAM_MODE NK_INTEGER */
  {  186,   -3 }, /* (69) db_options ::= db_options RETENTIONS NK_STRING */
  {  188,   -1 }, /* (70) alter_db_options ::= alter_db_option */
  {  188,   -2 }, /* (71) alter_db_options ::= alter_db_options alter_db_option */
  {  189,   -2 }, /* (72) alter_db_option ::= BLOCKS NK_INTEGER */
  {  189,   -2 }, /* (73) alter_db_option ::= FSYNC NK_INTEGER */
  {  189,   -2 }, /* (74) alter_db_option ::= KEEP NK_INTEGER */
  {  189,   -2 }, /* (75) alter_db_option ::= WAL NK_INTEGER */
  {  189,   -2 }, /* (76) alter_db_option ::= QUORUM NK_INTEGER */
  {  189,   -2 }, /* (77) alter_db_option ::= CACHELAST NK_INTEGER */
  {  176,   -9 }, /* (78) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  176,   -3 }, /* (79) cmd ::= CREATE TABLE multi_create_clause */
  {  176,   -9 }, /* (80) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  176,   -3 }, /* (81) cmd ::= DROP TABLE multi_drop_clause */
  {  176,   -4 }, /* (82) cmd ::= DROP STABLE exists_opt full_table_name */
  {  176,   -3 }, /* (83) cmd ::= ALTER TABLE alter_table_clause */
  {  176,   -3 }, /* (84) cmd ::= ALTER STABLE alter_table_clause */
  {  197,   -2 }, /* (85) alter_table_clause ::= full_table_name alter_table_options */
  {  197,   -5 }, /* (86) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  197,   -4 }, /* (87) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  197,   -5 }, /* (88) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  197,   -5 }, /* (89) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  197,   -5 }, /* (90) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  197,   -4 }, /* (91) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  197,   -5 }, /* (92) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  197,   -5 }, /* (93) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  197,   -6 }, /* (94) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
  {  194,   -1 }, /* (95) multi_create_clause ::= create_subtable_clause */
  {  194,   -2 }, /* (96) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  201,   -9 }, /* (97) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
  {  196,   -1 }, /* (98) multi_drop_clause ::= drop_table_clause */
  {  196,   -2 }, /* (99) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  204,   -2 }, /* (100) drop_table_clause ::= exists_opt full_table_name */
  {  202,    0 }, /* (101) specific_tags_opt ::= */
  {  202,   -3 }, /* (102) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  190,   -1 }, /* (103) full_table_name ::= table_name */
  {  190,   -3 }, /* (104) full_table_name ::= db_name NK_DOT table_name */
  {  191,   -1 }, /* (105) column_def_list ::= column_def */
  {  191,   -3 }, /* (106) column_def_list ::= column_def_list NK_COMMA column_def */
  {  207,   -2 }, /* (107) column_def ::= column_name type_name */
  {  207,   -4 }, /* (108) column_def ::= column_name type_name COMMENT NK_STRING */
  {  200,   -1 }, /* (109) type_name ::= BOOL */
  {  200,   -1 }, /* (110) type_name ::= TINYINT */
  {  200,   -1 }, /* (111) type_name ::= SMALLINT */
  {  200,   -1 }, /* (112) type_name ::= INT */
  {  200,   -1 }, /* (113) type_name ::= INTEGER */
  {  200,   -1 }, /* (114) type_name ::= BIGINT */
  {  200,   -1 }, /* (115) type_name ::= FLOAT */
  {  200,   -1 }, /* (116) type_name ::= DOUBLE */
  {  200,   -4 }, /* (117) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  200,   -1 }, /* (118) type_name ::= TIMESTAMP */
  {  200,   -4 }, /* (119) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  200,   -2 }, /* (120) type_name ::= TINYINT UNSIGNED */
  {  200,   -2 }, /* (121) type_name ::= SMALLINT UNSIGNED */
  {  200,   -2 }, /* (122) type_name ::= INT UNSIGNED */
  {  200,   -2 }, /* (123) type_name ::= BIGINT UNSIGNED */
  {  200,   -1 }, /* (124) type_name ::= JSON */
  {  200,   -4 }, /* (125) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  200,   -1 }, /* (126) type_name ::= MEDIUMBLOB */
  {  200,   -1 }, /* (127) type_name ::= BLOB */
  {  200,   -4 }, /* (128) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  200,   -1 }, /* (129) type_name ::= DECIMAL */
  {  200,   -4 }, /* (130) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  200,   -6 }, /* (131) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  192,    0 }, /* (132) tags_def_opt ::= */
  {  192,   -1 }, /* (133) tags_def_opt ::= tags_def */
  {  195,   -4 }, /* (134) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  193,    0 }, /* (135) table_options ::= */
  {  193,   -3 }, /* (136) table_options ::= table_options COMMENT NK_STRING */
  {  193,   -3 }, /* (137) table_options ::= table_options KEEP NK_INTEGER */
  {  193,   -3 }, /* (138) table_options ::= table_options TTL NK_INTEGER */
  {  193,   -5 }, /* (139) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  193,   -5 }, /* (140) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  193,   -3 }, /* (141) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  193,   -3 }, /* (142) table_options ::= table_options DELAY NK_INTEGER */
  {  198,   -1 }, /* (143) alter_table_options ::= alter_table_option */
  {  198,   -2 }, /* (144) alter_table_options ::= alter_table_options alter_table_option */
  {  209,   -2 }, /* (145) alter_table_option ::= COMMENT NK_STRING */
  {  209,   -2 }, /* (146) alter_table_option ::= KEEP NK_INTEGER */
  {  209,   -2 }, /* (147) alter_table_option ::= TTL NK_INTEGER */
  {  205,   -1 }, /* (148) col_name_list ::= col_name */
  {  205,   -3 }, /* (149) col_name_list ::= col_name_list NK_COMMA col_name */
  {  210,   -1 }, /* (150) col_name ::= column_name */
  {  176,   -2 }, /* (151) cmd ::= SHOW DNODES */
  {  176,   -2 }, /* (152) cmd ::= SHOW USERS */
  {  176,   -2 }, /* (153) cmd ::= SHOW DATABASES */
  {  176,   -4 }, /* (154) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  176,   -4 }, /* (155) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  176,   -3 }, /* (156) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  176,   -2 }, /* (157) cmd ::= SHOW MNODES */
  {  176,   -2 }, /* (158) cmd ::= SHOW MODULES */
  {  176,   -2 }, /* (159) cmd ::= SHOW QNODES */
  {  176,   -2 }, /* (160) cmd ::= SHOW FUNCTIONS */
  {  176,   -5 }, /* (161) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  176,   -2 }, /* (162) cmd ::= SHOW STREAMS */
  {  211,    0 }, /* (163) db_name_cond_opt ::= */
  {  211,   -2 }, /* (164) db_name_cond_opt ::= db_name NK_DOT */
  {  212,    0 }, /* (165) like_pattern_opt ::= */
  {  212,   -2 }, /* (166) like_pattern_opt ::= LIKE NK_STRING */
  {  213,   -1 }, /* (167) table_name_cond ::= table_name */
  {  214,    0 }, /* (168) from_db_opt ::= */
  {  214,   -2 }, /* (169) from_db_opt ::= FROM db_name */
  {  208,   -1 }, /* (170) func_name_list ::= func_name */
  {  208,   -3 }, /* (171) func_name_list ::= func_name_list NK_COMMA col_name */
  {  215,   -1 }, /* (172) func_name ::= function_name */
  {  176,   -8 }, /* (173) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  176,  -10 }, /* (174) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  176,   -6 }, /* (175) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  218,    0 }, /* (176) index_options ::= */
  {  218,   -9 }, /* (177) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  218,  -11 }, /* (178) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  219,   -1 }, /* (179) func_list ::= func */
  {  219,   -3 }, /* (180) func_list ::= func_list NK_COMMA func */
  {  222,   -4 }, /* (181) func ::= function_name NK_LP expression_list NK_RP */
  {  176,   -6 }, /* (182) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  176,   -6 }, /* (183) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
  {  176,   -4 }, /* (184) cmd ::= DROP TOPIC exists_opt topic_name */
  {  176,   -4 }, /* (185) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  226,    0 }, /* (186) analyze_opt ::= */
  {  226,   -1 }, /* (187) analyze_opt ::= ANALYZE */
  {  227,    0 }, /* (188) explain_options ::= */
  {  227,   -3 }, /* (189) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  227,   -3 }, /* (190) explain_options ::= explain_options RATIO NK_FLOAT */
  {  176,   -1 }, /* (191) cmd ::= query_expression */
  {  179,   -1 }, /* (192) literal ::= NK_INTEGER */
  {  179,   -1 }, /* (193) literal ::= NK_FLOAT */
  {  179,   -1 }, /* (194) literal ::= NK_STRING */
  {  179,   -1 }, /* (195) literal ::= NK_BOOL */
  {  179,   -2 }, /* (196) literal ::= TIMESTAMP NK_STRING */
  {  179,   -1 }, /* (197) literal ::= duration_literal */
  {  179,   -1 }, /* (198) literal ::= NULL */
  {  220,   -1 }, /* (199) duration_literal ::= NK_VARIABLE */
  {  228,   -1 }, /* (200) signed ::= NK_INTEGER */
  {  228,   -2 }, /* (201) signed ::= NK_PLUS NK_INTEGER */
  {  228,   -2 }, /* (202) signed ::= NK_MINUS NK_INTEGER */
  {  228,   -1 }, /* (203) signed ::= NK_FLOAT */
  {  228,   -2 }, /* (204) signed ::= NK_PLUS NK_FLOAT */
  {  228,   -2 }, /* (205) signed ::= NK_MINUS NK_FLOAT */
  {  229,   -1 }, /* (206) signed_literal ::= signed */
  {  229,   -1 }, /* (207) signed_literal ::= NK_STRING */
  {  229,   -1 }, /* (208) signed_literal ::= NK_BOOL */
  {  229,   -2 }, /* (209) signed_literal ::= TIMESTAMP NK_STRING */
  {  229,   -1 }, /* (210) signed_literal ::= duration_literal */
  {  229,   -1 }, /* (211) signed_literal ::= NULL */
  {  203,   -1 }, /* (212) literal_list ::= signed_literal */
  {  203,   -3 }, /* (213) literal_list ::= literal_list NK_COMMA signed_literal */
  {  185,   -1 }, /* (214) db_name ::= NK_ID */
  {  206,   -1 }, /* (215) table_name ::= NK_ID */
  {  199,   -1 }, /* (216) column_name ::= NK_ID */
  {  216,   -1 }, /* (217) function_name ::= NK_ID */
  {  230,   -1 }, /* (218) table_alias ::= NK_ID */
  {  231,   -1 }, /* (219) column_alias ::= NK_ID */
  {  181,   -1 }, /* (220) user_name ::= NK_ID */
  {  217,   -1 }, /* (221) index_name ::= NK_ID */
  {  224,   -1 }, /* (222) topic_name ::= NK_ID */
  {  232,   -1 }, /* (223) expression ::= literal */
  {  232,   -1 }, /* (224) expression ::= pseudo_column */
  {  232,   -1 }, /* (225) expression ::= column_reference */
  {  232,   -4 }, /* (226) expression ::= function_name NK_LP expression_list NK_RP */
  {  232,   -4 }, /* (227) expression ::= function_name NK_LP NK_STAR NK_RP */
  {  232,   -1 }, /* (228) expression ::= subquery */
  {  232,   -3 }, /* (229) expression ::= NK_LP expression NK_RP */
  {  232,   -2 }, /* (230) expression ::= NK_PLUS expression */
  {  232,   -2 }, /* (231) expression ::= NK_MINUS expression */
  {  232,   -3 }, /* (232) expression ::= expression NK_PLUS expression */
  {  232,   -3 }, /* (233) expression ::= expression NK_MINUS expression */
  {  232,   -3 }, /* (234) expression ::= expression NK_STAR expression */
  {  232,   -3 }, /* (235) expression ::= expression NK_SLASH expression */
  {  232,   -3 }, /* (236) expression ::= expression NK_REM expression */
  {  223,   -1 }, /* (237) expression_list ::= expression */
  {  223,   -3 }, /* (238) expression_list ::= expression_list NK_COMMA expression */
  {  234,   -1 }, /* (239) column_reference ::= column_name */
  {  234,   -3 }, /* (240) column_reference ::= table_name NK_DOT column_name */
  {  233,   -2 }, /* (241) pseudo_column ::= NK_UNDERLINE ROWTS */
  {  233,   -1 }, /* (242) pseudo_column ::= TBNAME */
  {  233,   -2 }, /* (243) pseudo_column ::= NK_UNDERLINE QSTARTTS */
  {  233,   -2 }, /* (244) pseudo_column ::= NK_UNDERLINE QENDTS */
  {  233,   -2 }, /* (245) pseudo_column ::= NK_UNDERLINE WSTARTTS */
  {  233,   -2 }, /* (246) pseudo_column ::= NK_UNDERLINE WENDTS */
  {  233,   -2 }, /* (247) pseudo_column ::= NK_UNDERLINE WDURATION */
  {  236,   -3 }, /* (248) predicate ::= expression compare_op expression */
  {  236,   -5 }, /* (249) predicate ::= expression BETWEEN expression AND expression */
  {  236,   -6 }, /* (250) predicate ::= expression NOT BETWEEN expression AND expression */
  {  236,   -3 }, /* (251) predicate ::= expression IS NULL */
  {  236,   -4 }, /* (252) predicate ::= expression IS NOT NULL */
  {  236,   -3 }, /* (253) predicate ::= expression in_op in_predicate_value */
  {  237,   -1 }, /* (254) compare_op ::= NK_LT */
  {  237,   -1 }, /* (255) compare_op ::= NK_GT */
  {  237,   -1 }, /* (256) compare_op ::= NK_LE */
  {  237,   -1 }, /* (257) compare_op ::= NK_GE */
  {  237,   -1 }, /* (258) compare_op ::= NK_NE */
  {  237,   -1 }, /* (259) compare_op ::= NK_EQ */
  {  237,   -1 }, /* (260) compare_op ::= LIKE */
  {  237,   -2 }, /* (261) compare_op ::= NOT LIKE */
  {  237,   -1 }, /* (262) compare_op ::= MATCH */
  {  237,   -1 }, /* (263) compare_op ::= NMATCH */
  {  238,   -1 }, /* (264) in_op ::= IN */
  {  238,   -2 }, /* (265) in_op ::= NOT IN */
  {  239,   -3 }, /* (266) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  240,   -1 }, /* (267) boolean_value_expression ::= boolean_primary */
  {  240,   -2 }, /* (268) boolean_value_expression ::= NOT boolean_primary */
  {  240,   -3 }, /* (269) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  240,   -3 }, /* (270) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  241,   -1 }, /* (271) boolean_primary ::= predicate */
  {  241,   -3 }, /* (272) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  242,   -1 }, /* (273) common_expression ::= expression */
  {  242,   -1 }, /* (274) common_expression ::= boolean_value_expression */
  {  243,   -2 }, /* (275) from_clause ::= FROM table_reference_list */
  {  244,   -1 }, /* (276) table_reference_list ::= table_reference */
  {  244,   -3 }, /* (277) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  245,   -1 }, /* (278) table_reference ::= table_primary */
  {  245,   -1 }, /* (279) table_reference ::= joined_table */
  {  246,   -2 }, /* (280) table_primary ::= table_name alias_opt */
  {  246,   -4 }, /* (281) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  246,   -2 }, /* (282) table_primary ::= subquery alias_opt */
  {  246,   -1 }, /* (283) table_primary ::= parenthesized_joined_table */
  {  248,    0 }, /* (284) alias_opt ::= */
  {  248,   -1 }, /* (285) alias_opt ::= table_alias */
  {  248,   -2 }, /* (286) alias_opt ::= AS table_alias */
  {  249,   -3 }, /* (287) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  249,   -3 }, /* (288) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  247,   -6 }, /* (289) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  250,    0 }, /* (290) join_type ::= */
  {  250,   -1 }, /* (291) join_type ::= INNER */
  {  252,   -9 }, /* (292) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  253,    0 }, /* (293) set_quantifier_opt ::= */
  {  253,   -1 }, /* (294) set_quantifier_opt ::= DISTINCT */
  {  253,   -1 }, /* (295) set_quantifier_opt ::= ALL */
  {  254,   -1 }, /* (296) select_list ::= NK_STAR */
  {  254,   -1 }, /* (297) select_list ::= select_sublist */
  {  260,   -1 }, /* (298) select_sublist ::= select_item */
  {  260,   -3 }, /* (299) select_sublist ::= select_sublist NK_COMMA select_item */
  {  261,   -1 }, /* (300) select_item ::= common_expression */
  {  261,   -2 }, /* (301) select_item ::= common_expression column_alias */
  {  261,   -3 }, /* (302) select_item ::= common_expression AS column_alias */
  {  261,   -3 }, /* (303) select_item ::= table_name NK_DOT NK_STAR */
  {  255,    0 }, /* (304) where_clause_opt ::= */
  {  255,   -2 }, /* (305) where_clause_opt ::= WHERE search_condition */
  {  256,    0 }, /* (306) partition_by_clause_opt ::= */
  {  256,   -3 }, /* (307) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  257,    0 }, /* (308) twindow_clause_opt ::= */
  {  257,   -6 }, /* (309) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  257,   -4 }, /* (310) twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP */
  {  257,   -6 }, /* (311) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  257,   -8 }, /* (312) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  221,    0 }, /* (313) sliding_opt ::= */
  {  221,   -4 }, /* (314) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  262,    0 }, /* (315) fill_opt ::= */
  {  262,   -4 }, /* (316) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  262,   -6 }, /* (317) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  263,   -1 }, /* (318) fill_mode ::= NONE */
  {  263,   -1 }, /* (319) fill_mode ::= PREV */
  {  263,   -1 }, /* (320) fill_mode ::= NULL */
  {  263,   -1 }, /* (321) fill_mode ::= LINEAR */
  {  263,   -1 }, /* (322) fill_mode ::= NEXT */
  {  258,    0 }, /* (323) group_by_clause_opt ::= */
  {  258,   -3 }, /* (324) group_by_clause_opt ::= GROUP BY group_by_list */
  {  264,   -1 }, /* (325) group_by_list ::= expression */
  {  264,   -3 }, /* (326) group_by_list ::= group_by_list NK_COMMA expression */
  {  259,    0 }, /* (327) having_clause_opt ::= */
  {  259,   -2 }, /* (328) having_clause_opt ::= HAVING search_condition */
  {  225,   -4 }, /* (329) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  265,   -1 }, /* (330) query_expression_body ::= query_primary */
  {  265,   -4 }, /* (331) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  269,   -1 }, /* (332) query_primary ::= query_specification */
  {  266,    0 }, /* (333) order_by_clause_opt ::= */
  {  266,   -3 }, /* (334) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  267,    0 }, /* (335) slimit_clause_opt ::= */
  {  267,   -2 }, /* (336) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  267,   -4 }, /* (337) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  267,   -4 }, /* (338) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  268,    0 }, /* (339) limit_clause_opt ::= */
  {  268,   -2 }, /* (340) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  268,   -4 }, /* (341) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  268,   -4 }, /* (342) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  235,   -3 }, /* (343) subquery ::= NK_LP query_expression NK_RP */
  {  251,   -1 }, /* (344) search_condition ::= common_expression */
  {  270,   -1 }, /* (345) sort_specification_list ::= sort_specification */
  {  270,   -3 }, /* (346) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  271,   -3 }, /* (347) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  272,    0 }, /* (348) ordering_specification_opt ::= */
  {  272,   -1 }, /* (349) ordering_specification_opt ::= ASC */
  {  272,   -1 }, /* (350) ordering_specification_opt ::= DESC */
  {  273,    0 }, /* (351) null_ordering_opt ::= */
  {  273,   -2 }, /* (352) null_ordering_opt ::= NULLS FIRST */
  {  273,   -2 }, /* (353) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,177,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,178,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,177,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,179,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,180,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,178,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,180,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,179,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy437, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy437, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy437, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy437); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy437, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy437, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy437); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 214: /* db_name ::= NK_ID */ yytestcase(yyruleno==214);
      case 215: /* table_name ::= NK_ID */ yytestcase(yyruleno==215);
      case 216: /* column_name ::= NK_ID */ yytestcase(yyruleno==216);
      case 217: /* function_name ::= NK_ID */ yytestcase(yyruleno==217);
      case 218: /* table_alias ::= NK_ID */ yytestcase(yyruleno==218);
      case 219: /* column_alias ::= NK_ID */ yytestcase(yyruleno==219);
      case 220: /* user_name ::= NK_ID */ yytestcase(yyruleno==220);
      case 221: /* index_name ::= NK_ID */ yytestcase(yyruleno==221);
      case 222: /* topic_name ::= NK_ID */ yytestcase(yyruleno==222);
{ yylhsminor.yy437 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy437 = yylhsminor.yy437;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateQnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropQnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy493, &yymsp[-1].minor.yy437, yymsp[0].minor.yy364); }
        break;
      case 44: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy493, &yymsp[0].minor.yy437); }
        break;
      case 45: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy437); }
        break;
      case 46: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy437, yymsp[0].minor.yy364); }
        break;
      case 47: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy493 = true; }
        break;
      case 48: /* not_exists_opt ::= */
      case 50: /* exists_opt ::= */ yytestcase(yyruleno==50);
      case 186: /* analyze_opt ::= */ yytestcase(yyruleno==186);
      case 293: /* set_quantifier_opt ::= */ yytestcase(yyruleno==293);
{ yymsp[1].minor.yy493 = false; }
        break;
      case 49: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy493 = true; }
        break;
      case 51: /* db_options ::= */
{ yymsp[1].minor.yy364 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 52: /* db_options ::= db_options BLOCKS NK_INTEGER */
{ yylhsminor.yy364 = setDatabaseOption(pCxt, yymsp[-2].minor.yy364, DB_OPTION_BLOCKS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 53: /* db_options ::= db_options CACHE NK_INTEGER */
{ yylhsminor.yy364 = setDatabaseOption(pCxt, yymsp[-2].minor.yy364, DB_OPTION_CACHE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 54: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy364 = setDatabaseOption(pCxt, yymsp[-2].minor.yy364, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 55: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy364 = setDatabaseOption(pCxt, yymsp[-2].minor.yy364, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 56: /* db_options ::= db_options DAYS NK_INTEGER */
{ yylhsminor.yy364 = setDatabaseOption(pCxt, yymsp[-2].minor.yy364, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 57: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy364 = setDatabaseOption(pCxt, yymsp[-2].minor.yy364, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 58: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy364 = setDatabaseOption(pCxt, yymsp[-2].minor.yy364, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 59: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy364 = setDatabaseOption(pCxt, yymsp[-2].minor.yy364, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 60: /* db_options ::= db_options KEEP NK_INTEGER */
{ yylhsminor.yy364 = setDatabaseOption(pCxt, yymsp[-2].minor.yy364, DB_OPTION_KEEP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 61: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy364 = setDatabaseOption(pCxt, yymsp[-2].minor.yy364, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 62: /* db_options ::= db_options QUORUM NK_INTEGER */
{ yylhsminor.yy364 = setDatabaseOption(pCxt, yymsp[-2].minor.yy364, DB_OPTION_QUORUM, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 63: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy364 = setDatabaseOption(pCxt, yymsp[-2].minor.yy364, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 64: /* db_options ::= db_options TTL NK_INTEGER */
{ yylhsminor.yy364 = setDatabaseOption(pCxt, yymsp[-2].minor.yy364, DB_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 65: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy364 = setDatabaseOption(pCxt, yymsp[-2].minor.yy364, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 66: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy364 = setDatabaseOption(pCxt, yymsp[-2].minor.yy364, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 67: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy364 = setDatabaseOption(pCxt, yymsp[-2].minor.yy364, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 68: /* db_options ::= db_options STREAM_MODE NK_INTEGER */
{ yylhsminor.yy364 = setDatabaseOption(pCxt, yymsp[-2].minor.yy364, DB_OPTION_STREAM_MODE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 69: /* db_options ::= db_options RETENTIONS NK_STRING */
{ yylhsminor.yy364 = setDatabaseOption(pCxt, yymsp[-2].minor.yy364, DB_OPTION_RETENTIONS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 70: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy364 = createDefaultAlterDatabaseOptions(pCxt); yylhsminor.yy364 = setDatabaseOption(pCxt, yylhsminor.yy364, yymsp[0].minor.yy29.type, &yymsp[0].minor.yy29.val); }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 71: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy364 = setDatabaseOption(pCxt, yymsp[-1].minor.yy364, yymsp[0].minor.yy29.type, &yymsp[0].minor.yy29.val); }
  yymsp[-1].minor.yy364 = yylhsminor.yy364;
        break;
      case 72: /* alter_db_option ::= BLOCKS NK_INTEGER */
{ yymsp[-1].minor.yy29.type = DB_OPTION_BLOCKS; yymsp[-1].minor.yy29.val = yymsp[0].minor.yy0; }
        break;
      case 73: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy29.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy29.val = yymsp[0].minor.yy0; }
        break;
      case 74: /* alter_db_option ::= KEEP NK_INTEGER */
{ yymsp[-1].minor.yy29.type = DB_OPTION_KEEP; yymsp[-1].minor.yy29.val = yymsp[0].minor.yy0; }
        break;
      case 75: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy29.type = DB_OPTION_WAL; yymsp[-1].minor.yy29.val = yymsp[0].minor.yy0; }
        break;
      case 76: /* alter_db_option ::= QUORUM NK_INTEGER */
{ yymsp[-1].minor.yy29.type = DB_OPTION_QUORUM; yymsp[-1].minor.yy29.val = yymsp[0].minor.yy0; }
        break;
      case 77: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy29.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy29.val = yymsp[0].minor.yy0; }
        break;
      case 78: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 80: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==80);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy493, yymsp[-5].minor.yy364, yymsp[-3].minor.yy40, yymsp[-1].minor.yy40, yymsp[0].minor.yy364); }
        break;
      case 79: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy40); }
        break;
      case 81: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy40); }
        break;
      case 82: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy493, yymsp[0].minor.yy364); }
        break;
      case 83: /* cmd ::= ALTER TABLE alter_table_clause */
      case 84: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==84);
      case 191: /* cmd ::= query_expression */ yytestcase(yyruleno==191);
{ pCxt->pRootNode = yymsp[0].minor.yy364; }
        break;
      case 85: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy364 = createAlterTableOption(pCxt, yymsp[-1].minor.yy364, yymsp[0].minor.yy364); }
  yymsp[-1].minor.yy364 = yylhsminor.yy364;
        break;
      case 86: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy364 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy364, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy437, yymsp[0].minor.yy420); }
  yymsp[-4].minor.yy364 = yylhsminor.yy364;
        break;
      case 87: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy364 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy364, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy437); }
  yymsp[-3].minor.yy364 = yylhsminor.yy364;
        break;
      case 88: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy364 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy364, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy437, yymsp[0].minor.yy420); }
  yymsp[-4].minor.yy364 = yylhsminor.yy364;
        break;
      case 89: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy364 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy364, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy437, &yymsp[0].minor.yy437); }
  yymsp[-4].minor.yy364 = yylhsminor.yy364;
        break;
      case 90: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy364 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy364, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy437, yymsp[0].minor.yy420); }
  yymsp[-4].minor.yy364 = yylhsminor.yy364;
        break;
      case 91: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy364 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy364, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy437); }
  yymsp[-3].minor.yy364 = yylhsminor.yy364;
        break;
      case 92: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy364 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy364, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy437, yymsp[0].minor.yy420); }
  yymsp[-4].minor.yy364 = yylhsminor.yy364;
        break;
      case 93: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy364 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy364, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy437, &yymsp[0].minor.yy437); }
  yymsp[-4].minor.yy364 = yylhsminor.yy364;
        break;
      case 94: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy364 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy364, &yymsp[-2].minor.yy437, yymsp[0].minor.yy364); }
  yymsp[-5].minor.yy364 = yylhsminor.yy364;
        break;
      case 95: /* multi_create_clause ::= create_subtable_clause */
      case 98: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==98);
      case 105: /* column_def_list ::= column_def */ yytestcase(yyruleno==105);
      case 148: /* col_name_list ::= col_name */ yytestcase(yyruleno==148);
      case 170: /* func_name_list ::= func_name */ yytestcase(yyruleno==170);
      case 179: /* func_list ::= func */ yytestcase(yyruleno==179);
      case 212: /* literal_list ::= signed_literal */ yytestcase(yyruleno==212);
      case 298: /* select_sublist ::= select_item */ yytestcase(yyruleno==298);
      case 345: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==345);
{ yylhsminor.yy40 = createNodeList(pCxt, yymsp[0].minor.yy364); }
  yymsp[0].minor.yy40 = yylhsminor.yy40;
        break;
      case 96: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 99: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==99);
{ yylhsminor.yy40 = addNodeToList(pCxt, yymsp[-1].minor.yy40, yymsp[0].minor.yy364); }
  yymsp[-1].minor.yy40 = yylhsminor.yy40;
        break;
      case 97: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
{ yylhsminor.yy364 = createCreateSubTableClause(pCxt, yymsp[-8].minor.yy493, yymsp[-7].minor.yy364, yymsp[-5].minor.yy364, yymsp[-4].minor.yy40, yymsp[-1].minor.yy40); }
  yymsp[-8].minor.yy364 = yylhsminor.yy364;
        break;
      case 100: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy364 = createDropTableClause(pCxt, yymsp[-1].minor.yy493, yymsp[0].minor.yy364); }
  yymsp[-1].minor.yy364 = yylhsminor.yy364;
        break;
      case 101: /* specific_tags_opt ::= */
      case 132: /* tags_def_opt ::= */ yytestcase(yyruleno==132);
      case 306: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==306);
      case 323: /* group_by_clause_opt ::= */ yytestcase(yyruleno==323);
      case 333: /* order_by_clause_opt ::= */ yytestcase(yyruleno==333);
{ yymsp[1].minor.yy40 = NULL; }
        break;
      case 102: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy40 = yymsp[-1].minor.yy40; }
        break;
      case 103: /* full_table_name ::= table_name */
{ yylhsminor.yy364 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy437, NULL); }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 104: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy364 = createRealTableNode(pCxt, &yymsp[-2].minor.yy437, &yymsp[0].minor.yy437, NULL); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 106: /* column_def_list ::= column_def_list NK_COMMA column_def */
      case 149: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==149);
      case 171: /* func_name_list ::= func_name_list NK_COMMA col_name */ yytestcase(yyruleno==171);
      case 180: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==180);
      case 213: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==213);
      case 299: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==299);
      case 346: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==346);
{ yylhsminor.yy40 = addNodeToList(pCxt, yymsp[-2].minor.yy40, yymsp[0].minor.yy364); }
  yymsp[-2].minor.yy40 = yylhsminor.yy40;
        break;
      case 107: /* column_def ::= column_name type_name */
{ yylhsminor.yy364 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy437, yymsp[0].minor.yy420, NULL); }
  yymsp[-1].minor.yy364 = yylhsminor.yy364;
        break;
      case 108: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy364 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy437, yymsp[-2].minor.yy420, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy364 = yylhsminor.yy364;
        break;
      case 109: /* type_name ::= BOOL */
{ yymsp[0].minor.yy420 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 110: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy420 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 111: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy420 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 112: /* type_name ::= INT */
      case 113: /* type_name ::= INTEGER */ yytestcase(yyruleno==113);
{ yymsp[0].minor.yy420 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 114: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy420 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 115: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy420 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 116: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy420 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 117: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy420 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 118: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy420 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 119: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy420 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 120: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy420 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 121: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy420 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 122: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy420 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 123: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy420 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 124: /* type_name ::= JSON */
{ yymsp[0].minor.yy420 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 125: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy420 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 126: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy420 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 127: /* type_name ::= BLOB */
{ yymsp[0].minor.yy420 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 128: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy420 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 129: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy420 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 130: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy420 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 131: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy420 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 133: /* tags_def_opt ::= tags_def */
      case 297: /* select_list ::= select_sublist */ yytestcase(yyruleno==297);
{ yylhsminor.yy40 = yymsp[0].minor.yy40; }
  yymsp[0].minor.yy40 = yylhsminor.yy40;
        break;
      case 134: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy40 = yymsp[-1].minor.yy40; }
        break;
      case 135: /* table_options ::= */
{ yymsp[1].minor.yy364 = createDefaultTableOptions(pCxt); }
        break;
      case 136: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy364 = setTableOption(pCxt, yymsp[-2].minor.yy364, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 137: /* table_options ::= table_options KEEP NK_INTEGER */
{ yylhsminor.yy364 = setTableOption(pCxt, yymsp[-2].minor.yy364, TABLE_OPTION_KEEP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 138: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy364 = setTableOption(pCxt, yymsp[-2].minor.yy364, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 139: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy364 = setTableSmaOption(pCxt, yymsp[-4].minor.yy364, yymsp[-1].minor.yy40); }
  yymsp[-4].minor.yy364 = yylhsminor.yy364;
        break;
      case 140: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ yylhsminor.yy364 = setTableRollupOption(pCxt, yymsp[-4].minor.yy364, yymsp[-1].minor.yy40); }
  yymsp[-4].minor.yy364 = yylhsminor.yy364;
        break;
      case 141: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ yylhsminor.yy364 = setTableOption(pCxt, yymsp[-2].minor.yy364, TABLE_OPTION_FILE_FACTOR, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 142: /* table_options ::= table_options DELAY NK_INTEGER */
{ yylhsminor.yy364 = setTableOption(pCxt, yymsp[-2].minor.yy364, TABLE_OPTION_DELAY, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 143: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy364 = createDefaultAlterTableOptions(pCxt); yylhsminor.yy364 = setTableOption(pCxt, yylhsminor.yy364, yymsp[0].minor.yy29.type, &yymsp[0].minor.yy29.val); }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 144: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy364 = setTableOption(pCxt, yymsp[-1].minor.yy364, yymsp[0].minor.yy29.type, &yymsp[0].minor.yy29.val); }
  yymsp[-1].minor.yy364 = yylhsminor.yy364;
        break;
      case 145: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy29.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy29.val = yymsp[0].minor.yy0; }
        break;
      case 146: /* alter_table_option ::= KEEP NK_INTEGER */
{ yymsp[-1].minor.yy29.type = TABLE_OPTION_KEEP; yymsp[-1].minor.yy29.val = yymsp[0].minor.yy0; }
        break;
      case 147: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy29.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy29.val = yymsp[0].minor.yy0; }
        break;
      case 150: /* col_name ::= column_name */
{ yylhsminor.yy364 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy437); }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 151: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 152: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 153: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 154: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy364, yymsp[0].minor.yy364); }
        break;
      case 155: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy364, yymsp[0].minor.yy364); }
        break;
      case 156: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy364, NULL); }
        break;
      case 157: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 158: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 159: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 160: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 161: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy364, yymsp[0].minor.yy364); }
        break;
      case 162: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 163: /* db_name_cond_opt ::= */
      case 168: /* from_db_opt ::= */ yytestcase(yyruleno==168);
{ yymsp[1].minor.yy364 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 164: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy364 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy437); }
  yymsp[-1].minor.yy364 = yylhsminor.yy364;
        break;
      case 165: /* like_pattern_opt ::= */
      case 176: /* index_options ::= */ yytestcase(yyruleno==176);
      case 304: /* where_clause_opt ::= */ yytestcase(yyruleno==304);
      case 308: /* twindow_clause_opt ::= */ yytestcase(yyruleno==308);
      case 313: /* sliding_opt ::= */ yytestcase(yyruleno==313);
      case 315: /* fill_opt ::= */ yytestcase(yyruleno==315);
      case 327: /* having_clause_opt ::= */ yytestcase(yyruleno==327);
      case 335: /* slimit_clause_opt ::= */ yytestcase(yyruleno==335);
      case 339: /* limit_clause_opt ::= */ yytestcase(yyruleno==339);
{ yymsp[1].minor.yy364 = NULL; }
        break;
      case 166: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy364 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 167: /* table_name_cond ::= table_name */
{ yylhsminor.yy364 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy437); }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 169: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy364 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy437); }
        break;
      case 172: /* func_name ::= function_name */
{ yylhsminor.yy364 = createFunctionNode(pCxt, &yymsp[0].minor.yy437, NULL); }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 173: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy493, &yymsp[-3].minor.yy437, &yymsp[-1].minor.yy437, NULL, yymsp[0].minor.yy364); }
        break;
      case 174: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy493, &yymsp[-5].minor.yy437, &yymsp[-3].minor.yy437, yymsp[-1].minor.yy40, NULL); }
        break;
      case 175: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy493, &yymsp[-2].minor.yy437, &yymsp[0].minor.yy437); }
        break;
      case 177: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy364 = createIndexOption(pCxt, yymsp[-6].minor.yy40, releaseRawExprNode(pCxt, yymsp[-2].minor.yy364), NULL, yymsp[0].minor.yy364); }
        break;
      case 178: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy364 = createIndexOption(pCxt, yymsp[-8].minor.yy40, releaseRawExprNode(pCxt, yymsp[-4].minor.yy364), releaseRawExprNode(pCxt, yymsp[-2].minor.yy364), yymsp[0].minor.yy364); }
        break;
      case 181: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy364 = createFunctionNode(pCxt, &yymsp[-3].minor.yy437, yymsp[-1].minor.yy40); }
  yymsp[-3].minor.yy364 = yylhsminor.yy364;
        break;
      case 182: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy493, &yymsp[-2].minor.yy437, yymsp[0].minor.yy364, NULL); }
        break;
      case 183: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy493, &yymsp[-2].minor.yy437, NULL, &yymsp[0].minor.yy437); }
        break;
      case 184: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy493, &yymsp[0].minor.yy437); }
        break;
      case 185: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy493, yymsp[-1].minor.yy364, yymsp[0].minor.yy364); }
        break;
      case 187: /* analyze_opt ::= ANALYZE */
      case 294: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==294);
{ yymsp[0].minor.yy493 = true; }
        break;
      case 188: /* explain_options ::= */
{ yymsp[1].minor.yy364 = createDefaultExplainOptions(pCxt); }
        break;
      case 189: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy364 = setExplainVerbose(pCxt, yymsp[-2].minor.yy364, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 190: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy364 = setExplainRatio(pCxt, yymsp[-2].minor.yy364, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 192: /* literal ::= NK_INTEGER */
{ yylhsminor.yy364 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 193: /* literal ::= NK_FLOAT */
{ yylhsminor.yy364 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 194: /* literal ::= NK_STRING */
{ yylhsminor.yy364 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 195: /* literal ::= NK_BOOL */
{ yylhsminor.yy364 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 196: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy364 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy364 = yylhsminor.yy364;
        break;
      case 197: /* literal ::= duration_literal */
      case 206: /* signed_literal ::= signed */ yytestcase(yyruleno==206);
      case 223: /* expression ::= literal */ yytestcase(yyruleno==223);
      case 224: /* expression ::= pseudo_column */ yytestcase(yyruleno==224);
      case 225: /* expression ::= column_reference */ yytestcase(yyruleno==225);
      case 228: /* expression ::= subquery */ yytestcase(yyruleno==228);
      case 267: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==267);
      case 271: /* boolean_primary ::= predicate */ yytestcase(yyruleno==271);
      case 273: /* common_expression ::= expression */ yytestcase(yyruleno==273);
      case 274: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==274);
      case 276: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==276);
      case 278: /* table_reference ::= table_primary */ yytestcase(yyruleno==278);
      case 279: /* table_reference ::= joined_table */ yytestcase(yyruleno==279);
      case 283: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==283);
      case 330: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==330);
      case 332: /* query_primary ::= query_specification */ yytestcase(yyruleno==332);
{ yylhsminor.yy364 = yymsp[0].minor.yy364; }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 198: /* literal ::= NULL */
{ yylhsminor.yy364 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL)); }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 199: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy364 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 200: /* signed ::= NK_INTEGER */
{ yylhsminor.yy364 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 201: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy364 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 202: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy364 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy364 = yylhsminor.yy364;
        break;
      case 203: /* signed ::= NK_FLOAT */
{ yylhsminor.yy364 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 204: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy364 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 205: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy364 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy364 = yylhsminor.yy364;
        break;
      case 207: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy364 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 208: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy364 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 209: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy364 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 210: /* signed_literal ::= duration_literal */
      case 344: /* search_condition ::= common_expression */ yytestcase(yyruleno==344);
{ yylhsminor.yy364 = releaseRawExprNode(pCxt, yymsp[0].minor.yy364); }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 211: /* signed_literal ::= NULL */
{ yymsp[0].minor.yy364 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL); }
        break;
      case 226: /* expression ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy364 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy437, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy437, yymsp[-1].minor.yy40)); }
  yymsp[-3].minor.yy364 = yylhsminor.yy364;
        break;
      case 227: /* expression ::= function_name NK_LP NK_STAR NK_RP */
{ yylhsminor.yy364 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy437, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy437, createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy0)))); }
  yymsp[-3].minor.yy364 = yylhsminor.yy364;
        break;
      case 229: /* expression ::= NK_LP expression NK_RP */
      case 272: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==272);
{ yylhsminor.yy364 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy364)); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 230: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy364);
                                                                                    yylhsminor.yy364 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy364));
                                                                                  }
  yymsp[-1].minor.yy364 = yylhsminor.yy364;
        break;
      case 231: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy364);
                                                                                    yylhsminor.yy364 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[0].minor.yy364), NULL));
                                                                                  }
  yymsp[-1].minor.yy364 = yylhsminor.yy364;
        break;
      case 232: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy364);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy364);
                                                                                    yylhsminor.yy364 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy364), releaseRawExprNode(pCxt, yymsp[0].minor.yy364))); 
                                                                                  }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 233: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy364);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy364);
                                                                                    yylhsminor.yy364 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy364), releaseRawExprNode(pCxt, yymsp[0].minor.yy364))); 
                                                                                  }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 234: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy364);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy364);
                                                                                    yylhsminor.yy364 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy364), releaseRawExprNode(pCxt, yymsp[0].minor.yy364))); 
                                                                                  }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 235: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy364);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy364);
                                                                                    yylhsminor.yy364 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy364), releaseRawExprNode(pCxt, yymsp[0].minor.yy364))); 
                                                                                  }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 236: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy364);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy364);
                                                                                    yylhsminor.yy364 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy364), releaseRawExprNode(pCxt, yymsp[0].minor.yy364))); 
                                                                                  }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 237: /* expression_list ::= expression */
{ yylhsminor.yy40 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy364)); }
  yymsp[0].minor.yy40 = yylhsminor.yy40;
        break;
      case 238: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy40 = addNodeToList(pCxt, yymsp[-2].minor.yy40, releaseRawExprNode(pCxt, yymsp[0].minor.yy364)); }
  yymsp[-2].minor.yy40 = yylhsminor.yy40;
        break;
      case 239: /* column_reference ::= column_name */
{ yylhsminor.yy364 = createRawExprNode(pCxt, &yymsp[0].minor.yy437, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy437)); }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 240: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy364 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy437, &yymsp[0].minor.yy437, createColumnNode(pCxt, &yymsp[-2].minor.yy437, &yymsp[0].minor.yy437)); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 241: /* pseudo_column ::= NK_UNDERLINE ROWTS */
      case 243: /* pseudo_column ::= NK_UNDERLINE QSTARTTS */ yytestcase(yyruleno==243);
      case 244: /* pseudo_column ::= NK_UNDERLINE QENDTS */ yytestcase(yyruleno==244);
      case 245: /* pseudo_column ::= NK_UNDERLINE WSTARTTS */ yytestcase(yyruleno==245);
      case 246: /* pseudo_column ::= NK_UNDERLINE WENDTS */ yytestcase(yyruleno==246);
      case 247: /* pseudo_column ::= NK_UNDERLINE WDURATION */ yytestcase(yyruleno==247);
{
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy364 = createRawExprNode(pCxt, &t, createFunctionNode(pCxt, &t, NULL));
                                                                                  }
  yymsp[-1].minor.yy364 = yylhsminor.yy364;
        break;
      case 242: /* pseudo_column ::= TBNAME */
{ yylhsminor.yy364 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 248: /* predicate ::= expression compare_op expression */
      case 253: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==253);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy364);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy364);
                                                                                    yylhsminor.yy364 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy328, releaseRawExprNode(pCxt, yymsp[-2].minor.yy364), releaseRawExprNode(pCxt, yymsp[0].minor.yy364)));
                                                                                  }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 249: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy364);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy364);
                                                                                    yylhsminor.yy364 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy364), releaseRawExprNode(pCxt, yymsp[-2].minor.yy364), releaseRawExprNode(pCxt, yymsp[0].minor.yy364)));
                                                                                  }
  yymsp[-4].minor.yy364 = yylhsminor.yy364;
        break;
      case 250: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy364);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy364);
                                                                                    yylhsminor.yy364 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy364), releaseRawExprNode(pCxt, yymsp[-5].minor.yy364), releaseRawExprNode(pCxt, yymsp[0].minor.yy364)));
                                                                                  }
  yymsp[-5].minor.yy364 = yylhsminor.yy364;
        break;
      case 251: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy364);
                                                                                    yylhsminor.yy364 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy364), NULL));
                                                                                  }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 252: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy364);
                                                                                    yylhsminor.yy364 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy364), NULL));
                                                                                  }
  yymsp[-3].minor.yy364 = yylhsminor.yy364;
        break;
      case 254: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy328 = OP_TYPE_LOWER_THAN; }
        break;
      case 255: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy328 = OP_TYPE_GREATER_THAN; }
        break;
      case 256: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy328 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 257: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy328 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 258: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy328 = OP_TYPE_NOT_EQUAL; }
        break;
      case 259: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy328 = OP_TYPE_EQUAL; }
        break;
      case 260: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy328 = OP_TYPE_LIKE; }
        break;
      case 261: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy328 = OP_TYPE_NOT_LIKE; }
        break;
      case 262: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy328 = OP_TYPE_MATCH; }
        break;
      case 263: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy328 = OP_TYPE_NMATCH; }
        break;
      case 264: /* in_op ::= IN */
{ yymsp[0].minor.yy328 = OP_TYPE_IN; }
        break;
      case 265: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy328 = OP_TYPE_NOT_IN; }
        break;
      case 266: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy364 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy40)); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 268: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy364);
                                                                                    yylhsminor.yy364 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy364), NULL));
                                                                                  }
  yymsp[-1].minor.yy364 = yylhsminor.yy364;
        break;
      case 269: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy364);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy364);
                                                                                    yylhsminor.yy364 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy364), releaseRawExprNode(pCxt, yymsp[0].minor.yy364)));
                                                                                  }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 270: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy364);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy364);
                                                                                    yylhsminor.yy364 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy364), releaseRawExprNode(pCxt, yymsp[0].minor.yy364)));
                                                                                  }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 275: /* from_clause ::= FROM table_reference_list */
      case 305: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==305);
      case 328: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==328);
{ yymsp[-1].minor.yy364 = yymsp[0].minor.yy364; }
        break;
      case 277: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy364 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy364, yymsp[0].minor.yy364, NULL); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 280: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy364 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy437, &yymsp[0].minor.yy437); }
  yymsp[-1].minor.yy364 = yylhsminor.yy364;
        break;
      case 281: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy364 = createRealTableNode(pCxt, &yymsp[-3].minor.yy437, &yymsp[-1].minor.yy437, &yymsp[0].minor.yy437); }
  yymsp[-3].minor.yy364 = yylhsminor.yy364;
        break;
      case 282: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy364 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy364), &yymsp[0].minor.yy437); }
  yymsp[-1].minor.yy364 = yylhsminor.yy364;
        break;
      case 284: /* alias_opt ::= */
{ yymsp[1].minor.yy437 = nil_token;  }
        break;
      case 285: /* alias_opt ::= table_alias */
{ yylhsminor.yy437 = yymsp[0].minor.yy437; }
  yymsp[0].minor.yy437 = yylhsminor.yy437;
        break;
      case 286: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy437 = yymsp[0].minor.yy437; }
        break;
      case 287: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 288: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==288);
{ yymsp[-2].minor.yy364 = yymsp[-1].minor.yy364; }
        break;
      case 289: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy364 = createJoinTableNode(pCxt, yymsp[-4].minor.yy392, yymsp[-5].minor.yy364, yymsp[-2].minor.yy364, yymsp[0].minor.yy364); }
  yymsp[-5].minor.yy364 = yylhsminor.yy364;
        break;
      case 290: /* join_type ::= */
{ yymsp[1].minor.yy392 = JOIN_TYPE_INNER; }
        break;
      case 291: /* join_type ::= INNER */
{ yymsp[0].minor.yy392 = JOIN_TYPE_INNER; }
        break;
      case 292: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy364 = createSelectStmt(pCxt, yymsp[-7].minor.yy493, yymsp[-6].minor.yy40, yymsp[-5].minor.yy364);
                                                                                    yymsp[-8].minor.yy364 = addWhereClause(pCxt, yymsp[-8].minor.yy364, yymsp[-4].minor.yy364);
                                                                                    yymsp[-8].minor.yy364 = addPartitionByClause(pCxt, yymsp[-8].minor.yy364, yymsp[-3].minor.yy40);
                                                                                    yymsp[-8].minor.yy364 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy364, yymsp[-2].minor.yy364);
                                                                                    yymsp[-8].minor.yy364 = addGroupByClause(pCxt, yymsp[-8].minor.yy364, yymsp[-1].minor.yy40);
                                                                                    yymsp[-8].minor.yy364 = addHavingClause(pCxt, yymsp[-8].minor.yy364, yymsp[0].minor.yy364);
                                                                                  }
        break;
      case 295: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy493 = false; }
        break;
      case 296: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy40 = NULL; }
        break;
      case 300: /* select_item ::= common_expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy364);
                                                                                    yylhsminor.yy364 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy364), &t);
                                                                                  }
  yymsp[0].minor.yy364 = yylhsminor.yy364;
        break;
      case 301: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy364 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy364), &yymsp[0].minor.yy437); }
  yymsp[-1].minor.yy364 = yylhsminor.yy364;
        break;
      case 302: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy364 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy364), &yymsp[0].minor.yy437); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 303: /* select_item ::= table_name NK_DOT NK_STAR */
{ yylhsminor.yy364 = createColumnNode(pCxt, &yymsp[-2].minor.yy437, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 307: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 324: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==324);
      case 334: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==334);
{ yymsp[-2].minor.yy40 = yymsp[0].minor.yy40; }
        break;
      case 309: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy364 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy364), releaseRawExprNode(pCxt, yymsp[-1].minor.yy364)); }
        break;
      case 310: /* twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP */
{ yymsp[-3].minor.yy364 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy364)); }
        break;
      case 311: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy364 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy364), NULL, yymsp[-1].minor.yy364, yymsp[0].minor.yy364); }
        break;
      case 312: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy364 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy364), releaseRawExprNode(pCxt, yymsp[-3].minor.yy364), yymsp[-1].minor.yy364, yymsp[0].minor.yy364); }
        break;
      case 314: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy364 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy364); }
        break;
      case 316: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy364 = createFillNode(pCxt, yymsp[-1].minor.yy478, NULL); }
        break;
      case 317: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy364 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy40)); }
        break;
      case 318: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy478 = FILL_MODE_NONE; }
        break;
      case 319: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy478 = FILL_MODE_PREV; }
        break;
      case 320: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy478 = FILL_MODE_NULL; }
        break;
      case 321: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy478 = FILL_MODE_LINEAR; }
        break;
      case 322: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy478 = FILL_MODE_NEXT; }
        break;
      case 325: /* group_by_list ::= expression */
{ yylhsminor.yy40 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy364))); }
  yymsp[0].minor.yy40 = yylhsminor.yy40;
        break;
      case 326: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy40 = addNodeToList(pCxt, yymsp[-2].minor.yy40, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy364))); }
  yymsp[-2].minor.yy40 = yylhsminor.yy40;
        break;
      case 329: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy364 = addOrderByClause(pCxt, yymsp[-3].minor.yy364, yymsp[-2].minor.yy40);
                                                                                    yylhsminor.yy364 = addSlimitClause(pCxt, yylhsminor.yy364, yymsp[-1].minor.yy364);
                                                                                    yylhsminor.yy364 = addLimitClause(pCxt, yylhsminor.yy364, yymsp[0].minor.yy364);
                                                                                  }
  yymsp[-3].minor.yy364 = yylhsminor.yy364;
        break;
      case 331: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy364 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy364, yymsp[0].minor.yy364); }
  yymsp[-3].minor.yy364 = yylhsminor.yy364;
        break;
      case 336: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 340: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==340);
{ yymsp[-1].minor.yy364 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 337: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 341: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==341);
{ yymsp[-3].minor.yy364 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 338: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 342: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==342);
{ yymsp[-3].minor.yy364 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 343: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy364 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy364); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 347: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy364 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy364), yymsp[-1].minor.yy210, yymsp[0].minor.yy177); }
  yymsp[-2].minor.yy364 = yylhsminor.yy364;
        break;
      case 348: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy210 = ORDER_ASC; }
        break;
      case 349: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy210 = ORDER_ASC; }
        break;
      case 350: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy210 = ORDER_DESC; }
        break;
      case 351: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy177 = NULL_ORDER_DEFAULT; }
        break;
      case 352: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy177 = NULL_ORDER_FIRST; }
        break;
      case 353: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy177 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
