/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.TaosGlobalConfig;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;

public class TSDBResultSetRowData {
    private ArrayList<Object> data = null;
    private int colSize = 0;

    public TSDBResultSetRowData(int colSize) {
        this.setColSize(colSize);
    }

    public TSDBResultSetRowData() {
        this.data = new ArrayList();
        this.setColSize(0);
    }

    public void clear() {
        if (this.data != null) {
            this.data.clear();
        }
        if (this.colSize == 0) {
            return;
        }
        this.data = new ArrayList(this.colSize);
        this.data.addAll(Collections.nCopies(this.colSize, null));
    }

    public boolean wasNull(int col) {
        return this.data.get(col) == null;
    }

    public void setBoolean(int col, boolean value) {
        this.data.set(col, value);
    }

    public boolean getBoolean(int col, int srcType) throws SQLException {
        Object obj = this.data.get(col);
        switch (srcType) {
            case 1: {
                return (Boolean)obj;
            }
            case 6: {
                return (double)((Float)obj).floatValue() == 1.0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return (Double)obj == 1.0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return (Byte)obj == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return (Short)obj == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return (Integer)obj == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: 
            case 9: {
                return (Long)obj == 1L ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public void setByte(int col, byte value) {
        this.data.set(col, value);
    }

    public void setShort(int col, short value) {
        this.data.set(col, value);
    }

    public void setInt(int col, int value) {
        this.data.set(col, value);
    }

    public int getInt(int col, int srcType) throws SQLException {
        Object obj = this.data.get(col);
        switch (srcType) {
            case 1: {
                return Boolean.TRUE.equals(obj) ? 1 : 0;
            }
            case 6: {
                return ((Float)obj).intValue();
            }
            case 7: {
                return ((Double)obj).intValue();
            }
            case 2: {
                return ((Byte)obj).byteValue();
            }
            case 3: {
                return ((Short)obj).shortValue();
            }
            case 4: {
                return (Integer)obj;
            }
            case 5: 
            case 9: {
                return ((Long)obj).intValue();
            }
            case 8: 
            case 10: {
                return Integer.parseInt((String)obj);
            }
        }
        return 0;
    }

    public void setLong(int col, long value) {
        this.data.set(col, value);
    }

    public long getLong(int col, int srcType) throws SQLException {
        Object obj = this.data.get(col);
        switch (srcType) {
            case 1: {
                return Boolean.TRUE.equals(obj) ? 1L : 0L;
            }
            case 6: {
                return ((Float)obj).longValue();
            }
            case 7: {
                return ((Double)obj).longValue();
            }
            case 2: {
                return ((Byte)obj).byteValue();
            }
            case 3: {
                return ((Short)obj).shortValue();
            }
            case 4: {
                return ((Integer)obj).intValue();
            }
            case 5: 
            case 9: {
                return (Long)obj;
            }
            case 8: 
            case 10: {
                return Long.parseLong((String)obj);
            }
        }
        return 0L;
    }

    public void setFloat(int col, float value) {
        this.data.set(col, Float.valueOf(value));
    }

    public float getFloat(int col, int srcType) throws SQLException {
        Object obj = this.data.get(col);
        switch (srcType) {
            case 1: {
                return Boolean.TRUE.equals(obj) ? 1.0f : 0.0f;
            }
            case 6: {
                return ((Float)obj).floatValue();
            }
            case 7: {
                return ((Double)obj).floatValue();
            }
            case 2: {
                return ((Byte)obj).byteValue();
            }
            case 3: {
                return ((Short)obj).shortValue();
            }
            case 4: {
                return ((Integer)obj).intValue();
            }
            case 5: 
            case 9: {
                return ((Long)obj).longValue();
            }
        }
        return 0.0f;
    }

    public void setDouble(int col, double value) {
        this.data.set(col, value);
    }

    public double getDouble(int col, int srcType) throws SQLException {
        Object obj = this.data.get(col);
        switch (srcType) {
            case 1: {
                return Boolean.TRUE.equals(obj) ? 1.0 : 0.0;
            }
            case 6: {
                return ((Float)obj).floatValue();
            }
            case 7: {
                return (Double)obj;
            }
            case 2: {
                return ((Byte)obj).byteValue();
            }
            case 3: {
                return ((Short)obj).shortValue();
            }
            case 4: {
                return ((Integer)obj).intValue();
            }
            case 5: 
            case 9: {
                return ((Long)obj).longValue();
            }
        }
        return 0.0;
    }

    public void setString(int col, String value) {
        this.data.set(col, value);
    }

    public void setByteArray(int col, byte[] value) {
        try {
            this.data.set(col, new String(value, TaosGlobalConfig.getCharset()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getString(int col, int srcType) throws SQLException {
        if (srcType == 8 || srcType == 10) {
            return (String)this.data.get(col);
        }
        return String.valueOf(this.data.get(col));
    }

    public void setTimestamp(int col, long ts) {
        this.data.set(col, ts);
    }

    public Timestamp getTimestamp(int col) {
        return new Timestamp((Long)this.data.get(col));
    }

    public Object get(int col) {
        return this.data.get(col);
    }

    public int getColSize() {
        return this.colSize;
    }

    public void setColSize(int colSize) {
        this.colSize = colSize;
        this.clear();
    }

    public ArrayList<Object> getData() {
        return this.data;
    }

    public void setData(ArrayList<Object> data) {
        this.data = (ArrayList)data.clone();
    }
}

