/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 457
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOperatorType yy20;
  int8_t yy33;
  SAlterOption yy123;
  SNode* yy148;
  SToken yy199;
  EFillMode yy334;
  bool yy397;
  SNodeList* yy404;
  EJoinType yy470;
  ENullOrder yy499;
  int64_t yy525;
  SDataType yy530;
  int32_t yy706;
  EOrder yy898;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             709
#define YYNRULE              539
#define YYNTOKEN             322
#define YY_MAX_SHIFT         708
#define YY_MIN_SHIFTREDUCE   1050
#define YY_MAX_SHIFTREDUCE   1588
#define YY_ERROR_ACTION      1589
#define YY_ACCEPT_ACTION     1590
#define YY_NO_ACTION         1591
#define YY_MIN_REDUCE        1592
#define YY_MAX_REDUCE        2130
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2410)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1946,  458, 1735,  459, 1628,  565,  584,   33,  274, 2101,
 /*    10 */   158, 1799,   43,   41, 1519, 1700,  351, 2106,  329, 1857,
 /*    20 */   360, 2101, 1370, 1592,  564,  173,  597, 1797,  352, 2102,
 /*    30 */   566, 1964,  464, 1449,  167, 1368,  155, 2105,  460,  580,
 /*    40 */    52, 2102, 2104,  399, 1915, 1748,  613,  122,  121,  120,
 /*    50 */   119,  118,  117,  116,  115,  114, 1847, 1746, 1444,  227,
 /*    60 */    36,   35, 1776,   16,   42,   40,   39,   38,   37, 1945,
 /*    70 */  1376, 1799,  467, 1980,  459, 1628,  100, 1947,  617, 1949,
 /*    80 */  1950,  612,  565,  607,  596,  545, 2101, 1798,  170, 2101,
 /*    90 */  2033, 1615, 1737,  167,  354, 2029,   12,   58,  597, 1946,
 /*   100 */  1933,  564,  173, 1929, 2107,  173, 2102,  566,  175, 2102,
 /*   110 */   566, 1929,  123,   47,  332, 1846, 2059,  113,  705,  497,
 /*   120 */   112,  111,  110,  109,  108,  107,  106,  105,  104, 1746,
 /*   130 */  1964, 1925, 1931, 1451, 1452, 1915, 1590, 1799,  614, 1925,
 /*   140 */  1931,  343,  607, 1915,  353,  613,   43,   41,  476, 1555,
 /*   150 */   607,   62,   97, 1797,  360, 1723, 1370, 1396,  596, 1946,
 /*   160 */    46,  365, 1425, 1434, 1792, 1794,  132, 1449, 1945, 1368,
 /*   170 */   597, 1102, 1980, 1101, 1738,  100, 1947,  617, 1949, 1950,
 /*   180 */   612, 1371,  607, 1369,  178,  134,  210,  141, 2004, 2033,
 /*   190 */  1964,  258, 1444,  354, 2029, 1793, 1794,   16,  580,  375,
 /*   200 */   596, 1746, 1103, 1915, 1376,  613, 1374, 1375,  405, 1424,
 /*   210 */  1427, 1428, 1429, 1430, 1431, 1432, 1433,  609,  605, 1442,
 /*   220 */  1443, 1445, 1446, 1447, 1448, 1450, 1453,    2, 1945,   58,
 /*   230 */    12,   85, 1980, 1946,  225,  100, 1947,  617, 1949, 1950,
 /*   240 */   612,  545,  607,   58, 1395, 2101,  176,  170,  318, 2033,
 /*   250 */  1083,   80,  705,  354, 2029,   42,   40,   39,   38,   37,
 /*   260 */  2107,  173,  176,  649, 1964, 2102,  566, 1451, 1452,  560,
 /*   270 */  1253, 1254,  614, 1170, 1742, 2060,   46, 1915, 1395,  613,
 /*   280 */    43,   41,  146,  145,  646,  645,  644,  143,  360, 1085,
 /*   290 */  1370, 1088, 1089, 1946,   82,  320, 1425, 1434,  530,  577,
 /*   300 */   528, 1449, 1945, 1368,  597, 1102, 1980, 1101, 1172,  100,
 /*   310 */  1947,  617, 1949, 1950,  612, 1371,  607, 1369,  123,   58,
 /*   320 */    58, 2008, 1397, 2033, 1964,  502, 1444,  354, 2029,  169,
 /*   330 */   131,   16,  614, 1614, 1396, 1746, 1103, 1915, 1376,  613,
 /*   340 */  1374, 1375, 1786, 1424, 1427, 1428, 1429, 1430, 1431, 1432,
 /*   350 */  1433,  609,  605, 1442, 1443, 1445, 1446, 1447, 1448, 1450,
 /*   360 */  1453,    2, 1945,    9,   12, 1946, 1980,  526,  441,  100,
 /*   370 */  1947,  617, 1949, 1950,  612, 2106,  607, 1915,  176, 2101,
 /*   380 */   524, 2121,  522, 2033, 1613,   91,  705,  354, 2029,  255,
 /*   390 */  2041,  576,  176,  124,  575, 2105, 1964, 2101, 2067, 2102,
 /*   400 */  2103, 1451, 1452,  398,  611,  397, 2106, 1739,  157, 1915,
 /*   410 */  1604,  613,  564,  173,   43,   41, 1454, 2102,  566, 1395,
 /*   420 */  1306, 1307,  360, 1397, 1370,  176,  189,  188, 1915,  457,
 /*   430 */  1425, 1434,  462, 1634, 1945, 1449,  577, 1368, 1980, 1661,
 /*   440 */   597,  310, 1947,  617, 1949, 1950,  612, 2048,  607, 1371,
 /*   450 */  1999, 1369,  466, 1612,  403,  462, 1634,   36,   35, 1545,
 /*   460 */  1444,   42,   40,   39,   38,   37,  257,  131,  176,  176,
 /*   470 */  1611, 1746, 1376, 2045, 1374, 1375,  583, 1424, 1427, 1428,
 /*   480 */  1429, 1430, 1431, 1432, 1433,  609,  605, 1442, 1443, 1445,
 /*   490 */  1446, 1447, 1448, 1450, 1453,    2,  133, 1915,   44, 2004,
 /*   500 */  1578, 1946, 1370,  555,  512,  511,  510,  552, 1543, 1544,
 /*   510 */  1546, 1547,  128,  506, 1915, 1368,  651,  505,  545, 1610,
 /*   520 */   705, 1398, 2101,  504,  509,  579,  171, 2041, 2042,  503,
 /*   530 */   129, 2046, 1964,  508,  507, 1451, 1452, 2107,  173,  226,
 /*   540 */   614,  597, 2102,  566, 1799, 1915, 1535,  613,   43,   41,
 /*   550 */  1376,  364,   80,  676,  674,  404,  360, 1609, 1370,  597,
 /*   560 */  1797, 1946,  597, 1915, 1425, 1434,  127,  257, 1394, 1449,
 /*   570 */  1945, 1368, 1746,  413, 1980, 1741,  427,  100, 1947,  617,
 /*   580 */  1949, 1950,  612, 1371,  607, 1369,  561,  556,  642, 2006,
 /*   590 */  1746, 2033, 1964, 1746, 1444,  354, 2029, 1480,  705, 1842,
 /*   600 */   614, 1915, 1347, 1348,    9, 1915, 1376,  613, 1374, 1375,
 /*   610 */   181, 1424, 1427, 1428, 1429, 1430, 1431, 1432, 1433,  609,
 /*   620 */   605, 1442, 1443, 1445, 1446, 1447, 1448, 1450, 1453,    2,
 /*   630 */  1945,  517,   44,  597, 1980,  144,  597,  100, 1947,  617,
 /*   640 */  1949, 1950,  612,  597,  607,  597,  527,  428,  597, 2121,
 /*   650 */   474, 2033, 1608, 1902,  705,  354, 2029,  475, 1946, 1743,
 /*   660 */   224, 1371,  139, 1369, 1746,  182, 2095, 1746,   30, 1451,
 /*   670 */  1452, 1724, 1607, 1964, 1746,  520, 1746,  597, 1485, 1746,
 /*   680 */   514,  559,   43,   41,  185,  223, 1374, 1375,   51, 1964,
 /*   690 */   360,  541, 1370, 1376, 1523,  597, 1915,  614, 1425, 1434,
 /*   700 */  1395,  382, 1915, 1449,  613, 1368,   36,   35, 1746,  581,
 /*   710 */    42,   40,   39,   38,   37,  363, 1915, 1371, 1398, 1369,
 /*   720 */   558,   77,   64,  155,   76,   63, 1746, 1945, 1444,  663,
 /*   730 */  1606, 1980, 1748,  476,  159, 1947,  617, 1949, 1950,  612,
 /*   740 */  1376,  607, 1374, 1375, 1731, 1424, 1427, 1428, 1429, 1430,
 /*   750 */  1431, 1432, 1433,  609,  605, 1442, 1443, 1445, 1446, 1447,
 /*   760 */  1448, 1450, 1453,    2,   36,   35,   12, 1946,   42,   40,
 /*   770 */    39,   38,   37,  366, 1915,  546, 2070,  597,  265,  266,
 /*   780 */   317,  155, 1393,  264,  599,  597, 2005,  501,  705,  435,
 /*   790 */  1748,  269,  448, 1593,    9,  447,    7, 1603, 1964,  592,
 /*   800 */    25, 1722,  288, 1451, 1452, 1776,  614,  649, 1746,  500,
 /*   810 */   419, 1915,  449,  613,  113,  421, 1746,  112,  111,  110,
 /*   820 */   109,  108,  107,  106,  105,  104,  146,  145,  646,  645,
 /*   830 */   644,  143, 1425, 1434,  394,  597,  531,   39,   38,   37,
 /*   840 */  1980, 1915, 1426,  306, 1947,  617, 1949, 1950,  612,  594,
 /*   850 */   607, 1371, 1733, 1369, 1602,  396,  392,  333, 1658, 1459,
 /*   860 */  2105,   29,  235,  651, 1729, 1395, 1746,   36,   35,  409,
 /*   870 */   230,   42,   40,   39,   38,   37, 1374, 1375,  608, 1424,
 /*   880 */  1427, 1428, 1429, 1430, 1431, 1432, 1433,  609,  605, 1442,
 /*   890 */  1443, 1445, 1446, 1447, 1448, 1450, 1453,    2, 1915,  445,
 /*   900 */  1088, 1089,  440,  439,  438,  437,  434,  433,  432,  431,
 /*   910 */   430,  426,  425,  424,  423,  334,  416,  415,  414, 1516,
 /*   920 */   411,  410,  331,  682,  681,  680,  679,  370, 1601,  678,
 /*   930 */   677,  135,  672,  671,  670,  669,  668,  667,  666,  665,
 /*   940 */   148,  661,  660,  659,  369,  368,  656,  655,  654,  653,
 /*   950 */   652,  156,  597, 1600,  641,  584,  294,   36,   35,  357,
 /*   960 */   356,   42,   40,   39,   38,   37,  595, 1946, 1858, 1384,
 /*   970 */   292,   66, 1915,  597,   65,    6,  512,  511,  510,  601,
 /*   980 */  1449, 2005, 1377, 1746,  128,  506, 1721,  275, 2048,  505,
 /*   990 */  2048,  155,  193,  454,  452,  504,  509, 1915, 1964, 1934,
 /*  1000 */  1749,  503,  337, 1398, 1746, 1444,  614, 1426,   11,   10,
 /*  1010 */  1929, 1915,  325,  613, 2044, 1599, 2043, 1376, 1210,  639,
 /*  1020 */   638,  637, 1214,  636, 1216, 1217,  635, 1219,  632,   58,
 /*  1030 */  1225,  629, 1227, 1228,  626,  623, 1945,  572, 1925, 1931,
 /*  1040 */  1980,  569, 1598,  100, 1947,  617, 1949, 1950,  612,  607,
 /*  1050 */   607,  540, 1597, 1596, 1478, 2121,  597, 2033, 1829, 1915,
 /*  1060 */   211,  354, 2029,  708,  338,  603,  336,  335,   99,  499,
 /*  1070 */   367,  643, 2052,  501, 1790,  162, 1595,  281, 1842, 1842,
 /*  1080 */  1395,  493,  489,  485,  481,  208, 1915, 1746,  647,  183,
 /*  1090 */   187, 1790,  166, 1605,  649,  500, 1915, 1915,  698,  694,
 /*  1100 */   690,  686,  279,  664, 1492, 1716,   74,   73,  402,  648,
 /*  1110 */  1479,  180, 1790,  146,  145,  646,  645,  644,  143,  568,
 /*  1120 */  1915,   48,   81,    3,   67,  206, 2053, 1512, 1385,  316,
 /*  1130 */  1380, 1701,  390,  406,  388,  384,  380,  377,  374,   98,
 /*  1140 */  1648,  137,  272,  125, 2073,   31,  407,  234,  577, 1587,
 /*  1150 */  1588,   36,   35, 1388, 1390,   42,   40,   39,   38,   37,
 /*  1160 */    60, 1515,  513,   11,   10,  605, 1442, 1443, 1445, 1446,
 /*  1170 */  1447, 1448, 1641,  216,   75,  593,  214, 1946,  176,  131,
 /*  1180 */  1512,   32,  358, 1473, 1474, 1475, 1476, 1477, 1481, 1482,
 /*  1190 */  1483, 1484,  205,  199,  515,  204,   36,   35,  472,  239,
 /*  1200 */    42,   40,   39,   38,   37, 1946,  218,  252, 1964,  217,
 /*  1210 */   422, 1639,  260, 1542,  197,  220,  614,  222,  219, 1379,
 /*  1220 */   221, 1915, 1426,  613,  233,   50, 1378,  553,  209, 1341,
 /*  1230 */   544,  229,  604,  518, 1131,   96, 1964,   45,  172, 2041,
 /*  1240 */  2042,  246,  129, 2046,  614,   93, 1945,  373, 1946, 1915,
 /*  1250 */  1980,  613,  241,  100, 1947,  617, 1949, 1950,  612,  573,
 /*  1260 */   607,  570, 1936,  262,   83,  600, 1965, 2033, 1851, 1132,
 /*  1270 */   140,  354, 2029,  371, 1945, 1629, 1946,   45, 1980, 1964,
 /*  1280 */  1787,  101, 1947,  617, 1949, 1950,  612,  614,  607,  545,
 /*  1290 */  1317,  142, 1915, 2101,  613, 2033,  657,   36,   35, 2032,
 /*  1300 */  2029,   42,   40,   39,   38,   37, 2063, 1964, 2107,  173,
 /*  1310 */   578, 1938,  254, 2102,  566,  614,  267, 1945, 1151, 1946,
 /*  1320 */  1915, 1980,  613,  589,  101, 1947,  617, 1949, 1950,  612,
 /*  1330 */  1435,  607,  144,    1,   60, 1635,   45, 1946, 2033,  251,
 /*  1340 */   658,    4,  602, 2029,  271,  615,  577,  381,  376, 1980,
 /*  1350 */  1964,  330,  101, 1947,  617, 1949, 1950,  612,  611,  607,
 /*  1360 */  1334, 1585, 1149, 1915,  282,  613, 2033, 1382, 1964, 1398,
 /*  1370 */   324, 2029,  621,  186, 1381, 1470,  614,  131,  408, 1852,
 /*  1380 */  1946, 1915, 1933,  613,  700, 1203,  412, 1486, 1945,  287,
 /*  1390 */   142,  144, 1980, 1929,  417,  310, 1947,  617, 1949, 1950,
 /*  1400 */   612,  610,  607,  598, 1998,  443, 1945, 1393,  429, 1844,
 /*  1410 */  1980, 1964,  436,  160, 1947,  617, 1949, 1950,  612,  614,
 /*  1420 */   607, 1925, 1931,  355, 1915, 1231,  613,  126,  142,  451,
 /*  1430 */   442,  444,  607, 1946,  450,  190,  174, 2041, 2042, 1399,
 /*  1440 */   129, 2046, 1401, 1235, 1242,  453,  455,  456,  465, 1945,
 /*  1450 */   468,  469, 1400, 1980, 1946, 1584,  101, 1947,  617, 1949,
 /*  1460 */  1950,  612,  196,  607, 1964,  567, 2122,  198,  470, 1402,
 /*  1470 */  2033,  471,  614, 1105,  201, 2030,  473, 1915,  496,  613,
 /*  1480 */  1240,  147,  477,  203,   78, 1964,   79,  207,  494,  495,
 /*  1490 */   103, 1892,  498,  614,  372, 1891,  532, 1736, 1915,  535,
 /*  1500 */   613,  319, 1945,  534,  228,  283, 1980,  549, 1946,  159,
 /*  1510 */  1947,  617, 1949, 1950,  612,  213,  607, 1732,  542,  215,
 /*  1520 */   149,  150,  536, 1945, 1734,  539, 1730, 1980,  554,  151,
 /*  1530 */   304, 1947,  617, 1949, 1950,  612,  545,  607,  152, 1964,
 /*  1540 */  2101,  231, 2079,  587,  551,    5,  563,  614,  344,  557,
 /*  1550 */  2064, 2071, 1915,  548,  613, 2107,  173, 2074,  237,  240,
 /*  1560 */  2102,  566, 1946,   36,   35, 2055,  245,   42,   40,   39,
 /*  1570 */    38,   37,  550,  247,  562,  345, 1512, 1945,  547, 1946,
 /*  1580 */  2124, 1980,  574, 2078,  160, 1947,  617, 1949, 1950,  612,
 /*  1590 */   249,  607,  250, 1964,  130,  163,  571, 1397,  349,  582,
 /*  1600 */  2100,  614, 2049,  348,  259, 1946, 1915,  284,  613,  253,
 /*  1610 */  1964,  585,  586,  285, 1863,  359,  590, 1862,  614, 1861,
 /*  1620 */   350,  248,   88, 1915,  286,  613,  591, 1747,   57,   92,
 /*  1630 */  2014, 1945,   90, 1946,  619, 1980, 1964, 2123,  311, 1947,
 /*  1640 */   617, 1949, 1950,  612,  614,  607, 1791,  289, 1945, 1915,
 /*  1650 */  1717,  613, 1980,  278,  701,  311, 1947,  617, 1949, 1950,
 /*  1660 */   612,  704,  607,  313, 1964,  702,   49,  321,  298,  361,
 /*  1670 */   322,  312,  614,  302, 1945,  293, 1946, 1915, 1980,  613,
 /*  1680 */   291,  295, 1947,  617, 1949, 1950,  612, 1909,  607, 1908,
 /*  1690 */    71, 1907, 1946, 1906,   72, 1903,  378,  379, 1362, 1363,
 /*  1700 */   179,  383, 1945, 1901,  385,  386, 1980, 1964,  387,  311,
 /*  1710 */  1947,  617, 1949, 1950,  612,  614,  607, 1900,  389,  154,
 /*  1720 */  1915, 1899,  613, 1964, 1898,  391,  393, 1897, 1337,  395,
 /*  1730 */  1336,  614, 1874, 1873,  400,  533, 1915,  401,  613, 1872,
 /*  1740 */  1871, 1837, 1836, 1946, 1297, 1945, 1834,  136, 1833, 1980,
 /*  1750 */  1832, 1835,  296, 1947,  617, 1949, 1950,  612, 1831,  607,
 /*  1760 */  1830, 1945, 1828, 1827, 1826, 1980,  184, 1825,  297, 1947,
 /*  1770 */   617, 1949, 1950,  612, 1964,  607,  420,  545,  418, 1824,
 /*  1780 */  1823, 2101,  614, 1822, 1821, 1820, 1946, 1915, 1819,  613,
 /*  1790 */  1818, 1817, 1816, 1815, 1814, 1813, 2107,  173, 1812, 1811,
 /*  1800 */  1810, 2102,  566, 1946, 1809, 1808, 1807,  138, 1806, 1805,
 /*  1810 */  1804, 1299, 1945, 1803, 1802,  446, 1980, 1964, 1801,  303,
 /*  1820 */  1947,  617, 1949, 1950,  612,  614,  607, 1800, 1663,  191,
 /*  1830 */  1915, 1178,  613, 1662, 1964,  192, 1660, 1624, 1091,  194,
 /*  1840 */    69, 1623,  614, 1090, 1887, 1881,  168, 1915, 1870,  613,
 /*  1850 */  1935, 1869,  195,  202,  461, 1945, 1946, 1854,  463, 1980,
 /*  1860 */    70,  200,  307, 1947,  617, 1949, 1950,  612, 1725,  607,
 /*  1870 */  1659, 1657, 1945, 1946,  478, 1655, 1980,  480,  479,  299,
 /*  1880 */  1947,  617, 1949, 1950,  612,  482,  607, 1964,  483, 1124,
 /*  1890 */  1653,  484,  488,  486,  487,  614, 1651,  490,  492, 1638,
 /*  1900 */  1915, 1637,  613,  491, 1964, 1620, 1727, 1247, 1246, 1726,
 /*  1910 */   673, 1169,  614, 1168, 1167, 1161, 1166, 1915,  675,  613,
 /*  1920 */    59, 1649,  212, 1163, 1946, 1945, 1162, 1160, 1642, 1980,
 /*  1930 */   339, 1640,  308, 1947,  617, 1949, 1950,  612,  340,  607,
 /*  1940 */   341, 1946, 1945, 1619,  516,  519, 1980,  521, 1618,  300,
 /*  1950 */  1947,  617, 1949, 1950,  612, 1964,  607,  523, 1617,  525,
 /*  1960 */   102, 1352, 1351,  614, 1354,  529, 1886, 1946, 1915,   24,
 /*  1970 */   613, 1343, 1964, 1880,  537, 1868, 1866, 2106,   17,   14,
 /*  1980 */   614,   53,  232,   26, 1946, 1915, 1557,  613,   56,  243,
 /*  1990 */   538,  236,   61, 1945,  238,  342,  161, 1980, 1964, 1541,
 /*  2000 */   309, 1947,  617, 1949, 1950,  612,  614,  607, 1534,  242,
 /*  2010 */  1945, 1915,  543,  613, 1980, 1964,  153,  301, 1947,  617,
 /*  2020 */  1949, 1950,  612,  614,  607,   27,  244, 1936, 1915,   28,
 /*  2030 */   613,   84,   19, 1572, 1571, 1946, 1945,  346, 1577, 1578,
 /*  2040 */  1980, 1576, 1575,  314, 1947,  617, 1949, 1950,  612,  347,
 /*  2050 */   607, 1509, 1508, 1945,   55,  256,  164, 1980, 1867, 1865,
 /*  2060 */   315, 1947,  617, 1949, 1950,  612, 1964,  607, 1864,  261,
 /*  2070 */   588, 1853,   18,   20,  614, 1539,   87,  263, 1946, 1915,
 /*  2080 */   268,  613,   86,   15,  270,  273,   54,   89,   93,   21,
 /*  2090 */     8,   10, 1461, 1460, 1946, 1386, 1983,  165,  177, 1417,
 /*  2100 */  1439,  606,  618, 1224, 1945,  620,  616,   34, 1980, 1964,
 /*  2110 */  1471, 1958, 1947,  617, 1949, 1950,  612,  614,  607, 1437,
 /*  2120 */  1436,   13, 1915,   22,  613, 1964, 1409,   23,  362, 1232,
 /*  2130 */   622,  624, 1229,  614,  627,  625,  630, 1226, 1915,  628,
 /*  2140 */   613, 1220,  631,  633, 1218, 1946, 1223, 1945,  634, 1209,
 /*  2150 */  1222, 1980,   94, 1221, 1957, 1947,  617, 1949, 1950,  612,
 /*  2160 */   276,  607,  640, 1945, 1241,   95, 1237, 1980,   68, 1122,
 /*  2170 */  1956, 1947,  617, 1949, 1950,  612, 1964,  607,  650, 1176,
 /*  2180 */  1157, 1156, 1155, 1154,  614, 1153, 1152, 1150, 1946, 1915,
 /*  2190 */  1148,  613, 1147, 1146, 1144,  662, 1143,  277, 1142, 1141,
 /*  2200 */  1140, 1139, 1138, 1137, 1173, 1946, 1171, 1134, 1133, 1130,
 /*  2210 */  1129, 1128, 1127, 1656, 1945,  683, 1654,  684, 1980, 1964,
 /*  2220 */   685,  326, 1947,  617, 1949, 1950,  612,  614,  607,  687,
 /*  2230 */   688,  689, 1915, 1652,  613,  691, 1964,  693,  692, 1650,
 /*  2240 */   695,  696,  697, 1636,  614,  699, 1080, 1616,  280, 1915,
 /*  2250 */   703,  613, 1372,  290, 1591,  706,  707, 1945, 1946, 1591,
 /*  2260 */  1591, 1980, 1591, 1591,  327, 1947,  617, 1949, 1950,  612,
 /*  2270 */  1591,  607, 1591, 1591, 1945, 1946, 1591, 1591, 1980, 1591,
 /*  2280 */  1591,  323, 1947,  617, 1949, 1950,  612, 1591,  607, 1964,
 /*  2290 */  1591, 1591, 1591, 1591, 1591, 1591, 1591,  614, 1591, 1591,
 /*  2300 */  1591, 1591, 1915, 1591,  613, 1591, 1964, 1591, 1591, 1591,
 /*  2310 */  1591, 1591, 1591, 1591,  614, 1591, 1591, 1591, 1591, 1915,
 /*  2320 */  1591,  613, 1591, 1591, 1591, 1591, 1946, 1945, 1591, 1591,
 /*  2330 */  1591, 1980, 1591, 1591,  328, 1947,  617, 1949, 1950,  612,
 /*  2340 */  1591,  607, 1591, 1591,  615, 1591, 1591, 1591, 1980, 1591,
 /*  2350 */  1591,  306, 1947,  617, 1949, 1950,  612, 1964,  607, 1591,
 /*  2360 */  1591, 1591, 1591, 1591, 1591,  614, 1591, 1591, 1591, 1591,
 /*  2370 */  1915, 1591,  613, 1591, 1591, 1591, 1591, 1591, 1591, 1591,
 /*  2380 */  1591, 1591, 1591, 1591, 1591, 1591, 1591, 1591, 1591, 1591,
 /*  2390 */  1591, 1591, 1591, 1591, 1591, 1945, 1591, 1591, 1591, 1980,
 /*  2400 */  1591, 1591,  305, 1947,  617, 1949, 1950,  612, 1591,  607,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   325,  329,  357,  331,  332,  427,  371,  416,  417,  431,
 /*    10 */   340,  356,   12,   13,   14,  345,  381,  427,  363,  384,
 /*    20 */    20,  431,   22,    0,  446,  447,  333,  372,  348,  451,
 /*    30 */   452,  356,   14,   33,  356,   35,  356,  447,   20,  364,
 /*    40 */   347,  451,  452,  385,  369,  365,  371,   24,   25,   26,
 /*    50 */    27,   28,   29,   30,   31,   32,  378,  364,   58,  349,
 /*    60 */     8,    9,  352,   63,   12,   13,   14,   15,   16,  394,
 /*    70 */    70,  356,  329,  398,  331,  332,  401,  402,  403,  404,
 /*    80 */   405,  406,  427,  408,   20,  427,  431,  372,  413,  431,
 /*    90 */   415,  325,  358,  356,  419,  420,   96,   96,  333,  325,
 /*   100 */   358,  446,  447,  369,  446,  447,  451,  452,  433,  451,
 /*   110 */   452,  369,  347,   96,  377,  378,  441,   21,  118,  354,
 /*   120 */    24,   25,   26,   27,   28,   29,   30,   31,   32,  364,
 /*   130 */   356,  397,  398,  133,  134,  369,  322,  356,  364,  397,
 /*   140 */   398,  399,  408,  369,  363,  371,   12,   13,   62,   97,
 /*   150 */   408,    4,  337,  372,   20,    0,   22,   20,   20,  325,
 /*   160 */    96,  367,  162,  163,  370,  371,  351,   33,  394,   35,
 /*   170 */   333,   20,  398,   22,  359,  401,  402,  403,  404,  405,
 /*   180 */   406,  181,  408,  183,  347,  411,   35,  413,  414,  415,
 /*   190 */   356,   58,   58,  419,  420,  370,  371,   63,  364,  385,
 /*   200 */    20,  364,   51,  369,   70,  371,  206,  207,  333,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  394,   96,
 /*   230 */    96,   98,  398,  325,  128,  401,  402,  403,  404,  405,
 /*   240 */   406,  427,  408,   96,   20,  431,  245,  413,  373,  415,
 /*   250 */     4,  339,  118,  419,  420,   12,   13,   14,   15,   16,
 /*   260 */   446,  447,  245,  108,  356,  451,  452,  133,  134,   20,
 /*   270 */   133,  134,  364,   35,  362,  441,   96,  369,   20,  371,
 /*   280 */    12,   13,  127,  128,  129,  130,  131,  132,   20,   43,
 /*   290 */    22,   45,   46,  325,  188,  189,  162,  163,  192,  333,
 /*   300 */   194,   33,  394,   35,  333,   20,  398,   22,   70,  401,
 /*   310 */   402,  403,  404,  405,  406,  181,  408,  183,  347,   96,
 /*   320 */    96,  413,   20,  415,  356,  354,   58,  419,  420,  355,
 /*   330 */   364,   63,  364,  325,   20,  364,   51,  369,   70,  371,
 /*   340 */   206,  207,  368,  209,  210,  211,  212,  213,  214,  215,
 /*   350 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   360 */   226,  227,  394,  229,   96,  325,  398,   21,   80,  401,
 /*   370 */   402,  403,  404,  405,  406,  427,  408,  369,  245,  431,
 /*   380 */    34,  413,   36,  415,  325,  337,  118,  419,  420,  423,
 /*   390 */   424,  425,  245,  427,  428,  447,  356,  431,  430,  451,
 /*   400 */   452,  133,  134,  180,  364,  182,    3,  359,  324,  369,
 /*   410 */   326,  371,  446,  447,   12,   13,   14,  451,  452,   20,
 /*   420 */   162,  163,   20,   20,   22,  245,  138,  139,  369,  330,
 /*   430 */   162,  163,  333,  334,  394,   33,  333,   35,  398,    0,
 /*   440 */   333,  401,  402,  403,  404,  405,  406,  400,  408,  181,
 /*   450 */   410,  183,  330,  325,  347,  333,  334,    8,    9,  206,
 /*   460 */    58,   12,   13,   14,   15,   16,  164,  364,  245,  245,
 /*   470 */   325,  364,   70,  426,  206,  207,  385,  209,  210,  211,
 /*   480 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   490 */   222,  223,  224,  225,  226,  227,  411,  369,   96,  414,
 /*   500 */    97,  325,   22,  167,   65,   66,   67,  254,  255,  256,
 /*   510 */   257,  258,   73,   74,  369,   35,   62,   78,  427,  325,
 /*   520 */   118,   20,  431,   84,   85,  422,  423,  424,  425,   90,
 /*   530 */   427,  428,  356,  342,  343,  133,  134,  446,  447,  127,
 /*   540 */   364,  333,  451,  452,  356,  369,   97,  371,   12,   13,
 /*   550 */    70,  363,  339,  342,  343,  347,   20,  325,   22,  333,
 /*   560 */   372,  325,  333,  369,  162,  163,  353,  164,   20,   33,
 /*   570 */   394,   35,  364,  347,  398,  362,  347,  401,  402,  403,
 /*   580 */   404,  405,  406,  181,  408,  183,  250,  251,  107,  413,
 /*   590 */   364,  415,  356,  364,   58,  419,  420,  161,  118,  364,
 /*   600 */   364,  369,  190,  191,  229,  369,   70,  371,  206,  207,
 /*   610 */   375,  209,  210,  211,  212,  213,  214,  215,  216,  217,
 /*   620 */   218,  219,  220,  221,  222,  223,  224,  225,  226,  227,
 /*   630 */   394,    4,   96,  333,  398,   44,  333,  401,  402,  403,
 /*   640 */   404,  405,  406,  333,  408,  333,   19,  347,  333,  413,
 /*   650 */   347,  415,  325,    0,  118,  419,  420,  347,  325,  347,
 /*   660 */    33,  181,  347,  183,  364,  164,  430,  364,  232,  133,
 /*   670 */   134,    0,  325,  356,  364,   48,  364,  333,  242,  364,
 /*   680 */    53,  364,   12,   13,   58,   58,  206,  207,   97,  356,
 /*   690 */    20,  347,   22,   70,   14,  333,  369,  364,  162,  163,
 /*   700 */    20,   48,  369,   33,  371,   35,    8,    9,  364,  347,
 /*   710 */    12,   13,   14,   15,   16,  348,  369,  181,   20,  183,
 /*   720 */   403,   95,   95,  356,   98,   98,  364,  394,   58,   70,
 /*   730 */   325,  398,  365,   62,  401,  402,  403,  404,  405,  406,
 /*   740 */    70,  408,  206,  207,  357,  209,  210,  211,  212,  213,
 /*   750 */   214,  215,  216,  217,  218,  219,  220,  221,  222,  223,
 /*   760 */   224,  225,  226,  227,    8,    9,   96,  325,   12,   13,
 /*   770 */    14,   15,   16,  348,  369,  442,  443,  333,  127,  128,
 /*   780 */    18,  356,   20,  132,  412,  333,  414,  108,  118,   27,
 /*   790 */   365,  347,   30,    0,  229,   33,  231,  325,  356,  347,
 /*   800 */    44,    0,  349,  133,  134,  352,  364,  108,  364,  130,
 /*   810 */    48,  369,   50,  371,   21,   53,  364,   24,   25,   26,
 /*   820 */    27,   28,   29,   30,   31,   32,  127,  128,  129,  130,
 /*   830 */   131,  132,  162,  163,  176,  333,  394,   14,   15,   16,
 /*   840 */   398,  369,  162,  401,  402,  403,  404,  405,  406,  347,
 /*   850 */   408,  181,  357,  183,  325,  197,  198,   95,    0,   14,
 /*   860 */     3,    2,  164,   62,  357,   20,  364,    8,    9,  107,
 /*   870 */   357,   12,   13,   14,   15,   16,  206,  207,  357,  209,
 /*   880 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   890 */   220,  221,  222,  223,  224,  225,  226,  227,  369,  137,
 /*   900 */    45,   46,  140,  141,  142,  143,  144,  145,  146,  147,
 /*   910 */   148,  149,  150,  151,  152,  153,  154,  155,  156,    4,
 /*   920 */   158,  159,  160,   65,   66,   67,   68,   69,  325,   71,
 /*   930 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   940 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   950 */    92,   18,  333,  325,  357,  371,   23,    8,    9,   12,
 /*   960 */    13,   12,   13,   14,   15,   16,  347,  325,  384,   22,
 /*   970 */    37,   38,  369,  333,   41,   39,   65,   66,   67,  412,
 /*   980 */    33,  414,   35,  364,   73,   74,    0,  347,  400,   78,
 /*   990 */   400,  356,   59,   60,   61,   84,   85,  369,  356,  358,
 /*  1000 */   365,   90,   37,   20,  364,   58,  364,  162,    1,    2,
 /*  1010 */   369,  369,   63,  371,  426,  325,  426,   70,  109,  110,
 /*  1020 */   111,  112,  113,  114,  115,  116,  117,  118,  119,   96,
 /*  1030 */   121,  122,  123,  124,  125,  126,  394,   44,  397,  398,
 /*  1040 */   398,   44,  325,  401,  402,  403,  404,  405,  406,  408,
 /*  1050 */   408,  389,  325,  325,  105,  413,  333,  415,    0,  369,
 /*  1060 */    33,  419,  420,   19,   99,  118,  101,  102,  135,  104,
 /*  1070 */   347,  366,  430,  108,  369,   48,  325,   33,  364,  364,
 /*  1080 */    20,   54,   55,   56,   57,   58,  369,  364,  366,  375,
 /*  1090 */   375,  369,   48,  326,  108,  130,  369,  369,   54,   55,
 /*  1100 */    56,   57,   58,  344,   97,  346,  173,  174,  175,  366,
 /*  1110 */   161,  178,  369,  127,  128,  129,  130,  131,  132,  262,
 /*  1120 */   369,   42,   95,   44,  107,   98,  243,  244,  181,  196,
 /*  1130 */   183,  345,  199,   22,  201,  202,  203,  204,  205,   95,
 /*  1140 */     0,   42,   98,   44,  379,    2,   35,  164,  333,  133,
 /*  1150 */   134,    8,    9,  206,  207,   12,   13,   14,   15,   16,
 /*  1160 */    44,  246,   22,    1,    2,  218,  219,  220,  221,  222,
 /*  1170 */   223,  224,    0,  100,  157,  131,  103,  325,  245,  364,
 /*  1180 */   244,  232,  233,  234,  235,  236,  237,  238,  239,  240,
 /*  1190 */   241,  242,  165,  166,   22,  168,    8,    9,  171,   44,
 /*  1200 */    12,   13,   14,   15,   16,  325,  100,  455,  356,  103,
 /*  1210 */   152,    0,  168,   97,  187,  100,  364,  100,  103,   35,
 /*  1220 */   103,  369,  162,  371,   58,  164,   35,  444,  335,  185,
 /*  1230 */   169,  187,   63,   22,   35,   96,  356,   44,  423,  424,
 /*  1240 */   425,  438,  427,  428,  364,  106,  394,  385,  325,  369,
 /*  1250 */   398,  371,   97,  401,  402,  403,  404,  405,  406,  266,
 /*  1260 */   408,  264,   47,   44,   98,  413,  356,  415,  379,   70,
 /*  1270 */    44,  419,  420,  335,  394,  332,  325,   44,  398,  356,
 /*  1280 */   368,  401,  402,  403,  404,  405,  406,  364,  408,  427,
 /*  1290 */    97,   44,  369,  431,  371,  415,   13,    8,    9,  419,
 /*  1300 */   420,   12,   13,   14,   15,   16,  379,  356,  446,  447,
 /*  1310 */   429,   96,  448,  451,  452,  364,   97,  394,   35,  325,
 /*  1320 */   369,  398,  371,   97,  401,  402,  403,  404,  405,  406,
 /*  1330 */    97,  408,   44,  432,   44,    0,   44,  325,  415,  421,
 /*  1340 */    13,  247,  419,  420,   97,  394,  333,   48,  396,  398,
 /*  1350 */   356,  395,  401,  402,  403,  404,  405,  406,  364,  408,
 /*  1360 */   179,  173,   35,  369,  387,  371,  415,  183,  356,   20,
 /*  1370 */   419,  420,   44,   42,  183,  206,  364,  364,  376,  379,
 /*  1380 */   325,  369,  358,  371,   49,   97,  376,   97,  394,   97,
 /*  1390 */    44,   44,  398,  369,  374,  401,  402,  403,  404,  405,
 /*  1400 */   406,  407,  408,  409,  410,  161,  394,   20,  333,  333,
 /*  1410 */   398,  356,  376,  401,  402,  403,  404,  405,  406,  364,
 /*  1420 */   408,  397,  398,  399,  369,   97,  371,   44,   44,  341,
 /*  1430 */   374,  374,  408,  325,   94,  333,  423,  424,  425,   20,
 /*  1440 */   427,  428,   20,   97,   97,  333,  333,  327,  327,  394,
 /*  1450 */   391,  371,   20,  398,  325,  267,  401,  402,  403,  404,
 /*  1460 */   405,  406,  339,  408,  356,  453,  454,  339,  334,   20,
 /*  1470 */   415,  386,  364,   52,  339,  420,  334,  369,  327,  371,
 /*  1480 */    97,   97,  333,  339,  339,  356,  339,  339,  336,  336,
 /*  1490 */   333,  369,  356,  364,  385,  369,  195,  356,  369,  186,
 /*  1500 */   371,  327,  394,  393,  337,  391,  398,  369,  325,  401,
 /*  1510 */   402,  403,  404,  405,  406,  356,  408,  356,  333,  356,
 /*  1520 */   356,  356,  390,  394,  356,  371,  356,  398,  253,  356,
 /*  1530 */   401,  402,  403,  404,  405,  406,  427,  408,  356,  356,
 /*  1540 */   431,  337,  437,  252,  369,  259,  172,  364,  369,  369,
 /*  1550 */   379,  443,  369,  260,  371,  446,  447,  379,  382,  382,
 /*  1560 */   451,  452,  325,    8,    9,  440,  439,   12,   13,   14,
 /*  1570 */    15,   16,  261,  436,  445,  268,  244,  394,  248,  325,
 /*  1580 */   456,  398,  265,  437,  401,  402,  403,  404,  405,  406,
 /*  1590 */   434,  408,  396,  356,  364,  437,  263,   20,  361,  333,
 /*  1600 */   450,  364,  400,  334,  337,  325,  369,  382,  371,  449,
 /*  1610 */   356,  369,  369,  382,  369,  361,  166,  369,  364,  369,
 /*  1620 */   369,  435,  337,  369,  352,  371,  380,  364,   96,   96,
 /*  1630 */   418,  394,  337,  325,  360,  398,  356,  454,  401,  402,
 /*  1640 */   403,  404,  405,  406,  364,  408,  369,  333,  394,  369,
 /*  1650 */   346,  371,  398,  337,   36,  401,  402,  403,  404,  405,
 /*  1660 */   406,  327,  408,  392,  356,  328,  388,  383,  350,  361,
 /*  1670 */   383,  350,  364,  350,  394,  323,  325,  369,  398,  371,
 /*  1680 */   338,  401,  402,  403,  404,  405,  406,    0,  408,    0,
 /*  1690 */   188,    0,  325,    0,   42,    0,   35,  200,   35,   35,
 /*  1700 */    35,  200,  394,    0,   35,   35,  398,  356,  200,  401,
 /*  1710 */   402,  403,  404,  405,  406,  364,  408,    0,  200,  164,
 /*  1720 */   369,    0,  371,  356,    0,   35,   22,    0,  183,   35,
 /*  1730 */   181,  364,    0,    0,  177,  385,  369,  176,  371,    0,
 /*  1740 */     0,    0,    0,  325,   47,  394,    0,   42,    0,  398,
 /*  1750 */     0,    0,  401,  402,  403,  404,  405,  406,    0,  408,
 /*  1760 */     0,  394,    0,    0,    0,  398,  152,    0,  401,  402,
 /*  1770 */   403,  404,  405,  406,  356,  408,  152,  427,   35,    0,
 /*  1780 */     0,  431,  364,    0,    0,    0,  325,  369,    0,  371,
 /*  1790 */     0,    0,    0,    0,    0,    0,  446,  447,    0,    0,
 /*  1800 */     0,  451,  452,  325,    0,    0,    0,   42,    0,    0,
 /*  1810 */     0,   22,  394,    0,    0,  136,  398,  356,    0,  401,
 /*  1820 */   402,  403,  404,  405,  406,  364,  408,    0,    0,   58,
 /*  1830 */   369,   35,  371,    0,  356,   58,    0,    0,   14,   42,
 /*  1840 */    39,    0,  364,   14,    0,    0,   44,  369,    0,  371,
 /*  1850 */    47,    0,   40,  172,   47,  394,  325,    0,   47,  398,
 /*  1860 */    39,   39,  401,  402,  403,  404,  405,  406,    0,  408,
 /*  1870 */     0,    0,  394,  325,   35,    0,  398,   39,   48,  401,
 /*  1880 */   402,  403,  404,  405,  406,   35,  408,  356,   48,   64,
 /*  1890 */     0,   39,   39,   35,   48,  364,    0,   35,   39,    0,
 /*  1900 */   369,    0,  371,   48,  356,    0,    0,   35,   22,    0,
 /*  1910 */    44,   35,  364,   35,   35,   22,   35,  369,   44,  371,
 /*  1920 */   105,    0,  103,   35,  325,  394,   35,   35,    0,  398,
 /*  1930 */    22,    0,  401,  402,  403,  404,  405,  406,   22,  408,
 /*  1940 */    22,  325,  394,    0,   50,   35,  398,   35,    0,  401,
 /*  1950 */   402,  403,  404,  405,  406,  356,  408,   35,    0,   22,
 /*  1960 */    20,   35,   35,  364,   97,  193,    0,  325,  369,   96,
 /*  1970 */   371,   35,  356,    0,   22,    0,    0,    3,   44,  249,
 /*  1980 */   364,  164,  166,   96,  325,  369,   97,  371,   44,   44,
 /*  1990 */   164,   96,    3,  394,   97,  164,   96,  398,  356,   97,
 /*  2000 */   401,  402,  403,  404,  405,  406,  364,  408,   97,   96,
 /*  2010 */   394,  369,  170,  371,  398,  356,  184,  401,  402,  403,
 /*  2020 */   404,  405,  406,  364,  408,   96,   47,   47,  369,   44,
 /*  2030 */   371,   96,   44,   35,   35,  325,  394,   35,   97,   97,
 /*  2040 */   398,   35,   35,  401,  402,  403,  404,  405,  406,   35,
 /*  2050 */   408,   97,   97,  394,   44,   47,   47,  398,    0,    0,
 /*  2060 */   401,  402,  403,  404,  405,  406,  356,  408,    0,   97,
 /*  2070 */   167,    0,  249,   96,  364,   97,   39,   96,  325,  369,
 /*  2080 */    96,  371,   96,  249,  165,   47,  243,   96,  106,   44,
 /*  2090 */   230,    2,  228,  228,  325,   22,   96,   47,   47,   22,
 /*  2100 */    97,   96,  107,  120,  394,   35,  208,   96,  398,  356,
 /*  2110 */   206,  401,  402,  403,  404,  405,  406,  364,  408,   97,
 /*  2120 */    97,   96,  369,   96,  371,  356,   97,   96,   35,   97,
 /*  2130 */    96,   35,   97,  364,   35,   96,   35,   97,  369,   96,
 /*  2140 */   371,   97,   96,   35,   97,  325,  120,  394,   96,   22,
 /*  2150 */   120,  398,   96,  120,  401,  402,  403,  404,  405,  406,
 /*  2160 */    44,  408,  108,  394,   35,   96,   22,  398,   96,   64,
 /*  2170 */   401,  402,  403,  404,  405,  406,  356,  408,   63,   70,
 /*  2180 */    35,   35,   35,   35,  364,   35,   35,   35,  325,  369,
 /*  2190 */    35,  371,   35,   35,   35,   93,   35,   44,   22,   35,
 /*  2200 */    22,   35,   35,   35,   70,  325,   35,   35,   35,   35,
 /*  2210 */    35,   22,   35,    0,  394,   35,    0,   48,  398,  356,
 /*  2220 */    39,  401,  402,  403,  404,  405,  406,  364,  408,   35,
 /*  2230 */    48,   39,  369,    0,  371,   35,  356,   39,   48,    0,
 /*  2240 */    35,   48,   39,    0,  364,   35,   35,    0,   22,  369,
 /*  2250 */    21,  371,   22,   22,  457,   21,   20,  394,  325,  457,
 /*  2260 */   457,  398,  457,  457,  401,  402,  403,  404,  405,  406,
 /*  2270 */   457,  408,  457,  457,  394,  325,  457,  457,  398,  457,
 /*  2280 */   457,  401,  402,  403,  404,  405,  406,  457,  408,  356,
 /*  2290 */   457,  457,  457,  457,  457,  457,  457,  364,  457,  457,
 /*  2300 */   457,  457,  369,  457,  371,  457,  356,  457,  457,  457,
 /*  2310 */   457,  457,  457,  457,  364,  457,  457,  457,  457,  369,
 /*  2320 */   457,  371,  457,  457,  457,  457,  325,  394,  457,  457,
 /*  2330 */   457,  398,  457,  457,  401,  402,  403,  404,  405,  406,
 /*  2340 */   457,  408,  457,  457,  394,  457,  457,  457,  398,  457,
 /*  2350 */   457,  401,  402,  403,  404,  405,  406,  356,  408,  457,
 /*  2360 */   457,  457,  457,  457,  457,  364,  457,  457,  457,  457,
 /*  2370 */   369,  457,  371,  457,  457,  457,  457,  457,  457,  457,
 /*  2380 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2390 */   457,  457,  457,  457,  457,  394,  457,  457,  457,  398,
 /*  2400 */   457,  457,  401,  402,  403,  404,  405,  406,  457,  408,
 /*  2410 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2420 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2430 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2440 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2450 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2460 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2470 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2480 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2490 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2500 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2510 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2520 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2530 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2540 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2550 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2560 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2570 */   457,  457,  457,  457,  457,  457,  457,  457,  457,
};
#define YY_SHIFT_COUNT    (708)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2247)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   933,    0,  134,    0,  268,  268,  268,  268,  268,  268,
 /*    10 */   268,  268,  268,  402,  536,  536,  670,  536,  536,  536,
 /*    20 */   536,  536,  536,  536,  536,  536,  536,  536,  536,  536,
 /*    30 */   536,  536,  536,  536,  536,  536,  536,  536,  536,  536,
 /*    40 */   536,  536,  536,  536,  536,  536,  180,  224,   64,  223,
 /*    50 */   133,    1,   17,    1,   64,   64,  947,  947,    1,  947,
 /*    60 */   947,  147,    1,  138,  138,  246,  246,  258,  137,   18,
 /*    70 */    18,  138,  138,  138,  138,  138,  138,  138,  138,  138,
 /*    80 */   138,   86,  138,  138,  249,  138,  314,  138,  138,  399,
 /*    90 */   138,  138,  399,  138,  399,  399,  399,  138,  454,  762,
 /*   100 */   949,  949,   96,  911,  480,  480,  480,  480,  480,  480,
 /*   110 */   480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
 /*   120 */   480,  480,  480,  965,  403,  258,  137,  671,  238,  302,
 /*   130 */   302,  302,  801,  565,  565,  238,  548,  548,  548,  481,
 /*   140 */   314,  375,  399,  623,  399,  623,  623,  481,  659,  909,
 /*   150 */   909,  909,  909,  909,  909,  909, 1044,  793,  439,  698,
 /*   160 */  1188,  253,  151,  336,  680,  845,  285,  501,  855,  679,
 /*   170 */   983,  883,  936,  857,  883, 1079,  915, 1060, 1094, 1299,
 /*   180 */  1181, 1331, 1349, 1331, 1244, 1387, 1387, 1331, 1244, 1244,
 /*   190 */  1340, 1387, 1387, 1387, 1419, 1419, 1422,   86,  314,   86,
 /*   200 */  1432, 1449,   86, 1432,   86,   86,   86, 1387,   86, 1421,
 /*   210 */  1421, 1419,  399,  399,  399,  399,  399,  399,  399,  399,
 /*   220 */   399,  399,  399, 1387, 1419,  623,  623, 1301, 1422,  454,
 /*   230 */  1313,  314,  454, 1387, 1349, 1349,  623, 1275, 1291,  623,
 /*   240 */  1275, 1291,  623,  623,  399, 1286, 1374, 1275, 1311, 1293,
 /*   250 */  1330, 1094, 1307, 1317, 1333, 1332,  548, 1577, 1387, 1432,
 /*   260 */   454, 1291,  623,  623,  623,  623,  623, 1291,  623, 1450,
 /*   270 */   454,  481,  454,  548, 1532, 1533,  623,  659, 1387,  454,
 /*   280 */  1618, 1419, 2410, 2410, 2410, 2410, 2410, 2410, 2410, 2410,
 /*   290 */  2410,  858, 1027,   23,  627,   52,  756,  449,  155,  859,
 /*   300 */  1143, 1555,  986, 1289, 1289, 1289, 1289, 1289, 1289, 1289,
 /*   310 */  1289, 1289,  699,  106,  243,  243,  658,  626,  288,  346,
 /*   320 */   412,  651,  651,  823, 1007,  436,  823,  823,  823,  591,
 /*   330 */   653, 1111, 1099, 1017, 1058, 1073, 1106, 1115, 1117, 1140,
 /*   340 */  1172, 1211, 1166, 1116, 1155, 1016,  997,  993, 1061, 1193,
 /*   350 */  1219, 1226, 1247, 1288, 1162, 1290, 1184, 1191, 1169, 1233,
 /*   360 */  1215, 1292, 1328, 1346, 1347, 1383, 1384, 1139, 1283, 1327,
 /*   370 */  1199, 1335, 1687, 1689, 1502, 1691, 1693, 1652, 1695, 1661,
 /*   380 */  1497, 1663, 1664, 1665, 1501, 1703, 1669, 1670, 1508, 1717,
 /*   390 */  1518, 1721, 1690, 1724, 1704, 1727, 1694, 1545, 1549, 1732,
 /*   400 */  1733, 1557, 1561, 1739, 1740, 1697, 1741, 1742, 1746, 1705,
 /*   410 */  1748, 1750, 1751, 1758, 1760, 1762, 1763, 1764, 1614, 1743,
 /*   420 */  1767, 1624, 1779, 1780, 1783, 1784, 1785, 1788, 1790, 1791,
 /*   430 */  1792, 1793, 1794, 1795, 1798, 1799, 1800, 1765, 1804, 1805,
 /*   440 */  1806, 1808, 1809, 1789, 1810, 1813, 1814, 1679, 1818, 1827,
 /*   450 */  1796, 1828, 1771, 1833, 1777, 1836, 1837, 1797, 1801, 1802,
 /*   460 */  1803, 1824, 1807, 1829, 1811, 1841, 1812, 1821, 1844, 1845,
 /*   470 */  1848, 1822, 1681, 1851, 1857, 1868, 1825, 1870, 1871, 1839,
 /*   480 */  1830, 1838, 1875, 1850, 1840, 1852, 1890, 1858, 1846, 1853,
 /*   490 */  1896, 1862, 1855, 1859, 1899, 1901, 1905, 1906, 1815, 1819,
 /*   500 */  1872, 1886, 1909, 1876, 1878, 1879, 1881, 1866, 1874, 1888,
 /*   510 */  1891, 1893, 1892, 1921, 1908, 1928, 1916, 1894, 1931, 1918,
 /*   520 */  1910, 1943, 1912, 1948, 1922, 1958, 1937, 1940, 1926, 1927,
 /*   530 */  1772, 1867, 1873, 1966, 1817, 1936, 1973, 1832, 1952, 1826,
 /*   540 */  1816, 1975, 1976, 1831, 1842, 1974, 1934, 1730, 1887, 1889,
 /*   550 */  1895, 1897, 1944, 1902, 1900, 1913, 1929, 1911, 1945, 1979,
 /*   560 */  1980, 1935, 1985, 1823, 1941, 1942, 1989, 1988, 1834, 1998,
 /*   570 */  1999, 2002, 2006, 2007, 2014, 1954, 1955, 2008, 1843, 2010,
 /*   580 */  2009, 2058, 2059, 2068, 1977, 1972, 1978, 1981, 1984, 1903,
 /*   590 */  1986, 2071, 2037, 1919, 1991, 1982, 1803, 2038, 2045, 1864,
 /*   600 */  1860, 1865, 2089, 2073, 1904, 2000, 2003, 2005, 2022, 2011,
 /*   610 */  2023, 2050, 2025, 2027, 2051, 2029, 2077, 1898, 2031, 1995,
 /*   620 */  2032, 2070, 2093, 2034, 2035, 2096, 2039, 2040, 2099, 2043,
 /*   630 */  2044, 2101, 2046, 2047, 2108, 2052, 1983, 2026, 2030, 2033,
 /*   640 */  2127, 2054, 2056, 2116, 2069, 2129, 2072, 2116, 2116, 2144,
 /*   650 */  2105, 2115, 2145, 2146, 2147, 2148, 2150, 2151, 2152, 2155,
 /*   660 */  2157, 2158, 2109, 2102, 2153, 2159, 2161, 2176, 2164, 2178,
 /*   670 */  2166, 2167, 2168, 2134, 1866, 2171, 1874, 2172, 2173, 2174,
 /*   680 */  2175, 2189, 2177, 2213, 2180, 2169, 2181, 2216, 2194, 2182,
 /*   690 */  2192, 2233, 2200, 2190, 2198, 2239, 2205, 2193, 2203, 2243,
 /*   700 */  2210, 2211, 2247, 2226, 2229, 2230, 2231, 2234, 2236,
};
#define YY_REDUCE_COUNT (290)
#define YY_REDUCE_MIN   (-422)
#define YY_REDUCE_MAX   (2001)
static const short yy_reduce_ofst[] = {
 /*     0 */  -186, -325, -226, -166,  -32,  236,  642,  -92,  176,  852,
 /*    10 */   880,  923,  951,  994,  333, 1012, 1055, 1108, 1129, 1183,
 /*    20 */  1237,   40, 1254, 1308,  442, 1280, 1351, 1367, 1418, 1461,
 /*    30 */  1478, 1531, 1548, 1599, 1616, 1642, 1659, 1710, 1753, 1769,
 /*    40 */  1820, 1863, 1880, 1933, 1950, 2001,  -34, -345,  103, -342,
 /*    50 */    91,  862, 1109, 1350,  815, 1013, -258, 1024, -422, -266,
 /*    60 */   641, -410,  -52, -235,  -29, -328, -257, -263, -206,   99,
 /*    70 */   122, -307, -163,  107,  208,  226,  229,  300,  303,  310,
 /*    80 */   312,  213,  315,  344,  317,  362, -365,  444,  452, -320,
 /*    90 */   502,  619, -219,  640,  367,  188,  425,  723, -185, -125,
 /*   100 */  -409, -409,   84, -330, -234,    8,   59,  128,  145,  194,
 /*   110 */   232,  327,  347,  405,  472,  529,  603,  628,  690,  717,
 /*   120 */   727,  728,  751,  -26,   47, -322, -175,  -88,  191,   47,
 /*   130 */   588,  590,   48,  372,  567,  211,  235,  714,  715, -290,
 /*   140 */   584,   85,  635,  705, -285,  722,  743,  453,  759, -355,
 /*   150 */   387,  495,  507,  513,  521,  597,  662,  767,  786,  765,
 /*   160 */   752,  783,  893,  803,  910,  910,  938,  889,  943,  912,
 /*   170 */   927,  881,  881,  864,  881,  918,  901,  910,  952,  956,
 /*   180 */   977, 1002, 1000, 1010, 1020, 1075, 1076, 1036, 1056, 1057,
 /*   190 */  1088, 1102, 1112, 1113, 1120, 1121, 1059, 1123, 1080, 1128,
 /*   200 */  1134, 1085, 1135, 1142, 1144, 1145, 1147, 1149, 1148, 1152,
 /*   210 */  1153, 1151, 1136, 1141, 1159, 1161, 1163, 1164, 1165, 1168,
 /*   220 */  1170, 1173, 1182, 1157, 1174, 1122, 1126, 1110, 1114, 1167,
 /*   230 */  1132, 1154, 1204, 1185, 1171, 1178, 1138, 1105, 1176, 1175,
 /*   240 */  1146, 1177, 1179, 1180,  910, 1125, 1127, 1158, 1137, 1186,
 /*   250 */  1156, 1196, 1124, 1150, 1160,  881, 1230, 1202, 1266, 1269,
 /*   260 */  1267, 1225, 1242, 1243, 1245, 1248, 1250, 1231, 1251, 1246,
 /*   270 */  1285, 1272, 1295, 1263, 1212, 1274, 1277, 1304, 1314, 1316,
 /*   280 */  1337, 1334, 1278, 1271, 1284, 1287, 1318, 1321, 1323, 1342,
 /*   290 */  1352,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*    10 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*    20 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*    30 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*    40 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*    50 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*    60 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1845, 1589, 1589,
 /*    70 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*    80 */  1589, 1667, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*    90 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1665, 1838,
 /*   100 */  2035, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   110 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   120 */  1589, 1589, 1589, 1589, 2047, 1589, 1589, 1667, 1589, 2047,
 /*   130 */  2047, 2047, 1665, 2007, 2007, 1589, 1589, 1589, 1589, 1775,
 /*   140 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1775, 1589, 1589,
 /*   150 */  1589, 1589, 1589, 1589, 1589, 1589, 1882, 1589, 1589, 2072,
 /*   160 */  2125, 1589, 1589, 2075, 1589, 1589, 1589, 1850, 1589, 1728,
 /*   170 */  2062, 2039, 2053, 2109, 2040, 2037, 2056, 1589, 2066, 1589,
 /*   180 */  1875, 1843, 1589, 1843, 1840, 1589, 1589, 1843, 1840, 1840,
 /*   190 */  1719, 1589, 1589, 1589, 1589, 1589, 1589, 1667, 1589, 1667,
 /*   200 */  1589, 1589, 1667, 1589, 1667, 1667, 1667, 1589, 1667, 1646,
 /*   210 */  1646, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   220 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1895, 1589, 1665,
 /*   230 */  1884, 1589, 1665, 1589, 1589, 1589, 1589, 2082, 2080, 1589,
 /*   240 */  2082, 2080, 1589, 1589, 1589, 2094, 2090, 2082, 2098, 2096,
 /*   250 */  2068, 2066, 2128, 2115, 2111, 2053, 1589, 1589, 1589, 1589,
 /*   260 */  1665, 2080, 1589, 1589, 1589, 1589, 1589, 2080, 1589, 1589,
 /*   270 */  1665, 1589, 1665, 1589, 1589, 1744, 1589, 1589, 1589, 1665,
 /*   280 */  1621, 1589, 1877, 1888, 1860, 1860, 1778, 1778, 1778, 1668,
 /*   290 */  1594, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   300 */  1589, 1589, 1589, 2093, 2092, 1963, 1589, 2011, 2010, 2009,
 /*   310 */  2000, 1962, 1740, 1589, 1961, 1960, 1589, 1589, 1589, 1589,
 /*   320 */  1589, 1856, 1855, 1954, 1589, 1589, 1955, 1953, 1952, 1589,
 /*   330 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   340 */  1589, 1589, 1589, 1589, 1589, 1589, 2112, 2116, 1589, 1589,
 /*   350 */  1589, 1589, 1589, 1589, 2036, 1589, 1589, 1589, 1589, 1589,
 /*   360 */  1937, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   370 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   380 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   390 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   400 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   410 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   420 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   430 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   440 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   450 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1626,
 /*   460 */  1942, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   470 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   480 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   490 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   500 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1707, 1706, 1589,
 /*   510 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   520 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   530 */  1589, 1945, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   540 */  1589, 1589, 1589, 1589, 1589, 2108, 2069, 1589, 1589, 1589,
 /*   550 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   560 */  1937, 1589, 2091, 1589, 1589, 2106, 1589, 2110, 1589, 1589,
 /*   570 */  1589, 1589, 1589, 1589, 1589, 2046, 2042, 1589, 1589, 2038,
 /*   580 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   590 */  1589, 1589, 1589, 1589, 1589, 1589, 1936, 1589, 1997, 1589,
 /*   600 */  1589, 1589, 2031, 1589, 1589, 1982, 1589, 1589, 1589, 1589,
 /*   610 */  1589, 1589, 1589, 1589, 1589, 1945, 1589, 1948, 1589, 1589,
 /*   620 */  1589, 1589, 1589, 1772, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   630 */  1589, 1589, 1589, 1589, 1589, 1589, 1757, 1755, 1754, 1753,
 /*   640 */  1589, 1750, 1589, 1785, 1589, 1589, 1589, 1781, 1780, 1589,
 /*   650 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   660 */  1589, 1589, 1589, 1589, 1687, 1589, 1589, 1589, 1589, 1589,
 /*   670 */  1589, 1589, 1589, 1589, 1678, 1589, 1677, 1589, 1589, 1589,
 /*   680 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   690 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*   700 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  269,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  269,  /*      AFTER => ABORT */
  269,  /*     ATTACH => ABORT */
  269,  /*     BEFORE => ABORT */
  269,  /*      BEGIN => ABORT */
  269,  /*     BITAND => ABORT */
  269,  /*     BITNOT => ABORT */
  269,  /*      BITOR => ABORT */
  269,  /*     BLOCKS => ABORT */
  269,  /*     CHANGE => ABORT */
  269,  /*      COMMA => ABORT */
  269,  /*    COMPACT => ABORT */
  269,  /*     CONCAT => ABORT */
  269,  /*   CONFLICT => ABORT */
  269,  /*       COPY => ABORT */
  269,  /*   DEFERRED => ABORT */
  269,  /* DELIMITERS => ABORT */
  269,  /*     DETACH => ABORT */
  269,  /*     DIVIDE => ABORT */
  269,  /*        DOT => ABORT */
  269,  /*       EACH => ABORT */
  269,  /*       FAIL => ABORT */
  269,  /*       FILE => ABORT */
  269,  /*        FOR => ABORT */
  269,  /*       GLOB => ABORT */
  269,  /*         ID => ABORT */
  269,  /*  IMMEDIATE => ABORT */
  269,  /*     IMPORT => ABORT */
  269,  /*  INITIALLY => ABORT */
  269,  /*    INSTEAD => ABORT */
  269,  /*     ISNULL => ABORT */
  269,  /*        KEY => ABORT */
  269,  /*    MODULES => ABORT */
  269,  /*  NK_BITNOT => ABORT */
  269,  /*    NK_SEMI => ABORT */
  269,  /*    NOTNULL => ABORT */
  269,  /*         OF => ABORT */
  269,  /*       PLUS => ABORT */
  269,  /*  PRIVILEGE => ABORT */
  269,  /*      RAISE => ABORT */
  269,  /*    REPLACE => ABORT */
  269,  /*   RESTRICT => ABORT */
  269,  /*        ROW => ABORT */
  269,  /*       SEMI => ABORT */
  269,  /*       STAR => ABORT */
  269,  /*  STATEMENT => ABORT */
  269,  /*     STRING => ABORT */
  269,  /*      TIMES => ABORT */
  269,  /*     UPDATE => ABORT */
  269,  /*     VALUES => ABORT */
  269,  /*   VARIABLE => ABORT */
  269,  /*       VIEW => ABORT */
  269,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "IF",
  /*   63 */ "NOT",
  /*   64 */ "EXISTS",
  /*   65 */ "BUFFER",
  /*   66 */ "CACHEMODEL",
  /*   67 */ "CACHESIZE",
  /*   68 */ "COMP",
  /*   69 */ "DURATION",
  /*   70 */ "NK_VARIABLE",
  /*   71 */ "MAXROWS",
  /*   72 */ "MINROWS",
  /*   73 */ "KEEP",
  /*   74 */ "PAGES",
  /*   75 */ "PAGESIZE",
  /*   76 */ "TSDB_PAGESIZE",
  /*   77 */ "PRECISION",
  /*   78 */ "REPLICA",
  /*   79 */ "STRICT",
  /*   80 */ "VGROUPS",
  /*   81 */ "SINGLE_STABLE",
  /*   82 */ "RETENTIONS",
  /*   83 */ "SCHEMALESS",
  /*   84 */ "WAL_LEVEL",
  /*   85 */ "WAL_FSYNC_PERIOD",
  /*   86 */ "WAL_RETENTION_PERIOD",
  /*   87 */ "WAL_RETENTION_SIZE",
  /*   88 */ "WAL_ROLL_PERIOD",
  /*   89 */ "WAL_SEGMENT_SIZE",
  /*   90 */ "STT_TRIGGER",
  /*   91 */ "TABLE_PREFIX",
  /*   92 */ "TABLE_SUFFIX",
  /*   93 */ "NK_COLON",
  /*   94 */ "MAX_SPEED",
  /*   95 */ "TABLE",
  /*   96 */ "NK_LP",
  /*   97 */ "NK_RP",
  /*   98 */ "STABLE",
  /*   99 */ "ADD",
  /*  100 */ "COLUMN",
  /*  101 */ "MODIFY",
  /*  102 */ "RENAME",
  /*  103 */ "TAG",
  /*  104 */ "SET",
  /*  105 */ "NK_EQ",
  /*  106 */ "USING",
  /*  107 */ "TAGS",
  /*  108 */ "COMMENT",
  /*  109 */ "BOOL",
  /*  110 */ "TINYINT",
  /*  111 */ "SMALLINT",
  /*  112 */ "INT",
  /*  113 */ "INTEGER",
  /*  114 */ "BIGINT",
  /*  115 */ "FLOAT",
  /*  116 */ "DOUBLE",
  /*  117 */ "BINARY",
  /*  118 */ "TIMESTAMP",
  /*  119 */ "NCHAR",
  /*  120 */ "UNSIGNED",
  /*  121 */ "JSON",
  /*  122 */ "VARCHAR",
  /*  123 */ "MEDIUMBLOB",
  /*  124 */ "BLOB",
  /*  125 */ "VARBINARY",
  /*  126 */ "DECIMAL",
  /*  127 */ "MAX_DELAY",
  /*  128 */ "WATERMARK",
  /*  129 */ "ROLLUP",
  /*  130 */ "TTL",
  /*  131 */ "SMA",
  /*  132 */ "DELETE_MARK",
  /*  133 */ "FIRST",
  /*  134 */ "LAST",
  /*  135 */ "SHOW",
  /*  136 */ "PRIVILEGES",
  /*  137 */ "DATABASES",
  /*  138 */ "TABLES",
  /*  139 */ "STABLES",
  /*  140 */ "MNODES",
  /*  141 */ "QNODES",
  /*  142 */ "FUNCTIONS",
  /*  143 */ "INDEXES",
  /*  144 */ "ACCOUNTS",
  /*  145 */ "APPS",
  /*  146 */ "CONNECTIONS",
  /*  147 */ "LICENCES",
  /*  148 */ "GRANTS",
  /*  149 */ "QUERIES",
  /*  150 */ "SCORES",
  /*  151 */ "TOPICS",
  /*  152 */ "VARIABLES",
  /*  153 */ "CLUSTER",
  /*  154 */ "BNODES",
  /*  155 */ "SNODES",
  /*  156 */ "TRANSACTIONS",
  /*  157 */ "DISTRIBUTED",
  /*  158 */ "CONSUMERS",
  /*  159 */ "SUBSCRIPTIONS",
  /*  160 */ "VNODES",
  /*  161 */ "LIKE",
  /*  162 */ "TBNAME",
  /*  163 */ "QTAGS",
  /*  164 */ "AS",
  /*  165 */ "INDEX",
  /*  166 */ "FUNCTION",
  /*  167 */ "INTERVAL",
  /*  168 */ "TOPIC",
  /*  169 */ "WITH",
  /*  170 */ "META",
  /*  171 */ "CONSUMER",
  /*  172 */ "GROUP",
  /*  173 */ "DESC",
  /*  174 */ "DESCRIBE",
  /*  175 */ "RESET",
  /*  176 */ "QUERY",
  /*  177 */ "CACHE",
  /*  178 */ "EXPLAIN",
  /*  179 */ "ANALYZE",
  /*  180 */ "VERBOSE",
  /*  181 */ "NK_BOOL",
  /*  182 */ "RATIO",
  /*  183 */ "NK_FLOAT",
  /*  184 */ "OUTPUTTYPE",
  /*  185 */ "AGGREGATE",
  /*  186 */ "BUFSIZE",
  /*  187 */ "STREAM",
  /*  188 */ "INTO",
  /*  189 */ "TRIGGER",
  /*  190 */ "AT_ONCE",
  /*  191 */ "WINDOW_CLOSE",
  /*  192 */ "IGNORE",
  /*  193 */ "EXPIRED",
  /*  194 */ "FILL_HISTORY",
  /*  195 */ "SUBTABLE",
  /*  196 */ "KILL",
  /*  197 */ "CONNECTION",
  /*  198 */ "TRANSACTION",
  /*  199 */ "BALANCE",
  /*  200 */ "VGROUP",
  /*  201 */ "MERGE",
  /*  202 */ "REDISTRIBUTE",
  /*  203 */ "SPLIT",
  /*  204 */ "DELETE",
  /*  205 */ "INSERT",
  /*  206 */ "NULL",
  /*  207 */ "NK_QUESTION",
  /*  208 */ "NK_ARROW",
  /*  209 */ "ROWTS",
  /*  210 */ "QSTART",
  /*  211 */ "QEND",
  /*  212 */ "QDURATION",
  /*  213 */ "WSTART",
  /*  214 */ "WEND",
  /*  215 */ "WDURATION",
  /*  216 */ "IROWTS",
  /*  217 */ "CAST",
  /*  218 */ "NOW",
  /*  219 */ "TODAY",
  /*  220 */ "TIMEZONE",
  /*  221 */ "CLIENT_VERSION",
  /*  222 */ "SERVER_VERSION",
  /*  223 */ "SERVER_STATUS",
  /*  224 */ "CURRENT_USER",
  /*  225 */ "COUNT",
  /*  226 */ "LAST_ROW",
  /*  227 */ "CASE",
  /*  228 */ "END",
  /*  229 */ "WHEN",
  /*  230 */ "THEN",
  /*  231 */ "ELSE",
  /*  232 */ "BETWEEN",
  /*  233 */ "IS",
  /*  234 */ "NK_LT",
  /*  235 */ "NK_GT",
  /*  236 */ "NK_LE",
  /*  237 */ "NK_GE",
  /*  238 */ "NK_NE",
  /*  239 */ "MATCH",
  /*  240 */ "NMATCH",
  /*  241 */ "CONTAINS",
  /*  242 */ "IN",
  /*  243 */ "JOIN",
  /*  244 */ "INNER",
  /*  245 */ "SELECT",
  /*  246 */ "DISTINCT",
  /*  247 */ "WHERE",
  /*  248 */ "PARTITION",
  /*  249 */ "BY",
  /*  250 */ "SESSION",
  /*  251 */ "STATE_WINDOW",
  /*  252 */ "SLIDING",
  /*  253 */ "FILL",
  /*  254 */ "VALUE",
  /*  255 */ "NONE",
  /*  256 */ "PREV",
  /*  257 */ "LINEAR",
  /*  258 */ "NEXT",
  /*  259 */ "HAVING",
  /*  260 */ "RANGE",
  /*  261 */ "EVERY",
  /*  262 */ "ORDER",
  /*  263 */ "SLIMIT",
  /*  264 */ "SOFFSET",
  /*  265 */ "LIMIT",
  /*  266 */ "OFFSET",
  /*  267 */ "ASC",
  /*  268 */ "NULLS",
  /*  269 */ "ABORT",
  /*  270 */ "AFTER",
  /*  271 */ "ATTACH",
  /*  272 */ "BEFORE",
  /*  273 */ "BEGIN",
  /*  274 */ "BITAND",
  /*  275 */ "BITNOT",
  /*  276 */ "BITOR",
  /*  277 */ "BLOCKS",
  /*  278 */ "CHANGE",
  /*  279 */ "COMMA",
  /*  280 */ "COMPACT",
  /*  281 */ "CONCAT",
  /*  282 */ "CONFLICT",
  /*  283 */ "COPY",
  /*  284 */ "DEFERRED",
  /*  285 */ "DELIMITERS",
  /*  286 */ "DETACH",
  /*  287 */ "DIVIDE",
  /*  288 */ "DOT",
  /*  289 */ "EACH",
  /*  290 */ "FAIL",
  /*  291 */ "FILE",
  /*  292 */ "FOR",
  /*  293 */ "GLOB",
  /*  294 */ "ID",
  /*  295 */ "IMMEDIATE",
  /*  296 */ "IMPORT",
  /*  297 */ "INITIALLY",
  /*  298 */ "INSTEAD",
  /*  299 */ "ISNULL",
  /*  300 */ "KEY",
  /*  301 */ "MODULES",
  /*  302 */ "NK_BITNOT",
  /*  303 */ "NK_SEMI",
  /*  304 */ "NOTNULL",
  /*  305 */ "OF",
  /*  306 */ "PLUS",
  /*  307 */ "PRIVILEGE",
  /*  308 */ "RAISE",
  /*  309 */ "REPLACE",
  /*  310 */ "RESTRICT",
  /*  311 */ "ROW",
  /*  312 */ "SEMI",
  /*  313 */ "STAR",
  /*  314 */ "STATEMENT",
  /*  315 */ "STRING",
  /*  316 */ "TIMES",
  /*  317 */ "UPDATE",
  /*  318 */ "VALUES",
  /*  319 */ "VARIABLE",
  /*  320 */ "VIEW",
  /*  321 */ "WAL",
  /*  322 */ "cmd",
  /*  323 */ "account_options",
  /*  324 */ "alter_account_options",
  /*  325 */ "literal",
  /*  326 */ "alter_account_option",
  /*  327 */ "user_name",
  /*  328 */ "sysinfo_opt",
  /*  329 */ "privileges",
  /*  330 */ "priv_level",
  /*  331 */ "priv_type_list",
  /*  332 */ "priv_type",
  /*  333 */ "db_name",
  /*  334 */ "topic_name",
  /*  335 */ "dnode_endpoint",
  /*  336 */ "force_opt",
  /*  337 */ "not_exists_opt",
  /*  338 */ "db_options",
  /*  339 */ "exists_opt",
  /*  340 */ "alter_db_options",
  /*  341 */ "speed_opt",
  /*  342 */ "integer_list",
  /*  343 */ "variable_list",
  /*  344 */ "retention_list",
  /*  345 */ "alter_db_option",
  /*  346 */ "retention",
  /*  347 */ "full_table_name",
  /*  348 */ "column_def_list",
  /*  349 */ "tags_def_opt",
  /*  350 */ "table_options",
  /*  351 */ "multi_create_clause",
  /*  352 */ "tags_def",
  /*  353 */ "multi_drop_clause",
  /*  354 */ "alter_table_clause",
  /*  355 */ "alter_table_options",
  /*  356 */ "column_name",
  /*  357 */ "type_name",
  /*  358 */ "signed_literal",
  /*  359 */ "create_subtable_clause",
  /*  360 */ "specific_cols_opt",
  /*  361 */ "expression_list",
  /*  362 */ "drop_table_clause",
  /*  363 */ "col_name_list",
  /*  364 */ "table_name",
  /*  365 */ "column_def",
  /*  366 */ "duration_list",
  /*  367 */ "rollup_func_list",
  /*  368 */ "alter_table_option",
  /*  369 */ "duration_literal",
  /*  370 */ "rollup_func_name",
  /*  371 */ "function_name",
  /*  372 */ "col_name",
  /*  373 */ "db_name_cond_opt",
  /*  374 */ "like_pattern_opt",
  /*  375 */ "table_name_cond",
  /*  376 */ "from_db_opt",
  /*  377 */ "tag_list_opt",
  /*  378 */ "tag_item",
  /*  379 */ "column_alias",
  /*  380 */ "index_options",
  /*  381 */ "func_list",
  /*  382 */ "sliding_opt",
  /*  383 */ "sma_stream_opt",
  /*  384 */ "func",
  /*  385 */ "query_or_subquery",
  /*  386 */ "cgroup_name",
  /*  387 */ "analyze_opt",
  /*  388 */ "explain_options",
  /*  389 */ "agg_func_opt",
  /*  390 */ "bufsize_opt",
  /*  391 */ "stream_name",
  /*  392 */ "stream_options",
  /*  393 */ "subtable_opt",
  /*  394 */ "expression",
  /*  395 */ "dnode_list",
  /*  396 */ "where_clause_opt",
  /*  397 */ "signed",
  /*  398 */ "literal_func",
  /*  399 */ "literal_list",
  /*  400 */ "table_alias",
  /*  401 */ "expr_or_subquery",
  /*  402 */ "pseudo_column",
  /*  403 */ "column_reference",
  /*  404 */ "function_expression",
  /*  405 */ "case_when_expression",
  /*  406 */ "star_func",
  /*  407 */ "star_func_para_list",
  /*  408 */ "noarg_func",
  /*  409 */ "other_para_list",
  /*  410 */ "star_func_para",
  /*  411 */ "when_then_list",
  /*  412 */ "case_when_else_opt",
  /*  413 */ "common_expression",
  /*  414 */ "when_then_expr",
  /*  415 */ "predicate",
  /*  416 */ "compare_op",
  /*  417 */ "in_op",
  /*  418 */ "in_predicate_value",
  /*  419 */ "boolean_value_expression",
  /*  420 */ "boolean_primary",
  /*  421 */ "from_clause_opt",
  /*  422 */ "table_reference_list",
  /*  423 */ "table_reference",
  /*  424 */ "table_primary",
  /*  425 */ "joined_table",
  /*  426 */ "alias_opt",
  /*  427 */ "subquery",
  /*  428 */ "parenthesized_joined_table",
  /*  429 */ "join_type",
  /*  430 */ "search_condition",
  /*  431 */ "query_specification",
  /*  432 */ "set_quantifier_opt",
  /*  433 */ "select_list",
  /*  434 */ "partition_by_clause_opt",
  /*  435 */ "range_opt",
  /*  436 */ "every_opt",
  /*  437 */ "fill_opt",
  /*  438 */ "twindow_clause_opt",
  /*  439 */ "group_by_clause_opt",
  /*  440 */ "having_clause_opt",
  /*  441 */ "select_item",
  /*  442 */ "partition_list",
  /*  443 */ "partition_item",
  /*  444 */ "fill_mode",
  /*  445 */ "group_by_list",
  /*  446 */ "query_expression",
  /*  447 */ "query_simple",
  /*  448 */ "order_by_clause_opt",
  /*  449 */ "slimit_clause_opt",
  /*  450 */ "limit_clause_opt",
  /*  451 */ "union_query_expression",
  /*  452 */ "query_simple_or_subquery",
  /*  453 */ "sort_specification_list",
  /*  454 */ "sort_specification",
  /*  455 */ "ordering_specification_opt",
  /*  456 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  73 */ "not_exists_opt ::=",
 /*  74 */ "exists_opt ::= IF EXISTS",
 /*  75 */ "exists_opt ::=",
 /*  76 */ "db_options ::=",
 /*  77 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  78 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  79 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  81 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  83 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  84 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options KEEP integer_list",
 /*  86 */ "db_options ::= db_options KEEP variable_list",
 /*  87 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  88 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  89 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  91 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  92 */ "db_options ::= db_options STRICT NK_STRING",
 /*  93 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  94 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  95 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  96 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 107 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 108 */ "alter_db_options ::= alter_db_option",
 /* 109 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 110 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 111 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 112 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 114 */ "alter_db_option ::= KEEP integer_list",
 /* 115 */ "alter_db_option ::= KEEP variable_list",
 /* 116 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 117 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 118 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 119 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 120 */ "integer_list ::= NK_INTEGER",
 /* 121 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 122 */ "variable_list ::= NK_VARIABLE",
 /* 123 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 124 */ "retention_list ::= retention",
 /* 125 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 126 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 127 */ "speed_opt ::=",
 /* 128 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 129 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 130 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 131 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 132 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 133 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 134 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 135 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 136 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 137 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 138 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 139 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 140 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 141 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 142 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 143 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 144 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 145 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 146 */ "multi_create_clause ::= create_subtable_clause",
 /* 147 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 148 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 149 */ "multi_drop_clause ::= drop_table_clause",
 /* 150 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 151 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 152 */ "specific_cols_opt ::=",
 /* 153 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 154 */ "full_table_name ::= table_name",
 /* 155 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 156 */ "column_def_list ::= column_def",
 /* 157 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 158 */ "column_def ::= column_name type_name",
 /* 159 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 160 */ "type_name ::= BOOL",
 /* 161 */ "type_name ::= TINYINT",
 /* 162 */ "type_name ::= SMALLINT",
 /* 163 */ "type_name ::= INT",
 /* 164 */ "type_name ::= INTEGER",
 /* 165 */ "type_name ::= BIGINT",
 /* 166 */ "type_name ::= FLOAT",
 /* 167 */ "type_name ::= DOUBLE",
 /* 168 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 169 */ "type_name ::= TIMESTAMP",
 /* 170 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 171 */ "type_name ::= TINYINT UNSIGNED",
 /* 172 */ "type_name ::= SMALLINT UNSIGNED",
 /* 173 */ "type_name ::= INT UNSIGNED",
 /* 174 */ "type_name ::= BIGINT UNSIGNED",
 /* 175 */ "type_name ::= JSON",
 /* 176 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 177 */ "type_name ::= MEDIUMBLOB",
 /* 178 */ "type_name ::= BLOB",
 /* 179 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 180 */ "type_name ::= DECIMAL",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 182 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 183 */ "tags_def_opt ::=",
 /* 184 */ "tags_def_opt ::= tags_def",
 /* 185 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 186 */ "table_options ::=",
 /* 187 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 188 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 189 */ "table_options ::= table_options WATERMARK duration_list",
 /* 190 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 191 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 192 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 193 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 194 */ "alter_table_options ::= alter_table_option",
 /* 195 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 196 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 197 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 198 */ "duration_list ::= duration_literal",
 /* 199 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 200 */ "rollup_func_list ::= rollup_func_name",
 /* 201 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 202 */ "rollup_func_name ::= function_name",
 /* 203 */ "rollup_func_name ::= FIRST",
 /* 204 */ "rollup_func_name ::= LAST",
 /* 205 */ "col_name_list ::= col_name",
 /* 206 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 207 */ "col_name ::= column_name",
 /* 208 */ "cmd ::= SHOW DNODES",
 /* 209 */ "cmd ::= SHOW USERS",
 /* 210 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 211 */ "cmd ::= SHOW DATABASES",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 214 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 215 */ "cmd ::= SHOW MNODES",
 /* 216 */ "cmd ::= SHOW QNODES",
 /* 217 */ "cmd ::= SHOW FUNCTIONS",
 /* 218 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 219 */ "cmd ::= SHOW STREAMS",
 /* 220 */ "cmd ::= SHOW ACCOUNTS",
 /* 221 */ "cmd ::= SHOW APPS",
 /* 222 */ "cmd ::= SHOW CONNECTIONS",
 /* 223 */ "cmd ::= SHOW LICENCES",
 /* 224 */ "cmd ::= SHOW GRANTS",
 /* 225 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 226 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 227 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 228 */ "cmd ::= SHOW QUERIES",
 /* 229 */ "cmd ::= SHOW SCORES",
 /* 230 */ "cmd ::= SHOW TOPICS",
 /* 231 */ "cmd ::= SHOW VARIABLES",
 /* 232 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 233 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 234 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 235 */ "cmd ::= SHOW BNODES",
 /* 236 */ "cmd ::= SHOW SNODES",
 /* 237 */ "cmd ::= SHOW CLUSTER",
 /* 238 */ "cmd ::= SHOW TRANSACTIONS",
 /* 239 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 240 */ "cmd ::= SHOW CONSUMERS",
 /* 241 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 242 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 244 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 245 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 246 */ "db_name_cond_opt ::=",
 /* 247 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 248 */ "like_pattern_opt ::=",
 /* 249 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 250 */ "table_name_cond ::= table_name",
 /* 251 */ "from_db_opt ::=",
 /* 252 */ "from_db_opt ::= FROM db_name",
 /* 253 */ "tag_list_opt ::=",
 /* 254 */ "tag_list_opt ::= tag_item",
 /* 255 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 256 */ "tag_item ::= TBNAME",
 /* 257 */ "tag_item ::= QTAGS",
 /* 258 */ "tag_item ::= column_name",
 /* 259 */ "tag_item ::= column_name column_alias",
 /* 260 */ "tag_item ::= column_name AS column_alias",
 /* 261 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 262 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 263 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 264 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 265 */ "func_list ::= func",
 /* 266 */ "func_list ::= func_list NK_COMMA func",
 /* 267 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 268 */ "sma_stream_opt ::=",
 /* 269 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 270 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 271 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 272 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 273 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 274 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 275 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 276 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 277 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 278 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 279 */ "cmd ::= DESC full_table_name",
 /* 280 */ "cmd ::= DESCRIBE full_table_name",
 /* 281 */ "cmd ::= RESET QUERY CACHE",
 /* 282 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 283 */ "analyze_opt ::=",
 /* 284 */ "analyze_opt ::= ANALYZE",
 /* 285 */ "explain_options ::=",
 /* 286 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 287 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 288 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 289 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 290 */ "agg_func_opt ::=",
 /* 291 */ "agg_func_opt ::= AGGREGATE",
 /* 292 */ "bufsize_opt ::=",
 /* 293 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 294 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 295 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 296 */ "stream_options ::=",
 /* 297 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 298 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 299 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 300 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 301 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 302 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 303 */ "subtable_opt ::=",
 /* 304 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 305 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 306 */ "cmd ::= KILL QUERY NK_STRING",
 /* 307 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 308 */ "cmd ::= BALANCE VGROUP",
 /* 309 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 310 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 311 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 312 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 313 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 314 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 315 */ "cmd ::= query_or_subquery",
 /* 316 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 317 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 318 */ "literal ::= NK_INTEGER",
 /* 319 */ "literal ::= NK_FLOAT",
 /* 320 */ "literal ::= NK_STRING",
 /* 321 */ "literal ::= NK_BOOL",
 /* 322 */ "literal ::= TIMESTAMP NK_STRING",
 /* 323 */ "literal ::= duration_literal",
 /* 324 */ "literal ::= NULL",
 /* 325 */ "literal ::= NK_QUESTION",
 /* 326 */ "duration_literal ::= NK_VARIABLE",
 /* 327 */ "signed ::= NK_INTEGER",
 /* 328 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 329 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 330 */ "signed ::= NK_FLOAT",
 /* 331 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 332 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 333 */ "signed_literal ::= signed",
 /* 334 */ "signed_literal ::= NK_STRING",
 /* 335 */ "signed_literal ::= NK_BOOL",
 /* 336 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 337 */ "signed_literal ::= duration_literal",
 /* 338 */ "signed_literal ::= NULL",
 /* 339 */ "signed_literal ::= literal_func",
 /* 340 */ "signed_literal ::= NK_QUESTION",
 /* 341 */ "literal_list ::= signed_literal",
 /* 342 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 343 */ "db_name ::= NK_ID",
 /* 344 */ "table_name ::= NK_ID",
 /* 345 */ "column_name ::= NK_ID",
 /* 346 */ "function_name ::= NK_ID",
 /* 347 */ "table_alias ::= NK_ID",
 /* 348 */ "column_alias ::= NK_ID",
 /* 349 */ "user_name ::= NK_ID",
 /* 350 */ "topic_name ::= NK_ID",
 /* 351 */ "stream_name ::= NK_ID",
 /* 352 */ "cgroup_name ::= NK_ID",
 /* 353 */ "expr_or_subquery ::= expression",
 /* 354 */ "expression ::= literal",
 /* 355 */ "expression ::= pseudo_column",
 /* 356 */ "expression ::= column_reference",
 /* 357 */ "expression ::= function_expression",
 /* 358 */ "expression ::= case_when_expression",
 /* 359 */ "expression ::= NK_LP expression NK_RP",
 /* 360 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 361 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 362 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 363 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 364 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 365 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 366 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 367 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 368 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 369 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 370 */ "expression_list ::= expr_or_subquery",
 /* 371 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 372 */ "column_reference ::= column_name",
 /* 373 */ "column_reference ::= table_name NK_DOT column_name",
 /* 374 */ "pseudo_column ::= ROWTS",
 /* 375 */ "pseudo_column ::= TBNAME",
 /* 376 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 377 */ "pseudo_column ::= QSTART",
 /* 378 */ "pseudo_column ::= QEND",
 /* 379 */ "pseudo_column ::= QDURATION",
 /* 380 */ "pseudo_column ::= WSTART",
 /* 381 */ "pseudo_column ::= WEND",
 /* 382 */ "pseudo_column ::= WDURATION",
 /* 383 */ "pseudo_column ::= IROWTS",
 /* 384 */ "pseudo_column ::= QTAGS",
 /* 385 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 386 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 387 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 388 */ "function_expression ::= literal_func",
 /* 389 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 390 */ "literal_func ::= NOW",
 /* 391 */ "noarg_func ::= NOW",
 /* 392 */ "noarg_func ::= TODAY",
 /* 393 */ "noarg_func ::= TIMEZONE",
 /* 394 */ "noarg_func ::= DATABASE",
 /* 395 */ "noarg_func ::= CLIENT_VERSION",
 /* 396 */ "noarg_func ::= SERVER_VERSION",
 /* 397 */ "noarg_func ::= SERVER_STATUS",
 /* 398 */ "noarg_func ::= CURRENT_USER",
 /* 399 */ "noarg_func ::= USER",
 /* 400 */ "star_func ::= COUNT",
 /* 401 */ "star_func ::= FIRST",
 /* 402 */ "star_func ::= LAST",
 /* 403 */ "star_func ::= LAST_ROW",
 /* 404 */ "star_func_para_list ::= NK_STAR",
 /* 405 */ "star_func_para_list ::= other_para_list",
 /* 406 */ "other_para_list ::= star_func_para",
 /* 407 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 408 */ "star_func_para ::= expr_or_subquery",
 /* 409 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 410 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 411 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 412 */ "when_then_list ::= when_then_expr",
 /* 413 */ "when_then_list ::= when_then_list when_then_expr",
 /* 414 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 415 */ "case_when_else_opt ::=",
 /* 416 */ "case_when_else_opt ::= ELSE common_expression",
 /* 417 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 418 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 419 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 420 */ "predicate ::= expr_or_subquery IS NULL",
 /* 421 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 422 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 423 */ "compare_op ::= NK_LT",
 /* 424 */ "compare_op ::= NK_GT",
 /* 425 */ "compare_op ::= NK_LE",
 /* 426 */ "compare_op ::= NK_GE",
 /* 427 */ "compare_op ::= NK_NE",
 /* 428 */ "compare_op ::= NK_EQ",
 /* 429 */ "compare_op ::= LIKE",
 /* 430 */ "compare_op ::= NOT LIKE",
 /* 431 */ "compare_op ::= MATCH",
 /* 432 */ "compare_op ::= NMATCH",
 /* 433 */ "compare_op ::= CONTAINS",
 /* 434 */ "in_op ::= IN",
 /* 435 */ "in_op ::= NOT IN",
 /* 436 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 437 */ "boolean_value_expression ::= boolean_primary",
 /* 438 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 439 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 440 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 441 */ "boolean_primary ::= predicate",
 /* 442 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 443 */ "common_expression ::= expr_or_subquery",
 /* 444 */ "common_expression ::= boolean_value_expression",
 /* 445 */ "from_clause_opt ::=",
 /* 446 */ "from_clause_opt ::= FROM table_reference_list",
 /* 447 */ "table_reference_list ::= table_reference",
 /* 448 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 449 */ "table_reference ::= table_primary",
 /* 450 */ "table_reference ::= joined_table",
 /* 451 */ "table_primary ::= table_name alias_opt",
 /* 452 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 453 */ "table_primary ::= subquery alias_opt",
 /* 454 */ "table_primary ::= parenthesized_joined_table",
 /* 455 */ "alias_opt ::=",
 /* 456 */ "alias_opt ::= table_alias",
 /* 457 */ "alias_opt ::= AS table_alias",
 /* 458 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 459 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 460 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 461 */ "join_type ::=",
 /* 462 */ "join_type ::= INNER",
 /* 463 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 464 */ "set_quantifier_opt ::=",
 /* 465 */ "set_quantifier_opt ::= DISTINCT",
 /* 466 */ "set_quantifier_opt ::= ALL",
 /* 467 */ "select_list ::= select_item",
 /* 468 */ "select_list ::= select_list NK_COMMA select_item",
 /* 469 */ "select_item ::= NK_STAR",
 /* 470 */ "select_item ::= common_expression",
 /* 471 */ "select_item ::= common_expression column_alias",
 /* 472 */ "select_item ::= common_expression AS column_alias",
 /* 473 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 474 */ "where_clause_opt ::=",
 /* 475 */ "where_clause_opt ::= WHERE search_condition",
 /* 476 */ "partition_by_clause_opt ::=",
 /* 477 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 478 */ "partition_list ::= partition_item",
 /* 479 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 480 */ "partition_item ::= expr_or_subquery",
 /* 481 */ "partition_item ::= expr_or_subquery column_alias",
 /* 482 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 483 */ "twindow_clause_opt ::=",
 /* 484 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 485 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 486 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 487 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 488 */ "sliding_opt ::=",
 /* 489 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 490 */ "fill_opt ::=",
 /* 491 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 492 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 493 */ "fill_mode ::= NONE",
 /* 494 */ "fill_mode ::= PREV",
 /* 495 */ "fill_mode ::= NULL",
 /* 496 */ "fill_mode ::= LINEAR",
 /* 497 */ "fill_mode ::= NEXT",
 /* 498 */ "group_by_clause_opt ::=",
 /* 499 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 500 */ "group_by_list ::= expr_or_subquery",
 /* 501 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 502 */ "having_clause_opt ::=",
 /* 503 */ "having_clause_opt ::= HAVING search_condition",
 /* 504 */ "range_opt ::=",
 /* 505 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 506 */ "every_opt ::=",
 /* 507 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 508 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 509 */ "query_simple ::= query_specification",
 /* 510 */ "query_simple ::= union_query_expression",
 /* 511 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 512 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 513 */ "query_simple_or_subquery ::= query_simple",
 /* 514 */ "query_simple_or_subquery ::= subquery",
 /* 515 */ "query_or_subquery ::= query_expression",
 /* 516 */ "query_or_subquery ::= subquery",
 /* 517 */ "order_by_clause_opt ::=",
 /* 518 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 519 */ "slimit_clause_opt ::=",
 /* 520 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 521 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 522 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 523 */ "limit_clause_opt ::=",
 /* 524 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 525 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 526 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 527 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 528 */ "subquery ::= NK_LP subquery NK_RP",
 /* 529 */ "search_condition ::= common_expression",
 /* 530 */ "sort_specification_list ::= sort_specification",
 /* 531 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 532 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 533 */ "ordering_specification_opt ::=",
 /* 534 */ "ordering_specification_opt ::= ASC",
 /* 535 */ "ordering_specification_opt ::= DESC",
 /* 536 */ "null_ordering_opt ::=",
 /* 537 */ "null_ordering_opt ::= NULLS FIRST",
 /* 538 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 322: /* cmd */
    case 325: /* literal */
    case 338: /* db_options */
    case 340: /* alter_db_options */
    case 346: /* retention */
    case 347: /* full_table_name */
    case 350: /* table_options */
    case 354: /* alter_table_clause */
    case 355: /* alter_table_options */
    case 358: /* signed_literal */
    case 359: /* create_subtable_clause */
    case 362: /* drop_table_clause */
    case 365: /* column_def */
    case 369: /* duration_literal */
    case 370: /* rollup_func_name */
    case 372: /* col_name */
    case 373: /* db_name_cond_opt */
    case 374: /* like_pattern_opt */
    case 375: /* table_name_cond */
    case 376: /* from_db_opt */
    case 378: /* tag_item */
    case 380: /* index_options */
    case 382: /* sliding_opt */
    case 383: /* sma_stream_opt */
    case 384: /* func */
    case 385: /* query_or_subquery */
    case 388: /* explain_options */
    case 392: /* stream_options */
    case 393: /* subtable_opt */
    case 394: /* expression */
    case 396: /* where_clause_opt */
    case 397: /* signed */
    case 398: /* literal_func */
    case 401: /* expr_or_subquery */
    case 402: /* pseudo_column */
    case 403: /* column_reference */
    case 404: /* function_expression */
    case 405: /* case_when_expression */
    case 410: /* star_func_para */
    case 412: /* case_when_else_opt */
    case 413: /* common_expression */
    case 414: /* when_then_expr */
    case 415: /* predicate */
    case 418: /* in_predicate_value */
    case 419: /* boolean_value_expression */
    case 420: /* boolean_primary */
    case 421: /* from_clause_opt */
    case 422: /* table_reference_list */
    case 423: /* table_reference */
    case 424: /* table_primary */
    case 425: /* joined_table */
    case 427: /* subquery */
    case 428: /* parenthesized_joined_table */
    case 430: /* search_condition */
    case 431: /* query_specification */
    case 435: /* range_opt */
    case 436: /* every_opt */
    case 437: /* fill_opt */
    case 438: /* twindow_clause_opt */
    case 440: /* having_clause_opt */
    case 441: /* select_item */
    case 443: /* partition_item */
    case 446: /* query_expression */
    case 447: /* query_simple */
    case 449: /* slimit_clause_opt */
    case 450: /* limit_clause_opt */
    case 451: /* union_query_expression */
    case 452: /* query_simple_or_subquery */
    case 454: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy148)); 
}
      break;
    case 323: /* account_options */
    case 324: /* alter_account_options */
    case 326: /* alter_account_option */
    case 341: /* speed_opt */
    case 390: /* bufsize_opt */
{
 
}
      break;
    case 327: /* user_name */
    case 330: /* priv_level */
    case 333: /* db_name */
    case 334: /* topic_name */
    case 335: /* dnode_endpoint */
    case 356: /* column_name */
    case 364: /* table_name */
    case 371: /* function_name */
    case 379: /* column_alias */
    case 386: /* cgroup_name */
    case 391: /* stream_name */
    case 400: /* table_alias */
    case 406: /* star_func */
    case 408: /* noarg_func */
    case 426: /* alias_opt */
{
 
}
      break;
    case 328: /* sysinfo_opt */
{
 
}
      break;
    case 329: /* privileges */
    case 331: /* priv_type_list */
    case 332: /* priv_type */
{
 
}
      break;
    case 336: /* force_opt */
    case 337: /* not_exists_opt */
    case 339: /* exists_opt */
    case 387: /* analyze_opt */
    case 389: /* agg_func_opt */
    case 432: /* set_quantifier_opt */
{
 
}
      break;
    case 342: /* integer_list */
    case 343: /* variable_list */
    case 344: /* retention_list */
    case 348: /* column_def_list */
    case 349: /* tags_def_opt */
    case 351: /* multi_create_clause */
    case 352: /* tags_def */
    case 353: /* multi_drop_clause */
    case 360: /* specific_cols_opt */
    case 361: /* expression_list */
    case 363: /* col_name_list */
    case 366: /* duration_list */
    case 367: /* rollup_func_list */
    case 377: /* tag_list_opt */
    case 381: /* func_list */
    case 395: /* dnode_list */
    case 399: /* literal_list */
    case 407: /* star_func_para_list */
    case 409: /* other_para_list */
    case 411: /* when_then_list */
    case 433: /* select_list */
    case 434: /* partition_by_clause_opt */
    case 439: /* group_by_clause_opt */
    case 442: /* partition_list */
    case 445: /* group_by_list */
    case 448: /* order_by_clause_opt */
    case 453: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy404)); 
}
      break;
    case 345: /* alter_db_option */
    case 368: /* alter_table_option */
{
 
}
      break;
    case 357: /* type_name */
{
 
}
      break;
    case 416: /* compare_op */
    case 417: /* in_op */
{
 
}
      break;
    case 429: /* join_type */
{
 
}
      break;
    case 444: /* fill_mode */
{
 
}
      break;
    case 455: /* ordering_specification_opt */
{
 
}
      break;
    case 456: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  322,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  322,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  323,    0 }, /* (2) account_options ::= */
  {  323,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  323,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  323,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  323,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  323,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  323,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  323,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  323,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  323,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  324,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  324,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  326,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  326,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  326,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  326,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  326,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  326,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  326,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  326,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  326,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  326,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  322,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  322,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  322,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  322,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  322,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  328,    0 }, /* (29) sysinfo_opt ::= */
  {  328,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  322,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  322,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  329,   -1 }, /* (33) privileges ::= ALL */
  {  329,   -1 }, /* (34) privileges ::= priv_type_list */
  {  329,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  331,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  331,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  332,   -1 }, /* (38) priv_type ::= READ */
  {  332,   -1 }, /* (39) priv_type ::= WRITE */
  {  330,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  330,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  330,   -1 }, /* (42) priv_level ::= topic_name */
  {  322,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  322,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  322,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  322,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  322,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  322,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  322,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  322,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  335,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  335,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  335,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  336,    0 }, /* (54) force_opt ::= */
  {  336,   -1 }, /* (55) force_opt ::= FORCE */
  {  322,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  322,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  322,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  322,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  322,   -2 }, /* (68) cmd ::= USE db_name */
  {  322,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  322,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  322,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  337,   -3 }, /* (72) not_exists_opt ::= IF NOT EXISTS */
  {  337,    0 }, /* (73) not_exists_opt ::= */
  {  339,   -2 }, /* (74) exists_opt ::= IF EXISTS */
  {  339,    0 }, /* (75) exists_opt ::= */
  {  338,    0 }, /* (76) db_options ::= */
  {  338,   -3 }, /* (77) db_options ::= db_options BUFFER NK_INTEGER */
  {  338,   -3 }, /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
  {  338,   -3 }, /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  338,   -3 }, /* (80) db_options ::= db_options COMP NK_INTEGER */
  {  338,   -3 }, /* (81) db_options ::= db_options DURATION NK_INTEGER */
  {  338,   -3 }, /* (82) db_options ::= db_options DURATION NK_VARIABLE */
  {  338,   -3 }, /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
  {  338,   -3 }, /* (84) db_options ::= db_options MINROWS NK_INTEGER */
  {  338,   -3 }, /* (85) db_options ::= db_options KEEP integer_list */
  {  338,   -3 }, /* (86) db_options ::= db_options KEEP variable_list */
  {  338,   -3 }, /* (87) db_options ::= db_options PAGES NK_INTEGER */
  {  338,   -3 }, /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  338,   -3 }, /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  338,   -3 }, /* (90) db_options ::= db_options PRECISION NK_STRING */
  {  338,   -3 }, /* (91) db_options ::= db_options REPLICA NK_INTEGER */
  {  338,   -3 }, /* (92) db_options ::= db_options STRICT NK_STRING */
  {  338,   -3 }, /* (93) db_options ::= db_options VGROUPS NK_INTEGER */
  {  338,   -3 }, /* (94) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  338,   -3 }, /* (95) db_options ::= db_options RETENTIONS retention_list */
  {  338,   -3 }, /* (96) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  338,   -3 }, /* (97) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  338,   -3 }, /* (98) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  338,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  338,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  338,   -3 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  338,   -4 }, /* (102) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  338,   -3 }, /* (103) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  338,   -3 }, /* (104) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  338,   -3 }, /* (105) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  338,   -3 }, /* (106) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  338,   -3 }, /* (107) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  340,   -1 }, /* (108) alter_db_options ::= alter_db_option */
  {  340,   -2 }, /* (109) alter_db_options ::= alter_db_options alter_db_option */
  {  345,   -2 }, /* (110) alter_db_option ::= BUFFER NK_INTEGER */
  {  345,   -2 }, /* (111) alter_db_option ::= CACHEMODEL NK_STRING */
  {  345,   -2 }, /* (112) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  345,   -2 }, /* (113) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  345,   -2 }, /* (114) alter_db_option ::= KEEP integer_list */
  {  345,   -2 }, /* (115) alter_db_option ::= KEEP variable_list */
  {  345,   -2 }, /* (116) alter_db_option ::= PAGES NK_INTEGER */
  {  345,   -2 }, /* (117) alter_db_option ::= REPLICA NK_INTEGER */
  {  345,   -2 }, /* (118) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  345,   -2 }, /* (119) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  342,   -1 }, /* (120) integer_list ::= NK_INTEGER */
  {  342,   -3 }, /* (121) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  343,   -1 }, /* (122) variable_list ::= NK_VARIABLE */
  {  343,   -3 }, /* (123) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  344,   -1 }, /* (124) retention_list ::= retention */
  {  344,   -3 }, /* (125) retention_list ::= retention_list NK_COMMA retention */
  {  346,   -3 }, /* (126) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  341,    0 }, /* (127) speed_opt ::= */
  {  341,   -2 }, /* (128) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  322,   -9 }, /* (129) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  322,   -3 }, /* (130) cmd ::= CREATE TABLE multi_create_clause */
  {  322,   -9 }, /* (131) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  322,   -3 }, /* (132) cmd ::= DROP TABLE multi_drop_clause */
  {  322,   -4 }, /* (133) cmd ::= DROP STABLE exists_opt full_table_name */
  {  322,   -3 }, /* (134) cmd ::= ALTER TABLE alter_table_clause */
  {  322,   -3 }, /* (135) cmd ::= ALTER STABLE alter_table_clause */
  {  354,   -2 }, /* (136) alter_table_clause ::= full_table_name alter_table_options */
  {  354,   -5 }, /* (137) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  354,   -4 }, /* (138) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  354,   -5 }, /* (139) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  354,   -5 }, /* (140) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  354,   -5 }, /* (141) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  354,   -4 }, /* (142) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  354,   -5 }, /* (143) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  354,   -5 }, /* (144) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  354,   -6 }, /* (145) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  351,   -1 }, /* (146) multi_create_clause ::= create_subtable_clause */
  {  351,   -2 }, /* (147) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  359,  -10 }, /* (148) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  353,   -1 }, /* (149) multi_drop_clause ::= drop_table_clause */
  {  353,   -2 }, /* (150) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  362,   -2 }, /* (151) drop_table_clause ::= exists_opt full_table_name */
  {  360,    0 }, /* (152) specific_cols_opt ::= */
  {  360,   -3 }, /* (153) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  347,   -1 }, /* (154) full_table_name ::= table_name */
  {  347,   -3 }, /* (155) full_table_name ::= db_name NK_DOT table_name */
  {  348,   -1 }, /* (156) column_def_list ::= column_def */
  {  348,   -3 }, /* (157) column_def_list ::= column_def_list NK_COMMA column_def */
  {  365,   -2 }, /* (158) column_def ::= column_name type_name */
  {  365,   -4 }, /* (159) column_def ::= column_name type_name COMMENT NK_STRING */
  {  357,   -1 }, /* (160) type_name ::= BOOL */
  {  357,   -1 }, /* (161) type_name ::= TINYINT */
  {  357,   -1 }, /* (162) type_name ::= SMALLINT */
  {  357,   -1 }, /* (163) type_name ::= INT */
  {  357,   -1 }, /* (164) type_name ::= INTEGER */
  {  357,   -1 }, /* (165) type_name ::= BIGINT */
  {  357,   -1 }, /* (166) type_name ::= FLOAT */
  {  357,   -1 }, /* (167) type_name ::= DOUBLE */
  {  357,   -4 }, /* (168) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  357,   -1 }, /* (169) type_name ::= TIMESTAMP */
  {  357,   -4 }, /* (170) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  357,   -2 }, /* (171) type_name ::= TINYINT UNSIGNED */
  {  357,   -2 }, /* (172) type_name ::= SMALLINT UNSIGNED */
  {  357,   -2 }, /* (173) type_name ::= INT UNSIGNED */
  {  357,   -2 }, /* (174) type_name ::= BIGINT UNSIGNED */
  {  357,   -1 }, /* (175) type_name ::= JSON */
  {  357,   -4 }, /* (176) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  357,   -1 }, /* (177) type_name ::= MEDIUMBLOB */
  {  357,   -1 }, /* (178) type_name ::= BLOB */
  {  357,   -4 }, /* (179) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  357,   -1 }, /* (180) type_name ::= DECIMAL */
  {  357,   -4 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  357,   -6 }, /* (182) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  349,    0 }, /* (183) tags_def_opt ::= */
  {  349,   -1 }, /* (184) tags_def_opt ::= tags_def */
  {  352,   -4 }, /* (185) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  350,    0 }, /* (186) table_options ::= */
  {  350,   -3 }, /* (187) table_options ::= table_options COMMENT NK_STRING */
  {  350,   -3 }, /* (188) table_options ::= table_options MAX_DELAY duration_list */
  {  350,   -3 }, /* (189) table_options ::= table_options WATERMARK duration_list */
  {  350,   -5 }, /* (190) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  350,   -3 }, /* (191) table_options ::= table_options TTL NK_INTEGER */
  {  350,   -5 }, /* (192) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  350,   -3 }, /* (193) table_options ::= table_options DELETE_MARK duration_list */
  {  355,   -1 }, /* (194) alter_table_options ::= alter_table_option */
  {  355,   -2 }, /* (195) alter_table_options ::= alter_table_options alter_table_option */
  {  368,   -2 }, /* (196) alter_table_option ::= COMMENT NK_STRING */
  {  368,   -2 }, /* (197) alter_table_option ::= TTL NK_INTEGER */
  {  366,   -1 }, /* (198) duration_list ::= duration_literal */
  {  366,   -3 }, /* (199) duration_list ::= duration_list NK_COMMA duration_literal */
  {  367,   -1 }, /* (200) rollup_func_list ::= rollup_func_name */
  {  367,   -3 }, /* (201) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  370,   -1 }, /* (202) rollup_func_name ::= function_name */
  {  370,   -1 }, /* (203) rollup_func_name ::= FIRST */
  {  370,   -1 }, /* (204) rollup_func_name ::= LAST */
  {  363,   -1 }, /* (205) col_name_list ::= col_name */
  {  363,   -3 }, /* (206) col_name_list ::= col_name_list NK_COMMA col_name */
  {  372,   -1 }, /* (207) col_name ::= column_name */
  {  322,   -2 }, /* (208) cmd ::= SHOW DNODES */
  {  322,   -2 }, /* (209) cmd ::= SHOW USERS */
  {  322,   -3 }, /* (210) cmd ::= SHOW USER PRIVILEGES */
  {  322,   -2 }, /* (211) cmd ::= SHOW DATABASES */
  {  322,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  322,   -4 }, /* (213) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  322,   -3 }, /* (214) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  322,   -2 }, /* (215) cmd ::= SHOW MNODES */
  {  322,   -2 }, /* (216) cmd ::= SHOW QNODES */
  {  322,   -2 }, /* (217) cmd ::= SHOW FUNCTIONS */
  {  322,   -5 }, /* (218) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  322,   -2 }, /* (219) cmd ::= SHOW STREAMS */
  {  322,   -2 }, /* (220) cmd ::= SHOW ACCOUNTS */
  {  322,   -2 }, /* (221) cmd ::= SHOW APPS */
  {  322,   -2 }, /* (222) cmd ::= SHOW CONNECTIONS */
  {  322,   -2 }, /* (223) cmd ::= SHOW LICENCES */
  {  322,   -2 }, /* (224) cmd ::= SHOW GRANTS */
  {  322,   -4 }, /* (225) cmd ::= SHOW CREATE DATABASE db_name */
  {  322,   -4 }, /* (226) cmd ::= SHOW CREATE TABLE full_table_name */
  {  322,   -4 }, /* (227) cmd ::= SHOW CREATE STABLE full_table_name */
  {  322,   -2 }, /* (228) cmd ::= SHOW QUERIES */
  {  322,   -2 }, /* (229) cmd ::= SHOW SCORES */
  {  322,   -2 }, /* (230) cmd ::= SHOW TOPICS */
  {  322,   -2 }, /* (231) cmd ::= SHOW VARIABLES */
  {  322,   -3 }, /* (232) cmd ::= SHOW CLUSTER VARIABLES */
  {  322,   -3 }, /* (233) cmd ::= SHOW LOCAL VARIABLES */
  {  322,   -5 }, /* (234) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  322,   -2 }, /* (235) cmd ::= SHOW BNODES */
  {  322,   -2 }, /* (236) cmd ::= SHOW SNODES */
  {  322,   -2 }, /* (237) cmd ::= SHOW CLUSTER */
  {  322,   -2 }, /* (238) cmd ::= SHOW TRANSACTIONS */
  {  322,   -4 }, /* (239) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  322,   -2 }, /* (240) cmd ::= SHOW CONSUMERS */
  {  322,   -2 }, /* (241) cmd ::= SHOW SUBSCRIPTIONS */
  {  322,   -5 }, /* (242) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  322,   -7 }, /* (243) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  322,   -3 }, /* (244) cmd ::= SHOW VNODES NK_INTEGER */
  {  322,   -3 }, /* (245) cmd ::= SHOW VNODES NK_STRING */
  {  373,    0 }, /* (246) db_name_cond_opt ::= */
  {  373,   -2 }, /* (247) db_name_cond_opt ::= db_name NK_DOT */
  {  374,    0 }, /* (248) like_pattern_opt ::= */
  {  374,   -2 }, /* (249) like_pattern_opt ::= LIKE NK_STRING */
  {  375,   -1 }, /* (250) table_name_cond ::= table_name */
  {  376,    0 }, /* (251) from_db_opt ::= */
  {  376,   -2 }, /* (252) from_db_opt ::= FROM db_name */
  {  377,    0 }, /* (253) tag_list_opt ::= */
  {  377,   -1 }, /* (254) tag_list_opt ::= tag_item */
  {  377,   -3 }, /* (255) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  378,   -1 }, /* (256) tag_item ::= TBNAME */
  {  378,   -1 }, /* (257) tag_item ::= QTAGS */
  {  378,   -1 }, /* (258) tag_item ::= column_name */
  {  378,   -2 }, /* (259) tag_item ::= column_name column_alias */
  {  378,   -3 }, /* (260) tag_item ::= column_name AS column_alias */
  {  322,   -8 }, /* (261) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  322,   -4 }, /* (262) cmd ::= DROP INDEX exists_opt full_table_name */
  {  380,  -10 }, /* (263) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  380,  -12 }, /* (264) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  381,   -1 }, /* (265) func_list ::= func */
  {  381,   -3 }, /* (266) func_list ::= func_list NK_COMMA func */
  {  384,   -4 }, /* (267) func ::= function_name NK_LP expression_list NK_RP */
  {  383,    0 }, /* (268) sma_stream_opt ::= */
  {  383,   -3 }, /* (269) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  383,   -3 }, /* (270) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  383,   -3 }, /* (271) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  322,   -6 }, /* (272) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  322,   -7 }, /* (273) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  322,   -9 }, /* (274) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  322,   -7 }, /* (275) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  322,   -9 }, /* (276) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  322,   -4 }, /* (277) cmd ::= DROP TOPIC exists_opt topic_name */
  {  322,   -7 }, /* (278) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  322,   -2 }, /* (279) cmd ::= DESC full_table_name */
  {  322,   -2 }, /* (280) cmd ::= DESCRIBE full_table_name */
  {  322,   -3 }, /* (281) cmd ::= RESET QUERY CACHE */
  {  322,   -4 }, /* (282) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  387,    0 }, /* (283) analyze_opt ::= */
  {  387,   -1 }, /* (284) analyze_opt ::= ANALYZE */
  {  388,    0 }, /* (285) explain_options ::= */
  {  388,   -3 }, /* (286) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  388,   -3 }, /* (287) explain_options ::= explain_options RATIO NK_FLOAT */
  {  322,  -10 }, /* (288) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  322,   -4 }, /* (289) cmd ::= DROP FUNCTION exists_opt function_name */
  {  389,    0 }, /* (290) agg_func_opt ::= */
  {  389,   -1 }, /* (291) agg_func_opt ::= AGGREGATE */
  {  390,    0 }, /* (292) bufsize_opt ::= */
  {  390,   -2 }, /* (293) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  322,  -11 }, /* (294) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  322,   -4 }, /* (295) cmd ::= DROP STREAM exists_opt stream_name */
  {  392,    0 }, /* (296) stream_options ::= */
  {  392,   -3 }, /* (297) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  392,   -3 }, /* (298) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  392,   -4 }, /* (299) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  392,   -3 }, /* (300) stream_options ::= stream_options WATERMARK duration_literal */
  {  392,   -4 }, /* (301) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  392,   -3 }, /* (302) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  393,    0 }, /* (303) subtable_opt ::= */
  {  393,   -4 }, /* (304) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  322,   -3 }, /* (305) cmd ::= KILL CONNECTION NK_INTEGER */
  {  322,   -3 }, /* (306) cmd ::= KILL QUERY NK_STRING */
  {  322,   -3 }, /* (307) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  322,   -2 }, /* (308) cmd ::= BALANCE VGROUP */
  {  322,   -4 }, /* (309) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  322,   -4 }, /* (310) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  322,   -3 }, /* (311) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  395,   -2 }, /* (312) dnode_list ::= DNODE NK_INTEGER */
  {  395,   -3 }, /* (313) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  322,   -4 }, /* (314) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  322,   -1 }, /* (315) cmd ::= query_or_subquery */
  {  322,   -7 }, /* (316) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  322,   -4 }, /* (317) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  325,   -1 }, /* (318) literal ::= NK_INTEGER */
  {  325,   -1 }, /* (319) literal ::= NK_FLOAT */
  {  325,   -1 }, /* (320) literal ::= NK_STRING */
  {  325,   -1 }, /* (321) literal ::= NK_BOOL */
  {  325,   -2 }, /* (322) literal ::= TIMESTAMP NK_STRING */
  {  325,   -1 }, /* (323) literal ::= duration_literal */
  {  325,   -1 }, /* (324) literal ::= NULL */
  {  325,   -1 }, /* (325) literal ::= NK_QUESTION */
  {  369,   -1 }, /* (326) duration_literal ::= NK_VARIABLE */
  {  397,   -1 }, /* (327) signed ::= NK_INTEGER */
  {  397,   -2 }, /* (328) signed ::= NK_PLUS NK_INTEGER */
  {  397,   -2 }, /* (329) signed ::= NK_MINUS NK_INTEGER */
  {  397,   -1 }, /* (330) signed ::= NK_FLOAT */
  {  397,   -2 }, /* (331) signed ::= NK_PLUS NK_FLOAT */
  {  397,   -2 }, /* (332) signed ::= NK_MINUS NK_FLOAT */
  {  358,   -1 }, /* (333) signed_literal ::= signed */
  {  358,   -1 }, /* (334) signed_literal ::= NK_STRING */
  {  358,   -1 }, /* (335) signed_literal ::= NK_BOOL */
  {  358,   -2 }, /* (336) signed_literal ::= TIMESTAMP NK_STRING */
  {  358,   -1 }, /* (337) signed_literal ::= duration_literal */
  {  358,   -1 }, /* (338) signed_literal ::= NULL */
  {  358,   -1 }, /* (339) signed_literal ::= literal_func */
  {  358,   -1 }, /* (340) signed_literal ::= NK_QUESTION */
  {  399,   -1 }, /* (341) literal_list ::= signed_literal */
  {  399,   -3 }, /* (342) literal_list ::= literal_list NK_COMMA signed_literal */
  {  333,   -1 }, /* (343) db_name ::= NK_ID */
  {  364,   -1 }, /* (344) table_name ::= NK_ID */
  {  356,   -1 }, /* (345) column_name ::= NK_ID */
  {  371,   -1 }, /* (346) function_name ::= NK_ID */
  {  400,   -1 }, /* (347) table_alias ::= NK_ID */
  {  379,   -1 }, /* (348) column_alias ::= NK_ID */
  {  327,   -1 }, /* (349) user_name ::= NK_ID */
  {  334,   -1 }, /* (350) topic_name ::= NK_ID */
  {  391,   -1 }, /* (351) stream_name ::= NK_ID */
  {  386,   -1 }, /* (352) cgroup_name ::= NK_ID */
  {  401,   -1 }, /* (353) expr_or_subquery ::= expression */
  {  394,   -1 }, /* (354) expression ::= literal */
  {  394,   -1 }, /* (355) expression ::= pseudo_column */
  {  394,   -1 }, /* (356) expression ::= column_reference */
  {  394,   -1 }, /* (357) expression ::= function_expression */
  {  394,   -1 }, /* (358) expression ::= case_when_expression */
  {  394,   -3 }, /* (359) expression ::= NK_LP expression NK_RP */
  {  394,   -2 }, /* (360) expression ::= NK_PLUS expr_or_subquery */
  {  394,   -2 }, /* (361) expression ::= NK_MINUS expr_or_subquery */
  {  394,   -3 }, /* (362) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  394,   -3 }, /* (363) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  394,   -3 }, /* (364) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  394,   -3 }, /* (365) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  394,   -3 }, /* (366) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  394,   -3 }, /* (367) expression ::= column_reference NK_ARROW NK_STRING */
  {  394,   -3 }, /* (368) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  394,   -3 }, /* (369) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  361,   -1 }, /* (370) expression_list ::= expr_or_subquery */
  {  361,   -3 }, /* (371) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  403,   -1 }, /* (372) column_reference ::= column_name */
  {  403,   -3 }, /* (373) column_reference ::= table_name NK_DOT column_name */
  {  402,   -1 }, /* (374) pseudo_column ::= ROWTS */
  {  402,   -1 }, /* (375) pseudo_column ::= TBNAME */
  {  402,   -3 }, /* (376) pseudo_column ::= table_name NK_DOT TBNAME */
  {  402,   -1 }, /* (377) pseudo_column ::= QSTART */
  {  402,   -1 }, /* (378) pseudo_column ::= QEND */
  {  402,   -1 }, /* (379) pseudo_column ::= QDURATION */
  {  402,   -1 }, /* (380) pseudo_column ::= WSTART */
  {  402,   -1 }, /* (381) pseudo_column ::= WEND */
  {  402,   -1 }, /* (382) pseudo_column ::= WDURATION */
  {  402,   -1 }, /* (383) pseudo_column ::= IROWTS */
  {  402,   -1 }, /* (384) pseudo_column ::= QTAGS */
  {  404,   -4 }, /* (385) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  404,   -4 }, /* (386) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  404,   -6 }, /* (387) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  404,   -1 }, /* (388) function_expression ::= literal_func */
  {  398,   -3 }, /* (389) literal_func ::= noarg_func NK_LP NK_RP */
  {  398,   -1 }, /* (390) literal_func ::= NOW */
  {  408,   -1 }, /* (391) noarg_func ::= NOW */
  {  408,   -1 }, /* (392) noarg_func ::= TODAY */
  {  408,   -1 }, /* (393) noarg_func ::= TIMEZONE */
  {  408,   -1 }, /* (394) noarg_func ::= DATABASE */
  {  408,   -1 }, /* (395) noarg_func ::= CLIENT_VERSION */
  {  408,   -1 }, /* (396) noarg_func ::= SERVER_VERSION */
  {  408,   -1 }, /* (397) noarg_func ::= SERVER_STATUS */
  {  408,   -1 }, /* (398) noarg_func ::= CURRENT_USER */
  {  408,   -1 }, /* (399) noarg_func ::= USER */
  {  406,   -1 }, /* (400) star_func ::= COUNT */
  {  406,   -1 }, /* (401) star_func ::= FIRST */
  {  406,   -1 }, /* (402) star_func ::= LAST */
  {  406,   -1 }, /* (403) star_func ::= LAST_ROW */
  {  407,   -1 }, /* (404) star_func_para_list ::= NK_STAR */
  {  407,   -1 }, /* (405) star_func_para_list ::= other_para_list */
  {  409,   -1 }, /* (406) other_para_list ::= star_func_para */
  {  409,   -3 }, /* (407) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  410,   -1 }, /* (408) star_func_para ::= expr_or_subquery */
  {  410,   -3 }, /* (409) star_func_para ::= table_name NK_DOT NK_STAR */
  {  405,   -4 }, /* (410) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  405,   -5 }, /* (411) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  411,   -1 }, /* (412) when_then_list ::= when_then_expr */
  {  411,   -2 }, /* (413) when_then_list ::= when_then_list when_then_expr */
  {  414,   -4 }, /* (414) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  412,    0 }, /* (415) case_when_else_opt ::= */
  {  412,   -2 }, /* (416) case_when_else_opt ::= ELSE common_expression */
  {  415,   -3 }, /* (417) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  415,   -5 }, /* (418) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  415,   -6 }, /* (419) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  415,   -3 }, /* (420) predicate ::= expr_or_subquery IS NULL */
  {  415,   -4 }, /* (421) predicate ::= expr_or_subquery IS NOT NULL */
  {  415,   -3 }, /* (422) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  416,   -1 }, /* (423) compare_op ::= NK_LT */
  {  416,   -1 }, /* (424) compare_op ::= NK_GT */
  {  416,   -1 }, /* (425) compare_op ::= NK_LE */
  {  416,   -1 }, /* (426) compare_op ::= NK_GE */
  {  416,   -1 }, /* (427) compare_op ::= NK_NE */
  {  416,   -1 }, /* (428) compare_op ::= NK_EQ */
  {  416,   -1 }, /* (429) compare_op ::= LIKE */
  {  416,   -2 }, /* (430) compare_op ::= NOT LIKE */
  {  416,   -1 }, /* (431) compare_op ::= MATCH */
  {  416,   -1 }, /* (432) compare_op ::= NMATCH */
  {  416,   -1 }, /* (433) compare_op ::= CONTAINS */
  {  417,   -1 }, /* (434) in_op ::= IN */
  {  417,   -2 }, /* (435) in_op ::= NOT IN */
  {  418,   -3 }, /* (436) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  419,   -1 }, /* (437) boolean_value_expression ::= boolean_primary */
  {  419,   -2 }, /* (438) boolean_value_expression ::= NOT boolean_primary */
  {  419,   -3 }, /* (439) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  419,   -3 }, /* (440) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  420,   -1 }, /* (441) boolean_primary ::= predicate */
  {  420,   -3 }, /* (442) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  413,   -1 }, /* (443) common_expression ::= expr_or_subquery */
  {  413,   -1 }, /* (444) common_expression ::= boolean_value_expression */
  {  421,    0 }, /* (445) from_clause_opt ::= */
  {  421,   -2 }, /* (446) from_clause_opt ::= FROM table_reference_list */
  {  422,   -1 }, /* (447) table_reference_list ::= table_reference */
  {  422,   -3 }, /* (448) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  423,   -1 }, /* (449) table_reference ::= table_primary */
  {  423,   -1 }, /* (450) table_reference ::= joined_table */
  {  424,   -2 }, /* (451) table_primary ::= table_name alias_opt */
  {  424,   -4 }, /* (452) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  424,   -2 }, /* (453) table_primary ::= subquery alias_opt */
  {  424,   -1 }, /* (454) table_primary ::= parenthesized_joined_table */
  {  426,    0 }, /* (455) alias_opt ::= */
  {  426,   -1 }, /* (456) alias_opt ::= table_alias */
  {  426,   -2 }, /* (457) alias_opt ::= AS table_alias */
  {  428,   -3 }, /* (458) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  428,   -3 }, /* (459) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  425,   -6 }, /* (460) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  429,    0 }, /* (461) join_type ::= */
  {  429,   -1 }, /* (462) join_type ::= INNER */
  {  431,  -12 }, /* (463) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  432,    0 }, /* (464) set_quantifier_opt ::= */
  {  432,   -1 }, /* (465) set_quantifier_opt ::= DISTINCT */
  {  432,   -1 }, /* (466) set_quantifier_opt ::= ALL */
  {  433,   -1 }, /* (467) select_list ::= select_item */
  {  433,   -3 }, /* (468) select_list ::= select_list NK_COMMA select_item */
  {  441,   -1 }, /* (469) select_item ::= NK_STAR */
  {  441,   -1 }, /* (470) select_item ::= common_expression */
  {  441,   -2 }, /* (471) select_item ::= common_expression column_alias */
  {  441,   -3 }, /* (472) select_item ::= common_expression AS column_alias */
  {  441,   -3 }, /* (473) select_item ::= table_name NK_DOT NK_STAR */
  {  396,    0 }, /* (474) where_clause_opt ::= */
  {  396,   -2 }, /* (475) where_clause_opt ::= WHERE search_condition */
  {  434,    0 }, /* (476) partition_by_clause_opt ::= */
  {  434,   -3 }, /* (477) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  442,   -1 }, /* (478) partition_list ::= partition_item */
  {  442,   -3 }, /* (479) partition_list ::= partition_list NK_COMMA partition_item */
  {  443,   -1 }, /* (480) partition_item ::= expr_or_subquery */
  {  443,   -2 }, /* (481) partition_item ::= expr_or_subquery column_alias */
  {  443,   -3 }, /* (482) partition_item ::= expr_or_subquery AS column_alias */
  {  438,    0 }, /* (483) twindow_clause_opt ::= */
  {  438,   -6 }, /* (484) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  438,   -4 }, /* (485) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  438,   -6 }, /* (486) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  438,   -8 }, /* (487) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  382,    0 }, /* (488) sliding_opt ::= */
  {  382,   -4 }, /* (489) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  437,    0 }, /* (490) fill_opt ::= */
  {  437,   -4 }, /* (491) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  437,   -6 }, /* (492) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  444,   -1 }, /* (493) fill_mode ::= NONE */
  {  444,   -1 }, /* (494) fill_mode ::= PREV */
  {  444,   -1 }, /* (495) fill_mode ::= NULL */
  {  444,   -1 }, /* (496) fill_mode ::= LINEAR */
  {  444,   -1 }, /* (497) fill_mode ::= NEXT */
  {  439,    0 }, /* (498) group_by_clause_opt ::= */
  {  439,   -3 }, /* (499) group_by_clause_opt ::= GROUP BY group_by_list */
  {  445,   -1 }, /* (500) group_by_list ::= expr_or_subquery */
  {  445,   -3 }, /* (501) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  440,    0 }, /* (502) having_clause_opt ::= */
  {  440,   -2 }, /* (503) having_clause_opt ::= HAVING search_condition */
  {  435,    0 }, /* (504) range_opt ::= */
  {  435,   -6 }, /* (505) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  436,    0 }, /* (506) every_opt ::= */
  {  436,   -4 }, /* (507) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  446,   -4 }, /* (508) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  447,   -1 }, /* (509) query_simple ::= query_specification */
  {  447,   -1 }, /* (510) query_simple ::= union_query_expression */
  {  451,   -4 }, /* (511) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  451,   -3 }, /* (512) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  452,   -1 }, /* (513) query_simple_or_subquery ::= query_simple */
  {  452,   -1 }, /* (514) query_simple_or_subquery ::= subquery */
  {  385,   -1 }, /* (515) query_or_subquery ::= query_expression */
  {  385,   -1 }, /* (516) query_or_subquery ::= subquery */
  {  448,    0 }, /* (517) order_by_clause_opt ::= */
  {  448,   -3 }, /* (518) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  449,    0 }, /* (519) slimit_clause_opt ::= */
  {  449,   -2 }, /* (520) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  449,   -4 }, /* (521) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  449,   -4 }, /* (522) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  450,    0 }, /* (523) limit_clause_opt ::= */
  {  450,   -2 }, /* (524) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  450,   -4 }, /* (525) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  450,   -4 }, /* (526) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  427,   -3 }, /* (527) subquery ::= NK_LP query_expression NK_RP */
  {  427,   -3 }, /* (528) subquery ::= NK_LP subquery NK_RP */
  {  430,   -1 }, /* (529) search_condition ::= common_expression */
  {  453,   -1 }, /* (530) sort_specification_list ::= sort_specification */
  {  453,   -3 }, /* (531) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  454,   -3 }, /* (532) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  455,    0 }, /* (533) ordering_specification_opt ::= */
  {  455,   -1 }, /* (534) ordering_specification_opt ::= ASC */
  {  455,   -1 }, /* (535) ordering_specification_opt ::= DESC */
  {  456,    0 }, /* (536) null_ordering_opt ::= */
  {  456,   -2 }, /* (537) null_ordering_opt ::= NULLS FIRST */
  {  456,   -2 }, /* (538) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,323,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,324,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,323,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,325,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,326,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,324,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,326,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,325,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy199, &yymsp[-1].minor.yy0, yymsp[0].minor.yy33); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy199, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy199, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy199, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy199); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy33 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy33 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy525, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy199); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy525, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy199); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy525 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy525 = yymsp[0].minor.yy525; }
  yymsp[0].minor.yy525 = yylhsminor.yy525;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy525 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy525 = yymsp[-2].minor.yy525 | yymsp[0].minor.yy525; }
  yymsp[-2].minor.yy525 = yylhsminor.yy525;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy525 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy525 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy199 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy199 = yylhsminor.yy199;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy199 = yymsp[-2].minor.yy199; }
  yymsp[-2].minor.yy199 = yylhsminor.yy199;
        break;
      case 42: /* priv_level ::= topic_name */
      case 456: /* alias_opt ::= table_alias */ yytestcase(yyruleno==456);
{ yylhsminor.yy199 = yymsp[0].minor.yy199; }
  yymsp[0].minor.yy199 = yylhsminor.yy199;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy199, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy397); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy199, yymsp[0].minor.yy397); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 343: /* db_name ::= NK_ID */ yytestcase(yyruleno==343);
      case 344: /* table_name ::= NK_ID */ yytestcase(yyruleno==344);
      case 345: /* column_name ::= NK_ID */ yytestcase(yyruleno==345);
      case 346: /* function_name ::= NK_ID */ yytestcase(yyruleno==346);
      case 347: /* table_alias ::= NK_ID */ yytestcase(yyruleno==347);
      case 348: /* column_alias ::= NK_ID */ yytestcase(yyruleno==348);
      case 349: /* user_name ::= NK_ID */ yytestcase(yyruleno==349);
      case 350: /* topic_name ::= NK_ID */ yytestcase(yyruleno==350);
      case 351: /* stream_name ::= NK_ID */ yytestcase(yyruleno==351);
      case 352: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==352);
      case 391: /* noarg_func ::= NOW */ yytestcase(yyruleno==391);
      case 392: /* noarg_func ::= TODAY */ yytestcase(yyruleno==392);
      case 393: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==393);
      case 394: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==394);
      case 395: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==395);
      case 396: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==396);
      case 397: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==397);
      case 398: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==398);
      case 399: /* noarg_func ::= USER */ yytestcase(yyruleno==399);
      case 400: /* star_func ::= COUNT */ yytestcase(yyruleno==400);
      case 401: /* star_func ::= FIRST */ yytestcase(yyruleno==401);
      case 402: /* star_func ::= LAST */ yytestcase(yyruleno==402);
      case 403: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==403);
{ yylhsminor.yy199 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy199 = yylhsminor.yy199;
        break;
      case 54: /* force_opt ::= */
      case 73: /* not_exists_opt ::= */ yytestcase(yyruleno==73);
      case 75: /* exists_opt ::= */ yytestcase(yyruleno==75);
      case 283: /* analyze_opt ::= */ yytestcase(yyruleno==283);
      case 290: /* agg_func_opt ::= */ yytestcase(yyruleno==290);
      case 464: /* set_quantifier_opt ::= */ yytestcase(yyruleno==464);
{ yymsp[1].minor.yy397 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 284: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==284);
      case 291: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==291);
      case 465: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==465);
{ yymsp[0].minor.yy397 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy397, &yymsp[-1].minor.yy199, yymsp[0].minor.yy148); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy199); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy199); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy199, yymsp[0].minor.yy148); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy199); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy199, yymsp[0].minor.yy706); }
        break;
      case 72: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy397 = true; }
        break;
      case 74: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy397 = true; }
        break;
      case 76: /* db_options ::= */
{ yymsp[1].minor.yy148 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 77: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 78: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 79: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 80: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 81: /* db_options ::= db_options DURATION NK_INTEGER */
      case 82: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==82);
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 83: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 84: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 85: /* db_options ::= db_options KEEP integer_list */
      case 86: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==86);
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_KEEP, yymsp[0].minor.yy404); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 87: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 88: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 89: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 90: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 91: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 92: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 93: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 94: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 95: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_RETENTIONS, yymsp[0].minor.yy404); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 96: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 97: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 98: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-3].minor.yy148, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-3].minor.yy148, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 103: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 104: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 105: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 106: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 107: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 108: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy148 = createAlterDatabaseOptions(pCxt); yylhsminor.yy148 = setAlterDatabaseOption(pCxt, yylhsminor.yy148, &yymsp[0].minor.yy123); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 109: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy148 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy148, &yymsp[0].minor.yy123); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 110: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy123.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= KEEP integer_list */
      case 115: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==115);
{ yymsp[-1].minor.yy123.type = DB_OPTION_KEEP; yymsp[-1].minor.yy123.pList = yymsp[0].minor.yy404; }
        break;
      case 116: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_PAGES; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_WAL; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy404 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 121: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 313: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==313);
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 122: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy404 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 123: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 124: /* retention_list ::= retention */
      case 146: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==146);
      case 149: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==149);
      case 156: /* column_def_list ::= column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name */ yytestcase(yyruleno==205);
      case 254: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==254);
      case 265: /* func_list ::= func */ yytestcase(yyruleno==265);
      case 341: /* literal_list ::= signed_literal */ yytestcase(yyruleno==341);
      case 406: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==406);
      case 412: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==412);
      case 467: /* select_list ::= select_item */ yytestcase(yyruleno==467);
      case 478: /* partition_list ::= partition_item */ yytestcase(yyruleno==478);
      case 530: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==530);
{ yylhsminor.yy404 = createNodeList(pCxt, yymsp[0].minor.yy148); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 125: /* retention_list ::= retention_list NK_COMMA retention */
      case 157: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==157);
      case 201: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==201);
      case 206: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==206);
      case 255: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==255);
      case 266: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==266);
      case 342: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==342);
      case 407: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==407);
      case 468: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==468);
      case 479: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==479);
      case 531: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==531);
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, yymsp[0].minor.yy148); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 126: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy148 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 127: /* speed_opt ::= */
      case 292: /* bufsize_opt ::= */ yytestcase(yyruleno==292);
{ yymsp[1].minor.yy706 = 0; }
        break;
      case 128: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 293: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==293);
{ yymsp[-1].minor.yy706 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 129: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 131: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==131);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy397, yymsp[-5].minor.yy148, yymsp[-3].minor.yy404, yymsp[-1].minor.yy404, yymsp[0].minor.yy148); }
        break;
      case 130: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy404); }
        break;
      case 132: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy404); }
        break;
      case 133: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy397, yymsp[0].minor.yy148); }
        break;
      case 134: /* cmd ::= ALTER TABLE alter_table_clause */
      case 315: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==315);
{ pCxt->pRootNode = yymsp[0].minor.yy148; }
        break;
      case 135: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy148); }
        break;
      case 136: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy148 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 137: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy148 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy148, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy199, yymsp[0].minor.yy530); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 138: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy148 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy148, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy199); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 139: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy148 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy148, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy199, yymsp[0].minor.yy530); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 140: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy148 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy148, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy199, &yymsp[0].minor.yy199); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 141: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy148 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy148, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy199, yymsp[0].minor.yy530); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 142: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy148 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy148, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy199); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 143: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy148 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy148, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy199, yymsp[0].minor.yy530); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 144: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy148 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy148, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy199, &yymsp[0].minor.yy199); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 145: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy148 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy148, &yymsp[-2].minor.yy199, yymsp[0].minor.yy148); }
  yymsp[-5].minor.yy148 = yylhsminor.yy148;
        break;
      case 147: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 150: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==150);
      case 413: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==413);
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-1].minor.yy404, yymsp[0].minor.yy148); }
  yymsp[-1].minor.yy404 = yylhsminor.yy404;
        break;
      case 148: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy148 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy397, yymsp[-8].minor.yy148, yymsp[-6].minor.yy148, yymsp[-5].minor.yy404, yymsp[-2].minor.yy404, yymsp[0].minor.yy148); }
  yymsp[-9].minor.yy148 = yylhsminor.yy148;
        break;
      case 151: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy148 = createDropTableClause(pCxt, yymsp[-1].minor.yy397, yymsp[0].minor.yy148); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 152: /* specific_cols_opt ::= */
      case 183: /* tags_def_opt ::= */ yytestcase(yyruleno==183);
      case 253: /* tag_list_opt ::= */ yytestcase(yyruleno==253);
      case 476: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==476);
      case 498: /* group_by_clause_opt ::= */ yytestcase(yyruleno==498);
      case 517: /* order_by_clause_opt ::= */ yytestcase(yyruleno==517);
{ yymsp[1].minor.yy404 = NULL; }
        break;
      case 153: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy404 = yymsp[-1].minor.yy404; }
        break;
      case 154: /* full_table_name ::= table_name */
{ yylhsminor.yy148 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy199, NULL); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 155: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy148 = createRealTableNode(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy199, NULL); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 158: /* column_def ::= column_name type_name */
{ yylhsminor.yy148 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy199, yymsp[0].minor.yy530, NULL); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 159: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy148 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy199, yymsp[-2].minor.yy530, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 160: /* type_name ::= BOOL */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 161: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 162: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 163: /* type_name ::= INT */
      case 164: /* type_name ::= INTEGER */ yytestcase(yyruleno==164);
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 165: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 166: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 167: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 168: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy530 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 169: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 170: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy530 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 171: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy530 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 172: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy530 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 173: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy530 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 174: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy530 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 175: /* type_name ::= JSON */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 176: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy530 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 177: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 178: /* type_name ::= BLOB */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 179: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy530 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 180: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy530 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 182: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy530 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 184: /* tags_def_opt ::= tags_def */
      case 405: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==405);
{ yylhsminor.yy404 = yymsp[0].minor.yy404; }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 185: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy404 = yymsp[-1].minor.yy404; }
        break;
      case 186: /* table_options ::= */
{ yymsp[1].minor.yy148 = createDefaultTableOptions(pCxt); }
        break;
      case 187: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-2].minor.yy148, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 188: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-2].minor.yy148, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy404); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 189: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-2].minor.yy148, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy404); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 190: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-4].minor.yy148, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy404); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 191: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-2].minor.yy148, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 192: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-4].minor.yy148, TABLE_OPTION_SMA, yymsp[-1].minor.yy404); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 193: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-2].minor.yy148, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy404); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 194: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy148 = createAlterTableOptions(pCxt); yylhsminor.yy148 = setTableOption(pCxt, yylhsminor.yy148, yymsp[0].minor.yy123.type, &yymsp[0].minor.yy123.val); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 195: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-1].minor.yy148, yymsp[0].minor.yy123.type, &yymsp[0].minor.yy123.val); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 196: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy123.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy123.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 198: /* duration_list ::= duration_literal */
      case 370: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==370);
{ yylhsminor.yy404 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy148)); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 199: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 371: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==371);
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, releaseRawExprNode(pCxt, yymsp[0].minor.yy148)); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 202: /* rollup_func_name ::= function_name */
{ yylhsminor.yy148 = createFunctionNode(pCxt, &yymsp[0].minor.yy199, NULL); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 203: /* rollup_func_name ::= FIRST */
      case 204: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==204);
      case 257: /* tag_item ::= QTAGS */ yytestcase(yyruleno==257);
{ yylhsminor.yy148 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 207: /* col_name ::= column_name */
      case 258: /* tag_item ::= column_name */ yytestcase(yyruleno==258);
{ yylhsminor.yy148 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy199); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 208: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 209: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 210: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 211: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy148, yymsp[0].minor.yy148, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy148, yymsp[0].minor.yy148, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy148, NULL, OP_TYPE_LIKE); }
        break;
      case 215: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 217: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 218: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy148, yymsp[-1].minor.yy148, OP_TYPE_EQUAL); }
        break;
      case 219: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 220: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 221: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 222: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 223: /* cmd ::= SHOW LICENCES */
      case 224: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==224);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 225: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy199); }
        break;
      case 226: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy148); }
        break;
      case 227: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy148); }
        break;
      case 228: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 229: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 230: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 231: /* cmd ::= SHOW VARIABLES */
      case 232: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==232);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 234: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy148); }
        break;
      case 235: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 237: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 238: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 239: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy148); }
        break;
      case 240: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 241: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 242: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy148, yymsp[-1].minor.yy148, OP_TYPE_EQUAL); }
        break;
      case 243: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy148, yymsp[0].minor.yy148, yymsp[-3].minor.yy404); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 245: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 246: /* db_name_cond_opt ::= */
      case 251: /* from_db_opt ::= */ yytestcase(yyruleno==251);
{ yymsp[1].minor.yy148 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 247: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy148 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy199); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 248: /* like_pattern_opt ::= */
      case 303: /* subtable_opt ::= */ yytestcase(yyruleno==303);
      case 415: /* case_when_else_opt ::= */ yytestcase(yyruleno==415);
      case 445: /* from_clause_opt ::= */ yytestcase(yyruleno==445);
      case 474: /* where_clause_opt ::= */ yytestcase(yyruleno==474);
      case 483: /* twindow_clause_opt ::= */ yytestcase(yyruleno==483);
      case 488: /* sliding_opt ::= */ yytestcase(yyruleno==488);
      case 490: /* fill_opt ::= */ yytestcase(yyruleno==490);
      case 502: /* having_clause_opt ::= */ yytestcase(yyruleno==502);
      case 504: /* range_opt ::= */ yytestcase(yyruleno==504);
      case 506: /* every_opt ::= */ yytestcase(yyruleno==506);
      case 519: /* slimit_clause_opt ::= */ yytestcase(yyruleno==519);
      case 523: /* limit_clause_opt ::= */ yytestcase(yyruleno==523);
{ yymsp[1].minor.yy148 = NULL; }
        break;
      case 249: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 250: /* table_name_cond ::= table_name */
{ yylhsminor.yy148 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy199); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 252: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy148 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy199); }
        break;
      case 256: /* tag_item ::= TBNAME */
{ yylhsminor.yy148 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 259: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy148 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy199), &yymsp[0].minor.yy199); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 260: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy148 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy199), &yymsp[0].minor.yy199); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 261: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy397, yymsp[-3].minor.yy148, yymsp[-1].minor.yy148, NULL, yymsp[0].minor.yy148); }
        break;
      case 262: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy397, yymsp[0].minor.yy148); }
        break;
      case 263: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy148 = createIndexOption(pCxt, yymsp[-7].minor.yy404, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), NULL, yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 264: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy148 = createIndexOption(pCxt, yymsp[-9].minor.yy404, releaseRawExprNode(pCxt, yymsp[-5].minor.yy148), releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 267: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy148 = createFunctionNode(pCxt, &yymsp[-3].minor.yy199, yymsp[-1].minor.yy404); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 268: /* sma_stream_opt ::= */
      case 296: /* stream_options ::= */ yytestcase(yyruleno==296);
{ yymsp[1].minor.yy148 = createStreamOptions(pCxt); }
        break;
      case 269: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 300: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==300);
{ ((SStreamOptions*)yymsp[-2].minor.yy148)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy148); yylhsminor.yy148 = yymsp[-2].minor.yy148; }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 270: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy148)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy148); yylhsminor.yy148 = yymsp[-2].minor.yy148; }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 271: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy148)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy148); yylhsminor.yy148 = yymsp[-2].minor.yy148; }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 272: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy397, &yymsp[-2].minor.yy199, yymsp[0].minor.yy148); }
        break;
      case 273: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy397, &yymsp[-3].minor.yy199, &yymsp[0].minor.yy199, false); }
        break;
      case 274: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy397, &yymsp[-5].minor.yy199, &yymsp[0].minor.yy199, true); }
        break;
      case 275: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy397, &yymsp[-3].minor.yy199, yymsp[0].minor.yy148, false); }
        break;
      case 276: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy397, &yymsp[-5].minor.yy199, yymsp[0].minor.yy148, true); }
        break;
      case 277: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy199); }
        break;
      case 278: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy397, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy199); }
        break;
      case 279: /* cmd ::= DESC full_table_name */
      case 280: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==280);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy148); }
        break;
      case 281: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 282: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy397, yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 285: /* explain_options ::= */
{ yymsp[1].minor.yy148 = createDefaultExplainOptions(pCxt); }
        break;
      case 286: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy148 = setExplainVerbose(pCxt, yymsp[-2].minor.yy148, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 287: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy148 = setExplainRatio(pCxt, yymsp[-2].minor.yy148, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 288: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy397, yymsp[-8].minor.yy397, &yymsp[-5].minor.yy199, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy530, yymsp[0].minor.yy706); }
        break;
      case 289: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy199); }
        break;
      case 294: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy397, &yymsp[-7].minor.yy199, yymsp[-4].minor.yy148, yymsp[-6].minor.yy148, yymsp[-3].minor.yy404, yymsp[-2].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 295: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy199); }
        break;
      case 297: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy148)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy148 = yymsp[-2].minor.yy148; }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 298: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy148)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy148 = yymsp[-2].minor.yy148; }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 299: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy148)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy148)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy148); yylhsminor.yy148 = yymsp[-3].minor.yy148; }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 301: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy148)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy148 = yymsp[-3].minor.yy148; }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 302: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy148)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy148 = yymsp[-2].minor.yy148; }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 304: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 489: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==489);
      case 507: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==507);
{ yymsp[-3].minor.yy148 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy148); }
        break;
      case 305: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 306: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 307: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 308: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 309: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 310: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy404); }
        break;
      case 311: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 312: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy404 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 314: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 316: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy148, yymsp[-2].minor.yy404, yymsp[0].minor.yy148); }
        break;
      case 317: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy148, NULL, yymsp[0].minor.yy148); }
        break;
      case 318: /* literal ::= NK_INTEGER */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 319: /* literal ::= NK_FLOAT */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 320: /* literal ::= NK_STRING */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 321: /* literal ::= NK_BOOL */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 322: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 323: /* literal ::= duration_literal */
      case 333: /* signed_literal ::= signed */ yytestcase(yyruleno==333);
      case 353: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==353);
      case 354: /* expression ::= literal */ yytestcase(yyruleno==354);
      case 355: /* expression ::= pseudo_column */ yytestcase(yyruleno==355);
      case 356: /* expression ::= column_reference */ yytestcase(yyruleno==356);
      case 357: /* expression ::= function_expression */ yytestcase(yyruleno==357);
      case 358: /* expression ::= case_when_expression */ yytestcase(yyruleno==358);
      case 388: /* function_expression ::= literal_func */ yytestcase(yyruleno==388);
      case 437: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==437);
      case 441: /* boolean_primary ::= predicate */ yytestcase(yyruleno==441);
      case 443: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==443);
      case 444: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==444);
      case 447: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==447);
      case 449: /* table_reference ::= table_primary */ yytestcase(yyruleno==449);
      case 450: /* table_reference ::= joined_table */ yytestcase(yyruleno==450);
      case 454: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==454);
      case 509: /* query_simple ::= query_specification */ yytestcase(yyruleno==509);
      case 510: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==510);
      case 513: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==513);
      case 515: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==515);
{ yylhsminor.yy148 = yymsp[0].minor.yy148; }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 324: /* literal ::= NULL */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 325: /* literal ::= NK_QUESTION */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 326: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 327: /* signed ::= NK_INTEGER */
{ yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 328: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 329: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 330: /* signed ::= NK_FLOAT */
{ yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 331: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 332: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 334: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 335: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 336: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 337: /* signed_literal ::= duration_literal */
      case 339: /* signed_literal ::= literal_func */ yytestcase(yyruleno==339);
      case 408: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==408);
      case 470: /* select_item ::= common_expression */ yytestcase(yyruleno==470);
      case 480: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==480);
      case 514: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==514);
      case 516: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==516);
      case 529: /* search_condition ::= common_expression */ yytestcase(yyruleno==529);
{ yylhsminor.yy148 = releaseRawExprNode(pCxt, yymsp[0].minor.yy148); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 338: /* signed_literal ::= NULL */
{ yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 340: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy148 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 359: /* expression ::= NK_LP expression NK_RP */
      case 442: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==442);
      case 528: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==528);
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy148)); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 360: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy148));
                                                                                  }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 361: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy148), NULL));
                                                                                  }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 362: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148))); 
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 363: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148))); 
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 364: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148))); 
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 365: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148))); 
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 366: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 367: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 368: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 369: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 372: /* column_reference ::= column_name */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy199, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy199)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 373: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy199, createColumnNode(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy199)); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 374: /* pseudo_column ::= ROWTS */
      case 375: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==375);
      case 377: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==377);
      case 378: /* pseudo_column ::= QEND */ yytestcase(yyruleno==378);
      case 379: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==379);
      case 380: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==380);
      case 381: /* pseudo_column ::= WEND */ yytestcase(yyruleno==381);
      case 382: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==382);
      case 383: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==383);
      case 384: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==384);
      case 390: /* literal_func ::= NOW */ yytestcase(yyruleno==390);
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 376: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy199)))); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 385: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 386: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==386);
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy199, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy199, yymsp[-1].minor.yy404)); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 387: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), yymsp[-1].minor.yy530)); }
  yymsp[-5].minor.yy148 = yylhsminor.yy148;
        break;
      case 389: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy199, NULL)); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 404: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy404 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 409: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 473: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==473);
{ yylhsminor.yy148 = createColumnNode(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 410: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy404, yymsp[-1].minor.yy148)); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 411: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), yymsp[-2].minor.yy404, yymsp[-1].minor.yy148)); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 414: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy148 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)); }
        break;
      case 416: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy148 = releaseRawExprNode(pCxt, yymsp[0].minor.yy148); }
        break;
      case 417: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 422: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==422);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy20, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 418: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy148), releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 419: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy148), releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-5].minor.yy148 = yylhsminor.yy148;
        break;
      case 420: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), NULL));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 421: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), NULL));
                                                                                  }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 423: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy20 = OP_TYPE_LOWER_THAN; }
        break;
      case 424: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy20 = OP_TYPE_GREATER_THAN; }
        break;
      case 425: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy20 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 426: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy20 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 427: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy20 = OP_TYPE_NOT_EQUAL; }
        break;
      case 428: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy20 = OP_TYPE_EQUAL; }
        break;
      case 429: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy20 = OP_TYPE_LIKE; }
        break;
      case 430: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy20 = OP_TYPE_NOT_LIKE; }
        break;
      case 431: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy20 = OP_TYPE_MATCH; }
        break;
      case 432: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy20 = OP_TYPE_NMATCH; }
        break;
      case 433: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy20 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 434: /* in_op ::= IN */
{ yymsp[0].minor.yy20 = OP_TYPE_IN; }
        break;
      case 435: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy20 = OP_TYPE_NOT_IN; }
        break;
      case 436: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy404)); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 438: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy148), NULL));
                                                                                  }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 439: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 440: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 446: /* from_clause_opt ::= FROM table_reference_list */
      case 475: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==475);
      case 503: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==503);
{ yymsp[-1].minor.yy148 = yymsp[0].minor.yy148; }
        break;
      case 448: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy148 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy148, yymsp[0].minor.yy148, NULL); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 451: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy148 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy199, &yymsp[0].minor.yy199); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 452: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy148 = createRealTableNode(pCxt, &yymsp[-3].minor.yy199, &yymsp[-1].minor.yy199, &yymsp[0].minor.yy199); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 453: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy148 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy148), &yymsp[0].minor.yy199); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 455: /* alias_opt ::= */
{ yymsp[1].minor.yy199 = nil_token;  }
        break;
      case 457: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy199 = yymsp[0].minor.yy199; }
        break;
      case 458: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 459: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==459);
{ yymsp[-2].minor.yy148 = yymsp[-1].minor.yy148; }
        break;
      case 460: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy148 = createJoinTableNode(pCxt, yymsp[-4].minor.yy470, yymsp[-5].minor.yy148, yymsp[-2].minor.yy148, yymsp[0].minor.yy148); }
  yymsp[-5].minor.yy148 = yylhsminor.yy148;
        break;
      case 461: /* join_type ::= */
{ yymsp[1].minor.yy470 = JOIN_TYPE_INNER; }
        break;
      case 462: /* join_type ::= INNER */
{ yymsp[0].minor.yy470 = JOIN_TYPE_INNER; }
        break;
      case 463: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy148 = createSelectStmt(pCxt, yymsp[-10].minor.yy397, yymsp[-9].minor.yy404, yymsp[-8].minor.yy148);
                                                                                    yymsp[-11].minor.yy148 = addWhereClause(pCxt, yymsp[-11].minor.yy148, yymsp[-7].minor.yy148);
                                                                                    yymsp[-11].minor.yy148 = addPartitionByClause(pCxt, yymsp[-11].minor.yy148, yymsp[-6].minor.yy404);
                                                                                    yymsp[-11].minor.yy148 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy148, yymsp[-2].minor.yy148);
                                                                                    yymsp[-11].minor.yy148 = addGroupByClause(pCxt, yymsp[-11].minor.yy148, yymsp[-1].minor.yy404);
                                                                                    yymsp[-11].minor.yy148 = addHavingClause(pCxt, yymsp[-11].minor.yy148, yymsp[0].minor.yy148);
                                                                                    yymsp[-11].minor.yy148 = addRangeClause(pCxt, yymsp[-11].minor.yy148, yymsp[-5].minor.yy148);
                                                                                    yymsp[-11].minor.yy148 = addEveryClause(pCxt, yymsp[-11].minor.yy148, yymsp[-4].minor.yy148);
                                                                                    yymsp[-11].minor.yy148 = addFillClause(pCxt, yymsp[-11].minor.yy148, yymsp[-3].minor.yy148);
                                                                                  }
        break;
      case 466: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy397 = false; }
        break;
      case 469: /* select_item ::= NK_STAR */
{ yylhsminor.yy148 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 471: /* select_item ::= common_expression column_alias */
      case 481: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==481);
{ yylhsminor.yy148 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy148), &yymsp[0].minor.yy199); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 472: /* select_item ::= common_expression AS column_alias */
      case 482: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==482);
{ yylhsminor.yy148 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), &yymsp[0].minor.yy199); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 477: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 499: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==499);
      case 518: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==518);
{ yymsp[-2].minor.yy404 = yymsp[0].minor.yy404; }
        break;
      case 484: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy148 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), releaseRawExprNode(pCxt, yymsp[-1].minor.yy148)); }
        break;
      case 485: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy148 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy148)); }
        break;
      case 486: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy148 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), NULL, yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 487: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy148 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy148), releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 491: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy148 = createFillNode(pCxt, yymsp[-1].minor.yy334, NULL); }
        break;
      case 492: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy148 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy404)); }
        break;
      case 493: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy334 = FILL_MODE_NONE; }
        break;
      case 494: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy334 = FILL_MODE_PREV; }
        break;
      case 495: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy334 = FILL_MODE_NULL; }
        break;
      case 496: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy334 = FILL_MODE_LINEAR; }
        break;
      case 497: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy334 = FILL_MODE_NEXT; }
        break;
      case 500: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy404 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy148))); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 501: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy148))); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 505: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy148 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), releaseRawExprNode(pCxt, yymsp[-1].minor.yy148)); }
        break;
      case 508: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy148 = addOrderByClause(pCxt, yymsp[-3].minor.yy148, yymsp[-2].minor.yy404);
                                                                                    yylhsminor.yy148 = addSlimitClause(pCxt, yylhsminor.yy148, yymsp[-1].minor.yy148);
                                                                                    yylhsminor.yy148 = addLimitClause(pCxt, yylhsminor.yy148, yymsp[0].minor.yy148);
                                                                                  }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 511: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy148 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy148, yymsp[0].minor.yy148); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 512: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy148 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy148, yymsp[0].minor.yy148); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 520: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 524: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==524);
{ yymsp[-1].minor.yy148 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 521: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 525: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==525);
{ yymsp[-3].minor.yy148 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 522: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 526: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==526);
{ yymsp[-3].minor.yy148 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 527: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy148); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 532: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy148 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), yymsp[-1].minor.yy898, yymsp[0].minor.yy499); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 533: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy898 = ORDER_ASC; }
        break;
      case 534: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy898 = ORDER_ASC; }
        break;
      case 535: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy898 = ORDER_DESC; }
        break;
      case 536: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy499 = NULL_ORDER_DEFAULT; }
        break;
      case 537: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy499 = NULL_ORDER_FIRST; }
        break;
      case 538: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy499 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
