/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 427
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SAlterOption yy95;
  EOperatorType yy198;
  EOrder yy204;
  int8_t yy215;
  ENullOrder yy277;
  bool yy313;
  int64_t yy473;
  SNodeList* yy544;
  SToken yy617;
  EJoinType yy708;
  SDataType yy784;
  EFillMode yy816;
  SNode* yy840;
  int32_t yy844;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             672
#define YYNRULE              493
#define YYNTOKEN             306
#define YY_MAX_SHIFT         671
#define YY_MIN_SHIFTREDUCE   979
#define YY_MAX_SHIFTREDUCE   1471
#define YY_ERROR_ACTION      1472
#define YY_ACCEPT_ACTION     1473
#define YY_NO_ACTION         1474
#define YY_MIN_REDUCE        1475
#define YY_MAX_REDUCE        1967
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2522)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   517, 1801,  436,  530,  437, 1510,  379,  326, 1720,   64,
 /*    10 */  1717,  553,   39,   37,  117, 1606,  444,  553,  437, 1510,
 /*    20 */   340,  474, 1272, 1475,   40,   38,   36,   35,   34, 1819,
 /*    30 */   530, 1617,  530, 1348, 1029, 1270, 1028,  582,  553,  127,
 /*    40 */   556,   55, 1771,  169,  581,  127, 1945,  116,  115,  114,
 /*    50 */   113,  112,  111,  110,  109,  108, 1343,  558, 1617,  164,
 /*    60 */  1617,   14,  327, 1942, 1030,  558,  127, 1833, 1278, 1537,
 /*    70 */   146,   94, 1802,  584, 1804, 1805,  580,  125,  575, 1619,
 /*    80 */   148, 1879, 1487,  125, 1498,  306, 1875, 1298, 1012, 1281,
 /*    90 */     1,  555,  160, 1887, 1888,   63, 1892, 1945,  250, 1887,
 /*   100 */   552, 1669,  551,  345,  125, 1945, 1662, 1664,  328,  150,
 /*   110 */   166, 1595,  668, 1576, 1942,  453, 1819, 1667,  166,  161,
 /*   120 */  1887, 1888, 1942, 1892,  546, 1771, 1350, 1351, 1016, 1017,
 /*   130 */    30,  260,  645,  644,  643,  642,  350, 1476,  641,  640,
 /*   140 */   128,  635,  634,  633,  632,  631,  630,  629,  139,  625,
 /*   150 */   624,  623,  349,  348,  620,  619,  618,  628,  107, 1589,
 /*   160 */   545,  106,  105,  104,  103,  102,  101,  100,   99,   98,
 /*   170 */   556,  453, 1273, 1894, 1271, 1127,  606,  605,  604, 1131,
 /*   180 */   603, 1133, 1134,  602, 1136,  599,  542, 1142,  596, 1144,
 /*   190 */  1145,  593,  590, 1169, 1170, 1276, 1277, 1891, 1325, 1326,
 /*   200 */  1328, 1329, 1330, 1331, 1332, 1333,  577,  573, 1341, 1342,
 /*   210 */  1344, 1345, 1346, 1347, 1349, 1352,   39,   37, 1411, 1945,
 /*   220 */  1789,  302,  158, 1295,  340, 1801, 1272,  222, 1284,  167,
 /*   230 */   415, 1785, 1944,  427,  167, 1656, 1942, 1348,  107, 1270,
 /*   240 */    43,  106,  105,  104,  103,  102,  101,  100,   99,   98,
 /*   250 */   400,  556,  428, 1819,  402, 1781, 1787,  329,   74, 1297,
 /*   260 */  1343,  582, 1298,  548,  543,   14, 1771,  575,  581,   33,
 /*   270 */    32,  122, 1278,   40,   38,   36,   35,   34,   33,   32,
 /*   280 */  1612,  217,   40,   38,   36,   35,   34, 1252, 1253, 1297,
 /*   290 */  1945, 1833,  393,   91,    2,   95, 1802,  584, 1804, 1805,
 /*   300 */   580,   63,  575,  165,  389, 1879,  124, 1942,  547,  331,
 /*   310 */  1875, 1958, 1663, 1664, 1609,   63,  668,   78,   33,   32,
 /*   320 */  1913,   42,   40,   38,   36,   35,   34,  441, 1432,   63,
 /*   330 */  1350, 1351,  426, 1295,   63,  421,  420,  419,  418,  417,
 /*   340 */   414,  413,  412,  411,  410,  406,  405,  404,  403,  397,
 /*   350 */   396,  395,  394,   22,  391,  390,  314,  483,  482,   33,
 /*   360 */    32, 1442,   61,   40,   38,   36,   35,   34, 1029,  530,
 /*   370 */  1028,  539, 1430, 1431, 1433, 1434, 1273, 1710, 1271,   26,
 /*   380 */   117, 1296,  378,  472,  377,   33,   32,  479,  172,   40,
 /*   390 */    38,   36,   35,   34,  223,  224,  553, 1617, 1030, 1276,
 /*   400 */  1277,  173, 1325, 1326, 1328, 1329, 1330, 1331, 1332, 1333,
 /*   410 */   577,  573, 1341, 1342, 1344, 1345, 1346, 1347, 1349, 1352,
 /*   420 */    39,   37, 1801,  491,  127, 1468,  615,  609,  340, 1593,
 /*   430 */  1272,   36,   35,   34,   71, 1894,  435,   70,  501,  439,
 /*   440 */   167, 1348, 1422, 1270, 1801,  137,  136,  612,  611,  610,
 /*   450 */  1819,  422,  209,  305,  167, 1415,  520,   49,  582, 1890,
 /*   460 */   167, 1297,  125, 1771, 1343,  581,  494, 1669,  167,   14,
 /*   470 */   488,  500, 1819,  167,  344,  208, 1278,  162, 1887, 1888,
 /*   480 */   582, 1892, 1473, 1667,  498, 1771,  496,  581, 1833,  617,
 /*   490 */  1789, 1758,   96, 1802,  584, 1804, 1805,  580,    2,  575,
 /*   500 */   558, 1785, 1879,  617,  177,  176, 1878, 1875,   58, 1089,
 /*   510 */  1833,   57, 1467,  374,   94, 1802,  584, 1804, 1805,  580,
 /*   520 */   668,  575,  343, 1602, 1879, 1781, 1787,  335,  306, 1875,
 /*   530 */   146, 1497,  376,  372, 1350, 1351,  385,  575,  362, 1619,
 /*   540 */  1945,  355, 1091, 1278,   33,   32, 1945,   74,   40,   38,
 /*   550 */    36,   35,   34,  164,   28,  443, 1358, 1942,  439, 1943,
 /*   560 */    33,   32, 1297, 1942,   40,   38,   36,   35,   34, 1613,
 /*   570 */    33,   32, 1771,  303,   40,   38,   36,   35,   34, 1299,
 /*   580 */  1273, 1945, 1271,   33,   32,   11,   10,   40,   38,   36,
 /*   590 */    35,   34,  317,  627,  164, 1496,  167,  307, 1942,  516,
 /*   600 */  1495,  562,  210, 1276, 1277,  560, 1325, 1326, 1328, 1329,
 /*   610 */  1330, 1331, 1332, 1333,  577,  573, 1341, 1342, 1344, 1345,
 /*   620 */  1346, 1347, 1349, 1352,   39,   37, 1801, 1310, 1604,  346,
 /*   630 */  1272,  353,  340, 1372, 1272, 1370, 1771,  146, 1710, 1945,
 /*   640 */  1327, 1771, 1801, 1270, 1594, 1348, 1619, 1270,  318,  175,
 /*   650 */   316,  315,  164,  476, 1819,  255, 1942,  478, 1669,   76,
 /*   660 */   305,  530,  582,  520,  639,  637, 1310, 1771, 1343,  581,
 /*   670 */  1819, 1945,  383,   84, 1668, 1384, 1278, 1592,  557,  477,
 /*   680 */  1278,  517, 1494, 1771,  164,  581, 1016, 1017, 1942, 1617,
 /*   690 */  1371, 1718, 1833, 1600, 1610,   27,   96, 1802,  584, 1804,
 /*   700 */  1805,  580,    8,  575, 1493, 1377, 1879, 1540, 1833, 1492,
 /*   710 */   569, 1875,   95, 1802,  584, 1804, 1805,  580,  252,  575,
 /*   720 */   668,  145, 1879, 1771,  668, 1300,  331, 1875,  159,   33,
 /*   730 */    32,    7, 1491,   40,   38,   36,   35,   34, 1350, 1351,
 /*   740 */   163, 1327,  146, 1408, 1490, 1771,  615, 1716, 1905,  300,
 /*   750 */  1771, 1620,   29,  338, 1365, 1366, 1367, 1368, 1369, 1373,
 /*   760 */  1374, 1375, 1376,  530, 1489,  137,  136,  612,  611,  610,
 /*   770 */  1297,  486,  485, 1771,  384, 1715, 1669,  300,  123,  615,
 /*   780 */  1273,  509, 1271,  312, 1273, 1771, 1271,   90,  481,  484,
 /*   790 */  1486, 1617, 1667, 1485,  480, 1899, 1404,   87,  137,  136,
 /*   800 */   612,  611,  610, 1276, 1277, 1771,  563, 1276, 1277, 1484,
 /*   810 */  1325, 1326, 1328, 1329, 1330, 1331, 1332, 1333,  577,  573,
 /*   820 */  1341, 1342, 1344, 1345, 1346, 1347, 1349, 1352,   39,   37,
 /*   830 */  1353, 1771, 1483,  213, 1771, 1894,  340,  530, 1272, 1801,
 /*   840 */   565,  167, 1608,  530, 1945,  486,  485,  352,  392, 1348,
 /*   850 */  1771, 1270,  123, 1785,  407, 1790, 1482,  165,  530, 1889,
 /*   860 */  1801, 1942,  481,  484,  232, 1617, 1785, 1819,  480,  408,
 /*   870 */   530, 1617, 1343, 1771, 1481,  557, 1480, 1781, 1787, 1488,
 /*   880 */  1771,  451,  581, 1577, 1278,  540, 1617, 1945, 1819,  575,
 /*   890 */  1781, 1787,  613,   44,    4, 1660,  579, 1771, 1617, 1479,
 /*   900 */   164, 1771,  575,  581, 1942, 1833,    9, 1478,  576,   95,
 /*   910 */  1802,  584, 1804, 1805,  580, 1771,  575, 1771,  614, 1879,
 /*   920 */  1404, 1660,  471,  331, 1875,  159, 1833, 1801,  668,  478,
 /*   930 */   293, 1802,  584, 1804, 1805,  580,  578,  575,  572, 1851,
 /*   940 */  1771,  272, 1350, 1351, 1647, 1906,  244,  135, 1771, 1327,
 /*   950 */   530,  477,   33,   32,  386, 1819,   40,   38,   36,   35,
 /*   960 */    34,  452,  201,  582,  608,  199,  530,  387, 1771, 1407,
 /*   970 */   581,  203, 1820,  205,  202,  530,  204, 1614, 1617,  207,
 /*   980 */   351,  530,  206,   53,  513,  530,  503,  571, 1273, 1280,
 /*   990 */  1271, 1511,  510, 1833, 1617,   54,  514,  289, 1802,  584,
 /*  1000 */  1804, 1805,  580, 1617,  575,  307,   11,   10, 1801, 1617,
 /*  1010 */   502, 1276, 1277, 1617, 1325, 1326, 1328, 1329, 1330, 1331,
 /*  1020 */  1332, 1333,  577,  573, 1341, 1342, 1344, 1345, 1346, 1347,
 /*  1030 */  1349, 1352,   39,   37, 1801,  549, 1819,  530, 1527, 1522,
 /*  1040 */   340, 1516, 1272, 1370,  582,  530, 1520,  566,  227, 1771,
 /*  1050 */  1945,  581, 1792, 1348,  216, 1270,  526, 1657,  530, 1056,
 /*  1060 */   487,  489, 1819,  164, 1909, 1617,  554, 1942,  492,  528,
 /*  1070 */   582, 1470, 1471, 1617, 1833, 1771, 1343,  581,  149, 1802,
 /*  1080 */   584, 1804, 1805,  580,  530,  575, 1617,   41, 1278,  663,
 /*  1090 */    77,  249, 1057,  221,  131,  529, 1794,  134, 1371,  254,
 /*  1100 */  1833,  257,  530,  671,   95, 1802,  584, 1804, 1805,  580,
 /*  1110 */     9,  575, 1617,  261, 1879,  259,  530,  267,  331, 1875,
 /*  1120 */  1958, 1362,  559, 1959,  135,    3,   51,  347, 1283, 1936,
 /*  1130 */  1617,  156,  668,  621,  236, 1223,  661,  657,  653,  649,
 /*  1140 */   265,  225,  523,    5, 1617,  229, 1350, 1351,   51,   41,
 /*  1150 */    41,  588,  134,  135,  119, 1075,  134,  356,  622,  313,
 /*  1160 */    29,  338, 1365, 1366, 1367, 1368, 1369, 1373, 1374, 1375,
 /*  1170 */  1376,  361, 1120,   92, 1429,  268,  230, 1239,  174,  388,
 /*  1180 */  1073, 1295,  239,  409, 1712,  416,  423,  424,  425,  429,
 /*  1190 */   431,  433, 1273, 1301, 1271,  434, 1378, 1334,  271, 1148,
 /*  1200 */  1152, 1159, 1157,  442,  138, 1303,  445,  183,  446,  527,
 /*  1210 */   185, 1801, 1302,  447, 1304, 1276, 1277,  188, 1325, 1326,
 /*  1220 */  1328, 1329, 1330, 1331, 1332, 1333,  577,  573, 1341, 1342,
 /*  1230 */  1344, 1345, 1346, 1347, 1349, 1352,   39,   37,  190, 1819,
 /*  1240 */   450,  448,  219,   72,  340,   73, 1272,  582,  454,  194,
 /*  1250 */   473,  475, 1771, 1607,  581,  198, 1603, 1348,  200, 1270,
 /*  1260 */  1246,  304,  212,  118,  140, 1751,  141, 1605,  269,  504,
 /*  1270 */  1601,  142,  143,  505,  211,  508,  214, 1833,  511,  515,
 /*  1280 */  1343,   96, 1802,  584, 1804, 1805,  580,  218,  575,  323,
 /*  1290 */   518, 1879, 1278,  538,  524,   81, 1876,  132, 1750,  147,
 /*  1300 */   525, 1722,  521,  133,  278,  337,  336,  270,  325,   83,
 /*  1310 */  1618, 1300,  541,  534,    2, 1286, 1910, 1920,  276,   60,
 /*  1320 */   234,  536,   59,  537, 1919,  330, 1348,  238, 1279,  544,
 /*  1330 */     6,  550,  532,  535, 1901, 1299,  668,  533,  180,  432,
 /*  1340 */   430, 1801,  248, 1404,  126,  567,  564,  153,   48, 1343,
 /*  1350 */  1350, 1351,   85,  332,  243, 1895,  586,  245,  246, 1661,
 /*  1360 */   273, 1278, 1590,  664,  247,  665,  264,  667,   52, 1819,
 /*  1370 */   277,   63, 1860,  253,  324,  299,  286,  582,  275,  296,
 /*  1380 */  1941, 1765, 1771,  295,  581, 1764,   65,  561, 1763, 1762,
 /*  1390 */  1961,  568,  256,   66, 1759,  358, 1273,  258, 1271,  359,
 /*  1400 */  1264, 1265,  170,  363, 1757,  570,  365, 1833,  366,   93,
 /*  1410 */   367,  294, 1802,  584, 1804, 1805,  580, 1756,  575, 1276,
 /*  1420 */  1277, 1801, 1325, 1326, 1328, 1329, 1330, 1331, 1332, 1333,
 /*  1430 */   577,  573, 1341, 1342, 1344, 1345, 1346, 1347, 1349, 1352,
 /*  1440 */   369, 1755, 1801,  371, 1754,   68,   67,  382,  373, 1819,
 /*  1450 */   171, 1753, 1242,  375,  531, 1241, 1733,  582,  380,  381,
 /*  1460 */  1731, 1730, 1771, 1732,  581, 1287,  301, 1282, 1211,  370,
 /*  1470 */  1819,  368,  364,  360,  357,  354,  129, 1702,  582, 1705,
 /*  1480 */  1704, 1703, 1701, 1771, 1700,  581,   69, 1833, 1290, 1292,
 /*  1490 */  1699,  294, 1802,  584, 1804, 1805,  580, 1698,  575, 1697,
 /*  1500 */   573, 1341, 1342, 1344, 1345, 1346, 1347, 1696, 1833, 1695,
 /*  1510 */   167, 1694,   95, 1802,  584, 1804, 1805,  580,  399,  575,
 /*  1520 */   398,  401, 1879, 1693, 1692, 1801,  331, 1875, 1958, 1691,
 /*  1530 */  1690, 1689, 1688, 1687, 1686, 1685, 1684, 1898, 1683, 1682,
 /*  1540 */  1681, 1801, 1680,  130, 1679, 1678, 1677, 1676, 1675, 1674,
 /*  1550 */  1213, 1673, 1672, 1819, 1671, 1670, 1542, 1541,  178,  179,
 /*  1560 */  1539,  582, 1507,  181,  120,  157, 1771, 1019,  581, 1819,
 /*  1570 */  1506, 1746, 1018,  438, 1740, 1729,  189,  582, 1049, 1538,
 /*  1580 */   121,  558, 1771,  440,  581, 1728, 1714, 1596, 1536, 1534,
 /*  1590 */   182, 1833, 1532, 1530,  455,  285, 1802,  584, 1804, 1805,
 /*  1600 */   580,  459,  575,  187,  457, 1519,  461, 1833,  456, 1801,
 /*  1610 */   460,  149, 1802,  584, 1804, 1805,  580,  463,  575,  464,
 /*  1620 */   465, 1945,  469,  468, 1518, 1801,  467, 1503, 1598, 1163,
 /*  1630 */  1162, 1597, 1088, 1087,  166, 1082, 1084, 1819, 1942,  636,
 /*  1640 */  1528, 1083,   50,  638,  319,  582, 1523,  320,  490, 1521,
 /*  1650 */  1771,  321,  581, 1819,  493, 1502, 1960, 1501,  495, 1500,
 /*  1660 */  1745,  579,   97,  499,   56,  558, 1771,  497,  581, 1248,
 /*  1670 */   197, 1739,  506,  144,  507, 1833,  215, 1727, 1725,  285,
 /*  1680 */  1802,  584, 1804, 1805,  580, 1726,  575, 1801, 1256, 1721,
 /*  1690 */   519, 1833, 1724, 1723,   15,  293, 1802,  584, 1804, 1805,
 /*  1700 */   580,  220,  575, 1713, 1852, 1945, 1801,  226,   79,   80,
 /*  1710 */    82,   87,  231,  242, 1792, 1819,   41,   47,  164,   16,
 /*  1720 */   339, 1444, 1942,  582,  235,   23,  522,  322, 1771,  233,
 /*  1730 */   581,   45,  251,  237, 1819,  228, 1426,  151,  512,  341,
 /*  1740 */   241,  240,  582, 1428,   24,   25,   86, 1771, 1456,  581,
 /*  1750 */    17,   46, 1421, 1833, 1401, 1400, 1791,  294, 1802,  584,
 /*  1760 */  1804, 1805,  580,  154,  575,   18, 1461, 1801,  196, 1455,
 /*  1770 */  1450,  333, 1833, 1460, 1459,  334,  294, 1802,  584, 1804,
 /*  1780 */  1805,  580,  152,  575,  553, 1801, 1288,  470,  466,  462,
 /*  1790 */   458,  195,   10,   19, 1836, 1819,  574, 1363, 1338,  155,
 /*  1800 */  1336,   31,   12,  582,  168, 1335,   20, 1318, 1771,  583,
 /*  1810 */   581,   21,  127, 1819, 1149,  587,  585,   13,  342,  589,
 /*  1820 */   592,  582, 1146,  591,   75, 1126, 1771,  193,  581,  594,
 /*  1830 */   597,  595,  558, 1833, 1143, 1801, 1137,  279, 1802,  584,
 /*  1840 */  1804, 1805,  580, 1135,  575,  598,  600,  601,  607, 1158,
 /*  1850 */   125, 1833,   88,   89, 1154,  280, 1802,  584, 1804, 1805,
 /*  1860 */   580, 1141,  575, 1819,   62,  250, 1887,  552, 1140,  551,
 /*  1870 */  1139,  582, 1945, 1138,  262, 1047, 1771,  616,  581, 1079,
 /*  1880 */  1078, 1077, 1076, 1074, 1072,  164, 1071, 1801, 1070, 1942,
 /*  1890 */   192,  186, 1095,  191,  626, 1068, 1067,  449,  263, 1066,
 /*  1900 */  1065, 1833, 1064, 1063, 1062,  281, 1802,  584, 1804, 1805,
 /*  1910 */   580, 1092,  575,  184, 1090, 1819, 1059, 1058, 1055, 1054,
 /*  1920 */  1053, 1052, 1535,  582,  646,  647,  648, 1533, 1771,  650,
 /*  1930 */   581, 1531,  651, 1529,  652, 1801,  654,  655,  656,  658,
 /*  1940 */   659,  660, 1517,  662, 1009, 1499,  266, 1801, 1274,  666,
 /*  1950 */   670,  274, 1474, 1833, 1474,  669, 1474,  288, 1802,  584,
 /*  1960 */  1804, 1805,  580, 1819,  575, 1474, 1474, 1474, 1474, 1474,
 /*  1970 */  1474,  582, 1474, 1474, 1474, 1819, 1771, 1474,  581, 1474,
 /*  1980 */  1474, 1474, 1474,  582, 1474, 1474, 1474, 1474, 1771, 1474,
 /*  1990 */   581, 1474, 1474, 1474, 1474, 1474, 1474, 1801, 1474, 1474,
 /*  2000 */  1474, 1833, 1474, 1474, 1474,  290, 1802,  584, 1804, 1805,
 /*  2010 */   580, 1474,  575, 1833, 1801, 1474, 1474,  282, 1802,  584,
 /*  2020 */  1804, 1805,  580, 1474,  575, 1819, 1474, 1474, 1474, 1474,
 /*  2030 */  1474, 1474, 1474,  582, 1474, 1474, 1474, 1474, 1771, 1474,
 /*  2040 */   581, 1474, 1819, 1474, 1474, 1474, 1474, 1474, 1474, 1474,
 /*  2050 */   582, 1474, 1474, 1474, 1474, 1771, 1474,  581, 1474, 1474,
 /*  2060 */  1474, 1474, 1474, 1833, 1474, 1474, 1474,  291, 1802,  584,
 /*  2070 */  1804, 1805,  580, 1474,  575, 1474, 1474, 1801, 1474, 1474,
 /*  2080 */  1833, 1474, 1474, 1474,  283, 1802,  584, 1804, 1805,  580,
 /*  2090 */  1474,  575, 1474, 1801, 1474, 1474, 1474, 1474, 1474, 1474,
 /*  2100 */  1474, 1474, 1474, 1474, 1474, 1819, 1474, 1474, 1474, 1474,
 /*  2110 */  1474, 1474, 1474,  582, 1474, 1474, 1474, 1474, 1771, 1474,
 /*  2120 */   581, 1819, 1474, 1474, 1474, 1474, 1474, 1474, 1474,  582,
 /*  2130 */  1474, 1474, 1474, 1474, 1771, 1474,  581, 1474, 1474, 1474,
 /*  2140 */  1474, 1474, 1474, 1833, 1474, 1801, 1474,  292, 1802,  584,
 /*  2150 */  1804, 1805,  580, 1474,  575, 1474, 1474, 1474, 1474, 1833,
 /*  2160 */  1474, 1801, 1474,  284, 1802,  584, 1804, 1805,  580, 1474,
 /*  2170 */   575, 1474, 1474, 1819, 1474, 1474, 1474, 1474, 1474, 1474,
 /*  2180 */  1474,  582, 1474, 1474, 1474, 1474, 1771, 1474,  581, 1819,
 /*  2190 */  1474, 1474, 1474, 1474, 1474, 1474, 1474,  582, 1474, 1474,
 /*  2200 */  1474, 1801, 1771, 1474,  581, 1474, 1474, 1474, 1474, 1474,
 /*  2210 */  1474, 1833, 1474, 1474, 1474,  297, 1802,  584, 1804, 1805,
 /*  2220 */   580, 1474,  575, 1801, 1474, 1474, 1474, 1833, 1474, 1819,
 /*  2230 */  1474,  298, 1802,  584, 1804, 1805,  580,  582,  575, 1474,
 /*  2240 */  1474, 1474, 1771, 1474,  581, 1474, 1474, 1474, 1474, 1474,
 /*  2250 */  1474, 1819, 1474, 1474, 1474, 1474, 1474, 1474, 1474,  582,
 /*  2260 */  1474, 1474, 1474, 1801, 1771, 1474,  581, 1833, 1474, 1474,
 /*  2270 */  1474, 1813, 1802,  584, 1804, 1805,  580, 1474,  575, 1474,
 /*  2280 */  1474, 1801, 1474, 1474, 1474, 1474, 1474, 1474, 1474, 1833,
 /*  2290 */  1474, 1819, 1474, 1812, 1802,  584, 1804, 1805,  580,  582,
 /*  2300 */   575, 1474, 1474, 1474, 1771, 1474,  581, 1474, 1474, 1819,
 /*  2310 */  1474, 1474, 1474, 1474, 1474, 1474, 1474,  582, 1474, 1474,
 /*  2320 */  1474, 1474, 1771, 1474,  581, 1474, 1474, 1474, 1474, 1833,
 /*  2330 */  1474, 1801, 1474, 1811, 1802,  584, 1804, 1805,  580, 1474,
 /*  2340 */   575, 1474, 1474, 1801, 1474, 1474, 1474, 1833, 1474, 1474,
 /*  2350 */  1474,  310, 1802,  584, 1804, 1805,  580, 1474,  575, 1819,
 /*  2360 */  1474, 1474, 1474, 1474, 1474, 1474, 1474,  582, 1474, 1474,
 /*  2370 */  1474, 1819, 1771, 1474,  581, 1474, 1474, 1474, 1474,  582,
 /*  2380 */  1474, 1474, 1474, 1474, 1771, 1474,  581, 1474, 1474, 1474,
 /*  2390 */  1474, 1474, 1474, 1474, 1801, 1474, 1474, 1833, 1474, 1474,
 /*  2400 */  1474,  309, 1802,  584, 1804, 1805,  580, 1474,  575, 1833,
 /*  2410 */  1474, 1474, 1474,  311, 1802,  584, 1804, 1805,  580, 1474,
 /*  2420 */   575, 1474, 1819, 1474, 1474, 1474, 1474, 1474, 1474, 1474,
 /*  2430 */   582, 1474, 1474, 1474, 1474, 1771, 1474,  581, 1474, 1474,
 /*  2440 */  1474, 1474, 1474, 1474, 1801, 1474, 1474, 1474, 1474, 1474,
 /*  2450 */  1474, 1474, 1474, 1474, 1474, 1474, 1474, 1474, 1474, 1474,
 /*  2460 */  1833, 1474, 1474, 1474,  308, 1802,  584, 1804, 1805,  580,
 /*  2470 */  1474,  575, 1819, 1474, 1474, 1474, 1474, 1474, 1474, 1474,
 /*  2480 */   582, 1474, 1474, 1474, 1474, 1771, 1474,  581, 1474, 1474,
 /*  2490 */  1474, 1474, 1474, 1474, 1474, 1474, 1474, 1474, 1474, 1474,
 /*  2500 */  1474, 1474, 1474, 1474, 1474, 1474, 1474, 1474, 1474, 1474,
 /*  2510 */  1833, 1474, 1474, 1474,  287, 1802,  584, 1804, 1805,  580,
 /*  2520 */  1474,  575,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   352,  309,  313,  317,  315,  316,  365,  359,    0,    4,
 /*    10 */   362,  317,   12,   13,  328,  338,  313,  317,  315,  316,
 /*    20 */    20,  335,   22,    0,   12,   13,   14,   15,   16,  337,
 /*    30 */   317,  345,  317,   33,   20,   35,   22,  345,  317,  345,
 /*    40 */    20,  328,  350,  328,  352,  345,  405,   24,   25,   26,
 /*    50 */    27,   28,   29,   30,   31,   32,   56,  365,  345,  418,
 /*    60 */   345,   61,  329,  422,   50,  365,  345,  375,   68,    0,
 /*    70 */   337,  379,  380,  381,  382,  383,  384,  383,  386,  346,
 /*    80 */   308,  389,  310,  383,  309,  393,  394,   20,    4,   35,
 /*    90 */    90,  397,  398,  399,  400,   90,  402,  405,  398,  399,
 /*   100 */   400,  337,  402,  348,  383,  405,  351,  352,  344,  322,
 /*   110 */   418,    0,  112,  326,  422,   60,  337,  353,  418,  398,
 /*   120 */   399,  400,  422,  402,  345,  350,  126,  127,   44,   45,
 /*   130 */   390,  391,   63,   64,   65,   66,   67,    0,   69,   70,
 /*   140 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   150 */    81,   82,   83,   84,   85,   86,   87,  325,   21,  327,
 /*   160 */   381,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   170 */    20,   60,  172,  377,  174,  103,  104,  105,  106,  107,
 /*   180 */   108,  109,  110,  111,  112,  113,  157,  115,  116,  117,
 /*   190 */   118,  119,  120,  126,  127,  195,  196,  401,  198,  199,
 /*   200 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,   12,   13,   14,  405,
 /*   220 */   339,   18,  336,   20,   20,  309,   22,  121,  174,  229,
 /*   230 */    27,  350,  418,   30,  229,  349,  422,   33,   21,   35,
 /*   240 */    90,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   250 */    47,   20,   49,  337,   51,  374,  375,  376,  321,   20,
 /*   260 */    56,  345,   20,  234,  235,   61,  350,  386,  352,    8,
 /*   270 */     9,  334,   68,   12,   13,   14,   15,   16,    8,    9,
 /*   280 */   343,   56,   12,   13,   14,   15,   16,  181,  182,   20,
 /*   290 */   405,  375,   89,  319,   90,  379,  380,  381,  382,  383,
 /*   300 */   384,   90,  386,  418,  101,  389,  332,  422,   20,  393,
 /*   310 */   394,  395,  351,  352,  340,   90,  112,   92,    8,    9,
 /*   320 */   404,   90,   12,   13,   14,   15,   16,   14,  195,   90,
 /*   330 */   126,  127,  129,   20,   90,  132,  133,  134,  135,  136,
 /*   340 */   137,  138,  139,  140,  141,  142,  143,  144,  145,  146,
 /*   350 */   147,  148,  149,   43,  151,  152,  153,  323,  324,    8,
 /*   360 */     9,   91,    3,   12,   13,   14,   15,   16,   20,  317,
 /*   370 */    22,  238,  239,  240,  241,  242,  172,  345,  174,    2,
 /*   380 */   328,   20,  171,   35,  173,    8,    9,  335,  356,   12,
 /*   390 */    13,   14,   15,   16,  121,  122,  317,  345,   50,  195,
 /*   400 */   196,   56,  198,  199,  200,  201,  202,  203,  204,  205,
 /*   410 */   206,  207,  208,  209,  210,  211,  212,  213,  214,  215,
 /*   420 */    12,   13,  309,    4,  345,  164,  102,  101,   20,    0,
 /*   430 */    22,   14,   15,   16,   89,  377,  314,   92,   19,  317,
 /*   440 */   229,   33,   91,   35,  309,  121,  122,  123,  124,  125,
 /*   450 */   337,   77,   33,  180,  229,   14,  183,   90,  345,  401,
 /*   460 */   229,   20,  383,  350,   56,  352,   47,  337,  229,   61,
 /*   470 */    51,   21,  337,  229,  344,   56,   68,  398,  399,  400,
 /*   480 */   345,  402,  306,  353,   34,  350,   36,  352,  375,   60,
 /*   490 */   339,    0,  379,  380,  381,  382,  383,  384,   90,  386,
 /*   500 */   365,  350,  389,   60,  130,  131,  393,  394,   89,   35,
 /*   510 */   375,   92,  251,  167,  379,  380,  381,  382,  383,  384,
 /*   520 */   112,  386,  329,  338,  389,  374,  375,  376,  393,  394,
 /*   530 */   337,  309,  186,  187,  126,  127,  317,  386,   47,  346,
 /*   540 */   405,  365,   68,   68,    8,    9,  405,  321,   12,   13,
 /*   550 */    14,   15,   16,  418,    2,  314,   14,  422,  317,  418,
 /*   560 */     8,    9,   20,  422,   12,   13,   14,   15,   16,  343,
 /*   570 */     8,    9,  350,  354,   12,   13,   14,   15,   16,   20,
 /*   580 */   172,  405,  174,    8,    9,    1,    2,   12,   13,   14,
 /*   590 */    15,   16,   37,   68,  418,  309,  229,   61,  422,  365,
 /*   600 */   309,   43,  122,  195,  196,  246,  198,  199,  200,  201,
 /*   610 */   202,  203,  204,  205,  206,  207,  208,  209,  210,  211,
 /*   620 */   212,  213,  214,  215,   12,   13,  309,   91,  338,  329,
 /*   630 */    22,  365,   20,  154,   22,   99,  350,  337,  345,  405,
 /*   640 */   199,  350,  309,   35,    0,   33,  346,   35,   93,  356,
 /*   650 */    95,   96,  418,   98,  337,  425,  422,  102,  337,  179,
 /*   660 */   180,  317,  345,  183,  323,  324,   91,  350,   56,  352,
 /*   670 */   337,  405,  328,  319,  353,   91,   68,    0,  345,  124,
 /*   680 */    68,  352,  309,  350,  418,  352,   44,   45,  422,  345,
 /*   690 */   154,  362,  375,  338,  340,  216,  379,  380,  381,  382,
 /*   700 */   383,  384,   90,  386,  309,  226,  389,    0,  375,  309,
 /*   710 */   393,  394,  379,  380,  381,  382,  383,  384,  159,  386,
 /*   720 */   112,  159,  389,  350,  112,   20,  393,  394,  395,    8,
 /*   730 */     9,   39,  309,   12,   13,   14,   15,   16,  126,  127,
 /*   740 */   407,  199,  337,    4,  309,  350,  102,  361,  415,  363,
 /*   750 */   350,  346,  216,  217,  218,  219,  220,  221,  222,  223,
 /*   760 */   224,  225,  226,  317,  309,  121,  122,  123,  124,  125,
 /*   770 */    20,   64,   65,  350,  328,  361,  337,  363,   71,  102,
 /*   780 */   172,  369,  174,  344,  172,  350,  174,   90,   81,   82,
 /*   790 */   309,  345,  353,  309,   87,  227,  228,  100,  121,  122,
 /*   800 */   123,  124,  125,  195,  196,  350,  248,  195,  196,  309,
 /*   810 */   198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
 /*   820 */   208,  209,  210,  211,  212,  213,  214,  215,   12,   13,
 /*   830 */    14,  350,  309,  338,  350,  377,   20,  317,   22,  309,
 /*   840 */    43,  229,  339,  317,  405,   64,   65,  365,  328,   33,
 /*   850 */   350,   35,   71,  350,  328,  339,  309,  418,  317,  401,
 /*   860 */   309,  422,   81,   82,  159,  345,  350,  337,   87,  328,
 /*   870 */   317,  345,   56,  350,  309,  345,  309,  374,  375,  310,
 /*   880 */   350,  328,  352,  326,   68,  416,  345,  405,  337,  386,
 /*   890 */   374,  375,  347,   42,   43,  350,  345,  350,  345,  309,
 /*   900 */   418,  350,  386,  352,  422,  375,   90,  309,  338,  379,
 /*   910 */   380,  381,  382,  383,  384,  350,  386,  350,  347,  389,
 /*   920 */   228,  350,  318,  393,  394,  395,  375,  309,  112,  102,
 /*   930 */   379,  380,  381,  382,  383,  384,  385,  386,  387,  388,
 /*   940 */   350,  330,  126,  127,  333,  415,  412,   43,  350,  199,
 /*   950 */   317,  124,    8,    9,   22,  337,   12,   13,   14,   15,
 /*   960 */    16,  328,   94,  345,  338,   97,  317,   35,  350,  230,
 /*   970 */   352,   94,  337,   94,   97,  317,   97,  328,  345,   94,
 /*   980 */   318,  317,   97,  159,  160,  317,  328,   61,  172,   35,
 /*   990 */   174,  316,  328,  375,  345,   91,  328,  379,  380,  381,
 /*  1000 */   382,  383,  384,  345,  386,   61,    1,    2,  309,  345,
 /*  1010 */   365,  195,  196,  345,  198,  199,  200,  201,  202,  203,
 /*  1020 */   204,  205,  206,  207,  208,  209,  210,  211,  212,  213,
 /*  1030 */   214,  215,   12,   13,  309,  417,  337,  317,    0,    0,
 /*  1040 */    20,    0,   22,   99,  345,  317,    0,  250,  328,  350,
 /*  1050 */   405,  352,   46,   33,   56,   35,  328,  349,  317,   35,
 /*  1060 */    22,   22,  337,  418,  378,  345,  403,  422,   22,  328,
 /*  1070 */   345,  126,  127,  345,  375,  350,   56,  352,  379,  380,
 /*  1080 */   381,  382,  383,  384,  317,  386,  345,   43,   68,   48,
 /*  1090 */    92,  396,   68,   43,   43,  328,   90,   43,  154,  419,
 /*  1100 */   375,  419,  317,   19,  379,  380,  381,  382,  383,  384,
 /*  1110 */    90,  386,  345,  328,  389,  419,  317,   33,  393,  394,
 /*  1120 */   395,  195,  423,  424,   43,  406,   43,  328,  174,  404,
 /*  1130 */   345,   47,  112,   13,   43,   91,   52,   53,   54,   55,
 /*  1140 */    56,   91,   91,  231,  345,   91,  126,  127,   43,   43,
 /*  1150 */    43,   43,   43,   43,   43,   35,   43,  373,   13,  372,
 /*  1160 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*  1170 */   226,   47,   91,   89,   91,  367,   92,  170,   42,  357,
 /*  1180 */    35,   20,   91,  317,  317,  357,  355,  154,  355,  317,
 /*  1190 */   317,  317,  172,   20,  174,  311,   91,   91,   91,   91,
 /*  1200 */    91,   91,   91,  311,   91,   20,  371,  321,  352,  125,
 /*  1210 */   321,  309,   20,  364,   20,  195,  196,  321,  198,  199,
 /*  1220 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*  1230 */   210,  211,  212,  213,  214,  215,   12,   13,  321,  337,
 /*  1240 */   364,  366,  158,  321,   20,  321,   22,  345,  317,  321,
 /*  1250 */   311,  337,  350,  337,  352,  337,  337,   33,  337,   35,
 /*  1260 */   176,  311,  178,  317,  337,  350,  337,  337,  371,  177,
 /*  1270 */   337,  337,  337,  370,  319,  352,  319,  375,  317,  317,
 /*  1280 */    56,  379,  380,  381,  382,  383,  384,  319,  386,  364,
 /*  1290 */   350,  389,   68,  236,  156,  319,  394,  360,  350,   18,
 /*  1300 */   358,  350,  350,  360,   23,   12,   13,  333,  350,  319,
 /*  1310 */   345,   20,  237,  350,   90,   22,  378,  411,   37,   38,
 /*  1320 */   360,  350,   41,  350,  411,  350,   33,  360,   35,  350,
 /*  1330 */   243,  163,  232,  245,  414,   20,  112,  244,   57,   58,
 /*  1340 */    59,  309,  373,  228,  345,  249,  247,  411,   90,   56,
 /*  1350 */   126,  127,   90,  252,  413,  377,  341,  410,  409,  350,
 /*  1360 */   317,   68,  327,   36,  408,  312,  319,  311,  368,  337,
 /*  1370 */   307,   90,  392,  420,  342,  363,  331,  345,  320,  331,
 /*  1380 */   421,    0,  350,  331,  352,    0,  179,  421,    0,    0,
 /*  1390 */   426,  421,  420,   42,    0,   35,  172,  420,  174,  189,
 /*  1400 */    35,   35,   35,  189,    0,  112,   35,  375,   35,  128,
 /*  1410 */   189,  379,  380,  381,  382,  383,  384,    0,  386,  195,
 /*  1420 */   196,  309,  198,  199,  200,  201,  202,  203,  204,  205,
 /*  1430 */   206,  207,  208,  209,  210,  211,  212,  213,  214,  215,
 /*  1440 */   189,    0,  309,   35,    0,  164,  165,  166,   22,  337,
 /*  1450 */   169,    0,  174,   35,  342,  172,    0,  345,  168,  167,
 /*  1460 */     0,    0,  350,    0,  352,  172,  185,  174,   46,  188,
 /*  1470 */   337,  190,  191,  192,  193,  194,   42,    0,  345,    0,
 /*  1480 */     0,    0,    0,  350,    0,  352,  150,  375,  195,  196,
 /*  1490 */     0,  379,  380,  381,  382,  383,  384,    0,  386,    0,
 /*  1500 */   207,  208,  209,  210,  211,  212,  213,    0,  375,    0,
 /*  1510 */   229,    0,  379,  380,  381,  382,  383,  384,   35,  386,
 /*  1520 */   145,  145,  389,    0,    0,  309,  393,  394,  395,    0,
 /*  1530 */     0,    0,    0,    0,    0,    0,    0,  404,    0,    0,
 /*  1540 */     0,  309,    0,   42,    0,    0,    0,    0,    0,    0,
 /*  1550 */    22,    0,    0,  337,    0,    0,    0,    0,   56,   56,
 /*  1560 */     0,  345,    0,   42,   39,   43,  350,   14,  352,  337,
 /*  1570 */     0,    0,   14,   46,    0,    0,  163,  345,   62,    0,
 /*  1580 */    39,  365,  350,   46,  352,    0,    0,    0,    0,    0,
 /*  1590 */    40,  375,    0,    0,   35,  379,  380,  381,  382,  383,
 /*  1600 */   384,   35,  386,   39,   39,    0,   39,  375,   47,  309,
 /*  1610 */    47,  379,  380,  381,  382,  383,  384,   35,  386,   47,
 /*  1620 */    39,  405,   39,   47,    0,  309,   35,    0,    0,   35,
 /*  1630 */    22,    0,   35,   35,  418,   22,   35,  337,  422,   43,
 /*  1640 */     0,   35,   99,   43,   22,  345,    0,   22,   49,    0,
 /*  1650 */   350,   22,  352,  337,   35,    0,  424,    0,   35,    0,
 /*  1660 */     0,  345,   20,   22,  159,  365,  350,   35,  352,   35,
 /*  1670 */    97,    0,   22,  175,  159,  375,  156,    0,    0,  379,
 /*  1680 */   380,  381,  382,  383,  384,    0,  386,  309,   35,    0,
 /*  1690 */   184,  375,    0,    0,   90,  379,  380,  381,  382,  383,
 /*  1700 */   384,   91,  386,    0,  388,  405,  309,   90,   90,   39,
 /*  1710 */    90,  100,   46,   46,   46,  337,   43,   43,  418,  233,
 /*  1720 */   342,   91,  422,  345,   91,   90,  157,  159,  350,   90,
 /*  1730 */   352,  227,   46,   90,  337,  155,   91,   90,  161,  342,
 /*  1740 */    43,   90,  345,   91,   90,   43,   90,  350,   35,  352,
 /*  1750 */   233,   43,   91,  375,   91,   91,   46,  379,  380,  381,
 /*  1760 */   382,  383,  384,   46,  386,   43,   91,  309,   33,   35,
 /*  1770 */    91,   35,  375,   35,   35,   35,  379,  380,  381,  382,
 /*  1780 */   383,  384,   47,  386,  317,  309,   22,   52,   53,   54,
 /*  1790 */    55,   56,    2,   43,   90,  337,   90,  195,   91,   46,
 /*  1800 */    91,   90,   90,  345,   46,   91,   90,   22,  350,  197,
 /*  1810 */   352,   90,  345,  337,   91,   35,  101,  233,   35,   90,
 /*  1820 */    90,  345,   91,   35,   89,   22,  350,   92,  352,   35,
 /*  1830 */    35,   90,  365,  375,   91,  309,   91,  379,  380,  381,
 /*  1840 */   382,  383,  384,   91,  386,   90,   35,   90,  102,   35,
 /*  1850 */   383,  375,   90,   90,   22,  379,  380,  381,  382,  383,
 /*  1860 */   384,  114,  386,  337,   90,  398,  399,  400,  114,  402,
 /*  1870 */   114,  345,  405,  114,   43,   62,  350,   61,  352,   35,
 /*  1880 */    35,   35,   35,   35,   35,  418,   35,  309,   35,  422,
 /*  1890 */   155,  156,   68,  158,   88,   35,   35,  162,   43,   22,
 /*  1900 */    35,  375,   22,   35,   35,  379,  380,  381,  382,  383,
 /*  1910 */   384,   68,  386,  178,   35,  337,   35,   35,   35,   35,
 /*  1920 */    22,   35,    0,  345,   35,   47,   39,    0,  350,   35,
 /*  1930 */   352,    0,   47,    0,   39,  309,   35,   47,   39,   35,
 /*  1940 */    47,   39,    0,   35,   35,    0,   22,  309,   22,   21,
 /*  1950 */    20,   22,  427,  375,  427,   21,  427,  379,  380,  381,
 /*  1960 */   382,  383,  384,  337,  386,  427,  427,  427,  427,  427,
 /*  1970 */   427,  345,  427,  427,  427,  337,  350,  427,  352,  427,
 /*  1980 */   427,  427,  427,  345,  427,  427,  427,  427,  350,  427,
 /*  1990 */   352,  427,  427,  427,  427,  427,  427,  309,  427,  427,
 /*  2000 */   427,  375,  427,  427,  427,  379,  380,  381,  382,  383,
 /*  2010 */   384,  427,  386,  375,  309,  427,  427,  379,  380,  381,
 /*  2020 */   382,  383,  384,  427,  386,  337,  427,  427,  427,  427,
 /*  2030 */   427,  427,  427,  345,  427,  427,  427,  427,  350,  427,
 /*  2040 */   352,  427,  337,  427,  427,  427,  427,  427,  427,  427,
 /*  2050 */   345,  427,  427,  427,  427,  350,  427,  352,  427,  427,
 /*  2060 */   427,  427,  427,  375,  427,  427,  427,  379,  380,  381,
 /*  2070 */   382,  383,  384,  427,  386,  427,  427,  309,  427,  427,
 /*  2080 */   375,  427,  427,  427,  379,  380,  381,  382,  383,  384,
 /*  2090 */   427,  386,  427,  309,  427,  427,  427,  427,  427,  427,
 /*  2100 */   427,  427,  427,  427,  427,  337,  427,  427,  427,  427,
 /*  2110 */   427,  427,  427,  345,  427,  427,  427,  427,  350,  427,
 /*  2120 */   352,  337,  427,  427,  427,  427,  427,  427,  427,  345,
 /*  2130 */   427,  427,  427,  427,  350,  427,  352,  427,  427,  427,
 /*  2140 */   427,  427,  427,  375,  427,  309,  427,  379,  380,  381,
 /*  2150 */   382,  383,  384,  427,  386,  427,  427,  427,  427,  375,
 /*  2160 */   427,  309,  427,  379,  380,  381,  382,  383,  384,  427,
 /*  2170 */   386,  427,  427,  337,  427,  427,  427,  427,  427,  427,
 /*  2180 */   427,  345,  427,  427,  427,  427,  350,  427,  352,  337,
 /*  2190 */   427,  427,  427,  427,  427,  427,  427,  345,  427,  427,
 /*  2200 */   427,  309,  350,  427,  352,  427,  427,  427,  427,  427,
 /*  2210 */   427,  375,  427,  427,  427,  379,  380,  381,  382,  383,
 /*  2220 */   384,  427,  386,  309,  427,  427,  427,  375,  427,  337,
 /*  2230 */   427,  379,  380,  381,  382,  383,  384,  345,  386,  427,
 /*  2240 */   427,  427,  350,  427,  352,  427,  427,  427,  427,  427,
 /*  2250 */   427,  337,  427,  427,  427,  427,  427,  427,  427,  345,
 /*  2260 */   427,  427,  427,  309,  350,  427,  352,  375,  427,  427,
 /*  2270 */   427,  379,  380,  381,  382,  383,  384,  427,  386,  427,
 /*  2280 */   427,  309,  427,  427,  427,  427,  427,  427,  427,  375,
 /*  2290 */   427,  337,  427,  379,  380,  381,  382,  383,  384,  345,
 /*  2300 */   386,  427,  427,  427,  350,  427,  352,  427,  427,  337,
 /*  2310 */   427,  427,  427,  427,  427,  427,  427,  345,  427,  427,
 /*  2320 */   427,  427,  350,  427,  352,  427,  427,  427,  427,  375,
 /*  2330 */   427,  309,  427,  379,  380,  381,  382,  383,  384,  427,
 /*  2340 */   386,  427,  427,  309,  427,  427,  427,  375,  427,  427,
 /*  2350 */   427,  379,  380,  381,  382,  383,  384,  427,  386,  337,
 /*  2360 */   427,  427,  427,  427,  427,  427,  427,  345,  427,  427,
 /*  2370 */   427,  337,  350,  427,  352,  427,  427,  427,  427,  345,
 /*  2380 */   427,  427,  427,  427,  350,  427,  352,  427,  427,  427,
 /*  2390 */   427,  427,  427,  427,  309,  427,  427,  375,  427,  427,
 /*  2400 */   427,  379,  380,  381,  382,  383,  384,  427,  386,  375,
 /*  2410 */   427,  427,  427,  379,  380,  381,  382,  383,  384,  427,
 /*  2420 */   386,  427,  337,  427,  427,  427,  427,  427,  427,  427,
 /*  2430 */   345,  427,  427,  427,  427,  350,  427,  352,  427,  427,
 /*  2440 */   427,  427,  427,  427,  309,  427,  427,  427,  427,  427,
 /*  2450 */   427,  427,  427,  427,  427,  427,  427,  427,  427,  427,
 /*  2460 */   375,  427,  427,  427,  379,  380,  381,  382,  383,  384,
 /*  2470 */   427,  386,  337,  427,  427,  427,  427,  427,  427,  427,
 /*  2480 */   345,  427,  427,  427,  427,  350,  427,  352,  427,  427,
 /*  2490 */   427,  427,  427,  427,  427,  427,  427,  427,  427,  427,
 /*  2500 */   427,  427,  427,  427,  427,  427,  427,  427,  427,  427,
 /*  2510 */   375,  427,  427,  427,  379,  380,  381,  382,  383,  384,
 /*  2520 */   427,  386,
};
#define YY_SHIFT_COUNT    (671)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1945)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1281,    0,    0,  204,  204,  408,  408,  408,  612,  612,
 /*    10 */   408,  408,  816, 1020, 1224, 1020, 1020, 1020, 1020, 1020,
 /*    20 */  1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
 /*    30 */  1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
 /*    40 */  1020, 1020,  231,  231,  150,  150,  150, 1293, 1293,  239,
 /*    50 */  1293, 1293,  211,  225,  244,  367,  244,   20,   20,   84,
 /*    60 */    84,    5,   67,  244,  244,   20,   20,   20,   20,   20,
 /*    70 */    20,   20,   20,   20,   20,   55,   20,   20,   20,  242,
 /*    80 */    20,   20,  269,   20,   20,  269,  288,   20,  269,  269,
 /*    90 */   269,   20,  443,  203,  536,  944,  944,  217,  608,  608,
 /*   100 */   608,  608,  608,  608,  608,  608,  608,  608,  608,  608,
 /*   110 */   608,  608,  608,  608,  608,  608,  608,  555,  781,   67,
 /*   120 */   313,  313,  111,  474,  429,  559,  559,  559,  474,  361,
 /*   130 */   361,  242,    8,    8,  269,  269,  475,  475,  326,  525,
 /*   140 */    72,   72,   72,   72,   72,   72,   72, 1084,  137,  261,
 /*   150 */   707,  133,  348,   29,  441,  542,   14,  642,  827,  705,
 /*   160 */   568,  692,  568,  851,  359,  359,  359,  739,  750,  912,
 /*   170 */  1124, 1007, 1136, 1161, 1161, 1136, 1033, 1033, 1161, 1161,
 /*   180 */  1161, 1173, 1173, 1185,   55,  242,   55, 1192, 1194,   55,
 /*   190 */  1192,   55,   55,   55, 1161,   55, 1173,  269,  269,  269,
 /*   200 */   269,  269,  269,  269,  269,  269,  269,  269, 1161, 1173,
 /*   210 */   475, 1185,  443, 1092,  242,  443, 1161, 1161, 1192,  443,
 /*   220 */  1057,  475,  475,  475,  475, 1057,  475, 1138,  443,  326,
 /*   230 */   443,  361, 1291,  475, 1075, 1057,  475,  475, 1075, 1057,
 /*   240 */   475,  475,  269, 1087, 1168, 1075, 1088, 1093, 1100,  912,
 /*   250 */  1115,  361, 1315, 1096, 1099, 1101, 1096, 1099, 1096, 1099,
 /*   260 */  1258, 1262,  475,  525, 1161,  443, 1327, 1173, 2522, 2522,
 /*   270 */  2522, 2522, 2522, 2522, 2522,   69, 1735,   23,  419,  270,
 /*   280 */   310,  351,  377,  552,  562,  575,  644,  721,  721,  721,
 /*   290 */   721,  721,  721,  721,  721,  677,  324,   12,   12,  480,
 /*   300 */   273,  346,  345,  374,  450,  106,  584,  479,  417,  417,
 /*   310 */   417,  417,  904,  491,  932,  868,  877,  879,  885, 1038,
 /*   320 */  1039, 1046,  998,  824, 1044, 1050, 1051, 1054, 1081, 1083,
 /*   330 */  1091, 1005,  945,  558,  797, 1105,   54,  954,  926, 1106,
 /*   340 */  1006, 1107, 1108, 1109, 1110, 1111, 1113,  697, 1120, 1145,
 /*   350 */  1024, 1041, 1381, 1385, 1207, 1388, 1389, 1351, 1394, 1360,
 /*   360 */  1210, 1365, 1366, 1367, 1214, 1404, 1371, 1373, 1221, 1417,
 /*   370 */  1251, 1441, 1408, 1444, 1426, 1451, 1418, 1278, 1283, 1456,
 /*   380 */  1463, 1290, 1292, 1460, 1461, 1422, 1479, 1480, 1481, 1434,
 /*   390 */  1477, 1482, 1484, 1336, 1490, 1497, 1499, 1507, 1509, 1375,
 /*   400 */  1483, 1511, 1376, 1523, 1524, 1529, 1530, 1531, 1532, 1533,
 /*   410 */  1534, 1535, 1536, 1538, 1539, 1540, 1542, 1501, 1544, 1545,
 /*   420 */  1546, 1547, 1548, 1549, 1528, 1551, 1552, 1554, 1555, 1556,
 /*   430 */  1502, 1557, 1503, 1560, 1562, 1521, 1525, 1522, 1553, 1527,
 /*   440 */  1558, 1537, 1570, 1550, 1541, 1571, 1574, 1575, 1564, 1413,
 /*   450 */  1585, 1586, 1587, 1516, 1579, 1588, 1559, 1561, 1565, 1589,
 /*   460 */  1566, 1563, 1567, 1592, 1582, 1572, 1581, 1593, 1591, 1576,
 /*   470 */  1583, 1605, 1624, 1627, 1628, 1543, 1573, 1594, 1608, 1631,
 /*   480 */  1597, 1598, 1596, 1600, 1601, 1606, 1613, 1640, 1622, 1646,
 /*   490 */  1625, 1599, 1649, 1629, 1619, 1655, 1623, 1657, 1632, 1659,
 /*   500 */  1641, 1642, 1660, 1505, 1634, 1671, 1498, 1650, 1515, 1520,
 /*   510 */  1677, 1678, 1568, 1577, 1685, 1692, 1693, 1604, 1610, 1653,
 /*   520 */  1506, 1689, 1617, 1569, 1618, 1703, 1670, 1580, 1620, 1611,
 /*   530 */  1666, 1673, 1486, 1635, 1630, 1639, 1633, 1645, 1643, 1674,
 /*   540 */  1652, 1647, 1651, 1654, 1661, 1697, 1667, 1668, 1656, 1702,
 /*   550 */  1517, 1663, 1664, 1686, 1504, 1708, 1710, 1717, 1675, 1722,
 /*   560 */  1584, 1679, 1713, 1734, 1736, 1738, 1739, 1740, 1679, 1790,
 /*   570 */  1764, 1602, 1750, 1704, 1707, 1706, 1709, 1711, 1714, 1753,
 /*   580 */  1712, 1716, 1758, 1785, 1612, 1721, 1715, 1723, 1780, 1783,
 /*   590 */  1729, 1731, 1788, 1730, 1743, 1794, 1741, 1745, 1795, 1755,
 /*   600 */  1752, 1811, 1757, 1747, 1754, 1756, 1759, 1803, 1746, 1762,
 /*   610 */  1763, 1814, 1774, 1831, 1831, 1832, 1813, 1816, 1844, 1845,
 /*   620 */  1846, 1847, 1848, 1849, 1851, 1853, 1824, 1806, 1855, 1860,
 /*   630 */  1861, 1877, 1865, 1880, 1868, 1869, 1843, 1596, 1879, 1600,
 /*   640 */  1881, 1882, 1883, 1884, 1898, 1886, 1922, 1889, 1878, 1887,
 /*   650 */  1927, 1894, 1885, 1895, 1931, 1901, 1890, 1899, 1933, 1904,
 /*   660 */  1893, 1902, 1942, 1908, 1909, 1945, 1924, 1928, 1926, 1929,
 /*   670 */  1934, 1930,
};
#define YY_REDUCE_COUNT (274)
#define YY_REDUCE_MIN   (-359)
#define YY_REDUCE_MAX   (2135)
static const short yy_reduce_ofst[] = {
 /*     0 */   176, -308,  135,  333,  530,  -84,  725, 1133, 1216, 1300,
 /*    10 */   113,  317,  551,  699,  902, 1032, 1112,  618, 1232, 1316,
 /*    20 */  1378, 1397, 1458, 1476, 1526, 1578, 1626, 1638, 1688, 1705,
 /*    30 */  1768, 1784, 1836, 1852, 1892, 1914, 1954, 1972, 2022, 2034,
 /*    40 */  2085, 2135, -300, 1467, -306, -279,   79, -119,  151,  439,
 /*    50 */   503,  516, -359,  234,  266,  482,  645, -314,   52, -311,
 /*    60 */  -297, -186, -245, -115,  141, -287, -285,  344,  446,  520,
 /*    70 */   526,  541,  553,  633,  649,  -63,  658,  664,  668, -352,
 /*    80 */   720,  728, -267,  741,  767, -236, -221,  785,  193,  130,
 /*    90 */   300,  799,  -26,  219, -260, -260, -260, -228, -225,  222,
 /*   100 */   286,  291,  373,  395,  400,  423,  435,  455,  481,  484,
 /*   110 */   500,  523,  547,  565,  567,  590,  598, -114, -213,  -39,
 /*   120 */   122,  241,  226,   34,  354, -204,   58,  458,  341,   32,
 /*   130 */   293,  329,  386,  414,  405,  321,  545,  571,  611, -168,
 /*   140 */  -323,  185,  290,  355,  495,  570,  626,  412,  569,  230,
 /*   150 */   557,  469,  604,  534,  635,  635,  662,  675,  708,  686,
 /*   160 */   663,  663,  663,  695,  680,  682,  696,  719,  635,  784,
 /*   170 */   787,  808,  822,  866,  867,  828,  831,  833,  872,  873,
 /*   180 */   874,  884,  892,  835,  886,  856,  889,  849,  875,  896,
 /*   190 */   876,  917,  922,  924,  931,  928,  939,  914,  916,  918,
 /*   200 */   919,  921,  927,  929,  930,  933,  934,  935,  946,  950,
 /*   210 */   915,  897,  955,  903,  923,  957,  961,  962,  925,  968,
 /*   220 */   937,  940,  948,  951,  952,  943,  958,  942,  976,  974,
 /*   230 */   990,  965,  938,  963,  906,  960,  971,  973,  913,  967,
 /*   240 */   975,  979,  635,  920,  941,  936,  947,  949,  956,  969,
 /*   250 */   663,  999,  978,  959,  953,  964,  966,  972,  970,  977,
 /*   260 */   980, 1015, 1009, 1035, 1043, 1047, 1053, 1056, 1000, 1012,
 /*   270 */  1045, 1048, 1052, 1058, 1063,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*    10 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*    20 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*    30 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*    40 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*    50 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*    60 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*    70 */  1472, 1472, 1472, 1472, 1472, 1546, 1472, 1472, 1472, 1472,
 /*    80 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*    90 */  1472, 1472, 1544, 1706, 1472, 1881, 1472, 1472, 1472, 1472,
 /*   100 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   110 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   120 */  1472, 1472, 1546, 1472, 1544, 1893, 1893, 1893, 1472, 1472,
 /*   130 */  1472, 1472, 1747, 1747, 1472, 1472, 1472, 1472, 1646, 1472,
 /*   140 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1741, 1472, 1962,
 /*   150 */  1472, 1472, 1472, 1916, 1472, 1472, 1472, 1472, 1599, 1908,
 /*   160 */  1885, 1899, 1886, 1883, 1947, 1947, 1947, 1902, 1472, 1912,
 /*   170 */  1472, 1734, 1711, 1472, 1472, 1711, 1708, 1708, 1472, 1472,
 /*   180 */  1472, 1472, 1472, 1472, 1546, 1472, 1546, 1472, 1472, 1546,
 /*   190 */  1472, 1546, 1546, 1546, 1472, 1546, 1472, 1472, 1472, 1472,
 /*   200 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   210 */  1472, 1472, 1544, 1743, 1472, 1544, 1472, 1472, 1472, 1544,
 /*   220 */  1921, 1472, 1472, 1472, 1472, 1921, 1472, 1472, 1544, 1472,
 /*   230 */  1544, 1472, 1472, 1472, 1923, 1921, 1472, 1472, 1923, 1921,
 /*   240 */  1472, 1472, 1472, 1935, 1931, 1923, 1939, 1937, 1914, 1912,
 /*   250 */  1899, 1472, 1472, 1953, 1949, 1965, 1953, 1949, 1953, 1949,
 /*   260 */  1472, 1615, 1472, 1472, 1472, 1544, 1504, 1472, 1736, 1747,
 /*   270 */  1649, 1649, 1649, 1547, 1477, 1472, 1472, 1472, 1472, 1472,
 /*   280 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1818, 1934, 1933,
 /*   290 */  1857, 1856, 1855, 1853, 1817, 1472, 1611, 1816, 1815, 1472,
 /*   300 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1809, 1810,
 /*   310 */  1808, 1807, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   320 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   330 */  1472, 1882, 1472, 1950, 1954, 1472, 1472, 1472, 1472, 1472,
 /*   340 */  1793, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   350 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   360 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   370 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   380 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   390 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   400 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   410 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   420 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   430 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1509, 1472, 1472,
 /*   440 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   450 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   460 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   470 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   480 */  1472, 1472, 1582, 1581, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   490 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   500 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   510 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   520 */  1472, 1751, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   530 */  1472, 1915, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   540 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1793, 1472, 1932,
 /*   550 */  1472, 1892, 1888, 1472, 1472, 1884, 1792, 1472, 1472, 1948,
 /*   560 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1877,
 /*   570 */  1472, 1472, 1850, 1835, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   580 */  1472, 1472, 1472, 1472, 1803, 1472, 1472, 1472, 1472, 1472,
 /*   590 */  1643, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   600 */  1472, 1472, 1472, 1628, 1626, 1625, 1624, 1472, 1621, 1472,
 /*   610 */  1472, 1472, 1472, 1652, 1651, 1472, 1472, 1472, 1472, 1472,
 /*   620 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1565, 1472,
 /*   630 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1557, 1472, 1556,
 /*   640 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   650 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   660 */  1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472,
 /*   670 */  1472, 1472,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* SST_TRIGGER => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  253,  /*      AFTER => ABORT */
  253,  /*     ATTACH => ABORT */
  253,  /*     BEFORE => ABORT */
  253,  /*      BEGIN => ABORT */
  253,  /*     BITAND => ABORT */
  253,  /*     BITNOT => ABORT */
  253,  /*      BITOR => ABORT */
  253,  /*     BLOCKS => ABORT */
  253,  /*     CHANGE => ABORT */
  253,  /*      COMMA => ABORT */
  253,  /*    COMPACT => ABORT */
  253,  /*     CONCAT => ABORT */
  253,  /*   CONFLICT => ABORT */
  253,  /*       COPY => ABORT */
  253,  /*   DEFERRED => ABORT */
  253,  /* DELIMITERS => ABORT */
  253,  /*     DETACH => ABORT */
  253,  /*     DIVIDE => ABORT */
  253,  /*        DOT => ABORT */
  253,  /*       EACH => ABORT */
  253,  /*        END => ABORT */
  253,  /*       FAIL => ABORT */
  253,  /*       FILE => ABORT */
  253,  /*        FOR => ABORT */
  253,  /*       GLOB => ABORT */
  253,  /*         ID => ABORT */
  253,  /*  IMMEDIATE => ABORT */
  253,  /*     IMPORT => ABORT */
  253,  /*  INITIALLY => ABORT */
  253,  /*    INSTEAD => ABORT */
  253,  /*     ISNULL => ABORT */
  253,  /*        KEY => ABORT */
  253,  /*  NK_BITNOT => ABORT */
  253,  /*    NK_SEMI => ABORT */
  253,  /*    NOTNULL => ABORT */
  253,  /*         OF => ABORT */
  253,  /*       PLUS => ABORT */
  253,  /*  PRIVILEGE => ABORT */
  253,  /*      RAISE => ABORT */
  253,  /*    REPLACE => ABORT */
  253,  /*   RESTRICT => ABORT */
  253,  /*        ROW => ABORT */
  253,  /*       SEMI => ABORT */
  253,  /*       STAR => ABORT */
  253,  /*  STATEMENT => ABORT */
  253,  /*     STRING => ABORT */
  253,  /*      TIMES => ABORT */
  253,  /*     UPDATE => ABORT */
  253,  /*     VALUES => ABORT */
  253,  /*   VARIABLE => ABORT */
  253,  /*       VIEW => ABORT */
  253,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "MAXROWS",
  /*   70 */ "MINROWS",
  /*   71 */ "KEEP",
  /*   72 */ "PAGES",
  /*   73 */ "PAGESIZE",
  /*   74 */ "PRECISION",
  /*   75 */ "REPLICA",
  /*   76 */ "STRICT",
  /*   77 */ "VGROUPS",
  /*   78 */ "SINGLE_STABLE",
  /*   79 */ "RETENTIONS",
  /*   80 */ "SCHEMALESS",
  /*   81 */ "WAL_LEVEL",
  /*   82 */ "WAL_FSYNC_PERIOD",
  /*   83 */ "WAL_RETENTION_PERIOD",
  /*   84 */ "WAL_RETENTION_SIZE",
  /*   85 */ "WAL_ROLL_PERIOD",
  /*   86 */ "WAL_SEGMENT_SIZE",
  /*   87 */ "SST_TRIGGER",
  /*   88 */ "NK_COLON",
  /*   89 */ "TABLE",
  /*   90 */ "NK_LP",
  /*   91 */ "NK_RP",
  /*   92 */ "STABLE",
  /*   93 */ "ADD",
  /*   94 */ "COLUMN",
  /*   95 */ "MODIFY",
  /*   96 */ "RENAME",
  /*   97 */ "TAG",
  /*   98 */ "SET",
  /*   99 */ "NK_EQ",
  /*  100 */ "USING",
  /*  101 */ "TAGS",
  /*  102 */ "COMMENT",
  /*  103 */ "BOOL",
  /*  104 */ "TINYINT",
  /*  105 */ "SMALLINT",
  /*  106 */ "INT",
  /*  107 */ "INTEGER",
  /*  108 */ "BIGINT",
  /*  109 */ "FLOAT",
  /*  110 */ "DOUBLE",
  /*  111 */ "BINARY",
  /*  112 */ "TIMESTAMP",
  /*  113 */ "NCHAR",
  /*  114 */ "UNSIGNED",
  /*  115 */ "JSON",
  /*  116 */ "VARCHAR",
  /*  117 */ "MEDIUMBLOB",
  /*  118 */ "BLOB",
  /*  119 */ "VARBINARY",
  /*  120 */ "DECIMAL",
  /*  121 */ "MAX_DELAY",
  /*  122 */ "WATERMARK",
  /*  123 */ "ROLLUP",
  /*  124 */ "TTL",
  /*  125 */ "SMA",
  /*  126 */ "FIRST",
  /*  127 */ "LAST",
  /*  128 */ "SHOW",
  /*  129 */ "DATABASES",
  /*  130 */ "TABLES",
  /*  131 */ "STABLES",
  /*  132 */ "MNODES",
  /*  133 */ "MODULES",
  /*  134 */ "QNODES",
  /*  135 */ "FUNCTIONS",
  /*  136 */ "INDEXES",
  /*  137 */ "ACCOUNTS",
  /*  138 */ "APPS",
  /*  139 */ "CONNECTIONS",
  /*  140 */ "LICENCES",
  /*  141 */ "GRANTS",
  /*  142 */ "QUERIES",
  /*  143 */ "SCORES",
  /*  144 */ "TOPICS",
  /*  145 */ "VARIABLES",
  /*  146 */ "BNODES",
  /*  147 */ "SNODES",
  /*  148 */ "CLUSTER",
  /*  149 */ "TRANSACTIONS",
  /*  150 */ "DISTRIBUTED",
  /*  151 */ "CONSUMERS",
  /*  152 */ "SUBSCRIPTIONS",
  /*  153 */ "VNODES",
  /*  154 */ "LIKE",
  /*  155 */ "INDEX",
  /*  156 */ "FUNCTION",
  /*  157 */ "INTERVAL",
  /*  158 */ "TOPIC",
  /*  159 */ "AS",
  /*  160 */ "WITH",
  /*  161 */ "META",
  /*  162 */ "CONSUMER",
  /*  163 */ "GROUP",
  /*  164 */ "DESC",
  /*  165 */ "DESCRIBE",
  /*  166 */ "RESET",
  /*  167 */ "QUERY",
  /*  168 */ "CACHE",
  /*  169 */ "EXPLAIN",
  /*  170 */ "ANALYZE",
  /*  171 */ "VERBOSE",
  /*  172 */ "NK_BOOL",
  /*  173 */ "RATIO",
  /*  174 */ "NK_FLOAT",
  /*  175 */ "OUTPUTTYPE",
  /*  176 */ "AGGREGATE",
  /*  177 */ "BUFSIZE",
  /*  178 */ "STREAM",
  /*  179 */ "INTO",
  /*  180 */ "TRIGGER",
  /*  181 */ "AT_ONCE",
  /*  182 */ "WINDOW_CLOSE",
  /*  183 */ "IGNORE",
  /*  184 */ "EXPIRED",
  /*  185 */ "KILL",
  /*  186 */ "CONNECTION",
  /*  187 */ "TRANSACTION",
  /*  188 */ "BALANCE",
  /*  189 */ "VGROUP",
  /*  190 */ "MERGE",
  /*  191 */ "REDISTRIBUTE",
  /*  192 */ "SPLIT",
  /*  193 */ "DELETE",
  /*  194 */ "INSERT",
  /*  195 */ "NULL",
  /*  196 */ "NK_QUESTION",
  /*  197 */ "NK_ARROW",
  /*  198 */ "ROWTS",
  /*  199 */ "TBNAME",
  /*  200 */ "QSTART",
  /*  201 */ "QEND",
  /*  202 */ "QDURATION",
  /*  203 */ "WSTART",
  /*  204 */ "WEND",
  /*  205 */ "WDURATION",
  /*  206 */ "CAST",
  /*  207 */ "NOW",
  /*  208 */ "TODAY",
  /*  209 */ "TIMEZONE",
  /*  210 */ "CLIENT_VERSION",
  /*  211 */ "SERVER_VERSION",
  /*  212 */ "SERVER_STATUS",
  /*  213 */ "CURRENT_USER",
  /*  214 */ "COUNT",
  /*  215 */ "LAST_ROW",
  /*  216 */ "BETWEEN",
  /*  217 */ "IS",
  /*  218 */ "NK_LT",
  /*  219 */ "NK_GT",
  /*  220 */ "NK_LE",
  /*  221 */ "NK_GE",
  /*  222 */ "NK_NE",
  /*  223 */ "MATCH",
  /*  224 */ "NMATCH",
  /*  225 */ "CONTAINS",
  /*  226 */ "IN",
  /*  227 */ "JOIN",
  /*  228 */ "INNER",
  /*  229 */ "SELECT",
  /*  230 */ "DISTINCT",
  /*  231 */ "WHERE",
  /*  232 */ "PARTITION",
  /*  233 */ "BY",
  /*  234 */ "SESSION",
  /*  235 */ "STATE_WINDOW",
  /*  236 */ "SLIDING",
  /*  237 */ "FILL",
  /*  238 */ "VALUE",
  /*  239 */ "NONE",
  /*  240 */ "PREV",
  /*  241 */ "LINEAR",
  /*  242 */ "NEXT",
  /*  243 */ "HAVING",
  /*  244 */ "RANGE",
  /*  245 */ "EVERY",
  /*  246 */ "ORDER",
  /*  247 */ "SLIMIT",
  /*  248 */ "SOFFSET",
  /*  249 */ "LIMIT",
  /*  250 */ "OFFSET",
  /*  251 */ "ASC",
  /*  252 */ "NULLS",
  /*  253 */ "ABORT",
  /*  254 */ "AFTER",
  /*  255 */ "ATTACH",
  /*  256 */ "BEFORE",
  /*  257 */ "BEGIN",
  /*  258 */ "BITAND",
  /*  259 */ "BITNOT",
  /*  260 */ "BITOR",
  /*  261 */ "BLOCKS",
  /*  262 */ "CHANGE",
  /*  263 */ "COMMA",
  /*  264 */ "COMPACT",
  /*  265 */ "CONCAT",
  /*  266 */ "CONFLICT",
  /*  267 */ "COPY",
  /*  268 */ "DEFERRED",
  /*  269 */ "DELIMITERS",
  /*  270 */ "DETACH",
  /*  271 */ "DIVIDE",
  /*  272 */ "DOT",
  /*  273 */ "EACH",
  /*  274 */ "END",
  /*  275 */ "FAIL",
  /*  276 */ "FILE",
  /*  277 */ "FOR",
  /*  278 */ "GLOB",
  /*  279 */ "ID",
  /*  280 */ "IMMEDIATE",
  /*  281 */ "IMPORT",
  /*  282 */ "INITIALLY",
  /*  283 */ "INSTEAD",
  /*  284 */ "ISNULL",
  /*  285 */ "KEY",
  /*  286 */ "NK_BITNOT",
  /*  287 */ "NK_SEMI",
  /*  288 */ "NOTNULL",
  /*  289 */ "OF",
  /*  290 */ "PLUS",
  /*  291 */ "PRIVILEGE",
  /*  292 */ "RAISE",
  /*  293 */ "REPLACE",
  /*  294 */ "RESTRICT",
  /*  295 */ "ROW",
  /*  296 */ "SEMI",
  /*  297 */ "STAR",
  /*  298 */ "STATEMENT",
  /*  299 */ "STRING",
  /*  300 */ "TIMES",
  /*  301 */ "UPDATE",
  /*  302 */ "VALUES",
  /*  303 */ "VARIABLE",
  /*  304 */ "VIEW",
  /*  305 */ "WAL",
  /*  306 */ "cmd",
  /*  307 */ "account_options",
  /*  308 */ "alter_account_options",
  /*  309 */ "literal",
  /*  310 */ "alter_account_option",
  /*  311 */ "user_name",
  /*  312 */ "sysinfo_opt",
  /*  313 */ "privileges",
  /*  314 */ "priv_level",
  /*  315 */ "priv_type_list",
  /*  316 */ "priv_type",
  /*  317 */ "db_name",
  /*  318 */ "dnode_endpoint",
  /*  319 */ "not_exists_opt",
  /*  320 */ "db_options",
  /*  321 */ "exists_opt",
  /*  322 */ "alter_db_options",
  /*  323 */ "integer_list",
  /*  324 */ "variable_list",
  /*  325 */ "retention_list",
  /*  326 */ "alter_db_option",
  /*  327 */ "retention",
  /*  328 */ "full_table_name",
  /*  329 */ "column_def_list",
  /*  330 */ "tags_def_opt",
  /*  331 */ "table_options",
  /*  332 */ "multi_create_clause",
  /*  333 */ "tags_def",
  /*  334 */ "multi_drop_clause",
  /*  335 */ "alter_table_clause",
  /*  336 */ "alter_table_options",
  /*  337 */ "column_name",
  /*  338 */ "type_name",
  /*  339 */ "signed_literal",
  /*  340 */ "create_subtable_clause",
  /*  341 */ "specific_cols_opt",
  /*  342 */ "expression_list",
  /*  343 */ "drop_table_clause",
  /*  344 */ "col_name_list",
  /*  345 */ "table_name",
  /*  346 */ "column_def",
  /*  347 */ "duration_list",
  /*  348 */ "rollup_func_list",
  /*  349 */ "alter_table_option",
  /*  350 */ "duration_literal",
  /*  351 */ "rollup_func_name",
  /*  352 */ "function_name",
  /*  353 */ "col_name",
  /*  354 */ "db_name_cond_opt",
  /*  355 */ "like_pattern_opt",
  /*  356 */ "table_name_cond",
  /*  357 */ "from_db_opt",
  /*  358 */ "index_options",
  /*  359 */ "func_list",
  /*  360 */ "sliding_opt",
  /*  361 */ "sma_stream_opt",
  /*  362 */ "func",
  /*  363 */ "stream_options",
  /*  364 */ "topic_name",
  /*  365 */ "query_expression",
  /*  366 */ "cgroup_name",
  /*  367 */ "analyze_opt",
  /*  368 */ "explain_options",
  /*  369 */ "agg_func_opt",
  /*  370 */ "bufsize_opt",
  /*  371 */ "stream_name",
  /*  372 */ "dnode_list",
  /*  373 */ "where_clause_opt",
  /*  374 */ "signed",
  /*  375 */ "literal_func",
  /*  376 */ "literal_list",
  /*  377 */ "table_alias",
  /*  378 */ "column_alias",
  /*  379 */ "expression",
  /*  380 */ "pseudo_column",
  /*  381 */ "column_reference",
  /*  382 */ "function_expression",
  /*  383 */ "subquery",
  /*  384 */ "star_func",
  /*  385 */ "star_func_para_list",
  /*  386 */ "noarg_func",
  /*  387 */ "other_para_list",
  /*  388 */ "star_func_para",
  /*  389 */ "predicate",
  /*  390 */ "compare_op",
  /*  391 */ "in_op",
  /*  392 */ "in_predicate_value",
  /*  393 */ "boolean_value_expression",
  /*  394 */ "boolean_primary",
  /*  395 */ "common_expression",
  /*  396 */ "from_clause_opt",
  /*  397 */ "table_reference_list",
  /*  398 */ "table_reference",
  /*  399 */ "table_primary",
  /*  400 */ "joined_table",
  /*  401 */ "alias_opt",
  /*  402 */ "parenthesized_joined_table",
  /*  403 */ "join_type",
  /*  404 */ "search_condition",
  /*  405 */ "query_specification",
  /*  406 */ "set_quantifier_opt",
  /*  407 */ "select_list",
  /*  408 */ "partition_by_clause_opt",
  /*  409 */ "range_opt",
  /*  410 */ "every_opt",
  /*  411 */ "fill_opt",
  /*  412 */ "twindow_clause_opt",
  /*  413 */ "group_by_clause_opt",
  /*  414 */ "having_clause_opt",
  /*  415 */ "select_item",
  /*  416 */ "fill_mode",
  /*  417 */ "group_by_list",
  /*  418 */ "query_expression_body",
  /*  419 */ "order_by_clause_opt",
  /*  420 */ "slimit_clause_opt",
  /*  421 */ "limit_clause_opt",
  /*  422 */ "query_primary",
  /*  423 */ "sort_specification_list",
  /*  424 */ "sort_specification",
  /*  425 */ "ordering_specification_opt",
  /*  426 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options KEEP integer_list",
 /*  82 */ "db_options ::= db_options KEEP variable_list",
 /*  83 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  84 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  85 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  86 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  87 */ "db_options ::= db_options STRICT NK_STRING",
 /*  88 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  89 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  90 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  91 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  92 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  93 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  94 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 100 */ "db_options ::= db_options SST_TRIGGER NK_INTEGER",
 /* 101 */ "alter_db_options ::= alter_db_option",
 /* 102 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 103 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 104 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 105 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 106 */ "alter_db_option ::= KEEP integer_list",
 /* 107 */ "alter_db_option ::= KEEP variable_list",
 /* 108 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 109 */ "alter_db_option ::= SST_TRIGGER NK_INTEGER",
 /* 110 */ "integer_list ::= NK_INTEGER",
 /* 111 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 112 */ "variable_list ::= NK_VARIABLE",
 /* 113 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 114 */ "retention_list ::= retention",
 /* 115 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 116 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 117 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 118 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 119 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 120 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 121 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 122 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 123 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 124 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 125 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 126 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 127 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 128 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 129 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 130 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 131 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 132 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 133 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 134 */ "multi_create_clause ::= create_subtable_clause",
 /* 135 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 136 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 137 */ "multi_drop_clause ::= drop_table_clause",
 /* 138 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 139 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 140 */ "specific_cols_opt ::=",
 /* 141 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 142 */ "full_table_name ::= table_name",
 /* 143 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 144 */ "column_def_list ::= column_def",
 /* 145 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 146 */ "column_def ::= column_name type_name",
 /* 147 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 148 */ "type_name ::= BOOL",
 /* 149 */ "type_name ::= TINYINT",
 /* 150 */ "type_name ::= SMALLINT",
 /* 151 */ "type_name ::= INT",
 /* 152 */ "type_name ::= INTEGER",
 /* 153 */ "type_name ::= BIGINT",
 /* 154 */ "type_name ::= FLOAT",
 /* 155 */ "type_name ::= DOUBLE",
 /* 156 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= TIMESTAMP",
 /* 158 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 159 */ "type_name ::= TINYINT UNSIGNED",
 /* 160 */ "type_name ::= SMALLINT UNSIGNED",
 /* 161 */ "type_name ::= INT UNSIGNED",
 /* 162 */ "type_name ::= BIGINT UNSIGNED",
 /* 163 */ "type_name ::= JSON",
 /* 164 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 165 */ "type_name ::= MEDIUMBLOB",
 /* 166 */ "type_name ::= BLOB",
 /* 167 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= DECIMAL",
 /* 169 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 171 */ "tags_def_opt ::=",
 /* 172 */ "tags_def_opt ::= tags_def",
 /* 173 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 174 */ "table_options ::=",
 /* 175 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 176 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 177 */ "table_options ::= table_options WATERMARK duration_list",
 /* 178 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 179 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 180 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 181 */ "alter_table_options ::= alter_table_option",
 /* 182 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 183 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 184 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 185 */ "duration_list ::= duration_literal",
 /* 186 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 187 */ "rollup_func_list ::= rollup_func_name",
 /* 188 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 189 */ "rollup_func_name ::= function_name",
 /* 190 */ "rollup_func_name ::= FIRST",
 /* 191 */ "rollup_func_name ::= LAST",
 /* 192 */ "col_name_list ::= col_name",
 /* 193 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 194 */ "col_name ::= column_name",
 /* 195 */ "cmd ::= SHOW DNODES",
 /* 196 */ "cmd ::= SHOW USERS",
 /* 197 */ "cmd ::= SHOW DATABASES",
 /* 198 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 199 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 200 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 201 */ "cmd ::= SHOW MNODES",
 /* 202 */ "cmd ::= SHOW MODULES",
 /* 203 */ "cmd ::= SHOW QNODES",
 /* 204 */ "cmd ::= SHOW FUNCTIONS",
 /* 205 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 206 */ "cmd ::= SHOW STREAMS",
 /* 207 */ "cmd ::= SHOW ACCOUNTS",
 /* 208 */ "cmd ::= SHOW APPS",
 /* 209 */ "cmd ::= SHOW CONNECTIONS",
 /* 210 */ "cmd ::= SHOW LICENCES",
 /* 211 */ "cmd ::= SHOW GRANTS",
 /* 212 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 213 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 214 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 215 */ "cmd ::= SHOW QUERIES",
 /* 216 */ "cmd ::= SHOW SCORES",
 /* 217 */ "cmd ::= SHOW TOPICS",
 /* 218 */ "cmd ::= SHOW VARIABLES",
 /* 219 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 220 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 221 */ "cmd ::= SHOW BNODES",
 /* 222 */ "cmd ::= SHOW SNODES",
 /* 223 */ "cmd ::= SHOW CLUSTER",
 /* 224 */ "cmd ::= SHOW TRANSACTIONS",
 /* 225 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 226 */ "cmd ::= SHOW CONSUMERS",
 /* 227 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 228 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 229 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 230 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 231 */ "db_name_cond_opt ::=",
 /* 232 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 233 */ "like_pattern_opt ::=",
 /* 234 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 235 */ "table_name_cond ::= table_name",
 /* 236 */ "from_db_opt ::=",
 /* 237 */ "from_db_opt ::= FROM db_name",
 /* 238 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 239 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 240 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 241 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 242 */ "func_list ::= func",
 /* 243 */ "func_list ::= func_list NK_COMMA func",
 /* 244 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 245 */ "sma_stream_opt ::=",
 /* 246 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 247 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 248 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 249 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 250 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 251 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 252 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 253 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 254 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 255 */ "cmd ::= DESC full_table_name",
 /* 256 */ "cmd ::= DESCRIBE full_table_name",
 /* 257 */ "cmd ::= RESET QUERY CACHE",
 /* 258 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 259 */ "analyze_opt ::=",
 /* 260 */ "analyze_opt ::= ANALYZE",
 /* 261 */ "explain_options ::=",
 /* 262 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 263 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 264 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 265 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 266 */ "agg_func_opt ::=",
 /* 267 */ "agg_func_opt ::= AGGREGATE",
 /* 268 */ "bufsize_opt ::=",
 /* 269 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 270 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name AS query_expression",
 /* 271 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 272 */ "stream_options ::=",
 /* 273 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 274 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 275 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 276 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 277 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 278 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 279 */ "cmd ::= KILL QUERY NK_STRING",
 /* 280 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 281 */ "cmd ::= BALANCE VGROUP",
 /* 282 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 283 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 284 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 285 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 286 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 287 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 288 */ "cmd ::= query_expression",
 /* 289 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression",
 /* 290 */ "cmd ::= INSERT INTO full_table_name query_expression",
 /* 291 */ "literal ::= NK_INTEGER",
 /* 292 */ "literal ::= NK_FLOAT",
 /* 293 */ "literal ::= NK_STRING",
 /* 294 */ "literal ::= NK_BOOL",
 /* 295 */ "literal ::= TIMESTAMP NK_STRING",
 /* 296 */ "literal ::= duration_literal",
 /* 297 */ "literal ::= NULL",
 /* 298 */ "literal ::= NK_QUESTION",
 /* 299 */ "duration_literal ::= NK_VARIABLE",
 /* 300 */ "signed ::= NK_INTEGER",
 /* 301 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 302 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 303 */ "signed ::= NK_FLOAT",
 /* 304 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 305 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 306 */ "signed_literal ::= signed",
 /* 307 */ "signed_literal ::= NK_STRING",
 /* 308 */ "signed_literal ::= NK_BOOL",
 /* 309 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 310 */ "signed_literal ::= duration_literal",
 /* 311 */ "signed_literal ::= NULL",
 /* 312 */ "signed_literal ::= literal_func",
 /* 313 */ "signed_literal ::= NK_QUESTION",
 /* 314 */ "literal_list ::= signed_literal",
 /* 315 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 316 */ "db_name ::= NK_ID",
 /* 317 */ "table_name ::= NK_ID",
 /* 318 */ "column_name ::= NK_ID",
 /* 319 */ "function_name ::= NK_ID",
 /* 320 */ "table_alias ::= NK_ID",
 /* 321 */ "column_alias ::= NK_ID",
 /* 322 */ "user_name ::= NK_ID",
 /* 323 */ "topic_name ::= NK_ID",
 /* 324 */ "stream_name ::= NK_ID",
 /* 325 */ "cgroup_name ::= NK_ID",
 /* 326 */ "expression ::= literal",
 /* 327 */ "expression ::= pseudo_column",
 /* 328 */ "expression ::= column_reference",
 /* 329 */ "expression ::= function_expression",
 /* 330 */ "expression ::= subquery",
 /* 331 */ "expression ::= NK_LP expression NK_RP",
 /* 332 */ "expression ::= NK_PLUS expression",
 /* 333 */ "expression ::= NK_MINUS expression",
 /* 334 */ "expression ::= expression NK_PLUS expression",
 /* 335 */ "expression ::= expression NK_MINUS expression",
 /* 336 */ "expression ::= expression NK_STAR expression",
 /* 337 */ "expression ::= expression NK_SLASH expression",
 /* 338 */ "expression ::= expression NK_REM expression",
 /* 339 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 340 */ "expression ::= expression NK_BITAND expression",
 /* 341 */ "expression ::= expression NK_BITOR expression",
 /* 342 */ "expression_list ::= expression",
 /* 343 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 344 */ "column_reference ::= column_name",
 /* 345 */ "column_reference ::= table_name NK_DOT column_name",
 /* 346 */ "pseudo_column ::= ROWTS",
 /* 347 */ "pseudo_column ::= TBNAME",
 /* 348 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 349 */ "pseudo_column ::= QSTART",
 /* 350 */ "pseudo_column ::= QEND",
 /* 351 */ "pseudo_column ::= QDURATION",
 /* 352 */ "pseudo_column ::= WSTART",
 /* 353 */ "pseudo_column ::= WEND",
 /* 354 */ "pseudo_column ::= WDURATION",
 /* 355 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 356 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 357 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 358 */ "function_expression ::= literal_func",
 /* 359 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 360 */ "literal_func ::= NOW",
 /* 361 */ "noarg_func ::= NOW",
 /* 362 */ "noarg_func ::= TODAY",
 /* 363 */ "noarg_func ::= TIMEZONE",
 /* 364 */ "noarg_func ::= DATABASE",
 /* 365 */ "noarg_func ::= CLIENT_VERSION",
 /* 366 */ "noarg_func ::= SERVER_VERSION",
 /* 367 */ "noarg_func ::= SERVER_STATUS",
 /* 368 */ "noarg_func ::= CURRENT_USER",
 /* 369 */ "noarg_func ::= USER",
 /* 370 */ "star_func ::= COUNT",
 /* 371 */ "star_func ::= FIRST",
 /* 372 */ "star_func ::= LAST",
 /* 373 */ "star_func ::= LAST_ROW",
 /* 374 */ "star_func_para_list ::= NK_STAR",
 /* 375 */ "star_func_para_list ::= other_para_list",
 /* 376 */ "other_para_list ::= star_func_para",
 /* 377 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 378 */ "star_func_para ::= expression",
 /* 379 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 380 */ "predicate ::= expression compare_op expression",
 /* 381 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 382 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 383 */ "predicate ::= expression IS NULL",
 /* 384 */ "predicate ::= expression IS NOT NULL",
 /* 385 */ "predicate ::= expression in_op in_predicate_value",
 /* 386 */ "compare_op ::= NK_LT",
 /* 387 */ "compare_op ::= NK_GT",
 /* 388 */ "compare_op ::= NK_LE",
 /* 389 */ "compare_op ::= NK_GE",
 /* 390 */ "compare_op ::= NK_NE",
 /* 391 */ "compare_op ::= NK_EQ",
 /* 392 */ "compare_op ::= LIKE",
 /* 393 */ "compare_op ::= NOT LIKE",
 /* 394 */ "compare_op ::= MATCH",
 /* 395 */ "compare_op ::= NMATCH",
 /* 396 */ "compare_op ::= CONTAINS",
 /* 397 */ "in_op ::= IN",
 /* 398 */ "in_op ::= NOT IN",
 /* 399 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 400 */ "boolean_value_expression ::= boolean_primary",
 /* 401 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 402 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 403 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 404 */ "boolean_primary ::= predicate",
 /* 405 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 406 */ "common_expression ::= expression",
 /* 407 */ "common_expression ::= boolean_value_expression",
 /* 408 */ "from_clause_opt ::=",
 /* 409 */ "from_clause_opt ::= FROM table_reference_list",
 /* 410 */ "table_reference_list ::= table_reference",
 /* 411 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 412 */ "table_reference ::= table_primary",
 /* 413 */ "table_reference ::= joined_table",
 /* 414 */ "table_primary ::= table_name alias_opt",
 /* 415 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 416 */ "table_primary ::= subquery alias_opt",
 /* 417 */ "table_primary ::= parenthesized_joined_table",
 /* 418 */ "alias_opt ::=",
 /* 419 */ "alias_opt ::= table_alias",
 /* 420 */ "alias_opt ::= AS table_alias",
 /* 421 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 422 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 423 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 424 */ "join_type ::=",
 /* 425 */ "join_type ::= INNER",
 /* 426 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 427 */ "set_quantifier_opt ::=",
 /* 428 */ "set_quantifier_opt ::= DISTINCT",
 /* 429 */ "set_quantifier_opt ::= ALL",
 /* 430 */ "select_list ::= select_item",
 /* 431 */ "select_list ::= select_list NK_COMMA select_item",
 /* 432 */ "select_item ::= NK_STAR",
 /* 433 */ "select_item ::= common_expression",
 /* 434 */ "select_item ::= common_expression column_alias",
 /* 435 */ "select_item ::= common_expression AS column_alias",
 /* 436 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 437 */ "where_clause_opt ::=",
 /* 438 */ "where_clause_opt ::= WHERE search_condition",
 /* 439 */ "partition_by_clause_opt ::=",
 /* 440 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 441 */ "twindow_clause_opt ::=",
 /* 442 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 443 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 444 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 445 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 446 */ "sliding_opt ::=",
 /* 447 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 448 */ "fill_opt ::=",
 /* 449 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 450 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 451 */ "fill_mode ::= NONE",
 /* 452 */ "fill_mode ::= PREV",
 /* 453 */ "fill_mode ::= NULL",
 /* 454 */ "fill_mode ::= LINEAR",
 /* 455 */ "fill_mode ::= NEXT",
 /* 456 */ "group_by_clause_opt ::=",
 /* 457 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 458 */ "group_by_list ::= expression",
 /* 459 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 460 */ "having_clause_opt ::=",
 /* 461 */ "having_clause_opt ::= HAVING search_condition",
 /* 462 */ "range_opt ::=",
 /* 463 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 464 */ "every_opt ::=",
 /* 465 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 466 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 467 */ "query_expression_body ::= query_primary",
 /* 468 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 469 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 470 */ "query_primary ::= query_specification",
 /* 471 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 472 */ "order_by_clause_opt ::=",
 /* 473 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 474 */ "slimit_clause_opt ::=",
 /* 475 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 476 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 477 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 478 */ "limit_clause_opt ::=",
 /* 479 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 480 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 481 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 482 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 483 */ "search_condition ::= common_expression",
 /* 484 */ "sort_specification_list ::= sort_specification",
 /* 485 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 486 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 487 */ "ordering_specification_opt ::=",
 /* 488 */ "ordering_specification_opt ::= ASC",
 /* 489 */ "ordering_specification_opt ::= DESC",
 /* 490 */ "null_ordering_opt ::=",
 /* 491 */ "null_ordering_opt ::= NULLS FIRST",
 /* 492 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 306: /* cmd */
    case 309: /* literal */
    case 320: /* db_options */
    case 322: /* alter_db_options */
    case 327: /* retention */
    case 328: /* full_table_name */
    case 331: /* table_options */
    case 335: /* alter_table_clause */
    case 336: /* alter_table_options */
    case 339: /* signed_literal */
    case 340: /* create_subtable_clause */
    case 343: /* drop_table_clause */
    case 346: /* column_def */
    case 350: /* duration_literal */
    case 351: /* rollup_func_name */
    case 353: /* col_name */
    case 354: /* db_name_cond_opt */
    case 355: /* like_pattern_opt */
    case 356: /* table_name_cond */
    case 357: /* from_db_opt */
    case 358: /* index_options */
    case 360: /* sliding_opt */
    case 361: /* sma_stream_opt */
    case 362: /* func */
    case 363: /* stream_options */
    case 365: /* query_expression */
    case 368: /* explain_options */
    case 373: /* where_clause_opt */
    case 374: /* signed */
    case 375: /* literal_func */
    case 379: /* expression */
    case 380: /* pseudo_column */
    case 381: /* column_reference */
    case 382: /* function_expression */
    case 383: /* subquery */
    case 388: /* star_func_para */
    case 389: /* predicate */
    case 392: /* in_predicate_value */
    case 393: /* boolean_value_expression */
    case 394: /* boolean_primary */
    case 395: /* common_expression */
    case 396: /* from_clause_opt */
    case 397: /* table_reference_list */
    case 398: /* table_reference */
    case 399: /* table_primary */
    case 400: /* joined_table */
    case 402: /* parenthesized_joined_table */
    case 404: /* search_condition */
    case 405: /* query_specification */
    case 409: /* range_opt */
    case 410: /* every_opt */
    case 411: /* fill_opt */
    case 412: /* twindow_clause_opt */
    case 414: /* having_clause_opt */
    case 415: /* select_item */
    case 418: /* query_expression_body */
    case 420: /* slimit_clause_opt */
    case 421: /* limit_clause_opt */
    case 422: /* query_primary */
    case 424: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy840)); 
}
      break;
    case 307: /* account_options */
    case 308: /* alter_account_options */
    case 310: /* alter_account_option */
    case 370: /* bufsize_opt */
{
 
}
      break;
    case 311: /* user_name */
    case 314: /* priv_level */
    case 317: /* db_name */
    case 318: /* dnode_endpoint */
    case 337: /* column_name */
    case 345: /* table_name */
    case 352: /* function_name */
    case 364: /* topic_name */
    case 366: /* cgroup_name */
    case 371: /* stream_name */
    case 377: /* table_alias */
    case 378: /* column_alias */
    case 384: /* star_func */
    case 386: /* noarg_func */
    case 401: /* alias_opt */
{
 
}
      break;
    case 312: /* sysinfo_opt */
{
 
}
      break;
    case 313: /* privileges */
    case 315: /* priv_type_list */
    case 316: /* priv_type */
{
 
}
      break;
    case 319: /* not_exists_opt */
    case 321: /* exists_opt */
    case 367: /* analyze_opt */
    case 369: /* agg_func_opt */
    case 406: /* set_quantifier_opt */
{
 
}
      break;
    case 323: /* integer_list */
    case 324: /* variable_list */
    case 325: /* retention_list */
    case 329: /* column_def_list */
    case 330: /* tags_def_opt */
    case 332: /* multi_create_clause */
    case 333: /* tags_def */
    case 334: /* multi_drop_clause */
    case 341: /* specific_cols_opt */
    case 342: /* expression_list */
    case 344: /* col_name_list */
    case 347: /* duration_list */
    case 348: /* rollup_func_list */
    case 359: /* func_list */
    case 372: /* dnode_list */
    case 376: /* literal_list */
    case 385: /* star_func_para_list */
    case 387: /* other_para_list */
    case 407: /* select_list */
    case 408: /* partition_by_clause_opt */
    case 413: /* group_by_clause_opt */
    case 417: /* group_by_list */
    case 419: /* order_by_clause_opt */
    case 423: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy544)); 
}
      break;
    case 326: /* alter_db_option */
    case 349: /* alter_table_option */
{
 
}
      break;
    case 338: /* type_name */
{
 
}
      break;
    case 390: /* compare_op */
    case 391: /* in_op */
{
 
}
      break;
    case 403: /* join_type */
{
 
}
      break;
    case 416: /* fill_mode */
{
 
}
      break;
    case 425: /* ordering_specification_opt */
{
 
}
      break;
    case 426: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  306,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  306,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  307,    0 }, /* (2) account_options ::= */
  {  307,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  307,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  307,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  307,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  307,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  307,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  307,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  307,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  307,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  308,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  308,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  310,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  310,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  310,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  310,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  310,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  310,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  310,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  310,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  310,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  310,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  306,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  306,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  306,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  306,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  306,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  312,    0 }, /* (29) sysinfo_opt ::= */
  {  312,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  306,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  306,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  313,   -1 }, /* (33) privileges ::= ALL */
  {  313,   -1 }, /* (34) privileges ::= priv_type_list */
  {  315,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  315,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  316,   -1 }, /* (37) priv_type ::= READ */
  {  316,   -1 }, /* (38) priv_type ::= WRITE */
  {  314,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  314,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  306,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  306,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  306,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  306,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  306,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  306,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  306,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  306,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  318,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  318,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  318,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  306,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  306,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  306,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  306,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  306,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  306,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  306,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  306,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  306,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  306,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  306,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  306,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  306,   -2 }, /* (64) cmd ::= USE db_name */
  {  306,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  306,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  306,   -3 }, /* (67) cmd ::= TRIM DATABASE db_name */
  {  319,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  319,    0 }, /* (69) not_exists_opt ::= */
  {  321,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  321,    0 }, /* (71) exists_opt ::= */
  {  320,    0 }, /* (72) db_options ::= */
  {  320,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  320,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  320,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  320,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  320,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  320,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  320,   -3 }, /* (79) db_options ::= db_options MAXROWS NK_INTEGER */
  {  320,   -3 }, /* (80) db_options ::= db_options MINROWS NK_INTEGER */
  {  320,   -3 }, /* (81) db_options ::= db_options KEEP integer_list */
  {  320,   -3 }, /* (82) db_options ::= db_options KEEP variable_list */
  {  320,   -3 }, /* (83) db_options ::= db_options PAGES NK_INTEGER */
  {  320,   -3 }, /* (84) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  320,   -3 }, /* (85) db_options ::= db_options PRECISION NK_STRING */
  {  320,   -3 }, /* (86) db_options ::= db_options REPLICA NK_INTEGER */
  {  320,   -3 }, /* (87) db_options ::= db_options STRICT NK_STRING */
  {  320,   -3 }, /* (88) db_options ::= db_options VGROUPS NK_INTEGER */
  {  320,   -3 }, /* (89) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  320,   -3 }, /* (90) db_options ::= db_options RETENTIONS retention_list */
  {  320,   -3 }, /* (91) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  320,   -3 }, /* (92) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  320,   -3 }, /* (93) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  320,   -3 }, /* (94) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  320,   -4 }, /* (95) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  320,   -3 }, /* (96) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  320,   -4 }, /* (97) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  320,   -3 }, /* (98) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  320,   -3 }, /* (99) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  320,   -3 }, /* (100) db_options ::= db_options SST_TRIGGER NK_INTEGER */
  {  322,   -1 }, /* (101) alter_db_options ::= alter_db_option */
  {  322,   -2 }, /* (102) alter_db_options ::= alter_db_options alter_db_option */
  {  326,   -2 }, /* (103) alter_db_option ::= CACHEMODEL NK_STRING */
  {  326,   -2 }, /* (104) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  326,   -2 }, /* (105) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  326,   -2 }, /* (106) alter_db_option ::= KEEP integer_list */
  {  326,   -2 }, /* (107) alter_db_option ::= KEEP variable_list */
  {  326,   -2 }, /* (108) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  326,   -2 }, /* (109) alter_db_option ::= SST_TRIGGER NK_INTEGER */
  {  323,   -1 }, /* (110) integer_list ::= NK_INTEGER */
  {  323,   -3 }, /* (111) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  324,   -1 }, /* (112) variable_list ::= NK_VARIABLE */
  {  324,   -3 }, /* (113) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  325,   -1 }, /* (114) retention_list ::= retention */
  {  325,   -3 }, /* (115) retention_list ::= retention_list NK_COMMA retention */
  {  327,   -3 }, /* (116) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  306,   -9 }, /* (117) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  306,   -3 }, /* (118) cmd ::= CREATE TABLE multi_create_clause */
  {  306,   -9 }, /* (119) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  306,   -3 }, /* (120) cmd ::= DROP TABLE multi_drop_clause */
  {  306,   -4 }, /* (121) cmd ::= DROP STABLE exists_opt full_table_name */
  {  306,   -3 }, /* (122) cmd ::= ALTER TABLE alter_table_clause */
  {  306,   -3 }, /* (123) cmd ::= ALTER STABLE alter_table_clause */
  {  335,   -2 }, /* (124) alter_table_clause ::= full_table_name alter_table_options */
  {  335,   -5 }, /* (125) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  335,   -4 }, /* (126) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  335,   -5 }, /* (127) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  335,   -5 }, /* (128) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  335,   -5 }, /* (129) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  335,   -4 }, /* (130) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  335,   -5 }, /* (131) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  335,   -5 }, /* (132) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  335,   -6 }, /* (133) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  332,   -1 }, /* (134) multi_create_clause ::= create_subtable_clause */
  {  332,   -2 }, /* (135) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  340,  -10 }, /* (136) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  334,   -1 }, /* (137) multi_drop_clause ::= drop_table_clause */
  {  334,   -2 }, /* (138) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  343,   -2 }, /* (139) drop_table_clause ::= exists_opt full_table_name */
  {  341,    0 }, /* (140) specific_cols_opt ::= */
  {  341,   -3 }, /* (141) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  328,   -1 }, /* (142) full_table_name ::= table_name */
  {  328,   -3 }, /* (143) full_table_name ::= db_name NK_DOT table_name */
  {  329,   -1 }, /* (144) column_def_list ::= column_def */
  {  329,   -3 }, /* (145) column_def_list ::= column_def_list NK_COMMA column_def */
  {  346,   -2 }, /* (146) column_def ::= column_name type_name */
  {  346,   -4 }, /* (147) column_def ::= column_name type_name COMMENT NK_STRING */
  {  338,   -1 }, /* (148) type_name ::= BOOL */
  {  338,   -1 }, /* (149) type_name ::= TINYINT */
  {  338,   -1 }, /* (150) type_name ::= SMALLINT */
  {  338,   -1 }, /* (151) type_name ::= INT */
  {  338,   -1 }, /* (152) type_name ::= INTEGER */
  {  338,   -1 }, /* (153) type_name ::= BIGINT */
  {  338,   -1 }, /* (154) type_name ::= FLOAT */
  {  338,   -1 }, /* (155) type_name ::= DOUBLE */
  {  338,   -4 }, /* (156) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  338,   -1 }, /* (157) type_name ::= TIMESTAMP */
  {  338,   -4 }, /* (158) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  338,   -2 }, /* (159) type_name ::= TINYINT UNSIGNED */
  {  338,   -2 }, /* (160) type_name ::= SMALLINT UNSIGNED */
  {  338,   -2 }, /* (161) type_name ::= INT UNSIGNED */
  {  338,   -2 }, /* (162) type_name ::= BIGINT UNSIGNED */
  {  338,   -1 }, /* (163) type_name ::= JSON */
  {  338,   -4 }, /* (164) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  338,   -1 }, /* (165) type_name ::= MEDIUMBLOB */
  {  338,   -1 }, /* (166) type_name ::= BLOB */
  {  338,   -4 }, /* (167) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  338,   -1 }, /* (168) type_name ::= DECIMAL */
  {  338,   -4 }, /* (169) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  338,   -6 }, /* (170) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  330,    0 }, /* (171) tags_def_opt ::= */
  {  330,   -1 }, /* (172) tags_def_opt ::= tags_def */
  {  333,   -4 }, /* (173) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  331,    0 }, /* (174) table_options ::= */
  {  331,   -3 }, /* (175) table_options ::= table_options COMMENT NK_STRING */
  {  331,   -3 }, /* (176) table_options ::= table_options MAX_DELAY duration_list */
  {  331,   -3 }, /* (177) table_options ::= table_options WATERMARK duration_list */
  {  331,   -5 }, /* (178) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  331,   -3 }, /* (179) table_options ::= table_options TTL NK_INTEGER */
  {  331,   -5 }, /* (180) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  336,   -1 }, /* (181) alter_table_options ::= alter_table_option */
  {  336,   -2 }, /* (182) alter_table_options ::= alter_table_options alter_table_option */
  {  349,   -2 }, /* (183) alter_table_option ::= COMMENT NK_STRING */
  {  349,   -2 }, /* (184) alter_table_option ::= TTL NK_INTEGER */
  {  347,   -1 }, /* (185) duration_list ::= duration_literal */
  {  347,   -3 }, /* (186) duration_list ::= duration_list NK_COMMA duration_literal */
  {  348,   -1 }, /* (187) rollup_func_list ::= rollup_func_name */
  {  348,   -3 }, /* (188) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  351,   -1 }, /* (189) rollup_func_name ::= function_name */
  {  351,   -1 }, /* (190) rollup_func_name ::= FIRST */
  {  351,   -1 }, /* (191) rollup_func_name ::= LAST */
  {  344,   -1 }, /* (192) col_name_list ::= col_name */
  {  344,   -3 }, /* (193) col_name_list ::= col_name_list NK_COMMA col_name */
  {  353,   -1 }, /* (194) col_name ::= column_name */
  {  306,   -2 }, /* (195) cmd ::= SHOW DNODES */
  {  306,   -2 }, /* (196) cmd ::= SHOW USERS */
  {  306,   -2 }, /* (197) cmd ::= SHOW DATABASES */
  {  306,   -4 }, /* (198) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  306,   -4 }, /* (199) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  306,   -3 }, /* (200) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  306,   -2 }, /* (201) cmd ::= SHOW MNODES */
  {  306,   -2 }, /* (202) cmd ::= SHOW MODULES */
  {  306,   -2 }, /* (203) cmd ::= SHOW QNODES */
  {  306,   -2 }, /* (204) cmd ::= SHOW FUNCTIONS */
  {  306,   -5 }, /* (205) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  306,   -2 }, /* (206) cmd ::= SHOW STREAMS */
  {  306,   -2 }, /* (207) cmd ::= SHOW ACCOUNTS */
  {  306,   -2 }, /* (208) cmd ::= SHOW APPS */
  {  306,   -2 }, /* (209) cmd ::= SHOW CONNECTIONS */
  {  306,   -2 }, /* (210) cmd ::= SHOW LICENCES */
  {  306,   -2 }, /* (211) cmd ::= SHOW GRANTS */
  {  306,   -4 }, /* (212) cmd ::= SHOW CREATE DATABASE db_name */
  {  306,   -4 }, /* (213) cmd ::= SHOW CREATE TABLE full_table_name */
  {  306,   -4 }, /* (214) cmd ::= SHOW CREATE STABLE full_table_name */
  {  306,   -2 }, /* (215) cmd ::= SHOW QUERIES */
  {  306,   -2 }, /* (216) cmd ::= SHOW SCORES */
  {  306,   -2 }, /* (217) cmd ::= SHOW TOPICS */
  {  306,   -2 }, /* (218) cmd ::= SHOW VARIABLES */
  {  306,   -3 }, /* (219) cmd ::= SHOW LOCAL VARIABLES */
  {  306,   -4 }, /* (220) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  306,   -2 }, /* (221) cmd ::= SHOW BNODES */
  {  306,   -2 }, /* (222) cmd ::= SHOW SNODES */
  {  306,   -2 }, /* (223) cmd ::= SHOW CLUSTER */
  {  306,   -2 }, /* (224) cmd ::= SHOW TRANSACTIONS */
  {  306,   -4 }, /* (225) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  306,   -2 }, /* (226) cmd ::= SHOW CONSUMERS */
  {  306,   -2 }, /* (227) cmd ::= SHOW SUBSCRIPTIONS */
  {  306,   -5 }, /* (228) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  306,   -3 }, /* (229) cmd ::= SHOW VNODES NK_INTEGER */
  {  306,   -3 }, /* (230) cmd ::= SHOW VNODES NK_STRING */
  {  354,    0 }, /* (231) db_name_cond_opt ::= */
  {  354,   -2 }, /* (232) db_name_cond_opt ::= db_name NK_DOT */
  {  355,    0 }, /* (233) like_pattern_opt ::= */
  {  355,   -2 }, /* (234) like_pattern_opt ::= LIKE NK_STRING */
  {  356,   -1 }, /* (235) table_name_cond ::= table_name */
  {  357,    0 }, /* (236) from_db_opt ::= */
  {  357,   -2 }, /* (237) from_db_opt ::= FROM db_name */
  {  306,   -8 }, /* (238) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  306,   -4 }, /* (239) cmd ::= DROP INDEX exists_opt full_table_name */
  {  358,  -10 }, /* (240) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  358,  -12 }, /* (241) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  359,   -1 }, /* (242) func_list ::= func */
  {  359,   -3 }, /* (243) func_list ::= func_list NK_COMMA func */
  {  362,   -4 }, /* (244) func ::= function_name NK_LP expression_list NK_RP */
  {  361,    0 }, /* (245) sma_stream_opt ::= */
  {  361,   -3 }, /* (246) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  361,   -3 }, /* (247) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  306,   -6 }, /* (248) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  306,   -7 }, /* (249) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  306,   -9 }, /* (250) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  306,   -7 }, /* (251) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  306,   -9 }, /* (252) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  306,   -4 }, /* (253) cmd ::= DROP TOPIC exists_opt topic_name */
  {  306,   -7 }, /* (254) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  306,   -2 }, /* (255) cmd ::= DESC full_table_name */
  {  306,   -2 }, /* (256) cmd ::= DESCRIBE full_table_name */
  {  306,   -3 }, /* (257) cmd ::= RESET QUERY CACHE */
  {  306,   -4 }, /* (258) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  367,    0 }, /* (259) analyze_opt ::= */
  {  367,   -1 }, /* (260) analyze_opt ::= ANALYZE */
  {  368,    0 }, /* (261) explain_options ::= */
  {  368,   -3 }, /* (262) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  368,   -3 }, /* (263) explain_options ::= explain_options RATIO NK_FLOAT */
  {  306,  -10 }, /* (264) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  306,   -4 }, /* (265) cmd ::= DROP FUNCTION exists_opt function_name */
  {  369,    0 }, /* (266) agg_func_opt ::= */
  {  369,   -1 }, /* (267) agg_func_opt ::= AGGREGATE */
  {  370,    0 }, /* (268) bufsize_opt ::= */
  {  370,   -2 }, /* (269) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  306,   -9 }, /* (270) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name AS query_expression */
  {  306,   -4 }, /* (271) cmd ::= DROP STREAM exists_opt stream_name */
  {  363,    0 }, /* (272) stream_options ::= */
  {  363,   -3 }, /* (273) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  363,   -3 }, /* (274) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  363,   -4 }, /* (275) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  363,   -3 }, /* (276) stream_options ::= stream_options WATERMARK duration_literal */
  {  363,   -4 }, /* (277) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  306,   -3 }, /* (278) cmd ::= KILL CONNECTION NK_INTEGER */
  {  306,   -3 }, /* (279) cmd ::= KILL QUERY NK_STRING */
  {  306,   -3 }, /* (280) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  306,   -2 }, /* (281) cmd ::= BALANCE VGROUP */
  {  306,   -4 }, /* (282) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  306,   -4 }, /* (283) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  306,   -3 }, /* (284) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  372,   -2 }, /* (285) dnode_list ::= DNODE NK_INTEGER */
  {  372,   -3 }, /* (286) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  306,   -4 }, /* (287) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  306,   -1 }, /* (288) cmd ::= query_expression */
  {  306,   -7 }, /* (289) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
  {  306,   -4 }, /* (290) cmd ::= INSERT INTO full_table_name query_expression */
  {  309,   -1 }, /* (291) literal ::= NK_INTEGER */
  {  309,   -1 }, /* (292) literal ::= NK_FLOAT */
  {  309,   -1 }, /* (293) literal ::= NK_STRING */
  {  309,   -1 }, /* (294) literal ::= NK_BOOL */
  {  309,   -2 }, /* (295) literal ::= TIMESTAMP NK_STRING */
  {  309,   -1 }, /* (296) literal ::= duration_literal */
  {  309,   -1 }, /* (297) literal ::= NULL */
  {  309,   -1 }, /* (298) literal ::= NK_QUESTION */
  {  350,   -1 }, /* (299) duration_literal ::= NK_VARIABLE */
  {  374,   -1 }, /* (300) signed ::= NK_INTEGER */
  {  374,   -2 }, /* (301) signed ::= NK_PLUS NK_INTEGER */
  {  374,   -2 }, /* (302) signed ::= NK_MINUS NK_INTEGER */
  {  374,   -1 }, /* (303) signed ::= NK_FLOAT */
  {  374,   -2 }, /* (304) signed ::= NK_PLUS NK_FLOAT */
  {  374,   -2 }, /* (305) signed ::= NK_MINUS NK_FLOAT */
  {  339,   -1 }, /* (306) signed_literal ::= signed */
  {  339,   -1 }, /* (307) signed_literal ::= NK_STRING */
  {  339,   -1 }, /* (308) signed_literal ::= NK_BOOL */
  {  339,   -2 }, /* (309) signed_literal ::= TIMESTAMP NK_STRING */
  {  339,   -1 }, /* (310) signed_literal ::= duration_literal */
  {  339,   -1 }, /* (311) signed_literal ::= NULL */
  {  339,   -1 }, /* (312) signed_literal ::= literal_func */
  {  339,   -1 }, /* (313) signed_literal ::= NK_QUESTION */
  {  376,   -1 }, /* (314) literal_list ::= signed_literal */
  {  376,   -3 }, /* (315) literal_list ::= literal_list NK_COMMA signed_literal */
  {  317,   -1 }, /* (316) db_name ::= NK_ID */
  {  345,   -1 }, /* (317) table_name ::= NK_ID */
  {  337,   -1 }, /* (318) column_name ::= NK_ID */
  {  352,   -1 }, /* (319) function_name ::= NK_ID */
  {  377,   -1 }, /* (320) table_alias ::= NK_ID */
  {  378,   -1 }, /* (321) column_alias ::= NK_ID */
  {  311,   -1 }, /* (322) user_name ::= NK_ID */
  {  364,   -1 }, /* (323) topic_name ::= NK_ID */
  {  371,   -1 }, /* (324) stream_name ::= NK_ID */
  {  366,   -1 }, /* (325) cgroup_name ::= NK_ID */
  {  379,   -1 }, /* (326) expression ::= literal */
  {  379,   -1 }, /* (327) expression ::= pseudo_column */
  {  379,   -1 }, /* (328) expression ::= column_reference */
  {  379,   -1 }, /* (329) expression ::= function_expression */
  {  379,   -1 }, /* (330) expression ::= subquery */
  {  379,   -3 }, /* (331) expression ::= NK_LP expression NK_RP */
  {  379,   -2 }, /* (332) expression ::= NK_PLUS expression */
  {  379,   -2 }, /* (333) expression ::= NK_MINUS expression */
  {  379,   -3 }, /* (334) expression ::= expression NK_PLUS expression */
  {  379,   -3 }, /* (335) expression ::= expression NK_MINUS expression */
  {  379,   -3 }, /* (336) expression ::= expression NK_STAR expression */
  {  379,   -3 }, /* (337) expression ::= expression NK_SLASH expression */
  {  379,   -3 }, /* (338) expression ::= expression NK_REM expression */
  {  379,   -3 }, /* (339) expression ::= column_reference NK_ARROW NK_STRING */
  {  379,   -3 }, /* (340) expression ::= expression NK_BITAND expression */
  {  379,   -3 }, /* (341) expression ::= expression NK_BITOR expression */
  {  342,   -1 }, /* (342) expression_list ::= expression */
  {  342,   -3 }, /* (343) expression_list ::= expression_list NK_COMMA expression */
  {  381,   -1 }, /* (344) column_reference ::= column_name */
  {  381,   -3 }, /* (345) column_reference ::= table_name NK_DOT column_name */
  {  380,   -1 }, /* (346) pseudo_column ::= ROWTS */
  {  380,   -1 }, /* (347) pseudo_column ::= TBNAME */
  {  380,   -3 }, /* (348) pseudo_column ::= table_name NK_DOT TBNAME */
  {  380,   -1 }, /* (349) pseudo_column ::= QSTART */
  {  380,   -1 }, /* (350) pseudo_column ::= QEND */
  {  380,   -1 }, /* (351) pseudo_column ::= QDURATION */
  {  380,   -1 }, /* (352) pseudo_column ::= WSTART */
  {  380,   -1 }, /* (353) pseudo_column ::= WEND */
  {  380,   -1 }, /* (354) pseudo_column ::= WDURATION */
  {  382,   -4 }, /* (355) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  382,   -4 }, /* (356) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  382,   -6 }, /* (357) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  382,   -1 }, /* (358) function_expression ::= literal_func */
  {  375,   -3 }, /* (359) literal_func ::= noarg_func NK_LP NK_RP */
  {  375,   -1 }, /* (360) literal_func ::= NOW */
  {  386,   -1 }, /* (361) noarg_func ::= NOW */
  {  386,   -1 }, /* (362) noarg_func ::= TODAY */
  {  386,   -1 }, /* (363) noarg_func ::= TIMEZONE */
  {  386,   -1 }, /* (364) noarg_func ::= DATABASE */
  {  386,   -1 }, /* (365) noarg_func ::= CLIENT_VERSION */
  {  386,   -1 }, /* (366) noarg_func ::= SERVER_VERSION */
  {  386,   -1 }, /* (367) noarg_func ::= SERVER_STATUS */
  {  386,   -1 }, /* (368) noarg_func ::= CURRENT_USER */
  {  386,   -1 }, /* (369) noarg_func ::= USER */
  {  384,   -1 }, /* (370) star_func ::= COUNT */
  {  384,   -1 }, /* (371) star_func ::= FIRST */
  {  384,   -1 }, /* (372) star_func ::= LAST */
  {  384,   -1 }, /* (373) star_func ::= LAST_ROW */
  {  385,   -1 }, /* (374) star_func_para_list ::= NK_STAR */
  {  385,   -1 }, /* (375) star_func_para_list ::= other_para_list */
  {  387,   -1 }, /* (376) other_para_list ::= star_func_para */
  {  387,   -3 }, /* (377) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  388,   -1 }, /* (378) star_func_para ::= expression */
  {  388,   -3 }, /* (379) star_func_para ::= table_name NK_DOT NK_STAR */
  {  389,   -3 }, /* (380) predicate ::= expression compare_op expression */
  {  389,   -5 }, /* (381) predicate ::= expression BETWEEN expression AND expression */
  {  389,   -6 }, /* (382) predicate ::= expression NOT BETWEEN expression AND expression */
  {  389,   -3 }, /* (383) predicate ::= expression IS NULL */
  {  389,   -4 }, /* (384) predicate ::= expression IS NOT NULL */
  {  389,   -3 }, /* (385) predicate ::= expression in_op in_predicate_value */
  {  390,   -1 }, /* (386) compare_op ::= NK_LT */
  {  390,   -1 }, /* (387) compare_op ::= NK_GT */
  {  390,   -1 }, /* (388) compare_op ::= NK_LE */
  {  390,   -1 }, /* (389) compare_op ::= NK_GE */
  {  390,   -1 }, /* (390) compare_op ::= NK_NE */
  {  390,   -1 }, /* (391) compare_op ::= NK_EQ */
  {  390,   -1 }, /* (392) compare_op ::= LIKE */
  {  390,   -2 }, /* (393) compare_op ::= NOT LIKE */
  {  390,   -1 }, /* (394) compare_op ::= MATCH */
  {  390,   -1 }, /* (395) compare_op ::= NMATCH */
  {  390,   -1 }, /* (396) compare_op ::= CONTAINS */
  {  391,   -1 }, /* (397) in_op ::= IN */
  {  391,   -2 }, /* (398) in_op ::= NOT IN */
  {  392,   -3 }, /* (399) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  393,   -1 }, /* (400) boolean_value_expression ::= boolean_primary */
  {  393,   -2 }, /* (401) boolean_value_expression ::= NOT boolean_primary */
  {  393,   -3 }, /* (402) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  393,   -3 }, /* (403) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  394,   -1 }, /* (404) boolean_primary ::= predicate */
  {  394,   -3 }, /* (405) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  395,   -1 }, /* (406) common_expression ::= expression */
  {  395,   -1 }, /* (407) common_expression ::= boolean_value_expression */
  {  396,    0 }, /* (408) from_clause_opt ::= */
  {  396,   -2 }, /* (409) from_clause_opt ::= FROM table_reference_list */
  {  397,   -1 }, /* (410) table_reference_list ::= table_reference */
  {  397,   -3 }, /* (411) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  398,   -1 }, /* (412) table_reference ::= table_primary */
  {  398,   -1 }, /* (413) table_reference ::= joined_table */
  {  399,   -2 }, /* (414) table_primary ::= table_name alias_opt */
  {  399,   -4 }, /* (415) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  399,   -2 }, /* (416) table_primary ::= subquery alias_opt */
  {  399,   -1 }, /* (417) table_primary ::= parenthesized_joined_table */
  {  401,    0 }, /* (418) alias_opt ::= */
  {  401,   -1 }, /* (419) alias_opt ::= table_alias */
  {  401,   -2 }, /* (420) alias_opt ::= AS table_alias */
  {  402,   -3 }, /* (421) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  402,   -3 }, /* (422) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  400,   -6 }, /* (423) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  403,    0 }, /* (424) join_type ::= */
  {  403,   -1 }, /* (425) join_type ::= INNER */
  {  405,  -12 }, /* (426) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  406,    0 }, /* (427) set_quantifier_opt ::= */
  {  406,   -1 }, /* (428) set_quantifier_opt ::= DISTINCT */
  {  406,   -1 }, /* (429) set_quantifier_opt ::= ALL */
  {  407,   -1 }, /* (430) select_list ::= select_item */
  {  407,   -3 }, /* (431) select_list ::= select_list NK_COMMA select_item */
  {  415,   -1 }, /* (432) select_item ::= NK_STAR */
  {  415,   -1 }, /* (433) select_item ::= common_expression */
  {  415,   -2 }, /* (434) select_item ::= common_expression column_alias */
  {  415,   -3 }, /* (435) select_item ::= common_expression AS column_alias */
  {  415,   -3 }, /* (436) select_item ::= table_name NK_DOT NK_STAR */
  {  373,    0 }, /* (437) where_clause_opt ::= */
  {  373,   -2 }, /* (438) where_clause_opt ::= WHERE search_condition */
  {  408,    0 }, /* (439) partition_by_clause_opt ::= */
  {  408,   -3 }, /* (440) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  412,    0 }, /* (441) twindow_clause_opt ::= */
  {  412,   -6 }, /* (442) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  412,   -4 }, /* (443) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  412,   -6 }, /* (444) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  412,   -8 }, /* (445) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  360,    0 }, /* (446) sliding_opt ::= */
  {  360,   -4 }, /* (447) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  411,    0 }, /* (448) fill_opt ::= */
  {  411,   -4 }, /* (449) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  411,   -6 }, /* (450) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  416,   -1 }, /* (451) fill_mode ::= NONE */
  {  416,   -1 }, /* (452) fill_mode ::= PREV */
  {  416,   -1 }, /* (453) fill_mode ::= NULL */
  {  416,   -1 }, /* (454) fill_mode ::= LINEAR */
  {  416,   -1 }, /* (455) fill_mode ::= NEXT */
  {  413,    0 }, /* (456) group_by_clause_opt ::= */
  {  413,   -3 }, /* (457) group_by_clause_opt ::= GROUP BY group_by_list */
  {  417,   -1 }, /* (458) group_by_list ::= expression */
  {  417,   -3 }, /* (459) group_by_list ::= group_by_list NK_COMMA expression */
  {  414,    0 }, /* (460) having_clause_opt ::= */
  {  414,   -2 }, /* (461) having_clause_opt ::= HAVING search_condition */
  {  409,    0 }, /* (462) range_opt ::= */
  {  409,   -6 }, /* (463) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  410,    0 }, /* (464) every_opt ::= */
  {  410,   -4 }, /* (465) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  365,   -4 }, /* (466) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  418,   -1 }, /* (467) query_expression_body ::= query_primary */
  {  418,   -4 }, /* (468) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  418,   -3 }, /* (469) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  422,   -1 }, /* (470) query_primary ::= query_specification */
  {  422,   -6 }, /* (471) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  419,    0 }, /* (472) order_by_clause_opt ::= */
  {  419,   -3 }, /* (473) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  420,    0 }, /* (474) slimit_clause_opt ::= */
  {  420,   -2 }, /* (475) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  420,   -4 }, /* (476) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  420,   -4 }, /* (477) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  421,    0 }, /* (478) limit_clause_opt ::= */
  {  421,   -2 }, /* (479) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  421,   -4 }, /* (480) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  421,   -4 }, /* (481) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  383,   -3 }, /* (482) subquery ::= NK_LP query_expression NK_RP */
  {  404,   -1 }, /* (483) search_condition ::= common_expression */
  {  423,   -1 }, /* (484) sort_specification_list ::= sort_specification */
  {  423,   -3 }, /* (485) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  424,   -3 }, /* (486) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  425,    0 }, /* (487) ordering_specification_opt ::= */
  {  425,   -1 }, /* (488) ordering_specification_opt ::= ASC */
  {  425,   -1 }, /* (489) ordering_specification_opt ::= DESC */
  {  426,    0 }, /* (490) null_ordering_opt ::= */
  {  426,   -2 }, /* (491) null_ordering_opt ::= NULLS FIRST */
  {  426,   -2 }, /* (492) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,307,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,308,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,307,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,309,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,310,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,308,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,310,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,309,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy617, &yymsp[-1].minor.yy0, yymsp[0].minor.yy215); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy617, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy617, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy617, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy617); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy215 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy215 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy473, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy617); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy473, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy617); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy473 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy473 = yymsp[0].minor.yy473; }
  yymsp[0].minor.yy473 = yylhsminor.yy473;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy473 = yymsp[-2].minor.yy473 | yymsp[0].minor.yy473; }
  yymsp[-2].minor.yy473 = yylhsminor.yy473;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy473 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy473 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy617 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy617 = yylhsminor.yy617;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy617 = yymsp[-2].minor.yy617; }
  yymsp[-2].minor.yy617 = yylhsminor.yy617;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy617, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy617); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 316: /* db_name ::= NK_ID */ yytestcase(yyruleno==316);
      case 317: /* table_name ::= NK_ID */ yytestcase(yyruleno==317);
      case 318: /* column_name ::= NK_ID */ yytestcase(yyruleno==318);
      case 319: /* function_name ::= NK_ID */ yytestcase(yyruleno==319);
      case 320: /* table_alias ::= NK_ID */ yytestcase(yyruleno==320);
      case 321: /* column_alias ::= NK_ID */ yytestcase(yyruleno==321);
      case 322: /* user_name ::= NK_ID */ yytestcase(yyruleno==322);
      case 323: /* topic_name ::= NK_ID */ yytestcase(yyruleno==323);
      case 324: /* stream_name ::= NK_ID */ yytestcase(yyruleno==324);
      case 325: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==325);
      case 361: /* noarg_func ::= NOW */ yytestcase(yyruleno==361);
      case 362: /* noarg_func ::= TODAY */ yytestcase(yyruleno==362);
      case 363: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==363);
      case 364: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==364);
      case 365: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==365);
      case 366: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==366);
      case 367: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==367);
      case 368: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==368);
      case 369: /* noarg_func ::= USER */ yytestcase(yyruleno==369);
      case 370: /* star_func ::= COUNT */ yytestcase(yyruleno==370);
      case 371: /* star_func ::= FIRST */ yytestcase(yyruleno==371);
      case 372: /* star_func ::= LAST */ yytestcase(yyruleno==372);
      case 373: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==373);
{ yylhsminor.yy617 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy617 = yylhsminor.yy617;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy313, &yymsp[-1].minor.yy617, yymsp[0].minor.yy840); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy313, &yymsp[0].minor.yy617); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy617); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy617, yymsp[0].minor.yy840); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy617); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[0].minor.yy617); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy313 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 259: /* analyze_opt ::= */ yytestcase(yyruleno==259);
      case 266: /* agg_func_opt ::= */ yytestcase(yyruleno==266);
      case 427: /* set_quantifier_opt ::= */ yytestcase(yyruleno==427);
{ yymsp[1].minor.yy313 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy313 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy840 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 79: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 80: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 81: /* db_options ::= db_options KEEP integer_list */
      case 82: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==82);
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_KEEP, yymsp[0].minor.yy544); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 83: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 84: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 85: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 86: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 87: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 88: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 89: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 90: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_RETENTIONS, yymsp[0].minor.yy544); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 91: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 92: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 93: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 94: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 95: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-3].minor.yy840, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 96: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-3].minor.yy840, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 98: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 99: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 100: /* db_options ::= db_options SST_TRIGGER NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_SST_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 101: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy840 = createAlterDatabaseOptions(pCxt); yylhsminor.yy840 = setAlterDatabaseOption(pCxt, yylhsminor.yy840, &yymsp[0].minor.yy95); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 102: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy840 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy840, &yymsp[0].minor.yy95); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 103: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy95.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy95.val = yymsp[0].minor.yy0; }
        break;
      case 104: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy95.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy95.val = yymsp[0].minor.yy0; }
        break;
      case 105: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy95.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy95.val = yymsp[0].minor.yy0; }
        break;
      case 106: /* alter_db_option ::= KEEP integer_list */
      case 107: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==107);
{ yymsp[-1].minor.yy95.type = DB_OPTION_KEEP; yymsp[-1].minor.yy95.pList = yymsp[0].minor.yy544; }
        break;
      case 108: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy95.type = DB_OPTION_WAL; yymsp[-1].minor.yy95.val = yymsp[0].minor.yy0; }
        break;
      case 109: /* alter_db_option ::= SST_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy95.type = DB_OPTION_SST_TRIGGER; yymsp[-1].minor.yy95.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy544 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy544 = yylhsminor.yy544;
        break;
      case 111: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 286: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==286);
{ yylhsminor.yy544 = addNodeToList(pCxt, yymsp[-2].minor.yy544, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy544 = yylhsminor.yy544;
        break;
      case 112: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy544 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy544 = yylhsminor.yy544;
        break;
      case 113: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy544 = addNodeToList(pCxt, yymsp[-2].minor.yy544, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy544 = yylhsminor.yy544;
        break;
      case 114: /* retention_list ::= retention */
      case 134: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==134);
      case 137: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==137);
      case 144: /* column_def_list ::= column_def */ yytestcase(yyruleno==144);
      case 187: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==187);
      case 192: /* col_name_list ::= col_name */ yytestcase(yyruleno==192);
      case 242: /* func_list ::= func */ yytestcase(yyruleno==242);
      case 314: /* literal_list ::= signed_literal */ yytestcase(yyruleno==314);
      case 376: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==376);
      case 430: /* select_list ::= select_item */ yytestcase(yyruleno==430);
      case 484: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==484);
{ yylhsminor.yy544 = createNodeList(pCxt, yymsp[0].minor.yy840); }
  yymsp[0].minor.yy544 = yylhsminor.yy544;
        break;
      case 115: /* retention_list ::= retention_list NK_COMMA retention */
      case 145: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==145);
      case 188: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==188);
      case 193: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==193);
      case 243: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==243);
      case 315: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==315);
      case 377: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==377);
      case 431: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==431);
      case 485: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==485);
{ yylhsminor.yy544 = addNodeToList(pCxt, yymsp[-2].minor.yy544, yymsp[0].minor.yy840); }
  yymsp[-2].minor.yy544 = yylhsminor.yy544;
        break;
      case 116: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy840 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 117: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 119: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==119);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy313, yymsp[-5].minor.yy840, yymsp[-3].minor.yy544, yymsp[-1].minor.yy544, yymsp[0].minor.yy840); }
        break;
      case 118: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy544); }
        break;
      case 120: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy544); }
        break;
      case 121: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy313, yymsp[0].minor.yy840); }
        break;
      case 122: /* cmd ::= ALTER TABLE alter_table_clause */
      case 288: /* cmd ::= query_expression */ yytestcase(yyruleno==288);
{ pCxt->pRootNode = yymsp[0].minor.yy840; }
        break;
      case 123: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy840); }
        break;
      case 124: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy840 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy840, yymsp[0].minor.yy840); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 125: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy840 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy840, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy617, yymsp[0].minor.yy784); }
  yymsp[-4].minor.yy840 = yylhsminor.yy840;
        break;
      case 126: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy840 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy840, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy617); }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 127: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy840 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy840, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy617, yymsp[0].minor.yy784); }
  yymsp[-4].minor.yy840 = yylhsminor.yy840;
        break;
      case 128: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy840 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy840, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy617, &yymsp[0].minor.yy617); }
  yymsp[-4].minor.yy840 = yylhsminor.yy840;
        break;
      case 129: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy840 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy840, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy617, yymsp[0].minor.yy784); }
  yymsp[-4].minor.yy840 = yylhsminor.yy840;
        break;
      case 130: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy840 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy840, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy617); }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 131: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy840 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy840, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy617, yymsp[0].minor.yy784); }
  yymsp[-4].minor.yy840 = yylhsminor.yy840;
        break;
      case 132: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy840 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy840, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy617, &yymsp[0].minor.yy617); }
  yymsp[-4].minor.yy840 = yylhsminor.yy840;
        break;
      case 133: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy840 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy840, &yymsp[-2].minor.yy617, yymsp[0].minor.yy840); }
  yymsp[-5].minor.yy840 = yylhsminor.yy840;
        break;
      case 135: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 138: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==138);
{ yylhsminor.yy544 = addNodeToList(pCxt, yymsp[-1].minor.yy544, yymsp[0].minor.yy840); }
  yymsp[-1].minor.yy544 = yylhsminor.yy544;
        break;
      case 136: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy840 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy313, yymsp[-8].minor.yy840, yymsp[-6].minor.yy840, yymsp[-5].minor.yy544, yymsp[-2].minor.yy544, yymsp[0].minor.yy840); }
  yymsp[-9].minor.yy840 = yylhsminor.yy840;
        break;
      case 139: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy840 = createDropTableClause(pCxt, yymsp[-1].minor.yy313, yymsp[0].minor.yy840); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 140: /* specific_cols_opt ::= */
      case 171: /* tags_def_opt ::= */ yytestcase(yyruleno==171);
      case 439: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==439);
      case 456: /* group_by_clause_opt ::= */ yytestcase(yyruleno==456);
      case 472: /* order_by_clause_opt ::= */ yytestcase(yyruleno==472);
{ yymsp[1].minor.yy544 = NULL; }
        break;
      case 141: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy544 = yymsp[-1].minor.yy544; }
        break;
      case 142: /* full_table_name ::= table_name */
{ yylhsminor.yy840 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy617, NULL); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 143: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy840 = createRealTableNode(pCxt, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy617, NULL); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 146: /* column_def ::= column_name type_name */
{ yylhsminor.yy840 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy617, yymsp[0].minor.yy784, NULL); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 147: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy840 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy617, yymsp[-2].minor.yy784, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 148: /* type_name ::= BOOL */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 149: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 150: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 151: /* type_name ::= INT */
      case 152: /* type_name ::= INTEGER */ yytestcase(yyruleno==152);
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 153: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 154: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 155: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 156: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 158: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 159: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy784 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 160: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy784 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 161: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy784 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 162: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy784 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 163: /* type_name ::= JSON */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 164: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 165: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 166: /* type_name ::= BLOB */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 167: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 169: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 170: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy784 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 172: /* tags_def_opt ::= tags_def */
      case 375: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==375);
{ yylhsminor.yy544 = yymsp[0].minor.yy544; }
  yymsp[0].minor.yy544 = yylhsminor.yy544;
        break;
      case 173: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy544 = yymsp[-1].minor.yy544; }
        break;
      case 174: /* table_options ::= */
{ yymsp[1].minor.yy840 = createDefaultTableOptions(pCxt); }
        break;
      case 175: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy840 = setTableOption(pCxt, yymsp[-2].minor.yy840, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 176: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy840 = setTableOption(pCxt, yymsp[-2].minor.yy840, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy544); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 177: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy840 = setTableOption(pCxt, yymsp[-2].minor.yy840, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy544); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 178: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy840 = setTableOption(pCxt, yymsp[-4].minor.yy840, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy544); }
  yymsp[-4].minor.yy840 = yylhsminor.yy840;
        break;
      case 179: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy840 = setTableOption(pCxt, yymsp[-2].minor.yy840, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 180: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy840 = setTableOption(pCxt, yymsp[-4].minor.yy840, TABLE_OPTION_SMA, yymsp[-1].minor.yy544); }
  yymsp[-4].minor.yy840 = yylhsminor.yy840;
        break;
      case 181: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy840 = createAlterTableOptions(pCxt); yylhsminor.yy840 = setTableOption(pCxt, yylhsminor.yy840, yymsp[0].minor.yy95.type, &yymsp[0].minor.yy95.val); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 182: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy840 = setTableOption(pCxt, yymsp[-1].minor.yy840, yymsp[0].minor.yy95.type, &yymsp[0].minor.yy95.val); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 183: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy95.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy95.val = yymsp[0].minor.yy0; }
        break;
      case 184: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy95.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy95.val = yymsp[0].minor.yy0; }
        break;
      case 185: /* duration_list ::= duration_literal */
      case 342: /* expression_list ::= expression */ yytestcase(yyruleno==342);
{ yylhsminor.yy544 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy840)); }
  yymsp[0].minor.yy544 = yylhsminor.yy544;
        break;
      case 186: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 343: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==343);
{ yylhsminor.yy544 = addNodeToList(pCxt, yymsp[-2].minor.yy544, releaseRawExprNode(pCxt, yymsp[0].minor.yy840)); }
  yymsp[-2].minor.yy544 = yylhsminor.yy544;
        break;
      case 189: /* rollup_func_name ::= function_name */
{ yylhsminor.yy840 = createFunctionNode(pCxt, &yymsp[0].minor.yy617, NULL); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 190: /* rollup_func_name ::= FIRST */
      case 191: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==191);
{ yylhsminor.yy840 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 194: /* col_name ::= column_name */
{ yylhsminor.yy840 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy617); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 195: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 196: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 197: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 198: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy840, yymsp[0].minor.yy840, OP_TYPE_LIKE); }
        break;
      case 199: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy840, yymsp[0].minor.yy840, OP_TYPE_LIKE); }
        break;
      case 200: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy840, NULL, OP_TYPE_LIKE); }
        break;
      case 201: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 202: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 203: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 204: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 205: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy840, yymsp[-1].minor.yy840, OP_TYPE_EQUAL); }
        break;
      case 206: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 207: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 208: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 209: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 210: /* cmd ::= SHOW LICENCES */
      case 211: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==211);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 212: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy617); }
        break;
      case 213: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy840); }
        break;
      case 214: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy840); }
        break;
      case 215: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 216: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 217: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 218: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 219: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 220: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 221: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 222: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 223: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 224: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 225: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy840); }
        break;
      case 226: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 227: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 228: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy840, yymsp[-1].minor.yy840, OP_TYPE_EQUAL); }
        break;
      case 229: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 230: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 231: /* db_name_cond_opt ::= */
      case 236: /* from_db_opt ::= */ yytestcase(yyruleno==236);
{ yymsp[1].minor.yy840 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 232: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy617); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 233: /* like_pattern_opt ::= */
      case 408: /* from_clause_opt ::= */ yytestcase(yyruleno==408);
      case 437: /* where_clause_opt ::= */ yytestcase(yyruleno==437);
      case 441: /* twindow_clause_opt ::= */ yytestcase(yyruleno==441);
      case 446: /* sliding_opt ::= */ yytestcase(yyruleno==446);
      case 448: /* fill_opt ::= */ yytestcase(yyruleno==448);
      case 460: /* having_clause_opt ::= */ yytestcase(yyruleno==460);
      case 462: /* range_opt ::= */ yytestcase(yyruleno==462);
      case 464: /* every_opt ::= */ yytestcase(yyruleno==464);
      case 474: /* slimit_clause_opt ::= */ yytestcase(yyruleno==474);
      case 478: /* limit_clause_opt ::= */ yytestcase(yyruleno==478);
{ yymsp[1].minor.yy840 = NULL; }
        break;
      case 234: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 235: /* table_name_cond ::= table_name */
{ yylhsminor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy617); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 237: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy617); }
        break;
      case 238: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy313, yymsp[-3].minor.yy840, yymsp[-1].minor.yy840, NULL, yymsp[0].minor.yy840); }
        break;
      case 239: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy313, yymsp[0].minor.yy840); }
        break;
      case 240: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy840 = createIndexOption(pCxt, yymsp[-7].minor.yy544, releaseRawExprNode(pCxt, yymsp[-3].minor.yy840), NULL, yymsp[-1].minor.yy840, yymsp[0].minor.yy840); }
        break;
      case 241: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy840 = createIndexOption(pCxt, yymsp[-9].minor.yy544, releaseRawExprNode(pCxt, yymsp[-5].minor.yy840), releaseRawExprNode(pCxt, yymsp[-3].minor.yy840), yymsp[-1].minor.yy840, yymsp[0].minor.yy840); }
        break;
      case 244: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy840 = createFunctionNode(pCxt, &yymsp[-3].minor.yy617, yymsp[-1].minor.yy544); }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 245: /* sma_stream_opt ::= */
      case 272: /* stream_options ::= */ yytestcase(yyruleno==272);
{ yymsp[1].minor.yy840 = createStreamOptions(pCxt); }
        break;
      case 246: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 276: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==276);
{ ((SStreamOptions*)yymsp[-2].minor.yy840)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy840); yylhsminor.yy840 = yymsp[-2].minor.yy840; }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 247: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy840)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy840); yylhsminor.yy840 = yymsp[-2].minor.yy840; }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 248: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy313, &yymsp[-2].minor.yy617, yymsp[0].minor.yy840); }
        break;
      case 249: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy313, &yymsp[-3].minor.yy617, &yymsp[0].minor.yy617, false); }
        break;
      case 250: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy313, &yymsp[-5].minor.yy617, &yymsp[0].minor.yy617, true); }
        break;
      case 251: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy313, &yymsp[-3].minor.yy617, yymsp[0].minor.yy840, false); }
        break;
      case 252: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy313, &yymsp[-5].minor.yy617, yymsp[0].minor.yy840, true); }
        break;
      case 253: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy313, &yymsp[0].minor.yy617); }
        break;
      case 254: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy313, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy617); }
        break;
      case 255: /* cmd ::= DESC full_table_name */
      case 256: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==256);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy840); }
        break;
      case 257: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 258: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy313, yymsp[-1].minor.yy840, yymsp[0].minor.yy840); }
        break;
      case 260: /* analyze_opt ::= ANALYZE */
      case 267: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==267);
      case 428: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==428);
{ yymsp[0].minor.yy313 = true; }
        break;
      case 261: /* explain_options ::= */
{ yymsp[1].minor.yy840 = createDefaultExplainOptions(pCxt); }
        break;
      case 262: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy840 = setExplainVerbose(pCxt, yymsp[-2].minor.yy840, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 263: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy840 = setExplainRatio(pCxt, yymsp[-2].minor.yy840, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 264: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy313, yymsp[-8].minor.yy313, &yymsp[-5].minor.yy617, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy784, yymsp[0].minor.yy844); }
        break;
      case 265: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy313, &yymsp[0].minor.yy617); }
        break;
      case 268: /* bufsize_opt ::= */
{ yymsp[1].minor.yy844 = 0; }
        break;
      case 269: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy844 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 270: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-6].minor.yy313, &yymsp[-5].minor.yy617, yymsp[-2].minor.yy840, yymsp[-4].minor.yy840, yymsp[0].minor.yy840); }
        break;
      case 271: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy313, &yymsp[0].minor.yy617); }
        break;
      case 273: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy840)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy840 = yymsp[-2].minor.yy840; }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 274: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy840)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy840 = yymsp[-2].minor.yy840; }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 275: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy840)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy840)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy840); yylhsminor.yy840 = yymsp[-3].minor.yy840; }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 277: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy840)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy840 = yymsp[-3].minor.yy840; }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 278: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 279: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 280: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 281: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 282: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 283: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy544); }
        break;
      case 284: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 285: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy544 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 287: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy840, yymsp[0].minor.yy840); }
        break;
      case 289: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy840, yymsp[-2].minor.yy544, yymsp[0].minor.yy840); }
        break;
      case 290: /* cmd ::= INSERT INTO full_table_name query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy840, NULL, yymsp[0].minor.yy840); }
        break;
      case 291: /* literal ::= NK_INTEGER */
{ yylhsminor.yy840 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 292: /* literal ::= NK_FLOAT */
{ yylhsminor.yy840 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 293: /* literal ::= NK_STRING */
{ yylhsminor.yy840 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 294: /* literal ::= NK_BOOL */
{ yylhsminor.yy840 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 295: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 296: /* literal ::= duration_literal */
      case 306: /* signed_literal ::= signed */ yytestcase(yyruleno==306);
      case 326: /* expression ::= literal */ yytestcase(yyruleno==326);
      case 327: /* expression ::= pseudo_column */ yytestcase(yyruleno==327);
      case 328: /* expression ::= column_reference */ yytestcase(yyruleno==328);
      case 329: /* expression ::= function_expression */ yytestcase(yyruleno==329);
      case 330: /* expression ::= subquery */ yytestcase(yyruleno==330);
      case 358: /* function_expression ::= literal_func */ yytestcase(yyruleno==358);
      case 400: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==400);
      case 404: /* boolean_primary ::= predicate */ yytestcase(yyruleno==404);
      case 406: /* common_expression ::= expression */ yytestcase(yyruleno==406);
      case 407: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==407);
      case 410: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==410);
      case 412: /* table_reference ::= table_primary */ yytestcase(yyruleno==412);
      case 413: /* table_reference ::= joined_table */ yytestcase(yyruleno==413);
      case 417: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==417);
      case 467: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==467);
      case 470: /* query_primary ::= query_specification */ yytestcase(yyruleno==470);
{ yylhsminor.yy840 = yymsp[0].minor.yy840; }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 297: /* literal ::= NULL */
{ yylhsminor.yy840 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 298: /* literal ::= NK_QUESTION */
{ yylhsminor.yy840 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 299: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy840 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 300: /* signed ::= NK_INTEGER */
{ yylhsminor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 301: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 302: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 303: /* signed ::= NK_FLOAT */
{ yylhsminor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 304: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 305: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 307: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 308: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 309: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 310: /* signed_literal ::= duration_literal */
      case 312: /* signed_literal ::= literal_func */ yytestcase(yyruleno==312);
      case 378: /* star_func_para ::= expression */ yytestcase(yyruleno==378);
      case 433: /* select_item ::= common_expression */ yytestcase(yyruleno==433);
      case 483: /* search_condition ::= common_expression */ yytestcase(yyruleno==483);
{ yylhsminor.yy840 = releaseRawExprNode(pCxt, yymsp[0].minor.yy840); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 311: /* signed_literal ::= NULL */
{ yylhsminor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 313: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy840 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 331: /* expression ::= NK_LP expression NK_RP */
      case 405: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==405);
{ yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy840)); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 332: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy840));
                                                                                  }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 333: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy840), NULL));
                                                                                  }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 334: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840))); 
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 335: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840))); 
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 336: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840))); 
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 337: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840))); 
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 338: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840)));
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 339: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 340: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840)));
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 341: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840)));
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 344: /* column_reference ::= column_name */
{ yylhsminor.yy840 = createRawExprNode(pCxt, &yymsp[0].minor.yy617, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy617)); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 345: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy617, createColumnNode(pCxt, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy617)); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 346: /* pseudo_column ::= ROWTS */
      case 347: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==347);
      case 349: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==349);
      case 350: /* pseudo_column ::= QEND */ yytestcase(yyruleno==350);
      case 351: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==351);
      case 352: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==352);
      case 353: /* pseudo_column ::= WEND */ yytestcase(yyruleno==353);
      case 354: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==354);
      case 360: /* literal_func ::= NOW */ yytestcase(yyruleno==360);
{ yylhsminor.yy840 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 348: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy617)))); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 355: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 356: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==356);
{ yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy617, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy617, yymsp[-1].minor.yy544)); }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 357: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy840), yymsp[-1].minor.yy784)); }
  yymsp[-5].minor.yy840 = yylhsminor.yy840;
        break;
      case 359: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy617, NULL)); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 374: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy544 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy544 = yylhsminor.yy544;
        break;
      case 379: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 436: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==436);
{ yylhsminor.yy840 = createColumnNode(pCxt, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 380: /* predicate ::= expression compare_op expression */
      case 385: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==385);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy198, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840)));
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 381: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy840), releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840)));
                                                                                  }
  yymsp[-4].minor.yy840 = yylhsminor.yy840;
        break;
      case 382: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy840), releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840)));
                                                                                  }
  yymsp[-5].minor.yy840 = yylhsminor.yy840;
        break;
      case 383: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), NULL));
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 384: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy840), NULL));
                                                                                  }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 386: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy198 = OP_TYPE_LOWER_THAN; }
        break;
      case 387: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy198 = OP_TYPE_GREATER_THAN; }
        break;
      case 388: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy198 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 389: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy198 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 390: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy198 = OP_TYPE_NOT_EQUAL; }
        break;
      case 391: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy198 = OP_TYPE_EQUAL; }
        break;
      case 392: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy198 = OP_TYPE_LIKE; }
        break;
      case 393: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy198 = OP_TYPE_NOT_LIKE; }
        break;
      case 394: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy198 = OP_TYPE_MATCH; }
        break;
      case 395: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy198 = OP_TYPE_NMATCH; }
        break;
      case 396: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy198 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 397: /* in_op ::= IN */
{ yymsp[0].minor.yy198 = OP_TYPE_IN; }
        break;
      case 398: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy198 = OP_TYPE_NOT_IN; }
        break;
      case 399: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy544)); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 401: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy840), NULL));
                                                                                  }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 402: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840)));
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 403: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840)));
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 409: /* from_clause_opt ::= FROM table_reference_list */
      case 438: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==438);
      case 461: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==461);
{ yymsp[-1].minor.yy840 = yymsp[0].minor.yy840; }
        break;
      case 411: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy840 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy840, yymsp[0].minor.yy840, NULL); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 414: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy840 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy617, &yymsp[0].minor.yy617); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 415: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy840 = createRealTableNode(pCxt, &yymsp[-3].minor.yy617, &yymsp[-1].minor.yy617, &yymsp[0].minor.yy617); }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 416: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy840 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy840), &yymsp[0].minor.yy617); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 418: /* alias_opt ::= */
{ yymsp[1].minor.yy617 = nil_token;  }
        break;
      case 419: /* alias_opt ::= table_alias */
{ yylhsminor.yy617 = yymsp[0].minor.yy617; }
  yymsp[0].minor.yy617 = yylhsminor.yy617;
        break;
      case 420: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy617 = yymsp[0].minor.yy617; }
        break;
      case 421: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 422: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==422);
{ yymsp[-2].minor.yy840 = yymsp[-1].minor.yy840; }
        break;
      case 423: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy840 = createJoinTableNode(pCxt, yymsp[-4].minor.yy708, yymsp[-5].minor.yy840, yymsp[-2].minor.yy840, yymsp[0].minor.yy840); }
  yymsp[-5].minor.yy840 = yylhsminor.yy840;
        break;
      case 424: /* join_type ::= */
{ yymsp[1].minor.yy708 = JOIN_TYPE_INNER; }
        break;
      case 425: /* join_type ::= INNER */
{ yymsp[0].minor.yy708 = JOIN_TYPE_INNER; }
        break;
      case 426: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy840 = createSelectStmt(pCxt, yymsp[-10].minor.yy313, yymsp[-9].minor.yy544, yymsp[-8].minor.yy840);
                                                                                    yymsp[-11].minor.yy840 = addWhereClause(pCxt, yymsp[-11].minor.yy840, yymsp[-7].minor.yy840);
                                                                                    yymsp[-11].minor.yy840 = addPartitionByClause(pCxt, yymsp[-11].minor.yy840, yymsp[-6].minor.yy544);
                                                                                    yymsp[-11].minor.yy840 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy840, yymsp[-2].minor.yy840);
                                                                                    yymsp[-11].minor.yy840 = addGroupByClause(pCxt, yymsp[-11].minor.yy840, yymsp[-1].minor.yy544);
                                                                                    yymsp[-11].minor.yy840 = addHavingClause(pCxt, yymsp[-11].minor.yy840, yymsp[0].minor.yy840);
                                                                                    yymsp[-11].minor.yy840 = addRangeClause(pCxt, yymsp[-11].minor.yy840, yymsp[-5].minor.yy840);
                                                                                    yymsp[-11].minor.yy840 = addEveryClause(pCxt, yymsp[-11].minor.yy840, yymsp[-4].minor.yy840);
                                                                                    yymsp[-11].minor.yy840 = addFillClause(pCxt, yymsp[-11].minor.yy840, yymsp[-3].minor.yy840);
                                                                                  }
        break;
      case 429: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy313 = false; }
        break;
      case 432: /* select_item ::= NK_STAR */
{ yylhsminor.yy840 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 434: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy840 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy840), &yymsp[0].minor.yy617); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 435: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy840 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), &yymsp[0].minor.yy617); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 440: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 457: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==457);
      case 473: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==473);
{ yymsp[-2].minor.yy544 = yymsp[0].minor.yy544; }
        break;
      case 442: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy840 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy840), releaseRawExprNode(pCxt, yymsp[-1].minor.yy840)); }
        break;
      case 443: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy840 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy840)); }
        break;
      case 444: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy840 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy840), NULL, yymsp[-1].minor.yy840, yymsp[0].minor.yy840); }
        break;
      case 445: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy840 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy840), releaseRawExprNode(pCxt, yymsp[-3].minor.yy840), yymsp[-1].minor.yy840, yymsp[0].minor.yy840); }
        break;
      case 447: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 465: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==465);
{ yymsp[-3].minor.yy840 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy840); }
        break;
      case 449: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy840 = createFillNode(pCxt, yymsp[-1].minor.yy816, NULL); }
        break;
      case 450: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy840 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy544)); }
        break;
      case 451: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy816 = FILL_MODE_NONE; }
        break;
      case 452: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy816 = FILL_MODE_PREV; }
        break;
      case 453: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy816 = FILL_MODE_NULL; }
        break;
      case 454: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy816 = FILL_MODE_LINEAR; }
        break;
      case 455: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy816 = FILL_MODE_NEXT; }
        break;
      case 458: /* group_by_list ::= expression */
{ yylhsminor.yy544 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy840))); }
  yymsp[0].minor.yy544 = yylhsminor.yy544;
        break;
      case 459: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy544 = addNodeToList(pCxt, yymsp[-2].minor.yy544, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy840))); }
  yymsp[-2].minor.yy544 = yylhsminor.yy544;
        break;
      case 463: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy840 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy840), releaseRawExprNode(pCxt, yymsp[-1].minor.yy840)); }
        break;
      case 466: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy840 = addOrderByClause(pCxt, yymsp[-3].minor.yy840, yymsp[-2].minor.yy544);
                                                                                    yylhsminor.yy840 = addSlimitClause(pCxt, yylhsminor.yy840, yymsp[-1].minor.yy840);
                                                                                    yylhsminor.yy840 = addLimitClause(pCxt, yylhsminor.yy840, yymsp[0].minor.yy840);
                                                                                  }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 468: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy840 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy840, yymsp[0].minor.yy840); }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 469: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy840 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy840, yymsp[0].minor.yy840); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 471: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ 
                                                                                    yymsp[-5].minor.yy840 = addOrderByClause(pCxt, yymsp[-4].minor.yy840, yymsp[-3].minor.yy544);
                                                                                    yymsp[-5].minor.yy840 = addSlimitClause(pCxt, yymsp[-5].minor.yy840, yymsp[-2].minor.yy840);
                                                                                    yymsp[-5].minor.yy840 = addLimitClause(pCxt, yymsp[-5].minor.yy840, yymsp[-1].minor.yy840);
                                                                                  }
        break;
      case 475: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 479: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==479);
{ yymsp[-1].minor.yy840 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 476: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 480: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==480);
{ yymsp[-3].minor.yy840 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 477: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 481: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==481);
{ yymsp[-3].minor.yy840 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 482: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy840); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 486: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy840 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), yymsp[-1].minor.yy204, yymsp[0].minor.yy277); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 487: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy204 = ORDER_ASC; }
        break;
      case 488: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy204 = ORDER_ASC; }
        break;
      case 489: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy204 = ORDER_DESC; }
        break;
      case 490: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy277 = NULL_ORDER_DEFAULT; }
        break;
      case 491: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy277 = NULL_ORDER_FIRST; }
        break;
      case 492: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy277 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
