---
sidebar_label: Go
title: 使用 Go 连接器建立连接
description: 使用 Go 连接器建立和 TDengine Cloud 的连接
---

<!-- exclude -->
import Tabs from '@theme/Tabs';
import TabItem from '@theme/TabItem';

<!-- exclude-end -->
## 初始化模块

```
go mod init tdengine.com/example
```

## 增加模块依赖

在 `go.mod` 文件中增加 `driver-go` 依赖。

```go-mod title="go.mod"
{{#include docs/examples/go/connectexample/go.mod}}
```

## 配置

在您的终端里面执行下面的命令设置 DSN(数据源名称) 为系统环境变量：

<Tabs defaultValue="bash">
<TabItem value="bash" label="Bash">

```bash
export TDENGINE_GO_DSN="<goDSN>"
```

</TabItem>
<TabItem value="cmd" label="CMD">

```bash
set TDENGINE_GO_DSN=<goDSN>
```

</TabItem>
<TabItem value="powershell" label="Powershell">

```powershell
$env:TDENGINE_GO_DSN='<goDSN>'
```

</TabItem>
</Tabs>


<!-- exclude -->
:::note
替换 <goDSN\> 为 真实的值，格式应该是 `https(<cloud_endpoint>)/?token=<token>`。

获取真实的 `goDSN` 的值，请登录[TDengine Cloud](https://cloud.taosdata.com) 后点击左边的”编程“菜单，然后选择”Go“。
:::
<!-- exclude-end -->

## 建立连接

复制代码到 main.go 文件。

```go title="main.go"
{{#include docs/examples/go/connectexample/main.go}}
```

执行下面的命令下载相关依赖：

```bash
go mod tidy
```

最后运行下面命令测试连接：

```bash
go run main.go
```

客户端连接建立连接以后，想了解更多写入数据和查询数据的内容，请参考 <https://docs.taosdata.com/cloud/data-in/insert-data/> and <https://docs.taosdata.com/cloud/data-out/query-data/>.

想知道更多通过 REST 接口写入数据的详情，请参考[REST 接口](https://docs.taosdata.com/cloud/programming/connector/rest-api/).
