/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 376
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EJoinType yy52;
  bool yy89;
  SDataType yy224;
  int32_t yy228;
  SNode* yy248;
  SAlterOption yy301;
  ENullOrder yy345;
  SToken yy401;
  EOrder yy482;
  int64_t yy525;
  SNodeList* yy552;
  EFillMode yy582;
  int8_t yy695;
  EOperatorType yy716;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             661
#define YYNRULE              485
#define YYNTOKEN             253
#define YY_MAX_SHIFT         660
#define YY_MIN_SHIFTREDUCE   962
#define YY_MAX_SHIFTREDUCE   1446
#define YY_ERROR_ACTION      1447
#define YY_ACCEPT_ACTION     1448
#define YY_NO_ACTION         1449
#define YY_MIN_REDUCE        1450
#define YY_MAX_REDUCE        1934
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2363)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   430,  549,  431, 1485,  438, 1685,  431, 1485, 1576,  549,
 /*    10 */    34,   33,   40,   38,   41,   39,   37,   36,   35, 1753,
 /*    20 */   337,   71, 1248, 1451,  379, 1756,  435,  342,  552,  122,
 /*    30 */  1630, 1632, 1270, 1323,  117, 1246, 1753,  122,   41,   39,
 /*    40 */    37,   36,   35, 1580,  103, 1749, 1755,  102,  101,  100,
 /*    50 */    99,   98,   97,   96,   95,   94, 1318,  570,  554, 1912,
 /*    60 */    14, 1448, 1749, 1755,  326, 1912, 1254, 1769,   62,  120,
 /*    70 */   385, 1012, 1911, 1011,  570,  447, 1909,  120,  159,   40,
 /*    80 */    38, 1386, 1909,    1,  156, 1854, 1855,  337, 1859, 1248,
 /*    90 */  1273,   44,  249, 1854,  548, 1787,  547,  995,  513, 1912,
 /*   100 */  1323, 1013, 1246,  577, 1473,  657,  323,  301, 1739, 1682,
 /*   110 */   576,  142,  161, 1462,   61, 1912, 1909,  482,  481, 1325,
 /*   120 */  1326,  349,  480, 1318,  554,  118,  477,   14,  160,  476,
 /*   130 */   475,  474, 1909, 1254, 1681, 1800,  298,  999, 1000,   89,
 /*   140 */  1770,  579, 1772, 1773,  575, 1739,  570,   61,  610, 1846,
 /*   150 */     2,   34,   33,  304, 1842,   41,   39,   37,   36,   35,
 /*   160 */   220,  221, 1912, 1912, 1249, 1912, 1247,  131,  130,  607,
 /*   170 */   606,  605,  657, 1512,  552,  159, 1910, 1637,  161, 1909,
 /*   180 */  1909,  143, 1909,  418,  325, 1542, 1325, 1326, 1450, 1145,
 /*   190 */  1146, 1252, 1253, 1635, 1301, 1302, 1304, 1305, 1306, 1307,
 /*   200 */  1308,  572,  568, 1316, 1317, 1319, 1320, 1321, 1322, 1324,
 /*   210 */  1327,   61,  112,  111,  110,  109,  108,  107,  106,  105,
 /*   220 */   104,  303,  558,  162,  515,   31,  259, 1417,  214,  174,
 /*   230 */   173, 1249,  219, 1247,   71,  634,  633,  632,  345, 1407,
 /*   240 */   631,  630,  629,  123,  624,  623,  622,  621,  620,  619,
 /*   250 */   618,  617,  133,  613,  162,   61, 1581,   75, 1252, 1253,
 /*   260 */  1273, 1301, 1302, 1304, 1305, 1306, 1307, 1308,  572,  568,
 /*   270 */  1316, 1317, 1319, 1320, 1321, 1322, 1324, 1327,   40,   38,
 /*   280 */   535, 1405, 1406, 1408, 1409,  549,  337,  162, 1248,  627,
 /*   290 */   512,  378,  347,  377, 1228, 1229, 1631, 1632,  370, 1323,
 /*   300 */  1563, 1246, 1103,  601,  600,  599, 1107,  598, 1109, 1110,
 /*   310 */   597, 1112,  594,  122, 1118,  591, 1120, 1121,  588,  585,
 /*   320 */   372,  368, 1318,  498,  479,  478,   14,  525, 1561,  525,
 /*   330 */   373, 1912, 1254, 1912,  554,   40,   38, 1769,  164, 1248,
 /*   340 */   113,   86, 1272,  337,  159, 1248,  159,  468, 1909,    2,
 /*   350 */  1909,  162, 1246,  120,  119, 1585, 1323, 1585, 1246,  447,
 /*   360 */   543, 1012, 1577, 1011, 1912, 1787,  207, 1472,  249, 1854,
 /*   370 */   548,  657,  547,  577, 1787, 1912,  466,  159, 1739, 1318,
 /*   380 */   576, 1909,  542, 1254,  552, 1325, 1326,  612,  159, 1254,
 /*   390 */  1471, 1013, 1909,  103,  554,  162,  102,  101,  100,   99,
 /*   400 */    98,   97,   96,   95,   94, 1800,    8, 1757, 1739,   89,
 /*   410 */  1770,  579, 1772, 1773,  575, 1065,  570,  538, 1753, 1846,
 /*   420 */   541,  559,  657,  304, 1842,   73,  303,  612,  657,  515,
 /*   430 */  1249, 1739, 1247,   34,   33, 1912,  496,   41,   39,   37,
 /*   440 */    36,   35, 1325, 1326, 1749, 1755, 1067,   43,  159,  494,
 /*   450 */  1470,  492, 1909, 1390, 1274, 1037,  570, 1252, 1253, 1272,
 /*   460 */  1301, 1302, 1304, 1305, 1306, 1307, 1308,  572,  568, 1316,
 /*   470 */  1317, 1319, 1320, 1321, 1322, 1324, 1327,   11,   10,  549,
 /*   480 */  1562, 1249,  525, 1247,  525,  549, 1038, 1249,  153, 1247,
 /*   490 */    79, 1739, 1861,  165, 1726,  383,  544,  539,   34,   33,
 /*   500 */   314, 1624,   41,   39,   37,   36,   35,  122, 1252, 1253,
 /*   510 */  1585, 1578, 1585,  122, 1252, 1253, 1858, 1301, 1302, 1304,
 /*   520 */  1305, 1306, 1307, 1308,  572,  568, 1316, 1317, 1319, 1320,
 /*   530 */  1321, 1322, 1324, 1327,   40,   38, 1328,  525,   37,   36,
 /*   540 */    35,  358,  337, 1769, 1248,  525,  162,  120,  384,  315,
 /*   550 */   305,  313,  312,  120,  470, 1323,  388, 1246,  472,  324,
 /*   560 */  1359,  551,  155, 1854, 1855, 1585, 1859,  140,  157, 1854,
 /*   570 */  1855, 1787, 1859, 1585, 1286,  610, 1587, 1271, 1318,  553,
 /*   580 */   471, 1443, 1345, 1333, 1739,  251,  576,  162, 1254, 1272,
 /*   590 */    85,   40,   38, 1515,  131,  130,  607,  606,  605,  337,
 /*   600 */    82, 1248,   34,   33, 1861,    9,   41,   39,   37,   36,
 /*   610 */    35, 1800, 1323,  566, 1246,   90, 1770,  579, 1772, 1773,
 /*   620 */   575,  525,  570,  429,  170, 1846,  433,  657, 1857,  330,
 /*   630 */  1842,  154,  113,  525, 1303, 1318, 1346,   23, 1680,  473,
 /*   640 */   298, 1325, 1326,  158,  403, 1254,  525, 1675, 1469, 1585,
 /*   650 */    69, 1872, 1254,   68,  525,  482,  481,  404,  172, 1351,
 /*   660 */   480, 1585,    9,  118,  477,  446, 1275,  476,  475,  474,
 /*   670 */  1442,   34,   33,  340, 1585,   41,   39,   37,   36,   35,
 /*   680 */  1637,  140, 1585,  525,  657,  604, 1249,  341, 1247, 1739,
 /*   690 */  1587,  615, 1468,  616, 1582, 1557, 1635, 1383, 1325, 1326,
 /*   700 */  1560,   30,  335, 1340, 1341, 1342, 1343, 1344, 1348, 1349,
 /*   710 */  1350, 1585,  437, 1252, 1253,  433, 1301, 1302, 1304, 1305,
 /*   720 */  1306, 1307, 1308,  572,  568, 1316, 1317, 1319, 1320, 1321,
 /*   730 */  1322, 1324, 1327, 1739,   34,   33,  628,  626,   41,   39,
 /*   740 */    37,   36,   35, 1249, 1337, 1247,   27, 1397,  608,  999,
 /*   750 */  1000, 1628,   34,   33,  140,   29,   41,   39,   37,   36,
 /*   760 */    35,   34,   33, 1588, 1303,   41,   39,   37,   36,   35,
 /*   770 */  1252, 1253,   59, 1301, 1302, 1304, 1305, 1306, 1307, 1308,
 /*   780 */   572,  568, 1316, 1317, 1319, 1320, 1321, 1322, 1324, 1327,
 /*   790 */    40,   38,  300, 1272, 1270,  610,  660,  231,  337, 1769,
 /*   800 */  1248,  411, 1574, 1347,  423, 1467, 1466, 1465,  525,  525,
 /*   810 */   266, 1323, 1464, 1246,  131,  130,  607,  606,  605, 1714,
 /*   820 */   506,  396, 1461,  424,  151,  398, 1352, 1787,    7,  650,
 /*   830 */   646,  642,  638,  264, 1318,  577, 1585, 1585,  525, 1460,
 /*   840 */  1739,  525,  576,  343, 1254, 1570, 1739, 1739, 1739,  510,
 /*   850 */    42,  140,  523, 1739,  513,  609,  389,  561, 1628,   87,
 /*   860 */  1587,    2,  229, 1739, 1861, 1683, 1585, 1800,   28, 1585,
 /*   870 */   472,   91, 1770,  579, 1772, 1773,  575,  139,  570, 1459,
 /*   880 */  1739, 1846, 1458,  657, 1457, 1845, 1842,  271, 1856, 1456,
 /*   890 */  1615, 1196,  471, 1866, 1379,  522,  422, 1325, 1326,  417,
 /*   900 */   416,  415,  414,  413,  410,  409,  408,  407,  406,  402,
 /*   910 */   401,  400,  399,  393,  392,  391,  390, 1382,  387,  386,
 /*   920 */  1739, 1455, 1454, 1739, 1637, 1739,  141,  216,   34,   33,
 /*   930 */  1739,  277,   41,   39,   37,   36,   35,   45,    4, 1502,
 /*   940 */  1636, 1572, 1249,  525, 1247,  275,   58, 1568, 1220,   57,
 /*   950 */   209,   34,   33, 1453,  524,   41,   39,   37,   36,   35,
 /*   960 */   210,  483, 1739, 1739, 1769,  176,  426, 1497, 1303, 1252,
 /*   970 */  1253, 1585, 1301, 1302, 1304, 1305, 1306, 1307, 1308,  572,
 /*   980 */   568, 1316, 1317, 1319, 1320, 1321, 1322, 1324, 1327,  485,
 /*   990 */   198,   61, 1787,  196, 1739,  525,  200,  525,  202,  199,
 /*  1000 */   553,  201, 1495,  305, 1286, 1739,  260,  576,  344,  556,
 /*  1010 */   204, 1379,  218,  203,  125,  213,   52,  509,  128,  129,
 /*  1020 */  1759,   50, 1257, 1585,  488, 1585,  235,   11,   10,   88,
 /*  1030 */   571,  603, 1800, 1256,  505, 1345,   90, 1770,  579, 1772,
 /*  1040 */  1773,  575, 1769,  570,   74, 1463, 1846, 1445, 1446,   42,
 /*  1050 */   330, 1842,  154,  222, 1543,  518,  254, 1761,  562,  228,
 /*  1060 */  1096,   42, 1404,   42,   66,   65,  382,  238,  583,  169,
 /*  1070 */  1787,  536, 1873,  465,  499,  376,  243, 1788,  577,  128,
 /*  1080 */   346,  129,  114, 1739, 1491,  576,  128, 1486,  299, 1346,
 /*  1090 */  1353,  366, 1625,  364,  360,  356,  166,  351,  348, 1876,
 /*  1100 */   550,  248, 1309,  253,  270,  256,  258,    3,   53, 1124,
 /*  1110 */  1800,   80, 1351,    5,   90, 1770,  579, 1772, 1773,  575,
 /*  1120 */  1128,  570, 1135, 1133, 1846,  328,  327,  132,  330, 1842,
 /*  1130 */  1925,  162,  652,  350, 1270, 1262,  353,  357,  310, 1880,
 /*  1140 */  1769, 1065, 1212,  311,  267,  405, 1323, 1677, 1255,  171,
 /*  1150 */   412,  193,  419, 1260,   30,  335, 1340, 1341, 1342, 1343,
 /*  1160 */  1344, 1348, 1349, 1350, 1259,  146, 1769,  420, 1787, 1318,
 /*  1170 */   464,  460,  456,  452,  192, 1276,  577,  487,  421, 1254,
 /*  1180 */   425, 1739,  427,  576,  428,  436, 1279,  439,  440,  179,
 /*  1190 */   181, 1278,  497,  442, 1787, 1280, 1277,  441,  184,  444,
 /*  1200 */    72,  186,  577,  190,  445,  188,  206, 1739, 1800,  576,
 /*  1210 */    70,  448,   90, 1770,  579, 1772, 1773,  575,  534,  570,
 /*  1220 */   490,  191, 1846,  467,  484,  469,  330, 1842, 1925,  205,
 /*  1230 */  1575, 1719,  195, 1769, 1800, 1571,  197, 1903,   90, 1770,
 /*  1240 */   579, 1772, 1773,  575,  134,  570,  135, 1573, 1846,   93,
 /*  1250 */  1569,  302,  330, 1842, 1925,   56,  136,  137,   55,  268,
 /*  1260 */   208, 1787,  501, 1865,  500,  189,  182,  504,  187,  577,
 /*  1270 */   211,  507,  443,  511, 1739,  533,  576, 1263,  215, 1258,
 /*  1280 */   519,  514,  320, 1718,  224, 1687, 1769,  126,  516,  127,
 /*  1290 */   554,  180,  322,  226,  269,  520, 1769,   78, 1275,  537,
 /*  1300 */  1586, 1800,  521,    6, 1266,  284, 1770,  579, 1772, 1773,
 /*  1310 */   575,  233,  570,  529, 1787,  568, 1316, 1317, 1319, 1320,
 /*  1320 */  1321, 1322,  577, 1877, 1787,  237,  531, 1739,  530,  576,
 /*  1330 */   532, 1912,  577,  546,  329,  528,  527, 1739,  540,  576,
 /*  1340 */   121, 1379, 1887,  554,  161,  247, 1274,  563, 1909,  560,
 /*  1350 */  1886, 1769,   19,  581, 1800,  331, 1629,  245,  284, 1770,
 /*  1360 */   579, 1772, 1773,  575, 1800,  570,  272, 1769,   91, 1770,
 /*  1370 */   579, 1772, 1773,  575, 1868,  570,  246,  242, 1846, 1787,
 /*  1380 */  1862,  244,  565, 1842, 1912, 1928, 1558,  574, 1827,  263,
 /*  1390 */   653,  656, 1739,  252,  576, 1787,  654,  159,   51,  147,
 /*  1400 */   285, 1909,  148,  577, 1908,  557,  295,  294, 1739,  274,
 /*  1410 */   576,  276, 1733,  255,   63, 1732,  564, 1769,  257, 1800,
 /*  1420 */  1731, 1730,   64,  292, 1770,  579, 1772, 1773,  575,  573,
 /*  1430 */   570,  567, 1818, 1769,  352, 1800, 1727,  355,  354,  144,
 /*  1440 */  1770,  579, 1772, 1773,  575, 1787,  570,  359, 1240, 1241,
 /*  1450 */  1725,  167,  361,  577,  362,  363, 1724,  365, 1739, 1723,
 /*  1460 */   576, 1787,  367, 1722,  369, 1721,  321,  371, 1704,  577,
 /*  1470 */   168,  374,  375, 1215, 1739, 1769,  576, 1214, 1698, 1697,
 /*  1480 */   380,  381, 1696,  555, 1926, 1800, 1695, 1184, 1670,   91,
 /*  1490 */  1770,  579, 1772, 1773,  575, 1769,  570, 1669, 1668, 1846,
 /*  1500 */    67, 1800, 1667, 1787, 1843,  293, 1770,  579, 1772, 1773,
 /*  1510 */   575,  577,  570, 1666, 1665, 1664, 1739, 1663,  576,  394,
 /*  1520 */   395, 1662,  397, 1787, 1661, 1660, 1659, 1658,  526, 1657,
 /*  1530 */  1656,  577,  124, 1647, 1646, 1645, 1739, 1655,  576, 1654,
 /*  1540 */  1653, 1652, 1651, 1800, 1650, 1649, 1648,  288, 1770,  579,
 /*  1550 */  1772, 1773,  575, 1769,  570, 1644, 1643, 1642, 1186, 1641,
 /*  1560 */  1640, 1639, 1638, 1800, 1516, 1769,  175,  293, 1770,  579,
 /*  1570 */  1772, 1773,  575, 1514,  570, 1769, 1482, 1002, 1481, 1001,
 /*  1580 */   177, 1787,  115, 1712, 1706,  545, 1694, 1693,  178,  577,
 /*  1590 */   152,  116,  185, 1787, 1739,  432,  576,  434,  334, 1679,
 /*  1600 */  1564,  577, 1513, 1787, 1511,  183, 1739,  449,  576,  451,
 /*  1610 */  1509,  574,  453,  455,  450, 1031, 1739, 1507,  576,  459,
 /*  1620 */   457, 1800,  454, 1505, 1494,  144, 1770,  579, 1772, 1773,
 /*  1630 */   575,  461,  570, 1800, 1493, 1769,  458,  293, 1770,  579,
 /*  1640 */  1772, 1773,  575, 1800,  570,  462,  463,  292, 1770,  579,
 /*  1650 */  1772, 1773,  575, 1478,  570, 1566, 1819, 1139, 1769,  194,
 /*  1660 */    49, 1138, 1565, 1787, 1064, 1063, 1062, 1061,  336,  625,
 /*  1670 */  1927,  577, 1058, 1057, 1503, 1056, 1739, 1498,  576,  627,
 /*  1680 */   316,  317,  486, 1496,  489,  318, 1787, 1477, 1476,  491,
 /*  1690 */  1475,  338,  493,  495,  577,   92, 1711, 1705,  138, 1739,
 /*  1700 */  1769,  576, 1222, 1800,  502, 1692,  212,  293, 1770,  579,
 /*  1710 */  1772, 1773,  575, 1690,  570, 1691, 1689, 1769,   15, 1686,
 /*  1720 */  1678,   82,   54, 1688,  225,  217, 1800,  223, 1787, 1232,
 /*  1730 */   293, 1770,  579, 1772, 1773,  575,  577,  570,  230,  503,
 /*  1740 */  1419, 1739,  319,  576,   76, 1787,  508,   42,   77,   16,
 /*  1750 */   517,   24,  227,  577,  234,  232,  241, 1401, 1739,  236,
 /*  1760 */   576, 1264, 1403,  145,   48, 1396, 1431, 1769, 1800,  239,
 /*  1770 */   240, 1759,  278, 1770,  579, 1772, 1773,  575,   25,  570,
 /*  1780 */    26,   81,  250, 1376, 1375, 1800,   47, 1758, 1769,  279,
 /*  1790 */  1770,  579, 1772, 1773,  575, 1787,  570,  149, 1436,   18,
 /*  1800 */  1430, 1425,   46,  577,  332, 1435,   17, 1434, 1739, 1769,
 /*  1810 */   576,  333,   10, 1803,   20,  569, 1787,   13, 1338, 1313,
 /*  1820 */   150,  163, 1311,   32,  577, 1294, 1310,  580,   12, 1739,
 /*  1830 */    21,  576,   22,  582, 1125, 1800,  578, 1787,  584,  280,
 /*  1840 */  1770,  579, 1772, 1773,  575,  577,  570,  339, 1122,  586,
 /*  1850 */  1739, 1769,  576,  589,  592,  595, 1800, 1119, 1102, 1117,
 /*  1860 */   287, 1770,  579, 1772, 1773,  575,  587,  570, 1769,  590,
 /*  1870 */  1116, 1113,  593, 1115, 1111,  596,  602, 1800,   83, 1787,
 /*  1880 */    84,  289, 1770,  579, 1772, 1773,  575,  577,  570, 1114,
 /*  1890 */  1134,   60, 1739,  261,  576, 1130, 1787, 1071, 1029,  611,
 /*  1900 */  1053,  262,  614, 1051,  577, 1050, 1049, 1048, 1046, 1739,
 /*  1910 */  1047,  576, 1045, 1044, 1068, 1066, 1041, 1040, 1039, 1800,
 /*  1920 */  1769,  636, 1036,  281, 1770,  579, 1772, 1773,  575, 1035,
 /*  1930 */   570, 1034, 1510,  635,  637, 1508, 1800,  639,  640,  641,
 /*  1940 */   290, 1770,  579, 1772, 1773,  575, 1506,  570, 1787,  643,
 /*  1950 */   644,  645, 1504,  647,  648,  649,  577, 1492,  651,  992,
 /*  1960 */  1474, 1739,  265,  576,  655, 1449, 1250,  273,  658,  659,
 /*  1970 */  1449, 1449, 1449, 1449, 1769, 1449, 1449, 1449, 1449, 1449,
 /*  1980 */  1449, 1449, 1449, 1449, 1449, 1449, 1449, 1449, 1800, 1449,
 /*  1990 */  1769, 1449,  282, 1770,  579, 1772, 1773,  575, 1449,  570,
 /*  2000 */  1769, 1449, 1787, 1449, 1449, 1449, 1449, 1449, 1449, 1449,
 /*  2010 */   577, 1449, 1449, 1449, 1449, 1739, 1449,  576, 1787, 1449,
 /*  2020 */  1449, 1449, 1449, 1449, 1449, 1449,  577, 1449, 1787, 1449,
 /*  2030 */  1449, 1739, 1449,  576, 1449, 1449,  577, 1449, 1449, 1449,
 /*  2040 */  1449, 1739, 1800,  576, 1449, 1449,  291, 1770,  579, 1772,
 /*  2050 */  1773,  575, 1769,  570, 1449, 1449, 1449, 1449, 1800, 1449,
 /*  2060 */  1449, 1449,  283, 1770,  579, 1772, 1773,  575, 1800,  570,
 /*  2070 */  1449, 1449,  296, 1770,  579, 1772, 1773,  575, 1449,  570,
 /*  2080 */  1787, 1449, 1449, 1449, 1449, 1449, 1449, 1449,  577, 1449,
 /*  2090 */  1449, 1449, 1449, 1739, 1769,  576, 1449, 1449, 1449, 1449,
 /*  2100 */  1449, 1449, 1449, 1449, 1449, 1449, 1449, 1449, 1769, 1449,
 /*  2110 */  1449, 1449, 1449, 1449, 1449, 1449, 1449, 1449, 1769, 1449,
 /*  2120 */  1800, 1449, 1787, 1449,  297, 1770,  579, 1772, 1773,  575,
 /*  2130 */   577,  570, 1449, 1449, 1449, 1739, 1787,  576, 1449, 1449,
 /*  2140 */  1449, 1449, 1449, 1449,  577, 1449, 1787, 1449, 1449, 1739,
 /*  2150 */  1449,  576, 1449, 1449,  577, 1449, 1449, 1449, 1449, 1739,
 /*  2160 */  1449,  576, 1800, 1449, 1449, 1449, 1781, 1770,  579, 1772,
 /*  2170 */  1773,  575, 1449,  570, 1449, 1449, 1800, 1769, 1449, 1449,
 /*  2180 */  1780, 1770,  579, 1772, 1773,  575, 1800,  570, 1449, 1449,
 /*  2190 */  1779, 1770,  579, 1772, 1773,  575, 1449,  570, 1769, 1449,
 /*  2200 */  1449, 1449, 1449, 1449, 1449, 1787, 1449, 1449, 1449, 1449,
 /*  2210 */  1449, 1449, 1449,  577, 1449, 1449, 1449, 1449, 1739, 1449,
 /*  2220 */   576, 1449, 1449, 1449, 1449, 1449, 1787, 1449, 1449, 1449,
 /*  2230 */  1449, 1449, 1449, 1449,  577, 1449, 1449, 1449, 1449, 1739,
 /*  2240 */  1449,  576, 1449, 1449, 1449, 1800, 1449, 1449, 1449,  308,
 /*  2250 */  1770,  579, 1772, 1773,  575, 1449,  570, 1769, 1449, 1449,
 /*  2260 */  1449, 1449, 1449, 1449, 1449, 1449, 1800, 1769, 1449, 1449,
 /*  2270 */   307, 1770,  579, 1772, 1773,  575, 1449,  570, 1449, 1449,
 /*  2280 */  1449, 1449, 1449, 1769, 1449, 1787, 1449, 1449, 1449, 1449,
 /*  2290 */  1449, 1449, 1449,  577, 1449, 1787, 1449, 1449, 1739, 1449,
 /*  2300 */   576, 1449, 1449,  577, 1449, 1449, 1449, 1449, 1739, 1449,
 /*  2310 */   576, 1787, 1449, 1449, 1449, 1449, 1449, 1449, 1449,  577,
 /*  2320 */  1449, 1449, 1449, 1449, 1739, 1800,  576, 1449, 1449,  309,
 /*  2330 */  1770,  579, 1772, 1773,  575, 1800,  570, 1449, 1449,  306,
 /*  2340 */  1770,  579, 1772, 1773,  575, 1449,  570, 1449, 1449, 1449,
 /*  2350 */  1449, 1800, 1449, 1449, 1449,  286, 1770,  579, 1772, 1773,
 /*  2360 */   575, 1449,  570,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   260,  264,  262,  263,  260,    0,  262,  263,  286,  264,
 /*    10 */     8,    9,   12,   13,   12,   13,   14,   15,   16,  297,
 /*    20 */    20,  268,   22,    0,  313,  286,   14,  295,   20,  292,
 /*    30 */   298,  299,   20,   33,  281,   35,  297,  292,   12,   13,
 /*    40 */    14,   15,   16,  290,   21,  323,  324,   24,   25,   26,
 /*    50 */    27,   28,   29,   30,   31,   32,   56,  335,  313,  354,
 /*    60 */    60,  253,  323,  324,  325,  354,   66,  256,    4,  332,
 /*    70 */   264,   20,  367,   22,  335,   59,  371,  332,  367,   12,
 /*    80 */    13,   14,  371,   83,  347,  348,  349,   20,  351,   22,
 /*    90 */    20,   83,  347,  348,  349,  284,  351,    4,  299,  354,
 /*   100 */    33,   50,   35,  292,  256,  105,  307,  301,  297,  310,
 /*   110 */   299,  255,  367,  257,   83,  354,  371,   62,   63,  119,
 /*   120 */   120,  313,   67,   56,  313,   70,   71,   60,  367,   74,
 /*   130 */    75,   76,  371,   66,  309,  324,  311,   44,   45,  328,
 /*   140 */   329,  330,  331,  332,  333,  297,  335,   83,   95,  338,
 /*   150 */    83,    8,    9,  342,  343,   12,   13,   14,   15,   16,
 /*   160 */   114,  115,  354,  354,  164,  354,  166,  114,  115,  116,
 /*   170 */   117,  118,  105,    0,   20,  367,  367,  284,  367,  371,
 /*   180 */   371,  269,  371,   77,  291,  273,  119,  120,    0,  119,
 /*   190 */   120,  191,  192,  300,  194,  195,  196,  197,  198,  199,
 /*   200 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,   83,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   220 */    32,  175,   43,  223,  178,  339,  340,   84,   56,  123,
 /*   230 */   124,  164,  114,  166,  268,   62,   63,   64,   65,  191,
 /*   240 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   250 */    77,   78,   79,   80,  223,   83,  290,   85,  191,  192,
 /*   260 */    20,  194,  195,  196,  197,  198,  199,  200,  201,  202,
 /*   270 */   203,  204,  205,  206,  207,  208,  209,  210,   12,   13,
 /*   280 */   232,  233,  234,  235,  236,  264,   20,  223,   22,   43,
 /*   290 */   313,  163,  313,  165,  176,  177,  298,  299,  159,   33,
 /*   300 */     0,   35,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   310 */   104,  105,  106,  292,  108,  109,  110,  111,  112,  113,
 /*   320 */   181,  182,   56,  313,  270,  271,   60,  264,    0,  264,
 /*   330 */    84,  354,   66,  354,  313,   12,   13,  256,  275,   22,
 /*   340 */   275,  266,   20,   20,  367,   22,  367,  282,  371,   83,
 /*   350 */   371,  223,   35,  332,  279,  292,   33,  292,   35,   59,
 /*   360 */    20,   20,  287,   22,  354,  284,  115,  256,  347,  348,
 /*   370 */   349,  105,  351,  292,  284,  354,   35,  367,  297,   56,
 /*   380 */   299,  371,  292,   66,   20,  119,  120,   59,  367,   66,
 /*   390 */   256,   50,  371,   21,  313,  223,   24,   25,   26,   27,
 /*   400 */    28,   29,   30,   31,   32,  324,   83,  286,  297,  328,
 /*   410 */   329,  330,  331,  332,  333,   35,  335,  149,  297,  338,
 /*   420 */   330,  242,  105,  342,  343,  174,  175,   59,  105,  178,
 /*   430 */   164,  297,  166,    8,    9,  354,   21,   12,   13,   14,
 /*   440 */    15,   16,  119,  120,  323,  324,   66,   83,  367,   34,
 /*   450 */   256,   36,  371,   14,   20,   35,  335,  191,  192,   20,
 /*   460 */   194,  195,  196,  197,  198,  199,  200,  201,  202,  203,
 /*   470 */   204,  205,  206,  207,  208,  209,  210,    1,    2,  264,
 /*   480 */     0,  164,  264,  166,  264,  264,   66,  164,  283,  166,
 /*   490 */   266,  297,  326,  275,    0,  275,  228,  229,    8,    9,
 /*   500 */    37,  296,   12,   13,   14,   15,   16,  292,  191,  192,
 /*   510 */   292,  287,  292,  292,  191,  192,  350,  194,  195,  196,
 /*   520 */   197,  198,  199,  200,  201,  202,  203,  204,  205,  206,
 /*   530 */   207,  208,  209,  210,   12,   13,   14,  264,   14,   15,
 /*   540 */    16,   47,   20,  256,   22,  264,  223,  332,  275,   86,
 /*   550 */    60,   88,   89,  332,   91,   33,  275,   35,   95,  276,
 /*   560 */    84,  346,  347,  348,  349,  292,  351,  284,  347,  348,
 /*   570 */   349,  284,  351,  292,   84,   95,  293,   20,   56,  292,
 /*   580 */   117,  156,   92,   14,  297,  151,  299,  223,   66,   20,
 /*   590 */    83,   12,   13,    0,  114,  115,  116,  117,  118,   20,
 /*   600 */    93,   22,    8,    9,  326,   83,   12,   13,   14,   15,
 /*   610 */    16,  324,   33,   60,   35,  328,  329,  330,  331,  332,
 /*   620 */   333,  264,  335,  261,   56,  338,  264,  105,  350,  342,
 /*   630 */   343,  344,  275,  264,  195,   56,  146,   43,  309,  282,
 /*   640 */   311,  119,  120,  356,  275,   66,  264,  292,  256,  292,
 /*   650 */    82,  364,   66,   85,  264,   62,   63,  275,  303,  169,
 /*   660 */    67,  292,   83,   70,   71,  275,   20,   74,   75,   76,
 /*   670 */   245,    8,    9,  276,  292,   12,   13,   14,   15,   16,
 /*   680 */   284,  284,  292,  264,  105,   94,  164,  291,  166,  297,
 /*   690 */   293,   66,  256,  272,  275,  274,  300,    4,  119,  120,
 /*   700 */     0,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   710 */   220,  292,  261,  191,  192,  264,  194,  195,  196,  197,
 /*   720 */   198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
 /*   730 */   208,  209,  210,  297,    8,    9,  270,  271,   12,   13,
 /*   740 */    14,   15,   16,  164,  191,  166,    2,   84,  294,   44,
 /*   750 */    45,  297,    8,    9,  284,    2,   12,   13,   14,   15,
 /*   760 */    16,    8,    9,  293,  195,   12,   13,   14,   15,   16,
 /*   770 */   191,  192,    3,  194,  195,  196,  197,  198,  199,  200,
 /*   780 */   201,  202,  203,  204,  205,  206,  207,  208,  209,  210,
 /*   790 */    12,   13,   18,   20,   20,   95,   19,  151,   20,  256,
 /*   800 */    22,   27,  285,  146,   30,  256,  256,  256,  264,  264,
 /*   810 */    33,   33,  256,   35,  114,  115,  116,  117,  118,  275,
 /*   820 */   275,   47,  256,   49,   47,   51,  169,  284,   39,   52,
 /*   830 */    53,   54,   55,   56,   56,  292,  292,  292,  264,  256,
 /*   840 */   297,  264,  299,  276,   66,  285,  297,  297,  297,  275,
 /*   850 */    43,  284,  275,  297,  299,  294,   82,   43,  297,   82,
 /*   860 */   293,   83,   85,  297,  326,  310,  292,  324,  211,  292,
 /*   870 */    95,  328,  329,  330,  331,  332,  333,  151,  335,  256,
 /*   880 */   297,  338,  256,  105,  256,  342,  343,  277,  350,  256,
 /*   890 */   280,   84,  117,  221,  222,  118,  122,  119,  120,  125,
 /*   900 */   126,  127,  128,  129,  130,  131,  132,  133,  134,  135,
 /*   910 */   136,  137,  138,  139,  140,  141,  142,  224,  144,  145,
 /*   920 */   297,  256,  256,  297,  284,  297,   18,  150,    8,    9,
 /*   930 */   297,   23,   12,   13,   14,   15,   16,   42,   43,    0,
 /*   940 */   300,  285,  164,  264,  166,   37,   38,  285,  171,   41,
 /*   950 */   173,    8,    9,  256,  275,   12,   13,   14,   15,   16,
 /*   960 */   285,   22,  297,  297,  256,   57,   58,    0,  195,  191,
 /*   970 */   192,  292,  194,  195,  196,  197,  198,  199,  200,  201,
 /*   980 */   202,  203,  204,  205,  206,  207,  208,  209,  210,   22,
 /*   990 */    87,   83,  284,   90,  297,  264,   87,  264,   87,   90,
 /*  1000 */   292,   90,    0,   60,   84,  297,  275,  299,  275,  240,
 /*  1010 */    87,  222,   43,   90,   43,   56,  151,  152,   43,   43,
 /*  1020 */    46,   43,   35,  292,   22,  292,   43,    1,    2,  121,
 /*  1030 */   285,  285,  324,   35,  317,   92,  328,  329,  330,  331,
 /*  1040 */   332,  333,  256,  335,   85,  257,  338,  119,  120,   43,
 /*  1050 */   342,  343,  344,   84,  273,   84,  374,   83,  244,   84,
 /*  1060 */    84,   43,   84,   43,  156,  157,  158,   84,   43,  161,
 /*  1070 */   284,  365,  364,  265,  320,  167,  361,  284,  292,   43,
 /*  1080 */   265,   43,   43,  297,    0,  299,   43,  263,  180,  146,
 /*  1090 */    84,  183,  296,  185,  186,  187,  188,  189,  190,  327,
 /*  1100 */   352,  345,   84,  368,   84,  368,  368,  355,  288,   84,
 /*  1110 */   324,   83,  169,  225,  328,  329,  330,  331,  332,  333,
 /*  1120 */    84,  335,   84,   84,  338,   12,   13,   84,  342,  343,
 /*  1130 */   344,  223,   48,  322,   20,   22,  264,   47,  321,  353,
 /*  1140 */   256,   35,  162,  270,  315,  264,   33,  264,   35,   42,
 /*  1150 */   304,   33,  302,  166,  211,  212,  213,  214,  215,  216,
 /*  1160 */   217,  218,  219,  220,  166,   47,  256,  146,  284,   56,
 /*  1170 */    52,   53,   54,   55,   56,   20,  292,    4,  302,   66,
 /*  1180 */   264,  297,  264,  299,  258,  258,   20,  319,  299,  268,
 /*  1190 */   268,   20,   19,  314,  284,   20,   20,  312,  268,  312,
 /*  1200 */    82,  268,  292,   85,  305,  268,   33,  297,  324,  299,
 /*  1210 */   268,  264,  328,  329,  330,  331,  332,  333,  105,  335,
 /*  1220 */    47,  268,  338,  258,   51,  284,  342,  343,  344,   56,
 /*  1230 */   284,  297,  284,  256,  324,  284,  284,  353,  328,  329,
 /*  1240 */   330,  331,  332,  333,  284,  335,  284,  284,  338,  264,
 /*  1250 */   284,  258,  342,  343,  344,   82,  284,  284,   85,  319,
 /*  1260 */   266,  284,  318,  353,  172,  147,  148,  299,  150,  292,
 /*  1270 */   266,  264,  154,  264,  297,  230,  299,  164,  266,  166,
 /*  1280 */   148,  297,  312,  297,  292,  297,  256,  308,  297,  308,
 /*  1290 */   313,  173,  297,  266,  280,  306,  256,  266,   20,  231,
 /*  1300 */   292,  324,  305,  237,  191,  328,  329,  330,  331,  332,
 /*  1310 */   333,  308,  335,  297,  284,  202,  203,  204,  205,  206,
 /*  1320 */   207,  208,  292,  327,  284,  308,  297,  297,  239,  299,
 /*  1330 */   297,  354,  292,  155,  297,  238,  226,  297,  297,  299,
 /*  1340 */   292,  222,  360,  313,  367,  322,   20,  243,  371,  241,
 /*  1350 */   360,  256,   83,  288,  324,  246,  297,  358,  328,  329,
 /*  1360 */   330,  331,  332,  333,  324,  335,  264,  256,  328,  329,
 /*  1370 */   330,  331,  332,  333,  363,  335,  357,  362,  338,  284,
 /*  1380 */   326,  359,  342,  343,  354,  375,  274,  292,  341,  266,
 /*  1390 */    36,  258,  297,  369,  299,  284,  259,  367,  316,  311,
 /*  1400 */   278,  371,  360,  292,  370,  370,  278,  278,  297,  267,
 /*  1410 */   299,  254,    0,  369,  174,    0,  370,  256,  369,  324,
 /*  1420 */     0,    0,   42,  328,  329,  330,  331,  332,  333,  334,
 /*  1430 */   335,  336,  337,  256,   74,  324,    0,  184,   35,  328,
 /*  1440 */   329,  330,  331,  332,  333,  284,  335,  184,   35,   35,
 /*  1450 */     0,   35,   35,  292,   35,  184,    0,  184,  297,    0,
 /*  1460 */   299,  284,   35,    0,   22,    0,  289,   35,    0,  292,
 /*  1470 */    83,  169,  168,  166,  297,  256,  299,  164,    0,    0,
 /*  1480 */   160,  159,    0,  372,  373,  324,    0,   46,    0,  328,
 /*  1490 */   329,  330,  331,  332,  333,  256,  335,    0,    0,  338,
 /*  1500 */   143,  324,    0,  284,  343,  328,  329,  330,  331,  332,
 /*  1510 */   333,  292,  335,    0,    0,    0,  297,    0,  299,  138,
 /*  1520 */    35,    0,  138,  284,    0,    0,    0,    0,  289,    0,
 /*  1530 */     0,  292,   42,    0,    0,    0,  297,    0,  299,    0,
 /*  1540 */     0,    0,    0,  324,    0,    0,    0,  328,  329,  330,
 /*  1550 */   331,  332,  333,  256,  335,    0,    0,    0,   22,    0,
 /*  1560 */     0,    0,    0,  324,    0,  256,   56,  328,  329,  330,
 /*  1570 */   331,  332,  333,    0,  335,  256,    0,   14,    0,   14,
 /*  1580 */    42,  284,   39,    0,    0,  366,    0,    0,   40,  292,
 /*  1590 */    43,   39,  155,  284,  297,   46,  299,   46,  289,    0,
 /*  1600 */     0,  292,    0,  284,    0,   39,  297,   35,  299,   39,
 /*  1610 */     0,  292,   35,   39,   47,   61,  297,    0,  299,   39,
 /*  1620 */    35,  324,   47,    0,    0,  328,  329,  330,  331,  332,
 /*  1630 */   333,   35,  335,  324,    0,  256,   47,  328,  329,  330,
 /*  1640 */   331,  332,  333,  324,  335,   47,   39,  328,  329,  330,
 /*  1650 */   331,  332,  333,    0,  335,    0,  337,   35,  256,   90,
 /*  1660 */    92,   22,    0,  284,   35,   35,   35,   35,  289,   43,
 /*  1670 */   373,  292,   35,   35,    0,   35,  297,    0,  299,   43,
 /*  1680 */    22,   22,   49,    0,   35,   22,  284,    0,    0,   35,
 /*  1690 */     0,  289,   35,   22,  292,   20,    0,    0,  170,  297,
 /*  1700 */   256,  299,   35,  324,   22,    0,  148,  328,  329,  330,
 /*  1710 */   331,  332,  333,    0,  335,    0,    0,  256,   83,    0,
 /*  1720 */     0,   93,  151,    0,   39,   84,  324,   83,  284,  179,
 /*  1730 */   328,  329,  330,  331,  332,  333,  292,  335,   46,  151,
 /*  1740 */    84,  297,  151,  299,   83,  284,  153,   43,   83,  227,
 /*  1750 */   149,   83,  147,  292,   84,   83,   46,   84,  297,   83,
 /*  1760 */   299,   22,   84,   83,   43,   84,   35,  256,  324,   83,
 /*  1770 */    43,   46,  328,  329,  330,  331,  332,  333,   83,  335,
 /*  1780 */    43,   83,   46,   84,   84,  324,   43,   46,  256,  328,
 /*  1790 */   329,  330,  331,  332,  333,  284,  335,   46,   84,   43,
 /*  1800 */    35,   84,  221,  292,   35,   35,  227,   35,  297,  256,
 /*  1810 */   299,   35,    2,   83,   43,   83,  284,  227,  191,   84,
 /*  1820 */    46,   46,   84,   83,  292,   22,   84,   94,   83,  297,
 /*  1830 */    83,  299,   83,   35,   84,  324,  193,  284,   83,  328,
 /*  1840 */   329,  330,  331,  332,  333,  292,  335,   35,   84,   35,
 /*  1850 */   297,  256,  299,   35,   35,   35,  324,   84,   22,  107,
 /*  1860 */   328,  329,  330,  331,  332,  333,   83,  335,  256,   83,
 /*  1870 */   107,   84,   83,  107,   84,   83,   95,  324,   83,  284,
 /*  1880 */    83,  328,  329,  330,  331,  332,  333,  292,  335,  107,
 /*  1890 */    35,   83,  297,   43,  299,   22,  284,   66,   61,   60,
 /*  1900 */    35,   43,   81,   35,  292,   35,   35,   35,   22,  297,
 /*  1910 */    35,  299,   35,   35,   66,   35,   35,   35,   35,  324,
 /*  1920 */   256,   47,   35,  328,  329,  330,  331,  332,  333,   35,
 /*  1930 */   335,   35,    0,   35,   39,    0,  324,   35,   47,   39,
 /*  1940 */   328,  329,  330,  331,  332,  333,    0,  335,  284,   35,
 /*  1950 */    47,   39,    0,   35,   47,   39,  292,    0,   35,   35,
 /*  1960 */     0,  297,   22,  299,   21,  376,   22,   22,   21,   20,
 /*  1970 */   376,  376,  376,  376,  256,  376,  376,  376,  376,  376,
 /*  1980 */   376,  376,  376,  376,  376,  376,  376,  376,  324,  376,
 /*  1990 */   256,  376,  328,  329,  330,  331,  332,  333,  376,  335,
 /*  2000 */   256,  376,  284,  376,  376,  376,  376,  376,  376,  376,
 /*  2010 */   292,  376,  376,  376,  376,  297,  376,  299,  284,  376,
 /*  2020 */   376,  376,  376,  376,  376,  376,  292,  376,  284,  376,
 /*  2030 */   376,  297,  376,  299,  376,  376,  292,  376,  376,  376,
 /*  2040 */   376,  297,  324,  299,  376,  376,  328,  329,  330,  331,
 /*  2050 */   332,  333,  256,  335,  376,  376,  376,  376,  324,  376,
 /*  2060 */   376,  376,  328,  329,  330,  331,  332,  333,  324,  335,
 /*  2070 */   376,  376,  328,  329,  330,  331,  332,  333,  376,  335,
 /*  2080 */   284,  376,  376,  376,  376,  376,  376,  376,  292,  376,
 /*  2090 */   376,  376,  376,  297,  256,  299,  376,  376,  376,  376,
 /*  2100 */   376,  376,  376,  376,  376,  376,  376,  376,  256,  376,
 /*  2110 */   376,  376,  376,  376,  376,  376,  376,  376,  256,  376,
 /*  2120 */   324,  376,  284,  376,  328,  329,  330,  331,  332,  333,
 /*  2130 */   292,  335,  376,  376,  376,  297,  284,  299,  376,  376,
 /*  2140 */   376,  376,  376,  376,  292,  376,  284,  376,  376,  297,
 /*  2150 */   376,  299,  376,  376,  292,  376,  376,  376,  376,  297,
 /*  2160 */   376,  299,  324,  376,  376,  376,  328,  329,  330,  331,
 /*  2170 */   332,  333,  376,  335,  376,  376,  324,  256,  376,  376,
 /*  2180 */   328,  329,  330,  331,  332,  333,  324,  335,  376,  376,
 /*  2190 */   328,  329,  330,  331,  332,  333,  376,  335,  256,  376,
 /*  2200 */   376,  376,  376,  376,  376,  284,  376,  376,  376,  376,
 /*  2210 */   376,  376,  376,  292,  376,  376,  376,  376,  297,  376,
 /*  2220 */   299,  376,  376,  376,  376,  376,  284,  376,  376,  376,
 /*  2230 */   376,  376,  376,  376,  292,  376,  376,  376,  376,  297,
 /*  2240 */   376,  299,  376,  376,  376,  324,  376,  376,  376,  328,
 /*  2250 */   329,  330,  331,  332,  333,  376,  335,  256,  376,  376,
 /*  2260 */   376,  376,  376,  376,  376,  376,  324,  256,  376,  376,
 /*  2270 */   328,  329,  330,  331,  332,  333,  376,  335,  376,  376,
 /*  2280 */   376,  376,  376,  256,  376,  284,  376,  376,  376,  376,
 /*  2290 */   376,  376,  376,  292,  376,  284,  376,  376,  297,  376,
 /*  2300 */   299,  376,  376,  292,  376,  376,  376,  376,  297,  376,
 /*  2310 */   299,  284,  376,  376,  376,  376,  376,  376,  376,  292,
 /*  2320 */   376,  376,  376,  376,  297,  324,  299,  376,  376,  328,
 /*  2330 */   329,  330,  331,  332,  333,  324,  335,  376,  376,  328,
 /*  2340 */   329,  330,  331,  332,  333,  376,  335,  376,  376,  376,
 /*  2350 */   376,  324,  376,  376,  376,  328,  329,  330,  331,  332,
 /*  2360 */   333,  376,  335,
};
#define YY_SHIFT_COUNT    (660)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1960)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   908,    0,    0,   67,   67,  266,  266,  266,  323,  323,
 /*    10 */   266,  266,  522,  579,  778,  579,  579,  579,  579,  579,
 /*    20 */   579,  579,  579,  579,  579,  579,  579,  579,  579,  579,
 /*    30 */   579,  579,  579,  579,  579,  579,  579,  579,  579,  579,
 /*    40 */   579,  579,  579,  364,  364,    8,    8,    8, 1113, 1113,
 /*    50 */  1113,  128,  172,   31,   31,  154,  154,   93,   93,   64,
 /*    60 */    70,   31,   31,  154,  154,  154,  154,  154,  154,  154,
 /*    70 */   154,  154,   16,  154,  154,  154,  240,  322,  154,  154,
 /*    80 */   322,  340,  154,  322,  322,  322,  154,  368,  774,  490,
 /*    90 */   943,  943,  372,   55,  317,  317,  317,  317,  317,  317,
 /*   100 */   317,  317,  317,  317,  317,  317,  317,  317,  317,  317,
 /*   110 */   317,  317,  317,  463,   70,   12,   12,  300,  380,  328,
 /*   120 */   434,  434,  434,  380,  557,  240,    5,    5,  322,  322,
 /*   130 */   586,  586,  591,  625,  206,  206,  206,  206,  206,  206,
 /*   140 */   206,  777,   23,  593,  425,   48,  341,  251,  268,  439,
 /*   150 */   569,   51,  705,  775,  646,  672,  789,  672,  895,  769,
 /*   160 */   769,  769,  693,  773, 1028,  888, 1114, 1090, 1106,  980,
 /*   170 */  1114, 1114, 1107, 1021, 1021, 1114, 1114, 1155, 1155, 1166,
 /*   180 */    16,  240,   16, 1171, 1175,   16, 1171,   16, 1176,   16,
 /*   190 */    16, 1114,   16, 1155,  322,  322,  322,  322,  322,  322,
 /*   200 */   322,  322,  322,  322,  322, 1114, 1155,  586, 1166,  368,
 /*   210 */  1092,  240,  368, 1114, 1114, 1171,  368, 1045,  586,  586,
 /*   220 */   586,  586, 1045,  586, 1132,  557, 1176,  368,  591,  368,
 /*   230 */   557, 1278,  586, 1068, 1045,  586,  586, 1068, 1045,  586,
 /*   240 */   586,  322, 1066, 1178, 1068, 1089, 1097, 1110,  888, 1119,
 /*   250 */   557, 1326, 1104, 1108, 1109, 1104, 1108, 1104, 1108, 1269,
 /*   260 */  1028,  586,  625, 1114,  368, 1354, 1155, 2363, 2363, 2363,
 /*   270 */  2363, 2363, 2363, 2363,  173, 1118,  188, 1173,  143,  594,
 /*   280 */   663,  744,  753,  726,  920,  480,    2,    2,    2,    2,
 /*   290 */     2,    2,    2,    2,  700,   53,   26,   26,   46,  139,
 /*   300 */   568,  106,  415,  118,  476,  657,  524,  524,  524,  524,
 /*   310 */   494,  246,  903,  909,  911,  923,  939,  967, 1002,  959,
 /*   320 */   865,  807,  969,  971,  975,  976,  978,  987,  998,  983,
 /*   330 */  1026,  928,  179,  814, 1006,  553, 1018,  974, 1020, 1025,
 /*   340 */  1036, 1038, 1039, 1043,  507,  420, 1084, 1412, 1240, 1415,
 /*   350 */  1420, 1380, 1421, 1360, 1436, 1403, 1253, 1413, 1414, 1416,
 /*   360 */  1263, 1450, 1417, 1419, 1271, 1456, 1273, 1459, 1427, 1463,
 /*   370 */  1442, 1465, 1432, 1468, 1387, 1302, 1304, 1307, 1313, 1478,
 /*   380 */  1479, 1320, 1322, 1482, 1486, 1441, 1488, 1497, 1498, 1357,
 /*   390 */  1502, 1513, 1514, 1515, 1517, 1381, 1485, 1521, 1384, 1524,
 /*   400 */  1525, 1526, 1527, 1529, 1530, 1537, 1539, 1540, 1541, 1542,
 /*   410 */  1544, 1545, 1546, 1490, 1533, 1534, 1535, 1555, 1556, 1557,
 /*   420 */  1536, 1559, 1560, 1561, 1562, 1564, 1510, 1573, 1576, 1538,
 /*   430 */  1543, 1547, 1563, 1549, 1565, 1551, 1578, 1548, 1552, 1583,
 /*   440 */  1584, 1586, 1566, 1437, 1587, 1599, 1600, 1554, 1602, 1604,
 /*   450 */  1572, 1567, 1570, 1610, 1577, 1575, 1574, 1617, 1585, 1589,
 /*   460 */  1580, 1623, 1596, 1598, 1607, 1624, 1634, 1653, 1655, 1568,
 /*   470 */  1569, 1622, 1639, 1662, 1629, 1630, 1631, 1632, 1626, 1636,
 /*   480 */  1637, 1638, 1640, 1674, 1658, 1677, 1659, 1633, 1683, 1663,
 /*   490 */  1649, 1687, 1654, 1688, 1657, 1690, 1671, 1675, 1696, 1571,
 /*   500 */  1667, 1697, 1528, 1682, 1588, 1558, 1705, 1713, 1591, 1593,
 /*   510 */  1715, 1716, 1723, 1635, 1641, 1550, 1719, 1644, 1601, 1661,
 /*   520 */  1720, 1685, 1605, 1665, 1628, 1692, 1704, 1522, 1668, 1656,
 /*   530 */  1672, 1670, 1673, 1676, 1739, 1721, 1678, 1680, 1686, 1695,
 /*   540 */  1681, 1727, 1710, 1725, 1698, 1737, 1579, 1699, 1700, 1736,
 /*   550 */  1581, 1743, 1741, 1751, 1714, 1756, 1590, 1717, 1731, 1765,
 /*   560 */  1769, 1770, 1772, 1776, 1717, 1810, 1627, 1771, 1730, 1735,
 /*   570 */  1732, 1738, 1740, 1742, 1774, 1745, 1747, 1775, 1803, 1643,
 /*   580 */  1749, 1733, 1750, 1798, 1812, 1755, 1764, 1814, 1783, 1773,
 /*   590 */  1818, 1786, 1787, 1819, 1789, 1790, 1820, 1792, 1752, 1763,
 /*   600 */  1766, 1782, 1836, 1781, 1795, 1797, 1855, 1808, 1850, 1850,
 /*   610 */  1873, 1837, 1839, 1865, 1831, 1821, 1858, 1868, 1870, 1871,
 /*   620 */  1872, 1875, 1886, 1877, 1878, 1848, 1626, 1880, 1636, 1881,
 /*   630 */  1882, 1883, 1887, 1894, 1896, 1932, 1898, 1874, 1895, 1935,
 /*   640 */  1902, 1891, 1900, 1946, 1914, 1903, 1912, 1952, 1918, 1907,
 /*   650 */  1916, 1957, 1923, 1924, 1960, 1940, 1943, 1944, 1945, 1947,
 /*   660 */  1949,
};
#define YY_REDUCE_COUNT (273)
#define YY_REDUCE_MIN   (-295)
#define YY_REDUCE_MAX   (2027)
static const short yy_reduce_ofst[] = {
 /*     0 */  -192, -189,   81,  287,  708,  786,  884,  910,  977, 1030,
 /*    10 */   543, 1040, 1095, 1111, 1161, 1177, 1239, 1219, 1297, 1309,
 /*    20 */  1319, 1379, 1402, 1444, 1461, 1511, 1532, 1553, 1595, 1612,
 /*    30 */  1664, 1718, 1734, 1744, 1796, 1838, 1852, 1862, 1921, 1942,
 /*    40 */  2001, 2011, 2027, -255,   21,  215, -263,  221, -261, -278,
 /*    50 */   121, -289,  -23,  -21,   10,   65,  357, -260, -256, -295,
 /*    60 */  -268, -239, -191,   63,  218,  220,  273,  281,  369,  382,
 /*    70 */   390,  419, -247,  544,  545,  574, -201,  283,  577,  679,
 /*    80 */  -107,   90,  731,  397,  396,  567,  733,   75, -194, -114,
 /*    90 */  -114, -114, -144,  -88, -152,  111,  134,  194,  392,  436,
 /*   100 */   549,  550,  551,  556,  566,  583,  623,  626,  628,  633,
 /*   110 */   665,  666,  697,  205,   -2,  362,  451,  -34,   54,  224,
 /*   120 */   166,  278,  538,  466,  355,  555, -175,  329,  470,  640,
 /*   130 */   454,  561,  610,  421,  517,  560,  656,  662,  675,  745,
 /*   140 */   746,  717,  788,  781,  682,  706,  808,  754,  715,  793,
 /*   150 */   793,  815,  824,  796,  772,  748,  748,  748,  756,  735,
 /*   160 */   737,  738,  752,  793,  820,  811,  872,  817,  873,  829,
 /*   170 */   881,  883,  846,  850,  876,  916,  918,  926,  927,  868,
 /*   180 */   921,  889,  922,  885,  879,  930,  887,  933,  899,  937,
 /*   190 */   942,  947,  953,  965,  941,  946,  948,  951,  952,  960,
 /*   200 */   962,  963,  966,  972,  973,  985,  993,  934,  940,  994,
 /*   210 */   944,  968, 1004, 1007, 1009,  970, 1012,  979,  984,  986,
 /*   220 */   988,  991,  981,  995,  989,  992,  997, 1027, 1014, 1031,
 /*   230 */  1008,  996, 1016,  982, 1003, 1029, 1033,  990, 1017, 1037,
 /*   240 */  1041,  793, 1011, 1015, 1042, 1022,  999, 1019, 1023,  748,
 /*   250 */  1048, 1054, 1034, 1024, 1010, 1035, 1044, 1046, 1049, 1047,
 /*   260 */  1065, 1059, 1112, 1102, 1123, 1137, 1133, 1082, 1088, 1122,
 /*   270 */  1128, 1129, 1142, 1157,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*    10 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*    20 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*    30 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*    40 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*    50 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*    60 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*    70 */  1447, 1447, 1520, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*    80 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1518, 1671, 1447,
 /*    90 */  1848, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   100 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   110 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1520, 1447, 1518,
 /*   120 */  1860, 1860, 1860, 1447, 1447, 1447, 1715, 1715, 1447, 1447,
 /*   130 */  1447, 1447, 1614, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   140 */  1447, 1707, 1447, 1447, 1929, 1447, 1447, 1713, 1883, 1447,
 /*   150 */  1447, 1447, 1447, 1567, 1875, 1852, 1866, 1853, 1850, 1914,
 /*   160 */  1914, 1914, 1869, 1447, 1583, 1879, 1447, 1447, 1447, 1699,
 /*   170 */  1447, 1447, 1676, 1673, 1673, 1447, 1447, 1447, 1447, 1447,
 /*   180 */  1520, 1447, 1520, 1447, 1447, 1520, 1447, 1520, 1447, 1520,
 /*   190 */  1520, 1447, 1520, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   200 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1518,
 /*   210 */  1709, 1447, 1518, 1447, 1447, 1447, 1518, 1888, 1447, 1447,
 /*   220 */  1447, 1447, 1888, 1447, 1447, 1447, 1447, 1518, 1447, 1518,
 /*   230 */  1447, 1447, 1447, 1890, 1888, 1447, 1447, 1890, 1888, 1447,
 /*   240 */  1447, 1447, 1902, 1898, 1890, 1906, 1904, 1881, 1879, 1866,
 /*   250 */  1447, 1447, 1920, 1916, 1932, 1920, 1916, 1920, 1916, 1447,
 /*   260 */  1583, 1447, 1447, 1447, 1518, 1479, 1447, 1701, 1715, 1617,
 /*   270 */  1617, 1617, 1521, 1452, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   280 */  1447, 1447, 1447, 1447, 1447, 1447, 1786, 1901, 1900, 1824,
 /*   290 */  1823, 1822, 1820, 1785, 1447, 1579, 1784, 1783, 1447, 1447,
 /*   300 */  1447, 1447, 1447, 1447, 1447, 1447, 1777, 1778, 1776, 1775,
 /*   310 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   320 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   330 */  1849, 1447, 1917, 1921, 1447, 1447, 1447, 1760, 1447, 1447,
 /*   340 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   350 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   360 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   370 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   380 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   390 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   400 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   410 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   420 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   430 */  1447, 1484, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   440 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   450 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   460 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   470 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1548, 1547,
 /*   480 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   490 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   500 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   510 */  1447, 1447, 1447, 1447, 1447, 1447, 1719, 1447, 1447, 1447,
 /*   520 */  1447, 1447, 1447, 1447, 1447, 1447, 1882, 1447, 1447, 1447,
 /*   530 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   540 */  1447, 1447, 1447, 1760, 1447, 1899, 1447, 1859, 1855, 1447,
 /*   550 */  1447, 1851, 1759, 1447, 1447, 1915, 1447, 1447, 1447, 1447,
 /*   560 */  1447, 1447, 1447, 1447, 1447, 1844, 1447, 1817, 1802, 1447,
 /*   570 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1771,
 /*   580 */  1447, 1447, 1447, 1447, 1447, 1611, 1447, 1447, 1447, 1447,
 /*   590 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1596, 1594,
 /*   600 */  1593, 1592, 1447, 1589, 1447, 1447, 1447, 1447, 1620, 1619,
 /*   610 */  1447, 1447, 1447, 1447, 1447, 1447, 1540, 1447, 1447, 1447,
 /*   620 */  1447, 1447, 1447, 1447, 1447, 1447, 1531, 1447, 1530, 1447,
 /*   630 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   640 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   650 */  1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
 /*   660 */  1447,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  247,  /*  NK_BITNOT => ID */
  247,  /*     VALUES => ID */
  247,  /*     IMPORT => ID */
  247,  /*    NK_SEMI => ID */
  247,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "IF",
  /*   60 */ "NOT",
  /*   61 */ "EXISTS",
  /*   62 */ "BUFFER",
  /*   63 */ "CACHELAST",
  /*   64 */ "COMP",
  /*   65 */ "DURATION",
  /*   66 */ "NK_VARIABLE",
  /*   67 */ "FSYNC",
  /*   68 */ "MAXROWS",
  /*   69 */ "MINROWS",
  /*   70 */ "KEEP",
  /*   71 */ "PAGES",
  /*   72 */ "PAGESIZE",
  /*   73 */ "PRECISION",
  /*   74 */ "REPLICA",
  /*   75 */ "STRICT",
  /*   76 */ "WAL",
  /*   77 */ "VGROUPS",
  /*   78 */ "SINGLE_STABLE",
  /*   79 */ "RETENTIONS",
  /*   80 */ "SCHEMALESS",
  /*   81 */ "NK_COLON",
  /*   82 */ "TABLE",
  /*   83 */ "NK_LP",
  /*   84 */ "NK_RP",
  /*   85 */ "STABLE",
  /*   86 */ "ADD",
  /*   87 */ "COLUMN",
  /*   88 */ "MODIFY",
  /*   89 */ "RENAME",
  /*   90 */ "TAG",
  /*   91 */ "SET",
  /*   92 */ "NK_EQ",
  /*   93 */ "USING",
  /*   94 */ "TAGS",
  /*   95 */ "COMMENT",
  /*   96 */ "BOOL",
  /*   97 */ "TINYINT",
  /*   98 */ "SMALLINT",
  /*   99 */ "INT",
  /*  100 */ "INTEGER",
  /*  101 */ "BIGINT",
  /*  102 */ "FLOAT",
  /*  103 */ "DOUBLE",
  /*  104 */ "BINARY",
  /*  105 */ "TIMESTAMP",
  /*  106 */ "NCHAR",
  /*  107 */ "UNSIGNED",
  /*  108 */ "JSON",
  /*  109 */ "VARCHAR",
  /*  110 */ "MEDIUMBLOB",
  /*  111 */ "BLOB",
  /*  112 */ "VARBINARY",
  /*  113 */ "DECIMAL",
  /*  114 */ "MAX_DELAY",
  /*  115 */ "WATERMARK",
  /*  116 */ "ROLLUP",
  /*  117 */ "TTL",
  /*  118 */ "SMA",
  /*  119 */ "FIRST",
  /*  120 */ "LAST",
  /*  121 */ "SHOW",
  /*  122 */ "DATABASES",
  /*  123 */ "TABLES",
  /*  124 */ "STABLES",
  /*  125 */ "MNODES",
  /*  126 */ "MODULES",
  /*  127 */ "QNODES",
  /*  128 */ "FUNCTIONS",
  /*  129 */ "INDEXES",
  /*  130 */ "ACCOUNTS",
  /*  131 */ "APPS",
  /*  132 */ "CONNECTIONS",
  /*  133 */ "LICENCE",
  /*  134 */ "GRANTS",
  /*  135 */ "QUERIES",
  /*  136 */ "SCORES",
  /*  137 */ "TOPICS",
  /*  138 */ "VARIABLES",
  /*  139 */ "BNODES",
  /*  140 */ "SNODES",
  /*  141 */ "CLUSTER",
  /*  142 */ "TRANSACTIONS",
  /*  143 */ "DISTRIBUTED",
  /*  144 */ "CONSUMERS",
  /*  145 */ "SUBSCRIPTIONS",
  /*  146 */ "LIKE",
  /*  147 */ "INDEX",
  /*  148 */ "FUNCTION",
  /*  149 */ "INTERVAL",
  /*  150 */ "TOPIC",
  /*  151 */ "AS",
  /*  152 */ "WITH",
  /*  153 */ "META",
  /*  154 */ "CONSUMER",
  /*  155 */ "GROUP",
  /*  156 */ "DESC",
  /*  157 */ "DESCRIBE",
  /*  158 */ "RESET",
  /*  159 */ "QUERY",
  /*  160 */ "CACHE",
  /*  161 */ "EXPLAIN",
  /*  162 */ "ANALYZE",
  /*  163 */ "VERBOSE",
  /*  164 */ "NK_BOOL",
  /*  165 */ "RATIO",
  /*  166 */ "NK_FLOAT",
  /*  167 */ "COMPACT",
  /*  168 */ "VNODES",
  /*  169 */ "IN",
  /*  170 */ "OUTPUTTYPE",
  /*  171 */ "AGGREGATE",
  /*  172 */ "BUFSIZE",
  /*  173 */ "STREAM",
  /*  174 */ "INTO",
  /*  175 */ "TRIGGER",
  /*  176 */ "AT_ONCE",
  /*  177 */ "WINDOW_CLOSE",
  /*  178 */ "IGNORE",
  /*  179 */ "EXPIRED",
  /*  180 */ "KILL",
  /*  181 */ "CONNECTION",
  /*  182 */ "TRANSACTION",
  /*  183 */ "BALANCE",
  /*  184 */ "VGROUP",
  /*  185 */ "MERGE",
  /*  186 */ "REDISTRIBUTE",
  /*  187 */ "SPLIT",
  /*  188 */ "SYNCDB",
  /*  189 */ "DELETE",
  /*  190 */ "INSERT",
  /*  191 */ "NULL",
  /*  192 */ "NK_QUESTION",
  /*  193 */ "NK_ARROW",
  /*  194 */ "ROWTS",
  /*  195 */ "TBNAME",
  /*  196 */ "QSTARTTS",
  /*  197 */ "QENDTS",
  /*  198 */ "WSTARTTS",
  /*  199 */ "WENDTS",
  /*  200 */ "WDURATION",
  /*  201 */ "CAST",
  /*  202 */ "NOW",
  /*  203 */ "TODAY",
  /*  204 */ "TIMEZONE",
  /*  205 */ "CLIENT_VERSION",
  /*  206 */ "SERVER_VERSION",
  /*  207 */ "SERVER_STATUS",
  /*  208 */ "CURRENT_USER",
  /*  209 */ "COUNT",
  /*  210 */ "LAST_ROW",
  /*  211 */ "BETWEEN",
  /*  212 */ "IS",
  /*  213 */ "NK_LT",
  /*  214 */ "NK_GT",
  /*  215 */ "NK_LE",
  /*  216 */ "NK_GE",
  /*  217 */ "NK_NE",
  /*  218 */ "MATCH",
  /*  219 */ "NMATCH",
  /*  220 */ "CONTAINS",
  /*  221 */ "JOIN",
  /*  222 */ "INNER",
  /*  223 */ "SELECT",
  /*  224 */ "DISTINCT",
  /*  225 */ "WHERE",
  /*  226 */ "PARTITION",
  /*  227 */ "BY",
  /*  228 */ "SESSION",
  /*  229 */ "STATE_WINDOW",
  /*  230 */ "SLIDING",
  /*  231 */ "FILL",
  /*  232 */ "VALUE",
  /*  233 */ "NONE",
  /*  234 */ "PREV",
  /*  235 */ "LINEAR",
  /*  236 */ "NEXT",
  /*  237 */ "HAVING",
  /*  238 */ "RANGE",
  /*  239 */ "EVERY",
  /*  240 */ "ORDER",
  /*  241 */ "SLIMIT",
  /*  242 */ "SOFFSET",
  /*  243 */ "LIMIT",
  /*  244 */ "OFFSET",
  /*  245 */ "ASC",
  /*  246 */ "NULLS",
  /*  247 */ "ID",
  /*  248 */ "NK_BITNOT",
  /*  249 */ "VALUES",
  /*  250 */ "IMPORT",
  /*  251 */ "NK_SEMI",
  /*  252 */ "FILE",
  /*  253 */ "cmd",
  /*  254 */ "account_options",
  /*  255 */ "alter_account_options",
  /*  256 */ "literal",
  /*  257 */ "alter_account_option",
  /*  258 */ "user_name",
  /*  259 */ "sysinfo_opt",
  /*  260 */ "privileges",
  /*  261 */ "priv_level",
  /*  262 */ "priv_type_list",
  /*  263 */ "priv_type",
  /*  264 */ "db_name",
  /*  265 */ "dnode_endpoint",
  /*  266 */ "not_exists_opt",
  /*  267 */ "db_options",
  /*  268 */ "exists_opt",
  /*  269 */ "alter_db_options",
  /*  270 */ "integer_list",
  /*  271 */ "variable_list",
  /*  272 */ "retention_list",
  /*  273 */ "alter_db_option",
  /*  274 */ "retention",
  /*  275 */ "full_table_name",
  /*  276 */ "column_def_list",
  /*  277 */ "tags_def_opt",
  /*  278 */ "table_options",
  /*  279 */ "multi_create_clause",
  /*  280 */ "tags_def",
  /*  281 */ "multi_drop_clause",
  /*  282 */ "alter_table_clause",
  /*  283 */ "alter_table_options",
  /*  284 */ "column_name",
  /*  285 */ "type_name",
  /*  286 */ "signed_literal",
  /*  287 */ "create_subtable_clause",
  /*  288 */ "specific_cols_opt",
  /*  289 */ "expression_list",
  /*  290 */ "drop_table_clause",
  /*  291 */ "col_name_list",
  /*  292 */ "table_name",
  /*  293 */ "column_def",
  /*  294 */ "duration_list",
  /*  295 */ "rollup_func_list",
  /*  296 */ "alter_table_option",
  /*  297 */ "duration_literal",
  /*  298 */ "rollup_func_name",
  /*  299 */ "function_name",
  /*  300 */ "col_name",
  /*  301 */ "db_name_cond_opt",
  /*  302 */ "like_pattern_opt",
  /*  303 */ "table_name_cond",
  /*  304 */ "from_db_opt",
  /*  305 */ "index_name",
  /*  306 */ "index_options",
  /*  307 */ "func_list",
  /*  308 */ "sliding_opt",
  /*  309 */ "sma_stream_opt",
  /*  310 */ "func",
  /*  311 */ "stream_options",
  /*  312 */ "topic_name",
  /*  313 */ "query_expression",
  /*  314 */ "cgroup_name",
  /*  315 */ "analyze_opt",
  /*  316 */ "explain_options",
  /*  317 */ "agg_func_opt",
  /*  318 */ "bufsize_opt",
  /*  319 */ "stream_name",
  /*  320 */ "into_opt",
  /*  321 */ "dnode_list",
  /*  322 */ "where_clause_opt",
  /*  323 */ "signed",
  /*  324 */ "literal_func",
  /*  325 */ "literal_list",
  /*  326 */ "table_alias",
  /*  327 */ "column_alias",
  /*  328 */ "expression",
  /*  329 */ "pseudo_column",
  /*  330 */ "column_reference",
  /*  331 */ "function_expression",
  /*  332 */ "subquery",
  /*  333 */ "star_func",
  /*  334 */ "star_func_para_list",
  /*  335 */ "noarg_func",
  /*  336 */ "other_para_list",
  /*  337 */ "star_func_para",
  /*  338 */ "predicate",
  /*  339 */ "compare_op",
  /*  340 */ "in_op",
  /*  341 */ "in_predicate_value",
  /*  342 */ "boolean_value_expression",
  /*  343 */ "boolean_primary",
  /*  344 */ "common_expression",
  /*  345 */ "from_clause_opt",
  /*  346 */ "table_reference_list",
  /*  347 */ "table_reference",
  /*  348 */ "table_primary",
  /*  349 */ "joined_table",
  /*  350 */ "alias_opt",
  /*  351 */ "parenthesized_joined_table",
  /*  352 */ "join_type",
  /*  353 */ "search_condition",
  /*  354 */ "query_specification",
  /*  355 */ "set_quantifier_opt",
  /*  356 */ "select_list",
  /*  357 */ "partition_by_clause_opt",
  /*  358 */ "range_opt",
  /*  359 */ "every_opt",
  /*  360 */ "fill_opt",
  /*  361 */ "twindow_clause_opt",
  /*  362 */ "group_by_clause_opt",
  /*  363 */ "having_clause_opt",
  /*  364 */ "select_item",
  /*  365 */ "fill_mode",
  /*  366 */ "group_by_list",
  /*  367 */ "query_expression_body",
  /*  368 */ "order_by_clause_opt",
  /*  369 */ "slimit_clause_opt",
  /*  370 */ "limit_clause_opt",
  /*  371 */ "query_primary",
  /*  372 */ "sort_specification_list",
  /*  373 */ "sort_specification",
  /*  374 */ "ordering_specification_opt",
  /*  375 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  68 */ "not_exists_opt ::=",
 /*  69 */ "exists_opt ::= IF EXISTS",
 /*  70 */ "exists_opt ::=",
 /*  71 */ "db_options ::=",
 /*  72 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  73 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  74 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  75 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  76 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  77 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  78 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  79 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options KEEP integer_list",
 /*  81 */ "db_options ::= db_options KEEP variable_list",
 /*  82 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  83 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  84 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  85 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  86 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  87 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  88 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  89 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  90 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  91 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  92 */ "alter_db_options ::= alter_db_option",
 /*  93 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  94 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  95 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  96 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  97 */ "alter_db_option ::= KEEP integer_list",
 /*  98 */ "alter_db_option ::= KEEP variable_list",
 /*  99 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 100 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 101 */ "alter_db_option ::= STRICT NK_INTEGER",
 /* 102 */ "alter_db_option ::= WAL NK_INTEGER",
 /* 103 */ "integer_list ::= NK_INTEGER",
 /* 104 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 105 */ "variable_list ::= NK_VARIABLE",
 /* 106 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 107 */ "retention_list ::= retention",
 /* 108 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 109 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 110 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 111 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 112 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 113 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 114 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 115 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 116 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 117 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 118 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 119 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 120 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 121 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 122 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 123 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 124 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 125 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 126 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 127 */ "multi_create_clause ::= create_subtable_clause",
 /* 128 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 129 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 130 */ "multi_drop_clause ::= drop_table_clause",
 /* 131 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 132 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 133 */ "specific_cols_opt ::=",
 /* 134 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 135 */ "full_table_name ::= table_name",
 /* 136 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 137 */ "column_def_list ::= column_def",
 /* 138 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 139 */ "column_def ::= column_name type_name",
 /* 140 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 141 */ "type_name ::= BOOL",
 /* 142 */ "type_name ::= TINYINT",
 /* 143 */ "type_name ::= SMALLINT",
 /* 144 */ "type_name ::= INT",
 /* 145 */ "type_name ::= INTEGER",
 /* 146 */ "type_name ::= BIGINT",
 /* 147 */ "type_name ::= FLOAT",
 /* 148 */ "type_name ::= DOUBLE",
 /* 149 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 150 */ "type_name ::= TIMESTAMP",
 /* 151 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 152 */ "type_name ::= TINYINT UNSIGNED",
 /* 153 */ "type_name ::= SMALLINT UNSIGNED",
 /* 154 */ "type_name ::= INT UNSIGNED",
 /* 155 */ "type_name ::= BIGINT UNSIGNED",
 /* 156 */ "type_name ::= JSON",
 /* 157 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 158 */ "type_name ::= MEDIUMBLOB",
 /* 159 */ "type_name ::= BLOB",
 /* 160 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 161 */ "type_name ::= DECIMAL",
 /* 162 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 163 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 164 */ "tags_def_opt ::=",
 /* 165 */ "tags_def_opt ::= tags_def",
 /* 166 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 167 */ "table_options ::=",
 /* 168 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 169 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 170 */ "table_options ::= table_options WATERMARK duration_list",
 /* 171 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 172 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 173 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 174 */ "alter_table_options ::= alter_table_option",
 /* 175 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 176 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 177 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 178 */ "duration_list ::= duration_literal",
 /* 179 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 180 */ "rollup_func_list ::= rollup_func_name",
 /* 181 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 182 */ "rollup_func_name ::= function_name",
 /* 183 */ "rollup_func_name ::= FIRST",
 /* 184 */ "rollup_func_name ::= LAST",
 /* 185 */ "col_name_list ::= col_name",
 /* 186 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 187 */ "col_name ::= column_name",
 /* 188 */ "cmd ::= SHOW DNODES",
 /* 189 */ "cmd ::= SHOW USERS",
 /* 190 */ "cmd ::= SHOW DATABASES",
 /* 191 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 192 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 193 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 194 */ "cmd ::= SHOW MNODES",
 /* 195 */ "cmd ::= SHOW MODULES",
 /* 196 */ "cmd ::= SHOW QNODES",
 /* 197 */ "cmd ::= SHOW FUNCTIONS",
 /* 198 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 199 */ "cmd ::= SHOW STREAMS",
 /* 200 */ "cmd ::= SHOW ACCOUNTS",
 /* 201 */ "cmd ::= SHOW APPS",
 /* 202 */ "cmd ::= SHOW CONNECTIONS",
 /* 203 */ "cmd ::= SHOW LICENCE",
 /* 204 */ "cmd ::= SHOW GRANTS",
 /* 205 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 206 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 207 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 208 */ "cmd ::= SHOW QUERIES",
 /* 209 */ "cmd ::= SHOW SCORES",
 /* 210 */ "cmd ::= SHOW TOPICS",
 /* 211 */ "cmd ::= SHOW VARIABLES",
 /* 212 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 213 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 214 */ "cmd ::= SHOW BNODES",
 /* 215 */ "cmd ::= SHOW SNODES",
 /* 216 */ "cmd ::= SHOW CLUSTER",
 /* 217 */ "cmd ::= SHOW TRANSACTIONS",
 /* 218 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 219 */ "cmd ::= SHOW CONSUMERS",
 /* 220 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 221 */ "db_name_cond_opt ::=",
 /* 222 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 223 */ "like_pattern_opt ::=",
 /* 224 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 225 */ "table_name_cond ::= table_name",
 /* 226 */ "from_db_opt ::=",
 /* 227 */ "from_db_opt ::= FROM db_name",
 /* 228 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 229 */ "cmd ::= DROP INDEX exists_opt index_name",
 /* 230 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 231 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 232 */ "func_list ::= func",
 /* 233 */ "func_list ::= func_list NK_COMMA func",
 /* 234 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 235 */ "sma_stream_opt ::=",
 /* 236 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 237 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 238 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 239 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 240 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 241 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 242 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 243 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 244 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 245 */ "cmd ::= DESC full_table_name",
 /* 246 */ "cmd ::= DESCRIBE full_table_name",
 /* 247 */ "cmd ::= RESET QUERY CACHE",
 /* 248 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 249 */ "analyze_opt ::=",
 /* 250 */ "analyze_opt ::= ANALYZE",
 /* 251 */ "explain_options ::=",
 /* 252 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 253 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 254 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 255 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 256 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 257 */ "agg_func_opt ::=",
 /* 258 */ "agg_func_opt ::= AGGREGATE",
 /* 259 */ "bufsize_opt ::=",
 /* 260 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 261 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 262 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 263 */ "into_opt ::=",
 /* 264 */ "into_opt ::= INTO full_table_name",
 /* 265 */ "stream_options ::=",
 /* 266 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 267 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 268 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 269 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 270 */ "stream_options ::= stream_options IGNORE EXPIRED",
 /* 271 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 272 */ "cmd ::= KILL QUERY NK_STRING",
 /* 273 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 274 */ "cmd ::= BALANCE VGROUP",
 /* 275 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 276 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 277 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 278 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 279 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 280 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 281 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 282 */ "cmd ::= query_expression",
 /* 283 */ "cmd ::= INSERT INTO full_table_name specific_cols_opt query_expression",
 /* 284 */ "literal ::= NK_INTEGER",
 /* 285 */ "literal ::= NK_FLOAT",
 /* 286 */ "literal ::= NK_STRING",
 /* 287 */ "literal ::= NK_BOOL",
 /* 288 */ "literal ::= TIMESTAMP NK_STRING",
 /* 289 */ "literal ::= duration_literal",
 /* 290 */ "literal ::= NULL",
 /* 291 */ "literal ::= NK_QUESTION",
 /* 292 */ "duration_literal ::= NK_VARIABLE",
 /* 293 */ "signed ::= NK_INTEGER",
 /* 294 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 295 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 296 */ "signed ::= NK_FLOAT",
 /* 297 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 298 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 299 */ "signed_literal ::= signed",
 /* 300 */ "signed_literal ::= NK_STRING",
 /* 301 */ "signed_literal ::= NK_BOOL",
 /* 302 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 303 */ "signed_literal ::= duration_literal",
 /* 304 */ "signed_literal ::= NULL",
 /* 305 */ "signed_literal ::= literal_func",
 /* 306 */ "literal_list ::= signed_literal",
 /* 307 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 308 */ "db_name ::= NK_ID",
 /* 309 */ "table_name ::= NK_ID",
 /* 310 */ "column_name ::= NK_ID",
 /* 311 */ "function_name ::= NK_ID",
 /* 312 */ "table_alias ::= NK_ID",
 /* 313 */ "column_alias ::= NK_ID",
 /* 314 */ "user_name ::= NK_ID",
 /* 315 */ "index_name ::= NK_ID",
 /* 316 */ "topic_name ::= NK_ID",
 /* 317 */ "stream_name ::= NK_ID",
 /* 318 */ "cgroup_name ::= NK_ID",
 /* 319 */ "expression ::= literal",
 /* 320 */ "expression ::= pseudo_column",
 /* 321 */ "expression ::= column_reference",
 /* 322 */ "expression ::= function_expression",
 /* 323 */ "expression ::= subquery",
 /* 324 */ "expression ::= NK_LP expression NK_RP",
 /* 325 */ "expression ::= NK_PLUS expression",
 /* 326 */ "expression ::= NK_MINUS expression",
 /* 327 */ "expression ::= expression NK_PLUS expression",
 /* 328 */ "expression ::= expression NK_MINUS expression",
 /* 329 */ "expression ::= expression NK_STAR expression",
 /* 330 */ "expression ::= expression NK_SLASH expression",
 /* 331 */ "expression ::= expression NK_REM expression",
 /* 332 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 333 */ "expression ::= expression NK_BITAND expression",
 /* 334 */ "expression ::= expression NK_BITOR expression",
 /* 335 */ "expression_list ::= expression",
 /* 336 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 337 */ "column_reference ::= column_name",
 /* 338 */ "column_reference ::= table_name NK_DOT column_name",
 /* 339 */ "pseudo_column ::= ROWTS",
 /* 340 */ "pseudo_column ::= TBNAME",
 /* 341 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 342 */ "pseudo_column ::= QSTARTTS",
 /* 343 */ "pseudo_column ::= QENDTS",
 /* 344 */ "pseudo_column ::= WSTARTTS",
 /* 345 */ "pseudo_column ::= WENDTS",
 /* 346 */ "pseudo_column ::= WDURATION",
 /* 347 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 348 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 349 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 350 */ "function_expression ::= literal_func",
 /* 351 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 352 */ "literal_func ::= NOW",
 /* 353 */ "noarg_func ::= NOW",
 /* 354 */ "noarg_func ::= TODAY",
 /* 355 */ "noarg_func ::= TIMEZONE",
 /* 356 */ "noarg_func ::= DATABASE",
 /* 357 */ "noarg_func ::= CLIENT_VERSION",
 /* 358 */ "noarg_func ::= SERVER_VERSION",
 /* 359 */ "noarg_func ::= SERVER_STATUS",
 /* 360 */ "noarg_func ::= CURRENT_USER",
 /* 361 */ "noarg_func ::= USER",
 /* 362 */ "star_func ::= COUNT",
 /* 363 */ "star_func ::= FIRST",
 /* 364 */ "star_func ::= LAST",
 /* 365 */ "star_func ::= LAST_ROW",
 /* 366 */ "star_func_para_list ::= NK_STAR",
 /* 367 */ "star_func_para_list ::= other_para_list",
 /* 368 */ "other_para_list ::= star_func_para",
 /* 369 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 370 */ "star_func_para ::= expression",
 /* 371 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 372 */ "predicate ::= expression compare_op expression",
 /* 373 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 374 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 375 */ "predicate ::= expression IS NULL",
 /* 376 */ "predicate ::= expression IS NOT NULL",
 /* 377 */ "predicate ::= expression in_op in_predicate_value",
 /* 378 */ "compare_op ::= NK_LT",
 /* 379 */ "compare_op ::= NK_GT",
 /* 380 */ "compare_op ::= NK_LE",
 /* 381 */ "compare_op ::= NK_GE",
 /* 382 */ "compare_op ::= NK_NE",
 /* 383 */ "compare_op ::= NK_EQ",
 /* 384 */ "compare_op ::= LIKE",
 /* 385 */ "compare_op ::= NOT LIKE",
 /* 386 */ "compare_op ::= MATCH",
 /* 387 */ "compare_op ::= NMATCH",
 /* 388 */ "compare_op ::= CONTAINS",
 /* 389 */ "in_op ::= IN",
 /* 390 */ "in_op ::= NOT IN",
 /* 391 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 392 */ "boolean_value_expression ::= boolean_primary",
 /* 393 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 394 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 395 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 396 */ "boolean_primary ::= predicate",
 /* 397 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 398 */ "common_expression ::= expression",
 /* 399 */ "common_expression ::= boolean_value_expression",
 /* 400 */ "from_clause_opt ::=",
 /* 401 */ "from_clause_opt ::= FROM table_reference_list",
 /* 402 */ "table_reference_list ::= table_reference",
 /* 403 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 404 */ "table_reference ::= table_primary",
 /* 405 */ "table_reference ::= joined_table",
 /* 406 */ "table_primary ::= table_name alias_opt",
 /* 407 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 408 */ "table_primary ::= subquery alias_opt",
 /* 409 */ "table_primary ::= parenthesized_joined_table",
 /* 410 */ "alias_opt ::=",
 /* 411 */ "alias_opt ::= table_alias",
 /* 412 */ "alias_opt ::= AS table_alias",
 /* 413 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 414 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 415 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 416 */ "join_type ::=",
 /* 417 */ "join_type ::= INNER",
 /* 418 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 419 */ "set_quantifier_opt ::=",
 /* 420 */ "set_quantifier_opt ::= DISTINCT",
 /* 421 */ "set_quantifier_opt ::= ALL",
 /* 422 */ "select_list ::= select_item",
 /* 423 */ "select_list ::= select_list NK_COMMA select_item",
 /* 424 */ "select_item ::= NK_STAR",
 /* 425 */ "select_item ::= common_expression",
 /* 426 */ "select_item ::= common_expression column_alias",
 /* 427 */ "select_item ::= common_expression AS column_alias",
 /* 428 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 429 */ "where_clause_opt ::=",
 /* 430 */ "where_clause_opt ::= WHERE search_condition",
 /* 431 */ "partition_by_clause_opt ::=",
 /* 432 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 433 */ "twindow_clause_opt ::=",
 /* 434 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 435 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 436 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 437 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 438 */ "sliding_opt ::=",
 /* 439 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 440 */ "fill_opt ::=",
 /* 441 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 442 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 443 */ "fill_mode ::= NONE",
 /* 444 */ "fill_mode ::= PREV",
 /* 445 */ "fill_mode ::= NULL",
 /* 446 */ "fill_mode ::= LINEAR",
 /* 447 */ "fill_mode ::= NEXT",
 /* 448 */ "group_by_clause_opt ::=",
 /* 449 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 450 */ "group_by_list ::= expression",
 /* 451 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 452 */ "having_clause_opt ::=",
 /* 453 */ "having_clause_opt ::= HAVING search_condition",
 /* 454 */ "range_opt ::=",
 /* 455 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 456 */ "every_opt ::=",
 /* 457 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 458 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 459 */ "query_expression_body ::= query_primary",
 /* 460 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 461 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 462 */ "query_primary ::= query_specification",
 /* 463 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 464 */ "order_by_clause_opt ::=",
 /* 465 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 466 */ "slimit_clause_opt ::=",
 /* 467 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 468 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 469 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 470 */ "limit_clause_opt ::=",
 /* 471 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 472 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 473 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 474 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 475 */ "search_condition ::= common_expression",
 /* 476 */ "sort_specification_list ::= sort_specification",
 /* 477 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 478 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 479 */ "ordering_specification_opt ::=",
 /* 480 */ "ordering_specification_opt ::= ASC",
 /* 481 */ "ordering_specification_opt ::= DESC",
 /* 482 */ "null_ordering_opt ::=",
 /* 483 */ "null_ordering_opt ::= NULLS FIRST",
 /* 484 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 253: /* cmd */
    case 256: /* literal */
    case 267: /* db_options */
    case 269: /* alter_db_options */
    case 274: /* retention */
    case 275: /* full_table_name */
    case 278: /* table_options */
    case 282: /* alter_table_clause */
    case 283: /* alter_table_options */
    case 286: /* signed_literal */
    case 287: /* create_subtable_clause */
    case 290: /* drop_table_clause */
    case 293: /* column_def */
    case 297: /* duration_literal */
    case 298: /* rollup_func_name */
    case 300: /* col_name */
    case 301: /* db_name_cond_opt */
    case 302: /* like_pattern_opt */
    case 303: /* table_name_cond */
    case 304: /* from_db_opt */
    case 306: /* index_options */
    case 308: /* sliding_opt */
    case 309: /* sma_stream_opt */
    case 310: /* func */
    case 311: /* stream_options */
    case 313: /* query_expression */
    case 316: /* explain_options */
    case 320: /* into_opt */
    case 322: /* where_clause_opt */
    case 323: /* signed */
    case 324: /* literal_func */
    case 328: /* expression */
    case 329: /* pseudo_column */
    case 330: /* column_reference */
    case 331: /* function_expression */
    case 332: /* subquery */
    case 337: /* star_func_para */
    case 338: /* predicate */
    case 341: /* in_predicate_value */
    case 342: /* boolean_value_expression */
    case 343: /* boolean_primary */
    case 344: /* common_expression */
    case 345: /* from_clause_opt */
    case 346: /* table_reference_list */
    case 347: /* table_reference */
    case 348: /* table_primary */
    case 349: /* joined_table */
    case 351: /* parenthesized_joined_table */
    case 353: /* search_condition */
    case 354: /* query_specification */
    case 358: /* range_opt */
    case 359: /* every_opt */
    case 360: /* fill_opt */
    case 361: /* twindow_clause_opt */
    case 363: /* having_clause_opt */
    case 364: /* select_item */
    case 367: /* query_expression_body */
    case 369: /* slimit_clause_opt */
    case 370: /* limit_clause_opt */
    case 371: /* query_primary */
    case 373: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy248)); 
}
      break;
    case 254: /* account_options */
    case 255: /* alter_account_options */
    case 257: /* alter_account_option */
    case 318: /* bufsize_opt */
{
 
}
      break;
    case 258: /* user_name */
    case 261: /* priv_level */
    case 264: /* db_name */
    case 265: /* dnode_endpoint */
    case 284: /* column_name */
    case 292: /* table_name */
    case 299: /* function_name */
    case 305: /* index_name */
    case 312: /* topic_name */
    case 314: /* cgroup_name */
    case 319: /* stream_name */
    case 326: /* table_alias */
    case 327: /* column_alias */
    case 333: /* star_func */
    case 335: /* noarg_func */
    case 350: /* alias_opt */
{
 
}
      break;
    case 259: /* sysinfo_opt */
{
 
}
      break;
    case 260: /* privileges */
    case 262: /* priv_type_list */
    case 263: /* priv_type */
{
 
}
      break;
    case 266: /* not_exists_opt */
    case 268: /* exists_opt */
    case 315: /* analyze_opt */
    case 317: /* agg_func_opt */
    case 355: /* set_quantifier_opt */
{
 
}
      break;
    case 270: /* integer_list */
    case 271: /* variable_list */
    case 272: /* retention_list */
    case 276: /* column_def_list */
    case 277: /* tags_def_opt */
    case 279: /* multi_create_clause */
    case 280: /* tags_def */
    case 281: /* multi_drop_clause */
    case 288: /* specific_cols_opt */
    case 289: /* expression_list */
    case 291: /* col_name_list */
    case 294: /* duration_list */
    case 295: /* rollup_func_list */
    case 307: /* func_list */
    case 321: /* dnode_list */
    case 325: /* literal_list */
    case 334: /* star_func_para_list */
    case 336: /* other_para_list */
    case 356: /* select_list */
    case 357: /* partition_by_clause_opt */
    case 362: /* group_by_clause_opt */
    case 366: /* group_by_list */
    case 368: /* order_by_clause_opt */
    case 372: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy552)); 
}
      break;
    case 273: /* alter_db_option */
    case 296: /* alter_table_option */
{
 
}
      break;
    case 285: /* type_name */
{
 
}
      break;
    case 339: /* compare_op */
    case 340: /* in_op */
{
 
}
      break;
    case 352: /* join_type */
{
 
}
      break;
    case 365: /* fill_mode */
{
 
}
      break;
    case 374: /* ordering_specification_opt */
{
 
}
      break;
    case 375: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  253,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  253,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  254,    0 }, /* (2) account_options ::= */
  {  254,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  254,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  254,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  254,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  254,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  254,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  254,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  254,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  254,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  255,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  255,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  257,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  257,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  257,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  257,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  257,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  257,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  257,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  257,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  257,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  257,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  253,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  253,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  253,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  253,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  253,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  259,    0 }, /* (29) sysinfo_opt ::= */
  {  259,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  253,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  253,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  260,   -1 }, /* (33) privileges ::= ALL */
  {  260,   -1 }, /* (34) privileges ::= priv_type_list */
  {  262,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  262,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  263,   -1 }, /* (37) priv_type ::= READ */
  {  263,   -1 }, /* (38) priv_type ::= WRITE */
  {  261,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  261,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  253,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  253,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  253,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  253,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  253,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  253,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  253,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  253,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  265,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  265,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  265,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  253,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  253,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  253,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  253,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  253,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  253,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  253,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  253,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  253,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  253,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  253,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  253,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  253,   -2 }, /* (64) cmd ::= USE db_name */
  {  253,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  253,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  266,   -3 }, /* (67) not_exists_opt ::= IF NOT EXISTS */
  {  266,    0 }, /* (68) not_exists_opt ::= */
  {  268,   -2 }, /* (69) exists_opt ::= IF EXISTS */
  {  268,    0 }, /* (70) exists_opt ::= */
  {  267,    0 }, /* (71) db_options ::= */
  {  267,   -3 }, /* (72) db_options ::= db_options BUFFER NK_INTEGER */
  {  267,   -3 }, /* (73) db_options ::= db_options CACHELAST NK_INTEGER */
  {  267,   -3 }, /* (74) db_options ::= db_options COMP NK_INTEGER */
  {  267,   -3 }, /* (75) db_options ::= db_options DURATION NK_INTEGER */
  {  267,   -3 }, /* (76) db_options ::= db_options DURATION NK_VARIABLE */
  {  267,   -3 }, /* (77) db_options ::= db_options FSYNC NK_INTEGER */
  {  267,   -3 }, /* (78) db_options ::= db_options MAXROWS NK_INTEGER */
  {  267,   -3 }, /* (79) db_options ::= db_options MINROWS NK_INTEGER */
  {  267,   -3 }, /* (80) db_options ::= db_options KEEP integer_list */
  {  267,   -3 }, /* (81) db_options ::= db_options KEEP variable_list */
  {  267,   -3 }, /* (82) db_options ::= db_options PAGES NK_INTEGER */
  {  267,   -3 }, /* (83) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  267,   -3 }, /* (84) db_options ::= db_options PRECISION NK_STRING */
  {  267,   -3 }, /* (85) db_options ::= db_options REPLICA NK_INTEGER */
  {  267,   -3 }, /* (86) db_options ::= db_options STRICT NK_INTEGER */
  {  267,   -3 }, /* (87) db_options ::= db_options WAL NK_INTEGER */
  {  267,   -3 }, /* (88) db_options ::= db_options VGROUPS NK_INTEGER */
  {  267,   -3 }, /* (89) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  267,   -3 }, /* (90) db_options ::= db_options RETENTIONS retention_list */
  {  267,   -3 }, /* (91) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  269,   -1 }, /* (92) alter_db_options ::= alter_db_option */
  {  269,   -2 }, /* (93) alter_db_options ::= alter_db_options alter_db_option */
  {  273,   -2 }, /* (94) alter_db_option ::= BUFFER NK_INTEGER */
  {  273,   -2 }, /* (95) alter_db_option ::= CACHELAST NK_INTEGER */
  {  273,   -2 }, /* (96) alter_db_option ::= FSYNC NK_INTEGER */
  {  273,   -2 }, /* (97) alter_db_option ::= KEEP integer_list */
  {  273,   -2 }, /* (98) alter_db_option ::= KEEP variable_list */
  {  273,   -2 }, /* (99) alter_db_option ::= PAGES NK_INTEGER */
  {  273,   -2 }, /* (100) alter_db_option ::= REPLICA NK_INTEGER */
  {  273,   -2 }, /* (101) alter_db_option ::= STRICT NK_INTEGER */
  {  273,   -2 }, /* (102) alter_db_option ::= WAL NK_INTEGER */
  {  270,   -1 }, /* (103) integer_list ::= NK_INTEGER */
  {  270,   -3 }, /* (104) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  271,   -1 }, /* (105) variable_list ::= NK_VARIABLE */
  {  271,   -3 }, /* (106) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  272,   -1 }, /* (107) retention_list ::= retention */
  {  272,   -3 }, /* (108) retention_list ::= retention_list NK_COMMA retention */
  {  274,   -3 }, /* (109) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  253,   -9 }, /* (110) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  253,   -3 }, /* (111) cmd ::= CREATE TABLE multi_create_clause */
  {  253,   -9 }, /* (112) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  253,   -3 }, /* (113) cmd ::= DROP TABLE multi_drop_clause */
  {  253,   -4 }, /* (114) cmd ::= DROP STABLE exists_opt full_table_name */
  {  253,   -3 }, /* (115) cmd ::= ALTER TABLE alter_table_clause */
  {  253,   -3 }, /* (116) cmd ::= ALTER STABLE alter_table_clause */
  {  282,   -2 }, /* (117) alter_table_clause ::= full_table_name alter_table_options */
  {  282,   -5 }, /* (118) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  282,   -4 }, /* (119) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  282,   -5 }, /* (120) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  282,   -5 }, /* (121) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  282,   -5 }, /* (122) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  282,   -4 }, /* (123) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  282,   -5 }, /* (124) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  282,   -5 }, /* (125) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  282,   -6 }, /* (126) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  279,   -1 }, /* (127) multi_create_clause ::= create_subtable_clause */
  {  279,   -2 }, /* (128) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  287,  -10 }, /* (129) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  281,   -1 }, /* (130) multi_drop_clause ::= drop_table_clause */
  {  281,   -2 }, /* (131) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  290,   -2 }, /* (132) drop_table_clause ::= exists_opt full_table_name */
  {  288,    0 }, /* (133) specific_cols_opt ::= */
  {  288,   -3 }, /* (134) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  275,   -1 }, /* (135) full_table_name ::= table_name */
  {  275,   -3 }, /* (136) full_table_name ::= db_name NK_DOT table_name */
  {  276,   -1 }, /* (137) column_def_list ::= column_def */
  {  276,   -3 }, /* (138) column_def_list ::= column_def_list NK_COMMA column_def */
  {  293,   -2 }, /* (139) column_def ::= column_name type_name */
  {  293,   -4 }, /* (140) column_def ::= column_name type_name COMMENT NK_STRING */
  {  285,   -1 }, /* (141) type_name ::= BOOL */
  {  285,   -1 }, /* (142) type_name ::= TINYINT */
  {  285,   -1 }, /* (143) type_name ::= SMALLINT */
  {  285,   -1 }, /* (144) type_name ::= INT */
  {  285,   -1 }, /* (145) type_name ::= INTEGER */
  {  285,   -1 }, /* (146) type_name ::= BIGINT */
  {  285,   -1 }, /* (147) type_name ::= FLOAT */
  {  285,   -1 }, /* (148) type_name ::= DOUBLE */
  {  285,   -4 }, /* (149) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  285,   -1 }, /* (150) type_name ::= TIMESTAMP */
  {  285,   -4 }, /* (151) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  285,   -2 }, /* (152) type_name ::= TINYINT UNSIGNED */
  {  285,   -2 }, /* (153) type_name ::= SMALLINT UNSIGNED */
  {  285,   -2 }, /* (154) type_name ::= INT UNSIGNED */
  {  285,   -2 }, /* (155) type_name ::= BIGINT UNSIGNED */
  {  285,   -1 }, /* (156) type_name ::= JSON */
  {  285,   -4 }, /* (157) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  285,   -1 }, /* (158) type_name ::= MEDIUMBLOB */
  {  285,   -1 }, /* (159) type_name ::= BLOB */
  {  285,   -4 }, /* (160) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  285,   -1 }, /* (161) type_name ::= DECIMAL */
  {  285,   -4 }, /* (162) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  285,   -6 }, /* (163) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  277,    0 }, /* (164) tags_def_opt ::= */
  {  277,   -1 }, /* (165) tags_def_opt ::= tags_def */
  {  280,   -4 }, /* (166) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  278,    0 }, /* (167) table_options ::= */
  {  278,   -3 }, /* (168) table_options ::= table_options COMMENT NK_STRING */
  {  278,   -3 }, /* (169) table_options ::= table_options MAX_DELAY duration_list */
  {  278,   -3 }, /* (170) table_options ::= table_options WATERMARK duration_list */
  {  278,   -5 }, /* (171) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  278,   -3 }, /* (172) table_options ::= table_options TTL NK_INTEGER */
  {  278,   -5 }, /* (173) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  283,   -1 }, /* (174) alter_table_options ::= alter_table_option */
  {  283,   -2 }, /* (175) alter_table_options ::= alter_table_options alter_table_option */
  {  296,   -2 }, /* (176) alter_table_option ::= COMMENT NK_STRING */
  {  296,   -2 }, /* (177) alter_table_option ::= TTL NK_INTEGER */
  {  294,   -1 }, /* (178) duration_list ::= duration_literal */
  {  294,   -3 }, /* (179) duration_list ::= duration_list NK_COMMA duration_literal */
  {  295,   -1 }, /* (180) rollup_func_list ::= rollup_func_name */
  {  295,   -3 }, /* (181) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  298,   -1 }, /* (182) rollup_func_name ::= function_name */
  {  298,   -1 }, /* (183) rollup_func_name ::= FIRST */
  {  298,   -1 }, /* (184) rollup_func_name ::= LAST */
  {  291,   -1 }, /* (185) col_name_list ::= col_name */
  {  291,   -3 }, /* (186) col_name_list ::= col_name_list NK_COMMA col_name */
  {  300,   -1 }, /* (187) col_name ::= column_name */
  {  253,   -2 }, /* (188) cmd ::= SHOW DNODES */
  {  253,   -2 }, /* (189) cmd ::= SHOW USERS */
  {  253,   -2 }, /* (190) cmd ::= SHOW DATABASES */
  {  253,   -4 }, /* (191) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  253,   -4 }, /* (192) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  253,   -3 }, /* (193) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  253,   -2 }, /* (194) cmd ::= SHOW MNODES */
  {  253,   -2 }, /* (195) cmd ::= SHOW MODULES */
  {  253,   -2 }, /* (196) cmd ::= SHOW QNODES */
  {  253,   -2 }, /* (197) cmd ::= SHOW FUNCTIONS */
  {  253,   -5 }, /* (198) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  253,   -2 }, /* (199) cmd ::= SHOW STREAMS */
  {  253,   -2 }, /* (200) cmd ::= SHOW ACCOUNTS */
  {  253,   -2 }, /* (201) cmd ::= SHOW APPS */
  {  253,   -2 }, /* (202) cmd ::= SHOW CONNECTIONS */
  {  253,   -2 }, /* (203) cmd ::= SHOW LICENCE */
  {  253,   -2 }, /* (204) cmd ::= SHOW GRANTS */
  {  253,   -4 }, /* (205) cmd ::= SHOW CREATE DATABASE db_name */
  {  253,   -4 }, /* (206) cmd ::= SHOW CREATE TABLE full_table_name */
  {  253,   -4 }, /* (207) cmd ::= SHOW CREATE STABLE full_table_name */
  {  253,   -2 }, /* (208) cmd ::= SHOW QUERIES */
  {  253,   -2 }, /* (209) cmd ::= SHOW SCORES */
  {  253,   -2 }, /* (210) cmd ::= SHOW TOPICS */
  {  253,   -2 }, /* (211) cmd ::= SHOW VARIABLES */
  {  253,   -3 }, /* (212) cmd ::= SHOW LOCAL VARIABLES */
  {  253,   -4 }, /* (213) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  253,   -2 }, /* (214) cmd ::= SHOW BNODES */
  {  253,   -2 }, /* (215) cmd ::= SHOW SNODES */
  {  253,   -2 }, /* (216) cmd ::= SHOW CLUSTER */
  {  253,   -2 }, /* (217) cmd ::= SHOW TRANSACTIONS */
  {  253,   -4 }, /* (218) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  253,   -2 }, /* (219) cmd ::= SHOW CONSUMERS */
  {  253,   -2 }, /* (220) cmd ::= SHOW SUBSCRIPTIONS */
  {  301,    0 }, /* (221) db_name_cond_opt ::= */
  {  301,   -2 }, /* (222) db_name_cond_opt ::= db_name NK_DOT */
  {  302,    0 }, /* (223) like_pattern_opt ::= */
  {  302,   -2 }, /* (224) like_pattern_opt ::= LIKE NK_STRING */
  {  303,   -1 }, /* (225) table_name_cond ::= table_name */
  {  304,    0 }, /* (226) from_db_opt ::= */
  {  304,   -2 }, /* (227) from_db_opt ::= FROM db_name */
  {  253,   -8 }, /* (228) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  253,   -4 }, /* (229) cmd ::= DROP INDEX exists_opt index_name */
  {  306,  -10 }, /* (230) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  306,  -12 }, /* (231) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  307,   -1 }, /* (232) func_list ::= func */
  {  307,   -3 }, /* (233) func_list ::= func_list NK_COMMA func */
  {  310,   -4 }, /* (234) func ::= function_name NK_LP expression_list NK_RP */
  {  309,    0 }, /* (235) sma_stream_opt ::= */
  {  309,   -3 }, /* (236) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  309,   -3 }, /* (237) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  253,   -6 }, /* (238) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  253,   -7 }, /* (239) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  253,   -9 }, /* (240) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  253,   -7 }, /* (241) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  253,   -9 }, /* (242) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  253,   -4 }, /* (243) cmd ::= DROP TOPIC exists_opt topic_name */
  {  253,   -7 }, /* (244) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  253,   -2 }, /* (245) cmd ::= DESC full_table_name */
  {  253,   -2 }, /* (246) cmd ::= DESCRIBE full_table_name */
  {  253,   -3 }, /* (247) cmd ::= RESET QUERY CACHE */
  {  253,   -4 }, /* (248) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  315,    0 }, /* (249) analyze_opt ::= */
  {  315,   -1 }, /* (250) analyze_opt ::= ANALYZE */
  {  316,    0 }, /* (251) explain_options ::= */
  {  316,   -3 }, /* (252) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  316,   -3 }, /* (253) explain_options ::= explain_options RATIO NK_FLOAT */
  {  253,   -6 }, /* (254) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  253,  -10 }, /* (255) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  253,   -4 }, /* (256) cmd ::= DROP FUNCTION exists_opt function_name */
  {  317,    0 }, /* (257) agg_func_opt ::= */
  {  317,   -1 }, /* (258) agg_func_opt ::= AGGREGATE */
  {  318,    0 }, /* (259) bufsize_opt ::= */
  {  318,   -2 }, /* (260) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  253,   -8 }, /* (261) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  253,   -4 }, /* (262) cmd ::= DROP STREAM exists_opt stream_name */
  {  320,    0 }, /* (263) into_opt ::= */
  {  320,   -2 }, /* (264) into_opt ::= INTO full_table_name */
  {  311,    0 }, /* (265) stream_options ::= */
  {  311,   -3 }, /* (266) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  311,   -3 }, /* (267) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  311,   -4 }, /* (268) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  311,   -3 }, /* (269) stream_options ::= stream_options WATERMARK duration_literal */
  {  311,   -3 }, /* (270) stream_options ::= stream_options IGNORE EXPIRED */
  {  253,   -3 }, /* (271) cmd ::= KILL CONNECTION NK_INTEGER */
  {  253,   -3 }, /* (272) cmd ::= KILL QUERY NK_STRING */
  {  253,   -3 }, /* (273) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  253,   -2 }, /* (274) cmd ::= BALANCE VGROUP */
  {  253,   -4 }, /* (275) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  253,   -4 }, /* (276) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  253,   -3 }, /* (277) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  321,   -2 }, /* (278) dnode_list ::= DNODE NK_INTEGER */
  {  321,   -3 }, /* (279) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  253,   -3 }, /* (280) cmd ::= SYNCDB db_name REPLICA */
  {  253,   -4 }, /* (281) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  253,   -1 }, /* (282) cmd ::= query_expression */
  {  253,   -5 }, /* (283) cmd ::= INSERT INTO full_table_name specific_cols_opt query_expression */
  {  256,   -1 }, /* (284) literal ::= NK_INTEGER */
  {  256,   -1 }, /* (285) literal ::= NK_FLOAT */
  {  256,   -1 }, /* (286) literal ::= NK_STRING */
  {  256,   -1 }, /* (287) literal ::= NK_BOOL */
  {  256,   -2 }, /* (288) literal ::= TIMESTAMP NK_STRING */
  {  256,   -1 }, /* (289) literal ::= duration_literal */
  {  256,   -1 }, /* (290) literal ::= NULL */
  {  256,   -1 }, /* (291) literal ::= NK_QUESTION */
  {  297,   -1 }, /* (292) duration_literal ::= NK_VARIABLE */
  {  323,   -1 }, /* (293) signed ::= NK_INTEGER */
  {  323,   -2 }, /* (294) signed ::= NK_PLUS NK_INTEGER */
  {  323,   -2 }, /* (295) signed ::= NK_MINUS NK_INTEGER */
  {  323,   -1 }, /* (296) signed ::= NK_FLOAT */
  {  323,   -2 }, /* (297) signed ::= NK_PLUS NK_FLOAT */
  {  323,   -2 }, /* (298) signed ::= NK_MINUS NK_FLOAT */
  {  286,   -1 }, /* (299) signed_literal ::= signed */
  {  286,   -1 }, /* (300) signed_literal ::= NK_STRING */
  {  286,   -1 }, /* (301) signed_literal ::= NK_BOOL */
  {  286,   -2 }, /* (302) signed_literal ::= TIMESTAMP NK_STRING */
  {  286,   -1 }, /* (303) signed_literal ::= duration_literal */
  {  286,   -1 }, /* (304) signed_literal ::= NULL */
  {  286,   -1 }, /* (305) signed_literal ::= literal_func */
  {  325,   -1 }, /* (306) literal_list ::= signed_literal */
  {  325,   -3 }, /* (307) literal_list ::= literal_list NK_COMMA signed_literal */
  {  264,   -1 }, /* (308) db_name ::= NK_ID */
  {  292,   -1 }, /* (309) table_name ::= NK_ID */
  {  284,   -1 }, /* (310) column_name ::= NK_ID */
  {  299,   -1 }, /* (311) function_name ::= NK_ID */
  {  326,   -1 }, /* (312) table_alias ::= NK_ID */
  {  327,   -1 }, /* (313) column_alias ::= NK_ID */
  {  258,   -1 }, /* (314) user_name ::= NK_ID */
  {  305,   -1 }, /* (315) index_name ::= NK_ID */
  {  312,   -1 }, /* (316) topic_name ::= NK_ID */
  {  319,   -1 }, /* (317) stream_name ::= NK_ID */
  {  314,   -1 }, /* (318) cgroup_name ::= NK_ID */
  {  328,   -1 }, /* (319) expression ::= literal */
  {  328,   -1 }, /* (320) expression ::= pseudo_column */
  {  328,   -1 }, /* (321) expression ::= column_reference */
  {  328,   -1 }, /* (322) expression ::= function_expression */
  {  328,   -1 }, /* (323) expression ::= subquery */
  {  328,   -3 }, /* (324) expression ::= NK_LP expression NK_RP */
  {  328,   -2 }, /* (325) expression ::= NK_PLUS expression */
  {  328,   -2 }, /* (326) expression ::= NK_MINUS expression */
  {  328,   -3 }, /* (327) expression ::= expression NK_PLUS expression */
  {  328,   -3 }, /* (328) expression ::= expression NK_MINUS expression */
  {  328,   -3 }, /* (329) expression ::= expression NK_STAR expression */
  {  328,   -3 }, /* (330) expression ::= expression NK_SLASH expression */
  {  328,   -3 }, /* (331) expression ::= expression NK_REM expression */
  {  328,   -3 }, /* (332) expression ::= column_reference NK_ARROW NK_STRING */
  {  328,   -3 }, /* (333) expression ::= expression NK_BITAND expression */
  {  328,   -3 }, /* (334) expression ::= expression NK_BITOR expression */
  {  289,   -1 }, /* (335) expression_list ::= expression */
  {  289,   -3 }, /* (336) expression_list ::= expression_list NK_COMMA expression */
  {  330,   -1 }, /* (337) column_reference ::= column_name */
  {  330,   -3 }, /* (338) column_reference ::= table_name NK_DOT column_name */
  {  329,   -1 }, /* (339) pseudo_column ::= ROWTS */
  {  329,   -1 }, /* (340) pseudo_column ::= TBNAME */
  {  329,   -3 }, /* (341) pseudo_column ::= table_name NK_DOT TBNAME */
  {  329,   -1 }, /* (342) pseudo_column ::= QSTARTTS */
  {  329,   -1 }, /* (343) pseudo_column ::= QENDTS */
  {  329,   -1 }, /* (344) pseudo_column ::= WSTARTTS */
  {  329,   -1 }, /* (345) pseudo_column ::= WENDTS */
  {  329,   -1 }, /* (346) pseudo_column ::= WDURATION */
  {  331,   -4 }, /* (347) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  331,   -4 }, /* (348) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  331,   -6 }, /* (349) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  331,   -1 }, /* (350) function_expression ::= literal_func */
  {  324,   -3 }, /* (351) literal_func ::= noarg_func NK_LP NK_RP */
  {  324,   -1 }, /* (352) literal_func ::= NOW */
  {  335,   -1 }, /* (353) noarg_func ::= NOW */
  {  335,   -1 }, /* (354) noarg_func ::= TODAY */
  {  335,   -1 }, /* (355) noarg_func ::= TIMEZONE */
  {  335,   -1 }, /* (356) noarg_func ::= DATABASE */
  {  335,   -1 }, /* (357) noarg_func ::= CLIENT_VERSION */
  {  335,   -1 }, /* (358) noarg_func ::= SERVER_VERSION */
  {  335,   -1 }, /* (359) noarg_func ::= SERVER_STATUS */
  {  335,   -1 }, /* (360) noarg_func ::= CURRENT_USER */
  {  335,   -1 }, /* (361) noarg_func ::= USER */
  {  333,   -1 }, /* (362) star_func ::= COUNT */
  {  333,   -1 }, /* (363) star_func ::= FIRST */
  {  333,   -1 }, /* (364) star_func ::= LAST */
  {  333,   -1 }, /* (365) star_func ::= LAST_ROW */
  {  334,   -1 }, /* (366) star_func_para_list ::= NK_STAR */
  {  334,   -1 }, /* (367) star_func_para_list ::= other_para_list */
  {  336,   -1 }, /* (368) other_para_list ::= star_func_para */
  {  336,   -3 }, /* (369) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  337,   -1 }, /* (370) star_func_para ::= expression */
  {  337,   -3 }, /* (371) star_func_para ::= table_name NK_DOT NK_STAR */
  {  338,   -3 }, /* (372) predicate ::= expression compare_op expression */
  {  338,   -5 }, /* (373) predicate ::= expression BETWEEN expression AND expression */
  {  338,   -6 }, /* (374) predicate ::= expression NOT BETWEEN expression AND expression */
  {  338,   -3 }, /* (375) predicate ::= expression IS NULL */
  {  338,   -4 }, /* (376) predicate ::= expression IS NOT NULL */
  {  338,   -3 }, /* (377) predicate ::= expression in_op in_predicate_value */
  {  339,   -1 }, /* (378) compare_op ::= NK_LT */
  {  339,   -1 }, /* (379) compare_op ::= NK_GT */
  {  339,   -1 }, /* (380) compare_op ::= NK_LE */
  {  339,   -1 }, /* (381) compare_op ::= NK_GE */
  {  339,   -1 }, /* (382) compare_op ::= NK_NE */
  {  339,   -1 }, /* (383) compare_op ::= NK_EQ */
  {  339,   -1 }, /* (384) compare_op ::= LIKE */
  {  339,   -2 }, /* (385) compare_op ::= NOT LIKE */
  {  339,   -1 }, /* (386) compare_op ::= MATCH */
  {  339,   -1 }, /* (387) compare_op ::= NMATCH */
  {  339,   -1 }, /* (388) compare_op ::= CONTAINS */
  {  340,   -1 }, /* (389) in_op ::= IN */
  {  340,   -2 }, /* (390) in_op ::= NOT IN */
  {  341,   -3 }, /* (391) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  342,   -1 }, /* (392) boolean_value_expression ::= boolean_primary */
  {  342,   -2 }, /* (393) boolean_value_expression ::= NOT boolean_primary */
  {  342,   -3 }, /* (394) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  342,   -3 }, /* (395) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  343,   -1 }, /* (396) boolean_primary ::= predicate */
  {  343,   -3 }, /* (397) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  344,   -1 }, /* (398) common_expression ::= expression */
  {  344,   -1 }, /* (399) common_expression ::= boolean_value_expression */
  {  345,    0 }, /* (400) from_clause_opt ::= */
  {  345,   -2 }, /* (401) from_clause_opt ::= FROM table_reference_list */
  {  346,   -1 }, /* (402) table_reference_list ::= table_reference */
  {  346,   -3 }, /* (403) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  347,   -1 }, /* (404) table_reference ::= table_primary */
  {  347,   -1 }, /* (405) table_reference ::= joined_table */
  {  348,   -2 }, /* (406) table_primary ::= table_name alias_opt */
  {  348,   -4 }, /* (407) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  348,   -2 }, /* (408) table_primary ::= subquery alias_opt */
  {  348,   -1 }, /* (409) table_primary ::= parenthesized_joined_table */
  {  350,    0 }, /* (410) alias_opt ::= */
  {  350,   -1 }, /* (411) alias_opt ::= table_alias */
  {  350,   -2 }, /* (412) alias_opt ::= AS table_alias */
  {  351,   -3 }, /* (413) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  351,   -3 }, /* (414) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  349,   -6 }, /* (415) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  352,    0 }, /* (416) join_type ::= */
  {  352,   -1 }, /* (417) join_type ::= INNER */
  {  354,  -12 }, /* (418) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  355,    0 }, /* (419) set_quantifier_opt ::= */
  {  355,   -1 }, /* (420) set_quantifier_opt ::= DISTINCT */
  {  355,   -1 }, /* (421) set_quantifier_opt ::= ALL */
  {  356,   -1 }, /* (422) select_list ::= select_item */
  {  356,   -3 }, /* (423) select_list ::= select_list NK_COMMA select_item */
  {  364,   -1 }, /* (424) select_item ::= NK_STAR */
  {  364,   -1 }, /* (425) select_item ::= common_expression */
  {  364,   -2 }, /* (426) select_item ::= common_expression column_alias */
  {  364,   -3 }, /* (427) select_item ::= common_expression AS column_alias */
  {  364,   -3 }, /* (428) select_item ::= table_name NK_DOT NK_STAR */
  {  322,    0 }, /* (429) where_clause_opt ::= */
  {  322,   -2 }, /* (430) where_clause_opt ::= WHERE search_condition */
  {  357,    0 }, /* (431) partition_by_clause_opt ::= */
  {  357,   -3 }, /* (432) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  361,    0 }, /* (433) twindow_clause_opt ::= */
  {  361,   -6 }, /* (434) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  361,   -4 }, /* (435) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  361,   -6 }, /* (436) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  361,   -8 }, /* (437) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  308,    0 }, /* (438) sliding_opt ::= */
  {  308,   -4 }, /* (439) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  360,    0 }, /* (440) fill_opt ::= */
  {  360,   -4 }, /* (441) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  360,   -6 }, /* (442) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  365,   -1 }, /* (443) fill_mode ::= NONE */
  {  365,   -1 }, /* (444) fill_mode ::= PREV */
  {  365,   -1 }, /* (445) fill_mode ::= NULL */
  {  365,   -1 }, /* (446) fill_mode ::= LINEAR */
  {  365,   -1 }, /* (447) fill_mode ::= NEXT */
  {  362,    0 }, /* (448) group_by_clause_opt ::= */
  {  362,   -3 }, /* (449) group_by_clause_opt ::= GROUP BY group_by_list */
  {  366,   -1 }, /* (450) group_by_list ::= expression */
  {  366,   -3 }, /* (451) group_by_list ::= group_by_list NK_COMMA expression */
  {  363,    0 }, /* (452) having_clause_opt ::= */
  {  363,   -2 }, /* (453) having_clause_opt ::= HAVING search_condition */
  {  358,    0 }, /* (454) range_opt ::= */
  {  358,   -6 }, /* (455) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  359,    0 }, /* (456) every_opt ::= */
  {  359,   -4 }, /* (457) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  313,   -4 }, /* (458) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  367,   -1 }, /* (459) query_expression_body ::= query_primary */
  {  367,   -4 }, /* (460) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  367,   -3 }, /* (461) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  371,   -1 }, /* (462) query_primary ::= query_specification */
  {  371,   -6 }, /* (463) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  368,    0 }, /* (464) order_by_clause_opt ::= */
  {  368,   -3 }, /* (465) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  369,    0 }, /* (466) slimit_clause_opt ::= */
  {  369,   -2 }, /* (467) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  369,   -4 }, /* (468) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  369,   -4 }, /* (469) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  370,    0 }, /* (470) limit_clause_opt ::= */
  {  370,   -2 }, /* (471) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  370,   -4 }, /* (472) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  370,   -4 }, /* (473) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  332,   -3 }, /* (474) subquery ::= NK_LP query_expression NK_RP */
  {  353,   -1 }, /* (475) search_condition ::= common_expression */
  {  372,   -1 }, /* (476) sort_specification_list ::= sort_specification */
  {  372,   -3 }, /* (477) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  373,   -3 }, /* (478) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  374,    0 }, /* (479) ordering_specification_opt ::= */
  {  374,   -1 }, /* (480) ordering_specification_opt ::= ASC */
  {  374,   -1 }, /* (481) ordering_specification_opt ::= DESC */
  {  375,    0 }, /* (482) null_ordering_opt ::= */
  {  375,   -2 }, /* (483) null_ordering_opt ::= NULLS FIRST */
  {  375,   -2 }, /* (484) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,254,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,255,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,254,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,256,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,257,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,255,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,257,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,256,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy401, &yymsp[-1].minor.yy0, yymsp[0].minor.yy695); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy401, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy401, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy401, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy401); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy695 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy695 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy525, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy401); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy525, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy401); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy525 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy525 = yymsp[0].minor.yy525; }
  yymsp[0].minor.yy525 = yylhsminor.yy525;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy525 = yymsp[-2].minor.yy525 | yymsp[0].minor.yy525; }
  yymsp[-2].minor.yy525 = yylhsminor.yy525;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy525 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy525 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy401 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy401 = yylhsminor.yy401;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy401 = yymsp[-2].minor.yy401; }
  yymsp[-2].minor.yy401 = yylhsminor.yy401;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy401, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy401); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 308: /* db_name ::= NK_ID */ yytestcase(yyruleno==308);
      case 309: /* table_name ::= NK_ID */ yytestcase(yyruleno==309);
      case 310: /* column_name ::= NK_ID */ yytestcase(yyruleno==310);
      case 311: /* function_name ::= NK_ID */ yytestcase(yyruleno==311);
      case 312: /* table_alias ::= NK_ID */ yytestcase(yyruleno==312);
      case 313: /* column_alias ::= NK_ID */ yytestcase(yyruleno==313);
      case 314: /* user_name ::= NK_ID */ yytestcase(yyruleno==314);
      case 315: /* index_name ::= NK_ID */ yytestcase(yyruleno==315);
      case 316: /* topic_name ::= NK_ID */ yytestcase(yyruleno==316);
      case 317: /* stream_name ::= NK_ID */ yytestcase(yyruleno==317);
      case 318: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==318);
      case 353: /* noarg_func ::= NOW */ yytestcase(yyruleno==353);
      case 354: /* noarg_func ::= TODAY */ yytestcase(yyruleno==354);
      case 355: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==355);
      case 356: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==356);
      case 357: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==357);
      case 358: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==358);
      case 359: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==359);
      case 360: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==360);
      case 361: /* noarg_func ::= USER */ yytestcase(yyruleno==361);
      case 362: /* star_func ::= COUNT */ yytestcase(yyruleno==362);
      case 363: /* star_func ::= FIRST */ yytestcase(yyruleno==363);
      case 364: /* star_func ::= LAST */ yytestcase(yyruleno==364);
      case 365: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==365);
{ yylhsminor.yy401 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy401 = yylhsminor.yy401;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy89, &yymsp[-1].minor.yy401, yymsp[0].minor.yy248); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy401); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy401); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy401, yymsp[0].minor.yy248); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy401); }
        break;
      case 67: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy89 = true; }
        break;
      case 68: /* not_exists_opt ::= */
      case 70: /* exists_opt ::= */ yytestcase(yyruleno==70);
      case 249: /* analyze_opt ::= */ yytestcase(yyruleno==249);
      case 257: /* agg_func_opt ::= */ yytestcase(yyruleno==257);
      case 419: /* set_quantifier_opt ::= */ yytestcase(yyruleno==419);
{ yymsp[1].minor.yy89 = false; }
        break;
      case 69: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy89 = true; }
        break;
      case 71: /* db_options ::= */
{ yymsp[1].minor.yy248 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 72: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 73: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 74: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 75: /* db_options ::= db_options DURATION NK_INTEGER */
      case 76: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==76);
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 77: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 78: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 79: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 80: /* db_options ::= db_options KEEP integer_list */
      case 81: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==81);
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_KEEP, yymsp[0].minor.yy552); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 82: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 83: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 84: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 85: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 86: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 87: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 88: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 89: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 90: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_RETENTIONS, yymsp[0].minor.yy552); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 91: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy248 = setDatabaseOption(pCxt, yymsp[-2].minor.yy248, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 92: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy248 = createAlterDatabaseOptions(pCxt); yylhsminor.yy248 = setAlterDatabaseOption(pCxt, yylhsminor.yy248, &yymsp[0].minor.yy301); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 93: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy248 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy248, &yymsp[0].minor.yy301); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 94: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 95: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= KEEP integer_list */
      case 98: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==98);
{ yymsp[-1].minor.yy301.type = DB_OPTION_KEEP; yymsp[-1].minor.yy301.pList = yymsp[0].minor.yy552; }
        break;
      case 99: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_PAGES; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 100: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 101: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_STRICT; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 102: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_WAL; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 103: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy552 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy552 = yylhsminor.yy552;
        break;
      case 104: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 279: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==279);
{ yylhsminor.yy552 = addNodeToList(pCxt, yymsp[-2].minor.yy552, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy552 = yylhsminor.yy552;
        break;
      case 105: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy552 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy552 = yylhsminor.yy552;
        break;
      case 106: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy552 = addNodeToList(pCxt, yymsp[-2].minor.yy552, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy552 = yylhsminor.yy552;
        break;
      case 107: /* retention_list ::= retention */
      case 127: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==127);
      case 130: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==130);
      case 137: /* column_def_list ::= column_def */ yytestcase(yyruleno==137);
      case 180: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==180);
      case 185: /* col_name_list ::= col_name */ yytestcase(yyruleno==185);
      case 232: /* func_list ::= func */ yytestcase(yyruleno==232);
      case 306: /* literal_list ::= signed_literal */ yytestcase(yyruleno==306);
      case 368: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==368);
      case 422: /* select_list ::= select_item */ yytestcase(yyruleno==422);
      case 476: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==476);
{ yylhsminor.yy552 = createNodeList(pCxt, yymsp[0].minor.yy248); }
  yymsp[0].minor.yy552 = yylhsminor.yy552;
        break;
      case 108: /* retention_list ::= retention_list NK_COMMA retention */
      case 138: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==138);
      case 181: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==181);
      case 186: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==186);
      case 233: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==233);
      case 307: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==307);
      case 369: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==369);
      case 423: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==423);
      case 477: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==477);
{ yylhsminor.yy552 = addNodeToList(pCxt, yymsp[-2].minor.yy552, yymsp[0].minor.yy248); }
  yymsp[-2].minor.yy552 = yylhsminor.yy552;
        break;
      case 109: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy248 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 110: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 112: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==112);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy89, yymsp[-5].minor.yy248, yymsp[-3].minor.yy552, yymsp[-1].minor.yy552, yymsp[0].minor.yy248); }
        break;
      case 111: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy552); }
        break;
      case 113: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy552); }
        break;
      case 114: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy89, yymsp[0].minor.yy248); }
        break;
      case 115: /* cmd ::= ALTER TABLE alter_table_clause */
      case 282: /* cmd ::= query_expression */ yytestcase(yyruleno==282);
{ pCxt->pRootNode = yymsp[0].minor.yy248; }
        break;
      case 116: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy248); }
        break;
      case 117: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy248 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy248, yymsp[0].minor.yy248); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 118: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy248 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy248, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy401, yymsp[0].minor.yy224); }
  yymsp[-4].minor.yy248 = yylhsminor.yy248;
        break;
      case 119: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy248 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy248, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy401); }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 120: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy248 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy248, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy401, yymsp[0].minor.yy224); }
  yymsp[-4].minor.yy248 = yylhsminor.yy248;
        break;
      case 121: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy248 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy248, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy401, &yymsp[0].minor.yy401); }
  yymsp[-4].minor.yy248 = yylhsminor.yy248;
        break;
      case 122: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy248 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy248, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy401, yymsp[0].minor.yy224); }
  yymsp[-4].minor.yy248 = yylhsminor.yy248;
        break;
      case 123: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy248 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy248, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy401); }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 124: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy248 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy248, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy401, yymsp[0].minor.yy224); }
  yymsp[-4].minor.yy248 = yylhsminor.yy248;
        break;
      case 125: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy248 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy248, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy401, &yymsp[0].minor.yy401); }
  yymsp[-4].minor.yy248 = yylhsminor.yy248;
        break;
      case 126: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy248 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy248, &yymsp[-2].minor.yy401, yymsp[0].minor.yy248); }
  yymsp[-5].minor.yy248 = yylhsminor.yy248;
        break;
      case 128: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 131: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==131);
{ yylhsminor.yy552 = addNodeToList(pCxt, yymsp[-1].minor.yy552, yymsp[0].minor.yy248); }
  yymsp[-1].minor.yy552 = yylhsminor.yy552;
        break;
      case 129: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy248 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy89, yymsp[-8].minor.yy248, yymsp[-6].minor.yy248, yymsp[-5].minor.yy552, yymsp[-2].minor.yy552, yymsp[0].minor.yy248); }
  yymsp[-9].minor.yy248 = yylhsminor.yy248;
        break;
      case 132: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy248 = createDropTableClause(pCxt, yymsp[-1].minor.yy89, yymsp[0].minor.yy248); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 133: /* specific_cols_opt ::= */
      case 164: /* tags_def_opt ::= */ yytestcase(yyruleno==164);
      case 431: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==431);
      case 448: /* group_by_clause_opt ::= */ yytestcase(yyruleno==448);
      case 464: /* order_by_clause_opt ::= */ yytestcase(yyruleno==464);
{ yymsp[1].minor.yy552 = NULL; }
        break;
      case 134: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy552 = yymsp[-1].minor.yy552; }
        break;
      case 135: /* full_table_name ::= table_name */
{ yylhsminor.yy248 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy401, NULL); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 136: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy248 = createRealTableNode(pCxt, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy401, NULL); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 139: /* column_def ::= column_name type_name */
{ yylhsminor.yy248 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy401, yymsp[0].minor.yy224, NULL); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 140: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy248 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy401, yymsp[-2].minor.yy224, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 141: /* type_name ::= BOOL */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 142: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 143: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 144: /* type_name ::= INT */
      case 145: /* type_name ::= INTEGER */ yytestcase(yyruleno==145);
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 146: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 147: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 148: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 149: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy224 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 150: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 151: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy224 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 152: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy224 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 153: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy224 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 154: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy224 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 155: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy224 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 156: /* type_name ::= JSON */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 157: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy224 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 158: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 159: /* type_name ::= BLOB */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 160: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy224 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 161: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy224 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 162: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy224 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 163: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy224 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 165: /* tags_def_opt ::= tags_def */
      case 367: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==367);
{ yylhsminor.yy552 = yymsp[0].minor.yy552; }
  yymsp[0].minor.yy552 = yylhsminor.yy552;
        break;
      case 166: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy552 = yymsp[-1].minor.yy552; }
        break;
      case 167: /* table_options ::= */
{ yymsp[1].minor.yy248 = createDefaultTableOptions(pCxt); }
        break;
      case 168: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy248 = setTableOption(pCxt, yymsp[-2].minor.yy248, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 169: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy248 = setTableOption(pCxt, yymsp[-2].minor.yy248, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy552); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 170: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy248 = setTableOption(pCxt, yymsp[-2].minor.yy248, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy552); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 171: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy248 = setTableOption(pCxt, yymsp[-4].minor.yy248, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy552); }
  yymsp[-4].minor.yy248 = yylhsminor.yy248;
        break;
      case 172: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy248 = setTableOption(pCxt, yymsp[-2].minor.yy248, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 173: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy248 = setTableOption(pCxt, yymsp[-4].minor.yy248, TABLE_OPTION_SMA, yymsp[-1].minor.yy552); }
  yymsp[-4].minor.yy248 = yylhsminor.yy248;
        break;
      case 174: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy248 = createAlterTableOptions(pCxt); yylhsminor.yy248 = setTableOption(pCxt, yylhsminor.yy248, yymsp[0].minor.yy301.type, &yymsp[0].minor.yy301.val); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 175: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy248 = setTableOption(pCxt, yymsp[-1].minor.yy248, yymsp[0].minor.yy301.type, &yymsp[0].minor.yy301.val); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 176: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy301.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 177: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy301.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 178: /* duration_list ::= duration_literal */
      case 335: /* expression_list ::= expression */ yytestcase(yyruleno==335);
{ yylhsminor.yy552 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy248)); }
  yymsp[0].minor.yy552 = yylhsminor.yy552;
        break;
      case 179: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 336: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==336);
{ yylhsminor.yy552 = addNodeToList(pCxt, yymsp[-2].minor.yy552, releaseRawExprNode(pCxt, yymsp[0].minor.yy248)); }
  yymsp[-2].minor.yy552 = yylhsminor.yy552;
        break;
      case 182: /* rollup_func_name ::= function_name */
{ yylhsminor.yy248 = createFunctionNode(pCxt, &yymsp[0].minor.yy401, NULL); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 183: /* rollup_func_name ::= FIRST */
      case 184: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==184);
{ yylhsminor.yy248 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 187: /* col_name ::= column_name */
{ yylhsminor.yy248 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy401); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 188: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 189: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 190: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 191: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy248, yymsp[0].minor.yy248, OP_TYPE_LIKE); }
        break;
      case 192: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy248, yymsp[0].minor.yy248, OP_TYPE_LIKE); }
        break;
      case 193: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy248, NULL, OP_TYPE_LIKE); }
        break;
      case 194: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 195: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 196: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 197: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 198: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy248, yymsp[-1].minor.yy248, OP_TYPE_EQUAL); }
        break;
      case 199: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 200: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 201: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 202: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 203: /* cmd ::= SHOW LICENCE */
      case 204: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==204);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT); }
        break;
      case 205: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy401); }
        break;
      case 206: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy248); }
        break;
      case 207: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy248); }
        break;
      case 208: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 209: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 210: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 211: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 212: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 213: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 214: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 217: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 218: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy248); }
        break;
      case 219: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 220: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 221: /* db_name_cond_opt ::= */
      case 226: /* from_db_opt ::= */ yytestcase(yyruleno==226);
{ yymsp[1].minor.yy248 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 222: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy401); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 223: /* like_pattern_opt ::= */
      case 263: /* into_opt ::= */ yytestcase(yyruleno==263);
      case 400: /* from_clause_opt ::= */ yytestcase(yyruleno==400);
      case 429: /* where_clause_opt ::= */ yytestcase(yyruleno==429);
      case 433: /* twindow_clause_opt ::= */ yytestcase(yyruleno==433);
      case 438: /* sliding_opt ::= */ yytestcase(yyruleno==438);
      case 440: /* fill_opt ::= */ yytestcase(yyruleno==440);
      case 452: /* having_clause_opt ::= */ yytestcase(yyruleno==452);
      case 454: /* range_opt ::= */ yytestcase(yyruleno==454);
      case 456: /* every_opt ::= */ yytestcase(yyruleno==456);
      case 466: /* slimit_clause_opt ::= */ yytestcase(yyruleno==466);
      case 470: /* limit_clause_opt ::= */ yytestcase(yyruleno==470);
{ yymsp[1].minor.yy248 = NULL; }
        break;
      case 224: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 225: /* table_name_cond ::= table_name */
{ yylhsminor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy401); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 227: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy401); }
        break;
      case 228: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy89, &yymsp[-3].minor.yy401, &yymsp[-1].minor.yy401, NULL, yymsp[0].minor.yy248); }
        break;
      case 229: /* cmd ::= DROP INDEX exists_opt index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy401); }
        break;
      case 230: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy248 = createIndexOption(pCxt, yymsp[-7].minor.yy552, releaseRawExprNode(pCxt, yymsp[-3].minor.yy248), NULL, yymsp[-1].minor.yy248, yymsp[0].minor.yy248); }
        break;
      case 231: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy248 = createIndexOption(pCxt, yymsp[-9].minor.yy552, releaseRawExprNode(pCxt, yymsp[-5].minor.yy248), releaseRawExprNode(pCxt, yymsp[-3].minor.yy248), yymsp[-1].minor.yy248, yymsp[0].minor.yy248); }
        break;
      case 234: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy248 = createFunctionNode(pCxt, &yymsp[-3].minor.yy401, yymsp[-1].minor.yy552); }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 235: /* sma_stream_opt ::= */
      case 265: /* stream_options ::= */ yytestcase(yyruleno==265);
{ yymsp[1].minor.yy248 = createStreamOptions(pCxt); }
        break;
      case 236: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 269: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==269);
{ ((SStreamOptions*)yymsp[-2].minor.yy248)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy248); yylhsminor.yy248 = yymsp[-2].minor.yy248; }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 237: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy248)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy248); yylhsminor.yy248 = yymsp[-2].minor.yy248; }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 238: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy89, &yymsp[-2].minor.yy401, yymsp[0].minor.yy248); }
        break;
      case 239: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy89, &yymsp[-3].minor.yy401, &yymsp[0].minor.yy401, false); }
        break;
      case 240: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy89, &yymsp[-5].minor.yy401, &yymsp[0].minor.yy401, true); }
        break;
      case 241: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy89, &yymsp[-3].minor.yy401, yymsp[0].minor.yy248, false); }
        break;
      case 242: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy89, &yymsp[-5].minor.yy401, yymsp[0].minor.yy248, true); }
        break;
      case 243: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy401); }
        break;
      case 244: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy89, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy401); }
        break;
      case 245: /* cmd ::= DESC full_table_name */
      case 246: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==246);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy248); }
        break;
      case 247: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 248: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy89, yymsp[-1].minor.yy248, yymsp[0].minor.yy248); }
        break;
      case 250: /* analyze_opt ::= ANALYZE */
      case 258: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==258);
      case 420: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==420);
{ yymsp[0].minor.yy89 = true; }
        break;
      case 251: /* explain_options ::= */
{ yymsp[1].minor.yy248 = createDefaultExplainOptions(pCxt); }
        break;
      case 252: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy248 = setExplainVerbose(pCxt, yymsp[-2].minor.yy248, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 253: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy248 = setExplainRatio(pCxt, yymsp[-2].minor.yy248, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 254: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy552); }
        break;
      case 255: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy89, yymsp[-8].minor.yy89, &yymsp[-5].minor.yy401, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy224, yymsp[0].minor.yy228); }
        break;
      case 256: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy401); }
        break;
      case 259: /* bufsize_opt ::= */
{ yymsp[1].minor.yy228 = 0; }
        break;
      case 260: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy228 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 261: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy89, &yymsp[-4].minor.yy401, yymsp[-2].minor.yy248, yymsp[-3].minor.yy248, yymsp[0].minor.yy248); }
        break;
      case 262: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy401); }
        break;
      case 264: /* into_opt ::= INTO full_table_name */
      case 401: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==401);
      case 430: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==430);
      case 453: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==453);
{ yymsp[-1].minor.yy248 = yymsp[0].minor.yy248; }
        break;
      case 266: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy248)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy248 = yymsp[-2].minor.yy248; }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 267: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy248)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy248 = yymsp[-2].minor.yy248; }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 268: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy248)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy248)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy248); yylhsminor.yy248 = yymsp[-3].minor.yy248; }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 270: /* stream_options ::= stream_options IGNORE EXPIRED */
{ ((SStreamOptions*)yymsp[-2].minor.yy248)->ignoreExpired = true; yylhsminor.yy248 = yymsp[-2].minor.yy248; }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 271: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 272: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 273: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 274: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 275: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 276: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy552); }
        break;
      case 277: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 278: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy552 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 280: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy401); }
        break;
      case 281: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy248, yymsp[0].minor.yy248); }
        break;
      case 283: /* cmd ::= INSERT INTO full_table_name specific_cols_opt query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-2].minor.yy248, yymsp[-1].minor.yy552, yymsp[0].minor.yy248); }
        break;
      case 284: /* literal ::= NK_INTEGER */
{ yylhsminor.yy248 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 285: /* literal ::= NK_FLOAT */
{ yylhsminor.yy248 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 286: /* literal ::= NK_STRING */
{ yylhsminor.yy248 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 287: /* literal ::= NK_BOOL */
{ yylhsminor.yy248 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 288: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 289: /* literal ::= duration_literal */
      case 299: /* signed_literal ::= signed */ yytestcase(yyruleno==299);
      case 319: /* expression ::= literal */ yytestcase(yyruleno==319);
      case 320: /* expression ::= pseudo_column */ yytestcase(yyruleno==320);
      case 321: /* expression ::= column_reference */ yytestcase(yyruleno==321);
      case 322: /* expression ::= function_expression */ yytestcase(yyruleno==322);
      case 323: /* expression ::= subquery */ yytestcase(yyruleno==323);
      case 350: /* function_expression ::= literal_func */ yytestcase(yyruleno==350);
      case 392: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==392);
      case 396: /* boolean_primary ::= predicate */ yytestcase(yyruleno==396);
      case 398: /* common_expression ::= expression */ yytestcase(yyruleno==398);
      case 399: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==399);
      case 402: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==402);
      case 404: /* table_reference ::= table_primary */ yytestcase(yyruleno==404);
      case 405: /* table_reference ::= joined_table */ yytestcase(yyruleno==405);
      case 409: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==409);
      case 459: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==459);
      case 462: /* query_primary ::= query_specification */ yytestcase(yyruleno==462);
{ yylhsminor.yy248 = yymsp[0].minor.yy248; }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 290: /* literal ::= NULL */
{ yylhsminor.yy248 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 291: /* literal ::= NK_QUESTION */
{ yylhsminor.yy248 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 292: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy248 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 293: /* signed ::= NK_INTEGER */
{ yylhsminor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 294: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 295: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 296: /* signed ::= NK_FLOAT */
{ yylhsminor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 297: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 298: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 300: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 301: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 302: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 303: /* signed_literal ::= duration_literal */
      case 305: /* signed_literal ::= literal_func */ yytestcase(yyruleno==305);
      case 370: /* star_func_para ::= expression */ yytestcase(yyruleno==370);
      case 425: /* select_item ::= common_expression */ yytestcase(yyruleno==425);
      case 475: /* search_condition ::= common_expression */ yytestcase(yyruleno==475);
{ yylhsminor.yy248 = releaseRawExprNode(pCxt, yymsp[0].minor.yy248); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 304: /* signed_literal ::= NULL */
{ yylhsminor.yy248 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 324: /* expression ::= NK_LP expression NK_RP */
      case 397: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==397);
{ yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy248)); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 325: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy248));
                                                                                  }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 326: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy248), NULL));
                                                                                  }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 327: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248))); 
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 328: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248))); 
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 329: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248))); 
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 330: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248))); 
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 331: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248)));
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 332: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 333: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248)));
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 334: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248)));
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 337: /* column_reference ::= column_name */
{ yylhsminor.yy248 = createRawExprNode(pCxt, &yymsp[0].minor.yy401, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy401)); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 338: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy401, createColumnNode(pCxt, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy401)); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 339: /* pseudo_column ::= ROWTS */
      case 340: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==340);
      case 342: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==342);
      case 343: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==343);
      case 344: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==344);
      case 345: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==345);
      case 346: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==346);
      case 352: /* literal_func ::= NOW */ yytestcase(yyruleno==352);
{ yylhsminor.yy248 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 341: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy401)))); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 347: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 348: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==348);
{ yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy401, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy401, yymsp[-1].minor.yy552)); }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 349: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy248), yymsp[-1].minor.yy224)); }
  yymsp[-5].minor.yy248 = yylhsminor.yy248;
        break;
      case 351: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy401, NULL)); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 366: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy552 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy552 = yylhsminor.yy552;
        break;
      case 371: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 428: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==428);
{ yylhsminor.yy248 = createColumnNode(pCxt, &yymsp[-2].minor.yy401, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 372: /* predicate ::= expression compare_op expression */
      case 377: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==377);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy716, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248)));
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 373: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy248), releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248)));
                                                                                  }
  yymsp[-4].minor.yy248 = yylhsminor.yy248;
        break;
      case 374: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy248), releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248)));
                                                                                  }
  yymsp[-5].minor.yy248 = yylhsminor.yy248;
        break;
      case 375: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), NULL));
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 376: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy248), NULL));
                                                                                  }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 378: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy716 = OP_TYPE_LOWER_THAN; }
        break;
      case 379: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy716 = OP_TYPE_GREATER_THAN; }
        break;
      case 380: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy716 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 381: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy716 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 382: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy716 = OP_TYPE_NOT_EQUAL; }
        break;
      case 383: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy716 = OP_TYPE_EQUAL; }
        break;
      case 384: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy716 = OP_TYPE_LIKE; }
        break;
      case 385: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy716 = OP_TYPE_NOT_LIKE; }
        break;
      case 386: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy716 = OP_TYPE_MATCH; }
        break;
      case 387: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy716 = OP_TYPE_NMATCH; }
        break;
      case 388: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy716 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 389: /* in_op ::= IN */
{ yymsp[0].minor.yy716 = OP_TYPE_IN; }
        break;
      case 390: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy716 = OP_TYPE_NOT_IN; }
        break;
      case 391: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy552)); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 393: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy248), NULL));
                                                                                  }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 394: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248)));
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 395: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy248);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy248);
                                                                                    yylhsminor.yy248 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), releaseRawExprNode(pCxt, yymsp[0].minor.yy248)));
                                                                                  }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 403: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy248 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy248, yymsp[0].minor.yy248, NULL); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 406: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy248 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy401, &yymsp[0].minor.yy401); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 407: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy248 = createRealTableNode(pCxt, &yymsp[-3].minor.yy401, &yymsp[-1].minor.yy401, &yymsp[0].minor.yy401); }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 408: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy248 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy248), &yymsp[0].minor.yy401); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 410: /* alias_opt ::= */
{ yymsp[1].minor.yy401 = nil_token;  }
        break;
      case 411: /* alias_opt ::= table_alias */
{ yylhsminor.yy401 = yymsp[0].minor.yy401; }
  yymsp[0].minor.yy401 = yylhsminor.yy401;
        break;
      case 412: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy401 = yymsp[0].minor.yy401; }
        break;
      case 413: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 414: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==414);
{ yymsp[-2].minor.yy248 = yymsp[-1].minor.yy248; }
        break;
      case 415: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy248 = createJoinTableNode(pCxt, yymsp[-4].minor.yy52, yymsp[-5].minor.yy248, yymsp[-2].minor.yy248, yymsp[0].minor.yy248); }
  yymsp[-5].minor.yy248 = yylhsminor.yy248;
        break;
      case 416: /* join_type ::= */
{ yymsp[1].minor.yy52 = JOIN_TYPE_INNER; }
        break;
      case 417: /* join_type ::= INNER */
{ yymsp[0].minor.yy52 = JOIN_TYPE_INNER; }
        break;
      case 418: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy248 = createSelectStmt(pCxt, yymsp[-10].minor.yy89, yymsp[-9].minor.yy552, yymsp[-8].minor.yy248);
                                                                                    yymsp[-11].minor.yy248 = addWhereClause(pCxt, yymsp[-11].minor.yy248, yymsp[-7].minor.yy248);
                                                                                    yymsp[-11].minor.yy248 = addPartitionByClause(pCxt, yymsp[-11].minor.yy248, yymsp[-6].minor.yy552);
                                                                                    yymsp[-11].minor.yy248 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy248, yymsp[-2].minor.yy248);
                                                                                    yymsp[-11].minor.yy248 = addGroupByClause(pCxt, yymsp[-11].minor.yy248, yymsp[-1].minor.yy552);
                                                                                    yymsp[-11].minor.yy248 = addHavingClause(pCxt, yymsp[-11].minor.yy248, yymsp[0].minor.yy248);
                                                                                    yymsp[-11].minor.yy248 = addRangeClause(pCxt, yymsp[-11].minor.yy248, yymsp[-5].minor.yy248);
                                                                                    yymsp[-11].minor.yy248 = addEveryClause(pCxt, yymsp[-11].minor.yy248, yymsp[-4].minor.yy248);
                                                                                    yymsp[-11].minor.yy248 = addFillClause(pCxt, yymsp[-11].minor.yy248, yymsp[-3].minor.yy248);
                                                                                  }
        break;
      case 421: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy89 = false; }
        break;
      case 424: /* select_item ::= NK_STAR */
{ yylhsminor.yy248 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy248 = yylhsminor.yy248;
        break;
      case 426: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy248 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy248), &yymsp[0].minor.yy401); }
  yymsp[-1].minor.yy248 = yylhsminor.yy248;
        break;
      case 427: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy248 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), &yymsp[0].minor.yy401); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 432: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 449: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==449);
      case 465: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==465);
{ yymsp[-2].minor.yy552 = yymsp[0].minor.yy552; }
        break;
      case 434: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy248 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy248), releaseRawExprNode(pCxt, yymsp[-1].minor.yy248)); }
        break;
      case 435: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy248 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy248)); }
        break;
      case 436: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy248 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy248), NULL, yymsp[-1].minor.yy248, yymsp[0].minor.yy248); }
        break;
      case 437: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy248 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy248), releaseRawExprNode(pCxt, yymsp[-3].minor.yy248), yymsp[-1].minor.yy248, yymsp[0].minor.yy248); }
        break;
      case 439: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 457: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==457);
{ yymsp[-3].minor.yy248 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy248); }
        break;
      case 441: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy248 = createFillNode(pCxt, yymsp[-1].minor.yy582, NULL); }
        break;
      case 442: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy248 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy552)); }
        break;
      case 443: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy582 = FILL_MODE_NONE; }
        break;
      case 444: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy582 = FILL_MODE_PREV; }
        break;
      case 445: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy582 = FILL_MODE_NULL; }
        break;
      case 446: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy582 = FILL_MODE_LINEAR; }
        break;
      case 447: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy582 = FILL_MODE_NEXT; }
        break;
      case 450: /* group_by_list ::= expression */
{ yylhsminor.yy552 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy248))); }
  yymsp[0].minor.yy552 = yylhsminor.yy552;
        break;
      case 451: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy552 = addNodeToList(pCxt, yymsp[-2].minor.yy552, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy248))); }
  yymsp[-2].minor.yy552 = yylhsminor.yy552;
        break;
      case 455: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy248 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy248), releaseRawExprNode(pCxt, yymsp[-1].minor.yy248)); }
        break;
      case 458: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy248 = addOrderByClause(pCxt, yymsp[-3].minor.yy248, yymsp[-2].minor.yy552);
                                                                                    yylhsminor.yy248 = addSlimitClause(pCxt, yylhsminor.yy248, yymsp[-1].minor.yy248);
                                                                                    yylhsminor.yy248 = addLimitClause(pCxt, yylhsminor.yy248, yymsp[0].minor.yy248);
                                                                                  }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 460: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy248 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy248, yymsp[0].minor.yy248); }
  yymsp[-3].minor.yy248 = yylhsminor.yy248;
        break;
      case 461: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy248 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy248, yymsp[0].minor.yy248); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 463: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy248 = yymsp[-4].minor.yy248; }
  yy_destructor(yypParser,368,&yymsp[-3].minor);
  yy_destructor(yypParser,369,&yymsp[-2].minor);
  yy_destructor(yypParser,370,&yymsp[-1].minor);
        break;
      case 467: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 471: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==471);
{ yymsp[-1].minor.yy248 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 468: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 472: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==472);
{ yymsp[-3].minor.yy248 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 469: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 473: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==473);
{ yymsp[-3].minor.yy248 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 474: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy248 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy248); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 478: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy248 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy248), yymsp[-1].minor.yy482, yymsp[0].minor.yy345); }
  yymsp[-2].minor.yy248 = yylhsminor.yy248;
        break;
      case 479: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy482 = ORDER_ASC; }
        break;
      case 480: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy482 = ORDER_ASC; }
        break;
      case 481: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy482 = ORDER_DESC; }
        break;
      case 482: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy345 = NULL_ORDER_DEFAULT; }
        break;
      case 483: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy345 = NULL_ORDER_FIRST; }
        break;
      case 484: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy345 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
