/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 449
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy14;
  bool yy39;
  SToken yy181;
  EJoinType yy202;
  int32_t yy276;
  SNodeList* yy282;
  int8_t yy293;
  ENullOrder yy305;
  SDataType yy380;
  EFillMode yy381;
  SAlterOption yy645;
  EOperatorType yy682;
  SNode* yy778;
  int64_t yy831;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             694
#define YYNRULE              522
#define YYNTOKEN             317
#define YY_MAX_SHIFT         693
#define YY_MIN_SHIFTREDUCE   1025
#define YY_MAX_SHIFTREDUCE   1546
#define YY_ERROR_ACTION      1547
#define YY_ACCEPT_ACTION     1548
#define YY_NO_ACTION         1549
#define YY_MIN_REDUCE        1550
#define YY_MAX_REDUCE        2071
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2819)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1873,   34,  267, 1873,  156, 1058, 1562, 1887,   62,  532,
 /*    10 */  1690, 1869,   44,   42, 1869,  446,  334,  447, 1585, 1799,
 /*    20 */   349, 1869, 1327,   43,   41,   40,   39,   38,  586,  157,
 /*    30 */   167, 1548, 1352, 1407, 1654, 1325, 1905, 1865, 1871,  337,
 /*    40 */  1865, 1871,  343, 1738,  587, 1062, 1063, 1865, 1871, 1855,
 /*    50 */   593,  599,   30,  593,  445, 1573, 1402,  449,   37,   36,
 /*    60 */   593,   17,   43,   41,   40,   39,   38, 1887, 1333,   44,
 /*    70 */    42, 1477, 1885, 1572,  503,  586, 1921,  349,  571, 1327,
 /*    80 */    97, 1886, 1888,  603, 1890, 1891,  598,   77,  593,  513,
 /*    90 */  1407,  364, 1325,  168,    1, 1974, 1905, 1855,   58,  342,
 /*   100 */  1970,  125,   46,  218,  600,  583,   58, 2042,  528, 1855,
 /*   110 */  1694,  599,  173, 1402,  463, 1855,  690,  506,   17, 1571,
 /*   120 */  2000,  500,  570,  171,  586, 1333,  217, 2043,  572, 2046,
 /*   130 */  1409, 1410,  601, 2047,  132,  583, 1921, 2042,  394, 1570,
 /*   140 */    98,  348, 1888,  603, 1890, 1891,  598,  454,  593,  447,
 /*   150 */  1585,    1, 2048,  171, 1075, 1974, 1074, 2043,  572,  314,
 /*   160 */  1970, 1855, 2042,   64,  132, 1474,   63,   58, 1481,  482,
 /*   170 */  2042,  130,  335,  690, 1352, 1328,  310, 1326, 2046,  219,
 /*   180 */   154, 1855, 2043, 2045, 1076,  570,  171, 1409, 1410, 1701,
 /*   190 */  2043,  572,  585,  169, 1982, 1983, 1353, 1987,   46, 1331,
 /*   200 */  1332,  121, 1382, 1383, 1385, 1386, 1387, 1388, 1389, 1390,
 /*   210 */  1391, 1392,  595,  591, 1400, 1401, 1403, 1404, 1405, 1406,
 /*   220 */  1408, 1411,    3,  264, 1982,  582, 1676,  581, 1745, 1746,
 /*   230 */  2042, 1417, 1328,  383, 1326,   79,  312, 1352,  388,  535,
 /*   240 */   174, 1503,  494,  493,  174,  570,  171,  387,  174,  386,
 /*   250 */  2043,  572,  174,  385,  381,  528, 1331, 1332,   58, 1382,
 /*   260 */  1383, 1385, 1386, 1387, 1388, 1389, 1390, 1391, 1392,  595,
 /*   270 */   591, 1400, 1401, 1403, 1404, 1405, 1406, 1408, 1411,    3,
 /*   280 */    44,   42,  693,  181, 2042,  233,  234,  628,  349,   77,
 /*   290 */  1327,  558, 1501, 1502, 1504, 1505,  274,  545, 1887, 2048,
 /*   300 */   171, 1407,  545, 1325, 2043,  572, 1222, 1223, 1569,   52,
 /*   310 */   165, 1874, 1695,  174,  120,  683,  679,  675,  671,  272,
 /*   320 */    74,  484, 1869,   73, 1402,  220, 1699, 1905, 1729,   17,
 /*   330 */   354, 1699,  634, 1744, 1746,  600, 1333,   44,   42, 1075,
 /*   340 */  1855, 1074,  599,  312,  143,  349,  535, 1327, 1865, 1871,
 /*   350 */  1855,  145,  144,  631,  630,  629,   95, 1384, 1407,  240,
 /*   360 */  1325,  593,    1,  601,  451,  561,  545, 1921,  634, 1076,
 /*   370 */  1350,  294,  348, 1888,  603, 1890, 1891,  598,  120,  593,
 /*   380 */    47, 1402, 1551,  574,  690,  489,   17,  145,  144,  631,
 /*   390 */   630,  629,  542, 1333, 1568, 1699,   51,  453, 1409, 1410,
 /*   400 */   449, 2042, 1473,  110,  174, 1140,  109,  108,  107,  106,
 /*   410 */   105,  104,  103,  102,  101, 1352,  570,  171, 1989,    1,
 /*   420 */  1384, 2043,  572,  110,  229,  227,  109,  108,  107,  106,
 /*   430 */   105,  104,  103,  102,  101,  545, 1855,  545, 1142,  431,
 /*   440 */   545,  690, 1299, 1328,  222, 1326, 1986,  176, 1353,  392,
 /*   450 */   567,  562,  393,   37,   36, 1409, 1410,   43,   41,   40,
 /*   460 */    39,   38, 1567,   58, 1699,   81, 1699, 1331, 1332, 1699,
 /*   470 */  1382, 1383, 1385, 1386, 1387, 1388, 1389, 1390, 1391, 1392,
 /*   480 */   595,  591, 1400, 1401, 1403, 1404, 1405, 1406, 1408, 1411,
 /*   490 */     3,   11,   11,    9,    7,  185,  184,   40,   39,   38,
 /*   500 */  1328,  547, 1326, 1946, 1855,  325, 1180,  625,  624,  623,
 /*   510 */  1184,  622, 1186, 1187,  621, 1189,  618,  636, 1195,  615,
 /*   520 */  1197, 1198,  612,  609, 1331, 1332,  174, 1382, 1383, 1385,
 /*   530 */  1386, 1387, 1388, 1389, 1390, 1391, 1392,  595,  591, 1400,
 /*   540 */  1401, 1403, 1404, 1405, 1406, 1408, 1411,    3,   44,   42,
 /*   550 */  1751,  545, 1905,  498,  497,  496,  349,  336, 1327, 1550,
 /*   560 */   565,  126,  492,  403,  545,  326, 1749,  324,  323, 1407,
 /*   570 */   486, 1325,  491,  495,  488, 1352,  417, 1566,  490, 1565,
 /*   580 */  1699, 1887,  512,  119,  118,  117,  116,  115,  114,  113,
 /*   590 */   112,  111, 1402, 1699,  352,  510,  487,  508, 1384,  564,
 /*   600 */  1887, 1751,  154, 1564, 1333,   44,   42, 1412,  353,  174,
 /*   610 */  1905, 1701, 1543,  349, 2047, 1327,  355, 1749,  600, 1855,
 /*   620 */  1354, 1855, 1677, 1855,  154,  599, 1407, 1751, 1325, 1905,
 /*   630 */     8, 1354, 1802, 1701,  319, 2047,   11,  600,  232,  545,
 /*   640 */    13,   12, 1855, 1749,  599, 1855, 1885, 1561, 1675, 1402,
 /*   650 */  1921,  418,  690,  531,  158, 1886, 1888,  603, 1890, 1891,
 /*   660 */   598, 1333,  593, 1842, 2042, 1885, 1409, 1410, 1699, 1921,
 /*   670 */   528,  545,  571,   97, 1886, 1888,  603, 1890, 1891,  598,
 /*   680 */  2046,  593,  463,  461, 2043, 2044, 2062,    8, 1974, 1855,
 /*   690 */    94, 1438,  342, 1970, 1470,  550, 2011, 1305, 1306, 2042,
 /*   700 */  1699, 2042, 2008,  566,  127,   87, 1536, 1542,  636,  690,
 /*   710 */   371, 1328, 1691, 1326, 2048,  171,  570,  171,  532, 2043,
 /*   720 */   572, 2043,  572, 1409, 1410,   37,   36, 1692, 1800,   43,
 /*   730 */    41,   40,   39,   38, 1450, 1331, 1332, 1355, 1382, 1383,
 /*   740 */  1385, 1386, 1387, 1388, 1389, 1390, 1391, 1392,  595,  591,
 /*   750 */  1400, 1401, 1403, 1404, 1405, 1406, 1408, 1411,    3,   37,
 /*   760 */    36,   31,  266,   43,   41,   40,   39,   38, 1328, 1615,
 /*   770 */  1326, 1443, 1351,  266,   37,   36,  174,   32,   43,   41,
 /*   780 */    40,   39,   38,   37,   36, 1560, 1559,   43,   41,   40,
 /*   790 */    39,   38, 1331, 1332, 1558, 1382, 1383, 1385, 1386, 1387,
 /*   800 */  1388, 1389, 1390, 1391, 1392,  595,  591, 1400, 1401, 1403,
 /*   810 */  1404, 1405, 1406, 1408, 1411,    3,   44,   42,  549,  583,
 /*   820 */  1946,  661,  659, 1798,  349,  307, 1327, 1855, 1855, 1797,
 /*   830 */   395,  307,  498,  497,  496, 1333, 1855, 1407,  545, 1325,
 /*   840 */   126,  492,  545,  396, 1792, 1792, 1513, 1355,  132, 1887,
 /*   850 */   462,  491,  495, 1557, 1696,  179,  180,  490,   37,   36,
 /*   860 */  1402, 1493,   43,   41,   40,   39,   38, 1699, 1887, 1792,
 /*   870 */   545, 1699, 1333,   44,   42,  545, 1688,  545, 1905,  243,
 /*   880 */   183,  349,  137, 1327, 1751,  130,  600,  524, 1989,  529,
 /*   890 */   545, 1855,  154,  599, 1407, 1855, 1325, 1905,    8, 1699,
 /*   900 */  1750, 1702,  237,  545, 1699,  600, 1699,  170, 1982, 1983,
 /*   910 */  1855, 1987,  599, 1336, 1885,  541, 1985, 1402, 1921, 1699,
 /*   920 */   690, 1887,  159, 1886, 1888,  603, 1890, 1891,  598, 1333,
 /*   930 */   593,  488, 1699, 1885, 1409, 1410, 1556, 1921, 1555,  402,
 /*   940 */   545,   97, 1886, 1888,  603, 1890, 1891,  598,  128,  593,
 /*   950 */  1905, 1945,  356,  487, 2062,    1, 1974, 1989,  600,  545,
 /*   960 */   342, 1970,  578, 1855,  545,  599,  649,  648, 1669, 1699,
 /*   970 */  2036,  543,  545,  575,  573, 2063,  544,  690, 1855, 1328,
 /*   980 */  1855, 1326, 1674, 1602,  268, 1984, 1885,   72, 1699,  242,
 /*   990 */  1921, 1409, 1410, 1699,  159, 1886, 1888,  603, 1890, 1891,
 /*  1000 */   598, 1699,  593, 1331, 1332,  499, 1382, 1383, 1385, 1386,
 /*  1010 */  1387, 1388, 1389, 1390, 1391, 1392,  595,  591, 1400, 1401,
 /*  1020 */  1403, 1404, 1405, 1406, 1408, 1411,    3,   37,   36,  205,
 /*  1030 */  1684,   43,   41,   40,   39,   38, 1328,  632, 1326,  362,
 /*  1040 */  1742,  633,   45,  161, 1742, 1554, 1335, 2064,  480,  476,
 /*  1050 */   472,  468,  204, 1553,  279, 1339,  528, 1729, 1062, 1063,
 /*  1060 */  1331, 1332, 1612, 1382, 1383, 1385, 1386, 1387, 1388, 1389,
 /*  1070 */  1390, 1391, 1392,  595,  591, 1400, 1401, 1403, 1404, 1405,
 /*  1080 */  1406, 1408, 1411,    3,  309, 2042, 1350, 1855,  634,   78,
 /*  1090 */  1994, 1470,  202,  425, 1276, 1855,  436,   48,    4,  210,
 /*  1100 */  2048,  171,  208,   50,  527, 2043,  572,  145,  144,  631,
 /*  1110 */   630,  629, 1686,  410,  231,  437,  212,  412,  214,  211,
 /*  1120 */   216,  213,  138,  215,  226,  667,  666,  665,  664,  359,
 /*  1130 */  1682,  663,  662,  133,  657,  656,  655,  654,  653,  652,
 /*  1140 */   651,  650,  147,  646,  645,  644,  358,  357,  641,  640,
 /*  1150 */   639,  638,  637,  155,  201,  195, 1597,  200,  285,  322,
 /*  1160 */  1595,  459, 1545, 1546,   80,  642,  235,  142,   13,   12,
 /*  1170 */   590,  398,  283,   66,  538,  143,   65,  193,  501,   60,
 /*  1180 */   579,  153,  504,  247, 1327, 1876,   60, 1122, 1338,  576,
 /*  1190 */   223,   45,  189,  442,  440, 1887,  594, 1325, 2047,  435,
 /*  1200 */    45,  607,  430,  429,  428,  427,  424,  423,  422,  421,
 /*  1210 */   420,  416,  415,  414,  413,  407,  406,  405,  404,  239,
 /*  1220 */   400,  399,  321,  142, 1905,  523,  627, 1173,  143,   58,
 /*  1230 */  1333, 1500,  600, 1878, 1563,  250, 1655, 1855, 1444,  599,
 /*  1240 */  2014,   37,   36, 1393,  122,   43,   41,   40,   39,   38,
 /*  1250 */    37,   36,  278, 1201,   43,   41,   40,   39,   38, 1102,
 /*  1260 */  1885,  142,  643,  261, 1921,  559,  481,   96,   97, 1886,
 /*  1270 */  1888,  603, 1890, 1891,  598, 1205,  593, 1887,  690,  129,
 /*  1280 */  1212,  141, 1945, 1974, 1120,   26, 1591,  342, 1970,  255,
 /*  1290 */  1536, 1906, 1103,  360,  315, 1586, 1210, 1739, 2004,   93,
 /*  1300 */   584,  260,   71,   70,  391,  263, 1905,  178, 1428,   90,
 /*  1310 */     2,  332,    5,  146,  600,  365,  370,  320, 1292, 1855,
 /*  1320 */   182,  599,  275,  397,  308,  401, 1350,  379, 1887,  377,
 /*  1330 */   373,  369,  366,  363,  685,  419, 1436, 1328, 1794, 1326,
 /*  1340 */   426,  433, 1885,  432,  434,  583, 1921,  438, 1356,  439,
 /*  1350 */   301, 1886, 1888,  603, 1890, 1891,  598, 1905,  593,  186,
 /*  1360 */  1358, 1331, 1332,  441,  361,  587,  443,  444,  452,  455,
 /*  1370 */  1855,  192,  599,  456,  132,  174,  194,  516, 1357,  457,
 /*  1380 */  1359,  528,  458,  197,  199,   75,   76,  464,  460,  203,
 /*  1390 */  1437,  483,  485, 1885,  528,  100, 1689, 1921,  207, 1685,
 /*  1400 */   515,   97, 1886, 1888,  603, 1890, 1891,  598,  311,  593,
 /*  1410 */  2042,  130,  209,  148,  168,  221, 1974,  517, 1833,  276,
 /*  1420 */   342, 1970,  149, 2042, 1687, 2048,  171, 1683,  518,  150,
 /*  1430 */  2043,  572,  151,  172, 1982, 1983,  522, 1987, 2048,  171,
 /*  1440 */   519, 2001,  224, 2043,  572,  525, 1887,  530,  228,  557,
 /*  1450 */   331,  533, 1832,  139, 1804,  536,  140,  333,  539,   84,
 /*  1460 */    33,  346, 1431, 1432, 1433, 1434, 1435, 1439, 1440, 1441,
 /*  1470 */  1442,  540,  277, 1700,   86, 1905, 1355,  553,  560, 2005,
 /*  1480 */  2015,    6,  245,  600,  555,  556,  249,  338, 1855, 2020,
 /*  1490 */   599,  569,  563, 1996, 2019,  554,  552,  551,  259,  339,
 /*  1500 */   580,  577, 1470,  131, 1354,   57,  162,  254, 1955,   88,
 /*  1510 */   256, 1885, 1990, 1887,  605, 1921, 1743, 1670,  257,   97,
 /*  1520 */  1886, 1888,  603, 1890, 1891,  598,  258,  593,  280,  271,
 /*  1530 */   686,  687, 2062,  689, 1974, 1887, 2041,  292,  342, 1970,
 /*  1540 */   262,  306, 1905,   49, 2065,  282,  303,  302, 1993,  284,
 /*  1550 */   600, 1849, 1848,   68, 1847, 1855,   69,  599, 1846, 1843,
 /*  1560 */   367,  368, 1319, 1320, 1905,  177,  372, 1841,  374,  375,
 /*  1570 */   376, 1840,  600,  378, 1839,  380, 1838, 1855, 1885,  599,
 /*  1580 */  1837,  384, 1921,  382, 1295, 1294,   97, 1886, 1888,  603,
 /*  1590 */  1890, 1891,  598, 1887,  593, 1815, 1814,  389,  390, 1949,
 /*  1600 */  1885, 1974, 1813, 1812, 1921,  342, 1970,  134,   97, 1886,
 /*  1610 */  1888,  603, 1890, 1891,  598, 1887,  593, 1787, 1264,  345,
 /*  1620 */   344, 1947, 1905, 1974, 1786, 1784, 1783,  342, 1970, 1341,
 /*  1630 */   600, 1782, 1785,  135, 1781, 1855,  408,  599, 1780, 1779,
 /*  1640 */  1407, 1778, 1334, 1777, 1905, 1776,  409, 1775,  411, 1774,
 /*  1650 */  1773, 1772,  600, 1771, 1770, 1769, 1768, 1855, 1885,  599,
 /*  1660 */  1767, 1766, 1921, 1402, 1765, 1764,   97, 1886, 1888,  603,
 /*  1670 */  1890, 1891,  598, 1763,  593, 1333, 1762, 1761, 1760,  548,
 /*  1680 */  1885, 1974,  136, 1759, 1921,  342, 1970, 1148,   98, 1886,
 /*  1690 */  1888,  603, 1890, 1891,  598, 1758,  593, 1757, 1756, 1755,
 /*  1700 */  1754, 1266, 1753, 1974, 1752, 1617, 1616, 1973, 1970, 1614,
 /*  1710 */  1582,  190,  448,  187,  188,  166,  450, 1065, 1581,  123,
 /*  1720 */   124, 1064, 1887,  589,  191, 1828, 1822, 1811,  196,  198,
 /*  1730 */  1810, 1796, 1678, 1095, 1613, 1611,  465,  466, 1609,  470,
 /*  1740 */  1607,  474, 1605,  478, 1594, 1593,  469,  467, 1578,  473,
 /*  1750 */  1680, 1905,  471, 1679,  475,  477,  479, 1216, 1215,  600,
 /*  1760 */  1603, 1598,   59,  206, 1855,  502,  599,  658, 1139, 1132,
 /*  1770 */  1596,  660, 1138,  327, 1137, 1577, 1134,  328, 1133,  329,
 /*  1780 */  1576, 1131, 1342, 1575, 1337,  511,   99, 1885, 1311,  505,
 /*  1790 */  1887, 1921, 1827,  507,  509,   98, 1886, 1888,  603, 1890,
 /*  1800 */  1891,  598, 1821,  593,   53,  152, 1345, 1347, 1301, 1887,
 /*  1810 */  1974,  520, 1809,   25,  588, 1970, 1807, 2047, 1808, 1905,
 /*  1820 */   591, 1400, 1401, 1403, 1404, 1405, 1406,  597, 1309,  521,
 /*  1830 */   330, 1806, 1855,  225,  599, 1805, 1803, 1795, 1905,  526,
 /*  1840 */    83,  241,  537,   18,  238, 1419,  600,  230,   19,   20,
 /*  1850 */   534, 1855,   15,  599,   10, 1885,  236,  253,   82, 1921,
 /*  1860 */    90, 1876,   85,  300, 1886, 1888,  603, 1890, 1891,  598,
 /*  1870 */   596,  593,  546, 1939, 1885,   27, 1887, 1515, 1921,  246,
 /*  1880 */   244,  248,   98, 1886, 1888,  603, 1890, 1891,  598, 1497,
 /*  1890 */   593,   56, 1499, 1887,  160,  252,   29, 1974,  251,   61,
 /*  1900 */    22,   28, 1971, 1492,   89, 1905,  265, 1530, 1418, 1529,
 /*  1910 */   340, 1534, 1535,  597, 1536, 1533,  341, 1467, 1855, 1466,
 /*  1920 */   599,   55, 1905, 1875,   12,  163, 1343, 1924, 1429,   54,
 /*  1930 */   600,  164,   21, 1397,  592, 1855, 1887,  599, 1395,   35,
 /*  1940 */    14, 1885, 1375,  175, 1394, 1921, 1367,  604,   23,  300,
 /*  1950 */  1886, 1888,  603, 1890, 1891,  598, 1887,  593, 1885, 1940,
 /*  1960 */    24,  606, 1921, 1202,  351, 1905,  158, 1886, 1888,  603,
 /*  1970 */  1890, 1891,  598,  600,  593,  602,  608,  610, 1855, 1199,
 /*  1980 */   599,  611,  613, 1196,  614, 1905, 1190,  616,  617,  619,
 /*  1990 */   347, 1194,  620,  600, 1188, 1179,   91,   92, 1855,  626,
 /*  2000 */   599, 1885, 1211,   67, 1193, 1921,  269, 1887, 2012,  296,
 /*  2010 */  1886, 1888,  603, 1890, 1891,  598,   16,  593, 1192, 1191,
 /*  2020 */  1207, 1885, 1093,  635, 1128, 1921, 1127, 1126, 1125,  301,
 /*  2030 */  1886, 1888,  603, 1890, 1891,  598, 1905,  593, 1124, 1123,
 /*  2040 */  1121,  350, 1119, 1118,  600, 1117, 1146,  647, 1115, 1855,
 /*  2050 */  1114,  599,  270,  568, 1113, 1112, 1111, 1110, 1109, 1108,
 /*  2060 */  1141, 1105, 1143, 1104, 1101, 1100, 1099, 1610, 1098, 1608,
 /*  2070 */   668, 1606, 1885,  672,  669,  670, 1921,  676,  673,  674,
 /*  2080 */   301, 1886, 1888,  603, 1890, 1891,  598, 1887,  593,  678,
 /*  2090 */   677, 1604,  680,  681,  682, 1592,  684, 1055, 1574,  273,
 /*  2100 */   688, 1549, 1329,  281,  691, 1887,  692, 1549, 1549, 1549,
 /*  2110 */  1549, 1549, 1549, 1549, 1549, 1549, 1905, 1549, 1549, 1549,
 /*  2120 */  1549, 1549, 1549, 1549,  600, 1549, 1549, 1549, 1549, 1855,
 /*  2130 */  1549,  599, 1549, 1549, 1905, 1549, 1549, 1549, 1549, 1549,
 /*  2140 */  1549, 1549,  600, 1549, 1549, 1549, 1549, 1855, 1887,  599,
 /*  2150 */  1549, 1549,  514, 1549, 1549, 1549, 1921, 1549, 1549, 1549,
 /*  2160 */   294, 1886, 1888,  603, 1890, 1891,  598, 1887,  593, 1549,
 /*  2170 */  1885, 1549, 1549, 1549, 1921, 1549, 1549, 1905,  286, 1886,
 /*  2180 */  1888,  603, 1890, 1891,  598,  600,  593, 1549, 1549, 1549,
 /*  2190 */  1855, 1887,  599, 1549, 1549, 1549, 1905, 1549, 1549, 1549,
 /*  2200 */  1549, 1549, 1549, 1549,  600, 1549, 1549, 1549, 1549, 1855,
 /*  2210 */  1549,  599, 1549, 1885, 1549, 1549, 1549, 1921, 1549, 1549,
 /*  2220 */  1905,  287, 1886, 1888,  603, 1890, 1891,  598,  600,  593,
 /*  2230 */  1549, 1549, 1885, 1855, 1887,  599, 1921, 1549, 1549, 1549,
 /*  2240 */   288, 1886, 1888,  603, 1890, 1891,  598, 1549,  593, 1549,
 /*  2250 */  1549, 1887, 1549, 1549, 1549, 1549, 1885, 1549, 1549, 1549,
 /*  2260 */  1921, 1549, 1549, 1905,  295, 1886, 1888,  603, 1890, 1891,
 /*  2270 */   598,  600,  593, 1549, 1549, 1549, 1855, 1887,  599, 1549,
 /*  2280 */  1905, 1549, 1549, 1549, 1549, 1549, 1549, 1549,  600, 1549,
 /*  2290 */  1549, 1549, 1549, 1855, 1887,  599, 1549, 1549, 1549, 1885,
 /*  2300 */  1549, 1549, 1549, 1921, 1549, 1549, 1905,  297, 1886, 1888,
 /*  2310 */   603, 1890, 1891,  598,  600,  593, 1885, 1549, 1549, 1855,
 /*  2320 */  1921,  599, 1549, 1905,  289, 1886, 1888,  603, 1890, 1891,
 /*  2330 */   598,  600,  593, 1549, 1549, 1549, 1855, 1549,  599, 1549,
 /*  2340 */  1549, 1549, 1885, 1549, 1549, 1549, 1921, 1549, 1549, 1549,
 /*  2350 */   298, 1886, 1888,  603, 1890, 1891,  598, 1887,  593, 1885,
 /*  2360 */  1549, 1549, 1549, 1921, 1549, 1549, 1549,  290, 1886, 1888,
 /*  2370 */   603, 1890, 1891,  598, 1887,  593, 1549, 1549, 1549, 1549,
 /*  2380 */  1549, 1549, 1549, 1549, 1549, 1549, 1905, 1549, 1549, 1549,
 /*  2390 */  1549, 1549, 1549, 1549,  600, 1549, 1549, 1549, 1549, 1855,
 /*  2400 */  1549,  599, 1549, 1905, 1549, 1549, 1549, 1549, 1549, 1549,
 /*  2410 */  1549,  600, 1549, 1549, 1549, 1549, 1855, 1549,  599, 1549,
 /*  2420 */  1549, 1549, 1885, 1549, 1549, 1549, 1921, 1549, 1549, 1549,
 /*  2430 */   299, 1886, 1888,  603, 1890, 1891,  598, 1887,  593, 1885,
 /*  2440 */  1549, 1549, 1549, 1921, 1549, 1549, 1549,  291, 1886, 1888,
 /*  2450 */   603, 1890, 1891,  598, 1549,  593, 1549, 1549, 1549, 1549,
 /*  2460 */  1549, 1549, 1549, 1887, 1549, 1549, 1905, 1549, 1549, 1549,
 /*  2470 */  1549, 1549, 1549, 1549,  600, 1549, 1549, 1549, 1549, 1855,
 /*  2480 */  1549,  599, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*  2490 */  1549, 1549, 1905, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*  2500 */   600, 1549, 1885, 1549, 1549, 1855, 1921,  599, 1549, 1549,
 /*  2510 */   304, 1886, 1888,  603, 1890, 1891,  598, 1887,  593, 1549,
 /*  2520 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1885, 1549,
 /*  2530 */  1549, 1549, 1921, 1549, 1887, 1549,  305, 1886, 1888,  603,
 /*  2540 */  1890, 1891,  598, 1549,  593, 1549, 1905, 1549, 1549, 1549,
 /*  2550 */  1549, 1549, 1549, 1549,  600, 1549, 1549, 1549, 1549, 1855,
 /*  2560 */  1549,  599, 1549, 1905, 1549, 1549, 1549, 1549, 1549, 1549,
 /*  2570 */  1549,  600, 1549, 1549, 1549, 1549, 1855, 1887,  599, 1549,
 /*  2580 */  1549, 1549, 1885, 1549, 1549, 1549, 1921, 1549, 1549, 1549,
 /*  2590 */  1899, 1886, 1888,  603, 1890, 1891,  598, 1887,  593, 1885,
 /*  2600 */  1549, 1549, 1549, 1921, 1549, 1549, 1905, 1898, 1886, 1888,
 /*  2610 */   603, 1890, 1891,  598,  600,  593, 1549, 1549, 1549, 1855,
 /*  2620 */  1549,  599, 1549, 1549, 1549, 1549, 1905, 1549, 1549, 1549,
 /*  2630 */  1549, 1549, 1549, 1549,  600, 1549, 1549, 1549, 1549, 1855,
 /*  2640 */  1887,  599, 1885, 1549, 1549, 1549, 1921, 1549, 1549, 1549,
 /*  2650 */  1897, 1886, 1888,  603, 1890, 1891,  598, 1887,  593, 1549,
 /*  2660 */  1549, 1549, 1885, 1549, 1549, 1549, 1921, 1549, 1549, 1905,
 /*  2670 */   316, 1886, 1888,  603, 1890, 1891,  598,  600,  593, 1549,
 /*  2680 */  1549, 1549, 1855, 1549,  599, 1549, 1905, 1549, 1549, 1549,
 /*  2690 */  1549, 1549, 1549, 1549,  600, 1549, 1549, 1549, 1549, 1855,
 /*  2700 */  1549,  599, 1549, 1549, 1549, 1885, 1549, 1549, 1549, 1921,
 /*  2710 */  1549, 1549, 1549,  317, 1886, 1888,  603, 1890, 1891,  598,
 /*  2720 */  1887,  593, 1885, 1549, 1549, 1549, 1921, 1549, 1549, 1549,
 /*  2730 */   313, 1886, 1888,  603, 1890, 1891,  598, 1887,  593, 1549,
 /*  2740 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1905,
 /*  2750 */  1549, 1549, 1549, 1549, 1549, 1549, 1549,  600, 1549, 1549,
 /*  2760 */  1549, 1549, 1855, 1549,  599, 1549, 1905, 1549, 1549, 1549,
 /*  2770 */  1549, 1549, 1549, 1549,  600, 1549, 1549, 1549, 1549, 1855,
 /*  2780 */  1549,  599, 1549, 1549, 1549, 1885, 1549, 1549, 1549, 1921,
 /*  2790 */  1549, 1549, 1549,  318, 1886, 1888,  603, 1890, 1891,  598,
 /*  2800 */  1549,  593, 1885, 1549, 1549, 1549, 1921, 1549, 1549, 1549,
 /*  2810 */   293, 1886, 1888,  603, 1890, 1891,  598, 1549,  593,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   351,  409,  410,  351,  319,    4,  321,  320,    4,  364,
 /*    10 */   351,  362,   12,   13,  362,  324,  371,  326,  327,  374,
 /*    20 */    20,  362,   22,   12,   13,   14,   15,   16,   20,  333,
 /*    30 */   348,  317,   20,   33,  338,   35,  349,  388,  389,  390,
 /*    40 */   388,  389,  390,  361,  357,   44,   45,  388,  389,  362,
 /*    50 */   401,  364,    2,  401,  325,  320,   56,  328,    8,    9,
 /*    60 */   401,   61,   12,   13,   14,   15,   16,  320,   68,   12,
 /*    70 */    13,   14,  385,  320,    4,   20,  389,   20,  394,   22,
 /*    80 */   393,  394,  395,  396,  397,  398,  399,  332,  401,   19,
 /*    90 */    33,  377,   35,  406,   94,  408,  349,  362,   94,  412,
 /*   100 */   413,  346,   94,   33,  357,  328,   94,  423,  394,  362,
 /*   110 */   355,  364,  425,   56,   60,  362,  116,   47,   61,  320,
 /*   120 */   433,   51,  438,  439,   20,   68,   56,  443,  444,    3,
 /*   130 */   130,  131,  385,  394,  357,  328,  389,  423,  328,  320,
 /*   140 */   393,  394,  395,  396,  397,  398,  399,  324,  401,  326,
 /*   150 */   327,   94,  438,  439,   20,  408,   22,  443,  444,  412,
 /*   160 */   413,  362,  423,   93,  357,    4,   96,   94,   14,   35,
 /*   170 */   423,  394,  341,  116,   20,  175,  366,  177,  439,  126,
 /*   180 */   349,  362,  443,  444,   50,  438,  439,  130,  131,  358,
 /*   190 */   443,  444,  415,  416,  417,  418,   20,  420,   94,  199,
 /*   200 */   200,  394,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  416,  417,  418,    0,  420,  363,  364,
 /*   230 */   423,   14,  175,  170,  177,  182,  183,   20,  377,  186,
 /*   240 */   240,  199,  335,  336,  240,  438,  439,  174,  240,  176,
 /*   250 */   443,  444,  240,  190,  191,  394,  199,  200,   94,  202,
 /*   260 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*   270 */   213,  214,  215,  216,  217,  218,  219,  220,  221,  222,
 /*   280 */    12,   13,   19,   56,  423,  125,  126,  105,   20,  332,
 /*   290 */    22,  249,  250,  251,  252,  253,   33,  328,  320,  438,
 /*   300 */   439,   33,  328,   35,  443,  444,  130,  131,  320,  340,
 /*   310 */    47,  351,  355,  240,  340,   52,   53,   54,   55,   56,
 /*   320 */    93,  347,  362,   96,   56,  342,  357,  349,  345,   61,
 /*   330 */   360,  357,  106,  363,  364,  357,   68,   12,   13,   20,
 /*   340 */   362,   22,  364,  183,   43,   20,  186,   22,  388,  389,
 /*   350 */   362,  125,  126,  127,  128,  129,   93,  203,   33,   96,
 /*   360 */    35,  401,   94,  385,   14,  160,  328,  389,  106,   50,
 /*   370 */    20,  393,  394,  395,  396,  397,  398,  399,  340,  401,
 /*   380 */    94,   56,    0,  257,  116,  347,   61,  125,  126,  127,
 /*   390 */   128,  129,  129,   68,  320,  357,   95,  325,  130,  131,
 /*   400 */   328,  423,  241,   21,  240,   35,   24,   25,   26,   27,
 /*   410 */    28,   29,   30,   31,   32,   20,  438,  439,  391,   94,
 /*   420 */   203,  443,  444,   21,  161,   56,   24,   25,   26,   27,
 /*   430 */    28,   29,   30,   31,   32,  328,  362,  328,   68,   78,
 /*   440 */   328,  116,  179,  175,  181,  177,  419,  340,   20,  340,
 /*   450 */   245,  246,  340,    8,    9,  130,  131,   12,   13,   14,
 /*   460 */    15,   16,  320,   94,  357,   96,  357,  199,  200,  357,
 /*   470 */   202,  203,  204,  205,  206,  207,  208,  209,  210,  211,
 /*   480 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   490 */   222,  224,  224,  226,   39,  134,  135,   14,   15,   16,
 /*   500 */   175,  405,  177,  407,  362,   37,  107,  108,  109,  110,
 /*   510 */   111,  112,  113,  114,  115,  116,  117,   60,  119,  120,
 /*   520 */   121,  122,  123,  124,  199,  200,  240,  202,  203,  204,
 /*   530 */   205,  206,  207,  208,  209,  210,  211,  212,  213,  214,
 /*   540 */   215,  216,  217,  218,  219,  220,  221,  222,   12,   13,
 /*   550 */   349,  328,  349,   63,   64,   65,   20,  356,   22,    0,
 /*   560 */   357,   71,   72,  340,  328,   97,  365,   99,  100,   33,
 /*   570 */   102,   35,   82,   83,  106,   20,  340,  320,   88,  320,
 /*   580 */   357,  320,   21,   24,   25,   26,   27,   28,   29,   30,
 /*   590 */    31,   32,   56,  357,  341,   34,  128,   36,  203,  396,
 /*   600 */   320,  349,  349,  320,   68,   12,   13,   14,  356,  240,
 /*   610 */   349,  358,  167,   20,    3,   22,  341,  365,  357,  362,
 /*   620 */    20,  362,    0,  362,  349,  364,   33,  349,   35,  349,
 /*   630 */    94,   20,    0,  358,  356,  394,  224,  357,  125,  328,
 /*   640 */     1,    2,  362,  365,  364,  362,  385,  320,    0,   56,
 /*   650 */   389,  340,  116,  377,  393,  394,  395,  396,  397,  398,
 /*   660 */   399,   68,  401,    0,  423,  385,  130,  131,  357,  389,
 /*   670 */   394,  328,  394,  393,  394,  395,  396,  397,  398,  399,
 /*   680 */   439,  401,   60,  340,  443,  444,  406,   94,  408,  362,
 /*   690 */   330,  157,  412,  413,  239,  434,  435,  184,  185,  423,
 /*   700 */   357,  423,  422,   20,  344,  330,   95,  262,   60,  116,
 /*   710 */    47,  175,  352,  177,  438,  439,  438,  439,  364,  443,
 /*   720 */   444,  443,  444,  130,  131,    8,    9,  352,  374,   12,
 /*   730 */    13,   14,   15,   16,   95,  199,  200,   20,  202,  203,
 /*   740 */   204,  205,  206,  207,  208,  209,  210,  211,  212,  213,
 /*   750 */   214,  215,  216,  217,  218,  219,  220,  221,  222,    8,
 /*   760 */     9,  227,  162,   12,   13,   14,   15,   16,  175,    0,
 /*   770 */   177,  237,   20,  162,    8,    9,  240,    2,   12,   13,
 /*   780 */    14,   15,   16,    8,    9,  320,  320,   12,   13,   14,
 /*   790 */    15,   16,  199,  200,  320,  202,  203,  204,  205,  206,
 /*   800 */   207,  208,  209,  210,  211,  212,  213,  214,  215,  216,
 /*   810 */   217,  218,  219,  220,  221,  222,   12,   13,  405,  328,
 /*   820 */   407,  335,  336,  373,   20,  375,   22,  362,  362,  373,
 /*   830 */    22,  375,   63,   64,   65,   68,  362,   33,  328,   35,
 /*   840 */    71,   72,  328,   35,  357,  357,   95,   20,  357,  320,
 /*   850 */   340,   82,   83,  320,  340,  368,  368,   88,    8,    9,
 /*   860 */    56,   95,   12,   13,   14,   15,   16,  357,  320,  357,
 /*   870 */   328,  357,   68,   12,   13,  328,  350,  328,  349,  162,
 /*   880 */   368,   20,  340,   22,  349,  394,  357,  340,  391,  340,
 /*   890 */   328,  362,  349,  364,   33,  362,   35,  349,   94,  357,
 /*   900 */   365,  358,  340,  328,  357,  357,  357,  416,  417,  418,
 /*   910 */   362,  420,  364,   35,  385,  340,  419,   56,  389,  357,
 /*   920 */   116,  320,  393,  394,  395,  396,  397,  398,  399,   68,
 /*   930 */   401,  106,  357,  385,  130,  131,  320,  389,  320,  105,
 /*   940 */   328,  393,  394,  395,  396,  397,  398,  399,  404,  401,
 /*   950 */   349,  407,  340,  128,  406,   94,  408,  391,  357,  328,
 /*   960 */   412,  413,   43,  362,  328,  364,  337,   68,  339,  357,
 /*   970 */   422,  340,  328,   43,  445,  446,  340,  116,  362,  175,
 /*   980 */   362,  177,    0,    0,  340,  419,  385,  153,  357,  162,
 /*   990 */   389,  130,  131,  357,  393,  394,  395,  396,  397,  398,
 /*  1000 */   399,  357,  401,  199,  200,   22,  202,  203,  204,  205,
 /*  1010 */   206,  207,  208,  209,  210,  211,  212,  213,  214,  215,
 /*  1020 */   216,  217,  218,  219,  220,  221,  222,    8,    9,   33,
 /*  1030 */   350,   12,   13,   14,   15,   16,  175,  359,  177,  377,
 /*  1040 */   362,  359,   43,   47,  362,  320,   35,  446,   52,   53,
 /*  1050 */    54,   55,   56,  320,  342,  177,  394,  345,   44,   45,
 /*  1060 */   199,  200,    0,  202,  203,  204,  205,  206,  207,  208,
 /*  1070 */   209,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*  1080 */   219,  220,  221,  222,   18,  423,   20,  362,  106,   93,
 /*  1090 */   238,  239,   96,   27,   95,  362,   30,   42,   43,   98,
 /*  1100 */   438,  439,  101,  162,  163,  443,  444,  125,  126,  127,
 /*  1110 */   128,  129,  350,   47,   43,   49,   98,   51,   98,  101,
 /*  1120 */    98,  101,   43,  101,   56,   63,   64,   65,   66,   67,
 /*  1130 */   350,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*  1140 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  1150 */    88,   89,   90,   18,  158,  159,    0,  161,   23,   93,
 /*  1160 */     0,  165,  130,  131,   96,   13,   95,   43,    1,    2,
 /*  1170 */    61,  105,   37,   38,   95,   43,   41,  181,   22,   43,
 /*  1180 */   261,  162,   22,   43,   22,   46,   43,   35,  177,  259,
 /*  1190 */   350,   43,   57,   58,   59,  320,  350,   35,    3,  133,
 /*  1200 */    43,   43,  136,  137,  138,  139,  140,  141,  142,  143,
 /*  1210 */   144,  145,  146,  147,  148,  149,  150,  151,  152,   95,
 /*  1220 */   154,  155,  156,   43,  349,  381,  350,   95,   43,   94,
 /*  1230 */    68,   95,  357,   94,  321,   95,  338,  362,   95,  364,
 /*  1240 */   392,    8,    9,   95,   43,   12,   13,   14,   15,   16,
 /*  1250 */     8,    9,   95,   95,   12,   13,   14,   15,   16,   35,
 /*  1260 */   385,   43,   13,  447,  389,  436,  329,  132,  393,  394,
 /*  1270 */   395,  396,  397,  398,  399,   95,  401,  320,  116,  404,
 /*  1280 */    95,  406,  407,  408,   35,   43,    0,  412,  413,  430,
 /*  1290 */    95,  349,   68,  329,   61,  327,   95,  361,  392,   94,
 /*  1300 */   421,  414,  167,  168,  169,  440,  349,  172,  199,  104,
 /*  1310 */   424,  354,  242,   95,  357,  387,   47,  386,  173,  362,
 /*  1320 */    42,  364,  379,  369,  189,  369,   20,  192,  320,  194,
 /*  1330 */   195,  196,  197,  198,   48,  328,  103,  175,  328,  177,
 /*  1340 */   369,  157,  385,  367,  367,  328,  389,   92,   20,  334,
 /*  1350 */   393,  394,  395,  396,  397,  398,  399,  349,  401,  328,
 /*  1360 */    20,  199,  200,  328,  377,  357,  328,  322,  322,  383,
 /*  1370 */   362,  332,  364,  364,  357,  240,  332,  377,   20,  376,
 /*  1380 */    20,  394,  378,  332,  332,  332,  332,  328,  376,  332,
 /*  1390 */   157,  322,  349,  385,  394,  328,  349,  389,  349,  349,
 /*  1400 */   188,  393,  394,  395,  396,  397,  398,  399,  322,  401,
 /*  1410 */   423,  394,  349,  349,  406,  330,  408,  384,  362,  383,
 /*  1420 */   412,  413,  349,  423,  349,  438,  439,  349,  180,  349,
 /*  1430 */   443,  444,  349,  416,  417,  418,  364,  420,  438,  439,
 /*  1440 */   382,  433,  330,  443,  444,  328,  320,  328,  330,  247,
 /*  1450 */   376,  362,  362,  372,  362,  362,  372,  362,  159,  330,
 /*  1460 */   227,  228,  229,  230,  231,  232,  233,  234,  235,  236,
 /*  1470 */   237,  370,  345,  357,  330,  349,   20,  362,  248,  392,
 /*  1480 */   392,  254,  372,  357,  362,  362,  372,  362,  362,  429,
 /*  1490 */   364,  166,  362,  432,  429,  256,  255,  243,  387,  263,
 /*  1500 */   260,  258,  239,  357,   20,   94,  429,  431,  411,   94,
 /*  1510 */   428,  385,  391,  320,  353,  389,  362,  339,  427,  393,
 /*  1520 */   394,  395,  396,  397,  398,  399,  426,  401,  328,  330,
 /*  1530 */    36,  323,  406,  322,  408,  320,  442,  343,  412,  413,
 /*  1540 */   441,  375,  349,  380,  448,  331,  343,  343,  422,  318,
 /*  1550 */   357,    0,    0,  182,    0,  362,   42,  364,    0,    0,
 /*  1560 */    35,  193,   35,   35,  349,   35,  193,    0,   35,   35,
 /*  1570 */   193,    0,  357,  193,    0,   35,    0,  362,  385,  364,
 /*  1580 */     0,   35,  389,   22,  177,  175,  393,  394,  395,  396,
 /*  1590 */   397,  398,  399,  320,  401,    0,    0,  171,  170,  406,
 /*  1600 */   385,  408,    0,    0,  389,  412,  413,   42,  393,  394,
 /*  1610 */   395,  396,  397,  398,  399,  320,  401,    0,   46,   12,
 /*  1620 */    13,  406,  349,  408,    0,    0,    0,  412,  413,   22,
 /*  1630 */   357,    0,    0,   42,    0,  362,  148,  364,    0,    0,
 /*  1640 */    33,    0,   35,    0,  349,    0,   35,    0,  148,    0,
 /*  1650 */     0,    0,  357,    0,    0,    0,    0,  362,  385,  364,
 /*  1660 */     0,    0,  389,   56,    0,    0,  393,  394,  395,  396,
 /*  1670 */   397,  398,  399,    0,  401,   68,    0,    0,    0,  406,
 /*  1680 */   385,  408,   42,    0,  389,  412,  413,   35,  393,  394,
 /*  1690 */   395,  396,  397,  398,  399,    0,  401,    0,    0,    0,
 /*  1700 */     0,   22,    0,  408,    0,    0,    0,  412,  413,    0,
 /*  1710 */     0,   42,   46,   56,   56,   43,   46,   14,    0,   39,
 /*  1720 */    39,   14,  320,  116,   40,    0,    0,    0,   39,  166,
 /*  1730 */     0,    0,    0,   62,    0,    0,   35,   47,    0,   47,
 /*  1740 */     0,   47,    0,   47,    0,    0,   35,   39,    0,   35,
 /*  1750 */     0,  349,   39,    0,   39,   35,   39,   35,   22,  357,
 /*  1760 */     0,    0,  103,  101,  362,   49,  364,   43,   35,   22,
 /*  1770 */     0,   43,   35,   22,   35,    0,   35,   22,   35,   22,
 /*  1780 */     0,   35,  175,    0,  177,   22,   20,  385,   95,   35,
 /*  1790 */   320,  389,    0,   35,   35,  393,  394,  395,  396,  397,
 /*  1800 */   398,  399,    0,  401,  162,  178,  199,  200,   35,  320,
 /*  1810 */   408,   22,    0,   94,  412,  413,    0,    3,    0,  349,
 /*  1820 */   213,  214,  215,  216,  217,  218,  219,  357,   35,  162,
 /*  1830 */   162,    0,  362,  159,  364,    0,    0,    0,  349,  164,
 /*  1840 */    39,   46,  160,   94,  158,  223,  357,   95,   43,   43,
 /*  1850 */   187,  362,  244,  364,  225,  385,   94,   46,   94,  389,
 /*  1860 */   104,   46,   94,  393,  394,  395,  396,  397,  398,  399,
 /*  1870 */   400,  401,  402,  403,  385,   94,  320,   95,  389,   95,
 /*  1880 */    94,   94,  393,  394,  395,  396,  397,  398,  399,   95,
 /*  1890 */   401,   43,   95,  320,   94,   43,   43,  408,   94,    3,
 /*  1900 */    43,   94,  413,   95,   94,  349,   46,   35,  223,   35,
 /*  1910 */    35,   35,   95,  357,   95,   35,   35,   95,  362,   95,
 /*  1920 */   364,   43,  349,   46,    2,   46,   22,   94,  199,  238,
 /*  1930 */   357,   46,  244,   95,   94,  362,  320,  364,   95,   94,
 /*  1940 */    94,  385,   22,   46,   95,  389,   95,  105,   94,  393,
 /*  1950 */   394,  395,  396,  397,  398,  399,  320,  401,  385,  403,
 /*  1960 */    94,   35,  389,   95,   35,  349,  393,  394,  395,  396,
 /*  1970 */   397,  398,  399,  357,  401,  201,   94,   35,  362,   95,
 /*  1980 */   364,   94,   35,   95,   94,  349,   95,   35,   94,   35,
 /*  1990 */   354,  118,   94,  357,   95,   22,   94,   94,  362,  106,
 /*  2000 */   364,  385,   35,   94,  118,  389,   43,  320,  435,  393,
 /*  2010 */   394,  395,  396,  397,  398,  399,  244,  401,  118,  118,
 /*  2020 */    22,  385,   62,   61,   35,  389,   35,   35,   35,  393,
 /*  2030 */   394,  395,  396,  397,  398,  399,  349,  401,   35,   35,
 /*  2040 */    35,  354,   35,   35,  357,   35,   68,   91,   35,  362,
 /*  2050 */    35,  364,   43,  437,   22,   35,   22,   35,   35,   35,
 /*  2060 */    35,   35,   68,   35,   35,   35,   22,    0,   35,    0,
 /*  2070 */    35,    0,  385,   35,   47,   39,  389,   35,   47,   39,
 /*  2080 */   393,  394,  395,  396,  397,  398,  399,  320,  401,   39,
 /*  2090 */    47,    0,   35,   47,   39,    0,   35,   35,    0,   22,
 /*  2100 */    21,  449,   22,   22,   21,  320,   20,  449,  449,  449,
 /*  2110 */   449,  449,  449,  449,  449,  449,  349,  449,  449,  449,
 /*  2120 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2130 */   449,  364,  449,  449,  349,  449,  449,  449,  449,  449,
 /*  2140 */   449,  449,  357,  449,  449,  449,  449,  362,  320,  364,
 /*  2150 */   449,  449,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2160 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  449,
 /*  2170 */   385,  449,  449,  449,  389,  449,  449,  349,  393,  394,
 /*  2180 */   395,  396,  397,  398,  399,  357,  401,  449,  449,  449,
 /*  2190 */   362,  320,  364,  449,  449,  449,  349,  449,  449,  449,
 /*  2200 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2210 */   449,  364,  449,  385,  449,  449,  449,  389,  449,  449,
 /*  2220 */   349,  393,  394,  395,  396,  397,  398,  399,  357,  401,
 /*  2230 */   449,  449,  385,  362,  320,  364,  389,  449,  449,  449,
 /*  2240 */   393,  394,  395,  396,  397,  398,  399,  449,  401,  449,
 /*  2250 */   449,  320,  449,  449,  449,  449,  385,  449,  449,  449,
 /*  2260 */   389,  449,  449,  349,  393,  394,  395,  396,  397,  398,
 /*  2270 */   399,  357,  401,  449,  449,  449,  362,  320,  364,  449,
 /*  2280 */   349,  449,  449,  449,  449,  449,  449,  449,  357,  449,
 /*  2290 */   449,  449,  449,  362,  320,  364,  449,  449,  449,  385,
 /*  2300 */   449,  449,  449,  389,  449,  449,  349,  393,  394,  395,
 /*  2310 */   396,  397,  398,  399,  357,  401,  385,  449,  449,  362,
 /*  2320 */   389,  364,  449,  349,  393,  394,  395,  396,  397,  398,
 /*  2330 */   399,  357,  401,  449,  449,  449,  362,  449,  364,  449,
 /*  2340 */   449,  449,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2350 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  385,
 /*  2360 */   449,  449,  449,  389,  449,  449,  449,  393,  394,  395,
 /*  2370 */   396,  397,  398,  399,  320,  401,  449,  449,  449,  449,
 /*  2380 */   449,  449,  449,  449,  449,  449,  349,  449,  449,  449,
 /*  2390 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2400 */   449,  364,  449,  349,  449,  449,  449,  449,  449,  449,
 /*  2410 */   449,  357,  449,  449,  449,  449,  362,  449,  364,  449,
 /*  2420 */   449,  449,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2430 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  385,
 /*  2440 */   449,  449,  449,  389,  449,  449,  449,  393,  394,  395,
 /*  2450 */   396,  397,  398,  399,  449,  401,  449,  449,  449,  449,
 /*  2460 */   449,  449,  449,  320,  449,  449,  349,  449,  449,  449,
 /*  2470 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2480 */   449,  364,  449,  449,  449,  449,  449,  449,  449,  449,
 /*  2490 */   449,  449,  349,  449,  449,  449,  449,  449,  449,  449,
 /*  2500 */   357,  449,  385,  449,  449,  362,  389,  364,  449,  449,
 /*  2510 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  449,
 /*  2520 */   449,  449,  449,  449,  449,  449,  449,  449,  385,  449,
 /*  2530 */   449,  449,  389,  449,  320,  449,  393,  394,  395,  396,
 /*  2540 */   397,  398,  399,  449,  401,  449,  349,  449,  449,  449,
 /*  2550 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2560 */   449,  364,  449,  349,  449,  449,  449,  449,  449,  449,
 /*  2570 */   449,  357,  449,  449,  449,  449,  362,  320,  364,  449,
 /*  2580 */   449,  449,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2590 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  385,
 /*  2600 */   449,  449,  449,  389,  449,  449,  349,  393,  394,  395,
 /*  2610 */   396,  397,  398,  399,  357,  401,  449,  449,  449,  362,
 /*  2620 */   449,  364,  449,  449,  449,  449,  349,  449,  449,  449,
 /*  2630 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2640 */   320,  364,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2650 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  449,
 /*  2660 */   449,  449,  385,  449,  449,  449,  389,  449,  449,  349,
 /*  2670 */   393,  394,  395,  396,  397,  398,  399,  357,  401,  449,
 /*  2680 */   449,  449,  362,  449,  364,  449,  349,  449,  449,  449,
 /*  2690 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2700 */   449,  364,  449,  449,  449,  385,  449,  449,  449,  389,
 /*  2710 */   449,  449,  449,  393,  394,  395,  396,  397,  398,  399,
 /*  2720 */   320,  401,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2730 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  449,
 /*  2740 */   449,  449,  449,  449,  449,  449,  449,  449,  449,  349,
 /*  2750 */   449,  449,  449,  449,  449,  449,  449,  357,  449,  449,
 /*  2760 */   449,  449,  362,  449,  364,  449,  349,  449,  449,  449,
 /*  2770 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2780 */   449,  364,  449,  449,  449,  385,  449,  449,  449,  389,
 /*  2790 */   449,  449,  449,  393,  394,  395,  396,  397,  398,  399,
 /*  2800 */   449,  401,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2810 */   393,  394,  395,  396,  397,  398,  399,  449,  401,
};
#define YY_SHIFT_COUNT    (693)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2098)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1135,    0,   57,  268,   57,  325,  325,  325,  536,  325,
 /*    10 */   325,  325,  325,  325,  593,  804,  804,  861,  804,  804,
 /*    20 */   804,  804,  804,  804,  804,  804,  804,  804,  804,  804,
 /*    30 */   804,  804,  804,  804,  804,  804,  804,  804,  804,  804,
 /*    40 */   804,  804,  804,  804,  804,  804,    8,   12,  104,   73,
 /*    50 */   369,  164,  286,  164,  104,  104, 1607, 1607,  164, 1607,
 /*    60 */  1607,    4,  164,   55,   55,    1,    1,  176,   55,   55,
 /*    70 */    55,   55,   55,   55,   55,   55,   55,   55,   54,   55,
 /*    80 */    55,   55,  428,   55,   55,  555,   55,   55,  555,  683,
 /*    90 */    55,  555,  555,  555,   55,  457, 1066, 1233, 1233,  402,
 /*   100 */   490, 1162, 1162, 1162, 1162, 1162, 1162, 1162, 1162, 1162,
 /*   110 */  1162, 1162, 1162, 1162, 1162, 1162, 1162, 1162, 1162, 1162,
 /*   120 */   468,  611,  176,  350,  350,  622,  370,  648,  267,  267,
 /*   130 */   600,  600,  600,  370,  752,  752,  752,  182,  428,  632,
 /*   140 */   632,  412,  555,  555,  767,  767,  182,  899,  399,  399,
 /*   150 */   399,  399,  399,  399,  399,  263,  382,  769,  717,  445,
 /*   160 */    42,  134,  205,  154,  217,  319, 1014,  825,  827,  852,
 /*   170 */   455,  126,  852, 1055,  161,  395, 1070, 1269, 1145, 1278,
 /*   180 */  1278, 1306, 1306, 1278, 1184, 1184, 1255, 1306, 1306, 1306,
 /*   190 */  1328, 1328, 1340,   54,  428,   54, 1358, 1360,   54, 1358,
 /*   200 */    54,   54,   54, 1306,   54, 1328,  555,  555,  555,  555,
 /*   210 */   555,  555,  555,  555,  555,  555,  555, 1306, 1328,  767,
 /*   220 */  1212, 1340,  457, 1248,  428,  457, 1306, 1306, 1358,  457,
 /*   230 */  1202,  767,  767,  767,  767, 1202,  767, 1299,  457,  182,
 /*   240 */   457,  752, 1456, 1456,  767, 1230, 1202,  767,  767, 1230,
 /*   250 */  1202,  767,  767,  555, 1227, 1325, 1230, 1239, 1241, 1254,
 /*   260 */  1070, 1236, 1240, 1243, 1263,  752, 1484, 1411, 1415,  767,
 /*   270 */   899, 1306,  457, 1494, 1328, 2819, 2819, 2819, 2819, 2819,
 /*   280 */  2819, 2819, 1062,  996,  559,   70,  751, 1242,  766,   50,
 /*   290 */   775, 1019,  226,  850,  850,  850,  850,  850,  850,  850,
 /*   300 */   850,  850,  982,  262,   11,   11,   53,  160,   63,  227,
 /*   310 */   361,  561,  513,  483,  639,  534,  483,  483,  483,  301,
 /*   320 */   663,  808,  834, 1001, 1018, 1020, 1022,  983, 1156, 1160,
 /*   330 */  1068,  941,  999, 1071, 1079, 1124, 1132, 1136, 1140, 1032,
 /*   340 */   930,  919, 1167, 1143,  878, 1011, 1109, 1148, 1195, 1139,
 /*   350 */  1157, 1158, 1180, 1185, 1201, 1218, 1205, 1152, 1249, 1224,
 /*   360 */  1286, 1551, 1552, 1371, 1554, 1558, 1514, 1559, 1525, 1368,
 /*   370 */  1527, 1528, 1530, 1373, 1567, 1533, 1534, 1377, 1571, 1380,
 /*   380 */  1574, 1540, 1576, 1561, 1580, 1546, 1407, 1410, 1595, 1596,
 /*   390 */  1426, 1428, 1602, 1603, 1572, 1617, 1624, 1625, 1565, 1626,
 /*   400 */  1631, 1632, 1591, 1634, 1638, 1639, 1641, 1643, 1645, 1488,
 /*   410 */  1611, 1647, 1500, 1649, 1650, 1651, 1653, 1654, 1655, 1656,
 /*   420 */  1660, 1661, 1664, 1665, 1673, 1676, 1677, 1640, 1678, 1683,
 /*   430 */  1695, 1697, 1698, 1679, 1699, 1700, 1702, 1704, 1652, 1705,
 /*   440 */  1657, 1706, 1658, 1709, 1710, 1669, 1680, 1672, 1703, 1666,
 /*   450 */  1707, 1670, 1718, 1684, 1681, 1725, 1726, 1727, 1689, 1563,
 /*   460 */  1730, 1731, 1732, 1671, 1734, 1735, 1701, 1690, 1708, 1738,
 /*   470 */  1711, 1692, 1713, 1740, 1714, 1694, 1715, 1742, 1720, 1696,
 /*   480 */  1717, 1744, 1745, 1748, 1750, 1659, 1662, 1722, 1736, 1753,
 /*   490 */  1733, 1737, 1739, 1724, 1728, 1741, 1743, 1747, 1746, 1760,
 /*   500 */  1751, 1761, 1755, 1716, 1770, 1757, 1754, 1775, 1758, 1780,
 /*   510 */  1759, 1783, 1763, 1766, 1693, 1719, 1792, 1642, 1773, 1802,
 /*   520 */  1627, 1789, 1667, 1674, 1812, 1816, 1668, 1675, 1814, 1818,
 /*   530 */  1831, 1835, 1749, 1752, 1793, 1663, 1836, 1762, 1682, 1764,
 /*   540 */  1837, 1801, 1686, 1768, 1756, 1795, 1805, 1622, 1629, 1685,
 /*   550 */  1806, 1608, 1781, 1782, 1786, 1784, 1794, 1787, 1848, 1797,
 /*   560 */  1800, 1804, 1807, 1808, 1852, 1811, 1815, 1810, 1853, 1688,
 /*   570 */  1817, 1819, 1896, 1857, 1772, 1872, 1874, 1875, 1876, 1880,
 /*   580 */  1881, 1822, 1824, 1860, 1691, 1878, 1877, 1879, 1922, 1904,
 /*   590 */  1729, 1833, 1838, 1840, 1843, 1845, 1849, 1885, 1846, 1854,
 /*   600 */  1897, 1851, 1920, 1774, 1866, 1842, 1868, 1926, 1929, 1882,
 /*   610 */  1884, 1942, 1887, 1888, 1947, 1890, 1891, 1952, 1894, 1899,
 /*   620 */  1954, 1898, 1873, 1886, 1900, 1901, 1973, 1893, 1902, 1903,
 /*   630 */  1967, 1909, 1963, 1963, 1998, 1960, 1962, 1989, 1991, 1992,
 /*   640 */  1993, 2003, 2004, 2005, 2007, 2008, 2010, 1978, 1956, 2009,
 /*   650 */  2013, 2015, 2032, 2020, 2034, 2022, 2023, 2024, 1994, 1724,
 /*   660 */  2025, 1728, 2026, 2028, 2029, 2030, 2044, 2033, 2067, 2035,
 /*   670 */  2027, 2036, 2069, 2038, 2031, 2040, 2071, 2042, 2043, 2050,
 /*   680 */  2091, 2057, 2046, 2055, 2095, 2061, 2062, 2098, 2077, 2079,
 /*   690 */  2080, 2081, 2083, 2086,
};
#define YY_REDUCE_COUNT (281)
#define YY_REDUCE_MIN   (-408)
#define YY_REDUCE_MAX   (2417)
static const short yy_reduce_ofst[] = {
 /*     0 */  -286, -253, -313,  875, 1008,  280,  548, 1126,  -22, 1193,
 /*    10 */  1215, 1273, 1295, 1402, 1470,  261,  529, 1489,  957, 1556,
 /*    20 */  1573, 1616,  601, 1636, 1687, 1767, 1785, 1828, 1847, 1871,
 /*    30 */  1914, 1931, 1957, 1974, 2037, 2054, 2117, 2143, 2197, 2214,
 /*    40 */  2257, 2277, 2320, 2337, 2400, 2417, -193,  278, -223, -139,
 /*    50 */   276,  662,  987, 1000,  491, 1017, -351, -348, -316, -341,
 /*    60 */   -40, -261,  241,  -26,   38, -309, -177,  -30,  -31,  107,
 /*    70 */   109,  112,  223,  236,  311,  343,  510,  514, -245,  542,
 /*    80 */   547,  549, -355,  562,  575, -169,  631,  636,  201,  203,
 /*    90 */   644,  253,  252,  275,  612,  360, -190, -408, -408, -315,
 /*   100 */  -304, -265, -247, -201, -181,  -12,   74,  142,  257,  259,
 /*   110 */   283,  327,  465,  466,  474,  533,  616,  618,  725,  733,
 /*   120 */  -318,   27, -135, -271,   72,  -43,  -93,  375,   96,  413,
 /*   130 */    27,  497,  566,  486,  487,  488,  512,  -17,  354,  450,
 /*   140 */   456,  544,  543,  535,  678,  682,  712,  629,  526,  680,
 /*   150 */   762,  780,  840,  846,  876,  844,  913,  898,  848,  816,
 /*   160 */   829,  937,  859,  942,  942,  964,  968,  936,  906,  879,
 /*   170 */   879,  865,  879,  887,  886,  942,  928,  931,  943,  954,
 /*   180 */   956, 1007, 1010,  971,  976,  977, 1015, 1031, 1035, 1038,
 /*   190 */  1045, 1046,  986, 1039, 1009, 1044, 1003, 1004, 1051, 1012,
 /*   200 */  1052, 1053, 1054, 1059, 1057, 1069, 1043, 1047, 1049, 1050,
 /*   210 */  1063, 1064, 1073, 1075, 1078, 1080, 1083, 1067, 1086, 1056,
 /*   220 */  1033, 1036, 1085, 1058, 1072, 1112, 1117, 1119, 1074, 1118,
 /*   230 */  1081, 1089, 1090, 1092, 1093, 1084, 1095, 1101, 1129, 1127,
 /*   240 */  1144, 1116, 1087, 1088, 1115, 1060, 1110, 1122, 1123, 1065,
 /*   250 */  1114, 1125, 1130,  942, 1061, 1076, 1077, 1082, 1091, 1100,
 /*   260 */  1111, 1096, 1094, 1099,  879, 1146, 1121, 1097, 1161, 1154,
 /*   270 */  1178, 1200, 1199, 1208, 1211, 1163, 1166, 1194, 1203, 1204,
 /*   280 */  1214, 1231,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*    10 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*    20 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*    30 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*    40 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*    50 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*    60 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*    70 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1621, 1547,
 /*    80 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*    90 */  1547, 1547, 1547, 1547, 1547, 1619, 1788, 1976, 1547, 1547,
 /*   100 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   110 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   120 */  1547, 1988, 1547, 1547, 1547, 1621, 1547, 1619, 1948, 1948,
 /*   130 */  1988, 1988, 1988, 1547, 1547, 1547, 1547, 1728, 1547, 1829,
 /*   140 */  1829, 1547, 1547, 1547, 1547, 1547, 1728, 1547, 1547, 1547,
 /*   150 */  1547, 1547, 1547, 1547, 1547, 1823, 1547, 1547, 2013, 2066,
 /*   160 */  1547, 1547, 2016, 1547, 1547, 1547, 1547, 1681, 2003, 1980,
 /*   170 */  1994, 2050, 1981, 1978, 1997, 1547, 2007, 1547, 1816, 1793,
 /*   180 */  1793, 1547, 1547, 1793, 1790, 1790, 1672, 1547, 1547, 1547,
 /*   190 */  1547, 1547, 1547, 1621, 1547, 1621, 1547, 1547, 1621, 1547,
 /*   200 */  1621, 1621, 1621, 1547, 1621, 1547, 1547, 1547, 1547, 1547,
 /*   210 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   220 */  1835, 1547, 1619, 1825, 1547, 1619, 1547, 1547, 1547, 1619,
 /*   230 */  2021, 1547, 1547, 1547, 1547, 2021, 1547, 1547, 1619, 1547,
 /*   240 */  1619, 1547, 1547, 1547, 1547, 2023, 2021, 1547, 1547, 2023,
 /*   250 */  2021, 1547, 1547, 1547, 2035, 2031, 2023, 2039, 2037, 2009,
 /*   260 */  2007, 2069, 2056, 2052, 1994, 1547, 1547, 1547, 1697, 1547,
 /*   270 */  1547, 1547, 1619, 1579, 1547, 1818, 1829, 1731, 1731, 1731,
 /*   280 */  1622, 1552, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   290 */  1547, 1547, 1547, 1904, 1547, 2034, 2033, 1952, 1951, 1950,
 /*   300 */  1941, 1903, 1547, 1693, 1902, 1901, 1547, 1547, 1547, 1547,
 /*   310 */  1547, 1547, 1547, 1895, 1547, 1547, 1896, 1894, 1893, 1547,
 /*   320 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   330 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   340 */  2053, 2057, 1977, 1547, 1547, 1547, 1547, 1547, 1886, 1877,
 /*   350 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   360 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   370 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   380 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   390 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   400 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   410 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   420 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   430 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   440 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1584, 1547, 1547,
 /*   450 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   460 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   470 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   480 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   490 */  1547, 1547, 1547, 1661, 1660, 1547, 1547, 1547, 1547, 1547,
 /*   500 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   510 */  1547, 1547, 1547, 1547, 1885, 1547, 1547, 1547, 1547, 1547,
 /*   520 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 2049, 1547,
 /*   530 */  1547, 1547, 1547, 1547, 1547, 1547, 1833, 1547, 1547, 1547,
 /*   540 */  1547, 1547, 1547, 1547, 1547, 1547, 1938, 1547, 1547, 1547,
 /*   550 */  2010, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   560 */  1547, 1547, 1547, 1547, 1547, 1547, 1877, 1547, 2032, 1547,
 /*   570 */  1547, 2047, 1547, 2051, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   580 */  1547, 1987, 1983, 1547, 1547, 1979, 1876, 1547, 1972, 1547,
 /*   590 */  1547, 1923, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   600 */  1547, 1885, 1547, 1889, 1547, 1547, 1547, 1547, 1547, 1725,
 /*   610 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   620 */  1547, 1547, 1710, 1708, 1707, 1706, 1547, 1703, 1547, 1547,
 /*   630 */  1547, 1547, 1734, 1733, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   640 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1641,
 /*   650 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1632,
 /*   660 */  1547, 1631, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   670 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   680 */  1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547, 1547,
 /*   690 */  1547, 1547, 1547, 1547,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  264,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  264,  /*      AFTER => ABORT */
  264,  /*     ATTACH => ABORT */
  264,  /*     BEFORE => ABORT */
  264,  /*      BEGIN => ABORT */
  264,  /*     BITAND => ABORT */
  264,  /*     BITNOT => ABORT */
  264,  /*      BITOR => ABORT */
  264,  /*     BLOCKS => ABORT */
  264,  /*     CHANGE => ABORT */
  264,  /*      COMMA => ABORT */
  264,  /*    COMPACT => ABORT */
  264,  /*     CONCAT => ABORT */
  264,  /*   CONFLICT => ABORT */
  264,  /*       COPY => ABORT */
  264,  /*   DEFERRED => ABORT */
  264,  /* DELIMITERS => ABORT */
  264,  /*     DETACH => ABORT */
  264,  /*     DIVIDE => ABORT */
  264,  /*        DOT => ABORT */
  264,  /*       EACH => ABORT */
  264,  /*       FAIL => ABORT */
  264,  /*       FILE => ABORT */
  264,  /*        FOR => ABORT */
  264,  /*       GLOB => ABORT */
  264,  /*         ID => ABORT */
  264,  /*  IMMEDIATE => ABORT */
  264,  /*     IMPORT => ABORT */
  264,  /*  INITIALLY => ABORT */
  264,  /*    INSTEAD => ABORT */
  264,  /*     ISNULL => ABORT */
  264,  /*        KEY => ABORT */
  264,  /*    MODULES => ABORT */
  264,  /*  NK_BITNOT => ABORT */
  264,  /*    NK_SEMI => ABORT */
  264,  /*    NOTNULL => ABORT */
  264,  /*         OF => ABORT */
  264,  /*       PLUS => ABORT */
  264,  /*  PRIVILEGE => ABORT */
  264,  /*      RAISE => ABORT */
  264,  /*    REPLACE => ABORT */
  264,  /*   RESTRICT => ABORT */
  264,  /*        ROW => ABORT */
  264,  /*       SEMI => ABORT */
  264,  /*       STAR => ABORT */
  264,  /*  STATEMENT => ABORT */
  264,  /*     STRING => ABORT */
  264,  /*      TIMES => ABORT */
  264,  /*     UPDATE => ABORT */
  264,  /*     VALUES => ABORT */
  264,  /*   VARIABLE => ABORT */
  264,  /*       VIEW => ABORT */
  264,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "MAXROWS",
  /*   70 */ "MINROWS",
  /*   71 */ "KEEP",
  /*   72 */ "PAGES",
  /*   73 */ "PAGESIZE",
  /*   74 */ "TSDB_PAGESIZE",
  /*   75 */ "PRECISION",
  /*   76 */ "REPLICA",
  /*   77 */ "STRICT",
  /*   78 */ "VGROUPS",
  /*   79 */ "SINGLE_STABLE",
  /*   80 */ "RETENTIONS",
  /*   81 */ "SCHEMALESS",
  /*   82 */ "WAL_LEVEL",
  /*   83 */ "WAL_FSYNC_PERIOD",
  /*   84 */ "WAL_RETENTION_PERIOD",
  /*   85 */ "WAL_RETENTION_SIZE",
  /*   86 */ "WAL_ROLL_PERIOD",
  /*   87 */ "WAL_SEGMENT_SIZE",
  /*   88 */ "STT_TRIGGER",
  /*   89 */ "TABLE_PREFIX",
  /*   90 */ "TABLE_SUFFIX",
  /*   91 */ "NK_COLON",
  /*   92 */ "MAX_SPEED",
  /*   93 */ "TABLE",
  /*   94 */ "NK_LP",
  /*   95 */ "NK_RP",
  /*   96 */ "STABLE",
  /*   97 */ "ADD",
  /*   98 */ "COLUMN",
  /*   99 */ "MODIFY",
  /*  100 */ "RENAME",
  /*  101 */ "TAG",
  /*  102 */ "SET",
  /*  103 */ "NK_EQ",
  /*  104 */ "USING",
  /*  105 */ "TAGS",
  /*  106 */ "COMMENT",
  /*  107 */ "BOOL",
  /*  108 */ "TINYINT",
  /*  109 */ "SMALLINT",
  /*  110 */ "INT",
  /*  111 */ "INTEGER",
  /*  112 */ "BIGINT",
  /*  113 */ "FLOAT",
  /*  114 */ "DOUBLE",
  /*  115 */ "BINARY",
  /*  116 */ "TIMESTAMP",
  /*  117 */ "NCHAR",
  /*  118 */ "UNSIGNED",
  /*  119 */ "JSON",
  /*  120 */ "VARCHAR",
  /*  121 */ "MEDIUMBLOB",
  /*  122 */ "BLOB",
  /*  123 */ "VARBINARY",
  /*  124 */ "DECIMAL",
  /*  125 */ "MAX_DELAY",
  /*  126 */ "WATERMARK",
  /*  127 */ "ROLLUP",
  /*  128 */ "TTL",
  /*  129 */ "SMA",
  /*  130 */ "FIRST",
  /*  131 */ "LAST",
  /*  132 */ "SHOW",
  /*  133 */ "DATABASES",
  /*  134 */ "TABLES",
  /*  135 */ "STABLES",
  /*  136 */ "MNODES",
  /*  137 */ "QNODES",
  /*  138 */ "FUNCTIONS",
  /*  139 */ "INDEXES",
  /*  140 */ "ACCOUNTS",
  /*  141 */ "APPS",
  /*  142 */ "CONNECTIONS",
  /*  143 */ "LICENCES",
  /*  144 */ "GRANTS",
  /*  145 */ "QUERIES",
  /*  146 */ "SCORES",
  /*  147 */ "TOPICS",
  /*  148 */ "VARIABLES",
  /*  149 */ "BNODES",
  /*  150 */ "SNODES",
  /*  151 */ "CLUSTER",
  /*  152 */ "TRANSACTIONS",
  /*  153 */ "DISTRIBUTED",
  /*  154 */ "CONSUMERS",
  /*  155 */ "SUBSCRIPTIONS",
  /*  156 */ "VNODES",
  /*  157 */ "LIKE",
  /*  158 */ "INDEX",
  /*  159 */ "FUNCTION",
  /*  160 */ "INTERVAL",
  /*  161 */ "TOPIC",
  /*  162 */ "AS",
  /*  163 */ "WITH",
  /*  164 */ "META",
  /*  165 */ "CONSUMER",
  /*  166 */ "GROUP",
  /*  167 */ "DESC",
  /*  168 */ "DESCRIBE",
  /*  169 */ "RESET",
  /*  170 */ "QUERY",
  /*  171 */ "CACHE",
  /*  172 */ "EXPLAIN",
  /*  173 */ "ANALYZE",
  /*  174 */ "VERBOSE",
  /*  175 */ "NK_BOOL",
  /*  176 */ "RATIO",
  /*  177 */ "NK_FLOAT",
  /*  178 */ "OUTPUTTYPE",
  /*  179 */ "AGGREGATE",
  /*  180 */ "BUFSIZE",
  /*  181 */ "STREAM",
  /*  182 */ "INTO",
  /*  183 */ "TRIGGER",
  /*  184 */ "AT_ONCE",
  /*  185 */ "WINDOW_CLOSE",
  /*  186 */ "IGNORE",
  /*  187 */ "EXPIRED",
  /*  188 */ "SUBTABLE",
  /*  189 */ "KILL",
  /*  190 */ "CONNECTION",
  /*  191 */ "TRANSACTION",
  /*  192 */ "BALANCE",
  /*  193 */ "VGROUP",
  /*  194 */ "MERGE",
  /*  195 */ "REDISTRIBUTE",
  /*  196 */ "SPLIT",
  /*  197 */ "DELETE",
  /*  198 */ "INSERT",
  /*  199 */ "NULL",
  /*  200 */ "NK_QUESTION",
  /*  201 */ "NK_ARROW",
  /*  202 */ "ROWTS",
  /*  203 */ "TBNAME",
  /*  204 */ "QSTART",
  /*  205 */ "QEND",
  /*  206 */ "QDURATION",
  /*  207 */ "WSTART",
  /*  208 */ "WEND",
  /*  209 */ "WDURATION",
  /*  210 */ "IROWTS",
  /*  211 */ "QTAGS",
  /*  212 */ "CAST",
  /*  213 */ "NOW",
  /*  214 */ "TODAY",
  /*  215 */ "TIMEZONE",
  /*  216 */ "CLIENT_VERSION",
  /*  217 */ "SERVER_VERSION",
  /*  218 */ "SERVER_STATUS",
  /*  219 */ "CURRENT_USER",
  /*  220 */ "COUNT",
  /*  221 */ "LAST_ROW",
  /*  222 */ "CASE",
  /*  223 */ "END",
  /*  224 */ "WHEN",
  /*  225 */ "THEN",
  /*  226 */ "ELSE",
  /*  227 */ "BETWEEN",
  /*  228 */ "IS",
  /*  229 */ "NK_LT",
  /*  230 */ "NK_GT",
  /*  231 */ "NK_LE",
  /*  232 */ "NK_GE",
  /*  233 */ "NK_NE",
  /*  234 */ "MATCH",
  /*  235 */ "NMATCH",
  /*  236 */ "CONTAINS",
  /*  237 */ "IN",
  /*  238 */ "JOIN",
  /*  239 */ "INNER",
  /*  240 */ "SELECT",
  /*  241 */ "DISTINCT",
  /*  242 */ "WHERE",
  /*  243 */ "PARTITION",
  /*  244 */ "BY",
  /*  245 */ "SESSION",
  /*  246 */ "STATE_WINDOW",
  /*  247 */ "SLIDING",
  /*  248 */ "FILL",
  /*  249 */ "VALUE",
  /*  250 */ "NONE",
  /*  251 */ "PREV",
  /*  252 */ "LINEAR",
  /*  253 */ "NEXT",
  /*  254 */ "HAVING",
  /*  255 */ "RANGE",
  /*  256 */ "EVERY",
  /*  257 */ "ORDER",
  /*  258 */ "SLIMIT",
  /*  259 */ "SOFFSET",
  /*  260 */ "LIMIT",
  /*  261 */ "OFFSET",
  /*  262 */ "ASC",
  /*  263 */ "NULLS",
  /*  264 */ "ABORT",
  /*  265 */ "AFTER",
  /*  266 */ "ATTACH",
  /*  267 */ "BEFORE",
  /*  268 */ "BEGIN",
  /*  269 */ "BITAND",
  /*  270 */ "BITNOT",
  /*  271 */ "BITOR",
  /*  272 */ "BLOCKS",
  /*  273 */ "CHANGE",
  /*  274 */ "COMMA",
  /*  275 */ "COMPACT",
  /*  276 */ "CONCAT",
  /*  277 */ "CONFLICT",
  /*  278 */ "COPY",
  /*  279 */ "DEFERRED",
  /*  280 */ "DELIMITERS",
  /*  281 */ "DETACH",
  /*  282 */ "DIVIDE",
  /*  283 */ "DOT",
  /*  284 */ "EACH",
  /*  285 */ "FAIL",
  /*  286 */ "FILE",
  /*  287 */ "FOR",
  /*  288 */ "GLOB",
  /*  289 */ "ID",
  /*  290 */ "IMMEDIATE",
  /*  291 */ "IMPORT",
  /*  292 */ "INITIALLY",
  /*  293 */ "INSTEAD",
  /*  294 */ "ISNULL",
  /*  295 */ "KEY",
  /*  296 */ "MODULES",
  /*  297 */ "NK_BITNOT",
  /*  298 */ "NK_SEMI",
  /*  299 */ "NOTNULL",
  /*  300 */ "OF",
  /*  301 */ "PLUS",
  /*  302 */ "PRIVILEGE",
  /*  303 */ "RAISE",
  /*  304 */ "REPLACE",
  /*  305 */ "RESTRICT",
  /*  306 */ "ROW",
  /*  307 */ "SEMI",
  /*  308 */ "STAR",
  /*  309 */ "STATEMENT",
  /*  310 */ "STRING",
  /*  311 */ "TIMES",
  /*  312 */ "UPDATE",
  /*  313 */ "VALUES",
  /*  314 */ "VARIABLE",
  /*  315 */ "VIEW",
  /*  316 */ "WAL",
  /*  317 */ "cmd",
  /*  318 */ "account_options",
  /*  319 */ "alter_account_options",
  /*  320 */ "literal",
  /*  321 */ "alter_account_option",
  /*  322 */ "user_name",
  /*  323 */ "sysinfo_opt",
  /*  324 */ "privileges",
  /*  325 */ "priv_level",
  /*  326 */ "priv_type_list",
  /*  327 */ "priv_type",
  /*  328 */ "db_name",
  /*  329 */ "dnode_endpoint",
  /*  330 */ "not_exists_opt",
  /*  331 */ "db_options",
  /*  332 */ "exists_opt",
  /*  333 */ "alter_db_options",
  /*  334 */ "speed_opt",
  /*  335 */ "integer_list",
  /*  336 */ "variable_list",
  /*  337 */ "retention_list",
  /*  338 */ "alter_db_option",
  /*  339 */ "retention",
  /*  340 */ "full_table_name",
  /*  341 */ "column_def_list",
  /*  342 */ "tags_def_opt",
  /*  343 */ "table_options",
  /*  344 */ "multi_create_clause",
  /*  345 */ "tags_def",
  /*  346 */ "multi_drop_clause",
  /*  347 */ "alter_table_clause",
  /*  348 */ "alter_table_options",
  /*  349 */ "column_name",
  /*  350 */ "type_name",
  /*  351 */ "signed_literal",
  /*  352 */ "create_subtable_clause",
  /*  353 */ "specific_cols_opt",
  /*  354 */ "expression_list",
  /*  355 */ "drop_table_clause",
  /*  356 */ "col_name_list",
  /*  357 */ "table_name",
  /*  358 */ "column_def",
  /*  359 */ "duration_list",
  /*  360 */ "rollup_func_list",
  /*  361 */ "alter_table_option",
  /*  362 */ "duration_literal",
  /*  363 */ "rollup_func_name",
  /*  364 */ "function_name",
  /*  365 */ "col_name",
  /*  366 */ "db_name_cond_opt",
  /*  367 */ "like_pattern_opt",
  /*  368 */ "table_name_cond",
  /*  369 */ "from_db_opt",
  /*  370 */ "index_options",
  /*  371 */ "func_list",
  /*  372 */ "sliding_opt",
  /*  373 */ "sma_stream_opt",
  /*  374 */ "func",
  /*  375 */ "stream_options",
  /*  376 */ "topic_name",
  /*  377 */ "query_or_subquery",
  /*  378 */ "cgroup_name",
  /*  379 */ "analyze_opt",
  /*  380 */ "explain_options",
  /*  381 */ "agg_func_opt",
  /*  382 */ "bufsize_opt",
  /*  383 */ "stream_name",
  /*  384 */ "subtable_opt",
  /*  385 */ "expression",
  /*  386 */ "dnode_list",
  /*  387 */ "where_clause_opt",
  /*  388 */ "signed",
  /*  389 */ "literal_func",
  /*  390 */ "literal_list",
  /*  391 */ "table_alias",
  /*  392 */ "column_alias",
  /*  393 */ "expr_or_subquery",
  /*  394 */ "subquery",
  /*  395 */ "pseudo_column",
  /*  396 */ "column_reference",
  /*  397 */ "function_expression",
  /*  398 */ "case_when_expression",
  /*  399 */ "star_func",
  /*  400 */ "star_func_para_list",
  /*  401 */ "noarg_func",
  /*  402 */ "other_para_list",
  /*  403 */ "star_func_para",
  /*  404 */ "when_then_list",
  /*  405 */ "case_when_else_opt",
  /*  406 */ "common_expression",
  /*  407 */ "when_then_expr",
  /*  408 */ "predicate",
  /*  409 */ "compare_op",
  /*  410 */ "in_op",
  /*  411 */ "in_predicate_value",
  /*  412 */ "boolean_value_expression",
  /*  413 */ "boolean_primary",
  /*  414 */ "from_clause_opt",
  /*  415 */ "table_reference_list",
  /*  416 */ "table_reference",
  /*  417 */ "table_primary",
  /*  418 */ "joined_table",
  /*  419 */ "alias_opt",
  /*  420 */ "parenthesized_joined_table",
  /*  421 */ "join_type",
  /*  422 */ "search_condition",
  /*  423 */ "query_specification",
  /*  424 */ "set_quantifier_opt",
  /*  425 */ "select_list",
  /*  426 */ "partition_by_clause_opt",
  /*  427 */ "range_opt",
  /*  428 */ "every_opt",
  /*  429 */ "fill_opt",
  /*  430 */ "twindow_clause_opt",
  /*  431 */ "group_by_clause_opt",
  /*  432 */ "having_clause_opt",
  /*  433 */ "select_item",
  /*  434 */ "partition_list",
  /*  435 */ "partition_item",
  /*  436 */ "fill_mode",
  /*  437 */ "group_by_list",
  /*  438 */ "query_expression",
  /*  439 */ "query_simple",
  /*  440 */ "order_by_clause_opt",
  /*  441 */ "slimit_clause_opt",
  /*  442 */ "limit_clause_opt",
  /*  443 */ "union_query_expression",
  /*  444 */ "query_simple_or_subquery",
  /*  445 */ "sort_specification_list",
  /*  446 */ "sort_specification",
  /*  447 */ "ordering_specification_opt",
  /*  448 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options KEEP integer_list",
 /*  82 */ "db_options ::= db_options KEEP variable_list",
 /*  83 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  84 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  85 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  86 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  87 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  88 */ "db_options ::= db_options STRICT NK_STRING",
 /*  89 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  90 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  91 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  92 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  93 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  94 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 102 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 103 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 104 */ "alter_db_options ::= alter_db_option",
 /* 105 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 106 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 107 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 108 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 109 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 110 */ "alter_db_option ::= KEEP integer_list",
 /* 111 */ "alter_db_option ::= KEEP variable_list",
 /* 112 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 114 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 115 */ "integer_list ::= NK_INTEGER",
 /* 116 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 117 */ "variable_list ::= NK_VARIABLE",
 /* 118 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 119 */ "retention_list ::= retention",
 /* 120 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 121 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 122 */ "speed_opt ::=",
 /* 123 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 124 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 125 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 126 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 127 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 128 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 129 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 130 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 131 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 132 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 133 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 134 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 135 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 136 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 141 */ "multi_create_clause ::= create_subtable_clause",
 /* 142 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 143 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 144 */ "multi_drop_clause ::= drop_table_clause",
 /* 145 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 146 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 147 */ "specific_cols_opt ::=",
 /* 148 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 149 */ "full_table_name ::= table_name",
 /* 150 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 151 */ "column_def_list ::= column_def",
 /* 152 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 153 */ "column_def ::= column_name type_name",
 /* 154 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 155 */ "type_name ::= BOOL",
 /* 156 */ "type_name ::= TINYINT",
 /* 157 */ "type_name ::= SMALLINT",
 /* 158 */ "type_name ::= INT",
 /* 159 */ "type_name ::= INTEGER",
 /* 160 */ "type_name ::= BIGINT",
 /* 161 */ "type_name ::= FLOAT",
 /* 162 */ "type_name ::= DOUBLE",
 /* 163 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 164 */ "type_name ::= TIMESTAMP",
 /* 165 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 166 */ "type_name ::= TINYINT UNSIGNED",
 /* 167 */ "type_name ::= SMALLINT UNSIGNED",
 /* 168 */ "type_name ::= INT UNSIGNED",
 /* 169 */ "type_name ::= BIGINT UNSIGNED",
 /* 170 */ "type_name ::= JSON",
 /* 171 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 172 */ "type_name ::= MEDIUMBLOB",
 /* 173 */ "type_name ::= BLOB",
 /* 174 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 175 */ "type_name ::= DECIMAL",
 /* 176 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 177 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 178 */ "tags_def_opt ::=",
 /* 179 */ "tags_def_opt ::= tags_def",
 /* 180 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 181 */ "table_options ::=",
 /* 182 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 183 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 184 */ "table_options ::= table_options WATERMARK duration_list",
 /* 185 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 186 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 187 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 188 */ "alter_table_options ::= alter_table_option",
 /* 189 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 190 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 191 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 192 */ "duration_list ::= duration_literal",
 /* 193 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 194 */ "rollup_func_list ::= rollup_func_name",
 /* 195 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 196 */ "rollup_func_name ::= function_name",
 /* 197 */ "rollup_func_name ::= FIRST",
 /* 198 */ "rollup_func_name ::= LAST",
 /* 199 */ "col_name_list ::= col_name",
 /* 200 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 201 */ "col_name ::= column_name",
 /* 202 */ "cmd ::= SHOW DNODES",
 /* 203 */ "cmd ::= SHOW USERS",
 /* 204 */ "cmd ::= SHOW DATABASES",
 /* 205 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 206 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 207 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 208 */ "cmd ::= SHOW MNODES",
 /* 209 */ "cmd ::= SHOW QNODES",
 /* 210 */ "cmd ::= SHOW FUNCTIONS",
 /* 211 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 212 */ "cmd ::= SHOW STREAMS",
 /* 213 */ "cmd ::= SHOW ACCOUNTS",
 /* 214 */ "cmd ::= SHOW APPS",
 /* 215 */ "cmd ::= SHOW CONNECTIONS",
 /* 216 */ "cmd ::= SHOW LICENCES",
 /* 217 */ "cmd ::= SHOW GRANTS",
 /* 218 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 219 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 220 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 221 */ "cmd ::= SHOW QUERIES",
 /* 222 */ "cmd ::= SHOW SCORES",
 /* 223 */ "cmd ::= SHOW TOPICS",
 /* 224 */ "cmd ::= SHOW VARIABLES",
 /* 225 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 226 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 227 */ "cmd ::= SHOW BNODES",
 /* 228 */ "cmd ::= SHOW SNODES",
 /* 229 */ "cmd ::= SHOW CLUSTER",
 /* 230 */ "cmd ::= SHOW TRANSACTIONS",
 /* 231 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 232 */ "cmd ::= SHOW CONSUMERS",
 /* 233 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 234 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 235 */ "cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt",
 /* 236 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 237 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 238 */ "db_name_cond_opt ::=",
 /* 239 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 240 */ "like_pattern_opt ::=",
 /* 241 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 242 */ "table_name_cond ::= table_name",
 /* 243 */ "from_db_opt ::=",
 /* 244 */ "from_db_opt ::= FROM db_name",
 /* 245 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 246 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 247 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 248 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 249 */ "func_list ::= func",
 /* 250 */ "func_list ::= func_list NK_COMMA func",
 /* 251 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 252 */ "sma_stream_opt ::=",
 /* 253 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 254 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 255 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 256 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 257 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 258 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 259 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 260 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 261 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 262 */ "cmd ::= DESC full_table_name",
 /* 263 */ "cmd ::= DESCRIBE full_table_name",
 /* 264 */ "cmd ::= RESET QUERY CACHE",
 /* 265 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 266 */ "analyze_opt ::=",
 /* 267 */ "analyze_opt ::= ANALYZE",
 /* 268 */ "explain_options ::=",
 /* 269 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 270 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 271 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 272 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 273 */ "agg_func_opt ::=",
 /* 274 */ "agg_func_opt ::= AGGREGATE",
 /* 275 */ "bufsize_opt ::=",
 /* 276 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 277 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 278 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 279 */ "stream_options ::=",
 /* 280 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 281 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 282 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 283 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 284 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 285 */ "subtable_opt ::=",
 /* 286 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 287 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 288 */ "cmd ::= KILL QUERY NK_STRING",
 /* 289 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 290 */ "cmd ::= BALANCE VGROUP",
 /* 291 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 292 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 293 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 294 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 295 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 296 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 297 */ "cmd ::= query_or_subquery",
 /* 298 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 299 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 300 */ "literal ::= NK_INTEGER",
 /* 301 */ "literal ::= NK_FLOAT",
 /* 302 */ "literal ::= NK_STRING",
 /* 303 */ "literal ::= NK_BOOL",
 /* 304 */ "literal ::= TIMESTAMP NK_STRING",
 /* 305 */ "literal ::= duration_literal",
 /* 306 */ "literal ::= NULL",
 /* 307 */ "literal ::= NK_QUESTION",
 /* 308 */ "duration_literal ::= NK_VARIABLE",
 /* 309 */ "signed ::= NK_INTEGER",
 /* 310 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 311 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 312 */ "signed ::= NK_FLOAT",
 /* 313 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 314 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 315 */ "signed_literal ::= signed",
 /* 316 */ "signed_literal ::= NK_STRING",
 /* 317 */ "signed_literal ::= NK_BOOL",
 /* 318 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 319 */ "signed_literal ::= duration_literal",
 /* 320 */ "signed_literal ::= NULL",
 /* 321 */ "signed_literal ::= literal_func",
 /* 322 */ "signed_literal ::= NK_QUESTION",
 /* 323 */ "literal_list ::= signed_literal",
 /* 324 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 325 */ "db_name ::= NK_ID",
 /* 326 */ "table_name ::= NK_ID",
 /* 327 */ "column_name ::= NK_ID",
 /* 328 */ "function_name ::= NK_ID",
 /* 329 */ "table_alias ::= NK_ID",
 /* 330 */ "column_alias ::= NK_ID",
 /* 331 */ "user_name ::= NK_ID",
 /* 332 */ "topic_name ::= NK_ID",
 /* 333 */ "stream_name ::= NK_ID",
 /* 334 */ "cgroup_name ::= NK_ID",
 /* 335 */ "expr_or_subquery ::= expression",
 /* 336 */ "expr_or_subquery ::= subquery",
 /* 337 */ "expression ::= literal",
 /* 338 */ "expression ::= pseudo_column",
 /* 339 */ "expression ::= column_reference",
 /* 340 */ "expression ::= function_expression",
 /* 341 */ "expression ::= case_when_expression",
 /* 342 */ "expression ::= NK_LP expression NK_RP",
 /* 343 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 344 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 345 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 346 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 347 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 348 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 349 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 350 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 351 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 352 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 353 */ "expression_list ::= expr_or_subquery",
 /* 354 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 355 */ "column_reference ::= column_name",
 /* 356 */ "column_reference ::= table_name NK_DOT column_name",
 /* 357 */ "pseudo_column ::= ROWTS",
 /* 358 */ "pseudo_column ::= TBNAME",
 /* 359 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 360 */ "pseudo_column ::= QSTART",
 /* 361 */ "pseudo_column ::= QEND",
 /* 362 */ "pseudo_column ::= QDURATION",
 /* 363 */ "pseudo_column ::= WSTART",
 /* 364 */ "pseudo_column ::= WEND",
 /* 365 */ "pseudo_column ::= WDURATION",
 /* 366 */ "pseudo_column ::= IROWTS",
 /* 367 */ "pseudo_column ::= QTAGS",
 /* 368 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 369 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 370 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 371 */ "function_expression ::= literal_func",
 /* 372 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 373 */ "literal_func ::= NOW",
 /* 374 */ "noarg_func ::= NOW",
 /* 375 */ "noarg_func ::= TODAY",
 /* 376 */ "noarg_func ::= TIMEZONE",
 /* 377 */ "noarg_func ::= DATABASE",
 /* 378 */ "noarg_func ::= CLIENT_VERSION",
 /* 379 */ "noarg_func ::= SERVER_VERSION",
 /* 380 */ "noarg_func ::= SERVER_STATUS",
 /* 381 */ "noarg_func ::= CURRENT_USER",
 /* 382 */ "noarg_func ::= USER",
 /* 383 */ "star_func ::= COUNT",
 /* 384 */ "star_func ::= FIRST",
 /* 385 */ "star_func ::= LAST",
 /* 386 */ "star_func ::= LAST_ROW",
 /* 387 */ "star_func_para_list ::= NK_STAR",
 /* 388 */ "star_func_para_list ::= other_para_list",
 /* 389 */ "other_para_list ::= star_func_para",
 /* 390 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 391 */ "star_func_para ::= expr_or_subquery",
 /* 392 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 393 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 394 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 395 */ "when_then_list ::= when_then_expr",
 /* 396 */ "when_then_list ::= when_then_list when_then_expr",
 /* 397 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 398 */ "case_when_else_opt ::=",
 /* 399 */ "case_when_else_opt ::= ELSE common_expression",
 /* 400 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 401 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 402 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 403 */ "predicate ::= expr_or_subquery IS NULL",
 /* 404 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 405 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 406 */ "compare_op ::= NK_LT",
 /* 407 */ "compare_op ::= NK_GT",
 /* 408 */ "compare_op ::= NK_LE",
 /* 409 */ "compare_op ::= NK_GE",
 /* 410 */ "compare_op ::= NK_NE",
 /* 411 */ "compare_op ::= NK_EQ",
 /* 412 */ "compare_op ::= LIKE",
 /* 413 */ "compare_op ::= NOT LIKE",
 /* 414 */ "compare_op ::= MATCH",
 /* 415 */ "compare_op ::= NMATCH",
 /* 416 */ "compare_op ::= CONTAINS",
 /* 417 */ "in_op ::= IN",
 /* 418 */ "in_op ::= NOT IN",
 /* 419 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 420 */ "boolean_value_expression ::= boolean_primary",
 /* 421 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 422 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 423 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 424 */ "boolean_primary ::= predicate",
 /* 425 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 426 */ "common_expression ::= expr_or_subquery",
 /* 427 */ "common_expression ::= boolean_value_expression",
 /* 428 */ "from_clause_opt ::=",
 /* 429 */ "from_clause_opt ::= FROM table_reference_list",
 /* 430 */ "table_reference_list ::= table_reference",
 /* 431 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 432 */ "table_reference ::= table_primary",
 /* 433 */ "table_reference ::= joined_table",
 /* 434 */ "table_primary ::= table_name alias_opt",
 /* 435 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 436 */ "table_primary ::= subquery alias_opt",
 /* 437 */ "table_primary ::= parenthesized_joined_table",
 /* 438 */ "alias_opt ::=",
 /* 439 */ "alias_opt ::= table_alias",
 /* 440 */ "alias_opt ::= AS table_alias",
 /* 441 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 442 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 443 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 444 */ "join_type ::=",
 /* 445 */ "join_type ::= INNER",
 /* 446 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 447 */ "set_quantifier_opt ::=",
 /* 448 */ "set_quantifier_opt ::= DISTINCT",
 /* 449 */ "set_quantifier_opt ::= ALL",
 /* 450 */ "select_list ::= select_item",
 /* 451 */ "select_list ::= select_list NK_COMMA select_item",
 /* 452 */ "select_item ::= NK_STAR",
 /* 453 */ "select_item ::= common_expression",
 /* 454 */ "select_item ::= common_expression column_alias",
 /* 455 */ "select_item ::= common_expression AS column_alias",
 /* 456 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 457 */ "where_clause_opt ::=",
 /* 458 */ "where_clause_opt ::= WHERE search_condition",
 /* 459 */ "partition_by_clause_opt ::=",
 /* 460 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 461 */ "partition_list ::= partition_item",
 /* 462 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 463 */ "partition_item ::= expr_or_subquery",
 /* 464 */ "partition_item ::= expr_or_subquery column_alias",
 /* 465 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 466 */ "twindow_clause_opt ::=",
 /* 467 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 468 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 469 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 470 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 471 */ "sliding_opt ::=",
 /* 472 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 473 */ "fill_opt ::=",
 /* 474 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 475 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 476 */ "fill_mode ::= NONE",
 /* 477 */ "fill_mode ::= PREV",
 /* 478 */ "fill_mode ::= NULL",
 /* 479 */ "fill_mode ::= LINEAR",
 /* 480 */ "fill_mode ::= NEXT",
 /* 481 */ "group_by_clause_opt ::=",
 /* 482 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 483 */ "group_by_list ::= expr_or_subquery",
 /* 484 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 485 */ "having_clause_opt ::=",
 /* 486 */ "having_clause_opt ::= HAVING search_condition",
 /* 487 */ "range_opt ::=",
 /* 488 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 489 */ "every_opt ::=",
 /* 490 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 491 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 492 */ "query_simple ::= query_specification",
 /* 493 */ "query_simple ::= union_query_expression",
 /* 494 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 495 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 496 */ "query_simple_or_subquery ::= query_simple",
 /* 497 */ "query_simple_or_subquery ::= subquery",
 /* 498 */ "query_or_subquery ::= query_expression",
 /* 499 */ "query_or_subquery ::= subquery",
 /* 500 */ "order_by_clause_opt ::=",
 /* 501 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 502 */ "slimit_clause_opt ::=",
 /* 503 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 504 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 505 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 506 */ "limit_clause_opt ::=",
 /* 507 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 508 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 509 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 510 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 511 */ "subquery ::= NK_LP subquery NK_RP",
 /* 512 */ "search_condition ::= common_expression",
 /* 513 */ "sort_specification_list ::= sort_specification",
 /* 514 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 515 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 516 */ "ordering_specification_opt ::=",
 /* 517 */ "ordering_specification_opt ::= ASC",
 /* 518 */ "ordering_specification_opt ::= DESC",
 /* 519 */ "null_ordering_opt ::=",
 /* 520 */ "null_ordering_opt ::= NULLS FIRST",
 /* 521 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 317: /* cmd */
    case 320: /* literal */
    case 331: /* db_options */
    case 333: /* alter_db_options */
    case 339: /* retention */
    case 340: /* full_table_name */
    case 343: /* table_options */
    case 347: /* alter_table_clause */
    case 348: /* alter_table_options */
    case 351: /* signed_literal */
    case 352: /* create_subtable_clause */
    case 355: /* drop_table_clause */
    case 358: /* column_def */
    case 362: /* duration_literal */
    case 363: /* rollup_func_name */
    case 365: /* col_name */
    case 366: /* db_name_cond_opt */
    case 367: /* like_pattern_opt */
    case 368: /* table_name_cond */
    case 369: /* from_db_opt */
    case 370: /* index_options */
    case 372: /* sliding_opt */
    case 373: /* sma_stream_opt */
    case 374: /* func */
    case 375: /* stream_options */
    case 377: /* query_or_subquery */
    case 380: /* explain_options */
    case 384: /* subtable_opt */
    case 385: /* expression */
    case 387: /* where_clause_opt */
    case 388: /* signed */
    case 389: /* literal_func */
    case 393: /* expr_or_subquery */
    case 394: /* subquery */
    case 395: /* pseudo_column */
    case 396: /* column_reference */
    case 397: /* function_expression */
    case 398: /* case_when_expression */
    case 403: /* star_func_para */
    case 405: /* case_when_else_opt */
    case 406: /* common_expression */
    case 407: /* when_then_expr */
    case 408: /* predicate */
    case 411: /* in_predicate_value */
    case 412: /* boolean_value_expression */
    case 413: /* boolean_primary */
    case 414: /* from_clause_opt */
    case 415: /* table_reference_list */
    case 416: /* table_reference */
    case 417: /* table_primary */
    case 418: /* joined_table */
    case 420: /* parenthesized_joined_table */
    case 422: /* search_condition */
    case 423: /* query_specification */
    case 427: /* range_opt */
    case 428: /* every_opt */
    case 429: /* fill_opt */
    case 430: /* twindow_clause_opt */
    case 432: /* having_clause_opt */
    case 433: /* select_item */
    case 435: /* partition_item */
    case 438: /* query_expression */
    case 439: /* query_simple */
    case 441: /* slimit_clause_opt */
    case 442: /* limit_clause_opt */
    case 443: /* union_query_expression */
    case 444: /* query_simple_or_subquery */
    case 446: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy778)); 
}
      break;
    case 318: /* account_options */
    case 319: /* alter_account_options */
    case 321: /* alter_account_option */
    case 334: /* speed_opt */
    case 382: /* bufsize_opt */
{
 
}
      break;
    case 322: /* user_name */
    case 325: /* priv_level */
    case 328: /* db_name */
    case 329: /* dnode_endpoint */
    case 349: /* column_name */
    case 357: /* table_name */
    case 364: /* function_name */
    case 376: /* topic_name */
    case 378: /* cgroup_name */
    case 383: /* stream_name */
    case 391: /* table_alias */
    case 392: /* column_alias */
    case 399: /* star_func */
    case 401: /* noarg_func */
    case 419: /* alias_opt */
{
 
}
      break;
    case 323: /* sysinfo_opt */
{
 
}
      break;
    case 324: /* privileges */
    case 326: /* priv_type_list */
    case 327: /* priv_type */
{
 
}
      break;
    case 330: /* not_exists_opt */
    case 332: /* exists_opt */
    case 379: /* analyze_opt */
    case 381: /* agg_func_opt */
    case 424: /* set_quantifier_opt */
{
 
}
      break;
    case 335: /* integer_list */
    case 336: /* variable_list */
    case 337: /* retention_list */
    case 341: /* column_def_list */
    case 342: /* tags_def_opt */
    case 344: /* multi_create_clause */
    case 345: /* tags_def */
    case 346: /* multi_drop_clause */
    case 353: /* specific_cols_opt */
    case 354: /* expression_list */
    case 356: /* col_name_list */
    case 359: /* duration_list */
    case 360: /* rollup_func_list */
    case 371: /* func_list */
    case 386: /* dnode_list */
    case 390: /* literal_list */
    case 400: /* star_func_para_list */
    case 402: /* other_para_list */
    case 404: /* when_then_list */
    case 425: /* select_list */
    case 426: /* partition_by_clause_opt */
    case 431: /* group_by_clause_opt */
    case 434: /* partition_list */
    case 437: /* group_by_list */
    case 440: /* order_by_clause_opt */
    case 445: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy282)); 
}
      break;
    case 338: /* alter_db_option */
    case 361: /* alter_table_option */
{
 
}
      break;
    case 350: /* type_name */
{
 
}
      break;
    case 409: /* compare_op */
    case 410: /* in_op */
{
 
}
      break;
    case 421: /* join_type */
{
 
}
      break;
    case 436: /* fill_mode */
{
 
}
      break;
    case 447: /* ordering_specification_opt */
{
 
}
      break;
    case 448: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  317,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  317,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  318,    0 }, /* (2) account_options ::= */
  {  318,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  318,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  318,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  318,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  318,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  318,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  318,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  318,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  318,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  319,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  319,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  321,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  321,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  321,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  321,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  321,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  321,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  321,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  321,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  321,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  321,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  317,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  317,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  317,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  317,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  317,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  323,    0 }, /* (29) sysinfo_opt ::= */
  {  323,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  317,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  317,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  324,   -1 }, /* (33) privileges ::= ALL */
  {  324,   -1 }, /* (34) privileges ::= priv_type_list */
  {  326,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  326,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  327,   -1 }, /* (37) priv_type ::= READ */
  {  327,   -1 }, /* (38) priv_type ::= WRITE */
  {  325,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  325,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  317,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  317,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  317,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  317,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  317,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  317,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  317,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  317,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  329,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  329,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  329,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  317,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  317,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  317,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  317,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  317,   -2 }, /* (64) cmd ::= USE db_name */
  {  317,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  317,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  317,   -4 }, /* (67) cmd ::= TRIM DATABASE db_name speed_opt */
  {  330,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  330,    0 }, /* (69) not_exists_opt ::= */
  {  332,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  332,    0 }, /* (71) exists_opt ::= */
  {  331,    0 }, /* (72) db_options ::= */
  {  331,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  331,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  331,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  331,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  331,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  331,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  331,   -3 }, /* (79) db_options ::= db_options MAXROWS NK_INTEGER */
  {  331,   -3 }, /* (80) db_options ::= db_options MINROWS NK_INTEGER */
  {  331,   -3 }, /* (81) db_options ::= db_options KEEP integer_list */
  {  331,   -3 }, /* (82) db_options ::= db_options KEEP variable_list */
  {  331,   -3 }, /* (83) db_options ::= db_options PAGES NK_INTEGER */
  {  331,   -3 }, /* (84) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  331,   -3 }, /* (85) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  331,   -3 }, /* (86) db_options ::= db_options PRECISION NK_STRING */
  {  331,   -3 }, /* (87) db_options ::= db_options REPLICA NK_INTEGER */
  {  331,   -3 }, /* (88) db_options ::= db_options STRICT NK_STRING */
  {  331,   -3 }, /* (89) db_options ::= db_options VGROUPS NK_INTEGER */
  {  331,   -3 }, /* (90) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  331,   -3 }, /* (91) db_options ::= db_options RETENTIONS retention_list */
  {  331,   -3 }, /* (92) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  331,   -3 }, /* (93) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  331,   -3 }, /* (94) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  331,   -3 }, /* (95) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  331,   -4 }, /* (96) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  331,   -3 }, /* (97) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  331,   -4 }, /* (98) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  331,   -3 }, /* (99) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  331,   -3 }, /* (100) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  331,   -3 }, /* (101) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  331,   -3 }, /* (102) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  331,   -3 }, /* (103) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  333,   -1 }, /* (104) alter_db_options ::= alter_db_option */
  {  333,   -2 }, /* (105) alter_db_options ::= alter_db_options alter_db_option */
  {  338,   -2 }, /* (106) alter_db_option ::= BUFFER NK_INTEGER */
  {  338,   -2 }, /* (107) alter_db_option ::= CACHEMODEL NK_STRING */
  {  338,   -2 }, /* (108) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  338,   -2 }, /* (109) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  338,   -2 }, /* (110) alter_db_option ::= KEEP integer_list */
  {  338,   -2 }, /* (111) alter_db_option ::= KEEP variable_list */
  {  338,   -2 }, /* (112) alter_db_option ::= PAGES NK_INTEGER */
  {  338,   -2 }, /* (113) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  338,   -2 }, /* (114) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  335,   -1 }, /* (115) integer_list ::= NK_INTEGER */
  {  335,   -3 }, /* (116) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  336,   -1 }, /* (117) variable_list ::= NK_VARIABLE */
  {  336,   -3 }, /* (118) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  337,   -1 }, /* (119) retention_list ::= retention */
  {  337,   -3 }, /* (120) retention_list ::= retention_list NK_COMMA retention */
  {  339,   -3 }, /* (121) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  334,    0 }, /* (122) speed_opt ::= */
  {  334,   -2 }, /* (123) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  317,   -9 }, /* (124) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  317,   -3 }, /* (125) cmd ::= CREATE TABLE multi_create_clause */
  {  317,   -9 }, /* (126) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  317,   -3 }, /* (127) cmd ::= DROP TABLE multi_drop_clause */
  {  317,   -4 }, /* (128) cmd ::= DROP STABLE exists_opt full_table_name */
  {  317,   -3 }, /* (129) cmd ::= ALTER TABLE alter_table_clause */
  {  317,   -3 }, /* (130) cmd ::= ALTER STABLE alter_table_clause */
  {  347,   -2 }, /* (131) alter_table_clause ::= full_table_name alter_table_options */
  {  347,   -5 }, /* (132) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  347,   -4 }, /* (133) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  347,   -5 }, /* (134) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  347,   -5 }, /* (135) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  347,   -5 }, /* (136) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  347,   -4 }, /* (137) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  347,   -5 }, /* (138) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  347,   -5 }, /* (139) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  347,   -6 }, /* (140) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  344,   -1 }, /* (141) multi_create_clause ::= create_subtable_clause */
  {  344,   -2 }, /* (142) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  352,  -10 }, /* (143) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  346,   -1 }, /* (144) multi_drop_clause ::= drop_table_clause */
  {  346,   -2 }, /* (145) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  355,   -2 }, /* (146) drop_table_clause ::= exists_opt full_table_name */
  {  353,    0 }, /* (147) specific_cols_opt ::= */
  {  353,   -3 }, /* (148) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  340,   -1 }, /* (149) full_table_name ::= table_name */
  {  340,   -3 }, /* (150) full_table_name ::= db_name NK_DOT table_name */
  {  341,   -1 }, /* (151) column_def_list ::= column_def */
  {  341,   -3 }, /* (152) column_def_list ::= column_def_list NK_COMMA column_def */
  {  358,   -2 }, /* (153) column_def ::= column_name type_name */
  {  358,   -4 }, /* (154) column_def ::= column_name type_name COMMENT NK_STRING */
  {  350,   -1 }, /* (155) type_name ::= BOOL */
  {  350,   -1 }, /* (156) type_name ::= TINYINT */
  {  350,   -1 }, /* (157) type_name ::= SMALLINT */
  {  350,   -1 }, /* (158) type_name ::= INT */
  {  350,   -1 }, /* (159) type_name ::= INTEGER */
  {  350,   -1 }, /* (160) type_name ::= BIGINT */
  {  350,   -1 }, /* (161) type_name ::= FLOAT */
  {  350,   -1 }, /* (162) type_name ::= DOUBLE */
  {  350,   -4 }, /* (163) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  350,   -1 }, /* (164) type_name ::= TIMESTAMP */
  {  350,   -4 }, /* (165) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  350,   -2 }, /* (166) type_name ::= TINYINT UNSIGNED */
  {  350,   -2 }, /* (167) type_name ::= SMALLINT UNSIGNED */
  {  350,   -2 }, /* (168) type_name ::= INT UNSIGNED */
  {  350,   -2 }, /* (169) type_name ::= BIGINT UNSIGNED */
  {  350,   -1 }, /* (170) type_name ::= JSON */
  {  350,   -4 }, /* (171) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  350,   -1 }, /* (172) type_name ::= MEDIUMBLOB */
  {  350,   -1 }, /* (173) type_name ::= BLOB */
  {  350,   -4 }, /* (174) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  350,   -1 }, /* (175) type_name ::= DECIMAL */
  {  350,   -4 }, /* (176) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  350,   -6 }, /* (177) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  342,    0 }, /* (178) tags_def_opt ::= */
  {  342,   -1 }, /* (179) tags_def_opt ::= tags_def */
  {  345,   -4 }, /* (180) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  343,    0 }, /* (181) table_options ::= */
  {  343,   -3 }, /* (182) table_options ::= table_options COMMENT NK_STRING */
  {  343,   -3 }, /* (183) table_options ::= table_options MAX_DELAY duration_list */
  {  343,   -3 }, /* (184) table_options ::= table_options WATERMARK duration_list */
  {  343,   -5 }, /* (185) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  343,   -3 }, /* (186) table_options ::= table_options TTL NK_INTEGER */
  {  343,   -5 }, /* (187) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  348,   -1 }, /* (188) alter_table_options ::= alter_table_option */
  {  348,   -2 }, /* (189) alter_table_options ::= alter_table_options alter_table_option */
  {  361,   -2 }, /* (190) alter_table_option ::= COMMENT NK_STRING */
  {  361,   -2 }, /* (191) alter_table_option ::= TTL NK_INTEGER */
  {  359,   -1 }, /* (192) duration_list ::= duration_literal */
  {  359,   -3 }, /* (193) duration_list ::= duration_list NK_COMMA duration_literal */
  {  360,   -1 }, /* (194) rollup_func_list ::= rollup_func_name */
  {  360,   -3 }, /* (195) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  363,   -1 }, /* (196) rollup_func_name ::= function_name */
  {  363,   -1 }, /* (197) rollup_func_name ::= FIRST */
  {  363,   -1 }, /* (198) rollup_func_name ::= LAST */
  {  356,   -1 }, /* (199) col_name_list ::= col_name */
  {  356,   -3 }, /* (200) col_name_list ::= col_name_list NK_COMMA col_name */
  {  365,   -1 }, /* (201) col_name ::= column_name */
  {  317,   -2 }, /* (202) cmd ::= SHOW DNODES */
  {  317,   -2 }, /* (203) cmd ::= SHOW USERS */
  {  317,   -2 }, /* (204) cmd ::= SHOW DATABASES */
  {  317,   -4 }, /* (205) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  317,   -4 }, /* (206) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  317,   -3 }, /* (207) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  317,   -2 }, /* (208) cmd ::= SHOW MNODES */
  {  317,   -2 }, /* (209) cmd ::= SHOW QNODES */
  {  317,   -2 }, /* (210) cmd ::= SHOW FUNCTIONS */
  {  317,   -5 }, /* (211) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  317,   -2 }, /* (212) cmd ::= SHOW STREAMS */
  {  317,   -2 }, /* (213) cmd ::= SHOW ACCOUNTS */
  {  317,   -2 }, /* (214) cmd ::= SHOW APPS */
  {  317,   -2 }, /* (215) cmd ::= SHOW CONNECTIONS */
  {  317,   -2 }, /* (216) cmd ::= SHOW LICENCES */
  {  317,   -2 }, /* (217) cmd ::= SHOW GRANTS */
  {  317,   -4 }, /* (218) cmd ::= SHOW CREATE DATABASE db_name */
  {  317,   -4 }, /* (219) cmd ::= SHOW CREATE TABLE full_table_name */
  {  317,   -4 }, /* (220) cmd ::= SHOW CREATE STABLE full_table_name */
  {  317,   -2 }, /* (221) cmd ::= SHOW QUERIES */
  {  317,   -2 }, /* (222) cmd ::= SHOW SCORES */
  {  317,   -2 }, /* (223) cmd ::= SHOW TOPICS */
  {  317,   -2 }, /* (224) cmd ::= SHOW VARIABLES */
  {  317,   -3 }, /* (225) cmd ::= SHOW LOCAL VARIABLES */
  {  317,   -4 }, /* (226) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  317,   -2 }, /* (227) cmd ::= SHOW BNODES */
  {  317,   -2 }, /* (228) cmd ::= SHOW SNODES */
  {  317,   -2 }, /* (229) cmd ::= SHOW CLUSTER */
  {  317,   -2 }, /* (230) cmd ::= SHOW TRANSACTIONS */
  {  317,   -4 }, /* (231) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  317,   -2 }, /* (232) cmd ::= SHOW CONSUMERS */
  {  317,   -2 }, /* (233) cmd ::= SHOW SUBSCRIPTIONS */
  {  317,   -5 }, /* (234) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  317,   -6 }, /* (235) cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt */
  {  317,   -3 }, /* (236) cmd ::= SHOW VNODES NK_INTEGER */
  {  317,   -3 }, /* (237) cmd ::= SHOW VNODES NK_STRING */
  {  366,    0 }, /* (238) db_name_cond_opt ::= */
  {  366,   -2 }, /* (239) db_name_cond_opt ::= db_name NK_DOT */
  {  367,    0 }, /* (240) like_pattern_opt ::= */
  {  367,   -2 }, /* (241) like_pattern_opt ::= LIKE NK_STRING */
  {  368,   -1 }, /* (242) table_name_cond ::= table_name */
  {  369,    0 }, /* (243) from_db_opt ::= */
  {  369,   -2 }, /* (244) from_db_opt ::= FROM db_name */
  {  317,   -8 }, /* (245) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  317,   -4 }, /* (246) cmd ::= DROP INDEX exists_opt full_table_name */
  {  370,  -10 }, /* (247) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  370,  -12 }, /* (248) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  371,   -1 }, /* (249) func_list ::= func */
  {  371,   -3 }, /* (250) func_list ::= func_list NK_COMMA func */
  {  374,   -4 }, /* (251) func ::= function_name NK_LP expression_list NK_RP */
  {  373,    0 }, /* (252) sma_stream_opt ::= */
  {  373,   -3 }, /* (253) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  373,   -3 }, /* (254) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  317,   -6 }, /* (255) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  317,   -7 }, /* (256) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  317,   -9 }, /* (257) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  317,   -7 }, /* (258) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  317,   -9 }, /* (259) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  317,   -4 }, /* (260) cmd ::= DROP TOPIC exists_opt topic_name */
  {  317,   -7 }, /* (261) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  317,   -2 }, /* (262) cmd ::= DESC full_table_name */
  {  317,   -2 }, /* (263) cmd ::= DESCRIBE full_table_name */
  {  317,   -3 }, /* (264) cmd ::= RESET QUERY CACHE */
  {  317,   -4 }, /* (265) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  379,    0 }, /* (266) analyze_opt ::= */
  {  379,   -1 }, /* (267) analyze_opt ::= ANALYZE */
  {  380,    0 }, /* (268) explain_options ::= */
  {  380,   -3 }, /* (269) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  380,   -3 }, /* (270) explain_options ::= explain_options RATIO NK_FLOAT */
  {  317,  -10 }, /* (271) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  317,   -4 }, /* (272) cmd ::= DROP FUNCTION exists_opt function_name */
  {  381,    0 }, /* (273) agg_func_opt ::= */
  {  381,   -1 }, /* (274) agg_func_opt ::= AGGREGATE */
  {  382,    0 }, /* (275) bufsize_opt ::= */
  {  382,   -2 }, /* (276) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  317,  -11 }, /* (277) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  317,   -4 }, /* (278) cmd ::= DROP STREAM exists_opt stream_name */
  {  375,    0 }, /* (279) stream_options ::= */
  {  375,   -3 }, /* (280) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  375,   -3 }, /* (281) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  375,   -4 }, /* (282) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  375,   -3 }, /* (283) stream_options ::= stream_options WATERMARK duration_literal */
  {  375,   -4 }, /* (284) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  384,    0 }, /* (285) subtable_opt ::= */
  {  384,   -4 }, /* (286) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  317,   -3 }, /* (287) cmd ::= KILL CONNECTION NK_INTEGER */
  {  317,   -3 }, /* (288) cmd ::= KILL QUERY NK_STRING */
  {  317,   -3 }, /* (289) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  317,   -2 }, /* (290) cmd ::= BALANCE VGROUP */
  {  317,   -4 }, /* (291) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  317,   -4 }, /* (292) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  317,   -3 }, /* (293) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  386,   -2 }, /* (294) dnode_list ::= DNODE NK_INTEGER */
  {  386,   -3 }, /* (295) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  317,   -4 }, /* (296) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  317,   -1 }, /* (297) cmd ::= query_or_subquery */
  {  317,   -7 }, /* (298) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  317,   -4 }, /* (299) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  320,   -1 }, /* (300) literal ::= NK_INTEGER */
  {  320,   -1 }, /* (301) literal ::= NK_FLOAT */
  {  320,   -1 }, /* (302) literal ::= NK_STRING */
  {  320,   -1 }, /* (303) literal ::= NK_BOOL */
  {  320,   -2 }, /* (304) literal ::= TIMESTAMP NK_STRING */
  {  320,   -1 }, /* (305) literal ::= duration_literal */
  {  320,   -1 }, /* (306) literal ::= NULL */
  {  320,   -1 }, /* (307) literal ::= NK_QUESTION */
  {  362,   -1 }, /* (308) duration_literal ::= NK_VARIABLE */
  {  388,   -1 }, /* (309) signed ::= NK_INTEGER */
  {  388,   -2 }, /* (310) signed ::= NK_PLUS NK_INTEGER */
  {  388,   -2 }, /* (311) signed ::= NK_MINUS NK_INTEGER */
  {  388,   -1 }, /* (312) signed ::= NK_FLOAT */
  {  388,   -2 }, /* (313) signed ::= NK_PLUS NK_FLOAT */
  {  388,   -2 }, /* (314) signed ::= NK_MINUS NK_FLOAT */
  {  351,   -1 }, /* (315) signed_literal ::= signed */
  {  351,   -1 }, /* (316) signed_literal ::= NK_STRING */
  {  351,   -1 }, /* (317) signed_literal ::= NK_BOOL */
  {  351,   -2 }, /* (318) signed_literal ::= TIMESTAMP NK_STRING */
  {  351,   -1 }, /* (319) signed_literal ::= duration_literal */
  {  351,   -1 }, /* (320) signed_literal ::= NULL */
  {  351,   -1 }, /* (321) signed_literal ::= literal_func */
  {  351,   -1 }, /* (322) signed_literal ::= NK_QUESTION */
  {  390,   -1 }, /* (323) literal_list ::= signed_literal */
  {  390,   -3 }, /* (324) literal_list ::= literal_list NK_COMMA signed_literal */
  {  328,   -1 }, /* (325) db_name ::= NK_ID */
  {  357,   -1 }, /* (326) table_name ::= NK_ID */
  {  349,   -1 }, /* (327) column_name ::= NK_ID */
  {  364,   -1 }, /* (328) function_name ::= NK_ID */
  {  391,   -1 }, /* (329) table_alias ::= NK_ID */
  {  392,   -1 }, /* (330) column_alias ::= NK_ID */
  {  322,   -1 }, /* (331) user_name ::= NK_ID */
  {  376,   -1 }, /* (332) topic_name ::= NK_ID */
  {  383,   -1 }, /* (333) stream_name ::= NK_ID */
  {  378,   -1 }, /* (334) cgroup_name ::= NK_ID */
  {  393,   -1 }, /* (335) expr_or_subquery ::= expression */
  {  393,   -1 }, /* (336) expr_or_subquery ::= subquery */
  {  385,   -1 }, /* (337) expression ::= literal */
  {  385,   -1 }, /* (338) expression ::= pseudo_column */
  {  385,   -1 }, /* (339) expression ::= column_reference */
  {  385,   -1 }, /* (340) expression ::= function_expression */
  {  385,   -1 }, /* (341) expression ::= case_when_expression */
  {  385,   -3 }, /* (342) expression ::= NK_LP expression NK_RP */
  {  385,   -2 }, /* (343) expression ::= NK_PLUS expr_or_subquery */
  {  385,   -2 }, /* (344) expression ::= NK_MINUS expr_or_subquery */
  {  385,   -3 }, /* (345) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  385,   -3 }, /* (346) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  385,   -3 }, /* (347) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  385,   -3 }, /* (348) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  385,   -3 }, /* (349) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  385,   -3 }, /* (350) expression ::= column_reference NK_ARROW NK_STRING */
  {  385,   -3 }, /* (351) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  385,   -3 }, /* (352) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  354,   -1 }, /* (353) expression_list ::= expr_or_subquery */
  {  354,   -3 }, /* (354) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  396,   -1 }, /* (355) column_reference ::= column_name */
  {  396,   -3 }, /* (356) column_reference ::= table_name NK_DOT column_name */
  {  395,   -1 }, /* (357) pseudo_column ::= ROWTS */
  {  395,   -1 }, /* (358) pseudo_column ::= TBNAME */
  {  395,   -3 }, /* (359) pseudo_column ::= table_name NK_DOT TBNAME */
  {  395,   -1 }, /* (360) pseudo_column ::= QSTART */
  {  395,   -1 }, /* (361) pseudo_column ::= QEND */
  {  395,   -1 }, /* (362) pseudo_column ::= QDURATION */
  {  395,   -1 }, /* (363) pseudo_column ::= WSTART */
  {  395,   -1 }, /* (364) pseudo_column ::= WEND */
  {  395,   -1 }, /* (365) pseudo_column ::= WDURATION */
  {  395,   -1 }, /* (366) pseudo_column ::= IROWTS */
  {  395,   -1 }, /* (367) pseudo_column ::= QTAGS */
  {  397,   -4 }, /* (368) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  397,   -4 }, /* (369) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  397,   -6 }, /* (370) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  397,   -1 }, /* (371) function_expression ::= literal_func */
  {  389,   -3 }, /* (372) literal_func ::= noarg_func NK_LP NK_RP */
  {  389,   -1 }, /* (373) literal_func ::= NOW */
  {  401,   -1 }, /* (374) noarg_func ::= NOW */
  {  401,   -1 }, /* (375) noarg_func ::= TODAY */
  {  401,   -1 }, /* (376) noarg_func ::= TIMEZONE */
  {  401,   -1 }, /* (377) noarg_func ::= DATABASE */
  {  401,   -1 }, /* (378) noarg_func ::= CLIENT_VERSION */
  {  401,   -1 }, /* (379) noarg_func ::= SERVER_VERSION */
  {  401,   -1 }, /* (380) noarg_func ::= SERVER_STATUS */
  {  401,   -1 }, /* (381) noarg_func ::= CURRENT_USER */
  {  401,   -1 }, /* (382) noarg_func ::= USER */
  {  399,   -1 }, /* (383) star_func ::= COUNT */
  {  399,   -1 }, /* (384) star_func ::= FIRST */
  {  399,   -1 }, /* (385) star_func ::= LAST */
  {  399,   -1 }, /* (386) star_func ::= LAST_ROW */
  {  400,   -1 }, /* (387) star_func_para_list ::= NK_STAR */
  {  400,   -1 }, /* (388) star_func_para_list ::= other_para_list */
  {  402,   -1 }, /* (389) other_para_list ::= star_func_para */
  {  402,   -3 }, /* (390) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  403,   -1 }, /* (391) star_func_para ::= expr_or_subquery */
  {  403,   -3 }, /* (392) star_func_para ::= table_name NK_DOT NK_STAR */
  {  398,   -4 }, /* (393) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  398,   -5 }, /* (394) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  404,   -1 }, /* (395) when_then_list ::= when_then_expr */
  {  404,   -2 }, /* (396) when_then_list ::= when_then_list when_then_expr */
  {  407,   -4 }, /* (397) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  405,    0 }, /* (398) case_when_else_opt ::= */
  {  405,   -2 }, /* (399) case_when_else_opt ::= ELSE common_expression */
  {  408,   -3 }, /* (400) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  408,   -5 }, /* (401) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  408,   -6 }, /* (402) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  408,   -3 }, /* (403) predicate ::= expr_or_subquery IS NULL */
  {  408,   -4 }, /* (404) predicate ::= expr_or_subquery IS NOT NULL */
  {  408,   -3 }, /* (405) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  409,   -1 }, /* (406) compare_op ::= NK_LT */
  {  409,   -1 }, /* (407) compare_op ::= NK_GT */
  {  409,   -1 }, /* (408) compare_op ::= NK_LE */
  {  409,   -1 }, /* (409) compare_op ::= NK_GE */
  {  409,   -1 }, /* (410) compare_op ::= NK_NE */
  {  409,   -1 }, /* (411) compare_op ::= NK_EQ */
  {  409,   -1 }, /* (412) compare_op ::= LIKE */
  {  409,   -2 }, /* (413) compare_op ::= NOT LIKE */
  {  409,   -1 }, /* (414) compare_op ::= MATCH */
  {  409,   -1 }, /* (415) compare_op ::= NMATCH */
  {  409,   -1 }, /* (416) compare_op ::= CONTAINS */
  {  410,   -1 }, /* (417) in_op ::= IN */
  {  410,   -2 }, /* (418) in_op ::= NOT IN */
  {  411,   -3 }, /* (419) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  412,   -1 }, /* (420) boolean_value_expression ::= boolean_primary */
  {  412,   -2 }, /* (421) boolean_value_expression ::= NOT boolean_primary */
  {  412,   -3 }, /* (422) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  412,   -3 }, /* (423) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  413,   -1 }, /* (424) boolean_primary ::= predicate */
  {  413,   -3 }, /* (425) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  406,   -1 }, /* (426) common_expression ::= expr_or_subquery */
  {  406,   -1 }, /* (427) common_expression ::= boolean_value_expression */
  {  414,    0 }, /* (428) from_clause_opt ::= */
  {  414,   -2 }, /* (429) from_clause_opt ::= FROM table_reference_list */
  {  415,   -1 }, /* (430) table_reference_list ::= table_reference */
  {  415,   -3 }, /* (431) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  416,   -1 }, /* (432) table_reference ::= table_primary */
  {  416,   -1 }, /* (433) table_reference ::= joined_table */
  {  417,   -2 }, /* (434) table_primary ::= table_name alias_opt */
  {  417,   -4 }, /* (435) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  417,   -2 }, /* (436) table_primary ::= subquery alias_opt */
  {  417,   -1 }, /* (437) table_primary ::= parenthesized_joined_table */
  {  419,    0 }, /* (438) alias_opt ::= */
  {  419,   -1 }, /* (439) alias_opt ::= table_alias */
  {  419,   -2 }, /* (440) alias_opt ::= AS table_alias */
  {  420,   -3 }, /* (441) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  420,   -3 }, /* (442) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  418,   -6 }, /* (443) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  421,    0 }, /* (444) join_type ::= */
  {  421,   -1 }, /* (445) join_type ::= INNER */
  {  423,  -12 }, /* (446) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  424,    0 }, /* (447) set_quantifier_opt ::= */
  {  424,   -1 }, /* (448) set_quantifier_opt ::= DISTINCT */
  {  424,   -1 }, /* (449) set_quantifier_opt ::= ALL */
  {  425,   -1 }, /* (450) select_list ::= select_item */
  {  425,   -3 }, /* (451) select_list ::= select_list NK_COMMA select_item */
  {  433,   -1 }, /* (452) select_item ::= NK_STAR */
  {  433,   -1 }, /* (453) select_item ::= common_expression */
  {  433,   -2 }, /* (454) select_item ::= common_expression column_alias */
  {  433,   -3 }, /* (455) select_item ::= common_expression AS column_alias */
  {  433,   -3 }, /* (456) select_item ::= table_name NK_DOT NK_STAR */
  {  387,    0 }, /* (457) where_clause_opt ::= */
  {  387,   -2 }, /* (458) where_clause_opt ::= WHERE search_condition */
  {  426,    0 }, /* (459) partition_by_clause_opt ::= */
  {  426,   -3 }, /* (460) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  434,   -1 }, /* (461) partition_list ::= partition_item */
  {  434,   -3 }, /* (462) partition_list ::= partition_list NK_COMMA partition_item */
  {  435,   -1 }, /* (463) partition_item ::= expr_or_subquery */
  {  435,   -2 }, /* (464) partition_item ::= expr_or_subquery column_alias */
  {  435,   -3 }, /* (465) partition_item ::= expr_or_subquery AS column_alias */
  {  430,    0 }, /* (466) twindow_clause_opt ::= */
  {  430,   -6 }, /* (467) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  430,   -4 }, /* (468) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  430,   -6 }, /* (469) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  430,   -8 }, /* (470) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  372,    0 }, /* (471) sliding_opt ::= */
  {  372,   -4 }, /* (472) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  429,    0 }, /* (473) fill_opt ::= */
  {  429,   -4 }, /* (474) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  429,   -6 }, /* (475) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  436,   -1 }, /* (476) fill_mode ::= NONE */
  {  436,   -1 }, /* (477) fill_mode ::= PREV */
  {  436,   -1 }, /* (478) fill_mode ::= NULL */
  {  436,   -1 }, /* (479) fill_mode ::= LINEAR */
  {  436,   -1 }, /* (480) fill_mode ::= NEXT */
  {  431,    0 }, /* (481) group_by_clause_opt ::= */
  {  431,   -3 }, /* (482) group_by_clause_opt ::= GROUP BY group_by_list */
  {  437,   -1 }, /* (483) group_by_list ::= expr_or_subquery */
  {  437,   -3 }, /* (484) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  432,    0 }, /* (485) having_clause_opt ::= */
  {  432,   -2 }, /* (486) having_clause_opt ::= HAVING search_condition */
  {  427,    0 }, /* (487) range_opt ::= */
  {  427,   -6 }, /* (488) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  428,    0 }, /* (489) every_opt ::= */
  {  428,   -4 }, /* (490) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  438,   -4 }, /* (491) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  439,   -1 }, /* (492) query_simple ::= query_specification */
  {  439,   -1 }, /* (493) query_simple ::= union_query_expression */
  {  443,   -4 }, /* (494) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  443,   -3 }, /* (495) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  444,   -1 }, /* (496) query_simple_or_subquery ::= query_simple */
  {  444,   -1 }, /* (497) query_simple_or_subquery ::= subquery */
  {  377,   -1 }, /* (498) query_or_subquery ::= query_expression */
  {  377,   -1 }, /* (499) query_or_subquery ::= subquery */
  {  440,    0 }, /* (500) order_by_clause_opt ::= */
  {  440,   -3 }, /* (501) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  441,    0 }, /* (502) slimit_clause_opt ::= */
  {  441,   -2 }, /* (503) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  441,   -4 }, /* (504) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  441,   -4 }, /* (505) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  442,    0 }, /* (506) limit_clause_opt ::= */
  {  442,   -2 }, /* (507) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  442,   -4 }, /* (508) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  442,   -4 }, /* (509) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  394,   -3 }, /* (510) subquery ::= NK_LP query_expression NK_RP */
  {  394,   -3 }, /* (511) subquery ::= NK_LP subquery NK_RP */
  {  422,   -1 }, /* (512) search_condition ::= common_expression */
  {  445,   -1 }, /* (513) sort_specification_list ::= sort_specification */
  {  445,   -3 }, /* (514) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  446,   -3 }, /* (515) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  447,    0 }, /* (516) ordering_specification_opt ::= */
  {  447,   -1 }, /* (517) ordering_specification_opt ::= ASC */
  {  447,   -1 }, /* (518) ordering_specification_opt ::= DESC */
  {  448,    0 }, /* (519) null_ordering_opt ::= */
  {  448,   -2 }, /* (520) null_ordering_opt ::= NULLS FIRST */
  {  448,   -2 }, /* (521) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,318,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,319,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,318,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,320,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,321,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,319,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,321,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,320,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy181, &yymsp[-1].minor.yy0, yymsp[0].minor.yy293); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy181, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy181, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy181, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy293 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy293 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy831, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy831, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy831 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy831 = yymsp[0].minor.yy831; }
  yymsp[0].minor.yy831 = yylhsminor.yy831;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy831 = yymsp[-2].minor.yy831 | yymsp[0].minor.yy831; }
  yymsp[-2].minor.yy831 = yylhsminor.yy831;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy831 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy831 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy181 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy181 = yylhsminor.yy181;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy181 = yymsp[-2].minor.yy181; }
  yymsp[-2].minor.yy181 = yylhsminor.yy181;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy181, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 325: /* db_name ::= NK_ID */ yytestcase(yyruleno==325);
      case 326: /* table_name ::= NK_ID */ yytestcase(yyruleno==326);
      case 327: /* column_name ::= NK_ID */ yytestcase(yyruleno==327);
      case 328: /* function_name ::= NK_ID */ yytestcase(yyruleno==328);
      case 329: /* table_alias ::= NK_ID */ yytestcase(yyruleno==329);
      case 330: /* column_alias ::= NK_ID */ yytestcase(yyruleno==330);
      case 331: /* user_name ::= NK_ID */ yytestcase(yyruleno==331);
      case 332: /* topic_name ::= NK_ID */ yytestcase(yyruleno==332);
      case 333: /* stream_name ::= NK_ID */ yytestcase(yyruleno==333);
      case 334: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==334);
      case 374: /* noarg_func ::= NOW */ yytestcase(yyruleno==374);
      case 375: /* noarg_func ::= TODAY */ yytestcase(yyruleno==375);
      case 376: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==376);
      case 377: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==377);
      case 378: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==378);
      case 379: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==379);
      case 380: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==380);
      case 381: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==381);
      case 382: /* noarg_func ::= USER */ yytestcase(yyruleno==382);
      case 383: /* star_func ::= COUNT */ yytestcase(yyruleno==383);
      case 384: /* star_func ::= FIRST */ yytestcase(yyruleno==384);
      case 385: /* star_func ::= LAST */ yytestcase(yyruleno==385);
      case 386: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==386);
{ yylhsminor.yy181 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy181 = yylhsminor.yy181;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy39, &yymsp[-1].minor.yy181, yymsp[0].minor.yy778); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy181, yymsp[0].minor.yy778); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy181, yymsp[0].minor.yy276); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy39 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 266: /* analyze_opt ::= */ yytestcase(yyruleno==266);
      case 273: /* agg_func_opt ::= */ yytestcase(yyruleno==273);
      case 447: /* set_quantifier_opt ::= */ yytestcase(yyruleno==447);
{ yymsp[1].minor.yy39 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy39 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy778 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 79: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 80: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 81: /* db_options ::= db_options KEEP integer_list */
      case 82: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==82);
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_KEEP, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 83: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 84: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 85: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 86: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 87: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 88: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 89: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 90: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 91: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_RETENTIONS, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 92: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 93: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 94: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 95: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 96: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-3].minor.yy778, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-3].minor.yy778, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 99: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 100: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 101: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 102: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 103: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 104: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy778 = createAlterDatabaseOptions(pCxt); yylhsminor.yy778 = setAlterDatabaseOption(pCxt, yylhsminor.yy778, &yymsp[0].minor.yy645); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 105: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy778 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy778, &yymsp[0].minor.yy645); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 106: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 107: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy645.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 108: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 109: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= KEEP integer_list */
      case 111: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==111);
{ yymsp[-1].minor.yy645.type = DB_OPTION_KEEP; yymsp[-1].minor.yy645.pList = yymsp[0].minor.yy282; }
        break;
      case 112: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_PAGES; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_WAL; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 115: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy282 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 116: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 295: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==295);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 117: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy282 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 118: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 119: /* retention_list ::= retention */
      case 141: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==141);
      case 144: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==144);
      case 151: /* column_def_list ::= column_def */ yytestcase(yyruleno==151);
      case 194: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==194);
      case 199: /* col_name_list ::= col_name */ yytestcase(yyruleno==199);
      case 249: /* func_list ::= func */ yytestcase(yyruleno==249);
      case 323: /* literal_list ::= signed_literal */ yytestcase(yyruleno==323);
      case 389: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==389);
      case 395: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==395);
      case 450: /* select_list ::= select_item */ yytestcase(yyruleno==450);
      case 461: /* partition_list ::= partition_item */ yytestcase(yyruleno==461);
      case 513: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==513);
{ yylhsminor.yy282 = createNodeList(pCxt, yymsp[0].minor.yy778); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 120: /* retention_list ::= retention_list NK_COMMA retention */
      case 152: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==152);
      case 195: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==195);
      case 200: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==200);
      case 250: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==250);
      case 324: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==324);
      case 390: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==390);
      case 451: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==451);
      case 462: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==462);
      case 514: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==514);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, yymsp[0].minor.yy778); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 121: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy778 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 122: /* speed_opt ::= */
      case 275: /* bufsize_opt ::= */ yytestcase(yyruleno==275);
{ yymsp[1].minor.yy276 = 0; }
        break;
      case 123: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 276: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==276);
{ yymsp[-1].minor.yy276 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 124: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 126: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==126);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy39, yymsp[-5].minor.yy778, yymsp[-3].minor.yy282, yymsp[-1].minor.yy282, yymsp[0].minor.yy778); }
        break;
      case 125: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy282); }
        break;
      case 127: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy282); }
        break;
      case 128: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy39, yymsp[0].minor.yy778); }
        break;
      case 129: /* cmd ::= ALTER TABLE alter_table_clause */
      case 297: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==297);
{ pCxt->pRootNode = yymsp[0].minor.yy778; }
        break;
      case 130: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy778); }
        break;
      case 131: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy778 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 132: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 133: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy778 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy778, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy181); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 134: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 135: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy778 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy778 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy778, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy181); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy778 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 140: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy778 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy778, &yymsp[-2].minor.yy181, yymsp[0].minor.yy778); }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 142: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 145: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==145);
      case 396: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==396);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-1].minor.yy282, yymsp[0].minor.yy778); }
  yymsp[-1].minor.yy282 = yylhsminor.yy282;
        break;
      case 143: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy778 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy39, yymsp[-8].minor.yy778, yymsp[-6].minor.yy778, yymsp[-5].minor.yy282, yymsp[-2].minor.yy282, yymsp[0].minor.yy778); }
  yymsp[-9].minor.yy778 = yylhsminor.yy778;
        break;
      case 146: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy778 = createDropTableClause(pCxt, yymsp[-1].minor.yy39, yymsp[0].minor.yy778); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 147: /* specific_cols_opt ::= */
      case 178: /* tags_def_opt ::= */ yytestcase(yyruleno==178);
      case 459: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==459);
      case 481: /* group_by_clause_opt ::= */ yytestcase(yyruleno==481);
      case 500: /* order_by_clause_opt ::= */ yytestcase(yyruleno==500);
{ yymsp[1].minor.yy282 = NULL; }
        break;
      case 148: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy282 = yymsp[-1].minor.yy282; }
        break;
      case 149: /* full_table_name ::= table_name */
{ yylhsminor.yy778 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy181, NULL); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 150: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy778 = createRealTableNode(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181, NULL); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 153: /* column_def ::= column_name type_name */
{ yylhsminor.yy778 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380, NULL); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 154: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy778 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy181, yymsp[-2].minor.yy380, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 155: /* type_name ::= BOOL */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 156: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 157: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 158: /* type_name ::= INT */
      case 159: /* type_name ::= INTEGER */ yytestcase(yyruleno==159);
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 160: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 161: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 162: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 163: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 164: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 165: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 166: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 167: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 168: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 169: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 170: /* type_name ::= JSON */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 171: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 172: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 173: /* type_name ::= BLOB */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 174: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 175: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 176: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 177: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy380 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 179: /* tags_def_opt ::= tags_def */
      case 388: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==388);
{ yylhsminor.yy282 = yymsp[0].minor.yy282; }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 180: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy282 = yymsp[-1].minor.yy282; }
        break;
      case 181: /* table_options ::= */
{ yymsp[1].minor.yy778 = createDefaultTableOptions(pCxt); }
        break;
      case 182: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 183: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 184: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 185: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-4].minor.yy778, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy282); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 186: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 187: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-4].minor.yy778, TABLE_OPTION_SMA, yymsp[-1].minor.yy282); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 188: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy778 = createAlterTableOptions(pCxt); yylhsminor.yy778 = setTableOption(pCxt, yylhsminor.yy778, yymsp[0].minor.yy645.type, &yymsp[0].minor.yy645.val); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 189: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-1].minor.yy778, yymsp[0].minor.yy645.type, &yymsp[0].minor.yy645.val); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 190: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy645.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 191: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy645.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 192: /* duration_list ::= duration_literal */
      case 353: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==353);
{ yylhsminor.yy282 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy778)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 193: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 354: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==354);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, releaseRawExprNode(pCxt, yymsp[0].minor.yy778)); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 196: /* rollup_func_name ::= function_name */
{ yylhsminor.yy778 = createFunctionNode(pCxt, &yymsp[0].minor.yy181, NULL); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 197: /* rollup_func_name ::= FIRST */
      case 198: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==198);
{ yylhsminor.yy778 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 201: /* col_name ::= column_name */
{ yylhsminor.yy778 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy181); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 202: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 203: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 204: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 205: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy778, yymsp[0].minor.yy778, OP_TYPE_LIKE); }
        break;
      case 206: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy778, yymsp[0].minor.yy778, OP_TYPE_LIKE); }
        break;
      case 207: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy778, NULL, OP_TYPE_LIKE); }
        break;
      case 208: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 209: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 210: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 211: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy778, yymsp[-1].minor.yy778, OP_TYPE_EQUAL); }
        break;
      case 212: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 213: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 214: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 215: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 216: /* cmd ::= SHOW LICENCES */
      case 217: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==217);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 218: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 219: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy778); }
        break;
      case 220: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy778); }
        break;
      case 221: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 222: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 223: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 224: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 225: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 226: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 227: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 228: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 229: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 230: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 231: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy778); }
        break;
      case 232: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 233: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 234: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy778, yymsp[-1].minor.yy778, OP_TYPE_EQUAL); }
        break;
      case 235: /* cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLE_TAGS_STMT, yymsp[0].minor.yy778, yymsp[-1].minor.yy778, OP_TYPE_EQUAL); }
        break;
      case 236: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 237: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 238: /* db_name_cond_opt ::= */
      case 243: /* from_db_opt ::= */ yytestcase(yyruleno==243);
{ yymsp[1].minor.yy778 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 239: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy778 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 240: /* like_pattern_opt ::= */
      case 285: /* subtable_opt ::= */ yytestcase(yyruleno==285);
      case 398: /* case_when_else_opt ::= */ yytestcase(yyruleno==398);
      case 428: /* from_clause_opt ::= */ yytestcase(yyruleno==428);
      case 457: /* where_clause_opt ::= */ yytestcase(yyruleno==457);
      case 466: /* twindow_clause_opt ::= */ yytestcase(yyruleno==466);
      case 471: /* sliding_opt ::= */ yytestcase(yyruleno==471);
      case 473: /* fill_opt ::= */ yytestcase(yyruleno==473);
      case 485: /* having_clause_opt ::= */ yytestcase(yyruleno==485);
      case 487: /* range_opt ::= */ yytestcase(yyruleno==487);
      case 489: /* every_opt ::= */ yytestcase(yyruleno==489);
      case 502: /* slimit_clause_opt ::= */ yytestcase(yyruleno==502);
      case 506: /* limit_clause_opt ::= */ yytestcase(yyruleno==506);
{ yymsp[1].minor.yy778 = NULL; }
        break;
      case 241: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 242: /* table_name_cond ::= table_name */
{ yylhsminor.yy778 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy181); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 244: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy778 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 245: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy39, yymsp[-3].minor.yy778, yymsp[-1].minor.yy778, NULL, yymsp[0].minor.yy778); }
        break;
      case 246: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy39, yymsp[0].minor.yy778); }
        break;
      case 247: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy778 = createIndexOption(pCxt, yymsp[-7].minor.yy282, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), NULL, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 248: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy778 = createIndexOption(pCxt, yymsp[-9].minor.yy282, releaseRawExprNode(pCxt, yymsp[-5].minor.yy778), releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 251: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy778 = createFunctionNode(pCxt, &yymsp[-3].minor.yy181, yymsp[-1].minor.yy282); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 252: /* sma_stream_opt ::= */
      case 279: /* stream_options ::= */ yytestcase(yyruleno==279);
{ yymsp[1].minor.yy778 = createStreamOptions(pCxt); }
        break;
      case 253: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 283: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==283);
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 254: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 255: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy39, &yymsp[-2].minor.yy181, yymsp[0].minor.yy778); }
        break;
      case 256: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy39, &yymsp[-3].minor.yy181, &yymsp[0].minor.yy181, false); }
        break;
      case 257: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy39, &yymsp[-5].minor.yy181, &yymsp[0].minor.yy181, true); }
        break;
      case 258: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy39, &yymsp[-3].minor.yy181, yymsp[0].minor.yy778, false); }
        break;
      case 259: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy39, &yymsp[-5].minor.yy181, yymsp[0].minor.yy778, true); }
        break;
      case 260: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 261: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy39, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181); }
        break;
      case 262: /* cmd ::= DESC full_table_name */
      case 263: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==263);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy778); }
        break;
      case 264: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 265: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy39, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 267: /* analyze_opt ::= ANALYZE */
      case 274: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==274);
      case 448: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==448);
{ yymsp[0].minor.yy39 = true; }
        break;
      case 268: /* explain_options ::= */
{ yymsp[1].minor.yy778 = createDefaultExplainOptions(pCxt); }
        break;
      case 269: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy778 = setExplainVerbose(pCxt, yymsp[-2].minor.yy778, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 270: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy778 = setExplainRatio(pCxt, yymsp[-2].minor.yy778, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 271: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy39, yymsp[-8].minor.yy39, &yymsp[-5].minor.yy181, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy380, yymsp[0].minor.yy276); }
        break;
      case 272: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 277: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy39, &yymsp[-7].minor.yy181, yymsp[-4].minor.yy778, yymsp[-6].minor.yy778, yymsp[-3].minor.yy282, yymsp[-2].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 278: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 280: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 281: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 282: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy778)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy778)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); yylhsminor.yy778 = yymsp[-3].minor.yy778; }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 284: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy778)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy778 = yymsp[-3].minor.yy778; }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 286: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 472: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==472);
      case 490: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==490);
{ yymsp[-3].minor.yy778 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy778); }
        break;
      case 287: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 288: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 289: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 290: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 291: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 292: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy282); }
        break;
      case 293: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 294: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy282 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 296: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 298: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy778, yymsp[-2].minor.yy282, yymsp[0].minor.yy778); }
        break;
      case 299: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy778, NULL, yymsp[0].minor.yy778); }
        break;
      case 300: /* literal ::= NK_INTEGER */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 301: /* literal ::= NK_FLOAT */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 302: /* literal ::= NK_STRING */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 303: /* literal ::= NK_BOOL */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 304: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 305: /* literal ::= duration_literal */
      case 315: /* signed_literal ::= signed */ yytestcase(yyruleno==315);
      case 335: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==335);
      case 336: /* expr_or_subquery ::= subquery */ yytestcase(yyruleno==336);
      case 337: /* expression ::= literal */ yytestcase(yyruleno==337);
      case 338: /* expression ::= pseudo_column */ yytestcase(yyruleno==338);
      case 339: /* expression ::= column_reference */ yytestcase(yyruleno==339);
      case 340: /* expression ::= function_expression */ yytestcase(yyruleno==340);
      case 341: /* expression ::= case_when_expression */ yytestcase(yyruleno==341);
      case 371: /* function_expression ::= literal_func */ yytestcase(yyruleno==371);
      case 420: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==420);
      case 424: /* boolean_primary ::= predicate */ yytestcase(yyruleno==424);
      case 426: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==426);
      case 427: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==427);
      case 430: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==430);
      case 432: /* table_reference ::= table_primary */ yytestcase(yyruleno==432);
      case 433: /* table_reference ::= joined_table */ yytestcase(yyruleno==433);
      case 437: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==437);
      case 492: /* query_simple ::= query_specification */ yytestcase(yyruleno==492);
      case 493: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==493);
      case 496: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==496);
      case 498: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==498);
{ yylhsminor.yy778 = yymsp[0].minor.yy778; }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 306: /* literal ::= NULL */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 307: /* literal ::= NK_QUESTION */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 308: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 309: /* signed ::= NK_INTEGER */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 310: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 311: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 312: /* signed ::= NK_FLOAT */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 313: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 314: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 316: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 317: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 318: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 319: /* signed_literal ::= duration_literal */
      case 321: /* signed_literal ::= literal_func */ yytestcase(yyruleno==321);
      case 391: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==391);
      case 453: /* select_item ::= common_expression */ yytestcase(yyruleno==453);
      case 463: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==463);
      case 497: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==497);
      case 499: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==499);
      case 512: /* search_condition ::= common_expression */ yytestcase(yyruleno==512);
{ yylhsminor.yy778 = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 320: /* signed_literal ::= NULL */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 322: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy778 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 342: /* expression ::= NK_LP expression NK_RP */
      case 425: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==425);
      case 511: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==511);
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 343: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy778));
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 344: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy778), NULL));
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 345: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 346: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 347: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 348: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 349: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 350: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 351: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 352: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 355: /* column_reference ::= column_name */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy181, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy181)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 356: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181, createColumnNode(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 357: /* pseudo_column ::= ROWTS */
      case 358: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==358);
      case 360: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==360);
      case 361: /* pseudo_column ::= QEND */ yytestcase(yyruleno==361);
      case 362: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==362);
      case 363: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==363);
      case 364: /* pseudo_column ::= WEND */ yytestcase(yyruleno==364);
      case 365: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==365);
      case 366: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==366);
      case 367: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==367);
      case 373: /* literal_func ::= NOW */ yytestcase(yyruleno==373);
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 359: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy181)))); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 368: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 369: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==369);
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy181, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy181, yymsp[-1].minor.yy282)); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 370: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-1].minor.yy380)); }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 372: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy181, NULL)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 387: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy282 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 392: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 456: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==456);
{ yylhsminor.yy778 = createColumnNode(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 393: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy282, yymsp[-1].minor.yy778)); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 394: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-2].minor.yy282, yymsp[-1].minor.yy778)); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 397: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy778 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)); }
        break;
      case 399: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy778 = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); }
        break;
      case 400: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 405: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==405);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy682, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 401: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy778), releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 402: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy778), releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 403: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), NULL));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 404: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), NULL));
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 406: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy682 = OP_TYPE_LOWER_THAN; }
        break;
      case 407: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy682 = OP_TYPE_GREATER_THAN; }
        break;
      case 408: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy682 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 409: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy682 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 410: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy682 = OP_TYPE_NOT_EQUAL; }
        break;
      case 411: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy682 = OP_TYPE_EQUAL; }
        break;
      case 412: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy682 = OP_TYPE_LIKE; }
        break;
      case 413: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy682 = OP_TYPE_NOT_LIKE; }
        break;
      case 414: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy682 = OP_TYPE_MATCH; }
        break;
      case 415: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy682 = OP_TYPE_NMATCH; }
        break;
      case 416: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy682 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 417: /* in_op ::= IN */
{ yymsp[0].minor.yy682 = OP_TYPE_IN; }
        break;
      case 418: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy682 = OP_TYPE_NOT_IN; }
        break;
      case 419: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy282)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 421: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy778), NULL));
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 422: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 423: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 429: /* from_clause_opt ::= FROM table_reference_list */
      case 458: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==458);
      case 486: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==486);
{ yymsp[-1].minor.yy778 = yymsp[0].minor.yy778; }
        break;
      case 431: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy778 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy778, yymsp[0].minor.yy778, NULL); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 434: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy778 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 435: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy778 = createRealTableNode(pCxt, &yymsp[-3].minor.yy181, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 436: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy778 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778), &yymsp[0].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 438: /* alias_opt ::= */
{ yymsp[1].minor.yy181 = nil_token;  }
        break;
      case 439: /* alias_opt ::= table_alias */
{ yylhsminor.yy181 = yymsp[0].minor.yy181; }
  yymsp[0].minor.yy181 = yylhsminor.yy181;
        break;
      case 440: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy181 = yymsp[0].minor.yy181; }
        break;
      case 441: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 442: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==442);
{ yymsp[-2].minor.yy778 = yymsp[-1].minor.yy778; }
        break;
      case 443: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy778 = createJoinTableNode(pCxt, yymsp[-4].minor.yy202, yymsp[-5].minor.yy778, yymsp[-2].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 444: /* join_type ::= */
{ yymsp[1].minor.yy202 = JOIN_TYPE_INNER; }
        break;
      case 445: /* join_type ::= INNER */
{ yymsp[0].minor.yy202 = JOIN_TYPE_INNER; }
        break;
      case 446: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy778 = createSelectStmt(pCxt, yymsp[-10].minor.yy39, yymsp[-9].minor.yy282, yymsp[-8].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addWhereClause(pCxt, yymsp[-11].minor.yy778, yymsp[-7].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addPartitionByClause(pCxt, yymsp[-11].minor.yy778, yymsp[-6].minor.yy282);
                                                                                    yymsp[-11].minor.yy778 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy778, yymsp[-2].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addGroupByClause(pCxt, yymsp[-11].minor.yy778, yymsp[-1].minor.yy282);
                                                                                    yymsp[-11].minor.yy778 = addHavingClause(pCxt, yymsp[-11].minor.yy778, yymsp[0].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addRangeClause(pCxt, yymsp[-11].minor.yy778, yymsp[-5].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addEveryClause(pCxt, yymsp[-11].minor.yy778, yymsp[-4].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addFillClause(pCxt, yymsp[-11].minor.yy778, yymsp[-3].minor.yy778);
                                                                                  }
        break;
      case 449: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy39 = false; }
        break;
      case 452: /* select_item ::= NK_STAR */
{ yylhsminor.yy778 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 454: /* select_item ::= common_expression column_alias */
      case 464: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==464);
{ yylhsminor.yy778 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778), &yymsp[0].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 455: /* select_item ::= common_expression AS column_alias */
      case 465: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==465);
{ yylhsminor.yy778 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), &yymsp[0].minor.yy181); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 460: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 482: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==482);
      case 501: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==501);
{ yymsp[-2].minor.yy282 = yymsp[0].minor.yy282; }
        break;
      case 467: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy778 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
        break;
      case 468: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy778 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
        break;
      case 469: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy778 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), NULL, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 470: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy778 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy778), releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 474: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy778 = createFillNode(pCxt, yymsp[-1].minor.yy381, NULL); }
        break;
      case 475: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy778 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy282)); }
        break;
      case 476: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy381 = FILL_MODE_NONE; }
        break;
      case 477: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy381 = FILL_MODE_PREV; }
        break;
      case 478: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy381 = FILL_MODE_NULL; }
        break;
      case 479: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy381 = FILL_MODE_LINEAR; }
        break;
      case 480: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy381 = FILL_MODE_NEXT; }
        break;
      case 483: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy282 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 484: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 488: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy778 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
        break;
      case 491: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy778 = addOrderByClause(pCxt, yymsp[-3].minor.yy778, yymsp[-2].minor.yy282);
                                                                                    yylhsminor.yy778 = addSlimitClause(pCxt, yylhsminor.yy778, yymsp[-1].minor.yy778);
                                                                                    yylhsminor.yy778 = addLimitClause(pCxt, yylhsminor.yy778, yymsp[0].minor.yy778);
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 494: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy778 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 495: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy778 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 503: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 507: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==507);
{ yymsp[-1].minor.yy778 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 504: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 508: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==508);
{ yymsp[-3].minor.yy778 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 505: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 509: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==509);
{ yymsp[-3].minor.yy778 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 510: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy778); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 515: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy778 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), yymsp[-1].minor.yy14, yymsp[0].minor.yy305); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 516: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy14 = ORDER_ASC; }
        break;
      case 517: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy14 = ORDER_ASC; }
        break;
      case 518: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy14 = ORDER_DESC; }
        break;
      case 519: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy305 = NULL_ORDER_DEFAULT; }
        break;
      case 520: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy305 = NULL_ORDER_FIRST; }
        break;
      case 521: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy305 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
